//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armmigrationdiscoverysap_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/migrationdiscovery/armmigrationdiscoverysap"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/475747ff6322e9bf180b8911d871561b264379c3/specification/workloads/resource-manager/Microsoft.Workloads/SAPDiscoverySites/preview/2023-10-01-preview/examples/SAPDiscoverySites_ListBySubscription.json
func ExampleSapDiscoverySitesClient_NewListBySubscriptionPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmigrationdiscoverysap.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewSapDiscoverySitesClient().NewListBySubscriptionPager(nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.SAPDiscoverySiteListResult = armmigrationdiscoverysap.SAPDiscoverySiteListResult{
		// 	Value: []*armmigrationdiscoverysap.SAPDiscoverySite{
		// 		{
		// 			Name: to.Ptr("SampleSite"),
		// 			Type: to.Ptr("microsoft.workloads/sapDiscoverySites"),
		// 			ID: to.Ptr("/subscriptions/6d875e77-e412-4d7d-9af4-8895278b4443/resourceGroups/test-rg/providers/Microsoft.Workloads/sapDiscoverySites/SampleSite"),
		// 			SystemData: &armmigrationdiscoverysap.SystemData{
		// 				CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-06-26T14:15:22.000Z"); return t}()),
		// 				CreatedBy: to.Ptr("UserName"),
		// 				CreatedByType: to.Ptr(armmigrationdiscoverysap.CreatedByTypeUser),
		// 				LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-06-26T14:15:22.000Z"); return t}()),
		// 				LastModifiedBy: to.Ptr("UserName"),
		// 				LastModifiedByType: to.Ptr(armmigrationdiscoverysap.CreatedByTypeUser),
		// 			},
		// 			Location: to.Ptr("eastus"),
		// 			Tags: map[string]*string{
		// 				"property1": to.Ptr("value1"),
		// 				"property2": to.Ptr("value2"),
		// 			},
		// 			Properties: &armmigrationdiscoverysap.SAPDiscoverySiteProperties{
		// 				Errors: &armmigrationdiscoverysap.SAPMigrateError{
		// 					Properties: &armmigrationdiscoverysap.ErrorDefinition{
		// 						Code: to.Ptr("ErrorCode1"),
		// 						Message: to.Ptr("This would be an elaborate error message"),
		// 						Details: []*armmigrationdiscoverysap.ErrorDefinition{
		// 							{
		// 								Code: to.Ptr("ErrorCode2"),
		// 								Message: to.Ptr("This would be an elaborate error message"),
		// 						}},
		// 					},
		// 				},
		// 				MasterSiteID: to.Ptr("MasterSiteIdResourceId"),
		// 				MigrateProjectID: to.Ptr("MigrateProjectId"),
		// 				ProvisioningState: to.Ptr(armmigrationdiscoverysap.ProvisioningStateSucceeded),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("SampleSite1"),
		// 			Type: to.Ptr("microsoft.workloads/sapDiscoverySites"),
		// 			ID: to.Ptr("/subscriptions/6d875e77-e412-4d7d-9af4-8895278b4443/resourceGroups/test-rg/providers/Microsoft.Workloads/sapDiscoverySites/SampleSite1"),
		// 			SystemData: &armmigrationdiscoverysap.SystemData{
		// 				CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-06-26T14:15:22.000Z"); return t}()),
		// 				CreatedBy: to.Ptr("UserName"),
		// 				CreatedByType: to.Ptr(armmigrationdiscoverysap.CreatedByTypeUser),
		// 				LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-06-26T14:15:22.000Z"); return t}()),
		// 				LastModifiedBy: to.Ptr("UserName"),
		// 				LastModifiedByType: to.Ptr(armmigrationdiscoverysap.CreatedByTypeUser),
		// 			},
		// 			Location: to.Ptr("eastus"),
		// 			Tags: map[string]*string{
		// 				"property1": to.Ptr("value1"),
		// 				"property2": to.Ptr("value2"),
		// 			},
		// 			Properties: &armmigrationdiscoverysap.SAPDiscoverySiteProperties{
		// 				Errors: &armmigrationdiscoverysap.SAPMigrateError{
		// 					Properties: &armmigrationdiscoverysap.ErrorDefinition{
		// 						Code: to.Ptr("ErrorCode1"),
		// 						Message: to.Ptr("This would be an elaborate error message"),
		// 						Details: []*armmigrationdiscoverysap.ErrorDefinition{
		// 							{
		// 								Code: to.Ptr("ErrorCode2"),
		// 								Message: to.Ptr("This would be an elaborate error message"),
		// 						}},
		// 					},
		// 				},
		// 				MasterSiteID: to.Ptr("MasterSiteIdResourceId1"),
		// 				MigrateProjectID: to.Ptr("MigrateProjectId1"),
		// 				ProvisioningState: to.Ptr(armmigrationdiscoverysap.ProvisioningStateSucceeded),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/475747ff6322e9bf180b8911d871561b264379c3/specification/workloads/resource-manager/Microsoft.Workloads/SAPDiscoverySites/preview/2023-10-01-preview/examples/SAPDiscoverySites_ListByResourceGroup.json
func ExampleSapDiscoverySitesClient_NewListByResourceGroupPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmigrationdiscoverysap.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewSapDiscoverySitesClient().NewListByResourceGroupPager("test-rg", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.SAPDiscoverySiteListResult = armmigrationdiscoverysap.SAPDiscoverySiteListResult{
		// 	Value: []*armmigrationdiscoverysap.SAPDiscoverySite{
		// 		{
		// 			Name: to.Ptr("SampleSite"),
		// 			Type: to.Ptr("microsoft.workloads/sapDiscoverySites"),
		// 			ID: to.Ptr("/subscriptions/6d875e77-e412-4d7d-9af4-8895278b4443/resourceGroups/test-rg/providers/Microsoft.Workloads/sapDiscoverySites/SampleSite"),
		// 			SystemData: &armmigrationdiscoverysap.SystemData{
		// 				CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-06-26T14:15:22.000Z"); return t}()),
		// 				CreatedBy: to.Ptr("UserName"),
		// 				CreatedByType: to.Ptr(armmigrationdiscoverysap.CreatedByTypeUser),
		// 				LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-06-26T14:15:22.000Z"); return t}()),
		// 				LastModifiedBy: to.Ptr("UserName"),
		// 				LastModifiedByType: to.Ptr(armmigrationdiscoverysap.CreatedByTypeUser),
		// 			},
		// 			Location: to.Ptr("eastus"),
		// 			Tags: map[string]*string{
		// 				"property1": to.Ptr("value1"),
		// 				"property2": to.Ptr("value2"),
		// 			},
		// 			Properties: &armmigrationdiscoverysap.SAPDiscoverySiteProperties{
		// 				Errors: &armmigrationdiscoverysap.SAPMigrateError{
		// 					Properties: &armmigrationdiscoverysap.ErrorDefinition{
		// 						Code: to.Ptr("ErrorCode1"),
		// 						Message: to.Ptr("This would be an elaborate error message"),
		// 						Details: []*armmigrationdiscoverysap.ErrorDefinition{
		// 							{
		// 								Code: to.Ptr("ErrorCode2"),
		// 								Message: to.Ptr("This would be an elaborate error message"),
		// 						}},
		// 					},
		// 				},
		// 				MasterSiteID: to.Ptr("MasterSiteIdResourceId"),
		// 				MigrateProjectID: to.Ptr("MigrateProjectId"),
		// 				ProvisioningState: to.Ptr(armmigrationdiscoverysap.ProvisioningStateSucceeded),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("SampleSite1"),
		// 			Type: to.Ptr("microsoft.workloads/sapDiscoverySites"),
		// 			ID: to.Ptr("/subscriptions/6d875e77-e412-4d7d-9af4-8895278b4443/resourceGroups/test-rg/providers/Microsoft.Workloads/sapDiscoverySites/SampleSite1"),
		// 			SystemData: &armmigrationdiscoverysap.SystemData{
		// 				CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-06-26T14:15:22.000Z"); return t}()),
		// 				CreatedBy: to.Ptr("UserName"),
		// 				CreatedByType: to.Ptr(armmigrationdiscoverysap.CreatedByTypeUser),
		// 				LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-06-26T14:15:22.000Z"); return t}()),
		// 				LastModifiedBy: to.Ptr("UserName"),
		// 				LastModifiedByType: to.Ptr(armmigrationdiscoverysap.CreatedByTypeUser),
		// 			},
		// 			Location: to.Ptr("eastus"),
		// 			Tags: map[string]*string{
		// 				"property1": to.Ptr("value1"),
		// 				"property2": to.Ptr("value2"),
		// 			},
		// 			Properties: &armmigrationdiscoverysap.SAPDiscoverySiteProperties{
		// 				Errors: &armmigrationdiscoverysap.SAPMigrateError{
		// 					Properties: &armmigrationdiscoverysap.ErrorDefinition{
		// 						Code: to.Ptr("ErrorCode1"),
		// 						Message: to.Ptr("This would be an elaborate error message"),
		// 						Details: []*armmigrationdiscoverysap.ErrorDefinition{
		// 							{
		// 								Code: to.Ptr("ErrorCode2"),
		// 								Message: to.Ptr("This would be an elaborate error message"),
		// 						}},
		// 					},
		// 				},
		// 				MasterSiteID: to.Ptr("MasterSiteIdResourceId1"),
		// 				MigrateProjectID: to.Ptr("MigrateProjectId1"),
		// 				ProvisioningState: to.Ptr(armmigrationdiscoverysap.ProvisioningStateSucceeded),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/475747ff6322e9bf180b8911d871561b264379c3/specification/workloads/resource-manager/Microsoft.Workloads/SAPDiscoverySites/preview/2023-10-01-preview/examples/SAPDiscoverySites_Get.json
func ExampleSapDiscoverySitesClient_Get() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmigrationdiscoverysap.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewSapDiscoverySitesClient().Get(ctx, "test-rg", "SampleSite", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.SAPDiscoverySite = armmigrationdiscoverysap.SAPDiscoverySite{
	// 	Name: to.Ptr("SampleSite"),
	// 	Type: to.Ptr("microsoft.workloads/sapDiscoverySites"),
	// 	ID: to.Ptr("/subscriptions/6d875e77-e412-4d7d-9af4-8895278b4443/resourceGroups/test-rg/providers/Microsoft.Workloads/sapDiscoverySites/SampleSite"),
	// 	SystemData: &armmigrationdiscoverysap.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-06-26T14:15:22.000Z"); return t}()),
	// 		CreatedBy: to.Ptr("UserName"),
	// 		CreatedByType: to.Ptr(armmigrationdiscoverysap.CreatedByTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-06-26T14:15:22.000Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("UserName"),
	// 		LastModifiedByType: to.Ptr(armmigrationdiscoverysap.CreatedByTypeUser),
	// 	},
	// 	Location: to.Ptr("eastus"),
	// 	Tags: map[string]*string{
	// 		"property1": to.Ptr("value1"),
	// 		"property2": to.Ptr("value2"),
	// 	},
	// 	Properties: &armmigrationdiscoverysap.SAPDiscoverySiteProperties{
	// 		Errors: &armmigrationdiscoverysap.SAPMigrateError{
	// 			Properties: &armmigrationdiscoverysap.ErrorDefinition{
	// 				Code: to.Ptr("ErrorCode1"),
	// 				Message: to.Ptr("This would be an elaborate error message"),
	// 				Details: []*armmigrationdiscoverysap.ErrorDefinition{
	// 					{
	// 						Code: to.Ptr("ErrorCode2"),
	// 						Message: to.Ptr("This would be an elaborate error message"),
	// 				}},
	// 			},
	// 		},
	// 		MasterSiteID: to.Ptr("MasterSiteIdResourceId"),
	// 		MigrateProjectID: to.Ptr("MigrateProjectId"),
	// 		ProvisioningState: to.Ptr(armmigrationdiscoverysap.ProvisioningStateSucceeded),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/475747ff6322e9bf180b8911d871561b264379c3/specification/workloads/resource-manager/Microsoft.Workloads/SAPDiscoverySites/preview/2023-10-01-preview/examples/SAPDiscoverySites_Create.json
func ExampleSapDiscoverySitesClient_BeginCreate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmigrationdiscoverysap.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewSapDiscoverySitesClient().BeginCreate(ctx, "test-rg", "SampleSite", armmigrationdiscoverysap.SAPDiscoverySite{
		Location: to.Ptr("eastus"),
		Tags: map[string]*string{
			"property1": to.Ptr("value1"),
			"property2": to.Ptr("value2"),
		},
		Properties: &armmigrationdiscoverysap.SAPDiscoverySiteProperties{
			MasterSiteID:     to.Ptr("MasterSiteIdResourceId"),
			MigrateProjectID: to.Ptr("MigrateProjectId"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.SAPDiscoverySite = armmigrationdiscoverysap.SAPDiscoverySite{
	// 	Name: to.Ptr("SampleSite"),
	// 	Type: to.Ptr("microsoft.workloads/sapDiscoverySites"),
	// 	ID: to.Ptr("/subscriptions/6d875e77-e412-4d7d-9af4-8895278b4443/resourceGroups/test-rg/providers/Microsoft.Workloads/sapDiscoverySites/SampleSite"),
	// 	SystemData: &armmigrationdiscoverysap.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-06-26T14:15:22.000Z"); return t}()),
	// 		CreatedBy: to.Ptr("UserName"),
	// 		CreatedByType: to.Ptr(armmigrationdiscoverysap.CreatedByTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-06-26T14:15:22.000Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("UserName"),
	// 		LastModifiedByType: to.Ptr(armmigrationdiscoverysap.CreatedByTypeUser),
	// 	},
	// 	Location: to.Ptr("eastus"),
	// 	Tags: map[string]*string{
	// 		"property1": to.Ptr("value1"),
	// 		"property2": to.Ptr("value2"),
	// 	},
	// 	Properties: &armmigrationdiscoverysap.SAPDiscoverySiteProperties{
	// 		Errors: &armmigrationdiscoverysap.SAPMigrateError{
	// 			Properties: &armmigrationdiscoverysap.ErrorDefinition{
	// 				Code: to.Ptr("ErrorCode1"),
	// 				Message: to.Ptr("This would be an elaborate error message"),
	// 				Details: []*armmigrationdiscoverysap.ErrorDefinition{
	// 					{
	// 						Code: to.Ptr("ErrorCode2"),
	// 						Message: to.Ptr("This would be an elaborate error message"),
	// 				}},
	// 			},
	// 		},
	// 		MasterSiteID: to.Ptr("MasterSiteIdResourceId"),
	// 		MigrateProjectID: to.Ptr("MigrateProjectId"),
	// 		ProvisioningState: to.Ptr(armmigrationdiscoverysap.ProvisioningStateSucceeded),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/475747ff6322e9bf180b8911d871561b264379c3/specification/workloads/resource-manager/Microsoft.Workloads/SAPDiscoverySites/preview/2023-10-01-preview/examples/SAPDiscoverySites_Update.json
func ExampleSapDiscoverySitesClient_Update() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmigrationdiscoverysap.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewSapDiscoverySitesClient().Update(ctx, "test-rg", "SampleSite", armmigrationdiscoverysap.SAPDiscoverySiteTagsUpdate{
		Tags: map[string]*string{
			"tag1": to.Ptr("value1"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.SAPDiscoverySite = armmigrationdiscoverysap.SAPDiscoverySite{
	// 	Name: to.Ptr("SampleSite"),
	// 	Type: to.Ptr("microsoft.workloads/sapDiscoverySites"),
	// 	ID: to.Ptr("/subscriptions/6d875e77-e412-4d7d-9af4-8895278b4443/resourceGroups/test-rg/providers/Microsoft.Workloads/sapDiscoverySites/SampleSite"),
	// 	SystemData: &armmigrationdiscoverysap.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-06-26T14:15:22.000Z"); return t}()),
	// 		CreatedBy: to.Ptr("UserName"),
	// 		CreatedByType: to.Ptr(armmigrationdiscoverysap.CreatedByTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-06-26T14:15:22.000Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("UserName"),
	// 		LastModifiedByType: to.Ptr(armmigrationdiscoverysap.CreatedByTypeUser),
	// 	},
	// 	Location: to.Ptr("eastus"),
	// 	Tags: map[string]*string{
	// 		"property1": to.Ptr("value1"),
	// 		"property2": to.Ptr("value2"),
	// 	},
	// 	Properties: &armmigrationdiscoverysap.SAPDiscoverySiteProperties{
	// 		Errors: &armmigrationdiscoverysap.SAPMigrateError{
	// 			Properties: &armmigrationdiscoverysap.ErrorDefinition{
	// 				Code: to.Ptr("ErrorCode1"),
	// 				Message: to.Ptr("This would be an elaborate error message"),
	// 				Details: []*armmigrationdiscoverysap.ErrorDefinition{
	// 					{
	// 						Code: to.Ptr("ErrorCode2"),
	// 						Message: to.Ptr("This would be an elaborate error message"),
	// 				}},
	// 			},
	// 		},
	// 		MasterSiteID: to.Ptr("MasterSiteIdResourceId"),
	// 		MigrateProjectID: to.Ptr("MigrateProjectId"),
	// 		ProvisioningState: to.Ptr(armmigrationdiscoverysap.ProvisioningStateSucceeded),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/475747ff6322e9bf180b8911d871561b264379c3/specification/workloads/resource-manager/Microsoft.Workloads/SAPDiscoverySites/preview/2023-10-01-preview/examples/SAPDiscoverySites_Delete.json
func ExampleSapDiscoverySitesClient_BeginDelete() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmigrationdiscoverysap.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewSapDiscoverySitesClient().BeginDelete(ctx, "test-rg", "SampleSite", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/475747ff6322e9bf180b8911d871561b264379c3/specification/workloads/resource-manager/Microsoft.Workloads/SAPDiscoverySites/preview/2023-10-01-preview/examples/SAPDiscoverySites_ImportEntities.json
func ExampleSapDiscoverySitesClient_BeginImportEntities() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmigrationdiscoverysap.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewSapDiscoverySitesClient().BeginImportEntities(ctx, "test-rg", "SampleSite", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.OperationStatusResult = armmigrationdiscoverysap.OperationStatusResult{
	// 	Name: to.Ptr("1e4193c3-206e-4916-b124-1da16175eb0e"),
	// 	EndTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-08-19T03:38:07.000Z"); return t}()),
	// 	Error: &armmigrationdiscoverysap.ErrorDetail{
	// 		Code: to.Ptr("ExcelUploadNotSupported"),
	// 		Message: to.Ptr("Excel upload is not supported for a natively discovered Site."),
	// 		Details: []*armmigrationdiscoverysap.ErrorDetail{
	// 			{
	// 				Code: to.Ptr("ParallelExcelUploadNotSuppoeted"),
	// 				Message: to.Ptr("Only one excel upload operation allowed for a discovery site at a time."),
	// 		}},
	// 	},
	// 	ID: to.Ptr("/subscriptions/6d875e77-e412-4d7d-9af4-8895278b4443/resourceGroups/test-rg/providers/Microsoft.Workloads/sapDiscoverySites/SampleSite"),
	// 	StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-08-19T03:36:07.000Z"); return t}()),
	// 	Status: to.Ptr("Succeeded"),
	// }
}
