//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armiotfirmwaredefense_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/iotfirmwaredefense/armiotfirmwaredefense"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/cf5ad1932d00c7d15497705ad6b71171d3d68b1e/specification/fist/resource-manager/Microsoft.IoTFirmwareDefense/stable/2024-01-10/examples/Firmwares_ListByWorkspace_MaximumSet_Gen.json
func ExampleFirmwaresClient_NewListByWorkspacePager_firmwaresListByWorkspaceMaximumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armiotfirmwaredefense.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewFirmwaresClient().NewListByWorkspacePager("rgworkspaces-firmwares", "A7", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.FirmwareList = armiotfirmwaredefense.FirmwareList{
		// 	Value: []*armiotfirmwaredefense.Firmware{
		// 		{
		// 			Name: to.Ptr("brmvnojpmxsgckdviynhxhftvcvbw"),
		// 			Type: to.Ptr("vlxhdbrphhnttmxvawwwewza"),
		// 			ID: to.Ptr("/subscriptions/blah/resourceGroups/blah/providers/blah/firmwares/blah"),
		// 			SystemData: &armiotfirmwaredefense.SystemData{
		// 				CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-02-19T06:40:29.228Z"); return t}()),
		// 				CreatedBy: to.Ptr("aylilpicryidesowemwnl"),
		// 				CreatedByType: to.Ptr(armiotfirmwaredefense.CreatedByTypeUser),
		// 				LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-02-19T06:40:29.228Z"); return t}()),
		// 				LastModifiedBy: to.Ptr("bgtifu"),
		// 				LastModifiedByType: to.Ptr(armiotfirmwaredefense.CreatedByTypeUser),
		// 			},
		// 			Properties: &armiotfirmwaredefense.FirmwareProperties{
		// 				Description: to.Ptr("uz"),
		// 				FileName: to.Ptr("wresexxulcdsdd"),
		// 				FileSize: to.Ptr[int64](17),
		// 				Model: to.Ptr("f"),
		// 				ProvisioningState: to.Ptr(armiotfirmwaredefense.ProvisioningStateSucceeded),
		// 				Status: to.Ptr(armiotfirmwaredefense.StatusPending),
		// 				StatusMessages: []*armiotfirmwaredefense.StatusMessage{
		// 					{
		// 						Message: to.Ptr("ulvhmhokezathzzauiitu"),
		// 				}},
		// 				Vendor: to.Ptr("vycmdhgtmepcptyoubztiuudpkcpd"),
		// 				Version: to.Ptr("s"),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/cf5ad1932d00c7d15497705ad6b71171d3d68b1e/specification/fist/resource-manager/Microsoft.IoTFirmwareDefense/stable/2024-01-10/examples/Firmwares_ListByWorkspace_MinimumSet_Gen.json
func ExampleFirmwaresClient_NewListByWorkspacePager_firmwaresListByWorkspaceMinimumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armiotfirmwaredefense.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewFirmwaresClient().NewListByWorkspacePager("rgworkspaces-firmwares", "A7", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.FirmwareList = armiotfirmwaredefense.FirmwareList{
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/cf5ad1932d00c7d15497705ad6b71171d3d68b1e/specification/fist/resource-manager/Microsoft.IoTFirmwareDefense/stable/2024-01-10/examples/Firmwares_Create_MaximumSet_Gen.json
func ExampleFirmwaresClient_Create_firmwaresCreateMaximumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armiotfirmwaredefense.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewFirmwaresClient().Create(ctx, "rgworkspaces-firmwares", "A7", "umrkdttp", armiotfirmwaredefense.Firmware{
		Properties: &armiotfirmwaredefense.FirmwareProperties{
			Description: to.Ptr("uz"),
			FileName:    to.Ptr("wresexxulcdsdd"),
			FileSize:    to.Ptr[int64](17),
			Model:       to.Ptr("f"),
			Status:      to.Ptr(armiotfirmwaredefense.StatusPending),
			StatusMessages: []*armiotfirmwaredefense.StatusMessage{
				{
					Message: to.Ptr("ulvhmhokezathzzauiitu"),
				}},
			Vendor:  to.Ptr("vycmdhgtmepcptyoubztiuudpkcpd"),
			Version: to.Ptr("s"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Firmware = armiotfirmwaredefense.Firmware{
	// 	Name: to.Ptr("brmvnojpmxsgckdviynhxhftvcvbw"),
	// 	Type: to.Ptr("vlxhdbrphhnttmxvawwwewza"),
	// 	ID: to.Ptr("/subscriptions/blah/resourceGroups/blah/providers/blah/firmwares/blah"),
	// 	SystemData: &armiotfirmwaredefense.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-02-19T06:40:29.228Z"); return t}()),
	// 		CreatedBy: to.Ptr("aylilpicryidesowemwnl"),
	// 		CreatedByType: to.Ptr(armiotfirmwaredefense.CreatedByTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-02-19T06:40:29.228Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("bgtifu"),
	// 		LastModifiedByType: to.Ptr(armiotfirmwaredefense.CreatedByTypeUser),
	// 	},
	// 	Properties: &armiotfirmwaredefense.FirmwareProperties{
	// 		Description: to.Ptr("uz"),
	// 		FileName: to.Ptr("wresexxulcdsdd"),
	// 		FileSize: to.Ptr[int64](17),
	// 		Model: to.Ptr("f"),
	// 		ProvisioningState: to.Ptr(armiotfirmwaredefense.ProvisioningStateSucceeded),
	// 		Status: to.Ptr(armiotfirmwaredefense.StatusPending),
	// 		StatusMessages: []*armiotfirmwaredefense.StatusMessage{
	// 			{
	// 				Message: to.Ptr("ulvhmhokezathzzauiitu"),
	// 		}},
	// 		Vendor: to.Ptr("vycmdhgtmepcptyoubztiuudpkcpd"),
	// 		Version: to.Ptr("s"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/cf5ad1932d00c7d15497705ad6b71171d3d68b1e/specification/fist/resource-manager/Microsoft.IoTFirmwareDefense/stable/2024-01-10/examples/Firmwares_Create_MinimumSet_Gen.json
func ExampleFirmwaresClient_Create_firmwaresCreateMinimumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armiotfirmwaredefense.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewFirmwaresClient().Create(ctx, "rgworkspaces-firmwares", "A7", "umrkdttp", armiotfirmwaredefense.Firmware{}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Firmware = armiotfirmwaredefense.Firmware{
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/cf5ad1932d00c7d15497705ad6b71171d3d68b1e/specification/fist/resource-manager/Microsoft.IoTFirmwareDefense/stable/2024-01-10/examples/Firmwares_Update_MaximumSet_Gen.json
func ExampleFirmwaresClient_Update_firmwaresUpdateMaximumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armiotfirmwaredefense.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewFirmwaresClient().Update(ctx, "rgworkspaces-firmwares", "A7", "umrkdttp", armiotfirmwaredefense.FirmwareUpdateDefinition{
		Properties: &armiotfirmwaredefense.FirmwareProperties{
			Description: to.Ptr("uz"),
			FileName:    to.Ptr("wresexxulcdsdd"),
			FileSize:    to.Ptr[int64](17),
			Model:       to.Ptr("f"),
			Status:      to.Ptr(armiotfirmwaredefense.StatusPending),
			StatusMessages: []*armiotfirmwaredefense.StatusMessage{
				{
					Message: to.Ptr("ulvhmhokezathzzauiitu"),
				}},
			Vendor:  to.Ptr("vycmdhgtmepcptyoubztiuudpkcpd"),
			Version: to.Ptr("s"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Firmware = armiotfirmwaredefense.Firmware{
	// 	Name: to.Ptr("brmvnojpmxsgckdviynhxhftvcvbw"),
	// 	Type: to.Ptr("vlxhdbrphhnttmxvawwwewza"),
	// 	ID: to.Ptr("/subscriptions/blah/resourceGroups/blah/providers/blah/firmwares/blah"),
	// 	SystemData: &armiotfirmwaredefense.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-02-19T06:40:29.228Z"); return t}()),
	// 		CreatedBy: to.Ptr("aylilpicryidesowemwnl"),
	// 		CreatedByType: to.Ptr(armiotfirmwaredefense.CreatedByTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-02-19T06:40:29.228Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("bgtifu"),
	// 		LastModifiedByType: to.Ptr(armiotfirmwaredefense.CreatedByTypeUser),
	// 	},
	// 	Properties: &armiotfirmwaredefense.FirmwareProperties{
	// 		Description: to.Ptr("uz"),
	// 		FileName: to.Ptr("wresexxulcdsdd"),
	// 		FileSize: to.Ptr[int64](17),
	// 		Model: to.Ptr("f"),
	// 		ProvisioningState: to.Ptr(armiotfirmwaredefense.ProvisioningStateSucceeded),
	// 		Status: to.Ptr(armiotfirmwaredefense.StatusPending),
	// 		StatusMessages: []*armiotfirmwaredefense.StatusMessage{
	// 			{
	// 				Message: to.Ptr("ulvhmhokezathzzauiitu"),
	// 		}},
	// 		Vendor: to.Ptr("vycmdhgtmepcptyoubztiuudpkcpd"),
	// 		Version: to.Ptr("s"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/cf5ad1932d00c7d15497705ad6b71171d3d68b1e/specification/fist/resource-manager/Microsoft.IoTFirmwareDefense/stable/2024-01-10/examples/Firmwares_Update_MinimumSet_Gen.json
func ExampleFirmwaresClient_Update_firmwaresUpdateMinimumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armiotfirmwaredefense.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewFirmwaresClient().Update(ctx, "rgworkspaces-firmwares", "A7", "umrkdttp", armiotfirmwaredefense.FirmwareUpdateDefinition{}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Firmware = armiotfirmwaredefense.Firmware{
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/cf5ad1932d00c7d15497705ad6b71171d3d68b1e/specification/fist/resource-manager/Microsoft.IoTFirmwareDefense/stable/2024-01-10/examples/Firmwares_Delete_MaximumSet_Gen.json
func ExampleFirmwaresClient_Delete_firmwaresDeleteMaximumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armiotfirmwaredefense.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewFirmwaresClient().Delete(ctx, "rgworkspaces-firmwares", "A7", "umrkdttp", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/cf5ad1932d00c7d15497705ad6b71171d3d68b1e/specification/fist/resource-manager/Microsoft.IoTFirmwareDefense/stable/2024-01-10/examples/Firmwares_Delete_MinimumSet_Gen.json
func ExampleFirmwaresClient_Delete_firmwaresDeleteMinimumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armiotfirmwaredefense.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewFirmwaresClient().Delete(ctx, "rgworkspaces-firmwares", "A7", "umrkdttp", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/cf5ad1932d00c7d15497705ad6b71171d3d68b1e/specification/fist/resource-manager/Microsoft.IoTFirmwareDefense/stable/2024-01-10/examples/Firmwares_Get_MaximumSet_Gen.json
func ExampleFirmwaresClient_Get_firmwaresGetMaximumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armiotfirmwaredefense.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewFirmwaresClient().Get(ctx, "rgworkspaces-firmwares", "A7", "umrkdttp", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Firmware = armiotfirmwaredefense.Firmware{
	// 	Name: to.Ptr("brmvnojpmxsgckdviynhxhftvcvbw"),
	// 	Type: to.Ptr("vlxhdbrphhnttmxvawwwewza"),
	// 	ID: to.Ptr("/subscriptions/blah/resourceGroups/blah/providers/blah/firmwares/blah"),
	// 	SystemData: &armiotfirmwaredefense.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-02-19T06:40:29.228Z"); return t}()),
	// 		CreatedBy: to.Ptr("aylilpicryidesowemwnl"),
	// 		CreatedByType: to.Ptr(armiotfirmwaredefense.CreatedByTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-02-19T06:40:29.228Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("bgtifu"),
	// 		LastModifiedByType: to.Ptr(armiotfirmwaredefense.CreatedByTypeUser),
	// 	},
	// 	Properties: &armiotfirmwaredefense.FirmwareProperties{
	// 		Description: to.Ptr("uz"),
	// 		FileName: to.Ptr("wresexxulcdsdd"),
	// 		FileSize: to.Ptr[int64](17),
	// 		Model: to.Ptr("f"),
	// 		ProvisioningState: to.Ptr(armiotfirmwaredefense.ProvisioningStateSucceeded),
	// 		Status: to.Ptr(armiotfirmwaredefense.StatusPending),
	// 		StatusMessages: []*armiotfirmwaredefense.StatusMessage{
	// 			{
	// 				Message: to.Ptr("ulvhmhokezathzzauiitu"),
	// 		}},
	// 		Vendor: to.Ptr("vycmdhgtmepcptyoubztiuudpkcpd"),
	// 		Version: to.Ptr("s"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/cf5ad1932d00c7d15497705ad6b71171d3d68b1e/specification/fist/resource-manager/Microsoft.IoTFirmwareDefense/stable/2024-01-10/examples/Firmwares_Get_MinimumSet_Gen.json
func ExampleFirmwaresClient_Get_firmwaresGetMinimumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armiotfirmwaredefense.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewFirmwaresClient().Get(ctx, "rgworkspaces-firmwares", "A7", "umrkdttp", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Firmware = armiotfirmwaredefense.Firmware{
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/cf5ad1932d00c7d15497705ad6b71171d3d68b1e/specification/fist/resource-manager/Microsoft.IoTFirmwareDefense/stable/2024-01-10/examples/Firmwares_GenerateDownloadUrl_MaximumSet_Gen.json
func ExampleFirmwaresClient_GenerateDownloadURL_firmwaresGenerateDownloadUrlMaximumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armiotfirmwaredefense.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewFirmwaresClient().GenerateDownloadURL(ctx, "rgworkspaces-firmwares", "A7", "umrkdttp", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.URLToken = armiotfirmwaredefense.URLToken{
	// 	URL: to.Ptr("https://i/am/a/sas/token"),
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/cf5ad1932d00c7d15497705ad6b71171d3d68b1e/specification/fist/resource-manager/Microsoft.IoTFirmwareDefense/stable/2024-01-10/examples/Firmwares_GenerateDownloadUrl_MinimumSet_Gen.json
func ExampleFirmwaresClient_GenerateDownloadURL_firmwaresGenerateDownloadUrlMinimumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armiotfirmwaredefense.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewFirmwaresClient().GenerateDownloadURL(ctx, "rgworkspaces-firmwares", "A7", "umrkdttp", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.URLToken = armiotfirmwaredefense.URLToken{
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/cf5ad1932d00c7d15497705ad6b71171d3d68b1e/specification/fist/resource-manager/Microsoft.IoTFirmwareDefense/stable/2024-01-10/examples/Firmwares_GenerateFilesystemDownloadUrl_MaximumSet_Gen.json
func ExampleFirmwaresClient_GenerateFilesystemDownloadURL_firmwaresGenerateFilesystemDownloadUrlMaximumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armiotfirmwaredefense.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewFirmwaresClient().GenerateFilesystemDownloadURL(ctx, "rgworkspaces-firmwares", "A7", "umrkdttp", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.URLToken = armiotfirmwaredefense.URLToken{
	// 	URL: to.Ptr("https://i/am/a/sas/token"),
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/cf5ad1932d00c7d15497705ad6b71171d3d68b1e/specification/fist/resource-manager/Microsoft.IoTFirmwareDefense/stable/2024-01-10/examples/Firmwares_GenerateFilesystemDownloadUrl_MinimumSet_Gen.json
func ExampleFirmwaresClient_GenerateFilesystemDownloadURL_firmwaresGenerateFilesystemDownloadUrlMinimumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armiotfirmwaredefense.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewFirmwaresClient().GenerateFilesystemDownloadURL(ctx, "rgworkspaces-firmwares", "A7", "umrkdttp", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.URLToken = armiotfirmwaredefense.URLToken{
	// }
}
