//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
// Code generated by Microsoft (R) AutoRest Code Generator.Changes may cause incorrect behavior and will be lost if the code
// is regenerated.
// Code generated by @autorest/go. DO NOT EDIT.

package armelastic

import "time"

// CloudDeployment - Details of the user's elastic deployment associated with the monitor resource.
type CloudDeployment struct {
	// READ-ONLY; Associated Azure subscription Id for the elastic deployment.
	AzureSubscriptionID *string

	// READ-ONLY; Elastic deployment Id
	DeploymentID *string

	// READ-ONLY; Region where Deployment at Elastic side took place.
	ElasticsearchRegion *string

	// READ-ONLY; Elasticsearch ingestion endpoint of the Elastic deployment.
	ElasticsearchServiceURL *string

	// READ-ONLY; Kibana endpoint of the Elastic deployment.
	KibanaServiceURL *string

	// READ-ONLY; Kibana dashboard sso URL of the Elastic deployment.
	KibanaSsoURL *string

	// READ-ONLY; Elastic deployment name
	Name *string
}

// CloudUser - Details of the user's elastic account.
type CloudUser struct {
	// READ-ONLY; Elastic cloud default dashboard sso URL of the Elastic user account.
	ElasticCloudSsoDefaultURL *string

	// READ-ONLY; Email of the Elastic User Account.
	EmailAddress *string

	// READ-ONLY; User Id of the elastic account of the User.
	ID *string
}

// CompanyInfo - Company information of the user to be passed to partners.
type CompanyInfo struct {
	// Business of the company
	Business *string

	// Country of the company location.
	Country *string

	// Domain of the company
	Domain *string

	// Number of employees in the company
	EmployeesNumber *string

	// State of the company location.
	State *string
}

// DeploymentInfoResponse - The properties of deployment in Elastic cloud corresponding to the Elastic monitor resource.
type DeploymentInfoResponse struct {
	// READ-ONLY; Deployment URL of the elasticsearch in Elastic cloud deployment.
	DeploymentURL *string

	// READ-ONLY; Disk capacity of the elasticsearch in Elastic cloud deployment.
	DiskCapacity *string

	// READ-ONLY; Marketplace SaaS Info of the resource.
	MarketplaceSaasInfo *MarketplaceSaaSInfo

	// READ-ONLY; RAM capacity of the elasticsearch in Elastic cloud deployment.
	MemoryCapacity *string

	// READ-ONLY; The Elastic deployment status.
	Status *ElasticDeploymentStatus

	// READ-ONLY; Version of the elasticsearch in Elastic cloud deployment.
	Version *string
}

// ExternalUserCreationResponse - The properties of the response we got from elastic while creating external user
type ExternalUserCreationResponse struct {
	// READ-ONLY; Shows if user is created or updated
	Created *bool
}

// ExternalUserInfo - The properties of the request required for creating user on elastic side
type ExternalUserInfo struct {
	// Email id of the user to be created or updated
	EmailID *string

	// Full name of the user to be created or updated
	FullName *string

	// Password of the user to be created or updated
	Password *string

	// Roles to be assigned for created or updated user
	Roles []*string

	// Username of the user to be created or updated
	UserName *string
}

// FilteringTag - The definition of a filtering tag. Filtering tags are used for capturing resources and include/exclude them
// from being monitored.
type FilteringTag struct {
	// Valid actions for a filtering tag.
	Action *TagAction

	// The name (also known as the key) of the tag.
	Name *string

	// The value of the tag.
	Value *string
}

// IdentityProperties - Identity properties.
type IdentityProperties struct {
	// Managed identity type.
	Type *ManagedIdentityTypes

	// READ-ONLY; The identity ID.
	PrincipalID *string

	// READ-ONLY; The tenant ID of resource.
	TenantID *string
}

// LogRules - Set of rules for sending logs for the Monitor resource.
type LogRules struct {
	// List of filtering tags to be used for capturing logs. This only takes effect if SendActivityLogs flag is enabled. If empty,
	// all resources will be captured. If only Exclude action is specified, the
	// rules will apply to the list of all available resources. If Include actions are specified, the rules will only include
	// resources with the associated tags.
	FilteringTags []*FilteringTag

	// Flag specifying if AAD logs should be sent for the Monitor resource.
	SendAADLogs *bool

	// Flag specifying if activity logs from Azure resources should be sent for the Monitor resource.
	SendActivityLogs *bool

	// Flag specifying if subscription logs should be sent for the Monitor resource.
	SendSubscriptionLogs *bool
}

// MarketplaceSaaSInfo - Marketplace SAAS Info of the resource.
type MarketplaceSaaSInfo struct {
	// Marketplace Subscription Details: SAAS Name
	MarketplaceName *string

	// Marketplace Subscription Details: Resource URI
	MarketplaceResourceID *string

	// Marketplace Subscription
	MarketplaceSubscription *MarketplaceSaaSInfoMarketplaceSubscription
}

// MarketplaceSaaSInfoMarketplaceSubscription - Marketplace Subscription
type MarketplaceSaaSInfoMarketplaceSubscription struct {
	// Marketplace Subscription Id. This is a GUID-formatted string.
	ID *string
}

// MonitorProperties - Properties specific to the monitor resource.
type MonitorProperties struct {
	// Elastic cloud properties.
	ElasticProperties *Properties

	// Flag to determine if User API Key has to be generated and shared.
	GenerateAPIKey *bool

	// Flag specifying if the resource monitoring is enabled or disabled.
	MonitoringStatus *MonitoringStatus

	// Provisioning state of the monitor resource.
	ProvisioningState *ProvisioningState

	// User information.
	UserInfo *UserInfo

	// Version of elastic of the monitor resource
	Version *string

	// READ-ONLY
	LiftrResourceCategory *LiftrResourceCategories

	// READ-ONLY; The priority of the resource.
	LiftrResourcePreference *int32
}

// MonitorResource - Monitor resource.
type MonitorResource struct {
	// REQUIRED; The location of the monitor resource
	Location *string

	// Identity properties of the monitor resource.
	Identity *IdentityProperties

	// Properties of the monitor resource.
	Properties *MonitorProperties

	// SKU of the monitor resource.
	SKU *ResourceSKU

	// The tags of the monitor resource.
	Tags map[string]*string

	// READ-ONLY; ARM id of the monitor resource.
	ID *string

	// READ-ONLY; Name of the monitor resource.
	Name *string

	// READ-ONLY; The system metadata relating to this resource
	SystemData *SystemData

	// READ-ONLY; The type of the monitor resource.
	Type *string
}

// MonitorResourceListResponse - Response of a list operation.
type MonitorResourceListResponse struct {
	// Link to the next set of results, if any.
	NextLink *string

	// Results of a list operation.
	Value []*MonitorResource
}

// MonitorResourceUpdateParameters - Monitor resource update parameters.
type MonitorResourceUpdateParameters struct {
	// elastic monitor resource tags.
	Tags map[string]*string
}

// MonitorUpgrade - Upgrade elastic monitor version
type MonitorUpgrade struct {
	// Version to which the elastic monitor should be upgraded to
	Version *string
}

// MonitoredResource - The properties of a resource currently being monitored by the Elastic monitor resource.
type MonitoredResource struct {
	// The ARM id of the resource.
	ID *string

	// Reason for why the resource is sending logs (or why it is not sending).
	ReasonForLogsStatus *string

	// Flag indicating the status of the resource for sending logs operation to Elastic.
	SendingLogs *SendingLogs
}

// MonitoredResourceListResponse - Response of a list operation.
type MonitoredResourceListResponse struct {
	// Link to the next set of results, if any.
	NextLink *string

	// Results of a list operation.
	Value []*MonitoredResource
}

// MonitoringTagRules - Capture logs and metrics of Azure resources based on ARM tags.
type MonitoringTagRules struct {
	// Properties of the monitoring tag rules.
	Properties *MonitoringTagRulesProperties

	// READ-ONLY; The id of the rule set.
	ID *string

	// READ-ONLY; Name of the rule set.
	Name *string

	// READ-ONLY; The system metadata relating to this resource
	SystemData *SystemData

	// READ-ONLY; The type of the rule set.
	Type *string
}

// MonitoringTagRulesListResponse - Response of a list operation.
type MonitoringTagRulesListResponse struct {
	// Link to the next set of results, if any.
	NextLink *string

	// Results of a list operation.
	Value []*MonitoringTagRules
}

// MonitoringTagRulesProperties - Definition of the properties for a TagRules resource.
type MonitoringTagRulesProperties struct {
	// Rules for sending logs.
	LogRules *LogRules

	// Provisioning state of the monitoring tag rules.
	ProvisioningState *ProvisioningState
}

// OperationDisplay - The object that represents the operation.
type OperationDisplay struct {
	// Description of the operation, e.g., 'Write monitors'.
	Description *string

	// Operation type, e.g., read, write, delete, etc.
	Operation *string

	// Service provider, i.e., Microsoft.Elastic.
	Provider *string

	// Type on which the operation is performed, e.g., 'monitors'.
	Resource *string
}

// OperationListResult - Result of GET request to list the Microsoft.Elastic operations.
type OperationListResult struct {
	// URL to get the next set of operation list results if there are any.
	NextLink *string

	// List of operations supported by the Microsoft.Elastic provider.
	Value []*OperationResult
}

// OperationResult - A Microsoft.Elastic REST API operation.
type OperationResult struct {
	// The object that represents the operation.
	Display *OperationDisplay

	// Indicates whether the operation is a data action
	IsDataAction *bool

	// Operation name, i.e., {provider}/{resource}/{operation}.
	Name *string

	// Origin of the operation
	Origin *string
}

// Properties - Elastic Resource Properties.
type Properties struct {
	// Details of the elastic cloud deployment.
	ElasticCloudDeployment *CloudDeployment

	// Details of the user's elastic account.
	ElasticCloudUser *CloudUser
}

// ResourceSKU - Microsoft.Elastic SKU.
type ResourceSKU struct {
	// REQUIRED; Name of the SKU.
	Name *string
}

// SystemData - Metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// The timestamp of resource creation (UTC).
	CreatedAt *time.Time

	// The identity that created the resource.
	CreatedBy *string

	// The type of identity that created the resource.
	CreatedByType *CreatedByType

	// The timestamp of resource last modification (UTC)
	LastModifiedAt *time.Time

	// The identity that last modified the resource.
	LastModifiedBy *string

	// The type of identity that last modified the resource.
	LastModifiedByType *CreatedByType
}

// TrafficFilter - Elastic traffic filter object
type TrafficFilter struct {
	// Description of the elastic filter
	Description *string

	// Id of the elastic filter
	ID *string

	// IncludeByDefault for the elastic filter
	IncludeByDefault *bool

	// Name of the elastic filter
	Name *string

	// Region of the elastic filter
	Region *string

	// Rules in the elastic filter
	Rules []*TrafficFilterRule

	// Type of the elastic filter
	Type *Type
}

// TrafficFilterResponse - List of elastic traffic filters in the account
type TrafficFilterResponse struct {
	// List of elastic traffic filters in the account
	Rulesets []*TrafficFilter
}

// TrafficFilterRule - Elastic traffic filter rule object
type TrafficFilterRule struct {
	// Guid of Private Endpoint in the elastic filter rule
	AzureEndpointGUID *string

	// Name of the Private Endpoint in the elastic filter rule
	AzureEndpointName *string

	// Description of the elastic filter rule
	Description *string

	// Id of the elastic filter rule
	ID *string

	// IP of the elastic filter rule
	Source *string
}

// UpgradableVersionsList - Stack Versions that this version can upgrade to
type UpgradableVersionsList struct {
	// Current version of the elastic monitor
	CurrentVersion *string

	// Stack Versions that this version can upgrade to
	UpgradableVersions []*string
}

// UserAPIKeyResponse - The User Api Key created for the Organization associated with the User Email Id that was passed in
// the request
type UserAPIKeyResponse struct {
	Properties *UserAPIKeyResponseProperties
}

type UserAPIKeyResponseProperties struct {
	// The User Api Key Generated based on GenerateApiKey flag. This is applicable for non-Portal clients only.
	APIKey *string
}

// UserEmailID - Email Id of the User Organization, of which the API Key must be returned
type UserEmailID struct {
	// The User email Id
	EmailID *string
}

// UserInfo - User Information to be passed to partners.
type UserInfo struct {
	// Company information of the user to be passed to partners.
	CompanyInfo *CompanyInfo

	// Company name of the user
	CompanyName *string

	// Email of the user used by Elastic for contacting them if needed
	EmailAddress *string

	// First name of the user
	FirstName *string

	// Last name of the user
	LastName *string
}

// VMCollectionUpdate - Update VM resource collection.
type VMCollectionUpdate struct {
	// Operation to be performed for given VM.
	OperationName *OperationName

	// ARM id of the VM resource.
	VMResourceID *string
}

// VMHostListResponse - Response of a list operation.
type VMHostListResponse struct {
	// Link to the next Vm resource Id, if any.
	NextLink *string

	// Results of a list operation.
	Value []*VMResources
}

// VMIngestionDetailsResponse - The vm ingestion details to install an agent.
type VMIngestionDetailsResponse struct {
	// The cloudId of given Elastic monitor resource.
	CloudID *string

	// Ingestion details to install agent on given VM.
	IngestionKey *string
}

// VMResources - The vm resource properties that is currently being monitored by the Elastic monitor resource.
type VMResources struct {
	// The ARM id of the VM resource.
	VMResourceID *string
}

// VersionListFormat - Elastic Version List Format
type VersionListFormat struct {
	// Elastic Version Properties
	Properties *VersionListProperties
}

// VersionListProperties - Elastic Version Properties
type VersionListProperties struct {
	// Available elastic version of the given region
	Version *string
}

// VersionsListResponse - List of elastic versions available in a region.
type VersionsListResponse struct {
	// Link to the next set of results, if any.
	NextLink *string

	// Results of a list operation.
	Value []*VersionListFormat
}
