//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
// Code generated by Microsoft (R) AutoRest Code Generator.Changes may cause incorrect behavior and will be lost if the code
// is regenerated.
// Code generated by @autorest/go. DO NOT EDIT.

package fake

import (
	"errors"
	"fmt"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"strings"
	"sync"
)

// ServerFactory is a fake server for instances of the armelastic.ClientFactory type.
type ServerFactory struct {
	AllTrafficFiltersServer            AllTrafficFiltersServer
	AssociateTrafficFilterServer       AssociateTrafficFilterServer
	CreateAndAssociateIPFilterServer   CreateAndAssociateIPFilterServer
	CreateAndAssociatePLFilterServer   CreateAndAssociatePLFilterServer
	DeploymentInfoServer               DeploymentInfoServer
	DetachAndDeleteTrafficFilterServer DetachAndDeleteTrafficFilterServer
	DetachTrafficFilterServer          DetachTrafficFilterServer
	ExternalUserServer                 ExternalUserServer
	ListAssociatedTrafficFiltersServer ListAssociatedTrafficFiltersServer
	MonitorServer                      MonitorServer
	MonitoredResourcesServer           MonitoredResourcesServer
	MonitorsServer                     MonitorsServer
	OperationsServer                   OperationsServer
	OrganizationsServer                OrganizationsServer
	TagRulesServer                     TagRulesServer
	TrafficFiltersServer               TrafficFiltersServer
	UpgradableVersionsServer           UpgradableVersionsServer
	VMCollectionServer                 VMCollectionServer
	VMHostServer                       VMHostServer
	VMIngestionServer                  VMIngestionServer
	VersionsServer                     VersionsServer
}

// NewServerFactoryTransport creates a new instance of ServerFactoryTransport with the provided implementation.
// The returned ServerFactoryTransport instance is connected to an instance of armelastic.ClientFactory via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewServerFactoryTransport(srv *ServerFactory) *ServerFactoryTransport {
	return &ServerFactoryTransport{
		srv: srv,
	}
}

// ServerFactoryTransport connects instances of armelastic.ClientFactory to instances of ServerFactory.
// Don't use this type directly, use NewServerFactoryTransport instead.
type ServerFactoryTransport struct {
	srv                                  *ServerFactory
	trMu                                 sync.Mutex
	trAllTrafficFiltersServer            *AllTrafficFiltersServerTransport
	trAssociateTrafficFilterServer       *AssociateTrafficFilterServerTransport
	trCreateAndAssociateIPFilterServer   *CreateAndAssociateIPFilterServerTransport
	trCreateAndAssociatePLFilterServer   *CreateAndAssociatePLFilterServerTransport
	trDeploymentInfoServer               *DeploymentInfoServerTransport
	trDetachAndDeleteTrafficFilterServer *DetachAndDeleteTrafficFilterServerTransport
	trDetachTrafficFilterServer          *DetachTrafficFilterServerTransport
	trExternalUserServer                 *ExternalUserServerTransport
	trListAssociatedTrafficFiltersServer *ListAssociatedTrafficFiltersServerTransport
	trMonitorServer                      *MonitorServerTransport
	trMonitoredResourcesServer           *MonitoredResourcesServerTransport
	trMonitorsServer                     *MonitorsServerTransport
	trOperationsServer                   *OperationsServerTransport
	trOrganizationsServer                *OrganizationsServerTransport
	trTagRulesServer                     *TagRulesServerTransport
	trTrafficFiltersServer               *TrafficFiltersServerTransport
	trUpgradableVersionsServer           *UpgradableVersionsServerTransport
	trVMCollectionServer                 *VMCollectionServerTransport
	trVMHostServer                       *VMHostServerTransport
	trVMIngestionServer                  *VMIngestionServerTransport
	trVersionsServer                     *VersionsServerTransport
}

// Do implements the policy.Transporter interface for ServerFactoryTransport.
func (s *ServerFactoryTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	client := method[:strings.Index(method, ".")]
	var resp *http.Response
	var err error

	switch client {
	case "AllTrafficFiltersClient":
		initServer(s, &s.trAllTrafficFiltersServer, func() *AllTrafficFiltersServerTransport {
			return NewAllTrafficFiltersServerTransport(&s.srv.AllTrafficFiltersServer)
		})
		resp, err = s.trAllTrafficFiltersServer.Do(req)
	case "AssociateTrafficFilterClient":
		initServer(s, &s.trAssociateTrafficFilterServer, func() *AssociateTrafficFilterServerTransport {
			return NewAssociateTrafficFilterServerTransport(&s.srv.AssociateTrafficFilterServer)
		})
		resp, err = s.trAssociateTrafficFilterServer.Do(req)
	case "CreateAndAssociateIPFilterClient":
		initServer(s, &s.trCreateAndAssociateIPFilterServer, func() *CreateAndAssociateIPFilterServerTransport {
			return NewCreateAndAssociateIPFilterServerTransport(&s.srv.CreateAndAssociateIPFilterServer)
		})
		resp, err = s.trCreateAndAssociateIPFilterServer.Do(req)
	case "CreateAndAssociatePLFilterClient":
		initServer(s, &s.trCreateAndAssociatePLFilterServer, func() *CreateAndAssociatePLFilterServerTransport {
			return NewCreateAndAssociatePLFilterServerTransport(&s.srv.CreateAndAssociatePLFilterServer)
		})
		resp, err = s.trCreateAndAssociatePLFilterServer.Do(req)
	case "DeploymentInfoClient":
		initServer(s, &s.trDeploymentInfoServer, func() *DeploymentInfoServerTransport {
			return NewDeploymentInfoServerTransport(&s.srv.DeploymentInfoServer)
		})
		resp, err = s.trDeploymentInfoServer.Do(req)
	case "DetachAndDeleteTrafficFilterClient":
		initServer(s, &s.trDetachAndDeleteTrafficFilterServer, func() *DetachAndDeleteTrafficFilterServerTransport {
			return NewDetachAndDeleteTrafficFilterServerTransport(&s.srv.DetachAndDeleteTrafficFilterServer)
		})
		resp, err = s.trDetachAndDeleteTrafficFilterServer.Do(req)
	case "DetachTrafficFilterClient":
		initServer(s, &s.trDetachTrafficFilterServer, func() *DetachTrafficFilterServerTransport {
			return NewDetachTrafficFilterServerTransport(&s.srv.DetachTrafficFilterServer)
		})
		resp, err = s.trDetachTrafficFilterServer.Do(req)
	case "ExternalUserClient":
		initServer(s, &s.trExternalUserServer, func() *ExternalUserServerTransport { return NewExternalUserServerTransport(&s.srv.ExternalUserServer) })
		resp, err = s.trExternalUserServer.Do(req)
	case "ListAssociatedTrafficFiltersClient":
		initServer(s, &s.trListAssociatedTrafficFiltersServer, func() *ListAssociatedTrafficFiltersServerTransport {
			return NewListAssociatedTrafficFiltersServerTransport(&s.srv.ListAssociatedTrafficFiltersServer)
		})
		resp, err = s.trListAssociatedTrafficFiltersServer.Do(req)
	case "MonitorClient":
		initServer(s, &s.trMonitorServer, func() *MonitorServerTransport { return NewMonitorServerTransport(&s.srv.MonitorServer) })
		resp, err = s.trMonitorServer.Do(req)
	case "MonitoredResourcesClient":
		initServer(s, &s.trMonitoredResourcesServer, func() *MonitoredResourcesServerTransport {
			return NewMonitoredResourcesServerTransport(&s.srv.MonitoredResourcesServer)
		})
		resp, err = s.trMonitoredResourcesServer.Do(req)
	case "MonitorsClient":
		initServer(s, &s.trMonitorsServer, func() *MonitorsServerTransport { return NewMonitorsServerTransport(&s.srv.MonitorsServer) })
		resp, err = s.trMonitorsServer.Do(req)
	case "OperationsClient":
		initServer(s, &s.trOperationsServer, func() *OperationsServerTransport { return NewOperationsServerTransport(&s.srv.OperationsServer) })
		resp, err = s.trOperationsServer.Do(req)
	case "OrganizationsClient":
		initServer(s, &s.trOrganizationsServer, func() *OrganizationsServerTransport {
			return NewOrganizationsServerTransport(&s.srv.OrganizationsServer)
		})
		resp, err = s.trOrganizationsServer.Do(req)
	case "TagRulesClient":
		initServer(s, &s.trTagRulesServer, func() *TagRulesServerTransport { return NewTagRulesServerTransport(&s.srv.TagRulesServer) })
		resp, err = s.trTagRulesServer.Do(req)
	case "TrafficFiltersClient":
		initServer(s, &s.trTrafficFiltersServer, func() *TrafficFiltersServerTransport {
			return NewTrafficFiltersServerTransport(&s.srv.TrafficFiltersServer)
		})
		resp, err = s.trTrafficFiltersServer.Do(req)
	case "UpgradableVersionsClient":
		initServer(s, &s.trUpgradableVersionsServer, func() *UpgradableVersionsServerTransport {
			return NewUpgradableVersionsServerTransport(&s.srv.UpgradableVersionsServer)
		})
		resp, err = s.trUpgradableVersionsServer.Do(req)
	case "VMCollectionClient":
		initServer(s, &s.trVMCollectionServer, func() *VMCollectionServerTransport { return NewVMCollectionServerTransport(&s.srv.VMCollectionServer) })
		resp, err = s.trVMCollectionServer.Do(req)
	case "VMHostClient":
		initServer(s, &s.trVMHostServer, func() *VMHostServerTransport { return NewVMHostServerTransport(&s.srv.VMHostServer) })
		resp, err = s.trVMHostServer.Do(req)
	case "VMIngestionClient":
		initServer(s, &s.trVMIngestionServer, func() *VMIngestionServerTransport { return NewVMIngestionServerTransport(&s.srv.VMIngestionServer) })
		resp, err = s.trVMIngestionServer.Do(req)
	case "VersionsClient":
		initServer(s, &s.trVersionsServer, func() *VersionsServerTransport { return NewVersionsServerTransport(&s.srv.VersionsServer) })
		resp, err = s.trVersionsServer.Do(req)
	default:
		err = fmt.Errorf("unhandled client %s", client)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func initServer[T any](s *ServerFactoryTransport, dst **T, src func() *T) {
	s.trMu.Lock()
	if *dst == nil {
		*dst = src()
	}
	s.trMu.Unlock()
}
