//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armdevcenter

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// ProjectCatalogEnvironmentDefinitionsClient contains the methods for the ProjectCatalogEnvironmentDefinitions group.
// Don't use this type directly, use NewProjectCatalogEnvironmentDefinitionsClient() instead.
type ProjectCatalogEnvironmentDefinitionsClient struct {
	internal       *arm.Client
	subscriptionID string
}

// NewProjectCatalogEnvironmentDefinitionsClient creates a new instance of ProjectCatalogEnvironmentDefinitionsClient with the specified values.
//   - subscriptionID - The ID of the target subscription.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewProjectCatalogEnvironmentDefinitionsClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*ProjectCatalogEnvironmentDefinitionsClient, error) {
	cl, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	client := &ProjectCatalogEnvironmentDefinitionsClient{
		subscriptionID: subscriptionID,
		internal:       cl,
	}
	return client, nil
}

// GetErrorDetails - Gets Environment Definition error details
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2024-02-01
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - projectName - The name of the project.
//   - catalogName - The name of the Catalog.
//   - environmentDefinitionName - The name of the Environment Definition.
//   - options - ProjectCatalogEnvironmentDefinitionsClientGetErrorDetailsOptions contains the optional parameters for the ProjectCatalogEnvironmentDefinitionsClient.GetErrorDetails
//     method.
func (client *ProjectCatalogEnvironmentDefinitionsClient) GetErrorDetails(ctx context.Context, resourceGroupName string, projectName string, catalogName string, environmentDefinitionName string, options *ProjectCatalogEnvironmentDefinitionsClientGetErrorDetailsOptions) (ProjectCatalogEnvironmentDefinitionsClientGetErrorDetailsResponse, error) {
	var err error
	const operationName = "ProjectCatalogEnvironmentDefinitionsClient.GetErrorDetails"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getErrorDetailsCreateRequest(ctx, resourceGroupName, projectName, catalogName, environmentDefinitionName, options)
	if err != nil {
		return ProjectCatalogEnvironmentDefinitionsClientGetErrorDetailsResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return ProjectCatalogEnvironmentDefinitionsClientGetErrorDetailsResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return ProjectCatalogEnvironmentDefinitionsClientGetErrorDetailsResponse{}, err
	}
	resp, err := client.getErrorDetailsHandleResponse(httpResp)
	return resp, err
}

// getErrorDetailsCreateRequest creates the GetErrorDetails request.
func (client *ProjectCatalogEnvironmentDefinitionsClient) getErrorDetailsCreateRequest(ctx context.Context, resourceGroupName string, projectName string, catalogName string, environmentDefinitionName string, options *ProjectCatalogEnvironmentDefinitionsClientGetErrorDetailsOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevCenter/projects/{projectName}/catalogs/{catalogName}/environmentDefinitions/{environmentDefinitionName}/getErrorDetails"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if projectName == "" {
		return nil, errors.New("parameter projectName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{projectName}", url.PathEscape(projectName))
	if catalogName == "" {
		return nil, errors.New("parameter catalogName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{catalogName}", url.PathEscape(catalogName))
	if environmentDefinitionName == "" {
		return nil, errors.New("parameter environmentDefinitionName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{environmentDefinitionName}", url.PathEscape(environmentDefinitionName))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2024-02-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getErrorDetailsHandleResponse handles the GetErrorDetails response.
func (client *ProjectCatalogEnvironmentDefinitionsClient) getErrorDetailsHandleResponse(resp *http.Response) (ProjectCatalogEnvironmentDefinitionsClientGetErrorDetailsResponse, error) {
	result := ProjectCatalogEnvironmentDefinitionsClientGetErrorDetailsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.CatalogResourceValidationErrorDetails); err != nil {
		return ProjectCatalogEnvironmentDefinitionsClientGetErrorDetailsResponse{}, err
	}
	return result, nil
}
