//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
// Code generated by Microsoft (R) AutoRest Code Generator.Changes may cause incorrect behavior and will be lost if the code
// is regenerated.
// Code generated by @autorest/go. DO NOT EDIT.

package armconnectedvmware

import (
	"context"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"strings"
)

// VMInstanceHybridIdentityMetadataClient contains the methods for the VMInstanceHybridIdentityMetadata group.
// Don't use this type directly, use NewVMInstanceHybridIdentityMetadataClient() instead.
type VMInstanceHybridIdentityMetadataClient struct {
	internal *arm.Client
}

// NewVMInstanceHybridIdentityMetadataClient creates a new instance of VMInstanceHybridIdentityMetadataClient with the specified values.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewVMInstanceHybridIdentityMetadataClient(credential azcore.TokenCredential, options *arm.ClientOptions) (*VMInstanceHybridIdentityMetadataClient, error) {
	cl, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	client := &VMInstanceHybridIdentityMetadataClient{
		internal: cl,
	}
	return client, nil
}

// Get - Implements HybridIdentityMetadata GET method.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-10-01
//   - resourceURI - The fully qualified Azure Resource manager identifier of the Hybrid Compute machine resource to be extended.
//   - options - VMInstanceHybridIdentityMetadataClientGetOptions contains the optional parameters for the VMInstanceHybridIdentityMetadataClient.Get
//     method.
func (client *VMInstanceHybridIdentityMetadataClient) Get(ctx context.Context, resourceURI string, options *VMInstanceHybridIdentityMetadataClientGetOptions) (VMInstanceHybridIdentityMetadataClientGetResponse, error) {
	var err error
	const operationName = "VMInstanceHybridIdentityMetadataClient.Get"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getCreateRequest(ctx, resourceURI, options)
	if err != nil {
		return VMInstanceHybridIdentityMetadataClientGetResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return VMInstanceHybridIdentityMetadataClientGetResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return VMInstanceHybridIdentityMetadataClientGetResponse{}, err
	}
	resp, err := client.getHandleResponse(httpResp)
	return resp, err
}

// getCreateRequest creates the Get request.
func (client *VMInstanceHybridIdentityMetadataClient) getCreateRequest(ctx context.Context, resourceURI string, options *VMInstanceHybridIdentityMetadataClientGetOptions) (*policy.Request, error) {
	urlPath := "/{resourceUri}/providers/Microsoft.ConnectedVMwarevSphere/virtualMachineInstances/default/hybridIdentityMetadata/default"
	urlPath = strings.ReplaceAll(urlPath, "{resourceUri}", resourceURI)
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-10-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getHandleResponse handles the Get response.
func (client *VMInstanceHybridIdentityMetadataClient) getHandleResponse(resp *http.Response) (VMInstanceHybridIdentityMetadataClientGetResponse, error) {
	result := VMInstanceHybridIdentityMetadataClientGetResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.VMInstanceHybridIdentityMetadata); err != nil {
		return VMInstanceHybridIdentityMetadataClientGetResponse{}, err
	}
	return result, nil
}

// NewListPager - Returns the list of HybridIdentityMetadata of the given vm.
//
// Generated from API version 2023-10-01
//   - resourceURI - The fully qualified Azure Resource manager identifier of the Hybrid Compute machine resource to be extended.
//   - options - VMInstanceHybridIdentityMetadataClientListOptions contains the optional parameters for the VMInstanceHybridIdentityMetadataClient.NewListPager
//     method.
func (client *VMInstanceHybridIdentityMetadataClient) NewListPager(resourceURI string, options *VMInstanceHybridIdentityMetadataClientListOptions) *runtime.Pager[VMInstanceHybridIdentityMetadataClientListResponse] {
	return runtime.NewPager(runtime.PagingHandler[VMInstanceHybridIdentityMetadataClientListResponse]{
		More: func(page VMInstanceHybridIdentityMetadataClientListResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *VMInstanceHybridIdentityMetadataClientListResponse) (VMInstanceHybridIdentityMetadataClientListResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "VMInstanceHybridIdentityMetadataClient.NewListPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listCreateRequest(ctx, resourceURI, options)
			}, nil)
			if err != nil {
				return VMInstanceHybridIdentityMetadataClientListResponse{}, err
			}
			return client.listHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listCreateRequest creates the List request.
func (client *VMInstanceHybridIdentityMetadataClient) listCreateRequest(ctx context.Context, resourceURI string, options *VMInstanceHybridIdentityMetadataClientListOptions) (*policy.Request, error) {
	urlPath := "/{resourceUri}/providers/Microsoft.ConnectedVMwarevSphere/virtualMachineInstances/default/hybridIdentityMetadata"
	urlPath = strings.ReplaceAll(urlPath, "{resourceUri}", resourceURI)
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-10-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listHandleResponse handles the List response.
func (client *VMInstanceHybridIdentityMetadataClient) listHandleResponse(resp *http.Response) (VMInstanceHybridIdentityMetadataClientListResponse, error) {
	result := VMInstanceHybridIdentityMetadataClientListResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.VMInstanceHybridIdentityMetadataList); err != nil {
		return VMInstanceHybridIdentityMetadataClientListResponse{}, err
	}
	return result, nil
}
