//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armconfluent

import "time"

// APIKeyOwnerEntity - API Key Owner details which can be a user or service account
type APIKeyOwnerEntity struct {
	// API Key owner id
	ID *string

	// Type of the owner service or user account
	Kind *string

	// API URL for accessing or modifying the referred object
	Related *string

	// CRN reference to the referred resource
	ResourceName *string
}

// APIKeyProperties - API Key Properties
type APIKeyProperties struct {
	// Metadata of the record
	Metadata *SCMetadataEntity

	// Specification of the API Key
	Spec *APIKeySpecEntity
}

// APIKeyRecord - Details API key
type APIKeyRecord struct {
	// Id of the api key
	ID *string

	// Type of api key
	Kind *string

	// API Key Properties
	Properties *APIKeyProperties
}

// APIKeyResourceEntity - API Key Resource details which can be kafka cluster or schema registry cluster
type APIKeyResourceEntity struct {
	// The environment of the api key
	Environment *string

	// Id of the resource
	ID *string

	// Type of the owner which can be service or user account
	Kind *string

	// API URL for accessing or modifying the api key resource object
	Related *string

	// CRN reference to the referred resource
	ResourceName *string
}

// APIKeySpecEntity - Spec of the API Key record
type APIKeySpecEntity struct {
	// The description of the API Key
	Description *string

	// The name of the API Key
	Name *string

	// Specification of the cluster
	Owner *APIKeyOwnerEntity

	// Specification of the cluster
	Resource *APIKeyResourceEntity

	// API Key Secret
	Secret *string
}

// AccessCreateRoleBindingRequestModel - Create role binding request model
type AccessCreateRoleBindingRequestModel struct {
	// A CRN that specifies the scope and resource patterns necessary for the role to bind
	CrnPattern *string

	// The principal User or Group to bind the role to
	Principal *string

	// The name of the role to bind to the principal
	RoleName *string
}

// AccessInviteUserAccountModel - Invite User Account model
type AccessInviteUserAccountModel struct {
	// Email of the logged in user
	Email *string

	// Details of the user who is being invited
	InvitedUserDetails *AccessInvitedUserDetails

	// Id of the organization
	OrganizationID *string

	// Upn of the logged in user
	Upn *string
}

// AccessInvitedUserDetails - Details of the user being invited
type AccessInvitedUserDetails struct {
	// Auth type of the user
	AuthType *string

	// UPN/Email of the user who is being invited
	InvitedEmail *string
}

// AccessListClusterSuccessResponse - Details of the clusters returned on successful response
type AccessListClusterSuccessResponse struct {
	// List of clusters
	Data []*ClusterRecord

	// Type of response
	Kind *string

	// Metadata of the list
	Metadata *ListMetadata
}

// AccessListEnvironmentsSuccessResponse - Details of the environments returned on successful response
type AccessListEnvironmentsSuccessResponse struct {
	// Environment list data
	Data []*EnvironmentRecord

	// Type of response
	Kind *string

	// Metadata of the environment list
	Metadata *ListMetadata
}

// AccessListInvitationsSuccessResponse - List invitations success response
type AccessListInvitationsSuccessResponse struct {
	// Data of the invitations list
	Data []*InvitationRecord

	// Type of response
	Kind *string

	// Metadata of the list
	Metadata *ListMetadata
}

// AccessListRoleBindingsSuccessResponse - Details of the role bindings returned on successful response
type AccessListRoleBindingsSuccessResponse struct {
	// List of role binding
	Data []*RoleBindingRecord

	// Type of response
	Kind *string

	// Metadata of the list
	Metadata *ListMetadata
}

// AccessListServiceAccountsSuccessResponse - List service accounts success response
type AccessListServiceAccountsSuccessResponse struct {
	// Data of the service accounts list
	Data []*ServiceAccountRecord

	// Type of response
	Kind *string

	// Metadata of the list
	Metadata *ListMetadata
}

// AccessListUsersSuccessResponse - List users success response
type AccessListUsersSuccessResponse struct {
	// Data of the users list
	Data []*UserRecord

	// Type of response
	Kind *string

	// Metadata of the list
	Metadata *ListMetadata
}

// AccessRoleBindingNameListSuccessResponse - Details of the role binding names returned on successful response
type AccessRoleBindingNameListSuccessResponse struct {
	// List of role binding names
	Data []*string

	// Type of response
	Kind *string

	// Metadata of the list
	Metadata *ListMetadata
}

// AgreementProperties - Terms properties for Marketplace and Confluent.
type AgreementProperties struct {
	// If any version of the terms have been accepted, otherwise false.
	Accepted *bool

	// Link to HTML with Microsoft and Publisher terms.
	LicenseTextLink *string

	// Plan identifier string.
	Plan *string

	// Link to the privacy policy of the publisher.
	PrivacyPolicyLink *string

	// Product identifier string.
	Product *string

	// Publisher identifier string.
	Publisher *string

	// Date and time in UTC of when the terms were accepted. This is empty if Accepted is false.
	RetrieveDatetime *time.Time

	// Terms signature.
	Signature *string
}

// AgreementResource - Agreement Terms definition
type AgreementResource struct {
	// Represents the properties of the resource.
	Properties *AgreementProperties

	// READ-ONLY; The ARM id of the resource.
	ID *string

	// READ-ONLY; The name of the agreement.
	Name *string

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource
	SystemData *SystemData

	// READ-ONLY; The type of the agreement.
	Type *string
}

// AgreementResourceListResponse - Response of a list operation.
type AgreementResourceListResponse struct {
	// Link to the next set of results, if any.
	NextLink *string

	// Results of a list operation.
	Value []*AgreementResource
}

// ClusterByokEntity - The network associated with this object
type ClusterByokEntity struct {
	// ID of the referred resource
	ID *string

	// API URL for accessing or modifying the referred object
	Related *string

	// CRN reference to the referred resource
	ResourceName *string
}

// ClusterConfigEntity - The configuration of the Kafka cluster
type ClusterConfigEntity struct {
	// The lifecycle phase of the cluster
	Kind *string
}

// ClusterEnvironmentEntity - The environment to which cluster belongs
type ClusterEnvironmentEntity struct {
	// Environment of the referred resource
	Environment *string

	// ID of the referred resource
	ID *string

	// API URL for accessing or modifying the referred object
	Related *string

	// CRN reference to the referred resource
	ResourceName *string
}

// ClusterNetworkEntity - The network associated with this object
type ClusterNetworkEntity struct {
	// Environment of the referred resource
	Environment *string

	// ID of the referred resource
	ID *string

	// API URL for accessing or modifying the referred object
	Related *string

	// CRN reference to the referred resource
	ResourceName *string
}

// ClusterProperties - Cluster Properties
type ClusterProperties struct {
	// Metadata of the record
	Metadata *SCMetadataEntity

	// Specification of the cluster
	Spec *SCClusterSpecEntity

	// Specification of the cluster status
	Status *ClusterStatusEntity
}

// ClusterRecord - Details of cluster record
type ClusterRecord struct {
	// Display name of the cluster
	DisplayName *string

	// Id of the cluster
	ID *string

	// Type of cluster
	Kind *string

	// Metadata of the record
	Metadata *MetadataEntity

	// Specification of the cluster
	Spec *ClusterSpecEntity

	// Specification of the cluster
	Status *ClusterStatusEntity
}

// ClusterSpecEntity - Spec of the cluster record
type ClusterSpecEntity struct {
	// The Kafka API cluster endpoint
	APIEndpoint *string

	// The availability zone configuration of the cluster
	Availability *string

	// Specification of the cluster
	Byok *ClusterByokEntity

	// The cloud service provider
	Cloud *string

	// Specification of the cluster
	Config *ClusterConfigEntity

	// The name of the cluster
	DisplayName *string

	// Specification of the cluster
	Environment *ClusterEnvironmentEntity

	// The cluster HTTP request URL.
	HTTPEndpoint *string

	// The bootstrap endpoint used by Kafka clients to connect to the cluster
	KafkaBootstrapEndpoint *string

	// Specification of the cluster
	Network *ClusterNetworkEntity

	// The cloud service provider region
	Region *string

	// type of zone availability
	Zone *string
}

// ClusterStatusEntity - Status of the cluster record
type ClusterStatusEntity struct {
	// The number of Confluent Kafka Units
	Cku *int32

	// The lifecycle phase of the cluster
	Phase *string
}

// CreateAPIKeyModel - Create API Key model
type CreateAPIKeyModel struct {
	// Description of the API Key
	Description *string

	// Name of the API Key
	Name *string
}

// EnvironmentProperties - Environment resource property
type EnvironmentProperties struct {
	// Metadata of the record
	Metadata *SCMetadataEntity
}

// EnvironmentRecord - Details about environment name, metadata and environment id of an environment
type EnvironmentRecord struct {
	// Display name of the user
	DisplayName *string

	// Id of the environment
	ID *string

	// Type of environment
	Kind *string

	// Metadata of the record
	Metadata *MetadataEntity
}

// ErrorResponseBody - Response body of Error
type ErrorResponseBody struct {
	// READ-ONLY; Error code
	Code *string

	// READ-ONLY; Error detail
	Details []*ErrorResponseBody

	// READ-ONLY; Error message
	Message *string

	// READ-ONLY; Error target
	Target *string
}

// GetEnvironmentsResponse - Result of GET request to list Confluent operations.
type GetEnvironmentsResponse struct {
	// URL to get the next set of environment records if there are any.
	NextLink *string

	// List of environments in a confluent organization
	Value []*SCEnvironmentRecord
}

// InvitationRecord - Record of the invitation
type InvitationRecord struct {
	// Accepted date time of the invitation
	AcceptedAt *string

	// Auth type of the user
	AuthType *string

	// Email of the user
	Email *string

	// Expiration date time of the invitation
	ExpiresAt *string

	// Id of the invitation
	ID *string

	// Type of account
	Kind *string

	// Metadata of the record
	Metadata *MetadataEntity

	// Status of the invitation
	Status *string
}

// LinkOrganization - Link an existing Confluent organization
type LinkOrganization struct {
	// REQUIRED; User auth token
	Token *string
}

// ListAccessRequestModel - List Access Request Model
type ListAccessRequestModel struct {
	// Search filters for the request
	SearchFilters map[string]*string
}

// ListClustersSuccessResponse - Result of GET request to list clusters in the environment of a confluent organization
type ListClustersSuccessResponse struct {
	// URL to get the next set of cluster records if there are any.
	NextLink *string

	// List of clusters in an environment of a confluent organization
	Value []*SCClusterRecord
}

// ListMetadata - Metadata of the list
type ListMetadata struct {
	// First page of the list
	First *string

	// Last page of the list
	Last *string

	// Next page of the list
	Next *string

	// Previous page of the list
	Prev *string

	// Total size of the list
	TotalSize *int32
}

// ListRegionsSuccessResponse - Result of POST request to list regions supported by confluent
type ListRegionsSuccessResponse struct {
	// List of regions supported by confluent
	Data []*RegionRecord
}

// ListSchemaRegistryClustersResponse - Result of GET request to list schema registry clusters in the environment of a confluent
// organization
type ListSchemaRegistryClustersResponse struct {
	// URL to get the next set of schema registry cluster records if there are any.
	NextLink *string

	// List of schema registry clusters in an environment of a confluent organization
	Value []*SchemaRegistryClusterRecord
}

// MetadataEntity - Metadata of the data record
type MetadataEntity struct {
	// Created Date Time
	CreatedAt *string

	// Deleted Date time
	DeletedAt *string

	// Resource name of the record
	ResourceName *string

	// Self lookup url
	Self *string

	// Updated Date time
	UpdatedAt *string
}

// OfferDetail - Confluent Offer detail
type OfferDetail struct {
	// REQUIRED; Offer Id
	ID *string

	// REQUIRED; Offer Plan Id
	PlanID *string

	// REQUIRED; Offer Plan Name
	PlanName *string

	// REQUIRED; Publisher Id
	PublisherID *string

	// REQUIRED; Offer Plan Term unit
	TermUnit *string

	// Private Offer Id
	PrivateOfferID *string

	// Array of Private Offer Ids
	PrivateOfferIDs []*string

	// SaaS Offer Status
	Status *SaaSOfferStatus

	// Offer Plan Term Id
	TermID *string
}

// OperationDisplay - The object that represents the operation.
type OperationDisplay struct {
	// Description of the operation, e.g., 'Write confluent'.
	Description *string

	// Operation type, e.g., read, write, delete, etc.
	Operation *string

	// Service provider: Microsoft.Confluent
	Provider *string

	// Type on which the operation is performed, e.g., 'clusters'.
	Resource *string
}

// OperationListResult - Result of GET request to list Confluent operations.
type OperationListResult struct {
	// URL to get the next set of operation list results if there are any.
	NextLink *string

	// List of Confluent operations supported by the Microsoft.Confluent provider.
	Value []*OperationResult
}

// OperationResult - An Confluent REST API operation.
type OperationResult struct {
	// The object that represents the operation.
	Display *OperationDisplay

	// Indicates whether the operation is a data action
	IsDataAction *bool

	// Operation name: {provider}/{resource}/{operation}
	Name *string
}

// OrganizationResource - Organization resource.
type OrganizationResource struct {
	// REQUIRED; Organization resource properties
	Properties *OrganizationResourceProperties

	// Location of Organization resource
	Location *string

	// Organization resource tags
	Tags map[string]*string

	// READ-ONLY; The ARM id of the resource.
	ID *string

	// READ-ONLY; The name of the resource.
	Name *string

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource
	SystemData *SystemData

	// READ-ONLY; The type of the resource.
	Type *string
}

// OrganizationResourceListResult - The response of a list operation.
type OrganizationResourceListResult struct {
	// Link to the next set of results, if any.
	NextLink *string

	// Result of a list operation.
	Value []*OrganizationResource
}

// OrganizationResourceProperties - Organization resource property
type OrganizationResourceProperties struct {
	// REQUIRED; Confluent offer detail
	OfferDetail *OfferDetail

	// REQUIRED; Subscriber detail
	UserDetail *UserDetail

	// Link an existing Confluent organization
	LinkOrganization *LinkOrganization

	// READ-ONLY; The creation time of the resource.
	CreatedTime *time.Time

	// READ-ONLY; Id of the Confluent organization.
	OrganizationID *string

	// READ-ONLY; Provision states for confluent RP
	ProvisioningState *ProvisionState

	// READ-ONLY; SSO url for the Confluent organization.
	SsoURL *string
}

// OrganizationResourceUpdate - Organization Resource update
type OrganizationResourceUpdate struct {
	// ARM resource tags
	Tags map[string]*string
}

// RegionProperties - Region Properties
type RegionProperties struct {
	// Metadata of the record
	Metadata *SCMetadataEntity

	// Specification of the region
	Spec *RegionSpecEntity
}

// RegionRecord - Details of region record
type RegionRecord struct {
	// Id of the cluster
	ID *string

	// Kind of the cluster
	Kind *string

	// Region Properties
	Properties *RegionProperties
}

// RegionSpecEntity - Region spec details
type RegionSpecEntity struct {
	// Cloud provider name
	Cloud *string

	// Display Name of the region
	Name     *string
	Packages []*string

	// Region name
	RegionName *string
}

// ResourceProviderDefaultErrorResponse - Default error response for resource provider
type ResourceProviderDefaultErrorResponse struct {
	// READ-ONLY; Response body of Error
	Error *ErrorResponseBody
}

// RoleBindingRecord - Details on principal, role name and crn pattern of a role binding
type RoleBindingRecord struct {
	// A CRN that specifies the scope and resource patterns necessary for the role to bind
	CrnPattern *string

	// Id of the role binding
	ID *string

	// The type of the resource.
	Kind *string

	// Metadata of the record
	Metadata *MetadataEntity

	// The principal User or Group to bind the role to
	Principal *string

	// The name of the role to bind to the principal
	RoleName *string
}

// SCClusterByokEntity - The network associated with this object
type SCClusterByokEntity struct {
	// ID of the referred resource
	ID *string

	// API URL for accessing or modifying the referred object
	Related *string

	// CRN reference to the referred resource
	ResourceName *string
}

// SCClusterNetworkEnvironmentEntity - The environment or the network to which cluster belongs
type SCClusterNetworkEnvironmentEntity struct {
	// Environment of the referred resource
	Environment *string

	// ID of the referred resource
	ID *string

	// API URL for accessing or modifying the referred object
	Related *string

	// CRN reference to the referred resource
	ResourceName *string
}

// SCClusterRecord - Details of cluster record
type SCClusterRecord struct {
	// Id of the cluster
	ID *string

	// Type of cluster
	Kind *string

	// Display name of the cluster
	Name *string

	// Cluster Properties
	Properties *ClusterProperties
}

// SCClusterSpecEntity - Spec of the cluster record
type SCClusterSpecEntity struct {
	// The Kafka API cluster endpoint
	APIEndpoint *string

	// The availability zone configuration of the cluster
	Availability *string

	// Specification of the cluster byok
	Byok *SCClusterByokEntity

	// The cloud service provider
	Cloud *string

	// Specification of the cluster configuration
	Config *ClusterConfigEntity

	// Specification of the cluster environment
	Environment *SCClusterNetworkEnvironmentEntity

	// The cluster HTTP request URL.
	HTTPEndpoint *string

	// The bootstrap endpoint used by Kafka clients to connect to the cluster
	KafkaBootstrapEndpoint *string

	// The name of the cluster
	Name *string

	// Specification of the cluster network
	Network *SCClusterNetworkEnvironmentEntity

	// The cloud service provider region
	Region *string

	// type of zone availability
	Zone *string
}

// SCConfluentListMetadata - Metadata of the list
type SCConfluentListMetadata struct {
	// First page of the list
	First *string

	// Last page of the list
	Last *string

	// Next page of the list
	Next *string

	// Previous page of the list
	Prev *string

	// Total size of the list
	TotalSize *int32
}

// SCEnvironmentRecord - Details about environment name, metadata and environment id of an environment
type SCEnvironmentRecord struct {
	// Id of the environment
	ID *string

	// Type of environment
	Kind *string

	// Display name of the environment
	Name *string

	// Environment properties
	Properties *EnvironmentProperties
}

// SCMetadataEntity - Metadata of the data record
type SCMetadataEntity struct {
	// Created Date Time
	CreatedTimestamp *string

	// Deleted Date time
	DeletedTimestamp *string

	// Resource name of the record
	ResourceName *string

	// Self lookup url
	Self *string

	// Updated Date time
	UpdatedTimestamp *string
}

// SchemaRegistryClusterEnvironmentRegionEntity - The environment associated with this object
type SchemaRegistryClusterEnvironmentRegionEntity struct {
	// ID of the referred resource
	ID *string

	// API URL for accessing or modifying the referred object
	Related *string

	// CRN reference to the referred resource
	ResourceName *string
}

// SchemaRegistryClusterProperties - Schema Registry Cluster Properties
type SchemaRegistryClusterProperties struct {
	// Metadata of the record
	Metadata *SCMetadataEntity

	// Specification of the schema registry cluster
	Spec *SchemaRegistryClusterSpecEntity

	// Specification of the cluster status
	Status *SchemaRegistryClusterStatusEntity
}

// SchemaRegistryClusterRecord - Details of schema registry cluster record
type SchemaRegistryClusterRecord struct {
	// Id of the cluster
	ID *string

	// Kind of the cluster
	Kind *string

	// Schema Registry Cluster Properties
	Properties *SchemaRegistryClusterProperties
}

// SchemaRegistryClusterSpecEntity - Details of schema registry cluster spec
type SchemaRegistryClusterSpecEntity struct {
	// The cloud service provider
	Cloud *string

	// Environment details of the schema registry cluster
	Environment *SchemaRegistryClusterEnvironmentRegionEntity

	// Http endpoint of the cluster
	HTTPEndpoint *string

	// Name of the schema registry cluster
	Name *string

	// Type of the cluster package Advanced, essentials
	Package *string

	// Region details of the schema registry cluster
	Region *SchemaRegistryClusterEnvironmentRegionEntity
}

// SchemaRegistryClusterStatusEntity - Status of the schema registry cluster record
type SchemaRegistryClusterStatusEntity struct {
	// The lifecycle phase of the cluster
	Phase *string
}

// ServiceAccountRecord - Record of the service account
type ServiceAccountRecord struct {
	// Description of the service account
	Description *string

	// Name of the service account
	DisplayName *string

	// Id of the service account
	ID *string

	// Type of account
	Kind *string

	// Metadata of the record
	Metadata *MetadataEntity
}

// SystemData - Metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// The timestamp of resource creation (UTC).
	CreatedAt *time.Time

	// The identity that created the resource.
	CreatedBy *string

	// The type of identity that created the resource.
	CreatedByType *CreatedByType

	// The timestamp of resource last modification (UTC)
	LastModifiedAt *time.Time

	// The identity that last modified the resource.
	LastModifiedBy *string

	// The type of identity that last modified the resource.
	LastModifiedByType *CreatedByType
}

// UserDetail - Subscriber detail
type UserDetail struct {
	// REQUIRED; Email address
	EmailAddress *string

	// AAD email address
	AADEmail *string

	// First name
	FirstName *string

	// Last name
	LastName *string

	// User principal name
	UserPrincipalName *string
}

// UserRecord - Record of the user
type UserRecord struct {
	// Auth type of the user
	AuthType *string

	// Email of the user
	Email *string

	// Name of the user
	FullName *string

	// Id of the user
	ID *string

	// Type of account
	Kind *string

	// Metadata of the record
	Metadata *MetadataEntity
}

// ValidationResponse - Validation response from the provider
type ValidationResponse struct {
	// Info from the response
	Info map[string]*string
}
