//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armbatch_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/batch/armbatch/v2"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/cf5ad1932d00c7d15497705ad6b71171d3d68b1e/specification/batch/resource-manager/Microsoft.Batch/stable/2024-02-01/examples/CertificateList.json
func ExampleCertificateClient_NewListByBatchAccountPager_listCertificates() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armbatch.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewCertificateClient().NewListByBatchAccountPager("default-azurebatch-japaneast", "sampleacct", &armbatch.CertificateClientListByBatchAccountOptions{Maxresults: nil,
		Select: nil,
		Filter: nil,
	})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.ListCertificatesResult = armbatch.ListCertificatesResult{
		// 	Value: []*armbatch.Certificate{
		// 		{
		// 			Name: to.Ptr("sha1-0a0e4f50d51beadeac1d35afc5116098e7902e6e"),
		// 			Type: to.Ptr("Microsoft.Batch/batchAccounts/certificates"),
		// 			Etag: to.Ptr("W/\"0x8D4EDD5118668F7\""),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/default-azurebatch-japaneast/providers/Microsoft.Batch/batchAccounts/samplecct/certificates/sha1-0a0e4f50d51beadeac1d35afc5116098e7902e6e"),
		// 			Properties: &armbatch.CertificateProperties{
		// 				Format: to.Ptr(armbatch.CertificateFormatPfx),
		// 				Thumbprint: to.Ptr("0a0e4f50d51beadeac1d35afc5116098e7902e6e"),
		// 				ThumbprintAlgorithm: to.Ptr("sha1"),
		// 				ProvisioningState: to.Ptr(armbatch.CertificateProvisioningStateSucceeded),
		// 				ProvisioningStateTransitionTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-07-21T01:47:38.442Z"); return t}()),
		// 				PublicData: to.Ptr("MIICrjCCAZagAwI..."),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/cf5ad1932d00c7d15497705ad6b71171d3d68b1e/specification/batch/resource-manager/Microsoft.Batch/stable/2024-02-01/examples/CertificateListWithFilter.json
func ExampleCertificateClient_NewListByBatchAccountPager_listCertificatesFilterAndSelect() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armbatch.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewCertificateClient().NewListByBatchAccountPager("default-azurebatch-japaneast", "sampleacct", &armbatch.CertificateClientListByBatchAccountOptions{Maxresults: nil,
		Select: to.Ptr("properties/format,properties/provisioningState"),
		Filter: to.Ptr("properties/provisioningStateTransitionTime gt '2017-05-01' or properties/provisioningState eq 'Failed'"),
	})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.ListCertificatesResult = armbatch.ListCertificatesResult{
		// 	Value: []*armbatch.Certificate{
		// 		{
		// 			Name: to.Ptr("sha1-0a0e4f50d51beadeac1d35afc5116098e7902e6e"),
		// 			Type: to.Ptr("Microsoft.Batch/batchAccounts/certificates"),
		// 			Etag: to.Ptr("W/\"0x8D4EDD5118668F7\""),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/default-azurebatch-japaneast/providers/Microsoft.Batch/batchAccounts/samplecct/certificates/sha1-0a0e4f50d51beadeac1d35afc5116098e7902e6e"),
		// 			Properties: &armbatch.CertificateProperties{
		// 				Format: to.Ptr(armbatch.CertificateFormatPfx),
		// 				ProvisioningState: to.Ptr(armbatch.CertificateProvisioningStateSucceeded),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("sha1-aeb228ffb0bf67a793d61dce263ebd16949f15a1"),
		// 			Type: to.Ptr("Microsoft.Batch/batchAccounts/certificates"),
		// 			Etag: to.Ptr("W/\"0x8D4EDD5118572E0\""),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/default-azurebatch-japaneast/providers/Microsoft.Batch/batchAccounts/samplecct/certificates/sha1-aeb228ffb0bf67a793d61dce263ebd16949f15a1"),
		// 			Properties: &armbatch.CertificateProperties{
		// 				Format: to.Ptr(armbatch.CertificateFormatCer),
		// 				ProvisioningState: to.Ptr(armbatch.CertificateProvisioningStateSucceeded),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/cf5ad1932d00c7d15497705ad6b71171d3d68b1e/specification/batch/resource-manager/Microsoft.Batch/stable/2024-02-01/examples/CertificateCreate_Full.json
func ExampleCertificateClient_Create_createCertificateFull() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armbatch.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewCertificateClient().Create(ctx, "default-azurebatch-japaneast", "sampleacct", "sha1-0a0e4f50d51beadeac1d35afc5116098e7902e6e", armbatch.CertificateCreateOrUpdateParameters{
		Properties: &armbatch.CertificateCreateOrUpdateProperties{
			Format:              to.Ptr(armbatch.CertificateFormatPfx),
			Thumbprint:          to.Ptr("0a0e4f50d51beadeac1d35afc5116098e7902e6e"),
			ThumbprintAlgorithm: to.Ptr("sha1"),
			Data:                to.Ptr("MIIJsgIBAzCCCW4GCSqGSIb3DQE..."),
			Password:            to.Ptr("<ExamplePassword>"),
		},
	}, &armbatch.CertificateClientCreateOptions{IfMatch: nil,
		IfNoneMatch: nil,
	})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Certificate = armbatch.Certificate{
	// 	Name: to.Ptr("sha1-0a0e4f50d51beadeac1d35afc5116098e7902e6e"),
	// 	Type: to.Ptr("Microsoft.Batch/batchAccounts/certificates"),
	// 	Etag: to.Ptr("W/\"0x8D4EDD5118668F7\""),
	// 	ID: to.Ptr("/subscriptions/subid/resourceGroups/default-azurebatch-japaneast/providers/Microsoft.Batch/batchAccounts/samplecct/certificates/sha1-0a0e4f50d51beadeac1d35afc5116098e7902e6e"),
	// 	Properties: &armbatch.CertificateProperties{
	// 		Format: to.Ptr(armbatch.CertificateFormatPfx),
	// 		Thumbprint: to.Ptr("0a0e4f50d51beadeac1d35afc5116098e7902e6e"),
	// 		ThumbprintAlgorithm: to.Ptr("sha1"),
	// 		ProvisioningState: to.Ptr(armbatch.CertificateProvisioningStateSucceeded),
	// 		ProvisioningStateTransitionTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-07-21T01:47:38.442Z"); return t}()),
	// 		PublicData: to.Ptr("MIICrjCCAZagAwI..."),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/cf5ad1932d00c7d15497705ad6b71171d3d68b1e/specification/batch/resource-manager/Microsoft.Batch/stable/2024-02-01/examples/CertificateCreate_MinimalCer.json
func ExampleCertificateClient_Create_createCertificateMinimalCer() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armbatch.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewCertificateClient().Create(ctx, "default-azurebatch-japaneast", "sampleacct", "sha1-0a0e4f50d51beadeac1d35afc5116098e7902e6e", armbatch.CertificateCreateOrUpdateParameters{
		Properties: &armbatch.CertificateCreateOrUpdateProperties{
			Format: to.Ptr(armbatch.CertificateFormatCer),
			Data:   to.Ptr("MIICrjCCAZagAwI..."),
		},
	}, &armbatch.CertificateClientCreateOptions{IfMatch: nil,
		IfNoneMatch: nil,
	})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Certificate = armbatch.Certificate{
	// 	Name: to.Ptr("sha1-0a0e4f50d51beadeac1d35afc5116098e7902e6e"),
	// 	Type: to.Ptr("Microsoft.Batch/batchAccounts/certificates"),
	// 	Etag: to.Ptr("W/\"0x8D4EDD5118668F7\""),
	// 	ID: to.Ptr("/subscriptions/subid/resourceGroups/default-azurebatch-japaneast/providers/Microsoft.Batch/batchAccounts/samplecct/certificates/sha1-0a0e4f50d51beadeac1d35afc5116098e7902e6e"),
	// 	Properties: &armbatch.CertificateProperties{
	// 		Format: to.Ptr(armbatch.CertificateFormatCer),
	// 		Thumbprint: to.Ptr("0a0e4f50d51beadeac1d35afc5116098e7902e6e"),
	// 		ThumbprintAlgorithm: to.Ptr("sha1"),
	// 		ProvisioningState: to.Ptr(armbatch.CertificateProvisioningStateSucceeded),
	// 		ProvisioningStateTransitionTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-07-21T01:47:38.442Z"); return t}()),
	// 		PublicData: to.Ptr("MIICrjCCAZagAwI..."),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/cf5ad1932d00c7d15497705ad6b71171d3d68b1e/specification/batch/resource-manager/Microsoft.Batch/stable/2024-02-01/examples/CertificateCreate_Minimal.json
func ExampleCertificateClient_Create_createCertificateMinimalPfx() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armbatch.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewCertificateClient().Create(ctx, "default-azurebatch-japaneast", "sampleacct", "sha1-0a0e4f50d51beadeac1d35afc5116098e7902e6e", armbatch.CertificateCreateOrUpdateParameters{
		Properties: &armbatch.CertificateCreateOrUpdateProperties{
			Data:     to.Ptr("MIIJsgIBAzCCCW4GCSqGSIb3DQE..."),
			Password: to.Ptr("<ExamplePassword>"),
		},
	}, &armbatch.CertificateClientCreateOptions{IfMatch: nil,
		IfNoneMatch: nil,
	})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Certificate = armbatch.Certificate{
	// 	Name: to.Ptr("sha1-0a0e4f50d51beadeac1d35afc5116098e7902e6e"),
	// 	Type: to.Ptr("Microsoft.Batch/batchAccounts/certificates"),
	// 	Etag: to.Ptr("W/\"0x8D4EDD5118668F7\""),
	// 	ID: to.Ptr("/subscriptions/subid/resourceGroups/default-azurebatch-japaneast/providers/Microsoft.Batch/batchAccounts/samplecct/certificates/sha1-0a0e4f50d51beadeac1d35afc5116098e7902e6e"),
	// 	Properties: &armbatch.CertificateProperties{
	// 		Format: to.Ptr(armbatch.CertificateFormatPfx),
	// 		Thumbprint: to.Ptr("0a0e4f50d51beadeac1d35afc5116098e7902e6e"),
	// 		ThumbprintAlgorithm: to.Ptr("sha1"),
	// 		ProvisioningState: to.Ptr(armbatch.CertificateProvisioningStateSucceeded),
	// 		ProvisioningStateTransitionTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-07-21T01:47:38.442Z"); return t}()),
	// 		PublicData: to.Ptr("MIICrjCCAZagAwI..."),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/cf5ad1932d00c7d15497705ad6b71171d3d68b1e/specification/batch/resource-manager/Microsoft.Batch/stable/2024-02-01/examples/CertificateUpdate.json
func ExampleCertificateClient_Update() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armbatch.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewCertificateClient().Update(ctx, "default-azurebatch-japaneast", "sampleacct", "sha1-0a0e4f50d51beadeac1d35afc5116098e7902e6e", armbatch.CertificateCreateOrUpdateParameters{
		Properties: &armbatch.CertificateCreateOrUpdateProperties{
			Data:     to.Ptr("MIIJsgIBAzCCCW4GCSqGSIb3DQE..."),
			Password: to.Ptr("<ExamplePassword>"),
		},
	}, &armbatch.CertificateClientUpdateOptions{IfMatch: nil})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Certificate = armbatch.Certificate{
	// 	Name: to.Ptr("sha1-0a0e4f50d51beadeac1d35afc5116098e7902e6e"),
	// 	Type: to.Ptr("Microsoft.Batch/batchAccounts/certificates"),
	// 	Etag: to.Ptr("W/\"0x8D4EDD5118668F7\""),
	// 	ID: to.Ptr("/subscriptions/subid/resourceGroups/default-azurebatch-japaneast/providers/Microsoft.Batch/batchAccounts/samplecct/certificates/sha1-0a0e4f50d51beadeac1d35afc5116098e7902e6e"),
	// 	Properties: &armbatch.CertificateProperties{
	// 		Format: to.Ptr(armbatch.CertificateFormatPfx),
	// 		Thumbprint: to.Ptr("0a0e4f50d51beadeac1d35afc5116098e7902e6e"),
	// 		ThumbprintAlgorithm: to.Ptr("sha1"),
	// 		ProvisioningState: to.Ptr(armbatch.CertificateProvisioningStateSucceeded),
	// 		ProvisioningStateTransitionTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-07-21T01:47:38.442Z"); return t}()),
	// 		PublicData: to.Ptr("MIICrjCCAZagAwI..."),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/cf5ad1932d00c7d15497705ad6b71171d3d68b1e/specification/batch/resource-manager/Microsoft.Batch/stable/2024-02-01/examples/CertificateDelete.json
func ExampleCertificateClient_BeginDelete() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armbatch.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewCertificateClient().BeginDelete(ctx, "default-azurebatch-japaneast", "sampleacct", "sha1-0a0e4f50d51beadeac1d35afc5116098e7902e6e", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/cf5ad1932d00c7d15497705ad6b71171d3d68b1e/specification/batch/resource-manager/Microsoft.Batch/stable/2024-02-01/examples/CertificateGet.json
func ExampleCertificateClient_Get_getCertificate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armbatch.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewCertificateClient().Get(ctx, "default-azurebatch-japaneast", "sampleacct", "sha1-0a0e4f50d51beadeac1d35afc5116098e7902e6e", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Certificate = armbatch.Certificate{
	// 	Name: to.Ptr("sha1-0a0e4f50d51beadeac1d35afc5116098e7902e6e"),
	// 	Type: to.Ptr("Microsoft.Batch/batchAccounts/certificates"),
	// 	Etag: to.Ptr("W/\"0x8D4EDD5118668F7\""),
	// 	ID: to.Ptr("/subscriptions/subid/resourceGroups/default-azurebatch-japaneast/providers/Microsoft.Batch/batchAccounts/samplecct/certificates/sha1-0a0e4f50d51beadeac1d35afc5116098e7902e6e"),
	// 	Properties: &armbatch.CertificateProperties{
	// 		Format: to.Ptr(armbatch.CertificateFormatPfx),
	// 		Thumbprint: to.Ptr("0a0e4f50d51beadeac1d35afc5116098e7902e6e"),
	// 		ThumbprintAlgorithm: to.Ptr("sha1"),
	// 		ProvisioningState: to.Ptr(armbatch.CertificateProvisioningStateSucceeded),
	// 		ProvisioningStateTransitionTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-07-21T01:47:38.442Z"); return t}()),
	// 		PublicData: to.Ptr("MIICrjCCAZagAwI..."),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/cf5ad1932d00c7d15497705ad6b71171d3d68b1e/specification/batch/resource-manager/Microsoft.Batch/stable/2024-02-01/examples/CertificateGetWithDeletionError.json
func ExampleCertificateClient_Get_getCertificateWithDeletionError() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armbatch.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewCertificateClient().Get(ctx, "default-azurebatch-japaneast", "sampleacct", "sha1-0a0e4f50d51beadeac1d35afc5116098e7902e6e", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Certificate = armbatch.Certificate{
	// 	Name: to.Ptr("sha1-0a0e4f50d51beadeac1d35afc5116098e7902e6e"),
	// 	Type: to.Ptr("Microsoft.Batch/batchAccounts/certificates"),
	// 	Etag: to.Ptr("W/\"0x8D4EDD5118668F7\""),
	// 	ID: to.Ptr("/subscriptions/subid/resourceGroups/default-azurebatch-japaneast/providers/Microsoft.Batch/batchAccounts/samplecct/certificates/sha1-0a0e4f50d51beadeac1d35afc5116098e7902e6e"),
	// 	Properties: &armbatch.CertificateProperties{
	// 		Format: to.Ptr(armbatch.CertificateFormatPfx),
	// 		Thumbprint: to.Ptr("0a0e4f50d51beadeac1d35afc5116098e7902e6e"),
	// 		ThumbprintAlgorithm: to.Ptr("sha1"),
	// 		DeleteCertificateError: &armbatch.DeleteCertificateError{
	// 			Code: to.Ptr("NodesReferencingCertificate"),
	// 			Message: to.Ptr("The specified certificate is being used by the below mentioned node(s)\nRequestId:2dc78afc-b15b-42d2-8c85-39cb61a0799e\nTime:2017-08-28T10:22:52.8633406Z"),
	// 			Target: to.Ptr("BatchAccount"),
	// 			Details: []*armbatch.DeleteCertificateError{
	// 				{
	// 					Code: to.Ptr("Nodes"),
	// 					Message: to.Ptr("node1, node3"),
	// 			}},
	// 		},
	// 		PreviousProvisioningState: to.Ptr(armbatch.CertificateProvisioningStateDeleting),
	// 		PreviousProvisioningStateTransitionTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-07-21T00:15:25.562Z"); return t}()),
	// 		ProvisioningState: to.Ptr(armbatch.CertificateProvisioningStateSucceeded),
	// 		ProvisioningStateTransitionTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-07-21T01:47:38.442Z"); return t}()),
	// 		PublicData: to.Ptr("MIICrjCCAZagAwI..."),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/cf5ad1932d00c7d15497705ad6b71171d3d68b1e/specification/batch/resource-manager/Microsoft.Batch/stable/2024-02-01/examples/CertificateCancelDeletion.json
func ExampleCertificateClient_CancelDeletion() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armbatch.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewCertificateClient().CancelDeletion(ctx, "default-azurebatch-japaneast", "sampleacct", "sha1-0a0e4f50d51beadeac1d35afc5116098e7902e6e", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Certificate = armbatch.Certificate{
	// 	Name: to.Ptr("sha1-0a0e4f50d51beadeac1d35afc5116098e7902e6e"),
	// 	Type: to.Ptr("Microsoft.Batch/batchAccounts/certificates"),
	// 	Etag: to.Ptr("W/\"0x8D4EDD513C3EDBB\""),
	// 	ID: to.Ptr("/subscriptions/subid/resourceGroups/default-azurebatch-japaneast/providers/Microsoft.Batch/batchAccounts/samplecct/certificates/sha1-0a0e4f50d51beadeac1d35afc5116098e7902e6e"),
	// 	Properties: &armbatch.CertificateProperties{
	// 		Format: to.Ptr(armbatch.CertificateFormatPfx),
	// 		Thumbprint: to.Ptr("0a0e4f50d51beadeac1d35afc5116098e7902e6e"),
	// 		ThumbprintAlgorithm: to.Ptr("sha1"),
	// 		PreviousProvisioningState: to.Ptr(armbatch.CertificateProvisioningStateFailed),
	// 		PreviousProvisioningStateTransitionTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-07-21T00:22:54.329Z"); return t}()),
	// 		ProvisioningState: to.Ptr(armbatch.CertificateProvisioningStateSucceeded),
	// 		ProvisioningStateTransitionTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-07-21T01:47:38.442Z"); return t}()),
	// 		PublicData: to.Ptr("MIICrjCCAZagAwI..."),
	// 	},
	// }
}
