//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/appcontainers/armappcontainers/v3"
	"net/http"
	"net/url"
	"regexp"
)

// BuildAuthTokenServer is a fake server for instances of the armappcontainers.BuildAuthTokenClient type.
type BuildAuthTokenServer struct {
	// List is the fake for method BuildAuthTokenClient.List
	// HTTP status codes to indicate success: http.StatusOK
	List func(ctx context.Context, resourceGroupName string, builderName string, buildName string, options *armappcontainers.BuildAuthTokenClientListOptions) (resp azfake.Responder[armappcontainers.BuildAuthTokenClientListResponse], errResp azfake.ErrorResponder)
}

// NewBuildAuthTokenServerTransport creates a new instance of BuildAuthTokenServerTransport with the provided implementation.
// The returned BuildAuthTokenServerTransport instance is connected to an instance of armappcontainers.BuildAuthTokenClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewBuildAuthTokenServerTransport(srv *BuildAuthTokenServer) *BuildAuthTokenServerTransport {
	return &BuildAuthTokenServerTransport{srv: srv}
}

// BuildAuthTokenServerTransport connects instances of armappcontainers.BuildAuthTokenClient to instances of BuildAuthTokenServer.
// Don't use this type directly, use NewBuildAuthTokenServerTransport instead.
type BuildAuthTokenServerTransport struct {
	srv *BuildAuthTokenServer
}

// Do implements the policy.Transporter interface for BuildAuthTokenServerTransport.
func (b *BuildAuthTokenServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "BuildAuthTokenClient.List":
		resp, err = b.dispatchList(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (b *BuildAuthTokenServerTransport) dispatchList(req *http.Request) (*http.Response, error) {
	if b.srv.List == nil {
		return nil, &nonRetriableError{errors.New("fake for method List not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.App/builders/(?P<builderName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/builds/(?P<buildName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/listAuthToken`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	builderNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("builderName")])
	if err != nil {
		return nil, err
	}
	buildNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("buildName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := b.srv.List(req.Context(), resourceGroupNameParam, builderNameParam, buildNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).BuildToken, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
