//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package azmetrics

// MetricUnit - The unit of the metric.
type MetricUnit string

const (
	// MetricUnitBitsPerSecond - Rate unit of binary digits per second.
	MetricUnitBitsPerSecond MetricUnit = "BitsPerSecond"
	// MetricUnitByteSeconds - Unit of data transfer or storage. It is the size of the data in bytes multiplied by the time it
	// takes to transfer or store the data in seconds.
	MetricUnitByteSeconds MetricUnit = "ByteSeconds"
	// MetricUnitBytes - Unit of memory in bytes.
	MetricUnitBytes MetricUnit = "Bytes"
	// MetricUnitBytesPerSecond - Rate unit of memory in bytes per second.
	MetricUnitBytesPerSecond MetricUnit = "BytesPerSecond"
	// MetricUnitCores - Unit of processing power.
	MetricUnitCores MetricUnit = "Cores"
	// MetricUnitCount - Unit of raw quantity.
	MetricUnitCount MetricUnit = "Count"
	// MetricUnitCountPerSecond - Rate unit of raw quantity per second.
	MetricUnitCountPerSecond MetricUnit = "CountPerSecond"
	// MetricUnitMilliCores - Unit of processing power in 1/1000th of a CPU core.
	MetricUnitMilliCores MetricUnit = "MilliCores"
	// MetricUnitMilliSeconds - Unit of time in 1/1000th of a second.
	MetricUnitMilliSeconds MetricUnit = "MilliSeconds"
	// MetricUnitNanoCores - Unit of processing power in one billionth of a CPU core.
	MetricUnitNanoCores MetricUnit = "NanoCores"
	// MetricUnitPercent - Percentage unit.
	MetricUnitPercent MetricUnit = "Percent"
	// MetricUnitSeconds - Unit of time in seconds.
	MetricUnitSeconds MetricUnit = "Seconds"
	// MetricUnitUnspecified - No specified unit.
	MetricUnitUnspecified MetricUnit = "Unspecified"
)

// PossibleMetricUnitValues returns the possible values for the MetricUnit const type.
func PossibleMetricUnitValues() []MetricUnit {
	return []MetricUnit{
		MetricUnitBitsPerSecond,
		MetricUnitByteSeconds,
		MetricUnitBytes,
		MetricUnitBytesPerSecond,
		MetricUnitCores,
		MetricUnitCount,
		MetricUnitCountPerSecond,
		MetricUnitMilliCores,
		MetricUnitMilliSeconds,
		MetricUnitNanoCores,
		MetricUnitPercent,
		MetricUnitSeconds,
		MetricUnitUnspecified,
	}
}
