//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package azsystemevents

// ACSAdvanceMessageDeliveryStatus - The updated message status
type ACSAdvanceMessageDeliveryStatus string

const (
	ACSAdvanceMessageDeliveryStatusDelivered ACSAdvanceMessageDeliveryStatus = "delivered"
	ACSAdvanceMessageDeliveryStatusFailed    ACSAdvanceMessageDeliveryStatus = "failed"
	ACSAdvanceMessageDeliveryStatusRead      ACSAdvanceMessageDeliveryStatus = "read"
	ACSAdvanceMessageDeliveryStatusSent      ACSAdvanceMessageDeliveryStatus = "sent"
	ACSAdvanceMessageDeliveryStatusUnknown   ACSAdvanceMessageDeliveryStatus = "unknown"
	ACSAdvanceMessageDeliveryStatusWarning   ACSAdvanceMessageDeliveryStatus = "warning"
)

// PossibleACSAdvanceMessageDeliveryStatusValues returns the possible values for the AcsAdvanceMessageDeliveryStatus const type.
func PossibleACSAdvanceMessageDeliveryStatusValues() []ACSAdvanceMessageDeliveryStatus {
	return []ACSAdvanceMessageDeliveryStatus{
		ACSAdvanceMessageDeliveryStatusDelivered,
		ACSAdvanceMessageDeliveryStatusFailed,
		ACSAdvanceMessageDeliveryStatusRead,
		ACSAdvanceMessageDeliveryStatusSent,
		ACSAdvanceMessageDeliveryStatusUnknown,
		ACSAdvanceMessageDeliveryStatusWarning,
	}
}

// ACSEmailDeliveryReportStatus - The status of the email. Any value other than Delivered is considered failed.
type ACSEmailDeliveryReportStatus string

const (
	// ACSEmailDeliveryReportStatusBounced - Hard bounce detected while sending the email
	ACSEmailDeliveryReportStatusBounced ACSEmailDeliveryReportStatus = "Bounced"
	// ACSEmailDeliveryReportStatusDelivered - The email was delivered
	ACSEmailDeliveryReportStatusDelivered ACSEmailDeliveryReportStatus = "Delivered"
	// ACSEmailDeliveryReportStatusFailed - The email failed to be delivered
	ACSEmailDeliveryReportStatusFailed ACSEmailDeliveryReportStatus = "Failed"
	// ACSEmailDeliveryReportStatusFilteredSpam - The message was identified spam and was rejected or blocked (not quarantined).
	ACSEmailDeliveryReportStatusFilteredSpam ACSEmailDeliveryReportStatus = "FilteredSpam"
	// ACSEmailDeliveryReportStatusQuarantined - The message was quarantined (as spam, bulk mail, or phishing). For more information,
	// see Quarantined email messages in EOP (EXCHANGE ONLINE PROTECTION).
	ACSEmailDeliveryReportStatusQuarantined ACSEmailDeliveryReportStatus = "Quarantined"
	// ACSEmailDeliveryReportStatusSuppressed - The email was suppressed
	ACSEmailDeliveryReportStatusSuppressed ACSEmailDeliveryReportStatus = "Suppressed"
)

// PossibleACSEmailDeliveryReportStatusValues returns the possible values for the AcsEmailDeliveryReportStatus const type.
func PossibleACSEmailDeliveryReportStatusValues() []ACSEmailDeliveryReportStatus {
	return []ACSEmailDeliveryReportStatus{
		ACSEmailDeliveryReportStatusBounced,
		ACSEmailDeliveryReportStatusDelivered,
		ACSEmailDeliveryReportStatusFailed,
		ACSEmailDeliveryReportStatusFilteredSpam,
		ACSEmailDeliveryReportStatusQuarantined,
		ACSEmailDeliveryReportStatusSuppressed,
	}
}

// ACSInteractiveReplyKind - The Message interactive reply type
type ACSInteractiveReplyKind string

const (
	// ACSInteractiveReplyKindButtonReply - Messaged interactive reply type is ButtonReply
	ACSInteractiveReplyKindButtonReply ACSInteractiveReplyKind = "buttonReply"
	// ACSInteractiveReplyKindListReply - Messaged interactive reply type is ListReply
	ACSInteractiveReplyKindListReply ACSInteractiveReplyKind = "listReply"
	// ACSInteractiveReplyKindUnknown - Messaged interactive reply type is Unknown
	ACSInteractiveReplyKindUnknown ACSInteractiveReplyKind = "unknown"
)

// PossibleACSInteractiveReplyKindValues returns the possible values for the AcsInteractiveReplyKind const type.
func PossibleACSInteractiveReplyKindValues() []ACSInteractiveReplyKind {
	return []ACSInteractiveReplyKind{
		ACSInteractiveReplyKindButtonReply,
		ACSInteractiveReplyKindListReply,
		ACSInteractiveReplyKindUnknown,
	}
}

// ACSMessageChannelKind - The The messaged received channel Kind
type ACSMessageChannelKind string

const (
	// ACSMessageChannelKindWhatsapp - Updated messaged channel type is Whatsapp
	ACSMessageChannelKindWhatsapp ACSMessageChannelKind = "whatsapp"
)

// PossibleACSMessageChannelKindValues returns the possible values for the AcsMessageChannelKind const type.
func PossibleACSMessageChannelKindValues() []ACSMessageChannelKind {
	return []ACSMessageChannelKind{
		ACSMessageChannelKindWhatsapp,
	}
}

// ACSRouterJobStatus - Router Job Received Job Status
type ACSRouterJobStatus string

const (
	ACSRouterJobStatusAssigned              ACSRouterJobStatus = "Assigned"
	ACSRouterJobStatusCancelled             ACSRouterJobStatus = "Cancelled"
	ACSRouterJobStatusClassificationFailed  ACSRouterJobStatus = "ClassificationFailed"
	ACSRouterJobStatusClosed                ACSRouterJobStatus = "Closed"
	ACSRouterJobStatusCompleted             ACSRouterJobStatus = "Completed"
	ACSRouterJobStatusCreated               ACSRouterJobStatus = "Created"
	ACSRouterJobStatusPendingClassification ACSRouterJobStatus = "PendingClassification"
	ACSRouterJobStatusPendingSchedule       ACSRouterJobStatus = "PendingSchedule"
	ACSRouterJobStatusQueued                ACSRouterJobStatus = "Queued"
	ACSRouterJobStatusScheduleFailed        ACSRouterJobStatus = "ScheduleFailed"
	ACSRouterJobStatusScheduled             ACSRouterJobStatus = "Scheduled"
	ACSRouterJobStatusWaitingForActivation  ACSRouterJobStatus = "WaitingForActivation"
)

// PossibleACSRouterJobStatusValues returns the possible values for the AcsRouterJobStatus const type.
func PossibleACSRouterJobStatusValues() []ACSRouterJobStatus {
	return []ACSRouterJobStatus{
		ACSRouterJobStatusAssigned,
		ACSRouterJobStatusCancelled,
		ACSRouterJobStatusClassificationFailed,
		ACSRouterJobStatusClosed,
		ACSRouterJobStatusCompleted,
		ACSRouterJobStatusCreated,
		ACSRouterJobStatusPendingClassification,
		ACSRouterJobStatusPendingSchedule,
		ACSRouterJobStatusQueued,
		ACSRouterJobStatusScheduleFailed,
		ACSRouterJobStatusScheduled,
		ACSRouterJobStatusWaitingForActivation,
	}
}

// ACSRouterLabelOperator - Router Job Worker Selector Label Operator
type ACSRouterLabelOperator string

const (
	// ACSRouterLabelOperatorEqual - =
	ACSRouterLabelOperatorEqual ACSRouterLabelOperator = "Equal"
	// ACSRouterLabelOperatorGreater - >
	ACSRouterLabelOperatorGreater ACSRouterLabelOperator = "Greater"
	// ACSRouterLabelOperatorGreaterThanOrEqual - >=
	ACSRouterLabelOperatorGreaterThanOrEqual ACSRouterLabelOperator = "GreaterThanOrEqual"
	// ACSRouterLabelOperatorLess - <
	ACSRouterLabelOperatorLess ACSRouterLabelOperator = "Less"
	// ACSRouterLabelOperatorLessThanOrEqual - <=
	ACSRouterLabelOperatorLessThanOrEqual ACSRouterLabelOperator = "LessThanOrEqual"
	// ACSRouterLabelOperatorNotEqual - !=
	ACSRouterLabelOperatorNotEqual ACSRouterLabelOperator = "NotEqual"
)

// PossibleACSRouterLabelOperatorValues returns the possible values for the AcsRouterLabelOperator const type.
func PossibleACSRouterLabelOperatorValues() []ACSRouterLabelOperator {
	return []ACSRouterLabelOperator{
		ACSRouterLabelOperatorEqual,
		ACSRouterLabelOperatorGreater,
		ACSRouterLabelOperatorGreaterThanOrEqual,
		ACSRouterLabelOperatorLess,
		ACSRouterLabelOperatorLessThanOrEqual,
		ACSRouterLabelOperatorNotEqual,
	}
}

// ACSRouterUpdatedWorkerProperty - An individual property updated in the Router Worker
type ACSRouterUpdatedWorkerProperty string

const (
	ACSRouterUpdatedWorkerPropertyAvailableForOffers    ACSRouterUpdatedWorkerProperty = "AvailableForOffers"
	ACSRouterUpdatedWorkerPropertyChannelConfigurations ACSRouterUpdatedWorkerProperty = "ChannelConfigurations"
	ACSRouterUpdatedWorkerPropertyLabels                ACSRouterUpdatedWorkerProperty = "Labels"
	ACSRouterUpdatedWorkerPropertyQueueAssignments      ACSRouterUpdatedWorkerProperty = "QueueAssignments"
	ACSRouterUpdatedWorkerPropertyTags                  ACSRouterUpdatedWorkerProperty = "Tags"
	ACSRouterUpdatedWorkerPropertyTotalCapacity         ACSRouterUpdatedWorkerProperty = "TotalCapacity"
)

// PossibleACSRouterUpdatedWorkerPropertyValues returns the possible values for the AcsRouterUpdatedWorkerProperty const type.
func PossibleACSRouterUpdatedWorkerPropertyValues() []ACSRouterUpdatedWorkerProperty {
	return []ACSRouterUpdatedWorkerProperty{
		ACSRouterUpdatedWorkerPropertyAvailableForOffers,
		ACSRouterUpdatedWorkerPropertyChannelConfigurations,
		ACSRouterUpdatedWorkerPropertyLabels,
		ACSRouterUpdatedWorkerPropertyQueueAssignments,
		ACSRouterUpdatedWorkerPropertyTags,
		ACSRouterUpdatedWorkerPropertyTotalCapacity,
	}
}

// ACSRouterWorkerSelectorState - Router Job Worker Selector State
type ACSRouterWorkerSelectorState string

const (
	// ACSRouterWorkerSelectorStateActive - Router Job Worker Selector is Active
	ACSRouterWorkerSelectorStateActive ACSRouterWorkerSelectorState = "active"
	// ACSRouterWorkerSelectorStateExpired - Router Job Worker Selector has Expire
	ACSRouterWorkerSelectorStateExpired ACSRouterWorkerSelectorState = "expired"
)

// PossibleACSRouterWorkerSelectorStateValues returns the possible values for the ACSRouterWorkerSelectorState const type.
func PossibleACSRouterWorkerSelectorStateValues() []ACSRouterWorkerSelectorState {
	return []ACSRouterWorkerSelectorState{
		ACSRouterWorkerSelectorStateActive,
		ACSRouterWorkerSelectorStateExpired,
	}
}

// ACSUserEngagement - The type of engagement user have with email
type ACSUserEngagement string

const (
	ACSUserEngagementClick ACSUserEngagement = "click"
	ACSUserEngagementView  ACSUserEngagement = "view"
)

// PossibleACSUserEngagementValues returns the possible values for the AcsUserEngagement const type.
func PossibleACSUserEngagementValues() []ACSUserEngagement {
	return []ACSUserEngagement{
		ACSUserEngagementClick,
		ACSUserEngagementView,
	}
}

// AppAction - Type of action of the operation.
type AppAction string

const (
	// AppActionChangedAppSettings - There was an operation to change app setting on the web app.
	AppActionChangedAppSettings AppAction = "ChangedAppSettings"
	// AppActionCompleted - The job has completed.
	AppActionCompleted AppAction = "Completed"
	// AppActionFailed - The job has failed to complete.
	AppActionFailed AppAction = "Failed"
	// AppActionRestarted - Web app was restarted.
	AppActionRestarted AppAction = "Restarted"
	// AppActionStarted - The job has started.
	AppActionStarted AppAction = "Started"
	// AppActionStopped - Web app was stopped.
	AppActionStopped AppAction = "Stopped"
)

// PossibleAppActionValues returns the possible values for the AppAction const type.
func PossibleAppActionValues() []AppAction {
	return []AppAction{
		AppActionChangedAppSettings,
		AppActionCompleted,
		AppActionFailed,
		AppActionRestarted,
		AppActionStarted,
		AppActionStopped,
	}
}

// AppServicePlanAction - Type of action on the app service plan.
type AppServicePlanAction string

const (
	// AppServicePlanActionUpdated - App Service plan is being updated.
	AppServicePlanActionUpdated AppServicePlanAction = "Updated"
)

// PossibleAppServicePlanActionValues returns the possible values for the AppServicePlanAction const type.
func PossibleAppServicePlanActionValues() []AppServicePlanAction {
	return []AppServicePlanAction{
		AppServicePlanActionUpdated,
	}
}

// AsyncStatus - Asynchronous operation status of the operation on the app service plan.
type AsyncStatus string

const (
	// AsyncStatusCompleted - Async operation has completed.
	AsyncStatusCompleted AsyncStatus = "Completed"
	// AsyncStatusFailed - Async operation failed to complete.
	AsyncStatusFailed AsyncStatus = "Failed"
	// AsyncStatusStarted - Async operation has started.
	AsyncStatusStarted AsyncStatus = "Started"
)

// PossibleAsyncStatusValues returns the possible values for the AsyncStatus const type.
func PossibleAsyncStatusValues() []AsyncStatus {
	return []AsyncStatus{
		AsyncStatusCompleted,
		AsyncStatusFailed,
		AsyncStatusStarted,
	}
}

// CommunicationCloudEnvironmentModel - The cloud that the identifier belongs to.
type CommunicationCloudEnvironmentModel string

const (
	CommunicationCloudEnvironmentModelDod    CommunicationCloudEnvironmentModel = "dod"
	CommunicationCloudEnvironmentModelGcch   CommunicationCloudEnvironmentModel = "gcch"
	CommunicationCloudEnvironmentModelPublic CommunicationCloudEnvironmentModel = "public"
)

// PossibleCommunicationCloudEnvironmentModelValues returns the possible values for the CommunicationCloudEnvironmentModel const type.
func PossibleCommunicationCloudEnvironmentModelValues() []CommunicationCloudEnvironmentModel {
	return []CommunicationCloudEnvironmentModel{
		CommunicationCloudEnvironmentModelDod,
		CommunicationCloudEnvironmentModelGcch,
		CommunicationCloudEnvironmentModelPublic,
	}
}

// CommunicationIdentifierModelKind - The identifier kind, for example 'communicationUser' or 'phoneNumber'.
type CommunicationIdentifierModelKind string

const (
	CommunicationIdentifierModelKindCommunicationUser  CommunicationIdentifierModelKind = "communicationUser"
	CommunicationIdentifierModelKindMicrosoftTeamsApp  CommunicationIdentifierModelKind = "microsoftTeamsApp"
	CommunicationIdentifierModelKindMicrosoftTeamsUser CommunicationIdentifierModelKind = "microsoftTeamsUser"
	CommunicationIdentifierModelKindPhoneNumber        CommunicationIdentifierModelKind = "phoneNumber"
	CommunicationIdentifierModelKindUnknown            CommunicationIdentifierModelKind = "unknown"
)

// PossibleCommunicationIdentifierModelKindValues returns the possible values for the CommunicationIdentifierModelKind const type.
func PossibleCommunicationIdentifierModelKindValues() []CommunicationIdentifierModelKind {
	return []CommunicationIdentifierModelKind{
		CommunicationIdentifierModelKindCommunicationUser,
		CommunicationIdentifierModelKindMicrosoftTeamsApp,
		CommunicationIdentifierModelKindMicrosoftTeamsUser,
		CommunicationIdentifierModelKindPhoneNumber,
		CommunicationIdentifierModelKindUnknown,
	}
}

// DataBoxStageName - Schema of DataBox Stage Name enumeration.
type DataBoxStageName string

const (
	// DataBoxStageNameCopyCompleted - Copy has completed
	DataBoxStageNameCopyCompleted DataBoxStageName = "CopyCompleted"
	// DataBoxStageNameCopyStarted - Copy has started
	DataBoxStageNameCopyStarted DataBoxStageName = "CopyStarted"
	// DataBoxStageNameOrderCompleted - Order has been completed
	DataBoxStageNameOrderCompleted DataBoxStageName = "OrderCompleted"
)

// PossibleDataBoxStageNameValues returns the possible values for the DataBoxStageName const type.
func PossibleDataBoxStageNameValues() []DataBoxStageName {
	return []DataBoxStageName{
		DataBoxStageNameCopyCompleted,
		DataBoxStageNameCopyStarted,
		DataBoxStageNameOrderCompleted,
	}
}

// EventGridMQTTClientDisconnectionReason - Reason for the disconnection of the MQTT client's session. The value could be
// one of the values in the disconnection reasons table.
type EventGridMQTTClientDisconnectionReason string

const (
	// EventGridMQTTClientDisconnectionReasonClientAuthenticationError - The client got disconnected for any authentication reasons
	// (for example, certificate expired, client got disabled, or client configuration changed).
	EventGridMQTTClientDisconnectionReasonClientAuthenticationError EventGridMQTTClientDisconnectionReason = "ClientAuthenticationError"
	// EventGridMQTTClientDisconnectionReasonClientAuthorizationError - The client got disconnected for any authorization reasons
	// (for example, because of a change in the configuration of topic spaces, permission bindings, or client groups).
	EventGridMQTTClientDisconnectionReasonClientAuthorizationError EventGridMQTTClientDisconnectionReason = "ClientAuthorizationError"
	// EventGridMQTTClientDisconnectionReasonClientError - The client sent a bad request or used one of the unsupported features
	// that resulted in a connection termination by the service.
	EventGridMQTTClientDisconnectionReasonClientError EventGridMQTTClientDisconnectionReason = "ClientError"
	// EventGridMQTTClientDisconnectionReasonClientInitiatedDisconnect - The client initiates a graceful disconnect through a
	// DISCONNECT packet for MQTT or a close frame for MQTT over WebSocket.
	EventGridMQTTClientDisconnectionReasonClientInitiatedDisconnect EventGridMQTTClientDisconnectionReason = "ClientInitiatedDisconnect"
	// EventGridMQTTClientDisconnectionReasonConnectionLost - The client-server connection is lost. (EXCHANGE ONLINE PROTECTION).
	EventGridMQTTClientDisconnectionReasonConnectionLost EventGridMQTTClientDisconnectionReason = "ConnectionLost"
	// EventGridMQTTClientDisconnectionReasonIPForbidden - The client's IP address is blocked by IP filter or Private links configuration.
	EventGridMQTTClientDisconnectionReasonIPForbidden EventGridMQTTClientDisconnectionReason = "IpForbidden"
	// EventGridMQTTClientDisconnectionReasonQuotaExceeded - The client exceeded one or more of the throttling limits that resulted
	// in a connection termination by the service.
	EventGridMQTTClientDisconnectionReasonQuotaExceeded EventGridMQTTClientDisconnectionReason = "QuotaExceeded"
	// EventGridMQTTClientDisconnectionReasonServerError - The connection got terminated due to an unexpected server error.
	EventGridMQTTClientDisconnectionReasonServerError EventGridMQTTClientDisconnectionReason = "ServerError"
	// EventGridMQTTClientDisconnectionReasonServerInitiatedDisconnect - The server initiates a graceful disconnect for any operational
	// reason.
	EventGridMQTTClientDisconnectionReasonServerInitiatedDisconnect EventGridMQTTClientDisconnectionReason = "ServerInitiatedDisconnect"
	// EventGridMQTTClientDisconnectionReasonSessionOverflow - The client's queue for unacknowledged QoS1 messages reached its
	// limit, which resulted in a connection termination by the server.
	EventGridMQTTClientDisconnectionReasonSessionOverflow EventGridMQTTClientDisconnectionReason = "SessionOverflow"
	// EventGridMQTTClientDisconnectionReasonSessionTakenOver - The client reconnected with the same authentication name, which
	// resulted in the termination of the previous connection.
	EventGridMQTTClientDisconnectionReasonSessionTakenOver EventGridMQTTClientDisconnectionReason = "SessionTakenOver"
)

// PossibleEventGridMQTTClientDisconnectionReasonValues returns the possible values for the EventGridMQTTClientDisconnectionReason const type.
func PossibleEventGridMQTTClientDisconnectionReasonValues() []EventGridMQTTClientDisconnectionReason {
	return []EventGridMQTTClientDisconnectionReason{
		EventGridMQTTClientDisconnectionReasonClientAuthenticationError,
		EventGridMQTTClientDisconnectionReasonClientAuthorizationError,
		EventGridMQTTClientDisconnectionReasonClientError,
		EventGridMQTTClientDisconnectionReasonClientInitiatedDisconnect,
		EventGridMQTTClientDisconnectionReasonConnectionLost,
		EventGridMQTTClientDisconnectionReasonIPForbidden,
		EventGridMQTTClientDisconnectionReasonQuotaExceeded,
		EventGridMQTTClientDisconnectionReasonServerError,
		EventGridMQTTClientDisconnectionReasonServerInitiatedDisconnect,
		EventGridMQTTClientDisconnectionReasonSessionOverflow,
		EventGridMQTTClientDisconnectionReasonSessionTakenOver,
	}
}

// EventGridMqttClientState - Configured state of the client. The value could be Enabled or Disabled
type EventGridMqttClientState string

const (
	EventGridMqttClientStateDisabled EventGridMqttClientState = "Disabled"
	EventGridMqttClientStateEnabled  EventGridMqttClientState = "Enabled"
)

// PossibleEventGridMqttClientStateValues returns the possible values for the EventGridMqttClientState const type.
func PossibleEventGridMqttClientStateValues() []EventGridMqttClientState {
	return []EventGridMqttClientState{
		EventGridMqttClientStateDisabled,
		EventGridMqttClientStateEnabled,
	}
}

// HealthcareFhirResourceType - Schema of FHIR resource type enumeration.
type HealthcareFhirResourceType string

const (
	// HealthcareFhirResourceTypeAccount - The FHIR resource type defined in STU3 and R4.
	HealthcareFhirResourceTypeAccount HealthcareFhirResourceType = "Account"
	// HealthcareFhirResourceTypeActivityDefinition - The FHIR resource type defined in STU3 and R4.
	HealthcareFhirResourceTypeActivityDefinition HealthcareFhirResourceType = "ActivityDefinition"
	// HealthcareFhirResourceTypeAdverseEvent - The FHIR resource type defined in STU3 and R4.
	HealthcareFhirResourceTypeAdverseEvent HealthcareFhirResourceType = "AdverseEvent"
	// HealthcareFhirResourceTypeAllergyIntolerance - The FHIR resource type defined in STU3 and R4.
	HealthcareFhirResourceTypeAllergyIntolerance HealthcareFhirResourceType = "AllergyIntolerance"
	// HealthcareFhirResourceTypeAppointment - The FHIR resource type defined in STU3 and R4.
	HealthcareFhirResourceTypeAppointment HealthcareFhirResourceType = "Appointment"
	// HealthcareFhirResourceTypeAppointmentResponse - The FHIR resource type defined in STU3 and R4.
	HealthcareFhirResourceTypeAppointmentResponse HealthcareFhirResourceType = "AppointmentResponse"
	// HealthcareFhirResourceTypeAuditEvent - The FHIR resource type defined in STU3 and R4.
	HealthcareFhirResourceTypeAuditEvent HealthcareFhirResourceType = "AuditEvent"
	// HealthcareFhirResourceTypeBasic - The FHIR resource type defined in STU3 and R4.
	HealthcareFhirResourceTypeBasic HealthcareFhirResourceType = "Basic"
	// HealthcareFhirResourceTypeBinary - The FHIR resource type defined in STU3 and R4.
	HealthcareFhirResourceTypeBinary HealthcareFhirResourceType = "Binary"
	// HealthcareFhirResourceTypeBiologicallyDerivedProduct - The FHIR resource type defined in R4.
	HealthcareFhirResourceTypeBiologicallyDerivedProduct HealthcareFhirResourceType = "BiologicallyDerivedProduct"
	// HealthcareFhirResourceTypeBodySite - The FHIR resource type defined in STU3.
	HealthcareFhirResourceTypeBodySite HealthcareFhirResourceType = "BodySite"
	// HealthcareFhirResourceTypeBodyStructure - The FHIR resource type defined in R4.
	HealthcareFhirResourceTypeBodyStructure HealthcareFhirResourceType = "BodyStructure"
	// HealthcareFhirResourceTypeBundle - The FHIR resource type defined in STU3 and R4.
	HealthcareFhirResourceTypeBundle HealthcareFhirResourceType = "Bundle"
	// HealthcareFhirResourceTypeCapabilityStatement - The FHIR resource type defined in STU3 and R4.
	HealthcareFhirResourceTypeCapabilityStatement HealthcareFhirResourceType = "CapabilityStatement"
	// HealthcareFhirResourceTypeCarePlan - The FHIR resource type defined in STU3 and R4.
	HealthcareFhirResourceTypeCarePlan HealthcareFhirResourceType = "CarePlan"
	// HealthcareFhirResourceTypeCareTeam - The FHIR resource type defined in STU3 and R4.
	HealthcareFhirResourceTypeCareTeam HealthcareFhirResourceType = "CareTeam"
	// HealthcareFhirResourceTypeCatalogEntry - The FHIR resource type defined in R4.
	HealthcareFhirResourceTypeCatalogEntry HealthcareFhirResourceType = "CatalogEntry"
	// HealthcareFhirResourceTypeChargeItem - The FHIR resource type defined in STU3 and R4.
	HealthcareFhirResourceTypeChargeItem HealthcareFhirResourceType = "ChargeItem"
	// HealthcareFhirResourceTypeChargeItemDefinition - The FHIR resource type defined in R4.
	HealthcareFhirResourceTypeChargeItemDefinition HealthcareFhirResourceType = "ChargeItemDefinition"
	// HealthcareFhirResourceTypeClaim - The FHIR resource type defined in STU3 and R4.
	HealthcareFhirResourceTypeClaim HealthcareFhirResourceType = "Claim"
	// HealthcareFhirResourceTypeClaimResponse - The FHIR resource type defined in STU3 and R4.
	HealthcareFhirResourceTypeClaimResponse HealthcareFhirResourceType = "ClaimResponse"
	// HealthcareFhirResourceTypeClinicalImpression - The FHIR resource type defined in STU3 and R4.
	HealthcareFhirResourceTypeClinicalImpression HealthcareFhirResourceType = "ClinicalImpression"
	// HealthcareFhirResourceTypeCodeSystem - The FHIR resource type defined in STU3 and R4.
	HealthcareFhirResourceTypeCodeSystem HealthcareFhirResourceType = "CodeSystem"
	// HealthcareFhirResourceTypeCommunication - The FHIR resource type defined in STU3 and R4.
	HealthcareFhirResourceTypeCommunication HealthcareFhirResourceType = "Communication"
	// HealthcareFhirResourceTypeCommunicationRequest - The FHIR resource type defined in STU3 and R4.
	HealthcareFhirResourceTypeCommunicationRequest HealthcareFhirResourceType = "CommunicationRequest"
	// HealthcareFhirResourceTypeCompartmentDefinition - The FHIR resource type defined in STU3 and R4.
	HealthcareFhirResourceTypeCompartmentDefinition HealthcareFhirResourceType = "CompartmentDefinition"
	// HealthcareFhirResourceTypeComposition - The FHIR resource type defined in STU3 and R4.
	HealthcareFhirResourceTypeComposition HealthcareFhirResourceType = "Composition"
	// HealthcareFhirResourceTypeConceptMap - The FHIR resource type defined in STU3 and R4.
	HealthcareFhirResourceTypeConceptMap HealthcareFhirResourceType = "ConceptMap"
	// HealthcareFhirResourceTypeCondition - The FHIR resource type defined in STU3 and R4.
	HealthcareFhirResourceTypeCondition HealthcareFhirResourceType = "Condition"
	// HealthcareFhirResourceTypeConsent - The FHIR resource type defined in STU3 and R4.
	HealthcareFhirResourceTypeConsent HealthcareFhirResourceType = "Consent"
	// HealthcareFhirResourceTypeContract - The FHIR resource type defined in STU3 and R4.
	HealthcareFhirResourceTypeContract HealthcareFhirResourceType = "Contract"
	// HealthcareFhirResourceTypeCoverage - The FHIR resource type defined in STU3 and R4.
	HealthcareFhirResourceTypeCoverage HealthcareFhirResourceType = "Coverage"
	// HealthcareFhirResourceTypeCoverageEligibilityRequest - The FHIR resource type defined in R4.
	HealthcareFhirResourceTypeCoverageEligibilityRequest HealthcareFhirResourceType = "CoverageEligibilityRequest"
	// HealthcareFhirResourceTypeCoverageEligibilityResponse - The FHIR resource type defined in R4.
	HealthcareFhirResourceTypeCoverageEligibilityResponse HealthcareFhirResourceType = "CoverageEligibilityResponse"
	// HealthcareFhirResourceTypeDataElement - The FHIR resource type defined in STU3.
	HealthcareFhirResourceTypeDataElement HealthcareFhirResourceType = "DataElement"
	// HealthcareFhirResourceTypeDetectedIssue - The FHIR resource type defined in STU3 and R4.
	HealthcareFhirResourceTypeDetectedIssue HealthcareFhirResourceType = "DetectedIssue"
	// HealthcareFhirResourceTypeDevice - The FHIR resource type defined in STU3 and R4.
	HealthcareFhirResourceTypeDevice HealthcareFhirResourceType = "Device"
	// HealthcareFhirResourceTypeDeviceComponent - The FHIR resource type defined in STU3.
	HealthcareFhirResourceTypeDeviceComponent HealthcareFhirResourceType = "DeviceComponent"
	// HealthcareFhirResourceTypeDeviceDefinition - The FHIR resource type defined in R4.
	HealthcareFhirResourceTypeDeviceDefinition HealthcareFhirResourceType = "DeviceDefinition"
	// HealthcareFhirResourceTypeDeviceMetric - The FHIR resource type defined in STU3 and R4.
	HealthcareFhirResourceTypeDeviceMetric HealthcareFhirResourceType = "DeviceMetric"
	// HealthcareFhirResourceTypeDeviceRequest - The FHIR resource type defined in STU3 and R4.
	HealthcareFhirResourceTypeDeviceRequest HealthcareFhirResourceType = "DeviceRequest"
	// HealthcareFhirResourceTypeDeviceUseStatement - The FHIR resource type defined in STU3 and R4.
	HealthcareFhirResourceTypeDeviceUseStatement HealthcareFhirResourceType = "DeviceUseStatement"
	// HealthcareFhirResourceTypeDiagnosticReport - The FHIR resource type defined in STU3 and R4.
	HealthcareFhirResourceTypeDiagnosticReport HealthcareFhirResourceType = "DiagnosticReport"
	// HealthcareFhirResourceTypeDocumentManifest - The FHIR resource type defined in STU3 and R4.
	HealthcareFhirResourceTypeDocumentManifest HealthcareFhirResourceType = "DocumentManifest"
	// HealthcareFhirResourceTypeDocumentReference - The FHIR resource type defined in STU3 and R4.
	HealthcareFhirResourceTypeDocumentReference HealthcareFhirResourceType = "DocumentReference"
	// HealthcareFhirResourceTypeDomainResource - The FHIR resource type defined in STU3 and R4.
	HealthcareFhirResourceTypeDomainResource HealthcareFhirResourceType = "DomainResource"
	// HealthcareFhirResourceTypeEffectEvidenceSynthesis - The FHIR resource type defined in R4.
	HealthcareFhirResourceTypeEffectEvidenceSynthesis HealthcareFhirResourceType = "EffectEvidenceSynthesis"
	// HealthcareFhirResourceTypeEligibilityRequest - The FHIR resource type defined in STU3.
	HealthcareFhirResourceTypeEligibilityRequest HealthcareFhirResourceType = "EligibilityRequest"
	// HealthcareFhirResourceTypeEligibilityResponse - The FHIR resource type defined in STU3.
	HealthcareFhirResourceTypeEligibilityResponse HealthcareFhirResourceType = "EligibilityResponse"
	// HealthcareFhirResourceTypeEncounter - The FHIR resource type defined in STU3 and R4.
	HealthcareFhirResourceTypeEncounter HealthcareFhirResourceType = "Encounter"
	// HealthcareFhirResourceTypeEndpoint - The FHIR resource type defined in STU3 and R4.
	HealthcareFhirResourceTypeEndpoint HealthcareFhirResourceType = "Endpoint"
	// HealthcareFhirResourceTypeEnrollmentRequest - The FHIR resource type defined in STU3 and R4.
	HealthcareFhirResourceTypeEnrollmentRequest HealthcareFhirResourceType = "EnrollmentRequest"
	// HealthcareFhirResourceTypeEnrollmentResponse - The FHIR resource type defined in STU3 and R4.
	HealthcareFhirResourceTypeEnrollmentResponse HealthcareFhirResourceType = "EnrollmentResponse"
	// HealthcareFhirResourceTypeEpisodeOfCare - The FHIR resource type defined in STU3 and R4.
	HealthcareFhirResourceTypeEpisodeOfCare HealthcareFhirResourceType = "EpisodeOfCare"
	// HealthcareFhirResourceTypeEventDefinition - The FHIR resource type defined in R4.
	HealthcareFhirResourceTypeEventDefinition HealthcareFhirResourceType = "EventDefinition"
	// HealthcareFhirResourceTypeEvidence - The FHIR resource type defined in R4.
	HealthcareFhirResourceTypeEvidence HealthcareFhirResourceType = "Evidence"
	// HealthcareFhirResourceTypeEvidenceVariable - The FHIR resource type defined in R4.
	HealthcareFhirResourceTypeEvidenceVariable HealthcareFhirResourceType = "EvidenceVariable"
	// HealthcareFhirResourceTypeExampleScenario - The FHIR resource type defined in R4.
	HealthcareFhirResourceTypeExampleScenario HealthcareFhirResourceType = "ExampleScenario"
	// HealthcareFhirResourceTypeExpansionProfile - The FHIR resource type defined in STU3.
	HealthcareFhirResourceTypeExpansionProfile HealthcareFhirResourceType = "ExpansionProfile"
	// HealthcareFhirResourceTypeExplanationOfBenefit - The FHIR resource type defined in STU3 and R4.
	HealthcareFhirResourceTypeExplanationOfBenefit HealthcareFhirResourceType = "ExplanationOfBenefit"
	// HealthcareFhirResourceTypeFamilyMemberHistory - The FHIR resource type defined in STU3 and R4.
	HealthcareFhirResourceTypeFamilyMemberHistory HealthcareFhirResourceType = "FamilyMemberHistory"
	// HealthcareFhirResourceTypeFlag - The FHIR resource type defined in STU3 and R4.
	HealthcareFhirResourceTypeFlag HealthcareFhirResourceType = "Flag"
	// HealthcareFhirResourceTypeGoal - The FHIR resource type defined in STU3 and R4.
	HealthcareFhirResourceTypeGoal HealthcareFhirResourceType = "Goal"
	// HealthcareFhirResourceTypeGraphDefinition - The FHIR resource type defined in STU3 and R4.
	HealthcareFhirResourceTypeGraphDefinition HealthcareFhirResourceType = "GraphDefinition"
	// HealthcareFhirResourceTypeGroup - The FHIR resource type defined in STU3 and R4.
	HealthcareFhirResourceTypeGroup HealthcareFhirResourceType = "Group"
	// HealthcareFhirResourceTypeGuidanceResponse - The FHIR resource type defined in STU3 and R4.
	HealthcareFhirResourceTypeGuidanceResponse HealthcareFhirResourceType = "GuidanceResponse"
	// HealthcareFhirResourceTypeHealthcareService - The FHIR resource type defined in STU3 and R4.
	HealthcareFhirResourceTypeHealthcareService HealthcareFhirResourceType = "HealthcareService"
	// HealthcareFhirResourceTypeImagingManifest - The FHIR resource type defined in STU3.
	HealthcareFhirResourceTypeImagingManifest HealthcareFhirResourceType = "ImagingManifest"
	// HealthcareFhirResourceTypeImagingStudy - The FHIR resource type defined in STU3 and R4.
	HealthcareFhirResourceTypeImagingStudy HealthcareFhirResourceType = "ImagingStudy"
	// HealthcareFhirResourceTypeImmunization - The FHIR resource type defined in STU3 and R4.
	HealthcareFhirResourceTypeImmunization HealthcareFhirResourceType = "Immunization"
	// HealthcareFhirResourceTypeImmunizationEvaluation - The FHIR resource type defined in R4.
	HealthcareFhirResourceTypeImmunizationEvaluation HealthcareFhirResourceType = "ImmunizationEvaluation"
	// HealthcareFhirResourceTypeImmunizationRecommendation - The FHIR resource type defined in STU3 and R4.
	HealthcareFhirResourceTypeImmunizationRecommendation HealthcareFhirResourceType = "ImmunizationRecommendation"
	// HealthcareFhirResourceTypeImplementationGuide - The FHIR resource type defined in STU3 and R4.
	HealthcareFhirResourceTypeImplementationGuide HealthcareFhirResourceType = "ImplementationGuide"
	// HealthcareFhirResourceTypeInsurancePlan - The FHIR resource type defined in R4.
	HealthcareFhirResourceTypeInsurancePlan HealthcareFhirResourceType = "InsurancePlan"
	// HealthcareFhirResourceTypeInvoice - The FHIR resource type defined in R4.
	HealthcareFhirResourceTypeInvoice HealthcareFhirResourceType = "Invoice"
	// HealthcareFhirResourceTypeLibrary - The FHIR resource type defined in STU3 and R4.
	HealthcareFhirResourceTypeLibrary HealthcareFhirResourceType = "Library"
	// HealthcareFhirResourceTypeLinkage - The FHIR resource type defined in STU3 and R4.
	HealthcareFhirResourceTypeLinkage HealthcareFhirResourceType = "Linkage"
	// HealthcareFhirResourceTypeList - The FHIR resource type defined in STU3 and R4.
	HealthcareFhirResourceTypeList HealthcareFhirResourceType = "List"
	// HealthcareFhirResourceTypeLocation - The FHIR resource type defined in STU3 and R4.
	HealthcareFhirResourceTypeLocation HealthcareFhirResourceType = "Location"
	// HealthcareFhirResourceTypeMeasure - The FHIR resource type defined in STU3 and R4.
	HealthcareFhirResourceTypeMeasure HealthcareFhirResourceType = "Measure"
	// HealthcareFhirResourceTypeMeasureReport - The FHIR resource type defined in STU3 and R4.
	HealthcareFhirResourceTypeMeasureReport HealthcareFhirResourceType = "MeasureReport"
	// HealthcareFhirResourceTypeMedia - The FHIR resource type defined in STU3 and R4.
	HealthcareFhirResourceTypeMedia HealthcareFhirResourceType = "Media"
	// HealthcareFhirResourceTypeMedication - The FHIR resource type defined in STU3 and R4.
	HealthcareFhirResourceTypeMedication HealthcareFhirResourceType = "Medication"
	// HealthcareFhirResourceTypeMedicationAdministration - The FHIR resource type defined in STU3 and R4.
	HealthcareFhirResourceTypeMedicationAdministration HealthcareFhirResourceType = "MedicationAdministration"
	// HealthcareFhirResourceTypeMedicationDispense - The FHIR resource type defined in STU3 and R4.
	HealthcareFhirResourceTypeMedicationDispense HealthcareFhirResourceType = "MedicationDispense"
	// HealthcareFhirResourceTypeMedicationKnowledge - The FHIR resource type defined in R4.
	HealthcareFhirResourceTypeMedicationKnowledge HealthcareFhirResourceType = "MedicationKnowledge"
	// HealthcareFhirResourceTypeMedicationRequest - The FHIR resource type defined in STU3 and R4.
	HealthcareFhirResourceTypeMedicationRequest HealthcareFhirResourceType = "MedicationRequest"
	// HealthcareFhirResourceTypeMedicationStatement - The FHIR resource type defined in STU3 and R4.
	HealthcareFhirResourceTypeMedicationStatement HealthcareFhirResourceType = "MedicationStatement"
	// HealthcareFhirResourceTypeMedicinalProduct - The FHIR resource type defined in R4.
	HealthcareFhirResourceTypeMedicinalProduct HealthcareFhirResourceType = "MedicinalProduct"
	// HealthcareFhirResourceTypeMedicinalProductAuthorization - The FHIR resource type defined in R4.
	HealthcareFhirResourceTypeMedicinalProductAuthorization HealthcareFhirResourceType = "MedicinalProductAuthorization"
	// HealthcareFhirResourceTypeMedicinalProductContraindication - The FHIR resource type defined in R4.
	HealthcareFhirResourceTypeMedicinalProductContraindication HealthcareFhirResourceType = "MedicinalProductContraindication"
	// HealthcareFhirResourceTypeMedicinalProductIndication - The FHIR resource type defined in R4.
	HealthcareFhirResourceTypeMedicinalProductIndication HealthcareFhirResourceType = "MedicinalProductIndication"
	// HealthcareFhirResourceTypeMedicinalProductIngredient - The FHIR resource type defined in R4.
	HealthcareFhirResourceTypeMedicinalProductIngredient HealthcareFhirResourceType = "MedicinalProductIngredient"
	// HealthcareFhirResourceTypeMedicinalProductInteraction - The FHIR resource type defined in R4.
	HealthcareFhirResourceTypeMedicinalProductInteraction HealthcareFhirResourceType = "MedicinalProductInteraction"
	// HealthcareFhirResourceTypeMedicinalProductManufactured - The FHIR resource type defined in R4.
	HealthcareFhirResourceTypeMedicinalProductManufactured HealthcareFhirResourceType = "MedicinalProductManufactured"
	// HealthcareFhirResourceTypeMedicinalProductPackaged - The FHIR resource type defined in R4.
	HealthcareFhirResourceTypeMedicinalProductPackaged HealthcareFhirResourceType = "MedicinalProductPackaged"
	// HealthcareFhirResourceTypeMedicinalProductPharmaceutical - The FHIR resource type defined in R4.
	HealthcareFhirResourceTypeMedicinalProductPharmaceutical HealthcareFhirResourceType = "MedicinalProductPharmaceutical"
	// HealthcareFhirResourceTypeMedicinalProductUndesirableEffect - The FHIR resource type defined in R4.
	HealthcareFhirResourceTypeMedicinalProductUndesirableEffect HealthcareFhirResourceType = "MedicinalProductUndesirableEffect"
	// HealthcareFhirResourceTypeMessageDefinition - The FHIR resource type defined in STU3 and R4.
	HealthcareFhirResourceTypeMessageDefinition HealthcareFhirResourceType = "MessageDefinition"
	// HealthcareFhirResourceTypeMessageHeader - The FHIR resource type defined in STU3 and R4.
	HealthcareFhirResourceTypeMessageHeader HealthcareFhirResourceType = "MessageHeader"
	// HealthcareFhirResourceTypeMolecularSequence - The FHIR resource type defined in R4.
	HealthcareFhirResourceTypeMolecularSequence HealthcareFhirResourceType = "MolecularSequence"
	// HealthcareFhirResourceTypeNamingSystem - The FHIR resource type defined in STU3 and R4.
	HealthcareFhirResourceTypeNamingSystem HealthcareFhirResourceType = "NamingSystem"
	// HealthcareFhirResourceTypeNutritionOrder - The FHIR resource type defined in STU3 and R4.
	HealthcareFhirResourceTypeNutritionOrder HealthcareFhirResourceType = "NutritionOrder"
	// HealthcareFhirResourceTypeObservation - The FHIR resource type defined in STU3 and R4.
	HealthcareFhirResourceTypeObservation HealthcareFhirResourceType = "Observation"
	// HealthcareFhirResourceTypeObservationDefinition - The FHIR resource type defined in R4.
	HealthcareFhirResourceTypeObservationDefinition HealthcareFhirResourceType = "ObservationDefinition"
	// HealthcareFhirResourceTypeOperationDefinition - The FHIR resource type defined in STU3 and R4.
	HealthcareFhirResourceTypeOperationDefinition HealthcareFhirResourceType = "OperationDefinition"
	// HealthcareFhirResourceTypeOperationOutcome - The FHIR resource type defined in STU3 and R4.
	HealthcareFhirResourceTypeOperationOutcome HealthcareFhirResourceType = "OperationOutcome"
	// HealthcareFhirResourceTypeOrganization - The FHIR resource type defined in STU3 and R4.
	HealthcareFhirResourceTypeOrganization HealthcareFhirResourceType = "Organization"
	// HealthcareFhirResourceTypeOrganizationAffiliation - The FHIR resource type defined in R4.
	HealthcareFhirResourceTypeOrganizationAffiliation HealthcareFhirResourceType = "OrganizationAffiliation"
	// HealthcareFhirResourceTypeParameters - The FHIR resource type defined in STU3 and R4.
	HealthcareFhirResourceTypeParameters HealthcareFhirResourceType = "Parameters"
	// HealthcareFhirResourceTypePatient - The FHIR resource type defined in STU3 and R4.
	HealthcareFhirResourceTypePatient HealthcareFhirResourceType = "Patient"
	// HealthcareFhirResourceTypePaymentNotice - The FHIR resource type defined in STU3 and R4.
	HealthcareFhirResourceTypePaymentNotice HealthcareFhirResourceType = "PaymentNotice"
	// HealthcareFhirResourceTypePaymentReconciliation - The FHIR resource type defined in STU3 and R4.
	HealthcareFhirResourceTypePaymentReconciliation HealthcareFhirResourceType = "PaymentReconciliation"
	// HealthcareFhirResourceTypePerson - The FHIR resource type defined in STU3 and R4.
	HealthcareFhirResourceTypePerson HealthcareFhirResourceType = "Person"
	// HealthcareFhirResourceTypePlanDefinition - The FHIR resource type defined in STU3 and R4.
	HealthcareFhirResourceTypePlanDefinition HealthcareFhirResourceType = "PlanDefinition"
	// HealthcareFhirResourceTypePractitioner - The FHIR resource type defined in STU3 and R4.
	HealthcareFhirResourceTypePractitioner HealthcareFhirResourceType = "Practitioner"
	// HealthcareFhirResourceTypePractitionerRole - The FHIR resource type defined in STU3 and R4.
	HealthcareFhirResourceTypePractitionerRole HealthcareFhirResourceType = "PractitionerRole"
	// HealthcareFhirResourceTypeProcedure - The FHIR resource type defined in STU3 and R4.
	HealthcareFhirResourceTypeProcedure HealthcareFhirResourceType = "Procedure"
	// HealthcareFhirResourceTypeProcedureRequest - The FHIR resource type defined in STU3.
	HealthcareFhirResourceTypeProcedureRequest HealthcareFhirResourceType = "ProcedureRequest"
	// HealthcareFhirResourceTypeProcessRequest - The FHIR resource type defined in STU3.
	HealthcareFhirResourceTypeProcessRequest HealthcareFhirResourceType = "ProcessRequest"
	// HealthcareFhirResourceTypeProcessResponse - The FHIR resource type defined in STU3.
	HealthcareFhirResourceTypeProcessResponse HealthcareFhirResourceType = "ProcessResponse"
	// HealthcareFhirResourceTypeProvenance - The FHIR resource type defined in STU3 and R4.
	HealthcareFhirResourceTypeProvenance HealthcareFhirResourceType = "Provenance"
	// HealthcareFhirResourceTypeQuestionnaire - The FHIR resource type defined in STU3 and R4.
	HealthcareFhirResourceTypeQuestionnaire HealthcareFhirResourceType = "Questionnaire"
	// HealthcareFhirResourceTypeQuestionnaireResponse - The FHIR resource type defined in STU3 and R4.
	HealthcareFhirResourceTypeQuestionnaireResponse HealthcareFhirResourceType = "QuestionnaireResponse"
	// HealthcareFhirResourceTypeReferralRequest - The FHIR resource type defined in STU3.
	HealthcareFhirResourceTypeReferralRequest HealthcareFhirResourceType = "ReferralRequest"
	// HealthcareFhirResourceTypeRelatedPerson - The FHIR resource type defined in STU3 and R4.
	HealthcareFhirResourceTypeRelatedPerson HealthcareFhirResourceType = "RelatedPerson"
	// HealthcareFhirResourceTypeRequestGroup - The FHIR resource type defined in STU3 and R4.
	HealthcareFhirResourceTypeRequestGroup HealthcareFhirResourceType = "RequestGroup"
	// HealthcareFhirResourceTypeResearchDefinition - The FHIR resource type defined in R4.
	HealthcareFhirResourceTypeResearchDefinition HealthcareFhirResourceType = "ResearchDefinition"
	// HealthcareFhirResourceTypeResearchElementDefinition - The FHIR resource type defined in R4.
	HealthcareFhirResourceTypeResearchElementDefinition HealthcareFhirResourceType = "ResearchElementDefinition"
	// HealthcareFhirResourceTypeResearchStudy - The FHIR resource type defined in STU3 and R4.
	HealthcareFhirResourceTypeResearchStudy HealthcareFhirResourceType = "ResearchStudy"
	// HealthcareFhirResourceTypeResearchSubject - The FHIR resource type defined in STU3 and R4.
	HealthcareFhirResourceTypeResearchSubject HealthcareFhirResourceType = "ResearchSubject"
	// HealthcareFhirResourceTypeResource - The FHIR resource type defined in STU3 and R4.
	HealthcareFhirResourceTypeResource HealthcareFhirResourceType = "Resource"
	// HealthcareFhirResourceTypeRiskAssessment - The FHIR resource type defined in STU3 and R4.
	HealthcareFhirResourceTypeRiskAssessment HealthcareFhirResourceType = "RiskAssessment"
	// HealthcareFhirResourceTypeRiskEvidenceSynthesis - The FHIR resource type defined in R4.
	HealthcareFhirResourceTypeRiskEvidenceSynthesis HealthcareFhirResourceType = "RiskEvidenceSynthesis"
	// HealthcareFhirResourceTypeSchedule - The FHIR resource type defined in STU3 and R4.
	HealthcareFhirResourceTypeSchedule HealthcareFhirResourceType = "Schedule"
	// HealthcareFhirResourceTypeSearchParameter - The FHIR resource type defined in STU3 and R4.
	HealthcareFhirResourceTypeSearchParameter HealthcareFhirResourceType = "SearchParameter"
	// HealthcareFhirResourceTypeSequence - The FHIR resource type defined in STU3.
	HealthcareFhirResourceTypeSequence HealthcareFhirResourceType = "Sequence"
	// HealthcareFhirResourceTypeServiceDefinition - The FHIR resource type defined in STU3.
	HealthcareFhirResourceTypeServiceDefinition HealthcareFhirResourceType = "ServiceDefinition"
	// HealthcareFhirResourceTypeServiceRequest - The FHIR resource type defined in R4.
	HealthcareFhirResourceTypeServiceRequest HealthcareFhirResourceType = "ServiceRequest"
	// HealthcareFhirResourceTypeSlot - The FHIR resource type defined in STU3 and R4.
	HealthcareFhirResourceTypeSlot HealthcareFhirResourceType = "Slot"
	// HealthcareFhirResourceTypeSpecimen - The FHIR resource type defined in STU3 and R4.
	HealthcareFhirResourceTypeSpecimen HealthcareFhirResourceType = "Specimen"
	// HealthcareFhirResourceTypeSpecimenDefinition - The FHIR resource type defined in R4.
	HealthcareFhirResourceTypeSpecimenDefinition HealthcareFhirResourceType = "SpecimenDefinition"
	// HealthcareFhirResourceTypeStructureDefinition - The FHIR resource type defined in STU3 and R4.
	HealthcareFhirResourceTypeStructureDefinition HealthcareFhirResourceType = "StructureDefinition"
	// HealthcareFhirResourceTypeStructureMap - The FHIR resource type defined in STU3 and R4.
	HealthcareFhirResourceTypeStructureMap HealthcareFhirResourceType = "StructureMap"
	// HealthcareFhirResourceTypeSubscription - The FHIR resource type defined in STU3 and R4.
	HealthcareFhirResourceTypeSubscription HealthcareFhirResourceType = "Subscription"
	// HealthcareFhirResourceTypeSubstance - The FHIR resource type defined in STU3 and R4.
	HealthcareFhirResourceTypeSubstance HealthcareFhirResourceType = "Substance"
	// HealthcareFhirResourceTypeSubstanceNucleicAcid - The FHIR resource type defined in R4.
	HealthcareFhirResourceTypeSubstanceNucleicAcid HealthcareFhirResourceType = "SubstanceNucleicAcid"
	// HealthcareFhirResourceTypeSubstancePolymer - The FHIR resource type defined in R4.
	HealthcareFhirResourceTypeSubstancePolymer HealthcareFhirResourceType = "SubstancePolymer"
	// HealthcareFhirResourceTypeSubstanceProtein - The FHIR resource type defined in R4.
	HealthcareFhirResourceTypeSubstanceProtein HealthcareFhirResourceType = "SubstanceProtein"
	// HealthcareFhirResourceTypeSubstanceReferenceInformation - The FHIR resource type defined in R4.
	HealthcareFhirResourceTypeSubstanceReferenceInformation HealthcareFhirResourceType = "SubstanceReferenceInformation"
	// HealthcareFhirResourceTypeSubstanceSourceMaterial - The FHIR resource type defined in R4.
	HealthcareFhirResourceTypeSubstanceSourceMaterial HealthcareFhirResourceType = "SubstanceSourceMaterial"
	// HealthcareFhirResourceTypeSubstanceSpecification - The FHIR resource type defined in R4.
	HealthcareFhirResourceTypeSubstanceSpecification HealthcareFhirResourceType = "SubstanceSpecification"
	// HealthcareFhirResourceTypeSupplyDelivery - The FHIR resource type defined in STU3 and R4.
	HealthcareFhirResourceTypeSupplyDelivery HealthcareFhirResourceType = "SupplyDelivery"
	// HealthcareFhirResourceTypeSupplyRequest - The FHIR resource type defined in STU3 and R4.
	HealthcareFhirResourceTypeSupplyRequest HealthcareFhirResourceType = "SupplyRequest"
	// HealthcareFhirResourceTypeTask - The FHIR resource type defined in STU3 and R4.
	HealthcareFhirResourceTypeTask HealthcareFhirResourceType = "Task"
	// HealthcareFhirResourceTypeTerminologyCapabilities - The FHIR resource type defined in R4.
	HealthcareFhirResourceTypeTerminologyCapabilities HealthcareFhirResourceType = "TerminologyCapabilities"
	// HealthcareFhirResourceTypeTestReport - The FHIR resource type defined in STU3 and R4.
	HealthcareFhirResourceTypeTestReport HealthcareFhirResourceType = "TestReport"
	// HealthcareFhirResourceTypeTestScript - The FHIR resource type defined in STU3 and R4.
	HealthcareFhirResourceTypeTestScript HealthcareFhirResourceType = "TestScript"
	// HealthcareFhirResourceTypeValueSet - The FHIR resource type defined in STU3 and R4.
	HealthcareFhirResourceTypeValueSet HealthcareFhirResourceType = "ValueSet"
	// HealthcareFhirResourceTypeVerificationResult - The FHIR resource type defined in R4.
	HealthcareFhirResourceTypeVerificationResult HealthcareFhirResourceType = "VerificationResult"
	// HealthcareFhirResourceTypeVisionPrescription - The FHIR resource type defined in STU3 and R4.
	HealthcareFhirResourceTypeVisionPrescription HealthcareFhirResourceType = "VisionPrescription"
)

// PossibleHealthcareFhirResourceTypeValues returns the possible values for the HealthcareFhirResourceType const type.
func PossibleHealthcareFhirResourceTypeValues() []HealthcareFhirResourceType {
	return []HealthcareFhirResourceType{
		HealthcareFhirResourceTypeAccount,
		HealthcareFhirResourceTypeActivityDefinition,
		HealthcareFhirResourceTypeAdverseEvent,
		HealthcareFhirResourceTypeAllergyIntolerance,
		HealthcareFhirResourceTypeAppointment,
		HealthcareFhirResourceTypeAppointmentResponse,
		HealthcareFhirResourceTypeAuditEvent,
		HealthcareFhirResourceTypeBasic,
		HealthcareFhirResourceTypeBinary,
		HealthcareFhirResourceTypeBiologicallyDerivedProduct,
		HealthcareFhirResourceTypeBodySite,
		HealthcareFhirResourceTypeBodyStructure,
		HealthcareFhirResourceTypeBundle,
		HealthcareFhirResourceTypeCapabilityStatement,
		HealthcareFhirResourceTypeCarePlan,
		HealthcareFhirResourceTypeCareTeam,
		HealthcareFhirResourceTypeCatalogEntry,
		HealthcareFhirResourceTypeChargeItem,
		HealthcareFhirResourceTypeChargeItemDefinition,
		HealthcareFhirResourceTypeClaim,
		HealthcareFhirResourceTypeClaimResponse,
		HealthcareFhirResourceTypeClinicalImpression,
		HealthcareFhirResourceTypeCodeSystem,
		HealthcareFhirResourceTypeCommunication,
		HealthcareFhirResourceTypeCommunicationRequest,
		HealthcareFhirResourceTypeCompartmentDefinition,
		HealthcareFhirResourceTypeComposition,
		HealthcareFhirResourceTypeConceptMap,
		HealthcareFhirResourceTypeCondition,
		HealthcareFhirResourceTypeConsent,
		HealthcareFhirResourceTypeContract,
		HealthcareFhirResourceTypeCoverage,
		HealthcareFhirResourceTypeCoverageEligibilityRequest,
		HealthcareFhirResourceTypeCoverageEligibilityResponse,
		HealthcareFhirResourceTypeDataElement,
		HealthcareFhirResourceTypeDetectedIssue,
		HealthcareFhirResourceTypeDevice,
		HealthcareFhirResourceTypeDeviceComponent,
		HealthcareFhirResourceTypeDeviceDefinition,
		HealthcareFhirResourceTypeDeviceMetric,
		HealthcareFhirResourceTypeDeviceRequest,
		HealthcareFhirResourceTypeDeviceUseStatement,
		HealthcareFhirResourceTypeDiagnosticReport,
		HealthcareFhirResourceTypeDocumentManifest,
		HealthcareFhirResourceTypeDocumentReference,
		HealthcareFhirResourceTypeDomainResource,
		HealthcareFhirResourceTypeEffectEvidenceSynthesis,
		HealthcareFhirResourceTypeEligibilityRequest,
		HealthcareFhirResourceTypeEligibilityResponse,
		HealthcareFhirResourceTypeEncounter,
		HealthcareFhirResourceTypeEndpoint,
		HealthcareFhirResourceTypeEnrollmentRequest,
		HealthcareFhirResourceTypeEnrollmentResponse,
		HealthcareFhirResourceTypeEpisodeOfCare,
		HealthcareFhirResourceTypeEventDefinition,
		HealthcareFhirResourceTypeEvidence,
		HealthcareFhirResourceTypeEvidenceVariable,
		HealthcareFhirResourceTypeExampleScenario,
		HealthcareFhirResourceTypeExpansionProfile,
		HealthcareFhirResourceTypeExplanationOfBenefit,
		HealthcareFhirResourceTypeFamilyMemberHistory,
		HealthcareFhirResourceTypeFlag,
		HealthcareFhirResourceTypeGoal,
		HealthcareFhirResourceTypeGraphDefinition,
		HealthcareFhirResourceTypeGroup,
		HealthcareFhirResourceTypeGuidanceResponse,
		HealthcareFhirResourceTypeHealthcareService,
		HealthcareFhirResourceTypeImagingManifest,
		HealthcareFhirResourceTypeImagingStudy,
		HealthcareFhirResourceTypeImmunization,
		HealthcareFhirResourceTypeImmunizationEvaluation,
		HealthcareFhirResourceTypeImmunizationRecommendation,
		HealthcareFhirResourceTypeImplementationGuide,
		HealthcareFhirResourceTypeInsurancePlan,
		HealthcareFhirResourceTypeInvoice,
		HealthcareFhirResourceTypeLibrary,
		HealthcareFhirResourceTypeLinkage,
		HealthcareFhirResourceTypeList,
		HealthcareFhirResourceTypeLocation,
		HealthcareFhirResourceTypeMeasure,
		HealthcareFhirResourceTypeMeasureReport,
		HealthcareFhirResourceTypeMedia,
		HealthcareFhirResourceTypeMedication,
		HealthcareFhirResourceTypeMedicationAdministration,
		HealthcareFhirResourceTypeMedicationDispense,
		HealthcareFhirResourceTypeMedicationKnowledge,
		HealthcareFhirResourceTypeMedicationRequest,
		HealthcareFhirResourceTypeMedicationStatement,
		HealthcareFhirResourceTypeMedicinalProduct,
		HealthcareFhirResourceTypeMedicinalProductAuthorization,
		HealthcareFhirResourceTypeMedicinalProductContraindication,
		HealthcareFhirResourceTypeMedicinalProductIndication,
		HealthcareFhirResourceTypeMedicinalProductIngredient,
		HealthcareFhirResourceTypeMedicinalProductInteraction,
		HealthcareFhirResourceTypeMedicinalProductManufactured,
		HealthcareFhirResourceTypeMedicinalProductPackaged,
		HealthcareFhirResourceTypeMedicinalProductPharmaceutical,
		HealthcareFhirResourceTypeMedicinalProductUndesirableEffect,
		HealthcareFhirResourceTypeMessageDefinition,
		HealthcareFhirResourceTypeMessageHeader,
		HealthcareFhirResourceTypeMolecularSequence,
		HealthcareFhirResourceTypeNamingSystem,
		HealthcareFhirResourceTypeNutritionOrder,
		HealthcareFhirResourceTypeObservation,
		HealthcareFhirResourceTypeObservationDefinition,
		HealthcareFhirResourceTypeOperationDefinition,
		HealthcareFhirResourceTypeOperationOutcome,
		HealthcareFhirResourceTypeOrganization,
		HealthcareFhirResourceTypeOrganizationAffiliation,
		HealthcareFhirResourceTypeParameters,
		HealthcareFhirResourceTypePatient,
		HealthcareFhirResourceTypePaymentNotice,
		HealthcareFhirResourceTypePaymentReconciliation,
		HealthcareFhirResourceTypePerson,
		HealthcareFhirResourceTypePlanDefinition,
		HealthcareFhirResourceTypePractitioner,
		HealthcareFhirResourceTypePractitionerRole,
		HealthcareFhirResourceTypeProcedure,
		HealthcareFhirResourceTypeProcedureRequest,
		HealthcareFhirResourceTypeProcessRequest,
		HealthcareFhirResourceTypeProcessResponse,
		HealthcareFhirResourceTypeProvenance,
		HealthcareFhirResourceTypeQuestionnaire,
		HealthcareFhirResourceTypeQuestionnaireResponse,
		HealthcareFhirResourceTypeReferralRequest,
		HealthcareFhirResourceTypeRelatedPerson,
		HealthcareFhirResourceTypeRequestGroup,
		HealthcareFhirResourceTypeResearchDefinition,
		HealthcareFhirResourceTypeResearchElementDefinition,
		HealthcareFhirResourceTypeResearchStudy,
		HealthcareFhirResourceTypeResearchSubject,
		HealthcareFhirResourceTypeResource,
		HealthcareFhirResourceTypeRiskAssessment,
		HealthcareFhirResourceTypeRiskEvidenceSynthesis,
		HealthcareFhirResourceTypeSchedule,
		HealthcareFhirResourceTypeSearchParameter,
		HealthcareFhirResourceTypeSequence,
		HealthcareFhirResourceTypeServiceDefinition,
		HealthcareFhirResourceTypeServiceRequest,
		HealthcareFhirResourceTypeSlot,
		HealthcareFhirResourceTypeSpecimen,
		HealthcareFhirResourceTypeSpecimenDefinition,
		HealthcareFhirResourceTypeStructureDefinition,
		HealthcareFhirResourceTypeStructureMap,
		HealthcareFhirResourceTypeSubscription,
		HealthcareFhirResourceTypeSubstance,
		HealthcareFhirResourceTypeSubstanceNucleicAcid,
		HealthcareFhirResourceTypeSubstancePolymer,
		HealthcareFhirResourceTypeSubstanceProtein,
		HealthcareFhirResourceTypeSubstanceReferenceInformation,
		HealthcareFhirResourceTypeSubstanceSourceMaterial,
		HealthcareFhirResourceTypeSubstanceSpecification,
		HealthcareFhirResourceTypeSupplyDelivery,
		HealthcareFhirResourceTypeSupplyRequest,
		HealthcareFhirResourceTypeTask,
		HealthcareFhirResourceTypeTerminologyCapabilities,
		HealthcareFhirResourceTypeTestReport,
		HealthcareFhirResourceTypeTestScript,
		HealthcareFhirResourceTypeValueSet,
		HealthcareFhirResourceTypeVerificationResult,
		HealthcareFhirResourceTypeVisionPrescription,
	}
}

// MediaJobErrorCategory - Helps with categorization of errors.
type MediaJobErrorCategory string

const (
	// MediaJobErrorCategoryAccount - The error is related to account information.
	MediaJobErrorCategoryAccount MediaJobErrorCategory = "Account"
	// MediaJobErrorCategoryConfiguration - The error is configuration related.
	MediaJobErrorCategoryConfiguration MediaJobErrorCategory = "Configuration"
	// MediaJobErrorCategoryContent - The error is related to data in the input files.
	MediaJobErrorCategoryContent MediaJobErrorCategory = "Content"
	// MediaJobErrorCategoryDownload - The error is download related.
	MediaJobErrorCategoryDownload MediaJobErrorCategory = "Download"
	// MediaJobErrorCategoryService - The error is service related.
	MediaJobErrorCategoryService MediaJobErrorCategory = "Service"
	// MediaJobErrorCategoryUpload - The error is upload related.
	MediaJobErrorCategoryUpload MediaJobErrorCategory = "Upload"
)

// PossibleMediaJobErrorCategoryValues returns the possible values for the MediaJobErrorCategory const type.
func PossibleMediaJobErrorCategoryValues() []MediaJobErrorCategory {
	return []MediaJobErrorCategory{
		MediaJobErrorCategoryAccount,
		MediaJobErrorCategoryConfiguration,
		MediaJobErrorCategoryContent,
		MediaJobErrorCategoryDownload,
		MediaJobErrorCategoryService,
		MediaJobErrorCategoryUpload,
	}
}

// MediaJobErrorCode - Error code describing the error.
type MediaJobErrorCode string

const (
	// MediaJobErrorCodeConfigurationUnsupported - There was a problem with the combination of input files and the configuration
	// settings applied, fix the configuration settings and retry with the same input, or change input to match the configuration.
	MediaJobErrorCodeConfigurationUnsupported MediaJobErrorCode = "ConfigurationUnsupported"
	// MediaJobErrorCodeContentMalformed - There was a problem with the input content (for example: zero byte files, or corrupt/non-decodable
	// files), check the input files.
	MediaJobErrorCodeContentMalformed MediaJobErrorCode = "ContentMalformed"
	// MediaJobErrorCodeContentUnsupported - There was a problem with the format of the input (not valid media file, or an unsupported
	// file/codec), check the validity of the input files.
	MediaJobErrorCodeContentUnsupported MediaJobErrorCode = "ContentUnsupported"
	// MediaJobErrorCodeDownloadNotAccessible - While trying to download the input files, the files were not accessible, please
	// check the availability of the source.
	MediaJobErrorCodeDownloadNotAccessible MediaJobErrorCode = "DownloadNotAccessible"
	// MediaJobErrorCodeDownloadTransientError - While trying to download the input files, there was an issue during transfer
	// (storage service, network errors), see details and check your source.
	MediaJobErrorCodeDownloadTransientError MediaJobErrorCode = "DownloadTransientError"
	// MediaJobErrorCodeIdentityUnsupported - There is an error verifying to the account identity. Check and fix the identity
	// configurations and retry. If unsuccessful, please contact support.
	MediaJobErrorCodeIdentityUnsupported MediaJobErrorCode = "IdentityUnsupported"
	// MediaJobErrorCodeServiceError - Fatal service error, please contact support.
	MediaJobErrorCodeServiceError MediaJobErrorCode = "ServiceError"
	// MediaJobErrorCodeServiceTransientError - Transient error, please retry, if retry is unsuccessful, please contact support.
	MediaJobErrorCodeServiceTransientError MediaJobErrorCode = "ServiceTransientError"
	// MediaJobErrorCodeUploadNotAccessible - While trying to upload the output files, the destination was not reachable, please
	// check the availability of the destination.
	MediaJobErrorCodeUploadNotAccessible MediaJobErrorCode = "UploadNotAccessible"
	// MediaJobErrorCodeUploadTransientError - While trying to upload the output files, there was an issue during transfer (storage
	// service, network errors), see details and check your destination.
	MediaJobErrorCodeUploadTransientError MediaJobErrorCode = "UploadTransientError"
)

// PossibleMediaJobErrorCodeValues returns the possible values for the MediaJobErrorCode const type.
func PossibleMediaJobErrorCodeValues() []MediaJobErrorCode {
	return []MediaJobErrorCode{
		MediaJobErrorCodeConfigurationUnsupported,
		MediaJobErrorCodeContentMalformed,
		MediaJobErrorCodeContentUnsupported,
		MediaJobErrorCodeDownloadNotAccessible,
		MediaJobErrorCodeDownloadTransientError,
		MediaJobErrorCodeIdentityUnsupported,
		MediaJobErrorCodeServiceError,
		MediaJobErrorCodeServiceTransientError,
		MediaJobErrorCodeUploadNotAccessible,
		MediaJobErrorCodeUploadTransientError,
	}
}

// MediaJobRetry - Indicates that it may be possible to retry the Job. If retry is unsuccessful, please contact Azure support
// via Azure Portal.
type MediaJobRetry string

const (
	// MediaJobRetryDoNotRetry - Issue needs to be investigated and then the job resubmitted with corrections or retried once
	// the underlying issue has been corrected.
	MediaJobRetryDoNotRetry MediaJobRetry = "DoNotRetry"
	// MediaJobRetryMayRetry - Issue may be resolved after waiting for a period of time and resubmitting the same Job.
	MediaJobRetryMayRetry MediaJobRetry = "MayRetry"
)

// PossibleMediaJobRetryValues returns the possible values for the MediaJobRetry const type.
func PossibleMediaJobRetryValues() []MediaJobRetry {
	return []MediaJobRetry{
		MediaJobRetryDoNotRetry,
		MediaJobRetryMayRetry,
	}
}

// MediaJobState - The previous state of the Job.
type MediaJobState string

const (
	// MediaJobStateCanceled - The job was canceled. This is a final state for the job.
	MediaJobStateCanceled MediaJobState = "Canceled"
	// MediaJobStateCanceling - The job is in the process of being canceled. This is a transient state for the job.
	MediaJobStateCanceling MediaJobState = "Canceling"
	// MediaJobStateError - The job has encountered an error. This is a final state for the job.
	MediaJobStateError MediaJobState = "Error"
	// MediaJobStateFinished - The job is finished. This is a final state for the job.
	MediaJobStateFinished MediaJobState = "Finished"
	// MediaJobStateProcessing - The job is processing. This is a transient state for the job.
	MediaJobStateProcessing MediaJobState = "Processing"
	// MediaJobStateQueued - The job is in a queued state, waiting for resources to become available. This is a transient state.
	MediaJobStateQueued MediaJobState = "Queued"
	// MediaJobStateScheduled - The job is being scheduled to run on an available resource. This is a transient state, between
	// queued and processing states.
	MediaJobStateScheduled MediaJobState = "Scheduled"
)

// PossibleMediaJobStateValues returns the possible values for the MediaJobState const type.
func PossibleMediaJobStateValues() []MediaJobState {
	return []MediaJobState{
		MediaJobStateCanceled,
		MediaJobStateCanceling,
		MediaJobStateError,
		MediaJobStateFinished,
		MediaJobStateProcessing,
		MediaJobStateQueued,
		MediaJobStateScheduled,
	}
}

// RecordingChannelKind - The recording channel type - Mixed, Unmixed
type RecordingChannelKind string

const (
	RecordingChannelKindMixed   RecordingChannelKind = "Mixed"
	RecordingChannelKindUnmixed RecordingChannelKind = "Unmixed"
)

// PossibleRecordingChannelKindValues returns the possible values for the RecordingChannelType const type.
func PossibleRecordingChannelKindValues() []RecordingChannelKind {
	return []RecordingChannelKind{
		RecordingChannelKindMixed,
		RecordingChannelKindUnmixed,
	}
}

// RecordingContentType - The recording content type- AudioVideo, or Audio
type RecordingContentType string

const (
	RecordingContentTypeAudio      RecordingContentType = "Audio"
	RecordingContentTypeAudioVideo RecordingContentType = "AudioVideo"
)

// PossibleRecordingContentTypeValues returns the possible values for the RecordingContentType const type.
func PossibleRecordingContentTypeValues() []RecordingContentType {
	return []RecordingContentType{
		RecordingContentTypeAudio,
		RecordingContentTypeAudioVideo,
	}
}

// RecordingFormatType - The recording format type - Mp4, Mp3, Wav
type RecordingFormatType string

const (
	RecordingFormatTypeMp3 RecordingFormatType = "Mp3"
	RecordingFormatTypeMp4 RecordingFormatType = "Mp4"
	RecordingFormatTypeWav RecordingFormatType = "Wav"
)

// PossibleRecordingFormatTypeValues returns the possible values for the RecordingFormatType const type.
func PossibleRecordingFormatTypeValues() []RecordingFormatType {
	return []RecordingFormatType{
		RecordingFormatTypeMp3,
		RecordingFormatTypeMp4,
		RecordingFormatTypeWav,
	}
}

// StampKind - Kind of environment where app service plan is.
type StampKind string

const (
	// StampKindAseV1 - App Service Plan is running on an App Service Environment V1.
	StampKindAseV1 StampKind = "AseV1"
	// StampKindAseV2 - App Service Plan is running on an App Service Environment V2.
	StampKindAseV2 StampKind = "AseV2"
	// StampKindPublic - App Service Plan is running on a public stamp.
	StampKindPublic StampKind = "Public"
)

// PossibleStampKindValues returns the possible values for the StampKind const type.
func PossibleStampKindValues() []StampKind {
	return []StampKind{
		StampKindAseV1,
		StampKindAseV2,
		StampKindPublic,
	}
}

// StorageTaskAssignmentCompletedStatus - The status for a storage task.
type StorageTaskAssignmentCompletedStatus string

const (
	StorageTaskAssignmentCompletedStatusFailed    StorageTaskAssignmentCompletedStatus = "Failed"
	StorageTaskAssignmentCompletedStatusSucceeded StorageTaskAssignmentCompletedStatus = "Succeeded"
)

// PossibleStorageTaskAssignmentCompletedStatusValues returns the possible values for the StorageTaskAssignmentCompletedStatus const type.
func PossibleStorageTaskAssignmentCompletedStatusValues() []StorageTaskAssignmentCompletedStatus {
	return []StorageTaskAssignmentCompletedStatus{
		StorageTaskAssignmentCompletedStatusFailed,
		StorageTaskAssignmentCompletedStatusSucceeded,
	}
}

// StorageTaskCompletedStatus - The status for a storage task.
type StorageTaskCompletedStatus string

const (
	StorageTaskCompletedStatusFailed    StorageTaskCompletedStatus = "Failed"
	StorageTaskCompletedStatusSucceeded StorageTaskCompletedStatus = "Succeeded"
)

// PossibleStorageTaskCompletedStatusValues returns the possible values for the StorageTaskCompletedStatus const type.
func PossibleStorageTaskCompletedStatusValues() []StorageTaskCompletedStatus {
	return []StorageTaskCompletedStatus{
		StorageTaskCompletedStatusFailed,
		StorageTaskCompletedStatusSucceeded,
	}
}
