# Support

## How to file issues and get help  

Customers with an [Azure support plan](https://azure.microsoft.com/support/options/) can open an [Azure support ticket](https://azure.microsoft.com/support/create-ticket/).
**We recommend this option if your problem requires immediate attention.** 

### Github issues
We use [GitHub Issues](https://github.com/Azure/azure-sdk-for-go/issues/new/choose) to track bugs, questions, and feature requests. 
GitHub issues are free, but **response time is not guaranteed.** See [GitHub issues support process](https://devblogs.microsoft.com/azure-sdk/github-issue-support-process/) for more details.

To ensure the relevance and manageability of our issue queue, we have an automated process that will close issues that are over two years old and have not been updated in the last 30 days. This measure is designed to help us respond to and resolve current issues more efficiently. We appreciate your understanding and cooperation in maintaining a focused and up-to-date issue tracking system.

### Community resources
- Search for similar issues in [our GitHub repository](https://github.com/Azure/azure-sdk-for-go/issues)
- Ask a question on [StackOverflow](https://stackoverflow.com/questions/tagged/azure-sdk+go) and tag it with "azure-sdk" and "go"
- Share or upvote feature requests on [Feedback Page](https://feedback.azure.com/forums/34192--general-feedback).
- Take a look at the [Azure SDK blog](https://devblogs.microsoft.com/azure-sdk/).
- Ask a question on [Twitter](https://twitter.com/AzureSDK)
- Ask a question at [Microsoft Q&A](https://docs.microsoft.com/answers/products/azure?WT.mc_id=Portal-Microsoft_Azure_Support&product=all)
- Ask a question at [Microsoft Tech Community](https://techcommunity.microsoft.com/t5/azure/ct-p/Azure)

### Security bugs
Security issues and bugs should be reported privately, via email, to the Microsoft Security Response Center(secure@microsoft.com). 
You should receive a response within 24 hours. 
Further information, including the MSRC PGP key, can be found in the [Security TechCenter](https://www.microsoft.com/msrc/faqs-report-an-issue?rtc=1)

## Microsoft Support Policy

Please refer to [Azure SDK Support and Lifecycle information](https://azure.github.io/azure-sdk/policies_support.html)
