package main

import "bytes"

var (
	frontmatterOpen  = []byte("---")
	frontmatterClose = []byte("\n---")
)

func extractFrontmatter(b []byte) (frontmatter, content []byte) {
	if !bytes.HasPrefix(b, frontmatterOpen) {
		return nil, b
	}
	if len(b) > len(frontmatterOpen) && b[len(frontmatterOpen)] != '\n' {
		return nil, b
	}
	b = b[len(frontmatterOpen):]

	i := bytes.Index(b, frontmatterClose)
	if i == -1 {
		return b, nil
	}
	return b[:i], b[i+len(frontmatterClose):]
}
