subroutine get_fioerror(name,item,status,error,ignore)
  character(len=*) :: name          !
  character(len=*) :: item          !
  integer :: status                 !
  logical :: error                  !
  logical :: ignore                 !
  !
  if (status.eq.0) return
  call fio_printerror(name,item,status,error)
  if (ignore) then
    status = 0
    error = .false.
  endif
  return
end subroutine get_fioerror
!
subroutine fio_printerror(name,sub,status,error)
  use gkernel_interfaces
  character(len=*) :: name          !
  character(len=*) :: sub           !
  integer :: status                 !
  logical :: error                  !
  ! Local
  character(len=30) :: errtext
  character(len=80) :: msg,errmessage
  character(len=160) :: msg2
  integer :: lmsg, lsub, l
  !
  !  Check if status is OK (no error); if so, simply return
  if (status .le. 0) return
  !
  !  The FTGERR subroutine returns a descriptive 30-character text string that
  !  corresponds to the integer error status number.  A complete list of all
  !  the error numbers can be found in the back of the FITSIO User's Guide.
  !
  call ftgerr(status,errtext)
  write (msg,1000) status, errtext
1000 format ('Error ',i6,': ',a)
  lmsg = lenc(msg)
  lsub = lenc(sub)
  msg2 =' '
  l = lenc(msg2)
  msg2(l+1:) = ' '//sub(1:lsub)
  l = lenc(msg2)
  msg2(l+1:) = '; '
  l = lenc(msg2)
  msg2(l+1:) = ' '//msg(1:lmsg)
  l = lenc(msg2)
  call message(8,3,name,msg2(1:l))
  !
  !  FITSIO usually generates an internal stack of error messages whenever
  !  an error occurs.  These messages provide much more information on the
  !  cause of the problem than can be provided by the single integer error
  !  status value.  The FTGMSG subroutine retrieves the oldest message from
  !  the stack and shifts any remaining messages on the stack down one
  !  position.  FTGMSG is called repeatedly until a blank message is
  !  returned, which indicates that the stack is empty.  Each error message
  !  may be up to 80 characters in length.  Another subroutine, called
  !  FTCMSG, is available to simply clear the whole error message stack in
  !  cases where one is not interested in the contents.
  !
  call ftgmsg(errmessage)
  do while (errmessage .ne. ' ')
    lmsg = lenc(errmessage)
    call message(8,3,'FITSIO',errmessage(1:lmsg))
    call ftgmsg(errmessage)
  enddo
  error = .true.
  status = 0
end subroutine fio_printerror
!
subroutine printerror(name,status)
  use gkernel_interfaces
  implicit none
  !------------------------------------------------------------------------
  ! This subroutine prints out the descriptive text corresponding to the
  ! error status value and prints out the contents of the internal
  ! error message stack generated by FITSIO whenever an error occurs.
  !------------------------------------------------------------------------
  character(len=*) :: name          !
  integer :: status                 !
  ! Local
  character(len=30) :: errtext
  character(len=80) :: msg,errmessage
  integer :: lmsg
  !
  !  Check if status is OK (no error); if so, simply return
  if (status .le. 0)return
  !  The FTGERR subroutine returns a descriptive 30-character text string that
  !  corresponds to the integer error status number.  A complete list of all
  !  the error numbers can be found in the back of the FITSIO User's Guide.
  call ftgerr(status,errtext)
  write (msg,1000) status, errtext
1000 format ('Error ',i6,': ',a)
  lmsg = lenc(msg)
  call message(8,3,name,msg(1:lmsg))
  !  FITSIO usually generates an internal stack of error messages whenever
  !  an error occurs.  These messages provide much more information on the
  !  cause of the problem than can be provided by the single integer error
  !  status value.  The FTGMSG subroutine retrieves the oldest message from
  !  the stack and shifts any remaining messages on the stack down one
  !  position.  FTGMSG is called repeatedly until a blank message is
  !  returned, which indicates that the stack is empty.  Each error message
  !  may be up to 80 characters in length.  Another subroutine, called
  !  FTCMSG, is available to simply clear the whole error message stack in
  !  cases where one is not interested in the contents.
  call ftgmsg(errmessage)
  do while (errmessage .ne. ' ')
    lmsg = lenc(errmessage)
    call message(8,3,'FITSIO',errmessage(1:lmsg))
    call ftgmsg(errmessage)
  enddo
end subroutine printerror
