module cubelist_object_pointer_types
  use cubetools_parameters
  use cubelist_object_types
  !---------------------------------------------------------------------
  !
  !---------------------------------------------------------------------
  !
  public :: list_object_p_t
  private
  !
  type :: list_object_p_t
    class(list_object_t), pointer :: p=>null()
    integer(kind=code_k)          :: code_pointer=code_pointer_null
  contains
    procedure, public :: allocate  => cubelist_object_allocate
    procedure, public :: associate => cubelist_object_associate
    procedure, public :: final     => cubelist_object_final
  end type list_object_p_t
  !
contains
  !
  subroutine cubelist_object_allocate(lopt,template,error)
    use gkernel_interfaces
    !----------------------------------------------------------------------
    ! Allocate an extended 'list_object_t' in memory, of type taken from
    ! the given template
    !----------------------------------------------------------------------
    class(list_object_p_t), intent(inout) :: lopt
    class(list_object_t),   intent(in)    :: template
    logical,                intent(inout) :: error
    !
    integer(kind=4) :: ier
    character(len=*), parameter :: rname='OBJECT>ALLOCATE'
    !
    ! For safety properly free the previous contents, if any
    call lopt%final(error)
    if (error)  return
    !
    allocate(lopt%p,source=template,stat=ier)
    if (failed_allocate(rname,'Object',ier,error)) return
    lopt%code_pointer = code_pointer_allocated
  end subroutine cubelist_object_allocate
  !
  subroutine cubelist_object_associate(lopt,lot,error)
    !-------------------------------------------------------------------
    ! Set or replace the list_object_t, taking care of the previous
    ! allocation status
    !-------------------------------------------------------------------
    class(list_object_p_t), intent(inout) :: lopt   !
    class(list_object_t),   target        :: lot    ! New target
    logical,                intent(inout) :: error  !
    !
    ! For safety properly free the previous contents, if any
    call lopt%final(error)
    if (error)  return
    !
    lopt%p => lot
    lopt%code_pointer = code_pointer_associated
  end subroutine cubelist_object_associate
  !
  subroutine cubelist_object_final(lopt,error)
    !-------------------------------------------------------------------
    ! Nullify the list_object_t, taking care of the previous
    ! allocation status
    !-------------------------------------------------------------------
    class(list_object_p_t), intent(inout) :: lopt
    logical,                intent(inout) :: error
    !
    if (lopt%code_pointer.eq.code_pointer_allocated) then
      call lopt%p%final(error)  ! Call the explicit FINAL method
      if (error)  return
      deallocate(lopt%p)  ! Call the implicit FINAL method of the dynamic type, if any
    else
      lopt%p => null()
    endif
    lopt%code_pointer = code_pointer_null
  end subroutine cubelist_object_final
  !
end module cubelist_object_pointer_types
