/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.io;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.catacombae.io.ReadableRandomAccessStream;
import org.catacombae.io.RuntimeIOException;

public class ReadableFileStream
implements ReadableRandomAccessStream {
    protected final RandomAccessFile raf;

    public ReadableFileStream(String filename) {
        this(new File(filename));
    }

    public ReadableFileStream(File file) {
        this(file, "r");
    }

    public ReadableFileStream(RandomAccessFile iRaf) {
        if (iRaf == null) {
            throw new IllegalArgumentException("iRaf may NOT be null");
        }
        this.raf = iRaf;
    }

    protected ReadableFileStream(String filename, String mode) {
        this(new File(filename), mode);
    }

    protected ReadableFileStream(File file, String mode) {
        try {
            this.raf = new RandomAccessFile(file, mode);
        }
        catch (IOException ex) {
            throw new RuntimeIOException(ex);
        }
    }

    public void seek(long pos) {
        try {
            this.raf.seek(pos);
        }
        catch (IOException ioe) {
            throw new RuntimeIOException("pos=" + pos + "," + ioe.toString(), ioe);
        }
    }

    public int read() {
        try {
            return this.raf.read();
        }
        catch (IOException ex) {
            throw new RuntimeIOException(ex);
        }
    }

    public int read(byte[] data) {
        try {
            return this.raf.read(data);
        }
        catch (IOException ex) {
            throw new RuntimeIOException(ex);
        }
    }

    public int read(byte[] data, int pos, int len) {
        try {
            return this.raf.read(data, pos, len);
        }
        catch (IOException ex) {
            throw new RuntimeIOException(ex);
        }
    }

    public void readFully(byte[] data) {
        try {
            this.raf.readFully(data);
        }
        catch (IOException ex) {
            throw new RuntimeIOException(ex);
        }
    }

    public void readFully(byte[] data, int offset, int length) {
        try {
            this.raf.readFully(data, offset, length);
        }
        catch (IOException ex) {
            throw new RuntimeIOException(ex);
        }
    }

    public long length() {
        try {
            return this.raf.length();
        }
        catch (IOException ex) {
            throw new RuntimeIOException(ex);
        }
    }

    public long getFilePointer() {
        try {
            return this.raf.getFilePointer();
        }
        catch (IOException ex) {
            throw new RuntimeIOException(ex);
        }
    }

    public void close() {
        try {
            this.raf.close();
        }
        catch (IOException ex) {
            throw new RuntimeIOException(ex);
        }
    }
}

