string(COMPARE EQUAL "${SQLite3_LIBRARIES}" "" z_vcpkg_sqlite3_fixup_libraries)
_find_package(${ARGS})
if(SQLite3_FOUND)
    set(z_vcpkg_sqlite3_libraries "")
    set(z_vcpkg_sqlite3_link_libs "")
    if("@SQLITE_ENABLE_ICU@")
        find_package(ICU COMPONENTS uc i18n)
        if(ICU_FOUND)
            list(APPEND z_vcpkg_sqlite3_libraries ${ICU_LIBRARIES})
            list(APPEND z_vcpkg_sqlite3_link_libs $<LINK_ONLY:ICU::uc> $<LINK_ONLY:ICU::i18n>)
        endif()
    endif()
    if(NOT WIN32)
        find_package(Threads)
        if(Threads_FOUND)
            list(APPEND z_vcpkg_sqlite3_libraries ${CMAKE_THREAD_LIBS_INIT})
            list(APPEND z_vcpkg_sqlite3_link_libs $<LINK_ONLY:Threads::Threads>)
        endif()
        list(APPEND z_vcpkg_sqlite3_libraries ${CMAKE_DL_LIBS})
        list(APPEND z_vcpkg_sqlite3_link_libs ${CMAKE_DL_LIBS})
        if("@SQLITE_ENABLE_FTS5@" OR "@SQLITE_ENABLE_MATH_FUNCTIONS@")
            find_library(z_vcpkg_sqlite3_have_libm m)
            if(z_vcpkg_sqlite3_have_libm)
                list(APPEND z_vcpkg_sqlite3_libraries m)
                list(APPEND z_vcpkg_sqlite3_link_libs $<LINK_ONLY:m>)
            endif()
        endif()
    endif()
    if(z_vcpkg_sqlite3_fixup_libraries)
        list(APPEND SQLite3_LIBRARIES ${z_vcpkg_sqlite3_libraries})
    endif()
    if(TARGET SQLite::SQLite3)
        set_target_properties(SQLite::SQLite3 PROPERTIES INTERFACE_LINK_LIBRARIES "${z_vcpkg_sqlite3_link_libs}")
    endif()
endif()
