;; Tests for i32x4 arithmetic operations on major boundary values and all special values.


(module
  (func (export "i32x4.dot_i16x8_s") (param v128 v128) (result v128) (i32x4.dot_i16x8_s (local.get 0) (local.get 1)))
)


;; i32x4.dot_i16x8_s
(assert_return (invoke "i32x4.dot_i16x8_s" (v128.const i16x8 0 0 0 0 0 0 0 0)
                                           (v128.const i16x8 0 0 0 0 0 0 0 0))
                                           (v128.const i32x4 0 0 0 0))
(assert_return (invoke "i32x4.dot_i16x8_s" (v128.const i16x8 0 0 0 0 0 0 0 0)
                                           (v128.const i16x8 1 1 1 1 1 1 1 1))
                                           (v128.const i32x4 0 0 0 0))
(assert_return (invoke "i32x4.dot_i16x8_s" (v128.const i16x8 1 1 1 1 1 1 1 1)
                                           (v128.const i16x8 1 1 1 1 1 1 1 1))
                                           (v128.const i32x4 2 2 2 2))
(assert_return (invoke "i32x4.dot_i16x8_s" (v128.const i16x8 0 0 0 0 0 0 0 0)
                                           (v128.const i16x8 -1 -1 -1 -1 -1 -1 -1 -1))
                                           (v128.const i32x4 0 0 0 0))
(assert_return (invoke "i32x4.dot_i16x8_s" (v128.const i16x8 1 1 1 1 1 1 1 1)
                                           (v128.const i16x8 -1 -1 -1 -1 -1 -1 -1 -1))
                                           (v128.const i32x4 -2 -2 -2 -2))
(assert_return (invoke "i32x4.dot_i16x8_s" (v128.const i16x8 -1 -1 -1 -1 -1 -1 -1 -1)
                                           (v128.const i16x8 -1 -1 -1 -1 -1 -1 -1 -1))
                                           (v128.const i32x4 2 2 2 2))
(assert_return (invoke "i32x4.dot_i16x8_s" (v128.const i16x8 16383 16383 16383 16383 16383 16383 16383 16383)
                                           (v128.const i16x8 16384 16384 16384 16384 16384 16384 16384 16384))
                                           (v128.const i32x4 536838144 536838144 536838144 536838144))
(assert_return (invoke "i32x4.dot_i16x8_s" (v128.const i16x8 16384 16384 16384 16384 16384 16384 16384 16384)
                                           (v128.const i16x8 16384 16384 16384 16384 16384 16384 16384 16384))
                                           (v128.const i32x4 536870912 536870912 536870912 536870912))
(assert_return (invoke "i32x4.dot_i16x8_s" (v128.const i16x8 -16383 -16383 -16383 -16383 -16383 -16383 -16383 -16383)
                                           (v128.const i16x8 -16384 -16384 -16384 -16384 -16384 -16384 -16384 -16384))
                                           (v128.const i32x4 536838144 536838144 536838144 536838144))
(assert_return (invoke "i32x4.dot_i16x8_s" (v128.const i16x8 -16384 -16384 -16384 -16384 -16384 -16384 -16384 -16384)
                                           (v128.const i16x8 -16384 -16384 -16384 -16384 -16384 -16384 -16384 -16384))
                                           (v128.const i32x4 536870912 536870912 536870912 536870912))
(assert_return (invoke "i32x4.dot_i16x8_s" (v128.const i16x8 -16385 -16385 -16385 -16385 -16385 -16385 -16385 -16385)
                                           (v128.const i16x8 -16384 -16384 -16384 -16384 -16384 -16384 -16384 -16384))
                                           (v128.const i32x4 536903680 536903680 536903680 536903680))
(assert_return (invoke "i32x4.dot_i16x8_s" (v128.const i16x8 32765 32765 32765 32765 32765 32765 32765 32765)
                                           (v128.const i16x8 1 1 1 1 1 1 1 1))
                                           (v128.const i32x4 65530 65530 65530 65530))
(assert_return (invoke "i32x4.dot_i16x8_s" (v128.const i16x8 32766 32766 32766 32766 32766 32766 32766 32766)
                                           (v128.const i16x8 1 1 1 1 1 1 1 1))
                                           (v128.const i32x4 65532 65532 65532 65532))
(assert_return (invoke "i32x4.dot_i16x8_s" (v128.const i16x8 32768 32768 32768 32768 32768 32768 32768 32768)
                                           (v128.const i16x8 1 1 1 1 1 1 1 1))
                                           (v128.const i32x4 -65536 -65536 -65536 -65536))
(assert_return (invoke "i32x4.dot_i16x8_s" (v128.const i16x8 -32766 -32766 -32766 -32766 -32766 -32766 -32766 -32766)
                                           (v128.const i16x8 -1 -1 -1 -1 -1 -1 -1 -1))
                                           (v128.const i32x4 65532 65532 65532 65532))
(assert_return (invoke "i32x4.dot_i16x8_s" (v128.const i16x8 -32767 -32767 -32767 -32767 -32767 -32767 -32767 -32767)
                                           (v128.const i16x8 -1 -1 -1 -1 -1 -1 -1 -1))
                                           (v128.const i32x4 65534 65534 65534 65534))
(assert_return (invoke "i32x4.dot_i16x8_s" (v128.const i16x8 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768)
                                           (v128.const i16x8 -1 -1 -1 -1 -1 -1 -1 -1))
                                           (v128.const i32x4 65536 65536 65536 65536))
(assert_return (invoke "i32x4.dot_i16x8_s" (v128.const i16x8 32767 32767 32767 32767 32767 32767 32767 32767)
                                           (v128.const i16x8 32767 32767 32767 32767 32767 32767 32767 32767))
                                           (v128.const i32x4 2147352578 2147352578 2147352578 2147352578))
(assert_return (invoke "i32x4.dot_i16x8_s" (v128.const i16x8 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768)
                                           (v128.const i16x8 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768))
                                           (v128.const i32x4 2147483648 2147483648 2147483648 2147483648))
(assert_return (invoke "i32x4.dot_i16x8_s" (v128.const i16x8 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768)
                                           (v128.const i16x8 -32767 -32767 -32767 -32767 -32767 -32767 -32767 -32767))
                                           (v128.const i32x4 2147418112 2147418112 2147418112 2147418112))
(assert_return (invoke "i32x4.dot_i16x8_s" (v128.const i16x8 65535 65535 65535 65535 65535 65535 65535 65535)
                                           (v128.const i16x8 0 0 0 0 0 0 0 0))
                                           (v128.const i32x4 0 0 0 0))
(assert_return (invoke "i32x4.dot_i16x8_s" (v128.const i16x8 65535 65535 65535 65535 65535 65535 65535 65535)
                                           (v128.const i16x8 1 1 1 1 1 1 1 1))
                                           (v128.const i32x4 -2 -2 -2 -2))
(assert_return (invoke "i32x4.dot_i16x8_s" (v128.const i16x8 65535 65535 65535 65535 65535 65535 65535 65535)
                                           (v128.const i16x8 -1 -1 -1 -1 -1 -1 -1 -1))
                                           (v128.const i32x4 2 2 2 2))
(assert_return (invoke "i32x4.dot_i16x8_s" (v128.const i16x8 65535 65535 65535 65535 65535 65535 65535 65535)
                                           (v128.const i16x8 32767 32767 32767 32767 32767 32767 32767 32767))
                                           (v128.const i32x4 -65534 -65534 -65534 -65534))
(assert_return (invoke "i32x4.dot_i16x8_s" (v128.const i16x8 65535 65535 65535 65535 65535 65535 65535 65535)
                                           (v128.const i16x8 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768))
                                           (v128.const i32x4 65536 65536 65536 65536))
(assert_return (invoke "i32x4.dot_i16x8_s" (v128.const i16x8 65535 65535 65535 65535 65535 65535 65535 65535)
                                           (v128.const i16x8 65535 65535 65535 65535 65535 65535 65535 65535))
                                           (v128.const i32x4 2 2 2 2))

;; type check
(assert_invalid (module (func (result v128) (i32x4.dot_i16x8_s (i32.const 0) (f32.const 0.0)))) "type mismatch")

;; Test operation with empty argument

(assert_invalid
  (module
    (func $i32x4.dot_i16x8_s-1st-arg-empty (result v128)
      (i32x4.dot_i16x8_s (v128.const i32x4 0 0 0 0))
    )
  )
  "type mismatch"
)
(assert_invalid
  (module
    (func $i32x4.dot_i16x8_s-arg-empty (result v128)
      (i32x4.dot_i16x8_s)
    )
  )
  "type mismatch"
)

