;; Test all the f32x4 comparison operators on major boundary values and all special values.

(module
  (func (export "eq") (param $x v128) (param $y v128) (result v128) (f32x4.eq (local.get $x) (local.get $y)))
  (func (export "ne") (param $x v128) (param $y v128) (result v128) (f32x4.ne (local.get $x) (local.get $y)))
  (func (export "lt") (param $x v128) (param $y v128) (result v128) (f32x4.lt (local.get $x) (local.get $y)))
  (func (export "le") (param $x v128) (param $y v128) (result v128) (f32x4.le (local.get $x) (local.get $y)))
  (func (export "gt") (param $x v128) (param $y v128) (result v128) (f32x4.gt (local.get $x) (local.get $y)))
  (func (export "ge") (param $x v128) (param $y v128) (result v128) (f32x4.ge (local.get $x) (local.get $y)))
)

;; eq
(assert_return (invoke "eq" (v128.const f32x4 nan nan nan nan)
                            (v128.const f32x4 nan nan nan nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 nan nan nan nan)
                            (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 nan nan nan nan)
                            (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 nan nan nan nan)
                            (v128.const f32x4 -inf -inf -inf -inf))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 nan nan nan nan)
                            (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 nan nan nan nan)
                            (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 nan nan nan nan)
                            (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 nan nan nan nan)
                            (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 nan nan nan nan)
                            (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 nan nan nan nan)
                            (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 nan nan nan nan)
                            (v128.const f32x4 -nan -nan -nan -nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 nan nan nan nan)
                            (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 nan nan nan nan)
                            (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 nan nan nan nan)
                            (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 nan nan nan nan)
                            (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 nan nan nan nan)
                            (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 nan nan nan nan)
                            (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 nan nan nan nan)
                            (v128.const f32x4 inf inf inf inf))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 nan nan nan nan)
                            (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 nan nan nan nan)
                            (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                            (v128.const f32x4 nan nan nan nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                            (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "eq" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                            (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                            (v128.const f32x4 -inf -inf -inf -inf))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                            (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                            (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                            (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                            (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                            (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                            (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                            (v128.const f32x4 -nan -nan -nan -nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                            (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                            (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                            (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                            (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                            (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                            (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                            (v128.const f32x4 inf inf inf inf))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                            (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                            (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                            (v128.const f32x4 nan nan nan nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                            (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                            (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                            (v128.const f32x4 -inf -inf -inf -inf))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                            (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                            (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                            (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                            (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                            (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                            (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                            (v128.const f32x4 -nan -nan -nan -nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                            (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                            (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                            (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                            (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                            (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                            (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                            (v128.const f32x4 inf inf inf inf))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                            (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                            (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 -inf -inf -inf -inf)
                            (v128.const f32x4 nan nan nan nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 -inf -inf -inf -inf)
                            (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 -inf -inf -inf -inf)
                            (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 -inf -inf -inf -inf)
                            (v128.const f32x4 -inf -inf -inf -inf))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "eq" (v128.const f32x4 -inf -inf -inf -inf)
                            (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 -inf -inf -inf -inf)
                            (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 -inf -inf -inf -inf)
                            (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 -inf -inf -inf -inf)
                            (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 -inf -inf -inf -inf)
                            (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 -inf -inf -inf -inf)
                            (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 -inf -inf -inf -inf)
                            (v128.const f32x4 -nan -nan -nan -nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 -inf -inf -inf -inf)
                            (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 -inf -inf -inf -inf)
                            (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 -inf -inf -inf -inf)
                            (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 -inf -inf -inf -inf)
                            (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 -inf -inf -inf -inf)
                            (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 -inf -inf -inf -inf)
                            (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 -inf -inf -inf -inf)
                            (v128.const f32x4 inf inf inf inf))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 -inf -inf -inf -inf)
                            (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 -inf -inf -inf -inf)
                            (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                            (v128.const f32x4 nan nan nan nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                            (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                            (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                            (v128.const f32x4 -inf -inf -inf -inf))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                            (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "eq" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                            (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                            (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                            (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                            (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                            (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                            (v128.const f32x4 -nan -nan -nan -nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                            (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                            (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                            (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                            (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                            (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                            (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                            (v128.const f32x4 inf inf inf inf))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                            (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                            (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                            (v128.const f32x4 nan nan nan nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                            (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                            (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                            (v128.const f32x4 -inf -inf -inf -inf))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                            (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                            (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "eq" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                            (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                            (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                            (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                            (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                            (v128.const f32x4 -nan -nan -nan -nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                            (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                            (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                            (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                            (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                            (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                            (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                            (v128.const f32x4 inf inf inf inf))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                            (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                            (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                            (v128.const f32x4 nan nan nan nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                            (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                            (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                            (v128.const f32x4 -inf -inf -inf -inf))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                            (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                            (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                            (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "eq" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                            (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                            (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                            (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                            (v128.const f32x4 -nan -nan -nan -nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                            (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                            (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                            (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                            (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                            (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                            (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                            (v128.const f32x4 inf inf inf inf))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                            (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                            (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                            (v128.const f32x4 nan nan nan nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                            (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                            (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                            (v128.const f32x4 -inf -inf -inf -inf))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                            (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                            (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                            (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                            (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "eq" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                            (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                            (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                            (v128.const f32x4 -nan -nan -nan -nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                            (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                            (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                            (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                            (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                            (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                            (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "eq" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                            (v128.const f32x4 inf inf inf inf))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                            (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                            (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                            (v128.const f32x4 nan nan nan nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                            (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                            (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                            (v128.const f32x4 -inf -inf -inf -inf))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                            (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                            (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                            (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                            (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                            (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "eq" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                            (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                            (v128.const f32x4 -nan -nan -nan -nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                            (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                            (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                            (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                            (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                            (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                            (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                            (v128.const f32x4 inf inf inf inf))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                            (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                            (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                            (v128.const f32x4 nan nan nan nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                            (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                            (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                            (v128.const f32x4 -inf -inf -inf -inf))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                            (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                            (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                            (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                            (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                            (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                            (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "eq" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                            (v128.const f32x4 -nan -nan -nan -nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                            (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                            (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                            (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                            (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                            (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                            (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                            (v128.const f32x4 inf inf inf inf))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                            (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                            (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 -nan -nan -nan -nan)
                            (v128.const f32x4 nan nan nan nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 -nan -nan -nan -nan)
                            (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 -nan -nan -nan -nan)
                            (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 -nan -nan -nan -nan)
                            (v128.const f32x4 -inf -inf -inf -inf))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 -nan -nan -nan -nan)
                            (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 -nan -nan -nan -nan)
                            (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 -nan -nan -nan -nan)
                            (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 -nan -nan -nan -nan)
                            (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 -nan -nan -nan -nan)
                            (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 -nan -nan -nan -nan)
                            (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 -nan -nan -nan -nan)
                            (v128.const f32x4 -nan -nan -nan -nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 -nan -nan -nan -nan)
                            (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 -nan -nan -nan -nan)
                            (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 -nan -nan -nan -nan)
                            (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 -nan -nan -nan -nan)
                            (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 -nan -nan -nan -nan)
                            (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 -nan -nan -nan -nan)
                            (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 -nan -nan -nan -nan)
                            (v128.const f32x4 inf inf inf inf))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 -nan -nan -nan -nan)
                            (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 -nan -nan -nan -nan)
                            (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                            (v128.const f32x4 nan nan nan nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                            (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                            (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                            (v128.const f32x4 -inf -inf -inf -inf))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                            (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                            (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                            (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                            (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                            (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                            (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                            (v128.const f32x4 -nan -nan -nan -nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                            (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "eq" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                            (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                            (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                            (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                            (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                            (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                            (v128.const f32x4 inf inf inf inf))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                            (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                            (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                            (v128.const f32x4 nan nan nan nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                            (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                            (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                            (v128.const f32x4 -inf -inf -inf -inf))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                            (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                            (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                            (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                            (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                            (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                            (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                            (v128.const f32x4 -nan -nan -nan -nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                            (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                            (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "eq" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                            (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                            (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                            (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                            (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                            (v128.const f32x4 inf inf inf inf))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                            (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                            (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                            (v128.const f32x4 nan nan nan nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                            (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                            (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                            (v128.const f32x4 -inf -inf -inf -inf))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                            (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                            (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                            (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                            (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                            (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                            (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                            (v128.const f32x4 -nan -nan -nan -nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                            (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                            (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                            (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "eq" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                            (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                            (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                            (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                            (v128.const f32x4 inf inf inf inf))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                            (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                            (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                            (v128.const f32x4 nan nan nan nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                            (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                            (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                            (v128.const f32x4 -inf -inf -inf -inf))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                            (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                            (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                            (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                            (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                            (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                            (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                            (v128.const f32x4 -nan -nan -nan -nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                            (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                            (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                            (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                            (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "eq" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                            (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                            (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                            (v128.const f32x4 inf inf inf inf))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                            (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                            (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                            (v128.const f32x4 nan nan nan nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                            (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                            (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                            (v128.const f32x4 -inf -inf -inf -inf))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                            (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                            (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                            (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                            (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                            (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                            (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                            (v128.const f32x4 -nan -nan -nan -nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                            (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                            (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                            (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                            (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                            (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                            (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                            (v128.const f32x4 inf inf inf inf))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                            (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                            (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                            (v128.const f32x4 nan nan nan nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                            (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                            (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                            (v128.const f32x4 -inf -inf -inf -inf))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                            (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                            (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                            (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                            (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "eq" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                            (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                            (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                            (v128.const f32x4 -nan -nan -nan -nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                            (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                            (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                            (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                            (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                            (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                            (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "eq" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                            (v128.const f32x4 inf inf inf inf))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                            (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                            (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 inf inf inf inf)
                            (v128.const f32x4 nan nan nan nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 inf inf inf inf)
                            (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 inf inf inf inf)
                            (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 inf inf inf inf)
                            (v128.const f32x4 -inf -inf -inf -inf))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 inf inf inf inf)
                            (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 inf inf inf inf)
                            (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 inf inf inf inf)
                            (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 inf inf inf inf)
                            (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 inf inf inf inf)
                            (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 inf inf inf inf)
                            (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 inf inf inf inf)
                            (v128.const f32x4 -nan -nan -nan -nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 inf inf inf inf)
                            (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 inf inf inf inf)
                            (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 inf inf inf inf)
                            (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 inf inf inf inf)
                            (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 inf inf inf inf)
                            (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 inf inf inf inf)
                            (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 inf inf inf inf)
                            (v128.const f32x4 inf inf inf inf))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "eq" (v128.const f32x4 inf inf inf inf)
                            (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 inf inf inf inf)
                            (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                            (v128.const f32x4 nan nan nan nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                            (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                            (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                            (v128.const f32x4 -inf -inf -inf -inf))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                            (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                            (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                            (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                            (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                            (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                            (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                            (v128.const f32x4 -nan -nan -nan -nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                            (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                            (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                            (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                            (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                            (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                            (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                            (v128.const f32x4 inf inf inf inf))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                            (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "eq" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                            (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                            (v128.const f32x4 nan nan nan nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                            (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                            (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                            (v128.const f32x4 -inf -inf -inf -inf))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                            (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                            (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                            (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                            (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                            (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                            (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                            (v128.const f32x4 -nan -nan -nan -nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                            (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                            (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                            (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                            (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                            (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                            (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                            (v128.const f32x4 inf inf inf inf))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                            (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                            (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "eq" (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019)
                            (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "eq" (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019)
                            (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019)
                            (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "eq" (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019)
                            (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "eq" (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019)
                            (v128.const f32x4 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019)
                            (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019)
                            (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "eq" (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019)
                            (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019)
                            (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019)
                            (v128.const f32x4 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019)
                            (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "eq" (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019)
                            (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019)
                            (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "eq" (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019)
                            (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "eq" (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019)
                            (v128.const f32x4 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019)
                            (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "eq" (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019)
                            (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019)
                            (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "eq" (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019)
                            (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "eq" (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019)
                            (v128.const f32x4 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789)
                            (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789)
                            (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789)
                            (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789)
                            (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "eq" (v128.const f32x4 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789)
                            (v128.const f32x4 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789))
                            (v128.const i32x4 -1 -1 -1 -1))

;; ne
(assert_return (invoke "ne" (v128.const f32x4 nan nan nan nan)
                            (v128.const f32x4 nan nan nan nan))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 nan nan nan nan)
                            (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 nan nan nan nan)
                            (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 nan nan nan nan)
                            (v128.const f32x4 -inf -inf -inf -inf))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 nan nan nan nan)
                            (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 nan nan nan nan)
                            (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 nan nan nan nan)
                            (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 nan nan nan nan)
                            (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 nan nan nan nan)
                            (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 nan nan nan nan)
                            (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 nan nan nan nan)
                            (v128.const f32x4 -nan -nan -nan -nan))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 nan nan nan nan)
                            (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 nan nan nan nan)
                            (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 nan nan nan nan)
                            (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 nan nan nan nan)
                            (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 nan nan nan nan)
                            (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 nan nan nan nan)
                            (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 nan nan nan nan)
                            (v128.const f32x4 inf inf inf inf))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 nan nan nan nan)
                            (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 nan nan nan nan)
                            (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                            (v128.const f32x4 nan nan nan nan))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                            (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ne" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                            (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                            (v128.const f32x4 -inf -inf -inf -inf))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                            (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                            (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                            (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                            (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                            (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                            (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                            (v128.const f32x4 -nan -nan -nan -nan))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                            (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                            (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                            (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                            (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                            (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                            (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                            (v128.const f32x4 inf inf inf inf))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                            (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                            (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                            (v128.const f32x4 nan nan nan nan))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                            (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                            (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                            (v128.const f32x4 -inf -inf -inf -inf))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                            (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                            (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                            (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                            (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                            (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                            (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                            (v128.const f32x4 -nan -nan -nan -nan))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                            (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                            (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                            (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                            (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                            (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                            (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                            (v128.const f32x4 inf inf inf inf))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                            (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                            (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 -inf -inf -inf -inf)
                            (v128.const f32x4 nan nan nan nan))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 -inf -inf -inf -inf)
                            (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 -inf -inf -inf -inf)
                            (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 -inf -inf -inf -inf)
                            (v128.const f32x4 -inf -inf -inf -inf))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ne" (v128.const f32x4 -inf -inf -inf -inf)
                            (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 -inf -inf -inf -inf)
                            (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 -inf -inf -inf -inf)
                            (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 -inf -inf -inf -inf)
                            (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 -inf -inf -inf -inf)
                            (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 -inf -inf -inf -inf)
                            (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 -inf -inf -inf -inf)
                            (v128.const f32x4 -nan -nan -nan -nan))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 -inf -inf -inf -inf)
                            (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 -inf -inf -inf -inf)
                            (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 -inf -inf -inf -inf)
                            (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 -inf -inf -inf -inf)
                            (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 -inf -inf -inf -inf)
                            (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 -inf -inf -inf -inf)
                            (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 -inf -inf -inf -inf)
                            (v128.const f32x4 inf inf inf inf))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 -inf -inf -inf -inf)
                            (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 -inf -inf -inf -inf)
                            (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                            (v128.const f32x4 nan nan nan nan))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                            (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                            (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                            (v128.const f32x4 -inf -inf -inf -inf))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                            (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ne" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                            (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                            (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                            (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                            (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                            (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                            (v128.const f32x4 -nan -nan -nan -nan))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                            (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                            (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                            (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                            (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                            (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                            (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                            (v128.const f32x4 inf inf inf inf))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                            (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                            (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                            (v128.const f32x4 nan nan nan nan))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                            (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                            (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                            (v128.const f32x4 -inf -inf -inf -inf))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                            (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                            (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ne" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                            (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                            (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                            (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                            (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                            (v128.const f32x4 -nan -nan -nan -nan))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                            (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                            (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                            (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                            (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                            (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                            (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                            (v128.const f32x4 inf inf inf inf))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                            (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                            (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                            (v128.const f32x4 nan nan nan nan))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                            (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                            (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                            (v128.const f32x4 -inf -inf -inf -inf))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                            (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                            (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                            (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ne" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                            (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                            (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                            (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                            (v128.const f32x4 -nan -nan -nan -nan))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                            (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                            (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                            (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                            (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                            (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                            (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                            (v128.const f32x4 inf inf inf inf))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                            (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                            (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                            (v128.const f32x4 nan nan nan nan))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                            (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                            (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                            (v128.const f32x4 -inf -inf -inf -inf))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                            (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                            (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                            (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                            (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ne" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                            (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                            (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                            (v128.const f32x4 -nan -nan -nan -nan))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                            (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                            (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                            (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                            (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                            (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                            (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ne" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                            (v128.const f32x4 inf inf inf inf))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                            (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                            (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                            (v128.const f32x4 nan nan nan nan))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                            (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                            (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                            (v128.const f32x4 -inf -inf -inf -inf))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                            (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                            (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                            (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                            (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                            (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ne" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                            (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                            (v128.const f32x4 -nan -nan -nan -nan))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                            (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                            (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                            (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                            (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                            (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                            (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                            (v128.const f32x4 inf inf inf inf))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                            (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                            (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                            (v128.const f32x4 nan nan nan nan))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                            (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                            (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                            (v128.const f32x4 -inf -inf -inf -inf))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                            (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                            (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                            (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                            (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                            (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                            (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ne" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                            (v128.const f32x4 -nan -nan -nan -nan))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                            (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                            (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                            (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                            (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                            (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                            (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                            (v128.const f32x4 inf inf inf inf))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                            (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                            (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 -nan -nan -nan -nan)
                            (v128.const f32x4 nan nan nan nan))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 -nan -nan -nan -nan)
                            (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 -nan -nan -nan -nan)
                            (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 -nan -nan -nan -nan)
                            (v128.const f32x4 -inf -inf -inf -inf))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 -nan -nan -nan -nan)
                            (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 -nan -nan -nan -nan)
                            (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 -nan -nan -nan -nan)
                            (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 -nan -nan -nan -nan)
                            (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 -nan -nan -nan -nan)
                            (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 -nan -nan -nan -nan)
                            (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 -nan -nan -nan -nan)
                            (v128.const f32x4 -nan -nan -nan -nan))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 -nan -nan -nan -nan)
                            (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 -nan -nan -nan -nan)
                            (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 -nan -nan -nan -nan)
                            (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 -nan -nan -nan -nan)
                            (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 -nan -nan -nan -nan)
                            (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 -nan -nan -nan -nan)
                            (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 -nan -nan -nan -nan)
                            (v128.const f32x4 inf inf inf inf))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 -nan -nan -nan -nan)
                            (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 -nan -nan -nan -nan)
                            (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                            (v128.const f32x4 nan nan nan nan))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                            (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                            (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                            (v128.const f32x4 -inf -inf -inf -inf))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                            (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                            (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                            (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                            (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                            (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                            (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                            (v128.const f32x4 -nan -nan -nan -nan))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                            (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ne" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                            (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                            (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                            (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                            (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                            (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                            (v128.const f32x4 inf inf inf inf))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                            (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                            (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                            (v128.const f32x4 nan nan nan nan))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                            (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                            (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                            (v128.const f32x4 -inf -inf -inf -inf))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                            (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                            (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                            (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                            (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                            (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                            (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                            (v128.const f32x4 -nan -nan -nan -nan))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                            (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                            (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ne" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                            (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                            (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                            (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                            (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                            (v128.const f32x4 inf inf inf inf))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                            (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                            (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                            (v128.const f32x4 nan nan nan nan))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                            (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                            (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                            (v128.const f32x4 -inf -inf -inf -inf))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                            (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                            (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                            (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                            (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                            (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                            (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                            (v128.const f32x4 -nan -nan -nan -nan))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                            (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                            (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                            (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ne" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                            (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                            (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                            (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                            (v128.const f32x4 inf inf inf inf))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                            (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                            (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                            (v128.const f32x4 nan nan nan nan))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                            (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                            (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                            (v128.const f32x4 -inf -inf -inf -inf))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                            (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                            (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                            (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                            (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                            (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                            (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                            (v128.const f32x4 -nan -nan -nan -nan))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                            (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                            (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                            (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                            (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ne" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                            (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                            (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                            (v128.const f32x4 inf inf inf inf))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                            (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                            (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                            (v128.const f32x4 nan nan nan nan))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                            (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                            (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                            (v128.const f32x4 -inf -inf -inf -inf))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                            (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                            (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                            (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                            (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                            (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                            (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                            (v128.const f32x4 -nan -nan -nan -nan))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                            (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                            (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                            (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                            (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                            (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                            (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                            (v128.const f32x4 inf inf inf inf))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                            (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                            (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                            (v128.const f32x4 nan nan nan nan))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                            (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                            (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                            (v128.const f32x4 -inf -inf -inf -inf))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                            (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                            (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                            (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                            (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ne" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                            (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                            (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                            (v128.const f32x4 -nan -nan -nan -nan))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                            (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                            (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                            (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                            (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                            (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                            (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ne" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                            (v128.const f32x4 inf inf inf inf))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                            (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                            (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 inf inf inf inf)
                            (v128.const f32x4 nan nan nan nan))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 inf inf inf inf)
                            (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 inf inf inf inf)
                            (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 inf inf inf inf)
                            (v128.const f32x4 -inf -inf -inf -inf))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 inf inf inf inf)
                            (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 inf inf inf inf)
                            (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 inf inf inf inf)
                            (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 inf inf inf inf)
                            (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 inf inf inf inf)
                            (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 inf inf inf inf)
                            (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 inf inf inf inf)
                            (v128.const f32x4 -nan -nan -nan -nan))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 inf inf inf inf)
                            (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 inf inf inf inf)
                            (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 inf inf inf inf)
                            (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 inf inf inf inf)
                            (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 inf inf inf inf)
                            (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 inf inf inf inf)
                            (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 inf inf inf inf)
                            (v128.const f32x4 inf inf inf inf))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ne" (v128.const f32x4 inf inf inf inf)
                            (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 inf inf inf inf)
                            (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                            (v128.const f32x4 nan nan nan nan))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                            (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                            (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                            (v128.const f32x4 -inf -inf -inf -inf))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                            (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                            (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                            (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                            (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                            (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                            (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                            (v128.const f32x4 -nan -nan -nan -nan))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                            (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                            (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                            (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                            (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                            (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                            (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                            (v128.const f32x4 inf inf inf inf))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                            (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ne" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                            (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                            (v128.const f32x4 nan nan nan nan))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                            (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                            (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                            (v128.const f32x4 -inf -inf -inf -inf))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                            (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                            (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                            (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                            (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                            (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                            (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                            (v128.const f32x4 -nan -nan -nan -nan))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                            (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                            (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                            (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                            (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                            (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                            (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                            (v128.const f32x4 inf inf inf inf))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                            (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                            (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ne" (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019)
                            (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ne" (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019)
                            (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019)
                            (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ne" (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019)
                            (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ne" (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019)
                            (v128.const f32x4 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019)
                            (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019)
                            (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ne" (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019)
                            (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019)
                            (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019)
                            (v128.const f32x4 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019)
                            (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ne" (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019)
                            (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019)
                            (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ne" (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019)
                            (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ne" (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019)
                            (v128.const f32x4 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019)
                            (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ne" (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019)
                            (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019)
                            (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ne" (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019)
                            (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ne" (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019)
                            (v128.const f32x4 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789)
                            (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789)
                            (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789)
                            (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789)
                            (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ne" (v128.const f32x4 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789)
                            (v128.const f32x4 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789))
                            (v128.const i32x4 0 0 0 0))

;; lt
(assert_return (invoke "lt" (v128.const f32x4 nan nan nan nan)
                            (v128.const f32x4 nan nan nan nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 nan nan nan nan)
                            (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 nan nan nan nan)
                            (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 nan nan nan nan)
                            (v128.const f32x4 -inf -inf -inf -inf))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 nan nan nan nan)
                            (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 nan nan nan nan)
                            (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 nan nan nan nan)
                            (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 nan nan nan nan)
                            (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 nan nan nan nan)
                            (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 nan nan nan nan)
                            (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 nan nan nan nan)
                            (v128.const f32x4 -nan -nan -nan -nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 nan nan nan nan)
                            (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 nan nan nan nan)
                            (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 nan nan nan nan)
                            (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 nan nan nan nan)
                            (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 nan nan nan nan)
                            (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 nan nan nan nan)
                            (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 nan nan nan nan)
                            (v128.const f32x4 inf inf inf inf))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 nan nan nan nan)
                            (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 nan nan nan nan)
                            (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                            (v128.const f32x4 nan nan nan nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                            (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                            (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                            (v128.const f32x4 -inf -inf -inf -inf))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                            (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "lt" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                            (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "lt" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                            (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                            (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                            (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                            (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "lt" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                            (v128.const f32x4 -nan -nan -nan -nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                            (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                            (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                            (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "lt" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                            (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                            (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                            (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                            (v128.const f32x4 inf inf inf inf))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "lt" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                            (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                            (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "lt" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                            (v128.const f32x4 nan nan nan nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                            (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                            (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                            (v128.const f32x4 -inf -inf -inf -inf))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                            (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                            (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                            (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                            (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                            (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                            (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                            (v128.const f32x4 -nan -nan -nan -nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                            (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                            (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                            (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                            (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                            (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                            (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                            (v128.const f32x4 inf inf inf inf))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                            (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                            (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 -inf -inf -inf -inf)
                            (v128.const f32x4 nan nan nan nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 -inf -inf -inf -inf)
                            (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "lt" (v128.const f32x4 -inf -inf -inf -inf)
                            (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 -inf -inf -inf -inf)
                            (v128.const f32x4 -inf -inf -inf -inf))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 -inf -inf -inf -inf)
                            (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "lt" (v128.const f32x4 -inf -inf -inf -inf)
                            (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "lt" (v128.const f32x4 -inf -inf -inf -inf)
                            (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "lt" (v128.const f32x4 -inf -inf -inf -inf)
                            (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "lt" (v128.const f32x4 -inf -inf -inf -inf)
                            (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "lt" (v128.const f32x4 -inf -inf -inf -inf)
                            (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "lt" (v128.const f32x4 -inf -inf -inf -inf)
                            (v128.const f32x4 -nan -nan -nan -nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 -inf -inf -inf -inf)
                            (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "lt" (v128.const f32x4 -inf -inf -inf -inf)
                            (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "lt" (v128.const f32x4 -inf -inf -inf -inf)
                            (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "lt" (v128.const f32x4 -inf -inf -inf -inf)
                            (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "lt" (v128.const f32x4 -inf -inf -inf -inf)
                            (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 -inf -inf -inf -inf)
                            (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "lt" (v128.const f32x4 -inf -inf -inf -inf)
                            (v128.const f32x4 inf inf inf inf))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "lt" (v128.const f32x4 -inf -inf -inf -inf)
                            (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "lt" (v128.const f32x4 -inf -inf -inf -inf)
                            (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "lt" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                            (v128.const f32x4 nan nan nan nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                            (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                            (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                            (v128.const f32x4 -inf -inf -inf -inf))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                            (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                            (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                            (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                            (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                            (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                            (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "lt" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                            (v128.const f32x4 -nan -nan -nan -nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                            (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                            (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                            (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                            (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                            (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                            (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                            (v128.const f32x4 inf inf inf inf))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "lt" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                            (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                            (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                            (v128.const f32x4 nan nan nan nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                            (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                            (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                            (v128.const f32x4 -inf -inf -inf -inf))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                            (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "lt" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                            (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                            (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                            (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                            (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                            (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "lt" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                            (v128.const f32x4 -nan -nan -nan -nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                            (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                            (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                            (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                            (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                            (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                            (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                            (v128.const f32x4 inf inf inf inf))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "lt" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                            (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                            (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                            (v128.const f32x4 nan nan nan nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                            (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "lt" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                            (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                            (v128.const f32x4 -inf -inf -inf -inf))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                            (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "lt" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                            (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "lt" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                            (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                            (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "lt" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                            (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "lt" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                            (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "lt" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                            (v128.const f32x4 -nan -nan -nan -nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                            (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "lt" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                            (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "lt" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                            (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "lt" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                            (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "lt" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                            (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                            (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "lt" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                            (v128.const f32x4 inf inf inf inf))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "lt" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                            (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "lt" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                            (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "lt" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                            (v128.const f32x4 nan nan nan nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                            (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "lt" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                            (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                            (v128.const f32x4 -inf -inf -inf -inf))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                            (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "lt" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                            (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "lt" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                            (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                            (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                            (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                            (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "lt" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                            (v128.const f32x4 -nan -nan -nan -nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                            (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                            (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                            (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "lt" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                            (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                            (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                            (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                            (v128.const f32x4 inf inf inf inf))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "lt" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                            (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                            (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "lt" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                            (v128.const f32x4 nan nan nan nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                            (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "lt" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                            (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                            (v128.const f32x4 -inf -inf -inf -inf))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                            (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "lt" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                            (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "lt" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                            (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                            (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "lt" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                            (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                            (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "lt" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                            (v128.const f32x4 -nan -nan -nan -nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                            (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "lt" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                            (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "lt" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                            (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "lt" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                            (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                            (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                            (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "lt" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                            (v128.const f32x4 inf inf inf inf))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "lt" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                            (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                            (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "lt" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                            (v128.const f32x4 nan nan nan nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                            (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                            (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                            (v128.const f32x4 -inf -inf -inf -inf))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                            (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                            (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                            (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                            (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                            (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                            (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                            (v128.const f32x4 -nan -nan -nan -nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                            (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                            (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                            (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                            (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                            (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                            (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                            (v128.const f32x4 inf inf inf inf))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "lt" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                            (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                            (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 -nan -nan -nan -nan)
                            (v128.const f32x4 nan nan nan nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 -nan -nan -nan -nan)
                            (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 -nan -nan -nan -nan)
                            (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 -nan -nan -nan -nan)
                            (v128.const f32x4 -inf -inf -inf -inf))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 -nan -nan -nan -nan)
                            (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 -nan -nan -nan -nan)
                            (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 -nan -nan -nan -nan)
                            (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 -nan -nan -nan -nan)
                            (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 -nan -nan -nan -nan)
                            (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 -nan -nan -nan -nan)
                            (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 -nan -nan -nan -nan)
                            (v128.const f32x4 -nan -nan -nan -nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 -nan -nan -nan -nan)
                            (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 -nan -nan -nan -nan)
                            (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 -nan -nan -nan -nan)
                            (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 -nan -nan -nan -nan)
                            (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 -nan -nan -nan -nan)
                            (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 -nan -nan -nan -nan)
                            (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 -nan -nan -nan -nan)
                            (v128.const f32x4 inf inf inf inf))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 -nan -nan -nan -nan)
                            (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 -nan -nan -nan -nan)
                            (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                            (v128.const f32x4 nan nan nan nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                            (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "lt" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                            (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                            (v128.const f32x4 -inf -inf -inf -inf))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                            (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "lt" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                            (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "lt" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                            (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                            (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "lt" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                            (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                            (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "lt" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                            (v128.const f32x4 -nan -nan -nan -nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                            (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                            (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                            (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "lt" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                            (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                            (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                            (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "lt" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                            (v128.const f32x4 inf inf inf inf))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "lt" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                            (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                            (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "lt" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                            (v128.const f32x4 nan nan nan nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                            (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "lt" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                            (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                            (v128.const f32x4 -inf -inf -inf -inf))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                            (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "lt" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                            (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "lt" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                            (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                            (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "lt" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                            (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                            (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "lt" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                            (v128.const f32x4 -nan -nan -nan -nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                            (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "lt" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                            (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                            (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "lt" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                            (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                            (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                            (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "lt" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                            (v128.const f32x4 inf inf inf inf))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "lt" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                            (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                            (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "lt" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                            (v128.const f32x4 nan nan nan nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                            (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                            (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                            (v128.const f32x4 -inf -inf -inf -inf))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                            (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "lt" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                            (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "lt" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                            (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                            (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                            (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                            (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "lt" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                            (v128.const f32x4 -nan -nan -nan -nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                            (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                            (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                            (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                            (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                            (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                            (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                            (v128.const f32x4 inf inf inf inf))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "lt" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                            (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                            (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                            (v128.const f32x4 nan nan nan nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                            (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "lt" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                            (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                            (v128.const f32x4 -inf -inf -inf -inf))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                            (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "lt" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                            (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "lt" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                            (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                            (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "lt" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                            (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "lt" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                            (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "lt" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                            (v128.const f32x4 -nan -nan -nan -nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                            (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "lt" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                            (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "lt" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                            (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "lt" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                            (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                            (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                            (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "lt" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                            (v128.const f32x4 inf inf inf inf))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "lt" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                            (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "lt" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                            (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "lt" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                            (v128.const f32x4 nan nan nan nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                            (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                            (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                            (v128.const f32x4 -inf -inf -inf -inf))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                            (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                            (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                            (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                            (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                            (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                            (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                            (v128.const f32x4 -nan -nan -nan -nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                            (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                            (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                            (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                            (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                            (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                            (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                            (v128.const f32x4 inf inf inf inf))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                            (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                            (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                            (v128.const f32x4 nan nan nan nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                            (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "lt" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                            (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                            (v128.const f32x4 -inf -inf -inf -inf))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                            (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "lt" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                            (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "lt" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                            (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                            (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                            (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                            (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "lt" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                            (v128.const f32x4 -nan -nan -nan -nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                            (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                            (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                            (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "lt" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                            (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                            (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                            (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                            (v128.const f32x4 inf inf inf inf))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "lt" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                            (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                            (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "lt" (v128.const f32x4 inf inf inf inf)
                            (v128.const f32x4 nan nan nan nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 inf inf inf inf)
                            (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 inf inf inf inf)
                            (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 inf inf inf inf)
                            (v128.const f32x4 -inf -inf -inf -inf))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 inf inf inf inf)
                            (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 inf inf inf inf)
                            (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 inf inf inf inf)
                            (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 inf inf inf inf)
                            (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 inf inf inf inf)
                            (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 inf inf inf inf)
                            (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 inf inf inf inf)
                            (v128.const f32x4 -nan -nan -nan -nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 inf inf inf inf)
                            (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 inf inf inf inf)
                            (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 inf inf inf inf)
                            (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 inf inf inf inf)
                            (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 inf inf inf inf)
                            (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 inf inf inf inf)
                            (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 inf inf inf inf)
                            (v128.const f32x4 inf inf inf inf))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 inf inf inf inf)
                            (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 inf inf inf inf)
                            (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                            (v128.const f32x4 nan nan nan nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                            (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "lt" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                            (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                            (v128.const f32x4 -inf -inf -inf -inf))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                            (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "lt" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                            (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "lt" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                            (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                            (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "lt" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                            (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "lt" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                            (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "lt" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                            (v128.const f32x4 -nan -nan -nan -nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                            (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "lt" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                            (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "lt" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                            (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "lt" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                            (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                            (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                            (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "lt" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                            (v128.const f32x4 inf inf inf inf))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "lt" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                            (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                            (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "lt" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                            (v128.const f32x4 nan nan nan nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                            (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                            (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                            (v128.const f32x4 -inf -inf -inf -inf))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                            (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "lt" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                            (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "lt" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                            (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                            (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                            (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                            (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "lt" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                            (v128.const f32x4 -nan -nan -nan -nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                            (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                            (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                            (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "lt" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                            (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                            (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                            (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                            (v128.const f32x4 inf inf inf inf))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "lt" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                            (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                            (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019)
                            (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019)
                            (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019)
                            (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019)
                            (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019)
                            (v128.const f32x4 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019)
                            (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "lt" (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019)
                            (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019)
                            (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "lt" (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019)
                            (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "lt" (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019)
                            (v128.const f32x4 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "lt" (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019)
                            (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019)
                            (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019)
                            (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019)
                            (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019)
                            (v128.const f32x4 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019)
                            (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019)
                            (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019)
                            (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019)
                            (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019)
                            (v128.const f32x4 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789)
                            (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "lt" (v128.const f32x4 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789)
                            (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "lt" (v128.const f32x4 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789)
                            (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "lt" (v128.const f32x4 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789)
                            (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "lt" (v128.const f32x4 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789)
                            (v128.const f32x4 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789))
                            (v128.const i32x4 0 0 0 0))

;; le
(assert_return (invoke "le" (v128.const f32x4 nan nan nan nan)
                            (v128.const f32x4 nan nan nan nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 nan nan nan nan)
                            (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 nan nan nan nan)
                            (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 nan nan nan nan)
                            (v128.const f32x4 -inf -inf -inf -inf))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 nan nan nan nan)
                            (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 nan nan nan nan)
                            (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 nan nan nan nan)
                            (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 nan nan nan nan)
                            (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 nan nan nan nan)
                            (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 nan nan nan nan)
                            (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 nan nan nan nan)
                            (v128.const f32x4 -nan -nan -nan -nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 nan nan nan nan)
                            (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 nan nan nan nan)
                            (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 nan nan nan nan)
                            (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 nan nan nan nan)
                            (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 nan nan nan nan)
                            (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 nan nan nan nan)
                            (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 nan nan nan nan)
                            (v128.const f32x4 inf inf inf inf))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 nan nan nan nan)
                            (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 nan nan nan nan)
                            (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                            (v128.const f32x4 nan nan nan nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                            (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "le" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                            (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                            (v128.const f32x4 -inf -inf -inf -inf))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                            (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "le" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                            (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "le" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                            (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                            (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                            (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                            (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "le" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                            (v128.const f32x4 -nan -nan -nan -nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                            (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                            (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                            (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "le" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                            (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                            (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                            (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                            (v128.const f32x4 inf inf inf inf))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "le" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                            (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                            (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "le" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                            (v128.const f32x4 nan nan nan nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                            (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                            (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                            (v128.const f32x4 -inf -inf -inf -inf))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                            (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                            (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                            (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                            (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                            (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                            (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                            (v128.const f32x4 -nan -nan -nan -nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                            (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                            (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                            (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                            (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                            (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                            (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                            (v128.const f32x4 inf inf inf inf))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                            (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                            (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 -inf -inf -inf -inf)
                            (v128.const f32x4 nan nan nan nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 -inf -inf -inf -inf)
                            (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "le" (v128.const f32x4 -inf -inf -inf -inf)
                            (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 -inf -inf -inf -inf)
                            (v128.const f32x4 -inf -inf -inf -inf))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "le" (v128.const f32x4 -inf -inf -inf -inf)
                            (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "le" (v128.const f32x4 -inf -inf -inf -inf)
                            (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "le" (v128.const f32x4 -inf -inf -inf -inf)
                            (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "le" (v128.const f32x4 -inf -inf -inf -inf)
                            (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "le" (v128.const f32x4 -inf -inf -inf -inf)
                            (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "le" (v128.const f32x4 -inf -inf -inf -inf)
                            (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "le" (v128.const f32x4 -inf -inf -inf -inf)
                            (v128.const f32x4 -nan -nan -nan -nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 -inf -inf -inf -inf)
                            (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "le" (v128.const f32x4 -inf -inf -inf -inf)
                            (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "le" (v128.const f32x4 -inf -inf -inf -inf)
                            (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "le" (v128.const f32x4 -inf -inf -inf -inf)
                            (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "le" (v128.const f32x4 -inf -inf -inf -inf)
                            (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 -inf -inf -inf -inf)
                            (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "le" (v128.const f32x4 -inf -inf -inf -inf)
                            (v128.const f32x4 inf inf inf inf))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "le" (v128.const f32x4 -inf -inf -inf -inf)
                            (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "le" (v128.const f32x4 -inf -inf -inf -inf)
                            (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "le" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                            (v128.const f32x4 nan nan nan nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                            (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                            (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                            (v128.const f32x4 -inf -inf -inf -inf))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                            (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "le" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                            (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                            (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                            (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                            (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                            (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "le" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                            (v128.const f32x4 -nan -nan -nan -nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                            (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                            (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                            (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                            (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                            (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                            (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                            (v128.const f32x4 inf inf inf inf))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "le" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                            (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                            (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                            (v128.const f32x4 nan nan nan nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                            (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                            (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                            (v128.const f32x4 -inf -inf -inf -inf))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                            (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "le" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                            (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "le" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                            (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                            (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                            (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                            (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "le" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                            (v128.const f32x4 -nan -nan -nan -nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                            (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                            (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                            (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                            (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                            (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                            (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                            (v128.const f32x4 inf inf inf inf))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "le" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                            (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                            (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                            (v128.const f32x4 nan nan nan nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                            (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "le" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                            (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                            (v128.const f32x4 -inf -inf -inf -inf))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                            (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "le" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                            (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "le" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                            (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "le" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                            (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "le" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                            (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "le" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                            (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "le" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                            (v128.const f32x4 -nan -nan -nan -nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                            (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "le" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                            (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "le" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                            (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "le" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                            (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "le" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                            (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                            (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "le" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                            (v128.const f32x4 inf inf inf inf))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "le" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                            (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "le" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                            (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "le" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                            (v128.const f32x4 nan nan nan nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                            (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "le" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                            (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                            (v128.const f32x4 -inf -inf -inf -inf))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                            (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "le" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                            (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "le" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                            (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                            (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "le" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                            (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                            (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "le" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                            (v128.const f32x4 -nan -nan -nan -nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                            (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                            (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                            (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "le" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                            (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                            (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                            (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "le" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                            (v128.const f32x4 inf inf inf inf))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "le" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                            (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                            (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "le" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                            (v128.const f32x4 nan nan nan nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                            (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "le" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                            (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                            (v128.const f32x4 -inf -inf -inf -inf))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                            (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "le" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                            (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "le" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                            (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                            (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "le" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                            (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "le" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                            (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "le" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                            (v128.const f32x4 -nan -nan -nan -nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                            (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "le" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                            (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "le" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                            (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "le" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                            (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                            (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                            (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "le" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                            (v128.const f32x4 inf inf inf inf))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "le" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                            (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                            (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "le" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                            (v128.const f32x4 nan nan nan nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                            (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                            (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                            (v128.const f32x4 -inf -inf -inf -inf))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                            (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                            (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                            (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                            (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                            (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                            (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "le" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                            (v128.const f32x4 -nan -nan -nan -nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                            (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                            (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                            (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                            (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                            (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                            (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                            (v128.const f32x4 inf inf inf inf))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "le" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                            (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                            (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 -nan -nan -nan -nan)
                            (v128.const f32x4 nan nan nan nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 -nan -nan -nan -nan)
                            (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 -nan -nan -nan -nan)
                            (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 -nan -nan -nan -nan)
                            (v128.const f32x4 -inf -inf -inf -inf))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 -nan -nan -nan -nan)
                            (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 -nan -nan -nan -nan)
                            (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 -nan -nan -nan -nan)
                            (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 -nan -nan -nan -nan)
                            (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 -nan -nan -nan -nan)
                            (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 -nan -nan -nan -nan)
                            (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 -nan -nan -nan -nan)
                            (v128.const f32x4 -nan -nan -nan -nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 -nan -nan -nan -nan)
                            (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 -nan -nan -nan -nan)
                            (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 -nan -nan -nan -nan)
                            (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 -nan -nan -nan -nan)
                            (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 -nan -nan -nan -nan)
                            (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 -nan -nan -nan -nan)
                            (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 -nan -nan -nan -nan)
                            (v128.const f32x4 inf inf inf inf))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 -nan -nan -nan -nan)
                            (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 -nan -nan -nan -nan)
                            (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                            (v128.const f32x4 nan nan nan nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                            (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "le" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                            (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                            (v128.const f32x4 -inf -inf -inf -inf))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                            (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "le" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                            (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "le" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                            (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                            (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "le" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                            (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                            (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "le" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                            (v128.const f32x4 -nan -nan -nan -nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                            (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "le" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                            (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                            (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "le" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                            (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                            (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                            (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "le" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                            (v128.const f32x4 inf inf inf inf))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "le" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                            (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                            (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "le" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                            (v128.const f32x4 nan nan nan nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                            (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "le" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                            (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                            (v128.const f32x4 -inf -inf -inf -inf))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                            (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "le" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                            (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "le" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                            (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                            (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "le" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                            (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                            (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "le" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                            (v128.const f32x4 -nan -nan -nan -nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                            (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "le" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                            (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "le" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                            (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "le" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                            (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                            (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                            (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "le" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                            (v128.const f32x4 inf inf inf inf))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "le" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                            (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                            (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "le" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                            (v128.const f32x4 nan nan nan nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                            (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                            (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                            (v128.const f32x4 -inf -inf -inf -inf))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                            (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "le" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                            (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "le" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                            (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                            (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                            (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                            (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "le" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                            (v128.const f32x4 -nan -nan -nan -nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                            (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                            (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                            (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "le" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                            (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                            (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                            (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                            (v128.const f32x4 inf inf inf inf))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "le" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                            (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                            (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                            (v128.const f32x4 nan nan nan nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                            (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "le" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                            (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                            (v128.const f32x4 -inf -inf -inf -inf))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                            (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "le" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                            (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "le" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                            (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                            (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "le" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                            (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "le" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                            (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "le" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                            (v128.const f32x4 -nan -nan -nan -nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                            (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "le" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                            (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "le" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                            (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "le" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                            (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "le" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                            (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                            (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "le" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                            (v128.const f32x4 inf inf inf inf))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "le" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                            (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "le" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                            (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "le" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                            (v128.const f32x4 nan nan nan nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                            (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                            (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                            (v128.const f32x4 -inf -inf -inf -inf))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                            (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                            (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                            (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                            (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                            (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                            (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                            (v128.const f32x4 -nan -nan -nan -nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                            (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                            (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                            (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                            (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                            (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                            (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                            (v128.const f32x4 inf inf inf inf))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                            (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                            (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                            (v128.const f32x4 nan nan nan nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                            (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "le" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                            (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                            (v128.const f32x4 -inf -inf -inf -inf))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                            (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "le" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                            (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "le" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                            (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                            (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "le" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                            (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                            (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "le" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                            (v128.const f32x4 -nan -nan -nan -nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                            (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                            (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                            (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "le" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                            (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                            (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                            (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "le" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                            (v128.const f32x4 inf inf inf inf))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "le" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                            (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                            (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "le" (v128.const f32x4 inf inf inf inf)
                            (v128.const f32x4 nan nan nan nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 inf inf inf inf)
                            (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 inf inf inf inf)
                            (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 inf inf inf inf)
                            (v128.const f32x4 -inf -inf -inf -inf))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 inf inf inf inf)
                            (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 inf inf inf inf)
                            (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 inf inf inf inf)
                            (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 inf inf inf inf)
                            (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 inf inf inf inf)
                            (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 inf inf inf inf)
                            (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 inf inf inf inf)
                            (v128.const f32x4 -nan -nan -nan -nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 inf inf inf inf)
                            (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 inf inf inf inf)
                            (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 inf inf inf inf)
                            (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 inf inf inf inf)
                            (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 inf inf inf inf)
                            (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 inf inf inf inf)
                            (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 inf inf inf inf)
                            (v128.const f32x4 inf inf inf inf))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "le" (v128.const f32x4 inf inf inf inf)
                            (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 inf inf inf inf)
                            (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                            (v128.const f32x4 nan nan nan nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                            (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "le" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                            (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                            (v128.const f32x4 -inf -inf -inf -inf))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                            (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "le" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                            (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "le" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                            (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                            (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "le" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                            (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "le" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                            (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "le" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                            (v128.const f32x4 -nan -nan -nan -nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                            (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "le" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                            (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "le" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                            (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "le" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                            (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                            (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                            (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "le" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                            (v128.const f32x4 inf inf inf inf))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "le" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                            (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "le" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                            (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "le" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                            (v128.const f32x4 nan nan nan nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                            (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                            (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                            (v128.const f32x4 -inf -inf -inf -inf))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                            (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "le" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                            (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "le" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                            (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                            (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                            (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                            (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "le" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                            (v128.const f32x4 -nan -nan -nan -nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                            (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                            (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                            (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "le" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                            (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                            (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                            (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                            (v128.const f32x4 inf inf inf inf))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "le" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                            (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                            (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "le" (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019)
                            (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "le" (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019)
                            (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019)
                            (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "le" (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019)
                            (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "le" (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019)
                            (v128.const f32x4 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019)
                            (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "le" (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019)
                            (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "le" (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019)
                            (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "le" (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019)
                            (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "le" (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019)
                            (v128.const f32x4 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "le" (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019)
                            (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "le" (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019)
                            (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019)
                            (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "le" (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019)
                            (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "le" (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019)
                            (v128.const f32x4 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019)
                            (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "le" (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019)
                            (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019)
                            (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "le" (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019)
                            (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "le" (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019)
                            (v128.const f32x4 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789)
                            (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "le" (v128.const f32x4 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789)
                            (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "le" (v128.const f32x4 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789)
                            (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "le" (v128.const f32x4 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789)
                            (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "le" (v128.const f32x4 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789)
                            (v128.const f32x4 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789))
                            (v128.const i32x4 -1 -1 -1 -1))

;; gt
(assert_return (invoke "gt" (v128.const f32x4 nan nan nan nan)
                            (v128.const f32x4 nan nan nan nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 nan nan nan nan)
                            (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 nan nan nan nan)
                            (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 nan nan nan nan)
                            (v128.const f32x4 -inf -inf -inf -inf))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 nan nan nan nan)
                            (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 nan nan nan nan)
                            (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 nan nan nan nan)
                            (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 nan nan nan nan)
                            (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 nan nan nan nan)
                            (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 nan nan nan nan)
                            (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 nan nan nan nan)
                            (v128.const f32x4 -nan -nan -nan -nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 nan nan nan nan)
                            (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 nan nan nan nan)
                            (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 nan nan nan nan)
                            (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 nan nan nan nan)
                            (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 nan nan nan nan)
                            (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 nan nan nan nan)
                            (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 nan nan nan nan)
                            (v128.const f32x4 inf inf inf inf))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 nan nan nan nan)
                            (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 nan nan nan nan)
                            (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                            (v128.const f32x4 nan nan nan nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                            (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                            (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                            (v128.const f32x4 -inf -inf -inf -inf))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "gt" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                            (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                            (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                            (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "gt" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                            (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "gt" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                            (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "gt" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                            (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                            (v128.const f32x4 -nan -nan -nan -nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                            (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "gt" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                            (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "gt" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                            (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                            (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "gt" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                            (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                            (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "gt" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                            (v128.const f32x4 inf inf inf inf))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                            (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "gt" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                            (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                            (v128.const f32x4 nan nan nan nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                            (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                            (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                            (v128.const f32x4 -inf -inf -inf -inf))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                            (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                            (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                            (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                            (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                            (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                            (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                            (v128.const f32x4 -nan -nan -nan -nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                            (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                            (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                            (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                            (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                            (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                            (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                            (v128.const f32x4 inf inf inf inf))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                            (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                            (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 -inf -inf -inf -inf)
                            (v128.const f32x4 nan nan nan nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 -inf -inf -inf -inf)
                            (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 -inf -inf -inf -inf)
                            (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 -inf -inf -inf -inf)
                            (v128.const f32x4 -inf -inf -inf -inf))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 -inf -inf -inf -inf)
                            (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 -inf -inf -inf -inf)
                            (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 -inf -inf -inf -inf)
                            (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 -inf -inf -inf -inf)
                            (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 -inf -inf -inf -inf)
                            (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 -inf -inf -inf -inf)
                            (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 -inf -inf -inf -inf)
                            (v128.const f32x4 -nan -nan -nan -nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 -inf -inf -inf -inf)
                            (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 -inf -inf -inf -inf)
                            (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 -inf -inf -inf -inf)
                            (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 -inf -inf -inf -inf)
                            (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 -inf -inf -inf -inf)
                            (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 -inf -inf -inf -inf)
                            (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 -inf -inf -inf -inf)
                            (v128.const f32x4 inf inf inf inf))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 -inf -inf -inf -inf)
                            (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 -inf -inf -inf -inf)
                            (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                            (v128.const f32x4 nan nan nan nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                            (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "gt" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                            (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                            (v128.const f32x4 -inf -inf -inf -inf))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "gt" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                            (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                            (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "gt" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                            (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "gt" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                            (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "gt" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                            (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "gt" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                            (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                            (v128.const f32x4 -nan -nan -nan -nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                            (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "gt" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                            (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "gt" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                            (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "gt" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                            (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "gt" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                            (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                            (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "gt" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                            (v128.const f32x4 inf inf inf inf))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                            (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "gt" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                            (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "gt" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                            (v128.const f32x4 nan nan nan nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                            (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "gt" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                            (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                            (v128.const f32x4 -inf -inf -inf -inf))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "gt" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                            (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                            (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                            (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "gt" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                            (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "gt" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                            (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "gt" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                            (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                            (v128.const f32x4 -nan -nan -nan -nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                            (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "gt" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                            (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "gt" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                            (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "gt" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                            (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "gt" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                            (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                            (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "gt" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                            (v128.const f32x4 inf inf inf inf))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                            (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "gt" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                            (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "gt" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                            (v128.const f32x4 nan nan nan nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                            (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                            (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                            (v128.const f32x4 -inf -inf -inf -inf))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "gt" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                            (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                            (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                            (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                            (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                            (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                            (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                            (v128.const f32x4 -nan -nan -nan -nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                            (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                            (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                            (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                            (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                            (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                            (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                            (v128.const f32x4 inf inf inf inf))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                            (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                            (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                            (v128.const f32x4 nan nan nan nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                            (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                            (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                            (v128.const f32x4 -inf -inf -inf -inf))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "gt" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                            (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                            (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                            (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "gt" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                            (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                            (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "gt" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                            (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                            (v128.const f32x4 -nan -nan -nan -nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                            (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "gt" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                            (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "gt" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                            (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                            (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "gt" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                            (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                            (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                            (v128.const f32x4 inf inf inf inf))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                            (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "gt" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                            (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                            (v128.const f32x4 nan nan nan nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                            (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                            (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                            (v128.const f32x4 -inf -inf -inf -inf))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "gt" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                            (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                            (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                            (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "gt" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                            (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                            (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                            (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                            (v128.const f32x4 -nan -nan -nan -nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                            (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                            (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                            (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                            (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "gt" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                            (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                            (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                            (v128.const f32x4 inf inf inf inf))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                            (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "gt" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                            (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                            (v128.const f32x4 nan nan nan nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                            (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "gt" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                            (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                            (v128.const f32x4 -inf -inf -inf -inf))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "gt" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                            (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "gt" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                            (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "gt" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                            (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "gt" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                            (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "gt" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                            (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "gt" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                            (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                            (v128.const f32x4 -nan -nan -nan -nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                            (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "gt" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                            (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "gt" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                            (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "gt" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                            (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "gt" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                            (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                            (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "gt" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                            (v128.const f32x4 inf inf inf inf))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                            (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "gt" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                            (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "gt" (v128.const f32x4 -nan -nan -nan -nan)
                            (v128.const f32x4 nan nan nan nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 -nan -nan -nan -nan)
                            (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 -nan -nan -nan -nan)
                            (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 -nan -nan -nan -nan)
                            (v128.const f32x4 -inf -inf -inf -inf))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 -nan -nan -nan -nan)
                            (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 -nan -nan -nan -nan)
                            (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 -nan -nan -nan -nan)
                            (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 -nan -nan -nan -nan)
                            (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 -nan -nan -nan -nan)
                            (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 -nan -nan -nan -nan)
                            (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 -nan -nan -nan -nan)
                            (v128.const f32x4 -nan -nan -nan -nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 -nan -nan -nan -nan)
                            (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 -nan -nan -nan -nan)
                            (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 -nan -nan -nan -nan)
                            (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 -nan -nan -nan -nan)
                            (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 -nan -nan -nan -nan)
                            (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 -nan -nan -nan -nan)
                            (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 -nan -nan -nan -nan)
                            (v128.const f32x4 inf inf inf inf))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 -nan -nan -nan -nan)
                            (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 -nan -nan -nan -nan)
                            (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                            (v128.const f32x4 nan nan nan nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                            (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                            (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                            (v128.const f32x4 -inf -inf -inf -inf))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "gt" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                            (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                            (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                            (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "gt" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                            (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                            (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "gt" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                            (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                            (v128.const f32x4 -nan -nan -nan -nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                            (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                            (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "gt" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                            (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                            (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "gt" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                            (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                            (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                            (v128.const f32x4 inf inf inf inf))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                            (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "gt" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                            (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                            (v128.const f32x4 nan nan nan nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                            (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                            (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                            (v128.const f32x4 -inf -inf -inf -inf))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "gt" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                            (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                            (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                            (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "gt" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                            (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                            (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "gt" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                            (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                            (v128.const f32x4 -nan -nan -nan -nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                            (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                            (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                            (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                            (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "gt" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                            (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                            (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                            (v128.const f32x4 inf inf inf inf))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                            (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "gt" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                            (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                            (v128.const f32x4 nan nan nan nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                            (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "gt" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                            (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                            (v128.const f32x4 -inf -inf -inf -inf))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "gt" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                            (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                            (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                            (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "gt" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                            (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "gt" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                            (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "gt" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                            (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                            (v128.const f32x4 -nan -nan -nan -nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                            (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "gt" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                            (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "gt" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                            (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                            (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "gt" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                            (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                            (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "gt" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                            (v128.const f32x4 inf inf inf inf))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                            (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "gt" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                            (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "gt" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                            (v128.const f32x4 nan nan nan nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                            (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                            (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                            (v128.const f32x4 -inf -inf -inf -inf))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "gt" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                            (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                            (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                            (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "gt" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                            (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                            (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                            (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                            (v128.const f32x4 -nan -nan -nan -nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                            (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                            (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                            (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                            (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                            (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                            (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                            (v128.const f32x4 inf inf inf inf))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                            (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                            (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                            (v128.const f32x4 nan nan nan nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                            (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                            (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                            (v128.const f32x4 -inf -inf -inf -inf))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                            (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                            (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                            (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                            (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                            (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                            (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                            (v128.const f32x4 -nan -nan -nan -nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                            (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                            (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                            (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                            (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                            (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                            (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                            (v128.const f32x4 inf inf inf inf))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                            (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                            (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                            (v128.const f32x4 nan nan nan nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                            (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                            (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                            (v128.const f32x4 -inf -inf -inf -inf))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "gt" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                            (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                            (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                            (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "gt" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                            (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                            (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "gt" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                            (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                            (v128.const f32x4 -nan -nan -nan -nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                            (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "gt" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                            (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "gt" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                            (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                            (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "gt" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                            (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                            (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                            (v128.const f32x4 inf inf inf inf))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                            (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "gt" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                            (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 inf inf inf inf)
                            (v128.const f32x4 nan nan nan nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 inf inf inf inf)
                            (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "gt" (v128.const f32x4 inf inf inf inf)
                            (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 inf inf inf inf)
                            (v128.const f32x4 -inf -inf -inf -inf))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "gt" (v128.const f32x4 inf inf inf inf)
                            (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "gt" (v128.const f32x4 inf inf inf inf)
                            (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "gt" (v128.const f32x4 inf inf inf inf)
                            (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "gt" (v128.const f32x4 inf inf inf inf)
                            (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "gt" (v128.const f32x4 inf inf inf inf)
                            (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "gt" (v128.const f32x4 inf inf inf inf)
                            (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "gt" (v128.const f32x4 inf inf inf inf)
                            (v128.const f32x4 -nan -nan -nan -nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 inf inf inf inf)
                            (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "gt" (v128.const f32x4 inf inf inf inf)
                            (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "gt" (v128.const f32x4 inf inf inf inf)
                            (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "gt" (v128.const f32x4 inf inf inf inf)
                            (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "gt" (v128.const f32x4 inf inf inf inf)
                            (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 inf inf inf inf)
                            (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "gt" (v128.const f32x4 inf inf inf inf)
                            (v128.const f32x4 inf inf inf inf))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 inf inf inf inf)
                            (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "gt" (v128.const f32x4 inf inf inf inf)
                            (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "gt" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                            (v128.const f32x4 nan nan nan nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                            (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                            (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                            (v128.const f32x4 -inf -inf -inf -inf))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "gt" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                            (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                            (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                            (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "gt" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                            (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                            (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                            (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                            (v128.const f32x4 -nan -nan -nan -nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                            (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                            (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                            (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                            (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "gt" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                            (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                            (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                            (v128.const f32x4 inf inf inf inf))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                            (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                            (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                            (v128.const f32x4 nan nan nan nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                            (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "gt" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                            (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                            (v128.const f32x4 -inf -inf -inf -inf))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "gt" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                            (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                            (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                            (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "gt" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                            (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "gt" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                            (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "gt" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                            (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                            (v128.const f32x4 -nan -nan -nan -nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                            (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "gt" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                            (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "gt" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                            (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                            (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "gt" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                            (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                            (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "gt" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                            (v128.const f32x4 inf inf inf inf))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                            (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "gt" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                            (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019)
                            (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019)
                            (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "gt" (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019)
                            (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019)
                            (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019)
                            (v128.const f32x4 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "gt" (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019)
                            (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019)
                            (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019)
                            (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019)
                            (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019)
                            (v128.const f32x4 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019)
                            (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019)
                            (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "gt" (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019)
                            (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019)
                            (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019)
                            (v128.const f32x4 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "gt" (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019)
                            (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019)
                            (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "gt" (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019)
                            (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019)
                            (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019)
                            (v128.const f32x4 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "gt" (v128.const f32x4 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789)
                            (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789)
                            (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "gt" (v128.const f32x4 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789)
                            (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789)
                            (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "gt" (v128.const f32x4 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789)
                            (v128.const f32x4 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789))
                            (v128.const i32x4 0 0 0 0))

;; ge
(assert_return (invoke "ge" (v128.const f32x4 nan nan nan nan)
                            (v128.const f32x4 nan nan nan nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 nan nan nan nan)
                            (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 nan nan nan nan)
                            (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 nan nan nan nan)
                            (v128.const f32x4 -inf -inf -inf -inf))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 nan nan nan nan)
                            (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 nan nan nan nan)
                            (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 nan nan nan nan)
                            (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 nan nan nan nan)
                            (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 nan nan nan nan)
                            (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 nan nan nan nan)
                            (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 nan nan nan nan)
                            (v128.const f32x4 -nan -nan -nan -nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 nan nan nan nan)
                            (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 nan nan nan nan)
                            (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 nan nan nan nan)
                            (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 nan nan nan nan)
                            (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 nan nan nan nan)
                            (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 nan nan nan nan)
                            (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 nan nan nan nan)
                            (v128.const f32x4 inf inf inf inf))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 nan nan nan nan)
                            (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 nan nan nan nan)
                            (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                            (v128.const f32x4 nan nan nan nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                            (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ge" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                            (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                            (v128.const f32x4 -inf -inf -inf -inf))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ge" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                            (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                            (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                            (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ge" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                            (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ge" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                            (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ge" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                            (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                            (v128.const f32x4 -nan -nan -nan -nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                            (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ge" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                            (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ge" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                            (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                            (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ge" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                            (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                            (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ge" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                            (v128.const f32x4 inf inf inf inf))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                            (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ge" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                            (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                            (v128.const f32x4 nan nan nan nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                            (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                            (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                            (v128.const f32x4 -inf -inf -inf -inf))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                            (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                            (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                            (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                            (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                            (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                            (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                            (v128.const f32x4 -nan -nan -nan -nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                            (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                            (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                            (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                            (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                            (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                            (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                            (v128.const f32x4 inf inf inf inf))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                            (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                            (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 -inf -inf -inf -inf)
                            (v128.const f32x4 nan nan nan nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 -inf -inf -inf -inf)
                            (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 -inf -inf -inf -inf)
                            (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 -inf -inf -inf -inf)
                            (v128.const f32x4 -inf -inf -inf -inf))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ge" (v128.const f32x4 -inf -inf -inf -inf)
                            (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 -inf -inf -inf -inf)
                            (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 -inf -inf -inf -inf)
                            (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 -inf -inf -inf -inf)
                            (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 -inf -inf -inf -inf)
                            (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 -inf -inf -inf -inf)
                            (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 -inf -inf -inf -inf)
                            (v128.const f32x4 -nan -nan -nan -nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 -inf -inf -inf -inf)
                            (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 -inf -inf -inf -inf)
                            (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 -inf -inf -inf -inf)
                            (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 -inf -inf -inf -inf)
                            (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 -inf -inf -inf -inf)
                            (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 -inf -inf -inf -inf)
                            (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 -inf -inf -inf -inf)
                            (v128.const f32x4 inf inf inf inf))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 -inf -inf -inf -inf)
                            (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 -inf -inf -inf -inf)
                            (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                            (v128.const f32x4 nan nan nan nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                            (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ge" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                            (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                            (v128.const f32x4 -inf -inf -inf -inf))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ge" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                            (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ge" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                            (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ge" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                            (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ge" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                            (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ge" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                            (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ge" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                            (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                            (v128.const f32x4 -nan -nan -nan -nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                            (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ge" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                            (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ge" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                            (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ge" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                            (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ge" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                            (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                            (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ge" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                            (v128.const f32x4 inf inf inf inf))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                            (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ge" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                            (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ge" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                            (v128.const f32x4 nan nan nan nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                            (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ge" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                            (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                            (v128.const f32x4 -inf -inf -inf -inf))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ge" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                            (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                            (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ge" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                            (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ge" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                            (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ge" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                            (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ge" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                            (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                            (v128.const f32x4 -nan -nan -nan -nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                            (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ge" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                            (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ge" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                            (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ge" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                            (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ge" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                            (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                            (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ge" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                            (v128.const f32x4 inf inf inf inf))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                            (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ge" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                            (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ge" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                            (v128.const f32x4 nan nan nan nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                            (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                            (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                            (v128.const f32x4 -inf -inf -inf -inf))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ge" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                            (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                            (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                            (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ge" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                            (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                            (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                            (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                            (v128.const f32x4 -nan -nan -nan -nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                            (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                            (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                            (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                            (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                            (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                            (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                            (v128.const f32x4 inf inf inf inf))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                            (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                            (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                            (v128.const f32x4 nan nan nan nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                            (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                            (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                            (v128.const f32x4 -inf -inf -inf -inf))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ge" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                            (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                            (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                            (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ge" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                            (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ge" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                            (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ge" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                            (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                            (v128.const f32x4 -nan -nan -nan -nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                            (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ge" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                            (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ge" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                            (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                            (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ge" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                            (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                            (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ge" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                            (v128.const f32x4 inf inf inf inf))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                            (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ge" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                            (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                            (v128.const f32x4 nan nan nan nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                            (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                            (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                            (v128.const f32x4 -inf -inf -inf -inf))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ge" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                            (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                            (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                            (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ge" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                            (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                            (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ge" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                            (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                            (v128.const f32x4 -nan -nan -nan -nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                            (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                            (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                            (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                            (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ge" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                            (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                            (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                            (v128.const f32x4 inf inf inf inf))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                            (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ge" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                            (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                            (v128.const f32x4 nan nan nan nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                            (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ge" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                            (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                            (v128.const f32x4 -inf -inf -inf -inf))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ge" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                            (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ge" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                            (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ge" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                            (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ge" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                            (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ge" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                            (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ge" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                            (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ge" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                            (v128.const f32x4 -nan -nan -nan -nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                            (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ge" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                            (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ge" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                            (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ge" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                            (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ge" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                            (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                            (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ge" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                            (v128.const f32x4 inf inf inf inf))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                            (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ge" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                            (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ge" (v128.const f32x4 -nan -nan -nan -nan)
                            (v128.const f32x4 nan nan nan nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 -nan -nan -nan -nan)
                            (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 -nan -nan -nan -nan)
                            (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 -nan -nan -nan -nan)
                            (v128.const f32x4 -inf -inf -inf -inf))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 -nan -nan -nan -nan)
                            (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 -nan -nan -nan -nan)
                            (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 -nan -nan -nan -nan)
                            (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 -nan -nan -nan -nan)
                            (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 -nan -nan -nan -nan)
                            (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 -nan -nan -nan -nan)
                            (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 -nan -nan -nan -nan)
                            (v128.const f32x4 -nan -nan -nan -nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 -nan -nan -nan -nan)
                            (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 -nan -nan -nan -nan)
                            (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 -nan -nan -nan -nan)
                            (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 -nan -nan -nan -nan)
                            (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 -nan -nan -nan -nan)
                            (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 -nan -nan -nan -nan)
                            (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 -nan -nan -nan -nan)
                            (v128.const f32x4 inf inf inf inf))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 -nan -nan -nan -nan)
                            (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 -nan -nan -nan -nan)
                            (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                            (v128.const f32x4 nan nan nan nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                            (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                            (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                            (v128.const f32x4 -inf -inf -inf -inf))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ge" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                            (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                            (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                            (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ge" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                            (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                            (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ge" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                            (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                            (v128.const f32x4 -nan -nan -nan -nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                            (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ge" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                            (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ge" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                            (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                            (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ge" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                            (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                            (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                            (v128.const f32x4 inf inf inf inf))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                            (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ge" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                            (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                            (v128.const f32x4 nan nan nan nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                            (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                            (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                            (v128.const f32x4 -inf -inf -inf -inf))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ge" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                            (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                            (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                            (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ge" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                            (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                            (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ge" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                            (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                            (v128.const f32x4 -nan -nan -nan -nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                            (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                            (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ge" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                            (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                            (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ge" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                            (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                            (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                            (v128.const f32x4 inf inf inf inf))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                            (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ge" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                            (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                            (v128.const f32x4 nan nan nan nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                            (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ge" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                            (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                            (v128.const f32x4 -inf -inf -inf -inf))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ge" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                            (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                            (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                            (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ge" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                            (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ge" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                            (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ge" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                            (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                            (v128.const f32x4 -nan -nan -nan -nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                            (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ge" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                            (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ge" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                            (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ge" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                            (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ge" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                            (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                            (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ge" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                            (v128.const f32x4 inf inf inf inf))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                            (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ge" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                            (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ge" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                            (v128.const f32x4 nan nan nan nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                            (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                            (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                            (v128.const f32x4 -inf -inf -inf -inf))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ge" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                            (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                            (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                            (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ge" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                            (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                            (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                            (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                            (v128.const f32x4 -nan -nan -nan -nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                            (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                            (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                            (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                            (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ge" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                            (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                            (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                            (v128.const f32x4 inf inf inf inf))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                            (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                            (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                            (v128.const f32x4 nan nan nan nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                            (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                            (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                            (v128.const f32x4 -inf -inf -inf -inf))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                            (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                            (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                            (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                            (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                            (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                            (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                            (v128.const f32x4 -nan -nan -nan -nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                            (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                            (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                            (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                            (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                            (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                            (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                            (v128.const f32x4 inf inf inf inf))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                            (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                            (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                            (v128.const f32x4 nan nan nan nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                            (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                            (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                            (v128.const f32x4 -inf -inf -inf -inf))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ge" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                            (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                            (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                            (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ge" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                            (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ge" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                            (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ge" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                            (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                            (v128.const f32x4 -nan -nan -nan -nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                            (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ge" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                            (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ge" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                            (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                            (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ge" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                            (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                            (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ge" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                            (v128.const f32x4 inf inf inf inf))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                            (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ge" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                            (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 inf inf inf inf)
                            (v128.const f32x4 nan nan nan nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 inf inf inf inf)
                            (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ge" (v128.const f32x4 inf inf inf inf)
                            (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 inf inf inf inf)
                            (v128.const f32x4 -inf -inf -inf -inf))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ge" (v128.const f32x4 inf inf inf inf)
                            (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ge" (v128.const f32x4 inf inf inf inf)
                            (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ge" (v128.const f32x4 inf inf inf inf)
                            (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ge" (v128.const f32x4 inf inf inf inf)
                            (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ge" (v128.const f32x4 inf inf inf inf)
                            (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ge" (v128.const f32x4 inf inf inf inf)
                            (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ge" (v128.const f32x4 inf inf inf inf)
                            (v128.const f32x4 -nan -nan -nan -nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 inf inf inf inf)
                            (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ge" (v128.const f32x4 inf inf inf inf)
                            (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ge" (v128.const f32x4 inf inf inf inf)
                            (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ge" (v128.const f32x4 inf inf inf inf)
                            (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ge" (v128.const f32x4 inf inf inf inf)
                            (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 inf inf inf inf)
                            (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ge" (v128.const f32x4 inf inf inf inf)
                            (v128.const f32x4 inf inf inf inf))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ge" (v128.const f32x4 inf inf inf inf)
                            (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ge" (v128.const f32x4 inf inf inf inf)
                            (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ge" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                            (v128.const f32x4 nan nan nan nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                            (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                            (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                            (v128.const f32x4 -inf -inf -inf -inf))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ge" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                            (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                            (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                            (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ge" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                            (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                            (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                            (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                            (v128.const f32x4 -nan -nan -nan -nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                            (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                            (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                            (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                            (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ge" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                            (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                            (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                            (v128.const f32x4 inf inf inf inf))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                            (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ge" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                            (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                            (v128.const f32x4 nan nan nan nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                            (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ge" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                            (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                            (v128.const f32x4 -inf -inf -inf -inf))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ge" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                            (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                            (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                            (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ge" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                            (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ge" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                            (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ge" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                            (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                            (v128.const f32x4 -nan -nan -nan -nan))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                            (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ge" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                            (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ge" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                            (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                            (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ge" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                            (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                            (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ge" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                            (v128.const f32x4 inf inf inf inf))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                            (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ge" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                            (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ge" (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019)
                            (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ge" (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019)
                            (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ge" (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019)
                            (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ge" (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019)
                            (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ge" (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019)
                            (v128.const f32x4 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ge" (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019)
                            (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019)
                            (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ge" (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019)
                            (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019)
                            (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019)
                            (v128.const f32x4 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019)
                            (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ge" (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019)
                            (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ge" (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019)
                            (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ge" (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019)
                            (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ge" (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019)
                            (v128.const f32x4 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ge" (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019)
                            (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ge" (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019)
                            (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ge" (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019)
                            (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ge" (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019)
                            (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ge" (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019)
                            (v128.const f32x4 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ge" (v128.const f32x4 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789)
                            (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789)
                            (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019))
                            (v128.const i32x4 -1 -1 -1 -1))
(assert_return (invoke "ge" (v128.const f32x4 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789)
                            (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789)
                            (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019))
                            (v128.const i32x4 0 0 0 0))
(assert_return (invoke "ge" (v128.const f32x4 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789)
                            (v128.const f32x4 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789))
                            (v128.const i32x4 -1 -1 -1 -1))

;; eq

;; f32x4.eq  (f32x4) (i8x16)
(assert_return (invoke "eq" (v128.const f32x4 -1 0 1 2.0)
                            (v128.const i8x16 -1 -1 -1 -1 0 0 0 0 1 1 1 1 2 2 2 2))
                            (v128.const i32x4 0 -1 0 0))

;; f32x4.eq  (f32x4) (i16x8)
(assert_return (invoke "eq" (v128.const f32x4 -1 0 1 2.0)
                            (v128.const i16x8 -1 -1 0 0 1 1 2 2))
                            (v128.const i32x4 0 -1 0 0))

;; f32x4.eq  (f32x4) (i32x4)
(assert_return (invoke "eq" (v128.const f32x4 -1 0 1 2.0)
                            (v128.const i32x4 3212836864 0 1 2))
                            (v128.const i32x4 -1 -1 0 0 ))

;; ne

;; f32x4.ne  (f32x4) (i8x16)
(assert_return (invoke "ne" (v128.const f32x4 -1 0 1 2.0)
                            (v128.const i8x16 -1 -1 -1 -1 0 0 0 0 1 1 1 1 2 2 2 2))
                            (v128.const i32x4 -1 0 -1 -1))

;; f32x4.ne  (f32x4) (i16x8)
(assert_return (invoke "ne" (v128.const f32x4 -1 0 1 2.0)
                            (v128.const i16x8 -1 -1 0 0 1 1 2 2))
                            (v128.const i32x4 -1 0 -1 -1))

;; f32x4.ne  (f32x4) (i32x4)
(assert_return (invoke "ne" (v128.const f32x4 -1 0 1 2.0)
                            (v128.const i32x4 3212836864 0 1 2))
                            (v128.const i32x4 0 0 -1 -1))

;; lt

;; f32x4.lt  (f32x4) (i8x16)
(assert_return (invoke "lt" (v128.const f32x4 -1 0 1 2.0)
                            (v128.const i8x16 -1 -1 -1 -1 0 0 0 0 1 1 1 1 2 2 2 2))
                            (v128.const i32x4 0 0 0 0))

;; f32x4.lt  (f32x4) (i16x8)
(assert_return (invoke "lt" (v128.const f32x4 -1 0 1 2.0)
                            (v128.const i16x8 -1 -1 0 0 1 1 2 2))
                            (v128.const i32x4 0 0 0 0))

;; f32x4.lt  (f32x4) (i32x4)
(assert_return (invoke "lt" (v128.const f32x4 -1 0 1 2.0)
                            (v128.const i32x4 3212836864 0 1 2))
                            (v128.const i32x4 0 0 0 0))

;; le

;; f32x4.le  (f32x4) (i8x16)
(assert_return (invoke "le" (v128.const f32x4 -1 0 1 2.0)
                            (v128.const i8x16 -1 -1 -1 -1 0 0 0 0 1 1 1 1 2 2 2 2))
                            (v128.const i32x4 0 -1 0 0))

;; f32x4.le  (f32x4) (i16x8)
(assert_return (invoke "le" (v128.const f32x4 -1 0 1 2.0)
                            (v128.const i16x8 -1 -1 0 0 1 1 2 2))
                            (v128.const i32x4 0 -1 0 0))

;; f32x4.le  (f32x4) (i32x4)
(assert_return (invoke "le" (v128.const f32x4 -1 0 1 2.0)
                            (v128.const i32x4 3212836864 0 1 2))
                            (v128.const i32x4 -1 -1 0 0))

;; gt

;; f32x4.gt  (f32x4) (i8x16)
(assert_return (invoke "gt" (v128.const f32x4 -1 0 1 2.0)
                            (v128.const i8x16 -1 -1 -1 -1 0 0 0 0 1 1 1 1 2 2 2 2))
                            (v128.const i32x4 0 0 -1 -1))

;; f32x4.gt  (f32x4) (i16x8)
(assert_return (invoke "gt" (v128.const f32x4 -1 0 1 2.0)
                            (v128.const i16x8 -1 -1 0 0 1 1 2 2))
                            (v128.const i32x4 0 0 -1 -1))

;; f32x4.gt  (f32x4) (i32x4)
(assert_return (invoke "gt" (v128.const f32x4 -1 0 1 2.0)
                            (v128.const i32x4 3212836864 0 1 2))
                            (v128.const i32x4 0 0 -1 -1))

;; ge

;; f32x4.ge  (f32x4) (i8x16)
(assert_return (invoke "ge" (v128.const f32x4 -1 0 1 2.0)
                            (v128.const i8x16 -1 -1 -1 -1 0 0 0 0 1 1 1 1 2 2 2 2))
                            (v128.const i32x4 0 -1 -1 -1))

;; f32x4.ge  (f32x4) (i16x8)
(assert_return (invoke "ge" (v128.const f32x4 -1 0 1 2.0)
                            (v128.const i16x8 -1 -1 0 0 1 1 2 2))
                            (v128.const i32x4 0 -1 -1 -1))

;; f32x4.ge  (f32x4) (i32x4)
(assert_return (invoke "ge" (v128.const f32x4 -1 0 1 2.0)
                            (v128.const i32x4 3212836864 0 1 2))
                            (v128.const i32x4 -1 -1 -1 -1))


;; Type check

(assert_invalid (module (func (result v128) (f32x4.eq (i64.const 0) (f64.const 0)))) "type mismatch")
(assert_invalid (module (func (result v128) (f32x4.ge (i64.const 0) (f64.const 0)))) "type mismatch")
(assert_invalid (module (func (result v128) (f32x4.gt (i64.const 0) (f64.const 0)))) "type mismatch")
(assert_invalid (module (func (result v128) (f32x4.le (i64.const 0) (f64.const 0)))) "type mismatch")
(assert_invalid (module (func (result v128) (f32x4.lt (i64.const 0) (f64.const 0)))) "type mismatch")
(assert_invalid (module (func (result v128) (f32x4.ne (i64.const 0) (f64.const 0)))) "type mismatch")


;; Unknown operators

(assert_malformed (module quote "(memory 1) (func (param $x v128) (param $y v128) (result v128) (f4x32.eq (local.get $x) (local.get $y)))") "unknown operator")
(assert_malformed (module quote "(memory 1) (func (param $x v128) (param $y v128) (result v128) (f4x32.ge (local.get $x) (local.get $y)))") "unknown operator")
(assert_malformed (module quote "(memory 1) (func (param $x v128) (param $y v128) (result v128) (f4x32.gt (local.get $x) (local.get $y)))") "unknown operator")
(assert_malformed (module quote "(memory 1) (func (param $x v128) (param $y v128) (result v128) (f4x32.le (local.get $x) (local.get $y)))") "unknown operator")
(assert_malformed (module quote "(memory 1) (func (param $x v128) (param $y v128) (result v128) (f4x32.lt (local.get $x) (local.get $y)))") "unknown operator")
(assert_malformed (module quote "(memory 1) (func (param $x v128) (param $y v128) (result v128) (f4x32.ne (local.get $x) (local.get $y)))") "unknown operator")


;; Combination

(module (memory 1)
  (func (export "eq-in-block")
    (block
      (drop
        (block (result v128)
          (f32x4.eq
            (block (result v128) (v128.load (i32.const 0)))
            (block (result v128) (v128.load (i32.const 1)))
          )
        )
      )
    )
  )
  (func (export "ne-in-block")
    (block
      (drop
        (block (result v128)
          (f32x4.ne
            (block (result v128) (v128.load (i32.const 0)))
            (block (result v128) (v128.load (i32.const 1)))
          )
        )
      )
    )
  )
  (func (export "lt-in-block")
    (block
      (drop
        (block (result v128)
          (f32x4.lt
            (block (result v128) (v128.load (i32.const 0)))
            (block (result v128) (v128.load (i32.const 1)))
          )
        )
      )
    )
  )
  (func (export "le-in-block")
    (block
      (drop
        (block (result v128)
          (f32x4.le
            (block (result v128) (v128.load (i32.const 0)))
            (block (result v128) (v128.load (i32.const 1)))
          )
        )
      )
    )
  )
  (func (export "gt-in-block")
    (block
      (drop
        (block (result v128)
          (f32x4.gt
            (block (result v128) (v128.load (i32.const 0)))
            (block (result v128) (v128.load (i32.const 1)))
          )
        )
      )
    )
  )
  (func (export "ge-in-block")
    (block
      (drop
        (block (result v128)
          (f32x4.ge
            (block (result v128) (v128.load (i32.const 0)))
            (block (result v128) (v128.load (i32.const 1)))
          )
        )
      )
    )
  )
  (func (export "nested-eq")
    (drop
      (f32x4.eq
        (f32x4.eq
          (f32x4.eq
            (v128.load (i32.const 0))
            (v128.load (i32.const 1))
          )
          (f32x4.eq
            (v128.load (i32.const 2))
            (v128.load (i32.const 3))
          )
        )
        (f32x4.eq
          (f32x4.eq
            (v128.load (i32.const 0))
            (v128.load (i32.const 1))
          )
          (f32x4.eq
            (v128.load (i32.const 2))
            (v128.load (i32.const 3))
          )
        )
      )
    )
  )
  (func (export "nested-ne")
    (drop
      (f32x4.ne
        (f32x4.ne
          (f32x4.ne
            (v128.load (i32.const 0))
            (v128.load (i32.const 1))
          )
          (f32x4.ne
            (v128.load (i32.const 2))
            (v128.load (i32.const 3))
          )
        )
        (f32x4.ne
          (f32x4.ne
            (v128.load (i32.const 0))
            (v128.load (i32.const 1))
          )
          (f32x4.ne
            (v128.load (i32.const 2))
            (v128.load (i32.const 3))
          )
        )
      )
    )
  )
  (func (export "nested-lt")
    (drop
      (f32x4.lt
        (f32x4.lt
          (f32x4.lt
            (v128.load (i32.const 0))
            (v128.load (i32.const 1))
          )
          (f32x4.lt
            (v128.load (i32.const 2))
            (v128.load (i32.const 3))
          )
        )
        (f32x4.lt
          (f32x4.lt
            (v128.load (i32.const 0))
            (v128.load (i32.const 1))
          )
          (f32x4.lt
            (v128.load (i32.const 2))
            (v128.load (i32.const 3))
          )
        )
      )
    )
  )
  (func (export "nested-le")
    (drop
      (f32x4.le
        (f32x4.le
          (f32x4.le
            (v128.load (i32.const 0))
            (v128.load (i32.const 1))
          )
          (f32x4.le
            (v128.load (i32.const 2))
            (v128.load (i32.const 3))
          )
        )
        (f32x4.le
          (f32x4.le
            (v128.load (i32.const 0))
            (v128.load (i32.const 1))
          )
          (f32x4.le
            (v128.load (i32.const 2))
            (v128.load (i32.const 3))
          )
        )
      )
    )
  )
  (func (export "nested-gt")
    (drop
      (f32x4.gt
        (f32x4.gt
          (f32x4.gt
            (v128.load (i32.const 0))
            (v128.load (i32.const 1))
          )
          (f32x4.gt
            (v128.load (i32.const 2))
            (v128.load (i32.const 3))
          )
        )
        (f32x4.gt
          (f32x4.gt
            (v128.load (i32.const 0))
            (v128.load (i32.const 1))
          )
          (f32x4.gt
            (v128.load (i32.const 2))
            (v128.load (i32.const 3))
          )
        )
      )
    )
  )
  (func (export "nested-ge")
    (drop
      (f32x4.ge
        (f32x4.ge
          (f32x4.ge
            (v128.load (i32.const 0))
            (v128.load (i32.const 1))
          )
          (f32x4.ge
            (v128.load (i32.const 2))
            (v128.load (i32.const 3))
          )
        )
        (f32x4.ge
          (f32x4.ge
            (v128.load (i32.const 0))
            (v128.load (i32.const 1))
          )
          (f32x4.ge
            (v128.load (i32.const 2))
            (v128.load (i32.const 3))
          )
        )
      )
    )
  )
  (func (export "as-param")
    (drop
      (f32x4.ge
        (f32x4.eq
          (f32x4.lt
            (v128.load (i32.const 0))
            (v128.load (i32.const 1))
          )
          (f32x4.le
            (v128.load (i32.const 2))
            (v128.load (i32.const 3))
          )
        )
        (f32x4.ne
          (f32x4.gt
            (v128.load (i32.const 0))
            (v128.load (i32.const 1))
          )
          (f32x4.lt
            (v128.load (i32.const 2))
            (v128.load (i32.const 3))
          )
        )
      )
    )
  )
)

(assert_return (invoke "eq-in-block"))
(assert_return (invoke "ne-in-block"))
(assert_return (invoke "lt-in-block"))
(assert_return (invoke "le-in-block"))
(assert_return (invoke "gt-in-block"))
(assert_return (invoke "ge-in-block"))
(assert_return (invoke "nested-eq"))
(assert_return (invoke "nested-ne"))
(assert_return (invoke "nested-lt"))
(assert_return (invoke "nested-le"))
(assert_return (invoke "nested-gt"))
(assert_return (invoke "nested-ge"))
(assert_return (invoke "as-param"))

;; Test operation with empty argument

(assert_invalid
  (module
    (func $f32x4.eq-1st-arg-empty (result v128)
      (f32x4.eq (v128.const f32x4 0 0 0 0))
    )
  )
  "type mismatch"
)
(assert_invalid
  (module
    (func $f32x4.eq-arg-empty (result v128)
      (f32x4.eq)
    )
  )
  "type mismatch"
)
(assert_invalid
  (module
    (func $f32x4.ne-1st-arg-empty (result v128)
      (f32x4.ne (v128.const f32x4 0 0 0 0))
    )
  )
  "type mismatch"
)
(assert_invalid
  (module
    (func $f32x4.ne-arg-empty (result v128)
      (f32x4.ne)
    )
  )
  "type mismatch"
)
(assert_invalid
  (module
    (func $f32x4.lt-1st-arg-empty (result v128)
      (f32x4.lt (v128.const f32x4 0 0 0 0))
    )
  )
  "type mismatch"
)
(assert_invalid
  (module
    (func $f32x4.lt-arg-empty (result v128)
      (f32x4.lt)
    )
  )
  "type mismatch"
)
(assert_invalid
  (module
    (func $f32x4.le-1st-arg-empty (result v128)
      (f32x4.le (v128.const f32x4 0 0 0 0))
    )
  )
  "type mismatch"
)
(assert_invalid
  (module
    (func $f32x4.le-arg-empty (result v128)
      (f32x4.le)
    )
  )
  "type mismatch"
)
(assert_invalid
  (module
    (func $f32x4.gt-1st-arg-empty (result v128)
      (f32x4.gt (v128.const f32x4 0 0 0 0))
    )
  )
  "type mismatch"
)
(assert_invalid
  (module
    (func $f32x4.gt-arg-empty (result v128)
      (f32x4.gt)
    )
  )
  "type mismatch"
)
(assert_invalid
  (module
    (func $f32x4.ge-1st-arg-empty (result v128)
      (f32x4.ge (v128.const f32x4 0 0 0 0))
    )
  )
  "type mismatch"
)
(assert_invalid
  (module
    (func $f32x4.ge-arg-empty (result v128)
      (f32x4.ge)
    )
  )
  "type mismatch"
)