use super::*;
use indoc::indoc;

#[test]
fn parse_ldd_output() {
    let ver_str = glibc_ldd_output_to_version(
        "stdout",
        indoc! {br"ld.so (Ubuntu GLIBC 2.39-0ubuntu8.3) stable release version 2.39.
            Copyright (C) 2024 Free Software Foundation, Inc.
            This is free software; see the source for copying conditions.
            There is NO warranty; not even for MERCHANTABILITY or FITNESS FOR A
            PARTICULAR PURPOSE.
        "},
    )
    .unwrap();
    assert_eq!(
        ver_str,
        LibcVersion::Manylinux {
            major: 2,
            minor: 39
        }
    );
}

#[test]
fn parse_musl_ld_output() {
    // This output was generated by running `/lib/ld-musl-x86_64.so.1`
    // in an Alpine Docker image. The Alpine version:
    //
    // # cat /etc/alpine-release
    // 3.19.1
    let output = b"\
musl libc (x86_64)
Version 1.2.4_git20230717
Dynamic Program Loader
Usage: /lib/ld-musl-x86_64.so.1 [options] [--] pathname [args]\
    ";
    let got = musl_ld_output_to_version("stderr", output).unwrap();
    assert_eq!(got, LibcVersion::Musllinux { major: 1, minor: 2 });
}
