use clap::{crate_authors, crate_description, crate_version, App, AppSettings, Arg, ArgMatches};

pub fn launch() -> ArgMatches {
    App::new("t-rec")
        .version(crate_version!())
        .author(crate_authors!())
        .about(crate_description!())
        .setting(AppSettings::AllowMissingPositional)
        .arg(
            Arg::new("verbose")
                .takes_value(false)
                .short('v')
                .long("verbose")
                .required(false)
                .help("Enable verbose insights for the curious")
        )
        .arg(Arg::new("quiet")
                .takes_value(false)
                .short('q')
                .long("quiet")
                .required(false)
                .help("Quiet mode, suppresses the banner: 'Press Ctrl+D to end recording'")
        )
        .arg(
            Arg::new("video")
                .takes_value(false)
                .short('m')
                .long("video")
                .required(false)
                .help("Generates additionally to the gif a mp4 video of the recording")
        )
        .arg(
            Arg::new("video-only")
                .takes_value(false)
                .short('M')
                .long("video-only")
                .required(false)
                .conflicts_with("video")
                .help("Generates only a mp4 video and not gif")
        )
        .arg(
            Arg::new("decor")
                .takes_value(true)
                .possible_values(&["shadow", "none"])
                .default_value("none")
                .required(false)
                .short('d')
                .long("decor")
                .help("Decorates the animation with certain, mostly border effects")
        )
        .arg(
            Arg::new("bg")
                .takes_value(true)
                .possible_values(&["white", "black", "transparent"])
                .default_value("transparent")
                .required(false)
                .short('b')
                .long("bg")
                .help("Background color when decors are used")
        )
        .arg(
            Arg::new("natural-mode")
                .value_name("natural")
                .takes_value(false)
                .required(false)
                .short('n')
                .long("natural")
                .help("If you want a very natural typing experience and disable the idle detection and sampling optimization")
        )
        .arg(
            Arg::new("list-windows")
                .value_name("list all visible windows with name and id")
                .takes_value(false)
                .required(false)
                .short('l')
                .long("ls-win")
                .help("If you want to see a list of windows available for recording by their id, you can set env var 'WINDOWID' or `--win-id` to record this specific window only"),
        )
        .arg(
            Arg::new("win-id")
                .takes_value(true)
                .short('w')
                .long("win-id")
                .required(false)
                .help("Window Id (see --ls-win) that should be captured, instead of the current terminal")
        )
        .arg(
            Arg::new("end-pause")
                .value_name("s | ms | m")
                .takes_value(true)
                .required(false)
                .short('e')
                .long("end-pause")
                .help("to specify the pause time at the end of the animation, that time the gif will show the last frame"),
        )
        .arg(
            Arg::new("start-pause")
                .value_name("s | ms | m")
                .takes_value(true)
                .required(false)
                .short('s')
                .long("start-pause")
                .help("to specify the pause time at the start of the animation, that time the gif will show the first frame"),
        )
        .arg(
            Arg::new("file")
                .takes_value(true)
                .required(false)
                .short('o')
                .long("output")
                .default_value("t-rec")
                .help("to specify the output file (without extension)"),
        )
        .arg(
            Arg::new("program")
                .value_name("shell or program to launch")
                .takes_value(true)
                .required(false)
                .help("If you want to start a different program than $SHELL you can pass it here. For example '/bin/sh'"),
        ).get_matches()
}
