# Préréglages

Voici un ensemble de préréglages pour Starship soumis par la communauté. Si vous avez un préréglage à partager, veuillez [proposer une PR](https://github.com/starship/starship/edit/master/docs/presets/README.md) pour mettre à jour ce fichier! 😊

Pour obtenir des détails sur comment utiliser un préréglage, cliquez simplement sur l’image.

## [Symboles Nerd Font](./nerd-font.md)

Ce préréglage change les symboles de chaque module pour utiliser les symboles de Nerd Font.

[![Capture d'écran du préréglage Nerd Font Symbols](/presets/img/nerd-font-symbols.png "Cliquez pour voir le préréglage Nerd Font Symbols")](./nerd-font)

## [Segments entre crochets](./bracketed-segments.md)

Ce préréglage modifie le format de tous les modules intégrés pour afficher leur segment entre crochets au lieu d'utiliser les labels par défaut de Starship ("via", "on", etc.).

[![Capture d'écran du préréglages Segments entre crochets](/presets/img/bracketed-segments.png "Cliquez pour voir le préréglage Segments entre crochets")](./bracketed-segments)

## [Texte uniquement](./plain-text.md)

Ce préréglage change les symboles de chaque module en texte brut. Idéal si vous n'avez pas accès à Unicode.

[![Capture d'écran du préréglage Texte uniquement](/presets/img/plain-text-symbols.png "Cliquez pour voir le préréglage Texte uniquement")](./plain-text)

## [Pas de version des environnements](./no-runtimes.md)

Ce préréglage masque la version des environnements. Si vous travaillez dans des conteneurs ou environnements virtuels, celui-là est pour vous!

[![Capture d'écran du préréglage Pas de version des environnements](/presets/img/no-runtime-versions.png "Cliquez pour voir le préréglage Pas de version des environnements")](./no-runtimes)

## [Invite de commande Pure](./pure-preset.md)

Ce préréglage émule l'apparence et le comportement de [Pure](https://github.com/sindresorhus/pure).

[![Capture d'écran du préréglage Pure](/presets/img/pure-preset.png "Cliquez pour voir le préréglage Pure")](./pure-preset)

## [Pastel Powerline](./pastel-powerline.md)

Ce préréglage s'inspire de [M365Princess](https://github.com/JanDeDobbeleer/oh-my-posh/blob/main/themes/M365Princess.omp.json). Il montre également comment fonctionne la substitution de chemin dans starship.

[![Capture d'écran du préréglage Pastel Powerline](/presets/img/pastel-powerline.png "Cliquez pour voir le préréglage Pure")](./pastel-powerline)
