# Personalizações

Aqui tem uma coleção de personalizações desenvolvidas pela comunidade para usar com Starship. Se você tem uma personalização para compartilhar, por favor, [envie uma PR](https://github.com/starship/starship/edit/master/docs/presets/README.md) atualizando este arquivo! 😊

Para mais detalhes sobre como usar uma personalização, clique na imagem.

## [Símbolos Nerd Font](./nerd-font.md)

Essa predefinição altera os símbolos para cada módulo usar símbolos com Nerd Font.

[![Captura de tela da personalização com símbolos usando Nerd Font](/presets/img/nerd-font-symbols.png "Clique para ver as personalizações para Nerd Font")](./nerd-font)

## [Sem Nerd Fonts](./no-nerd-font.md)

Essa predefinição altera os símbolos para vários módulos para que nenhum utilize símbolos das Nerd Fonts em nenhum lugar no prompt.

::: tip

Esta predefinição se tornará padrão em [uma futura release do starship](https://github.com/starship/starship/pull/3544).

:::

[Clique para visualizar a predefinição de sem Nerd Font](./no-nerd-font)

## [Seguimentos entre colchetes](./bracketed-segments.md)

Está personalização altera o formato de todos os módulos integrados para que usem colchetes ao mostrar o seguimento ao invés de usar texto convencional do Starship ("via", "on", etc.).

[![Captura de tela de segmentos predefinidos](/presets/img/bracketed-segments.png "Clique para ver as personalizações de seguimentos entre colchetes")](./bracketed-segments)

## [Símbolos de texto simples](./plain-text.md)

Essa personalização converte os símbolos para cada módulo em texto simples. Importante para quando não tiver suporte para caracteres Unicode.

[![Captura de tela de personalização de símbolos de texto simples](/presets/img/plain-text-symbols.png "Clique para ver as personalizações para símbolos de texto simples")](./plain-text)

## [Runtime Ausente](./no-runtimes.md)

Esta predefinição oculta a versão do runtime da linguagem. Se você trabalha com containers ou ambientes virtualizados, esta aqui é para você!

[![Captura de tela de uma personalização ocultando a versão do runtime](/presets/img/no-runtime-versions.png "Clique para ver as personalizações para remover a versão do runtime")](./no-runtimes)

## [Sem Ícones Vazios](./no-empty-icons.md)

Este preset não mostra ícones se as ferramentas não forem encontradas.

[![Captura de tela de preset de nenhum ícone vazio](/presets/img/no-empty-icons.png "Clique para ver as personalizações para remover a versão do runtime")](./no-empty-icons.md)

## [Prompt do Terminal com Pure](./pure-preset.md)

Essa personalização simula a aparência e o comportamento do [Pure](https://github.com/sindresorhus/pure).

[![Captura de tela da personalização do prompt do terminal usando Pure](/presets/img/pure-preset.png "Clique para ver as personalização para usar no prompt do terminal com Pure")](./pure-preset)

## [Pastel Powerline](./pastel-powerline.md)

Esta personalização é inspirada em [M365Princess](https://github.com/JanDeDobbeleer/oh-my-posh/blob/main/themes/M365Princess.omp.json). Mostra também como a substituição de segmentos do caminho completo do diretório funciona no starship.

[![Capture de tela das personalizações com Pastel Powerline](/presets/img/pastel-powerline.png "Clique para ver as personalização para usar no prompt do terminal com Pure")](./pastel-powerline)

## [Tokyo Night](./tokyo-night.md)

Este preset é inspirado por  [tokyo-night-vscode-theme](https://github.com/enkia/tokyo-night-vscode-theme).

[![Captura de tela de Tokyo Night preset](/presets/img/tokyo-night.png "Clique para visualizar Tokyo Night preset")](./tokyo-night)

## [Gruvbox Rainbow](./gruvbox-rainbow.md)

This preset is heavily inspired by [Pastel Powerline](./pastel-powerline.md), and [Tokyo Night](./tokyo-night.md).

[![Screenshot of Gruvbox Rainbow preset](/presets/img/gruvbox-rainbow.png "Click to view Gruvbox Rainbow preset")](./gruvbox-rainbow)
