# 🚀 Advanced Installation

To install starship, you need to do two things:

1. Get the **starship** binary onto your computer
1. Tell your shell to use the starship binary as its prompt by modifying its init scripts

For most users, the instructions on [the main page](/guide/#🚀-installation) will work great. However,
for some more specialized platforms, different instructions are needed.

There are so many platforms out there that they didn't fit into the main
README.md file, so here are some installation instructions for other platforms
from the community. Is yours not here? Please do add it here if you figure it
out!

## [Chocolatey](https://chocolatey.org)

### Prerequisites

Head over to the [Chocolatey installation page](https://chocolatey.org/install) and follow the instructions to install Chocolatey. 

### Installation

```powershell
choco install starship
```

## [termux](https://termux.com)

### Prerequisites

```sh
pkg install getconf
```

### Installation

```sh
curl -fsSL https://starship.rs/install.sh | bash -s -- -b /data/data/com.termux/files/usr/bin
```

## [Nix](https://nixos.wiki/wiki/Nix)

### Getting the Binary

#### Imperatively

```sh
nix-env -iA nixos.starship
```

#### Declarative, single user, via [home-manager](home-manager)

Enable the `programs.starship` module in your `home.nix` file, and add your settings

```nix
{
  programs.starship = {
    enable = true;
    enableZshIntegration = true;
    # Configuration written to ~/.config/starship.toml
    settings = {
      # add_newline = false;

      # character = {
      #   success_symbol = "[➜](bold green)";
      #   error_symbol = "[➜](bold red)";
      # };

      # package.disabled = true;
    };
  };
}
```

then run

```sh
home-manager switch
```

#### Declarative, system-wide, with NixOS

Add `pkgs.starship` to `environment.systemPackages` in your `configuration.nix`,
then run

```sh
sudo nixos-rebuild switch
```
