# rust-analyzer

This extension provides support for the [Rust programming language](https://www.rust-lang.org/).

## Features

- [code completion] with [imports insertion]
- go to [definition], [implementation], [type definition]
- [find all references], [workspace symbol search], [symbol renaming]
- [types and documentation on hover]
- [inlay hints] for types and parameter names
- [semantic syntax highlighting]
- a lot of [assists(code actions)]
- apply suggestions from errors
- ... and many more, checkout the [manual] to see them all

[code completion]: https://rust-analyzer.github.io/manual.html#magic-completions
[imports insertion]: https://rust-analyzer.github.io/manual.html#completion-with-autoimport
[definition]: https://rust-analyzer.github.io/manual.html#go-to-definition
[implementation]: https://rust-analyzer.github.io/manual.html#go-to-implementation
[type definition]: https://rust-analyzer.github.io/manual.html#go-to-type-definition
[find all references]: https://rust-analyzer.github.io/manual.html#find-all-references
[workspace symbol search]: https://rust-analyzer.github.io/manual.html#workspace-symbol
[symbol renaming]: https://rust-analyzer.github.io/manual.html#rename
[types and documentation on hover]: https://rust-analyzer.github.io/manual.html#hover
[inlay hints]: https://rust-analyzer.github.io/manual.html#inlay-hints
[semantic syntax highlighting]: https://rust-analyzer.github.io/manual.html#semantic-syntax-highlighting
[assists(code actions)]: https://rust-analyzer.github.io/manual.html#assists-code-actions
[manual]: https://rust-analyzer.github.io/manual.html

## Quick start

1. Install [rustup]
2. Install the [rust-analyzer extension]

[rustup]: https://rustup.rs
[rust-analyzer extension]: https://marketplace.visualstudio.com/items?itemName=matklad.rust-analyzer

## Configuration

This extension provides configurations through VSCode's configuration settings. All the configurations are under `rust-analyzer.*`.

See <https://rust-analyzer.github.io/manual.html#vs-code-2> for more information on VSCode specific configurations.

## Communication

For usage and troubleshooting requests, please use "IDEs and Editors" category of the Rust forum:

<https://users.rust-lang.org/c/ide/14>

## Documentation

See <https://rust-analyzer.github.io/> for more information.
