---
layout: post
title: 'Settings UI, Welcome UI, Adaptive theme, crates.io and more'
date: 2023-09-19 13:53
description: 'Crates.io, Alpine Linux, openSUSE, Nix home manager, adaptive theme, settings UI, welcome UI, blinking cursor, plain navigation mode ...'
categories: windows macos linux webassembly
---

This post also includes changes of v0.0.19.

### Highlight #1: New window API (breaking change)

Configuration properties: window_height, window_width and window_opacity has been moved to a new window/background API:

```toml
# Window configuration
#
# • width - define the intial window width.
#   Default: 600
#
# • height - define the inital window height.
#   Default: 400
#
# • mode - define how the window will be created
#     - "Windowed" (default) is based on width and height
#     - "Maximized" window is created with maximized
#     - "Fullscreen" window is created with fullscreen
#
[window]
width = 600
height = 400
mode = "Windowed"
```

From now and on you can also set image as background.

```toml
# Background configuration
#
# • opacity - changes the background transparency state
#   Default: 1.0
#
# • mode - defines background mode bewteen "Color" and "Image"
#   Default: Color
#
# • image - Set an image as background
#   Default: None
#
[background]
mode = "Image"
opacity = 1.0
[background.image]
path = "/Users/rapha/Desktop/eastward.jpg"
width = 200.0
height = 200.0
x = 0.0
```

Although you can define opacity though the new configuration API it does not work either for the image neither for the window. This something will be fixed in upcoming releases. An example below using the configuration we just saw.

![Example background](https://media.discordapp.net/attachments/1110689410258841662/1152881776348364811/F6JGpamXsAAWvcG.png?width=1048&height=848)

note: The image above is from the [Eastward game](<https://en.wikipedia.org/wiki/Eastward_(video_game)>)

## Highlight #2: crates.io

Rio terminal is now also available in crates.io: https://crates.io/crates/rioterm .

```sh
cargo install rioterm
```

## Highlight #3: Alpine Linux, openSUSE and Nix home manager.

• Rio has landed in Nix home manager: [nix-community/home-manager/pull/4118](https://github.com/nix-community/home-manager/pull/4118) and huge props to [@otaviosalvador](https://twitter.com/otaviosalvador) for making it possible.

• Rio has landed in Alpine Linux: [gitlab.alpinelinux.org](https://gitlab.alpinelinux.org/alpine/aports/-/merge_requests/51369) and huge props to [@androw](https://github.com/androw) for making it possible.

• Rio has landed in openSUSE: [build.opensuse.org](https://build.opensuse.org/package/show/X11:terminals/rioterm) and huge props to [@androw](https://github.com/androw) for making it possible.

## Highlight #4: Welcome screen and default creation of configuration file

Now Rio terminal does create the configuration file per first initialization.

![Welcome message](https://user-images.githubusercontent.com/240594/268500927-788ea316-ede8-4d23-ba1f-9621a6a82908.png)

## Highlight #5: Settings UI

After v0.0.19, Rio will start to provide a custom internal settings UI, where you can manage your configuration without edit the file.

![Settings UI](/assets/posts/0.0.19/demo-settings.png)

Note: Not all the configuration options has been ported, so you would still need to use the config file for specific configuration updates.

## Highlight #6: Error handling

Configuration errors, command errors, font not found and etecetera are not silent anymore. This version introduces an UI for error handling.

![Error handling](/assets/posts/0.0.19/demo-error-handling.png)

## Highlight #7: Adaptive theme

Rio support theme based on the system theme (light and dark). This configuration only works for Web, MacOS and Windows.

```toml
[adaptive-theme]
light = "belafonte-day"
dark = "belafonte-night"
```

Example of usage with MacOS:

![Settings UI](/assets/features/adaptive-theme.gif)

## Highlight #8: Blinking cursor

Rio now supports blinking cursor.

```toml
# Blinking Cursor
#
# Default is false
#
blinking-cursor = true
```

## Highlight #9: Navigation mode called "Plain"

Navigation mode "Plain" is perfect if you use tmux/zellij or anything similar.

Plain navigation mode will simply turn off any platform key binding, will not add any key binding (like creation of tabs, windows, panels and other platform key bindings). Note it also get rid of platform key bingins such as shift+control+c for example, to re-add it you would need to map yourself.

This mode is great if you want configure every single bit of how Rio key bindings will work.

Usage:

```toml
[navigation]
mode = "Plain"
```

## Full changelog of v0.0.19

- Fix for retrieving shell environment variable when running inside of Flatpak sandbox (Ref: https://github.com/raphamorim/rio/issues/198).
- Rio terminal is now also available in crates.io: https://crates.io/crates/rioterm .
- Added "navigation.mode = "Plain"", it basically disables all platform key bindings for tabs, windows and panels creation (Ref https://github.com/raphamorim/rio/issues/213).
- Support for blinking cursor (Ref: https://github.com/raphamorim/rio/issues/137) (this option is not enabled by default).
- Migrated font-kit to a custom font loader.
- Support to MacOS tile window positioning feature (left or right).
- Added support to MacOS display native top bar items.
- Support to adaptive theme (theme selection based on user system theme variant "dark" or "light").
- Implemented "ScrollPageUp", "ScrollPageDown", "ScrollHalfPageUp", "ScrollHalfPageDown", "ScrollToTop", "ScrollToBottom", "ScrollLineUp", "ScrollLineDown" (Ref: https://github.com/raphamorim/rio/issues/206).
- Support to "fonts.family" (it overwrittes regular, bold, bold-italic and italic font families).
- Added a welcome screen UI.
- Added a settings UI.
- Exposes "RIO_CONFIG" environment variable that contains the path of the configuration.
- Rio creates a configuration file with all defaults if does not exist.
- Added "OpenConfigEditor" key binding for all platforms.
- Configuration property "editor" was removed.
- Created Assistant, Rio terminal UI for display error (Ref: https://github.com/raphamorim/rio/issues/168).
- Fix 'Backspace' keypress triggers Ctrl+h keybinding in Zellij instead of deleting character. (Ref: https://github.com/raphamorim/rio/issues/197).
- Implemented "TERM_PROGRAM" and "TERM_PROGRAM_VERSION" (Ref: https://github.com/raphamorim/rio/issues/200).
- Whenever native tabs is on disable macos deadzone logic.
