---
layout: post
title: 'Rio 0.0.9'
date: 2023-07-17 12:34
description: 'Multi window support, FreeBSD support, possibility of choose between Spawn and Fork, inverse instruction, multi byte rendering fixes, support to older MacOS versions, select shell and working-dir in configuration file.'
categories: release windows macos linux
---

# v0.0.9: Highlights

- Multi window support.
- Support to older MacOS versions (older or equal to Big Sur).
- Possibility of choose between Spawn and Fork.
- Inverse instruction.
- Introduced "rio" terminfo.
- Multi byte rendering fixes.
- Select shell and working-dir in configuration file.
- FreeBSD support and [added to FreeBSD ports](https://github.com/freebsd/freebsd-ports/commit/8582b8c59459a7dc5112a94a39de45f6cc124c3e).

<br/>

# Overview

Rio release 0.0.9 is finally here, there's a lot of updates to cover so let's get started. I also would like to remind you that Rio is still unstable. This release adds a lot of bug fixes and feature additions in order to make Rio terminal stable.

## Multi window support

Rio terminal has added the support to multi window feature.

<img src="https://miro.medium.com/v2/resize:fit:2914/format:webp/1*KyVD4EJ-wQU8pTmOFTwaQg.png" width="100%" />

Shortcuts:

- MacOS: Command + N
- Windows: Alt + N
- Linux: Control + N

## Support to older MacOS versions (older or equal to Big Sur).

Now it is available for versions below Ventura (Rome).

## Choose between fork or spawn

Decide which one to use in the configuration file by the usage of propery "use-fork":

```toml
use-fork = false
```

Defaults for POSIX-based systems:

- MacOS: spawn processes
- Linux/BSD: fork processes

## Inverse instructions

Before the v0.0.9, programs were not correctly rendered in the terminal due to the lack of inverse instruction in Rio.

For example, ranger uses inverse to show the active path.

Before:

![Rio before 0.0.9](https://user-images.githubusercontent.com/3630346/245280487-12af56a1-d9ad-4310-bd4e-3d96d42e8a42.png)

Now:

![Rio now](https://user-images.githubusercontent.com/3630346/251224085-39531c88-8e04-48ad-b09a-8fd12a0e011b.png)

## Introduced "rio" terminfo

Terminfo (formerly Termcap) is a database of terminal capabilities and more. For every (well almost) model of terminal it tells application programs what the terminal is capable of doing.

It tells what escape sequences (or control characters) to send to the terminal in order to do things such as move the cursor to a new location, erase part of the screen, scroll the screen, change modes, change appearance (colors, brightness, blinking, underlining, reverse video etc.).

After about 1980, many terminals supported over a hundred different commands (some of which take numeric parameters).

Rio terminal has now it's own terminfo:

```sh
$ echo $TERM
rio
```

More info [here](/docs/install#terminfo).

## Fixes for multi-byte rendering

Before the v0.0.9, multi-byte characters were not correctly rendered in the terminal.

Before: As reported in the issue [#127](https://github.com/raphamorim/rio/issues/127)

Now:

![Now](https://user-images.githubusercontent.com/3630346/252940293-da345089-3d4c-4d05-8b0f-d0665f1e1347.png)

## Configuration file addition: shell

Now you can set "shell.program" to the path of your favorite shell, e.g. "/bin/fish".

Entries in "shell.args" are passed unmodified as arguments to the shell.

```toml
shell = { program = "/bin/zsh", args = ["--login"] }
```

Defaults:

- MacOS: /bin/zsh --login
- Linux/BSD: user login shell
- Windows: powershell

## Configuration file addition: working_dir

Directory the shell is started in. If this is unset the working
directory of the parent process will be used.

This configuration only has effect if use-fork is disabled

```toml
working_dir = "/Users/raphael/Documents/"
```

## Configuration file removal: Advanced

Breaking changes for configuration file regarding "Advanced". The configuration "Advanced" has moved to root level and "disable-render-when-unfocused" renamed to "disable-unfocused-render".

```toml
theme = "dracula"

[advanced]
disable-render-when-unfocused = true
```

**now**

```toml
theme = "dracula"
disable-unfocused-render = true
```

## Changelog of v0.0.9

- The configuration "Advanced" has moved to root level and "disable-render-when-unfocused" renamed to "disable-unfocused-render".
- Support to **spawn and fork processes**, spawn has became default. Spawn increases Rio compability in a broad range, like old MacOS versions (older or equal to Big Sur). However, If you want to use Rio terminal to fork processes instead of spawning processes, enable "use-fork" in the configuration file.
- Introduced "RIO_LOG_LEVEL" variable usage.
- Increased max tabs from 6 to 9.
- Fix Incorrect cursor position when using multi-byte characters (Ref: [#127](https://github.com/raphamorim/rio/issues/127))
- Fix bug ["black screen with nearly zero interactivity"](https://github.com/raphamorim/rio/issues/112) and new tab hanging.
- Fix cursor disappearing after resize.
- Introduction of "shell" and "working_dir" in configuration file.
- Multi window support [#97](https://github.com/raphamorim/rio/issues/97).
- Corrections on select and scroll experience (it was using wrongly font-bound for line calculation).
- Add selection color to the theme config (closed [#125](https://github.com/raphamorim/rio/issues/125)).
- Implemented Inverse (fix [#92](https://github.com/raphamorim/rio/issues/92)).
- Proper choose formats that matches Rio requirements (related [#122](https://github.com/raphamorim/rio/issues/122)).
- Corcovado: Filter windows crate dependency to only Windows targets (related: [#119](https://github.com/raphamorim/rio/issues/119)).
- Teletypewriter: Fixes for musl as target_env (related: [#119](https://github.com/raphamorim/rio/issues/119)).
- FreeBSD support, implementation by [yurivict](https://github.com/yurivict) ([Commit](https://github.com/freebsd/freebsd-ports/commit/8582b8c59459a7dc5112a94a39de45f6cc124c3e), Ref: [#115](https://github.com/raphamorim/rio/issues/115))
