// Copyright (c) 2018-2019, The rav1e contributors. All rights reserved
//
// This source code is subject to the terms of the BSD 2 Clause License and
// the Alliance for Open Media Patent License 1.0. If the BSD 2 Clause License
// was not distributed with this source code in the LICENSE file, you can
// obtain it at www.aomedia.org/license/software. If the Alliance for Open
// Media Patent License 1.0 was not distributed with this source code in the
// PATENTS file, you can obtain it at www.aomedia.org/license/patent.

#![allow(non_upper_case_globals)]

use crate::context::*;
use crate::transform::*;

const TOKEN_CDF_Q_CTXS: usize = 4;

pub static av1_default_dc_sign_cdfs: [[[[u16; cdf_size!(2)];
  DC_SIGN_CONTEXTS]; PLANE_TYPES];
  TOKEN_CDF_Q_CTXS] = [
  [
    [cdf!(128 * 125), cdf!(128 * 102), cdf!(128 * 147)],
    [cdf!(128 * 119), cdf!(128 * 101), cdf!(128 * 135)],
  ],
  [
    [cdf!(128 * 125), cdf!(128 * 102), cdf!(128 * 147)],
    [cdf!(128 * 119), cdf!(128 * 101), cdf!(128 * 135)],
  ],
  [
    [cdf!(128 * 125), cdf!(128 * 102), cdf!(128 * 147)],
    [cdf!(128 * 119), cdf!(128 * 101), cdf!(128 * 135)],
  ],
  [
    [cdf!(128 * 125), cdf!(128 * 102), cdf!(128 * 147)],
    [cdf!(128 * 119), cdf!(128 * 101), cdf!(128 * 135)],
  ],
];

pub static av1_default_txb_skip_cdfs: [[[[u16; cdf_size!(2)];
  TXB_SKIP_CONTEXTS];
  TxSize::TX_SIZES]; TOKEN_CDF_Q_CTXS] = [
  [
    [
      cdf!(31849),
      cdf!(5892),
      cdf!(12112),
      cdf!(21935),
      cdf!(20289),
      cdf!(27473),
      cdf!(32487),
      cdf!(7654),
      cdf!(19473),
      cdf!(29984),
      cdf!(9961),
      cdf!(30242),
      cdf!(32117),
    ],
    [
      cdf!(31548),
      cdf!(1549),
      cdf!(10130),
      cdf!(16656),
      cdf!(18591),
      cdf!(26308),
      cdf!(32537),
      cdf!(5403),
      cdf!(18096),
      cdf!(30003),
      cdf!(16384),
      cdf!(16384),
      cdf!(16384),
    ],
    [
      cdf!(29957),
      cdf!(5391),
      cdf!(18039),
      cdf!(23566),
      cdf!(22431),
      cdf!(25822),
      cdf!(32197),
      cdf!(3778),
      cdf!(15336),
      cdf!(28981),
      cdf!(16384),
      cdf!(16384),
      cdf!(16384),
    ],
    [
      cdf!(17920),
      cdf!(1818),
      cdf!(7282),
      cdf!(25273),
      cdf!(10923),
      cdf!(31554),
      cdf!(32624),
      cdf!(1366),
      cdf!(15628),
      cdf!(30462),
      cdf!(146),
      cdf!(5132),
      cdf!(31657),
    ],
    [
      cdf!(6308),
      cdf!(117),
      cdf!(1638),
      cdf!(2161),
      cdf!(16384),
      cdf!(10923),
      cdf!(30247),
      cdf!(16384),
      cdf!(16384),
      cdf!(16384),
      cdf!(16384),
      cdf!(16384),
      cdf!(16384),
    ],
  ],
  [
    [
      cdf!(30371),
      cdf!(7570),
      cdf!(13155),
      cdf!(20751),
      cdf!(20969),
      cdf!(27067),
      cdf!(32013),
      cdf!(5495),
      cdf!(17942),
      cdf!(28280),
      cdf!(16384),
      cdf!(16384),
      cdf!(16384),
    ],
    [
      cdf!(31782),
      cdf!(1836),
      cdf!(10689),
      cdf!(17604),
      cdf!(21622),
      cdf!(27518),
      cdf!(32399),
      cdf!(4419),
      cdf!(16294),
      cdf!(28345),
      cdf!(16384),
      cdf!(16384),
      cdf!(16384),
    ],
    [
      cdf!(31901),
      cdf!(10311),
      cdf!(18047),
      cdf!(24806),
      cdf!(23288),
      cdf!(27914),
      cdf!(32296),
      cdf!(4215),
      cdf!(15756),
      cdf!(28341),
      cdf!(16384),
      cdf!(16384),
      cdf!(16384),
    ],
    [
      cdf!(26726),
      cdf!(1045),
      cdf!(11703),
      cdf!(20590),
      cdf!(18554),
      cdf!(25970),
      cdf!(31938),
      cdf!(5583),
      cdf!(21313),
      cdf!(29390),
      cdf!(641),
      cdf!(22265),
      cdf!(31452),
    ],
    [
      cdf!(26584),
      cdf!(188),
      cdf!(8847),
      cdf!(24519),
      cdf!(22938),
      cdf!(30583),
      cdf!(32608),
      cdf!(16384),
      cdf!(16384),
      cdf!(16384),
      cdf!(16384),
      cdf!(16384),
      cdf!(16384),
    ],
  ],
  [
    [
      cdf!(29614),
      cdf!(9068),
      cdf!(12924),
      cdf!(19538),
      cdf!(17737),
      cdf!(24619),
      cdf!(30642),
      cdf!(4119),
      cdf!(16026),
      cdf!(25657),
      cdf!(16384),
      cdf!(16384),
      cdf!(16384),
    ],
    [
      cdf!(31957),
      cdf!(3230),
      cdf!(11153),
      cdf!(18123),
      cdf!(20143),
      cdf!(26536),
      cdf!(31986),
      cdf!(3050),
      cdf!(14603),
      cdf!(25155),
      cdf!(16384),
      cdf!(16384),
      cdf!(16384),
    ],
    [
      cdf!(32363),
      cdf!(10692),
      cdf!(19090),
      cdf!(24357),
      cdf!(24442),
      cdf!(28312),
      cdf!(32169),
      cdf!(3648),
      cdf!(15690),
      cdf!(26815),
      cdf!(16384),
      cdf!(16384),
      cdf!(16384),
    ],
    [
      cdf!(30669),
      cdf!(3832),
      cdf!(11663),
      cdf!(18889),
      cdf!(19782),
      cdf!(23313),
      cdf!(31330),
      cdf!(5124),
      cdf!(18719),
      cdf!(28468),
      cdf!(3082),
      cdf!(20982),
      cdf!(29443),
    ],
    [
      cdf!(28573),
      cdf!(3183),
      cdf!(17802),
      cdf!(25977),
      cdf!(26677),
      cdf!(27832),
      cdf!(32387),
      cdf!(16384),
      cdf!(16384),
      cdf!(16384),
      cdf!(16384),
      cdf!(16384),
      cdf!(16384),
    ],
  ],
  [
    [
      cdf!(26887),
      cdf!(6729),
      cdf!(10361),
      cdf!(17442),
      cdf!(15045),
      cdf!(22478),
      cdf!(29072),
      cdf!(2713),
      cdf!(11861),
      cdf!(20773),
      cdf!(16384),
      cdf!(16384),
      cdf!(16384),
    ],
    [
      cdf!(31903),
      cdf!(2044),
      cdf!(7528),
      cdf!(14618),
      cdf!(16182),
      cdf!(24168),
      cdf!(31037),
      cdf!(2786),
      cdf!(11194),
      cdf!(20155),
      cdf!(16384),
      cdf!(16384),
      cdf!(16384),
    ],
    [
      cdf!(32510),
      cdf!(8430),
      cdf!(17318),
      cdf!(24154),
      cdf!(23674),
      cdf!(28789),
      cdf!(32139),
      cdf!(3440),
      cdf!(13117),
      cdf!(22702),
      cdf!(16384),
      cdf!(16384),
      cdf!(16384),
    ],
    [
      cdf!(31671),
      cdf!(2056),
      cdf!(11746),
      cdf!(16852),
      cdf!(18635),
      cdf!(24715),
      cdf!(31484),
      cdf!(4656),
      cdf!(16074),
      cdf!(24704),
      cdf!(1806),
      cdf!(14645),
      cdf!(25336),
    ],
    [
      cdf!(31539),
      cdf!(8433),
      cdf!(20576),
      cdf!(27904),
      cdf!(27852),
      cdf!(30026),
      cdf!(32441),
      cdf!(16384),
      cdf!(16384),
      cdf!(16384),
      cdf!(16384),
      cdf!(16384),
      cdf!(16384),
    ],
  ],
];

pub static av1_default_eob_extra_cdfs: [[[[[u16; cdf_size!(2)];
  EOB_COEF_CONTEXTS]; PLANE_TYPES];
  TxSize::TX_SIZES]; TOKEN_CDF_Q_CTXS] = [
  [
    [
      [
        cdf!(16961),
        cdf!(17223),
        cdf!(7621),
        cdf!(16384),
        cdf!(16384),
        cdf!(16384),
        cdf!(16384),
        cdf!(16384),
        cdf!(16384),
      ],
      [
        cdf!(19069),
        cdf!(22525),
        cdf!(13377),
        cdf!(16384),
        cdf!(16384),
        cdf!(16384),
        cdf!(16384),
        cdf!(16384),
        cdf!(16384),
      ],
    ],
    [
      [
        cdf!(20401),
        cdf!(17025),
        cdf!(12845),
        cdf!(12873),
        cdf!(14094),
        cdf!(16384),
        cdf!(16384),
        cdf!(16384),
        cdf!(16384),
      ],
      [
        cdf!(20681),
        cdf!(20701),
        cdf!(15250),
        cdf!(15017),
        cdf!(14928),
        cdf!(16384),
        cdf!(16384),
        cdf!(16384),
        cdf!(16384),
      ],
    ],
    [
      [
        cdf!(23905),
        cdf!(17194),
        cdf!(16170),
        cdf!(17695),
        cdf!(13826),
        cdf!(15810),
        cdf!(12036),
        cdf!(16384),
        cdf!(16384),
      ],
      [
        cdf!(23959),
        cdf!(20799),
        cdf!(19021),
        cdf!(16203),
        cdf!(17886),
        cdf!(14144),
        cdf!(12010),
        cdf!(16384),
        cdf!(16384),
      ],
    ],
    [
      [
        cdf!(27399),
        cdf!(16327),
        cdf!(18071),
        cdf!(19584),
        cdf!(20721),
        cdf!(18432),
        cdf!(19560),
        cdf!(10150),
        cdf!(8805),
      ],
      [
        cdf!(24932),
        cdf!(20833),
        cdf!(12027),
        cdf!(16670),
        cdf!(19914),
        cdf!(15106),
        cdf!(17662),
        cdf!(13783),
        cdf!(28756),
      ],
    ],
    [
      [
        cdf!(23406),
        cdf!(21845),
        cdf!(18432),
        cdf!(16384),
        cdf!(17096),
        cdf!(12561),
        cdf!(17320),
        cdf!(22395),
        cdf!(21370),
      ],
      [
        cdf!(16384),
        cdf!(16384),
        cdf!(16384),
        cdf!(16384),
        cdf!(16384),
        cdf!(16384),
        cdf!(16384),
        cdf!(16384),
        cdf!(16384),
      ],
    ],
  ],
  [
    [
      [
        cdf!(17471),
        cdf!(20223),
        cdf!(11357),
        cdf!(16384),
        cdf!(16384),
        cdf!(16384),
        cdf!(16384),
        cdf!(16384),
        cdf!(16384),
      ],
      [
        cdf!(20335),
        cdf!(21667),
        cdf!(14818),
        cdf!(16384),
        cdf!(16384),
        cdf!(16384),
        cdf!(16384),
        cdf!(16384),
        cdf!(16384),
      ],
    ],
    [
      [
        cdf!(20430),
        cdf!(20662),
        cdf!(15367),
        cdf!(16970),
        cdf!(14657),
        cdf!(16384),
        cdf!(16384),
        cdf!(16384),
        cdf!(16384),
      ],
      [
        cdf!(22117),
        cdf!(22028),
        cdf!(18650),
        cdf!(16042),
        cdf!(15885),
        cdf!(16384),
        cdf!(16384),
        cdf!(16384),
        cdf!(16384),
      ],
    ],
    [
      [
        cdf!(22409),
        cdf!(21012),
        cdf!(15650),
        cdf!(17395),
        cdf!(15469),
        cdf!(20205),
        cdf!(19511),
        cdf!(16384),
        cdf!(16384),
      ],
      [
        cdf!(24220),
        cdf!(22480),
        cdf!(17737),
        cdf!(18916),
        cdf!(19268),
        cdf!(18412),
        cdf!(18844),
        cdf!(16384),
        cdf!(16384),
      ],
    ],
    [
      [
        cdf!(25991),
        cdf!(20314),
        cdf!(17731),
        cdf!(19678),
        cdf!(18649),
        cdf!(17307),
        cdf!(21798),
        cdf!(17549),
        cdf!(15630),
      ],
      [
        cdf!(26585),
        cdf!(21469),
        cdf!(20432),
        cdf!(17735),
        cdf!(19280),
        cdf!(15235),
        cdf!(20297),
        cdf!(22471),
        cdf!(28997),
      ],
    ],
    [
      [
        cdf!(26605),
        cdf!(11304),
        cdf!(16726),
        cdf!(16560),
        cdf!(20866),
        cdf!(23524),
        cdf!(19878),
        cdf!(13469),
        cdf!(23084),
      ],
      [
        cdf!(16384),
        cdf!(16384),
        cdf!(16384),
        cdf!(16384),
        cdf!(16384),
        cdf!(16384),
        cdf!(16384),
        cdf!(16384),
        cdf!(16384),
      ],
    ],
  ],
  [
    [
      [
        cdf!(18983),
        cdf!(20512),
        cdf!(14885),
        cdf!(16384),
        cdf!(16384),
        cdf!(16384),
        cdf!(16384),
        cdf!(16384),
        cdf!(16384),
      ],
      [
        cdf!(20090),
        cdf!(19444),
        cdf!(17286),
        cdf!(16384),
        cdf!(16384),
        cdf!(16384),
        cdf!(16384),
        cdf!(16384),
        cdf!(16384),
      ],
    ],
    [
      [
        cdf!(19139),
        cdf!(21487),
        cdf!(18959),
        cdf!(20910),
        cdf!(19089),
        cdf!(16384),
        cdf!(16384),
        cdf!(16384),
        cdf!(16384),
      ],
      [
        cdf!(20536),
        cdf!(20664),
        cdf!(20625),
        cdf!(19123),
        cdf!(14862),
        cdf!(16384),
        cdf!(16384),
        cdf!(16384),
        cdf!(16384),
      ],
    ],
    [
      [
        cdf!(19833),
        cdf!(21502),
        cdf!(17485),
        cdf!(20267),
        cdf!(18353),
        cdf!(23329),
        cdf!(21478),
        cdf!(16384),
        cdf!(16384),
      ],
      [
        cdf!(22041),
        cdf!(23434),
        cdf!(20001),
        cdf!(20554),
        cdf!(20951),
        cdf!(20145),
        cdf!(15562),
        cdf!(16384),
        cdf!(16384),
      ],
    ],
    [
      [
        cdf!(23312),
        cdf!(21607),
        cdf!(16526),
        cdf!(18957),
        cdf!(18034),
        cdf!(18934),
        cdf!(24247),
        cdf!(16921),
        cdf!(17080),
      ],
      [
        cdf!(26579),
        cdf!(24910),
        cdf!(18637),
        cdf!(19800),
        cdf!(20388),
        cdf!(9887),
        cdf!(15642),
        cdf!(30198),
        cdf!(24721),
      ],
    ],
    [
      [
        cdf!(26998),
        cdf!(16737),
        cdf!(17838),
        cdf!(18922),
        cdf!(19515),
        cdf!(18636),
        cdf!(17333),
        cdf!(15776),
        cdf!(22658),
      ],
      [
        cdf!(16384),
        cdf!(16384),
        cdf!(16384),
        cdf!(16384),
        cdf!(16384),
        cdf!(16384),
        cdf!(16384),
        cdf!(16384),
        cdf!(16384),
      ],
    ],
  ],
  [
    [
      [
        cdf!(20177),
        cdf!(20789),
        cdf!(20262),
        cdf!(16384),
        cdf!(16384),
        cdf!(16384),
        cdf!(16384),
        cdf!(16384),
        cdf!(16384),
      ],
      [
        cdf!(21416),
        cdf!(20855),
        cdf!(23410),
        cdf!(16384),
        cdf!(16384),
        cdf!(16384),
        cdf!(16384),
        cdf!(16384),
        cdf!(16384),
      ],
    ],
    [
      [
        cdf!(20238),
        cdf!(21057),
        cdf!(19159),
        cdf!(22337),
        cdf!(20159),
        cdf!(16384),
        cdf!(16384),
        cdf!(16384),
        cdf!(16384),
      ],
      [
        cdf!(20125),
        cdf!(20559),
        cdf!(21707),
        cdf!(22296),
        cdf!(17333),
        cdf!(16384),
        cdf!(16384),
        cdf!(16384),
        cdf!(16384),
      ],
    ],
    [
      [
        cdf!(19941),
        cdf!(20527),
        cdf!(21470),
        cdf!(22487),
        cdf!(19558),
        cdf!(22354),
        cdf!(20331),
        cdf!(16384),
        cdf!(16384),
      ],
      [
        cdf!(22752),
        cdf!(25006),
        cdf!(22075),
        cdf!(21576),
        cdf!(17740),
        cdf!(21690),
        cdf!(19211),
        cdf!(16384),
        cdf!(16384),
      ],
    ],
    [
      [
        cdf!(21442),
        cdf!(22358),
        cdf!(18503),
        cdf!(20291),
        cdf!(19945),
        cdf!(21294),
        cdf!(21178),
        cdf!(19400),
        cdf!(10556),
      ],
      [
        cdf!(24648),
        cdf!(24949),
        cdf!(20708),
        cdf!(23905),
        cdf!(20501),
        cdf!(9558),
        cdf!(9423),
        cdf!(30365),
        cdf!(19253),
      ],
    ],
    [
      [
        cdf!(26064),
        cdf!(22098),
        cdf!(19613),
        cdf!(20525),
        cdf!(17595),
        cdf!(16618),
        cdf!(20497),
        cdf!(18989),
        cdf!(15513),
      ],
      [
        cdf!(16384),
        cdf!(16384),
        cdf!(16384),
        cdf!(16384),
        cdf!(16384),
        cdf!(16384),
        cdf!(16384),
        cdf!(16384),
        cdf!(16384),
      ],
    ],
  ],
];

pub static av1_default_eob_multi16_cdfs: [[[[u16; cdf_size!(5)]; 2];
  PLANE_TYPES]; TOKEN_CDF_Q_CTXS] = [
  [
    [cdf!(840, 1039, 1980, 4895), cdf!(370, 671, 1883, 4471)],
    [cdf!(3247, 4950, 9688, 14563), cdf!(1904, 3354, 7763, 14647)],
  ],
  [
    [cdf!(2125, 2551, 5165, 8946), cdf!(513, 765, 1859, 6339)],
    [cdf!(7637, 9498, 14259, 19108), cdf!(2497, 4096, 8866, 16993)],
  ],
  [
    [cdf!(4016, 4897, 8881, 14968), cdf!(716, 1105, 2646, 10056)],
    [cdf!(11139, 13270, 18241, 23566), cdf!(3192, 5032, 10297, 19755)],
  ],
  [
    [cdf!(6708, 8958, 14746, 22133), cdf!(1222, 2074, 4783, 15410)],
    [cdf!(19575, 21766, 26044, 29709), cdf!(7297, 10767, 19273, 28194)],
  ],
];

pub static av1_default_eob_multi32_cdfs: [[[[u16; cdf_size!(6)]; 2];
  PLANE_TYPES]; TOKEN_CDF_Q_CTXS] = [
  [
    [cdf!(400, 520, 977, 2102, 6542), cdf!(210, 405, 1315, 3326, 7537)],
    [
      cdf!(2636, 4273, 7588, 11794, 20401),
      cdf!(1786, 3179, 6902, 11357, 19054),
    ],
  ],
  [
    [cdf!(989, 1249, 2019, 4151, 10785), cdf!(313, 441, 1099, 2917, 8562)],
    [
      cdf!(8394, 10352, 13932, 18855, 26014),
      cdf!(2578, 4124, 8181, 13670, 24234),
    ],
  ],
  [
    [cdf!(2515, 3003, 4452, 8162, 16041), cdf!(574, 821, 1836, 5089, 13128)],
    [
      cdf!(13468, 16303, 20361, 25105, 29281),
      cdf!(3542, 5502, 10415, 16760, 25644),
    ],
  ],
  [
    [
      cdf!(4617, 5709, 8446, 13584, 23135),
      cdf!(1156, 1702, 3675, 9274, 20539),
    ],
    [
      cdf!(22086, 24282, 27010, 29770, 31743),
      cdf!(7699, 10897, 20891, 26926, 31628),
    ],
  ],
];

pub static av1_default_eob_multi64_cdfs: [[[[u16; cdf_size!(7)]; 2];
  PLANE_TYPES]; TOKEN_CDF_Q_CTXS] = [
  [
    [
      cdf!(329, 498, 1101, 1784, 3265, 7758),
      cdf!(335, 730, 1459, 5494, 8755, 12997),
    ],
    [
      cdf!(3505, 5304, 10086, 13814, 17684, 23370),
      cdf!(1563, 2700, 4876, 10911, 14706, 22480),
    ],
  ],
  [
    [
      cdf!(1260, 1446, 2253, 3712, 6652, 13369),
      cdf!(401, 605, 1029, 2563, 5845, 12626),
    ],
    [
      cdf!(8609, 10612, 14624, 18714, 22614, 29024),
      cdf!(1923, 3127, 5867, 9703, 14277, 27100),
    ],
  ],
  [
    [
      cdf!(2374, 2772, 4583, 7276, 12288, 19706),
      cdf!(497, 810, 1315, 3000, 7004, 15641),
    ],
    [
      cdf!(15050, 17126, 21410, 24886, 28156, 30726),
      cdf!(4034, 6290, 10235, 14982, 21214, 28491),
    ],
  ],
  [
    [
      cdf!(6307, 7541, 12060, 16358, 22553, 27865),
      cdf!(1289, 2320, 3971, 7926, 14153, 24291),
    ],
    [
      cdf!(24212, 25708, 28268, 30035, 31307, 32049),
      cdf!(8726, 12378, 19409, 26450, 30038, 32462),
    ],
  ],
];

pub static av1_default_eob_multi128_cdfs: [[[[u16; cdf_size!(8)]; 2];
  PLANE_TYPES]; TOKEN_CDF_Q_CTXS] = [
  [
    [
      cdf!(219, 482, 1140, 2091, 3680, 6028, 12586),
      cdf!(371, 699, 1254, 4830, 9479, 12562, 17497),
    ],
    [
      cdf!(5245, 7456, 12880, 15852, 20033, 23932, 27608),
      cdf!(2054, 3472, 5869, 14232, 18242, 20590, 26752),
    ],
  ],
  [
    [
      cdf!(685, 933, 1488, 2714, 4766, 8562, 19254),
      cdf!(217, 352, 618, 2303, 5261, 9969, 17472),
    ],
    [
      cdf!(8045, 11200, 15497, 19595, 23948, 27408, 30938),
      cdf!(2310, 4160, 7471, 14997, 17931, 20768, 30240),
    ],
  ],
  [
    [
      cdf!(1366, 1738, 2527, 5016, 9355, 15797, 24643),
      cdf!(354, 558, 944, 2760, 7287, 14037, 21779),
    ],
    [
      cdf!(13627, 16246, 20173, 24429, 27948, 30415, 31863),
      cdf!(6275, 9889, 14769, 23164, 27988, 30493, 32272),
    ],
  ],
  [
    [
      cdf!(3472, 4885, 7489, 12481, 18517, 24536, 29635),
      cdf!(886, 1731, 3271, 8469, 15569, 22126, 28383),
    ],
    [
      cdf!(24313, 26062, 28385, 30107, 31217, 31898, 32345),
      cdf!(9165, 13282, 21150, 30286, 31894, 32571, 32712),
    ],
  ],
];

pub static av1_default_eob_multi256_cdfs: [[[[u16; cdf_size!(9)]; 2];
  PLANE_TYPES]; TOKEN_CDF_Q_CTXS] = [
  [
    [
      cdf!(310, 584, 1887, 3589, 6168, 8611, 11352, 15652),
      cdf!(998, 1850, 2998, 5604, 17341, 19888, 22899, 25583),
    ],
    [
      cdf!(2520, 3240, 5952, 8870, 12577, 17558, 19954, 24168),
      cdf!(2203, 4130, 7435, 10739, 20652, 23681, 25609, 27261),
    ],
  ],
  [
    [
      cdf!(1448, 2109, 4151, 6263, 9329, 13260, 17944, 23300),
      cdf!(399, 1019, 1749, 3038, 10444, 15546, 22739, 27294),
    ],
    [
      cdf!(6402, 8148, 12623, 15072, 18728, 22847, 26447, 29377),
      cdf!(1674, 3252, 5734, 10159, 22397, 23802, 24821, 30940),
    ],
  ],
  [
    [
      cdf!(3089, 3920, 6038, 9460, 14266, 19881, 25766, 29176),
      cdf!(1084, 2358, 3488, 5122, 11483, 18103, 26023, 29799),
    ],
    [
      cdf!(11514, 13794, 17480, 20754, 24361, 27378, 29492, 31277),
      cdf!(6571, 9610, 15516, 21826, 29092, 30829, 31842, 32708),
    ],
  ],
  [
    [
      cdf!(5348, 7113, 11820, 15924, 22106, 26777, 30334, 31757),
      cdf!(2453, 4474, 6307, 8777, 16474, 22975, 29000, 31547),
    ],
    [
      cdf!(23110, 24597, 27140, 28894, 30167, 30927, 31392, 32094),
      cdf!(9998, 17661, 25178, 28097, 31308, 32038, 32403, 32695),
    ],
  ],
];

pub static av1_default_eob_multi512_cdfs: [[[[u16; cdf_size!(10)]; 2];
  PLANE_TYPES]; TOKEN_CDF_Q_CTXS] = [
  [
    [
      cdf!(641, 983, 3707, 5430, 10234, 14958, 18788, 23412, 26061),
      cdf!(3277, 6554, 9830, 13107, 16384, 19661, 22938, 26214, 29491),
    ],
    [
      cdf!(5095, 6446, 9996, 13354, 16017, 17986, 20919, 26129, 29140),
      cdf!(3277, 6554, 9830, 13107, 16384, 19661, 22938, 26214, 29491),
    ],
  ],
  [
    [
      cdf!(1230, 2278, 5035, 7776, 11871, 15346, 19590, 24584, 28749),
      cdf!(3277, 6554, 9830, 13107, 16384, 19661, 22938, 26214, 29491),
    ],
    [
      cdf!(7265, 9979, 15819, 19250, 21780, 23846, 26478, 28396, 31811),
      cdf!(3277, 6554, 9830, 13107, 16384, 19661, 22938, 26214, 29491),
    ],
  ],
  [
    [
      cdf!(2624, 3936, 6480, 9686, 13979, 17726, 23267, 28410, 31078),
      cdf!(3277, 6554, 9830, 13107, 16384, 19661, 22938, 26214, 29491),
    ],
    [
      cdf!(12015, 14769, 19588, 22052, 24222, 25812, 27300, 29219, 32114),
      cdf!(3277, 6554, 9830, 13107, 16384, 19661, 22938, 26214, 29491),
    ],
  ],
  [
    [
      cdf!(5927, 7809, 10923, 14597, 19439, 24135, 28456, 31142, 32060),
      cdf!(3277, 6554, 9830, 13107, 16384, 19661, 22938, 26214, 29491),
    ],
    [
      cdf!(21093, 23043, 25742, 27658, 29097, 29716, 30073, 30820, 31956),
      cdf!(3277, 6554, 9830, 13107, 16384, 19661, 22938, 26214, 29491),
    ],
  ],
];

pub static av1_default_eob_multi1024_cdfs: [[[[u16; cdf_size!(11)]; 2];
  PLANE_TYPES]; TOKEN_CDF_Q_CTXS] = [
  [
    [
      cdf!(393, 421, 751, 1623, 3160, 6352, 13345, 18047, 22571, 25830),
      cdf!(2979, 5958, 8937, 11916, 14895, 17873, 20852, 23831, 26810, 29789),
    ],
    [
      cdf!(1865, 1988, 2930, 4242, 10533, 16538, 21354, 27255, 28546, 31784),
      cdf!(2979, 5958, 8937, 11916, 14895, 17873, 20852, 23831, 26810, 29789),
    ],
  ],
  [
    [
      cdf!(696, 948, 3145, 5702, 9706, 13217, 17851, 21856, 25692, 28034),
      cdf!(2979, 5958, 8937, 11916, 14895, 17873, 20852, 23831, 26810, 29789),
    ],
    [
      cdf!(2672, 3591, 9330, 17084, 22725, 24284, 26527, 28027, 28377, 30876),
      cdf!(2979, 5958, 8937, 11916, 14895, 17873, 20852, 23831, 26810, 29789),
    ],
  ],
  [
    [
      cdf!(2784, 3831, 7041, 10521, 14847, 18844, 23155, 26682, 29229, 31045),
      cdf!(2979, 5958, 8937, 11916, 14895, 17873, 20852, 23831, 26810, 29789),
    ],
    [
      cdf!(
        9577, 12466, 17739, 20750, 22061, 23215, 24601, 25483, 25843, 32056
      ),
      cdf!(2979, 5958, 8937, 11916, 14895, 17873, 20852, 23831, 26810, 29789),
    ],
  ],
  [
    [
      cdf!(6698, 8334, 11961, 15762, 20186, 23862, 27434, 29326, 31082, 32050),
      cdf!(2979, 5958, 8937, 11916, 14895, 17873, 20852, 23831, 26810, 29789),
    ],
    [
      cdf!(
        20569, 22426, 25569, 26859, 28053, 28913, 29486, 29724, 29807, 32570
      ),
      cdf!(2979, 5958, 8937, 11916, 14895, 17873, 20852, 23831, 26810, 29789),
    ],
  ],
];

pub static av1_default_coeff_lps_multi_cdfs: [[[[[u16; cdf_size!(BR_CDF_SIZE)];
  LEVEL_CONTEXTS];
  PLANE_TYPES];
  TxSize::TX_SIZES];
  TOKEN_CDF_Q_CTXS] = [
  [
    [
      [
        cdf!(14298, 20718, 24174),
        cdf!(12536, 19601, 23789),
        cdf!(8712, 15051, 19503),
        cdf!(6170, 11327, 15434),
        cdf!(4742, 8926, 12538),
        cdf!(3803, 7317, 10546),
        cdf!(1696, 3317, 4871),
        cdf!(14392, 19951, 22756),
        cdf!(15978, 23218, 26818),
        cdf!(12187, 19474, 23889),
        cdf!(9176, 15640, 20259),
        cdf!(7068, 12655, 17028),
        cdf!(5656, 10442, 14472),
        cdf!(2580, 4992, 7244),
        cdf!(12136, 18049, 21426),
        cdf!(13784, 20721, 24481),
        cdf!(10836, 17621, 21900),
        cdf!(8372, 14444, 18847),
        cdf!(6523, 11779, 16000),
        cdf!(5337, 9898, 13760),
        cdf!(3034, 5860, 8462),
      ],
      [
        cdf!(15967, 22905, 26286),
        cdf!(13534, 20654, 24579),
        cdf!(9504, 16092, 20535),
        cdf!(6975, 12568, 16903),
        cdf!(5364, 10091, 14020),
        cdf!(4357, 8370, 11857),
        cdf!(2506, 4934, 7218),
        cdf!(23032, 28815, 30936),
        cdf!(19540, 26704, 29719),
        cdf!(15158, 22969, 27097),
        cdf!(11408, 18865, 23650),
        cdf!(8885, 15448, 20250),
        cdf!(7108, 12853, 17416),
        cdf!(4231, 8041, 11480),
        cdf!(19823, 26490, 29156),
        cdf!(18890, 25929, 28932),
        cdf!(15660, 23491, 27433),
        cdf!(12147, 19776, 24488),
        cdf!(9728, 16774, 21649),
        cdf!(7919, 14277, 19066),
        cdf!(5440, 10170, 14185),
      ],
    ],
    [
      [
        cdf!(14406, 20862, 24414),
        cdf!(11824, 18907, 23109),
        cdf!(8257, 14393, 18803),
        cdf!(5860, 10747, 14778),
        cdf!(4475, 8486, 11984),
        cdf!(3606, 6954, 10043),
        cdf!(1736, 3410, 5048),
        cdf!(14430, 20046, 22882),
        cdf!(15593, 22899, 26709),
        cdf!(12102, 19368, 23811),
        cdf!(9059, 15584, 20262),
        cdf!(6999, 12603, 17048),
        cdf!(5684, 10497, 14553),
        cdf!(2822, 5438, 7862),
        cdf!(15785, 21585, 24359),
        cdf!(18347, 25229, 28266),
        cdf!(14974, 22487, 26389),
        cdf!(11423, 18681, 23271),
        cdf!(8863, 15350, 20008),
        cdf!(7153, 12852, 17278),
        cdf!(3707, 7036, 9982),
      ],
      [
        cdf!(15460, 21696, 25469),
        cdf!(12170, 19249, 23191),
        cdf!(8723, 15027, 19332),
        cdf!(6428, 11704, 15874),
        cdf!(4922, 9292, 13052),
        cdf!(4139, 7695, 11010),
        cdf!(2291, 4508, 6598),
        cdf!(19856, 26920, 29828),
        cdf!(17923, 25289, 28792),
        cdf!(14278, 21968, 26297),
        cdf!(10910, 18136, 22950),
        cdf!(8423, 14815, 19627),
        cdf!(6771, 12283, 16774),
        cdf!(4074, 7750, 11081),
        cdf!(19852, 26074, 28672),
        cdf!(19371, 26110, 28989),
        cdf!(16265, 23873, 27663),
        cdf!(12758, 20378, 24952),
        cdf!(10095, 17098, 21961),
        cdf!(8250, 14628, 19451),
        cdf!(5205, 9745, 13622),
      ],
    ],
    [
      [
        cdf!(10563, 16233, 19763),
        cdf!(9794, 16022, 19804),
        cdf!(6750, 11945, 15759),
        cdf!(4963, 9186, 12752),
        cdf!(3845, 7435, 10627),
        cdf!(3051, 6085, 8834),
        cdf!(1311, 2596, 3830),
        cdf!(11246, 16404, 19689),
        cdf!(12315, 18911, 22731),
        cdf!(10557, 17095, 21289),
        cdf!(8136, 14006, 18249),
        cdf!(6348, 11474, 15565),
        cdf!(5196, 9655, 13400),
        cdf!(2349, 4526, 6587),
        cdf!(13337, 18730, 21569),
        cdf!(19306, 26071, 28882),
        cdf!(15952, 23540, 27254),
        cdf!(12409, 19934, 24430),
        cdf!(9760, 16706, 21389),
        cdf!(8004, 14220, 18818),
        cdf!(4138, 7794, 10961),
      ],
      [
        cdf!(10870, 16684, 20949),
        cdf!(9664, 15230, 18680),
        cdf!(6886, 12109, 15408),
        cdf!(4825, 8900, 12305),
        cdf!(3630, 7162, 10314),
        cdf!(3036, 6429, 9387),
        cdf!(1671, 3296, 4940),
        cdf!(13819, 19159, 23026),
        cdf!(11984, 19108, 23120),
        cdf!(10690, 17210, 21663),
        cdf!(7984, 14154, 18333),
        cdf!(6868, 12294, 16124),
        cdf!(5274, 8994, 12868),
        cdf!(2988, 5771, 8424),
        cdf!(19736, 26647, 29141),
        cdf!(18933, 26070, 28984),
        cdf!(15779, 23048, 27200),
        cdf!(12638, 20061, 24532),
        cdf!(10692, 17545, 22220),
        cdf!(9217, 15251, 20054),
        cdf!(5078, 9284, 12594),
      ],
    ],
    [
      [
        cdf!(2331, 3662, 5244),
        cdf!(2891, 4771, 6145),
        cdf!(4598, 7623, 9729),
        cdf!(3520, 6845, 9199),
        cdf!(3417, 6119, 9324),
        cdf!(2601, 5412, 7385),
        cdf!(600, 1173, 1744),
        cdf!(7672, 13286, 17469),
        cdf!(4232, 7792, 10793),
        cdf!(2915, 5317, 7397),
        cdf!(2318, 4356, 6152),
        cdf!(2127, 4000, 5554),
        cdf!(1850, 3478, 5275),
        cdf!(977, 1933, 2843),
        cdf!(18280, 24387, 27989),
        cdf!(15852, 22671, 26185),
        cdf!(13845, 20951, 24789),
        cdf!(11055, 17966, 22129),
        cdf!(9138, 15422, 19801),
        cdf!(7454, 13145, 17456),
        cdf!(3370, 6393, 9013),
      ],
      [
        cdf!(5842, 9229, 10838),
        cdf!(2313, 3491, 4276),
        cdf!(2998, 6104, 7496),
        cdf!(2420, 7447, 9868),
        cdf!(3034, 8495, 10923),
        cdf!(4076, 8937, 10975),
        cdf!(1086, 2370, 3299),
        cdf!(9714, 17254, 20444),
        cdf!(8543, 13698, 17123),
        cdf!(4918, 9007, 11910),
        cdf!(4129, 7532, 10553),
        cdf!(2364, 5533, 8058),
        cdf!(1834, 3546, 5563),
        cdf!(1473, 2908, 4133),
        cdf!(15405, 21193, 25619),
        cdf!(15691, 21952, 26561),
        cdf!(12962, 19194, 24165),
        cdf!(10272, 17855, 22129),
        cdf!(8588, 15270, 20718),
        cdf!(8682, 14669, 19500),
        cdf!(4870, 9636, 13205),
      ],
    ],
    [
      [
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
      ],
      [
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
      ],
    ],
  ],
  [
    [
      [
        cdf!(14995, 21341, 24749),
        cdf!(13158, 20289, 24601),
        cdf!(8941, 15326, 19876),
        cdf!(6297, 11541, 15807),
        cdf!(4817, 9029, 12776),
        cdf!(3731, 7273, 10627),
        cdf!(1847, 3617, 5354),
        cdf!(14472, 19659, 22343),
        cdf!(16806, 24162, 27533),
        cdf!(12900, 20404, 24713),
        cdf!(9411, 16112, 20797),
        cdf!(7056, 12697, 17148),
        cdf!(5544, 10339, 14460),
        cdf!(2954, 5704, 8319),
        cdf!(12464, 18071, 21354),
        cdf!(15482, 22528, 26034),
        cdf!(12070, 19269, 23624),
        cdf!(8953, 15406, 20106),
        cdf!(7027, 12730, 17220),
        cdf!(5887, 10913, 15140),
        cdf!(3793, 7278, 10447),
      ],
      [
        cdf!(15571, 22232, 25749),
        cdf!(14506, 21575, 25374),
        cdf!(10189, 17089, 21569),
        cdf!(7316, 13301, 17915),
        cdf!(5783, 10912, 15190),
        cdf!(4760, 9155, 13088),
        cdf!(2993, 5966, 8774),
        cdf!(23424, 28903, 30778),
        cdf!(20775, 27666, 30290),
        cdf!(16474, 24410, 28299),
        cdf!(12471, 20180, 24987),
        cdf!(9410, 16487, 21439),
        cdf!(7536, 13614, 18529),
        cdf!(5048, 9586, 13549),
        cdf!(21090, 27290, 29756),
        cdf!(20796, 27402, 30026),
        cdf!(17819, 25485, 28969),
        cdf!(13860, 21909, 26462),
        cdf!(11002, 18494, 23529),
        cdf!(8953, 15929, 20897),
        cdf!(6448, 11918, 16454),
      ],
    ],
    [
      [
        cdf!(15999, 22208, 25449),
        cdf!(13050, 19988, 24122),
        cdf!(8594, 14864, 19378),
        cdf!(6033, 11079, 15238),
        cdf!(4554, 8683, 12347),
        cdf!(3672, 7139, 10337),
        cdf!(1900, 3771, 5576),
        cdf!(15788, 21340, 23949),
        cdf!(16825, 24235, 27758),
        cdf!(12873, 20402, 24810),
        cdf!(9590, 16363, 21094),
        cdf!(7352, 13209, 17733),
        cdf!(5960, 10989, 15184),
        cdf!(3232, 6234, 9007),
        cdf!(15761, 20716, 23224),
        cdf!(19318, 25989, 28759),
        cdf!(15529, 23094, 26929),
        cdf!(11662, 18989, 23641),
        cdf!(8955, 15568, 20366),
        cdf!(7281, 13106, 17708),
        cdf!(4248, 8059, 11440),
      ],
      [
        cdf!(14899, 21217, 24503),
        cdf!(13519, 20283, 24047),
        cdf!(9429, 15966, 20365),
        cdf!(6700, 12355, 16652),
        cdf!(5088, 9704, 13716),
        cdf!(4243, 8154, 11731),
        cdf!(2702, 5364, 7861),
        cdf!(22745, 28388, 30454),
        cdf!(20235, 27146, 29922),
        cdf!(15896, 23715, 27637),
        cdf!(11840, 19350, 24131),
        cdf!(9122, 15932, 20880),
        cdf!(7488, 13581, 18362),
        cdf!(5114, 9568, 13370),
        cdf!(20845, 26553, 28932),
        cdf!(20981, 27372, 29884),
        cdf!(17781, 25335, 28785),
        cdf!(13760, 21708, 26297),
        cdf!(10975, 18415, 23365),
        cdf!(9045, 15789, 20686),
        cdf!(6130, 11199, 15423),
      ],
    ],
    [
      [
        cdf!(13549, 19724, 23158),
        cdf!(11844, 18382, 22246),
        cdf!(7919, 13619, 17773),
        cdf!(5486, 10143, 13946),
        cdf!(4166, 7983, 11324),
        cdf!(3364, 6506, 9427),
        cdf!(1598, 3160, 4674),
        cdf!(15281, 20979, 23781),
        cdf!(14939, 22119, 25952),
        cdf!(11363, 18407, 22812),
        cdf!(8609, 14857, 19370),
        cdf!(6737, 12184, 16480),
        cdf!(5506, 10263, 14262),
        cdf!(2990, 5786, 8380),
        cdf!(20249, 25253, 27417),
        cdf!(21070, 27518, 30001),
        cdf!(16854, 24469, 28074),
        cdf!(12864, 20486, 25000),
        cdf!(9962, 16978, 21778),
        cdf!(8074, 14338, 19048),
        cdf!(4494, 8479, 11906),
      ],
      [
        cdf!(13960, 19617, 22829),
        cdf!(11150, 17341, 21228),
        cdf!(7150, 12964, 17190),
        cdf!(5331, 10002, 13867),
        cdf!(4167, 7744, 11057),
        cdf!(3480, 6629, 9646),
        cdf!(1883, 3784, 5686),
        cdf!(18752, 25660, 28912),
        cdf!(16968, 24586, 28030),
        cdf!(13520, 21055, 25313),
        cdf!(10453, 17626, 22280),
        cdf!(8386, 14505, 19116),
        cdf!(6742, 12595, 17008),
        cdf!(4273, 8140, 11499),
        cdf!(22120, 27827, 30233),
        cdf!(20563, 27358, 29895),
        cdf!(17076, 24644, 28153),
        cdf!(13362, 20942, 25309),
        cdf!(10794, 17965, 22695),
        cdf!(9014, 15652, 20319),
        cdf!(5708, 10512, 14497),
      ],
    ],
    [
      [
        cdf!(5705, 10930, 15725),
        cdf!(7946, 12765, 16115),
        cdf!(6801, 12123, 16226),
        cdf!(5462, 10135, 14200),
        cdf!(4189, 8011, 11507),
        cdf!(3191, 6229, 9408),
        cdf!(1057, 2137, 3212),
        cdf!(10018, 17067, 21491),
        cdf!(7380, 12582, 16453),
        cdf!(6068, 10845, 14339),
        cdf!(5098, 9198, 12555),
        cdf!(4312, 8010, 11119),
        cdf!(3700, 6966, 9781),
        cdf!(1693, 3326, 4887),
        cdf!(18757, 24930, 27774),
        cdf!(17648, 24596, 27817),
        cdf!(14707, 22052, 26026),
        cdf!(11720, 18852, 23292),
        cdf!(9357, 15952, 20525),
        cdf!(7810, 13753, 18210),
        cdf!(3879, 7333, 10328),
      ],
      [
        cdf!(8278, 13242, 15922),
        cdf!(10547, 15867, 18919),
        cdf!(9106, 15842, 20609),
        cdf!(6833, 13007, 17218),
        cdf!(4811, 9712, 13923),
        cdf!(3985, 7352, 11128),
        cdf!(1688, 3458, 5262),
        cdf!(12951, 21861, 26510),
        cdf!(9788, 16044, 20276),
        cdf!(6309, 11244, 14870),
        cdf!(5183, 9349, 12566),
        cdf!(4389, 8229, 11492),
        cdf!(3633, 6945, 10620),
        cdf!(3600, 6847, 9907),
        cdf!(21748, 28137, 30255),
        cdf!(19436, 26581, 29560),
        cdf!(16359, 24201, 27953),
        cdf!(13961, 21693, 25871),
        cdf!(11544, 18686, 23322),
        cdf!(9372, 16462, 20952),
        cdf!(6138, 11210, 15390),
      ],
    ],
    [
      [
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
      ],
      [
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
      ],
    ],
  ],
  [
    [
      [
        cdf!(16138, 22223, 25509),
        cdf!(15347, 22430, 26332),
        cdf!(9614, 16736, 21332),
        cdf!(6600, 12275, 16907),
        cdf!(4811, 9424, 13547),
        cdf!(3748, 7809, 11420),
        cdf!(2254, 4587, 6890),
        cdf!(15196, 20284, 23177),
        cdf!(18317, 25469, 28451),
        cdf!(13918, 21651, 25842),
        cdf!(10052, 17150, 21995),
        cdf!(7499, 13630, 18587),
        cdf!(6158, 11417, 16003),
        cdf!(4014, 7785, 11252),
        cdf!(15048, 21067, 24384),
        cdf!(18202, 25346, 28553),
        cdf!(14302, 22019, 26356),
        cdf!(10839, 18139, 23166),
        cdf!(8715, 15744, 20806),
        cdf!(7536, 13576, 18544),
        cdf!(5413, 10335, 14498),
      ],
      [
        cdf!(17394, 24501, 27895),
        cdf!(15889, 23420, 27185),
        cdf!(11561, 19133, 23870),
        cdf!(8285, 14812, 19844),
        cdf!(6496, 12043, 16550),
        cdf!(4771, 9574, 13677),
        cdf!(3603, 6830, 10144),
        cdf!(21656, 27704, 30200),
        cdf!(21324, 27915, 30511),
        cdf!(17327, 25336, 28997),
        cdf!(13417, 21381, 26033),
        cdf!(10132, 17425, 22338),
        cdf!(8580, 15016, 19633),
        cdf!(5694, 11477, 16411),
        cdf!(24116, 29780, 31450),
        cdf!(23853, 29695, 31591),
        cdf!(20085, 27614, 30428),
        cdf!(15326, 24335, 28575),
        cdf!(11814, 19472, 24810),
        cdf!(10221, 18611, 24767),
        cdf!(7689, 14558, 20321),
      ],
    ],
    [
      [
        cdf!(16214, 22380, 25770),
        cdf!(14213, 21304, 25295),
        cdf!(9213, 15823, 20455),
        cdf!(6395, 11758, 16139),
        cdf!(4779, 9187, 13066),
        cdf!(3821, 7501, 10953),
        cdf!(2293, 4567, 6795),
        cdf!(15859, 21283, 23820),
        cdf!(18404, 25602, 28726),
        cdf!(14325, 21980, 26206),
        cdf!(10669, 17937, 22720),
        cdf!(8297, 14642, 19447),
        cdf!(6746, 12389, 16893),
        cdf!(4324, 8251, 11770),
        cdf!(16532, 21631, 24475),
        cdf!(20667, 27150, 29668),
        cdf!(16728, 24510, 28175),
        cdf!(12861, 20645, 25332),
        cdf!(10076, 17361, 22417),
        cdf!(8395, 14940, 19963),
        cdf!(5731, 10683, 14912),
      ],
      [
        cdf!(14433, 21155, 24938),
        cdf!(14658, 21716, 25545),
        cdf!(9923, 16824, 21557),
        cdf!(6982, 13052, 17721),
        cdf!(5419, 10503, 15050),
        cdf!(4852, 9162, 13014),
        cdf!(3271, 6395, 9630),
        cdf!(22210, 27833, 30109),
        cdf!(20750, 27368, 29821),
        cdf!(16894, 24828, 28573),
        cdf!(13247, 21276, 25757),
        cdf!(10038, 17265, 22563),
        cdf!(8587, 14947, 20327),
        cdf!(5645, 11371, 15252),
        cdf!(22027, 27526, 29714),
        cdf!(23098, 29146, 31221),
        cdf!(19886, 27341, 30272),
        cdf!(15609, 23747, 28046),
        cdf!(11993, 20065, 24939),
        cdf!(9637, 18267, 23671),
        cdf!(7625, 13801, 19144),
      ],
    ],
    [
      [
        cdf!(14438, 20798, 24089),
        cdf!(12621, 19203, 23097),
        cdf!(8177, 14125, 18402),
        cdf!(5674, 10501, 14456),
        cdf!(4236, 8239, 11733),
        cdf!(3447, 6750, 9806),
        cdf!(1986, 3950, 5864),
        cdf!(16208, 22099, 24930),
        cdf!(16537, 24025, 27585),
        cdf!(12780, 20381, 24867),
        cdf!(9767, 16612, 21416),
        cdf!(7686, 13738, 18398),
        cdf!(6333, 11614, 15964),
        cdf!(3941, 7571, 10836),
        cdf!(22819, 27422, 29202),
        cdf!(22224, 28514, 30721),
        cdf!(17660, 25433, 28913),
        cdf!(13574, 21482, 26002),
        cdf!(10629, 17977, 22938),
        cdf!(8612, 15298, 20265),
        cdf!(5607, 10491, 14596),
      ],
      [
        cdf!(13569, 19800, 23206),
        cdf!(13128, 19924, 23869),
        cdf!(8329, 14841, 19403),
        cdf!(6130, 10976, 15057),
        cdf!(4682, 8839, 12518),
        cdf!(3656, 7409, 10588),
        cdf!(2577, 5099, 7412),
        cdf!(22427, 28684, 30585),
        cdf!(20913, 27750, 30139),
        cdf!(15840, 24109, 27834),
        cdf!(12308, 20029, 24569),
        cdf!(10216, 16785, 21458),
        cdf!(8309, 14203, 19113),
        cdf!(6043, 11168, 15307),
        cdf!(23166, 28901, 30998),
        cdf!(21899, 28405, 30751),
        cdf!(18413, 26091, 29443),
        cdf!(15233, 23114, 27352),
        cdf!(12683, 20472, 25288),
        cdf!(10702, 18259, 23409),
        cdf!(8125, 14464, 19226),
      ],
    ],
    [
      [
        cdf!(9040, 14786, 18360),
        cdf!(9979, 15718, 19415),
        cdf!(7913, 13918, 18311),
        cdf!(5859, 10889, 15184),
        cdf!(4593, 8677, 12510),
        cdf!(3820, 7396, 10791),
        cdf!(1730, 3471, 5192),
        cdf!(11803, 18365, 22709),
        cdf!(11419, 18058, 22225),
        cdf!(9418, 15774, 20243),
        cdf!(7539, 13325, 17657),
        cdf!(6233, 11317, 15384),
        cdf!(5137, 9656, 13545),
        cdf!(2977, 5774, 8349),
        cdf!(21207, 27246, 29640),
        cdf!(19547, 26578, 29497),
        cdf!(16169, 23871, 27690),
        cdf!(12820, 20458, 25018),
        cdf!(10224, 17332, 22214),
        cdf!(8526, 15048, 19884),
        cdf!(5037, 9410, 13118),
      ],
      [
        cdf!(12339, 17329, 20140),
        cdf!(13505, 19895, 23225),
        cdf!(9847, 16944, 21564),
        cdf!(7280, 13256, 18348),
        cdf!(4712, 10009, 14454),
        cdf!(4361, 7914, 12477),
        cdf!(2870, 5628, 7995),
        cdf!(20061, 25504, 28526),
        cdf!(15235, 22878, 26145),
        cdf!(12985, 19958, 24155),
        cdf!(9782, 16641, 21403),
        cdf!(9456, 16360, 20760),
        cdf!(6855, 12940, 18557),
        cdf!(5661, 10564, 15002),
        cdf!(25656, 30602, 31894),
        cdf!(22570, 29107, 31092),
        cdf!(18917, 26423, 29541),
        cdf!(15940, 23649, 27754),
        cdf!(12803, 20581, 25219),
        cdf!(11082, 18695, 23376),
        cdf!(7939, 14373, 19005),
      ],
    ],
    [
      [
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
      ],
      [
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
      ],
    ],
  ],
  [
    [
      [
        cdf!(18315, 24289, 27551),
        cdf!(16854, 24068, 27835),
        cdf!(10140, 17927, 23173),
        cdf!(6722, 12982, 18267),
        cdf!(4661, 9826, 14706),
        cdf!(3832, 8165, 12294),
        cdf!(2795, 6098, 9245),
        cdf!(17145, 23326, 26672),
        cdf!(20733, 27680, 30308),
        cdf!(16032, 24461, 28546),
        cdf!(11653, 20093, 25081),
        cdf!(9290, 16429, 22086),
        cdf!(7796, 14598, 19982),
        cdf!(6502, 12378, 17441),
        cdf!(21681, 27732, 30320),
        cdf!(22389, 29044, 31261),
        cdf!(19027, 26731, 30087),
        cdf!(14739, 23755, 28624),
        cdf!(11358, 20778, 25511),
        cdf!(10995, 18073, 24190),
        cdf!(9162, 14990, 20617),
      ],
      [
        cdf!(21425, 27952, 30388),
        cdf!(18062, 25838, 29034),
        cdf!(11956, 19881, 24808),
        cdf!(7718, 15000, 20980),
        cdf!(5702, 11254, 16143),
        cdf!(4898, 9088, 16864),
        cdf!(3679, 6776, 11907),
        cdf!(23294, 30160, 31663),
        cdf!(24397, 29896, 31836),
        cdf!(19245, 27128, 30593),
        cdf!(13202, 19825, 26404),
        cdf!(11578, 19297, 23957),
        cdf!(8073, 13297, 21370),
        cdf!(5461, 10923, 19745),
        cdf!(27367, 30521, 31934),
        cdf!(24904, 30671, 31940),
        cdf!(23075, 28460, 31299),
        cdf!(14400, 23658, 30417),
        cdf!(13885, 23882, 28325),
        cdf!(14746, 22938, 27853),
        cdf!(5461, 16384, 27307),
      ],
    ],
    [
      [
        cdf!(18274, 24813, 27890),
        cdf!(15537, 23149, 27003),
        cdf!(9449, 16740, 21827),
        cdf!(6700, 12498, 17261),
        cdf!(4988, 9866, 14198),
        cdf!(4236, 8147, 11902),
        cdf!(2867, 5860, 8654),
        cdf!(17124, 23171, 26101),
        cdf!(20396, 27477, 30148),
        cdf!(16573, 24629, 28492),
        cdf!(12749, 20846, 25674),
        cdf!(10233, 17878, 22818),
        cdf!(8525, 15332, 20363),
        cdf!(6283, 11632, 16255),
        cdf!(20466, 26511, 29286),
        cdf!(23059, 29174, 31191),
        cdf!(19481, 27263, 30241),
        cdf!(15458, 23631, 28137),
        cdf!(12416, 20608, 25693),
        cdf!(10261, 18011, 23261),
        cdf!(8016, 14655, 19666),
      ],
      [
        cdf!(17616, 24586, 28112),
        cdf!(15809, 23299, 27155),
        cdf!(10767, 18890, 23793),
        cdf!(7727, 14255, 18865),
        cdf!(6129, 11926, 16882),
        cdf!(4482, 9704, 14861),
        cdf!(3277, 7452, 11522),
        cdf!(22956, 28551, 30730),
        cdf!(22724, 28937, 30961),
        cdf!(18467, 26324, 29580),
        cdf!(13234, 20713, 25649),
        cdf!(11181, 17592, 22481),
        cdf!(8291, 18358, 24576),
        cdf!(7568, 11881, 14984),
        cdf!(24948, 29001, 31147),
        cdf!(25674, 30619, 32151),
        cdf!(20841, 26793, 29603),
        cdf!(14669, 24356, 28666),
        cdf!(11334, 23593, 28219),
        cdf!(8922, 14762, 22873),
        cdf!(8301, 13544, 20535),
      ],
    ],
    [
      [
        cdf!(17113, 23733, 27081),
        cdf!(14139, 21406, 25452),
        cdf!(8552, 15002, 19776),
        cdf!(5871, 11120, 15378),
        cdf!(4455, 8616, 12253),
        cdf!(3469, 6910, 10386),
        cdf!(2255, 4553, 6782),
        cdf!(18224, 24376, 27053),
        cdf!(19290, 26710, 29614),
        cdf!(14936, 22991, 27184),
        cdf!(11238, 18951, 23762),
        cdf!(8786, 15617, 20588),
        cdf!(7317, 13228, 18003),
        cdf!(5101, 9512, 13493),
        cdf!(22639, 28222, 30210),
        cdf!(23216, 29331, 31307),
        cdf!(19075, 26762, 29895),
        cdf!(15014, 23113, 27457),
        cdf!(11938, 19857, 24752),
        cdf!(9942, 17280, 22282),
        cdf!(7167, 13144, 17752),
      ],
      [
        cdf!(15820, 22738, 26488),
        cdf!(13530, 20885, 25216),
        cdf!(8395, 15530, 20452),
        cdf!(6574, 12321, 16380),
        cdf!(5353, 10419, 14568),
        cdf!(4613, 8446, 12381),
        cdf!(3440, 7158, 9903),
        cdf!(24247, 29051, 31224),
        cdf!(22118, 28058, 30369),
        cdf!(16498, 24768, 28389),
        cdf!(12920, 21175, 26137),
        cdf!(10730, 18619, 25352),
        cdf!(10187, 16279, 22791),
        cdf!(9310, 14631, 22127),
        cdf!(24970, 30558, 32057),
        cdf!(24801, 29942, 31698),
        cdf!(22432, 28453, 30855),
        cdf!(19054, 25680, 29580),
        cdf!(14392, 23036, 28109),
        cdf!(12495, 20947, 26650),
        cdf!(12442, 20326, 26214),
      ],
    ],
    [
      [
        cdf!(12162, 18785, 22648),
        cdf!(12749, 19697, 23806),
        cdf!(8580, 15297, 20346),
        cdf!(6169, 11749, 16543),
        cdf!(4836, 9391, 13448),
        cdf!(3821, 7711, 11613),
        cdf!(2228, 4601, 7070),
        cdf!(16319, 24725, 28280),
        cdf!(15698, 23277, 27168),
        cdf!(12726, 20368, 25047),
        cdf!(9912, 17015, 21976),
        cdf!(7888, 14220, 19179),
        cdf!(6777, 12284, 17018),
        cdf!(4492, 8590, 12252),
        cdf!(23249, 28904, 30947),
        cdf!(21050, 27908, 30512),
        cdf!(17440, 25340, 28949),
        cdf!(14059, 22018, 26541),
        cdf!(11288, 18903, 23898),
        cdf!(9411, 16342, 21428),
        cdf!(6278, 11588, 15944),
      ],
      [
        cdf!(13981, 20067, 23226),
        cdf!(16922, 23580, 26783),
        cdf!(11005, 19039, 24487),
        cdf!(7389, 14218, 19798),
        cdf!(5598, 11505, 17206),
        cdf!(6090, 11213, 15659),
        cdf!(3820, 7371, 10119),
        cdf!(21082, 26925, 29675),
        cdf!(21262, 28627, 31128),
        cdf!(18392, 26454, 30437),
        cdf!(14870, 22910, 27096),
        cdf!(12620, 19484, 24908),
        cdf!(9290, 16553, 22802),
        cdf!(6668, 14288, 20004),
        cdf!(27704, 31055, 31949),
        cdf!(24709, 29978, 31788),
        cdf!(21668, 29264, 31657),
        cdf!(18295, 26968, 30074),
        cdf!(16399, 24422, 29313),
        cdf!(14347, 23026, 28104),
        cdf!(12370, 19806, 24477),
      ],
    ],
    [
      [
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
      ],
      [
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
      ],
    ],
  ],
];

pub static av1_default_coeff_base_multi_cdfs: [[[[[u16;
  cdf_size!(NUM_BASE_LEVELS + 2)];
  SIG_COEF_CONTEXTS];
  PLANE_TYPES];
  TxSize::TX_SIZES];
  TOKEN_CDF_Q_CTXS] = [
  [
    [
      [
        cdf!(4034, 8930, 12727),
        cdf!(18082, 29741, 31877),
        cdf!(12596, 26124, 30493),
        cdf!(9446, 21118, 27005),
        cdf!(6308, 15141, 21279),
        cdf!(2463, 6357, 9783),
        cdf!(20667, 30546, 31929),
        cdf!(13043, 26123, 30134),
        cdf!(8151, 18757, 24778),
        cdf!(5255, 12839, 18632),
        cdf!(2820, 7206, 11161),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(15736, 27553, 30604),
        cdf!(11210, 23794, 28787),
        cdf!(5947, 13874, 19701),
        cdf!(4215, 9323, 13891),
        cdf!(2833, 6462, 10059),
        cdf!(19605, 30393, 31582),
        cdf!(13523, 26252, 30248),
        cdf!(8446, 18622, 24512),
        cdf!(3818, 10343, 15974),
        cdf!(1481, 4117, 6796),
        cdf!(22649, 31302, 32190),
        cdf!(14829, 27127, 30449),
        cdf!(8313, 17702, 23304),
        cdf!(3022, 8301, 12786),
        cdf!(1536, 4412, 7184),
        cdf!(22354, 29774, 31372),
        cdf!(14723, 25472, 29214),
        cdf!(6673, 13745, 18662),
        cdf!(2068, 5766, 9322),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
      ],
      [
        cdf!(6302, 16444, 21761),
        cdf!(23040, 31538, 32475),
        cdf!(15196, 28452, 31496),
        cdf!(10020, 22946, 28514),
        cdf!(6533, 16862, 23501),
        cdf!(3538, 9816, 15076),
        cdf!(24444, 31875, 32525),
        cdf!(15881, 28924, 31635),
        cdf!(9922, 22873, 28466),
        cdf!(6527, 16966, 23691),
        cdf!(4114, 11303, 17220),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(20201, 30770, 32209),
        cdf!(14754, 28071, 31258),
        cdf!(8378, 20186, 26517),
        cdf!(5916, 15299, 21978),
        cdf!(4268, 11583, 17901),
        cdf!(24361, 32025, 32581),
        cdf!(18673, 30105, 31943),
        cdf!(10196, 22244, 27576),
        cdf!(5495, 14349, 20417),
        cdf!(2676, 7415, 11498),
        cdf!(24678, 31958, 32585),
        cdf!(18629, 29906, 31831),
        cdf!(9364, 20724, 26315),
        cdf!(4641, 12318, 18094),
        cdf!(2758, 7387, 11579),
        cdf!(25433, 31842, 32469),
        cdf!(18795, 29289, 31411),
        cdf!(7644, 17584, 23592),
        cdf!(3408, 9014, 15047),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
      ],
    ],
    [
      [
        cdf!(4536, 10072, 14001),
        cdf!(25459, 31416, 32206),
        cdf!(16605, 28048, 30818),
        cdf!(11008, 22857, 27719),
        cdf!(6915, 16268, 22315),
        cdf!(2625, 6812, 10537),
        cdf!(24257, 31788, 32499),
        cdf!(16880, 29454, 31879),
        cdf!(11958, 25054, 29778),
        cdf!(7916, 18718, 25084),
        cdf!(3383, 8777, 13446),
        cdf!(22720, 31603, 32393),
        cdf!(14960, 28125, 31335),
        cdf!(9731, 22210, 27928),
        cdf!(6304, 15832, 22277),
        cdf!(2910, 7818, 12166),
        cdf!(20375, 30627, 32131),
        cdf!(13904, 27284, 30887),
        cdf!(9368, 21558, 27144),
        cdf!(5937, 14966, 21119),
        cdf!(2667, 7225, 11319),
        cdf!(23970, 31470, 32378),
        cdf!(17173, 29734, 32018),
        cdf!(12795, 25441, 29965),
        cdf!(8981, 19680, 25893),
        cdf!(4728, 11372, 16902),
        cdf!(24287, 31797, 32439),
        cdf!(16703, 29145, 31696),
        cdf!(10833, 23554, 28725),
        cdf!(6468, 16566, 23057),
        cdf!(2415, 6562, 10278),
        cdf!(26610, 32395, 32659),
        cdf!(18590, 30498, 32117),
        cdf!(12420, 25756, 29950),
        cdf!(7639, 18746, 24710),
        cdf!(3001, 8086, 12347),
        cdf!(25076, 32064, 32580),
        cdf!(17946, 30128, 32028),
        cdf!(12024, 24985, 29378),
        cdf!(7517, 18390, 24304),
        cdf!(3243, 8781, 13331),
        cdf!(8192, 16384, 24576),
      ],
      [
        cdf!(6037, 16771, 21957),
        cdf!(24774, 31704, 32426),
        cdf!(16830, 28589, 31056),
        cdf!(10602, 22828, 27760),
        cdf!(6733, 16829, 23071),
        cdf!(3250, 8914, 13556),
        cdf!(25582, 32220, 32668),
        cdf!(18659, 30342, 32223),
        cdf!(12546, 26149, 30515),
        cdf!(8420, 20451, 26801),
        cdf!(4636, 12420, 18344),
        cdf!(27581, 32362, 32639),
        cdf!(18987, 30083, 31978),
        cdf!(11327, 24248, 29084),
        cdf!(7264, 17719, 24120),
        cdf!(3995, 10768, 16169),
        cdf!(25893, 31831, 32487),
        cdf!(16577, 28587, 31379),
        cdf!(10189, 22748, 28182),
        cdf!(6832, 17094, 23556),
        cdf!(3708, 10110, 15334),
        cdf!(25904, 32282, 32656),
        cdf!(19721, 30792, 32276),
        cdf!(12819, 26243, 30411),
        cdf!(8572, 20614, 26891),
        cdf!(5364, 14059, 20467),
        cdf!(26580, 32438, 32677),
        cdf!(20852, 31225, 32340),
        cdf!(12435, 25700, 29967),
        cdf!(8691, 20825, 26976),
        cdf!(4446, 12209, 17269),
        cdf!(27350, 32429, 32696),
        cdf!(21372, 30977, 32272),
        cdf!(12673, 25270, 29853),
        cdf!(9208, 20925, 26640),
        cdf!(5018, 13351, 18732),
        cdf!(27351, 32479, 32713),
        cdf!(21398, 31209, 32387),
        cdf!(12162, 25047, 29842),
        cdf!(7896, 18691, 25319),
        cdf!(4670, 12882, 18881),
        cdf!(8192, 16384, 24576),
      ],
    ],
    [
      [
        cdf!(5487, 10460, 13708),
        cdf!(21597, 28303, 30674),
        cdf!(11037, 21953, 26476),
        cdf!(8147, 17962, 22952),
        cdf!(5242, 13061, 18532),
        cdf!(1889, 5208, 8182),
        cdf!(26774, 32133, 32590),
        cdf!(17844, 29564, 31767),
        cdf!(11690, 24438, 29171),
        cdf!(7542, 18215, 24459),
        cdf!(2993, 8050, 12319),
        cdf!(28023, 32328, 32591),
        cdf!(18651, 30126, 31954),
        cdf!(12164, 25146, 29589),
        cdf!(7762, 18530, 24771),
        cdf!(3492, 9183, 13920),
        cdf!(27591, 32008, 32491),
        cdf!(17149, 28853, 31510),
        cdf!(11485, 24003, 28860),
        cdf!(7697, 18086, 24210),
        cdf!(3075, 7999, 12218),
        cdf!(28268, 32482, 32654),
        cdf!(19631, 31051, 32404),
        cdf!(13860, 27260, 31020),
        cdf!(9605, 21613, 27594),
        cdf!(4876, 12162, 17908),
        cdf!(27248, 32316, 32576),
        cdf!(18955, 30457, 32075),
        cdf!(11824, 23997, 28795),
        cdf!(7346, 18196, 24647),
        cdf!(3403, 9247, 14111),
        cdf!(29711, 32655, 32735),
        cdf!(21169, 31394, 32417),
        cdf!(13487, 27198, 30957),
        cdf!(8828, 21683, 27614),
        cdf!(4270, 11451, 17038),
        cdf!(28708, 32578, 32731),
        cdf!(20120, 31241, 32482),
        cdf!(13692, 27550, 31321),
        cdf!(9418, 22514, 28439),
        cdf!(4999, 13283, 19462),
        cdf!(8192, 16384, 24576),
      ],
      [
        cdf!(5673, 14302, 19711),
        cdf!(26251, 30701, 31834),
        cdf!(12782, 23783, 27803),
        cdf!(9127, 20657, 25808),
        cdf!(6368, 16208, 21462),
        cdf!(2465, 7177, 10822),
        cdf!(29961, 32563, 32719),
        cdf!(18318, 29891, 31949),
        cdf!(11361, 24514, 29357),
        cdf!(7900, 19603, 25607),
        cdf!(4002, 10590, 15546),
        cdf!(29637, 32310, 32595),
        cdf!(18296, 29913, 31809),
        cdf!(10144, 21515, 26871),
        cdf!(5358, 14322, 20394),
        cdf!(3067, 8362, 13346),
        cdf!(28652, 32470, 32676),
        cdf!(17538, 30771, 32209),
        cdf!(13924, 26882, 30494),
        cdf!(10496, 22837, 27869),
        cdf!(7236, 16396, 21621),
        cdf!(30743, 32687, 32746),
        cdf!(23006, 31676, 32489),
        cdf!(14494, 27828, 31120),
        cdf!(10174, 22801, 28352),
        cdf!(6242, 15281, 21043),
        cdf!(25817, 32243, 32720),
        cdf!(18618, 31367, 32325),
        cdf!(13997, 28318, 31878),
        cdf!(12255, 26534, 31383),
        cdf!(9561, 21588, 28450),
        cdf!(28188, 32635, 32724),
        cdf!(22060, 32365, 32728),
        cdf!(18102, 30690, 32528),
        cdf!(14196, 28864, 31999),
        cdf!(12262, 25792, 30865),
        cdf!(24176, 32109, 32628),
        cdf!(18280, 29681, 31963),
        cdf!(10205, 23703, 29664),
        cdf!(7889, 20025, 27676),
        cdf!(6060, 16743, 23970),
        cdf!(8192, 16384, 24576),
      ],
    ],
    [
      [
        cdf!(5141, 7096, 8260),
        cdf!(27186, 29022, 29789),
        cdf!(6668, 12568, 15682),
        cdf!(2172, 6181, 8638),
        cdf!(1126, 3379, 4531),
        cdf!(443, 1361, 2254),
        cdf!(26083, 31153, 32436),
        cdf!(13486, 24603, 28483),
        cdf!(6508, 14840, 19910),
        cdf!(3386, 8800, 13286),
        cdf!(1530, 4322, 7054),
        cdf!(29639, 32080, 32548),
        cdf!(15897, 27552, 30290),
        cdf!(8588, 20047, 25383),
        cdf!(4889, 13339, 19269),
        cdf!(2240, 6871, 10498),
        cdf!(28165, 32197, 32517),
        cdf!(20735, 30427, 31568),
        cdf!(14325, 24671, 27692),
        cdf!(5119, 12554, 17805),
        cdf!(1810, 5441, 8261),
        cdf!(31212, 32724, 32748),
        cdf!(23352, 31766, 32545),
        cdf!(14669, 27570, 31059),
        cdf!(8492, 20894, 27272),
        cdf!(3644, 10194, 15204),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
      ],
      [
        cdf!(2461, 7013, 9371),
        cdf!(24749, 29600, 30986),
        cdf!(9466, 19037, 22417),
        cdf!(3584, 9280, 14400),
        cdf!(1505, 3929, 5433),
        cdf!(677, 1500, 2736),
        cdf!(23987, 30702, 32117),
        cdf!(13554, 24571, 29263),
        cdf!(6211, 14556, 21155),
        cdf!(3135, 10972, 15625),
        cdf!(2435, 7127, 11427),
        cdf!(31300, 32532, 32550),
        cdf!(14757, 30365, 31954),
        cdf!(4405, 11612, 18553),
        cdf!(580, 4132, 7322),
        cdf!(1695, 10169, 14124),
        cdf!(30008, 32282, 32591),
        cdf!(19244, 30108, 31748),
        cdf!(11180, 24158, 29555),
        cdf!(5650, 14972, 19209),
        cdf!(2114, 5109, 8456),
        cdf!(31856, 32716, 32748),
        cdf!(23012, 31664, 32572),
        cdf!(13694, 26656, 30636),
        cdf!(8142, 19508, 26093),
        cdf!(4253, 10955, 16724),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
      ],
    ],
    [
      [
        cdf!(601, 983, 1311),
        cdf!(18725, 23406, 28087),
        cdf!(5461, 8192, 10923),
        cdf!(3781, 15124, 21425),
        cdf!(2587, 7761, 12072),
        cdf!(106, 458, 810),
        cdf!(22282, 29710, 31894),
        cdf!(8508, 20926, 25984),
        cdf!(3726, 12713, 18083),
        cdf!(1620, 7112, 10893),
        cdf!(729, 2236, 3495),
        cdf!(30163, 32474, 32684),
        cdf!(18304, 30464, 32000),
        cdf!(11443, 26526, 29647),
        cdf!(6007, 15292, 21299),
        cdf!(2234, 6703, 8937),
        cdf!(30954, 32177, 32571),
        cdf!(17363, 29562, 31076),
        cdf!(9686, 22464, 27410),
        cdf!(8192, 16384, 21390),
        cdf!(1755, 8046, 11264),
        cdf!(31168, 32734, 32748),
        cdf!(22486, 31441, 32471),
        cdf!(12833, 25627, 29738),
        cdf!(6980, 17379, 23122),
        cdf!(3111, 8887, 13479),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
      ],
      [
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
      ],
    ],
  ],
  [
    [
      [
        cdf!(6041, 11854, 15927),
        cdf!(20326, 30905, 32251),
        cdf!(14164, 26831, 30725),
        cdf!(9760, 20647, 26585),
        cdf!(6416, 14953, 21219),
        cdf!(2966, 7151, 10891),
        cdf!(23567, 31374, 32254),
        cdf!(14978, 27416, 30946),
        cdf!(9434, 20225, 26254),
        cdf!(6658, 14558, 20535),
        cdf!(3916, 8677, 12989),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(18088, 29545, 31587),
        cdf!(13062, 25843, 30073),
        cdf!(8940, 16827, 22251),
        cdf!(7654, 13220, 17973),
        cdf!(5733, 10316, 14456),
        cdf!(22879, 31388, 32114),
        cdf!(15215, 27993, 30955),
        cdf!(9397, 19445, 24978),
        cdf!(3442, 9813, 15344),
        cdf!(1368, 3936, 6532),
        cdf!(25494, 32033, 32406),
        cdf!(16772, 27963, 30718),
        cdf!(9419, 18165, 23260),
        cdf!(2677, 7501, 11797),
        cdf!(1516, 4344, 7170),
        cdf!(26556, 31454, 32101),
        cdf!(17128, 27035, 30108),
        cdf!(8324, 15344, 20249),
        cdf!(1903, 5696, 9469),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
      ],
      [
        cdf!(8455, 19003, 24368),
        cdf!(23563, 32021, 32604),
        cdf!(16237, 29446, 31935),
        cdf!(10724, 23999, 29358),
        cdf!(6725, 17528, 24416),
        cdf!(3927, 10927, 16825),
        cdf!(26313, 32288, 32634),
        cdf!(17430, 30095, 32095),
        cdf!(11116, 24606, 29679),
        cdf!(7195, 18384, 25269),
        cdf!(4726, 12852, 19315),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(22822, 31648, 32483),
        cdf!(16724, 29633, 31929),
        cdf!(10261, 23033, 28725),
        cdf!(7029, 17840, 24528),
        cdf!(4867, 13886, 21502),
        cdf!(25298, 31892, 32491),
        cdf!(17809, 29330, 31512),
        cdf!(9668, 21329, 26579),
        cdf!(4774, 12956, 18976),
        cdf!(2322, 7030, 11540),
        cdf!(25472, 31920, 32543),
        cdf!(17957, 29387, 31632),
        cdf!(9196, 20593, 26400),
        cdf!(4680, 12705, 19202),
        cdf!(2917, 8456, 13436),
        cdf!(26471, 32059, 32574),
        cdf!(18458, 29783, 31909),
        cdf!(8400, 19464, 25956),
        cdf!(3812, 10973, 17206),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
      ],
    ],
    [
      [
        cdf!(6779, 13743, 17678),
        cdf!(24806, 31797, 32457),
        cdf!(17616, 29047, 31372),
        cdf!(11063, 23175, 28003),
        cdf!(6521, 16110, 22324),
        cdf!(2764, 7504, 11654),
        cdf!(25266, 32367, 32637),
        cdf!(19054, 30553, 32175),
        cdf!(12139, 25212, 29807),
        cdf!(7311, 18162, 24704),
        cdf!(3397, 9164, 14074),
        cdf!(25988, 32208, 32522),
        cdf!(16253, 28912, 31526),
        cdf!(9151, 21387, 27372),
        cdf!(5688, 14915, 21496),
        cdf!(2717, 7627, 12004),
        cdf!(23144, 31855, 32443),
        cdf!(16070, 28491, 31325),
        cdf!(8702, 20467, 26517),
        cdf!(5243, 13956, 20367),
        cdf!(2621, 7335, 11567),
        cdf!(26636, 32340, 32630),
        cdf!(19990, 31050, 32341),
        cdf!(13243, 26105, 30315),
        cdf!(8588, 19521, 25918),
        cdf!(4717, 11585, 17304),
        cdf!(25844, 32292, 32582),
        cdf!(19090, 30635, 32097),
        cdf!(11963, 24546, 28939),
        cdf!(6218, 16087, 22354),
        cdf!(2340, 6608, 10426),
        cdf!(28046, 32576, 32694),
        cdf!(21178, 31313, 32296),
        cdf!(13486, 26184, 29870),
        cdf!(7149, 17871, 23723),
        cdf!(2833, 7958, 12259),
        cdf!(27710, 32528, 32686),
        cdf!(20674, 31076, 32268),
        cdf!(12413, 24955, 29243),
        cdf!(6676, 16927, 23097),
        cdf!(2966, 8333, 12919),
        cdf!(8192, 16384, 24576),
      ],
      [
        cdf!(8639, 19339, 24429),
        cdf!(24404, 31837, 32525),
        cdf!(16997, 29425, 31784),
        cdf!(11253, 24234, 29149),
        cdf!(6751, 17394, 24028),
        cdf!(3490, 9830, 15191),
        cdf!(26283, 32471, 32714),
        cdf!(19599, 31168, 32442),
        cdf!(13146, 26954, 30893),
        cdf!(8214, 20588, 26890),
        cdf!(4699, 13081, 19300),
        cdf!(28212, 32458, 32669),
        cdf!(18594, 30316, 32100),
        cdf!(11219, 24408, 29234),
        cdf!(6865, 17656, 24149),
        cdf!(3678, 10362, 16006),
        cdf!(25825, 32136, 32616),
        cdf!(17313, 29853, 32021),
        cdf!(11197, 24471, 29472),
        cdf!(6947, 17781, 24405),
        cdf!(3768, 10660, 16261),
        cdf!(27352, 32500, 32706),
        cdf!(20850, 31468, 32469),
        cdf!(14021, 27707, 31133),
        cdf!(8964, 21748, 27838),
        cdf!(5437, 14665, 21187),
        cdf!(26304, 32492, 32698),
        cdf!(20409, 31380, 32385),
        cdf!(13682, 27222, 30632),
        cdf!(8974, 21236, 26685),
        cdf!(4234, 11665, 16934),
        cdf!(26273, 32357, 32711),
        cdf!(20672, 31242, 32441),
        cdf!(14172, 27254, 30902),
        cdf!(9870, 21898, 27275),
        cdf!(5164, 13506, 19270),
        cdf!(26725, 32459, 32728),
        cdf!(20991, 31442, 32527),
        cdf!(13071, 26434, 30811),
        cdf!(8184, 20090, 26742),
        cdf!(4803, 13255, 19895),
        cdf!(8192, 16384, 24576),
      ],
    ],
    [
      [
        cdf!(7555, 14942, 18501),
        cdf!(24410, 31178, 32287),
        cdf!(14394, 26738, 30253),
        cdf!(8413, 19554, 25195),
        cdf!(4766, 12924, 18785),
        cdf!(2029, 5806, 9207),
        cdf!(26776, 32364, 32663),
        cdf!(18732, 29967, 31931),
        cdf!(11005, 23786, 28852),
        cdf!(6466, 16909, 23510),
        cdf!(3044, 8638, 13419),
        cdf!(29208, 32582, 32704),
        cdf!(20068, 30857, 32208),
        cdf!(12003, 25085, 29595),
        cdf!(6947, 17750, 24189),
        cdf!(3245, 9103, 14007),
        cdf!(27359, 32465, 32669),
        cdf!(19421, 30614, 32174),
        cdf!(11915, 25010, 29579),
        cdf!(6950, 17676, 24074),
        cdf!(3007, 8473, 13096),
        cdf!(29002, 32676, 32735),
        cdf!(22102, 31849, 32576),
        cdf!(14408, 28009, 31405),
        cdf!(9027, 21679, 27931),
        cdf!(4694, 12678, 18748),
        cdf!(28216, 32528, 32682),
        cdf!(20849, 31264, 32318),
        cdf!(12756, 25815, 29751),
        cdf!(7565, 18801, 24923),
        cdf!(3509, 9533, 14477),
        cdf!(30133, 32687, 32739),
        cdf!(23063, 31910, 32515),
        cdf!(14588, 28051, 31132),
        cdf!(9085, 21649, 27457),
        cdf!(4261, 11654, 17264),
        cdf!(29518, 32691, 32748),
        cdf!(22451, 31959, 32613),
        cdf!(14864, 28722, 31700),
        cdf!(9695, 22964, 28716),
        cdf!(4932, 13358, 19502),
        cdf!(8192, 16384, 24576),
      ],
      [
        cdf!(6465, 16958, 21688),
        cdf!(25199, 31514, 32360),
        cdf!(14774, 27149, 30607),
        cdf!(9257, 21438, 26972),
        cdf!(5723, 15183, 21882),
        cdf!(3150, 8879, 13731),
        cdf!(26989, 32262, 32682),
        cdf!(17396, 29937, 32085),
        cdf!(11387, 24901, 29784),
        cdf!(7289, 18821, 25548),
        cdf!(3734, 10577, 16086),
        cdf!(29728, 32501, 32695),
        cdf!(17431, 29701, 31903),
        cdf!(9921, 22826, 28300),
        cdf!(5896, 15434, 22068),
        cdf!(3430, 9646, 14757),
        cdf!(28614, 32511, 32705),
        cdf!(19364, 30638, 32263),
        cdf!(13129, 26254, 30402),
        cdf!(8754, 20484, 26440),
        cdf!(4378, 11607, 17110),
        cdf!(30292, 32671, 32744),
        cdf!(21780, 31603, 32501),
        cdf!(14314, 27829, 31291),
        cdf!(9611, 22327, 28263),
        cdf!(4890, 13087, 19065),
        cdf!(25862, 32567, 32733),
        cdf!(20794, 32050, 32567),
        cdf!(17243, 30625, 32254),
        cdf!(13283, 27628, 31474),
        cdf!(9669, 22532, 28918),
        cdf!(27435, 32697, 32748),
        cdf!(24922, 32390, 32714),
        cdf!(21449, 31504, 32536),
        cdf!(16392, 29729, 31832),
        cdf!(11692, 24884, 29076),
        cdf!(24193, 32290, 32735),
        cdf!(18909, 31104, 32563),
        cdf!(12236, 26841, 31403),
        cdf!(8171, 21840, 29082),
        cdf!(7224, 17280, 25275),
        cdf!(8192, 16384, 24576),
      ],
    ],
    [
      [
        cdf!(3078, 6839, 9890),
        cdf!(13837, 20450, 24479),
        cdf!(5914, 14222, 19328),
        cdf!(3866, 10267, 14762),
        cdf!(2612, 7208, 11042),
        cdf!(1067, 2991, 4776),
        cdf!(25817, 31646, 32529),
        cdf!(13708, 26338, 30385),
        cdf!(7328, 18585, 24870),
        cdf!(4691, 13080, 19276),
        cdf!(1825, 5253, 8352),
        cdf!(29386, 32315, 32624),
        cdf!(17160, 29001, 31360),
        cdf!(9602, 21862, 27396),
        cdf!(5915, 15772, 22148),
        cdf!(2786, 7779, 12047),
        cdf!(29246, 32450, 32663),
        cdf!(18696, 29929, 31818),
        cdf!(10510, 23369, 28560),
        cdf!(6229, 16499, 23125),
        cdf!(2608, 7448, 11705),
        cdf!(30753, 32710, 32748),
        cdf!(21638, 31487, 32503),
        cdf!(12937, 26854, 30870),
        cdf!(8182, 20596, 26970),
        cdf!(3637, 10269, 15497),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
      ],
      [
        cdf!(5244, 12150, 16906),
        cdf!(20486, 26858, 29701),
        cdf!(7756, 18317, 23735),
        cdf!(3452, 9256, 13146),
        cdf!(2020, 5206, 8229),
        cdf!(1801, 4993, 7903),
        cdf!(27051, 31858, 32531),
        cdf!(15988, 27531, 30619),
        cdf!(9188, 21484, 26719),
        cdf!(6273, 17186, 23800),
        cdf!(3108, 9355, 14764),
        cdf!(31076, 32520, 32680),
        cdf!(18119, 30037, 31850),
        cdf!(10244, 22969, 27472),
        cdf!(4692, 14077, 19273),
        cdf!(3694, 11677, 17556),
        cdf!(30060, 32581, 32720),
        cdf!(21011, 30775, 32120),
        cdf!(11931, 24820, 29289),
        cdf!(7119, 17662, 24356),
        cdf!(3833, 10706, 16304),
        cdf!(31954, 32731, 32748),
        cdf!(23913, 31724, 32489),
        cdf!(15520, 28060, 31286),
        cdf!(11517, 23008, 28571),
        cdf!(6193, 14508, 20629),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
      ],
    ],
    [
      [
        cdf!(1035, 2807, 4156),
        cdf!(13162, 18138, 20939),
        cdf!(2696, 6633, 8755),
        cdf!(1373, 4161, 6853),
        cdf!(1099, 2746, 4716),
        cdf!(340, 1021, 1599),
        cdf!(22826, 30419, 32135),
        cdf!(10395, 21762, 26942),
        cdf!(4726, 12407, 17361),
        cdf!(2447, 7080, 10593),
        cdf!(1227, 3717, 6011),
        cdf!(28156, 31424, 31934),
        cdf!(16915, 27754, 30373),
        cdf!(9148, 20990, 26431),
        cdf!(5950, 15515, 21148),
        cdf!(2492, 7327, 11526),
        cdf!(30602, 32477, 32670),
        cdf!(20026, 29955, 31568),
        cdf!(11220, 23628, 28105),
        cdf!(6652, 17019, 22973),
        cdf!(3064, 8536, 13043),
        cdf!(31769, 32724, 32748),
        cdf!(22230, 30887, 32373),
        cdf!(12234, 25079, 29731),
        cdf!(7326, 18816, 25353),
        cdf!(3933, 10907, 16616),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
      ],
      [
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
      ],
    ],
  ],
  [
    [
      [
        cdf!(8896, 16227, 20630),
        cdf!(23629, 31782, 32527),
        cdf!(15173, 27755, 31321),
        cdf!(10158, 21233, 27382),
        cdf!(6420, 14857, 21558),
        cdf!(3269, 8155, 12646),
        cdf!(24835, 32009, 32496),
        cdf!(16509, 28421, 31579),
        cdf!(10957, 21514, 27418),
        cdf!(7881, 15930, 22096),
        cdf!(5388, 10960, 15918),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(20745, 30773, 32093),
        cdf!(15200, 27221, 30861),
        cdf!(13032, 20873, 25667),
        cdf!(12285, 18663, 23494),
        cdf!(11563, 17481, 21489),
        cdf!(26260, 31982, 32320),
        cdf!(15397, 28083, 31100),
        cdf!(9742, 19217, 24824),
        cdf!(3261, 9629, 15362),
        cdf!(1480, 4322, 7499),
        cdf!(27599, 32256, 32460),
        cdf!(16857, 27659, 30774),
        cdf!(9551, 18290, 23748),
        cdf!(3052, 8933, 14103),
        cdf!(2021, 5910, 9787),
        cdf!(29005, 32015, 32392),
        cdf!(17677, 27694, 30863),
        cdf!(9204, 17356, 23219),
        cdf!(2403, 7516, 12814),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
      ],
      [
        cdf!(10808, 22056, 26896),
        cdf!(25739, 32313, 32676),
        cdf!(17288, 30203, 32221),
        cdf!(11359, 24878, 29896),
        cdf!(6949, 17767, 24893),
        cdf!(4287, 11796, 18071),
        cdf!(27880, 32521, 32705),
        cdf!(19038, 31004, 32414),
        cdf!(12564, 26345, 30768),
        cdf!(8269, 19947, 26779),
        cdf!(5674, 14657, 21674),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(25742, 32319, 32671),
        cdf!(19557, 31164, 32454),
        cdf!(13381, 26381, 30755),
        cdf!(10101, 21466, 26722),
        cdf!(9209, 19650, 26825),
        cdf!(27107, 31917, 32432),
        cdf!(18056, 28893, 31203),
        cdf!(10200, 21434, 26764),
        cdf!(4660, 12913, 19502),
        cdf!(2368, 6930, 12504),
        cdf!(26960, 32158, 32613),
        cdf!(18628, 30005, 32031),
        cdf!(10233, 22442, 28232),
        cdf!(5471, 14630, 21516),
        cdf!(3235, 10767, 17109),
        cdf!(27696, 32440, 32692),
        cdf!(20032, 31167, 32438),
        cdf!(8700, 21341, 28442),
        cdf!(5662, 14831, 21795),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
      ],
    ],
    [
      [
        cdf!(9704, 17294, 21132),
        cdf!(26762, 32278, 32633),
        cdf!(18382, 29620, 31819),
        cdf!(10891, 23475, 28723),
        cdf!(6358, 16583, 23309),
        cdf!(3248, 9118, 14141),
        cdf!(27204, 32573, 32699),
        cdf!(19818, 30824, 32329),
        cdf!(11772, 25120, 30041),
        cdf!(6995, 18033, 25039),
        cdf!(3752, 10442, 16098),
        cdf!(27222, 32256, 32559),
        cdf!(15356, 28399, 31475),
        cdf!(8821, 20635, 27057),
        cdf!(5511, 14404, 21239),
        cdf!(2935, 8222, 13051),
        cdf!(24875, 32120, 32529),
        cdf!(15233, 28265, 31445),
        cdf!(8605, 20570, 26932),
        cdf!(5431, 14413, 21196),
        cdf!(2994, 8341, 13223),
        cdf!(28201, 32604, 32700),
        cdf!(21041, 31446, 32456),
        cdf!(13221, 26213, 30475),
        cdf!(8255, 19385, 26037),
        cdf!(4930, 12585, 18830),
        cdf!(28768, 32448, 32627),
        cdf!(19705, 30561, 32021),
        cdf!(11572, 23589, 28220),
        cdf!(5532, 15034, 21446),
        cdf!(2460, 7150, 11456),
        cdf!(29874, 32619, 32699),
        cdf!(21621, 31071, 32201),
        cdf!(12511, 24747, 28992),
        cdf!(6281, 16395, 22748),
        cdf!(3246, 9278, 14497),
        cdf!(29715, 32625, 32712),
        cdf!(20958, 31011, 32283),
        cdf!(11233, 23671, 28806),
        cdf!(6012, 16128, 22868),
        cdf!(3427, 9851, 15414),
        cdf!(8192, 16384, 24576),
      ],
      [
        cdf!(11016, 22111, 26794),
        cdf!(25946, 32357, 32677),
        cdf!(17890, 30452, 32252),
        cdf!(11678, 25142, 29816),
        cdf!(6720, 17534, 24584),
        cdf!(4230, 11665, 17820),
        cdf!(28400, 32623, 32747),
        cdf!(21164, 31668, 32575),
        cdf!(13572, 27388, 31182),
        cdf!(8234, 20750, 27358),
        cdf!(5065, 14055, 20897),
        cdf!(28981, 32547, 32705),
        cdf!(18681, 30543, 32239),
        cdf!(10919, 24075, 29286),
        cdf!(6431, 17199, 24077),
        cdf!(3819, 10464, 16618),
        cdf!(26870, 32467, 32693),
        cdf!(19041, 30831, 32347),
        cdf!(11794, 25211, 30016),
        cdf!(6888, 18019, 24970),
        cdf!(4370, 12363, 18992),
        cdf!(29578, 32670, 32744),
        cdf!(23159, 32007, 32613),
        cdf!(15315, 28669, 31676),
        cdf!(9298, 22607, 28782),
        cdf!(6144, 15913, 22968),
        cdf!(28110, 32499, 32669),
        cdf!(21574, 30937, 32015),
        cdf!(12759, 24818, 28727),
        cdf!(6545, 16761, 23042),
        cdf!(3649, 10597, 16833),
        cdf!(28163, 32552, 32728),
        cdf!(22101, 31469, 32464),
        cdf!(13160, 25472, 30143),
        cdf!(7303, 18684, 25468),
        cdf!(5241, 13975, 20955),
        cdf!(28400, 32631, 32744),
        cdf!(22104, 31793, 32603),
        cdf!(13557, 26571, 30846),
        cdf!(7749, 19861, 26675),
        cdf!(4873, 14030, 21234),
        cdf!(8192, 16384, 24576),
      ],
    ],
    [
      [
        cdf!(9800, 17635, 21073),
        cdf!(26153, 31885, 32527),
        cdf!(15038, 27852, 31006),
        cdf!(8718, 20564, 26486),
        cdf!(5128, 14076, 20514),
        cdf!(2636, 7566, 11925),
        cdf!(27551, 32504, 32701),
        cdf!(18310, 30054, 32100),
        cdf!(10211, 23420, 29082),
        cdf!(6222, 16876, 23916),
        cdf!(3462, 9954, 15498),
        cdf!(29991, 32633, 32721),
        cdf!(19883, 30751, 32201),
        cdf!(11141, 24184, 29285),
        cdf!(6420, 16940, 23774),
        cdf!(3392, 9753, 15118),
        cdf!(28465, 32616, 32712),
        cdf!(19850, 30702, 32244),
        cdf!(10983, 24024, 29223),
        cdf!(6294, 16770, 23582),
        cdf!(3244, 9283, 14509),
        cdf!(30023, 32717, 32748),
        cdf!(22940, 32032, 32626),
        cdf!(14282, 27928, 31473),
        cdf!(8562, 21327, 27914),
        cdf!(4846, 13393, 19919),
        cdf!(29981, 32590, 32695),
        cdf!(20465, 30963, 32166),
        cdf!(11479, 23579, 28195),
        cdf!(5916, 15648, 22073),
        cdf!(3031, 8605, 13398),
        cdf!(31146, 32691, 32739),
        cdf!(23106, 31724, 32444),
        cdf!(13783, 26738, 30439),
        cdf!(7852, 19468, 25807),
        cdf!(3860, 11124, 16853),
        cdf!(31014, 32724, 32748),
        cdf!(23629, 32109, 32628),
        cdf!(14747, 28115, 31403),
        cdf!(8545, 21242, 27478),
        cdf!(4574, 12781, 19067),
        cdf!(8192, 16384, 24576),
      ],
      [
        cdf!(9185, 19694, 24688),
        cdf!(26081, 31985, 32621),
        cdf!(16015, 29000, 31787),
        cdf!(10542, 23690, 29206),
        cdf!(6732, 17945, 24677),
        cdf!(3916, 11039, 16722),
        cdf!(28224, 32566, 32744),
        cdf!(19100, 31138, 32485),
        cdf!(12528, 26620, 30879),
        cdf!(7741, 20277, 26885),
        cdf!(4566, 12845, 18990),
        cdf!(29933, 32593, 32718),
        cdf!(17670, 30333, 32155),
        cdf!(10385, 23600, 28909),
        cdf!(6243, 16236, 22407),
        cdf!(3976, 10389, 16017),
        cdf!(28377, 32561, 32738),
        cdf!(19366, 31175, 32482),
        cdf!(13327, 27175, 31094),
        cdf!(8258, 20769, 27143),
        cdf!(4703, 13198, 19527),
        cdf!(31086, 32706, 32748),
        cdf!(22853, 31902, 32583),
        cdf!(14759, 28186, 31419),
        cdf!(9284, 22382, 28348),
        cdf!(5585, 15192, 21868),
        cdf!(28291, 32652, 32746),
        cdf!(19849, 32107, 32571),
        cdf!(14834, 26818, 29214),
        cdf!(10306, 22594, 28672),
        cdf!(6615, 17384, 23384),
        cdf!(28947, 32604, 32745),
        cdf!(25625, 32289, 32646),
        cdf!(18758, 28672, 31403),
        cdf!(10017, 23430, 28523),
        cdf!(6862, 15269, 22131),
        cdf!(23933, 32509, 32739),
        cdf!(19927, 31495, 32631),
        cdf!(11903, 26023, 30621),
        cdf!(7026, 20094, 27252),
        cdf!(5998, 18106, 24437),
        cdf!(8192, 16384, 24576),
      ],
    ],
    [
      [
        cdf!(4456, 11274, 15533),
        cdf!(21219, 29079, 31616),
        cdf!(11173, 23774, 28567),
        cdf!(7282, 18293, 24263),
        cdf!(4890, 13286, 19115),
        cdf!(1890, 5508, 8659),
        cdf!(26651, 32136, 32647),
        cdf!(14630, 28254, 31455),
        cdf!(8716, 21287, 27395),
        cdf!(5615, 15331, 22008),
        cdf!(2675, 7700, 12150),
        cdf!(29954, 32526, 32690),
        cdf!(16126, 28982, 31633),
        cdf!(9030, 21361, 27352),
        cdf!(5411, 14793, 21271),
        cdf!(2943, 8422, 13163),
        cdf!(29539, 32601, 32730),
        cdf!(18125, 30385, 32201),
        cdf!(10422, 24090, 29468),
        cdf!(6468, 17487, 24438),
        cdf!(2970, 8653, 13531),
        cdf!(30912, 32715, 32748),
        cdf!(20666, 31373, 32497),
        cdf!(12509, 26640, 30917),
        cdf!(8058, 20629, 27290),
        cdf!(4231, 12006, 18052),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
      ],
      [
        cdf!(10202, 20633, 25484),
        cdf!(27336, 31445, 32352),
        cdf!(12420, 24384, 28552),
        cdf!(7648, 18115, 23856),
        cdf!(5662, 14341, 19902),
        cdf!(3611, 10328, 15390),
        cdf!(30945, 32616, 32736),
        cdf!(18682, 30505, 32253),
        cdf!(11513, 25336, 30203),
        cdf!(7449, 19452, 26148),
        cdf!(4482, 13051, 18886),
        cdf!(32022, 32690, 32747),
        cdf!(18578, 30501, 32146),
        cdf!(11249, 23368, 28631),
        cdf!(5645, 16958, 22158),
        cdf!(5009, 11444, 16637),
        cdf!(31357, 32710, 32748),
        cdf!(21552, 31494, 32504),
        cdf!(13891, 27677, 31340),
        cdf!(9051, 22098, 28172),
        cdf!(5190, 13377, 19486),
        cdf!(32364, 32740, 32748),
        cdf!(24839, 31907, 32551),
        cdf!(17160, 28779, 31696),
        cdf!(12452, 24137, 29602),
        cdf!(6165, 15389, 22477),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
      ],
    ],
    [
      [
        cdf!(2575, 7281, 11077),
        cdf!(14002, 20866, 25402),
        cdf!(6343, 15056, 19658),
        cdf!(4474, 11858, 17041),
        cdf!(2865, 8299, 12534),
        cdf!(1344, 3949, 6391),
        cdf!(24720, 31239, 32459),
        cdf!(12585, 25356, 29968),
        cdf!(7181, 18246, 24444),
        cdf!(5025, 13667, 19885),
        cdf!(2521, 7304, 11605),
        cdf!(29908, 32252, 32584),
        cdf!(17421, 29156, 31575),
        cdf!(9889, 22188, 27782),
        cdf!(5878, 15647, 22123),
        cdf!(2814, 8665, 13323),
        cdf!(30183, 32568, 32713),
        cdf!(18528, 30195, 32049),
        cdf!(10982, 24606, 29657),
        cdf!(6957, 18165, 25231),
        cdf!(3508, 10118, 15468),
        cdf!(31761, 32736, 32748),
        cdf!(21041, 31328, 32546),
        cdf!(12568, 26732, 31166),
        cdf!(8052, 20720, 27733),
        cdf!(4336, 12192, 18396),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
      ],
      [
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
      ],
    ],
  ],
  [
    [
      [
        cdf!(7062, 16472, 22319),
        cdf!(24538, 32261, 32674),
        cdf!(13675, 28041, 31779),
        cdf!(8590, 20674, 27631),
        cdf!(5685, 14675, 22013),
        cdf!(3655, 9898, 15731),
        cdf!(26493, 32418, 32658),
        cdf!(16376, 29342, 32090),
        cdf!(10594, 22649, 28970),
        cdf!(8176, 17170, 24303),
        cdf!(5605, 12694, 19139),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(23888, 31902, 32542),
        cdf!(18612, 29687, 31987),
        cdf!(16245, 24852, 29249),
        cdf!(15765, 22608, 27559),
        cdf!(19895, 24699, 27510),
        cdf!(28401, 32212, 32457),
        cdf!(15274, 27825, 30980),
        cdf!(9364, 18128, 24332),
        cdf!(2283, 8193, 15082),
        cdf!(1228, 3972, 7881),
        cdf!(29455, 32469, 32620),
        cdf!(17981, 28245, 31388),
        cdf!(10921, 20098, 26240),
        cdf!(3743, 11829, 18657),
        cdf!(2374, 9593, 15715),
        cdf!(31068, 32466, 32635),
        cdf!(20321, 29572, 31971),
        cdf!(10771, 20255, 27119),
        cdf!(2795, 10410, 17361),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
      ],
      [
        cdf!(9320, 22102, 27840),
        cdf!(27057, 32464, 32724),
        cdf!(16331, 30268, 32309),
        cdf!(10319, 23935, 29720),
        cdf!(6189, 16448, 24106),
        cdf!(3589, 10884, 18808),
        cdf!(29026, 32624, 32748),
        cdf!(19226, 31507, 32587),
        cdf!(12692, 26921, 31203),
        cdf!(7049, 19532, 27635),
        cdf!(7727, 15669, 23252),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(28056, 32625, 32748),
        cdf!(22383, 32075, 32669),
        cdf!(15417, 27098, 31749),
        cdf!(18127, 26493, 27190),
        cdf!(5461, 16384, 21845),
        cdf!(27982, 32091, 32584),
        cdf!(19045, 29868, 31972),
        cdf!(10397, 22266, 27932),
        cdf!(5990, 13697, 21500),
        cdf!(1792, 6912, 15104),
        cdf!(28198, 32501, 32718),
        cdf!(21534, 31521, 32569),
        cdf!(11109, 25217, 30017),
        cdf!(5671, 15124, 26151),
        cdf!(4681, 14043, 18725),
        cdf!(28688, 32580, 32741),
        cdf!(22576, 32079, 32661),
        cdf!(10627, 22141, 28340),
        cdf!(9362, 14043, 28087),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
      ],
    ],
    [
      [
        cdf!(7754, 16948, 22142),
        cdf!(25670, 32330, 32691),
        cdf!(15663, 29225, 31994),
        cdf!(9878, 23288, 29158),
        cdf!(6419, 17088, 24336),
        cdf!(3859, 11003, 17039),
        cdf!(27562, 32595, 32725),
        cdf!(17575, 30588, 32399),
        cdf!(10819, 24838, 30309),
        cdf!(7124, 18686, 25916),
        cdf!(4479, 12688, 19340),
        cdf!(28385, 32476, 32673),
        cdf!(15306, 29005, 31938),
        cdf!(8937, 21615, 28322),
        cdf!(5982, 15603, 22786),
        cdf!(3620, 10267, 16136),
        cdf!(27280, 32464, 32667),
        cdf!(15607, 29160, 32004),
        cdf!(9091, 22135, 28740),
        cdf!(6232, 16632, 24020),
        cdf!(4047, 11377, 17672),
        cdf!(29220, 32630, 32718),
        cdf!(19650, 31220, 32462),
        cdf!(13050, 26312, 30827),
        cdf!(9228, 20870, 27468),
        cdf!(6146, 15149, 21971),
        cdf!(30169, 32481, 32623),
        cdf!(17212, 29311, 31554),
        cdf!(9911, 21311, 26882),
        cdf!(4487, 13314, 20372),
        cdf!(2570, 7772, 12889),
        cdf!(30924, 32613, 32708),
        cdf!(19490, 30206, 32107),
        cdf!(11232, 23998, 29276),
        cdf!(6769, 17955, 25035),
        cdf!(4398, 12623, 19214),
        cdf!(30609, 32627, 32722),
        cdf!(19370, 30582, 32287),
        cdf!(10457, 23619, 29409),
        cdf!(6443, 17637, 24834),
        cdf!(4645, 13236, 20106),
        cdf!(8192, 16384, 24576),
      ],
      [
        cdf!(8626, 20271, 26216),
        cdf!(26707, 32406, 32711),
        cdf!(16999, 30329, 32286),
        cdf!(11445, 25123, 30286),
        cdf!(6411, 18828, 25601),
        cdf!(6801, 12458, 20248),
        cdf!(29918, 32682, 32748),
        cdf!(20649, 31739, 32618),
        cdf!(12879, 27773, 31581),
        cdf!(7896, 21751, 28244),
        cdf!(5260, 14870, 23698),
        cdf!(29252, 32593, 32731),
        cdf!(17072, 30460, 32294),
        cdf!(10653, 24143, 29365),
        cdf!(6536, 17490, 23983),
        cdf!(4929, 13170, 20085),
        cdf!(28137, 32518, 32715),
        cdf!(18171, 30784, 32407),
        cdf!(11437, 25436, 30459),
        cdf!(7252, 18534, 26176),
        cdf!(4126, 13353, 20978),
        cdf!(31162, 32726, 32748),
        cdf!(23017, 32222, 32701),
        cdf!(15629, 29233, 32046),
        cdf!(9387, 22621, 29480),
        cdf!(6922, 17616, 25010),
        cdf!(28838, 32265, 32614),
        cdf!(19701, 30206, 31920),
        cdf!(11214, 22410, 27933),
        cdf!(5320, 14177, 23034),
        cdf!(5049, 12881, 17827),
        cdf!(27484, 32471, 32734),
        cdf!(21076, 31526, 32561),
        cdf!(12707, 26303, 31211),
        cdf!(8169, 21722, 28219),
        cdf!(6045, 19406, 27042),
        cdf!(27753, 32572, 32745),
        cdf!(20832, 31878, 32653),
        cdf!(13250, 27356, 31674),
        cdf!(7718, 21508, 29858),
        cdf!(7209, 18350, 25559),
        cdf!(8192, 16384, 24576),
      ],
    ],
    [
      [
        cdf!(7876, 16901, 21741),
        cdf!(24001, 31898, 32625),
        cdf!(14529, 27959, 31451),
        cdf!(8273, 20818, 27258),
        cdf!(5278, 14673, 21510),
        cdf!(2983, 8843, 14039),
        cdf!(28016, 32574, 32732),
        cdf!(17471, 30306, 32301),
        cdf!(10224, 24063, 29728),
        cdf!(6602, 17954, 25052),
        cdf!(4002, 11585, 17759),
        cdf!(30190, 32634, 32739),
        cdf!(17497, 30282, 32270),
        cdf!(10229, 23729, 29538),
        cdf!(6344, 17211, 24440),
        cdf!(3849, 11189, 17108),
        cdf!(28570, 32583, 32726),
        cdf!(17521, 30161, 32238),
        cdf!(10153, 23565, 29378),
        cdf!(6455, 17341, 24443),
        cdf!(3907, 11042, 17024),
        cdf!(30689, 32715, 32748),
        cdf!(21546, 31840, 32610),
        cdf!(13547, 27581, 31459),
        cdf!(8912, 21757, 28309),
        cdf!(5548, 15080, 22046),
        cdf!(30783, 32540, 32685),
        cdf!(17540, 29528, 31668),
        cdf!(10160, 21468, 26783),
        cdf!(4724, 13393, 20054),
        cdf!(2702, 8174, 13102),
        cdf!(31648, 32686, 32742),
        cdf!(20954, 31094, 32337),
        cdf!(12420, 25698, 30179),
        cdf!(7304, 19320, 26248),
        cdf!(4366, 12261, 18864),
        cdf!(31581, 32723, 32748),
        cdf!(21373, 31586, 32525),
        cdf!(12744, 26625, 30885),
        cdf!(7431, 20322, 26950),
        cdf!(4692, 13323, 20111),
        cdf!(8192, 16384, 24576),
      ],
      [
        cdf!(7833, 18369, 24095),
        cdf!(26650, 32273, 32702),
        cdf!(16371, 29961, 32191),
        cdf!(11055, 24082, 29629),
        cdf!(6892, 18644, 25400),
        cdf!(5006, 13057, 19240),
        cdf!(29834, 32666, 32748),
        cdf!(19577, 31335, 32570),
        cdf!(12253, 26509, 31122),
        cdf!(7991, 20772, 27711),
        cdf!(5677, 15910, 23059),
        cdf!(30109, 32532, 32720),
        cdf!(16747, 30166, 32252),
        cdf!(10134, 23542, 29184),
        cdf!(5791, 16176, 23556),
        cdf!(4362, 10414, 17284),
        cdf!(29492, 32626, 32748),
        cdf!(19894, 31402, 32525),
        cdf!(12942, 27071, 30869),
        cdf!(8346, 21216, 27405),
        cdf!(6572, 17087, 23859),
        cdf!(32035, 32735, 32748),
        cdf!(22957, 31838, 32618),
        cdf!(14724, 28572, 31772),
        cdf!(10364, 23999, 29553),
        cdf!(7004, 18433, 25655),
        cdf!(27528, 32277, 32681),
        cdf!(16959, 31171, 32096),
        cdf!(10486, 23593, 27962),
        cdf!(8192, 16384, 23211),
        cdf!(8937, 17873, 20852),
        cdf!(27715, 32002, 32615),
        cdf!(15073, 29491, 31676),
        cdf!(11264, 24576, 28672),
        cdf!(2341, 18725, 23406),
        cdf!(7282, 18204, 25486),
        cdf!(28547, 32213, 32657),
        cdf!(20788, 29773, 32239),
        cdf!(6780, 21469, 30508),
        cdf!(5958, 14895, 23831),
        cdf!(16384, 21845, 27307),
        cdf!(8192, 16384, 24576),
      ],
    ],
    [
      [
        cdf!(5992, 14304, 19765),
        cdf!(22612, 31238, 32456),
        cdf!(13456, 27162, 31087),
        cdf!(8001, 20062, 26504),
        cdf!(5168, 14105, 20764),
        cdf!(2632, 7771, 12385),
        cdf!(27034, 32344, 32709),
        cdf!(15850, 29415, 31997),
        cdf!(9494, 22776, 28841),
        cdf!(6151, 16830, 23969),
        cdf!(3461, 10039, 15722),
        cdf!(30134, 32569, 32731),
        cdf!(15638, 29422, 31945),
        cdf!(9150, 21865, 28218),
        cdf!(5647, 15719, 22676),
        cdf!(3402, 9772, 15477),
        cdf!(28530, 32586, 32735),
        cdf!(17139, 30298, 32292),
        cdf!(10200, 24039, 29685),
        cdf!(6419, 17674, 24786),
        cdf!(3544, 10225, 15824),
        cdf!(31333, 32726, 32748),
        cdf!(20618, 31487, 32544),
        cdf!(12901, 27217, 31232),
        cdf!(8624, 21734, 28171),
        cdf!(5104, 14191, 20748),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
      ],
      [
        cdf!(11206, 21090, 26561),
        cdf!(28759, 32279, 32671),
        cdf!(14171, 27952, 31569),
        cdf!(9743, 22907, 29141),
        cdf!(6871, 17886, 24868),
        cdf!(4960, 13152, 19315),
        cdf!(31077, 32661, 32748),
        cdf!(19400, 31195, 32515),
        cdf!(12752, 26858, 31040),
        cdf!(8370, 22098, 28591),
        cdf!(5457, 15373, 22298),
        cdf!(31697, 32706, 32748),
        cdf!(17860, 30657, 32333),
        cdf!(12510, 24812, 29261),
        cdf!(6180, 19124, 24722),
        cdf!(5041, 13548, 17959),
        cdf!(31552, 32716, 32748),
        cdf!(21908, 31769, 32623),
        cdf!(14470, 28201, 31565),
        cdf!(9493, 22982, 28608),
        cdf!(6858, 17240, 24137),
        cdf!(32543, 32752, 32756),
        cdf!(24286, 32097, 32666),
        cdf!(15958, 29217, 32024),
        cdf!(10207, 24234, 29958),
        cdf!(6929, 18305, 25652),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
      ],
    ],
    [
      [
        cdf!(4137, 10847, 15682),
        cdf!(17824, 27001, 30058),
        cdf!(10204, 22796, 28291),
        cdf!(6076, 15935, 22125),
        cdf!(3852, 10937, 16816),
        cdf!(2252, 6324, 10131),
        cdf!(25840, 32016, 32662),
        cdf!(15109, 28268, 31531),
        cdf!(9385, 22231, 28340),
        cdf!(6082, 16672, 23479),
        cdf!(3318, 9427, 14681),
        cdf!(30594, 32574, 32718),
        cdf!(16836, 29552, 31859),
        cdf!(9556, 22542, 28356),
        cdf!(6305, 16725, 23540),
        cdf!(3376, 9895, 15184),
        cdf!(29383, 32617, 32745),
        cdf!(18891, 30809, 32401),
        cdf!(11688, 25942, 30687),
        cdf!(7468, 19469, 26651),
        cdf!(3909, 11358, 17012),
        cdf!(31564, 32736, 32748),
        cdf!(20906, 31611, 32600),
        cdf!(13191, 27621, 31537),
        cdf!(8768, 22029, 28676),
        cdf!(5079, 14109, 20906),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
      ],
      [
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
        cdf!(8192, 16384, 24576),
      ],
    ],
  ],
];

pub static av1_default_coeff_base_eob_multi_cdfs: [[[[[u16;
  cdf_size!(NUM_BASE_LEVELS + 1)];
  SIG_COEF_CONTEXTS_EOB];
  PLANE_TYPES];
  TxSize::TX_SIZES];
  TOKEN_CDF_Q_CTXS] = [
  [
    [
      [
        cdf!(17837, 29055),
        cdf!(29600, 31446),
        cdf!(30844, 31878),
        cdf!(24926, 28948),
      ],
      [
        cdf!(21365, 30026),
        cdf!(30512, 32423),
        cdf!(31658, 32621),
        cdf!(29630, 31881),
      ],
    ],
    [
      [
        cdf!(5717, 26477),
        cdf!(30491, 31703),
        cdf!(31550, 32158),
        cdf!(29648, 31491),
      ],
      [
        cdf!(12608, 27820),
        cdf!(30680, 32225),
        cdf!(30809, 32335),
        cdf!(31299, 32423),
      ],
    ],
    [
      [
        cdf!(1786, 12612),
        cdf!(30663, 31625),
        cdf!(32339, 32468),
        cdf!(31148, 31833),
      ],
      [
        cdf!(18857, 23865),
        cdf!(31428, 32428),
        cdf!(31744, 32373),
        cdf!(31775, 32526),
      ],
    ],
    [
      [
        cdf!(1787, 2532),
        cdf!(30832, 31662),
        cdf!(31824, 32682),
        cdf!(32133, 32569),
      ],
      [
        cdf!(13751, 22235),
        cdf!(32089, 32409),
        cdf!(27084, 27920),
        cdf!(29291, 32594),
      ],
    ],
    [
      [
        cdf!(1725, 3449),
        cdf!(31102, 31935),
        cdf!(32457, 32613),
        cdf!(32412, 32649),
      ],
      [
        cdf!(10923, 21845),
        cdf!(10923, 21845),
        cdf!(10923, 21845),
        cdf!(10923, 21845),
      ],
    ],
  ],
  [
    [
      [
        cdf!(17560, 29888),
        cdf!(29671, 31549),
        cdf!(31007, 32056),
        cdf!(27286, 30006),
      ],
      [
        cdf!(26594, 31212),
        cdf!(31208, 32582),
        cdf!(31835, 32637),
        cdf!(30595, 32206),
      ],
    ],
    [
      [
        cdf!(15239, 29932),
        cdf!(31315, 32095),
        cdf!(32130, 32434),
        cdf!(30864, 31996),
      ],
      [
        cdf!(26279, 30968),
        cdf!(31142, 32495),
        cdf!(31713, 32540),
        cdf!(31929, 32594),
      ],
    ],
    [
      [
        cdf!(2644, 25198),
        cdf!(32038, 32451),
        cdf!(32639, 32695),
        cdf!(32166, 32518),
      ],
      [
        cdf!(17187, 27668),
        cdf!(31714, 32550),
        cdf!(32283, 32678),
        cdf!(31930, 32563),
      ],
    ],
    [
      [
        cdf!(1044, 2257),
        cdf!(30755, 31923),
        cdf!(32208, 32693),
        cdf!(32244, 32615),
      ],
      [
        cdf!(21317, 26207),
        cdf!(29133, 30868),
        cdf!(29311, 31231),
        cdf!(29657, 31087),
      ],
    ],
    [
      [
        cdf!(478, 1834),
        cdf!(31005, 31987),
        cdf!(32317, 32724),
        cdf!(30865, 32648),
      ],
      [
        cdf!(10923, 21845),
        cdf!(10923, 21845),
        cdf!(10923, 21845),
        cdf!(10923, 21845),
      ],
    ],
  ],
  [
    [
      [
        cdf!(20092, 30774),
        cdf!(30695, 32020),
        cdf!(31131, 32103),
        cdf!(28666, 30870),
      ],
      [
        cdf!(27258, 31095),
        cdf!(31804, 32623),
        cdf!(31763, 32528),
        cdf!(31438, 32506),
      ],
    ],
    [
      [
        cdf!(18049, 30489),
        cdf!(31706, 32286),
        cdf!(32163, 32473),
        cdf!(31550, 32184),
      ],
      [
        cdf!(27116, 30842),
        cdf!(31971, 32598),
        cdf!(32088, 32576),
        cdf!(32067, 32664),
      ],
    ],
    [
      [
        cdf!(12854, 29093),
        cdf!(32272, 32558),
        cdf!(32667, 32729),
        cdf!(32306, 32585),
      ],
      [
        cdf!(25476, 30366),
        cdf!(32169, 32687),
        cdf!(32479, 32689),
        cdf!(31673, 32634),
      ],
    ],
    [
      [
        cdf!(2809, 19301),
        cdf!(32205, 32622),
        cdf!(32338, 32730),
        cdf!(31786, 32616),
      ],
      [
        cdf!(22737, 29105),
        cdf!(30810, 32362),
        cdf!(30014, 32627),
        cdf!(30528, 32574),
      ],
    ],
    [
      [
        cdf!(935, 3382),
        cdf!(30789, 31909),
        cdf!(32466, 32756),
        cdf!(30860, 32513),
      ],
      [
        cdf!(10923, 21845),
        cdf!(10923, 21845),
        cdf!(10923, 21845),
        cdf!(10923, 21845),
      ],
    ],
  ],
  [
    [
      [
        cdf!(22497, 31198),
        cdf!(31715, 32495),
        cdf!(31606, 32337),
        cdf!(30388, 31990),
      ],
      [
        cdf!(27877, 31584),
        cdf!(32170, 32728),
        cdf!(32155, 32688),
        cdf!(32219, 32702),
      ],
    ],
    [
      [
        cdf!(21457, 31043),
        cdf!(31951, 32483),
        cdf!(32153, 32562),
        cdf!(31473, 32215),
      ],
      [
        cdf!(27558, 31151),
        cdf!(32020, 32640),
        cdf!(32097, 32575),
        cdf!(32242, 32719),
      ],
    ],
    [
      [
        cdf!(19980, 30591),
        cdf!(32219, 32597),
        cdf!(32581, 32706),
        cdf!(31803, 32287),
      ],
      [
        cdf!(26473, 30507),
        cdf!(32431, 32723),
        cdf!(32196, 32611),
        cdf!(31588, 32528),
      ],
    ],
    [
      [
        cdf!(24647, 30463),
        cdf!(32412, 32695),
        cdf!(32468, 32720),
        cdf!(31269, 32523),
      ],
      [
        cdf!(28482, 31505),
        cdf!(32152, 32701),
        cdf!(31732, 32598),
        cdf!(31767, 32712),
      ],
    ],
    [
      [
        cdf!(12358, 24977),
        cdf!(31331, 32385),
        cdf!(32634, 32756),
        cdf!(30411, 32548),
      ],
      [
        cdf!(10923, 21845),
        cdf!(10923, 21845),
        cdf!(10923, 21845),
        cdf!(10923, 21845),
      ],
    ],
  ],
];
