#[cfg(unix)]
use {thrussh, thrussh_keys, libpijul, reqwest, term, toml, hex, bs58, regex};
#[cfg(windows)]
use {thrussh, thrussh_keys, libpijul, reqwest, term, toml, hex, bs58, regex};
use std;
use std::path::PathBuf;

#[cfg(windows)]
error_chain!{
    foreign_links {
        IO(std::io::Error);
        Term(term::Error);
        Repository(libpijul::Error);
        UTF8(std::string::FromUtf8Error);
        Hex(hex::FromHexError);
        SSH(thrussh::Error);
        SSHKeys(thrussh_keys::Error);
        Reqwest(reqwest::Error);
        TomlDe(toml::de::Error);
        TomlSer(toml::ser::Error);
        Base58(bs58::decode::DecodeError);
        StripPrefix(std::path::StripPrefixError);
        Regex(regex::Error);
    }
    errors {
        HookFailed(cmd: String) {
            description("Failure hook")
                display("Hook failed: {}", cmd)
        }
        InARepository(path: std::path::PathBuf) {
            description("Inside repository")
                display("Inside repository {:?}", path)
        }
        NotInARepository {
            description("Not in a repository")
        }
        MissingRemoteRepository {
            description("Missing remote repository")
        }
        InvalidPath(path: String) {
            description("Invalid path")
                display("Invalid path {}", path)
        }
        WrongHash {
            description("Wrong hash")
        }
        BranchAlreadyExists {
            description("That branch already exists")
        }
        CannotDeleteCurrentBranch {
            description("Cannot delete current branch")
        }
        NoSuchBranch {
            description("No such branch")
                display("That branch does not exist. You can create it using pijul fork.")
        }
        IsDirectory {
            description("Is a directory")
        }
        CannotParseRemote {
            description("Cannot parse remote address")
        }
        WillNotOverwriteKeyFile(path: std::path::PathBuf) {
            description("Refusing to overwrite key file")
                display("Refusing to overwrite key file {:?}", path)
        }
        BranchDoesNotHavePatch(branch_name: String, patch: libpijul::Hash) {
            description("This branch does not have this patch")
                display("Branch \"{}\" does not have patch {}",
                        branch_name,
                        patch.to_base58())
        }
        PatchNotFound(repo_root: String, patch_hash: libpijul::Hash) {
            description("Patch not found")
                display("Patch {} not found in repository {:?}",
                        patch_hash.to_base58(),
                        repo_root)
        }
        SshKeyNotFound(path: PathBuf) {
            description("SSH key not found")
                display("SSH key not found in {:?}", path)
        }
        NoHomeDir {
            description("No home dir")
                display("No home dir")
        }
        ExtraDepNotOnBranch(hash: libpijul::Hash) {
            description("Extra dependencies can only be added if they are on the same branch as the current record.")
            display("Extra dependencies can only be added if they are on the same branch as the current record: {:?}", hash.to_base58())
        }
        PendingChanges {
            description("Pending Change in the Repository")
                display("There are pending changes in the repository. You need to revert or record them if you want to continue.")
        }
        EmptyPatchName {
            description("Empty patch name")
                display("You have provided an empty patch name.")
        }
        CannotSpawnEditor(editor: String, cause: String) {
            description("Cannot spawn editor command")
            display("Cannot start editor \"{}\" because: {}", editor, cause)
        }
        InvalidDate(date:  String) {
            description("Invalid date")
                display("“{}” is not a valid date", date)

        }
    }
}

#[cfg(unix)]
error_chain!{
    foreign_links {
        IO(std::io::Error);
        Term(term::Error);
        Repository(libpijul::Error);
        UTF8(std::string::FromUtf8Error);
        Hex(hex::FromHexError);
        SSH(thrussh::Error);
        SSHKeys(thrussh_keys::Error);
        Reqwest(reqwest::Error);
        TomlDe(toml::de::Error);
        TomlSer(toml::ser::Error);
        Base58(bs58::decode::DecodeError);
        StripPrefix(std::path::StripPrefixError);
        Regex(regex::Error);
    }
    errors {
        HookFailed(cmd: String) {
            description("Failure hook")
                display("Hook failed: {}", cmd)
        }
        InARepository(path: std::path::PathBuf) {
            description("Inside repository")
                display("Inside repository {:?}", path)
        }
        NotInARepository {
            description("Not in a repository")
        }
        MissingRemoteRepository {
            description("Missing remote repository")
        }
        InvalidPath(path: String) {
            description("Invalid path")
                display("Invalid path {}", path)
        }
        WrongHash {
            description("Wrong hash")
        }
        BranchAlreadyExists {
            description("That branch already exists")
        }
        CannotDeleteCurrentBranch {
            description("Cannot delete current branch")
        }
        NoSuchBranch {
            description("No such branch")
                display("That branch does not exist. You can create it using pijul fork.")
        }
        IsDirectory {
            description("Is a directory")
        }
        CannotParseRemote {
            description("Cannot parse remote address")
        }
        WillNotOverwriteKeyFile(path: std::path::PathBuf) {
            description("Refusing to overwrite key file")
                display("Refusing to overwrite key file {:?}", path)
        }
        BranchDoesNotHavePatch(branch_name: String, patch: libpijul::Hash) {
            description("This branch does not have this patch")
                display("Branch \"{}\" does not have patch {}",
                        branch_name,
                        patch.to_base58())
        }
        PatchNotFound(repo_root: String, patch_hash: libpijul::Hash) {
            description("Patch not found")
                display("Patch {} not found in repository {:?}",
                        patch_hash.to_base58(),
                        repo_root)
        }
        SshKeyNotFound(path: PathBuf) {
            description("SSH key not found")
                display("SSH key not found in {:?}", path)
        }
        NoHomeDir {
            description("No home dir")
                display("No home dir")
        }
        ExtraDepNotOnBranch(hash: libpijul::Hash) {
            description("Extra dependencies can only be added if they are on the same branch as the current record.")
            display("Extra dependencies can only be added if they are on the same branch as the current record: {:?}", hash.to_base58())
        }
        PendingChanges {
            description("Pending Change in the Repository")
                display("There are pending changes in the repository. You need to revert or record them if you want to continue.")
        }
        EmptyPatchName {
            description("Empty patch name")
                display("You have provided an empty patch name.")
        }
        CannotSpawnEditor(editor: String, cause: String) {
            description("Cannot spawn editor command")
            display("Cannot start editor \"{}\" because: {}", editor, cause)
        }
        InvalidDate(date:  String) {
            description("Invalid date")
                display("“{}” is not a valid date", date)

        }
    }
}

impl ErrorKind {
    pub fn lacks_space(&self) -> bool {
        match *self {
            ErrorKind::Repository(ref r) => r.lacks_space(),
            _ => false
        }
    }
}

impl From<thrussh::HandlerError<Error>> for Error {
    fn from(err: thrussh::HandlerError<Error>) -> Error {
        match err {
            thrussh::HandlerError::Handler(e) => e,
            thrussh::HandlerError::Error(e) => ErrorKind::SSH(e).into()
        }
    }
}
impl From<Error> for thrussh::HandlerError<Error> {
    fn from(e: Error) -> thrussh::HandlerError<Error> {
        thrussh::HandlerError::Handler(e)
    }
}
