# split column

splits contents across multiple columns via the separator.

Syntax: `split column <separator>  ...args{flags}`

## Parameters

* `<separator>`: string that denotes what separates columns
* `args`: column names to give the new columns. If not specified they will be set to `Column1` `Column2` ...

## Flags

    --collapse-empty
      Removes empty columns

## Examples

If we have file structured like this:

```shell
0.12643678160919541 | 0.6851851851851852 | 0.273972602739726
0.28735632183908044 | 0.09259259259259259 | 0.6986301369863014
0.8045977011494253 | 0.8148148148148148 | 0.7397260273972602
0.28735632183908044 | 0.09259259259259259 | 0.547945205479452
0.6896551724137931 | 0.7037037037037037 | 1.2465753424657535
0.6896551724137931 | 0.8333333333333334 | 0.4657534246575342
0.9080459770114943 | 1.3333333333333333 | 0.4931506849315068
0.9310344827586207 | 1.1296296296296295 | 0.7123287671232876
0.3448275862068966 | 0.018518518518518517 | 0.6575342465753424
1.0459770114942528 | 1.0925925925925926 | 0.6164383561643836
```

We can build a table from it using the `split column` command

```shell
> open coordinates.txt | lines | split column " | "
───┬─────────────────────┬──────────────────────┬────────────────────
 # │ Column1             │ Column2              │ Column3
───┼─────────────────────┼──────────────────────┼────────────────────
 0 │ 0.12643678160919541 │ 0.6851851851851852   │ 0.273972602739726
 1 │ 0.28735632183908044 │ 0.09259259259259259  │ 0.6986301369863014
 2 │ 0.8045977011494253  │ 0.8148148148148148   │ 0.7397260273972602
 3 │ 0.28735632183908044 │ 0.09259259259259259  │ 0.547945205479452
 4 │ 0.6896551724137931  │ 0.7037037037037037   │ 1.2465753424657535
 5 │ 0.6896551724137931  │ 0.8333333333333334   │ 0.4657534246575342
 6 │ 0.9080459770114943  │ 1.3333333333333333   │ 0.4931506849315068
 7 │ 0.9310344827586207  │ 1.1296296296296295   │ 0.7123287671232876
 8 │ 0.3448275862068966  │ 0.018518518518518517 │ 0.6575342465753424
 9 │ 1.0459770114942528  │ 1.0925925925925926   │ 0.6164383561643836
───┴─────────────────────┴──────────────────────┴────────────────────
```

And give names to the columns

```shell
> open coordinates.txt | lines | split column " | " x y z
───┬─────────────────────┬──────────────────────┬────────────────────
 # │ x                   │ y                    │ z
───┼─────────────────────┼──────────────────────┼────────────────────
 0 │ 0.12643678160919541 │ 0.6851851851851852   │ 0.273972602739726
 1 │ 0.28735632183908044 │ 0.09259259259259259  │ 0.6986301369863014
 2 │ 0.8045977011494253  │ 0.8148148148148148   │ 0.7397260273972602
 3 │ 0.28735632183908044 │ 0.09259259259259259  │ 0.547945205479452
 4 │ 0.6896551724137931  │ 0.7037037037037037   │ 1.2465753424657535
 5 │ 0.6896551724137931  │ 0.8333333333333334   │ 0.4657534246575342
 6 │ 0.9080459770114943  │ 1.3333333333333333   │ 0.4931506849315068
 7 │ 0.9310344827586207  │ 1.1296296296296295   │ 0.7123287671232876
 8 │ 0.3448275862068966  │ 0.018518518518518517 │ 0.6575342465753424
 9 │ 1.0459770114942528  │ 1.0925925925925926   │ 0.6164383561643836
───┴─────────────────────┴──────────────────────┴────────────────────
```
