# random

Use `random` to generate random values

## bool

* `random bool`: Generate a random boolean value

### bool Flags

* `-b`, `--bias` \<number>: Adjusts the probability of a "true" outcome

### bool Examples

```shell
> random bool
false
```

```shell
> random bool --bias 0.75
true
```

## dice

* `random dice`: Generate a random dice roll

### dice Flags

* `d`, `--dice` \<integer>: The amount of dice being rolled
* `s`, `--sides` \<integer>: The amount of sides a die has

### dice Examples

```shell
> random dice
4
```

```shell
> random dice -d 10 -s 12
───┬────
 0 │ 11
 1 │ 11
 2 │ 11
 3 │ 11
 4 │  5
 5 │  3
 6 │ 10
 7 │  7
 8 │  3
 9 │  1
───┴────
```

```shell
> random dice --dice 1024 --sides 16 | histogram | sort-by occurrences
────┬───────┬─────────────┬────────────┬──────────────────────────────────────────────────────────────────────────────────────────────────────
 #  │ value │ occurrences │ percentage │ frequency
────┼───────┼─────────────┼────────────┼──────────────────────────────────────────────────────────────────────────────────────────────────────
  0 │ 6     │          57 │ 75.00%     │ ***************************************************************************
  1 │ 12    │          59 │ 77.63%     │ *****************************************************************************
  2 │ 3     │          59 │ 77.63%     │ *****************************************************************************
  3 │ 16    │          60 │ 78.95%     │ ******************************************************************************
  4 │ 13    │          61 │ 80.26%     │ ********************************************************************************
  5 │ 11    │          62 │ 81.58%     │ *********************************************************************************
  6 │ 5     │          62 │ 81.58%     │ *********************************************************************************
  7 │ 9     │          62 │ 81.58%     │ *********************************************************************************
  8 │ 4     │          63 │ 82.89%     │ **********************************************************************************
  9 │ 8     │          64 │ 84.21%     │ ************************************************************************************
 10 │ 10    │          65 │ 85.53%     │ *************************************************************************************
 11 │ 15    │          66 │ 86.84%     │ **************************************************************************************
 12 │ 14    │          67 │ 88.16%     │ ****************************************************************************************
 13 │ 7     │          69 │ 90.79%     │ ******************************************************************************************
 14 │ 1     │          72 │ 94.74%     │ **********************************************************************************************
 15 │ 2     │          76 │ 100.00%    │ ****************************************************************************************************
────┴───────┴─────────────┴────────────┴──────────────────────────────────────────────────────────────────────────────────────────────────────
```

## uuid

* `random uuid`: Generate a random uuid4 string

### uuid Examples

```shell
> random uuid
8af4de39-acbc-42f0-94d1-7cfad6c01f8b
```

## integer

* `random integer`: Generate a random integer

### integer Flags

* `m`, `--min` \<integer>: The minimum value to generate
* `x`, `--max` \<integer>: The maximum value to generate

### integer Examples

```shell
> random integer
42
```

```shell
> random integer 5000..
8700890823
```

```shell
> random integer ..100
73
```

```shell
> random integer 100000..200000
173400
```

### chars Examples
Generate a random password of length 15
```shell
> random chars -l 15
fWBSbE7QtaoJGeo
```