Installation
------------

* [Installing the main binary](#installing-the-main-binary)
    * [Using Homebrew](#using-homebrew)
    * [Using Gentoo](#using-gentoo)
    * [Using nix](#using-nix)
    * [Using cargo](#using-cargo)
    * [Using install script](#using-install-script)
    * [Downloading pre-compiled binaries](#downloading-pre-compiled-binaries)
    * [Building from source](#building-from-source)
    * [Other package managers](#other-package-managers)
* [Installing the shell widget](#installing-the-shell-widget)

### Installing the main binary

#### Using [Homebrew](http://brew.sh/)

```sh
brew install navi
```

#### Using [Gentoo](https://gentoo.org/)

Be sure to [enable](https://wiki.gentoo.org/wiki/Ebuild_repository) the [GURU overlay](https://gpo.zugaina.org/Overlays/guru/app-misc/navi).

```sh
emerge -a app-misc/navi
```

#### Using [nix](https://nixos.org/)

```sh
nix-env -iA nixpkgs.navi
```

#### Using [cargo](https://github.com/rust-lang/cargo)

```bash
cargo install --locked navi
```

#### Using install script

```bash
bash <(curl -sL https://raw.githubusercontent.com/denisidoro/navi/master/scripts/install)

# (optional) to set directories:
# BIN_DIR=/usr/local/bin bash <(curl -sL https://raw.githubusercontent.com/denisidoro/navi/master/scripts/install)
```

#### Downloading pre-compiled binaries

- download the correct binary [here](https://github.com/denisidoro/navi/releases/latest)
- extract the content to your `$PATH`

#### Building from source

```bash
git clone https://github.com/denisidoro/navi ~/.navi
cd ~/.navi
make install 

# (optional) to set the install directory:
# make BIN_DIR=/usr/local/bin install
```

##### Compile time environment variables

**navi** supports environment variables at compile time that modify the behavior of the binary at runtime:

- `NAVI_PATH` (directory path value): If the `cheats` directory in the user's directory does not exist, **navi** uses this path (if it exists), as a fallback location to look for cheat files. Use case: system-wide installed, shared used cheatsheets folder.
- `NAVI_CONFIG` (file path value): If the `config.yaml` file in the user's directory does not exist, **navi** uses this path (if it exists), as a fallback location to look for a configuration file. Use case: system-wide installed, shared used configuration file.

#### Other package managers

You can find **navi** for more package managers by clicking on the image below: 

[![Packaging status](https://repology.org/badge/vertical-allrepos/navi.svg)](https://repology.org/project/navi/versions)

Feel free to be the maintainer of **navi** for any package manager you'd like!

### Installing the shell widget

If you want to install it, add this line to your `.bashrc`-like file:
```sh
# bash
eval "$(navi widget bash)"

# zsh
eval "$(navi widget zsh)"

# fish
navi widget fish | source

# elvish
eval (navi widget elvish | slurp)
```

By default, `Ctrl+G` is assigned to launching **navi**.

There's currently no way to customize the widget behavior out-of-the-box. If you want to change the keybinding or the **navi** flags used by the widget, please:
1. run, e.g., `navi widget bash` in your terminal
2. copy the output
3. paste the output in your `.bashrc`-like file
4. edit the contents accordingly
