// AUTOGENERATED with ExifTool 12.50 ()

#include <stdint.h>
#include <map>

#include "exif_tags.hpp"


const TagTable exif_tag_names = {
    { 0x1, "InteropIndex" },
    { 0x2, "InteropVersion" },
    { 0xb, "ProcessingSoftware" },
    { 0xfe, "SubfileType" },
    { 0xff, "OldSubfileType" },
    { 0x100, "ImageWidth" },
    { 0x101, "ImageHeight" },
    { 0x102, "BitsPerSample" },
    { 0x103, "Compression" },
    { 0x106, "PhotometricInterpretation" },
    { 0x107, "Thresholding" },
    { 0x108, "CellWidth" },
    { 0x109, "CellLength" },
    { 0x10a, "FillOrder" },
    { 0x10d, "DocumentName" },
    { 0x10e, "ImageDescription" },
    { 0x10f, "Make" },
    { 0x110, "Model" },
    { 0x111, "StripOffsets" },
    { 0x112, "Orientation" },
    { 0x115, "SamplesPerPixel" },
    { 0x116, "RowsPerStrip" },
    { 0x117, "StripByteCounts" },
    { 0x118, "MinSampleValue" },
    { 0x119, "MaxSampleValue" },
    { 0x11a, "XResolution" },
    { 0x11b, "YResolution" },
    { 0x11c, "PlanarConfiguration" },
    { 0x11d, "PageName" },
    { 0x11e, "XPosition" },
    { 0x11f, "YPosition" },
    { 0x120, "FreeOffsets" },
    { 0x121, "FreeByteCounts" },
    { 0x122, "GrayResponseUnit" },
    { 0x123, "GrayResponseCurve" },
    { 0x124, "T4Options" },
    { 0x125, "T6Options" },
    { 0x128, "ResolutionUnit" },
    { 0x129, "PageNumber" },
    { 0x12c, "ColorResponseUnit" },
    { 0x12d, "TransferFunction" },
    { 0x131, "Software" },
    { 0x132, "ModifyDate" },
    { 0x13b, "Artist" },
    { 0x13c, "HostComputer" },
    { 0x13d, "Predictor" },
    { 0x13e, "WhitePoint" },
    { 0x13f, "PrimaryChromaticities" },
    { 0x140, "ColorMap" },
    { 0x141, "HalftoneHints" },
    { 0x142, "TileWidth" },
    { 0x143, "TileLength" },
    { 0x144, "TileOffsets" },
    { 0x145, "TileByteCounts" },
    { 0x146, "BadFaxLines" },
    { 0x147, "CleanFaxData" },
    { 0x148, "ConsecutiveBadFaxLines" },
    { 0x14a, "SubIFD" },
    { 0x14c, "InkSet" },
    { 0x14d, "InkNames" },
    { 0x14e, "NumberofInks" },
    { 0x150, "DotRange" },
    { 0x151, "TargetPrinter" },
    { 0x152, "ExtraSamples" },
    { 0x153, "SampleFormat" },
    { 0x154, "SMinSampleValue" },
    { 0x155, "SMaxSampleValue" },
    { 0x156, "TransferRange" },
    { 0x157, "ClipPath" },
    { 0x158, "XClipPathUnits" },
    { 0x159, "YClipPathUnits" },
    { 0x15a, "Indexed" },
    { 0x15b, "JPEGTables" },
    { 0x15f, "OPIProxy" },
    { 0x190, "GlobalParametersIFD" },
    { 0x191, "ProfileType" },
    { 0x192, "FaxProfile" },
    { 0x193, "CodingMethods" },
    { 0x194, "VersionYear" },
    { 0x195, "ModeNumber" },
    { 0x1b1, "Decode" },
    { 0x1b2, "DefaultImageColor" },
    { 0x1b3, "T82Options" },
    { 0x1b5, "JPEGTables" },
    { 0x200, "JPEGProc" },
    { 0x201, "ThumbnailOffset" },
    { 0x202, "ThumbnailLength" },
    { 0x203, "JPEGRestartInterval" },
    { 0x205, "JPEGLosslessPredictors" },
    { 0x206, "JPEGPointTransforms" },
    { 0x207, "JPEGQTables" },
    { 0x208, "JPEGDCTables" },
    { 0x209, "JPEGACTables" },
    { 0x211, "YCbCrCoefficients" },
    { 0x212, "YCbCrSubSampling" },
    { 0x213, "YCbCrPositioning" },
    { 0x214, "ReferenceBlackWhite" },
    { 0x22f, "StripRowCounts" },
    { 0x2bc, "ApplicationNotes" },
    { 0x3e7, "USPTOMiscellaneous" },
    { 0x1000, "RelatedImageFileFormat" },
    { 0x1001, "RelatedImageWidth" },
    { 0x1002, "RelatedImageHeight" },
    { 0x4746, "Rating" },
    { 0x4747, "XP_DIP_XML" },
    { 0x4748, "StitchInfo" },
    { 0x4749, "RatingPercent" },
    { 0x7000, "SonyRawFileType" },
    { 0x7010, "SonyToneCurve" },
    { 0x7031, "VignettingCorrection" },
    { 0x7032, "VignettingCorrParams" },
    { 0x7034, "ChromaticAberrationCorrection" },
    { 0x7035, "ChromaticAberrationCorrParams" },
    { 0x7036, "DistortionCorrection" },
    { 0x7037, "DistortionCorrParams" },
    { 0x74c7, "SonyCropTopLeft" },
    { 0x74c8, "SonyCropSize" },
    { 0x800d, "ImageID" },
    { 0x80a3, "WangTag1" },
    { 0x80a4, "WangAnnotation" },
    { 0x80a5, "WangTag3" },
    { 0x80a6, "WangTag4" },
    { 0x80b9, "ImageReferencePoints" },
    { 0x80ba, "RegionXformTackPoint" },
    { 0x80bb, "WarpQuadrilateral" },
    { 0x80bc, "AffineTransformMat" },
    { 0x80e3, "Matteing" },
    { 0x80e4, "DataType" },
    { 0x80e5, "ImageDepth" },
    { 0x80e6, "TileDepth" },
    { 0x8214, "ImageFullWidth" },
    { 0x8215, "ImageFullHeight" },
    { 0x8216, "TextureFormat" },
    { 0x8217, "WrapModes" },
    { 0x8218, "FovCot" },
    { 0x8219, "MatrixWorldToScreen" },
    { 0x821a, "MatrixWorldToCamera" },
    { 0x827d, "Model2" },
    { 0x828d, "CFARepeatPatternDim" },
    { 0x828e, "CFAPattern2" },
    { 0x828f, "BatteryLevel" },
    { 0x8290, "KodakIFD" },
    { 0x8298, "Copyright" },
    { 0x829a, "ExposureTime" },
    { 0x829d, "FNumber" },
    { 0x82a5, "MDFileTag" },
    { 0x82a6, "MDScalePixel" },
    { 0x82a7, "MDColorTable" },
    { 0x82a8, "MDLabName" },
    { 0x82a9, "MDSampleInfo" },
    { 0x82aa, "MDPrepDate" },
    { 0x82ab, "MDPrepTime" },
    { 0x82ac, "MDFileUnits" },
    { 0x830e, "PixelScale" },
    { 0x8335, "AdventScale" },
    { 0x8336, "AdventRevision" },
    { 0x835c, "UIC1Tag" },
    { 0x835d, "UIC2Tag" },
    { 0x835e, "UIC3Tag" },
    { 0x835f, "UIC4Tag" },
    { 0x83bb, "IPTC-NAA" },
    { 0x847e, "IntergraphPacketData" },
    { 0x847f, "IntergraphFlagRegisters" },
    { 0x8480, "IntergraphMatrix" },
    { 0x8481, "INGRReserved" },
    { 0x8482, "ModelTiePoint" },
    { 0x84e0, "Site" },
    { 0x84e1, "ColorSequence" },
    { 0x84e2, "IT8Header" },
    { 0x84e3, "RasterPadding" },
    { 0x84e4, "BitsPerRunLength" },
    { 0x84e5, "BitsPerExtendedRunLength" },
    { 0x84e6, "ColorTable" },
    { 0x84e7, "ImageColorIndicator" },
    { 0x84e8, "BackgroundColorIndicator" },
    { 0x84e9, "ImageColorValue" },
    { 0x84ea, "BackgroundColorValue" },
    { 0x84eb, "PixelIntensityRange" },
    { 0x84ec, "TransparencyIndicator" },
    { 0x84ed, "ColorCharacterization" },
    { 0x84ee, "HCUsage" },
    { 0x84ef, "TrapIndicator" },
    { 0x84f0, "CMYKEquivalent" },
    { 0x8546, "SEMInfo" },
    { 0x8568, "AFCP_IPTC" },
    { 0x85b8, "PixelMagicJBIGOptions" },
    { 0x85d7, "JPLCartoIFD" },
    { 0x85d8, "ModelTransform" },
    { 0x8602, "WB_GRGBLevels" },
    { 0x8606, "LeafData" },
    { 0x8649, "PhotoshopSettings" },
    { 0x8769, "ExifOffset" },
    { 0x8773, "ICC_Profile" },
    { 0x877f, "TIFF_FXExtensions" },
    { 0x8780, "MultiProfiles" },
    { 0x8781, "SharedData" },
    { 0x8782, "T88Options" },
    { 0x87ac, "ImageLayer" },
    { 0x87af, "GeoTiffDirectory" },
    { 0x87b0, "GeoTiffDoubleParams" },
    { 0x87b1, "GeoTiffAsciiParams" },
    { 0x87be, "JBIGOptions" },
    { 0x8822, "ExposureProgram" },
    { 0x8824, "SpectralSensitivity" },
    { 0x8825, "GPSInfo" },
    { 0x8827, "ISO" },
    { 0x8828, "Opto-ElectricConvFactor" },
    { 0x8829, "Interlace" },
    { 0x882a, "TimeZoneOffset" },
    { 0x882b, "SelfTimerMode" },
    { 0x8830, "SensitivityType" },
    { 0x8831, "StandardOutputSensitivity" },
    { 0x8832, "RecommendedExposureIndex" },
    { 0x8833, "ISOSpeed" },
    { 0x8834, "ISOSpeedLatitudeyyy" },
    { 0x8835, "ISOSpeedLatitudezzz" },
    { 0x885c, "FaxRecvParams" },
    { 0x885d, "FaxSubAddress" },
    { 0x885e, "FaxRecvTime" },
    { 0x8871, "FedexEDR" },
    { 0x888a, "LeafSubIFD" },
    { 0x9000, "ExifVersion" },
    { 0x9003, "DateTimeOriginal" },
    { 0x9004, "CreateDate" },
    { 0x9009, "GooglePlusUploadCode" },
    { 0x9010, "OffsetTime" },
    { 0x9011, "OffsetTimeOriginal" },
    { 0x9012, "OffsetTimeDigitized" },
    { 0x9101, "ComponentsConfiguration" },
    { 0x9102, "CompressedBitsPerPixel" },
    { 0x9201, "ShutterSpeedValue" },
    { 0x9202, "ApertureValue" },
    { 0x9203, "BrightnessValue" },
    { 0x9204, "ExposureCompensation" },
    { 0x9205, "MaxApertureValue" },
    { 0x9206, "SubjectDistance" },
    { 0x9207, "MeteringMode" },
    { 0x9208, "LightSource" },
    { 0x9209, "Flash" },
    { 0x920a, "FocalLength" },
    { 0x920b, "FlashEnergy" },
    { 0x920c, "SpatialFrequencyResponse" },
    { 0x920d, "Noise" },
    { 0x920e, "FocalPlaneXResolution" },
    { 0x920f, "FocalPlaneYResolution" },
    { 0x9210, "FocalPlaneResolutionUnit" },
    { 0x9211, "ImageNumber" },
    { 0x9212, "SecurityClassification" },
    { 0x9213, "ImageHistory" },
    { 0x9214, "SubjectArea" },
    { 0x9215, "ExposureIndex" },
    { 0x9216, "TIFF-EPStandardID" },
    { 0x9217, "SensingMethod" },
    { 0x923a, "CIP3DataFile" },
    { 0x923b, "CIP3Sheet" },
    { 0x923c, "CIP3Side" },
    { 0x923f, "StoNits" },
    { 0x927c, "MakerNoteApple" },
    { 0x9286, "UserComment" },
    { 0x9290, "SubSecTime" },
    { 0x9291, "SubSecTimeOriginal" },
    { 0x9292, "SubSecTimeDigitized" },
    { 0x932f, "MSDocumentText" },
    { 0x9330, "MSPropertySetStorage" },
    { 0x9331, "MSDocumentTextPosition" },
    { 0x935c, "ImageSourceData" },
    { 0x9400, "AmbientTemperature" },
    { 0x9401, "Humidity" },
    { 0x9402, "Pressure" },
    { 0x9403, "WaterDepth" },
    { 0x9404, "Acceleration" },
    { 0x9405, "CameraElevationAngle" },
    { 0x9c9b, "XPTitle" },
    { 0x9c9c, "XPComment" },
    { 0x9c9d, "XPAuthor" },
    { 0x9c9e, "XPKeywords" },
    { 0x9c9f, "XPSubject" },
    { 0xa000, "FlashpixVersion" },
    { 0xa001, "ColorSpace" },
    { 0xa002, "ExifImageWidth" },
    { 0xa003, "ExifImageHeight" },
    { 0xa004, "RelatedSoundFile" },
    { 0xa005, "InteropOffset" },
    { 0xa010, "SamsungRawPointersOffset" },
    { 0xa011, "SamsungRawPointersLength" },
    { 0xa101, "SamsungRawByteOrder" },
    { 0xa102, "SamsungRawUnknown" },
    { 0xa20b, "FlashEnergy" },
    { 0xa20c, "SpatialFrequencyResponse" },
    { 0xa20d, "Noise" },
    { 0xa20e, "FocalPlaneXResolution" },
    { 0xa20f, "FocalPlaneYResolution" },
    { 0xa210, "FocalPlaneResolutionUnit" },
    { 0xa211, "ImageNumber" },
    { 0xa212, "SecurityClassification" },
    { 0xa213, "ImageHistory" },
    { 0xa214, "SubjectLocation" },
    { 0xa215, "ExposureIndex" },
    { 0xa216, "TIFF-EPStandardID" },
    { 0xa217, "SensingMethod" },
    { 0xa300, "FileSource" },
    { 0xa301, "SceneType" },
    { 0xa302, "CFAPattern" },
    { 0xa401, "CustomRendered" },
    { 0xa402, "ExposureMode" },
    { 0xa403, "WhiteBalance" },
    { 0xa404, "DigitalZoomRatio" },
    { 0xa405, "FocalLengthIn35mmFormat" },
    { 0xa406, "SceneCaptureType" },
    { 0xa407, "GainControl" },
    { 0xa408, "Contrast" },
    { 0xa409, "Saturation" },
    { 0xa40a, "Sharpness" },
    { 0xa40b, "DeviceSettingDescription" },
    { 0xa40c, "SubjectDistanceRange" },
    { 0xa420, "ImageUniqueID" },
    { 0xa430, "OwnerName" },
    { 0xa431, "SerialNumber" },
    { 0xa432, "LensInfo" },
    { 0xa433, "LensMake" },
    { 0xa434, "LensModel" },
    { 0xa435, "LensSerialNumber" },
    { 0xa460, "CompositeImage" },
    { 0xa461, "CompositeImageCount" },
    { 0xa462, "CompositeImageExposureTimes" },
    { 0xa480, "GDALMetadata" },
    { 0xa481, "GDALNoData" },
    { 0xa500, "Gamma" },
    { 0xafc0, "ExpandSoftware" },
    { 0xafc1, "ExpandLens" },
    { 0xafc2, "ExpandFilm" },
    { 0xafc3, "ExpandFilterLens" },
    { 0xafc4, "ExpandScanner" },
    { 0xafc5, "ExpandFlashLamp" },
    { 0xb4c3, "HasselbladRawImage" },
    { 0xbc01, "PixelFormat" },
    { 0xbc02, "Transformation" },
    { 0xbc03, "Uncompressed" },
    { 0xbc04, "ImageType" },
    { 0xbc80, "ImageWidth" },
    { 0xbc81, "ImageHeight" },
    { 0xbc82, "WidthResolution" },
    { 0xbc83, "HeightResolution" },
    { 0xbcc0, "ImageOffset" },
    { 0xbcc1, "ImageByteCount" },
    { 0xbcc2, "AlphaOffset" },
    { 0xbcc3, "AlphaByteCount" },
    { 0xbcc4, "ImageDataDiscard" },
    { 0xbcc5, "AlphaDataDiscard" },
    { 0xc427, "OceScanjobDesc" },
    { 0xc428, "OceApplicationSelector" },
    { 0xc429, "OceIDNumber" },
    { 0xc42a, "OceImageLogic" },
    { 0xc44f, "Annotations" },
    { 0xc4a5, "PrintIM" },
    { 0xc51b, "HasselbladExif" },
    { 0xc573, "OriginalFileName" },
    { 0xc580, "USPTOOriginalContentType" },
    { 0xc5e0, "CR2CFAPattern" },
    { 0xc612, "DNGVersion" },
    { 0xc613, "DNGBackwardVersion" },
    { 0xc614, "UniqueCameraModel" },
    { 0xc615, "LocalizedCameraModel" },
    { 0xc616, "CFAPlaneColor" },
    { 0xc617, "CFALayout" },
    { 0xc618, "LinearizationTable" },
    { 0xc619, "BlackLevelRepeatDim" },
    { 0xc61a, "BlackLevel" },
    { 0xc61b, "BlackLevelDeltaH" },
    { 0xc61c, "BlackLevelDeltaV" },
    { 0xc61d, "WhiteLevel" },
    { 0xc61e, "DefaultScale" },
    { 0xc61f, "DefaultCropOrigin" },
    { 0xc620, "DefaultCropSize" },
    { 0xc621, "ColorMatrix1" },
    { 0xc622, "ColorMatrix2" },
    { 0xc623, "CameraCalibration1" },
    { 0xc624, "CameraCalibration2" },
    { 0xc625, "ReductionMatrix1" },
    { 0xc626, "ReductionMatrix2" },
    { 0xc627, "AnalogBalance" },
    { 0xc628, "AsShotNeutral" },
    { 0xc629, "AsShotWhiteXY" },
    { 0xc62a, "BaselineExposure" },
    { 0xc62b, "BaselineNoise" },
    { 0xc62c, "BaselineSharpness" },
    { 0xc62d, "BayerGreenSplit" },
    { 0xc62e, "LinearResponseLimit" },
    { 0xc62f, "CameraSerialNumber" },
    { 0xc630, "DNGLensInfo" },
    { 0xc631, "ChromaBlurRadius" },
    { 0xc632, "AntiAliasStrength" },
    { 0xc633, "ShadowScale" },
    { 0xc634, "SR2Private" },
    { 0xc635, "MakerNoteSafety" },
    { 0xc640, "RawImageSegmentation" },
    { 0xc65a, "CalibrationIlluminant1" },
    { 0xc65b, "CalibrationIlluminant2" },
    { 0xc65c, "BestQualityScale" },
    { 0xc65d, "RawDataUniqueID" },
    { 0xc660, "AliasLayerMetadata" },
    { 0xc68b, "OriginalRawFileName" },
    { 0xc68c, "OriginalRawFileData" },
    { 0xc68d, "ActiveArea" },
    { 0xc68e, "MaskedAreas" },
    { 0xc68f, "AsShotICCProfile" },
    { 0xc690, "AsShotPreProfileMatrix" },
    { 0xc691, "CurrentICCProfile" },
    { 0xc692, "CurrentPreProfileMatrix" },
    { 0xc6bf, "ColorimetricReference" },
    { 0xc6c5, "SRawType" },
    { 0xc6d2, "PanasonicTitle" },
    { 0xc6d3, "PanasonicTitle2" },
    { 0xc6f3, "CameraCalibrationSig" },
    { 0xc6f4, "ProfileCalibrationSig" },
    { 0xc6f5, "ProfileIFD" },
    { 0xc6f6, "AsShotProfileName" },
    { 0xc6f7, "NoiseReductionApplied" },
    { 0xc6f8, "ProfileName" },
    { 0xc6f9, "ProfileHueSatMapDims" },
    { 0xc6fa, "ProfileHueSatMapData1" },
    { 0xc6fb, "ProfileHueSatMapData2" },
    { 0xc6fc, "ProfileToneCurve" },
    { 0xc6fd, "ProfileEmbedPolicy" },
    { 0xc6fe, "ProfileCopyright" },
    { 0xc714, "ForwardMatrix1" },
    { 0xc715, "ForwardMatrix2" },
    { 0xc716, "PreviewApplicationName" },
    { 0xc717, "PreviewApplicationVersion" },
    { 0xc718, "PreviewSettingsName" },
    { 0xc719, "PreviewSettingsDigest" },
    { 0xc71a, "PreviewColorSpace" },
    { 0xc71b, "PreviewDateTime" },
    { 0xc71c, "RawImageDigest" },
    { 0xc71d, "OriginalRawFileDigest" },
    { 0xc71e, "SubTileBlockSize" },
    { 0xc71f, "RowInterleaveFactor" },
    { 0xc725, "ProfileLookTableDims" },
    { 0xc726, "ProfileLookTableData" },
    { 0xc740, "OpcodeList1" },
    { 0xc741, "OpcodeList2" },
    { 0xc74e, "OpcodeList3" },
    { 0xc761, "NoiseProfile" },
    { 0xc763, "TimeCodes" },
    { 0xc764, "FrameRate" },
    { 0xc772, "TStop" },
    { 0xc789, "ReelName" },
    { 0xc791, "OriginalDefaultFinalSize" },
    { 0xc792, "OriginalBestQualitySize" },
    { 0xc793, "OriginalDefaultCropSize" },
    { 0xc7a1, "CameraLabel" },
    { 0xc7a3, "ProfileHueSatMapEncoding" },
    { 0xc7a4, "ProfileLookTableEncoding" },
    { 0xc7a5, "BaselineExposureOffset" },
    { 0xc7a6, "DefaultBlackRender" },
    { 0xc7a7, "NewRawImageDigest" },
    { 0xc7a8, "RawToPreviewGain" },
    { 0xc7aa, "CacheVersion" },
    { 0xc7b5, "DefaultUserCrop" },
    { 0xc7d5, "NikonNEFInfo" },
    { 0xc7e9, "DepthFormat" },
    { 0xc7ea, "DepthNear" },
    { 0xc7eb, "DepthFar" },
    { 0xc7ec, "DepthUnits" },
    { 0xc7ed, "DepthMeasureType" },
    { 0xc7ee, "EnhanceParams" },
    { 0xcd2d, "ProfileGainTableMap" },
    { 0xcd2e, "SemanticName" },
    { 0xcd30, "SemanticInstanceID" },
    { 0xcd31, "CalibrationIlluminant3" },
    { 0xcd32, "CameraCalibration3" },
    { 0xcd33, "ColorMatrix3" },
    { 0xcd34, "ForwardMatrix3" },
    { 0xcd35, "IlluminantData1" },
    { 0xcd36, "IlluminantData2" },
    { 0xcd37, "IlluminantData3" },
    { 0xcd38, "MaskSubArea" },
    { 0xcd39, "ProfileHueSatMapData3" },
    { 0xcd3a, "ReductionMatrix3" },
    { 0xcd3b, "RGBTables" },
    { 0xea1c, "Padding" },
    { 0xea1d, "OffsetSchema" },
    { 0xfde8, "OwnerName" },
    { 0xfde9, "SerialNumber" },
    { 0xfdea, "Lens" },
    { 0xfe00, "KDC_IFD" },
    { 0xfe4c, "RawFile" },
    { 0xfe4d, "Converter" },
    { 0xfe4e, "WhiteBalance" },
    { 0xfe51, "Exposure" },
    { 0xfe52, "Shadows" },
    { 0xfe53, "Brightness" },
    { 0xfe54, "Contrast" },
    { 0xfe55, "Saturation" },
    { 0xfe56, "Sharpness" },
    { 0xfe57, "Smoothness" },
    { 0xfe58, "MoireFilter" },
};

const TagTable mnote_apple_tag_names = {
    { 0x3, "RunTime" },
    { 0x8, "AccelerationVector" },
    { 0xa, "HDRImageType" },
    { 0xb, "BurstUUID" },
    { 0xc, "FocusDistanceRange" },
    { 0x11, "MediaGroupUUID" },
    { 0x15, "ImageUniqueID" },
    { 0x17, "LivePhotoVideoIndex" },
};

const TagTable mnote_canon_tag_names = {
    { 0x1, "CanonCameraSettings" },
    { 0x2, "CanonFocalLength" },
    { 0x3, "CanonFlashInfo" },
    { 0x4, "CanonShotInfo" },
    { 0x5, "CanonPanorama" },
    { 0x6, "CanonImageType" },
    { 0x7, "CanonFirmwareVersion" },
    { 0x8, "FileNumber" },
    { 0x9, "OwnerName" },
    { 0xa, "UnknownD30" },
    { 0xc, "SerialNumber" },
    { 0xd, "CanonCameraInfo1D" },
    { 0xe, "CanonFileLength" },
    { 0xf, "CustomFunctions1D" },
    { 0x10, "CanonModelID" },
    { 0x11, "MovieInfo" },
    { 0x12, "CanonAFInfo" },
    { 0x13, "ThumbnailImageValidArea" },
    { 0x15, "SerialNumberFormat" },
    { 0x1a, "SuperMacro" },
    { 0x1c, "DateStampMode" },
    { 0x1d, "MyColors" },
    { 0x1e, "FirmwareRevision" },
    { 0x23, "Categories" },
    { 0x24, "FaceDetect1" },
    { 0x25, "FaceDetect2" },
    { 0x26, "CanonAFInfo2" },
    { 0x27, "ContrastInfo" },
    { 0x28, "ImageUniqueID" },
    { 0x29, "WBInfo" },
    { 0x2f, "FaceDetect3" },
    { 0x35, "TimeInfo" },
    { 0x38, "BatteryType" },
    { 0x3c, "AFInfo3" },
    { 0x81, "RawDataOffset" },
    { 0x83, "OriginalDecisionDataOffset" },
    { 0x90, "CustomFunctions1D" },
    { 0x91, "PersonalFunctions" },
    { 0x92, "PersonalFunctionValues" },
    { 0x93, "CanonFileInfo" },
    { 0x94, "AFPointsInFocus1D" },
    { 0x95, "LensModel" },
    { 0x96, "SerialInfo" },
    { 0x97, "DustRemovalData" },
    { 0x98, "CropInfo" },
    { 0x99, "CustomFunctions2" },
    { 0x9a, "AspectInfo" },
    { 0xa0, "ProcessingInfo" },
    { 0xa1, "ToneCurveTable" },
    { 0xa2, "SharpnessTable" },
    { 0xa3, "SharpnessFreqTable" },
    { 0xa4, "WhiteBalanceTable" },
    { 0xa9, "ColorBalance" },
    { 0xaa, "MeasuredColor" },
    { 0xae, "ColorTemperature" },
    { 0xb0, "CanonFlags" },
    { 0xb1, "ModifiedInfo" },
    { 0xb2, "ToneCurveMatching" },
    { 0xb3, "WhiteBalanceMatching" },
    { 0xb4, "ColorSpace" },
    { 0xb6, "PreviewImageInfo" },
    { 0xd0, "VRDOffset" },
    { 0xe0, "SensorInfo" },
    { 0x4001, "ColorData1" },
    { 0x4002, "CRWParam" },
    { 0x4003, "ColorInfo" },
    { 0x4005, "Flavor" },
    { 0x4008, "PictureStyleUserDef" },
    { 0x4009, "PictureStylePC" },
    { 0x4010, "CustomPictureStyleFileName" },
    { 0x4013, "AFMicroAdj" },
    { 0x4015, "VignettingCorr" },
    { 0x4016, "VignettingCorr2" },
    { 0x4018, "LightingOpt" },
    { 0x4019, "LensInfo" },
    { 0x4020, "AmbienceInfo" },
    { 0x4021, "MultiExp" },
    { 0x4024, "FilterInfo" },
    { 0x4025, "HDRInfo" },
    { 0x4026, "LogInfo" },
    { 0x4028, "AFConfig" },
    { 0x403f, "RawBurstModeRoll" },
};

const TagTable mnote_fujifilm_tag_names = {
    { 0x0, "Version" },
    { 0x10, "InternalSerialNumber" },
    { 0x1000, "Quality" },
    { 0x1001, "Sharpness" },
    { 0x1002, "WhiteBalance" },
    { 0x1003, "Saturation" },
    { 0x1004, "Contrast" },
    { 0x1005, "ColorTemperature" },
    { 0x1006, "Contrast" },
    { 0x100a, "WhiteBalanceFineTune" },
    { 0x100b, "NoiseReduction" },
    { 0x100e, "NoiseReduction" },
    { 0x100f, "Clarity" },
    { 0x1010, "FujiFlashMode" },
    { 0x1011, "FlashExposureComp" },
    { 0x1020, "Macro" },
    { 0x1021, "FocusMode" },
    { 0x1022, "AFMode" },
    { 0x1023, "FocusPixel" },
    { 0x102b, "PrioritySettings" },
    { 0x102d, "FocusSettings" },
    { 0x102e, "AFCSettings" },
    { 0x1030, "SlowSync" },
    { 0x1031, "PictureMode" },
    { 0x1032, "ExposureCount" },
    { 0x1033, "EXRAuto" },
    { 0x1034, "EXRMode" },
    { 0x1040, "ShadowTone" },
    { 0x1041, "HighlightTone" },
    { 0x1044, "DigitalZoom" },
    { 0x1045, "LensModulationOptimizer" },
    { 0x1047, "GrainEffectRoughness" },
    { 0x1048, "ColorChromeEffect" },
    { 0x1049, "BWAdjustment" },
    { 0x104c, "GrainEffectSize" },
    { 0x104d, "CropMode" },
    { 0x104e, "ColorChromeFXBlue" },
    { 0x1050, "ShutterType" },
    { 0x1100, "AutoBracketing" },
    { 0x1101, "SequenceNumber" },
    { 0x1103, "DriveSettings" },
    { 0x1105, "PixelShiftShots" },
    { 0x1106, "PixelShiftOffset" },
    { 0x1153, "PanoramaAngle" },
    { 0x1154, "PanoramaDirection" },
    { 0x1201, "AdvancedFilter" },
    { 0x1210, "ColorMode" },
    { 0x1300, "BlurWarning" },
    { 0x1301, "FocusWarning" },
    { 0x1302, "ExposureWarning" },
    { 0x1304, "GEImageSize" },
    { 0x1400, "DynamicRange" },
    { 0x1401, "FilmMode" },
    { 0x1402, "DynamicRangeSetting" },
    { 0x1403, "DevelopmentDynamicRange" },
    { 0x1404, "MinFocalLength" },
    { 0x1405, "MaxFocalLength" },
    { 0x1406, "MaxApertureAtMinFocal" },
    { 0x1407, "MaxApertureAtMaxFocal" },
    { 0x140b, "AutoDynamicRange" },
    { 0x1422, "ImageStabilization" },
    { 0x1425, "SceneRecognition" },
    { 0x1431, "Rating" },
    { 0x1436, "ImageGeneration" },
    { 0x1438, "ImageCount" },
    { 0x1443, "DRangePriority" },
    { 0x1444, "DRangePriorityAuto" },
    { 0x1445, "DRangePriorityFixed" },
    { 0x1446, "FlickerReduction" },
    { 0x1447, "FujiModel" },
    { 0x1448, "FujiModel2" },
    { 0x3803, "VideoRecordingMode" },
    { 0x3804, "PeripheralLighting" },
    { 0x3806, "VideoCompression" },
    { 0x3820, "FrameRate" },
    { 0x3821, "FrameWidth" },
    { 0x3822, "FrameHeight" },
    { 0x3824, "FullHDHighSpeedRec" },
    { 0x4005, "FaceElementSelected" },
    { 0x4100, "FacesDetected" },
    { 0x4103, "FacePositions" },
    { 0x4200, "NumFaceElements" },
    { 0x4201, "FaceElementTypes" },
    { 0x4203, "FaceElementPositions" },
    { 0x4282, "FaceRecInfo" },
    { 0x8000, "FileSource" },
    { 0x8002, "OrderNumber" },
    { 0x8003, "FrameNumber" },
    { 0xb211, "Parallax" },
};

const TagTable mnote_minolta_tag_names = {
    { 0x0, "MakerNoteVersion" },
    { 0x1, "MinoltaCameraSettingsOld" },
    { 0x3, "MinoltaCameraSettings" },
    { 0x4, "MinoltaCameraSettings7D" },
    { 0x10, "CameraInfoA100" },
    { 0x18, "ISInfoA100" },
    { 0x20, "WBInfoA100" },
    { 0x40, "CompressedImageSize" },
    { 0x81, "PreviewImage" },
    { 0x88, "PreviewImageStart" },
    { 0x89, "PreviewImageLength" },
    { 0x100, "SceneMode" },
    { 0x101, "ColorMode" },
    { 0x102, "MinoltaQuality" },
    { 0x103, "MinoltaQuality" },
    { 0x104, "FlashExposureComp" },
    { 0x105, "Teleconverter" },
    { 0x107, "ImageStabilization" },
    { 0x109, "RawAndJpgRecording" },
    { 0x10a, "ZoneMatching" },
    { 0x10b, "ColorTemperature" },
    { 0x10c, "LensType" },
    { 0x111, "ColorCompensationFilter" },
    { 0x112, "WhiteBalanceFineTune" },
    { 0x113, "ImageStabilization" },
    { 0x114, "MinoltaCameraSettings5D" },
    { 0x115, "WhiteBalance" },
    { 0xe00, "PrintIM" },
    { 0xf00, "MinoltaCameraSettings2" },
};

const TagTable mnote_nikon_tag_names = {
    { 0x1, "MakerNoteVersion" },
    { 0x2, "ISO" },
    { 0x3, "ColorMode" },
    { 0x4, "Quality" },
    { 0x5, "WhiteBalance" },
    { 0x6, "Sharpness" },
    { 0x7, "FocusMode" },
    { 0x8, "FlashSetting" },
    { 0x9, "FlashType" },
    { 0xb, "WhiteBalanceFineTune" },
    { 0xc, "WB_RBLevels" },
    { 0xd, "ProgramShift" },
    { 0xe, "ExposureDifference" },
    { 0xf, "ISOSelection" },
    { 0x10, "DataDump" },
    { 0x11, "PreviewIFD" },
    { 0x12, "FlashExposureComp" },
    { 0x13, "ISOSetting" },
    { 0x14, "ColorBalanceA" },
    { 0x16, "ImageBoundary" },
    { 0x17, "ExternalFlashExposureComp" },
    { 0x18, "FlashExposureBracketValue" },
    { 0x19, "ExposureBracketValue" },
    { 0x1a, "ImageProcessing" },
    { 0x1b, "CropHiSpeed" },
    { 0x1c, "ExposureTuning" },
    { 0x1d, "SerialNumber" },
    { 0x1e, "ColorSpace" },
    { 0x1f, "VRInfo" },
    { 0x20, "ImageAuthentication" },
    { 0x21, "FaceDetect" },
    { 0x22, "ActiveD-Lighting" },
    { 0x23, "PictureControlData" },
    { 0x24, "WorldTime" },
    { 0x25, "ISOInfo" },
    { 0x2a, "VignetteControl" },
    { 0x2b, "DistortInfo" },
    { 0x2c, "UnknownInfo" },
    { 0x32, "UnknownInfo2" },
    { 0x34, "ShutterMode" },
    { 0x35, "HDRInfo" },
    { 0x37, "MechanicalShutterCount" },
    { 0x39, "LocationInfo" },
    { 0x3d, "BlackLevel" },
    { 0x3e, "ImageSizeRAW" },
    { 0x3f, "WhiteBalanceFineTune" },
    { 0x45, "CropArea" },
    { 0x4e, "NikonSettings" },
    { 0x4f, "ColorTemperatureAuto" },
    { 0x51, "MakerNotes0x51" },
    { 0x80, "ImageAdjustment" },
    { 0x81, "ToneComp" },
    { 0x82, "AuxiliaryLens" },
    { 0x83, "LensType" },
    { 0x84, "Lens" },
    { 0x85, "ManualFocusDistance" },
    { 0x86, "DigitalZoom" },
    { 0x87, "FlashMode" },
    { 0x88, "AFInfo" },
    { 0x89, "ShootingMode" },
    { 0x8b, "LensFStops" },
    { 0x8c, "ContrastCurve" },
    { 0x8d, "ColorHue" },
    { 0x8f, "SceneMode" },
    { 0x90, "LightSource" },
    { 0x91, "ShotInfoD40" },
    { 0x92, "HueAdjustment" },
    { 0x93, "NEFCompression" },
    { 0x94, "SaturationAdj" },
    { 0x95, "NoiseReduction" },
    { 0x96, "NEFLinearizationTable" },
    { 0x97, "ColorBalance0100" },
    { 0x98, "LensData0100" },
    { 0x99, "RawImageCenter" },
    { 0x9a, "SensorPixelSize" },
    { 0x9c, "SceneAssist" },
    { 0x9d, "DateStampMode" },
    { 0x9e, "RetouchHistory" },
    { 0xa0, "SerialNumber" },
    { 0xa2, "ImageDataSize" },
    { 0xa5, "ImageCount" },
    { 0xa6, "DeletedImageCount" },
    { 0xa7, "ShutterCount" },
    { 0xa8, "FlashInfo0100" },
    { 0xa9, "ImageOptimization" },
    { 0xaa, "Saturation" },
    { 0xab, "VariProgram" },
    { 0xac, "ImageStabilization" },
    { 0xad, "AFResponse" },
    { 0xb0, "MultiExposure" },
    { 0xb1, "HighISONoiseReduction" },
    { 0xb3, "ToningEffect" },
    { 0xb6, "PowerUpTime" },
    { 0xb7, "AFInfo2" },
    { 0xb8, "FileInfo" },
    { 0xb9, "AFTune" },
    { 0xbb, "RetouchInfo" },
    { 0xbd, "PictureControlData" },
    { 0xbf, "SilentPhotography" },
    { 0xc3, "BarometerInfo" },
    { 0xe00, "PrintIM" },
    { 0xe01, "NikonCaptureData" },
    { 0xe09, "NikonCaptureVersion" },
    { 0xe0e, "NikonCaptureOffsets" },
    { 0xe10, "NikonScanIFD" },
    { 0xe13, "NikonCaptureEditVersions" },
    { 0xe1d, "NikonICCProfile" },
    { 0xe1e, "NikonCaptureOutput" },
    { 0xe22, "NEFBitDepth" },
};

const TagTable mnote_nikon2_tag_names = {
    { 0x3, "Quality" },
    { 0x4, "ColorMode" },
    { 0x5, "ImageAdjustment" },
    { 0x6, "CCDSensitivity" },
    { 0x7, "WhiteBalance" },
    { 0x8, "Focus" },
    { 0xa, "DigitalZoom" },
    { 0xb, "Converter" },
};

const TagTable mnote_olympus_tag_names = {
    { 0x0, "MakerNoteVersion" },
    { 0x1, "MinoltaCameraSettingsOld" },
    { 0x3, "MinoltaCameraSettings" },
    { 0x40, "CompressedImageSize" },
    { 0x81, "PreviewImageData" },
    { 0x88, "PreviewImageStart" },
    { 0x89, "PreviewImageLength" },
    { 0x100, "ThumbnailImage" },
    { 0x104, "BodyFirmwareVersion" },
    { 0x200, "SpecialMode" },
    { 0x201, "Quality" },
    { 0x202, "Macro" },
    { 0x203, "BWMode" },
    { 0x204, "DigitalZoom" },
    { 0x205, "FocalPlaneDiagonal" },
    { 0x206, "LensDistortionParams" },
    { 0x207, "CameraType" },
    { 0x208, "TextInfo" },
    { 0x209, "CameraID" },
    { 0x20b, "EpsonImageWidth" },
    { 0x20c, "EpsonImageHeight" },
    { 0x20d, "EpsonSoftware" },
    { 0x280, "PreviewImage" },
    { 0x300, "PreCaptureFrames" },
    { 0x301, "WhiteBoard" },
    { 0x302, "OneTouchWB" },
    { 0x303, "WhiteBalanceBracket" },
    { 0x304, "WhiteBalanceBias" },
    { 0x400, "SensorArea" },
    { 0x401, "BlackLevel" },
    { 0x403, "SceneMode" },
    { 0x404, "SerialNumber" },
    { 0x405, "Firmware" },
    { 0xe00, "PrintIM" },
    { 0xf00, "DataDump" },
    { 0xf01, "DataDump2" },
    { 0xf04, "ZoomedPreviewStart" },
    { 0xf05, "ZoomedPreviewLength" },
    { 0xf06, "ZoomedPreviewSize" },
    { 0x1000, "ShutterSpeedValue" },
    { 0x1001, "ISOValue" },
    { 0x1002, "ApertureValue" },
    { 0x1003, "BrightnessValue" },
    { 0x1004, "FlashMode" },
    { 0x1005, "FlashDevice" },
    { 0x1006, "ExposureCompensation" },
    { 0x1007, "SensorTemperature" },
    { 0x1008, "LensTemperature" },
    { 0x1009, "LightCondition" },
    { 0x100a, "FocusRange" },
    { 0x100b, "FocusMode" },
    { 0x100c, "ManualFocusDistance" },
    { 0x100d, "ZoomStepCount" },
    { 0x100e, "FocusStepCount" },
    { 0x100f, "Sharpness" },
    { 0x1010, "FlashChargeLevel" },
    { 0x1011, "ColorMatrix" },
    { 0x1012, "BlackLevel" },
    { 0x1013, "ColorTemperatureBG" },
    { 0x1014, "ColorTemperatureRG" },
    { 0x1015, "WBMode" },
    { 0x1017, "RedBalance" },
    { 0x1018, "BlueBalance" },
    { 0x1019, "ColorMatrixNumber" },
    { 0x101a, "SerialNumber" },
    { 0x101b, "ExternalFlashAE1_0" },
    { 0x101c, "ExternalFlashAE2_0" },
    { 0x101d, "InternalFlashAE1_0" },
    { 0x101e, "InternalFlashAE2_0" },
    { 0x101f, "ExternalFlashAE1" },
    { 0x1020, "ExternalFlashAE2" },
    { 0x1021, "InternalFlashAE1" },
    { 0x1022, "InternalFlashAE2" },
    { 0x1023, "FlashExposureComp" },
    { 0x1024, "InternalFlashTable" },
    { 0x1025, "ExternalFlashGValue" },
    { 0x1026, "ExternalFlashBounce" },
    { 0x1027, "ExternalFlashZoom" },
    { 0x1028, "ExternalFlashMode" },
    { 0x1029, "Contrast" },
    { 0x102a, "SharpnessFactor" },
    { 0x102b, "ColorControl" },
    { 0x102c, "ValidBits" },
    { 0x102d, "CoringFilter" },
    { 0x102e, "OlympusImageWidth" },
    { 0x102f, "OlympusImageHeight" },
    { 0x1030, "SceneDetect" },
    { 0x1031, "SceneArea" },
    { 0x1033, "SceneDetectData" },
    { 0x1034, "CompressionRatio" },
    { 0x1035, "PreviewImageValid" },
    { 0x1036, "PreviewImageStart" },
    { 0x1037, "PreviewImageLength" },
    { 0x1038, "AFResult" },
    { 0x1039, "CCDScanMode" },
    { 0x103a, "NoiseReduction" },
    { 0x103b, "FocusStepInfinity" },
    { 0x103c, "FocusStepNear" },
    { 0x103d, "LightValueCenter" },
    { 0x103e, "LightValuePeriphery" },
    { 0x103f, "FieldCount" },
    { 0x2010, "Equipment" },
    { 0x2020, "CameraSettings" },
    { 0x2030, "RawDevelopment" },
    { 0x2031, "RawDev2" },
    { 0x2040, "ImageProcessing" },
    { 0x2050, "FocusInfo" },
    { 0x2100, "Olympus2100" },
    { 0x2200, "Olympus2200" },
    { 0x2300, "Olympus2300" },
    { 0x2400, "Olympus2400" },
    { 0x2500, "Olympus2500" },
    { 0x2600, "Olympus2600" },
    { 0x2700, "Olympus2700" },
    { 0x2800, "Olympus2800" },
    { 0x2900, "Olympus2900" },
    { 0x3000, "RawInfo" },
    { 0x4000, "MainInfo" },
    { 0x5000, "UnknownInfo" },
};

const TagTable mnote_panasonic_tag_names = {
    { 0x1, "ImageQuality" },
    { 0x2, "FirmwareVersion" },
    { 0x3, "WhiteBalance" },
    { 0x7, "FocusMode" },
    { 0xf, "AFAreaMode" },
    { 0x1a, "ImageStabilization" },
    { 0x1c, "MacroMode" },
    { 0x1f, "ShootingMode" },
    { 0x20, "Audio" },
    { 0x21, "DataDump" },
    { 0x23, "WhiteBalanceBias" },
    { 0x24, "FlashBias" },
    { 0x25, "InternalSerialNumber" },
    { 0x26, "PanasonicExifVersion" },
    { 0x27, "VideoFrameRate" },
    { 0x28, "ColorEffect" },
    { 0x29, "TimeSincePowerOn" },
    { 0x2a, "BurstMode" },
    { 0x2b, "SequenceNumber" },
    { 0x2c, "ContrastMode" },
    { 0x2d, "NoiseReduction" },
    { 0x2e, "SelfTimer" },
    { 0x30, "Rotation" },
    { 0x31, "AFAssistLamp" },
    { 0x32, "ColorMode" },
    { 0x33, "BabyAge" },
    { 0x34, "OpticalZoomMode" },
    { 0x35, "ConversionLens" },
    { 0x36, "TravelDay" },
    { 0x38, "BatteryLevel" },
    { 0x39, "Contrast" },
    { 0x3a, "WorldTimeLocation" },
    { 0x3b, "TextStamp" },
    { 0x3c, "ProgramISO" },
    { 0x3d, "AdvancedSceneType" },
    { 0x3e, "TextStamp" },
    { 0x3f, "FacesDetected" },
    { 0x40, "Saturation" },
    { 0x41, "Sharpness" },
    { 0x42, "FilmMode" },
    { 0x43, "JPEGQuality" },
    { 0x44, "ColorTempKelvin" },
    { 0x45, "BracketSettings" },
    { 0x46, "WBShiftAB" },
    { 0x47, "WBShiftGM" },
    { 0x48, "FlashCurtain" },
    { 0x49, "LongExposureNoiseReduction" },
    { 0x4b, "PanasonicImageWidth" },
    { 0x4c, "PanasonicImageHeight" },
    { 0x4d, "AFPointPosition" },
    { 0x4e, "FaceDetInfo" },
    { 0x51, "LensType" },
    { 0x52, "LensSerialNumber" },
    { 0x53, "AccessoryType" },
    { 0x54, "AccessorySerialNumber" },
    { 0x59, "Transform" },
    { 0x5d, "IntelligentExposure" },
    { 0x60, "LensFirmwareVersion" },
    { 0x61, "FaceRecInfo" },
    { 0x62, "FlashWarning" },
    { 0x63, "RecognizedFaceFlags" },
    { 0x65, "Title" },
    { 0x66, "BabyName" },
    { 0x67, "Location" },
    { 0x69, "Country" },
    { 0x6b, "State" },
    { 0x6d, "City" },
    { 0x6f, "Landmark" },
    { 0x70, "IntelligentResolution" },
    { 0x76, "HDRShot" },
    { 0x77, "BurstSpeed" },
    { 0x79, "IntelligentD-Range" },
    { 0x7c, "ClearRetouch" },
    { 0x80, "City2" },
    { 0x86, "ManometerPressure" },
    { 0x89, "PhotoStyle" },
    { 0x8a, "ShadingCompensation" },
    { 0x8b, "WBShiftIntelligentAuto" },
    { 0x8c, "AccelerometerZ" },
    { 0x8d, "AccelerometerX" },
    { 0x8e, "AccelerometerY" },
    { 0x8f, "CameraOrientation" },
    { 0x90, "RollAngle" },
    { 0x91, "PitchAngle" },
    { 0x92, "WBShiftCreativeControl" },
    { 0x93, "SweepPanoramaDirection" },
    { 0x94, "SweepPanoramaFieldOfView" },
    { 0x96, "TimerRecording" },
    { 0x9d, "InternalNDFilter" },
    { 0x9e, "HDR" },
    { 0x9f, "ShutterType" },
    { 0xa1, "FilterEffect" },
    { 0xa3, "ClearRetouchValue" },
    { 0xa7, "OutputLUT" },
    { 0xab, "TouchAE" },
    { 0xac, "MonochromeFilterEffect" },
    { 0xad, "HighlightShadow" },
    { 0xaf, "TimeStamp" },
    { 0xb3, "VideoBurstResolution" },
    { 0xb4, "MultiExposure" },
    { 0xb9, "RedEyeRemoval" },
    { 0xbb, "VideoBurstMode" },
    { 0xbc, "DiffractionCorrection" },
    { 0xbd, "FocusBracket" },
    { 0xbe, "LongExposureNRUsed" },
    { 0xbf, "PostFocusMerging" },
    { 0xc1, "VideoPreburst" },
    { 0xc4, "LensTypeMake" },
    { 0xc5, "LensTypeModel" },
    { 0xca, "SensorType" },
    { 0xd1, "ISO" },
    { 0xd2, "MonochromeGrainEffect" },
    { 0xd6, "NoiseReductionStrength" },
    { 0xe4, "LensTypeModel" },
    { 0xe8, "MinimumISO" },
    { 0xee, "DynamicRangeBoost" },
    { 0xe00, "PrintIM" },
    { 0x2003, "TimeInfo" },
    { 0x8000, "MakerNoteVersion" },
    { 0x8001, "SceneMode" },
    { 0x8002, "HighlightWarning" },
    { 0x8003, "DarkFocusEnvironment" },
    { 0x8004, "WBRedLevel" },
    { 0x8005, "WBGreenLevel" },
    { 0x8006, "WBBlueLevel" },
    { 0x8008, "TextStamp" },
    { 0x8009, "TextStamp" },
    { 0x8010, "BabyAge" },
    { 0x8012, "Transform" },
};

const TagTable mnote_leica2_tag_names = {
    { 0x300, "Quality" },
    { 0x302, "UserProfile" },
    { 0x303, "SerialNumber" },
    { 0x304, "WhiteBalance" },
    { 0x310, "LensType" },
    { 0x311, "ExternalSensorBrightnessValue" },
    { 0x312, "MeasuredLV" },
    { 0x313, "ApproximateFNumber" },
    { 0x320, "CameraTemperature" },
    { 0x321, "ColorTemperature" },
    { 0x322, "WBRedLevel" },
    { 0x323, "WBGreenLevel" },
    { 0x324, "WBBlueLevel" },
    { 0x325, "UV-IRFilterCorrection" },
    { 0x330, "CCDVersion" },
    { 0x331, "CCDBoardVersion" },
    { 0x332, "ControllerBoardVersion" },
    { 0x333, "M16CVersion" },
    { 0x340, "ImageIDNumber" },
};

const TagTable mnote_leica4_tag_names = {
    { 0x3000, "Subdir3000" },
    { 0x3100, "Subdir3100" },
    { 0x3400, "Subdir3400" },
    { 0x3900, "Subdir3900" },
};

const TagTable mnote_leica5_tag_names = {
    { 0x303, "LensType" },
    { 0x305, "SerialNumber" },
    { 0x407, "OriginalFileName" },
    { 0x408, "OriginalDirectory" },
    { 0x40a, "FocusInfo" },
    { 0x40d, "ExposureMode" },
    { 0x410, "ShotInfo" },
    { 0x412, "FilmMode" },
    { 0x413, "WB_RGBLevels" },
    { 0x500, "InternalSerialNumber" },
};

const TagTable mnote_leica6_tag_names = {
    { 0x300, "PreviewImage" },
    { 0x301, "UnknownBlock" },
    { 0x303, "LensType" },
    { 0x304, "FocusDistance" },
    { 0x311, "ExternalSensorBrightnessValue" },
    { 0x312, "MeasuredLV" },
    { 0x320, "FirmwareVersion" },
    { 0x321, "LensSerialNumber" },
};

const TagTable mnote_leica9_tag_names = {
    { 0x304, "FocusDistance" },
    { 0x311, "ExternalSensorBrightnessValue" },
    { 0x312, "MeasuredLV" },
    { 0x34c, "UserProfile" },
    { 0x359, "ISOSelected" },
    { 0x35a, "FNumber" },
    { 0x35b, "CorrelatedColorTemp" },
    { 0x35c, "ColorTint" },
    { 0x35d, "WhitePoint" },
};

const TagTable mnote_pentax_tag_names = {
    { 0x0, "PentaxVersion" },
    { 0x1, "PentaxModelType" },
    { 0x2, "PreviewImageSize" },
    { 0x3, "PreviewImageLength" },
    { 0x4, "PreviewImageStart" },
    { 0x5, "PentaxModelID" },
    { 0x6, "Date" },
    { 0x7, "Time" },
    { 0x8, "Quality" },
    { 0x9, "PentaxImageSize" },
    { 0xb, "PictureMode" },
    { 0xc, "FlashMode" },
    { 0xd, "FocusMode" },
    { 0xe, "AFPointSelected" },
    { 0xf, "AFPointsInFocus" },
    { 0x10, "FocusPosition" },
    { 0x12, "ExposureTime" },
    { 0x13, "FNumber" },
    { 0x14, "ISO" },
    { 0x15, "LightReading" },
    { 0x16, "ExposureCompensation" },
    { 0x17, "MeteringMode" },
    { 0x18, "AutoBracketing" },
    { 0x19, "WhiteBalance" },
    { 0x1a, "WhiteBalanceMode" },
    { 0x1b, "BlueBalance" },
    { 0x1c, "RedBalance" },
    { 0x1d, "FocalLength" },
    { 0x1e, "DigitalZoom" },
    { 0x1f, "Saturation" },
    { 0x20, "Contrast" },
    { 0x21, "Sharpness" },
    { 0x22, "WorldTimeLocation" },
    { 0x23, "HometownCity" },
    { 0x24, "DestinationCity" },
    { 0x25, "HometownDST" },
    { 0x26, "DestinationDST" },
    { 0x27, "DSPFirmwareVersion" },
    { 0x28, "CPUFirmwareVersion" },
    { 0x29, "FrameNumber" },
    { 0x2d, "EffectiveLV" },
    { 0x32, "ImageEditing" },
    { 0x33, "PictureMode" },
    { 0x34, "DriveMode" },
    { 0x35, "SensorSize" },
    { 0x37, "ColorSpace" },
    { 0x38, "ImageAreaOffset" },
    { 0x39, "RawImageSize" },
    { 0x3c, "AFPointsInFocus" },
    { 0x3d, "DataScaling" },
    { 0x3e, "PreviewImageBorders" },
    { 0x3f, "LensRec" },
    { 0x40, "SensitivityAdjust" },
    { 0x41, "ImageEditCount" },
    { 0x47, "CameraTemperature" },
    { 0x48, "AELock" },
    { 0x49, "NoiseReduction" },
    { 0x4d, "FlashExposureComp" },
    { 0x4f, "ImageTone" },
    { 0x50, "ColorTemperature" },
    { 0x53, "ColorTempDaylight" },
    { 0x54, "ColorTempShade" },
    { 0x55, "ColorTempCloudy" },
    { 0x56, "ColorTempTungsten" },
    { 0x57, "ColorTempFluorescentD" },
    { 0x58, "ColorTempFluorescentN" },
    { 0x59, "ColorTempFluorescentW" },
    { 0x5a, "ColorTempFlash" },
    { 0x5c, "ShakeReductionInfo" },
    { 0x5d, "ShutterCount" },
    { 0x60, "FaceInfo" },
    { 0x62, "RawDevelopmentProcess" },
    { 0x67, "Hue" },
    { 0x68, "AWBInfo" },
    { 0x69, "DynamicRangeExpansion" },
    { 0x6b, "TimeInfo" },
    { 0x6c, "HighLowKeyAdj" },
    { 0x6d, "ContrastHighlight" },
    { 0x6e, "ContrastShadow" },
    { 0x6f, "ContrastHighlightShadowAdj" },
    { 0x70, "FineSharpness" },
    { 0x71, "HighISONoiseReduction" },
    { 0x72, "AFAdjustment" },
    { 0x73, "MonochromeFilterEffect" },
    { 0x74, "MonochromeToning" },
    { 0x76, "FaceDetect" },
    { 0x77, "FaceDetectFrameSize" },
    { 0x79, "ShadowCorrection" },
    { 0x7a, "ISOAutoParameters" },
    { 0x7b, "CrossProcess" },
    { 0x7d, "LensCorr" },
    { 0x7e, "WhiteLevel" },
    { 0x7f, "BleachBypassToning" },
    { 0x80, "AspectRatio" },
    { 0x82, "BlurControl" },
    { 0x85, "HDR" },
    { 0x87, "ShutterType" },
    { 0x88, "NeutralDensityFilter" },
    { 0x8b, "ISO" },
    { 0x92, "IntervalShooting" },
    { 0x95, "SkinToneCorrection" },
    { 0x96, "ClarityControl" },
    { 0x200, "BlackPoint" },
    { 0x201, "WhitePoint" },
    { 0x203, "ColorMatrixA" },
    { 0x204, "ColorMatrixB" },
    { 0x205, "CameraSettings" },
    { 0x206, "AEInfo" },
    { 0x207, "LensInfo" },
    { 0x208, "FlashInfo" },
    { 0x209, "AEMeteringSegments" },
    { 0x20a, "FlashMeteringSegments" },
    { 0x20b, "SlaveFlashMeteringSegments" },
    { 0x20d, "WB_RGGBLevelsDaylight" },
    { 0x20e, "WB_RGGBLevelsShade" },
    { 0x20f, "WB_RGGBLevelsCloudy" },
    { 0x210, "WB_RGGBLevelsTungsten" },
    { 0x211, "WB_RGGBLevelsFluorescentD" },
    { 0x212, "WB_RGGBLevelsFluorescentN" },
    { 0x213, "WB_RGGBLevelsFluorescentW" },
    { 0x214, "WB_RGGBLevelsFlash" },
    { 0x215, "CameraInfo" },
    { 0x216, "BatteryInfo" },
    { 0x21b, "SaturationInfo" },
    { 0x21c, "ColorMatrixA2" },
    { 0x21d, "ColorMatrixB2" },
    { 0x21f, "AFInfo" },
    { 0x220, "HuffmanTable" },
    { 0x221, "KelvinWB" },
    { 0x222, "ColorInfo" },
    { 0x224, "EVStepInfo" },
    { 0x226, "ShotInfo" },
    { 0x227, "FacePos" },
    { 0x228, "FaceSize" },
    { 0x229, "SerialNumber" },
    { 0x22a, "FilterInfo" },
    { 0x22b, "LevelInfo" },
    { 0x22d, "WBLevels" },
    { 0x22e, "Artist" },
    { 0x22f, "Copyright" },
    { 0x230, "FirmwareVersion" },
    { 0x231, "ContrastDetectAFArea" },
    { 0x235, "CrossProcessParams" },
    { 0x239, "LensInfoQ" },
    { 0x23f, "Model" },
    { 0x243, "PixelShiftInfo" },
    { 0x245, "AFPointInfo" },
    { 0x3fe, "DataDump" },
    { 0x3ff, "TempInfo" },
    { 0x402, "ToneCurve" },
    { 0x403, "ToneCurves" },
    { 0x405, "UnknownBlock" },
    { 0xe00, "PrintIM" },
};

const TagTable mnote_ricoh_tag_names = {
    { 0x1, "MakerNoteType" },
    { 0x2, "FirmwareVersion" },
    { 0x5, "SerialNumber" },
    { 0xe00, "PrintIM" },
    { 0x1000, "RecordingFormat" },
    { 0x1001, "ImageInfo" },
    { 0x1002, "DriveMode" },
    { 0x1003, "Sharpness" },
    { 0x1004, "WhiteBalanceFineTune" },
    { 0x1006, "FocusMode" },
    { 0x1007, "AutoBracketing" },
    { 0x1009, "MacroMode" },
    { 0x100a, "FlashMode" },
    { 0x100b, "FlashExposureComp" },
    { 0x100c, "ManualFlashOutput" },
    { 0x100d, "FullPressSnap" },
    { 0x100e, "DynamicRangeExpansion" },
    { 0x100f, "NoiseReduction" },
    { 0x1010, "ImageEffects" },
    { 0x1011, "Vignetting" },
    { 0x1012, "Contrast" },
    { 0x1013, "Saturation" },
    { 0x1014, "Sharpness" },
    { 0x1015, "ToningEffect" },
    { 0x1016, "HueAdjust" },
    { 0x1017, "WideAdapter" },
    { 0x1018, "CropMode" },
    { 0x1019, "NDFilter" },
    { 0x101a, "WBBracketShotNumber" },
    { 0x1200, "AFStatus" },
    { 0x1201, "AFAreaXPosition1" },
    { 0x1202, "AFAreaYPosition1" },
    { 0x1203, "AFAreaXPosition" },
    { 0x1204, "AFAreaYPosition" },
    { 0x1205, "AFAreaMode" },
    { 0x1307, "ColorTempKelvin" },
    { 0x1308, "ColorTemperature" },
    { 0x1500, "FocalLength" },
    { 0x1601, "SensorWidth" },
    { 0x1602, "SensorHeight" },
    { 0x1603, "CroppedImageWidth" },
    { 0x1604, "CroppedImageHeight" },
    { 0x2001, "RicohSubdir" },
    { 0x4001, "ThetaSubdir" },
};

const TagTable mnote_sigma_tag_names = {
    { 0x2, "SerialNumber" },
    { 0x3, "DriveMode" },
    { 0x4, "ResolutionMode" },
    { 0x5, "AFMode" },
    { 0x6, "FocusSetting" },
    { 0x7, "WhiteBalance" },
    { 0x8, "ExposureMode" },
    { 0x9, "MeteringMode" },
    { 0xa, "LensFocalRange" },
    { 0xb, "ColorSpace" },
    { 0xc, "ExposureCompensation" },
    { 0xd, "Contrast" },
    { 0xe, "Shadow" },
    { 0xf, "Highlight" },
    { 0x10, "Saturation" },
    { 0x11, "Sharpness" },
    { 0x12, "X3FillLight" },
    { 0x14, "ColorAdjustment" },
    { 0x15, "AdjustmentMode" },
    { 0x16, "Quality" },
    { 0x17, "Firmware" },
    { 0x18, "Software" },
    { 0x19, "AutoBracket" },
    { 0x1a, "PreviewImageStart" },
    { 0x1b, "PreviewImageLength" },
    { 0x1c, "PreviewImageSize" },
    { 0x1d, "MakerNoteVersion" },
    { 0x1e, "PreviewImageSize" },
    { 0x1f, "AFPoint" },
    { 0x22, "FileFormat" },
    { 0x24, "Calibration" },
    { 0x26, "FileFormat" },
    { 0x27, "LensType" },
    { 0x2a, "LensFocalRange" },
    { 0x2b, "LensMaxApertureRange" },
    { 0x2c, "ColorMode" },
    { 0x30, "LensApertureRange" },
    { 0x31, "FNumber" },
    { 0x32, "ExposureTime" },
    { 0x33, "ExposureTime2" },
    { 0x34, "BurstShot" },
    { 0x35, "ExposureCompensation" },
    { 0x39, "SensorTemperature" },
    { 0x3a, "FlashExposureComp" },
    { 0x3b, "Firmware" },
    { 0x3c, "WhiteBalance" },
    { 0x3d, "PictureMode" },
    { 0x48, "LensApertureRange" },
    { 0x49, "FNumber" },
    { 0x4a, "ExposureTime" },
    { 0x4b, "ExposureTime2" },
    { 0x4d, "ExposureCompensation" },
    { 0x55, "SensorTemperature" },
    { 0x56, "FlashExposureComp" },
    { 0x57, "Firmware2" },
    { 0x58, "WhiteBalance" },
    { 0x59, "DigitalFilter" },
    { 0x84, "Model" },
    { 0x86, "ISO" },
    { 0x87, "ResolutionMode" },
    { 0x88, "WhiteBalance" },
    { 0x8c, "Firmware" },
    { 0x11f, "CameraCalibration" },
    { 0x120, "WBSettings" },
    { 0x121, "WBSettings2" },
};

const TagTable mnote_sony_tag_names = {
    { 0x10, "CameraInfo" },
    { 0x20, "FocusInfo" },
    { 0x102, "Quality" },
    { 0x104, "FlashExposureComp" },
    { 0x105, "Teleconverter" },
    { 0x112, "WhiteBalanceFineTune" },
    { 0x114, "CameraSettings" },
    { 0x115, "WhiteBalance" },
    { 0x116, "ExtraInfo" },
    { 0xe00, "PrintIM" },
    { 0x1000, "MultiBurstMode" },
    { 0x1001, "MultiBurstImageWidth" },
    { 0x1002, "MultiBurstImageHeight" },
    { 0x1003, "Panorama" },
    { 0x2001, "PreviewImage" },
    { 0x2002, "Rating" },
    { 0x2004, "Contrast" },
    { 0x2005, "Saturation" },
    { 0x2006, "Sharpness" },
    { 0x2007, "Brightness" },
    { 0x2008, "LongExposureNoiseReduction" },
    { 0x2009, "HighISONoiseReduction" },
    { 0x200a, "HDR" },
    { 0x200b, "MultiFrameNoiseReduction" },
    { 0x200e, "PictureEffect" },
    { 0x200f, "SoftSkinEffect" },
    { 0x2010, "Tag2010a" },
    { 0x2011, "VignettingCorrection" },
    { 0x2012, "LateralChromaticAberration" },
    { 0x2013, "DistortionCorrectionSetting" },
    { 0x2014, "WBShiftAB_GM" },
    { 0x2016, "AutoPortraitFramed" },
    { 0x2017, "FlashAction" },
    { 0x201a, "ElectronicFrontCurtainShutter" },
    { 0x201b, "FocusMode" },
    { 0x201c, "AFAreaModeSetting" },
    { 0x201d, "FlexibleSpotPosition" },
    { 0x201e, "AFPointSelected" },
    { 0x2020, "AFPointsUsed" },
    { 0x2021, "AFTracking" },
    { 0x2022, "FocalPlaneAFPointsUsed" },
    { 0x2023, "MultiFrameNREffect" },
    { 0x2026, "WBShiftAB_GM_Precise" },
    { 0x2027, "FocusLocation" },
    { 0x2028, "VariableLowPassFilter" },
    { 0x2029, "RAWFileType" },
    { 0x202a, "Tag202a" },
    { 0x202b, "PrioritySetInAWB" },
    { 0x202c, "MeteringMode2" },
    { 0x202d, "ExposureStandardAdjustment" },
    { 0x202e, "Quality" },
    { 0x202f, "PixelShiftInfo" },
    { 0x2031, "SerialNumber" },
    { 0x2032, "Shadows" },
    { 0x2033, "Highlights" },
    { 0x2034, "Fade" },
    { 0x2035, "SharpnessRange" },
    { 0x2036, "Clarity" },
    { 0x2037, "FocusFrameSize" },
    { 0x2039, "JPEG-HEIFSwitch" },
    { 0x3000, "ShotInfo" },
    { 0x900b, "Tag900b" },
    { 0x9050, "Tag9050a" },
    { 0x9400, "Tag9400a" },
    { 0x9401, "Tag9401" },
    { 0x9402, "Tag9402" },
    { 0x9403, "Tag9403" },
    { 0x9404, "Tag9404a" },
    { 0x9405, "Tag9405a" },
    { 0x9406, "Tag9406" },
    { 0x9407, "Sony_0x9407" },
    { 0x9408, "Sony_0x9408" },
    { 0x9409, "Sony_0x9409" },
    { 0x940a, "Tag940a" },
    { 0x940b, "Sony_0x940b" },
    { 0x940c, "Tag940c" },
    { 0x940d, "Sony_0x940d" },
    { 0x940e, "AFInfo" },
    { 0x940f, "Sony_0x940f" },
    { 0x9411, "Sony_0x9411" },
    { 0x9416, "Sony_0x9416" },
    { 0xb000, "FileFormat" },
    { 0xb001, "SonyModelID" },
    { 0xb020, "CreativeStyle" },
    { 0xb021, "ColorTemperature" },
    { 0xb022, "ColorCompensationFilter" },
    { 0xb023, "SceneMode" },
    { 0xb024, "ZoneMatching" },
    { 0xb025, "DynamicRangeOptimizer" },
    { 0xb026, "ImageStabilization" },
    { 0xb027, "LensType" },
    { 0xb028, "MinoltaMakerNote" },
    { 0xb029, "ColorMode" },
    { 0xb02a, "LensSpec" },
    { 0xb02b, "FullImageSize" },
    { 0xb02c, "PreviewImageSize" },
    { 0xb040, "Macro" },
    { 0xb041, "ExposureMode" },
    { 0xb042, "FocusMode" },
    { 0xb043, "AFAreaMode" },
    { 0xb044, "AFIlluminator" },
    { 0xb047, "JPEGQuality" },
    { 0xb048, "FlashLevel" },
    { 0xb049, "ReleaseMode" },
    { 0xb04a, "SequenceNumber" },
    { 0xb04b, "Anti-Blur" },
    { 0xb04e, "FocusMode" },
    { 0xb04f, "DynamicRangeOptimizer" },
    { 0xb050, "HighISONoiseReduction2" },
    { 0xb052, "IntelligentAuto" },
    { 0xb054, "WhiteBalance" },
};

const TagTable raw_panasonic_tag_names = {
    { 0x1, "PanasonicRawVersion" },
    { 0x2, "SensorWidth" },
    { 0x3, "SensorHeight" },
    { 0x4, "SensorTopBorder" },
    { 0x5, "SensorLeftBorder" },
    { 0x6, "SensorBottomBorder" },
    { 0x7, "SensorRightBorder" },
    { 0x8, "SamplesPerPixel" },
    { 0x9, "CFAPattern" },
    { 0xa, "BitsPerSample" },
    { 0xb, "Compression" },
    { 0xe, "LinearityLimitRed" },
    { 0xf, "LinearityLimitGreen" },
    { 0x10, "LinearityLimitBlue" },
    { 0x11, "RedBalance" },
    { 0x12, "BlueBalance" },
    { 0x13, "WBInfo" },
    { 0x17, "ISO" },
    { 0x18, "HighISOMultiplierRed" },
    { 0x19, "HighISOMultiplierGreen" },
    { 0x1a, "HighISOMultiplierBlue" },
    { 0x1b, "NoiseReductionParams" },
    { 0x1c, "BlackLevelRed" },
    { 0x1d, "BlackLevelGreen" },
    { 0x1e, "BlackLevelBlue" },
    { 0x24, "WBRedLevel" },
    { 0x25, "WBGreenLevel" },
    { 0x26, "WBBlueLevel" },
    { 0x27, "WBInfo2" },
    { 0x2d, "RawFormat" },
    { 0x2e, "JpgFromRaw" },
    { 0x2f, "CropTop" },
    { 0x30, "CropLeft" },
    { 0x31, "CropBottom" },
    { 0x32, "CropRight" },
    { 0x10f, "Make" },
    { 0x110, "Model" },
    { 0x111, "StripOffsets" },
    { 0x112, "Orientation" },
    { 0x116, "RowsPerStrip" },
    { 0x117, "StripByteCounts" },
    { 0x118, "RawDataOffset" },
    { 0x119, "DistortionInfo" },
    { 0x11c, "Gamma" },
    { 0x120, "CameraIFD" },
    { 0x121, "Multishot" },
    { 0x2bc, "ApplicationNotes" },
    { 0x83bb, "IPTC-NAA" },
    { 0x8769, "ExifOffset" },
    { 0x8825, "GPSInfo" },
};