use std::path;

use crate::context::AppContext;
use crate::preview::{preview_dir, preview_file};
use crate::ui::TuiBackend;

pub fn load_preview_path(context: &mut AppContext, backend: &mut TuiBackend, p: path::PathBuf) {
    if p.is_dir() {
        let need_to_load = context
            .tab_context_mut()
            .curr_tab_mut()
            .history_mut()
            .get(p.as_path())
            .map(|e| e.need_update())
            .unwrap_or(true);

        if need_to_load {
            preview_dir::Background::load_preview(context, p);
        }
    } else if p.is_file() {
        let need_to_load = context
            .preview_context_ref()
            .get_preview(p.as_path())
            .is_none();

        if need_to_load {
            preview_file::Background::preview_path_with_script(context, backend, p);
        }
    }
}

pub fn load_preview(context: &mut AppContext, backend: &mut TuiBackend) {
    let mut p: Option<path::PathBuf> = None;
    if let Some(curr_list) = context.tab_context_ref().curr_tab_ref().curr_list_ref() {
        if let Some(index) = curr_list.index {
            let entry = &curr_list.contents[index];
            p = Some(entry.file_path().to_path_buf())
        }
    }

    if let Some(p) = p {
        load_preview_path(context, backend, p);
    }
}
