// Copyright 2020 The Jujutsu Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
// https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

use testutils::git;

use crate::common::TestEnvironment;

#[test]
fn test_gitsubmodule_print_gitmodules() {
    let test_env = TestEnvironment::default();
    let workspace_root = test_env.env_root().join("repo");
    git::init(&workspace_root);
    test_env
        .run_jj_in(&workspace_root, ["git", "init", "--git-repo", "."])
        .success();

    std::fs::write(
        workspace_root.join(".gitmodules"),
        "
[submodule \"old\"]
	path = old
	url = https://github.com/old/old.git
",
    )
    .unwrap();

    test_env.run_jj_in(&workspace_root, ["new"]).success();

    std::fs::write(
        workspace_root.join(".gitmodules"),
        "
[submodule \"new\"]
	path = new
	url = https://github.com/new/new.git
",
    )
    .unwrap();

    let output = test_env.run_jj_in(
        &workspace_root,
        ["git", "submodule", "print-gitmodules", "-r", "@-"],
    );
    insta::assert_snapshot!(output, @r"
    name:old
    url:https://github.com/old/old.git
    path:old


    [EOF]
    ");

    let output = test_env.run_jj_in(&workspace_root, ["git", "submodule", "print-gitmodules"]);
    insta::assert_snapshot!(output, @r"
    name:new
    url:https://github.com/new/new.git
    path:new


    [EOF]
    ");
}
