@ModuleInfo { minPklVersion = "0.27.2" }
module hk.Config
min_hk_version = "{{version | truncate(length=1)}}.0.0"

open class Linter {
    /// Which profiles (HK_PROFILES) need to be active for the step to run
    profiles: List<String>?

    /// Which file patterns to run the step on
    glob: List<String>?

    /// If true, the step will run by itself, waiting for previous steps to finish before starting and making later steps wait for it to finish
    exclusive = false

    /// Wait for sibling steps to finish before starting this step.
    depends: List<String> = List()

    /// If true, when intending to run the fix command for this step, if any other steps in the same group need to read to the same files, this step will run the check command instead
    /// if it fails, the fix command will be run after
    /// Note that this behavior is only used if multiple steps would be in contention. If all fix steps edit disjoint files, the fix step will be chosen first despite this config.
    check_first = true

    /// Run check/fix step on batches of files instead of all files at once.
    /// This takes advantage of parallel processing for otherwise single-threaded linters like eslint and prettier.
    batch = false

    /// fetches a read lock instead of a write lock when running fix/fix_all. Use if the tool has its own locking mechanism or you simply don't care if files may be written to
    /// by multiple steps.
    stomp = false

    /// a shell command to check. Any edits will be ignored.
    check: String?
    check_list_files: String?
    check_diff: String?
    check_extra_args: String?

    /// a shell command that checks and edits files. Edits will be automatically added to the index.
    fix: String?
    fix_extra_args: String?

    /// if set, run the linter on workspaces only which are parent directories containing this filename
    workspace_indicator: String?

    /// if set, run the linter scripts with this prefix, e.g.: "mise exec --" or "npm run"
    prefix: String?

    /// if set, run the linter scripts in this directory
    dir: String?

    /// run the linter scripts with these environment variables
    env = new Mapping<String, String>{}

    /// if not set, all files will be added
    stage: List<String>?
}

open class Step {
    /// Which profiles (HK_PROFILES) need to be active for the step to run
    profiles: List<String>?

    /// Which file patterns to run the step on
    glob: List<String>?

    /// If true, the step will run by itself, waiting for previous steps to finish before starting and making later steps wait for it to finish
    exclusive = false

    /// Wait for sibling steps to finish before starting this step.
    depends: List<String> = List()

    /// run the linter scripts with these environment variables
    env = new Mapping<String, String>{}

    /// a shell command to run
    run: String
}

class Fix extends Step {
    type = "fix"
    run = "fix"
    linter_dependencies = new Mapping<String, List<String>>{}
}

class Check extends Step {
    type = "check"
    run = "check"
    linter_dependencies = new Mapping<String, List<String>>{}
}

typealias Hook = Mapping<String, Step>

linters: Mapping<String, Linter>?

hooks: Mapping<String, Hook>?
