// amends "package://github.com/jdx/hk/releases/download/v0.5.0/hk@0.5.0#/Config.pkl"
amends "pkl/Config.pkl"
import "pkl/builtins/actionlint.pkl"
import "pkl/builtins/cargo_clippy.pkl"
import "pkl/builtins/cargo_fmt.pkl"
import "pkl/builtins/prettier.pkl"
import "pkl/builtins/eslint.pkl"

// defines what happens during git pre-commit hook
linters = new {
    ["actionlint"] = new actionlint.Actionlint {}
    // TODO: fails on releases with hk-example.pkl
    //["pkl"] {
        //glob = new { "*.pkl" }
        //check = "pkl eval {{files}} >/dev/null"
    //}
    // predefined formatters+linters
    ["cargo-clippy"] = new cargo_clippy.CargoClippy {
        profiles = List("slow")
        check_extra_args = "-- -D warnings"
    }
    ["cargo-fmt"] = new cargo_fmt.CargoFmt {
        profiles = List("!slow")
    }
    ["dbg"] {
        // ensure no dbg! macros are used
        glob = List("**/*.rs")
        check = "! rg -e 'dbg!' {{files}}"
    }
    ["eslint"] = new eslint.Eslint {
        dir = "docs"
        prefix = "bun run"
    }
    ["prettier"] = new prettier.Prettier {
        glob = List("*.js", "*.ts", "*.yml", "*.yaml") // override the default globs
    }
}

hooks = new {
    ["pre-commit"] {
        ["prelint"] {
            run = "mise run prelint"
            exclusive = true
        }
        ["fix"] = new Fix {}
    }
}

// TODO
//`pre-push` {
    // ["format"] {
    //     check = true // ensures the files have no changes and fails otherwise
    //     formatter = formatters.prettier
    // }
    // ["lint"] {
    //     linters = new {
    //         ["eslint"] {
    //             glob = new { "*.ts" }
    //         }
    //         ["clippy"] {}
    //         ["golangci-lint"] {}
    //     }
    // }
//}

// TODO
// commit_msg {
// }

// TODO
// prepare_commit_msg {
// }

// TODO
// update {
// }
