## Commands

Following are the currently available commands for [gpg-tui](https://github.com/orhun/gpg-tui). See [README.md](README.md#running-commands) for more information.

| Command                            | Syntax                                                             | Example(s)                                                                                                                                                                                       |
| ---------------------------------- | ------------------------------------------------------------------ | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------ |
| Confirm the execution of a command | `:confirm <other_command>`                                         | `:confirm list pub`                                                                                                                                                                              |
| Show the help menu                 | `:help`                                                            | -                                                                                                                                                                                                |
| Show a message                     | `:out <type> <msg>`                                                | `:out success hey`<br>`:out warning !!!`<br>`:out failure error`<br>`:out action done`                                                                                                           |
| Show the options menu              | `:options`                                                         | -                                                                                                                                                                                                |
| List public/secret keys            | `:list <key_type>`                                                 | `:list pub`<br>`:list sec`                                                                                                                                                                       |
| Import/receive key(s)              | `:import <key_path>..` / `:import-clipboard` `:receive <key_id>..` | `:import key1.asc key2.asc`<br>`:import-clipboard`<br>`:receive 0x00`                                                                                                                            |
| Export key(s)                      | `:export <key_type> <query> (subkey)`                              | `:export pub 0x00`<br>`:export sec orhun`                                                                                                                                                        |
| Delete key                         | `:delete <key_type> <key_id>`                                      | `:delete pub 0x00`                                                                                                                                                                               |
| Send key                           | `:send <key_id>`                                                   | `:send 0x00`                                                                                                                                                                                     |
| Edit key                           | `:edit <key_id>`                                                   | `:edit 0x00`                                                                                                                                                                                     |
| Sign key                           | `:sign <key_id>`                                                   | `:sign <key_id>`                                                                                                                                                                                 |
| Generate key                       | `:generate`                                                        | -                                                                                                                                                                                                |
| Switch to copy mode                | `:copy`                                                            | -                                                                                                                                                                                                |
| Copy values to clipboard           | `:copy <copy_type>`                                                | `:copy row1`<br>`:copy row2`<br>`:copy key`<br>`:copy key_id`<br>`:copy key_fingerprint`<br>`:copy key_user_id`                                                                                  |
| Toggle detail                      | `:toggle (detail) (all)`                                           | `:toggle`<br>`:toggle detail`<br>`:toggle detail all`                                                                                                                                            |
| Scroll                             | `:scroll (row) <direction> <amount>`                               | `:scroll down 1`<br>`:scroll up 5`<br>`:scroll row down 2`                                                                                                                                       |
| Set value                          | `:set <option> <value>`                                            | `:set output /tmp`<br>`:set mode normal`<br>`:set armor true`<br>`:set minimize 10`<br>`:set detail full`<br>`:set margin 2`<br>`:set style plain`<br>`:set color #123123`<br>`:set signer 0x00` |
| Get value                          | `:get <option>`                                                    | `:get output`<br>`:get mode`<br>`:get armor`<br>`:get minimize`<br>`:get detail`<br>`:get margin`<br>`:get style`<br>`:get color`<br>`:get signer`                                               |
| Change style                       | `:style <style>`                                                   | `:style plain`<br>`:style colored`                                                                                                                                                               |
| Switch mode                        | `:mode <mode>`                                                     | `:mode normal`<br>`:mode visual`<br>`:mode copy`                                                                                                                                                 |
| Switch to normal mode              | `:normal`                                                          | -                                                                                                                                                                                                |
| Switch to visual mode              | `:visual`                                                          | -                                                                                                                                                                                                |
| Paste from clipboard               | `:paste`                                                           | -                                                                                                                                                                                                |
| Enable command input               | `:input`                                                           | -                                                                                                                                                                                                |
| Enable search                      | `:search`                                                          | -                                                                                                                                                                                                |
| Go to the next tab                 | `:next`                                                            | -                                                                                                                                                                                                |
| Go to the previous tab             | `:previous`                                                        | -                                                                                                                                                                                                |
| Refresh the application            | `:refresh`                                                         | -                                                                                                                                                                                                |
| Refresh the keyring                | `:refresh keys`                                                    | -                                                                                                                                                                                                |
| Show logs                          | `:logs`                                                            | -                                                                                                                                                                                                |
| Quit the application               | `:quit`                                                            | -                                                                                                                                                                                                |
| Do nothing                         | `:none`                                                            | -                                                                                                                                                                                                |
