# Changelog

## v1.10.0 - 2025-04-14

### Bug fixes

- Fixed a bug where the code action to unqualify types and values would add an
  unqualified import even if it was already imported.
  ([Surya Rose](https://github.com/GearsDatapacks))

- Fixed a bug where numbers starting with `0x_`, `0o_` and `0b_` would cause
  a syntax error when compiling to JavaScript.
  ([Surya Rose](https://github.com/GearsDatapacks))

## v1.10.0-rc1 - 2025-04-05

### Compiler

- On the JavaScript target, bit arrays can now use the `unit` option to control
  the units of the `size` option.
  ([Surya Rose](https://github.com/GearsDatapacks))

- The compiler can now tell if string branches are unreachable. For example, the
  following code:

  ```gleam
  case a_string {
    "Hello, " <> name -> name
    "Hello, Jak" -> "Jak"
    _ -> "Stranger"
  }
  ```

  Will raise the following warning:

  ```
  warning: Unreachable case clause
    ┌─ /src/greet.gleam:7:5
    │
  7 │     "Hello, Jak" -> "Jak"
    │     ^^^^^^^^^^^^^^^^^^^^^

  This case clause cannot be reached as a previous clause matches the same
  values.

  Hint: It can be safely removed.
  ```

  ([Giacomo Cavalieri](https://github.com/giacomocavalieri))

- On the JavaScript target, blocks and various other expressions no longer
  compile to immediately invoked function expressions.
  ([Surya Rose](https://github.com/GearsDatapacks))

- On the JavaScript target, bit arrays can now use 16-bit floats in expressions
  and patterns.
  ([Richard Viney](https://github.com/richard-viney))

- Improved the error message for unknown and missing target names in the
  `@target` attribute.
  ([Alexander Keleschovsky](https://github.com/AlecGhost))

- The compiler now uses a call graph for detecting unused types and values.
  This means that among other things, it can now detect unused recursive
  functions. For example:

  ```gleam
  // warning: unused
  fn some_recursive_function() {
    some_recursive_function()
  }
  ```

  ([Surya Rose](https://github.com/GearsDatapacks))

- The compiler now emits a warning when using `let assert` to assert a value
  whose variant has already been inferred. For example:

  ```gleam
  // warning: This will always crash
  let assert Ok(_) = Error("Some error")
  ```

  ([Surya Rose](https://github.com/GearsDatapacks))

- It is now possible to omit the `:float` option for literal floats used in a
  `BitArray` segment.

  ```gleam
  <<1.11>>
  ```

  Is the same as:

  ```gleam
  <<1.11:float>>
  ```

  ([Giacomo Cavalieri](https://github.com/giacomocavalieri))

- Compilation of binary operators is now fault tolerant and won't stop at the
  first type error.
  ([Giacomo Cavalieri](https://github.com/giacomocavalieri))

- The compiler now provides a better error message when using the wrong operator
  to try and join two strings together. For example:

  ```txt
  error: Type mismatch
    ┌─ /src/wibble.gleam:2:13
    │
  2 │   "Hello, " + "Lucy"
    │             ^ Use <> instead

  The + operator can only be used on Ints.
  To join two strings together you can use the <> operator.
  ```

  ([Giacomo Cavalieri](https://github.com/giacomocavalieri))

- The compiler now provides a better error message when using an Int operator on
  Float values, suggesting the correct replacement. For example:

  ```txt
  error: Type mismatch
    ┌─ /Users/giacomocavalieri/Desktop/prova/src/prova.gleam:2:7
    │
  2 │   1.0 + 2.0
    │       ^ Use +. instead

  The + operator can only be used on Ints.
  ```

  ([Giacomo Cavalieri](https://github.com/giacomocavalieri))

- The compiler now provides a better error message when using a Float operator
  on Int values, suggesting the correct replacement. For example:

  ```txt
  error: Type mismatch
    ┌─ /Users/giacomocavalieri/Desktop/prova/src/prova.gleam:2:5
    │
  2 │   1 >. 2
    │     ^^ Use > instead

  The >. operator can only be used on Floats.
  ```

  ([Giacomo Cavalieri](https://github.com/giacomocavalieri))

- The compiler no longer shows errors for a function's labels if the called
  function itself doesn't exist.
  ([Giacomo Cavalieri](https://github.com/giacomocavalieri))

### Build tool

- Include a type annotation for the `main` function generated by `gleam new`.
  ([Drew Olson](https://github.com/drewolson))

- Two entry point scripts are now always generated by `gleam export erlang-shipment`:

  - `entrypoint.sh` for POSIX Shell
  - `entrypoint.ps1` for PowerShell

  ([Greg Burri](https://github.com/ummon))

- The `gleam export` command now takes a `package-information` option to
  export the project's `gleam.toml` as a JSON file.
  ([Rodrigo Álvarez](https://github.com/Papipo))

- Improved the error message when failing to encrypt or decrypt a local
  Hex API key.
  ([Samuel Cristobal](https://github.com/scristobal))

- The `HEXPM_USER` and `HEXPM_PASS` environment variables when running
  `gleam publish` have been deprecated in favour of `HEXPM_API_KEY`.
  ([Samuel Cristobal](https://github.com/scristobal))

- The "functions" and "constants" sections of generated HTML documentation have
  been merged into one "values" section.
  ([Sam Zanca](https://github.com/metruzanca))

### Language server

- The language server now allows renaming of functions, constants,
  custom type variants and custom types across modules. For example:

  ```gleam
  // wibble.gleam
  pub fn wibble() {
    wibble()
  //^ Trigger rename
  }
  // wobble.gleam
  import wibble

  pub fn main() {
    wibble.wibble()
  }
  ```

  Becomes:

  ```gleam
  // wibble.gleam
  pub fn wobble() {
    wobble()
  }
  // wobble.gleam
  import wibble

  pub fn main() {
    wibble.wobble()
  }
  ```

  ([Surya Rose](https://github.com/GearsDatapacks))

- The language server can now offer a code action to replace a `..` in a pattern
  with all the fields that are being ignored. For example triggering the code
  action on this spread:

  ```gleam
  pub type Pokemon {
    Pokemon(id: Int, name: String, moves: List(String))
  }

  pub fn main() {
    let Pokemon(..) = todo
    //          ^ If you put your cursor here
  }
  ```

  Would generate the following code:

  ```gleam
  pub type Pokemon {
    Pokemon(id: Int, name: String, moves: List(String))
  }

  pub fn main() {
    let Pokemon(id:, name:, moves:) = todo
  }
  ```

  ([Giacomo Cavalieri](https://github.com/giacomocavalieri))

- The function generated by the "Generate JSON encoder" code action has been
  slightly modified so that it will now fail to compile if the type has new
  fields added, ensuring the programmer remembers to re-run the code action.
  For example, for this type:

  ```gleam
  type Person {
    Person(name: String, age: Int)
  }
  ```

  The following code used to be generated:

  ```gleam
  fn encode_person(person: Person) -> json.Json {
    json.object([
      #("name", json.string(person.name)),
      #("age", json.int(person.age)),
    ])
  }
  ```

  But now, this code is generated:

  ```gleam
  fn encode_person(person: Person) -> json.Json {
    let Person(name:, age:) = person
    json.object([
      #("name", json.string(name)),
      #("age", json.int(age)),
    ])
  }
  ```

  ([Surya Rose](https://github.com/GearsDatapacks))

- The language server now supports finding references to values and types,
  both within a module and across multiple modules.
  ([Surya Rose](https://github.com/GearsDatapacks))

- The language server now offers a code action to remove all `echo`s in a
  module. For example:

  ```gleam
  pub fn main() {
    [1, 2, 3]
    |> echo
    // ^^^^ If you put your cursor over here
    |> list.filter(int.is_even)
    |> echo
  }
  ```

  Triggering the code action would remove all the `echo` pipeline steps:

  ```gleam
  pub fn main() {
    [1, 2, 3]
    |> list.filter(int.is_even)
  }
  ```

  This also works with all the `echo`s used before an expression:

  ```gleam
  pub fn main() {
    echo 1 + 2
  //^^^^^^^^^^ If hovering anywhere over here
  }
  ```

  Triggering the code action would remove the `echo`:

  ```gleam
  pub fn main() {
    1 + 2
  }
  ```

  ([Giacomo Cavalieri](https://github.com/giacomocavalieri))

- The language server now offers a code action to replace a Float operator used
  on Int values with the correct operator. For example:

  ```gleam
  pub fn main() {
    11 +. 1
  //^^^^^^^ When hovering anywhere over here
  }
  ```

  Triggering the code action would fix the compilation error by using the
  correct Int operator:

  ```gleam
  pub fn main() {
    11 + 1
  }
  ```

  This also works the other way around:

  ```gleam
  pub fn main() {
    1.1 + 10.0
  //^^^^^^^^^^ If hovering anywhere over here
  }
  ```

  Triggering the code action would replace the wrong operator with the correct
  equivalent Float operator:

  ```gleam
  pub fn main() {
    1.1 +. 10.0
  }
  ```

  ([Giacomo Cavalieri](https://github.com/giacomocavalieri))

- If there's a compilation error because two strings are being joined with the
  wrong `+` operator (instead of using `<>`), the language server now offers a
  code action to fix the error automatically. For example:

  ```gleam
  pub fn main() {
    "Hello, " + "Jak"
  //^^^^^^^^^^^^^^^^^ When hovering anywhere over here
  }
  ```

  Triggering the code action would fix the compilation error by using the
  correct `<>` operator instead of `+`:

  ```gleam
  pub fn main() {
    "Hello, " <> "Jak"
  }
  ```

  ([Giacomo Cavalieri](https://github.com/giacomocavalieri))

- The language server now offers the option to lift expressions into consts.
  For example, in two uses of the code action:

  ```gleam
  pub fn main() {
    [#("a", 0), #("b", 1), #("a", 2)]
    |> key_filter("a")
  }
  ```

  Becomes:

  ```gleam
  const values = [#("a", 0), #("b", 1), #("a", 2)]

  const string = "a"

  pub fn main() {
    values
    |> key_filter(string)
  }
  ```

  ([Matias Carlander](https://github.com/matiascr))

- The language server will now only offer the code action to generate a JSON
  encoder if the `gleam_json` package is installed as a dependency.
  ([Surya Rose](https://github.com/GearsDatapacks))

- The language server will offer to wrap assignment or case clause values in
  blocks. Useful when adding more expressions to an existing case clause or
  variable assignment.

  ```gleam
  pub fn f(pokemon_type: PokemonType) {
    case pokemon_type {
      Water -> soak()
      //       ^^^^^^ selecting the right-hand side of the `->` in a clause
      Fire -> burn()
    }
  }
  ```

  Becomes

  ```gleam
  pub fn f(pokemon_type: PokemonType) {
    case pokemon_type {
      Water -> {
        soak()
      }
      Fire -> burn()
    }
  }
  ```

  ([Matias Carlander](https://github.com/matiascr))

- The "Generate function" code action now uses labels or variable names to improve
  the names of generated arguments. For example:

  ```gleam
  pub fn main() {
    let language = English
    greet(language, name: "Louis")
  }
  ```

  Will generate the following function:

  ```gleam
  pub fn greet(language: String, name name: String) -> a {
    todo
  }
  ```

  ([Surya Rose](https://github.com/GearsDatapacks))

- The "Rewrite from `use`" code action now only triggers if the cursor is on the
  first line of the `use` expression to rewrite.
  ([Giacomo Cavalieri](https://github.com/giacomocavalieri))

### Formatter

### Container images

- Container images now contain Software Bill of Materials (SBoM) and SLSA
  Provenance information.
  ([Jonatan Männchen](https://github.com/maennchen))

### Bug fixes

- Fixed a bug where tuples with atoms in the first position could be
  incorrectly formatted by `echo`.
  ([Louis Pilfold](https://github.com/lpil))

- Fixed a bug where unlabelled arguments would be allowed after labelled
  arguments in variant constructor definitions.
  ([Surya Rose](https://github.com/GearsDatapacks))

- Fixed a bug where using the "Convert to pipe" code action on a function whose
  first argument is itself a pipe would result in invalid code.
  ([Giacomo Cavalieri](https://github.com/giacomocavalieri))

- Fixed a bug where using the "Convert to pipe" code action on a function or
  record capture produces invalid code.
  ([Matias Carlander](https://github.com/matiascr))

- Fixed a bug where a temporarily moved or removed file does not get recompiled,
  even though its dependencies changed in the meanwhile.
  ([Sakari Bergen](http://github.com/sbergen))

- Fixed a bug where the "Inline variable" code action would not work properly
  if used inside a record update.
  ([Surya Rose](https://github.com/GearsDatapacks))

- Fixed a bug where variant inference wouldn't work on `let assert` assignments.
  ([Giacomo Cavalieri](https://github.com/giacomocavalieri))

- Fixed a bug where the build tool could fail to lock the build directory but
  not report an error.
  ([Louis Pilfold](https://github.com/lpil))

- Fixed a bug where the language server would be too eager to recompile modules
  when it could use the cache from previous compilations.
  ([Louis Pilfold](https://github.com/lpil))

- Fixed a bug where `let assert` would not assert that the given value matched
  the pattern if it was the only expression inside a block.
  ([Surya Rose](https://github.com/GearsDatapacks))

- Fixed a bug where the code generated for `echo` on JavaScript could have name
  collisions if there are functions called `console` or `process`, or custom type
  variants called `Object` or `Deno` defined in the module.
  ([Louis Pilfold](https://github.com/lpil))

- Fixed a bug where the language server would stop working if the build
  directory was deleted e.g. as a result of `gleam clean`.
  ([Sakari Bergen](https://github.com/sbergen))

- Fixed a bug where the "Rewrite to pipe" code action could generate invalid
  code when the piped argument was a binary operation.
  ([Giacomo Cavalieri](https://github.com/giacomocavalieri))

- Fixed a bug where prelude types and values would be suggested in autocomplete
  when part of a module select.
  ([Surya Rose](https://github.com/GearsDatapacks))

- Fixed a bug where the check for multiple top-level modules when publishing
  would incorrectly print a warning.
  ([Surya Rose](https://github.com/GearsDatapacks))

## v1.9.1 - 2025-03-10

### Formatter

- Improved the formatting of pipelines printed with `echo`.
  ([Giacomo Cavalieri](https://github.com/giacomocavalieri))

### Bug fixes

- Fixed a bug where `echo` used before a pipeline would generate invalid code
  for the Erlang target.
  ([Giacomo Cavalieri](https://github.com/giacomocavalieri))
