This month is hard to characterize in terms of progress, but there certainly was some activity to write about.

## The RustWeek: Unconf

Christoph Rüßler and I got an invitation to the RustConf in Utrecht, allowing us to participate in the "Critical Infrastructure" group. The city is great, and it's easy to reach the location, overall, particularly because the Amsterdam Airport has a direct connection to Utrecht by train. That way I managed to get there at 8:57am in the morning by plane :D (I just had to get up at 2:30am to make it to the airport in Berlin which is much harder to reach).

The first day was full of session and the most relevant topic, to me, certainly was sustainable open source development. There was one crucial session about this with a lot of valuable insights being shared. Everything I got from that and other sessions can be found [in this discussion](https://github.com/GitoxideLabs/gitoxide/discussions/2015).

Was there any specific outcome? Frankly, I don't know as I did not feel that I can contribute anything of substance and quickly decided to roam around to meet and see people.

On the second day I had a crucial conversation with Erik and Folkert from the Trifecta Foundation to see how a Sovereign Tech Fund application could benefit `gitoxide` and `zlib-rs`. Let's just say that I really, *really* want to finish this application now to accelerate `gitoxide` development.

## Precious Files - now opt-in

As you may recall, `gix clean` proudly respects precious files, a feature I simply don't want to live without anymore. Previously it was enabled by default because it was deemed unlikely this is ever going to cause trouble. But trouble did it cause nonetheless.

The reason for this is simple: those who wanted to ignore a certain `$houdini` folder, a folder that isn't easy to interact with in a typical bash thanks to the `$` prefix, would put `$houdini` into their `.gitignore`. Git will now ignore the folder, and all is well. Any `gitoxide` powered application though would see `$`, and act like `houdini` is precious. This would lead to the side effect that `$houdini` wasn't actually ignored.

This was fixed by deactivating parser support for this by default, while allowing to enable it with the `gitoxide.parsePrecious` configuration variable, or alternatively, by setting `GIX_PARSE_PRECIOUS=1`.

`gix` - the CLI - will of course still parse precious files by default, but it's trivially turned off by the means above.

## Round-Tripping for Author and Committer in Commits

Thanks to Pierre Chevalier it became evident that parsing some commits and re-serialising them didn't produce the same result as the parsing was lossy. Thus, the conversion from bytes-buffer to `CommitRef` to `Commit` and back to bytes wasn't producing the same byte buffer as one might hope.

The solution was to clearly define the properties of the `*Ref` object types, as possibly leniently parsed objects which also do their best to be lossless. Only during deserialization will we leniently decode them, and possibly loose information in the process.

This also means that now generally the conversion from bytes-buffer to `CommitRef` and back to a bytes-buffer is lossless, as long as one doesn't involve the owned `Commit` type.

Doing so also meant that the `gix_date::Time` structure could finally be relieved of its `sign` field, a left-over of the times when decoded types had to try to be as lossless as possible.

It's notable that file-modes in trees are still decoded while trying to deal with one particular quirk even in the decoded form. There is probably no need to change that, but if things get more complex it should be possible to apply the same 'technique' to the `TreeRef` as well. I do have hope though that this won't ever be necessary.

## Community

### Gix Blame - as correct as it gets without rename tracking

There has been some work by Christoph Rüßler which led to `gix blame` to finally be as correct as it gets, thanks to one bugfix which, now that I look at it, somehow hasn't landed yet.

In theory though, in conjunction with ongoing community-work to bring Git-style hunk post-processing, blamed files that don't require rename tracking should come out exactly like the ones in Git, at comparable, albeit still slower, speeds. 

And what's best is that more work is on the way which makes the implementation more cache-friendly. That way duplicate computation can be avoided on a per-file basis which should help tooling tremendously. Imagine a tool drilling into the history of a single file, allowing to go back and forth in history fluently as it only recomputes what's needed between checkpoints.

This also means that it would *just* need to deal with rename tracking to achieve Git-level quality - that day can't come soon enough.

### Gix in Cargo

Thanks to the Unconf I could drop in on the Cargo team swiftly talked myself into relieving my guilty conscience by finally integrating `gix statu` into `cargo package`.
[The PR](https://github.com/rust-lang/cargo/pull/15534) was brought up a couple of hours later and finished (in its first revision) just two days later.
And I think `gitoxide` can be very impactful there as the implementation will fix a couple of long-standing [performance](https://github.com/rust-lang/cargo/issues/14955)
and correctness issues (particularly the one I have been seeing with ignored files being considered dirty).

This also means the next step for Cargo can be taken once there is a `git reset` implementation, something I'd expect to improve the performance of checkouts of Git dependencies.

Cheers
Sebastian

PS: The latest timesheets can be found [here (2025)](https://github.com/Byron/byron/blob/main/timesheets/2025.csv). 