#![forbid(unsafe_code)]
#![warn(trivial_casts, unused_lifetimes, unused_qualifications)]
//! This library consists of all of the things fif needs to run. It only exists as a library to separate code, and to
//! make testing a bit easier. I don't recommend using this as a library for your crate, as it may have breaking
//! changes without incrementing the major version, as it's really only meant to be a place for fif's internals to live.

pub mod files;
pub mod findings;
pub mod formats;
pub mod mime_db;
pub mod parameters;
pub mod utils;

use cfg_if::cfg_if;
use once_cell::sync::Lazy;

use crate::findings::Findings;
use crate::mime_db::MimeDb;

cfg_if! {
	if #[cfg(not(all(target_endian = "big", target_pointer_width = "32")))] {
		// most architectures
		pub use smartstring::alias::String;
	} else {
		// powerpc and other big endian 32-bit archs
		pub use std::string::String;
	}
}

cfg_if! {
	if #[cfg(any(all(unix, feature = "infer-backend"), all(not(unix), not(feature = "xdg-mime-backend"))))] {
		/// A [Lazy] holding an instance of [mime_db::MimeDb].
		pub static MIMEDB: Lazy<mime_db::InferDb> = Lazy::new(crate::mime_db::InferDb::init);
	} else {
		/// A [Lazy] holding an instance of [mime_db::MimeDb].
		pub static MIMEDB: Lazy<mime_db::XdgDb> = Lazy::new(crate::mime_db::XdgDb::init);
	}
}
