
using namespace System.Management.Automation
using namespace System.Management.Automation.Language

Register-ArgumentCompleter -Native -CommandName 'ffsend' -ScriptBlock {
    param($wordToComplete, $commandAst, $cursorPosition)

    $commandElements = $commandAst.CommandElements
    $command = @(
        'ffsend'
        for ($i = 1; $i -lt $commandElements.Count; $i++) {
            $element = $commandElements[$i]
            if ($element -isnot [StringConstantExpressionAst] -or
                $element.StringConstantType -ne [StringConstantType]::BareWord -or
                $element.Value.StartsWith('-')) {
                break
        }
        $element.Value
    }) -join ';'

    $completions = @(switch ($command) {
        'ffsend' {
            [CompletionResult]::new('-t', 't', [CompletionResultType]::ParameterName, 'Request timeout (0 to disable)')
            [CompletionResult]::new('--timeout', 'timeout', [CompletionResultType]::ParameterName, 'Request timeout (0 to disable)')
            [CompletionResult]::new('-T', 'T', [CompletionResultType]::ParameterName, 'Transfer timeout (0 to disable)')
            [CompletionResult]::new('--transfer-timeout', 'transfer-timeout', [CompletionResultType]::ParameterName, 'Transfer timeout (0 to disable)')
            [CompletionResult]::new('-A', 'A', [CompletionResultType]::ParameterName, 'Server API version to use, ''-'' to lookup')
            [CompletionResult]::new('--api', 'api', [CompletionResultType]::ParameterName, 'Server API version to use, ''-'' to lookup')
            [CompletionResult]::new('--basic-auth', 'basic-auth', [CompletionResultType]::ParameterName, 'HTTP basic authentication credentials')
            [CompletionResult]::new('-H', 'H', [CompletionResultType]::ParameterName, 'Use the specified history file')
            [CompletionResult]::new('--history', 'history', [CompletionResultType]::ParameterName, 'Use the specified history file')
            [CompletionResult]::new('-f', 'f', [CompletionResultType]::ParameterName, 'Force the action, ignore warnings')
            [CompletionResult]::new('--force', 'force', [CompletionResultType]::ParameterName, 'Force the action, ignore warnings')
            [CompletionResult]::new('-I', 'I', [CompletionResultType]::ParameterName, 'Not interactive, do not prompt')
            [CompletionResult]::new('--no-interact', 'no-interact', [CompletionResultType]::ParameterName, 'Not interactive, do not prompt')
            [CompletionResult]::new('-y', 'y', [CompletionResultType]::ParameterName, 'Assume yes for prompts')
            [CompletionResult]::new('--yes', 'yes', [CompletionResultType]::ParameterName, 'Assume yes for prompts')
            [CompletionResult]::new('-q', 'q', [CompletionResultType]::ParameterName, 'Produce output suitable for logging and automation')
            [CompletionResult]::new('--quiet', 'quiet', [CompletionResultType]::ParameterName, 'Produce output suitable for logging and automation')
            [CompletionResult]::new('-v', 'v', [CompletionResultType]::ParameterName, 'Enable verbose information and logging')
            [CompletionResult]::new('--verbose', 'verbose', [CompletionResultType]::ParameterName, 'Enable verbose information and logging')
            [CompletionResult]::new('-i', 'i', [CompletionResultType]::ParameterName, 'Don''t update local history for actions')
            [CompletionResult]::new('--incognito', 'incognito', [CompletionResultType]::ParameterName, 'Don''t update local history for actions')
            [CompletionResult]::new('-h', 'h', [CompletionResultType]::ParameterName, 'Prints help information')
            [CompletionResult]::new('--help', 'help', [CompletionResultType]::ParameterName, 'Prints help information')
            [CompletionResult]::new('-V', 'V', [CompletionResultType]::ParameterName, 'Prints version information')
            [CompletionResult]::new('--version', 'version', [CompletionResultType]::ParameterName, 'Prints version information')
            [CompletionResult]::new('debug', 'debug', [CompletionResultType]::ParameterValue, 'View debug information')
            [CompletionResult]::new('delete', 'delete', [CompletionResultType]::ParameterValue, 'Delete a shared file')
            [CompletionResult]::new('download', 'download', [CompletionResultType]::ParameterValue, 'Download files')
            [CompletionResult]::new('exists', 'exists', [CompletionResultType]::ParameterValue, 'Check whether a remote file exists')
            [CompletionResult]::new('generate', 'generate', [CompletionResultType]::ParameterValue, 'Generate assets')
            [CompletionResult]::new('info', 'info', [CompletionResultType]::ParameterValue, 'Fetch info about a shared file')
            [CompletionResult]::new('parameters', 'parameters', [CompletionResultType]::ParameterValue, 'Change parameters of a shared file')
            [CompletionResult]::new('password', 'password', [CompletionResultType]::ParameterValue, 'Change the password of a shared file')
            [CompletionResult]::new('upload', 'upload', [CompletionResultType]::ParameterValue, 'Upload files')
            [CompletionResult]::new('version', 'version', [CompletionResultType]::ParameterValue, 'Determine the Send server version')
            [CompletionResult]::new('history', 'history', [CompletionResultType]::ParameterValue, 'View file history')
            [CompletionResult]::new('help', 'help', [CompletionResultType]::ParameterValue, 'Prints this message or the help of the given subcommand(s)')
            break
        }
        'ffsend;debug' {
            [CompletionResult]::new('-h', 'h', [CompletionResultType]::ParameterName, 'The remote host to upload to')
            [CompletionResult]::new('--host', 'host', [CompletionResultType]::ParameterName, 'The remote host to upload to')
            [CompletionResult]::new('-t', 't', [CompletionResultType]::ParameterName, 'Request timeout (0 to disable)')
            [CompletionResult]::new('--timeout', 'timeout', [CompletionResultType]::ParameterName, 'Request timeout (0 to disable)')
            [CompletionResult]::new('-T', 'T', [CompletionResultType]::ParameterName, 'Transfer timeout (0 to disable)')
            [CompletionResult]::new('--transfer-timeout', 'transfer-timeout', [CompletionResultType]::ParameterName, 'Transfer timeout (0 to disable)')
            [CompletionResult]::new('-A', 'A', [CompletionResultType]::ParameterName, 'Server API version to use, ''-'' to lookup')
            [CompletionResult]::new('--api', 'api', [CompletionResultType]::ParameterName, 'Server API version to use, ''-'' to lookup')
            [CompletionResult]::new('--basic-auth', 'basic-auth', [CompletionResultType]::ParameterName, 'HTTP basic authentication credentials')
            [CompletionResult]::new('-H', 'H', [CompletionResultType]::ParameterName, 'Use the specified history file')
            [CompletionResult]::new('--history', 'history', [CompletionResultType]::ParameterName, 'Use the specified history file')
            [CompletionResult]::new('--help', 'help', [CompletionResultType]::ParameterName, 'Prints help information')
            [CompletionResult]::new('-V', 'V', [CompletionResultType]::ParameterName, 'Prints version information')
            [CompletionResult]::new('--version', 'version', [CompletionResultType]::ParameterName, 'Prints version information')
            [CompletionResult]::new('-f', 'f', [CompletionResultType]::ParameterName, 'Force the action, ignore warnings')
            [CompletionResult]::new('--force', 'force', [CompletionResultType]::ParameterName, 'Force the action, ignore warnings')
            [CompletionResult]::new('-I', 'I', [CompletionResultType]::ParameterName, 'Not interactive, do not prompt')
            [CompletionResult]::new('--no-interact', 'no-interact', [CompletionResultType]::ParameterName, 'Not interactive, do not prompt')
            [CompletionResult]::new('-y', 'y', [CompletionResultType]::ParameterName, 'Assume yes for prompts')
            [CompletionResult]::new('--yes', 'yes', [CompletionResultType]::ParameterName, 'Assume yes for prompts')
            [CompletionResult]::new('-q', 'q', [CompletionResultType]::ParameterName, 'Produce output suitable for logging and automation')
            [CompletionResult]::new('--quiet', 'quiet', [CompletionResultType]::ParameterName, 'Produce output suitable for logging and automation')
            [CompletionResult]::new('-v', 'v', [CompletionResultType]::ParameterName, 'Enable verbose information and logging')
            [CompletionResult]::new('--verbose', 'verbose', [CompletionResultType]::ParameterName, 'Enable verbose information and logging')
            [CompletionResult]::new('-i', 'i', [CompletionResultType]::ParameterName, 'Don''t update local history for actions')
            [CompletionResult]::new('--incognito', 'incognito', [CompletionResultType]::ParameterName, 'Don''t update local history for actions')
            break
        }
        'ffsend;delete' {
            [CompletionResult]::new('-o', 'o', [CompletionResultType]::ParameterName, 'Specify the file owner token')
            [CompletionResult]::new('--owner', 'owner', [CompletionResultType]::ParameterName, 'Specify the file owner token')
            [CompletionResult]::new('-t', 't', [CompletionResultType]::ParameterName, 'Request timeout (0 to disable)')
            [CompletionResult]::new('--timeout', 'timeout', [CompletionResultType]::ParameterName, 'Request timeout (0 to disable)')
            [CompletionResult]::new('-T', 'T', [CompletionResultType]::ParameterName, 'Transfer timeout (0 to disable)')
            [CompletionResult]::new('--transfer-timeout', 'transfer-timeout', [CompletionResultType]::ParameterName, 'Transfer timeout (0 to disable)')
            [CompletionResult]::new('-A', 'A', [CompletionResultType]::ParameterName, 'Server API version to use, ''-'' to lookup')
            [CompletionResult]::new('--api', 'api', [CompletionResultType]::ParameterName, 'Server API version to use, ''-'' to lookup')
            [CompletionResult]::new('--basic-auth', 'basic-auth', [CompletionResultType]::ParameterName, 'HTTP basic authentication credentials')
            [CompletionResult]::new('-H', 'H', [CompletionResultType]::ParameterName, 'Use the specified history file')
            [CompletionResult]::new('--history', 'history', [CompletionResultType]::ParameterName, 'Use the specified history file')
            [CompletionResult]::new('-h', 'h', [CompletionResultType]::ParameterName, 'Prints help information')
            [CompletionResult]::new('--help', 'help', [CompletionResultType]::ParameterName, 'Prints help information')
            [CompletionResult]::new('-V', 'V', [CompletionResultType]::ParameterName, 'Prints version information')
            [CompletionResult]::new('--version', 'version', [CompletionResultType]::ParameterName, 'Prints version information')
            [CompletionResult]::new('-f', 'f', [CompletionResultType]::ParameterName, 'Force the action, ignore warnings')
            [CompletionResult]::new('--force', 'force', [CompletionResultType]::ParameterName, 'Force the action, ignore warnings')
            [CompletionResult]::new('-I', 'I', [CompletionResultType]::ParameterName, 'Not interactive, do not prompt')
            [CompletionResult]::new('--no-interact', 'no-interact', [CompletionResultType]::ParameterName, 'Not interactive, do not prompt')
            [CompletionResult]::new('-y', 'y', [CompletionResultType]::ParameterName, 'Assume yes for prompts')
            [CompletionResult]::new('--yes', 'yes', [CompletionResultType]::ParameterName, 'Assume yes for prompts')
            [CompletionResult]::new('-q', 'q', [CompletionResultType]::ParameterName, 'Produce output suitable for logging and automation')
            [CompletionResult]::new('--quiet', 'quiet', [CompletionResultType]::ParameterName, 'Produce output suitable for logging and automation')
            [CompletionResult]::new('-v', 'v', [CompletionResultType]::ParameterName, 'Enable verbose information and logging')
            [CompletionResult]::new('--verbose', 'verbose', [CompletionResultType]::ParameterName, 'Enable verbose information and logging')
            [CompletionResult]::new('-i', 'i', [CompletionResultType]::ParameterName, 'Don''t update local history for actions')
            [CompletionResult]::new('--incognito', 'incognito', [CompletionResultType]::ParameterName, 'Don''t update local history for actions')
            break
        }
        'ffsend;download' {
            [CompletionResult]::new('-p', 'p', [CompletionResultType]::ParameterName, 'Unlock a password protected file')
            [CompletionResult]::new('--password', 'password', [CompletionResultType]::ParameterName, 'Unlock a password protected file')
            [CompletionResult]::new('-o', 'o', [CompletionResultType]::ParameterName, 'Output file or directory')
            [CompletionResult]::new('--output', 'output', [CompletionResultType]::ParameterName, 'Output file or directory')
            [CompletionResult]::new('-t', 't', [CompletionResultType]::ParameterName, 'Request timeout (0 to disable)')
            [CompletionResult]::new('--timeout', 'timeout', [CompletionResultType]::ParameterName, 'Request timeout (0 to disable)')
            [CompletionResult]::new('-T', 'T', [CompletionResultType]::ParameterName, 'Transfer timeout (0 to disable)')
            [CompletionResult]::new('--transfer-timeout', 'transfer-timeout', [CompletionResultType]::ParameterName, 'Transfer timeout (0 to disable)')
            [CompletionResult]::new('-A', 'A', [CompletionResultType]::ParameterName, 'Server API version to use, ''-'' to lookup')
            [CompletionResult]::new('--api', 'api', [CompletionResultType]::ParameterName, 'Server API version to use, ''-'' to lookup')
            [CompletionResult]::new('--basic-auth', 'basic-auth', [CompletionResultType]::ParameterName, 'HTTP basic authentication credentials')
            [CompletionResult]::new('-H', 'H', [CompletionResultType]::ParameterName, 'Use the specified history file')
            [CompletionResult]::new('--history', 'history', [CompletionResultType]::ParameterName, 'Use the specified history file')
            [CompletionResult]::new('-e', 'e', [CompletionResultType]::ParameterName, 'Extract an archived file')
            [CompletionResult]::new('--extract', 'extract', [CompletionResultType]::ParameterName, 'Extract an archived file')
            [CompletionResult]::new('-h', 'h', [CompletionResultType]::ParameterName, 'Prints help information')
            [CompletionResult]::new('--help', 'help', [CompletionResultType]::ParameterName, 'Prints help information')
            [CompletionResult]::new('-V', 'V', [CompletionResultType]::ParameterName, 'Prints version information')
            [CompletionResult]::new('--version', 'version', [CompletionResultType]::ParameterName, 'Prints version information')
            [CompletionResult]::new('-f', 'f', [CompletionResultType]::ParameterName, 'Force the action, ignore warnings')
            [CompletionResult]::new('--force', 'force', [CompletionResultType]::ParameterName, 'Force the action, ignore warnings')
            [CompletionResult]::new('-I', 'I', [CompletionResultType]::ParameterName, 'Not interactive, do not prompt')
            [CompletionResult]::new('--no-interact', 'no-interact', [CompletionResultType]::ParameterName, 'Not interactive, do not prompt')
            [CompletionResult]::new('-y', 'y', [CompletionResultType]::ParameterName, 'Assume yes for prompts')
            [CompletionResult]::new('--yes', 'yes', [CompletionResultType]::ParameterName, 'Assume yes for prompts')
            [CompletionResult]::new('-q', 'q', [CompletionResultType]::ParameterName, 'Produce output suitable for logging and automation')
            [CompletionResult]::new('--quiet', 'quiet', [CompletionResultType]::ParameterName, 'Produce output suitable for logging and automation')
            [CompletionResult]::new('-v', 'v', [CompletionResultType]::ParameterName, 'Enable verbose information and logging')
            [CompletionResult]::new('--verbose', 'verbose', [CompletionResultType]::ParameterName, 'Enable verbose information and logging')
            [CompletionResult]::new('-i', 'i', [CompletionResultType]::ParameterName, 'Don''t update local history for actions')
            [CompletionResult]::new('--incognito', 'incognito', [CompletionResultType]::ParameterName, 'Don''t update local history for actions')
            break
        }
        'ffsend;exists' {
            [CompletionResult]::new('-t', 't', [CompletionResultType]::ParameterName, 'Request timeout (0 to disable)')
            [CompletionResult]::new('--timeout', 'timeout', [CompletionResultType]::ParameterName, 'Request timeout (0 to disable)')
            [CompletionResult]::new('-T', 'T', [CompletionResultType]::ParameterName, 'Transfer timeout (0 to disable)')
            [CompletionResult]::new('--transfer-timeout', 'transfer-timeout', [CompletionResultType]::ParameterName, 'Transfer timeout (0 to disable)')
            [CompletionResult]::new('-A', 'A', [CompletionResultType]::ParameterName, 'Server API version to use, ''-'' to lookup')
            [CompletionResult]::new('--api', 'api', [CompletionResultType]::ParameterName, 'Server API version to use, ''-'' to lookup')
            [CompletionResult]::new('--basic-auth', 'basic-auth', [CompletionResultType]::ParameterName, 'HTTP basic authentication credentials')
            [CompletionResult]::new('-H', 'H', [CompletionResultType]::ParameterName, 'Use the specified history file')
            [CompletionResult]::new('--history', 'history', [CompletionResultType]::ParameterName, 'Use the specified history file')
            [CompletionResult]::new('-h', 'h', [CompletionResultType]::ParameterName, 'Prints help information')
            [CompletionResult]::new('--help', 'help', [CompletionResultType]::ParameterName, 'Prints help information')
            [CompletionResult]::new('-V', 'V', [CompletionResultType]::ParameterName, 'Prints version information')
            [CompletionResult]::new('--version', 'version', [CompletionResultType]::ParameterName, 'Prints version information')
            [CompletionResult]::new('-f', 'f', [CompletionResultType]::ParameterName, 'Force the action, ignore warnings')
            [CompletionResult]::new('--force', 'force', [CompletionResultType]::ParameterName, 'Force the action, ignore warnings')
            [CompletionResult]::new('-I', 'I', [CompletionResultType]::ParameterName, 'Not interactive, do not prompt')
            [CompletionResult]::new('--no-interact', 'no-interact', [CompletionResultType]::ParameterName, 'Not interactive, do not prompt')
            [CompletionResult]::new('-y', 'y', [CompletionResultType]::ParameterName, 'Assume yes for prompts')
            [CompletionResult]::new('--yes', 'yes', [CompletionResultType]::ParameterName, 'Assume yes for prompts')
            [CompletionResult]::new('-q', 'q', [CompletionResultType]::ParameterName, 'Produce output suitable for logging and automation')
            [CompletionResult]::new('--quiet', 'quiet', [CompletionResultType]::ParameterName, 'Produce output suitable for logging and automation')
            [CompletionResult]::new('-v', 'v', [CompletionResultType]::ParameterName, 'Enable verbose information and logging')
            [CompletionResult]::new('--verbose', 'verbose', [CompletionResultType]::ParameterName, 'Enable verbose information and logging')
            [CompletionResult]::new('-i', 'i', [CompletionResultType]::ParameterName, 'Don''t update local history for actions')
            [CompletionResult]::new('--incognito', 'incognito', [CompletionResultType]::ParameterName, 'Don''t update local history for actions')
            break
        }
        'ffsend;generate' {
            [CompletionResult]::new('-t', 't', [CompletionResultType]::ParameterName, 'Request timeout (0 to disable)')
            [CompletionResult]::new('--timeout', 'timeout', [CompletionResultType]::ParameterName, 'Request timeout (0 to disable)')
            [CompletionResult]::new('-T', 'T', [CompletionResultType]::ParameterName, 'Transfer timeout (0 to disable)')
            [CompletionResult]::new('--transfer-timeout', 'transfer-timeout', [CompletionResultType]::ParameterName, 'Transfer timeout (0 to disable)')
            [CompletionResult]::new('-A', 'A', [CompletionResultType]::ParameterName, 'Server API version to use, ''-'' to lookup')
            [CompletionResult]::new('--api', 'api', [CompletionResultType]::ParameterName, 'Server API version to use, ''-'' to lookup')
            [CompletionResult]::new('--basic-auth', 'basic-auth', [CompletionResultType]::ParameterName, 'HTTP basic authentication credentials')
            [CompletionResult]::new('-H', 'H', [CompletionResultType]::ParameterName, 'Use the specified history file')
            [CompletionResult]::new('--history', 'history', [CompletionResultType]::ParameterName, 'Use the specified history file')
            [CompletionResult]::new('-h', 'h', [CompletionResultType]::ParameterName, 'Prints help information')
            [CompletionResult]::new('--help', 'help', [CompletionResultType]::ParameterName, 'Prints help information')
            [CompletionResult]::new('-V', 'V', [CompletionResultType]::ParameterName, 'Prints version information')
            [CompletionResult]::new('--version', 'version', [CompletionResultType]::ParameterName, 'Prints version information')
            [CompletionResult]::new('-f', 'f', [CompletionResultType]::ParameterName, 'Force the action, ignore warnings')
            [CompletionResult]::new('--force', 'force', [CompletionResultType]::ParameterName, 'Force the action, ignore warnings')
            [CompletionResult]::new('-I', 'I', [CompletionResultType]::ParameterName, 'Not interactive, do not prompt')
            [CompletionResult]::new('--no-interact', 'no-interact', [CompletionResultType]::ParameterName, 'Not interactive, do not prompt')
            [CompletionResult]::new('-y', 'y', [CompletionResultType]::ParameterName, 'Assume yes for prompts')
            [CompletionResult]::new('--yes', 'yes', [CompletionResultType]::ParameterName, 'Assume yes for prompts')
            [CompletionResult]::new('-q', 'q', [CompletionResultType]::ParameterName, 'Produce output suitable for logging and automation')
            [CompletionResult]::new('--quiet', 'quiet', [CompletionResultType]::ParameterName, 'Produce output suitable for logging and automation')
            [CompletionResult]::new('-v', 'v', [CompletionResultType]::ParameterName, 'Enable verbose information and logging')
            [CompletionResult]::new('--verbose', 'verbose', [CompletionResultType]::ParameterName, 'Enable verbose information and logging')
            [CompletionResult]::new('-i', 'i', [CompletionResultType]::ParameterName, 'Don''t update local history for actions')
            [CompletionResult]::new('--incognito', 'incognito', [CompletionResultType]::ParameterName, 'Don''t update local history for actions')
            [CompletionResult]::new('completions', 'completions', [CompletionResultType]::ParameterValue, 'Shell completions')
            [CompletionResult]::new('help', 'help', [CompletionResultType]::ParameterValue, 'Prints this message or the help of the given subcommand(s)')
            break
        }
        'ffsend;generate;completions' {
            [CompletionResult]::new('-o', 'o', [CompletionResultType]::ParameterName, 'Shell completion files output directory')
            [CompletionResult]::new('--output', 'output', [CompletionResultType]::ParameterName, 'Shell completion files output directory')
            [CompletionResult]::new('-t', 't', [CompletionResultType]::ParameterName, 'Request timeout (0 to disable)')
            [CompletionResult]::new('--timeout', 'timeout', [CompletionResultType]::ParameterName, 'Request timeout (0 to disable)')
            [CompletionResult]::new('-T', 'T', [CompletionResultType]::ParameterName, 'Transfer timeout (0 to disable)')
            [CompletionResult]::new('--transfer-timeout', 'transfer-timeout', [CompletionResultType]::ParameterName, 'Transfer timeout (0 to disable)')
            [CompletionResult]::new('-A', 'A', [CompletionResultType]::ParameterName, 'Server API version to use, ''-'' to lookup')
            [CompletionResult]::new('--api', 'api', [CompletionResultType]::ParameterName, 'Server API version to use, ''-'' to lookup')
            [CompletionResult]::new('--basic-auth', 'basic-auth', [CompletionResultType]::ParameterName, 'HTTP basic authentication credentials')
            [CompletionResult]::new('-H', 'H', [CompletionResultType]::ParameterName, 'Use the specified history file')
            [CompletionResult]::new('--history', 'history', [CompletionResultType]::ParameterName, 'Use the specified history file')
            [CompletionResult]::new('-h', 'h', [CompletionResultType]::ParameterName, 'Prints help information')
            [CompletionResult]::new('--help', 'help', [CompletionResultType]::ParameterName, 'Prints help information')
            [CompletionResult]::new('-V', 'V', [CompletionResultType]::ParameterName, 'Prints version information')
            [CompletionResult]::new('--version', 'version', [CompletionResultType]::ParameterName, 'Prints version information')
            [CompletionResult]::new('-f', 'f', [CompletionResultType]::ParameterName, 'Force the action, ignore warnings')
            [CompletionResult]::new('--force', 'force', [CompletionResultType]::ParameterName, 'Force the action, ignore warnings')
            [CompletionResult]::new('-I', 'I', [CompletionResultType]::ParameterName, 'Not interactive, do not prompt')
            [CompletionResult]::new('--no-interact', 'no-interact', [CompletionResultType]::ParameterName, 'Not interactive, do not prompt')
            [CompletionResult]::new('-y', 'y', [CompletionResultType]::ParameterName, 'Assume yes for prompts')
            [CompletionResult]::new('--yes', 'yes', [CompletionResultType]::ParameterName, 'Assume yes for prompts')
            [CompletionResult]::new('-q', 'q', [CompletionResultType]::ParameterName, 'Produce output suitable for logging and automation')
            [CompletionResult]::new('--quiet', 'quiet', [CompletionResultType]::ParameterName, 'Produce output suitable for logging and automation')
            [CompletionResult]::new('-v', 'v', [CompletionResultType]::ParameterName, 'Enable verbose information and logging')
            [CompletionResult]::new('--verbose', 'verbose', [CompletionResultType]::ParameterName, 'Enable verbose information and logging')
            [CompletionResult]::new('-i', 'i', [CompletionResultType]::ParameterName, 'Don''t update local history for actions')
            [CompletionResult]::new('--incognito', 'incognito', [CompletionResultType]::ParameterName, 'Don''t update local history for actions')
            break
        }
        'ffsend;generate;help' {
            [CompletionResult]::new('-t', 't', [CompletionResultType]::ParameterName, 'Request timeout (0 to disable)')
            [CompletionResult]::new('--timeout', 'timeout', [CompletionResultType]::ParameterName, 'Request timeout (0 to disable)')
            [CompletionResult]::new('-T', 'T', [CompletionResultType]::ParameterName, 'Transfer timeout (0 to disable)')
            [CompletionResult]::new('--transfer-timeout', 'transfer-timeout', [CompletionResultType]::ParameterName, 'Transfer timeout (0 to disable)')
            [CompletionResult]::new('-A', 'A', [CompletionResultType]::ParameterName, 'Server API version to use, ''-'' to lookup')
            [CompletionResult]::new('--api', 'api', [CompletionResultType]::ParameterName, 'Server API version to use, ''-'' to lookup')
            [CompletionResult]::new('--basic-auth', 'basic-auth', [CompletionResultType]::ParameterName, 'HTTP basic authentication credentials')
            [CompletionResult]::new('-H', 'H', [CompletionResultType]::ParameterName, 'Use the specified history file')
            [CompletionResult]::new('--history', 'history', [CompletionResultType]::ParameterName, 'Use the specified history file')
            [CompletionResult]::new('-h', 'h', [CompletionResultType]::ParameterName, 'Prints help information')
            [CompletionResult]::new('--help', 'help', [CompletionResultType]::ParameterName, 'Prints help information')
            [CompletionResult]::new('-V', 'V', [CompletionResultType]::ParameterName, 'Prints version information')
            [CompletionResult]::new('--version', 'version', [CompletionResultType]::ParameterName, 'Prints version information')
            [CompletionResult]::new('-f', 'f', [CompletionResultType]::ParameterName, 'Force the action, ignore warnings')
            [CompletionResult]::new('--force', 'force', [CompletionResultType]::ParameterName, 'Force the action, ignore warnings')
            [CompletionResult]::new('-I', 'I', [CompletionResultType]::ParameterName, 'Not interactive, do not prompt')
            [CompletionResult]::new('--no-interact', 'no-interact', [CompletionResultType]::ParameterName, 'Not interactive, do not prompt')
            [CompletionResult]::new('-y', 'y', [CompletionResultType]::ParameterName, 'Assume yes for prompts')
            [CompletionResult]::new('--yes', 'yes', [CompletionResultType]::ParameterName, 'Assume yes for prompts')
            [CompletionResult]::new('-q', 'q', [CompletionResultType]::ParameterName, 'Produce output suitable for logging and automation')
            [CompletionResult]::new('--quiet', 'quiet', [CompletionResultType]::ParameterName, 'Produce output suitable for logging and automation')
            [CompletionResult]::new('-v', 'v', [CompletionResultType]::ParameterName, 'Enable verbose information and logging')
            [CompletionResult]::new('--verbose', 'verbose', [CompletionResultType]::ParameterName, 'Enable verbose information and logging')
            [CompletionResult]::new('-i', 'i', [CompletionResultType]::ParameterName, 'Don''t update local history for actions')
            [CompletionResult]::new('--incognito', 'incognito', [CompletionResultType]::ParameterName, 'Don''t update local history for actions')
            break
        }
        'ffsend;info' {
            [CompletionResult]::new('-o', 'o', [CompletionResultType]::ParameterName, 'Specify the file owner token')
            [CompletionResult]::new('--owner', 'owner', [CompletionResultType]::ParameterName, 'Specify the file owner token')
            [CompletionResult]::new('-p', 'p', [CompletionResultType]::ParameterName, 'Unlock a password protected file')
            [CompletionResult]::new('--password', 'password', [CompletionResultType]::ParameterName, 'Unlock a password protected file')
            [CompletionResult]::new('-t', 't', [CompletionResultType]::ParameterName, 'Request timeout (0 to disable)')
            [CompletionResult]::new('--timeout', 'timeout', [CompletionResultType]::ParameterName, 'Request timeout (0 to disable)')
            [CompletionResult]::new('-T', 'T', [CompletionResultType]::ParameterName, 'Transfer timeout (0 to disable)')
            [CompletionResult]::new('--transfer-timeout', 'transfer-timeout', [CompletionResultType]::ParameterName, 'Transfer timeout (0 to disable)')
            [CompletionResult]::new('-A', 'A', [CompletionResultType]::ParameterName, 'Server API version to use, ''-'' to lookup')
            [CompletionResult]::new('--api', 'api', [CompletionResultType]::ParameterName, 'Server API version to use, ''-'' to lookup')
            [CompletionResult]::new('--basic-auth', 'basic-auth', [CompletionResultType]::ParameterName, 'HTTP basic authentication credentials')
            [CompletionResult]::new('-H', 'H', [CompletionResultType]::ParameterName, 'Use the specified history file')
            [CompletionResult]::new('--history', 'history', [CompletionResultType]::ParameterName, 'Use the specified history file')
            [CompletionResult]::new('-h', 'h', [CompletionResultType]::ParameterName, 'Prints help information')
            [CompletionResult]::new('--help', 'help', [CompletionResultType]::ParameterName, 'Prints help information')
            [CompletionResult]::new('-V', 'V', [CompletionResultType]::ParameterName, 'Prints version information')
            [CompletionResult]::new('--version', 'version', [CompletionResultType]::ParameterName, 'Prints version information')
            [CompletionResult]::new('-f', 'f', [CompletionResultType]::ParameterName, 'Force the action, ignore warnings')
            [CompletionResult]::new('--force', 'force', [CompletionResultType]::ParameterName, 'Force the action, ignore warnings')
            [CompletionResult]::new('-I', 'I', [CompletionResultType]::ParameterName, 'Not interactive, do not prompt')
            [CompletionResult]::new('--no-interact', 'no-interact', [CompletionResultType]::ParameterName, 'Not interactive, do not prompt')
            [CompletionResult]::new('-y', 'y', [CompletionResultType]::ParameterName, 'Assume yes for prompts')
            [CompletionResult]::new('--yes', 'yes', [CompletionResultType]::ParameterName, 'Assume yes for prompts')
            [CompletionResult]::new('-q', 'q', [CompletionResultType]::ParameterName, 'Produce output suitable for logging and automation')
            [CompletionResult]::new('--quiet', 'quiet', [CompletionResultType]::ParameterName, 'Produce output suitable for logging and automation')
            [CompletionResult]::new('-v', 'v', [CompletionResultType]::ParameterName, 'Enable verbose information and logging')
            [CompletionResult]::new('--verbose', 'verbose', [CompletionResultType]::ParameterName, 'Enable verbose information and logging')
            [CompletionResult]::new('-i', 'i', [CompletionResultType]::ParameterName, 'Don''t update local history for actions')
            [CompletionResult]::new('--incognito', 'incognito', [CompletionResultType]::ParameterName, 'Don''t update local history for actions')
            break
        }
        'ffsend;parameters' {
            [CompletionResult]::new('-o', 'o', [CompletionResultType]::ParameterName, 'Specify the file owner token')
            [CompletionResult]::new('--owner', 'owner', [CompletionResultType]::ParameterName, 'Specify the file owner token')
            [CompletionResult]::new('-d', 'd', [CompletionResultType]::ParameterName, 'The file download limit')
            [CompletionResult]::new('--download-limit', 'download-limit', [CompletionResultType]::ParameterName, 'The file download limit')
            [CompletionResult]::new('-t', 't', [CompletionResultType]::ParameterName, 'Request timeout (0 to disable)')
            [CompletionResult]::new('--timeout', 'timeout', [CompletionResultType]::ParameterName, 'Request timeout (0 to disable)')
            [CompletionResult]::new('-T', 'T', [CompletionResultType]::ParameterName, 'Transfer timeout (0 to disable)')
            [CompletionResult]::new('--transfer-timeout', 'transfer-timeout', [CompletionResultType]::ParameterName, 'Transfer timeout (0 to disable)')
            [CompletionResult]::new('-A', 'A', [CompletionResultType]::ParameterName, 'Server API version to use, ''-'' to lookup')
            [CompletionResult]::new('--api', 'api', [CompletionResultType]::ParameterName, 'Server API version to use, ''-'' to lookup')
            [CompletionResult]::new('--basic-auth', 'basic-auth', [CompletionResultType]::ParameterName, 'HTTP basic authentication credentials')
            [CompletionResult]::new('-H', 'H', [CompletionResultType]::ParameterName, 'Use the specified history file')
            [CompletionResult]::new('--history', 'history', [CompletionResultType]::ParameterName, 'Use the specified history file')
            [CompletionResult]::new('-h', 'h', [CompletionResultType]::ParameterName, 'Prints help information')
            [CompletionResult]::new('--help', 'help', [CompletionResultType]::ParameterName, 'Prints help information')
            [CompletionResult]::new('-V', 'V', [CompletionResultType]::ParameterName, 'Prints version information')
            [CompletionResult]::new('--version', 'version', [CompletionResultType]::ParameterName, 'Prints version information')
            [CompletionResult]::new('-f', 'f', [CompletionResultType]::ParameterName, 'Force the action, ignore warnings')
            [CompletionResult]::new('--force', 'force', [CompletionResultType]::ParameterName, 'Force the action, ignore warnings')
            [CompletionResult]::new('-I', 'I', [CompletionResultType]::ParameterName, 'Not interactive, do not prompt')
            [CompletionResult]::new('--no-interact', 'no-interact', [CompletionResultType]::ParameterName, 'Not interactive, do not prompt')
            [CompletionResult]::new('-y', 'y', [CompletionResultType]::ParameterName, 'Assume yes for prompts')
            [CompletionResult]::new('--yes', 'yes', [CompletionResultType]::ParameterName, 'Assume yes for prompts')
            [CompletionResult]::new('-q', 'q', [CompletionResultType]::ParameterName, 'Produce output suitable for logging and automation')
            [CompletionResult]::new('--quiet', 'quiet', [CompletionResultType]::ParameterName, 'Produce output suitable for logging and automation')
            [CompletionResult]::new('-v', 'v', [CompletionResultType]::ParameterName, 'Enable verbose information and logging')
            [CompletionResult]::new('--verbose', 'verbose', [CompletionResultType]::ParameterName, 'Enable verbose information and logging')
            [CompletionResult]::new('-i', 'i', [CompletionResultType]::ParameterName, 'Don''t update local history for actions')
            [CompletionResult]::new('--incognito', 'incognito', [CompletionResultType]::ParameterName, 'Don''t update local history for actions')
            break
        }
        'ffsend;password' {
            [CompletionResult]::new('-p', 'p', [CompletionResultType]::ParameterName, 'Specify a password, do not prompt')
            [CompletionResult]::new('--password', 'password', [CompletionResultType]::ParameterName, 'Specify a password, do not prompt')
            [CompletionResult]::new('-o', 'o', [CompletionResultType]::ParameterName, 'Specify the file owner token')
            [CompletionResult]::new('--owner', 'owner', [CompletionResultType]::ParameterName, 'Specify the file owner token')
            [CompletionResult]::new('-t', 't', [CompletionResultType]::ParameterName, 'Request timeout (0 to disable)')
            [CompletionResult]::new('--timeout', 'timeout', [CompletionResultType]::ParameterName, 'Request timeout (0 to disable)')
            [CompletionResult]::new('-T', 'T', [CompletionResultType]::ParameterName, 'Transfer timeout (0 to disable)')
            [CompletionResult]::new('--transfer-timeout', 'transfer-timeout', [CompletionResultType]::ParameterName, 'Transfer timeout (0 to disable)')
            [CompletionResult]::new('-A', 'A', [CompletionResultType]::ParameterName, 'Server API version to use, ''-'' to lookup')
            [CompletionResult]::new('--api', 'api', [CompletionResultType]::ParameterName, 'Server API version to use, ''-'' to lookup')
            [CompletionResult]::new('--basic-auth', 'basic-auth', [CompletionResultType]::ParameterName, 'HTTP basic authentication credentials')
            [CompletionResult]::new('-H', 'H', [CompletionResultType]::ParameterName, 'Use the specified history file')
            [CompletionResult]::new('--history', 'history', [CompletionResultType]::ParameterName, 'Use the specified history file')
            [CompletionResult]::new('-P', 'P', [CompletionResultType]::ParameterName, 'Protect the file with a generated passphrase')
            [CompletionResult]::new('--gen-passphrase', 'gen-passphrase', [CompletionResultType]::ParameterName, 'Protect the file with a generated passphrase')
            [CompletionResult]::new('-h', 'h', [CompletionResultType]::ParameterName, 'Prints help information')
            [CompletionResult]::new('--help', 'help', [CompletionResultType]::ParameterName, 'Prints help information')
            [CompletionResult]::new('-V', 'V', [CompletionResultType]::ParameterName, 'Prints version information')
            [CompletionResult]::new('--version', 'version', [CompletionResultType]::ParameterName, 'Prints version information')
            [CompletionResult]::new('-f', 'f', [CompletionResultType]::ParameterName, 'Force the action, ignore warnings')
            [CompletionResult]::new('--force', 'force', [CompletionResultType]::ParameterName, 'Force the action, ignore warnings')
            [CompletionResult]::new('-I', 'I', [CompletionResultType]::ParameterName, 'Not interactive, do not prompt')
            [CompletionResult]::new('--no-interact', 'no-interact', [CompletionResultType]::ParameterName, 'Not interactive, do not prompt')
            [CompletionResult]::new('-y', 'y', [CompletionResultType]::ParameterName, 'Assume yes for prompts')
            [CompletionResult]::new('--yes', 'yes', [CompletionResultType]::ParameterName, 'Assume yes for prompts')
            [CompletionResult]::new('-q', 'q', [CompletionResultType]::ParameterName, 'Produce output suitable for logging and automation')
            [CompletionResult]::new('--quiet', 'quiet', [CompletionResultType]::ParameterName, 'Produce output suitable for logging and automation')
            [CompletionResult]::new('-v', 'v', [CompletionResultType]::ParameterName, 'Enable verbose information and logging')
            [CompletionResult]::new('--verbose', 'verbose', [CompletionResultType]::ParameterName, 'Enable verbose information and logging')
            [CompletionResult]::new('-i', 'i', [CompletionResultType]::ParameterName, 'Don''t update local history for actions')
            [CompletionResult]::new('--incognito', 'incognito', [CompletionResultType]::ParameterName, 'Don''t update local history for actions')
            break
        }
        'ffsend;upload' {
            [CompletionResult]::new('-p', 'p', [CompletionResultType]::ParameterName, 'Protect the file with a password')
            [CompletionResult]::new('--password', 'password', [CompletionResultType]::ParameterName, 'Protect the file with a password')
            [CompletionResult]::new('-d', 'd', [CompletionResultType]::ParameterName, 'The file download limit')
            [CompletionResult]::new('--download-limit', 'download-limit', [CompletionResultType]::ParameterName, 'The file download limit')
            [CompletionResult]::new('-e', 'e', [CompletionResultType]::ParameterName, 'The file expiry time')
            [CompletionResult]::new('--expiry-time', 'expiry-time', [CompletionResultType]::ParameterName, 'The file expiry time')
            [CompletionResult]::new('-h', 'h', [CompletionResultType]::ParameterName, 'The remote host to upload to')
            [CompletionResult]::new('--host', 'host', [CompletionResultType]::ParameterName, 'The remote host to upload to')
            [CompletionResult]::new('-n', 'n', [CompletionResultType]::ParameterName, 'Rename the file being uploaded')
            [CompletionResult]::new('--name', 'name', [CompletionResultType]::ParameterName, 'Rename the file being uploaded')
            [CompletionResult]::new('-t', 't', [CompletionResultType]::ParameterName, 'Request timeout (0 to disable)')
            [CompletionResult]::new('--timeout', 'timeout', [CompletionResultType]::ParameterName, 'Request timeout (0 to disable)')
            [CompletionResult]::new('-T', 'T', [CompletionResultType]::ParameterName, 'Transfer timeout (0 to disable)')
            [CompletionResult]::new('--transfer-timeout', 'transfer-timeout', [CompletionResultType]::ParameterName, 'Transfer timeout (0 to disable)')
            [CompletionResult]::new('-A', 'A', [CompletionResultType]::ParameterName, 'Server API version to use, ''-'' to lookup')
            [CompletionResult]::new('--api', 'api', [CompletionResultType]::ParameterName, 'Server API version to use, ''-'' to lookup')
            [CompletionResult]::new('--basic-auth', 'basic-auth', [CompletionResultType]::ParameterName, 'HTTP basic authentication credentials')
            [CompletionResult]::new('-H', 'H', [CompletionResultType]::ParameterName, 'Use the specified history file')
            [CompletionResult]::new('--history', 'history', [CompletionResultType]::ParameterName, 'Use the specified history file')
            [CompletionResult]::new('-P', 'P', [CompletionResultType]::ParameterName, 'Protect the file with a generated passphrase')
            [CompletionResult]::new('--gen-passphrase', 'gen-passphrase', [CompletionResultType]::ParameterName, 'Protect the file with a generated passphrase')
            [CompletionResult]::new('-o', 'o', [CompletionResultType]::ParameterName, 'Open the share link in your browser')
            [CompletionResult]::new('--open', 'open', [CompletionResultType]::ParameterName, 'Open the share link in your browser')
            [CompletionResult]::new('-D', 'D', [CompletionResultType]::ParameterName, 'Delete local file after upload')
            [CompletionResult]::new('--delete', 'delete', [CompletionResultType]::ParameterName, 'Delete local file after upload')
            [CompletionResult]::new('-a', 'a', [CompletionResultType]::ParameterName, 'Archive the upload in a single file')
            [CompletionResult]::new('--archive', 'archive', [CompletionResultType]::ParameterName, 'Archive the upload in a single file')
            [CompletionResult]::new('-c', 'c', [CompletionResultType]::ParameterName, 'Copy the share link to your clipboard')
            [CompletionResult]::new('--copy', 'copy', [CompletionResultType]::ParameterName, 'Copy the share link to your clipboard')
            [CompletionResult]::new('-C', 'C', [CompletionResultType]::ParameterName, 'Copy the ffsend download command to your clipboard')
            [CompletionResult]::new('--copy-cmd', 'copy-cmd', [CompletionResultType]::ParameterName, 'Copy the ffsend download command to your clipboard')
            [CompletionResult]::new('-S', 'S', [CompletionResultType]::ParameterName, 'Shorten share URLs with a public service')
            [CompletionResult]::new('--shorten', 'shorten', [CompletionResultType]::ParameterName, 'Shorten share URLs with a public service')
            [CompletionResult]::new('-Q', 'Q', [CompletionResultType]::ParameterName, 'Print a QR code for the share URL')
            [CompletionResult]::new('--qrcode', 'qrcode', [CompletionResultType]::ParameterName, 'Print a QR code for the share URL')
            [CompletionResult]::new('--help', 'help', [CompletionResultType]::ParameterName, 'Prints help information')
            [CompletionResult]::new('-V', 'V', [CompletionResultType]::ParameterName, 'Prints version information')
            [CompletionResult]::new('--version', 'version', [CompletionResultType]::ParameterName, 'Prints version information')
            [CompletionResult]::new('-f', 'f', [CompletionResultType]::ParameterName, 'Force the action, ignore warnings')
            [CompletionResult]::new('--force', 'force', [CompletionResultType]::ParameterName, 'Force the action, ignore warnings')
            [CompletionResult]::new('-I', 'I', [CompletionResultType]::ParameterName, 'Not interactive, do not prompt')
            [CompletionResult]::new('--no-interact', 'no-interact', [CompletionResultType]::ParameterName, 'Not interactive, do not prompt')
            [CompletionResult]::new('-y', 'y', [CompletionResultType]::ParameterName, 'Assume yes for prompts')
            [CompletionResult]::new('--yes', 'yes', [CompletionResultType]::ParameterName, 'Assume yes for prompts')
            [CompletionResult]::new('-q', 'q', [CompletionResultType]::ParameterName, 'Produce output suitable for logging and automation')
            [CompletionResult]::new('--quiet', 'quiet', [CompletionResultType]::ParameterName, 'Produce output suitable for logging and automation')
            [CompletionResult]::new('-v', 'v', [CompletionResultType]::ParameterName, 'Enable verbose information and logging')
            [CompletionResult]::new('--verbose', 'verbose', [CompletionResultType]::ParameterName, 'Enable verbose information and logging')
            [CompletionResult]::new('-i', 'i', [CompletionResultType]::ParameterName, 'Don''t update local history for actions')
            [CompletionResult]::new('--incognito', 'incognito', [CompletionResultType]::ParameterName, 'Don''t update local history for actions')
            break
        }
        'ffsend;version' {
            [CompletionResult]::new('-h', 'h', [CompletionResultType]::ParameterName, 'The remote host to upload to')
            [CompletionResult]::new('--host', 'host', [CompletionResultType]::ParameterName, 'The remote host to upload to')
            [CompletionResult]::new('-t', 't', [CompletionResultType]::ParameterName, 'Request timeout (0 to disable)')
            [CompletionResult]::new('--timeout', 'timeout', [CompletionResultType]::ParameterName, 'Request timeout (0 to disable)')
            [CompletionResult]::new('-T', 'T', [CompletionResultType]::ParameterName, 'Transfer timeout (0 to disable)')
            [CompletionResult]::new('--transfer-timeout', 'transfer-timeout', [CompletionResultType]::ParameterName, 'Transfer timeout (0 to disable)')
            [CompletionResult]::new('-A', 'A', [CompletionResultType]::ParameterName, 'Server API version to use, ''-'' to lookup')
            [CompletionResult]::new('--api', 'api', [CompletionResultType]::ParameterName, 'Server API version to use, ''-'' to lookup')
            [CompletionResult]::new('--basic-auth', 'basic-auth', [CompletionResultType]::ParameterName, 'HTTP basic authentication credentials')
            [CompletionResult]::new('-H', 'H', [CompletionResultType]::ParameterName, 'Use the specified history file')
            [CompletionResult]::new('--history', 'history', [CompletionResultType]::ParameterName, 'Use the specified history file')
            [CompletionResult]::new('--help', 'help', [CompletionResultType]::ParameterName, 'Prints help information')
            [CompletionResult]::new('-V', 'V', [CompletionResultType]::ParameterName, 'Prints version information')
            [CompletionResult]::new('--version', 'version', [CompletionResultType]::ParameterName, 'Prints version information')
            [CompletionResult]::new('-f', 'f', [CompletionResultType]::ParameterName, 'Force the action, ignore warnings')
            [CompletionResult]::new('--force', 'force', [CompletionResultType]::ParameterName, 'Force the action, ignore warnings')
            [CompletionResult]::new('-I', 'I', [CompletionResultType]::ParameterName, 'Not interactive, do not prompt')
            [CompletionResult]::new('--no-interact', 'no-interact', [CompletionResultType]::ParameterName, 'Not interactive, do not prompt')
            [CompletionResult]::new('-y', 'y', [CompletionResultType]::ParameterName, 'Assume yes for prompts')
            [CompletionResult]::new('--yes', 'yes', [CompletionResultType]::ParameterName, 'Assume yes for prompts')
            [CompletionResult]::new('-q', 'q', [CompletionResultType]::ParameterName, 'Produce output suitable for logging and automation')
            [CompletionResult]::new('--quiet', 'quiet', [CompletionResultType]::ParameterName, 'Produce output suitable for logging and automation')
            [CompletionResult]::new('-v', 'v', [CompletionResultType]::ParameterName, 'Enable verbose information and logging')
            [CompletionResult]::new('--verbose', 'verbose', [CompletionResultType]::ParameterName, 'Enable verbose information and logging')
            [CompletionResult]::new('-i', 'i', [CompletionResultType]::ParameterName, 'Don''t update local history for actions')
            [CompletionResult]::new('--incognito', 'incognito', [CompletionResultType]::ParameterName, 'Don''t update local history for actions')
            break
        }
        'ffsend;history' {
            [CompletionResult]::new('-R', 'R', [CompletionResultType]::ParameterName, 'Remove history entry')
            [CompletionResult]::new('--rm', 'rm', [CompletionResultType]::ParameterName, 'Remove history entry')
            [CompletionResult]::new('-t', 't', [CompletionResultType]::ParameterName, 'Request timeout (0 to disable)')
            [CompletionResult]::new('--timeout', 'timeout', [CompletionResultType]::ParameterName, 'Request timeout (0 to disable)')
            [CompletionResult]::new('-T', 'T', [CompletionResultType]::ParameterName, 'Transfer timeout (0 to disable)')
            [CompletionResult]::new('--transfer-timeout', 'transfer-timeout', [CompletionResultType]::ParameterName, 'Transfer timeout (0 to disable)')
            [CompletionResult]::new('-A', 'A', [CompletionResultType]::ParameterName, 'Server API version to use, ''-'' to lookup')
            [CompletionResult]::new('--api', 'api', [CompletionResultType]::ParameterName, 'Server API version to use, ''-'' to lookup')
            [CompletionResult]::new('--basic-auth', 'basic-auth', [CompletionResultType]::ParameterName, 'HTTP basic authentication credentials')
            [CompletionResult]::new('-H', 'H', [CompletionResultType]::ParameterName, 'Use the specified history file')
            [CompletionResult]::new('--history', 'history', [CompletionResultType]::ParameterName, 'Use the specified history file')
            [CompletionResult]::new('-C', 'C', [CompletionResultType]::ParameterName, 'Clear all history')
            [CompletionResult]::new('--clear', 'clear', [CompletionResultType]::ParameterName, 'Clear all history')
            [CompletionResult]::new('-h', 'h', [CompletionResultType]::ParameterName, 'Prints help information')
            [CompletionResult]::new('--help', 'help', [CompletionResultType]::ParameterName, 'Prints help information')
            [CompletionResult]::new('-V', 'V', [CompletionResultType]::ParameterName, 'Prints version information')
            [CompletionResult]::new('--version', 'version', [CompletionResultType]::ParameterName, 'Prints version information')
            [CompletionResult]::new('-f', 'f', [CompletionResultType]::ParameterName, 'Force the action, ignore warnings')
            [CompletionResult]::new('--force', 'force', [CompletionResultType]::ParameterName, 'Force the action, ignore warnings')
            [CompletionResult]::new('-I', 'I', [CompletionResultType]::ParameterName, 'Not interactive, do not prompt')
            [CompletionResult]::new('--no-interact', 'no-interact', [CompletionResultType]::ParameterName, 'Not interactive, do not prompt')
            [CompletionResult]::new('-y', 'y', [CompletionResultType]::ParameterName, 'Assume yes for prompts')
            [CompletionResult]::new('--yes', 'yes', [CompletionResultType]::ParameterName, 'Assume yes for prompts')
            [CompletionResult]::new('-q', 'q', [CompletionResultType]::ParameterName, 'Produce output suitable for logging and automation')
            [CompletionResult]::new('--quiet', 'quiet', [CompletionResultType]::ParameterName, 'Produce output suitable for logging and automation')
            [CompletionResult]::new('-v', 'v', [CompletionResultType]::ParameterName, 'Enable verbose information and logging')
            [CompletionResult]::new('--verbose', 'verbose', [CompletionResultType]::ParameterName, 'Enable verbose information and logging')
            [CompletionResult]::new('-i', 'i', [CompletionResultType]::ParameterName, 'Don''t update local history for actions')
            [CompletionResult]::new('--incognito', 'incognito', [CompletionResultType]::ParameterName, 'Don''t update local history for actions')
            break
        }
        'ffsend;help' {
            [CompletionResult]::new('-t', 't', [CompletionResultType]::ParameterName, 'Request timeout (0 to disable)')
            [CompletionResult]::new('--timeout', 'timeout', [CompletionResultType]::ParameterName, 'Request timeout (0 to disable)')
            [CompletionResult]::new('-T', 'T', [CompletionResultType]::ParameterName, 'Transfer timeout (0 to disable)')
            [CompletionResult]::new('--transfer-timeout', 'transfer-timeout', [CompletionResultType]::ParameterName, 'Transfer timeout (0 to disable)')
            [CompletionResult]::new('-A', 'A', [CompletionResultType]::ParameterName, 'Server API version to use, ''-'' to lookup')
            [CompletionResult]::new('--api', 'api', [CompletionResultType]::ParameterName, 'Server API version to use, ''-'' to lookup')
            [CompletionResult]::new('--basic-auth', 'basic-auth', [CompletionResultType]::ParameterName, 'HTTP basic authentication credentials')
            [CompletionResult]::new('-H', 'H', [CompletionResultType]::ParameterName, 'Use the specified history file')
            [CompletionResult]::new('--history', 'history', [CompletionResultType]::ParameterName, 'Use the specified history file')
            [CompletionResult]::new('-h', 'h', [CompletionResultType]::ParameterName, 'Prints help information')
            [CompletionResult]::new('--help', 'help', [CompletionResultType]::ParameterName, 'Prints help information')
            [CompletionResult]::new('-V', 'V', [CompletionResultType]::ParameterName, 'Prints version information')
            [CompletionResult]::new('--version', 'version', [CompletionResultType]::ParameterName, 'Prints version information')
            [CompletionResult]::new('-f', 'f', [CompletionResultType]::ParameterName, 'Force the action, ignore warnings')
            [CompletionResult]::new('--force', 'force', [CompletionResultType]::ParameterName, 'Force the action, ignore warnings')
            [CompletionResult]::new('-I', 'I', [CompletionResultType]::ParameterName, 'Not interactive, do not prompt')
            [CompletionResult]::new('--no-interact', 'no-interact', [CompletionResultType]::ParameterName, 'Not interactive, do not prompt')
            [CompletionResult]::new('-y', 'y', [CompletionResultType]::ParameterName, 'Assume yes for prompts')
            [CompletionResult]::new('--yes', 'yes', [CompletionResultType]::ParameterName, 'Assume yes for prompts')
            [CompletionResult]::new('-q', 'q', [CompletionResultType]::ParameterName, 'Produce output suitable for logging and automation')
            [CompletionResult]::new('--quiet', 'quiet', [CompletionResultType]::ParameterName, 'Produce output suitable for logging and automation')
            [CompletionResult]::new('-v', 'v', [CompletionResultType]::ParameterName, 'Enable verbose information and logging')
            [CompletionResult]::new('--verbose', 'verbose', [CompletionResultType]::ParameterName, 'Enable verbose information and logging')
            [CompletionResult]::new('-i', 'i', [CompletionResultType]::ParameterName, 'Don''t update local history for actions')
            [CompletionResult]::new('--incognito', 'incognito', [CompletionResultType]::ParameterName, 'Don''t update local history for actions')
            break
        }
    })

    $completions.Where{ $_.CompletionText -like "$wordToComplete*" } |
        Sort-Object -Property ListItemText
}
