/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.model.quad.blender;

import me.jellysquid.mods.sodium.client.model.quad.ModelQuadView;
import me.jellysquid.mods.sodium.client.model.quad.blender.ColorBlender;
import me.jellysquid.mods.sodium.client.model.quad.blender.ColorSampler;
import me.jellysquid.mods.sodium.client.util.color.ColorARGB;
import me.jellysquid.mods.sodium.client.util.color.ColorMixer;
import net.minecraft.class_1920;
import net.minecraft.class_2338;
import net.minecraft.class_3532;

public class LinearColorBlender
implements ColorBlender {
    private final int[] cachedRet = new int[4];
    private final class_2338.class_2339 mpos = new class_2338.class_2339();

    @Override
    public <T> int[] getColors(class_1920 world, class_2338 origin, ModelQuadView quad, ColorSampler<T> sampler, T state) {
        int[] colors = this.cachedRet;
        for (int vertexIndex = 0; vertexIndex < 4; ++vertexIndex) {
            colors[vertexIndex] = this.getVertexColor(world, origin, quad, sampler, state, vertexIndex);
        }
        return colors;
    }

    private <T> int getBlockColor(class_1920 world, T state, ColorSampler<T> sampler, int x, int y, int z, int colorIdx) {
        return sampler.getColor(state, world, (class_2338)this.mpos.method_10103(x, y, z), colorIdx);
    }

    private <T> int getVertexColor(class_1920 world, class_2338 origin, ModelQuadView quad, ColorSampler<T> sampler, T state, int vertexIdx) {
        float x = class_3532.method_15363((float)quad.getX(vertexIdx), (float)-1.0f, (float)2.0f) - 0.5f;
        float y = class_3532.method_15363((float)quad.getY(vertexIdx), (float)-1.0f, (float)2.0f) - 0.5f;
        float z = class_3532.method_15363((float)quad.getZ(vertexIdx), (float)-1.0f, (float)2.0f) - 0.5f;
        int intX = (int)Math.floor(x);
        int intY = (int)Math.floor(y);
        int intZ = (int)Math.floor(z);
        int originX = origin.method_10263() + intX;
        int originY = origin.method_10264() + intY;
        int originZ = origin.method_10260() + intZ;
        int c00 = this.getBlockColor(world, state, sampler, originX, originY, originZ, quad.getColorIndex());
        int c01 = this.getBlockColor(world, state, sampler, originX, originY, originZ + 1, quad.getColorIndex());
        int c10 = this.getBlockColor(world, state, sampler, originX + 1, originY, originZ, quad.getColorIndex());
        int c11 = this.getBlockColor(world, state, sampler, originX + 1, originY, originZ + 1, quad.getColorIndex());
        float fracX = x - (float)intX;
        float fracZ = z - (float)intZ;
        int dz1 = ColorMixer.getStartRatio(fracZ);
        int dz2 = ColorMixer.getEndRatio(fracZ);
        int rz0 = ColorMixer.mixARGB(c00, c01, dz1, dz2);
        int rz1 = ColorMixer.mixARGB(c10, c11, dz1, dz2);
        int dx1 = ColorMixer.getStartRatio(fracX);
        int dx2 = ColorMixer.getEndRatio(fracX);
        int rx = ColorMixer.mixARGB(rz0, rz1, dx1, dx2);
        return ColorARGB.toABGR(rx);
    }
}

