#include "tree_sitter/parser.h"

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#define LANGUAGE_VERSION 14
#define STATE_COUNT 496
#define LARGE_STATE_COUNT 213
#define SYMBOL_COUNT 73
#define ALIAS_COUNT 0
#define TOKEN_COUNT 35
#define EXTERNAL_TOKEN_COUNT 0
#define FIELD_COUNT 11
#define MAX_ALIAS_SEQUENCE_LENGTH 6
#define PRODUCTION_ID_COUNT 43

enum ts_symbol_identifiers {
  sym__ws = 1,
  sym_comment = 2,
  anon_sym_POUND_ = 3,
  sym_num_lit = 4,
  anon_sym_SLASH = 5,
  aux_sym__kwd_leading_slash_token1 = 6,
  aux_sym__kwd_qualified_token1 = 7,
  anon_sym_COLON = 8,
  anon_sym_COLON_COLON = 9,
  aux_sym_str_lit_token1 = 10,
  sym_char_lit = 11,
  sym_nil_lit = 12,
  sym_bool_lit = 13,
  aux_sym__sym_qualified_token1 = 14,
  aux_sym__sym_qualified_token2 = 15,
  anon_sym_CARET = 16,
  anon_sym_POUND_CARET = 17,
  anon_sym_LPAREN = 18,
  anon_sym_RPAREN = 19,
  anon_sym_LBRACE = 20,
  anon_sym_RBRACE = 21,
  anon_sym_LBRACK = 22,
  anon_sym_RBRACK = 23,
  anon_sym_POUND = 24,
  anon_sym_POUND_QMARK = 25,
  anon_sym_POUND_QMARK_AT = 26,
  anon_sym_POUND_SQUOTE = 27,
  anon_sym_POUND_POUND = 28,
  anon_sym_POUND_EQ = 29,
  anon_sym_AT = 30,
  anon_sym_SQUOTE = 31,
  anon_sym_BQUOTE = 32,
  anon_sym_TILDE_AT = 33,
  anon_sym_TILDE = 34,
  sym_source = 35,
  sym__gap = 36,
  sym_dis_expr = 37,
  sym__form = 38,
  sym_kwd_lit = 39,
  sym_str_lit = 40,
  sym_sym_lit = 41,
  sym__metadata_lit = 42,
  sym_meta_lit = 43,
  sym_old_meta_lit = 44,
  sym_list_lit = 45,
  sym__bare_list_lit = 46,
  sym_map_lit = 47,
  sym__bare_map_lit = 48,
  sym_vec_lit = 49,
  sym__bare_vec_lit = 50,
  sym_set_lit = 51,
  sym__bare_set_lit = 52,
  sym_anon_fn_lit = 53,
  sym_regex_lit = 54,
  sym_read_cond_lit = 55,
  sym_splicing_read_cond_lit = 56,
  sym_auto_res_mark = 57,
  sym_ns_map_lit = 58,
  sym_var_quoting_lit = 59,
  sym_sym_val_lit = 60,
  sym_evaling_lit = 61,
  sym_tagged_or_ctor_lit = 62,
  sym_derefing_lit = 63,
  sym_quoting_lit = 64,
  sym_syn_quoting_lit = 65,
  sym_unquote_splicing_lit = 66,
  sym_unquoting_lit = 67,
  aux_sym_source_repeat1 = 68,
  aux_sym_dis_expr_repeat1 = 69,
  aux_sym_sym_lit_repeat1 = 70,
  aux_sym__bare_list_lit_repeat1 = 71,
  aux_sym_read_cond_lit_repeat1 = 72,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym__ws] = "_ws",
  [sym_comment] = "comment",
  [anon_sym_POUND_] = "#_",
  [sym_num_lit] = "num_lit",
  [anon_sym_SLASH] = "/",
  [aux_sym__kwd_leading_slash_token1] = "kwd_name",
  [aux_sym__kwd_qualified_token1] = "kwd_ns",
  [anon_sym_COLON] = ":",
  [anon_sym_COLON_COLON] = "::",
  [aux_sym_str_lit_token1] = "str_lit_token1",
  [sym_char_lit] = "char_lit",
  [sym_nil_lit] = "nil_lit",
  [sym_bool_lit] = "bool_lit",
  [aux_sym__sym_qualified_token1] = "sym_ns",
  [aux_sym__sym_qualified_token2] = "sym_name",
  [anon_sym_CARET] = "^",
  [anon_sym_POUND_CARET] = "#^",
  [anon_sym_LPAREN] = "(",
  [anon_sym_RPAREN] = ")",
  [anon_sym_LBRACE] = "{",
  [anon_sym_RBRACE] = "}",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [anon_sym_POUND] = "#",
  [anon_sym_POUND_QMARK] = "#\?",
  [anon_sym_POUND_QMARK_AT] = "#\?@",
  [anon_sym_POUND_SQUOTE] = "#'",
  [anon_sym_POUND_POUND] = "##",
  [anon_sym_POUND_EQ] = "#=",
  [anon_sym_AT] = "@",
  [anon_sym_SQUOTE] = "'",
  [anon_sym_BQUOTE] = "`",
  [anon_sym_TILDE_AT] = "~@",
  [anon_sym_TILDE] = "~",
  [sym_source] = "source",
  [sym__gap] = "_gap",
  [sym_dis_expr] = "dis_expr",
  [sym__form] = "_form",
  [sym_kwd_lit] = "kwd_lit",
  [sym_str_lit] = "str_lit",
  [sym_sym_lit] = "sym_lit",
  [sym__metadata_lit] = "_metadata_lit",
  [sym_meta_lit] = "meta_lit",
  [sym_old_meta_lit] = "old_meta_lit",
  [sym_list_lit] = "list_lit",
  [sym__bare_list_lit] = "_bare_list_lit",
  [sym_map_lit] = "map_lit",
  [sym__bare_map_lit] = "_bare_map_lit",
  [sym_vec_lit] = "vec_lit",
  [sym__bare_vec_lit] = "_bare_vec_lit",
  [sym_set_lit] = "set_lit",
  [sym__bare_set_lit] = "_bare_set_lit",
  [sym_anon_fn_lit] = "anon_fn_lit",
  [sym_regex_lit] = "regex_lit",
  [sym_read_cond_lit] = "read_cond_lit",
  [sym_splicing_read_cond_lit] = "splicing_read_cond_lit",
  [sym_auto_res_mark] = "auto_res_mark",
  [sym_ns_map_lit] = "ns_map_lit",
  [sym_var_quoting_lit] = "var_quoting_lit",
  [sym_sym_val_lit] = "sym_val_lit",
  [sym_evaling_lit] = "evaling_lit",
  [sym_tagged_or_ctor_lit] = "tagged_or_ctor_lit",
  [sym_derefing_lit] = "derefing_lit",
  [sym_quoting_lit] = "quoting_lit",
  [sym_syn_quoting_lit] = "syn_quoting_lit",
  [sym_unquote_splicing_lit] = "unquote_splicing_lit",
  [sym_unquoting_lit] = "unquoting_lit",
  [aux_sym_source_repeat1] = "source_repeat1",
  [aux_sym_dis_expr_repeat1] = "dis_expr_repeat1",
  [aux_sym_sym_lit_repeat1] = "sym_lit_repeat1",
  [aux_sym__bare_list_lit_repeat1] = "_bare_list_lit_repeat1",
  [aux_sym_read_cond_lit_repeat1] = "read_cond_lit_repeat1",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym__ws] = sym__ws,
  [sym_comment] = sym_comment,
  [anon_sym_POUND_] = anon_sym_POUND_,
  [sym_num_lit] = sym_num_lit,
  [anon_sym_SLASH] = anon_sym_SLASH,
  [aux_sym__kwd_leading_slash_token1] = aux_sym__kwd_leading_slash_token1,
  [aux_sym__kwd_qualified_token1] = aux_sym__kwd_qualified_token1,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_COLON_COLON] = anon_sym_COLON_COLON,
  [aux_sym_str_lit_token1] = aux_sym_str_lit_token1,
  [sym_char_lit] = sym_char_lit,
  [sym_nil_lit] = sym_nil_lit,
  [sym_bool_lit] = sym_bool_lit,
  [aux_sym__sym_qualified_token1] = aux_sym__sym_qualified_token1,
  [aux_sym__sym_qualified_token2] = aux_sym__sym_qualified_token2,
  [anon_sym_CARET] = anon_sym_CARET,
  [anon_sym_POUND_CARET] = anon_sym_POUND_CARET,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_POUND] = anon_sym_POUND,
  [anon_sym_POUND_QMARK] = anon_sym_POUND_QMARK,
  [anon_sym_POUND_QMARK_AT] = anon_sym_POUND_QMARK_AT,
  [anon_sym_POUND_SQUOTE] = anon_sym_POUND_SQUOTE,
  [anon_sym_POUND_POUND] = anon_sym_POUND_POUND,
  [anon_sym_POUND_EQ] = anon_sym_POUND_EQ,
  [anon_sym_AT] = anon_sym_AT,
  [anon_sym_SQUOTE] = anon_sym_SQUOTE,
  [anon_sym_BQUOTE] = anon_sym_BQUOTE,
  [anon_sym_TILDE_AT] = anon_sym_TILDE_AT,
  [anon_sym_TILDE] = anon_sym_TILDE,
  [sym_source] = sym_source,
  [sym__gap] = sym__gap,
  [sym_dis_expr] = sym_dis_expr,
  [sym__form] = sym__form,
  [sym_kwd_lit] = sym_kwd_lit,
  [sym_str_lit] = sym_str_lit,
  [sym_sym_lit] = sym_sym_lit,
  [sym__metadata_lit] = sym__metadata_lit,
  [sym_meta_lit] = sym_meta_lit,
  [sym_old_meta_lit] = sym_old_meta_lit,
  [sym_list_lit] = sym_list_lit,
  [sym__bare_list_lit] = sym__bare_list_lit,
  [sym_map_lit] = sym_map_lit,
  [sym__bare_map_lit] = sym__bare_map_lit,
  [sym_vec_lit] = sym_vec_lit,
  [sym__bare_vec_lit] = sym__bare_vec_lit,
  [sym_set_lit] = sym_set_lit,
  [sym__bare_set_lit] = sym__bare_set_lit,
  [sym_anon_fn_lit] = sym_anon_fn_lit,
  [sym_regex_lit] = sym_regex_lit,
  [sym_read_cond_lit] = sym_read_cond_lit,
  [sym_splicing_read_cond_lit] = sym_splicing_read_cond_lit,
  [sym_auto_res_mark] = sym_auto_res_mark,
  [sym_ns_map_lit] = sym_ns_map_lit,
  [sym_var_quoting_lit] = sym_var_quoting_lit,
  [sym_sym_val_lit] = sym_sym_val_lit,
  [sym_evaling_lit] = sym_evaling_lit,
  [sym_tagged_or_ctor_lit] = sym_tagged_or_ctor_lit,
  [sym_derefing_lit] = sym_derefing_lit,
  [sym_quoting_lit] = sym_quoting_lit,
  [sym_syn_quoting_lit] = sym_syn_quoting_lit,
  [sym_unquote_splicing_lit] = sym_unquote_splicing_lit,
  [sym_unquoting_lit] = sym_unquoting_lit,
  [aux_sym_source_repeat1] = aux_sym_source_repeat1,
  [aux_sym_dis_expr_repeat1] = aux_sym_dis_expr_repeat1,
  [aux_sym_sym_lit_repeat1] = aux_sym_sym_lit_repeat1,
  [aux_sym__bare_list_lit_repeat1] = aux_sym__bare_list_lit_repeat1,
  [aux_sym_read_cond_lit_repeat1] = aux_sym_read_cond_lit_repeat1,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym__ws] = {
    .visible = false,
    .named = true,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_POUND_] = {
    .visible = true,
    .named = false,
  },
  [sym_num_lit] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = false,
  },
  [aux_sym__kwd_leading_slash_token1] = {
    .visible = true,
    .named = true,
  },
  [aux_sym__kwd_qualified_token1] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON_COLON] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_str_lit_token1] = {
    .visible = false,
    .named = false,
  },
  [sym_char_lit] = {
    .visible = true,
    .named = true,
  },
  [sym_nil_lit] = {
    .visible = true,
    .named = true,
  },
  [sym_bool_lit] = {
    .visible = true,
    .named = true,
  },
  [aux_sym__sym_qualified_token1] = {
    .visible = true,
    .named = true,
  },
  [aux_sym__sym_qualified_token2] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_CARET] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_POUND_CARET] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_POUND] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_POUND_QMARK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_POUND_QMARK_AT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_POUND_SQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_POUND_POUND] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_POUND_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_TILDE_AT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_TILDE] = {
    .visible = true,
    .named = false,
  },
  [sym_source] = {
    .visible = true,
    .named = true,
  },
  [sym__gap] = {
    .visible = false,
    .named = true,
  },
  [sym_dis_expr] = {
    .visible = true,
    .named = true,
  },
  [sym__form] = {
    .visible = false,
    .named = true,
  },
  [sym_kwd_lit] = {
    .visible = true,
    .named = true,
  },
  [sym_str_lit] = {
    .visible = true,
    .named = true,
  },
  [sym_sym_lit] = {
    .visible = true,
    .named = true,
  },
  [sym__metadata_lit] = {
    .visible = false,
    .named = true,
  },
  [sym_meta_lit] = {
    .visible = true,
    .named = true,
  },
  [sym_old_meta_lit] = {
    .visible = true,
    .named = true,
  },
  [sym_list_lit] = {
    .visible = true,
    .named = true,
  },
  [sym__bare_list_lit] = {
    .visible = false,
    .named = true,
  },
  [sym_map_lit] = {
    .visible = true,
    .named = true,
  },
  [sym__bare_map_lit] = {
    .visible = false,
    .named = true,
  },
  [sym_vec_lit] = {
    .visible = true,
    .named = true,
  },
  [sym__bare_vec_lit] = {
    .visible = false,
    .named = true,
  },
  [sym_set_lit] = {
    .visible = true,
    .named = true,
  },
  [sym__bare_set_lit] = {
    .visible = false,
    .named = true,
  },
  [sym_anon_fn_lit] = {
    .visible = true,
    .named = true,
  },
  [sym_regex_lit] = {
    .visible = true,
    .named = true,
  },
  [sym_read_cond_lit] = {
    .visible = true,
    .named = true,
  },
  [sym_splicing_read_cond_lit] = {
    .visible = true,
    .named = true,
  },
  [sym_auto_res_mark] = {
    .visible = true,
    .named = true,
  },
  [sym_ns_map_lit] = {
    .visible = true,
    .named = true,
  },
  [sym_var_quoting_lit] = {
    .visible = true,
    .named = true,
  },
  [sym_sym_val_lit] = {
    .visible = true,
    .named = true,
  },
  [sym_evaling_lit] = {
    .visible = true,
    .named = true,
  },
  [sym_tagged_or_ctor_lit] = {
    .visible = true,
    .named = true,
  },
  [sym_derefing_lit] = {
    .visible = true,
    .named = true,
  },
  [sym_quoting_lit] = {
    .visible = true,
    .named = true,
  },
  [sym_syn_quoting_lit] = {
    .visible = true,
    .named = true,
  },
  [sym_unquote_splicing_lit] = {
    .visible = true,
    .named = true,
  },
  [sym_unquoting_lit] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_source_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_dis_expr_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_sym_lit_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__bare_list_lit_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_read_cond_lit_repeat1] = {
    .visible = false,
    .named = false,
  },
};

enum ts_field_identifiers {
  field_close = 1,
  field_delimiter = 2,
  field_marker = 3,
  field_meta = 4,
  field_name = 5,
  field_namespace = 6,
  field_old_meta = 7,
  field_open = 8,
  field_prefix = 9,
  field_tag = 10,
  field_value = 11,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_close] = "close",
  [field_delimiter] = "delimiter",
  [field_marker] = "marker",
  [field_meta] = "meta",
  [field_name] = "name",
  [field_namespace] = "namespace",
  [field_old_meta] = "old_meta",
  [field_open] = "open",
  [field_prefix] = "prefix",
  [field_tag] = "tag",
  [field_value] = "value",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [1] = {.index = 0, .length = 1},
  [2] = {.index = 1, .length = 2},
  [3] = {.index = 3, .length = 1},
  [4] = {.index = 4, .length = 1},
  [5] = {.index = 5, .length = 3},
  [6] = {.index = 8, .length = 4},
  [7] = {.index = 12, .length = 2},
  [8] = {.index = 14, .length = 2},
  [9] = {.index = 16, .length = 2},
  [10] = {.index = 18, .length = 1},
  [11] = {.index = 19, .length = 1},
  [12] = {.index = 20, .length = 4},
  [13] = {.index = 24, .length = 3},
  [14] = {.index = 27, .length = 5},
  [15] = {.index = 32, .length = 6},
  [16] = {.index = 38, .length = 4},
  [17] = {.index = 42, .length = 2},
  [18] = {.index = 44, .length = 3},
  [19] = {.index = 47, .length = 3},
  [20] = {.index = 50, .length = 3},
  [21] = {.index = 53, .length = 2},
  [22] = {.index = 55, .length = 3},
  [23] = {.index = 58, .length = 5},
  [24] = {.index = 63, .length = 3},
  [25] = {.index = 66, .length = 4},
  [26] = {.index = 70, .length = 6},
  [27] = {.index = 76, .length = 4},
  [28] = {.index = 80, .length = 4},
  [29] = {.index = 84, .length = 4},
  [30] = {.index = 88, .length = 5},
  [31] = {.index = 93, .length = 3},
  [32] = {.index = 96, .length = 3},
  [33] = {.index = 99, .length = 5},
  [34] = {.index = 104, .length = 7},
  [35] = {.index = 111, .length = 5},
  [36] = {.index = 116, .length = 6},
  [37] = {.index = 122, .length = 4},
  [38] = {.index = 126, .length = 3},
  [39] = {.index = 129, .length = 7},
  [40] = {.index = 136, .length = 5},
  [41] = {.index = 141, .length = 5},
  [42] = {.index = 146, .length = 5},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_name, 0},
  [1] =
    {field_meta, 0, .inherited = true},
    {field_old_meta, 0, .inherited = true},
  [3] =
    {field_meta, 0},
  [4] =
    {field_old_meta, 0},
  [5] =
    {field_close, 0, .inherited = true},
    {field_open, 0, .inherited = true},
    {field_value, 0, .inherited = true},
  [8] =
    {field_close, 0, .inherited = true},
    {field_marker, 0, .inherited = true},
    {field_open, 0, .inherited = true},
    {field_value, 0, .inherited = true},
  [12] =
    {field_marker, 0},
    {field_value, 1},
  [14] =
    {field_marker, 0},
    {field_name, 1},
  [16] =
    {field_close, 1},
    {field_open, 0},
  [18] =
    {field_value, 0},
  [19] =
    {field_marker, 0},
  [20] =
    {field_close, 1, .inherited = true},
    {field_marker, 0},
    {field_open, 1, .inherited = true},
    {field_value, 1, .inherited = true},
  [24] =
    {field_meta, 0, .inherited = true},
    {field_name, 1},
    {field_old_meta, 0, .inherited = true},
  [27] =
    {field_close, 1, .inherited = true},
    {field_meta, 0, .inherited = true},
    {field_old_meta, 0, .inherited = true},
    {field_open, 1, .inherited = true},
    {field_value, 1, .inherited = true},
  [32] =
    {field_close, 1, .inherited = true},
    {field_marker, 1, .inherited = true},
    {field_meta, 0, .inherited = true},
    {field_old_meta, 0, .inherited = true},
    {field_open, 1, .inherited = true},
    {field_value, 1, .inherited = true},
  [38] =
    {field_meta, 0, .inherited = true},
    {field_meta, 1, .inherited = true},
    {field_old_meta, 0, .inherited = true},
    {field_old_meta, 1, .inherited = true},
  [42] =
    {field_marker, 0},
    {field_value, 2},
  [44] =
    {field_delimiter, 1},
    {field_marker, 0},
    {field_name, 2},
  [47] =
    {field_delimiter, 1},
    {field_name, 2},
    {field_namespace, 0},
  [50] =
    {field_close, 2},
    {field_open, 0},
    {field_value, 1, .inherited = true},
  [53] =
    {field_value, 0, .inherited = true},
    {field_value, 1, .inherited = true},
  [55] =
    {field_close, 2},
    {field_marker, 0},
    {field_open, 1},
  [58] =
    {field_close, 2, .inherited = true},
    {field_marker, 0},
    {field_open, 2, .inherited = true},
    {field_prefix, 1},
    {field_value, 2, .inherited = true},
  [63] =
    {field_marker, 0},
    {field_tag, 1},
    {field_value, 2},
  [66] =
    {field_close, 2, .inherited = true},
    {field_marker, 0},
    {field_open, 2, .inherited = true},
    {field_value, 2, .inherited = true},
  [70] =
    {field_close, 2, .inherited = true},
    {field_marker, 1},
    {field_meta, 0, .inherited = true},
    {field_old_meta, 0, .inherited = true},
    {field_open, 2, .inherited = true},
    {field_value, 2, .inherited = true},
  [76] =
    {field_marker, 1},
    {field_meta, 0, .inherited = true},
    {field_old_meta, 0, .inherited = true},
    {field_value, 2},
  [80] =
    {field_delimiter, 2},
    {field_marker, 0},
    {field_name, 3},
    {field_namespace, 1},
  [84] =
    {field_close, 3},
    {field_marker, 0},
    {field_open, 1},
    {field_value, 2, .inherited = true},
  [88] =
    {field_close, 3, .inherited = true},
    {field_marker, 0},
    {field_open, 3, .inherited = true},
    {field_prefix, 1},
    {field_value, 3, .inherited = true},
  [93] =
    {field_marker, 0},
    {field_tag, 1},
    {field_value, 3},
  [96] =
    {field_marker, 0},
    {field_tag, 2},
    {field_value, 3},
  [99] =
    {field_delimiter, 2},
    {field_meta, 0, .inherited = true},
    {field_name, 3},
    {field_namespace, 1},
    {field_old_meta, 0, .inherited = true},
  [104] =
    {field_close, 3, .inherited = true},
    {field_marker, 1},
    {field_meta, 0, .inherited = true},
    {field_old_meta, 0, .inherited = true},
    {field_open, 3, .inherited = true},
    {field_prefix, 2},
    {field_value, 3, .inherited = true},
  [111] =
    {field_marker, 1},
    {field_meta, 0, .inherited = true},
    {field_old_meta, 0, .inherited = true},
    {field_tag, 2},
    {field_value, 3},
  [116] =
    {field_close, 3, .inherited = true},
    {field_marker, 1},
    {field_meta, 0, .inherited = true},
    {field_old_meta, 0, .inherited = true},
    {field_open, 3, .inherited = true},
    {field_value, 3, .inherited = true},
  [122] =
    {field_marker, 1},
    {field_meta, 0, .inherited = true},
    {field_old_meta, 0, .inherited = true},
    {field_value, 3},
  [126] =
    {field_marker, 0},
    {field_tag, 2},
    {field_value, 4},
  [129] =
    {field_close, 4, .inherited = true},
    {field_marker, 1},
    {field_meta, 0, .inherited = true},
    {field_old_meta, 0, .inherited = true},
    {field_open, 4, .inherited = true},
    {field_prefix, 2},
    {field_value, 4, .inherited = true},
  [136] =
    {field_marker, 1},
    {field_meta, 0, .inherited = true},
    {field_old_meta, 0, .inherited = true},
    {field_tag, 2},
    {field_value, 4},
  [141] =
    {field_marker, 1},
    {field_meta, 0, .inherited = true},
    {field_old_meta, 0, .inherited = true},
    {field_tag, 3},
    {field_value, 4},
  [146] =
    {field_marker, 1},
    {field_meta, 0, .inherited = true},
    {field_old_meta, 0, .inherited = true},
    {field_tag, 3},
    {field_value, 5},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
  [1] = {
    [0] = aux_sym__sym_qualified_token2,
  },
  [8] = {
    [1] = aux_sym__kwd_leading_slash_token1,
  },
  [13] = {
    [1] = aux_sym__sym_qualified_token2,
  },
};

static const uint16_t ts_non_terminal_alias_map[] = {
  0,
};

static const TSStateId ts_primary_state_ids[STATE_COUNT] = {
  [0] = 0,
  [1] = 1,
  [2] = 2,
  [3] = 3,
  [4] = 4,
  [5] = 5,
  [6] = 6,
  [7] = 5,
  [8] = 8,
  [9] = 9,
  [10] = 10,
  [11] = 4,
  [12] = 12,
  [13] = 9,
  [14] = 12,
  [15] = 10,
  [16] = 3,
  [17] = 8,
  [18] = 6,
  [19] = 19,
  [20] = 20,
  [21] = 21,
  [22] = 22,
  [23] = 23,
  [24] = 24,
  [25] = 25,
  [26] = 26,
  [27] = 27,
  [28] = 28,
  [29] = 29,
  [30] = 30,
  [31] = 31,
  [32] = 32,
  [33] = 33,
  [34] = 34,
  [35] = 35,
  [36] = 36,
  [37] = 37,
  [38] = 38,
  [39] = 39,
  [40] = 21,
  [41] = 41,
  [42] = 42,
  [43] = 43,
  [44] = 44,
  [45] = 45,
  [46] = 31,
  [47] = 47,
  [48] = 48,
  [49] = 49,
  [50] = 50,
  [51] = 21,
  [52] = 22,
  [53] = 39,
  [54] = 54,
  [55] = 28,
  [56] = 27,
  [57] = 26,
  [58] = 25,
  [59] = 24,
  [60] = 23,
  [61] = 54,
  [62] = 31,
  [63] = 21,
  [64] = 44,
  [65] = 50,
  [66] = 66,
  [67] = 67,
  [68] = 68,
  [69] = 69,
  [70] = 49,
  [71] = 71,
  [72] = 48,
  [73] = 73,
  [74] = 47,
  [75] = 75,
  [76] = 45,
  [77] = 77,
  [78] = 43,
  [79] = 79,
  [80] = 80,
  [81] = 29,
  [82] = 30,
  [83] = 83,
  [84] = 32,
  [85] = 33,
  [86] = 42,
  [87] = 34,
  [88] = 41,
  [89] = 38,
  [90] = 37,
  [91] = 36,
  [92] = 35,
  [93] = 35,
  [94] = 36,
  [95] = 37,
  [96] = 38,
  [97] = 41,
  [98] = 42,
  [99] = 43,
  [100] = 45,
  [101] = 47,
  [102] = 48,
  [103] = 49,
  [104] = 50,
  [105] = 35,
  [106] = 68,
  [107] = 22,
  [108] = 39,
  [109] = 28,
  [110] = 54,
  [111] = 27,
  [112] = 26,
  [113] = 25,
  [114] = 34,
  [115] = 33,
  [116] = 24,
  [117] = 80,
  [118] = 23,
  [119] = 83,
  [120] = 44,
  [121] = 66,
  [122] = 67,
  [123] = 68,
  [124] = 79,
  [125] = 69,
  [126] = 71,
  [127] = 73,
  [128] = 75,
  [129] = 32,
  [130] = 77,
  [131] = 79,
  [132] = 80,
  [133] = 29,
  [134] = 30,
  [135] = 83,
  [136] = 32,
  [137] = 33,
  [138] = 83,
  [139] = 34,
  [140] = 77,
  [141] = 35,
  [142] = 36,
  [143] = 37,
  [144] = 30,
  [145] = 38,
  [146] = 29,
  [147] = 41,
  [148] = 80,
  [149] = 42,
  [150] = 79,
  [151] = 43,
  [152] = 77,
  [153] = 45,
  [154] = 47,
  [155] = 48,
  [156] = 49,
  [157] = 50,
  [158] = 75,
  [159] = 21,
  [160] = 22,
  [161] = 75,
  [162] = 66,
  [163] = 73,
  [164] = 67,
  [165] = 73,
  [166] = 71,
  [167] = 39,
  [168] = 28,
  [169] = 27,
  [170] = 26,
  [171] = 25,
  [172] = 24,
  [173] = 23,
  [174] = 54,
  [175] = 71,
  [176] = 69,
  [177] = 68,
  [178] = 68,
  [179] = 69,
  [180] = 71,
  [181] = 73,
  [182] = 75,
  [183] = 69,
  [184] = 77,
  [185] = 79,
  [186] = 80,
  [187] = 29,
  [188] = 54,
  [189] = 23,
  [190] = 30,
  [191] = 24,
  [192] = 25,
  [193] = 26,
  [194] = 27,
  [195] = 28,
  [196] = 83,
  [197] = 32,
  [198] = 50,
  [199] = 34,
  [200] = 42,
  [201] = 39,
  [202] = 33,
  [203] = 49,
  [204] = 41,
  [205] = 48,
  [206] = 38,
  [207] = 47,
  [208] = 22,
  [209] = 37,
  [210] = 45,
  [211] = 36,
  [212] = 43,
  [213] = 213,
  [214] = 214,
  [215] = 215,
  [216] = 216,
  [217] = 217,
  [218] = 218,
  [219] = 219,
  [220] = 220,
  [221] = 221,
  [222] = 222,
  [223] = 223,
  [224] = 224,
  [225] = 225,
  [226] = 226,
  [227] = 227,
  [228] = 228,
  [229] = 229,
  [230] = 230,
  [231] = 231,
  [232] = 232,
  [233] = 233,
  [234] = 234,
  [235] = 235,
  [236] = 236,
  [237] = 237,
  [238] = 238,
  [239] = 239,
  [240] = 240,
  [241] = 241,
  [242] = 242,
  [243] = 243,
  [244] = 244,
  [245] = 245,
  [246] = 246,
  [247] = 247,
  [248] = 248,
  [249] = 249,
  [250] = 250,
  [251] = 251,
  [252] = 252,
  [253] = 253,
  [254] = 254,
  [255] = 255,
  [256] = 256,
  [257] = 257,
  [258] = 258,
  [259] = 259,
  [260] = 260,
  [261] = 261,
  [262] = 262,
  [263] = 263,
  [264] = 264,
  [265] = 265,
  [266] = 266,
  [267] = 267,
  [268] = 268,
  [269] = 269,
  [270] = 270,
  [271] = 271,
  [272] = 272,
  [273] = 273,
  [274] = 274,
  [275] = 275,
  [276] = 276,
  [277] = 277,
  [278] = 278,
  [279] = 279,
  [280] = 280,
  [281] = 281,
  [282] = 282,
  [283] = 283,
  [284] = 284,
  [285] = 285,
  [286] = 286,
  [287] = 287,
  [288] = 288,
  [289] = 289,
  [290] = 290,
  [291] = 291,
  [292] = 292,
  [293] = 293,
  [294] = 294,
  [295] = 295,
  [296] = 296,
  [297] = 297,
  [298] = 298,
  [299] = 299,
  [300] = 300,
  [301] = 301,
  [302] = 302,
  [303] = 303,
  [304] = 303,
  [305] = 303,
  [306] = 303,
  [307] = 303,
  [308] = 308,
  [309] = 308,
  [310] = 310,
  [311] = 311,
  [312] = 308,
  [313] = 313,
  [314] = 314,
  [315] = 308,
  [316] = 308,
  [317] = 301,
  [318] = 318,
  [319] = 318,
  [320] = 318,
  [321] = 318,
  [322] = 318,
  [323] = 213,
  [324] = 324,
  [325] = 281,
  [326] = 286,
  [327] = 265,
  [328] = 221,
  [329] = 225,
  [330] = 294,
  [331] = 292,
  [332] = 288,
  [333] = 229,
  [334] = 249,
  [335] = 250,
  [336] = 230,
  [337] = 231,
  [338] = 233,
  [339] = 234,
  [340] = 340,
  [341] = 235,
  [342] = 236,
  [343] = 237,
  [344] = 238,
  [345] = 239,
  [346] = 293,
  [347] = 240,
  [348] = 232,
  [349] = 228,
  [350] = 224,
  [351] = 223,
  [352] = 220,
  [353] = 241,
  [354] = 354,
  [355] = 244,
  [356] = 258,
  [357] = 222,
  [358] = 273,
  [359] = 299,
  [360] = 360,
  [361] = 361,
  [362] = 298,
  [363] = 363,
  [364] = 297,
  [365] = 296,
  [366] = 245,
  [367] = 246,
  [368] = 295,
  [369] = 278,
  [370] = 247,
  [371] = 248,
  [372] = 251,
  [373] = 252,
  [374] = 227,
  [375] = 375,
  [376] = 280,
  [377] = 253,
  [378] = 263,
  [379] = 216,
  [380] = 254,
  [381] = 255,
  [382] = 256,
  [383] = 354,
  [384] = 291,
  [385] = 274,
  [386] = 257,
  [387] = 259,
  [388] = 217,
  [389] = 389,
  [390] = 340,
  [391] = 289,
  [392] = 218,
  [393] = 287,
  [394] = 360,
  [395] = 260,
  [396] = 261,
  [397] = 262,
  [398] = 264,
  [399] = 399,
  [400] = 285,
  [401] = 215,
  [402] = 284,
  [403] = 219,
  [404] = 266,
  [405] = 283,
  [406] = 282,
  [407] = 242,
  [408] = 279,
  [409] = 267,
  [410] = 290,
  [411] = 300,
  [412] = 277,
  [413] = 268,
  [414] = 214,
  [415] = 276,
  [416] = 275,
  [417] = 243,
  [418] = 272,
  [419] = 271,
  [420] = 270,
  [421] = 269,
  [422] = 375,
  [423] = 226,
  [424] = 424,
  [425] = 425,
  [426] = 425,
  [427] = 425,
  [428] = 428,
  [429] = 428,
  [430] = 428,
  [431] = 428,
  [432] = 425,
  [433] = 425,
  [434] = 428,
  [435] = 310,
  [436] = 311,
  [437] = 313,
  [438] = 314,
  [439] = 301,
  [440] = 440,
  [441] = 440,
  [442] = 314,
  [443] = 213,
  [444] = 324,
  [445] = 310,
  [446] = 301,
  [447] = 313,
  [448] = 311,
  [449] = 324,
  [450] = 450,
  [451] = 451,
  [452] = 452,
  [453] = 453,
  [454] = 454,
  [455] = 213,
  [456] = 456,
  [457] = 450,
  [458] = 456,
  [459] = 459,
  [460] = 453,
  [461] = 454,
  [462] = 459,
  [463] = 451,
  [464] = 301,
  [465] = 465,
  [466] = 213,
  [467] = 467,
  [468] = 468,
  [469] = 469,
  [470] = 470,
  [471] = 471,
  [472] = 470,
  [473] = 473,
  [474] = 468,
  [475] = 467,
  [476] = 473,
  [477] = 477,
  [478] = 478,
  [479] = 477,
  [480] = 478,
  [481] = 469,
  [482] = 471,
  [483] = 483,
  [484] = 484,
  [485] = 484,
  [486] = 484,
  [487] = 484,
  [488] = 484,
  [489] = 489,
  [490] = 490,
  [491] = 491,
  [492] = 491,
  [493] = 493,
  [494] = 490,
  [495] = 489,
};

static inline bool sym__ws_character_set_1(int32_t c) {
  return (c < 8192
    ? (c < ','
      ? (c < 28
        ? (c >= '\t' && c <= '\r')
        : c <= ' ')
      : (c <= ',' || c == 5760))
    : (c <= 8198 || (c < 8287
      ? (c < 8232
        ? (c >= 8200 && c <= 8202)
        : c <= 8233)
      : (c <= 8287 || c == 12288))));
}

static inline bool sym_comment_character_set_1(int32_t c) {
  return (c < '['
    ? (c < '('
      ? (c < 28
        ? (c < '\t'
          ? c == 0
          : c <= '\r')
        : (c <= ' ' || c == '"'))
      : (c <= ')' || (c < ';'
        ? (c < '/'
          ? c == ','
          : c <= '/')
        : (c <= ';' || c == '@'))))
    : (c <= '^' || (c < 8192
      ? (c < '}'
        ? (c < '{'
          ? c == '`'
          : c <= '{')
        : (c <= '~' || c == 5760))
      : (c <= 8198 || (c < 8287
        ? (c < 8232
          ? (c >= 8200 && c <= 8202)
          : c <= 8233)
        : (c <= 8287 || c == 12288))))));
}

static inline bool sym_comment_character_set_2(int32_t c) {
  return (c < '`'
    ? (c < ','
      ? (c < '"'
        ? (c < 28
          ? (c >= '\t' && c <= '\r')
          : c <= ' ')
        : (c <= '"' || (c >= '(' && c <= ')')))
      : (c <= ',' || (c < '@'
        ? (c < ';'
          ? c == '/'
          : c <= ';')
        : (c <= '@' || (c >= '[' && c <= '^')))))
    : (c <= '`' || (c < 8200
      ? (c < 5760
        ? (c < '}'
          ? c == '{'
          : c <= '~')
        : (c <= 5760 || (c >= 8192 && c <= 8198)))
      : (c <= 8202 || (c < 8287
        ? (c >= 8232 && c <= 8233)
        : (c <= 8287 || c == 12288))))));
}

static inline bool sym_comment_character_set_3(int32_t c) {
  return (c < '`'
    ? (c < ','
      ? (c < '"'
        ? (c < 28
          ? (c >= '\t' && c <= '\r')
          : c <= ' ')
        : (c <= '"' || (c >= '(' && c <= ')')))
      : (c <= ',' || (c < '@'
        ? c == ';'
        : (c <= '@' || (c >= '[' && c <= '^')))))
    : (c <= '`' || (c < 8200
      ? (c < 5760
        ? (c < '}'
          ? c == '{'
          : c <= '~')
        : (c <= 5760 || (c >= 8192 && c <= 8198)))
      : (c <= 8202 || (c < 8287
        ? (c >= 8232 && c <= 8233)
        : (c <= 8287 || c == 12288))))));
}

static inline bool aux_sym__kwd_leading_slash_token1_character_set_1(int32_t c) {
  return (c < '`'
    ? (c < '('
      ? (c < 28
        ? (c < '\t'
          ? c == 0
          : c <= '\r')
        : (c <= ' ' || c == '"'))
      : (c <= ')' || (c < '@'
        ? (c < ';'
          ? c == ','
          : c <= ';')
        : (c <= '@' || (c >= '[' && c <= '^')))))
    : (c <= '`' || (c < 8200
      ? (c < 5760
        ? (c < '}'
          ? c == '{'
          : c <= '~')
        : (c <= 5760 || (c >= 8192 && c <= 8198)))
      : (c <= 8202 || (c < 8287
        ? (c >= 8232 && c <= 8233)
        : (c <= 8287 || c == 12288))))));
}

static inline bool aux_sym__kwd_leading_slash_token1_character_set_2(int32_t c) {
  return (c < '{'
    ? (c < ','
      ? (c < 28
        ? (c < '\t'
          ? c == 0
          : c <= '\r')
        : (c <= '"' || (c >= '(' && c <= ')')))
      : (c <= ',' || (c < '?'
        ? c == ';'
        : (c <= '@' || (c >= '[' && c <= '`')))))
    : (c <= '{' || (c < 8200
      ? (c < 5760
        ? (c >= '}' && c <= '~')
        : (c <= 5760 || (c >= 8192 && c <= 8198)))
      : (c <= 8202 || (c < 8287
        ? (c >= 8232 && c <= 8233)
        : (c <= 8287 || c == 12288))))));
}

static inline bool aux_sym__kwd_leading_slash_token1_character_set_3(int32_t c) {
  return (c < '{'
    ? (c < ','
      ? (c < 28
        ? (c < '\t'
          ? c == 0
          : c <= '\r')
        : (c <= '"' || (c >= '(' && c <= ')')))
      : (c <= ',' || (c < '@'
        ? c == ';'
        : (c <= '@' || (c >= '[' && c <= '`')))))
    : (c <= '{' || (c < 8200
      ? (c < 5760
        ? (c >= '}' && c <= '~')
        : (c <= 5760 || (c >= 8192 && c <= 8198)))
      : (c <= 8202 || (c < 8287
        ? (c >= 8232 && c <= 8233)
        : (c <= 8287 || c == 12288))))));
}

static inline bool aux_sym__kwd_leading_slash_token1_character_set_4(int32_t c) {
  return (c < '@'
    ? (c < '('
      ? (c < 28
        ? (c < '\t'
          ? c == 0
          : c <= '\r')
        : (c <= ' ' || c == '"'))
      : (c <= ')' || (c < '/'
        ? c == ','
        : (c <= '9' || c == ';'))))
    : (c <= '^' || (c < 8200
      ? (c < 5760
        ? (c < '}'
          ? (c >= '`' && c <= '{')
          : c <= '~')
        : (c <= 5760 || (c >= 8192 && c <= 8198)))
      : (c <= 8202 || (c < 8287
        ? (c >= 8232 && c <= 8233)
        : (c <= 8287 || c == 12288))))));
}

static inline bool aux_sym__kwd_leading_slash_token1_character_set_5(int32_t c) {
  return (c < '@'
    ? (c < '('
      ? (c < 28
        ? (c < '\t'
          ? c == 0
          : c <= '\r')
        : (c <= ' ' || c == '"'))
      : (c <= ')' || (c < '0'
        ? c == ','
        : (c <= '9' || c == ';'))))
    : (c <= '^' || (c < 8200
      ? (c < 5760
        ? (c < '}'
          ? (c >= '`' && c <= '{')
          : c <= '~')
        : (c <= 5760 || (c >= 8192 && c <= 8198)))
      : (c <= 8202 || (c < 8287
        ? (c >= 8232 && c <= 8233)
        : (c <= 8287 || c == 12288))))));
}

static inline bool aux_sym__kwd_leading_slash_token1_character_set_6(int32_t c) {
  return (c < '['
    ? (c < '('
      ? (c < 28
        ? (c < '\t'
          ? c == 0
          : c <= '\r')
        : (c <= ' ' || c == '"'))
      : (c <= ')' || (c < ';'
        ? (c < '/'
          ? c == ','
          : c <= '9')
        : (c <= ';' || (c >= '@' && c <= 'F')))))
    : (c <= '^' || (c < 8192
      ? (c < '}'
        ? (c < '{'
          ? (c >= '`' && c <= 'f')
          : c <= '{')
        : (c <= '~' || c == 5760))
      : (c <= 8198 || (c < 8287
        ? (c < 8232
          ? (c >= 8200 && c <= 8202)
          : c <= 8233)
        : (c <= 8287 || c == 12288))))));
}

static inline bool aux_sym__kwd_leading_slash_token1_character_set_7(int32_t c) {
  return (c < '['
    ? (c < '('
      ? (c < 28
        ? (c < '\t'
          ? c == 0
          : c <= '\r')
        : (c <= ' ' || c == '"'))
      : (c <= ')' || (c < ';'
        ? (c < '0'
          ? c == ','
          : c <= '9')
        : (c <= ';' || (c >= '@' && c <= 'F')))))
    : (c <= '^' || (c < 8192
      ? (c < '}'
        ? (c < '{'
          ? (c >= '`' && c <= 'f')
          : c <= '{')
        : (c <= '~' || c == 5760))
      : (c <= 8198 || (c < 8287
        ? (c < 8232
          ? (c >= 8200 && c <= 8202)
          : c <= 8233)
        : (c <= 8287 || c == 12288))))));
}

static inline bool aux_sym__kwd_leading_slash_token1_character_set_8(int32_t c) {
  return (c < '['
    ? (c < '('
      ? (c < 28
        ? (c < '\t'
          ? c == 0
          : c <= '\r')
        : (c <= ' ' || c == '"'))
      : (c <= ')' || (c < ';'
        ? (c < '/'
          ? (c >= '+' && c <= '-')
          : c <= '9')
        : (c <= ';' || c == '@'))))
    : (c <= '^' || (c < 8192
      ? (c < '}'
        ? (c < '{'
          ? c == '`'
          : c <= '{')
        : (c <= '~' || c == 5760))
      : (c <= 8198 || (c < 8287
        ? (c < 8232
          ? (c >= 8200 && c <= 8202)
          : c <= 8233)
        : (c <= 8287 || c == 12288))))));
}

static inline bool aux_sym__kwd_leading_slash_token1_character_set_9(int32_t c) {
  return (c < '['
    ? (c < '('
      ? (c < 28
        ? (c < '\t'
          ? c == 0
          : c <= '\r')
        : (c <= ' ' || c == '"'))
      : (c <= ')' || (c < ';'
        ? (c < '0'
          ? (c >= '+' && c <= '-')
          : c <= '9')
        : (c <= ';' || c == '@'))))
    : (c <= '^' || (c < 8192
      ? (c < '}'
        ? (c < '{'
          ? c == '`'
          : c <= '{')
        : (c <= '~' || c == 5760))
      : (c <= 8198 || (c < 8287
        ? (c < 8232
          ? (c >= 8200 && c <= 8202)
          : c <= 8233)
        : (c <= 8287 || c == 12288))))));
}

static inline bool aux_sym__kwd_leading_slash_token1_character_set_10(int32_t c) {
  return (c < '['
    ? (c < '('
      ? (c < 28
        ? (c < '\t'
          ? c == 0
          : c <= '\r')
        : (c <= ' ' || c == '"'))
      : (c <= ')' || (c < ';'
        ? (c < '/'
          ? c == ','
          : c <= '9')
        : (c <= ';' || c == '@'))))
    : (c <= '^' || (c < 8192
      ? (c < '}'
        ? (c < '{'
          ? c == '`'
          : c <= '{')
        : (c <= '~' || c == 5760))
      : (c <= 8198 || (c < 8287
        ? (c < 8232
          ? (c >= 8200 && c <= 8202)
          : c <= 8233)
        : (c <= 8287 || c == 12288))))));
}

static inline bool aux_sym__kwd_leading_slash_token1_character_set_11(int32_t c) {
  return (c < '['
    ? (c < '('
      ? (c < 28
        ? (c < '\t'
          ? c == 0
          : c <= '\r')
        : (c <= ' ' || c == '"'))
      : (c <= ')' || (c < ';'
        ? (c < '0'
          ? c == ','
          : c <= '9')
        : (c <= ';' || c == '@'))))
    : (c <= '^' || (c < 8192
      ? (c < '}'
        ? (c < '{'
          ? c == '`'
          : c <= '{')
        : (c <= '~' || c == 5760))
      : (c <= 8198 || (c < 8287
        ? (c < 8232
          ? (c >= 8200 && c <= 8202)
          : c <= 8233)
        : (c <= 8287 || c == 12288))))));
}

static inline bool aux_sym__kwd_leading_slash_token1_character_set_12(int32_t c) {
  return (c < '`'
    ? (c < ','
      ? (c < 28
        ? (c < '\t'
          ? c == 0
          : c <= '\r')
        : (c <= ' ' || (c < '('
          ? c == '"'
          : c <= ')')))
      : (c <= ',' || (c < '@'
        ? (c < ';'
          ? c == '/'
          : c <= ';')
        : (c <= '@' || (c >= '[' && c <= '^')))))
    : (c <= '`' || (c < 8192
      ? (c < '}'
        ? (c < '{'
          ? c == 'e'
          : c <= '{')
        : (c <= '~' || c == 5760))
      : (c <= 8198 || (c < 8287
        ? (c < 8232
          ? (c >= 8200 && c <= 8202)
          : c <= 8233)
        : (c <= 8287 || c == 12288))))));
}

static inline bool aux_sym__kwd_leading_slash_token1_character_set_13(int32_t c) {
  return (c < '`'
    ? (c < ','
      ? (c < 28
        ? (c < '\t'
          ? c == 0
          : c <= '\r')
        : (c <= ' ' || (c < '('
          ? c == '"'
          : c <= ')')))
      : (c <= ',' || (c < '@'
        ? (c < ';'
          ? c == '/'
          : c <= ';')
        : (c <= '@' || (c >= '[' && c <= '^')))))
    : (c <= '`' || (c < 8192
      ? (c < '}'
        ? (c < '{'
          ? c == 'i'
          : c <= '{')
        : (c <= '~' || c == 5760))
      : (c <= 8198 || (c < 8287
        ? (c < 8232
          ? (c >= 8200 && c <= 8202)
          : c <= 8233)
        : (c <= 8287 || c == 12288))))));
}

static inline bool aux_sym__kwd_leading_slash_token1_character_set_14(int32_t c) {
  return (c < '`'
    ? (c < ','
      ? (c < 28
        ? (c < '\t'
          ? c == 0
          : c <= '\r')
        : (c <= ' ' || (c < '('
          ? c == '"'
          : c <= ')')))
      : (c <= ',' || (c < '@'
        ? (c < ';'
          ? c == '/'
          : c <= ';')
        : (c <= '@' || (c >= '[' && c <= '^')))))
    : (c <= '`' || (c < 8192
      ? (c < '}'
        ? (c < '{'
          ? c == 'l'
          : c <= '{')
        : (c <= '~' || c == 5760))
      : (c <= 8198 || (c < 8287
        ? (c < 8232
          ? (c >= 8200 && c <= 8202)
          : c <= 8233)
        : (c <= 8287 || c == 12288))))));
}

static inline bool aux_sym__kwd_leading_slash_token1_character_set_15(int32_t c) {
  return (c < '`'
    ? (c < ','
      ? (c < 28
        ? (c < '\t'
          ? c == 0
          : c <= '\r')
        : (c <= ' ' || (c < '('
          ? c == '"'
          : c <= ')')))
      : (c <= ',' || (c < '@'
        ? (c < ';'
          ? c == '/'
          : c <= ';')
        : (c <= '@' || (c >= '[' && c <= '^')))))
    : (c <= '`' || (c < 8192
      ? (c < '}'
        ? (c < '{'
          ? c == 'r'
          : c <= '{')
        : (c <= '~' || c == 5760))
      : (c <= 8198 || (c < 8287
        ? (c < 8232
          ? (c >= 8200 && c <= 8202)
          : c <= 8233)
        : (c <= 8287 || c == 12288))))));
}

static inline bool aux_sym__kwd_leading_slash_token1_character_set_16(int32_t c) {
  return (c < '`'
    ? (c < ','
      ? (c < 28
        ? (c < '\t'
          ? c == 0
          : c <= '\r')
        : (c <= ' ' || (c < '('
          ? c == '"'
          : c <= ')')))
      : (c <= ',' || (c < '@'
        ? (c < ';'
          ? c == '/'
          : c <= ';')
        : (c <= '@' || (c >= '[' && c <= '^')))))
    : (c <= '`' || (c < 8192
      ? (c < '}'
        ? (c < '{'
          ? c == 's'
          : c <= '{')
        : (c <= '~' || c == 5760))
      : (c <= 8198 || (c < 8287
        ? (c < 8232
          ? (c >= 8200 && c <= 8202)
          : c <= 8233)
        : (c <= 8287 || c == 12288))))));
}

static inline bool aux_sym__kwd_leading_slash_token1_character_set_17(int32_t c) {
  return (c < '`'
    ? (c < ','
      ? (c < 28
        ? (c < '\t'
          ? c == 0
          : c <= '\r')
        : (c <= ' ' || (c < '('
          ? c == '"'
          : c <= ')')))
      : (c <= ',' || (c < '@'
        ? (c < ';'
          ? c == '/'
          : c <= ';')
        : (c <= '@' || (c >= '[' && c <= '^')))))
    : (c <= '`' || (c < 8192
      ? (c < '}'
        ? (c < '{'
          ? c == 'u'
          : c <= '{')
        : (c <= '~' || c == 5760))
      : (c <= 8198 || (c < 8287
        ? (c < 8232
          ? (c >= 8200 && c <= 8202)
          : c <= 8233)
        : (c <= 8287 || c == 12288))))));
}

static inline bool aux_sym__kwd_leading_slash_token1_character_set_18(int32_t c) {
  return (c < '['
    ? (c < '('
      ? (c < 28
        ? (c < '\t'
          ? c == 0
          : c <= '\r')
        : (c <= ' ' || c == '"'))
      : (c <= ')' || (c < ';'
        ? (c < '/'
          ? c == ','
          : c <= '/')
        : (c <= ';' || c == '@'))))
    : (c <= '^' || (c < 8192
      ? (c < '}'
        ? (c < '{'
          ? (c >= '`' && c <= 'a')
          : c <= '{')
        : (c <= '~' || c == 5760))
      : (c <= 8198 || (c < 8287
        ? (c < 8232
          ? (c >= 8200 && c <= 8202)
          : c <= 8233)
        : (c <= 8287 || c == 12288))))));
}

static inline bool aux_sym__kwd_qualified_token1_character_set_1(int32_t c) {
  return (c < '`'
    ? (c < '('
      ? (c < 28
        ? (c < '\t'
          ? c == 0
          : c <= '\r')
        : (c <= ' ' || c == '"'))
      : (c <= ')' || (c < '@'
        ? (c < ':'
          ? c == ','
          : c <= ';')
        : (c <= '@' || (c >= '[' && c <= '^')))))
    : (c <= '`' || (c < 8200
      ? (c < 5760
        ? (c < '}'
          ? c == '{'
          : c <= '~')
        : (c <= 5760 || (c >= 8192 && c <= 8198)))
      : (c <= 8202 || (c < 8287
        ? (c >= 8232 && c <= 8233)
        : (c <= 8287 || c == 12288))))));
}

static inline bool aux_sym__kwd_qualified_token1_character_set_2(int32_t c) {
  return (c < '['
    ? (c < ','
      ? (c < 28
        ? (c < '\t'
          ? c == 0
          : c <= '\r')
        : (c <= '"' || (c >= '(' && c <= ')')))
      : (c <= ',' || (c < ';'
        ? c == '/'
        : (c <= ';' || c == '@'))))
    : (c <= '`' || (c < 8200
      ? (c < 5760
        ? (c < '}'
          ? c == '{'
          : c <= '~')
        : (c <= 5760 || (c >= 8192 && c <= 8198)))
      : (c <= 8202 || (c < 8287
        ? (c >= 8232 && c <= 8233)
        : (c <= 8287 || c == 12288))))));
}

static inline bool aux_sym__sym_qualified_token1_character_set_1(int32_t c) {
  return (c < '\\'
    ? (c < '"'
      ? (c < '\t'
        ? c == 0
        : (c <= '\r' || (c >= 28 && c <= ' ')))
      : (c <= '"' || (c < ','
        ? c == ')'
        : (c <= ',' || (c >= '0' && c <= ';')))))
    : (c <= ']' || (c < 8200
      ? (c < 5760
        ? c == '}'
        : (c <= 5760 || (c >= 8192 && c <= 8198)))
      : (c <= 8202 || (c < 8287
        ? (c >= 8232 && c <= 8233)
        : (c <= 8287 || c == 12288))))));
}

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(45);
      if (lookahead == '"') ADVANCE(2);
      if (lookahead == '#') ADVANCE(146);
      if (lookahead == '\'') ADVANCE(161);
      if (lookahead == '(') ADVANCE(138);
      if (lookahead == ')') ADVANCE(139);
      if (lookahead == '/') ADVANCE(76);
      if (lookahead == '0') ADVANCE(55);
      if (lookahead == ':') ADVANCE(103);
      if (lookahead == ';') ADVANCE(50);
      if (lookahead == '@') ADVANCE(159);
      if (lookahead == '[') ADVANCE(142);
      if (lookahead == '\\') ADVANCE(42);
      if (lookahead == ']') ADVANCE(143);
      if (lookahead == '^') ADVANCE(136);
      if (lookahead == '`') ADVANCE(162);
      if (lookahead == 'f') ADVANCE(97);
      if (lookahead == 'n') ADVANCE(91);
      if (lookahead == 't') ADVANCE(94);
      if (lookahead == '{') ADVANCE(140);
      if (lookahead == '}') ADVANCE(141);
      if (lookahead == '~') ADVANCE(164);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(86);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(57);
      if (sym__ws_character_set_1(lookahead)) ADVANCE(46);
      if (lookahead != 0) ADVANCE(98);
      END_STATE();
    case 1:
      if (lookahead == '"') ADVANCE(2);
      if (lookahead == '#') ADVANCE(145);
      if (lookahead == '\'') ADVANCE(160);
      if (lookahead == '(') ADVANCE(138);
      if (lookahead == '/') ADVANCE(75);
      if (lookahead == ':') ADVANCE(102);
      if (lookahead == ';') ADVANCE(50);
      if (lookahead == '@') ADVANCE(159);
      if (lookahead == '[') ADVANCE(142);
      if (lookahead == '^') ADVANCE(136);
      if (lookahead == '`') ADVANCE(162);
      if (lookahead == '{') ADVANCE(140);
      if (lookahead == '~') ADVANCE(164);
      if (sym__ws_character_set_1(lookahead)) ADVANCE(46);
      if (lookahead != 0 &&
          lookahead != ')' &&
          (lookahead < '0' || '9' < lookahead) &&
          lookahead != '\\' &&
          lookahead != ']' &&
          lookahead != '}') ADVANCE(134);
      END_STATE();
    case 2:
      if (lookahead == '"') ADVANCE(106);
      if (lookahead == '\\') ADVANCE(43);
      if (lookahead != 0) ADVANCE(2);
      END_STATE();
    case 3:
      if (lookahead == '#') ADVANCE(148);
      if (lookahead == '\'') ADVANCE(160);
      if (lookahead == '(') ADVANCE(138);
      if (lookahead == '/') ADVANCE(75);
      if (lookahead == '@') ADVANCE(159);
      if (lookahead == '[') ADVANCE(142);
      if (lookahead == '^') ADVANCE(136);
      if (lookahead == '`') ADVANCE(162);
      if (lookahead == '{') ADVANCE(140);
      if (lookahead == '~') ADVANCE(164);
      if (!aux_sym__sym_qualified_token1_character_set_1(lookahead)) ADVANCE(134);
      END_STATE();
    case 4:
      if (lookahead == '#') ADVANCE(147);
      if (lookahead == '\'') ADVANCE(161);
      if (lookahead == '(') ADVANCE(138);
      if (lookahead == '/') ADVANCE(76);
      if (('0' <= lookahead && lookahead <= ':')) ADVANCE(99);
      if (lookahead == ';') ADVANCE(50);
      if (lookahead == '@') ADVANCE(159);
      if (lookahead == '[') ADVANCE(142);
      if (lookahead == '^') ADVANCE(136);
      if (lookahead == '`') ADVANCE(162);
      if (lookahead == '{') ADVANCE(140);
      if (lookahead == '~') ADVANCE(164);
      if (sym__ws_character_set_1(lookahead)) ADVANCE(46);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != ')' &&
          lookahead != '\\' &&
          lookahead != ']' &&
          lookahead != '}') ADVANCE(98);
      END_STATE();
    case 5:
      if (lookahead == '#') ADVANCE(77);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= ':')) ADVANCE(99);
      if (lookahead == '(') ADVANCE(138);
      if (lookahead == '/') ADVANCE(76);
      if (lookahead == ';') ADVANCE(50);
      if (lookahead == '^') ADVANCE(136);
      if (sym__ws_character_set_1(lookahead)) ADVANCE(46);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != ')' &&
          lookahead != '@' &&
          (lookahead < '[' || ']' < lookahead) &&
          lookahead != '`' &&
          lookahead != '{' &&
          lookahead != '}' &&
          lookahead != '~') ADVANCE(98);
      END_STATE();
    case 6:
      if (lookahead == '#') ADVANCE(78);
      if (lookahead == '\'' ||
          ('0' <= lookahead && lookahead <= ':')) ADVANCE(99);
      if (lookahead == '/') ADVANCE(76);
      if (lookahead == ';') ADVANCE(50);
      if (lookahead == '^') ADVANCE(136);
      if (sym__ws_character_set_1(lookahead)) ADVANCE(46);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != '@' &&
          (lookahead < '[' || ']' < lookahead) &&
          lookahead != '`' &&
          lookahead != '{' &&
          lookahead != '}' &&
          lookahead != '~') ADVANCE(98);
      END_STATE();
    case 7:
      if (lookahead == '#') ADVANCE(100);
      if (lookahead == '/') ADVANCE(75);
      if (lookahead == ';') ADVANCE(50);
      if (lookahead == '{') ADVANCE(140);
      if (sym__ws_character_set_1(lookahead)) ADVANCE(46);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ':' &&
          lookahead != '@' &&
          (lookahead < '[' || '^' < lookahead) &&
          lookahead != '`' &&
          lookahead != '}' &&
          lookahead != '~') ADVANCE(101);
      END_STATE();
    case 8:
      if (lookahead == '#') ADVANCE(79);
      if (!aux_sym__kwd_leading_slash_token1_character_set_1(lookahead)) ADVANCE(99);
      if (lookahead == ';') ADVANCE(50);
      if (lookahead == '{') ADVANCE(140);
      if (sym__ws_character_set_1(lookahead)) ADVANCE(46);
      END_STATE();
    case 9:
      if (lookahead == '/') ADVANCE(75);
      if (!aux_sym__kwd_qualified_token1_character_set_1(lookahead)) ADVANCE(101);
      END_STATE();
    case 10:
      if (lookahead == 'a') ADVANCE(13);
      END_STATE();
    case 11:
      if (lookahead == 'b') ADVANCE(107);
      END_STATE();
    case 12:
      if (lookahead == 'c') ADVANCE(20);
      END_STATE();
    case 13:
      if (lookahead == 'c') ADVANCE(15);
      END_STATE();
    case 14:
      if (lookahead == 'd') ADVANCE(107);
      END_STATE();
    case 15:
      if (lookahead == 'e') ADVANCE(107);
      END_STATE();
    case 16:
      if (lookahead == 'e') ADVANCE(14);
      END_STATE();
    case 17:
      if (lookahead == 'e') ADVANCE(16);
      END_STATE();
    case 18:
      if (lookahead == 'f') ADVANCE(17);
      END_STATE();
    case 19:
      if (lookahead == 'i') ADVANCE(24);
      END_STATE();
    case 20:
      if (lookahead == 'k') ADVANCE(28);
      END_STATE();
    case 21:
      if (lookahead == 'l') ADVANCE(19);
      END_STATE();
    case 22:
      if (lookahead == 'm') ADVANCE(18);
      END_STATE();
    case 23:
      if (lookahead == 'n') ADVANCE(107);
      END_STATE();
    case 24:
      if (lookahead == 'n') ADVANCE(15);
      END_STATE();
    case 25:
      if (lookahead == 'p') ADVANCE(10);
      END_STATE();
    case 26:
      if (lookahead == 'r') ADVANCE(22);
      END_STATE();
    case 27:
      if (lookahead == 'r') ADVANCE(23);
      END_STATE();
    case 28:
      if (lookahead == 's') ADVANCE(25);
      END_STATE();
    case 29:
      if (lookahead == 't') ADVANCE(30);
      END_STATE();
    case 30:
      if (lookahead == 'u') ADVANCE(27);
      END_STATE();
    case 31:
      if (lookahead == 'w') ADVANCE(21);
      END_STATE();
    case 32:
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(34);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(71);
      END_STATE();
    case 33:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(73);
      END_STATE();
    case 34:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(71);
      END_STATE();
    case 35:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(107);
      END_STATE();
    case 36:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(72);
      END_STATE();
    case 37:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(35);
      END_STATE();
    case 38:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(37);
      END_STATE();
    case 39:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(74);
      END_STATE();
    case 40:
      if (!aux_sym__kwd_leading_slash_token1_character_set_1(lookahead)) ADVANCE(99);
      END_STATE();
    case 41:
      if (!aux_sym__kwd_leading_slash_token1_character_set_1(lookahead)) ADVANCE(135);
      END_STATE();
    case 42:
      if (lookahead != 0 &&
          lookahead != 'b' &&
          lookahead != 'f' &&
          lookahead != 'n' &&
          lookahead != 'o' &&
          (lookahead < 'r' || 'u' < lookahead)) ADVANCE(107);
      if (lookahead == 'b') ADVANCE(108);
      if (lookahead == 'f') ADVANCE(112);
      if (lookahead == 'n') ADVANCE(110);
      if (lookahead == 'o') ADVANCE(116);
      if (lookahead == 'r') ADVANCE(111);
      if (lookahead == 's') ADVANCE(113);
      if (lookahead == 't') ADVANCE(109);
      if (lookahead == 'u') ADVANCE(117);
      END_STATE();
    case 43:
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(2);
      END_STATE();
    case 44:
      if (eof) ADVANCE(45);
      if (lookahead == '"') ADVANCE(2);
      if (lookahead == '#') ADVANCE(144);
      if (lookahead == '\'') ADVANCE(160);
      if (lookahead == '(') ADVANCE(138);
      if (lookahead == ')') ADVANCE(139);
      if (lookahead == '/') ADVANCE(75);
      if (lookahead == '0') ADVANCE(61);
      if (lookahead == ':') ADVANCE(102);
      if (lookahead == ';') ADVANCE(50);
      if (lookahead == '@') ADVANCE(159);
      if (lookahead == '[') ADVANCE(142);
      if (lookahead == '\\') ADVANCE(42);
      if (lookahead == ']') ADVANCE(143);
      if (lookahead == '^') ADVANCE(136);
      if (lookahead == '`') ADVANCE(162);
      if (lookahead == 'f') ADVANCE(122);
      if (lookahead == 'n') ADVANCE(124);
      if (lookahead == 't') ADVANCE(127);
      if (lookahead == '{') ADVANCE(140);
      if (lookahead == '}') ADVANCE(141);
      if (lookahead == '~') ADVANCE(164);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(121);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(63);
      if (sym__ws_character_set_1(lookahead)) ADVANCE(46);
      if (lookahead != 0) ADVANCE(134);
      END_STATE();
    case 45:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 46:
      ACCEPT_TOKEN(sym__ws);
      if (sym__ws_character_set_1(lookahead)) ADVANCE(46);
      END_STATE();
    case 47:
      ACCEPT_TOKEN(sym_comment);
      END_STATE();
    case 48:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '\n') ADVANCE(47);
      if (!sym_comment_character_set_1(lookahead)) ADVANCE(48);
      if (sym_comment_character_set_2(lookahead)) ADVANCE(50);
      END_STATE();
    case 49:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '\n') ADVANCE(47);
      if (!aux_sym__kwd_leading_slash_token1_character_set_1(lookahead)) ADVANCE(49);
      if (sym_comment_character_set_3(lookahead)) ADVANCE(50);
      END_STATE();
    case 50:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '\n') ADVANCE(47);
      if (lookahead != 0) ADVANCE(50);
      END_STATE();
    case 51:
      ACCEPT_TOKEN(anon_sym_POUND_);
      END_STATE();
    case 52:
      ACCEPT_TOKEN(anon_sym_POUND_);
      if (!sym_comment_character_set_1(lookahead)) ADVANCE(101);
      END_STATE();
    case 53:
      ACCEPT_TOKEN(anon_sym_POUND_);
      if (!aux_sym__kwd_leading_slash_token1_character_set_1(lookahead)) ADVANCE(99);
      END_STATE();
    case 54:
      ACCEPT_TOKEN(sym_num_lit);
      END_STATE();
    case 55:
      ACCEPT_TOKEN(sym_num_lit);
      if (lookahead == '.') ADVANCE(67);
      if (lookahead == '/') ADVANCE(88);
      if (lookahead == 'M' ||
          lookahead == 'N') ADVANCE(54);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(85);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(81);
      if (lookahead == 'X' ||
          lookahead == 'x') ADVANCE(83);
      if (lookahead == '8' ||
          lookahead == '9') ADVANCE(57);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(56);
      END_STATE();
    case 56:
      ACCEPT_TOKEN(sym_num_lit);
      if (lookahead == '.') ADVANCE(67);
      if (lookahead == '/') ADVANCE(88);
      if (lookahead == 'M' ||
          lookahead == 'N') ADVANCE(54);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(85);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(81);
      if (lookahead == '8' ||
          lookahead == '9') ADVANCE(57);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(56);
      END_STATE();
    case 57:
      ACCEPT_TOKEN(sym_num_lit);
      if (lookahead == '.') ADVANCE(67);
      if (lookahead == '/') ADVANCE(88);
      if (lookahead == 'M' ||
          lookahead == 'N') ADVANCE(54);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(85);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(81);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(57);
      END_STATE();
    case 58:
      ACCEPT_TOKEN(sym_num_lit);
      if (lookahead == '.') ADVANCE(68);
      if (lookahead == '/') ADVANCE(88);
      if (lookahead == 'M' ||
          lookahead == 'N') ADVANCE(54);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(84);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(80);
      if (lookahead == 'X' ||
          lookahead == 'x') ADVANCE(82);
      if (lookahead == '8' ||
          lookahead == '9') ADVANCE(60);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(59);
      END_STATE();
    case 59:
      ACCEPT_TOKEN(sym_num_lit);
      if (lookahead == '.') ADVANCE(68);
      if (lookahead == '/') ADVANCE(88);
      if (lookahead == 'M' ||
          lookahead == 'N') ADVANCE(54);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(84);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(80);
      if (lookahead == '8' ||
          lookahead == '9') ADVANCE(60);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(59);
      END_STATE();
    case 60:
      ACCEPT_TOKEN(sym_num_lit);
      if (lookahead == '.') ADVANCE(68);
      if (lookahead == '/') ADVANCE(88);
      if (lookahead == 'M' ||
          lookahead == 'N') ADVANCE(54);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(84);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(80);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(60);
      END_STATE();
    case 61:
      ACCEPT_TOKEN(sym_num_lit);
      if (lookahead == '.') ADVANCE(69);
      if (lookahead == '/') ADVANCE(33);
      if (lookahead == 'M' ||
          lookahead == 'N') ADVANCE(54);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(32);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(39);
      if (lookahead == 'X' ||
          lookahead == 'x') ADVANCE(36);
      if (lookahead == '8' ||
          lookahead == '9') ADVANCE(63);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(62);
      END_STATE();
    case 62:
      ACCEPT_TOKEN(sym_num_lit);
      if (lookahead == '.') ADVANCE(69);
      if (lookahead == '/') ADVANCE(33);
      if (lookahead == 'M' ||
          lookahead == 'N') ADVANCE(54);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(32);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(39);
      if (lookahead == '8' ||
          lookahead == '9') ADVANCE(63);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(62);
      END_STATE();
    case 63:
      ACCEPT_TOKEN(sym_num_lit);
      if (lookahead == '.') ADVANCE(69);
      if (lookahead == '/') ADVANCE(33);
      if (lookahead == 'M' ||
          lookahead == 'N') ADVANCE(54);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(32);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(39);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(63);
      END_STATE();
    case 64:
      ACCEPT_TOKEN(sym_num_lit);
      if (lookahead == '.') ADVANCE(70);
      if (lookahead == '/') ADVANCE(33);
      if (lookahead == 'M' ||
          lookahead == 'N') ADVANCE(54);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(130);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(131);
      if (lookahead == 'X' ||
          lookahead == 'x') ADVANCE(132);
      if (lookahead == '8' ||
          lookahead == '9') ADVANCE(66);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(65);
      END_STATE();
    case 65:
      ACCEPT_TOKEN(sym_num_lit);
      if (lookahead == '.') ADVANCE(70);
      if (lookahead == '/') ADVANCE(33);
      if (lookahead == 'M' ||
          lookahead == 'N') ADVANCE(54);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(130);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(131);
      if (lookahead == '8' ||
          lookahead == '9') ADVANCE(66);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(65);
      END_STATE();
    case 66:
      ACCEPT_TOKEN(sym_num_lit);
      if (lookahead == '.') ADVANCE(70);
      if (lookahead == '/') ADVANCE(33);
      if (lookahead == 'M' ||
          lookahead == 'N') ADVANCE(54);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(130);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(131);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(66);
      END_STATE();
    case 67:
      ACCEPT_TOKEN(sym_num_lit);
      if (lookahead == 'M') ADVANCE(54);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(85);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(67);
      END_STATE();
    case 68:
      ACCEPT_TOKEN(sym_num_lit);
      if (lookahead == 'M') ADVANCE(54);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(84);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(68);
      END_STATE();
    case 69:
      ACCEPT_TOKEN(sym_num_lit);
      if (lookahead == 'M') ADVANCE(54);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(32);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(69);
      END_STATE();
    case 70:
      ACCEPT_TOKEN(sym_num_lit);
      if (lookahead == 'M') ADVANCE(54);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(130);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(70);
      END_STATE();
    case 71:
      ACCEPT_TOKEN(sym_num_lit);
      if (lookahead == 'M') ADVANCE(54);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(71);
      END_STATE();
    case 72:
      ACCEPT_TOKEN(sym_num_lit);
      if (lookahead == 'N') ADVANCE(54);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(72);
      END_STATE();
    case 73:
      ACCEPT_TOKEN(sym_num_lit);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(73);
      END_STATE();
    case 74:
      ACCEPT_TOKEN(sym_num_lit);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(74);
      END_STATE();
    case 75:
      ACCEPT_TOKEN(anon_sym_SLASH);
      END_STATE();
    case 76:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (!aux_sym__kwd_leading_slash_token1_character_set_1(lookahead)) ADVANCE(99);
      END_STATE();
    case 77:
      ACCEPT_TOKEN(aux_sym__kwd_leading_slash_token1);
      if (lookahead == '!') ADVANCE(49);
      if (!aux_sym__kwd_leading_slash_token1_character_set_2(lookahead)) ADVANCE(99);
      if (lookahead == '?') ADVANCE(150);
      if (lookahead == '^') ADVANCE(137);
      if (lookahead == '_') ADVANCE(53);
      END_STATE();
    case 78:
      ACCEPT_TOKEN(aux_sym__kwd_leading_slash_token1);
      if (lookahead == '!') ADVANCE(49);
      if (!aux_sym__kwd_leading_slash_token1_character_set_3(lookahead)) ADVANCE(99);
      if (lookahead == '^') ADVANCE(137);
      if (lookahead == '_') ADVANCE(53);
      END_STATE();
    case 79:
      ACCEPT_TOKEN(aux_sym__kwd_leading_slash_token1);
      if (lookahead == '!') ADVANCE(49);
      if (!aux_sym__kwd_leading_slash_token1_character_set_3(lookahead)) ADVANCE(99);
      if (lookahead == '_') ADVANCE(53);
      END_STATE();
    case 80:
      ACCEPT_TOKEN(aux_sym__kwd_leading_slash_token1);
      if (!aux_sym__kwd_leading_slash_token1_character_set_4(lookahead)) ADVANCE(98);
      if (lookahead == '/') ADVANCE(99);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(74);
      END_STATE();
    case 81:
      ACCEPT_TOKEN(aux_sym__kwd_leading_slash_token1);
      if (!aux_sym__kwd_leading_slash_token1_character_set_5(lookahead)) ADVANCE(99);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(74);
      END_STATE();
    case 82:
      ACCEPT_TOKEN(aux_sym__kwd_leading_slash_token1);
      if (!aux_sym__kwd_leading_slash_token1_character_set_6(lookahead)) ADVANCE(98);
      if (lookahead == '/') ADVANCE(99);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(72);
      END_STATE();
    case 83:
      ACCEPT_TOKEN(aux_sym__kwd_leading_slash_token1);
      if (!aux_sym__kwd_leading_slash_token1_character_set_7(lookahead)) ADVANCE(99);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(72);
      END_STATE();
    case 84:
      ACCEPT_TOKEN(aux_sym__kwd_leading_slash_token1);
      if (!aux_sym__kwd_leading_slash_token1_character_set_8(lookahead)) ADVANCE(98);
      if (lookahead == '/') ADVANCE(99);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(87);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(71);
      END_STATE();
    case 85:
      ACCEPT_TOKEN(aux_sym__kwd_leading_slash_token1);
      if (!aux_sym__kwd_leading_slash_token1_character_set_9(lookahead)) ADVANCE(99);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(89);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(71);
      END_STATE();
    case 86:
      ACCEPT_TOKEN(aux_sym__kwd_leading_slash_token1);
      if (!aux_sym__kwd_leading_slash_token1_character_set_10(lookahead)) ADVANCE(98);
      if (lookahead == '/') ADVANCE(99);
      if (lookahead == '0') ADVANCE(58);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(60);
      END_STATE();
    case 87:
      ACCEPT_TOKEN(aux_sym__kwd_leading_slash_token1);
      if (!aux_sym__kwd_leading_slash_token1_character_set_10(lookahead)) ADVANCE(98);
      if (lookahead == '/') ADVANCE(99);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(71);
      END_STATE();
    case 88:
      ACCEPT_TOKEN(aux_sym__kwd_leading_slash_token1);
      if (!aux_sym__kwd_leading_slash_token1_character_set_11(lookahead)) ADVANCE(99);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(73);
      END_STATE();
    case 89:
      ACCEPT_TOKEN(aux_sym__kwd_leading_slash_token1);
      if (!aux_sym__kwd_leading_slash_token1_character_set_11(lookahead)) ADVANCE(99);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(71);
      END_STATE();
    case 90:
      ACCEPT_TOKEN(aux_sym__kwd_leading_slash_token1);
      if (!aux_sym__kwd_leading_slash_token1_character_set_12(lookahead)) ADVANCE(98);
      if (lookahead == '/') ADVANCE(99);
      if (lookahead == 'e') ADVANCE(98);
      END_STATE();
    case 91:
      ACCEPT_TOKEN(aux_sym__kwd_leading_slash_token1);
      if (!aux_sym__kwd_leading_slash_token1_character_set_13(lookahead)) ADVANCE(98);
      if (lookahead == '/') ADVANCE(99);
      if (lookahead == 'i') ADVANCE(93);
      END_STATE();
    case 92:
      ACCEPT_TOKEN(aux_sym__kwd_leading_slash_token1);
      if (!aux_sym__kwd_leading_slash_token1_character_set_14(lookahead)) ADVANCE(98);
      if (lookahead == '/') ADVANCE(99);
      if (lookahead == 'l') ADVANCE(95);
      END_STATE();
    case 93:
      ACCEPT_TOKEN(aux_sym__kwd_leading_slash_token1);
      if (!aux_sym__kwd_leading_slash_token1_character_set_14(lookahead)) ADVANCE(98);
      if (lookahead == '/') ADVANCE(99);
      if (lookahead == 'l') ADVANCE(118);
      END_STATE();
    case 94:
      ACCEPT_TOKEN(aux_sym__kwd_leading_slash_token1);
      if (!aux_sym__kwd_leading_slash_token1_character_set_15(lookahead)) ADVANCE(98);
      if (lookahead == '/') ADVANCE(99);
      if (lookahead == 'r') ADVANCE(96);
      END_STATE();
    case 95:
      ACCEPT_TOKEN(aux_sym__kwd_leading_slash_token1);
      if (!aux_sym__kwd_leading_slash_token1_character_set_16(lookahead)) ADVANCE(98);
      if (lookahead == '/') ADVANCE(99);
      if (lookahead == 's') ADVANCE(90);
      END_STATE();
    case 96:
      ACCEPT_TOKEN(aux_sym__kwd_leading_slash_token1);
      if (!aux_sym__kwd_leading_slash_token1_character_set_17(lookahead)) ADVANCE(98);
      if (lookahead == '/') ADVANCE(99);
      if (lookahead == 'u') ADVANCE(90);
      END_STATE();
    case 97:
      ACCEPT_TOKEN(aux_sym__kwd_leading_slash_token1);
      if (!aux_sym__kwd_leading_slash_token1_character_set_18(lookahead)) ADVANCE(98);
      if (lookahead == '/') ADVANCE(99);
      if (lookahead == 'a') ADVANCE(92);
      END_STATE();
    case 98:
      ACCEPT_TOKEN(aux_sym__kwd_leading_slash_token1);
      if (!sym_comment_character_set_1(lookahead)) ADVANCE(98);
      if (lookahead == '/') ADVANCE(99);
      END_STATE();
    case 99:
      ACCEPT_TOKEN(aux_sym__kwd_leading_slash_token1);
      if (!aux_sym__kwd_leading_slash_token1_character_set_1(lookahead)) ADVANCE(99);
      END_STATE();
    case 100:
      ACCEPT_TOKEN(aux_sym__kwd_qualified_token1);
      if (lookahead == '!') ADVANCE(48);
      if (!aux_sym__kwd_qualified_token1_character_set_2(lookahead)) ADVANCE(101);
      if (lookahead == '_') ADVANCE(52);
      END_STATE();
    case 101:
      ACCEPT_TOKEN(aux_sym__kwd_qualified_token1);
      if (!sym_comment_character_set_1(lookahead)) ADVANCE(101);
      END_STATE();
    case 102:
      ACCEPT_TOKEN(anon_sym_COLON);
      if (lookahead == ':') ADVANCE(104);
      END_STATE();
    case 103:
      ACCEPT_TOKEN(anon_sym_COLON);
      if (!aux_sym__kwd_qualified_token1_character_set_1(lookahead)) ADVANCE(99);
      if (lookahead == ':') ADVANCE(105);
      END_STATE();
    case 104:
      ACCEPT_TOKEN(anon_sym_COLON_COLON);
      END_STATE();
    case 105:
      ACCEPT_TOKEN(anon_sym_COLON_COLON);
      if (!aux_sym__kwd_leading_slash_token1_character_set_1(lookahead)) ADVANCE(99);
      END_STATE();
    case 106:
      ACCEPT_TOKEN(aux_sym_str_lit_token1);
      END_STATE();
    case 107:
      ACCEPT_TOKEN(sym_char_lit);
      END_STATE();
    case 108:
      ACCEPT_TOKEN(sym_char_lit);
      if (lookahead == 'a') ADVANCE(12);
      END_STATE();
    case 109:
      ACCEPT_TOKEN(sym_char_lit);
      if (lookahead == 'a') ADVANCE(11);
      END_STATE();
    case 110:
      ACCEPT_TOKEN(sym_char_lit);
      if (lookahead == 'e') ADVANCE(31);
      END_STATE();
    case 111:
      ACCEPT_TOKEN(sym_char_lit);
      if (lookahead == 'e') ADVANCE(29);
      END_STATE();
    case 112:
      ACCEPT_TOKEN(sym_char_lit);
      if (lookahead == 'o') ADVANCE(26);
      END_STATE();
    case 113:
      ACCEPT_TOKEN(sym_char_lit);
      if (lookahead == 'p') ADVANCE(10);
      END_STATE();
    case 114:
      ACCEPT_TOKEN(sym_char_lit);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(107);
      END_STATE();
    case 115:
      ACCEPT_TOKEN(sym_char_lit);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(114);
      END_STATE();
    case 116:
      ACCEPT_TOKEN(sym_char_lit);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(115);
      END_STATE();
    case 117:
      ACCEPT_TOKEN(sym_char_lit);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(38);
      END_STATE();
    case 118:
      ACCEPT_TOKEN(sym_nil_lit);
      if (!sym_comment_character_set_1(lookahead)) ADVANCE(98);
      if (lookahead == '/') ADVANCE(99);
      END_STATE();
    case 119:
      ACCEPT_TOKEN(sym_nil_lit);
      if (!sym_comment_character_set_1(lookahead)) ADVANCE(134);
      END_STATE();
    case 120:
      ACCEPT_TOKEN(sym_bool_lit);
      if (!sym_comment_character_set_1(lookahead)) ADVANCE(134);
      END_STATE();
    case 121:
      ACCEPT_TOKEN(aux_sym__sym_qualified_token1);
      if (lookahead == '0') ADVANCE(64);
      if (!aux_sym__kwd_leading_slash_token1_character_set_10(lookahead)) ADVANCE(134);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(66);
      END_STATE();
    case 122:
      ACCEPT_TOKEN(aux_sym__sym_qualified_token1);
      if (lookahead == 'a') ADVANCE(125);
      if (!sym_comment_character_set_1(lookahead)) ADVANCE(134);
      END_STATE();
    case 123:
      ACCEPT_TOKEN(aux_sym__sym_qualified_token1);
      if (lookahead == 'e') ADVANCE(120);
      if (!sym_comment_character_set_1(lookahead)) ADVANCE(134);
      END_STATE();
    case 124:
      ACCEPT_TOKEN(aux_sym__sym_qualified_token1);
      if (lookahead == 'i') ADVANCE(126);
      if (!sym_comment_character_set_1(lookahead)) ADVANCE(134);
      END_STATE();
    case 125:
      ACCEPT_TOKEN(aux_sym__sym_qualified_token1);
      if (lookahead == 'l') ADVANCE(128);
      if (!sym_comment_character_set_1(lookahead)) ADVANCE(134);
      END_STATE();
    case 126:
      ACCEPT_TOKEN(aux_sym__sym_qualified_token1);
      if (lookahead == 'l') ADVANCE(119);
      if (!sym_comment_character_set_1(lookahead)) ADVANCE(134);
      END_STATE();
    case 127:
      ACCEPT_TOKEN(aux_sym__sym_qualified_token1);
      if (lookahead == 'r') ADVANCE(129);
      if (!sym_comment_character_set_1(lookahead)) ADVANCE(134);
      END_STATE();
    case 128:
      ACCEPT_TOKEN(aux_sym__sym_qualified_token1);
      if (lookahead == 's') ADVANCE(123);
      if (!sym_comment_character_set_1(lookahead)) ADVANCE(134);
      END_STATE();
    case 129:
      ACCEPT_TOKEN(aux_sym__sym_qualified_token1);
      if (lookahead == 'u') ADVANCE(123);
      if (!sym_comment_character_set_1(lookahead)) ADVANCE(134);
      END_STATE();
    case 130:
      ACCEPT_TOKEN(aux_sym__sym_qualified_token1);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(133);
      if (!aux_sym__kwd_leading_slash_token1_character_set_10(lookahead)) ADVANCE(134);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(71);
      END_STATE();
    case 131:
      ACCEPT_TOKEN(aux_sym__sym_qualified_token1);
      if (!aux_sym__kwd_leading_slash_token1_character_set_4(lookahead)) ADVANCE(134);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(74);
      END_STATE();
    case 132:
      ACCEPT_TOKEN(aux_sym__sym_qualified_token1);
      if (!aux_sym__kwd_leading_slash_token1_character_set_6(lookahead)) ADVANCE(134);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(72);
      END_STATE();
    case 133:
      ACCEPT_TOKEN(aux_sym__sym_qualified_token1);
      if (!aux_sym__kwd_leading_slash_token1_character_set_10(lookahead)) ADVANCE(134);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(71);
      END_STATE();
    case 134:
      ACCEPT_TOKEN(aux_sym__sym_qualified_token1);
      if (!sym_comment_character_set_1(lookahead)) ADVANCE(134);
      END_STATE();
    case 135:
      ACCEPT_TOKEN(aux_sym__sym_qualified_token2);
      if (!aux_sym__kwd_leading_slash_token1_character_set_1(lookahead)) ADVANCE(135);
      END_STATE();
    case 136:
      ACCEPT_TOKEN(anon_sym_CARET);
      END_STATE();
    case 137:
      ACCEPT_TOKEN(anon_sym_POUND_CARET);
      END_STATE();
    case 138:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 139:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 140:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 141:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 142:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 143:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 144:
      ACCEPT_TOKEN(anon_sym_POUND);
      if (lookahead == '!') ADVANCE(50);
      if (lookahead == '#') ADVANCE(155);
      if (lookahead == '\'') ADVANCE(153);
      if (lookahead == '=') ADVANCE(157);
      if (lookahead == '?') ADVANCE(149);
      if (lookahead == '^') ADVANCE(137);
      if (lookahead == '_') ADVANCE(51);
      END_STATE();
    case 145:
      ACCEPT_TOKEN(anon_sym_POUND);
      if (lookahead == '!') ADVANCE(50);
      if (lookahead == '\'') ADVANCE(153);
      if (lookahead == '=') ADVANCE(157);
      if (lookahead == '?') ADVANCE(149);
      if (lookahead == '^') ADVANCE(137);
      if (lookahead == '_') ADVANCE(51);
      END_STATE();
    case 146:
      ACCEPT_TOKEN(anon_sym_POUND);
      if (lookahead == '!') ADVANCE(49);
      if (lookahead == '#') ADVANCE(156);
      if (lookahead == '\'') ADVANCE(154);
      if (lookahead == '=') ADVANCE(158);
      if (lookahead == '?') ADVANCE(151);
      if (lookahead == '^') ADVANCE(137);
      if (lookahead == '_') ADVANCE(53);
      if (!aux_sym__kwd_leading_slash_token1_character_set_3(lookahead)) ADVANCE(99);
      END_STATE();
    case 147:
      ACCEPT_TOKEN(anon_sym_POUND);
      if (lookahead == '!') ADVANCE(49);
      if (lookahead == '\'') ADVANCE(154);
      if (lookahead == '=') ADVANCE(158);
      if (lookahead == '?') ADVANCE(151);
      if (lookahead == '^') ADVANCE(137);
      if (lookahead == '_') ADVANCE(53);
      if (!aux_sym__kwd_leading_slash_token1_character_set_3(lookahead)) ADVANCE(99);
      END_STATE();
    case 148:
      ACCEPT_TOKEN(anon_sym_POUND);
      if (lookahead == '\'') ADVANCE(153);
      if (lookahead == '=') ADVANCE(157);
      if (lookahead == '?') ADVANCE(149);
      if (lookahead == '^') ADVANCE(137);
      END_STATE();
    case 149:
      ACCEPT_TOKEN(anon_sym_POUND_QMARK);
      if (lookahead == '@') ADVANCE(152);
      END_STATE();
    case 150:
      ACCEPT_TOKEN(anon_sym_POUND_QMARK);
      if (!aux_sym__kwd_leading_slash_token1_character_set_1(lookahead)) ADVANCE(99);
      END_STATE();
    case 151:
      ACCEPT_TOKEN(anon_sym_POUND_QMARK);
      if (!aux_sym__kwd_leading_slash_token1_character_set_1(lookahead)) ADVANCE(99);
      if (lookahead == '@') ADVANCE(152);
      END_STATE();
    case 152:
      ACCEPT_TOKEN(anon_sym_POUND_QMARK_AT);
      END_STATE();
    case 153:
      ACCEPT_TOKEN(anon_sym_POUND_SQUOTE);
      END_STATE();
    case 154:
      ACCEPT_TOKEN(anon_sym_POUND_SQUOTE);
      if (!aux_sym__kwd_leading_slash_token1_character_set_1(lookahead)) ADVANCE(99);
      END_STATE();
    case 155:
      ACCEPT_TOKEN(anon_sym_POUND_POUND);
      END_STATE();
    case 156:
      ACCEPT_TOKEN(anon_sym_POUND_POUND);
      if (!aux_sym__kwd_leading_slash_token1_character_set_1(lookahead)) ADVANCE(99);
      END_STATE();
    case 157:
      ACCEPT_TOKEN(anon_sym_POUND_EQ);
      END_STATE();
    case 158:
      ACCEPT_TOKEN(anon_sym_POUND_EQ);
      if (!aux_sym__kwd_leading_slash_token1_character_set_1(lookahead)) ADVANCE(99);
      END_STATE();
    case 159:
      ACCEPT_TOKEN(anon_sym_AT);
      END_STATE();
    case 160:
      ACCEPT_TOKEN(anon_sym_SQUOTE);
      END_STATE();
    case 161:
      ACCEPT_TOKEN(anon_sym_SQUOTE);
      if (!aux_sym__kwd_leading_slash_token1_character_set_1(lookahead)) ADVANCE(99);
      END_STATE();
    case 162:
      ACCEPT_TOKEN(anon_sym_BQUOTE);
      END_STATE();
    case 163:
      ACCEPT_TOKEN(anon_sym_TILDE_AT);
      END_STATE();
    case 164:
      ACCEPT_TOKEN(anon_sym_TILDE);
      if (lookahead == '@') ADVANCE(163);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0},
  [1] = {.lex_state = 44},
  [2] = {.lex_state = 44},
  [3] = {.lex_state = 44},
  [4] = {.lex_state = 44},
  [5] = {.lex_state = 44},
  [6] = {.lex_state = 44},
  [7] = {.lex_state = 44},
  [8] = {.lex_state = 44},
  [9] = {.lex_state = 44},
  [10] = {.lex_state = 44},
  [11] = {.lex_state = 44},
  [12] = {.lex_state = 44},
  [13] = {.lex_state = 44},
  [14] = {.lex_state = 44},
  [15] = {.lex_state = 44},
  [16] = {.lex_state = 44},
  [17] = {.lex_state = 44},
  [18] = {.lex_state = 44},
  [19] = {.lex_state = 44},
  [20] = {.lex_state = 44},
  [21] = {.lex_state = 44},
  [22] = {.lex_state = 44},
  [23] = {.lex_state = 44},
  [24] = {.lex_state = 44},
  [25] = {.lex_state = 44},
  [26] = {.lex_state = 44},
  [27] = {.lex_state = 44},
  [28] = {.lex_state = 44},
  [29] = {.lex_state = 44},
  [30] = {.lex_state = 44},
  [31] = {.lex_state = 44},
  [32] = {.lex_state = 44},
  [33] = {.lex_state = 44},
  [34] = {.lex_state = 44},
  [35] = {.lex_state = 44},
  [36] = {.lex_state = 44},
  [37] = {.lex_state = 44},
  [38] = {.lex_state = 44},
  [39] = {.lex_state = 44},
  [40] = {.lex_state = 44},
  [41] = {.lex_state = 44},
  [42] = {.lex_state = 44},
  [43] = {.lex_state = 44},
  [44] = {.lex_state = 44},
  [45] = {.lex_state = 44},
  [46] = {.lex_state = 44},
  [47] = {.lex_state = 44},
  [48] = {.lex_state = 44},
  [49] = {.lex_state = 44},
  [50] = {.lex_state = 44},
  [51] = {.lex_state = 44},
  [52] = {.lex_state = 44},
  [53] = {.lex_state = 44},
  [54] = {.lex_state = 44},
  [55] = {.lex_state = 44},
  [56] = {.lex_state = 44},
  [57] = {.lex_state = 44},
  [58] = {.lex_state = 44},
  [59] = {.lex_state = 44},
  [60] = {.lex_state = 44},
  [61] = {.lex_state = 44},
  [62] = {.lex_state = 44},
  [63] = {.lex_state = 44},
  [64] = {.lex_state = 44},
  [65] = {.lex_state = 44},
  [66] = {.lex_state = 44},
  [67] = {.lex_state = 44},
  [68] = {.lex_state = 44},
  [69] = {.lex_state = 44},
  [70] = {.lex_state = 44},
  [71] = {.lex_state = 44},
  [72] = {.lex_state = 44},
  [73] = {.lex_state = 44},
  [74] = {.lex_state = 44},
  [75] = {.lex_state = 44},
  [76] = {.lex_state = 44},
  [77] = {.lex_state = 44},
  [78] = {.lex_state = 44},
  [79] = {.lex_state = 44},
  [80] = {.lex_state = 44},
  [81] = {.lex_state = 44},
  [82] = {.lex_state = 44},
  [83] = {.lex_state = 44},
  [84] = {.lex_state = 44},
  [85] = {.lex_state = 44},
  [86] = {.lex_state = 44},
  [87] = {.lex_state = 44},
  [88] = {.lex_state = 44},
  [89] = {.lex_state = 44},
  [90] = {.lex_state = 44},
  [91] = {.lex_state = 44},
  [92] = {.lex_state = 44},
  [93] = {.lex_state = 44},
  [94] = {.lex_state = 44},
  [95] = {.lex_state = 44},
  [96] = {.lex_state = 44},
  [97] = {.lex_state = 44},
  [98] = {.lex_state = 44},
  [99] = {.lex_state = 44},
  [100] = {.lex_state = 44},
  [101] = {.lex_state = 44},
  [102] = {.lex_state = 44},
  [103] = {.lex_state = 44},
  [104] = {.lex_state = 44},
  [105] = {.lex_state = 44},
  [106] = {.lex_state = 44},
  [107] = {.lex_state = 44},
  [108] = {.lex_state = 44},
  [109] = {.lex_state = 44},
  [110] = {.lex_state = 44},
  [111] = {.lex_state = 44},
  [112] = {.lex_state = 44},
  [113] = {.lex_state = 44},
  [114] = {.lex_state = 44},
  [115] = {.lex_state = 44},
  [116] = {.lex_state = 44},
  [117] = {.lex_state = 44},
  [118] = {.lex_state = 44},
  [119] = {.lex_state = 44},
  [120] = {.lex_state = 44},
  [121] = {.lex_state = 44},
  [122] = {.lex_state = 44},
  [123] = {.lex_state = 44},
  [124] = {.lex_state = 44},
  [125] = {.lex_state = 44},
  [126] = {.lex_state = 44},
  [127] = {.lex_state = 44},
  [128] = {.lex_state = 44},
  [129] = {.lex_state = 44},
  [130] = {.lex_state = 44},
  [131] = {.lex_state = 44},
  [132] = {.lex_state = 44},
  [133] = {.lex_state = 44},
  [134] = {.lex_state = 44},
  [135] = {.lex_state = 44},
  [136] = {.lex_state = 44},
  [137] = {.lex_state = 44},
  [138] = {.lex_state = 44},
  [139] = {.lex_state = 44},
  [140] = {.lex_state = 44},
  [141] = {.lex_state = 44},
  [142] = {.lex_state = 44},
  [143] = {.lex_state = 44},
  [144] = {.lex_state = 44},
  [145] = {.lex_state = 44},
  [146] = {.lex_state = 44},
  [147] = {.lex_state = 44},
  [148] = {.lex_state = 44},
  [149] = {.lex_state = 44},
  [150] = {.lex_state = 44},
  [151] = {.lex_state = 44},
  [152] = {.lex_state = 44},
  [153] = {.lex_state = 44},
  [154] = {.lex_state = 44},
  [155] = {.lex_state = 44},
  [156] = {.lex_state = 44},
  [157] = {.lex_state = 44},
  [158] = {.lex_state = 44},
  [159] = {.lex_state = 44},
  [160] = {.lex_state = 44},
  [161] = {.lex_state = 44},
  [162] = {.lex_state = 44},
  [163] = {.lex_state = 44},
  [164] = {.lex_state = 44},
  [165] = {.lex_state = 44},
  [166] = {.lex_state = 44},
  [167] = {.lex_state = 44},
  [168] = {.lex_state = 44},
  [169] = {.lex_state = 44},
  [170] = {.lex_state = 44},
  [171] = {.lex_state = 44},
  [172] = {.lex_state = 44},
  [173] = {.lex_state = 44},
  [174] = {.lex_state = 44},
  [175] = {.lex_state = 44},
  [176] = {.lex_state = 44},
  [177] = {.lex_state = 44},
  [178] = {.lex_state = 44},
  [179] = {.lex_state = 44},
  [180] = {.lex_state = 44},
  [181] = {.lex_state = 44},
  [182] = {.lex_state = 44},
  [183] = {.lex_state = 44},
  [184] = {.lex_state = 44},
  [185] = {.lex_state = 44},
  [186] = {.lex_state = 44},
  [187] = {.lex_state = 44},
  [188] = {.lex_state = 44},
  [189] = {.lex_state = 44},
  [190] = {.lex_state = 44},
  [191] = {.lex_state = 44},
  [192] = {.lex_state = 44},
  [193] = {.lex_state = 44},
  [194] = {.lex_state = 44},
  [195] = {.lex_state = 44},
  [196] = {.lex_state = 44},
  [197] = {.lex_state = 44},
  [198] = {.lex_state = 44},
  [199] = {.lex_state = 44},
  [200] = {.lex_state = 44},
  [201] = {.lex_state = 44},
  [202] = {.lex_state = 44},
  [203] = {.lex_state = 44},
  [204] = {.lex_state = 44},
  [205] = {.lex_state = 44},
  [206] = {.lex_state = 44},
  [207] = {.lex_state = 44},
  [208] = {.lex_state = 44},
  [209] = {.lex_state = 44},
  [210] = {.lex_state = 44},
  [211] = {.lex_state = 44},
  [212] = {.lex_state = 44},
  [213] = {.lex_state = 0},
  [214] = {.lex_state = 44},
  [215] = {.lex_state = 44},
  [216] = {.lex_state = 44},
  [217] = {.lex_state = 44},
  [218] = {.lex_state = 44},
  [219] = {.lex_state = 44},
  [220] = {.lex_state = 44},
  [221] = {.lex_state = 44},
  [222] = {.lex_state = 44},
  [223] = {.lex_state = 44},
  [224] = {.lex_state = 44},
  [225] = {.lex_state = 44},
  [226] = {.lex_state = 44},
  [227] = {.lex_state = 44},
  [228] = {.lex_state = 44},
  [229] = {.lex_state = 44},
  [230] = {.lex_state = 44},
  [231] = {.lex_state = 44},
  [232] = {.lex_state = 44},
  [233] = {.lex_state = 44},
  [234] = {.lex_state = 44},
  [235] = {.lex_state = 44},
  [236] = {.lex_state = 44},
  [237] = {.lex_state = 44},
  [238] = {.lex_state = 44},
  [239] = {.lex_state = 44},
  [240] = {.lex_state = 44},
  [241] = {.lex_state = 44},
  [242] = {.lex_state = 44},
  [243] = {.lex_state = 44},
  [244] = {.lex_state = 44},
  [245] = {.lex_state = 44},
  [246] = {.lex_state = 44},
  [247] = {.lex_state = 44},
  [248] = {.lex_state = 44},
  [249] = {.lex_state = 44},
  [250] = {.lex_state = 44},
  [251] = {.lex_state = 44},
  [252] = {.lex_state = 44},
  [253] = {.lex_state = 44},
  [254] = {.lex_state = 44},
  [255] = {.lex_state = 44},
  [256] = {.lex_state = 44},
  [257] = {.lex_state = 44},
  [258] = {.lex_state = 44},
  [259] = {.lex_state = 44},
  [260] = {.lex_state = 44},
  [261] = {.lex_state = 44},
  [262] = {.lex_state = 44},
  [263] = {.lex_state = 44},
  [264] = {.lex_state = 44},
  [265] = {.lex_state = 44},
  [266] = {.lex_state = 44},
  [267] = {.lex_state = 44},
  [268] = {.lex_state = 44},
  [269] = {.lex_state = 44},
  [270] = {.lex_state = 44},
  [271] = {.lex_state = 44},
  [272] = {.lex_state = 44},
  [273] = {.lex_state = 44},
  [274] = {.lex_state = 44},
  [275] = {.lex_state = 44},
  [276] = {.lex_state = 44},
  [277] = {.lex_state = 44},
  [278] = {.lex_state = 44},
  [279] = {.lex_state = 44},
  [280] = {.lex_state = 44},
  [281] = {.lex_state = 44},
  [282] = {.lex_state = 44},
  [283] = {.lex_state = 44},
  [284] = {.lex_state = 44},
  [285] = {.lex_state = 44},
  [286] = {.lex_state = 44},
  [287] = {.lex_state = 44},
  [288] = {.lex_state = 44},
  [289] = {.lex_state = 44},
  [290] = {.lex_state = 44},
  [291] = {.lex_state = 44},
  [292] = {.lex_state = 44},
  [293] = {.lex_state = 44},
  [294] = {.lex_state = 44},
  [295] = {.lex_state = 44},
  [296] = {.lex_state = 44},
  [297] = {.lex_state = 44},
  [298] = {.lex_state = 44},
  [299] = {.lex_state = 44},
  [300] = {.lex_state = 44},
  [301] = {.lex_state = 44},
  [302] = {.lex_state = 44},
  [303] = {.lex_state = 3},
  [304] = {.lex_state = 3},
  [305] = {.lex_state = 3},
  [306] = {.lex_state = 3},
  [307] = {.lex_state = 3},
  [308] = {.lex_state = 1},
  [309] = {.lex_state = 1},
  [310] = {.lex_state = 1},
  [311] = {.lex_state = 1},
  [312] = {.lex_state = 1},
  [313] = {.lex_state = 1},
  [314] = {.lex_state = 1},
  [315] = {.lex_state = 1},
  [316] = {.lex_state = 1},
  [317] = {.lex_state = 1},
  [318] = {.lex_state = 1},
  [319] = {.lex_state = 1},
  [320] = {.lex_state = 1},
  [321] = {.lex_state = 1},
  [322] = {.lex_state = 1},
  [323] = {.lex_state = 4},
  [324] = {.lex_state = 3},
  [325] = {.lex_state = 1},
  [326] = {.lex_state = 1},
  [327] = {.lex_state = 1},
  [328] = {.lex_state = 1},
  [329] = {.lex_state = 1},
  [330] = {.lex_state = 1},
  [331] = {.lex_state = 1},
  [332] = {.lex_state = 1},
  [333] = {.lex_state = 1},
  [334] = {.lex_state = 1},
  [335] = {.lex_state = 1},
  [336] = {.lex_state = 1},
  [337] = {.lex_state = 1},
  [338] = {.lex_state = 1},
  [339] = {.lex_state = 1},
  [340] = {.lex_state = 1},
  [341] = {.lex_state = 1},
  [342] = {.lex_state = 1},
  [343] = {.lex_state = 1},
  [344] = {.lex_state = 1},
  [345] = {.lex_state = 1},
  [346] = {.lex_state = 1},
  [347] = {.lex_state = 1},
  [348] = {.lex_state = 1},
  [349] = {.lex_state = 1},
  [350] = {.lex_state = 1},
  [351] = {.lex_state = 1},
  [352] = {.lex_state = 1},
  [353] = {.lex_state = 1},
  [354] = {.lex_state = 1},
  [355] = {.lex_state = 1},
  [356] = {.lex_state = 1},
  [357] = {.lex_state = 1},
  [358] = {.lex_state = 1},
  [359] = {.lex_state = 1},
  [360] = {.lex_state = 1},
  [361] = {.lex_state = 1},
  [362] = {.lex_state = 1},
  [363] = {.lex_state = 1},
  [364] = {.lex_state = 1},
  [365] = {.lex_state = 1},
  [366] = {.lex_state = 1},
  [367] = {.lex_state = 1},
  [368] = {.lex_state = 1},
  [369] = {.lex_state = 1},
  [370] = {.lex_state = 1},
  [371] = {.lex_state = 1},
  [372] = {.lex_state = 1},
  [373] = {.lex_state = 1},
  [374] = {.lex_state = 1},
  [375] = {.lex_state = 1},
  [376] = {.lex_state = 1},
  [377] = {.lex_state = 1},
  [378] = {.lex_state = 1},
  [379] = {.lex_state = 1},
  [380] = {.lex_state = 1},
  [381] = {.lex_state = 1},
  [382] = {.lex_state = 1},
  [383] = {.lex_state = 1},
  [384] = {.lex_state = 1},
  [385] = {.lex_state = 1},
  [386] = {.lex_state = 1},
  [387] = {.lex_state = 1},
  [388] = {.lex_state = 1},
  [389] = {.lex_state = 1},
  [390] = {.lex_state = 1},
  [391] = {.lex_state = 1},
  [392] = {.lex_state = 1},
  [393] = {.lex_state = 1},
  [394] = {.lex_state = 1},
  [395] = {.lex_state = 1},
  [396] = {.lex_state = 1},
  [397] = {.lex_state = 1},
  [398] = {.lex_state = 1},
  [399] = {.lex_state = 1},
  [400] = {.lex_state = 1},
  [401] = {.lex_state = 1},
  [402] = {.lex_state = 1},
  [403] = {.lex_state = 1},
  [404] = {.lex_state = 1},
  [405] = {.lex_state = 1},
  [406] = {.lex_state = 1},
  [407] = {.lex_state = 1},
  [408] = {.lex_state = 1},
  [409] = {.lex_state = 1},
  [410] = {.lex_state = 1},
  [411] = {.lex_state = 1},
  [412] = {.lex_state = 1},
  [413] = {.lex_state = 1},
  [414] = {.lex_state = 1},
  [415] = {.lex_state = 1},
  [416] = {.lex_state = 1},
  [417] = {.lex_state = 1},
  [418] = {.lex_state = 1},
  [419] = {.lex_state = 1},
  [420] = {.lex_state = 1},
  [421] = {.lex_state = 1},
  [422] = {.lex_state = 1},
  [423] = {.lex_state = 1},
  [424] = {.lex_state = 3},
  [425] = {.lex_state = 1},
  [426] = {.lex_state = 1},
  [427] = {.lex_state = 1},
  [428] = {.lex_state = 1},
  [429] = {.lex_state = 1},
  [430] = {.lex_state = 1},
  [431] = {.lex_state = 1},
  [432] = {.lex_state = 1},
  [433] = {.lex_state = 1},
  [434] = {.lex_state = 1},
  [435] = {.lex_state = 1},
  [436] = {.lex_state = 1},
  [437] = {.lex_state = 1},
  [438] = {.lex_state = 1},
  [439] = {.lex_state = 1},
  [440] = {.lex_state = 3},
  [441] = {.lex_state = 3},
  [442] = {.lex_state = 1},
  [443] = {.lex_state = 5},
  [444] = {.lex_state = 3},
  [445] = {.lex_state = 1},
  [446] = {.lex_state = 1},
  [447] = {.lex_state = 1},
  [448] = {.lex_state = 1},
  [449] = {.lex_state = 3},
  [450] = {.lex_state = 44},
  [451] = {.lex_state = 44},
  [452] = {.lex_state = 3},
  [453] = {.lex_state = 44},
  [454] = {.lex_state = 44},
  [455] = {.lex_state = 6},
  [456] = {.lex_state = 44},
  [457] = {.lex_state = 44},
  [458] = {.lex_state = 44},
  [459] = {.lex_state = 44},
  [460] = {.lex_state = 44},
  [461] = {.lex_state = 44},
  [462] = {.lex_state = 44},
  [463] = {.lex_state = 44},
  [464] = {.lex_state = 44},
  [465] = {.lex_state = 7},
  [466] = {.lex_state = 8},
  [467] = {.lex_state = 0},
  [468] = {.lex_state = 0},
  [469] = {.lex_state = 0},
  [470] = {.lex_state = 0},
  [471] = {.lex_state = 0},
  [472] = {.lex_state = 0},
  [473] = {.lex_state = 0},
  [474] = {.lex_state = 0},
  [475] = {.lex_state = 0},
  [476] = {.lex_state = 0},
  [477] = {.lex_state = 0},
  [478] = {.lex_state = 0},
  [479] = {.lex_state = 0},
  [480] = {.lex_state = 0},
  [481] = {.lex_state = 0},
  [482] = {.lex_state = 0},
  [483] = {.lex_state = 0},
  [484] = {.lex_state = 9},
  [485] = {.lex_state = 9},
  [486] = {.lex_state = 9},
  [487] = {.lex_state = 9},
  [488] = {.lex_state = 9},
  [489] = {.lex_state = 41},
  [490] = {.lex_state = 40},
  [491] = {.lex_state = 41},
  [492] = {.lex_state = 41},
  [493] = {.lex_state = 0},
  [494] = {.lex_state = 40},
  [495] = {.lex_state = 41},
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym__ws] = ACTIONS(1),
    [sym_comment] = ACTIONS(1),
    [anon_sym_POUND_] = ACTIONS(1),
    [sym_num_lit] = ACTIONS(1),
    [anon_sym_SLASH] = ACTIONS(1),
    [aux_sym__kwd_leading_slash_token1] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_COLON_COLON] = ACTIONS(1),
    [aux_sym_str_lit_token1] = ACTIONS(1),
    [sym_char_lit] = ACTIONS(1),
    [sym_nil_lit] = ACTIONS(1),
    [sym_bool_lit] = ACTIONS(1),
    [aux_sym__sym_qualified_token1] = ACTIONS(1),
    [anon_sym_CARET] = ACTIONS(1),
    [anon_sym_POUND_CARET] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_POUND] = ACTIONS(1),
    [anon_sym_POUND_QMARK] = ACTIONS(1),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(1),
    [anon_sym_POUND_SQUOTE] = ACTIONS(1),
    [anon_sym_POUND_POUND] = ACTIONS(1),
    [anon_sym_POUND_EQ] = ACTIONS(1),
    [anon_sym_AT] = ACTIONS(1),
    [anon_sym_SQUOTE] = ACTIONS(1),
    [anon_sym_BQUOTE] = ACTIONS(1),
    [anon_sym_TILDE_AT] = ACTIONS(1),
    [anon_sym_TILDE] = ACTIONS(1),
  },
  [1] = {
    [sym_source] = STATE(493),
    [sym__gap] = STATE(19),
    [sym_dis_expr] = STATE(19),
    [sym__form] = STATE(19),
    [sym_kwd_lit] = STATE(19),
    [sym_str_lit] = STATE(19),
    [sym_sym_lit] = STATE(19),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(19),
    [sym__bare_list_lit] = STATE(218),
    [sym_map_lit] = STATE(19),
    [sym__bare_map_lit] = STATE(219),
    [sym_vec_lit] = STATE(19),
    [sym__bare_vec_lit] = STATE(226),
    [sym_set_lit] = STATE(19),
    [sym__bare_set_lit] = STATE(227),
    [sym_anon_fn_lit] = STATE(19),
    [sym_regex_lit] = STATE(19),
    [sym_read_cond_lit] = STATE(19),
    [sym_splicing_read_cond_lit] = STATE(19),
    [sym_ns_map_lit] = STATE(19),
    [sym_var_quoting_lit] = STATE(19),
    [sym_sym_val_lit] = STATE(19),
    [sym_evaling_lit] = STATE(19),
    [sym_tagged_or_ctor_lit] = STATE(19),
    [sym_derefing_lit] = STATE(19),
    [sym_quoting_lit] = STATE(19),
    [sym_syn_quoting_lit] = STATE(19),
    [sym_unquote_splicing_lit] = STATE(19),
    [sym_unquoting_lit] = STATE(19),
    [aux_sym_source_repeat1] = STATE(19),
    [aux_sym_sym_lit_repeat1] = STATE(305),
    [ts_builtin_sym_end] = ACTIONS(3),
    [sym__ws] = ACTIONS(5),
    [sym_comment] = ACTIONS(5),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(5),
    [anon_sym_SLASH] = ACTIONS(9),
    [anon_sym_COLON] = ACTIONS(11),
    [anon_sym_COLON_COLON] = ACTIONS(13),
    [aux_sym_str_lit_token1] = ACTIONS(15),
    [sym_char_lit] = ACTIONS(5),
    [sym_nil_lit] = ACTIONS(17),
    [sym_bool_lit] = ACTIONS(17),
    [aux_sym__sym_qualified_token1] = ACTIONS(19),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_POUND] = ACTIONS(31),
    [anon_sym_POUND_QMARK] = ACTIONS(33),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(35),
    [anon_sym_POUND_SQUOTE] = ACTIONS(37),
    [anon_sym_POUND_POUND] = ACTIONS(39),
    [anon_sym_POUND_EQ] = ACTIONS(41),
    [anon_sym_AT] = ACTIONS(43),
    [anon_sym_SQUOTE] = ACTIONS(45),
    [anon_sym_BQUOTE] = ACTIONS(47),
    [anon_sym_TILDE_AT] = ACTIONS(49),
    [anon_sym_TILDE] = ACTIONS(51),
  },
  [2] = {
    [sym__gap] = STATE(2),
    [sym_dis_expr] = STATE(2),
    [sym__form] = STATE(302),
    [sym_kwd_lit] = STATE(302),
    [sym_str_lit] = STATE(302),
    [sym_sym_lit] = STATE(302),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(302),
    [sym__bare_list_lit] = STATE(218),
    [sym_map_lit] = STATE(302),
    [sym__bare_map_lit] = STATE(219),
    [sym_vec_lit] = STATE(302),
    [sym__bare_vec_lit] = STATE(226),
    [sym_set_lit] = STATE(302),
    [sym__bare_set_lit] = STATE(227),
    [sym_anon_fn_lit] = STATE(302),
    [sym_regex_lit] = STATE(302),
    [sym_read_cond_lit] = STATE(302),
    [sym_splicing_read_cond_lit] = STATE(302),
    [sym_ns_map_lit] = STATE(302),
    [sym_var_quoting_lit] = STATE(302),
    [sym_sym_val_lit] = STATE(302),
    [sym_evaling_lit] = STATE(302),
    [sym_tagged_or_ctor_lit] = STATE(302),
    [sym_derefing_lit] = STATE(302),
    [sym_quoting_lit] = STATE(302),
    [sym_syn_quoting_lit] = STATE(302),
    [sym_unquote_splicing_lit] = STATE(302),
    [sym_unquoting_lit] = STATE(302),
    [aux_sym_sym_lit_repeat1] = STATE(305),
    [aux_sym__bare_list_lit_repeat1] = STATE(2),
    [sym__ws] = ACTIONS(53),
    [sym_comment] = ACTIONS(53),
    [anon_sym_POUND_] = ACTIONS(56),
    [sym_num_lit] = ACTIONS(59),
    [anon_sym_SLASH] = ACTIONS(62),
    [anon_sym_COLON] = ACTIONS(65),
    [anon_sym_COLON_COLON] = ACTIONS(68),
    [aux_sym_str_lit_token1] = ACTIONS(71),
    [sym_char_lit] = ACTIONS(59),
    [sym_nil_lit] = ACTIONS(74),
    [sym_bool_lit] = ACTIONS(74),
    [aux_sym__sym_qualified_token1] = ACTIONS(77),
    [anon_sym_CARET] = ACTIONS(80),
    [anon_sym_POUND_CARET] = ACTIONS(83),
    [anon_sym_LPAREN] = ACTIONS(86),
    [anon_sym_RPAREN] = ACTIONS(89),
    [anon_sym_LBRACE] = ACTIONS(91),
    [anon_sym_RBRACE] = ACTIONS(89),
    [anon_sym_LBRACK] = ACTIONS(94),
    [anon_sym_RBRACK] = ACTIONS(89),
    [anon_sym_POUND] = ACTIONS(97),
    [anon_sym_POUND_QMARK] = ACTIONS(100),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(103),
    [anon_sym_POUND_SQUOTE] = ACTIONS(106),
    [anon_sym_POUND_POUND] = ACTIONS(109),
    [anon_sym_POUND_EQ] = ACTIONS(112),
    [anon_sym_AT] = ACTIONS(115),
    [anon_sym_SQUOTE] = ACTIONS(118),
    [anon_sym_BQUOTE] = ACTIONS(121),
    [anon_sym_TILDE_AT] = ACTIONS(124),
    [anon_sym_TILDE] = ACTIONS(127),
  },
  [3] = {
    [sym__gap] = STATE(2),
    [sym_dis_expr] = STATE(2),
    [sym__form] = STATE(302),
    [sym_kwd_lit] = STATE(302),
    [sym_str_lit] = STATE(302),
    [sym_sym_lit] = STATE(302),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(302),
    [sym__bare_list_lit] = STATE(218),
    [sym_map_lit] = STATE(302),
    [sym__bare_map_lit] = STATE(219),
    [sym_vec_lit] = STATE(302),
    [sym__bare_vec_lit] = STATE(226),
    [sym_set_lit] = STATE(302),
    [sym__bare_set_lit] = STATE(227),
    [sym_anon_fn_lit] = STATE(302),
    [sym_regex_lit] = STATE(302),
    [sym_read_cond_lit] = STATE(302),
    [sym_splicing_read_cond_lit] = STATE(302),
    [sym_ns_map_lit] = STATE(302),
    [sym_var_quoting_lit] = STATE(302),
    [sym_sym_val_lit] = STATE(302),
    [sym_evaling_lit] = STATE(302),
    [sym_tagged_or_ctor_lit] = STATE(302),
    [sym_derefing_lit] = STATE(302),
    [sym_quoting_lit] = STATE(302),
    [sym_syn_quoting_lit] = STATE(302),
    [sym_unquote_splicing_lit] = STATE(302),
    [sym_unquoting_lit] = STATE(302),
    [aux_sym_sym_lit_repeat1] = STATE(305),
    [aux_sym__bare_list_lit_repeat1] = STATE(2),
    [sym__ws] = ACTIONS(130),
    [sym_comment] = ACTIONS(130),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(132),
    [anon_sym_SLASH] = ACTIONS(9),
    [anon_sym_COLON] = ACTIONS(11),
    [anon_sym_COLON_COLON] = ACTIONS(13),
    [aux_sym_str_lit_token1] = ACTIONS(15),
    [sym_char_lit] = ACTIONS(132),
    [sym_nil_lit] = ACTIONS(134),
    [sym_bool_lit] = ACTIONS(134),
    [aux_sym__sym_qualified_token1] = ACTIONS(19),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_RPAREN] = ACTIONS(136),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_POUND] = ACTIONS(31),
    [anon_sym_POUND_QMARK] = ACTIONS(33),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(35),
    [anon_sym_POUND_SQUOTE] = ACTIONS(37),
    [anon_sym_POUND_POUND] = ACTIONS(39),
    [anon_sym_POUND_EQ] = ACTIONS(41),
    [anon_sym_AT] = ACTIONS(43),
    [anon_sym_SQUOTE] = ACTIONS(45),
    [anon_sym_BQUOTE] = ACTIONS(47),
    [anon_sym_TILDE_AT] = ACTIONS(49),
    [anon_sym_TILDE] = ACTIONS(51),
  },
  [4] = {
    [sym__gap] = STATE(7),
    [sym_dis_expr] = STATE(7),
    [sym__form] = STATE(302),
    [sym_kwd_lit] = STATE(302),
    [sym_str_lit] = STATE(302),
    [sym_sym_lit] = STATE(302),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(302),
    [sym__bare_list_lit] = STATE(218),
    [sym_map_lit] = STATE(302),
    [sym__bare_map_lit] = STATE(219),
    [sym_vec_lit] = STATE(302),
    [sym__bare_vec_lit] = STATE(226),
    [sym_set_lit] = STATE(302),
    [sym__bare_set_lit] = STATE(227),
    [sym_anon_fn_lit] = STATE(302),
    [sym_regex_lit] = STATE(302),
    [sym_read_cond_lit] = STATE(302),
    [sym_splicing_read_cond_lit] = STATE(302),
    [sym_ns_map_lit] = STATE(302),
    [sym_var_quoting_lit] = STATE(302),
    [sym_sym_val_lit] = STATE(302),
    [sym_evaling_lit] = STATE(302),
    [sym_tagged_or_ctor_lit] = STATE(302),
    [sym_derefing_lit] = STATE(302),
    [sym_quoting_lit] = STATE(302),
    [sym_syn_quoting_lit] = STATE(302),
    [sym_unquote_splicing_lit] = STATE(302),
    [sym_unquoting_lit] = STATE(302),
    [aux_sym_sym_lit_repeat1] = STATE(305),
    [aux_sym__bare_list_lit_repeat1] = STATE(7),
    [sym__ws] = ACTIONS(138),
    [sym_comment] = ACTIONS(138),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(132),
    [anon_sym_SLASH] = ACTIONS(9),
    [anon_sym_COLON] = ACTIONS(11),
    [anon_sym_COLON_COLON] = ACTIONS(13),
    [aux_sym_str_lit_token1] = ACTIONS(15),
    [sym_char_lit] = ACTIONS(132),
    [sym_nil_lit] = ACTIONS(134),
    [sym_bool_lit] = ACTIONS(134),
    [aux_sym__sym_qualified_token1] = ACTIONS(19),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_RBRACK] = ACTIONS(140),
    [anon_sym_POUND] = ACTIONS(31),
    [anon_sym_POUND_QMARK] = ACTIONS(33),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(35),
    [anon_sym_POUND_SQUOTE] = ACTIONS(37),
    [anon_sym_POUND_POUND] = ACTIONS(39),
    [anon_sym_POUND_EQ] = ACTIONS(41),
    [anon_sym_AT] = ACTIONS(43),
    [anon_sym_SQUOTE] = ACTIONS(45),
    [anon_sym_BQUOTE] = ACTIONS(47),
    [anon_sym_TILDE_AT] = ACTIONS(49),
    [anon_sym_TILDE] = ACTIONS(51),
  },
  [5] = {
    [sym__gap] = STATE(2),
    [sym_dis_expr] = STATE(2),
    [sym__form] = STATE(302),
    [sym_kwd_lit] = STATE(302),
    [sym_str_lit] = STATE(302),
    [sym_sym_lit] = STATE(302),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(302),
    [sym__bare_list_lit] = STATE(218),
    [sym_map_lit] = STATE(302),
    [sym__bare_map_lit] = STATE(219),
    [sym_vec_lit] = STATE(302),
    [sym__bare_vec_lit] = STATE(226),
    [sym_set_lit] = STATE(302),
    [sym__bare_set_lit] = STATE(227),
    [sym_anon_fn_lit] = STATE(302),
    [sym_regex_lit] = STATE(302),
    [sym_read_cond_lit] = STATE(302),
    [sym_splicing_read_cond_lit] = STATE(302),
    [sym_ns_map_lit] = STATE(302),
    [sym_var_quoting_lit] = STATE(302),
    [sym_sym_val_lit] = STATE(302),
    [sym_evaling_lit] = STATE(302),
    [sym_tagged_or_ctor_lit] = STATE(302),
    [sym_derefing_lit] = STATE(302),
    [sym_quoting_lit] = STATE(302),
    [sym_syn_quoting_lit] = STATE(302),
    [sym_unquote_splicing_lit] = STATE(302),
    [sym_unquoting_lit] = STATE(302),
    [aux_sym_sym_lit_repeat1] = STATE(305),
    [aux_sym__bare_list_lit_repeat1] = STATE(2),
    [sym__ws] = ACTIONS(130),
    [sym_comment] = ACTIONS(130),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(132),
    [anon_sym_SLASH] = ACTIONS(9),
    [anon_sym_COLON] = ACTIONS(11),
    [anon_sym_COLON_COLON] = ACTIONS(13),
    [aux_sym_str_lit_token1] = ACTIONS(15),
    [sym_char_lit] = ACTIONS(132),
    [sym_nil_lit] = ACTIONS(134),
    [sym_bool_lit] = ACTIONS(134),
    [aux_sym__sym_qualified_token1] = ACTIONS(19),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_RBRACK] = ACTIONS(142),
    [anon_sym_POUND] = ACTIONS(31),
    [anon_sym_POUND_QMARK] = ACTIONS(33),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(35),
    [anon_sym_POUND_SQUOTE] = ACTIONS(37),
    [anon_sym_POUND_POUND] = ACTIONS(39),
    [anon_sym_POUND_EQ] = ACTIONS(41),
    [anon_sym_AT] = ACTIONS(43),
    [anon_sym_SQUOTE] = ACTIONS(45),
    [anon_sym_BQUOTE] = ACTIONS(47),
    [anon_sym_TILDE_AT] = ACTIONS(49),
    [anon_sym_TILDE] = ACTIONS(51),
  },
  [6] = {
    [sym__gap] = STATE(2),
    [sym_dis_expr] = STATE(2),
    [sym__form] = STATE(302),
    [sym_kwd_lit] = STATE(302),
    [sym_str_lit] = STATE(302),
    [sym_sym_lit] = STATE(302),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(302),
    [sym__bare_list_lit] = STATE(218),
    [sym_map_lit] = STATE(302),
    [sym__bare_map_lit] = STATE(219),
    [sym_vec_lit] = STATE(302),
    [sym__bare_vec_lit] = STATE(226),
    [sym_set_lit] = STATE(302),
    [sym__bare_set_lit] = STATE(227),
    [sym_anon_fn_lit] = STATE(302),
    [sym_regex_lit] = STATE(302),
    [sym_read_cond_lit] = STATE(302),
    [sym_splicing_read_cond_lit] = STATE(302),
    [sym_ns_map_lit] = STATE(302),
    [sym_var_quoting_lit] = STATE(302),
    [sym_sym_val_lit] = STATE(302),
    [sym_evaling_lit] = STATE(302),
    [sym_tagged_or_ctor_lit] = STATE(302),
    [sym_derefing_lit] = STATE(302),
    [sym_quoting_lit] = STATE(302),
    [sym_syn_quoting_lit] = STATE(302),
    [sym_unquote_splicing_lit] = STATE(302),
    [sym_unquoting_lit] = STATE(302),
    [aux_sym_sym_lit_repeat1] = STATE(305),
    [aux_sym__bare_list_lit_repeat1] = STATE(2),
    [sym__ws] = ACTIONS(130),
    [sym_comment] = ACTIONS(130),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(132),
    [anon_sym_SLASH] = ACTIONS(9),
    [anon_sym_COLON] = ACTIONS(11),
    [anon_sym_COLON_COLON] = ACTIONS(13),
    [aux_sym_str_lit_token1] = ACTIONS(15),
    [sym_char_lit] = ACTIONS(132),
    [sym_nil_lit] = ACTIONS(134),
    [sym_bool_lit] = ACTIONS(134),
    [aux_sym__sym_qualified_token1] = ACTIONS(19),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_RBRACE] = ACTIONS(144),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_POUND] = ACTIONS(31),
    [anon_sym_POUND_QMARK] = ACTIONS(33),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(35),
    [anon_sym_POUND_SQUOTE] = ACTIONS(37),
    [anon_sym_POUND_POUND] = ACTIONS(39),
    [anon_sym_POUND_EQ] = ACTIONS(41),
    [anon_sym_AT] = ACTIONS(43),
    [anon_sym_SQUOTE] = ACTIONS(45),
    [anon_sym_BQUOTE] = ACTIONS(47),
    [anon_sym_TILDE_AT] = ACTIONS(49),
    [anon_sym_TILDE] = ACTIONS(51),
  },
  [7] = {
    [sym__gap] = STATE(2),
    [sym_dis_expr] = STATE(2),
    [sym__form] = STATE(302),
    [sym_kwd_lit] = STATE(302),
    [sym_str_lit] = STATE(302),
    [sym_sym_lit] = STATE(302),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(302),
    [sym__bare_list_lit] = STATE(218),
    [sym_map_lit] = STATE(302),
    [sym__bare_map_lit] = STATE(219),
    [sym_vec_lit] = STATE(302),
    [sym__bare_vec_lit] = STATE(226),
    [sym_set_lit] = STATE(302),
    [sym__bare_set_lit] = STATE(227),
    [sym_anon_fn_lit] = STATE(302),
    [sym_regex_lit] = STATE(302),
    [sym_read_cond_lit] = STATE(302),
    [sym_splicing_read_cond_lit] = STATE(302),
    [sym_ns_map_lit] = STATE(302),
    [sym_var_quoting_lit] = STATE(302),
    [sym_sym_val_lit] = STATE(302),
    [sym_evaling_lit] = STATE(302),
    [sym_tagged_or_ctor_lit] = STATE(302),
    [sym_derefing_lit] = STATE(302),
    [sym_quoting_lit] = STATE(302),
    [sym_syn_quoting_lit] = STATE(302),
    [sym_unquote_splicing_lit] = STATE(302),
    [sym_unquoting_lit] = STATE(302),
    [aux_sym_sym_lit_repeat1] = STATE(305),
    [aux_sym__bare_list_lit_repeat1] = STATE(2),
    [sym__ws] = ACTIONS(130),
    [sym_comment] = ACTIONS(130),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(132),
    [anon_sym_SLASH] = ACTIONS(9),
    [anon_sym_COLON] = ACTIONS(11),
    [anon_sym_COLON_COLON] = ACTIONS(13),
    [aux_sym_str_lit_token1] = ACTIONS(15),
    [sym_char_lit] = ACTIONS(132),
    [sym_nil_lit] = ACTIONS(134),
    [sym_bool_lit] = ACTIONS(134),
    [aux_sym__sym_qualified_token1] = ACTIONS(19),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_RBRACK] = ACTIONS(146),
    [anon_sym_POUND] = ACTIONS(31),
    [anon_sym_POUND_QMARK] = ACTIONS(33),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(35),
    [anon_sym_POUND_SQUOTE] = ACTIONS(37),
    [anon_sym_POUND_POUND] = ACTIONS(39),
    [anon_sym_POUND_EQ] = ACTIONS(41),
    [anon_sym_AT] = ACTIONS(43),
    [anon_sym_SQUOTE] = ACTIONS(45),
    [anon_sym_BQUOTE] = ACTIONS(47),
    [anon_sym_TILDE_AT] = ACTIONS(49),
    [anon_sym_TILDE] = ACTIONS(51),
  },
  [8] = {
    [sym__gap] = STATE(12),
    [sym_dis_expr] = STATE(12),
    [sym__form] = STATE(302),
    [sym_kwd_lit] = STATE(302),
    [sym_str_lit] = STATE(302),
    [sym_sym_lit] = STATE(302),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(302),
    [sym__bare_list_lit] = STATE(218),
    [sym_map_lit] = STATE(302),
    [sym__bare_map_lit] = STATE(219),
    [sym_vec_lit] = STATE(302),
    [sym__bare_vec_lit] = STATE(226),
    [sym_set_lit] = STATE(302),
    [sym__bare_set_lit] = STATE(227),
    [sym_anon_fn_lit] = STATE(302),
    [sym_regex_lit] = STATE(302),
    [sym_read_cond_lit] = STATE(302),
    [sym_splicing_read_cond_lit] = STATE(302),
    [sym_ns_map_lit] = STATE(302),
    [sym_var_quoting_lit] = STATE(302),
    [sym_sym_val_lit] = STATE(302),
    [sym_evaling_lit] = STATE(302),
    [sym_tagged_or_ctor_lit] = STATE(302),
    [sym_derefing_lit] = STATE(302),
    [sym_quoting_lit] = STATE(302),
    [sym_syn_quoting_lit] = STATE(302),
    [sym_unquote_splicing_lit] = STATE(302),
    [sym_unquoting_lit] = STATE(302),
    [aux_sym_sym_lit_repeat1] = STATE(305),
    [aux_sym__bare_list_lit_repeat1] = STATE(12),
    [sym__ws] = ACTIONS(148),
    [sym_comment] = ACTIONS(148),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(132),
    [anon_sym_SLASH] = ACTIONS(9),
    [anon_sym_COLON] = ACTIONS(11),
    [anon_sym_COLON_COLON] = ACTIONS(13),
    [aux_sym_str_lit_token1] = ACTIONS(15),
    [sym_char_lit] = ACTIONS(132),
    [sym_nil_lit] = ACTIONS(134),
    [sym_bool_lit] = ACTIONS(134),
    [aux_sym__sym_qualified_token1] = ACTIONS(19),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_RBRACE] = ACTIONS(150),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_POUND] = ACTIONS(31),
    [anon_sym_POUND_QMARK] = ACTIONS(33),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(35),
    [anon_sym_POUND_SQUOTE] = ACTIONS(37),
    [anon_sym_POUND_POUND] = ACTIONS(39),
    [anon_sym_POUND_EQ] = ACTIONS(41),
    [anon_sym_AT] = ACTIONS(43),
    [anon_sym_SQUOTE] = ACTIONS(45),
    [anon_sym_BQUOTE] = ACTIONS(47),
    [anon_sym_TILDE_AT] = ACTIONS(49),
    [anon_sym_TILDE] = ACTIONS(51),
  },
  [9] = {
    [sym__gap] = STATE(16),
    [sym_dis_expr] = STATE(16),
    [sym__form] = STATE(302),
    [sym_kwd_lit] = STATE(302),
    [sym_str_lit] = STATE(302),
    [sym_sym_lit] = STATE(302),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(302),
    [sym__bare_list_lit] = STATE(218),
    [sym_map_lit] = STATE(302),
    [sym__bare_map_lit] = STATE(219),
    [sym_vec_lit] = STATE(302),
    [sym__bare_vec_lit] = STATE(226),
    [sym_set_lit] = STATE(302),
    [sym__bare_set_lit] = STATE(227),
    [sym_anon_fn_lit] = STATE(302),
    [sym_regex_lit] = STATE(302),
    [sym_read_cond_lit] = STATE(302),
    [sym_splicing_read_cond_lit] = STATE(302),
    [sym_ns_map_lit] = STATE(302),
    [sym_var_quoting_lit] = STATE(302),
    [sym_sym_val_lit] = STATE(302),
    [sym_evaling_lit] = STATE(302),
    [sym_tagged_or_ctor_lit] = STATE(302),
    [sym_derefing_lit] = STATE(302),
    [sym_quoting_lit] = STATE(302),
    [sym_syn_quoting_lit] = STATE(302),
    [sym_unquote_splicing_lit] = STATE(302),
    [sym_unquoting_lit] = STATE(302),
    [aux_sym_sym_lit_repeat1] = STATE(305),
    [aux_sym__bare_list_lit_repeat1] = STATE(16),
    [sym__ws] = ACTIONS(152),
    [sym_comment] = ACTIONS(152),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(132),
    [anon_sym_SLASH] = ACTIONS(9),
    [anon_sym_COLON] = ACTIONS(11),
    [anon_sym_COLON_COLON] = ACTIONS(13),
    [aux_sym_str_lit_token1] = ACTIONS(15),
    [sym_char_lit] = ACTIONS(132),
    [sym_nil_lit] = ACTIONS(134),
    [sym_bool_lit] = ACTIONS(134),
    [aux_sym__sym_qualified_token1] = ACTIONS(19),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_RPAREN] = ACTIONS(154),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_POUND] = ACTIONS(31),
    [anon_sym_POUND_QMARK] = ACTIONS(33),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(35),
    [anon_sym_POUND_SQUOTE] = ACTIONS(37),
    [anon_sym_POUND_POUND] = ACTIONS(39),
    [anon_sym_POUND_EQ] = ACTIONS(41),
    [anon_sym_AT] = ACTIONS(43),
    [anon_sym_SQUOTE] = ACTIONS(45),
    [anon_sym_BQUOTE] = ACTIONS(47),
    [anon_sym_TILDE_AT] = ACTIONS(49),
    [anon_sym_TILDE] = ACTIONS(51),
  },
  [10] = {
    [sym__gap] = STATE(18),
    [sym_dis_expr] = STATE(18),
    [sym__form] = STATE(302),
    [sym_kwd_lit] = STATE(302),
    [sym_str_lit] = STATE(302),
    [sym_sym_lit] = STATE(302),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(302),
    [sym__bare_list_lit] = STATE(218),
    [sym_map_lit] = STATE(302),
    [sym__bare_map_lit] = STATE(219),
    [sym_vec_lit] = STATE(302),
    [sym__bare_vec_lit] = STATE(226),
    [sym_set_lit] = STATE(302),
    [sym__bare_set_lit] = STATE(227),
    [sym_anon_fn_lit] = STATE(302),
    [sym_regex_lit] = STATE(302),
    [sym_read_cond_lit] = STATE(302),
    [sym_splicing_read_cond_lit] = STATE(302),
    [sym_ns_map_lit] = STATE(302),
    [sym_var_quoting_lit] = STATE(302),
    [sym_sym_val_lit] = STATE(302),
    [sym_evaling_lit] = STATE(302),
    [sym_tagged_or_ctor_lit] = STATE(302),
    [sym_derefing_lit] = STATE(302),
    [sym_quoting_lit] = STATE(302),
    [sym_syn_quoting_lit] = STATE(302),
    [sym_unquote_splicing_lit] = STATE(302),
    [sym_unquoting_lit] = STATE(302),
    [aux_sym_sym_lit_repeat1] = STATE(305),
    [aux_sym__bare_list_lit_repeat1] = STATE(18),
    [sym__ws] = ACTIONS(156),
    [sym_comment] = ACTIONS(156),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(132),
    [anon_sym_SLASH] = ACTIONS(9),
    [anon_sym_COLON] = ACTIONS(11),
    [anon_sym_COLON_COLON] = ACTIONS(13),
    [aux_sym_str_lit_token1] = ACTIONS(15),
    [sym_char_lit] = ACTIONS(132),
    [sym_nil_lit] = ACTIONS(134),
    [sym_bool_lit] = ACTIONS(134),
    [aux_sym__sym_qualified_token1] = ACTIONS(19),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_RBRACE] = ACTIONS(158),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_POUND] = ACTIONS(31),
    [anon_sym_POUND_QMARK] = ACTIONS(33),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(35),
    [anon_sym_POUND_SQUOTE] = ACTIONS(37),
    [anon_sym_POUND_POUND] = ACTIONS(39),
    [anon_sym_POUND_EQ] = ACTIONS(41),
    [anon_sym_AT] = ACTIONS(43),
    [anon_sym_SQUOTE] = ACTIONS(45),
    [anon_sym_BQUOTE] = ACTIONS(47),
    [anon_sym_TILDE_AT] = ACTIONS(49),
    [anon_sym_TILDE] = ACTIONS(51),
  },
  [11] = {
    [sym__gap] = STATE(5),
    [sym_dis_expr] = STATE(5),
    [sym__form] = STATE(302),
    [sym_kwd_lit] = STATE(302),
    [sym_str_lit] = STATE(302),
    [sym_sym_lit] = STATE(302),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(302),
    [sym__bare_list_lit] = STATE(218),
    [sym_map_lit] = STATE(302),
    [sym__bare_map_lit] = STATE(219),
    [sym_vec_lit] = STATE(302),
    [sym__bare_vec_lit] = STATE(226),
    [sym_set_lit] = STATE(302),
    [sym__bare_set_lit] = STATE(227),
    [sym_anon_fn_lit] = STATE(302),
    [sym_regex_lit] = STATE(302),
    [sym_read_cond_lit] = STATE(302),
    [sym_splicing_read_cond_lit] = STATE(302),
    [sym_ns_map_lit] = STATE(302),
    [sym_var_quoting_lit] = STATE(302),
    [sym_sym_val_lit] = STATE(302),
    [sym_evaling_lit] = STATE(302),
    [sym_tagged_or_ctor_lit] = STATE(302),
    [sym_derefing_lit] = STATE(302),
    [sym_quoting_lit] = STATE(302),
    [sym_syn_quoting_lit] = STATE(302),
    [sym_unquote_splicing_lit] = STATE(302),
    [sym_unquoting_lit] = STATE(302),
    [aux_sym_sym_lit_repeat1] = STATE(305),
    [aux_sym__bare_list_lit_repeat1] = STATE(5),
    [sym__ws] = ACTIONS(160),
    [sym_comment] = ACTIONS(160),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(132),
    [anon_sym_SLASH] = ACTIONS(9),
    [anon_sym_COLON] = ACTIONS(11),
    [anon_sym_COLON_COLON] = ACTIONS(13),
    [aux_sym_str_lit_token1] = ACTIONS(15),
    [sym_char_lit] = ACTIONS(132),
    [sym_nil_lit] = ACTIONS(134),
    [sym_bool_lit] = ACTIONS(134),
    [aux_sym__sym_qualified_token1] = ACTIONS(19),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_RBRACK] = ACTIONS(162),
    [anon_sym_POUND] = ACTIONS(31),
    [anon_sym_POUND_QMARK] = ACTIONS(33),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(35),
    [anon_sym_POUND_SQUOTE] = ACTIONS(37),
    [anon_sym_POUND_POUND] = ACTIONS(39),
    [anon_sym_POUND_EQ] = ACTIONS(41),
    [anon_sym_AT] = ACTIONS(43),
    [anon_sym_SQUOTE] = ACTIONS(45),
    [anon_sym_BQUOTE] = ACTIONS(47),
    [anon_sym_TILDE_AT] = ACTIONS(49),
    [anon_sym_TILDE] = ACTIONS(51),
  },
  [12] = {
    [sym__gap] = STATE(2),
    [sym_dis_expr] = STATE(2),
    [sym__form] = STATE(302),
    [sym_kwd_lit] = STATE(302),
    [sym_str_lit] = STATE(302),
    [sym_sym_lit] = STATE(302),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(302),
    [sym__bare_list_lit] = STATE(218),
    [sym_map_lit] = STATE(302),
    [sym__bare_map_lit] = STATE(219),
    [sym_vec_lit] = STATE(302),
    [sym__bare_vec_lit] = STATE(226),
    [sym_set_lit] = STATE(302),
    [sym__bare_set_lit] = STATE(227),
    [sym_anon_fn_lit] = STATE(302),
    [sym_regex_lit] = STATE(302),
    [sym_read_cond_lit] = STATE(302),
    [sym_splicing_read_cond_lit] = STATE(302),
    [sym_ns_map_lit] = STATE(302),
    [sym_var_quoting_lit] = STATE(302),
    [sym_sym_val_lit] = STATE(302),
    [sym_evaling_lit] = STATE(302),
    [sym_tagged_or_ctor_lit] = STATE(302),
    [sym_derefing_lit] = STATE(302),
    [sym_quoting_lit] = STATE(302),
    [sym_syn_quoting_lit] = STATE(302),
    [sym_unquote_splicing_lit] = STATE(302),
    [sym_unquoting_lit] = STATE(302),
    [aux_sym_sym_lit_repeat1] = STATE(305),
    [aux_sym__bare_list_lit_repeat1] = STATE(2),
    [sym__ws] = ACTIONS(130),
    [sym_comment] = ACTIONS(130),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(132),
    [anon_sym_SLASH] = ACTIONS(9),
    [anon_sym_COLON] = ACTIONS(11),
    [anon_sym_COLON_COLON] = ACTIONS(13),
    [aux_sym_str_lit_token1] = ACTIONS(15),
    [sym_char_lit] = ACTIONS(132),
    [sym_nil_lit] = ACTIONS(134),
    [sym_bool_lit] = ACTIONS(134),
    [aux_sym__sym_qualified_token1] = ACTIONS(19),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_RBRACE] = ACTIONS(164),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_POUND] = ACTIONS(31),
    [anon_sym_POUND_QMARK] = ACTIONS(33),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(35),
    [anon_sym_POUND_SQUOTE] = ACTIONS(37),
    [anon_sym_POUND_POUND] = ACTIONS(39),
    [anon_sym_POUND_EQ] = ACTIONS(41),
    [anon_sym_AT] = ACTIONS(43),
    [anon_sym_SQUOTE] = ACTIONS(45),
    [anon_sym_BQUOTE] = ACTIONS(47),
    [anon_sym_TILDE_AT] = ACTIONS(49),
    [anon_sym_TILDE] = ACTIONS(51),
  },
  [13] = {
    [sym__gap] = STATE(3),
    [sym_dis_expr] = STATE(3),
    [sym__form] = STATE(302),
    [sym_kwd_lit] = STATE(302),
    [sym_str_lit] = STATE(302),
    [sym_sym_lit] = STATE(302),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(302),
    [sym__bare_list_lit] = STATE(218),
    [sym_map_lit] = STATE(302),
    [sym__bare_map_lit] = STATE(219),
    [sym_vec_lit] = STATE(302),
    [sym__bare_vec_lit] = STATE(226),
    [sym_set_lit] = STATE(302),
    [sym__bare_set_lit] = STATE(227),
    [sym_anon_fn_lit] = STATE(302),
    [sym_regex_lit] = STATE(302),
    [sym_read_cond_lit] = STATE(302),
    [sym_splicing_read_cond_lit] = STATE(302),
    [sym_ns_map_lit] = STATE(302),
    [sym_var_quoting_lit] = STATE(302),
    [sym_sym_val_lit] = STATE(302),
    [sym_evaling_lit] = STATE(302),
    [sym_tagged_or_ctor_lit] = STATE(302),
    [sym_derefing_lit] = STATE(302),
    [sym_quoting_lit] = STATE(302),
    [sym_syn_quoting_lit] = STATE(302),
    [sym_unquote_splicing_lit] = STATE(302),
    [sym_unquoting_lit] = STATE(302),
    [aux_sym_sym_lit_repeat1] = STATE(305),
    [aux_sym__bare_list_lit_repeat1] = STATE(3),
    [sym__ws] = ACTIONS(166),
    [sym_comment] = ACTIONS(166),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(132),
    [anon_sym_SLASH] = ACTIONS(9),
    [anon_sym_COLON] = ACTIONS(11),
    [anon_sym_COLON_COLON] = ACTIONS(13),
    [aux_sym_str_lit_token1] = ACTIONS(15),
    [sym_char_lit] = ACTIONS(132),
    [sym_nil_lit] = ACTIONS(134),
    [sym_bool_lit] = ACTIONS(134),
    [aux_sym__sym_qualified_token1] = ACTIONS(19),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_RPAREN] = ACTIONS(168),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_POUND] = ACTIONS(31),
    [anon_sym_POUND_QMARK] = ACTIONS(33),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(35),
    [anon_sym_POUND_SQUOTE] = ACTIONS(37),
    [anon_sym_POUND_POUND] = ACTIONS(39),
    [anon_sym_POUND_EQ] = ACTIONS(41),
    [anon_sym_AT] = ACTIONS(43),
    [anon_sym_SQUOTE] = ACTIONS(45),
    [anon_sym_BQUOTE] = ACTIONS(47),
    [anon_sym_TILDE_AT] = ACTIONS(49),
    [anon_sym_TILDE] = ACTIONS(51),
  },
  [14] = {
    [sym__gap] = STATE(2),
    [sym_dis_expr] = STATE(2),
    [sym__form] = STATE(302),
    [sym_kwd_lit] = STATE(302),
    [sym_str_lit] = STATE(302),
    [sym_sym_lit] = STATE(302),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(302),
    [sym__bare_list_lit] = STATE(218),
    [sym_map_lit] = STATE(302),
    [sym__bare_map_lit] = STATE(219),
    [sym_vec_lit] = STATE(302),
    [sym__bare_vec_lit] = STATE(226),
    [sym_set_lit] = STATE(302),
    [sym__bare_set_lit] = STATE(227),
    [sym_anon_fn_lit] = STATE(302),
    [sym_regex_lit] = STATE(302),
    [sym_read_cond_lit] = STATE(302),
    [sym_splicing_read_cond_lit] = STATE(302),
    [sym_ns_map_lit] = STATE(302),
    [sym_var_quoting_lit] = STATE(302),
    [sym_sym_val_lit] = STATE(302),
    [sym_evaling_lit] = STATE(302),
    [sym_tagged_or_ctor_lit] = STATE(302),
    [sym_derefing_lit] = STATE(302),
    [sym_quoting_lit] = STATE(302),
    [sym_syn_quoting_lit] = STATE(302),
    [sym_unquote_splicing_lit] = STATE(302),
    [sym_unquoting_lit] = STATE(302),
    [aux_sym_sym_lit_repeat1] = STATE(305),
    [aux_sym__bare_list_lit_repeat1] = STATE(2),
    [sym__ws] = ACTIONS(130),
    [sym_comment] = ACTIONS(130),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(132),
    [anon_sym_SLASH] = ACTIONS(9),
    [anon_sym_COLON] = ACTIONS(11),
    [anon_sym_COLON_COLON] = ACTIONS(13),
    [aux_sym_str_lit_token1] = ACTIONS(15),
    [sym_char_lit] = ACTIONS(132),
    [sym_nil_lit] = ACTIONS(134),
    [sym_bool_lit] = ACTIONS(134),
    [aux_sym__sym_qualified_token1] = ACTIONS(19),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_RBRACE] = ACTIONS(170),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_POUND] = ACTIONS(31),
    [anon_sym_POUND_QMARK] = ACTIONS(33),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(35),
    [anon_sym_POUND_SQUOTE] = ACTIONS(37),
    [anon_sym_POUND_POUND] = ACTIONS(39),
    [anon_sym_POUND_EQ] = ACTIONS(41),
    [anon_sym_AT] = ACTIONS(43),
    [anon_sym_SQUOTE] = ACTIONS(45),
    [anon_sym_BQUOTE] = ACTIONS(47),
    [anon_sym_TILDE_AT] = ACTIONS(49),
    [anon_sym_TILDE] = ACTIONS(51),
  },
  [15] = {
    [sym__gap] = STATE(6),
    [sym_dis_expr] = STATE(6),
    [sym__form] = STATE(302),
    [sym_kwd_lit] = STATE(302),
    [sym_str_lit] = STATE(302),
    [sym_sym_lit] = STATE(302),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(302),
    [sym__bare_list_lit] = STATE(218),
    [sym_map_lit] = STATE(302),
    [sym__bare_map_lit] = STATE(219),
    [sym_vec_lit] = STATE(302),
    [sym__bare_vec_lit] = STATE(226),
    [sym_set_lit] = STATE(302),
    [sym__bare_set_lit] = STATE(227),
    [sym_anon_fn_lit] = STATE(302),
    [sym_regex_lit] = STATE(302),
    [sym_read_cond_lit] = STATE(302),
    [sym_splicing_read_cond_lit] = STATE(302),
    [sym_ns_map_lit] = STATE(302),
    [sym_var_quoting_lit] = STATE(302),
    [sym_sym_val_lit] = STATE(302),
    [sym_evaling_lit] = STATE(302),
    [sym_tagged_or_ctor_lit] = STATE(302),
    [sym_derefing_lit] = STATE(302),
    [sym_quoting_lit] = STATE(302),
    [sym_syn_quoting_lit] = STATE(302),
    [sym_unquote_splicing_lit] = STATE(302),
    [sym_unquoting_lit] = STATE(302),
    [aux_sym_sym_lit_repeat1] = STATE(305),
    [aux_sym__bare_list_lit_repeat1] = STATE(6),
    [sym__ws] = ACTIONS(172),
    [sym_comment] = ACTIONS(172),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(132),
    [anon_sym_SLASH] = ACTIONS(9),
    [anon_sym_COLON] = ACTIONS(11),
    [anon_sym_COLON_COLON] = ACTIONS(13),
    [aux_sym_str_lit_token1] = ACTIONS(15),
    [sym_char_lit] = ACTIONS(132),
    [sym_nil_lit] = ACTIONS(134),
    [sym_bool_lit] = ACTIONS(134),
    [aux_sym__sym_qualified_token1] = ACTIONS(19),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_RBRACE] = ACTIONS(174),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_POUND] = ACTIONS(31),
    [anon_sym_POUND_QMARK] = ACTIONS(33),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(35),
    [anon_sym_POUND_SQUOTE] = ACTIONS(37),
    [anon_sym_POUND_POUND] = ACTIONS(39),
    [anon_sym_POUND_EQ] = ACTIONS(41),
    [anon_sym_AT] = ACTIONS(43),
    [anon_sym_SQUOTE] = ACTIONS(45),
    [anon_sym_BQUOTE] = ACTIONS(47),
    [anon_sym_TILDE_AT] = ACTIONS(49),
    [anon_sym_TILDE] = ACTIONS(51),
  },
  [16] = {
    [sym__gap] = STATE(2),
    [sym_dis_expr] = STATE(2),
    [sym__form] = STATE(302),
    [sym_kwd_lit] = STATE(302),
    [sym_str_lit] = STATE(302),
    [sym_sym_lit] = STATE(302),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(302),
    [sym__bare_list_lit] = STATE(218),
    [sym_map_lit] = STATE(302),
    [sym__bare_map_lit] = STATE(219),
    [sym_vec_lit] = STATE(302),
    [sym__bare_vec_lit] = STATE(226),
    [sym_set_lit] = STATE(302),
    [sym__bare_set_lit] = STATE(227),
    [sym_anon_fn_lit] = STATE(302),
    [sym_regex_lit] = STATE(302),
    [sym_read_cond_lit] = STATE(302),
    [sym_splicing_read_cond_lit] = STATE(302),
    [sym_ns_map_lit] = STATE(302),
    [sym_var_quoting_lit] = STATE(302),
    [sym_sym_val_lit] = STATE(302),
    [sym_evaling_lit] = STATE(302),
    [sym_tagged_or_ctor_lit] = STATE(302),
    [sym_derefing_lit] = STATE(302),
    [sym_quoting_lit] = STATE(302),
    [sym_syn_quoting_lit] = STATE(302),
    [sym_unquote_splicing_lit] = STATE(302),
    [sym_unquoting_lit] = STATE(302),
    [aux_sym_sym_lit_repeat1] = STATE(305),
    [aux_sym__bare_list_lit_repeat1] = STATE(2),
    [sym__ws] = ACTIONS(130),
    [sym_comment] = ACTIONS(130),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(132),
    [anon_sym_SLASH] = ACTIONS(9),
    [anon_sym_COLON] = ACTIONS(11),
    [anon_sym_COLON_COLON] = ACTIONS(13),
    [aux_sym_str_lit_token1] = ACTIONS(15),
    [sym_char_lit] = ACTIONS(132),
    [sym_nil_lit] = ACTIONS(134),
    [sym_bool_lit] = ACTIONS(134),
    [aux_sym__sym_qualified_token1] = ACTIONS(19),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_RPAREN] = ACTIONS(176),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_POUND] = ACTIONS(31),
    [anon_sym_POUND_QMARK] = ACTIONS(33),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(35),
    [anon_sym_POUND_SQUOTE] = ACTIONS(37),
    [anon_sym_POUND_POUND] = ACTIONS(39),
    [anon_sym_POUND_EQ] = ACTIONS(41),
    [anon_sym_AT] = ACTIONS(43),
    [anon_sym_SQUOTE] = ACTIONS(45),
    [anon_sym_BQUOTE] = ACTIONS(47),
    [anon_sym_TILDE_AT] = ACTIONS(49),
    [anon_sym_TILDE] = ACTIONS(51),
  },
  [17] = {
    [sym__gap] = STATE(14),
    [sym_dis_expr] = STATE(14),
    [sym__form] = STATE(302),
    [sym_kwd_lit] = STATE(302),
    [sym_str_lit] = STATE(302),
    [sym_sym_lit] = STATE(302),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(302),
    [sym__bare_list_lit] = STATE(218),
    [sym_map_lit] = STATE(302),
    [sym__bare_map_lit] = STATE(219),
    [sym_vec_lit] = STATE(302),
    [sym__bare_vec_lit] = STATE(226),
    [sym_set_lit] = STATE(302),
    [sym__bare_set_lit] = STATE(227),
    [sym_anon_fn_lit] = STATE(302),
    [sym_regex_lit] = STATE(302),
    [sym_read_cond_lit] = STATE(302),
    [sym_splicing_read_cond_lit] = STATE(302),
    [sym_ns_map_lit] = STATE(302),
    [sym_var_quoting_lit] = STATE(302),
    [sym_sym_val_lit] = STATE(302),
    [sym_evaling_lit] = STATE(302),
    [sym_tagged_or_ctor_lit] = STATE(302),
    [sym_derefing_lit] = STATE(302),
    [sym_quoting_lit] = STATE(302),
    [sym_syn_quoting_lit] = STATE(302),
    [sym_unquote_splicing_lit] = STATE(302),
    [sym_unquoting_lit] = STATE(302),
    [aux_sym_sym_lit_repeat1] = STATE(305),
    [aux_sym__bare_list_lit_repeat1] = STATE(14),
    [sym__ws] = ACTIONS(178),
    [sym_comment] = ACTIONS(178),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(132),
    [anon_sym_SLASH] = ACTIONS(9),
    [anon_sym_COLON] = ACTIONS(11),
    [anon_sym_COLON_COLON] = ACTIONS(13),
    [aux_sym_str_lit_token1] = ACTIONS(15),
    [sym_char_lit] = ACTIONS(132),
    [sym_nil_lit] = ACTIONS(134),
    [sym_bool_lit] = ACTIONS(134),
    [aux_sym__sym_qualified_token1] = ACTIONS(19),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_RBRACE] = ACTIONS(180),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_POUND] = ACTIONS(31),
    [anon_sym_POUND_QMARK] = ACTIONS(33),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(35),
    [anon_sym_POUND_SQUOTE] = ACTIONS(37),
    [anon_sym_POUND_POUND] = ACTIONS(39),
    [anon_sym_POUND_EQ] = ACTIONS(41),
    [anon_sym_AT] = ACTIONS(43),
    [anon_sym_SQUOTE] = ACTIONS(45),
    [anon_sym_BQUOTE] = ACTIONS(47),
    [anon_sym_TILDE_AT] = ACTIONS(49),
    [anon_sym_TILDE] = ACTIONS(51),
  },
  [18] = {
    [sym__gap] = STATE(2),
    [sym_dis_expr] = STATE(2),
    [sym__form] = STATE(302),
    [sym_kwd_lit] = STATE(302),
    [sym_str_lit] = STATE(302),
    [sym_sym_lit] = STATE(302),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(302),
    [sym__bare_list_lit] = STATE(218),
    [sym_map_lit] = STATE(302),
    [sym__bare_map_lit] = STATE(219),
    [sym_vec_lit] = STATE(302),
    [sym__bare_vec_lit] = STATE(226),
    [sym_set_lit] = STATE(302),
    [sym__bare_set_lit] = STATE(227),
    [sym_anon_fn_lit] = STATE(302),
    [sym_regex_lit] = STATE(302),
    [sym_read_cond_lit] = STATE(302),
    [sym_splicing_read_cond_lit] = STATE(302),
    [sym_ns_map_lit] = STATE(302),
    [sym_var_quoting_lit] = STATE(302),
    [sym_sym_val_lit] = STATE(302),
    [sym_evaling_lit] = STATE(302),
    [sym_tagged_or_ctor_lit] = STATE(302),
    [sym_derefing_lit] = STATE(302),
    [sym_quoting_lit] = STATE(302),
    [sym_syn_quoting_lit] = STATE(302),
    [sym_unquote_splicing_lit] = STATE(302),
    [sym_unquoting_lit] = STATE(302),
    [aux_sym_sym_lit_repeat1] = STATE(305),
    [aux_sym__bare_list_lit_repeat1] = STATE(2),
    [sym__ws] = ACTIONS(130),
    [sym_comment] = ACTIONS(130),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(132),
    [anon_sym_SLASH] = ACTIONS(9),
    [anon_sym_COLON] = ACTIONS(11),
    [anon_sym_COLON_COLON] = ACTIONS(13),
    [aux_sym_str_lit_token1] = ACTIONS(15),
    [sym_char_lit] = ACTIONS(132),
    [sym_nil_lit] = ACTIONS(134),
    [sym_bool_lit] = ACTIONS(134),
    [aux_sym__sym_qualified_token1] = ACTIONS(19),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_RBRACE] = ACTIONS(182),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_POUND] = ACTIONS(31),
    [anon_sym_POUND_QMARK] = ACTIONS(33),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(35),
    [anon_sym_POUND_SQUOTE] = ACTIONS(37),
    [anon_sym_POUND_POUND] = ACTIONS(39),
    [anon_sym_POUND_EQ] = ACTIONS(41),
    [anon_sym_AT] = ACTIONS(43),
    [anon_sym_SQUOTE] = ACTIONS(45),
    [anon_sym_BQUOTE] = ACTIONS(47),
    [anon_sym_TILDE_AT] = ACTIONS(49),
    [anon_sym_TILDE] = ACTIONS(51),
  },
  [19] = {
    [sym__gap] = STATE(20),
    [sym_dis_expr] = STATE(20),
    [sym__form] = STATE(20),
    [sym_kwd_lit] = STATE(20),
    [sym_str_lit] = STATE(20),
    [sym_sym_lit] = STATE(20),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(20),
    [sym__bare_list_lit] = STATE(218),
    [sym_map_lit] = STATE(20),
    [sym__bare_map_lit] = STATE(219),
    [sym_vec_lit] = STATE(20),
    [sym__bare_vec_lit] = STATE(226),
    [sym_set_lit] = STATE(20),
    [sym__bare_set_lit] = STATE(227),
    [sym_anon_fn_lit] = STATE(20),
    [sym_regex_lit] = STATE(20),
    [sym_read_cond_lit] = STATE(20),
    [sym_splicing_read_cond_lit] = STATE(20),
    [sym_ns_map_lit] = STATE(20),
    [sym_var_quoting_lit] = STATE(20),
    [sym_sym_val_lit] = STATE(20),
    [sym_evaling_lit] = STATE(20),
    [sym_tagged_or_ctor_lit] = STATE(20),
    [sym_derefing_lit] = STATE(20),
    [sym_quoting_lit] = STATE(20),
    [sym_syn_quoting_lit] = STATE(20),
    [sym_unquote_splicing_lit] = STATE(20),
    [sym_unquoting_lit] = STATE(20),
    [aux_sym_source_repeat1] = STATE(20),
    [aux_sym_sym_lit_repeat1] = STATE(305),
    [ts_builtin_sym_end] = ACTIONS(184),
    [sym__ws] = ACTIONS(186),
    [sym_comment] = ACTIONS(186),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(186),
    [anon_sym_SLASH] = ACTIONS(9),
    [anon_sym_COLON] = ACTIONS(11),
    [anon_sym_COLON_COLON] = ACTIONS(13),
    [aux_sym_str_lit_token1] = ACTIONS(15),
    [sym_char_lit] = ACTIONS(186),
    [sym_nil_lit] = ACTIONS(188),
    [sym_bool_lit] = ACTIONS(188),
    [aux_sym__sym_qualified_token1] = ACTIONS(19),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_POUND] = ACTIONS(31),
    [anon_sym_POUND_QMARK] = ACTIONS(33),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(35),
    [anon_sym_POUND_SQUOTE] = ACTIONS(37),
    [anon_sym_POUND_POUND] = ACTIONS(39),
    [anon_sym_POUND_EQ] = ACTIONS(41),
    [anon_sym_AT] = ACTIONS(43),
    [anon_sym_SQUOTE] = ACTIONS(45),
    [anon_sym_BQUOTE] = ACTIONS(47),
    [anon_sym_TILDE_AT] = ACTIONS(49),
    [anon_sym_TILDE] = ACTIONS(51),
  },
  [20] = {
    [sym__gap] = STATE(20),
    [sym_dis_expr] = STATE(20),
    [sym__form] = STATE(20),
    [sym_kwd_lit] = STATE(20),
    [sym_str_lit] = STATE(20),
    [sym_sym_lit] = STATE(20),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(20),
    [sym__bare_list_lit] = STATE(218),
    [sym_map_lit] = STATE(20),
    [sym__bare_map_lit] = STATE(219),
    [sym_vec_lit] = STATE(20),
    [sym__bare_vec_lit] = STATE(226),
    [sym_set_lit] = STATE(20),
    [sym__bare_set_lit] = STATE(227),
    [sym_anon_fn_lit] = STATE(20),
    [sym_regex_lit] = STATE(20),
    [sym_read_cond_lit] = STATE(20),
    [sym_splicing_read_cond_lit] = STATE(20),
    [sym_ns_map_lit] = STATE(20),
    [sym_var_quoting_lit] = STATE(20),
    [sym_sym_val_lit] = STATE(20),
    [sym_evaling_lit] = STATE(20),
    [sym_tagged_or_ctor_lit] = STATE(20),
    [sym_derefing_lit] = STATE(20),
    [sym_quoting_lit] = STATE(20),
    [sym_syn_quoting_lit] = STATE(20),
    [sym_unquote_splicing_lit] = STATE(20),
    [sym_unquoting_lit] = STATE(20),
    [aux_sym_source_repeat1] = STATE(20),
    [aux_sym_sym_lit_repeat1] = STATE(305),
    [ts_builtin_sym_end] = ACTIONS(190),
    [sym__ws] = ACTIONS(192),
    [sym_comment] = ACTIONS(192),
    [anon_sym_POUND_] = ACTIONS(195),
    [sym_num_lit] = ACTIONS(192),
    [anon_sym_SLASH] = ACTIONS(198),
    [anon_sym_COLON] = ACTIONS(201),
    [anon_sym_COLON_COLON] = ACTIONS(204),
    [aux_sym_str_lit_token1] = ACTIONS(207),
    [sym_char_lit] = ACTIONS(192),
    [sym_nil_lit] = ACTIONS(210),
    [sym_bool_lit] = ACTIONS(210),
    [aux_sym__sym_qualified_token1] = ACTIONS(213),
    [anon_sym_CARET] = ACTIONS(216),
    [anon_sym_POUND_CARET] = ACTIONS(219),
    [anon_sym_LPAREN] = ACTIONS(222),
    [anon_sym_LBRACE] = ACTIONS(225),
    [anon_sym_LBRACK] = ACTIONS(228),
    [anon_sym_POUND] = ACTIONS(231),
    [anon_sym_POUND_QMARK] = ACTIONS(234),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(237),
    [anon_sym_POUND_SQUOTE] = ACTIONS(240),
    [anon_sym_POUND_POUND] = ACTIONS(243),
    [anon_sym_POUND_EQ] = ACTIONS(246),
    [anon_sym_AT] = ACTIONS(249),
    [anon_sym_SQUOTE] = ACTIONS(252),
    [anon_sym_BQUOTE] = ACTIONS(255),
    [anon_sym_TILDE_AT] = ACTIONS(258),
    [anon_sym_TILDE] = ACTIONS(261),
  },
  [21] = {
    [sym__gap] = STATE(301),
    [sym_dis_expr] = STATE(301),
    [sym__form] = STATE(420),
    [sym_kwd_lit] = STATE(420),
    [sym_str_lit] = STATE(420),
    [sym_sym_lit] = STATE(420),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(420),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(420),
    [sym__bare_map_lit] = STATE(403),
    [sym_vec_lit] = STATE(420),
    [sym__bare_vec_lit] = STATE(423),
    [sym_set_lit] = STATE(420),
    [sym__bare_set_lit] = STATE(374),
    [sym_anon_fn_lit] = STATE(420),
    [sym_regex_lit] = STATE(420),
    [sym_read_cond_lit] = STATE(420),
    [sym_splicing_read_cond_lit] = STATE(420),
    [sym_ns_map_lit] = STATE(420),
    [sym_var_quoting_lit] = STATE(420),
    [sym_sym_val_lit] = STATE(420),
    [sym_evaling_lit] = STATE(420),
    [sym_tagged_or_ctor_lit] = STATE(420),
    [sym_derefing_lit] = STATE(420),
    [sym_quoting_lit] = STATE(420),
    [sym_syn_quoting_lit] = STATE(420),
    [sym_unquote_splicing_lit] = STATE(420),
    [sym_unquoting_lit] = STATE(420),
    [aux_sym_dis_expr_repeat1] = STATE(301),
    [aux_sym_sym_lit_repeat1] = STATE(304),
    [sym__ws] = ACTIONS(264),
    [sym_comment] = ACTIONS(264),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(266),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(270),
    [anon_sym_COLON_COLON] = ACTIONS(272),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(266),
    [sym_nil_lit] = ACTIONS(276),
    [sym_bool_lit] = ACTIONS(276),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(286),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(292),
    [anon_sym_POUND_POUND] = ACTIONS(294),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(298),
    [anon_sym_SQUOTE] = ACTIONS(300),
    [anon_sym_BQUOTE] = ACTIONS(302),
    [anon_sym_TILDE_AT] = ACTIONS(304),
    [anon_sym_TILDE] = ACTIONS(306),
  },
  [22] = {
    [sym__gap] = STATE(114),
    [sym_dis_expr] = STATE(114),
    [sym__form] = STATE(267),
    [sym_kwd_lit] = STATE(267),
    [sym_str_lit] = STATE(267),
    [sym_sym_lit] = STATE(267),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(267),
    [sym__bare_list_lit] = STATE(218),
    [sym_map_lit] = STATE(267),
    [sym__bare_map_lit] = STATE(219),
    [sym_vec_lit] = STATE(267),
    [sym__bare_vec_lit] = STATE(226),
    [sym_set_lit] = STATE(267),
    [sym__bare_set_lit] = STATE(227),
    [sym_anon_fn_lit] = STATE(267),
    [sym_regex_lit] = STATE(267),
    [sym_read_cond_lit] = STATE(267),
    [sym_splicing_read_cond_lit] = STATE(267),
    [sym_ns_map_lit] = STATE(267),
    [sym_var_quoting_lit] = STATE(267),
    [sym_sym_val_lit] = STATE(267),
    [sym_evaling_lit] = STATE(267),
    [sym_tagged_or_ctor_lit] = STATE(267),
    [sym_derefing_lit] = STATE(267),
    [sym_quoting_lit] = STATE(267),
    [sym_syn_quoting_lit] = STATE(267),
    [sym_unquote_splicing_lit] = STATE(267),
    [sym_unquoting_lit] = STATE(267),
    [aux_sym_dis_expr_repeat1] = STATE(114),
    [aux_sym_sym_lit_repeat1] = STATE(305),
    [sym__ws] = ACTIONS(308),
    [sym_comment] = ACTIONS(308),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(310),
    [anon_sym_SLASH] = ACTIONS(9),
    [anon_sym_COLON] = ACTIONS(11),
    [anon_sym_COLON_COLON] = ACTIONS(13),
    [aux_sym_str_lit_token1] = ACTIONS(15),
    [sym_char_lit] = ACTIONS(310),
    [sym_nil_lit] = ACTIONS(312),
    [sym_bool_lit] = ACTIONS(312),
    [aux_sym__sym_qualified_token1] = ACTIONS(19),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_POUND] = ACTIONS(31),
    [anon_sym_POUND_QMARK] = ACTIONS(33),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(35),
    [anon_sym_POUND_SQUOTE] = ACTIONS(37),
    [anon_sym_POUND_POUND] = ACTIONS(39),
    [anon_sym_POUND_EQ] = ACTIONS(41),
    [anon_sym_AT] = ACTIONS(43),
    [anon_sym_SQUOTE] = ACTIONS(45),
    [anon_sym_BQUOTE] = ACTIONS(47),
    [anon_sym_TILDE_AT] = ACTIONS(49),
    [anon_sym_TILDE] = ACTIONS(51),
  },
  [23] = {
    [sym__gap] = STATE(104),
    [sym_dis_expr] = STATE(104),
    [sym__form] = STATE(347),
    [sym_kwd_lit] = STATE(347),
    [sym_str_lit] = STATE(347),
    [sym_sym_lit] = STATE(347),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(347),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(347),
    [sym__bare_map_lit] = STATE(403),
    [sym_vec_lit] = STATE(347),
    [sym__bare_vec_lit] = STATE(423),
    [sym_set_lit] = STATE(347),
    [sym__bare_set_lit] = STATE(374),
    [sym_anon_fn_lit] = STATE(347),
    [sym_regex_lit] = STATE(347),
    [sym_read_cond_lit] = STATE(347),
    [sym_splicing_read_cond_lit] = STATE(347),
    [sym_ns_map_lit] = STATE(347),
    [sym_var_quoting_lit] = STATE(347),
    [sym_sym_val_lit] = STATE(347),
    [sym_evaling_lit] = STATE(347),
    [sym_tagged_or_ctor_lit] = STATE(347),
    [sym_derefing_lit] = STATE(347),
    [sym_quoting_lit] = STATE(347),
    [sym_syn_quoting_lit] = STATE(347),
    [sym_unquote_splicing_lit] = STATE(347),
    [sym_unquoting_lit] = STATE(347),
    [aux_sym_dis_expr_repeat1] = STATE(104),
    [aux_sym_sym_lit_repeat1] = STATE(304),
    [sym__ws] = ACTIONS(314),
    [sym_comment] = ACTIONS(314),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(316),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(270),
    [anon_sym_COLON_COLON] = ACTIONS(272),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(316),
    [sym_nil_lit] = ACTIONS(318),
    [sym_bool_lit] = ACTIONS(318),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(286),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(292),
    [anon_sym_POUND_POUND] = ACTIONS(294),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(298),
    [anon_sym_SQUOTE] = ACTIONS(300),
    [anon_sym_BQUOTE] = ACTIONS(302),
    [anon_sym_TILDE_AT] = ACTIONS(304),
    [anon_sym_TILDE] = ACTIONS(306),
  },
  [24] = {
    [sym__gap] = STATE(70),
    [sym_dis_expr] = STATE(70),
    [sym__form] = STATE(244),
    [sym_kwd_lit] = STATE(244),
    [sym_str_lit] = STATE(244),
    [sym_sym_lit] = STATE(244),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(244),
    [sym__bare_list_lit] = STATE(218),
    [sym_map_lit] = STATE(244),
    [sym__bare_map_lit] = STATE(219),
    [sym_vec_lit] = STATE(244),
    [sym__bare_vec_lit] = STATE(226),
    [sym_set_lit] = STATE(244),
    [sym__bare_set_lit] = STATE(227),
    [sym_anon_fn_lit] = STATE(244),
    [sym_regex_lit] = STATE(244),
    [sym_read_cond_lit] = STATE(244),
    [sym_splicing_read_cond_lit] = STATE(244),
    [sym_ns_map_lit] = STATE(244),
    [sym_var_quoting_lit] = STATE(244),
    [sym_sym_val_lit] = STATE(244),
    [sym_evaling_lit] = STATE(244),
    [sym_tagged_or_ctor_lit] = STATE(244),
    [sym_derefing_lit] = STATE(244),
    [sym_quoting_lit] = STATE(244),
    [sym_syn_quoting_lit] = STATE(244),
    [sym_unquote_splicing_lit] = STATE(244),
    [sym_unquoting_lit] = STATE(244),
    [aux_sym_dis_expr_repeat1] = STATE(70),
    [aux_sym_sym_lit_repeat1] = STATE(305),
    [sym__ws] = ACTIONS(320),
    [sym_comment] = ACTIONS(320),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(322),
    [anon_sym_SLASH] = ACTIONS(9),
    [anon_sym_COLON] = ACTIONS(11),
    [anon_sym_COLON_COLON] = ACTIONS(13),
    [aux_sym_str_lit_token1] = ACTIONS(15),
    [sym_char_lit] = ACTIONS(322),
    [sym_nil_lit] = ACTIONS(324),
    [sym_bool_lit] = ACTIONS(324),
    [aux_sym__sym_qualified_token1] = ACTIONS(19),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_POUND] = ACTIONS(31),
    [anon_sym_POUND_QMARK] = ACTIONS(33),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(35),
    [anon_sym_POUND_SQUOTE] = ACTIONS(37),
    [anon_sym_POUND_POUND] = ACTIONS(39),
    [anon_sym_POUND_EQ] = ACTIONS(41),
    [anon_sym_AT] = ACTIONS(43),
    [anon_sym_SQUOTE] = ACTIONS(45),
    [anon_sym_BQUOTE] = ACTIONS(47),
    [anon_sym_TILDE_AT] = ACTIONS(49),
    [anon_sym_TILDE] = ACTIONS(51),
  },
  [25] = {
    [sym__gap] = STATE(72),
    [sym_dis_expr] = STATE(72),
    [sym__form] = STATE(245),
    [sym_kwd_lit] = STATE(245),
    [sym_str_lit] = STATE(245),
    [sym_sym_lit] = STATE(245),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(245),
    [sym__bare_list_lit] = STATE(218),
    [sym_map_lit] = STATE(245),
    [sym__bare_map_lit] = STATE(219),
    [sym_vec_lit] = STATE(245),
    [sym__bare_vec_lit] = STATE(226),
    [sym_set_lit] = STATE(245),
    [sym__bare_set_lit] = STATE(227),
    [sym_anon_fn_lit] = STATE(245),
    [sym_regex_lit] = STATE(245),
    [sym_read_cond_lit] = STATE(245),
    [sym_splicing_read_cond_lit] = STATE(245),
    [sym_ns_map_lit] = STATE(245),
    [sym_var_quoting_lit] = STATE(245),
    [sym_sym_val_lit] = STATE(245),
    [sym_evaling_lit] = STATE(245),
    [sym_tagged_or_ctor_lit] = STATE(245),
    [sym_derefing_lit] = STATE(245),
    [sym_quoting_lit] = STATE(245),
    [sym_syn_quoting_lit] = STATE(245),
    [sym_unquote_splicing_lit] = STATE(245),
    [sym_unquoting_lit] = STATE(245),
    [aux_sym_dis_expr_repeat1] = STATE(72),
    [aux_sym_sym_lit_repeat1] = STATE(305),
    [sym__ws] = ACTIONS(326),
    [sym_comment] = ACTIONS(326),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(328),
    [anon_sym_SLASH] = ACTIONS(9),
    [anon_sym_COLON] = ACTIONS(11),
    [anon_sym_COLON_COLON] = ACTIONS(13),
    [aux_sym_str_lit_token1] = ACTIONS(15),
    [sym_char_lit] = ACTIONS(328),
    [sym_nil_lit] = ACTIONS(330),
    [sym_bool_lit] = ACTIONS(330),
    [aux_sym__sym_qualified_token1] = ACTIONS(19),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_POUND] = ACTIONS(31),
    [anon_sym_POUND_QMARK] = ACTIONS(33),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(35),
    [anon_sym_POUND_SQUOTE] = ACTIONS(37),
    [anon_sym_POUND_POUND] = ACTIONS(39),
    [anon_sym_POUND_EQ] = ACTIONS(41),
    [anon_sym_AT] = ACTIONS(43),
    [anon_sym_SQUOTE] = ACTIONS(45),
    [anon_sym_BQUOTE] = ACTIONS(47),
    [anon_sym_TILDE_AT] = ACTIONS(49),
    [anon_sym_TILDE] = ACTIONS(51),
  },
  [26] = {
    [sym__gap] = STATE(74),
    [sym_dis_expr] = STATE(74),
    [sym__form] = STATE(246),
    [sym_kwd_lit] = STATE(246),
    [sym_str_lit] = STATE(246),
    [sym_sym_lit] = STATE(246),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(246),
    [sym__bare_list_lit] = STATE(218),
    [sym_map_lit] = STATE(246),
    [sym__bare_map_lit] = STATE(219),
    [sym_vec_lit] = STATE(246),
    [sym__bare_vec_lit] = STATE(226),
    [sym_set_lit] = STATE(246),
    [sym__bare_set_lit] = STATE(227),
    [sym_anon_fn_lit] = STATE(246),
    [sym_regex_lit] = STATE(246),
    [sym_read_cond_lit] = STATE(246),
    [sym_splicing_read_cond_lit] = STATE(246),
    [sym_ns_map_lit] = STATE(246),
    [sym_var_quoting_lit] = STATE(246),
    [sym_sym_val_lit] = STATE(246),
    [sym_evaling_lit] = STATE(246),
    [sym_tagged_or_ctor_lit] = STATE(246),
    [sym_derefing_lit] = STATE(246),
    [sym_quoting_lit] = STATE(246),
    [sym_syn_quoting_lit] = STATE(246),
    [sym_unquote_splicing_lit] = STATE(246),
    [sym_unquoting_lit] = STATE(246),
    [aux_sym_dis_expr_repeat1] = STATE(74),
    [aux_sym_sym_lit_repeat1] = STATE(305),
    [sym__ws] = ACTIONS(332),
    [sym_comment] = ACTIONS(332),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(334),
    [anon_sym_SLASH] = ACTIONS(9),
    [anon_sym_COLON] = ACTIONS(11),
    [anon_sym_COLON_COLON] = ACTIONS(13),
    [aux_sym_str_lit_token1] = ACTIONS(15),
    [sym_char_lit] = ACTIONS(334),
    [sym_nil_lit] = ACTIONS(336),
    [sym_bool_lit] = ACTIONS(336),
    [aux_sym__sym_qualified_token1] = ACTIONS(19),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_POUND] = ACTIONS(31),
    [anon_sym_POUND_QMARK] = ACTIONS(33),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(35),
    [anon_sym_POUND_SQUOTE] = ACTIONS(37),
    [anon_sym_POUND_POUND] = ACTIONS(39),
    [anon_sym_POUND_EQ] = ACTIONS(41),
    [anon_sym_AT] = ACTIONS(43),
    [anon_sym_SQUOTE] = ACTIONS(45),
    [anon_sym_BQUOTE] = ACTIONS(47),
    [anon_sym_TILDE_AT] = ACTIONS(49),
    [anon_sym_TILDE] = ACTIONS(51),
  },
  [27] = {
    [sym__gap] = STATE(76),
    [sym_dis_expr] = STATE(76),
    [sym__form] = STATE(247),
    [sym_kwd_lit] = STATE(247),
    [sym_str_lit] = STATE(247),
    [sym_sym_lit] = STATE(247),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(247),
    [sym__bare_list_lit] = STATE(218),
    [sym_map_lit] = STATE(247),
    [sym__bare_map_lit] = STATE(219),
    [sym_vec_lit] = STATE(247),
    [sym__bare_vec_lit] = STATE(226),
    [sym_set_lit] = STATE(247),
    [sym__bare_set_lit] = STATE(227),
    [sym_anon_fn_lit] = STATE(247),
    [sym_regex_lit] = STATE(247),
    [sym_read_cond_lit] = STATE(247),
    [sym_splicing_read_cond_lit] = STATE(247),
    [sym_ns_map_lit] = STATE(247),
    [sym_var_quoting_lit] = STATE(247),
    [sym_sym_val_lit] = STATE(247),
    [sym_evaling_lit] = STATE(247),
    [sym_tagged_or_ctor_lit] = STATE(247),
    [sym_derefing_lit] = STATE(247),
    [sym_quoting_lit] = STATE(247),
    [sym_syn_quoting_lit] = STATE(247),
    [sym_unquote_splicing_lit] = STATE(247),
    [sym_unquoting_lit] = STATE(247),
    [aux_sym_dis_expr_repeat1] = STATE(76),
    [aux_sym_sym_lit_repeat1] = STATE(305),
    [sym__ws] = ACTIONS(338),
    [sym_comment] = ACTIONS(338),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(340),
    [anon_sym_SLASH] = ACTIONS(9),
    [anon_sym_COLON] = ACTIONS(11),
    [anon_sym_COLON_COLON] = ACTIONS(13),
    [aux_sym_str_lit_token1] = ACTIONS(15),
    [sym_char_lit] = ACTIONS(340),
    [sym_nil_lit] = ACTIONS(342),
    [sym_bool_lit] = ACTIONS(342),
    [aux_sym__sym_qualified_token1] = ACTIONS(19),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_POUND] = ACTIONS(31),
    [anon_sym_POUND_QMARK] = ACTIONS(33),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(35),
    [anon_sym_POUND_SQUOTE] = ACTIONS(37),
    [anon_sym_POUND_POUND] = ACTIONS(39),
    [anon_sym_POUND_EQ] = ACTIONS(41),
    [anon_sym_AT] = ACTIONS(43),
    [anon_sym_SQUOTE] = ACTIONS(45),
    [anon_sym_BQUOTE] = ACTIONS(47),
    [anon_sym_TILDE_AT] = ACTIONS(49),
    [anon_sym_TILDE] = ACTIONS(51),
  },
  [28] = {
    [sym__gap] = STATE(78),
    [sym_dis_expr] = STATE(78),
    [sym__form] = STATE(248),
    [sym_kwd_lit] = STATE(248),
    [sym_str_lit] = STATE(248),
    [sym_sym_lit] = STATE(248),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(248),
    [sym__bare_list_lit] = STATE(218),
    [sym_map_lit] = STATE(248),
    [sym__bare_map_lit] = STATE(219),
    [sym_vec_lit] = STATE(248),
    [sym__bare_vec_lit] = STATE(226),
    [sym_set_lit] = STATE(248),
    [sym__bare_set_lit] = STATE(227),
    [sym_anon_fn_lit] = STATE(248),
    [sym_regex_lit] = STATE(248),
    [sym_read_cond_lit] = STATE(248),
    [sym_splicing_read_cond_lit] = STATE(248),
    [sym_ns_map_lit] = STATE(248),
    [sym_var_quoting_lit] = STATE(248),
    [sym_sym_val_lit] = STATE(248),
    [sym_evaling_lit] = STATE(248),
    [sym_tagged_or_ctor_lit] = STATE(248),
    [sym_derefing_lit] = STATE(248),
    [sym_quoting_lit] = STATE(248),
    [sym_syn_quoting_lit] = STATE(248),
    [sym_unquote_splicing_lit] = STATE(248),
    [sym_unquoting_lit] = STATE(248),
    [aux_sym_dis_expr_repeat1] = STATE(78),
    [aux_sym_sym_lit_repeat1] = STATE(305),
    [sym__ws] = ACTIONS(344),
    [sym_comment] = ACTIONS(344),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(346),
    [anon_sym_SLASH] = ACTIONS(9),
    [anon_sym_COLON] = ACTIONS(11),
    [anon_sym_COLON_COLON] = ACTIONS(13),
    [aux_sym_str_lit_token1] = ACTIONS(15),
    [sym_char_lit] = ACTIONS(346),
    [sym_nil_lit] = ACTIONS(348),
    [sym_bool_lit] = ACTIONS(348),
    [aux_sym__sym_qualified_token1] = ACTIONS(19),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_POUND] = ACTIONS(31),
    [anon_sym_POUND_QMARK] = ACTIONS(33),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(35),
    [anon_sym_POUND_SQUOTE] = ACTIONS(37),
    [anon_sym_POUND_POUND] = ACTIONS(39),
    [anon_sym_POUND_EQ] = ACTIONS(41),
    [anon_sym_AT] = ACTIONS(43),
    [anon_sym_SQUOTE] = ACTIONS(45),
    [anon_sym_BQUOTE] = ACTIONS(47),
    [anon_sym_TILDE_AT] = ACTIONS(49),
    [anon_sym_TILDE] = ACTIONS(51),
  },
  [29] = {
    [sym__gap] = STATE(301),
    [sym_dis_expr] = STATE(301),
    [sym__form] = STATE(334),
    [sym_kwd_lit] = STATE(334),
    [sym_str_lit] = STATE(334),
    [sym_sym_lit] = STATE(334),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(334),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(334),
    [sym__bare_map_lit] = STATE(403),
    [sym_vec_lit] = STATE(334),
    [sym__bare_vec_lit] = STATE(423),
    [sym_set_lit] = STATE(334),
    [sym__bare_set_lit] = STATE(374),
    [sym_anon_fn_lit] = STATE(334),
    [sym_regex_lit] = STATE(334),
    [sym_read_cond_lit] = STATE(334),
    [sym_splicing_read_cond_lit] = STATE(334),
    [sym_ns_map_lit] = STATE(334),
    [sym_var_quoting_lit] = STATE(334),
    [sym_sym_val_lit] = STATE(334),
    [sym_evaling_lit] = STATE(334),
    [sym_tagged_or_ctor_lit] = STATE(334),
    [sym_derefing_lit] = STATE(334),
    [sym_quoting_lit] = STATE(334),
    [sym_syn_quoting_lit] = STATE(334),
    [sym_unquote_splicing_lit] = STATE(334),
    [sym_unquoting_lit] = STATE(334),
    [aux_sym_dis_expr_repeat1] = STATE(301),
    [aux_sym_sym_lit_repeat1] = STATE(307),
    [sym__ws] = ACTIONS(264),
    [sym_comment] = ACTIONS(264),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(350),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(352),
    [anon_sym_COLON_COLON] = ACTIONS(354),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(350),
    [sym_nil_lit] = ACTIONS(356),
    [sym_bool_lit] = ACTIONS(356),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(358),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(360),
    [anon_sym_POUND_POUND] = ACTIONS(362),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(364),
    [anon_sym_SQUOTE] = ACTIONS(366),
    [anon_sym_BQUOTE] = ACTIONS(368),
    [anon_sym_TILDE_AT] = ACTIONS(370),
    [anon_sym_TILDE] = ACTIONS(372),
  },
  [30] = {
    [sym__gap] = STATE(301),
    [sym_dis_expr] = STATE(301),
    [sym__form] = STATE(417),
    [sym_kwd_lit] = STATE(417),
    [sym_str_lit] = STATE(417),
    [sym_sym_lit] = STATE(417),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(417),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(417),
    [sym__bare_map_lit] = STATE(403),
    [sym_vec_lit] = STATE(417),
    [sym__bare_vec_lit] = STATE(423),
    [sym_set_lit] = STATE(417),
    [sym__bare_set_lit] = STATE(374),
    [sym_anon_fn_lit] = STATE(417),
    [sym_regex_lit] = STATE(417),
    [sym_read_cond_lit] = STATE(417),
    [sym_splicing_read_cond_lit] = STATE(417),
    [sym_ns_map_lit] = STATE(417),
    [sym_var_quoting_lit] = STATE(417),
    [sym_sym_val_lit] = STATE(417),
    [sym_evaling_lit] = STATE(417),
    [sym_tagged_or_ctor_lit] = STATE(417),
    [sym_derefing_lit] = STATE(417),
    [sym_quoting_lit] = STATE(417),
    [sym_syn_quoting_lit] = STATE(417),
    [sym_unquote_splicing_lit] = STATE(417),
    [sym_unquoting_lit] = STATE(417),
    [aux_sym_dis_expr_repeat1] = STATE(301),
    [aux_sym_sym_lit_repeat1] = STATE(307),
    [sym__ws] = ACTIONS(264),
    [sym_comment] = ACTIONS(264),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(374),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(352),
    [anon_sym_COLON_COLON] = ACTIONS(354),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(374),
    [sym_nil_lit] = ACTIONS(376),
    [sym_bool_lit] = ACTIONS(376),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(358),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(360),
    [anon_sym_POUND_POUND] = ACTIONS(362),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(364),
    [anon_sym_SQUOTE] = ACTIONS(366),
    [anon_sym_BQUOTE] = ACTIONS(368),
    [anon_sym_TILDE_AT] = ACTIONS(370),
    [anon_sym_TILDE] = ACTIONS(372),
  },
  [31] = {
    [sym__gap] = STATE(301),
    [sym_dis_expr] = STATE(301),
    [sym__form] = STATE(389),
    [sym_kwd_lit] = STATE(389),
    [sym_str_lit] = STATE(389),
    [sym_sym_lit] = STATE(389),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(389),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(389),
    [sym__bare_map_lit] = STATE(403),
    [sym_vec_lit] = STATE(389),
    [sym__bare_vec_lit] = STATE(423),
    [sym_set_lit] = STATE(389),
    [sym__bare_set_lit] = STATE(374),
    [sym_anon_fn_lit] = STATE(389),
    [sym_regex_lit] = STATE(389),
    [sym_read_cond_lit] = STATE(389),
    [sym_splicing_read_cond_lit] = STATE(389),
    [sym_ns_map_lit] = STATE(389),
    [sym_var_quoting_lit] = STATE(389),
    [sym_sym_val_lit] = STATE(389),
    [sym_evaling_lit] = STATE(389),
    [sym_tagged_or_ctor_lit] = STATE(389),
    [sym_derefing_lit] = STATE(389),
    [sym_quoting_lit] = STATE(389),
    [sym_syn_quoting_lit] = STATE(389),
    [sym_unquote_splicing_lit] = STATE(389),
    [sym_unquoting_lit] = STATE(389),
    [aux_sym_dis_expr_repeat1] = STATE(301),
    [aux_sym_sym_lit_repeat1] = STATE(304),
    [sym__ws] = ACTIONS(264),
    [sym_comment] = ACTIONS(264),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(378),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(270),
    [anon_sym_COLON_COLON] = ACTIONS(272),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(378),
    [sym_nil_lit] = ACTIONS(380),
    [sym_bool_lit] = ACTIONS(380),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(286),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(292),
    [anon_sym_POUND_POUND] = ACTIONS(294),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(298),
    [anon_sym_SQUOTE] = ACTIONS(300),
    [anon_sym_BQUOTE] = ACTIONS(302),
    [anon_sym_TILDE_AT] = ACTIONS(304),
    [anon_sym_TILDE] = ACTIONS(306),
  },
  [32] = {
    [sym__gap] = STATE(165),
    [sym_dis_expr] = STATE(165),
    [sym__form] = STATE(357),
    [sym_kwd_lit] = STATE(357),
    [sym_str_lit] = STATE(357),
    [sym_sym_lit] = STATE(357),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(357),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(357),
    [sym__bare_map_lit] = STATE(403),
    [sym_vec_lit] = STATE(357),
    [sym__bare_vec_lit] = STATE(423),
    [sym_set_lit] = STATE(357),
    [sym__bare_set_lit] = STATE(374),
    [sym_anon_fn_lit] = STATE(357),
    [sym_regex_lit] = STATE(357),
    [sym_read_cond_lit] = STATE(357),
    [sym_splicing_read_cond_lit] = STATE(357),
    [sym_ns_map_lit] = STATE(357),
    [sym_var_quoting_lit] = STATE(357),
    [sym_sym_val_lit] = STATE(357),
    [sym_evaling_lit] = STATE(357),
    [sym_tagged_or_ctor_lit] = STATE(357),
    [sym_derefing_lit] = STATE(357),
    [sym_quoting_lit] = STATE(357),
    [sym_syn_quoting_lit] = STATE(357),
    [sym_unquote_splicing_lit] = STATE(357),
    [sym_unquoting_lit] = STATE(357),
    [aux_sym_dis_expr_repeat1] = STATE(165),
    [aux_sym_sym_lit_repeat1] = STATE(307),
    [sym__ws] = ACTIONS(382),
    [sym_comment] = ACTIONS(382),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(384),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(352),
    [anon_sym_COLON_COLON] = ACTIONS(354),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(384),
    [sym_nil_lit] = ACTIONS(386),
    [sym_bool_lit] = ACTIONS(386),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(358),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(360),
    [anon_sym_POUND_POUND] = ACTIONS(362),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(364),
    [anon_sym_SQUOTE] = ACTIONS(366),
    [anon_sym_BQUOTE] = ACTIONS(368),
    [anon_sym_TILDE_AT] = ACTIONS(370),
    [anon_sym_TILDE] = ACTIONS(372),
  },
  [33] = {
    [sym__gap] = STATE(161),
    [sym_dis_expr] = STATE(161),
    [sym__form] = STATE(362),
    [sym_kwd_lit] = STATE(362),
    [sym_str_lit] = STATE(362),
    [sym_sym_lit] = STATE(362),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(362),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(362),
    [sym__bare_map_lit] = STATE(403),
    [sym_vec_lit] = STATE(362),
    [sym__bare_vec_lit] = STATE(423),
    [sym_set_lit] = STATE(362),
    [sym__bare_set_lit] = STATE(374),
    [sym_anon_fn_lit] = STATE(362),
    [sym_regex_lit] = STATE(362),
    [sym_read_cond_lit] = STATE(362),
    [sym_splicing_read_cond_lit] = STATE(362),
    [sym_ns_map_lit] = STATE(362),
    [sym_var_quoting_lit] = STATE(362),
    [sym_sym_val_lit] = STATE(362),
    [sym_evaling_lit] = STATE(362),
    [sym_tagged_or_ctor_lit] = STATE(362),
    [sym_derefing_lit] = STATE(362),
    [sym_quoting_lit] = STATE(362),
    [sym_syn_quoting_lit] = STATE(362),
    [sym_unquote_splicing_lit] = STATE(362),
    [sym_unquoting_lit] = STATE(362),
    [aux_sym_dis_expr_repeat1] = STATE(161),
    [aux_sym_sym_lit_repeat1] = STATE(307),
    [sym__ws] = ACTIONS(388),
    [sym_comment] = ACTIONS(388),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(390),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(352),
    [anon_sym_COLON_COLON] = ACTIONS(354),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(390),
    [sym_nil_lit] = ACTIONS(392),
    [sym_bool_lit] = ACTIONS(392),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(358),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(360),
    [anon_sym_POUND_POUND] = ACTIONS(362),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(364),
    [anon_sym_SQUOTE] = ACTIONS(366),
    [anon_sym_BQUOTE] = ACTIONS(368),
    [anon_sym_TILDE_AT] = ACTIONS(370),
    [anon_sym_TILDE] = ACTIONS(372),
  },
  [34] = {
    [sym__gap] = STATE(301),
    [sym_dis_expr] = STATE(301),
    [sym__form] = STATE(364),
    [sym_kwd_lit] = STATE(364),
    [sym_str_lit] = STATE(364),
    [sym_sym_lit] = STATE(364),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(364),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(364),
    [sym__bare_map_lit] = STATE(403),
    [sym_vec_lit] = STATE(364),
    [sym__bare_vec_lit] = STATE(423),
    [sym_set_lit] = STATE(364),
    [sym__bare_set_lit] = STATE(374),
    [sym_anon_fn_lit] = STATE(364),
    [sym_regex_lit] = STATE(364),
    [sym_read_cond_lit] = STATE(364),
    [sym_splicing_read_cond_lit] = STATE(364),
    [sym_ns_map_lit] = STATE(364),
    [sym_var_quoting_lit] = STATE(364),
    [sym_sym_val_lit] = STATE(364),
    [sym_evaling_lit] = STATE(364),
    [sym_tagged_or_ctor_lit] = STATE(364),
    [sym_derefing_lit] = STATE(364),
    [sym_quoting_lit] = STATE(364),
    [sym_syn_quoting_lit] = STATE(364),
    [sym_unquote_splicing_lit] = STATE(364),
    [sym_unquoting_lit] = STATE(364),
    [aux_sym_dis_expr_repeat1] = STATE(301),
    [aux_sym_sym_lit_repeat1] = STATE(307),
    [sym__ws] = ACTIONS(264),
    [sym_comment] = ACTIONS(264),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(394),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(352),
    [anon_sym_COLON_COLON] = ACTIONS(354),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(394),
    [sym_nil_lit] = ACTIONS(396),
    [sym_bool_lit] = ACTIONS(396),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(358),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(360),
    [anon_sym_POUND_POUND] = ACTIONS(362),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(364),
    [anon_sym_SQUOTE] = ACTIONS(366),
    [anon_sym_BQUOTE] = ACTIONS(368),
    [anon_sym_TILDE_AT] = ACTIONS(370),
    [anon_sym_TILDE] = ACTIONS(372),
  },
  [35] = {
    [sym__gap] = STATE(140),
    [sym_dis_expr] = STATE(140),
    [sym__form] = STATE(378),
    [sym_kwd_lit] = STATE(378),
    [sym_str_lit] = STATE(378),
    [sym_sym_lit] = STATE(378),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(378),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(378),
    [sym__bare_map_lit] = STATE(403),
    [sym_vec_lit] = STATE(378),
    [sym__bare_vec_lit] = STATE(423),
    [sym_set_lit] = STATE(378),
    [sym__bare_set_lit] = STATE(374),
    [sym_anon_fn_lit] = STATE(378),
    [sym_regex_lit] = STATE(378),
    [sym_read_cond_lit] = STATE(378),
    [sym_splicing_read_cond_lit] = STATE(378),
    [sym_ns_map_lit] = STATE(378),
    [sym_var_quoting_lit] = STATE(378),
    [sym_sym_val_lit] = STATE(378),
    [sym_evaling_lit] = STATE(378),
    [sym_tagged_or_ctor_lit] = STATE(378),
    [sym_derefing_lit] = STATE(378),
    [sym_quoting_lit] = STATE(378),
    [sym_syn_quoting_lit] = STATE(378),
    [sym_unquote_splicing_lit] = STATE(378),
    [sym_unquoting_lit] = STATE(378),
    [aux_sym_dis_expr_repeat1] = STATE(140),
    [aux_sym_sym_lit_repeat1] = STATE(307),
    [sym__ws] = ACTIONS(398),
    [sym_comment] = ACTIONS(398),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(400),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(352),
    [anon_sym_COLON_COLON] = ACTIONS(354),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(400),
    [sym_nil_lit] = ACTIONS(402),
    [sym_bool_lit] = ACTIONS(402),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(358),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(360),
    [anon_sym_POUND_POUND] = ACTIONS(362),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(364),
    [anon_sym_SQUOTE] = ACTIONS(366),
    [anon_sym_BQUOTE] = ACTIONS(368),
    [anon_sym_TILDE_AT] = ACTIONS(370),
    [anon_sym_TILDE] = ACTIONS(372),
  },
  [36] = {
    [sym__gap] = STATE(124),
    [sym_dis_expr] = STATE(124),
    [sym__form] = STATE(384),
    [sym_kwd_lit] = STATE(384),
    [sym_str_lit] = STATE(384),
    [sym_sym_lit] = STATE(384),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(384),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(384),
    [sym__bare_map_lit] = STATE(403),
    [sym_vec_lit] = STATE(384),
    [sym__bare_vec_lit] = STATE(423),
    [sym_set_lit] = STATE(384),
    [sym__bare_set_lit] = STATE(374),
    [sym_anon_fn_lit] = STATE(384),
    [sym_regex_lit] = STATE(384),
    [sym_read_cond_lit] = STATE(384),
    [sym_splicing_read_cond_lit] = STATE(384),
    [sym_ns_map_lit] = STATE(384),
    [sym_var_quoting_lit] = STATE(384),
    [sym_sym_val_lit] = STATE(384),
    [sym_evaling_lit] = STATE(384),
    [sym_tagged_or_ctor_lit] = STATE(384),
    [sym_derefing_lit] = STATE(384),
    [sym_quoting_lit] = STATE(384),
    [sym_syn_quoting_lit] = STATE(384),
    [sym_unquote_splicing_lit] = STATE(384),
    [sym_unquoting_lit] = STATE(384),
    [aux_sym_dis_expr_repeat1] = STATE(124),
    [aux_sym_sym_lit_repeat1] = STATE(307),
    [sym__ws] = ACTIONS(404),
    [sym_comment] = ACTIONS(404),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(406),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(352),
    [anon_sym_COLON_COLON] = ACTIONS(354),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(406),
    [sym_nil_lit] = ACTIONS(408),
    [sym_bool_lit] = ACTIONS(408),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(358),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(360),
    [anon_sym_POUND_POUND] = ACTIONS(362),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(364),
    [anon_sym_SQUOTE] = ACTIONS(366),
    [anon_sym_BQUOTE] = ACTIONS(368),
    [anon_sym_TILDE_AT] = ACTIONS(370),
    [anon_sym_TILDE] = ACTIONS(372),
  },
  [37] = {
    [sym__gap] = STATE(117),
    [sym_dis_expr] = STATE(117),
    [sym__form] = STATE(410),
    [sym_kwd_lit] = STATE(410),
    [sym_str_lit] = STATE(410),
    [sym_sym_lit] = STATE(410),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(410),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(410),
    [sym__bare_map_lit] = STATE(403),
    [sym_vec_lit] = STATE(410),
    [sym__bare_vec_lit] = STATE(423),
    [sym_set_lit] = STATE(410),
    [sym__bare_set_lit] = STATE(374),
    [sym_anon_fn_lit] = STATE(410),
    [sym_regex_lit] = STATE(410),
    [sym_read_cond_lit] = STATE(410),
    [sym_splicing_read_cond_lit] = STATE(410),
    [sym_ns_map_lit] = STATE(410),
    [sym_var_quoting_lit] = STATE(410),
    [sym_sym_val_lit] = STATE(410),
    [sym_evaling_lit] = STATE(410),
    [sym_tagged_or_ctor_lit] = STATE(410),
    [sym_derefing_lit] = STATE(410),
    [sym_quoting_lit] = STATE(410),
    [sym_syn_quoting_lit] = STATE(410),
    [sym_unquote_splicing_lit] = STATE(410),
    [sym_unquoting_lit] = STATE(410),
    [aux_sym_dis_expr_repeat1] = STATE(117),
    [aux_sym_sym_lit_repeat1] = STATE(307),
    [sym__ws] = ACTIONS(410),
    [sym_comment] = ACTIONS(410),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(412),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(352),
    [anon_sym_COLON_COLON] = ACTIONS(354),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(412),
    [sym_nil_lit] = ACTIONS(414),
    [sym_bool_lit] = ACTIONS(414),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(358),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(360),
    [anon_sym_POUND_POUND] = ACTIONS(362),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(364),
    [anon_sym_SQUOTE] = ACTIONS(366),
    [anon_sym_BQUOTE] = ACTIONS(368),
    [anon_sym_TILDE_AT] = ACTIONS(370),
    [anon_sym_TILDE] = ACTIONS(372),
  },
  [38] = {
    [sym__gap] = STATE(29),
    [sym_dis_expr] = STATE(29),
    [sym__form] = STATE(391),
    [sym_kwd_lit] = STATE(391),
    [sym_str_lit] = STATE(391),
    [sym_sym_lit] = STATE(391),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(391),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(391),
    [sym__bare_map_lit] = STATE(403),
    [sym_vec_lit] = STATE(391),
    [sym__bare_vec_lit] = STATE(423),
    [sym_set_lit] = STATE(391),
    [sym__bare_set_lit] = STATE(374),
    [sym_anon_fn_lit] = STATE(391),
    [sym_regex_lit] = STATE(391),
    [sym_read_cond_lit] = STATE(391),
    [sym_splicing_read_cond_lit] = STATE(391),
    [sym_ns_map_lit] = STATE(391),
    [sym_var_quoting_lit] = STATE(391),
    [sym_sym_val_lit] = STATE(391),
    [sym_evaling_lit] = STATE(391),
    [sym_tagged_or_ctor_lit] = STATE(391),
    [sym_derefing_lit] = STATE(391),
    [sym_quoting_lit] = STATE(391),
    [sym_syn_quoting_lit] = STATE(391),
    [sym_unquote_splicing_lit] = STATE(391),
    [sym_unquoting_lit] = STATE(391),
    [aux_sym_dis_expr_repeat1] = STATE(29),
    [aux_sym_sym_lit_repeat1] = STATE(307),
    [sym__ws] = ACTIONS(416),
    [sym_comment] = ACTIONS(416),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(418),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(352),
    [anon_sym_COLON_COLON] = ACTIONS(354),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(418),
    [sym_nil_lit] = ACTIONS(420),
    [sym_bool_lit] = ACTIONS(420),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(358),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(360),
    [anon_sym_POUND_POUND] = ACTIONS(362),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(364),
    [anon_sym_SQUOTE] = ACTIONS(366),
    [anon_sym_BQUOTE] = ACTIONS(368),
    [anon_sym_TILDE_AT] = ACTIONS(370),
    [anon_sym_TILDE] = ACTIONS(372),
  },
  [39] = {
    [sym__gap] = STATE(301),
    [sym_dis_expr] = STATE(301),
    [sym__form] = STATE(257),
    [sym_kwd_lit] = STATE(257),
    [sym_str_lit] = STATE(257),
    [sym_sym_lit] = STATE(257),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(257),
    [sym__bare_list_lit] = STATE(218),
    [sym_map_lit] = STATE(257),
    [sym__bare_map_lit] = STATE(219),
    [sym_vec_lit] = STATE(257),
    [sym__bare_vec_lit] = STATE(226),
    [sym_set_lit] = STATE(257),
    [sym__bare_set_lit] = STATE(227),
    [sym_anon_fn_lit] = STATE(257),
    [sym_regex_lit] = STATE(257),
    [sym_read_cond_lit] = STATE(257),
    [sym_splicing_read_cond_lit] = STATE(257),
    [sym_ns_map_lit] = STATE(257),
    [sym_var_quoting_lit] = STATE(257),
    [sym_sym_val_lit] = STATE(257),
    [sym_evaling_lit] = STATE(257),
    [sym_tagged_or_ctor_lit] = STATE(257),
    [sym_derefing_lit] = STATE(257),
    [sym_quoting_lit] = STATE(257),
    [sym_syn_quoting_lit] = STATE(257),
    [sym_unquote_splicing_lit] = STATE(257),
    [sym_unquoting_lit] = STATE(257),
    [aux_sym_dis_expr_repeat1] = STATE(301),
    [aux_sym_sym_lit_repeat1] = STATE(305),
    [sym__ws] = ACTIONS(264),
    [sym_comment] = ACTIONS(264),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(422),
    [anon_sym_SLASH] = ACTIONS(9),
    [anon_sym_COLON] = ACTIONS(11),
    [anon_sym_COLON_COLON] = ACTIONS(13),
    [aux_sym_str_lit_token1] = ACTIONS(15),
    [sym_char_lit] = ACTIONS(422),
    [sym_nil_lit] = ACTIONS(424),
    [sym_bool_lit] = ACTIONS(424),
    [aux_sym__sym_qualified_token1] = ACTIONS(19),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_POUND] = ACTIONS(31),
    [anon_sym_POUND_QMARK] = ACTIONS(33),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(35),
    [anon_sym_POUND_SQUOTE] = ACTIONS(37),
    [anon_sym_POUND_POUND] = ACTIONS(39),
    [anon_sym_POUND_EQ] = ACTIONS(41),
    [anon_sym_AT] = ACTIONS(43),
    [anon_sym_SQUOTE] = ACTIONS(45),
    [anon_sym_BQUOTE] = ACTIONS(47),
    [anon_sym_TILDE_AT] = ACTIONS(49),
    [anon_sym_TILDE] = ACTIONS(51),
  },
  [40] = {
    [sym__gap] = STATE(301),
    [sym_dis_expr] = STATE(301),
    [sym__form] = STATE(420),
    [sym_kwd_lit] = STATE(420),
    [sym_str_lit] = STATE(420),
    [sym_sym_lit] = STATE(420),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(420),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(420),
    [sym__bare_map_lit] = STATE(403),
    [sym_vec_lit] = STATE(420),
    [sym__bare_vec_lit] = STATE(423),
    [sym_set_lit] = STATE(420),
    [sym__bare_set_lit] = STATE(374),
    [sym_anon_fn_lit] = STATE(420),
    [sym_regex_lit] = STATE(420),
    [sym_read_cond_lit] = STATE(420),
    [sym_splicing_read_cond_lit] = STATE(420),
    [sym_ns_map_lit] = STATE(420),
    [sym_var_quoting_lit] = STATE(420),
    [sym_sym_val_lit] = STATE(420),
    [sym_evaling_lit] = STATE(420),
    [sym_tagged_or_ctor_lit] = STATE(420),
    [sym_derefing_lit] = STATE(420),
    [sym_quoting_lit] = STATE(420),
    [sym_syn_quoting_lit] = STATE(420),
    [sym_unquote_splicing_lit] = STATE(420),
    [sym_unquoting_lit] = STATE(420),
    [aux_sym_dis_expr_repeat1] = STATE(301),
    [aux_sym_sym_lit_repeat1] = STATE(306),
    [sym__ws] = ACTIONS(264),
    [sym_comment] = ACTIONS(264),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(266),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(426),
    [anon_sym_COLON_COLON] = ACTIONS(428),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(266),
    [sym_nil_lit] = ACTIONS(276),
    [sym_bool_lit] = ACTIONS(276),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(430),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(432),
    [anon_sym_POUND_POUND] = ACTIONS(434),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(436),
    [anon_sym_SQUOTE] = ACTIONS(438),
    [anon_sym_BQUOTE] = ACTIONS(440),
    [anon_sym_TILDE_AT] = ACTIONS(442),
    [anon_sym_TILDE] = ACTIONS(444),
  },
  [41] = {
    [sym__gap] = STATE(30),
    [sym_dis_expr] = STATE(30),
    [sym__form] = STATE(393),
    [sym_kwd_lit] = STATE(393),
    [sym_str_lit] = STATE(393),
    [sym_sym_lit] = STATE(393),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(393),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(393),
    [sym__bare_map_lit] = STATE(403),
    [sym_vec_lit] = STATE(393),
    [sym__bare_vec_lit] = STATE(423),
    [sym_set_lit] = STATE(393),
    [sym__bare_set_lit] = STATE(374),
    [sym_anon_fn_lit] = STATE(393),
    [sym_regex_lit] = STATE(393),
    [sym_read_cond_lit] = STATE(393),
    [sym_splicing_read_cond_lit] = STATE(393),
    [sym_ns_map_lit] = STATE(393),
    [sym_var_quoting_lit] = STATE(393),
    [sym_sym_val_lit] = STATE(393),
    [sym_evaling_lit] = STATE(393),
    [sym_tagged_or_ctor_lit] = STATE(393),
    [sym_derefing_lit] = STATE(393),
    [sym_quoting_lit] = STATE(393),
    [sym_syn_quoting_lit] = STATE(393),
    [sym_unquote_splicing_lit] = STATE(393),
    [sym_unquoting_lit] = STATE(393),
    [aux_sym_dis_expr_repeat1] = STATE(30),
    [aux_sym_sym_lit_repeat1] = STATE(307),
    [sym__ws] = ACTIONS(446),
    [sym_comment] = ACTIONS(446),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(448),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(352),
    [anon_sym_COLON_COLON] = ACTIONS(354),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(448),
    [sym_nil_lit] = ACTIONS(450),
    [sym_bool_lit] = ACTIONS(450),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(358),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(360),
    [anon_sym_POUND_POUND] = ACTIONS(362),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(364),
    [anon_sym_SQUOTE] = ACTIONS(366),
    [anon_sym_BQUOTE] = ACTIONS(368),
    [anon_sym_TILDE_AT] = ACTIONS(370),
    [anon_sym_TILDE] = ACTIONS(372),
  },
  [42] = {
    [sym__gap] = STATE(119),
    [sym_dis_expr] = STATE(119),
    [sym__form] = STATE(405),
    [sym_kwd_lit] = STATE(405),
    [sym_str_lit] = STATE(405),
    [sym_sym_lit] = STATE(405),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(405),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(405),
    [sym__bare_map_lit] = STATE(403),
    [sym_vec_lit] = STATE(405),
    [sym__bare_vec_lit] = STATE(423),
    [sym_set_lit] = STATE(405),
    [sym__bare_set_lit] = STATE(374),
    [sym_anon_fn_lit] = STATE(405),
    [sym_regex_lit] = STATE(405),
    [sym_read_cond_lit] = STATE(405),
    [sym_splicing_read_cond_lit] = STATE(405),
    [sym_ns_map_lit] = STATE(405),
    [sym_var_quoting_lit] = STATE(405),
    [sym_sym_val_lit] = STATE(405),
    [sym_evaling_lit] = STATE(405),
    [sym_tagged_or_ctor_lit] = STATE(405),
    [sym_derefing_lit] = STATE(405),
    [sym_quoting_lit] = STATE(405),
    [sym_syn_quoting_lit] = STATE(405),
    [sym_unquote_splicing_lit] = STATE(405),
    [sym_unquoting_lit] = STATE(405),
    [aux_sym_dis_expr_repeat1] = STATE(119),
    [aux_sym_sym_lit_repeat1] = STATE(307),
    [sym__ws] = ACTIONS(452),
    [sym_comment] = ACTIONS(452),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(454),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(352),
    [anon_sym_COLON_COLON] = ACTIONS(354),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(454),
    [sym_nil_lit] = ACTIONS(456),
    [sym_bool_lit] = ACTIONS(456),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(358),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(360),
    [anon_sym_POUND_POUND] = ACTIONS(362),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(364),
    [anon_sym_SQUOTE] = ACTIONS(366),
    [anon_sym_BQUOTE] = ACTIONS(368),
    [anon_sym_TILDE_AT] = ACTIONS(370),
    [anon_sym_TILDE] = ACTIONS(372),
  },
  [43] = {
    [sym__gap] = STATE(301),
    [sym_dis_expr] = STATE(301),
    [sym__form] = STATE(369),
    [sym_kwd_lit] = STATE(369),
    [sym_str_lit] = STATE(369),
    [sym_sym_lit] = STATE(369),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(369),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(369),
    [sym__bare_map_lit] = STATE(403),
    [sym_vec_lit] = STATE(369),
    [sym__bare_vec_lit] = STATE(423),
    [sym_set_lit] = STATE(369),
    [sym__bare_set_lit] = STATE(374),
    [sym_anon_fn_lit] = STATE(369),
    [sym_regex_lit] = STATE(369),
    [sym_read_cond_lit] = STATE(369),
    [sym_splicing_read_cond_lit] = STATE(369),
    [sym_ns_map_lit] = STATE(369),
    [sym_var_quoting_lit] = STATE(369),
    [sym_sym_val_lit] = STATE(369),
    [sym_evaling_lit] = STATE(369),
    [sym_tagged_or_ctor_lit] = STATE(369),
    [sym_derefing_lit] = STATE(369),
    [sym_quoting_lit] = STATE(369),
    [sym_syn_quoting_lit] = STATE(369),
    [sym_unquote_splicing_lit] = STATE(369),
    [sym_unquoting_lit] = STATE(369),
    [aux_sym_dis_expr_repeat1] = STATE(301),
    [aux_sym_sym_lit_repeat1] = STATE(307),
    [sym__ws] = ACTIONS(264),
    [sym_comment] = ACTIONS(264),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(458),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(352),
    [anon_sym_COLON_COLON] = ACTIONS(354),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(458),
    [sym_nil_lit] = ACTIONS(460),
    [sym_bool_lit] = ACTIONS(460),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(358),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(360),
    [anon_sym_POUND_POUND] = ACTIONS(362),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(364),
    [anon_sym_SQUOTE] = ACTIONS(366),
    [anon_sym_BQUOTE] = ACTIONS(368),
    [anon_sym_TILDE_AT] = ACTIONS(370),
    [anon_sym_TILDE] = ACTIONS(372),
  },
  [44] = {
    [sym__gap] = STATE(301),
    [sym_dis_expr] = STATE(301),
    [sym__form] = STATE(399),
    [sym_kwd_lit] = STATE(399),
    [sym_str_lit] = STATE(399),
    [sym_sym_lit] = STATE(399),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(399),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(399),
    [sym__bare_map_lit] = STATE(403),
    [sym_vec_lit] = STATE(399),
    [sym__bare_vec_lit] = STATE(423),
    [sym_set_lit] = STATE(399),
    [sym__bare_set_lit] = STATE(374),
    [sym_anon_fn_lit] = STATE(399),
    [sym_regex_lit] = STATE(399),
    [sym_read_cond_lit] = STATE(399),
    [sym_splicing_read_cond_lit] = STATE(399),
    [sym_ns_map_lit] = STATE(399),
    [sym_var_quoting_lit] = STATE(399),
    [sym_sym_val_lit] = STATE(399),
    [sym_evaling_lit] = STATE(399),
    [sym_tagged_or_ctor_lit] = STATE(399),
    [sym_derefing_lit] = STATE(399),
    [sym_quoting_lit] = STATE(399),
    [sym_syn_quoting_lit] = STATE(399),
    [sym_unquote_splicing_lit] = STATE(399),
    [sym_unquoting_lit] = STATE(399),
    [aux_sym_dis_expr_repeat1] = STATE(301),
    [aux_sym_sym_lit_repeat1] = STATE(306),
    [sym__ws] = ACTIONS(264),
    [sym_comment] = ACTIONS(264),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(462),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(426),
    [anon_sym_COLON_COLON] = ACTIONS(428),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(462),
    [sym_nil_lit] = ACTIONS(464),
    [sym_bool_lit] = ACTIONS(464),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(430),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(432),
    [anon_sym_POUND_POUND] = ACTIONS(434),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(436),
    [anon_sym_SQUOTE] = ACTIONS(438),
    [anon_sym_BQUOTE] = ACTIONS(440),
    [anon_sym_TILDE_AT] = ACTIONS(442),
    [anon_sym_TILDE] = ACTIONS(444),
  },
  [45] = {
    [sym__gap] = STATE(301),
    [sym_dis_expr] = STATE(301),
    [sym__form] = STATE(412),
    [sym_kwd_lit] = STATE(412),
    [sym_str_lit] = STATE(412),
    [sym_sym_lit] = STATE(412),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(412),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(412),
    [sym__bare_map_lit] = STATE(403),
    [sym_vec_lit] = STATE(412),
    [sym__bare_vec_lit] = STATE(423),
    [sym_set_lit] = STATE(412),
    [sym__bare_set_lit] = STATE(374),
    [sym_anon_fn_lit] = STATE(412),
    [sym_regex_lit] = STATE(412),
    [sym_read_cond_lit] = STATE(412),
    [sym_splicing_read_cond_lit] = STATE(412),
    [sym_ns_map_lit] = STATE(412),
    [sym_var_quoting_lit] = STATE(412),
    [sym_sym_val_lit] = STATE(412),
    [sym_evaling_lit] = STATE(412),
    [sym_tagged_or_ctor_lit] = STATE(412),
    [sym_derefing_lit] = STATE(412),
    [sym_quoting_lit] = STATE(412),
    [sym_syn_quoting_lit] = STATE(412),
    [sym_unquote_splicing_lit] = STATE(412),
    [sym_unquoting_lit] = STATE(412),
    [aux_sym_dis_expr_repeat1] = STATE(301),
    [aux_sym_sym_lit_repeat1] = STATE(307),
    [sym__ws] = ACTIONS(264),
    [sym_comment] = ACTIONS(264),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(466),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(352),
    [anon_sym_COLON_COLON] = ACTIONS(354),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(466),
    [sym_nil_lit] = ACTIONS(468),
    [sym_bool_lit] = ACTIONS(468),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(358),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(360),
    [anon_sym_POUND_POUND] = ACTIONS(362),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(364),
    [anon_sym_SQUOTE] = ACTIONS(366),
    [anon_sym_BQUOTE] = ACTIONS(368),
    [anon_sym_TILDE_AT] = ACTIONS(370),
    [anon_sym_TILDE] = ACTIONS(372),
  },
  [46] = {
    [sym__gap] = STATE(301),
    [sym_dis_expr] = STATE(301),
    [sym__form] = STATE(389),
    [sym_kwd_lit] = STATE(389),
    [sym_str_lit] = STATE(389),
    [sym_sym_lit] = STATE(389),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(389),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(389),
    [sym__bare_map_lit] = STATE(403),
    [sym_vec_lit] = STATE(389),
    [sym__bare_vec_lit] = STATE(423),
    [sym_set_lit] = STATE(389),
    [sym__bare_set_lit] = STATE(374),
    [sym_anon_fn_lit] = STATE(389),
    [sym_regex_lit] = STATE(389),
    [sym_read_cond_lit] = STATE(389),
    [sym_splicing_read_cond_lit] = STATE(389),
    [sym_ns_map_lit] = STATE(389),
    [sym_var_quoting_lit] = STATE(389),
    [sym_sym_val_lit] = STATE(389),
    [sym_evaling_lit] = STATE(389),
    [sym_tagged_or_ctor_lit] = STATE(389),
    [sym_derefing_lit] = STATE(389),
    [sym_quoting_lit] = STATE(389),
    [sym_syn_quoting_lit] = STATE(389),
    [sym_unquote_splicing_lit] = STATE(389),
    [sym_unquoting_lit] = STATE(389),
    [aux_sym_dis_expr_repeat1] = STATE(301),
    [aux_sym_sym_lit_repeat1] = STATE(306),
    [sym__ws] = ACTIONS(264),
    [sym_comment] = ACTIONS(264),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(378),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(426),
    [anon_sym_COLON_COLON] = ACTIONS(428),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(378),
    [sym_nil_lit] = ACTIONS(380),
    [sym_bool_lit] = ACTIONS(380),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(430),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(432),
    [anon_sym_POUND_POUND] = ACTIONS(434),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(436),
    [anon_sym_SQUOTE] = ACTIONS(438),
    [anon_sym_BQUOTE] = ACTIONS(440),
    [anon_sym_TILDE_AT] = ACTIONS(442),
    [anon_sym_TILDE] = ACTIONS(444),
  },
  [47] = {
    [sym__gap] = STATE(301),
    [sym_dis_expr] = STATE(301),
    [sym__form] = STATE(414),
    [sym_kwd_lit] = STATE(414),
    [sym_str_lit] = STATE(414),
    [sym_sym_lit] = STATE(414),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(414),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(414),
    [sym__bare_map_lit] = STATE(403),
    [sym_vec_lit] = STATE(414),
    [sym__bare_vec_lit] = STATE(423),
    [sym_set_lit] = STATE(414),
    [sym__bare_set_lit] = STATE(374),
    [sym_anon_fn_lit] = STATE(414),
    [sym_regex_lit] = STATE(414),
    [sym_read_cond_lit] = STATE(414),
    [sym_splicing_read_cond_lit] = STATE(414),
    [sym_ns_map_lit] = STATE(414),
    [sym_var_quoting_lit] = STATE(414),
    [sym_sym_val_lit] = STATE(414),
    [sym_evaling_lit] = STATE(414),
    [sym_tagged_or_ctor_lit] = STATE(414),
    [sym_derefing_lit] = STATE(414),
    [sym_quoting_lit] = STATE(414),
    [sym_syn_quoting_lit] = STATE(414),
    [sym_unquote_splicing_lit] = STATE(414),
    [sym_unquoting_lit] = STATE(414),
    [aux_sym_dis_expr_repeat1] = STATE(301),
    [aux_sym_sym_lit_repeat1] = STATE(307),
    [sym__ws] = ACTIONS(264),
    [sym_comment] = ACTIONS(264),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(470),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(352),
    [anon_sym_COLON_COLON] = ACTIONS(354),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(470),
    [sym_nil_lit] = ACTIONS(472),
    [sym_bool_lit] = ACTIONS(472),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(358),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(360),
    [anon_sym_POUND_POUND] = ACTIONS(362),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(364),
    [anon_sym_SQUOTE] = ACTIONS(366),
    [anon_sym_BQUOTE] = ACTIONS(368),
    [anon_sym_TILDE_AT] = ACTIONS(370),
    [anon_sym_TILDE] = ACTIONS(372),
  },
  [48] = {
    [sym__gap] = STATE(301),
    [sym_dis_expr] = STATE(301),
    [sym__form] = STATE(415),
    [sym_kwd_lit] = STATE(415),
    [sym_str_lit] = STATE(415),
    [sym_sym_lit] = STATE(415),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(415),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(415),
    [sym__bare_map_lit] = STATE(403),
    [sym_vec_lit] = STATE(415),
    [sym__bare_vec_lit] = STATE(423),
    [sym_set_lit] = STATE(415),
    [sym__bare_set_lit] = STATE(374),
    [sym_anon_fn_lit] = STATE(415),
    [sym_regex_lit] = STATE(415),
    [sym_read_cond_lit] = STATE(415),
    [sym_splicing_read_cond_lit] = STATE(415),
    [sym_ns_map_lit] = STATE(415),
    [sym_var_quoting_lit] = STATE(415),
    [sym_sym_val_lit] = STATE(415),
    [sym_evaling_lit] = STATE(415),
    [sym_tagged_or_ctor_lit] = STATE(415),
    [sym_derefing_lit] = STATE(415),
    [sym_quoting_lit] = STATE(415),
    [sym_syn_quoting_lit] = STATE(415),
    [sym_unquote_splicing_lit] = STATE(415),
    [sym_unquoting_lit] = STATE(415),
    [aux_sym_dis_expr_repeat1] = STATE(301),
    [aux_sym_sym_lit_repeat1] = STATE(307),
    [sym__ws] = ACTIONS(264),
    [sym_comment] = ACTIONS(264),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(474),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(352),
    [anon_sym_COLON_COLON] = ACTIONS(354),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(474),
    [sym_nil_lit] = ACTIONS(476),
    [sym_bool_lit] = ACTIONS(476),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(358),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(360),
    [anon_sym_POUND_POUND] = ACTIONS(362),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(364),
    [anon_sym_SQUOTE] = ACTIONS(366),
    [anon_sym_BQUOTE] = ACTIONS(368),
    [anon_sym_TILDE_AT] = ACTIONS(370),
    [anon_sym_TILDE] = ACTIONS(372),
  },
  [49] = {
    [sym__gap] = STATE(301),
    [sym_dis_expr] = STATE(301),
    [sym__form] = STATE(416),
    [sym_kwd_lit] = STATE(416),
    [sym_str_lit] = STATE(416),
    [sym_sym_lit] = STATE(416),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(416),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(416),
    [sym__bare_map_lit] = STATE(403),
    [sym_vec_lit] = STATE(416),
    [sym__bare_vec_lit] = STATE(423),
    [sym_set_lit] = STATE(416),
    [sym__bare_set_lit] = STATE(374),
    [sym_anon_fn_lit] = STATE(416),
    [sym_regex_lit] = STATE(416),
    [sym_read_cond_lit] = STATE(416),
    [sym_splicing_read_cond_lit] = STATE(416),
    [sym_ns_map_lit] = STATE(416),
    [sym_var_quoting_lit] = STATE(416),
    [sym_sym_val_lit] = STATE(416),
    [sym_evaling_lit] = STATE(416),
    [sym_tagged_or_ctor_lit] = STATE(416),
    [sym_derefing_lit] = STATE(416),
    [sym_quoting_lit] = STATE(416),
    [sym_syn_quoting_lit] = STATE(416),
    [sym_unquote_splicing_lit] = STATE(416),
    [sym_unquoting_lit] = STATE(416),
    [aux_sym_dis_expr_repeat1] = STATE(301),
    [aux_sym_sym_lit_repeat1] = STATE(307),
    [sym__ws] = ACTIONS(264),
    [sym_comment] = ACTIONS(264),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(478),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(352),
    [anon_sym_COLON_COLON] = ACTIONS(354),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(478),
    [sym_nil_lit] = ACTIONS(480),
    [sym_bool_lit] = ACTIONS(480),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(358),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(360),
    [anon_sym_POUND_POUND] = ACTIONS(362),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(364),
    [anon_sym_SQUOTE] = ACTIONS(366),
    [anon_sym_BQUOTE] = ACTIONS(368),
    [anon_sym_TILDE_AT] = ACTIONS(370),
    [anon_sym_TILDE] = ACTIONS(372),
  },
  [50] = {
    [sym__gap] = STATE(301),
    [sym_dis_expr] = STATE(301),
    [sym__form] = STATE(419),
    [sym_kwd_lit] = STATE(419),
    [sym_str_lit] = STATE(419),
    [sym_sym_lit] = STATE(419),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(419),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(419),
    [sym__bare_map_lit] = STATE(403),
    [sym_vec_lit] = STATE(419),
    [sym__bare_vec_lit] = STATE(423),
    [sym_set_lit] = STATE(419),
    [sym__bare_set_lit] = STATE(374),
    [sym_anon_fn_lit] = STATE(419),
    [sym_regex_lit] = STATE(419),
    [sym_read_cond_lit] = STATE(419),
    [sym_splicing_read_cond_lit] = STATE(419),
    [sym_ns_map_lit] = STATE(419),
    [sym_var_quoting_lit] = STATE(419),
    [sym_sym_val_lit] = STATE(419),
    [sym_evaling_lit] = STATE(419),
    [sym_tagged_or_ctor_lit] = STATE(419),
    [sym_derefing_lit] = STATE(419),
    [sym_quoting_lit] = STATE(419),
    [sym_syn_quoting_lit] = STATE(419),
    [sym_unquote_splicing_lit] = STATE(419),
    [sym_unquoting_lit] = STATE(419),
    [aux_sym_dis_expr_repeat1] = STATE(301),
    [aux_sym_sym_lit_repeat1] = STATE(307),
    [sym__ws] = ACTIONS(264),
    [sym_comment] = ACTIONS(264),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(482),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(352),
    [anon_sym_COLON_COLON] = ACTIONS(354),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(482),
    [sym_nil_lit] = ACTIONS(484),
    [sym_bool_lit] = ACTIONS(484),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(358),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(360),
    [anon_sym_POUND_POUND] = ACTIONS(362),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(364),
    [anon_sym_SQUOTE] = ACTIONS(366),
    [anon_sym_BQUOTE] = ACTIONS(368),
    [anon_sym_TILDE_AT] = ACTIONS(370),
    [anon_sym_TILDE] = ACTIONS(372),
  },
  [51] = {
    [sym__gap] = STATE(301),
    [sym_dis_expr] = STATE(301),
    [sym__form] = STATE(420),
    [sym_kwd_lit] = STATE(420),
    [sym_str_lit] = STATE(420),
    [sym_sym_lit] = STATE(420),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(420),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(420),
    [sym__bare_map_lit] = STATE(403),
    [sym_vec_lit] = STATE(420),
    [sym__bare_vec_lit] = STATE(423),
    [sym_set_lit] = STATE(420),
    [sym__bare_set_lit] = STATE(374),
    [sym_anon_fn_lit] = STATE(420),
    [sym_regex_lit] = STATE(420),
    [sym_read_cond_lit] = STATE(420),
    [sym_splicing_read_cond_lit] = STATE(420),
    [sym_ns_map_lit] = STATE(420),
    [sym_var_quoting_lit] = STATE(420),
    [sym_sym_val_lit] = STATE(420),
    [sym_evaling_lit] = STATE(420),
    [sym_tagged_or_ctor_lit] = STATE(420),
    [sym_derefing_lit] = STATE(420),
    [sym_quoting_lit] = STATE(420),
    [sym_syn_quoting_lit] = STATE(420),
    [sym_unquote_splicing_lit] = STATE(420),
    [sym_unquoting_lit] = STATE(420),
    [aux_sym_dis_expr_repeat1] = STATE(301),
    [aux_sym_sym_lit_repeat1] = STATE(307),
    [sym__ws] = ACTIONS(264),
    [sym_comment] = ACTIONS(264),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(266),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(352),
    [anon_sym_COLON_COLON] = ACTIONS(354),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(266),
    [sym_nil_lit] = ACTIONS(276),
    [sym_bool_lit] = ACTIONS(276),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(358),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(360),
    [anon_sym_POUND_POUND] = ACTIONS(362),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(364),
    [anon_sym_SQUOTE] = ACTIONS(366),
    [anon_sym_BQUOTE] = ACTIONS(368),
    [anon_sym_TILDE_AT] = ACTIONS(370),
    [anon_sym_TILDE] = ACTIONS(372),
  },
  [52] = {
    [sym__gap] = STATE(34),
    [sym_dis_expr] = STATE(34),
    [sym__form] = STATE(409),
    [sym_kwd_lit] = STATE(409),
    [sym_str_lit] = STATE(409),
    [sym_sym_lit] = STATE(409),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(409),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(409),
    [sym__bare_map_lit] = STATE(403),
    [sym_vec_lit] = STATE(409),
    [sym__bare_vec_lit] = STATE(423),
    [sym_set_lit] = STATE(409),
    [sym__bare_set_lit] = STATE(374),
    [sym_anon_fn_lit] = STATE(409),
    [sym_regex_lit] = STATE(409),
    [sym_read_cond_lit] = STATE(409),
    [sym_splicing_read_cond_lit] = STATE(409),
    [sym_ns_map_lit] = STATE(409),
    [sym_var_quoting_lit] = STATE(409),
    [sym_sym_val_lit] = STATE(409),
    [sym_evaling_lit] = STATE(409),
    [sym_tagged_or_ctor_lit] = STATE(409),
    [sym_derefing_lit] = STATE(409),
    [sym_quoting_lit] = STATE(409),
    [sym_syn_quoting_lit] = STATE(409),
    [sym_unquote_splicing_lit] = STATE(409),
    [sym_unquoting_lit] = STATE(409),
    [aux_sym_dis_expr_repeat1] = STATE(34),
    [aux_sym_sym_lit_repeat1] = STATE(307),
    [sym__ws] = ACTIONS(486),
    [sym_comment] = ACTIONS(486),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(488),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(352),
    [anon_sym_COLON_COLON] = ACTIONS(354),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(488),
    [sym_nil_lit] = ACTIONS(490),
    [sym_bool_lit] = ACTIONS(490),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(358),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(360),
    [anon_sym_POUND_POUND] = ACTIONS(362),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(364),
    [anon_sym_SQUOTE] = ACTIONS(366),
    [anon_sym_BQUOTE] = ACTIONS(368),
    [anon_sym_TILDE_AT] = ACTIONS(370),
    [anon_sym_TILDE] = ACTIONS(372),
  },
  [53] = {
    [sym__gap] = STATE(301),
    [sym_dis_expr] = STATE(301),
    [sym__form] = STATE(386),
    [sym_kwd_lit] = STATE(386),
    [sym_str_lit] = STATE(386),
    [sym_sym_lit] = STATE(386),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(386),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(386),
    [sym__bare_map_lit] = STATE(403),
    [sym_vec_lit] = STATE(386),
    [sym__bare_vec_lit] = STATE(423),
    [sym_set_lit] = STATE(386),
    [sym__bare_set_lit] = STATE(374),
    [sym_anon_fn_lit] = STATE(386),
    [sym_regex_lit] = STATE(386),
    [sym_read_cond_lit] = STATE(386),
    [sym_splicing_read_cond_lit] = STATE(386),
    [sym_ns_map_lit] = STATE(386),
    [sym_var_quoting_lit] = STATE(386),
    [sym_sym_val_lit] = STATE(386),
    [sym_evaling_lit] = STATE(386),
    [sym_tagged_or_ctor_lit] = STATE(386),
    [sym_derefing_lit] = STATE(386),
    [sym_quoting_lit] = STATE(386),
    [sym_syn_quoting_lit] = STATE(386),
    [sym_unquote_splicing_lit] = STATE(386),
    [sym_unquoting_lit] = STATE(386),
    [aux_sym_dis_expr_repeat1] = STATE(301),
    [aux_sym_sym_lit_repeat1] = STATE(306),
    [sym__ws] = ACTIONS(264),
    [sym_comment] = ACTIONS(264),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(492),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(426),
    [anon_sym_COLON_COLON] = ACTIONS(428),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(492),
    [sym_nil_lit] = ACTIONS(494),
    [sym_bool_lit] = ACTIONS(494),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(430),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(432),
    [anon_sym_POUND_POUND] = ACTIONS(434),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(436),
    [anon_sym_SQUOTE] = ACTIONS(438),
    [anon_sym_BQUOTE] = ACTIONS(440),
    [anon_sym_TILDE_AT] = ACTIONS(442),
    [anon_sym_TILDE] = ACTIONS(444),
  },
  [54] = {
    [sym__gap] = STATE(21),
    [sym_dis_expr] = STATE(21),
    [sym__form] = STATE(345),
    [sym_kwd_lit] = STATE(345),
    [sym_str_lit] = STATE(345),
    [sym_sym_lit] = STATE(345),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(345),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(345),
    [sym__bare_map_lit] = STATE(403),
    [sym_vec_lit] = STATE(345),
    [sym__bare_vec_lit] = STATE(423),
    [sym_set_lit] = STATE(345),
    [sym__bare_set_lit] = STATE(374),
    [sym_anon_fn_lit] = STATE(345),
    [sym_regex_lit] = STATE(345),
    [sym_read_cond_lit] = STATE(345),
    [sym_splicing_read_cond_lit] = STATE(345),
    [sym_ns_map_lit] = STATE(345),
    [sym_var_quoting_lit] = STATE(345),
    [sym_sym_val_lit] = STATE(345),
    [sym_evaling_lit] = STATE(345),
    [sym_tagged_or_ctor_lit] = STATE(345),
    [sym_derefing_lit] = STATE(345),
    [sym_quoting_lit] = STATE(345),
    [sym_syn_quoting_lit] = STATE(345),
    [sym_unquote_splicing_lit] = STATE(345),
    [sym_unquoting_lit] = STATE(345),
    [aux_sym_dis_expr_repeat1] = STATE(21),
    [aux_sym_sym_lit_repeat1] = STATE(304),
    [sym__ws] = ACTIONS(496),
    [sym_comment] = ACTIONS(496),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(498),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(270),
    [anon_sym_COLON_COLON] = ACTIONS(272),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(498),
    [sym_nil_lit] = ACTIONS(500),
    [sym_bool_lit] = ACTIONS(500),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(286),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(292),
    [anon_sym_POUND_POUND] = ACTIONS(294),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(298),
    [anon_sym_SQUOTE] = ACTIONS(300),
    [anon_sym_BQUOTE] = ACTIONS(302),
    [anon_sym_TILDE_AT] = ACTIONS(304),
    [anon_sym_TILDE] = ACTIONS(306),
  },
  [55] = {
    [sym__gap] = STATE(43),
    [sym_dis_expr] = STATE(43),
    [sym__form] = STATE(371),
    [sym_kwd_lit] = STATE(371),
    [sym_str_lit] = STATE(371),
    [sym_sym_lit] = STATE(371),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(371),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(371),
    [sym__bare_map_lit] = STATE(403),
    [sym_vec_lit] = STATE(371),
    [sym__bare_vec_lit] = STATE(423),
    [sym_set_lit] = STATE(371),
    [sym__bare_set_lit] = STATE(374),
    [sym_anon_fn_lit] = STATE(371),
    [sym_regex_lit] = STATE(371),
    [sym_read_cond_lit] = STATE(371),
    [sym_splicing_read_cond_lit] = STATE(371),
    [sym_ns_map_lit] = STATE(371),
    [sym_var_quoting_lit] = STATE(371),
    [sym_sym_val_lit] = STATE(371),
    [sym_evaling_lit] = STATE(371),
    [sym_tagged_or_ctor_lit] = STATE(371),
    [sym_derefing_lit] = STATE(371),
    [sym_quoting_lit] = STATE(371),
    [sym_syn_quoting_lit] = STATE(371),
    [sym_unquote_splicing_lit] = STATE(371),
    [sym_unquoting_lit] = STATE(371),
    [aux_sym_dis_expr_repeat1] = STATE(43),
    [aux_sym_sym_lit_repeat1] = STATE(307),
    [sym__ws] = ACTIONS(502),
    [sym_comment] = ACTIONS(502),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(504),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(352),
    [anon_sym_COLON_COLON] = ACTIONS(354),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(504),
    [sym_nil_lit] = ACTIONS(506),
    [sym_bool_lit] = ACTIONS(506),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(358),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(360),
    [anon_sym_POUND_POUND] = ACTIONS(362),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(364),
    [anon_sym_SQUOTE] = ACTIONS(366),
    [anon_sym_BQUOTE] = ACTIONS(368),
    [anon_sym_TILDE_AT] = ACTIONS(370),
    [anon_sym_TILDE] = ACTIONS(372),
  },
  [56] = {
    [sym__gap] = STATE(45),
    [sym_dis_expr] = STATE(45),
    [sym__form] = STATE(370),
    [sym_kwd_lit] = STATE(370),
    [sym_str_lit] = STATE(370),
    [sym_sym_lit] = STATE(370),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(370),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(370),
    [sym__bare_map_lit] = STATE(403),
    [sym_vec_lit] = STATE(370),
    [sym__bare_vec_lit] = STATE(423),
    [sym_set_lit] = STATE(370),
    [sym__bare_set_lit] = STATE(374),
    [sym_anon_fn_lit] = STATE(370),
    [sym_regex_lit] = STATE(370),
    [sym_read_cond_lit] = STATE(370),
    [sym_splicing_read_cond_lit] = STATE(370),
    [sym_ns_map_lit] = STATE(370),
    [sym_var_quoting_lit] = STATE(370),
    [sym_sym_val_lit] = STATE(370),
    [sym_evaling_lit] = STATE(370),
    [sym_tagged_or_ctor_lit] = STATE(370),
    [sym_derefing_lit] = STATE(370),
    [sym_quoting_lit] = STATE(370),
    [sym_syn_quoting_lit] = STATE(370),
    [sym_unquote_splicing_lit] = STATE(370),
    [sym_unquoting_lit] = STATE(370),
    [aux_sym_dis_expr_repeat1] = STATE(45),
    [aux_sym_sym_lit_repeat1] = STATE(307),
    [sym__ws] = ACTIONS(508),
    [sym_comment] = ACTIONS(508),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(510),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(352),
    [anon_sym_COLON_COLON] = ACTIONS(354),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(510),
    [sym_nil_lit] = ACTIONS(512),
    [sym_bool_lit] = ACTIONS(512),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(358),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(360),
    [anon_sym_POUND_POUND] = ACTIONS(362),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(364),
    [anon_sym_SQUOTE] = ACTIONS(366),
    [anon_sym_BQUOTE] = ACTIONS(368),
    [anon_sym_TILDE_AT] = ACTIONS(370),
    [anon_sym_TILDE] = ACTIONS(372),
  },
  [57] = {
    [sym__gap] = STATE(47),
    [sym_dis_expr] = STATE(47),
    [sym__form] = STATE(367),
    [sym_kwd_lit] = STATE(367),
    [sym_str_lit] = STATE(367),
    [sym_sym_lit] = STATE(367),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(367),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(367),
    [sym__bare_map_lit] = STATE(403),
    [sym_vec_lit] = STATE(367),
    [sym__bare_vec_lit] = STATE(423),
    [sym_set_lit] = STATE(367),
    [sym__bare_set_lit] = STATE(374),
    [sym_anon_fn_lit] = STATE(367),
    [sym_regex_lit] = STATE(367),
    [sym_read_cond_lit] = STATE(367),
    [sym_splicing_read_cond_lit] = STATE(367),
    [sym_ns_map_lit] = STATE(367),
    [sym_var_quoting_lit] = STATE(367),
    [sym_sym_val_lit] = STATE(367),
    [sym_evaling_lit] = STATE(367),
    [sym_tagged_or_ctor_lit] = STATE(367),
    [sym_derefing_lit] = STATE(367),
    [sym_quoting_lit] = STATE(367),
    [sym_syn_quoting_lit] = STATE(367),
    [sym_unquote_splicing_lit] = STATE(367),
    [sym_unquoting_lit] = STATE(367),
    [aux_sym_dis_expr_repeat1] = STATE(47),
    [aux_sym_sym_lit_repeat1] = STATE(307),
    [sym__ws] = ACTIONS(514),
    [sym_comment] = ACTIONS(514),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(516),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(352),
    [anon_sym_COLON_COLON] = ACTIONS(354),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(516),
    [sym_nil_lit] = ACTIONS(518),
    [sym_bool_lit] = ACTIONS(518),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(358),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(360),
    [anon_sym_POUND_POUND] = ACTIONS(362),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(364),
    [anon_sym_SQUOTE] = ACTIONS(366),
    [anon_sym_BQUOTE] = ACTIONS(368),
    [anon_sym_TILDE_AT] = ACTIONS(370),
    [anon_sym_TILDE] = ACTIONS(372),
  },
  [58] = {
    [sym__gap] = STATE(48),
    [sym_dis_expr] = STATE(48),
    [sym__form] = STATE(366),
    [sym_kwd_lit] = STATE(366),
    [sym_str_lit] = STATE(366),
    [sym_sym_lit] = STATE(366),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(366),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(366),
    [sym__bare_map_lit] = STATE(403),
    [sym_vec_lit] = STATE(366),
    [sym__bare_vec_lit] = STATE(423),
    [sym_set_lit] = STATE(366),
    [sym__bare_set_lit] = STATE(374),
    [sym_anon_fn_lit] = STATE(366),
    [sym_regex_lit] = STATE(366),
    [sym_read_cond_lit] = STATE(366),
    [sym_splicing_read_cond_lit] = STATE(366),
    [sym_ns_map_lit] = STATE(366),
    [sym_var_quoting_lit] = STATE(366),
    [sym_sym_val_lit] = STATE(366),
    [sym_evaling_lit] = STATE(366),
    [sym_tagged_or_ctor_lit] = STATE(366),
    [sym_derefing_lit] = STATE(366),
    [sym_quoting_lit] = STATE(366),
    [sym_syn_quoting_lit] = STATE(366),
    [sym_unquote_splicing_lit] = STATE(366),
    [sym_unquoting_lit] = STATE(366),
    [aux_sym_dis_expr_repeat1] = STATE(48),
    [aux_sym_sym_lit_repeat1] = STATE(307),
    [sym__ws] = ACTIONS(520),
    [sym_comment] = ACTIONS(520),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(522),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(352),
    [anon_sym_COLON_COLON] = ACTIONS(354),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(522),
    [sym_nil_lit] = ACTIONS(524),
    [sym_bool_lit] = ACTIONS(524),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(358),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(360),
    [anon_sym_POUND_POUND] = ACTIONS(362),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(364),
    [anon_sym_SQUOTE] = ACTIONS(366),
    [anon_sym_BQUOTE] = ACTIONS(368),
    [anon_sym_TILDE_AT] = ACTIONS(370),
    [anon_sym_TILDE] = ACTIONS(372),
  },
  [59] = {
    [sym__gap] = STATE(49),
    [sym_dis_expr] = STATE(49),
    [sym__form] = STATE(355),
    [sym_kwd_lit] = STATE(355),
    [sym_str_lit] = STATE(355),
    [sym_sym_lit] = STATE(355),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(355),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(355),
    [sym__bare_map_lit] = STATE(403),
    [sym_vec_lit] = STATE(355),
    [sym__bare_vec_lit] = STATE(423),
    [sym_set_lit] = STATE(355),
    [sym__bare_set_lit] = STATE(374),
    [sym_anon_fn_lit] = STATE(355),
    [sym_regex_lit] = STATE(355),
    [sym_read_cond_lit] = STATE(355),
    [sym_splicing_read_cond_lit] = STATE(355),
    [sym_ns_map_lit] = STATE(355),
    [sym_var_quoting_lit] = STATE(355),
    [sym_sym_val_lit] = STATE(355),
    [sym_evaling_lit] = STATE(355),
    [sym_tagged_or_ctor_lit] = STATE(355),
    [sym_derefing_lit] = STATE(355),
    [sym_quoting_lit] = STATE(355),
    [sym_syn_quoting_lit] = STATE(355),
    [sym_unquote_splicing_lit] = STATE(355),
    [sym_unquoting_lit] = STATE(355),
    [aux_sym_dis_expr_repeat1] = STATE(49),
    [aux_sym_sym_lit_repeat1] = STATE(307),
    [sym__ws] = ACTIONS(526),
    [sym_comment] = ACTIONS(526),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(528),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(352),
    [anon_sym_COLON_COLON] = ACTIONS(354),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(528),
    [sym_nil_lit] = ACTIONS(530),
    [sym_bool_lit] = ACTIONS(530),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(358),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(360),
    [anon_sym_POUND_POUND] = ACTIONS(362),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(364),
    [anon_sym_SQUOTE] = ACTIONS(366),
    [anon_sym_BQUOTE] = ACTIONS(368),
    [anon_sym_TILDE_AT] = ACTIONS(370),
    [anon_sym_TILDE] = ACTIONS(372),
  },
  [60] = {
    [sym__gap] = STATE(50),
    [sym_dis_expr] = STATE(50),
    [sym__form] = STATE(347),
    [sym_kwd_lit] = STATE(347),
    [sym_str_lit] = STATE(347),
    [sym_sym_lit] = STATE(347),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(347),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(347),
    [sym__bare_map_lit] = STATE(403),
    [sym_vec_lit] = STATE(347),
    [sym__bare_vec_lit] = STATE(423),
    [sym_set_lit] = STATE(347),
    [sym__bare_set_lit] = STATE(374),
    [sym_anon_fn_lit] = STATE(347),
    [sym_regex_lit] = STATE(347),
    [sym_read_cond_lit] = STATE(347),
    [sym_splicing_read_cond_lit] = STATE(347),
    [sym_ns_map_lit] = STATE(347),
    [sym_var_quoting_lit] = STATE(347),
    [sym_sym_val_lit] = STATE(347),
    [sym_evaling_lit] = STATE(347),
    [sym_tagged_or_ctor_lit] = STATE(347),
    [sym_derefing_lit] = STATE(347),
    [sym_quoting_lit] = STATE(347),
    [sym_syn_quoting_lit] = STATE(347),
    [sym_unquote_splicing_lit] = STATE(347),
    [sym_unquoting_lit] = STATE(347),
    [aux_sym_dis_expr_repeat1] = STATE(50),
    [aux_sym_sym_lit_repeat1] = STATE(307),
    [sym__ws] = ACTIONS(532),
    [sym_comment] = ACTIONS(532),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(316),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(352),
    [anon_sym_COLON_COLON] = ACTIONS(354),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(316),
    [sym_nil_lit] = ACTIONS(318),
    [sym_bool_lit] = ACTIONS(318),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(358),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(360),
    [anon_sym_POUND_POUND] = ACTIONS(362),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(364),
    [anon_sym_SQUOTE] = ACTIONS(366),
    [anon_sym_BQUOTE] = ACTIONS(368),
    [anon_sym_TILDE_AT] = ACTIONS(370),
    [anon_sym_TILDE] = ACTIONS(372),
  },
  [61] = {
    [sym__gap] = STATE(51),
    [sym_dis_expr] = STATE(51),
    [sym__form] = STATE(345),
    [sym_kwd_lit] = STATE(345),
    [sym_str_lit] = STATE(345),
    [sym_sym_lit] = STATE(345),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(345),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(345),
    [sym__bare_map_lit] = STATE(403),
    [sym_vec_lit] = STATE(345),
    [sym__bare_vec_lit] = STATE(423),
    [sym_set_lit] = STATE(345),
    [sym__bare_set_lit] = STATE(374),
    [sym_anon_fn_lit] = STATE(345),
    [sym_regex_lit] = STATE(345),
    [sym_read_cond_lit] = STATE(345),
    [sym_splicing_read_cond_lit] = STATE(345),
    [sym_ns_map_lit] = STATE(345),
    [sym_var_quoting_lit] = STATE(345),
    [sym_sym_val_lit] = STATE(345),
    [sym_evaling_lit] = STATE(345),
    [sym_tagged_or_ctor_lit] = STATE(345),
    [sym_derefing_lit] = STATE(345),
    [sym_quoting_lit] = STATE(345),
    [sym_syn_quoting_lit] = STATE(345),
    [sym_unquote_splicing_lit] = STATE(345),
    [sym_unquoting_lit] = STATE(345),
    [aux_sym_dis_expr_repeat1] = STATE(51),
    [aux_sym_sym_lit_repeat1] = STATE(307),
    [sym__ws] = ACTIONS(534),
    [sym_comment] = ACTIONS(534),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(498),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(352),
    [anon_sym_COLON_COLON] = ACTIONS(354),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(498),
    [sym_nil_lit] = ACTIONS(500),
    [sym_bool_lit] = ACTIONS(500),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(358),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(360),
    [anon_sym_POUND_POUND] = ACTIONS(362),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(364),
    [anon_sym_SQUOTE] = ACTIONS(366),
    [anon_sym_BQUOTE] = ACTIONS(368),
    [anon_sym_TILDE_AT] = ACTIONS(370),
    [anon_sym_TILDE] = ACTIONS(372),
  },
  [62] = {
    [sym__gap] = STATE(301),
    [sym_dis_expr] = STATE(301),
    [sym__form] = STATE(389),
    [sym_kwd_lit] = STATE(389),
    [sym_str_lit] = STATE(389),
    [sym_sym_lit] = STATE(389),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(389),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(389),
    [sym__bare_map_lit] = STATE(403),
    [sym_vec_lit] = STATE(389),
    [sym__bare_vec_lit] = STATE(423),
    [sym_set_lit] = STATE(389),
    [sym__bare_set_lit] = STATE(374),
    [sym_anon_fn_lit] = STATE(389),
    [sym_regex_lit] = STATE(389),
    [sym_read_cond_lit] = STATE(389),
    [sym_splicing_read_cond_lit] = STATE(389),
    [sym_ns_map_lit] = STATE(389),
    [sym_var_quoting_lit] = STATE(389),
    [sym_sym_val_lit] = STATE(389),
    [sym_evaling_lit] = STATE(389),
    [sym_tagged_or_ctor_lit] = STATE(389),
    [sym_derefing_lit] = STATE(389),
    [sym_quoting_lit] = STATE(389),
    [sym_syn_quoting_lit] = STATE(389),
    [sym_unquote_splicing_lit] = STATE(389),
    [sym_unquoting_lit] = STATE(389),
    [aux_sym_dis_expr_repeat1] = STATE(301),
    [aux_sym_sym_lit_repeat1] = STATE(307),
    [sym__ws] = ACTIONS(264),
    [sym_comment] = ACTIONS(264),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(378),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(352),
    [anon_sym_COLON_COLON] = ACTIONS(354),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(378),
    [sym_nil_lit] = ACTIONS(380),
    [sym_bool_lit] = ACTIONS(380),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(358),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(360),
    [anon_sym_POUND_POUND] = ACTIONS(362),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(364),
    [anon_sym_SQUOTE] = ACTIONS(366),
    [anon_sym_BQUOTE] = ACTIONS(368),
    [anon_sym_TILDE_AT] = ACTIONS(370),
    [anon_sym_TILDE] = ACTIONS(372),
  },
  [63] = {
    [sym__gap] = STATE(301),
    [sym_dis_expr] = STATE(301),
    [sym__form] = STATE(270),
    [sym_kwd_lit] = STATE(270),
    [sym_str_lit] = STATE(270),
    [sym_sym_lit] = STATE(270),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(270),
    [sym__bare_list_lit] = STATE(218),
    [sym_map_lit] = STATE(270),
    [sym__bare_map_lit] = STATE(219),
    [sym_vec_lit] = STATE(270),
    [sym__bare_vec_lit] = STATE(226),
    [sym_set_lit] = STATE(270),
    [sym__bare_set_lit] = STATE(227),
    [sym_anon_fn_lit] = STATE(270),
    [sym_regex_lit] = STATE(270),
    [sym_read_cond_lit] = STATE(270),
    [sym_splicing_read_cond_lit] = STATE(270),
    [sym_ns_map_lit] = STATE(270),
    [sym_var_quoting_lit] = STATE(270),
    [sym_sym_val_lit] = STATE(270),
    [sym_evaling_lit] = STATE(270),
    [sym_tagged_or_ctor_lit] = STATE(270),
    [sym_derefing_lit] = STATE(270),
    [sym_quoting_lit] = STATE(270),
    [sym_syn_quoting_lit] = STATE(270),
    [sym_unquote_splicing_lit] = STATE(270),
    [sym_unquoting_lit] = STATE(270),
    [aux_sym_dis_expr_repeat1] = STATE(301),
    [aux_sym_sym_lit_repeat1] = STATE(305),
    [sym__ws] = ACTIONS(264),
    [sym_comment] = ACTIONS(264),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(536),
    [anon_sym_SLASH] = ACTIONS(9),
    [anon_sym_COLON] = ACTIONS(11),
    [anon_sym_COLON_COLON] = ACTIONS(13),
    [aux_sym_str_lit_token1] = ACTIONS(15),
    [sym_char_lit] = ACTIONS(536),
    [sym_nil_lit] = ACTIONS(538),
    [sym_bool_lit] = ACTIONS(538),
    [aux_sym__sym_qualified_token1] = ACTIONS(19),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_POUND] = ACTIONS(31),
    [anon_sym_POUND_QMARK] = ACTIONS(33),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(35),
    [anon_sym_POUND_SQUOTE] = ACTIONS(37),
    [anon_sym_POUND_POUND] = ACTIONS(39),
    [anon_sym_POUND_EQ] = ACTIONS(41),
    [anon_sym_AT] = ACTIONS(43),
    [anon_sym_SQUOTE] = ACTIONS(45),
    [anon_sym_BQUOTE] = ACTIONS(47),
    [anon_sym_TILDE_AT] = ACTIONS(49),
    [anon_sym_TILDE] = ACTIONS(51),
  },
  [64] = {
    [sym__gap] = STATE(301),
    [sym_dis_expr] = STATE(301),
    [sym__form] = STATE(399),
    [sym_kwd_lit] = STATE(399),
    [sym_str_lit] = STATE(399),
    [sym_sym_lit] = STATE(399),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(399),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(399),
    [sym__bare_map_lit] = STATE(403),
    [sym_vec_lit] = STATE(399),
    [sym__bare_vec_lit] = STATE(423),
    [sym_set_lit] = STATE(399),
    [sym__bare_set_lit] = STATE(374),
    [sym_anon_fn_lit] = STATE(399),
    [sym_regex_lit] = STATE(399),
    [sym_read_cond_lit] = STATE(399),
    [sym_splicing_read_cond_lit] = STATE(399),
    [sym_ns_map_lit] = STATE(399),
    [sym_var_quoting_lit] = STATE(399),
    [sym_sym_val_lit] = STATE(399),
    [sym_evaling_lit] = STATE(399),
    [sym_tagged_or_ctor_lit] = STATE(399),
    [sym_derefing_lit] = STATE(399),
    [sym_quoting_lit] = STATE(399),
    [sym_syn_quoting_lit] = STATE(399),
    [sym_unquote_splicing_lit] = STATE(399),
    [sym_unquoting_lit] = STATE(399),
    [aux_sym_dis_expr_repeat1] = STATE(301),
    [aux_sym_sym_lit_repeat1] = STATE(307),
    [sym__ws] = ACTIONS(264),
    [sym_comment] = ACTIONS(264),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(462),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(352),
    [anon_sym_COLON_COLON] = ACTIONS(354),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(462),
    [sym_nil_lit] = ACTIONS(464),
    [sym_bool_lit] = ACTIONS(464),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(358),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(360),
    [anon_sym_POUND_POUND] = ACTIONS(362),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(364),
    [anon_sym_SQUOTE] = ACTIONS(366),
    [anon_sym_BQUOTE] = ACTIONS(368),
    [anon_sym_TILDE_AT] = ACTIONS(370),
    [anon_sym_TILDE] = ACTIONS(372),
  },
  [65] = {
    [sym__gap] = STATE(301),
    [sym_dis_expr] = STATE(301),
    [sym__form] = STATE(271),
    [sym_kwd_lit] = STATE(271),
    [sym_str_lit] = STATE(271),
    [sym_sym_lit] = STATE(271),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(271),
    [sym__bare_list_lit] = STATE(218),
    [sym_map_lit] = STATE(271),
    [sym__bare_map_lit] = STATE(219),
    [sym_vec_lit] = STATE(271),
    [sym__bare_vec_lit] = STATE(226),
    [sym_set_lit] = STATE(271),
    [sym__bare_set_lit] = STATE(227),
    [sym_anon_fn_lit] = STATE(271),
    [sym_regex_lit] = STATE(271),
    [sym_read_cond_lit] = STATE(271),
    [sym_splicing_read_cond_lit] = STATE(271),
    [sym_ns_map_lit] = STATE(271),
    [sym_var_quoting_lit] = STATE(271),
    [sym_sym_val_lit] = STATE(271),
    [sym_evaling_lit] = STATE(271),
    [sym_tagged_or_ctor_lit] = STATE(271),
    [sym_derefing_lit] = STATE(271),
    [sym_quoting_lit] = STATE(271),
    [sym_syn_quoting_lit] = STATE(271),
    [sym_unquote_splicing_lit] = STATE(271),
    [sym_unquoting_lit] = STATE(271),
    [aux_sym_dis_expr_repeat1] = STATE(301),
    [aux_sym_sym_lit_repeat1] = STATE(305),
    [sym__ws] = ACTIONS(264),
    [sym_comment] = ACTIONS(264),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(540),
    [anon_sym_SLASH] = ACTIONS(9),
    [anon_sym_COLON] = ACTIONS(11),
    [anon_sym_COLON_COLON] = ACTIONS(13),
    [aux_sym_str_lit_token1] = ACTIONS(15),
    [sym_char_lit] = ACTIONS(540),
    [sym_nil_lit] = ACTIONS(542),
    [sym_bool_lit] = ACTIONS(542),
    [aux_sym__sym_qualified_token1] = ACTIONS(19),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_POUND] = ACTIONS(31),
    [anon_sym_POUND_QMARK] = ACTIONS(33),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(35),
    [anon_sym_POUND_SQUOTE] = ACTIONS(37),
    [anon_sym_POUND_POUND] = ACTIONS(39),
    [anon_sym_POUND_EQ] = ACTIONS(41),
    [anon_sym_AT] = ACTIONS(43),
    [anon_sym_SQUOTE] = ACTIONS(45),
    [anon_sym_BQUOTE] = ACTIONS(47),
    [anon_sym_TILDE_AT] = ACTIONS(49),
    [anon_sym_TILDE] = ACTIONS(51),
  },
  [66] = {
    [sym__gap] = STATE(62),
    [sym_dis_expr] = STATE(62),
    [sym__form] = STATE(363),
    [sym_kwd_lit] = STATE(363),
    [sym_str_lit] = STATE(363),
    [sym_sym_lit] = STATE(363),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(363),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(363),
    [sym__bare_map_lit] = STATE(403),
    [sym_vec_lit] = STATE(363),
    [sym__bare_vec_lit] = STATE(423),
    [sym_set_lit] = STATE(363),
    [sym__bare_set_lit] = STATE(374),
    [sym_anon_fn_lit] = STATE(363),
    [sym_regex_lit] = STATE(363),
    [sym_read_cond_lit] = STATE(363),
    [sym_splicing_read_cond_lit] = STATE(363),
    [sym_ns_map_lit] = STATE(363),
    [sym_var_quoting_lit] = STATE(363),
    [sym_sym_val_lit] = STATE(363),
    [sym_evaling_lit] = STATE(363),
    [sym_tagged_or_ctor_lit] = STATE(363),
    [sym_derefing_lit] = STATE(363),
    [sym_quoting_lit] = STATE(363),
    [sym_syn_quoting_lit] = STATE(363),
    [sym_unquote_splicing_lit] = STATE(363),
    [sym_unquoting_lit] = STATE(363),
    [aux_sym_dis_expr_repeat1] = STATE(62),
    [aux_sym_sym_lit_repeat1] = STATE(307),
    [sym__ws] = ACTIONS(544),
    [sym_comment] = ACTIONS(544),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(546),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(352),
    [anon_sym_COLON_COLON] = ACTIONS(354),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(546),
    [sym_nil_lit] = ACTIONS(548),
    [sym_bool_lit] = ACTIONS(548),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(358),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(360),
    [anon_sym_POUND_POUND] = ACTIONS(362),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(364),
    [anon_sym_SQUOTE] = ACTIONS(366),
    [anon_sym_BQUOTE] = ACTIONS(368),
    [anon_sym_TILDE_AT] = ACTIONS(370),
    [anon_sym_TILDE] = ACTIONS(372),
  },
  [67] = {
    [sym__gap] = STATE(64),
    [sym_dis_expr] = STATE(64),
    [sym__form] = STATE(361),
    [sym_kwd_lit] = STATE(361),
    [sym_str_lit] = STATE(361),
    [sym_sym_lit] = STATE(361),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(361),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(361),
    [sym__bare_map_lit] = STATE(403),
    [sym_vec_lit] = STATE(361),
    [sym__bare_vec_lit] = STATE(423),
    [sym_set_lit] = STATE(361),
    [sym__bare_set_lit] = STATE(374),
    [sym_anon_fn_lit] = STATE(361),
    [sym_regex_lit] = STATE(361),
    [sym_read_cond_lit] = STATE(361),
    [sym_splicing_read_cond_lit] = STATE(361),
    [sym_ns_map_lit] = STATE(361),
    [sym_var_quoting_lit] = STATE(361),
    [sym_sym_val_lit] = STATE(361),
    [sym_evaling_lit] = STATE(361),
    [sym_tagged_or_ctor_lit] = STATE(361),
    [sym_derefing_lit] = STATE(361),
    [sym_quoting_lit] = STATE(361),
    [sym_syn_quoting_lit] = STATE(361),
    [sym_unquote_splicing_lit] = STATE(361),
    [sym_unquoting_lit] = STATE(361),
    [aux_sym_dis_expr_repeat1] = STATE(64),
    [aux_sym_sym_lit_repeat1] = STATE(307),
    [sym__ws] = ACTIONS(550),
    [sym_comment] = ACTIONS(550),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(552),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(352),
    [anon_sym_COLON_COLON] = ACTIONS(354),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(552),
    [sym_nil_lit] = ACTIONS(554),
    [sym_bool_lit] = ACTIONS(554),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(358),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(360),
    [anon_sym_POUND_POUND] = ACTIONS(362),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(364),
    [anon_sym_SQUOTE] = ACTIONS(366),
    [anon_sym_BQUOTE] = ACTIONS(368),
    [anon_sym_TILDE_AT] = ACTIONS(370),
    [anon_sym_TILDE] = ACTIONS(372),
  },
  [68] = {
    [sym__gap] = STATE(108),
    [sym_dis_expr] = STATE(108),
    [sym__form] = STATE(333),
    [sym_kwd_lit] = STATE(333),
    [sym_str_lit] = STATE(333),
    [sym_sym_lit] = STATE(333),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(333),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(333),
    [sym__bare_map_lit] = STATE(403),
    [sym_vec_lit] = STATE(333),
    [sym__bare_vec_lit] = STATE(423),
    [sym_set_lit] = STATE(333),
    [sym__bare_set_lit] = STATE(374),
    [sym_anon_fn_lit] = STATE(333),
    [sym_regex_lit] = STATE(333),
    [sym_read_cond_lit] = STATE(333),
    [sym_splicing_read_cond_lit] = STATE(333),
    [sym_ns_map_lit] = STATE(333),
    [sym_var_quoting_lit] = STATE(333),
    [sym_sym_val_lit] = STATE(333),
    [sym_evaling_lit] = STATE(333),
    [sym_tagged_or_ctor_lit] = STATE(333),
    [sym_derefing_lit] = STATE(333),
    [sym_quoting_lit] = STATE(333),
    [sym_syn_quoting_lit] = STATE(333),
    [sym_unquote_splicing_lit] = STATE(333),
    [sym_unquoting_lit] = STATE(333),
    [aux_sym_dis_expr_repeat1] = STATE(108),
    [aux_sym_sym_lit_repeat1] = STATE(307),
    [sym__ws] = ACTIONS(556),
    [sym_comment] = ACTIONS(556),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(558),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(352),
    [anon_sym_COLON_COLON] = ACTIONS(354),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(558),
    [sym_nil_lit] = ACTIONS(560),
    [sym_bool_lit] = ACTIONS(560),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(358),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(360),
    [anon_sym_POUND_POUND] = ACTIONS(362),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(364),
    [anon_sym_SQUOTE] = ACTIONS(366),
    [anon_sym_BQUOTE] = ACTIONS(368),
    [anon_sym_TILDE_AT] = ACTIONS(370),
    [anon_sym_TILDE] = ACTIONS(372),
  },
  [69] = {
    [sym__gap] = STATE(301),
    [sym_dis_expr] = STATE(301),
    [sym__form] = STATE(332),
    [sym_kwd_lit] = STATE(332),
    [sym_str_lit] = STATE(332),
    [sym_sym_lit] = STATE(332),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(332),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(332),
    [sym__bare_map_lit] = STATE(403),
    [sym_vec_lit] = STATE(332),
    [sym__bare_vec_lit] = STATE(423),
    [sym_set_lit] = STATE(332),
    [sym__bare_set_lit] = STATE(374),
    [sym_anon_fn_lit] = STATE(332),
    [sym_regex_lit] = STATE(332),
    [sym_read_cond_lit] = STATE(332),
    [sym_splicing_read_cond_lit] = STATE(332),
    [sym_ns_map_lit] = STATE(332),
    [sym_var_quoting_lit] = STATE(332),
    [sym_sym_val_lit] = STATE(332),
    [sym_evaling_lit] = STATE(332),
    [sym_tagged_or_ctor_lit] = STATE(332),
    [sym_derefing_lit] = STATE(332),
    [sym_quoting_lit] = STATE(332),
    [sym_syn_quoting_lit] = STATE(332),
    [sym_unquote_splicing_lit] = STATE(332),
    [sym_unquoting_lit] = STATE(332),
    [aux_sym_dis_expr_repeat1] = STATE(301),
    [aux_sym_sym_lit_repeat1] = STATE(304),
    [sym__ws] = ACTIONS(264),
    [sym_comment] = ACTIONS(264),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(562),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(270),
    [anon_sym_COLON_COLON] = ACTIONS(272),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(562),
    [sym_nil_lit] = ACTIONS(564),
    [sym_bool_lit] = ACTIONS(564),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(286),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(292),
    [anon_sym_POUND_POUND] = ACTIONS(294),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(298),
    [anon_sym_SQUOTE] = ACTIONS(300),
    [anon_sym_BQUOTE] = ACTIONS(302),
    [anon_sym_TILDE_AT] = ACTIONS(304),
    [anon_sym_TILDE] = ACTIONS(306),
  },
  [70] = {
    [sym__gap] = STATE(301),
    [sym_dis_expr] = STATE(301),
    [sym__form] = STATE(275),
    [sym_kwd_lit] = STATE(275),
    [sym_str_lit] = STATE(275),
    [sym_sym_lit] = STATE(275),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(275),
    [sym__bare_list_lit] = STATE(218),
    [sym_map_lit] = STATE(275),
    [sym__bare_map_lit] = STATE(219),
    [sym_vec_lit] = STATE(275),
    [sym__bare_vec_lit] = STATE(226),
    [sym_set_lit] = STATE(275),
    [sym__bare_set_lit] = STATE(227),
    [sym_anon_fn_lit] = STATE(275),
    [sym_regex_lit] = STATE(275),
    [sym_read_cond_lit] = STATE(275),
    [sym_splicing_read_cond_lit] = STATE(275),
    [sym_ns_map_lit] = STATE(275),
    [sym_var_quoting_lit] = STATE(275),
    [sym_sym_val_lit] = STATE(275),
    [sym_evaling_lit] = STATE(275),
    [sym_tagged_or_ctor_lit] = STATE(275),
    [sym_derefing_lit] = STATE(275),
    [sym_quoting_lit] = STATE(275),
    [sym_syn_quoting_lit] = STATE(275),
    [sym_unquote_splicing_lit] = STATE(275),
    [sym_unquoting_lit] = STATE(275),
    [aux_sym_dis_expr_repeat1] = STATE(301),
    [aux_sym_sym_lit_repeat1] = STATE(305),
    [sym__ws] = ACTIONS(264),
    [sym_comment] = ACTIONS(264),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(566),
    [anon_sym_SLASH] = ACTIONS(9),
    [anon_sym_COLON] = ACTIONS(11),
    [anon_sym_COLON_COLON] = ACTIONS(13),
    [aux_sym_str_lit_token1] = ACTIONS(15),
    [sym_char_lit] = ACTIONS(566),
    [sym_nil_lit] = ACTIONS(568),
    [sym_bool_lit] = ACTIONS(568),
    [aux_sym__sym_qualified_token1] = ACTIONS(19),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_POUND] = ACTIONS(31),
    [anon_sym_POUND_QMARK] = ACTIONS(33),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(35),
    [anon_sym_POUND_SQUOTE] = ACTIONS(37),
    [anon_sym_POUND_POUND] = ACTIONS(39),
    [anon_sym_POUND_EQ] = ACTIONS(41),
    [anon_sym_AT] = ACTIONS(43),
    [anon_sym_SQUOTE] = ACTIONS(45),
    [anon_sym_BQUOTE] = ACTIONS(47),
    [anon_sym_TILDE_AT] = ACTIONS(49),
    [anon_sym_TILDE] = ACTIONS(51),
  },
  [71] = {
    [sym__gap] = STATE(69),
    [sym_dis_expr] = STATE(69),
    [sym__form] = STATE(331),
    [sym_kwd_lit] = STATE(331),
    [sym_str_lit] = STATE(331),
    [sym_sym_lit] = STATE(331),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(331),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(331),
    [sym__bare_map_lit] = STATE(403),
    [sym_vec_lit] = STATE(331),
    [sym__bare_vec_lit] = STATE(423),
    [sym_set_lit] = STATE(331),
    [sym__bare_set_lit] = STATE(374),
    [sym_anon_fn_lit] = STATE(331),
    [sym_regex_lit] = STATE(331),
    [sym_read_cond_lit] = STATE(331),
    [sym_splicing_read_cond_lit] = STATE(331),
    [sym_ns_map_lit] = STATE(331),
    [sym_var_quoting_lit] = STATE(331),
    [sym_sym_val_lit] = STATE(331),
    [sym_evaling_lit] = STATE(331),
    [sym_tagged_or_ctor_lit] = STATE(331),
    [sym_derefing_lit] = STATE(331),
    [sym_quoting_lit] = STATE(331),
    [sym_syn_quoting_lit] = STATE(331),
    [sym_unquote_splicing_lit] = STATE(331),
    [sym_unquoting_lit] = STATE(331),
    [aux_sym_dis_expr_repeat1] = STATE(69),
    [aux_sym_sym_lit_repeat1] = STATE(304),
    [sym__ws] = ACTIONS(570),
    [sym_comment] = ACTIONS(570),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(572),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(270),
    [anon_sym_COLON_COLON] = ACTIONS(272),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(572),
    [sym_nil_lit] = ACTIONS(574),
    [sym_bool_lit] = ACTIONS(574),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(286),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(292),
    [anon_sym_POUND_POUND] = ACTIONS(294),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(298),
    [anon_sym_SQUOTE] = ACTIONS(300),
    [anon_sym_BQUOTE] = ACTIONS(302),
    [anon_sym_TILDE_AT] = ACTIONS(304),
    [anon_sym_TILDE] = ACTIONS(306),
  },
  [72] = {
    [sym__gap] = STATE(301),
    [sym_dis_expr] = STATE(301),
    [sym__form] = STATE(276),
    [sym_kwd_lit] = STATE(276),
    [sym_str_lit] = STATE(276),
    [sym_sym_lit] = STATE(276),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(276),
    [sym__bare_list_lit] = STATE(218),
    [sym_map_lit] = STATE(276),
    [sym__bare_map_lit] = STATE(219),
    [sym_vec_lit] = STATE(276),
    [sym__bare_vec_lit] = STATE(226),
    [sym_set_lit] = STATE(276),
    [sym__bare_set_lit] = STATE(227),
    [sym_anon_fn_lit] = STATE(276),
    [sym_regex_lit] = STATE(276),
    [sym_read_cond_lit] = STATE(276),
    [sym_splicing_read_cond_lit] = STATE(276),
    [sym_ns_map_lit] = STATE(276),
    [sym_var_quoting_lit] = STATE(276),
    [sym_sym_val_lit] = STATE(276),
    [sym_evaling_lit] = STATE(276),
    [sym_tagged_or_ctor_lit] = STATE(276),
    [sym_derefing_lit] = STATE(276),
    [sym_quoting_lit] = STATE(276),
    [sym_syn_quoting_lit] = STATE(276),
    [sym_unquote_splicing_lit] = STATE(276),
    [sym_unquoting_lit] = STATE(276),
    [aux_sym_dis_expr_repeat1] = STATE(301),
    [aux_sym_sym_lit_repeat1] = STATE(305),
    [sym__ws] = ACTIONS(264),
    [sym_comment] = ACTIONS(264),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(576),
    [anon_sym_SLASH] = ACTIONS(9),
    [anon_sym_COLON] = ACTIONS(11),
    [anon_sym_COLON_COLON] = ACTIONS(13),
    [aux_sym_str_lit_token1] = ACTIONS(15),
    [sym_char_lit] = ACTIONS(576),
    [sym_nil_lit] = ACTIONS(578),
    [sym_bool_lit] = ACTIONS(578),
    [aux_sym__sym_qualified_token1] = ACTIONS(19),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_POUND] = ACTIONS(31),
    [anon_sym_POUND_QMARK] = ACTIONS(33),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(35),
    [anon_sym_POUND_SQUOTE] = ACTIONS(37),
    [anon_sym_POUND_POUND] = ACTIONS(39),
    [anon_sym_POUND_EQ] = ACTIONS(41),
    [anon_sym_AT] = ACTIONS(43),
    [anon_sym_SQUOTE] = ACTIONS(45),
    [anon_sym_BQUOTE] = ACTIONS(47),
    [anon_sym_TILDE_AT] = ACTIONS(49),
    [anon_sym_TILDE] = ACTIONS(51),
  },
  [73] = {
    [sym__gap] = STATE(301),
    [sym_dis_expr] = STATE(301),
    [sym__form] = STATE(329),
    [sym_kwd_lit] = STATE(329),
    [sym_str_lit] = STATE(329),
    [sym_sym_lit] = STATE(329),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(329),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(329),
    [sym__bare_map_lit] = STATE(403),
    [sym_vec_lit] = STATE(329),
    [sym__bare_vec_lit] = STATE(423),
    [sym_set_lit] = STATE(329),
    [sym__bare_set_lit] = STATE(374),
    [sym_anon_fn_lit] = STATE(329),
    [sym_regex_lit] = STATE(329),
    [sym_read_cond_lit] = STATE(329),
    [sym_splicing_read_cond_lit] = STATE(329),
    [sym_ns_map_lit] = STATE(329),
    [sym_var_quoting_lit] = STATE(329),
    [sym_sym_val_lit] = STATE(329),
    [sym_evaling_lit] = STATE(329),
    [sym_tagged_or_ctor_lit] = STATE(329),
    [sym_derefing_lit] = STATE(329),
    [sym_quoting_lit] = STATE(329),
    [sym_syn_quoting_lit] = STATE(329),
    [sym_unquote_splicing_lit] = STATE(329),
    [sym_unquoting_lit] = STATE(329),
    [aux_sym_dis_expr_repeat1] = STATE(301),
    [aux_sym_sym_lit_repeat1] = STATE(304),
    [sym__ws] = ACTIONS(264),
    [sym_comment] = ACTIONS(264),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(580),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(270),
    [anon_sym_COLON_COLON] = ACTIONS(272),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(580),
    [sym_nil_lit] = ACTIONS(582),
    [sym_bool_lit] = ACTIONS(582),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(286),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(292),
    [anon_sym_POUND_POUND] = ACTIONS(294),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(298),
    [anon_sym_SQUOTE] = ACTIONS(300),
    [anon_sym_BQUOTE] = ACTIONS(302),
    [anon_sym_TILDE_AT] = ACTIONS(304),
    [anon_sym_TILDE] = ACTIONS(306),
  },
  [74] = {
    [sym__gap] = STATE(301),
    [sym_dis_expr] = STATE(301),
    [sym__form] = STATE(214),
    [sym_kwd_lit] = STATE(214),
    [sym_str_lit] = STATE(214),
    [sym_sym_lit] = STATE(214),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(214),
    [sym__bare_list_lit] = STATE(218),
    [sym_map_lit] = STATE(214),
    [sym__bare_map_lit] = STATE(219),
    [sym_vec_lit] = STATE(214),
    [sym__bare_vec_lit] = STATE(226),
    [sym_set_lit] = STATE(214),
    [sym__bare_set_lit] = STATE(227),
    [sym_anon_fn_lit] = STATE(214),
    [sym_regex_lit] = STATE(214),
    [sym_read_cond_lit] = STATE(214),
    [sym_splicing_read_cond_lit] = STATE(214),
    [sym_ns_map_lit] = STATE(214),
    [sym_var_quoting_lit] = STATE(214),
    [sym_sym_val_lit] = STATE(214),
    [sym_evaling_lit] = STATE(214),
    [sym_tagged_or_ctor_lit] = STATE(214),
    [sym_derefing_lit] = STATE(214),
    [sym_quoting_lit] = STATE(214),
    [sym_syn_quoting_lit] = STATE(214),
    [sym_unquote_splicing_lit] = STATE(214),
    [sym_unquoting_lit] = STATE(214),
    [aux_sym_dis_expr_repeat1] = STATE(301),
    [aux_sym_sym_lit_repeat1] = STATE(305),
    [sym__ws] = ACTIONS(264),
    [sym_comment] = ACTIONS(264),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(584),
    [anon_sym_SLASH] = ACTIONS(9),
    [anon_sym_COLON] = ACTIONS(11),
    [anon_sym_COLON_COLON] = ACTIONS(13),
    [aux_sym_str_lit_token1] = ACTIONS(15),
    [sym_char_lit] = ACTIONS(584),
    [sym_nil_lit] = ACTIONS(586),
    [sym_bool_lit] = ACTIONS(586),
    [aux_sym__sym_qualified_token1] = ACTIONS(19),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_POUND] = ACTIONS(31),
    [anon_sym_POUND_QMARK] = ACTIONS(33),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(35),
    [anon_sym_POUND_SQUOTE] = ACTIONS(37),
    [anon_sym_POUND_POUND] = ACTIONS(39),
    [anon_sym_POUND_EQ] = ACTIONS(41),
    [anon_sym_AT] = ACTIONS(43),
    [anon_sym_SQUOTE] = ACTIONS(45),
    [anon_sym_BQUOTE] = ACTIONS(47),
    [anon_sym_TILDE_AT] = ACTIONS(49),
    [anon_sym_TILDE] = ACTIONS(51),
  },
  [75] = {
    [sym__gap] = STATE(301),
    [sym_dis_expr] = STATE(301),
    [sym__form] = STATE(327),
    [sym_kwd_lit] = STATE(327),
    [sym_str_lit] = STATE(327),
    [sym_sym_lit] = STATE(327),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(327),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(327),
    [sym__bare_map_lit] = STATE(403),
    [sym_vec_lit] = STATE(327),
    [sym__bare_vec_lit] = STATE(423),
    [sym_set_lit] = STATE(327),
    [sym__bare_set_lit] = STATE(374),
    [sym_anon_fn_lit] = STATE(327),
    [sym_regex_lit] = STATE(327),
    [sym_read_cond_lit] = STATE(327),
    [sym_splicing_read_cond_lit] = STATE(327),
    [sym_ns_map_lit] = STATE(327),
    [sym_var_quoting_lit] = STATE(327),
    [sym_sym_val_lit] = STATE(327),
    [sym_evaling_lit] = STATE(327),
    [sym_tagged_or_ctor_lit] = STATE(327),
    [sym_derefing_lit] = STATE(327),
    [sym_quoting_lit] = STATE(327),
    [sym_syn_quoting_lit] = STATE(327),
    [sym_unquote_splicing_lit] = STATE(327),
    [sym_unquoting_lit] = STATE(327),
    [aux_sym_dis_expr_repeat1] = STATE(301),
    [aux_sym_sym_lit_repeat1] = STATE(304),
    [sym__ws] = ACTIONS(264),
    [sym_comment] = ACTIONS(264),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(588),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(270),
    [anon_sym_COLON_COLON] = ACTIONS(272),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(588),
    [sym_nil_lit] = ACTIONS(590),
    [sym_bool_lit] = ACTIONS(590),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(286),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(292),
    [anon_sym_POUND_POUND] = ACTIONS(294),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(298),
    [anon_sym_SQUOTE] = ACTIONS(300),
    [anon_sym_BQUOTE] = ACTIONS(302),
    [anon_sym_TILDE_AT] = ACTIONS(304),
    [anon_sym_TILDE] = ACTIONS(306),
  },
  [76] = {
    [sym__gap] = STATE(301),
    [sym_dis_expr] = STATE(301),
    [sym__form] = STATE(277),
    [sym_kwd_lit] = STATE(277),
    [sym_str_lit] = STATE(277),
    [sym_sym_lit] = STATE(277),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(277),
    [sym__bare_list_lit] = STATE(218),
    [sym_map_lit] = STATE(277),
    [sym__bare_map_lit] = STATE(219),
    [sym_vec_lit] = STATE(277),
    [sym__bare_vec_lit] = STATE(226),
    [sym_set_lit] = STATE(277),
    [sym__bare_set_lit] = STATE(227),
    [sym_anon_fn_lit] = STATE(277),
    [sym_regex_lit] = STATE(277),
    [sym_read_cond_lit] = STATE(277),
    [sym_splicing_read_cond_lit] = STATE(277),
    [sym_ns_map_lit] = STATE(277),
    [sym_var_quoting_lit] = STATE(277),
    [sym_sym_val_lit] = STATE(277),
    [sym_evaling_lit] = STATE(277),
    [sym_tagged_or_ctor_lit] = STATE(277),
    [sym_derefing_lit] = STATE(277),
    [sym_quoting_lit] = STATE(277),
    [sym_syn_quoting_lit] = STATE(277),
    [sym_unquote_splicing_lit] = STATE(277),
    [sym_unquoting_lit] = STATE(277),
    [aux_sym_dis_expr_repeat1] = STATE(301),
    [aux_sym_sym_lit_repeat1] = STATE(305),
    [sym__ws] = ACTIONS(264),
    [sym_comment] = ACTIONS(264),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(592),
    [anon_sym_SLASH] = ACTIONS(9),
    [anon_sym_COLON] = ACTIONS(11),
    [anon_sym_COLON_COLON] = ACTIONS(13),
    [aux_sym_str_lit_token1] = ACTIONS(15),
    [sym_char_lit] = ACTIONS(592),
    [sym_nil_lit] = ACTIONS(594),
    [sym_bool_lit] = ACTIONS(594),
    [aux_sym__sym_qualified_token1] = ACTIONS(19),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_POUND] = ACTIONS(31),
    [anon_sym_POUND_QMARK] = ACTIONS(33),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(35),
    [anon_sym_POUND_SQUOTE] = ACTIONS(37),
    [anon_sym_POUND_POUND] = ACTIONS(39),
    [anon_sym_POUND_EQ] = ACTIONS(41),
    [anon_sym_AT] = ACTIONS(43),
    [anon_sym_SQUOTE] = ACTIONS(45),
    [anon_sym_BQUOTE] = ACTIONS(47),
    [anon_sym_TILDE_AT] = ACTIONS(49),
    [anon_sym_TILDE] = ACTIONS(51),
  },
  [77] = {
    [sym__gap] = STATE(301),
    [sym_dis_expr] = STATE(301),
    [sym__form] = STATE(411),
    [sym_kwd_lit] = STATE(411),
    [sym_str_lit] = STATE(411),
    [sym_sym_lit] = STATE(411),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(411),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(411),
    [sym__bare_map_lit] = STATE(403),
    [sym_vec_lit] = STATE(411),
    [sym__bare_vec_lit] = STATE(423),
    [sym_set_lit] = STATE(411),
    [sym__bare_set_lit] = STATE(374),
    [sym_anon_fn_lit] = STATE(411),
    [sym_regex_lit] = STATE(411),
    [sym_read_cond_lit] = STATE(411),
    [sym_splicing_read_cond_lit] = STATE(411),
    [sym_ns_map_lit] = STATE(411),
    [sym_var_quoting_lit] = STATE(411),
    [sym_sym_val_lit] = STATE(411),
    [sym_evaling_lit] = STATE(411),
    [sym_tagged_or_ctor_lit] = STATE(411),
    [sym_derefing_lit] = STATE(411),
    [sym_quoting_lit] = STATE(411),
    [sym_syn_quoting_lit] = STATE(411),
    [sym_unquote_splicing_lit] = STATE(411),
    [sym_unquoting_lit] = STATE(411),
    [aux_sym_dis_expr_repeat1] = STATE(301),
    [aux_sym_sym_lit_repeat1] = STATE(304),
    [sym__ws] = ACTIONS(264),
    [sym_comment] = ACTIONS(264),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(596),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(270),
    [anon_sym_COLON_COLON] = ACTIONS(272),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(596),
    [sym_nil_lit] = ACTIONS(598),
    [sym_bool_lit] = ACTIONS(598),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(286),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(292),
    [anon_sym_POUND_POUND] = ACTIONS(294),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(298),
    [anon_sym_SQUOTE] = ACTIONS(300),
    [anon_sym_BQUOTE] = ACTIONS(302),
    [anon_sym_TILDE_AT] = ACTIONS(304),
    [anon_sym_TILDE] = ACTIONS(306),
  },
  [78] = {
    [sym__gap] = STATE(301),
    [sym_dis_expr] = STATE(301),
    [sym__form] = STATE(278),
    [sym_kwd_lit] = STATE(278),
    [sym_str_lit] = STATE(278),
    [sym_sym_lit] = STATE(278),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(278),
    [sym__bare_list_lit] = STATE(218),
    [sym_map_lit] = STATE(278),
    [sym__bare_map_lit] = STATE(219),
    [sym_vec_lit] = STATE(278),
    [sym__bare_vec_lit] = STATE(226),
    [sym_set_lit] = STATE(278),
    [sym__bare_set_lit] = STATE(227),
    [sym_anon_fn_lit] = STATE(278),
    [sym_regex_lit] = STATE(278),
    [sym_read_cond_lit] = STATE(278),
    [sym_splicing_read_cond_lit] = STATE(278),
    [sym_ns_map_lit] = STATE(278),
    [sym_var_quoting_lit] = STATE(278),
    [sym_sym_val_lit] = STATE(278),
    [sym_evaling_lit] = STATE(278),
    [sym_tagged_or_ctor_lit] = STATE(278),
    [sym_derefing_lit] = STATE(278),
    [sym_quoting_lit] = STATE(278),
    [sym_syn_quoting_lit] = STATE(278),
    [sym_unquote_splicing_lit] = STATE(278),
    [sym_unquoting_lit] = STATE(278),
    [aux_sym_dis_expr_repeat1] = STATE(301),
    [aux_sym_sym_lit_repeat1] = STATE(305),
    [sym__ws] = ACTIONS(264),
    [sym_comment] = ACTIONS(264),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(600),
    [anon_sym_SLASH] = ACTIONS(9),
    [anon_sym_COLON] = ACTIONS(11),
    [anon_sym_COLON_COLON] = ACTIONS(13),
    [aux_sym_str_lit_token1] = ACTIONS(15),
    [sym_char_lit] = ACTIONS(600),
    [sym_nil_lit] = ACTIONS(602),
    [sym_bool_lit] = ACTIONS(602),
    [aux_sym__sym_qualified_token1] = ACTIONS(19),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_POUND] = ACTIONS(31),
    [anon_sym_POUND_QMARK] = ACTIONS(33),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(35),
    [anon_sym_POUND_SQUOTE] = ACTIONS(37),
    [anon_sym_POUND_POUND] = ACTIONS(39),
    [anon_sym_POUND_EQ] = ACTIONS(41),
    [anon_sym_AT] = ACTIONS(43),
    [anon_sym_SQUOTE] = ACTIONS(45),
    [anon_sym_BQUOTE] = ACTIONS(47),
    [anon_sym_TILDE_AT] = ACTIONS(49),
    [anon_sym_TILDE] = ACTIONS(51),
  },
  [79] = {
    [sym__gap] = STATE(301),
    [sym_dis_expr] = STATE(301),
    [sym__form] = STATE(385),
    [sym_kwd_lit] = STATE(385),
    [sym_str_lit] = STATE(385),
    [sym_sym_lit] = STATE(385),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(385),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(385),
    [sym__bare_map_lit] = STATE(403),
    [sym_vec_lit] = STATE(385),
    [sym__bare_vec_lit] = STATE(423),
    [sym_set_lit] = STATE(385),
    [sym__bare_set_lit] = STATE(374),
    [sym_anon_fn_lit] = STATE(385),
    [sym_regex_lit] = STATE(385),
    [sym_read_cond_lit] = STATE(385),
    [sym_splicing_read_cond_lit] = STATE(385),
    [sym_ns_map_lit] = STATE(385),
    [sym_var_quoting_lit] = STATE(385),
    [sym_sym_val_lit] = STATE(385),
    [sym_evaling_lit] = STATE(385),
    [sym_tagged_or_ctor_lit] = STATE(385),
    [sym_derefing_lit] = STATE(385),
    [sym_quoting_lit] = STATE(385),
    [sym_syn_quoting_lit] = STATE(385),
    [sym_unquote_splicing_lit] = STATE(385),
    [sym_unquoting_lit] = STATE(385),
    [aux_sym_dis_expr_repeat1] = STATE(301),
    [aux_sym_sym_lit_repeat1] = STATE(304),
    [sym__ws] = ACTIONS(264),
    [sym_comment] = ACTIONS(264),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(604),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(270),
    [anon_sym_COLON_COLON] = ACTIONS(272),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(604),
    [sym_nil_lit] = ACTIONS(606),
    [sym_bool_lit] = ACTIONS(606),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(286),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(292),
    [anon_sym_POUND_POUND] = ACTIONS(294),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(298),
    [anon_sym_SQUOTE] = ACTIONS(300),
    [anon_sym_BQUOTE] = ACTIONS(302),
    [anon_sym_TILDE_AT] = ACTIONS(304),
    [anon_sym_TILDE] = ACTIONS(306),
  },
  [80] = {
    [sym__gap] = STATE(301),
    [sym_dis_expr] = STATE(301),
    [sym__form] = STATE(335),
    [sym_kwd_lit] = STATE(335),
    [sym_str_lit] = STATE(335),
    [sym_sym_lit] = STATE(335),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(335),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(335),
    [sym__bare_map_lit] = STATE(403),
    [sym_vec_lit] = STATE(335),
    [sym__bare_vec_lit] = STATE(423),
    [sym_set_lit] = STATE(335),
    [sym__bare_set_lit] = STATE(374),
    [sym_anon_fn_lit] = STATE(335),
    [sym_regex_lit] = STATE(335),
    [sym_read_cond_lit] = STATE(335),
    [sym_splicing_read_cond_lit] = STATE(335),
    [sym_ns_map_lit] = STATE(335),
    [sym_var_quoting_lit] = STATE(335),
    [sym_sym_val_lit] = STATE(335),
    [sym_evaling_lit] = STATE(335),
    [sym_tagged_or_ctor_lit] = STATE(335),
    [sym_derefing_lit] = STATE(335),
    [sym_quoting_lit] = STATE(335),
    [sym_syn_quoting_lit] = STATE(335),
    [sym_unquote_splicing_lit] = STATE(335),
    [sym_unquoting_lit] = STATE(335),
    [aux_sym_dis_expr_repeat1] = STATE(301),
    [aux_sym_sym_lit_repeat1] = STATE(304),
    [sym__ws] = ACTIONS(264),
    [sym_comment] = ACTIONS(264),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(608),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(270),
    [anon_sym_COLON_COLON] = ACTIONS(272),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(608),
    [sym_nil_lit] = ACTIONS(610),
    [sym_bool_lit] = ACTIONS(610),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(286),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(292),
    [anon_sym_POUND_POUND] = ACTIONS(294),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(298),
    [anon_sym_SQUOTE] = ACTIONS(300),
    [anon_sym_BQUOTE] = ACTIONS(302),
    [anon_sym_TILDE_AT] = ACTIONS(304),
    [anon_sym_TILDE] = ACTIONS(306),
  },
  [81] = {
    [sym__gap] = STATE(301),
    [sym_dis_expr] = STATE(301),
    [sym__form] = STATE(334),
    [sym_kwd_lit] = STATE(334),
    [sym_str_lit] = STATE(334),
    [sym_sym_lit] = STATE(334),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(334),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(334),
    [sym__bare_map_lit] = STATE(403),
    [sym_vec_lit] = STATE(334),
    [sym__bare_vec_lit] = STATE(423),
    [sym_set_lit] = STATE(334),
    [sym__bare_set_lit] = STATE(374),
    [sym_anon_fn_lit] = STATE(334),
    [sym_regex_lit] = STATE(334),
    [sym_read_cond_lit] = STATE(334),
    [sym_splicing_read_cond_lit] = STATE(334),
    [sym_ns_map_lit] = STATE(334),
    [sym_var_quoting_lit] = STATE(334),
    [sym_sym_val_lit] = STATE(334),
    [sym_evaling_lit] = STATE(334),
    [sym_tagged_or_ctor_lit] = STATE(334),
    [sym_derefing_lit] = STATE(334),
    [sym_quoting_lit] = STATE(334),
    [sym_syn_quoting_lit] = STATE(334),
    [sym_unquote_splicing_lit] = STATE(334),
    [sym_unquoting_lit] = STATE(334),
    [aux_sym_dis_expr_repeat1] = STATE(301),
    [aux_sym_sym_lit_repeat1] = STATE(304),
    [sym__ws] = ACTIONS(264),
    [sym_comment] = ACTIONS(264),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(350),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(270),
    [anon_sym_COLON_COLON] = ACTIONS(272),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(350),
    [sym_nil_lit] = ACTIONS(356),
    [sym_bool_lit] = ACTIONS(356),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(286),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(292),
    [anon_sym_POUND_POUND] = ACTIONS(294),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(298),
    [anon_sym_SQUOTE] = ACTIONS(300),
    [anon_sym_BQUOTE] = ACTIONS(302),
    [anon_sym_TILDE_AT] = ACTIONS(304),
    [anon_sym_TILDE] = ACTIONS(306),
  },
  [82] = {
    [sym__gap] = STATE(301),
    [sym_dis_expr] = STATE(301),
    [sym__form] = STATE(417),
    [sym_kwd_lit] = STATE(417),
    [sym_str_lit] = STATE(417),
    [sym_sym_lit] = STATE(417),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(417),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(417),
    [sym__bare_map_lit] = STATE(403),
    [sym_vec_lit] = STATE(417),
    [sym__bare_vec_lit] = STATE(423),
    [sym_set_lit] = STATE(417),
    [sym__bare_set_lit] = STATE(374),
    [sym_anon_fn_lit] = STATE(417),
    [sym_regex_lit] = STATE(417),
    [sym_read_cond_lit] = STATE(417),
    [sym_splicing_read_cond_lit] = STATE(417),
    [sym_ns_map_lit] = STATE(417),
    [sym_var_quoting_lit] = STATE(417),
    [sym_sym_val_lit] = STATE(417),
    [sym_evaling_lit] = STATE(417),
    [sym_tagged_or_ctor_lit] = STATE(417),
    [sym_derefing_lit] = STATE(417),
    [sym_quoting_lit] = STATE(417),
    [sym_syn_quoting_lit] = STATE(417),
    [sym_unquote_splicing_lit] = STATE(417),
    [sym_unquoting_lit] = STATE(417),
    [aux_sym_dis_expr_repeat1] = STATE(301),
    [aux_sym_sym_lit_repeat1] = STATE(304),
    [sym__ws] = ACTIONS(264),
    [sym_comment] = ACTIONS(264),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(374),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(270),
    [anon_sym_COLON_COLON] = ACTIONS(272),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(374),
    [sym_nil_lit] = ACTIONS(376),
    [sym_bool_lit] = ACTIONS(376),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(286),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(292),
    [anon_sym_POUND_POUND] = ACTIONS(294),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(298),
    [anon_sym_SQUOTE] = ACTIONS(300),
    [anon_sym_BQUOTE] = ACTIONS(302),
    [anon_sym_TILDE_AT] = ACTIONS(304),
    [anon_sym_TILDE] = ACTIONS(306),
  },
  [83] = {
    [sym__gap] = STATE(301),
    [sym_dis_expr] = STATE(301),
    [sym__form] = STATE(350),
    [sym_kwd_lit] = STATE(350),
    [sym_str_lit] = STATE(350),
    [sym_sym_lit] = STATE(350),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(350),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(350),
    [sym__bare_map_lit] = STATE(403),
    [sym_vec_lit] = STATE(350),
    [sym__bare_vec_lit] = STATE(423),
    [sym_set_lit] = STATE(350),
    [sym__bare_set_lit] = STATE(374),
    [sym_anon_fn_lit] = STATE(350),
    [sym_regex_lit] = STATE(350),
    [sym_read_cond_lit] = STATE(350),
    [sym_splicing_read_cond_lit] = STATE(350),
    [sym_ns_map_lit] = STATE(350),
    [sym_var_quoting_lit] = STATE(350),
    [sym_sym_val_lit] = STATE(350),
    [sym_evaling_lit] = STATE(350),
    [sym_tagged_or_ctor_lit] = STATE(350),
    [sym_derefing_lit] = STATE(350),
    [sym_quoting_lit] = STATE(350),
    [sym_syn_quoting_lit] = STATE(350),
    [sym_unquote_splicing_lit] = STATE(350),
    [sym_unquoting_lit] = STATE(350),
    [aux_sym_dis_expr_repeat1] = STATE(301),
    [aux_sym_sym_lit_repeat1] = STATE(304),
    [sym__ws] = ACTIONS(264),
    [sym_comment] = ACTIONS(264),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(612),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(270),
    [anon_sym_COLON_COLON] = ACTIONS(272),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(612),
    [sym_nil_lit] = ACTIONS(614),
    [sym_bool_lit] = ACTIONS(614),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(286),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(292),
    [anon_sym_POUND_POUND] = ACTIONS(294),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(298),
    [anon_sym_SQUOTE] = ACTIONS(300),
    [anon_sym_BQUOTE] = ACTIONS(302),
    [anon_sym_TILDE_AT] = ACTIONS(304),
    [anon_sym_TILDE] = ACTIONS(306),
  },
  [84] = {
    [sym__gap] = STATE(73),
    [sym_dis_expr] = STATE(73),
    [sym__form] = STATE(357),
    [sym_kwd_lit] = STATE(357),
    [sym_str_lit] = STATE(357),
    [sym_sym_lit] = STATE(357),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(357),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(357),
    [sym__bare_map_lit] = STATE(403),
    [sym_vec_lit] = STATE(357),
    [sym__bare_vec_lit] = STATE(423),
    [sym_set_lit] = STATE(357),
    [sym__bare_set_lit] = STATE(374),
    [sym_anon_fn_lit] = STATE(357),
    [sym_regex_lit] = STATE(357),
    [sym_read_cond_lit] = STATE(357),
    [sym_splicing_read_cond_lit] = STATE(357),
    [sym_ns_map_lit] = STATE(357),
    [sym_var_quoting_lit] = STATE(357),
    [sym_sym_val_lit] = STATE(357),
    [sym_evaling_lit] = STATE(357),
    [sym_tagged_or_ctor_lit] = STATE(357),
    [sym_derefing_lit] = STATE(357),
    [sym_quoting_lit] = STATE(357),
    [sym_syn_quoting_lit] = STATE(357),
    [sym_unquote_splicing_lit] = STATE(357),
    [sym_unquoting_lit] = STATE(357),
    [aux_sym_dis_expr_repeat1] = STATE(73),
    [aux_sym_sym_lit_repeat1] = STATE(304),
    [sym__ws] = ACTIONS(616),
    [sym_comment] = ACTIONS(616),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(384),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(270),
    [anon_sym_COLON_COLON] = ACTIONS(272),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(384),
    [sym_nil_lit] = ACTIONS(386),
    [sym_bool_lit] = ACTIONS(386),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(286),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(292),
    [anon_sym_POUND_POUND] = ACTIONS(294),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(298),
    [anon_sym_SQUOTE] = ACTIONS(300),
    [anon_sym_BQUOTE] = ACTIONS(302),
    [anon_sym_TILDE_AT] = ACTIONS(304),
    [anon_sym_TILDE] = ACTIONS(306),
  },
  [85] = {
    [sym__gap] = STATE(75),
    [sym_dis_expr] = STATE(75),
    [sym__form] = STATE(362),
    [sym_kwd_lit] = STATE(362),
    [sym_str_lit] = STATE(362),
    [sym_sym_lit] = STATE(362),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(362),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(362),
    [sym__bare_map_lit] = STATE(403),
    [sym_vec_lit] = STATE(362),
    [sym__bare_vec_lit] = STATE(423),
    [sym_set_lit] = STATE(362),
    [sym__bare_set_lit] = STATE(374),
    [sym_anon_fn_lit] = STATE(362),
    [sym_regex_lit] = STATE(362),
    [sym_read_cond_lit] = STATE(362),
    [sym_splicing_read_cond_lit] = STATE(362),
    [sym_ns_map_lit] = STATE(362),
    [sym_var_quoting_lit] = STATE(362),
    [sym_sym_val_lit] = STATE(362),
    [sym_evaling_lit] = STATE(362),
    [sym_tagged_or_ctor_lit] = STATE(362),
    [sym_derefing_lit] = STATE(362),
    [sym_quoting_lit] = STATE(362),
    [sym_syn_quoting_lit] = STATE(362),
    [sym_unquote_splicing_lit] = STATE(362),
    [sym_unquoting_lit] = STATE(362),
    [aux_sym_dis_expr_repeat1] = STATE(75),
    [aux_sym_sym_lit_repeat1] = STATE(304),
    [sym__ws] = ACTIONS(618),
    [sym_comment] = ACTIONS(618),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(390),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(270),
    [anon_sym_COLON_COLON] = ACTIONS(272),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(390),
    [sym_nil_lit] = ACTIONS(392),
    [sym_bool_lit] = ACTIONS(392),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(286),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(292),
    [anon_sym_POUND_POUND] = ACTIONS(294),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(298),
    [anon_sym_SQUOTE] = ACTIONS(300),
    [anon_sym_BQUOTE] = ACTIONS(302),
    [anon_sym_TILDE_AT] = ACTIONS(304),
    [anon_sym_TILDE] = ACTIONS(306),
  },
  [86] = {
    [sym__gap] = STATE(138),
    [sym_dis_expr] = STATE(138),
    [sym__form] = STATE(283),
    [sym_kwd_lit] = STATE(283),
    [sym_str_lit] = STATE(283),
    [sym_sym_lit] = STATE(283),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(283),
    [sym__bare_list_lit] = STATE(218),
    [sym_map_lit] = STATE(283),
    [sym__bare_map_lit] = STATE(219),
    [sym_vec_lit] = STATE(283),
    [sym__bare_vec_lit] = STATE(226),
    [sym_set_lit] = STATE(283),
    [sym__bare_set_lit] = STATE(227),
    [sym_anon_fn_lit] = STATE(283),
    [sym_regex_lit] = STATE(283),
    [sym_read_cond_lit] = STATE(283),
    [sym_splicing_read_cond_lit] = STATE(283),
    [sym_ns_map_lit] = STATE(283),
    [sym_var_quoting_lit] = STATE(283),
    [sym_sym_val_lit] = STATE(283),
    [sym_evaling_lit] = STATE(283),
    [sym_tagged_or_ctor_lit] = STATE(283),
    [sym_derefing_lit] = STATE(283),
    [sym_quoting_lit] = STATE(283),
    [sym_syn_quoting_lit] = STATE(283),
    [sym_unquote_splicing_lit] = STATE(283),
    [sym_unquoting_lit] = STATE(283),
    [aux_sym_dis_expr_repeat1] = STATE(138),
    [aux_sym_sym_lit_repeat1] = STATE(305),
    [sym__ws] = ACTIONS(620),
    [sym_comment] = ACTIONS(620),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(622),
    [anon_sym_SLASH] = ACTIONS(9),
    [anon_sym_COLON] = ACTIONS(11),
    [anon_sym_COLON_COLON] = ACTIONS(13),
    [aux_sym_str_lit_token1] = ACTIONS(15),
    [sym_char_lit] = ACTIONS(622),
    [sym_nil_lit] = ACTIONS(624),
    [sym_bool_lit] = ACTIONS(624),
    [aux_sym__sym_qualified_token1] = ACTIONS(19),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_POUND] = ACTIONS(31),
    [anon_sym_POUND_QMARK] = ACTIONS(33),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(35),
    [anon_sym_POUND_SQUOTE] = ACTIONS(37),
    [anon_sym_POUND_POUND] = ACTIONS(39),
    [anon_sym_POUND_EQ] = ACTIONS(41),
    [anon_sym_AT] = ACTIONS(43),
    [anon_sym_SQUOTE] = ACTIONS(45),
    [anon_sym_BQUOTE] = ACTIONS(47),
    [anon_sym_TILDE_AT] = ACTIONS(49),
    [anon_sym_TILDE] = ACTIONS(51),
  },
  [87] = {
    [sym__gap] = STATE(301),
    [sym_dis_expr] = STATE(301),
    [sym__form] = STATE(364),
    [sym_kwd_lit] = STATE(364),
    [sym_str_lit] = STATE(364),
    [sym_sym_lit] = STATE(364),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(364),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(364),
    [sym__bare_map_lit] = STATE(403),
    [sym_vec_lit] = STATE(364),
    [sym__bare_vec_lit] = STATE(423),
    [sym_set_lit] = STATE(364),
    [sym__bare_set_lit] = STATE(374),
    [sym_anon_fn_lit] = STATE(364),
    [sym_regex_lit] = STATE(364),
    [sym_read_cond_lit] = STATE(364),
    [sym_splicing_read_cond_lit] = STATE(364),
    [sym_ns_map_lit] = STATE(364),
    [sym_var_quoting_lit] = STATE(364),
    [sym_sym_val_lit] = STATE(364),
    [sym_evaling_lit] = STATE(364),
    [sym_tagged_or_ctor_lit] = STATE(364),
    [sym_derefing_lit] = STATE(364),
    [sym_quoting_lit] = STATE(364),
    [sym_syn_quoting_lit] = STATE(364),
    [sym_unquote_splicing_lit] = STATE(364),
    [sym_unquoting_lit] = STATE(364),
    [aux_sym_dis_expr_repeat1] = STATE(301),
    [aux_sym_sym_lit_repeat1] = STATE(304),
    [sym__ws] = ACTIONS(264),
    [sym_comment] = ACTIONS(264),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(394),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(270),
    [anon_sym_COLON_COLON] = ACTIONS(272),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(394),
    [sym_nil_lit] = ACTIONS(396),
    [sym_bool_lit] = ACTIONS(396),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(286),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(292),
    [anon_sym_POUND_POUND] = ACTIONS(294),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(298),
    [anon_sym_SQUOTE] = ACTIONS(300),
    [anon_sym_BQUOTE] = ACTIONS(302),
    [anon_sym_TILDE_AT] = ACTIONS(304),
    [anon_sym_TILDE] = ACTIONS(306),
  },
  [88] = {
    [sym__gap] = STATE(144),
    [sym_dis_expr] = STATE(144),
    [sym__form] = STATE(287),
    [sym_kwd_lit] = STATE(287),
    [sym_str_lit] = STATE(287),
    [sym_sym_lit] = STATE(287),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(287),
    [sym__bare_list_lit] = STATE(218),
    [sym_map_lit] = STATE(287),
    [sym__bare_map_lit] = STATE(219),
    [sym_vec_lit] = STATE(287),
    [sym__bare_vec_lit] = STATE(226),
    [sym_set_lit] = STATE(287),
    [sym__bare_set_lit] = STATE(227),
    [sym_anon_fn_lit] = STATE(287),
    [sym_regex_lit] = STATE(287),
    [sym_read_cond_lit] = STATE(287),
    [sym_splicing_read_cond_lit] = STATE(287),
    [sym_ns_map_lit] = STATE(287),
    [sym_var_quoting_lit] = STATE(287),
    [sym_sym_val_lit] = STATE(287),
    [sym_evaling_lit] = STATE(287),
    [sym_tagged_or_ctor_lit] = STATE(287),
    [sym_derefing_lit] = STATE(287),
    [sym_quoting_lit] = STATE(287),
    [sym_syn_quoting_lit] = STATE(287),
    [sym_unquote_splicing_lit] = STATE(287),
    [sym_unquoting_lit] = STATE(287),
    [aux_sym_dis_expr_repeat1] = STATE(144),
    [aux_sym_sym_lit_repeat1] = STATE(305),
    [sym__ws] = ACTIONS(626),
    [sym_comment] = ACTIONS(626),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(628),
    [anon_sym_SLASH] = ACTIONS(9),
    [anon_sym_COLON] = ACTIONS(11),
    [anon_sym_COLON_COLON] = ACTIONS(13),
    [aux_sym_str_lit_token1] = ACTIONS(15),
    [sym_char_lit] = ACTIONS(628),
    [sym_nil_lit] = ACTIONS(630),
    [sym_bool_lit] = ACTIONS(630),
    [aux_sym__sym_qualified_token1] = ACTIONS(19),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_POUND] = ACTIONS(31),
    [anon_sym_POUND_QMARK] = ACTIONS(33),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(35),
    [anon_sym_POUND_SQUOTE] = ACTIONS(37),
    [anon_sym_POUND_POUND] = ACTIONS(39),
    [anon_sym_POUND_EQ] = ACTIONS(41),
    [anon_sym_AT] = ACTIONS(43),
    [anon_sym_SQUOTE] = ACTIONS(45),
    [anon_sym_BQUOTE] = ACTIONS(47),
    [anon_sym_TILDE_AT] = ACTIONS(49),
    [anon_sym_TILDE] = ACTIONS(51),
  },
  [89] = {
    [sym__gap] = STATE(146),
    [sym_dis_expr] = STATE(146),
    [sym__form] = STATE(289),
    [sym_kwd_lit] = STATE(289),
    [sym_str_lit] = STATE(289),
    [sym_sym_lit] = STATE(289),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(289),
    [sym__bare_list_lit] = STATE(218),
    [sym_map_lit] = STATE(289),
    [sym__bare_map_lit] = STATE(219),
    [sym_vec_lit] = STATE(289),
    [sym__bare_vec_lit] = STATE(226),
    [sym_set_lit] = STATE(289),
    [sym__bare_set_lit] = STATE(227),
    [sym_anon_fn_lit] = STATE(289),
    [sym_regex_lit] = STATE(289),
    [sym_read_cond_lit] = STATE(289),
    [sym_splicing_read_cond_lit] = STATE(289),
    [sym_ns_map_lit] = STATE(289),
    [sym_var_quoting_lit] = STATE(289),
    [sym_sym_val_lit] = STATE(289),
    [sym_evaling_lit] = STATE(289),
    [sym_tagged_or_ctor_lit] = STATE(289),
    [sym_derefing_lit] = STATE(289),
    [sym_quoting_lit] = STATE(289),
    [sym_syn_quoting_lit] = STATE(289),
    [sym_unquote_splicing_lit] = STATE(289),
    [sym_unquoting_lit] = STATE(289),
    [aux_sym_dis_expr_repeat1] = STATE(146),
    [aux_sym_sym_lit_repeat1] = STATE(305),
    [sym__ws] = ACTIONS(632),
    [sym_comment] = ACTIONS(632),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(634),
    [anon_sym_SLASH] = ACTIONS(9),
    [anon_sym_COLON] = ACTIONS(11),
    [anon_sym_COLON_COLON] = ACTIONS(13),
    [aux_sym_str_lit_token1] = ACTIONS(15),
    [sym_char_lit] = ACTIONS(634),
    [sym_nil_lit] = ACTIONS(636),
    [sym_bool_lit] = ACTIONS(636),
    [aux_sym__sym_qualified_token1] = ACTIONS(19),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_POUND] = ACTIONS(31),
    [anon_sym_POUND_QMARK] = ACTIONS(33),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(35),
    [anon_sym_POUND_SQUOTE] = ACTIONS(37),
    [anon_sym_POUND_POUND] = ACTIONS(39),
    [anon_sym_POUND_EQ] = ACTIONS(41),
    [anon_sym_AT] = ACTIONS(43),
    [anon_sym_SQUOTE] = ACTIONS(45),
    [anon_sym_BQUOTE] = ACTIONS(47),
    [anon_sym_TILDE_AT] = ACTIONS(49),
    [anon_sym_TILDE] = ACTIONS(51),
  },
  [90] = {
    [sym__gap] = STATE(148),
    [sym_dis_expr] = STATE(148),
    [sym__form] = STATE(290),
    [sym_kwd_lit] = STATE(290),
    [sym_str_lit] = STATE(290),
    [sym_sym_lit] = STATE(290),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(290),
    [sym__bare_list_lit] = STATE(218),
    [sym_map_lit] = STATE(290),
    [sym__bare_map_lit] = STATE(219),
    [sym_vec_lit] = STATE(290),
    [sym__bare_vec_lit] = STATE(226),
    [sym_set_lit] = STATE(290),
    [sym__bare_set_lit] = STATE(227),
    [sym_anon_fn_lit] = STATE(290),
    [sym_regex_lit] = STATE(290),
    [sym_read_cond_lit] = STATE(290),
    [sym_splicing_read_cond_lit] = STATE(290),
    [sym_ns_map_lit] = STATE(290),
    [sym_var_quoting_lit] = STATE(290),
    [sym_sym_val_lit] = STATE(290),
    [sym_evaling_lit] = STATE(290),
    [sym_tagged_or_ctor_lit] = STATE(290),
    [sym_derefing_lit] = STATE(290),
    [sym_quoting_lit] = STATE(290),
    [sym_syn_quoting_lit] = STATE(290),
    [sym_unquote_splicing_lit] = STATE(290),
    [sym_unquoting_lit] = STATE(290),
    [aux_sym_dis_expr_repeat1] = STATE(148),
    [aux_sym_sym_lit_repeat1] = STATE(305),
    [sym__ws] = ACTIONS(638),
    [sym_comment] = ACTIONS(638),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(640),
    [anon_sym_SLASH] = ACTIONS(9),
    [anon_sym_COLON] = ACTIONS(11),
    [anon_sym_COLON_COLON] = ACTIONS(13),
    [aux_sym_str_lit_token1] = ACTIONS(15),
    [sym_char_lit] = ACTIONS(640),
    [sym_nil_lit] = ACTIONS(642),
    [sym_bool_lit] = ACTIONS(642),
    [aux_sym__sym_qualified_token1] = ACTIONS(19),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_POUND] = ACTIONS(31),
    [anon_sym_POUND_QMARK] = ACTIONS(33),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(35),
    [anon_sym_POUND_SQUOTE] = ACTIONS(37),
    [anon_sym_POUND_POUND] = ACTIONS(39),
    [anon_sym_POUND_EQ] = ACTIONS(41),
    [anon_sym_AT] = ACTIONS(43),
    [anon_sym_SQUOTE] = ACTIONS(45),
    [anon_sym_BQUOTE] = ACTIONS(47),
    [anon_sym_TILDE_AT] = ACTIONS(49),
    [anon_sym_TILDE] = ACTIONS(51),
  },
  [91] = {
    [sym__gap] = STATE(150),
    [sym_dis_expr] = STATE(150),
    [sym__form] = STATE(291),
    [sym_kwd_lit] = STATE(291),
    [sym_str_lit] = STATE(291),
    [sym_sym_lit] = STATE(291),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(291),
    [sym__bare_list_lit] = STATE(218),
    [sym_map_lit] = STATE(291),
    [sym__bare_map_lit] = STATE(219),
    [sym_vec_lit] = STATE(291),
    [sym__bare_vec_lit] = STATE(226),
    [sym_set_lit] = STATE(291),
    [sym__bare_set_lit] = STATE(227),
    [sym_anon_fn_lit] = STATE(291),
    [sym_regex_lit] = STATE(291),
    [sym_read_cond_lit] = STATE(291),
    [sym_splicing_read_cond_lit] = STATE(291),
    [sym_ns_map_lit] = STATE(291),
    [sym_var_quoting_lit] = STATE(291),
    [sym_sym_val_lit] = STATE(291),
    [sym_evaling_lit] = STATE(291),
    [sym_tagged_or_ctor_lit] = STATE(291),
    [sym_derefing_lit] = STATE(291),
    [sym_quoting_lit] = STATE(291),
    [sym_syn_quoting_lit] = STATE(291),
    [sym_unquote_splicing_lit] = STATE(291),
    [sym_unquoting_lit] = STATE(291),
    [aux_sym_dis_expr_repeat1] = STATE(150),
    [aux_sym_sym_lit_repeat1] = STATE(305),
    [sym__ws] = ACTIONS(644),
    [sym_comment] = ACTIONS(644),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(646),
    [anon_sym_SLASH] = ACTIONS(9),
    [anon_sym_COLON] = ACTIONS(11),
    [anon_sym_COLON_COLON] = ACTIONS(13),
    [aux_sym_str_lit_token1] = ACTIONS(15),
    [sym_char_lit] = ACTIONS(646),
    [sym_nil_lit] = ACTIONS(648),
    [sym_bool_lit] = ACTIONS(648),
    [aux_sym__sym_qualified_token1] = ACTIONS(19),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_POUND] = ACTIONS(31),
    [anon_sym_POUND_QMARK] = ACTIONS(33),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(35),
    [anon_sym_POUND_SQUOTE] = ACTIONS(37),
    [anon_sym_POUND_POUND] = ACTIONS(39),
    [anon_sym_POUND_EQ] = ACTIONS(41),
    [anon_sym_AT] = ACTIONS(43),
    [anon_sym_SQUOTE] = ACTIONS(45),
    [anon_sym_BQUOTE] = ACTIONS(47),
    [anon_sym_TILDE_AT] = ACTIONS(49),
    [anon_sym_TILDE] = ACTIONS(51),
  },
  [92] = {
    [sym__gap] = STATE(152),
    [sym_dis_expr] = STATE(152),
    [sym__form] = STATE(263),
    [sym_kwd_lit] = STATE(263),
    [sym_str_lit] = STATE(263),
    [sym_sym_lit] = STATE(263),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(263),
    [sym__bare_list_lit] = STATE(218),
    [sym_map_lit] = STATE(263),
    [sym__bare_map_lit] = STATE(219),
    [sym_vec_lit] = STATE(263),
    [sym__bare_vec_lit] = STATE(226),
    [sym_set_lit] = STATE(263),
    [sym__bare_set_lit] = STATE(227),
    [sym_anon_fn_lit] = STATE(263),
    [sym_regex_lit] = STATE(263),
    [sym_read_cond_lit] = STATE(263),
    [sym_splicing_read_cond_lit] = STATE(263),
    [sym_ns_map_lit] = STATE(263),
    [sym_var_quoting_lit] = STATE(263),
    [sym_sym_val_lit] = STATE(263),
    [sym_evaling_lit] = STATE(263),
    [sym_tagged_or_ctor_lit] = STATE(263),
    [sym_derefing_lit] = STATE(263),
    [sym_quoting_lit] = STATE(263),
    [sym_syn_quoting_lit] = STATE(263),
    [sym_unquote_splicing_lit] = STATE(263),
    [sym_unquoting_lit] = STATE(263),
    [aux_sym_dis_expr_repeat1] = STATE(152),
    [aux_sym_sym_lit_repeat1] = STATE(305),
    [sym__ws] = ACTIONS(650),
    [sym_comment] = ACTIONS(650),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(652),
    [anon_sym_SLASH] = ACTIONS(9),
    [anon_sym_COLON] = ACTIONS(11),
    [anon_sym_COLON_COLON] = ACTIONS(13),
    [aux_sym_str_lit_token1] = ACTIONS(15),
    [sym_char_lit] = ACTIONS(652),
    [sym_nil_lit] = ACTIONS(654),
    [sym_bool_lit] = ACTIONS(654),
    [aux_sym__sym_qualified_token1] = ACTIONS(19),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_POUND] = ACTIONS(31),
    [anon_sym_POUND_QMARK] = ACTIONS(33),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(35),
    [anon_sym_POUND_SQUOTE] = ACTIONS(37),
    [anon_sym_POUND_POUND] = ACTIONS(39),
    [anon_sym_POUND_EQ] = ACTIONS(41),
    [anon_sym_AT] = ACTIONS(43),
    [anon_sym_SQUOTE] = ACTIONS(45),
    [anon_sym_BQUOTE] = ACTIONS(47),
    [anon_sym_TILDE_AT] = ACTIONS(49),
    [anon_sym_TILDE] = ACTIONS(51),
  },
  [93] = {
    [sym__gap] = STATE(77),
    [sym_dis_expr] = STATE(77),
    [sym__form] = STATE(378),
    [sym_kwd_lit] = STATE(378),
    [sym_str_lit] = STATE(378),
    [sym_sym_lit] = STATE(378),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(378),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(378),
    [sym__bare_map_lit] = STATE(403),
    [sym_vec_lit] = STATE(378),
    [sym__bare_vec_lit] = STATE(423),
    [sym_set_lit] = STATE(378),
    [sym__bare_set_lit] = STATE(374),
    [sym_anon_fn_lit] = STATE(378),
    [sym_regex_lit] = STATE(378),
    [sym_read_cond_lit] = STATE(378),
    [sym_splicing_read_cond_lit] = STATE(378),
    [sym_ns_map_lit] = STATE(378),
    [sym_var_quoting_lit] = STATE(378),
    [sym_sym_val_lit] = STATE(378),
    [sym_evaling_lit] = STATE(378),
    [sym_tagged_or_ctor_lit] = STATE(378),
    [sym_derefing_lit] = STATE(378),
    [sym_quoting_lit] = STATE(378),
    [sym_syn_quoting_lit] = STATE(378),
    [sym_unquote_splicing_lit] = STATE(378),
    [sym_unquoting_lit] = STATE(378),
    [aux_sym_dis_expr_repeat1] = STATE(77),
    [aux_sym_sym_lit_repeat1] = STATE(304),
    [sym__ws] = ACTIONS(656),
    [sym_comment] = ACTIONS(656),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(400),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(270),
    [anon_sym_COLON_COLON] = ACTIONS(272),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(400),
    [sym_nil_lit] = ACTIONS(402),
    [sym_bool_lit] = ACTIONS(402),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(286),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(292),
    [anon_sym_POUND_POUND] = ACTIONS(294),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(298),
    [anon_sym_SQUOTE] = ACTIONS(300),
    [anon_sym_BQUOTE] = ACTIONS(302),
    [anon_sym_TILDE_AT] = ACTIONS(304),
    [anon_sym_TILDE] = ACTIONS(306),
  },
  [94] = {
    [sym__gap] = STATE(79),
    [sym_dis_expr] = STATE(79),
    [sym__form] = STATE(384),
    [sym_kwd_lit] = STATE(384),
    [sym_str_lit] = STATE(384),
    [sym_sym_lit] = STATE(384),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(384),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(384),
    [sym__bare_map_lit] = STATE(403),
    [sym_vec_lit] = STATE(384),
    [sym__bare_vec_lit] = STATE(423),
    [sym_set_lit] = STATE(384),
    [sym__bare_set_lit] = STATE(374),
    [sym_anon_fn_lit] = STATE(384),
    [sym_regex_lit] = STATE(384),
    [sym_read_cond_lit] = STATE(384),
    [sym_splicing_read_cond_lit] = STATE(384),
    [sym_ns_map_lit] = STATE(384),
    [sym_var_quoting_lit] = STATE(384),
    [sym_sym_val_lit] = STATE(384),
    [sym_evaling_lit] = STATE(384),
    [sym_tagged_or_ctor_lit] = STATE(384),
    [sym_derefing_lit] = STATE(384),
    [sym_quoting_lit] = STATE(384),
    [sym_syn_quoting_lit] = STATE(384),
    [sym_unquote_splicing_lit] = STATE(384),
    [sym_unquoting_lit] = STATE(384),
    [aux_sym_dis_expr_repeat1] = STATE(79),
    [aux_sym_sym_lit_repeat1] = STATE(304),
    [sym__ws] = ACTIONS(658),
    [sym_comment] = ACTIONS(658),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(406),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(270),
    [anon_sym_COLON_COLON] = ACTIONS(272),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(406),
    [sym_nil_lit] = ACTIONS(408),
    [sym_bool_lit] = ACTIONS(408),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(286),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(292),
    [anon_sym_POUND_POUND] = ACTIONS(294),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(298),
    [anon_sym_SQUOTE] = ACTIONS(300),
    [anon_sym_BQUOTE] = ACTIONS(302),
    [anon_sym_TILDE_AT] = ACTIONS(304),
    [anon_sym_TILDE] = ACTIONS(306),
  },
  [95] = {
    [sym__gap] = STATE(80),
    [sym_dis_expr] = STATE(80),
    [sym__form] = STATE(410),
    [sym_kwd_lit] = STATE(410),
    [sym_str_lit] = STATE(410),
    [sym_sym_lit] = STATE(410),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(410),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(410),
    [sym__bare_map_lit] = STATE(403),
    [sym_vec_lit] = STATE(410),
    [sym__bare_vec_lit] = STATE(423),
    [sym_set_lit] = STATE(410),
    [sym__bare_set_lit] = STATE(374),
    [sym_anon_fn_lit] = STATE(410),
    [sym_regex_lit] = STATE(410),
    [sym_read_cond_lit] = STATE(410),
    [sym_splicing_read_cond_lit] = STATE(410),
    [sym_ns_map_lit] = STATE(410),
    [sym_var_quoting_lit] = STATE(410),
    [sym_sym_val_lit] = STATE(410),
    [sym_evaling_lit] = STATE(410),
    [sym_tagged_or_ctor_lit] = STATE(410),
    [sym_derefing_lit] = STATE(410),
    [sym_quoting_lit] = STATE(410),
    [sym_syn_quoting_lit] = STATE(410),
    [sym_unquote_splicing_lit] = STATE(410),
    [sym_unquoting_lit] = STATE(410),
    [aux_sym_dis_expr_repeat1] = STATE(80),
    [aux_sym_sym_lit_repeat1] = STATE(304),
    [sym__ws] = ACTIONS(660),
    [sym_comment] = ACTIONS(660),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(412),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(270),
    [anon_sym_COLON_COLON] = ACTIONS(272),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(412),
    [sym_nil_lit] = ACTIONS(414),
    [sym_bool_lit] = ACTIONS(414),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(286),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(292),
    [anon_sym_POUND_POUND] = ACTIONS(294),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(298),
    [anon_sym_SQUOTE] = ACTIONS(300),
    [anon_sym_BQUOTE] = ACTIONS(302),
    [anon_sym_TILDE_AT] = ACTIONS(304),
    [anon_sym_TILDE] = ACTIONS(306),
  },
  [96] = {
    [sym__gap] = STATE(81),
    [sym_dis_expr] = STATE(81),
    [sym__form] = STATE(391),
    [sym_kwd_lit] = STATE(391),
    [sym_str_lit] = STATE(391),
    [sym_sym_lit] = STATE(391),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(391),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(391),
    [sym__bare_map_lit] = STATE(403),
    [sym_vec_lit] = STATE(391),
    [sym__bare_vec_lit] = STATE(423),
    [sym_set_lit] = STATE(391),
    [sym__bare_set_lit] = STATE(374),
    [sym_anon_fn_lit] = STATE(391),
    [sym_regex_lit] = STATE(391),
    [sym_read_cond_lit] = STATE(391),
    [sym_splicing_read_cond_lit] = STATE(391),
    [sym_ns_map_lit] = STATE(391),
    [sym_var_quoting_lit] = STATE(391),
    [sym_sym_val_lit] = STATE(391),
    [sym_evaling_lit] = STATE(391),
    [sym_tagged_or_ctor_lit] = STATE(391),
    [sym_derefing_lit] = STATE(391),
    [sym_quoting_lit] = STATE(391),
    [sym_syn_quoting_lit] = STATE(391),
    [sym_unquote_splicing_lit] = STATE(391),
    [sym_unquoting_lit] = STATE(391),
    [aux_sym_dis_expr_repeat1] = STATE(81),
    [aux_sym_sym_lit_repeat1] = STATE(304),
    [sym__ws] = ACTIONS(662),
    [sym_comment] = ACTIONS(662),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(418),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(270),
    [anon_sym_COLON_COLON] = ACTIONS(272),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(418),
    [sym_nil_lit] = ACTIONS(420),
    [sym_bool_lit] = ACTIONS(420),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(286),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(292),
    [anon_sym_POUND_POUND] = ACTIONS(294),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(298),
    [anon_sym_SQUOTE] = ACTIONS(300),
    [anon_sym_BQUOTE] = ACTIONS(302),
    [anon_sym_TILDE_AT] = ACTIONS(304),
    [anon_sym_TILDE] = ACTIONS(306),
  },
  [97] = {
    [sym__gap] = STATE(82),
    [sym_dis_expr] = STATE(82),
    [sym__form] = STATE(393),
    [sym_kwd_lit] = STATE(393),
    [sym_str_lit] = STATE(393),
    [sym_sym_lit] = STATE(393),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(393),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(393),
    [sym__bare_map_lit] = STATE(403),
    [sym_vec_lit] = STATE(393),
    [sym__bare_vec_lit] = STATE(423),
    [sym_set_lit] = STATE(393),
    [sym__bare_set_lit] = STATE(374),
    [sym_anon_fn_lit] = STATE(393),
    [sym_regex_lit] = STATE(393),
    [sym_read_cond_lit] = STATE(393),
    [sym_splicing_read_cond_lit] = STATE(393),
    [sym_ns_map_lit] = STATE(393),
    [sym_var_quoting_lit] = STATE(393),
    [sym_sym_val_lit] = STATE(393),
    [sym_evaling_lit] = STATE(393),
    [sym_tagged_or_ctor_lit] = STATE(393),
    [sym_derefing_lit] = STATE(393),
    [sym_quoting_lit] = STATE(393),
    [sym_syn_quoting_lit] = STATE(393),
    [sym_unquote_splicing_lit] = STATE(393),
    [sym_unquoting_lit] = STATE(393),
    [aux_sym_dis_expr_repeat1] = STATE(82),
    [aux_sym_sym_lit_repeat1] = STATE(304),
    [sym__ws] = ACTIONS(664),
    [sym_comment] = ACTIONS(664),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(448),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(270),
    [anon_sym_COLON_COLON] = ACTIONS(272),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(448),
    [sym_nil_lit] = ACTIONS(450),
    [sym_bool_lit] = ACTIONS(450),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(286),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(292),
    [anon_sym_POUND_POUND] = ACTIONS(294),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(298),
    [anon_sym_SQUOTE] = ACTIONS(300),
    [anon_sym_BQUOTE] = ACTIONS(302),
    [anon_sym_TILDE_AT] = ACTIONS(304),
    [anon_sym_TILDE] = ACTIONS(306),
  },
  [98] = {
    [sym__gap] = STATE(83),
    [sym_dis_expr] = STATE(83),
    [sym__form] = STATE(405),
    [sym_kwd_lit] = STATE(405),
    [sym_str_lit] = STATE(405),
    [sym_sym_lit] = STATE(405),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(405),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(405),
    [sym__bare_map_lit] = STATE(403),
    [sym_vec_lit] = STATE(405),
    [sym__bare_vec_lit] = STATE(423),
    [sym_set_lit] = STATE(405),
    [sym__bare_set_lit] = STATE(374),
    [sym_anon_fn_lit] = STATE(405),
    [sym_regex_lit] = STATE(405),
    [sym_read_cond_lit] = STATE(405),
    [sym_splicing_read_cond_lit] = STATE(405),
    [sym_ns_map_lit] = STATE(405),
    [sym_var_quoting_lit] = STATE(405),
    [sym_sym_val_lit] = STATE(405),
    [sym_evaling_lit] = STATE(405),
    [sym_tagged_or_ctor_lit] = STATE(405),
    [sym_derefing_lit] = STATE(405),
    [sym_quoting_lit] = STATE(405),
    [sym_syn_quoting_lit] = STATE(405),
    [sym_unquote_splicing_lit] = STATE(405),
    [sym_unquoting_lit] = STATE(405),
    [aux_sym_dis_expr_repeat1] = STATE(83),
    [aux_sym_sym_lit_repeat1] = STATE(304),
    [sym__ws] = ACTIONS(666),
    [sym_comment] = ACTIONS(666),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(454),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(270),
    [anon_sym_COLON_COLON] = ACTIONS(272),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(454),
    [sym_nil_lit] = ACTIONS(456),
    [sym_bool_lit] = ACTIONS(456),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(286),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(292),
    [anon_sym_POUND_POUND] = ACTIONS(294),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(298),
    [anon_sym_SQUOTE] = ACTIONS(300),
    [anon_sym_BQUOTE] = ACTIONS(302),
    [anon_sym_TILDE_AT] = ACTIONS(304),
    [anon_sym_TILDE] = ACTIONS(306),
  },
  [99] = {
    [sym__gap] = STATE(301),
    [sym_dis_expr] = STATE(301),
    [sym__form] = STATE(369),
    [sym_kwd_lit] = STATE(369),
    [sym_str_lit] = STATE(369),
    [sym_sym_lit] = STATE(369),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(369),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(369),
    [sym__bare_map_lit] = STATE(403),
    [sym_vec_lit] = STATE(369),
    [sym__bare_vec_lit] = STATE(423),
    [sym_set_lit] = STATE(369),
    [sym__bare_set_lit] = STATE(374),
    [sym_anon_fn_lit] = STATE(369),
    [sym_regex_lit] = STATE(369),
    [sym_read_cond_lit] = STATE(369),
    [sym_splicing_read_cond_lit] = STATE(369),
    [sym_ns_map_lit] = STATE(369),
    [sym_var_quoting_lit] = STATE(369),
    [sym_sym_val_lit] = STATE(369),
    [sym_evaling_lit] = STATE(369),
    [sym_tagged_or_ctor_lit] = STATE(369),
    [sym_derefing_lit] = STATE(369),
    [sym_quoting_lit] = STATE(369),
    [sym_syn_quoting_lit] = STATE(369),
    [sym_unquote_splicing_lit] = STATE(369),
    [sym_unquoting_lit] = STATE(369),
    [aux_sym_dis_expr_repeat1] = STATE(301),
    [aux_sym_sym_lit_repeat1] = STATE(304),
    [sym__ws] = ACTIONS(264),
    [sym_comment] = ACTIONS(264),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(458),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(270),
    [anon_sym_COLON_COLON] = ACTIONS(272),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(458),
    [sym_nil_lit] = ACTIONS(460),
    [sym_bool_lit] = ACTIONS(460),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(286),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(292),
    [anon_sym_POUND_POUND] = ACTIONS(294),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(298),
    [anon_sym_SQUOTE] = ACTIONS(300),
    [anon_sym_BQUOTE] = ACTIONS(302),
    [anon_sym_TILDE_AT] = ACTIONS(304),
    [anon_sym_TILDE] = ACTIONS(306),
  },
  [100] = {
    [sym__gap] = STATE(301),
    [sym_dis_expr] = STATE(301),
    [sym__form] = STATE(412),
    [sym_kwd_lit] = STATE(412),
    [sym_str_lit] = STATE(412),
    [sym_sym_lit] = STATE(412),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(412),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(412),
    [sym__bare_map_lit] = STATE(403),
    [sym_vec_lit] = STATE(412),
    [sym__bare_vec_lit] = STATE(423),
    [sym_set_lit] = STATE(412),
    [sym__bare_set_lit] = STATE(374),
    [sym_anon_fn_lit] = STATE(412),
    [sym_regex_lit] = STATE(412),
    [sym_read_cond_lit] = STATE(412),
    [sym_splicing_read_cond_lit] = STATE(412),
    [sym_ns_map_lit] = STATE(412),
    [sym_var_quoting_lit] = STATE(412),
    [sym_sym_val_lit] = STATE(412),
    [sym_evaling_lit] = STATE(412),
    [sym_tagged_or_ctor_lit] = STATE(412),
    [sym_derefing_lit] = STATE(412),
    [sym_quoting_lit] = STATE(412),
    [sym_syn_quoting_lit] = STATE(412),
    [sym_unquote_splicing_lit] = STATE(412),
    [sym_unquoting_lit] = STATE(412),
    [aux_sym_dis_expr_repeat1] = STATE(301),
    [aux_sym_sym_lit_repeat1] = STATE(304),
    [sym__ws] = ACTIONS(264),
    [sym_comment] = ACTIONS(264),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(466),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(270),
    [anon_sym_COLON_COLON] = ACTIONS(272),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(466),
    [sym_nil_lit] = ACTIONS(468),
    [sym_bool_lit] = ACTIONS(468),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(286),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(292),
    [anon_sym_POUND_POUND] = ACTIONS(294),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(298),
    [anon_sym_SQUOTE] = ACTIONS(300),
    [anon_sym_BQUOTE] = ACTIONS(302),
    [anon_sym_TILDE_AT] = ACTIONS(304),
    [anon_sym_TILDE] = ACTIONS(306),
  },
  [101] = {
    [sym__gap] = STATE(301),
    [sym_dis_expr] = STATE(301),
    [sym__form] = STATE(414),
    [sym_kwd_lit] = STATE(414),
    [sym_str_lit] = STATE(414),
    [sym_sym_lit] = STATE(414),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(414),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(414),
    [sym__bare_map_lit] = STATE(403),
    [sym_vec_lit] = STATE(414),
    [sym__bare_vec_lit] = STATE(423),
    [sym_set_lit] = STATE(414),
    [sym__bare_set_lit] = STATE(374),
    [sym_anon_fn_lit] = STATE(414),
    [sym_regex_lit] = STATE(414),
    [sym_read_cond_lit] = STATE(414),
    [sym_splicing_read_cond_lit] = STATE(414),
    [sym_ns_map_lit] = STATE(414),
    [sym_var_quoting_lit] = STATE(414),
    [sym_sym_val_lit] = STATE(414),
    [sym_evaling_lit] = STATE(414),
    [sym_tagged_or_ctor_lit] = STATE(414),
    [sym_derefing_lit] = STATE(414),
    [sym_quoting_lit] = STATE(414),
    [sym_syn_quoting_lit] = STATE(414),
    [sym_unquote_splicing_lit] = STATE(414),
    [sym_unquoting_lit] = STATE(414),
    [aux_sym_dis_expr_repeat1] = STATE(301),
    [aux_sym_sym_lit_repeat1] = STATE(304),
    [sym__ws] = ACTIONS(264),
    [sym_comment] = ACTIONS(264),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(470),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(270),
    [anon_sym_COLON_COLON] = ACTIONS(272),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(470),
    [sym_nil_lit] = ACTIONS(472),
    [sym_bool_lit] = ACTIONS(472),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(286),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(292),
    [anon_sym_POUND_POUND] = ACTIONS(294),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(298),
    [anon_sym_SQUOTE] = ACTIONS(300),
    [anon_sym_BQUOTE] = ACTIONS(302),
    [anon_sym_TILDE_AT] = ACTIONS(304),
    [anon_sym_TILDE] = ACTIONS(306),
  },
  [102] = {
    [sym__gap] = STATE(301),
    [sym_dis_expr] = STATE(301),
    [sym__form] = STATE(415),
    [sym_kwd_lit] = STATE(415),
    [sym_str_lit] = STATE(415),
    [sym_sym_lit] = STATE(415),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(415),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(415),
    [sym__bare_map_lit] = STATE(403),
    [sym_vec_lit] = STATE(415),
    [sym__bare_vec_lit] = STATE(423),
    [sym_set_lit] = STATE(415),
    [sym__bare_set_lit] = STATE(374),
    [sym_anon_fn_lit] = STATE(415),
    [sym_regex_lit] = STATE(415),
    [sym_read_cond_lit] = STATE(415),
    [sym_splicing_read_cond_lit] = STATE(415),
    [sym_ns_map_lit] = STATE(415),
    [sym_var_quoting_lit] = STATE(415),
    [sym_sym_val_lit] = STATE(415),
    [sym_evaling_lit] = STATE(415),
    [sym_tagged_or_ctor_lit] = STATE(415),
    [sym_derefing_lit] = STATE(415),
    [sym_quoting_lit] = STATE(415),
    [sym_syn_quoting_lit] = STATE(415),
    [sym_unquote_splicing_lit] = STATE(415),
    [sym_unquoting_lit] = STATE(415),
    [aux_sym_dis_expr_repeat1] = STATE(301),
    [aux_sym_sym_lit_repeat1] = STATE(304),
    [sym__ws] = ACTIONS(264),
    [sym_comment] = ACTIONS(264),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(474),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(270),
    [anon_sym_COLON_COLON] = ACTIONS(272),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(474),
    [sym_nil_lit] = ACTIONS(476),
    [sym_bool_lit] = ACTIONS(476),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(286),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(292),
    [anon_sym_POUND_POUND] = ACTIONS(294),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(298),
    [anon_sym_SQUOTE] = ACTIONS(300),
    [anon_sym_BQUOTE] = ACTIONS(302),
    [anon_sym_TILDE_AT] = ACTIONS(304),
    [anon_sym_TILDE] = ACTIONS(306),
  },
  [103] = {
    [sym__gap] = STATE(301),
    [sym_dis_expr] = STATE(301),
    [sym__form] = STATE(416),
    [sym_kwd_lit] = STATE(416),
    [sym_str_lit] = STATE(416),
    [sym_sym_lit] = STATE(416),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(416),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(416),
    [sym__bare_map_lit] = STATE(403),
    [sym_vec_lit] = STATE(416),
    [sym__bare_vec_lit] = STATE(423),
    [sym_set_lit] = STATE(416),
    [sym__bare_set_lit] = STATE(374),
    [sym_anon_fn_lit] = STATE(416),
    [sym_regex_lit] = STATE(416),
    [sym_read_cond_lit] = STATE(416),
    [sym_splicing_read_cond_lit] = STATE(416),
    [sym_ns_map_lit] = STATE(416),
    [sym_var_quoting_lit] = STATE(416),
    [sym_sym_val_lit] = STATE(416),
    [sym_evaling_lit] = STATE(416),
    [sym_tagged_or_ctor_lit] = STATE(416),
    [sym_derefing_lit] = STATE(416),
    [sym_quoting_lit] = STATE(416),
    [sym_syn_quoting_lit] = STATE(416),
    [sym_unquote_splicing_lit] = STATE(416),
    [sym_unquoting_lit] = STATE(416),
    [aux_sym_dis_expr_repeat1] = STATE(301),
    [aux_sym_sym_lit_repeat1] = STATE(304),
    [sym__ws] = ACTIONS(264),
    [sym_comment] = ACTIONS(264),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(478),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(270),
    [anon_sym_COLON_COLON] = ACTIONS(272),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(478),
    [sym_nil_lit] = ACTIONS(480),
    [sym_bool_lit] = ACTIONS(480),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(286),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(292),
    [anon_sym_POUND_POUND] = ACTIONS(294),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(298),
    [anon_sym_SQUOTE] = ACTIONS(300),
    [anon_sym_BQUOTE] = ACTIONS(302),
    [anon_sym_TILDE_AT] = ACTIONS(304),
    [anon_sym_TILDE] = ACTIONS(306),
  },
  [104] = {
    [sym__gap] = STATE(301),
    [sym_dis_expr] = STATE(301),
    [sym__form] = STATE(419),
    [sym_kwd_lit] = STATE(419),
    [sym_str_lit] = STATE(419),
    [sym_sym_lit] = STATE(419),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(419),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(419),
    [sym__bare_map_lit] = STATE(403),
    [sym_vec_lit] = STATE(419),
    [sym__bare_vec_lit] = STATE(423),
    [sym_set_lit] = STATE(419),
    [sym__bare_set_lit] = STATE(374),
    [sym_anon_fn_lit] = STATE(419),
    [sym_regex_lit] = STATE(419),
    [sym_read_cond_lit] = STATE(419),
    [sym_splicing_read_cond_lit] = STATE(419),
    [sym_ns_map_lit] = STATE(419),
    [sym_var_quoting_lit] = STATE(419),
    [sym_sym_val_lit] = STATE(419),
    [sym_evaling_lit] = STATE(419),
    [sym_tagged_or_ctor_lit] = STATE(419),
    [sym_derefing_lit] = STATE(419),
    [sym_quoting_lit] = STATE(419),
    [sym_syn_quoting_lit] = STATE(419),
    [sym_unquote_splicing_lit] = STATE(419),
    [sym_unquoting_lit] = STATE(419),
    [aux_sym_dis_expr_repeat1] = STATE(301),
    [aux_sym_sym_lit_repeat1] = STATE(304),
    [sym__ws] = ACTIONS(264),
    [sym_comment] = ACTIONS(264),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(482),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(270),
    [anon_sym_COLON_COLON] = ACTIONS(272),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(482),
    [sym_nil_lit] = ACTIONS(484),
    [sym_bool_lit] = ACTIONS(484),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(286),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(292),
    [anon_sym_POUND_POUND] = ACTIONS(294),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(298),
    [anon_sym_SQUOTE] = ACTIONS(300),
    [anon_sym_BQUOTE] = ACTIONS(302),
    [anon_sym_TILDE_AT] = ACTIONS(304),
    [anon_sym_TILDE] = ACTIONS(306),
  },
  [105] = {
    [sym__gap] = STATE(184),
    [sym_dis_expr] = STATE(184),
    [sym__form] = STATE(378),
    [sym_kwd_lit] = STATE(378),
    [sym_str_lit] = STATE(378),
    [sym_sym_lit] = STATE(378),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(378),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(378),
    [sym__bare_map_lit] = STATE(403),
    [sym_vec_lit] = STATE(378),
    [sym__bare_vec_lit] = STATE(423),
    [sym_set_lit] = STATE(378),
    [sym__bare_set_lit] = STATE(374),
    [sym_anon_fn_lit] = STATE(378),
    [sym_regex_lit] = STATE(378),
    [sym_read_cond_lit] = STATE(378),
    [sym_splicing_read_cond_lit] = STATE(378),
    [sym_ns_map_lit] = STATE(378),
    [sym_var_quoting_lit] = STATE(378),
    [sym_sym_val_lit] = STATE(378),
    [sym_evaling_lit] = STATE(378),
    [sym_tagged_or_ctor_lit] = STATE(378),
    [sym_derefing_lit] = STATE(378),
    [sym_quoting_lit] = STATE(378),
    [sym_syn_quoting_lit] = STATE(378),
    [sym_unquote_splicing_lit] = STATE(378),
    [sym_unquoting_lit] = STATE(378),
    [aux_sym_dis_expr_repeat1] = STATE(184),
    [aux_sym_sym_lit_repeat1] = STATE(306),
    [sym__ws] = ACTIONS(668),
    [sym_comment] = ACTIONS(668),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(400),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(426),
    [anon_sym_COLON_COLON] = ACTIONS(428),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(400),
    [sym_nil_lit] = ACTIONS(402),
    [sym_bool_lit] = ACTIONS(402),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(430),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(432),
    [anon_sym_POUND_POUND] = ACTIONS(434),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(436),
    [anon_sym_SQUOTE] = ACTIONS(438),
    [anon_sym_BQUOTE] = ACTIONS(440),
    [anon_sym_TILDE_AT] = ACTIONS(442),
    [anon_sym_TILDE] = ACTIONS(444),
  },
  [106] = {
    [sym__gap] = STATE(39),
    [sym_dis_expr] = STATE(39),
    [sym__form] = STATE(229),
    [sym_kwd_lit] = STATE(229),
    [sym_str_lit] = STATE(229),
    [sym_sym_lit] = STATE(229),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(229),
    [sym__bare_list_lit] = STATE(218),
    [sym_map_lit] = STATE(229),
    [sym__bare_map_lit] = STATE(219),
    [sym_vec_lit] = STATE(229),
    [sym__bare_vec_lit] = STATE(226),
    [sym_set_lit] = STATE(229),
    [sym__bare_set_lit] = STATE(227),
    [sym_anon_fn_lit] = STATE(229),
    [sym_regex_lit] = STATE(229),
    [sym_read_cond_lit] = STATE(229),
    [sym_splicing_read_cond_lit] = STATE(229),
    [sym_ns_map_lit] = STATE(229),
    [sym_var_quoting_lit] = STATE(229),
    [sym_sym_val_lit] = STATE(229),
    [sym_evaling_lit] = STATE(229),
    [sym_tagged_or_ctor_lit] = STATE(229),
    [sym_derefing_lit] = STATE(229),
    [sym_quoting_lit] = STATE(229),
    [sym_syn_quoting_lit] = STATE(229),
    [sym_unquote_splicing_lit] = STATE(229),
    [sym_unquoting_lit] = STATE(229),
    [aux_sym_dis_expr_repeat1] = STATE(39),
    [aux_sym_sym_lit_repeat1] = STATE(305),
    [sym__ws] = ACTIONS(670),
    [sym_comment] = ACTIONS(670),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(672),
    [anon_sym_SLASH] = ACTIONS(9),
    [anon_sym_COLON] = ACTIONS(11),
    [anon_sym_COLON_COLON] = ACTIONS(13),
    [aux_sym_str_lit_token1] = ACTIONS(15),
    [sym_char_lit] = ACTIONS(672),
    [sym_nil_lit] = ACTIONS(674),
    [sym_bool_lit] = ACTIONS(674),
    [aux_sym__sym_qualified_token1] = ACTIONS(19),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_POUND] = ACTIONS(31),
    [anon_sym_POUND_QMARK] = ACTIONS(33),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(35),
    [anon_sym_POUND_SQUOTE] = ACTIONS(37),
    [anon_sym_POUND_POUND] = ACTIONS(39),
    [anon_sym_POUND_EQ] = ACTIONS(41),
    [anon_sym_AT] = ACTIONS(43),
    [anon_sym_SQUOTE] = ACTIONS(45),
    [anon_sym_BQUOTE] = ACTIONS(47),
    [anon_sym_TILDE_AT] = ACTIONS(49),
    [anon_sym_TILDE] = ACTIONS(51),
  },
  [107] = {
    [sym__gap] = STATE(87),
    [sym_dis_expr] = STATE(87),
    [sym__form] = STATE(409),
    [sym_kwd_lit] = STATE(409),
    [sym_str_lit] = STATE(409),
    [sym_sym_lit] = STATE(409),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(409),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(409),
    [sym__bare_map_lit] = STATE(403),
    [sym_vec_lit] = STATE(409),
    [sym__bare_vec_lit] = STATE(423),
    [sym_set_lit] = STATE(409),
    [sym__bare_set_lit] = STATE(374),
    [sym_anon_fn_lit] = STATE(409),
    [sym_regex_lit] = STATE(409),
    [sym_read_cond_lit] = STATE(409),
    [sym_splicing_read_cond_lit] = STATE(409),
    [sym_ns_map_lit] = STATE(409),
    [sym_var_quoting_lit] = STATE(409),
    [sym_sym_val_lit] = STATE(409),
    [sym_evaling_lit] = STATE(409),
    [sym_tagged_or_ctor_lit] = STATE(409),
    [sym_derefing_lit] = STATE(409),
    [sym_quoting_lit] = STATE(409),
    [sym_syn_quoting_lit] = STATE(409),
    [sym_unquote_splicing_lit] = STATE(409),
    [sym_unquoting_lit] = STATE(409),
    [aux_sym_dis_expr_repeat1] = STATE(87),
    [aux_sym_sym_lit_repeat1] = STATE(304),
    [sym__ws] = ACTIONS(676),
    [sym_comment] = ACTIONS(676),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(488),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(270),
    [anon_sym_COLON_COLON] = ACTIONS(272),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(488),
    [sym_nil_lit] = ACTIONS(490),
    [sym_bool_lit] = ACTIONS(490),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(286),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(292),
    [anon_sym_POUND_POUND] = ACTIONS(294),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(298),
    [anon_sym_SQUOTE] = ACTIONS(300),
    [anon_sym_BQUOTE] = ACTIONS(302),
    [anon_sym_TILDE_AT] = ACTIONS(304),
    [anon_sym_TILDE] = ACTIONS(306),
  },
  [108] = {
    [sym__gap] = STATE(301),
    [sym_dis_expr] = STATE(301),
    [sym__form] = STATE(386),
    [sym_kwd_lit] = STATE(386),
    [sym_str_lit] = STATE(386),
    [sym_sym_lit] = STATE(386),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(386),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(386),
    [sym__bare_map_lit] = STATE(403),
    [sym_vec_lit] = STATE(386),
    [sym__bare_vec_lit] = STATE(423),
    [sym_set_lit] = STATE(386),
    [sym__bare_set_lit] = STATE(374),
    [sym_anon_fn_lit] = STATE(386),
    [sym_regex_lit] = STATE(386),
    [sym_read_cond_lit] = STATE(386),
    [sym_splicing_read_cond_lit] = STATE(386),
    [sym_ns_map_lit] = STATE(386),
    [sym_var_quoting_lit] = STATE(386),
    [sym_sym_val_lit] = STATE(386),
    [sym_evaling_lit] = STATE(386),
    [sym_tagged_or_ctor_lit] = STATE(386),
    [sym_derefing_lit] = STATE(386),
    [sym_quoting_lit] = STATE(386),
    [sym_syn_quoting_lit] = STATE(386),
    [sym_unquote_splicing_lit] = STATE(386),
    [sym_unquoting_lit] = STATE(386),
    [aux_sym_dis_expr_repeat1] = STATE(301),
    [aux_sym_sym_lit_repeat1] = STATE(307),
    [sym__ws] = ACTIONS(264),
    [sym_comment] = ACTIONS(264),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(492),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(352),
    [anon_sym_COLON_COLON] = ACTIONS(354),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(492),
    [sym_nil_lit] = ACTIONS(494),
    [sym_bool_lit] = ACTIONS(494),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(358),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(360),
    [anon_sym_POUND_POUND] = ACTIONS(362),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(364),
    [anon_sym_SQUOTE] = ACTIONS(366),
    [anon_sym_BQUOTE] = ACTIONS(368),
    [anon_sym_TILDE_AT] = ACTIONS(370),
    [anon_sym_TILDE] = ACTIONS(372),
  },
  [109] = {
    [sym__gap] = STATE(99),
    [sym_dis_expr] = STATE(99),
    [sym__form] = STATE(371),
    [sym_kwd_lit] = STATE(371),
    [sym_str_lit] = STATE(371),
    [sym_sym_lit] = STATE(371),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(371),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(371),
    [sym__bare_map_lit] = STATE(403),
    [sym_vec_lit] = STATE(371),
    [sym__bare_vec_lit] = STATE(423),
    [sym_set_lit] = STATE(371),
    [sym__bare_set_lit] = STATE(374),
    [sym_anon_fn_lit] = STATE(371),
    [sym_regex_lit] = STATE(371),
    [sym_read_cond_lit] = STATE(371),
    [sym_splicing_read_cond_lit] = STATE(371),
    [sym_ns_map_lit] = STATE(371),
    [sym_var_quoting_lit] = STATE(371),
    [sym_sym_val_lit] = STATE(371),
    [sym_evaling_lit] = STATE(371),
    [sym_tagged_or_ctor_lit] = STATE(371),
    [sym_derefing_lit] = STATE(371),
    [sym_quoting_lit] = STATE(371),
    [sym_syn_quoting_lit] = STATE(371),
    [sym_unquote_splicing_lit] = STATE(371),
    [sym_unquoting_lit] = STATE(371),
    [aux_sym_dis_expr_repeat1] = STATE(99),
    [aux_sym_sym_lit_repeat1] = STATE(304),
    [sym__ws] = ACTIONS(678),
    [sym_comment] = ACTIONS(678),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(504),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(270),
    [anon_sym_COLON_COLON] = ACTIONS(272),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(504),
    [sym_nil_lit] = ACTIONS(506),
    [sym_bool_lit] = ACTIONS(506),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(286),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(292),
    [anon_sym_POUND_POUND] = ACTIONS(294),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(298),
    [anon_sym_SQUOTE] = ACTIONS(300),
    [anon_sym_BQUOTE] = ACTIONS(302),
    [anon_sym_TILDE_AT] = ACTIONS(304),
    [anon_sym_TILDE] = ACTIONS(306),
  },
  [110] = {
    [sym__gap] = STATE(63),
    [sym_dis_expr] = STATE(63),
    [sym__form] = STATE(239),
    [sym_kwd_lit] = STATE(239),
    [sym_str_lit] = STATE(239),
    [sym_sym_lit] = STATE(239),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(239),
    [sym__bare_list_lit] = STATE(218),
    [sym_map_lit] = STATE(239),
    [sym__bare_map_lit] = STATE(219),
    [sym_vec_lit] = STATE(239),
    [sym__bare_vec_lit] = STATE(226),
    [sym_set_lit] = STATE(239),
    [sym__bare_set_lit] = STATE(227),
    [sym_anon_fn_lit] = STATE(239),
    [sym_regex_lit] = STATE(239),
    [sym_read_cond_lit] = STATE(239),
    [sym_splicing_read_cond_lit] = STATE(239),
    [sym_ns_map_lit] = STATE(239),
    [sym_var_quoting_lit] = STATE(239),
    [sym_sym_val_lit] = STATE(239),
    [sym_evaling_lit] = STATE(239),
    [sym_tagged_or_ctor_lit] = STATE(239),
    [sym_derefing_lit] = STATE(239),
    [sym_quoting_lit] = STATE(239),
    [sym_syn_quoting_lit] = STATE(239),
    [sym_unquote_splicing_lit] = STATE(239),
    [sym_unquoting_lit] = STATE(239),
    [aux_sym_dis_expr_repeat1] = STATE(63),
    [aux_sym_sym_lit_repeat1] = STATE(305),
    [sym__ws] = ACTIONS(680),
    [sym_comment] = ACTIONS(680),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(682),
    [anon_sym_SLASH] = ACTIONS(9),
    [anon_sym_COLON] = ACTIONS(11),
    [anon_sym_COLON_COLON] = ACTIONS(13),
    [aux_sym_str_lit_token1] = ACTIONS(15),
    [sym_char_lit] = ACTIONS(682),
    [sym_nil_lit] = ACTIONS(684),
    [sym_bool_lit] = ACTIONS(684),
    [aux_sym__sym_qualified_token1] = ACTIONS(19),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_POUND] = ACTIONS(31),
    [anon_sym_POUND_QMARK] = ACTIONS(33),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(35),
    [anon_sym_POUND_SQUOTE] = ACTIONS(37),
    [anon_sym_POUND_POUND] = ACTIONS(39),
    [anon_sym_POUND_EQ] = ACTIONS(41),
    [anon_sym_AT] = ACTIONS(43),
    [anon_sym_SQUOTE] = ACTIONS(45),
    [anon_sym_BQUOTE] = ACTIONS(47),
    [anon_sym_TILDE_AT] = ACTIONS(49),
    [anon_sym_TILDE] = ACTIONS(51),
  },
  [111] = {
    [sym__gap] = STATE(100),
    [sym_dis_expr] = STATE(100),
    [sym__form] = STATE(370),
    [sym_kwd_lit] = STATE(370),
    [sym_str_lit] = STATE(370),
    [sym_sym_lit] = STATE(370),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(370),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(370),
    [sym__bare_map_lit] = STATE(403),
    [sym_vec_lit] = STATE(370),
    [sym__bare_vec_lit] = STATE(423),
    [sym_set_lit] = STATE(370),
    [sym__bare_set_lit] = STATE(374),
    [sym_anon_fn_lit] = STATE(370),
    [sym_regex_lit] = STATE(370),
    [sym_read_cond_lit] = STATE(370),
    [sym_splicing_read_cond_lit] = STATE(370),
    [sym_ns_map_lit] = STATE(370),
    [sym_var_quoting_lit] = STATE(370),
    [sym_sym_val_lit] = STATE(370),
    [sym_evaling_lit] = STATE(370),
    [sym_tagged_or_ctor_lit] = STATE(370),
    [sym_derefing_lit] = STATE(370),
    [sym_quoting_lit] = STATE(370),
    [sym_syn_quoting_lit] = STATE(370),
    [sym_unquote_splicing_lit] = STATE(370),
    [sym_unquoting_lit] = STATE(370),
    [aux_sym_dis_expr_repeat1] = STATE(100),
    [aux_sym_sym_lit_repeat1] = STATE(304),
    [sym__ws] = ACTIONS(686),
    [sym_comment] = ACTIONS(686),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(510),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(270),
    [anon_sym_COLON_COLON] = ACTIONS(272),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(510),
    [sym_nil_lit] = ACTIONS(512),
    [sym_bool_lit] = ACTIONS(512),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(286),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(292),
    [anon_sym_POUND_POUND] = ACTIONS(294),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(298),
    [anon_sym_SQUOTE] = ACTIONS(300),
    [anon_sym_BQUOTE] = ACTIONS(302),
    [anon_sym_TILDE_AT] = ACTIONS(304),
    [anon_sym_TILDE] = ACTIONS(306),
  },
  [112] = {
    [sym__gap] = STATE(101),
    [sym_dis_expr] = STATE(101),
    [sym__form] = STATE(367),
    [sym_kwd_lit] = STATE(367),
    [sym_str_lit] = STATE(367),
    [sym_sym_lit] = STATE(367),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(367),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(367),
    [sym__bare_map_lit] = STATE(403),
    [sym_vec_lit] = STATE(367),
    [sym__bare_vec_lit] = STATE(423),
    [sym_set_lit] = STATE(367),
    [sym__bare_set_lit] = STATE(374),
    [sym_anon_fn_lit] = STATE(367),
    [sym_regex_lit] = STATE(367),
    [sym_read_cond_lit] = STATE(367),
    [sym_splicing_read_cond_lit] = STATE(367),
    [sym_ns_map_lit] = STATE(367),
    [sym_var_quoting_lit] = STATE(367),
    [sym_sym_val_lit] = STATE(367),
    [sym_evaling_lit] = STATE(367),
    [sym_tagged_or_ctor_lit] = STATE(367),
    [sym_derefing_lit] = STATE(367),
    [sym_quoting_lit] = STATE(367),
    [sym_syn_quoting_lit] = STATE(367),
    [sym_unquote_splicing_lit] = STATE(367),
    [sym_unquoting_lit] = STATE(367),
    [aux_sym_dis_expr_repeat1] = STATE(101),
    [aux_sym_sym_lit_repeat1] = STATE(304),
    [sym__ws] = ACTIONS(688),
    [sym_comment] = ACTIONS(688),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(516),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(270),
    [anon_sym_COLON_COLON] = ACTIONS(272),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(516),
    [sym_nil_lit] = ACTIONS(518),
    [sym_bool_lit] = ACTIONS(518),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(286),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(292),
    [anon_sym_POUND_POUND] = ACTIONS(294),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(298),
    [anon_sym_SQUOTE] = ACTIONS(300),
    [anon_sym_BQUOTE] = ACTIONS(302),
    [anon_sym_TILDE_AT] = ACTIONS(304),
    [anon_sym_TILDE] = ACTIONS(306),
  },
  [113] = {
    [sym__gap] = STATE(102),
    [sym_dis_expr] = STATE(102),
    [sym__form] = STATE(366),
    [sym_kwd_lit] = STATE(366),
    [sym_str_lit] = STATE(366),
    [sym_sym_lit] = STATE(366),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(366),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(366),
    [sym__bare_map_lit] = STATE(403),
    [sym_vec_lit] = STATE(366),
    [sym__bare_vec_lit] = STATE(423),
    [sym_set_lit] = STATE(366),
    [sym__bare_set_lit] = STATE(374),
    [sym_anon_fn_lit] = STATE(366),
    [sym_regex_lit] = STATE(366),
    [sym_read_cond_lit] = STATE(366),
    [sym_splicing_read_cond_lit] = STATE(366),
    [sym_ns_map_lit] = STATE(366),
    [sym_var_quoting_lit] = STATE(366),
    [sym_sym_val_lit] = STATE(366),
    [sym_evaling_lit] = STATE(366),
    [sym_tagged_or_ctor_lit] = STATE(366),
    [sym_derefing_lit] = STATE(366),
    [sym_quoting_lit] = STATE(366),
    [sym_syn_quoting_lit] = STATE(366),
    [sym_unquote_splicing_lit] = STATE(366),
    [sym_unquoting_lit] = STATE(366),
    [aux_sym_dis_expr_repeat1] = STATE(102),
    [aux_sym_sym_lit_repeat1] = STATE(304),
    [sym__ws] = ACTIONS(690),
    [sym_comment] = ACTIONS(690),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(522),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(270),
    [anon_sym_COLON_COLON] = ACTIONS(272),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(522),
    [sym_nil_lit] = ACTIONS(524),
    [sym_bool_lit] = ACTIONS(524),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(286),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(292),
    [anon_sym_POUND_POUND] = ACTIONS(294),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(298),
    [anon_sym_SQUOTE] = ACTIONS(300),
    [anon_sym_BQUOTE] = ACTIONS(302),
    [anon_sym_TILDE_AT] = ACTIONS(304),
    [anon_sym_TILDE] = ACTIONS(306),
  },
  [114] = {
    [sym__gap] = STATE(301),
    [sym_dis_expr] = STATE(301),
    [sym__form] = STATE(297),
    [sym_kwd_lit] = STATE(297),
    [sym_str_lit] = STATE(297),
    [sym_sym_lit] = STATE(297),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(297),
    [sym__bare_list_lit] = STATE(218),
    [sym_map_lit] = STATE(297),
    [sym__bare_map_lit] = STATE(219),
    [sym_vec_lit] = STATE(297),
    [sym__bare_vec_lit] = STATE(226),
    [sym_set_lit] = STATE(297),
    [sym__bare_set_lit] = STATE(227),
    [sym_anon_fn_lit] = STATE(297),
    [sym_regex_lit] = STATE(297),
    [sym_read_cond_lit] = STATE(297),
    [sym_splicing_read_cond_lit] = STATE(297),
    [sym_ns_map_lit] = STATE(297),
    [sym_var_quoting_lit] = STATE(297),
    [sym_sym_val_lit] = STATE(297),
    [sym_evaling_lit] = STATE(297),
    [sym_tagged_or_ctor_lit] = STATE(297),
    [sym_derefing_lit] = STATE(297),
    [sym_quoting_lit] = STATE(297),
    [sym_syn_quoting_lit] = STATE(297),
    [sym_unquote_splicing_lit] = STATE(297),
    [sym_unquoting_lit] = STATE(297),
    [aux_sym_dis_expr_repeat1] = STATE(301),
    [aux_sym_sym_lit_repeat1] = STATE(305),
    [sym__ws] = ACTIONS(264),
    [sym_comment] = ACTIONS(264),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(692),
    [anon_sym_SLASH] = ACTIONS(9),
    [anon_sym_COLON] = ACTIONS(11),
    [anon_sym_COLON_COLON] = ACTIONS(13),
    [aux_sym_str_lit_token1] = ACTIONS(15),
    [sym_char_lit] = ACTIONS(692),
    [sym_nil_lit] = ACTIONS(694),
    [sym_bool_lit] = ACTIONS(694),
    [aux_sym__sym_qualified_token1] = ACTIONS(19),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_POUND] = ACTIONS(31),
    [anon_sym_POUND_QMARK] = ACTIONS(33),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(35),
    [anon_sym_POUND_SQUOTE] = ACTIONS(37),
    [anon_sym_POUND_POUND] = ACTIONS(39),
    [anon_sym_POUND_EQ] = ACTIONS(41),
    [anon_sym_AT] = ACTIONS(43),
    [anon_sym_SQUOTE] = ACTIONS(45),
    [anon_sym_BQUOTE] = ACTIONS(47),
    [anon_sym_TILDE_AT] = ACTIONS(49),
    [anon_sym_TILDE] = ACTIONS(51),
  },
  [115] = {
    [sym__gap] = STATE(158),
    [sym_dis_expr] = STATE(158),
    [sym__form] = STATE(298),
    [sym_kwd_lit] = STATE(298),
    [sym_str_lit] = STATE(298),
    [sym_sym_lit] = STATE(298),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(298),
    [sym__bare_list_lit] = STATE(218),
    [sym_map_lit] = STATE(298),
    [sym__bare_map_lit] = STATE(219),
    [sym_vec_lit] = STATE(298),
    [sym__bare_vec_lit] = STATE(226),
    [sym_set_lit] = STATE(298),
    [sym__bare_set_lit] = STATE(227),
    [sym_anon_fn_lit] = STATE(298),
    [sym_regex_lit] = STATE(298),
    [sym_read_cond_lit] = STATE(298),
    [sym_splicing_read_cond_lit] = STATE(298),
    [sym_ns_map_lit] = STATE(298),
    [sym_var_quoting_lit] = STATE(298),
    [sym_sym_val_lit] = STATE(298),
    [sym_evaling_lit] = STATE(298),
    [sym_tagged_or_ctor_lit] = STATE(298),
    [sym_derefing_lit] = STATE(298),
    [sym_quoting_lit] = STATE(298),
    [sym_syn_quoting_lit] = STATE(298),
    [sym_unquote_splicing_lit] = STATE(298),
    [sym_unquoting_lit] = STATE(298),
    [aux_sym_dis_expr_repeat1] = STATE(158),
    [aux_sym_sym_lit_repeat1] = STATE(305),
    [sym__ws] = ACTIONS(696),
    [sym_comment] = ACTIONS(696),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(698),
    [anon_sym_SLASH] = ACTIONS(9),
    [anon_sym_COLON] = ACTIONS(11),
    [anon_sym_COLON_COLON] = ACTIONS(13),
    [aux_sym_str_lit_token1] = ACTIONS(15),
    [sym_char_lit] = ACTIONS(698),
    [sym_nil_lit] = ACTIONS(700),
    [sym_bool_lit] = ACTIONS(700),
    [aux_sym__sym_qualified_token1] = ACTIONS(19),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_POUND] = ACTIONS(31),
    [anon_sym_POUND_QMARK] = ACTIONS(33),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(35),
    [anon_sym_POUND_SQUOTE] = ACTIONS(37),
    [anon_sym_POUND_POUND] = ACTIONS(39),
    [anon_sym_POUND_EQ] = ACTIONS(41),
    [anon_sym_AT] = ACTIONS(43),
    [anon_sym_SQUOTE] = ACTIONS(45),
    [anon_sym_BQUOTE] = ACTIONS(47),
    [anon_sym_TILDE_AT] = ACTIONS(49),
    [anon_sym_TILDE] = ACTIONS(51),
  },
  [116] = {
    [sym__gap] = STATE(103),
    [sym_dis_expr] = STATE(103),
    [sym__form] = STATE(355),
    [sym_kwd_lit] = STATE(355),
    [sym_str_lit] = STATE(355),
    [sym_sym_lit] = STATE(355),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(355),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(355),
    [sym__bare_map_lit] = STATE(403),
    [sym_vec_lit] = STATE(355),
    [sym__bare_vec_lit] = STATE(423),
    [sym_set_lit] = STATE(355),
    [sym__bare_set_lit] = STATE(374),
    [sym_anon_fn_lit] = STATE(355),
    [sym_regex_lit] = STATE(355),
    [sym_read_cond_lit] = STATE(355),
    [sym_splicing_read_cond_lit] = STATE(355),
    [sym_ns_map_lit] = STATE(355),
    [sym_var_quoting_lit] = STATE(355),
    [sym_sym_val_lit] = STATE(355),
    [sym_evaling_lit] = STATE(355),
    [sym_tagged_or_ctor_lit] = STATE(355),
    [sym_derefing_lit] = STATE(355),
    [sym_quoting_lit] = STATE(355),
    [sym_syn_quoting_lit] = STATE(355),
    [sym_unquote_splicing_lit] = STATE(355),
    [sym_unquoting_lit] = STATE(355),
    [aux_sym_dis_expr_repeat1] = STATE(103),
    [aux_sym_sym_lit_repeat1] = STATE(304),
    [sym__ws] = ACTIONS(702),
    [sym_comment] = ACTIONS(702),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(528),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(270),
    [anon_sym_COLON_COLON] = ACTIONS(272),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(528),
    [sym_nil_lit] = ACTIONS(530),
    [sym_bool_lit] = ACTIONS(530),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(286),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(292),
    [anon_sym_POUND_POUND] = ACTIONS(294),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(298),
    [anon_sym_SQUOTE] = ACTIONS(300),
    [anon_sym_BQUOTE] = ACTIONS(302),
    [anon_sym_TILDE_AT] = ACTIONS(304),
    [anon_sym_TILDE] = ACTIONS(306),
  },
  [117] = {
    [sym__gap] = STATE(301),
    [sym_dis_expr] = STATE(301),
    [sym__form] = STATE(335),
    [sym_kwd_lit] = STATE(335),
    [sym_str_lit] = STATE(335),
    [sym_sym_lit] = STATE(335),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(335),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(335),
    [sym__bare_map_lit] = STATE(403),
    [sym_vec_lit] = STATE(335),
    [sym__bare_vec_lit] = STATE(423),
    [sym_set_lit] = STATE(335),
    [sym__bare_set_lit] = STATE(374),
    [sym_anon_fn_lit] = STATE(335),
    [sym_regex_lit] = STATE(335),
    [sym_read_cond_lit] = STATE(335),
    [sym_splicing_read_cond_lit] = STATE(335),
    [sym_ns_map_lit] = STATE(335),
    [sym_var_quoting_lit] = STATE(335),
    [sym_sym_val_lit] = STATE(335),
    [sym_evaling_lit] = STATE(335),
    [sym_tagged_or_ctor_lit] = STATE(335),
    [sym_derefing_lit] = STATE(335),
    [sym_quoting_lit] = STATE(335),
    [sym_syn_quoting_lit] = STATE(335),
    [sym_unquote_splicing_lit] = STATE(335),
    [sym_unquoting_lit] = STATE(335),
    [aux_sym_dis_expr_repeat1] = STATE(301),
    [aux_sym_sym_lit_repeat1] = STATE(307),
    [sym__ws] = ACTIONS(264),
    [sym_comment] = ACTIONS(264),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(608),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(352),
    [anon_sym_COLON_COLON] = ACTIONS(354),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(608),
    [sym_nil_lit] = ACTIONS(610),
    [sym_bool_lit] = ACTIONS(610),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(358),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(360),
    [anon_sym_POUND_POUND] = ACTIONS(362),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(364),
    [anon_sym_SQUOTE] = ACTIONS(366),
    [anon_sym_BQUOTE] = ACTIONS(368),
    [anon_sym_TILDE_AT] = ACTIONS(370),
    [anon_sym_TILDE] = ACTIONS(372),
  },
  [118] = {
    [sym__gap] = STATE(65),
    [sym_dis_expr] = STATE(65),
    [sym__form] = STATE(240),
    [sym_kwd_lit] = STATE(240),
    [sym_str_lit] = STATE(240),
    [sym_sym_lit] = STATE(240),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(240),
    [sym__bare_list_lit] = STATE(218),
    [sym_map_lit] = STATE(240),
    [sym__bare_map_lit] = STATE(219),
    [sym_vec_lit] = STATE(240),
    [sym__bare_vec_lit] = STATE(226),
    [sym_set_lit] = STATE(240),
    [sym__bare_set_lit] = STATE(227),
    [sym_anon_fn_lit] = STATE(240),
    [sym_regex_lit] = STATE(240),
    [sym_read_cond_lit] = STATE(240),
    [sym_splicing_read_cond_lit] = STATE(240),
    [sym_ns_map_lit] = STATE(240),
    [sym_var_quoting_lit] = STATE(240),
    [sym_sym_val_lit] = STATE(240),
    [sym_evaling_lit] = STATE(240),
    [sym_tagged_or_ctor_lit] = STATE(240),
    [sym_derefing_lit] = STATE(240),
    [sym_quoting_lit] = STATE(240),
    [sym_syn_quoting_lit] = STATE(240),
    [sym_unquote_splicing_lit] = STATE(240),
    [sym_unquoting_lit] = STATE(240),
    [aux_sym_dis_expr_repeat1] = STATE(65),
    [aux_sym_sym_lit_repeat1] = STATE(305),
    [sym__ws] = ACTIONS(704),
    [sym_comment] = ACTIONS(704),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(706),
    [anon_sym_SLASH] = ACTIONS(9),
    [anon_sym_COLON] = ACTIONS(11),
    [anon_sym_COLON_COLON] = ACTIONS(13),
    [aux_sym_str_lit_token1] = ACTIONS(15),
    [sym_char_lit] = ACTIONS(706),
    [sym_nil_lit] = ACTIONS(708),
    [sym_bool_lit] = ACTIONS(708),
    [aux_sym__sym_qualified_token1] = ACTIONS(19),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_POUND] = ACTIONS(31),
    [anon_sym_POUND_QMARK] = ACTIONS(33),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(35),
    [anon_sym_POUND_SQUOTE] = ACTIONS(37),
    [anon_sym_POUND_POUND] = ACTIONS(39),
    [anon_sym_POUND_EQ] = ACTIONS(41),
    [anon_sym_AT] = ACTIONS(43),
    [anon_sym_SQUOTE] = ACTIONS(45),
    [anon_sym_BQUOTE] = ACTIONS(47),
    [anon_sym_TILDE_AT] = ACTIONS(49),
    [anon_sym_TILDE] = ACTIONS(51),
  },
  [119] = {
    [sym__gap] = STATE(301),
    [sym_dis_expr] = STATE(301),
    [sym__form] = STATE(350),
    [sym_kwd_lit] = STATE(350),
    [sym_str_lit] = STATE(350),
    [sym_sym_lit] = STATE(350),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(350),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(350),
    [sym__bare_map_lit] = STATE(403),
    [sym_vec_lit] = STATE(350),
    [sym__bare_vec_lit] = STATE(423),
    [sym_set_lit] = STATE(350),
    [sym__bare_set_lit] = STATE(374),
    [sym_anon_fn_lit] = STATE(350),
    [sym_regex_lit] = STATE(350),
    [sym_read_cond_lit] = STATE(350),
    [sym_splicing_read_cond_lit] = STATE(350),
    [sym_ns_map_lit] = STATE(350),
    [sym_var_quoting_lit] = STATE(350),
    [sym_sym_val_lit] = STATE(350),
    [sym_evaling_lit] = STATE(350),
    [sym_tagged_or_ctor_lit] = STATE(350),
    [sym_derefing_lit] = STATE(350),
    [sym_quoting_lit] = STATE(350),
    [sym_syn_quoting_lit] = STATE(350),
    [sym_unquote_splicing_lit] = STATE(350),
    [sym_unquoting_lit] = STATE(350),
    [aux_sym_dis_expr_repeat1] = STATE(301),
    [aux_sym_sym_lit_repeat1] = STATE(307),
    [sym__ws] = ACTIONS(264),
    [sym_comment] = ACTIONS(264),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(612),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(352),
    [anon_sym_COLON_COLON] = ACTIONS(354),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(612),
    [sym_nil_lit] = ACTIONS(614),
    [sym_bool_lit] = ACTIONS(614),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(358),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(360),
    [anon_sym_POUND_POUND] = ACTIONS(362),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(364),
    [anon_sym_SQUOTE] = ACTIONS(366),
    [anon_sym_BQUOTE] = ACTIONS(368),
    [anon_sym_TILDE_AT] = ACTIONS(370),
    [anon_sym_TILDE] = ACTIONS(372),
  },
  [120] = {
    [sym__gap] = STATE(301),
    [sym_dis_expr] = STATE(301),
    [sym__form] = STATE(399),
    [sym_kwd_lit] = STATE(399),
    [sym_str_lit] = STATE(399),
    [sym_sym_lit] = STATE(399),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(399),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(399),
    [sym__bare_map_lit] = STATE(403),
    [sym_vec_lit] = STATE(399),
    [sym__bare_vec_lit] = STATE(423),
    [sym_set_lit] = STATE(399),
    [sym__bare_set_lit] = STATE(374),
    [sym_anon_fn_lit] = STATE(399),
    [sym_regex_lit] = STATE(399),
    [sym_read_cond_lit] = STATE(399),
    [sym_splicing_read_cond_lit] = STATE(399),
    [sym_ns_map_lit] = STATE(399),
    [sym_var_quoting_lit] = STATE(399),
    [sym_sym_val_lit] = STATE(399),
    [sym_evaling_lit] = STATE(399),
    [sym_tagged_or_ctor_lit] = STATE(399),
    [sym_derefing_lit] = STATE(399),
    [sym_quoting_lit] = STATE(399),
    [sym_syn_quoting_lit] = STATE(399),
    [sym_unquote_splicing_lit] = STATE(399),
    [sym_unquoting_lit] = STATE(399),
    [aux_sym_dis_expr_repeat1] = STATE(301),
    [aux_sym_sym_lit_repeat1] = STATE(304),
    [sym__ws] = ACTIONS(264),
    [sym_comment] = ACTIONS(264),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(462),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(270),
    [anon_sym_COLON_COLON] = ACTIONS(272),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(462),
    [sym_nil_lit] = ACTIONS(464),
    [sym_bool_lit] = ACTIONS(464),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(286),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(292),
    [anon_sym_POUND_POUND] = ACTIONS(294),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(298),
    [anon_sym_SQUOTE] = ACTIONS(300),
    [anon_sym_BQUOTE] = ACTIONS(302),
    [anon_sym_TILDE_AT] = ACTIONS(304),
    [anon_sym_TILDE] = ACTIONS(306),
  },
  [121] = {
    [sym__gap] = STATE(31),
    [sym_dis_expr] = STATE(31),
    [sym__form] = STATE(363),
    [sym_kwd_lit] = STATE(363),
    [sym_str_lit] = STATE(363),
    [sym_sym_lit] = STATE(363),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(363),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(363),
    [sym__bare_map_lit] = STATE(403),
    [sym_vec_lit] = STATE(363),
    [sym__bare_vec_lit] = STATE(423),
    [sym_set_lit] = STATE(363),
    [sym__bare_set_lit] = STATE(374),
    [sym_anon_fn_lit] = STATE(363),
    [sym_regex_lit] = STATE(363),
    [sym_read_cond_lit] = STATE(363),
    [sym_splicing_read_cond_lit] = STATE(363),
    [sym_ns_map_lit] = STATE(363),
    [sym_var_quoting_lit] = STATE(363),
    [sym_sym_val_lit] = STATE(363),
    [sym_evaling_lit] = STATE(363),
    [sym_tagged_or_ctor_lit] = STATE(363),
    [sym_derefing_lit] = STATE(363),
    [sym_quoting_lit] = STATE(363),
    [sym_syn_quoting_lit] = STATE(363),
    [sym_unquote_splicing_lit] = STATE(363),
    [sym_unquoting_lit] = STATE(363),
    [aux_sym_dis_expr_repeat1] = STATE(31),
    [aux_sym_sym_lit_repeat1] = STATE(304),
    [sym__ws] = ACTIONS(710),
    [sym_comment] = ACTIONS(710),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(546),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(270),
    [anon_sym_COLON_COLON] = ACTIONS(272),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(546),
    [sym_nil_lit] = ACTIONS(548),
    [sym_bool_lit] = ACTIONS(548),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(286),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(292),
    [anon_sym_POUND_POUND] = ACTIONS(294),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(298),
    [anon_sym_SQUOTE] = ACTIONS(300),
    [anon_sym_BQUOTE] = ACTIONS(302),
    [anon_sym_TILDE_AT] = ACTIONS(304),
    [anon_sym_TILDE] = ACTIONS(306),
  },
  [122] = {
    [sym__gap] = STATE(120),
    [sym_dis_expr] = STATE(120),
    [sym__form] = STATE(361),
    [sym_kwd_lit] = STATE(361),
    [sym_str_lit] = STATE(361),
    [sym_sym_lit] = STATE(361),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(361),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(361),
    [sym__bare_map_lit] = STATE(403),
    [sym_vec_lit] = STATE(361),
    [sym__bare_vec_lit] = STATE(423),
    [sym_set_lit] = STATE(361),
    [sym__bare_set_lit] = STATE(374),
    [sym_anon_fn_lit] = STATE(361),
    [sym_regex_lit] = STATE(361),
    [sym_read_cond_lit] = STATE(361),
    [sym_splicing_read_cond_lit] = STATE(361),
    [sym_ns_map_lit] = STATE(361),
    [sym_var_quoting_lit] = STATE(361),
    [sym_sym_val_lit] = STATE(361),
    [sym_evaling_lit] = STATE(361),
    [sym_tagged_or_ctor_lit] = STATE(361),
    [sym_derefing_lit] = STATE(361),
    [sym_quoting_lit] = STATE(361),
    [sym_syn_quoting_lit] = STATE(361),
    [sym_unquote_splicing_lit] = STATE(361),
    [sym_unquoting_lit] = STATE(361),
    [aux_sym_dis_expr_repeat1] = STATE(120),
    [aux_sym_sym_lit_repeat1] = STATE(304),
    [sym__ws] = ACTIONS(712),
    [sym_comment] = ACTIONS(712),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(552),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(270),
    [anon_sym_COLON_COLON] = ACTIONS(272),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(552),
    [sym_nil_lit] = ACTIONS(554),
    [sym_bool_lit] = ACTIONS(554),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(286),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(292),
    [anon_sym_POUND_POUND] = ACTIONS(294),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(298),
    [anon_sym_SQUOTE] = ACTIONS(300),
    [anon_sym_BQUOTE] = ACTIONS(302),
    [anon_sym_TILDE_AT] = ACTIONS(304),
    [anon_sym_TILDE] = ACTIONS(306),
  },
  [123] = {
    [sym__gap] = STATE(167),
    [sym_dis_expr] = STATE(167),
    [sym__form] = STATE(229),
    [sym_kwd_lit] = STATE(229),
    [sym_str_lit] = STATE(229),
    [sym_sym_lit] = STATE(229),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(229),
    [sym__bare_list_lit] = STATE(218),
    [sym_map_lit] = STATE(229),
    [sym__bare_map_lit] = STATE(219),
    [sym_vec_lit] = STATE(229),
    [sym__bare_vec_lit] = STATE(226),
    [sym_set_lit] = STATE(229),
    [sym__bare_set_lit] = STATE(227),
    [sym_anon_fn_lit] = STATE(229),
    [sym_regex_lit] = STATE(229),
    [sym_read_cond_lit] = STATE(229),
    [sym_splicing_read_cond_lit] = STATE(229),
    [sym_ns_map_lit] = STATE(229),
    [sym_var_quoting_lit] = STATE(229),
    [sym_sym_val_lit] = STATE(229),
    [sym_evaling_lit] = STATE(229),
    [sym_tagged_or_ctor_lit] = STATE(229),
    [sym_derefing_lit] = STATE(229),
    [sym_quoting_lit] = STATE(229),
    [sym_syn_quoting_lit] = STATE(229),
    [sym_unquote_splicing_lit] = STATE(229),
    [sym_unquoting_lit] = STATE(229),
    [aux_sym_dis_expr_repeat1] = STATE(167),
    [aux_sym_sym_lit_repeat1] = STATE(303),
    [sym__ws] = ACTIONS(714),
    [sym_comment] = ACTIONS(714),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(672),
    [anon_sym_SLASH] = ACTIONS(9),
    [anon_sym_COLON] = ACTIONS(716),
    [anon_sym_COLON_COLON] = ACTIONS(718),
    [aux_sym_str_lit_token1] = ACTIONS(15),
    [sym_char_lit] = ACTIONS(672),
    [sym_nil_lit] = ACTIONS(674),
    [sym_bool_lit] = ACTIONS(674),
    [aux_sym__sym_qualified_token1] = ACTIONS(19),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_POUND] = ACTIONS(720),
    [anon_sym_POUND_QMARK] = ACTIONS(33),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(35),
    [anon_sym_POUND_SQUOTE] = ACTIONS(722),
    [anon_sym_POUND_POUND] = ACTIONS(724),
    [anon_sym_POUND_EQ] = ACTIONS(41),
    [anon_sym_AT] = ACTIONS(726),
    [anon_sym_SQUOTE] = ACTIONS(728),
    [anon_sym_BQUOTE] = ACTIONS(730),
    [anon_sym_TILDE_AT] = ACTIONS(732),
    [anon_sym_TILDE] = ACTIONS(734),
  },
  [124] = {
    [sym__gap] = STATE(301),
    [sym_dis_expr] = STATE(301),
    [sym__form] = STATE(385),
    [sym_kwd_lit] = STATE(385),
    [sym_str_lit] = STATE(385),
    [sym_sym_lit] = STATE(385),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(385),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(385),
    [sym__bare_map_lit] = STATE(403),
    [sym_vec_lit] = STATE(385),
    [sym__bare_vec_lit] = STATE(423),
    [sym_set_lit] = STATE(385),
    [sym__bare_set_lit] = STATE(374),
    [sym_anon_fn_lit] = STATE(385),
    [sym_regex_lit] = STATE(385),
    [sym_read_cond_lit] = STATE(385),
    [sym_splicing_read_cond_lit] = STATE(385),
    [sym_ns_map_lit] = STATE(385),
    [sym_var_quoting_lit] = STATE(385),
    [sym_sym_val_lit] = STATE(385),
    [sym_evaling_lit] = STATE(385),
    [sym_tagged_or_ctor_lit] = STATE(385),
    [sym_derefing_lit] = STATE(385),
    [sym_quoting_lit] = STATE(385),
    [sym_syn_quoting_lit] = STATE(385),
    [sym_unquote_splicing_lit] = STATE(385),
    [sym_unquoting_lit] = STATE(385),
    [aux_sym_dis_expr_repeat1] = STATE(301),
    [aux_sym_sym_lit_repeat1] = STATE(307),
    [sym__ws] = ACTIONS(264),
    [sym_comment] = ACTIONS(264),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(604),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(352),
    [anon_sym_COLON_COLON] = ACTIONS(354),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(604),
    [sym_nil_lit] = ACTIONS(606),
    [sym_bool_lit] = ACTIONS(606),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(358),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(360),
    [anon_sym_POUND_POUND] = ACTIONS(362),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(364),
    [anon_sym_SQUOTE] = ACTIONS(366),
    [anon_sym_BQUOTE] = ACTIONS(368),
    [anon_sym_TILDE_AT] = ACTIONS(370),
    [anon_sym_TILDE] = ACTIONS(372),
  },
  [125] = {
    [sym__gap] = STATE(301),
    [sym_dis_expr] = STATE(301),
    [sym__form] = STATE(288),
    [sym_kwd_lit] = STATE(288),
    [sym_str_lit] = STATE(288),
    [sym_sym_lit] = STATE(288),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(288),
    [sym__bare_list_lit] = STATE(218),
    [sym_map_lit] = STATE(288),
    [sym__bare_map_lit] = STATE(219),
    [sym_vec_lit] = STATE(288),
    [sym__bare_vec_lit] = STATE(226),
    [sym_set_lit] = STATE(288),
    [sym__bare_set_lit] = STATE(227),
    [sym_anon_fn_lit] = STATE(288),
    [sym_regex_lit] = STATE(288),
    [sym_read_cond_lit] = STATE(288),
    [sym_splicing_read_cond_lit] = STATE(288),
    [sym_ns_map_lit] = STATE(288),
    [sym_var_quoting_lit] = STATE(288),
    [sym_sym_val_lit] = STATE(288),
    [sym_evaling_lit] = STATE(288),
    [sym_tagged_or_ctor_lit] = STATE(288),
    [sym_derefing_lit] = STATE(288),
    [sym_quoting_lit] = STATE(288),
    [sym_syn_quoting_lit] = STATE(288),
    [sym_unquote_splicing_lit] = STATE(288),
    [sym_unquoting_lit] = STATE(288),
    [aux_sym_dis_expr_repeat1] = STATE(301),
    [aux_sym_sym_lit_repeat1] = STATE(303),
    [sym__ws] = ACTIONS(264),
    [sym_comment] = ACTIONS(264),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(736),
    [anon_sym_SLASH] = ACTIONS(9),
    [anon_sym_COLON] = ACTIONS(716),
    [anon_sym_COLON_COLON] = ACTIONS(718),
    [aux_sym_str_lit_token1] = ACTIONS(15),
    [sym_char_lit] = ACTIONS(736),
    [sym_nil_lit] = ACTIONS(738),
    [sym_bool_lit] = ACTIONS(738),
    [aux_sym__sym_qualified_token1] = ACTIONS(19),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_POUND] = ACTIONS(720),
    [anon_sym_POUND_QMARK] = ACTIONS(33),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(35),
    [anon_sym_POUND_SQUOTE] = ACTIONS(722),
    [anon_sym_POUND_POUND] = ACTIONS(724),
    [anon_sym_POUND_EQ] = ACTIONS(41),
    [anon_sym_AT] = ACTIONS(726),
    [anon_sym_SQUOTE] = ACTIONS(728),
    [anon_sym_BQUOTE] = ACTIONS(730),
    [anon_sym_TILDE_AT] = ACTIONS(732),
    [anon_sym_TILDE] = ACTIONS(734),
  },
  [126] = {
    [sym__gap] = STATE(125),
    [sym_dis_expr] = STATE(125),
    [sym__form] = STATE(292),
    [sym_kwd_lit] = STATE(292),
    [sym_str_lit] = STATE(292),
    [sym_sym_lit] = STATE(292),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(292),
    [sym__bare_list_lit] = STATE(218),
    [sym_map_lit] = STATE(292),
    [sym__bare_map_lit] = STATE(219),
    [sym_vec_lit] = STATE(292),
    [sym__bare_vec_lit] = STATE(226),
    [sym_set_lit] = STATE(292),
    [sym__bare_set_lit] = STATE(227),
    [sym_anon_fn_lit] = STATE(292),
    [sym_regex_lit] = STATE(292),
    [sym_read_cond_lit] = STATE(292),
    [sym_splicing_read_cond_lit] = STATE(292),
    [sym_ns_map_lit] = STATE(292),
    [sym_var_quoting_lit] = STATE(292),
    [sym_sym_val_lit] = STATE(292),
    [sym_evaling_lit] = STATE(292),
    [sym_tagged_or_ctor_lit] = STATE(292),
    [sym_derefing_lit] = STATE(292),
    [sym_quoting_lit] = STATE(292),
    [sym_syn_quoting_lit] = STATE(292),
    [sym_unquote_splicing_lit] = STATE(292),
    [sym_unquoting_lit] = STATE(292),
    [aux_sym_dis_expr_repeat1] = STATE(125),
    [aux_sym_sym_lit_repeat1] = STATE(303),
    [sym__ws] = ACTIONS(740),
    [sym_comment] = ACTIONS(740),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(742),
    [anon_sym_SLASH] = ACTIONS(9),
    [anon_sym_COLON] = ACTIONS(716),
    [anon_sym_COLON_COLON] = ACTIONS(718),
    [aux_sym_str_lit_token1] = ACTIONS(15),
    [sym_char_lit] = ACTIONS(742),
    [sym_nil_lit] = ACTIONS(744),
    [sym_bool_lit] = ACTIONS(744),
    [aux_sym__sym_qualified_token1] = ACTIONS(19),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_POUND] = ACTIONS(720),
    [anon_sym_POUND_QMARK] = ACTIONS(33),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(35),
    [anon_sym_POUND_SQUOTE] = ACTIONS(722),
    [anon_sym_POUND_POUND] = ACTIONS(724),
    [anon_sym_POUND_EQ] = ACTIONS(41),
    [anon_sym_AT] = ACTIONS(726),
    [anon_sym_SQUOTE] = ACTIONS(728),
    [anon_sym_BQUOTE] = ACTIONS(730),
    [anon_sym_TILDE_AT] = ACTIONS(732),
    [anon_sym_TILDE] = ACTIONS(734),
  },
  [127] = {
    [sym__gap] = STATE(301),
    [sym_dis_expr] = STATE(301),
    [sym__form] = STATE(225),
    [sym_kwd_lit] = STATE(225),
    [sym_str_lit] = STATE(225),
    [sym_sym_lit] = STATE(225),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(225),
    [sym__bare_list_lit] = STATE(218),
    [sym_map_lit] = STATE(225),
    [sym__bare_map_lit] = STATE(219),
    [sym_vec_lit] = STATE(225),
    [sym__bare_vec_lit] = STATE(226),
    [sym_set_lit] = STATE(225),
    [sym__bare_set_lit] = STATE(227),
    [sym_anon_fn_lit] = STATE(225),
    [sym_regex_lit] = STATE(225),
    [sym_read_cond_lit] = STATE(225),
    [sym_splicing_read_cond_lit] = STATE(225),
    [sym_ns_map_lit] = STATE(225),
    [sym_var_quoting_lit] = STATE(225),
    [sym_sym_val_lit] = STATE(225),
    [sym_evaling_lit] = STATE(225),
    [sym_tagged_or_ctor_lit] = STATE(225),
    [sym_derefing_lit] = STATE(225),
    [sym_quoting_lit] = STATE(225),
    [sym_syn_quoting_lit] = STATE(225),
    [sym_unquote_splicing_lit] = STATE(225),
    [sym_unquoting_lit] = STATE(225),
    [aux_sym_dis_expr_repeat1] = STATE(301),
    [aux_sym_sym_lit_repeat1] = STATE(303),
    [sym__ws] = ACTIONS(264),
    [sym_comment] = ACTIONS(264),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(746),
    [anon_sym_SLASH] = ACTIONS(9),
    [anon_sym_COLON] = ACTIONS(716),
    [anon_sym_COLON_COLON] = ACTIONS(718),
    [aux_sym_str_lit_token1] = ACTIONS(15),
    [sym_char_lit] = ACTIONS(746),
    [sym_nil_lit] = ACTIONS(748),
    [sym_bool_lit] = ACTIONS(748),
    [aux_sym__sym_qualified_token1] = ACTIONS(19),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_POUND] = ACTIONS(720),
    [anon_sym_POUND_QMARK] = ACTIONS(33),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(35),
    [anon_sym_POUND_SQUOTE] = ACTIONS(722),
    [anon_sym_POUND_POUND] = ACTIONS(724),
    [anon_sym_POUND_EQ] = ACTIONS(41),
    [anon_sym_AT] = ACTIONS(726),
    [anon_sym_SQUOTE] = ACTIONS(728),
    [anon_sym_BQUOTE] = ACTIONS(730),
    [anon_sym_TILDE_AT] = ACTIONS(732),
    [anon_sym_TILDE] = ACTIONS(734),
  },
  [128] = {
    [sym__gap] = STATE(301),
    [sym_dis_expr] = STATE(301),
    [sym__form] = STATE(265),
    [sym_kwd_lit] = STATE(265),
    [sym_str_lit] = STATE(265),
    [sym_sym_lit] = STATE(265),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(265),
    [sym__bare_list_lit] = STATE(218),
    [sym_map_lit] = STATE(265),
    [sym__bare_map_lit] = STATE(219),
    [sym_vec_lit] = STATE(265),
    [sym__bare_vec_lit] = STATE(226),
    [sym_set_lit] = STATE(265),
    [sym__bare_set_lit] = STATE(227),
    [sym_anon_fn_lit] = STATE(265),
    [sym_regex_lit] = STATE(265),
    [sym_read_cond_lit] = STATE(265),
    [sym_splicing_read_cond_lit] = STATE(265),
    [sym_ns_map_lit] = STATE(265),
    [sym_var_quoting_lit] = STATE(265),
    [sym_sym_val_lit] = STATE(265),
    [sym_evaling_lit] = STATE(265),
    [sym_tagged_or_ctor_lit] = STATE(265),
    [sym_derefing_lit] = STATE(265),
    [sym_quoting_lit] = STATE(265),
    [sym_syn_quoting_lit] = STATE(265),
    [sym_unquote_splicing_lit] = STATE(265),
    [sym_unquoting_lit] = STATE(265),
    [aux_sym_dis_expr_repeat1] = STATE(301),
    [aux_sym_sym_lit_repeat1] = STATE(303),
    [sym__ws] = ACTIONS(264),
    [sym_comment] = ACTIONS(264),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(750),
    [anon_sym_SLASH] = ACTIONS(9),
    [anon_sym_COLON] = ACTIONS(716),
    [anon_sym_COLON_COLON] = ACTIONS(718),
    [aux_sym_str_lit_token1] = ACTIONS(15),
    [sym_char_lit] = ACTIONS(750),
    [sym_nil_lit] = ACTIONS(752),
    [sym_bool_lit] = ACTIONS(752),
    [aux_sym__sym_qualified_token1] = ACTIONS(19),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_POUND] = ACTIONS(720),
    [anon_sym_POUND_QMARK] = ACTIONS(33),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(35),
    [anon_sym_POUND_SQUOTE] = ACTIONS(722),
    [anon_sym_POUND_POUND] = ACTIONS(724),
    [anon_sym_POUND_EQ] = ACTIONS(41),
    [anon_sym_AT] = ACTIONS(726),
    [anon_sym_SQUOTE] = ACTIONS(728),
    [anon_sym_BQUOTE] = ACTIONS(730),
    [anon_sym_TILDE_AT] = ACTIONS(732),
    [anon_sym_TILDE] = ACTIONS(734),
  },
  [129] = {
    [sym__gap] = STATE(163),
    [sym_dis_expr] = STATE(163),
    [sym__form] = STATE(222),
    [sym_kwd_lit] = STATE(222),
    [sym_str_lit] = STATE(222),
    [sym_sym_lit] = STATE(222),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(222),
    [sym__bare_list_lit] = STATE(218),
    [sym_map_lit] = STATE(222),
    [sym__bare_map_lit] = STATE(219),
    [sym_vec_lit] = STATE(222),
    [sym__bare_vec_lit] = STATE(226),
    [sym_set_lit] = STATE(222),
    [sym__bare_set_lit] = STATE(227),
    [sym_anon_fn_lit] = STATE(222),
    [sym_regex_lit] = STATE(222),
    [sym_read_cond_lit] = STATE(222),
    [sym_splicing_read_cond_lit] = STATE(222),
    [sym_ns_map_lit] = STATE(222),
    [sym_var_quoting_lit] = STATE(222),
    [sym_sym_val_lit] = STATE(222),
    [sym_evaling_lit] = STATE(222),
    [sym_tagged_or_ctor_lit] = STATE(222),
    [sym_derefing_lit] = STATE(222),
    [sym_quoting_lit] = STATE(222),
    [sym_syn_quoting_lit] = STATE(222),
    [sym_unquote_splicing_lit] = STATE(222),
    [sym_unquoting_lit] = STATE(222),
    [aux_sym_dis_expr_repeat1] = STATE(163),
    [aux_sym_sym_lit_repeat1] = STATE(305),
    [sym__ws] = ACTIONS(754),
    [sym_comment] = ACTIONS(754),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(756),
    [anon_sym_SLASH] = ACTIONS(9),
    [anon_sym_COLON] = ACTIONS(11),
    [anon_sym_COLON_COLON] = ACTIONS(13),
    [aux_sym_str_lit_token1] = ACTIONS(15),
    [sym_char_lit] = ACTIONS(756),
    [sym_nil_lit] = ACTIONS(758),
    [sym_bool_lit] = ACTIONS(758),
    [aux_sym__sym_qualified_token1] = ACTIONS(19),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_POUND] = ACTIONS(31),
    [anon_sym_POUND_QMARK] = ACTIONS(33),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(35),
    [anon_sym_POUND_SQUOTE] = ACTIONS(37),
    [anon_sym_POUND_POUND] = ACTIONS(39),
    [anon_sym_POUND_EQ] = ACTIONS(41),
    [anon_sym_AT] = ACTIONS(43),
    [anon_sym_SQUOTE] = ACTIONS(45),
    [anon_sym_BQUOTE] = ACTIONS(47),
    [anon_sym_TILDE_AT] = ACTIONS(49),
    [anon_sym_TILDE] = ACTIONS(51),
  },
  [130] = {
    [sym__gap] = STATE(301),
    [sym_dis_expr] = STATE(301),
    [sym__form] = STATE(300),
    [sym_kwd_lit] = STATE(300),
    [sym_str_lit] = STATE(300),
    [sym_sym_lit] = STATE(300),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(300),
    [sym__bare_list_lit] = STATE(218),
    [sym_map_lit] = STATE(300),
    [sym__bare_map_lit] = STATE(219),
    [sym_vec_lit] = STATE(300),
    [sym__bare_vec_lit] = STATE(226),
    [sym_set_lit] = STATE(300),
    [sym__bare_set_lit] = STATE(227),
    [sym_anon_fn_lit] = STATE(300),
    [sym_regex_lit] = STATE(300),
    [sym_read_cond_lit] = STATE(300),
    [sym_splicing_read_cond_lit] = STATE(300),
    [sym_ns_map_lit] = STATE(300),
    [sym_var_quoting_lit] = STATE(300),
    [sym_sym_val_lit] = STATE(300),
    [sym_evaling_lit] = STATE(300),
    [sym_tagged_or_ctor_lit] = STATE(300),
    [sym_derefing_lit] = STATE(300),
    [sym_quoting_lit] = STATE(300),
    [sym_syn_quoting_lit] = STATE(300),
    [sym_unquote_splicing_lit] = STATE(300),
    [sym_unquoting_lit] = STATE(300),
    [aux_sym_dis_expr_repeat1] = STATE(301),
    [aux_sym_sym_lit_repeat1] = STATE(303),
    [sym__ws] = ACTIONS(264),
    [sym_comment] = ACTIONS(264),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(760),
    [anon_sym_SLASH] = ACTIONS(9),
    [anon_sym_COLON] = ACTIONS(716),
    [anon_sym_COLON_COLON] = ACTIONS(718),
    [aux_sym_str_lit_token1] = ACTIONS(15),
    [sym_char_lit] = ACTIONS(760),
    [sym_nil_lit] = ACTIONS(762),
    [sym_bool_lit] = ACTIONS(762),
    [aux_sym__sym_qualified_token1] = ACTIONS(19),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_POUND] = ACTIONS(720),
    [anon_sym_POUND_QMARK] = ACTIONS(33),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(35),
    [anon_sym_POUND_SQUOTE] = ACTIONS(722),
    [anon_sym_POUND_POUND] = ACTIONS(724),
    [anon_sym_POUND_EQ] = ACTIONS(41),
    [anon_sym_AT] = ACTIONS(726),
    [anon_sym_SQUOTE] = ACTIONS(728),
    [anon_sym_BQUOTE] = ACTIONS(730),
    [anon_sym_TILDE_AT] = ACTIONS(732),
    [anon_sym_TILDE] = ACTIONS(734),
  },
  [131] = {
    [sym__gap] = STATE(301),
    [sym_dis_expr] = STATE(301),
    [sym__form] = STATE(274),
    [sym_kwd_lit] = STATE(274),
    [sym_str_lit] = STATE(274),
    [sym_sym_lit] = STATE(274),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(274),
    [sym__bare_list_lit] = STATE(218),
    [sym_map_lit] = STATE(274),
    [sym__bare_map_lit] = STATE(219),
    [sym_vec_lit] = STATE(274),
    [sym__bare_vec_lit] = STATE(226),
    [sym_set_lit] = STATE(274),
    [sym__bare_set_lit] = STATE(227),
    [sym_anon_fn_lit] = STATE(274),
    [sym_regex_lit] = STATE(274),
    [sym_read_cond_lit] = STATE(274),
    [sym_splicing_read_cond_lit] = STATE(274),
    [sym_ns_map_lit] = STATE(274),
    [sym_var_quoting_lit] = STATE(274),
    [sym_sym_val_lit] = STATE(274),
    [sym_evaling_lit] = STATE(274),
    [sym_tagged_or_ctor_lit] = STATE(274),
    [sym_derefing_lit] = STATE(274),
    [sym_quoting_lit] = STATE(274),
    [sym_syn_quoting_lit] = STATE(274),
    [sym_unquote_splicing_lit] = STATE(274),
    [sym_unquoting_lit] = STATE(274),
    [aux_sym_dis_expr_repeat1] = STATE(301),
    [aux_sym_sym_lit_repeat1] = STATE(303),
    [sym__ws] = ACTIONS(264),
    [sym_comment] = ACTIONS(264),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(764),
    [anon_sym_SLASH] = ACTIONS(9),
    [anon_sym_COLON] = ACTIONS(716),
    [anon_sym_COLON_COLON] = ACTIONS(718),
    [aux_sym_str_lit_token1] = ACTIONS(15),
    [sym_char_lit] = ACTIONS(764),
    [sym_nil_lit] = ACTIONS(766),
    [sym_bool_lit] = ACTIONS(766),
    [aux_sym__sym_qualified_token1] = ACTIONS(19),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_POUND] = ACTIONS(720),
    [anon_sym_POUND_QMARK] = ACTIONS(33),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(35),
    [anon_sym_POUND_SQUOTE] = ACTIONS(722),
    [anon_sym_POUND_POUND] = ACTIONS(724),
    [anon_sym_POUND_EQ] = ACTIONS(41),
    [anon_sym_AT] = ACTIONS(726),
    [anon_sym_SQUOTE] = ACTIONS(728),
    [anon_sym_BQUOTE] = ACTIONS(730),
    [anon_sym_TILDE_AT] = ACTIONS(732),
    [anon_sym_TILDE] = ACTIONS(734),
  },
  [132] = {
    [sym__gap] = STATE(301),
    [sym_dis_expr] = STATE(301),
    [sym__form] = STATE(250),
    [sym_kwd_lit] = STATE(250),
    [sym_str_lit] = STATE(250),
    [sym_sym_lit] = STATE(250),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(250),
    [sym__bare_list_lit] = STATE(218),
    [sym_map_lit] = STATE(250),
    [sym__bare_map_lit] = STATE(219),
    [sym_vec_lit] = STATE(250),
    [sym__bare_vec_lit] = STATE(226),
    [sym_set_lit] = STATE(250),
    [sym__bare_set_lit] = STATE(227),
    [sym_anon_fn_lit] = STATE(250),
    [sym_regex_lit] = STATE(250),
    [sym_read_cond_lit] = STATE(250),
    [sym_splicing_read_cond_lit] = STATE(250),
    [sym_ns_map_lit] = STATE(250),
    [sym_var_quoting_lit] = STATE(250),
    [sym_sym_val_lit] = STATE(250),
    [sym_evaling_lit] = STATE(250),
    [sym_tagged_or_ctor_lit] = STATE(250),
    [sym_derefing_lit] = STATE(250),
    [sym_quoting_lit] = STATE(250),
    [sym_syn_quoting_lit] = STATE(250),
    [sym_unquote_splicing_lit] = STATE(250),
    [sym_unquoting_lit] = STATE(250),
    [aux_sym_dis_expr_repeat1] = STATE(301),
    [aux_sym_sym_lit_repeat1] = STATE(303),
    [sym__ws] = ACTIONS(264),
    [sym_comment] = ACTIONS(264),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(768),
    [anon_sym_SLASH] = ACTIONS(9),
    [anon_sym_COLON] = ACTIONS(716),
    [anon_sym_COLON_COLON] = ACTIONS(718),
    [aux_sym_str_lit_token1] = ACTIONS(15),
    [sym_char_lit] = ACTIONS(768),
    [sym_nil_lit] = ACTIONS(770),
    [sym_bool_lit] = ACTIONS(770),
    [aux_sym__sym_qualified_token1] = ACTIONS(19),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_POUND] = ACTIONS(720),
    [anon_sym_POUND_QMARK] = ACTIONS(33),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(35),
    [anon_sym_POUND_SQUOTE] = ACTIONS(722),
    [anon_sym_POUND_POUND] = ACTIONS(724),
    [anon_sym_POUND_EQ] = ACTIONS(41),
    [anon_sym_AT] = ACTIONS(726),
    [anon_sym_SQUOTE] = ACTIONS(728),
    [anon_sym_BQUOTE] = ACTIONS(730),
    [anon_sym_TILDE_AT] = ACTIONS(732),
    [anon_sym_TILDE] = ACTIONS(734),
  },
  [133] = {
    [sym__gap] = STATE(301),
    [sym_dis_expr] = STATE(301),
    [sym__form] = STATE(249),
    [sym_kwd_lit] = STATE(249),
    [sym_str_lit] = STATE(249),
    [sym_sym_lit] = STATE(249),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(249),
    [sym__bare_list_lit] = STATE(218),
    [sym_map_lit] = STATE(249),
    [sym__bare_map_lit] = STATE(219),
    [sym_vec_lit] = STATE(249),
    [sym__bare_vec_lit] = STATE(226),
    [sym_set_lit] = STATE(249),
    [sym__bare_set_lit] = STATE(227),
    [sym_anon_fn_lit] = STATE(249),
    [sym_regex_lit] = STATE(249),
    [sym_read_cond_lit] = STATE(249),
    [sym_splicing_read_cond_lit] = STATE(249),
    [sym_ns_map_lit] = STATE(249),
    [sym_var_quoting_lit] = STATE(249),
    [sym_sym_val_lit] = STATE(249),
    [sym_evaling_lit] = STATE(249),
    [sym_tagged_or_ctor_lit] = STATE(249),
    [sym_derefing_lit] = STATE(249),
    [sym_quoting_lit] = STATE(249),
    [sym_syn_quoting_lit] = STATE(249),
    [sym_unquote_splicing_lit] = STATE(249),
    [sym_unquoting_lit] = STATE(249),
    [aux_sym_dis_expr_repeat1] = STATE(301),
    [aux_sym_sym_lit_repeat1] = STATE(303),
    [sym__ws] = ACTIONS(264),
    [sym_comment] = ACTIONS(264),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(772),
    [anon_sym_SLASH] = ACTIONS(9),
    [anon_sym_COLON] = ACTIONS(716),
    [anon_sym_COLON_COLON] = ACTIONS(718),
    [aux_sym_str_lit_token1] = ACTIONS(15),
    [sym_char_lit] = ACTIONS(772),
    [sym_nil_lit] = ACTIONS(774),
    [sym_bool_lit] = ACTIONS(774),
    [aux_sym__sym_qualified_token1] = ACTIONS(19),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_POUND] = ACTIONS(720),
    [anon_sym_POUND_QMARK] = ACTIONS(33),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(35),
    [anon_sym_POUND_SQUOTE] = ACTIONS(722),
    [anon_sym_POUND_POUND] = ACTIONS(724),
    [anon_sym_POUND_EQ] = ACTIONS(41),
    [anon_sym_AT] = ACTIONS(726),
    [anon_sym_SQUOTE] = ACTIONS(728),
    [anon_sym_BQUOTE] = ACTIONS(730),
    [anon_sym_TILDE_AT] = ACTIONS(732),
    [anon_sym_TILDE] = ACTIONS(734),
  },
  [134] = {
    [sym__gap] = STATE(301),
    [sym_dis_expr] = STATE(301),
    [sym__form] = STATE(243),
    [sym_kwd_lit] = STATE(243),
    [sym_str_lit] = STATE(243),
    [sym_sym_lit] = STATE(243),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(243),
    [sym__bare_list_lit] = STATE(218),
    [sym_map_lit] = STATE(243),
    [sym__bare_map_lit] = STATE(219),
    [sym_vec_lit] = STATE(243),
    [sym__bare_vec_lit] = STATE(226),
    [sym_set_lit] = STATE(243),
    [sym__bare_set_lit] = STATE(227),
    [sym_anon_fn_lit] = STATE(243),
    [sym_regex_lit] = STATE(243),
    [sym_read_cond_lit] = STATE(243),
    [sym_splicing_read_cond_lit] = STATE(243),
    [sym_ns_map_lit] = STATE(243),
    [sym_var_quoting_lit] = STATE(243),
    [sym_sym_val_lit] = STATE(243),
    [sym_evaling_lit] = STATE(243),
    [sym_tagged_or_ctor_lit] = STATE(243),
    [sym_derefing_lit] = STATE(243),
    [sym_quoting_lit] = STATE(243),
    [sym_syn_quoting_lit] = STATE(243),
    [sym_unquote_splicing_lit] = STATE(243),
    [sym_unquoting_lit] = STATE(243),
    [aux_sym_dis_expr_repeat1] = STATE(301),
    [aux_sym_sym_lit_repeat1] = STATE(303),
    [sym__ws] = ACTIONS(264),
    [sym_comment] = ACTIONS(264),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(776),
    [anon_sym_SLASH] = ACTIONS(9),
    [anon_sym_COLON] = ACTIONS(716),
    [anon_sym_COLON_COLON] = ACTIONS(718),
    [aux_sym_str_lit_token1] = ACTIONS(15),
    [sym_char_lit] = ACTIONS(776),
    [sym_nil_lit] = ACTIONS(778),
    [sym_bool_lit] = ACTIONS(778),
    [aux_sym__sym_qualified_token1] = ACTIONS(19),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_POUND] = ACTIONS(720),
    [anon_sym_POUND_QMARK] = ACTIONS(33),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(35),
    [anon_sym_POUND_SQUOTE] = ACTIONS(722),
    [anon_sym_POUND_POUND] = ACTIONS(724),
    [anon_sym_POUND_EQ] = ACTIONS(41),
    [anon_sym_AT] = ACTIONS(726),
    [anon_sym_SQUOTE] = ACTIONS(728),
    [anon_sym_BQUOTE] = ACTIONS(730),
    [anon_sym_TILDE_AT] = ACTIONS(732),
    [anon_sym_TILDE] = ACTIONS(734),
  },
  [135] = {
    [sym__gap] = STATE(301),
    [sym_dis_expr] = STATE(301),
    [sym__form] = STATE(224),
    [sym_kwd_lit] = STATE(224),
    [sym_str_lit] = STATE(224),
    [sym_sym_lit] = STATE(224),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(224),
    [sym__bare_list_lit] = STATE(218),
    [sym_map_lit] = STATE(224),
    [sym__bare_map_lit] = STATE(219),
    [sym_vec_lit] = STATE(224),
    [sym__bare_vec_lit] = STATE(226),
    [sym_set_lit] = STATE(224),
    [sym__bare_set_lit] = STATE(227),
    [sym_anon_fn_lit] = STATE(224),
    [sym_regex_lit] = STATE(224),
    [sym_read_cond_lit] = STATE(224),
    [sym_splicing_read_cond_lit] = STATE(224),
    [sym_ns_map_lit] = STATE(224),
    [sym_var_quoting_lit] = STATE(224),
    [sym_sym_val_lit] = STATE(224),
    [sym_evaling_lit] = STATE(224),
    [sym_tagged_or_ctor_lit] = STATE(224),
    [sym_derefing_lit] = STATE(224),
    [sym_quoting_lit] = STATE(224),
    [sym_syn_quoting_lit] = STATE(224),
    [sym_unquote_splicing_lit] = STATE(224),
    [sym_unquoting_lit] = STATE(224),
    [aux_sym_dis_expr_repeat1] = STATE(301),
    [aux_sym_sym_lit_repeat1] = STATE(303),
    [sym__ws] = ACTIONS(264),
    [sym_comment] = ACTIONS(264),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(780),
    [anon_sym_SLASH] = ACTIONS(9),
    [anon_sym_COLON] = ACTIONS(716),
    [anon_sym_COLON_COLON] = ACTIONS(718),
    [aux_sym_str_lit_token1] = ACTIONS(15),
    [sym_char_lit] = ACTIONS(780),
    [sym_nil_lit] = ACTIONS(782),
    [sym_bool_lit] = ACTIONS(782),
    [aux_sym__sym_qualified_token1] = ACTIONS(19),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_POUND] = ACTIONS(720),
    [anon_sym_POUND_QMARK] = ACTIONS(33),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(35),
    [anon_sym_POUND_SQUOTE] = ACTIONS(722),
    [anon_sym_POUND_POUND] = ACTIONS(724),
    [anon_sym_POUND_EQ] = ACTIONS(41),
    [anon_sym_AT] = ACTIONS(726),
    [anon_sym_SQUOTE] = ACTIONS(728),
    [anon_sym_BQUOTE] = ACTIONS(730),
    [anon_sym_TILDE_AT] = ACTIONS(732),
    [anon_sym_TILDE] = ACTIONS(734),
  },
  [136] = {
    [sym__gap] = STATE(127),
    [sym_dis_expr] = STATE(127),
    [sym__form] = STATE(222),
    [sym_kwd_lit] = STATE(222),
    [sym_str_lit] = STATE(222),
    [sym_sym_lit] = STATE(222),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(222),
    [sym__bare_list_lit] = STATE(218),
    [sym_map_lit] = STATE(222),
    [sym__bare_map_lit] = STATE(219),
    [sym_vec_lit] = STATE(222),
    [sym__bare_vec_lit] = STATE(226),
    [sym_set_lit] = STATE(222),
    [sym__bare_set_lit] = STATE(227),
    [sym_anon_fn_lit] = STATE(222),
    [sym_regex_lit] = STATE(222),
    [sym_read_cond_lit] = STATE(222),
    [sym_splicing_read_cond_lit] = STATE(222),
    [sym_ns_map_lit] = STATE(222),
    [sym_var_quoting_lit] = STATE(222),
    [sym_sym_val_lit] = STATE(222),
    [sym_evaling_lit] = STATE(222),
    [sym_tagged_or_ctor_lit] = STATE(222),
    [sym_derefing_lit] = STATE(222),
    [sym_quoting_lit] = STATE(222),
    [sym_syn_quoting_lit] = STATE(222),
    [sym_unquote_splicing_lit] = STATE(222),
    [sym_unquoting_lit] = STATE(222),
    [aux_sym_dis_expr_repeat1] = STATE(127),
    [aux_sym_sym_lit_repeat1] = STATE(303),
    [sym__ws] = ACTIONS(784),
    [sym_comment] = ACTIONS(784),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(756),
    [anon_sym_SLASH] = ACTIONS(9),
    [anon_sym_COLON] = ACTIONS(716),
    [anon_sym_COLON_COLON] = ACTIONS(718),
    [aux_sym_str_lit_token1] = ACTIONS(15),
    [sym_char_lit] = ACTIONS(756),
    [sym_nil_lit] = ACTIONS(758),
    [sym_bool_lit] = ACTIONS(758),
    [aux_sym__sym_qualified_token1] = ACTIONS(19),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_POUND] = ACTIONS(720),
    [anon_sym_POUND_QMARK] = ACTIONS(33),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(35),
    [anon_sym_POUND_SQUOTE] = ACTIONS(722),
    [anon_sym_POUND_POUND] = ACTIONS(724),
    [anon_sym_POUND_EQ] = ACTIONS(41),
    [anon_sym_AT] = ACTIONS(726),
    [anon_sym_SQUOTE] = ACTIONS(728),
    [anon_sym_BQUOTE] = ACTIONS(730),
    [anon_sym_TILDE_AT] = ACTIONS(732),
    [anon_sym_TILDE] = ACTIONS(734),
  },
  [137] = {
    [sym__gap] = STATE(128),
    [sym_dis_expr] = STATE(128),
    [sym__form] = STATE(298),
    [sym_kwd_lit] = STATE(298),
    [sym_str_lit] = STATE(298),
    [sym_sym_lit] = STATE(298),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(298),
    [sym__bare_list_lit] = STATE(218),
    [sym_map_lit] = STATE(298),
    [sym__bare_map_lit] = STATE(219),
    [sym_vec_lit] = STATE(298),
    [sym__bare_vec_lit] = STATE(226),
    [sym_set_lit] = STATE(298),
    [sym__bare_set_lit] = STATE(227),
    [sym_anon_fn_lit] = STATE(298),
    [sym_regex_lit] = STATE(298),
    [sym_read_cond_lit] = STATE(298),
    [sym_splicing_read_cond_lit] = STATE(298),
    [sym_ns_map_lit] = STATE(298),
    [sym_var_quoting_lit] = STATE(298),
    [sym_sym_val_lit] = STATE(298),
    [sym_evaling_lit] = STATE(298),
    [sym_tagged_or_ctor_lit] = STATE(298),
    [sym_derefing_lit] = STATE(298),
    [sym_quoting_lit] = STATE(298),
    [sym_syn_quoting_lit] = STATE(298),
    [sym_unquote_splicing_lit] = STATE(298),
    [sym_unquoting_lit] = STATE(298),
    [aux_sym_dis_expr_repeat1] = STATE(128),
    [aux_sym_sym_lit_repeat1] = STATE(303),
    [sym__ws] = ACTIONS(786),
    [sym_comment] = ACTIONS(786),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(698),
    [anon_sym_SLASH] = ACTIONS(9),
    [anon_sym_COLON] = ACTIONS(716),
    [anon_sym_COLON_COLON] = ACTIONS(718),
    [aux_sym_str_lit_token1] = ACTIONS(15),
    [sym_char_lit] = ACTIONS(698),
    [sym_nil_lit] = ACTIONS(700),
    [sym_bool_lit] = ACTIONS(700),
    [aux_sym__sym_qualified_token1] = ACTIONS(19),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_POUND] = ACTIONS(720),
    [anon_sym_POUND_QMARK] = ACTIONS(33),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(35),
    [anon_sym_POUND_SQUOTE] = ACTIONS(722),
    [anon_sym_POUND_POUND] = ACTIONS(724),
    [anon_sym_POUND_EQ] = ACTIONS(41),
    [anon_sym_AT] = ACTIONS(726),
    [anon_sym_SQUOTE] = ACTIONS(728),
    [anon_sym_BQUOTE] = ACTIONS(730),
    [anon_sym_TILDE_AT] = ACTIONS(732),
    [anon_sym_TILDE] = ACTIONS(734),
  },
  [138] = {
    [sym__gap] = STATE(301),
    [sym_dis_expr] = STATE(301),
    [sym__form] = STATE(224),
    [sym_kwd_lit] = STATE(224),
    [sym_str_lit] = STATE(224),
    [sym_sym_lit] = STATE(224),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(224),
    [sym__bare_list_lit] = STATE(218),
    [sym_map_lit] = STATE(224),
    [sym__bare_map_lit] = STATE(219),
    [sym_vec_lit] = STATE(224),
    [sym__bare_vec_lit] = STATE(226),
    [sym_set_lit] = STATE(224),
    [sym__bare_set_lit] = STATE(227),
    [sym_anon_fn_lit] = STATE(224),
    [sym_regex_lit] = STATE(224),
    [sym_read_cond_lit] = STATE(224),
    [sym_splicing_read_cond_lit] = STATE(224),
    [sym_ns_map_lit] = STATE(224),
    [sym_var_quoting_lit] = STATE(224),
    [sym_sym_val_lit] = STATE(224),
    [sym_evaling_lit] = STATE(224),
    [sym_tagged_or_ctor_lit] = STATE(224),
    [sym_derefing_lit] = STATE(224),
    [sym_quoting_lit] = STATE(224),
    [sym_syn_quoting_lit] = STATE(224),
    [sym_unquote_splicing_lit] = STATE(224),
    [sym_unquoting_lit] = STATE(224),
    [aux_sym_dis_expr_repeat1] = STATE(301),
    [aux_sym_sym_lit_repeat1] = STATE(305),
    [sym__ws] = ACTIONS(264),
    [sym_comment] = ACTIONS(264),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(780),
    [anon_sym_SLASH] = ACTIONS(9),
    [anon_sym_COLON] = ACTIONS(11),
    [anon_sym_COLON_COLON] = ACTIONS(13),
    [aux_sym_str_lit_token1] = ACTIONS(15),
    [sym_char_lit] = ACTIONS(780),
    [sym_nil_lit] = ACTIONS(782),
    [sym_bool_lit] = ACTIONS(782),
    [aux_sym__sym_qualified_token1] = ACTIONS(19),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_POUND] = ACTIONS(31),
    [anon_sym_POUND_QMARK] = ACTIONS(33),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(35),
    [anon_sym_POUND_SQUOTE] = ACTIONS(37),
    [anon_sym_POUND_POUND] = ACTIONS(39),
    [anon_sym_POUND_EQ] = ACTIONS(41),
    [anon_sym_AT] = ACTIONS(43),
    [anon_sym_SQUOTE] = ACTIONS(45),
    [anon_sym_BQUOTE] = ACTIONS(47),
    [anon_sym_TILDE_AT] = ACTIONS(49),
    [anon_sym_TILDE] = ACTIONS(51),
  },
  [139] = {
    [sym__gap] = STATE(301),
    [sym_dis_expr] = STATE(301),
    [sym__form] = STATE(297),
    [sym_kwd_lit] = STATE(297),
    [sym_str_lit] = STATE(297),
    [sym_sym_lit] = STATE(297),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(297),
    [sym__bare_list_lit] = STATE(218),
    [sym_map_lit] = STATE(297),
    [sym__bare_map_lit] = STATE(219),
    [sym_vec_lit] = STATE(297),
    [sym__bare_vec_lit] = STATE(226),
    [sym_set_lit] = STATE(297),
    [sym__bare_set_lit] = STATE(227),
    [sym_anon_fn_lit] = STATE(297),
    [sym_regex_lit] = STATE(297),
    [sym_read_cond_lit] = STATE(297),
    [sym_splicing_read_cond_lit] = STATE(297),
    [sym_ns_map_lit] = STATE(297),
    [sym_var_quoting_lit] = STATE(297),
    [sym_sym_val_lit] = STATE(297),
    [sym_evaling_lit] = STATE(297),
    [sym_tagged_or_ctor_lit] = STATE(297),
    [sym_derefing_lit] = STATE(297),
    [sym_quoting_lit] = STATE(297),
    [sym_syn_quoting_lit] = STATE(297),
    [sym_unquote_splicing_lit] = STATE(297),
    [sym_unquoting_lit] = STATE(297),
    [aux_sym_dis_expr_repeat1] = STATE(301),
    [aux_sym_sym_lit_repeat1] = STATE(303),
    [sym__ws] = ACTIONS(264),
    [sym_comment] = ACTIONS(264),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(692),
    [anon_sym_SLASH] = ACTIONS(9),
    [anon_sym_COLON] = ACTIONS(716),
    [anon_sym_COLON_COLON] = ACTIONS(718),
    [aux_sym_str_lit_token1] = ACTIONS(15),
    [sym_char_lit] = ACTIONS(692),
    [sym_nil_lit] = ACTIONS(694),
    [sym_bool_lit] = ACTIONS(694),
    [aux_sym__sym_qualified_token1] = ACTIONS(19),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_POUND] = ACTIONS(720),
    [anon_sym_POUND_QMARK] = ACTIONS(33),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(35),
    [anon_sym_POUND_SQUOTE] = ACTIONS(722),
    [anon_sym_POUND_POUND] = ACTIONS(724),
    [anon_sym_POUND_EQ] = ACTIONS(41),
    [anon_sym_AT] = ACTIONS(726),
    [anon_sym_SQUOTE] = ACTIONS(728),
    [anon_sym_BQUOTE] = ACTIONS(730),
    [anon_sym_TILDE_AT] = ACTIONS(732),
    [anon_sym_TILDE] = ACTIONS(734),
  },
  [140] = {
    [sym__gap] = STATE(301),
    [sym_dis_expr] = STATE(301),
    [sym__form] = STATE(411),
    [sym_kwd_lit] = STATE(411),
    [sym_str_lit] = STATE(411),
    [sym_sym_lit] = STATE(411),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(411),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(411),
    [sym__bare_map_lit] = STATE(403),
    [sym_vec_lit] = STATE(411),
    [sym__bare_vec_lit] = STATE(423),
    [sym_set_lit] = STATE(411),
    [sym__bare_set_lit] = STATE(374),
    [sym_anon_fn_lit] = STATE(411),
    [sym_regex_lit] = STATE(411),
    [sym_read_cond_lit] = STATE(411),
    [sym_splicing_read_cond_lit] = STATE(411),
    [sym_ns_map_lit] = STATE(411),
    [sym_var_quoting_lit] = STATE(411),
    [sym_sym_val_lit] = STATE(411),
    [sym_evaling_lit] = STATE(411),
    [sym_tagged_or_ctor_lit] = STATE(411),
    [sym_derefing_lit] = STATE(411),
    [sym_quoting_lit] = STATE(411),
    [sym_syn_quoting_lit] = STATE(411),
    [sym_unquote_splicing_lit] = STATE(411),
    [sym_unquoting_lit] = STATE(411),
    [aux_sym_dis_expr_repeat1] = STATE(301),
    [aux_sym_sym_lit_repeat1] = STATE(307),
    [sym__ws] = ACTIONS(264),
    [sym_comment] = ACTIONS(264),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(596),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(352),
    [anon_sym_COLON_COLON] = ACTIONS(354),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(596),
    [sym_nil_lit] = ACTIONS(598),
    [sym_bool_lit] = ACTIONS(598),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(358),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(360),
    [anon_sym_POUND_POUND] = ACTIONS(362),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(364),
    [anon_sym_SQUOTE] = ACTIONS(366),
    [anon_sym_BQUOTE] = ACTIONS(368),
    [anon_sym_TILDE_AT] = ACTIONS(370),
    [anon_sym_TILDE] = ACTIONS(372),
  },
  [141] = {
    [sym__gap] = STATE(130),
    [sym_dis_expr] = STATE(130),
    [sym__form] = STATE(263),
    [sym_kwd_lit] = STATE(263),
    [sym_str_lit] = STATE(263),
    [sym_sym_lit] = STATE(263),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(263),
    [sym__bare_list_lit] = STATE(218),
    [sym_map_lit] = STATE(263),
    [sym__bare_map_lit] = STATE(219),
    [sym_vec_lit] = STATE(263),
    [sym__bare_vec_lit] = STATE(226),
    [sym_set_lit] = STATE(263),
    [sym__bare_set_lit] = STATE(227),
    [sym_anon_fn_lit] = STATE(263),
    [sym_regex_lit] = STATE(263),
    [sym_read_cond_lit] = STATE(263),
    [sym_splicing_read_cond_lit] = STATE(263),
    [sym_ns_map_lit] = STATE(263),
    [sym_var_quoting_lit] = STATE(263),
    [sym_sym_val_lit] = STATE(263),
    [sym_evaling_lit] = STATE(263),
    [sym_tagged_or_ctor_lit] = STATE(263),
    [sym_derefing_lit] = STATE(263),
    [sym_quoting_lit] = STATE(263),
    [sym_syn_quoting_lit] = STATE(263),
    [sym_unquote_splicing_lit] = STATE(263),
    [sym_unquoting_lit] = STATE(263),
    [aux_sym_dis_expr_repeat1] = STATE(130),
    [aux_sym_sym_lit_repeat1] = STATE(303),
    [sym__ws] = ACTIONS(788),
    [sym_comment] = ACTIONS(788),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(652),
    [anon_sym_SLASH] = ACTIONS(9),
    [anon_sym_COLON] = ACTIONS(716),
    [anon_sym_COLON_COLON] = ACTIONS(718),
    [aux_sym_str_lit_token1] = ACTIONS(15),
    [sym_char_lit] = ACTIONS(652),
    [sym_nil_lit] = ACTIONS(654),
    [sym_bool_lit] = ACTIONS(654),
    [aux_sym__sym_qualified_token1] = ACTIONS(19),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_POUND] = ACTIONS(720),
    [anon_sym_POUND_QMARK] = ACTIONS(33),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(35),
    [anon_sym_POUND_SQUOTE] = ACTIONS(722),
    [anon_sym_POUND_POUND] = ACTIONS(724),
    [anon_sym_POUND_EQ] = ACTIONS(41),
    [anon_sym_AT] = ACTIONS(726),
    [anon_sym_SQUOTE] = ACTIONS(728),
    [anon_sym_BQUOTE] = ACTIONS(730),
    [anon_sym_TILDE_AT] = ACTIONS(732),
    [anon_sym_TILDE] = ACTIONS(734),
  },
  [142] = {
    [sym__gap] = STATE(131),
    [sym_dis_expr] = STATE(131),
    [sym__form] = STATE(291),
    [sym_kwd_lit] = STATE(291),
    [sym_str_lit] = STATE(291),
    [sym_sym_lit] = STATE(291),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(291),
    [sym__bare_list_lit] = STATE(218),
    [sym_map_lit] = STATE(291),
    [sym__bare_map_lit] = STATE(219),
    [sym_vec_lit] = STATE(291),
    [sym__bare_vec_lit] = STATE(226),
    [sym_set_lit] = STATE(291),
    [sym__bare_set_lit] = STATE(227),
    [sym_anon_fn_lit] = STATE(291),
    [sym_regex_lit] = STATE(291),
    [sym_read_cond_lit] = STATE(291),
    [sym_splicing_read_cond_lit] = STATE(291),
    [sym_ns_map_lit] = STATE(291),
    [sym_var_quoting_lit] = STATE(291),
    [sym_sym_val_lit] = STATE(291),
    [sym_evaling_lit] = STATE(291),
    [sym_tagged_or_ctor_lit] = STATE(291),
    [sym_derefing_lit] = STATE(291),
    [sym_quoting_lit] = STATE(291),
    [sym_syn_quoting_lit] = STATE(291),
    [sym_unquote_splicing_lit] = STATE(291),
    [sym_unquoting_lit] = STATE(291),
    [aux_sym_dis_expr_repeat1] = STATE(131),
    [aux_sym_sym_lit_repeat1] = STATE(303),
    [sym__ws] = ACTIONS(790),
    [sym_comment] = ACTIONS(790),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(646),
    [anon_sym_SLASH] = ACTIONS(9),
    [anon_sym_COLON] = ACTIONS(716),
    [anon_sym_COLON_COLON] = ACTIONS(718),
    [aux_sym_str_lit_token1] = ACTIONS(15),
    [sym_char_lit] = ACTIONS(646),
    [sym_nil_lit] = ACTIONS(648),
    [sym_bool_lit] = ACTIONS(648),
    [aux_sym__sym_qualified_token1] = ACTIONS(19),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_POUND] = ACTIONS(720),
    [anon_sym_POUND_QMARK] = ACTIONS(33),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(35),
    [anon_sym_POUND_SQUOTE] = ACTIONS(722),
    [anon_sym_POUND_POUND] = ACTIONS(724),
    [anon_sym_POUND_EQ] = ACTIONS(41),
    [anon_sym_AT] = ACTIONS(726),
    [anon_sym_SQUOTE] = ACTIONS(728),
    [anon_sym_BQUOTE] = ACTIONS(730),
    [anon_sym_TILDE_AT] = ACTIONS(732),
    [anon_sym_TILDE] = ACTIONS(734),
  },
  [143] = {
    [sym__gap] = STATE(132),
    [sym_dis_expr] = STATE(132),
    [sym__form] = STATE(290),
    [sym_kwd_lit] = STATE(290),
    [sym_str_lit] = STATE(290),
    [sym_sym_lit] = STATE(290),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(290),
    [sym__bare_list_lit] = STATE(218),
    [sym_map_lit] = STATE(290),
    [sym__bare_map_lit] = STATE(219),
    [sym_vec_lit] = STATE(290),
    [sym__bare_vec_lit] = STATE(226),
    [sym_set_lit] = STATE(290),
    [sym__bare_set_lit] = STATE(227),
    [sym_anon_fn_lit] = STATE(290),
    [sym_regex_lit] = STATE(290),
    [sym_read_cond_lit] = STATE(290),
    [sym_splicing_read_cond_lit] = STATE(290),
    [sym_ns_map_lit] = STATE(290),
    [sym_var_quoting_lit] = STATE(290),
    [sym_sym_val_lit] = STATE(290),
    [sym_evaling_lit] = STATE(290),
    [sym_tagged_or_ctor_lit] = STATE(290),
    [sym_derefing_lit] = STATE(290),
    [sym_quoting_lit] = STATE(290),
    [sym_syn_quoting_lit] = STATE(290),
    [sym_unquote_splicing_lit] = STATE(290),
    [sym_unquoting_lit] = STATE(290),
    [aux_sym_dis_expr_repeat1] = STATE(132),
    [aux_sym_sym_lit_repeat1] = STATE(303),
    [sym__ws] = ACTIONS(792),
    [sym_comment] = ACTIONS(792),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(640),
    [anon_sym_SLASH] = ACTIONS(9),
    [anon_sym_COLON] = ACTIONS(716),
    [anon_sym_COLON_COLON] = ACTIONS(718),
    [aux_sym_str_lit_token1] = ACTIONS(15),
    [sym_char_lit] = ACTIONS(640),
    [sym_nil_lit] = ACTIONS(642),
    [sym_bool_lit] = ACTIONS(642),
    [aux_sym__sym_qualified_token1] = ACTIONS(19),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_POUND] = ACTIONS(720),
    [anon_sym_POUND_QMARK] = ACTIONS(33),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(35),
    [anon_sym_POUND_SQUOTE] = ACTIONS(722),
    [anon_sym_POUND_POUND] = ACTIONS(724),
    [anon_sym_POUND_EQ] = ACTIONS(41),
    [anon_sym_AT] = ACTIONS(726),
    [anon_sym_SQUOTE] = ACTIONS(728),
    [anon_sym_BQUOTE] = ACTIONS(730),
    [anon_sym_TILDE_AT] = ACTIONS(732),
    [anon_sym_TILDE] = ACTIONS(734),
  },
  [144] = {
    [sym__gap] = STATE(301),
    [sym_dis_expr] = STATE(301),
    [sym__form] = STATE(243),
    [sym_kwd_lit] = STATE(243),
    [sym_str_lit] = STATE(243),
    [sym_sym_lit] = STATE(243),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(243),
    [sym__bare_list_lit] = STATE(218),
    [sym_map_lit] = STATE(243),
    [sym__bare_map_lit] = STATE(219),
    [sym_vec_lit] = STATE(243),
    [sym__bare_vec_lit] = STATE(226),
    [sym_set_lit] = STATE(243),
    [sym__bare_set_lit] = STATE(227),
    [sym_anon_fn_lit] = STATE(243),
    [sym_regex_lit] = STATE(243),
    [sym_read_cond_lit] = STATE(243),
    [sym_splicing_read_cond_lit] = STATE(243),
    [sym_ns_map_lit] = STATE(243),
    [sym_var_quoting_lit] = STATE(243),
    [sym_sym_val_lit] = STATE(243),
    [sym_evaling_lit] = STATE(243),
    [sym_tagged_or_ctor_lit] = STATE(243),
    [sym_derefing_lit] = STATE(243),
    [sym_quoting_lit] = STATE(243),
    [sym_syn_quoting_lit] = STATE(243),
    [sym_unquote_splicing_lit] = STATE(243),
    [sym_unquoting_lit] = STATE(243),
    [aux_sym_dis_expr_repeat1] = STATE(301),
    [aux_sym_sym_lit_repeat1] = STATE(305),
    [sym__ws] = ACTIONS(264),
    [sym_comment] = ACTIONS(264),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(776),
    [anon_sym_SLASH] = ACTIONS(9),
    [anon_sym_COLON] = ACTIONS(11),
    [anon_sym_COLON_COLON] = ACTIONS(13),
    [aux_sym_str_lit_token1] = ACTIONS(15),
    [sym_char_lit] = ACTIONS(776),
    [sym_nil_lit] = ACTIONS(778),
    [sym_bool_lit] = ACTIONS(778),
    [aux_sym__sym_qualified_token1] = ACTIONS(19),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_POUND] = ACTIONS(31),
    [anon_sym_POUND_QMARK] = ACTIONS(33),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(35),
    [anon_sym_POUND_SQUOTE] = ACTIONS(37),
    [anon_sym_POUND_POUND] = ACTIONS(39),
    [anon_sym_POUND_EQ] = ACTIONS(41),
    [anon_sym_AT] = ACTIONS(43),
    [anon_sym_SQUOTE] = ACTIONS(45),
    [anon_sym_BQUOTE] = ACTIONS(47),
    [anon_sym_TILDE_AT] = ACTIONS(49),
    [anon_sym_TILDE] = ACTIONS(51),
  },
  [145] = {
    [sym__gap] = STATE(133),
    [sym_dis_expr] = STATE(133),
    [sym__form] = STATE(289),
    [sym_kwd_lit] = STATE(289),
    [sym_str_lit] = STATE(289),
    [sym_sym_lit] = STATE(289),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(289),
    [sym__bare_list_lit] = STATE(218),
    [sym_map_lit] = STATE(289),
    [sym__bare_map_lit] = STATE(219),
    [sym_vec_lit] = STATE(289),
    [sym__bare_vec_lit] = STATE(226),
    [sym_set_lit] = STATE(289),
    [sym__bare_set_lit] = STATE(227),
    [sym_anon_fn_lit] = STATE(289),
    [sym_regex_lit] = STATE(289),
    [sym_read_cond_lit] = STATE(289),
    [sym_splicing_read_cond_lit] = STATE(289),
    [sym_ns_map_lit] = STATE(289),
    [sym_var_quoting_lit] = STATE(289),
    [sym_sym_val_lit] = STATE(289),
    [sym_evaling_lit] = STATE(289),
    [sym_tagged_or_ctor_lit] = STATE(289),
    [sym_derefing_lit] = STATE(289),
    [sym_quoting_lit] = STATE(289),
    [sym_syn_quoting_lit] = STATE(289),
    [sym_unquote_splicing_lit] = STATE(289),
    [sym_unquoting_lit] = STATE(289),
    [aux_sym_dis_expr_repeat1] = STATE(133),
    [aux_sym_sym_lit_repeat1] = STATE(303),
    [sym__ws] = ACTIONS(794),
    [sym_comment] = ACTIONS(794),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(634),
    [anon_sym_SLASH] = ACTIONS(9),
    [anon_sym_COLON] = ACTIONS(716),
    [anon_sym_COLON_COLON] = ACTIONS(718),
    [aux_sym_str_lit_token1] = ACTIONS(15),
    [sym_char_lit] = ACTIONS(634),
    [sym_nil_lit] = ACTIONS(636),
    [sym_bool_lit] = ACTIONS(636),
    [aux_sym__sym_qualified_token1] = ACTIONS(19),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_POUND] = ACTIONS(720),
    [anon_sym_POUND_QMARK] = ACTIONS(33),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(35),
    [anon_sym_POUND_SQUOTE] = ACTIONS(722),
    [anon_sym_POUND_POUND] = ACTIONS(724),
    [anon_sym_POUND_EQ] = ACTIONS(41),
    [anon_sym_AT] = ACTIONS(726),
    [anon_sym_SQUOTE] = ACTIONS(728),
    [anon_sym_BQUOTE] = ACTIONS(730),
    [anon_sym_TILDE_AT] = ACTIONS(732),
    [anon_sym_TILDE] = ACTIONS(734),
  },
  [146] = {
    [sym__gap] = STATE(301),
    [sym_dis_expr] = STATE(301),
    [sym__form] = STATE(249),
    [sym_kwd_lit] = STATE(249),
    [sym_str_lit] = STATE(249),
    [sym_sym_lit] = STATE(249),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(249),
    [sym__bare_list_lit] = STATE(218),
    [sym_map_lit] = STATE(249),
    [sym__bare_map_lit] = STATE(219),
    [sym_vec_lit] = STATE(249),
    [sym__bare_vec_lit] = STATE(226),
    [sym_set_lit] = STATE(249),
    [sym__bare_set_lit] = STATE(227),
    [sym_anon_fn_lit] = STATE(249),
    [sym_regex_lit] = STATE(249),
    [sym_read_cond_lit] = STATE(249),
    [sym_splicing_read_cond_lit] = STATE(249),
    [sym_ns_map_lit] = STATE(249),
    [sym_var_quoting_lit] = STATE(249),
    [sym_sym_val_lit] = STATE(249),
    [sym_evaling_lit] = STATE(249),
    [sym_tagged_or_ctor_lit] = STATE(249),
    [sym_derefing_lit] = STATE(249),
    [sym_quoting_lit] = STATE(249),
    [sym_syn_quoting_lit] = STATE(249),
    [sym_unquote_splicing_lit] = STATE(249),
    [sym_unquoting_lit] = STATE(249),
    [aux_sym_dis_expr_repeat1] = STATE(301),
    [aux_sym_sym_lit_repeat1] = STATE(305),
    [sym__ws] = ACTIONS(264),
    [sym_comment] = ACTIONS(264),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(772),
    [anon_sym_SLASH] = ACTIONS(9),
    [anon_sym_COLON] = ACTIONS(11),
    [anon_sym_COLON_COLON] = ACTIONS(13),
    [aux_sym_str_lit_token1] = ACTIONS(15),
    [sym_char_lit] = ACTIONS(772),
    [sym_nil_lit] = ACTIONS(774),
    [sym_bool_lit] = ACTIONS(774),
    [aux_sym__sym_qualified_token1] = ACTIONS(19),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_POUND] = ACTIONS(31),
    [anon_sym_POUND_QMARK] = ACTIONS(33),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(35),
    [anon_sym_POUND_SQUOTE] = ACTIONS(37),
    [anon_sym_POUND_POUND] = ACTIONS(39),
    [anon_sym_POUND_EQ] = ACTIONS(41),
    [anon_sym_AT] = ACTIONS(43),
    [anon_sym_SQUOTE] = ACTIONS(45),
    [anon_sym_BQUOTE] = ACTIONS(47),
    [anon_sym_TILDE_AT] = ACTIONS(49),
    [anon_sym_TILDE] = ACTIONS(51),
  },
  [147] = {
    [sym__gap] = STATE(134),
    [sym_dis_expr] = STATE(134),
    [sym__form] = STATE(287),
    [sym_kwd_lit] = STATE(287),
    [sym_str_lit] = STATE(287),
    [sym_sym_lit] = STATE(287),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(287),
    [sym__bare_list_lit] = STATE(218),
    [sym_map_lit] = STATE(287),
    [sym__bare_map_lit] = STATE(219),
    [sym_vec_lit] = STATE(287),
    [sym__bare_vec_lit] = STATE(226),
    [sym_set_lit] = STATE(287),
    [sym__bare_set_lit] = STATE(227),
    [sym_anon_fn_lit] = STATE(287),
    [sym_regex_lit] = STATE(287),
    [sym_read_cond_lit] = STATE(287),
    [sym_splicing_read_cond_lit] = STATE(287),
    [sym_ns_map_lit] = STATE(287),
    [sym_var_quoting_lit] = STATE(287),
    [sym_sym_val_lit] = STATE(287),
    [sym_evaling_lit] = STATE(287),
    [sym_tagged_or_ctor_lit] = STATE(287),
    [sym_derefing_lit] = STATE(287),
    [sym_quoting_lit] = STATE(287),
    [sym_syn_quoting_lit] = STATE(287),
    [sym_unquote_splicing_lit] = STATE(287),
    [sym_unquoting_lit] = STATE(287),
    [aux_sym_dis_expr_repeat1] = STATE(134),
    [aux_sym_sym_lit_repeat1] = STATE(303),
    [sym__ws] = ACTIONS(796),
    [sym_comment] = ACTIONS(796),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(628),
    [anon_sym_SLASH] = ACTIONS(9),
    [anon_sym_COLON] = ACTIONS(716),
    [anon_sym_COLON_COLON] = ACTIONS(718),
    [aux_sym_str_lit_token1] = ACTIONS(15),
    [sym_char_lit] = ACTIONS(628),
    [sym_nil_lit] = ACTIONS(630),
    [sym_bool_lit] = ACTIONS(630),
    [aux_sym__sym_qualified_token1] = ACTIONS(19),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_POUND] = ACTIONS(720),
    [anon_sym_POUND_QMARK] = ACTIONS(33),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(35),
    [anon_sym_POUND_SQUOTE] = ACTIONS(722),
    [anon_sym_POUND_POUND] = ACTIONS(724),
    [anon_sym_POUND_EQ] = ACTIONS(41),
    [anon_sym_AT] = ACTIONS(726),
    [anon_sym_SQUOTE] = ACTIONS(728),
    [anon_sym_BQUOTE] = ACTIONS(730),
    [anon_sym_TILDE_AT] = ACTIONS(732),
    [anon_sym_TILDE] = ACTIONS(734),
  },
  [148] = {
    [sym__gap] = STATE(301),
    [sym_dis_expr] = STATE(301),
    [sym__form] = STATE(250),
    [sym_kwd_lit] = STATE(250),
    [sym_str_lit] = STATE(250),
    [sym_sym_lit] = STATE(250),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(250),
    [sym__bare_list_lit] = STATE(218),
    [sym_map_lit] = STATE(250),
    [sym__bare_map_lit] = STATE(219),
    [sym_vec_lit] = STATE(250),
    [sym__bare_vec_lit] = STATE(226),
    [sym_set_lit] = STATE(250),
    [sym__bare_set_lit] = STATE(227),
    [sym_anon_fn_lit] = STATE(250),
    [sym_regex_lit] = STATE(250),
    [sym_read_cond_lit] = STATE(250),
    [sym_splicing_read_cond_lit] = STATE(250),
    [sym_ns_map_lit] = STATE(250),
    [sym_var_quoting_lit] = STATE(250),
    [sym_sym_val_lit] = STATE(250),
    [sym_evaling_lit] = STATE(250),
    [sym_tagged_or_ctor_lit] = STATE(250),
    [sym_derefing_lit] = STATE(250),
    [sym_quoting_lit] = STATE(250),
    [sym_syn_quoting_lit] = STATE(250),
    [sym_unquote_splicing_lit] = STATE(250),
    [sym_unquoting_lit] = STATE(250),
    [aux_sym_dis_expr_repeat1] = STATE(301),
    [aux_sym_sym_lit_repeat1] = STATE(305),
    [sym__ws] = ACTIONS(264),
    [sym_comment] = ACTIONS(264),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(768),
    [anon_sym_SLASH] = ACTIONS(9),
    [anon_sym_COLON] = ACTIONS(11),
    [anon_sym_COLON_COLON] = ACTIONS(13),
    [aux_sym_str_lit_token1] = ACTIONS(15),
    [sym_char_lit] = ACTIONS(768),
    [sym_nil_lit] = ACTIONS(770),
    [sym_bool_lit] = ACTIONS(770),
    [aux_sym__sym_qualified_token1] = ACTIONS(19),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_POUND] = ACTIONS(31),
    [anon_sym_POUND_QMARK] = ACTIONS(33),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(35),
    [anon_sym_POUND_SQUOTE] = ACTIONS(37),
    [anon_sym_POUND_POUND] = ACTIONS(39),
    [anon_sym_POUND_EQ] = ACTIONS(41),
    [anon_sym_AT] = ACTIONS(43),
    [anon_sym_SQUOTE] = ACTIONS(45),
    [anon_sym_BQUOTE] = ACTIONS(47),
    [anon_sym_TILDE_AT] = ACTIONS(49),
    [anon_sym_TILDE] = ACTIONS(51),
  },
  [149] = {
    [sym__gap] = STATE(135),
    [sym_dis_expr] = STATE(135),
    [sym__form] = STATE(283),
    [sym_kwd_lit] = STATE(283),
    [sym_str_lit] = STATE(283),
    [sym_sym_lit] = STATE(283),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(283),
    [sym__bare_list_lit] = STATE(218),
    [sym_map_lit] = STATE(283),
    [sym__bare_map_lit] = STATE(219),
    [sym_vec_lit] = STATE(283),
    [sym__bare_vec_lit] = STATE(226),
    [sym_set_lit] = STATE(283),
    [sym__bare_set_lit] = STATE(227),
    [sym_anon_fn_lit] = STATE(283),
    [sym_regex_lit] = STATE(283),
    [sym_read_cond_lit] = STATE(283),
    [sym_splicing_read_cond_lit] = STATE(283),
    [sym_ns_map_lit] = STATE(283),
    [sym_var_quoting_lit] = STATE(283),
    [sym_sym_val_lit] = STATE(283),
    [sym_evaling_lit] = STATE(283),
    [sym_tagged_or_ctor_lit] = STATE(283),
    [sym_derefing_lit] = STATE(283),
    [sym_quoting_lit] = STATE(283),
    [sym_syn_quoting_lit] = STATE(283),
    [sym_unquote_splicing_lit] = STATE(283),
    [sym_unquoting_lit] = STATE(283),
    [aux_sym_dis_expr_repeat1] = STATE(135),
    [aux_sym_sym_lit_repeat1] = STATE(303),
    [sym__ws] = ACTIONS(798),
    [sym_comment] = ACTIONS(798),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(622),
    [anon_sym_SLASH] = ACTIONS(9),
    [anon_sym_COLON] = ACTIONS(716),
    [anon_sym_COLON_COLON] = ACTIONS(718),
    [aux_sym_str_lit_token1] = ACTIONS(15),
    [sym_char_lit] = ACTIONS(622),
    [sym_nil_lit] = ACTIONS(624),
    [sym_bool_lit] = ACTIONS(624),
    [aux_sym__sym_qualified_token1] = ACTIONS(19),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_POUND] = ACTIONS(720),
    [anon_sym_POUND_QMARK] = ACTIONS(33),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(35),
    [anon_sym_POUND_SQUOTE] = ACTIONS(722),
    [anon_sym_POUND_POUND] = ACTIONS(724),
    [anon_sym_POUND_EQ] = ACTIONS(41),
    [anon_sym_AT] = ACTIONS(726),
    [anon_sym_SQUOTE] = ACTIONS(728),
    [anon_sym_BQUOTE] = ACTIONS(730),
    [anon_sym_TILDE_AT] = ACTIONS(732),
    [anon_sym_TILDE] = ACTIONS(734),
  },
  [150] = {
    [sym__gap] = STATE(301),
    [sym_dis_expr] = STATE(301),
    [sym__form] = STATE(274),
    [sym_kwd_lit] = STATE(274),
    [sym_str_lit] = STATE(274),
    [sym_sym_lit] = STATE(274),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(274),
    [sym__bare_list_lit] = STATE(218),
    [sym_map_lit] = STATE(274),
    [sym__bare_map_lit] = STATE(219),
    [sym_vec_lit] = STATE(274),
    [sym__bare_vec_lit] = STATE(226),
    [sym_set_lit] = STATE(274),
    [sym__bare_set_lit] = STATE(227),
    [sym_anon_fn_lit] = STATE(274),
    [sym_regex_lit] = STATE(274),
    [sym_read_cond_lit] = STATE(274),
    [sym_splicing_read_cond_lit] = STATE(274),
    [sym_ns_map_lit] = STATE(274),
    [sym_var_quoting_lit] = STATE(274),
    [sym_sym_val_lit] = STATE(274),
    [sym_evaling_lit] = STATE(274),
    [sym_tagged_or_ctor_lit] = STATE(274),
    [sym_derefing_lit] = STATE(274),
    [sym_quoting_lit] = STATE(274),
    [sym_syn_quoting_lit] = STATE(274),
    [sym_unquote_splicing_lit] = STATE(274),
    [sym_unquoting_lit] = STATE(274),
    [aux_sym_dis_expr_repeat1] = STATE(301),
    [aux_sym_sym_lit_repeat1] = STATE(305),
    [sym__ws] = ACTIONS(264),
    [sym_comment] = ACTIONS(264),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(764),
    [anon_sym_SLASH] = ACTIONS(9),
    [anon_sym_COLON] = ACTIONS(11),
    [anon_sym_COLON_COLON] = ACTIONS(13),
    [aux_sym_str_lit_token1] = ACTIONS(15),
    [sym_char_lit] = ACTIONS(764),
    [sym_nil_lit] = ACTIONS(766),
    [sym_bool_lit] = ACTIONS(766),
    [aux_sym__sym_qualified_token1] = ACTIONS(19),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_POUND] = ACTIONS(31),
    [anon_sym_POUND_QMARK] = ACTIONS(33),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(35),
    [anon_sym_POUND_SQUOTE] = ACTIONS(37),
    [anon_sym_POUND_POUND] = ACTIONS(39),
    [anon_sym_POUND_EQ] = ACTIONS(41),
    [anon_sym_AT] = ACTIONS(43),
    [anon_sym_SQUOTE] = ACTIONS(45),
    [anon_sym_BQUOTE] = ACTIONS(47),
    [anon_sym_TILDE_AT] = ACTIONS(49),
    [anon_sym_TILDE] = ACTIONS(51),
  },
  [151] = {
    [sym__gap] = STATE(301),
    [sym_dis_expr] = STATE(301),
    [sym__form] = STATE(278),
    [sym_kwd_lit] = STATE(278),
    [sym_str_lit] = STATE(278),
    [sym_sym_lit] = STATE(278),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(278),
    [sym__bare_list_lit] = STATE(218),
    [sym_map_lit] = STATE(278),
    [sym__bare_map_lit] = STATE(219),
    [sym_vec_lit] = STATE(278),
    [sym__bare_vec_lit] = STATE(226),
    [sym_set_lit] = STATE(278),
    [sym__bare_set_lit] = STATE(227),
    [sym_anon_fn_lit] = STATE(278),
    [sym_regex_lit] = STATE(278),
    [sym_read_cond_lit] = STATE(278),
    [sym_splicing_read_cond_lit] = STATE(278),
    [sym_ns_map_lit] = STATE(278),
    [sym_var_quoting_lit] = STATE(278),
    [sym_sym_val_lit] = STATE(278),
    [sym_evaling_lit] = STATE(278),
    [sym_tagged_or_ctor_lit] = STATE(278),
    [sym_derefing_lit] = STATE(278),
    [sym_quoting_lit] = STATE(278),
    [sym_syn_quoting_lit] = STATE(278),
    [sym_unquote_splicing_lit] = STATE(278),
    [sym_unquoting_lit] = STATE(278),
    [aux_sym_dis_expr_repeat1] = STATE(301),
    [aux_sym_sym_lit_repeat1] = STATE(303),
    [sym__ws] = ACTIONS(264),
    [sym_comment] = ACTIONS(264),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(600),
    [anon_sym_SLASH] = ACTIONS(9),
    [anon_sym_COLON] = ACTIONS(716),
    [anon_sym_COLON_COLON] = ACTIONS(718),
    [aux_sym_str_lit_token1] = ACTIONS(15),
    [sym_char_lit] = ACTIONS(600),
    [sym_nil_lit] = ACTIONS(602),
    [sym_bool_lit] = ACTIONS(602),
    [aux_sym__sym_qualified_token1] = ACTIONS(19),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_POUND] = ACTIONS(720),
    [anon_sym_POUND_QMARK] = ACTIONS(33),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(35),
    [anon_sym_POUND_SQUOTE] = ACTIONS(722),
    [anon_sym_POUND_POUND] = ACTIONS(724),
    [anon_sym_POUND_EQ] = ACTIONS(41),
    [anon_sym_AT] = ACTIONS(726),
    [anon_sym_SQUOTE] = ACTIONS(728),
    [anon_sym_BQUOTE] = ACTIONS(730),
    [anon_sym_TILDE_AT] = ACTIONS(732),
    [anon_sym_TILDE] = ACTIONS(734),
  },
  [152] = {
    [sym__gap] = STATE(301),
    [sym_dis_expr] = STATE(301),
    [sym__form] = STATE(300),
    [sym_kwd_lit] = STATE(300),
    [sym_str_lit] = STATE(300),
    [sym_sym_lit] = STATE(300),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(300),
    [sym__bare_list_lit] = STATE(218),
    [sym_map_lit] = STATE(300),
    [sym__bare_map_lit] = STATE(219),
    [sym_vec_lit] = STATE(300),
    [sym__bare_vec_lit] = STATE(226),
    [sym_set_lit] = STATE(300),
    [sym__bare_set_lit] = STATE(227),
    [sym_anon_fn_lit] = STATE(300),
    [sym_regex_lit] = STATE(300),
    [sym_read_cond_lit] = STATE(300),
    [sym_splicing_read_cond_lit] = STATE(300),
    [sym_ns_map_lit] = STATE(300),
    [sym_var_quoting_lit] = STATE(300),
    [sym_sym_val_lit] = STATE(300),
    [sym_evaling_lit] = STATE(300),
    [sym_tagged_or_ctor_lit] = STATE(300),
    [sym_derefing_lit] = STATE(300),
    [sym_quoting_lit] = STATE(300),
    [sym_syn_quoting_lit] = STATE(300),
    [sym_unquote_splicing_lit] = STATE(300),
    [sym_unquoting_lit] = STATE(300),
    [aux_sym_dis_expr_repeat1] = STATE(301),
    [aux_sym_sym_lit_repeat1] = STATE(305),
    [sym__ws] = ACTIONS(264),
    [sym_comment] = ACTIONS(264),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(760),
    [anon_sym_SLASH] = ACTIONS(9),
    [anon_sym_COLON] = ACTIONS(11),
    [anon_sym_COLON_COLON] = ACTIONS(13),
    [aux_sym_str_lit_token1] = ACTIONS(15),
    [sym_char_lit] = ACTIONS(760),
    [sym_nil_lit] = ACTIONS(762),
    [sym_bool_lit] = ACTIONS(762),
    [aux_sym__sym_qualified_token1] = ACTIONS(19),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_POUND] = ACTIONS(31),
    [anon_sym_POUND_QMARK] = ACTIONS(33),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(35),
    [anon_sym_POUND_SQUOTE] = ACTIONS(37),
    [anon_sym_POUND_POUND] = ACTIONS(39),
    [anon_sym_POUND_EQ] = ACTIONS(41),
    [anon_sym_AT] = ACTIONS(43),
    [anon_sym_SQUOTE] = ACTIONS(45),
    [anon_sym_BQUOTE] = ACTIONS(47),
    [anon_sym_TILDE_AT] = ACTIONS(49),
    [anon_sym_TILDE] = ACTIONS(51),
  },
  [153] = {
    [sym__gap] = STATE(301),
    [sym_dis_expr] = STATE(301),
    [sym__form] = STATE(277),
    [sym_kwd_lit] = STATE(277),
    [sym_str_lit] = STATE(277),
    [sym_sym_lit] = STATE(277),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(277),
    [sym__bare_list_lit] = STATE(218),
    [sym_map_lit] = STATE(277),
    [sym__bare_map_lit] = STATE(219),
    [sym_vec_lit] = STATE(277),
    [sym__bare_vec_lit] = STATE(226),
    [sym_set_lit] = STATE(277),
    [sym__bare_set_lit] = STATE(227),
    [sym_anon_fn_lit] = STATE(277),
    [sym_regex_lit] = STATE(277),
    [sym_read_cond_lit] = STATE(277),
    [sym_splicing_read_cond_lit] = STATE(277),
    [sym_ns_map_lit] = STATE(277),
    [sym_var_quoting_lit] = STATE(277),
    [sym_sym_val_lit] = STATE(277),
    [sym_evaling_lit] = STATE(277),
    [sym_tagged_or_ctor_lit] = STATE(277),
    [sym_derefing_lit] = STATE(277),
    [sym_quoting_lit] = STATE(277),
    [sym_syn_quoting_lit] = STATE(277),
    [sym_unquote_splicing_lit] = STATE(277),
    [sym_unquoting_lit] = STATE(277),
    [aux_sym_dis_expr_repeat1] = STATE(301),
    [aux_sym_sym_lit_repeat1] = STATE(303),
    [sym__ws] = ACTIONS(264),
    [sym_comment] = ACTIONS(264),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(592),
    [anon_sym_SLASH] = ACTIONS(9),
    [anon_sym_COLON] = ACTIONS(716),
    [anon_sym_COLON_COLON] = ACTIONS(718),
    [aux_sym_str_lit_token1] = ACTIONS(15),
    [sym_char_lit] = ACTIONS(592),
    [sym_nil_lit] = ACTIONS(594),
    [sym_bool_lit] = ACTIONS(594),
    [aux_sym__sym_qualified_token1] = ACTIONS(19),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_POUND] = ACTIONS(720),
    [anon_sym_POUND_QMARK] = ACTIONS(33),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(35),
    [anon_sym_POUND_SQUOTE] = ACTIONS(722),
    [anon_sym_POUND_POUND] = ACTIONS(724),
    [anon_sym_POUND_EQ] = ACTIONS(41),
    [anon_sym_AT] = ACTIONS(726),
    [anon_sym_SQUOTE] = ACTIONS(728),
    [anon_sym_BQUOTE] = ACTIONS(730),
    [anon_sym_TILDE_AT] = ACTIONS(732),
    [anon_sym_TILDE] = ACTIONS(734),
  },
  [154] = {
    [sym__gap] = STATE(301),
    [sym_dis_expr] = STATE(301),
    [sym__form] = STATE(214),
    [sym_kwd_lit] = STATE(214),
    [sym_str_lit] = STATE(214),
    [sym_sym_lit] = STATE(214),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(214),
    [sym__bare_list_lit] = STATE(218),
    [sym_map_lit] = STATE(214),
    [sym__bare_map_lit] = STATE(219),
    [sym_vec_lit] = STATE(214),
    [sym__bare_vec_lit] = STATE(226),
    [sym_set_lit] = STATE(214),
    [sym__bare_set_lit] = STATE(227),
    [sym_anon_fn_lit] = STATE(214),
    [sym_regex_lit] = STATE(214),
    [sym_read_cond_lit] = STATE(214),
    [sym_splicing_read_cond_lit] = STATE(214),
    [sym_ns_map_lit] = STATE(214),
    [sym_var_quoting_lit] = STATE(214),
    [sym_sym_val_lit] = STATE(214),
    [sym_evaling_lit] = STATE(214),
    [sym_tagged_or_ctor_lit] = STATE(214),
    [sym_derefing_lit] = STATE(214),
    [sym_quoting_lit] = STATE(214),
    [sym_syn_quoting_lit] = STATE(214),
    [sym_unquote_splicing_lit] = STATE(214),
    [sym_unquoting_lit] = STATE(214),
    [aux_sym_dis_expr_repeat1] = STATE(301),
    [aux_sym_sym_lit_repeat1] = STATE(303),
    [sym__ws] = ACTIONS(264),
    [sym_comment] = ACTIONS(264),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(584),
    [anon_sym_SLASH] = ACTIONS(9),
    [anon_sym_COLON] = ACTIONS(716),
    [anon_sym_COLON_COLON] = ACTIONS(718),
    [aux_sym_str_lit_token1] = ACTIONS(15),
    [sym_char_lit] = ACTIONS(584),
    [sym_nil_lit] = ACTIONS(586),
    [sym_bool_lit] = ACTIONS(586),
    [aux_sym__sym_qualified_token1] = ACTIONS(19),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_POUND] = ACTIONS(720),
    [anon_sym_POUND_QMARK] = ACTIONS(33),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(35),
    [anon_sym_POUND_SQUOTE] = ACTIONS(722),
    [anon_sym_POUND_POUND] = ACTIONS(724),
    [anon_sym_POUND_EQ] = ACTIONS(41),
    [anon_sym_AT] = ACTIONS(726),
    [anon_sym_SQUOTE] = ACTIONS(728),
    [anon_sym_BQUOTE] = ACTIONS(730),
    [anon_sym_TILDE_AT] = ACTIONS(732),
    [anon_sym_TILDE] = ACTIONS(734),
  },
  [155] = {
    [sym__gap] = STATE(301),
    [sym_dis_expr] = STATE(301),
    [sym__form] = STATE(276),
    [sym_kwd_lit] = STATE(276),
    [sym_str_lit] = STATE(276),
    [sym_sym_lit] = STATE(276),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(276),
    [sym__bare_list_lit] = STATE(218),
    [sym_map_lit] = STATE(276),
    [sym__bare_map_lit] = STATE(219),
    [sym_vec_lit] = STATE(276),
    [sym__bare_vec_lit] = STATE(226),
    [sym_set_lit] = STATE(276),
    [sym__bare_set_lit] = STATE(227),
    [sym_anon_fn_lit] = STATE(276),
    [sym_regex_lit] = STATE(276),
    [sym_read_cond_lit] = STATE(276),
    [sym_splicing_read_cond_lit] = STATE(276),
    [sym_ns_map_lit] = STATE(276),
    [sym_var_quoting_lit] = STATE(276),
    [sym_sym_val_lit] = STATE(276),
    [sym_evaling_lit] = STATE(276),
    [sym_tagged_or_ctor_lit] = STATE(276),
    [sym_derefing_lit] = STATE(276),
    [sym_quoting_lit] = STATE(276),
    [sym_syn_quoting_lit] = STATE(276),
    [sym_unquote_splicing_lit] = STATE(276),
    [sym_unquoting_lit] = STATE(276),
    [aux_sym_dis_expr_repeat1] = STATE(301),
    [aux_sym_sym_lit_repeat1] = STATE(303),
    [sym__ws] = ACTIONS(264),
    [sym_comment] = ACTIONS(264),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(576),
    [anon_sym_SLASH] = ACTIONS(9),
    [anon_sym_COLON] = ACTIONS(716),
    [anon_sym_COLON_COLON] = ACTIONS(718),
    [aux_sym_str_lit_token1] = ACTIONS(15),
    [sym_char_lit] = ACTIONS(576),
    [sym_nil_lit] = ACTIONS(578),
    [sym_bool_lit] = ACTIONS(578),
    [aux_sym__sym_qualified_token1] = ACTIONS(19),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_POUND] = ACTIONS(720),
    [anon_sym_POUND_QMARK] = ACTIONS(33),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(35),
    [anon_sym_POUND_SQUOTE] = ACTIONS(722),
    [anon_sym_POUND_POUND] = ACTIONS(724),
    [anon_sym_POUND_EQ] = ACTIONS(41),
    [anon_sym_AT] = ACTIONS(726),
    [anon_sym_SQUOTE] = ACTIONS(728),
    [anon_sym_BQUOTE] = ACTIONS(730),
    [anon_sym_TILDE_AT] = ACTIONS(732),
    [anon_sym_TILDE] = ACTIONS(734),
  },
  [156] = {
    [sym__gap] = STATE(301),
    [sym_dis_expr] = STATE(301),
    [sym__form] = STATE(275),
    [sym_kwd_lit] = STATE(275),
    [sym_str_lit] = STATE(275),
    [sym_sym_lit] = STATE(275),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(275),
    [sym__bare_list_lit] = STATE(218),
    [sym_map_lit] = STATE(275),
    [sym__bare_map_lit] = STATE(219),
    [sym_vec_lit] = STATE(275),
    [sym__bare_vec_lit] = STATE(226),
    [sym_set_lit] = STATE(275),
    [sym__bare_set_lit] = STATE(227),
    [sym_anon_fn_lit] = STATE(275),
    [sym_regex_lit] = STATE(275),
    [sym_read_cond_lit] = STATE(275),
    [sym_splicing_read_cond_lit] = STATE(275),
    [sym_ns_map_lit] = STATE(275),
    [sym_var_quoting_lit] = STATE(275),
    [sym_sym_val_lit] = STATE(275),
    [sym_evaling_lit] = STATE(275),
    [sym_tagged_or_ctor_lit] = STATE(275),
    [sym_derefing_lit] = STATE(275),
    [sym_quoting_lit] = STATE(275),
    [sym_syn_quoting_lit] = STATE(275),
    [sym_unquote_splicing_lit] = STATE(275),
    [sym_unquoting_lit] = STATE(275),
    [aux_sym_dis_expr_repeat1] = STATE(301),
    [aux_sym_sym_lit_repeat1] = STATE(303),
    [sym__ws] = ACTIONS(264),
    [sym_comment] = ACTIONS(264),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(566),
    [anon_sym_SLASH] = ACTIONS(9),
    [anon_sym_COLON] = ACTIONS(716),
    [anon_sym_COLON_COLON] = ACTIONS(718),
    [aux_sym_str_lit_token1] = ACTIONS(15),
    [sym_char_lit] = ACTIONS(566),
    [sym_nil_lit] = ACTIONS(568),
    [sym_bool_lit] = ACTIONS(568),
    [aux_sym__sym_qualified_token1] = ACTIONS(19),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_POUND] = ACTIONS(720),
    [anon_sym_POUND_QMARK] = ACTIONS(33),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(35),
    [anon_sym_POUND_SQUOTE] = ACTIONS(722),
    [anon_sym_POUND_POUND] = ACTIONS(724),
    [anon_sym_POUND_EQ] = ACTIONS(41),
    [anon_sym_AT] = ACTIONS(726),
    [anon_sym_SQUOTE] = ACTIONS(728),
    [anon_sym_BQUOTE] = ACTIONS(730),
    [anon_sym_TILDE_AT] = ACTIONS(732),
    [anon_sym_TILDE] = ACTIONS(734),
  },
  [157] = {
    [sym__gap] = STATE(301),
    [sym_dis_expr] = STATE(301),
    [sym__form] = STATE(271),
    [sym_kwd_lit] = STATE(271),
    [sym_str_lit] = STATE(271),
    [sym_sym_lit] = STATE(271),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(271),
    [sym__bare_list_lit] = STATE(218),
    [sym_map_lit] = STATE(271),
    [sym__bare_map_lit] = STATE(219),
    [sym_vec_lit] = STATE(271),
    [sym__bare_vec_lit] = STATE(226),
    [sym_set_lit] = STATE(271),
    [sym__bare_set_lit] = STATE(227),
    [sym_anon_fn_lit] = STATE(271),
    [sym_regex_lit] = STATE(271),
    [sym_read_cond_lit] = STATE(271),
    [sym_splicing_read_cond_lit] = STATE(271),
    [sym_ns_map_lit] = STATE(271),
    [sym_var_quoting_lit] = STATE(271),
    [sym_sym_val_lit] = STATE(271),
    [sym_evaling_lit] = STATE(271),
    [sym_tagged_or_ctor_lit] = STATE(271),
    [sym_derefing_lit] = STATE(271),
    [sym_quoting_lit] = STATE(271),
    [sym_syn_quoting_lit] = STATE(271),
    [sym_unquote_splicing_lit] = STATE(271),
    [sym_unquoting_lit] = STATE(271),
    [aux_sym_dis_expr_repeat1] = STATE(301),
    [aux_sym_sym_lit_repeat1] = STATE(303),
    [sym__ws] = ACTIONS(264),
    [sym_comment] = ACTIONS(264),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(540),
    [anon_sym_SLASH] = ACTIONS(9),
    [anon_sym_COLON] = ACTIONS(716),
    [anon_sym_COLON_COLON] = ACTIONS(718),
    [aux_sym_str_lit_token1] = ACTIONS(15),
    [sym_char_lit] = ACTIONS(540),
    [sym_nil_lit] = ACTIONS(542),
    [sym_bool_lit] = ACTIONS(542),
    [aux_sym__sym_qualified_token1] = ACTIONS(19),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_POUND] = ACTIONS(720),
    [anon_sym_POUND_QMARK] = ACTIONS(33),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(35),
    [anon_sym_POUND_SQUOTE] = ACTIONS(722),
    [anon_sym_POUND_POUND] = ACTIONS(724),
    [anon_sym_POUND_EQ] = ACTIONS(41),
    [anon_sym_AT] = ACTIONS(726),
    [anon_sym_SQUOTE] = ACTIONS(728),
    [anon_sym_BQUOTE] = ACTIONS(730),
    [anon_sym_TILDE_AT] = ACTIONS(732),
    [anon_sym_TILDE] = ACTIONS(734),
  },
  [158] = {
    [sym__gap] = STATE(301),
    [sym_dis_expr] = STATE(301),
    [sym__form] = STATE(265),
    [sym_kwd_lit] = STATE(265),
    [sym_str_lit] = STATE(265),
    [sym_sym_lit] = STATE(265),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(265),
    [sym__bare_list_lit] = STATE(218),
    [sym_map_lit] = STATE(265),
    [sym__bare_map_lit] = STATE(219),
    [sym_vec_lit] = STATE(265),
    [sym__bare_vec_lit] = STATE(226),
    [sym_set_lit] = STATE(265),
    [sym__bare_set_lit] = STATE(227),
    [sym_anon_fn_lit] = STATE(265),
    [sym_regex_lit] = STATE(265),
    [sym_read_cond_lit] = STATE(265),
    [sym_splicing_read_cond_lit] = STATE(265),
    [sym_ns_map_lit] = STATE(265),
    [sym_var_quoting_lit] = STATE(265),
    [sym_sym_val_lit] = STATE(265),
    [sym_evaling_lit] = STATE(265),
    [sym_tagged_or_ctor_lit] = STATE(265),
    [sym_derefing_lit] = STATE(265),
    [sym_quoting_lit] = STATE(265),
    [sym_syn_quoting_lit] = STATE(265),
    [sym_unquote_splicing_lit] = STATE(265),
    [sym_unquoting_lit] = STATE(265),
    [aux_sym_dis_expr_repeat1] = STATE(301),
    [aux_sym_sym_lit_repeat1] = STATE(305),
    [sym__ws] = ACTIONS(264),
    [sym_comment] = ACTIONS(264),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(750),
    [anon_sym_SLASH] = ACTIONS(9),
    [anon_sym_COLON] = ACTIONS(11),
    [anon_sym_COLON_COLON] = ACTIONS(13),
    [aux_sym_str_lit_token1] = ACTIONS(15),
    [sym_char_lit] = ACTIONS(750),
    [sym_nil_lit] = ACTIONS(752),
    [sym_bool_lit] = ACTIONS(752),
    [aux_sym__sym_qualified_token1] = ACTIONS(19),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_POUND] = ACTIONS(31),
    [anon_sym_POUND_QMARK] = ACTIONS(33),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(35),
    [anon_sym_POUND_SQUOTE] = ACTIONS(37),
    [anon_sym_POUND_POUND] = ACTIONS(39),
    [anon_sym_POUND_EQ] = ACTIONS(41),
    [anon_sym_AT] = ACTIONS(43),
    [anon_sym_SQUOTE] = ACTIONS(45),
    [anon_sym_BQUOTE] = ACTIONS(47),
    [anon_sym_TILDE_AT] = ACTIONS(49),
    [anon_sym_TILDE] = ACTIONS(51),
  },
  [159] = {
    [sym__gap] = STATE(301),
    [sym_dis_expr] = STATE(301),
    [sym__form] = STATE(270),
    [sym_kwd_lit] = STATE(270),
    [sym_str_lit] = STATE(270),
    [sym_sym_lit] = STATE(270),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(270),
    [sym__bare_list_lit] = STATE(218),
    [sym_map_lit] = STATE(270),
    [sym__bare_map_lit] = STATE(219),
    [sym_vec_lit] = STATE(270),
    [sym__bare_vec_lit] = STATE(226),
    [sym_set_lit] = STATE(270),
    [sym__bare_set_lit] = STATE(227),
    [sym_anon_fn_lit] = STATE(270),
    [sym_regex_lit] = STATE(270),
    [sym_read_cond_lit] = STATE(270),
    [sym_splicing_read_cond_lit] = STATE(270),
    [sym_ns_map_lit] = STATE(270),
    [sym_var_quoting_lit] = STATE(270),
    [sym_sym_val_lit] = STATE(270),
    [sym_evaling_lit] = STATE(270),
    [sym_tagged_or_ctor_lit] = STATE(270),
    [sym_derefing_lit] = STATE(270),
    [sym_quoting_lit] = STATE(270),
    [sym_syn_quoting_lit] = STATE(270),
    [sym_unquote_splicing_lit] = STATE(270),
    [sym_unquoting_lit] = STATE(270),
    [aux_sym_dis_expr_repeat1] = STATE(301),
    [aux_sym_sym_lit_repeat1] = STATE(303),
    [sym__ws] = ACTIONS(264),
    [sym_comment] = ACTIONS(264),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(536),
    [anon_sym_SLASH] = ACTIONS(9),
    [anon_sym_COLON] = ACTIONS(716),
    [anon_sym_COLON_COLON] = ACTIONS(718),
    [aux_sym_str_lit_token1] = ACTIONS(15),
    [sym_char_lit] = ACTIONS(536),
    [sym_nil_lit] = ACTIONS(538),
    [sym_bool_lit] = ACTIONS(538),
    [aux_sym__sym_qualified_token1] = ACTIONS(19),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_POUND] = ACTIONS(720),
    [anon_sym_POUND_QMARK] = ACTIONS(33),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(35),
    [anon_sym_POUND_SQUOTE] = ACTIONS(722),
    [anon_sym_POUND_POUND] = ACTIONS(724),
    [anon_sym_POUND_EQ] = ACTIONS(41),
    [anon_sym_AT] = ACTIONS(726),
    [anon_sym_SQUOTE] = ACTIONS(728),
    [anon_sym_BQUOTE] = ACTIONS(730),
    [anon_sym_TILDE_AT] = ACTIONS(732),
    [anon_sym_TILDE] = ACTIONS(734),
  },
  [160] = {
    [sym__gap] = STATE(139),
    [sym_dis_expr] = STATE(139),
    [sym__form] = STATE(267),
    [sym_kwd_lit] = STATE(267),
    [sym_str_lit] = STATE(267),
    [sym_sym_lit] = STATE(267),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(267),
    [sym__bare_list_lit] = STATE(218),
    [sym_map_lit] = STATE(267),
    [sym__bare_map_lit] = STATE(219),
    [sym_vec_lit] = STATE(267),
    [sym__bare_vec_lit] = STATE(226),
    [sym_set_lit] = STATE(267),
    [sym__bare_set_lit] = STATE(227),
    [sym_anon_fn_lit] = STATE(267),
    [sym_regex_lit] = STATE(267),
    [sym_read_cond_lit] = STATE(267),
    [sym_splicing_read_cond_lit] = STATE(267),
    [sym_ns_map_lit] = STATE(267),
    [sym_var_quoting_lit] = STATE(267),
    [sym_sym_val_lit] = STATE(267),
    [sym_evaling_lit] = STATE(267),
    [sym_tagged_or_ctor_lit] = STATE(267),
    [sym_derefing_lit] = STATE(267),
    [sym_quoting_lit] = STATE(267),
    [sym_syn_quoting_lit] = STATE(267),
    [sym_unquote_splicing_lit] = STATE(267),
    [sym_unquoting_lit] = STATE(267),
    [aux_sym_dis_expr_repeat1] = STATE(139),
    [aux_sym_sym_lit_repeat1] = STATE(303),
    [sym__ws] = ACTIONS(800),
    [sym_comment] = ACTIONS(800),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(310),
    [anon_sym_SLASH] = ACTIONS(9),
    [anon_sym_COLON] = ACTIONS(716),
    [anon_sym_COLON_COLON] = ACTIONS(718),
    [aux_sym_str_lit_token1] = ACTIONS(15),
    [sym_char_lit] = ACTIONS(310),
    [sym_nil_lit] = ACTIONS(312),
    [sym_bool_lit] = ACTIONS(312),
    [aux_sym__sym_qualified_token1] = ACTIONS(19),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_POUND] = ACTIONS(720),
    [anon_sym_POUND_QMARK] = ACTIONS(33),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(35),
    [anon_sym_POUND_SQUOTE] = ACTIONS(722),
    [anon_sym_POUND_POUND] = ACTIONS(724),
    [anon_sym_POUND_EQ] = ACTIONS(41),
    [anon_sym_AT] = ACTIONS(726),
    [anon_sym_SQUOTE] = ACTIONS(728),
    [anon_sym_BQUOTE] = ACTIONS(730),
    [anon_sym_TILDE_AT] = ACTIONS(732),
    [anon_sym_TILDE] = ACTIONS(734),
  },
  [161] = {
    [sym__gap] = STATE(301),
    [sym_dis_expr] = STATE(301),
    [sym__form] = STATE(327),
    [sym_kwd_lit] = STATE(327),
    [sym_str_lit] = STATE(327),
    [sym_sym_lit] = STATE(327),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(327),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(327),
    [sym__bare_map_lit] = STATE(403),
    [sym_vec_lit] = STATE(327),
    [sym__bare_vec_lit] = STATE(423),
    [sym_set_lit] = STATE(327),
    [sym__bare_set_lit] = STATE(374),
    [sym_anon_fn_lit] = STATE(327),
    [sym_regex_lit] = STATE(327),
    [sym_read_cond_lit] = STATE(327),
    [sym_splicing_read_cond_lit] = STATE(327),
    [sym_ns_map_lit] = STATE(327),
    [sym_var_quoting_lit] = STATE(327),
    [sym_sym_val_lit] = STATE(327),
    [sym_evaling_lit] = STATE(327),
    [sym_tagged_or_ctor_lit] = STATE(327),
    [sym_derefing_lit] = STATE(327),
    [sym_quoting_lit] = STATE(327),
    [sym_syn_quoting_lit] = STATE(327),
    [sym_unquote_splicing_lit] = STATE(327),
    [sym_unquoting_lit] = STATE(327),
    [aux_sym_dis_expr_repeat1] = STATE(301),
    [aux_sym_sym_lit_repeat1] = STATE(307),
    [sym__ws] = ACTIONS(264),
    [sym_comment] = ACTIONS(264),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(588),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(352),
    [anon_sym_COLON_COLON] = ACTIONS(354),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(588),
    [sym_nil_lit] = ACTIONS(590),
    [sym_bool_lit] = ACTIONS(590),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(358),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(360),
    [anon_sym_POUND_POUND] = ACTIONS(362),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(364),
    [anon_sym_SQUOTE] = ACTIONS(366),
    [anon_sym_BQUOTE] = ACTIONS(368),
    [anon_sym_TILDE_AT] = ACTIONS(370),
    [anon_sym_TILDE] = ACTIONS(372),
  },
  [162] = {
    [sym__gap] = STATE(46),
    [sym_dis_expr] = STATE(46),
    [sym__form] = STATE(363),
    [sym_kwd_lit] = STATE(363),
    [sym_str_lit] = STATE(363),
    [sym_sym_lit] = STATE(363),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(363),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(363),
    [sym__bare_map_lit] = STATE(403),
    [sym_vec_lit] = STATE(363),
    [sym__bare_vec_lit] = STATE(423),
    [sym_set_lit] = STATE(363),
    [sym__bare_set_lit] = STATE(374),
    [sym_anon_fn_lit] = STATE(363),
    [sym_regex_lit] = STATE(363),
    [sym_read_cond_lit] = STATE(363),
    [sym_splicing_read_cond_lit] = STATE(363),
    [sym_ns_map_lit] = STATE(363),
    [sym_var_quoting_lit] = STATE(363),
    [sym_sym_val_lit] = STATE(363),
    [sym_evaling_lit] = STATE(363),
    [sym_tagged_or_ctor_lit] = STATE(363),
    [sym_derefing_lit] = STATE(363),
    [sym_quoting_lit] = STATE(363),
    [sym_syn_quoting_lit] = STATE(363),
    [sym_unquote_splicing_lit] = STATE(363),
    [sym_unquoting_lit] = STATE(363),
    [aux_sym_dis_expr_repeat1] = STATE(46),
    [aux_sym_sym_lit_repeat1] = STATE(306),
    [sym__ws] = ACTIONS(802),
    [sym_comment] = ACTIONS(802),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(546),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(426),
    [anon_sym_COLON_COLON] = ACTIONS(428),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(546),
    [sym_nil_lit] = ACTIONS(548),
    [sym_bool_lit] = ACTIONS(548),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(430),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(432),
    [anon_sym_POUND_POUND] = ACTIONS(434),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(436),
    [anon_sym_SQUOTE] = ACTIONS(438),
    [anon_sym_BQUOTE] = ACTIONS(440),
    [anon_sym_TILDE_AT] = ACTIONS(442),
    [anon_sym_TILDE] = ACTIONS(444),
  },
  [163] = {
    [sym__gap] = STATE(301),
    [sym_dis_expr] = STATE(301),
    [sym__form] = STATE(225),
    [sym_kwd_lit] = STATE(225),
    [sym_str_lit] = STATE(225),
    [sym_sym_lit] = STATE(225),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(225),
    [sym__bare_list_lit] = STATE(218),
    [sym_map_lit] = STATE(225),
    [sym__bare_map_lit] = STATE(219),
    [sym_vec_lit] = STATE(225),
    [sym__bare_vec_lit] = STATE(226),
    [sym_set_lit] = STATE(225),
    [sym__bare_set_lit] = STATE(227),
    [sym_anon_fn_lit] = STATE(225),
    [sym_regex_lit] = STATE(225),
    [sym_read_cond_lit] = STATE(225),
    [sym_splicing_read_cond_lit] = STATE(225),
    [sym_ns_map_lit] = STATE(225),
    [sym_var_quoting_lit] = STATE(225),
    [sym_sym_val_lit] = STATE(225),
    [sym_evaling_lit] = STATE(225),
    [sym_tagged_or_ctor_lit] = STATE(225),
    [sym_derefing_lit] = STATE(225),
    [sym_quoting_lit] = STATE(225),
    [sym_syn_quoting_lit] = STATE(225),
    [sym_unquote_splicing_lit] = STATE(225),
    [sym_unquoting_lit] = STATE(225),
    [aux_sym_dis_expr_repeat1] = STATE(301),
    [aux_sym_sym_lit_repeat1] = STATE(305),
    [sym__ws] = ACTIONS(264),
    [sym_comment] = ACTIONS(264),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(746),
    [anon_sym_SLASH] = ACTIONS(9),
    [anon_sym_COLON] = ACTIONS(11),
    [anon_sym_COLON_COLON] = ACTIONS(13),
    [aux_sym_str_lit_token1] = ACTIONS(15),
    [sym_char_lit] = ACTIONS(746),
    [sym_nil_lit] = ACTIONS(748),
    [sym_bool_lit] = ACTIONS(748),
    [aux_sym__sym_qualified_token1] = ACTIONS(19),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_POUND] = ACTIONS(31),
    [anon_sym_POUND_QMARK] = ACTIONS(33),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(35),
    [anon_sym_POUND_SQUOTE] = ACTIONS(37),
    [anon_sym_POUND_POUND] = ACTIONS(39),
    [anon_sym_POUND_EQ] = ACTIONS(41),
    [anon_sym_AT] = ACTIONS(43),
    [anon_sym_SQUOTE] = ACTIONS(45),
    [anon_sym_BQUOTE] = ACTIONS(47),
    [anon_sym_TILDE_AT] = ACTIONS(49),
    [anon_sym_TILDE] = ACTIONS(51),
  },
  [164] = {
    [sym__gap] = STATE(44),
    [sym_dis_expr] = STATE(44),
    [sym__form] = STATE(361),
    [sym_kwd_lit] = STATE(361),
    [sym_str_lit] = STATE(361),
    [sym_sym_lit] = STATE(361),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(361),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(361),
    [sym__bare_map_lit] = STATE(403),
    [sym_vec_lit] = STATE(361),
    [sym__bare_vec_lit] = STATE(423),
    [sym_set_lit] = STATE(361),
    [sym__bare_set_lit] = STATE(374),
    [sym_anon_fn_lit] = STATE(361),
    [sym_regex_lit] = STATE(361),
    [sym_read_cond_lit] = STATE(361),
    [sym_splicing_read_cond_lit] = STATE(361),
    [sym_ns_map_lit] = STATE(361),
    [sym_var_quoting_lit] = STATE(361),
    [sym_sym_val_lit] = STATE(361),
    [sym_evaling_lit] = STATE(361),
    [sym_tagged_or_ctor_lit] = STATE(361),
    [sym_derefing_lit] = STATE(361),
    [sym_quoting_lit] = STATE(361),
    [sym_syn_quoting_lit] = STATE(361),
    [sym_unquote_splicing_lit] = STATE(361),
    [sym_unquoting_lit] = STATE(361),
    [aux_sym_dis_expr_repeat1] = STATE(44),
    [aux_sym_sym_lit_repeat1] = STATE(306),
    [sym__ws] = ACTIONS(804),
    [sym_comment] = ACTIONS(804),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(552),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(426),
    [anon_sym_COLON_COLON] = ACTIONS(428),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(552),
    [sym_nil_lit] = ACTIONS(554),
    [sym_bool_lit] = ACTIONS(554),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(430),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(432),
    [anon_sym_POUND_POUND] = ACTIONS(434),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(436),
    [anon_sym_SQUOTE] = ACTIONS(438),
    [anon_sym_BQUOTE] = ACTIONS(440),
    [anon_sym_TILDE_AT] = ACTIONS(442),
    [anon_sym_TILDE] = ACTIONS(444),
  },
  [165] = {
    [sym__gap] = STATE(301),
    [sym_dis_expr] = STATE(301),
    [sym__form] = STATE(329),
    [sym_kwd_lit] = STATE(329),
    [sym_str_lit] = STATE(329),
    [sym_sym_lit] = STATE(329),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(329),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(329),
    [sym__bare_map_lit] = STATE(403),
    [sym_vec_lit] = STATE(329),
    [sym__bare_vec_lit] = STATE(423),
    [sym_set_lit] = STATE(329),
    [sym__bare_set_lit] = STATE(374),
    [sym_anon_fn_lit] = STATE(329),
    [sym_regex_lit] = STATE(329),
    [sym_read_cond_lit] = STATE(329),
    [sym_splicing_read_cond_lit] = STATE(329),
    [sym_ns_map_lit] = STATE(329),
    [sym_var_quoting_lit] = STATE(329),
    [sym_sym_val_lit] = STATE(329),
    [sym_evaling_lit] = STATE(329),
    [sym_tagged_or_ctor_lit] = STATE(329),
    [sym_derefing_lit] = STATE(329),
    [sym_quoting_lit] = STATE(329),
    [sym_syn_quoting_lit] = STATE(329),
    [sym_unquote_splicing_lit] = STATE(329),
    [sym_unquoting_lit] = STATE(329),
    [aux_sym_dis_expr_repeat1] = STATE(301),
    [aux_sym_sym_lit_repeat1] = STATE(307),
    [sym__ws] = ACTIONS(264),
    [sym_comment] = ACTIONS(264),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(580),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(352),
    [anon_sym_COLON_COLON] = ACTIONS(354),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(580),
    [sym_nil_lit] = ACTIONS(582),
    [sym_bool_lit] = ACTIONS(582),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(358),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(360),
    [anon_sym_POUND_POUND] = ACTIONS(362),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(364),
    [anon_sym_SQUOTE] = ACTIONS(366),
    [anon_sym_BQUOTE] = ACTIONS(368),
    [anon_sym_TILDE_AT] = ACTIONS(370),
    [anon_sym_TILDE] = ACTIONS(372),
  },
  [166] = {
    [sym__gap] = STATE(183),
    [sym_dis_expr] = STATE(183),
    [sym__form] = STATE(292),
    [sym_kwd_lit] = STATE(292),
    [sym_str_lit] = STATE(292),
    [sym_sym_lit] = STATE(292),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(292),
    [sym__bare_list_lit] = STATE(218),
    [sym_map_lit] = STATE(292),
    [sym__bare_map_lit] = STATE(219),
    [sym_vec_lit] = STATE(292),
    [sym__bare_vec_lit] = STATE(226),
    [sym_set_lit] = STATE(292),
    [sym__bare_set_lit] = STATE(227),
    [sym_anon_fn_lit] = STATE(292),
    [sym_regex_lit] = STATE(292),
    [sym_read_cond_lit] = STATE(292),
    [sym_splicing_read_cond_lit] = STATE(292),
    [sym_ns_map_lit] = STATE(292),
    [sym_var_quoting_lit] = STATE(292),
    [sym_sym_val_lit] = STATE(292),
    [sym_evaling_lit] = STATE(292),
    [sym_tagged_or_ctor_lit] = STATE(292),
    [sym_derefing_lit] = STATE(292),
    [sym_quoting_lit] = STATE(292),
    [sym_syn_quoting_lit] = STATE(292),
    [sym_unquote_splicing_lit] = STATE(292),
    [sym_unquoting_lit] = STATE(292),
    [aux_sym_dis_expr_repeat1] = STATE(183),
    [aux_sym_sym_lit_repeat1] = STATE(305),
    [sym__ws] = ACTIONS(806),
    [sym_comment] = ACTIONS(806),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(742),
    [anon_sym_SLASH] = ACTIONS(9),
    [anon_sym_COLON] = ACTIONS(11),
    [anon_sym_COLON_COLON] = ACTIONS(13),
    [aux_sym_str_lit_token1] = ACTIONS(15),
    [sym_char_lit] = ACTIONS(742),
    [sym_nil_lit] = ACTIONS(744),
    [sym_bool_lit] = ACTIONS(744),
    [aux_sym__sym_qualified_token1] = ACTIONS(19),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_POUND] = ACTIONS(31),
    [anon_sym_POUND_QMARK] = ACTIONS(33),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(35),
    [anon_sym_POUND_SQUOTE] = ACTIONS(37),
    [anon_sym_POUND_POUND] = ACTIONS(39),
    [anon_sym_POUND_EQ] = ACTIONS(41),
    [anon_sym_AT] = ACTIONS(43),
    [anon_sym_SQUOTE] = ACTIONS(45),
    [anon_sym_BQUOTE] = ACTIONS(47),
    [anon_sym_TILDE_AT] = ACTIONS(49),
    [anon_sym_TILDE] = ACTIONS(51),
  },
  [167] = {
    [sym__gap] = STATE(301),
    [sym_dis_expr] = STATE(301),
    [sym__form] = STATE(257),
    [sym_kwd_lit] = STATE(257),
    [sym_str_lit] = STATE(257),
    [sym_sym_lit] = STATE(257),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(257),
    [sym__bare_list_lit] = STATE(218),
    [sym_map_lit] = STATE(257),
    [sym__bare_map_lit] = STATE(219),
    [sym_vec_lit] = STATE(257),
    [sym__bare_vec_lit] = STATE(226),
    [sym_set_lit] = STATE(257),
    [sym__bare_set_lit] = STATE(227),
    [sym_anon_fn_lit] = STATE(257),
    [sym_regex_lit] = STATE(257),
    [sym_read_cond_lit] = STATE(257),
    [sym_splicing_read_cond_lit] = STATE(257),
    [sym_ns_map_lit] = STATE(257),
    [sym_var_quoting_lit] = STATE(257),
    [sym_sym_val_lit] = STATE(257),
    [sym_evaling_lit] = STATE(257),
    [sym_tagged_or_ctor_lit] = STATE(257),
    [sym_derefing_lit] = STATE(257),
    [sym_quoting_lit] = STATE(257),
    [sym_syn_quoting_lit] = STATE(257),
    [sym_unquote_splicing_lit] = STATE(257),
    [sym_unquoting_lit] = STATE(257),
    [aux_sym_dis_expr_repeat1] = STATE(301),
    [aux_sym_sym_lit_repeat1] = STATE(303),
    [sym__ws] = ACTIONS(264),
    [sym_comment] = ACTIONS(264),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(422),
    [anon_sym_SLASH] = ACTIONS(9),
    [anon_sym_COLON] = ACTIONS(716),
    [anon_sym_COLON_COLON] = ACTIONS(718),
    [aux_sym_str_lit_token1] = ACTIONS(15),
    [sym_char_lit] = ACTIONS(422),
    [sym_nil_lit] = ACTIONS(424),
    [sym_bool_lit] = ACTIONS(424),
    [aux_sym__sym_qualified_token1] = ACTIONS(19),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_POUND] = ACTIONS(720),
    [anon_sym_POUND_QMARK] = ACTIONS(33),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(35),
    [anon_sym_POUND_SQUOTE] = ACTIONS(722),
    [anon_sym_POUND_POUND] = ACTIONS(724),
    [anon_sym_POUND_EQ] = ACTIONS(41),
    [anon_sym_AT] = ACTIONS(726),
    [anon_sym_SQUOTE] = ACTIONS(728),
    [anon_sym_BQUOTE] = ACTIONS(730),
    [anon_sym_TILDE_AT] = ACTIONS(732),
    [anon_sym_TILDE] = ACTIONS(734),
  },
  [168] = {
    [sym__gap] = STATE(151),
    [sym_dis_expr] = STATE(151),
    [sym__form] = STATE(248),
    [sym_kwd_lit] = STATE(248),
    [sym_str_lit] = STATE(248),
    [sym_sym_lit] = STATE(248),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(248),
    [sym__bare_list_lit] = STATE(218),
    [sym_map_lit] = STATE(248),
    [sym__bare_map_lit] = STATE(219),
    [sym_vec_lit] = STATE(248),
    [sym__bare_vec_lit] = STATE(226),
    [sym_set_lit] = STATE(248),
    [sym__bare_set_lit] = STATE(227),
    [sym_anon_fn_lit] = STATE(248),
    [sym_regex_lit] = STATE(248),
    [sym_read_cond_lit] = STATE(248),
    [sym_splicing_read_cond_lit] = STATE(248),
    [sym_ns_map_lit] = STATE(248),
    [sym_var_quoting_lit] = STATE(248),
    [sym_sym_val_lit] = STATE(248),
    [sym_evaling_lit] = STATE(248),
    [sym_tagged_or_ctor_lit] = STATE(248),
    [sym_derefing_lit] = STATE(248),
    [sym_quoting_lit] = STATE(248),
    [sym_syn_quoting_lit] = STATE(248),
    [sym_unquote_splicing_lit] = STATE(248),
    [sym_unquoting_lit] = STATE(248),
    [aux_sym_dis_expr_repeat1] = STATE(151),
    [aux_sym_sym_lit_repeat1] = STATE(303),
    [sym__ws] = ACTIONS(808),
    [sym_comment] = ACTIONS(808),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(346),
    [anon_sym_SLASH] = ACTIONS(9),
    [anon_sym_COLON] = ACTIONS(716),
    [anon_sym_COLON_COLON] = ACTIONS(718),
    [aux_sym_str_lit_token1] = ACTIONS(15),
    [sym_char_lit] = ACTIONS(346),
    [sym_nil_lit] = ACTIONS(348),
    [sym_bool_lit] = ACTIONS(348),
    [aux_sym__sym_qualified_token1] = ACTIONS(19),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_POUND] = ACTIONS(720),
    [anon_sym_POUND_QMARK] = ACTIONS(33),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(35),
    [anon_sym_POUND_SQUOTE] = ACTIONS(722),
    [anon_sym_POUND_POUND] = ACTIONS(724),
    [anon_sym_POUND_EQ] = ACTIONS(41),
    [anon_sym_AT] = ACTIONS(726),
    [anon_sym_SQUOTE] = ACTIONS(728),
    [anon_sym_BQUOTE] = ACTIONS(730),
    [anon_sym_TILDE_AT] = ACTIONS(732),
    [anon_sym_TILDE] = ACTIONS(734),
  },
  [169] = {
    [sym__gap] = STATE(153),
    [sym_dis_expr] = STATE(153),
    [sym__form] = STATE(247),
    [sym_kwd_lit] = STATE(247),
    [sym_str_lit] = STATE(247),
    [sym_sym_lit] = STATE(247),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(247),
    [sym__bare_list_lit] = STATE(218),
    [sym_map_lit] = STATE(247),
    [sym__bare_map_lit] = STATE(219),
    [sym_vec_lit] = STATE(247),
    [sym__bare_vec_lit] = STATE(226),
    [sym_set_lit] = STATE(247),
    [sym__bare_set_lit] = STATE(227),
    [sym_anon_fn_lit] = STATE(247),
    [sym_regex_lit] = STATE(247),
    [sym_read_cond_lit] = STATE(247),
    [sym_splicing_read_cond_lit] = STATE(247),
    [sym_ns_map_lit] = STATE(247),
    [sym_var_quoting_lit] = STATE(247),
    [sym_sym_val_lit] = STATE(247),
    [sym_evaling_lit] = STATE(247),
    [sym_tagged_or_ctor_lit] = STATE(247),
    [sym_derefing_lit] = STATE(247),
    [sym_quoting_lit] = STATE(247),
    [sym_syn_quoting_lit] = STATE(247),
    [sym_unquote_splicing_lit] = STATE(247),
    [sym_unquoting_lit] = STATE(247),
    [aux_sym_dis_expr_repeat1] = STATE(153),
    [aux_sym_sym_lit_repeat1] = STATE(303),
    [sym__ws] = ACTIONS(810),
    [sym_comment] = ACTIONS(810),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(340),
    [anon_sym_SLASH] = ACTIONS(9),
    [anon_sym_COLON] = ACTIONS(716),
    [anon_sym_COLON_COLON] = ACTIONS(718),
    [aux_sym_str_lit_token1] = ACTIONS(15),
    [sym_char_lit] = ACTIONS(340),
    [sym_nil_lit] = ACTIONS(342),
    [sym_bool_lit] = ACTIONS(342),
    [aux_sym__sym_qualified_token1] = ACTIONS(19),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_POUND] = ACTIONS(720),
    [anon_sym_POUND_QMARK] = ACTIONS(33),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(35),
    [anon_sym_POUND_SQUOTE] = ACTIONS(722),
    [anon_sym_POUND_POUND] = ACTIONS(724),
    [anon_sym_POUND_EQ] = ACTIONS(41),
    [anon_sym_AT] = ACTIONS(726),
    [anon_sym_SQUOTE] = ACTIONS(728),
    [anon_sym_BQUOTE] = ACTIONS(730),
    [anon_sym_TILDE_AT] = ACTIONS(732),
    [anon_sym_TILDE] = ACTIONS(734),
  },
  [170] = {
    [sym__gap] = STATE(154),
    [sym_dis_expr] = STATE(154),
    [sym__form] = STATE(246),
    [sym_kwd_lit] = STATE(246),
    [sym_str_lit] = STATE(246),
    [sym_sym_lit] = STATE(246),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(246),
    [sym__bare_list_lit] = STATE(218),
    [sym_map_lit] = STATE(246),
    [sym__bare_map_lit] = STATE(219),
    [sym_vec_lit] = STATE(246),
    [sym__bare_vec_lit] = STATE(226),
    [sym_set_lit] = STATE(246),
    [sym__bare_set_lit] = STATE(227),
    [sym_anon_fn_lit] = STATE(246),
    [sym_regex_lit] = STATE(246),
    [sym_read_cond_lit] = STATE(246),
    [sym_splicing_read_cond_lit] = STATE(246),
    [sym_ns_map_lit] = STATE(246),
    [sym_var_quoting_lit] = STATE(246),
    [sym_sym_val_lit] = STATE(246),
    [sym_evaling_lit] = STATE(246),
    [sym_tagged_or_ctor_lit] = STATE(246),
    [sym_derefing_lit] = STATE(246),
    [sym_quoting_lit] = STATE(246),
    [sym_syn_quoting_lit] = STATE(246),
    [sym_unquote_splicing_lit] = STATE(246),
    [sym_unquoting_lit] = STATE(246),
    [aux_sym_dis_expr_repeat1] = STATE(154),
    [aux_sym_sym_lit_repeat1] = STATE(303),
    [sym__ws] = ACTIONS(812),
    [sym_comment] = ACTIONS(812),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(334),
    [anon_sym_SLASH] = ACTIONS(9),
    [anon_sym_COLON] = ACTIONS(716),
    [anon_sym_COLON_COLON] = ACTIONS(718),
    [aux_sym_str_lit_token1] = ACTIONS(15),
    [sym_char_lit] = ACTIONS(334),
    [sym_nil_lit] = ACTIONS(336),
    [sym_bool_lit] = ACTIONS(336),
    [aux_sym__sym_qualified_token1] = ACTIONS(19),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_POUND] = ACTIONS(720),
    [anon_sym_POUND_QMARK] = ACTIONS(33),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(35),
    [anon_sym_POUND_SQUOTE] = ACTIONS(722),
    [anon_sym_POUND_POUND] = ACTIONS(724),
    [anon_sym_POUND_EQ] = ACTIONS(41),
    [anon_sym_AT] = ACTIONS(726),
    [anon_sym_SQUOTE] = ACTIONS(728),
    [anon_sym_BQUOTE] = ACTIONS(730),
    [anon_sym_TILDE_AT] = ACTIONS(732),
    [anon_sym_TILDE] = ACTIONS(734),
  },
  [171] = {
    [sym__gap] = STATE(155),
    [sym_dis_expr] = STATE(155),
    [sym__form] = STATE(245),
    [sym_kwd_lit] = STATE(245),
    [sym_str_lit] = STATE(245),
    [sym_sym_lit] = STATE(245),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(245),
    [sym__bare_list_lit] = STATE(218),
    [sym_map_lit] = STATE(245),
    [sym__bare_map_lit] = STATE(219),
    [sym_vec_lit] = STATE(245),
    [sym__bare_vec_lit] = STATE(226),
    [sym_set_lit] = STATE(245),
    [sym__bare_set_lit] = STATE(227),
    [sym_anon_fn_lit] = STATE(245),
    [sym_regex_lit] = STATE(245),
    [sym_read_cond_lit] = STATE(245),
    [sym_splicing_read_cond_lit] = STATE(245),
    [sym_ns_map_lit] = STATE(245),
    [sym_var_quoting_lit] = STATE(245),
    [sym_sym_val_lit] = STATE(245),
    [sym_evaling_lit] = STATE(245),
    [sym_tagged_or_ctor_lit] = STATE(245),
    [sym_derefing_lit] = STATE(245),
    [sym_quoting_lit] = STATE(245),
    [sym_syn_quoting_lit] = STATE(245),
    [sym_unquote_splicing_lit] = STATE(245),
    [sym_unquoting_lit] = STATE(245),
    [aux_sym_dis_expr_repeat1] = STATE(155),
    [aux_sym_sym_lit_repeat1] = STATE(303),
    [sym__ws] = ACTIONS(814),
    [sym_comment] = ACTIONS(814),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(328),
    [anon_sym_SLASH] = ACTIONS(9),
    [anon_sym_COLON] = ACTIONS(716),
    [anon_sym_COLON_COLON] = ACTIONS(718),
    [aux_sym_str_lit_token1] = ACTIONS(15),
    [sym_char_lit] = ACTIONS(328),
    [sym_nil_lit] = ACTIONS(330),
    [sym_bool_lit] = ACTIONS(330),
    [aux_sym__sym_qualified_token1] = ACTIONS(19),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_POUND] = ACTIONS(720),
    [anon_sym_POUND_QMARK] = ACTIONS(33),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(35),
    [anon_sym_POUND_SQUOTE] = ACTIONS(722),
    [anon_sym_POUND_POUND] = ACTIONS(724),
    [anon_sym_POUND_EQ] = ACTIONS(41),
    [anon_sym_AT] = ACTIONS(726),
    [anon_sym_SQUOTE] = ACTIONS(728),
    [anon_sym_BQUOTE] = ACTIONS(730),
    [anon_sym_TILDE_AT] = ACTIONS(732),
    [anon_sym_TILDE] = ACTIONS(734),
  },
  [172] = {
    [sym__gap] = STATE(156),
    [sym_dis_expr] = STATE(156),
    [sym__form] = STATE(244),
    [sym_kwd_lit] = STATE(244),
    [sym_str_lit] = STATE(244),
    [sym_sym_lit] = STATE(244),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(244),
    [sym__bare_list_lit] = STATE(218),
    [sym_map_lit] = STATE(244),
    [sym__bare_map_lit] = STATE(219),
    [sym_vec_lit] = STATE(244),
    [sym__bare_vec_lit] = STATE(226),
    [sym_set_lit] = STATE(244),
    [sym__bare_set_lit] = STATE(227),
    [sym_anon_fn_lit] = STATE(244),
    [sym_regex_lit] = STATE(244),
    [sym_read_cond_lit] = STATE(244),
    [sym_splicing_read_cond_lit] = STATE(244),
    [sym_ns_map_lit] = STATE(244),
    [sym_var_quoting_lit] = STATE(244),
    [sym_sym_val_lit] = STATE(244),
    [sym_evaling_lit] = STATE(244),
    [sym_tagged_or_ctor_lit] = STATE(244),
    [sym_derefing_lit] = STATE(244),
    [sym_quoting_lit] = STATE(244),
    [sym_syn_quoting_lit] = STATE(244),
    [sym_unquote_splicing_lit] = STATE(244),
    [sym_unquoting_lit] = STATE(244),
    [aux_sym_dis_expr_repeat1] = STATE(156),
    [aux_sym_sym_lit_repeat1] = STATE(303),
    [sym__ws] = ACTIONS(816),
    [sym_comment] = ACTIONS(816),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(322),
    [anon_sym_SLASH] = ACTIONS(9),
    [anon_sym_COLON] = ACTIONS(716),
    [anon_sym_COLON_COLON] = ACTIONS(718),
    [aux_sym_str_lit_token1] = ACTIONS(15),
    [sym_char_lit] = ACTIONS(322),
    [sym_nil_lit] = ACTIONS(324),
    [sym_bool_lit] = ACTIONS(324),
    [aux_sym__sym_qualified_token1] = ACTIONS(19),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_POUND] = ACTIONS(720),
    [anon_sym_POUND_QMARK] = ACTIONS(33),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(35),
    [anon_sym_POUND_SQUOTE] = ACTIONS(722),
    [anon_sym_POUND_POUND] = ACTIONS(724),
    [anon_sym_POUND_EQ] = ACTIONS(41),
    [anon_sym_AT] = ACTIONS(726),
    [anon_sym_SQUOTE] = ACTIONS(728),
    [anon_sym_BQUOTE] = ACTIONS(730),
    [anon_sym_TILDE_AT] = ACTIONS(732),
    [anon_sym_TILDE] = ACTIONS(734),
  },
  [173] = {
    [sym__gap] = STATE(157),
    [sym_dis_expr] = STATE(157),
    [sym__form] = STATE(240),
    [sym_kwd_lit] = STATE(240),
    [sym_str_lit] = STATE(240),
    [sym_sym_lit] = STATE(240),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(240),
    [sym__bare_list_lit] = STATE(218),
    [sym_map_lit] = STATE(240),
    [sym__bare_map_lit] = STATE(219),
    [sym_vec_lit] = STATE(240),
    [sym__bare_vec_lit] = STATE(226),
    [sym_set_lit] = STATE(240),
    [sym__bare_set_lit] = STATE(227),
    [sym_anon_fn_lit] = STATE(240),
    [sym_regex_lit] = STATE(240),
    [sym_read_cond_lit] = STATE(240),
    [sym_splicing_read_cond_lit] = STATE(240),
    [sym_ns_map_lit] = STATE(240),
    [sym_var_quoting_lit] = STATE(240),
    [sym_sym_val_lit] = STATE(240),
    [sym_evaling_lit] = STATE(240),
    [sym_tagged_or_ctor_lit] = STATE(240),
    [sym_derefing_lit] = STATE(240),
    [sym_quoting_lit] = STATE(240),
    [sym_syn_quoting_lit] = STATE(240),
    [sym_unquote_splicing_lit] = STATE(240),
    [sym_unquoting_lit] = STATE(240),
    [aux_sym_dis_expr_repeat1] = STATE(157),
    [aux_sym_sym_lit_repeat1] = STATE(303),
    [sym__ws] = ACTIONS(818),
    [sym_comment] = ACTIONS(818),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(706),
    [anon_sym_SLASH] = ACTIONS(9),
    [anon_sym_COLON] = ACTIONS(716),
    [anon_sym_COLON_COLON] = ACTIONS(718),
    [aux_sym_str_lit_token1] = ACTIONS(15),
    [sym_char_lit] = ACTIONS(706),
    [sym_nil_lit] = ACTIONS(708),
    [sym_bool_lit] = ACTIONS(708),
    [aux_sym__sym_qualified_token1] = ACTIONS(19),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_POUND] = ACTIONS(720),
    [anon_sym_POUND_QMARK] = ACTIONS(33),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(35),
    [anon_sym_POUND_SQUOTE] = ACTIONS(722),
    [anon_sym_POUND_POUND] = ACTIONS(724),
    [anon_sym_POUND_EQ] = ACTIONS(41),
    [anon_sym_AT] = ACTIONS(726),
    [anon_sym_SQUOTE] = ACTIONS(728),
    [anon_sym_BQUOTE] = ACTIONS(730),
    [anon_sym_TILDE_AT] = ACTIONS(732),
    [anon_sym_TILDE] = ACTIONS(734),
  },
  [174] = {
    [sym__gap] = STATE(159),
    [sym_dis_expr] = STATE(159),
    [sym__form] = STATE(239),
    [sym_kwd_lit] = STATE(239),
    [sym_str_lit] = STATE(239),
    [sym_sym_lit] = STATE(239),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(239),
    [sym__bare_list_lit] = STATE(218),
    [sym_map_lit] = STATE(239),
    [sym__bare_map_lit] = STATE(219),
    [sym_vec_lit] = STATE(239),
    [sym__bare_vec_lit] = STATE(226),
    [sym_set_lit] = STATE(239),
    [sym__bare_set_lit] = STATE(227),
    [sym_anon_fn_lit] = STATE(239),
    [sym_regex_lit] = STATE(239),
    [sym_read_cond_lit] = STATE(239),
    [sym_splicing_read_cond_lit] = STATE(239),
    [sym_ns_map_lit] = STATE(239),
    [sym_var_quoting_lit] = STATE(239),
    [sym_sym_val_lit] = STATE(239),
    [sym_evaling_lit] = STATE(239),
    [sym_tagged_or_ctor_lit] = STATE(239),
    [sym_derefing_lit] = STATE(239),
    [sym_quoting_lit] = STATE(239),
    [sym_syn_quoting_lit] = STATE(239),
    [sym_unquote_splicing_lit] = STATE(239),
    [sym_unquoting_lit] = STATE(239),
    [aux_sym_dis_expr_repeat1] = STATE(159),
    [aux_sym_sym_lit_repeat1] = STATE(303),
    [sym__ws] = ACTIONS(820),
    [sym_comment] = ACTIONS(820),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(682),
    [anon_sym_SLASH] = ACTIONS(9),
    [anon_sym_COLON] = ACTIONS(716),
    [anon_sym_COLON_COLON] = ACTIONS(718),
    [aux_sym_str_lit_token1] = ACTIONS(15),
    [sym_char_lit] = ACTIONS(682),
    [sym_nil_lit] = ACTIONS(684),
    [sym_bool_lit] = ACTIONS(684),
    [aux_sym__sym_qualified_token1] = ACTIONS(19),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_POUND] = ACTIONS(720),
    [anon_sym_POUND_QMARK] = ACTIONS(33),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(35),
    [anon_sym_POUND_SQUOTE] = ACTIONS(722),
    [anon_sym_POUND_POUND] = ACTIONS(724),
    [anon_sym_POUND_EQ] = ACTIONS(41),
    [anon_sym_AT] = ACTIONS(726),
    [anon_sym_SQUOTE] = ACTIONS(728),
    [anon_sym_BQUOTE] = ACTIONS(730),
    [anon_sym_TILDE_AT] = ACTIONS(732),
    [anon_sym_TILDE] = ACTIONS(734),
  },
  [175] = {
    [sym__gap] = STATE(176),
    [sym_dis_expr] = STATE(176),
    [sym__form] = STATE(331),
    [sym_kwd_lit] = STATE(331),
    [sym_str_lit] = STATE(331),
    [sym_sym_lit] = STATE(331),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(331),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(331),
    [sym__bare_map_lit] = STATE(403),
    [sym_vec_lit] = STATE(331),
    [sym__bare_vec_lit] = STATE(423),
    [sym_set_lit] = STATE(331),
    [sym__bare_set_lit] = STATE(374),
    [sym_anon_fn_lit] = STATE(331),
    [sym_regex_lit] = STATE(331),
    [sym_read_cond_lit] = STATE(331),
    [sym_splicing_read_cond_lit] = STATE(331),
    [sym_ns_map_lit] = STATE(331),
    [sym_var_quoting_lit] = STATE(331),
    [sym_sym_val_lit] = STATE(331),
    [sym_evaling_lit] = STATE(331),
    [sym_tagged_or_ctor_lit] = STATE(331),
    [sym_derefing_lit] = STATE(331),
    [sym_quoting_lit] = STATE(331),
    [sym_syn_quoting_lit] = STATE(331),
    [sym_unquote_splicing_lit] = STATE(331),
    [sym_unquoting_lit] = STATE(331),
    [aux_sym_dis_expr_repeat1] = STATE(176),
    [aux_sym_sym_lit_repeat1] = STATE(307),
    [sym__ws] = ACTIONS(822),
    [sym_comment] = ACTIONS(822),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(572),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(352),
    [anon_sym_COLON_COLON] = ACTIONS(354),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(572),
    [sym_nil_lit] = ACTIONS(574),
    [sym_bool_lit] = ACTIONS(574),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(358),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(360),
    [anon_sym_POUND_POUND] = ACTIONS(362),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(364),
    [anon_sym_SQUOTE] = ACTIONS(366),
    [anon_sym_BQUOTE] = ACTIONS(368),
    [anon_sym_TILDE_AT] = ACTIONS(370),
    [anon_sym_TILDE] = ACTIONS(372),
  },
  [176] = {
    [sym__gap] = STATE(301),
    [sym_dis_expr] = STATE(301),
    [sym__form] = STATE(332),
    [sym_kwd_lit] = STATE(332),
    [sym_str_lit] = STATE(332),
    [sym_sym_lit] = STATE(332),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(332),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(332),
    [sym__bare_map_lit] = STATE(403),
    [sym_vec_lit] = STATE(332),
    [sym__bare_vec_lit] = STATE(423),
    [sym_set_lit] = STATE(332),
    [sym__bare_set_lit] = STATE(374),
    [sym_anon_fn_lit] = STATE(332),
    [sym_regex_lit] = STATE(332),
    [sym_read_cond_lit] = STATE(332),
    [sym_splicing_read_cond_lit] = STATE(332),
    [sym_ns_map_lit] = STATE(332),
    [sym_var_quoting_lit] = STATE(332),
    [sym_sym_val_lit] = STATE(332),
    [sym_evaling_lit] = STATE(332),
    [sym_tagged_or_ctor_lit] = STATE(332),
    [sym_derefing_lit] = STATE(332),
    [sym_quoting_lit] = STATE(332),
    [sym_syn_quoting_lit] = STATE(332),
    [sym_unquote_splicing_lit] = STATE(332),
    [sym_unquoting_lit] = STATE(332),
    [aux_sym_dis_expr_repeat1] = STATE(301),
    [aux_sym_sym_lit_repeat1] = STATE(307),
    [sym__ws] = ACTIONS(264),
    [sym_comment] = ACTIONS(264),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(562),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(352),
    [anon_sym_COLON_COLON] = ACTIONS(354),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(562),
    [sym_nil_lit] = ACTIONS(564),
    [sym_bool_lit] = ACTIONS(564),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(358),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(360),
    [anon_sym_POUND_POUND] = ACTIONS(362),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(364),
    [anon_sym_SQUOTE] = ACTIONS(366),
    [anon_sym_BQUOTE] = ACTIONS(368),
    [anon_sym_TILDE_AT] = ACTIONS(370),
    [anon_sym_TILDE] = ACTIONS(372),
  },
  [177] = {
    [sym__gap] = STATE(53),
    [sym_dis_expr] = STATE(53),
    [sym__form] = STATE(333),
    [sym_kwd_lit] = STATE(333),
    [sym_str_lit] = STATE(333),
    [sym_sym_lit] = STATE(333),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(333),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(333),
    [sym__bare_map_lit] = STATE(403),
    [sym_vec_lit] = STATE(333),
    [sym__bare_vec_lit] = STATE(423),
    [sym_set_lit] = STATE(333),
    [sym__bare_set_lit] = STATE(374),
    [sym_anon_fn_lit] = STATE(333),
    [sym_regex_lit] = STATE(333),
    [sym_read_cond_lit] = STATE(333),
    [sym_splicing_read_cond_lit] = STATE(333),
    [sym_ns_map_lit] = STATE(333),
    [sym_var_quoting_lit] = STATE(333),
    [sym_sym_val_lit] = STATE(333),
    [sym_evaling_lit] = STATE(333),
    [sym_tagged_or_ctor_lit] = STATE(333),
    [sym_derefing_lit] = STATE(333),
    [sym_quoting_lit] = STATE(333),
    [sym_syn_quoting_lit] = STATE(333),
    [sym_unquote_splicing_lit] = STATE(333),
    [sym_unquoting_lit] = STATE(333),
    [aux_sym_dis_expr_repeat1] = STATE(53),
    [aux_sym_sym_lit_repeat1] = STATE(306),
    [sym__ws] = ACTIONS(824),
    [sym_comment] = ACTIONS(824),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(558),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(426),
    [anon_sym_COLON_COLON] = ACTIONS(428),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(558),
    [sym_nil_lit] = ACTIONS(560),
    [sym_bool_lit] = ACTIONS(560),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(430),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(432),
    [anon_sym_POUND_POUND] = ACTIONS(434),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(436),
    [anon_sym_SQUOTE] = ACTIONS(438),
    [anon_sym_BQUOTE] = ACTIONS(440),
    [anon_sym_TILDE_AT] = ACTIONS(442),
    [anon_sym_TILDE] = ACTIONS(444),
  },
  [178] = {
    [sym__gap] = STATE(201),
    [sym_dis_expr] = STATE(201),
    [sym__form] = STATE(333),
    [sym_kwd_lit] = STATE(333),
    [sym_str_lit] = STATE(333),
    [sym_sym_lit] = STATE(333),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(333),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(333),
    [sym__bare_map_lit] = STATE(403),
    [sym_vec_lit] = STATE(333),
    [sym__bare_vec_lit] = STATE(423),
    [sym_set_lit] = STATE(333),
    [sym__bare_set_lit] = STATE(374),
    [sym_anon_fn_lit] = STATE(333),
    [sym_regex_lit] = STATE(333),
    [sym_read_cond_lit] = STATE(333),
    [sym_splicing_read_cond_lit] = STATE(333),
    [sym_ns_map_lit] = STATE(333),
    [sym_var_quoting_lit] = STATE(333),
    [sym_sym_val_lit] = STATE(333),
    [sym_evaling_lit] = STATE(333),
    [sym_tagged_or_ctor_lit] = STATE(333),
    [sym_derefing_lit] = STATE(333),
    [sym_quoting_lit] = STATE(333),
    [sym_syn_quoting_lit] = STATE(333),
    [sym_unquote_splicing_lit] = STATE(333),
    [sym_unquoting_lit] = STATE(333),
    [aux_sym_dis_expr_repeat1] = STATE(201),
    [aux_sym_sym_lit_repeat1] = STATE(304),
    [sym__ws] = ACTIONS(826),
    [sym_comment] = ACTIONS(826),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(558),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(270),
    [anon_sym_COLON_COLON] = ACTIONS(272),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(558),
    [sym_nil_lit] = ACTIONS(560),
    [sym_bool_lit] = ACTIONS(560),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(286),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(292),
    [anon_sym_POUND_POUND] = ACTIONS(294),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(298),
    [anon_sym_SQUOTE] = ACTIONS(300),
    [anon_sym_BQUOTE] = ACTIONS(302),
    [anon_sym_TILDE_AT] = ACTIONS(304),
    [anon_sym_TILDE] = ACTIONS(306),
  },
  [179] = {
    [sym__gap] = STATE(301),
    [sym_dis_expr] = STATE(301),
    [sym__form] = STATE(332),
    [sym_kwd_lit] = STATE(332),
    [sym_str_lit] = STATE(332),
    [sym_sym_lit] = STATE(332),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(332),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(332),
    [sym__bare_map_lit] = STATE(403),
    [sym_vec_lit] = STATE(332),
    [sym__bare_vec_lit] = STATE(423),
    [sym_set_lit] = STATE(332),
    [sym__bare_set_lit] = STATE(374),
    [sym_anon_fn_lit] = STATE(332),
    [sym_regex_lit] = STATE(332),
    [sym_read_cond_lit] = STATE(332),
    [sym_splicing_read_cond_lit] = STATE(332),
    [sym_ns_map_lit] = STATE(332),
    [sym_var_quoting_lit] = STATE(332),
    [sym_sym_val_lit] = STATE(332),
    [sym_evaling_lit] = STATE(332),
    [sym_tagged_or_ctor_lit] = STATE(332),
    [sym_derefing_lit] = STATE(332),
    [sym_quoting_lit] = STATE(332),
    [sym_syn_quoting_lit] = STATE(332),
    [sym_unquote_splicing_lit] = STATE(332),
    [sym_unquoting_lit] = STATE(332),
    [aux_sym_dis_expr_repeat1] = STATE(301),
    [aux_sym_sym_lit_repeat1] = STATE(306),
    [sym__ws] = ACTIONS(264),
    [sym_comment] = ACTIONS(264),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(562),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(426),
    [anon_sym_COLON_COLON] = ACTIONS(428),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(562),
    [sym_nil_lit] = ACTIONS(564),
    [sym_bool_lit] = ACTIONS(564),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(430),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(432),
    [anon_sym_POUND_POUND] = ACTIONS(434),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(436),
    [anon_sym_SQUOTE] = ACTIONS(438),
    [anon_sym_BQUOTE] = ACTIONS(440),
    [anon_sym_TILDE_AT] = ACTIONS(442),
    [anon_sym_TILDE] = ACTIONS(444),
  },
  [180] = {
    [sym__gap] = STATE(179),
    [sym_dis_expr] = STATE(179),
    [sym__form] = STATE(331),
    [sym_kwd_lit] = STATE(331),
    [sym_str_lit] = STATE(331),
    [sym_sym_lit] = STATE(331),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(331),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(331),
    [sym__bare_map_lit] = STATE(403),
    [sym_vec_lit] = STATE(331),
    [sym__bare_vec_lit] = STATE(423),
    [sym_set_lit] = STATE(331),
    [sym__bare_set_lit] = STATE(374),
    [sym_anon_fn_lit] = STATE(331),
    [sym_regex_lit] = STATE(331),
    [sym_read_cond_lit] = STATE(331),
    [sym_splicing_read_cond_lit] = STATE(331),
    [sym_ns_map_lit] = STATE(331),
    [sym_var_quoting_lit] = STATE(331),
    [sym_sym_val_lit] = STATE(331),
    [sym_evaling_lit] = STATE(331),
    [sym_tagged_or_ctor_lit] = STATE(331),
    [sym_derefing_lit] = STATE(331),
    [sym_quoting_lit] = STATE(331),
    [sym_syn_quoting_lit] = STATE(331),
    [sym_unquote_splicing_lit] = STATE(331),
    [sym_unquoting_lit] = STATE(331),
    [aux_sym_dis_expr_repeat1] = STATE(179),
    [aux_sym_sym_lit_repeat1] = STATE(306),
    [sym__ws] = ACTIONS(828),
    [sym_comment] = ACTIONS(828),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(572),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(426),
    [anon_sym_COLON_COLON] = ACTIONS(428),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(572),
    [sym_nil_lit] = ACTIONS(574),
    [sym_bool_lit] = ACTIONS(574),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(430),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(432),
    [anon_sym_POUND_POUND] = ACTIONS(434),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(436),
    [anon_sym_SQUOTE] = ACTIONS(438),
    [anon_sym_BQUOTE] = ACTIONS(440),
    [anon_sym_TILDE_AT] = ACTIONS(442),
    [anon_sym_TILDE] = ACTIONS(444),
  },
  [181] = {
    [sym__gap] = STATE(301),
    [sym_dis_expr] = STATE(301),
    [sym__form] = STATE(329),
    [sym_kwd_lit] = STATE(329),
    [sym_str_lit] = STATE(329),
    [sym_sym_lit] = STATE(329),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(329),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(329),
    [sym__bare_map_lit] = STATE(403),
    [sym_vec_lit] = STATE(329),
    [sym__bare_vec_lit] = STATE(423),
    [sym_set_lit] = STATE(329),
    [sym__bare_set_lit] = STATE(374),
    [sym_anon_fn_lit] = STATE(329),
    [sym_regex_lit] = STATE(329),
    [sym_read_cond_lit] = STATE(329),
    [sym_splicing_read_cond_lit] = STATE(329),
    [sym_ns_map_lit] = STATE(329),
    [sym_var_quoting_lit] = STATE(329),
    [sym_sym_val_lit] = STATE(329),
    [sym_evaling_lit] = STATE(329),
    [sym_tagged_or_ctor_lit] = STATE(329),
    [sym_derefing_lit] = STATE(329),
    [sym_quoting_lit] = STATE(329),
    [sym_syn_quoting_lit] = STATE(329),
    [sym_unquote_splicing_lit] = STATE(329),
    [sym_unquoting_lit] = STATE(329),
    [aux_sym_dis_expr_repeat1] = STATE(301),
    [aux_sym_sym_lit_repeat1] = STATE(306),
    [sym__ws] = ACTIONS(264),
    [sym_comment] = ACTIONS(264),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(580),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(426),
    [anon_sym_COLON_COLON] = ACTIONS(428),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(580),
    [sym_nil_lit] = ACTIONS(582),
    [sym_bool_lit] = ACTIONS(582),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(430),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(432),
    [anon_sym_POUND_POUND] = ACTIONS(434),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(436),
    [anon_sym_SQUOTE] = ACTIONS(438),
    [anon_sym_BQUOTE] = ACTIONS(440),
    [anon_sym_TILDE_AT] = ACTIONS(442),
    [anon_sym_TILDE] = ACTIONS(444),
  },
  [182] = {
    [sym__gap] = STATE(301),
    [sym_dis_expr] = STATE(301),
    [sym__form] = STATE(327),
    [sym_kwd_lit] = STATE(327),
    [sym_str_lit] = STATE(327),
    [sym_sym_lit] = STATE(327),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(327),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(327),
    [sym__bare_map_lit] = STATE(403),
    [sym_vec_lit] = STATE(327),
    [sym__bare_vec_lit] = STATE(423),
    [sym_set_lit] = STATE(327),
    [sym__bare_set_lit] = STATE(374),
    [sym_anon_fn_lit] = STATE(327),
    [sym_regex_lit] = STATE(327),
    [sym_read_cond_lit] = STATE(327),
    [sym_splicing_read_cond_lit] = STATE(327),
    [sym_ns_map_lit] = STATE(327),
    [sym_var_quoting_lit] = STATE(327),
    [sym_sym_val_lit] = STATE(327),
    [sym_evaling_lit] = STATE(327),
    [sym_tagged_or_ctor_lit] = STATE(327),
    [sym_derefing_lit] = STATE(327),
    [sym_quoting_lit] = STATE(327),
    [sym_syn_quoting_lit] = STATE(327),
    [sym_unquote_splicing_lit] = STATE(327),
    [sym_unquoting_lit] = STATE(327),
    [aux_sym_dis_expr_repeat1] = STATE(301),
    [aux_sym_sym_lit_repeat1] = STATE(306),
    [sym__ws] = ACTIONS(264),
    [sym_comment] = ACTIONS(264),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(588),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(426),
    [anon_sym_COLON_COLON] = ACTIONS(428),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(588),
    [sym_nil_lit] = ACTIONS(590),
    [sym_bool_lit] = ACTIONS(590),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(430),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(432),
    [anon_sym_POUND_POUND] = ACTIONS(434),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(436),
    [anon_sym_SQUOTE] = ACTIONS(438),
    [anon_sym_BQUOTE] = ACTIONS(440),
    [anon_sym_TILDE_AT] = ACTIONS(442),
    [anon_sym_TILDE] = ACTIONS(444),
  },
  [183] = {
    [sym__gap] = STATE(301),
    [sym_dis_expr] = STATE(301),
    [sym__form] = STATE(288),
    [sym_kwd_lit] = STATE(288),
    [sym_str_lit] = STATE(288),
    [sym_sym_lit] = STATE(288),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(288),
    [sym__bare_list_lit] = STATE(218),
    [sym_map_lit] = STATE(288),
    [sym__bare_map_lit] = STATE(219),
    [sym_vec_lit] = STATE(288),
    [sym__bare_vec_lit] = STATE(226),
    [sym_set_lit] = STATE(288),
    [sym__bare_set_lit] = STATE(227),
    [sym_anon_fn_lit] = STATE(288),
    [sym_regex_lit] = STATE(288),
    [sym_read_cond_lit] = STATE(288),
    [sym_splicing_read_cond_lit] = STATE(288),
    [sym_ns_map_lit] = STATE(288),
    [sym_var_quoting_lit] = STATE(288),
    [sym_sym_val_lit] = STATE(288),
    [sym_evaling_lit] = STATE(288),
    [sym_tagged_or_ctor_lit] = STATE(288),
    [sym_derefing_lit] = STATE(288),
    [sym_quoting_lit] = STATE(288),
    [sym_syn_quoting_lit] = STATE(288),
    [sym_unquote_splicing_lit] = STATE(288),
    [sym_unquoting_lit] = STATE(288),
    [aux_sym_dis_expr_repeat1] = STATE(301),
    [aux_sym_sym_lit_repeat1] = STATE(305),
    [sym__ws] = ACTIONS(264),
    [sym_comment] = ACTIONS(264),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(736),
    [anon_sym_SLASH] = ACTIONS(9),
    [anon_sym_COLON] = ACTIONS(11),
    [anon_sym_COLON_COLON] = ACTIONS(13),
    [aux_sym_str_lit_token1] = ACTIONS(15),
    [sym_char_lit] = ACTIONS(736),
    [sym_nil_lit] = ACTIONS(738),
    [sym_bool_lit] = ACTIONS(738),
    [aux_sym__sym_qualified_token1] = ACTIONS(19),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_POUND] = ACTIONS(31),
    [anon_sym_POUND_QMARK] = ACTIONS(33),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(35),
    [anon_sym_POUND_SQUOTE] = ACTIONS(37),
    [anon_sym_POUND_POUND] = ACTIONS(39),
    [anon_sym_POUND_EQ] = ACTIONS(41),
    [anon_sym_AT] = ACTIONS(43),
    [anon_sym_SQUOTE] = ACTIONS(45),
    [anon_sym_BQUOTE] = ACTIONS(47),
    [anon_sym_TILDE_AT] = ACTIONS(49),
    [anon_sym_TILDE] = ACTIONS(51),
  },
  [184] = {
    [sym__gap] = STATE(301),
    [sym_dis_expr] = STATE(301),
    [sym__form] = STATE(411),
    [sym_kwd_lit] = STATE(411),
    [sym_str_lit] = STATE(411),
    [sym_sym_lit] = STATE(411),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(411),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(411),
    [sym__bare_map_lit] = STATE(403),
    [sym_vec_lit] = STATE(411),
    [sym__bare_vec_lit] = STATE(423),
    [sym_set_lit] = STATE(411),
    [sym__bare_set_lit] = STATE(374),
    [sym_anon_fn_lit] = STATE(411),
    [sym_regex_lit] = STATE(411),
    [sym_read_cond_lit] = STATE(411),
    [sym_splicing_read_cond_lit] = STATE(411),
    [sym_ns_map_lit] = STATE(411),
    [sym_var_quoting_lit] = STATE(411),
    [sym_sym_val_lit] = STATE(411),
    [sym_evaling_lit] = STATE(411),
    [sym_tagged_or_ctor_lit] = STATE(411),
    [sym_derefing_lit] = STATE(411),
    [sym_quoting_lit] = STATE(411),
    [sym_syn_quoting_lit] = STATE(411),
    [sym_unquote_splicing_lit] = STATE(411),
    [sym_unquoting_lit] = STATE(411),
    [aux_sym_dis_expr_repeat1] = STATE(301),
    [aux_sym_sym_lit_repeat1] = STATE(306),
    [sym__ws] = ACTIONS(264),
    [sym_comment] = ACTIONS(264),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(596),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(426),
    [anon_sym_COLON_COLON] = ACTIONS(428),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(596),
    [sym_nil_lit] = ACTIONS(598),
    [sym_bool_lit] = ACTIONS(598),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(430),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(432),
    [anon_sym_POUND_POUND] = ACTIONS(434),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(436),
    [anon_sym_SQUOTE] = ACTIONS(438),
    [anon_sym_BQUOTE] = ACTIONS(440),
    [anon_sym_TILDE_AT] = ACTIONS(442),
    [anon_sym_TILDE] = ACTIONS(444),
  },
  [185] = {
    [sym__gap] = STATE(301),
    [sym_dis_expr] = STATE(301),
    [sym__form] = STATE(385),
    [sym_kwd_lit] = STATE(385),
    [sym_str_lit] = STATE(385),
    [sym_sym_lit] = STATE(385),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(385),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(385),
    [sym__bare_map_lit] = STATE(403),
    [sym_vec_lit] = STATE(385),
    [sym__bare_vec_lit] = STATE(423),
    [sym_set_lit] = STATE(385),
    [sym__bare_set_lit] = STATE(374),
    [sym_anon_fn_lit] = STATE(385),
    [sym_regex_lit] = STATE(385),
    [sym_read_cond_lit] = STATE(385),
    [sym_splicing_read_cond_lit] = STATE(385),
    [sym_ns_map_lit] = STATE(385),
    [sym_var_quoting_lit] = STATE(385),
    [sym_sym_val_lit] = STATE(385),
    [sym_evaling_lit] = STATE(385),
    [sym_tagged_or_ctor_lit] = STATE(385),
    [sym_derefing_lit] = STATE(385),
    [sym_quoting_lit] = STATE(385),
    [sym_syn_quoting_lit] = STATE(385),
    [sym_unquote_splicing_lit] = STATE(385),
    [sym_unquoting_lit] = STATE(385),
    [aux_sym_dis_expr_repeat1] = STATE(301),
    [aux_sym_sym_lit_repeat1] = STATE(306),
    [sym__ws] = ACTIONS(264),
    [sym_comment] = ACTIONS(264),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(604),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(426),
    [anon_sym_COLON_COLON] = ACTIONS(428),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(604),
    [sym_nil_lit] = ACTIONS(606),
    [sym_bool_lit] = ACTIONS(606),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(430),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(432),
    [anon_sym_POUND_POUND] = ACTIONS(434),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(436),
    [anon_sym_SQUOTE] = ACTIONS(438),
    [anon_sym_BQUOTE] = ACTIONS(440),
    [anon_sym_TILDE_AT] = ACTIONS(442),
    [anon_sym_TILDE] = ACTIONS(444),
  },
  [186] = {
    [sym__gap] = STATE(301),
    [sym_dis_expr] = STATE(301),
    [sym__form] = STATE(335),
    [sym_kwd_lit] = STATE(335),
    [sym_str_lit] = STATE(335),
    [sym_sym_lit] = STATE(335),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(335),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(335),
    [sym__bare_map_lit] = STATE(403),
    [sym_vec_lit] = STATE(335),
    [sym__bare_vec_lit] = STATE(423),
    [sym_set_lit] = STATE(335),
    [sym__bare_set_lit] = STATE(374),
    [sym_anon_fn_lit] = STATE(335),
    [sym_regex_lit] = STATE(335),
    [sym_read_cond_lit] = STATE(335),
    [sym_splicing_read_cond_lit] = STATE(335),
    [sym_ns_map_lit] = STATE(335),
    [sym_var_quoting_lit] = STATE(335),
    [sym_sym_val_lit] = STATE(335),
    [sym_evaling_lit] = STATE(335),
    [sym_tagged_or_ctor_lit] = STATE(335),
    [sym_derefing_lit] = STATE(335),
    [sym_quoting_lit] = STATE(335),
    [sym_syn_quoting_lit] = STATE(335),
    [sym_unquote_splicing_lit] = STATE(335),
    [sym_unquoting_lit] = STATE(335),
    [aux_sym_dis_expr_repeat1] = STATE(301),
    [aux_sym_sym_lit_repeat1] = STATE(306),
    [sym__ws] = ACTIONS(264),
    [sym_comment] = ACTIONS(264),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(608),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(426),
    [anon_sym_COLON_COLON] = ACTIONS(428),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(608),
    [sym_nil_lit] = ACTIONS(610),
    [sym_bool_lit] = ACTIONS(610),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(430),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(432),
    [anon_sym_POUND_POUND] = ACTIONS(434),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(436),
    [anon_sym_SQUOTE] = ACTIONS(438),
    [anon_sym_BQUOTE] = ACTIONS(440),
    [anon_sym_TILDE_AT] = ACTIONS(442),
    [anon_sym_TILDE] = ACTIONS(444),
  },
  [187] = {
    [sym__gap] = STATE(301),
    [sym_dis_expr] = STATE(301),
    [sym__form] = STATE(334),
    [sym_kwd_lit] = STATE(334),
    [sym_str_lit] = STATE(334),
    [sym_sym_lit] = STATE(334),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(334),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(334),
    [sym__bare_map_lit] = STATE(403),
    [sym_vec_lit] = STATE(334),
    [sym__bare_vec_lit] = STATE(423),
    [sym_set_lit] = STATE(334),
    [sym__bare_set_lit] = STATE(374),
    [sym_anon_fn_lit] = STATE(334),
    [sym_regex_lit] = STATE(334),
    [sym_read_cond_lit] = STATE(334),
    [sym_splicing_read_cond_lit] = STATE(334),
    [sym_ns_map_lit] = STATE(334),
    [sym_var_quoting_lit] = STATE(334),
    [sym_sym_val_lit] = STATE(334),
    [sym_evaling_lit] = STATE(334),
    [sym_tagged_or_ctor_lit] = STATE(334),
    [sym_derefing_lit] = STATE(334),
    [sym_quoting_lit] = STATE(334),
    [sym_syn_quoting_lit] = STATE(334),
    [sym_unquote_splicing_lit] = STATE(334),
    [sym_unquoting_lit] = STATE(334),
    [aux_sym_dis_expr_repeat1] = STATE(301),
    [aux_sym_sym_lit_repeat1] = STATE(306),
    [sym__ws] = ACTIONS(264),
    [sym_comment] = ACTIONS(264),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(350),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(426),
    [anon_sym_COLON_COLON] = ACTIONS(428),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(350),
    [sym_nil_lit] = ACTIONS(356),
    [sym_bool_lit] = ACTIONS(356),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(430),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(432),
    [anon_sym_POUND_POUND] = ACTIONS(434),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(436),
    [anon_sym_SQUOTE] = ACTIONS(438),
    [anon_sym_BQUOTE] = ACTIONS(440),
    [anon_sym_TILDE_AT] = ACTIONS(442),
    [anon_sym_TILDE] = ACTIONS(444),
  },
  [188] = {
    [sym__gap] = STATE(40),
    [sym_dis_expr] = STATE(40),
    [sym__form] = STATE(345),
    [sym_kwd_lit] = STATE(345),
    [sym_str_lit] = STATE(345),
    [sym_sym_lit] = STATE(345),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(345),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(345),
    [sym__bare_map_lit] = STATE(403),
    [sym_vec_lit] = STATE(345),
    [sym__bare_vec_lit] = STATE(423),
    [sym_set_lit] = STATE(345),
    [sym__bare_set_lit] = STATE(374),
    [sym_anon_fn_lit] = STATE(345),
    [sym_regex_lit] = STATE(345),
    [sym_read_cond_lit] = STATE(345),
    [sym_splicing_read_cond_lit] = STATE(345),
    [sym_ns_map_lit] = STATE(345),
    [sym_var_quoting_lit] = STATE(345),
    [sym_sym_val_lit] = STATE(345),
    [sym_evaling_lit] = STATE(345),
    [sym_tagged_or_ctor_lit] = STATE(345),
    [sym_derefing_lit] = STATE(345),
    [sym_quoting_lit] = STATE(345),
    [sym_syn_quoting_lit] = STATE(345),
    [sym_unquote_splicing_lit] = STATE(345),
    [sym_unquoting_lit] = STATE(345),
    [aux_sym_dis_expr_repeat1] = STATE(40),
    [aux_sym_sym_lit_repeat1] = STATE(306),
    [sym__ws] = ACTIONS(830),
    [sym_comment] = ACTIONS(830),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(498),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(426),
    [anon_sym_COLON_COLON] = ACTIONS(428),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(498),
    [sym_nil_lit] = ACTIONS(500),
    [sym_bool_lit] = ACTIONS(500),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(430),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(432),
    [anon_sym_POUND_POUND] = ACTIONS(434),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(436),
    [anon_sym_SQUOTE] = ACTIONS(438),
    [anon_sym_BQUOTE] = ACTIONS(440),
    [anon_sym_TILDE_AT] = ACTIONS(442),
    [anon_sym_TILDE] = ACTIONS(444),
  },
  [189] = {
    [sym__gap] = STATE(198),
    [sym_dis_expr] = STATE(198),
    [sym__form] = STATE(347),
    [sym_kwd_lit] = STATE(347),
    [sym_str_lit] = STATE(347),
    [sym_sym_lit] = STATE(347),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(347),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(347),
    [sym__bare_map_lit] = STATE(403),
    [sym_vec_lit] = STATE(347),
    [sym__bare_vec_lit] = STATE(423),
    [sym_set_lit] = STATE(347),
    [sym__bare_set_lit] = STATE(374),
    [sym_anon_fn_lit] = STATE(347),
    [sym_regex_lit] = STATE(347),
    [sym_read_cond_lit] = STATE(347),
    [sym_splicing_read_cond_lit] = STATE(347),
    [sym_ns_map_lit] = STATE(347),
    [sym_var_quoting_lit] = STATE(347),
    [sym_sym_val_lit] = STATE(347),
    [sym_evaling_lit] = STATE(347),
    [sym_tagged_or_ctor_lit] = STATE(347),
    [sym_derefing_lit] = STATE(347),
    [sym_quoting_lit] = STATE(347),
    [sym_syn_quoting_lit] = STATE(347),
    [sym_unquote_splicing_lit] = STATE(347),
    [sym_unquoting_lit] = STATE(347),
    [aux_sym_dis_expr_repeat1] = STATE(198),
    [aux_sym_sym_lit_repeat1] = STATE(306),
    [sym__ws] = ACTIONS(832),
    [sym_comment] = ACTIONS(832),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(316),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(426),
    [anon_sym_COLON_COLON] = ACTIONS(428),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(316),
    [sym_nil_lit] = ACTIONS(318),
    [sym_bool_lit] = ACTIONS(318),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(430),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(432),
    [anon_sym_POUND_POUND] = ACTIONS(434),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(436),
    [anon_sym_SQUOTE] = ACTIONS(438),
    [anon_sym_BQUOTE] = ACTIONS(440),
    [anon_sym_TILDE_AT] = ACTIONS(442),
    [anon_sym_TILDE] = ACTIONS(444),
  },
  [190] = {
    [sym__gap] = STATE(301),
    [sym_dis_expr] = STATE(301),
    [sym__form] = STATE(417),
    [sym_kwd_lit] = STATE(417),
    [sym_str_lit] = STATE(417),
    [sym_sym_lit] = STATE(417),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(417),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(417),
    [sym__bare_map_lit] = STATE(403),
    [sym_vec_lit] = STATE(417),
    [sym__bare_vec_lit] = STATE(423),
    [sym_set_lit] = STATE(417),
    [sym__bare_set_lit] = STATE(374),
    [sym_anon_fn_lit] = STATE(417),
    [sym_regex_lit] = STATE(417),
    [sym_read_cond_lit] = STATE(417),
    [sym_splicing_read_cond_lit] = STATE(417),
    [sym_ns_map_lit] = STATE(417),
    [sym_var_quoting_lit] = STATE(417),
    [sym_sym_val_lit] = STATE(417),
    [sym_evaling_lit] = STATE(417),
    [sym_tagged_or_ctor_lit] = STATE(417),
    [sym_derefing_lit] = STATE(417),
    [sym_quoting_lit] = STATE(417),
    [sym_syn_quoting_lit] = STATE(417),
    [sym_unquote_splicing_lit] = STATE(417),
    [sym_unquoting_lit] = STATE(417),
    [aux_sym_dis_expr_repeat1] = STATE(301),
    [aux_sym_sym_lit_repeat1] = STATE(306),
    [sym__ws] = ACTIONS(264),
    [sym_comment] = ACTIONS(264),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(374),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(426),
    [anon_sym_COLON_COLON] = ACTIONS(428),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(374),
    [sym_nil_lit] = ACTIONS(376),
    [sym_bool_lit] = ACTIONS(376),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(430),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(432),
    [anon_sym_POUND_POUND] = ACTIONS(434),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(436),
    [anon_sym_SQUOTE] = ACTIONS(438),
    [anon_sym_BQUOTE] = ACTIONS(440),
    [anon_sym_TILDE_AT] = ACTIONS(442),
    [anon_sym_TILDE] = ACTIONS(444),
  },
  [191] = {
    [sym__gap] = STATE(203),
    [sym_dis_expr] = STATE(203),
    [sym__form] = STATE(355),
    [sym_kwd_lit] = STATE(355),
    [sym_str_lit] = STATE(355),
    [sym_sym_lit] = STATE(355),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(355),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(355),
    [sym__bare_map_lit] = STATE(403),
    [sym_vec_lit] = STATE(355),
    [sym__bare_vec_lit] = STATE(423),
    [sym_set_lit] = STATE(355),
    [sym__bare_set_lit] = STATE(374),
    [sym_anon_fn_lit] = STATE(355),
    [sym_regex_lit] = STATE(355),
    [sym_read_cond_lit] = STATE(355),
    [sym_splicing_read_cond_lit] = STATE(355),
    [sym_ns_map_lit] = STATE(355),
    [sym_var_quoting_lit] = STATE(355),
    [sym_sym_val_lit] = STATE(355),
    [sym_evaling_lit] = STATE(355),
    [sym_tagged_or_ctor_lit] = STATE(355),
    [sym_derefing_lit] = STATE(355),
    [sym_quoting_lit] = STATE(355),
    [sym_syn_quoting_lit] = STATE(355),
    [sym_unquote_splicing_lit] = STATE(355),
    [sym_unquoting_lit] = STATE(355),
    [aux_sym_dis_expr_repeat1] = STATE(203),
    [aux_sym_sym_lit_repeat1] = STATE(306),
    [sym__ws] = ACTIONS(834),
    [sym_comment] = ACTIONS(834),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(528),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(426),
    [anon_sym_COLON_COLON] = ACTIONS(428),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(528),
    [sym_nil_lit] = ACTIONS(530),
    [sym_bool_lit] = ACTIONS(530),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(430),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(432),
    [anon_sym_POUND_POUND] = ACTIONS(434),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(436),
    [anon_sym_SQUOTE] = ACTIONS(438),
    [anon_sym_BQUOTE] = ACTIONS(440),
    [anon_sym_TILDE_AT] = ACTIONS(442),
    [anon_sym_TILDE] = ACTIONS(444),
  },
  [192] = {
    [sym__gap] = STATE(205),
    [sym_dis_expr] = STATE(205),
    [sym__form] = STATE(366),
    [sym_kwd_lit] = STATE(366),
    [sym_str_lit] = STATE(366),
    [sym_sym_lit] = STATE(366),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(366),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(366),
    [sym__bare_map_lit] = STATE(403),
    [sym_vec_lit] = STATE(366),
    [sym__bare_vec_lit] = STATE(423),
    [sym_set_lit] = STATE(366),
    [sym__bare_set_lit] = STATE(374),
    [sym_anon_fn_lit] = STATE(366),
    [sym_regex_lit] = STATE(366),
    [sym_read_cond_lit] = STATE(366),
    [sym_splicing_read_cond_lit] = STATE(366),
    [sym_ns_map_lit] = STATE(366),
    [sym_var_quoting_lit] = STATE(366),
    [sym_sym_val_lit] = STATE(366),
    [sym_evaling_lit] = STATE(366),
    [sym_tagged_or_ctor_lit] = STATE(366),
    [sym_derefing_lit] = STATE(366),
    [sym_quoting_lit] = STATE(366),
    [sym_syn_quoting_lit] = STATE(366),
    [sym_unquote_splicing_lit] = STATE(366),
    [sym_unquoting_lit] = STATE(366),
    [aux_sym_dis_expr_repeat1] = STATE(205),
    [aux_sym_sym_lit_repeat1] = STATE(306),
    [sym__ws] = ACTIONS(836),
    [sym_comment] = ACTIONS(836),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(522),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(426),
    [anon_sym_COLON_COLON] = ACTIONS(428),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(522),
    [sym_nil_lit] = ACTIONS(524),
    [sym_bool_lit] = ACTIONS(524),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(430),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(432),
    [anon_sym_POUND_POUND] = ACTIONS(434),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(436),
    [anon_sym_SQUOTE] = ACTIONS(438),
    [anon_sym_BQUOTE] = ACTIONS(440),
    [anon_sym_TILDE_AT] = ACTIONS(442),
    [anon_sym_TILDE] = ACTIONS(444),
  },
  [193] = {
    [sym__gap] = STATE(207),
    [sym_dis_expr] = STATE(207),
    [sym__form] = STATE(367),
    [sym_kwd_lit] = STATE(367),
    [sym_str_lit] = STATE(367),
    [sym_sym_lit] = STATE(367),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(367),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(367),
    [sym__bare_map_lit] = STATE(403),
    [sym_vec_lit] = STATE(367),
    [sym__bare_vec_lit] = STATE(423),
    [sym_set_lit] = STATE(367),
    [sym__bare_set_lit] = STATE(374),
    [sym_anon_fn_lit] = STATE(367),
    [sym_regex_lit] = STATE(367),
    [sym_read_cond_lit] = STATE(367),
    [sym_splicing_read_cond_lit] = STATE(367),
    [sym_ns_map_lit] = STATE(367),
    [sym_var_quoting_lit] = STATE(367),
    [sym_sym_val_lit] = STATE(367),
    [sym_evaling_lit] = STATE(367),
    [sym_tagged_or_ctor_lit] = STATE(367),
    [sym_derefing_lit] = STATE(367),
    [sym_quoting_lit] = STATE(367),
    [sym_syn_quoting_lit] = STATE(367),
    [sym_unquote_splicing_lit] = STATE(367),
    [sym_unquoting_lit] = STATE(367),
    [aux_sym_dis_expr_repeat1] = STATE(207),
    [aux_sym_sym_lit_repeat1] = STATE(306),
    [sym__ws] = ACTIONS(838),
    [sym_comment] = ACTIONS(838),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(516),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(426),
    [anon_sym_COLON_COLON] = ACTIONS(428),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(516),
    [sym_nil_lit] = ACTIONS(518),
    [sym_bool_lit] = ACTIONS(518),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(430),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(432),
    [anon_sym_POUND_POUND] = ACTIONS(434),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(436),
    [anon_sym_SQUOTE] = ACTIONS(438),
    [anon_sym_BQUOTE] = ACTIONS(440),
    [anon_sym_TILDE_AT] = ACTIONS(442),
    [anon_sym_TILDE] = ACTIONS(444),
  },
  [194] = {
    [sym__gap] = STATE(210),
    [sym_dis_expr] = STATE(210),
    [sym__form] = STATE(370),
    [sym_kwd_lit] = STATE(370),
    [sym_str_lit] = STATE(370),
    [sym_sym_lit] = STATE(370),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(370),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(370),
    [sym__bare_map_lit] = STATE(403),
    [sym_vec_lit] = STATE(370),
    [sym__bare_vec_lit] = STATE(423),
    [sym_set_lit] = STATE(370),
    [sym__bare_set_lit] = STATE(374),
    [sym_anon_fn_lit] = STATE(370),
    [sym_regex_lit] = STATE(370),
    [sym_read_cond_lit] = STATE(370),
    [sym_splicing_read_cond_lit] = STATE(370),
    [sym_ns_map_lit] = STATE(370),
    [sym_var_quoting_lit] = STATE(370),
    [sym_sym_val_lit] = STATE(370),
    [sym_evaling_lit] = STATE(370),
    [sym_tagged_or_ctor_lit] = STATE(370),
    [sym_derefing_lit] = STATE(370),
    [sym_quoting_lit] = STATE(370),
    [sym_syn_quoting_lit] = STATE(370),
    [sym_unquote_splicing_lit] = STATE(370),
    [sym_unquoting_lit] = STATE(370),
    [aux_sym_dis_expr_repeat1] = STATE(210),
    [aux_sym_sym_lit_repeat1] = STATE(306),
    [sym__ws] = ACTIONS(840),
    [sym_comment] = ACTIONS(840),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(510),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(426),
    [anon_sym_COLON_COLON] = ACTIONS(428),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(510),
    [sym_nil_lit] = ACTIONS(512),
    [sym_bool_lit] = ACTIONS(512),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(430),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(432),
    [anon_sym_POUND_POUND] = ACTIONS(434),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(436),
    [anon_sym_SQUOTE] = ACTIONS(438),
    [anon_sym_BQUOTE] = ACTIONS(440),
    [anon_sym_TILDE_AT] = ACTIONS(442),
    [anon_sym_TILDE] = ACTIONS(444),
  },
  [195] = {
    [sym__gap] = STATE(212),
    [sym_dis_expr] = STATE(212),
    [sym__form] = STATE(371),
    [sym_kwd_lit] = STATE(371),
    [sym_str_lit] = STATE(371),
    [sym_sym_lit] = STATE(371),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(371),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(371),
    [sym__bare_map_lit] = STATE(403),
    [sym_vec_lit] = STATE(371),
    [sym__bare_vec_lit] = STATE(423),
    [sym_set_lit] = STATE(371),
    [sym__bare_set_lit] = STATE(374),
    [sym_anon_fn_lit] = STATE(371),
    [sym_regex_lit] = STATE(371),
    [sym_read_cond_lit] = STATE(371),
    [sym_splicing_read_cond_lit] = STATE(371),
    [sym_ns_map_lit] = STATE(371),
    [sym_var_quoting_lit] = STATE(371),
    [sym_sym_val_lit] = STATE(371),
    [sym_evaling_lit] = STATE(371),
    [sym_tagged_or_ctor_lit] = STATE(371),
    [sym_derefing_lit] = STATE(371),
    [sym_quoting_lit] = STATE(371),
    [sym_syn_quoting_lit] = STATE(371),
    [sym_unquote_splicing_lit] = STATE(371),
    [sym_unquoting_lit] = STATE(371),
    [aux_sym_dis_expr_repeat1] = STATE(212),
    [aux_sym_sym_lit_repeat1] = STATE(306),
    [sym__ws] = ACTIONS(842),
    [sym_comment] = ACTIONS(842),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(504),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(426),
    [anon_sym_COLON_COLON] = ACTIONS(428),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(504),
    [sym_nil_lit] = ACTIONS(506),
    [sym_bool_lit] = ACTIONS(506),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(430),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(432),
    [anon_sym_POUND_POUND] = ACTIONS(434),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(436),
    [anon_sym_SQUOTE] = ACTIONS(438),
    [anon_sym_BQUOTE] = ACTIONS(440),
    [anon_sym_TILDE_AT] = ACTIONS(442),
    [anon_sym_TILDE] = ACTIONS(444),
  },
  [196] = {
    [sym__gap] = STATE(301),
    [sym_dis_expr] = STATE(301),
    [sym__form] = STATE(350),
    [sym_kwd_lit] = STATE(350),
    [sym_str_lit] = STATE(350),
    [sym_sym_lit] = STATE(350),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(350),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(350),
    [sym__bare_map_lit] = STATE(403),
    [sym_vec_lit] = STATE(350),
    [sym__bare_vec_lit] = STATE(423),
    [sym_set_lit] = STATE(350),
    [sym__bare_set_lit] = STATE(374),
    [sym_anon_fn_lit] = STATE(350),
    [sym_regex_lit] = STATE(350),
    [sym_read_cond_lit] = STATE(350),
    [sym_splicing_read_cond_lit] = STATE(350),
    [sym_ns_map_lit] = STATE(350),
    [sym_var_quoting_lit] = STATE(350),
    [sym_sym_val_lit] = STATE(350),
    [sym_evaling_lit] = STATE(350),
    [sym_tagged_or_ctor_lit] = STATE(350),
    [sym_derefing_lit] = STATE(350),
    [sym_quoting_lit] = STATE(350),
    [sym_syn_quoting_lit] = STATE(350),
    [sym_unquote_splicing_lit] = STATE(350),
    [sym_unquoting_lit] = STATE(350),
    [aux_sym_dis_expr_repeat1] = STATE(301),
    [aux_sym_sym_lit_repeat1] = STATE(306),
    [sym__ws] = ACTIONS(264),
    [sym_comment] = ACTIONS(264),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(612),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(426),
    [anon_sym_COLON_COLON] = ACTIONS(428),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(612),
    [sym_nil_lit] = ACTIONS(614),
    [sym_bool_lit] = ACTIONS(614),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(430),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(432),
    [anon_sym_POUND_POUND] = ACTIONS(434),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(436),
    [anon_sym_SQUOTE] = ACTIONS(438),
    [anon_sym_BQUOTE] = ACTIONS(440),
    [anon_sym_TILDE_AT] = ACTIONS(442),
    [anon_sym_TILDE] = ACTIONS(444),
  },
  [197] = {
    [sym__gap] = STATE(181),
    [sym_dis_expr] = STATE(181),
    [sym__form] = STATE(357),
    [sym_kwd_lit] = STATE(357),
    [sym_str_lit] = STATE(357),
    [sym_sym_lit] = STATE(357),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(357),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(357),
    [sym__bare_map_lit] = STATE(403),
    [sym_vec_lit] = STATE(357),
    [sym__bare_vec_lit] = STATE(423),
    [sym_set_lit] = STATE(357),
    [sym__bare_set_lit] = STATE(374),
    [sym_anon_fn_lit] = STATE(357),
    [sym_regex_lit] = STATE(357),
    [sym_read_cond_lit] = STATE(357),
    [sym_splicing_read_cond_lit] = STATE(357),
    [sym_ns_map_lit] = STATE(357),
    [sym_var_quoting_lit] = STATE(357),
    [sym_sym_val_lit] = STATE(357),
    [sym_evaling_lit] = STATE(357),
    [sym_tagged_or_ctor_lit] = STATE(357),
    [sym_derefing_lit] = STATE(357),
    [sym_quoting_lit] = STATE(357),
    [sym_syn_quoting_lit] = STATE(357),
    [sym_unquote_splicing_lit] = STATE(357),
    [sym_unquoting_lit] = STATE(357),
    [aux_sym_dis_expr_repeat1] = STATE(181),
    [aux_sym_sym_lit_repeat1] = STATE(306),
    [sym__ws] = ACTIONS(844),
    [sym_comment] = ACTIONS(844),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(384),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(426),
    [anon_sym_COLON_COLON] = ACTIONS(428),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(384),
    [sym_nil_lit] = ACTIONS(386),
    [sym_bool_lit] = ACTIONS(386),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(430),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(432),
    [anon_sym_POUND_POUND] = ACTIONS(434),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(436),
    [anon_sym_SQUOTE] = ACTIONS(438),
    [anon_sym_BQUOTE] = ACTIONS(440),
    [anon_sym_TILDE_AT] = ACTIONS(442),
    [anon_sym_TILDE] = ACTIONS(444),
  },
  [198] = {
    [sym__gap] = STATE(301),
    [sym_dis_expr] = STATE(301),
    [sym__form] = STATE(419),
    [sym_kwd_lit] = STATE(419),
    [sym_str_lit] = STATE(419),
    [sym_sym_lit] = STATE(419),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(419),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(419),
    [sym__bare_map_lit] = STATE(403),
    [sym_vec_lit] = STATE(419),
    [sym__bare_vec_lit] = STATE(423),
    [sym_set_lit] = STATE(419),
    [sym__bare_set_lit] = STATE(374),
    [sym_anon_fn_lit] = STATE(419),
    [sym_regex_lit] = STATE(419),
    [sym_read_cond_lit] = STATE(419),
    [sym_splicing_read_cond_lit] = STATE(419),
    [sym_ns_map_lit] = STATE(419),
    [sym_var_quoting_lit] = STATE(419),
    [sym_sym_val_lit] = STATE(419),
    [sym_evaling_lit] = STATE(419),
    [sym_tagged_or_ctor_lit] = STATE(419),
    [sym_derefing_lit] = STATE(419),
    [sym_quoting_lit] = STATE(419),
    [sym_syn_quoting_lit] = STATE(419),
    [sym_unquote_splicing_lit] = STATE(419),
    [sym_unquoting_lit] = STATE(419),
    [aux_sym_dis_expr_repeat1] = STATE(301),
    [aux_sym_sym_lit_repeat1] = STATE(306),
    [sym__ws] = ACTIONS(264),
    [sym_comment] = ACTIONS(264),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(482),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(426),
    [anon_sym_COLON_COLON] = ACTIONS(428),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(482),
    [sym_nil_lit] = ACTIONS(484),
    [sym_bool_lit] = ACTIONS(484),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(430),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(432),
    [anon_sym_POUND_POUND] = ACTIONS(434),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(436),
    [anon_sym_SQUOTE] = ACTIONS(438),
    [anon_sym_BQUOTE] = ACTIONS(440),
    [anon_sym_TILDE_AT] = ACTIONS(442),
    [anon_sym_TILDE] = ACTIONS(444),
  },
  [199] = {
    [sym__gap] = STATE(301),
    [sym_dis_expr] = STATE(301),
    [sym__form] = STATE(364),
    [sym_kwd_lit] = STATE(364),
    [sym_str_lit] = STATE(364),
    [sym_sym_lit] = STATE(364),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(364),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(364),
    [sym__bare_map_lit] = STATE(403),
    [sym_vec_lit] = STATE(364),
    [sym__bare_vec_lit] = STATE(423),
    [sym_set_lit] = STATE(364),
    [sym__bare_set_lit] = STATE(374),
    [sym_anon_fn_lit] = STATE(364),
    [sym_regex_lit] = STATE(364),
    [sym_read_cond_lit] = STATE(364),
    [sym_splicing_read_cond_lit] = STATE(364),
    [sym_ns_map_lit] = STATE(364),
    [sym_var_quoting_lit] = STATE(364),
    [sym_sym_val_lit] = STATE(364),
    [sym_evaling_lit] = STATE(364),
    [sym_tagged_or_ctor_lit] = STATE(364),
    [sym_derefing_lit] = STATE(364),
    [sym_quoting_lit] = STATE(364),
    [sym_syn_quoting_lit] = STATE(364),
    [sym_unquote_splicing_lit] = STATE(364),
    [sym_unquoting_lit] = STATE(364),
    [aux_sym_dis_expr_repeat1] = STATE(301),
    [aux_sym_sym_lit_repeat1] = STATE(306),
    [sym__ws] = ACTIONS(264),
    [sym_comment] = ACTIONS(264),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(394),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(426),
    [anon_sym_COLON_COLON] = ACTIONS(428),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(394),
    [sym_nil_lit] = ACTIONS(396),
    [sym_bool_lit] = ACTIONS(396),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(430),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(432),
    [anon_sym_POUND_POUND] = ACTIONS(434),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(436),
    [anon_sym_SQUOTE] = ACTIONS(438),
    [anon_sym_BQUOTE] = ACTIONS(440),
    [anon_sym_TILDE_AT] = ACTIONS(442),
    [anon_sym_TILDE] = ACTIONS(444),
  },
  [200] = {
    [sym__gap] = STATE(196),
    [sym_dis_expr] = STATE(196),
    [sym__form] = STATE(405),
    [sym_kwd_lit] = STATE(405),
    [sym_str_lit] = STATE(405),
    [sym_sym_lit] = STATE(405),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(405),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(405),
    [sym__bare_map_lit] = STATE(403),
    [sym_vec_lit] = STATE(405),
    [sym__bare_vec_lit] = STATE(423),
    [sym_set_lit] = STATE(405),
    [sym__bare_set_lit] = STATE(374),
    [sym_anon_fn_lit] = STATE(405),
    [sym_regex_lit] = STATE(405),
    [sym_read_cond_lit] = STATE(405),
    [sym_splicing_read_cond_lit] = STATE(405),
    [sym_ns_map_lit] = STATE(405),
    [sym_var_quoting_lit] = STATE(405),
    [sym_sym_val_lit] = STATE(405),
    [sym_evaling_lit] = STATE(405),
    [sym_tagged_or_ctor_lit] = STATE(405),
    [sym_derefing_lit] = STATE(405),
    [sym_quoting_lit] = STATE(405),
    [sym_syn_quoting_lit] = STATE(405),
    [sym_unquote_splicing_lit] = STATE(405),
    [sym_unquoting_lit] = STATE(405),
    [aux_sym_dis_expr_repeat1] = STATE(196),
    [aux_sym_sym_lit_repeat1] = STATE(306),
    [sym__ws] = ACTIONS(846),
    [sym_comment] = ACTIONS(846),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(454),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(426),
    [anon_sym_COLON_COLON] = ACTIONS(428),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(454),
    [sym_nil_lit] = ACTIONS(456),
    [sym_bool_lit] = ACTIONS(456),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(430),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(432),
    [anon_sym_POUND_POUND] = ACTIONS(434),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(436),
    [anon_sym_SQUOTE] = ACTIONS(438),
    [anon_sym_BQUOTE] = ACTIONS(440),
    [anon_sym_TILDE_AT] = ACTIONS(442),
    [anon_sym_TILDE] = ACTIONS(444),
  },
  [201] = {
    [sym__gap] = STATE(301),
    [sym_dis_expr] = STATE(301),
    [sym__form] = STATE(386),
    [sym_kwd_lit] = STATE(386),
    [sym_str_lit] = STATE(386),
    [sym_sym_lit] = STATE(386),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(386),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(386),
    [sym__bare_map_lit] = STATE(403),
    [sym_vec_lit] = STATE(386),
    [sym__bare_vec_lit] = STATE(423),
    [sym_set_lit] = STATE(386),
    [sym__bare_set_lit] = STATE(374),
    [sym_anon_fn_lit] = STATE(386),
    [sym_regex_lit] = STATE(386),
    [sym_read_cond_lit] = STATE(386),
    [sym_splicing_read_cond_lit] = STATE(386),
    [sym_ns_map_lit] = STATE(386),
    [sym_var_quoting_lit] = STATE(386),
    [sym_sym_val_lit] = STATE(386),
    [sym_evaling_lit] = STATE(386),
    [sym_tagged_or_ctor_lit] = STATE(386),
    [sym_derefing_lit] = STATE(386),
    [sym_quoting_lit] = STATE(386),
    [sym_syn_quoting_lit] = STATE(386),
    [sym_unquote_splicing_lit] = STATE(386),
    [sym_unquoting_lit] = STATE(386),
    [aux_sym_dis_expr_repeat1] = STATE(301),
    [aux_sym_sym_lit_repeat1] = STATE(304),
    [sym__ws] = ACTIONS(264),
    [sym_comment] = ACTIONS(264),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(492),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(270),
    [anon_sym_COLON_COLON] = ACTIONS(272),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(492),
    [sym_nil_lit] = ACTIONS(494),
    [sym_bool_lit] = ACTIONS(494),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(286),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(292),
    [anon_sym_POUND_POUND] = ACTIONS(294),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(298),
    [anon_sym_SQUOTE] = ACTIONS(300),
    [anon_sym_BQUOTE] = ACTIONS(302),
    [anon_sym_TILDE_AT] = ACTIONS(304),
    [anon_sym_TILDE] = ACTIONS(306),
  },
  [202] = {
    [sym__gap] = STATE(182),
    [sym_dis_expr] = STATE(182),
    [sym__form] = STATE(362),
    [sym_kwd_lit] = STATE(362),
    [sym_str_lit] = STATE(362),
    [sym_sym_lit] = STATE(362),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(362),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(362),
    [sym__bare_map_lit] = STATE(403),
    [sym_vec_lit] = STATE(362),
    [sym__bare_vec_lit] = STATE(423),
    [sym_set_lit] = STATE(362),
    [sym__bare_set_lit] = STATE(374),
    [sym_anon_fn_lit] = STATE(362),
    [sym_regex_lit] = STATE(362),
    [sym_read_cond_lit] = STATE(362),
    [sym_splicing_read_cond_lit] = STATE(362),
    [sym_ns_map_lit] = STATE(362),
    [sym_var_quoting_lit] = STATE(362),
    [sym_sym_val_lit] = STATE(362),
    [sym_evaling_lit] = STATE(362),
    [sym_tagged_or_ctor_lit] = STATE(362),
    [sym_derefing_lit] = STATE(362),
    [sym_quoting_lit] = STATE(362),
    [sym_syn_quoting_lit] = STATE(362),
    [sym_unquote_splicing_lit] = STATE(362),
    [sym_unquoting_lit] = STATE(362),
    [aux_sym_dis_expr_repeat1] = STATE(182),
    [aux_sym_sym_lit_repeat1] = STATE(306),
    [sym__ws] = ACTIONS(848),
    [sym_comment] = ACTIONS(848),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(390),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(426),
    [anon_sym_COLON_COLON] = ACTIONS(428),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(390),
    [sym_nil_lit] = ACTIONS(392),
    [sym_bool_lit] = ACTIONS(392),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(430),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(432),
    [anon_sym_POUND_POUND] = ACTIONS(434),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(436),
    [anon_sym_SQUOTE] = ACTIONS(438),
    [anon_sym_BQUOTE] = ACTIONS(440),
    [anon_sym_TILDE_AT] = ACTIONS(442),
    [anon_sym_TILDE] = ACTIONS(444),
  },
  [203] = {
    [sym__gap] = STATE(301),
    [sym_dis_expr] = STATE(301),
    [sym__form] = STATE(416),
    [sym_kwd_lit] = STATE(416),
    [sym_str_lit] = STATE(416),
    [sym_sym_lit] = STATE(416),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(416),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(416),
    [sym__bare_map_lit] = STATE(403),
    [sym_vec_lit] = STATE(416),
    [sym__bare_vec_lit] = STATE(423),
    [sym_set_lit] = STATE(416),
    [sym__bare_set_lit] = STATE(374),
    [sym_anon_fn_lit] = STATE(416),
    [sym_regex_lit] = STATE(416),
    [sym_read_cond_lit] = STATE(416),
    [sym_splicing_read_cond_lit] = STATE(416),
    [sym_ns_map_lit] = STATE(416),
    [sym_var_quoting_lit] = STATE(416),
    [sym_sym_val_lit] = STATE(416),
    [sym_evaling_lit] = STATE(416),
    [sym_tagged_or_ctor_lit] = STATE(416),
    [sym_derefing_lit] = STATE(416),
    [sym_quoting_lit] = STATE(416),
    [sym_syn_quoting_lit] = STATE(416),
    [sym_unquote_splicing_lit] = STATE(416),
    [sym_unquoting_lit] = STATE(416),
    [aux_sym_dis_expr_repeat1] = STATE(301),
    [aux_sym_sym_lit_repeat1] = STATE(306),
    [sym__ws] = ACTIONS(264),
    [sym_comment] = ACTIONS(264),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(478),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(426),
    [anon_sym_COLON_COLON] = ACTIONS(428),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(478),
    [sym_nil_lit] = ACTIONS(480),
    [sym_bool_lit] = ACTIONS(480),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(430),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(432),
    [anon_sym_POUND_POUND] = ACTIONS(434),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(436),
    [anon_sym_SQUOTE] = ACTIONS(438),
    [anon_sym_BQUOTE] = ACTIONS(440),
    [anon_sym_TILDE_AT] = ACTIONS(442),
    [anon_sym_TILDE] = ACTIONS(444),
  },
  [204] = {
    [sym__gap] = STATE(190),
    [sym_dis_expr] = STATE(190),
    [sym__form] = STATE(393),
    [sym_kwd_lit] = STATE(393),
    [sym_str_lit] = STATE(393),
    [sym_sym_lit] = STATE(393),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(393),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(393),
    [sym__bare_map_lit] = STATE(403),
    [sym_vec_lit] = STATE(393),
    [sym__bare_vec_lit] = STATE(423),
    [sym_set_lit] = STATE(393),
    [sym__bare_set_lit] = STATE(374),
    [sym_anon_fn_lit] = STATE(393),
    [sym_regex_lit] = STATE(393),
    [sym_read_cond_lit] = STATE(393),
    [sym_splicing_read_cond_lit] = STATE(393),
    [sym_ns_map_lit] = STATE(393),
    [sym_var_quoting_lit] = STATE(393),
    [sym_sym_val_lit] = STATE(393),
    [sym_evaling_lit] = STATE(393),
    [sym_tagged_or_ctor_lit] = STATE(393),
    [sym_derefing_lit] = STATE(393),
    [sym_quoting_lit] = STATE(393),
    [sym_syn_quoting_lit] = STATE(393),
    [sym_unquote_splicing_lit] = STATE(393),
    [sym_unquoting_lit] = STATE(393),
    [aux_sym_dis_expr_repeat1] = STATE(190),
    [aux_sym_sym_lit_repeat1] = STATE(306),
    [sym__ws] = ACTIONS(850),
    [sym_comment] = ACTIONS(850),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(448),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(426),
    [anon_sym_COLON_COLON] = ACTIONS(428),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(448),
    [sym_nil_lit] = ACTIONS(450),
    [sym_bool_lit] = ACTIONS(450),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(430),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(432),
    [anon_sym_POUND_POUND] = ACTIONS(434),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(436),
    [anon_sym_SQUOTE] = ACTIONS(438),
    [anon_sym_BQUOTE] = ACTIONS(440),
    [anon_sym_TILDE_AT] = ACTIONS(442),
    [anon_sym_TILDE] = ACTIONS(444),
  },
  [205] = {
    [sym__gap] = STATE(301),
    [sym_dis_expr] = STATE(301),
    [sym__form] = STATE(415),
    [sym_kwd_lit] = STATE(415),
    [sym_str_lit] = STATE(415),
    [sym_sym_lit] = STATE(415),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(415),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(415),
    [sym__bare_map_lit] = STATE(403),
    [sym_vec_lit] = STATE(415),
    [sym__bare_vec_lit] = STATE(423),
    [sym_set_lit] = STATE(415),
    [sym__bare_set_lit] = STATE(374),
    [sym_anon_fn_lit] = STATE(415),
    [sym_regex_lit] = STATE(415),
    [sym_read_cond_lit] = STATE(415),
    [sym_splicing_read_cond_lit] = STATE(415),
    [sym_ns_map_lit] = STATE(415),
    [sym_var_quoting_lit] = STATE(415),
    [sym_sym_val_lit] = STATE(415),
    [sym_evaling_lit] = STATE(415),
    [sym_tagged_or_ctor_lit] = STATE(415),
    [sym_derefing_lit] = STATE(415),
    [sym_quoting_lit] = STATE(415),
    [sym_syn_quoting_lit] = STATE(415),
    [sym_unquote_splicing_lit] = STATE(415),
    [sym_unquoting_lit] = STATE(415),
    [aux_sym_dis_expr_repeat1] = STATE(301),
    [aux_sym_sym_lit_repeat1] = STATE(306),
    [sym__ws] = ACTIONS(264),
    [sym_comment] = ACTIONS(264),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(474),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(426),
    [anon_sym_COLON_COLON] = ACTIONS(428),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(474),
    [sym_nil_lit] = ACTIONS(476),
    [sym_bool_lit] = ACTIONS(476),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(430),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(432),
    [anon_sym_POUND_POUND] = ACTIONS(434),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(436),
    [anon_sym_SQUOTE] = ACTIONS(438),
    [anon_sym_BQUOTE] = ACTIONS(440),
    [anon_sym_TILDE_AT] = ACTIONS(442),
    [anon_sym_TILDE] = ACTIONS(444),
  },
  [206] = {
    [sym__gap] = STATE(187),
    [sym_dis_expr] = STATE(187),
    [sym__form] = STATE(391),
    [sym_kwd_lit] = STATE(391),
    [sym_str_lit] = STATE(391),
    [sym_sym_lit] = STATE(391),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(391),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(391),
    [sym__bare_map_lit] = STATE(403),
    [sym_vec_lit] = STATE(391),
    [sym__bare_vec_lit] = STATE(423),
    [sym_set_lit] = STATE(391),
    [sym__bare_set_lit] = STATE(374),
    [sym_anon_fn_lit] = STATE(391),
    [sym_regex_lit] = STATE(391),
    [sym_read_cond_lit] = STATE(391),
    [sym_splicing_read_cond_lit] = STATE(391),
    [sym_ns_map_lit] = STATE(391),
    [sym_var_quoting_lit] = STATE(391),
    [sym_sym_val_lit] = STATE(391),
    [sym_evaling_lit] = STATE(391),
    [sym_tagged_or_ctor_lit] = STATE(391),
    [sym_derefing_lit] = STATE(391),
    [sym_quoting_lit] = STATE(391),
    [sym_syn_quoting_lit] = STATE(391),
    [sym_unquote_splicing_lit] = STATE(391),
    [sym_unquoting_lit] = STATE(391),
    [aux_sym_dis_expr_repeat1] = STATE(187),
    [aux_sym_sym_lit_repeat1] = STATE(306),
    [sym__ws] = ACTIONS(852),
    [sym_comment] = ACTIONS(852),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(418),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(426),
    [anon_sym_COLON_COLON] = ACTIONS(428),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(418),
    [sym_nil_lit] = ACTIONS(420),
    [sym_bool_lit] = ACTIONS(420),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(430),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(432),
    [anon_sym_POUND_POUND] = ACTIONS(434),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(436),
    [anon_sym_SQUOTE] = ACTIONS(438),
    [anon_sym_BQUOTE] = ACTIONS(440),
    [anon_sym_TILDE_AT] = ACTIONS(442),
    [anon_sym_TILDE] = ACTIONS(444),
  },
  [207] = {
    [sym__gap] = STATE(301),
    [sym_dis_expr] = STATE(301),
    [sym__form] = STATE(414),
    [sym_kwd_lit] = STATE(414),
    [sym_str_lit] = STATE(414),
    [sym_sym_lit] = STATE(414),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(414),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(414),
    [sym__bare_map_lit] = STATE(403),
    [sym_vec_lit] = STATE(414),
    [sym__bare_vec_lit] = STATE(423),
    [sym_set_lit] = STATE(414),
    [sym__bare_set_lit] = STATE(374),
    [sym_anon_fn_lit] = STATE(414),
    [sym_regex_lit] = STATE(414),
    [sym_read_cond_lit] = STATE(414),
    [sym_splicing_read_cond_lit] = STATE(414),
    [sym_ns_map_lit] = STATE(414),
    [sym_var_quoting_lit] = STATE(414),
    [sym_sym_val_lit] = STATE(414),
    [sym_evaling_lit] = STATE(414),
    [sym_tagged_or_ctor_lit] = STATE(414),
    [sym_derefing_lit] = STATE(414),
    [sym_quoting_lit] = STATE(414),
    [sym_syn_quoting_lit] = STATE(414),
    [sym_unquote_splicing_lit] = STATE(414),
    [sym_unquoting_lit] = STATE(414),
    [aux_sym_dis_expr_repeat1] = STATE(301),
    [aux_sym_sym_lit_repeat1] = STATE(306),
    [sym__ws] = ACTIONS(264),
    [sym_comment] = ACTIONS(264),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(470),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(426),
    [anon_sym_COLON_COLON] = ACTIONS(428),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(470),
    [sym_nil_lit] = ACTIONS(472),
    [sym_bool_lit] = ACTIONS(472),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(430),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(432),
    [anon_sym_POUND_POUND] = ACTIONS(434),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(436),
    [anon_sym_SQUOTE] = ACTIONS(438),
    [anon_sym_BQUOTE] = ACTIONS(440),
    [anon_sym_TILDE_AT] = ACTIONS(442),
    [anon_sym_TILDE] = ACTIONS(444),
  },
  [208] = {
    [sym__gap] = STATE(199),
    [sym_dis_expr] = STATE(199),
    [sym__form] = STATE(409),
    [sym_kwd_lit] = STATE(409),
    [sym_str_lit] = STATE(409),
    [sym_sym_lit] = STATE(409),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(409),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(409),
    [sym__bare_map_lit] = STATE(403),
    [sym_vec_lit] = STATE(409),
    [sym__bare_vec_lit] = STATE(423),
    [sym_set_lit] = STATE(409),
    [sym__bare_set_lit] = STATE(374),
    [sym_anon_fn_lit] = STATE(409),
    [sym_regex_lit] = STATE(409),
    [sym_read_cond_lit] = STATE(409),
    [sym_splicing_read_cond_lit] = STATE(409),
    [sym_ns_map_lit] = STATE(409),
    [sym_var_quoting_lit] = STATE(409),
    [sym_sym_val_lit] = STATE(409),
    [sym_evaling_lit] = STATE(409),
    [sym_tagged_or_ctor_lit] = STATE(409),
    [sym_derefing_lit] = STATE(409),
    [sym_quoting_lit] = STATE(409),
    [sym_syn_quoting_lit] = STATE(409),
    [sym_unquote_splicing_lit] = STATE(409),
    [sym_unquoting_lit] = STATE(409),
    [aux_sym_dis_expr_repeat1] = STATE(199),
    [aux_sym_sym_lit_repeat1] = STATE(306),
    [sym__ws] = ACTIONS(854),
    [sym_comment] = ACTIONS(854),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(488),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(426),
    [anon_sym_COLON_COLON] = ACTIONS(428),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(488),
    [sym_nil_lit] = ACTIONS(490),
    [sym_bool_lit] = ACTIONS(490),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(430),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(432),
    [anon_sym_POUND_POUND] = ACTIONS(434),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(436),
    [anon_sym_SQUOTE] = ACTIONS(438),
    [anon_sym_BQUOTE] = ACTIONS(440),
    [anon_sym_TILDE_AT] = ACTIONS(442),
    [anon_sym_TILDE] = ACTIONS(444),
  },
  [209] = {
    [sym__gap] = STATE(186),
    [sym_dis_expr] = STATE(186),
    [sym__form] = STATE(410),
    [sym_kwd_lit] = STATE(410),
    [sym_str_lit] = STATE(410),
    [sym_sym_lit] = STATE(410),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(410),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(410),
    [sym__bare_map_lit] = STATE(403),
    [sym_vec_lit] = STATE(410),
    [sym__bare_vec_lit] = STATE(423),
    [sym_set_lit] = STATE(410),
    [sym__bare_set_lit] = STATE(374),
    [sym_anon_fn_lit] = STATE(410),
    [sym_regex_lit] = STATE(410),
    [sym_read_cond_lit] = STATE(410),
    [sym_splicing_read_cond_lit] = STATE(410),
    [sym_ns_map_lit] = STATE(410),
    [sym_var_quoting_lit] = STATE(410),
    [sym_sym_val_lit] = STATE(410),
    [sym_evaling_lit] = STATE(410),
    [sym_tagged_or_ctor_lit] = STATE(410),
    [sym_derefing_lit] = STATE(410),
    [sym_quoting_lit] = STATE(410),
    [sym_syn_quoting_lit] = STATE(410),
    [sym_unquote_splicing_lit] = STATE(410),
    [sym_unquoting_lit] = STATE(410),
    [aux_sym_dis_expr_repeat1] = STATE(186),
    [aux_sym_sym_lit_repeat1] = STATE(306),
    [sym__ws] = ACTIONS(856),
    [sym_comment] = ACTIONS(856),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(412),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(426),
    [anon_sym_COLON_COLON] = ACTIONS(428),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(412),
    [sym_nil_lit] = ACTIONS(414),
    [sym_bool_lit] = ACTIONS(414),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(430),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(432),
    [anon_sym_POUND_POUND] = ACTIONS(434),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(436),
    [anon_sym_SQUOTE] = ACTIONS(438),
    [anon_sym_BQUOTE] = ACTIONS(440),
    [anon_sym_TILDE_AT] = ACTIONS(442),
    [anon_sym_TILDE] = ACTIONS(444),
  },
  [210] = {
    [sym__gap] = STATE(301),
    [sym_dis_expr] = STATE(301),
    [sym__form] = STATE(412),
    [sym_kwd_lit] = STATE(412),
    [sym_str_lit] = STATE(412),
    [sym_sym_lit] = STATE(412),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(412),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(412),
    [sym__bare_map_lit] = STATE(403),
    [sym_vec_lit] = STATE(412),
    [sym__bare_vec_lit] = STATE(423),
    [sym_set_lit] = STATE(412),
    [sym__bare_set_lit] = STATE(374),
    [sym_anon_fn_lit] = STATE(412),
    [sym_regex_lit] = STATE(412),
    [sym_read_cond_lit] = STATE(412),
    [sym_splicing_read_cond_lit] = STATE(412),
    [sym_ns_map_lit] = STATE(412),
    [sym_var_quoting_lit] = STATE(412),
    [sym_sym_val_lit] = STATE(412),
    [sym_evaling_lit] = STATE(412),
    [sym_tagged_or_ctor_lit] = STATE(412),
    [sym_derefing_lit] = STATE(412),
    [sym_quoting_lit] = STATE(412),
    [sym_syn_quoting_lit] = STATE(412),
    [sym_unquote_splicing_lit] = STATE(412),
    [sym_unquoting_lit] = STATE(412),
    [aux_sym_dis_expr_repeat1] = STATE(301),
    [aux_sym_sym_lit_repeat1] = STATE(306),
    [sym__ws] = ACTIONS(264),
    [sym_comment] = ACTIONS(264),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(466),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(426),
    [anon_sym_COLON_COLON] = ACTIONS(428),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(466),
    [sym_nil_lit] = ACTIONS(468),
    [sym_bool_lit] = ACTIONS(468),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(430),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(432),
    [anon_sym_POUND_POUND] = ACTIONS(434),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(436),
    [anon_sym_SQUOTE] = ACTIONS(438),
    [anon_sym_BQUOTE] = ACTIONS(440),
    [anon_sym_TILDE_AT] = ACTIONS(442),
    [anon_sym_TILDE] = ACTIONS(444),
  },
  [211] = {
    [sym__gap] = STATE(185),
    [sym_dis_expr] = STATE(185),
    [sym__form] = STATE(384),
    [sym_kwd_lit] = STATE(384),
    [sym_str_lit] = STATE(384),
    [sym_sym_lit] = STATE(384),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(384),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(384),
    [sym__bare_map_lit] = STATE(403),
    [sym_vec_lit] = STATE(384),
    [sym__bare_vec_lit] = STATE(423),
    [sym_set_lit] = STATE(384),
    [sym__bare_set_lit] = STATE(374),
    [sym_anon_fn_lit] = STATE(384),
    [sym_regex_lit] = STATE(384),
    [sym_read_cond_lit] = STATE(384),
    [sym_splicing_read_cond_lit] = STATE(384),
    [sym_ns_map_lit] = STATE(384),
    [sym_var_quoting_lit] = STATE(384),
    [sym_sym_val_lit] = STATE(384),
    [sym_evaling_lit] = STATE(384),
    [sym_tagged_or_ctor_lit] = STATE(384),
    [sym_derefing_lit] = STATE(384),
    [sym_quoting_lit] = STATE(384),
    [sym_syn_quoting_lit] = STATE(384),
    [sym_unquote_splicing_lit] = STATE(384),
    [sym_unquoting_lit] = STATE(384),
    [aux_sym_dis_expr_repeat1] = STATE(185),
    [aux_sym_sym_lit_repeat1] = STATE(306),
    [sym__ws] = ACTIONS(858),
    [sym_comment] = ACTIONS(858),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(406),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(426),
    [anon_sym_COLON_COLON] = ACTIONS(428),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(406),
    [sym_nil_lit] = ACTIONS(408),
    [sym_bool_lit] = ACTIONS(408),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(430),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(432),
    [anon_sym_POUND_POUND] = ACTIONS(434),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(436),
    [anon_sym_SQUOTE] = ACTIONS(438),
    [anon_sym_BQUOTE] = ACTIONS(440),
    [anon_sym_TILDE_AT] = ACTIONS(442),
    [anon_sym_TILDE] = ACTIONS(444),
  },
  [212] = {
    [sym__gap] = STATE(301),
    [sym_dis_expr] = STATE(301),
    [sym__form] = STATE(369),
    [sym_kwd_lit] = STATE(369),
    [sym_str_lit] = STATE(369),
    [sym_sym_lit] = STATE(369),
    [sym__metadata_lit] = STATE(424),
    [sym_meta_lit] = STATE(314),
    [sym_old_meta_lit] = STATE(313),
    [sym_list_lit] = STATE(369),
    [sym__bare_list_lit] = STATE(392),
    [sym_map_lit] = STATE(369),
    [sym__bare_map_lit] = STATE(403),
    [sym_vec_lit] = STATE(369),
    [sym__bare_vec_lit] = STATE(423),
    [sym_set_lit] = STATE(369),
    [sym__bare_set_lit] = STATE(374),
    [sym_anon_fn_lit] = STATE(369),
    [sym_regex_lit] = STATE(369),
    [sym_read_cond_lit] = STATE(369),
    [sym_splicing_read_cond_lit] = STATE(369),
    [sym_ns_map_lit] = STATE(369),
    [sym_var_quoting_lit] = STATE(369),
    [sym_sym_val_lit] = STATE(369),
    [sym_evaling_lit] = STATE(369),
    [sym_tagged_or_ctor_lit] = STATE(369),
    [sym_derefing_lit] = STATE(369),
    [sym_quoting_lit] = STATE(369),
    [sym_syn_quoting_lit] = STATE(369),
    [sym_unquote_splicing_lit] = STATE(369),
    [sym_unquoting_lit] = STATE(369),
    [aux_sym_dis_expr_repeat1] = STATE(301),
    [aux_sym_sym_lit_repeat1] = STATE(306),
    [sym__ws] = ACTIONS(264),
    [sym_comment] = ACTIONS(264),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(458),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(426),
    [anon_sym_COLON_COLON] = ACTIONS(428),
    [aux_sym_str_lit_token1] = ACTIONS(274),
    [sym_char_lit] = ACTIONS(458),
    [sym_nil_lit] = ACTIONS(460),
    [sym_bool_lit] = ACTIONS(460),
    [aux_sym__sym_qualified_token1] = ACTIONS(278),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_POUND_CARET] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_POUND] = ACTIONS(430),
    [anon_sym_POUND_QMARK] = ACTIONS(288),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(290),
    [anon_sym_POUND_SQUOTE] = ACTIONS(432),
    [anon_sym_POUND_POUND] = ACTIONS(434),
    [anon_sym_POUND_EQ] = ACTIONS(296),
    [anon_sym_AT] = ACTIONS(436),
    [anon_sym_SQUOTE] = ACTIONS(438),
    [anon_sym_BQUOTE] = ACTIONS(440),
    [anon_sym_TILDE_AT] = ACTIONS(442),
    [anon_sym_TILDE] = ACTIONS(444),
  },
};

static const uint16_t ts_small_parse_table[] = {
  [0] = 3,
    ACTIONS(864), 1,
      aux_sym__kwd_leading_slash_token1,
    ACTIONS(862), 14,
      anon_sym_POUND_,
      anon_sym_SLASH,
      anon_sym_COLON,
      anon_sym_COLON_COLON,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym__sym_qualified_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_SQUOTE,
      anon_sym_TILDE,
    ACTIONS(860), 18,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      sym_num_lit,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_AT,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [40] = 2,
    ACTIONS(868), 7,
      anon_sym_COLON,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym__sym_qualified_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(866), 25,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [77] = 2,
    ACTIONS(872), 7,
      anon_sym_COLON,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym__sym_qualified_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(870), 25,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [114] = 2,
    ACTIONS(876), 7,
      anon_sym_COLON,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym__sym_qualified_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(874), 25,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [151] = 3,
    ACTIONS(880), 1,
      anon_sym_SLASH,
    ACTIONS(882), 7,
      anon_sym_COLON,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym__sym_qualified_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(878), 24,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [190] = 2,
    ACTIONS(886), 7,
      anon_sym_COLON,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym__sym_qualified_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(884), 25,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [227] = 2,
    ACTIONS(890), 7,
      anon_sym_COLON,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym__sym_qualified_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(888), 25,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [264] = 2,
    ACTIONS(894), 7,
      anon_sym_COLON,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym__sym_qualified_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(892), 25,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [301] = 2,
    ACTIONS(898), 7,
      anon_sym_COLON,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym__sym_qualified_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(896), 25,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [338] = 2,
    ACTIONS(902), 7,
      anon_sym_COLON,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym__sym_qualified_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(900), 25,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [375] = 2,
    ACTIONS(906), 7,
      anon_sym_COLON,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym__sym_qualified_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(904), 25,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [412] = 2,
    ACTIONS(910), 7,
      anon_sym_COLON,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym__sym_qualified_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(908), 25,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [449] = 2,
    ACTIONS(914), 7,
      anon_sym_COLON,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym__sym_qualified_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(912), 25,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [486] = 2,
    ACTIONS(918), 7,
      anon_sym_COLON,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym__sym_qualified_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(916), 25,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [523] = 2,
    ACTIONS(922), 7,
      anon_sym_COLON,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym__sym_qualified_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(920), 25,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [560] = 2,
    ACTIONS(926), 7,
      anon_sym_COLON,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym__sym_qualified_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(924), 25,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [597] = 2,
    ACTIONS(930), 7,
      anon_sym_COLON,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym__sym_qualified_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(928), 25,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [634] = 3,
    ACTIONS(932), 1,
      anon_sym_SLASH,
    ACTIONS(862), 7,
      anon_sym_COLON,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym__sym_qualified_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(860), 24,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [673] = 2,
    ACTIONS(936), 7,
      anon_sym_COLON,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym__sym_qualified_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(934), 25,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [710] = 2,
    ACTIONS(926), 7,
      anon_sym_COLON,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym__sym_qualified_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(924), 25,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [747] = 2,
    ACTIONS(940), 7,
      anon_sym_COLON,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym__sym_qualified_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(938), 25,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [784] = 2,
    ACTIONS(944), 7,
      anon_sym_COLON,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym__sym_qualified_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(942), 25,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [821] = 2,
    ACTIONS(948), 7,
      anon_sym_COLON,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym__sym_qualified_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(946), 25,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [858] = 2,
    ACTIONS(952), 7,
      anon_sym_COLON,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym__sym_qualified_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(950), 25,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [895] = 2,
    ACTIONS(956), 7,
      anon_sym_COLON,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym__sym_qualified_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(954), 25,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [932] = 2,
    ACTIONS(960), 7,
      anon_sym_COLON,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym__sym_qualified_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(958), 25,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [969] = 2,
    ACTIONS(964), 7,
      anon_sym_COLON,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym__sym_qualified_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(962), 25,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [1006] = 2,
    ACTIONS(968), 7,
      anon_sym_COLON,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym__sym_qualified_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(966), 25,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [1043] = 2,
    ACTIONS(972), 7,
      anon_sym_COLON,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym__sym_qualified_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(970), 25,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [1080] = 2,
    ACTIONS(926), 7,
      anon_sym_COLON,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym__sym_qualified_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(924), 25,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [1117] = 2,
    ACTIONS(976), 7,
      anon_sym_COLON,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym__sym_qualified_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(974), 25,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [1154] = 2,
    ACTIONS(980), 7,
      anon_sym_COLON,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym__sym_qualified_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(978), 25,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [1191] = 2,
    ACTIONS(984), 7,
      anon_sym_COLON,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym__sym_qualified_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(982), 25,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [1228] = 2,
    ACTIONS(988), 7,
      anon_sym_COLON,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym__sym_qualified_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(986), 25,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [1265] = 2,
    ACTIONS(992), 7,
      anon_sym_COLON,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym__sym_qualified_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(990), 25,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [1302] = 2,
    ACTIONS(996), 7,
      anon_sym_COLON,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym__sym_qualified_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(994), 25,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [1339] = 2,
    ACTIONS(1000), 7,
      anon_sym_COLON,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym__sym_qualified_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(998), 25,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [1376] = 2,
    ACTIONS(1004), 7,
      anon_sym_COLON,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym__sym_qualified_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1002), 25,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [1413] = 2,
    ACTIONS(1008), 7,
      anon_sym_COLON,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym__sym_qualified_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1006), 25,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [1450] = 3,
    ACTIONS(1010), 1,
      anon_sym_SLASH,
    ACTIONS(1008), 7,
      anon_sym_COLON,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym__sym_qualified_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1006), 24,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [1489] = 2,
    ACTIONS(1014), 7,
      anon_sym_COLON,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym__sym_qualified_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1012), 25,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [1526] = 2,
    ACTIONS(1018), 7,
      anon_sym_COLON,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym__sym_qualified_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1016), 25,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [1563] = 2,
    ACTIONS(1022), 7,
      anon_sym_COLON,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym__sym_qualified_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1020), 25,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [1600] = 2,
    ACTIONS(1026), 7,
      anon_sym_COLON,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym__sym_qualified_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1024), 25,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [1637] = 2,
    ACTIONS(1030), 7,
      anon_sym_COLON,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym__sym_qualified_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1028), 25,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [1674] = 2,
    ACTIONS(1034), 7,
      anon_sym_COLON,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym__sym_qualified_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1032), 25,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [1711] = 2,
    ACTIONS(1038), 7,
      anon_sym_COLON,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym__sym_qualified_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1036), 25,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [1748] = 2,
    ACTIONS(1042), 7,
      anon_sym_COLON,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym__sym_qualified_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1040), 25,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [1785] = 2,
    ACTIONS(1046), 7,
      anon_sym_COLON,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym__sym_qualified_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1044), 25,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [1822] = 2,
    ACTIONS(1050), 7,
      anon_sym_COLON,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym__sym_qualified_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1048), 25,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [1859] = 2,
    ACTIONS(1054), 7,
      anon_sym_COLON,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym__sym_qualified_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1052), 25,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [1896] = 2,
    ACTIONS(1058), 7,
      anon_sym_COLON,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym__sym_qualified_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1056), 25,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [1933] = 2,
    ACTIONS(1062), 7,
      anon_sym_COLON,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym__sym_qualified_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1060), 25,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [1970] = 2,
    ACTIONS(1066), 7,
      anon_sym_COLON,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym__sym_qualified_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1064), 25,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [2007] = 2,
    ACTIONS(1070), 7,
      anon_sym_COLON,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym__sym_qualified_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1068), 25,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [2044] = 2,
    ACTIONS(1074), 7,
      anon_sym_COLON,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym__sym_qualified_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1072), 25,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [2081] = 2,
    ACTIONS(1078), 7,
      anon_sym_COLON,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym__sym_qualified_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1076), 25,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [2118] = 2,
    ACTIONS(1082), 7,
      anon_sym_COLON,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym__sym_qualified_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1080), 25,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [2155] = 2,
    ACTIONS(1086), 7,
      anon_sym_COLON,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym__sym_qualified_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1084), 25,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [2192] = 2,
    ACTIONS(1090), 7,
      anon_sym_COLON,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym__sym_qualified_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1088), 25,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [2229] = 2,
    ACTIONS(1034), 7,
      anon_sym_COLON,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym__sym_qualified_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1032), 25,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [2266] = 2,
    ACTIONS(1094), 7,
      anon_sym_COLON,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym__sym_qualified_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1092), 25,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [2303] = 2,
    ACTIONS(1098), 7,
      anon_sym_COLON,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym__sym_qualified_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1096), 25,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [2340] = 2,
    ACTIONS(1102), 7,
      anon_sym_COLON,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym__sym_qualified_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1100), 25,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [2377] = 2,
    ACTIONS(1106), 7,
      anon_sym_COLON,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym__sym_qualified_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1104), 25,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [2414] = 2,
    ACTIONS(1110), 7,
      anon_sym_COLON,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym__sym_qualified_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1108), 25,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [2451] = 2,
    ACTIONS(1114), 7,
      anon_sym_COLON,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym__sym_qualified_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1112), 25,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [2488] = 2,
    ACTIONS(882), 7,
      anon_sym_COLON,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym__sym_qualified_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(878), 25,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [2525] = 2,
    ACTIONS(1118), 7,
      anon_sym_COLON,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym__sym_qualified_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1116), 25,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [2562] = 2,
    ACTIONS(1122), 7,
      anon_sym_COLON,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym__sym_qualified_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1120), 25,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [2599] = 2,
    ACTIONS(1126), 7,
      anon_sym_COLON,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym__sym_qualified_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1124), 25,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [2636] = 2,
    ACTIONS(1130), 7,
      anon_sym_COLON,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym__sym_qualified_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1128), 25,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [2673] = 2,
    ACTIONS(1130), 7,
      anon_sym_COLON,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym__sym_qualified_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1128), 25,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [2710] = 2,
    ACTIONS(1130), 7,
      anon_sym_COLON,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym__sym_qualified_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1128), 25,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [2747] = 2,
    ACTIONS(1134), 7,
      anon_sym_COLON,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym__sym_qualified_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1132), 25,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [2784] = 2,
    ACTIONS(1138), 7,
      anon_sym_COLON,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym__sym_qualified_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1136), 25,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [2821] = 2,
    ACTIONS(1142), 7,
      anon_sym_COLON,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym__sym_qualified_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1140), 25,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [2858] = 2,
    ACTIONS(1146), 7,
      anon_sym_COLON,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym__sym_qualified_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1144), 25,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [2895] = 2,
    ACTIONS(1150), 7,
      anon_sym_COLON,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym__sym_qualified_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1148), 25,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [2932] = 2,
    ACTIONS(1154), 7,
      anon_sym_COLON,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym__sym_qualified_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1152), 25,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [2969] = 2,
    ACTIONS(1158), 7,
      anon_sym_COLON,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym__sym_qualified_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1156), 25,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [3006] = 2,
    ACTIONS(898), 7,
      anon_sym_COLON,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym__sym_qualified_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(896), 25,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [3043] = 2,
    ACTIONS(1162), 7,
      anon_sym_COLON,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym__sym_qualified_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1160), 25,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [3080] = 2,
    ACTIONS(1166), 7,
      anon_sym_COLON,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym__sym_qualified_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1164), 25,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [3117] = 2,
    ACTIONS(1170), 7,
      anon_sym_COLON,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym__sym_qualified_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1168), 25,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [3154] = 2,
    ACTIONS(1174), 7,
      anon_sym_COLON,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym__sym_qualified_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1172), 25,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [3191] = 2,
    ACTIONS(1178), 7,
      anon_sym_COLON,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym__sym_qualified_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1176), 25,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [3228] = 2,
    ACTIONS(1182), 7,
      anon_sym_COLON,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym__sym_qualified_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1180), 25,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [3265] = 5,
    ACTIONS(1187), 1,
      anon_sym_POUND_,
    ACTIONS(1184), 2,
      sym__ws,
      sym_comment,
    STATE(301), 3,
      sym__gap,
      sym_dis_expr,
      aux_sym_dis_expr_repeat1,
    ACTIONS(1192), 7,
      anon_sym_COLON,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym__sym_qualified_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1190), 18,
      sym_num_lit,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [3307] = 2,
    ACTIONS(1196), 7,
      anon_sym_COLON,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym__sym_qualified_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1194), 24,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      anon_sym_SLASH,
      anon_sym_COLON_COLON,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [3343] = 25,
    ACTIONS(21), 1,
      anon_sym_CARET,
    ACTIONS(23), 1,
      anon_sym_POUND_CARET,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(29), 1,
      anon_sym_LBRACK,
    ACTIONS(1198), 1,
      anon_sym_SLASH,
    ACTIONS(1200), 1,
      aux_sym__sym_qualified_token1,
    ACTIONS(1202), 1,
      anon_sym_POUND,
    ACTIONS(1204), 1,
      anon_sym_POUND_QMARK,
    ACTIONS(1206), 1,
      anon_sym_POUND_QMARK_AT,
    ACTIONS(1208), 1,
      anon_sym_POUND_SQUOTE,
    ACTIONS(1210), 1,
      anon_sym_POUND_EQ,
    ACTIONS(1212), 1,
      anon_sym_AT,
    ACTIONS(1214), 1,
      anon_sym_SQUOTE,
    ACTIONS(1216), 1,
      anon_sym_BQUOTE,
    ACTIONS(1218), 1,
      anon_sym_TILDE_AT,
    ACTIONS(1220), 1,
      anon_sym_TILDE,
    STATE(253), 1,
      sym__bare_list_lit,
    STATE(254), 1,
      sym__bare_map_lit,
    STATE(255), 1,
      sym__bare_vec_lit,
    STATE(256), 1,
      sym__bare_set_lit,
    STATE(313), 1,
      sym_old_meta_lit,
    STATE(314), 1,
      sym_meta_lit,
    STATE(324), 1,
      aux_sym_sym_lit_repeat1,
    STATE(424), 1,
      sym__metadata_lit,
  [3419] = 25,
    ACTIONS(21), 1,
      anon_sym_CARET,
    ACTIONS(23), 1,
      anon_sym_POUND_CARET,
    ACTIONS(280), 1,
      anon_sym_LPAREN,
    ACTIONS(282), 1,
      anon_sym_LBRACE,
    ACTIONS(284), 1,
      anon_sym_LBRACK,
    ACTIONS(1222), 1,
      anon_sym_SLASH,
    ACTIONS(1224), 1,
      aux_sym__sym_qualified_token1,
    ACTIONS(1226), 1,
      anon_sym_POUND,
    ACTIONS(1228), 1,
      anon_sym_POUND_QMARK,
    ACTIONS(1230), 1,
      anon_sym_POUND_QMARK_AT,
    ACTIONS(1232), 1,
      anon_sym_POUND_SQUOTE,
    ACTIONS(1234), 1,
      anon_sym_POUND_EQ,
    ACTIONS(1236), 1,
      anon_sym_AT,
    ACTIONS(1238), 1,
      anon_sym_SQUOTE,
    ACTIONS(1240), 1,
      anon_sym_BQUOTE,
    ACTIONS(1242), 1,
      anon_sym_TILDE_AT,
    ACTIONS(1244), 1,
      anon_sym_TILDE,
    STATE(313), 1,
      sym_old_meta_lit,
    STATE(314), 1,
      sym_meta_lit,
    STATE(324), 1,
      aux_sym_sym_lit_repeat1,
    STATE(377), 1,
      sym__bare_list_lit,
    STATE(380), 1,
      sym__bare_map_lit,
    STATE(381), 1,
      sym__bare_vec_lit,
    STATE(382), 1,
      sym__bare_set_lit,
    STATE(424), 1,
      sym__metadata_lit,
  [3495] = 25,
    ACTIONS(21), 1,
      anon_sym_CARET,
    ACTIONS(23), 1,
      anon_sym_POUND_CARET,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(29), 1,
      anon_sym_LBRACK,
    ACTIONS(1198), 1,
      anon_sym_SLASH,
    ACTIONS(1200), 1,
      aux_sym__sym_qualified_token1,
    ACTIONS(1204), 1,
      anon_sym_POUND_QMARK,
    ACTIONS(1206), 1,
      anon_sym_POUND_QMARK_AT,
    ACTIONS(1210), 1,
      anon_sym_POUND_EQ,
    ACTIONS(1246), 1,
      anon_sym_POUND,
    ACTIONS(1248), 1,
      anon_sym_POUND_SQUOTE,
    ACTIONS(1250), 1,
      anon_sym_AT,
    ACTIONS(1252), 1,
      anon_sym_SQUOTE,
    ACTIONS(1254), 1,
      anon_sym_BQUOTE,
    ACTIONS(1256), 1,
      anon_sym_TILDE_AT,
    ACTIONS(1258), 1,
      anon_sym_TILDE,
    STATE(253), 1,
      sym__bare_list_lit,
    STATE(254), 1,
      sym__bare_map_lit,
    STATE(255), 1,
      sym__bare_vec_lit,
    STATE(256), 1,
      sym__bare_set_lit,
    STATE(313), 1,
      sym_old_meta_lit,
    STATE(314), 1,
      sym_meta_lit,
    STATE(324), 1,
      aux_sym_sym_lit_repeat1,
    STATE(424), 1,
      sym__metadata_lit,
  [3571] = 25,
    ACTIONS(21), 1,
      anon_sym_CARET,
    ACTIONS(23), 1,
      anon_sym_POUND_CARET,
    ACTIONS(280), 1,
      anon_sym_LPAREN,
    ACTIONS(282), 1,
      anon_sym_LBRACE,
    ACTIONS(284), 1,
      anon_sym_LBRACK,
    ACTIONS(1222), 1,
      anon_sym_SLASH,
    ACTIONS(1224), 1,
      aux_sym__sym_qualified_token1,
    ACTIONS(1228), 1,
      anon_sym_POUND_QMARK,
    ACTIONS(1230), 1,
      anon_sym_POUND_QMARK_AT,
    ACTIONS(1234), 1,
      anon_sym_POUND_EQ,
    ACTIONS(1260), 1,
      anon_sym_POUND,
    ACTIONS(1262), 1,
      anon_sym_POUND_SQUOTE,
    ACTIONS(1264), 1,
      anon_sym_AT,
    ACTIONS(1266), 1,
      anon_sym_SQUOTE,
    ACTIONS(1268), 1,
      anon_sym_BQUOTE,
    ACTIONS(1270), 1,
      anon_sym_TILDE_AT,
    ACTIONS(1272), 1,
      anon_sym_TILDE,
    STATE(313), 1,
      sym_old_meta_lit,
    STATE(314), 1,
      sym_meta_lit,
    STATE(324), 1,
      aux_sym_sym_lit_repeat1,
    STATE(377), 1,
      sym__bare_list_lit,
    STATE(380), 1,
      sym__bare_map_lit,
    STATE(381), 1,
      sym__bare_vec_lit,
    STATE(382), 1,
      sym__bare_set_lit,
    STATE(424), 1,
      sym__metadata_lit,
  [3647] = 25,
    ACTIONS(21), 1,
      anon_sym_CARET,
    ACTIONS(23), 1,
      anon_sym_POUND_CARET,
    ACTIONS(280), 1,
      anon_sym_LPAREN,
    ACTIONS(282), 1,
      anon_sym_LBRACE,
    ACTIONS(284), 1,
      anon_sym_LBRACK,
    ACTIONS(1222), 1,
      anon_sym_SLASH,
    ACTIONS(1224), 1,
      aux_sym__sym_qualified_token1,
    ACTIONS(1228), 1,
      anon_sym_POUND_QMARK,
    ACTIONS(1230), 1,
      anon_sym_POUND_QMARK_AT,
    ACTIONS(1234), 1,
      anon_sym_POUND_EQ,
    ACTIONS(1274), 1,
      anon_sym_POUND,
    ACTIONS(1276), 1,
      anon_sym_POUND_SQUOTE,
    ACTIONS(1278), 1,
      anon_sym_AT,
    ACTIONS(1280), 1,
      anon_sym_SQUOTE,
    ACTIONS(1282), 1,
      anon_sym_BQUOTE,
    ACTIONS(1284), 1,
      anon_sym_TILDE_AT,
    ACTIONS(1286), 1,
      anon_sym_TILDE,
    STATE(313), 1,
      sym_old_meta_lit,
    STATE(314), 1,
      sym_meta_lit,
    STATE(324), 1,
      aux_sym_sym_lit_repeat1,
    STATE(377), 1,
      sym__bare_list_lit,
    STATE(380), 1,
      sym__bare_map_lit,
    STATE(381), 1,
      sym__bare_vec_lit,
    STATE(382), 1,
      sym__bare_set_lit,
    STATE(424), 1,
      sym__metadata_lit,
  [3723] = 19,
    ACTIONS(9), 1,
      anon_sym_SLASH,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(716), 1,
      anon_sym_COLON,
    ACTIONS(1290), 1,
      anon_sym_POUND_,
    ACTIONS(1292), 1,
      anon_sym_COLON_COLON,
    ACTIONS(1294), 1,
      aux_sym_str_lit_token1,
    ACTIONS(1296), 1,
      aux_sym__sym_qualified_token1,
    ACTIONS(1298), 1,
      anon_sym_CARET,
    ACTIONS(1300), 1,
      anon_sym_POUND_CARET,
    ACTIONS(1302), 1,
      anon_sym_LBRACE,
    STATE(160), 1,
      sym_sym_lit,
    STATE(236), 1,
      sym__bare_list_lit,
    STATE(424), 1,
      sym__metadata_lit,
    STATE(442), 1,
      sym_meta_lit,
    STATE(447), 1,
      sym_old_meta_lit,
    STATE(452), 1,
      aux_sym_sym_lit_repeat1,
    ACTIONS(1288), 2,
      sym__ws,
      sym_comment,
    STATE(454), 2,
      sym_kwd_lit,
      sym_auto_res_mark,
    STATE(428), 3,
      sym__gap,
      sym_dis_expr,
      aux_sym_dis_expr_repeat1,
  [3785] = 19,
    ACTIONS(9), 1,
      anon_sym_SLASH,
    ACTIONS(280), 1,
      anon_sym_LPAREN,
    ACTIONS(716), 1,
      anon_sym_COLON,
    ACTIONS(1290), 1,
      anon_sym_POUND_,
    ACTIONS(1292), 1,
      anon_sym_COLON_COLON,
    ACTIONS(1296), 1,
      aux_sym__sym_qualified_token1,
    ACTIONS(1298), 1,
      anon_sym_CARET,
    ACTIONS(1300), 1,
      anon_sym_POUND_CARET,
    ACTIONS(1306), 1,
      aux_sym_str_lit_token1,
    ACTIONS(1308), 1,
      anon_sym_LBRACE,
    STATE(208), 1,
      sym_sym_lit,
    STATE(342), 1,
      sym__bare_list_lit,
    STATE(424), 1,
      sym__metadata_lit,
    STATE(442), 1,
      sym_meta_lit,
    STATE(447), 1,
      sym_old_meta_lit,
    STATE(452), 1,
      aux_sym_sym_lit_repeat1,
    ACTIONS(1304), 2,
      sym__ws,
      sym_comment,
    STATE(461), 2,
      sym_kwd_lit,
      sym_auto_res_mark,
    STATE(429), 3,
      sym__gap,
      sym_dis_expr,
      aux_sym_dis_expr_repeat1,
  [3847] = 5,
    ACTIONS(1312), 1,
      anon_sym_POUND_,
    ACTIONS(1310), 2,
      sym__ws,
      sym_comment,
    ACTIONS(1316), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    STATE(317), 3,
      sym__gap,
      sym_dis_expr,
      aux_sym_dis_expr_repeat1,
    ACTIONS(1314), 14,
      anon_sym_SLASH,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [3881] = 5,
    ACTIONS(1312), 1,
      anon_sym_POUND_,
    ACTIONS(1310), 2,
      sym__ws,
      sym_comment,
    ACTIONS(1320), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    STATE(317), 3,
      sym__gap,
      sym_dis_expr,
      aux_sym_dis_expr_repeat1,
    ACTIONS(1318), 14,
      anon_sym_SLASH,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [3915] = 19,
    ACTIONS(9), 1,
      anon_sym_SLASH,
    ACTIONS(280), 1,
      anon_sym_LPAREN,
    ACTIONS(716), 1,
      anon_sym_COLON,
    ACTIONS(1290), 1,
      anon_sym_POUND_,
    ACTIONS(1292), 1,
      anon_sym_COLON_COLON,
    ACTIONS(1296), 1,
      aux_sym__sym_qualified_token1,
    ACTIONS(1298), 1,
      anon_sym_CARET,
    ACTIONS(1300), 1,
      anon_sym_POUND_CARET,
    ACTIONS(1306), 1,
      aux_sym_str_lit_token1,
    ACTIONS(1308), 1,
      anon_sym_LBRACE,
    STATE(107), 1,
      sym_sym_lit,
    STATE(342), 1,
      sym__bare_list_lit,
    STATE(424), 1,
      sym__metadata_lit,
    STATE(442), 1,
      sym_meta_lit,
    STATE(447), 1,
      sym_old_meta_lit,
    STATE(452), 1,
      aux_sym_sym_lit_repeat1,
    ACTIONS(1322), 2,
      sym__ws,
      sym_comment,
    STATE(461), 2,
      sym_kwd_lit,
      sym_auto_res_mark,
    STATE(431), 3,
      sym__gap,
      sym_dis_expr,
      aux_sym_dis_expr_repeat1,
  [3977] = 5,
    ACTIONS(1312), 1,
      anon_sym_POUND_,
    ACTIONS(1324), 2,
      sym__ws,
      sym_comment,
    ACTIONS(1328), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    STATE(310), 3,
      sym__gap,
      sym_dis_expr,
      aux_sym_dis_expr_repeat1,
    ACTIONS(1326), 14,
      anon_sym_SLASH,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [4011] = 5,
    ACTIONS(1312), 1,
      anon_sym_POUND_,
    ACTIONS(1330), 2,
      sym__ws,
      sym_comment,
    ACTIONS(1334), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    STATE(311), 3,
      sym__gap,
      sym_dis_expr,
      aux_sym_dis_expr_repeat1,
    ACTIONS(1332), 14,
      anon_sym_SLASH,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [4045] = 19,
    ACTIONS(9), 1,
      anon_sym_SLASH,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(716), 1,
      anon_sym_COLON,
    ACTIONS(1290), 1,
      anon_sym_POUND_,
    ACTIONS(1292), 1,
      anon_sym_COLON_COLON,
    ACTIONS(1294), 1,
      aux_sym_str_lit_token1,
    ACTIONS(1296), 1,
      aux_sym__sym_qualified_token1,
    ACTIONS(1298), 1,
      anon_sym_CARET,
    ACTIONS(1300), 1,
      anon_sym_POUND_CARET,
    ACTIONS(1302), 1,
      anon_sym_LBRACE,
    STATE(22), 1,
      sym_sym_lit,
    STATE(236), 1,
      sym__bare_list_lit,
    STATE(424), 1,
      sym__metadata_lit,
    STATE(442), 1,
      sym_meta_lit,
    STATE(447), 1,
      sym_old_meta_lit,
    STATE(452), 1,
      aux_sym_sym_lit_repeat1,
    ACTIONS(1336), 2,
      sym__ws,
      sym_comment,
    STATE(454), 2,
      sym_kwd_lit,
      sym_auto_res_mark,
    STATE(430), 3,
      sym__gap,
      sym_dis_expr,
      aux_sym_dis_expr_repeat1,
  [4107] = 19,
    ACTIONS(9), 1,
      anon_sym_SLASH,
    ACTIONS(280), 1,
      anon_sym_LPAREN,
    ACTIONS(716), 1,
      anon_sym_COLON,
    ACTIONS(1290), 1,
      anon_sym_POUND_,
    ACTIONS(1292), 1,
      anon_sym_COLON_COLON,
    ACTIONS(1296), 1,
      aux_sym__sym_qualified_token1,
    ACTIONS(1298), 1,
      anon_sym_CARET,
    ACTIONS(1300), 1,
      anon_sym_POUND_CARET,
    ACTIONS(1306), 1,
      aux_sym_str_lit_token1,
    ACTIONS(1308), 1,
      anon_sym_LBRACE,
    STATE(52), 1,
      sym_sym_lit,
    STATE(342), 1,
      sym__bare_list_lit,
    STATE(424), 1,
      sym__metadata_lit,
    STATE(442), 1,
      sym_meta_lit,
    STATE(447), 1,
      sym_old_meta_lit,
    STATE(452), 1,
      aux_sym_sym_lit_repeat1,
    ACTIONS(1338), 2,
      sym__ws,
      sym_comment,
    STATE(461), 2,
      sym_kwd_lit,
      sym_auto_res_mark,
    STATE(434), 3,
      sym__gap,
      sym_dis_expr,
      aux_sym_dis_expr_repeat1,
  [4169] = 5,
    ACTIONS(1343), 1,
      anon_sym_POUND_,
    ACTIONS(1340), 2,
      sym__ws,
      sym_comment,
    ACTIONS(1192), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    STATE(317), 3,
      sym__gap,
      sym_dis_expr,
      aux_sym_dis_expr_repeat1,
    ACTIONS(1190), 14,
      anon_sym_SLASH,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [4203] = 19,
    ACTIONS(9), 1,
      anon_sym_SLASH,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(716), 1,
      anon_sym_COLON,
    ACTIONS(1290), 1,
      anon_sym_POUND_,
    ACTIONS(1292), 1,
      anon_sym_COLON_COLON,
    ACTIONS(1296), 1,
      aux_sym__sym_qualified_token1,
    ACTIONS(1298), 1,
      anon_sym_CARET,
    ACTIONS(1300), 1,
      anon_sym_POUND_CARET,
    ACTIONS(1302), 1,
      anon_sym_LBRACE,
    STATE(129), 1,
      sym_sym_lit,
    STATE(279), 1,
      sym__bare_list_lit,
    STATE(424), 1,
      sym__metadata_lit,
    STATE(442), 1,
      sym_meta_lit,
    STATE(447), 1,
      sym_old_meta_lit,
    STATE(452), 1,
      aux_sym_sym_lit_repeat1,
    STATE(456), 1,
      sym_kwd_lit,
    STATE(463), 1,
      sym_auto_res_mark,
    ACTIONS(1346), 2,
      sym__ws,
      sym_comment,
    STATE(427), 3,
      sym__gap,
      sym_dis_expr,
      aux_sym_dis_expr_repeat1,
  [4264] = 19,
    ACTIONS(9), 1,
      anon_sym_SLASH,
    ACTIONS(280), 1,
      anon_sym_LPAREN,
    ACTIONS(716), 1,
      anon_sym_COLON,
    ACTIONS(1290), 1,
      anon_sym_POUND_,
    ACTIONS(1292), 1,
      anon_sym_COLON_COLON,
    ACTIONS(1296), 1,
      aux_sym__sym_qualified_token1,
    ACTIONS(1298), 1,
      anon_sym_CARET,
    ACTIONS(1300), 1,
      anon_sym_POUND_CARET,
    ACTIONS(1308), 1,
      anon_sym_LBRACE,
    STATE(197), 1,
      sym_sym_lit,
    STATE(408), 1,
      sym__bare_list_lit,
    STATE(424), 1,
      sym__metadata_lit,
    STATE(442), 1,
      sym_meta_lit,
    STATE(447), 1,
      sym_old_meta_lit,
    STATE(451), 1,
      sym_auto_res_mark,
    STATE(452), 1,
      aux_sym_sym_lit_repeat1,
    STATE(458), 1,
      sym_kwd_lit,
    ACTIONS(1348), 2,
      sym__ws,
      sym_comment,
    STATE(426), 3,
      sym__gap,
      sym_dis_expr,
      aux_sym_dis_expr_repeat1,
  [4325] = 19,
    ACTIONS(9), 1,
      anon_sym_SLASH,
    ACTIONS(280), 1,
      anon_sym_LPAREN,
    ACTIONS(716), 1,
      anon_sym_COLON,
    ACTIONS(1290), 1,
      anon_sym_POUND_,
    ACTIONS(1292), 1,
      anon_sym_COLON_COLON,
    ACTIONS(1296), 1,
      aux_sym__sym_qualified_token1,
    ACTIONS(1298), 1,
      anon_sym_CARET,
    ACTIONS(1300), 1,
      anon_sym_POUND_CARET,
    ACTIONS(1308), 1,
      anon_sym_LBRACE,
    STATE(32), 1,
      sym_sym_lit,
    STATE(408), 1,
      sym__bare_list_lit,
    STATE(424), 1,
      sym__metadata_lit,
    STATE(442), 1,
      sym_meta_lit,
    STATE(447), 1,
      sym_old_meta_lit,
    STATE(451), 1,
      sym_auto_res_mark,
    STATE(452), 1,
      aux_sym_sym_lit_repeat1,
    STATE(458), 1,
      sym_kwd_lit,
    ACTIONS(1350), 2,
      sym__ws,
      sym_comment,
    STATE(432), 3,
      sym__gap,
      sym_dis_expr,
      aux_sym_dis_expr_repeat1,
  [4386] = 19,
    ACTIONS(9), 1,
      anon_sym_SLASH,
    ACTIONS(280), 1,
      anon_sym_LPAREN,
    ACTIONS(716), 1,
      anon_sym_COLON,
    ACTIONS(1290), 1,
      anon_sym_POUND_,
    ACTIONS(1292), 1,
      anon_sym_COLON_COLON,
    ACTIONS(1296), 1,
      aux_sym__sym_qualified_token1,
    ACTIONS(1298), 1,
      anon_sym_CARET,
    ACTIONS(1300), 1,
      anon_sym_POUND_CARET,
    ACTIONS(1308), 1,
      anon_sym_LBRACE,
    STATE(84), 1,
      sym_sym_lit,
    STATE(408), 1,
      sym__bare_list_lit,
    STATE(424), 1,
      sym__metadata_lit,
    STATE(442), 1,
      sym_meta_lit,
    STATE(447), 1,
      sym_old_meta_lit,
    STATE(451), 1,
      sym_auto_res_mark,
    STATE(452), 1,
      aux_sym_sym_lit_repeat1,
    STATE(458), 1,
      sym_kwd_lit,
    ACTIONS(1352), 2,
      sym__ws,
      sym_comment,
    STATE(433), 3,
      sym__gap,
      sym_dis_expr,
      aux_sym_dis_expr_repeat1,
  [4447] = 19,
    ACTIONS(9), 1,
      anon_sym_SLASH,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(716), 1,
      anon_sym_COLON,
    ACTIONS(1290), 1,
      anon_sym_POUND_,
    ACTIONS(1292), 1,
      anon_sym_COLON_COLON,
    ACTIONS(1296), 1,
      aux_sym__sym_qualified_token1,
    ACTIONS(1298), 1,
      anon_sym_CARET,
    ACTIONS(1300), 1,
      anon_sym_POUND_CARET,
    ACTIONS(1302), 1,
      anon_sym_LBRACE,
    STATE(136), 1,
      sym_sym_lit,
    STATE(279), 1,
      sym__bare_list_lit,
    STATE(424), 1,
      sym__metadata_lit,
    STATE(442), 1,
      sym_meta_lit,
    STATE(447), 1,
      sym_old_meta_lit,
    STATE(452), 1,
      aux_sym_sym_lit_repeat1,
    STATE(456), 1,
      sym_kwd_lit,
    STATE(463), 1,
      sym_auto_res_mark,
    ACTIONS(1354), 2,
      sym__ws,
      sym_comment,
    STATE(425), 3,
      sym__gap,
      sym_dis_expr,
      aux_sym_dis_expr_repeat1,
  [4508] = 3,
    ACTIONS(1356), 1,
      aux_sym__kwd_leading_slash_token1,
    ACTIONS(862), 9,
      anon_sym_POUND_,
      anon_sym_SLASH,
      aux_sym__sym_qualified_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_SQUOTE,
      anon_sym_TILDE,
    ACTIONS(860), 11,
      sym__ws,
      sym_comment,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_AT,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [4536] = 8,
    ACTIONS(1360), 1,
      anon_sym_CARET,
    ACTIONS(1363), 1,
      anon_sym_POUND_CARET,
    STATE(313), 1,
      sym_old_meta_lit,
    STATE(314), 1,
      sym_meta_lit,
    STATE(324), 1,
      aux_sym_sym_lit_repeat1,
    STATE(424), 1,
      sym__metadata_lit,
    ACTIONS(1366), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1358), 12,
      anon_sym_SLASH,
      aux_sym__sym_qualified_token1,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [4574] = 2,
    ACTIONS(1118), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1116), 17,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      anon_sym_SLASH,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [4599] = 2,
    ACTIONS(1130), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1128), 17,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      anon_sym_SLASH,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [4624] = 2,
    ACTIONS(1062), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1060), 17,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      anon_sym_SLASH,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [4649] = 2,
    ACTIONS(898), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(896), 17,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      anon_sym_SLASH,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [4674] = 2,
    ACTIONS(914), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(912), 17,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      anon_sym_SLASH,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [4699] = 2,
    ACTIONS(898), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(896), 17,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      anon_sym_SLASH,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [4724] = 2,
    ACTIONS(1154), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1152), 17,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      anon_sym_SLASH,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [4749] = 2,
    ACTIONS(1138), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1136), 17,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      anon_sym_SLASH,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [4774] = 2,
    ACTIONS(930), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(928), 17,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      anon_sym_SLASH,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [4799] = 2,
    ACTIONS(1000), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(998), 17,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      anon_sym_SLASH,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [4824] = 2,
    ACTIONS(1004), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1002), 17,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      anon_sym_SLASH,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [4849] = 3,
    ACTIONS(1368), 1,
      anon_sym_SLASH,
    ACTIONS(862), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(860), 16,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [4876] = 2,
    ACTIONS(936), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(934), 17,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      anon_sym_SLASH,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [4901] = 2,
    ACTIONS(940), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(938), 17,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      anon_sym_SLASH,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [4926] = 2,
    ACTIONS(944), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(942), 17,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      anon_sym_SLASH,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [4951] = 15,
    ACTIONS(9), 1,
      anon_sym_SLASH,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(1296), 1,
      aux_sym__sym_qualified_token1,
    ACTIONS(1372), 1,
      anon_sym_POUND_,
    ACTIONS(1374), 1,
      anon_sym_CARET,
    ACTIONS(1376), 1,
      anon_sym_POUND_CARET,
    ACTIONS(1378), 1,
      anon_sym_POUND_QMARK,
    STATE(218), 1,
      sym__bare_list_lit,
    STATE(424), 1,
      sym__metadata_lit,
    STATE(437), 1,
      sym_old_meta_lit,
    STATE(438), 1,
      sym_meta_lit,
    STATE(441), 1,
      aux_sym_sym_lit_repeat1,
    ACTIONS(1370), 2,
      sym__ws,
      sym_comment,
    STATE(241), 3,
      sym_sym_lit,
      sym_list_lit,
      sym_read_cond_lit,
    STATE(383), 3,
      sym__gap,
      sym_dis_expr,
      aux_sym_dis_expr_repeat1,
  [5002] = 2,
    ACTIONS(948), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(946), 17,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      anon_sym_SLASH,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [5027] = 2,
    ACTIONS(952), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(950), 17,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      anon_sym_SLASH,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [5052] = 2,
    ACTIONS(956), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(954), 17,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      anon_sym_SLASH,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [5077] = 2,
    ACTIONS(960), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(958), 17,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      anon_sym_SLASH,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [5102] = 2,
    ACTIONS(964), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(962), 17,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      anon_sym_SLASH,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [5127] = 2,
    ACTIONS(1158), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1156), 17,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      anon_sym_SLASH,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [5152] = 2,
    ACTIONS(968), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(966), 17,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      anon_sym_SLASH,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [5177] = 2,
    ACTIONS(926), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(924), 17,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      anon_sym_SLASH,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [5202] = 2,
    ACTIONS(926), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(924), 17,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      anon_sym_SLASH,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [5227] = 2,
    ACTIONS(910), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(908), 17,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      anon_sym_SLASH,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [5252] = 2,
    ACTIONS(906), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(904), 17,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      anon_sym_SLASH,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [5277] = 2,
    ACTIONS(894), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(892), 17,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      anon_sym_SLASH,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [5302] = 2,
    ACTIONS(972), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(970), 17,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      anon_sym_SLASH,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [5327] = 15,
    ACTIONS(268), 1,
      anon_sym_SLASH,
    ACTIONS(280), 1,
      anon_sym_LPAREN,
    ACTIONS(1372), 1,
      anon_sym_POUND_,
    ACTIONS(1374), 1,
      anon_sym_CARET,
    ACTIONS(1376), 1,
      anon_sym_POUND_CARET,
    ACTIONS(1382), 1,
      aux_sym__sym_qualified_token1,
    ACTIONS(1384), 1,
      anon_sym_POUND_QMARK,
    STATE(392), 1,
      sym__bare_list_lit,
    STATE(424), 1,
      sym__metadata_lit,
    STATE(437), 1,
      sym_old_meta_lit,
    STATE(438), 1,
      sym_meta_lit,
    STATE(440), 1,
      aux_sym_sym_lit_repeat1,
    ACTIONS(1380), 2,
      sym__ws,
      sym_comment,
    STATE(418), 3,
      sym_sym_lit,
      sym_list_lit,
      sym_read_cond_lit,
    STATE(439), 3,
      sym__gap,
      sym_dis_expr,
      aux_sym_dis_expr_repeat1,
  [5378] = 2,
    ACTIONS(980), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(978), 17,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      anon_sym_SLASH,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [5403] = 2,
    ACTIONS(1034), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1032), 17,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      anon_sym_SLASH,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [5428] = 2,
    ACTIONS(902), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(900), 17,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      anon_sym_SLASH,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [5453] = 2,
    ACTIONS(1034), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1032), 17,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      anon_sym_SLASH,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [5478] = 2,
    ACTIONS(1178), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1176), 17,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      anon_sym_SLASH,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [5503] = 17,
    ACTIONS(9), 1,
      anon_sym_SLASH,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(1296), 1,
      aux_sym__sym_qualified_token1,
    ACTIONS(1372), 1,
      anon_sym_POUND_,
    ACTIONS(1374), 1,
      anon_sym_CARET,
    ACTIONS(1376), 1,
      anon_sym_POUND_CARET,
    ACTIONS(1378), 1,
      anon_sym_POUND_QMARK,
    STATE(218), 1,
      sym__bare_list_lit,
    STATE(228), 1,
      sym_sym_lit,
    STATE(232), 1,
      sym_list_lit,
    STATE(242), 1,
      sym_read_cond_lit,
    STATE(424), 1,
      sym__metadata_lit,
    STATE(437), 1,
      sym_old_meta_lit,
    STATE(438), 1,
      sym_meta_lit,
    STATE(441), 1,
      aux_sym_sym_lit_repeat1,
    ACTIONS(1380), 2,
      sym__ws,
      sym_comment,
    STATE(439), 3,
      sym__gap,
      sym_dis_expr,
      aux_sym_dis_expr_repeat1,
  [5558] = 2,
    ACTIONS(1388), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1386), 17,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      anon_sym_SLASH,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [5583] = 2,
    ACTIONS(1174), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1172), 17,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      anon_sym_SLASH,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [5608] = 2,
    ACTIONS(1392), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1390), 17,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      anon_sym_SLASH,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [5633] = 2,
    ACTIONS(1170), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1168), 17,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      anon_sym_SLASH,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [5658] = 2,
    ACTIONS(1166), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1164), 17,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      anon_sym_SLASH,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [5683] = 2,
    ACTIONS(984), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(982), 17,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      anon_sym_SLASH,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [5708] = 2,
    ACTIONS(988), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(986), 17,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      anon_sym_SLASH,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [5733] = 2,
    ACTIONS(1162), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1160), 17,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      anon_sym_SLASH,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [5758] = 2,
    ACTIONS(1110), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1108), 17,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      anon_sym_SLASH,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [5783] = 2,
    ACTIONS(992), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(990), 17,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      anon_sym_SLASH,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [5808] = 2,
    ACTIONS(996), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(994), 17,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      anon_sym_SLASH,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [5833] = 2,
    ACTIONS(1008), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1006), 17,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      anon_sym_SLASH,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [5858] = 3,
    ACTIONS(1394), 1,
      anon_sym_SLASH,
    ACTIONS(1008), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1006), 16,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [5885] = 2,
    ACTIONS(922), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(920), 17,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      anon_sym_SLASH,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [5910] = 17,
    ACTIONS(268), 1,
      anon_sym_SLASH,
    ACTIONS(280), 1,
      anon_sym_LPAREN,
    ACTIONS(1372), 1,
      anon_sym_POUND_,
    ACTIONS(1374), 1,
      anon_sym_CARET,
    ACTIONS(1376), 1,
      anon_sym_POUND_CARET,
    ACTIONS(1382), 1,
      aux_sym__sym_qualified_token1,
    ACTIONS(1384), 1,
      anon_sym_POUND_QMARK,
    STATE(326), 1,
      sym_read_cond_lit,
    STATE(392), 1,
      sym__bare_list_lit,
    STATE(400), 1,
      sym_list_lit,
    STATE(402), 1,
      sym_sym_lit,
    STATE(424), 1,
      sym__metadata_lit,
    STATE(437), 1,
      sym_old_meta_lit,
    STATE(438), 1,
      sym_meta_lit,
    STATE(440), 1,
      aux_sym_sym_lit_repeat1,
    ACTIONS(1396), 2,
      sym__ws,
      sym_comment,
    STATE(394), 3,
      sym__gap,
      sym_dis_expr,
      aux_sym_dis_expr_repeat1,
  [5965] = 2,
    ACTIONS(882), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(878), 17,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      anon_sym_SLASH,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [5990] = 2,
    ACTIONS(1014), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1012), 17,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      anon_sym_SLASH,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [6015] = 2,
    ACTIONS(1054), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1052), 17,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      anon_sym_SLASH,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [6040] = 2,
    ACTIONS(876), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(874), 17,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      anon_sym_SLASH,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [6065] = 2,
    ACTIONS(1018), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1016), 17,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      anon_sym_SLASH,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [6090] = 2,
    ACTIONS(1022), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1020), 17,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      anon_sym_SLASH,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [6115] = 2,
    ACTIONS(1026), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1024), 17,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      anon_sym_SLASH,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [6140] = 15,
    ACTIONS(9), 1,
      anon_sym_SLASH,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(1296), 1,
      aux_sym__sym_qualified_token1,
    ACTIONS(1372), 1,
      anon_sym_POUND_,
    ACTIONS(1374), 1,
      anon_sym_CARET,
    ACTIONS(1376), 1,
      anon_sym_POUND_CARET,
    ACTIONS(1378), 1,
      anon_sym_POUND_QMARK,
    STATE(218), 1,
      sym__bare_list_lit,
    STATE(424), 1,
      sym__metadata_lit,
    STATE(437), 1,
      sym_old_meta_lit,
    STATE(438), 1,
      sym_meta_lit,
    STATE(441), 1,
      aux_sym_sym_lit_repeat1,
    ACTIONS(1380), 2,
      sym__ws,
      sym_comment,
    STATE(272), 3,
      sym_sym_lit,
      sym_list_lit,
      sym_read_cond_lit,
    STATE(439), 3,
      sym__gap,
      sym_dis_expr,
      aux_sym_dis_expr_repeat1,
  [6191] = 2,
    ACTIONS(1150), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1148), 17,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      anon_sym_SLASH,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [6216] = 2,
    ACTIONS(1094), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1092), 17,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      anon_sym_SLASH,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [6241] = 2,
    ACTIONS(1030), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1028), 17,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      anon_sym_SLASH,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [6266] = 2,
    ACTIONS(1038), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1036), 17,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      anon_sym_SLASH,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [6291] = 3,
    ACTIONS(1398), 1,
      anon_sym_SLASH,
    ACTIONS(882), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(878), 16,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [6318] = 2,
    ACTIONS(1402), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1400), 17,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      anon_sym_SLASH,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [6343] = 15,
    ACTIONS(268), 1,
      anon_sym_SLASH,
    ACTIONS(280), 1,
      anon_sym_LPAREN,
    ACTIONS(1372), 1,
      anon_sym_POUND_,
    ACTIONS(1374), 1,
      anon_sym_CARET,
    ACTIONS(1376), 1,
      anon_sym_POUND_CARET,
    ACTIONS(1382), 1,
      aux_sym__sym_qualified_token1,
    ACTIONS(1384), 1,
      anon_sym_POUND_QMARK,
    STATE(392), 1,
      sym__bare_list_lit,
    STATE(424), 1,
      sym__metadata_lit,
    STATE(437), 1,
      sym_old_meta_lit,
    STATE(438), 1,
      sym_meta_lit,
    STATE(440), 1,
      aux_sym_sym_lit_repeat1,
    ACTIONS(1404), 2,
      sym__ws,
      sym_comment,
    STATE(353), 3,
      sym_sym_lit,
      sym_list_lit,
      sym_read_cond_lit,
    STATE(354), 3,
      sym__gap,
      sym_dis_expr,
      aux_sym_dis_expr_repeat1,
  [6394] = 2,
    ACTIONS(1142), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1140), 17,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      anon_sym_SLASH,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [6419] = 2,
    ACTIONS(886), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(884), 17,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      anon_sym_SLASH,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [6444] = 2,
    ACTIONS(1134), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1132), 17,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      anon_sym_SLASH,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [6469] = 17,
    ACTIONS(268), 1,
      anon_sym_SLASH,
    ACTIONS(280), 1,
      anon_sym_LPAREN,
    ACTIONS(1372), 1,
      anon_sym_POUND_,
    ACTIONS(1374), 1,
      anon_sym_CARET,
    ACTIONS(1376), 1,
      anon_sym_POUND_CARET,
    ACTIONS(1382), 1,
      aux_sym__sym_qualified_token1,
    ACTIONS(1384), 1,
      anon_sym_POUND_QMARK,
    STATE(348), 1,
      sym_list_lit,
    STATE(349), 1,
      sym_sym_lit,
    STATE(392), 1,
      sym__bare_list_lit,
    STATE(407), 1,
      sym_read_cond_lit,
    STATE(424), 1,
      sym__metadata_lit,
    STATE(437), 1,
      sym_old_meta_lit,
    STATE(438), 1,
      sym_meta_lit,
    STATE(440), 1,
      aux_sym_sym_lit_repeat1,
    ACTIONS(1380), 2,
      sym__ws,
      sym_comment,
    STATE(439), 3,
      sym__gap,
      sym_dis_expr,
      aux_sym_dis_expr_repeat1,
  [6524] = 2,
    ACTIONS(1042), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1040), 17,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      anon_sym_SLASH,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [6549] = 2,
    ACTIONS(1046), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1044), 17,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      anon_sym_SLASH,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [6574] = 2,
    ACTIONS(1050), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1048), 17,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      anon_sym_SLASH,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [6599] = 2,
    ACTIONS(1058), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1056), 17,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      anon_sym_SLASH,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [6624] = 2,
    ACTIONS(1408), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1406), 17,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      anon_sym_SLASH,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [6649] = 2,
    ACTIONS(1130), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1128), 17,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      anon_sym_SLASH,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [6674] = 2,
    ACTIONS(872), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(870), 17,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      anon_sym_SLASH,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [6699] = 2,
    ACTIONS(1130), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1128), 17,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      anon_sym_SLASH,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [6724] = 2,
    ACTIONS(890), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(888), 17,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      anon_sym_SLASH,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [6749] = 2,
    ACTIONS(1066), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1064), 17,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      anon_sym_SLASH,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [6774] = 2,
    ACTIONS(1126), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1124), 17,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      anon_sym_SLASH,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [6799] = 2,
    ACTIONS(1122), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1120), 17,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      anon_sym_SLASH,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [6824] = 2,
    ACTIONS(926), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(924), 17,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      anon_sym_SLASH,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [6849] = 2,
    ACTIONS(1114), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1112), 17,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      anon_sym_SLASH,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [6874] = 2,
    ACTIONS(1070), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1068), 17,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      anon_sym_SLASH,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [6899] = 2,
    ACTIONS(1146), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1144), 17,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      anon_sym_SLASH,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [6924] = 2,
    ACTIONS(1182), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1180), 17,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      anon_sym_SLASH,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [6949] = 2,
    ACTIONS(1106), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1104), 17,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      anon_sym_SLASH,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [6974] = 2,
    ACTIONS(1074), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1072), 17,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      anon_sym_SLASH,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [6999] = 2,
    ACTIONS(868), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(866), 17,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      anon_sym_SLASH,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [7024] = 2,
    ACTIONS(1102), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1100), 17,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      anon_sym_SLASH,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [7049] = 2,
    ACTIONS(1098), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1096), 17,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      anon_sym_SLASH,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [7074] = 2,
    ACTIONS(976), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(974), 17,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      anon_sym_SLASH,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [7099] = 2,
    ACTIONS(1090), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1088), 17,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      anon_sym_SLASH,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [7124] = 2,
    ACTIONS(1086), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1084), 17,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      anon_sym_SLASH,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [7149] = 2,
    ACTIONS(1082), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1080), 17,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      anon_sym_SLASH,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [7174] = 2,
    ACTIONS(1078), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1076), 17,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      anon_sym_SLASH,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [7199] = 17,
    ACTIONS(9), 1,
      anon_sym_SLASH,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(1296), 1,
      aux_sym__sym_qualified_token1,
    ACTIONS(1372), 1,
      anon_sym_POUND_,
    ACTIONS(1374), 1,
      anon_sym_CARET,
    ACTIONS(1376), 1,
      anon_sym_POUND_CARET,
    ACTIONS(1378), 1,
      anon_sym_POUND_QMARK,
    STATE(218), 1,
      sym__bare_list_lit,
    STATE(284), 1,
      sym_sym_lit,
    STATE(285), 1,
      sym_list_lit,
    STATE(286), 1,
      sym_read_cond_lit,
    STATE(424), 1,
      sym__metadata_lit,
    STATE(437), 1,
      sym_old_meta_lit,
    STATE(438), 1,
      sym_meta_lit,
    STATE(441), 1,
      aux_sym_sym_lit_repeat1,
    ACTIONS(1410), 2,
      sym__ws,
      sym_comment,
    STATE(360), 3,
      sym__gap,
      sym_dis_expr,
      aux_sym_dis_expr_repeat1,
  [7254] = 2,
    ACTIONS(918), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(916), 17,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      anon_sym_SLASH,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [7279] = 2,
    ACTIONS(1414), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1412), 14,
      anon_sym_SLASH,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [7301] = 12,
    ACTIONS(9), 1,
      anon_sym_SLASH,
    ACTIONS(1290), 1,
      anon_sym_POUND_,
    ACTIONS(1296), 1,
      aux_sym__sym_qualified_token1,
    ACTIONS(1298), 1,
      anon_sym_CARET,
    ACTIONS(1300), 1,
      anon_sym_POUND_CARET,
    STATE(126), 1,
      sym_sym_lit,
    STATE(424), 1,
      sym__metadata_lit,
    STATE(442), 1,
      sym_meta_lit,
    STATE(447), 1,
      sym_old_meta_lit,
    STATE(452), 1,
      aux_sym_sym_lit_repeat1,
    ACTIONS(1416), 2,
      sym__ws,
      sym_comment,
    STATE(446), 3,
      sym__gap,
      sym_dis_expr,
      aux_sym_dis_expr_repeat1,
  [7341] = 12,
    ACTIONS(9), 1,
      anon_sym_SLASH,
    ACTIONS(1290), 1,
      anon_sym_POUND_,
    ACTIONS(1296), 1,
      aux_sym__sym_qualified_token1,
    ACTIONS(1298), 1,
      anon_sym_CARET,
    ACTIONS(1300), 1,
      anon_sym_POUND_CARET,
    STATE(180), 1,
      sym_sym_lit,
    STATE(424), 1,
      sym__metadata_lit,
    STATE(442), 1,
      sym_meta_lit,
    STATE(447), 1,
      sym_old_meta_lit,
    STATE(452), 1,
      aux_sym_sym_lit_repeat1,
    ACTIONS(1416), 2,
      sym__ws,
      sym_comment,
    STATE(446), 3,
      sym__gap,
      sym_dis_expr,
      aux_sym_dis_expr_repeat1,
  [7381] = 12,
    ACTIONS(9), 1,
      anon_sym_SLASH,
    ACTIONS(1290), 1,
      anon_sym_POUND_,
    ACTIONS(1296), 1,
      aux_sym__sym_qualified_token1,
    ACTIONS(1298), 1,
      anon_sym_CARET,
    ACTIONS(1300), 1,
      anon_sym_POUND_CARET,
    STATE(166), 1,
      sym_sym_lit,
    STATE(424), 1,
      sym__metadata_lit,
    STATE(442), 1,
      sym_meta_lit,
    STATE(447), 1,
      sym_old_meta_lit,
    STATE(452), 1,
      aux_sym_sym_lit_repeat1,
    ACTIONS(1416), 2,
      sym__ws,
      sym_comment,
    STATE(446), 3,
      sym__gap,
      sym_dis_expr,
      aux_sym_dis_expr_repeat1,
  [7421] = 12,
    ACTIONS(9), 1,
      anon_sym_SLASH,
    ACTIONS(1290), 1,
      anon_sym_POUND_,
    ACTIONS(1296), 1,
      aux_sym__sym_qualified_token1,
    ACTIONS(1298), 1,
      anon_sym_CARET,
    ACTIONS(1300), 1,
      anon_sym_POUND_CARET,
    STATE(137), 1,
      sym_sym_lit,
    STATE(424), 1,
      sym__metadata_lit,
    STATE(442), 1,
      sym_meta_lit,
    STATE(447), 1,
      sym_old_meta_lit,
    STATE(452), 1,
      aux_sym_sym_lit_repeat1,
    ACTIONS(1416), 2,
      sym__ws,
      sym_comment,
    STATE(446), 3,
      sym__gap,
      sym_dis_expr,
      aux_sym_dis_expr_repeat1,
  [7461] = 12,
    ACTIONS(9), 1,
      anon_sym_SLASH,
    ACTIONS(1290), 1,
      anon_sym_POUND_,
    ACTIONS(1296), 1,
      aux_sym__sym_qualified_token1,
    ACTIONS(1298), 1,
      anon_sym_CARET,
    ACTIONS(1300), 1,
      anon_sym_POUND_CARET,
    STATE(202), 1,
      sym_sym_lit,
    STATE(424), 1,
      sym__metadata_lit,
    STATE(442), 1,
      sym_meta_lit,
    STATE(447), 1,
      sym_old_meta_lit,
    STATE(452), 1,
      aux_sym_sym_lit_repeat1,
    ACTIONS(1416), 2,
      sym__ws,
      sym_comment,
    STATE(446), 3,
      sym__gap,
      sym_dis_expr,
      aux_sym_dis_expr_repeat1,
  [7501] = 12,
    ACTIONS(9), 1,
      anon_sym_SLASH,
    ACTIONS(1290), 1,
      anon_sym_POUND_,
    ACTIONS(1296), 1,
      aux_sym__sym_qualified_token1,
    ACTIONS(1298), 1,
      anon_sym_CARET,
    ACTIONS(1300), 1,
      anon_sym_POUND_CARET,
    STATE(115), 1,
      sym_sym_lit,
    STATE(424), 1,
      sym__metadata_lit,
    STATE(442), 1,
      sym_meta_lit,
    STATE(447), 1,
      sym_old_meta_lit,
    STATE(452), 1,
      aux_sym_sym_lit_repeat1,
    ACTIONS(1416), 2,
      sym__ws,
      sym_comment,
    STATE(446), 3,
      sym__gap,
      sym_dis_expr,
      aux_sym_dis_expr_repeat1,
  [7541] = 12,
    ACTIONS(9), 1,
      anon_sym_SLASH,
    ACTIONS(1290), 1,
      anon_sym_POUND_,
    ACTIONS(1296), 1,
      aux_sym__sym_qualified_token1,
    ACTIONS(1298), 1,
      anon_sym_CARET,
    ACTIONS(1300), 1,
      anon_sym_POUND_CARET,
    STATE(85), 1,
      sym_sym_lit,
    STATE(424), 1,
      sym__metadata_lit,
    STATE(442), 1,
      sym_meta_lit,
    STATE(447), 1,
      sym_old_meta_lit,
    STATE(452), 1,
      aux_sym_sym_lit_repeat1,
    ACTIONS(1416), 2,
      sym__ws,
      sym_comment,
    STATE(446), 3,
      sym__gap,
      sym_dis_expr,
      aux_sym_dis_expr_repeat1,
  [7581] = 12,
    ACTIONS(9), 1,
      anon_sym_SLASH,
    ACTIONS(1290), 1,
      anon_sym_POUND_,
    ACTIONS(1296), 1,
      aux_sym__sym_qualified_token1,
    ACTIONS(1298), 1,
      anon_sym_CARET,
    ACTIONS(1300), 1,
      anon_sym_POUND_CARET,
    STATE(175), 1,
      sym_sym_lit,
    STATE(424), 1,
      sym__metadata_lit,
    STATE(442), 1,
      sym_meta_lit,
    STATE(447), 1,
      sym_old_meta_lit,
    STATE(452), 1,
      aux_sym_sym_lit_repeat1,
    ACTIONS(1416), 2,
      sym__ws,
      sym_comment,
    STATE(446), 3,
      sym__gap,
      sym_dis_expr,
      aux_sym_dis_expr_repeat1,
  [7621] = 12,
    ACTIONS(9), 1,
      anon_sym_SLASH,
    ACTIONS(1290), 1,
      anon_sym_POUND_,
    ACTIONS(1296), 1,
      aux_sym__sym_qualified_token1,
    ACTIONS(1298), 1,
      anon_sym_CARET,
    ACTIONS(1300), 1,
      anon_sym_POUND_CARET,
    STATE(71), 1,
      sym_sym_lit,
    STATE(424), 1,
      sym__metadata_lit,
    STATE(442), 1,
      sym_meta_lit,
    STATE(447), 1,
      sym_old_meta_lit,
    STATE(452), 1,
      aux_sym_sym_lit_repeat1,
    ACTIONS(1416), 2,
      sym__ws,
      sym_comment,
    STATE(446), 3,
      sym__gap,
      sym_dis_expr,
      aux_sym_dis_expr_repeat1,
  [7661] = 12,
    ACTIONS(9), 1,
      anon_sym_SLASH,
    ACTIONS(1290), 1,
      anon_sym_POUND_,
    ACTIONS(1296), 1,
      aux_sym__sym_qualified_token1,
    ACTIONS(1298), 1,
      anon_sym_CARET,
    ACTIONS(1300), 1,
      anon_sym_POUND_CARET,
    STATE(33), 1,
      sym_sym_lit,
    STATE(424), 1,
      sym__metadata_lit,
    STATE(442), 1,
      sym_meta_lit,
    STATE(447), 1,
      sym_old_meta_lit,
    STATE(452), 1,
      aux_sym_sym_lit_repeat1,
    ACTIONS(1416), 2,
      sym__ws,
      sym_comment,
    STATE(446), 3,
      sym__gap,
      sym_dis_expr,
      aux_sym_dis_expr_repeat1,
  [7701] = 4,
    ACTIONS(1372), 1,
      anon_sym_POUND_,
    ACTIONS(1380), 2,
      sym__ws,
      sym_comment,
    STATE(439), 3,
      sym__gap,
      sym_dis_expr,
      aux_sym_dis_expr_repeat1,
    ACTIONS(1314), 6,
      anon_sym_SLASH,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_POUND_QMARK,
  [7722] = 4,
    ACTIONS(1372), 1,
      anon_sym_POUND_,
    ACTIONS(1380), 2,
      sym__ws,
      sym_comment,
    STATE(439), 3,
      sym__gap,
      sym_dis_expr,
      aux_sym_dis_expr_repeat1,
    ACTIONS(1318), 6,
      anon_sym_SLASH,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_POUND_QMARK,
  [7743] = 4,
    ACTIONS(1372), 1,
      anon_sym_POUND_,
    ACTIONS(1418), 2,
      sym__ws,
      sym_comment,
    STATE(435), 3,
      sym__gap,
      sym_dis_expr,
      aux_sym_dis_expr_repeat1,
    ACTIONS(1326), 6,
      anon_sym_SLASH,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_POUND_QMARK,
  [7764] = 4,
    ACTIONS(1372), 1,
      anon_sym_POUND_,
    ACTIONS(1420), 2,
      sym__ws,
      sym_comment,
    STATE(436), 3,
      sym__gap,
      sym_dis_expr,
      aux_sym_dis_expr_repeat1,
    ACTIONS(1332), 6,
      anon_sym_SLASH,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_POUND_QMARK,
  [7785] = 4,
    ACTIONS(1425), 1,
      anon_sym_POUND_,
    ACTIONS(1422), 2,
      sym__ws,
      sym_comment,
    STATE(439), 3,
      sym__gap,
      sym_dis_expr,
      aux_sym_dis_expr_repeat1,
    ACTIONS(1190), 6,
      anon_sym_SLASH,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_POUND_QMARK,
  [7806] = 11,
    ACTIONS(280), 1,
      anon_sym_LPAREN,
    ACTIONS(1222), 1,
      anon_sym_SLASH,
    ACTIONS(1224), 1,
      aux_sym__sym_qualified_token1,
    ACTIONS(1374), 1,
      anon_sym_CARET,
    ACTIONS(1376), 1,
      anon_sym_POUND_CARET,
    ACTIONS(1428), 1,
      anon_sym_POUND_QMARK,
    STATE(377), 1,
      sym__bare_list_lit,
    STATE(424), 1,
      sym__metadata_lit,
    STATE(437), 1,
      sym_old_meta_lit,
    STATE(438), 1,
      sym_meta_lit,
    STATE(444), 1,
      aux_sym_sym_lit_repeat1,
  [7840] = 11,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(1198), 1,
      anon_sym_SLASH,
    ACTIONS(1200), 1,
      aux_sym__sym_qualified_token1,
    ACTIONS(1374), 1,
      anon_sym_CARET,
    ACTIONS(1376), 1,
      anon_sym_POUND_CARET,
    ACTIONS(1430), 1,
      anon_sym_POUND_QMARK,
    STATE(253), 1,
      sym__bare_list_lit,
    STATE(424), 1,
      sym__metadata_lit,
    STATE(437), 1,
      sym_old_meta_lit,
    STATE(438), 1,
      sym_meta_lit,
    STATE(444), 1,
      aux_sym_sym_lit_repeat1,
  [7874] = 4,
    ACTIONS(1290), 1,
      anon_sym_POUND_,
    ACTIONS(1432), 2,
      sym__ws,
      sym_comment,
    STATE(448), 3,
      sym__gap,
      sym_dis_expr,
      aux_sym_dis_expr_repeat1,
    ACTIONS(1332), 4,
      anon_sym_SLASH,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
  [7893] = 3,
    ACTIONS(1356), 1,
      aux_sym__kwd_leading_slash_token1,
    ACTIONS(862), 4,
      anon_sym_POUND_,
      anon_sym_SLASH,
      aux_sym__sym_qualified_token1,
      anon_sym_POUND_QMARK,
    ACTIONS(860), 5,
      sym__ws,
      sym_comment,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
  [7910] = 7,
    ACTIONS(1434), 1,
      anon_sym_CARET,
    ACTIONS(1437), 1,
      anon_sym_POUND_CARET,
    STATE(424), 1,
      sym__metadata_lit,
    STATE(437), 1,
      sym_old_meta_lit,
    STATE(438), 1,
      sym_meta_lit,
    STATE(444), 1,
      aux_sym_sym_lit_repeat1,
    ACTIONS(1358), 4,
      anon_sym_SLASH,
      aux_sym__sym_qualified_token1,
      anon_sym_LPAREN,
      anon_sym_POUND_QMARK,
  [7935] = 4,
    ACTIONS(1290), 1,
      anon_sym_POUND_,
    ACTIONS(1416), 2,
      sym__ws,
      sym_comment,
    STATE(446), 3,
      sym__gap,
      sym_dis_expr,
      aux_sym_dis_expr_repeat1,
    ACTIONS(1314), 4,
      anon_sym_SLASH,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
  [7954] = 4,
    ACTIONS(1443), 1,
      anon_sym_POUND_,
    ACTIONS(1440), 2,
      sym__ws,
      sym_comment,
    STATE(446), 3,
      sym__gap,
      sym_dis_expr,
      aux_sym_dis_expr_repeat1,
    ACTIONS(1190), 4,
      anon_sym_SLASH,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
  [7973] = 4,
    ACTIONS(1290), 1,
      anon_sym_POUND_,
    ACTIONS(1446), 2,
      sym__ws,
      sym_comment,
    STATE(445), 3,
      sym__gap,
      sym_dis_expr,
      aux_sym_dis_expr_repeat1,
    ACTIONS(1326), 4,
      anon_sym_SLASH,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
  [7992] = 4,
    ACTIONS(1290), 1,
      anon_sym_POUND_,
    ACTIONS(1416), 2,
      sym__ws,
      sym_comment,
    STATE(446), 3,
      sym__gap,
      sym_dis_expr,
      aux_sym_dis_expr_repeat1,
    ACTIONS(1318), 4,
      anon_sym_SLASH,
      aux_sym__sym_qualified_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
  [8011] = 7,
    ACTIONS(1448), 1,
      anon_sym_CARET,
    ACTIONS(1451), 1,
      anon_sym_POUND_CARET,
    STATE(424), 1,
      sym__metadata_lit,
    STATE(442), 1,
      sym_meta_lit,
    STATE(447), 1,
      sym_old_meta_lit,
    STATE(449), 1,
      aux_sym_sym_lit_repeat1,
    ACTIONS(1358), 2,
      anon_sym_SLASH,
      aux_sym__sym_qualified_token1,
  [8034] = 5,
    ACTIONS(282), 1,
      anon_sym_LBRACE,
    ACTIONS(1456), 1,
      anon_sym_POUND_,
    STATE(330), 1,
      sym__bare_map_lit,
    ACTIONS(1454), 2,
      sym__ws,
      sym_comment,
    STATE(464), 3,
      sym__gap,
      sym_dis_expr,
      aux_sym_dis_expr_repeat1,
  [8053] = 5,
    ACTIONS(282), 1,
      anon_sym_LBRACE,
    ACTIONS(1456), 1,
      anon_sym_POUND_,
    STATE(356), 1,
      sym__bare_map_lit,
    ACTIONS(1458), 2,
      sym__ws,
      sym_comment,
    STATE(450), 3,
      sym__gap,
      sym_dis_expr,
      aux_sym_dis_expr_repeat1,
  [8072] = 8,
    ACTIONS(1198), 1,
      anon_sym_SLASH,
    ACTIONS(1200), 1,
      aux_sym__sym_qualified_token1,
    ACTIONS(1298), 1,
      anon_sym_CARET,
    ACTIONS(1300), 1,
      anon_sym_POUND_CARET,
    STATE(424), 1,
      sym__metadata_lit,
    STATE(442), 1,
      sym_meta_lit,
    STATE(447), 1,
      sym_old_meta_lit,
    STATE(449), 1,
      aux_sym_sym_lit_repeat1,
  [8097] = 5,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(1456), 1,
      anon_sym_POUND_,
    STATE(296), 1,
      sym__bare_map_lit,
    ACTIONS(1454), 2,
      sym__ws,
      sym_comment,
    STATE(464), 3,
      sym__gap,
      sym_dis_expr,
      aux_sym_dis_expr_repeat1,
  [8116] = 5,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(1456), 1,
      anon_sym_POUND_,
    STATE(266), 1,
      sym__bare_map_lit,
    ACTIONS(1460), 2,
      sym__ws,
      sym_comment,
    STATE(453), 3,
      sym__gap,
      sym_dis_expr,
      aux_sym_dis_expr_repeat1,
  [8135] = 3,
    ACTIONS(1356), 1,
      aux_sym__kwd_leading_slash_token1,
    ACTIONS(862), 3,
      anon_sym_POUND_,
      anon_sym_SLASH,
      aux_sym__sym_qualified_token1,
    ACTIONS(860), 4,
      sym__ws,
      sym_comment,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
  [8150] = 5,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(1456), 1,
      anon_sym_POUND_,
    STATE(273), 1,
      sym__bare_map_lit,
    ACTIONS(1462), 2,
      sym__ws,
      sym_comment,
    STATE(462), 3,
      sym__gap,
      sym_dis_expr,
      aux_sym_dis_expr_repeat1,
  [8169] = 5,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(1456), 1,
      anon_sym_POUND_,
    STATE(294), 1,
      sym__bare_map_lit,
    ACTIONS(1454), 2,
      sym__ws,
      sym_comment,
    STATE(464), 3,
      sym__gap,
      sym_dis_expr,
      aux_sym_dis_expr_repeat1,
  [8188] = 5,
    ACTIONS(282), 1,
      anon_sym_LBRACE,
    ACTIONS(1456), 1,
      anon_sym_POUND_,
    STATE(358), 1,
      sym__bare_map_lit,
    ACTIONS(1464), 2,
      sym__ws,
      sym_comment,
    STATE(459), 3,
      sym__gap,
      sym_dis_expr,
      aux_sym_dis_expr_repeat1,
  [8207] = 5,
    ACTIONS(282), 1,
      anon_sym_LBRACE,
    ACTIONS(1456), 1,
      anon_sym_POUND_,
    STATE(328), 1,
      sym__bare_map_lit,
    ACTIONS(1454), 2,
      sym__ws,
      sym_comment,
    STATE(464), 3,
      sym__gap,
      sym_dis_expr,
      aux_sym_dis_expr_repeat1,
  [8226] = 5,
    ACTIONS(282), 1,
      anon_sym_LBRACE,
    ACTIONS(1456), 1,
      anon_sym_POUND_,
    STATE(365), 1,
      sym__bare_map_lit,
    ACTIONS(1454), 2,
      sym__ws,
      sym_comment,
    STATE(464), 3,
      sym__gap,
      sym_dis_expr,
      aux_sym_dis_expr_repeat1,
  [8245] = 5,
    ACTIONS(282), 1,
      anon_sym_LBRACE,
    ACTIONS(1456), 1,
      anon_sym_POUND_,
    STATE(404), 1,
      sym__bare_map_lit,
    ACTIONS(1466), 2,
      sym__ws,
      sym_comment,
    STATE(460), 3,
      sym__gap,
      sym_dis_expr,
      aux_sym_dis_expr_repeat1,
  [8264] = 5,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(1456), 1,
      anon_sym_POUND_,
    STATE(221), 1,
      sym__bare_map_lit,
    ACTIONS(1454), 2,
      sym__ws,
      sym_comment,
    STATE(464), 3,
      sym__gap,
      sym_dis_expr,
      aux_sym_dis_expr_repeat1,
  [8283] = 5,
    ACTIONS(27), 1,
      anon_sym_LBRACE,
    ACTIONS(1456), 1,
      anon_sym_POUND_,
    STATE(258), 1,
      sym__bare_map_lit,
    ACTIONS(1468), 2,
      sym__ws,
      sym_comment,
    STATE(457), 3,
      sym__gap,
      sym_dis_expr,
      aux_sym_dis_expr_repeat1,
  [8302] = 4,
    ACTIONS(1190), 1,
      anon_sym_LBRACE,
    ACTIONS(1473), 1,
      anon_sym_POUND_,
    ACTIONS(1470), 2,
      sym__ws,
      sym_comment,
    STATE(464), 3,
      sym__gap,
      sym_dis_expr,
      aux_sym_dis_expr_repeat1,
  [8318] = 4,
    ACTIONS(1478), 1,
      anon_sym_POUND_,
    ACTIONS(1480), 1,
      anon_sym_SLASH,
    ACTIONS(1482), 1,
      aux_sym__kwd_qualified_token1,
    ACTIONS(1476), 3,
      sym__ws,
      sym_comment,
      anon_sym_LBRACE,
  [8333] = 3,
    ACTIONS(862), 1,
      anon_sym_POUND_,
    ACTIONS(864), 1,
      aux_sym__kwd_leading_slash_token1,
    ACTIONS(860), 3,
      sym__ws,
      sym_comment,
      anon_sym_LBRACE,
  [8345] = 4,
    ACTIONS(280), 1,
      anon_sym_LPAREN,
    ACTIONS(1484), 1,
      sym__ws,
    STATE(351), 1,
      sym__bare_list_lit,
    STATE(483), 1,
      aux_sym_read_cond_lit_repeat1,
  [8358] = 4,
    ACTIONS(280), 1,
      anon_sym_LPAREN,
    ACTIONS(1486), 1,
      sym__ws,
    STATE(325), 1,
      sym__bare_list_lit,
    STATE(476), 1,
      aux_sym_read_cond_lit_repeat1,
  [8371] = 4,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(1488), 1,
      sym__ws,
    STATE(282), 1,
      sym__bare_list_lit,
    STATE(475), 1,
      aux_sym_read_cond_lit_repeat1,
  [8384] = 4,
    ACTIONS(280), 1,
      anon_sym_LPAREN,
    ACTIONS(1484), 1,
      sym__ws,
    STATE(421), 1,
      sym__bare_list_lit,
    STATE(483), 1,
      aux_sym_read_cond_lit_repeat1,
  [8397] = 4,
    ACTIONS(280), 1,
      anon_sym_LPAREN,
    ACTIONS(1484), 1,
      sym__ws,
    STATE(413), 1,
      sym__bare_list_lit,
    STATE(483), 1,
      aux_sym_read_cond_lit_repeat1,
  [8410] = 4,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(1484), 1,
      sym__ws,
    STATE(269), 1,
      sym__bare_list_lit,
    STATE(483), 1,
      aux_sym_read_cond_lit_repeat1,
  [8423] = 4,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(1484), 1,
      sym__ws,
    STATE(220), 1,
      sym__bare_list_lit,
    STATE(483), 1,
      aux_sym_read_cond_lit_repeat1,
  [8436] = 4,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(1490), 1,
      sym__ws,
    STATE(281), 1,
      sym__bare_list_lit,
    STATE(473), 1,
      aux_sym_read_cond_lit_repeat1,
  [8449] = 4,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(1484), 1,
      sym__ws,
    STATE(223), 1,
      sym__bare_list_lit,
    STATE(483), 1,
      aux_sym_read_cond_lit_repeat1,
  [8462] = 4,
    ACTIONS(280), 1,
      anon_sym_LPAREN,
    ACTIONS(1484), 1,
      sym__ws,
    STATE(352), 1,
      sym__bare_list_lit,
    STATE(483), 1,
      aux_sym_read_cond_lit_repeat1,
  [8475] = 4,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(1492), 1,
      sym__ws,
    STATE(238), 1,
      sym__bare_list_lit,
    STATE(472), 1,
      aux_sym_read_cond_lit_repeat1,
  [8488] = 4,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(1494), 1,
      sym__ws,
    STATE(237), 1,
      sym__bare_list_lit,
    STATE(482), 1,
      aux_sym_read_cond_lit_repeat1,
  [8501] = 4,
    ACTIONS(280), 1,
      anon_sym_LPAREN,
    ACTIONS(1496), 1,
      sym__ws,
    STATE(344), 1,
      sym__bare_list_lit,
    STATE(470), 1,
      aux_sym_read_cond_lit_repeat1,
  [8514] = 4,
    ACTIONS(280), 1,
      anon_sym_LPAREN,
    ACTIONS(1498), 1,
      sym__ws,
    STATE(343), 1,
      sym__bare_list_lit,
    STATE(471), 1,
      aux_sym_read_cond_lit_repeat1,
  [8527] = 4,
    ACTIONS(280), 1,
      anon_sym_LPAREN,
    ACTIONS(1500), 1,
      sym__ws,
    STATE(406), 1,
      sym__bare_list_lit,
    STATE(467), 1,
      aux_sym_read_cond_lit_repeat1,
  [8540] = 4,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(1484), 1,
      sym__ws,
    STATE(268), 1,
      sym__bare_list_lit,
    STATE(483), 1,
      aux_sym_read_cond_lit_repeat1,
  [8553] = 3,
    ACTIONS(1502), 1,
      sym__ws,
    ACTIONS(1505), 1,
      anon_sym_LPAREN,
    STATE(483), 1,
      aux_sym_read_cond_lit_repeat1,
  [8563] = 2,
    ACTIONS(1507), 1,
      anon_sym_SLASH,
    ACTIONS(1509), 1,
      aux_sym__kwd_qualified_token1,
  [8570] = 2,
    ACTIONS(1480), 1,
      anon_sym_SLASH,
    ACTIONS(1509), 1,
      aux_sym__kwd_qualified_token1,
  [8577] = 2,
    ACTIONS(1511), 1,
      anon_sym_SLASH,
    ACTIONS(1513), 1,
      aux_sym__kwd_qualified_token1,
  [8584] = 2,
    ACTIONS(1513), 1,
      aux_sym__kwd_qualified_token1,
    ACTIONS(1515), 1,
      anon_sym_SLASH,
  [8591] = 2,
    ACTIONS(1513), 1,
      aux_sym__kwd_qualified_token1,
    ACTIONS(1517), 1,
      anon_sym_SLASH,
  [8598] = 1,
    ACTIONS(1519), 1,
      aux_sym__sym_qualified_token2,
  [8602] = 1,
    ACTIONS(1521), 1,
      aux_sym__kwd_leading_slash_token1,
  [8606] = 1,
    ACTIONS(1523), 1,
      aux_sym__sym_qualified_token2,
  [8610] = 1,
    ACTIONS(1525), 1,
      aux_sym__sym_qualified_token2,
  [8614] = 1,
    ACTIONS(1527), 1,
      ts_builtin_sym_end,
  [8618] = 1,
    ACTIONS(1529), 1,
      aux_sym__kwd_leading_slash_token1,
  [8622] = 1,
    ACTIONS(1531), 1,
      aux_sym__sym_qualified_token2,
};

static const uint32_t ts_small_parse_table_map[] = {
  [SMALL_STATE(213)] = 0,
  [SMALL_STATE(214)] = 40,
  [SMALL_STATE(215)] = 77,
  [SMALL_STATE(216)] = 114,
  [SMALL_STATE(217)] = 151,
  [SMALL_STATE(218)] = 190,
  [SMALL_STATE(219)] = 227,
  [SMALL_STATE(220)] = 264,
  [SMALL_STATE(221)] = 301,
  [SMALL_STATE(222)] = 338,
  [SMALL_STATE(223)] = 375,
  [SMALL_STATE(224)] = 412,
  [SMALL_STATE(225)] = 449,
  [SMALL_STATE(226)] = 486,
  [SMALL_STATE(227)] = 523,
  [SMALL_STATE(228)] = 560,
  [SMALL_STATE(229)] = 597,
  [SMALL_STATE(230)] = 634,
  [SMALL_STATE(231)] = 673,
  [SMALL_STATE(232)] = 710,
  [SMALL_STATE(233)] = 747,
  [SMALL_STATE(234)] = 784,
  [SMALL_STATE(235)] = 821,
  [SMALL_STATE(236)] = 858,
  [SMALL_STATE(237)] = 895,
  [SMALL_STATE(238)] = 932,
  [SMALL_STATE(239)] = 969,
  [SMALL_STATE(240)] = 1006,
  [SMALL_STATE(241)] = 1043,
  [SMALL_STATE(242)] = 1080,
  [SMALL_STATE(243)] = 1117,
  [SMALL_STATE(244)] = 1154,
  [SMALL_STATE(245)] = 1191,
  [SMALL_STATE(246)] = 1228,
  [SMALL_STATE(247)] = 1265,
  [SMALL_STATE(248)] = 1302,
  [SMALL_STATE(249)] = 1339,
  [SMALL_STATE(250)] = 1376,
  [SMALL_STATE(251)] = 1413,
  [SMALL_STATE(252)] = 1450,
  [SMALL_STATE(253)] = 1489,
  [SMALL_STATE(254)] = 1526,
  [SMALL_STATE(255)] = 1563,
  [SMALL_STATE(256)] = 1600,
  [SMALL_STATE(257)] = 1637,
  [SMALL_STATE(258)] = 1674,
  [SMALL_STATE(259)] = 1711,
  [SMALL_STATE(260)] = 1748,
  [SMALL_STATE(261)] = 1785,
  [SMALL_STATE(262)] = 1822,
  [SMALL_STATE(263)] = 1859,
  [SMALL_STATE(264)] = 1896,
  [SMALL_STATE(265)] = 1933,
  [SMALL_STATE(266)] = 1970,
  [SMALL_STATE(267)] = 2007,
  [SMALL_STATE(268)] = 2044,
  [SMALL_STATE(269)] = 2081,
  [SMALL_STATE(270)] = 2118,
  [SMALL_STATE(271)] = 2155,
  [SMALL_STATE(272)] = 2192,
  [SMALL_STATE(273)] = 2229,
  [SMALL_STATE(274)] = 2266,
  [SMALL_STATE(275)] = 2303,
  [SMALL_STATE(276)] = 2340,
  [SMALL_STATE(277)] = 2377,
  [SMALL_STATE(278)] = 2414,
  [SMALL_STATE(279)] = 2451,
  [SMALL_STATE(280)] = 2488,
  [SMALL_STATE(281)] = 2525,
  [SMALL_STATE(282)] = 2562,
  [SMALL_STATE(283)] = 2599,
  [SMALL_STATE(284)] = 2636,
  [SMALL_STATE(285)] = 2673,
  [SMALL_STATE(286)] = 2710,
  [SMALL_STATE(287)] = 2747,
  [SMALL_STATE(288)] = 2784,
  [SMALL_STATE(289)] = 2821,
  [SMALL_STATE(290)] = 2858,
  [SMALL_STATE(291)] = 2895,
  [SMALL_STATE(292)] = 2932,
  [SMALL_STATE(293)] = 2969,
  [SMALL_STATE(294)] = 3006,
  [SMALL_STATE(295)] = 3043,
  [SMALL_STATE(296)] = 3080,
  [SMALL_STATE(297)] = 3117,
  [SMALL_STATE(298)] = 3154,
  [SMALL_STATE(299)] = 3191,
  [SMALL_STATE(300)] = 3228,
  [SMALL_STATE(301)] = 3265,
  [SMALL_STATE(302)] = 3307,
  [SMALL_STATE(303)] = 3343,
  [SMALL_STATE(304)] = 3419,
  [SMALL_STATE(305)] = 3495,
  [SMALL_STATE(306)] = 3571,
  [SMALL_STATE(307)] = 3647,
  [SMALL_STATE(308)] = 3723,
  [SMALL_STATE(309)] = 3785,
  [SMALL_STATE(310)] = 3847,
  [SMALL_STATE(311)] = 3881,
  [SMALL_STATE(312)] = 3915,
  [SMALL_STATE(313)] = 3977,
  [SMALL_STATE(314)] = 4011,
  [SMALL_STATE(315)] = 4045,
  [SMALL_STATE(316)] = 4107,
  [SMALL_STATE(317)] = 4169,
  [SMALL_STATE(318)] = 4203,
  [SMALL_STATE(319)] = 4264,
  [SMALL_STATE(320)] = 4325,
  [SMALL_STATE(321)] = 4386,
  [SMALL_STATE(322)] = 4447,
  [SMALL_STATE(323)] = 4508,
  [SMALL_STATE(324)] = 4536,
  [SMALL_STATE(325)] = 4574,
  [SMALL_STATE(326)] = 4599,
  [SMALL_STATE(327)] = 4624,
  [SMALL_STATE(328)] = 4649,
  [SMALL_STATE(329)] = 4674,
  [SMALL_STATE(330)] = 4699,
  [SMALL_STATE(331)] = 4724,
  [SMALL_STATE(332)] = 4749,
  [SMALL_STATE(333)] = 4774,
  [SMALL_STATE(334)] = 4799,
  [SMALL_STATE(335)] = 4824,
  [SMALL_STATE(336)] = 4849,
  [SMALL_STATE(337)] = 4876,
  [SMALL_STATE(338)] = 4901,
  [SMALL_STATE(339)] = 4926,
  [SMALL_STATE(340)] = 4951,
  [SMALL_STATE(341)] = 5002,
  [SMALL_STATE(342)] = 5027,
  [SMALL_STATE(343)] = 5052,
  [SMALL_STATE(344)] = 5077,
  [SMALL_STATE(345)] = 5102,
  [SMALL_STATE(346)] = 5127,
  [SMALL_STATE(347)] = 5152,
  [SMALL_STATE(348)] = 5177,
  [SMALL_STATE(349)] = 5202,
  [SMALL_STATE(350)] = 5227,
  [SMALL_STATE(351)] = 5252,
  [SMALL_STATE(352)] = 5277,
  [SMALL_STATE(353)] = 5302,
  [SMALL_STATE(354)] = 5327,
  [SMALL_STATE(355)] = 5378,
  [SMALL_STATE(356)] = 5403,
  [SMALL_STATE(357)] = 5428,
  [SMALL_STATE(358)] = 5453,
  [SMALL_STATE(359)] = 5478,
  [SMALL_STATE(360)] = 5503,
  [SMALL_STATE(361)] = 5558,
  [SMALL_STATE(362)] = 5583,
  [SMALL_STATE(363)] = 5608,
  [SMALL_STATE(364)] = 5633,
  [SMALL_STATE(365)] = 5658,
  [SMALL_STATE(366)] = 5683,
  [SMALL_STATE(367)] = 5708,
  [SMALL_STATE(368)] = 5733,
  [SMALL_STATE(369)] = 5758,
  [SMALL_STATE(370)] = 5783,
  [SMALL_STATE(371)] = 5808,
  [SMALL_STATE(372)] = 5833,
  [SMALL_STATE(373)] = 5858,
  [SMALL_STATE(374)] = 5885,
  [SMALL_STATE(375)] = 5910,
  [SMALL_STATE(376)] = 5965,
  [SMALL_STATE(377)] = 5990,
  [SMALL_STATE(378)] = 6015,
  [SMALL_STATE(379)] = 6040,
  [SMALL_STATE(380)] = 6065,
  [SMALL_STATE(381)] = 6090,
  [SMALL_STATE(382)] = 6115,
  [SMALL_STATE(383)] = 6140,
  [SMALL_STATE(384)] = 6191,
  [SMALL_STATE(385)] = 6216,
  [SMALL_STATE(386)] = 6241,
  [SMALL_STATE(387)] = 6266,
  [SMALL_STATE(388)] = 6291,
  [SMALL_STATE(389)] = 6318,
  [SMALL_STATE(390)] = 6343,
  [SMALL_STATE(391)] = 6394,
  [SMALL_STATE(392)] = 6419,
  [SMALL_STATE(393)] = 6444,
  [SMALL_STATE(394)] = 6469,
  [SMALL_STATE(395)] = 6524,
  [SMALL_STATE(396)] = 6549,
  [SMALL_STATE(397)] = 6574,
  [SMALL_STATE(398)] = 6599,
  [SMALL_STATE(399)] = 6624,
  [SMALL_STATE(400)] = 6649,
  [SMALL_STATE(401)] = 6674,
  [SMALL_STATE(402)] = 6699,
  [SMALL_STATE(403)] = 6724,
  [SMALL_STATE(404)] = 6749,
  [SMALL_STATE(405)] = 6774,
  [SMALL_STATE(406)] = 6799,
  [SMALL_STATE(407)] = 6824,
  [SMALL_STATE(408)] = 6849,
  [SMALL_STATE(409)] = 6874,
  [SMALL_STATE(410)] = 6899,
  [SMALL_STATE(411)] = 6924,
  [SMALL_STATE(412)] = 6949,
  [SMALL_STATE(413)] = 6974,
  [SMALL_STATE(414)] = 6999,
  [SMALL_STATE(415)] = 7024,
  [SMALL_STATE(416)] = 7049,
  [SMALL_STATE(417)] = 7074,
  [SMALL_STATE(418)] = 7099,
  [SMALL_STATE(419)] = 7124,
  [SMALL_STATE(420)] = 7149,
  [SMALL_STATE(421)] = 7174,
  [SMALL_STATE(422)] = 7199,
  [SMALL_STATE(423)] = 7254,
  [SMALL_STATE(424)] = 7279,
  [SMALL_STATE(425)] = 7301,
  [SMALL_STATE(426)] = 7341,
  [SMALL_STATE(427)] = 7381,
  [SMALL_STATE(428)] = 7421,
  [SMALL_STATE(429)] = 7461,
  [SMALL_STATE(430)] = 7501,
  [SMALL_STATE(431)] = 7541,
  [SMALL_STATE(432)] = 7581,
  [SMALL_STATE(433)] = 7621,
  [SMALL_STATE(434)] = 7661,
  [SMALL_STATE(435)] = 7701,
  [SMALL_STATE(436)] = 7722,
  [SMALL_STATE(437)] = 7743,
  [SMALL_STATE(438)] = 7764,
  [SMALL_STATE(439)] = 7785,
  [SMALL_STATE(440)] = 7806,
  [SMALL_STATE(441)] = 7840,
  [SMALL_STATE(442)] = 7874,
  [SMALL_STATE(443)] = 7893,
  [SMALL_STATE(444)] = 7910,
  [SMALL_STATE(445)] = 7935,
  [SMALL_STATE(446)] = 7954,
  [SMALL_STATE(447)] = 7973,
  [SMALL_STATE(448)] = 7992,
  [SMALL_STATE(449)] = 8011,
  [SMALL_STATE(450)] = 8034,
  [SMALL_STATE(451)] = 8053,
  [SMALL_STATE(452)] = 8072,
  [SMALL_STATE(453)] = 8097,
  [SMALL_STATE(454)] = 8116,
  [SMALL_STATE(455)] = 8135,
  [SMALL_STATE(456)] = 8150,
  [SMALL_STATE(457)] = 8169,
  [SMALL_STATE(458)] = 8188,
  [SMALL_STATE(459)] = 8207,
  [SMALL_STATE(460)] = 8226,
  [SMALL_STATE(461)] = 8245,
  [SMALL_STATE(462)] = 8264,
  [SMALL_STATE(463)] = 8283,
  [SMALL_STATE(464)] = 8302,
  [SMALL_STATE(465)] = 8318,
  [SMALL_STATE(466)] = 8333,
  [SMALL_STATE(467)] = 8345,
  [SMALL_STATE(468)] = 8358,
  [SMALL_STATE(469)] = 8371,
  [SMALL_STATE(470)] = 8384,
  [SMALL_STATE(471)] = 8397,
  [SMALL_STATE(472)] = 8410,
  [SMALL_STATE(473)] = 8423,
  [SMALL_STATE(474)] = 8436,
  [SMALL_STATE(475)] = 8449,
  [SMALL_STATE(476)] = 8462,
  [SMALL_STATE(477)] = 8475,
  [SMALL_STATE(478)] = 8488,
  [SMALL_STATE(479)] = 8501,
  [SMALL_STATE(480)] = 8514,
  [SMALL_STATE(481)] = 8527,
  [SMALL_STATE(482)] = 8540,
  [SMALL_STATE(483)] = 8553,
  [SMALL_STATE(484)] = 8563,
  [SMALL_STATE(485)] = 8570,
  [SMALL_STATE(486)] = 8577,
  [SMALL_STATE(487)] = 8584,
  [SMALL_STATE(488)] = 8591,
  [SMALL_STATE(489)] = 8598,
  [SMALL_STATE(490)] = 8602,
  [SMALL_STATE(491)] = 8606,
  [SMALL_STATE(492)] = 8610,
  [SMALL_STATE(493)] = 8614,
  [SMALL_STATE(494)] = 8618,
  [SMALL_STATE(495)] = 8622,
};

static const TSParseActionEntry ts_parse_actions[] = {
  [0] = {.entry = {.count = 0, .reusable = false}},
  [1] = {.entry = {.count = 1, .reusable = false}}, RECOVER(),
  [3] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_source, 0),
  [5] = {.entry = {.count = 1, .reusable = true}}, SHIFT(19),
  [7] = {.entry = {.count = 1, .reusable = true}}, SHIFT(106),
  [9] = {.entry = {.count = 1, .reusable = true}}, SHIFT(280),
  [11] = {.entry = {.count = 1, .reusable = false}}, SHIFT(484),
  [13] = {.entry = {.count = 1, .reusable = true}}, SHIFT(484),
  [15] = {.entry = {.count = 1, .reusable = true}}, SHIFT(216),
  [17] = {.entry = {.count = 1, .reusable = false}}, SHIFT(19),
  [19] = {.entry = {.count = 1, .reusable = false}}, SHIFT(217),
  [21] = {.entry = {.count = 1, .reusable = true}}, SHIFT(164),
  [23] = {.entry = {.count = 1, .reusable = true}}, SHIFT(162),
  [25] = {.entry = {.count = 1, .reusable = true}}, SHIFT(9),
  [27] = {.entry = {.count = 1, .reusable = true}}, SHIFT(10),
  [29] = {.entry = {.count = 1, .reusable = true}}, SHIFT(11),
  [31] = {.entry = {.count = 1, .reusable = false}}, SHIFT(315),
  [33] = {.entry = {.count = 1, .reusable = false}}, SHIFT(478),
  [35] = {.entry = {.count = 1, .reusable = true}}, SHIFT(477),
  [37] = {.entry = {.count = 1, .reusable = true}}, SHIFT(110),
  [39] = {.entry = {.count = 1, .reusable = true}}, SHIFT(118),
  [41] = {.entry = {.count = 1, .reusable = true}}, SHIFT(340),
  [43] = {.entry = {.count = 1, .reusable = true}}, SHIFT(24),
  [45] = {.entry = {.count = 1, .reusable = true}}, SHIFT(25),
  [47] = {.entry = {.count = 1, .reusable = true}}, SHIFT(26),
  [49] = {.entry = {.count = 1, .reusable = true}}, SHIFT(27),
  [51] = {.entry = {.count = 1, .reusable = false}}, SHIFT(28),
  [53] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__bare_list_lit_repeat1, 2, .production_id = 21), SHIFT_REPEAT(2),
  [56] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__bare_list_lit_repeat1, 2, .production_id = 21), SHIFT_REPEAT(106),
  [59] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__bare_list_lit_repeat1, 2, .production_id = 21), SHIFT_REPEAT(302),
  [62] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__bare_list_lit_repeat1, 2, .production_id = 21), SHIFT_REPEAT(280),
  [65] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__bare_list_lit_repeat1, 2, .production_id = 21), SHIFT_REPEAT(484),
  [68] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__bare_list_lit_repeat1, 2, .production_id = 21), SHIFT_REPEAT(484),
  [71] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__bare_list_lit_repeat1, 2, .production_id = 21), SHIFT_REPEAT(216),
  [74] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__bare_list_lit_repeat1, 2, .production_id = 21), SHIFT_REPEAT(302),
  [77] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__bare_list_lit_repeat1, 2, .production_id = 21), SHIFT_REPEAT(217),
  [80] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__bare_list_lit_repeat1, 2, .production_id = 21), SHIFT_REPEAT(164),
  [83] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__bare_list_lit_repeat1, 2, .production_id = 21), SHIFT_REPEAT(162),
  [86] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__bare_list_lit_repeat1, 2, .production_id = 21), SHIFT_REPEAT(9),
  [89] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__bare_list_lit_repeat1, 2, .production_id = 21),
  [91] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__bare_list_lit_repeat1, 2, .production_id = 21), SHIFT_REPEAT(10),
  [94] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__bare_list_lit_repeat1, 2, .production_id = 21), SHIFT_REPEAT(11),
  [97] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__bare_list_lit_repeat1, 2, .production_id = 21), SHIFT_REPEAT(315),
  [100] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__bare_list_lit_repeat1, 2, .production_id = 21), SHIFT_REPEAT(478),
  [103] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__bare_list_lit_repeat1, 2, .production_id = 21), SHIFT_REPEAT(477),
  [106] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__bare_list_lit_repeat1, 2, .production_id = 21), SHIFT_REPEAT(110),
  [109] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__bare_list_lit_repeat1, 2, .production_id = 21), SHIFT_REPEAT(118),
  [112] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__bare_list_lit_repeat1, 2, .production_id = 21), SHIFT_REPEAT(340),
  [115] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__bare_list_lit_repeat1, 2, .production_id = 21), SHIFT_REPEAT(24),
  [118] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__bare_list_lit_repeat1, 2, .production_id = 21), SHIFT_REPEAT(25),
  [121] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__bare_list_lit_repeat1, 2, .production_id = 21), SHIFT_REPEAT(26),
  [124] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__bare_list_lit_repeat1, 2, .production_id = 21), SHIFT_REPEAT(27),
  [127] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__bare_list_lit_repeat1, 2, .production_id = 21), SHIFT_REPEAT(28),
  [130] = {.entry = {.count = 1, .reusable = true}}, SHIFT(2),
  [132] = {.entry = {.count = 1, .reusable = true}}, SHIFT(302),
  [134] = {.entry = {.count = 1, .reusable = false}}, SHIFT(302),
  [136] = {.entry = {.count = 1, .reusable = true}}, SHIFT(396),
  [138] = {.entry = {.count = 1, .reusable = true}}, SHIFT(7),
  [140] = {.entry = {.count = 1, .reusable = true}}, SHIFT(339),
  [142] = {.entry = {.count = 1, .reusable = true}}, SHIFT(264),
  [144] = {.entry = {.count = 1, .reusable = true}}, SHIFT(397),
  [146] = {.entry = {.count = 1, .reusable = true}}, SHIFT(398),
  [148] = {.entry = {.count = 1, .reusable = true}}, SHIFT(12),
  [150] = {.entry = {.count = 1, .reusable = true}}, SHIFT(401),
  [152] = {.entry = {.count = 1, .reusable = true}}, SHIFT(16),
  [154] = {.entry = {.count = 1, .reusable = true}}, SHIFT(231),
  [156] = {.entry = {.count = 1, .reusable = true}}, SHIFT(18),
  [158] = {.entry = {.count = 1, .reusable = true}}, SHIFT(233),
  [160] = {.entry = {.count = 1, .reusable = true}}, SHIFT(5),
  [162] = {.entry = {.count = 1, .reusable = true}}, SHIFT(234),
  [164] = {.entry = {.count = 1, .reusable = true}}, SHIFT(368),
  [166] = {.entry = {.count = 1, .reusable = true}}, SHIFT(3),
  [168] = {.entry = {.count = 1, .reusable = true}}, SHIFT(337),
  [170] = {.entry = {.count = 1, .reusable = true}}, SHIFT(295),
  [172] = {.entry = {.count = 1, .reusable = true}}, SHIFT(6),
  [174] = {.entry = {.count = 1, .reusable = true}}, SHIFT(338),
  [176] = {.entry = {.count = 1, .reusable = true}}, SHIFT(261),
  [178] = {.entry = {.count = 1, .reusable = true}}, SHIFT(14),
  [180] = {.entry = {.count = 1, .reusable = true}}, SHIFT(215),
  [182] = {.entry = {.count = 1, .reusable = true}}, SHIFT(262),
  [184] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_source, 1),
  [186] = {.entry = {.count = 1, .reusable = true}}, SHIFT(20),
  [188] = {.entry = {.count = 1, .reusable = false}}, SHIFT(20),
  [190] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_source_repeat1, 2),
  [192] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_repeat1, 2), SHIFT_REPEAT(20),
  [195] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_repeat1, 2), SHIFT_REPEAT(106),
  [198] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_repeat1, 2), SHIFT_REPEAT(280),
  [201] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_repeat1, 2), SHIFT_REPEAT(484),
  [204] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_repeat1, 2), SHIFT_REPEAT(484),
  [207] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_repeat1, 2), SHIFT_REPEAT(216),
  [210] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_repeat1, 2), SHIFT_REPEAT(20),
  [213] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_repeat1, 2), SHIFT_REPEAT(217),
  [216] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_repeat1, 2), SHIFT_REPEAT(164),
  [219] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_repeat1, 2), SHIFT_REPEAT(162),
  [222] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_repeat1, 2), SHIFT_REPEAT(9),
  [225] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_repeat1, 2), SHIFT_REPEAT(10),
  [228] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_repeat1, 2), SHIFT_REPEAT(11),
  [231] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_repeat1, 2), SHIFT_REPEAT(315),
  [234] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_repeat1, 2), SHIFT_REPEAT(478),
  [237] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_repeat1, 2), SHIFT_REPEAT(477),
  [240] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_repeat1, 2), SHIFT_REPEAT(110),
  [243] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_repeat1, 2), SHIFT_REPEAT(118),
  [246] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_repeat1, 2), SHIFT_REPEAT(340),
  [249] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_repeat1, 2), SHIFT_REPEAT(24),
  [252] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_repeat1, 2), SHIFT_REPEAT(25),
  [255] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_repeat1, 2), SHIFT_REPEAT(26),
  [258] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_repeat1, 2), SHIFT_REPEAT(27),
  [261] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_repeat1, 2), SHIFT_REPEAT(28),
  [264] = {.entry = {.count = 1, .reusable = true}}, SHIFT(301),
  [266] = {.entry = {.count = 1, .reusable = true}}, SHIFT(420),
  [268] = {.entry = {.count = 1, .reusable = true}}, SHIFT(376),
  [270] = {.entry = {.count = 1, .reusable = false}}, SHIFT(486),
  [272] = {.entry = {.count = 1, .reusable = true}}, SHIFT(486),
  [274] = {.entry = {.count = 1, .reusable = true}}, SHIFT(379),
  [276] = {.entry = {.count = 1, .reusable = false}}, SHIFT(420),
  [278] = {.entry = {.count = 1, .reusable = false}}, SHIFT(388),
  [280] = {.entry = {.count = 1, .reusable = true}}, SHIFT(13),
  [282] = {.entry = {.count = 1, .reusable = true}}, SHIFT(15),
  [284] = {.entry = {.count = 1, .reusable = true}}, SHIFT(4),
  [286] = {.entry = {.count = 1, .reusable = false}}, SHIFT(312),
  [288] = {.entry = {.count = 1, .reusable = false}}, SHIFT(480),
  [290] = {.entry = {.count = 1, .reusable = true}}, SHIFT(479),
  [292] = {.entry = {.count = 1, .reusable = true}}, SHIFT(54),
  [294] = {.entry = {.count = 1, .reusable = true}}, SHIFT(23),
  [296] = {.entry = {.count = 1, .reusable = true}}, SHIFT(390),
  [298] = {.entry = {.count = 1, .reusable = true}}, SHIFT(116),
  [300] = {.entry = {.count = 1, .reusable = true}}, SHIFT(113),
  [302] = {.entry = {.count = 1, .reusable = true}}, SHIFT(112),
  [304] = {.entry = {.count = 1, .reusable = true}}, SHIFT(111),
  [306] = {.entry = {.count = 1, .reusable = false}}, SHIFT(109),
  [308] = {.entry = {.count = 1, .reusable = true}}, SHIFT(114),
  [310] = {.entry = {.count = 1, .reusable = true}}, SHIFT(267),
  [312] = {.entry = {.count = 1, .reusable = false}}, SHIFT(267),
  [314] = {.entry = {.count = 1, .reusable = true}}, SHIFT(104),
  [316] = {.entry = {.count = 1, .reusable = true}}, SHIFT(347),
  [318] = {.entry = {.count = 1, .reusable = false}}, SHIFT(347),
  [320] = {.entry = {.count = 1, .reusable = true}}, SHIFT(70),
  [322] = {.entry = {.count = 1, .reusable = true}}, SHIFT(244),
  [324] = {.entry = {.count = 1, .reusable = false}}, SHIFT(244),
  [326] = {.entry = {.count = 1, .reusable = true}}, SHIFT(72),
  [328] = {.entry = {.count = 1, .reusable = true}}, SHIFT(245),
  [330] = {.entry = {.count = 1, .reusable = false}}, SHIFT(245),
  [332] = {.entry = {.count = 1, .reusable = true}}, SHIFT(74),
  [334] = {.entry = {.count = 1, .reusable = true}}, SHIFT(246),
  [336] = {.entry = {.count = 1, .reusable = false}}, SHIFT(246),
  [338] = {.entry = {.count = 1, .reusable = true}}, SHIFT(76),
  [340] = {.entry = {.count = 1, .reusable = true}}, SHIFT(247),
  [342] = {.entry = {.count = 1, .reusable = false}}, SHIFT(247),
  [344] = {.entry = {.count = 1, .reusable = true}}, SHIFT(78),
  [346] = {.entry = {.count = 1, .reusable = true}}, SHIFT(248),
  [348] = {.entry = {.count = 1, .reusable = false}}, SHIFT(248),
  [350] = {.entry = {.count = 1, .reusable = true}}, SHIFT(334),
  [352] = {.entry = {.count = 1, .reusable = false}}, SHIFT(487),
  [354] = {.entry = {.count = 1, .reusable = true}}, SHIFT(487),
  [356] = {.entry = {.count = 1, .reusable = false}}, SHIFT(334),
  [358] = {.entry = {.count = 1, .reusable = false}}, SHIFT(316),
  [360] = {.entry = {.count = 1, .reusable = true}}, SHIFT(61),
  [362] = {.entry = {.count = 1, .reusable = true}}, SHIFT(60),
  [364] = {.entry = {.count = 1, .reusable = true}}, SHIFT(59),
  [366] = {.entry = {.count = 1, .reusable = true}}, SHIFT(58),
  [368] = {.entry = {.count = 1, .reusable = true}}, SHIFT(57),
  [370] = {.entry = {.count = 1, .reusable = true}}, SHIFT(56),
  [372] = {.entry = {.count = 1, .reusable = false}}, SHIFT(55),
  [374] = {.entry = {.count = 1, .reusable = true}}, SHIFT(417),
  [376] = {.entry = {.count = 1, .reusable = false}}, SHIFT(417),
  [378] = {.entry = {.count = 1, .reusable = true}}, SHIFT(389),
  [380] = {.entry = {.count = 1, .reusable = false}}, SHIFT(389),
  [382] = {.entry = {.count = 1, .reusable = true}}, SHIFT(165),
  [384] = {.entry = {.count = 1, .reusable = true}}, SHIFT(357),
  [386] = {.entry = {.count = 1, .reusable = false}}, SHIFT(357),
  [388] = {.entry = {.count = 1, .reusable = true}}, SHIFT(161),
  [390] = {.entry = {.count = 1, .reusable = true}}, SHIFT(362),
  [392] = {.entry = {.count = 1, .reusable = false}}, SHIFT(362),
  [394] = {.entry = {.count = 1, .reusable = true}}, SHIFT(364),
  [396] = {.entry = {.count = 1, .reusable = false}}, SHIFT(364),
  [398] = {.entry = {.count = 1, .reusable = true}}, SHIFT(140),
  [400] = {.entry = {.count = 1, .reusable = true}}, SHIFT(378),
  [402] = {.entry = {.count = 1, .reusable = false}}, SHIFT(378),
  [404] = {.entry = {.count = 1, .reusable = true}}, SHIFT(124),
  [406] = {.entry = {.count = 1, .reusable = true}}, SHIFT(384),
  [408] = {.entry = {.count = 1, .reusable = false}}, SHIFT(384),
  [410] = {.entry = {.count = 1, .reusable = true}}, SHIFT(117),
  [412] = {.entry = {.count = 1, .reusable = true}}, SHIFT(410),
  [414] = {.entry = {.count = 1, .reusable = false}}, SHIFT(410),
  [416] = {.entry = {.count = 1, .reusable = true}}, SHIFT(29),
  [418] = {.entry = {.count = 1, .reusable = true}}, SHIFT(391),
  [420] = {.entry = {.count = 1, .reusable = false}}, SHIFT(391),
  [422] = {.entry = {.count = 1, .reusable = true}}, SHIFT(257),
  [424] = {.entry = {.count = 1, .reusable = false}}, SHIFT(257),
  [426] = {.entry = {.count = 1, .reusable = false}}, SHIFT(488),
  [428] = {.entry = {.count = 1, .reusable = true}}, SHIFT(488),
  [430] = {.entry = {.count = 1, .reusable = false}}, SHIFT(309),
  [432] = {.entry = {.count = 1, .reusable = true}}, SHIFT(188),
  [434] = {.entry = {.count = 1, .reusable = true}}, SHIFT(189),
  [436] = {.entry = {.count = 1, .reusable = true}}, SHIFT(191),
  [438] = {.entry = {.count = 1, .reusable = true}}, SHIFT(192),
  [440] = {.entry = {.count = 1, .reusable = true}}, SHIFT(193),
  [442] = {.entry = {.count = 1, .reusable = true}}, SHIFT(194),
  [444] = {.entry = {.count = 1, .reusable = false}}, SHIFT(195),
  [446] = {.entry = {.count = 1, .reusable = true}}, SHIFT(30),
  [448] = {.entry = {.count = 1, .reusable = true}}, SHIFT(393),
  [450] = {.entry = {.count = 1, .reusable = false}}, SHIFT(393),
  [452] = {.entry = {.count = 1, .reusable = true}}, SHIFT(119),
  [454] = {.entry = {.count = 1, .reusable = true}}, SHIFT(405),
  [456] = {.entry = {.count = 1, .reusable = false}}, SHIFT(405),
  [458] = {.entry = {.count = 1, .reusable = true}}, SHIFT(369),
  [460] = {.entry = {.count = 1, .reusable = false}}, SHIFT(369),
  [462] = {.entry = {.count = 1, .reusable = true}}, SHIFT(399),
  [464] = {.entry = {.count = 1, .reusable = false}}, SHIFT(399),
  [466] = {.entry = {.count = 1, .reusable = true}}, SHIFT(412),
  [468] = {.entry = {.count = 1, .reusable = false}}, SHIFT(412),
  [470] = {.entry = {.count = 1, .reusable = true}}, SHIFT(414),
  [472] = {.entry = {.count = 1, .reusable = false}}, SHIFT(414),
  [474] = {.entry = {.count = 1, .reusable = true}}, SHIFT(415),
  [476] = {.entry = {.count = 1, .reusable = false}}, SHIFT(415),
  [478] = {.entry = {.count = 1, .reusable = true}}, SHIFT(416),
  [480] = {.entry = {.count = 1, .reusable = false}}, SHIFT(416),
  [482] = {.entry = {.count = 1, .reusable = true}}, SHIFT(419),
  [484] = {.entry = {.count = 1, .reusable = false}}, SHIFT(419),
  [486] = {.entry = {.count = 1, .reusable = true}}, SHIFT(34),
  [488] = {.entry = {.count = 1, .reusable = true}}, SHIFT(409),
  [490] = {.entry = {.count = 1, .reusable = false}}, SHIFT(409),
  [492] = {.entry = {.count = 1, .reusable = true}}, SHIFT(386),
  [494] = {.entry = {.count = 1, .reusable = false}}, SHIFT(386),
  [496] = {.entry = {.count = 1, .reusable = true}}, SHIFT(21),
  [498] = {.entry = {.count = 1, .reusable = true}}, SHIFT(345),
  [500] = {.entry = {.count = 1, .reusable = false}}, SHIFT(345),
  [502] = {.entry = {.count = 1, .reusable = true}}, SHIFT(43),
  [504] = {.entry = {.count = 1, .reusable = true}}, SHIFT(371),
  [506] = {.entry = {.count = 1, .reusable = false}}, SHIFT(371),
  [508] = {.entry = {.count = 1, .reusable = true}}, SHIFT(45),
  [510] = {.entry = {.count = 1, .reusable = true}}, SHIFT(370),
  [512] = {.entry = {.count = 1, .reusable = false}}, SHIFT(370),
  [514] = {.entry = {.count = 1, .reusable = true}}, SHIFT(47),
  [516] = {.entry = {.count = 1, .reusable = true}}, SHIFT(367),
  [518] = {.entry = {.count = 1, .reusable = false}}, SHIFT(367),
  [520] = {.entry = {.count = 1, .reusable = true}}, SHIFT(48),
  [522] = {.entry = {.count = 1, .reusable = true}}, SHIFT(366),
  [524] = {.entry = {.count = 1, .reusable = false}}, SHIFT(366),
  [526] = {.entry = {.count = 1, .reusable = true}}, SHIFT(49),
  [528] = {.entry = {.count = 1, .reusable = true}}, SHIFT(355),
  [530] = {.entry = {.count = 1, .reusable = false}}, SHIFT(355),
  [532] = {.entry = {.count = 1, .reusable = true}}, SHIFT(50),
  [534] = {.entry = {.count = 1, .reusable = true}}, SHIFT(51),
  [536] = {.entry = {.count = 1, .reusable = true}}, SHIFT(270),
  [538] = {.entry = {.count = 1, .reusable = false}}, SHIFT(270),
  [540] = {.entry = {.count = 1, .reusable = true}}, SHIFT(271),
  [542] = {.entry = {.count = 1, .reusable = false}}, SHIFT(271),
  [544] = {.entry = {.count = 1, .reusable = true}}, SHIFT(62),
  [546] = {.entry = {.count = 1, .reusable = true}}, SHIFT(363),
  [548] = {.entry = {.count = 1, .reusable = false}}, SHIFT(363),
  [550] = {.entry = {.count = 1, .reusable = true}}, SHIFT(64),
  [552] = {.entry = {.count = 1, .reusable = true}}, SHIFT(361),
  [554] = {.entry = {.count = 1, .reusable = false}}, SHIFT(361),
  [556] = {.entry = {.count = 1, .reusable = true}}, SHIFT(108),
  [558] = {.entry = {.count = 1, .reusable = true}}, SHIFT(333),
  [560] = {.entry = {.count = 1, .reusable = false}}, SHIFT(333),
  [562] = {.entry = {.count = 1, .reusable = true}}, SHIFT(332),
  [564] = {.entry = {.count = 1, .reusable = false}}, SHIFT(332),
  [566] = {.entry = {.count = 1, .reusable = true}}, SHIFT(275),
  [568] = {.entry = {.count = 1, .reusable = false}}, SHIFT(275),
  [570] = {.entry = {.count = 1, .reusable = true}}, SHIFT(69),
  [572] = {.entry = {.count = 1, .reusable = true}}, SHIFT(331),
  [574] = {.entry = {.count = 1, .reusable = false}}, SHIFT(331),
  [576] = {.entry = {.count = 1, .reusable = true}}, SHIFT(276),
  [578] = {.entry = {.count = 1, .reusable = false}}, SHIFT(276),
  [580] = {.entry = {.count = 1, .reusable = true}}, SHIFT(329),
  [582] = {.entry = {.count = 1, .reusable = false}}, SHIFT(329),
  [584] = {.entry = {.count = 1, .reusable = true}}, SHIFT(214),
  [586] = {.entry = {.count = 1, .reusable = false}}, SHIFT(214),
  [588] = {.entry = {.count = 1, .reusable = true}}, SHIFT(327),
  [590] = {.entry = {.count = 1, .reusable = false}}, SHIFT(327),
  [592] = {.entry = {.count = 1, .reusable = true}}, SHIFT(277),
  [594] = {.entry = {.count = 1, .reusable = false}}, SHIFT(277),
  [596] = {.entry = {.count = 1, .reusable = true}}, SHIFT(411),
  [598] = {.entry = {.count = 1, .reusable = false}}, SHIFT(411),
  [600] = {.entry = {.count = 1, .reusable = true}}, SHIFT(278),
  [602] = {.entry = {.count = 1, .reusable = false}}, SHIFT(278),
  [604] = {.entry = {.count = 1, .reusable = true}}, SHIFT(385),
  [606] = {.entry = {.count = 1, .reusable = false}}, SHIFT(385),
  [608] = {.entry = {.count = 1, .reusable = true}}, SHIFT(335),
  [610] = {.entry = {.count = 1, .reusable = false}}, SHIFT(335),
  [612] = {.entry = {.count = 1, .reusable = true}}, SHIFT(350),
  [614] = {.entry = {.count = 1, .reusable = false}}, SHIFT(350),
  [616] = {.entry = {.count = 1, .reusable = true}}, SHIFT(73),
  [618] = {.entry = {.count = 1, .reusable = true}}, SHIFT(75),
  [620] = {.entry = {.count = 1, .reusable = true}}, SHIFT(138),
  [622] = {.entry = {.count = 1, .reusable = true}}, SHIFT(283),
  [624] = {.entry = {.count = 1, .reusable = false}}, SHIFT(283),
  [626] = {.entry = {.count = 1, .reusable = true}}, SHIFT(144),
  [628] = {.entry = {.count = 1, .reusable = true}}, SHIFT(287),
  [630] = {.entry = {.count = 1, .reusable = false}}, SHIFT(287),
  [632] = {.entry = {.count = 1, .reusable = true}}, SHIFT(146),
  [634] = {.entry = {.count = 1, .reusable = true}}, SHIFT(289),
  [636] = {.entry = {.count = 1, .reusable = false}}, SHIFT(289),
  [638] = {.entry = {.count = 1, .reusable = true}}, SHIFT(148),
  [640] = {.entry = {.count = 1, .reusable = true}}, SHIFT(290),
  [642] = {.entry = {.count = 1, .reusable = false}}, SHIFT(290),
  [644] = {.entry = {.count = 1, .reusable = true}}, SHIFT(150),
  [646] = {.entry = {.count = 1, .reusable = true}}, SHIFT(291),
  [648] = {.entry = {.count = 1, .reusable = false}}, SHIFT(291),
  [650] = {.entry = {.count = 1, .reusable = true}}, SHIFT(152),
  [652] = {.entry = {.count = 1, .reusable = true}}, SHIFT(263),
  [654] = {.entry = {.count = 1, .reusable = false}}, SHIFT(263),
  [656] = {.entry = {.count = 1, .reusable = true}}, SHIFT(77),
  [658] = {.entry = {.count = 1, .reusable = true}}, SHIFT(79),
  [660] = {.entry = {.count = 1, .reusable = true}}, SHIFT(80),
  [662] = {.entry = {.count = 1, .reusable = true}}, SHIFT(81),
  [664] = {.entry = {.count = 1, .reusable = true}}, SHIFT(82),
  [666] = {.entry = {.count = 1, .reusable = true}}, SHIFT(83),
  [668] = {.entry = {.count = 1, .reusable = true}}, SHIFT(184),
  [670] = {.entry = {.count = 1, .reusable = true}}, SHIFT(39),
  [672] = {.entry = {.count = 1, .reusable = true}}, SHIFT(229),
  [674] = {.entry = {.count = 1, .reusable = false}}, SHIFT(229),
  [676] = {.entry = {.count = 1, .reusable = true}}, SHIFT(87),
  [678] = {.entry = {.count = 1, .reusable = true}}, SHIFT(99),
  [680] = {.entry = {.count = 1, .reusable = true}}, SHIFT(63),
  [682] = {.entry = {.count = 1, .reusable = true}}, SHIFT(239),
  [684] = {.entry = {.count = 1, .reusable = false}}, SHIFT(239),
  [686] = {.entry = {.count = 1, .reusable = true}}, SHIFT(100),
  [688] = {.entry = {.count = 1, .reusable = true}}, SHIFT(101),
  [690] = {.entry = {.count = 1, .reusable = true}}, SHIFT(102),
  [692] = {.entry = {.count = 1, .reusable = true}}, SHIFT(297),
  [694] = {.entry = {.count = 1, .reusable = false}}, SHIFT(297),
  [696] = {.entry = {.count = 1, .reusable = true}}, SHIFT(158),
  [698] = {.entry = {.count = 1, .reusable = true}}, SHIFT(298),
  [700] = {.entry = {.count = 1, .reusable = false}}, SHIFT(298),
  [702] = {.entry = {.count = 1, .reusable = true}}, SHIFT(103),
  [704] = {.entry = {.count = 1, .reusable = true}}, SHIFT(65),
  [706] = {.entry = {.count = 1, .reusable = true}}, SHIFT(240),
  [708] = {.entry = {.count = 1, .reusable = false}}, SHIFT(240),
  [710] = {.entry = {.count = 1, .reusable = true}}, SHIFT(31),
  [712] = {.entry = {.count = 1, .reusable = true}}, SHIFT(120),
  [714] = {.entry = {.count = 1, .reusable = true}}, SHIFT(167),
  [716] = {.entry = {.count = 1, .reusable = false}}, SHIFT(485),
  [718] = {.entry = {.count = 1, .reusable = true}}, SHIFT(485),
  [720] = {.entry = {.count = 1, .reusable = false}}, SHIFT(308),
  [722] = {.entry = {.count = 1, .reusable = true}}, SHIFT(174),
  [724] = {.entry = {.count = 1, .reusable = true}}, SHIFT(173),
  [726] = {.entry = {.count = 1, .reusable = true}}, SHIFT(172),
  [728] = {.entry = {.count = 1, .reusable = true}}, SHIFT(171),
  [730] = {.entry = {.count = 1, .reusable = true}}, SHIFT(170),
  [732] = {.entry = {.count = 1, .reusable = true}}, SHIFT(169),
  [734] = {.entry = {.count = 1, .reusable = false}}, SHIFT(168),
  [736] = {.entry = {.count = 1, .reusable = true}}, SHIFT(288),
  [738] = {.entry = {.count = 1, .reusable = false}}, SHIFT(288),
  [740] = {.entry = {.count = 1, .reusable = true}}, SHIFT(125),
  [742] = {.entry = {.count = 1, .reusable = true}}, SHIFT(292),
  [744] = {.entry = {.count = 1, .reusable = false}}, SHIFT(292),
  [746] = {.entry = {.count = 1, .reusable = true}}, SHIFT(225),
  [748] = {.entry = {.count = 1, .reusable = false}}, SHIFT(225),
  [750] = {.entry = {.count = 1, .reusable = true}}, SHIFT(265),
  [752] = {.entry = {.count = 1, .reusable = false}}, SHIFT(265),
  [754] = {.entry = {.count = 1, .reusable = true}}, SHIFT(163),
  [756] = {.entry = {.count = 1, .reusable = true}}, SHIFT(222),
  [758] = {.entry = {.count = 1, .reusable = false}}, SHIFT(222),
  [760] = {.entry = {.count = 1, .reusable = true}}, SHIFT(300),
  [762] = {.entry = {.count = 1, .reusable = false}}, SHIFT(300),
  [764] = {.entry = {.count = 1, .reusable = true}}, SHIFT(274),
  [766] = {.entry = {.count = 1, .reusable = false}}, SHIFT(274),
  [768] = {.entry = {.count = 1, .reusable = true}}, SHIFT(250),
  [770] = {.entry = {.count = 1, .reusable = false}}, SHIFT(250),
  [772] = {.entry = {.count = 1, .reusable = true}}, SHIFT(249),
  [774] = {.entry = {.count = 1, .reusable = false}}, SHIFT(249),
  [776] = {.entry = {.count = 1, .reusable = true}}, SHIFT(243),
  [778] = {.entry = {.count = 1, .reusable = false}}, SHIFT(243),
  [780] = {.entry = {.count = 1, .reusable = true}}, SHIFT(224),
  [782] = {.entry = {.count = 1, .reusable = false}}, SHIFT(224),
  [784] = {.entry = {.count = 1, .reusable = true}}, SHIFT(127),
  [786] = {.entry = {.count = 1, .reusable = true}}, SHIFT(128),
  [788] = {.entry = {.count = 1, .reusable = true}}, SHIFT(130),
  [790] = {.entry = {.count = 1, .reusable = true}}, SHIFT(131),
  [792] = {.entry = {.count = 1, .reusable = true}}, SHIFT(132),
  [794] = {.entry = {.count = 1, .reusable = true}}, SHIFT(133),
  [796] = {.entry = {.count = 1, .reusable = true}}, SHIFT(134),
  [798] = {.entry = {.count = 1, .reusable = true}}, SHIFT(135),
  [800] = {.entry = {.count = 1, .reusable = true}}, SHIFT(139),
  [802] = {.entry = {.count = 1, .reusable = true}}, SHIFT(46),
  [804] = {.entry = {.count = 1, .reusable = true}}, SHIFT(44),
  [806] = {.entry = {.count = 1, .reusable = true}}, SHIFT(183),
  [808] = {.entry = {.count = 1, .reusable = true}}, SHIFT(151),
  [810] = {.entry = {.count = 1, .reusable = true}}, SHIFT(153),
  [812] = {.entry = {.count = 1, .reusable = true}}, SHIFT(154),
  [814] = {.entry = {.count = 1, .reusable = true}}, SHIFT(155),
  [816] = {.entry = {.count = 1, .reusable = true}}, SHIFT(156),
  [818] = {.entry = {.count = 1, .reusable = true}}, SHIFT(157),
  [820] = {.entry = {.count = 1, .reusable = true}}, SHIFT(159),
  [822] = {.entry = {.count = 1, .reusable = true}}, SHIFT(176),
  [824] = {.entry = {.count = 1, .reusable = true}}, SHIFT(53),
  [826] = {.entry = {.count = 1, .reusable = true}}, SHIFT(201),
  [828] = {.entry = {.count = 1, .reusable = true}}, SHIFT(179),
  [830] = {.entry = {.count = 1, .reusable = true}}, SHIFT(40),
  [832] = {.entry = {.count = 1, .reusable = true}}, SHIFT(198),
  [834] = {.entry = {.count = 1, .reusable = true}}, SHIFT(203),
  [836] = {.entry = {.count = 1, .reusable = true}}, SHIFT(205),
  [838] = {.entry = {.count = 1, .reusable = true}}, SHIFT(207),
  [840] = {.entry = {.count = 1, .reusable = true}}, SHIFT(210),
  [842] = {.entry = {.count = 1, .reusable = true}}, SHIFT(212),
  [844] = {.entry = {.count = 1, .reusable = true}}, SHIFT(181),
  [846] = {.entry = {.count = 1, .reusable = true}}, SHIFT(196),
  [848] = {.entry = {.count = 1, .reusable = true}}, SHIFT(182),
  [850] = {.entry = {.count = 1, .reusable = true}}, SHIFT(190),
  [852] = {.entry = {.count = 1, .reusable = true}}, SHIFT(187),
  [854] = {.entry = {.count = 1, .reusable = true}}, SHIFT(199),
  [856] = {.entry = {.count = 1, .reusable = true}}, SHIFT(186),
  [858] = {.entry = {.count = 1, .reusable = true}}, SHIFT(185),
  [860] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_kwd_lit, 2, .production_id = 8),
  [862] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_kwd_lit, 2, .production_id = 8),
  [864] = {.entry = {.count = 1, .reusable = false}}, SHIFT(259),
  [866] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_syn_quoting_lit, 3, .production_id = 17),
  [868] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_syn_quoting_lit, 3, .production_id = 17),
  [870] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__bare_set_lit, 3, .production_id = 22),
  [872] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__bare_set_lit, 3, .production_id = 22),
  [874] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_str_lit, 1),
  [876] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_str_lit, 1),
  [878] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_sym_lit, 1, .production_id = 1),
  [880] = {.entry = {.count = 1, .reusable = true}}, SHIFT(491),
  [882] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_sym_lit, 1, .production_id = 1),
  [884] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_list_lit, 1, .production_id = 5),
  [886] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_list_lit, 1, .production_id = 5),
  [888] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_map_lit, 1, .production_id = 5),
  [890] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_map_lit, 1, .production_id = 5),
  [892] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_read_cond_lit, 4, .production_id = 36),
  [894] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_read_cond_lit, 4, .production_id = 36),
  [896] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_ns_map_lit, 5, .production_id = 39),
  [898] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_ns_map_lit, 5, .production_id = 39),
  [900] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_tagged_or_ctor_lit, 4, .production_id = 35),
  [902] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_tagged_or_ctor_lit, 4, .production_id = 35),
  [904] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_splicing_read_cond_lit, 4, .production_id = 36),
  [906] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_splicing_read_cond_lit, 4, .production_id = 36),
  [908] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_var_quoting_lit, 4, .production_id = 37),
  [910] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_var_quoting_lit, 4, .production_id = 37),
  [912] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_tagged_or_ctor_lit, 5, .production_id = 40),
  [914] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_tagged_or_ctor_lit, 5, .production_id = 40),
  [916] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_vec_lit, 1, .production_id = 5),
  [918] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_vec_lit, 1, .production_id = 5),
  [920] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_set_lit, 1, .production_id = 6),
  [922] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_set_lit, 1, .production_id = 6),
  [924] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_evaling_lit, 4, .production_id = 37),
  [926] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_evaling_lit, 4, .production_id = 37),
  [928] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_dis_expr, 2, .production_id = 7),
  [930] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_dis_expr, 2, .production_id = 7),
  [932] = {.entry = {.count = 1, .reusable = true}}, SHIFT(494),
  [934] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__bare_list_lit, 2, .production_id = 9),
  [936] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__bare_list_lit, 2, .production_id = 9),
  [938] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__bare_map_lit, 2, .production_id = 9),
  [940] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__bare_map_lit, 2, .production_id = 9),
  [942] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__bare_vec_lit, 2, .production_id = 9),
  [944] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__bare_vec_lit, 2, .production_id = 9),
  [946] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_regex_lit, 2, .production_id = 11),
  [948] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_regex_lit, 2, .production_id = 11),
  [950] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_anon_fn_lit, 2, .production_id = 12),
  [952] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_anon_fn_lit, 2, .production_id = 12),
  [954] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_read_cond_lit, 2, .production_id = 12),
  [956] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_read_cond_lit, 2, .production_id = 12),
  [958] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_splicing_read_cond_lit, 2, .production_id = 12),
  [960] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_splicing_read_cond_lit, 2, .production_id = 12),
  [962] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_var_quoting_lit, 2, .production_id = 7),
  [964] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_var_quoting_lit, 2, .production_id = 7),
  [966] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_sym_val_lit, 2, .production_id = 7),
  [968] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_sym_val_lit, 2, .production_id = 7),
  [970] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_evaling_lit, 2, .production_id = 7),
  [972] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_evaling_lit, 2, .production_id = 7),
  [974] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_derefing_lit, 4, .production_id = 37),
  [976] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_derefing_lit, 4, .production_id = 37),
  [978] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_derefing_lit, 2, .production_id = 7),
  [980] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_derefing_lit, 2, .production_id = 7),
  [982] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_quoting_lit, 2, .production_id = 7),
  [984] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_quoting_lit, 2, .production_id = 7),
  [986] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_syn_quoting_lit, 2, .production_id = 7),
  [988] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_syn_quoting_lit, 2, .production_id = 7),
  [990] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_unquote_splicing_lit, 2, .production_id = 7),
  [992] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_unquote_splicing_lit, 2, .production_id = 7),
  [994] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_unquoting_lit, 2, .production_id = 7),
  [996] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_unquoting_lit, 2, .production_id = 7),
  [998] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_quoting_lit, 4, .production_id = 37),
  [1000] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_quoting_lit, 4, .production_id = 37),
  [1002] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_syn_quoting_lit, 4, .production_id = 37),
  [1004] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_syn_quoting_lit, 4, .production_id = 37),
  [1006] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_sym_lit, 2, .production_id = 13),
  [1008] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_sym_lit, 2, .production_id = 13),
  [1010] = {.entry = {.count = 1, .reusable = true}}, SHIFT(489),
  [1012] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_list_lit, 2, .production_id = 14),
  [1014] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_list_lit, 2, .production_id = 14),
  [1016] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_map_lit, 2, .production_id = 14),
  [1018] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_map_lit, 2, .production_id = 14),
  [1020] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_vec_lit, 2, .production_id = 14),
  [1022] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_vec_lit, 2, .production_id = 14),
  [1024] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_set_lit, 2, .production_id = 15),
  [1026] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_set_lit, 2, .production_id = 15),
  [1028] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_dis_expr, 3, .production_id = 17),
  [1030] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_dis_expr, 3, .production_id = 17),
  [1032] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_ns_map_lit, 4, .production_id = 34),
  [1034] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_ns_map_lit, 4, .production_id = 34),
  [1036] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_kwd_lit, 3, .production_id = 18),
  [1038] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_kwd_lit, 3, .production_id = 18),
  [1040] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_sym_lit, 3, .production_id = 19),
  [1042] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_sym_lit, 3, .production_id = 19),
  [1044] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__bare_list_lit, 3, .production_id = 20),
  [1046] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__bare_list_lit, 3, .production_id = 20),
  [1048] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__bare_map_lit, 3, .production_id = 20),
  [1050] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__bare_map_lit, 3, .production_id = 20),
  [1052] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_unquoting_lit, 3, .production_id = 27),
  [1054] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_unquoting_lit, 3, .production_id = 27),
  [1056] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__bare_vec_lit, 3, .production_id = 20),
  [1058] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__bare_vec_lit, 3, .production_id = 20),
  [1060] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_tagged_or_ctor_lit, 5, .production_id = 38),
  [1062] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_tagged_or_ctor_lit, 5, .production_id = 38),
  [1064] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_ns_map_lit, 3, .production_id = 23),
  [1066] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_ns_map_lit, 3, .production_id = 23),
  [1068] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_tagged_or_ctor_lit, 3, .production_id = 24),
  [1070] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_tagged_or_ctor_lit, 3, .production_id = 24),
  [1072] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_read_cond_lit, 3, .production_id = 25),
  [1074] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_read_cond_lit, 3, .production_id = 25),
  [1076] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_splicing_read_cond_lit, 3, .production_id = 25),
  [1078] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_splicing_read_cond_lit, 3, .production_id = 25),
  [1080] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_var_quoting_lit, 3, .production_id = 17),
  [1082] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_var_quoting_lit, 3, .production_id = 17),
  [1084] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_sym_val_lit, 3, .production_id = 17),
  [1086] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_sym_val_lit, 3, .production_id = 17),
  [1088] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_evaling_lit, 3, .production_id = 17),
  [1090] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_evaling_lit, 3, .production_id = 17),
  [1092] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_unquote_splicing_lit, 4, .production_id = 37),
  [1094] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_unquote_splicing_lit, 4, .production_id = 37),
  [1096] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_derefing_lit, 3, .production_id = 17),
  [1098] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_derefing_lit, 3, .production_id = 17),
  [1100] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_quoting_lit, 3, .production_id = 17),
  [1102] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_quoting_lit, 3, .production_id = 17),
  [1104] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_unquote_splicing_lit, 3, .production_id = 17),
  [1106] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_unquote_splicing_lit, 3, .production_id = 17),
  [1108] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_unquoting_lit, 3, .production_id = 17),
  [1110] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_unquoting_lit, 3, .production_id = 17),
  [1112] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_anon_fn_lit, 3, .production_id = 26),
  [1114] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_anon_fn_lit, 3, .production_id = 26),
  [1116] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_read_cond_lit, 3, .production_id = 26),
  [1118] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_read_cond_lit, 3, .production_id = 26),
  [1120] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_splicing_read_cond_lit, 3, .production_id = 26),
  [1122] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_splicing_read_cond_lit, 3, .production_id = 26),
  [1124] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_var_quoting_lit, 3, .production_id = 27),
  [1126] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_var_quoting_lit, 3, .production_id = 27),
  [1128] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_evaling_lit, 3, .production_id = 27),
  [1130] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_evaling_lit, 3, .production_id = 27),
  [1132] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_derefing_lit, 3, .production_id = 27),
  [1134] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_derefing_lit, 3, .production_id = 27),
  [1136] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_tagged_or_ctor_lit, 6, .production_id = 42),
  [1138] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_tagged_or_ctor_lit, 6, .production_id = 42),
  [1140] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_quoting_lit, 3, .production_id = 27),
  [1142] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_quoting_lit, 3, .production_id = 27),
  [1144] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_syn_quoting_lit, 3, .production_id = 27),
  [1146] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_syn_quoting_lit, 3, .production_id = 27),
  [1148] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_unquote_splicing_lit, 3, .production_id = 27),
  [1150] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_unquote_splicing_lit, 3, .production_id = 27),
  [1152] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_tagged_or_ctor_lit, 5, .production_id = 41),
  [1154] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_tagged_or_ctor_lit, 5, .production_id = 41),
  [1156] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_kwd_lit, 4, .production_id = 28),
  [1158] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_kwd_lit, 4, .production_id = 28),
  [1160] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__bare_set_lit, 4, .production_id = 29),
  [1162] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__bare_set_lit, 4, .production_id = 29),
  [1164] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_ns_map_lit, 4, .production_id = 30),
  [1166] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_ns_map_lit, 4, .production_id = 30),
  [1168] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_tagged_or_ctor_lit, 4, .production_id = 31),
  [1170] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_tagged_or_ctor_lit, 4, .production_id = 31),
  [1172] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_tagged_or_ctor_lit, 4, .production_id = 32),
  [1174] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_tagged_or_ctor_lit, 4, .production_id = 32),
  [1176] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_sym_lit, 4, .production_id = 33),
  [1178] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_sym_lit, 4, .production_id = 33),
  [1180] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_unquoting_lit, 4, .production_id = 37),
  [1182] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_unquoting_lit, 4, .production_id = 37),
  [1184] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_dis_expr_repeat1, 2), SHIFT_REPEAT(301),
  [1187] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_dis_expr_repeat1, 2), SHIFT_REPEAT(106),
  [1190] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_dis_expr_repeat1, 2),
  [1192] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_dis_expr_repeat1, 2),
  [1194] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__bare_list_lit_repeat1, 1, .production_id = 10),
  [1196] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym__bare_list_lit_repeat1, 1, .production_id = 10),
  [1198] = {.entry = {.count = 1, .reusable = true}}, SHIFT(251),
  [1200] = {.entry = {.count = 1, .reusable = true}}, SHIFT(252),
  [1202] = {.entry = {.count = 1, .reusable = false}}, SHIFT(322),
  [1204] = {.entry = {.count = 1, .reusable = false}}, SHIFT(474),
  [1206] = {.entry = {.count = 1, .reusable = true}}, SHIFT(469),
  [1208] = {.entry = {.count = 1, .reusable = true}}, SHIFT(149),
  [1210] = {.entry = {.count = 1, .reusable = true}}, SHIFT(422),
  [1212] = {.entry = {.count = 1, .reusable = true}}, SHIFT(147),
  [1214] = {.entry = {.count = 1, .reusable = true}}, SHIFT(145),
  [1216] = {.entry = {.count = 1, .reusable = true}}, SHIFT(143),
  [1218] = {.entry = {.count = 1, .reusable = true}}, SHIFT(142),
  [1220] = {.entry = {.count = 1, .reusable = false}}, SHIFT(141),
  [1222] = {.entry = {.count = 1, .reusable = true}}, SHIFT(372),
  [1224] = {.entry = {.count = 1, .reusable = true}}, SHIFT(373),
  [1226] = {.entry = {.count = 1, .reusable = false}}, SHIFT(321),
  [1228] = {.entry = {.count = 1, .reusable = false}}, SHIFT(468),
  [1230] = {.entry = {.count = 1, .reusable = true}}, SHIFT(481),
  [1232] = {.entry = {.count = 1, .reusable = true}}, SHIFT(98),
  [1234] = {.entry = {.count = 1, .reusable = true}}, SHIFT(375),
  [1236] = {.entry = {.count = 1, .reusable = true}}, SHIFT(97),
  [1238] = {.entry = {.count = 1, .reusable = true}}, SHIFT(96),
  [1240] = {.entry = {.count = 1, .reusable = true}}, SHIFT(95),
  [1242] = {.entry = {.count = 1, .reusable = true}}, SHIFT(94),
  [1244] = {.entry = {.count = 1, .reusable = false}}, SHIFT(93),
  [1246] = {.entry = {.count = 1, .reusable = false}}, SHIFT(318),
  [1248] = {.entry = {.count = 1, .reusable = true}}, SHIFT(86),
  [1250] = {.entry = {.count = 1, .reusable = true}}, SHIFT(88),
  [1252] = {.entry = {.count = 1, .reusable = true}}, SHIFT(89),
  [1254] = {.entry = {.count = 1, .reusable = true}}, SHIFT(90),
  [1256] = {.entry = {.count = 1, .reusable = true}}, SHIFT(91),
  [1258] = {.entry = {.count = 1, .reusable = false}}, SHIFT(92),
  [1260] = {.entry = {.count = 1, .reusable = false}}, SHIFT(319),
  [1262] = {.entry = {.count = 1, .reusable = true}}, SHIFT(200),
  [1264] = {.entry = {.count = 1, .reusable = true}}, SHIFT(204),
  [1266] = {.entry = {.count = 1, .reusable = true}}, SHIFT(206),
  [1268] = {.entry = {.count = 1, .reusable = true}}, SHIFT(209),
  [1270] = {.entry = {.count = 1, .reusable = true}}, SHIFT(211),
  [1272] = {.entry = {.count = 1, .reusable = false}}, SHIFT(105),
  [1274] = {.entry = {.count = 1, .reusable = false}}, SHIFT(320),
  [1276] = {.entry = {.count = 1, .reusable = true}}, SHIFT(42),
  [1278] = {.entry = {.count = 1, .reusable = true}}, SHIFT(41),
  [1280] = {.entry = {.count = 1, .reusable = true}}, SHIFT(38),
  [1282] = {.entry = {.count = 1, .reusable = true}}, SHIFT(37),
  [1284] = {.entry = {.count = 1, .reusable = true}}, SHIFT(36),
  [1286] = {.entry = {.count = 1, .reusable = false}}, SHIFT(35),
  [1288] = {.entry = {.count = 1, .reusable = true}}, SHIFT(428),
  [1290] = {.entry = {.count = 1, .reusable = true}}, SHIFT(178),
  [1292] = {.entry = {.count = 1, .reusable = true}}, SHIFT(465),
  [1294] = {.entry = {.count = 1, .reusable = true}}, SHIFT(235),
  [1296] = {.entry = {.count = 1, .reusable = true}}, SHIFT(217),
  [1298] = {.entry = {.count = 1, .reusable = true}}, SHIFT(122),
  [1300] = {.entry = {.count = 1, .reusable = true}}, SHIFT(121),
  [1302] = {.entry = {.count = 1, .reusable = true}}, SHIFT(17),
  [1304] = {.entry = {.count = 1, .reusable = true}}, SHIFT(429),
  [1306] = {.entry = {.count = 1, .reusable = true}}, SHIFT(341),
  [1308] = {.entry = {.count = 1, .reusable = true}}, SHIFT(8),
  [1310] = {.entry = {.count = 1, .reusable = true}}, SHIFT(317),
  [1312] = {.entry = {.count = 1, .reusable = true}}, SHIFT(177),
  [1314] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__metadata_lit, 2, .production_id = 4),
  [1316] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__metadata_lit, 2, .production_id = 4),
  [1318] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__metadata_lit, 2, .production_id = 3),
  [1320] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__metadata_lit, 2, .production_id = 3),
  [1322] = {.entry = {.count = 1, .reusable = true}}, SHIFT(431),
  [1324] = {.entry = {.count = 1, .reusable = true}}, SHIFT(310),
  [1326] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__metadata_lit, 1, .production_id = 4),
  [1328] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__metadata_lit, 1, .production_id = 4),
  [1330] = {.entry = {.count = 1, .reusable = true}}, SHIFT(311),
  [1332] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__metadata_lit, 1, .production_id = 3),
  [1334] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__metadata_lit, 1, .production_id = 3),
  [1336] = {.entry = {.count = 1, .reusable = true}}, SHIFT(430),
  [1338] = {.entry = {.count = 1, .reusable = true}}, SHIFT(434),
  [1340] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_dis_expr_repeat1, 2), SHIFT_REPEAT(317),
  [1343] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_dis_expr_repeat1, 2), SHIFT_REPEAT(177),
  [1346] = {.entry = {.count = 1, .reusable = true}}, SHIFT(427),
  [1348] = {.entry = {.count = 1, .reusable = true}}, SHIFT(426),
  [1350] = {.entry = {.count = 1, .reusable = true}}, SHIFT(432),
  [1352] = {.entry = {.count = 1, .reusable = true}}, SHIFT(433),
  [1354] = {.entry = {.count = 1, .reusable = true}}, SHIFT(425),
  [1356] = {.entry = {.count = 1, .reusable = false}}, SHIFT(387),
  [1358] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_sym_lit_repeat1, 2, .production_id = 16),
  [1360] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_sym_lit_repeat1, 2, .production_id = 16), SHIFT_REPEAT(164),
  [1363] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_sym_lit_repeat1, 2, .production_id = 16), SHIFT_REPEAT(162),
  [1366] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_sym_lit_repeat1, 2, .production_id = 16),
  [1368] = {.entry = {.count = 1, .reusable = true}}, SHIFT(490),
  [1370] = {.entry = {.count = 1, .reusable = true}}, SHIFT(383),
  [1372] = {.entry = {.count = 1, .reusable = true}}, SHIFT(68),
  [1374] = {.entry = {.count = 1, .reusable = true}}, SHIFT(67),
  [1376] = {.entry = {.count = 1, .reusable = true}}, SHIFT(66),
  [1378] = {.entry = {.count = 1, .reusable = true}}, SHIFT(478),
  [1380] = {.entry = {.count = 1, .reusable = true}}, SHIFT(439),
  [1382] = {.entry = {.count = 1, .reusable = true}}, SHIFT(388),
  [1384] = {.entry = {.count = 1, .reusable = true}}, SHIFT(480),
  [1386] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_meta_lit, 2, .production_id = 7),
  [1388] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_meta_lit, 2, .production_id = 7),
  [1390] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_old_meta_lit, 2, .production_id = 7),
  [1392] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_old_meta_lit, 2, .production_id = 7),
  [1394] = {.entry = {.count = 1, .reusable = true}}, SHIFT(495),
  [1396] = {.entry = {.count = 1, .reusable = true}}, SHIFT(394),
  [1398] = {.entry = {.count = 1, .reusable = true}}, SHIFT(492),
  [1400] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_old_meta_lit, 3, .production_id = 17),
  [1402] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_old_meta_lit, 3, .production_id = 17),
  [1404] = {.entry = {.count = 1, .reusable = true}}, SHIFT(354),
  [1406] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_meta_lit, 3, .production_id = 17),
  [1408] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_meta_lit, 3, .production_id = 17),
  [1410] = {.entry = {.count = 1, .reusable = true}}, SHIFT(360),
  [1412] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_sym_lit_repeat1, 1, .production_id = 2),
  [1414] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_sym_lit_repeat1, 1, .production_id = 2),
  [1416] = {.entry = {.count = 1, .reusable = true}}, SHIFT(446),
  [1418] = {.entry = {.count = 1, .reusable = true}}, SHIFT(435),
  [1420] = {.entry = {.count = 1, .reusable = true}}, SHIFT(436),
  [1422] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_dis_expr_repeat1, 2), SHIFT_REPEAT(439),
  [1425] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_dis_expr_repeat1, 2), SHIFT_REPEAT(68),
  [1428] = {.entry = {.count = 1, .reusable = true}}, SHIFT(468),
  [1430] = {.entry = {.count = 1, .reusable = true}}, SHIFT(474),
  [1432] = {.entry = {.count = 1, .reusable = true}}, SHIFT(448),
  [1434] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_sym_lit_repeat1, 2, .production_id = 16), SHIFT_REPEAT(67),
  [1437] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_sym_lit_repeat1, 2, .production_id = 16), SHIFT_REPEAT(66),
  [1440] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_dis_expr_repeat1, 2), SHIFT_REPEAT(446),
  [1443] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_dis_expr_repeat1, 2), SHIFT_REPEAT(178),
  [1446] = {.entry = {.count = 1, .reusable = true}}, SHIFT(445),
  [1448] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_sym_lit_repeat1, 2, .production_id = 16), SHIFT_REPEAT(122),
  [1451] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_sym_lit_repeat1, 2, .production_id = 16), SHIFT_REPEAT(121),
  [1454] = {.entry = {.count = 1, .reusable = true}}, SHIFT(464),
  [1456] = {.entry = {.count = 1, .reusable = true}}, SHIFT(123),
  [1458] = {.entry = {.count = 1, .reusable = true}}, SHIFT(450),
  [1460] = {.entry = {.count = 1, .reusable = true}}, SHIFT(453),
  [1462] = {.entry = {.count = 1, .reusable = true}}, SHIFT(462),
  [1464] = {.entry = {.count = 1, .reusable = true}}, SHIFT(459),
  [1466] = {.entry = {.count = 1, .reusable = true}}, SHIFT(460),
  [1468] = {.entry = {.count = 1, .reusable = true}}, SHIFT(457),
  [1470] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_dis_expr_repeat1, 2), SHIFT_REPEAT(464),
  [1473] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_dis_expr_repeat1, 2), SHIFT_REPEAT(123),
  [1476] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_auto_res_mark, 1),
  [1478] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_auto_res_mark, 1),
  [1480] = {.entry = {.count = 1, .reusable = true}}, SHIFT(466),
  [1482] = {.entry = {.count = 1, .reusable = false}}, SHIFT(230),
  [1484] = {.entry = {.count = 1, .reusable = true}}, SHIFT(483),
  [1486] = {.entry = {.count = 1, .reusable = true}}, SHIFT(476),
  [1488] = {.entry = {.count = 1, .reusable = true}}, SHIFT(475),
  [1490] = {.entry = {.count = 1, .reusable = true}}, SHIFT(473),
  [1492] = {.entry = {.count = 1, .reusable = true}}, SHIFT(472),
  [1494] = {.entry = {.count = 1, .reusable = true}}, SHIFT(482),
  [1496] = {.entry = {.count = 1, .reusable = true}}, SHIFT(470),
  [1498] = {.entry = {.count = 1, .reusable = true}}, SHIFT(471),
  [1500] = {.entry = {.count = 1, .reusable = true}}, SHIFT(467),
  [1502] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_read_cond_lit_repeat1, 2), SHIFT_REPEAT(483),
  [1505] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_read_cond_lit_repeat1, 2),
  [1507] = {.entry = {.count = 1, .reusable = true}}, SHIFT(213),
  [1509] = {.entry = {.count = 1, .reusable = true}}, SHIFT(230),
  [1511] = {.entry = {.count = 1, .reusable = true}}, SHIFT(455),
  [1513] = {.entry = {.count = 1, .reusable = true}}, SHIFT(336),
  [1515] = {.entry = {.count = 1, .reusable = true}}, SHIFT(443),
  [1517] = {.entry = {.count = 1, .reusable = true}}, SHIFT(323),
  [1519] = {.entry = {.count = 1, .reusable = true}}, SHIFT(299),
  [1521] = {.entry = {.count = 1, .reusable = true}}, SHIFT(346),
  [1523] = {.entry = {.count = 1, .reusable = true}}, SHIFT(260),
  [1525] = {.entry = {.count = 1, .reusable = true}}, SHIFT(395),
  [1527] = {.entry = {.count = 1, .reusable = true}},  ACCEPT_INPUT(),
  [1529] = {.entry = {.count = 1, .reusable = true}}, SHIFT(293),
  [1531] = {.entry = {.count = 1, .reusable = true}}, SHIFT(359),
};

#ifdef __cplusplus
extern "C" {
#endif
#ifdef _WIN32
#define extern __declspec(dllexport)
#endif

extern const TSLanguage *tree_sitter_clojure(void) {
  static const TSLanguage language = {
    .version = LANGUAGE_VERSION,
    .symbol_count = SYMBOL_COUNT,
    .alias_count = ALIAS_COUNT,
    .token_count = TOKEN_COUNT,
    .external_token_count = EXTERNAL_TOKEN_COUNT,
    .state_count = STATE_COUNT,
    .large_state_count = LARGE_STATE_COUNT,
    .production_id_count = PRODUCTION_ID_COUNT,
    .field_count = FIELD_COUNT,
    .max_alias_sequence_length = MAX_ALIAS_SEQUENCE_LENGTH,
    .parse_table = &ts_parse_table[0][0],
    .small_parse_table = ts_small_parse_table,
    .small_parse_table_map = ts_small_parse_table_map,
    .parse_actions = ts_parse_actions,
    .symbol_names = ts_symbol_names,
    .field_names = ts_field_names,
    .field_map_slices = ts_field_map_slices,
    .field_map_entries = ts_field_map_entries,
    .symbol_metadata = ts_symbol_metadata,
    .public_symbol_map = ts_symbol_map,
    .alias_map = ts_non_terminal_alias_map,
    .alias_sequences = &ts_alias_sequences[0][0],
    .lex_modes = ts_lex_modes,
    .lex_fn = ts_lex,
    .primary_state_ids = ts_primary_state_ids,
  };
  return &language;
}
#ifdef __cplusplus
}
#endif
