#include <tree_sitter/parser.h>

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#ifdef _MSC_VER
#pragma optimize("", off)
#elif defined(__clang__)
#pragma clang optimize off
#elif defined(__GNUC__)
#pragma GCC optimize ("O0")
#endif

#define LANGUAGE_VERSION 14
#define STATE_COUNT 419
#define LARGE_STATE_COUNT 71
#define SYMBOL_COUNT 437
#define ALIAS_COUNT 4
#define TOKEN_COUNT 367
#define EXTERNAL_TOKEN_COUNT 2
#define FIELD_COUNT 4
#define MAX_ALIAS_SEQUENCE_LENGTH 9
#define PRODUCTION_ID_COUNT 11

enum {
  sym_identifier = 1,
  anon_sym_DOTclass = 2,
  anon_sym_DOTsuper = 3,
  anon_sym_DOTsource = 4,
  anon_sym_DOTimplements = 5,
  anon_sym_DOTfield = 6,
  anon_sym_EQ = 7,
  anon_sym_DOTendfield = 8,
  anon_sym_DOTmethod = 9,
  anon_sym_DOTendmethod = 10,
  anon_sym_DOTannotation = 11,
  anon_sym_DOTendannotation = 12,
  anon_sym_system = 13,
  anon_sym_build = 14,
  anon_sym_runtime = 15,
  sym_annotation_key = 16,
  anon_sym_DOTsubannotation = 17,
  anon_sym_DOTendsubannotation = 18,
  anon_sym_DOTparam = 19,
  anon_sym_DOTendparam = 20,
  anon_sym_COMMA = 21,
  anon_sym_DOTparameter = 22,
  anon_sym_DOTendparameter = 23,
  anon_sym_LF = 24,
  anon_sym_nop = 25,
  anon_sym_move = 26,
  anon_sym_move_SLASHfrom16 = 27,
  anon_sym_move_SLASH16 = 28,
  anon_sym_move_DASHwide = 29,
  anon_sym_move_DASHwide_SLASHfrom16 = 30,
  anon_sym_move_DASHwide_SLASH16 = 31,
  anon_sym_move_DASHobject = 32,
  anon_sym_move_DASHobject_SLASHfrom16 = 33,
  anon_sym_move_DASHobject_SLASH16 = 34,
  anon_sym_move_DASHresult = 35,
  anon_sym_move_DASHresult_DASHwide = 36,
  anon_sym_move_DASHresult_DASHobject = 37,
  anon_sym_move_DASHexception = 38,
  anon_sym_return_DASHvoid = 39,
  anon_sym_return = 40,
  anon_sym_return_DASHwide = 41,
  anon_sym_return_DASHobject = 42,
  anon_sym_const_SLASH4 = 43,
  anon_sym_const_SLASH16 = 44,
  anon_sym_const = 45,
  anon_sym_const_SLASHhigh16 = 46,
  anon_sym_const_DASHwide_SLASH16 = 47,
  anon_sym_const_DASHwide_SLASH32 = 48,
  anon_sym_const_DASHwide = 49,
  anon_sym_const_DASHwide_SLASHhigh16 = 50,
  anon_sym_const_DASHstring = 51,
  anon_sym_const_DASHstring_SLASHjumbo = 52,
  anon_sym_const_DASHclass = 53,
  anon_sym_const_DASHmethod_DASHhandle = 54,
  anon_sym_const_DASHmethod_DASHtype = 55,
  anon_sym_monitor_DASHenter = 56,
  anon_sym_monitor_DASHexit = 57,
  anon_sym_check_DASHcast = 58,
  anon_sym_instance_DASHof = 59,
  anon_sym_array_DASHlength = 60,
  anon_sym_new_DASHinstance = 61,
  anon_sym_new_DASHarray = 62,
  anon_sym_filled_DASHnew_DASHarray = 63,
  anon_sym_filled_DASHnew_DASHarray_SLASHrange = 64,
  anon_sym_fill_DASHarray_DASHdata = 65,
  anon_sym_throw = 66,
  anon_sym_throw_DASHverification_DASHerror = 67,
  anon_sym_goto = 68,
  anon_sym_goto_SLASH16 = 69,
  anon_sym_goto_SLASH32 = 70,
  anon_sym_packed_DASHswitch = 71,
  anon_sym_sparse_DASHswitch = 72,
  anon_sym_cmpl_DASHfloat = 73,
  anon_sym_cmpg_DASHfloat = 74,
  anon_sym_cmpl_DASHdouble = 75,
  anon_sym_cmpg_DASHdouble = 76,
  anon_sym_cmp_DASHlong = 77,
  anon_sym_if_DASHeq = 78,
  anon_sym_if_DASHne = 79,
  anon_sym_if_DASHlt = 80,
  anon_sym_if_DASHge = 81,
  anon_sym_if_DASHgt = 82,
  anon_sym_if_DASHle = 83,
  anon_sym_if_DASHeqz = 84,
  anon_sym_if_DASHnez = 85,
  anon_sym_if_DASHltz = 86,
  anon_sym_if_DASHgez = 87,
  anon_sym_if_DASHgtz = 88,
  anon_sym_if_DASHlez = 89,
  anon_sym_aget = 90,
  anon_sym_aget_DASHwide = 91,
  anon_sym_aget_DASHobject = 92,
  anon_sym_aget_DASHboolean = 93,
  anon_sym_aget_DASHbyte = 94,
  anon_sym_aget_DASHchar = 95,
  anon_sym_aget_DASHshort = 96,
  anon_sym_aput = 97,
  anon_sym_aput_DASHwide = 98,
  anon_sym_aput_DASHobject = 99,
  anon_sym_aput_DASHboolean = 100,
  anon_sym_aput_DASHbyte = 101,
  anon_sym_aput_DASHchar = 102,
  anon_sym_aput_DASHshort = 103,
  anon_sym_iget = 104,
  anon_sym_iget_DASHwide = 105,
  anon_sym_iget_DASHobject = 106,
  anon_sym_iget_DASHboolean = 107,
  anon_sym_iget_DASHbyte = 108,
  anon_sym_iget_DASHchar = 109,
  anon_sym_iget_DASHshort = 110,
  anon_sym_iget_DASHvolatile = 111,
  anon_sym_iget_DASHwide_DASHvolatile = 112,
  anon_sym_iget_DASHobject_DASHvolatile = 113,
  anon_sym_iput = 114,
  anon_sym_iput_DASHwide = 115,
  anon_sym_iput_DASHobject = 116,
  anon_sym_iput_DASHboolean = 117,
  anon_sym_iput_DASHbyte = 118,
  anon_sym_iput_DASHchar = 119,
  anon_sym_iput_DASHshort = 120,
  anon_sym_iput_DASHvolatile = 121,
  anon_sym_iput_DASHwide_DASHvolatile = 122,
  anon_sym_iput_DASHobject_DASHvolatile = 123,
  anon_sym_sget = 124,
  anon_sym_sget_DASHwide = 125,
  anon_sym_sget_DASHobject = 126,
  anon_sym_sget_DASHboolean = 127,
  anon_sym_sget_DASHbyte = 128,
  anon_sym_sget_DASHchar = 129,
  anon_sym_sget_DASHshort = 130,
  anon_sym_sget_DASHvolatile = 131,
  anon_sym_sget_DASHwide_DASHvolatile = 132,
  anon_sym_sget_DASHobject_DASHvolatile = 133,
  anon_sym_sput = 134,
  anon_sym_sput_DASHwide = 135,
  anon_sym_sput_DASHobject = 136,
  anon_sym_sput_DASHboolean = 137,
  anon_sym_sput_DASHbyte = 138,
  anon_sym_sput_DASHchar = 139,
  anon_sym_sput_DASHshort = 140,
  anon_sym_sput_DASHvolatile = 141,
  anon_sym_sput_DASHwide_DASHvolatile = 142,
  anon_sym_sput_DASHobject_DASHvolatile = 143,
  anon_sym_invoke_DASHconstructor = 144,
  anon_sym_invoke_DASHcustom = 145,
  anon_sym_invoke_DASHdirect = 146,
  anon_sym_invoke_DASHdirect_DASHempty = 147,
  anon_sym_invoke_DASHinstance = 148,
  anon_sym_invoke_DASHinterface = 149,
  anon_sym_invoke_DASHpolymorphic = 150,
  anon_sym_invoke_DASHstatic = 151,
  anon_sym_invoke_DASHsuper = 152,
  anon_sym_invoke_DASHvirtual = 153,
  anon_sym_invoke_DASHcustom_SLASHrange = 154,
  anon_sym_invoke_DASHdirect_SLASHrange = 155,
  anon_sym_invoke_DASHinterface_SLASHrange = 156,
  anon_sym_invoke_DASHobject_DASHinit_SLASHrange = 157,
  anon_sym_invoke_DASHpolymorphic_SLASHrange = 158,
  anon_sym_invoke_DASHstatic_SLASHrange = 159,
  anon_sym_invoke_DASHsuper_SLASHrange = 160,
  anon_sym_invoke_DASHvirtual_SLASHrange = 161,
  anon_sym_neg_DASHint = 162,
  anon_sym_not_DASHint = 163,
  anon_sym_neg_DASHlong = 164,
  anon_sym_not_DASHlong = 165,
  anon_sym_neg_DASHfloat = 166,
  anon_sym_neg_DASHdouble = 167,
  anon_sym_int_DASHto_DASHlong = 168,
  anon_sym_int_DASHto_DASHfloat = 169,
  anon_sym_int_DASHto_DASHdouble = 170,
  anon_sym_long_DASHto_DASHint = 171,
  anon_sym_long_DASHto_DASHfloat = 172,
  anon_sym_long_DASHto_DASHdouble = 173,
  anon_sym_float_DASHto_DASHint = 174,
  anon_sym_float_DASHto_DASHlong = 175,
  anon_sym_float_DASHto_DASHdouble = 176,
  anon_sym_double_DASHto_DASHint = 177,
  anon_sym_double_DASHto_DASHlong = 178,
  anon_sym_double_DASHto_DASHfloat = 179,
  anon_sym_int_DASHto_DASHbyte = 180,
  anon_sym_int_DASHto_DASHchar = 181,
  anon_sym_int_DASHto_DASHshort = 182,
  anon_sym_add_DASHint = 183,
  anon_sym_sub_DASHint = 184,
  anon_sym_mul_DASHint = 185,
  anon_sym_div_DASHint = 186,
  anon_sym_rem_DASHint = 187,
  anon_sym_and_DASHint = 188,
  anon_sym_or_DASHint = 189,
  anon_sym_xor_DASHint = 190,
  anon_sym_shl_DASHint = 191,
  anon_sym_shr_DASHint = 192,
  anon_sym_ushr_DASHint = 193,
  anon_sym_add_DASHlong = 194,
  anon_sym_sub_DASHlong = 195,
  anon_sym_mul_DASHlong = 196,
  anon_sym_div_DASHlong = 197,
  anon_sym_rem_DASHlong = 198,
  anon_sym_and_DASHlong = 199,
  anon_sym_or_DASHlong = 200,
  anon_sym_xor_DASHlong = 201,
  anon_sym_shl_DASHlong = 202,
  anon_sym_shr_DASHlong = 203,
  anon_sym_ushr_DASHlong = 204,
  anon_sym_add_DASHfloat = 205,
  anon_sym_sub_DASHfloat = 206,
  anon_sym_mul_DASHfloat = 207,
  anon_sym_div_DASHfloat = 208,
  anon_sym_rem_DASHfloat = 209,
  anon_sym_add_DASHdouble = 210,
  anon_sym_sub_DASHdouble = 211,
  anon_sym_mul_DASHdouble = 212,
  anon_sym_div_DASHdouble = 213,
  anon_sym_rem_DASHdouble = 214,
  anon_sym_add_DASHint_SLASH2addr = 215,
  anon_sym_sub_DASHint_SLASH2addr = 216,
  anon_sym_mul_DASHint_SLASH2addr = 217,
  anon_sym_div_DASHint_SLASH2addr = 218,
  anon_sym_rem_DASHint_SLASH2addr = 219,
  anon_sym_and_DASHint_SLASH2addr = 220,
  anon_sym_or_DASHint_SLASH2addr = 221,
  anon_sym_xor_DASHint_SLASH2addr = 222,
  anon_sym_shl_DASHint_SLASH2addr = 223,
  anon_sym_shr_DASHint_SLASH2addr = 224,
  anon_sym_ushr_DASHint_SLASH2addr = 225,
  anon_sym_add_DASHlong_SLASH2addr = 226,
  anon_sym_sub_DASHlong_SLASH2addr = 227,
  anon_sym_mul_DASHlong_SLASH2addr = 228,
  anon_sym_div_DASHlong_SLASH2addr = 229,
  anon_sym_rem_DASHlong_SLASH2addr = 230,
  anon_sym_and_DASHlong_SLASH2addr = 231,
  anon_sym_or_DASHlong_SLASH2addr = 232,
  anon_sym_xor_DASHlong_SLASH2addr = 233,
  anon_sym_shl_DASHlong_SLASH2addr = 234,
  anon_sym_shr_DASHlong_SLASH2addr = 235,
  anon_sym_ushr_DASHlong_SLASH2addr = 236,
  anon_sym_add_DASHfloat_SLASH2addr = 237,
  anon_sym_sub_DASHfloat_SLASH2addr = 238,
  anon_sym_mul_DASHfloat_SLASH2addr = 239,
  anon_sym_div_DASHfloat_SLASH2addr = 240,
  anon_sym_rem_DASHfloat_SLASH2addr = 241,
  anon_sym_add_DASHdouble_SLASH2addr = 242,
  anon_sym_sub_DASHdouble_SLASH2addr = 243,
  anon_sym_mul_DASHdouble_SLASH2addr = 244,
  anon_sym_div_DASHdouble_SLASH2addr = 245,
  anon_sym_rem_DASHdouble_SLASH2addr = 246,
  anon_sym_add_DASHint_SLASHlit16 = 247,
  anon_sym_sub_DASHint_SLASHlit16 = 248,
  anon_sym_mul_DASHint_SLASHlit16 = 249,
  anon_sym_div_DASHint_SLASHlit16 = 250,
  anon_sym_rem_DASHint_SLASHlit16 = 251,
  anon_sym_and_DASHint_SLASHlit16 = 252,
  anon_sym_or_DASHint_SLASHlit16 = 253,
  anon_sym_xor_DASHint_SLASHlit16 = 254,
  anon_sym_add_DASHint_SLASHlit8 = 255,
  anon_sym_sub_DASHint_SLASHlit8 = 256,
  anon_sym_mul_DASHint_SLASHlit8 = 257,
  anon_sym_div_DASHint_SLASHlit8 = 258,
  anon_sym_rem_DASHint_SLASHlit8 = 259,
  anon_sym_and_DASHint_SLASHlit8 = 260,
  anon_sym_or_DASHint_SLASHlit8 = 261,
  anon_sym_xor_DASHint_SLASHlit8 = 262,
  anon_sym_shl_DASHint_SLASHlit8 = 263,
  anon_sym_shr_DASHint_SLASHlit8 = 264,
  anon_sym_ushr_DASHint_SLASHlit8 = 265,
  anon_sym_static_DASHget = 266,
  anon_sym_static_DASHput = 267,
  anon_sym_instance_DASHget = 268,
  anon_sym_instance_DASHput = 269,
  anon_sym_execute_DASHinline = 270,
  anon_sym_execute_DASHinline_SLASHrange = 271,
  anon_sym_iget_DASHquick = 272,
  anon_sym_iget_DASHwide_DASHquick = 273,
  anon_sym_iget_DASHobject_DASHquick = 274,
  anon_sym_iput_DASHquick = 275,
  anon_sym_iput_DASHwide_DASHquick = 276,
  anon_sym_iput_DASHobject_DASHquick = 277,
  anon_sym_iput_DASHboolean_DASHquick = 278,
  anon_sym_iput_DASHbyte_DASHquick = 279,
  anon_sym_iput_DASHchar_DASHquick = 280,
  anon_sym_iput_DASHshort_DASHquick = 281,
  anon_sym_invoke_DASHvirtual_DASHquick = 282,
  anon_sym_invoke_DASHvirtual_DASHquick_SLASHrange = 283,
  anon_sym_invoke_DASHsuper_DASHquick = 284,
  anon_sym_invoke_DASHsuper_DASHquick_SLASHrange = 285,
  anon_sym_rsub_DASHint = 286,
  anon_sym_rsub_DASHint_SLASHlit8 = 287,
  anon_sym_DOTline = 288,
  anon_sym_DOTlocals = 289,
  anon_sym_DOTlocal = 290,
  anon_sym_COLON = 291,
  anon_sym_DOTendlocal = 292,
  anon_sym_DOTrestartlocal = 293,
  anon_sym_DOTregisters = 294,
  anon_sym_DOTcatch = 295,
  anon_sym_LBRACE = 296,
  anon_sym_DOT_DOT = 297,
  anon_sym_RBRACE = 298,
  anon_sym_DOTcatchall = 299,
  anon_sym_DOTpacked_DASHswitch = 300,
  anon_sym_DOTendpacked_DASHswitch = 301,
  anon_sym_DOTsparse_DASHswitch = 302,
  anon_sym_DASH_GT = 303,
  anon_sym_DOTendsparse_DASHswitch = 304,
  anon_sym_DOTarray_DASHdata = 305,
  anon_sym_DOTendarray_DASHdata = 306,
  sym_prologue_directive = 307,
  sym_epilogue_directive = 308,
  anon_sym_SLASH = 309,
  anon_sym_SEMI = 310,
  aux_sym_label_token1 = 311,
  aux_sym_jmp_label_token1 = 312,
  anon_sym_DASH = 313,
  anon_sym_LPAREN = 314,
  anon_sym_RPAREN = 315,
  anon_sym_AT = 316,
  anon_sym_LBRACK = 317,
  aux_sym_primitive_type_token1 = 318,
  aux_sym_primitive_type_token2 = 319,
  anon_sym_constructor = 320,
  anon_sym_public = 321,
  anon_sym_private = 322,
  anon_sym_protected = 323,
  anon_sym_static = 324,
  anon_sym_final = 325,
  anon_sym_synchronized = 326,
  anon_sym_volatile = 327,
  anon_sym_bridge = 328,
  anon_sym_transient = 329,
  anon_sym_varargs = 330,
  anon_sym_native = 331,
  anon_sym_interface = 332,
  anon_sym_abstract = 333,
  anon_sym_strictfp = 334,
  anon_sym_synthetic = 335,
  anon_sym_annotation = 336,
  anon_sym_enum = 337,
  anon_sym_declared_DASHsynchronized = 338,
  anon_sym_whitelist = 339,
  anon_sym_greylist = 340,
  anon_sym_blacklist = 341,
  anon_sym_greylist_DASHmax_DASHo = 342,
  anon_sym_greylist_DASHmax_DASHp = 343,
  anon_sym_greylist_DASHmax_DASHq = 344,
  anon_sym_greylist_DASHmax_DASHr = 345,
  anon_sym_core_DASHplatform_DASHapi = 346,
  anon_sym_test_DASHapi = 347,
  anon_sym_DOTenum = 348,
  sym_variable = 349,
  sym_parameter = 350,
  sym_number = 351,
  sym_float = 352,
  sym_NaN = 353,
  sym_Infinity = 354,
  anon_sym_DQUOTE = 355,
  sym_string_fragment = 356,
  aux_sym__escape_sequence_token1 = 357,
  sym_escape_sequence = 358,
  anon_sym_true = 359,
  anon_sym_false = 360,
  anon_sym_SQUOTE = 361,
  aux_sym_character_token1 = 362,
  sym_null = 363,
  sym_comment = 364,
  sym_L = 365,
  sym__class_ident = 366,
  sym_class_definition = 367,
  sym_class_directive = 368,
  sym_super_directive = 369,
  sym_source_directive = 370,
  sym_implements_directive = 371,
  sym_field_definition = 372,
  sym_method_definition = 373,
  sym_annotation_directive = 374,
  sym_annotation_visibility = 375,
  sym_annotation_property = 376,
  sym_annotation_value = 377,
  sym_subannotation_directive = 378,
  sym_param_directive = 379,
  sym_parameter_directive = 380,
  sym_statement = 381,
  sym_expression = 382,
  sym_opcode = 383,
  sym_value = 384,
  sym_directive = 385,
  sym_line_directive = 386,
  sym_locals_directive = 387,
  sym_local_directive = 388,
  sym_end_local_directive = 389,
  sym_restart_local_directive = 390,
  sym_registers_directive = 391,
  sym_catch_directive = 392,
  sym_catchall_directive = 393,
  sym_packed_switch_directive = 394,
  sym_sparse_switch_directive = 395,
  sym_array_data_directive = 396,
  sym_class_identifier = 397,
  sym_label = 398,
  sym_jmp_label = 399,
  sym_body = 400,
  sym__field_body = 401,
  sym_method_signature = 402,
  sym__method_signature_body = 403,
  sym_method_handle = 404,
  sym__full_field_body = 405,
  sym_full_method_signature = 406,
  sym_custom_invoke = 407,
  sym_type = 408,
  sym_array_type = 409,
  sym_primitive_type = 410,
  sym_access_modifiers = 411,
  aux_sym__method_access_modifiers = 412,
  sym_access_modifier = 413,
  sym_enum_reference = 414,
  sym_register = 415,
  sym_list = 416,
  sym_range = 417,
  sym_literal = 418,
  sym_string = 419,
  sym__escape_sequence = 420,
  sym_boolean = 421,
  sym_character = 422,
  aux_sym_class_definition_repeat1 = 423,
  aux_sym_class_definition_repeat2 = 424,
  aux_sym_field_definition_repeat1 = 425,
  aux_sym_method_definition_repeat1 = 426,
  aux_sym_annotation_directive_repeat1 = 427,
  aux_sym_expression_repeat1 = 428,
  aux_sym_packed_switch_directive_repeat1 = 429,
  aux_sym_sparse_switch_directive_repeat1 = 430,
  aux_sym_array_data_directive_repeat1 = 431,
  aux_sym_class_identifier_repeat1 = 432,
  aux_sym__method_signature_body_repeat1 = 433,
  aux_sym_custom_invoke_repeat1 = 434,
  aux_sym_access_modifiers_repeat1 = 435,
  aux_sym_string_repeat1 = 436,
  alias_sym_field_identifier = 437,
  alias_sym_field_type = 438,
  alias_sym_param_identifier = 439,
  alias_sym_parameters = 440,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym_identifier] = "identifier",
  [anon_sym_DOTclass] = ".class",
  [anon_sym_DOTsuper] = ".super",
  [anon_sym_DOTsource] = ".source",
  [anon_sym_DOTimplements] = ".implements",
  [anon_sym_DOTfield] = ".field",
  [anon_sym_EQ] = "=",
  [anon_sym_DOTendfield] = ".end field",
  [anon_sym_DOTmethod] = ".method",
  [anon_sym_DOTendmethod] = ".end method",
  [anon_sym_DOTannotation] = ".annotation",
  [anon_sym_DOTendannotation] = ".end annotation",
  [anon_sym_system] = "system",
  [anon_sym_build] = "build",
  [anon_sym_runtime] = "runtime",
  [sym_annotation_key] = "annotation_key",
  [anon_sym_DOTsubannotation] = ".subannotation",
  [anon_sym_DOTendsubannotation] = ".end subannotation",
  [anon_sym_DOTparam] = ".param",
  [anon_sym_DOTendparam] = ".end param",
  [anon_sym_COMMA] = ",",
  [anon_sym_DOTparameter] = ".parameter",
  [anon_sym_DOTendparameter] = ".end parameter",
  [anon_sym_LF] = "\n",
  [anon_sym_nop] = "nop",
  [anon_sym_move] = "move",
  [anon_sym_move_SLASHfrom16] = "move/from16",
  [anon_sym_move_SLASH16] = "move/16",
  [anon_sym_move_DASHwide] = "move-wide",
  [anon_sym_move_DASHwide_SLASHfrom16] = "move-wide/from16",
  [anon_sym_move_DASHwide_SLASH16] = "move-wide/16",
  [anon_sym_move_DASHobject] = "move-object",
  [anon_sym_move_DASHobject_SLASHfrom16] = "move-object/from16",
  [anon_sym_move_DASHobject_SLASH16] = "move-object/16",
  [anon_sym_move_DASHresult] = "move-result",
  [anon_sym_move_DASHresult_DASHwide] = "move-result-wide",
  [anon_sym_move_DASHresult_DASHobject] = "move-result-object",
  [anon_sym_move_DASHexception] = "move-exception",
  [anon_sym_return_DASHvoid] = "return-void",
  [anon_sym_return] = "return",
  [anon_sym_return_DASHwide] = "return-wide",
  [anon_sym_return_DASHobject] = "return-object",
  [anon_sym_const_SLASH4] = "const/4",
  [anon_sym_const_SLASH16] = "const/16",
  [anon_sym_const] = "const",
  [anon_sym_const_SLASHhigh16] = "const/high16",
  [anon_sym_const_DASHwide_SLASH16] = "const-wide/16",
  [anon_sym_const_DASHwide_SLASH32] = "const-wide/32",
  [anon_sym_const_DASHwide] = "const-wide",
  [anon_sym_const_DASHwide_SLASHhigh16] = "const-wide/high16",
  [anon_sym_const_DASHstring] = "const-string",
  [anon_sym_const_DASHstring_SLASHjumbo] = "const-string/jumbo",
  [anon_sym_const_DASHclass] = "const-class",
  [anon_sym_const_DASHmethod_DASHhandle] = "const-method-handle",
  [anon_sym_const_DASHmethod_DASHtype] = "const-method-type",
  [anon_sym_monitor_DASHenter] = "monitor-enter",
  [anon_sym_monitor_DASHexit] = "monitor-exit",
  [anon_sym_check_DASHcast] = "check-cast",
  [anon_sym_instance_DASHof] = "instance-of",
  [anon_sym_array_DASHlength] = "array-length",
  [anon_sym_new_DASHinstance] = "new-instance",
  [anon_sym_new_DASHarray] = "new-array",
  [anon_sym_filled_DASHnew_DASHarray] = "filled-new-array",
  [anon_sym_filled_DASHnew_DASHarray_SLASHrange] = "filled-new-array/range",
  [anon_sym_fill_DASHarray_DASHdata] = "fill-array-data",
  [anon_sym_throw] = "throw",
  [anon_sym_throw_DASHverification_DASHerror] = "throw-verification-error",
  [anon_sym_goto] = "goto",
  [anon_sym_goto_SLASH16] = "goto/16",
  [anon_sym_goto_SLASH32] = "goto/32",
  [anon_sym_packed_DASHswitch] = "packed-switch",
  [anon_sym_sparse_DASHswitch] = "sparse-switch",
  [anon_sym_cmpl_DASHfloat] = "cmpl-float",
  [anon_sym_cmpg_DASHfloat] = "cmpg-float",
  [anon_sym_cmpl_DASHdouble] = "cmpl-double",
  [anon_sym_cmpg_DASHdouble] = "cmpg-double",
  [anon_sym_cmp_DASHlong] = "cmp-long",
  [anon_sym_if_DASHeq] = "if-eq",
  [anon_sym_if_DASHne] = "if-ne",
  [anon_sym_if_DASHlt] = "if-lt",
  [anon_sym_if_DASHge] = "if-ge",
  [anon_sym_if_DASHgt] = "if-gt",
  [anon_sym_if_DASHle] = "if-le",
  [anon_sym_if_DASHeqz] = "if-eqz",
  [anon_sym_if_DASHnez] = "if-nez",
  [anon_sym_if_DASHltz] = "if-ltz",
  [anon_sym_if_DASHgez] = "if-gez",
  [anon_sym_if_DASHgtz] = "if-gtz",
  [anon_sym_if_DASHlez] = "if-lez",
  [anon_sym_aget] = "aget",
  [anon_sym_aget_DASHwide] = "aget-wide",
  [anon_sym_aget_DASHobject] = "aget-object",
  [anon_sym_aget_DASHboolean] = "aget-boolean",
  [anon_sym_aget_DASHbyte] = "aget-byte",
  [anon_sym_aget_DASHchar] = "aget-char",
  [anon_sym_aget_DASHshort] = "aget-short",
  [anon_sym_aput] = "aput",
  [anon_sym_aput_DASHwide] = "aput-wide",
  [anon_sym_aput_DASHobject] = "aput-object",
  [anon_sym_aput_DASHboolean] = "aput-boolean",
  [anon_sym_aput_DASHbyte] = "aput-byte",
  [anon_sym_aput_DASHchar] = "aput-char",
  [anon_sym_aput_DASHshort] = "aput-short",
  [anon_sym_iget] = "iget",
  [anon_sym_iget_DASHwide] = "iget-wide",
  [anon_sym_iget_DASHobject] = "iget-object",
  [anon_sym_iget_DASHboolean] = "iget-boolean",
  [anon_sym_iget_DASHbyte] = "iget-byte",
  [anon_sym_iget_DASHchar] = "iget-char",
  [anon_sym_iget_DASHshort] = "iget-short",
  [anon_sym_iget_DASHvolatile] = "iget-volatile",
  [anon_sym_iget_DASHwide_DASHvolatile] = "iget-wide-volatile",
  [anon_sym_iget_DASHobject_DASHvolatile] = "iget-object-volatile",
  [anon_sym_iput] = "iput",
  [anon_sym_iput_DASHwide] = "iput-wide",
  [anon_sym_iput_DASHobject] = "iput-object",
  [anon_sym_iput_DASHboolean] = "iput-boolean",
  [anon_sym_iput_DASHbyte] = "iput-byte",
  [anon_sym_iput_DASHchar] = "iput-char",
  [anon_sym_iput_DASHshort] = "iput-short",
  [anon_sym_iput_DASHvolatile] = "iput-volatile",
  [anon_sym_iput_DASHwide_DASHvolatile] = "iput-wide-volatile",
  [anon_sym_iput_DASHobject_DASHvolatile] = "iput-object-volatile",
  [anon_sym_sget] = "sget",
  [anon_sym_sget_DASHwide] = "sget-wide",
  [anon_sym_sget_DASHobject] = "sget-object",
  [anon_sym_sget_DASHboolean] = "sget-boolean",
  [anon_sym_sget_DASHbyte] = "sget-byte",
  [anon_sym_sget_DASHchar] = "sget-char",
  [anon_sym_sget_DASHshort] = "sget-short",
  [anon_sym_sget_DASHvolatile] = "sget-volatile",
  [anon_sym_sget_DASHwide_DASHvolatile] = "sget-wide-volatile",
  [anon_sym_sget_DASHobject_DASHvolatile] = "sget-object-volatile",
  [anon_sym_sput] = "sput",
  [anon_sym_sput_DASHwide] = "sput-wide",
  [anon_sym_sput_DASHobject] = "sput-object",
  [anon_sym_sput_DASHboolean] = "sput-boolean",
  [anon_sym_sput_DASHbyte] = "sput-byte",
  [anon_sym_sput_DASHchar] = "sput-char",
  [anon_sym_sput_DASHshort] = "sput-short",
  [anon_sym_sput_DASHvolatile] = "sput-volatile",
  [anon_sym_sput_DASHwide_DASHvolatile] = "sput-wide-volatile",
  [anon_sym_sput_DASHobject_DASHvolatile] = "sput-object-volatile",
  [anon_sym_invoke_DASHconstructor] = "invoke-constructor",
  [anon_sym_invoke_DASHcustom] = "invoke-custom",
  [anon_sym_invoke_DASHdirect] = "invoke-direct",
  [anon_sym_invoke_DASHdirect_DASHempty] = "invoke-direct-empty",
  [anon_sym_invoke_DASHinstance] = "invoke-instance",
  [anon_sym_invoke_DASHinterface] = "invoke-interface",
  [anon_sym_invoke_DASHpolymorphic] = "invoke-polymorphic",
  [anon_sym_invoke_DASHstatic] = "invoke-static",
  [anon_sym_invoke_DASHsuper] = "invoke-super",
  [anon_sym_invoke_DASHvirtual] = "invoke-virtual",
  [anon_sym_invoke_DASHcustom_SLASHrange] = "invoke-custom/range",
  [anon_sym_invoke_DASHdirect_SLASHrange] = "invoke-direct/range",
  [anon_sym_invoke_DASHinterface_SLASHrange] = "invoke-interface/range",
  [anon_sym_invoke_DASHobject_DASHinit_SLASHrange] = "invoke-object-init/range",
  [anon_sym_invoke_DASHpolymorphic_SLASHrange] = "invoke-polymorphic/range",
  [anon_sym_invoke_DASHstatic_SLASHrange] = "invoke-static/range",
  [anon_sym_invoke_DASHsuper_SLASHrange] = "invoke-super/range",
  [anon_sym_invoke_DASHvirtual_SLASHrange] = "invoke-virtual/range",
  [anon_sym_neg_DASHint] = "neg-int",
  [anon_sym_not_DASHint] = "not-int",
  [anon_sym_neg_DASHlong] = "neg-long",
  [anon_sym_not_DASHlong] = "not-long",
  [anon_sym_neg_DASHfloat] = "neg-float",
  [anon_sym_neg_DASHdouble] = "neg-double",
  [anon_sym_int_DASHto_DASHlong] = "int-to-long",
  [anon_sym_int_DASHto_DASHfloat] = "int-to-float",
  [anon_sym_int_DASHto_DASHdouble] = "int-to-double",
  [anon_sym_long_DASHto_DASHint] = "long-to-int",
  [anon_sym_long_DASHto_DASHfloat] = "long-to-float",
  [anon_sym_long_DASHto_DASHdouble] = "long-to-double",
  [anon_sym_float_DASHto_DASHint] = "float-to-int",
  [anon_sym_float_DASHto_DASHlong] = "float-to-long",
  [anon_sym_float_DASHto_DASHdouble] = "float-to-double",
  [anon_sym_double_DASHto_DASHint] = "double-to-int",
  [anon_sym_double_DASHto_DASHlong] = "double-to-long",
  [anon_sym_double_DASHto_DASHfloat] = "double-to-float",
  [anon_sym_int_DASHto_DASHbyte] = "int-to-byte",
  [anon_sym_int_DASHto_DASHchar] = "int-to-char",
  [anon_sym_int_DASHto_DASHshort] = "int-to-short",
  [anon_sym_add_DASHint] = "add-int",
  [anon_sym_sub_DASHint] = "sub-int",
  [anon_sym_mul_DASHint] = "mul-int",
  [anon_sym_div_DASHint] = "div-int",
  [anon_sym_rem_DASHint] = "rem-int",
  [anon_sym_and_DASHint] = "and-int",
  [anon_sym_or_DASHint] = "or-int",
  [anon_sym_xor_DASHint] = "xor-int",
  [anon_sym_shl_DASHint] = "shl-int",
  [anon_sym_shr_DASHint] = "shr-int",
  [anon_sym_ushr_DASHint] = "ushr-int",
  [anon_sym_add_DASHlong] = "add-long",
  [anon_sym_sub_DASHlong] = "sub-long",
  [anon_sym_mul_DASHlong] = "mul-long",
  [anon_sym_div_DASHlong] = "div-long",
  [anon_sym_rem_DASHlong] = "rem-long",
  [anon_sym_and_DASHlong] = "and-long",
  [anon_sym_or_DASHlong] = "or-long",
  [anon_sym_xor_DASHlong] = "xor-long",
  [anon_sym_shl_DASHlong] = "shl-long",
  [anon_sym_shr_DASHlong] = "shr-long",
  [anon_sym_ushr_DASHlong] = "ushr-long",
  [anon_sym_add_DASHfloat] = "add-float",
  [anon_sym_sub_DASHfloat] = "sub-float",
  [anon_sym_mul_DASHfloat] = "mul-float",
  [anon_sym_div_DASHfloat] = "div-float",
  [anon_sym_rem_DASHfloat] = "rem-float",
  [anon_sym_add_DASHdouble] = "add-double",
  [anon_sym_sub_DASHdouble] = "sub-double",
  [anon_sym_mul_DASHdouble] = "mul-double",
  [anon_sym_div_DASHdouble] = "div-double",
  [anon_sym_rem_DASHdouble] = "rem-double",
  [anon_sym_add_DASHint_SLASH2addr] = "add-int/2addr",
  [anon_sym_sub_DASHint_SLASH2addr] = "sub-int/2addr",
  [anon_sym_mul_DASHint_SLASH2addr] = "mul-int/2addr",
  [anon_sym_div_DASHint_SLASH2addr] = "div-int/2addr",
  [anon_sym_rem_DASHint_SLASH2addr] = "rem-int/2addr",
  [anon_sym_and_DASHint_SLASH2addr] = "and-int/2addr",
  [anon_sym_or_DASHint_SLASH2addr] = "or-int/2addr",
  [anon_sym_xor_DASHint_SLASH2addr] = "xor-int/2addr",
  [anon_sym_shl_DASHint_SLASH2addr] = "shl-int/2addr",
  [anon_sym_shr_DASHint_SLASH2addr] = "shr-int/2addr",
  [anon_sym_ushr_DASHint_SLASH2addr] = "ushr-int/2addr",
  [anon_sym_add_DASHlong_SLASH2addr] = "add-long/2addr",
  [anon_sym_sub_DASHlong_SLASH2addr] = "sub-long/2addr",
  [anon_sym_mul_DASHlong_SLASH2addr] = "mul-long/2addr",
  [anon_sym_div_DASHlong_SLASH2addr] = "div-long/2addr",
  [anon_sym_rem_DASHlong_SLASH2addr] = "rem-long/2addr",
  [anon_sym_and_DASHlong_SLASH2addr] = "and-long/2addr",
  [anon_sym_or_DASHlong_SLASH2addr] = "or-long/2addr",
  [anon_sym_xor_DASHlong_SLASH2addr] = "xor-long/2addr",
  [anon_sym_shl_DASHlong_SLASH2addr] = "shl-long/2addr",
  [anon_sym_shr_DASHlong_SLASH2addr] = "shr-long/2addr",
  [anon_sym_ushr_DASHlong_SLASH2addr] = "ushr-long/2addr",
  [anon_sym_add_DASHfloat_SLASH2addr] = "add-float/2addr",
  [anon_sym_sub_DASHfloat_SLASH2addr] = "sub-float/2addr",
  [anon_sym_mul_DASHfloat_SLASH2addr] = "mul-float/2addr",
  [anon_sym_div_DASHfloat_SLASH2addr] = "div-float/2addr",
  [anon_sym_rem_DASHfloat_SLASH2addr] = "rem-float/2addr",
  [anon_sym_add_DASHdouble_SLASH2addr] = "add-double/2addr",
  [anon_sym_sub_DASHdouble_SLASH2addr] = "sub-double/2addr",
  [anon_sym_mul_DASHdouble_SLASH2addr] = "mul-double/2addr",
  [anon_sym_div_DASHdouble_SLASH2addr] = "div-double/2addr",
  [anon_sym_rem_DASHdouble_SLASH2addr] = "rem-double/2addr",
  [anon_sym_add_DASHint_SLASHlit16] = "add-int/lit16",
  [anon_sym_sub_DASHint_SLASHlit16] = "sub-int/lit16",
  [anon_sym_mul_DASHint_SLASHlit16] = "mul-int/lit16",
  [anon_sym_div_DASHint_SLASHlit16] = "div-int/lit16",
  [anon_sym_rem_DASHint_SLASHlit16] = "rem-int/lit16",
  [anon_sym_and_DASHint_SLASHlit16] = "and-int/lit16",
  [anon_sym_or_DASHint_SLASHlit16] = "or-int/lit16",
  [anon_sym_xor_DASHint_SLASHlit16] = "xor-int/lit16",
  [anon_sym_add_DASHint_SLASHlit8] = "add-int/lit8",
  [anon_sym_sub_DASHint_SLASHlit8] = "sub-int/lit8",
  [anon_sym_mul_DASHint_SLASHlit8] = "mul-int/lit8",
  [anon_sym_div_DASHint_SLASHlit8] = "div-int/lit8",
  [anon_sym_rem_DASHint_SLASHlit8] = "rem-int/lit8",
  [anon_sym_and_DASHint_SLASHlit8] = "and-int/lit8",
  [anon_sym_or_DASHint_SLASHlit8] = "or-int/lit8",
  [anon_sym_xor_DASHint_SLASHlit8] = "xor-int/lit8",
  [anon_sym_shl_DASHint_SLASHlit8] = "shl-int/lit8",
  [anon_sym_shr_DASHint_SLASHlit8] = "shr-int/lit8",
  [anon_sym_ushr_DASHint_SLASHlit8] = "ushr-int/lit8",
  [anon_sym_static_DASHget] = "static-get",
  [anon_sym_static_DASHput] = "static-put",
  [anon_sym_instance_DASHget] = "instance-get",
  [anon_sym_instance_DASHput] = "instance-put",
  [anon_sym_execute_DASHinline] = "execute-inline",
  [anon_sym_execute_DASHinline_SLASHrange] = "execute-inline/range",
  [anon_sym_iget_DASHquick] = "iget-quick",
  [anon_sym_iget_DASHwide_DASHquick] = "iget-wide-quick",
  [anon_sym_iget_DASHobject_DASHquick] = "iget-object-quick",
  [anon_sym_iput_DASHquick] = "iput-quick",
  [anon_sym_iput_DASHwide_DASHquick] = "iput-wide-quick",
  [anon_sym_iput_DASHobject_DASHquick] = "iput-object-quick",
  [anon_sym_iput_DASHboolean_DASHquick] = "iput-boolean-quick",
  [anon_sym_iput_DASHbyte_DASHquick] = "iput-byte-quick",
  [anon_sym_iput_DASHchar_DASHquick] = "iput-char-quick",
  [anon_sym_iput_DASHshort_DASHquick] = "iput-short-quick",
  [anon_sym_invoke_DASHvirtual_DASHquick] = "invoke-virtual-quick",
  [anon_sym_invoke_DASHvirtual_DASHquick_SLASHrange] = "invoke-virtual-quick/range",
  [anon_sym_invoke_DASHsuper_DASHquick] = "invoke-super-quick",
  [anon_sym_invoke_DASHsuper_DASHquick_SLASHrange] = "invoke-super-quick/range",
  [anon_sym_rsub_DASHint] = "rsub-int",
  [anon_sym_rsub_DASHint_SLASHlit8] = "rsub-int/lit8",
  [anon_sym_DOTline] = ".line",
  [anon_sym_DOTlocals] = ".locals",
  [anon_sym_DOTlocal] = ".local",
  [anon_sym_COLON] = ":",
  [anon_sym_DOTendlocal] = ".end local",
  [anon_sym_DOTrestartlocal] = ".restart local",
  [anon_sym_DOTregisters] = ".registers",
  [anon_sym_DOTcatch] = ".catch",
  [anon_sym_LBRACE] = "{",
  [anon_sym_DOT_DOT] = "..",
  [anon_sym_RBRACE] = "}",
  [anon_sym_DOTcatchall] = ".catchall",
  [anon_sym_DOTpacked_DASHswitch] = ".packed-switch",
  [anon_sym_DOTendpacked_DASHswitch] = ".end packed-switch",
  [anon_sym_DOTsparse_DASHswitch] = ".sparse-switch",
  [anon_sym_DASH_GT] = "->",
  [anon_sym_DOTendsparse_DASHswitch] = ".end sparse-switch",
  [anon_sym_DOTarray_DASHdata] = ".array-data",
  [anon_sym_DOTendarray_DASHdata] = ".end array-data",
  [sym_prologue_directive] = "prologue_directive",
  [sym_epilogue_directive] = "epilogue_directive",
  [anon_sym_SLASH] = "/",
  [anon_sym_SEMI] = ";",
  [aux_sym_label_token1] = "label_token1",
  [aux_sym_jmp_label_token1] = "jmp_label_token1",
  [anon_sym_DASH] = "method_identifier",
  [anon_sym_LPAREN] = "(",
  [anon_sym_RPAREN] = ")",
  [anon_sym_AT] = "@",
  [anon_sym_LBRACK] = "[",
  [aux_sym_primitive_type_token1] = "primitive_type_token1",
  [aux_sym_primitive_type_token2] = "primitive_type_token2",
  [anon_sym_constructor] = "constructor",
  [anon_sym_public] = "public",
  [anon_sym_private] = "private",
  [anon_sym_protected] = "protected",
  [anon_sym_static] = "static",
  [anon_sym_final] = "final",
  [anon_sym_synchronized] = "synchronized",
  [anon_sym_volatile] = "volatile",
  [anon_sym_bridge] = "bridge",
  [anon_sym_transient] = "transient",
  [anon_sym_varargs] = "varargs",
  [anon_sym_native] = "native",
  [anon_sym_interface] = "interface",
  [anon_sym_abstract] = "abstract",
  [anon_sym_strictfp] = "strictfp",
  [anon_sym_synthetic] = "synthetic",
  [anon_sym_annotation] = "annotation",
  [anon_sym_enum] = "enum",
  [anon_sym_declared_DASHsynchronized] = "declared-synchronized",
  [anon_sym_whitelist] = "whitelist",
  [anon_sym_greylist] = "greylist",
  [anon_sym_blacklist] = "blacklist",
  [anon_sym_greylist_DASHmax_DASHo] = "greylist-max-o",
  [anon_sym_greylist_DASHmax_DASHp] = "greylist-max-p",
  [anon_sym_greylist_DASHmax_DASHq] = "greylist-max-q",
  [anon_sym_greylist_DASHmax_DASHr] = "greylist-max-r",
  [anon_sym_core_DASHplatform_DASHapi] = "core-platform-api",
  [anon_sym_test_DASHapi] = "test-api",
  [anon_sym_DOTenum] = ".enum",
  [sym_variable] = "variable",
  [sym_parameter] = "parameter",
  [sym_number] = "number",
  [sym_float] = "float",
  [sym_NaN] = "NaN",
  [sym_Infinity] = "Infinity",
  [anon_sym_DQUOTE] = "\"",
  [sym_string_fragment] = "string_fragment",
  [aux_sym__escape_sequence_token1] = "_escape_sequence_token1",
  [sym_escape_sequence] = "escape_sequence",
  [anon_sym_true] = "true",
  [anon_sym_false] = "false",
  [anon_sym_SQUOTE] = "'",
  [aux_sym_character_token1] = "character_token1",
  [sym_null] = "null",
  [sym_comment] = "comment",
  [sym_L] = "L",
  [sym__class_ident] = "identifier",
  [sym_class_definition] = "class_definition",
  [sym_class_directive] = "class_directive",
  [sym_super_directive] = "super_directive",
  [sym_source_directive] = "source_directive",
  [sym_implements_directive] = "implements_directive",
  [sym_field_definition] = "field_definition",
  [sym_method_definition] = "method_definition",
  [sym_annotation_directive] = "annotation_directive",
  [sym_annotation_visibility] = "annotation_visibility",
  [sym_annotation_property] = "annotation_property",
  [sym_annotation_value] = "annotation_value",
  [sym_subannotation_directive] = "subannotation_directive",
  [sym_param_directive] = "param_directive",
  [sym_parameter_directive] = "parameter_directive",
  [sym_statement] = "statement",
  [sym_expression] = "expression",
  [sym_opcode] = "opcode",
  [sym_value] = "value",
  [sym_directive] = "directive",
  [sym_line_directive] = "line_directive",
  [sym_locals_directive] = "locals_directive",
  [sym_local_directive] = "local_directive",
  [sym_end_local_directive] = "end_local_directive",
  [sym_restart_local_directive] = "restart_local_directive",
  [sym_registers_directive] = "registers_directive",
  [sym_catch_directive] = "catch_directive",
  [sym_catchall_directive] = "catchall_directive",
  [sym_packed_switch_directive] = "packed_switch_directive",
  [sym_sparse_switch_directive] = "sparse_switch_directive",
  [sym_array_data_directive] = "array_data_directive",
  [sym_class_identifier] = "class_identifier",
  [sym_label] = "label",
  [sym_jmp_label] = "jmp_label",
  [sym_body] = "body",
  [sym__field_body] = "_field_body",
  [sym_method_signature] = "method_signature",
  [sym__method_signature_body] = "_method_signature_body",
  [sym_method_handle] = "method_handle",
  [sym__full_field_body] = "_full_field_body",
  [sym_full_method_signature] = "full_method_signature",
  [sym_custom_invoke] = "custom_invoke",
  [sym_type] = "type",
  [sym_array_type] = "array_type",
  [sym_primitive_type] = "primitive_type",
  [sym_access_modifiers] = "access_modifiers",
  [aux_sym__method_access_modifiers] = "_method_access_modifiers",
  [sym_access_modifier] = "access_modifier",
  [sym_enum_reference] = "enum_reference",
  [sym_register] = "register",
  [sym_list] = "list",
  [sym_range] = "range",
  [sym_literal] = "literal",
  [sym_string] = "string",
  [sym__escape_sequence] = "_escape_sequence",
  [sym_boolean] = "boolean",
  [sym_character] = "character",
  [aux_sym_class_definition_repeat1] = "class_definition_repeat1",
  [aux_sym_class_definition_repeat2] = "class_definition_repeat2",
  [aux_sym_field_definition_repeat1] = "field_definition_repeat1",
  [aux_sym_method_definition_repeat1] = "method_definition_repeat1",
  [aux_sym_annotation_directive_repeat1] = "annotation_directive_repeat1",
  [aux_sym_expression_repeat1] = "expression_repeat1",
  [aux_sym_packed_switch_directive_repeat1] = "packed_switch_directive_repeat1",
  [aux_sym_sparse_switch_directive_repeat1] = "sparse_switch_directive_repeat1",
  [aux_sym_array_data_directive_repeat1] = "array_data_directive_repeat1",
  [aux_sym_class_identifier_repeat1] = "class_identifier_repeat1",
  [aux_sym__method_signature_body_repeat1] = "_method_signature_body_repeat1",
  [aux_sym_custom_invoke_repeat1] = "custom_invoke_repeat1",
  [aux_sym_access_modifiers_repeat1] = "access_modifiers_repeat1",
  [aux_sym_string_repeat1] = "string_repeat1",
  [alias_sym_field_identifier] = "field_identifier",
  [alias_sym_field_type] = "field_type",
  [alias_sym_param_identifier] = "param_identifier",
  [alias_sym_parameters] = "parameters",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym_identifier] = sym_identifier,
  [anon_sym_DOTclass] = anon_sym_DOTclass,
  [anon_sym_DOTsuper] = anon_sym_DOTsuper,
  [anon_sym_DOTsource] = anon_sym_DOTsource,
  [anon_sym_DOTimplements] = anon_sym_DOTimplements,
  [anon_sym_DOTfield] = anon_sym_DOTfield,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_DOTendfield] = anon_sym_DOTendfield,
  [anon_sym_DOTmethod] = anon_sym_DOTmethod,
  [anon_sym_DOTendmethod] = anon_sym_DOTendmethod,
  [anon_sym_DOTannotation] = anon_sym_DOTannotation,
  [anon_sym_DOTendannotation] = anon_sym_DOTendannotation,
  [anon_sym_system] = anon_sym_system,
  [anon_sym_build] = anon_sym_build,
  [anon_sym_runtime] = anon_sym_runtime,
  [sym_annotation_key] = sym_annotation_key,
  [anon_sym_DOTsubannotation] = anon_sym_DOTsubannotation,
  [anon_sym_DOTendsubannotation] = anon_sym_DOTendsubannotation,
  [anon_sym_DOTparam] = anon_sym_DOTparam,
  [anon_sym_DOTendparam] = anon_sym_DOTendparam,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_DOTparameter] = anon_sym_DOTparameter,
  [anon_sym_DOTendparameter] = anon_sym_DOTendparameter,
  [anon_sym_LF] = anon_sym_LF,
  [anon_sym_nop] = anon_sym_nop,
  [anon_sym_move] = anon_sym_move,
  [anon_sym_move_SLASHfrom16] = anon_sym_move_SLASHfrom16,
  [anon_sym_move_SLASH16] = anon_sym_move_SLASH16,
  [anon_sym_move_DASHwide] = anon_sym_move_DASHwide,
  [anon_sym_move_DASHwide_SLASHfrom16] = anon_sym_move_DASHwide_SLASHfrom16,
  [anon_sym_move_DASHwide_SLASH16] = anon_sym_move_DASHwide_SLASH16,
  [anon_sym_move_DASHobject] = anon_sym_move_DASHobject,
  [anon_sym_move_DASHobject_SLASHfrom16] = anon_sym_move_DASHobject_SLASHfrom16,
  [anon_sym_move_DASHobject_SLASH16] = anon_sym_move_DASHobject_SLASH16,
  [anon_sym_move_DASHresult] = anon_sym_move_DASHresult,
  [anon_sym_move_DASHresult_DASHwide] = anon_sym_move_DASHresult_DASHwide,
  [anon_sym_move_DASHresult_DASHobject] = anon_sym_move_DASHresult_DASHobject,
  [anon_sym_move_DASHexception] = anon_sym_move_DASHexception,
  [anon_sym_return_DASHvoid] = anon_sym_return_DASHvoid,
  [anon_sym_return] = anon_sym_return,
  [anon_sym_return_DASHwide] = anon_sym_return_DASHwide,
  [anon_sym_return_DASHobject] = anon_sym_return_DASHobject,
  [anon_sym_const_SLASH4] = anon_sym_const_SLASH4,
  [anon_sym_const_SLASH16] = anon_sym_const_SLASH16,
  [anon_sym_const] = anon_sym_const,
  [anon_sym_const_SLASHhigh16] = anon_sym_const_SLASHhigh16,
  [anon_sym_const_DASHwide_SLASH16] = anon_sym_const_DASHwide_SLASH16,
  [anon_sym_const_DASHwide_SLASH32] = anon_sym_const_DASHwide_SLASH32,
  [anon_sym_const_DASHwide] = anon_sym_const_DASHwide,
  [anon_sym_const_DASHwide_SLASHhigh16] = anon_sym_const_DASHwide_SLASHhigh16,
  [anon_sym_const_DASHstring] = anon_sym_const_DASHstring,
  [anon_sym_const_DASHstring_SLASHjumbo] = anon_sym_const_DASHstring_SLASHjumbo,
  [anon_sym_const_DASHclass] = anon_sym_const_DASHclass,
  [anon_sym_const_DASHmethod_DASHhandle] = anon_sym_const_DASHmethod_DASHhandle,
  [anon_sym_const_DASHmethod_DASHtype] = anon_sym_const_DASHmethod_DASHtype,
  [anon_sym_monitor_DASHenter] = anon_sym_monitor_DASHenter,
  [anon_sym_monitor_DASHexit] = anon_sym_monitor_DASHexit,
  [anon_sym_check_DASHcast] = anon_sym_check_DASHcast,
  [anon_sym_instance_DASHof] = anon_sym_instance_DASHof,
  [anon_sym_array_DASHlength] = anon_sym_array_DASHlength,
  [anon_sym_new_DASHinstance] = anon_sym_new_DASHinstance,
  [anon_sym_new_DASHarray] = anon_sym_new_DASHarray,
  [anon_sym_filled_DASHnew_DASHarray] = anon_sym_filled_DASHnew_DASHarray,
  [anon_sym_filled_DASHnew_DASHarray_SLASHrange] = anon_sym_filled_DASHnew_DASHarray_SLASHrange,
  [anon_sym_fill_DASHarray_DASHdata] = anon_sym_fill_DASHarray_DASHdata,
  [anon_sym_throw] = anon_sym_throw,
  [anon_sym_throw_DASHverification_DASHerror] = anon_sym_throw_DASHverification_DASHerror,
  [anon_sym_goto] = anon_sym_goto,
  [anon_sym_goto_SLASH16] = anon_sym_goto_SLASH16,
  [anon_sym_goto_SLASH32] = anon_sym_goto_SLASH32,
  [anon_sym_packed_DASHswitch] = anon_sym_packed_DASHswitch,
  [anon_sym_sparse_DASHswitch] = anon_sym_sparse_DASHswitch,
  [anon_sym_cmpl_DASHfloat] = anon_sym_cmpl_DASHfloat,
  [anon_sym_cmpg_DASHfloat] = anon_sym_cmpg_DASHfloat,
  [anon_sym_cmpl_DASHdouble] = anon_sym_cmpl_DASHdouble,
  [anon_sym_cmpg_DASHdouble] = anon_sym_cmpg_DASHdouble,
  [anon_sym_cmp_DASHlong] = anon_sym_cmp_DASHlong,
  [anon_sym_if_DASHeq] = anon_sym_if_DASHeq,
  [anon_sym_if_DASHne] = anon_sym_if_DASHne,
  [anon_sym_if_DASHlt] = anon_sym_if_DASHlt,
  [anon_sym_if_DASHge] = anon_sym_if_DASHge,
  [anon_sym_if_DASHgt] = anon_sym_if_DASHgt,
  [anon_sym_if_DASHle] = anon_sym_if_DASHle,
  [anon_sym_if_DASHeqz] = anon_sym_if_DASHeqz,
  [anon_sym_if_DASHnez] = anon_sym_if_DASHnez,
  [anon_sym_if_DASHltz] = anon_sym_if_DASHltz,
  [anon_sym_if_DASHgez] = anon_sym_if_DASHgez,
  [anon_sym_if_DASHgtz] = anon_sym_if_DASHgtz,
  [anon_sym_if_DASHlez] = anon_sym_if_DASHlez,
  [anon_sym_aget] = anon_sym_aget,
  [anon_sym_aget_DASHwide] = anon_sym_aget_DASHwide,
  [anon_sym_aget_DASHobject] = anon_sym_aget_DASHobject,
  [anon_sym_aget_DASHboolean] = anon_sym_aget_DASHboolean,
  [anon_sym_aget_DASHbyte] = anon_sym_aget_DASHbyte,
  [anon_sym_aget_DASHchar] = anon_sym_aget_DASHchar,
  [anon_sym_aget_DASHshort] = anon_sym_aget_DASHshort,
  [anon_sym_aput] = anon_sym_aput,
  [anon_sym_aput_DASHwide] = anon_sym_aput_DASHwide,
  [anon_sym_aput_DASHobject] = anon_sym_aput_DASHobject,
  [anon_sym_aput_DASHboolean] = anon_sym_aput_DASHboolean,
  [anon_sym_aput_DASHbyte] = anon_sym_aput_DASHbyte,
  [anon_sym_aput_DASHchar] = anon_sym_aput_DASHchar,
  [anon_sym_aput_DASHshort] = anon_sym_aput_DASHshort,
  [anon_sym_iget] = anon_sym_iget,
  [anon_sym_iget_DASHwide] = anon_sym_iget_DASHwide,
  [anon_sym_iget_DASHobject] = anon_sym_iget_DASHobject,
  [anon_sym_iget_DASHboolean] = anon_sym_iget_DASHboolean,
  [anon_sym_iget_DASHbyte] = anon_sym_iget_DASHbyte,
  [anon_sym_iget_DASHchar] = anon_sym_iget_DASHchar,
  [anon_sym_iget_DASHshort] = anon_sym_iget_DASHshort,
  [anon_sym_iget_DASHvolatile] = anon_sym_iget_DASHvolatile,
  [anon_sym_iget_DASHwide_DASHvolatile] = anon_sym_iget_DASHwide_DASHvolatile,
  [anon_sym_iget_DASHobject_DASHvolatile] = anon_sym_iget_DASHobject_DASHvolatile,
  [anon_sym_iput] = anon_sym_iput,
  [anon_sym_iput_DASHwide] = anon_sym_iput_DASHwide,
  [anon_sym_iput_DASHobject] = anon_sym_iput_DASHobject,
  [anon_sym_iput_DASHboolean] = anon_sym_iput_DASHboolean,
  [anon_sym_iput_DASHbyte] = anon_sym_iput_DASHbyte,
  [anon_sym_iput_DASHchar] = anon_sym_iput_DASHchar,
  [anon_sym_iput_DASHshort] = anon_sym_iput_DASHshort,
  [anon_sym_iput_DASHvolatile] = anon_sym_iput_DASHvolatile,
  [anon_sym_iput_DASHwide_DASHvolatile] = anon_sym_iput_DASHwide_DASHvolatile,
  [anon_sym_iput_DASHobject_DASHvolatile] = anon_sym_iput_DASHobject_DASHvolatile,
  [anon_sym_sget] = anon_sym_sget,
  [anon_sym_sget_DASHwide] = anon_sym_sget_DASHwide,
  [anon_sym_sget_DASHobject] = anon_sym_sget_DASHobject,
  [anon_sym_sget_DASHboolean] = anon_sym_sget_DASHboolean,
  [anon_sym_sget_DASHbyte] = anon_sym_sget_DASHbyte,
  [anon_sym_sget_DASHchar] = anon_sym_sget_DASHchar,
  [anon_sym_sget_DASHshort] = anon_sym_sget_DASHshort,
  [anon_sym_sget_DASHvolatile] = anon_sym_sget_DASHvolatile,
  [anon_sym_sget_DASHwide_DASHvolatile] = anon_sym_sget_DASHwide_DASHvolatile,
  [anon_sym_sget_DASHobject_DASHvolatile] = anon_sym_sget_DASHobject_DASHvolatile,
  [anon_sym_sput] = anon_sym_sput,
  [anon_sym_sput_DASHwide] = anon_sym_sput_DASHwide,
  [anon_sym_sput_DASHobject] = anon_sym_sput_DASHobject,
  [anon_sym_sput_DASHboolean] = anon_sym_sput_DASHboolean,
  [anon_sym_sput_DASHbyte] = anon_sym_sput_DASHbyte,
  [anon_sym_sput_DASHchar] = anon_sym_sput_DASHchar,
  [anon_sym_sput_DASHshort] = anon_sym_sput_DASHshort,
  [anon_sym_sput_DASHvolatile] = anon_sym_sput_DASHvolatile,
  [anon_sym_sput_DASHwide_DASHvolatile] = anon_sym_sput_DASHwide_DASHvolatile,
  [anon_sym_sput_DASHobject_DASHvolatile] = anon_sym_sput_DASHobject_DASHvolatile,
  [anon_sym_invoke_DASHconstructor] = anon_sym_invoke_DASHconstructor,
  [anon_sym_invoke_DASHcustom] = anon_sym_invoke_DASHcustom,
  [anon_sym_invoke_DASHdirect] = anon_sym_invoke_DASHdirect,
  [anon_sym_invoke_DASHdirect_DASHempty] = anon_sym_invoke_DASHdirect_DASHempty,
  [anon_sym_invoke_DASHinstance] = anon_sym_invoke_DASHinstance,
  [anon_sym_invoke_DASHinterface] = anon_sym_invoke_DASHinterface,
  [anon_sym_invoke_DASHpolymorphic] = anon_sym_invoke_DASHpolymorphic,
  [anon_sym_invoke_DASHstatic] = anon_sym_invoke_DASHstatic,
  [anon_sym_invoke_DASHsuper] = anon_sym_invoke_DASHsuper,
  [anon_sym_invoke_DASHvirtual] = anon_sym_invoke_DASHvirtual,
  [anon_sym_invoke_DASHcustom_SLASHrange] = anon_sym_invoke_DASHcustom_SLASHrange,
  [anon_sym_invoke_DASHdirect_SLASHrange] = anon_sym_invoke_DASHdirect_SLASHrange,
  [anon_sym_invoke_DASHinterface_SLASHrange] = anon_sym_invoke_DASHinterface_SLASHrange,
  [anon_sym_invoke_DASHobject_DASHinit_SLASHrange] = anon_sym_invoke_DASHobject_DASHinit_SLASHrange,
  [anon_sym_invoke_DASHpolymorphic_SLASHrange] = anon_sym_invoke_DASHpolymorphic_SLASHrange,
  [anon_sym_invoke_DASHstatic_SLASHrange] = anon_sym_invoke_DASHstatic_SLASHrange,
  [anon_sym_invoke_DASHsuper_SLASHrange] = anon_sym_invoke_DASHsuper_SLASHrange,
  [anon_sym_invoke_DASHvirtual_SLASHrange] = anon_sym_invoke_DASHvirtual_SLASHrange,
  [anon_sym_neg_DASHint] = anon_sym_neg_DASHint,
  [anon_sym_not_DASHint] = anon_sym_not_DASHint,
  [anon_sym_neg_DASHlong] = anon_sym_neg_DASHlong,
  [anon_sym_not_DASHlong] = anon_sym_not_DASHlong,
  [anon_sym_neg_DASHfloat] = anon_sym_neg_DASHfloat,
  [anon_sym_neg_DASHdouble] = anon_sym_neg_DASHdouble,
  [anon_sym_int_DASHto_DASHlong] = anon_sym_int_DASHto_DASHlong,
  [anon_sym_int_DASHto_DASHfloat] = anon_sym_int_DASHto_DASHfloat,
  [anon_sym_int_DASHto_DASHdouble] = anon_sym_int_DASHto_DASHdouble,
  [anon_sym_long_DASHto_DASHint] = anon_sym_long_DASHto_DASHint,
  [anon_sym_long_DASHto_DASHfloat] = anon_sym_long_DASHto_DASHfloat,
  [anon_sym_long_DASHto_DASHdouble] = anon_sym_long_DASHto_DASHdouble,
  [anon_sym_float_DASHto_DASHint] = anon_sym_float_DASHto_DASHint,
  [anon_sym_float_DASHto_DASHlong] = anon_sym_float_DASHto_DASHlong,
  [anon_sym_float_DASHto_DASHdouble] = anon_sym_float_DASHto_DASHdouble,
  [anon_sym_double_DASHto_DASHint] = anon_sym_double_DASHto_DASHint,
  [anon_sym_double_DASHto_DASHlong] = anon_sym_double_DASHto_DASHlong,
  [anon_sym_double_DASHto_DASHfloat] = anon_sym_double_DASHto_DASHfloat,
  [anon_sym_int_DASHto_DASHbyte] = anon_sym_int_DASHto_DASHbyte,
  [anon_sym_int_DASHto_DASHchar] = anon_sym_int_DASHto_DASHchar,
  [anon_sym_int_DASHto_DASHshort] = anon_sym_int_DASHto_DASHshort,
  [anon_sym_add_DASHint] = anon_sym_add_DASHint,
  [anon_sym_sub_DASHint] = anon_sym_sub_DASHint,
  [anon_sym_mul_DASHint] = anon_sym_mul_DASHint,
  [anon_sym_div_DASHint] = anon_sym_div_DASHint,
  [anon_sym_rem_DASHint] = anon_sym_rem_DASHint,
  [anon_sym_and_DASHint] = anon_sym_and_DASHint,
  [anon_sym_or_DASHint] = anon_sym_or_DASHint,
  [anon_sym_xor_DASHint] = anon_sym_xor_DASHint,
  [anon_sym_shl_DASHint] = anon_sym_shl_DASHint,
  [anon_sym_shr_DASHint] = anon_sym_shr_DASHint,
  [anon_sym_ushr_DASHint] = anon_sym_ushr_DASHint,
  [anon_sym_add_DASHlong] = anon_sym_add_DASHlong,
  [anon_sym_sub_DASHlong] = anon_sym_sub_DASHlong,
  [anon_sym_mul_DASHlong] = anon_sym_mul_DASHlong,
  [anon_sym_div_DASHlong] = anon_sym_div_DASHlong,
  [anon_sym_rem_DASHlong] = anon_sym_rem_DASHlong,
  [anon_sym_and_DASHlong] = anon_sym_and_DASHlong,
  [anon_sym_or_DASHlong] = anon_sym_or_DASHlong,
  [anon_sym_xor_DASHlong] = anon_sym_xor_DASHlong,
  [anon_sym_shl_DASHlong] = anon_sym_shl_DASHlong,
  [anon_sym_shr_DASHlong] = anon_sym_shr_DASHlong,
  [anon_sym_ushr_DASHlong] = anon_sym_ushr_DASHlong,
  [anon_sym_add_DASHfloat] = anon_sym_add_DASHfloat,
  [anon_sym_sub_DASHfloat] = anon_sym_sub_DASHfloat,
  [anon_sym_mul_DASHfloat] = anon_sym_mul_DASHfloat,
  [anon_sym_div_DASHfloat] = anon_sym_div_DASHfloat,
  [anon_sym_rem_DASHfloat] = anon_sym_rem_DASHfloat,
  [anon_sym_add_DASHdouble] = anon_sym_add_DASHdouble,
  [anon_sym_sub_DASHdouble] = anon_sym_sub_DASHdouble,
  [anon_sym_mul_DASHdouble] = anon_sym_mul_DASHdouble,
  [anon_sym_div_DASHdouble] = anon_sym_div_DASHdouble,
  [anon_sym_rem_DASHdouble] = anon_sym_rem_DASHdouble,
  [anon_sym_add_DASHint_SLASH2addr] = anon_sym_add_DASHint_SLASH2addr,
  [anon_sym_sub_DASHint_SLASH2addr] = anon_sym_sub_DASHint_SLASH2addr,
  [anon_sym_mul_DASHint_SLASH2addr] = anon_sym_mul_DASHint_SLASH2addr,
  [anon_sym_div_DASHint_SLASH2addr] = anon_sym_div_DASHint_SLASH2addr,
  [anon_sym_rem_DASHint_SLASH2addr] = anon_sym_rem_DASHint_SLASH2addr,
  [anon_sym_and_DASHint_SLASH2addr] = anon_sym_and_DASHint_SLASH2addr,
  [anon_sym_or_DASHint_SLASH2addr] = anon_sym_or_DASHint_SLASH2addr,
  [anon_sym_xor_DASHint_SLASH2addr] = anon_sym_xor_DASHint_SLASH2addr,
  [anon_sym_shl_DASHint_SLASH2addr] = anon_sym_shl_DASHint_SLASH2addr,
  [anon_sym_shr_DASHint_SLASH2addr] = anon_sym_shr_DASHint_SLASH2addr,
  [anon_sym_ushr_DASHint_SLASH2addr] = anon_sym_ushr_DASHint_SLASH2addr,
  [anon_sym_add_DASHlong_SLASH2addr] = anon_sym_add_DASHlong_SLASH2addr,
  [anon_sym_sub_DASHlong_SLASH2addr] = anon_sym_sub_DASHlong_SLASH2addr,
  [anon_sym_mul_DASHlong_SLASH2addr] = anon_sym_mul_DASHlong_SLASH2addr,
  [anon_sym_div_DASHlong_SLASH2addr] = anon_sym_div_DASHlong_SLASH2addr,
  [anon_sym_rem_DASHlong_SLASH2addr] = anon_sym_rem_DASHlong_SLASH2addr,
  [anon_sym_and_DASHlong_SLASH2addr] = anon_sym_and_DASHlong_SLASH2addr,
  [anon_sym_or_DASHlong_SLASH2addr] = anon_sym_or_DASHlong_SLASH2addr,
  [anon_sym_xor_DASHlong_SLASH2addr] = anon_sym_xor_DASHlong_SLASH2addr,
  [anon_sym_shl_DASHlong_SLASH2addr] = anon_sym_shl_DASHlong_SLASH2addr,
  [anon_sym_shr_DASHlong_SLASH2addr] = anon_sym_shr_DASHlong_SLASH2addr,
  [anon_sym_ushr_DASHlong_SLASH2addr] = anon_sym_ushr_DASHlong_SLASH2addr,
  [anon_sym_add_DASHfloat_SLASH2addr] = anon_sym_add_DASHfloat_SLASH2addr,
  [anon_sym_sub_DASHfloat_SLASH2addr] = anon_sym_sub_DASHfloat_SLASH2addr,
  [anon_sym_mul_DASHfloat_SLASH2addr] = anon_sym_mul_DASHfloat_SLASH2addr,
  [anon_sym_div_DASHfloat_SLASH2addr] = anon_sym_div_DASHfloat_SLASH2addr,
  [anon_sym_rem_DASHfloat_SLASH2addr] = anon_sym_rem_DASHfloat_SLASH2addr,
  [anon_sym_add_DASHdouble_SLASH2addr] = anon_sym_add_DASHdouble_SLASH2addr,
  [anon_sym_sub_DASHdouble_SLASH2addr] = anon_sym_sub_DASHdouble_SLASH2addr,
  [anon_sym_mul_DASHdouble_SLASH2addr] = anon_sym_mul_DASHdouble_SLASH2addr,
  [anon_sym_div_DASHdouble_SLASH2addr] = anon_sym_div_DASHdouble_SLASH2addr,
  [anon_sym_rem_DASHdouble_SLASH2addr] = anon_sym_rem_DASHdouble_SLASH2addr,
  [anon_sym_add_DASHint_SLASHlit16] = anon_sym_add_DASHint_SLASHlit16,
  [anon_sym_sub_DASHint_SLASHlit16] = anon_sym_sub_DASHint_SLASHlit16,
  [anon_sym_mul_DASHint_SLASHlit16] = anon_sym_mul_DASHint_SLASHlit16,
  [anon_sym_div_DASHint_SLASHlit16] = anon_sym_div_DASHint_SLASHlit16,
  [anon_sym_rem_DASHint_SLASHlit16] = anon_sym_rem_DASHint_SLASHlit16,
  [anon_sym_and_DASHint_SLASHlit16] = anon_sym_and_DASHint_SLASHlit16,
  [anon_sym_or_DASHint_SLASHlit16] = anon_sym_or_DASHint_SLASHlit16,
  [anon_sym_xor_DASHint_SLASHlit16] = anon_sym_xor_DASHint_SLASHlit16,
  [anon_sym_add_DASHint_SLASHlit8] = anon_sym_add_DASHint_SLASHlit8,
  [anon_sym_sub_DASHint_SLASHlit8] = anon_sym_sub_DASHint_SLASHlit8,
  [anon_sym_mul_DASHint_SLASHlit8] = anon_sym_mul_DASHint_SLASHlit8,
  [anon_sym_div_DASHint_SLASHlit8] = anon_sym_div_DASHint_SLASHlit8,
  [anon_sym_rem_DASHint_SLASHlit8] = anon_sym_rem_DASHint_SLASHlit8,
  [anon_sym_and_DASHint_SLASHlit8] = anon_sym_and_DASHint_SLASHlit8,
  [anon_sym_or_DASHint_SLASHlit8] = anon_sym_or_DASHint_SLASHlit8,
  [anon_sym_xor_DASHint_SLASHlit8] = anon_sym_xor_DASHint_SLASHlit8,
  [anon_sym_shl_DASHint_SLASHlit8] = anon_sym_shl_DASHint_SLASHlit8,
  [anon_sym_shr_DASHint_SLASHlit8] = anon_sym_shr_DASHint_SLASHlit8,
  [anon_sym_ushr_DASHint_SLASHlit8] = anon_sym_ushr_DASHint_SLASHlit8,
  [anon_sym_static_DASHget] = anon_sym_static_DASHget,
  [anon_sym_static_DASHput] = anon_sym_static_DASHput,
  [anon_sym_instance_DASHget] = anon_sym_instance_DASHget,
  [anon_sym_instance_DASHput] = anon_sym_instance_DASHput,
  [anon_sym_execute_DASHinline] = anon_sym_execute_DASHinline,
  [anon_sym_execute_DASHinline_SLASHrange] = anon_sym_execute_DASHinline_SLASHrange,
  [anon_sym_iget_DASHquick] = anon_sym_iget_DASHquick,
  [anon_sym_iget_DASHwide_DASHquick] = anon_sym_iget_DASHwide_DASHquick,
  [anon_sym_iget_DASHobject_DASHquick] = anon_sym_iget_DASHobject_DASHquick,
  [anon_sym_iput_DASHquick] = anon_sym_iput_DASHquick,
  [anon_sym_iput_DASHwide_DASHquick] = anon_sym_iput_DASHwide_DASHquick,
  [anon_sym_iput_DASHobject_DASHquick] = anon_sym_iput_DASHobject_DASHquick,
  [anon_sym_iput_DASHboolean_DASHquick] = anon_sym_iput_DASHboolean_DASHquick,
  [anon_sym_iput_DASHbyte_DASHquick] = anon_sym_iput_DASHbyte_DASHquick,
  [anon_sym_iput_DASHchar_DASHquick] = anon_sym_iput_DASHchar_DASHquick,
  [anon_sym_iput_DASHshort_DASHquick] = anon_sym_iput_DASHshort_DASHquick,
  [anon_sym_invoke_DASHvirtual_DASHquick] = anon_sym_invoke_DASHvirtual_DASHquick,
  [anon_sym_invoke_DASHvirtual_DASHquick_SLASHrange] = anon_sym_invoke_DASHvirtual_DASHquick_SLASHrange,
  [anon_sym_invoke_DASHsuper_DASHquick] = anon_sym_invoke_DASHsuper_DASHquick,
  [anon_sym_invoke_DASHsuper_DASHquick_SLASHrange] = anon_sym_invoke_DASHsuper_DASHquick_SLASHrange,
  [anon_sym_rsub_DASHint] = anon_sym_rsub_DASHint,
  [anon_sym_rsub_DASHint_SLASHlit8] = anon_sym_rsub_DASHint_SLASHlit8,
  [anon_sym_DOTline] = anon_sym_DOTline,
  [anon_sym_DOTlocals] = anon_sym_DOTlocals,
  [anon_sym_DOTlocal] = anon_sym_DOTlocal,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_DOTendlocal] = anon_sym_DOTendlocal,
  [anon_sym_DOTrestartlocal] = anon_sym_DOTrestartlocal,
  [anon_sym_DOTregisters] = anon_sym_DOTregisters,
  [anon_sym_DOTcatch] = anon_sym_DOTcatch,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_DOT_DOT] = anon_sym_DOT_DOT,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_DOTcatchall] = anon_sym_DOTcatchall,
  [anon_sym_DOTpacked_DASHswitch] = anon_sym_DOTpacked_DASHswitch,
  [anon_sym_DOTendpacked_DASHswitch] = anon_sym_DOTendpacked_DASHswitch,
  [anon_sym_DOTsparse_DASHswitch] = anon_sym_DOTsparse_DASHswitch,
  [anon_sym_DASH_GT] = anon_sym_DASH_GT,
  [anon_sym_DOTendsparse_DASHswitch] = anon_sym_DOTendsparse_DASHswitch,
  [anon_sym_DOTarray_DASHdata] = anon_sym_DOTarray_DASHdata,
  [anon_sym_DOTendarray_DASHdata] = anon_sym_DOTendarray_DASHdata,
  [sym_prologue_directive] = sym_prologue_directive,
  [sym_epilogue_directive] = sym_epilogue_directive,
  [anon_sym_SLASH] = anon_sym_SLASH,
  [anon_sym_SEMI] = anon_sym_SEMI,
  [aux_sym_label_token1] = aux_sym_label_token1,
  [aux_sym_jmp_label_token1] = aux_sym_jmp_label_token1,
  [anon_sym_DASH] = anon_sym_DASH,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_AT] = anon_sym_AT,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [aux_sym_primitive_type_token1] = aux_sym_primitive_type_token1,
  [aux_sym_primitive_type_token2] = aux_sym_primitive_type_token2,
  [anon_sym_constructor] = anon_sym_constructor,
  [anon_sym_public] = anon_sym_public,
  [anon_sym_private] = anon_sym_private,
  [anon_sym_protected] = anon_sym_protected,
  [anon_sym_static] = anon_sym_static,
  [anon_sym_final] = anon_sym_final,
  [anon_sym_synchronized] = anon_sym_synchronized,
  [anon_sym_volatile] = anon_sym_volatile,
  [anon_sym_bridge] = anon_sym_bridge,
  [anon_sym_transient] = anon_sym_transient,
  [anon_sym_varargs] = anon_sym_varargs,
  [anon_sym_native] = anon_sym_native,
  [anon_sym_interface] = anon_sym_interface,
  [anon_sym_abstract] = anon_sym_abstract,
  [anon_sym_strictfp] = anon_sym_strictfp,
  [anon_sym_synthetic] = anon_sym_synthetic,
  [anon_sym_annotation] = anon_sym_annotation,
  [anon_sym_enum] = anon_sym_enum,
  [anon_sym_declared_DASHsynchronized] = anon_sym_declared_DASHsynchronized,
  [anon_sym_whitelist] = anon_sym_whitelist,
  [anon_sym_greylist] = anon_sym_greylist,
  [anon_sym_blacklist] = anon_sym_blacklist,
  [anon_sym_greylist_DASHmax_DASHo] = anon_sym_greylist_DASHmax_DASHo,
  [anon_sym_greylist_DASHmax_DASHp] = anon_sym_greylist_DASHmax_DASHp,
  [anon_sym_greylist_DASHmax_DASHq] = anon_sym_greylist_DASHmax_DASHq,
  [anon_sym_greylist_DASHmax_DASHr] = anon_sym_greylist_DASHmax_DASHr,
  [anon_sym_core_DASHplatform_DASHapi] = anon_sym_core_DASHplatform_DASHapi,
  [anon_sym_test_DASHapi] = anon_sym_test_DASHapi,
  [anon_sym_DOTenum] = anon_sym_DOTenum,
  [sym_variable] = sym_variable,
  [sym_parameter] = sym_parameter,
  [sym_number] = sym_number,
  [sym_float] = sym_float,
  [sym_NaN] = sym_NaN,
  [sym_Infinity] = sym_Infinity,
  [anon_sym_DQUOTE] = anon_sym_DQUOTE,
  [sym_string_fragment] = sym_string_fragment,
  [aux_sym__escape_sequence_token1] = aux_sym__escape_sequence_token1,
  [sym_escape_sequence] = sym_escape_sequence,
  [anon_sym_true] = anon_sym_true,
  [anon_sym_false] = anon_sym_false,
  [anon_sym_SQUOTE] = anon_sym_SQUOTE,
  [aux_sym_character_token1] = aux_sym_character_token1,
  [sym_null] = sym_null,
  [sym_comment] = sym_comment,
  [sym_L] = sym_L,
  [sym__class_ident] = sym_identifier,
  [sym_class_definition] = sym_class_definition,
  [sym_class_directive] = sym_class_directive,
  [sym_super_directive] = sym_super_directive,
  [sym_source_directive] = sym_source_directive,
  [sym_implements_directive] = sym_implements_directive,
  [sym_field_definition] = sym_field_definition,
  [sym_method_definition] = sym_method_definition,
  [sym_annotation_directive] = sym_annotation_directive,
  [sym_annotation_visibility] = sym_annotation_visibility,
  [sym_annotation_property] = sym_annotation_property,
  [sym_annotation_value] = sym_annotation_value,
  [sym_subannotation_directive] = sym_subannotation_directive,
  [sym_param_directive] = sym_param_directive,
  [sym_parameter_directive] = sym_parameter_directive,
  [sym_statement] = sym_statement,
  [sym_expression] = sym_expression,
  [sym_opcode] = sym_opcode,
  [sym_value] = sym_value,
  [sym_directive] = sym_directive,
  [sym_line_directive] = sym_line_directive,
  [sym_locals_directive] = sym_locals_directive,
  [sym_local_directive] = sym_local_directive,
  [sym_end_local_directive] = sym_end_local_directive,
  [sym_restart_local_directive] = sym_restart_local_directive,
  [sym_registers_directive] = sym_registers_directive,
  [sym_catch_directive] = sym_catch_directive,
  [sym_catchall_directive] = sym_catchall_directive,
  [sym_packed_switch_directive] = sym_packed_switch_directive,
  [sym_sparse_switch_directive] = sym_sparse_switch_directive,
  [sym_array_data_directive] = sym_array_data_directive,
  [sym_class_identifier] = sym_class_identifier,
  [sym_label] = sym_label,
  [sym_jmp_label] = sym_jmp_label,
  [sym_body] = sym_body,
  [sym__field_body] = sym__field_body,
  [sym_method_signature] = sym_method_signature,
  [sym__method_signature_body] = sym__method_signature_body,
  [sym_method_handle] = sym_method_handle,
  [sym__full_field_body] = sym__full_field_body,
  [sym_full_method_signature] = sym_full_method_signature,
  [sym_custom_invoke] = sym_custom_invoke,
  [sym_type] = sym_type,
  [sym_array_type] = sym_array_type,
  [sym_primitive_type] = sym_primitive_type,
  [sym_access_modifiers] = sym_access_modifiers,
  [aux_sym__method_access_modifiers] = aux_sym__method_access_modifiers,
  [sym_access_modifier] = sym_access_modifier,
  [sym_enum_reference] = sym_enum_reference,
  [sym_register] = sym_register,
  [sym_list] = sym_list,
  [sym_range] = sym_range,
  [sym_literal] = sym_literal,
  [sym_string] = sym_string,
  [sym__escape_sequence] = sym__escape_sequence,
  [sym_boolean] = sym_boolean,
  [sym_character] = sym_character,
  [aux_sym_class_definition_repeat1] = aux_sym_class_definition_repeat1,
  [aux_sym_class_definition_repeat2] = aux_sym_class_definition_repeat2,
  [aux_sym_field_definition_repeat1] = aux_sym_field_definition_repeat1,
  [aux_sym_method_definition_repeat1] = aux_sym_method_definition_repeat1,
  [aux_sym_annotation_directive_repeat1] = aux_sym_annotation_directive_repeat1,
  [aux_sym_expression_repeat1] = aux_sym_expression_repeat1,
  [aux_sym_packed_switch_directive_repeat1] = aux_sym_packed_switch_directive_repeat1,
  [aux_sym_sparse_switch_directive_repeat1] = aux_sym_sparse_switch_directive_repeat1,
  [aux_sym_array_data_directive_repeat1] = aux_sym_array_data_directive_repeat1,
  [aux_sym_class_identifier_repeat1] = aux_sym_class_identifier_repeat1,
  [aux_sym__method_signature_body_repeat1] = aux_sym__method_signature_body_repeat1,
  [aux_sym_custom_invoke_repeat1] = aux_sym_custom_invoke_repeat1,
  [aux_sym_access_modifiers_repeat1] = aux_sym_access_modifiers_repeat1,
  [aux_sym_string_repeat1] = aux_sym_string_repeat1,
  [alias_sym_field_identifier] = alias_sym_field_identifier,
  [alias_sym_field_type] = alias_sym_field_type,
  [alias_sym_param_identifier] = alias_sym_param_identifier,
  [alias_sym_parameters] = alias_sym_parameters,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym_identifier] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_DOTclass] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOTsuper] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOTsource] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOTimplements] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOTfield] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOTendfield] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOTmethod] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOTendmethod] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOTannotation] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOTendannotation] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_system] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_build] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_runtime] = {
    .visible = true,
    .named = false,
  },
  [sym_annotation_key] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_DOTsubannotation] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOTendsubannotation] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOTparam] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOTendparam] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOTparameter] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOTendparameter] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LF] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_nop] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_move] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_move_SLASHfrom16] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_move_SLASH16] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_move_DASHwide] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_move_DASHwide_SLASHfrom16] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_move_DASHwide_SLASH16] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_move_DASHobject] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_move_DASHobject_SLASHfrom16] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_move_DASHobject_SLASH16] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_move_DASHresult] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_move_DASHresult_DASHwide] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_move_DASHresult_DASHobject] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_move_DASHexception] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_return_DASHvoid] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_return] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_return_DASHwide] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_return_DASHobject] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_const_SLASH4] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_const_SLASH16] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_const] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_const_SLASHhigh16] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_const_DASHwide_SLASH16] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_const_DASHwide_SLASH32] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_const_DASHwide] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_const_DASHwide_SLASHhigh16] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_const_DASHstring] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_const_DASHstring_SLASHjumbo] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_const_DASHclass] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_const_DASHmethod_DASHhandle] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_const_DASHmethod_DASHtype] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_monitor_DASHenter] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_monitor_DASHexit] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_check_DASHcast] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_instance_DASHof] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_array_DASHlength] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_new_DASHinstance] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_new_DASHarray] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_filled_DASHnew_DASHarray] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_filled_DASHnew_DASHarray_SLASHrange] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_fill_DASHarray_DASHdata] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_throw] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_throw_DASHverification_DASHerror] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_goto] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_goto_SLASH16] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_goto_SLASH32] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_packed_DASHswitch] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_sparse_DASHswitch] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_cmpl_DASHfloat] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_cmpg_DASHfloat] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_cmpl_DASHdouble] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_cmpg_DASHdouble] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_cmp_DASHlong] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_if_DASHeq] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_if_DASHne] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_if_DASHlt] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_if_DASHge] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_if_DASHgt] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_if_DASHle] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_if_DASHeqz] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_if_DASHnez] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_if_DASHltz] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_if_DASHgez] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_if_DASHgtz] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_if_DASHlez] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_aget] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_aget_DASHwide] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_aget_DASHobject] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_aget_DASHboolean] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_aget_DASHbyte] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_aget_DASHchar] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_aget_DASHshort] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_aput] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_aput_DASHwide] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_aput_DASHobject] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_aput_DASHboolean] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_aput_DASHbyte] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_aput_DASHchar] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_aput_DASHshort] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_iget] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_iget_DASHwide] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_iget_DASHobject] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_iget_DASHboolean] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_iget_DASHbyte] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_iget_DASHchar] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_iget_DASHshort] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_iget_DASHvolatile] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_iget_DASHwide_DASHvolatile] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_iget_DASHobject_DASHvolatile] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_iput] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_iput_DASHwide] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_iput_DASHobject] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_iput_DASHboolean] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_iput_DASHbyte] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_iput_DASHchar] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_iput_DASHshort] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_iput_DASHvolatile] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_iput_DASHwide_DASHvolatile] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_iput_DASHobject_DASHvolatile] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_sget] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_sget_DASHwide] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_sget_DASHobject] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_sget_DASHboolean] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_sget_DASHbyte] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_sget_DASHchar] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_sget_DASHshort] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_sget_DASHvolatile] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_sget_DASHwide_DASHvolatile] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_sget_DASHobject_DASHvolatile] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_sput] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_sput_DASHwide] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_sput_DASHobject] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_sput_DASHboolean] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_sput_DASHbyte] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_sput_DASHchar] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_sput_DASHshort] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_sput_DASHvolatile] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_sput_DASHwide_DASHvolatile] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_sput_DASHobject_DASHvolatile] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_invoke_DASHconstructor] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_invoke_DASHcustom] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_invoke_DASHdirect] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_invoke_DASHdirect_DASHempty] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_invoke_DASHinstance] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_invoke_DASHinterface] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_invoke_DASHpolymorphic] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_invoke_DASHstatic] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_invoke_DASHsuper] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_invoke_DASHvirtual] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_invoke_DASHcustom_SLASHrange] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_invoke_DASHdirect_SLASHrange] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_invoke_DASHinterface_SLASHrange] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_invoke_DASHobject_DASHinit_SLASHrange] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_invoke_DASHpolymorphic_SLASHrange] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_invoke_DASHstatic_SLASHrange] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_invoke_DASHsuper_SLASHrange] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_invoke_DASHvirtual_SLASHrange] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_neg_DASHint] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_not_DASHint] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_neg_DASHlong] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_not_DASHlong] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_neg_DASHfloat] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_neg_DASHdouble] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_int_DASHto_DASHlong] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_int_DASHto_DASHfloat] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_int_DASHto_DASHdouble] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_long_DASHto_DASHint] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_long_DASHto_DASHfloat] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_long_DASHto_DASHdouble] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_float_DASHto_DASHint] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_float_DASHto_DASHlong] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_float_DASHto_DASHdouble] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_double_DASHto_DASHint] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_double_DASHto_DASHlong] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_double_DASHto_DASHfloat] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_int_DASHto_DASHbyte] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_int_DASHto_DASHchar] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_int_DASHto_DASHshort] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_add_DASHint] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_sub_DASHint] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_mul_DASHint] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_div_DASHint] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_rem_DASHint] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_and_DASHint] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_or_DASHint] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_xor_DASHint] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_shl_DASHint] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_shr_DASHint] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ushr_DASHint] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_add_DASHlong] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_sub_DASHlong] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_mul_DASHlong] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_div_DASHlong] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_rem_DASHlong] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_and_DASHlong] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_or_DASHlong] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_xor_DASHlong] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_shl_DASHlong] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_shr_DASHlong] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ushr_DASHlong] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_add_DASHfloat] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_sub_DASHfloat] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_mul_DASHfloat] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_div_DASHfloat] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_rem_DASHfloat] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_add_DASHdouble] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_sub_DASHdouble] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_mul_DASHdouble] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_div_DASHdouble] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_rem_DASHdouble] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_add_DASHint_SLASH2addr] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_sub_DASHint_SLASH2addr] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_mul_DASHint_SLASH2addr] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_div_DASHint_SLASH2addr] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_rem_DASHint_SLASH2addr] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_and_DASHint_SLASH2addr] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_or_DASHint_SLASH2addr] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_xor_DASHint_SLASH2addr] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_shl_DASHint_SLASH2addr] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_shr_DASHint_SLASH2addr] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ushr_DASHint_SLASH2addr] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_add_DASHlong_SLASH2addr] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_sub_DASHlong_SLASH2addr] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_mul_DASHlong_SLASH2addr] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_div_DASHlong_SLASH2addr] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_rem_DASHlong_SLASH2addr] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_and_DASHlong_SLASH2addr] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_or_DASHlong_SLASH2addr] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_xor_DASHlong_SLASH2addr] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_shl_DASHlong_SLASH2addr] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_shr_DASHlong_SLASH2addr] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ushr_DASHlong_SLASH2addr] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_add_DASHfloat_SLASH2addr] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_sub_DASHfloat_SLASH2addr] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_mul_DASHfloat_SLASH2addr] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_div_DASHfloat_SLASH2addr] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_rem_DASHfloat_SLASH2addr] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_add_DASHdouble_SLASH2addr] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_sub_DASHdouble_SLASH2addr] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_mul_DASHdouble_SLASH2addr] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_div_DASHdouble_SLASH2addr] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_rem_DASHdouble_SLASH2addr] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_add_DASHint_SLASHlit16] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_sub_DASHint_SLASHlit16] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_mul_DASHint_SLASHlit16] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_div_DASHint_SLASHlit16] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_rem_DASHint_SLASHlit16] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_and_DASHint_SLASHlit16] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_or_DASHint_SLASHlit16] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_xor_DASHint_SLASHlit16] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_add_DASHint_SLASHlit8] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_sub_DASHint_SLASHlit8] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_mul_DASHint_SLASHlit8] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_div_DASHint_SLASHlit8] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_rem_DASHint_SLASHlit8] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_and_DASHint_SLASHlit8] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_or_DASHint_SLASHlit8] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_xor_DASHint_SLASHlit8] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_shl_DASHint_SLASHlit8] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_shr_DASHint_SLASHlit8] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ushr_DASHint_SLASHlit8] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_static_DASHget] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_static_DASHput] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_instance_DASHget] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_instance_DASHput] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_execute_DASHinline] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_execute_DASHinline_SLASHrange] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_iget_DASHquick] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_iget_DASHwide_DASHquick] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_iget_DASHobject_DASHquick] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_iput_DASHquick] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_iput_DASHwide_DASHquick] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_iput_DASHobject_DASHquick] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_iput_DASHboolean_DASHquick] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_iput_DASHbyte_DASHquick] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_iput_DASHchar_DASHquick] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_iput_DASHshort_DASHquick] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_invoke_DASHvirtual_DASHquick] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_invoke_DASHvirtual_DASHquick_SLASHrange] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_invoke_DASHsuper_DASHquick] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_invoke_DASHsuper_DASHquick_SLASHrange] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_rsub_DASHint] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_rsub_DASHint_SLASHlit8] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOTline] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOTlocals] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOTlocal] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOTendlocal] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOTrestartlocal] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOTregisters] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOTcatch] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOTcatchall] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOTpacked_DASHswitch] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOTendpacked_DASHswitch] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOTsparse_DASHswitch] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOTendsparse_DASHswitch] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOTarray_DASHdata] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOTendarray_DASHdata] = {
    .visible = true,
    .named = false,
  },
  [sym_prologue_directive] = {
    .visible = true,
    .named = true,
  },
  [sym_epilogue_directive] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SEMI] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_label_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_jmp_label_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_primitive_type_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_primitive_type_token2] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_constructor] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_public] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_private] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_protected] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_static] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_final] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_synchronized] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_volatile] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_bridge] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_transient] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_varargs] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_native] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_interface] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_abstract] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_strictfp] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_synthetic] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_annotation] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_enum] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_declared_DASHsynchronized] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_whitelist] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_greylist] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_blacklist] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_greylist_DASHmax_DASHo] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_greylist_DASHmax_DASHp] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_greylist_DASHmax_DASHq] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_greylist_DASHmax_DASHr] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_core_DASHplatform_DASHapi] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_test_DASHapi] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOTenum] = {
    .visible = true,
    .named = false,
  },
  [sym_variable] = {
    .visible = true,
    .named = true,
  },
  [sym_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_number] = {
    .visible = true,
    .named = true,
  },
  [sym_float] = {
    .visible = true,
    .named = true,
  },
  [sym_NaN] = {
    .visible = true,
    .named = true,
  },
  [sym_Infinity] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [sym_string_fragment] = {
    .visible = true,
    .named = true,
  },
  [aux_sym__escape_sequence_token1] = {
    .visible = false,
    .named = false,
  },
  [sym_escape_sequence] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_true] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_false] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SQUOTE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_character_token1] = {
    .visible = false,
    .named = false,
  },
  [sym_null] = {
    .visible = true,
    .named = true,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_L] = {
    .visible = true,
    .named = false,
  },
  [sym__class_ident] = {
    .visible = true,
    .named = true,
  },
  [sym_class_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_class_directive] = {
    .visible = true,
    .named = true,
  },
  [sym_super_directive] = {
    .visible = true,
    .named = true,
  },
  [sym_source_directive] = {
    .visible = true,
    .named = true,
  },
  [sym_implements_directive] = {
    .visible = true,
    .named = true,
  },
  [sym_field_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_method_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_annotation_directive] = {
    .visible = true,
    .named = true,
  },
  [sym_annotation_visibility] = {
    .visible = true,
    .named = true,
  },
  [sym_annotation_property] = {
    .visible = true,
    .named = true,
  },
  [sym_annotation_value] = {
    .visible = true,
    .named = true,
  },
  [sym_subannotation_directive] = {
    .visible = true,
    .named = true,
  },
  [sym_param_directive] = {
    .visible = true,
    .named = true,
  },
  [sym_parameter_directive] = {
    .visible = true,
    .named = true,
  },
  [sym_statement] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_opcode] = {
    .visible = true,
    .named = true,
  },
  [sym_value] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_directive] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_line_directive] = {
    .visible = true,
    .named = true,
  },
  [sym_locals_directive] = {
    .visible = true,
    .named = true,
  },
  [sym_local_directive] = {
    .visible = true,
    .named = true,
  },
  [sym_end_local_directive] = {
    .visible = true,
    .named = true,
  },
  [sym_restart_local_directive] = {
    .visible = true,
    .named = true,
  },
  [sym_registers_directive] = {
    .visible = true,
    .named = true,
  },
  [sym_catch_directive] = {
    .visible = true,
    .named = true,
  },
  [sym_catchall_directive] = {
    .visible = true,
    .named = true,
  },
  [sym_packed_switch_directive] = {
    .visible = true,
    .named = true,
  },
  [sym_sparse_switch_directive] = {
    .visible = true,
    .named = true,
  },
  [sym_array_data_directive] = {
    .visible = true,
    .named = true,
  },
  [sym_class_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_label] = {
    .visible = true,
    .named = true,
  },
  [sym_jmp_label] = {
    .visible = true,
    .named = true,
  },
  [sym_body] = {
    .visible = true,
    .named = true,
  },
  [sym__field_body] = {
    .visible = false,
    .named = true,
  },
  [sym_method_signature] = {
    .visible = true,
    .named = true,
  },
  [sym__method_signature_body] = {
    .visible = false,
    .named = true,
  },
  [sym_method_handle] = {
    .visible = true,
    .named = true,
  },
  [sym__full_field_body] = {
    .visible = false,
    .named = true,
  },
  [sym_full_method_signature] = {
    .visible = true,
    .named = true,
  },
  [sym_custom_invoke] = {
    .visible = true,
    .named = true,
  },
  [sym_type] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_array_type] = {
    .visible = true,
    .named = true,
  },
  [sym_primitive_type] = {
    .visible = true,
    .named = true,
  },
  [sym_access_modifiers] = {
    .visible = true,
    .named = true,
  },
  [aux_sym__method_access_modifiers] = {
    .visible = false,
    .named = false,
  },
  [sym_access_modifier] = {
    .visible = true,
    .named = true,
  },
  [sym_enum_reference] = {
    .visible = true,
    .named = true,
  },
  [sym_register] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_list] = {
    .visible = true,
    .named = true,
  },
  [sym_range] = {
    .visible = true,
    .named = true,
  },
  [sym_literal] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_string] = {
    .visible = true,
    .named = true,
  },
  [sym__escape_sequence] = {
    .visible = false,
    .named = true,
  },
  [sym_boolean] = {
    .visible = true,
    .named = true,
  },
  [sym_character] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_class_definition_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_class_definition_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_field_definition_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_method_definition_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_annotation_directive_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_expression_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_packed_switch_directive_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_sparse_switch_directive_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_array_data_directive_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_class_identifier_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__method_signature_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_custom_invoke_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_access_modifiers_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [alias_sym_field_identifier] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_field_type] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_param_identifier] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_parameters] = {
    .visible = true,
    .named = true,
  },
};

enum {
  field_element_width = 1,
  field_end = 2,
  field_start = 3,
  field_value = 4,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_element_width] = "element_width",
  [field_end] = "end",
  [field_start] = "start",
  [field_value] = "value",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [6] = {.index = 0, .length = 1},
  [9] = {.index = 1, .length = 2},
  [10] = {.index = 3, .length = 2},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_element_width, 1},
  [1] =
    {field_element_width, 1},
    {field_value, 2},
  [3] =
    {field_end, 3},
    {field_start, 1},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
  [1] = {
    [0] = anon_sym_DASH,
  },
  [2] = {
    [0] = alias_sym_field_identifier,
    [2] = alias_sym_field_type,
  },
  [3] = {
    [0] = sym_method_signature,
  },
  [4] = {
    [0] = anon_sym_DASH,
    [1] = anon_sym_DASH,
  },
  [5] = {
    [2] = alias_sym_param_identifier,
  },
  [7] = {
    [1] = alias_sym_parameters,
  },
  [8] = {
    [3] = alias_sym_param_identifier,
  },
};

static const uint16_t ts_non_terminal_alias_map[] = {
  sym__method_signature_body, 2,
    sym__method_signature_body,
    sym_method_signature,
  sym_type, 2,
    sym_type,
    alias_sym_field_type,
  aux_sym__method_signature_body_repeat1, 2,
    aux_sym__method_signature_body_repeat1,
    alias_sym_parameters,
  0,
};

static const TSStateId ts_primary_state_ids[STATE_COUNT] = {
  [0] = 0,
  [1] = 1,
  [2] = 2,
  [3] = 3,
  [4] = 4,
  [5] = 3,
  [6] = 6,
  [7] = 7,
  [8] = 7,
  [9] = 9,
  [10] = 10,
  [11] = 11,
  [12] = 12,
  [13] = 13,
  [14] = 14,
  [15] = 15,
  [16] = 16,
  [17] = 17,
  [18] = 18,
  [19] = 19,
  [20] = 20,
  [21] = 21,
  [22] = 22,
  [23] = 23,
  [24] = 24,
  [25] = 25,
  [26] = 26,
  [27] = 27,
  [28] = 28,
  [29] = 29,
  [30] = 30,
  [31] = 31,
  [32] = 32,
  [33] = 33,
  [34] = 34,
  [35] = 35,
  [36] = 36,
  [37] = 36,
  [38] = 38,
  [39] = 39,
  [40] = 40,
  [41] = 41,
  [42] = 42,
  [43] = 43,
  [44] = 44,
  [45] = 45,
  [46] = 46,
  [47] = 47,
  [48] = 48,
  [49] = 49,
  [50] = 50,
  [51] = 51,
  [52] = 52,
  [53] = 53,
  [54] = 54,
  [55] = 55,
  [56] = 56,
  [57] = 57,
  [58] = 58,
  [59] = 59,
  [60] = 60,
  [61] = 61,
  [62] = 62,
  [63] = 63,
  [64] = 64,
  [65] = 65,
  [66] = 66,
  [67] = 67,
  [68] = 68,
  [69] = 69,
  [70] = 70,
  [71] = 71,
  [72] = 72,
  [73] = 73,
  [74] = 74,
  [75] = 75,
  [76] = 76,
  [77] = 77,
  [78] = 78,
  [79] = 79,
  [80] = 77,
  [81] = 79,
  [82] = 78,
  [83] = 42,
  [84] = 41,
  [85] = 85,
  [86] = 86,
  [87] = 87,
  [88] = 88,
  [89] = 89,
  [90] = 90,
  [91] = 91,
  [92] = 92,
  [93] = 93,
  [94] = 94,
  [95] = 95,
  [96] = 96,
  [97] = 97,
  [98] = 98,
  [99] = 99,
  [100] = 100,
  [101] = 101,
  [102] = 102,
  [103] = 101,
  [104] = 101,
  [105] = 97,
  [106] = 101,
  [107] = 107,
  [108] = 108,
  [109] = 109,
  [110] = 97,
  [111] = 97,
  [112] = 112,
  [113] = 112,
  [114] = 114,
  [115] = 115,
  [116] = 116,
  [117] = 117,
  [118] = 117,
  [119] = 116,
  [120] = 120,
  [121] = 115,
  [122] = 115,
  [123] = 115,
  [124] = 124,
  [125] = 125,
  [126] = 126,
  [127] = 127,
  [128] = 128,
  [129] = 114,
  [130] = 130,
  [131] = 120,
  [132] = 114,
  [133] = 116,
  [134] = 120,
  [135] = 135,
  [136] = 117,
  [137] = 115,
  [138] = 138,
  [139] = 117,
  [140] = 140,
  [141] = 116,
  [142] = 142,
  [143] = 143,
  [144] = 144,
  [145] = 145,
  [146] = 146,
  [147] = 147,
  [148] = 148,
  [149] = 149,
  [150] = 20,
  [151] = 151,
  [152] = 152,
  [153] = 99,
  [154] = 154,
  [155] = 155,
  [156] = 155,
  [157] = 157,
  [158] = 157,
  [159] = 151,
  [160] = 160,
  [161] = 161,
  [162] = 152,
  [163] = 163,
  [164] = 152,
  [165] = 157,
  [166] = 124,
  [167] = 17,
  [168] = 21,
  [169] = 42,
  [170] = 41,
  [171] = 171,
  [172] = 172,
  [173] = 173,
  [174] = 99,
  [175] = 175,
  [176] = 176,
  [177] = 176,
  [178] = 176,
  [179] = 175,
  [180] = 180,
  [181] = 175,
  [182] = 182,
  [183] = 183,
  [184] = 19,
  [185] = 185,
  [186] = 172,
  [187] = 18,
  [188] = 25,
  [189] = 30,
  [190] = 31,
  [191] = 24,
  [192] = 192,
  [193] = 193,
  [194] = 194,
  [195] = 195,
  [196] = 196,
  [197] = 197,
  [198] = 198,
  [199] = 199,
  [200] = 200,
  [201] = 201,
  [202] = 200,
  [203] = 203,
  [204] = 204,
  [205] = 194,
  [206] = 206,
  [207] = 192,
  [208] = 208,
  [209] = 209,
  [210] = 210,
  [211] = 211,
  [212] = 212,
  [213] = 213,
  [214] = 214,
  [215] = 214,
  [216] = 212,
  [217] = 217,
  [218] = 218,
  [219] = 185,
  [220] = 220,
  [221] = 221,
  [222] = 210,
  [223] = 195,
  [224] = 224,
  [225] = 225,
  [226] = 226,
  [227] = 227,
  [228] = 228,
  [229] = 229,
  [230] = 230,
  [231] = 231,
  [232] = 232,
  [233] = 233,
  [234] = 234,
  [235] = 235,
  [236] = 236,
  [237] = 224,
  [238] = 238,
  [239] = 239,
  [240] = 240,
  [241] = 241,
  [242] = 242,
  [243] = 243,
  [244] = 235,
  [245] = 224,
  [246] = 246,
  [247] = 224,
  [248] = 248,
  [249] = 234,
  [250] = 230,
  [251] = 17,
  [252] = 234,
  [253] = 253,
  [254] = 234,
  [255] = 255,
  [256] = 229,
  [257] = 20,
  [258] = 258,
  [259] = 241,
  [260] = 21,
  [261] = 229,
  [262] = 262,
  [263] = 29,
  [264] = 264,
  [265] = 27,
  [266] = 246,
  [267] = 17,
  [268] = 28,
  [269] = 269,
  [270] = 270,
  [271] = 230,
  [272] = 225,
  [273] = 248,
  [274] = 20,
  [275] = 21,
  [276] = 124,
  [277] = 232,
  [278] = 32,
  [279] = 279,
  [280] = 264,
  [281] = 42,
  [282] = 41,
  [283] = 242,
  [284] = 227,
  [285] = 128,
  [286] = 286,
  [287] = 100,
  [288] = 31,
  [289] = 27,
  [290] = 290,
  [291] = 291,
  [292] = 34,
  [293] = 109,
  [294] = 108,
  [295] = 24,
  [296] = 90,
  [297] = 89,
  [298] = 29,
  [299] = 299,
  [300] = 300,
  [301] = 107,
  [302] = 96,
  [303] = 149,
  [304] = 147,
  [305] = 142,
  [306] = 146,
  [307] = 307,
  [308] = 33,
  [309] = 28,
  [310] = 310,
  [311] = 23,
  [312] = 95,
  [313] = 94,
  [314] = 143,
  [315] = 30,
  [316] = 25,
  [317] = 26,
  [318] = 88,
  [319] = 319,
  [320] = 18,
  [321] = 22,
  [322] = 23,
  [323] = 323,
  [324] = 32,
  [325] = 325,
  [326] = 19,
  [327] = 327,
  [328] = 328,
  [329] = 291,
  [330] = 330,
  [331] = 331,
  [332] = 307,
  [333] = 327,
  [334] = 334,
  [335] = 328,
  [336] = 328,
  [337] = 337,
  [338] = 338,
  [339] = 310,
  [340] = 340,
  [341] = 341,
  [342] = 342,
  [343] = 343,
  [344] = 340,
  [345] = 345,
  [346] = 346,
  [347] = 347,
  [348] = 348,
  [349] = 349,
  [350] = 328,
  [351] = 299,
  [352] = 319,
  [353] = 102,
  [354] = 323,
  [355] = 307,
  [356] = 356,
  [357] = 357,
  [358] = 358,
  [359] = 359,
  [360] = 360,
  [361] = 361,
  [362] = 362,
  [363] = 363,
  [364] = 364,
  [365] = 365,
  [366] = 366,
  [367] = 367,
  [368] = 368,
  [369] = 369,
  [370] = 370,
  [371] = 371,
  [372] = 372,
  [373] = 370,
  [374] = 374,
  [375] = 375,
  [376] = 376,
  [377] = 377,
  [378] = 378,
  [379] = 365,
  [380] = 369,
  [381] = 381,
  [382] = 382,
  [383] = 383,
  [384] = 384,
  [385] = 385,
  [386] = 386,
  [387] = 387,
  [388] = 364,
  [389] = 389,
  [390] = 358,
  [391] = 391,
  [392] = 370,
  [393] = 393,
  [394] = 360,
  [395] = 363,
  [396] = 381,
  [397] = 391,
  [398] = 378,
  [399] = 365,
  [400] = 369,
  [401] = 378,
  [402] = 402,
  [403] = 403,
  [404] = 385,
  [405] = 378,
  [406] = 406,
  [407] = 360,
  [408] = 408,
  [409] = 358,
  [410] = 38,
  [411] = 411,
  [412] = 412,
  [413] = 413,
  [414] = 369,
  [415] = 362,
  [416] = 367,
  [417] = 417,
  [418] = 387,
};

static inline bool sym_escape_sequence_character_set_1(int32_t c) {
  return (c < 'a'
    ? (c < '?'
      ? (c < '\''
        ? c == '"'
        : c <= '\'')
      : (c <= '?' || c == '\\'))
    : (c <= 'b' || (c < 'r'
      ? (c < 'n'
        ? c == 'f'
        : c <= 'n')
      : (c <= 'r' || (c >= 't' && c <= 'v')))));
}

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(608);
      if (lookahead == '"') ADVANCE(1256);
      if (lookahead == '#') ADVANCE(1274);
      if (lookahead == '\'') ADVANCE(1268);
      if (lookahead == '(') ADVANCE(1228);
      if (lookahead == ')') ADVANCE(1229);
      if (lookahead == '+') ADVANCE(30);
      if (lookahead == ',') ADVANCE(625);
      if (lookahead == '-') ADVANCE(1225);
      if (lookahead == '.') ADVANCE(28);
      if (lookahead == '/') ADVANCE(1219);
      if (lookahead == '0') ADVANCE(1237);
      if (lookahead == ':') ADVANCE(784);
      if (lookahead == ';') ADVANCE(1220);
      if (lookahead == '<') ADVANCE(604);
      if (lookahead == '=') ADVANCE(614);
      if (lookahead == '@') ADVANCE(1230);
      if (('B' <= lookahead && lookahead <= 'D') ||
          lookahead == 'F' ||
          lookahead == 'J' ||
          lookahead == 'S' ||
          lookahead == 'V' ||
          lookahead == 'Z') ADVANCE(1232);
      if (lookahead == 'I') ADVANCE(1233);
      if (lookahead == 'N') ADVANCE(923);
      if (lookahead == '[') ADVANCE(1231);
      if (lookahead == '\\') ADVANCE(578);
      if (lookahead == 'a') ADVANCE(955);
      if (lookahead == 'c') ADVANCE(1097);
      if (lookahead == 'd') ADVANCE(1012);
      if (lookahead == 'e') ADVANCE(1214);
      if (lookahead == 'f') ADVANCE(924);
      if (lookahead == 'g') ADVANCE(1098);
      if (lookahead == 'i') ADVANCE(1006);
      if (lookahead == 'm') ADVANCE(1107);
      if (lookahead == 'n') ADVANCE(1099);
      if (lookahead == 'o') ADVANCE(1136);
      if (lookahead == 'r') ADVANCE(966);
      if (lookahead == 's') ADVANCE(1007);
      if (lookahead == 't') ADVANCE(1008);
      if (lookahead == 'u') ADVANCE(1150);
      if (lookahead == 'x') ADVANCE(1130);
      if (lookahead == '{') ADVANCE(789);
      if (lookahead == '}') ADVANCE(791);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(605)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1240);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Y') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1:
      if (lookahead == '\n') ADVANCE(628);
      if (lookahead == '"') ADVANCE(1256);
      if (lookahead == '#') ADVANCE(1274);
      if (lookahead == '$') ADVANCE(1218);
      if (lookahead == '\'') ADVANCE(1268);
      if (lookahead == '(') ADVANCE(1228);
      if (lookahead == '+') ADVANCE(30);
      if (lookahead == '-') ADVANCE(1226);
      if (lookahead == '.') ADVANCE(313);
      if (lookahead == '0') ADVANCE(1238);
      if (lookahead == ':') ADVANCE(111);
      if (lookahead == '<') ADVANCE(604);
      if (('B' <= lookahead && lookahead <= 'D') ||
          lookahead == 'F' ||
          lookahead == 'J' ||
          lookahead == 'S' ||
          lookahead == 'V' ||
          lookahead == 'Z') ADVANCE(1232);
      if (lookahead == 'I') ADVANCE(1234);
      if (lookahead == 'N') ADVANCE(837);
      if (lookahead == '[') ADVANCE(1231);
      if (lookahead == 'a') ADVANCE(842);
      if (lookahead == 'c') ADVANCE(880);
      if (lookahead == 'd') ADVANCE(863);
      if (lookahead == 'e') ADVANCE(919);
      if (lookahead == 'f') ADVANCE(838);
      if (lookahead == 'g') ADVANCE(881);
      if (lookahead == 'i') ADVANCE(858);
      if (lookahead == 'm') ADVANCE(887);
      if (lookahead == 'n') ADVANCE(882);
      if (lookahead == 'o') ADVANCE(890);
      if (lookahead == 'r') ADVANCE(846);
      if (lookahead == 's') ADVANCE(859);
      if (lookahead == 't') ADVANCE(860);
      if (lookahead == 'u') ADVANCE(895);
      if (lookahead == 'x') ADVANCE(888);
      if (lookahead == '{') ADVANCE(789);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(1)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1239);
      if (('A' <= lookahead && lookahead <= 'Y') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(921);
      END_STATE();
    case 2:
      if (lookahead == '\n') ADVANCE(629);
      if (lookahead == '#') ADVANCE(1274);
      if (lookahead == '(') ADVANCE(1228);
      if (lookahead == ',') ADVANCE(625);
      if (lookahead == '-') ADVANCE(112);
      if (lookahead == ':') ADVANCE(784);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(2)
      END_STATE();
    case 3:
      if (lookahead == ' ') ADVANCE(188);
      END_STATE();
    case 4:
      if (lookahead == ' ') ADVANCE(324);
      END_STATE();
    case 5:
      if (lookahead == ' ') ADVANCE(323);
      END_STATE();
    case 6:
      if (lookahead == ' ') ADVANCE(390);
      END_STATE();
    case 7:
      if (lookahead == ' ') ADVANCE(134);
      END_STATE();
    case 8:
      if (lookahead == ' ') ADVANCE(191);
      END_STATE();
    case 9:
      if (lookahead == ' ') ADVANCE(396);
      END_STATE();
    case 10:
      if (lookahead == ' ') ADVANCE(389);
      END_STATE();
    case 11:
      if (lookahead == '"') ADVANCE(1256);
      if (lookahead == '#') ADVANCE(1274);
      if (lookahead == '$') ADVANCE(1218);
      if (lookahead == '\'') ADVANCE(1268);
      if (lookahead == '(') ADVANCE(1228);
      if (lookahead == '+') ADVANCE(30);
      if (lookahead == '-') ADVANCE(1226);
      if (lookahead == '.') ADVANCE(186);
      if (lookahead == '0') ADVANCE(1238);
      if (lookahead == ':') ADVANCE(111);
      if (lookahead == '<') ADVANCE(604);
      if (('B' <= lookahead && lookahead <= 'D') ||
          lookahead == 'F' ||
          lookahead == 'J' ||
          lookahead == 'S' ||
          lookahead == 'V' ||
          lookahead == 'Z') ADVANCE(1232);
      if (lookahead == 'I') ADVANCE(1234);
      if (lookahead == 'N') ADVANCE(837);
      if (lookahead == '[') ADVANCE(1231);
      if (lookahead == 'a') ADVANCE(842);
      if (lookahead == 'c') ADVANCE(880);
      if (lookahead == 'd') ADVANCE(863);
      if (lookahead == 'e') ADVANCE(919);
      if (lookahead == 'f') ADVANCE(838);
      if (lookahead == 'g') ADVANCE(881);
      if (lookahead == 'i') ADVANCE(858);
      if (lookahead == 'm') ADVANCE(887);
      if (lookahead == 'n') ADVANCE(882);
      if (lookahead == 'o') ADVANCE(890);
      if (lookahead == 'r') ADVANCE(846);
      if (lookahead == 's') ADVANCE(859);
      if (lookahead == 't') ADVANCE(860);
      if (lookahead == 'u') ADVANCE(895);
      if (lookahead == 'x') ADVANCE(888);
      if (lookahead == '{') ADVANCE(789);
      if (lookahead == '}') ADVANCE(791);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(11)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1239);
      if (('A' <= lookahead && lookahead <= 'Y') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(921);
      END_STATE();
    case 12:
      if (lookahead == '"') ADVANCE(1256);
      if (lookahead == '#') ADVANCE(1274);
      if (lookahead == '$') ADVANCE(1218);
      if (lookahead == '\'') ADVANCE(1268);
      if (lookahead == '+') ADVANCE(30);
      if (lookahead == ',') ADVANCE(625);
      if (lookahead == '-') ADVANCE(27);
      if (lookahead == '.') ADVANCE(113);
      if (lookahead == '0') ADVANCE(1238);
      if (lookahead == ':') ADVANCE(111);
      if (lookahead == '<') ADVANCE(604);
      if (lookahead == 'I') ADVANCE(876);
      if (lookahead == 'N') ADVANCE(837);
      if (lookahead == 'a') ADVANCE(842);
      if (lookahead == 'c') ADVANCE(880);
      if (lookahead == 'd') ADVANCE(863);
      if (lookahead == 'e') ADVANCE(919);
      if (lookahead == 'f') ADVANCE(838);
      if (lookahead == 'g') ADVANCE(881);
      if (lookahead == 'i') ADVANCE(858);
      if (lookahead == 'm') ADVANCE(887);
      if (lookahead == 'n') ADVANCE(882);
      if (lookahead == 'o') ADVANCE(890);
      if (lookahead == 'r') ADVANCE(846);
      if (lookahead == 's') ADVANCE(859);
      if (lookahead == 't') ADVANCE(860);
      if (lookahead == 'u') ADVANCE(895);
      if (lookahead == 'x') ADVANCE(888);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(12)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1239);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(921);
      END_STATE();
    case 13:
      if (lookahead == '"') ADVANCE(1256);
      if (lookahead == '#') ADVANCE(1274);
      if (lookahead == '$') ADVANCE(1218);
      if (lookahead == '\'') ADVANCE(1268);
      if (lookahead == '+') ADVANCE(30);
      if (lookahead == '-') ADVANCE(27);
      if (lookahead == '.') ADVANCE(114);
      if (lookahead == '0') ADVANCE(1238);
      if (lookahead == ':') ADVANCE(111);
      if (lookahead == '<') ADVANCE(604);
      if (lookahead == 'I') ADVANCE(876);
      if (lookahead == 'N') ADVANCE(837);
      if (lookahead == 'a') ADVANCE(842);
      if (lookahead == 'c') ADVANCE(880);
      if (lookahead == 'd') ADVANCE(863);
      if (lookahead == 'e') ADVANCE(919);
      if (lookahead == 'f') ADVANCE(838);
      if (lookahead == 'g') ADVANCE(881);
      if (lookahead == 'i') ADVANCE(858);
      if (lookahead == 'm') ADVANCE(887);
      if (lookahead == 'n') ADVANCE(882);
      if (lookahead == 'o') ADVANCE(890);
      if (lookahead == 'r') ADVANCE(846);
      if (lookahead == 's') ADVANCE(859);
      if (lookahead == 't') ADVANCE(860);
      if (lookahead == 'u') ADVANCE(895);
      if (lookahead == 'x') ADVANCE(888);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(13)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1239);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(921);
      END_STATE();
    case 14:
      if (lookahead == '"') ADVANCE(1256);
      if (lookahead == '#') ADVANCE(1274);
      if (lookahead == '\'') ADVANCE(1268);
      if (lookahead == '(') ADVANCE(1228);
      if (lookahead == '+') ADVANCE(30);
      if (lookahead == '-') ADVANCE(1226);
      if (lookahead == '.') ADVANCE(313);
      if (lookahead == '0') ADVANCE(1237);
      if (lookahead == '<') ADVANCE(604);
      if (lookahead == 'I') ADVANCE(1064);
      if (lookahead == 'N') ADVANCE(923);
      if (lookahead == '[') ADVANCE(1231);
      if (lookahead == 'f') ADVANCE(925);
      if (lookahead == 'n') ADVANCE(1204);
      if (lookahead == 't') ADVANCE(1139);
      if (lookahead == '{') ADVANCE(789);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(14)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1240);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 15:
      if (lookahead == '"') ADVANCE(1256);
      if (lookahead == '#') ADVANCE(1274);
      if (lookahead == '(') ADVANCE(1228);
      if (lookahead == ')') ADVANCE(1229);
      if (lookahead == '+') ADVANCE(30);
      if (lookahead == '-') ADVANCE(1227);
      if (lookahead == '.') ADVANCE(314);
      if (lookahead == '0') ADVANCE(1241);
      if (lookahead == '<') ADVANCE(604);
      if (('B' <= lookahead && lookahead <= 'D') ||
          lookahead == 'F' ||
          lookahead == 'I' ||
          lookahead == 'J' ||
          lookahead == 'S' ||
          lookahead == 'V' ||
          lookahead == 'Z') ADVANCE(1232);
      if (lookahead == '[') ADVANCE(1231);
      if (lookahead == 'a') ADVANCE(955);
      if (lookahead == 'c') ADVANCE(1097);
      if (lookahead == 'd') ADVANCE(1012);
      if (lookahead == 'e') ADVANCE(1214);
      if (lookahead == 'f') ADVANCE(1015);
      if (lookahead == 'g') ADVANCE(1098);
      if (lookahead == 'i') ADVANCE(1006);
      if (lookahead == 'm') ADVANCE(1107);
      if (lookahead == 'n') ADVANCE(1100);
      if (lookahead == 'o') ADVANCE(1136);
      if (lookahead == 'r') ADVANCE(966);
      if (lookahead == 's') ADVANCE(1007);
      if (lookahead == 't') ADVANCE(1009);
      if (lookahead == 'u') ADVANCE(1150);
      if (lookahead == 'x') ADVANCE(1130);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(15)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1247);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Y') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 16:
      if (lookahead == '"') ADVANCE(1256);
      if (lookahead == '#') ADVANCE(1274);
      if (lookahead == '(') ADVANCE(1228);
      if (lookahead == '+') ADVANCE(30);
      if (lookahead == '-') ADVANCE(1227);
      if (lookahead == '0') ADVANCE(1241);
      if (lookahead == '<') ADVANCE(604);
      if (lookahead == '[') ADVANCE(1231);
      if (lookahead == 'a') ADVANCE(955);
      if (lookahead == 'c') ADVANCE(1097);
      if (lookahead == 'd') ADVANCE(1012);
      if (lookahead == 'e') ADVANCE(1214);
      if (lookahead == 'f') ADVANCE(1015);
      if (lookahead == 'g') ADVANCE(1098);
      if (lookahead == 'i') ADVANCE(1006);
      if (lookahead == 'm') ADVANCE(1107);
      if (lookahead == 'n') ADVANCE(1100);
      if (lookahead == 'o') ADVANCE(1136);
      if (lookahead == 'r') ADVANCE(966);
      if (lookahead == 's') ADVANCE(1007);
      if (lookahead == 't') ADVANCE(1009);
      if (lookahead == 'u') ADVANCE(1150);
      if (lookahead == 'x') ADVANCE(1130);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(16)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1247);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 17:
      if (lookahead == '"') ADVANCE(1256);
      if (lookahead == '#') ADVANCE(1257);
      if (lookahead == '\\') ADVANCE(578);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(1258);
      if (lookahead != 0) ADVANCE(1259);
      END_STATE();
    case 18:
      if (lookahead == '#') ADVANCE(1274);
      if (lookahead == ')') ADVANCE(1229);
      if (lookahead == '-') ADVANCE(112);
      if (lookahead == '@') ADVANCE(1230);
      if (('B' <= lookahead && lookahead <= 'D') ||
          lookahead == 'F' ||
          lookahead == 'I' ||
          lookahead == 'J' ||
          lookahead == 'S' ||
          lookahead == 'V' ||
          lookahead == 'Z') ADVANCE(1232);
      if (lookahead == '[') ADVANCE(1231);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(18)
      END_STATE();
    case 19:
      if (lookahead == '#') ADVANCE(1274);
      if (lookahead == '+') ADVANCE(30);
      if (lookahead == '-') ADVANCE(1227);
      if (lookahead == '0') ADVANCE(1241);
      if (lookahead == '<') ADVANCE(604);
      if (lookahead == '[') ADVANCE(1231);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(19)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1247);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 20:
      if (lookahead == '#') ADVANCE(1271);
      if (lookahead == '\'') ADVANCE(1268);
      if (lookahead == '\\') ADVANCE(578);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(1270);
      if (lookahead != 0) ADVANCE(1269);
      END_STATE();
    case 21:
      if (lookahead == '-') ADVANCE(223);
      END_STATE();
    case 22:
      if (lookahead == '-') ADVANCE(532);
      END_STATE();
    case 23:
      if (lookahead == '-') ADVANCE(285);
      END_STATE();
    case 24:
      if (lookahead == '-') ADVANCE(538);
      END_STATE();
    case 25:
      if (lookahead == '-') ADVANCE(539);
      END_STATE();
    case 26:
      if (lookahead == '-') ADVANCE(540);
      END_STATE();
    case 27:
      if (lookahead == '.') ADVANCE(597);
      if (lookahead == '0') ADVANCE(1237);
      if (lookahead == 'I') ADVANCE(407);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1240);
      END_STATE();
    case 28:
      if (lookahead == '.') ADVANCE(790);
      if (lookahead == 'a') ADVANCE(414);
      if (lookahead == 'c') ADVANCE(116);
      if (lookahead == 'e') ADVANCE(408);
      if (lookahead == 'f') ADVANCE(354);
      if (lookahead == 'i') ADVANCE(397);
      if (lookahead == 'l') ADVANCE(353);
      if (lookahead == 'm') ADVANCE(305);
      if (lookahead == 'p') ADVANCE(117);
      if (lookahead == 'r') ADVANCE(288);
      if (lookahead == 's') ADVANCE(446);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1251);
      END_STATE();
    case 29:
      if (lookahead == '.') ADVANCE(790);
      if (lookahead == 'a') ADVANCE(414);
      if (lookahead == 'c') ADVANCE(115);
      if (lookahead == 'e') ADVANCE(421);
      if (lookahead == 'f') ADVANCE(354);
      if (lookahead == 'i') ADVANCE(397);
      if (lookahead == 'l') ADVANCE(353);
      if (lookahead == 'm') ADVANCE(305);
      if (lookahead == 'p') ADVANCE(117);
      if (lookahead == 'r') ADVANCE(288);
      if (lookahead == 's') ADVANCE(445);
      END_STATE();
    case 30:
      if (lookahead == '0') ADVANCE(1246);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1247);
      END_STATE();
    case 31:
      if (lookahead == '1') ADVANCE(84);
      if (lookahead == '3') ADVANCE(50);
      END_STATE();
    case 32:
      if (lookahead == '1') ADVANCE(85);
      if (lookahead == 'f') ADVANCE(509);
      END_STATE();
    case 33:
      if (lookahead == '1') ADVANCE(86);
      if (lookahead == '4') ADVANCE(644);
      if (lookahead == 'h') ADVANCE(352);
      END_STATE();
    case 34:
      if (lookahead == '1') ADVANCE(87);
      END_STATE();
    case 35:
      if (lookahead == '1') ADVANCE(88);
      END_STATE();
    case 36:
      if (lookahead == '1') ADVANCE(89);
      if (lookahead == 'f') ADVANCE(515);
      END_STATE();
    case 37:
      if (lookahead == '1') ADVANCE(90);
      if (lookahead == '8') ADVANCE(768);
      END_STATE();
    case 38:
      if (lookahead == '1') ADVANCE(91);
      if (lookahead == '8') ADVANCE(762);
      END_STATE();
    case 39:
      if (lookahead == '1') ADVANCE(92);
      if (lookahead == '8') ADVANCE(767);
      END_STATE();
    case 40:
      if (lookahead == '1') ADVANCE(93);
      if (lookahead == '3') ADVANCE(51);
      if (lookahead == 'h') ADVANCE(379);
      END_STATE();
    case 41:
      if (lookahead == '1') ADVANCE(94);
      if (lookahead == '8') ADVANCE(765);
      END_STATE();
    case 42:
      if (lookahead == '1') ADVANCE(95);
      if (lookahead == '8') ADVANCE(764);
      END_STATE();
    case 43:
      if (lookahead == '1') ADVANCE(96);
      if (lookahead == '8') ADVANCE(766);
      END_STATE();
    case 44:
      if (lookahead == '1') ADVANCE(97);
      if (lookahead == '8') ADVANCE(763);
      END_STATE();
    case 45:
      if (lookahead == '1') ADVANCE(98);
      if (lookahead == '8') ADVANCE(769);
      END_STATE();
    case 46:
      if (lookahead == '1') ADVANCE(99);
      if (lookahead == 'f') ADVANCE(527);
      END_STATE();
    case 47:
      if (lookahead == '1') ADVANCE(100);
      END_STATE();
    case 48:
      if (lookahead == '1') ADVANCE(101);
      END_STATE();
    case 49:
      if (lookahead == '1') ADVANCE(102);
      END_STATE();
    case 50:
      if (lookahead == '2') ADVANCE(662);
      END_STATE();
    case 51:
      if (lookahead == '2') ADVANCE(650);
      END_STATE();
    case 52:
      if (lookahead == '2') ADVANCE(128);
      if (lookahead == 'l') ADVANCE(361);
      END_STATE();
    case 53:
      if (lookahead == '2') ADVANCE(137);
      if (lookahead == 'l') ADVANCE(363);
      END_STATE();
    case 54:
      if (lookahead == '2') ADVANCE(142);
      if (lookahead == 'l') ADVANCE(365);
      END_STATE();
    case 55:
      if (lookahead == '2') ADVANCE(145);
      if (lookahead == 'l') ADVANCE(366);
      END_STATE();
    case 56:
      if (lookahead == '2') ADVANCE(148);
      if (lookahead == 'l') ADVANCE(367);
      END_STATE();
    case 57:
      if (lookahead == '2') ADVANCE(150);
      END_STATE();
    case 58:
      if (lookahead == '2') ADVANCE(152);
      if (lookahead == 'l') ADVANCE(368);
      END_STATE();
    case 59:
      if (lookahead == '2') ADVANCE(154);
      if (lookahead == 'l') ADVANCE(369);
      END_STATE();
    case 60:
      if (lookahead == '2') ADVANCE(156);
      if (lookahead == 'l') ADVANCE(370);
      END_STATE();
    case 61:
      if (lookahead == '2') ADVANCE(158);
      if (lookahead == 'l') ADVANCE(371);
      END_STATE();
    case 62:
      if (lookahead == '2') ADVANCE(160);
      if (lookahead == 'l') ADVANCE(372);
      END_STATE();
    case 63:
      if (lookahead == '2') ADVANCE(162);
      END_STATE();
    case 64:
      if (lookahead == '2') ADVANCE(164);
      END_STATE();
    case 65:
      if (lookahead == '2') ADVANCE(166);
      END_STATE();
    case 66:
      if (lookahead == '2') ADVANCE(168);
      END_STATE();
    case 67:
      if (lookahead == '2') ADVANCE(169);
      END_STATE();
    case 68:
      if (lookahead == '2') ADVANCE(170);
      END_STATE();
    case 69:
      if (lookahead == '2') ADVANCE(171);
      END_STATE();
    case 70:
      if (lookahead == '2') ADVANCE(172);
      END_STATE();
    case 71:
      if (lookahead == '2') ADVANCE(173);
      if (lookahead == 'l') ADVANCE(374);
      END_STATE();
    case 72:
      if (lookahead == '2') ADVANCE(174);
      END_STATE();
    case 73:
      if (lookahead == '2') ADVANCE(175);
      END_STATE();
    case 74:
      if (lookahead == '2') ADVANCE(176);
      END_STATE();
    case 75:
      if (lookahead == '2') ADVANCE(177);
      END_STATE();
    case 76:
      if (lookahead == '2') ADVANCE(178);
      END_STATE();
    case 77:
      if (lookahead == '2') ADVANCE(179);
      END_STATE();
    case 78:
      if (lookahead == '2') ADVANCE(180);
      END_STATE();
    case 79:
      if (lookahead == '2') ADVANCE(181);
      END_STATE();
    case 80:
      if (lookahead == '2') ADVANCE(182);
      END_STATE();
    case 81:
      if (lookahead == '2') ADVANCE(183);
      END_STATE();
    case 82:
      if (lookahead == '2') ADVANCE(184);
      END_STATE();
    case 83:
      if (lookahead == '2') ADVANCE(185);
      END_STATE();
    case 84:
      if (lookahead == '6') ADVANCE(661);
      END_STATE();
    case 85:
      if (lookahead == '6') ADVANCE(635);
      END_STATE();
    case 86:
      if (lookahead == '6') ADVANCE(645);
      END_STATE();
    case 87:
      if (lookahead == '6') ADVANCE(634);
      END_STATE();
    case 88:
      if (lookahead == '6') ADVANCE(648);
      END_STATE();
    case 89:
      if (lookahead == '6') ADVANCE(638);
      END_STATE();
    case 90:
      if (lookahead == '6') ADVANCE(760);
      END_STATE();
    case 91:
      if (lookahead == '6') ADVANCE(754);
      END_STATE();
    case 92:
      if (lookahead == '6') ADVANCE(759);
      END_STATE();
    case 93:
      if (lookahead == '6') ADVANCE(649);
      END_STATE();
    case 94:
      if (lookahead == '6') ADVANCE(757);
      END_STATE();
    case 95:
      if (lookahead == '6') ADVANCE(756);
      END_STATE();
    case 96:
      if (lookahead == '6') ADVANCE(758);
      END_STATE();
    case 97:
      if (lookahead == '6') ADVANCE(755);
      END_STATE();
    case 98:
      if (lookahead == '6') ADVANCE(761);
      END_STATE();
    case 99:
      if (lookahead == '6') ADVANCE(641);
      END_STATE();
    case 100:
      if (lookahead == '6') ADVANCE(637);
      END_STATE();
    case 101:
      if (lookahead == '6') ADVANCE(652);
      END_STATE();
    case 102:
      if (lookahead == '6') ADVANCE(640);
      END_STATE();
    case 103:
      if (lookahead == '8') ADVANCE(770);
      END_STATE();
    case 104:
      if (lookahead == '8') ADVANCE(771);
      END_STATE();
    case 105:
      if (lookahead == '8') ADVANCE(780);
      END_STATE();
    case 106:
      if (lookahead == '8') ADVANCE(772);
      END_STATE();
    case 107:
      if (lookahead == ':') ADVANCE(1224);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(598);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 108:
      if (lookahead == ':') ADVANCE(1224);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1242);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 109:
      if (lookahead == ':') ADVANCE(1224);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(1243);
      if (('G' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('g' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 110:
      if (lookahead == ':') ADVANCE(1224);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 111:
      if (lookahead == ':') ADVANCE(1223);
      if (lookahead == 'B' ||
          lookahead == 'C' ||
          lookahead == 'F' ||
          lookahead == 'J' ||
          lookahead == 'S' ||
          lookahead == 'V' ||
          lookahead == 'Z') ADVANCE(1222);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != 'I') ADVANCE(1221);
      END_STATE();
    case 112:
      if (lookahead == '>') ADVANCE(796);
      END_STATE();
    case 113:
      if (lookahead == 'a') ADVANCE(414);
      if (lookahead == 'c') ADVANCE(115);
      if (lookahead == 'e') ADVANCE(422);
      if (lookahead == 'l') ADVANCE(353);
      if (lookahead == 'p') ADVANCE(117);
      if (lookahead == 'r') ADVANCE(288);
      if (lookahead == 's') ADVANCE(445);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1251);
      END_STATE();
    case 114:
      if (lookahead == 'a') ADVANCE(414);
      if (lookahead == 'c') ADVANCE(115);
      if (lookahead == 'e') ADVANCE(438);
      if (lookahead == 'l') ADVANCE(353);
      if (lookahead == 'p') ADVANCE(117);
      if (lookahead == 'r') ADVANCE(288);
      if (lookahead == 's') ADVANCE(445);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1251);
      END_STATE();
    case 115:
      if (lookahead == 'a') ADVANCE(545);
      END_STATE();
    case 116:
      if (lookahead == 'a') ADVANCE(545);
      if (lookahead == 'l') ADVANCE(118);
      END_STATE();
    case 117:
      if (lookahead == 'a') ADVANCE(197);
      if (lookahead == 'r') ADVANCE(466);
      END_STATE();
    case 118:
      if (lookahead == 'a') ADVANCE(535);
      END_STATE();
    case 119:
      if (lookahead == 'a') ADVANCE(590);
      END_STATE();
    case 120:
      if (lookahead == 'a') ADVANCE(798);
      END_STATE();
    case 121:
      if (lookahead == 'a') ADVANCE(799);
      END_STATE();
    case 122:
      if (lookahead == 'a') ADVANCE(399);
      END_STATE();
    case 123:
      if (lookahead == 'a') ADVANCE(508);
      END_STATE();
    case 124:
      if (lookahead == 'a') ADVANCE(384);
      END_STATE();
    case 125:
      if (lookahead == 'a') ADVANCE(441);
      END_STATE();
    case 126:
      if (lookahead == 'a') ADVANCE(511);
      END_STATE();
    case 127:
      if (lookahead == 'a') ADVANCE(401);
      END_STATE();
    case 128:
      if (lookahead == 'a') ADVANCE(221);
      END_STATE();
    case 129:
      if (lookahead == 'a') ADVANCE(556);
      END_STATE();
    case 130:
      if (lookahead == 'a') ADVANCE(404);
      END_STATE();
    case 131:
      if (lookahead == 'a') ADVANCE(386);
      END_STATE();
    case 132:
      if (lookahead == 'a') ADVANCE(416);
      END_STATE();
    case 133:
      if (lookahead == 'a') ADVANCE(387);
      END_STATE();
    case 134:
      if (lookahead == 'a') ADVANCE(529);
      if (lookahead == 's') ADVANCE(469);
      END_STATE();
    case 135:
      if (lookahead == 'a') ADVANCE(207);
      END_STATE();
    case 136:
      if (lookahead == 'a') ADVANCE(562);
      END_STATE();
    case 137:
      if (lookahead == 'a') ADVANCE(224);
      END_STATE();
    case 138:
      if (lookahead == 'a') ADVANCE(569);
      END_STATE();
    case 139:
      if (lookahead == 'a') ADVANCE(426);
      END_STATE();
    case 140:
      if (lookahead == 'a') ADVANCE(208);
      END_STATE();
    case 141:
      if (lookahead == 'a') ADVANCE(563);
      END_STATE();
    case 142:
      if (lookahead == 'a') ADVANCE(226);
      END_STATE();
    case 143:
      if (lookahead == 'a') ADVANCE(572);
      END_STATE();
    case 144:
      if (lookahead == 'a') ADVANCE(427);
      END_STATE();
    case 145:
      if (lookahead == 'a') ADVANCE(228);
      END_STATE();
    case 146:
      if (lookahead == 'a') ADVANCE(575);
      END_STATE();
    case 147:
      if (lookahead == 'a') ADVANCE(428);
      END_STATE();
    case 148:
      if (lookahead == 'a') ADVANCE(230);
      END_STATE();
    case 149:
      if (lookahead == 'a') ADVANCE(429);
      END_STATE();
    case 150:
      if (lookahead == 'a') ADVANCE(232);
      END_STATE();
    case 151:
      if (lookahead == 'a') ADVANCE(430);
      END_STATE();
    case 152:
      if (lookahead == 'a') ADVANCE(234);
      END_STATE();
    case 153:
      if (lookahead == 'a') ADVANCE(431);
      END_STATE();
    case 154:
      if (lookahead == 'a') ADVANCE(236);
      END_STATE();
    case 155:
      if (lookahead == 'a') ADVANCE(432);
      END_STATE();
    case 156:
      if (lookahead == 'a') ADVANCE(238);
      END_STATE();
    case 157:
      if (lookahead == 'a') ADVANCE(433);
      END_STATE();
    case 158:
      if (lookahead == 'a') ADVANCE(240);
      END_STATE();
    case 159:
      if (lookahead == 'a') ADVANCE(434);
      END_STATE();
    case 160:
      if (lookahead == 'a') ADVANCE(242);
      END_STATE();
    case 161:
      if (lookahead == 'a') ADVANCE(435);
      END_STATE();
    case 162:
      if (lookahead == 'a') ADVANCE(244);
      END_STATE();
    case 163:
      if (lookahead == 'a') ADVANCE(436);
      END_STATE();
    case 164:
      if (lookahead == 'a') ADVANCE(246);
      END_STATE();
    case 165:
      if (lookahead == 'a') ADVANCE(514);
      END_STATE();
    case 166:
      if (lookahead == 'a') ADVANCE(248);
      END_STATE();
    case 167:
      if (lookahead == 'a') ADVANCE(512);
      END_STATE();
    case 168:
      if (lookahead == 'a') ADVANCE(250);
      END_STATE();
    case 169:
      if (lookahead == 'a') ADVANCE(252);
      END_STATE();
    case 170:
      if (lookahead == 'a') ADVANCE(254);
      END_STATE();
    case 171:
      if (lookahead == 'a') ADVANCE(256);
      END_STATE();
    case 172:
      if (lookahead == 'a') ADVANCE(258);
      END_STATE();
    case 173:
      if (lookahead == 'a') ADVANCE(260);
      END_STATE();
    case 174:
      if (lookahead == 'a') ADVANCE(262);
      END_STATE();
    case 175:
      if (lookahead == 'a') ADVANCE(264);
      END_STATE();
    case 176:
      if (lookahead == 'a') ADVANCE(266);
      END_STATE();
    case 177:
      if (lookahead == 'a') ADVANCE(268);
      END_STATE();
    case 178:
      if (lookahead == 'a') ADVANCE(270);
      END_STATE();
    case 179:
      if (lookahead == 'a') ADVANCE(272);
      END_STATE();
    case 180:
      if (lookahead == 'a') ADVANCE(274);
      END_STATE();
    case 181:
      if (lookahead == 'a') ADVANCE(276);
      END_STATE();
    case 182:
      if (lookahead == 'a') ADVANCE(278);
      END_STATE();
    case 183:
      if (lookahead == 'a') ADVANCE(280);
      END_STATE();
    case 184:
      if (lookahead == 'a') ADVANCE(282);
      END_STATE();
    case 185:
      if (lookahead == 'a') ADVANCE(284);
      END_STATE();
    case 186:
      if (lookahead == 'a') ADVANCE(413);
      if (lookahead == 'e') ADVANCE(425);
      if (lookahead == 's') ADVANCE(585);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1251);
      END_STATE();
    case 187:
      if (lookahead == 'a') ADVANCE(413);
      if (lookahead == 'e') ADVANCE(424);
      if (lookahead == 'f') ADVANCE(354);
      if (lookahead == 'i') ADVANCE(397);
      if (lookahead == 'm') ADVANCE(305);
      if (lookahead == 's') ADVANCE(447);
      END_STATE();
    case 188:
      if (lookahead == 'a') ADVANCE(443);
      if (lookahead == 'f') ADVANCE(360);
      if (lookahead == 'l') ADVANCE(459);
      if (lookahead == 'm') ADVANCE(316);
      if (lookahead == 'p') ADVANCE(135);
      if (lookahead == 's') ADVANCE(470);
      END_STATE();
    case 189:
      if (lookahead == 'a') ADVANCE(592);
      END_STATE();
    case 190:
      if (lookahead == 'a') ADVANCE(444);
      END_STATE();
    case 191:
      if (lookahead == 'a') ADVANCE(442);
      if (lookahead == 'f') ADVANCE(360);
      if (lookahead == 's') ADVANCE(579);
      END_STATE();
    case 192:
      if (lookahead == 'a') ADVANCE(530);
      END_STATE();
    case 193:
      if (lookahead == 'b') ADVANCE(125);
      END_STATE();
    case 194:
      if (lookahead == 'b') ADVANCE(125);
      if (lookahead == 'p') ADVANCE(309);
      END_STATE();
    case 195:
      if (lookahead == 'b') ADVANCE(449);
      END_STATE();
    case 196:
      if (lookahead == 'b') ADVANCE(190);
      END_STATE();
    case 197:
      if (lookahead == 'c') ADVANCE(381);
      if (lookahead == 'r') ADVANCE(122);
      END_STATE();
    case 198:
      if (lookahead == 'c') ADVANCE(342);
      END_STATE();
    case 199:
      if (lookahead == 'c') ADVANCE(124);
      END_STATE();
    case 200:
      if (lookahead == 'c') ADVANCE(343);
      END_STATE();
    case 201:
      if (lookahead == 'c') ADVANCE(344);
      END_STATE();
    case 202:
      if (lookahead == 'c') ADVANCE(345);
      END_STATE();
    case 203:
      if (lookahead == 'c') ADVANCE(346);
      END_STATE();
    case 204:
      if (lookahead == 'c') ADVANCE(290);
      END_STATE();
    case 205:
      if (lookahead == 'c') ADVANCE(131);
      END_STATE();
    case 206:
      if (lookahead == 'c') ADVANCE(133);
      END_STATE();
    case 207:
      if (lookahead == 'c') ADVANCE(382);
      if (lookahead == 'r') ADVANCE(127);
      END_STATE();
    case 208:
      if (lookahead == 'c') ADVANCE(382);
      if (lookahead == 'r') ADVANCE(130);
      END_STATE();
    case 209:
      if (lookahead == 'd') ADVANCE(3);
      if (lookahead == 'u') ADVANCE(398);
      END_STATE();
    case 210:
      if (lookahead == 'd') ADVANCE(613);
      END_STATE();
    case 211:
      if (lookahead == 'd') ADVANCE(616);
      END_STATE();
    case 212:
      if (lookahead == 'd') ADVANCE(615);
      END_STATE();
    case 213:
      if (lookahead == 'd') ADVANCE(617);
      END_STATE();
    case 214:
      if (lookahead == 'd') ADVANCE(22);
      END_STATE();
    case 215:
      if (lookahead == 'd') ADVANCE(4);
      if (lookahead == 'u') ADVANCE(398);
      END_STATE();
    case 216:
      if (lookahead == 'd') ADVANCE(5);
      END_STATE();
    case 217:
      if (lookahead == 'd') ADVANCE(6);
      END_STATE();
    case 218:
      if (lookahead == 'd') ADVANCE(7);
      END_STATE();
    case 219:
      if (lookahead == 'd') ADVANCE(8);
      END_STATE();
    case 220:
      if (lookahead == 'd') ADVANCE(473);
      END_STATE();
    case 221:
      if (lookahead == 'd') ADVANCE(220);
      END_STATE();
    case 222:
      if (lookahead == 'd') ADVANCE(474);
      END_STATE();
    case 223:
      if (lookahead == 'd') ADVANCE(136);
      END_STATE();
    case 224:
      if (lookahead == 'd') ADVANCE(222);
      END_STATE();
    case 225:
      if (lookahead == 'd') ADVANCE(475);
      END_STATE();
    case 226:
      if (lookahead == 'd') ADVANCE(225);
      END_STATE();
    case 227:
      if (lookahead == 'd') ADVANCE(476);
      END_STATE();
    case 228:
      if (lookahead == 'd') ADVANCE(227);
      END_STATE();
    case 229:
      if (lookahead == 'd') ADVANCE(477);
      END_STATE();
    case 230:
      if (lookahead == 'd') ADVANCE(229);
      END_STATE();
    case 231:
      if (lookahead == 'd') ADVANCE(478);
      END_STATE();
    case 232:
      if (lookahead == 'd') ADVANCE(231);
      END_STATE();
    case 233:
      if (lookahead == 'd') ADVANCE(479);
      END_STATE();
    case 234:
      if (lookahead == 'd') ADVANCE(233);
      END_STATE();
    case 235:
      if (lookahead == 'd') ADVANCE(480);
      END_STATE();
    case 236:
      if (lookahead == 'd') ADVANCE(235);
      END_STATE();
    case 237:
      if (lookahead == 'd') ADVANCE(481);
      END_STATE();
    case 238:
      if (lookahead == 'd') ADVANCE(237);
      END_STATE();
    case 239:
      if (lookahead == 'd') ADVANCE(482);
      END_STATE();
    case 240:
      if (lookahead == 'd') ADVANCE(239);
      END_STATE();
    case 241:
      if (lookahead == 'd') ADVANCE(483);
      END_STATE();
    case 242:
      if (lookahead == 'd') ADVANCE(241);
      END_STATE();
    case 243:
      if (lookahead == 'd') ADVANCE(484);
      END_STATE();
    case 244:
      if (lookahead == 'd') ADVANCE(243);
      END_STATE();
    case 245:
      if (lookahead == 'd') ADVANCE(485);
      END_STATE();
    case 246:
      if (lookahead == 'd') ADVANCE(245);
      END_STATE();
    case 247:
      if (lookahead == 'd') ADVANCE(486);
      END_STATE();
    case 248:
      if (lookahead == 'd') ADVANCE(247);
      END_STATE();
    case 249:
      if (lookahead == 'd') ADVANCE(487);
      END_STATE();
    case 250:
      if (lookahead == 'd') ADVANCE(249);
      END_STATE();
    case 251:
      if (lookahead == 'd') ADVANCE(488);
      END_STATE();
    case 252:
      if (lookahead == 'd') ADVANCE(251);
      END_STATE();
    case 253:
      if (lookahead == 'd') ADVANCE(489);
      END_STATE();
    case 254:
      if (lookahead == 'd') ADVANCE(253);
      END_STATE();
    case 255:
      if (lookahead == 'd') ADVANCE(490);
      END_STATE();
    case 256:
      if (lookahead == 'd') ADVANCE(255);
      END_STATE();
    case 257:
      if (lookahead == 'd') ADVANCE(491);
      END_STATE();
    case 258:
      if (lookahead == 'd') ADVANCE(257);
      END_STATE();
    case 259:
      if (lookahead == 'd') ADVANCE(492);
      END_STATE();
    case 260:
      if (lookahead == 'd') ADVANCE(259);
      END_STATE();
    case 261:
      if (lookahead == 'd') ADVANCE(493);
      END_STATE();
    case 262:
      if (lookahead == 'd') ADVANCE(261);
      END_STATE();
    case 263:
      if (lookahead == 'd') ADVANCE(494);
      END_STATE();
    case 264:
      if (lookahead == 'd') ADVANCE(263);
      END_STATE();
    case 265:
      if (lookahead == 'd') ADVANCE(495);
      END_STATE();
    case 266:
      if (lookahead == 'd') ADVANCE(265);
      END_STATE();
    case 267:
      if (lookahead == 'd') ADVANCE(496);
      END_STATE();
    case 268:
      if (lookahead == 'd') ADVANCE(267);
      END_STATE();
    case 269:
      if (lookahead == 'd') ADVANCE(497);
      END_STATE();
    case 270:
      if (lookahead == 'd') ADVANCE(269);
      END_STATE();
    case 271:
      if (lookahead == 'd') ADVANCE(498);
      END_STATE();
    case 272:
      if (lookahead == 'd') ADVANCE(271);
      END_STATE();
    case 273:
      if (lookahead == 'd') ADVANCE(499);
      END_STATE();
    case 274:
      if (lookahead == 'd') ADVANCE(273);
      END_STATE();
    case 275:
      if (lookahead == 'd') ADVANCE(500);
      END_STATE();
    case 276:
      if (lookahead == 'd') ADVANCE(275);
      END_STATE();
    case 277:
      if (lookahead == 'd') ADVANCE(501);
      END_STATE();
    case 278:
      if (lookahead == 'd') ADVANCE(277);
      END_STATE();
    case 279:
      if (lookahead == 'd') ADVANCE(502);
      END_STATE();
    case 280:
      if (lookahead == 'd') ADVANCE(279);
      END_STATE();
    case 281:
      if (lookahead == 'd') ADVANCE(503);
      END_STATE();
    case 282:
      if (lookahead == 'd') ADVANCE(281);
      END_STATE();
    case 283:
      if (lookahead == 'd') ADVANCE(504);
      END_STATE();
    case 284:
      if (lookahead == 'd') ADVANCE(283);
      END_STATE();
    case 285:
      if (lookahead == 'd') ADVANCE(141);
      END_STATE();
    case 286:
      if (lookahead == 'd') ADVANCE(10);
      END_STATE();
    case 287:
      if (lookahead == 'd') ADVANCE(25);
      END_STATE();
    case 288:
      if (lookahead == 'e') ADVANCE(327);
      END_STATE();
    case 289:
      if (lookahead == 'e') ADVANCE(781);
      END_STATE();
    case 290:
      if (lookahead == 'e') ADVANCE(611);
      END_STATE();
    case 291:
      if (lookahead == 'e') ADVANCE(801);
      END_STATE();
    case 292:
      if (lookahead == 'e') ADVANCE(800);
      END_STATE();
    case 293:
      if (lookahead == 'e') ADVANCE(688);
      END_STATE();
    case 294:
      if (lookahead == 'e') ADVANCE(682);
      END_STATE();
    case 295:
      if (lookahead == 'e') ADVANCE(683);
      END_STATE();
    case 296:
      if (lookahead == 'e') ADVANCE(687);
      END_STATE();
    case 297:
      if (lookahead == 'e') ADVANCE(774);
      END_STATE();
    case 298:
      if (lookahead == 'e') ADVANCE(689);
      END_STATE();
    case 299:
      if (lookahead == 'e') ADVANCE(656);
      END_STATE();
    case 300:
      if (lookahead == 'e') ADVANCE(684);
      END_STATE();
    case 301:
      if (lookahead == 'e') ADVANCE(685);
      END_STATE();
    case 302:
      if (lookahead == 'e') ADVANCE(686);
      END_STATE();
    case 303:
      if (lookahead == 'e') ADVANCE(778);
      END_STATE();
    case 304:
      if (lookahead == 'e') ADVANCE(776);
      END_STATE();
    case 305:
      if (lookahead == 'e') ADVANCE(542);
      END_STATE();
    case 306:
      if (lookahead == 'e') ADVANCE(383);
      END_STATE();
    case 307:
      if (lookahead == 'e') ADVANCE(214);
      END_STATE();
    case 308:
      if (lookahead == 'e') ADVANCE(403);
      END_STATE();
    case 309:
      if (lookahead == 'e') ADVANCE(471);
      END_STATE();
    case 310:
      if (lookahead == 'e') ADVANCE(420);
      END_STATE();
    case 311:
      if (lookahead == 'e') ADVANCE(472);
      END_STATE();
    case 312:
      if (lookahead == 'e') ADVANCE(391);
      END_STATE();
    case 313:
      if (lookahead == 'e') ADVANCE(419);
      if (lookahead == 's') ADVANCE(585);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1251);
      END_STATE();
    case 314:
      if (lookahead == 'e') ADVANCE(423);
      END_STATE();
    case 315:
      if (lookahead == 'e') ADVANCE(505);
      END_STATE();
    case 316:
      if (lookahead == 'e') ADVANCE(566);
      END_STATE();
    case 317:
      if (lookahead == 'e') ADVANCE(510);
      END_STATE();
    case 318:
      if (lookahead == 'e') ADVANCE(565);
      END_STATE();
    case 319:
      if (lookahead == 'e') ADVANCE(24);
      END_STATE();
    case 320:
      if (lookahead == 'e') ADVANCE(287);
      END_STATE();
    case 321:
      if (lookahead == 'e') ADVANCE(26);
      END_STATE();
    case 322:
      if (lookahead == 'f') ADVANCE(356);
      END_STATE();
    case 323:
      if (lookahead == 'f') ADVANCE(360);
      if (lookahead == 'l') ADVANCE(459);
      if (lookahead == 'm') ADVANCE(316);
      if (lookahead == 'p') ADVANCE(140);
      END_STATE();
    case 324:
      if (lookahead == 'f') ADVANCE(360);
      if (lookahead == 'p') ADVANCE(165);
      END_STATE();
    case 325:
      if (lookahead == 'g') ADVANCE(583);
      END_STATE();
    case 326:
      if (lookahead == 'g') ADVANCE(349);
      END_STATE();
    case 327:
      if (lookahead == 'g') ADVANCE(355);
      if (lookahead == 's') ADVANCE(567);
      END_STATE();
    case 328:
      if (lookahead == 'g') ADVANCE(293);
      END_STATE();
    case 329:
      if (lookahead == 'g') ADVANCE(294);
      END_STATE();
    case 330:
      if (lookahead == 'g') ADVANCE(295);
      END_STATE();
    case 331:
      if (lookahead == 'g') ADVANCE(296);
      END_STATE();
    case 332:
      if (lookahead == 'g') ADVANCE(297);
      END_STATE();
    case 333:
      if (lookahead == 'g') ADVANCE(298);
      END_STATE();
    case 334:
      if (lookahead == 'g') ADVANCE(299);
      END_STATE();
    case 335:
      if (lookahead == 'g') ADVANCE(300);
      END_STATE();
    case 336:
      if (lookahead == 'g') ADVANCE(301);
      END_STATE();
    case 337:
      if (lookahead == 'g') ADVANCE(302);
      END_STATE();
    case 338:
      if (lookahead == 'g') ADVANCE(303);
      END_STATE();
    case 339:
      if (lookahead == 'g') ADVANCE(304);
      END_STATE();
    case 340:
      if (lookahead == 'g') ADVANCE(584);
      END_STATE();
    case 341:
      if (lookahead == 'g') ADVANCE(350);
      END_STATE();
    case 342:
      if (lookahead == 'h') ADVANCE(788);
      END_STATE();
    case 343:
      if (lookahead == 'h') ADVANCE(793);
      END_STATE();
    case 344:
      if (lookahead == 'h') ADVANCE(795);
      END_STATE();
    case 345:
      if (lookahead == 'h') ADVANCE(794);
      END_STATE();
    case 346:
      if (lookahead == 'h') ADVANCE(797);
      END_STATE();
    case 347:
      if (lookahead == 'h') ADVANCE(450);
      END_STATE();
    case 348:
      if (lookahead == 'h') ADVANCE(454);
      END_STATE();
    case 349:
      if (lookahead == 'h') ADVANCE(35);
      END_STATE();
    case 350:
      if (lookahead == 'h') ADVANCE(48);
      END_STATE();
    case 351:
      if (lookahead == 'i') ADVANCE(388);
      END_STATE();
    case 352:
      if (lookahead == 'i') ADVANCE(326);
      END_STATE();
    case 353:
      if (lookahead == 'i') ADVANCE(417);
      if (lookahead == 'o') ADVANCE(199);
      END_STATE();
    case 354:
      if (lookahead == 'i') ADVANCE(306);
      END_STATE();
    case 355:
      if (lookahead == 'i') ADVANCE(536);
      END_STATE();
    case 356:
      if (lookahead == 'i') ADVANCE(418);
      END_STATE();
    case 357:
      if (lookahead == 'i') ADVANCE(547);
      END_STATE();
    case 358:
      if (lookahead == 'i') ADVANCE(453);
      END_STATE();
    case 359:
      if (lookahead == 'i') ADVANCE(455);
      END_STATE();
    case 360:
      if (lookahead == 'i') ADVANCE(312);
      END_STATE();
    case 361:
      if (lookahead == 'i') ADVANCE(543);
      END_STATE();
    case 362:
      if (lookahead == 'i') ADVANCE(456);
      END_STATE();
    case 363:
      if (lookahead == 'i') ADVANCE(548);
      END_STATE();
    case 364:
      if (lookahead == 'i') ADVANCE(457);
      END_STATE();
    case 365:
      if (lookahead == 'i') ADVANCE(550);
      END_STATE();
    case 366:
      if (lookahead == 'i') ADVANCE(552);
      END_STATE();
    case 367:
      if (lookahead == 'i') ADVANCE(554);
      END_STATE();
    case 368:
      if (lookahead == 'i') ADVANCE(555);
      END_STATE();
    case 369:
      if (lookahead == 'i') ADVANCE(544);
      END_STATE();
    case 370:
      if (lookahead == 'i') ADVANCE(549);
      END_STATE();
    case 371:
      if (lookahead == 'i') ADVANCE(559);
      END_STATE();
    case 372:
      if (lookahead == 'i') ADVANCE(560);
      END_STATE();
    case 373:
      if (lookahead == 'i') ADVANCE(551);
      END_STATE();
    case 374:
      if (lookahead == 'i') ADVANCE(553);
      END_STATE();
    case 375:
      if (lookahead == 'i') ADVANCE(568);
      END_STATE();
    case 376:
      if (lookahead == 'i') ADVANCE(571);
      END_STATE();
    case 377:
      if (lookahead == 'i') ADVANCE(574);
      END_STATE();
    case 378:
      if (lookahead == 'i') ADVANCE(577);
      END_STATE();
    case 379:
      if (lookahead == 'i') ADVANCE(341);
      END_STATE();
    case 380:
      if (lookahead == 'j') ADVANCE(582);
      END_STATE();
    case 381:
      if (lookahead == 'k') ADVANCE(307);
      END_STATE();
    case 382:
      if (lookahead == 'k') ADVANCE(320);
      END_STATE();
    case 383:
      if (lookahead == 'l') ADVANCE(210);
      END_STATE();
    case 384:
      if (lookahead == 'l') ADVANCE(783);
      END_STATE();
    case 385:
      if (lookahead == 'l') ADVANCE(792);
      END_STATE();
    case 386:
      if (lookahead == 'l') ADVANCE(785);
      END_STATE();
    case 387:
      if (lookahead == 'l') ADVANCE(786);
      END_STATE();
    case 388:
      if (lookahead == 'l') ADVANCE(448);
      END_STATE();
    case 389:
      if (lookahead == 'l') ADVANCE(459);
      if (lookahead == 'm') ADVANCE(316);
      if (lookahead == 'p') ADVANCE(165);
      END_STATE();
    case 390:
      if (lookahead == 'l') ADVANCE(459);
      if (lookahead == 'm') ADVANCE(316);
      if (lookahead == 'p') ADVANCE(167);
      END_STATE();
    case 391:
      if (lookahead == 'l') ADVANCE(212);
      END_STATE();
    case 392:
      if (lookahead == 'l') ADVANCE(308);
      END_STATE();
    case 393:
      if (lookahead == 'l') ADVANCE(385);
      END_STATE();
    case 394:
      if (lookahead == 'l') ADVANCE(373);
      END_STATE();
    case 395:
      if (lookahead == 'l') ADVANCE(460);
      END_STATE();
    case 396:
      if (lookahead == 'l') ADVANCE(463);
      END_STATE();
    case 397:
      if (lookahead == 'm') ADVANCE(467);
      END_STATE();
    case 398:
      if (lookahead == 'm') ADVANCE(1235);
      END_STATE();
    case 399:
      if (lookahead == 'm') ADVANCE(623);
      END_STATE();
    case 400:
      if (lookahead == 'm') ADVANCE(34);
      END_STATE();
    case 401:
      if (lookahead == 'm') ADVANCE(624);
      END_STATE();
    case 402:
      if (lookahead == 'm') ADVANCE(195);
      END_STATE();
    case 403:
      if (lookahead == 'm') ADVANCE(310);
      END_STATE();
    case 404:
      if (lookahead == 'm') ADVANCE(318);
      END_STATE();
    case 405:
      if (lookahead == 'm') ADVANCE(47);
      END_STATE();
    case 406:
      if (lookahead == 'm') ADVANCE(49);
      END_STATE();
    case 407:
      if (lookahead == 'n') ADVANCE(322);
      END_STATE();
    case 408:
      if (lookahead == 'n') ADVANCE(209);
      if (lookahead == 'p') ADVANCE(351);
      END_STATE();
    case 409:
      if (lookahead == 'n') ADVANCE(618);
      END_STATE();
    case 410:
      if (lookahead == 'n') ADVANCE(621);
      END_STATE();
    case 411:
      if (lookahead == 'n') ADVANCE(619);
      END_STATE();
    case 412:
      if (lookahead == 'n') ADVANCE(622);
      END_STATE();
    case 413:
      if (lookahead == 'n') ADVANCE(415);
      END_STATE();
    case 414:
      if (lookahead == 'n') ADVANCE(415);
      if (lookahead == 'r') ADVANCE(506);
      END_STATE();
    case 415:
      if (lookahead == 'n') ADVANCE(451);
      END_STATE();
    case 416:
      if (lookahead == 'n') ADVANCE(328);
      END_STATE();
    case 417:
      if (lookahead == 'n') ADVANCE(289);
      END_STATE();
    case 418:
      if (lookahead == 'n') ADVANCE(357);
      END_STATE();
    case 419:
      if (lookahead == 'n') ADVANCE(580);
      END_STATE();
    case 420:
      if (lookahead == 'n') ADVANCE(558);
      END_STATE();
    case 421:
      if (lookahead == 'n') ADVANCE(216);
      if (lookahead == 'p') ADVANCE(351);
      END_STATE();
    case 422:
      if (lookahead == 'n') ADVANCE(217);
      if (lookahead == 'p') ADVANCE(351);
      END_STATE();
    case 423:
      if (lookahead == 'n') ADVANCE(218);
      END_STATE();
    case 424:
      if (lookahead == 'n') ADVANCE(219);
      END_STATE();
    case 425:
      if (lookahead == 'n') ADVANCE(215);
      END_STATE();
    case 426:
      if (lookahead == 'n') ADVANCE(329);
      END_STATE();
    case 427:
      if (lookahead == 'n') ADVANCE(330);
      END_STATE();
    case 428:
      if (lookahead == 'n') ADVANCE(331);
      END_STATE();
    case 429:
      if (lookahead == 'n') ADVANCE(332);
      END_STATE();
    case 430:
      if (lookahead == 'n') ADVANCE(333);
      END_STATE();
    case 431:
      if (lookahead == 'n') ADVANCE(334);
      END_STATE();
    case 432:
      if (lookahead == 'n') ADVANCE(335);
      END_STATE();
    case 433:
      if (lookahead == 'n') ADVANCE(336);
      END_STATE();
    case 434:
      if (lookahead == 'n') ADVANCE(337);
      END_STATE();
    case 435:
      if (lookahead == 'n') ADVANCE(338);
      END_STATE();
    case 436:
      if (lookahead == 'n') ADVANCE(339);
      END_STATE();
    case 437:
      if (lookahead == 'n') ADVANCE(461);
      END_STATE();
    case 438:
      if (lookahead == 'n') ADVANCE(286);
      if (lookahead == 'p') ADVANCE(351);
      END_STATE();
    case 439:
      if (lookahead == 'n') ADVANCE(464);
      END_STATE();
    case 440:
      if (lookahead == 'n') ADVANCE(465);
      END_STATE();
    case 441:
      if (lookahead == 'n') ADVANCE(437);
      END_STATE();
    case 442:
      if (lookahead == 'n') ADVANCE(439);
      END_STATE();
    case 443:
      if (lookahead == 'n') ADVANCE(439);
      if (lookahead == 'r') ADVANCE(528);
      END_STATE();
    case 444:
      if (lookahead == 'n') ADVANCE(440);
      END_STATE();
    case 445:
      if (lookahead == 'o') ADVANCE(581);
      if (lookahead == 'p') ADVANCE(123);
      END_STATE();
    case 446:
      if (lookahead == 'o') ADVANCE(581);
      if (lookahead == 'p') ADVANCE(123);
      if (lookahead == 'u') ADVANCE(194);
      END_STATE();
    case 447:
      if (lookahead == 'o') ADVANCE(581);
      if (lookahead == 'u') ADVANCE(468);
      END_STATE();
    case 448:
      if (lookahead == 'o') ADVANCE(325);
      END_STATE();
    case 449:
      if (lookahead == 'o') ADVANCE(654);
      END_STATE();
    case 450:
      if (lookahead == 'o') ADVANCE(211);
      END_STATE();
    case 451:
      if (lookahead == 'o') ADVANCE(557);
      END_STATE();
    case 452:
      if (lookahead == 'o') ADVANCE(400);
      END_STATE();
    case 453:
      if (lookahead == 'o') ADVANCE(409);
      END_STATE();
    case 454:
      if (lookahead == 'o') ADVANCE(213);
      END_STATE();
    case 455:
      if (lookahead == 'o') ADVANCE(410);
      END_STATE();
    case 456:
      if (lookahead == 'o') ADVANCE(411);
      END_STATE();
    case 457:
      if (lookahead == 'o') ADVANCE(412);
      END_STATE();
    case 458:
      if (lookahead == 'o') ADVANCE(405);
      END_STATE();
    case 459:
      if (lookahead == 'o') ADVANCE(205);
      END_STATE();
    case 460:
      if (lookahead == 'o') ADVANCE(340);
      END_STATE();
    case 461:
      if (lookahead == 'o') ADVANCE(570);
      END_STATE();
    case 462:
      if (lookahead == 'o') ADVANCE(406);
      END_STATE();
    case 463:
      if (lookahead == 'o') ADVANCE(206);
      END_STATE();
    case 464:
      if (lookahead == 'o') ADVANCE(573);
      END_STATE();
    case 465:
      if (lookahead == 'o') ADVANCE(576);
      END_STATE();
    case 466:
      if (lookahead == 'o') ADVANCE(395);
      END_STATE();
    case 467:
      if (lookahead == 'p') ADVANCE(392);
      END_STATE();
    case 468:
      if (lookahead == 'p') ADVANCE(309);
      END_STATE();
    case 469:
      if (lookahead == 'p') ADVANCE(192);
      END_STATE();
    case 470:
      if (lookahead == 'p') ADVANCE(192);
      if (lookahead == 'u') ADVANCE(196);
      END_STATE();
    case 471:
      if (lookahead == 'r') ADVANCE(610);
      END_STATE();
    case 472:
      if (lookahead == 'r') ADVANCE(626);
      END_STATE();
    case 473:
      if (lookahead == 'r') ADVANCE(728);
      END_STATE();
    case 474:
      if (lookahead == 'r') ADVANCE(722);
      END_STATE();
    case 475:
      if (lookahead == 'r') ADVANCE(727);
      END_STATE();
    case 476:
      if (lookahead == 'r') ADVANCE(725);
      END_STATE();
    case 477:
      if (lookahead == 'r') ADVANCE(724);
      END_STATE();
    case 478:
      if (lookahead == 'r') ADVANCE(739);
      END_STATE();
    case 479:
      if (lookahead == 'r') ADVANCE(726);
      END_STATE();
    case 480:
      if (lookahead == 'r') ADVANCE(730);
      END_STATE();
    case 481:
      if (lookahead == 'r') ADVANCE(731);
      END_STATE();
    case 482:
      if (lookahead == 'r') ADVANCE(723);
      END_STATE();
    case 483:
      if (lookahead == 'r') ADVANCE(729);
      END_STATE();
    case 484:
      if (lookahead == 'r') ADVANCE(733);
      END_STATE();
    case 485:
      if (lookahead == 'r') ADVANCE(738);
      END_STATE();
    case 486:
      if (lookahead == 'r') ADVANCE(736);
      END_STATE();
    case 487:
      if (lookahead == 'r') ADVANCE(735);
      END_STATE();
    case 488:
      if (lookahead == 'r') ADVANCE(737);
      END_STATE();
    case 489:
      if (lookahead == 'r') ADVANCE(741);
      END_STATE();
    case 490:
      if (lookahead == 'r') ADVANCE(742);
      END_STATE();
    case 491:
      if (lookahead == 'r') ADVANCE(734);
      END_STATE();
    case 492:
      if (lookahead == 'r') ADVANCE(732);
      END_STATE();
    case 493:
      if (lookahead == 'r') ADVANCE(740);
      END_STATE();
    case 494:
      if (lookahead == 'r') ADVANCE(744);
      END_STATE();
    case 495:
      if (lookahead == 'r') ADVANCE(747);
      END_STATE();
    case 496:
      if (lookahead == 'r') ADVANCE(746);
      END_STATE();
    case 497:
      if (lookahead == 'r') ADVANCE(748);
      END_STATE();
    case 498:
      if (lookahead == 'r') ADVANCE(745);
      END_STATE();
    case 499:
      if (lookahead == 'r') ADVANCE(743);
      END_STATE();
    case 500:
      if (lookahead == 'r') ADVANCE(749);
      END_STATE();
    case 501:
      if (lookahead == 'r') ADVANCE(752);
      END_STATE();
    case 502:
      if (lookahead == 'r') ADVANCE(751);
      END_STATE();
    case 503:
      if (lookahead == 'r') ADVANCE(753);
      END_STATE();
    case 504:
      if (lookahead == 'r') ADVANCE(750);
      END_STATE();
    case 505:
      if (lookahead == 'r') ADVANCE(627);
      END_STATE();
    case 506:
      if (lookahead == 'r') ADVANCE(119);
      END_STATE();
    case 507:
      if (lookahead == 'r') ADVANCE(204);
      END_STATE();
    case 508:
      if (lookahead == 'r') ADVANCE(537);
      END_STATE();
    case 509:
      if (lookahead == 'r') ADVANCE(452);
      END_STATE();
    case 510:
      if (lookahead == 'r') ADVANCE(533);
      END_STATE();
    case 511:
      if (lookahead == 'r') ADVANCE(546);
      END_STATE();
    case 512:
      if (lookahead == 'r') ADVANCE(127);
      END_STATE();
    case 513:
      if (lookahead == 'r') ADVANCE(132);
      END_STATE();
    case 514:
      if (lookahead == 'r') ADVANCE(130);
      END_STATE();
    case 515:
      if (lookahead == 'r') ADVANCE(458);
      END_STATE();
    case 516:
      if (lookahead == 'r') ADVANCE(139);
      END_STATE();
    case 517:
      if (lookahead == 'r') ADVANCE(144);
      END_STATE();
    case 518:
      if (lookahead == 'r') ADVANCE(147);
      END_STATE();
    case 519:
      if (lookahead == 'r') ADVANCE(149);
      END_STATE();
    case 520:
      if (lookahead == 'r') ADVANCE(151);
      END_STATE();
    case 521:
      if (lookahead == 'r') ADVANCE(153);
      END_STATE();
    case 522:
      if (lookahead == 'r') ADVANCE(155);
      END_STATE();
    case 523:
      if (lookahead == 'r') ADVANCE(157);
      END_STATE();
    case 524:
      if (lookahead == 'r') ADVANCE(159);
      END_STATE();
    case 525:
      if (lookahead == 'r') ADVANCE(161);
      END_STATE();
    case 526:
      if (lookahead == 'r') ADVANCE(163);
      END_STATE();
    case 527:
      if (lookahead == 'r') ADVANCE(462);
      END_STATE();
    case 528:
      if (lookahead == 'r') ADVANCE(189);
      END_STATE();
    case 529:
      if (lookahead == 'r') ADVANCE(528);
      END_STATE();
    case 530:
      if (lookahead == 'r') ADVANCE(541);
      END_STATE();
    case 531:
      if (lookahead == 's') ADVANCE(609);
      END_STATE();
    case 532:
      if (lookahead == 's') ADVANCE(586);
      END_STATE();
    case 533:
      if (lookahead == 's') ADVANCE(787);
      END_STATE();
    case 534:
      if (lookahead == 's') ADVANCE(612);
      END_STATE();
    case 535:
      if (lookahead == 's') ADVANCE(531);
      END_STATE();
    case 536:
      if (lookahead == 's') ADVANCE(561);
      END_STATE();
    case 537:
      if (lookahead == 's') ADVANCE(319);
      END_STATE();
    case 538:
      if (lookahead == 's') ADVANCE(587);
      END_STATE();
    case 539:
      if (lookahead == 's') ADVANCE(588);
      END_STATE();
    case 540:
      if (lookahead == 's') ADVANCE(589);
      END_STATE();
    case 541:
      if (lookahead == 's') ADVANCE(321);
      END_STATE();
    case 542:
      if (lookahead == 't') ADVANCE(347);
      END_STATE();
    case 543:
      if (lookahead == 't') ADVANCE(37);
      END_STATE();
    case 544:
      if (lookahead == 't') ADVANCE(103);
      END_STATE();
    case 545:
      if (lookahead == 't') ADVANCE(198);
      END_STATE();
    case 546:
      if (lookahead == 't') ADVANCE(9);
      END_STATE();
    case 547:
      if (lookahead == 't') ADVANCE(591);
      END_STATE();
    case 548:
      if (lookahead == 't') ADVANCE(38);
      END_STATE();
    case 549:
      if (lookahead == 't') ADVANCE(104);
      END_STATE();
    case 550:
      if (lookahead == 't') ADVANCE(39);
      END_STATE();
    case 551:
      if (lookahead == 't') ADVANCE(105);
      END_STATE();
    case 552:
      if (lookahead == 't') ADVANCE(41);
      END_STATE();
    case 553:
      if (lookahead == 't') ADVANCE(106);
      END_STATE();
    case 554:
      if (lookahead == 't') ADVANCE(42);
      END_STATE();
    case 555:
      if (lookahead == 't') ADVANCE(43);
      END_STATE();
    case 556:
      if (lookahead == 't') ADVANCE(358);
      END_STATE();
    case 557:
      if (lookahead == 't') ADVANCE(129);
      END_STATE();
    case 558:
      if (lookahead == 't') ADVANCE(534);
      END_STATE();
    case 559:
      if (lookahead == 't') ADVANCE(44);
      END_STATE();
    case 560:
      if (lookahead == 't') ADVANCE(45);
      END_STATE();
    case 561:
      if (lookahead == 't') ADVANCE(317);
      END_STATE();
    case 562:
      if (lookahead == 't') ADVANCE(120);
      END_STATE();
    case 563:
      if (lookahead == 't') ADVANCE(121);
      END_STATE();
    case 564:
      if (lookahead == 't') ADVANCE(311);
      END_STATE();
    case 565:
      if (lookahead == 't') ADVANCE(315);
      END_STATE();
    case 566:
      if (lookahead == 't') ADVANCE(348);
      END_STATE();
    case 567:
      if (lookahead == 't') ADVANCE(126);
      END_STATE();
    case 568:
      if (lookahead == 't') ADVANCE(200);
      END_STATE();
    case 569:
      if (lookahead == 't') ADVANCE(359);
      END_STATE();
    case 570:
      if (lookahead == 't') ADVANCE(138);
      END_STATE();
    case 571:
      if (lookahead == 't') ADVANCE(201);
      END_STATE();
    case 572:
      if (lookahead == 't') ADVANCE(362);
      END_STATE();
    case 573:
      if (lookahead == 't') ADVANCE(143);
      END_STATE();
    case 574:
      if (lookahead == 't') ADVANCE(202);
      END_STATE();
    case 575:
      if (lookahead == 't') ADVANCE(364);
      END_STATE();
    case 576:
      if (lookahead == 't') ADVANCE(146);
      END_STATE();
    case 577:
      if (lookahead == 't') ADVANCE(203);
      END_STATE();
    case 578:
      if (lookahead == 'u') ADVANCE(593);
      if (lookahead == 'x') ADVANCE(603);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(1261);
      if (sym_escape_sequence_character_set_1(lookahead)) ADVANCE(1262);
      if (lookahead != 0) ADVANCE(1260);
      END_STATE();
    case 579:
      if (lookahead == 'u') ADVANCE(196);
      END_STATE();
    case 580:
      if (lookahead == 'u') ADVANCE(398);
      END_STATE();
    case 581:
      if (lookahead == 'u') ADVANCE(507);
      END_STATE();
    case 582:
      if (lookahead == 'u') ADVANCE(402);
      END_STATE();
    case 583:
      if (lookahead == 'u') ADVANCE(291);
      END_STATE();
    case 584:
      if (lookahead == 'u') ADVANCE(292);
      END_STATE();
    case 585:
      if (lookahead == 'u') ADVANCE(193);
      END_STATE();
    case 586:
      if (lookahead == 'w') ADVANCE(375);
      END_STATE();
    case 587:
      if (lookahead == 'w') ADVANCE(376);
      END_STATE();
    case 588:
      if (lookahead == 'w') ADVANCE(377);
      END_STATE();
    case 589:
      if (lookahead == 'w') ADVANCE(378);
      END_STATE();
    case 590:
      if (lookahead == 'y') ADVANCE(21);
      END_STATE();
    case 591:
      if (lookahead == 'y') ADVANCE(1255);
      END_STATE();
    case 592:
      if (lookahead == 'y') ADVANCE(23);
      END_STATE();
    case 593:
      if (lookahead == '{') ADVANCE(601);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(602);
      END_STATE();
    case 594:
      if (lookahead == '}') ADVANCE(1262);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(594);
      END_STATE();
    case 595:
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(598);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1252);
      END_STATE();
    case 596:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1247);
      END_STATE();
    case 597:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1251);
      END_STATE();
    case 598:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1252);
      END_STATE();
    case 599:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(1262);
      END_STATE();
    case 600:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(1245);
      END_STATE();
    case 601:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(594);
      END_STATE();
    case 602:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(603);
      END_STATE();
    case 603:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(599);
      END_STATE();
    case 604:
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 605:
      if (eof) ADVANCE(608);
      if (lookahead == '"') ADVANCE(1256);
      if (lookahead == '#') ADVANCE(1274);
      if (lookahead == '\'') ADVANCE(1268);
      if (lookahead == '(') ADVANCE(1228);
      if (lookahead == ')') ADVANCE(1229);
      if (lookahead == '+') ADVANCE(30);
      if (lookahead == ',') ADVANCE(625);
      if (lookahead == '-') ADVANCE(1225);
      if (lookahead == '.') ADVANCE(28);
      if (lookahead == '/') ADVANCE(1219);
      if (lookahead == '0') ADVANCE(1237);
      if (lookahead == ':') ADVANCE(784);
      if (lookahead == ';') ADVANCE(1220);
      if (lookahead == '<') ADVANCE(604);
      if (lookahead == '=') ADVANCE(614);
      if (lookahead == '@') ADVANCE(1230);
      if (('B' <= lookahead && lookahead <= 'D') ||
          lookahead == 'F' ||
          lookahead == 'J' ||
          lookahead == 'S' ||
          lookahead == 'V' ||
          lookahead == 'Z') ADVANCE(1232);
      if (lookahead == 'I') ADVANCE(1233);
      if (lookahead == 'N') ADVANCE(923);
      if (lookahead == '[') ADVANCE(1231);
      if (lookahead == 'a') ADVANCE(955);
      if (lookahead == 'c') ADVANCE(1097);
      if (lookahead == 'd') ADVANCE(1012);
      if (lookahead == 'e') ADVANCE(1214);
      if (lookahead == 'f') ADVANCE(924);
      if (lookahead == 'g') ADVANCE(1098);
      if (lookahead == 'i') ADVANCE(1006);
      if (lookahead == 'm') ADVANCE(1107);
      if (lookahead == 'n') ADVANCE(1099);
      if (lookahead == 'o') ADVANCE(1136);
      if (lookahead == 'r') ADVANCE(966);
      if (lookahead == 's') ADVANCE(1007);
      if (lookahead == 't') ADVANCE(1008);
      if (lookahead == 'u') ADVANCE(1150);
      if (lookahead == 'x') ADVANCE(1130);
      if (lookahead == '{') ADVANCE(789);
      if (lookahead == '}') ADVANCE(791);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(605)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1240);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Y') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 606:
      if (eof) ADVANCE(608);
      if (lookahead == '#') ADVANCE(1274);
      if (lookahead == '$') ADVANCE(1218);
      if (lookahead == ')') ADVANCE(1229);
      if (lookahead == ',') ADVANCE(625);
      if (lookahead == '-') ADVANCE(112);
      if (lookahead == '.') ADVANCE(29);
      if (lookahead == ':') ADVANCE(111);
      if (lookahead == '<') ADVANCE(604);
      if (lookahead == '=') ADVANCE(614);
      if (lookahead == 'a') ADVANCE(842);
      if (lookahead == 'c') ADVANCE(880);
      if (lookahead == 'd') ADVANCE(863);
      if (lookahead == 'e') ADVANCE(919);
      if (lookahead == 'f') ADVANCE(865);
      if (lookahead == 'g') ADVANCE(881);
      if (lookahead == 'i') ADVANCE(858);
      if (lookahead == 'm') ADVANCE(887);
      if (lookahead == 'n') ADVANCE(883);
      if (lookahead == 'o') ADVANCE(890);
      if (lookahead == 'r') ADVANCE(846);
      if (lookahead == 's') ADVANCE(859);
      if (lookahead == 't') ADVANCE(861);
      if (lookahead == 'u') ADVANCE(895);
      if (lookahead == 'x') ADVANCE(888);
      if (lookahead == '}') ADVANCE(791);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(606)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(110);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(921);
      END_STATE();
    case 607:
      if (eof) ADVANCE(608);
      if (lookahead == '#') ADVANCE(1274);
      if (lookahead == '(') ADVANCE(1228);
      if (lookahead == ')') ADVANCE(1229);
      if (lookahead == ',') ADVANCE(625);
      if (lookahead == '-') ADVANCE(112);
      if (lookahead == '.') ADVANCE(187);
      if (lookahead == ':') ADVANCE(784);
      if (lookahead == '=') ADVANCE(614);
      if (lookahead == '{') ADVANCE(789);
      if (lookahead == '}') ADVANCE(791);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(607)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(620);
      END_STATE();
    case 608:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 609:
      ACCEPT_TOKEN(anon_sym_DOTclass);
      END_STATE();
    case 610:
      ACCEPT_TOKEN(anon_sym_DOTsuper);
      END_STATE();
    case 611:
      ACCEPT_TOKEN(anon_sym_DOTsource);
      END_STATE();
    case 612:
      ACCEPT_TOKEN(anon_sym_DOTimplements);
      END_STATE();
    case 613:
      ACCEPT_TOKEN(anon_sym_DOTfield);
      END_STATE();
    case 614:
      ACCEPT_TOKEN(anon_sym_EQ);
      END_STATE();
    case 615:
      ACCEPT_TOKEN(anon_sym_DOTendfield);
      END_STATE();
    case 616:
      ACCEPT_TOKEN(anon_sym_DOTmethod);
      END_STATE();
    case 617:
      ACCEPT_TOKEN(anon_sym_DOTendmethod);
      END_STATE();
    case 618:
      ACCEPT_TOKEN(anon_sym_DOTannotation);
      END_STATE();
    case 619:
      ACCEPT_TOKEN(anon_sym_DOTendannotation);
      END_STATE();
    case 620:
      ACCEPT_TOKEN(sym_annotation_key);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(620);
      END_STATE();
    case 621:
      ACCEPT_TOKEN(anon_sym_DOTsubannotation);
      END_STATE();
    case 622:
      ACCEPT_TOKEN(anon_sym_DOTendsubannotation);
      END_STATE();
    case 623:
      ACCEPT_TOKEN(anon_sym_DOTparam);
      if (lookahead == 'e') ADVANCE(564);
      END_STATE();
    case 624:
      ACCEPT_TOKEN(anon_sym_DOTendparam);
      END_STATE();
    case 625:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 626:
      ACCEPT_TOKEN(anon_sym_DOTparameter);
      END_STATE();
    case 627:
      ACCEPT_TOKEN(anon_sym_DOTendparameter);
      END_STATE();
    case 628:
      ACCEPT_TOKEN(anon_sym_LF);
      if (lookahead == '\n') ADVANCE(628);
      if (lookahead == '-') ADVANCE(1226);
      if (('B' <= lookahead && lookahead <= 'D') ||
          lookahead == 'F' ||
          lookahead == 'J' ||
          lookahead == 'S' ||
          lookahead == 'V' ||
          lookahead == 'Z') ADVANCE(1232);
      if (lookahead == 'I') ADVANCE(1234);
      if (lookahead == 'N') ADVANCE(837);
      END_STATE();
    case 629:
      ACCEPT_TOKEN(anon_sym_LF);
      if (lookahead == '\n') ADVANCE(629);
      END_STATE();
    case 630:
      ACCEPT_TOKEN(anon_sym_nop);
      if (lookahead == ':') ADVANCE(1224);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == '$' ||
          lookahead == '-') ADVANCE(1218);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(921);
      END_STATE();
    case 631:
      ACCEPT_TOKEN(anon_sym_nop);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 632:
      ACCEPT_TOKEN(anon_sym_move);
      if (lookahead == '$') ADVANCE(1218);
      if (lookahead == '-') ADVANCE(1105);
      if (lookahead == '/') ADVANCE(32);
      if (lookahead == ':') ADVANCE(1224);
      if (lookahead == '>') ADVANCE(802);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(921);
      END_STATE();
    case 633:
      ACCEPT_TOKEN(anon_sym_move);
      if (lookahead == '-') ADVANCE(1105);
      if (lookahead == '/') ADVANCE(32);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 634:
      ACCEPT_TOKEN(anon_sym_move_SLASHfrom16);
      END_STATE();
    case 635:
      ACCEPT_TOKEN(anon_sym_move_SLASH16);
      END_STATE();
    case 636:
      ACCEPT_TOKEN(anon_sym_move_DASHwide);
      if (lookahead == '/') ADVANCE(36);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 637:
      ACCEPT_TOKEN(anon_sym_move_DASHwide_SLASHfrom16);
      END_STATE();
    case 638:
      ACCEPT_TOKEN(anon_sym_move_DASHwide_SLASH16);
      END_STATE();
    case 639:
      ACCEPT_TOKEN(anon_sym_move_DASHobject);
      if (lookahead == '/') ADVANCE(46);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 640:
      ACCEPT_TOKEN(anon_sym_move_DASHobject_SLASHfrom16);
      END_STATE();
    case 641:
      ACCEPT_TOKEN(anon_sym_move_DASHobject_SLASH16);
      END_STATE();
    case 642:
      ACCEPT_TOKEN(anon_sym_return);
      if (lookahead == ':') ADVANCE(1224);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == '$' ||
          lookahead == '-') ADVANCE(1218);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(921);
      END_STATE();
    case 643:
      ACCEPT_TOKEN(anon_sym_return);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 644:
      ACCEPT_TOKEN(anon_sym_const_SLASH4);
      END_STATE();
    case 645:
      ACCEPT_TOKEN(anon_sym_const_SLASH16);
      END_STATE();
    case 646:
      ACCEPT_TOKEN(anon_sym_const);
      if (lookahead == '$') ADVANCE(1218);
      if (lookahead == '-') ADVANCE(1153);
      if (lookahead == '/') ADVANCE(33);
      if (lookahead == ':') ADVANCE(1224);
      if (lookahead == '>') ADVANCE(802);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(921);
      END_STATE();
    case 647:
      ACCEPT_TOKEN(anon_sym_const);
      if (lookahead == '-') ADVANCE(1153);
      if (lookahead == '/') ADVANCE(33);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 648:
      ACCEPT_TOKEN(anon_sym_const_SLASHhigh16);
      END_STATE();
    case 649:
      ACCEPT_TOKEN(anon_sym_const_DASHwide_SLASH16);
      END_STATE();
    case 650:
      ACCEPT_TOKEN(anon_sym_const_DASHwide_SLASH32);
      END_STATE();
    case 651:
      ACCEPT_TOKEN(anon_sym_const_DASHwide);
      if (lookahead == '/') ADVANCE(40);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 652:
      ACCEPT_TOKEN(anon_sym_const_DASHwide_SLASHhigh16);
      END_STATE();
    case 653:
      ACCEPT_TOKEN(anon_sym_const_DASHstring);
      if (lookahead == '/') ADVANCE(380);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 654:
      ACCEPT_TOKEN(anon_sym_const_DASHstring_SLASHjumbo);
      END_STATE();
    case 655:
      ACCEPT_TOKEN(anon_sym_filled_DASHnew_DASHarray);
      if (lookahead == '/') ADVANCE(521);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 656:
      ACCEPT_TOKEN(anon_sym_filled_DASHnew_DASHarray_SLASHrange);
      END_STATE();
    case 657:
      ACCEPT_TOKEN(anon_sym_throw);
      if (lookahead == ':') ADVANCE(1224);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == '$' ||
          lookahead == '-') ADVANCE(1218);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(921);
      END_STATE();
    case 658:
      ACCEPT_TOKEN(anon_sym_throw);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 659:
      ACCEPT_TOKEN(anon_sym_goto);
      if (lookahead == '/') ADVANCE(31);
      if (lookahead == ':') ADVANCE(1224);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == '$' ||
          lookahead == '-') ADVANCE(1218);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(921);
      END_STATE();
    case 660:
      ACCEPT_TOKEN(anon_sym_goto);
      if (lookahead == '/') ADVANCE(31);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 661:
      ACCEPT_TOKEN(anon_sym_goto_SLASH16);
      END_STATE();
    case 662:
      ACCEPT_TOKEN(anon_sym_goto_SLASH32);
      END_STATE();
    case 663:
      ACCEPT_TOKEN(anon_sym_aget);
      if (lookahead == ':') ADVANCE(1224);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == '$' ||
          lookahead == '-') ADVANCE(1218);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(921);
      END_STATE();
    case 664:
      ACCEPT_TOKEN(anon_sym_aget);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 665:
      ACCEPT_TOKEN(anon_sym_aput);
      if (lookahead == ':') ADVANCE(1224);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == '$' ||
          lookahead == '-') ADVANCE(1218);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(921);
      END_STATE();
    case 666:
      ACCEPT_TOKEN(anon_sym_aput);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 667:
      ACCEPT_TOKEN(anon_sym_iget);
      if (lookahead == ':') ADVANCE(1224);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == '$' ||
          lookahead == '-') ADVANCE(1218);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(921);
      END_STATE();
    case 668:
      ACCEPT_TOKEN(anon_sym_iget);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 669:
      ACCEPT_TOKEN(anon_sym_iput);
      if (lookahead == ':') ADVANCE(1224);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == '$' ||
          lookahead == '-') ADVANCE(1218);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(921);
      END_STATE();
    case 670:
      ACCEPT_TOKEN(anon_sym_iput);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 671:
      ACCEPT_TOKEN(anon_sym_sget);
      if (lookahead == ':') ADVANCE(1224);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == '$' ||
          lookahead == '-') ADVANCE(1218);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(921);
      END_STATE();
    case 672:
      ACCEPT_TOKEN(anon_sym_sget);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 673:
      ACCEPT_TOKEN(anon_sym_sput);
      if (lookahead == ':') ADVANCE(1224);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == '$' ||
          lookahead == '-') ADVANCE(1218);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(921);
      END_STATE();
    case 674:
      ACCEPT_TOKEN(anon_sym_sput);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 675:
      ACCEPT_TOKEN(anon_sym_invoke_DASHcustom);
      if (lookahead == '/') ADVANCE(516);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 676:
      ACCEPT_TOKEN(anon_sym_invoke_DASHdirect);
      if (lookahead == '/') ADVANCE(517);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 677:
      ACCEPT_TOKEN(anon_sym_invoke_DASHinterface);
      if (lookahead == '/') ADVANCE(522);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 678:
      ACCEPT_TOKEN(anon_sym_invoke_DASHpolymorphic);
      if (lookahead == '/') ADVANCE(524);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 679:
      ACCEPT_TOKEN(anon_sym_invoke_DASHstatic);
      if (lookahead == '/') ADVANCE(518);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 680:
      ACCEPT_TOKEN(anon_sym_invoke_DASHsuper);
      if (lookahead == '-') ADVANCE(1134);
      if (lookahead == '/') ADVANCE(513);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 681:
      ACCEPT_TOKEN(anon_sym_invoke_DASHvirtual);
      if (lookahead == '-') ADVANCE(1135);
      if (lookahead == '/') ADVANCE(520);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 682:
      ACCEPT_TOKEN(anon_sym_invoke_DASHcustom_SLASHrange);
      END_STATE();
    case 683:
      ACCEPT_TOKEN(anon_sym_invoke_DASHdirect_SLASHrange);
      END_STATE();
    case 684:
      ACCEPT_TOKEN(anon_sym_invoke_DASHinterface_SLASHrange);
      END_STATE();
    case 685:
      ACCEPT_TOKEN(anon_sym_invoke_DASHobject_DASHinit_SLASHrange);
      END_STATE();
    case 686:
      ACCEPT_TOKEN(anon_sym_invoke_DASHpolymorphic_SLASHrange);
      END_STATE();
    case 687:
      ACCEPT_TOKEN(anon_sym_invoke_DASHstatic_SLASHrange);
      END_STATE();
    case 688:
      ACCEPT_TOKEN(anon_sym_invoke_DASHsuper_SLASHrange);
      END_STATE();
    case 689:
      ACCEPT_TOKEN(anon_sym_invoke_DASHvirtual_SLASHrange);
      END_STATE();
    case 690:
      ACCEPT_TOKEN(anon_sym_add_DASHint);
      if (lookahead == '/') ADVANCE(53);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 691:
      ACCEPT_TOKEN(anon_sym_sub_DASHint);
      if (lookahead == '/') ADVANCE(61);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 692:
      ACCEPT_TOKEN(anon_sym_mul_DASHint);
      if (lookahead == '/') ADVANCE(56);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 693:
      ACCEPT_TOKEN(anon_sym_div_DASHint);
      if (lookahead == '/') ADVANCE(55);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 694:
      ACCEPT_TOKEN(anon_sym_rem_DASHint);
      if (lookahead == '/') ADVANCE(58);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 695:
      ACCEPT_TOKEN(anon_sym_and_DASHint);
      if (lookahead == '/') ADVANCE(54);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 696:
      ACCEPT_TOKEN(anon_sym_or_DASHint);
      if (lookahead == '/') ADVANCE(52);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 697:
      ACCEPT_TOKEN(anon_sym_xor_DASHint);
      if (lookahead == '/') ADVANCE(62);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 698:
      ACCEPT_TOKEN(anon_sym_shl_DASHint);
      if (lookahead == '/') ADVANCE(59);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 699:
      ACCEPT_TOKEN(anon_sym_shr_DASHint);
      if (lookahead == '/') ADVANCE(60);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 700:
      ACCEPT_TOKEN(anon_sym_ushr_DASHint);
      if (lookahead == '/') ADVANCE(71);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 701:
      ACCEPT_TOKEN(anon_sym_add_DASHlong);
      if (lookahead == '/') ADVANCE(63);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 702:
      ACCEPT_TOKEN(anon_sym_sub_DASHlong);
      if (lookahead == '/') ADVANCE(70);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 703:
      ACCEPT_TOKEN(anon_sym_mul_DASHlong);
      if (lookahead == '/') ADVANCE(66);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 704:
      ACCEPT_TOKEN(anon_sym_div_DASHlong);
      if (lookahead == '/') ADVANCE(65);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 705:
      ACCEPT_TOKEN(anon_sym_rem_DASHlong);
      if (lookahead == '/') ADVANCE(67);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 706:
      ACCEPT_TOKEN(anon_sym_and_DASHlong);
      if (lookahead == '/') ADVANCE(64);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 707:
      ACCEPT_TOKEN(anon_sym_or_DASHlong);
      if (lookahead == '/') ADVANCE(57);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 708:
      ACCEPT_TOKEN(anon_sym_xor_DASHlong);
      if (lookahead == '/') ADVANCE(72);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 709:
      ACCEPT_TOKEN(anon_sym_shl_DASHlong);
      if (lookahead == '/') ADVANCE(68);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 710:
      ACCEPT_TOKEN(anon_sym_shr_DASHlong);
      if (lookahead == '/') ADVANCE(69);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 711:
      ACCEPT_TOKEN(anon_sym_ushr_DASHlong);
      if (lookahead == '/') ADVANCE(78);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 712:
      ACCEPT_TOKEN(anon_sym_add_DASHfloat);
      if (lookahead == '/') ADVANCE(73);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 713:
      ACCEPT_TOKEN(anon_sym_sub_DASHfloat);
      if (lookahead == '/') ADVANCE(77);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 714:
      ACCEPT_TOKEN(anon_sym_mul_DASHfloat);
      if (lookahead == '/') ADVANCE(75);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 715:
      ACCEPT_TOKEN(anon_sym_div_DASHfloat);
      if (lookahead == '/') ADVANCE(74);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 716:
      ACCEPT_TOKEN(anon_sym_rem_DASHfloat);
      if (lookahead == '/') ADVANCE(76);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 717:
      ACCEPT_TOKEN(anon_sym_add_DASHdouble);
      if (lookahead == '/') ADVANCE(79);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 718:
      ACCEPT_TOKEN(anon_sym_sub_DASHdouble);
      if (lookahead == '/') ADVANCE(83);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 719:
      ACCEPT_TOKEN(anon_sym_mul_DASHdouble);
      if (lookahead == '/') ADVANCE(81);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 720:
      ACCEPT_TOKEN(anon_sym_div_DASHdouble);
      if (lookahead == '/') ADVANCE(80);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 721:
      ACCEPT_TOKEN(anon_sym_rem_DASHdouble);
      if (lookahead == '/') ADVANCE(82);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 722:
      ACCEPT_TOKEN(anon_sym_add_DASHint_SLASH2addr);
      END_STATE();
    case 723:
      ACCEPT_TOKEN(anon_sym_sub_DASHint_SLASH2addr);
      END_STATE();
    case 724:
      ACCEPT_TOKEN(anon_sym_mul_DASHint_SLASH2addr);
      END_STATE();
    case 725:
      ACCEPT_TOKEN(anon_sym_div_DASHint_SLASH2addr);
      END_STATE();
    case 726:
      ACCEPT_TOKEN(anon_sym_rem_DASHint_SLASH2addr);
      END_STATE();
    case 727:
      ACCEPT_TOKEN(anon_sym_and_DASHint_SLASH2addr);
      END_STATE();
    case 728:
      ACCEPT_TOKEN(anon_sym_or_DASHint_SLASH2addr);
      END_STATE();
    case 729:
      ACCEPT_TOKEN(anon_sym_xor_DASHint_SLASH2addr);
      END_STATE();
    case 730:
      ACCEPT_TOKEN(anon_sym_shl_DASHint_SLASH2addr);
      END_STATE();
    case 731:
      ACCEPT_TOKEN(anon_sym_shr_DASHint_SLASH2addr);
      END_STATE();
    case 732:
      ACCEPT_TOKEN(anon_sym_ushr_DASHint_SLASH2addr);
      END_STATE();
    case 733:
      ACCEPT_TOKEN(anon_sym_add_DASHlong_SLASH2addr);
      END_STATE();
    case 734:
      ACCEPT_TOKEN(anon_sym_sub_DASHlong_SLASH2addr);
      END_STATE();
    case 735:
      ACCEPT_TOKEN(anon_sym_mul_DASHlong_SLASH2addr);
      END_STATE();
    case 736:
      ACCEPT_TOKEN(anon_sym_div_DASHlong_SLASH2addr);
      END_STATE();
    case 737:
      ACCEPT_TOKEN(anon_sym_rem_DASHlong_SLASH2addr);
      END_STATE();
    case 738:
      ACCEPT_TOKEN(anon_sym_and_DASHlong_SLASH2addr);
      END_STATE();
    case 739:
      ACCEPT_TOKEN(anon_sym_or_DASHlong_SLASH2addr);
      END_STATE();
    case 740:
      ACCEPT_TOKEN(anon_sym_xor_DASHlong_SLASH2addr);
      END_STATE();
    case 741:
      ACCEPT_TOKEN(anon_sym_shl_DASHlong_SLASH2addr);
      END_STATE();
    case 742:
      ACCEPT_TOKEN(anon_sym_shr_DASHlong_SLASH2addr);
      END_STATE();
    case 743:
      ACCEPT_TOKEN(anon_sym_ushr_DASHlong_SLASH2addr);
      END_STATE();
    case 744:
      ACCEPT_TOKEN(anon_sym_add_DASHfloat_SLASH2addr);
      END_STATE();
    case 745:
      ACCEPT_TOKEN(anon_sym_sub_DASHfloat_SLASH2addr);
      END_STATE();
    case 746:
      ACCEPT_TOKEN(anon_sym_mul_DASHfloat_SLASH2addr);
      END_STATE();
    case 747:
      ACCEPT_TOKEN(anon_sym_div_DASHfloat_SLASH2addr);
      END_STATE();
    case 748:
      ACCEPT_TOKEN(anon_sym_rem_DASHfloat_SLASH2addr);
      END_STATE();
    case 749:
      ACCEPT_TOKEN(anon_sym_add_DASHdouble_SLASH2addr);
      END_STATE();
    case 750:
      ACCEPT_TOKEN(anon_sym_sub_DASHdouble_SLASH2addr);
      END_STATE();
    case 751:
      ACCEPT_TOKEN(anon_sym_mul_DASHdouble_SLASH2addr);
      END_STATE();
    case 752:
      ACCEPT_TOKEN(anon_sym_div_DASHdouble_SLASH2addr);
      END_STATE();
    case 753:
      ACCEPT_TOKEN(anon_sym_rem_DASHdouble_SLASH2addr);
      END_STATE();
    case 754:
      ACCEPT_TOKEN(anon_sym_add_DASHint_SLASHlit16);
      END_STATE();
    case 755:
      ACCEPT_TOKEN(anon_sym_sub_DASHint_SLASHlit16);
      END_STATE();
    case 756:
      ACCEPT_TOKEN(anon_sym_mul_DASHint_SLASHlit16);
      END_STATE();
    case 757:
      ACCEPT_TOKEN(anon_sym_div_DASHint_SLASHlit16);
      END_STATE();
    case 758:
      ACCEPT_TOKEN(anon_sym_rem_DASHint_SLASHlit16);
      END_STATE();
    case 759:
      ACCEPT_TOKEN(anon_sym_and_DASHint_SLASHlit16);
      END_STATE();
    case 760:
      ACCEPT_TOKEN(anon_sym_or_DASHint_SLASHlit16);
      END_STATE();
    case 761:
      ACCEPT_TOKEN(anon_sym_xor_DASHint_SLASHlit16);
      END_STATE();
    case 762:
      ACCEPT_TOKEN(anon_sym_add_DASHint_SLASHlit8);
      END_STATE();
    case 763:
      ACCEPT_TOKEN(anon_sym_sub_DASHint_SLASHlit8);
      END_STATE();
    case 764:
      ACCEPT_TOKEN(anon_sym_mul_DASHint_SLASHlit8);
      END_STATE();
    case 765:
      ACCEPT_TOKEN(anon_sym_div_DASHint_SLASHlit8);
      END_STATE();
    case 766:
      ACCEPT_TOKEN(anon_sym_rem_DASHint_SLASHlit8);
      END_STATE();
    case 767:
      ACCEPT_TOKEN(anon_sym_and_DASHint_SLASHlit8);
      END_STATE();
    case 768:
      ACCEPT_TOKEN(anon_sym_or_DASHint_SLASHlit8);
      END_STATE();
    case 769:
      ACCEPT_TOKEN(anon_sym_xor_DASHint_SLASHlit8);
      END_STATE();
    case 770:
      ACCEPT_TOKEN(anon_sym_shl_DASHint_SLASHlit8);
      END_STATE();
    case 771:
      ACCEPT_TOKEN(anon_sym_shr_DASHint_SLASHlit8);
      END_STATE();
    case 772:
      ACCEPT_TOKEN(anon_sym_ushr_DASHint_SLASHlit8);
      END_STATE();
    case 773:
      ACCEPT_TOKEN(anon_sym_execute_DASHinline);
      if (lookahead == '/') ADVANCE(519);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 774:
      ACCEPT_TOKEN(anon_sym_execute_DASHinline_SLASHrange);
      END_STATE();
    case 775:
      ACCEPT_TOKEN(anon_sym_invoke_DASHvirtual_DASHquick);
      if (lookahead == '/') ADVANCE(526);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 776:
      ACCEPT_TOKEN(anon_sym_invoke_DASHvirtual_DASHquick_SLASHrange);
      END_STATE();
    case 777:
      ACCEPT_TOKEN(anon_sym_invoke_DASHsuper_DASHquick);
      if (lookahead == '/') ADVANCE(525);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 778:
      ACCEPT_TOKEN(anon_sym_invoke_DASHsuper_DASHquick_SLASHrange);
      END_STATE();
    case 779:
      ACCEPT_TOKEN(anon_sym_rsub_DASHint);
      if (lookahead == '/') ADVANCE(394);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 780:
      ACCEPT_TOKEN(anon_sym_rsub_DASHint_SLASHlit8);
      END_STATE();
    case 781:
      ACCEPT_TOKEN(anon_sym_DOTline);
      END_STATE();
    case 782:
      ACCEPT_TOKEN(anon_sym_DOTlocals);
      END_STATE();
    case 783:
      ACCEPT_TOKEN(anon_sym_DOTlocal);
      if (lookahead == 's') ADVANCE(782);
      END_STATE();
    case 784:
      ACCEPT_TOKEN(anon_sym_COLON);
      END_STATE();
    case 785:
      ACCEPT_TOKEN(anon_sym_DOTendlocal);
      END_STATE();
    case 786:
      ACCEPT_TOKEN(anon_sym_DOTrestartlocal);
      END_STATE();
    case 787:
      ACCEPT_TOKEN(anon_sym_DOTregisters);
      END_STATE();
    case 788:
      ACCEPT_TOKEN(anon_sym_DOTcatch);
      if (lookahead == 'a') ADVANCE(393);
      END_STATE();
    case 789:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 790:
      ACCEPT_TOKEN(anon_sym_DOT_DOT);
      END_STATE();
    case 791:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 792:
      ACCEPT_TOKEN(anon_sym_DOTcatchall);
      END_STATE();
    case 793:
      ACCEPT_TOKEN(anon_sym_DOTpacked_DASHswitch);
      END_STATE();
    case 794:
      ACCEPT_TOKEN(anon_sym_DOTendpacked_DASHswitch);
      END_STATE();
    case 795:
      ACCEPT_TOKEN(anon_sym_DOTsparse_DASHswitch);
      END_STATE();
    case 796:
      ACCEPT_TOKEN(anon_sym_DASH_GT);
      END_STATE();
    case 797:
      ACCEPT_TOKEN(anon_sym_DOTendsparse_DASHswitch);
      END_STATE();
    case 798:
      ACCEPT_TOKEN(anon_sym_DOTarray_DASHdata);
      END_STATE();
    case 799:
      ACCEPT_TOKEN(anon_sym_DOTendarray_DASHdata);
      END_STATE();
    case 800:
      ACCEPT_TOKEN(sym_prologue_directive);
      END_STATE();
    case 801:
      ACCEPT_TOKEN(sym_epilogue_directive);
      END_STATE();
    case 802:
      ACCEPT_TOKEN(sym_identifier);
      END_STATE();
    case 803:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '$') ADVANCE(1218);
      if (lookahead == '-') ADVANCE(1016);
      if (lookahead == ':') ADVANCE(1224);
      if (lookahead == '>') ADVANCE(802);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(921);
      END_STATE();
    case 804:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '$') ADVANCE(1218);
      if (lookahead == '-') ADVANCE(958);
      if (lookahead == ':') ADVANCE(1224);
      if (lookahead == '>') ADVANCE(802);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(921);
      END_STATE();
    case 805:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '$') ADVANCE(1218);
      if (lookahead == '-') ADVANCE(949);
      if (lookahead == ':') ADVANCE(1224);
      if (lookahead == '>') ADVANCE(802);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(921);
      END_STATE();
    case 806:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '$') ADVANCE(1218);
      if (lookahead == '-') ADVANCE(1077);
      if (lookahead == ':') ADVANCE(1224);
      if (lookahead == '>') ADVANCE(802);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(921);
      END_STATE();
    case 807:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '$') ADVANCE(1218);
      if (lookahead == '-') ADVANCE(1033);
      if (lookahead == ':') ADVANCE(1224);
      if (lookahead == '>') ADVANCE(802);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(921);
      END_STATE();
    case 808:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '$') ADVANCE(1218);
      if (lookahead == '-') ADVANCE(1024);
      if (lookahead == ':') ADVANCE(1224);
      if (lookahead == '>') ADVANCE(802);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(921);
      END_STATE();
    case 809:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '$') ADVANCE(1218);
      if (lookahead == '-') ADVANCE(1029);
      if (lookahead == ':') ADVANCE(1224);
      if (lookahead == '>') ADVANCE(802);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(921);
      END_STATE();
    case 810:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '$') ADVANCE(1218);
      if (lookahead == '-') ADVANCE(961);
      if (lookahead == ':') ADVANCE(1224);
      if (lookahead == '>') ADVANCE(802);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(921);
      END_STATE();
    case 811:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '$') ADVANCE(1218);
      if (lookahead == '-') ADVANCE(1030);
      if (lookahead == ':') ADVANCE(1224);
      if (lookahead == '>') ADVANCE(802);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(921);
      END_STATE();
    case 812:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '$') ADVANCE(1218);
      if (lookahead == '-') ADVANCE(962);
      if (lookahead == ':') ADVANCE(1224);
      if (lookahead == '>') ADVANCE(802);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(921);
      END_STATE();
    case 813:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '$') ADVANCE(1218);
      if (lookahead == '-') ADVANCE(1031);
      if (lookahead == ':') ADVANCE(1224);
      if (lookahead == '>') ADVANCE(802);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(921);
      END_STATE();
    case 814:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '$') ADVANCE(1218);
      if (lookahead == '-') ADVANCE(963);
      if (lookahead == ':') ADVANCE(1224);
      if (lookahead == '>') ADVANCE(802);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(921);
      END_STATE();
    case 815:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '$') ADVANCE(1218);
      if (lookahead == '-') ADVANCE(1032);
      if (lookahead == ':') ADVANCE(1224);
      if (lookahead == '>') ADVANCE(802);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(921);
      END_STATE();
    case 816:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '$') ADVANCE(1218);
      if (lookahead == '-') ADVANCE(964);
      if (lookahead == ':') ADVANCE(1224);
      if (lookahead == '>') ADVANCE(802);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(921);
      END_STATE();
    case 817:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '$') ADVANCE(1218);
      if (lookahead == '-') ADVANCE(1034);
      if (lookahead == ':') ADVANCE(1224);
      if (lookahead == '>') ADVANCE(802);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(921);
      END_STATE();
    case 818:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '-') ADVANCE(1016);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 819:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '-') ADVANCE(958);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 820:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '-') ADVANCE(949);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 821:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '-') ADVANCE(928);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 822:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '-') ADVANCE(1077);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 823:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '-') ADVANCE(1033);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 824:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '-') ADVANCE(1024);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 825:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '-') ADVANCE(1029);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 826:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '-') ADVANCE(961);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 827:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '-') ADVANCE(1030);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 828:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '-') ADVANCE(962);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 829:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '-') ADVANCE(1031);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 830:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '-') ADVANCE(963);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 831:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '-') ADVANCE(1032);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 832:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '-') ADVANCE(964);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 833:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '-') ADVANCE(1034);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 834:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '-') ADVANCE(1035);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 835:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '/') ADVANCE(523);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 836:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(1224);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'N') ADVANCE(1254);
      if (lookahead == '$' ||
          lookahead == '-') ADVANCE(1218);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(921);
      END_STATE();
    case 837:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(1224);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'a') ADVANCE(836);
      if (lookahead == '$' ||
          lookahead == '-') ADVANCE(1218);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(921);
      END_STATE();
    case 838:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(1224);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'a') ADVANCE(869);
      if (lookahead == 'i') ADVANCE(870);
      if (lookahead == '$' ||
          lookahead == '-') ADVANCE(1218);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(921);
      END_STATE();
    case 839:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(1224);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'b') ADVANCE(807);
      if (lookahead == '$' ||
          lookahead == '-') ADVANCE(1218);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(921);
      END_STATE();
    case 840:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(1224);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'b') ADVANCE(816);
      if (lookahead == '$' ||
          lookahead == '-') ADVANCE(1218);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(921);
      END_STATE();
    case 841:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(1224);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'c') ADVANCE(913);
      if (lookahead == '$' ||
          lookahead == '-') ADVANCE(1218);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(921);
      END_STATE();
    case 842:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(1224);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'd') ADVANCE(843);
      if (lookahead == 'g') ADVANCE(851);
      if (lookahead == 'n') ADVANCE(845);
      if (lookahead == 'p') ADVANCE(909);
      if (lookahead == '$' ||
          lookahead == '-') ADVANCE(1218);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(921);
      END_STATE();
    case 843:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(1224);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'd') ADVANCE(804);
      if (lookahead == '$' ||
          lookahead == '-') ADVANCE(1218);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(921);
      END_STATE();
    case 844:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(1224);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'd') ADVANCE(806);
      if (lookahead == '$' ||
          lookahead == '-') ADVANCE(1218);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(921);
      END_STATE();
    case 845:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(1224);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'd') ADVANCE(809);
      if (lookahead == '$' ||
          lookahead == '-') ADVANCE(1218);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(921);
      END_STATE();
    case 846:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(1224);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'e') ADVANCE(875);
      if (lookahead == 's') ADVANCE(914);
      if (lookahead == '$' ||
          lookahead == '-') ADVANCE(1218);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(921);
      END_STATE();
    case 847:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(1224);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'e') ADVANCE(841);
      if (lookahead == '$' ||
          lookahead == '-') ADVANCE(1218);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(921);
      END_STATE();
    case 848:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(1224);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'e') ADVANCE(632);
      if (lookahead == '$' ||
          lookahead == '-') ADVANCE(1218);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(921);
      END_STATE();
    case 849:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(1224);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'e') ADVANCE(1264);
      if (lookahead == '$' ||
          lookahead == '-') ADVANCE(1218);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(921);
      END_STATE();
    case 850:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(1224);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'e') ADVANCE(1266);
      if (lookahead == '$' ||
          lookahead == '-') ADVANCE(1218);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(921);
      END_STATE();
    case 851:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(1224);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'e') ADVANCE(898);
      if (lookahead == '$' ||
          lookahead == '-') ADVANCE(1218);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(921);
      END_STATE();
    case 852:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(1224);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'e') ADVANCE(900);
      if (lookahead == '$' ||
          lookahead == '-') ADVANCE(1218);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(921);
      END_STATE();
    case 853:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(1224);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'e') ADVANCE(805);
      if (lookahead == '$' ||
          lookahead == '-') ADVANCE(1218);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(921);
      END_STATE();
    case 854:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(1224);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'e') ADVANCE(902);
      if (lookahead == '$' ||
          lookahead == '-') ADVANCE(1218);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(921);
      END_STATE();
    case 855:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(1224);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'e') ADVANCE(844);
      if (lookahead == '$' ||
          lookahead == '-') ADVANCE(1218);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(921);
      END_STATE();
    case 856:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(1224);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'e') ADVANCE(808);
      if (lookahead == '$' ||
          lookahead == '-') ADVANCE(1218);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(921);
      END_STATE();
    case 857:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(1224);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'f') ADVANCE(864);
      if (lookahead == '$' ||
          lookahead == '-') ADVANCE(1218);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(921);
      END_STATE();
    case 858:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(1224);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'g') ADVANCE(852);
      if (lookahead == 'n') ADVANCE(916);
      if (lookahead == 'p') ADVANCE(911);
      if (lookahead == '$' ||
          lookahead == '-') ADVANCE(1218);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(921);
      END_STATE();
    case 859:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(1224);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'g') ADVANCE(854);
      if (lookahead == 'h') ADVANCE(873);
      if (lookahead == 'p') ADVANCE(912);
      if (lookahead == 'u') ADVANCE(840);
      if (lookahead == '$' ||
          lookahead == '-') ADVANCE(1218);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(921);
      END_STATE();
    case 860:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(1224);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'h') ADVANCE(892);
      if (lookahead == 'r') ADVANCE(910);
      if (lookahead == '$' ||
          lookahead == '-') ADVANCE(1218);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(921);
      END_STATE();
    case 861:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(1224);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'h') ADVANCE(892);
      if (lookahead == '$' ||
          lookahead == '-') ADVANCE(1218);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(921);
      END_STATE();
    case 862:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(1224);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'h') ADVANCE(894);
      if (lookahead == '$' ||
          lookahead == '-') ADVANCE(1218);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(921);
      END_STATE();
    case 863:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(1224);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'i') ADVANCE(917);
      if (lookahead == '$' ||
          lookahead == '-') ADVANCE(1218);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(921);
      END_STATE();
    case 864:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(1224);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'i') ADVANCE(879);
      if (lookahead == '$' ||
          lookahead == '-') ADVANCE(1218);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(921);
      END_STATE();
    case 865:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(1224);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'i') ADVANCE(870);
      if (lookahead == '$' ||
          lookahead == '-') ADVANCE(1218);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(921);
      END_STATE();
    case 866:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(1224);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'i') ADVANCE(905);
      if (lookahead == '$' ||
          lookahead == '-') ADVANCE(1218);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(921);
      END_STATE();
    case 867:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(1224);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'k') ADVANCE(853);
      if (lookahead == '$' ||
          lookahead == '-') ADVANCE(1218);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(921);
      END_STATE();
    case 868:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(1224);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'l') ADVANCE(1272);
      if (lookahead == '$' ||
          lookahead == '-') ADVANCE(1218);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(921);
      END_STATE();
    case 869:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(1224);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'l') ADVANCE(896);
      if (lookahead == '$' ||
          lookahead == '-') ADVANCE(1218);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(921);
      END_STATE();
    case 870:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(1224);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'l') ADVANCE(872);
      if (lookahead == '$' ||
          lookahead == '-') ADVANCE(1218);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(921);
      END_STATE();
    case 871:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(1224);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'l') ADVANCE(868);
      if (lookahead == '$' ||
          lookahead == '-') ADVANCE(1218);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(921);
      END_STATE();
    case 872:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(1224);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'l') ADVANCE(855);
      if (lookahead == '$' ||
          lookahead == '-') ADVANCE(1218);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(921);
      END_STATE();
    case 873:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(1224);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'l') ADVANCE(811);
      if (lookahead == 'r') ADVANCE(813);
      if (lookahead == '$' ||
          lookahead == '-') ADVANCE(1218);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(921);
      END_STATE();
    case 874:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(1224);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'l') ADVANCE(812);
      if (lookahead == '$' ||
          lookahead == '-') ADVANCE(1218);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(921);
      END_STATE();
    case 875:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(1224);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'm') ADVANCE(814);
      if (lookahead == 't') ADVANCE(908);
      if (lookahead == '$' ||
          lookahead == '-') ADVANCE(1218);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(921);
      END_STATE();
    case 876:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(1224);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'n') ADVANCE(857);
      if (lookahead == '$' ||
          lookahead == '-') ADVANCE(1218);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(921);
      END_STATE();
    case 877:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(1224);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'n') ADVANCE(642);
      if (lookahead == '$' ||
          lookahead == '-') ADVANCE(1218);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(921);
      END_STATE();
    case 878:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(1224);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'n') ADVANCE(897);
      if (lookahead == '$' ||
          lookahead == '-') ADVANCE(1218);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(921);
      END_STATE();
    case 879:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(1224);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'n') ADVANCE(866);
      if (lookahead == '$' ||
          lookahead == '-') ADVANCE(1218);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(921);
      END_STATE();
    case 880:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(1224);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'o') ADVANCE(878);
      if (lookahead == '$' ||
          lookahead == '-') ADVANCE(1218);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(921);
      END_STATE();
    case 881:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(1224);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'o') ADVANCE(906);
      if (lookahead == '$' ||
          lookahead == '-') ADVANCE(1218);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(921);
      END_STATE();
    case 882:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(1224);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'o') ADVANCE(889);
      if (lookahead == 'u') ADVANCE(871);
      if (lookahead == '$' ||
          lookahead == '-') ADVANCE(1218);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(921);
      END_STATE();
    case 883:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(1224);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'o') ADVANCE(889);
      if (lookahead == '$' ||
          lookahead == '-') ADVANCE(1218);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(921);
      END_STATE();
    case 884:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(1224);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'o') ADVANCE(659);
      if (lookahead == '$' ||
          lookahead == '-') ADVANCE(1218);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(921);
      END_STATE();
    case 885:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(1224);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'o') ADVANCE(867);
      if (lookahead == '$' ||
          lookahead == '-') ADVANCE(1218);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(921);
      END_STATE();
    case 886:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(1224);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'o') ADVANCE(918);
      if (lookahead == '$' ||
          lookahead == '-') ADVANCE(1218);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(921);
      END_STATE();
    case 887:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(1224);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'o') ADVANCE(915);
      if (lookahead == 'u') ADVANCE(874);
      if (lookahead == '$' ||
          lookahead == '-') ADVANCE(1218);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(921);
      END_STATE();
    case 888:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(1224);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'o') ADVANCE(893);
      if (lookahead == '$' ||
          lookahead == '-') ADVANCE(1218);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(921);
      END_STATE();
    case 889:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(1224);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'p') ADVANCE(630);
      if (lookahead == '$' ||
          lookahead == '-') ADVANCE(1218);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(921);
      END_STATE();
    case 890:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(1224);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'r') ADVANCE(803);
      if (lookahead == '$' ||
          lookahead == '-') ADVANCE(1218);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(921);
      END_STATE();
    case 891:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(1224);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'r') ADVANCE(877);
      if (lookahead == '$' ||
          lookahead == '-') ADVANCE(1218);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(921);
      END_STATE();
    case 892:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(1224);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'r') ADVANCE(886);
      if (lookahead == '$' ||
          lookahead == '-') ADVANCE(1218);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(921);
      END_STATE();
    case 893:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(1224);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'r') ADVANCE(815);
      if (lookahead == '$' ||
          lookahead == '-') ADVANCE(1218);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(921);
      END_STATE();
    case 894:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(1224);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'r') ADVANCE(817);
      if (lookahead == '$' ||
          lookahead == '-') ADVANCE(1218);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(921);
      END_STATE();
    case 895:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(1224);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 's') ADVANCE(862);
      if (lookahead == '$' ||
          lookahead == '-') ADVANCE(1218);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(921);
      END_STATE();
    case 896:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(1224);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 's') ADVANCE(850);
      if (lookahead == '$' ||
          lookahead == '-') ADVANCE(1218);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(921);
      END_STATE();
    case 897:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(1224);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 's') ADVANCE(904);
      if (lookahead == '$' ||
          lookahead == '-') ADVANCE(1218);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(921);
      END_STATE();
    case 898:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(1224);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 't') ADVANCE(663);
      if (lookahead == '$' ||
          lookahead == '-') ADVANCE(1218);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(921);
      END_STATE();
    case 899:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(1224);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 't') ADVANCE(665);
      if (lookahead == '$' ||
          lookahead == '-') ADVANCE(1218);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(921);
      END_STATE();
    case 900:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(1224);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 't') ADVANCE(667);
      if (lookahead == '$' ||
          lookahead == '-') ADVANCE(1218);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(921);
      END_STATE();
    case 901:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(1224);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 't') ADVANCE(669);
      if (lookahead == '$' ||
          lookahead == '-') ADVANCE(1218);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(921);
      END_STATE();
    case 902:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(1224);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 't') ADVANCE(671);
      if (lookahead == '$' ||
          lookahead == '-') ADVANCE(1218);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(921);
      END_STATE();
    case 903:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(1224);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 't') ADVANCE(673);
      if (lookahead == '$' ||
          lookahead == '-') ADVANCE(1218);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(921);
      END_STATE();
    case 904:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(1224);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 't') ADVANCE(646);
      if (lookahead == '$' ||
          lookahead == '-') ADVANCE(1218);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(921);
      END_STATE();
    case 905:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(1224);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 't') ADVANCE(920);
      if (lookahead == '$' ||
          lookahead == '-') ADVANCE(1218);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(921);
      END_STATE();
    case 906:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(1224);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 't') ADVANCE(884);
      if (lookahead == '$' ||
          lookahead == '-') ADVANCE(1218);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(921);
      END_STATE();
    case 907:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(1224);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 't') ADVANCE(856);
      if (lookahead == '$' ||
          lookahead == '-') ADVANCE(1218);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(921);
      END_STATE();
    case 908:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(1224);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'u') ADVANCE(891);
      if (lookahead == '$' ||
          lookahead == '-') ADVANCE(1218);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(921);
      END_STATE();
    case 909:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(1224);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'u') ADVANCE(899);
      if (lookahead == '$' ||
          lookahead == '-') ADVANCE(1218);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(921);
      END_STATE();
    case 910:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(1224);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'u') ADVANCE(849);
      if (lookahead == '$' ||
          lookahead == '-') ADVANCE(1218);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(921);
      END_STATE();
    case 911:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(1224);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'u') ADVANCE(901);
      if (lookahead == '$' ||
          lookahead == '-') ADVANCE(1218);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(921);
      END_STATE();
    case 912:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(1224);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'u') ADVANCE(903);
      if (lookahead == '$' ||
          lookahead == '-') ADVANCE(1218);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(921);
      END_STATE();
    case 913:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(1224);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'u') ADVANCE(907);
      if (lookahead == '$' ||
          lookahead == '-') ADVANCE(1218);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(921);
      END_STATE();
    case 914:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(1224);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'u') ADVANCE(839);
      if (lookahead == '$' ||
          lookahead == '-') ADVANCE(1218);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(921);
      END_STATE();
    case 915:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(1224);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'v') ADVANCE(848);
      if (lookahead == '$' ||
          lookahead == '-') ADVANCE(1218);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(921);
      END_STATE();
    case 916:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(1224);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'v') ADVANCE(885);
      if (lookahead == '$' ||
          lookahead == '-') ADVANCE(1218);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(921);
      END_STATE();
    case 917:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(1224);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'v') ADVANCE(810);
      if (lookahead == '$' ||
          lookahead == '-') ADVANCE(1218);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(921);
      END_STATE();
    case 918:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(1224);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'w') ADVANCE(657);
      if (lookahead == '$' ||
          lookahead == '-') ADVANCE(1218);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(921);
      END_STATE();
    case 919:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(1224);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'x') ADVANCE(847);
      if (lookahead == '$' ||
          lookahead == '-') ADVANCE(1218);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(921);
      END_STATE();
    case 920:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(1224);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'y') ADVANCE(1255);
      if (lookahead == '$' ||
          lookahead == '-') ADVANCE(1218);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(921);
      END_STATE();
    case 921:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(1224);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == '$' ||
          lookahead == '-') ADVANCE(1218);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(921);
      END_STATE();
    case 922:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'N') ADVANCE(1254);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 923:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'a') ADVANCE(922);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 924:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'a') ADVANCE(1044);
      if (lookahead == 'i') ADVANCE(1045);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 925:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'a') ADVANCE(1044);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 926:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'a') ADVANCE(1217);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 927:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'a') ADVANCE(950);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 928:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'a') ADVANCE(1144);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 929:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'a') ADVANCE(1042);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 930:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'a') ADVANCE(1175);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 931:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'a') ADVANCE(1176);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 932:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'a') ADVANCE(1177);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 933:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'a') ADVANCE(1178);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 934:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'a') ADVANCE(1179);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 935:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'a') ADVANCE(1185);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 936:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'b') ADVANCE(1036);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 937:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'b') ADVANCE(823);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 938:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'b') ADVANCE(1049);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 939:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'b') ADVANCE(1050);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 940:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'b') ADVANCE(1051);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 941:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'b') ADVANCE(1052);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 942:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'b') ADVANCE(1053);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 943:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'b') ADVANCE(1037);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 944:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'b') ADVANCE(832);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 945:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'c') ADVANCE(679);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 946:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'c') ADVANCE(678);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 947:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'c') ADVANCE(1038);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 948:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'c') ADVANCE(1039);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 949:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'c') ADVANCE(1196);
      if (lookahead == 'd') ADVANCE(1018);
      if (lookahead == 'i') ADVANCE(1095);
      if (lookahead == 'o') ADVANCE(943);
      if (lookahead == 'p') ADVANCE(1112);
      if (lookahead == 's') ADVANCE(1191);
      if (lookahead == 'v') ADVANCE(1020);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 950:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'c') ADVANCE(979);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 951:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'c') ADVANCE(1180);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 952:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'c') ADVANCE(1181);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 953:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'c') ADVANCE(1190);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 954:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'c') ADVANCE(1202);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 955:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'd') ADVANCE(956);
      if (lookahead == 'g') ADVANCE(980);
      if (lookahead == 'n') ADVANCE(965);
      if (lookahead == 'p') ADVANCE(1193);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 956:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'd') ADVANCE(819);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 957:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'd') ADVANCE(822);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 958:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'd') ADVANCE(1109);
      if (lookahead == 'f') ADVANCE(1048);
      if (lookahead == 'i') ADVANCE(1082);
      if (lookahead == 'l') ADVANCE(1110);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 959:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'd') ADVANCE(971);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 960:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'd') ADVANCE(973);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 961:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'd') ADVANCE(1126);
      if (lookahead == 'f') ADVANCE(1054);
      if (lookahead == 'i') ADVANCE(1085);
      if (lookahead == 'l') ADVANCE(1113);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 962:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'd') ADVANCE(1127);
      if (lookahead == 'f') ADVANCE(1055);
      if (lookahead == 'i') ADVANCE(1086);
      if (lookahead == 'l') ADVANCE(1114);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 963:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'd') ADVANCE(1128);
      if (lookahead == 'f') ADVANCE(1056);
      if (lookahead == 'i') ADVANCE(1087);
      if (lookahead == 'l') ADVANCE(1115);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 964:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'd') ADVANCE(1129);
      if (lookahead == 'f') ADVANCE(1058);
      if (lookahead == 'i') ADVANCE(1090);
      if (lookahead == 'l') ADVANCE(1119);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 965:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'd') ADVANCE(825);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 966:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'e') ADVANCE(1063);
      if (lookahead == 's') ADVANCE(1203);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 967:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'e') ADVANCE(954);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 968:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'e') ADVANCE(633);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 969:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'e') ADVANCE(1265);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 970:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'e') ADVANCE(1267);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 971:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'e') ADVANCE(636);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 972:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'e') ADVANCE(717);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 973:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'e') ADVANCE(651);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 974:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'e') ADVANCE(720);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 975:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'e') ADVANCE(719);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 976:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'e') ADVANCE(721);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 977:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'e') ADVANCE(718);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 978:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'e') ADVANCE(773);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 979:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'e') ADVANCE(677);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 980:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'e') ADVANCE(1155);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 981:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'e') ADVANCE(951);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 982:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'e') ADVANCE(1213);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 983:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'e') ADVANCE(1157);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 984:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'e') ADVANCE(820);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 985:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'e') ADVANCE(1159);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 986:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'e') ADVANCE(1138);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 987:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'e') ADVANCE(1137);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 988:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'e') ADVANCE(952);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 989:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'e') ADVANCE(957);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 990:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'e') ADVANCE(953);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 991:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'e') ADVANCE(824);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 992:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'f') ADVANCE(1014);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 993:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'f') ADVANCE(927);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 994:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'g') ADVANCE(707);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 995:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'g') ADVANCE(701);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 996:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'g') ADVANCE(706);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 997:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'g') ADVANCE(704);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 998:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'g') ADVANCE(703);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 999:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'g') ADVANCE(705);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1000:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'g') ADVANCE(709);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1001:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'g') ADVANCE(710);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1002:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'g') ADVANCE(702);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1003:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'g') ADVANCE(708);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1004:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'g') ADVANCE(711);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1005:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'g') ADVANCE(653);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1006:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'g') ADVANCE(983);
      if (lookahead == 'n') ADVANCE(1210);
      if (lookahead == 'p') ADVANCE(1198);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1007:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'g') ADVANCE(985);
      if (lookahead == 'h') ADVANCE(1060);
      if (lookahead == 'p') ADVANCE(1200);
      if (lookahead == 'u') ADVANCE(944);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1008:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'h') ADVANCE(1143);
      if (lookahead == 'r') ADVANCE(1197);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1009:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'h') ADVANCE(1143);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1010:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'h') ADVANCE(1021);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1011:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'h') ADVANCE(1149);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1012:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'i') ADVANCE(1211);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1013:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'i') ADVANCE(959);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1014:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'i') ADVANCE(1069);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1015:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'i') ADVANCE(1045);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1016:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'i') ADVANCE(1079);
      if (lookahead == 'l') ADVANCE(1108);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1017:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'i') ADVANCE(945);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1018:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'i') ADVANCE(1146);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1019:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'i') ADVANCE(947);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1020:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'i') ADVANCE(1145);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1021:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'i') ADVANCE(946);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1022:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'i') ADVANCE(948);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1023:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'i') ADVANCE(1163);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1024:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'i') ADVANCE(1075);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1025:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'i') ADVANCE(1083);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1026:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'i') ADVANCE(1091);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1027:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'i') ADVANCE(1182);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1028:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'i') ADVANCE(960);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1029:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'i') ADVANCE(1084);
      if (lookahead == 'l') ADVANCE(1111);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1030:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'i') ADVANCE(1088);
      if (lookahead == 'l') ADVANCE(1117);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1031:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'i') ADVANCE(1089);
      if (lookahead == 'l') ADVANCE(1118);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1032:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'i') ADVANCE(1092);
      if (lookahead == 'l') ADVANCE(1120);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1033:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'i') ADVANCE(1093);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1034:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'i') ADVANCE(1094);
      if (lookahead == 'l') ADVANCE(1121);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1035:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'i') ADVANCE(1096);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1036:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'j') ADVANCE(981);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1037:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'j') ADVANCE(990);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1038:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'k') ADVANCE(777);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1039:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'k') ADVANCE(775);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1040:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'k') ADVANCE(984);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1041:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'l') ADVANCE(1273);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1042:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'l') ADVANCE(681);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1043:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'l') ADVANCE(1216);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1044:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'l') ADVANCE(1151);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1045:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'l') ADVANCE(1047);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1046:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'l') ADVANCE(1041);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1047:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'l') ADVANCE(989);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1048:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'l') ADVANCE(1104);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1049:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'l') ADVANCE(972);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1050:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'l') ADVANCE(974);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1051:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'l') ADVANCE(975);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1052:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'l') ADVANCE(976);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1053:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'l') ADVANCE(977);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1054:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'l') ADVANCE(1122);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1055:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'l') ADVANCE(1123);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1056:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'l') ADVANCE(1124);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1057:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'l') ADVANCE(1026);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1058:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'l') ADVANCE(1125);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1059:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'l') ADVANCE(828);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1060:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'l') ADVANCE(827);
      if (lookahead == 'r') ADVANCE(829);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1061:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'm') ADVANCE(675);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1062:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'm') ADVANCE(1116);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1063:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'm') ADVANCE(830);
      if (lookahead == 't') ADVANCE(1192);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1064:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'n') ADVANCE(992);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1065:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'n') ADVANCE(994);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1066:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'n') ADVANCE(643);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1067:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'n') ADVANCE(1152);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1068:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'n') ADVANCE(995);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1069:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'n') ADVANCE(1023);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1070:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'n') ADVANCE(996);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1071:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'n') ADVANCE(997);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1072:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'n') ADVANCE(998);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1073:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'n') ADVANCE(999);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1074:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'n') ADVANCE(1000);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1075:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'n') ADVANCE(1057);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1076:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'n') ADVANCE(1001);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1077:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'n') ADVANCE(982);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1078:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'n') ADVANCE(1002);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1079:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'n') ADVANCE(1162);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1080:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'n') ADVANCE(1003);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1081:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'n') ADVANCE(1004);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1082:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'n') ADVANCE(1164);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1083:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'n') ADVANCE(1005);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1084:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'n') ADVANCE(1165);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1085:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'n') ADVANCE(1166);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1086:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'n') ADVANCE(1167);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1087:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'n') ADVANCE(1168);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1088:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'n') ADVANCE(1169);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1089:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'n') ADVANCE(1170);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1090:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'n') ADVANCE(1171);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1091:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'n') ADVANCE(978);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1092:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'n') ADVANCE(1172);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1093:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'n') ADVANCE(1173);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1094:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'n') ADVANCE(1174);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1095:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'n') ADVANCE(1189);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1096:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'n') ADVANCE(1027);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1097:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'o') ADVANCE(1067);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1098:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'o') ADVANCE(1183);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1099:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'o') ADVANCE(1131);
      if (lookahead == 'u') ADVANCE(1046);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1100:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'o') ADVANCE(1131);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1101:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'o') ADVANCE(660);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1102:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'o') ADVANCE(1040);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1103:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'o') ADVANCE(1212);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1104:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'o') ADVANCE(930);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1105:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'o') ADVANCE(936);
      if (lookahead == 'w') ADVANCE(1013);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1106:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'o') ADVANCE(1061);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1107:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'o') ADVANCE(1209);
      if (lookahead == 'u') ADVANCE(1059);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1108:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'o') ADVANCE(1065);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1109:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'o') ADVANCE(1194);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1110:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'o') ADVANCE(1068);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1111:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'o') ADVANCE(1070);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1112:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'o') ADVANCE(1043);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1113:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'o') ADVANCE(1071);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1114:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'o') ADVANCE(1072);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1115:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'o') ADVANCE(1073);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1116:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'o') ADVANCE(1140);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1117:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'o') ADVANCE(1074);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1118:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'o') ADVANCE(1076);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1119:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'o') ADVANCE(1078);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1120:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'o') ADVANCE(1080);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1121:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'o') ADVANCE(1081);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1122:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'o') ADVANCE(931);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1123:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'o') ADVANCE(932);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1124:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'o') ADVANCE(933);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1125:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'o') ADVANCE(934);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1126:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'o') ADVANCE(1205);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1127:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'o') ADVANCE(1206);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1128:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'o') ADVANCE(1207);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1129:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'o') ADVANCE(1208);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1130:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'o') ADVANCE(1148);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1131:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'p') ADVANCE(631);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1132:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'p') ADVANCE(1010);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1133:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'p') ADVANCE(987);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1134:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'q') ADVANCE(1199);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1135:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'q') ADVANCE(1201);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1136:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'r') ADVANCE(818);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1137:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'r') ADVANCE(680);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1138:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'r') ADVANCE(993);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1139:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'r') ADVANCE(1197);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1140:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'r') ADVANCE(1132);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1141:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'r') ADVANCE(1066);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1142:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'r') ADVANCE(926);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1143:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'r') ADVANCE(1103);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1144:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'r') ADVANCE(1142);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1145:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'r') ADVANCE(1186);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1146:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'r') ADVANCE(988);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1147:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'r') ADVANCE(1025);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1148:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'r') ADVANCE(831);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1149:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'r') ADVANCE(833);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1150:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 's') ADVANCE(1011);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1151:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 's') ADVANCE(970);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1152:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 's') ADVANCE(1161);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1153:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 's') ADVANCE(1184);
      if (lookahead == 'w') ADVANCE(1028);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1154:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 's') ADVANCE(1188);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1155:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 't') ADVANCE(664);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1156:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 't') ADVANCE(666);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1157:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 't') ADVANCE(668);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1158:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 't') ADVANCE(670);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1159:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 't') ADVANCE(672);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1160:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 't') ADVANCE(674);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1161:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 't') ADVANCE(647);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1162:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 't') ADVANCE(696);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1163:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 't') ADVANCE(1215);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1164:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 't') ADVANCE(690);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1165:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 't') ADVANCE(695);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1166:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 't') ADVANCE(693);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1167:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 't') ADVANCE(692);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1168:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 't') ADVANCE(694);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1169:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 't') ADVANCE(698);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1170:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 't') ADVANCE(699);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1171:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 't') ADVANCE(691);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1172:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 't') ADVANCE(697);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1173:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 't') ADVANCE(779);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1174:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 't') ADVANCE(700);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1175:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 't') ADVANCE(712);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1176:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 't') ADVANCE(715);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1177:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 't') ADVANCE(714);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1178:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 't') ADVANCE(716);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1179:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 't') ADVANCE(713);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1180:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 't') ADVANCE(639);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1181:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 't') ADVANCE(676);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1182:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 't') ADVANCE(835);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1183:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 't') ADVANCE(1101);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1184:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 't') ADVANCE(1147);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1185:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 't') ADVANCE(1017);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1186:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 't') ADVANCE(1195);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1187:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 't') ADVANCE(991);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1188:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 't') ADVANCE(1106);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1189:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 't') ADVANCE(986);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1190:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 't') ADVANCE(834);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1191:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 't') ADVANCE(935);
      if (lookahead == 'u') ADVANCE(1133);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1192:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'u') ADVANCE(1141);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1193:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'u') ADVANCE(1156);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1194:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'u') ADVANCE(938);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1195:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'u') ADVANCE(929);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1196:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'u') ADVANCE(1154);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1197:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'u') ADVANCE(969);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1198:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'u') ADVANCE(1158);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1199:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'u') ADVANCE(1019);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1200:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'u') ADVANCE(1160);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1201:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'u') ADVANCE(1022);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1202:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'u') ADVANCE(1187);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1203:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'u') ADVANCE(937);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1204:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'u') ADVANCE(1046);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1205:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'u') ADVANCE(939);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1206:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'u') ADVANCE(940);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1207:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'u') ADVANCE(941);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1208:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'u') ADVANCE(942);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1209:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'v') ADVANCE(968);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1210:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'v') ADVANCE(1102);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1211:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'v') ADVANCE(826);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1212:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'w') ADVANCE(658);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1213:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'w') ADVANCE(821);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1214:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'x') ADVANCE(967);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1215:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'y') ADVANCE(1255);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1216:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'y') ADVANCE(1062);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1217:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == 'y') ADVANCE(655);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1218:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1219:
      ACCEPT_TOKEN(anon_sym_SLASH);
      END_STATE();
    case 1220:
      ACCEPT_TOKEN(anon_sym_SEMI);
      END_STATE();
    case 1221:
      ACCEPT_TOKEN(aux_sym_label_token1);
      if (lookahead == 'I') ADVANCE(1222);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1222);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != ':') ADVANCE(1222);
      END_STATE();
    case 1222:
      ACCEPT_TOKEN(aux_sym_label_token1);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1222);
      END_STATE();
    case 1223:
      ACCEPT_TOKEN(aux_sym_label_token1);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != ':' &&
          lookahead != 'I') ADVANCE(1222);
      END_STATE();
    case 1224:
      ACCEPT_TOKEN(aux_sym_jmp_label_token1);
      END_STATE();
    case 1225:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '.') ADVANCE(597);
      if (lookahead == '0') ADVANCE(1237);
      if (lookahead == '>') ADVANCE(796);
      if (lookahead == 'I') ADVANCE(407);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1240);
      END_STATE();
    case 1226:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '.') ADVANCE(597);
      if (lookahead == '0') ADVANCE(1237);
      if (lookahead == 'I') ADVANCE(407);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1240);
      END_STATE();
    case 1227:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '0') ADVANCE(1241);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1247);
      END_STATE();
    case 1228:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 1229:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 1230:
      ACCEPT_TOKEN(anon_sym_AT);
      END_STATE();
    case 1231:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 1232:
      ACCEPT_TOKEN(aux_sym_primitive_type_token2);
      END_STATE();
    case 1233:
      ACCEPT_TOKEN(aux_sym_primitive_type_token2);
      if (lookahead == 'n') ADVANCE(992);
      END_STATE();
    case 1234:
      ACCEPT_TOKEN(aux_sym_primitive_type_token2);
      if (lookahead == 'n') ADVANCE(857);
      END_STATE();
    case 1235:
      ACCEPT_TOKEN(anon_sym_DOTenum);
      END_STATE();
    case 1236:
      ACCEPT_TOKEN(sym_number);
      END_STATE();
    case 1237:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '.') ADVANCE(597);
      if (lookahead == '0') ADVANCE(1240);
      if (lookahead == '_') ADVANCE(596);
      if (lookahead == 'f') ADVANCE(1248);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(595);
      if (lookahead == 'X' ||
          lookahead == 'x') ADVANCE(600);
      if (lookahead == 'L' ||
          lookahead == 'S' ||
          lookahead == 'T' ||
          lookahead == 'l' ||
          lookahead == 's' ||
          lookahead == 't') ADVANCE(1236);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1240);
      END_STATE();
    case 1238:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '.') ADVANCE(597);
      if (lookahead == '0') ADVANCE(1239);
      if (lookahead == ':') ADVANCE(1224);
      if (lookahead == '_') ADVANCE(108);
      if (lookahead == 'f') ADVANCE(1250);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(107);
      if (lookahead == 'X' ||
          lookahead == 'x') ADVANCE(109);
      if (lookahead == 'L' ||
          lookahead == 'S' ||
          lookahead == 'T' ||
          lookahead == 'l' ||
          lookahead == 's' ||
          lookahead == 't') ADVANCE(1244);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1239);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 1239:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '.') ADVANCE(597);
      if (lookahead == ':') ADVANCE(1224);
      if (lookahead == '_') ADVANCE(108);
      if (lookahead == 'f') ADVANCE(1250);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(107);
      if (lookahead == 'L' ||
          lookahead == 'S' ||
          lookahead == 'T' ||
          lookahead == 'l' ||
          lookahead == 's' ||
          lookahead == 't') ADVANCE(1244);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1239);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 1240:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '.') ADVANCE(597);
      if (lookahead == '_') ADVANCE(596);
      if (lookahead == 'f') ADVANCE(1248);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(595);
      if (lookahead == 'L' ||
          lookahead == 'S' ||
          lookahead == 'T' ||
          lookahead == 'l' ||
          lookahead == 's' ||
          lookahead == 't') ADVANCE(1236);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1240);
      END_STATE();
    case 1241:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '0') ADVANCE(1247);
      if (lookahead == '_') ADVANCE(596);
      if (lookahead == 'X' ||
          lookahead == 'x') ADVANCE(600);
      if (lookahead == 'L' ||
          lookahead == 'S' ||
          lookahead == 'T' ||
          lookahead == 'l' ||
          lookahead == 's' ||
          lookahead == 't') ADVANCE(1236);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1247);
      END_STATE();
    case 1242:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == ':') ADVANCE(1224);
      if (lookahead == '_') ADVANCE(108);
      if (lookahead == 'L' ||
          lookahead == 'S' ||
          lookahead == 'T' ||
          lookahead == 'l' ||
          lookahead == 's' ||
          lookahead == 't') ADVANCE(1244);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1242);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 1243:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == ':') ADVANCE(1224);
      if (lookahead == '_') ADVANCE(109);
      if (lookahead == 'L' ||
          lookahead == 'S' ||
          lookahead == 'T' ||
          lookahead == 'l' ||
          lookahead == 's' ||
          lookahead == 't') ADVANCE(1244);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(1243);
      if (('G' <= lookahead && lookahead <= 'Z') ||
          ('g' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 1244:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == ':') ADVANCE(1224);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 1245:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '_') ADVANCE(600);
      if (lookahead == 'L' ||
          lookahead == 'S' ||
          lookahead == 'T' ||
          lookahead == 'l' ||
          lookahead == 's' ||
          lookahead == 't') ADVANCE(1236);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(1245);
      END_STATE();
    case 1246:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '_') ADVANCE(596);
      if (lookahead == 'X' ||
          lookahead == 'x') ADVANCE(600);
      if (lookahead == 'L' ||
          lookahead == 'S' ||
          lookahead == 'T' ||
          lookahead == 'l' ||
          lookahead == 's' ||
          lookahead == 't') ADVANCE(1236);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1247);
      END_STATE();
    case 1247:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '_') ADVANCE(596);
      if (lookahead == 'L' ||
          lookahead == 'S' ||
          lookahead == 'T' ||
          lookahead == 'l' ||
          lookahead == 's' ||
          lookahead == 't') ADVANCE(1236);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1247);
      END_STATE();
    case 1248:
      ACCEPT_TOKEN(sym_float);
      END_STATE();
    case 1249:
      ACCEPT_TOKEN(sym_float);
      if (lookahead == ':') ADVANCE(1224);
      if (lookahead == 'f') ADVANCE(1250);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 1250:
      ACCEPT_TOKEN(sym_float);
      if (lookahead == ':') ADVANCE(1224);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 1251:
      ACCEPT_TOKEN(sym_float);
      if (lookahead == 'f') ADVANCE(1248);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(595);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1251);
      END_STATE();
    case 1252:
      ACCEPT_TOKEN(sym_float);
      if (lookahead == 'f') ADVANCE(1248);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1252);
      END_STATE();
    case 1253:
      ACCEPT_TOKEN(sym_NaN);
      END_STATE();
    case 1254:
      ACCEPT_TOKEN(sym_NaN);
      if (lookahead == 'f') ADVANCE(1253);
      END_STATE();
    case 1255:
      ACCEPT_TOKEN(sym_Infinity);
      END_STATE();
    case 1256:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      END_STATE();
    case 1257:
      ACCEPT_TOKEN(sym_string_fragment);
      if (lookahead == '\n') ADVANCE(1259);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(1257);
      END_STATE();
    case 1258:
      ACCEPT_TOKEN(sym_string_fragment);
      if (lookahead == '#') ADVANCE(1257);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(1258);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(1259);
      END_STATE();
    case 1259:
      ACCEPT_TOKEN(sym_string_fragment);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(1259);
      END_STATE();
    case 1260:
      ACCEPT_TOKEN(aux_sym__escape_sequence_token1);
      END_STATE();
    case 1261:
      ACCEPT_TOKEN(aux_sym__escape_sequence_token1);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(1263);
      END_STATE();
    case 1262:
      ACCEPT_TOKEN(sym_escape_sequence);
      END_STATE();
    case 1263:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(1262);
      END_STATE();
    case 1264:
      ACCEPT_TOKEN(anon_sym_true);
      if (lookahead == ':') ADVANCE(1224);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == '$' ||
          lookahead == '-') ADVANCE(1218);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(921);
      END_STATE();
    case 1265:
      ACCEPT_TOKEN(anon_sym_true);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1266:
      ACCEPT_TOKEN(anon_sym_false);
      if (lookahead == ':') ADVANCE(1224);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == '$' ||
          lookahead == '-') ADVANCE(1218);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(921);
      END_STATE();
    case 1267:
      ACCEPT_TOKEN(anon_sym_false);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1268:
      ACCEPT_TOKEN(anon_sym_SQUOTE);
      END_STATE();
    case 1269:
      ACCEPT_TOKEN(aux_sym_character_token1);
      END_STATE();
    case 1270:
      ACCEPT_TOKEN(aux_sym_character_token1);
      if (lookahead == '#') ADVANCE(1271);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(1270);
      if (lookahead != 0 &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(1269);
      END_STATE();
    case 1271:
      ACCEPT_TOKEN(aux_sym_character_token1);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(1274);
      END_STATE();
    case 1272:
      ACCEPT_TOKEN(sym_null);
      if (lookahead == ':') ADVANCE(1224);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == '$' ||
          lookahead == '-') ADVANCE(1218);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(921);
      END_STATE();
    case 1273:
      ACCEPT_TOKEN(sym_null);
      if (lookahead == '>') ADVANCE(802);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1218);
      END_STATE();
    case 1274:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(1274);
      END_STATE();
    default:
      return false;
  }
}

static bool ts_lex_keywords(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (lookahead == 'a') ADVANCE(1);
      if (lookahead == 'b') ADVANCE(2);
      if (lookahead == 'c') ADVANCE(3);
      if (lookahead == 'd') ADVANCE(4);
      if (lookahead == 'e') ADVANCE(5);
      if (lookahead == 'f') ADVANCE(6);
      if (lookahead == 'g') ADVANCE(7);
      if (lookahead == 'i') ADVANCE(8);
      if (lookahead == 'l') ADVANCE(9);
      if (lookahead == 'm') ADVANCE(10);
      if (lookahead == 'n') ADVANCE(11);
      if (lookahead == 'p') ADVANCE(12);
      if (lookahead == 'r') ADVANCE(13);
      if (lookahead == 's') ADVANCE(14);
      if (lookahead == 't') ADVANCE(15);
      if (lookahead == 'v') ADVANCE(16);
      if (lookahead == 'w') ADVANCE(17);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(18)
      END_STATE();
    case 1:
      if (lookahead == 'b') ADVANCE(19);
      if (lookahead == 'g') ADVANCE(20);
      if (lookahead == 'n') ADVANCE(21);
      if (lookahead == 'p') ADVANCE(22);
      if (lookahead == 'r') ADVANCE(23);
      END_STATE();
    case 2:
      if (lookahead == 'l') ADVANCE(24);
      if (lookahead == 'r') ADVANCE(25);
      if (lookahead == 'u') ADVANCE(26);
      END_STATE();
    case 3:
      if (lookahead == 'h') ADVANCE(27);
      if (lookahead == 'm') ADVANCE(28);
      if (lookahead == 'o') ADVANCE(29);
      END_STATE();
    case 4:
      if (lookahead == 'e') ADVANCE(30);
      if (lookahead == 'o') ADVANCE(31);
      END_STATE();
    case 5:
      if (lookahead == 'n') ADVANCE(32);
      END_STATE();
    case 6:
      if (lookahead == 'i') ADVANCE(33);
      if (lookahead == 'l') ADVANCE(34);
      END_STATE();
    case 7:
      if (lookahead == 'r') ADVANCE(35);
      END_STATE();
    case 8:
      if (lookahead == 'f') ADVANCE(36);
      if (lookahead == 'g') ADVANCE(37);
      if (lookahead == 'n') ADVANCE(38);
      if (lookahead == 'p') ADVANCE(39);
      END_STATE();
    case 9:
      if (lookahead == 'o') ADVANCE(40);
      END_STATE();
    case 10:
      if (lookahead == 'o') ADVANCE(41);
      END_STATE();
    case 11:
      if (lookahead == 'a') ADVANCE(42);
      if (lookahead == 'e') ADVANCE(43);
      if (lookahead == 'o') ADVANCE(44);
      END_STATE();
    case 12:
      if (lookahead == 'a') ADVANCE(45);
      if (lookahead == 'r') ADVANCE(46);
      if (lookahead == 'u') ADVANCE(47);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(48);
      END_STATE();
    case 13:
      if (lookahead == 'e') ADVANCE(49);
      if (lookahead == 'u') ADVANCE(50);
      END_STATE();
    case 14:
      if (lookahead == 'g') ADVANCE(51);
      if (lookahead == 'p') ADVANCE(52);
      if (lookahead == 't') ADVANCE(53);
      if (lookahead == 'y') ADVANCE(54);
      END_STATE();
    case 15:
      if (lookahead == 'e') ADVANCE(55);
      if (lookahead == 'h') ADVANCE(56);
      if (lookahead == 'r') ADVANCE(57);
      END_STATE();
    case 16:
      if (lookahead == 'a') ADVANCE(58);
      if (lookahead == 'o') ADVANCE(59);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(60);
      END_STATE();
    case 17:
      if (lookahead == 'h') ADVANCE(61);
      END_STATE();
    case 18:
      if (lookahead == 'a') ADVANCE(1);
      if (lookahead == 'b') ADVANCE(2);
      if (lookahead == 'c') ADVANCE(3);
      if (lookahead == 'd') ADVANCE(4);
      if (lookahead == 'e') ADVANCE(5);
      if (lookahead == 'f') ADVANCE(6);
      if (lookahead == 'g') ADVANCE(7);
      if (lookahead == 'i') ADVANCE(8);
      if (lookahead == 'l') ADVANCE(9);
      if (lookahead == 'm') ADVANCE(10);
      if (lookahead == 'n') ADVANCE(11);
      if (lookahead == 'p') ADVANCE(62);
      if (lookahead == 'r') ADVANCE(13);
      if (lookahead == 's') ADVANCE(14);
      if (lookahead == 't') ADVANCE(15);
      if (lookahead == 'v') ADVANCE(63);
      if (lookahead == 'w') ADVANCE(17);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(18)
      END_STATE();
    case 19:
      if (lookahead == 's') ADVANCE(64);
      END_STATE();
    case 20:
      if (lookahead == 'e') ADVANCE(65);
      END_STATE();
    case 21:
      if (lookahead == 'n') ADVANCE(66);
      END_STATE();
    case 22:
      if (lookahead == 'u') ADVANCE(67);
      END_STATE();
    case 23:
      if (lookahead == 'r') ADVANCE(68);
      END_STATE();
    case 24:
      if (lookahead == 'a') ADVANCE(69);
      END_STATE();
    case 25:
      if (lookahead == 'i') ADVANCE(70);
      END_STATE();
    case 26:
      if (lookahead == 'i') ADVANCE(71);
      END_STATE();
    case 27:
      if (lookahead == 'e') ADVANCE(72);
      END_STATE();
    case 28:
      if (lookahead == 'p') ADVANCE(73);
      END_STATE();
    case 29:
      if (lookahead == 'n') ADVANCE(74);
      if (lookahead == 'r') ADVANCE(75);
      END_STATE();
    case 30:
      if (lookahead == 'c') ADVANCE(76);
      END_STATE();
    case 31:
      if (lookahead == 'u') ADVANCE(77);
      END_STATE();
    case 32:
      if (lookahead == 'u') ADVANCE(78);
      END_STATE();
    case 33:
      if (lookahead == 'l') ADVANCE(79);
      if (lookahead == 'n') ADVANCE(80);
      END_STATE();
    case 34:
      if (lookahead == 'o') ADVANCE(81);
      END_STATE();
    case 35:
      if (lookahead == 'e') ADVANCE(82);
      END_STATE();
    case 36:
      if (lookahead == '-') ADVANCE(83);
      END_STATE();
    case 37:
      if (lookahead == 'e') ADVANCE(84);
      END_STATE();
    case 38:
      if (lookahead == 's') ADVANCE(85);
      if (lookahead == 't') ADVANCE(86);
      if (lookahead == 'v') ADVANCE(87);
      END_STATE();
    case 39:
      if (lookahead == 'u') ADVANCE(88);
      END_STATE();
    case 40:
      if (lookahead == 'n') ADVANCE(89);
      END_STATE();
    case 41:
      if (lookahead == 'n') ADVANCE(90);
      if (lookahead == 'v') ADVANCE(91);
      END_STATE();
    case 42:
      if (lookahead == 't') ADVANCE(92);
      END_STATE();
    case 43:
      if (lookahead == 'g') ADVANCE(93);
      if (lookahead == 'w') ADVANCE(94);
      END_STATE();
    case 44:
      if (lookahead == 't') ADVANCE(95);
      END_STATE();
    case 45:
      if (lookahead == 'c') ADVANCE(96);
      END_STATE();
    case 46:
      if (lookahead == 'i') ADVANCE(97);
      if (lookahead == 'o') ADVANCE(98);
      END_STATE();
    case 47:
      if (lookahead == 'b') ADVANCE(99);
      END_STATE();
    case 48:
      ACCEPT_TOKEN(sym_parameter);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(48);
      END_STATE();
    case 49:
      if (lookahead == 't') ADVANCE(100);
      END_STATE();
    case 50:
      if (lookahead == 'n') ADVANCE(101);
      END_STATE();
    case 51:
      if (lookahead == 'e') ADVANCE(102);
      END_STATE();
    case 52:
      if (lookahead == 'a') ADVANCE(103);
      if (lookahead == 'u') ADVANCE(104);
      END_STATE();
    case 53:
      if (lookahead == 'a') ADVANCE(105);
      if (lookahead == 'r') ADVANCE(106);
      END_STATE();
    case 54:
      if (lookahead == 'n') ADVANCE(107);
      if (lookahead == 's') ADVANCE(108);
      END_STATE();
    case 55:
      if (lookahead == 's') ADVANCE(109);
      END_STATE();
    case 56:
      if (lookahead == 'r') ADVANCE(110);
      END_STATE();
    case 57:
      if (lookahead == 'a') ADVANCE(111);
      END_STATE();
    case 58:
      if (lookahead == 'r') ADVANCE(112);
      END_STATE();
    case 59:
      if (lookahead == 'l') ADVANCE(113);
      END_STATE();
    case 60:
      ACCEPT_TOKEN(sym_variable);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(60);
      END_STATE();
    case 61:
      if (lookahead == 'i') ADVANCE(114);
      END_STATE();
    case 62:
      if (lookahead == 'a') ADVANCE(45);
      if (lookahead == 'r') ADVANCE(46);
      if (lookahead == 'u') ADVANCE(47);
      END_STATE();
    case 63:
      if (lookahead == 'a') ADVANCE(58);
      if (lookahead == 'o') ADVANCE(59);
      END_STATE();
    case 64:
      if (lookahead == 't') ADVANCE(115);
      END_STATE();
    case 65:
      if (lookahead == 't') ADVANCE(116);
      END_STATE();
    case 66:
      if (lookahead == 'o') ADVANCE(117);
      END_STATE();
    case 67:
      if (lookahead == 't') ADVANCE(118);
      END_STATE();
    case 68:
      if (lookahead == 'a') ADVANCE(119);
      END_STATE();
    case 69:
      if (lookahead == 'c') ADVANCE(120);
      END_STATE();
    case 70:
      if (lookahead == 'd') ADVANCE(121);
      END_STATE();
    case 71:
      if (lookahead == 'l') ADVANCE(122);
      END_STATE();
    case 72:
      if (lookahead == 'c') ADVANCE(123);
      END_STATE();
    case 73:
      if (lookahead == '-') ADVANCE(124);
      if (lookahead == 'g') ADVANCE(125);
      if (lookahead == 'l') ADVANCE(126);
      END_STATE();
    case 74:
      if (lookahead == 's') ADVANCE(127);
      END_STATE();
    case 75:
      if (lookahead == 'e') ADVANCE(128);
      END_STATE();
    case 76:
      if (lookahead == 'l') ADVANCE(129);
      END_STATE();
    case 77:
      if (lookahead == 'b') ADVANCE(130);
      END_STATE();
    case 78:
      if (lookahead == 'm') ADVANCE(131);
      END_STATE();
    case 79:
      if (lookahead == 'l') ADVANCE(132);
      END_STATE();
    case 80:
      if (lookahead == 'a') ADVANCE(133);
      END_STATE();
    case 81:
      if (lookahead == 'a') ADVANCE(134);
      END_STATE();
    case 82:
      if (lookahead == 'y') ADVANCE(135);
      END_STATE();
    case 83:
      if (lookahead == 'e') ADVANCE(136);
      if (lookahead == 'g') ADVANCE(137);
      if (lookahead == 'l') ADVANCE(138);
      if (lookahead == 'n') ADVANCE(139);
      END_STATE();
    case 84:
      if (lookahead == 't') ADVANCE(140);
      END_STATE();
    case 85:
      if (lookahead == 't') ADVANCE(141);
      END_STATE();
    case 86:
      if (lookahead == '-') ADVANCE(142);
      if (lookahead == 'e') ADVANCE(143);
      END_STATE();
    case 87:
      if (lookahead == 'o') ADVANCE(144);
      END_STATE();
    case 88:
      if (lookahead == 't') ADVANCE(145);
      END_STATE();
    case 89:
      if (lookahead == 'g') ADVANCE(146);
      END_STATE();
    case 90:
      if (lookahead == 'i') ADVANCE(147);
      END_STATE();
    case 91:
      if (lookahead == 'e') ADVANCE(148);
      END_STATE();
    case 92:
      if (lookahead == 'i') ADVANCE(149);
      END_STATE();
    case 93:
      if (lookahead == '-') ADVANCE(150);
      END_STATE();
    case 94:
      if (lookahead == '-') ADVANCE(151);
      END_STATE();
    case 95:
      if (lookahead == '-') ADVANCE(152);
      END_STATE();
    case 96:
      if (lookahead == 'k') ADVANCE(153);
      END_STATE();
    case 97:
      if (lookahead == 'v') ADVANCE(154);
      END_STATE();
    case 98:
      if (lookahead == 't') ADVANCE(155);
      END_STATE();
    case 99:
      if (lookahead == 'l') ADVANCE(156);
      END_STATE();
    case 100:
      if (lookahead == 'u') ADVANCE(157);
      END_STATE();
    case 101:
      if (lookahead == 't') ADVANCE(158);
      END_STATE();
    case 102:
      if (lookahead == 't') ADVANCE(159);
      END_STATE();
    case 103:
      if (lookahead == 'r') ADVANCE(160);
      END_STATE();
    case 104:
      if (lookahead == 't') ADVANCE(161);
      END_STATE();
    case 105:
      if (lookahead == 't') ADVANCE(162);
      END_STATE();
    case 106:
      if (lookahead == 'i') ADVANCE(163);
      END_STATE();
    case 107:
      if (lookahead == 'c') ADVANCE(164);
      if (lookahead == 't') ADVANCE(165);
      END_STATE();
    case 108:
      if (lookahead == 't') ADVANCE(166);
      END_STATE();
    case 109:
      if (lookahead == 't') ADVANCE(167);
      END_STATE();
    case 110:
      if (lookahead == 'o') ADVANCE(168);
      END_STATE();
    case 111:
      if (lookahead == 'n') ADVANCE(169);
      END_STATE();
    case 112:
      if (lookahead == 'a') ADVANCE(170);
      END_STATE();
    case 113:
      if (lookahead == 'a') ADVANCE(171);
      END_STATE();
    case 114:
      if (lookahead == 't') ADVANCE(172);
      END_STATE();
    case 115:
      if (lookahead == 'r') ADVANCE(173);
      END_STATE();
    case 116:
      if (lookahead == '-') ADVANCE(174);
      END_STATE();
    case 117:
      if (lookahead == 't') ADVANCE(175);
      END_STATE();
    case 118:
      if (lookahead == '-') ADVANCE(176);
      END_STATE();
    case 119:
      if (lookahead == 'y') ADVANCE(177);
      END_STATE();
    case 120:
      if (lookahead == 'k') ADVANCE(178);
      END_STATE();
    case 121:
      if (lookahead == 'g') ADVANCE(179);
      END_STATE();
    case 122:
      if (lookahead == 'd') ADVANCE(180);
      END_STATE();
    case 123:
      if (lookahead == 'k') ADVANCE(181);
      END_STATE();
    case 124:
      if (lookahead == 'l') ADVANCE(182);
      END_STATE();
    case 125:
      if (lookahead == '-') ADVANCE(183);
      END_STATE();
    case 126:
      if (lookahead == '-') ADVANCE(184);
      END_STATE();
    case 127:
      if (lookahead == 't') ADVANCE(185);
      END_STATE();
    case 128:
      if (lookahead == '-') ADVANCE(186);
      END_STATE();
    case 129:
      if (lookahead == 'a') ADVANCE(187);
      END_STATE();
    case 130:
      if (lookahead == 'l') ADVANCE(188);
      END_STATE();
    case 131:
      ACCEPT_TOKEN(anon_sym_enum);
      END_STATE();
    case 132:
      if (lookahead == '-') ADVANCE(189);
      END_STATE();
    case 133:
      if (lookahead == 'l') ADVANCE(190);
      END_STATE();
    case 134:
      if (lookahead == 't') ADVANCE(191);
      END_STATE();
    case 135:
      if (lookahead == 'l') ADVANCE(192);
      END_STATE();
    case 136:
      if (lookahead == 'q') ADVANCE(193);
      END_STATE();
    case 137:
      if (lookahead == 'e') ADVANCE(194);
      if (lookahead == 't') ADVANCE(195);
      END_STATE();
    case 138:
      if (lookahead == 'e') ADVANCE(196);
      if (lookahead == 't') ADVANCE(197);
      END_STATE();
    case 139:
      if (lookahead == 'e') ADVANCE(198);
      END_STATE();
    case 140:
      if (lookahead == '-') ADVANCE(199);
      END_STATE();
    case 141:
      if (lookahead == 'a') ADVANCE(200);
      END_STATE();
    case 142:
      if (lookahead == 't') ADVANCE(201);
      END_STATE();
    case 143:
      if (lookahead == 'r') ADVANCE(202);
      END_STATE();
    case 144:
      if (lookahead == 'k') ADVANCE(203);
      END_STATE();
    case 145:
      if (lookahead == '-') ADVANCE(204);
      END_STATE();
    case 146:
      if (lookahead == '-') ADVANCE(205);
      END_STATE();
    case 147:
      if (lookahead == 't') ADVANCE(206);
      END_STATE();
    case 148:
      if (lookahead == '-') ADVANCE(207);
      END_STATE();
    case 149:
      if (lookahead == 'v') ADVANCE(208);
      END_STATE();
    case 150:
      if (lookahead == 'd') ADVANCE(209);
      if (lookahead == 'f') ADVANCE(210);
      if (lookahead == 'i') ADVANCE(211);
      if (lookahead == 'l') ADVANCE(212);
      END_STATE();
    case 151:
      if (lookahead == 'a') ADVANCE(213);
      if (lookahead == 'i') ADVANCE(214);
      END_STATE();
    case 152:
      if (lookahead == 'i') ADVANCE(215);
      if (lookahead == 'l') ADVANCE(216);
      END_STATE();
    case 153:
      if (lookahead == 'e') ADVANCE(217);
      END_STATE();
    case 154:
      if (lookahead == 'a') ADVANCE(218);
      END_STATE();
    case 155:
      if (lookahead == 'e') ADVANCE(219);
      END_STATE();
    case 156:
      if (lookahead == 'i') ADVANCE(220);
      END_STATE();
    case 157:
      if (lookahead == 'r') ADVANCE(221);
      END_STATE();
    case 158:
      if (lookahead == 'i') ADVANCE(222);
      END_STATE();
    case 159:
      if (lookahead == '-') ADVANCE(223);
      END_STATE();
    case 160:
      if (lookahead == 's') ADVANCE(224);
      END_STATE();
    case 161:
      if (lookahead == '-') ADVANCE(225);
      END_STATE();
    case 162:
      if (lookahead == 'i') ADVANCE(226);
      END_STATE();
    case 163:
      if (lookahead == 'c') ADVANCE(227);
      END_STATE();
    case 164:
      if (lookahead == 'h') ADVANCE(228);
      END_STATE();
    case 165:
      if (lookahead == 'h') ADVANCE(229);
      END_STATE();
    case 166:
      if (lookahead == 'e') ADVANCE(230);
      END_STATE();
    case 167:
      if (lookahead == '-') ADVANCE(231);
      END_STATE();
    case 168:
      if (lookahead == 'w') ADVANCE(232);
      END_STATE();
    case 169:
      if (lookahead == 's') ADVANCE(233);
      END_STATE();
    case 170:
      if (lookahead == 'r') ADVANCE(234);
      END_STATE();
    case 171:
      if (lookahead == 't') ADVANCE(235);
      END_STATE();
    case 172:
      if (lookahead == 'e') ADVANCE(236);
      END_STATE();
    case 173:
      if (lookahead == 'a') ADVANCE(237);
      END_STATE();
    case 174:
      if (lookahead == 'b') ADVANCE(238);
      if (lookahead == 'c') ADVANCE(239);
      if (lookahead == 'o') ADVANCE(240);
      if (lookahead == 's') ADVANCE(241);
      if (lookahead == 'w') ADVANCE(242);
      END_STATE();
    case 175:
      if (lookahead == 'a') ADVANCE(243);
      END_STATE();
    case 176:
      if (lookahead == 'b') ADVANCE(244);
      if (lookahead == 'c') ADVANCE(245);
      if (lookahead == 'o') ADVANCE(246);
      if (lookahead == 's') ADVANCE(247);
      if (lookahead == 'w') ADVANCE(248);
      END_STATE();
    case 177:
      if (lookahead == '-') ADVANCE(249);
      END_STATE();
    case 178:
      if (lookahead == 'l') ADVANCE(250);
      END_STATE();
    case 179:
      if (lookahead == 'e') ADVANCE(251);
      END_STATE();
    case 180:
      ACCEPT_TOKEN(anon_sym_build);
      END_STATE();
    case 181:
      if (lookahead == '-') ADVANCE(252);
      END_STATE();
    case 182:
      if (lookahead == 'o') ADVANCE(253);
      END_STATE();
    case 183:
      if (lookahead == 'd') ADVANCE(254);
      if (lookahead == 'f') ADVANCE(255);
      END_STATE();
    case 184:
      if (lookahead == 'd') ADVANCE(256);
      if (lookahead == 'f') ADVANCE(257);
      END_STATE();
    case 185:
      if (lookahead == '-') ADVANCE(258);
      if (lookahead == 'r') ADVANCE(259);
      END_STATE();
    case 186:
      if (lookahead == 'p') ADVANCE(260);
      END_STATE();
    case 187:
      if (lookahead == 'r') ADVANCE(261);
      END_STATE();
    case 188:
      if (lookahead == 'e') ADVANCE(262);
      END_STATE();
    case 189:
      if (lookahead == 'a') ADVANCE(263);
      END_STATE();
    case 190:
      ACCEPT_TOKEN(anon_sym_final);
      END_STATE();
    case 191:
      if (lookahead == '-') ADVANCE(264);
      END_STATE();
    case 192:
      if (lookahead == 'i') ADVANCE(265);
      END_STATE();
    case 193:
      ACCEPT_TOKEN(anon_sym_if_DASHeq);
      if (lookahead == 'z') ADVANCE(266);
      END_STATE();
    case 194:
      ACCEPT_TOKEN(anon_sym_if_DASHge);
      if (lookahead == 'z') ADVANCE(267);
      END_STATE();
    case 195:
      ACCEPT_TOKEN(anon_sym_if_DASHgt);
      if (lookahead == 'z') ADVANCE(268);
      END_STATE();
    case 196:
      ACCEPT_TOKEN(anon_sym_if_DASHle);
      if (lookahead == 'z') ADVANCE(269);
      END_STATE();
    case 197:
      ACCEPT_TOKEN(anon_sym_if_DASHlt);
      if (lookahead == 'z') ADVANCE(270);
      END_STATE();
    case 198:
      ACCEPT_TOKEN(anon_sym_if_DASHne);
      if (lookahead == 'z') ADVANCE(271);
      END_STATE();
    case 199:
      if (lookahead == 'b') ADVANCE(272);
      if (lookahead == 'c') ADVANCE(273);
      if (lookahead == 'o') ADVANCE(274);
      if (lookahead == 'q') ADVANCE(275);
      if (lookahead == 's') ADVANCE(276);
      if (lookahead == 'v') ADVANCE(277);
      if (lookahead == 'w') ADVANCE(278);
      END_STATE();
    case 200:
      if (lookahead == 'n') ADVANCE(279);
      END_STATE();
    case 201:
      if (lookahead == 'o') ADVANCE(280);
      END_STATE();
    case 202:
      if (lookahead == 'f') ADVANCE(281);
      END_STATE();
    case 203:
      if (lookahead == 'e') ADVANCE(282);
      END_STATE();
    case 204:
      if (lookahead == 'b') ADVANCE(283);
      if (lookahead == 'c') ADVANCE(284);
      if (lookahead == 'o') ADVANCE(285);
      if (lookahead == 'q') ADVANCE(286);
      if (lookahead == 's') ADVANCE(287);
      if (lookahead == 'v') ADVANCE(288);
      if (lookahead == 'w') ADVANCE(289);
      END_STATE();
    case 205:
      if (lookahead == 't') ADVANCE(290);
      END_STATE();
    case 206:
      if (lookahead == 'o') ADVANCE(291);
      END_STATE();
    case 207:
      if (lookahead == 'e') ADVANCE(292);
      if (lookahead == 'r') ADVANCE(293);
      END_STATE();
    case 208:
      if (lookahead == 'e') ADVANCE(294);
      END_STATE();
    case 209:
      if (lookahead == 'o') ADVANCE(295);
      END_STATE();
    case 210:
      if (lookahead == 'l') ADVANCE(296);
      END_STATE();
    case 211:
      if (lookahead == 'n') ADVANCE(297);
      END_STATE();
    case 212:
      if (lookahead == 'o') ADVANCE(298);
      END_STATE();
    case 213:
      if (lookahead == 'r') ADVANCE(299);
      END_STATE();
    case 214:
      if (lookahead == 'n') ADVANCE(300);
      END_STATE();
    case 215:
      if (lookahead == 'n') ADVANCE(301);
      END_STATE();
    case 216:
      if (lookahead == 'o') ADVANCE(302);
      END_STATE();
    case 217:
      if (lookahead == 'd') ADVANCE(303);
      END_STATE();
    case 218:
      if (lookahead == 't') ADVANCE(304);
      END_STATE();
    case 219:
      if (lookahead == 'c') ADVANCE(305);
      END_STATE();
    case 220:
      if (lookahead == 'c') ADVANCE(306);
      END_STATE();
    case 221:
      if (lookahead == 'n') ADVANCE(307);
      END_STATE();
    case 222:
      if (lookahead == 'm') ADVANCE(308);
      END_STATE();
    case 223:
      if (lookahead == 'b') ADVANCE(309);
      if (lookahead == 'c') ADVANCE(310);
      if (lookahead == 'o') ADVANCE(311);
      if (lookahead == 's') ADVANCE(312);
      if (lookahead == 'v') ADVANCE(313);
      if (lookahead == 'w') ADVANCE(314);
      END_STATE();
    case 224:
      if (lookahead == 'e') ADVANCE(315);
      END_STATE();
    case 225:
      if (lookahead == 'b') ADVANCE(316);
      if (lookahead == 'c') ADVANCE(317);
      if (lookahead == 'o') ADVANCE(318);
      if (lookahead == 's') ADVANCE(319);
      if (lookahead == 'v') ADVANCE(320);
      if (lookahead == 'w') ADVANCE(321);
      END_STATE();
    case 226:
      if (lookahead == 'c') ADVANCE(322);
      END_STATE();
    case 227:
      if (lookahead == 't') ADVANCE(323);
      END_STATE();
    case 228:
      if (lookahead == 'r') ADVANCE(324);
      END_STATE();
    case 229:
      if (lookahead == 'e') ADVANCE(325);
      END_STATE();
    case 230:
      if (lookahead == 'm') ADVANCE(326);
      END_STATE();
    case 231:
      if (lookahead == 'a') ADVANCE(327);
      END_STATE();
    case 232:
      if (lookahead == '-') ADVANCE(328);
      END_STATE();
    case 233:
      if (lookahead == 'i') ADVANCE(329);
      END_STATE();
    case 234:
      if (lookahead == 'g') ADVANCE(330);
      END_STATE();
    case 235:
      if (lookahead == 'i') ADVANCE(331);
      END_STATE();
    case 236:
      if (lookahead == 'l') ADVANCE(332);
      END_STATE();
    case 237:
      if (lookahead == 'c') ADVANCE(333);
      END_STATE();
    case 238:
      if (lookahead == 'o') ADVANCE(334);
      if (lookahead == 'y') ADVANCE(335);
      END_STATE();
    case 239:
      if (lookahead == 'h') ADVANCE(336);
      END_STATE();
    case 240:
      if (lookahead == 'b') ADVANCE(337);
      END_STATE();
    case 241:
      if (lookahead == 'h') ADVANCE(338);
      END_STATE();
    case 242:
      if (lookahead == 'i') ADVANCE(339);
      END_STATE();
    case 243:
      if (lookahead == 't') ADVANCE(340);
      END_STATE();
    case 244:
      if (lookahead == 'o') ADVANCE(341);
      if (lookahead == 'y') ADVANCE(342);
      END_STATE();
    case 245:
      if (lookahead == 'h') ADVANCE(343);
      END_STATE();
    case 246:
      if (lookahead == 'b') ADVANCE(344);
      END_STATE();
    case 247:
      if (lookahead == 'h') ADVANCE(345);
      END_STATE();
    case 248:
      if (lookahead == 'i') ADVANCE(346);
      END_STATE();
    case 249:
      if (lookahead == 'l') ADVANCE(347);
      END_STATE();
    case 250:
      if (lookahead == 'i') ADVANCE(348);
      END_STATE();
    case 251:
      ACCEPT_TOKEN(anon_sym_bridge);
      END_STATE();
    case 252:
      if (lookahead == 'c') ADVANCE(349);
      END_STATE();
    case 253:
      if (lookahead == 'n') ADVANCE(350);
      END_STATE();
    case 254:
      if (lookahead == 'o') ADVANCE(351);
      END_STATE();
    case 255:
      if (lookahead == 'l') ADVANCE(352);
      END_STATE();
    case 256:
      if (lookahead == 'o') ADVANCE(353);
      END_STATE();
    case 257:
      if (lookahead == 'l') ADVANCE(354);
      END_STATE();
    case 258:
      if (lookahead == 'c') ADVANCE(355);
      if (lookahead == 'm') ADVANCE(356);
      END_STATE();
    case 259:
      if (lookahead == 'u') ADVANCE(357);
      END_STATE();
    case 260:
      if (lookahead == 'l') ADVANCE(358);
      END_STATE();
    case 261:
      if (lookahead == 'e') ADVANCE(359);
      END_STATE();
    case 262:
      if (lookahead == '-') ADVANCE(360);
      END_STATE();
    case 263:
      if (lookahead == 'r') ADVANCE(361);
      END_STATE();
    case 264:
      if (lookahead == 't') ADVANCE(362);
      END_STATE();
    case 265:
      if (lookahead == 's') ADVANCE(363);
      END_STATE();
    case 266:
      ACCEPT_TOKEN(anon_sym_if_DASHeqz);
      END_STATE();
    case 267:
      ACCEPT_TOKEN(anon_sym_if_DASHgez);
      END_STATE();
    case 268:
      ACCEPT_TOKEN(anon_sym_if_DASHgtz);
      END_STATE();
    case 269:
      ACCEPT_TOKEN(anon_sym_if_DASHlez);
      END_STATE();
    case 270:
      ACCEPT_TOKEN(anon_sym_if_DASHltz);
      END_STATE();
    case 271:
      ACCEPT_TOKEN(anon_sym_if_DASHnez);
      END_STATE();
    case 272:
      if (lookahead == 'o') ADVANCE(364);
      if (lookahead == 'y') ADVANCE(365);
      END_STATE();
    case 273:
      if (lookahead == 'h') ADVANCE(366);
      END_STATE();
    case 274:
      if (lookahead == 'b') ADVANCE(367);
      END_STATE();
    case 275:
      if (lookahead == 'u') ADVANCE(368);
      END_STATE();
    case 276:
      if (lookahead == 'h') ADVANCE(369);
      END_STATE();
    case 277:
      if (lookahead == 'o') ADVANCE(370);
      END_STATE();
    case 278:
      if (lookahead == 'i') ADVANCE(371);
      END_STATE();
    case 279:
      if (lookahead == 'c') ADVANCE(372);
      END_STATE();
    case 280:
      if (lookahead == '-') ADVANCE(373);
      END_STATE();
    case 281:
      if (lookahead == 'a') ADVANCE(374);
      END_STATE();
    case 282:
      if (lookahead == '-') ADVANCE(375);
      END_STATE();
    case 283:
      if (lookahead == 'o') ADVANCE(376);
      if (lookahead == 'y') ADVANCE(377);
      END_STATE();
    case 284:
      if (lookahead == 'h') ADVANCE(378);
      END_STATE();
    case 285:
      if (lookahead == 'b') ADVANCE(379);
      END_STATE();
    case 286:
      if (lookahead == 'u') ADVANCE(380);
      END_STATE();
    case 287:
      if (lookahead == 'h') ADVANCE(381);
      END_STATE();
    case 288:
      if (lookahead == 'o') ADVANCE(382);
      END_STATE();
    case 289:
      if (lookahead == 'i') ADVANCE(383);
      END_STATE();
    case 290:
      if (lookahead == 'o') ADVANCE(384);
      END_STATE();
    case 291:
      if (lookahead == 'r') ADVANCE(385);
      END_STATE();
    case 292:
      if (lookahead == 'x') ADVANCE(386);
      END_STATE();
    case 293:
      if (lookahead == 'e') ADVANCE(387);
      END_STATE();
    case 294:
      ACCEPT_TOKEN(anon_sym_native);
      END_STATE();
    case 295:
      if (lookahead == 'u') ADVANCE(388);
      END_STATE();
    case 296:
      if (lookahead == 'o') ADVANCE(389);
      END_STATE();
    case 297:
      if (lookahead == 't') ADVANCE(390);
      END_STATE();
    case 298:
      if (lookahead == 'n') ADVANCE(391);
      END_STATE();
    case 299:
      if (lookahead == 'r') ADVANCE(392);
      END_STATE();
    case 300:
      if (lookahead == 's') ADVANCE(393);
      END_STATE();
    case 301:
      if (lookahead == 't') ADVANCE(394);
      END_STATE();
    case 302:
      if (lookahead == 'n') ADVANCE(395);
      END_STATE();
    case 303:
      if (lookahead == '-') ADVANCE(396);
      END_STATE();
    case 304:
      if (lookahead == 'e') ADVANCE(397);
      END_STATE();
    case 305:
      if (lookahead == 't') ADVANCE(398);
      END_STATE();
    case 306:
      ACCEPT_TOKEN(anon_sym_public);
      END_STATE();
    case 307:
      if (lookahead == '-') ADVANCE(399);
      END_STATE();
    case 308:
      if (lookahead == 'e') ADVANCE(400);
      END_STATE();
    case 309:
      if (lookahead == 'o') ADVANCE(401);
      if (lookahead == 'y') ADVANCE(402);
      END_STATE();
    case 310:
      if (lookahead == 'h') ADVANCE(403);
      END_STATE();
    case 311:
      if (lookahead == 'b') ADVANCE(404);
      END_STATE();
    case 312:
      if (lookahead == 'h') ADVANCE(405);
      END_STATE();
    case 313:
      if (lookahead == 'o') ADVANCE(406);
      END_STATE();
    case 314:
      if (lookahead == 'i') ADVANCE(407);
      END_STATE();
    case 315:
      if (lookahead == '-') ADVANCE(408);
      END_STATE();
    case 316:
      if (lookahead == 'o') ADVANCE(409);
      if (lookahead == 'y') ADVANCE(410);
      END_STATE();
    case 317:
      if (lookahead == 'h') ADVANCE(411);
      END_STATE();
    case 318:
      if (lookahead == 'b') ADVANCE(412);
      END_STATE();
    case 319:
      if (lookahead == 'h') ADVANCE(413);
      END_STATE();
    case 320:
      if (lookahead == 'o') ADVANCE(414);
      END_STATE();
    case 321:
      if (lookahead == 'i') ADVANCE(415);
      END_STATE();
    case 322:
      ACCEPT_TOKEN(anon_sym_static);
      if (lookahead == '-') ADVANCE(416);
      END_STATE();
    case 323:
      if (lookahead == 'f') ADVANCE(417);
      END_STATE();
    case 324:
      if (lookahead == 'o') ADVANCE(418);
      END_STATE();
    case 325:
      if (lookahead == 't') ADVANCE(419);
      END_STATE();
    case 326:
      ACCEPT_TOKEN(anon_sym_system);
      END_STATE();
    case 327:
      if (lookahead == 'p') ADVANCE(420);
      END_STATE();
    case 328:
      if (lookahead == 'v') ADVANCE(421);
      END_STATE();
    case 329:
      if (lookahead == 'e') ADVANCE(422);
      END_STATE();
    case 330:
      if (lookahead == 's') ADVANCE(423);
      END_STATE();
    case 331:
      if (lookahead == 'l') ADVANCE(424);
      END_STATE();
    case 332:
      if (lookahead == 'i') ADVANCE(425);
      END_STATE();
    case 333:
      if (lookahead == 't') ADVANCE(426);
      END_STATE();
    case 334:
      if (lookahead == 'o') ADVANCE(427);
      END_STATE();
    case 335:
      if (lookahead == 't') ADVANCE(428);
      END_STATE();
    case 336:
      if (lookahead == 'a') ADVANCE(429);
      END_STATE();
    case 337:
      if (lookahead == 'j') ADVANCE(430);
      END_STATE();
    case 338:
      if (lookahead == 'o') ADVANCE(431);
      END_STATE();
    case 339:
      if (lookahead == 'd') ADVANCE(432);
      END_STATE();
    case 340:
      if (lookahead == 'i') ADVANCE(433);
      END_STATE();
    case 341:
      if (lookahead == 'o') ADVANCE(434);
      END_STATE();
    case 342:
      if (lookahead == 't') ADVANCE(435);
      END_STATE();
    case 343:
      if (lookahead == 'a') ADVANCE(436);
      END_STATE();
    case 344:
      if (lookahead == 'j') ADVANCE(437);
      END_STATE();
    case 345:
      if (lookahead == 'o') ADVANCE(438);
      END_STATE();
    case 346:
      if (lookahead == 'd') ADVANCE(439);
      END_STATE();
    case 347:
      if (lookahead == 'e') ADVANCE(440);
      END_STATE();
    case 348:
      if (lookahead == 's') ADVANCE(441);
      END_STATE();
    case 349:
      if (lookahead == 'a') ADVANCE(442);
      END_STATE();
    case 350:
      if (lookahead == 'g') ADVANCE(443);
      END_STATE();
    case 351:
      if (lookahead == 'u') ADVANCE(444);
      END_STATE();
    case 352:
      if (lookahead == 'o') ADVANCE(445);
      END_STATE();
    case 353:
      if (lookahead == 'u') ADVANCE(446);
      END_STATE();
    case 354:
      if (lookahead == 'o') ADVANCE(447);
      END_STATE();
    case 355:
      if (lookahead == 'l') ADVANCE(448);
      END_STATE();
    case 356:
      if (lookahead == 'e') ADVANCE(449);
      END_STATE();
    case 357:
      if (lookahead == 'c') ADVANCE(450);
      END_STATE();
    case 358:
      if (lookahead == 'a') ADVANCE(451);
      END_STATE();
    case 359:
      if (lookahead == 'd') ADVANCE(452);
      END_STATE();
    case 360:
      if (lookahead == 't') ADVANCE(453);
      END_STATE();
    case 361:
      if (lookahead == 'r') ADVANCE(454);
      END_STATE();
    case 362:
      if (lookahead == 'o') ADVANCE(455);
      END_STATE();
    case 363:
      if (lookahead == 't') ADVANCE(456);
      END_STATE();
    case 364:
      if (lookahead == 'o') ADVANCE(457);
      END_STATE();
    case 365:
      if (lookahead == 't') ADVANCE(458);
      END_STATE();
    case 366:
      if (lookahead == 'a') ADVANCE(459);
      END_STATE();
    case 367:
      if (lookahead == 'j') ADVANCE(460);
      END_STATE();
    case 368:
      if (lookahead == 'i') ADVANCE(461);
      END_STATE();
    case 369:
      if (lookahead == 'o') ADVANCE(462);
      END_STATE();
    case 370:
      if (lookahead == 'l') ADVANCE(463);
      END_STATE();
    case 371:
      if (lookahead == 'd') ADVANCE(464);
      END_STATE();
    case 372:
      if (lookahead == 'e') ADVANCE(465);
      END_STATE();
    case 373:
      if (lookahead == 'b') ADVANCE(466);
      if (lookahead == 'c') ADVANCE(467);
      if (lookahead == 'd') ADVANCE(468);
      if (lookahead == 'f') ADVANCE(469);
      if (lookahead == 'l') ADVANCE(470);
      if (lookahead == 's') ADVANCE(471);
      END_STATE();
    case 374:
      if (lookahead == 'c') ADVANCE(472);
      END_STATE();
    case 375:
      if (lookahead == 'c') ADVANCE(473);
      if (lookahead == 'd') ADVANCE(474);
      if (lookahead == 'i') ADVANCE(475);
      END_STATE();
    case 376:
      if (lookahead == 'o') ADVANCE(476);
      END_STATE();
    case 377:
      if (lookahead == 't') ADVANCE(477);
      END_STATE();
    case 378:
      if (lookahead == 'a') ADVANCE(478);
      END_STATE();
    case 379:
      if (lookahead == 'j') ADVANCE(479);
      END_STATE();
    case 380:
      if (lookahead == 'i') ADVANCE(480);
      END_STATE();
    case 381:
      if (lookahead == 'o') ADVANCE(481);
      END_STATE();
    case 382:
      if (lookahead == 'l') ADVANCE(482);
      END_STATE();
    case 383:
      if (lookahead == 'd') ADVANCE(483);
      END_STATE();
    case 384:
      if (lookahead == '-') ADVANCE(484);
      END_STATE();
    case 385:
      if (lookahead == '-') ADVANCE(485);
      END_STATE();
    case 386:
      if (lookahead == 'c') ADVANCE(486);
      END_STATE();
    case 387:
      if (lookahead == 's') ADVANCE(487);
      END_STATE();
    case 388:
      if (lookahead == 'b') ADVANCE(488);
      END_STATE();
    case 389:
      if (lookahead == 'a') ADVANCE(489);
      END_STATE();
    case 390:
      ACCEPT_TOKEN(anon_sym_neg_DASHint);
      END_STATE();
    case 391:
      if (lookahead == 'g') ADVANCE(490);
      END_STATE();
    case 392:
      if (lookahead == 'a') ADVANCE(491);
      END_STATE();
    case 393:
      if (lookahead == 't') ADVANCE(492);
      END_STATE();
    case 394:
      ACCEPT_TOKEN(anon_sym_not_DASHint);
      END_STATE();
    case 395:
      if (lookahead == 'g') ADVANCE(493);
      END_STATE();
    case 396:
      if (lookahead == 's') ADVANCE(494);
      END_STATE();
    case 397:
      ACCEPT_TOKEN(anon_sym_private);
      END_STATE();
    case 398:
      if (lookahead == 'e') ADVANCE(495);
      END_STATE();
    case 399:
      if (lookahead == 'o') ADVANCE(496);
      if (lookahead == 'v') ADVANCE(497);
      if (lookahead == 'w') ADVANCE(498);
      END_STATE();
    case 400:
      ACCEPT_TOKEN(anon_sym_runtime);
      END_STATE();
    case 401:
      if (lookahead == 'o') ADVANCE(499);
      END_STATE();
    case 402:
      if (lookahead == 't') ADVANCE(500);
      END_STATE();
    case 403:
      if (lookahead == 'a') ADVANCE(501);
      END_STATE();
    case 404:
      if (lookahead == 'j') ADVANCE(502);
      END_STATE();
    case 405:
      if (lookahead == 'o') ADVANCE(503);
      END_STATE();
    case 406:
      if (lookahead == 'l') ADVANCE(504);
      END_STATE();
    case 407:
      if (lookahead == 'd') ADVANCE(505);
      END_STATE();
    case 408:
      if (lookahead == 's') ADVANCE(506);
      END_STATE();
    case 409:
      if (lookahead == 'o') ADVANCE(507);
      END_STATE();
    case 410:
      if (lookahead == 't') ADVANCE(508);
      END_STATE();
    case 411:
      if (lookahead == 'a') ADVANCE(509);
      END_STATE();
    case 412:
      if (lookahead == 'j') ADVANCE(510);
      END_STATE();
    case 413:
      if (lookahead == 'o') ADVANCE(511);
      END_STATE();
    case 414:
      if (lookahead == 'l') ADVANCE(512);
      END_STATE();
    case 415:
      if (lookahead == 'd') ADVANCE(513);
      END_STATE();
    case 416:
      if (lookahead == 'g') ADVANCE(514);
      if (lookahead == 'p') ADVANCE(515);
      END_STATE();
    case 417:
      if (lookahead == 'p') ADVANCE(516);
      END_STATE();
    case 418:
      if (lookahead == 'n') ADVANCE(517);
      END_STATE();
    case 419:
      if (lookahead == 'i') ADVANCE(518);
      END_STATE();
    case 420:
      if (lookahead == 'i') ADVANCE(519);
      END_STATE();
    case 421:
      if (lookahead == 'e') ADVANCE(520);
      END_STATE();
    case 422:
      if (lookahead == 'n') ADVANCE(521);
      END_STATE();
    case 423:
      ACCEPT_TOKEN(anon_sym_varargs);
      END_STATE();
    case 424:
      if (lookahead == 'e') ADVANCE(522);
      END_STATE();
    case 425:
      if (lookahead == 's') ADVANCE(523);
      END_STATE();
    case 426:
      ACCEPT_TOKEN(anon_sym_abstract);
      END_STATE();
    case 427:
      if (lookahead == 'l') ADVANCE(524);
      END_STATE();
    case 428:
      if (lookahead == 'e') ADVANCE(525);
      END_STATE();
    case 429:
      if (lookahead == 'r') ADVANCE(526);
      END_STATE();
    case 430:
      if (lookahead == 'e') ADVANCE(527);
      END_STATE();
    case 431:
      if (lookahead == 'r') ADVANCE(528);
      END_STATE();
    case 432:
      if (lookahead == 'e') ADVANCE(529);
      END_STATE();
    case 433:
      if (lookahead == 'o') ADVANCE(530);
      END_STATE();
    case 434:
      if (lookahead == 'l') ADVANCE(531);
      END_STATE();
    case 435:
      if (lookahead == 'e') ADVANCE(532);
      END_STATE();
    case 436:
      if (lookahead == 'r') ADVANCE(533);
      END_STATE();
    case 437:
      if (lookahead == 'e') ADVANCE(534);
      END_STATE();
    case 438:
      if (lookahead == 'r') ADVANCE(535);
      END_STATE();
    case 439:
      if (lookahead == 'e') ADVANCE(536);
      END_STATE();
    case 440:
      if (lookahead == 'n') ADVANCE(537);
      END_STATE();
    case 441:
      if (lookahead == 't') ADVANCE(538);
      END_STATE();
    case 442:
      if (lookahead == 's') ADVANCE(539);
      END_STATE();
    case 443:
      ACCEPT_TOKEN(anon_sym_cmp_DASHlong);
      END_STATE();
    case 444:
      if (lookahead == 'b') ADVANCE(540);
      END_STATE();
    case 445:
      if (lookahead == 'a') ADVANCE(541);
      END_STATE();
    case 446:
      if (lookahead == 'b') ADVANCE(542);
      END_STATE();
    case 447:
      if (lookahead == 'a') ADVANCE(543);
      END_STATE();
    case 448:
      if (lookahead == 'a') ADVANCE(544);
      END_STATE();
    case 449:
      if (lookahead == 't') ADVANCE(545);
      END_STATE();
    case 450:
      if (lookahead == 't') ADVANCE(546);
      END_STATE();
    case 451:
      if (lookahead == 't') ADVANCE(547);
      END_STATE();
    case 452:
      if (lookahead == '-') ADVANCE(548);
      END_STATE();
    case 453:
      if (lookahead == 'o') ADVANCE(549);
      END_STATE();
    case 454:
      if (lookahead == 'a') ADVANCE(550);
      END_STATE();
    case 455:
      if (lookahead == '-') ADVANCE(551);
      END_STATE();
    case 456:
      ACCEPT_TOKEN(anon_sym_greylist);
      if (lookahead == '-') ADVANCE(552);
      END_STATE();
    case 457:
      if (lookahead == 'l') ADVANCE(553);
      END_STATE();
    case 458:
      if (lookahead == 'e') ADVANCE(554);
      END_STATE();
    case 459:
      if (lookahead == 'r') ADVANCE(555);
      END_STATE();
    case 460:
      if (lookahead == 'e') ADVANCE(556);
      END_STATE();
    case 461:
      if (lookahead == 'c') ADVANCE(557);
      END_STATE();
    case 462:
      if (lookahead == 'r') ADVANCE(558);
      END_STATE();
    case 463:
      if (lookahead == 'a') ADVANCE(559);
      END_STATE();
    case 464:
      if (lookahead == 'e') ADVANCE(560);
      END_STATE();
    case 465:
      if (lookahead == '-') ADVANCE(561);
      END_STATE();
    case 466:
      if (lookahead == 'y') ADVANCE(562);
      END_STATE();
    case 467:
      if (lookahead == 'h') ADVANCE(563);
      END_STATE();
    case 468:
      if (lookahead == 'o') ADVANCE(564);
      END_STATE();
    case 469:
      if (lookahead == 'l') ADVANCE(565);
      END_STATE();
    case 470:
      if (lookahead == 'o') ADVANCE(566);
      END_STATE();
    case 471:
      if (lookahead == 'h') ADVANCE(567);
      END_STATE();
    case 472:
      if (lookahead == 'e') ADVANCE(568);
      END_STATE();
    case 473:
      if (lookahead == 'o') ADVANCE(569);
      END_STATE();
    case 474:
      if (lookahead == 'i') ADVANCE(570);
      END_STATE();
    case 475:
      if (lookahead == 'n') ADVANCE(571);
      END_STATE();
    case 476:
      if (lookahead == 'l') ADVANCE(572);
      END_STATE();
    case 477:
      if (lookahead == 'e') ADVANCE(573);
      END_STATE();
    case 478:
      if (lookahead == 'r') ADVANCE(574);
      END_STATE();
    case 479:
      if (lookahead == 'e') ADVANCE(575);
      END_STATE();
    case 480:
      if (lookahead == 'c') ADVANCE(576);
      END_STATE();
    case 481:
      if (lookahead == 'r') ADVANCE(577);
      END_STATE();
    case 482:
      if (lookahead == 'a') ADVANCE(578);
      END_STATE();
    case 483:
      if (lookahead == 'e') ADVANCE(579);
      END_STATE();
    case 484:
      if (lookahead == 'd') ADVANCE(580);
      if (lookahead == 'f') ADVANCE(581);
      if (lookahead == 'i') ADVANCE(582);
      END_STATE();
    case 485:
      if (lookahead == 'e') ADVANCE(583);
      END_STATE();
    case 486:
      if (lookahead == 'e') ADVANCE(584);
      END_STATE();
    case 487:
      if (lookahead == 'u') ADVANCE(585);
      END_STATE();
    case 488:
      if (lookahead == 'l') ADVANCE(586);
      END_STATE();
    case 489:
      if (lookahead == 't') ADVANCE(587);
      END_STATE();
    case 490:
      ACCEPT_TOKEN(anon_sym_neg_DASHlong);
      END_STATE();
    case 491:
      if (lookahead == 'y') ADVANCE(588);
      END_STATE();
    case 492:
      if (lookahead == 'a') ADVANCE(589);
      END_STATE();
    case 493:
      ACCEPT_TOKEN(anon_sym_not_DASHlong);
      END_STATE();
    case 494:
      if (lookahead == 'w') ADVANCE(590);
      END_STATE();
    case 495:
      if (lookahead == 'd') ADVANCE(591);
      END_STATE();
    case 496:
      if (lookahead == 'b') ADVANCE(592);
      END_STATE();
    case 497:
      if (lookahead == 'o') ADVANCE(593);
      END_STATE();
    case 498:
      if (lookahead == 'i') ADVANCE(594);
      END_STATE();
    case 499:
      if (lookahead == 'l') ADVANCE(595);
      END_STATE();
    case 500:
      if (lookahead == 'e') ADVANCE(596);
      END_STATE();
    case 501:
      if (lookahead == 'r') ADVANCE(597);
      END_STATE();
    case 502:
      if (lookahead == 'e') ADVANCE(598);
      END_STATE();
    case 503:
      if (lookahead == 'r') ADVANCE(599);
      END_STATE();
    case 504:
      if (lookahead == 'a') ADVANCE(600);
      END_STATE();
    case 505:
      if (lookahead == 'e') ADVANCE(601);
      END_STATE();
    case 506:
      if (lookahead == 'w') ADVANCE(602);
      END_STATE();
    case 507:
      if (lookahead == 'l') ADVANCE(603);
      END_STATE();
    case 508:
      if (lookahead == 'e') ADVANCE(604);
      END_STATE();
    case 509:
      if (lookahead == 'r') ADVANCE(605);
      END_STATE();
    case 510:
      if (lookahead == 'e') ADVANCE(606);
      END_STATE();
    case 511:
      if (lookahead == 'r') ADVANCE(607);
      END_STATE();
    case 512:
      if (lookahead == 'a') ADVANCE(608);
      END_STATE();
    case 513:
      if (lookahead == 'e') ADVANCE(609);
      END_STATE();
    case 514:
      if (lookahead == 'e') ADVANCE(610);
      END_STATE();
    case 515:
      if (lookahead == 'u') ADVANCE(611);
      END_STATE();
    case 516:
      ACCEPT_TOKEN(anon_sym_strictfp);
      END_STATE();
    case 517:
      if (lookahead == 'i') ADVANCE(612);
      END_STATE();
    case 518:
      if (lookahead == 'c') ADVANCE(613);
      END_STATE();
    case 519:
      ACCEPT_TOKEN(anon_sym_test_DASHapi);
      END_STATE();
    case 520:
      if (lookahead == 'r') ADVANCE(614);
      END_STATE();
    case 521:
      if (lookahead == 't') ADVANCE(615);
      END_STATE();
    case 522:
      ACCEPT_TOKEN(anon_sym_volatile);
      END_STATE();
    case 523:
      if (lookahead == 't') ADVANCE(616);
      END_STATE();
    case 524:
      if (lookahead == 'e') ADVANCE(617);
      END_STATE();
    case 525:
      ACCEPT_TOKEN(anon_sym_aget_DASHbyte);
      END_STATE();
    case 526:
      ACCEPT_TOKEN(anon_sym_aget_DASHchar);
      END_STATE();
    case 527:
      if (lookahead == 'c') ADVANCE(618);
      END_STATE();
    case 528:
      if (lookahead == 't') ADVANCE(619);
      END_STATE();
    case 529:
      ACCEPT_TOKEN(anon_sym_aget_DASHwide);
      END_STATE();
    case 530:
      if (lookahead == 'n') ADVANCE(620);
      END_STATE();
    case 531:
      if (lookahead == 'e') ADVANCE(621);
      END_STATE();
    case 532:
      ACCEPT_TOKEN(anon_sym_aput_DASHbyte);
      END_STATE();
    case 533:
      ACCEPT_TOKEN(anon_sym_aput_DASHchar);
      END_STATE();
    case 534:
      if (lookahead == 'c') ADVANCE(622);
      END_STATE();
    case 535:
      if (lookahead == 't') ADVANCE(623);
      END_STATE();
    case 536:
      ACCEPT_TOKEN(anon_sym_aput_DASHwide);
      END_STATE();
    case 537:
      if (lookahead == 'g') ADVANCE(624);
      END_STATE();
    case 538:
      ACCEPT_TOKEN(anon_sym_blacklist);
      END_STATE();
    case 539:
      if (lookahead == 't') ADVANCE(625);
      END_STATE();
    case 540:
      if (lookahead == 'l') ADVANCE(626);
      END_STATE();
    case 541:
      if (lookahead == 't') ADVANCE(627);
      END_STATE();
    case 542:
      if (lookahead == 'l') ADVANCE(628);
      END_STATE();
    case 543:
      if (lookahead == 't') ADVANCE(629);
      END_STATE();
    case 544:
      if (lookahead == 's') ADVANCE(630);
      END_STATE();
    case 545:
      if (lookahead == 'h') ADVANCE(631);
      END_STATE();
    case 546:
      if (lookahead == 'o') ADVANCE(632);
      END_STATE();
    case 547:
      if (lookahead == 'f') ADVANCE(633);
      END_STATE();
    case 548:
      if (lookahead == 's') ADVANCE(634);
      END_STATE();
    case 549:
      if (lookahead == '-') ADVANCE(635);
      END_STATE();
    case 550:
      if (lookahead == 'y') ADVANCE(636);
      END_STATE();
    case 551:
      if (lookahead == 'd') ADVANCE(637);
      if (lookahead == 'i') ADVANCE(638);
      if (lookahead == 'l') ADVANCE(639);
      END_STATE();
    case 552:
      if (lookahead == 'm') ADVANCE(640);
      END_STATE();
    case 553:
      if (lookahead == 'e') ADVANCE(641);
      END_STATE();
    case 554:
      ACCEPT_TOKEN(anon_sym_iget_DASHbyte);
      END_STATE();
    case 555:
      ACCEPT_TOKEN(anon_sym_iget_DASHchar);
      END_STATE();
    case 556:
      if (lookahead == 'c') ADVANCE(642);
      END_STATE();
    case 557:
      if (lookahead == 'k') ADVANCE(643);
      END_STATE();
    case 558:
      if (lookahead == 't') ADVANCE(644);
      END_STATE();
    case 559:
      if (lookahead == 't') ADVANCE(645);
      END_STATE();
    case 560:
      ACCEPT_TOKEN(anon_sym_iget_DASHwide);
      if (lookahead == '-') ADVANCE(646);
      END_STATE();
    case 561:
      if (lookahead == 'g') ADVANCE(647);
      if (lookahead == 'o') ADVANCE(648);
      if (lookahead == 'p') ADVANCE(649);
      END_STATE();
    case 562:
      if (lookahead == 't') ADVANCE(650);
      END_STATE();
    case 563:
      if (lookahead == 'a') ADVANCE(651);
      END_STATE();
    case 564:
      if (lookahead == 'u') ADVANCE(652);
      END_STATE();
    case 565:
      if (lookahead == 'o') ADVANCE(653);
      END_STATE();
    case 566:
      if (lookahead == 'n') ADVANCE(654);
      END_STATE();
    case 567:
      if (lookahead == 'o') ADVANCE(655);
      END_STATE();
    case 568:
      ACCEPT_TOKEN(anon_sym_interface);
      END_STATE();
    case 569:
      if (lookahead == 'n') ADVANCE(656);
      END_STATE();
    case 570:
      if (lookahead == 'r') ADVANCE(657);
      END_STATE();
    case 571:
      if (lookahead == 's') ADVANCE(658);
      END_STATE();
    case 572:
      if (lookahead == 'e') ADVANCE(659);
      END_STATE();
    case 573:
      ACCEPT_TOKEN(anon_sym_iput_DASHbyte);
      if (lookahead == '-') ADVANCE(660);
      END_STATE();
    case 574:
      ACCEPT_TOKEN(anon_sym_iput_DASHchar);
      if (lookahead == '-') ADVANCE(661);
      END_STATE();
    case 575:
      if (lookahead == 'c') ADVANCE(662);
      END_STATE();
    case 576:
      if (lookahead == 'k') ADVANCE(663);
      END_STATE();
    case 577:
      if (lookahead == 't') ADVANCE(664);
      END_STATE();
    case 578:
      if (lookahead == 't') ADVANCE(665);
      END_STATE();
    case 579:
      ACCEPT_TOKEN(anon_sym_iput_DASHwide);
      if (lookahead == '-') ADVANCE(666);
      END_STATE();
    case 580:
      if (lookahead == 'o') ADVANCE(667);
      END_STATE();
    case 581:
      if (lookahead == 'l') ADVANCE(668);
      END_STATE();
    case 582:
      if (lookahead == 'n') ADVANCE(669);
      END_STATE();
    case 583:
      if (lookahead == 'n') ADVANCE(670);
      if (lookahead == 'x') ADVANCE(671);
      END_STATE();
    case 584:
      if (lookahead == 'p') ADVANCE(672);
      END_STATE();
    case 585:
      if (lookahead == 'l') ADVANCE(673);
      END_STATE();
    case 586:
      if (lookahead == 'e') ADVANCE(674);
      END_STATE();
    case 587:
      ACCEPT_TOKEN(anon_sym_neg_DASHfloat);
      END_STATE();
    case 588:
      ACCEPT_TOKEN(anon_sym_new_DASHarray);
      END_STATE();
    case 589:
      if (lookahead == 'n') ADVANCE(675);
      END_STATE();
    case 590:
      if (lookahead == 'i') ADVANCE(676);
      END_STATE();
    case 591:
      ACCEPT_TOKEN(anon_sym_protected);
      END_STATE();
    case 592:
      if (lookahead == 'j') ADVANCE(677);
      END_STATE();
    case 593:
      if (lookahead == 'i') ADVANCE(678);
      END_STATE();
    case 594:
      if (lookahead == 'd') ADVANCE(679);
      END_STATE();
    case 595:
      if (lookahead == 'e') ADVANCE(680);
      END_STATE();
    case 596:
      ACCEPT_TOKEN(anon_sym_sget_DASHbyte);
      END_STATE();
    case 597:
      ACCEPT_TOKEN(anon_sym_sget_DASHchar);
      END_STATE();
    case 598:
      if (lookahead == 'c') ADVANCE(681);
      END_STATE();
    case 599:
      if (lookahead == 't') ADVANCE(682);
      END_STATE();
    case 600:
      if (lookahead == 't') ADVANCE(683);
      END_STATE();
    case 601:
      ACCEPT_TOKEN(anon_sym_sget_DASHwide);
      if (lookahead == '-') ADVANCE(684);
      END_STATE();
    case 602:
      if (lookahead == 'i') ADVANCE(685);
      END_STATE();
    case 603:
      if (lookahead == 'e') ADVANCE(686);
      END_STATE();
    case 604:
      ACCEPT_TOKEN(anon_sym_sput_DASHbyte);
      END_STATE();
    case 605:
      ACCEPT_TOKEN(anon_sym_sput_DASHchar);
      END_STATE();
    case 606:
      if (lookahead == 'c') ADVANCE(687);
      END_STATE();
    case 607:
      if (lookahead == 't') ADVANCE(688);
      END_STATE();
    case 608:
      if (lookahead == 't') ADVANCE(689);
      END_STATE();
    case 609:
      ACCEPT_TOKEN(anon_sym_sput_DASHwide);
      if (lookahead == '-') ADVANCE(690);
      END_STATE();
    case 610:
      if (lookahead == 't') ADVANCE(691);
      END_STATE();
    case 611:
      if (lookahead == 't') ADVANCE(692);
      END_STATE();
    case 612:
      if (lookahead == 'z') ADVANCE(693);
      END_STATE();
    case 613:
      ACCEPT_TOKEN(anon_sym_synthetic);
      END_STATE();
    case 614:
      if (lookahead == 'i') ADVANCE(694);
      END_STATE();
    case 615:
      ACCEPT_TOKEN(anon_sym_transient);
      END_STATE();
    case 616:
      ACCEPT_TOKEN(anon_sym_whitelist);
      END_STATE();
    case 617:
      if (lookahead == 'a') ADVANCE(695);
      END_STATE();
    case 618:
      if (lookahead == 't') ADVANCE(696);
      END_STATE();
    case 619:
      ACCEPT_TOKEN(anon_sym_aget_DASHshort);
      END_STATE();
    case 620:
      ACCEPT_TOKEN(anon_sym_annotation);
      END_STATE();
    case 621:
      if (lookahead == 'a') ADVANCE(697);
      END_STATE();
    case 622:
      if (lookahead == 't') ADVANCE(698);
      END_STATE();
    case 623:
      ACCEPT_TOKEN(anon_sym_aput_DASHshort);
      END_STATE();
    case 624:
      if (lookahead == 't') ADVANCE(699);
      END_STATE();
    case 625:
      ACCEPT_TOKEN(anon_sym_check_DASHcast);
      END_STATE();
    case 626:
      if (lookahead == 'e') ADVANCE(700);
      END_STATE();
    case 627:
      ACCEPT_TOKEN(anon_sym_cmpg_DASHfloat);
      END_STATE();
    case 628:
      if (lookahead == 'e') ADVANCE(701);
      END_STATE();
    case 629:
      ACCEPT_TOKEN(anon_sym_cmpl_DASHfloat);
      END_STATE();
    case 630:
      if (lookahead == 's') ADVANCE(702);
      END_STATE();
    case 631:
      if (lookahead == 'o') ADVANCE(703);
      END_STATE();
    case 632:
      if (lookahead == 'r') ADVANCE(704);
      END_STATE();
    case 633:
      if (lookahead == 'o') ADVANCE(705);
      END_STATE();
    case 634:
      if (lookahead == 'y') ADVANCE(706);
      END_STATE();
    case 635:
      if (lookahead == 'f') ADVANCE(707);
      if (lookahead == 'i') ADVANCE(708);
      if (lookahead == 'l') ADVANCE(709);
      END_STATE();
    case 636:
      if (lookahead == '-') ADVANCE(710);
      END_STATE();
    case 637:
      if (lookahead == 'o') ADVANCE(711);
      END_STATE();
    case 638:
      if (lookahead == 'n') ADVANCE(712);
      END_STATE();
    case 639:
      if (lookahead == 'o') ADVANCE(713);
      END_STATE();
    case 640:
      if (lookahead == 'a') ADVANCE(714);
      END_STATE();
    case 641:
      if (lookahead == 'a') ADVANCE(715);
      END_STATE();
    case 642:
      if (lookahead == 't') ADVANCE(716);
      END_STATE();
    case 643:
      ACCEPT_TOKEN(anon_sym_iget_DASHquick);
      END_STATE();
    case 644:
      ACCEPT_TOKEN(anon_sym_iget_DASHshort);
      END_STATE();
    case 645:
      if (lookahead == 'i') ADVANCE(717);
      END_STATE();
    case 646:
      if (lookahead == 'q') ADVANCE(718);
      if (lookahead == 'v') ADVANCE(719);
      END_STATE();
    case 647:
      if (lookahead == 'e') ADVANCE(720);
      END_STATE();
    case 648:
      if (lookahead == 'f') ADVANCE(721);
      END_STATE();
    case 649:
      if (lookahead == 'u') ADVANCE(722);
      END_STATE();
    case 650:
      if (lookahead == 'e') ADVANCE(723);
      END_STATE();
    case 651:
      if (lookahead == 'r') ADVANCE(724);
      END_STATE();
    case 652:
      if (lookahead == 'b') ADVANCE(725);
      END_STATE();
    case 653:
      if (lookahead == 'a') ADVANCE(726);
      END_STATE();
    case 654:
      if (lookahead == 'g') ADVANCE(727);
      END_STATE();
    case 655:
      if (lookahead == 'r') ADVANCE(728);
      END_STATE();
    case 656:
      if (lookahead == 's') ADVANCE(729);
      END_STATE();
    case 657:
      if (lookahead == 'e') ADVANCE(730);
      END_STATE();
    case 658:
      if (lookahead == 't') ADVANCE(731);
      END_STATE();
    case 659:
      if (lookahead == 'a') ADVANCE(732);
      END_STATE();
    case 660:
      if (lookahead == 'q') ADVANCE(733);
      END_STATE();
    case 661:
      if (lookahead == 'q') ADVANCE(734);
      END_STATE();
    case 662:
      if (lookahead == 't') ADVANCE(735);
      END_STATE();
    case 663:
      ACCEPT_TOKEN(anon_sym_iput_DASHquick);
      END_STATE();
    case 664:
      ACCEPT_TOKEN(anon_sym_iput_DASHshort);
      if (lookahead == '-') ADVANCE(736);
      END_STATE();
    case 665:
      if (lookahead == 'i') ADVANCE(737);
      END_STATE();
    case 666:
      if (lookahead == 'q') ADVANCE(738);
      if (lookahead == 'v') ADVANCE(739);
      END_STATE();
    case 667:
      if (lookahead == 'u') ADVANCE(740);
      END_STATE();
    case 668:
      if (lookahead == 'o') ADVANCE(741);
      END_STATE();
    case 669:
      if (lookahead == 't') ADVANCE(742);
      END_STATE();
    case 670:
      if (lookahead == 't') ADVANCE(743);
      END_STATE();
    case 671:
      if (lookahead == 'i') ADVANCE(744);
      END_STATE();
    case 672:
      if (lookahead == 't') ADVANCE(745);
      END_STATE();
    case 673:
      if (lookahead == 't') ADVANCE(746);
      END_STATE();
    case 674:
      ACCEPT_TOKEN(anon_sym_neg_DASHdouble);
      END_STATE();
    case 675:
      if (lookahead == 'c') ADVANCE(747);
      END_STATE();
    case 676:
      if (lookahead == 't') ADVANCE(748);
      END_STATE();
    case 677:
      if (lookahead == 'e') ADVANCE(749);
      END_STATE();
    case 678:
      if (lookahead == 'd') ADVANCE(750);
      END_STATE();
    case 679:
      if (lookahead == 'e') ADVANCE(751);
      END_STATE();
    case 680:
      if (lookahead == 'a') ADVANCE(752);
      END_STATE();
    case 681:
      if (lookahead == 't') ADVANCE(753);
      END_STATE();
    case 682:
      ACCEPT_TOKEN(anon_sym_sget_DASHshort);
      END_STATE();
    case 683:
      if (lookahead == 'i') ADVANCE(754);
      END_STATE();
    case 684:
      if (lookahead == 'v') ADVANCE(755);
      END_STATE();
    case 685:
      if (lookahead == 't') ADVANCE(756);
      END_STATE();
    case 686:
      if (lookahead == 'a') ADVANCE(757);
      END_STATE();
    case 687:
      if (lookahead == 't') ADVANCE(758);
      END_STATE();
    case 688:
      ACCEPT_TOKEN(anon_sym_sput_DASHshort);
      END_STATE();
    case 689:
      if (lookahead == 'i') ADVANCE(759);
      END_STATE();
    case 690:
      if (lookahead == 'v') ADVANCE(760);
      END_STATE();
    case 691:
      ACCEPT_TOKEN(anon_sym_static_DASHget);
      END_STATE();
    case 692:
      ACCEPT_TOKEN(anon_sym_static_DASHput);
      END_STATE();
    case 693:
      if (lookahead == 'e') ADVANCE(761);
      END_STATE();
    case 694:
      if (lookahead == 'f') ADVANCE(762);
      END_STATE();
    case 695:
      if (lookahead == 'n') ADVANCE(763);
      END_STATE();
    case 696:
      ACCEPT_TOKEN(anon_sym_aget_DASHobject);
      END_STATE();
    case 697:
      if (lookahead == 'n') ADVANCE(764);
      END_STATE();
    case 698:
      ACCEPT_TOKEN(anon_sym_aput_DASHobject);
      END_STATE();
    case 699:
      if (lookahead == 'h') ADVANCE(765);
      END_STATE();
    case 700:
      ACCEPT_TOKEN(anon_sym_cmpg_DASHdouble);
      END_STATE();
    case 701:
      ACCEPT_TOKEN(anon_sym_cmpl_DASHdouble);
      END_STATE();
    case 702:
      ACCEPT_TOKEN(anon_sym_const_DASHclass);
      END_STATE();
    case 703:
      if (lookahead == 'd') ADVANCE(766);
      END_STATE();
    case 704:
      ACCEPT_TOKEN(anon_sym_constructor);
      END_STATE();
    case 705:
      if (lookahead == 'r') ADVANCE(767);
      END_STATE();
    case 706:
      if (lookahead == 'n') ADVANCE(768);
      END_STATE();
    case 707:
      if (lookahead == 'l') ADVANCE(769);
      END_STATE();
    case 708:
      if (lookahead == 'n') ADVANCE(770);
      END_STATE();
    case 709:
      if (lookahead == 'o') ADVANCE(771);
      END_STATE();
    case 710:
      if (lookahead == 'd') ADVANCE(772);
      END_STATE();
    case 711:
      if (lookahead == 'u') ADVANCE(773);
      END_STATE();
    case 712:
      if (lookahead == 't') ADVANCE(774);
      END_STATE();
    case 713:
      if (lookahead == 'n') ADVANCE(775);
      END_STATE();
    case 714:
      if (lookahead == 'x') ADVANCE(776);
      END_STATE();
    case 715:
      if (lookahead == 'n') ADVANCE(777);
      END_STATE();
    case 716:
      ACCEPT_TOKEN(anon_sym_iget_DASHobject);
      if (lookahead == '-') ADVANCE(778);
      END_STATE();
    case 717:
      if (lookahead == 'l') ADVANCE(779);
      END_STATE();
    case 718:
      if (lookahead == 'u') ADVANCE(780);
      END_STATE();
    case 719:
      if (lookahead == 'o') ADVANCE(781);
      END_STATE();
    case 720:
      if (lookahead == 't') ADVANCE(782);
      END_STATE();
    case 721:
      ACCEPT_TOKEN(anon_sym_instance_DASHof);
      END_STATE();
    case 722:
      if (lookahead == 't') ADVANCE(783);
      END_STATE();
    case 723:
      ACCEPT_TOKEN(anon_sym_int_DASHto_DASHbyte);
      END_STATE();
    case 724:
      ACCEPT_TOKEN(anon_sym_int_DASHto_DASHchar);
      END_STATE();
    case 725:
      if (lookahead == 'l') ADVANCE(784);
      END_STATE();
    case 726:
      if (lookahead == 't') ADVANCE(785);
      END_STATE();
    case 727:
      ACCEPT_TOKEN(anon_sym_int_DASHto_DASHlong);
      END_STATE();
    case 728:
      if (lookahead == 't') ADVANCE(786);
      END_STATE();
    case 729:
      if (lookahead == 't') ADVANCE(787);
      END_STATE();
    case 730:
      if (lookahead == 'c') ADVANCE(788);
      END_STATE();
    case 731:
      if (lookahead == 'a') ADVANCE(789);
      END_STATE();
    case 732:
      if (lookahead == 'n') ADVANCE(790);
      END_STATE();
    case 733:
      if (lookahead == 'u') ADVANCE(791);
      END_STATE();
    case 734:
      if (lookahead == 'u') ADVANCE(792);
      END_STATE();
    case 735:
      ACCEPT_TOKEN(anon_sym_iput_DASHobject);
      if (lookahead == '-') ADVANCE(793);
      END_STATE();
    case 736:
      if (lookahead == 'q') ADVANCE(794);
      END_STATE();
    case 737:
      if (lookahead == 'l') ADVANCE(795);
      END_STATE();
    case 738:
      if (lookahead == 'u') ADVANCE(796);
      END_STATE();
    case 739:
      if (lookahead == 'o') ADVANCE(797);
      END_STATE();
    case 740:
      if (lookahead == 'b') ADVANCE(798);
      END_STATE();
    case 741:
      if (lookahead == 'a') ADVANCE(799);
      END_STATE();
    case 742:
      ACCEPT_TOKEN(anon_sym_long_DASHto_DASHint);
      END_STATE();
    case 743:
      if (lookahead == 'e') ADVANCE(800);
      END_STATE();
    case 744:
      if (lookahead == 't') ADVANCE(801);
      END_STATE();
    case 745:
      if (lookahead == 'i') ADVANCE(802);
      END_STATE();
    case 746:
      ACCEPT_TOKEN(anon_sym_move_DASHresult);
      if (lookahead == '-') ADVANCE(803);
      END_STATE();
    case 747:
      if (lookahead == 'e') ADVANCE(804);
      END_STATE();
    case 748:
      if (lookahead == 'c') ADVANCE(805);
      END_STATE();
    case 749:
      if (lookahead == 'c') ADVANCE(806);
      END_STATE();
    case 750:
      ACCEPT_TOKEN(anon_sym_return_DASHvoid);
      END_STATE();
    case 751:
      ACCEPT_TOKEN(anon_sym_return_DASHwide);
      END_STATE();
    case 752:
      if (lookahead == 'n') ADVANCE(807);
      END_STATE();
    case 753:
      ACCEPT_TOKEN(anon_sym_sget_DASHobject);
      if (lookahead == '-') ADVANCE(808);
      END_STATE();
    case 754:
      if (lookahead == 'l') ADVANCE(809);
      END_STATE();
    case 755:
      if (lookahead == 'o') ADVANCE(810);
      END_STATE();
    case 756:
      if (lookahead == 'c') ADVANCE(811);
      END_STATE();
    case 757:
      if (lookahead == 'n') ADVANCE(812);
      END_STATE();
    case 758:
      ACCEPT_TOKEN(anon_sym_sput_DASHobject);
      if (lookahead == '-') ADVANCE(813);
      END_STATE();
    case 759:
      if (lookahead == 'l') ADVANCE(814);
      END_STATE();
    case 760:
      if (lookahead == 'o') ADVANCE(815);
      END_STATE();
    case 761:
      if (lookahead == 'd') ADVANCE(816);
      END_STATE();
    case 762:
      if (lookahead == 'i') ADVANCE(817);
      END_STATE();
    case 763:
      ACCEPT_TOKEN(anon_sym_aget_DASHboolean);
      END_STATE();
    case 764:
      ACCEPT_TOKEN(anon_sym_aput_DASHboolean);
      END_STATE();
    case 765:
      ACCEPT_TOKEN(anon_sym_array_DASHlength);
      END_STATE();
    case 766:
      if (lookahead == '-') ADVANCE(818);
      END_STATE();
    case 767:
      if (lookahead == 'm') ADVANCE(819);
      END_STATE();
    case 768:
      if (lookahead == 'c') ADVANCE(820);
      END_STATE();
    case 769:
      if (lookahead == 'o') ADVANCE(821);
      END_STATE();
    case 770:
      if (lookahead == 't') ADVANCE(822);
      END_STATE();
    case 771:
      if (lookahead == 'n') ADVANCE(823);
      END_STATE();
    case 772:
      if (lookahead == 'a') ADVANCE(824);
      END_STATE();
    case 773:
      if (lookahead == 'b') ADVANCE(825);
      END_STATE();
    case 774:
      ACCEPT_TOKEN(anon_sym_float_DASHto_DASHint);
      END_STATE();
    case 775:
      if (lookahead == 'g') ADVANCE(826);
      END_STATE();
    case 776:
      if (lookahead == '-') ADVANCE(827);
      END_STATE();
    case 777:
      ACCEPT_TOKEN(anon_sym_iget_DASHboolean);
      END_STATE();
    case 778:
      if (lookahead == 'q') ADVANCE(828);
      if (lookahead == 'v') ADVANCE(829);
      END_STATE();
    case 779:
      if (lookahead == 'e') ADVANCE(830);
      END_STATE();
    case 780:
      if (lookahead == 'i') ADVANCE(831);
      END_STATE();
    case 781:
      if (lookahead == 'l') ADVANCE(832);
      END_STATE();
    case 782:
      ACCEPT_TOKEN(anon_sym_instance_DASHget);
      END_STATE();
    case 783:
      ACCEPT_TOKEN(anon_sym_instance_DASHput);
      END_STATE();
    case 784:
      if (lookahead == 'e') ADVANCE(833);
      END_STATE();
    case 785:
      ACCEPT_TOKEN(anon_sym_int_DASHto_DASHfloat);
      END_STATE();
    case 786:
      ACCEPT_TOKEN(anon_sym_int_DASHto_DASHshort);
      END_STATE();
    case 787:
      if (lookahead == 'r') ADVANCE(834);
      END_STATE();
    case 788:
      if (lookahead == 't') ADVANCE(835);
      END_STATE();
    case 789:
      if (lookahead == 'n') ADVANCE(836);
      END_STATE();
    case 790:
      ACCEPT_TOKEN(anon_sym_iput_DASHboolean);
      if (lookahead == '-') ADVANCE(837);
      END_STATE();
    case 791:
      if (lookahead == 'i') ADVANCE(838);
      END_STATE();
    case 792:
      if (lookahead == 'i') ADVANCE(839);
      END_STATE();
    case 793:
      if (lookahead == 'q') ADVANCE(840);
      if (lookahead == 'v') ADVANCE(841);
      END_STATE();
    case 794:
      if (lookahead == 'u') ADVANCE(842);
      END_STATE();
    case 795:
      if (lookahead == 'e') ADVANCE(843);
      END_STATE();
    case 796:
      if (lookahead == 'i') ADVANCE(844);
      END_STATE();
    case 797:
      if (lookahead == 'l') ADVANCE(845);
      END_STATE();
    case 798:
      if (lookahead == 'l') ADVANCE(846);
      END_STATE();
    case 799:
      if (lookahead == 't') ADVANCE(847);
      END_STATE();
    case 800:
      if (lookahead == 'r') ADVANCE(848);
      END_STATE();
    case 801:
      ACCEPT_TOKEN(anon_sym_monitor_DASHexit);
      END_STATE();
    case 802:
      if (lookahead == 'o') ADVANCE(849);
      END_STATE();
    case 803:
      if (lookahead == 'o') ADVANCE(850);
      if (lookahead == 'w') ADVANCE(851);
      END_STATE();
    case 804:
      ACCEPT_TOKEN(anon_sym_new_DASHinstance);
      END_STATE();
    case 805:
      if (lookahead == 'h') ADVANCE(852);
      END_STATE();
    case 806:
      if (lookahead == 't') ADVANCE(853);
      END_STATE();
    case 807:
      ACCEPT_TOKEN(anon_sym_sget_DASHboolean);
      END_STATE();
    case 808:
      if (lookahead == 'v') ADVANCE(854);
      END_STATE();
    case 809:
      if (lookahead == 'e') ADVANCE(855);
      END_STATE();
    case 810:
      if (lookahead == 'l') ADVANCE(856);
      END_STATE();
    case 811:
      if (lookahead == 'h') ADVANCE(857);
      END_STATE();
    case 812:
      ACCEPT_TOKEN(anon_sym_sput_DASHboolean);
      END_STATE();
    case 813:
      if (lookahead == 'v') ADVANCE(858);
      END_STATE();
    case 814:
      if (lookahead == 'e') ADVANCE(859);
      END_STATE();
    case 815:
      if (lookahead == 'l') ADVANCE(860);
      END_STATE();
    case 816:
      ACCEPT_TOKEN(anon_sym_synchronized);
      END_STATE();
    case 817:
      if (lookahead == 'c') ADVANCE(861);
      END_STATE();
    case 818:
      if (lookahead == 'h') ADVANCE(862);
      if (lookahead == 't') ADVANCE(863);
      END_STATE();
    case 819:
      if (lookahead == '-') ADVANCE(864);
      END_STATE();
    case 820:
      if (lookahead == 'h') ADVANCE(865);
      END_STATE();
    case 821:
      if (lookahead == 'a') ADVANCE(866);
      END_STATE();
    case 822:
      ACCEPT_TOKEN(anon_sym_double_DASHto_DASHint);
      END_STATE();
    case 823:
      if (lookahead == 'g') ADVANCE(867);
      END_STATE();
    case 824:
      if (lookahead == 't') ADVANCE(868);
      END_STATE();
    case 825:
      if (lookahead == 'l') ADVANCE(869);
      END_STATE();
    case 826:
      ACCEPT_TOKEN(anon_sym_float_DASHto_DASHlong);
      END_STATE();
    case 827:
      if (lookahead == 'o') ADVANCE(870);
      if (lookahead == 'p') ADVANCE(871);
      if (lookahead == 'q') ADVANCE(872);
      if (lookahead == 'r') ADVANCE(873);
      END_STATE();
    case 828:
      if (lookahead == 'u') ADVANCE(874);
      END_STATE();
    case 829:
      if (lookahead == 'o') ADVANCE(875);
      END_STATE();
    case 830:
      ACCEPT_TOKEN(anon_sym_iget_DASHvolatile);
      END_STATE();
    case 831:
      if (lookahead == 'c') ADVANCE(876);
      END_STATE();
    case 832:
      if (lookahead == 'a') ADVANCE(877);
      END_STATE();
    case 833:
      ACCEPT_TOKEN(anon_sym_int_DASHto_DASHdouble);
      END_STATE();
    case 834:
      if (lookahead == 'u') ADVANCE(878);
      END_STATE();
    case 835:
      if (lookahead == '-') ADVANCE(879);
      END_STATE();
    case 836:
      if (lookahead == 'c') ADVANCE(880);
      END_STATE();
    case 837:
      if (lookahead == 'q') ADVANCE(881);
      END_STATE();
    case 838:
      if (lookahead == 'c') ADVANCE(882);
      END_STATE();
    case 839:
      if (lookahead == 'c') ADVANCE(883);
      END_STATE();
    case 840:
      if (lookahead == 'u') ADVANCE(884);
      END_STATE();
    case 841:
      if (lookahead == 'o') ADVANCE(885);
      END_STATE();
    case 842:
      if (lookahead == 'i') ADVANCE(886);
      END_STATE();
    case 843:
      ACCEPT_TOKEN(anon_sym_iput_DASHvolatile);
      END_STATE();
    case 844:
      if (lookahead == 'c') ADVANCE(887);
      END_STATE();
    case 845:
      if (lookahead == 'a') ADVANCE(888);
      END_STATE();
    case 846:
      if (lookahead == 'e') ADVANCE(889);
      END_STATE();
    case 847:
      ACCEPT_TOKEN(anon_sym_long_DASHto_DASHfloat);
      END_STATE();
    case 848:
      ACCEPT_TOKEN(anon_sym_monitor_DASHenter);
      END_STATE();
    case 849:
      if (lookahead == 'n') ADVANCE(890);
      END_STATE();
    case 850:
      if (lookahead == 'b') ADVANCE(891);
      END_STATE();
    case 851:
      if (lookahead == 'i') ADVANCE(892);
      END_STATE();
    case 852:
      ACCEPT_TOKEN(anon_sym_packed_DASHswitch);
      END_STATE();
    case 853:
      ACCEPT_TOKEN(anon_sym_return_DASHobject);
      END_STATE();
    case 854:
      if (lookahead == 'o') ADVANCE(893);
      END_STATE();
    case 855:
      ACCEPT_TOKEN(anon_sym_sget_DASHvolatile);
      END_STATE();
    case 856:
      if (lookahead == 'a') ADVANCE(894);
      END_STATE();
    case 857:
      ACCEPT_TOKEN(anon_sym_sparse_DASHswitch);
      END_STATE();
    case 858:
      if (lookahead == 'o') ADVANCE(895);
      END_STATE();
    case 859:
      ACCEPT_TOKEN(anon_sym_sput_DASHvolatile);
      END_STATE();
    case 860:
      if (lookahead == 'a') ADVANCE(896);
      END_STATE();
    case 861:
      if (lookahead == 'a') ADVANCE(897);
      END_STATE();
    case 862:
      if (lookahead == 'a') ADVANCE(898);
      END_STATE();
    case 863:
      if (lookahead == 'y') ADVANCE(899);
      END_STATE();
    case 864:
      if (lookahead == 'a') ADVANCE(900);
      END_STATE();
    case 865:
      if (lookahead == 'r') ADVANCE(901);
      END_STATE();
    case 866:
      if (lookahead == 't') ADVANCE(902);
      END_STATE();
    case 867:
      ACCEPT_TOKEN(anon_sym_double_DASHto_DASHlong);
      END_STATE();
    case 868:
      if (lookahead == 'a') ADVANCE(903);
      END_STATE();
    case 869:
      if (lookahead == 'e') ADVANCE(904);
      END_STATE();
    case 870:
      ACCEPT_TOKEN(anon_sym_greylist_DASHmax_DASHo);
      END_STATE();
    case 871:
      ACCEPT_TOKEN(anon_sym_greylist_DASHmax_DASHp);
      END_STATE();
    case 872:
      ACCEPT_TOKEN(anon_sym_greylist_DASHmax_DASHq);
      END_STATE();
    case 873:
      ACCEPT_TOKEN(anon_sym_greylist_DASHmax_DASHr);
      END_STATE();
    case 874:
      if (lookahead == 'i') ADVANCE(905);
      END_STATE();
    case 875:
      if (lookahead == 'l') ADVANCE(906);
      END_STATE();
    case 876:
      if (lookahead == 'k') ADVANCE(907);
      END_STATE();
    case 877:
      if (lookahead == 't') ADVANCE(908);
      END_STATE();
    case 878:
      if (lookahead == 'c') ADVANCE(909);
      END_STATE();
    case 879:
      if (lookahead == 'e') ADVANCE(910);
      END_STATE();
    case 880:
      if (lookahead == 'e') ADVANCE(911);
      END_STATE();
    case 881:
      if (lookahead == 'u') ADVANCE(912);
      END_STATE();
    case 882:
      if (lookahead == 'k') ADVANCE(913);
      END_STATE();
    case 883:
      if (lookahead == 'k') ADVANCE(914);
      END_STATE();
    case 884:
      if (lookahead == 'i') ADVANCE(915);
      END_STATE();
    case 885:
      if (lookahead == 'l') ADVANCE(916);
      END_STATE();
    case 886:
      if (lookahead == 'c') ADVANCE(917);
      END_STATE();
    case 887:
      if (lookahead == 'k') ADVANCE(918);
      END_STATE();
    case 888:
      if (lookahead == 't') ADVANCE(919);
      END_STATE();
    case 889:
      ACCEPT_TOKEN(anon_sym_long_DASHto_DASHdouble);
      END_STATE();
    case 890:
      ACCEPT_TOKEN(anon_sym_move_DASHexception);
      END_STATE();
    case 891:
      if (lookahead == 'j') ADVANCE(920);
      END_STATE();
    case 892:
      if (lookahead == 'd') ADVANCE(921);
      END_STATE();
    case 893:
      if (lookahead == 'l') ADVANCE(922);
      END_STATE();
    case 894:
      if (lookahead == 't') ADVANCE(923);
      END_STATE();
    case 895:
      if (lookahead == 'l') ADVANCE(924);
      END_STATE();
    case 896:
      if (lookahead == 't') ADVANCE(925);
      END_STATE();
    case 897:
      if (lookahead == 't') ADVANCE(926);
      END_STATE();
    case 898:
      if (lookahead == 'n') ADVANCE(927);
      END_STATE();
    case 899:
      if (lookahead == 'p') ADVANCE(928);
      END_STATE();
    case 900:
      if (lookahead == 'p') ADVANCE(929);
      END_STATE();
    case 901:
      if (lookahead == 'o') ADVANCE(930);
      END_STATE();
    case 902:
      ACCEPT_TOKEN(anon_sym_double_DASHto_DASHfloat);
      END_STATE();
    case 903:
      ACCEPT_TOKEN(anon_sym_fill_DASHarray_DASHdata);
      END_STATE();
    case 904:
      ACCEPT_TOKEN(anon_sym_float_DASHto_DASHdouble);
      END_STATE();
    case 905:
      if (lookahead == 'c') ADVANCE(931);
      END_STATE();
    case 906:
      if (lookahead == 'a') ADVANCE(932);
      END_STATE();
    case 907:
      ACCEPT_TOKEN(anon_sym_iget_DASHwide_DASHquick);
      END_STATE();
    case 908:
      if (lookahead == 'i') ADVANCE(933);
      END_STATE();
    case 909:
      if (lookahead == 't') ADVANCE(934);
      END_STATE();
    case 910:
      if (lookahead == 'm') ADVANCE(935);
      END_STATE();
    case 911:
      ACCEPT_TOKEN(anon_sym_invoke_DASHinstance);
      END_STATE();
    case 912:
      if (lookahead == 'i') ADVANCE(936);
      END_STATE();
    case 913:
      ACCEPT_TOKEN(anon_sym_iput_DASHbyte_DASHquick);
      END_STATE();
    case 914:
      ACCEPT_TOKEN(anon_sym_iput_DASHchar_DASHquick);
      END_STATE();
    case 915:
      if (lookahead == 'c') ADVANCE(937);
      END_STATE();
    case 916:
      if (lookahead == 'a') ADVANCE(938);
      END_STATE();
    case 917:
      if (lookahead == 'k') ADVANCE(939);
      END_STATE();
    case 918:
      ACCEPT_TOKEN(anon_sym_iput_DASHwide_DASHquick);
      END_STATE();
    case 919:
      if (lookahead == 'i') ADVANCE(940);
      END_STATE();
    case 920:
      if (lookahead == 'e') ADVANCE(941);
      END_STATE();
    case 921:
      if (lookahead == 'e') ADVANCE(942);
      END_STATE();
    case 922:
      if (lookahead == 'a') ADVANCE(943);
      END_STATE();
    case 923:
      if (lookahead == 'i') ADVANCE(944);
      END_STATE();
    case 924:
      if (lookahead == 'a') ADVANCE(945);
      END_STATE();
    case 925:
      if (lookahead == 'i') ADVANCE(946);
      END_STATE();
    case 926:
      if (lookahead == 'i') ADVANCE(947);
      END_STATE();
    case 927:
      if (lookahead == 'd') ADVANCE(948);
      END_STATE();
    case 928:
      if (lookahead == 'e') ADVANCE(949);
      END_STATE();
    case 929:
      if (lookahead == 'i') ADVANCE(950);
      END_STATE();
    case 930:
      if (lookahead == 'n') ADVANCE(951);
      END_STATE();
    case 931:
      if (lookahead == 'k') ADVANCE(952);
      END_STATE();
    case 932:
      if (lookahead == 't') ADVANCE(953);
      END_STATE();
    case 933:
      if (lookahead == 'l') ADVANCE(954);
      END_STATE();
    case 934:
      if (lookahead == 'o') ADVANCE(955);
      END_STATE();
    case 935:
      if (lookahead == 'p') ADVANCE(956);
      END_STATE();
    case 936:
      if (lookahead == 'c') ADVANCE(957);
      END_STATE();
    case 937:
      if (lookahead == 'k') ADVANCE(958);
      END_STATE();
    case 938:
      if (lookahead == 't') ADVANCE(959);
      END_STATE();
    case 939:
      ACCEPT_TOKEN(anon_sym_iput_DASHshort_DASHquick);
      END_STATE();
    case 940:
      if (lookahead == 'l') ADVANCE(960);
      END_STATE();
    case 941:
      if (lookahead == 'c') ADVANCE(961);
      END_STATE();
    case 942:
      ACCEPT_TOKEN(anon_sym_move_DASHresult_DASHwide);
      END_STATE();
    case 943:
      if (lookahead == 't') ADVANCE(962);
      END_STATE();
    case 944:
      if (lookahead == 'l') ADVANCE(963);
      END_STATE();
    case 945:
      if (lookahead == 't') ADVANCE(964);
      END_STATE();
    case 946:
      if (lookahead == 'l') ADVANCE(965);
      END_STATE();
    case 947:
      if (lookahead == 'o') ADVANCE(966);
      END_STATE();
    case 948:
      if (lookahead == 'l') ADVANCE(967);
      END_STATE();
    case 949:
      ACCEPT_TOKEN(anon_sym_const_DASHmethod_DASHtype);
      END_STATE();
    case 950:
      ACCEPT_TOKEN(anon_sym_core_DASHplatform_DASHapi);
      END_STATE();
    case 951:
      if (lookahead == 'i') ADVANCE(968);
      END_STATE();
    case 952:
      ACCEPT_TOKEN(anon_sym_iget_DASHobject_DASHquick);
      END_STATE();
    case 953:
      if (lookahead == 'i') ADVANCE(969);
      END_STATE();
    case 954:
      if (lookahead == 'e') ADVANCE(970);
      END_STATE();
    case 955:
      if (lookahead == 'r') ADVANCE(971);
      END_STATE();
    case 956:
      if (lookahead == 't') ADVANCE(972);
      END_STATE();
    case 957:
      if (lookahead == 'k') ADVANCE(973);
      END_STATE();
    case 958:
      ACCEPT_TOKEN(anon_sym_iput_DASHobject_DASHquick);
      END_STATE();
    case 959:
      if (lookahead == 'i') ADVANCE(974);
      END_STATE();
    case 960:
      if (lookahead == 'e') ADVANCE(975);
      END_STATE();
    case 961:
      if (lookahead == 't') ADVANCE(976);
      END_STATE();
    case 962:
      if (lookahead == 'i') ADVANCE(977);
      END_STATE();
    case 963:
      if (lookahead == 'e') ADVANCE(978);
      END_STATE();
    case 964:
      if (lookahead == 'i') ADVANCE(979);
      END_STATE();
    case 965:
      if (lookahead == 'e') ADVANCE(980);
      END_STATE();
    case 966:
      if (lookahead == 'n') ADVANCE(981);
      END_STATE();
    case 967:
      if (lookahead == 'e') ADVANCE(982);
      END_STATE();
    case 968:
      if (lookahead == 'z') ADVANCE(983);
      END_STATE();
    case 969:
      if (lookahead == 'l') ADVANCE(984);
      END_STATE();
    case 970:
      ACCEPT_TOKEN(anon_sym_iget_DASHwide_DASHvolatile);
      END_STATE();
    case 971:
      ACCEPT_TOKEN(anon_sym_invoke_DASHconstructor);
      END_STATE();
    case 972:
      if (lookahead == 'y') ADVANCE(985);
      END_STATE();
    case 973:
      ACCEPT_TOKEN(anon_sym_iput_DASHboolean_DASHquick);
      END_STATE();
    case 974:
      if (lookahead == 'l') ADVANCE(986);
      END_STATE();
    case 975:
      ACCEPT_TOKEN(anon_sym_iput_DASHwide_DASHvolatile);
      END_STATE();
    case 976:
      ACCEPT_TOKEN(anon_sym_move_DASHresult_DASHobject);
      END_STATE();
    case 977:
      if (lookahead == 'l') ADVANCE(987);
      END_STATE();
    case 978:
      ACCEPT_TOKEN(anon_sym_sget_DASHwide_DASHvolatile);
      END_STATE();
    case 979:
      if (lookahead == 'l') ADVANCE(988);
      END_STATE();
    case 980:
      ACCEPT_TOKEN(anon_sym_sput_DASHwide_DASHvolatile);
      END_STATE();
    case 981:
      if (lookahead == '-') ADVANCE(989);
      END_STATE();
    case 982:
      ACCEPT_TOKEN(anon_sym_const_DASHmethod_DASHhandle);
      END_STATE();
    case 983:
      if (lookahead == 'e') ADVANCE(990);
      END_STATE();
    case 984:
      if (lookahead == 'e') ADVANCE(991);
      END_STATE();
    case 985:
      ACCEPT_TOKEN(anon_sym_invoke_DASHdirect_DASHempty);
      END_STATE();
    case 986:
      if (lookahead == 'e') ADVANCE(992);
      END_STATE();
    case 987:
      if (lookahead == 'e') ADVANCE(993);
      END_STATE();
    case 988:
      if (lookahead == 'e') ADVANCE(994);
      END_STATE();
    case 989:
      if (lookahead == 'e') ADVANCE(995);
      END_STATE();
    case 990:
      if (lookahead == 'd') ADVANCE(996);
      END_STATE();
    case 991:
      ACCEPT_TOKEN(anon_sym_iget_DASHobject_DASHvolatile);
      END_STATE();
    case 992:
      ACCEPT_TOKEN(anon_sym_iput_DASHobject_DASHvolatile);
      END_STATE();
    case 993:
      ACCEPT_TOKEN(anon_sym_sget_DASHobject_DASHvolatile);
      END_STATE();
    case 994:
      ACCEPT_TOKEN(anon_sym_sput_DASHobject_DASHvolatile);
      END_STATE();
    case 995:
      if (lookahead == 'r') ADVANCE(997);
      END_STATE();
    case 996:
      ACCEPT_TOKEN(anon_sym_declared_DASHsynchronized);
      END_STATE();
    case 997:
      if (lookahead == 'r') ADVANCE(998);
      END_STATE();
    case 998:
      if (lookahead == 'o') ADVANCE(999);
      END_STATE();
    case 999:
      if (lookahead == 'r') ADVANCE(1000);
      END_STATE();
    case 1000:
      ACCEPT_TOKEN(anon_sym_throw_DASHverification_DASHerror);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0, .external_lex_state = 1},
  [1] = {.lex_state = 0},
  [2] = {.lex_state = 1, .external_lex_state = 2},
  [3] = {.lex_state = 11, .external_lex_state = 2},
  [4] = {.lex_state = 11, .external_lex_state = 2},
  [5] = {.lex_state = 11, .external_lex_state = 2},
  [6] = {.lex_state = 11, .external_lex_state = 2},
  [7] = {.lex_state = 11, .external_lex_state = 2},
  [8] = {.lex_state = 11, .external_lex_state = 2},
  [9] = {.lex_state = 11, .external_lex_state = 2},
  [10] = {.lex_state = 606},
  [11] = {.lex_state = 606},
  [12] = {.lex_state = 606},
  [13] = {.lex_state = 606},
  [14] = {.lex_state = 606},
  [15] = {.lex_state = 12},
  [16] = {.lex_state = 13},
  [17] = {.lex_state = 606},
  [18] = {.lex_state = 606},
  [19] = {.lex_state = 606},
  [20] = {.lex_state = 606},
  [21] = {.lex_state = 606},
  [22] = {.lex_state = 606},
  [23] = {.lex_state = 606},
  [24] = {.lex_state = 606},
  [25] = {.lex_state = 606},
  [26] = {.lex_state = 606},
  [27] = {.lex_state = 606},
  [28] = {.lex_state = 606},
  [29] = {.lex_state = 606},
  [30] = {.lex_state = 606},
  [31] = {.lex_state = 606},
  [32] = {.lex_state = 606},
  [33] = {.lex_state = 606},
  [34] = {.lex_state = 606},
  [35] = {.lex_state = 606},
  [36] = {.lex_state = 15, .external_lex_state = 2},
  [37] = {.lex_state = 15, .external_lex_state = 2},
  [38] = {.lex_state = 1, .external_lex_state = 2},
  [39] = {.lex_state = 606},
  [40] = {.lex_state = 606},
  [41] = {.lex_state = 606},
  [42] = {.lex_state = 606},
  [43] = {.lex_state = 606},
  [44] = {.lex_state = 606},
  [45] = {.lex_state = 606},
  [46] = {.lex_state = 606},
  [47] = {.lex_state = 606},
  [48] = {.lex_state = 606},
  [49] = {.lex_state = 606},
  [50] = {.lex_state = 606},
  [51] = {.lex_state = 606},
  [52] = {.lex_state = 606},
  [53] = {.lex_state = 606},
  [54] = {.lex_state = 606},
  [55] = {.lex_state = 606},
  [56] = {.lex_state = 606},
  [57] = {.lex_state = 606},
  [58] = {.lex_state = 606},
  [59] = {.lex_state = 606},
  [60] = {.lex_state = 606},
  [61] = {.lex_state = 606},
  [62] = {.lex_state = 606},
  [63] = {.lex_state = 606},
  [64] = {.lex_state = 606},
  [65] = {.lex_state = 606},
  [66] = {.lex_state = 606},
  [67] = {.lex_state = 606},
  [68] = {.lex_state = 606},
  [69] = {.lex_state = 606},
  [70] = {.lex_state = 16, .external_lex_state = 2},
  [71] = {.lex_state = 19},
  [72] = {.lex_state = 19},
  [73] = {.lex_state = 19},
  [74] = {.lex_state = 19},
  [75] = {.lex_state = 14, .external_lex_state = 2},
  [76] = {.lex_state = 19, .external_lex_state = 2},
  [77] = {.lex_state = 19},
  [78] = {.lex_state = 19},
  [79] = {.lex_state = 19},
  [80] = {.lex_state = 19, .external_lex_state = 2},
  [81] = {.lex_state = 19, .external_lex_state = 2},
  [82] = {.lex_state = 19, .external_lex_state = 2},
  [83] = {.lex_state = 607},
  [84] = {.lex_state = 607},
  [85] = {.lex_state = 14},
  [86] = {.lex_state = 14},
  [87] = {.lex_state = 0},
  [88] = {.lex_state = 607},
  [89] = {.lex_state = 607},
  [90] = {.lex_state = 607},
  [91] = {.lex_state = 0},
  [92] = {.lex_state = 0},
  [93] = {.lex_state = 0},
  [94] = {.lex_state = 607},
  [95] = {.lex_state = 607},
  [96] = {.lex_state = 607},
  [97] = {.lex_state = 18, .external_lex_state = 2},
  [98] = {.lex_state = 18, .external_lex_state = 2},
  [99] = {.lex_state = 0},
  [100] = {.lex_state = 607},
  [101] = {.lex_state = 18, .external_lex_state = 2},
  [102] = {.lex_state = 607},
  [103] = {.lex_state = 18, .external_lex_state = 2},
  [104] = {.lex_state = 18, .external_lex_state = 2},
  [105] = {.lex_state = 18, .external_lex_state = 2},
  [106] = {.lex_state = 18, .external_lex_state = 2},
  [107] = {.lex_state = 607},
  [108] = {.lex_state = 607},
  [109] = {.lex_state = 607},
  [110] = {.lex_state = 18, .external_lex_state = 2},
  [111] = {.lex_state = 18, .external_lex_state = 2},
  [112] = {.lex_state = 18, .external_lex_state = 2},
  [113] = {.lex_state = 18, .external_lex_state = 2},
  [114] = {.lex_state = 18, .external_lex_state = 2},
  [115] = {.lex_state = 18, .external_lex_state = 2},
  [116] = {.lex_state = 18, .external_lex_state = 2},
  [117] = {.lex_state = 18, .external_lex_state = 2},
  [118] = {.lex_state = 18, .external_lex_state = 2},
  [119] = {.lex_state = 18, .external_lex_state = 2},
  [120] = {.lex_state = 19, .external_lex_state = 2},
  [121] = {.lex_state = 18, .external_lex_state = 2},
  [122] = {.lex_state = 18, .external_lex_state = 2},
  [123] = {.lex_state = 18, .external_lex_state = 2},
  [124] = {.lex_state = 606},
  [125] = {.lex_state = 18, .external_lex_state = 2},
  [126] = {.lex_state = 0},
  [127] = {.lex_state = 0},
  [128] = {.lex_state = 0},
  [129] = {.lex_state = 18, .external_lex_state = 2},
  [130] = {.lex_state = 0},
  [131] = {.lex_state = 19, .external_lex_state = 2},
  [132] = {.lex_state = 18, .external_lex_state = 2},
  [133] = {.lex_state = 18, .external_lex_state = 2},
  [134] = {.lex_state = 19, .external_lex_state = 2},
  [135] = {.lex_state = 0},
  [136] = {.lex_state = 18, .external_lex_state = 2},
  [137] = {.lex_state = 18, .external_lex_state = 2},
  [138] = {.lex_state = 0},
  [139] = {.lex_state = 18, .external_lex_state = 2},
  [140] = {.lex_state = 0},
  [141] = {.lex_state = 18, .external_lex_state = 2},
  [142] = {.lex_state = 0},
  [143] = {.lex_state = 0},
  [144] = {.lex_state = 0},
  [145] = {.lex_state = 0},
  [146] = {.lex_state = 0},
  [147] = {.lex_state = 0},
  [148] = {.lex_state = 0},
  [149] = {.lex_state = 0},
  [150] = {.lex_state = 18, .external_lex_state = 2},
  [151] = {.lex_state = 0},
  [152] = {.lex_state = 17},
  [153] = {.lex_state = 607},
  [154] = {.lex_state = 606},
  [155] = {.lex_state = 0, .external_lex_state = 2},
  [156] = {.lex_state = 0, .external_lex_state = 2},
  [157] = {.lex_state = 17},
  [158] = {.lex_state = 17},
  [159] = {.lex_state = 0},
  [160] = {.lex_state = 0},
  [161] = {.lex_state = 606},
  [162] = {.lex_state = 17},
  [163] = {.lex_state = 606},
  [164] = {.lex_state = 17},
  [165] = {.lex_state = 17},
  [166] = {.lex_state = 18, .external_lex_state = 2},
  [167] = {.lex_state = 18, .external_lex_state = 2},
  [168] = {.lex_state = 18, .external_lex_state = 2},
  [169] = {.lex_state = 18, .external_lex_state = 2},
  [170] = {.lex_state = 18, .external_lex_state = 2},
  [171] = {.lex_state = 17},
  [172] = {.lex_state = 11},
  [173] = {.lex_state = 607},
  [174] = {.lex_state = 2},
  [175] = {.lex_state = 20},
  [176] = {.lex_state = 19},
  [177] = {.lex_state = 19},
  [178] = {.lex_state = 19},
  [179] = {.lex_state = 20},
  [180] = {.lex_state = 0},
  [181] = {.lex_state = 20},
  [182] = {.lex_state = 18, .external_lex_state = 2},
  [183] = {.lex_state = 0},
  [184] = {.lex_state = 607},
  [185] = {.lex_state = 607},
  [186] = {.lex_state = 0},
  [187] = {.lex_state = 607},
  [188] = {.lex_state = 607},
  [189] = {.lex_state = 607},
  [190] = {.lex_state = 607},
  [191] = {.lex_state = 607},
  [192] = {.lex_state = 607},
  [193] = {.lex_state = 0},
  [194] = {.lex_state = 19},
  [195] = {.lex_state = 19},
  [196] = {.lex_state = 0},
  [197] = {.lex_state = 0},
  [198] = {.lex_state = 0},
  [199] = {.lex_state = 0},
  [200] = {.lex_state = 19},
  [201] = {.lex_state = 11},
  [202] = {.lex_state = 19},
  [203] = {.lex_state = 606},
  [204] = {.lex_state = 606},
  [205] = {.lex_state = 19},
  [206] = {.lex_state = 0},
  [207] = {.lex_state = 607},
  [208] = {.lex_state = 0},
  [209] = {.lex_state = 0},
  [210] = {.lex_state = 19},
  [211] = {.lex_state = 0},
  [212] = {.lex_state = 607},
  [213] = {.lex_state = 0},
  [214] = {.lex_state = 607},
  [215] = {.lex_state = 607},
  [216] = {.lex_state = 607},
  [217] = {.lex_state = 607},
  [218] = {.lex_state = 11},
  [219] = {.lex_state = 607},
  [220] = {.lex_state = 0},
  [221] = {.lex_state = 0},
  [222] = {.lex_state = 19},
  [223] = {.lex_state = 19},
  [224] = {.lex_state = 0},
  [225] = {.lex_state = 19},
  [226] = {.lex_state = 2},
  [227] = {.lex_state = 0},
  [228] = {.lex_state = 15},
  [229] = {.lex_state = 19},
  [230] = {.lex_state = 0},
  [231] = {.lex_state = 15},
  [232] = {.lex_state = 0},
  [233] = {.lex_state = 2},
  [234] = {.lex_state = 0},
  [235] = {.lex_state = 0},
  [236] = {.lex_state = 0},
  [237] = {.lex_state = 0},
  [238] = {.lex_state = 607},
  [239] = {.lex_state = 607},
  [240] = {.lex_state = 0},
  [241] = {.lex_state = 0},
  [242] = {.lex_state = 2},
  [243] = {.lex_state = 15},
  [244] = {.lex_state = 0},
  [245] = {.lex_state = 0},
  [246] = {.lex_state = 0},
  [247] = {.lex_state = 0},
  [248] = {.lex_state = 0},
  [249] = {.lex_state = 0},
  [250] = {.lex_state = 0},
  [251] = {.lex_state = 607},
  [252] = {.lex_state = 0},
  [253] = {.lex_state = 19},
  [254] = {.lex_state = 0},
  [255] = {.lex_state = 19},
  [256] = {.lex_state = 19},
  [257] = {.lex_state = 607},
  [258] = {.lex_state = 15},
  [259] = {.lex_state = 0},
  [260] = {.lex_state = 607},
  [261] = {.lex_state = 19},
  [262] = {.lex_state = 19},
  [263] = {.lex_state = 607},
  [264] = {.lex_state = 0},
  [265] = {.lex_state = 607},
  [266] = {.lex_state = 0},
  [267] = {.lex_state = 2},
  [268] = {.lex_state = 607},
  [269] = {.lex_state = 15},
  [270] = {.lex_state = 19},
  [271] = {.lex_state = 0},
  [272] = {.lex_state = 19},
  [273] = {.lex_state = 0},
  [274] = {.lex_state = 2},
  [275] = {.lex_state = 2},
  [276] = {.lex_state = 2},
  [277] = {.lex_state = 0},
  [278] = {.lex_state = 607},
  [279] = {.lex_state = 15},
  [280] = {.lex_state = 0},
  [281] = {.lex_state = 2},
  [282] = {.lex_state = 2},
  [283] = {.lex_state = 0},
  [284] = {.lex_state = 0},
  [285] = {.lex_state = 2},
  [286] = {.lex_state = 0},
  [287] = {.lex_state = 2},
  [288] = {.lex_state = 2},
  [289] = {.lex_state = 2},
  [290] = {.lex_state = 0, .external_lex_state = 2},
  [291] = {.lex_state = 606},
  [292] = {.lex_state = 0},
  [293] = {.lex_state = 2},
  [294] = {.lex_state = 2},
  [295] = {.lex_state = 2},
  [296] = {.lex_state = 2},
  [297] = {.lex_state = 2},
  [298] = {.lex_state = 2},
  [299] = {.lex_state = 0},
  [300] = {.lex_state = 11},
  [301] = {.lex_state = 2},
  [302] = {.lex_state = 2},
  [303] = {.lex_state = 2},
  [304] = {.lex_state = 2},
  [305] = {.lex_state = 2},
  [306] = {.lex_state = 2},
  [307] = {.lex_state = 0},
  [308] = {.lex_state = 0},
  [309] = {.lex_state = 2},
  [310] = {.lex_state = 0, .external_lex_state = 2},
  [311] = {.lex_state = 15},
  [312] = {.lex_state = 2},
  [313] = {.lex_state = 2},
  [314] = {.lex_state = 2},
  [315] = {.lex_state = 2},
  [316] = {.lex_state = 2},
  [317] = {.lex_state = 2},
  [318] = {.lex_state = 2},
  [319] = {.lex_state = 0, .external_lex_state = 2},
  [320] = {.lex_state = 2},
  [321] = {.lex_state = 2},
  [322] = {.lex_state = 2},
  [323] = {.lex_state = 0, .external_lex_state = 2},
  [324] = {.lex_state = 2},
  [325] = {.lex_state = 0},
  [326] = {.lex_state = 2},
  [327] = {.lex_state = 0, .external_lex_state = 2},
  [328] = {.lex_state = 0},
  [329] = {.lex_state = 606},
  [330] = {.lex_state = 0, .external_lex_state = 2},
  [331] = {.lex_state = 0, .external_lex_state = 2},
  [332] = {.lex_state = 0},
  [333] = {.lex_state = 0, .external_lex_state = 2},
  [334] = {.lex_state = 606},
  [335] = {.lex_state = 0},
  [336] = {.lex_state = 0},
  [337] = {.lex_state = 11},
  [338] = {.lex_state = 0},
  [339] = {.lex_state = 0, .external_lex_state = 2},
  [340] = {.lex_state = 0, .external_lex_state = 2},
  [341] = {.lex_state = 606},
  [342] = {.lex_state = 0},
  [343] = {.lex_state = 11},
  [344] = {.lex_state = 0, .external_lex_state = 2},
  [345] = {.lex_state = 0},
  [346] = {.lex_state = 11},
  [347] = {.lex_state = 0, .external_lex_state = 2},
  [348] = {.lex_state = 606},
  [349] = {.lex_state = 15},
  [350] = {.lex_state = 0},
  [351] = {.lex_state = 2},
  [352] = {.lex_state = 0, .external_lex_state = 2},
  [353] = {.lex_state = 2},
  [354] = {.lex_state = 0, .external_lex_state = 2},
  [355] = {.lex_state = 0},
  [356] = {.lex_state = 11},
  [357] = {.lex_state = 606},
  [358] = {.lex_state = 606},
  [359] = {.lex_state = 0},
  [360] = {.lex_state = 606},
  [361] = {.lex_state = 0},
  [362] = {.lex_state = 0},
  [363] = {.lex_state = 606},
  [364] = {.lex_state = 0},
  [365] = {.lex_state = 0},
  [366] = {.lex_state = 15},
  [367] = {.lex_state = 0},
  [368] = {.lex_state = 0, .external_lex_state = 3},
  [369] = {.lex_state = 19},
  [370] = {.lex_state = 0},
  [371] = {.lex_state = 0, .external_lex_state = 2},
  [372] = {.lex_state = 606},
  [373] = {.lex_state = 0},
  [374] = {.lex_state = 0},
  [375] = {.lex_state = 0},
  [376] = {.lex_state = 0},
  [377] = {.lex_state = 0},
  [378] = {.lex_state = 0, .external_lex_state = 3},
  [379] = {.lex_state = 0},
  [380] = {.lex_state = 19},
  [381] = {.lex_state = 606},
  [382] = {.lex_state = 0},
  [383] = {.lex_state = 19},
  [384] = {.lex_state = 0},
  [385] = {.lex_state = 0},
  [386] = {.lex_state = 15},
  [387] = {.lex_state = 15},
  [388] = {.lex_state = 0},
  [389] = {.lex_state = 0},
  [390] = {.lex_state = 606},
  [391] = {.lex_state = 606},
  [392] = {.lex_state = 0},
  [393] = {.lex_state = 0},
  [394] = {.lex_state = 606},
  [395] = {.lex_state = 606},
  [396] = {.lex_state = 606},
  [397] = {.lex_state = 606},
  [398] = {.lex_state = 0, .external_lex_state = 3},
  [399] = {.lex_state = 0},
  [400] = {.lex_state = 19},
  [401] = {.lex_state = 0, .external_lex_state = 3},
  [402] = {.lex_state = 0},
  [403] = {.lex_state = 0},
  [404] = {.lex_state = 0},
  [405] = {.lex_state = 0, .external_lex_state = 3},
  [406] = {.lex_state = 15},
  [407] = {.lex_state = 606},
  [408] = {.lex_state = 0},
  [409] = {.lex_state = 606},
  [410] = {.lex_state = 0},
  [411] = {.lex_state = 15},
  [412] = {.lex_state = 0},
  [413] = {.lex_state = 0},
  [414] = {.lex_state = 19},
  [415] = {.lex_state = 0},
  [416] = {.lex_state = 0},
  [417] = {.lex_state = 15},
  [418] = {.lex_state = 15},
};

enum {
  ts_external_token_L = 0,
  ts_external_token__class_ident = 1,
};

static const TSSymbol ts_external_scanner_symbol_map[EXTERNAL_TOKEN_COUNT] = {
  [ts_external_token_L] = sym_L,
  [ts_external_token__class_ident] = sym__class_ident,
};

static const bool ts_external_scanner_states[4][EXTERNAL_TOKEN_COUNT] = {
  [1] = {
    [ts_external_token_L] = true,
    [ts_external_token__class_ident] = true,
  },
  [2] = {
    [ts_external_token_L] = true,
  },
  [3] = {
    [ts_external_token__class_ident] = true,
  },
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym_identifier] = ACTIONS(1),
    [anon_sym_DOTclass] = ACTIONS(1),
    [anon_sym_DOTsuper] = ACTIONS(1),
    [anon_sym_DOTsource] = ACTIONS(1),
    [anon_sym_DOTimplements] = ACTIONS(1),
    [anon_sym_DOTfield] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_DOTendfield] = ACTIONS(1),
    [anon_sym_DOTmethod] = ACTIONS(1),
    [anon_sym_DOTendmethod] = ACTIONS(1),
    [anon_sym_DOTannotation] = ACTIONS(1),
    [anon_sym_DOTendannotation] = ACTIONS(1),
    [anon_sym_system] = ACTIONS(1),
    [anon_sym_build] = ACTIONS(1),
    [anon_sym_runtime] = ACTIONS(1),
    [anon_sym_DOTsubannotation] = ACTIONS(1),
    [anon_sym_DOTendsubannotation] = ACTIONS(1),
    [anon_sym_DOTparam] = ACTIONS(1),
    [anon_sym_DOTendparam] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_DOTparameter] = ACTIONS(1),
    [anon_sym_nop] = ACTIONS(1),
    [anon_sym_move] = ACTIONS(1),
    [anon_sym_move_SLASHfrom16] = ACTIONS(1),
    [anon_sym_move_SLASH16] = ACTIONS(1),
    [anon_sym_move_DASHwide] = ACTIONS(1),
    [anon_sym_move_DASHwide_SLASHfrom16] = ACTIONS(1),
    [anon_sym_move_DASHwide_SLASH16] = ACTIONS(1),
    [anon_sym_move_DASHobject] = ACTIONS(1),
    [anon_sym_move_DASHobject_SLASHfrom16] = ACTIONS(1),
    [anon_sym_move_DASHobject_SLASH16] = ACTIONS(1),
    [anon_sym_move_DASHresult] = ACTIONS(1),
    [anon_sym_move_DASHresult_DASHwide] = ACTIONS(1),
    [anon_sym_move_DASHresult_DASHobject] = ACTIONS(1),
    [anon_sym_move_DASHexception] = ACTIONS(1),
    [anon_sym_return_DASHvoid] = ACTIONS(1),
    [anon_sym_return] = ACTIONS(1),
    [anon_sym_return_DASHwide] = ACTIONS(1),
    [anon_sym_return_DASHobject] = ACTIONS(1),
    [anon_sym_const_SLASH4] = ACTIONS(1),
    [anon_sym_const_SLASH16] = ACTIONS(1),
    [anon_sym_const] = ACTIONS(1),
    [anon_sym_const_SLASHhigh16] = ACTIONS(1),
    [anon_sym_const_DASHwide_SLASH16] = ACTIONS(1),
    [anon_sym_const_DASHwide_SLASH32] = ACTIONS(1),
    [anon_sym_const_DASHwide] = ACTIONS(1),
    [anon_sym_const_DASHwide_SLASHhigh16] = ACTIONS(1),
    [anon_sym_const_DASHstring] = ACTIONS(1),
    [anon_sym_const_DASHstring_SLASHjumbo] = ACTIONS(1),
    [anon_sym_const_DASHclass] = ACTIONS(1),
    [anon_sym_const_DASHmethod_DASHhandle] = ACTIONS(1),
    [anon_sym_const_DASHmethod_DASHtype] = ACTIONS(1),
    [anon_sym_monitor_DASHenter] = ACTIONS(1),
    [anon_sym_monitor_DASHexit] = ACTIONS(1),
    [anon_sym_check_DASHcast] = ACTIONS(1),
    [anon_sym_instance_DASHof] = ACTIONS(1),
    [anon_sym_array_DASHlength] = ACTIONS(1),
    [anon_sym_new_DASHinstance] = ACTIONS(1),
    [anon_sym_new_DASHarray] = ACTIONS(1),
    [anon_sym_filled_DASHnew_DASHarray] = ACTIONS(1),
    [anon_sym_filled_DASHnew_DASHarray_SLASHrange] = ACTIONS(1),
    [anon_sym_fill_DASHarray_DASHdata] = ACTIONS(1),
    [anon_sym_throw] = ACTIONS(1),
    [anon_sym_throw_DASHverification_DASHerror] = ACTIONS(1),
    [anon_sym_goto] = ACTIONS(1),
    [anon_sym_goto_SLASH16] = ACTIONS(1),
    [anon_sym_goto_SLASH32] = ACTIONS(1),
    [anon_sym_packed_DASHswitch] = ACTIONS(1),
    [anon_sym_sparse_DASHswitch] = ACTIONS(1),
    [anon_sym_cmpl_DASHfloat] = ACTIONS(1),
    [anon_sym_cmpg_DASHfloat] = ACTIONS(1),
    [anon_sym_cmpl_DASHdouble] = ACTIONS(1),
    [anon_sym_cmpg_DASHdouble] = ACTIONS(1),
    [anon_sym_cmp_DASHlong] = ACTIONS(1),
    [anon_sym_if_DASHeq] = ACTIONS(1),
    [anon_sym_if_DASHne] = ACTIONS(1),
    [anon_sym_if_DASHlt] = ACTIONS(1),
    [anon_sym_if_DASHge] = ACTIONS(1),
    [anon_sym_if_DASHgt] = ACTIONS(1),
    [anon_sym_if_DASHle] = ACTIONS(1),
    [anon_sym_if_DASHeqz] = ACTIONS(1),
    [anon_sym_if_DASHnez] = ACTIONS(1),
    [anon_sym_if_DASHltz] = ACTIONS(1),
    [anon_sym_if_DASHgez] = ACTIONS(1),
    [anon_sym_if_DASHgtz] = ACTIONS(1),
    [anon_sym_if_DASHlez] = ACTIONS(1),
    [anon_sym_aget] = ACTIONS(1),
    [anon_sym_aget_DASHwide] = ACTIONS(1),
    [anon_sym_aget_DASHobject] = ACTIONS(1),
    [anon_sym_aget_DASHboolean] = ACTIONS(1),
    [anon_sym_aget_DASHbyte] = ACTIONS(1),
    [anon_sym_aget_DASHchar] = ACTIONS(1),
    [anon_sym_aget_DASHshort] = ACTIONS(1),
    [anon_sym_aput] = ACTIONS(1),
    [anon_sym_aput_DASHwide] = ACTIONS(1),
    [anon_sym_aput_DASHobject] = ACTIONS(1),
    [anon_sym_aput_DASHboolean] = ACTIONS(1),
    [anon_sym_aput_DASHbyte] = ACTIONS(1),
    [anon_sym_aput_DASHchar] = ACTIONS(1),
    [anon_sym_aput_DASHshort] = ACTIONS(1),
    [anon_sym_iget] = ACTIONS(1),
    [anon_sym_iget_DASHwide] = ACTIONS(1),
    [anon_sym_iget_DASHobject] = ACTIONS(1),
    [anon_sym_iget_DASHboolean] = ACTIONS(1),
    [anon_sym_iget_DASHbyte] = ACTIONS(1),
    [anon_sym_iget_DASHchar] = ACTIONS(1),
    [anon_sym_iget_DASHshort] = ACTIONS(1),
    [anon_sym_iget_DASHvolatile] = ACTIONS(1),
    [anon_sym_iget_DASHwide_DASHvolatile] = ACTIONS(1),
    [anon_sym_iget_DASHobject_DASHvolatile] = ACTIONS(1),
    [anon_sym_iput] = ACTIONS(1),
    [anon_sym_iput_DASHwide] = ACTIONS(1),
    [anon_sym_iput_DASHobject] = ACTIONS(1),
    [anon_sym_iput_DASHboolean] = ACTIONS(1),
    [anon_sym_iput_DASHbyte] = ACTIONS(1),
    [anon_sym_iput_DASHchar] = ACTIONS(1),
    [anon_sym_iput_DASHshort] = ACTIONS(1),
    [anon_sym_iput_DASHvolatile] = ACTIONS(1),
    [anon_sym_iput_DASHwide_DASHvolatile] = ACTIONS(1),
    [anon_sym_iput_DASHobject_DASHvolatile] = ACTIONS(1),
    [anon_sym_sget] = ACTIONS(1),
    [anon_sym_sget_DASHwide] = ACTIONS(1),
    [anon_sym_sget_DASHobject] = ACTIONS(1),
    [anon_sym_sget_DASHboolean] = ACTIONS(1),
    [anon_sym_sget_DASHbyte] = ACTIONS(1),
    [anon_sym_sget_DASHchar] = ACTIONS(1),
    [anon_sym_sget_DASHshort] = ACTIONS(1),
    [anon_sym_sget_DASHvolatile] = ACTIONS(1),
    [anon_sym_sget_DASHwide_DASHvolatile] = ACTIONS(1),
    [anon_sym_sget_DASHobject_DASHvolatile] = ACTIONS(1),
    [anon_sym_sput] = ACTIONS(1),
    [anon_sym_sput_DASHwide] = ACTIONS(1),
    [anon_sym_sput_DASHobject] = ACTIONS(1),
    [anon_sym_sput_DASHboolean] = ACTIONS(1),
    [anon_sym_sput_DASHbyte] = ACTIONS(1),
    [anon_sym_sput_DASHchar] = ACTIONS(1),
    [anon_sym_sput_DASHshort] = ACTIONS(1),
    [anon_sym_sput_DASHvolatile] = ACTIONS(1),
    [anon_sym_sput_DASHwide_DASHvolatile] = ACTIONS(1),
    [anon_sym_sput_DASHobject_DASHvolatile] = ACTIONS(1),
    [anon_sym_invoke_DASHconstructor] = ACTIONS(1),
    [anon_sym_invoke_DASHcustom] = ACTIONS(1),
    [anon_sym_invoke_DASHdirect] = ACTIONS(1),
    [anon_sym_invoke_DASHdirect_DASHempty] = ACTIONS(1),
    [anon_sym_invoke_DASHinstance] = ACTIONS(1),
    [anon_sym_invoke_DASHinterface] = ACTIONS(1),
    [anon_sym_invoke_DASHpolymorphic] = ACTIONS(1),
    [anon_sym_invoke_DASHstatic] = ACTIONS(1),
    [anon_sym_invoke_DASHsuper] = ACTIONS(1),
    [anon_sym_invoke_DASHvirtual] = ACTIONS(1),
    [anon_sym_invoke_DASHcustom_SLASHrange] = ACTIONS(1),
    [anon_sym_invoke_DASHdirect_SLASHrange] = ACTIONS(1),
    [anon_sym_invoke_DASHinterface_SLASHrange] = ACTIONS(1),
    [anon_sym_invoke_DASHobject_DASHinit_SLASHrange] = ACTIONS(1),
    [anon_sym_invoke_DASHpolymorphic_SLASHrange] = ACTIONS(1),
    [anon_sym_invoke_DASHstatic_SLASHrange] = ACTIONS(1),
    [anon_sym_invoke_DASHsuper_SLASHrange] = ACTIONS(1),
    [anon_sym_invoke_DASHvirtual_SLASHrange] = ACTIONS(1),
    [anon_sym_neg_DASHint] = ACTIONS(1),
    [anon_sym_not_DASHint] = ACTIONS(1),
    [anon_sym_neg_DASHlong] = ACTIONS(1),
    [anon_sym_not_DASHlong] = ACTIONS(1),
    [anon_sym_neg_DASHfloat] = ACTIONS(1),
    [anon_sym_neg_DASHdouble] = ACTIONS(1),
    [anon_sym_int_DASHto_DASHlong] = ACTIONS(1),
    [anon_sym_int_DASHto_DASHfloat] = ACTIONS(1),
    [anon_sym_int_DASHto_DASHdouble] = ACTIONS(1),
    [anon_sym_long_DASHto_DASHint] = ACTIONS(1),
    [anon_sym_long_DASHto_DASHfloat] = ACTIONS(1),
    [anon_sym_long_DASHto_DASHdouble] = ACTIONS(1),
    [anon_sym_float_DASHto_DASHint] = ACTIONS(1),
    [anon_sym_float_DASHto_DASHlong] = ACTIONS(1),
    [anon_sym_float_DASHto_DASHdouble] = ACTIONS(1),
    [anon_sym_double_DASHto_DASHint] = ACTIONS(1),
    [anon_sym_double_DASHto_DASHlong] = ACTIONS(1),
    [anon_sym_double_DASHto_DASHfloat] = ACTIONS(1),
    [anon_sym_int_DASHto_DASHbyte] = ACTIONS(1),
    [anon_sym_int_DASHto_DASHchar] = ACTIONS(1),
    [anon_sym_int_DASHto_DASHshort] = ACTIONS(1),
    [anon_sym_add_DASHint] = ACTIONS(1),
    [anon_sym_sub_DASHint] = ACTIONS(1),
    [anon_sym_mul_DASHint] = ACTIONS(1),
    [anon_sym_div_DASHint] = ACTIONS(1),
    [anon_sym_rem_DASHint] = ACTIONS(1),
    [anon_sym_and_DASHint] = ACTIONS(1),
    [anon_sym_or_DASHint] = ACTIONS(1),
    [anon_sym_xor_DASHint] = ACTIONS(1),
    [anon_sym_shl_DASHint] = ACTIONS(1),
    [anon_sym_shr_DASHint] = ACTIONS(1),
    [anon_sym_ushr_DASHint] = ACTIONS(1),
    [anon_sym_add_DASHlong] = ACTIONS(1),
    [anon_sym_sub_DASHlong] = ACTIONS(1),
    [anon_sym_mul_DASHlong] = ACTIONS(1),
    [anon_sym_div_DASHlong] = ACTIONS(1),
    [anon_sym_rem_DASHlong] = ACTIONS(1),
    [anon_sym_and_DASHlong] = ACTIONS(1),
    [anon_sym_or_DASHlong] = ACTIONS(1),
    [anon_sym_xor_DASHlong] = ACTIONS(1),
    [anon_sym_shl_DASHlong] = ACTIONS(1),
    [anon_sym_shr_DASHlong] = ACTIONS(1),
    [anon_sym_ushr_DASHlong] = ACTIONS(1),
    [anon_sym_add_DASHfloat] = ACTIONS(1),
    [anon_sym_sub_DASHfloat] = ACTIONS(1),
    [anon_sym_mul_DASHfloat] = ACTIONS(1),
    [anon_sym_div_DASHfloat] = ACTIONS(1),
    [anon_sym_rem_DASHfloat] = ACTIONS(1),
    [anon_sym_add_DASHdouble] = ACTIONS(1),
    [anon_sym_sub_DASHdouble] = ACTIONS(1),
    [anon_sym_mul_DASHdouble] = ACTIONS(1),
    [anon_sym_div_DASHdouble] = ACTIONS(1),
    [anon_sym_rem_DASHdouble] = ACTIONS(1),
    [anon_sym_add_DASHint_SLASH2addr] = ACTIONS(1),
    [anon_sym_sub_DASHint_SLASH2addr] = ACTIONS(1),
    [anon_sym_mul_DASHint_SLASH2addr] = ACTIONS(1),
    [anon_sym_div_DASHint_SLASH2addr] = ACTIONS(1),
    [anon_sym_rem_DASHint_SLASH2addr] = ACTIONS(1),
    [anon_sym_and_DASHint_SLASH2addr] = ACTIONS(1),
    [anon_sym_or_DASHint_SLASH2addr] = ACTIONS(1),
    [anon_sym_xor_DASHint_SLASH2addr] = ACTIONS(1),
    [anon_sym_shl_DASHint_SLASH2addr] = ACTIONS(1),
    [anon_sym_shr_DASHint_SLASH2addr] = ACTIONS(1),
    [anon_sym_ushr_DASHint_SLASH2addr] = ACTIONS(1),
    [anon_sym_add_DASHlong_SLASH2addr] = ACTIONS(1),
    [anon_sym_sub_DASHlong_SLASH2addr] = ACTIONS(1),
    [anon_sym_mul_DASHlong_SLASH2addr] = ACTIONS(1),
    [anon_sym_div_DASHlong_SLASH2addr] = ACTIONS(1),
    [anon_sym_rem_DASHlong_SLASH2addr] = ACTIONS(1),
    [anon_sym_and_DASHlong_SLASH2addr] = ACTIONS(1),
    [anon_sym_or_DASHlong_SLASH2addr] = ACTIONS(1),
    [anon_sym_xor_DASHlong_SLASH2addr] = ACTIONS(1),
    [anon_sym_shl_DASHlong_SLASH2addr] = ACTIONS(1),
    [anon_sym_shr_DASHlong_SLASH2addr] = ACTIONS(1),
    [anon_sym_ushr_DASHlong_SLASH2addr] = ACTIONS(1),
    [anon_sym_add_DASHfloat_SLASH2addr] = ACTIONS(1),
    [anon_sym_sub_DASHfloat_SLASH2addr] = ACTIONS(1),
    [anon_sym_mul_DASHfloat_SLASH2addr] = ACTIONS(1),
    [anon_sym_div_DASHfloat_SLASH2addr] = ACTIONS(1),
    [anon_sym_rem_DASHfloat_SLASH2addr] = ACTIONS(1),
    [anon_sym_add_DASHdouble_SLASH2addr] = ACTIONS(1),
    [anon_sym_sub_DASHdouble_SLASH2addr] = ACTIONS(1),
    [anon_sym_mul_DASHdouble_SLASH2addr] = ACTIONS(1),
    [anon_sym_div_DASHdouble_SLASH2addr] = ACTIONS(1),
    [anon_sym_rem_DASHdouble_SLASH2addr] = ACTIONS(1),
    [anon_sym_add_DASHint_SLASHlit16] = ACTIONS(1),
    [anon_sym_sub_DASHint_SLASHlit16] = ACTIONS(1),
    [anon_sym_mul_DASHint_SLASHlit16] = ACTIONS(1),
    [anon_sym_div_DASHint_SLASHlit16] = ACTIONS(1),
    [anon_sym_rem_DASHint_SLASHlit16] = ACTIONS(1),
    [anon_sym_and_DASHint_SLASHlit16] = ACTIONS(1),
    [anon_sym_or_DASHint_SLASHlit16] = ACTIONS(1),
    [anon_sym_xor_DASHint_SLASHlit16] = ACTIONS(1),
    [anon_sym_add_DASHint_SLASHlit8] = ACTIONS(1),
    [anon_sym_sub_DASHint_SLASHlit8] = ACTIONS(1),
    [anon_sym_mul_DASHint_SLASHlit8] = ACTIONS(1),
    [anon_sym_div_DASHint_SLASHlit8] = ACTIONS(1),
    [anon_sym_rem_DASHint_SLASHlit8] = ACTIONS(1),
    [anon_sym_and_DASHint_SLASHlit8] = ACTIONS(1),
    [anon_sym_or_DASHint_SLASHlit8] = ACTIONS(1),
    [anon_sym_xor_DASHint_SLASHlit8] = ACTIONS(1),
    [anon_sym_shl_DASHint_SLASHlit8] = ACTIONS(1),
    [anon_sym_shr_DASHint_SLASHlit8] = ACTIONS(1),
    [anon_sym_ushr_DASHint_SLASHlit8] = ACTIONS(1),
    [anon_sym_static_DASHget] = ACTIONS(1),
    [anon_sym_static_DASHput] = ACTIONS(1),
    [anon_sym_instance_DASHget] = ACTIONS(1),
    [anon_sym_instance_DASHput] = ACTIONS(1),
    [anon_sym_execute_DASHinline] = ACTIONS(1),
    [anon_sym_execute_DASHinline_SLASHrange] = ACTIONS(1),
    [anon_sym_iget_DASHquick] = ACTIONS(1),
    [anon_sym_iget_DASHwide_DASHquick] = ACTIONS(1),
    [anon_sym_iget_DASHobject_DASHquick] = ACTIONS(1),
    [anon_sym_iput_DASHquick] = ACTIONS(1),
    [anon_sym_iput_DASHwide_DASHquick] = ACTIONS(1),
    [anon_sym_iput_DASHobject_DASHquick] = ACTIONS(1),
    [anon_sym_iput_DASHboolean_DASHquick] = ACTIONS(1),
    [anon_sym_iput_DASHbyte_DASHquick] = ACTIONS(1),
    [anon_sym_iput_DASHchar_DASHquick] = ACTIONS(1),
    [anon_sym_iput_DASHshort_DASHquick] = ACTIONS(1),
    [anon_sym_invoke_DASHvirtual_DASHquick] = ACTIONS(1),
    [anon_sym_invoke_DASHvirtual_DASHquick_SLASHrange] = ACTIONS(1),
    [anon_sym_invoke_DASHsuper_DASHquick] = ACTIONS(1),
    [anon_sym_invoke_DASHsuper_DASHquick_SLASHrange] = ACTIONS(1),
    [anon_sym_rsub_DASHint] = ACTIONS(1),
    [anon_sym_rsub_DASHint_SLASHlit8] = ACTIONS(1),
    [anon_sym_DOTline] = ACTIONS(1),
    [anon_sym_DOTlocals] = ACTIONS(1),
    [anon_sym_DOTlocal] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_DOTendlocal] = ACTIONS(1),
    [anon_sym_DOTrestartlocal] = ACTIONS(1),
    [anon_sym_DOTregisters] = ACTIONS(1),
    [anon_sym_DOTcatch] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_DOT_DOT] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_DOTcatchall] = ACTIONS(1),
    [anon_sym_DOTpacked_DASHswitch] = ACTIONS(1),
    [anon_sym_DOTendpacked_DASHswitch] = ACTIONS(1),
    [anon_sym_DOTsparse_DASHswitch] = ACTIONS(1),
    [anon_sym_DASH_GT] = ACTIONS(1),
    [anon_sym_DOTendsparse_DASHswitch] = ACTIONS(1),
    [anon_sym_DOTarray_DASHdata] = ACTIONS(1),
    [anon_sym_DOTendarray_DASHdata] = ACTIONS(1),
    [sym_prologue_directive] = ACTIONS(1),
    [sym_epilogue_directive] = ACTIONS(1),
    [anon_sym_SLASH] = ACTIONS(1),
    [anon_sym_SEMI] = ACTIONS(1),
    [anon_sym_DASH] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_AT] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [aux_sym_primitive_type_token1] = ACTIONS(1),
    [aux_sym_primitive_type_token2] = ACTIONS(1),
    [anon_sym_constructor] = ACTIONS(1),
    [anon_sym_public] = ACTIONS(1),
    [anon_sym_private] = ACTIONS(1),
    [anon_sym_protected] = ACTIONS(1),
    [anon_sym_static] = ACTIONS(1),
    [anon_sym_final] = ACTIONS(1),
    [anon_sym_synchronized] = ACTIONS(1),
    [anon_sym_volatile] = ACTIONS(1),
    [anon_sym_bridge] = ACTIONS(1),
    [anon_sym_transient] = ACTIONS(1),
    [anon_sym_varargs] = ACTIONS(1),
    [anon_sym_native] = ACTIONS(1),
    [anon_sym_interface] = ACTIONS(1),
    [anon_sym_abstract] = ACTIONS(1),
    [anon_sym_strictfp] = ACTIONS(1),
    [anon_sym_synthetic] = ACTIONS(1),
    [anon_sym_annotation] = ACTIONS(1),
    [anon_sym_enum] = ACTIONS(1),
    [anon_sym_declared_DASHsynchronized] = ACTIONS(1),
    [anon_sym_whitelist] = ACTIONS(1),
    [anon_sym_greylist] = ACTIONS(1),
    [anon_sym_blacklist] = ACTIONS(1),
    [anon_sym_greylist_DASHmax_DASHo] = ACTIONS(1),
    [anon_sym_greylist_DASHmax_DASHp] = ACTIONS(1),
    [anon_sym_greylist_DASHmax_DASHq] = ACTIONS(1),
    [anon_sym_greylist_DASHmax_DASHr] = ACTIONS(1),
    [anon_sym_core_DASHplatform_DASHapi] = ACTIONS(1),
    [anon_sym_test_DASHapi] = ACTIONS(1),
    [anon_sym_DOTenum] = ACTIONS(1),
    [sym_variable] = ACTIONS(1),
    [sym_parameter] = ACTIONS(1),
    [sym_number] = ACTIONS(1),
    [sym_float] = ACTIONS(1),
    [sym_NaN] = ACTIONS(1),
    [sym_Infinity] = ACTIONS(1),
    [anon_sym_DQUOTE] = ACTIONS(1),
    [aux_sym__escape_sequence_token1] = ACTIONS(1),
    [sym_escape_sequence] = ACTIONS(1),
    [anon_sym_true] = ACTIONS(1),
    [anon_sym_false] = ACTIONS(1),
    [anon_sym_SQUOTE] = ACTIONS(1),
    [sym_null] = ACTIONS(1),
    [sym_comment] = ACTIONS(3),
    [sym_L] = ACTIONS(1),
    [sym__class_ident] = ACTIONS(1),
  },
  [1] = {
    [sym_class_definition] = STATE(412),
    [sym_class_directive] = STATE(325),
    [anon_sym_DOTclass] = ACTIONS(5),
    [sym_comment] = ACTIONS(3),
  },
  [2] = {
    [sym_subannotation_directive] = STATE(314),
    [sym_opcode] = STATE(385),
    [sym_value] = STATE(226),
    [sym_class_identifier] = STATE(276),
    [sym_label] = STATE(314),
    [sym_jmp_label] = STATE(314),
    [sym_body] = STATE(314),
    [sym__field_body] = STATE(313),
    [sym_method_signature] = STATE(313),
    [sym__method_signature_body] = STATE(312),
    [sym_method_handle] = STATE(314),
    [sym__full_field_body] = STATE(313),
    [sym_full_method_signature] = STATE(313),
    [sym_custom_invoke] = STATE(314),
    [sym_type] = STATE(314),
    [sym_array_type] = STATE(276),
    [sym_primitive_type] = STATE(274),
    [sym_enum_reference] = STATE(314),
    [sym_register] = STATE(314),
    [sym_list] = STATE(314),
    [sym_range] = STATE(314),
    [sym_literal] = STATE(314),
    [sym_string] = STATE(316),
    [sym_boolean] = STATE(316),
    [sym_character] = STATE(316),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_DOTsubannotation] = ACTIONS(9),
    [anon_sym_LF] = ACTIONS(11),
    [anon_sym_nop] = ACTIONS(13),
    [anon_sym_move] = ACTIONS(13),
    [anon_sym_move_SLASHfrom16] = ACTIONS(13),
    [anon_sym_move_SLASH16] = ACTIONS(13),
    [anon_sym_move_DASHwide] = ACTIONS(13),
    [anon_sym_move_DASHwide_SLASHfrom16] = ACTIONS(13),
    [anon_sym_move_DASHwide_SLASH16] = ACTIONS(13),
    [anon_sym_move_DASHobject] = ACTIONS(13),
    [anon_sym_move_DASHobject_SLASHfrom16] = ACTIONS(13),
    [anon_sym_move_DASHobject_SLASH16] = ACTIONS(13),
    [anon_sym_move_DASHresult] = ACTIONS(13),
    [anon_sym_move_DASHresult_DASHwide] = ACTIONS(13),
    [anon_sym_move_DASHresult_DASHobject] = ACTIONS(13),
    [anon_sym_move_DASHexception] = ACTIONS(13),
    [anon_sym_return_DASHvoid] = ACTIONS(13),
    [anon_sym_return] = ACTIONS(13),
    [anon_sym_return_DASHwide] = ACTIONS(13),
    [anon_sym_return_DASHobject] = ACTIONS(13),
    [anon_sym_const_SLASH4] = ACTIONS(13),
    [anon_sym_const_SLASH16] = ACTIONS(13),
    [anon_sym_const] = ACTIONS(13),
    [anon_sym_const_SLASHhigh16] = ACTIONS(13),
    [anon_sym_const_DASHwide_SLASH16] = ACTIONS(13),
    [anon_sym_const_DASHwide_SLASH32] = ACTIONS(13),
    [anon_sym_const_DASHwide] = ACTIONS(13),
    [anon_sym_const_DASHwide_SLASHhigh16] = ACTIONS(13),
    [anon_sym_const_DASHstring] = ACTIONS(13),
    [anon_sym_const_DASHstring_SLASHjumbo] = ACTIONS(13),
    [anon_sym_const_DASHclass] = ACTIONS(13),
    [anon_sym_const_DASHmethod_DASHhandle] = ACTIONS(13),
    [anon_sym_const_DASHmethod_DASHtype] = ACTIONS(13),
    [anon_sym_monitor_DASHenter] = ACTIONS(13),
    [anon_sym_monitor_DASHexit] = ACTIONS(13),
    [anon_sym_check_DASHcast] = ACTIONS(13),
    [anon_sym_instance_DASHof] = ACTIONS(13),
    [anon_sym_array_DASHlength] = ACTIONS(13),
    [anon_sym_new_DASHinstance] = ACTIONS(13),
    [anon_sym_new_DASHarray] = ACTIONS(13),
    [anon_sym_filled_DASHnew_DASHarray] = ACTIONS(13),
    [anon_sym_filled_DASHnew_DASHarray_SLASHrange] = ACTIONS(13),
    [anon_sym_fill_DASHarray_DASHdata] = ACTIONS(13),
    [anon_sym_throw] = ACTIONS(13),
    [anon_sym_throw_DASHverification_DASHerror] = ACTIONS(13),
    [anon_sym_goto] = ACTIONS(13),
    [anon_sym_goto_SLASH16] = ACTIONS(13),
    [anon_sym_goto_SLASH32] = ACTIONS(13),
    [anon_sym_packed_DASHswitch] = ACTIONS(13),
    [anon_sym_sparse_DASHswitch] = ACTIONS(13),
    [anon_sym_cmpl_DASHfloat] = ACTIONS(13),
    [anon_sym_cmpg_DASHfloat] = ACTIONS(13),
    [anon_sym_cmpl_DASHdouble] = ACTIONS(13),
    [anon_sym_cmpg_DASHdouble] = ACTIONS(13),
    [anon_sym_cmp_DASHlong] = ACTIONS(13),
    [anon_sym_if_DASHeq] = ACTIONS(13),
    [anon_sym_if_DASHne] = ACTIONS(13),
    [anon_sym_if_DASHlt] = ACTIONS(13),
    [anon_sym_if_DASHge] = ACTIONS(13),
    [anon_sym_if_DASHgt] = ACTIONS(13),
    [anon_sym_if_DASHle] = ACTIONS(13),
    [anon_sym_if_DASHeqz] = ACTIONS(13),
    [anon_sym_if_DASHnez] = ACTIONS(13),
    [anon_sym_if_DASHltz] = ACTIONS(13),
    [anon_sym_if_DASHgez] = ACTIONS(13),
    [anon_sym_if_DASHgtz] = ACTIONS(13),
    [anon_sym_if_DASHlez] = ACTIONS(13),
    [anon_sym_aget] = ACTIONS(13),
    [anon_sym_aget_DASHwide] = ACTIONS(13),
    [anon_sym_aget_DASHobject] = ACTIONS(13),
    [anon_sym_aget_DASHboolean] = ACTIONS(13),
    [anon_sym_aget_DASHbyte] = ACTIONS(13),
    [anon_sym_aget_DASHchar] = ACTIONS(13),
    [anon_sym_aget_DASHshort] = ACTIONS(13),
    [anon_sym_aput] = ACTIONS(13),
    [anon_sym_aput_DASHwide] = ACTIONS(13),
    [anon_sym_aput_DASHobject] = ACTIONS(13),
    [anon_sym_aput_DASHboolean] = ACTIONS(13),
    [anon_sym_aput_DASHbyte] = ACTIONS(13),
    [anon_sym_aput_DASHchar] = ACTIONS(13),
    [anon_sym_aput_DASHshort] = ACTIONS(13),
    [anon_sym_iget] = ACTIONS(13),
    [anon_sym_iget_DASHwide] = ACTIONS(13),
    [anon_sym_iget_DASHobject] = ACTIONS(13),
    [anon_sym_iget_DASHboolean] = ACTIONS(13),
    [anon_sym_iget_DASHbyte] = ACTIONS(13),
    [anon_sym_iget_DASHchar] = ACTIONS(13),
    [anon_sym_iget_DASHshort] = ACTIONS(13),
    [anon_sym_iget_DASHvolatile] = ACTIONS(13),
    [anon_sym_iget_DASHwide_DASHvolatile] = ACTIONS(13),
    [anon_sym_iget_DASHobject_DASHvolatile] = ACTIONS(13),
    [anon_sym_iput] = ACTIONS(13),
    [anon_sym_iput_DASHwide] = ACTIONS(13),
    [anon_sym_iput_DASHobject] = ACTIONS(13),
    [anon_sym_iput_DASHboolean] = ACTIONS(13),
    [anon_sym_iput_DASHbyte] = ACTIONS(13),
    [anon_sym_iput_DASHchar] = ACTIONS(13),
    [anon_sym_iput_DASHshort] = ACTIONS(13),
    [anon_sym_iput_DASHvolatile] = ACTIONS(13),
    [anon_sym_iput_DASHwide_DASHvolatile] = ACTIONS(13),
    [anon_sym_iput_DASHobject_DASHvolatile] = ACTIONS(13),
    [anon_sym_sget] = ACTIONS(13),
    [anon_sym_sget_DASHwide] = ACTIONS(13),
    [anon_sym_sget_DASHobject] = ACTIONS(13),
    [anon_sym_sget_DASHboolean] = ACTIONS(13),
    [anon_sym_sget_DASHbyte] = ACTIONS(13),
    [anon_sym_sget_DASHchar] = ACTIONS(13),
    [anon_sym_sget_DASHshort] = ACTIONS(13),
    [anon_sym_sget_DASHvolatile] = ACTIONS(13),
    [anon_sym_sget_DASHwide_DASHvolatile] = ACTIONS(13),
    [anon_sym_sget_DASHobject_DASHvolatile] = ACTIONS(13),
    [anon_sym_sput] = ACTIONS(13),
    [anon_sym_sput_DASHwide] = ACTIONS(13),
    [anon_sym_sput_DASHobject] = ACTIONS(13),
    [anon_sym_sput_DASHboolean] = ACTIONS(13),
    [anon_sym_sput_DASHbyte] = ACTIONS(13),
    [anon_sym_sput_DASHchar] = ACTIONS(13),
    [anon_sym_sput_DASHshort] = ACTIONS(13),
    [anon_sym_sput_DASHvolatile] = ACTIONS(13),
    [anon_sym_sput_DASHwide_DASHvolatile] = ACTIONS(13),
    [anon_sym_sput_DASHobject_DASHvolatile] = ACTIONS(13),
    [anon_sym_invoke_DASHconstructor] = ACTIONS(13),
    [anon_sym_invoke_DASHcustom] = ACTIONS(13),
    [anon_sym_invoke_DASHdirect] = ACTIONS(13),
    [anon_sym_invoke_DASHdirect_DASHempty] = ACTIONS(13),
    [anon_sym_invoke_DASHinstance] = ACTIONS(13),
    [anon_sym_invoke_DASHinterface] = ACTIONS(13),
    [anon_sym_invoke_DASHpolymorphic] = ACTIONS(13),
    [anon_sym_invoke_DASHstatic] = ACTIONS(13),
    [anon_sym_invoke_DASHsuper] = ACTIONS(13),
    [anon_sym_invoke_DASHvirtual] = ACTIONS(13),
    [anon_sym_invoke_DASHcustom_SLASHrange] = ACTIONS(13),
    [anon_sym_invoke_DASHdirect_SLASHrange] = ACTIONS(13),
    [anon_sym_invoke_DASHinterface_SLASHrange] = ACTIONS(13),
    [anon_sym_invoke_DASHobject_DASHinit_SLASHrange] = ACTIONS(13),
    [anon_sym_invoke_DASHpolymorphic_SLASHrange] = ACTIONS(13),
    [anon_sym_invoke_DASHstatic_SLASHrange] = ACTIONS(13),
    [anon_sym_invoke_DASHsuper_SLASHrange] = ACTIONS(13),
    [anon_sym_invoke_DASHvirtual_SLASHrange] = ACTIONS(13),
    [anon_sym_neg_DASHint] = ACTIONS(13),
    [anon_sym_not_DASHint] = ACTIONS(13),
    [anon_sym_neg_DASHlong] = ACTIONS(13),
    [anon_sym_not_DASHlong] = ACTIONS(13),
    [anon_sym_neg_DASHfloat] = ACTIONS(13),
    [anon_sym_neg_DASHdouble] = ACTIONS(13),
    [anon_sym_int_DASHto_DASHlong] = ACTIONS(13),
    [anon_sym_int_DASHto_DASHfloat] = ACTIONS(13),
    [anon_sym_int_DASHto_DASHdouble] = ACTIONS(13),
    [anon_sym_long_DASHto_DASHint] = ACTIONS(13),
    [anon_sym_long_DASHto_DASHfloat] = ACTIONS(13),
    [anon_sym_long_DASHto_DASHdouble] = ACTIONS(13),
    [anon_sym_float_DASHto_DASHint] = ACTIONS(13),
    [anon_sym_float_DASHto_DASHlong] = ACTIONS(13),
    [anon_sym_float_DASHto_DASHdouble] = ACTIONS(13),
    [anon_sym_double_DASHto_DASHint] = ACTIONS(13),
    [anon_sym_double_DASHto_DASHlong] = ACTIONS(13),
    [anon_sym_double_DASHto_DASHfloat] = ACTIONS(13),
    [anon_sym_int_DASHto_DASHbyte] = ACTIONS(13),
    [anon_sym_int_DASHto_DASHchar] = ACTIONS(13),
    [anon_sym_int_DASHto_DASHshort] = ACTIONS(13),
    [anon_sym_add_DASHint] = ACTIONS(13),
    [anon_sym_sub_DASHint] = ACTIONS(13),
    [anon_sym_mul_DASHint] = ACTIONS(13),
    [anon_sym_div_DASHint] = ACTIONS(13),
    [anon_sym_rem_DASHint] = ACTIONS(13),
    [anon_sym_and_DASHint] = ACTIONS(13),
    [anon_sym_or_DASHint] = ACTIONS(13),
    [anon_sym_xor_DASHint] = ACTIONS(13),
    [anon_sym_shl_DASHint] = ACTIONS(13),
    [anon_sym_shr_DASHint] = ACTIONS(13),
    [anon_sym_ushr_DASHint] = ACTIONS(13),
    [anon_sym_add_DASHlong] = ACTIONS(13),
    [anon_sym_sub_DASHlong] = ACTIONS(13),
    [anon_sym_mul_DASHlong] = ACTIONS(13),
    [anon_sym_div_DASHlong] = ACTIONS(13),
    [anon_sym_rem_DASHlong] = ACTIONS(13),
    [anon_sym_and_DASHlong] = ACTIONS(13),
    [anon_sym_or_DASHlong] = ACTIONS(13),
    [anon_sym_xor_DASHlong] = ACTIONS(13),
    [anon_sym_shl_DASHlong] = ACTIONS(13),
    [anon_sym_shr_DASHlong] = ACTIONS(13),
    [anon_sym_ushr_DASHlong] = ACTIONS(13),
    [anon_sym_add_DASHfloat] = ACTIONS(13),
    [anon_sym_sub_DASHfloat] = ACTIONS(13),
    [anon_sym_mul_DASHfloat] = ACTIONS(13),
    [anon_sym_div_DASHfloat] = ACTIONS(13),
    [anon_sym_rem_DASHfloat] = ACTIONS(13),
    [anon_sym_add_DASHdouble] = ACTIONS(13),
    [anon_sym_sub_DASHdouble] = ACTIONS(13),
    [anon_sym_mul_DASHdouble] = ACTIONS(13),
    [anon_sym_div_DASHdouble] = ACTIONS(13),
    [anon_sym_rem_DASHdouble] = ACTIONS(13),
    [anon_sym_add_DASHint_SLASH2addr] = ACTIONS(13),
    [anon_sym_sub_DASHint_SLASH2addr] = ACTIONS(13),
    [anon_sym_mul_DASHint_SLASH2addr] = ACTIONS(13),
    [anon_sym_div_DASHint_SLASH2addr] = ACTIONS(13),
    [anon_sym_rem_DASHint_SLASH2addr] = ACTIONS(13),
    [anon_sym_and_DASHint_SLASH2addr] = ACTIONS(13),
    [anon_sym_or_DASHint_SLASH2addr] = ACTIONS(13),
    [anon_sym_xor_DASHint_SLASH2addr] = ACTIONS(13),
    [anon_sym_shl_DASHint_SLASH2addr] = ACTIONS(13),
    [anon_sym_shr_DASHint_SLASH2addr] = ACTIONS(13),
    [anon_sym_ushr_DASHint_SLASH2addr] = ACTIONS(13),
    [anon_sym_add_DASHlong_SLASH2addr] = ACTIONS(13),
    [anon_sym_sub_DASHlong_SLASH2addr] = ACTIONS(13),
    [anon_sym_mul_DASHlong_SLASH2addr] = ACTIONS(13),
    [anon_sym_div_DASHlong_SLASH2addr] = ACTIONS(13),
    [anon_sym_rem_DASHlong_SLASH2addr] = ACTIONS(13),
    [anon_sym_and_DASHlong_SLASH2addr] = ACTIONS(13),
    [anon_sym_or_DASHlong_SLASH2addr] = ACTIONS(13),
    [anon_sym_xor_DASHlong_SLASH2addr] = ACTIONS(13),
    [anon_sym_shl_DASHlong_SLASH2addr] = ACTIONS(13),
    [anon_sym_shr_DASHlong_SLASH2addr] = ACTIONS(13),
    [anon_sym_ushr_DASHlong_SLASH2addr] = ACTIONS(13),
    [anon_sym_add_DASHfloat_SLASH2addr] = ACTIONS(13),
    [anon_sym_sub_DASHfloat_SLASH2addr] = ACTIONS(13),
    [anon_sym_mul_DASHfloat_SLASH2addr] = ACTIONS(13),
    [anon_sym_div_DASHfloat_SLASH2addr] = ACTIONS(13),
    [anon_sym_rem_DASHfloat_SLASH2addr] = ACTIONS(13),
    [anon_sym_add_DASHdouble_SLASH2addr] = ACTIONS(13),
    [anon_sym_sub_DASHdouble_SLASH2addr] = ACTIONS(13),
    [anon_sym_mul_DASHdouble_SLASH2addr] = ACTIONS(13),
    [anon_sym_div_DASHdouble_SLASH2addr] = ACTIONS(13),
    [anon_sym_rem_DASHdouble_SLASH2addr] = ACTIONS(13),
    [anon_sym_add_DASHint_SLASHlit16] = ACTIONS(13),
    [anon_sym_sub_DASHint_SLASHlit16] = ACTIONS(13),
    [anon_sym_mul_DASHint_SLASHlit16] = ACTIONS(13),
    [anon_sym_div_DASHint_SLASHlit16] = ACTIONS(13),
    [anon_sym_rem_DASHint_SLASHlit16] = ACTIONS(13),
    [anon_sym_and_DASHint_SLASHlit16] = ACTIONS(13),
    [anon_sym_or_DASHint_SLASHlit16] = ACTIONS(13),
    [anon_sym_xor_DASHint_SLASHlit16] = ACTIONS(13),
    [anon_sym_add_DASHint_SLASHlit8] = ACTIONS(13),
    [anon_sym_sub_DASHint_SLASHlit8] = ACTIONS(13),
    [anon_sym_mul_DASHint_SLASHlit8] = ACTIONS(13),
    [anon_sym_div_DASHint_SLASHlit8] = ACTIONS(13),
    [anon_sym_rem_DASHint_SLASHlit8] = ACTIONS(13),
    [anon_sym_and_DASHint_SLASHlit8] = ACTIONS(13),
    [anon_sym_or_DASHint_SLASHlit8] = ACTIONS(13),
    [anon_sym_xor_DASHint_SLASHlit8] = ACTIONS(13),
    [anon_sym_shl_DASHint_SLASHlit8] = ACTIONS(13),
    [anon_sym_shr_DASHint_SLASHlit8] = ACTIONS(13),
    [anon_sym_ushr_DASHint_SLASHlit8] = ACTIONS(13),
    [anon_sym_static_DASHget] = ACTIONS(13),
    [anon_sym_static_DASHput] = ACTIONS(13),
    [anon_sym_instance_DASHget] = ACTIONS(13),
    [anon_sym_instance_DASHput] = ACTIONS(13),
    [anon_sym_execute_DASHinline] = ACTIONS(13),
    [anon_sym_execute_DASHinline_SLASHrange] = ACTIONS(13),
    [anon_sym_iget_DASHquick] = ACTIONS(13),
    [anon_sym_iget_DASHwide_DASHquick] = ACTIONS(13),
    [anon_sym_iget_DASHobject_DASHquick] = ACTIONS(13),
    [anon_sym_iput_DASHquick] = ACTIONS(13),
    [anon_sym_iput_DASHwide_DASHquick] = ACTIONS(13),
    [anon_sym_iput_DASHobject_DASHquick] = ACTIONS(13),
    [anon_sym_iput_DASHboolean_DASHquick] = ACTIONS(13),
    [anon_sym_iput_DASHbyte_DASHquick] = ACTIONS(13),
    [anon_sym_iput_DASHchar_DASHquick] = ACTIONS(13),
    [anon_sym_iput_DASHshort_DASHquick] = ACTIONS(13),
    [anon_sym_invoke_DASHvirtual_DASHquick] = ACTIONS(13),
    [anon_sym_invoke_DASHvirtual_DASHquick_SLASHrange] = ACTIONS(13),
    [anon_sym_invoke_DASHsuper_DASHquick] = ACTIONS(13),
    [anon_sym_invoke_DASHsuper_DASHquick_SLASHrange] = ACTIONS(13),
    [anon_sym_rsub_DASHint] = ACTIONS(13),
    [anon_sym_rsub_DASHint_SLASHlit8] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [aux_sym_label_token1] = ACTIONS(17),
    [aux_sym_jmp_label_token1] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_LPAREN] = ACTIONS(23),
    [anon_sym_LBRACK] = ACTIONS(25),
    [aux_sym_primitive_type_token1] = ACTIONS(27),
    [aux_sym_primitive_type_token2] = ACTIONS(27),
    [anon_sym_DOTenum] = ACTIONS(29),
    [sym_variable] = ACTIONS(31),
    [sym_parameter] = ACTIONS(31),
    [sym_number] = ACTIONS(33),
    [sym_float] = ACTIONS(35),
    [sym_NaN] = ACTIONS(35),
    [sym_Infinity] = ACTIONS(35),
    [anon_sym_DQUOTE] = ACTIONS(37),
    [anon_sym_true] = ACTIONS(39),
    [anon_sym_false] = ACTIONS(39),
    [anon_sym_SQUOTE] = ACTIONS(41),
    [sym_null] = ACTIONS(35),
    [sym_comment] = ACTIONS(43),
    [sym_L] = ACTIONS(45),
  },
  [3] = {
    [sym_subannotation_directive] = STATE(143),
    [sym_opcode] = STATE(404),
    [sym_value] = STATE(244),
    [sym_class_identifier] = STATE(124),
    [sym_label] = STATE(143),
    [sym_jmp_label] = STATE(246),
    [sym_body] = STATE(143),
    [sym__field_body] = STATE(94),
    [sym_method_signature] = STATE(94),
    [sym__method_signature_body] = STATE(95),
    [sym_method_handle] = STATE(143),
    [sym__full_field_body] = STATE(94),
    [sym_full_method_signature] = STATE(94),
    [sym_custom_invoke] = STATE(143),
    [sym_type] = STATE(143),
    [sym_array_type] = STATE(124),
    [sym_primitive_type] = STATE(20),
    [sym_enum_reference] = STATE(143),
    [sym_register] = STATE(248),
    [sym_list] = STATE(143),
    [sym_range] = STATE(143),
    [sym_literal] = STATE(143),
    [sym_string] = STATE(25),
    [sym_boolean] = STATE(25),
    [sym_character] = STATE(25),
    [sym_identifier] = ACTIONS(47),
    [anon_sym_DOTsubannotation] = ACTIONS(49),
    [anon_sym_nop] = ACTIONS(13),
    [anon_sym_move] = ACTIONS(13),
    [anon_sym_move_SLASHfrom16] = ACTIONS(51),
    [anon_sym_move_SLASH16] = ACTIONS(51),
    [anon_sym_move_DASHwide] = ACTIONS(13),
    [anon_sym_move_DASHwide_SLASHfrom16] = ACTIONS(51),
    [anon_sym_move_DASHwide_SLASH16] = ACTIONS(51),
    [anon_sym_move_DASHobject] = ACTIONS(13),
    [anon_sym_move_DASHobject_SLASHfrom16] = ACTIONS(51),
    [anon_sym_move_DASHobject_SLASH16] = ACTIONS(51),
    [anon_sym_move_DASHresult] = ACTIONS(13),
    [anon_sym_move_DASHresult_DASHwide] = ACTIONS(13),
    [anon_sym_move_DASHresult_DASHobject] = ACTIONS(13),
    [anon_sym_move_DASHexception] = ACTIONS(13),
    [anon_sym_return_DASHvoid] = ACTIONS(13),
    [anon_sym_return] = ACTIONS(13),
    [anon_sym_return_DASHwide] = ACTIONS(13),
    [anon_sym_return_DASHobject] = ACTIONS(13),
    [anon_sym_const_SLASH4] = ACTIONS(51),
    [anon_sym_const_SLASH16] = ACTIONS(51),
    [anon_sym_const] = ACTIONS(13),
    [anon_sym_const_SLASHhigh16] = ACTIONS(51),
    [anon_sym_const_DASHwide_SLASH16] = ACTIONS(51),
    [anon_sym_const_DASHwide_SLASH32] = ACTIONS(51),
    [anon_sym_const_DASHwide] = ACTIONS(13),
    [anon_sym_const_DASHwide_SLASHhigh16] = ACTIONS(51),
    [anon_sym_const_DASHstring] = ACTIONS(13),
    [anon_sym_const_DASHstring_SLASHjumbo] = ACTIONS(51),
    [anon_sym_const_DASHclass] = ACTIONS(13),
    [anon_sym_const_DASHmethod_DASHhandle] = ACTIONS(13),
    [anon_sym_const_DASHmethod_DASHtype] = ACTIONS(13),
    [anon_sym_monitor_DASHenter] = ACTIONS(13),
    [anon_sym_monitor_DASHexit] = ACTIONS(13),
    [anon_sym_check_DASHcast] = ACTIONS(13),
    [anon_sym_instance_DASHof] = ACTIONS(13),
    [anon_sym_array_DASHlength] = ACTIONS(13),
    [anon_sym_new_DASHinstance] = ACTIONS(13),
    [anon_sym_new_DASHarray] = ACTIONS(13),
    [anon_sym_filled_DASHnew_DASHarray] = ACTIONS(13),
    [anon_sym_filled_DASHnew_DASHarray_SLASHrange] = ACTIONS(51),
    [anon_sym_fill_DASHarray_DASHdata] = ACTIONS(13),
    [anon_sym_throw] = ACTIONS(13),
    [anon_sym_throw_DASHverification_DASHerror] = ACTIONS(13),
    [anon_sym_goto] = ACTIONS(13),
    [anon_sym_goto_SLASH16] = ACTIONS(51),
    [anon_sym_goto_SLASH32] = ACTIONS(51),
    [anon_sym_packed_DASHswitch] = ACTIONS(13),
    [anon_sym_sparse_DASHswitch] = ACTIONS(13),
    [anon_sym_cmpl_DASHfloat] = ACTIONS(13),
    [anon_sym_cmpg_DASHfloat] = ACTIONS(13),
    [anon_sym_cmpl_DASHdouble] = ACTIONS(13),
    [anon_sym_cmpg_DASHdouble] = ACTIONS(13),
    [anon_sym_cmp_DASHlong] = ACTIONS(13),
    [anon_sym_if_DASHeq] = ACTIONS(13),
    [anon_sym_if_DASHne] = ACTIONS(13),
    [anon_sym_if_DASHlt] = ACTIONS(13),
    [anon_sym_if_DASHge] = ACTIONS(13),
    [anon_sym_if_DASHgt] = ACTIONS(13),
    [anon_sym_if_DASHle] = ACTIONS(13),
    [anon_sym_if_DASHeqz] = ACTIONS(13),
    [anon_sym_if_DASHnez] = ACTIONS(13),
    [anon_sym_if_DASHltz] = ACTIONS(13),
    [anon_sym_if_DASHgez] = ACTIONS(13),
    [anon_sym_if_DASHgtz] = ACTIONS(13),
    [anon_sym_if_DASHlez] = ACTIONS(13),
    [anon_sym_aget] = ACTIONS(13),
    [anon_sym_aget_DASHwide] = ACTIONS(13),
    [anon_sym_aget_DASHobject] = ACTIONS(13),
    [anon_sym_aget_DASHboolean] = ACTIONS(13),
    [anon_sym_aget_DASHbyte] = ACTIONS(13),
    [anon_sym_aget_DASHchar] = ACTIONS(13),
    [anon_sym_aget_DASHshort] = ACTIONS(13),
    [anon_sym_aput] = ACTIONS(13),
    [anon_sym_aput_DASHwide] = ACTIONS(13),
    [anon_sym_aput_DASHobject] = ACTIONS(13),
    [anon_sym_aput_DASHboolean] = ACTIONS(13),
    [anon_sym_aput_DASHbyte] = ACTIONS(13),
    [anon_sym_aput_DASHchar] = ACTIONS(13),
    [anon_sym_aput_DASHshort] = ACTIONS(13),
    [anon_sym_iget] = ACTIONS(13),
    [anon_sym_iget_DASHwide] = ACTIONS(13),
    [anon_sym_iget_DASHobject] = ACTIONS(13),
    [anon_sym_iget_DASHboolean] = ACTIONS(13),
    [anon_sym_iget_DASHbyte] = ACTIONS(13),
    [anon_sym_iget_DASHchar] = ACTIONS(13),
    [anon_sym_iget_DASHshort] = ACTIONS(13),
    [anon_sym_iget_DASHvolatile] = ACTIONS(13),
    [anon_sym_iget_DASHwide_DASHvolatile] = ACTIONS(13),
    [anon_sym_iget_DASHobject_DASHvolatile] = ACTIONS(13),
    [anon_sym_iput] = ACTIONS(13),
    [anon_sym_iput_DASHwide] = ACTIONS(13),
    [anon_sym_iput_DASHobject] = ACTIONS(13),
    [anon_sym_iput_DASHboolean] = ACTIONS(13),
    [anon_sym_iput_DASHbyte] = ACTIONS(13),
    [anon_sym_iput_DASHchar] = ACTIONS(13),
    [anon_sym_iput_DASHshort] = ACTIONS(13),
    [anon_sym_iput_DASHvolatile] = ACTIONS(13),
    [anon_sym_iput_DASHwide_DASHvolatile] = ACTIONS(13),
    [anon_sym_iput_DASHobject_DASHvolatile] = ACTIONS(13),
    [anon_sym_sget] = ACTIONS(13),
    [anon_sym_sget_DASHwide] = ACTIONS(13),
    [anon_sym_sget_DASHobject] = ACTIONS(13),
    [anon_sym_sget_DASHboolean] = ACTIONS(13),
    [anon_sym_sget_DASHbyte] = ACTIONS(13),
    [anon_sym_sget_DASHchar] = ACTIONS(13),
    [anon_sym_sget_DASHshort] = ACTIONS(13),
    [anon_sym_sget_DASHvolatile] = ACTIONS(13),
    [anon_sym_sget_DASHwide_DASHvolatile] = ACTIONS(13),
    [anon_sym_sget_DASHobject_DASHvolatile] = ACTIONS(13),
    [anon_sym_sput] = ACTIONS(13),
    [anon_sym_sput_DASHwide] = ACTIONS(13),
    [anon_sym_sput_DASHobject] = ACTIONS(13),
    [anon_sym_sput_DASHboolean] = ACTIONS(13),
    [anon_sym_sput_DASHbyte] = ACTIONS(13),
    [anon_sym_sput_DASHchar] = ACTIONS(13),
    [anon_sym_sput_DASHshort] = ACTIONS(13),
    [anon_sym_sput_DASHvolatile] = ACTIONS(13),
    [anon_sym_sput_DASHwide_DASHvolatile] = ACTIONS(13),
    [anon_sym_sput_DASHobject_DASHvolatile] = ACTIONS(13),
    [anon_sym_invoke_DASHconstructor] = ACTIONS(13),
    [anon_sym_invoke_DASHcustom] = ACTIONS(13),
    [anon_sym_invoke_DASHdirect] = ACTIONS(13),
    [anon_sym_invoke_DASHdirect_DASHempty] = ACTIONS(13),
    [anon_sym_invoke_DASHinstance] = ACTIONS(13),
    [anon_sym_invoke_DASHinterface] = ACTIONS(13),
    [anon_sym_invoke_DASHpolymorphic] = ACTIONS(13),
    [anon_sym_invoke_DASHstatic] = ACTIONS(13),
    [anon_sym_invoke_DASHsuper] = ACTIONS(13),
    [anon_sym_invoke_DASHvirtual] = ACTIONS(13),
    [anon_sym_invoke_DASHcustom_SLASHrange] = ACTIONS(51),
    [anon_sym_invoke_DASHdirect_SLASHrange] = ACTIONS(51),
    [anon_sym_invoke_DASHinterface_SLASHrange] = ACTIONS(51),
    [anon_sym_invoke_DASHobject_DASHinit_SLASHrange] = ACTIONS(51),
    [anon_sym_invoke_DASHpolymorphic_SLASHrange] = ACTIONS(51),
    [anon_sym_invoke_DASHstatic_SLASHrange] = ACTIONS(51),
    [anon_sym_invoke_DASHsuper_SLASHrange] = ACTIONS(51),
    [anon_sym_invoke_DASHvirtual_SLASHrange] = ACTIONS(51),
    [anon_sym_neg_DASHint] = ACTIONS(13),
    [anon_sym_not_DASHint] = ACTIONS(13),
    [anon_sym_neg_DASHlong] = ACTIONS(13),
    [anon_sym_not_DASHlong] = ACTIONS(13),
    [anon_sym_neg_DASHfloat] = ACTIONS(13),
    [anon_sym_neg_DASHdouble] = ACTIONS(13),
    [anon_sym_int_DASHto_DASHlong] = ACTIONS(13),
    [anon_sym_int_DASHto_DASHfloat] = ACTIONS(13),
    [anon_sym_int_DASHto_DASHdouble] = ACTIONS(13),
    [anon_sym_long_DASHto_DASHint] = ACTIONS(13),
    [anon_sym_long_DASHto_DASHfloat] = ACTIONS(13),
    [anon_sym_long_DASHto_DASHdouble] = ACTIONS(13),
    [anon_sym_float_DASHto_DASHint] = ACTIONS(13),
    [anon_sym_float_DASHto_DASHlong] = ACTIONS(13),
    [anon_sym_float_DASHto_DASHdouble] = ACTIONS(13),
    [anon_sym_double_DASHto_DASHint] = ACTIONS(13),
    [anon_sym_double_DASHto_DASHlong] = ACTIONS(13),
    [anon_sym_double_DASHto_DASHfloat] = ACTIONS(13),
    [anon_sym_int_DASHto_DASHbyte] = ACTIONS(13),
    [anon_sym_int_DASHto_DASHchar] = ACTIONS(13),
    [anon_sym_int_DASHto_DASHshort] = ACTIONS(13),
    [anon_sym_add_DASHint] = ACTIONS(13),
    [anon_sym_sub_DASHint] = ACTIONS(13),
    [anon_sym_mul_DASHint] = ACTIONS(13),
    [anon_sym_div_DASHint] = ACTIONS(13),
    [anon_sym_rem_DASHint] = ACTIONS(13),
    [anon_sym_and_DASHint] = ACTIONS(13),
    [anon_sym_or_DASHint] = ACTIONS(13),
    [anon_sym_xor_DASHint] = ACTIONS(13),
    [anon_sym_shl_DASHint] = ACTIONS(13),
    [anon_sym_shr_DASHint] = ACTIONS(13),
    [anon_sym_ushr_DASHint] = ACTIONS(13),
    [anon_sym_add_DASHlong] = ACTIONS(13),
    [anon_sym_sub_DASHlong] = ACTIONS(13),
    [anon_sym_mul_DASHlong] = ACTIONS(13),
    [anon_sym_div_DASHlong] = ACTIONS(13),
    [anon_sym_rem_DASHlong] = ACTIONS(13),
    [anon_sym_and_DASHlong] = ACTIONS(13),
    [anon_sym_or_DASHlong] = ACTIONS(13),
    [anon_sym_xor_DASHlong] = ACTIONS(13),
    [anon_sym_shl_DASHlong] = ACTIONS(13),
    [anon_sym_shr_DASHlong] = ACTIONS(13),
    [anon_sym_ushr_DASHlong] = ACTIONS(13),
    [anon_sym_add_DASHfloat] = ACTIONS(13),
    [anon_sym_sub_DASHfloat] = ACTIONS(13),
    [anon_sym_mul_DASHfloat] = ACTIONS(13),
    [anon_sym_div_DASHfloat] = ACTIONS(13),
    [anon_sym_rem_DASHfloat] = ACTIONS(13),
    [anon_sym_add_DASHdouble] = ACTIONS(13),
    [anon_sym_sub_DASHdouble] = ACTIONS(13),
    [anon_sym_mul_DASHdouble] = ACTIONS(13),
    [anon_sym_div_DASHdouble] = ACTIONS(13),
    [anon_sym_rem_DASHdouble] = ACTIONS(13),
    [anon_sym_add_DASHint_SLASH2addr] = ACTIONS(51),
    [anon_sym_sub_DASHint_SLASH2addr] = ACTIONS(51),
    [anon_sym_mul_DASHint_SLASH2addr] = ACTIONS(51),
    [anon_sym_div_DASHint_SLASH2addr] = ACTIONS(51),
    [anon_sym_rem_DASHint_SLASH2addr] = ACTIONS(51),
    [anon_sym_and_DASHint_SLASH2addr] = ACTIONS(51),
    [anon_sym_or_DASHint_SLASH2addr] = ACTIONS(51),
    [anon_sym_xor_DASHint_SLASH2addr] = ACTIONS(51),
    [anon_sym_shl_DASHint_SLASH2addr] = ACTIONS(51),
    [anon_sym_shr_DASHint_SLASH2addr] = ACTIONS(51),
    [anon_sym_ushr_DASHint_SLASH2addr] = ACTIONS(51),
    [anon_sym_add_DASHlong_SLASH2addr] = ACTIONS(51),
    [anon_sym_sub_DASHlong_SLASH2addr] = ACTIONS(51),
    [anon_sym_mul_DASHlong_SLASH2addr] = ACTIONS(51),
    [anon_sym_div_DASHlong_SLASH2addr] = ACTIONS(51),
    [anon_sym_rem_DASHlong_SLASH2addr] = ACTIONS(51),
    [anon_sym_and_DASHlong_SLASH2addr] = ACTIONS(51),
    [anon_sym_or_DASHlong_SLASH2addr] = ACTIONS(51),
    [anon_sym_xor_DASHlong_SLASH2addr] = ACTIONS(51),
    [anon_sym_shl_DASHlong_SLASH2addr] = ACTIONS(51),
    [anon_sym_shr_DASHlong_SLASH2addr] = ACTIONS(51),
    [anon_sym_ushr_DASHlong_SLASH2addr] = ACTIONS(51),
    [anon_sym_add_DASHfloat_SLASH2addr] = ACTIONS(51),
    [anon_sym_sub_DASHfloat_SLASH2addr] = ACTIONS(51),
    [anon_sym_mul_DASHfloat_SLASH2addr] = ACTIONS(51),
    [anon_sym_div_DASHfloat_SLASH2addr] = ACTIONS(51),
    [anon_sym_rem_DASHfloat_SLASH2addr] = ACTIONS(51),
    [anon_sym_add_DASHdouble_SLASH2addr] = ACTIONS(51),
    [anon_sym_sub_DASHdouble_SLASH2addr] = ACTIONS(51),
    [anon_sym_mul_DASHdouble_SLASH2addr] = ACTIONS(51),
    [anon_sym_div_DASHdouble_SLASH2addr] = ACTIONS(51),
    [anon_sym_rem_DASHdouble_SLASH2addr] = ACTIONS(51),
    [anon_sym_add_DASHint_SLASHlit16] = ACTIONS(51),
    [anon_sym_sub_DASHint_SLASHlit16] = ACTIONS(51),
    [anon_sym_mul_DASHint_SLASHlit16] = ACTIONS(51),
    [anon_sym_div_DASHint_SLASHlit16] = ACTIONS(51),
    [anon_sym_rem_DASHint_SLASHlit16] = ACTIONS(51),
    [anon_sym_and_DASHint_SLASHlit16] = ACTIONS(51),
    [anon_sym_or_DASHint_SLASHlit16] = ACTIONS(51),
    [anon_sym_xor_DASHint_SLASHlit16] = ACTIONS(51),
    [anon_sym_add_DASHint_SLASHlit8] = ACTIONS(51),
    [anon_sym_sub_DASHint_SLASHlit8] = ACTIONS(51),
    [anon_sym_mul_DASHint_SLASHlit8] = ACTIONS(51),
    [anon_sym_div_DASHint_SLASHlit8] = ACTIONS(51),
    [anon_sym_rem_DASHint_SLASHlit8] = ACTIONS(51),
    [anon_sym_and_DASHint_SLASHlit8] = ACTIONS(51),
    [anon_sym_or_DASHint_SLASHlit8] = ACTIONS(51),
    [anon_sym_xor_DASHint_SLASHlit8] = ACTIONS(51),
    [anon_sym_shl_DASHint_SLASHlit8] = ACTIONS(51),
    [anon_sym_shr_DASHint_SLASHlit8] = ACTIONS(51),
    [anon_sym_ushr_DASHint_SLASHlit8] = ACTIONS(51),
    [anon_sym_static_DASHget] = ACTIONS(13),
    [anon_sym_static_DASHput] = ACTIONS(13),
    [anon_sym_instance_DASHget] = ACTIONS(13),
    [anon_sym_instance_DASHput] = ACTIONS(13),
    [anon_sym_execute_DASHinline] = ACTIONS(13),
    [anon_sym_execute_DASHinline_SLASHrange] = ACTIONS(51),
    [anon_sym_iget_DASHquick] = ACTIONS(13),
    [anon_sym_iget_DASHwide_DASHquick] = ACTIONS(13),
    [anon_sym_iget_DASHobject_DASHquick] = ACTIONS(13),
    [anon_sym_iput_DASHquick] = ACTIONS(13),
    [anon_sym_iput_DASHwide_DASHquick] = ACTIONS(13),
    [anon_sym_iput_DASHobject_DASHquick] = ACTIONS(13),
    [anon_sym_iput_DASHboolean_DASHquick] = ACTIONS(13),
    [anon_sym_iput_DASHbyte_DASHquick] = ACTIONS(13),
    [anon_sym_iput_DASHchar_DASHquick] = ACTIONS(13),
    [anon_sym_iput_DASHshort_DASHquick] = ACTIONS(13),
    [anon_sym_invoke_DASHvirtual_DASHquick] = ACTIONS(13),
    [anon_sym_invoke_DASHvirtual_DASHquick_SLASHrange] = ACTIONS(51),
    [anon_sym_invoke_DASHsuper_DASHquick] = ACTIONS(13),
    [anon_sym_invoke_DASHsuper_DASHquick_SLASHrange] = ACTIONS(51),
    [anon_sym_rsub_DASHint] = ACTIONS(13),
    [anon_sym_rsub_DASHint_SLASHlit8] = ACTIONS(51),
    [anon_sym_LBRACE] = ACTIONS(53),
    [anon_sym_RBRACE] = ACTIONS(55),
    [aux_sym_label_token1] = ACTIONS(57),
    [aux_sym_jmp_label_token1] = ACTIONS(59),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_LPAREN] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [aux_sym_primitive_type_token1] = ACTIONS(67),
    [aux_sym_primitive_type_token2] = ACTIONS(67),
    [anon_sym_DOTenum] = ACTIONS(69),
    [sym_variable] = ACTIONS(71),
    [sym_parameter] = ACTIONS(71),
    [sym_number] = ACTIONS(73),
    [sym_float] = ACTIONS(75),
    [sym_NaN] = ACTIONS(77),
    [sym_Infinity] = ACTIONS(77),
    [anon_sym_DQUOTE] = ACTIONS(79),
    [anon_sym_true] = ACTIONS(81),
    [anon_sym_false] = ACTIONS(81),
    [anon_sym_SQUOTE] = ACTIONS(83),
    [sym_null] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [sym_L] = ACTIONS(85),
  },
  [4] = {
    [sym_subannotation_directive] = STATE(143),
    [sym_opcode] = STATE(404),
    [sym_value] = STATE(244),
    [sym_class_identifier] = STATE(124),
    [sym_label] = STATE(143),
    [sym_jmp_label] = STATE(143),
    [sym_body] = STATE(143),
    [sym__field_body] = STATE(94),
    [sym_method_signature] = STATE(94),
    [sym__method_signature_body] = STATE(95),
    [sym_method_handle] = STATE(143),
    [sym__full_field_body] = STATE(94),
    [sym_full_method_signature] = STATE(94),
    [sym_custom_invoke] = STATE(143),
    [sym_type] = STATE(143),
    [sym_array_type] = STATE(124),
    [sym_primitive_type] = STATE(20),
    [sym_enum_reference] = STATE(143),
    [sym_register] = STATE(143),
    [sym_list] = STATE(143),
    [sym_range] = STATE(143),
    [sym_literal] = STATE(143),
    [sym_string] = STATE(25),
    [sym_boolean] = STATE(25),
    [sym_character] = STATE(25),
    [sym_identifier] = ACTIONS(47),
    [anon_sym_DOTsubannotation] = ACTIONS(49),
    [anon_sym_nop] = ACTIONS(13),
    [anon_sym_move] = ACTIONS(13),
    [anon_sym_move_SLASHfrom16] = ACTIONS(51),
    [anon_sym_move_SLASH16] = ACTIONS(51),
    [anon_sym_move_DASHwide] = ACTIONS(13),
    [anon_sym_move_DASHwide_SLASHfrom16] = ACTIONS(51),
    [anon_sym_move_DASHwide_SLASH16] = ACTIONS(51),
    [anon_sym_move_DASHobject] = ACTIONS(13),
    [anon_sym_move_DASHobject_SLASHfrom16] = ACTIONS(51),
    [anon_sym_move_DASHobject_SLASH16] = ACTIONS(51),
    [anon_sym_move_DASHresult] = ACTIONS(13),
    [anon_sym_move_DASHresult_DASHwide] = ACTIONS(13),
    [anon_sym_move_DASHresult_DASHobject] = ACTIONS(13),
    [anon_sym_move_DASHexception] = ACTIONS(13),
    [anon_sym_return_DASHvoid] = ACTIONS(13),
    [anon_sym_return] = ACTIONS(13),
    [anon_sym_return_DASHwide] = ACTIONS(13),
    [anon_sym_return_DASHobject] = ACTIONS(13),
    [anon_sym_const_SLASH4] = ACTIONS(51),
    [anon_sym_const_SLASH16] = ACTIONS(51),
    [anon_sym_const] = ACTIONS(13),
    [anon_sym_const_SLASHhigh16] = ACTIONS(51),
    [anon_sym_const_DASHwide_SLASH16] = ACTIONS(51),
    [anon_sym_const_DASHwide_SLASH32] = ACTIONS(51),
    [anon_sym_const_DASHwide] = ACTIONS(13),
    [anon_sym_const_DASHwide_SLASHhigh16] = ACTIONS(51),
    [anon_sym_const_DASHstring] = ACTIONS(13),
    [anon_sym_const_DASHstring_SLASHjumbo] = ACTIONS(51),
    [anon_sym_const_DASHclass] = ACTIONS(13),
    [anon_sym_const_DASHmethod_DASHhandle] = ACTIONS(13),
    [anon_sym_const_DASHmethod_DASHtype] = ACTIONS(13),
    [anon_sym_monitor_DASHenter] = ACTIONS(13),
    [anon_sym_monitor_DASHexit] = ACTIONS(13),
    [anon_sym_check_DASHcast] = ACTIONS(13),
    [anon_sym_instance_DASHof] = ACTIONS(13),
    [anon_sym_array_DASHlength] = ACTIONS(13),
    [anon_sym_new_DASHinstance] = ACTIONS(13),
    [anon_sym_new_DASHarray] = ACTIONS(13),
    [anon_sym_filled_DASHnew_DASHarray] = ACTIONS(13),
    [anon_sym_filled_DASHnew_DASHarray_SLASHrange] = ACTIONS(51),
    [anon_sym_fill_DASHarray_DASHdata] = ACTIONS(13),
    [anon_sym_throw] = ACTIONS(13),
    [anon_sym_throw_DASHverification_DASHerror] = ACTIONS(13),
    [anon_sym_goto] = ACTIONS(13),
    [anon_sym_goto_SLASH16] = ACTIONS(51),
    [anon_sym_goto_SLASH32] = ACTIONS(51),
    [anon_sym_packed_DASHswitch] = ACTIONS(13),
    [anon_sym_sparse_DASHswitch] = ACTIONS(13),
    [anon_sym_cmpl_DASHfloat] = ACTIONS(13),
    [anon_sym_cmpg_DASHfloat] = ACTIONS(13),
    [anon_sym_cmpl_DASHdouble] = ACTIONS(13),
    [anon_sym_cmpg_DASHdouble] = ACTIONS(13),
    [anon_sym_cmp_DASHlong] = ACTIONS(13),
    [anon_sym_if_DASHeq] = ACTIONS(13),
    [anon_sym_if_DASHne] = ACTIONS(13),
    [anon_sym_if_DASHlt] = ACTIONS(13),
    [anon_sym_if_DASHge] = ACTIONS(13),
    [anon_sym_if_DASHgt] = ACTIONS(13),
    [anon_sym_if_DASHle] = ACTIONS(13),
    [anon_sym_if_DASHeqz] = ACTIONS(13),
    [anon_sym_if_DASHnez] = ACTIONS(13),
    [anon_sym_if_DASHltz] = ACTIONS(13),
    [anon_sym_if_DASHgez] = ACTIONS(13),
    [anon_sym_if_DASHgtz] = ACTIONS(13),
    [anon_sym_if_DASHlez] = ACTIONS(13),
    [anon_sym_aget] = ACTIONS(13),
    [anon_sym_aget_DASHwide] = ACTIONS(13),
    [anon_sym_aget_DASHobject] = ACTIONS(13),
    [anon_sym_aget_DASHboolean] = ACTIONS(13),
    [anon_sym_aget_DASHbyte] = ACTIONS(13),
    [anon_sym_aget_DASHchar] = ACTIONS(13),
    [anon_sym_aget_DASHshort] = ACTIONS(13),
    [anon_sym_aput] = ACTIONS(13),
    [anon_sym_aput_DASHwide] = ACTIONS(13),
    [anon_sym_aput_DASHobject] = ACTIONS(13),
    [anon_sym_aput_DASHboolean] = ACTIONS(13),
    [anon_sym_aput_DASHbyte] = ACTIONS(13),
    [anon_sym_aput_DASHchar] = ACTIONS(13),
    [anon_sym_aput_DASHshort] = ACTIONS(13),
    [anon_sym_iget] = ACTIONS(13),
    [anon_sym_iget_DASHwide] = ACTIONS(13),
    [anon_sym_iget_DASHobject] = ACTIONS(13),
    [anon_sym_iget_DASHboolean] = ACTIONS(13),
    [anon_sym_iget_DASHbyte] = ACTIONS(13),
    [anon_sym_iget_DASHchar] = ACTIONS(13),
    [anon_sym_iget_DASHshort] = ACTIONS(13),
    [anon_sym_iget_DASHvolatile] = ACTIONS(13),
    [anon_sym_iget_DASHwide_DASHvolatile] = ACTIONS(13),
    [anon_sym_iget_DASHobject_DASHvolatile] = ACTIONS(13),
    [anon_sym_iput] = ACTIONS(13),
    [anon_sym_iput_DASHwide] = ACTIONS(13),
    [anon_sym_iput_DASHobject] = ACTIONS(13),
    [anon_sym_iput_DASHboolean] = ACTIONS(13),
    [anon_sym_iput_DASHbyte] = ACTIONS(13),
    [anon_sym_iput_DASHchar] = ACTIONS(13),
    [anon_sym_iput_DASHshort] = ACTIONS(13),
    [anon_sym_iput_DASHvolatile] = ACTIONS(13),
    [anon_sym_iput_DASHwide_DASHvolatile] = ACTIONS(13),
    [anon_sym_iput_DASHobject_DASHvolatile] = ACTIONS(13),
    [anon_sym_sget] = ACTIONS(13),
    [anon_sym_sget_DASHwide] = ACTIONS(13),
    [anon_sym_sget_DASHobject] = ACTIONS(13),
    [anon_sym_sget_DASHboolean] = ACTIONS(13),
    [anon_sym_sget_DASHbyte] = ACTIONS(13),
    [anon_sym_sget_DASHchar] = ACTIONS(13),
    [anon_sym_sget_DASHshort] = ACTIONS(13),
    [anon_sym_sget_DASHvolatile] = ACTIONS(13),
    [anon_sym_sget_DASHwide_DASHvolatile] = ACTIONS(13),
    [anon_sym_sget_DASHobject_DASHvolatile] = ACTIONS(13),
    [anon_sym_sput] = ACTIONS(13),
    [anon_sym_sput_DASHwide] = ACTIONS(13),
    [anon_sym_sput_DASHobject] = ACTIONS(13),
    [anon_sym_sput_DASHboolean] = ACTIONS(13),
    [anon_sym_sput_DASHbyte] = ACTIONS(13),
    [anon_sym_sput_DASHchar] = ACTIONS(13),
    [anon_sym_sput_DASHshort] = ACTIONS(13),
    [anon_sym_sput_DASHvolatile] = ACTIONS(13),
    [anon_sym_sput_DASHwide_DASHvolatile] = ACTIONS(13),
    [anon_sym_sput_DASHobject_DASHvolatile] = ACTIONS(13),
    [anon_sym_invoke_DASHconstructor] = ACTIONS(13),
    [anon_sym_invoke_DASHcustom] = ACTIONS(13),
    [anon_sym_invoke_DASHdirect] = ACTIONS(13),
    [anon_sym_invoke_DASHdirect_DASHempty] = ACTIONS(13),
    [anon_sym_invoke_DASHinstance] = ACTIONS(13),
    [anon_sym_invoke_DASHinterface] = ACTIONS(13),
    [anon_sym_invoke_DASHpolymorphic] = ACTIONS(13),
    [anon_sym_invoke_DASHstatic] = ACTIONS(13),
    [anon_sym_invoke_DASHsuper] = ACTIONS(13),
    [anon_sym_invoke_DASHvirtual] = ACTIONS(13),
    [anon_sym_invoke_DASHcustom_SLASHrange] = ACTIONS(51),
    [anon_sym_invoke_DASHdirect_SLASHrange] = ACTIONS(51),
    [anon_sym_invoke_DASHinterface_SLASHrange] = ACTIONS(51),
    [anon_sym_invoke_DASHobject_DASHinit_SLASHrange] = ACTIONS(51),
    [anon_sym_invoke_DASHpolymorphic_SLASHrange] = ACTIONS(51),
    [anon_sym_invoke_DASHstatic_SLASHrange] = ACTIONS(51),
    [anon_sym_invoke_DASHsuper_SLASHrange] = ACTIONS(51),
    [anon_sym_invoke_DASHvirtual_SLASHrange] = ACTIONS(51),
    [anon_sym_neg_DASHint] = ACTIONS(13),
    [anon_sym_not_DASHint] = ACTIONS(13),
    [anon_sym_neg_DASHlong] = ACTIONS(13),
    [anon_sym_not_DASHlong] = ACTIONS(13),
    [anon_sym_neg_DASHfloat] = ACTIONS(13),
    [anon_sym_neg_DASHdouble] = ACTIONS(13),
    [anon_sym_int_DASHto_DASHlong] = ACTIONS(13),
    [anon_sym_int_DASHto_DASHfloat] = ACTIONS(13),
    [anon_sym_int_DASHto_DASHdouble] = ACTIONS(13),
    [anon_sym_long_DASHto_DASHint] = ACTIONS(13),
    [anon_sym_long_DASHto_DASHfloat] = ACTIONS(13),
    [anon_sym_long_DASHto_DASHdouble] = ACTIONS(13),
    [anon_sym_float_DASHto_DASHint] = ACTIONS(13),
    [anon_sym_float_DASHto_DASHlong] = ACTIONS(13),
    [anon_sym_float_DASHto_DASHdouble] = ACTIONS(13),
    [anon_sym_double_DASHto_DASHint] = ACTIONS(13),
    [anon_sym_double_DASHto_DASHlong] = ACTIONS(13),
    [anon_sym_double_DASHto_DASHfloat] = ACTIONS(13),
    [anon_sym_int_DASHto_DASHbyte] = ACTIONS(13),
    [anon_sym_int_DASHto_DASHchar] = ACTIONS(13),
    [anon_sym_int_DASHto_DASHshort] = ACTIONS(13),
    [anon_sym_add_DASHint] = ACTIONS(13),
    [anon_sym_sub_DASHint] = ACTIONS(13),
    [anon_sym_mul_DASHint] = ACTIONS(13),
    [anon_sym_div_DASHint] = ACTIONS(13),
    [anon_sym_rem_DASHint] = ACTIONS(13),
    [anon_sym_and_DASHint] = ACTIONS(13),
    [anon_sym_or_DASHint] = ACTIONS(13),
    [anon_sym_xor_DASHint] = ACTIONS(13),
    [anon_sym_shl_DASHint] = ACTIONS(13),
    [anon_sym_shr_DASHint] = ACTIONS(13),
    [anon_sym_ushr_DASHint] = ACTIONS(13),
    [anon_sym_add_DASHlong] = ACTIONS(13),
    [anon_sym_sub_DASHlong] = ACTIONS(13),
    [anon_sym_mul_DASHlong] = ACTIONS(13),
    [anon_sym_div_DASHlong] = ACTIONS(13),
    [anon_sym_rem_DASHlong] = ACTIONS(13),
    [anon_sym_and_DASHlong] = ACTIONS(13),
    [anon_sym_or_DASHlong] = ACTIONS(13),
    [anon_sym_xor_DASHlong] = ACTIONS(13),
    [anon_sym_shl_DASHlong] = ACTIONS(13),
    [anon_sym_shr_DASHlong] = ACTIONS(13),
    [anon_sym_ushr_DASHlong] = ACTIONS(13),
    [anon_sym_add_DASHfloat] = ACTIONS(13),
    [anon_sym_sub_DASHfloat] = ACTIONS(13),
    [anon_sym_mul_DASHfloat] = ACTIONS(13),
    [anon_sym_div_DASHfloat] = ACTIONS(13),
    [anon_sym_rem_DASHfloat] = ACTIONS(13),
    [anon_sym_add_DASHdouble] = ACTIONS(13),
    [anon_sym_sub_DASHdouble] = ACTIONS(13),
    [anon_sym_mul_DASHdouble] = ACTIONS(13),
    [anon_sym_div_DASHdouble] = ACTIONS(13),
    [anon_sym_rem_DASHdouble] = ACTIONS(13),
    [anon_sym_add_DASHint_SLASH2addr] = ACTIONS(51),
    [anon_sym_sub_DASHint_SLASH2addr] = ACTIONS(51),
    [anon_sym_mul_DASHint_SLASH2addr] = ACTIONS(51),
    [anon_sym_div_DASHint_SLASH2addr] = ACTIONS(51),
    [anon_sym_rem_DASHint_SLASH2addr] = ACTIONS(51),
    [anon_sym_and_DASHint_SLASH2addr] = ACTIONS(51),
    [anon_sym_or_DASHint_SLASH2addr] = ACTIONS(51),
    [anon_sym_xor_DASHint_SLASH2addr] = ACTIONS(51),
    [anon_sym_shl_DASHint_SLASH2addr] = ACTIONS(51),
    [anon_sym_shr_DASHint_SLASH2addr] = ACTIONS(51),
    [anon_sym_ushr_DASHint_SLASH2addr] = ACTIONS(51),
    [anon_sym_add_DASHlong_SLASH2addr] = ACTIONS(51),
    [anon_sym_sub_DASHlong_SLASH2addr] = ACTIONS(51),
    [anon_sym_mul_DASHlong_SLASH2addr] = ACTIONS(51),
    [anon_sym_div_DASHlong_SLASH2addr] = ACTIONS(51),
    [anon_sym_rem_DASHlong_SLASH2addr] = ACTIONS(51),
    [anon_sym_and_DASHlong_SLASH2addr] = ACTIONS(51),
    [anon_sym_or_DASHlong_SLASH2addr] = ACTIONS(51),
    [anon_sym_xor_DASHlong_SLASH2addr] = ACTIONS(51),
    [anon_sym_shl_DASHlong_SLASH2addr] = ACTIONS(51),
    [anon_sym_shr_DASHlong_SLASH2addr] = ACTIONS(51),
    [anon_sym_ushr_DASHlong_SLASH2addr] = ACTIONS(51),
    [anon_sym_add_DASHfloat_SLASH2addr] = ACTIONS(51),
    [anon_sym_sub_DASHfloat_SLASH2addr] = ACTIONS(51),
    [anon_sym_mul_DASHfloat_SLASH2addr] = ACTIONS(51),
    [anon_sym_div_DASHfloat_SLASH2addr] = ACTIONS(51),
    [anon_sym_rem_DASHfloat_SLASH2addr] = ACTIONS(51),
    [anon_sym_add_DASHdouble_SLASH2addr] = ACTIONS(51),
    [anon_sym_sub_DASHdouble_SLASH2addr] = ACTIONS(51),
    [anon_sym_mul_DASHdouble_SLASH2addr] = ACTIONS(51),
    [anon_sym_div_DASHdouble_SLASH2addr] = ACTIONS(51),
    [anon_sym_rem_DASHdouble_SLASH2addr] = ACTIONS(51),
    [anon_sym_add_DASHint_SLASHlit16] = ACTIONS(51),
    [anon_sym_sub_DASHint_SLASHlit16] = ACTIONS(51),
    [anon_sym_mul_DASHint_SLASHlit16] = ACTIONS(51),
    [anon_sym_div_DASHint_SLASHlit16] = ACTIONS(51),
    [anon_sym_rem_DASHint_SLASHlit16] = ACTIONS(51),
    [anon_sym_and_DASHint_SLASHlit16] = ACTIONS(51),
    [anon_sym_or_DASHint_SLASHlit16] = ACTIONS(51),
    [anon_sym_xor_DASHint_SLASHlit16] = ACTIONS(51),
    [anon_sym_add_DASHint_SLASHlit8] = ACTIONS(51),
    [anon_sym_sub_DASHint_SLASHlit8] = ACTIONS(51),
    [anon_sym_mul_DASHint_SLASHlit8] = ACTIONS(51),
    [anon_sym_div_DASHint_SLASHlit8] = ACTIONS(51),
    [anon_sym_rem_DASHint_SLASHlit8] = ACTIONS(51),
    [anon_sym_and_DASHint_SLASHlit8] = ACTIONS(51),
    [anon_sym_or_DASHint_SLASHlit8] = ACTIONS(51),
    [anon_sym_xor_DASHint_SLASHlit8] = ACTIONS(51),
    [anon_sym_shl_DASHint_SLASHlit8] = ACTIONS(51),
    [anon_sym_shr_DASHint_SLASHlit8] = ACTIONS(51),
    [anon_sym_ushr_DASHint_SLASHlit8] = ACTIONS(51),
    [anon_sym_static_DASHget] = ACTIONS(13),
    [anon_sym_static_DASHput] = ACTIONS(13),
    [anon_sym_instance_DASHget] = ACTIONS(13),
    [anon_sym_instance_DASHput] = ACTIONS(13),
    [anon_sym_execute_DASHinline] = ACTIONS(13),
    [anon_sym_execute_DASHinline_SLASHrange] = ACTIONS(51),
    [anon_sym_iget_DASHquick] = ACTIONS(13),
    [anon_sym_iget_DASHwide_DASHquick] = ACTIONS(13),
    [anon_sym_iget_DASHobject_DASHquick] = ACTIONS(13),
    [anon_sym_iput_DASHquick] = ACTIONS(13),
    [anon_sym_iput_DASHwide_DASHquick] = ACTIONS(13),
    [anon_sym_iput_DASHobject_DASHquick] = ACTIONS(13),
    [anon_sym_iput_DASHboolean_DASHquick] = ACTIONS(13),
    [anon_sym_iput_DASHbyte_DASHquick] = ACTIONS(13),
    [anon_sym_iput_DASHchar_DASHquick] = ACTIONS(13),
    [anon_sym_iput_DASHshort_DASHquick] = ACTIONS(13),
    [anon_sym_invoke_DASHvirtual_DASHquick] = ACTIONS(13),
    [anon_sym_invoke_DASHvirtual_DASHquick_SLASHrange] = ACTIONS(51),
    [anon_sym_invoke_DASHsuper_DASHquick] = ACTIONS(13),
    [anon_sym_invoke_DASHsuper_DASHquick_SLASHrange] = ACTIONS(51),
    [anon_sym_rsub_DASHint] = ACTIONS(13),
    [anon_sym_rsub_DASHint_SLASHlit8] = ACTIONS(51),
    [anon_sym_LBRACE] = ACTIONS(53),
    [anon_sym_RBRACE] = ACTIONS(55),
    [aux_sym_label_token1] = ACTIONS(57),
    [aux_sym_jmp_label_token1] = ACTIONS(59),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_LPAREN] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [aux_sym_primitive_type_token1] = ACTIONS(67),
    [aux_sym_primitive_type_token2] = ACTIONS(67),
    [anon_sym_DOTenum] = ACTIONS(69),
    [sym_variable] = ACTIONS(71),
    [sym_parameter] = ACTIONS(71),
    [sym_number] = ACTIONS(87),
    [sym_float] = ACTIONS(75),
    [sym_NaN] = ACTIONS(77),
    [sym_Infinity] = ACTIONS(77),
    [anon_sym_DQUOTE] = ACTIONS(79),
    [anon_sym_true] = ACTIONS(81),
    [anon_sym_false] = ACTIONS(81),
    [anon_sym_SQUOTE] = ACTIONS(83),
    [sym_null] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [sym_L] = ACTIONS(85),
  },
  [5] = {
    [sym_subannotation_directive] = STATE(143),
    [sym_opcode] = STATE(404),
    [sym_value] = STATE(235),
    [sym_class_identifier] = STATE(124),
    [sym_label] = STATE(143),
    [sym_jmp_label] = STATE(266),
    [sym_body] = STATE(143),
    [sym__field_body] = STATE(94),
    [sym_method_signature] = STATE(94),
    [sym__method_signature_body] = STATE(95),
    [sym_method_handle] = STATE(143),
    [sym__full_field_body] = STATE(94),
    [sym_full_method_signature] = STATE(94),
    [sym_custom_invoke] = STATE(143),
    [sym_type] = STATE(143),
    [sym_array_type] = STATE(124),
    [sym_primitive_type] = STATE(20),
    [sym_enum_reference] = STATE(143),
    [sym_register] = STATE(273),
    [sym_list] = STATE(143),
    [sym_range] = STATE(143),
    [sym_literal] = STATE(143),
    [sym_string] = STATE(25),
    [sym_boolean] = STATE(25),
    [sym_character] = STATE(25),
    [sym_identifier] = ACTIONS(47),
    [anon_sym_DOTsubannotation] = ACTIONS(49),
    [anon_sym_nop] = ACTIONS(13),
    [anon_sym_move] = ACTIONS(13),
    [anon_sym_move_SLASHfrom16] = ACTIONS(51),
    [anon_sym_move_SLASH16] = ACTIONS(51),
    [anon_sym_move_DASHwide] = ACTIONS(13),
    [anon_sym_move_DASHwide_SLASHfrom16] = ACTIONS(51),
    [anon_sym_move_DASHwide_SLASH16] = ACTIONS(51),
    [anon_sym_move_DASHobject] = ACTIONS(13),
    [anon_sym_move_DASHobject_SLASHfrom16] = ACTIONS(51),
    [anon_sym_move_DASHobject_SLASH16] = ACTIONS(51),
    [anon_sym_move_DASHresult] = ACTIONS(13),
    [anon_sym_move_DASHresult_DASHwide] = ACTIONS(13),
    [anon_sym_move_DASHresult_DASHobject] = ACTIONS(13),
    [anon_sym_move_DASHexception] = ACTIONS(13),
    [anon_sym_return_DASHvoid] = ACTIONS(13),
    [anon_sym_return] = ACTIONS(13),
    [anon_sym_return_DASHwide] = ACTIONS(13),
    [anon_sym_return_DASHobject] = ACTIONS(13),
    [anon_sym_const_SLASH4] = ACTIONS(51),
    [anon_sym_const_SLASH16] = ACTIONS(51),
    [anon_sym_const] = ACTIONS(13),
    [anon_sym_const_SLASHhigh16] = ACTIONS(51),
    [anon_sym_const_DASHwide_SLASH16] = ACTIONS(51),
    [anon_sym_const_DASHwide_SLASH32] = ACTIONS(51),
    [anon_sym_const_DASHwide] = ACTIONS(13),
    [anon_sym_const_DASHwide_SLASHhigh16] = ACTIONS(51),
    [anon_sym_const_DASHstring] = ACTIONS(13),
    [anon_sym_const_DASHstring_SLASHjumbo] = ACTIONS(51),
    [anon_sym_const_DASHclass] = ACTIONS(13),
    [anon_sym_const_DASHmethod_DASHhandle] = ACTIONS(13),
    [anon_sym_const_DASHmethod_DASHtype] = ACTIONS(13),
    [anon_sym_monitor_DASHenter] = ACTIONS(13),
    [anon_sym_monitor_DASHexit] = ACTIONS(13),
    [anon_sym_check_DASHcast] = ACTIONS(13),
    [anon_sym_instance_DASHof] = ACTIONS(13),
    [anon_sym_array_DASHlength] = ACTIONS(13),
    [anon_sym_new_DASHinstance] = ACTIONS(13),
    [anon_sym_new_DASHarray] = ACTIONS(13),
    [anon_sym_filled_DASHnew_DASHarray] = ACTIONS(13),
    [anon_sym_filled_DASHnew_DASHarray_SLASHrange] = ACTIONS(51),
    [anon_sym_fill_DASHarray_DASHdata] = ACTIONS(13),
    [anon_sym_throw] = ACTIONS(13),
    [anon_sym_throw_DASHverification_DASHerror] = ACTIONS(13),
    [anon_sym_goto] = ACTIONS(13),
    [anon_sym_goto_SLASH16] = ACTIONS(51),
    [anon_sym_goto_SLASH32] = ACTIONS(51),
    [anon_sym_packed_DASHswitch] = ACTIONS(13),
    [anon_sym_sparse_DASHswitch] = ACTIONS(13),
    [anon_sym_cmpl_DASHfloat] = ACTIONS(13),
    [anon_sym_cmpg_DASHfloat] = ACTIONS(13),
    [anon_sym_cmpl_DASHdouble] = ACTIONS(13),
    [anon_sym_cmpg_DASHdouble] = ACTIONS(13),
    [anon_sym_cmp_DASHlong] = ACTIONS(13),
    [anon_sym_if_DASHeq] = ACTIONS(13),
    [anon_sym_if_DASHne] = ACTIONS(13),
    [anon_sym_if_DASHlt] = ACTIONS(13),
    [anon_sym_if_DASHge] = ACTIONS(13),
    [anon_sym_if_DASHgt] = ACTIONS(13),
    [anon_sym_if_DASHle] = ACTIONS(13),
    [anon_sym_if_DASHeqz] = ACTIONS(13),
    [anon_sym_if_DASHnez] = ACTIONS(13),
    [anon_sym_if_DASHltz] = ACTIONS(13),
    [anon_sym_if_DASHgez] = ACTIONS(13),
    [anon_sym_if_DASHgtz] = ACTIONS(13),
    [anon_sym_if_DASHlez] = ACTIONS(13),
    [anon_sym_aget] = ACTIONS(13),
    [anon_sym_aget_DASHwide] = ACTIONS(13),
    [anon_sym_aget_DASHobject] = ACTIONS(13),
    [anon_sym_aget_DASHboolean] = ACTIONS(13),
    [anon_sym_aget_DASHbyte] = ACTIONS(13),
    [anon_sym_aget_DASHchar] = ACTIONS(13),
    [anon_sym_aget_DASHshort] = ACTIONS(13),
    [anon_sym_aput] = ACTIONS(13),
    [anon_sym_aput_DASHwide] = ACTIONS(13),
    [anon_sym_aput_DASHobject] = ACTIONS(13),
    [anon_sym_aput_DASHboolean] = ACTIONS(13),
    [anon_sym_aput_DASHbyte] = ACTIONS(13),
    [anon_sym_aput_DASHchar] = ACTIONS(13),
    [anon_sym_aput_DASHshort] = ACTIONS(13),
    [anon_sym_iget] = ACTIONS(13),
    [anon_sym_iget_DASHwide] = ACTIONS(13),
    [anon_sym_iget_DASHobject] = ACTIONS(13),
    [anon_sym_iget_DASHboolean] = ACTIONS(13),
    [anon_sym_iget_DASHbyte] = ACTIONS(13),
    [anon_sym_iget_DASHchar] = ACTIONS(13),
    [anon_sym_iget_DASHshort] = ACTIONS(13),
    [anon_sym_iget_DASHvolatile] = ACTIONS(13),
    [anon_sym_iget_DASHwide_DASHvolatile] = ACTIONS(13),
    [anon_sym_iget_DASHobject_DASHvolatile] = ACTIONS(13),
    [anon_sym_iput] = ACTIONS(13),
    [anon_sym_iput_DASHwide] = ACTIONS(13),
    [anon_sym_iput_DASHobject] = ACTIONS(13),
    [anon_sym_iput_DASHboolean] = ACTIONS(13),
    [anon_sym_iput_DASHbyte] = ACTIONS(13),
    [anon_sym_iput_DASHchar] = ACTIONS(13),
    [anon_sym_iput_DASHshort] = ACTIONS(13),
    [anon_sym_iput_DASHvolatile] = ACTIONS(13),
    [anon_sym_iput_DASHwide_DASHvolatile] = ACTIONS(13),
    [anon_sym_iput_DASHobject_DASHvolatile] = ACTIONS(13),
    [anon_sym_sget] = ACTIONS(13),
    [anon_sym_sget_DASHwide] = ACTIONS(13),
    [anon_sym_sget_DASHobject] = ACTIONS(13),
    [anon_sym_sget_DASHboolean] = ACTIONS(13),
    [anon_sym_sget_DASHbyte] = ACTIONS(13),
    [anon_sym_sget_DASHchar] = ACTIONS(13),
    [anon_sym_sget_DASHshort] = ACTIONS(13),
    [anon_sym_sget_DASHvolatile] = ACTIONS(13),
    [anon_sym_sget_DASHwide_DASHvolatile] = ACTIONS(13),
    [anon_sym_sget_DASHobject_DASHvolatile] = ACTIONS(13),
    [anon_sym_sput] = ACTIONS(13),
    [anon_sym_sput_DASHwide] = ACTIONS(13),
    [anon_sym_sput_DASHobject] = ACTIONS(13),
    [anon_sym_sput_DASHboolean] = ACTIONS(13),
    [anon_sym_sput_DASHbyte] = ACTIONS(13),
    [anon_sym_sput_DASHchar] = ACTIONS(13),
    [anon_sym_sput_DASHshort] = ACTIONS(13),
    [anon_sym_sput_DASHvolatile] = ACTIONS(13),
    [anon_sym_sput_DASHwide_DASHvolatile] = ACTIONS(13),
    [anon_sym_sput_DASHobject_DASHvolatile] = ACTIONS(13),
    [anon_sym_invoke_DASHconstructor] = ACTIONS(13),
    [anon_sym_invoke_DASHcustom] = ACTIONS(13),
    [anon_sym_invoke_DASHdirect] = ACTIONS(13),
    [anon_sym_invoke_DASHdirect_DASHempty] = ACTIONS(13),
    [anon_sym_invoke_DASHinstance] = ACTIONS(13),
    [anon_sym_invoke_DASHinterface] = ACTIONS(13),
    [anon_sym_invoke_DASHpolymorphic] = ACTIONS(13),
    [anon_sym_invoke_DASHstatic] = ACTIONS(13),
    [anon_sym_invoke_DASHsuper] = ACTIONS(13),
    [anon_sym_invoke_DASHvirtual] = ACTIONS(13),
    [anon_sym_invoke_DASHcustom_SLASHrange] = ACTIONS(51),
    [anon_sym_invoke_DASHdirect_SLASHrange] = ACTIONS(51),
    [anon_sym_invoke_DASHinterface_SLASHrange] = ACTIONS(51),
    [anon_sym_invoke_DASHobject_DASHinit_SLASHrange] = ACTIONS(51),
    [anon_sym_invoke_DASHpolymorphic_SLASHrange] = ACTIONS(51),
    [anon_sym_invoke_DASHstatic_SLASHrange] = ACTIONS(51),
    [anon_sym_invoke_DASHsuper_SLASHrange] = ACTIONS(51),
    [anon_sym_invoke_DASHvirtual_SLASHrange] = ACTIONS(51),
    [anon_sym_neg_DASHint] = ACTIONS(13),
    [anon_sym_not_DASHint] = ACTIONS(13),
    [anon_sym_neg_DASHlong] = ACTIONS(13),
    [anon_sym_not_DASHlong] = ACTIONS(13),
    [anon_sym_neg_DASHfloat] = ACTIONS(13),
    [anon_sym_neg_DASHdouble] = ACTIONS(13),
    [anon_sym_int_DASHto_DASHlong] = ACTIONS(13),
    [anon_sym_int_DASHto_DASHfloat] = ACTIONS(13),
    [anon_sym_int_DASHto_DASHdouble] = ACTIONS(13),
    [anon_sym_long_DASHto_DASHint] = ACTIONS(13),
    [anon_sym_long_DASHto_DASHfloat] = ACTIONS(13),
    [anon_sym_long_DASHto_DASHdouble] = ACTIONS(13),
    [anon_sym_float_DASHto_DASHint] = ACTIONS(13),
    [anon_sym_float_DASHto_DASHlong] = ACTIONS(13),
    [anon_sym_float_DASHto_DASHdouble] = ACTIONS(13),
    [anon_sym_double_DASHto_DASHint] = ACTIONS(13),
    [anon_sym_double_DASHto_DASHlong] = ACTIONS(13),
    [anon_sym_double_DASHto_DASHfloat] = ACTIONS(13),
    [anon_sym_int_DASHto_DASHbyte] = ACTIONS(13),
    [anon_sym_int_DASHto_DASHchar] = ACTIONS(13),
    [anon_sym_int_DASHto_DASHshort] = ACTIONS(13),
    [anon_sym_add_DASHint] = ACTIONS(13),
    [anon_sym_sub_DASHint] = ACTIONS(13),
    [anon_sym_mul_DASHint] = ACTIONS(13),
    [anon_sym_div_DASHint] = ACTIONS(13),
    [anon_sym_rem_DASHint] = ACTIONS(13),
    [anon_sym_and_DASHint] = ACTIONS(13),
    [anon_sym_or_DASHint] = ACTIONS(13),
    [anon_sym_xor_DASHint] = ACTIONS(13),
    [anon_sym_shl_DASHint] = ACTIONS(13),
    [anon_sym_shr_DASHint] = ACTIONS(13),
    [anon_sym_ushr_DASHint] = ACTIONS(13),
    [anon_sym_add_DASHlong] = ACTIONS(13),
    [anon_sym_sub_DASHlong] = ACTIONS(13),
    [anon_sym_mul_DASHlong] = ACTIONS(13),
    [anon_sym_div_DASHlong] = ACTIONS(13),
    [anon_sym_rem_DASHlong] = ACTIONS(13),
    [anon_sym_and_DASHlong] = ACTIONS(13),
    [anon_sym_or_DASHlong] = ACTIONS(13),
    [anon_sym_xor_DASHlong] = ACTIONS(13),
    [anon_sym_shl_DASHlong] = ACTIONS(13),
    [anon_sym_shr_DASHlong] = ACTIONS(13),
    [anon_sym_ushr_DASHlong] = ACTIONS(13),
    [anon_sym_add_DASHfloat] = ACTIONS(13),
    [anon_sym_sub_DASHfloat] = ACTIONS(13),
    [anon_sym_mul_DASHfloat] = ACTIONS(13),
    [anon_sym_div_DASHfloat] = ACTIONS(13),
    [anon_sym_rem_DASHfloat] = ACTIONS(13),
    [anon_sym_add_DASHdouble] = ACTIONS(13),
    [anon_sym_sub_DASHdouble] = ACTIONS(13),
    [anon_sym_mul_DASHdouble] = ACTIONS(13),
    [anon_sym_div_DASHdouble] = ACTIONS(13),
    [anon_sym_rem_DASHdouble] = ACTIONS(13),
    [anon_sym_add_DASHint_SLASH2addr] = ACTIONS(51),
    [anon_sym_sub_DASHint_SLASH2addr] = ACTIONS(51),
    [anon_sym_mul_DASHint_SLASH2addr] = ACTIONS(51),
    [anon_sym_div_DASHint_SLASH2addr] = ACTIONS(51),
    [anon_sym_rem_DASHint_SLASH2addr] = ACTIONS(51),
    [anon_sym_and_DASHint_SLASH2addr] = ACTIONS(51),
    [anon_sym_or_DASHint_SLASH2addr] = ACTIONS(51),
    [anon_sym_xor_DASHint_SLASH2addr] = ACTIONS(51),
    [anon_sym_shl_DASHint_SLASH2addr] = ACTIONS(51),
    [anon_sym_shr_DASHint_SLASH2addr] = ACTIONS(51),
    [anon_sym_ushr_DASHint_SLASH2addr] = ACTIONS(51),
    [anon_sym_add_DASHlong_SLASH2addr] = ACTIONS(51),
    [anon_sym_sub_DASHlong_SLASH2addr] = ACTIONS(51),
    [anon_sym_mul_DASHlong_SLASH2addr] = ACTIONS(51),
    [anon_sym_div_DASHlong_SLASH2addr] = ACTIONS(51),
    [anon_sym_rem_DASHlong_SLASH2addr] = ACTIONS(51),
    [anon_sym_and_DASHlong_SLASH2addr] = ACTIONS(51),
    [anon_sym_or_DASHlong_SLASH2addr] = ACTIONS(51),
    [anon_sym_xor_DASHlong_SLASH2addr] = ACTIONS(51),
    [anon_sym_shl_DASHlong_SLASH2addr] = ACTIONS(51),
    [anon_sym_shr_DASHlong_SLASH2addr] = ACTIONS(51),
    [anon_sym_ushr_DASHlong_SLASH2addr] = ACTIONS(51),
    [anon_sym_add_DASHfloat_SLASH2addr] = ACTIONS(51),
    [anon_sym_sub_DASHfloat_SLASH2addr] = ACTIONS(51),
    [anon_sym_mul_DASHfloat_SLASH2addr] = ACTIONS(51),
    [anon_sym_div_DASHfloat_SLASH2addr] = ACTIONS(51),
    [anon_sym_rem_DASHfloat_SLASH2addr] = ACTIONS(51),
    [anon_sym_add_DASHdouble_SLASH2addr] = ACTIONS(51),
    [anon_sym_sub_DASHdouble_SLASH2addr] = ACTIONS(51),
    [anon_sym_mul_DASHdouble_SLASH2addr] = ACTIONS(51),
    [anon_sym_div_DASHdouble_SLASH2addr] = ACTIONS(51),
    [anon_sym_rem_DASHdouble_SLASH2addr] = ACTIONS(51),
    [anon_sym_add_DASHint_SLASHlit16] = ACTIONS(51),
    [anon_sym_sub_DASHint_SLASHlit16] = ACTIONS(51),
    [anon_sym_mul_DASHint_SLASHlit16] = ACTIONS(51),
    [anon_sym_div_DASHint_SLASHlit16] = ACTIONS(51),
    [anon_sym_rem_DASHint_SLASHlit16] = ACTIONS(51),
    [anon_sym_and_DASHint_SLASHlit16] = ACTIONS(51),
    [anon_sym_or_DASHint_SLASHlit16] = ACTIONS(51),
    [anon_sym_xor_DASHint_SLASHlit16] = ACTIONS(51),
    [anon_sym_add_DASHint_SLASHlit8] = ACTIONS(51),
    [anon_sym_sub_DASHint_SLASHlit8] = ACTIONS(51),
    [anon_sym_mul_DASHint_SLASHlit8] = ACTIONS(51),
    [anon_sym_div_DASHint_SLASHlit8] = ACTIONS(51),
    [anon_sym_rem_DASHint_SLASHlit8] = ACTIONS(51),
    [anon_sym_and_DASHint_SLASHlit8] = ACTIONS(51),
    [anon_sym_or_DASHint_SLASHlit8] = ACTIONS(51),
    [anon_sym_xor_DASHint_SLASHlit8] = ACTIONS(51),
    [anon_sym_shl_DASHint_SLASHlit8] = ACTIONS(51),
    [anon_sym_shr_DASHint_SLASHlit8] = ACTIONS(51),
    [anon_sym_ushr_DASHint_SLASHlit8] = ACTIONS(51),
    [anon_sym_static_DASHget] = ACTIONS(13),
    [anon_sym_static_DASHput] = ACTIONS(13),
    [anon_sym_instance_DASHget] = ACTIONS(13),
    [anon_sym_instance_DASHput] = ACTIONS(13),
    [anon_sym_execute_DASHinline] = ACTIONS(13),
    [anon_sym_execute_DASHinline_SLASHrange] = ACTIONS(51),
    [anon_sym_iget_DASHquick] = ACTIONS(13),
    [anon_sym_iget_DASHwide_DASHquick] = ACTIONS(13),
    [anon_sym_iget_DASHobject_DASHquick] = ACTIONS(13),
    [anon_sym_iput_DASHquick] = ACTIONS(13),
    [anon_sym_iput_DASHwide_DASHquick] = ACTIONS(13),
    [anon_sym_iput_DASHobject_DASHquick] = ACTIONS(13),
    [anon_sym_iput_DASHboolean_DASHquick] = ACTIONS(13),
    [anon_sym_iput_DASHbyte_DASHquick] = ACTIONS(13),
    [anon_sym_iput_DASHchar_DASHquick] = ACTIONS(13),
    [anon_sym_iput_DASHshort_DASHquick] = ACTIONS(13),
    [anon_sym_invoke_DASHvirtual_DASHquick] = ACTIONS(13),
    [anon_sym_invoke_DASHvirtual_DASHquick_SLASHrange] = ACTIONS(51),
    [anon_sym_invoke_DASHsuper_DASHquick] = ACTIONS(13),
    [anon_sym_invoke_DASHsuper_DASHquick_SLASHrange] = ACTIONS(51),
    [anon_sym_rsub_DASHint] = ACTIONS(13),
    [anon_sym_rsub_DASHint_SLASHlit8] = ACTIONS(51),
    [anon_sym_LBRACE] = ACTIONS(53),
    [anon_sym_RBRACE] = ACTIONS(89),
    [aux_sym_label_token1] = ACTIONS(57),
    [aux_sym_jmp_label_token1] = ACTIONS(59),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_LPAREN] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [aux_sym_primitive_type_token1] = ACTIONS(67),
    [aux_sym_primitive_type_token2] = ACTIONS(67),
    [anon_sym_DOTenum] = ACTIONS(69),
    [sym_variable] = ACTIONS(71),
    [sym_parameter] = ACTIONS(71),
    [sym_number] = ACTIONS(91),
    [sym_float] = ACTIONS(75),
    [sym_NaN] = ACTIONS(77),
    [sym_Infinity] = ACTIONS(77),
    [anon_sym_DQUOTE] = ACTIONS(79),
    [anon_sym_true] = ACTIONS(81),
    [anon_sym_false] = ACTIONS(81),
    [anon_sym_SQUOTE] = ACTIONS(83),
    [sym_null] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [sym_L] = ACTIONS(85),
  },
  [6] = {
    [sym_subannotation_directive] = STATE(143),
    [sym_opcode] = STATE(404),
    [sym_value] = STATE(144),
    [sym_class_identifier] = STATE(124),
    [sym_label] = STATE(143),
    [sym_jmp_label] = STATE(143),
    [sym_body] = STATE(143),
    [sym__field_body] = STATE(94),
    [sym_method_signature] = STATE(94),
    [sym__method_signature_body] = STATE(95),
    [sym_method_handle] = STATE(143),
    [sym__full_field_body] = STATE(94),
    [sym_full_method_signature] = STATE(94),
    [sym_custom_invoke] = STATE(143),
    [sym_type] = STATE(143),
    [sym_array_type] = STATE(124),
    [sym_primitive_type] = STATE(20),
    [sym_enum_reference] = STATE(143),
    [sym_register] = STATE(143),
    [sym_list] = STATE(143),
    [sym_range] = STATE(143),
    [sym_literal] = STATE(143),
    [sym_string] = STATE(25),
    [sym_boolean] = STATE(25),
    [sym_character] = STATE(25),
    [sym_identifier] = ACTIONS(47),
    [anon_sym_DOTsubannotation] = ACTIONS(49),
    [anon_sym_nop] = ACTIONS(13),
    [anon_sym_move] = ACTIONS(13),
    [anon_sym_move_SLASHfrom16] = ACTIONS(51),
    [anon_sym_move_SLASH16] = ACTIONS(51),
    [anon_sym_move_DASHwide] = ACTIONS(13),
    [anon_sym_move_DASHwide_SLASHfrom16] = ACTIONS(51),
    [anon_sym_move_DASHwide_SLASH16] = ACTIONS(51),
    [anon_sym_move_DASHobject] = ACTIONS(13),
    [anon_sym_move_DASHobject_SLASHfrom16] = ACTIONS(51),
    [anon_sym_move_DASHobject_SLASH16] = ACTIONS(51),
    [anon_sym_move_DASHresult] = ACTIONS(13),
    [anon_sym_move_DASHresult_DASHwide] = ACTIONS(13),
    [anon_sym_move_DASHresult_DASHobject] = ACTIONS(13),
    [anon_sym_move_DASHexception] = ACTIONS(13),
    [anon_sym_return_DASHvoid] = ACTIONS(13),
    [anon_sym_return] = ACTIONS(13),
    [anon_sym_return_DASHwide] = ACTIONS(13),
    [anon_sym_return_DASHobject] = ACTIONS(13),
    [anon_sym_const_SLASH4] = ACTIONS(51),
    [anon_sym_const_SLASH16] = ACTIONS(51),
    [anon_sym_const] = ACTIONS(13),
    [anon_sym_const_SLASHhigh16] = ACTIONS(51),
    [anon_sym_const_DASHwide_SLASH16] = ACTIONS(51),
    [anon_sym_const_DASHwide_SLASH32] = ACTIONS(51),
    [anon_sym_const_DASHwide] = ACTIONS(13),
    [anon_sym_const_DASHwide_SLASHhigh16] = ACTIONS(51),
    [anon_sym_const_DASHstring] = ACTIONS(13),
    [anon_sym_const_DASHstring_SLASHjumbo] = ACTIONS(51),
    [anon_sym_const_DASHclass] = ACTIONS(13),
    [anon_sym_const_DASHmethod_DASHhandle] = ACTIONS(13),
    [anon_sym_const_DASHmethod_DASHtype] = ACTIONS(13),
    [anon_sym_monitor_DASHenter] = ACTIONS(13),
    [anon_sym_monitor_DASHexit] = ACTIONS(13),
    [anon_sym_check_DASHcast] = ACTIONS(13),
    [anon_sym_instance_DASHof] = ACTIONS(13),
    [anon_sym_array_DASHlength] = ACTIONS(13),
    [anon_sym_new_DASHinstance] = ACTIONS(13),
    [anon_sym_new_DASHarray] = ACTIONS(13),
    [anon_sym_filled_DASHnew_DASHarray] = ACTIONS(13),
    [anon_sym_filled_DASHnew_DASHarray_SLASHrange] = ACTIONS(51),
    [anon_sym_fill_DASHarray_DASHdata] = ACTIONS(13),
    [anon_sym_throw] = ACTIONS(13),
    [anon_sym_throw_DASHverification_DASHerror] = ACTIONS(13),
    [anon_sym_goto] = ACTIONS(13),
    [anon_sym_goto_SLASH16] = ACTIONS(51),
    [anon_sym_goto_SLASH32] = ACTIONS(51),
    [anon_sym_packed_DASHswitch] = ACTIONS(13),
    [anon_sym_sparse_DASHswitch] = ACTIONS(13),
    [anon_sym_cmpl_DASHfloat] = ACTIONS(13),
    [anon_sym_cmpg_DASHfloat] = ACTIONS(13),
    [anon_sym_cmpl_DASHdouble] = ACTIONS(13),
    [anon_sym_cmpg_DASHdouble] = ACTIONS(13),
    [anon_sym_cmp_DASHlong] = ACTIONS(13),
    [anon_sym_if_DASHeq] = ACTIONS(13),
    [anon_sym_if_DASHne] = ACTIONS(13),
    [anon_sym_if_DASHlt] = ACTIONS(13),
    [anon_sym_if_DASHge] = ACTIONS(13),
    [anon_sym_if_DASHgt] = ACTIONS(13),
    [anon_sym_if_DASHle] = ACTIONS(13),
    [anon_sym_if_DASHeqz] = ACTIONS(13),
    [anon_sym_if_DASHnez] = ACTIONS(13),
    [anon_sym_if_DASHltz] = ACTIONS(13),
    [anon_sym_if_DASHgez] = ACTIONS(13),
    [anon_sym_if_DASHgtz] = ACTIONS(13),
    [anon_sym_if_DASHlez] = ACTIONS(13),
    [anon_sym_aget] = ACTIONS(13),
    [anon_sym_aget_DASHwide] = ACTIONS(13),
    [anon_sym_aget_DASHobject] = ACTIONS(13),
    [anon_sym_aget_DASHboolean] = ACTIONS(13),
    [anon_sym_aget_DASHbyte] = ACTIONS(13),
    [anon_sym_aget_DASHchar] = ACTIONS(13),
    [anon_sym_aget_DASHshort] = ACTIONS(13),
    [anon_sym_aput] = ACTIONS(13),
    [anon_sym_aput_DASHwide] = ACTIONS(13),
    [anon_sym_aput_DASHobject] = ACTIONS(13),
    [anon_sym_aput_DASHboolean] = ACTIONS(13),
    [anon_sym_aput_DASHbyte] = ACTIONS(13),
    [anon_sym_aput_DASHchar] = ACTIONS(13),
    [anon_sym_aput_DASHshort] = ACTIONS(13),
    [anon_sym_iget] = ACTIONS(13),
    [anon_sym_iget_DASHwide] = ACTIONS(13),
    [anon_sym_iget_DASHobject] = ACTIONS(13),
    [anon_sym_iget_DASHboolean] = ACTIONS(13),
    [anon_sym_iget_DASHbyte] = ACTIONS(13),
    [anon_sym_iget_DASHchar] = ACTIONS(13),
    [anon_sym_iget_DASHshort] = ACTIONS(13),
    [anon_sym_iget_DASHvolatile] = ACTIONS(13),
    [anon_sym_iget_DASHwide_DASHvolatile] = ACTIONS(13),
    [anon_sym_iget_DASHobject_DASHvolatile] = ACTIONS(13),
    [anon_sym_iput] = ACTIONS(13),
    [anon_sym_iput_DASHwide] = ACTIONS(13),
    [anon_sym_iput_DASHobject] = ACTIONS(13),
    [anon_sym_iput_DASHboolean] = ACTIONS(13),
    [anon_sym_iput_DASHbyte] = ACTIONS(13),
    [anon_sym_iput_DASHchar] = ACTIONS(13),
    [anon_sym_iput_DASHshort] = ACTIONS(13),
    [anon_sym_iput_DASHvolatile] = ACTIONS(13),
    [anon_sym_iput_DASHwide_DASHvolatile] = ACTIONS(13),
    [anon_sym_iput_DASHobject_DASHvolatile] = ACTIONS(13),
    [anon_sym_sget] = ACTIONS(13),
    [anon_sym_sget_DASHwide] = ACTIONS(13),
    [anon_sym_sget_DASHobject] = ACTIONS(13),
    [anon_sym_sget_DASHboolean] = ACTIONS(13),
    [anon_sym_sget_DASHbyte] = ACTIONS(13),
    [anon_sym_sget_DASHchar] = ACTIONS(13),
    [anon_sym_sget_DASHshort] = ACTIONS(13),
    [anon_sym_sget_DASHvolatile] = ACTIONS(13),
    [anon_sym_sget_DASHwide_DASHvolatile] = ACTIONS(13),
    [anon_sym_sget_DASHobject_DASHvolatile] = ACTIONS(13),
    [anon_sym_sput] = ACTIONS(13),
    [anon_sym_sput_DASHwide] = ACTIONS(13),
    [anon_sym_sput_DASHobject] = ACTIONS(13),
    [anon_sym_sput_DASHboolean] = ACTIONS(13),
    [anon_sym_sput_DASHbyte] = ACTIONS(13),
    [anon_sym_sput_DASHchar] = ACTIONS(13),
    [anon_sym_sput_DASHshort] = ACTIONS(13),
    [anon_sym_sput_DASHvolatile] = ACTIONS(13),
    [anon_sym_sput_DASHwide_DASHvolatile] = ACTIONS(13),
    [anon_sym_sput_DASHobject_DASHvolatile] = ACTIONS(13),
    [anon_sym_invoke_DASHconstructor] = ACTIONS(13),
    [anon_sym_invoke_DASHcustom] = ACTIONS(13),
    [anon_sym_invoke_DASHdirect] = ACTIONS(13),
    [anon_sym_invoke_DASHdirect_DASHempty] = ACTIONS(13),
    [anon_sym_invoke_DASHinstance] = ACTIONS(13),
    [anon_sym_invoke_DASHinterface] = ACTIONS(13),
    [anon_sym_invoke_DASHpolymorphic] = ACTIONS(13),
    [anon_sym_invoke_DASHstatic] = ACTIONS(13),
    [anon_sym_invoke_DASHsuper] = ACTIONS(13),
    [anon_sym_invoke_DASHvirtual] = ACTIONS(13),
    [anon_sym_invoke_DASHcustom_SLASHrange] = ACTIONS(51),
    [anon_sym_invoke_DASHdirect_SLASHrange] = ACTIONS(51),
    [anon_sym_invoke_DASHinterface_SLASHrange] = ACTIONS(51),
    [anon_sym_invoke_DASHobject_DASHinit_SLASHrange] = ACTIONS(51),
    [anon_sym_invoke_DASHpolymorphic_SLASHrange] = ACTIONS(51),
    [anon_sym_invoke_DASHstatic_SLASHrange] = ACTIONS(51),
    [anon_sym_invoke_DASHsuper_SLASHrange] = ACTIONS(51),
    [anon_sym_invoke_DASHvirtual_SLASHrange] = ACTIONS(51),
    [anon_sym_neg_DASHint] = ACTIONS(13),
    [anon_sym_not_DASHint] = ACTIONS(13),
    [anon_sym_neg_DASHlong] = ACTIONS(13),
    [anon_sym_not_DASHlong] = ACTIONS(13),
    [anon_sym_neg_DASHfloat] = ACTIONS(13),
    [anon_sym_neg_DASHdouble] = ACTIONS(13),
    [anon_sym_int_DASHto_DASHlong] = ACTIONS(13),
    [anon_sym_int_DASHto_DASHfloat] = ACTIONS(13),
    [anon_sym_int_DASHto_DASHdouble] = ACTIONS(13),
    [anon_sym_long_DASHto_DASHint] = ACTIONS(13),
    [anon_sym_long_DASHto_DASHfloat] = ACTIONS(13),
    [anon_sym_long_DASHto_DASHdouble] = ACTIONS(13),
    [anon_sym_float_DASHto_DASHint] = ACTIONS(13),
    [anon_sym_float_DASHto_DASHlong] = ACTIONS(13),
    [anon_sym_float_DASHto_DASHdouble] = ACTIONS(13),
    [anon_sym_double_DASHto_DASHint] = ACTIONS(13),
    [anon_sym_double_DASHto_DASHlong] = ACTIONS(13),
    [anon_sym_double_DASHto_DASHfloat] = ACTIONS(13),
    [anon_sym_int_DASHto_DASHbyte] = ACTIONS(13),
    [anon_sym_int_DASHto_DASHchar] = ACTIONS(13),
    [anon_sym_int_DASHto_DASHshort] = ACTIONS(13),
    [anon_sym_add_DASHint] = ACTIONS(13),
    [anon_sym_sub_DASHint] = ACTIONS(13),
    [anon_sym_mul_DASHint] = ACTIONS(13),
    [anon_sym_div_DASHint] = ACTIONS(13),
    [anon_sym_rem_DASHint] = ACTIONS(13),
    [anon_sym_and_DASHint] = ACTIONS(13),
    [anon_sym_or_DASHint] = ACTIONS(13),
    [anon_sym_xor_DASHint] = ACTIONS(13),
    [anon_sym_shl_DASHint] = ACTIONS(13),
    [anon_sym_shr_DASHint] = ACTIONS(13),
    [anon_sym_ushr_DASHint] = ACTIONS(13),
    [anon_sym_add_DASHlong] = ACTIONS(13),
    [anon_sym_sub_DASHlong] = ACTIONS(13),
    [anon_sym_mul_DASHlong] = ACTIONS(13),
    [anon_sym_div_DASHlong] = ACTIONS(13),
    [anon_sym_rem_DASHlong] = ACTIONS(13),
    [anon_sym_and_DASHlong] = ACTIONS(13),
    [anon_sym_or_DASHlong] = ACTIONS(13),
    [anon_sym_xor_DASHlong] = ACTIONS(13),
    [anon_sym_shl_DASHlong] = ACTIONS(13),
    [anon_sym_shr_DASHlong] = ACTIONS(13),
    [anon_sym_ushr_DASHlong] = ACTIONS(13),
    [anon_sym_add_DASHfloat] = ACTIONS(13),
    [anon_sym_sub_DASHfloat] = ACTIONS(13),
    [anon_sym_mul_DASHfloat] = ACTIONS(13),
    [anon_sym_div_DASHfloat] = ACTIONS(13),
    [anon_sym_rem_DASHfloat] = ACTIONS(13),
    [anon_sym_add_DASHdouble] = ACTIONS(13),
    [anon_sym_sub_DASHdouble] = ACTIONS(13),
    [anon_sym_mul_DASHdouble] = ACTIONS(13),
    [anon_sym_div_DASHdouble] = ACTIONS(13),
    [anon_sym_rem_DASHdouble] = ACTIONS(13),
    [anon_sym_add_DASHint_SLASH2addr] = ACTIONS(51),
    [anon_sym_sub_DASHint_SLASH2addr] = ACTIONS(51),
    [anon_sym_mul_DASHint_SLASH2addr] = ACTIONS(51),
    [anon_sym_div_DASHint_SLASH2addr] = ACTIONS(51),
    [anon_sym_rem_DASHint_SLASH2addr] = ACTIONS(51),
    [anon_sym_and_DASHint_SLASH2addr] = ACTIONS(51),
    [anon_sym_or_DASHint_SLASH2addr] = ACTIONS(51),
    [anon_sym_xor_DASHint_SLASH2addr] = ACTIONS(51),
    [anon_sym_shl_DASHint_SLASH2addr] = ACTIONS(51),
    [anon_sym_shr_DASHint_SLASH2addr] = ACTIONS(51),
    [anon_sym_ushr_DASHint_SLASH2addr] = ACTIONS(51),
    [anon_sym_add_DASHlong_SLASH2addr] = ACTIONS(51),
    [anon_sym_sub_DASHlong_SLASH2addr] = ACTIONS(51),
    [anon_sym_mul_DASHlong_SLASH2addr] = ACTIONS(51),
    [anon_sym_div_DASHlong_SLASH2addr] = ACTIONS(51),
    [anon_sym_rem_DASHlong_SLASH2addr] = ACTIONS(51),
    [anon_sym_and_DASHlong_SLASH2addr] = ACTIONS(51),
    [anon_sym_or_DASHlong_SLASH2addr] = ACTIONS(51),
    [anon_sym_xor_DASHlong_SLASH2addr] = ACTIONS(51),
    [anon_sym_shl_DASHlong_SLASH2addr] = ACTIONS(51),
    [anon_sym_shr_DASHlong_SLASH2addr] = ACTIONS(51),
    [anon_sym_ushr_DASHlong_SLASH2addr] = ACTIONS(51),
    [anon_sym_add_DASHfloat_SLASH2addr] = ACTIONS(51),
    [anon_sym_sub_DASHfloat_SLASH2addr] = ACTIONS(51),
    [anon_sym_mul_DASHfloat_SLASH2addr] = ACTIONS(51),
    [anon_sym_div_DASHfloat_SLASH2addr] = ACTIONS(51),
    [anon_sym_rem_DASHfloat_SLASH2addr] = ACTIONS(51),
    [anon_sym_add_DASHdouble_SLASH2addr] = ACTIONS(51),
    [anon_sym_sub_DASHdouble_SLASH2addr] = ACTIONS(51),
    [anon_sym_mul_DASHdouble_SLASH2addr] = ACTIONS(51),
    [anon_sym_div_DASHdouble_SLASH2addr] = ACTIONS(51),
    [anon_sym_rem_DASHdouble_SLASH2addr] = ACTIONS(51),
    [anon_sym_add_DASHint_SLASHlit16] = ACTIONS(51),
    [anon_sym_sub_DASHint_SLASHlit16] = ACTIONS(51),
    [anon_sym_mul_DASHint_SLASHlit16] = ACTIONS(51),
    [anon_sym_div_DASHint_SLASHlit16] = ACTIONS(51),
    [anon_sym_rem_DASHint_SLASHlit16] = ACTIONS(51),
    [anon_sym_and_DASHint_SLASHlit16] = ACTIONS(51),
    [anon_sym_or_DASHint_SLASHlit16] = ACTIONS(51),
    [anon_sym_xor_DASHint_SLASHlit16] = ACTIONS(51),
    [anon_sym_add_DASHint_SLASHlit8] = ACTIONS(51),
    [anon_sym_sub_DASHint_SLASHlit8] = ACTIONS(51),
    [anon_sym_mul_DASHint_SLASHlit8] = ACTIONS(51),
    [anon_sym_div_DASHint_SLASHlit8] = ACTIONS(51),
    [anon_sym_rem_DASHint_SLASHlit8] = ACTIONS(51),
    [anon_sym_and_DASHint_SLASHlit8] = ACTIONS(51),
    [anon_sym_or_DASHint_SLASHlit8] = ACTIONS(51),
    [anon_sym_xor_DASHint_SLASHlit8] = ACTIONS(51),
    [anon_sym_shl_DASHint_SLASHlit8] = ACTIONS(51),
    [anon_sym_shr_DASHint_SLASHlit8] = ACTIONS(51),
    [anon_sym_ushr_DASHint_SLASHlit8] = ACTIONS(51),
    [anon_sym_static_DASHget] = ACTIONS(13),
    [anon_sym_static_DASHput] = ACTIONS(13),
    [anon_sym_instance_DASHget] = ACTIONS(13),
    [anon_sym_instance_DASHput] = ACTIONS(13),
    [anon_sym_execute_DASHinline] = ACTIONS(13),
    [anon_sym_execute_DASHinline_SLASHrange] = ACTIONS(51),
    [anon_sym_iget_DASHquick] = ACTIONS(13),
    [anon_sym_iget_DASHwide_DASHquick] = ACTIONS(13),
    [anon_sym_iget_DASHobject_DASHquick] = ACTIONS(13),
    [anon_sym_iput_DASHquick] = ACTIONS(13),
    [anon_sym_iput_DASHwide_DASHquick] = ACTIONS(13),
    [anon_sym_iput_DASHobject_DASHquick] = ACTIONS(13),
    [anon_sym_iput_DASHboolean_DASHquick] = ACTIONS(13),
    [anon_sym_iput_DASHbyte_DASHquick] = ACTIONS(13),
    [anon_sym_iput_DASHchar_DASHquick] = ACTIONS(13),
    [anon_sym_iput_DASHshort_DASHquick] = ACTIONS(13),
    [anon_sym_invoke_DASHvirtual_DASHquick] = ACTIONS(13),
    [anon_sym_invoke_DASHvirtual_DASHquick_SLASHrange] = ACTIONS(51),
    [anon_sym_invoke_DASHsuper_DASHquick] = ACTIONS(13),
    [anon_sym_invoke_DASHsuper_DASHquick_SLASHrange] = ACTIONS(51),
    [anon_sym_rsub_DASHint] = ACTIONS(13),
    [anon_sym_rsub_DASHint_SLASHlit8] = ACTIONS(51),
    [anon_sym_LBRACE] = ACTIONS(53),
    [aux_sym_label_token1] = ACTIONS(57),
    [aux_sym_jmp_label_token1] = ACTIONS(59),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_LPAREN] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [aux_sym_primitive_type_token1] = ACTIONS(67),
    [aux_sym_primitive_type_token2] = ACTIONS(67),
    [anon_sym_DOTenum] = ACTIONS(69),
    [sym_variable] = ACTIONS(71),
    [sym_parameter] = ACTIONS(71),
    [sym_number] = ACTIONS(87),
    [sym_float] = ACTIONS(75),
    [sym_NaN] = ACTIONS(77),
    [sym_Infinity] = ACTIONS(77),
    [anon_sym_DQUOTE] = ACTIONS(79),
    [anon_sym_true] = ACTIONS(81),
    [anon_sym_false] = ACTIONS(81),
    [anon_sym_SQUOTE] = ACTIONS(83),
    [sym_null] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [sym_L] = ACTIONS(85),
  },
  [7] = {
    [sym_subannotation_directive] = STATE(314),
    [sym_opcode] = STATE(385),
    [sym_value] = STATE(351),
    [sym_class_identifier] = STATE(276),
    [sym_label] = STATE(314),
    [sym_jmp_label] = STATE(314),
    [sym_body] = STATE(314),
    [sym__field_body] = STATE(313),
    [sym_method_signature] = STATE(313),
    [sym__method_signature_body] = STATE(312),
    [sym_method_handle] = STATE(314),
    [sym__full_field_body] = STATE(313),
    [sym_full_method_signature] = STATE(313),
    [sym_custom_invoke] = STATE(314),
    [sym_type] = STATE(314),
    [sym_array_type] = STATE(276),
    [sym_primitive_type] = STATE(274),
    [sym_enum_reference] = STATE(314),
    [sym_register] = STATE(314),
    [sym_list] = STATE(314),
    [sym_range] = STATE(314),
    [sym_literal] = STATE(314),
    [sym_string] = STATE(316),
    [sym_boolean] = STATE(316),
    [sym_character] = STATE(316),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_DOTsubannotation] = ACTIONS(93),
    [anon_sym_nop] = ACTIONS(13),
    [anon_sym_move] = ACTIONS(13),
    [anon_sym_move_SLASHfrom16] = ACTIONS(51),
    [anon_sym_move_SLASH16] = ACTIONS(51),
    [anon_sym_move_DASHwide] = ACTIONS(13),
    [anon_sym_move_DASHwide_SLASHfrom16] = ACTIONS(51),
    [anon_sym_move_DASHwide_SLASH16] = ACTIONS(51),
    [anon_sym_move_DASHobject] = ACTIONS(13),
    [anon_sym_move_DASHobject_SLASHfrom16] = ACTIONS(51),
    [anon_sym_move_DASHobject_SLASH16] = ACTIONS(51),
    [anon_sym_move_DASHresult] = ACTIONS(13),
    [anon_sym_move_DASHresult_DASHwide] = ACTIONS(13),
    [anon_sym_move_DASHresult_DASHobject] = ACTIONS(13),
    [anon_sym_move_DASHexception] = ACTIONS(13),
    [anon_sym_return_DASHvoid] = ACTIONS(13),
    [anon_sym_return] = ACTIONS(13),
    [anon_sym_return_DASHwide] = ACTIONS(13),
    [anon_sym_return_DASHobject] = ACTIONS(13),
    [anon_sym_const_SLASH4] = ACTIONS(51),
    [anon_sym_const_SLASH16] = ACTIONS(51),
    [anon_sym_const] = ACTIONS(13),
    [anon_sym_const_SLASHhigh16] = ACTIONS(51),
    [anon_sym_const_DASHwide_SLASH16] = ACTIONS(51),
    [anon_sym_const_DASHwide_SLASH32] = ACTIONS(51),
    [anon_sym_const_DASHwide] = ACTIONS(13),
    [anon_sym_const_DASHwide_SLASHhigh16] = ACTIONS(51),
    [anon_sym_const_DASHstring] = ACTIONS(13),
    [anon_sym_const_DASHstring_SLASHjumbo] = ACTIONS(51),
    [anon_sym_const_DASHclass] = ACTIONS(13),
    [anon_sym_const_DASHmethod_DASHhandle] = ACTIONS(13),
    [anon_sym_const_DASHmethod_DASHtype] = ACTIONS(13),
    [anon_sym_monitor_DASHenter] = ACTIONS(13),
    [anon_sym_monitor_DASHexit] = ACTIONS(13),
    [anon_sym_check_DASHcast] = ACTIONS(13),
    [anon_sym_instance_DASHof] = ACTIONS(13),
    [anon_sym_array_DASHlength] = ACTIONS(13),
    [anon_sym_new_DASHinstance] = ACTIONS(13),
    [anon_sym_new_DASHarray] = ACTIONS(13),
    [anon_sym_filled_DASHnew_DASHarray] = ACTIONS(13),
    [anon_sym_filled_DASHnew_DASHarray_SLASHrange] = ACTIONS(51),
    [anon_sym_fill_DASHarray_DASHdata] = ACTIONS(13),
    [anon_sym_throw] = ACTIONS(13),
    [anon_sym_throw_DASHverification_DASHerror] = ACTIONS(13),
    [anon_sym_goto] = ACTIONS(13),
    [anon_sym_goto_SLASH16] = ACTIONS(51),
    [anon_sym_goto_SLASH32] = ACTIONS(51),
    [anon_sym_packed_DASHswitch] = ACTIONS(13),
    [anon_sym_sparse_DASHswitch] = ACTIONS(13),
    [anon_sym_cmpl_DASHfloat] = ACTIONS(13),
    [anon_sym_cmpg_DASHfloat] = ACTIONS(13),
    [anon_sym_cmpl_DASHdouble] = ACTIONS(13),
    [anon_sym_cmpg_DASHdouble] = ACTIONS(13),
    [anon_sym_cmp_DASHlong] = ACTIONS(13),
    [anon_sym_if_DASHeq] = ACTIONS(13),
    [anon_sym_if_DASHne] = ACTIONS(13),
    [anon_sym_if_DASHlt] = ACTIONS(13),
    [anon_sym_if_DASHge] = ACTIONS(13),
    [anon_sym_if_DASHgt] = ACTIONS(13),
    [anon_sym_if_DASHle] = ACTIONS(13),
    [anon_sym_if_DASHeqz] = ACTIONS(13),
    [anon_sym_if_DASHnez] = ACTIONS(13),
    [anon_sym_if_DASHltz] = ACTIONS(13),
    [anon_sym_if_DASHgez] = ACTIONS(13),
    [anon_sym_if_DASHgtz] = ACTIONS(13),
    [anon_sym_if_DASHlez] = ACTIONS(13),
    [anon_sym_aget] = ACTIONS(13),
    [anon_sym_aget_DASHwide] = ACTIONS(13),
    [anon_sym_aget_DASHobject] = ACTIONS(13),
    [anon_sym_aget_DASHboolean] = ACTIONS(13),
    [anon_sym_aget_DASHbyte] = ACTIONS(13),
    [anon_sym_aget_DASHchar] = ACTIONS(13),
    [anon_sym_aget_DASHshort] = ACTIONS(13),
    [anon_sym_aput] = ACTIONS(13),
    [anon_sym_aput_DASHwide] = ACTIONS(13),
    [anon_sym_aput_DASHobject] = ACTIONS(13),
    [anon_sym_aput_DASHboolean] = ACTIONS(13),
    [anon_sym_aput_DASHbyte] = ACTIONS(13),
    [anon_sym_aput_DASHchar] = ACTIONS(13),
    [anon_sym_aput_DASHshort] = ACTIONS(13),
    [anon_sym_iget] = ACTIONS(13),
    [anon_sym_iget_DASHwide] = ACTIONS(13),
    [anon_sym_iget_DASHobject] = ACTIONS(13),
    [anon_sym_iget_DASHboolean] = ACTIONS(13),
    [anon_sym_iget_DASHbyte] = ACTIONS(13),
    [anon_sym_iget_DASHchar] = ACTIONS(13),
    [anon_sym_iget_DASHshort] = ACTIONS(13),
    [anon_sym_iget_DASHvolatile] = ACTIONS(13),
    [anon_sym_iget_DASHwide_DASHvolatile] = ACTIONS(13),
    [anon_sym_iget_DASHobject_DASHvolatile] = ACTIONS(13),
    [anon_sym_iput] = ACTIONS(13),
    [anon_sym_iput_DASHwide] = ACTIONS(13),
    [anon_sym_iput_DASHobject] = ACTIONS(13),
    [anon_sym_iput_DASHboolean] = ACTIONS(13),
    [anon_sym_iput_DASHbyte] = ACTIONS(13),
    [anon_sym_iput_DASHchar] = ACTIONS(13),
    [anon_sym_iput_DASHshort] = ACTIONS(13),
    [anon_sym_iput_DASHvolatile] = ACTIONS(13),
    [anon_sym_iput_DASHwide_DASHvolatile] = ACTIONS(13),
    [anon_sym_iput_DASHobject_DASHvolatile] = ACTIONS(13),
    [anon_sym_sget] = ACTIONS(13),
    [anon_sym_sget_DASHwide] = ACTIONS(13),
    [anon_sym_sget_DASHobject] = ACTIONS(13),
    [anon_sym_sget_DASHboolean] = ACTIONS(13),
    [anon_sym_sget_DASHbyte] = ACTIONS(13),
    [anon_sym_sget_DASHchar] = ACTIONS(13),
    [anon_sym_sget_DASHshort] = ACTIONS(13),
    [anon_sym_sget_DASHvolatile] = ACTIONS(13),
    [anon_sym_sget_DASHwide_DASHvolatile] = ACTIONS(13),
    [anon_sym_sget_DASHobject_DASHvolatile] = ACTIONS(13),
    [anon_sym_sput] = ACTIONS(13),
    [anon_sym_sput_DASHwide] = ACTIONS(13),
    [anon_sym_sput_DASHobject] = ACTIONS(13),
    [anon_sym_sput_DASHboolean] = ACTIONS(13),
    [anon_sym_sput_DASHbyte] = ACTIONS(13),
    [anon_sym_sput_DASHchar] = ACTIONS(13),
    [anon_sym_sput_DASHshort] = ACTIONS(13),
    [anon_sym_sput_DASHvolatile] = ACTIONS(13),
    [anon_sym_sput_DASHwide_DASHvolatile] = ACTIONS(13),
    [anon_sym_sput_DASHobject_DASHvolatile] = ACTIONS(13),
    [anon_sym_invoke_DASHconstructor] = ACTIONS(13),
    [anon_sym_invoke_DASHcustom] = ACTIONS(13),
    [anon_sym_invoke_DASHdirect] = ACTIONS(13),
    [anon_sym_invoke_DASHdirect_DASHempty] = ACTIONS(13),
    [anon_sym_invoke_DASHinstance] = ACTIONS(13),
    [anon_sym_invoke_DASHinterface] = ACTIONS(13),
    [anon_sym_invoke_DASHpolymorphic] = ACTIONS(13),
    [anon_sym_invoke_DASHstatic] = ACTIONS(13),
    [anon_sym_invoke_DASHsuper] = ACTIONS(13),
    [anon_sym_invoke_DASHvirtual] = ACTIONS(13),
    [anon_sym_invoke_DASHcustom_SLASHrange] = ACTIONS(51),
    [anon_sym_invoke_DASHdirect_SLASHrange] = ACTIONS(51),
    [anon_sym_invoke_DASHinterface_SLASHrange] = ACTIONS(51),
    [anon_sym_invoke_DASHobject_DASHinit_SLASHrange] = ACTIONS(51),
    [anon_sym_invoke_DASHpolymorphic_SLASHrange] = ACTIONS(51),
    [anon_sym_invoke_DASHstatic_SLASHrange] = ACTIONS(51),
    [anon_sym_invoke_DASHsuper_SLASHrange] = ACTIONS(51),
    [anon_sym_invoke_DASHvirtual_SLASHrange] = ACTIONS(51),
    [anon_sym_neg_DASHint] = ACTIONS(13),
    [anon_sym_not_DASHint] = ACTIONS(13),
    [anon_sym_neg_DASHlong] = ACTIONS(13),
    [anon_sym_not_DASHlong] = ACTIONS(13),
    [anon_sym_neg_DASHfloat] = ACTIONS(13),
    [anon_sym_neg_DASHdouble] = ACTIONS(13),
    [anon_sym_int_DASHto_DASHlong] = ACTIONS(13),
    [anon_sym_int_DASHto_DASHfloat] = ACTIONS(13),
    [anon_sym_int_DASHto_DASHdouble] = ACTIONS(13),
    [anon_sym_long_DASHto_DASHint] = ACTIONS(13),
    [anon_sym_long_DASHto_DASHfloat] = ACTIONS(13),
    [anon_sym_long_DASHto_DASHdouble] = ACTIONS(13),
    [anon_sym_float_DASHto_DASHint] = ACTIONS(13),
    [anon_sym_float_DASHto_DASHlong] = ACTIONS(13),
    [anon_sym_float_DASHto_DASHdouble] = ACTIONS(13),
    [anon_sym_double_DASHto_DASHint] = ACTIONS(13),
    [anon_sym_double_DASHto_DASHlong] = ACTIONS(13),
    [anon_sym_double_DASHto_DASHfloat] = ACTIONS(13),
    [anon_sym_int_DASHto_DASHbyte] = ACTIONS(13),
    [anon_sym_int_DASHto_DASHchar] = ACTIONS(13),
    [anon_sym_int_DASHto_DASHshort] = ACTIONS(13),
    [anon_sym_add_DASHint] = ACTIONS(13),
    [anon_sym_sub_DASHint] = ACTIONS(13),
    [anon_sym_mul_DASHint] = ACTIONS(13),
    [anon_sym_div_DASHint] = ACTIONS(13),
    [anon_sym_rem_DASHint] = ACTIONS(13),
    [anon_sym_and_DASHint] = ACTIONS(13),
    [anon_sym_or_DASHint] = ACTIONS(13),
    [anon_sym_xor_DASHint] = ACTIONS(13),
    [anon_sym_shl_DASHint] = ACTIONS(13),
    [anon_sym_shr_DASHint] = ACTIONS(13),
    [anon_sym_ushr_DASHint] = ACTIONS(13),
    [anon_sym_add_DASHlong] = ACTIONS(13),
    [anon_sym_sub_DASHlong] = ACTIONS(13),
    [anon_sym_mul_DASHlong] = ACTIONS(13),
    [anon_sym_div_DASHlong] = ACTIONS(13),
    [anon_sym_rem_DASHlong] = ACTIONS(13),
    [anon_sym_and_DASHlong] = ACTIONS(13),
    [anon_sym_or_DASHlong] = ACTIONS(13),
    [anon_sym_xor_DASHlong] = ACTIONS(13),
    [anon_sym_shl_DASHlong] = ACTIONS(13),
    [anon_sym_shr_DASHlong] = ACTIONS(13),
    [anon_sym_ushr_DASHlong] = ACTIONS(13),
    [anon_sym_add_DASHfloat] = ACTIONS(13),
    [anon_sym_sub_DASHfloat] = ACTIONS(13),
    [anon_sym_mul_DASHfloat] = ACTIONS(13),
    [anon_sym_div_DASHfloat] = ACTIONS(13),
    [anon_sym_rem_DASHfloat] = ACTIONS(13),
    [anon_sym_add_DASHdouble] = ACTIONS(13),
    [anon_sym_sub_DASHdouble] = ACTIONS(13),
    [anon_sym_mul_DASHdouble] = ACTIONS(13),
    [anon_sym_div_DASHdouble] = ACTIONS(13),
    [anon_sym_rem_DASHdouble] = ACTIONS(13),
    [anon_sym_add_DASHint_SLASH2addr] = ACTIONS(51),
    [anon_sym_sub_DASHint_SLASH2addr] = ACTIONS(51),
    [anon_sym_mul_DASHint_SLASH2addr] = ACTIONS(51),
    [anon_sym_div_DASHint_SLASH2addr] = ACTIONS(51),
    [anon_sym_rem_DASHint_SLASH2addr] = ACTIONS(51),
    [anon_sym_and_DASHint_SLASH2addr] = ACTIONS(51),
    [anon_sym_or_DASHint_SLASH2addr] = ACTIONS(51),
    [anon_sym_xor_DASHint_SLASH2addr] = ACTIONS(51),
    [anon_sym_shl_DASHint_SLASH2addr] = ACTIONS(51),
    [anon_sym_shr_DASHint_SLASH2addr] = ACTIONS(51),
    [anon_sym_ushr_DASHint_SLASH2addr] = ACTIONS(51),
    [anon_sym_add_DASHlong_SLASH2addr] = ACTIONS(51),
    [anon_sym_sub_DASHlong_SLASH2addr] = ACTIONS(51),
    [anon_sym_mul_DASHlong_SLASH2addr] = ACTIONS(51),
    [anon_sym_div_DASHlong_SLASH2addr] = ACTIONS(51),
    [anon_sym_rem_DASHlong_SLASH2addr] = ACTIONS(51),
    [anon_sym_and_DASHlong_SLASH2addr] = ACTIONS(51),
    [anon_sym_or_DASHlong_SLASH2addr] = ACTIONS(51),
    [anon_sym_xor_DASHlong_SLASH2addr] = ACTIONS(51),
    [anon_sym_shl_DASHlong_SLASH2addr] = ACTIONS(51),
    [anon_sym_shr_DASHlong_SLASH2addr] = ACTIONS(51),
    [anon_sym_ushr_DASHlong_SLASH2addr] = ACTIONS(51),
    [anon_sym_add_DASHfloat_SLASH2addr] = ACTIONS(51),
    [anon_sym_sub_DASHfloat_SLASH2addr] = ACTIONS(51),
    [anon_sym_mul_DASHfloat_SLASH2addr] = ACTIONS(51),
    [anon_sym_div_DASHfloat_SLASH2addr] = ACTIONS(51),
    [anon_sym_rem_DASHfloat_SLASH2addr] = ACTIONS(51),
    [anon_sym_add_DASHdouble_SLASH2addr] = ACTIONS(51),
    [anon_sym_sub_DASHdouble_SLASH2addr] = ACTIONS(51),
    [anon_sym_mul_DASHdouble_SLASH2addr] = ACTIONS(51),
    [anon_sym_div_DASHdouble_SLASH2addr] = ACTIONS(51),
    [anon_sym_rem_DASHdouble_SLASH2addr] = ACTIONS(51),
    [anon_sym_add_DASHint_SLASHlit16] = ACTIONS(51),
    [anon_sym_sub_DASHint_SLASHlit16] = ACTIONS(51),
    [anon_sym_mul_DASHint_SLASHlit16] = ACTIONS(51),
    [anon_sym_div_DASHint_SLASHlit16] = ACTIONS(51),
    [anon_sym_rem_DASHint_SLASHlit16] = ACTIONS(51),
    [anon_sym_and_DASHint_SLASHlit16] = ACTIONS(51),
    [anon_sym_or_DASHint_SLASHlit16] = ACTIONS(51),
    [anon_sym_xor_DASHint_SLASHlit16] = ACTIONS(51),
    [anon_sym_add_DASHint_SLASHlit8] = ACTIONS(51),
    [anon_sym_sub_DASHint_SLASHlit8] = ACTIONS(51),
    [anon_sym_mul_DASHint_SLASHlit8] = ACTIONS(51),
    [anon_sym_div_DASHint_SLASHlit8] = ACTIONS(51),
    [anon_sym_rem_DASHint_SLASHlit8] = ACTIONS(51),
    [anon_sym_and_DASHint_SLASHlit8] = ACTIONS(51),
    [anon_sym_or_DASHint_SLASHlit8] = ACTIONS(51),
    [anon_sym_xor_DASHint_SLASHlit8] = ACTIONS(51),
    [anon_sym_shl_DASHint_SLASHlit8] = ACTIONS(51),
    [anon_sym_shr_DASHint_SLASHlit8] = ACTIONS(51),
    [anon_sym_ushr_DASHint_SLASHlit8] = ACTIONS(51),
    [anon_sym_static_DASHget] = ACTIONS(13),
    [anon_sym_static_DASHput] = ACTIONS(13),
    [anon_sym_instance_DASHget] = ACTIONS(13),
    [anon_sym_instance_DASHput] = ACTIONS(13),
    [anon_sym_execute_DASHinline] = ACTIONS(13),
    [anon_sym_execute_DASHinline_SLASHrange] = ACTIONS(51),
    [anon_sym_iget_DASHquick] = ACTIONS(13),
    [anon_sym_iget_DASHwide_DASHquick] = ACTIONS(13),
    [anon_sym_iget_DASHobject_DASHquick] = ACTIONS(13),
    [anon_sym_iput_DASHquick] = ACTIONS(13),
    [anon_sym_iput_DASHwide_DASHquick] = ACTIONS(13),
    [anon_sym_iput_DASHobject_DASHquick] = ACTIONS(13),
    [anon_sym_iput_DASHboolean_DASHquick] = ACTIONS(13),
    [anon_sym_iput_DASHbyte_DASHquick] = ACTIONS(13),
    [anon_sym_iput_DASHchar_DASHquick] = ACTIONS(13),
    [anon_sym_iput_DASHshort_DASHquick] = ACTIONS(13),
    [anon_sym_invoke_DASHvirtual_DASHquick] = ACTIONS(13),
    [anon_sym_invoke_DASHvirtual_DASHquick_SLASHrange] = ACTIONS(51),
    [anon_sym_invoke_DASHsuper_DASHquick] = ACTIONS(13),
    [anon_sym_invoke_DASHsuper_DASHquick_SLASHrange] = ACTIONS(51),
    [anon_sym_rsub_DASHint] = ACTIONS(13),
    [anon_sym_rsub_DASHint_SLASHlit8] = ACTIONS(51),
    [anon_sym_LBRACE] = ACTIONS(95),
    [aux_sym_label_token1] = ACTIONS(97),
    [aux_sym_jmp_label_token1] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_LPAREN] = ACTIONS(99),
    [anon_sym_LBRACK] = ACTIONS(101),
    [aux_sym_primitive_type_token1] = ACTIONS(27),
    [aux_sym_primitive_type_token2] = ACTIONS(27),
    [anon_sym_DOTenum] = ACTIONS(103),
    [sym_variable] = ACTIONS(31),
    [sym_parameter] = ACTIONS(31),
    [sym_number] = ACTIONS(33),
    [sym_float] = ACTIONS(35),
    [sym_NaN] = ACTIONS(105),
    [sym_Infinity] = ACTIONS(105),
    [anon_sym_DQUOTE] = ACTIONS(107),
    [anon_sym_true] = ACTIONS(39),
    [anon_sym_false] = ACTIONS(39),
    [anon_sym_SQUOTE] = ACTIONS(109),
    [sym_null] = ACTIONS(35),
    [sym_comment] = ACTIONS(3),
    [sym_L] = ACTIONS(45),
  },
  [8] = {
    [sym_subannotation_directive] = STATE(143),
    [sym_opcode] = STATE(404),
    [sym_value] = STATE(299),
    [sym_class_identifier] = STATE(124),
    [sym_label] = STATE(143),
    [sym_jmp_label] = STATE(143),
    [sym_body] = STATE(143),
    [sym__field_body] = STATE(94),
    [sym_method_signature] = STATE(94),
    [sym__method_signature_body] = STATE(95),
    [sym_method_handle] = STATE(143),
    [sym__full_field_body] = STATE(94),
    [sym_full_method_signature] = STATE(94),
    [sym_custom_invoke] = STATE(143),
    [sym_type] = STATE(143),
    [sym_array_type] = STATE(124),
    [sym_primitive_type] = STATE(20),
    [sym_enum_reference] = STATE(143),
    [sym_register] = STATE(143),
    [sym_list] = STATE(143),
    [sym_range] = STATE(143),
    [sym_literal] = STATE(143),
    [sym_string] = STATE(25),
    [sym_boolean] = STATE(25),
    [sym_character] = STATE(25),
    [sym_identifier] = ACTIONS(47),
    [anon_sym_DOTsubannotation] = ACTIONS(49),
    [anon_sym_nop] = ACTIONS(13),
    [anon_sym_move] = ACTIONS(13),
    [anon_sym_move_SLASHfrom16] = ACTIONS(51),
    [anon_sym_move_SLASH16] = ACTIONS(51),
    [anon_sym_move_DASHwide] = ACTIONS(13),
    [anon_sym_move_DASHwide_SLASHfrom16] = ACTIONS(51),
    [anon_sym_move_DASHwide_SLASH16] = ACTIONS(51),
    [anon_sym_move_DASHobject] = ACTIONS(13),
    [anon_sym_move_DASHobject_SLASHfrom16] = ACTIONS(51),
    [anon_sym_move_DASHobject_SLASH16] = ACTIONS(51),
    [anon_sym_move_DASHresult] = ACTIONS(13),
    [anon_sym_move_DASHresult_DASHwide] = ACTIONS(13),
    [anon_sym_move_DASHresult_DASHobject] = ACTIONS(13),
    [anon_sym_move_DASHexception] = ACTIONS(13),
    [anon_sym_return_DASHvoid] = ACTIONS(13),
    [anon_sym_return] = ACTIONS(13),
    [anon_sym_return_DASHwide] = ACTIONS(13),
    [anon_sym_return_DASHobject] = ACTIONS(13),
    [anon_sym_const_SLASH4] = ACTIONS(51),
    [anon_sym_const_SLASH16] = ACTIONS(51),
    [anon_sym_const] = ACTIONS(13),
    [anon_sym_const_SLASHhigh16] = ACTIONS(51),
    [anon_sym_const_DASHwide_SLASH16] = ACTIONS(51),
    [anon_sym_const_DASHwide_SLASH32] = ACTIONS(51),
    [anon_sym_const_DASHwide] = ACTIONS(13),
    [anon_sym_const_DASHwide_SLASHhigh16] = ACTIONS(51),
    [anon_sym_const_DASHstring] = ACTIONS(13),
    [anon_sym_const_DASHstring_SLASHjumbo] = ACTIONS(51),
    [anon_sym_const_DASHclass] = ACTIONS(13),
    [anon_sym_const_DASHmethod_DASHhandle] = ACTIONS(13),
    [anon_sym_const_DASHmethod_DASHtype] = ACTIONS(13),
    [anon_sym_monitor_DASHenter] = ACTIONS(13),
    [anon_sym_monitor_DASHexit] = ACTIONS(13),
    [anon_sym_check_DASHcast] = ACTIONS(13),
    [anon_sym_instance_DASHof] = ACTIONS(13),
    [anon_sym_array_DASHlength] = ACTIONS(13),
    [anon_sym_new_DASHinstance] = ACTIONS(13),
    [anon_sym_new_DASHarray] = ACTIONS(13),
    [anon_sym_filled_DASHnew_DASHarray] = ACTIONS(13),
    [anon_sym_filled_DASHnew_DASHarray_SLASHrange] = ACTIONS(51),
    [anon_sym_fill_DASHarray_DASHdata] = ACTIONS(13),
    [anon_sym_throw] = ACTIONS(13),
    [anon_sym_throw_DASHverification_DASHerror] = ACTIONS(13),
    [anon_sym_goto] = ACTIONS(13),
    [anon_sym_goto_SLASH16] = ACTIONS(51),
    [anon_sym_goto_SLASH32] = ACTIONS(51),
    [anon_sym_packed_DASHswitch] = ACTIONS(13),
    [anon_sym_sparse_DASHswitch] = ACTIONS(13),
    [anon_sym_cmpl_DASHfloat] = ACTIONS(13),
    [anon_sym_cmpg_DASHfloat] = ACTIONS(13),
    [anon_sym_cmpl_DASHdouble] = ACTIONS(13),
    [anon_sym_cmpg_DASHdouble] = ACTIONS(13),
    [anon_sym_cmp_DASHlong] = ACTIONS(13),
    [anon_sym_if_DASHeq] = ACTIONS(13),
    [anon_sym_if_DASHne] = ACTIONS(13),
    [anon_sym_if_DASHlt] = ACTIONS(13),
    [anon_sym_if_DASHge] = ACTIONS(13),
    [anon_sym_if_DASHgt] = ACTIONS(13),
    [anon_sym_if_DASHle] = ACTIONS(13),
    [anon_sym_if_DASHeqz] = ACTIONS(13),
    [anon_sym_if_DASHnez] = ACTIONS(13),
    [anon_sym_if_DASHltz] = ACTIONS(13),
    [anon_sym_if_DASHgez] = ACTIONS(13),
    [anon_sym_if_DASHgtz] = ACTIONS(13),
    [anon_sym_if_DASHlez] = ACTIONS(13),
    [anon_sym_aget] = ACTIONS(13),
    [anon_sym_aget_DASHwide] = ACTIONS(13),
    [anon_sym_aget_DASHobject] = ACTIONS(13),
    [anon_sym_aget_DASHboolean] = ACTIONS(13),
    [anon_sym_aget_DASHbyte] = ACTIONS(13),
    [anon_sym_aget_DASHchar] = ACTIONS(13),
    [anon_sym_aget_DASHshort] = ACTIONS(13),
    [anon_sym_aput] = ACTIONS(13),
    [anon_sym_aput_DASHwide] = ACTIONS(13),
    [anon_sym_aput_DASHobject] = ACTIONS(13),
    [anon_sym_aput_DASHboolean] = ACTIONS(13),
    [anon_sym_aput_DASHbyte] = ACTIONS(13),
    [anon_sym_aput_DASHchar] = ACTIONS(13),
    [anon_sym_aput_DASHshort] = ACTIONS(13),
    [anon_sym_iget] = ACTIONS(13),
    [anon_sym_iget_DASHwide] = ACTIONS(13),
    [anon_sym_iget_DASHobject] = ACTIONS(13),
    [anon_sym_iget_DASHboolean] = ACTIONS(13),
    [anon_sym_iget_DASHbyte] = ACTIONS(13),
    [anon_sym_iget_DASHchar] = ACTIONS(13),
    [anon_sym_iget_DASHshort] = ACTIONS(13),
    [anon_sym_iget_DASHvolatile] = ACTIONS(13),
    [anon_sym_iget_DASHwide_DASHvolatile] = ACTIONS(13),
    [anon_sym_iget_DASHobject_DASHvolatile] = ACTIONS(13),
    [anon_sym_iput] = ACTIONS(13),
    [anon_sym_iput_DASHwide] = ACTIONS(13),
    [anon_sym_iput_DASHobject] = ACTIONS(13),
    [anon_sym_iput_DASHboolean] = ACTIONS(13),
    [anon_sym_iput_DASHbyte] = ACTIONS(13),
    [anon_sym_iput_DASHchar] = ACTIONS(13),
    [anon_sym_iput_DASHshort] = ACTIONS(13),
    [anon_sym_iput_DASHvolatile] = ACTIONS(13),
    [anon_sym_iput_DASHwide_DASHvolatile] = ACTIONS(13),
    [anon_sym_iput_DASHobject_DASHvolatile] = ACTIONS(13),
    [anon_sym_sget] = ACTIONS(13),
    [anon_sym_sget_DASHwide] = ACTIONS(13),
    [anon_sym_sget_DASHobject] = ACTIONS(13),
    [anon_sym_sget_DASHboolean] = ACTIONS(13),
    [anon_sym_sget_DASHbyte] = ACTIONS(13),
    [anon_sym_sget_DASHchar] = ACTIONS(13),
    [anon_sym_sget_DASHshort] = ACTIONS(13),
    [anon_sym_sget_DASHvolatile] = ACTIONS(13),
    [anon_sym_sget_DASHwide_DASHvolatile] = ACTIONS(13),
    [anon_sym_sget_DASHobject_DASHvolatile] = ACTIONS(13),
    [anon_sym_sput] = ACTIONS(13),
    [anon_sym_sput_DASHwide] = ACTIONS(13),
    [anon_sym_sput_DASHobject] = ACTIONS(13),
    [anon_sym_sput_DASHboolean] = ACTIONS(13),
    [anon_sym_sput_DASHbyte] = ACTIONS(13),
    [anon_sym_sput_DASHchar] = ACTIONS(13),
    [anon_sym_sput_DASHshort] = ACTIONS(13),
    [anon_sym_sput_DASHvolatile] = ACTIONS(13),
    [anon_sym_sput_DASHwide_DASHvolatile] = ACTIONS(13),
    [anon_sym_sput_DASHobject_DASHvolatile] = ACTIONS(13),
    [anon_sym_invoke_DASHconstructor] = ACTIONS(13),
    [anon_sym_invoke_DASHcustom] = ACTIONS(13),
    [anon_sym_invoke_DASHdirect] = ACTIONS(13),
    [anon_sym_invoke_DASHdirect_DASHempty] = ACTIONS(13),
    [anon_sym_invoke_DASHinstance] = ACTIONS(13),
    [anon_sym_invoke_DASHinterface] = ACTIONS(13),
    [anon_sym_invoke_DASHpolymorphic] = ACTIONS(13),
    [anon_sym_invoke_DASHstatic] = ACTIONS(13),
    [anon_sym_invoke_DASHsuper] = ACTIONS(13),
    [anon_sym_invoke_DASHvirtual] = ACTIONS(13),
    [anon_sym_invoke_DASHcustom_SLASHrange] = ACTIONS(51),
    [anon_sym_invoke_DASHdirect_SLASHrange] = ACTIONS(51),
    [anon_sym_invoke_DASHinterface_SLASHrange] = ACTIONS(51),
    [anon_sym_invoke_DASHobject_DASHinit_SLASHrange] = ACTIONS(51),
    [anon_sym_invoke_DASHpolymorphic_SLASHrange] = ACTIONS(51),
    [anon_sym_invoke_DASHstatic_SLASHrange] = ACTIONS(51),
    [anon_sym_invoke_DASHsuper_SLASHrange] = ACTIONS(51),
    [anon_sym_invoke_DASHvirtual_SLASHrange] = ACTIONS(51),
    [anon_sym_neg_DASHint] = ACTIONS(13),
    [anon_sym_not_DASHint] = ACTIONS(13),
    [anon_sym_neg_DASHlong] = ACTIONS(13),
    [anon_sym_not_DASHlong] = ACTIONS(13),
    [anon_sym_neg_DASHfloat] = ACTIONS(13),
    [anon_sym_neg_DASHdouble] = ACTIONS(13),
    [anon_sym_int_DASHto_DASHlong] = ACTIONS(13),
    [anon_sym_int_DASHto_DASHfloat] = ACTIONS(13),
    [anon_sym_int_DASHto_DASHdouble] = ACTIONS(13),
    [anon_sym_long_DASHto_DASHint] = ACTIONS(13),
    [anon_sym_long_DASHto_DASHfloat] = ACTIONS(13),
    [anon_sym_long_DASHto_DASHdouble] = ACTIONS(13),
    [anon_sym_float_DASHto_DASHint] = ACTIONS(13),
    [anon_sym_float_DASHto_DASHlong] = ACTIONS(13),
    [anon_sym_float_DASHto_DASHdouble] = ACTIONS(13),
    [anon_sym_double_DASHto_DASHint] = ACTIONS(13),
    [anon_sym_double_DASHto_DASHlong] = ACTIONS(13),
    [anon_sym_double_DASHto_DASHfloat] = ACTIONS(13),
    [anon_sym_int_DASHto_DASHbyte] = ACTIONS(13),
    [anon_sym_int_DASHto_DASHchar] = ACTIONS(13),
    [anon_sym_int_DASHto_DASHshort] = ACTIONS(13),
    [anon_sym_add_DASHint] = ACTIONS(13),
    [anon_sym_sub_DASHint] = ACTIONS(13),
    [anon_sym_mul_DASHint] = ACTIONS(13),
    [anon_sym_div_DASHint] = ACTIONS(13),
    [anon_sym_rem_DASHint] = ACTIONS(13),
    [anon_sym_and_DASHint] = ACTIONS(13),
    [anon_sym_or_DASHint] = ACTIONS(13),
    [anon_sym_xor_DASHint] = ACTIONS(13),
    [anon_sym_shl_DASHint] = ACTIONS(13),
    [anon_sym_shr_DASHint] = ACTIONS(13),
    [anon_sym_ushr_DASHint] = ACTIONS(13),
    [anon_sym_add_DASHlong] = ACTIONS(13),
    [anon_sym_sub_DASHlong] = ACTIONS(13),
    [anon_sym_mul_DASHlong] = ACTIONS(13),
    [anon_sym_div_DASHlong] = ACTIONS(13),
    [anon_sym_rem_DASHlong] = ACTIONS(13),
    [anon_sym_and_DASHlong] = ACTIONS(13),
    [anon_sym_or_DASHlong] = ACTIONS(13),
    [anon_sym_xor_DASHlong] = ACTIONS(13),
    [anon_sym_shl_DASHlong] = ACTIONS(13),
    [anon_sym_shr_DASHlong] = ACTIONS(13),
    [anon_sym_ushr_DASHlong] = ACTIONS(13),
    [anon_sym_add_DASHfloat] = ACTIONS(13),
    [anon_sym_sub_DASHfloat] = ACTIONS(13),
    [anon_sym_mul_DASHfloat] = ACTIONS(13),
    [anon_sym_div_DASHfloat] = ACTIONS(13),
    [anon_sym_rem_DASHfloat] = ACTIONS(13),
    [anon_sym_add_DASHdouble] = ACTIONS(13),
    [anon_sym_sub_DASHdouble] = ACTIONS(13),
    [anon_sym_mul_DASHdouble] = ACTIONS(13),
    [anon_sym_div_DASHdouble] = ACTIONS(13),
    [anon_sym_rem_DASHdouble] = ACTIONS(13),
    [anon_sym_add_DASHint_SLASH2addr] = ACTIONS(51),
    [anon_sym_sub_DASHint_SLASH2addr] = ACTIONS(51),
    [anon_sym_mul_DASHint_SLASH2addr] = ACTIONS(51),
    [anon_sym_div_DASHint_SLASH2addr] = ACTIONS(51),
    [anon_sym_rem_DASHint_SLASH2addr] = ACTIONS(51),
    [anon_sym_and_DASHint_SLASH2addr] = ACTIONS(51),
    [anon_sym_or_DASHint_SLASH2addr] = ACTIONS(51),
    [anon_sym_xor_DASHint_SLASH2addr] = ACTIONS(51),
    [anon_sym_shl_DASHint_SLASH2addr] = ACTIONS(51),
    [anon_sym_shr_DASHint_SLASH2addr] = ACTIONS(51),
    [anon_sym_ushr_DASHint_SLASH2addr] = ACTIONS(51),
    [anon_sym_add_DASHlong_SLASH2addr] = ACTIONS(51),
    [anon_sym_sub_DASHlong_SLASH2addr] = ACTIONS(51),
    [anon_sym_mul_DASHlong_SLASH2addr] = ACTIONS(51),
    [anon_sym_div_DASHlong_SLASH2addr] = ACTIONS(51),
    [anon_sym_rem_DASHlong_SLASH2addr] = ACTIONS(51),
    [anon_sym_and_DASHlong_SLASH2addr] = ACTIONS(51),
    [anon_sym_or_DASHlong_SLASH2addr] = ACTIONS(51),
    [anon_sym_xor_DASHlong_SLASH2addr] = ACTIONS(51),
    [anon_sym_shl_DASHlong_SLASH2addr] = ACTIONS(51),
    [anon_sym_shr_DASHlong_SLASH2addr] = ACTIONS(51),
    [anon_sym_ushr_DASHlong_SLASH2addr] = ACTIONS(51),
    [anon_sym_add_DASHfloat_SLASH2addr] = ACTIONS(51),
    [anon_sym_sub_DASHfloat_SLASH2addr] = ACTIONS(51),
    [anon_sym_mul_DASHfloat_SLASH2addr] = ACTIONS(51),
    [anon_sym_div_DASHfloat_SLASH2addr] = ACTIONS(51),
    [anon_sym_rem_DASHfloat_SLASH2addr] = ACTIONS(51),
    [anon_sym_add_DASHdouble_SLASH2addr] = ACTIONS(51),
    [anon_sym_sub_DASHdouble_SLASH2addr] = ACTIONS(51),
    [anon_sym_mul_DASHdouble_SLASH2addr] = ACTIONS(51),
    [anon_sym_div_DASHdouble_SLASH2addr] = ACTIONS(51),
    [anon_sym_rem_DASHdouble_SLASH2addr] = ACTIONS(51),
    [anon_sym_add_DASHint_SLASHlit16] = ACTIONS(51),
    [anon_sym_sub_DASHint_SLASHlit16] = ACTIONS(51),
    [anon_sym_mul_DASHint_SLASHlit16] = ACTIONS(51),
    [anon_sym_div_DASHint_SLASHlit16] = ACTIONS(51),
    [anon_sym_rem_DASHint_SLASHlit16] = ACTIONS(51),
    [anon_sym_and_DASHint_SLASHlit16] = ACTIONS(51),
    [anon_sym_or_DASHint_SLASHlit16] = ACTIONS(51),
    [anon_sym_xor_DASHint_SLASHlit16] = ACTIONS(51),
    [anon_sym_add_DASHint_SLASHlit8] = ACTIONS(51),
    [anon_sym_sub_DASHint_SLASHlit8] = ACTIONS(51),
    [anon_sym_mul_DASHint_SLASHlit8] = ACTIONS(51),
    [anon_sym_div_DASHint_SLASHlit8] = ACTIONS(51),
    [anon_sym_rem_DASHint_SLASHlit8] = ACTIONS(51),
    [anon_sym_and_DASHint_SLASHlit8] = ACTIONS(51),
    [anon_sym_or_DASHint_SLASHlit8] = ACTIONS(51),
    [anon_sym_xor_DASHint_SLASHlit8] = ACTIONS(51),
    [anon_sym_shl_DASHint_SLASHlit8] = ACTIONS(51),
    [anon_sym_shr_DASHint_SLASHlit8] = ACTIONS(51),
    [anon_sym_ushr_DASHint_SLASHlit8] = ACTIONS(51),
    [anon_sym_static_DASHget] = ACTIONS(13),
    [anon_sym_static_DASHput] = ACTIONS(13),
    [anon_sym_instance_DASHget] = ACTIONS(13),
    [anon_sym_instance_DASHput] = ACTIONS(13),
    [anon_sym_execute_DASHinline] = ACTIONS(13),
    [anon_sym_execute_DASHinline_SLASHrange] = ACTIONS(51),
    [anon_sym_iget_DASHquick] = ACTIONS(13),
    [anon_sym_iget_DASHwide_DASHquick] = ACTIONS(13),
    [anon_sym_iget_DASHobject_DASHquick] = ACTIONS(13),
    [anon_sym_iput_DASHquick] = ACTIONS(13),
    [anon_sym_iput_DASHwide_DASHquick] = ACTIONS(13),
    [anon_sym_iput_DASHobject_DASHquick] = ACTIONS(13),
    [anon_sym_iput_DASHboolean_DASHquick] = ACTIONS(13),
    [anon_sym_iput_DASHbyte_DASHquick] = ACTIONS(13),
    [anon_sym_iput_DASHchar_DASHquick] = ACTIONS(13),
    [anon_sym_iput_DASHshort_DASHquick] = ACTIONS(13),
    [anon_sym_invoke_DASHvirtual_DASHquick] = ACTIONS(13),
    [anon_sym_invoke_DASHvirtual_DASHquick_SLASHrange] = ACTIONS(51),
    [anon_sym_invoke_DASHsuper_DASHquick] = ACTIONS(13),
    [anon_sym_invoke_DASHsuper_DASHquick_SLASHrange] = ACTIONS(51),
    [anon_sym_rsub_DASHint] = ACTIONS(13),
    [anon_sym_rsub_DASHint_SLASHlit8] = ACTIONS(51),
    [anon_sym_LBRACE] = ACTIONS(53),
    [aux_sym_label_token1] = ACTIONS(57),
    [aux_sym_jmp_label_token1] = ACTIONS(59),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_LPAREN] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [aux_sym_primitive_type_token1] = ACTIONS(67),
    [aux_sym_primitive_type_token2] = ACTIONS(67),
    [anon_sym_DOTenum] = ACTIONS(69),
    [sym_variable] = ACTIONS(71),
    [sym_parameter] = ACTIONS(71),
    [sym_number] = ACTIONS(87),
    [sym_float] = ACTIONS(75),
    [sym_NaN] = ACTIONS(77),
    [sym_Infinity] = ACTIONS(77),
    [anon_sym_DQUOTE] = ACTIONS(79),
    [anon_sym_true] = ACTIONS(81),
    [anon_sym_false] = ACTIONS(81),
    [anon_sym_SQUOTE] = ACTIONS(83),
    [sym_null] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [sym_L] = ACTIONS(85),
  },
  [9] = {
    [sym_subannotation_directive] = STATE(143),
    [sym_opcode] = STATE(404),
    [sym_value] = STATE(148),
    [sym_class_identifier] = STATE(124),
    [sym_label] = STATE(143),
    [sym_jmp_label] = STATE(143),
    [sym_body] = STATE(143),
    [sym__field_body] = STATE(94),
    [sym_method_signature] = STATE(94),
    [sym__method_signature_body] = STATE(95),
    [sym_method_handle] = STATE(143),
    [sym__full_field_body] = STATE(94),
    [sym_full_method_signature] = STATE(94),
    [sym_custom_invoke] = STATE(143),
    [sym_type] = STATE(143),
    [sym_array_type] = STATE(124),
    [sym_primitive_type] = STATE(20),
    [sym_enum_reference] = STATE(143),
    [sym_register] = STATE(143),
    [sym_list] = STATE(143),
    [sym_range] = STATE(143),
    [sym_literal] = STATE(143),
    [sym_string] = STATE(25),
    [sym_boolean] = STATE(25),
    [sym_character] = STATE(25),
    [sym_identifier] = ACTIONS(47),
    [anon_sym_DOTsubannotation] = ACTIONS(49),
    [anon_sym_nop] = ACTIONS(13),
    [anon_sym_move] = ACTIONS(13),
    [anon_sym_move_SLASHfrom16] = ACTIONS(51),
    [anon_sym_move_SLASH16] = ACTIONS(51),
    [anon_sym_move_DASHwide] = ACTIONS(13),
    [anon_sym_move_DASHwide_SLASHfrom16] = ACTIONS(51),
    [anon_sym_move_DASHwide_SLASH16] = ACTIONS(51),
    [anon_sym_move_DASHobject] = ACTIONS(13),
    [anon_sym_move_DASHobject_SLASHfrom16] = ACTIONS(51),
    [anon_sym_move_DASHobject_SLASH16] = ACTIONS(51),
    [anon_sym_move_DASHresult] = ACTIONS(13),
    [anon_sym_move_DASHresult_DASHwide] = ACTIONS(13),
    [anon_sym_move_DASHresult_DASHobject] = ACTIONS(13),
    [anon_sym_move_DASHexception] = ACTIONS(13),
    [anon_sym_return_DASHvoid] = ACTIONS(13),
    [anon_sym_return] = ACTIONS(13),
    [anon_sym_return_DASHwide] = ACTIONS(13),
    [anon_sym_return_DASHobject] = ACTIONS(13),
    [anon_sym_const_SLASH4] = ACTIONS(51),
    [anon_sym_const_SLASH16] = ACTIONS(51),
    [anon_sym_const] = ACTIONS(13),
    [anon_sym_const_SLASHhigh16] = ACTIONS(51),
    [anon_sym_const_DASHwide_SLASH16] = ACTIONS(51),
    [anon_sym_const_DASHwide_SLASH32] = ACTIONS(51),
    [anon_sym_const_DASHwide] = ACTIONS(13),
    [anon_sym_const_DASHwide_SLASHhigh16] = ACTIONS(51),
    [anon_sym_const_DASHstring] = ACTIONS(13),
    [anon_sym_const_DASHstring_SLASHjumbo] = ACTIONS(51),
    [anon_sym_const_DASHclass] = ACTIONS(13),
    [anon_sym_const_DASHmethod_DASHhandle] = ACTIONS(13),
    [anon_sym_const_DASHmethod_DASHtype] = ACTIONS(13),
    [anon_sym_monitor_DASHenter] = ACTIONS(13),
    [anon_sym_monitor_DASHexit] = ACTIONS(13),
    [anon_sym_check_DASHcast] = ACTIONS(13),
    [anon_sym_instance_DASHof] = ACTIONS(13),
    [anon_sym_array_DASHlength] = ACTIONS(13),
    [anon_sym_new_DASHinstance] = ACTIONS(13),
    [anon_sym_new_DASHarray] = ACTIONS(13),
    [anon_sym_filled_DASHnew_DASHarray] = ACTIONS(13),
    [anon_sym_filled_DASHnew_DASHarray_SLASHrange] = ACTIONS(51),
    [anon_sym_fill_DASHarray_DASHdata] = ACTIONS(13),
    [anon_sym_throw] = ACTIONS(13),
    [anon_sym_throw_DASHverification_DASHerror] = ACTIONS(13),
    [anon_sym_goto] = ACTIONS(13),
    [anon_sym_goto_SLASH16] = ACTIONS(51),
    [anon_sym_goto_SLASH32] = ACTIONS(51),
    [anon_sym_packed_DASHswitch] = ACTIONS(13),
    [anon_sym_sparse_DASHswitch] = ACTIONS(13),
    [anon_sym_cmpl_DASHfloat] = ACTIONS(13),
    [anon_sym_cmpg_DASHfloat] = ACTIONS(13),
    [anon_sym_cmpl_DASHdouble] = ACTIONS(13),
    [anon_sym_cmpg_DASHdouble] = ACTIONS(13),
    [anon_sym_cmp_DASHlong] = ACTIONS(13),
    [anon_sym_if_DASHeq] = ACTIONS(13),
    [anon_sym_if_DASHne] = ACTIONS(13),
    [anon_sym_if_DASHlt] = ACTIONS(13),
    [anon_sym_if_DASHge] = ACTIONS(13),
    [anon_sym_if_DASHgt] = ACTIONS(13),
    [anon_sym_if_DASHle] = ACTIONS(13),
    [anon_sym_if_DASHeqz] = ACTIONS(13),
    [anon_sym_if_DASHnez] = ACTIONS(13),
    [anon_sym_if_DASHltz] = ACTIONS(13),
    [anon_sym_if_DASHgez] = ACTIONS(13),
    [anon_sym_if_DASHgtz] = ACTIONS(13),
    [anon_sym_if_DASHlez] = ACTIONS(13),
    [anon_sym_aget] = ACTIONS(13),
    [anon_sym_aget_DASHwide] = ACTIONS(13),
    [anon_sym_aget_DASHobject] = ACTIONS(13),
    [anon_sym_aget_DASHboolean] = ACTIONS(13),
    [anon_sym_aget_DASHbyte] = ACTIONS(13),
    [anon_sym_aget_DASHchar] = ACTIONS(13),
    [anon_sym_aget_DASHshort] = ACTIONS(13),
    [anon_sym_aput] = ACTIONS(13),
    [anon_sym_aput_DASHwide] = ACTIONS(13),
    [anon_sym_aput_DASHobject] = ACTIONS(13),
    [anon_sym_aput_DASHboolean] = ACTIONS(13),
    [anon_sym_aput_DASHbyte] = ACTIONS(13),
    [anon_sym_aput_DASHchar] = ACTIONS(13),
    [anon_sym_aput_DASHshort] = ACTIONS(13),
    [anon_sym_iget] = ACTIONS(13),
    [anon_sym_iget_DASHwide] = ACTIONS(13),
    [anon_sym_iget_DASHobject] = ACTIONS(13),
    [anon_sym_iget_DASHboolean] = ACTIONS(13),
    [anon_sym_iget_DASHbyte] = ACTIONS(13),
    [anon_sym_iget_DASHchar] = ACTIONS(13),
    [anon_sym_iget_DASHshort] = ACTIONS(13),
    [anon_sym_iget_DASHvolatile] = ACTIONS(13),
    [anon_sym_iget_DASHwide_DASHvolatile] = ACTIONS(13),
    [anon_sym_iget_DASHobject_DASHvolatile] = ACTIONS(13),
    [anon_sym_iput] = ACTIONS(13),
    [anon_sym_iput_DASHwide] = ACTIONS(13),
    [anon_sym_iput_DASHobject] = ACTIONS(13),
    [anon_sym_iput_DASHboolean] = ACTIONS(13),
    [anon_sym_iput_DASHbyte] = ACTIONS(13),
    [anon_sym_iput_DASHchar] = ACTIONS(13),
    [anon_sym_iput_DASHshort] = ACTIONS(13),
    [anon_sym_iput_DASHvolatile] = ACTIONS(13),
    [anon_sym_iput_DASHwide_DASHvolatile] = ACTIONS(13),
    [anon_sym_iput_DASHobject_DASHvolatile] = ACTIONS(13),
    [anon_sym_sget] = ACTIONS(13),
    [anon_sym_sget_DASHwide] = ACTIONS(13),
    [anon_sym_sget_DASHobject] = ACTIONS(13),
    [anon_sym_sget_DASHboolean] = ACTIONS(13),
    [anon_sym_sget_DASHbyte] = ACTIONS(13),
    [anon_sym_sget_DASHchar] = ACTIONS(13),
    [anon_sym_sget_DASHshort] = ACTIONS(13),
    [anon_sym_sget_DASHvolatile] = ACTIONS(13),
    [anon_sym_sget_DASHwide_DASHvolatile] = ACTIONS(13),
    [anon_sym_sget_DASHobject_DASHvolatile] = ACTIONS(13),
    [anon_sym_sput] = ACTIONS(13),
    [anon_sym_sput_DASHwide] = ACTIONS(13),
    [anon_sym_sput_DASHobject] = ACTIONS(13),
    [anon_sym_sput_DASHboolean] = ACTIONS(13),
    [anon_sym_sput_DASHbyte] = ACTIONS(13),
    [anon_sym_sput_DASHchar] = ACTIONS(13),
    [anon_sym_sput_DASHshort] = ACTIONS(13),
    [anon_sym_sput_DASHvolatile] = ACTIONS(13),
    [anon_sym_sput_DASHwide_DASHvolatile] = ACTIONS(13),
    [anon_sym_sput_DASHobject_DASHvolatile] = ACTIONS(13),
    [anon_sym_invoke_DASHconstructor] = ACTIONS(13),
    [anon_sym_invoke_DASHcustom] = ACTIONS(13),
    [anon_sym_invoke_DASHdirect] = ACTIONS(13),
    [anon_sym_invoke_DASHdirect_DASHempty] = ACTIONS(13),
    [anon_sym_invoke_DASHinstance] = ACTIONS(13),
    [anon_sym_invoke_DASHinterface] = ACTIONS(13),
    [anon_sym_invoke_DASHpolymorphic] = ACTIONS(13),
    [anon_sym_invoke_DASHstatic] = ACTIONS(13),
    [anon_sym_invoke_DASHsuper] = ACTIONS(13),
    [anon_sym_invoke_DASHvirtual] = ACTIONS(13),
    [anon_sym_invoke_DASHcustom_SLASHrange] = ACTIONS(51),
    [anon_sym_invoke_DASHdirect_SLASHrange] = ACTIONS(51),
    [anon_sym_invoke_DASHinterface_SLASHrange] = ACTIONS(51),
    [anon_sym_invoke_DASHobject_DASHinit_SLASHrange] = ACTIONS(51),
    [anon_sym_invoke_DASHpolymorphic_SLASHrange] = ACTIONS(51),
    [anon_sym_invoke_DASHstatic_SLASHrange] = ACTIONS(51),
    [anon_sym_invoke_DASHsuper_SLASHrange] = ACTIONS(51),
    [anon_sym_invoke_DASHvirtual_SLASHrange] = ACTIONS(51),
    [anon_sym_neg_DASHint] = ACTIONS(13),
    [anon_sym_not_DASHint] = ACTIONS(13),
    [anon_sym_neg_DASHlong] = ACTIONS(13),
    [anon_sym_not_DASHlong] = ACTIONS(13),
    [anon_sym_neg_DASHfloat] = ACTIONS(13),
    [anon_sym_neg_DASHdouble] = ACTIONS(13),
    [anon_sym_int_DASHto_DASHlong] = ACTIONS(13),
    [anon_sym_int_DASHto_DASHfloat] = ACTIONS(13),
    [anon_sym_int_DASHto_DASHdouble] = ACTIONS(13),
    [anon_sym_long_DASHto_DASHint] = ACTIONS(13),
    [anon_sym_long_DASHto_DASHfloat] = ACTIONS(13),
    [anon_sym_long_DASHto_DASHdouble] = ACTIONS(13),
    [anon_sym_float_DASHto_DASHint] = ACTIONS(13),
    [anon_sym_float_DASHto_DASHlong] = ACTIONS(13),
    [anon_sym_float_DASHto_DASHdouble] = ACTIONS(13),
    [anon_sym_double_DASHto_DASHint] = ACTIONS(13),
    [anon_sym_double_DASHto_DASHlong] = ACTIONS(13),
    [anon_sym_double_DASHto_DASHfloat] = ACTIONS(13),
    [anon_sym_int_DASHto_DASHbyte] = ACTIONS(13),
    [anon_sym_int_DASHto_DASHchar] = ACTIONS(13),
    [anon_sym_int_DASHto_DASHshort] = ACTIONS(13),
    [anon_sym_add_DASHint] = ACTIONS(13),
    [anon_sym_sub_DASHint] = ACTIONS(13),
    [anon_sym_mul_DASHint] = ACTIONS(13),
    [anon_sym_div_DASHint] = ACTIONS(13),
    [anon_sym_rem_DASHint] = ACTIONS(13),
    [anon_sym_and_DASHint] = ACTIONS(13),
    [anon_sym_or_DASHint] = ACTIONS(13),
    [anon_sym_xor_DASHint] = ACTIONS(13),
    [anon_sym_shl_DASHint] = ACTIONS(13),
    [anon_sym_shr_DASHint] = ACTIONS(13),
    [anon_sym_ushr_DASHint] = ACTIONS(13),
    [anon_sym_add_DASHlong] = ACTIONS(13),
    [anon_sym_sub_DASHlong] = ACTIONS(13),
    [anon_sym_mul_DASHlong] = ACTIONS(13),
    [anon_sym_div_DASHlong] = ACTIONS(13),
    [anon_sym_rem_DASHlong] = ACTIONS(13),
    [anon_sym_and_DASHlong] = ACTIONS(13),
    [anon_sym_or_DASHlong] = ACTIONS(13),
    [anon_sym_xor_DASHlong] = ACTIONS(13),
    [anon_sym_shl_DASHlong] = ACTIONS(13),
    [anon_sym_shr_DASHlong] = ACTIONS(13),
    [anon_sym_ushr_DASHlong] = ACTIONS(13),
    [anon_sym_add_DASHfloat] = ACTIONS(13),
    [anon_sym_sub_DASHfloat] = ACTIONS(13),
    [anon_sym_mul_DASHfloat] = ACTIONS(13),
    [anon_sym_div_DASHfloat] = ACTIONS(13),
    [anon_sym_rem_DASHfloat] = ACTIONS(13),
    [anon_sym_add_DASHdouble] = ACTIONS(13),
    [anon_sym_sub_DASHdouble] = ACTIONS(13),
    [anon_sym_mul_DASHdouble] = ACTIONS(13),
    [anon_sym_div_DASHdouble] = ACTIONS(13),
    [anon_sym_rem_DASHdouble] = ACTIONS(13),
    [anon_sym_add_DASHint_SLASH2addr] = ACTIONS(51),
    [anon_sym_sub_DASHint_SLASH2addr] = ACTIONS(51),
    [anon_sym_mul_DASHint_SLASH2addr] = ACTIONS(51),
    [anon_sym_div_DASHint_SLASH2addr] = ACTIONS(51),
    [anon_sym_rem_DASHint_SLASH2addr] = ACTIONS(51),
    [anon_sym_and_DASHint_SLASH2addr] = ACTIONS(51),
    [anon_sym_or_DASHint_SLASH2addr] = ACTIONS(51),
    [anon_sym_xor_DASHint_SLASH2addr] = ACTIONS(51),
    [anon_sym_shl_DASHint_SLASH2addr] = ACTIONS(51),
    [anon_sym_shr_DASHint_SLASH2addr] = ACTIONS(51),
    [anon_sym_ushr_DASHint_SLASH2addr] = ACTIONS(51),
    [anon_sym_add_DASHlong_SLASH2addr] = ACTIONS(51),
    [anon_sym_sub_DASHlong_SLASH2addr] = ACTIONS(51),
    [anon_sym_mul_DASHlong_SLASH2addr] = ACTIONS(51),
    [anon_sym_div_DASHlong_SLASH2addr] = ACTIONS(51),
    [anon_sym_rem_DASHlong_SLASH2addr] = ACTIONS(51),
    [anon_sym_and_DASHlong_SLASH2addr] = ACTIONS(51),
    [anon_sym_or_DASHlong_SLASH2addr] = ACTIONS(51),
    [anon_sym_xor_DASHlong_SLASH2addr] = ACTIONS(51),
    [anon_sym_shl_DASHlong_SLASH2addr] = ACTIONS(51),
    [anon_sym_shr_DASHlong_SLASH2addr] = ACTIONS(51),
    [anon_sym_ushr_DASHlong_SLASH2addr] = ACTIONS(51),
    [anon_sym_add_DASHfloat_SLASH2addr] = ACTIONS(51),
    [anon_sym_sub_DASHfloat_SLASH2addr] = ACTIONS(51),
    [anon_sym_mul_DASHfloat_SLASH2addr] = ACTIONS(51),
    [anon_sym_div_DASHfloat_SLASH2addr] = ACTIONS(51),
    [anon_sym_rem_DASHfloat_SLASH2addr] = ACTIONS(51),
    [anon_sym_add_DASHdouble_SLASH2addr] = ACTIONS(51),
    [anon_sym_sub_DASHdouble_SLASH2addr] = ACTIONS(51),
    [anon_sym_mul_DASHdouble_SLASH2addr] = ACTIONS(51),
    [anon_sym_div_DASHdouble_SLASH2addr] = ACTIONS(51),
    [anon_sym_rem_DASHdouble_SLASH2addr] = ACTIONS(51),
    [anon_sym_add_DASHint_SLASHlit16] = ACTIONS(51),
    [anon_sym_sub_DASHint_SLASHlit16] = ACTIONS(51),
    [anon_sym_mul_DASHint_SLASHlit16] = ACTIONS(51),
    [anon_sym_div_DASHint_SLASHlit16] = ACTIONS(51),
    [anon_sym_rem_DASHint_SLASHlit16] = ACTIONS(51),
    [anon_sym_and_DASHint_SLASHlit16] = ACTIONS(51),
    [anon_sym_or_DASHint_SLASHlit16] = ACTIONS(51),
    [anon_sym_xor_DASHint_SLASHlit16] = ACTIONS(51),
    [anon_sym_add_DASHint_SLASHlit8] = ACTIONS(51),
    [anon_sym_sub_DASHint_SLASHlit8] = ACTIONS(51),
    [anon_sym_mul_DASHint_SLASHlit8] = ACTIONS(51),
    [anon_sym_div_DASHint_SLASHlit8] = ACTIONS(51),
    [anon_sym_rem_DASHint_SLASHlit8] = ACTIONS(51),
    [anon_sym_and_DASHint_SLASHlit8] = ACTIONS(51),
    [anon_sym_or_DASHint_SLASHlit8] = ACTIONS(51),
    [anon_sym_xor_DASHint_SLASHlit8] = ACTIONS(51),
    [anon_sym_shl_DASHint_SLASHlit8] = ACTIONS(51),
    [anon_sym_shr_DASHint_SLASHlit8] = ACTIONS(51),
    [anon_sym_ushr_DASHint_SLASHlit8] = ACTIONS(51),
    [anon_sym_static_DASHget] = ACTIONS(13),
    [anon_sym_static_DASHput] = ACTIONS(13),
    [anon_sym_instance_DASHget] = ACTIONS(13),
    [anon_sym_instance_DASHput] = ACTIONS(13),
    [anon_sym_execute_DASHinline] = ACTIONS(13),
    [anon_sym_execute_DASHinline_SLASHrange] = ACTIONS(51),
    [anon_sym_iget_DASHquick] = ACTIONS(13),
    [anon_sym_iget_DASHwide_DASHquick] = ACTIONS(13),
    [anon_sym_iget_DASHobject_DASHquick] = ACTIONS(13),
    [anon_sym_iput_DASHquick] = ACTIONS(13),
    [anon_sym_iput_DASHwide_DASHquick] = ACTIONS(13),
    [anon_sym_iput_DASHobject_DASHquick] = ACTIONS(13),
    [anon_sym_iput_DASHboolean_DASHquick] = ACTIONS(13),
    [anon_sym_iput_DASHbyte_DASHquick] = ACTIONS(13),
    [anon_sym_iput_DASHchar_DASHquick] = ACTIONS(13),
    [anon_sym_iput_DASHshort_DASHquick] = ACTIONS(13),
    [anon_sym_invoke_DASHvirtual_DASHquick] = ACTIONS(13),
    [anon_sym_invoke_DASHvirtual_DASHquick_SLASHrange] = ACTIONS(51),
    [anon_sym_invoke_DASHsuper_DASHquick] = ACTIONS(13),
    [anon_sym_invoke_DASHsuper_DASHquick_SLASHrange] = ACTIONS(51),
    [anon_sym_rsub_DASHint] = ACTIONS(13),
    [anon_sym_rsub_DASHint_SLASHlit8] = ACTIONS(51),
    [anon_sym_LBRACE] = ACTIONS(53),
    [aux_sym_label_token1] = ACTIONS(57),
    [aux_sym_jmp_label_token1] = ACTIONS(59),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_LPAREN] = ACTIONS(63),
    [anon_sym_LBRACK] = ACTIONS(65),
    [aux_sym_primitive_type_token1] = ACTIONS(67),
    [aux_sym_primitive_type_token2] = ACTIONS(67),
    [anon_sym_DOTenum] = ACTIONS(69),
    [sym_variable] = ACTIONS(71),
    [sym_parameter] = ACTIONS(71),
    [sym_number] = ACTIONS(87),
    [sym_float] = ACTIONS(75),
    [sym_NaN] = ACTIONS(77),
    [sym_Infinity] = ACTIONS(77),
    [anon_sym_DQUOTE] = ACTIONS(79),
    [anon_sym_true] = ACTIONS(81),
    [anon_sym_false] = ACTIONS(81),
    [anon_sym_SQUOTE] = ACTIONS(83),
    [sym_null] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [sym_L] = ACTIONS(85),
  },
  [10] = {
    [sym_source_directive] = STATE(68),
    [sym_annotation_directive] = STATE(59),
    [sym_param_directive] = STATE(68),
    [sym_parameter_directive] = STATE(68),
    [sym_statement] = STATE(13),
    [sym_expression] = STATE(59),
    [sym_opcode] = STATE(2),
    [sym_directive] = STATE(59),
    [sym_line_directive] = STATE(68),
    [sym_locals_directive] = STATE(68),
    [sym_local_directive] = STATE(68),
    [sym_end_local_directive] = STATE(68),
    [sym_restart_local_directive] = STATE(68),
    [sym_registers_directive] = STATE(68),
    [sym_catch_directive] = STATE(68),
    [sym_catchall_directive] = STATE(68),
    [sym_packed_switch_directive] = STATE(68),
    [sym_sparse_switch_directive] = STATE(68),
    [sym_array_data_directive] = STATE(68),
    [sym_label] = STATE(59),
    [sym_jmp_label] = STATE(59),
    [aux_sym_method_definition_repeat1] = STATE(13),
    [anon_sym_DOTsource] = ACTIONS(111),
    [anon_sym_DOTendmethod] = ACTIONS(113),
    [anon_sym_DOTannotation] = ACTIONS(115),
    [anon_sym_DOTparam] = ACTIONS(117),
    [anon_sym_DOTparameter] = ACTIONS(119),
    [anon_sym_nop] = ACTIONS(121),
    [anon_sym_move] = ACTIONS(121),
    [anon_sym_move_SLASHfrom16] = ACTIONS(123),
    [anon_sym_move_SLASH16] = ACTIONS(123),
    [anon_sym_move_DASHwide] = ACTIONS(121),
    [anon_sym_move_DASHwide_SLASHfrom16] = ACTIONS(123),
    [anon_sym_move_DASHwide_SLASH16] = ACTIONS(123),
    [anon_sym_move_DASHobject] = ACTIONS(121),
    [anon_sym_move_DASHobject_SLASHfrom16] = ACTIONS(123),
    [anon_sym_move_DASHobject_SLASH16] = ACTIONS(123),
    [anon_sym_move_DASHresult] = ACTIONS(121),
    [anon_sym_move_DASHresult_DASHwide] = ACTIONS(123),
    [anon_sym_move_DASHresult_DASHobject] = ACTIONS(123),
    [anon_sym_move_DASHexception] = ACTIONS(123),
    [anon_sym_return_DASHvoid] = ACTIONS(123),
    [anon_sym_return] = ACTIONS(121),
    [anon_sym_return_DASHwide] = ACTIONS(123),
    [anon_sym_return_DASHobject] = ACTIONS(123),
    [anon_sym_const_SLASH4] = ACTIONS(123),
    [anon_sym_const_SLASH16] = ACTIONS(123),
    [anon_sym_const] = ACTIONS(121),
    [anon_sym_const_SLASHhigh16] = ACTIONS(123),
    [anon_sym_const_DASHwide_SLASH16] = ACTIONS(123),
    [anon_sym_const_DASHwide_SLASH32] = ACTIONS(123),
    [anon_sym_const_DASHwide] = ACTIONS(121),
    [anon_sym_const_DASHwide_SLASHhigh16] = ACTIONS(123),
    [anon_sym_const_DASHstring] = ACTIONS(121),
    [anon_sym_const_DASHstring_SLASHjumbo] = ACTIONS(123),
    [anon_sym_const_DASHclass] = ACTIONS(123),
    [anon_sym_const_DASHmethod_DASHhandle] = ACTIONS(123),
    [anon_sym_const_DASHmethod_DASHtype] = ACTIONS(123),
    [anon_sym_monitor_DASHenter] = ACTIONS(123),
    [anon_sym_monitor_DASHexit] = ACTIONS(123),
    [anon_sym_check_DASHcast] = ACTIONS(123),
    [anon_sym_instance_DASHof] = ACTIONS(123),
    [anon_sym_array_DASHlength] = ACTIONS(123),
    [anon_sym_new_DASHinstance] = ACTIONS(123),
    [anon_sym_new_DASHarray] = ACTIONS(123),
    [anon_sym_filled_DASHnew_DASHarray] = ACTIONS(121),
    [anon_sym_filled_DASHnew_DASHarray_SLASHrange] = ACTIONS(123),
    [anon_sym_fill_DASHarray_DASHdata] = ACTIONS(123),
    [anon_sym_throw] = ACTIONS(121),
    [anon_sym_throw_DASHverification_DASHerror] = ACTIONS(123),
    [anon_sym_goto] = ACTIONS(121),
    [anon_sym_goto_SLASH16] = ACTIONS(123),
    [anon_sym_goto_SLASH32] = ACTIONS(123),
    [anon_sym_packed_DASHswitch] = ACTIONS(123),
    [anon_sym_sparse_DASHswitch] = ACTIONS(123),
    [anon_sym_cmpl_DASHfloat] = ACTIONS(123),
    [anon_sym_cmpg_DASHfloat] = ACTIONS(123),
    [anon_sym_cmpl_DASHdouble] = ACTIONS(123),
    [anon_sym_cmpg_DASHdouble] = ACTIONS(123),
    [anon_sym_cmp_DASHlong] = ACTIONS(123),
    [anon_sym_if_DASHeq] = ACTIONS(121),
    [anon_sym_if_DASHne] = ACTIONS(121),
    [anon_sym_if_DASHlt] = ACTIONS(121),
    [anon_sym_if_DASHge] = ACTIONS(121),
    [anon_sym_if_DASHgt] = ACTIONS(121),
    [anon_sym_if_DASHle] = ACTIONS(121),
    [anon_sym_if_DASHeqz] = ACTIONS(123),
    [anon_sym_if_DASHnez] = ACTIONS(123),
    [anon_sym_if_DASHltz] = ACTIONS(123),
    [anon_sym_if_DASHgez] = ACTIONS(123),
    [anon_sym_if_DASHgtz] = ACTIONS(123),
    [anon_sym_if_DASHlez] = ACTIONS(123),
    [anon_sym_aget] = ACTIONS(121),
    [anon_sym_aget_DASHwide] = ACTIONS(123),
    [anon_sym_aget_DASHobject] = ACTIONS(123),
    [anon_sym_aget_DASHboolean] = ACTIONS(123),
    [anon_sym_aget_DASHbyte] = ACTIONS(123),
    [anon_sym_aget_DASHchar] = ACTIONS(123),
    [anon_sym_aget_DASHshort] = ACTIONS(123),
    [anon_sym_aput] = ACTIONS(121),
    [anon_sym_aput_DASHwide] = ACTIONS(123),
    [anon_sym_aput_DASHobject] = ACTIONS(123),
    [anon_sym_aput_DASHboolean] = ACTIONS(123),
    [anon_sym_aput_DASHbyte] = ACTIONS(123),
    [anon_sym_aput_DASHchar] = ACTIONS(123),
    [anon_sym_aput_DASHshort] = ACTIONS(123),
    [anon_sym_iget] = ACTIONS(121),
    [anon_sym_iget_DASHwide] = ACTIONS(121),
    [anon_sym_iget_DASHobject] = ACTIONS(121),
    [anon_sym_iget_DASHboolean] = ACTIONS(123),
    [anon_sym_iget_DASHbyte] = ACTIONS(123),
    [anon_sym_iget_DASHchar] = ACTIONS(123),
    [anon_sym_iget_DASHshort] = ACTIONS(123),
    [anon_sym_iget_DASHvolatile] = ACTIONS(123),
    [anon_sym_iget_DASHwide_DASHvolatile] = ACTIONS(123),
    [anon_sym_iget_DASHobject_DASHvolatile] = ACTIONS(123),
    [anon_sym_iput] = ACTIONS(121),
    [anon_sym_iput_DASHwide] = ACTIONS(121),
    [anon_sym_iput_DASHobject] = ACTIONS(121),
    [anon_sym_iput_DASHboolean] = ACTIONS(121),
    [anon_sym_iput_DASHbyte] = ACTIONS(121),
    [anon_sym_iput_DASHchar] = ACTIONS(121),
    [anon_sym_iput_DASHshort] = ACTIONS(121),
    [anon_sym_iput_DASHvolatile] = ACTIONS(123),
    [anon_sym_iput_DASHwide_DASHvolatile] = ACTIONS(123),
    [anon_sym_iput_DASHobject_DASHvolatile] = ACTIONS(123),
    [anon_sym_sget] = ACTIONS(121),
    [anon_sym_sget_DASHwide] = ACTIONS(121),
    [anon_sym_sget_DASHobject] = ACTIONS(121),
    [anon_sym_sget_DASHboolean] = ACTIONS(123),
    [anon_sym_sget_DASHbyte] = ACTIONS(123),
    [anon_sym_sget_DASHchar] = ACTIONS(123),
    [anon_sym_sget_DASHshort] = ACTIONS(123),
    [anon_sym_sget_DASHvolatile] = ACTIONS(123),
    [anon_sym_sget_DASHwide_DASHvolatile] = ACTIONS(123),
    [anon_sym_sget_DASHobject_DASHvolatile] = ACTIONS(123),
    [anon_sym_sput] = ACTIONS(121),
    [anon_sym_sput_DASHwide] = ACTIONS(121),
    [anon_sym_sput_DASHobject] = ACTIONS(121),
    [anon_sym_sput_DASHboolean] = ACTIONS(123),
    [anon_sym_sput_DASHbyte] = ACTIONS(123),
    [anon_sym_sput_DASHchar] = ACTIONS(123),
    [anon_sym_sput_DASHshort] = ACTIONS(123),
    [anon_sym_sput_DASHvolatile] = ACTIONS(123),
    [anon_sym_sput_DASHwide_DASHvolatile] = ACTIONS(123),
    [anon_sym_sput_DASHobject_DASHvolatile] = ACTIONS(123),
    [anon_sym_invoke_DASHconstructor] = ACTIONS(123),
    [anon_sym_invoke_DASHcustom] = ACTIONS(121),
    [anon_sym_invoke_DASHdirect] = ACTIONS(121),
    [anon_sym_invoke_DASHdirect_DASHempty] = ACTIONS(123),
    [anon_sym_invoke_DASHinstance] = ACTIONS(123),
    [anon_sym_invoke_DASHinterface] = ACTIONS(121),
    [anon_sym_invoke_DASHpolymorphic] = ACTIONS(121),
    [anon_sym_invoke_DASHstatic] = ACTIONS(121),
    [anon_sym_invoke_DASHsuper] = ACTIONS(121),
    [anon_sym_invoke_DASHvirtual] = ACTIONS(121),
    [anon_sym_invoke_DASHcustom_SLASHrange] = ACTIONS(123),
    [anon_sym_invoke_DASHdirect_SLASHrange] = ACTIONS(123),
    [anon_sym_invoke_DASHinterface_SLASHrange] = ACTIONS(123),
    [anon_sym_invoke_DASHobject_DASHinit_SLASHrange] = ACTIONS(123),
    [anon_sym_invoke_DASHpolymorphic_SLASHrange] = ACTIONS(123),
    [anon_sym_invoke_DASHstatic_SLASHrange] = ACTIONS(123),
    [anon_sym_invoke_DASHsuper_SLASHrange] = ACTIONS(123),
    [anon_sym_invoke_DASHvirtual_SLASHrange] = ACTIONS(123),
    [anon_sym_neg_DASHint] = ACTIONS(123),
    [anon_sym_not_DASHint] = ACTIONS(123),
    [anon_sym_neg_DASHlong] = ACTIONS(123),
    [anon_sym_not_DASHlong] = ACTIONS(123),
    [anon_sym_neg_DASHfloat] = ACTIONS(123),
    [anon_sym_neg_DASHdouble] = ACTIONS(123),
    [anon_sym_int_DASHto_DASHlong] = ACTIONS(123),
    [anon_sym_int_DASHto_DASHfloat] = ACTIONS(123),
    [anon_sym_int_DASHto_DASHdouble] = ACTIONS(123),
    [anon_sym_long_DASHto_DASHint] = ACTIONS(123),
    [anon_sym_long_DASHto_DASHfloat] = ACTIONS(123),
    [anon_sym_long_DASHto_DASHdouble] = ACTIONS(123),
    [anon_sym_float_DASHto_DASHint] = ACTIONS(123),
    [anon_sym_float_DASHto_DASHlong] = ACTIONS(123),
    [anon_sym_float_DASHto_DASHdouble] = ACTIONS(123),
    [anon_sym_double_DASHto_DASHint] = ACTIONS(123),
    [anon_sym_double_DASHto_DASHlong] = ACTIONS(123),
    [anon_sym_double_DASHto_DASHfloat] = ACTIONS(123),
    [anon_sym_int_DASHto_DASHbyte] = ACTIONS(123),
    [anon_sym_int_DASHto_DASHchar] = ACTIONS(123),
    [anon_sym_int_DASHto_DASHshort] = ACTIONS(123),
    [anon_sym_add_DASHint] = ACTIONS(121),
    [anon_sym_sub_DASHint] = ACTIONS(121),
    [anon_sym_mul_DASHint] = ACTIONS(121),
    [anon_sym_div_DASHint] = ACTIONS(121),
    [anon_sym_rem_DASHint] = ACTIONS(121),
    [anon_sym_and_DASHint] = ACTIONS(121),
    [anon_sym_or_DASHint] = ACTIONS(121),
    [anon_sym_xor_DASHint] = ACTIONS(121),
    [anon_sym_shl_DASHint] = ACTIONS(121),
    [anon_sym_shr_DASHint] = ACTIONS(121),
    [anon_sym_ushr_DASHint] = ACTIONS(121),
    [anon_sym_add_DASHlong] = ACTIONS(121),
    [anon_sym_sub_DASHlong] = ACTIONS(121),
    [anon_sym_mul_DASHlong] = ACTIONS(121),
    [anon_sym_div_DASHlong] = ACTIONS(121),
    [anon_sym_rem_DASHlong] = ACTIONS(121),
    [anon_sym_and_DASHlong] = ACTIONS(121),
    [anon_sym_or_DASHlong] = ACTIONS(121),
    [anon_sym_xor_DASHlong] = ACTIONS(121),
    [anon_sym_shl_DASHlong] = ACTIONS(121),
    [anon_sym_shr_DASHlong] = ACTIONS(121),
    [anon_sym_ushr_DASHlong] = ACTIONS(121),
    [anon_sym_add_DASHfloat] = ACTIONS(121),
    [anon_sym_sub_DASHfloat] = ACTIONS(121),
    [anon_sym_mul_DASHfloat] = ACTIONS(121),
    [anon_sym_div_DASHfloat] = ACTIONS(121),
    [anon_sym_rem_DASHfloat] = ACTIONS(121),
    [anon_sym_add_DASHdouble] = ACTIONS(121),
    [anon_sym_sub_DASHdouble] = ACTIONS(121),
    [anon_sym_mul_DASHdouble] = ACTIONS(121),
    [anon_sym_div_DASHdouble] = ACTIONS(121),
    [anon_sym_rem_DASHdouble] = ACTIONS(121),
    [anon_sym_add_DASHint_SLASH2addr] = ACTIONS(123),
    [anon_sym_sub_DASHint_SLASH2addr] = ACTIONS(123),
    [anon_sym_mul_DASHint_SLASH2addr] = ACTIONS(123),
    [anon_sym_div_DASHint_SLASH2addr] = ACTIONS(123),
    [anon_sym_rem_DASHint_SLASH2addr] = ACTIONS(123),
    [anon_sym_and_DASHint_SLASH2addr] = ACTIONS(123),
    [anon_sym_or_DASHint_SLASH2addr] = ACTIONS(123),
    [anon_sym_xor_DASHint_SLASH2addr] = ACTIONS(123),
    [anon_sym_shl_DASHint_SLASH2addr] = ACTIONS(123),
    [anon_sym_shr_DASHint_SLASH2addr] = ACTIONS(123),
    [anon_sym_ushr_DASHint_SLASH2addr] = ACTIONS(123),
    [anon_sym_add_DASHlong_SLASH2addr] = ACTIONS(123),
    [anon_sym_sub_DASHlong_SLASH2addr] = ACTIONS(123),
    [anon_sym_mul_DASHlong_SLASH2addr] = ACTIONS(123),
    [anon_sym_div_DASHlong_SLASH2addr] = ACTIONS(123),
    [anon_sym_rem_DASHlong_SLASH2addr] = ACTIONS(123),
    [anon_sym_and_DASHlong_SLASH2addr] = ACTIONS(123),
    [anon_sym_or_DASHlong_SLASH2addr] = ACTIONS(123),
    [anon_sym_xor_DASHlong_SLASH2addr] = ACTIONS(123),
    [anon_sym_shl_DASHlong_SLASH2addr] = ACTIONS(123),
    [anon_sym_shr_DASHlong_SLASH2addr] = ACTIONS(123),
    [anon_sym_ushr_DASHlong_SLASH2addr] = ACTIONS(123),
    [anon_sym_add_DASHfloat_SLASH2addr] = ACTIONS(123),
    [anon_sym_sub_DASHfloat_SLASH2addr] = ACTIONS(123),
    [anon_sym_mul_DASHfloat_SLASH2addr] = ACTIONS(123),
    [anon_sym_div_DASHfloat_SLASH2addr] = ACTIONS(123),
    [anon_sym_rem_DASHfloat_SLASH2addr] = ACTIONS(123),
    [anon_sym_add_DASHdouble_SLASH2addr] = ACTIONS(123),
    [anon_sym_sub_DASHdouble_SLASH2addr] = ACTIONS(123),
    [anon_sym_mul_DASHdouble_SLASH2addr] = ACTIONS(123),
    [anon_sym_div_DASHdouble_SLASH2addr] = ACTIONS(123),
    [anon_sym_rem_DASHdouble_SLASH2addr] = ACTIONS(123),
    [anon_sym_add_DASHint_SLASHlit16] = ACTIONS(123),
    [anon_sym_sub_DASHint_SLASHlit16] = ACTIONS(123),
    [anon_sym_mul_DASHint_SLASHlit16] = ACTIONS(123),
    [anon_sym_div_DASHint_SLASHlit16] = ACTIONS(123),
    [anon_sym_rem_DASHint_SLASHlit16] = ACTIONS(123),
    [anon_sym_and_DASHint_SLASHlit16] = ACTIONS(123),
    [anon_sym_or_DASHint_SLASHlit16] = ACTIONS(123),
    [anon_sym_xor_DASHint_SLASHlit16] = ACTIONS(123),
    [anon_sym_add_DASHint_SLASHlit8] = ACTIONS(123),
    [anon_sym_sub_DASHint_SLASHlit8] = ACTIONS(123),
    [anon_sym_mul_DASHint_SLASHlit8] = ACTIONS(123),
    [anon_sym_div_DASHint_SLASHlit8] = ACTIONS(123),
    [anon_sym_rem_DASHint_SLASHlit8] = ACTIONS(123),
    [anon_sym_and_DASHint_SLASHlit8] = ACTIONS(123),
    [anon_sym_or_DASHint_SLASHlit8] = ACTIONS(123),
    [anon_sym_xor_DASHint_SLASHlit8] = ACTIONS(123),
    [anon_sym_shl_DASHint_SLASHlit8] = ACTIONS(123),
    [anon_sym_shr_DASHint_SLASHlit8] = ACTIONS(123),
    [anon_sym_ushr_DASHint_SLASHlit8] = ACTIONS(123),
    [anon_sym_static_DASHget] = ACTIONS(123),
    [anon_sym_static_DASHput] = ACTIONS(123),
    [anon_sym_instance_DASHget] = ACTIONS(123),
    [anon_sym_instance_DASHput] = ACTIONS(123),
    [anon_sym_execute_DASHinline] = ACTIONS(121),
    [anon_sym_execute_DASHinline_SLASHrange] = ACTIONS(123),
    [anon_sym_iget_DASHquick] = ACTIONS(123),
    [anon_sym_iget_DASHwide_DASHquick] = ACTIONS(123),
    [anon_sym_iget_DASHobject_DASHquick] = ACTIONS(123),
    [anon_sym_iput_DASHquick] = ACTIONS(123),
    [anon_sym_iput_DASHwide_DASHquick] = ACTIONS(123),
    [anon_sym_iput_DASHobject_DASHquick] = ACTIONS(123),
    [anon_sym_iput_DASHboolean_DASHquick] = ACTIONS(123),
    [anon_sym_iput_DASHbyte_DASHquick] = ACTIONS(123),
    [anon_sym_iput_DASHchar_DASHquick] = ACTIONS(123),
    [anon_sym_iput_DASHshort_DASHquick] = ACTIONS(123),
    [anon_sym_invoke_DASHvirtual_DASHquick] = ACTIONS(121),
    [anon_sym_invoke_DASHvirtual_DASHquick_SLASHrange] = ACTIONS(123),
    [anon_sym_invoke_DASHsuper_DASHquick] = ACTIONS(121),
    [anon_sym_invoke_DASHsuper_DASHquick_SLASHrange] = ACTIONS(123),
    [anon_sym_rsub_DASHint] = ACTIONS(121),
    [anon_sym_rsub_DASHint_SLASHlit8] = ACTIONS(123),
    [anon_sym_DOTline] = ACTIONS(125),
    [anon_sym_DOTlocals] = ACTIONS(127),
    [anon_sym_DOTlocal] = ACTIONS(129),
    [anon_sym_DOTendlocal] = ACTIONS(131),
    [anon_sym_DOTrestartlocal] = ACTIONS(133),
    [anon_sym_DOTregisters] = ACTIONS(135),
    [anon_sym_DOTcatch] = ACTIONS(137),
    [anon_sym_DOTcatchall] = ACTIONS(139),
    [anon_sym_DOTpacked_DASHswitch] = ACTIONS(141),
    [anon_sym_DOTsparse_DASHswitch] = ACTIONS(143),
    [anon_sym_DOTarray_DASHdata] = ACTIONS(145),
    [sym_prologue_directive] = ACTIONS(147),
    [sym_epilogue_directive] = ACTIONS(147),
    [aux_sym_label_token1] = ACTIONS(57),
    [aux_sym_jmp_label_token1] = ACTIONS(149),
    [sym_comment] = ACTIONS(3),
  },
  [11] = {
    [sym_source_directive] = STATE(68),
    [sym_annotation_directive] = STATE(59),
    [sym_param_directive] = STATE(68),
    [sym_parameter_directive] = STATE(68),
    [sym_statement] = STATE(12),
    [sym_expression] = STATE(59),
    [sym_opcode] = STATE(2),
    [sym_directive] = STATE(59),
    [sym_line_directive] = STATE(68),
    [sym_locals_directive] = STATE(68),
    [sym_local_directive] = STATE(68),
    [sym_end_local_directive] = STATE(68),
    [sym_restart_local_directive] = STATE(68),
    [sym_registers_directive] = STATE(68),
    [sym_catch_directive] = STATE(68),
    [sym_catchall_directive] = STATE(68),
    [sym_packed_switch_directive] = STATE(68),
    [sym_sparse_switch_directive] = STATE(68),
    [sym_array_data_directive] = STATE(68),
    [sym_label] = STATE(59),
    [sym_jmp_label] = STATE(59),
    [aux_sym_method_definition_repeat1] = STATE(12),
    [anon_sym_DOTsource] = ACTIONS(111),
    [anon_sym_DOTendmethod] = ACTIONS(113),
    [anon_sym_DOTannotation] = ACTIONS(115),
    [anon_sym_DOTparam] = ACTIONS(117),
    [anon_sym_DOTparameter] = ACTIONS(119),
    [anon_sym_nop] = ACTIONS(121),
    [anon_sym_move] = ACTIONS(121),
    [anon_sym_move_SLASHfrom16] = ACTIONS(123),
    [anon_sym_move_SLASH16] = ACTIONS(123),
    [anon_sym_move_DASHwide] = ACTIONS(121),
    [anon_sym_move_DASHwide_SLASHfrom16] = ACTIONS(123),
    [anon_sym_move_DASHwide_SLASH16] = ACTIONS(123),
    [anon_sym_move_DASHobject] = ACTIONS(121),
    [anon_sym_move_DASHobject_SLASHfrom16] = ACTIONS(123),
    [anon_sym_move_DASHobject_SLASH16] = ACTIONS(123),
    [anon_sym_move_DASHresult] = ACTIONS(121),
    [anon_sym_move_DASHresult_DASHwide] = ACTIONS(123),
    [anon_sym_move_DASHresult_DASHobject] = ACTIONS(123),
    [anon_sym_move_DASHexception] = ACTIONS(123),
    [anon_sym_return_DASHvoid] = ACTIONS(123),
    [anon_sym_return] = ACTIONS(121),
    [anon_sym_return_DASHwide] = ACTIONS(123),
    [anon_sym_return_DASHobject] = ACTIONS(123),
    [anon_sym_const_SLASH4] = ACTIONS(123),
    [anon_sym_const_SLASH16] = ACTIONS(123),
    [anon_sym_const] = ACTIONS(121),
    [anon_sym_const_SLASHhigh16] = ACTIONS(123),
    [anon_sym_const_DASHwide_SLASH16] = ACTIONS(123),
    [anon_sym_const_DASHwide_SLASH32] = ACTIONS(123),
    [anon_sym_const_DASHwide] = ACTIONS(121),
    [anon_sym_const_DASHwide_SLASHhigh16] = ACTIONS(123),
    [anon_sym_const_DASHstring] = ACTIONS(121),
    [anon_sym_const_DASHstring_SLASHjumbo] = ACTIONS(123),
    [anon_sym_const_DASHclass] = ACTIONS(123),
    [anon_sym_const_DASHmethod_DASHhandle] = ACTIONS(123),
    [anon_sym_const_DASHmethod_DASHtype] = ACTIONS(123),
    [anon_sym_monitor_DASHenter] = ACTIONS(123),
    [anon_sym_monitor_DASHexit] = ACTIONS(123),
    [anon_sym_check_DASHcast] = ACTIONS(123),
    [anon_sym_instance_DASHof] = ACTIONS(123),
    [anon_sym_array_DASHlength] = ACTIONS(123),
    [anon_sym_new_DASHinstance] = ACTIONS(123),
    [anon_sym_new_DASHarray] = ACTIONS(123),
    [anon_sym_filled_DASHnew_DASHarray] = ACTIONS(121),
    [anon_sym_filled_DASHnew_DASHarray_SLASHrange] = ACTIONS(123),
    [anon_sym_fill_DASHarray_DASHdata] = ACTIONS(123),
    [anon_sym_throw] = ACTIONS(121),
    [anon_sym_throw_DASHverification_DASHerror] = ACTIONS(123),
    [anon_sym_goto] = ACTIONS(121),
    [anon_sym_goto_SLASH16] = ACTIONS(123),
    [anon_sym_goto_SLASH32] = ACTIONS(123),
    [anon_sym_packed_DASHswitch] = ACTIONS(123),
    [anon_sym_sparse_DASHswitch] = ACTIONS(123),
    [anon_sym_cmpl_DASHfloat] = ACTIONS(123),
    [anon_sym_cmpg_DASHfloat] = ACTIONS(123),
    [anon_sym_cmpl_DASHdouble] = ACTIONS(123),
    [anon_sym_cmpg_DASHdouble] = ACTIONS(123),
    [anon_sym_cmp_DASHlong] = ACTIONS(123),
    [anon_sym_if_DASHeq] = ACTIONS(121),
    [anon_sym_if_DASHne] = ACTIONS(121),
    [anon_sym_if_DASHlt] = ACTIONS(121),
    [anon_sym_if_DASHge] = ACTIONS(121),
    [anon_sym_if_DASHgt] = ACTIONS(121),
    [anon_sym_if_DASHle] = ACTIONS(121),
    [anon_sym_if_DASHeqz] = ACTIONS(123),
    [anon_sym_if_DASHnez] = ACTIONS(123),
    [anon_sym_if_DASHltz] = ACTIONS(123),
    [anon_sym_if_DASHgez] = ACTIONS(123),
    [anon_sym_if_DASHgtz] = ACTIONS(123),
    [anon_sym_if_DASHlez] = ACTIONS(123),
    [anon_sym_aget] = ACTIONS(121),
    [anon_sym_aget_DASHwide] = ACTIONS(123),
    [anon_sym_aget_DASHobject] = ACTIONS(123),
    [anon_sym_aget_DASHboolean] = ACTIONS(123),
    [anon_sym_aget_DASHbyte] = ACTIONS(123),
    [anon_sym_aget_DASHchar] = ACTIONS(123),
    [anon_sym_aget_DASHshort] = ACTIONS(123),
    [anon_sym_aput] = ACTIONS(121),
    [anon_sym_aput_DASHwide] = ACTIONS(123),
    [anon_sym_aput_DASHobject] = ACTIONS(123),
    [anon_sym_aput_DASHboolean] = ACTIONS(123),
    [anon_sym_aput_DASHbyte] = ACTIONS(123),
    [anon_sym_aput_DASHchar] = ACTIONS(123),
    [anon_sym_aput_DASHshort] = ACTIONS(123),
    [anon_sym_iget] = ACTIONS(121),
    [anon_sym_iget_DASHwide] = ACTIONS(121),
    [anon_sym_iget_DASHobject] = ACTIONS(121),
    [anon_sym_iget_DASHboolean] = ACTIONS(123),
    [anon_sym_iget_DASHbyte] = ACTIONS(123),
    [anon_sym_iget_DASHchar] = ACTIONS(123),
    [anon_sym_iget_DASHshort] = ACTIONS(123),
    [anon_sym_iget_DASHvolatile] = ACTIONS(123),
    [anon_sym_iget_DASHwide_DASHvolatile] = ACTIONS(123),
    [anon_sym_iget_DASHobject_DASHvolatile] = ACTIONS(123),
    [anon_sym_iput] = ACTIONS(121),
    [anon_sym_iput_DASHwide] = ACTIONS(121),
    [anon_sym_iput_DASHobject] = ACTIONS(121),
    [anon_sym_iput_DASHboolean] = ACTIONS(121),
    [anon_sym_iput_DASHbyte] = ACTIONS(121),
    [anon_sym_iput_DASHchar] = ACTIONS(121),
    [anon_sym_iput_DASHshort] = ACTIONS(121),
    [anon_sym_iput_DASHvolatile] = ACTIONS(123),
    [anon_sym_iput_DASHwide_DASHvolatile] = ACTIONS(123),
    [anon_sym_iput_DASHobject_DASHvolatile] = ACTIONS(123),
    [anon_sym_sget] = ACTIONS(121),
    [anon_sym_sget_DASHwide] = ACTIONS(121),
    [anon_sym_sget_DASHobject] = ACTIONS(121),
    [anon_sym_sget_DASHboolean] = ACTIONS(123),
    [anon_sym_sget_DASHbyte] = ACTIONS(123),
    [anon_sym_sget_DASHchar] = ACTIONS(123),
    [anon_sym_sget_DASHshort] = ACTIONS(123),
    [anon_sym_sget_DASHvolatile] = ACTIONS(123),
    [anon_sym_sget_DASHwide_DASHvolatile] = ACTIONS(123),
    [anon_sym_sget_DASHobject_DASHvolatile] = ACTIONS(123),
    [anon_sym_sput] = ACTIONS(121),
    [anon_sym_sput_DASHwide] = ACTIONS(121),
    [anon_sym_sput_DASHobject] = ACTIONS(121),
    [anon_sym_sput_DASHboolean] = ACTIONS(123),
    [anon_sym_sput_DASHbyte] = ACTIONS(123),
    [anon_sym_sput_DASHchar] = ACTIONS(123),
    [anon_sym_sput_DASHshort] = ACTIONS(123),
    [anon_sym_sput_DASHvolatile] = ACTIONS(123),
    [anon_sym_sput_DASHwide_DASHvolatile] = ACTIONS(123),
    [anon_sym_sput_DASHobject_DASHvolatile] = ACTIONS(123),
    [anon_sym_invoke_DASHconstructor] = ACTIONS(123),
    [anon_sym_invoke_DASHcustom] = ACTIONS(121),
    [anon_sym_invoke_DASHdirect] = ACTIONS(121),
    [anon_sym_invoke_DASHdirect_DASHempty] = ACTIONS(123),
    [anon_sym_invoke_DASHinstance] = ACTIONS(123),
    [anon_sym_invoke_DASHinterface] = ACTIONS(121),
    [anon_sym_invoke_DASHpolymorphic] = ACTIONS(121),
    [anon_sym_invoke_DASHstatic] = ACTIONS(121),
    [anon_sym_invoke_DASHsuper] = ACTIONS(121),
    [anon_sym_invoke_DASHvirtual] = ACTIONS(121),
    [anon_sym_invoke_DASHcustom_SLASHrange] = ACTIONS(123),
    [anon_sym_invoke_DASHdirect_SLASHrange] = ACTIONS(123),
    [anon_sym_invoke_DASHinterface_SLASHrange] = ACTIONS(123),
    [anon_sym_invoke_DASHobject_DASHinit_SLASHrange] = ACTIONS(123),
    [anon_sym_invoke_DASHpolymorphic_SLASHrange] = ACTIONS(123),
    [anon_sym_invoke_DASHstatic_SLASHrange] = ACTIONS(123),
    [anon_sym_invoke_DASHsuper_SLASHrange] = ACTIONS(123),
    [anon_sym_invoke_DASHvirtual_SLASHrange] = ACTIONS(123),
    [anon_sym_neg_DASHint] = ACTIONS(123),
    [anon_sym_not_DASHint] = ACTIONS(123),
    [anon_sym_neg_DASHlong] = ACTIONS(123),
    [anon_sym_not_DASHlong] = ACTIONS(123),
    [anon_sym_neg_DASHfloat] = ACTIONS(123),
    [anon_sym_neg_DASHdouble] = ACTIONS(123),
    [anon_sym_int_DASHto_DASHlong] = ACTIONS(123),
    [anon_sym_int_DASHto_DASHfloat] = ACTIONS(123),
    [anon_sym_int_DASHto_DASHdouble] = ACTIONS(123),
    [anon_sym_long_DASHto_DASHint] = ACTIONS(123),
    [anon_sym_long_DASHto_DASHfloat] = ACTIONS(123),
    [anon_sym_long_DASHto_DASHdouble] = ACTIONS(123),
    [anon_sym_float_DASHto_DASHint] = ACTIONS(123),
    [anon_sym_float_DASHto_DASHlong] = ACTIONS(123),
    [anon_sym_float_DASHto_DASHdouble] = ACTIONS(123),
    [anon_sym_double_DASHto_DASHint] = ACTIONS(123),
    [anon_sym_double_DASHto_DASHlong] = ACTIONS(123),
    [anon_sym_double_DASHto_DASHfloat] = ACTIONS(123),
    [anon_sym_int_DASHto_DASHbyte] = ACTIONS(123),
    [anon_sym_int_DASHto_DASHchar] = ACTIONS(123),
    [anon_sym_int_DASHto_DASHshort] = ACTIONS(123),
    [anon_sym_add_DASHint] = ACTIONS(121),
    [anon_sym_sub_DASHint] = ACTIONS(121),
    [anon_sym_mul_DASHint] = ACTIONS(121),
    [anon_sym_div_DASHint] = ACTIONS(121),
    [anon_sym_rem_DASHint] = ACTIONS(121),
    [anon_sym_and_DASHint] = ACTIONS(121),
    [anon_sym_or_DASHint] = ACTIONS(121),
    [anon_sym_xor_DASHint] = ACTIONS(121),
    [anon_sym_shl_DASHint] = ACTIONS(121),
    [anon_sym_shr_DASHint] = ACTIONS(121),
    [anon_sym_ushr_DASHint] = ACTIONS(121),
    [anon_sym_add_DASHlong] = ACTIONS(121),
    [anon_sym_sub_DASHlong] = ACTIONS(121),
    [anon_sym_mul_DASHlong] = ACTIONS(121),
    [anon_sym_div_DASHlong] = ACTIONS(121),
    [anon_sym_rem_DASHlong] = ACTIONS(121),
    [anon_sym_and_DASHlong] = ACTIONS(121),
    [anon_sym_or_DASHlong] = ACTIONS(121),
    [anon_sym_xor_DASHlong] = ACTIONS(121),
    [anon_sym_shl_DASHlong] = ACTIONS(121),
    [anon_sym_shr_DASHlong] = ACTIONS(121),
    [anon_sym_ushr_DASHlong] = ACTIONS(121),
    [anon_sym_add_DASHfloat] = ACTIONS(121),
    [anon_sym_sub_DASHfloat] = ACTIONS(121),
    [anon_sym_mul_DASHfloat] = ACTIONS(121),
    [anon_sym_div_DASHfloat] = ACTIONS(121),
    [anon_sym_rem_DASHfloat] = ACTIONS(121),
    [anon_sym_add_DASHdouble] = ACTIONS(121),
    [anon_sym_sub_DASHdouble] = ACTIONS(121),
    [anon_sym_mul_DASHdouble] = ACTIONS(121),
    [anon_sym_div_DASHdouble] = ACTIONS(121),
    [anon_sym_rem_DASHdouble] = ACTIONS(121),
    [anon_sym_add_DASHint_SLASH2addr] = ACTIONS(123),
    [anon_sym_sub_DASHint_SLASH2addr] = ACTIONS(123),
    [anon_sym_mul_DASHint_SLASH2addr] = ACTIONS(123),
    [anon_sym_div_DASHint_SLASH2addr] = ACTIONS(123),
    [anon_sym_rem_DASHint_SLASH2addr] = ACTIONS(123),
    [anon_sym_and_DASHint_SLASH2addr] = ACTIONS(123),
    [anon_sym_or_DASHint_SLASH2addr] = ACTIONS(123),
    [anon_sym_xor_DASHint_SLASH2addr] = ACTIONS(123),
    [anon_sym_shl_DASHint_SLASH2addr] = ACTIONS(123),
    [anon_sym_shr_DASHint_SLASH2addr] = ACTIONS(123),
    [anon_sym_ushr_DASHint_SLASH2addr] = ACTIONS(123),
    [anon_sym_add_DASHlong_SLASH2addr] = ACTIONS(123),
    [anon_sym_sub_DASHlong_SLASH2addr] = ACTIONS(123),
    [anon_sym_mul_DASHlong_SLASH2addr] = ACTIONS(123),
    [anon_sym_div_DASHlong_SLASH2addr] = ACTIONS(123),
    [anon_sym_rem_DASHlong_SLASH2addr] = ACTIONS(123),
    [anon_sym_and_DASHlong_SLASH2addr] = ACTIONS(123),
    [anon_sym_or_DASHlong_SLASH2addr] = ACTIONS(123),
    [anon_sym_xor_DASHlong_SLASH2addr] = ACTIONS(123),
    [anon_sym_shl_DASHlong_SLASH2addr] = ACTIONS(123),
    [anon_sym_shr_DASHlong_SLASH2addr] = ACTIONS(123),
    [anon_sym_ushr_DASHlong_SLASH2addr] = ACTIONS(123),
    [anon_sym_add_DASHfloat_SLASH2addr] = ACTIONS(123),
    [anon_sym_sub_DASHfloat_SLASH2addr] = ACTIONS(123),
    [anon_sym_mul_DASHfloat_SLASH2addr] = ACTIONS(123),
    [anon_sym_div_DASHfloat_SLASH2addr] = ACTIONS(123),
    [anon_sym_rem_DASHfloat_SLASH2addr] = ACTIONS(123),
    [anon_sym_add_DASHdouble_SLASH2addr] = ACTIONS(123),
    [anon_sym_sub_DASHdouble_SLASH2addr] = ACTIONS(123),
    [anon_sym_mul_DASHdouble_SLASH2addr] = ACTIONS(123),
    [anon_sym_div_DASHdouble_SLASH2addr] = ACTIONS(123),
    [anon_sym_rem_DASHdouble_SLASH2addr] = ACTIONS(123),
    [anon_sym_add_DASHint_SLASHlit16] = ACTIONS(123),
    [anon_sym_sub_DASHint_SLASHlit16] = ACTIONS(123),
    [anon_sym_mul_DASHint_SLASHlit16] = ACTIONS(123),
    [anon_sym_div_DASHint_SLASHlit16] = ACTIONS(123),
    [anon_sym_rem_DASHint_SLASHlit16] = ACTIONS(123),
    [anon_sym_and_DASHint_SLASHlit16] = ACTIONS(123),
    [anon_sym_or_DASHint_SLASHlit16] = ACTIONS(123),
    [anon_sym_xor_DASHint_SLASHlit16] = ACTIONS(123),
    [anon_sym_add_DASHint_SLASHlit8] = ACTIONS(123),
    [anon_sym_sub_DASHint_SLASHlit8] = ACTIONS(123),
    [anon_sym_mul_DASHint_SLASHlit8] = ACTIONS(123),
    [anon_sym_div_DASHint_SLASHlit8] = ACTIONS(123),
    [anon_sym_rem_DASHint_SLASHlit8] = ACTIONS(123),
    [anon_sym_and_DASHint_SLASHlit8] = ACTIONS(123),
    [anon_sym_or_DASHint_SLASHlit8] = ACTIONS(123),
    [anon_sym_xor_DASHint_SLASHlit8] = ACTIONS(123),
    [anon_sym_shl_DASHint_SLASHlit8] = ACTIONS(123),
    [anon_sym_shr_DASHint_SLASHlit8] = ACTIONS(123),
    [anon_sym_ushr_DASHint_SLASHlit8] = ACTIONS(123),
    [anon_sym_static_DASHget] = ACTIONS(123),
    [anon_sym_static_DASHput] = ACTIONS(123),
    [anon_sym_instance_DASHget] = ACTIONS(123),
    [anon_sym_instance_DASHput] = ACTIONS(123),
    [anon_sym_execute_DASHinline] = ACTIONS(121),
    [anon_sym_execute_DASHinline_SLASHrange] = ACTIONS(123),
    [anon_sym_iget_DASHquick] = ACTIONS(123),
    [anon_sym_iget_DASHwide_DASHquick] = ACTIONS(123),
    [anon_sym_iget_DASHobject_DASHquick] = ACTIONS(123),
    [anon_sym_iput_DASHquick] = ACTIONS(123),
    [anon_sym_iput_DASHwide_DASHquick] = ACTIONS(123),
    [anon_sym_iput_DASHobject_DASHquick] = ACTIONS(123),
    [anon_sym_iput_DASHboolean_DASHquick] = ACTIONS(123),
    [anon_sym_iput_DASHbyte_DASHquick] = ACTIONS(123),
    [anon_sym_iput_DASHchar_DASHquick] = ACTIONS(123),
    [anon_sym_iput_DASHshort_DASHquick] = ACTIONS(123),
    [anon_sym_invoke_DASHvirtual_DASHquick] = ACTIONS(121),
    [anon_sym_invoke_DASHvirtual_DASHquick_SLASHrange] = ACTIONS(123),
    [anon_sym_invoke_DASHsuper_DASHquick] = ACTIONS(121),
    [anon_sym_invoke_DASHsuper_DASHquick_SLASHrange] = ACTIONS(123),
    [anon_sym_rsub_DASHint] = ACTIONS(121),
    [anon_sym_rsub_DASHint_SLASHlit8] = ACTIONS(123),
    [anon_sym_DOTline] = ACTIONS(125),
    [anon_sym_DOTlocals] = ACTIONS(127),
    [anon_sym_DOTlocal] = ACTIONS(129),
    [anon_sym_DOTendlocal] = ACTIONS(131),
    [anon_sym_DOTrestartlocal] = ACTIONS(133),
    [anon_sym_DOTregisters] = ACTIONS(135),
    [anon_sym_DOTcatch] = ACTIONS(137),
    [anon_sym_DOTcatchall] = ACTIONS(139),
    [anon_sym_DOTpacked_DASHswitch] = ACTIONS(141),
    [anon_sym_DOTsparse_DASHswitch] = ACTIONS(143),
    [anon_sym_DOTarray_DASHdata] = ACTIONS(145),
    [sym_prologue_directive] = ACTIONS(147),
    [sym_epilogue_directive] = ACTIONS(147),
    [aux_sym_label_token1] = ACTIONS(57),
    [aux_sym_jmp_label_token1] = ACTIONS(149),
    [sym_comment] = ACTIONS(3),
  },
  [12] = {
    [sym_source_directive] = STATE(68),
    [sym_annotation_directive] = STATE(59),
    [sym_param_directive] = STATE(68),
    [sym_parameter_directive] = STATE(68),
    [sym_statement] = STATE(12),
    [sym_expression] = STATE(59),
    [sym_opcode] = STATE(2),
    [sym_directive] = STATE(59),
    [sym_line_directive] = STATE(68),
    [sym_locals_directive] = STATE(68),
    [sym_local_directive] = STATE(68),
    [sym_end_local_directive] = STATE(68),
    [sym_restart_local_directive] = STATE(68),
    [sym_registers_directive] = STATE(68),
    [sym_catch_directive] = STATE(68),
    [sym_catchall_directive] = STATE(68),
    [sym_packed_switch_directive] = STATE(68),
    [sym_sparse_switch_directive] = STATE(68),
    [sym_array_data_directive] = STATE(68),
    [sym_label] = STATE(59),
    [sym_jmp_label] = STATE(59),
    [aux_sym_method_definition_repeat1] = STATE(12),
    [anon_sym_DOTsource] = ACTIONS(151),
    [anon_sym_DOTendmethod] = ACTIONS(154),
    [anon_sym_DOTannotation] = ACTIONS(156),
    [anon_sym_DOTparam] = ACTIONS(159),
    [anon_sym_DOTparameter] = ACTIONS(162),
    [anon_sym_nop] = ACTIONS(165),
    [anon_sym_move] = ACTIONS(165),
    [anon_sym_move_SLASHfrom16] = ACTIONS(168),
    [anon_sym_move_SLASH16] = ACTIONS(168),
    [anon_sym_move_DASHwide] = ACTIONS(165),
    [anon_sym_move_DASHwide_SLASHfrom16] = ACTIONS(168),
    [anon_sym_move_DASHwide_SLASH16] = ACTIONS(168),
    [anon_sym_move_DASHobject] = ACTIONS(165),
    [anon_sym_move_DASHobject_SLASHfrom16] = ACTIONS(168),
    [anon_sym_move_DASHobject_SLASH16] = ACTIONS(168),
    [anon_sym_move_DASHresult] = ACTIONS(165),
    [anon_sym_move_DASHresult_DASHwide] = ACTIONS(168),
    [anon_sym_move_DASHresult_DASHobject] = ACTIONS(168),
    [anon_sym_move_DASHexception] = ACTIONS(168),
    [anon_sym_return_DASHvoid] = ACTIONS(168),
    [anon_sym_return] = ACTIONS(165),
    [anon_sym_return_DASHwide] = ACTIONS(168),
    [anon_sym_return_DASHobject] = ACTIONS(168),
    [anon_sym_const_SLASH4] = ACTIONS(168),
    [anon_sym_const_SLASH16] = ACTIONS(168),
    [anon_sym_const] = ACTIONS(165),
    [anon_sym_const_SLASHhigh16] = ACTIONS(168),
    [anon_sym_const_DASHwide_SLASH16] = ACTIONS(168),
    [anon_sym_const_DASHwide_SLASH32] = ACTIONS(168),
    [anon_sym_const_DASHwide] = ACTIONS(165),
    [anon_sym_const_DASHwide_SLASHhigh16] = ACTIONS(168),
    [anon_sym_const_DASHstring] = ACTIONS(165),
    [anon_sym_const_DASHstring_SLASHjumbo] = ACTIONS(168),
    [anon_sym_const_DASHclass] = ACTIONS(168),
    [anon_sym_const_DASHmethod_DASHhandle] = ACTIONS(168),
    [anon_sym_const_DASHmethod_DASHtype] = ACTIONS(168),
    [anon_sym_monitor_DASHenter] = ACTIONS(168),
    [anon_sym_monitor_DASHexit] = ACTIONS(168),
    [anon_sym_check_DASHcast] = ACTIONS(168),
    [anon_sym_instance_DASHof] = ACTIONS(168),
    [anon_sym_array_DASHlength] = ACTIONS(168),
    [anon_sym_new_DASHinstance] = ACTIONS(168),
    [anon_sym_new_DASHarray] = ACTIONS(168),
    [anon_sym_filled_DASHnew_DASHarray] = ACTIONS(165),
    [anon_sym_filled_DASHnew_DASHarray_SLASHrange] = ACTIONS(168),
    [anon_sym_fill_DASHarray_DASHdata] = ACTIONS(168),
    [anon_sym_throw] = ACTIONS(165),
    [anon_sym_throw_DASHverification_DASHerror] = ACTIONS(168),
    [anon_sym_goto] = ACTIONS(165),
    [anon_sym_goto_SLASH16] = ACTIONS(168),
    [anon_sym_goto_SLASH32] = ACTIONS(168),
    [anon_sym_packed_DASHswitch] = ACTIONS(168),
    [anon_sym_sparse_DASHswitch] = ACTIONS(168),
    [anon_sym_cmpl_DASHfloat] = ACTIONS(168),
    [anon_sym_cmpg_DASHfloat] = ACTIONS(168),
    [anon_sym_cmpl_DASHdouble] = ACTIONS(168),
    [anon_sym_cmpg_DASHdouble] = ACTIONS(168),
    [anon_sym_cmp_DASHlong] = ACTIONS(168),
    [anon_sym_if_DASHeq] = ACTIONS(165),
    [anon_sym_if_DASHne] = ACTIONS(165),
    [anon_sym_if_DASHlt] = ACTIONS(165),
    [anon_sym_if_DASHge] = ACTIONS(165),
    [anon_sym_if_DASHgt] = ACTIONS(165),
    [anon_sym_if_DASHle] = ACTIONS(165),
    [anon_sym_if_DASHeqz] = ACTIONS(168),
    [anon_sym_if_DASHnez] = ACTIONS(168),
    [anon_sym_if_DASHltz] = ACTIONS(168),
    [anon_sym_if_DASHgez] = ACTIONS(168),
    [anon_sym_if_DASHgtz] = ACTIONS(168),
    [anon_sym_if_DASHlez] = ACTIONS(168),
    [anon_sym_aget] = ACTIONS(165),
    [anon_sym_aget_DASHwide] = ACTIONS(168),
    [anon_sym_aget_DASHobject] = ACTIONS(168),
    [anon_sym_aget_DASHboolean] = ACTIONS(168),
    [anon_sym_aget_DASHbyte] = ACTIONS(168),
    [anon_sym_aget_DASHchar] = ACTIONS(168),
    [anon_sym_aget_DASHshort] = ACTIONS(168),
    [anon_sym_aput] = ACTIONS(165),
    [anon_sym_aput_DASHwide] = ACTIONS(168),
    [anon_sym_aput_DASHobject] = ACTIONS(168),
    [anon_sym_aput_DASHboolean] = ACTIONS(168),
    [anon_sym_aput_DASHbyte] = ACTIONS(168),
    [anon_sym_aput_DASHchar] = ACTIONS(168),
    [anon_sym_aput_DASHshort] = ACTIONS(168),
    [anon_sym_iget] = ACTIONS(165),
    [anon_sym_iget_DASHwide] = ACTIONS(165),
    [anon_sym_iget_DASHobject] = ACTIONS(165),
    [anon_sym_iget_DASHboolean] = ACTIONS(168),
    [anon_sym_iget_DASHbyte] = ACTIONS(168),
    [anon_sym_iget_DASHchar] = ACTIONS(168),
    [anon_sym_iget_DASHshort] = ACTIONS(168),
    [anon_sym_iget_DASHvolatile] = ACTIONS(168),
    [anon_sym_iget_DASHwide_DASHvolatile] = ACTIONS(168),
    [anon_sym_iget_DASHobject_DASHvolatile] = ACTIONS(168),
    [anon_sym_iput] = ACTIONS(165),
    [anon_sym_iput_DASHwide] = ACTIONS(165),
    [anon_sym_iput_DASHobject] = ACTIONS(165),
    [anon_sym_iput_DASHboolean] = ACTIONS(165),
    [anon_sym_iput_DASHbyte] = ACTIONS(165),
    [anon_sym_iput_DASHchar] = ACTIONS(165),
    [anon_sym_iput_DASHshort] = ACTIONS(165),
    [anon_sym_iput_DASHvolatile] = ACTIONS(168),
    [anon_sym_iput_DASHwide_DASHvolatile] = ACTIONS(168),
    [anon_sym_iput_DASHobject_DASHvolatile] = ACTIONS(168),
    [anon_sym_sget] = ACTIONS(165),
    [anon_sym_sget_DASHwide] = ACTIONS(165),
    [anon_sym_sget_DASHobject] = ACTIONS(165),
    [anon_sym_sget_DASHboolean] = ACTIONS(168),
    [anon_sym_sget_DASHbyte] = ACTIONS(168),
    [anon_sym_sget_DASHchar] = ACTIONS(168),
    [anon_sym_sget_DASHshort] = ACTIONS(168),
    [anon_sym_sget_DASHvolatile] = ACTIONS(168),
    [anon_sym_sget_DASHwide_DASHvolatile] = ACTIONS(168),
    [anon_sym_sget_DASHobject_DASHvolatile] = ACTIONS(168),
    [anon_sym_sput] = ACTIONS(165),
    [anon_sym_sput_DASHwide] = ACTIONS(165),
    [anon_sym_sput_DASHobject] = ACTIONS(165),
    [anon_sym_sput_DASHboolean] = ACTIONS(168),
    [anon_sym_sput_DASHbyte] = ACTIONS(168),
    [anon_sym_sput_DASHchar] = ACTIONS(168),
    [anon_sym_sput_DASHshort] = ACTIONS(168),
    [anon_sym_sput_DASHvolatile] = ACTIONS(168),
    [anon_sym_sput_DASHwide_DASHvolatile] = ACTIONS(168),
    [anon_sym_sput_DASHobject_DASHvolatile] = ACTIONS(168),
    [anon_sym_invoke_DASHconstructor] = ACTIONS(168),
    [anon_sym_invoke_DASHcustom] = ACTIONS(165),
    [anon_sym_invoke_DASHdirect] = ACTIONS(165),
    [anon_sym_invoke_DASHdirect_DASHempty] = ACTIONS(168),
    [anon_sym_invoke_DASHinstance] = ACTIONS(168),
    [anon_sym_invoke_DASHinterface] = ACTIONS(165),
    [anon_sym_invoke_DASHpolymorphic] = ACTIONS(165),
    [anon_sym_invoke_DASHstatic] = ACTIONS(165),
    [anon_sym_invoke_DASHsuper] = ACTIONS(165),
    [anon_sym_invoke_DASHvirtual] = ACTIONS(165),
    [anon_sym_invoke_DASHcustom_SLASHrange] = ACTIONS(168),
    [anon_sym_invoke_DASHdirect_SLASHrange] = ACTIONS(168),
    [anon_sym_invoke_DASHinterface_SLASHrange] = ACTIONS(168),
    [anon_sym_invoke_DASHobject_DASHinit_SLASHrange] = ACTIONS(168),
    [anon_sym_invoke_DASHpolymorphic_SLASHrange] = ACTIONS(168),
    [anon_sym_invoke_DASHstatic_SLASHrange] = ACTIONS(168),
    [anon_sym_invoke_DASHsuper_SLASHrange] = ACTIONS(168),
    [anon_sym_invoke_DASHvirtual_SLASHrange] = ACTIONS(168),
    [anon_sym_neg_DASHint] = ACTIONS(168),
    [anon_sym_not_DASHint] = ACTIONS(168),
    [anon_sym_neg_DASHlong] = ACTIONS(168),
    [anon_sym_not_DASHlong] = ACTIONS(168),
    [anon_sym_neg_DASHfloat] = ACTIONS(168),
    [anon_sym_neg_DASHdouble] = ACTIONS(168),
    [anon_sym_int_DASHto_DASHlong] = ACTIONS(168),
    [anon_sym_int_DASHto_DASHfloat] = ACTIONS(168),
    [anon_sym_int_DASHto_DASHdouble] = ACTIONS(168),
    [anon_sym_long_DASHto_DASHint] = ACTIONS(168),
    [anon_sym_long_DASHto_DASHfloat] = ACTIONS(168),
    [anon_sym_long_DASHto_DASHdouble] = ACTIONS(168),
    [anon_sym_float_DASHto_DASHint] = ACTIONS(168),
    [anon_sym_float_DASHto_DASHlong] = ACTIONS(168),
    [anon_sym_float_DASHto_DASHdouble] = ACTIONS(168),
    [anon_sym_double_DASHto_DASHint] = ACTIONS(168),
    [anon_sym_double_DASHto_DASHlong] = ACTIONS(168),
    [anon_sym_double_DASHto_DASHfloat] = ACTIONS(168),
    [anon_sym_int_DASHto_DASHbyte] = ACTIONS(168),
    [anon_sym_int_DASHto_DASHchar] = ACTIONS(168),
    [anon_sym_int_DASHto_DASHshort] = ACTIONS(168),
    [anon_sym_add_DASHint] = ACTIONS(165),
    [anon_sym_sub_DASHint] = ACTIONS(165),
    [anon_sym_mul_DASHint] = ACTIONS(165),
    [anon_sym_div_DASHint] = ACTIONS(165),
    [anon_sym_rem_DASHint] = ACTIONS(165),
    [anon_sym_and_DASHint] = ACTIONS(165),
    [anon_sym_or_DASHint] = ACTIONS(165),
    [anon_sym_xor_DASHint] = ACTIONS(165),
    [anon_sym_shl_DASHint] = ACTIONS(165),
    [anon_sym_shr_DASHint] = ACTIONS(165),
    [anon_sym_ushr_DASHint] = ACTIONS(165),
    [anon_sym_add_DASHlong] = ACTIONS(165),
    [anon_sym_sub_DASHlong] = ACTIONS(165),
    [anon_sym_mul_DASHlong] = ACTIONS(165),
    [anon_sym_div_DASHlong] = ACTIONS(165),
    [anon_sym_rem_DASHlong] = ACTIONS(165),
    [anon_sym_and_DASHlong] = ACTIONS(165),
    [anon_sym_or_DASHlong] = ACTIONS(165),
    [anon_sym_xor_DASHlong] = ACTIONS(165),
    [anon_sym_shl_DASHlong] = ACTIONS(165),
    [anon_sym_shr_DASHlong] = ACTIONS(165),
    [anon_sym_ushr_DASHlong] = ACTIONS(165),
    [anon_sym_add_DASHfloat] = ACTIONS(165),
    [anon_sym_sub_DASHfloat] = ACTIONS(165),
    [anon_sym_mul_DASHfloat] = ACTIONS(165),
    [anon_sym_div_DASHfloat] = ACTIONS(165),
    [anon_sym_rem_DASHfloat] = ACTIONS(165),
    [anon_sym_add_DASHdouble] = ACTIONS(165),
    [anon_sym_sub_DASHdouble] = ACTIONS(165),
    [anon_sym_mul_DASHdouble] = ACTIONS(165),
    [anon_sym_div_DASHdouble] = ACTIONS(165),
    [anon_sym_rem_DASHdouble] = ACTIONS(165),
    [anon_sym_add_DASHint_SLASH2addr] = ACTIONS(168),
    [anon_sym_sub_DASHint_SLASH2addr] = ACTIONS(168),
    [anon_sym_mul_DASHint_SLASH2addr] = ACTIONS(168),
    [anon_sym_div_DASHint_SLASH2addr] = ACTIONS(168),
    [anon_sym_rem_DASHint_SLASH2addr] = ACTIONS(168),
    [anon_sym_and_DASHint_SLASH2addr] = ACTIONS(168),
    [anon_sym_or_DASHint_SLASH2addr] = ACTIONS(168),
    [anon_sym_xor_DASHint_SLASH2addr] = ACTIONS(168),
    [anon_sym_shl_DASHint_SLASH2addr] = ACTIONS(168),
    [anon_sym_shr_DASHint_SLASH2addr] = ACTIONS(168),
    [anon_sym_ushr_DASHint_SLASH2addr] = ACTIONS(168),
    [anon_sym_add_DASHlong_SLASH2addr] = ACTIONS(168),
    [anon_sym_sub_DASHlong_SLASH2addr] = ACTIONS(168),
    [anon_sym_mul_DASHlong_SLASH2addr] = ACTIONS(168),
    [anon_sym_div_DASHlong_SLASH2addr] = ACTIONS(168),
    [anon_sym_rem_DASHlong_SLASH2addr] = ACTIONS(168),
    [anon_sym_and_DASHlong_SLASH2addr] = ACTIONS(168),
    [anon_sym_or_DASHlong_SLASH2addr] = ACTIONS(168),
    [anon_sym_xor_DASHlong_SLASH2addr] = ACTIONS(168),
    [anon_sym_shl_DASHlong_SLASH2addr] = ACTIONS(168),
    [anon_sym_shr_DASHlong_SLASH2addr] = ACTIONS(168),
    [anon_sym_ushr_DASHlong_SLASH2addr] = ACTIONS(168),
    [anon_sym_add_DASHfloat_SLASH2addr] = ACTIONS(168),
    [anon_sym_sub_DASHfloat_SLASH2addr] = ACTIONS(168),
    [anon_sym_mul_DASHfloat_SLASH2addr] = ACTIONS(168),
    [anon_sym_div_DASHfloat_SLASH2addr] = ACTIONS(168),
    [anon_sym_rem_DASHfloat_SLASH2addr] = ACTIONS(168),
    [anon_sym_add_DASHdouble_SLASH2addr] = ACTIONS(168),
    [anon_sym_sub_DASHdouble_SLASH2addr] = ACTIONS(168),
    [anon_sym_mul_DASHdouble_SLASH2addr] = ACTIONS(168),
    [anon_sym_div_DASHdouble_SLASH2addr] = ACTIONS(168),
    [anon_sym_rem_DASHdouble_SLASH2addr] = ACTIONS(168),
    [anon_sym_add_DASHint_SLASHlit16] = ACTIONS(168),
    [anon_sym_sub_DASHint_SLASHlit16] = ACTIONS(168),
    [anon_sym_mul_DASHint_SLASHlit16] = ACTIONS(168),
    [anon_sym_div_DASHint_SLASHlit16] = ACTIONS(168),
    [anon_sym_rem_DASHint_SLASHlit16] = ACTIONS(168),
    [anon_sym_and_DASHint_SLASHlit16] = ACTIONS(168),
    [anon_sym_or_DASHint_SLASHlit16] = ACTIONS(168),
    [anon_sym_xor_DASHint_SLASHlit16] = ACTIONS(168),
    [anon_sym_add_DASHint_SLASHlit8] = ACTIONS(168),
    [anon_sym_sub_DASHint_SLASHlit8] = ACTIONS(168),
    [anon_sym_mul_DASHint_SLASHlit8] = ACTIONS(168),
    [anon_sym_div_DASHint_SLASHlit8] = ACTIONS(168),
    [anon_sym_rem_DASHint_SLASHlit8] = ACTIONS(168),
    [anon_sym_and_DASHint_SLASHlit8] = ACTIONS(168),
    [anon_sym_or_DASHint_SLASHlit8] = ACTIONS(168),
    [anon_sym_xor_DASHint_SLASHlit8] = ACTIONS(168),
    [anon_sym_shl_DASHint_SLASHlit8] = ACTIONS(168),
    [anon_sym_shr_DASHint_SLASHlit8] = ACTIONS(168),
    [anon_sym_ushr_DASHint_SLASHlit8] = ACTIONS(168),
    [anon_sym_static_DASHget] = ACTIONS(168),
    [anon_sym_static_DASHput] = ACTIONS(168),
    [anon_sym_instance_DASHget] = ACTIONS(168),
    [anon_sym_instance_DASHput] = ACTIONS(168),
    [anon_sym_execute_DASHinline] = ACTIONS(165),
    [anon_sym_execute_DASHinline_SLASHrange] = ACTIONS(168),
    [anon_sym_iget_DASHquick] = ACTIONS(168),
    [anon_sym_iget_DASHwide_DASHquick] = ACTIONS(168),
    [anon_sym_iget_DASHobject_DASHquick] = ACTIONS(168),
    [anon_sym_iput_DASHquick] = ACTIONS(168),
    [anon_sym_iput_DASHwide_DASHquick] = ACTIONS(168),
    [anon_sym_iput_DASHobject_DASHquick] = ACTIONS(168),
    [anon_sym_iput_DASHboolean_DASHquick] = ACTIONS(168),
    [anon_sym_iput_DASHbyte_DASHquick] = ACTIONS(168),
    [anon_sym_iput_DASHchar_DASHquick] = ACTIONS(168),
    [anon_sym_iput_DASHshort_DASHquick] = ACTIONS(168),
    [anon_sym_invoke_DASHvirtual_DASHquick] = ACTIONS(165),
    [anon_sym_invoke_DASHvirtual_DASHquick_SLASHrange] = ACTIONS(168),
    [anon_sym_invoke_DASHsuper_DASHquick] = ACTIONS(165),
    [anon_sym_invoke_DASHsuper_DASHquick_SLASHrange] = ACTIONS(168),
    [anon_sym_rsub_DASHint] = ACTIONS(165),
    [anon_sym_rsub_DASHint_SLASHlit8] = ACTIONS(168),
    [anon_sym_DOTline] = ACTIONS(171),
    [anon_sym_DOTlocals] = ACTIONS(174),
    [anon_sym_DOTlocal] = ACTIONS(177),
    [anon_sym_DOTendlocal] = ACTIONS(180),
    [anon_sym_DOTrestartlocal] = ACTIONS(183),
    [anon_sym_DOTregisters] = ACTIONS(186),
    [anon_sym_DOTcatch] = ACTIONS(189),
    [anon_sym_DOTcatchall] = ACTIONS(192),
    [anon_sym_DOTpacked_DASHswitch] = ACTIONS(195),
    [anon_sym_DOTsparse_DASHswitch] = ACTIONS(198),
    [anon_sym_DOTarray_DASHdata] = ACTIONS(201),
    [sym_prologue_directive] = ACTIONS(204),
    [sym_epilogue_directive] = ACTIONS(204),
    [aux_sym_label_token1] = ACTIONS(207),
    [aux_sym_jmp_label_token1] = ACTIONS(210),
    [sym_comment] = ACTIONS(3),
  },
  [13] = {
    [sym_source_directive] = STATE(68),
    [sym_annotation_directive] = STATE(59),
    [sym_param_directive] = STATE(68),
    [sym_parameter_directive] = STATE(68),
    [sym_statement] = STATE(12),
    [sym_expression] = STATE(59),
    [sym_opcode] = STATE(2),
    [sym_directive] = STATE(59),
    [sym_line_directive] = STATE(68),
    [sym_locals_directive] = STATE(68),
    [sym_local_directive] = STATE(68),
    [sym_end_local_directive] = STATE(68),
    [sym_restart_local_directive] = STATE(68),
    [sym_registers_directive] = STATE(68),
    [sym_catch_directive] = STATE(68),
    [sym_catchall_directive] = STATE(68),
    [sym_packed_switch_directive] = STATE(68),
    [sym_sparse_switch_directive] = STATE(68),
    [sym_array_data_directive] = STATE(68),
    [sym_label] = STATE(59),
    [sym_jmp_label] = STATE(59),
    [aux_sym_method_definition_repeat1] = STATE(12),
    [anon_sym_DOTsource] = ACTIONS(111),
    [anon_sym_DOTendmethod] = ACTIONS(213),
    [anon_sym_DOTannotation] = ACTIONS(115),
    [anon_sym_DOTparam] = ACTIONS(117),
    [anon_sym_DOTparameter] = ACTIONS(119),
    [anon_sym_nop] = ACTIONS(121),
    [anon_sym_move] = ACTIONS(121),
    [anon_sym_move_SLASHfrom16] = ACTIONS(123),
    [anon_sym_move_SLASH16] = ACTIONS(123),
    [anon_sym_move_DASHwide] = ACTIONS(121),
    [anon_sym_move_DASHwide_SLASHfrom16] = ACTIONS(123),
    [anon_sym_move_DASHwide_SLASH16] = ACTIONS(123),
    [anon_sym_move_DASHobject] = ACTIONS(121),
    [anon_sym_move_DASHobject_SLASHfrom16] = ACTIONS(123),
    [anon_sym_move_DASHobject_SLASH16] = ACTIONS(123),
    [anon_sym_move_DASHresult] = ACTIONS(121),
    [anon_sym_move_DASHresult_DASHwide] = ACTIONS(123),
    [anon_sym_move_DASHresult_DASHobject] = ACTIONS(123),
    [anon_sym_move_DASHexception] = ACTIONS(123),
    [anon_sym_return_DASHvoid] = ACTIONS(123),
    [anon_sym_return] = ACTIONS(121),
    [anon_sym_return_DASHwide] = ACTIONS(123),
    [anon_sym_return_DASHobject] = ACTIONS(123),
    [anon_sym_const_SLASH4] = ACTIONS(123),
    [anon_sym_const_SLASH16] = ACTIONS(123),
    [anon_sym_const] = ACTIONS(121),
    [anon_sym_const_SLASHhigh16] = ACTIONS(123),
    [anon_sym_const_DASHwide_SLASH16] = ACTIONS(123),
    [anon_sym_const_DASHwide_SLASH32] = ACTIONS(123),
    [anon_sym_const_DASHwide] = ACTIONS(121),
    [anon_sym_const_DASHwide_SLASHhigh16] = ACTIONS(123),
    [anon_sym_const_DASHstring] = ACTIONS(121),
    [anon_sym_const_DASHstring_SLASHjumbo] = ACTIONS(123),
    [anon_sym_const_DASHclass] = ACTIONS(123),
    [anon_sym_const_DASHmethod_DASHhandle] = ACTIONS(123),
    [anon_sym_const_DASHmethod_DASHtype] = ACTIONS(123),
    [anon_sym_monitor_DASHenter] = ACTIONS(123),
    [anon_sym_monitor_DASHexit] = ACTIONS(123),
    [anon_sym_check_DASHcast] = ACTIONS(123),
    [anon_sym_instance_DASHof] = ACTIONS(123),
    [anon_sym_array_DASHlength] = ACTIONS(123),
    [anon_sym_new_DASHinstance] = ACTIONS(123),
    [anon_sym_new_DASHarray] = ACTIONS(123),
    [anon_sym_filled_DASHnew_DASHarray] = ACTIONS(121),
    [anon_sym_filled_DASHnew_DASHarray_SLASHrange] = ACTIONS(123),
    [anon_sym_fill_DASHarray_DASHdata] = ACTIONS(123),
    [anon_sym_throw] = ACTIONS(121),
    [anon_sym_throw_DASHverification_DASHerror] = ACTIONS(123),
    [anon_sym_goto] = ACTIONS(121),
    [anon_sym_goto_SLASH16] = ACTIONS(123),
    [anon_sym_goto_SLASH32] = ACTIONS(123),
    [anon_sym_packed_DASHswitch] = ACTIONS(123),
    [anon_sym_sparse_DASHswitch] = ACTIONS(123),
    [anon_sym_cmpl_DASHfloat] = ACTIONS(123),
    [anon_sym_cmpg_DASHfloat] = ACTIONS(123),
    [anon_sym_cmpl_DASHdouble] = ACTIONS(123),
    [anon_sym_cmpg_DASHdouble] = ACTIONS(123),
    [anon_sym_cmp_DASHlong] = ACTIONS(123),
    [anon_sym_if_DASHeq] = ACTIONS(121),
    [anon_sym_if_DASHne] = ACTIONS(121),
    [anon_sym_if_DASHlt] = ACTIONS(121),
    [anon_sym_if_DASHge] = ACTIONS(121),
    [anon_sym_if_DASHgt] = ACTIONS(121),
    [anon_sym_if_DASHle] = ACTIONS(121),
    [anon_sym_if_DASHeqz] = ACTIONS(123),
    [anon_sym_if_DASHnez] = ACTIONS(123),
    [anon_sym_if_DASHltz] = ACTIONS(123),
    [anon_sym_if_DASHgez] = ACTIONS(123),
    [anon_sym_if_DASHgtz] = ACTIONS(123),
    [anon_sym_if_DASHlez] = ACTIONS(123),
    [anon_sym_aget] = ACTIONS(121),
    [anon_sym_aget_DASHwide] = ACTIONS(123),
    [anon_sym_aget_DASHobject] = ACTIONS(123),
    [anon_sym_aget_DASHboolean] = ACTIONS(123),
    [anon_sym_aget_DASHbyte] = ACTIONS(123),
    [anon_sym_aget_DASHchar] = ACTIONS(123),
    [anon_sym_aget_DASHshort] = ACTIONS(123),
    [anon_sym_aput] = ACTIONS(121),
    [anon_sym_aput_DASHwide] = ACTIONS(123),
    [anon_sym_aput_DASHobject] = ACTIONS(123),
    [anon_sym_aput_DASHboolean] = ACTIONS(123),
    [anon_sym_aput_DASHbyte] = ACTIONS(123),
    [anon_sym_aput_DASHchar] = ACTIONS(123),
    [anon_sym_aput_DASHshort] = ACTIONS(123),
    [anon_sym_iget] = ACTIONS(121),
    [anon_sym_iget_DASHwide] = ACTIONS(121),
    [anon_sym_iget_DASHobject] = ACTIONS(121),
    [anon_sym_iget_DASHboolean] = ACTIONS(123),
    [anon_sym_iget_DASHbyte] = ACTIONS(123),
    [anon_sym_iget_DASHchar] = ACTIONS(123),
    [anon_sym_iget_DASHshort] = ACTIONS(123),
    [anon_sym_iget_DASHvolatile] = ACTIONS(123),
    [anon_sym_iget_DASHwide_DASHvolatile] = ACTIONS(123),
    [anon_sym_iget_DASHobject_DASHvolatile] = ACTIONS(123),
    [anon_sym_iput] = ACTIONS(121),
    [anon_sym_iput_DASHwide] = ACTIONS(121),
    [anon_sym_iput_DASHobject] = ACTIONS(121),
    [anon_sym_iput_DASHboolean] = ACTIONS(121),
    [anon_sym_iput_DASHbyte] = ACTIONS(121),
    [anon_sym_iput_DASHchar] = ACTIONS(121),
    [anon_sym_iput_DASHshort] = ACTIONS(121),
    [anon_sym_iput_DASHvolatile] = ACTIONS(123),
    [anon_sym_iput_DASHwide_DASHvolatile] = ACTIONS(123),
    [anon_sym_iput_DASHobject_DASHvolatile] = ACTIONS(123),
    [anon_sym_sget] = ACTIONS(121),
    [anon_sym_sget_DASHwide] = ACTIONS(121),
    [anon_sym_sget_DASHobject] = ACTIONS(121),
    [anon_sym_sget_DASHboolean] = ACTIONS(123),
    [anon_sym_sget_DASHbyte] = ACTIONS(123),
    [anon_sym_sget_DASHchar] = ACTIONS(123),
    [anon_sym_sget_DASHshort] = ACTIONS(123),
    [anon_sym_sget_DASHvolatile] = ACTIONS(123),
    [anon_sym_sget_DASHwide_DASHvolatile] = ACTIONS(123),
    [anon_sym_sget_DASHobject_DASHvolatile] = ACTIONS(123),
    [anon_sym_sput] = ACTIONS(121),
    [anon_sym_sput_DASHwide] = ACTIONS(121),
    [anon_sym_sput_DASHobject] = ACTIONS(121),
    [anon_sym_sput_DASHboolean] = ACTIONS(123),
    [anon_sym_sput_DASHbyte] = ACTIONS(123),
    [anon_sym_sput_DASHchar] = ACTIONS(123),
    [anon_sym_sput_DASHshort] = ACTIONS(123),
    [anon_sym_sput_DASHvolatile] = ACTIONS(123),
    [anon_sym_sput_DASHwide_DASHvolatile] = ACTIONS(123),
    [anon_sym_sput_DASHobject_DASHvolatile] = ACTIONS(123),
    [anon_sym_invoke_DASHconstructor] = ACTIONS(123),
    [anon_sym_invoke_DASHcustom] = ACTIONS(121),
    [anon_sym_invoke_DASHdirect] = ACTIONS(121),
    [anon_sym_invoke_DASHdirect_DASHempty] = ACTIONS(123),
    [anon_sym_invoke_DASHinstance] = ACTIONS(123),
    [anon_sym_invoke_DASHinterface] = ACTIONS(121),
    [anon_sym_invoke_DASHpolymorphic] = ACTIONS(121),
    [anon_sym_invoke_DASHstatic] = ACTIONS(121),
    [anon_sym_invoke_DASHsuper] = ACTIONS(121),
    [anon_sym_invoke_DASHvirtual] = ACTIONS(121),
    [anon_sym_invoke_DASHcustom_SLASHrange] = ACTIONS(123),
    [anon_sym_invoke_DASHdirect_SLASHrange] = ACTIONS(123),
    [anon_sym_invoke_DASHinterface_SLASHrange] = ACTIONS(123),
    [anon_sym_invoke_DASHobject_DASHinit_SLASHrange] = ACTIONS(123),
    [anon_sym_invoke_DASHpolymorphic_SLASHrange] = ACTIONS(123),
    [anon_sym_invoke_DASHstatic_SLASHrange] = ACTIONS(123),
    [anon_sym_invoke_DASHsuper_SLASHrange] = ACTIONS(123),
    [anon_sym_invoke_DASHvirtual_SLASHrange] = ACTIONS(123),
    [anon_sym_neg_DASHint] = ACTIONS(123),
    [anon_sym_not_DASHint] = ACTIONS(123),
    [anon_sym_neg_DASHlong] = ACTIONS(123),
    [anon_sym_not_DASHlong] = ACTIONS(123),
    [anon_sym_neg_DASHfloat] = ACTIONS(123),
    [anon_sym_neg_DASHdouble] = ACTIONS(123),
    [anon_sym_int_DASHto_DASHlong] = ACTIONS(123),
    [anon_sym_int_DASHto_DASHfloat] = ACTIONS(123),
    [anon_sym_int_DASHto_DASHdouble] = ACTIONS(123),
    [anon_sym_long_DASHto_DASHint] = ACTIONS(123),
    [anon_sym_long_DASHto_DASHfloat] = ACTIONS(123),
    [anon_sym_long_DASHto_DASHdouble] = ACTIONS(123),
    [anon_sym_float_DASHto_DASHint] = ACTIONS(123),
    [anon_sym_float_DASHto_DASHlong] = ACTIONS(123),
    [anon_sym_float_DASHto_DASHdouble] = ACTIONS(123),
    [anon_sym_double_DASHto_DASHint] = ACTIONS(123),
    [anon_sym_double_DASHto_DASHlong] = ACTIONS(123),
    [anon_sym_double_DASHto_DASHfloat] = ACTIONS(123),
    [anon_sym_int_DASHto_DASHbyte] = ACTIONS(123),
    [anon_sym_int_DASHto_DASHchar] = ACTIONS(123),
    [anon_sym_int_DASHto_DASHshort] = ACTIONS(123),
    [anon_sym_add_DASHint] = ACTIONS(121),
    [anon_sym_sub_DASHint] = ACTIONS(121),
    [anon_sym_mul_DASHint] = ACTIONS(121),
    [anon_sym_div_DASHint] = ACTIONS(121),
    [anon_sym_rem_DASHint] = ACTIONS(121),
    [anon_sym_and_DASHint] = ACTIONS(121),
    [anon_sym_or_DASHint] = ACTIONS(121),
    [anon_sym_xor_DASHint] = ACTIONS(121),
    [anon_sym_shl_DASHint] = ACTIONS(121),
    [anon_sym_shr_DASHint] = ACTIONS(121),
    [anon_sym_ushr_DASHint] = ACTIONS(121),
    [anon_sym_add_DASHlong] = ACTIONS(121),
    [anon_sym_sub_DASHlong] = ACTIONS(121),
    [anon_sym_mul_DASHlong] = ACTIONS(121),
    [anon_sym_div_DASHlong] = ACTIONS(121),
    [anon_sym_rem_DASHlong] = ACTIONS(121),
    [anon_sym_and_DASHlong] = ACTIONS(121),
    [anon_sym_or_DASHlong] = ACTIONS(121),
    [anon_sym_xor_DASHlong] = ACTIONS(121),
    [anon_sym_shl_DASHlong] = ACTIONS(121),
    [anon_sym_shr_DASHlong] = ACTIONS(121),
    [anon_sym_ushr_DASHlong] = ACTIONS(121),
    [anon_sym_add_DASHfloat] = ACTIONS(121),
    [anon_sym_sub_DASHfloat] = ACTIONS(121),
    [anon_sym_mul_DASHfloat] = ACTIONS(121),
    [anon_sym_div_DASHfloat] = ACTIONS(121),
    [anon_sym_rem_DASHfloat] = ACTIONS(121),
    [anon_sym_add_DASHdouble] = ACTIONS(121),
    [anon_sym_sub_DASHdouble] = ACTIONS(121),
    [anon_sym_mul_DASHdouble] = ACTIONS(121),
    [anon_sym_div_DASHdouble] = ACTIONS(121),
    [anon_sym_rem_DASHdouble] = ACTIONS(121),
    [anon_sym_add_DASHint_SLASH2addr] = ACTIONS(123),
    [anon_sym_sub_DASHint_SLASH2addr] = ACTIONS(123),
    [anon_sym_mul_DASHint_SLASH2addr] = ACTIONS(123),
    [anon_sym_div_DASHint_SLASH2addr] = ACTIONS(123),
    [anon_sym_rem_DASHint_SLASH2addr] = ACTIONS(123),
    [anon_sym_and_DASHint_SLASH2addr] = ACTIONS(123),
    [anon_sym_or_DASHint_SLASH2addr] = ACTIONS(123),
    [anon_sym_xor_DASHint_SLASH2addr] = ACTIONS(123),
    [anon_sym_shl_DASHint_SLASH2addr] = ACTIONS(123),
    [anon_sym_shr_DASHint_SLASH2addr] = ACTIONS(123),
    [anon_sym_ushr_DASHint_SLASH2addr] = ACTIONS(123),
    [anon_sym_add_DASHlong_SLASH2addr] = ACTIONS(123),
    [anon_sym_sub_DASHlong_SLASH2addr] = ACTIONS(123),
    [anon_sym_mul_DASHlong_SLASH2addr] = ACTIONS(123),
    [anon_sym_div_DASHlong_SLASH2addr] = ACTIONS(123),
    [anon_sym_rem_DASHlong_SLASH2addr] = ACTIONS(123),
    [anon_sym_and_DASHlong_SLASH2addr] = ACTIONS(123),
    [anon_sym_or_DASHlong_SLASH2addr] = ACTIONS(123),
    [anon_sym_xor_DASHlong_SLASH2addr] = ACTIONS(123),
    [anon_sym_shl_DASHlong_SLASH2addr] = ACTIONS(123),
    [anon_sym_shr_DASHlong_SLASH2addr] = ACTIONS(123),
    [anon_sym_ushr_DASHlong_SLASH2addr] = ACTIONS(123),
    [anon_sym_add_DASHfloat_SLASH2addr] = ACTIONS(123),
    [anon_sym_sub_DASHfloat_SLASH2addr] = ACTIONS(123),
    [anon_sym_mul_DASHfloat_SLASH2addr] = ACTIONS(123),
    [anon_sym_div_DASHfloat_SLASH2addr] = ACTIONS(123),
    [anon_sym_rem_DASHfloat_SLASH2addr] = ACTIONS(123),
    [anon_sym_add_DASHdouble_SLASH2addr] = ACTIONS(123),
    [anon_sym_sub_DASHdouble_SLASH2addr] = ACTIONS(123),
    [anon_sym_mul_DASHdouble_SLASH2addr] = ACTIONS(123),
    [anon_sym_div_DASHdouble_SLASH2addr] = ACTIONS(123),
    [anon_sym_rem_DASHdouble_SLASH2addr] = ACTIONS(123),
    [anon_sym_add_DASHint_SLASHlit16] = ACTIONS(123),
    [anon_sym_sub_DASHint_SLASHlit16] = ACTIONS(123),
    [anon_sym_mul_DASHint_SLASHlit16] = ACTIONS(123),
    [anon_sym_div_DASHint_SLASHlit16] = ACTIONS(123),
    [anon_sym_rem_DASHint_SLASHlit16] = ACTIONS(123),
    [anon_sym_and_DASHint_SLASHlit16] = ACTIONS(123),
    [anon_sym_or_DASHint_SLASHlit16] = ACTIONS(123),
    [anon_sym_xor_DASHint_SLASHlit16] = ACTIONS(123),
    [anon_sym_add_DASHint_SLASHlit8] = ACTIONS(123),
    [anon_sym_sub_DASHint_SLASHlit8] = ACTIONS(123),
    [anon_sym_mul_DASHint_SLASHlit8] = ACTIONS(123),
    [anon_sym_div_DASHint_SLASHlit8] = ACTIONS(123),
    [anon_sym_rem_DASHint_SLASHlit8] = ACTIONS(123),
    [anon_sym_and_DASHint_SLASHlit8] = ACTIONS(123),
    [anon_sym_or_DASHint_SLASHlit8] = ACTIONS(123),
    [anon_sym_xor_DASHint_SLASHlit8] = ACTIONS(123),
    [anon_sym_shl_DASHint_SLASHlit8] = ACTIONS(123),
    [anon_sym_shr_DASHint_SLASHlit8] = ACTIONS(123),
    [anon_sym_ushr_DASHint_SLASHlit8] = ACTIONS(123),
    [anon_sym_static_DASHget] = ACTIONS(123),
    [anon_sym_static_DASHput] = ACTIONS(123),
    [anon_sym_instance_DASHget] = ACTIONS(123),
    [anon_sym_instance_DASHput] = ACTIONS(123),
    [anon_sym_execute_DASHinline] = ACTIONS(121),
    [anon_sym_execute_DASHinline_SLASHrange] = ACTIONS(123),
    [anon_sym_iget_DASHquick] = ACTIONS(123),
    [anon_sym_iget_DASHwide_DASHquick] = ACTIONS(123),
    [anon_sym_iget_DASHobject_DASHquick] = ACTIONS(123),
    [anon_sym_iput_DASHquick] = ACTIONS(123),
    [anon_sym_iput_DASHwide_DASHquick] = ACTIONS(123),
    [anon_sym_iput_DASHobject_DASHquick] = ACTIONS(123),
    [anon_sym_iput_DASHboolean_DASHquick] = ACTIONS(123),
    [anon_sym_iput_DASHbyte_DASHquick] = ACTIONS(123),
    [anon_sym_iput_DASHchar_DASHquick] = ACTIONS(123),
    [anon_sym_iput_DASHshort_DASHquick] = ACTIONS(123),
    [anon_sym_invoke_DASHvirtual_DASHquick] = ACTIONS(121),
    [anon_sym_invoke_DASHvirtual_DASHquick_SLASHrange] = ACTIONS(123),
    [anon_sym_invoke_DASHsuper_DASHquick] = ACTIONS(121),
    [anon_sym_invoke_DASHsuper_DASHquick_SLASHrange] = ACTIONS(123),
    [anon_sym_rsub_DASHint] = ACTIONS(121),
    [anon_sym_rsub_DASHint_SLASHlit8] = ACTIONS(123),
    [anon_sym_DOTline] = ACTIONS(125),
    [anon_sym_DOTlocals] = ACTIONS(127),
    [anon_sym_DOTlocal] = ACTIONS(129),
    [anon_sym_DOTendlocal] = ACTIONS(131),
    [anon_sym_DOTrestartlocal] = ACTIONS(133),
    [anon_sym_DOTregisters] = ACTIONS(135),
    [anon_sym_DOTcatch] = ACTIONS(137),
    [anon_sym_DOTcatchall] = ACTIONS(139),
    [anon_sym_DOTpacked_DASHswitch] = ACTIONS(141),
    [anon_sym_DOTsparse_DASHswitch] = ACTIONS(143),
    [anon_sym_DOTarray_DASHdata] = ACTIONS(145),
    [sym_prologue_directive] = ACTIONS(147),
    [sym_epilogue_directive] = ACTIONS(147),
    [aux_sym_label_token1] = ACTIONS(57),
    [aux_sym_jmp_label_token1] = ACTIONS(149),
    [sym_comment] = ACTIONS(3),
  },
  [14] = {
    [sym_source_directive] = STATE(68),
    [sym_annotation_directive] = STATE(59),
    [sym_param_directive] = STATE(68),
    [sym_parameter_directive] = STATE(68),
    [sym_statement] = STATE(11),
    [sym_expression] = STATE(59),
    [sym_opcode] = STATE(2),
    [sym_directive] = STATE(59),
    [sym_line_directive] = STATE(68),
    [sym_locals_directive] = STATE(68),
    [sym_local_directive] = STATE(68),
    [sym_end_local_directive] = STATE(68),
    [sym_restart_local_directive] = STATE(68),
    [sym_registers_directive] = STATE(68),
    [sym_catch_directive] = STATE(68),
    [sym_catchall_directive] = STATE(68),
    [sym_packed_switch_directive] = STATE(68),
    [sym_sparse_switch_directive] = STATE(68),
    [sym_array_data_directive] = STATE(68),
    [sym_label] = STATE(59),
    [sym_jmp_label] = STATE(59),
    [aux_sym_method_definition_repeat1] = STATE(11),
    [anon_sym_DOTsource] = ACTIONS(111),
    [anon_sym_DOTendmethod] = ACTIONS(215),
    [anon_sym_DOTannotation] = ACTIONS(115),
    [anon_sym_DOTparam] = ACTIONS(117),
    [anon_sym_DOTparameter] = ACTIONS(119),
    [anon_sym_nop] = ACTIONS(121),
    [anon_sym_move] = ACTIONS(121),
    [anon_sym_move_SLASHfrom16] = ACTIONS(123),
    [anon_sym_move_SLASH16] = ACTIONS(123),
    [anon_sym_move_DASHwide] = ACTIONS(121),
    [anon_sym_move_DASHwide_SLASHfrom16] = ACTIONS(123),
    [anon_sym_move_DASHwide_SLASH16] = ACTIONS(123),
    [anon_sym_move_DASHobject] = ACTIONS(121),
    [anon_sym_move_DASHobject_SLASHfrom16] = ACTIONS(123),
    [anon_sym_move_DASHobject_SLASH16] = ACTIONS(123),
    [anon_sym_move_DASHresult] = ACTIONS(121),
    [anon_sym_move_DASHresult_DASHwide] = ACTIONS(123),
    [anon_sym_move_DASHresult_DASHobject] = ACTIONS(123),
    [anon_sym_move_DASHexception] = ACTIONS(123),
    [anon_sym_return_DASHvoid] = ACTIONS(123),
    [anon_sym_return] = ACTIONS(121),
    [anon_sym_return_DASHwide] = ACTIONS(123),
    [anon_sym_return_DASHobject] = ACTIONS(123),
    [anon_sym_const_SLASH4] = ACTIONS(123),
    [anon_sym_const_SLASH16] = ACTIONS(123),
    [anon_sym_const] = ACTIONS(121),
    [anon_sym_const_SLASHhigh16] = ACTIONS(123),
    [anon_sym_const_DASHwide_SLASH16] = ACTIONS(123),
    [anon_sym_const_DASHwide_SLASH32] = ACTIONS(123),
    [anon_sym_const_DASHwide] = ACTIONS(121),
    [anon_sym_const_DASHwide_SLASHhigh16] = ACTIONS(123),
    [anon_sym_const_DASHstring] = ACTIONS(121),
    [anon_sym_const_DASHstring_SLASHjumbo] = ACTIONS(123),
    [anon_sym_const_DASHclass] = ACTIONS(123),
    [anon_sym_const_DASHmethod_DASHhandle] = ACTIONS(123),
    [anon_sym_const_DASHmethod_DASHtype] = ACTIONS(123),
    [anon_sym_monitor_DASHenter] = ACTIONS(123),
    [anon_sym_monitor_DASHexit] = ACTIONS(123),
    [anon_sym_check_DASHcast] = ACTIONS(123),
    [anon_sym_instance_DASHof] = ACTIONS(123),
    [anon_sym_array_DASHlength] = ACTIONS(123),
    [anon_sym_new_DASHinstance] = ACTIONS(123),
    [anon_sym_new_DASHarray] = ACTIONS(123),
    [anon_sym_filled_DASHnew_DASHarray] = ACTIONS(121),
    [anon_sym_filled_DASHnew_DASHarray_SLASHrange] = ACTIONS(123),
    [anon_sym_fill_DASHarray_DASHdata] = ACTIONS(123),
    [anon_sym_throw] = ACTIONS(121),
    [anon_sym_throw_DASHverification_DASHerror] = ACTIONS(123),
    [anon_sym_goto] = ACTIONS(121),
    [anon_sym_goto_SLASH16] = ACTIONS(123),
    [anon_sym_goto_SLASH32] = ACTIONS(123),
    [anon_sym_packed_DASHswitch] = ACTIONS(123),
    [anon_sym_sparse_DASHswitch] = ACTIONS(123),
    [anon_sym_cmpl_DASHfloat] = ACTIONS(123),
    [anon_sym_cmpg_DASHfloat] = ACTIONS(123),
    [anon_sym_cmpl_DASHdouble] = ACTIONS(123),
    [anon_sym_cmpg_DASHdouble] = ACTIONS(123),
    [anon_sym_cmp_DASHlong] = ACTIONS(123),
    [anon_sym_if_DASHeq] = ACTIONS(121),
    [anon_sym_if_DASHne] = ACTIONS(121),
    [anon_sym_if_DASHlt] = ACTIONS(121),
    [anon_sym_if_DASHge] = ACTIONS(121),
    [anon_sym_if_DASHgt] = ACTIONS(121),
    [anon_sym_if_DASHle] = ACTIONS(121),
    [anon_sym_if_DASHeqz] = ACTIONS(123),
    [anon_sym_if_DASHnez] = ACTIONS(123),
    [anon_sym_if_DASHltz] = ACTIONS(123),
    [anon_sym_if_DASHgez] = ACTIONS(123),
    [anon_sym_if_DASHgtz] = ACTIONS(123),
    [anon_sym_if_DASHlez] = ACTIONS(123),
    [anon_sym_aget] = ACTIONS(121),
    [anon_sym_aget_DASHwide] = ACTIONS(123),
    [anon_sym_aget_DASHobject] = ACTIONS(123),
    [anon_sym_aget_DASHboolean] = ACTIONS(123),
    [anon_sym_aget_DASHbyte] = ACTIONS(123),
    [anon_sym_aget_DASHchar] = ACTIONS(123),
    [anon_sym_aget_DASHshort] = ACTIONS(123),
    [anon_sym_aput] = ACTIONS(121),
    [anon_sym_aput_DASHwide] = ACTIONS(123),
    [anon_sym_aput_DASHobject] = ACTIONS(123),
    [anon_sym_aput_DASHboolean] = ACTIONS(123),
    [anon_sym_aput_DASHbyte] = ACTIONS(123),
    [anon_sym_aput_DASHchar] = ACTIONS(123),
    [anon_sym_aput_DASHshort] = ACTIONS(123),
    [anon_sym_iget] = ACTIONS(121),
    [anon_sym_iget_DASHwide] = ACTIONS(121),
    [anon_sym_iget_DASHobject] = ACTIONS(121),
    [anon_sym_iget_DASHboolean] = ACTIONS(123),
    [anon_sym_iget_DASHbyte] = ACTIONS(123),
    [anon_sym_iget_DASHchar] = ACTIONS(123),
    [anon_sym_iget_DASHshort] = ACTIONS(123),
    [anon_sym_iget_DASHvolatile] = ACTIONS(123),
    [anon_sym_iget_DASHwide_DASHvolatile] = ACTIONS(123),
    [anon_sym_iget_DASHobject_DASHvolatile] = ACTIONS(123),
    [anon_sym_iput] = ACTIONS(121),
    [anon_sym_iput_DASHwide] = ACTIONS(121),
    [anon_sym_iput_DASHobject] = ACTIONS(121),
    [anon_sym_iput_DASHboolean] = ACTIONS(121),
    [anon_sym_iput_DASHbyte] = ACTIONS(121),
    [anon_sym_iput_DASHchar] = ACTIONS(121),
    [anon_sym_iput_DASHshort] = ACTIONS(121),
    [anon_sym_iput_DASHvolatile] = ACTIONS(123),
    [anon_sym_iput_DASHwide_DASHvolatile] = ACTIONS(123),
    [anon_sym_iput_DASHobject_DASHvolatile] = ACTIONS(123),
    [anon_sym_sget] = ACTIONS(121),
    [anon_sym_sget_DASHwide] = ACTIONS(121),
    [anon_sym_sget_DASHobject] = ACTIONS(121),
    [anon_sym_sget_DASHboolean] = ACTIONS(123),
    [anon_sym_sget_DASHbyte] = ACTIONS(123),
    [anon_sym_sget_DASHchar] = ACTIONS(123),
    [anon_sym_sget_DASHshort] = ACTIONS(123),
    [anon_sym_sget_DASHvolatile] = ACTIONS(123),
    [anon_sym_sget_DASHwide_DASHvolatile] = ACTIONS(123),
    [anon_sym_sget_DASHobject_DASHvolatile] = ACTIONS(123),
    [anon_sym_sput] = ACTIONS(121),
    [anon_sym_sput_DASHwide] = ACTIONS(121),
    [anon_sym_sput_DASHobject] = ACTIONS(121),
    [anon_sym_sput_DASHboolean] = ACTIONS(123),
    [anon_sym_sput_DASHbyte] = ACTIONS(123),
    [anon_sym_sput_DASHchar] = ACTIONS(123),
    [anon_sym_sput_DASHshort] = ACTIONS(123),
    [anon_sym_sput_DASHvolatile] = ACTIONS(123),
    [anon_sym_sput_DASHwide_DASHvolatile] = ACTIONS(123),
    [anon_sym_sput_DASHobject_DASHvolatile] = ACTIONS(123),
    [anon_sym_invoke_DASHconstructor] = ACTIONS(123),
    [anon_sym_invoke_DASHcustom] = ACTIONS(121),
    [anon_sym_invoke_DASHdirect] = ACTIONS(121),
    [anon_sym_invoke_DASHdirect_DASHempty] = ACTIONS(123),
    [anon_sym_invoke_DASHinstance] = ACTIONS(123),
    [anon_sym_invoke_DASHinterface] = ACTIONS(121),
    [anon_sym_invoke_DASHpolymorphic] = ACTIONS(121),
    [anon_sym_invoke_DASHstatic] = ACTIONS(121),
    [anon_sym_invoke_DASHsuper] = ACTIONS(121),
    [anon_sym_invoke_DASHvirtual] = ACTIONS(121),
    [anon_sym_invoke_DASHcustom_SLASHrange] = ACTIONS(123),
    [anon_sym_invoke_DASHdirect_SLASHrange] = ACTIONS(123),
    [anon_sym_invoke_DASHinterface_SLASHrange] = ACTIONS(123),
    [anon_sym_invoke_DASHobject_DASHinit_SLASHrange] = ACTIONS(123),
    [anon_sym_invoke_DASHpolymorphic_SLASHrange] = ACTIONS(123),
    [anon_sym_invoke_DASHstatic_SLASHrange] = ACTIONS(123),
    [anon_sym_invoke_DASHsuper_SLASHrange] = ACTIONS(123),
    [anon_sym_invoke_DASHvirtual_SLASHrange] = ACTIONS(123),
    [anon_sym_neg_DASHint] = ACTIONS(123),
    [anon_sym_not_DASHint] = ACTIONS(123),
    [anon_sym_neg_DASHlong] = ACTIONS(123),
    [anon_sym_not_DASHlong] = ACTIONS(123),
    [anon_sym_neg_DASHfloat] = ACTIONS(123),
    [anon_sym_neg_DASHdouble] = ACTIONS(123),
    [anon_sym_int_DASHto_DASHlong] = ACTIONS(123),
    [anon_sym_int_DASHto_DASHfloat] = ACTIONS(123),
    [anon_sym_int_DASHto_DASHdouble] = ACTIONS(123),
    [anon_sym_long_DASHto_DASHint] = ACTIONS(123),
    [anon_sym_long_DASHto_DASHfloat] = ACTIONS(123),
    [anon_sym_long_DASHto_DASHdouble] = ACTIONS(123),
    [anon_sym_float_DASHto_DASHint] = ACTIONS(123),
    [anon_sym_float_DASHto_DASHlong] = ACTIONS(123),
    [anon_sym_float_DASHto_DASHdouble] = ACTIONS(123),
    [anon_sym_double_DASHto_DASHint] = ACTIONS(123),
    [anon_sym_double_DASHto_DASHlong] = ACTIONS(123),
    [anon_sym_double_DASHto_DASHfloat] = ACTIONS(123),
    [anon_sym_int_DASHto_DASHbyte] = ACTIONS(123),
    [anon_sym_int_DASHto_DASHchar] = ACTIONS(123),
    [anon_sym_int_DASHto_DASHshort] = ACTIONS(123),
    [anon_sym_add_DASHint] = ACTIONS(121),
    [anon_sym_sub_DASHint] = ACTIONS(121),
    [anon_sym_mul_DASHint] = ACTIONS(121),
    [anon_sym_div_DASHint] = ACTIONS(121),
    [anon_sym_rem_DASHint] = ACTIONS(121),
    [anon_sym_and_DASHint] = ACTIONS(121),
    [anon_sym_or_DASHint] = ACTIONS(121),
    [anon_sym_xor_DASHint] = ACTIONS(121),
    [anon_sym_shl_DASHint] = ACTIONS(121),
    [anon_sym_shr_DASHint] = ACTIONS(121),
    [anon_sym_ushr_DASHint] = ACTIONS(121),
    [anon_sym_add_DASHlong] = ACTIONS(121),
    [anon_sym_sub_DASHlong] = ACTIONS(121),
    [anon_sym_mul_DASHlong] = ACTIONS(121),
    [anon_sym_div_DASHlong] = ACTIONS(121),
    [anon_sym_rem_DASHlong] = ACTIONS(121),
    [anon_sym_and_DASHlong] = ACTIONS(121),
    [anon_sym_or_DASHlong] = ACTIONS(121),
    [anon_sym_xor_DASHlong] = ACTIONS(121),
    [anon_sym_shl_DASHlong] = ACTIONS(121),
    [anon_sym_shr_DASHlong] = ACTIONS(121),
    [anon_sym_ushr_DASHlong] = ACTIONS(121),
    [anon_sym_add_DASHfloat] = ACTIONS(121),
    [anon_sym_sub_DASHfloat] = ACTIONS(121),
    [anon_sym_mul_DASHfloat] = ACTIONS(121),
    [anon_sym_div_DASHfloat] = ACTIONS(121),
    [anon_sym_rem_DASHfloat] = ACTIONS(121),
    [anon_sym_add_DASHdouble] = ACTIONS(121),
    [anon_sym_sub_DASHdouble] = ACTIONS(121),
    [anon_sym_mul_DASHdouble] = ACTIONS(121),
    [anon_sym_div_DASHdouble] = ACTIONS(121),
    [anon_sym_rem_DASHdouble] = ACTIONS(121),
    [anon_sym_add_DASHint_SLASH2addr] = ACTIONS(123),
    [anon_sym_sub_DASHint_SLASH2addr] = ACTIONS(123),
    [anon_sym_mul_DASHint_SLASH2addr] = ACTIONS(123),
    [anon_sym_div_DASHint_SLASH2addr] = ACTIONS(123),
    [anon_sym_rem_DASHint_SLASH2addr] = ACTIONS(123),
    [anon_sym_and_DASHint_SLASH2addr] = ACTIONS(123),
    [anon_sym_or_DASHint_SLASH2addr] = ACTIONS(123),
    [anon_sym_xor_DASHint_SLASH2addr] = ACTIONS(123),
    [anon_sym_shl_DASHint_SLASH2addr] = ACTIONS(123),
    [anon_sym_shr_DASHint_SLASH2addr] = ACTIONS(123),
    [anon_sym_ushr_DASHint_SLASH2addr] = ACTIONS(123),
    [anon_sym_add_DASHlong_SLASH2addr] = ACTIONS(123),
    [anon_sym_sub_DASHlong_SLASH2addr] = ACTIONS(123),
    [anon_sym_mul_DASHlong_SLASH2addr] = ACTIONS(123),
    [anon_sym_div_DASHlong_SLASH2addr] = ACTIONS(123),
    [anon_sym_rem_DASHlong_SLASH2addr] = ACTIONS(123),
    [anon_sym_and_DASHlong_SLASH2addr] = ACTIONS(123),
    [anon_sym_or_DASHlong_SLASH2addr] = ACTIONS(123),
    [anon_sym_xor_DASHlong_SLASH2addr] = ACTIONS(123),
    [anon_sym_shl_DASHlong_SLASH2addr] = ACTIONS(123),
    [anon_sym_shr_DASHlong_SLASH2addr] = ACTIONS(123),
    [anon_sym_ushr_DASHlong_SLASH2addr] = ACTIONS(123),
    [anon_sym_add_DASHfloat_SLASH2addr] = ACTIONS(123),
    [anon_sym_sub_DASHfloat_SLASH2addr] = ACTIONS(123),
    [anon_sym_mul_DASHfloat_SLASH2addr] = ACTIONS(123),
    [anon_sym_div_DASHfloat_SLASH2addr] = ACTIONS(123),
    [anon_sym_rem_DASHfloat_SLASH2addr] = ACTIONS(123),
    [anon_sym_add_DASHdouble_SLASH2addr] = ACTIONS(123),
    [anon_sym_sub_DASHdouble_SLASH2addr] = ACTIONS(123),
    [anon_sym_mul_DASHdouble_SLASH2addr] = ACTIONS(123),
    [anon_sym_div_DASHdouble_SLASH2addr] = ACTIONS(123),
    [anon_sym_rem_DASHdouble_SLASH2addr] = ACTIONS(123),
    [anon_sym_add_DASHint_SLASHlit16] = ACTIONS(123),
    [anon_sym_sub_DASHint_SLASHlit16] = ACTIONS(123),
    [anon_sym_mul_DASHint_SLASHlit16] = ACTIONS(123),
    [anon_sym_div_DASHint_SLASHlit16] = ACTIONS(123),
    [anon_sym_rem_DASHint_SLASHlit16] = ACTIONS(123),
    [anon_sym_and_DASHint_SLASHlit16] = ACTIONS(123),
    [anon_sym_or_DASHint_SLASHlit16] = ACTIONS(123),
    [anon_sym_xor_DASHint_SLASHlit16] = ACTIONS(123),
    [anon_sym_add_DASHint_SLASHlit8] = ACTIONS(123),
    [anon_sym_sub_DASHint_SLASHlit8] = ACTIONS(123),
    [anon_sym_mul_DASHint_SLASHlit8] = ACTIONS(123),
    [anon_sym_div_DASHint_SLASHlit8] = ACTIONS(123),
    [anon_sym_rem_DASHint_SLASHlit8] = ACTIONS(123),
    [anon_sym_and_DASHint_SLASHlit8] = ACTIONS(123),
    [anon_sym_or_DASHint_SLASHlit8] = ACTIONS(123),
    [anon_sym_xor_DASHint_SLASHlit8] = ACTIONS(123),
    [anon_sym_shl_DASHint_SLASHlit8] = ACTIONS(123),
    [anon_sym_shr_DASHint_SLASHlit8] = ACTIONS(123),
    [anon_sym_ushr_DASHint_SLASHlit8] = ACTIONS(123),
    [anon_sym_static_DASHget] = ACTIONS(123),
    [anon_sym_static_DASHput] = ACTIONS(123),
    [anon_sym_instance_DASHget] = ACTIONS(123),
    [anon_sym_instance_DASHput] = ACTIONS(123),
    [anon_sym_execute_DASHinline] = ACTIONS(121),
    [anon_sym_execute_DASHinline_SLASHrange] = ACTIONS(123),
    [anon_sym_iget_DASHquick] = ACTIONS(123),
    [anon_sym_iget_DASHwide_DASHquick] = ACTIONS(123),
    [anon_sym_iget_DASHobject_DASHquick] = ACTIONS(123),
    [anon_sym_iput_DASHquick] = ACTIONS(123),
    [anon_sym_iput_DASHwide_DASHquick] = ACTIONS(123),
    [anon_sym_iput_DASHobject_DASHquick] = ACTIONS(123),
    [anon_sym_iput_DASHboolean_DASHquick] = ACTIONS(123),
    [anon_sym_iput_DASHbyte_DASHquick] = ACTIONS(123),
    [anon_sym_iput_DASHchar_DASHquick] = ACTIONS(123),
    [anon_sym_iput_DASHshort_DASHquick] = ACTIONS(123),
    [anon_sym_invoke_DASHvirtual_DASHquick] = ACTIONS(121),
    [anon_sym_invoke_DASHvirtual_DASHquick_SLASHrange] = ACTIONS(123),
    [anon_sym_invoke_DASHsuper_DASHquick] = ACTIONS(121),
    [anon_sym_invoke_DASHsuper_DASHquick_SLASHrange] = ACTIONS(123),
    [anon_sym_rsub_DASHint] = ACTIONS(121),
    [anon_sym_rsub_DASHint_SLASHlit8] = ACTIONS(123),
    [anon_sym_DOTline] = ACTIONS(125),
    [anon_sym_DOTlocals] = ACTIONS(127),
    [anon_sym_DOTlocal] = ACTIONS(129),
    [anon_sym_DOTendlocal] = ACTIONS(131),
    [anon_sym_DOTrestartlocal] = ACTIONS(133),
    [anon_sym_DOTregisters] = ACTIONS(135),
    [anon_sym_DOTcatch] = ACTIONS(137),
    [anon_sym_DOTcatchall] = ACTIONS(139),
    [anon_sym_DOTpacked_DASHswitch] = ACTIONS(141),
    [anon_sym_DOTsparse_DASHswitch] = ACTIONS(143),
    [anon_sym_DOTarray_DASHdata] = ACTIONS(145),
    [sym_prologue_directive] = ACTIONS(147),
    [sym_epilogue_directive] = ACTIONS(147),
    [aux_sym_label_token1] = ACTIONS(57),
    [aux_sym_jmp_label_token1] = ACTIONS(149),
    [sym_comment] = ACTIONS(3),
  },
  [15] = {
    [sym_annotation_directive] = STATE(211),
    [sym_literal] = STATE(47),
    [sym_string] = STATE(25),
    [sym_boolean] = STATE(25),
    [sym_character] = STATE(25),
    [aux_sym_field_definition_repeat1] = STATE(211),
    [sym_identifier] = ACTIONS(217),
    [anon_sym_DOTsource] = ACTIONS(219),
    [anon_sym_DOTendmethod] = ACTIONS(219),
    [anon_sym_DOTannotation] = ACTIONS(221),
    [anon_sym_DOTparam] = ACTIONS(223),
    [anon_sym_DOTendparam] = ACTIONS(225),
    [anon_sym_COMMA] = ACTIONS(227),
    [anon_sym_DOTparameter] = ACTIONS(219),
    [anon_sym_nop] = ACTIONS(223),
    [anon_sym_move] = ACTIONS(223),
    [anon_sym_move_SLASHfrom16] = ACTIONS(219),
    [anon_sym_move_SLASH16] = ACTIONS(219),
    [anon_sym_move_DASHwide] = ACTIONS(223),
    [anon_sym_move_DASHwide_SLASHfrom16] = ACTIONS(219),
    [anon_sym_move_DASHwide_SLASH16] = ACTIONS(219),
    [anon_sym_move_DASHobject] = ACTIONS(223),
    [anon_sym_move_DASHobject_SLASHfrom16] = ACTIONS(219),
    [anon_sym_move_DASHobject_SLASH16] = ACTIONS(219),
    [anon_sym_move_DASHresult] = ACTIONS(223),
    [anon_sym_move_DASHresult_DASHwide] = ACTIONS(223),
    [anon_sym_move_DASHresult_DASHobject] = ACTIONS(223),
    [anon_sym_move_DASHexception] = ACTIONS(223),
    [anon_sym_return_DASHvoid] = ACTIONS(223),
    [anon_sym_return] = ACTIONS(223),
    [anon_sym_return_DASHwide] = ACTIONS(223),
    [anon_sym_return_DASHobject] = ACTIONS(223),
    [anon_sym_const_SLASH4] = ACTIONS(219),
    [anon_sym_const_SLASH16] = ACTIONS(219),
    [anon_sym_const] = ACTIONS(223),
    [anon_sym_const_SLASHhigh16] = ACTIONS(219),
    [anon_sym_const_DASHwide_SLASH16] = ACTIONS(219),
    [anon_sym_const_DASHwide_SLASH32] = ACTIONS(219),
    [anon_sym_const_DASHwide] = ACTIONS(223),
    [anon_sym_const_DASHwide_SLASHhigh16] = ACTIONS(219),
    [anon_sym_const_DASHstring] = ACTIONS(223),
    [anon_sym_const_DASHstring_SLASHjumbo] = ACTIONS(219),
    [anon_sym_const_DASHclass] = ACTIONS(223),
    [anon_sym_const_DASHmethod_DASHhandle] = ACTIONS(223),
    [anon_sym_const_DASHmethod_DASHtype] = ACTIONS(223),
    [anon_sym_monitor_DASHenter] = ACTIONS(223),
    [anon_sym_monitor_DASHexit] = ACTIONS(223),
    [anon_sym_check_DASHcast] = ACTIONS(223),
    [anon_sym_instance_DASHof] = ACTIONS(223),
    [anon_sym_array_DASHlength] = ACTIONS(223),
    [anon_sym_new_DASHinstance] = ACTIONS(223),
    [anon_sym_new_DASHarray] = ACTIONS(223),
    [anon_sym_filled_DASHnew_DASHarray] = ACTIONS(223),
    [anon_sym_filled_DASHnew_DASHarray_SLASHrange] = ACTIONS(219),
    [anon_sym_fill_DASHarray_DASHdata] = ACTIONS(223),
    [anon_sym_throw] = ACTIONS(223),
    [anon_sym_throw_DASHverification_DASHerror] = ACTIONS(223),
    [anon_sym_goto] = ACTIONS(223),
    [anon_sym_goto_SLASH16] = ACTIONS(219),
    [anon_sym_goto_SLASH32] = ACTIONS(219),
    [anon_sym_packed_DASHswitch] = ACTIONS(223),
    [anon_sym_sparse_DASHswitch] = ACTIONS(223),
    [anon_sym_cmpl_DASHfloat] = ACTIONS(223),
    [anon_sym_cmpg_DASHfloat] = ACTIONS(223),
    [anon_sym_cmpl_DASHdouble] = ACTIONS(223),
    [anon_sym_cmpg_DASHdouble] = ACTIONS(223),
    [anon_sym_cmp_DASHlong] = ACTIONS(223),
    [anon_sym_if_DASHeq] = ACTIONS(223),
    [anon_sym_if_DASHne] = ACTIONS(223),
    [anon_sym_if_DASHlt] = ACTIONS(223),
    [anon_sym_if_DASHge] = ACTIONS(223),
    [anon_sym_if_DASHgt] = ACTIONS(223),
    [anon_sym_if_DASHle] = ACTIONS(223),
    [anon_sym_if_DASHeqz] = ACTIONS(223),
    [anon_sym_if_DASHnez] = ACTIONS(223),
    [anon_sym_if_DASHltz] = ACTIONS(223),
    [anon_sym_if_DASHgez] = ACTIONS(223),
    [anon_sym_if_DASHgtz] = ACTIONS(223),
    [anon_sym_if_DASHlez] = ACTIONS(223),
    [anon_sym_aget] = ACTIONS(223),
    [anon_sym_aget_DASHwide] = ACTIONS(223),
    [anon_sym_aget_DASHobject] = ACTIONS(223),
    [anon_sym_aget_DASHboolean] = ACTIONS(223),
    [anon_sym_aget_DASHbyte] = ACTIONS(223),
    [anon_sym_aget_DASHchar] = ACTIONS(223),
    [anon_sym_aget_DASHshort] = ACTIONS(223),
    [anon_sym_aput] = ACTIONS(223),
    [anon_sym_aput_DASHwide] = ACTIONS(223),
    [anon_sym_aput_DASHobject] = ACTIONS(223),
    [anon_sym_aput_DASHboolean] = ACTIONS(223),
    [anon_sym_aput_DASHbyte] = ACTIONS(223),
    [anon_sym_aput_DASHchar] = ACTIONS(223),
    [anon_sym_aput_DASHshort] = ACTIONS(223),
    [anon_sym_iget] = ACTIONS(223),
    [anon_sym_iget_DASHwide] = ACTIONS(223),
    [anon_sym_iget_DASHobject] = ACTIONS(223),
    [anon_sym_iget_DASHboolean] = ACTIONS(223),
    [anon_sym_iget_DASHbyte] = ACTIONS(223),
    [anon_sym_iget_DASHchar] = ACTIONS(223),
    [anon_sym_iget_DASHshort] = ACTIONS(223),
    [anon_sym_iget_DASHvolatile] = ACTIONS(223),
    [anon_sym_iget_DASHwide_DASHvolatile] = ACTIONS(223),
    [anon_sym_iget_DASHobject_DASHvolatile] = ACTIONS(223),
    [anon_sym_iput] = ACTIONS(223),
    [anon_sym_iput_DASHwide] = ACTIONS(223),
    [anon_sym_iput_DASHobject] = ACTIONS(223),
    [anon_sym_iput_DASHboolean] = ACTIONS(223),
    [anon_sym_iput_DASHbyte] = ACTIONS(223),
    [anon_sym_iput_DASHchar] = ACTIONS(223),
    [anon_sym_iput_DASHshort] = ACTIONS(223),
    [anon_sym_iput_DASHvolatile] = ACTIONS(223),
    [anon_sym_iput_DASHwide_DASHvolatile] = ACTIONS(223),
    [anon_sym_iput_DASHobject_DASHvolatile] = ACTIONS(223),
    [anon_sym_sget] = ACTIONS(223),
    [anon_sym_sget_DASHwide] = ACTIONS(223),
    [anon_sym_sget_DASHobject] = ACTIONS(223),
    [anon_sym_sget_DASHboolean] = ACTIONS(223),
    [anon_sym_sget_DASHbyte] = ACTIONS(223),
    [anon_sym_sget_DASHchar] = ACTIONS(223),
    [anon_sym_sget_DASHshort] = ACTIONS(223),
    [anon_sym_sget_DASHvolatile] = ACTIONS(223),
    [anon_sym_sget_DASHwide_DASHvolatile] = ACTIONS(223),
    [anon_sym_sget_DASHobject_DASHvolatile] = ACTIONS(223),
    [anon_sym_sput] = ACTIONS(223),
    [anon_sym_sput_DASHwide] = ACTIONS(223),
    [anon_sym_sput_DASHobject] = ACTIONS(223),
    [anon_sym_sput_DASHboolean] = ACTIONS(223),
    [anon_sym_sput_DASHbyte] = ACTIONS(223),
    [anon_sym_sput_DASHchar] = ACTIONS(223),
    [anon_sym_sput_DASHshort] = ACTIONS(223),
    [anon_sym_sput_DASHvolatile] = ACTIONS(223),
    [anon_sym_sput_DASHwide_DASHvolatile] = ACTIONS(223),
    [anon_sym_sput_DASHobject_DASHvolatile] = ACTIONS(223),
    [anon_sym_invoke_DASHconstructor] = ACTIONS(223),
    [anon_sym_invoke_DASHcustom] = ACTIONS(223),
    [anon_sym_invoke_DASHdirect] = ACTIONS(223),
    [anon_sym_invoke_DASHdirect_DASHempty] = ACTIONS(223),
    [anon_sym_invoke_DASHinstance] = ACTIONS(223),
    [anon_sym_invoke_DASHinterface] = ACTIONS(223),
    [anon_sym_invoke_DASHpolymorphic] = ACTIONS(223),
    [anon_sym_invoke_DASHstatic] = ACTIONS(223),
    [anon_sym_invoke_DASHsuper] = ACTIONS(223),
    [anon_sym_invoke_DASHvirtual] = ACTIONS(223),
    [anon_sym_invoke_DASHcustom_SLASHrange] = ACTIONS(219),
    [anon_sym_invoke_DASHdirect_SLASHrange] = ACTIONS(219),
    [anon_sym_invoke_DASHinterface_SLASHrange] = ACTIONS(219),
    [anon_sym_invoke_DASHobject_DASHinit_SLASHrange] = ACTIONS(219),
    [anon_sym_invoke_DASHpolymorphic_SLASHrange] = ACTIONS(219),
    [anon_sym_invoke_DASHstatic_SLASHrange] = ACTIONS(219),
    [anon_sym_invoke_DASHsuper_SLASHrange] = ACTIONS(219),
    [anon_sym_invoke_DASHvirtual_SLASHrange] = ACTIONS(219),
    [anon_sym_neg_DASHint] = ACTIONS(223),
    [anon_sym_not_DASHint] = ACTIONS(223),
    [anon_sym_neg_DASHlong] = ACTIONS(223),
    [anon_sym_not_DASHlong] = ACTIONS(223),
    [anon_sym_neg_DASHfloat] = ACTIONS(223),
    [anon_sym_neg_DASHdouble] = ACTIONS(223),
    [anon_sym_int_DASHto_DASHlong] = ACTIONS(223),
    [anon_sym_int_DASHto_DASHfloat] = ACTIONS(223),
    [anon_sym_int_DASHto_DASHdouble] = ACTIONS(223),
    [anon_sym_long_DASHto_DASHint] = ACTIONS(223),
    [anon_sym_long_DASHto_DASHfloat] = ACTIONS(223),
    [anon_sym_long_DASHto_DASHdouble] = ACTIONS(223),
    [anon_sym_float_DASHto_DASHint] = ACTIONS(223),
    [anon_sym_float_DASHto_DASHlong] = ACTIONS(223),
    [anon_sym_float_DASHto_DASHdouble] = ACTIONS(223),
    [anon_sym_double_DASHto_DASHint] = ACTIONS(223),
    [anon_sym_double_DASHto_DASHlong] = ACTIONS(223),
    [anon_sym_double_DASHto_DASHfloat] = ACTIONS(223),
    [anon_sym_int_DASHto_DASHbyte] = ACTIONS(223),
    [anon_sym_int_DASHto_DASHchar] = ACTIONS(223),
    [anon_sym_int_DASHto_DASHshort] = ACTIONS(223),
    [anon_sym_add_DASHint] = ACTIONS(223),
    [anon_sym_sub_DASHint] = ACTIONS(223),
    [anon_sym_mul_DASHint] = ACTIONS(223),
    [anon_sym_div_DASHint] = ACTIONS(223),
    [anon_sym_rem_DASHint] = ACTIONS(223),
    [anon_sym_and_DASHint] = ACTIONS(223),
    [anon_sym_or_DASHint] = ACTIONS(223),
    [anon_sym_xor_DASHint] = ACTIONS(223),
    [anon_sym_shl_DASHint] = ACTIONS(223),
    [anon_sym_shr_DASHint] = ACTIONS(223),
    [anon_sym_ushr_DASHint] = ACTIONS(223),
    [anon_sym_add_DASHlong] = ACTIONS(223),
    [anon_sym_sub_DASHlong] = ACTIONS(223),
    [anon_sym_mul_DASHlong] = ACTIONS(223),
    [anon_sym_div_DASHlong] = ACTIONS(223),
    [anon_sym_rem_DASHlong] = ACTIONS(223),
    [anon_sym_and_DASHlong] = ACTIONS(223),
    [anon_sym_or_DASHlong] = ACTIONS(223),
    [anon_sym_xor_DASHlong] = ACTIONS(223),
    [anon_sym_shl_DASHlong] = ACTIONS(223),
    [anon_sym_shr_DASHlong] = ACTIONS(223),
    [anon_sym_ushr_DASHlong] = ACTIONS(223),
    [anon_sym_add_DASHfloat] = ACTIONS(223),
    [anon_sym_sub_DASHfloat] = ACTIONS(223),
    [anon_sym_mul_DASHfloat] = ACTIONS(223),
    [anon_sym_div_DASHfloat] = ACTIONS(223),
    [anon_sym_rem_DASHfloat] = ACTIONS(223),
    [anon_sym_add_DASHdouble] = ACTIONS(223),
    [anon_sym_sub_DASHdouble] = ACTIONS(223),
    [anon_sym_mul_DASHdouble] = ACTIONS(223),
    [anon_sym_div_DASHdouble] = ACTIONS(223),
    [anon_sym_rem_DASHdouble] = ACTIONS(223),
    [anon_sym_add_DASHint_SLASH2addr] = ACTIONS(219),
    [anon_sym_sub_DASHint_SLASH2addr] = ACTIONS(219),
    [anon_sym_mul_DASHint_SLASH2addr] = ACTIONS(219),
    [anon_sym_div_DASHint_SLASH2addr] = ACTIONS(219),
    [anon_sym_rem_DASHint_SLASH2addr] = ACTIONS(219),
    [anon_sym_and_DASHint_SLASH2addr] = ACTIONS(219),
    [anon_sym_or_DASHint_SLASH2addr] = ACTIONS(219),
    [anon_sym_xor_DASHint_SLASH2addr] = ACTIONS(219),
    [anon_sym_shl_DASHint_SLASH2addr] = ACTIONS(219),
    [anon_sym_shr_DASHint_SLASH2addr] = ACTIONS(219),
    [anon_sym_ushr_DASHint_SLASH2addr] = ACTIONS(219),
    [anon_sym_add_DASHlong_SLASH2addr] = ACTIONS(219),
    [anon_sym_sub_DASHlong_SLASH2addr] = ACTIONS(219),
    [anon_sym_mul_DASHlong_SLASH2addr] = ACTIONS(219),
    [anon_sym_div_DASHlong_SLASH2addr] = ACTIONS(219),
    [anon_sym_rem_DASHlong_SLASH2addr] = ACTIONS(219),
    [anon_sym_and_DASHlong_SLASH2addr] = ACTIONS(219),
    [anon_sym_or_DASHlong_SLASH2addr] = ACTIONS(219),
    [anon_sym_xor_DASHlong_SLASH2addr] = ACTIONS(219),
    [anon_sym_shl_DASHlong_SLASH2addr] = ACTIONS(219),
    [anon_sym_shr_DASHlong_SLASH2addr] = ACTIONS(219),
    [anon_sym_ushr_DASHlong_SLASH2addr] = ACTIONS(219),
    [anon_sym_add_DASHfloat_SLASH2addr] = ACTIONS(219),
    [anon_sym_sub_DASHfloat_SLASH2addr] = ACTIONS(219),
    [anon_sym_mul_DASHfloat_SLASH2addr] = ACTIONS(219),
    [anon_sym_div_DASHfloat_SLASH2addr] = ACTIONS(219),
    [anon_sym_rem_DASHfloat_SLASH2addr] = ACTIONS(219),
    [anon_sym_add_DASHdouble_SLASH2addr] = ACTIONS(219),
    [anon_sym_sub_DASHdouble_SLASH2addr] = ACTIONS(219),
    [anon_sym_mul_DASHdouble_SLASH2addr] = ACTIONS(219),
    [anon_sym_div_DASHdouble_SLASH2addr] = ACTIONS(219),
    [anon_sym_rem_DASHdouble_SLASH2addr] = ACTIONS(219),
    [anon_sym_add_DASHint_SLASHlit16] = ACTIONS(219),
    [anon_sym_sub_DASHint_SLASHlit16] = ACTIONS(219),
    [anon_sym_mul_DASHint_SLASHlit16] = ACTIONS(219),
    [anon_sym_div_DASHint_SLASHlit16] = ACTIONS(219),
    [anon_sym_rem_DASHint_SLASHlit16] = ACTIONS(219),
    [anon_sym_and_DASHint_SLASHlit16] = ACTIONS(219),
    [anon_sym_or_DASHint_SLASHlit16] = ACTIONS(219),
    [anon_sym_xor_DASHint_SLASHlit16] = ACTIONS(219),
    [anon_sym_add_DASHint_SLASHlit8] = ACTIONS(219),
    [anon_sym_sub_DASHint_SLASHlit8] = ACTIONS(219),
    [anon_sym_mul_DASHint_SLASHlit8] = ACTIONS(219),
    [anon_sym_div_DASHint_SLASHlit8] = ACTIONS(219),
    [anon_sym_rem_DASHint_SLASHlit8] = ACTIONS(219),
    [anon_sym_and_DASHint_SLASHlit8] = ACTIONS(219),
    [anon_sym_or_DASHint_SLASHlit8] = ACTIONS(219),
    [anon_sym_xor_DASHint_SLASHlit8] = ACTIONS(219),
    [anon_sym_shl_DASHint_SLASHlit8] = ACTIONS(219),
    [anon_sym_shr_DASHint_SLASHlit8] = ACTIONS(219),
    [anon_sym_ushr_DASHint_SLASHlit8] = ACTIONS(219),
    [anon_sym_static_DASHget] = ACTIONS(223),
    [anon_sym_static_DASHput] = ACTIONS(223),
    [anon_sym_instance_DASHget] = ACTIONS(223),
    [anon_sym_instance_DASHput] = ACTIONS(223),
    [anon_sym_execute_DASHinline] = ACTIONS(223),
    [anon_sym_execute_DASHinline_SLASHrange] = ACTIONS(219),
    [anon_sym_iget_DASHquick] = ACTIONS(223),
    [anon_sym_iget_DASHwide_DASHquick] = ACTIONS(223),
    [anon_sym_iget_DASHobject_DASHquick] = ACTIONS(223),
    [anon_sym_iput_DASHquick] = ACTIONS(223),
    [anon_sym_iput_DASHwide_DASHquick] = ACTIONS(223),
    [anon_sym_iput_DASHobject_DASHquick] = ACTIONS(223),
    [anon_sym_iput_DASHboolean_DASHquick] = ACTIONS(223),
    [anon_sym_iput_DASHbyte_DASHquick] = ACTIONS(223),
    [anon_sym_iput_DASHchar_DASHquick] = ACTIONS(223),
    [anon_sym_iput_DASHshort_DASHquick] = ACTIONS(223),
    [anon_sym_invoke_DASHvirtual_DASHquick] = ACTIONS(223),
    [anon_sym_invoke_DASHvirtual_DASHquick_SLASHrange] = ACTIONS(219),
    [anon_sym_invoke_DASHsuper_DASHquick] = ACTIONS(223),
    [anon_sym_invoke_DASHsuper_DASHquick_SLASHrange] = ACTIONS(219),
    [anon_sym_rsub_DASHint] = ACTIONS(223),
    [anon_sym_rsub_DASHint_SLASHlit8] = ACTIONS(219),
    [anon_sym_DOTline] = ACTIONS(219),
    [anon_sym_DOTlocals] = ACTIONS(219),
    [anon_sym_DOTlocal] = ACTIONS(223),
    [anon_sym_DOTendlocal] = ACTIONS(219),
    [anon_sym_DOTrestartlocal] = ACTIONS(219),
    [anon_sym_DOTregisters] = ACTIONS(219),
    [anon_sym_DOTcatch] = ACTIONS(223),
    [anon_sym_DOTcatchall] = ACTIONS(219),
    [anon_sym_DOTpacked_DASHswitch] = ACTIONS(219),
    [anon_sym_DOTsparse_DASHswitch] = ACTIONS(219),
    [anon_sym_DOTarray_DASHdata] = ACTIONS(219),
    [sym_prologue_directive] = ACTIONS(219),
    [sym_epilogue_directive] = ACTIONS(219),
    [aux_sym_label_token1] = ACTIONS(219),
    [aux_sym_jmp_label_token1] = ACTIONS(223),
    [sym_number] = ACTIONS(75),
    [sym_float] = ACTIONS(75),
    [sym_NaN] = ACTIONS(77),
    [sym_Infinity] = ACTIONS(77),
    [anon_sym_DQUOTE] = ACTIONS(79),
    [anon_sym_true] = ACTIONS(81),
    [anon_sym_false] = ACTIONS(81),
    [anon_sym_SQUOTE] = ACTIONS(83),
    [sym_null] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
  },
  [16] = {
    [sym_annotation_directive] = STATE(201),
    [sym_literal] = STATE(39),
    [sym_string] = STATE(25),
    [sym_boolean] = STATE(25),
    [sym_character] = STATE(25),
    [aux_sym_field_definition_repeat1] = STATE(201),
    [anon_sym_DOTsource] = ACTIONS(229),
    [anon_sym_DOTendmethod] = ACTIONS(229),
    [anon_sym_DOTannotation] = ACTIONS(115),
    [anon_sym_DOTparam] = ACTIONS(231),
    [anon_sym_DOTparameter] = ACTIONS(229),
    [anon_sym_DOTendparameter] = ACTIONS(233),
    [anon_sym_nop] = ACTIONS(231),
    [anon_sym_move] = ACTIONS(231),
    [anon_sym_move_SLASHfrom16] = ACTIONS(229),
    [anon_sym_move_SLASH16] = ACTIONS(229),
    [anon_sym_move_DASHwide] = ACTIONS(231),
    [anon_sym_move_DASHwide_SLASHfrom16] = ACTIONS(229),
    [anon_sym_move_DASHwide_SLASH16] = ACTIONS(229),
    [anon_sym_move_DASHobject] = ACTIONS(231),
    [anon_sym_move_DASHobject_SLASHfrom16] = ACTIONS(229),
    [anon_sym_move_DASHobject_SLASH16] = ACTIONS(229),
    [anon_sym_move_DASHresult] = ACTIONS(231),
    [anon_sym_move_DASHresult_DASHwide] = ACTIONS(229),
    [anon_sym_move_DASHresult_DASHobject] = ACTIONS(229),
    [anon_sym_move_DASHexception] = ACTIONS(229),
    [anon_sym_return_DASHvoid] = ACTIONS(229),
    [anon_sym_return] = ACTIONS(231),
    [anon_sym_return_DASHwide] = ACTIONS(229),
    [anon_sym_return_DASHobject] = ACTIONS(229),
    [anon_sym_const_SLASH4] = ACTIONS(229),
    [anon_sym_const_SLASH16] = ACTIONS(229),
    [anon_sym_const] = ACTIONS(231),
    [anon_sym_const_SLASHhigh16] = ACTIONS(229),
    [anon_sym_const_DASHwide_SLASH16] = ACTIONS(229),
    [anon_sym_const_DASHwide_SLASH32] = ACTIONS(229),
    [anon_sym_const_DASHwide] = ACTIONS(231),
    [anon_sym_const_DASHwide_SLASHhigh16] = ACTIONS(229),
    [anon_sym_const_DASHstring] = ACTIONS(231),
    [anon_sym_const_DASHstring_SLASHjumbo] = ACTIONS(229),
    [anon_sym_const_DASHclass] = ACTIONS(229),
    [anon_sym_const_DASHmethod_DASHhandle] = ACTIONS(229),
    [anon_sym_const_DASHmethod_DASHtype] = ACTIONS(229),
    [anon_sym_monitor_DASHenter] = ACTIONS(229),
    [anon_sym_monitor_DASHexit] = ACTIONS(229),
    [anon_sym_check_DASHcast] = ACTIONS(229),
    [anon_sym_instance_DASHof] = ACTIONS(229),
    [anon_sym_array_DASHlength] = ACTIONS(229),
    [anon_sym_new_DASHinstance] = ACTIONS(229),
    [anon_sym_new_DASHarray] = ACTIONS(229),
    [anon_sym_filled_DASHnew_DASHarray] = ACTIONS(231),
    [anon_sym_filled_DASHnew_DASHarray_SLASHrange] = ACTIONS(229),
    [anon_sym_fill_DASHarray_DASHdata] = ACTIONS(229),
    [anon_sym_throw] = ACTIONS(231),
    [anon_sym_throw_DASHverification_DASHerror] = ACTIONS(229),
    [anon_sym_goto] = ACTIONS(231),
    [anon_sym_goto_SLASH16] = ACTIONS(229),
    [anon_sym_goto_SLASH32] = ACTIONS(229),
    [anon_sym_packed_DASHswitch] = ACTIONS(229),
    [anon_sym_sparse_DASHswitch] = ACTIONS(229),
    [anon_sym_cmpl_DASHfloat] = ACTIONS(229),
    [anon_sym_cmpg_DASHfloat] = ACTIONS(229),
    [anon_sym_cmpl_DASHdouble] = ACTIONS(229),
    [anon_sym_cmpg_DASHdouble] = ACTIONS(229),
    [anon_sym_cmp_DASHlong] = ACTIONS(229),
    [anon_sym_if_DASHeq] = ACTIONS(231),
    [anon_sym_if_DASHne] = ACTIONS(231),
    [anon_sym_if_DASHlt] = ACTIONS(231),
    [anon_sym_if_DASHge] = ACTIONS(231),
    [anon_sym_if_DASHgt] = ACTIONS(231),
    [anon_sym_if_DASHle] = ACTIONS(231),
    [anon_sym_if_DASHeqz] = ACTIONS(229),
    [anon_sym_if_DASHnez] = ACTIONS(229),
    [anon_sym_if_DASHltz] = ACTIONS(229),
    [anon_sym_if_DASHgez] = ACTIONS(229),
    [anon_sym_if_DASHgtz] = ACTIONS(229),
    [anon_sym_if_DASHlez] = ACTIONS(229),
    [anon_sym_aget] = ACTIONS(231),
    [anon_sym_aget_DASHwide] = ACTIONS(229),
    [anon_sym_aget_DASHobject] = ACTIONS(229),
    [anon_sym_aget_DASHboolean] = ACTIONS(229),
    [anon_sym_aget_DASHbyte] = ACTIONS(229),
    [anon_sym_aget_DASHchar] = ACTIONS(229),
    [anon_sym_aget_DASHshort] = ACTIONS(229),
    [anon_sym_aput] = ACTIONS(231),
    [anon_sym_aput_DASHwide] = ACTIONS(229),
    [anon_sym_aput_DASHobject] = ACTIONS(229),
    [anon_sym_aput_DASHboolean] = ACTIONS(229),
    [anon_sym_aput_DASHbyte] = ACTIONS(229),
    [anon_sym_aput_DASHchar] = ACTIONS(229),
    [anon_sym_aput_DASHshort] = ACTIONS(229),
    [anon_sym_iget] = ACTIONS(231),
    [anon_sym_iget_DASHwide] = ACTIONS(231),
    [anon_sym_iget_DASHobject] = ACTIONS(231),
    [anon_sym_iget_DASHboolean] = ACTIONS(229),
    [anon_sym_iget_DASHbyte] = ACTIONS(229),
    [anon_sym_iget_DASHchar] = ACTIONS(229),
    [anon_sym_iget_DASHshort] = ACTIONS(229),
    [anon_sym_iget_DASHvolatile] = ACTIONS(229),
    [anon_sym_iget_DASHwide_DASHvolatile] = ACTIONS(229),
    [anon_sym_iget_DASHobject_DASHvolatile] = ACTIONS(229),
    [anon_sym_iput] = ACTIONS(231),
    [anon_sym_iput_DASHwide] = ACTIONS(231),
    [anon_sym_iput_DASHobject] = ACTIONS(231),
    [anon_sym_iput_DASHboolean] = ACTIONS(231),
    [anon_sym_iput_DASHbyte] = ACTIONS(231),
    [anon_sym_iput_DASHchar] = ACTIONS(231),
    [anon_sym_iput_DASHshort] = ACTIONS(231),
    [anon_sym_iput_DASHvolatile] = ACTIONS(229),
    [anon_sym_iput_DASHwide_DASHvolatile] = ACTIONS(229),
    [anon_sym_iput_DASHobject_DASHvolatile] = ACTIONS(229),
    [anon_sym_sget] = ACTIONS(231),
    [anon_sym_sget_DASHwide] = ACTIONS(231),
    [anon_sym_sget_DASHobject] = ACTIONS(231),
    [anon_sym_sget_DASHboolean] = ACTIONS(229),
    [anon_sym_sget_DASHbyte] = ACTIONS(229),
    [anon_sym_sget_DASHchar] = ACTIONS(229),
    [anon_sym_sget_DASHshort] = ACTIONS(229),
    [anon_sym_sget_DASHvolatile] = ACTIONS(229),
    [anon_sym_sget_DASHwide_DASHvolatile] = ACTIONS(229),
    [anon_sym_sget_DASHobject_DASHvolatile] = ACTIONS(229),
    [anon_sym_sput] = ACTIONS(231),
    [anon_sym_sput_DASHwide] = ACTIONS(231),
    [anon_sym_sput_DASHobject] = ACTIONS(231),
    [anon_sym_sput_DASHboolean] = ACTIONS(229),
    [anon_sym_sput_DASHbyte] = ACTIONS(229),
    [anon_sym_sput_DASHchar] = ACTIONS(229),
    [anon_sym_sput_DASHshort] = ACTIONS(229),
    [anon_sym_sput_DASHvolatile] = ACTIONS(229),
    [anon_sym_sput_DASHwide_DASHvolatile] = ACTIONS(229),
    [anon_sym_sput_DASHobject_DASHvolatile] = ACTIONS(229),
    [anon_sym_invoke_DASHconstructor] = ACTIONS(229),
    [anon_sym_invoke_DASHcustom] = ACTIONS(231),
    [anon_sym_invoke_DASHdirect] = ACTIONS(231),
    [anon_sym_invoke_DASHdirect_DASHempty] = ACTIONS(229),
    [anon_sym_invoke_DASHinstance] = ACTIONS(229),
    [anon_sym_invoke_DASHinterface] = ACTIONS(231),
    [anon_sym_invoke_DASHpolymorphic] = ACTIONS(231),
    [anon_sym_invoke_DASHstatic] = ACTIONS(231),
    [anon_sym_invoke_DASHsuper] = ACTIONS(231),
    [anon_sym_invoke_DASHvirtual] = ACTIONS(231),
    [anon_sym_invoke_DASHcustom_SLASHrange] = ACTIONS(229),
    [anon_sym_invoke_DASHdirect_SLASHrange] = ACTIONS(229),
    [anon_sym_invoke_DASHinterface_SLASHrange] = ACTIONS(229),
    [anon_sym_invoke_DASHobject_DASHinit_SLASHrange] = ACTIONS(229),
    [anon_sym_invoke_DASHpolymorphic_SLASHrange] = ACTIONS(229),
    [anon_sym_invoke_DASHstatic_SLASHrange] = ACTIONS(229),
    [anon_sym_invoke_DASHsuper_SLASHrange] = ACTIONS(229),
    [anon_sym_invoke_DASHvirtual_SLASHrange] = ACTIONS(229),
    [anon_sym_neg_DASHint] = ACTIONS(229),
    [anon_sym_not_DASHint] = ACTIONS(229),
    [anon_sym_neg_DASHlong] = ACTIONS(229),
    [anon_sym_not_DASHlong] = ACTIONS(229),
    [anon_sym_neg_DASHfloat] = ACTIONS(229),
    [anon_sym_neg_DASHdouble] = ACTIONS(229),
    [anon_sym_int_DASHto_DASHlong] = ACTIONS(229),
    [anon_sym_int_DASHto_DASHfloat] = ACTIONS(229),
    [anon_sym_int_DASHto_DASHdouble] = ACTIONS(229),
    [anon_sym_long_DASHto_DASHint] = ACTIONS(229),
    [anon_sym_long_DASHto_DASHfloat] = ACTIONS(229),
    [anon_sym_long_DASHto_DASHdouble] = ACTIONS(229),
    [anon_sym_float_DASHto_DASHint] = ACTIONS(229),
    [anon_sym_float_DASHto_DASHlong] = ACTIONS(229),
    [anon_sym_float_DASHto_DASHdouble] = ACTIONS(229),
    [anon_sym_double_DASHto_DASHint] = ACTIONS(229),
    [anon_sym_double_DASHto_DASHlong] = ACTIONS(229),
    [anon_sym_double_DASHto_DASHfloat] = ACTIONS(229),
    [anon_sym_int_DASHto_DASHbyte] = ACTIONS(229),
    [anon_sym_int_DASHto_DASHchar] = ACTIONS(229),
    [anon_sym_int_DASHto_DASHshort] = ACTIONS(229),
    [anon_sym_add_DASHint] = ACTIONS(231),
    [anon_sym_sub_DASHint] = ACTIONS(231),
    [anon_sym_mul_DASHint] = ACTIONS(231),
    [anon_sym_div_DASHint] = ACTIONS(231),
    [anon_sym_rem_DASHint] = ACTIONS(231),
    [anon_sym_and_DASHint] = ACTIONS(231),
    [anon_sym_or_DASHint] = ACTIONS(231),
    [anon_sym_xor_DASHint] = ACTIONS(231),
    [anon_sym_shl_DASHint] = ACTIONS(231),
    [anon_sym_shr_DASHint] = ACTIONS(231),
    [anon_sym_ushr_DASHint] = ACTIONS(231),
    [anon_sym_add_DASHlong] = ACTIONS(231),
    [anon_sym_sub_DASHlong] = ACTIONS(231),
    [anon_sym_mul_DASHlong] = ACTIONS(231),
    [anon_sym_div_DASHlong] = ACTIONS(231),
    [anon_sym_rem_DASHlong] = ACTIONS(231),
    [anon_sym_and_DASHlong] = ACTIONS(231),
    [anon_sym_or_DASHlong] = ACTIONS(231),
    [anon_sym_xor_DASHlong] = ACTIONS(231),
    [anon_sym_shl_DASHlong] = ACTIONS(231),
    [anon_sym_shr_DASHlong] = ACTIONS(231),
    [anon_sym_ushr_DASHlong] = ACTIONS(231),
    [anon_sym_add_DASHfloat] = ACTIONS(231),
    [anon_sym_sub_DASHfloat] = ACTIONS(231),
    [anon_sym_mul_DASHfloat] = ACTIONS(231),
    [anon_sym_div_DASHfloat] = ACTIONS(231),
    [anon_sym_rem_DASHfloat] = ACTIONS(231),
    [anon_sym_add_DASHdouble] = ACTIONS(231),
    [anon_sym_sub_DASHdouble] = ACTIONS(231),
    [anon_sym_mul_DASHdouble] = ACTIONS(231),
    [anon_sym_div_DASHdouble] = ACTIONS(231),
    [anon_sym_rem_DASHdouble] = ACTIONS(231),
    [anon_sym_add_DASHint_SLASH2addr] = ACTIONS(229),
    [anon_sym_sub_DASHint_SLASH2addr] = ACTIONS(229),
    [anon_sym_mul_DASHint_SLASH2addr] = ACTIONS(229),
    [anon_sym_div_DASHint_SLASH2addr] = ACTIONS(229),
    [anon_sym_rem_DASHint_SLASH2addr] = ACTIONS(229),
    [anon_sym_and_DASHint_SLASH2addr] = ACTIONS(229),
    [anon_sym_or_DASHint_SLASH2addr] = ACTIONS(229),
    [anon_sym_xor_DASHint_SLASH2addr] = ACTIONS(229),
    [anon_sym_shl_DASHint_SLASH2addr] = ACTIONS(229),
    [anon_sym_shr_DASHint_SLASH2addr] = ACTIONS(229),
    [anon_sym_ushr_DASHint_SLASH2addr] = ACTIONS(229),
    [anon_sym_add_DASHlong_SLASH2addr] = ACTIONS(229),
    [anon_sym_sub_DASHlong_SLASH2addr] = ACTIONS(229),
    [anon_sym_mul_DASHlong_SLASH2addr] = ACTIONS(229),
    [anon_sym_div_DASHlong_SLASH2addr] = ACTIONS(229),
    [anon_sym_rem_DASHlong_SLASH2addr] = ACTIONS(229),
    [anon_sym_and_DASHlong_SLASH2addr] = ACTIONS(229),
    [anon_sym_or_DASHlong_SLASH2addr] = ACTIONS(229),
    [anon_sym_xor_DASHlong_SLASH2addr] = ACTIONS(229),
    [anon_sym_shl_DASHlong_SLASH2addr] = ACTIONS(229),
    [anon_sym_shr_DASHlong_SLASH2addr] = ACTIONS(229),
    [anon_sym_ushr_DASHlong_SLASH2addr] = ACTIONS(229),
    [anon_sym_add_DASHfloat_SLASH2addr] = ACTIONS(229),
    [anon_sym_sub_DASHfloat_SLASH2addr] = ACTIONS(229),
    [anon_sym_mul_DASHfloat_SLASH2addr] = ACTIONS(229),
    [anon_sym_div_DASHfloat_SLASH2addr] = ACTIONS(229),
    [anon_sym_rem_DASHfloat_SLASH2addr] = ACTIONS(229),
    [anon_sym_add_DASHdouble_SLASH2addr] = ACTIONS(229),
    [anon_sym_sub_DASHdouble_SLASH2addr] = ACTIONS(229),
    [anon_sym_mul_DASHdouble_SLASH2addr] = ACTIONS(229),
    [anon_sym_div_DASHdouble_SLASH2addr] = ACTIONS(229),
    [anon_sym_rem_DASHdouble_SLASH2addr] = ACTIONS(229),
    [anon_sym_add_DASHint_SLASHlit16] = ACTIONS(229),
    [anon_sym_sub_DASHint_SLASHlit16] = ACTIONS(229),
    [anon_sym_mul_DASHint_SLASHlit16] = ACTIONS(229),
    [anon_sym_div_DASHint_SLASHlit16] = ACTIONS(229),
    [anon_sym_rem_DASHint_SLASHlit16] = ACTIONS(229),
    [anon_sym_and_DASHint_SLASHlit16] = ACTIONS(229),
    [anon_sym_or_DASHint_SLASHlit16] = ACTIONS(229),
    [anon_sym_xor_DASHint_SLASHlit16] = ACTIONS(229),
    [anon_sym_add_DASHint_SLASHlit8] = ACTIONS(229),
    [anon_sym_sub_DASHint_SLASHlit8] = ACTIONS(229),
    [anon_sym_mul_DASHint_SLASHlit8] = ACTIONS(229),
    [anon_sym_div_DASHint_SLASHlit8] = ACTIONS(229),
    [anon_sym_rem_DASHint_SLASHlit8] = ACTIONS(229),
    [anon_sym_and_DASHint_SLASHlit8] = ACTIONS(229),
    [anon_sym_or_DASHint_SLASHlit8] = ACTIONS(229),
    [anon_sym_xor_DASHint_SLASHlit8] = ACTIONS(229),
    [anon_sym_shl_DASHint_SLASHlit8] = ACTIONS(229),
    [anon_sym_shr_DASHint_SLASHlit8] = ACTIONS(229),
    [anon_sym_ushr_DASHint_SLASHlit8] = ACTIONS(229),
    [anon_sym_static_DASHget] = ACTIONS(229),
    [anon_sym_static_DASHput] = ACTIONS(229),
    [anon_sym_instance_DASHget] = ACTIONS(229),
    [anon_sym_instance_DASHput] = ACTIONS(229),
    [anon_sym_execute_DASHinline] = ACTIONS(231),
    [anon_sym_execute_DASHinline_SLASHrange] = ACTIONS(229),
    [anon_sym_iget_DASHquick] = ACTIONS(229),
    [anon_sym_iget_DASHwide_DASHquick] = ACTIONS(229),
    [anon_sym_iget_DASHobject_DASHquick] = ACTIONS(229),
    [anon_sym_iput_DASHquick] = ACTIONS(229),
    [anon_sym_iput_DASHwide_DASHquick] = ACTIONS(229),
    [anon_sym_iput_DASHobject_DASHquick] = ACTIONS(229),
    [anon_sym_iput_DASHboolean_DASHquick] = ACTIONS(229),
    [anon_sym_iput_DASHbyte_DASHquick] = ACTIONS(229),
    [anon_sym_iput_DASHchar_DASHquick] = ACTIONS(229),
    [anon_sym_iput_DASHshort_DASHquick] = ACTIONS(229),
    [anon_sym_invoke_DASHvirtual_DASHquick] = ACTIONS(231),
    [anon_sym_invoke_DASHvirtual_DASHquick_SLASHrange] = ACTIONS(229),
    [anon_sym_invoke_DASHsuper_DASHquick] = ACTIONS(231),
    [anon_sym_invoke_DASHsuper_DASHquick_SLASHrange] = ACTIONS(229),
    [anon_sym_rsub_DASHint] = ACTIONS(231),
    [anon_sym_rsub_DASHint_SLASHlit8] = ACTIONS(229),
    [anon_sym_DOTline] = ACTIONS(229),
    [anon_sym_DOTlocals] = ACTIONS(229),
    [anon_sym_DOTlocal] = ACTIONS(231),
    [anon_sym_DOTendlocal] = ACTIONS(229),
    [anon_sym_DOTrestartlocal] = ACTIONS(229),
    [anon_sym_DOTregisters] = ACTIONS(229),
    [anon_sym_DOTcatch] = ACTIONS(231),
    [anon_sym_DOTcatchall] = ACTIONS(229),
    [anon_sym_DOTpacked_DASHswitch] = ACTIONS(229),
    [anon_sym_DOTsparse_DASHswitch] = ACTIONS(229),
    [anon_sym_DOTarray_DASHdata] = ACTIONS(229),
    [sym_prologue_directive] = ACTIONS(229),
    [sym_epilogue_directive] = ACTIONS(229),
    [aux_sym_label_token1] = ACTIONS(229),
    [aux_sym_jmp_label_token1] = ACTIONS(231),
    [sym_number] = ACTIONS(75),
    [sym_float] = ACTIONS(75),
    [sym_NaN] = ACTIONS(77),
    [sym_Infinity] = ACTIONS(77),
    [anon_sym_DQUOTE] = ACTIONS(79),
    [anon_sym_true] = ACTIONS(81),
    [anon_sym_false] = ACTIONS(81),
    [anon_sym_SQUOTE] = ACTIONS(83),
    [sym_null] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
  },
  [17] = {
    [ts_builtin_sym_end] = ACTIONS(235),
    [anon_sym_DOTsource] = ACTIONS(235),
    [anon_sym_DOTfield] = ACTIONS(235),
    [anon_sym_EQ] = ACTIONS(235),
    [anon_sym_DOTendfield] = ACTIONS(235),
    [anon_sym_DOTmethod] = ACTIONS(235),
    [anon_sym_DOTendmethod] = ACTIONS(235),
    [anon_sym_DOTannotation] = ACTIONS(235),
    [anon_sym_DOTparam] = ACTIONS(237),
    [anon_sym_COMMA] = ACTIONS(235),
    [anon_sym_DOTparameter] = ACTIONS(235),
    [anon_sym_nop] = ACTIONS(237),
    [anon_sym_move] = ACTIONS(237),
    [anon_sym_move_SLASHfrom16] = ACTIONS(235),
    [anon_sym_move_SLASH16] = ACTIONS(235),
    [anon_sym_move_DASHwide] = ACTIONS(237),
    [anon_sym_move_DASHwide_SLASHfrom16] = ACTIONS(235),
    [anon_sym_move_DASHwide_SLASH16] = ACTIONS(235),
    [anon_sym_move_DASHobject] = ACTIONS(237),
    [anon_sym_move_DASHobject_SLASHfrom16] = ACTIONS(235),
    [anon_sym_move_DASHobject_SLASH16] = ACTIONS(235),
    [anon_sym_move_DASHresult] = ACTIONS(237),
    [anon_sym_move_DASHresult_DASHwide] = ACTIONS(235),
    [anon_sym_move_DASHresult_DASHobject] = ACTIONS(235),
    [anon_sym_move_DASHexception] = ACTIONS(235),
    [anon_sym_return_DASHvoid] = ACTIONS(235),
    [anon_sym_return] = ACTIONS(237),
    [anon_sym_return_DASHwide] = ACTIONS(235),
    [anon_sym_return_DASHobject] = ACTIONS(235),
    [anon_sym_const_SLASH4] = ACTIONS(235),
    [anon_sym_const_SLASH16] = ACTIONS(235),
    [anon_sym_const] = ACTIONS(237),
    [anon_sym_const_SLASHhigh16] = ACTIONS(235),
    [anon_sym_const_DASHwide_SLASH16] = ACTIONS(235),
    [anon_sym_const_DASHwide_SLASH32] = ACTIONS(235),
    [anon_sym_const_DASHwide] = ACTIONS(237),
    [anon_sym_const_DASHwide_SLASHhigh16] = ACTIONS(235),
    [anon_sym_const_DASHstring] = ACTIONS(237),
    [anon_sym_const_DASHstring_SLASHjumbo] = ACTIONS(235),
    [anon_sym_const_DASHclass] = ACTIONS(235),
    [anon_sym_const_DASHmethod_DASHhandle] = ACTIONS(235),
    [anon_sym_const_DASHmethod_DASHtype] = ACTIONS(235),
    [anon_sym_monitor_DASHenter] = ACTIONS(235),
    [anon_sym_monitor_DASHexit] = ACTIONS(235),
    [anon_sym_check_DASHcast] = ACTIONS(235),
    [anon_sym_instance_DASHof] = ACTIONS(235),
    [anon_sym_array_DASHlength] = ACTIONS(235),
    [anon_sym_new_DASHinstance] = ACTIONS(235),
    [anon_sym_new_DASHarray] = ACTIONS(235),
    [anon_sym_filled_DASHnew_DASHarray] = ACTIONS(237),
    [anon_sym_filled_DASHnew_DASHarray_SLASHrange] = ACTIONS(235),
    [anon_sym_fill_DASHarray_DASHdata] = ACTIONS(235),
    [anon_sym_throw] = ACTIONS(237),
    [anon_sym_throw_DASHverification_DASHerror] = ACTIONS(235),
    [anon_sym_goto] = ACTIONS(237),
    [anon_sym_goto_SLASH16] = ACTIONS(235),
    [anon_sym_goto_SLASH32] = ACTIONS(235),
    [anon_sym_packed_DASHswitch] = ACTIONS(235),
    [anon_sym_sparse_DASHswitch] = ACTIONS(235),
    [anon_sym_cmpl_DASHfloat] = ACTIONS(235),
    [anon_sym_cmpg_DASHfloat] = ACTIONS(235),
    [anon_sym_cmpl_DASHdouble] = ACTIONS(235),
    [anon_sym_cmpg_DASHdouble] = ACTIONS(235),
    [anon_sym_cmp_DASHlong] = ACTIONS(235),
    [anon_sym_if_DASHeq] = ACTIONS(237),
    [anon_sym_if_DASHne] = ACTIONS(237),
    [anon_sym_if_DASHlt] = ACTIONS(237),
    [anon_sym_if_DASHge] = ACTIONS(237),
    [anon_sym_if_DASHgt] = ACTIONS(237),
    [anon_sym_if_DASHle] = ACTIONS(237),
    [anon_sym_if_DASHeqz] = ACTIONS(235),
    [anon_sym_if_DASHnez] = ACTIONS(235),
    [anon_sym_if_DASHltz] = ACTIONS(235),
    [anon_sym_if_DASHgez] = ACTIONS(235),
    [anon_sym_if_DASHgtz] = ACTIONS(235),
    [anon_sym_if_DASHlez] = ACTIONS(235),
    [anon_sym_aget] = ACTIONS(237),
    [anon_sym_aget_DASHwide] = ACTIONS(235),
    [anon_sym_aget_DASHobject] = ACTIONS(235),
    [anon_sym_aget_DASHboolean] = ACTIONS(235),
    [anon_sym_aget_DASHbyte] = ACTIONS(235),
    [anon_sym_aget_DASHchar] = ACTIONS(235),
    [anon_sym_aget_DASHshort] = ACTIONS(235),
    [anon_sym_aput] = ACTIONS(237),
    [anon_sym_aput_DASHwide] = ACTIONS(235),
    [anon_sym_aput_DASHobject] = ACTIONS(235),
    [anon_sym_aput_DASHboolean] = ACTIONS(235),
    [anon_sym_aput_DASHbyte] = ACTIONS(235),
    [anon_sym_aput_DASHchar] = ACTIONS(235),
    [anon_sym_aput_DASHshort] = ACTIONS(235),
    [anon_sym_iget] = ACTIONS(237),
    [anon_sym_iget_DASHwide] = ACTIONS(237),
    [anon_sym_iget_DASHobject] = ACTIONS(237),
    [anon_sym_iget_DASHboolean] = ACTIONS(235),
    [anon_sym_iget_DASHbyte] = ACTIONS(235),
    [anon_sym_iget_DASHchar] = ACTIONS(235),
    [anon_sym_iget_DASHshort] = ACTIONS(235),
    [anon_sym_iget_DASHvolatile] = ACTIONS(235),
    [anon_sym_iget_DASHwide_DASHvolatile] = ACTIONS(235),
    [anon_sym_iget_DASHobject_DASHvolatile] = ACTIONS(235),
    [anon_sym_iput] = ACTIONS(237),
    [anon_sym_iput_DASHwide] = ACTIONS(237),
    [anon_sym_iput_DASHobject] = ACTIONS(237),
    [anon_sym_iput_DASHboolean] = ACTIONS(237),
    [anon_sym_iput_DASHbyte] = ACTIONS(237),
    [anon_sym_iput_DASHchar] = ACTIONS(237),
    [anon_sym_iput_DASHshort] = ACTIONS(237),
    [anon_sym_iput_DASHvolatile] = ACTIONS(235),
    [anon_sym_iput_DASHwide_DASHvolatile] = ACTIONS(235),
    [anon_sym_iput_DASHobject_DASHvolatile] = ACTIONS(235),
    [anon_sym_sget] = ACTIONS(237),
    [anon_sym_sget_DASHwide] = ACTIONS(237),
    [anon_sym_sget_DASHobject] = ACTIONS(237),
    [anon_sym_sget_DASHboolean] = ACTIONS(235),
    [anon_sym_sget_DASHbyte] = ACTIONS(235),
    [anon_sym_sget_DASHchar] = ACTIONS(235),
    [anon_sym_sget_DASHshort] = ACTIONS(235),
    [anon_sym_sget_DASHvolatile] = ACTIONS(235),
    [anon_sym_sget_DASHwide_DASHvolatile] = ACTIONS(235),
    [anon_sym_sget_DASHobject_DASHvolatile] = ACTIONS(235),
    [anon_sym_sput] = ACTIONS(237),
    [anon_sym_sput_DASHwide] = ACTIONS(237),
    [anon_sym_sput_DASHobject] = ACTIONS(237),
    [anon_sym_sput_DASHboolean] = ACTIONS(235),
    [anon_sym_sput_DASHbyte] = ACTIONS(235),
    [anon_sym_sput_DASHchar] = ACTIONS(235),
    [anon_sym_sput_DASHshort] = ACTIONS(235),
    [anon_sym_sput_DASHvolatile] = ACTIONS(235),
    [anon_sym_sput_DASHwide_DASHvolatile] = ACTIONS(235),
    [anon_sym_sput_DASHobject_DASHvolatile] = ACTIONS(235),
    [anon_sym_invoke_DASHconstructor] = ACTIONS(235),
    [anon_sym_invoke_DASHcustom] = ACTIONS(237),
    [anon_sym_invoke_DASHdirect] = ACTIONS(237),
    [anon_sym_invoke_DASHdirect_DASHempty] = ACTIONS(235),
    [anon_sym_invoke_DASHinstance] = ACTIONS(235),
    [anon_sym_invoke_DASHinterface] = ACTIONS(237),
    [anon_sym_invoke_DASHpolymorphic] = ACTIONS(237),
    [anon_sym_invoke_DASHstatic] = ACTIONS(237),
    [anon_sym_invoke_DASHsuper] = ACTIONS(237),
    [anon_sym_invoke_DASHvirtual] = ACTIONS(237),
    [anon_sym_invoke_DASHcustom_SLASHrange] = ACTIONS(235),
    [anon_sym_invoke_DASHdirect_SLASHrange] = ACTIONS(235),
    [anon_sym_invoke_DASHinterface_SLASHrange] = ACTIONS(235),
    [anon_sym_invoke_DASHobject_DASHinit_SLASHrange] = ACTIONS(235),
    [anon_sym_invoke_DASHpolymorphic_SLASHrange] = ACTIONS(235),
    [anon_sym_invoke_DASHstatic_SLASHrange] = ACTIONS(235),
    [anon_sym_invoke_DASHsuper_SLASHrange] = ACTIONS(235),
    [anon_sym_invoke_DASHvirtual_SLASHrange] = ACTIONS(235),
    [anon_sym_neg_DASHint] = ACTIONS(235),
    [anon_sym_not_DASHint] = ACTIONS(235),
    [anon_sym_neg_DASHlong] = ACTIONS(235),
    [anon_sym_not_DASHlong] = ACTIONS(235),
    [anon_sym_neg_DASHfloat] = ACTIONS(235),
    [anon_sym_neg_DASHdouble] = ACTIONS(235),
    [anon_sym_int_DASHto_DASHlong] = ACTIONS(235),
    [anon_sym_int_DASHto_DASHfloat] = ACTIONS(235),
    [anon_sym_int_DASHto_DASHdouble] = ACTIONS(235),
    [anon_sym_long_DASHto_DASHint] = ACTIONS(235),
    [anon_sym_long_DASHto_DASHfloat] = ACTIONS(235),
    [anon_sym_long_DASHto_DASHdouble] = ACTIONS(235),
    [anon_sym_float_DASHto_DASHint] = ACTIONS(235),
    [anon_sym_float_DASHto_DASHlong] = ACTIONS(235),
    [anon_sym_float_DASHto_DASHdouble] = ACTIONS(235),
    [anon_sym_double_DASHto_DASHint] = ACTIONS(235),
    [anon_sym_double_DASHto_DASHlong] = ACTIONS(235),
    [anon_sym_double_DASHto_DASHfloat] = ACTIONS(235),
    [anon_sym_int_DASHto_DASHbyte] = ACTIONS(235),
    [anon_sym_int_DASHto_DASHchar] = ACTIONS(235),
    [anon_sym_int_DASHto_DASHshort] = ACTIONS(235),
    [anon_sym_add_DASHint] = ACTIONS(237),
    [anon_sym_sub_DASHint] = ACTIONS(237),
    [anon_sym_mul_DASHint] = ACTIONS(237),
    [anon_sym_div_DASHint] = ACTIONS(237),
    [anon_sym_rem_DASHint] = ACTIONS(237),
    [anon_sym_and_DASHint] = ACTIONS(237),
    [anon_sym_or_DASHint] = ACTIONS(237),
    [anon_sym_xor_DASHint] = ACTIONS(237),
    [anon_sym_shl_DASHint] = ACTIONS(237),
    [anon_sym_shr_DASHint] = ACTIONS(237),
    [anon_sym_ushr_DASHint] = ACTIONS(237),
    [anon_sym_add_DASHlong] = ACTIONS(237),
    [anon_sym_sub_DASHlong] = ACTIONS(237),
    [anon_sym_mul_DASHlong] = ACTIONS(237),
    [anon_sym_div_DASHlong] = ACTIONS(237),
    [anon_sym_rem_DASHlong] = ACTIONS(237),
    [anon_sym_and_DASHlong] = ACTIONS(237),
    [anon_sym_or_DASHlong] = ACTIONS(237),
    [anon_sym_xor_DASHlong] = ACTIONS(237),
    [anon_sym_shl_DASHlong] = ACTIONS(237),
    [anon_sym_shr_DASHlong] = ACTIONS(237),
    [anon_sym_ushr_DASHlong] = ACTIONS(237),
    [anon_sym_add_DASHfloat] = ACTIONS(237),
    [anon_sym_sub_DASHfloat] = ACTIONS(237),
    [anon_sym_mul_DASHfloat] = ACTIONS(237),
    [anon_sym_div_DASHfloat] = ACTIONS(237),
    [anon_sym_rem_DASHfloat] = ACTIONS(237),
    [anon_sym_add_DASHdouble] = ACTIONS(237),
    [anon_sym_sub_DASHdouble] = ACTIONS(237),
    [anon_sym_mul_DASHdouble] = ACTIONS(237),
    [anon_sym_div_DASHdouble] = ACTIONS(237),
    [anon_sym_rem_DASHdouble] = ACTIONS(237),
    [anon_sym_add_DASHint_SLASH2addr] = ACTIONS(235),
    [anon_sym_sub_DASHint_SLASH2addr] = ACTIONS(235),
    [anon_sym_mul_DASHint_SLASH2addr] = ACTIONS(235),
    [anon_sym_div_DASHint_SLASH2addr] = ACTIONS(235),
    [anon_sym_rem_DASHint_SLASH2addr] = ACTIONS(235),
    [anon_sym_and_DASHint_SLASH2addr] = ACTIONS(235),
    [anon_sym_or_DASHint_SLASH2addr] = ACTIONS(235),
    [anon_sym_xor_DASHint_SLASH2addr] = ACTIONS(235),
    [anon_sym_shl_DASHint_SLASH2addr] = ACTIONS(235),
    [anon_sym_shr_DASHint_SLASH2addr] = ACTIONS(235),
    [anon_sym_ushr_DASHint_SLASH2addr] = ACTIONS(235),
    [anon_sym_add_DASHlong_SLASH2addr] = ACTIONS(235),
    [anon_sym_sub_DASHlong_SLASH2addr] = ACTIONS(235),
    [anon_sym_mul_DASHlong_SLASH2addr] = ACTIONS(235),
    [anon_sym_div_DASHlong_SLASH2addr] = ACTIONS(235),
    [anon_sym_rem_DASHlong_SLASH2addr] = ACTIONS(235),
    [anon_sym_and_DASHlong_SLASH2addr] = ACTIONS(235),
    [anon_sym_or_DASHlong_SLASH2addr] = ACTIONS(235),
    [anon_sym_xor_DASHlong_SLASH2addr] = ACTIONS(235),
    [anon_sym_shl_DASHlong_SLASH2addr] = ACTIONS(235),
    [anon_sym_shr_DASHlong_SLASH2addr] = ACTIONS(235),
    [anon_sym_ushr_DASHlong_SLASH2addr] = ACTIONS(235),
    [anon_sym_add_DASHfloat_SLASH2addr] = ACTIONS(235),
    [anon_sym_sub_DASHfloat_SLASH2addr] = ACTIONS(235),
    [anon_sym_mul_DASHfloat_SLASH2addr] = ACTIONS(235),
    [anon_sym_div_DASHfloat_SLASH2addr] = ACTIONS(235),
    [anon_sym_rem_DASHfloat_SLASH2addr] = ACTIONS(235),
    [anon_sym_add_DASHdouble_SLASH2addr] = ACTIONS(235),
    [anon_sym_sub_DASHdouble_SLASH2addr] = ACTIONS(235),
    [anon_sym_mul_DASHdouble_SLASH2addr] = ACTIONS(235),
    [anon_sym_div_DASHdouble_SLASH2addr] = ACTIONS(235),
    [anon_sym_rem_DASHdouble_SLASH2addr] = ACTIONS(235),
    [anon_sym_add_DASHint_SLASHlit16] = ACTIONS(235),
    [anon_sym_sub_DASHint_SLASHlit16] = ACTIONS(235),
    [anon_sym_mul_DASHint_SLASHlit16] = ACTIONS(235),
    [anon_sym_div_DASHint_SLASHlit16] = ACTIONS(235),
    [anon_sym_rem_DASHint_SLASHlit16] = ACTIONS(235),
    [anon_sym_and_DASHint_SLASHlit16] = ACTIONS(235),
    [anon_sym_or_DASHint_SLASHlit16] = ACTIONS(235),
    [anon_sym_xor_DASHint_SLASHlit16] = ACTIONS(235),
    [anon_sym_add_DASHint_SLASHlit8] = ACTIONS(235),
    [anon_sym_sub_DASHint_SLASHlit8] = ACTIONS(235),
    [anon_sym_mul_DASHint_SLASHlit8] = ACTIONS(235),
    [anon_sym_div_DASHint_SLASHlit8] = ACTIONS(235),
    [anon_sym_rem_DASHint_SLASHlit8] = ACTIONS(235),
    [anon_sym_and_DASHint_SLASHlit8] = ACTIONS(235),
    [anon_sym_or_DASHint_SLASHlit8] = ACTIONS(235),
    [anon_sym_xor_DASHint_SLASHlit8] = ACTIONS(235),
    [anon_sym_shl_DASHint_SLASHlit8] = ACTIONS(235),
    [anon_sym_shr_DASHint_SLASHlit8] = ACTIONS(235),
    [anon_sym_ushr_DASHint_SLASHlit8] = ACTIONS(235),
    [anon_sym_static_DASHget] = ACTIONS(235),
    [anon_sym_static_DASHput] = ACTIONS(235),
    [anon_sym_instance_DASHget] = ACTIONS(235),
    [anon_sym_instance_DASHput] = ACTIONS(235),
    [anon_sym_execute_DASHinline] = ACTIONS(237),
    [anon_sym_execute_DASHinline_SLASHrange] = ACTIONS(235),
    [anon_sym_iget_DASHquick] = ACTIONS(235),
    [anon_sym_iget_DASHwide_DASHquick] = ACTIONS(235),
    [anon_sym_iget_DASHobject_DASHquick] = ACTIONS(235),
    [anon_sym_iput_DASHquick] = ACTIONS(235),
    [anon_sym_iput_DASHwide_DASHquick] = ACTIONS(235),
    [anon_sym_iput_DASHobject_DASHquick] = ACTIONS(235),
    [anon_sym_iput_DASHboolean_DASHquick] = ACTIONS(235),
    [anon_sym_iput_DASHbyte_DASHquick] = ACTIONS(235),
    [anon_sym_iput_DASHchar_DASHquick] = ACTIONS(235),
    [anon_sym_iput_DASHshort_DASHquick] = ACTIONS(235),
    [anon_sym_invoke_DASHvirtual_DASHquick] = ACTIONS(237),
    [anon_sym_invoke_DASHvirtual_DASHquick_SLASHrange] = ACTIONS(235),
    [anon_sym_invoke_DASHsuper_DASHquick] = ACTIONS(237),
    [anon_sym_invoke_DASHsuper_DASHquick_SLASHrange] = ACTIONS(235),
    [anon_sym_rsub_DASHint] = ACTIONS(237),
    [anon_sym_rsub_DASHint_SLASHlit8] = ACTIONS(235),
    [anon_sym_DOTline] = ACTIONS(235),
    [anon_sym_DOTlocals] = ACTIONS(235),
    [anon_sym_DOTlocal] = ACTIONS(237),
    [anon_sym_DOTendlocal] = ACTIONS(235),
    [anon_sym_DOTrestartlocal] = ACTIONS(235),
    [anon_sym_DOTregisters] = ACTIONS(235),
    [anon_sym_DOTcatch] = ACTIONS(237),
    [anon_sym_RBRACE] = ACTIONS(235),
    [anon_sym_DOTcatchall] = ACTIONS(235),
    [anon_sym_DOTpacked_DASHswitch] = ACTIONS(235),
    [anon_sym_DOTsparse_DASHswitch] = ACTIONS(235),
    [anon_sym_DASH_GT] = ACTIONS(235),
    [anon_sym_DOTarray_DASHdata] = ACTIONS(235),
    [sym_prologue_directive] = ACTIONS(235),
    [sym_epilogue_directive] = ACTIONS(235),
    [aux_sym_label_token1] = ACTIONS(235),
    [aux_sym_jmp_label_token1] = ACTIONS(235),
    [anon_sym_RPAREN] = ACTIONS(235),
    [sym_comment] = ACTIONS(3),
  },
  [18] = {
    [ts_builtin_sym_end] = ACTIONS(239),
    [anon_sym_DOTsource] = ACTIONS(239),
    [anon_sym_DOTimplements] = ACTIONS(239),
    [anon_sym_DOTfield] = ACTIONS(239),
    [anon_sym_DOTendfield] = ACTIONS(239),
    [anon_sym_DOTmethod] = ACTIONS(239),
    [anon_sym_DOTendmethod] = ACTIONS(239),
    [anon_sym_DOTannotation] = ACTIONS(239),
    [anon_sym_DOTparam] = ACTIONS(241),
    [anon_sym_COMMA] = ACTIONS(239),
    [anon_sym_DOTparameter] = ACTIONS(239),
    [anon_sym_DOTendparameter] = ACTIONS(239),
    [anon_sym_nop] = ACTIONS(241),
    [anon_sym_move] = ACTIONS(241),
    [anon_sym_move_SLASHfrom16] = ACTIONS(239),
    [anon_sym_move_SLASH16] = ACTIONS(239),
    [anon_sym_move_DASHwide] = ACTIONS(241),
    [anon_sym_move_DASHwide_SLASHfrom16] = ACTIONS(239),
    [anon_sym_move_DASHwide_SLASH16] = ACTIONS(239),
    [anon_sym_move_DASHobject] = ACTIONS(241),
    [anon_sym_move_DASHobject_SLASHfrom16] = ACTIONS(239),
    [anon_sym_move_DASHobject_SLASH16] = ACTIONS(239),
    [anon_sym_move_DASHresult] = ACTIONS(241),
    [anon_sym_move_DASHresult_DASHwide] = ACTIONS(239),
    [anon_sym_move_DASHresult_DASHobject] = ACTIONS(239),
    [anon_sym_move_DASHexception] = ACTIONS(239),
    [anon_sym_return_DASHvoid] = ACTIONS(239),
    [anon_sym_return] = ACTIONS(241),
    [anon_sym_return_DASHwide] = ACTIONS(239),
    [anon_sym_return_DASHobject] = ACTIONS(239),
    [anon_sym_const_SLASH4] = ACTIONS(239),
    [anon_sym_const_SLASH16] = ACTIONS(239),
    [anon_sym_const] = ACTIONS(241),
    [anon_sym_const_SLASHhigh16] = ACTIONS(239),
    [anon_sym_const_DASHwide_SLASH16] = ACTIONS(239),
    [anon_sym_const_DASHwide_SLASH32] = ACTIONS(239),
    [anon_sym_const_DASHwide] = ACTIONS(241),
    [anon_sym_const_DASHwide_SLASHhigh16] = ACTIONS(239),
    [anon_sym_const_DASHstring] = ACTIONS(241),
    [anon_sym_const_DASHstring_SLASHjumbo] = ACTIONS(239),
    [anon_sym_const_DASHclass] = ACTIONS(239),
    [anon_sym_const_DASHmethod_DASHhandle] = ACTIONS(239),
    [anon_sym_const_DASHmethod_DASHtype] = ACTIONS(239),
    [anon_sym_monitor_DASHenter] = ACTIONS(239),
    [anon_sym_monitor_DASHexit] = ACTIONS(239),
    [anon_sym_check_DASHcast] = ACTIONS(239),
    [anon_sym_instance_DASHof] = ACTIONS(239),
    [anon_sym_array_DASHlength] = ACTIONS(239),
    [anon_sym_new_DASHinstance] = ACTIONS(239),
    [anon_sym_new_DASHarray] = ACTIONS(239),
    [anon_sym_filled_DASHnew_DASHarray] = ACTIONS(241),
    [anon_sym_filled_DASHnew_DASHarray_SLASHrange] = ACTIONS(239),
    [anon_sym_fill_DASHarray_DASHdata] = ACTIONS(239),
    [anon_sym_throw] = ACTIONS(241),
    [anon_sym_throw_DASHverification_DASHerror] = ACTIONS(239),
    [anon_sym_goto] = ACTIONS(241),
    [anon_sym_goto_SLASH16] = ACTIONS(239),
    [anon_sym_goto_SLASH32] = ACTIONS(239),
    [anon_sym_packed_DASHswitch] = ACTIONS(239),
    [anon_sym_sparse_DASHswitch] = ACTIONS(239),
    [anon_sym_cmpl_DASHfloat] = ACTIONS(239),
    [anon_sym_cmpg_DASHfloat] = ACTIONS(239),
    [anon_sym_cmpl_DASHdouble] = ACTIONS(239),
    [anon_sym_cmpg_DASHdouble] = ACTIONS(239),
    [anon_sym_cmp_DASHlong] = ACTIONS(239),
    [anon_sym_if_DASHeq] = ACTIONS(241),
    [anon_sym_if_DASHne] = ACTIONS(241),
    [anon_sym_if_DASHlt] = ACTIONS(241),
    [anon_sym_if_DASHge] = ACTIONS(241),
    [anon_sym_if_DASHgt] = ACTIONS(241),
    [anon_sym_if_DASHle] = ACTIONS(241),
    [anon_sym_if_DASHeqz] = ACTIONS(239),
    [anon_sym_if_DASHnez] = ACTIONS(239),
    [anon_sym_if_DASHltz] = ACTIONS(239),
    [anon_sym_if_DASHgez] = ACTIONS(239),
    [anon_sym_if_DASHgtz] = ACTIONS(239),
    [anon_sym_if_DASHlez] = ACTIONS(239),
    [anon_sym_aget] = ACTIONS(241),
    [anon_sym_aget_DASHwide] = ACTIONS(239),
    [anon_sym_aget_DASHobject] = ACTIONS(239),
    [anon_sym_aget_DASHboolean] = ACTIONS(239),
    [anon_sym_aget_DASHbyte] = ACTIONS(239),
    [anon_sym_aget_DASHchar] = ACTIONS(239),
    [anon_sym_aget_DASHshort] = ACTIONS(239),
    [anon_sym_aput] = ACTIONS(241),
    [anon_sym_aput_DASHwide] = ACTIONS(239),
    [anon_sym_aput_DASHobject] = ACTIONS(239),
    [anon_sym_aput_DASHboolean] = ACTIONS(239),
    [anon_sym_aput_DASHbyte] = ACTIONS(239),
    [anon_sym_aput_DASHchar] = ACTIONS(239),
    [anon_sym_aput_DASHshort] = ACTIONS(239),
    [anon_sym_iget] = ACTIONS(241),
    [anon_sym_iget_DASHwide] = ACTIONS(241),
    [anon_sym_iget_DASHobject] = ACTIONS(241),
    [anon_sym_iget_DASHboolean] = ACTIONS(239),
    [anon_sym_iget_DASHbyte] = ACTIONS(239),
    [anon_sym_iget_DASHchar] = ACTIONS(239),
    [anon_sym_iget_DASHshort] = ACTIONS(239),
    [anon_sym_iget_DASHvolatile] = ACTIONS(239),
    [anon_sym_iget_DASHwide_DASHvolatile] = ACTIONS(239),
    [anon_sym_iget_DASHobject_DASHvolatile] = ACTIONS(239),
    [anon_sym_iput] = ACTIONS(241),
    [anon_sym_iput_DASHwide] = ACTIONS(241),
    [anon_sym_iput_DASHobject] = ACTIONS(241),
    [anon_sym_iput_DASHboolean] = ACTIONS(241),
    [anon_sym_iput_DASHbyte] = ACTIONS(241),
    [anon_sym_iput_DASHchar] = ACTIONS(241),
    [anon_sym_iput_DASHshort] = ACTIONS(241),
    [anon_sym_iput_DASHvolatile] = ACTIONS(239),
    [anon_sym_iput_DASHwide_DASHvolatile] = ACTIONS(239),
    [anon_sym_iput_DASHobject_DASHvolatile] = ACTIONS(239),
    [anon_sym_sget] = ACTIONS(241),
    [anon_sym_sget_DASHwide] = ACTIONS(241),
    [anon_sym_sget_DASHobject] = ACTIONS(241),
    [anon_sym_sget_DASHboolean] = ACTIONS(239),
    [anon_sym_sget_DASHbyte] = ACTIONS(239),
    [anon_sym_sget_DASHchar] = ACTIONS(239),
    [anon_sym_sget_DASHshort] = ACTIONS(239),
    [anon_sym_sget_DASHvolatile] = ACTIONS(239),
    [anon_sym_sget_DASHwide_DASHvolatile] = ACTIONS(239),
    [anon_sym_sget_DASHobject_DASHvolatile] = ACTIONS(239),
    [anon_sym_sput] = ACTIONS(241),
    [anon_sym_sput_DASHwide] = ACTIONS(241),
    [anon_sym_sput_DASHobject] = ACTIONS(241),
    [anon_sym_sput_DASHboolean] = ACTIONS(239),
    [anon_sym_sput_DASHbyte] = ACTIONS(239),
    [anon_sym_sput_DASHchar] = ACTIONS(239),
    [anon_sym_sput_DASHshort] = ACTIONS(239),
    [anon_sym_sput_DASHvolatile] = ACTIONS(239),
    [anon_sym_sput_DASHwide_DASHvolatile] = ACTIONS(239),
    [anon_sym_sput_DASHobject_DASHvolatile] = ACTIONS(239),
    [anon_sym_invoke_DASHconstructor] = ACTIONS(239),
    [anon_sym_invoke_DASHcustom] = ACTIONS(241),
    [anon_sym_invoke_DASHdirect] = ACTIONS(241),
    [anon_sym_invoke_DASHdirect_DASHempty] = ACTIONS(239),
    [anon_sym_invoke_DASHinstance] = ACTIONS(239),
    [anon_sym_invoke_DASHinterface] = ACTIONS(241),
    [anon_sym_invoke_DASHpolymorphic] = ACTIONS(241),
    [anon_sym_invoke_DASHstatic] = ACTIONS(241),
    [anon_sym_invoke_DASHsuper] = ACTIONS(241),
    [anon_sym_invoke_DASHvirtual] = ACTIONS(241),
    [anon_sym_invoke_DASHcustom_SLASHrange] = ACTIONS(239),
    [anon_sym_invoke_DASHdirect_SLASHrange] = ACTIONS(239),
    [anon_sym_invoke_DASHinterface_SLASHrange] = ACTIONS(239),
    [anon_sym_invoke_DASHobject_DASHinit_SLASHrange] = ACTIONS(239),
    [anon_sym_invoke_DASHpolymorphic_SLASHrange] = ACTIONS(239),
    [anon_sym_invoke_DASHstatic_SLASHrange] = ACTIONS(239),
    [anon_sym_invoke_DASHsuper_SLASHrange] = ACTIONS(239),
    [anon_sym_invoke_DASHvirtual_SLASHrange] = ACTIONS(239),
    [anon_sym_neg_DASHint] = ACTIONS(239),
    [anon_sym_not_DASHint] = ACTIONS(239),
    [anon_sym_neg_DASHlong] = ACTIONS(239),
    [anon_sym_not_DASHlong] = ACTIONS(239),
    [anon_sym_neg_DASHfloat] = ACTIONS(239),
    [anon_sym_neg_DASHdouble] = ACTIONS(239),
    [anon_sym_int_DASHto_DASHlong] = ACTIONS(239),
    [anon_sym_int_DASHto_DASHfloat] = ACTIONS(239),
    [anon_sym_int_DASHto_DASHdouble] = ACTIONS(239),
    [anon_sym_long_DASHto_DASHint] = ACTIONS(239),
    [anon_sym_long_DASHto_DASHfloat] = ACTIONS(239),
    [anon_sym_long_DASHto_DASHdouble] = ACTIONS(239),
    [anon_sym_float_DASHto_DASHint] = ACTIONS(239),
    [anon_sym_float_DASHto_DASHlong] = ACTIONS(239),
    [anon_sym_float_DASHto_DASHdouble] = ACTIONS(239),
    [anon_sym_double_DASHto_DASHint] = ACTIONS(239),
    [anon_sym_double_DASHto_DASHlong] = ACTIONS(239),
    [anon_sym_double_DASHto_DASHfloat] = ACTIONS(239),
    [anon_sym_int_DASHto_DASHbyte] = ACTIONS(239),
    [anon_sym_int_DASHto_DASHchar] = ACTIONS(239),
    [anon_sym_int_DASHto_DASHshort] = ACTIONS(239),
    [anon_sym_add_DASHint] = ACTIONS(241),
    [anon_sym_sub_DASHint] = ACTIONS(241),
    [anon_sym_mul_DASHint] = ACTIONS(241),
    [anon_sym_div_DASHint] = ACTIONS(241),
    [anon_sym_rem_DASHint] = ACTIONS(241),
    [anon_sym_and_DASHint] = ACTIONS(241),
    [anon_sym_or_DASHint] = ACTIONS(241),
    [anon_sym_xor_DASHint] = ACTIONS(241),
    [anon_sym_shl_DASHint] = ACTIONS(241),
    [anon_sym_shr_DASHint] = ACTIONS(241),
    [anon_sym_ushr_DASHint] = ACTIONS(241),
    [anon_sym_add_DASHlong] = ACTIONS(241),
    [anon_sym_sub_DASHlong] = ACTIONS(241),
    [anon_sym_mul_DASHlong] = ACTIONS(241),
    [anon_sym_div_DASHlong] = ACTIONS(241),
    [anon_sym_rem_DASHlong] = ACTIONS(241),
    [anon_sym_and_DASHlong] = ACTIONS(241),
    [anon_sym_or_DASHlong] = ACTIONS(241),
    [anon_sym_xor_DASHlong] = ACTIONS(241),
    [anon_sym_shl_DASHlong] = ACTIONS(241),
    [anon_sym_shr_DASHlong] = ACTIONS(241),
    [anon_sym_ushr_DASHlong] = ACTIONS(241),
    [anon_sym_add_DASHfloat] = ACTIONS(241),
    [anon_sym_sub_DASHfloat] = ACTIONS(241),
    [anon_sym_mul_DASHfloat] = ACTIONS(241),
    [anon_sym_div_DASHfloat] = ACTIONS(241),
    [anon_sym_rem_DASHfloat] = ACTIONS(241),
    [anon_sym_add_DASHdouble] = ACTIONS(241),
    [anon_sym_sub_DASHdouble] = ACTIONS(241),
    [anon_sym_mul_DASHdouble] = ACTIONS(241),
    [anon_sym_div_DASHdouble] = ACTIONS(241),
    [anon_sym_rem_DASHdouble] = ACTIONS(241),
    [anon_sym_add_DASHint_SLASH2addr] = ACTIONS(239),
    [anon_sym_sub_DASHint_SLASH2addr] = ACTIONS(239),
    [anon_sym_mul_DASHint_SLASH2addr] = ACTIONS(239),
    [anon_sym_div_DASHint_SLASH2addr] = ACTIONS(239),
    [anon_sym_rem_DASHint_SLASH2addr] = ACTIONS(239),
    [anon_sym_and_DASHint_SLASH2addr] = ACTIONS(239),
    [anon_sym_or_DASHint_SLASH2addr] = ACTIONS(239),
    [anon_sym_xor_DASHint_SLASH2addr] = ACTIONS(239),
    [anon_sym_shl_DASHint_SLASH2addr] = ACTIONS(239),
    [anon_sym_shr_DASHint_SLASH2addr] = ACTIONS(239),
    [anon_sym_ushr_DASHint_SLASH2addr] = ACTIONS(239),
    [anon_sym_add_DASHlong_SLASH2addr] = ACTIONS(239),
    [anon_sym_sub_DASHlong_SLASH2addr] = ACTIONS(239),
    [anon_sym_mul_DASHlong_SLASH2addr] = ACTIONS(239),
    [anon_sym_div_DASHlong_SLASH2addr] = ACTIONS(239),
    [anon_sym_rem_DASHlong_SLASH2addr] = ACTIONS(239),
    [anon_sym_and_DASHlong_SLASH2addr] = ACTIONS(239),
    [anon_sym_or_DASHlong_SLASH2addr] = ACTIONS(239),
    [anon_sym_xor_DASHlong_SLASH2addr] = ACTIONS(239),
    [anon_sym_shl_DASHlong_SLASH2addr] = ACTIONS(239),
    [anon_sym_shr_DASHlong_SLASH2addr] = ACTIONS(239),
    [anon_sym_ushr_DASHlong_SLASH2addr] = ACTIONS(239),
    [anon_sym_add_DASHfloat_SLASH2addr] = ACTIONS(239),
    [anon_sym_sub_DASHfloat_SLASH2addr] = ACTIONS(239),
    [anon_sym_mul_DASHfloat_SLASH2addr] = ACTIONS(239),
    [anon_sym_div_DASHfloat_SLASH2addr] = ACTIONS(239),
    [anon_sym_rem_DASHfloat_SLASH2addr] = ACTIONS(239),
    [anon_sym_add_DASHdouble_SLASH2addr] = ACTIONS(239),
    [anon_sym_sub_DASHdouble_SLASH2addr] = ACTIONS(239),
    [anon_sym_mul_DASHdouble_SLASH2addr] = ACTIONS(239),
    [anon_sym_div_DASHdouble_SLASH2addr] = ACTIONS(239),
    [anon_sym_rem_DASHdouble_SLASH2addr] = ACTIONS(239),
    [anon_sym_add_DASHint_SLASHlit16] = ACTIONS(239),
    [anon_sym_sub_DASHint_SLASHlit16] = ACTIONS(239),
    [anon_sym_mul_DASHint_SLASHlit16] = ACTIONS(239),
    [anon_sym_div_DASHint_SLASHlit16] = ACTIONS(239),
    [anon_sym_rem_DASHint_SLASHlit16] = ACTIONS(239),
    [anon_sym_and_DASHint_SLASHlit16] = ACTIONS(239),
    [anon_sym_or_DASHint_SLASHlit16] = ACTIONS(239),
    [anon_sym_xor_DASHint_SLASHlit16] = ACTIONS(239),
    [anon_sym_add_DASHint_SLASHlit8] = ACTIONS(239),
    [anon_sym_sub_DASHint_SLASHlit8] = ACTIONS(239),
    [anon_sym_mul_DASHint_SLASHlit8] = ACTIONS(239),
    [anon_sym_div_DASHint_SLASHlit8] = ACTIONS(239),
    [anon_sym_rem_DASHint_SLASHlit8] = ACTIONS(239),
    [anon_sym_and_DASHint_SLASHlit8] = ACTIONS(239),
    [anon_sym_or_DASHint_SLASHlit8] = ACTIONS(239),
    [anon_sym_xor_DASHint_SLASHlit8] = ACTIONS(239),
    [anon_sym_shl_DASHint_SLASHlit8] = ACTIONS(239),
    [anon_sym_shr_DASHint_SLASHlit8] = ACTIONS(239),
    [anon_sym_ushr_DASHint_SLASHlit8] = ACTIONS(239),
    [anon_sym_static_DASHget] = ACTIONS(239),
    [anon_sym_static_DASHput] = ACTIONS(239),
    [anon_sym_instance_DASHget] = ACTIONS(239),
    [anon_sym_instance_DASHput] = ACTIONS(239),
    [anon_sym_execute_DASHinline] = ACTIONS(241),
    [anon_sym_execute_DASHinline_SLASHrange] = ACTIONS(239),
    [anon_sym_iget_DASHquick] = ACTIONS(239),
    [anon_sym_iget_DASHwide_DASHquick] = ACTIONS(239),
    [anon_sym_iget_DASHobject_DASHquick] = ACTIONS(239),
    [anon_sym_iput_DASHquick] = ACTIONS(239),
    [anon_sym_iput_DASHwide_DASHquick] = ACTIONS(239),
    [anon_sym_iput_DASHobject_DASHquick] = ACTIONS(239),
    [anon_sym_iput_DASHboolean_DASHquick] = ACTIONS(239),
    [anon_sym_iput_DASHbyte_DASHquick] = ACTIONS(239),
    [anon_sym_iput_DASHchar_DASHquick] = ACTIONS(239),
    [anon_sym_iput_DASHshort_DASHquick] = ACTIONS(239),
    [anon_sym_invoke_DASHvirtual_DASHquick] = ACTIONS(241),
    [anon_sym_invoke_DASHvirtual_DASHquick_SLASHrange] = ACTIONS(239),
    [anon_sym_invoke_DASHsuper_DASHquick] = ACTIONS(241),
    [anon_sym_invoke_DASHsuper_DASHquick_SLASHrange] = ACTIONS(239),
    [anon_sym_rsub_DASHint] = ACTIONS(241),
    [anon_sym_rsub_DASHint_SLASHlit8] = ACTIONS(239),
    [anon_sym_DOTline] = ACTIONS(239),
    [anon_sym_DOTlocals] = ACTIONS(239),
    [anon_sym_DOTlocal] = ACTIONS(241),
    [anon_sym_DOTendlocal] = ACTIONS(239),
    [anon_sym_DOTrestartlocal] = ACTIONS(239),
    [anon_sym_DOTregisters] = ACTIONS(239),
    [anon_sym_DOTcatch] = ACTIONS(241),
    [anon_sym_RBRACE] = ACTIONS(239),
    [anon_sym_DOTcatchall] = ACTIONS(239),
    [anon_sym_DOTpacked_DASHswitch] = ACTIONS(239),
    [anon_sym_DOTsparse_DASHswitch] = ACTIONS(239),
    [anon_sym_DOTarray_DASHdata] = ACTIONS(239),
    [sym_prologue_directive] = ACTIONS(239),
    [sym_epilogue_directive] = ACTIONS(239),
    [aux_sym_label_token1] = ACTIONS(239),
    [aux_sym_jmp_label_token1] = ACTIONS(239),
    [anon_sym_RPAREN] = ACTIONS(239),
    [sym_comment] = ACTIONS(3),
  },
  [19] = {
    [ts_builtin_sym_end] = ACTIONS(243),
    [anon_sym_DOTsource] = ACTIONS(243),
    [anon_sym_DOTimplements] = ACTIONS(243),
    [anon_sym_DOTfield] = ACTIONS(243),
    [anon_sym_DOTendfield] = ACTIONS(243),
    [anon_sym_DOTmethod] = ACTIONS(243),
    [anon_sym_DOTendmethod] = ACTIONS(243),
    [anon_sym_DOTannotation] = ACTIONS(243),
    [anon_sym_DOTparam] = ACTIONS(245),
    [anon_sym_COMMA] = ACTIONS(243),
    [anon_sym_DOTparameter] = ACTIONS(243),
    [anon_sym_DOTendparameter] = ACTIONS(243),
    [anon_sym_nop] = ACTIONS(245),
    [anon_sym_move] = ACTIONS(245),
    [anon_sym_move_SLASHfrom16] = ACTIONS(243),
    [anon_sym_move_SLASH16] = ACTIONS(243),
    [anon_sym_move_DASHwide] = ACTIONS(245),
    [anon_sym_move_DASHwide_SLASHfrom16] = ACTIONS(243),
    [anon_sym_move_DASHwide_SLASH16] = ACTIONS(243),
    [anon_sym_move_DASHobject] = ACTIONS(245),
    [anon_sym_move_DASHobject_SLASHfrom16] = ACTIONS(243),
    [anon_sym_move_DASHobject_SLASH16] = ACTIONS(243),
    [anon_sym_move_DASHresult] = ACTIONS(245),
    [anon_sym_move_DASHresult_DASHwide] = ACTIONS(243),
    [anon_sym_move_DASHresult_DASHobject] = ACTIONS(243),
    [anon_sym_move_DASHexception] = ACTIONS(243),
    [anon_sym_return_DASHvoid] = ACTIONS(243),
    [anon_sym_return] = ACTIONS(245),
    [anon_sym_return_DASHwide] = ACTIONS(243),
    [anon_sym_return_DASHobject] = ACTIONS(243),
    [anon_sym_const_SLASH4] = ACTIONS(243),
    [anon_sym_const_SLASH16] = ACTIONS(243),
    [anon_sym_const] = ACTIONS(245),
    [anon_sym_const_SLASHhigh16] = ACTIONS(243),
    [anon_sym_const_DASHwide_SLASH16] = ACTIONS(243),
    [anon_sym_const_DASHwide_SLASH32] = ACTIONS(243),
    [anon_sym_const_DASHwide] = ACTIONS(245),
    [anon_sym_const_DASHwide_SLASHhigh16] = ACTIONS(243),
    [anon_sym_const_DASHstring] = ACTIONS(245),
    [anon_sym_const_DASHstring_SLASHjumbo] = ACTIONS(243),
    [anon_sym_const_DASHclass] = ACTIONS(243),
    [anon_sym_const_DASHmethod_DASHhandle] = ACTIONS(243),
    [anon_sym_const_DASHmethod_DASHtype] = ACTIONS(243),
    [anon_sym_monitor_DASHenter] = ACTIONS(243),
    [anon_sym_monitor_DASHexit] = ACTIONS(243),
    [anon_sym_check_DASHcast] = ACTIONS(243),
    [anon_sym_instance_DASHof] = ACTIONS(243),
    [anon_sym_array_DASHlength] = ACTIONS(243),
    [anon_sym_new_DASHinstance] = ACTIONS(243),
    [anon_sym_new_DASHarray] = ACTIONS(243),
    [anon_sym_filled_DASHnew_DASHarray] = ACTIONS(245),
    [anon_sym_filled_DASHnew_DASHarray_SLASHrange] = ACTIONS(243),
    [anon_sym_fill_DASHarray_DASHdata] = ACTIONS(243),
    [anon_sym_throw] = ACTIONS(245),
    [anon_sym_throw_DASHverification_DASHerror] = ACTIONS(243),
    [anon_sym_goto] = ACTIONS(245),
    [anon_sym_goto_SLASH16] = ACTIONS(243),
    [anon_sym_goto_SLASH32] = ACTIONS(243),
    [anon_sym_packed_DASHswitch] = ACTIONS(243),
    [anon_sym_sparse_DASHswitch] = ACTIONS(243),
    [anon_sym_cmpl_DASHfloat] = ACTIONS(243),
    [anon_sym_cmpg_DASHfloat] = ACTIONS(243),
    [anon_sym_cmpl_DASHdouble] = ACTIONS(243),
    [anon_sym_cmpg_DASHdouble] = ACTIONS(243),
    [anon_sym_cmp_DASHlong] = ACTIONS(243),
    [anon_sym_if_DASHeq] = ACTIONS(245),
    [anon_sym_if_DASHne] = ACTIONS(245),
    [anon_sym_if_DASHlt] = ACTIONS(245),
    [anon_sym_if_DASHge] = ACTIONS(245),
    [anon_sym_if_DASHgt] = ACTIONS(245),
    [anon_sym_if_DASHle] = ACTIONS(245),
    [anon_sym_if_DASHeqz] = ACTIONS(243),
    [anon_sym_if_DASHnez] = ACTIONS(243),
    [anon_sym_if_DASHltz] = ACTIONS(243),
    [anon_sym_if_DASHgez] = ACTIONS(243),
    [anon_sym_if_DASHgtz] = ACTIONS(243),
    [anon_sym_if_DASHlez] = ACTIONS(243),
    [anon_sym_aget] = ACTIONS(245),
    [anon_sym_aget_DASHwide] = ACTIONS(243),
    [anon_sym_aget_DASHobject] = ACTIONS(243),
    [anon_sym_aget_DASHboolean] = ACTIONS(243),
    [anon_sym_aget_DASHbyte] = ACTIONS(243),
    [anon_sym_aget_DASHchar] = ACTIONS(243),
    [anon_sym_aget_DASHshort] = ACTIONS(243),
    [anon_sym_aput] = ACTIONS(245),
    [anon_sym_aput_DASHwide] = ACTIONS(243),
    [anon_sym_aput_DASHobject] = ACTIONS(243),
    [anon_sym_aput_DASHboolean] = ACTIONS(243),
    [anon_sym_aput_DASHbyte] = ACTIONS(243),
    [anon_sym_aput_DASHchar] = ACTIONS(243),
    [anon_sym_aput_DASHshort] = ACTIONS(243),
    [anon_sym_iget] = ACTIONS(245),
    [anon_sym_iget_DASHwide] = ACTIONS(245),
    [anon_sym_iget_DASHobject] = ACTIONS(245),
    [anon_sym_iget_DASHboolean] = ACTIONS(243),
    [anon_sym_iget_DASHbyte] = ACTIONS(243),
    [anon_sym_iget_DASHchar] = ACTIONS(243),
    [anon_sym_iget_DASHshort] = ACTIONS(243),
    [anon_sym_iget_DASHvolatile] = ACTIONS(243),
    [anon_sym_iget_DASHwide_DASHvolatile] = ACTIONS(243),
    [anon_sym_iget_DASHobject_DASHvolatile] = ACTIONS(243),
    [anon_sym_iput] = ACTIONS(245),
    [anon_sym_iput_DASHwide] = ACTIONS(245),
    [anon_sym_iput_DASHobject] = ACTIONS(245),
    [anon_sym_iput_DASHboolean] = ACTIONS(245),
    [anon_sym_iput_DASHbyte] = ACTIONS(245),
    [anon_sym_iput_DASHchar] = ACTIONS(245),
    [anon_sym_iput_DASHshort] = ACTIONS(245),
    [anon_sym_iput_DASHvolatile] = ACTIONS(243),
    [anon_sym_iput_DASHwide_DASHvolatile] = ACTIONS(243),
    [anon_sym_iput_DASHobject_DASHvolatile] = ACTIONS(243),
    [anon_sym_sget] = ACTIONS(245),
    [anon_sym_sget_DASHwide] = ACTIONS(245),
    [anon_sym_sget_DASHobject] = ACTIONS(245),
    [anon_sym_sget_DASHboolean] = ACTIONS(243),
    [anon_sym_sget_DASHbyte] = ACTIONS(243),
    [anon_sym_sget_DASHchar] = ACTIONS(243),
    [anon_sym_sget_DASHshort] = ACTIONS(243),
    [anon_sym_sget_DASHvolatile] = ACTIONS(243),
    [anon_sym_sget_DASHwide_DASHvolatile] = ACTIONS(243),
    [anon_sym_sget_DASHobject_DASHvolatile] = ACTIONS(243),
    [anon_sym_sput] = ACTIONS(245),
    [anon_sym_sput_DASHwide] = ACTIONS(245),
    [anon_sym_sput_DASHobject] = ACTIONS(245),
    [anon_sym_sput_DASHboolean] = ACTIONS(243),
    [anon_sym_sput_DASHbyte] = ACTIONS(243),
    [anon_sym_sput_DASHchar] = ACTIONS(243),
    [anon_sym_sput_DASHshort] = ACTIONS(243),
    [anon_sym_sput_DASHvolatile] = ACTIONS(243),
    [anon_sym_sput_DASHwide_DASHvolatile] = ACTIONS(243),
    [anon_sym_sput_DASHobject_DASHvolatile] = ACTIONS(243),
    [anon_sym_invoke_DASHconstructor] = ACTIONS(243),
    [anon_sym_invoke_DASHcustom] = ACTIONS(245),
    [anon_sym_invoke_DASHdirect] = ACTIONS(245),
    [anon_sym_invoke_DASHdirect_DASHempty] = ACTIONS(243),
    [anon_sym_invoke_DASHinstance] = ACTIONS(243),
    [anon_sym_invoke_DASHinterface] = ACTIONS(245),
    [anon_sym_invoke_DASHpolymorphic] = ACTIONS(245),
    [anon_sym_invoke_DASHstatic] = ACTIONS(245),
    [anon_sym_invoke_DASHsuper] = ACTIONS(245),
    [anon_sym_invoke_DASHvirtual] = ACTIONS(245),
    [anon_sym_invoke_DASHcustom_SLASHrange] = ACTIONS(243),
    [anon_sym_invoke_DASHdirect_SLASHrange] = ACTIONS(243),
    [anon_sym_invoke_DASHinterface_SLASHrange] = ACTIONS(243),
    [anon_sym_invoke_DASHobject_DASHinit_SLASHrange] = ACTIONS(243),
    [anon_sym_invoke_DASHpolymorphic_SLASHrange] = ACTIONS(243),
    [anon_sym_invoke_DASHstatic_SLASHrange] = ACTIONS(243),
    [anon_sym_invoke_DASHsuper_SLASHrange] = ACTIONS(243),
    [anon_sym_invoke_DASHvirtual_SLASHrange] = ACTIONS(243),
    [anon_sym_neg_DASHint] = ACTIONS(243),
    [anon_sym_not_DASHint] = ACTIONS(243),
    [anon_sym_neg_DASHlong] = ACTIONS(243),
    [anon_sym_not_DASHlong] = ACTIONS(243),
    [anon_sym_neg_DASHfloat] = ACTIONS(243),
    [anon_sym_neg_DASHdouble] = ACTIONS(243),
    [anon_sym_int_DASHto_DASHlong] = ACTIONS(243),
    [anon_sym_int_DASHto_DASHfloat] = ACTIONS(243),
    [anon_sym_int_DASHto_DASHdouble] = ACTIONS(243),
    [anon_sym_long_DASHto_DASHint] = ACTIONS(243),
    [anon_sym_long_DASHto_DASHfloat] = ACTIONS(243),
    [anon_sym_long_DASHto_DASHdouble] = ACTIONS(243),
    [anon_sym_float_DASHto_DASHint] = ACTIONS(243),
    [anon_sym_float_DASHto_DASHlong] = ACTIONS(243),
    [anon_sym_float_DASHto_DASHdouble] = ACTIONS(243),
    [anon_sym_double_DASHto_DASHint] = ACTIONS(243),
    [anon_sym_double_DASHto_DASHlong] = ACTIONS(243),
    [anon_sym_double_DASHto_DASHfloat] = ACTIONS(243),
    [anon_sym_int_DASHto_DASHbyte] = ACTIONS(243),
    [anon_sym_int_DASHto_DASHchar] = ACTIONS(243),
    [anon_sym_int_DASHto_DASHshort] = ACTIONS(243),
    [anon_sym_add_DASHint] = ACTIONS(245),
    [anon_sym_sub_DASHint] = ACTIONS(245),
    [anon_sym_mul_DASHint] = ACTIONS(245),
    [anon_sym_div_DASHint] = ACTIONS(245),
    [anon_sym_rem_DASHint] = ACTIONS(245),
    [anon_sym_and_DASHint] = ACTIONS(245),
    [anon_sym_or_DASHint] = ACTIONS(245),
    [anon_sym_xor_DASHint] = ACTIONS(245),
    [anon_sym_shl_DASHint] = ACTIONS(245),
    [anon_sym_shr_DASHint] = ACTIONS(245),
    [anon_sym_ushr_DASHint] = ACTIONS(245),
    [anon_sym_add_DASHlong] = ACTIONS(245),
    [anon_sym_sub_DASHlong] = ACTIONS(245),
    [anon_sym_mul_DASHlong] = ACTIONS(245),
    [anon_sym_div_DASHlong] = ACTIONS(245),
    [anon_sym_rem_DASHlong] = ACTIONS(245),
    [anon_sym_and_DASHlong] = ACTIONS(245),
    [anon_sym_or_DASHlong] = ACTIONS(245),
    [anon_sym_xor_DASHlong] = ACTIONS(245),
    [anon_sym_shl_DASHlong] = ACTIONS(245),
    [anon_sym_shr_DASHlong] = ACTIONS(245),
    [anon_sym_ushr_DASHlong] = ACTIONS(245),
    [anon_sym_add_DASHfloat] = ACTIONS(245),
    [anon_sym_sub_DASHfloat] = ACTIONS(245),
    [anon_sym_mul_DASHfloat] = ACTIONS(245),
    [anon_sym_div_DASHfloat] = ACTIONS(245),
    [anon_sym_rem_DASHfloat] = ACTIONS(245),
    [anon_sym_add_DASHdouble] = ACTIONS(245),
    [anon_sym_sub_DASHdouble] = ACTIONS(245),
    [anon_sym_mul_DASHdouble] = ACTIONS(245),
    [anon_sym_div_DASHdouble] = ACTIONS(245),
    [anon_sym_rem_DASHdouble] = ACTIONS(245),
    [anon_sym_add_DASHint_SLASH2addr] = ACTIONS(243),
    [anon_sym_sub_DASHint_SLASH2addr] = ACTIONS(243),
    [anon_sym_mul_DASHint_SLASH2addr] = ACTIONS(243),
    [anon_sym_div_DASHint_SLASH2addr] = ACTIONS(243),
    [anon_sym_rem_DASHint_SLASH2addr] = ACTIONS(243),
    [anon_sym_and_DASHint_SLASH2addr] = ACTIONS(243),
    [anon_sym_or_DASHint_SLASH2addr] = ACTIONS(243),
    [anon_sym_xor_DASHint_SLASH2addr] = ACTIONS(243),
    [anon_sym_shl_DASHint_SLASH2addr] = ACTIONS(243),
    [anon_sym_shr_DASHint_SLASH2addr] = ACTIONS(243),
    [anon_sym_ushr_DASHint_SLASH2addr] = ACTIONS(243),
    [anon_sym_add_DASHlong_SLASH2addr] = ACTIONS(243),
    [anon_sym_sub_DASHlong_SLASH2addr] = ACTIONS(243),
    [anon_sym_mul_DASHlong_SLASH2addr] = ACTIONS(243),
    [anon_sym_div_DASHlong_SLASH2addr] = ACTIONS(243),
    [anon_sym_rem_DASHlong_SLASH2addr] = ACTIONS(243),
    [anon_sym_and_DASHlong_SLASH2addr] = ACTIONS(243),
    [anon_sym_or_DASHlong_SLASH2addr] = ACTIONS(243),
    [anon_sym_xor_DASHlong_SLASH2addr] = ACTIONS(243),
    [anon_sym_shl_DASHlong_SLASH2addr] = ACTIONS(243),
    [anon_sym_shr_DASHlong_SLASH2addr] = ACTIONS(243),
    [anon_sym_ushr_DASHlong_SLASH2addr] = ACTIONS(243),
    [anon_sym_add_DASHfloat_SLASH2addr] = ACTIONS(243),
    [anon_sym_sub_DASHfloat_SLASH2addr] = ACTIONS(243),
    [anon_sym_mul_DASHfloat_SLASH2addr] = ACTIONS(243),
    [anon_sym_div_DASHfloat_SLASH2addr] = ACTIONS(243),
    [anon_sym_rem_DASHfloat_SLASH2addr] = ACTIONS(243),
    [anon_sym_add_DASHdouble_SLASH2addr] = ACTIONS(243),
    [anon_sym_sub_DASHdouble_SLASH2addr] = ACTIONS(243),
    [anon_sym_mul_DASHdouble_SLASH2addr] = ACTIONS(243),
    [anon_sym_div_DASHdouble_SLASH2addr] = ACTIONS(243),
    [anon_sym_rem_DASHdouble_SLASH2addr] = ACTIONS(243),
    [anon_sym_add_DASHint_SLASHlit16] = ACTIONS(243),
    [anon_sym_sub_DASHint_SLASHlit16] = ACTIONS(243),
    [anon_sym_mul_DASHint_SLASHlit16] = ACTIONS(243),
    [anon_sym_div_DASHint_SLASHlit16] = ACTIONS(243),
    [anon_sym_rem_DASHint_SLASHlit16] = ACTIONS(243),
    [anon_sym_and_DASHint_SLASHlit16] = ACTIONS(243),
    [anon_sym_or_DASHint_SLASHlit16] = ACTIONS(243),
    [anon_sym_xor_DASHint_SLASHlit16] = ACTIONS(243),
    [anon_sym_add_DASHint_SLASHlit8] = ACTIONS(243),
    [anon_sym_sub_DASHint_SLASHlit8] = ACTIONS(243),
    [anon_sym_mul_DASHint_SLASHlit8] = ACTIONS(243),
    [anon_sym_div_DASHint_SLASHlit8] = ACTIONS(243),
    [anon_sym_rem_DASHint_SLASHlit8] = ACTIONS(243),
    [anon_sym_and_DASHint_SLASHlit8] = ACTIONS(243),
    [anon_sym_or_DASHint_SLASHlit8] = ACTIONS(243),
    [anon_sym_xor_DASHint_SLASHlit8] = ACTIONS(243),
    [anon_sym_shl_DASHint_SLASHlit8] = ACTIONS(243),
    [anon_sym_shr_DASHint_SLASHlit8] = ACTIONS(243),
    [anon_sym_ushr_DASHint_SLASHlit8] = ACTIONS(243),
    [anon_sym_static_DASHget] = ACTIONS(243),
    [anon_sym_static_DASHput] = ACTIONS(243),
    [anon_sym_instance_DASHget] = ACTIONS(243),
    [anon_sym_instance_DASHput] = ACTIONS(243),
    [anon_sym_execute_DASHinline] = ACTIONS(245),
    [anon_sym_execute_DASHinline_SLASHrange] = ACTIONS(243),
    [anon_sym_iget_DASHquick] = ACTIONS(243),
    [anon_sym_iget_DASHwide_DASHquick] = ACTIONS(243),
    [anon_sym_iget_DASHobject_DASHquick] = ACTIONS(243),
    [anon_sym_iput_DASHquick] = ACTIONS(243),
    [anon_sym_iput_DASHwide_DASHquick] = ACTIONS(243),
    [anon_sym_iput_DASHobject_DASHquick] = ACTIONS(243),
    [anon_sym_iput_DASHboolean_DASHquick] = ACTIONS(243),
    [anon_sym_iput_DASHbyte_DASHquick] = ACTIONS(243),
    [anon_sym_iput_DASHchar_DASHquick] = ACTIONS(243),
    [anon_sym_iput_DASHshort_DASHquick] = ACTIONS(243),
    [anon_sym_invoke_DASHvirtual_DASHquick] = ACTIONS(245),
    [anon_sym_invoke_DASHvirtual_DASHquick_SLASHrange] = ACTIONS(243),
    [anon_sym_invoke_DASHsuper_DASHquick] = ACTIONS(245),
    [anon_sym_invoke_DASHsuper_DASHquick_SLASHrange] = ACTIONS(243),
    [anon_sym_rsub_DASHint] = ACTIONS(245),
    [anon_sym_rsub_DASHint_SLASHlit8] = ACTIONS(243),
    [anon_sym_DOTline] = ACTIONS(243),
    [anon_sym_DOTlocals] = ACTIONS(243),
    [anon_sym_DOTlocal] = ACTIONS(245),
    [anon_sym_DOTendlocal] = ACTIONS(243),
    [anon_sym_DOTrestartlocal] = ACTIONS(243),
    [anon_sym_DOTregisters] = ACTIONS(243),
    [anon_sym_DOTcatch] = ACTIONS(245),
    [anon_sym_RBRACE] = ACTIONS(243),
    [anon_sym_DOTcatchall] = ACTIONS(243),
    [anon_sym_DOTpacked_DASHswitch] = ACTIONS(243),
    [anon_sym_DOTsparse_DASHswitch] = ACTIONS(243),
    [anon_sym_DOTarray_DASHdata] = ACTIONS(243),
    [sym_prologue_directive] = ACTIONS(243),
    [sym_epilogue_directive] = ACTIONS(243),
    [aux_sym_label_token1] = ACTIONS(243),
    [aux_sym_jmp_label_token1] = ACTIONS(243),
    [anon_sym_RPAREN] = ACTIONS(243),
    [sym_comment] = ACTIONS(3),
  },
  [20] = {
    [ts_builtin_sym_end] = ACTIONS(247),
    [anon_sym_DOTsource] = ACTIONS(247),
    [anon_sym_DOTfield] = ACTIONS(247),
    [anon_sym_EQ] = ACTIONS(247),
    [anon_sym_DOTendfield] = ACTIONS(247),
    [anon_sym_DOTmethod] = ACTIONS(247),
    [anon_sym_DOTendmethod] = ACTIONS(247),
    [anon_sym_DOTannotation] = ACTIONS(247),
    [anon_sym_DOTparam] = ACTIONS(249),
    [anon_sym_COMMA] = ACTIONS(247),
    [anon_sym_DOTparameter] = ACTIONS(247),
    [anon_sym_nop] = ACTIONS(249),
    [anon_sym_move] = ACTIONS(249),
    [anon_sym_move_SLASHfrom16] = ACTIONS(247),
    [anon_sym_move_SLASH16] = ACTIONS(247),
    [anon_sym_move_DASHwide] = ACTIONS(249),
    [anon_sym_move_DASHwide_SLASHfrom16] = ACTIONS(247),
    [anon_sym_move_DASHwide_SLASH16] = ACTIONS(247),
    [anon_sym_move_DASHobject] = ACTIONS(249),
    [anon_sym_move_DASHobject_SLASHfrom16] = ACTIONS(247),
    [anon_sym_move_DASHobject_SLASH16] = ACTIONS(247),
    [anon_sym_move_DASHresult] = ACTIONS(249),
    [anon_sym_move_DASHresult_DASHwide] = ACTIONS(247),
    [anon_sym_move_DASHresult_DASHobject] = ACTIONS(247),
    [anon_sym_move_DASHexception] = ACTIONS(247),
    [anon_sym_return_DASHvoid] = ACTIONS(247),
    [anon_sym_return] = ACTIONS(249),
    [anon_sym_return_DASHwide] = ACTIONS(247),
    [anon_sym_return_DASHobject] = ACTIONS(247),
    [anon_sym_const_SLASH4] = ACTIONS(247),
    [anon_sym_const_SLASH16] = ACTIONS(247),
    [anon_sym_const] = ACTIONS(249),
    [anon_sym_const_SLASHhigh16] = ACTIONS(247),
    [anon_sym_const_DASHwide_SLASH16] = ACTIONS(247),
    [anon_sym_const_DASHwide_SLASH32] = ACTIONS(247),
    [anon_sym_const_DASHwide] = ACTIONS(249),
    [anon_sym_const_DASHwide_SLASHhigh16] = ACTIONS(247),
    [anon_sym_const_DASHstring] = ACTIONS(249),
    [anon_sym_const_DASHstring_SLASHjumbo] = ACTIONS(247),
    [anon_sym_const_DASHclass] = ACTIONS(247),
    [anon_sym_const_DASHmethod_DASHhandle] = ACTIONS(247),
    [anon_sym_const_DASHmethod_DASHtype] = ACTIONS(247),
    [anon_sym_monitor_DASHenter] = ACTIONS(247),
    [anon_sym_monitor_DASHexit] = ACTIONS(247),
    [anon_sym_check_DASHcast] = ACTIONS(247),
    [anon_sym_instance_DASHof] = ACTIONS(247),
    [anon_sym_array_DASHlength] = ACTIONS(247),
    [anon_sym_new_DASHinstance] = ACTIONS(247),
    [anon_sym_new_DASHarray] = ACTIONS(247),
    [anon_sym_filled_DASHnew_DASHarray] = ACTIONS(249),
    [anon_sym_filled_DASHnew_DASHarray_SLASHrange] = ACTIONS(247),
    [anon_sym_fill_DASHarray_DASHdata] = ACTIONS(247),
    [anon_sym_throw] = ACTIONS(249),
    [anon_sym_throw_DASHverification_DASHerror] = ACTIONS(247),
    [anon_sym_goto] = ACTIONS(249),
    [anon_sym_goto_SLASH16] = ACTIONS(247),
    [anon_sym_goto_SLASH32] = ACTIONS(247),
    [anon_sym_packed_DASHswitch] = ACTIONS(247),
    [anon_sym_sparse_DASHswitch] = ACTIONS(247),
    [anon_sym_cmpl_DASHfloat] = ACTIONS(247),
    [anon_sym_cmpg_DASHfloat] = ACTIONS(247),
    [anon_sym_cmpl_DASHdouble] = ACTIONS(247),
    [anon_sym_cmpg_DASHdouble] = ACTIONS(247),
    [anon_sym_cmp_DASHlong] = ACTIONS(247),
    [anon_sym_if_DASHeq] = ACTIONS(249),
    [anon_sym_if_DASHne] = ACTIONS(249),
    [anon_sym_if_DASHlt] = ACTIONS(249),
    [anon_sym_if_DASHge] = ACTIONS(249),
    [anon_sym_if_DASHgt] = ACTIONS(249),
    [anon_sym_if_DASHle] = ACTIONS(249),
    [anon_sym_if_DASHeqz] = ACTIONS(247),
    [anon_sym_if_DASHnez] = ACTIONS(247),
    [anon_sym_if_DASHltz] = ACTIONS(247),
    [anon_sym_if_DASHgez] = ACTIONS(247),
    [anon_sym_if_DASHgtz] = ACTIONS(247),
    [anon_sym_if_DASHlez] = ACTIONS(247),
    [anon_sym_aget] = ACTIONS(249),
    [anon_sym_aget_DASHwide] = ACTIONS(247),
    [anon_sym_aget_DASHobject] = ACTIONS(247),
    [anon_sym_aget_DASHboolean] = ACTIONS(247),
    [anon_sym_aget_DASHbyte] = ACTIONS(247),
    [anon_sym_aget_DASHchar] = ACTIONS(247),
    [anon_sym_aget_DASHshort] = ACTIONS(247),
    [anon_sym_aput] = ACTIONS(249),
    [anon_sym_aput_DASHwide] = ACTIONS(247),
    [anon_sym_aput_DASHobject] = ACTIONS(247),
    [anon_sym_aput_DASHboolean] = ACTIONS(247),
    [anon_sym_aput_DASHbyte] = ACTIONS(247),
    [anon_sym_aput_DASHchar] = ACTIONS(247),
    [anon_sym_aput_DASHshort] = ACTIONS(247),
    [anon_sym_iget] = ACTIONS(249),
    [anon_sym_iget_DASHwide] = ACTIONS(249),
    [anon_sym_iget_DASHobject] = ACTIONS(249),
    [anon_sym_iget_DASHboolean] = ACTIONS(247),
    [anon_sym_iget_DASHbyte] = ACTIONS(247),
    [anon_sym_iget_DASHchar] = ACTIONS(247),
    [anon_sym_iget_DASHshort] = ACTIONS(247),
    [anon_sym_iget_DASHvolatile] = ACTIONS(247),
    [anon_sym_iget_DASHwide_DASHvolatile] = ACTIONS(247),
    [anon_sym_iget_DASHobject_DASHvolatile] = ACTIONS(247),
    [anon_sym_iput] = ACTIONS(249),
    [anon_sym_iput_DASHwide] = ACTIONS(249),
    [anon_sym_iput_DASHobject] = ACTIONS(249),
    [anon_sym_iput_DASHboolean] = ACTIONS(249),
    [anon_sym_iput_DASHbyte] = ACTIONS(249),
    [anon_sym_iput_DASHchar] = ACTIONS(249),
    [anon_sym_iput_DASHshort] = ACTIONS(249),
    [anon_sym_iput_DASHvolatile] = ACTIONS(247),
    [anon_sym_iput_DASHwide_DASHvolatile] = ACTIONS(247),
    [anon_sym_iput_DASHobject_DASHvolatile] = ACTIONS(247),
    [anon_sym_sget] = ACTIONS(249),
    [anon_sym_sget_DASHwide] = ACTIONS(249),
    [anon_sym_sget_DASHobject] = ACTIONS(249),
    [anon_sym_sget_DASHboolean] = ACTIONS(247),
    [anon_sym_sget_DASHbyte] = ACTIONS(247),
    [anon_sym_sget_DASHchar] = ACTIONS(247),
    [anon_sym_sget_DASHshort] = ACTIONS(247),
    [anon_sym_sget_DASHvolatile] = ACTIONS(247),
    [anon_sym_sget_DASHwide_DASHvolatile] = ACTIONS(247),
    [anon_sym_sget_DASHobject_DASHvolatile] = ACTIONS(247),
    [anon_sym_sput] = ACTIONS(249),
    [anon_sym_sput_DASHwide] = ACTIONS(249),
    [anon_sym_sput_DASHobject] = ACTIONS(249),
    [anon_sym_sput_DASHboolean] = ACTIONS(247),
    [anon_sym_sput_DASHbyte] = ACTIONS(247),
    [anon_sym_sput_DASHchar] = ACTIONS(247),
    [anon_sym_sput_DASHshort] = ACTIONS(247),
    [anon_sym_sput_DASHvolatile] = ACTIONS(247),
    [anon_sym_sput_DASHwide_DASHvolatile] = ACTIONS(247),
    [anon_sym_sput_DASHobject_DASHvolatile] = ACTIONS(247),
    [anon_sym_invoke_DASHconstructor] = ACTIONS(247),
    [anon_sym_invoke_DASHcustom] = ACTIONS(249),
    [anon_sym_invoke_DASHdirect] = ACTIONS(249),
    [anon_sym_invoke_DASHdirect_DASHempty] = ACTIONS(247),
    [anon_sym_invoke_DASHinstance] = ACTIONS(247),
    [anon_sym_invoke_DASHinterface] = ACTIONS(249),
    [anon_sym_invoke_DASHpolymorphic] = ACTIONS(249),
    [anon_sym_invoke_DASHstatic] = ACTIONS(249),
    [anon_sym_invoke_DASHsuper] = ACTIONS(249),
    [anon_sym_invoke_DASHvirtual] = ACTIONS(249),
    [anon_sym_invoke_DASHcustom_SLASHrange] = ACTIONS(247),
    [anon_sym_invoke_DASHdirect_SLASHrange] = ACTIONS(247),
    [anon_sym_invoke_DASHinterface_SLASHrange] = ACTIONS(247),
    [anon_sym_invoke_DASHobject_DASHinit_SLASHrange] = ACTIONS(247),
    [anon_sym_invoke_DASHpolymorphic_SLASHrange] = ACTIONS(247),
    [anon_sym_invoke_DASHstatic_SLASHrange] = ACTIONS(247),
    [anon_sym_invoke_DASHsuper_SLASHrange] = ACTIONS(247),
    [anon_sym_invoke_DASHvirtual_SLASHrange] = ACTIONS(247),
    [anon_sym_neg_DASHint] = ACTIONS(247),
    [anon_sym_not_DASHint] = ACTIONS(247),
    [anon_sym_neg_DASHlong] = ACTIONS(247),
    [anon_sym_not_DASHlong] = ACTIONS(247),
    [anon_sym_neg_DASHfloat] = ACTIONS(247),
    [anon_sym_neg_DASHdouble] = ACTIONS(247),
    [anon_sym_int_DASHto_DASHlong] = ACTIONS(247),
    [anon_sym_int_DASHto_DASHfloat] = ACTIONS(247),
    [anon_sym_int_DASHto_DASHdouble] = ACTIONS(247),
    [anon_sym_long_DASHto_DASHint] = ACTIONS(247),
    [anon_sym_long_DASHto_DASHfloat] = ACTIONS(247),
    [anon_sym_long_DASHto_DASHdouble] = ACTIONS(247),
    [anon_sym_float_DASHto_DASHint] = ACTIONS(247),
    [anon_sym_float_DASHto_DASHlong] = ACTIONS(247),
    [anon_sym_float_DASHto_DASHdouble] = ACTIONS(247),
    [anon_sym_double_DASHto_DASHint] = ACTIONS(247),
    [anon_sym_double_DASHto_DASHlong] = ACTIONS(247),
    [anon_sym_double_DASHto_DASHfloat] = ACTIONS(247),
    [anon_sym_int_DASHto_DASHbyte] = ACTIONS(247),
    [anon_sym_int_DASHto_DASHchar] = ACTIONS(247),
    [anon_sym_int_DASHto_DASHshort] = ACTIONS(247),
    [anon_sym_add_DASHint] = ACTIONS(249),
    [anon_sym_sub_DASHint] = ACTIONS(249),
    [anon_sym_mul_DASHint] = ACTIONS(249),
    [anon_sym_div_DASHint] = ACTIONS(249),
    [anon_sym_rem_DASHint] = ACTIONS(249),
    [anon_sym_and_DASHint] = ACTIONS(249),
    [anon_sym_or_DASHint] = ACTIONS(249),
    [anon_sym_xor_DASHint] = ACTIONS(249),
    [anon_sym_shl_DASHint] = ACTIONS(249),
    [anon_sym_shr_DASHint] = ACTIONS(249),
    [anon_sym_ushr_DASHint] = ACTIONS(249),
    [anon_sym_add_DASHlong] = ACTIONS(249),
    [anon_sym_sub_DASHlong] = ACTIONS(249),
    [anon_sym_mul_DASHlong] = ACTIONS(249),
    [anon_sym_div_DASHlong] = ACTIONS(249),
    [anon_sym_rem_DASHlong] = ACTIONS(249),
    [anon_sym_and_DASHlong] = ACTIONS(249),
    [anon_sym_or_DASHlong] = ACTIONS(249),
    [anon_sym_xor_DASHlong] = ACTIONS(249),
    [anon_sym_shl_DASHlong] = ACTIONS(249),
    [anon_sym_shr_DASHlong] = ACTIONS(249),
    [anon_sym_ushr_DASHlong] = ACTIONS(249),
    [anon_sym_add_DASHfloat] = ACTIONS(249),
    [anon_sym_sub_DASHfloat] = ACTIONS(249),
    [anon_sym_mul_DASHfloat] = ACTIONS(249),
    [anon_sym_div_DASHfloat] = ACTIONS(249),
    [anon_sym_rem_DASHfloat] = ACTIONS(249),
    [anon_sym_add_DASHdouble] = ACTIONS(249),
    [anon_sym_sub_DASHdouble] = ACTIONS(249),
    [anon_sym_mul_DASHdouble] = ACTIONS(249),
    [anon_sym_div_DASHdouble] = ACTIONS(249),
    [anon_sym_rem_DASHdouble] = ACTIONS(249),
    [anon_sym_add_DASHint_SLASH2addr] = ACTIONS(247),
    [anon_sym_sub_DASHint_SLASH2addr] = ACTIONS(247),
    [anon_sym_mul_DASHint_SLASH2addr] = ACTIONS(247),
    [anon_sym_div_DASHint_SLASH2addr] = ACTIONS(247),
    [anon_sym_rem_DASHint_SLASH2addr] = ACTIONS(247),
    [anon_sym_and_DASHint_SLASH2addr] = ACTIONS(247),
    [anon_sym_or_DASHint_SLASH2addr] = ACTIONS(247),
    [anon_sym_xor_DASHint_SLASH2addr] = ACTIONS(247),
    [anon_sym_shl_DASHint_SLASH2addr] = ACTIONS(247),
    [anon_sym_shr_DASHint_SLASH2addr] = ACTIONS(247),
    [anon_sym_ushr_DASHint_SLASH2addr] = ACTIONS(247),
    [anon_sym_add_DASHlong_SLASH2addr] = ACTIONS(247),
    [anon_sym_sub_DASHlong_SLASH2addr] = ACTIONS(247),
    [anon_sym_mul_DASHlong_SLASH2addr] = ACTIONS(247),
    [anon_sym_div_DASHlong_SLASH2addr] = ACTIONS(247),
    [anon_sym_rem_DASHlong_SLASH2addr] = ACTIONS(247),
    [anon_sym_and_DASHlong_SLASH2addr] = ACTIONS(247),
    [anon_sym_or_DASHlong_SLASH2addr] = ACTIONS(247),
    [anon_sym_xor_DASHlong_SLASH2addr] = ACTIONS(247),
    [anon_sym_shl_DASHlong_SLASH2addr] = ACTIONS(247),
    [anon_sym_shr_DASHlong_SLASH2addr] = ACTIONS(247),
    [anon_sym_ushr_DASHlong_SLASH2addr] = ACTIONS(247),
    [anon_sym_add_DASHfloat_SLASH2addr] = ACTIONS(247),
    [anon_sym_sub_DASHfloat_SLASH2addr] = ACTIONS(247),
    [anon_sym_mul_DASHfloat_SLASH2addr] = ACTIONS(247),
    [anon_sym_div_DASHfloat_SLASH2addr] = ACTIONS(247),
    [anon_sym_rem_DASHfloat_SLASH2addr] = ACTIONS(247),
    [anon_sym_add_DASHdouble_SLASH2addr] = ACTIONS(247),
    [anon_sym_sub_DASHdouble_SLASH2addr] = ACTIONS(247),
    [anon_sym_mul_DASHdouble_SLASH2addr] = ACTIONS(247),
    [anon_sym_div_DASHdouble_SLASH2addr] = ACTIONS(247),
    [anon_sym_rem_DASHdouble_SLASH2addr] = ACTIONS(247),
    [anon_sym_add_DASHint_SLASHlit16] = ACTIONS(247),
    [anon_sym_sub_DASHint_SLASHlit16] = ACTIONS(247),
    [anon_sym_mul_DASHint_SLASHlit16] = ACTIONS(247),
    [anon_sym_div_DASHint_SLASHlit16] = ACTIONS(247),
    [anon_sym_rem_DASHint_SLASHlit16] = ACTIONS(247),
    [anon_sym_and_DASHint_SLASHlit16] = ACTIONS(247),
    [anon_sym_or_DASHint_SLASHlit16] = ACTIONS(247),
    [anon_sym_xor_DASHint_SLASHlit16] = ACTIONS(247),
    [anon_sym_add_DASHint_SLASHlit8] = ACTIONS(247),
    [anon_sym_sub_DASHint_SLASHlit8] = ACTIONS(247),
    [anon_sym_mul_DASHint_SLASHlit8] = ACTIONS(247),
    [anon_sym_div_DASHint_SLASHlit8] = ACTIONS(247),
    [anon_sym_rem_DASHint_SLASHlit8] = ACTIONS(247),
    [anon_sym_and_DASHint_SLASHlit8] = ACTIONS(247),
    [anon_sym_or_DASHint_SLASHlit8] = ACTIONS(247),
    [anon_sym_xor_DASHint_SLASHlit8] = ACTIONS(247),
    [anon_sym_shl_DASHint_SLASHlit8] = ACTIONS(247),
    [anon_sym_shr_DASHint_SLASHlit8] = ACTIONS(247),
    [anon_sym_ushr_DASHint_SLASHlit8] = ACTIONS(247),
    [anon_sym_static_DASHget] = ACTIONS(247),
    [anon_sym_static_DASHput] = ACTIONS(247),
    [anon_sym_instance_DASHget] = ACTIONS(247),
    [anon_sym_instance_DASHput] = ACTIONS(247),
    [anon_sym_execute_DASHinline] = ACTIONS(249),
    [anon_sym_execute_DASHinline_SLASHrange] = ACTIONS(247),
    [anon_sym_iget_DASHquick] = ACTIONS(247),
    [anon_sym_iget_DASHwide_DASHquick] = ACTIONS(247),
    [anon_sym_iget_DASHobject_DASHquick] = ACTIONS(247),
    [anon_sym_iput_DASHquick] = ACTIONS(247),
    [anon_sym_iput_DASHwide_DASHquick] = ACTIONS(247),
    [anon_sym_iput_DASHobject_DASHquick] = ACTIONS(247),
    [anon_sym_iput_DASHboolean_DASHquick] = ACTIONS(247),
    [anon_sym_iput_DASHbyte_DASHquick] = ACTIONS(247),
    [anon_sym_iput_DASHchar_DASHquick] = ACTIONS(247),
    [anon_sym_iput_DASHshort_DASHquick] = ACTIONS(247),
    [anon_sym_invoke_DASHvirtual_DASHquick] = ACTIONS(249),
    [anon_sym_invoke_DASHvirtual_DASHquick_SLASHrange] = ACTIONS(247),
    [anon_sym_invoke_DASHsuper_DASHquick] = ACTIONS(249),
    [anon_sym_invoke_DASHsuper_DASHquick_SLASHrange] = ACTIONS(247),
    [anon_sym_rsub_DASHint] = ACTIONS(249),
    [anon_sym_rsub_DASHint_SLASHlit8] = ACTIONS(247),
    [anon_sym_DOTline] = ACTIONS(247),
    [anon_sym_DOTlocals] = ACTIONS(247),
    [anon_sym_DOTlocal] = ACTIONS(249),
    [anon_sym_DOTendlocal] = ACTIONS(247),
    [anon_sym_DOTrestartlocal] = ACTIONS(247),
    [anon_sym_DOTregisters] = ACTIONS(247),
    [anon_sym_DOTcatch] = ACTIONS(249),
    [anon_sym_RBRACE] = ACTIONS(247),
    [anon_sym_DOTcatchall] = ACTIONS(247),
    [anon_sym_DOTpacked_DASHswitch] = ACTIONS(247),
    [anon_sym_DOTsparse_DASHswitch] = ACTIONS(247),
    [anon_sym_DASH_GT] = ACTIONS(247),
    [anon_sym_DOTarray_DASHdata] = ACTIONS(247),
    [sym_prologue_directive] = ACTIONS(247),
    [sym_epilogue_directive] = ACTIONS(247),
    [aux_sym_label_token1] = ACTIONS(247),
    [aux_sym_jmp_label_token1] = ACTIONS(247),
    [anon_sym_RPAREN] = ACTIONS(247),
    [sym_comment] = ACTIONS(3),
  },
  [21] = {
    [ts_builtin_sym_end] = ACTIONS(251),
    [anon_sym_DOTsource] = ACTIONS(251),
    [anon_sym_DOTfield] = ACTIONS(251),
    [anon_sym_EQ] = ACTIONS(251),
    [anon_sym_DOTendfield] = ACTIONS(251),
    [anon_sym_DOTmethod] = ACTIONS(251),
    [anon_sym_DOTendmethod] = ACTIONS(251),
    [anon_sym_DOTannotation] = ACTIONS(251),
    [anon_sym_DOTparam] = ACTIONS(253),
    [anon_sym_COMMA] = ACTIONS(251),
    [anon_sym_DOTparameter] = ACTIONS(251),
    [anon_sym_nop] = ACTIONS(253),
    [anon_sym_move] = ACTIONS(253),
    [anon_sym_move_SLASHfrom16] = ACTIONS(251),
    [anon_sym_move_SLASH16] = ACTIONS(251),
    [anon_sym_move_DASHwide] = ACTIONS(253),
    [anon_sym_move_DASHwide_SLASHfrom16] = ACTIONS(251),
    [anon_sym_move_DASHwide_SLASH16] = ACTIONS(251),
    [anon_sym_move_DASHobject] = ACTIONS(253),
    [anon_sym_move_DASHobject_SLASHfrom16] = ACTIONS(251),
    [anon_sym_move_DASHobject_SLASH16] = ACTIONS(251),
    [anon_sym_move_DASHresult] = ACTIONS(253),
    [anon_sym_move_DASHresult_DASHwide] = ACTIONS(251),
    [anon_sym_move_DASHresult_DASHobject] = ACTIONS(251),
    [anon_sym_move_DASHexception] = ACTIONS(251),
    [anon_sym_return_DASHvoid] = ACTIONS(251),
    [anon_sym_return] = ACTIONS(253),
    [anon_sym_return_DASHwide] = ACTIONS(251),
    [anon_sym_return_DASHobject] = ACTIONS(251),
    [anon_sym_const_SLASH4] = ACTIONS(251),
    [anon_sym_const_SLASH16] = ACTIONS(251),
    [anon_sym_const] = ACTIONS(253),
    [anon_sym_const_SLASHhigh16] = ACTIONS(251),
    [anon_sym_const_DASHwide_SLASH16] = ACTIONS(251),
    [anon_sym_const_DASHwide_SLASH32] = ACTIONS(251),
    [anon_sym_const_DASHwide] = ACTIONS(253),
    [anon_sym_const_DASHwide_SLASHhigh16] = ACTIONS(251),
    [anon_sym_const_DASHstring] = ACTIONS(253),
    [anon_sym_const_DASHstring_SLASHjumbo] = ACTIONS(251),
    [anon_sym_const_DASHclass] = ACTIONS(251),
    [anon_sym_const_DASHmethod_DASHhandle] = ACTIONS(251),
    [anon_sym_const_DASHmethod_DASHtype] = ACTIONS(251),
    [anon_sym_monitor_DASHenter] = ACTIONS(251),
    [anon_sym_monitor_DASHexit] = ACTIONS(251),
    [anon_sym_check_DASHcast] = ACTIONS(251),
    [anon_sym_instance_DASHof] = ACTIONS(251),
    [anon_sym_array_DASHlength] = ACTIONS(251),
    [anon_sym_new_DASHinstance] = ACTIONS(251),
    [anon_sym_new_DASHarray] = ACTIONS(251),
    [anon_sym_filled_DASHnew_DASHarray] = ACTIONS(253),
    [anon_sym_filled_DASHnew_DASHarray_SLASHrange] = ACTIONS(251),
    [anon_sym_fill_DASHarray_DASHdata] = ACTIONS(251),
    [anon_sym_throw] = ACTIONS(253),
    [anon_sym_throw_DASHverification_DASHerror] = ACTIONS(251),
    [anon_sym_goto] = ACTIONS(253),
    [anon_sym_goto_SLASH16] = ACTIONS(251),
    [anon_sym_goto_SLASH32] = ACTIONS(251),
    [anon_sym_packed_DASHswitch] = ACTIONS(251),
    [anon_sym_sparse_DASHswitch] = ACTIONS(251),
    [anon_sym_cmpl_DASHfloat] = ACTIONS(251),
    [anon_sym_cmpg_DASHfloat] = ACTIONS(251),
    [anon_sym_cmpl_DASHdouble] = ACTIONS(251),
    [anon_sym_cmpg_DASHdouble] = ACTIONS(251),
    [anon_sym_cmp_DASHlong] = ACTIONS(251),
    [anon_sym_if_DASHeq] = ACTIONS(253),
    [anon_sym_if_DASHne] = ACTIONS(253),
    [anon_sym_if_DASHlt] = ACTIONS(253),
    [anon_sym_if_DASHge] = ACTIONS(253),
    [anon_sym_if_DASHgt] = ACTIONS(253),
    [anon_sym_if_DASHle] = ACTIONS(253),
    [anon_sym_if_DASHeqz] = ACTIONS(251),
    [anon_sym_if_DASHnez] = ACTIONS(251),
    [anon_sym_if_DASHltz] = ACTIONS(251),
    [anon_sym_if_DASHgez] = ACTIONS(251),
    [anon_sym_if_DASHgtz] = ACTIONS(251),
    [anon_sym_if_DASHlez] = ACTIONS(251),
    [anon_sym_aget] = ACTIONS(253),
    [anon_sym_aget_DASHwide] = ACTIONS(251),
    [anon_sym_aget_DASHobject] = ACTIONS(251),
    [anon_sym_aget_DASHboolean] = ACTIONS(251),
    [anon_sym_aget_DASHbyte] = ACTIONS(251),
    [anon_sym_aget_DASHchar] = ACTIONS(251),
    [anon_sym_aget_DASHshort] = ACTIONS(251),
    [anon_sym_aput] = ACTIONS(253),
    [anon_sym_aput_DASHwide] = ACTIONS(251),
    [anon_sym_aput_DASHobject] = ACTIONS(251),
    [anon_sym_aput_DASHboolean] = ACTIONS(251),
    [anon_sym_aput_DASHbyte] = ACTIONS(251),
    [anon_sym_aput_DASHchar] = ACTIONS(251),
    [anon_sym_aput_DASHshort] = ACTIONS(251),
    [anon_sym_iget] = ACTIONS(253),
    [anon_sym_iget_DASHwide] = ACTIONS(253),
    [anon_sym_iget_DASHobject] = ACTIONS(253),
    [anon_sym_iget_DASHboolean] = ACTIONS(251),
    [anon_sym_iget_DASHbyte] = ACTIONS(251),
    [anon_sym_iget_DASHchar] = ACTIONS(251),
    [anon_sym_iget_DASHshort] = ACTIONS(251),
    [anon_sym_iget_DASHvolatile] = ACTIONS(251),
    [anon_sym_iget_DASHwide_DASHvolatile] = ACTIONS(251),
    [anon_sym_iget_DASHobject_DASHvolatile] = ACTIONS(251),
    [anon_sym_iput] = ACTIONS(253),
    [anon_sym_iput_DASHwide] = ACTIONS(253),
    [anon_sym_iput_DASHobject] = ACTIONS(253),
    [anon_sym_iput_DASHboolean] = ACTIONS(253),
    [anon_sym_iput_DASHbyte] = ACTIONS(253),
    [anon_sym_iput_DASHchar] = ACTIONS(253),
    [anon_sym_iput_DASHshort] = ACTIONS(253),
    [anon_sym_iput_DASHvolatile] = ACTIONS(251),
    [anon_sym_iput_DASHwide_DASHvolatile] = ACTIONS(251),
    [anon_sym_iput_DASHobject_DASHvolatile] = ACTIONS(251),
    [anon_sym_sget] = ACTIONS(253),
    [anon_sym_sget_DASHwide] = ACTIONS(253),
    [anon_sym_sget_DASHobject] = ACTIONS(253),
    [anon_sym_sget_DASHboolean] = ACTIONS(251),
    [anon_sym_sget_DASHbyte] = ACTIONS(251),
    [anon_sym_sget_DASHchar] = ACTIONS(251),
    [anon_sym_sget_DASHshort] = ACTIONS(251),
    [anon_sym_sget_DASHvolatile] = ACTIONS(251),
    [anon_sym_sget_DASHwide_DASHvolatile] = ACTIONS(251),
    [anon_sym_sget_DASHobject_DASHvolatile] = ACTIONS(251),
    [anon_sym_sput] = ACTIONS(253),
    [anon_sym_sput_DASHwide] = ACTIONS(253),
    [anon_sym_sput_DASHobject] = ACTIONS(253),
    [anon_sym_sput_DASHboolean] = ACTIONS(251),
    [anon_sym_sput_DASHbyte] = ACTIONS(251),
    [anon_sym_sput_DASHchar] = ACTIONS(251),
    [anon_sym_sput_DASHshort] = ACTIONS(251),
    [anon_sym_sput_DASHvolatile] = ACTIONS(251),
    [anon_sym_sput_DASHwide_DASHvolatile] = ACTIONS(251),
    [anon_sym_sput_DASHobject_DASHvolatile] = ACTIONS(251),
    [anon_sym_invoke_DASHconstructor] = ACTIONS(251),
    [anon_sym_invoke_DASHcustom] = ACTIONS(253),
    [anon_sym_invoke_DASHdirect] = ACTIONS(253),
    [anon_sym_invoke_DASHdirect_DASHempty] = ACTIONS(251),
    [anon_sym_invoke_DASHinstance] = ACTIONS(251),
    [anon_sym_invoke_DASHinterface] = ACTIONS(253),
    [anon_sym_invoke_DASHpolymorphic] = ACTIONS(253),
    [anon_sym_invoke_DASHstatic] = ACTIONS(253),
    [anon_sym_invoke_DASHsuper] = ACTIONS(253),
    [anon_sym_invoke_DASHvirtual] = ACTIONS(253),
    [anon_sym_invoke_DASHcustom_SLASHrange] = ACTIONS(251),
    [anon_sym_invoke_DASHdirect_SLASHrange] = ACTIONS(251),
    [anon_sym_invoke_DASHinterface_SLASHrange] = ACTIONS(251),
    [anon_sym_invoke_DASHobject_DASHinit_SLASHrange] = ACTIONS(251),
    [anon_sym_invoke_DASHpolymorphic_SLASHrange] = ACTIONS(251),
    [anon_sym_invoke_DASHstatic_SLASHrange] = ACTIONS(251),
    [anon_sym_invoke_DASHsuper_SLASHrange] = ACTIONS(251),
    [anon_sym_invoke_DASHvirtual_SLASHrange] = ACTIONS(251),
    [anon_sym_neg_DASHint] = ACTIONS(251),
    [anon_sym_not_DASHint] = ACTIONS(251),
    [anon_sym_neg_DASHlong] = ACTIONS(251),
    [anon_sym_not_DASHlong] = ACTIONS(251),
    [anon_sym_neg_DASHfloat] = ACTIONS(251),
    [anon_sym_neg_DASHdouble] = ACTIONS(251),
    [anon_sym_int_DASHto_DASHlong] = ACTIONS(251),
    [anon_sym_int_DASHto_DASHfloat] = ACTIONS(251),
    [anon_sym_int_DASHto_DASHdouble] = ACTIONS(251),
    [anon_sym_long_DASHto_DASHint] = ACTIONS(251),
    [anon_sym_long_DASHto_DASHfloat] = ACTIONS(251),
    [anon_sym_long_DASHto_DASHdouble] = ACTIONS(251),
    [anon_sym_float_DASHto_DASHint] = ACTIONS(251),
    [anon_sym_float_DASHto_DASHlong] = ACTIONS(251),
    [anon_sym_float_DASHto_DASHdouble] = ACTIONS(251),
    [anon_sym_double_DASHto_DASHint] = ACTIONS(251),
    [anon_sym_double_DASHto_DASHlong] = ACTIONS(251),
    [anon_sym_double_DASHto_DASHfloat] = ACTIONS(251),
    [anon_sym_int_DASHto_DASHbyte] = ACTIONS(251),
    [anon_sym_int_DASHto_DASHchar] = ACTIONS(251),
    [anon_sym_int_DASHto_DASHshort] = ACTIONS(251),
    [anon_sym_add_DASHint] = ACTIONS(253),
    [anon_sym_sub_DASHint] = ACTIONS(253),
    [anon_sym_mul_DASHint] = ACTIONS(253),
    [anon_sym_div_DASHint] = ACTIONS(253),
    [anon_sym_rem_DASHint] = ACTIONS(253),
    [anon_sym_and_DASHint] = ACTIONS(253),
    [anon_sym_or_DASHint] = ACTIONS(253),
    [anon_sym_xor_DASHint] = ACTIONS(253),
    [anon_sym_shl_DASHint] = ACTIONS(253),
    [anon_sym_shr_DASHint] = ACTIONS(253),
    [anon_sym_ushr_DASHint] = ACTIONS(253),
    [anon_sym_add_DASHlong] = ACTIONS(253),
    [anon_sym_sub_DASHlong] = ACTIONS(253),
    [anon_sym_mul_DASHlong] = ACTIONS(253),
    [anon_sym_div_DASHlong] = ACTIONS(253),
    [anon_sym_rem_DASHlong] = ACTIONS(253),
    [anon_sym_and_DASHlong] = ACTIONS(253),
    [anon_sym_or_DASHlong] = ACTIONS(253),
    [anon_sym_xor_DASHlong] = ACTIONS(253),
    [anon_sym_shl_DASHlong] = ACTIONS(253),
    [anon_sym_shr_DASHlong] = ACTIONS(253),
    [anon_sym_ushr_DASHlong] = ACTIONS(253),
    [anon_sym_add_DASHfloat] = ACTIONS(253),
    [anon_sym_sub_DASHfloat] = ACTIONS(253),
    [anon_sym_mul_DASHfloat] = ACTIONS(253),
    [anon_sym_div_DASHfloat] = ACTIONS(253),
    [anon_sym_rem_DASHfloat] = ACTIONS(253),
    [anon_sym_add_DASHdouble] = ACTIONS(253),
    [anon_sym_sub_DASHdouble] = ACTIONS(253),
    [anon_sym_mul_DASHdouble] = ACTIONS(253),
    [anon_sym_div_DASHdouble] = ACTIONS(253),
    [anon_sym_rem_DASHdouble] = ACTIONS(253),
    [anon_sym_add_DASHint_SLASH2addr] = ACTIONS(251),
    [anon_sym_sub_DASHint_SLASH2addr] = ACTIONS(251),
    [anon_sym_mul_DASHint_SLASH2addr] = ACTIONS(251),
    [anon_sym_div_DASHint_SLASH2addr] = ACTIONS(251),
    [anon_sym_rem_DASHint_SLASH2addr] = ACTIONS(251),
    [anon_sym_and_DASHint_SLASH2addr] = ACTIONS(251),
    [anon_sym_or_DASHint_SLASH2addr] = ACTIONS(251),
    [anon_sym_xor_DASHint_SLASH2addr] = ACTIONS(251),
    [anon_sym_shl_DASHint_SLASH2addr] = ACTIONS(251),
    [anon_sym_shr_DASHint_SLASH2addr] = ACTIONS(251),
    [anon_sym_ushr_DASHint_SLASH2addr] = ACTIONS(251),
    [anon_sym_add_DASHlong_SLASH2addr] = ACTIONS(251),
    [anon_sym_sub_DASHlong_SLASH2addr] = ACTIONS(251),
    [anon_sym_mul_DASHlong_SLASH2addr] = ACTIONS(251),
    [anon_sym_div_DASHlong_SLASH2addr] = ACTIONS(251),
    [anon_sym_rem_DASHlong_SLASH2addr] = ACTIONS(251),
    [anon_sym_and_DASHlong_SLASH2addr] = ACTIONS(251),
    [anon_sym_or_DASHlong_SLASH2addr] = ACTIONS(251),
    [anon_sym_xor_DASHlong_SLASH2addr] = ACTIONS(251),
    [anon_sym_shl_DASHlong_SLASH2addr] = ACTIONS(251),
    [anon_sym_shr_DASHlong_SLASH2addr] = ACTIONS(251),
    [anon_sym_ushr_DASHlong_SLASH2addr] = ACTIONS(251),
    [anon_sym_add_DASHfloat_SLASH2addr] = ACTIONS(251),
    [anon_sym_sub_DASHfloat_SLASH2addr] = ACTIONS(251),
    [anon_sym_mul_DASHfloat_SLASH2addr] = ACTIONS(251),
    [anon_sym_div_DASHfloat_SLASH2addr] = ACTIONS(251),
    [anon_sym_rem_DASHfloat_SLASH2addr] = ACTIONS(251),
    [anon_sym_add_DASHdouble_SLASH2addr] = ACTIONS(251),
    [anon_sym_sub_DASHdouble_SLASH2addr] = ACTIONS(251),
    [anon_sym_mul_DASHdouble_SLASH2addr] = ACTIONS(251),
    [anon_sym_div_DASHdouble_SLASH2addr] = ACTIONS(251),
    [anon_sym_rem_DASHdouble_SLASH2addr] = ACTIONS(251),
    [anon_sym_add_DASHint_SLASHlit16] = ACTIONS(251),
    [anon_sym_sub_DASHint_SLASHlit16] = ACTIONS(251),
    [anon_sym_mul_DASHint_SLASHlit16] = ACTIONS(251),
    [anon_sym_div_DASHint_SLASHlit16] = ACTIONS(251),
    [anon_sym_rem_DASHint_SLASHlit16] = ACTIONS(251),
    [anon_sym_and_DASHint_SLASHlit16] = ACTIONS(251),
    [anon_sym_or_DASHint_SLASHlit16] = ACTIONS(251),
    [anon_sym_xor_DASHint_SLASHlit16] = ACTIONS(251),
    [anon_sym_add_DASHint_SLASHlit8] = ACTIONS(251),
    [anon_sym_sub_DASHint_SLASHlit8] = ACTIONS(251),
    [anon_sym_mul_DASHint_SLASHlit8] = ACTIONS(251),
    [anon_sym_div_DASHint_SLASHlit8] = ACTIONS(251),
    [anon_sym_rem_DASHint_SLASHlit8] = ACTIONS(251),
    [anon_sym_and_DASHint_SLASHlit8] = ACTIONS(251),
    [anon_sym_or_DASHint_SLASHlit8] = ACTIONS(251),
    [anon_sym_xor_DASHint_SLASHlit8] = ACTIONS(251),
    [anon_sym_shl_DASHint_SLASHlit8] = ACTIONS(251),
    [anon_sym_shr_DASHint_SLASHlit8] = ACTIONS(251),
    [anon_sym_ushr_DASHint_SLASHlit8] = ACTIONS(251),
    [anon_sym_static_DASHget] = ACTIONS(251),
    [anon_sym_static_DASHput] = ACTIONS(251),
    [anon_sym_instance_DASHget] = ACTIONS(251),
    [anon_sym_instance_DASHput] = ACTIONS(251),
    [anon_sym_execute_DASHinline] = ACTIONS(253),
    [anon_sym_execute_DASHinline_SLASHrange] = ACTIONS(251),
    [anon_sym_iget_DASHquick] = ACTIONS(251),
    [anon_sym_iget_DASHwide_DASHquick] = ACTIONS(251),
    [anon_sym_iget_DASHobject_DASHquick] = ACTIONS(251),
    [anon_sym_iput_DASHquick] = ACTIONS(251),
    [anon_sym_iput_DASHwide_DASHquick] = ACTIONS(251),
    [anon_sym_iput_DASHobject_DASHquick] = ACTIONS(251),
    [anon_sym_iput_DASHboolean_DASHquick] = ACTIONS(251),
    [anon_sym_iput_DASHbyte_DASHquick] = ACTIONS(251),
    [anon_sym_iput_DASHchar_DASHquick] = ACTIONS(251),
    [anon_sym_iput_DASHshort_DASHquick] = ACTIONS(251),
    [anon_sym_invoke_DASHvirtual_DASHquick] = ACTIONS(253),
    [anon_sym_invoke_DASHvirtual_DASHquick_SLASHrange] = ACTIONS(251),
    [anon_sym_invoke_DASHsuper_DASHquick] = ACTIONS(253),
    [anon_sym_invoke_DASHsuper_DASHquick_SLASHrange] = ACTIONS(251),
    [anon_sym_rsub_DASHint] = ACTIONS(253),
    [anon_sym_rsub_DASHint_SLASHlit8] = ACTIONS(251),
    [anon_sym_DOTline] = ACTIONS(251),
    [anon_sym_DOTlocals] = ACTIONS(251),
    [anon_sym_DOTlocal] = ACTIONS(253),
    [anon_sym_DOTendlocal] = ACTIONS(251),
    [anon_sym_DOTrestartlocal] = ACTIONS(251),
    [anon_sym_DOTregisters] = ACTIONS(251),
    [anon_sym_DOTcatch] = ACTIONS(253),
    [anon_sym_RBRACE] = ACTIONS(251),
    [anon_sym_DOTcatchall] = ACTIONS(251),
    [anon_sym_DOTpacked_DASHswitch] = ACTIONS(251),
    [anon_sym_DOTsparse_DASHswitch] = ACTIONS(251),
    [anon_sym_DASH_GT] = ACTIONS(251),
    [anon_sym_DOTarray_DASHdata] = ACTIONS(251),
    [sym_prologue_directive] = ACTIONS(251),
    [sym_epilogue_directive] = ACTIONS(251),
    [aux_sym_label_token1] = ACTIONS(251),
    [aux_sym_jmp_label_token1] = ACTIONS(251),
    [anon_sym_RPAREN] = ACTIONS(251),
    [sym_comment] = ACTIONS(3),
  },
  [22] = {
    [ts_builtin_sym_end] = ACTIONS(255),
    [anon_sym_DOTsource] = ACTIONS(255),
    [anon_sym_DOTfield] = ACTIONS(255),
    [anon_sym_DOTendfield] = ACTIONS(255),
    [anon_sym_DOTmethod] = ACTIONS(255),
    [anon_sym_DOTendmethod] = ACTIONS(255),
    [anon_sym_DOTannotation] = ACTIONS(255),
    [anon_sym_DOTparam] = ACTIONS(257),
    [anon_sym_COMMA] = ACTIONS(255),
    [anon_sym_DOTparameter] = ACTIONS(255),
    [anon_sym_nop] = ACTIONS(257),
    [anon_sym_move] = ACTIONS(257),
    [anon_sym_move_SLASHfrom16] = ACTIONS(255),
    [anon_sym_move_SLASH16] = ACTIONS(255),
    [anon_sym_move_DASHwide] = ACTIONS(257),
    [anon_sym_move_DASHwide_SLASHfrom16] = ACTIONS(255),
    [anon_sym_move_DASHwide_SLASH16] = ACTIONS(255),
    [anon_sym_move_DASHobject] = ACTIONS(257),
    [anon_sym_move_DASHobject_SLASHfrom16] = ACTIONS(255),
    [anon_sym_move_DASHobject_SLASH16] = ACTIONS(255),
    [anon_sym_move_DASHresult] = ACTIONS(257),
    [anon_sym_move_DASHresult_DASHwide] = ACTIONS(255),
    [anon_sym_move_DASHresult_DASHobject] = ACTIONS(255),
    [anon_sym_move_DASHexception] = ACTIONS(255),
    [anon_sym_return_DASHvoid] = ACTIONS(255),
    [anon_sym_return] = ACTIONS(257),
    [anon_sym_return_DASHwide] = ACTIONS(255),
    [anon_sym_return_DASHobject] = ACTIONS(255),
    [anon_sym_const_SLASH4] = ACTIONS(255),
    [anon_sym_const_SLASH16] = ACTIONS(255),
    [anon_sym_const] = ACTIONS(257),
    [anon_sym_const_SLASHhigh16] = ACTIONS(255),
    [anon_sym_const_DASHwide_SLASH16] = ACTIONS(255),
    [anon_sym_const_DASHwide_SLASH32] = ACTIONS(255),
    [anon_sym_const_DASHwide] = ACTIONS(257),
    [anon_sym_const_DASHwide_SLASHhigh16] = ACTIONS(255),
    [anon_sym_const_DASHstring] = ACTIONS(257),
    [anon_sym_const_DASHstring_SLASHjumbo] = ACTIONS(255),
    [anon_sym_const_DASHclass] = ACTIONS(255),
    [anon_sym_const_DASHmethod_DASHhandle] = ACTIONS(255),
    [anon_sym_const_DASHmethod_DASHtype] = ACTIONS(255),
    [anon_sym_monitor_DASHenter] = ACTIONS(255),
    [anon_sym_monitor_DASHexit] = ACTIONS(255),
    [anon_sym_check_DASHcast] = ACTIONS(255),
    [anon_sym_instance_DASHof] = ACTIONS(255),
    [anon_sym_array_DASHlength] = ACTIONS(255),
    [anon_sym_new_DASHinstance] = ACTIONS(255),
    [anon_sym_new_DASHarray] = ACTIONS(255),
    [anon_sym_filled_DASHnew_DASHarray] = ACTIONS(257),
    [anon_sym_filled_DASHnew_DASHarray_SLASHrange] = ACTIONS(255),
    [anon_sym_fill_DASHarray_DASHdata] = ACTIONS(255),
    [anon_sym_throw] = ACTIONS(257),
    [anon_sym_throw_DASHverification_DASHerror] = ACTIONS(255),
    [anon_sym_goto] = ACTIONS(257),
    [anon_sym_goto_SLASH16] = ACTIONS(255),
    [anon_sym_goto_SLASH32] = ACTIONS(255),
    [anon_sym_packed_DASHswitch] = ACTIONS(255),
    [anon_sym_sparse_DASHswitch] = ACTIONS(255),
    [anon_sym_cmpl_DASHfloat] = ACTIONS(255),
    [anon_sym_cmpg_DASHfloat] = ACTIONS(255),
    [anon_sym_cmpl_DASHdouble] = ACTIONS(255),
    [anon_sym_cmpg_DASHdouble] = ACTIONS(255),
    [anon_sym_cmp_DASHlong] = ACTIONS(255),
    [anon_sym_if_DASHeq] = ACTIONS(257),
    [anon_sym_if_DASHne] = ACTIONS(257),
    [anon_sym_if_DASHlt] = ACTIONS(257),
    [anon_sym_if_DASHge] = ACTIONS(257),
    [anon_sym_if_DASHgt] = ACTIONS(257),
    [anon_sym_if_DASHle] = ACTIONS(257),
    [anon_sym_if_DASHeqz] = ACTIONS(255),
    [anon_sym_if_DASHnez] = ACTIONS(255),
    [anon_sym_if_DASHltz] = ACTIONS(255),
    [anon_sym_if_DASHgez] = ACTIONS(255),
    [anon_sym_if_DASHgtz] = ACTIONS(255),
    [anon_sym_if_DASHlez] = ACTIONS(255),
    [anon_sym_aget] = ACTIONS(257),
    [anon_sym_aget_DASHwide] = ACTIONS(255),
    [anon_sym_aget_DASHobject] = ACTIONS(255),
    [anon_sym_aget_DASHboolean] = ACTIONS(255),
    [anon_sym_aget_DASHbyte] = ACTIONS(255),
    [anon_sym_aget_DASHchar] = ACTIONS(255),
    [anon_sym_aget_DASHshort] = ACTIONS(255),
    [anon_sym_aput] = ACTIONS(257),
    [anon_sym_aput_DASHwide] = ACTIONS(255),
    [anon_sym_aput_DASHobject] = ACTIONS(255),
    [anon_sym_aput_DASHboolean] = ACTIONS(255),
    [anon_sym_aput_DASHbyte] = ACTIONS(255),
    [anon_sym_aput_DASHchar] = ACTIONS(255),
    [anon_sym_aput_DASHshort] = ACTIONS(255),
    [anon_sym_iget] = ACTIONS(257),
    [anon_sym_iget_DASHwide] = ACTIONS(257),
    [anon_sym_iget_DASHobject] = ACTIONS(257),
    [anon_sym_iget_DASHboolean] = ACTIONS(255),
    [anon_sym_iget_DASHbyte] = ACTIONS(255),
    [anon_sym_iget_DASHchar] = ACTIONS(255),
    [anon_sym_iget_DASHshort] = ACTIONS(255),
    [anon_sym_iget_DASHvolatile] = ACTIONS(255),
    [anon_sym_iget_DASHwide_DASHvolatile] = ACTIONS(255),
    [anon_sym_iget_DASHobject_DASHvolatile] = ACTIONS(255),
    [anon_sym_iput] = ACTIONS(257),
    [anon_sym_iput_DASHwide] = ACTIONS(257),
    [anon_sym_iput_DASHobject] = ACTIONS(257),
    [anon_sym_iput_DASHboolean] = ACTIONS(257),
    [anon_sym_iput_DASHbyte] = ACTIONS(257),
    [anon_sym_iput_DASHchar] = ACTIONS(257),
    [anon_sym_iput_DASHshort] = ACTIONS(257),
    [anon_sym_iput_DASHvolatile] = ACTIONS(255),
    [anon_sym_iput_DASHwide_DASHvolatile] = ACTIONS(255),
    [anon_sym_iput_DASHobject_DASHvolatile] = ACTIONS(255),
    [anon_sym_sget] = ACTIONS(257),
    [anon_sym_sget_DASHwide] = ACTIONS(257),
    [anon_sym_sget_DASHobject] = ACTIONS(257),
    [anon_sym_sget_DASHboolean] = ACTIONS(255),
    [anon_sym_sget_DASHbyte] = ACTIONS(255),
    [anon_sym_sget_DASHchar] = ACTIONS(255),
    [anon_sym_sget_DASHshort] = ACTIONS(255),
    [anon_sym_sget_DASHvolatile] = ACTIONS(255),
    [anon_sym_sget_DASHwide_DASHvolatile] = ACTIONS(255),
    [anon_sym_sget_DASHobject_DASHvolatile] = ACTIONS(255),
    [anon_sym_sput] = ACTIONS(257),
    [anon_sym_sput_DASHwide] = ACTIONS(257),
    [anon_sym_sput_DASHobject] = ACTIONS(257),
    [anon_sym_sput_DASHboolean] = ACTIONS(255),
    [anon_sym_sput_DASHbyte] = ACTIONS(255),
    [anon_sym_sput_DASHchar] = ACTIONS(255),
    [anon_sym_sput_DASHshort] = ACTIONS(255),
    [anon_sym_sput_DASHvolatile] = ACTIONS(255),
    [anon_sym_sput_DASHwide_DASHvolatile] = ACTIONS(255),
    [anon_sym_sput_DASHobject_DASHvolatile] = ACTIONS(255),
    [anon_sym_invoke_DASHconstructor] = ACTIONS(255),
    [anon_sym_invoke_DASHcustom] = ACTIONS(257),
    [anon_sym_invoke_DASHdirect] = ACTIONS(257),
    [anon_sym_invoke_DASHdirect_DASHempty] = ACTIONS(255),
    [anon_sym_invoke_DASHinstance] = ACTIONS(255),
    [anon_sym_invoke_DASHinterface] = ACTIONS(257),
    [anon_sym_invoke_DASHpolymorphic] = ACTIONS(257),
    [anon_sym_invoke_DASHstatic] = ACTIONS(257),
    [anon_sym_invoke_DASHsuper] = ACTIONS(257),
    [anon_sym_invoke_DASHvirtual] = ACTIONS(257),
    [anon_sym_invoke_DASHcustom_SLASHrange] = ACTIONS(255),
    [anon_sym_invoke_DASHdirect_SLASHrange] = ACTIONS(255),
    [anon_sym_invoke_DASHinterface_SLASHrange] = ACTIONS(255),
    [anon_sym_invoke_DASHobject_DASHinit_SLASHrange] = ACTIONS(255),
    [anon_sym_invoke_DASHpolymorphic_SLASHrange] = ACTIONS(255),
    [anon_sym_invoke_DASHstatic_SLASHrange] = ACTIONS(255),
    [anon_sym_invoke_DASHsuper_SLASHrange] = ACTIONS(255),
    [anon_sym_invoke_DASHvirtual_SLASHrange] = ACTIONS(255),
    [anon_sym_neg_DASHint] = ACTIONS(255),
    [anon_sym_not_DASHint] = ACTIONS(255),
    [anon_sym_neg_DASHlong] = ACTIONS(255),
    [anon_sym_not_DASHlong] = ACTIONS(255),
    [anon_sym_neg_DASHfloat] = ACTIONS(255),
    [anon_sym_neg_DASHdouble] = ACTIONS(255),
    [anon_sym_int_DASHto_DASHlong] = ACTIONS(255),
    [anon_sym_int_DASHto_DASHfloat] = ACTIONS(255),
    [anon_sym_int_DASHto_DASHdouble] = ACTIONS(255),
    [anon_sym_long_DASHto_DASHint] = ACTIONS(255),
    [anon_sym_long_DASHto_DASHfloat] = ACTIONS(255),
    [anon_sym_long_DASHto_DASHdouble] = ACTIONS(255),
    [anon_sym_float_DASHto_DASHint] = ACTIONS(255),
    [anon_sym_float_DASHto_DASHlong] = ACTIONS(255),
    [anon_sym_float_DASHto_DASHdouble] = ACTIONS(255),
    [anon_sym_double_DASHto_DASHint] = ACTIONS(255),
    [anon_sym_double_DASHto_DASHlong] = ACTIONS(255),
    [anon_sym_double_DASHto_DASHfloat] = ACTIONS(255),
    [anon_sym_int_DASHto_DASHbyte] = ACTIONS(255),
    [anon_sym_int_DASHto_DASHchar] = ACTIONS(255),
    [anon_sym_int_DASHto_DASHshort] = ACTIONS(255),
    [anon_sym_add_DASHint] = ACTIONS(257),
    [anon_sym_sub_DASHint] = ACTIONS(257),
    [anon_sym_mul_DASHint] = ACTIONS(257),
    [anon_sym_div_DASHint] = ACTIONS(257),
    [anon_sym_rem_DASHint] = ACTIONS(257),
    [anon_sym_and_DASHint] = ACTIONS(257),
    [anon_sym_or_DASHint] = ACTIONS(257),
    [anon_sym_xor_DASHint] = ACTIONS(257),
    [anon_sym_shl_DASHint] = ACTIONS(257),
    [anon_sym_shr_DASHint] = ACTIONS(257),
    [anon_sym_ushr_DASHint] = ACTIONS(257),
    [anon_sym_add_DASHlong] = ACTIONS(257),
    [anon_sym_sub_DASHlong] = ACTIONS(257),
    [anon_sym_mul_DASHlong] = ACTIONS(257),
    [anon_sym_div_DASHlong] = ACTIONS(257),
    [anon_sym_rem_DASHlong] = ACTIONS(257),
    [anon_sym_and_DASHlong] = ACTIONS(257),
    [anon_sym_or_DASHlong] = ACTIONS(257),
    [anon_sym_xor_DASHlong] = ACTIONS(257),
    [anon_sym_shl_DASHlong] = ACTIONS(257),
    [anon_sym_shr_DASHlong] = ACTIONS(257),
    [anon_sym_ushr_DASHlong] = ACTIONS(257),
    [anon_sym_add_DASHfloat] = ACTIONS(257),
    [anon_sym_sub_DASHfloat] = ACTIONS(257),
    [anon_sym_mul_DASHfloat] = ACTIONS(257),
    [anon_sym_div_DASHfloat] = ACTIONS(257),
    [anon_sym_rem_DASHfloat] = ACTIONS(257),
    [anon_sym_add_DASHdouble] = ACTIONS(257),
    [anon_sym_sub_DASHdouble] = ACTIONS(257),
    [anon_sym_mul_DASHdouble] = ACTIONS(257),
    [anon_sym_div_DASHdouble] = ACTIONS(257),
    [anon_sym_rem_DASHdouble] = ACTIONS(257),
    [anon_sym_add_DASHint_SLASH2addr] = ACTIONS(255),
    [anon_sym_sub_DASHint_SLASH2addr] = ACTIONS(255),
    [anon_sym_mul_DASHint_SLASH2addr] = ACTIONS(255),
    [anon_sym_div_DASHint_SLASH2addr] = ACTIONS(255),
    [anon_sym_rem_DASHint_SLASH2addr] = ACTIONS(255),
    [anon_sym_and_DASHint_SLASH2addr] = ACTIONS(255),
    [anon_sym_or_DASHint_SLASH2addr] = ACTIONS(255),
    [anon_sym_xor_DASHint_SLASH2addr] = ACTIONS(255),
    [anon_sym_shl_DASHint_SLASH2addr] = ACTIONS(255),
    [anon_sym_shr_DASHint_SLASH2addr] = ACTIONS(255),
    [anon_sym_ushr_DASHint_SLASH2addr] = ACTIONS(255),
    [anon_sym_add_DASHlong_SLASH2addr] = ACTIONS(255),
    [anon_sym_sub_DASHlong_SLASH2addr] = ACTIONS(255),
    [anon_sym_mul_DASHlong_SLASH2addr] = ACTIONS(255),
    [anon_sym_div_DASHlong_SLASH2addr] = ACTIONS(255),
    [anon_sym_rem_DASHlong_SLASH2addr] = ACTIONS(255),
    [anon_sym_and_DASHlong_SLASH2addr] = ACTIONS(255),
    [anon_sym_or_DASHlong_SLASH2addr] = ACTIONS(255),
    [anon_sym_xor_DASHlong_SLASH2addr] = ACTIONS(255),
    [anon_sym_shl_DASHlong_SLASH2addr] = ACTIONS(255),
    [anon_sym_shr_DASHlong_SLASH2addr] = ACTIONS(255),
    [anon_sym_ushr_DASHlong_SLASH2addr] = ACTIONS(255),
    [anon_sym_add_DASHfloat_SLASH2addr] = ACTIONS(255),
    [anon_sym_sub_DASHfloat_SLASH2addr] = ACTIONS(255),
    [anon_sym_mul_DASHfloat_SLASH2addr] = ACTIONS(255),
    [anon_sym_div_DASHfloat_SLASH2addr] = ACTIONS(255),
    [anon_sym_rem_DASHfloat_SLASH2addr] = ACTIONS(255),
    [anon_sym_add_DASHdouble_SLASH2addr] = ACTIONS(255),
    [anon_sym_sub_DASHdouble_SLASH2addr] = ACTIONS(255),
    [anon_sym_mul_DASHdouble_SLASH2addr] = ACTIONS(255),
    [anon_sym_div_DASHdouble_SLASH2addr] = ACTIONS(255),
    [anon_sym_rem_DASHdouble_SLASH2addr] = ACTIONS(255),
    [anon_sym_add_DASHint_SLASHlit16] = ACTIONS(255),
    [anon_sym_sub_DASHint_SLASHlit16] = ACTIONS(255),
    [anon_sym_mul_DASHint_SLASHlit16] = ACTIONS(255),
    [anon_sym_div_DASHint_SLASHlit16] = ACTIONS(255),
    [anon_sym_rem_DASHint_SLASHlit16] = ACTIONS(255),
    [anon_sym_and_DASHint_SLASHlit16] = ACTIONS(255),
    [anon_sym_or_DASHint_SLASHlit16] = ACTIONS(255),
    [anon_sym_xor_DASHint_SLASHlit16] = ACTIONS(255),
    [anon_sym_add_DASHint_SLASHlit8] = ACTIONS(255),
    [anon_sym_sub_DASHint_SLASHlit8] = ACTIONS(255),
    [anon_sym_mul_DASHint_SLASHlit8] = ACTIONS(255),
    [anon_sym_div_DASHint_SLASHlit8] = ACTIONS(255),
    [anon_sym_rem_DASHint_SLASHlit8] = ACTIONS(255),
    [anon_sym_and_DASHint_SLASHlit8] = ACTIONS(255),
    [anon_sym_or_DASHint_SLASHlit8] = ACTIONS(255),
    [anon_sym_xor_DASHint_SLASHlit8] = ACTIONS(255),
    [anon_sym_shl_DASHint_SLASHlit8] = ACTIONS(255),
    [anon_sym_shr_DASHint_SLASHlit8] = ACTIONS(255),
    [anon_sym_ushr_DASHint_SLASHlit8] = ACTIONS(255),
    [anon_sym_static_DASHget] = ACTIONS(255),
    [anon_sym_static_DASHput] = ACTIONS(255),
    [anon_sym_instance_DASHget] = ACTIONS(255),
    [anon_sym_instance_DASHput] = ACTIONS(255),
    [anon_sym_execute_DASHinline] = ACTIONS(257),
    [anon_sym_execute_DASHinline_SLASHrange] = ACTIONS(255),
    [anon_sym_iget_DASHquick] = ACTIONS(255),
    [anon_sym_iget_DASHwide_DASHquick] = ACTIONS(255),
    [anon_sym_iget_DASHobject_DASHquick] = ACTIONS(255),
    [anon_sym_iput_DASHquick] = ACTIONS(255),
    [anon_sym_iput_DASHwide_DASHquick] = ACTIONS(255),
    [anon_sym_iput_DASHobject_DASHquick] = ACTIONS(255),
    [anon_sym_iput_DASHboolean_DASHquick] = ACTIONS(255),
    [anon_sym_iput_DASHbyte_DASHquick] = ACTIONS(255),
    [anon_sym_iput_DASHchar_DASHquick] = ACTIONS(255),
    [anon_sym_iput_DASHshort_DASHquick] = ACTIONS(255),
    [anon_sym_invoke_DASHvirtual_DASHquick] = ACTIONS(257),
    [anon_sym_invoke_DASHvirtual_DASHquick_SLASHrange] = ACTIONS(255),
    [anon_sym_invoke_DASHsuper_DASHquick] = ACTIONS(257),
    [anon_sym_invoke_DASHsuper_DASHquick_SLASHrange] = ACTIONS(255),
    [anon_sym_rsub_DASHint] = ACTIONS(257),
    [anon_sym_rsub_DASHint_SLASHlit8] = ACTIONS(255),
    [anon_sym_DOTline] = ACTIONS(255),
    [anon_sym_DOTlocals] = ACTIONS(255),
    [anon_sym_DOTlocal] = ACTIONS(257),
    [anon_sym_DOTendlocal] = ACTIONS(255),
    [anon_sym_DOTrestartlocal] = ACTIONS(255),
    [anon_sym_DOTregisters] = ACTIONS(255),
    [anon_sym_DOTcatch] = ACTIONS(257),
    [anon_sym_DOT_DOT] = ACTIONS(255),
    [anon_sym_RBRACE] = ACTIONS(255),
    [anon_sym_DOTcatchall] = ACTIONS(255),
    [anon_sym_DOTpacked_DASHswitch] = ACTIONS(255),
    [anon_sym_DOTendpacked_DASHswitch] = ACTIONS(255),
    [anon_sym_DOTsparse_DASHswitch] = ACTIONS(255),
    [anon_sym_DOTarray_DASHdata] = ACTIONS(255),
    [sym_prologue_directive] = ACTIONS(255),
    [sym_epilogue_directive] = ACTIONS(255),
    [aux_sym_label_token1] = ACTIONS(255),
    [aux_sym_jmp_label_token1] = ACTIONS(255),
    [sym_comment] = ACTIONS(3),
  },
  [23] = {
    [ts_builtin_sym_end] = ACTIONS(259),
    [anon_sym_DOTsource] = ACTIONS(259),
    [anon_sym_DOTfield] = ACTIONS(259),
    [anon_sym_DOTendfield] = ACTIONS(259),
    [anon_sym_DOTmethod] = ACTIONS(259),
    [anon_sym_DOTendmethod] = ACTIONS(259),
    [anon_sym_DOTannotation] = ACTIONS(259),
    [anon_sym_DOTparam] = ACTIONS(261),
    [anon_sym_COMMA] = ACTIONS(259),
    [anon_sym_DOTparameter] = ACTIONS(259),
    [anon_sym_nop] = ACTIONS(261),
    [anon_sym_move] = ACTIONS(261),
    [anon_sym_move_SLASHfrom16] = ACTIONS(259),
    [anon_sym_move_SLASH16] = ACTIONS(259),
    [anon_sym_move_DASHwide] = ACTIONS(261),
    [anon_sym_move_DASHwide_SLASHfrom16] = ACTIONS(259),
    [anon_sym_move_DASHwide_SLASH16] = ACTIONS(259),
    [anon_sym_move_DASHobject] = ACTIONS(261),
    [anon_sym_move_DASHobject_SLASHfrom16] = ACTIONS(259),
    [anon_sym_move_DASHobject_SLASH16] = ACTIONS(259),
    [anon_sym_move_DASHresult] = ACTIONS(261),
    [anon_sym_move_DASHresult_DASHwide] = ACTIONS(259),
    [anon_sym_move_DASHresult_DASHobject] = ACTIONS(259),
    [anon_sym_move_DASHexception] = ACTIONS(259),
    [anon_sym_return_DASHvoid] = ACTIONS(259),
    [anon_sym_return] = ACTIONS(261),
    [anon_sym_return_DASHwide] = ACTIONS(259),
    [anon_sym_return_DASHobject] = ACTIONS(259),
    [anon_sym_const_SLASH4] = ACTIONS(259),
    [anon_sym_const_SLASH16] = ACTIONS(259),
    [anon_sym_const] = ACTIONS(261),
    [anon_sym_const_SLASHhigh16] = ACTIONS(259),
    [anon_sym_const_DASHwide_SLASH16] = ACTIONS(259),
    [anon_sym_const_DASHwide_SLASH32] = ACTIONS(259),
    [anon_sym_const_DASHwide] = ACTIONS(261),
    [anon_sym_const_DASHwide_SLASHhigh16] = ACTIONS(259),
    [anon_sym_const_DASHstring] = ACTIONS(261),
    [anon_sym_const_DASHstring_SLASHjumbo] = ACTIONS(259),
    [anon_sym_const_DASHclass] = ACTIONS(259),
    [anon_sym_const_DASHmethod_DASHhandle] = ACTIONS(259),
    [anon_sym_const_DASHmethod_DASHtype] = ACTIONS(259),
    [anon_sym_monitor_DASHenter] = ACTIONS(259),
    [anon_sym_monitor_DASHexit] = ACTIONS(259),
    [anon_sym_check_DASHcast] = ACTIONS(259),
    [anon_sym_instance_DASHof] = ACTIONS(259),
    [anon_sym_array_DASHlength] = ACTIONS(259),
    [anon_sym_new_DASHinstance] = ACTIONS(259),
    [anon_sym_new_DASHarray] = ACTIONS(259),
    [anon_sym_filled_DASHnew_DASHarray] = ACTIONS(261),
    [anon_sym_filled_DASHnew_DASHarray_SLASHrange] = ACTIONS(259),
    [anon_sym_fill_DASHarray_DASHdata] = ACTIONS(259),
    [anon_sym_throw] = ACTIONS(261),
    [anon_sym_throw_DASHverification_DASHerror] = ACTIONS(259),
    [anon_sym_goto] = ACTIONS(261),
    [anon_sym_goto_SLASH16] = ACTIONS(259),
    [anon_sym_goto_SLASH32] = ACTIONS(259),
    [anon_sym_packed_DASHswitch] = ACTIONS(259),
    [anon_sym_sparse_DASHswitch] = ACTIONS(259),
    [anon_sym_cmpl_DASHfloat] = ACTIONS(259),
    [anon_sym_cmpg_DASHfloat] = ACTIONS(259),
    [anon_sym_cmpl_DASHdouble] = ACTIONS(259),
    [anon_sym_cmpg_DASHdouble] = ACTIONS(259),
    [anon_sym_cmp_DASHlong] = ACTIONS(259),
    [anon_sym_if_DASHeq] = ACTIONS(261),
    [anon_sym_if_DASHne] = ACTIONS(261),
    [anon_sym_if_DASHlt] = ACTIONS(261),
    [anon_sym_if_DASHge] = ACTIONS(261),
    [anon_sym_if_DASHgt] = ACTIONS(261),
    [anon_sym_if_DASHle] = ACTIONS(261),
    [anon_sym_if_DASHeqz] = ACTIONS(259),
    [anon_sym_if_DASHnez] = ACTIONS(259),
    [anon_sym_if_DASHltz] = ACTIONS(259),
    [anon_sym_if_DASHgez] = ACTIONS(259),
    [anon_sym_if_DASHgtz] = ACTIONS(259),
    [anon_sym_if_DASHlez] = ACTIONS(259),
    [anon_sym_aget] = ACTIONS(261),
    [anon_sym_aget_DASHwide] = ACTIONS(259),
    [anon_sym_aget_DASHobject] = ACTIONS(259),
    [anon_sym_aget_DASHboolean] = ACTIONS(259),
    [anon_sym_aget_DASHbyte] = ACTIONS(259),
    [anon_sym_aget_DASHchar] = ACTIONS(259),
    [anon_sym_aget_DASHshort] = ACTIONS(259),
    [anon_sym_aput] = ACTIONS(261),
    [anon_sym_aput_DASHwide] = ACTIONS(259),
    [anon_sym_aput_DASHobject] = ACTIONS(259),
    [anon_sym_aput_DASHboolean] = ACTIONS(259),
    [anon_sym_aput_DASHbyte] = ACTIONS(259),
    [anon_sym_aput_DASHchar] = ACTIONS(259),
    [anon_sym_aput_DASHshort] = ACTIONS(259),
    [anon_sym_iget] = ACTIONS(261),
    [anon_sym_iget_DASHwide] = ACTIONS(261),
    [anon_sym_iget_DASHobject] = ACTIONS(261),
    [anon_sym_iget_DASHboolean] = ACTIONS(259),
    [anon_sym_iget_DASHbyte] = ACTIONS(259),
    [anon_sym_iget_DASHchar] = ACTIONS(259),
    [anon_sym_iget_DASHshort] = ACTIONS(259),
    [anon_sym_iget_DASHvolatile] = ACTIONS(259),
    [anon_sym_iget_DASHwide_DASHvolatile] = ACTIONS(259),
    [anon_sym_iget_DASHobject_DASHvolatile] = ACTIONS(259),
    [anon_sym_iput] = ACTIONS(261),
    [anon_sym_iput_DASHwide] = ACTIONS(261),
    [anon_sym_iput_DASHobject] = ACTIONS(261),
    [anon_sym_iput_DASHboolean] = ACTIONS(261),
    [anon_sym_iput_DASHbyte] = ACTIONS(261),
    [anon_sym_iput_DASHchar] = ACTIONS(261),
    [anon_sym_iput_DASHshort] = ACTIONS(261),
    [anon_sym_iput_DASHvolatile] = ACTIONS(259),
    [anon_sym_iput_DASHwide_DASHvolatile] = ACTIONS(259),
    [anon_sym_iput_DASHobject_DASHvolatile] = ACTIONS(259),
    [anon_sym_sget] = ACTIONS(261),
    [anon_sym_sget_DASHwide] = ACTIONS(261),
    [anon_sym_sget_DASHobject] = ACTIONS(261),
    [anon_sym_sget_DASHboolean] = ACTIONS(259),
    [anon_sym_sget_DASHbyte] = ACTIONS(259),
    [anon_sym_sget_DASHchar] = ACTIONS(259),
    [anon_sym_sget_DASHshort] = ACTIONS(259),
    [anon_sym_sget_DASHvolatile] = ACTIONS(259),
    [anon_sym_sget_DASHwide_DASHvolatile] = ACTIONS(259),
    [anon_sym_sget_DASHobject_DASHvolatile] = ACTIONS(259),
    [anon_sym_sput] = ACTIONS(261),
    [anon_sym_sput_DASHwide] = ACTIONS(261),
    [anon_sym_sput_DASHobject] = ACTIONS(261),
    [anon_sym_sput_DASHboolean] = ACTIONS(259),
    [anon_sym_sput_DASHbyte] = ACTIONS(259),
    [anon_sym_sput_DASHchar] = ACTIONS(259),
    [anon_sym_sput_DASHshort] = ACTIONS(259),
    [anon_sym_sput_DASHvolatile] = ACTIONS(259),
    [anon_sym_sput_DASHwide_DASHvolatile] = ACTIONS(259),
    [anon_sym_sput_DASHobject_DASHvolatile] = ACTIONS(259),
    [anon_sym_invoke_DASHconstructor] = ACTIONS(259),
    [anon_sym_invoke_DASHcustom] = ACTIONS(261),
    [anon_sym_invoke_DASHdirect] = ACTIONS(261),
    [anon_sym_invoke_DASHdirect_DASHempty] = ACTIONS(259),
    [anon_sym_invoke_DASHinstance] = ACTIONS(259),
    [anon_sym_invoke_DASHinterface] = ACTIONS(261),
    [anon_sym_invoke_DASHpolymorphic] = ACTIONS(261),
    [anon_sym_invoke_DASHstatic] = ACTIONS(261),
    [anon_sym_invoke_DASHsuper] = ACTIONS(261),
    [anon_sym_invoke_DASHvirtual] = ACTIONS(261),
    [anon_sym_invoke_DASHcustom_SLASHrange] = ACTIONS(259),
    [anon_sym_invoke_DASHdirect_SLASHrange] = ACTIONS(259),
    [anon_sym_invoke_DASHinterface_SLASHrange] = ACTIONS(259),
    [anon_sym_invoke_DASHobject_DASHinit_SLASHrange] = ACTIONS(259),
    [anon_sym_invoke_DASHpolymorphic_SLASHrange] = ACTIONS(259),
    [anon_sym_invoke_DASHstatic_SLASHrange] = ACTIONS(259),
    [anon_sym_invoke_DASHsuper_SLASHrange] = ACTIONS(259),
    [anon_sym_invoke_DASHvirtual_SLASHrange] = ACTIONS(259),
    [anon_sym_neg_DASHint] = ACTIONS(259),
    [anon_sym_not_DASHint] = ACTIONS(259),
    [anon_sym_neg_DASHlong] = ACTIONS(259),
    [anon_sym_not_DASHlong] = ACTIONS(259),
    [anon_sym_neg_DASHfloat] = ACTIONS(259),
    [anon_sym_neg_DASHdouble] = ACTIONS(259),
    [anon_sym_int_DASHto_DASHlong] = ACTIONS(259),
    [anon_sym_int_DASHto_DASHfloat] = ACTIONS(259),
    [anon_sym_int_DASHto_DASHdouble] = ACTIONS(259),
    [anon_sym_long_DASHto_DASHint] = ACTIONS(259),
    [anon_sym_long_DASHto_DASHfloat] = ACTIONS(259),
    [anon_sym_long_DASHto_DASHdouble] = ACTIONS(259),
    [anon_sym_float_DASHto_DASHint] = ACTIONS(259),
    [anon_sym_float_DASHto_DASHlong] = ACTIONS(259),
    [anon_sym_float_DASHto_DASHdouble] = ACTIONS(259),
    [anon_sym_double_DASHto_DASHint] = ACTIONS(259),
    [anon_sym_double_DASHto_DASHlong] = ACTIONS(259),
    [anon_sym_double_DASHto_DASHfloat] = ACTIONS(259),
    [anon_sym_int_DASHto_DASHbyte] = ACTIONS(259),
    [anon_sym_int_DASHto_DASHchar] = ACTIONS(259),
    [anon_sym_int_DASHto_DASHshort] = ACTIONS(259),
    [anon_sym_add_DASHint] = ACTIONS(261),
    [anon_sym_sub_DASHint] = ACTIONS(261),
    [anon_sym_mul_DASHint] = ACTIONS(261),
    [anon_sym_div_DASHint] = ACTIONS(261),
    [anon_sym_rem_DASHint] = ACTIONS(261),
    [anon_sym_and_DASHint] = ACTIONS(261),
    [anon_sym_or_DASHint] = ACTIONS(261),
    [anon_sym_xor_DASHint] = ACTIONS(261),
    [anon_sym_shl_DASHint] = ACTIONS(261),
    [anon_sym_shr_DASHint] = ACTIONS(261),
    [anon_sym_ushr_DASHint] = ACTIONS(261),
    [anon_sym_add_DASHlong] = ACTIONS(261),
    [anon_sym_sub_DASHlong] = ACTIONS(261),
    [anon_sym_mul_DASHlong] = ACTIONS(261),
    [anon_sym_div_DASHlong] = ACTIONS(261),
    [anon_sym_rem_DASHlong] = ACTIONS(261),
    [anon_sym_and_DASHlong] = ACTIONS(261),
    [anon_sym_or_DASHlong] = ACTIONS(261),
    [anon_sym_xor_DASHlong] = ACTIONS(261),
    [anon_sym_shl_DASHlong] = ACTIONS(261),
    [anon_sym_shr_DASHlong] = ACTIONS(261),
    [anon_sym_ushr_DASHlong] = ACTIONS(261),
    [anon_sym_add_DASHfloat] = ACTIONS(261),
    [anon_sym_sub_DASHfloat] = ACTIONS(261),
    [anon_sym_mul_DASHfloat] = ACTIONS(261),
    [anon_sym_div_DASHfloat] = ACTIONS(261),
    [anon_sym_rem_DASHfloat] = ACTIONS(261),
    [anon_sym_add_DASHdouble] = ACTIONS(261),
    [anon_sym_sub_DASHdouble] = ACTIONS(261),
    [anon_sym_mul_DASHdouble] = ACTIONS(261),
    [anon_sym_div_DASHdouble] = ACTIONS(261),
    [anon_sym_rem_DASHdouble] = ACTIONS(261),
    [anon_sym_add_DASHint_SLASH2addr] = ACTIONS(259),
    [anon_sym_sub_DASHint_SLASH2addr] = ACTIONS(259),
    [anon_sym_mul_DASHint_SLASH2addr] = ACTIONS(259),
    [anon_sym_div_DASHint_SLASH2addr] = ACTIONS(259),
    [anon_sym_rem_DASHint_SLASH2addr] = ACTIONS(259),
    [anon_sym_and_DASHint_SLASH2addr] = ACTIONS(259),
    [anon_sym_or_DASHint_SLASH2addr] = ACTIONS(259),
    [anon_sym_xor_DASHint_SLASH2addr] = ACTIONS(259),
    [anon_sym_shl_DASHint_SLASH2addr] = ACTIONS(259),
    [anon_sym_shr_DASHint_SLASH2addr] = ACTIONS(259),
    [anon_sym_ushr_DASHint_SLASH2addr] = ACTIONS(259),
    [anon_sym_add_DASHlong_SLASH2addr] = ACTIONS(259),
    [anon_sym_sub_DASHlong_SLASH2addr] = ACTIONS(259),
    [anon_sym_mul_DASHlong_SLASH2addr] = ACTIONS(259),
    [anon_sym_div_DASHlong_SLASH2addr] = ACTIONS(259),
    [anon_sym_rem_DASHlong_SLASH2addr] = ACTIONS(259),
    [anon_sym_and_DASHlong_SLASH2addr] = ACTIONS(259),
    [anon_sym_or_DASHlong_SLASH2addr] = ACTIONS(259),
    [anon_sym_xor_DASHlong_SLASH2addr] = ACTIONS(259),
    [anon_sym_shl_DASHlong_SLASH2addr] = ACTIONS(259),
    [anon_sym_shr_DASHlong_SLASH2addr] = ACTIONS(259),
    [anon_sym_ushr_DASHlong_SLASH2addr] = ACTIONS(259),
    [anon_sym_add_DASHfloat_SLASH2addr] = ACTIONS(259),
    [anon_sym_sub_DASHfloat_SLASH2addr] = ACTIONS(259),
    [anon_sym_mul_DASHfloat_SLASH2addr] = ACTIONS(259),
    [anon_sym_div_DASHfloat_SLASH2addr] = ACTIONS(259),
    [anon_sym_rem_DASHfloat_SLASH2addr] = ACTIONS(259),
    [anon_sym_add_DASHdouble_SLASH2addr] = ACTIONS(259),
    [anon_sym_sub_DASHdouble_SLASH2addr] = ACTIONS(259),
    [anon_sym_mul_DASHdouble_SLASH2addr] = ACTIONS(259),
    [anon_sym_div_DASHdouble_SLASH2addr] = ACTIONS(259),
    [anon_sym_rem_DASHdouble_SLASH2addr] = ACTIONS(259),
    [anon_sym_add_DASHint_SLASHlit16] = ACTIONS(259),
    [anon_sym_sub_DASHint_SLASHlit16] = ACTIONS(259),
    [anon_sym_mul_DASHint_SLASHlit16] = ACTIONS(259),
    [anon_sym_div_DASHint_SLASHlit16] = ACTIONS(259),
    [anon_sym_rem_DASHint_SLASHlit16] = ACTIONS(259),
    [anon_sym_and_DASHint_SLASHlit16] = ACTIONS(259),
    [anon_sym_or_DASHint_SLASHlit16] = ACTIONS(259),
    [anon_sym_xor_DASHint_SLASHlit16] = ACTIONS(259),
    [anon_sym_add_DASHint_SLASHlit8] = ACTIONS(259),
    [anon_sym_sub_DASHint_SLASHlit8] = ACTIONS(259),
    [anon_sym_mul_DASHint_SLASHlit8] = ACTIONS(259),
    [anon_sym_div_DASHint_SLASHlit8] = ACTIONS(259),
    [anon_sym_rem_DASHint_SLASHlit8] = ACTIONS(259),
    [anon_sym_and_DASHint_SLASHlit8] = ACTIONS(259),
    [anon_sym_or_DASHint_SLASHlit8] = ACTIONS(259),
    [anon_sym_xor_DASHint_SLASHlit8] = ACTIONS(259),
    [anon_sym_shl_DASHint_SLASHlit8] = ACTIONS(259),
    [anon_sym_shr_DASHint_SLASHlit8] = ACTIONS(259),
    [anon_sym_ushr_DASHint_SLASHlit8] = ACTIONS(259),
    [anon_sym_static_DASHget] = ACTIONS(259),
    [anon_sym_static_DASHput] = ACTIONS(259),
    [anon_sym_instance_DASHget] = ACTIONS(259),
    [anon_sym_instance_DASHput] = ACTIONS(259),
    [anon_sym_execute_DASHinline] = ACTIONS(261),
    [anon_sym_execute_DASHinline_SLASHrange] = ACTIONS(259),
    [anon_sym_iget_DASHquick] = ACTIONS(259),
    [anon_sym_iget_DASHwide_DASHquick] = ACTIONS(259),
    [anon_sym_iget_DASHobject_DASHquick] = ACTIONS(259),
    [anon_sym_iput_DASHquick] = ACTIONS(259),
    [anon_sym_iput_DASHwide_DASHquick] = ACTIONS(259),
    [anon_sym_iput_DASHobject_DASHquick] = ACTIONS(259),
    [anon_sym_iput_DASHboolean_DASHquick] = ACTIONS(259),
    [anon_sym_iput_DASHbyte_DASHquick] = ACTIONS(259),
    [anon_sym_iput_DASHchar_DASHquick] = ACTIONS(259),
    [anon_sym_iput_DASHshort_DASHquick] = ACTIONS(259),
    [anon_sym_invoke_DASHvirtual_DASHquick] = ACTIONS(261),
    [anon_sym_invoke_DASHvirtual_DASHquick_SLASHrange] = ACTIONS(259),
    [anon_sym_invoke_DASHsuper_DASHquick] = ACTIONS(261),
    [anon_sym_invoke_DASHsuper_DASHquick_SLASHrange] = ACTIONS(259),
    [anon_sym_rsub_DASHint] = ACTIONS(261),
    [anon_sym_rsub_DASHint_SLASHlit8] = ACTIONS(259),
    [anon_sym_DOTline] = ACTIONS(259),
    [anon_sym_DOTlocals] = ACTIONS(259),
    [anon_sym_DOTlocal] = ACTIONS(261),
    [anon_sym_DOTendlocal] = ACTIONS(259),
    [anon_sym_DOTrestartlocal] = ACTIONS(259),
    [anon_sym_DOTregisters] = ACTIONS(259),
    [anon_sym_DOTcatch] = ACTIONS(261),
    [anon_sym_DOT_DOT] = ACTIONS(259),
    [anon_sym_RBRACE] = ACTIONS(259),
    [anon_sym_DOTcatchall] = ACTIONS(259),
    [anon_sym_DOTpacked_DASHswitch] = ACTIONS(259),
    [anon_sym_DOTendpacked_DASHswitch] = ACTIONS(259),
    [anon_sym_DOTsparse_DASHswitch] = ACTIONS(259),
    [anon_sym_DOTarray_DASHdata] = ACTIONS(259),
    [sym_prologue_directive] = ACTIONS(259),
    [sym_epilogue_directive] = ACTIONS(259),
    [aux_sym_label_token1] = ACTIONS(259),
    [aux_sym_jmp_label_token1] = ACTIONS(259),
    [sym_comment] = ACTIONS(3),
  },
  [24] = {
    [ts_builtin_sym_end] = ACTIONS(263),
    [anon_sym_DOTsource] = ACTIONS(263),
    [anon_sym_DOTfield] = ACTIONS(263),
    [anon_sym_DOTendfield] = ACTIONS(263),
    [anon_sym_DOTmethod] = ACTIONS(263),
    [anon_sym_DOTendmethod] = ACTIONS(263),
    [anon_sym_DOTannotation] = ACTIONS(263),
    [anon_sym_DOTparam] = ACTIONS(265),
    [anon_sym_COMMA] = ACTIONS(263),
    [anon_sym_DOTparameter] = ACTIONS(263),
    [anon_sym_DOTendparameter] = ACTIONS(263),
    [anon_sym_nop] = ACTIONS(265),
    [anon_sym_move] = ACTIONS(265),
    [anon_sym_move_SLASHfrom16] = ACTIONS(263),
    [anon_sym_move_SLASH16] = ACTIONS(263),
    [anon_sym_move_DASHwide] = ACTIONS(265),
    [anon_sym_move_DASHwide_SLASHfrom16] = ACTIONS(263),
    [anon_sym_move_DASHwide_SLASH16] = ACTIONS(263),
    [anon_sym_move_DASHobject] = ACTIONS(265),
    [anon_sym_move_DASHobject_SLASHfrom16] = ACTIONS(263),
    [anon_sym_move_DASHobject_SLASH16] = ACTIONS(263),
    [anon_sym_move_DASHresult] = ACTIONS(265),
    [anon_sym_move_DASHresult_DASHwide] = ACTIONS(263),
    [anon_sym_move_DASHresult_DASHobject] = ACTIONS(263),
    [anon_sym_move_DASHexception] = ACTIONS(263),
    [anon_sym_return_DASHvoid] = ACTIONS(263),
    [anon_sym_return] = ACTIONS(265),
    [anon_sym_return_DASHwide] = ACTIONS(263),
    [anon_sym_return_DASHobject] = ACTIONS(263),
    [anon_sym_const_SLASH4] = ACTIONS(263),
    [anon_sym_const_SLASH16] = ACTIONS(263),
    [anon_sym_const] = ACTIONS(265),
    [anon_sym_const_SLASHhigh16] = ACTIONS(263),
    [anon_sym_const_DASHwide_SLASH16] = ACTIONS(263),
    [anon_sym_const_DASHwide_SLASH32] = ACTIONS(263),
    [anon_sym_const_DASHwide] = ACTIONS(265),
    [anon_sym_const_DASHwide_SLASHhigh16] = ACTIONS(263),
    [anon_sym_const_DASHstring] = ACTIONS(265),
    [anon_sym_const_DASHstring_SLASHjumbo] = ACTIONS(263),
    [anon_sym_const_DASHclass] = ACTIONS(263),
    [anon_sym_const_DASHmethod_DASHhandle] = ACTIONS(263),
    [anon_sym_const_DASHmethod_DASHtype] = ACTIONS(263),
    [anon_sym_monitor_DASHenter] = ACTIONS(263),
    [anon_sym_monitor_DASHexit] = ACTIONS(263),
    [anon_sym_check_DASHcast] = ACTIONS(263),
    [anon_sym_instance_DASHof] = ACTIONS(263),
    [anon_sym_array_DASHlength] = ACTIONS(263),
    [anon_sym_new_DASHinstance] = ACTIONS(263),
    [anon_sym_new_DASHarray] = ACTIONS(263),
    [anon_sym_filled_DASHnew_DASHarray] = ACTIONS(265),
    [anon_sym_filled_DASHnew_DASHarray_SLASHrange] = ACTIONS(263),
    [anon_sym_fill_DASHarray_DASHdata] = ACTIONS(263),
    [anon_sym_throw] = ACTIONS(265),
    [anon_sym_throw_DASHverification_DASHerror] = ACTIONS(263),
    [anon_sym_goto] = ACTIONS(265),
    [anon_sym_goto_SLASH16] = ACTIONS(263),
    [anon_sym_goto_SLASH32] = ACTIONS(263),
    [anon_sym_packed_DASHswitch] = ACTIONS(263),
    [anon_sym_sparse_DASHswitch] = ACTIONS(263),
    [anon_sym_cmpl_DASHfloat] = ACTIONS(263),
    [anon_sym_cmpg_DASHfloat] = ACTIONS(263),
    [anon_sym_cmpl_DASHdouble] = ACTIONS(263),
    [anon_sym_cmpg_DASHdouble] = ACTIONS(263),
    [anon_sym_cmp_DASHlong] = ACTIONS(263),
    [anon_sym_if_DASHeq] = ACTIONS(265),
    [anon_sym_if_DASHne] = ACTIONS(265),
    [anon_sym_if_DASHlt] = ACTIONS(265),
    [anon_sym_if_DASHge] = ACTIONS(265),
    [anon_sym_if_DASHgt] = ACTIONS(265),
    [anon_sym_if_DASHle] = ACTIONS(265),
    [anon_sym_if_DASHeqz] = ACTIONS(263),
    [anon_sym_if_DASHnez] = ACTIONS(263),
    [anon_sym_if_DASHltz] = ACTIONS(263),
    [anon_sym_if_DASHgez] = ACTIONS(263),
    [anon_sym_if_DASHgtz] = ACTIONS(263),
    [anon_sym_if_DASHlez] = ACTIONS(263),
    [anon_sym_aget] = ACTIONS(265),
    [anon_sym_aget_DASHwide] = ACTIONS(263),
    [anon_sym_aget_DASHobject] = ACTIONS(263),
    [anon_sym_aget_DASHboolean] = ACTIONS(263),
    [anon_sym_aget_DASHbyte] = ACTIONS(263),
    [anon_sym_aget_DASHchar] = ACTIONS(263),
    [anon_sym_aget_DASHshort] = ACTIONS(263),
    [anon_sym_aput] = ACTIONS(265),
    [anon_sym_aput_DASHwide] = ACTIONS(263),
    [anon_sym_aput_DASHobject] = ACTIONS(263),
    [anon_sym_aput_DASHboolean] = ACTIONS(263),
    [anon_sym_aput_DASHbyte] = ACTIONS(263),
    [anon_sym_aput_DASHchar] = ACTIONS(263),
    [anon_sym_aput_DASHshort] = ACTIONS(263),
    [anon_sym_iget] = ACTIONS(265),
    [anon_sym_iget_DASHwide] = ACTIONS(265),
    [anon_sym_iget_DASHobject] = ACTIONS(265),
    [anon_sym_iget_DASHboolean] = ACTIONS(263),
    [anon_sym_iget_DASHbyte] = ACTIONS(263),
    [anon_sym_iget_DASHchar] = ACTIONS(263),
    [anon_sym_iget_DASHshort] = ACTIONS(263),
    [anon_sym_iget_DASHvolatile] = ACTIONS(263),
    [anon_sym_iget_DASHwide_DASHvolatile] = ACTIONS(263),
    [anon_sym_iget_DASHobject_DASHvolatile] = ACTIONS(263),
    [anon_sym_iput] = ACTIONS(265),
    [anon_sym_iput_DASHwide] = ACTIONS(265),
    [anon_sym_iput_DASHobject] = ACTIONS(265),
    [anon_sym_iput_DASHboolean] = ACTIONS(265),
    [anon_sym_iput_DASHbyte] = ACTIONS(265),
    [anon_sym_iput_DASHchar] = ACTIONS(265),
    [anon_sym_iput_DASHshort] = ACTIONS(265),
    [anon_sym_iput_DASHvolatile] = ACTIONS(263),
    [anon_sym_iput_DASHwide_DASHvolatile] = ACTIONS(263),
    [anon_sym_iput_DASHobject_DASHvolatile] = ACTIONS(263),
    [anon_sym_sget] = ACTIONS(265),
    [anon_sym_sget_DASHwide] = ACTIONS(265),
    [anon_sym_sget_DASHobject] = ACTIONS(265),
    [anon_sym_sget_DASHboolean] = ACTIONS(263),
    [anon_sym_sget_DASHbyte] = ACTIONS(263),
    [anon_sym_sget_DASHchar] = ACTIONS(263),
    [anon_sym_sget_DASHshort] = ACTIONS(263),
    [anon_sym_sget_DASHvolatile] = ACTIONS(263),
    [anon_sym_sget_DASHwide_DASHvolatile] = ACTIONS(263),
    [anon_sym_sget_DASHobject_DASHvolatile] = ACTIONS(263),
    [anon_sym_sput] = ACTIONS(265),
    [anon_sym_sput_DASHwide] = ACTIONS(265),
    [anon_sym_sput_DASHobject] = ACTIONS(265),
    [anon_sym_sput_DASHboolean] = ACTIONS(263),
    [anon_sym_sput_DASHbyte] = ACTIONS(263),
    [anon_sym_sput_DASHchar] = ACTIONS(263),
    [anon_sym_sput_DASHshort] = ACTIONS(263),
    [anon_sym_sput_DASHvolatile] = ACTIONS(263),
    [anon_sym_sput_DASHwide_DASHvolatile] = ACTIONS(263),
    [anon_sym_sput_DASHobject_DASHvolatile] = ACTIONS(263),
    [anon_sym_invoke_DASHconstructor] = ACTIONS(263),
    [anon_sym_invoke_DASHcustom] = ACTIONS(265),
    [anon_sym_invoke_DASHdirect] = ACTIONS(265),
    [anon_sym_invoke_DASHdirect_DASHempty] = ACTIONS(263),
    [anon_sym_invoke_DASHinstance] = ACTIONS(263),
    [anon_sym_invoke_DASHinterface] = ACTIONS(265),
    [anon_sym_invoke_DASHpolymorphic] = ACTIONS(265),
    [anon_sym_invoke_DASHstatic] = ACTIONS(265),
    [anon_sym_invoke_DASHsuper] = ACTIONS(265),
    [anon_sym_invoke_DASHvirtual] = ACTIONS(265),
    [anon_sym_invoke_DASHcustom_SLASHrange] = ACTIONS(263),
    [anon_sym_invoke_DASHdirect_SLASHrange] = ACTIONS(263),
    [anon_sym_invoke_DASHinterface_SLASHrange] = ACTIONS(263),
    [anon_sym_invoke_DASHobject_DASHinit_SLASHrange] = ACTIONS(263),
    [anon_sym_invoke_DASHpolymorphic_SLASHrange] = ACTIONS(263),
    [anon_sym_invoke_DASHstatic_SLASHrange] = ACTIONS(263),
    [anon_sym_invoke_DASHsuper_SLASHrange] = ACTIONS(263),
    [anon_sym_invoke_DASHvirtual_SLASHrange] = ACTIONS(263),
    [anon_sym_neg_DASHint] = ACTIONS(263),
    [anon_sym_not_DASHint] = ACTIONS(263),
    [anon_sym_neg_DASHlong] = ACTIONS(263),
    [anon_sym_not_DASHlong] = ACTIONS(263),
    [anon_sym_neg_DASHfloat] = ACTIONS(263),
    [anon_sym_neg_DASHdouble] = ACTIONS(263),
    [anon_sym_int_DASHto_DASHlong] = ACTIONS(263),
    [anon_sym_int_DASHto_DASHfloat] = ACTIONS(263),
    [anon_sym_int_DASHto_DASHdouble] = ACTIONS(263),
    [anon_sym_long_DASHto_DASHint] = ACTIONS(263),
    [anon_sym_long_DASHto_DASHfloat] = ACTIONS(263),
    [anon_sym_long_DASHto_DASHdouble] = ACTIONS(263),
    [anon_sym_float_DASHto_DASHint] = ACTIONS(263),
    [anon_sym_float_DASHto_DASHlong] = ACTIONS(263),
    [anon_sym_float_DASHto_DASHdouble] = ACTIONS(263),
    [anon_sym_double_DASHto_DASHint] = ACTIONS(263),
    [anon_sym_double_DASHto_DASHlong] = ACTIONS(263),
    [anon_sym_double_DASHto_DASHfloat] = ACTIONS(263),
    [anon_sym_int_DASHto_DASHbyte] = ACTIONS(263),
    [anon_sym_int_DASHto_DASHchar] = ACTIONS(263),
    [anon_sym_int_DASHto_DASHshort] = ACTIONS(263),
    [anon_sym_add_DASHint] = ACTIONS(265),
    [anon_sym_sub_DASHint] = ACTIONS(265),
    [anon_sym_mul_DASHint] = ACTIONS(265),
    [anon_sym_div_DASHint] = ACTIONS(265),
    [anon_sym_rem_DASHint] = ACTIONS(265),
    [anon_sym_and_DASHint] = ACTIONS(265),
    [anon_sym_or_DASHint] = ACTIONS(265),
    [anon_sym_xor_DASHint] = ACTIONS(265),
    [anon_sym_shl_DASHint] = ACTIONS(265),
    [anon_sym_shr_DASHint] = ACTIONS(265),
    [anon_sym_ushr_DASHint] = ACTIONS(265),
    [anon_sym_add_DASHlong] = ACTIONS(265),
    [anon_sym_sub_DASHlong] = ACTIONS(265),
    [anon_sym_mul_DASHlong] = ACTIONS(265),
    [anon_sym_div_DASHlong] = ACTIONS(265),
    [anon_sym_rem_DASHlong] = ACTIONS(265),
    [anon_sym_and_DASHlong] = ACTIONS(265),
    [anon_sym_or_DASHlong] = ACTIONS(265),
    [anon_sym_xor_DASHlong] = ACTIONS(265),
    [anon_sym_shl_DASHlong] = ACTIONS(265),
    [anon_sym_shr_DASHlong] = ACTIONS(265),
    [anon_sym_ushr_DASHlong] = ACTIONS(265),
    [anon_sym_add_DASHfloat] = ACTIONS(265),
    [anon_sym_sub_DASHfloat] = ACTIONS(265),
    [anon_sym_mul_DASHfloat] = ACTIONS(265),
    [anon_sym_div_DASHfloat] = ACTIONS(265),
    [anon_sym_rem_DASHfloat] = ACTIONS(265),
    [anon_sym_add_DASHdouble] = ACTIONS(265),
    [anon_sym_sub_DASHdouble] = ACTIONS(265),
    [anon_sym_mul_DASHdouble] = ACTIONS(265),
    [anon_sym_div_DASHdouble] = ACTIONS(265),
    [anon_sym_rem_DASHdouble] = ACTIONS(265),
    [anon_sym_add_DASHint_SLASH2addr] = ACTIONS(263),
    [anon_sym_sub_DASHint_SLASH2addr] = ACTIONS(263),
    [anon_sym_mul_DASHint_SLASH2addr] = ACTIONS(263),
    [anon_sym_div_DASHint_SLASH2addr] = ACTIONS(263),
    [anon_sym_rem_DASHint_SLASH2addr] = ACTIONS(263),
    [anon_sym_and_DASHint_SLASH2addr] = ACTIONS(263),
    [anon_sym_or_DASHint_SLASH2addr] = ACTIONS(263),
    [anon_sym_xor_DASHint_SLASH2addr] = ACTIONS(263),
    [anon_sym_shl_DASHint_SLASH2addr] = ACTIONS(263),
    [anon_sym_shr_DASHint_SLASH2addr] = ACTIONS(263),
    [anon_sym_ushr_DASHint_SLASH2addr] = ACTIONS(263),
    [anon_sym_add_DASHlong_SLASH2addr] = ACTIONS(263),
    [anon_sym_sub_DASHlong_SLASH2addr] = ACTIONS(263),
    [anon_sym_mul_DASHlong_SLASH2addr] = ACTIONS(263),
    [anon_sym_div_DASHlong_SLASH2addr] = ACTIONS(263),
    [anon_sym_rem_DASHlong_SLASH2addr] = ACTIONS(263),
    [anon_sym_and_DASHlong_SLASH2addr] = ACTIONS(263),
    [anon_sym_or_DASHlong_SLASH2addr] = ACTIONS(263),
    [anon_sym_xor_DASHlong_SLASH2addr] = ACTIONS(263),
    [anon_sym_shl_DASHlong_SLASH2addr] = ACTIONS(263),
    [anon_sym_shr_DASHlong_SLASH2addr] = ACTIONS(263),
    [anon_sym_ushr_DASHlong_SLASH2addr] = ACTIONS(263),
    [anon_sym_add_DASHfloat_SLASH2addr] = ACTIONS(263),
    [anon_sym_sub_DASHfloat_SLASH2addr] = ACTIONS(263),
    [anon_sym_mul_DASHfloat_SLASH2addr] = ACTIONS(263),
    [anon_sym_div_DASHfloat_SLASH2addr] = ACTIONS(263),
    [anon_sym_rem_DASHfloat_SLASH2addr] = ACTIONS(263),
    [anon_sym_add_DASHdouble_SLASH2addr] = ACTIONS(263),
    [anon_sym_sub_DASHdouble_SLASH2addr] = ACTIONS(263),
    [anon_sym_mul_DASHdouble_SLASH2addr] = ACTIONS(263),
    [anon_sym_div_DASHdouble_SLASH2addr] = ACTIONS(263),
    [anon_sym_rem_DASHdouble_SLASH2addr] = ACTIONS(263),
    [anon_sym_add_DASHint_SLASHlit16] = ACTIONS(263),
    [anon_sym_sub_DASHint_SLASHlit16] = ACTIONS(263),
    [anon_sym_mul_DASHint_SLASHlit16] = ACTIONS(263),
    [anon_sym_div_DASHint_SLASHlit16] = ACTIONS(263),
    [anon_sym_rem_DASHint_SLASHlit16] = ACTIONS(263),
    [anon_sym_and_DASHint_SLASHlit16] = ACTIONS(263),
    [anon_sym_or_DASHint_SLASHlit16] = ACTIONS(263),
    [anon_sym_xor_DASHint_SLASHlit16] = ACTIONS(263),
    [anon_sym_add_DASHint_SLASHlit8] = ACTIONS(263),
    [anon_sym_sub_DASHint_SLASHlit8] = ACTIONS(263),
    [anon_sym_mul_DASHint_SLASHlit8] = ACTIONS(263),
    [anon_sym_div_DASHint_SLASHlit8] = ACTIONS(263),
    [anon_sym_rem_DASHint_SLASHlit8] = ACTIONS(263),
    [anon_sym_and_DASHint_SLASHlit8] = ACTIONS(263),
    [anon_sym_or_DASHint_SLASHlit8] = ACTIONS(263),
    [anon_sym_xor_DASHint_SLASHlit8] = ACTIONS(263),
    [anon_sym_shl_DASHint_SLASHlit8] = ACTIONS(263),
    [anon_sym_shr_DASHint_SLASHlit8] = ACTIONS(263),
    [anon_sym_ushr_DASHint_SLASHlit8] = ACTIONS(263),
    [anon_sym_static_DASHget] = ACTIONS(263),
    [anon_sym_static_DASHput] = ACTIONS(263),
    [anon_sym_instance_DASHget] = ACTIONS(263),
    [anon_sym_instance_DASHput] = ACTIONS(263),
    [anon_sym_execute_DASHinline] = ACTIONS(265),
    [anon_sym_execute_DASHinline_SLASHrange] = ACTIONS(263),
    [anon_sym_iget_DASHquick] = ACTIONS(263),
    [anon_sym_iget_DASHwide_DASHquick] = ACTIONS(263),
    [anon_sym_iget_DASHobject_DASHquick] = ACTIONS(263),
    [anon_sym_iput_DASHquick] = ACTIONS(263),
    [anon_sym_iput_DASHwide_DASHquick] = ACTIONS(263),
    [anon_sym_iput_DASHobject_DASHquick] = ACTIONS(263),
    [anon_sym_iput_DASHboolean_DASHquick] = ACTIONS(263),
    [anon_sym_iput_DASHbyte_DASHquick] = ACTIONS(263),
    [anon_sym_iput_DASHchar_DASHquick] = ACTIONS(263),
    [anon_sym_iput_DASHshort_DASHquick] = ACTIONS(263),
    [anon_sym_invoke_DASHvirtual_DASHquick] = ACTIONS(265),
    [anon_sym_invoke_DASHvirtual_DASHquick_SLASHrange] = ACTIONS(263),
    [anon_sym_invoke_DASHsuper_DASHquick] = ACTIONS(265),
    [anon_sym_invoke_DASHsuper_DASHquick_SLASHrange] = ACTIONS(263),
    [anon_sym_rsub_DASHint] = ACTIONS(265),
    [anon_sym_rsub_DASHint_SLASHlit8] = ACTIONS(263),
    [anon_sym_DOTline] = ACTIONS(263),
    [anon_sym_DOTlocals] = ACTIONS(263),
    [anon_sym_DOTlocal] = ACTIONS(265),
    [anon_sym_DOTendlocal] = ACTIONS(263),
    [anon_sym_DOTrestartlocal] = ACTIONS(263),
    [anon_sym_DOTregisters] = ACTIONS(263),
    [anon_sym_DOTcatch] = ACTIONS(265),
    [anon_sym_RBRACE] = ACTIONS(263),
    [anon_sym_DOTcatchall] = ACTIONS(263),
    [anon_sym_DOTpacked_DASHswitch] = ACTIONS(263),
    [anon_sym_DOTsparse_DASHswitch] = ACTIONS(263),
    [anon_sym_DOTarray_DASHdata] = ACTIONS(263),
    [sym_prologue_directive] = ACTIONS(263),
    [sym_epilogue_directive] = ACTIONS(263),
    [aux_sym_label_token1] = ACTIONS(263),
    [aux_sym_jmp_label_token1] = ACTIONS(263),
    [sym_comment] = ACTIONS(3),
  },
  [25] = {
    [ts_builtin_sym_end] = ACTIONS(267),
    [anon_sym_DOTsource] = ACTIONS(267),
    [anon_sym_DOTfield] = ACTIONS(267),
    [anon_sym_DOTendfield] = ACTIONS(267),
    [anon_sym_DOTmethod] = ACTIONS(267),
    [anon_sym_DOTendmethod] = ACTIONS(267),
    [anon_sym_DOTannotation] = ACTIONS(267),
    [anon_sym_DOTparam] = ACTIONS(269),
    [anon_sym_COMMA] = ACTIONS(267),
    [anon_sym_DOTparameter] = ACTIONS(267),
    [anon_sym_DOTendparameter] = ACTIONS(267),
    [anon_sym_nop] = ACTIONS(269),
    [anon_sym_move] = ACTIONS(269),
    [anon_sym_move_SLASHfrom16] = ACTIONS(267),
    [anon_sym_move_SLASH16] = ACTIONS(267),
    [anon_sym_move_DASHwide] = ACTIONS(269),
    [anon_sym_move_DASHwide_SLASHfrom16] = ACTIONS(267),
    [anon_sym_move_DASHwide_SLASH16] = ACTIONS(267),
    [anon_sym_move_DASHobject] = ACTIONS(269),
    [anon_sym_move_DASHobject_SLASHfrom16] = ACTIONS(267),
    [anon_sym_move_DASHobject_SLASH16] = ACTIONS(267),
    [anon_sym_move_DASHresult] = ACTIONS(269),
    [anon_sym_move_DASHresult_DASHwide] = ACTIONS(267),
    [anon_sym_move_DASHresult_DASHobject] = ACTIONS(267),
    [anon_sym_move_DASHexception] = ACTIONS(267),
    [anon_sym_return_DASHvoid] = ACTIONS(267),
    [anon_sym_return] = ACTIONS(269),
    [anon_sym_return_DASHwide] = ACTIONS(267),
    [anon_sym_return_DASHobject] = ACTIONS(267),
    [anon_sym_const_SLASH4] = ACTIONS(267),
    [anon_sym_const_SLASH16] = ACTIONS(267),
    [anon_sym_const] = ACTIONS(269),
    [anon_sym_const_SLASHhigh16] = ACTIONS(267),
    [anon_sym_const_DASHwide_SLASH16] = ACTIONS(267),
    [anon_sym_const_DASHwide_SLASH32] = ACTIONS(267),
    [anon_sym_const_DASHwide] = ACTIONS(269),
    [anon_sym_const_DASHwide_SLASHhigh16] = ACTIONS(267),
    [anon_sym_const_DASHstring] = ACTIONS(269),
    [anon_sym_const_DASHstring_SLASHjumbo] = ACTIONS(267),
    [anon_sym_const_DASHclass] = ACTIONS(267),
    [anon_sym_const_DASHmethod_DASHhandle] = ACTIONS(267),
    [anon_sym_const_DASHmethod_DASHtype] = ACTIONS(267),
    [anon_sym_monitor_DASHenter] = ACTIONS(267),
    [anon_sym_monitor_DASHexit] = ACTIONS(267),
    [anon_sym_check_DASHcast] = ACTIONS(267),
    [anon_sym_instance_DASHof] = ACTIONS(267),
    [anon_sym_array_DASHlength] = ACTIONS(267),
    [anon_sym_new_DASHinstance] = ACTIONS(267),
    [anon_sym_new_DASHarray] = ACTIONS(267),
    [anon_sym_filled_DASHnew_DASHarray] = ACTIONS(269),
    [anon_sym_filled_DASHnew_DASHarray_SLASHrange] = ACTIONS(267),
    [anon_sym_fill_DASHarray_DASHdata] = ACTIONS(267),
    [anon_sym_throw] = ACTIONS(269),
    [anon_sym_throw_DASHverification_DASHerror] = ACTIONS(267),
    [anon_sym_goto] = ACTIONS(269),
    [anon_sym_goto_SLASH16] = ACTIONS(267),
    [anon_sym_goto_SLASH32] = ACTIONS(267),
    [anon_sym_packed_DASHswitch] = ACTIONS(267),
    [anon_sym_sparse_DASHswitch] = ACTIONS(267),
    [anon_sym_cmpl_DASHfloat] = ACTIONS(267),
    [anon_sym_cmpg_DASHfloat] = ACTIONS(267),
    [anon_sym_cmpl_DASHdouble] = ACTIONS(267),
    [anon_sym_cmpg_DASHdouble] = ACTIONS(267),
    [anon_sym_cmp_DASHlong] = ACTIONS(267),
    [anon_sym_if_DASHeq] = ACTIONS(269),
    [anon_sym_if_DASHne] = ACTIONS(269),
    [anon_sym_if_DASHlt] = ACTIONS(269),
    [anon_sym_if_DASHge] = ACTIONS(269),
    [anon_sym_if_DASHgt] = ACTIONS(269),
    [anon_sym_if_DASHle] = ACTIONS(269),
    [anon_sym_if_DASHeqz] = ACTIONS(267),
    [anon_sym_if_DASHnez] = ACTIONS(267),
    [anon_sym_if_DASHltz] = ACTIONS(267),
    [anon_sym_if_DASHgez] = ACTIONS(267),
    [anon_sym_if_DASHgtz] = ACTIONS(267),
    [anon_sym_if_DASHlez] = ACTIONS(267),
    [anon_sym_aget] = ACTIONS(269),
    [anon_sym_aget_DASHwide] = ACTIONS(267),
    [anon_sym_aget_DASHobject] = ACTIONS(267),
    [anon_sym_aget_DASHboolean] = ACTIONS(267),
    [anon_sym_aget_DASHbyte] = ACTIONS(267),
    [anon_sym_aget_DASHchar] = ACTIONS(267),
    [anon_sym_aget_DASHshort] = ACTIONS(267),
    [anon_sym_aput] = ACTIONS(269),
    [anon_sym_aput_DASHwide] = ACTIONS(267),
    [anon_sym_aput_DASHobject] = ACTIONS(267),
    [anon_sym_aput_DASHboolean] = ACTIONS(267),
    [anon_sym_aput_DASHbyte] = ACTIONS(267),
    [anon_sym_aput_DASHchar] = ACTIONS(267),
    [anon_sym_aput_DASHshort] = ACTIONS(267),
    [anon_sym_iget] = ACTIONS(269),
    [anon_sym_iget_DASHwide] = ACTIONS(269),
    [anon_sym_iget_DASHobject] = ACTIONS(269),
    [anon_sym_iget_DASHboolean] = ACTIONS(267),
    [anon_sym_iget_DASHbyte] = ACTIONS(267),
    [anon_sym_iget_DASHchar] = ACTIONS(267),
    [anon_sym_iget_DASHshort] = ACTIONS(267),
    [anon_sym_iget_DASHvolatile] = ACTIONS(267),
    [anon_sym_iget_DASHwide_DASHvolatile] = ACTIONS(267),
    [anon_sym_iget_DASHobject_DASHvolatile] = ACTIONS(267),
    [anon_sym_iput] = ACTIONS(269),
    [anon_sym_iput_DASHwide] = ACTIONS(269),
    [anon_sym_iput_DASHobject] = ACTIONS(269),
    [anon_sym_iput_DASHboolean] = ACTIONS(269),
    [anon_sym_iput_DASHbyte] = ACTIONS(269),
    [anon_sym_iput_DASHchar] = ACTIONS(269),
    [anon_sym_iput_DASHshort] = ACTIONS(269),
    [anon_sym_iput_DASHvolatile] = ACTIONS(267),
    [anon_sym_iput_DASHwide_DASHvolatile] = ACTIONS(267),
    [anon_sym_iput_DASHobject_DASHvolatile] = ACTIONS(267),
    [anon_sym_sget] = ACTIONS(269),
    [anon_sym_sget_DASHwide] = ACTIONS(269),
    [anon_sym_sget_DASHobject] = ACTIONS(269),
    [anon_sym_sget_DASHboolean] = ACTIONS(267),
    [anon_sym_sget_DASHbyte] = ACTIONS(267),
    [anon_sym_sget_DASHchar] = ACTIONS(267),
    [anon_sym_sget_DASHshort] = ACTIONS(267),
    [anon_sym_sget_DASHvolatile] = ACTIONS(267),
    [anon_sym_sget_DASHwide_DASHvolatile] = ACTIONS(267),
    [anon_sym_sget_DASHobject_DASHvolatile] = ACTIONS(267),
    [anon_sym_sput] = ACTIONS(269),
    [anon_sym_sput_DASHwide] = ACTIONS(269),
    [anon_sym_sput_DASHobject] = ACTIONS(269),
    [anon_sym_sput_DASHboolean] = ACTIONS(267),
    [anon_sym_sput_DASHbyte] = ACTIONS(267),
    [anon_sym_sput_DASHchar] = ACTIONS(267),
    [anon_sym_sput_DASHshort] = ACTIONS(267),
    [anon_sym_sput_DASHvolatile] = ACTIONS(267),
    [anon_sym_sput_DASHwide_DASHvolatile] = ACTIONS(267),
    [anon_sym_sput_DASHobject_DASHvolatile] = ACTIONS(267),
    [anon_sym_invoke_DASHconstructor] = ACTIONS(267),
    [anon_sym_invoke_DASHcustom] = ACTIONS(269),
    [anon_sym_invoke_DASHdirect] = ACTIONS(269),
    [anon_sym_invoke_DASHdirect_DASHempty] = ACTIONS(267),
    [anon_sym_invoke_DASHinstance] = ACTIONS(267),
    [anon_sym_invoke_DASHinterface] = ACTIONS(269),
    [anon_sym_invoke_DASHpolymorphic] = ACTIONS(269),
    [anon_sym_invoke_DASHstatic] = ACTIONS(269),
    [anon_sym_invoke_DASHsuper] = ACTIONS(269),
    [anon_sym_invoke_DASHvirtual] = ACTIONS(269),
    [anon_sym_invoke_DASHcustom_SLASHrange] = ACTIONS(267),
    [anon_sym_invoke_DASHdirect_SLASHrange] = ACTIONS(267),
    [anon_sym_invoke_DASHinterface_SLASHrange] = ACTIONS(267),
    [anon_sym_invoke_DASHobject_DASHinit_SLASHrange] = ACTIONS(267),
    [anon_sym_invoke_DASHpolymorphic_SLASHrange] = ACTIONS(267),
    [anon_sym_invoke_DASHstatic_SLASHrange] = ACTIONS(267),
    [anon_sym_invoke_DASHsuper_SLASHrange] = ACTIONS(267),
    [anon_sym_invoke_DASHvirtual_SLASHrange] = ACTIONS(267),
    [anon_sym_neg_DASHint] = ACTIONS(267),
    [anon_sym_not_DASHint] = ACTIONS(267),
    [anon_sym_neg_DASHlong] = ACTIONS(267),
    [anon_sym_not_DASHlong] = ACTIONS(267),
    [anon_sym_neg_DASHfloat] = ACTIONS(267),
    [anon_sym_neg_DASHdouble] = ACTIONS(267),
    [anon_sym_int_DASHto_DASHlong] = ACTIONS(267),
    [anon_sym_int_DASHto_DASHfloat] = ACTIONS(267),
    [anon_sym_int_DASHto_DASHdouble] = ACTIONS(267),
    [anon_sym_long_DASHto_DASHint] = ACTIONS(267),
    [anon_sym_long_DASHto_DASHfloat] = ACTIONS(267),
    [anon_sym_long_DASHto_DASHdouble] = ACTIONS(267),
    [anon_sym_float_DASHto_DASHint] = ACTIONS(267),
    [anon_sym_float_DASHto_DASHlong] = ACTIONS(267),
    [anon_sym_float_DASHto_DASHdouble] = ACTIONS(267),
    [anon_sym_double_DASHto_DASHint] = ACTIONS(267),
    [anon_sym_double_DASHto_DASHlong] = ACTIONS(267),
    [anon_sym_double_DASHto_DASHfloat] = ACTIONS(267),
    [anon_sym_int_DASHto_DASHbyte] = ACTIONS(267),
    [anon_sym_int_DASHto_DASHchar] = ACTIONS(267),
    [anon_sym_int_DASHto_DASHshort] = ACTIONS(267),
    [anon_sym_add_DASHint] = ACTIONS(269),
    [anon_sym_sub_DASHint] = ACTIONS(269),
    [anon_sym_mul_DASHint] = ACTIONS(269),
    [anon_sym_div_DASHint] = ACTIONS(269),
    [anon_sym_rem_DASHint] = ACTIONS(269),
    [anon_sym_and_DASHint] = ACTIONS(269),
    [anon_sym_or_DASHint] = ACTIONS(269),
    [anon_sym_xor_DASHint] = ACTIONS(269),
    [anon_sym_shl_DASHint] = ACTIONS(269),
    [anon_sym_shr_DASHint] = ACTIONS(269),
    [anon_sym_ushr_DASHint] = ACTIONS(269),
    [anon_sym_add_DASHlong] = ACTIONS(269),
    [anon_sym_sub_DASHlong] = ACTIONS(269),
    [anon_sym_mul_DASHlong] = ACTIONS(269),
    [anon_sym_div_DASHlong] = ACTIONS(269),
    [anon_sym_rem_DASHlong] = ACTIONS(269),
    [anon_sym_and_DASHlong] = ACTIONS(269),
    [anon_sym_or_DASHlong] = ACTIONS(269),
    [anon_sym_xor_DASHlong] = ACTIONS(269),
    [anon_sym_shl_DASHlong] = ACTIONS(269),
    [anon_sym_shr_DASHlong] = ACTIONS(269),
    [anon_sym_ushr_DASHlong] = ACTIONS(269),
    [anon_sym_add_DASHfloat] = ACTIONS(269),
    [anon_sym_sub_DASHfloat] = ACTIONS(269),
    [anon_sym_mul_DASHfloat] = ACTIONS(269),
    [anon_sym_div_DASHfloat] = ACTIONS(269),
    [anon_sym_rem_DASHfloat] = ACTIONS(269),
    [anon_sym_add_DASHdouble] = ACTIONS(269),
    [anon_sym_sub_DASHdouble] = ACTIONS(269),
    [anon_sym_mul_DASHdouble] = ACTIONS(269),
    [anon_sym_div_DASHdouble] = ACTIONS(269),
    [anon_sym_rem_DASHdouble] = ACTIONS(269),
    [anon_sym_add_DASHint_SLASH2addr] = ACTIONS(267),
    [anon_sym_sub_DASHint_SLASH2addr] = ACTIONS(267),
    [anon_sym_mul_DASHint_SLASH2addr] = ACTIONS(267),
    [anon_sym_div_DASHint_SLASH2addr] = ACTIONS(267),
    [anon_sym_rem_DASHint_SLASH2addr] = ACTIONS(267),
    [anon_sym_and_DASHint_SLASH2addr] = ACTIONS(267),
    [anon_sym_or_DASHint_SLASH2addr] = ACTIONS(267),
    [anon_sym_xor_DASHint_SLASH2addr] = ACTIONS(267),
    [anon_sym_shl_DASHint_SLASH2addr] = ACTIONS(267),
    [anon_sym_shr_DASHint_SLASH2addr] = ACTIONS(267),
    [anon_sym_ushr_DASHint_SLASH2addr] = ACTIONS(267),
    [anon_sym_add_DASHlong_SLASH2addr] = ACTIONS(267),
    [anon_sym_sub_DASHlong_SLASH2addr] = ACTIONS(267),
    [anon_sym_mul_DASHlong_SLASH2addr] = ACTIONS(267),
    [anon_sym_div_DASHlong_SLASH2addr] = ACTIONS(267),
    [anon_sym_rem_DASHlong_SLASH2addr] = ACTIONS(267),
    [anon_sym_and_DASHlong_SLASH2addr] = ACTIONS(267),
    [anon_sym_or_DASHlong_SLASH2addr] = ACTIONS(267),
    [anon_sym_xor_DASHlong_SLASH2addr] = ACTIONS(267),
    [anon_sym_shl_DASHlong_SLASH2addr] = ACTIONS(267),
    [anon_sym_shr_DASHlong_SLASH2addr] = ACTIONS(267),
    [anon_sym_ushr_DASHlong_SLASH2addr] = ACTIONS(267),
    [anon_sym_add_DASHfloat_SLASH2addr] = ACTIONS(267),
    [anon_sym_sub_DASHfloat_SLASH2addr] = ACTIONS(267),
    [anon_sym_mul_DASHfloat_SLASH2addr] = ACTIONS(267),
    [anon_sym_div_DASHfloat_SLASH2addr] = ACTIONS(267),
    [anon_sym_rem_DASHfloat_SLASH2addr] = ACTIONS(267),
    [anon_sym_add_DASHdouble_SLASH2addr] = ACTIONS(267),
    [anon_sym_sub_DASHdouble_SLASH2addr] = ACTIONS(267),
    [anon_sym_mul_DASHdouble_SLASH2addr] = ACTIONS(267),
    [anon_sym_div_DASHdouble_SLASH2addr] = ACTIONS(267),
    [anon_sym_rem_DASHdouble_SLASH2addr] = ACTIONS(267),
    [anon_sym_add_DASHint_SLASHlit16] = ACTIONS(267),
    [anon_sym_sub_DASHint_SLASHlit16] = ACTIONS(267),
    [anon_sym_mul_DASHint_SLASHlit16] = ACTIONS(267),
    [anon_sym_div_DASHint_SLASHlit16] = ACTIONS(267),
    [anon_sym_rem_DASHint_SLASHlit16] = ACTIONS(267),
    [anon_sym_and_DASHint_SLASHlit16] = ACTIONS(267),
    [anon_sym_or_DASHint_SLASHlit16] = ACTIONS(267),
    [anon_sym_xor_DASHint_SLASHlit16] = ACTIONS(267),
    [anon_sym_add_DASHint_SLASHlit8] = ACTIONS(267),
    [anon_sym_sub_DASHint_SLASHlit8] = ACTIONS(267),
    [anon_sym_mul_DASHint_SLASHlit8] = ACTIONS(267),
    [anon_sym_div_DASHint_SLASHlit8] = ACTIONS(267),
    [anon_sym_rem_DASHint_SLASHlit8] = ACTIONS(267),
    [anon_sym_and_DASHint_SLASHlit8] = ACTIONS(267),
    [anon_sym_or_DASHint_SLASHlit8] = ACTIONS(267),
    [anon_sym_xor_DASHint_SLASHlit8] = ACTIONS(267),
    [anon_sym_shl_DASHint_SLASHlit8] = ACTIONS(267),
    [anon_sym_shr_DASHint_SLASHlit8] = ACTIONS(267),
    [anon_sym_ushr_DASHint_SLASHlit8] = ACTIONS(267),
    [anon_sym_static_DASHget] = ACTIONS(267),
    [anon_sym_static_DASHput] = ACTIONS(267),
    [anon_sym_instance_DASHget] = ACTIONS(267),
    [anon_sym_instance_DASHput] = ACTIONS(267),
    [anon_sym_execute_DASHinline] = ACTIONS(269),
    [anon_sym_execute_DASHinline_SLASHrange] = ACTIONS(267),
    [anon_sym_iget_DASHquick] = ACTIONS(267),
    [anon_sym_iget_DASHwide_DASHquick] = ACTIONS(267),
    [anon_sym_iget_DASHobject_DASHquick] = ACTIONS(267),
    [anon_sym_iput_DASHquick] = ACTIONS(267),
    [anon_sym_iput_DASHwide_DASHquick] = ACTIONS(267),
    [anon_sym_iput_DASHobject_DASHquick] = ACTIONS(267),
    [anon_sym_iput_DASHboolean_DASHquick] = ACTIONS(267),
    [anon_sym_iput_DASHbyte_DASHquick] = ACTIONS(267),
    [anon_sym_iput_DASHchar_DASHquick] = ACTIONS(267),
    [anon_sym_iput_DASHshort_DASHquick] = ACTIONS(267),
    [anon_sym_invoke_DASHvirtual_DASHquick] = ACTIONS(269),
    [anon_sym_invoke_DASHvirtual_DASHquick_SLASHrange] = ACTIONS(267),
    [anon_sym_invoke_DASHsuper_DASHquick] = ACTIONS(269),
    [anon_sym_invoke_DASHsuper_DASHquick_SLASHrange] = ACTIONS(267),
    [anon_sym_rsub_DASHint] = ACTIONS(269),
    [anon_sym_rsub_DASHint_SLASHlit8] = ACTIONS(267),
    [anon_sym_DOTline] = ACTIONS(267),
    [anon_sym_DOTlocals] = ACTIONS(267),
    [anon_sym_DOTlocal] = ACTIONS(269),
    [anon_sym_DOTendlocal] = ACTIONS(267),
    [anon_sym_DOTrestartlocal] = ACTIONS(267),
    [anon_sym_DOTregisters] = ACTIONS(267),
    [anon_sym_DOTcatch] = ACTIONS(269),
    [anon_sym_RBRACE] = ACTIONS(267),
    [anon_sym_DOTcatchall] = ACTIONS(267),
    [anon_sym_DOTpacked_DASHswitch] = ACTIONS(267),
    [anon_sym_DOTsparse_DASHswitch] = ACTIONS(267),
    [anon_sym_DOTarray_DASHdata] = ACTIONS(267),
    [sym_prologue_directive] = ACTIONS(267),
    [sym_epilogue_directive] = ACTIONS(267),
    [aux_sym_label_token1] = ACTIONS(267),
    [aux_sym_jmp_label_token1] = ACTIONS(267),
    [sym_comment] = ACTIONS(3),
  },
  [26] = {
    [ts_builtin_sym_end] = ACTIONS(271),
    [anon_sym_DOTsource] = ACTIONS(271),
    [anon_sym_DOTfield] = ACTIONS(271),
    [anon_sym_DOTendfield] = ACTIONS(271),
    [anon_sym_DOTmethod] = ACTIONS(271),
    [anon_sym_DOTendmethod] = ACTIONS(271),
    [anon_sym_DOTannotation] = ACTIONS(271),
    [anon_sym_DOTparam] = ACTIONS(273),
    [anon_sym_COMMA] = ACTIONS(271),
    [anon_sym_DOTparameter] = ACTIONS(271),
    [anon_sym_nop] = ACTIONS(273),
    [anon_sym_move] = ACTIONS(273),
    [anon_sym_move_SLASHfrom16] = ACTIONS(271),
    [anon_sym_move_SLASH16] = ACTIONS(271),
    [anon_sym_move_DASHwide] = ACTIONS(273),
    [anon_sym_move_DASHwide_SLASHfrom16] = ACTIONS(271),
    [anon_sym_move_DASHwide_SLASH16] = ACTIONS(271),
    [anon_sym_move_DASHobject] = ACTIONS(273),
    [anon_sym_move_DASHobject_SLASHfrom16] = ACTIONS(271),
    [anon_sym_move_DASHobject_SLASH16] = ACTIONS(271),
    [anon_sym_move_DASHresult] = ACTIONS(273),
    [anon_sym_move_DASHresult_DASHwide] = ACTIONS(271),
    [anon_sym_move_DASHresult_DASHobject] = ACTIONS(271),
    [anon_sym_move_DASHexception] = ACTIONS(271),
    [anon_sym_return_DASHvoid] = ACTIONS(271),
    [anon_sym_return] = ACTIONS(273),
    [anon_sym_return_DASHwide] = ACTIONS(271),
    [anon_sym_return_DASHobject] = ACTIONS(271),
    [anon_sym_const_SLASH4] = ACTIONS(271),
    [anon_sym_const_SLASH16] = ACTIONS(271),
    [anon_sym_const] = ACTIONS(273),
    [anon_sym_const_SLASHhigh16] = ACTIONS(271),
    [anon_sym_const_DASHwide_SLASH16] = ACTIONS(271),
    [anon_sym_const_DASHwide_SLASH32] = ACTIONS(271),
    [anon_sym_const_DASHwide] = ACTIONS(273),
    [anon_sym_const_DASHwide_SLASHhigh16] = ACTIONS(271),
    [anon_sym_const_DASHstring] = ACTIONS(273),
    [anon_sym_const_DASHstring_SLASHjumbo] = ACTIONS(271),
    [anon_sym_const_DASHclass] = ACTIONS(271),
    [anon_sym_const_DASHmethod_DASHhandle] = ACTIONS(271),
    [anon_sym_const_DASHmethod_DASHtype] = ACTIONS(271),
    [anon_sym_monitor_DASHenter] = ACTIONS(271),
    [anon_sym_monitor_DASHexit] = ACTIONS(271),
    [anon_sym_check_DASHcast] = ACTIONS(271),
    [anon_sym_instance_DASHof] = ACTIONS(271),
    [anon_sym_array_DASHlength] = ACTIONS(271),
    [anon_sym_new_DASHinstance] = ACTIONS(271),
    [anon_sym_new_DASHarray] = ACTIONS(271),
    [anon_sym_filled_DASHnew_DASHarray] = ACTIONS(273),
    [anon_sym_filled_DASHnew_DASHarray_SLASHrange] = ACTIONS(271),
    [anon_sym_fill_DASHarray_DASHdata] = ACTIONS(271),
    [anon_sym_throw] = ACTIONS(273),
    [anon_sym_throw_DASHverification_DASHerror] = ACTIONS(271),
    [anon_sym_goto] = ACTIONS(273),
    [anon_sym_goto_SLASH16] = ACTIONS(271),
    [anon_sym_goto_SLASH32] = ACTIONS(271),
    [anon_sym_packed_DASHswitch] = ACTIONS(271),
    [anon_sym_sparse_DASHswitch] = ACTIONS(271),
    [anon_sym_cmpl_DASHfloat] = ACTIONS(271),
    [anon_sym_cmpg_DASHfloat] = ACTIONS(271),
    [anon_sym_cmpl_DASHdouble] = ACTIONS(271),
    [anon_sym_cmpg_DASHdouble] = ACTIONS(271),
    [anon_sym_cmp_DASHlong] = ACTIONS(271),
    [anon_sym_if_DASHeq] = ACTIONS(273),
    [anon_sym_if_DASHne] = ACTIONS(273),
    [anon_sym_if_DASHlt] = ACTIONS(273),
    [anon_sym_if_DASHge] = ACTIONS(273),
    [anon_sym_if_DASHgt] = ACTIONS(273),
    [anon_sym_if_DASHle] = ACTIONS(273),
    [anon_sym_if_DASHeqz] = ACTIONS(271),
    [anon_sym_if_DASHnez] = ACTIONS(271),
    [anon_sym_if_DASHltz] = ACTIONS(271),
    [anon_sym_if_DASHgez] = ACTIONS(271),
    [anon_sym_if_DASHgtz] = ACTIONS(271),
    [anon_sym_if_DASHlez] = ACTIONS(271),
    [anon_sym_aget] = ACTIONS(273),
    [anon_sym_aget_DASHwide] = ACTIONS(271),
    [anon_sym_aget_DASHobject] = ACTIONS(271),
    [anon_sym_aget_DASHboolean] = ACTIONS(271),
    [anon_sym_aget_DASHbyte] = ACTIONS(271),
    [anon_sym_aget_DASHchar] = ACTIONS(271),
    [anon_sym_aget_DASHshort] = ACTIONS(271),
    [anon_sym_aput] = ACTIONS(273),
    [anon_sym_aput_DASHwide] = ACTIONS(271),
    [anon_sym_aput_DASHobject] = ACTIONS(271),
    [anon_sym_aput_DASHboolean] = ACTIONS(271),
    [anon_sym_aput_DASHbyte] = ACTIONS(271),
    [anon_sym_aput_DASHchar] = ACTIONS(271),
    [anon_sym_aput_DASHshort] = ACTIONS(271),
    [anon_sym_iget] = ACTIONS(273),
    [anon_sym_iget_DASHwide] = ACTIONS(273),
    [anon_sym_iget_DASHobject] = ACTIONS(273),
    [anon_sym_iget_DASHboolean] = ACTIONS(271),
    [anon_sym_iget_DASHbyte] = ACTIONS(271),
    [anon_sym_iget_DASHchar] = ACTIONS(271),
    [anon_sym_iget_DASHshort] = ACTIONS(271),
    [anon_sym_iget_DASHvolatile] = ACTIONS(271),
    [anon_sym_iget_DASHwide_DASHvolatile] = ACTIONS(271),
    [anon_sym_iget_DASHobject_DASHvolatile] = ACTIONS(271),
    [anon_sym_iput] = ACTIONS(273),
    [anon_sym_iput_DASHwide] = ACTIONS(273),
    [anon_sym_iput_DASHobject] = ACTIONS(273),
    [anon_sym_iput_DASHboolean] = ACTIONS(273),
    [anon_sym_iput_DASHbyte] = ACTIONS(273),
    [anon_sym_iput_DASHchar] = ACTIONS(273),
    [anon_sym_iput_DASHshort] = ACTIONS(273),
    [anon_sym_iput_DASHvolatile] = ACTIONS(271),
    [anon_sym_iput_DASHwide_DASHvolatile] = ACTIONS(271),
    [anon_sym_iput_DASHobject_DASHvolatile] = ACTIONS(271),
    [anon_sym_sget] = ACTIONS(273),
    [anon_sym_sget_DASHwide] = ACTIONS(273),
    [anon_sym_sget_DASHobject] = ACTIONS(273),
    [anon_sym_sget_DASHboolean] = ACTIONS(271),
    [anon_sym_sget_DASHbyte] = ACTIONS(271),
    [anon_sym_sget_DASHchar] = ACTIONS(271),
    [anon_sym_sget_DASHshort] = ACTIONS(271),
    [anon_sym_sget_DASHvolatile] = ACTIONS(271),
    [anon_sym_sget_DASHwide_DASHvolatile] = ACTIONS(271),
    [anon_sym_sget_DASHobject_DASHvolatile] = ACTIONS(271),
    [anon_sym_sput] = ACTIONS(273),
    [anon_sym_sput_DASHwide] = ACTIONS(273),
    [anon_sym_sput_DASHobject] = ACTIONS(273),
    [anon_sym_sput_DASHboolean] = ACTIONS(271),
    [anon_sym_sput_DASHbyte] = ACTIONS(271),
    [anon_sym_sput_DASHchar] = ACTIONS(271),
    [anon_sym_sput_DASHshort] = ACTIONS(271),
    [anon_sym_sput_DASHvolatile] = ACTIONS(271),
    [anon_sym_sput_DASHwide_DASHvolatile] = ACTIONS(271),
    [anon_sym_sput_DASHobject_DASHvolatile] = ACTIONS(271),
    [anon_sym_invoke_DASHconstructor] = ACTIONS(271),
    [anon_sym_invoke_DASHcustom] = ACTIONS(273),
    [anon_sym_invoke_DASHdirect] = ACTIONS(273),
    [anon_sym_invoke_DASHdirect_DASHempty] = ACTIONS(271),
    [anon_sym_invoke_DASHinstance] = ACTIONS(271),
    [anon_sym_invoke_DASHinterface] = ACTIONS(273),
    [anon_sym_invoke_DASHpolymorphic] = ACTIONS(273),
    [anon_sym_invoke_DASHstatic] = ACTIONS(273),
    [anon_sym_invoke_DASHsuper] = ACTIONS(273),
    [anon_sym_invoke_DASHvirtual] = ACTIONS(273),
    [anon_sym_invoke_DASHcustom_SLASHrange] = ACTIONS(271),
    [anon_sym_invoke_DASHdirect_SLASHrange] = ACTIONS(271),
    [anon_sym_invoke_DASHinterface_SLASHrange] = ACTIONS(271),
    [anon_sym_invoke_DASHobject_DASHinit_SLASHrange] = ACTIONS(271),
    [anon_sym_invoke_DASHpolymorphic_SLASHrange] = ACTIONS(271),
    [anon_sym_invoke_DASHstatic_SLASHrange] = ACTIONS(271),
    [anon_sym_invoke_DASHsuper_SLASHrange] = ACTIONS(271),
    [anon_sym_invoke_DASHvirtual_SLASHrange] = ACTIONS(271),
    [anon_sym_neg_DASHint] = ACTIONS(271),
    [anon_sym_not_DASHint] = ACTIONS(271),
    [anon_sym_neg_DASHlong] = ACTIONS(271),
    [anon_sym_not_DASHlong] = ACTIONS(271),
    [anon_sym_neg_DASHfloat] = ACTIONS(271),
    [anon_sym_neg_DASHdouble] = ACTIONS(271),
    [anon_sym_int_DASHto_DASHlong] = ACTIONS(271),
    [anon_sym_int_DASHto_DASHfloat] = ACTIONS(271),
    [anon_sym_int_DASHto_DASHdouble] = ACTIONS(271),
    [anon_sym_long_DASHto_DASHint] = ACTIONS(271),
    [anon_sym_long_DASHto_DASHfloat] = ACTIONS(271),
    [anon_sym_long_DASHto_DASHdouble] = ACTIONS(271),
    [anon_sym_float_DASHto_DASHint] = ACTIONS(271),
    [anon_sym_float_DASHto_DASHlong] = ACTIONS(271),
    [anon_sym_float_DASHto_DASHdouble] = ACTIONS(271),
    [anon_sym_double_DASHto_DASHint] = ACTIONS(271),
    [anon_sym_double_DASHto_DASHlong] = ACTIONS(271),
    [anon_sym_double_DASHto_DASHfloat] = ACTIONS(271),
    [anon_sym_int_DASHto_DASHbyte] = ACTIONS(271),
    [anon_sym_int_DASHto_DASHchar] = ACTIONS(271),
    [anon_sym_int_DASHto_DASHshort] = ACTIONS(271),
    [anon_sym_add_DASHint] = ACTIONS(273),
    [anon_sym_sub_DASHint] = ACTIONS(273),
    [anon_sym_mul_DASHint] = ACTIONS(273),
    [anon_sym_div_DASHint] = ACTIONS(273),
    [anon_sym_rem_DASHint] = ACTIONS(273),
    [anon_sym_and_DASHint] = ACTIONS(273),
    [anon_sym_or_DASHint] = ACTIONS(273),
    [anon_sym_xor_DASHint] = ACTIONS(273),
    [anon_sym_shl_DASHint] = ACTIONS(273),
    [anon_sym_shr_DASHint] = ACTIONS(273),
    [anon_sym_ushr_DASHint] = ACTIONS(273),
    [anon_sym_add_DASHlong] = ACTIONS(273),
    [anon_sym_sub_DASHlong] = ACTIONS(273),
    [anon_sym_mul_DASHlong] = ACTIONS(273),
    [anon_sym_div_DASHlong] = ACTIONS(273),
    [anon_sym_rem_DASHlong] = ACTIONS(273),
    [anon_sym_and_DASHlong] = ACTIONS(273),
    [anon_sym_or_DASHlong] = ACTIONS(273),
    [anon_sym_xor_DASHlong] = ACTIONS(273),
    [anon_sym_shl_DASHlong] = ACTIONS(273),
    [anon_sym_shr_DASHlong] = ACTIONS(273),
    [anon_sym_ushr_DASHlong] = ACTIONS(273),
    [anon_sym_add_DASHfloat] = ACTIONS(273),
    [anon_sym_sub_DASHfloat] = ACTIONS(273),
    [anon_sym_mul_DASHfloat] = ACTIONS(273),
    [anon_sym_div_DASHfloat] = ACTIONS(273),
    [anon_sym_rem_DASHfloat] = ACTIONS(273),
    [anon_sym_add_DASHdouble] = ACTIONS(273),
    [anon_sym_sub_DASHdouble] = ACTIONS(273),
    [anon_sym_mul_DASHdouble] = ACTIONS(273),
    [anon_sym_div_DASHdouble] = ACTIONS(273),
    [anon_sym_rem_DASHdouble] = ACTIONS(273),
    [anon_sym_add_DASHint_SLASH2addr] = ACTIONS(271),
    [anon_sym_sub_DASHint_SLASH2addr] = ACTIONS(271),
    [anon_sym_mul_DASHint_SLASH2addr] = ACTIONS(271),
    [anon_sym_div_DASHint_SLASH2addr] = ACTIONS(271),
    [anon_sym_rem_DASHint_SLASH2addr] = ACTIONS(271),
    [anon_sym_and_DASHint_SLASH2addr] = ACTIONS(271),
    [anon_sym_or_DASHint_SLASH2addr] = ACTIONS(271),
    [anon_sym_xor_DASHint_SLASH2addr] = ACTIONS(271),
    [anon_sym_shl_DASHint_SLASH2addr] = ACTIONS(271),
    [anon_sym_shr_DASHint_SLASH2addr] = ACTIONS(271),
    [anon_sym_ushr_DASHint_SLASH2addr] = ACTIONS(271),
    [anon_sym_add_DASHlong_SLASH2addr] = ACTIONS(271),
    [anon_sym_sub_DASHlong_SLASH2addr] = ACTIONS(271),
    [anon_sym_mul_DASHlong_SLASH2addr] = ACTIONS(271),
    [anon_sym_div_DASHlong_SLASH2addr] = ACTIONS(271),
    [anon_sym_rem_DASHlong_SLASH2addr] = ACTIONS(271),
    [anon_sym_and_DASHlong_SLASH2addr] = ACTIONS(271),
    [anon_sym_or_DASHlong_SLASH2addr] = ACTIONS(271),
    [anon_sym_xor_DASHlong_SLASH2addr] = ACTIONS(271),
    [anon_sym_shl_DASHlong_SLASH2addr] = ACTIONS(271),
    [anon_sym_shr_DASHlong_SLASH2addr] = ACTIONS(271),
    [anon_sym_ushr_DASHlong_SLASH2addr] = ACTIONS(271),
    [anon_sym_add_DASHfloat_SLASH2addr] = ACTIONS(271),
    [anon_sym_sub_DASHfloat_SLASH2addr] = ACTIONS(271),
    [anon_sym_mul_DASHfloat_SLASH2addr] = ACTIONS(271),
    [anon_sym_div_DASHfloat_SLASH2addr] = ACTIONS(271),
    [anon_sym_rem_DASHfloat_SLASH2addr] = ACTIONS(271),
    [anon_sym_add_DASHdouble_SLASH2addr] = ACTIONS(271),
    [anon_sym_sub_DASHdouble_SLASH2addr] = ACTIONS(271),
    [anon_sym_mul_DASHdouble_SLASH2addr] = ACTIONS(271),
    [anon_sym_div_DASHdouble_SLASH2addr] = ACTIONS(271),
    [anon_sym_rem_DASHdouble_SLASH2addr] = ACTIONS(271),
    [anon_sym_add_DASHint_SLASHlit16] = ACTIONS(271),
    [anon_sym_sub_DASHint_SLASHlit16] = ACTIONS(271),
    [anon_sym_mul_DASHint_SLASHlit16] = ACTIONS(271),
    [anon_sym_div_DASHint_SLASHlit16] = ACTIONS(271),
    [anon_sym_rem_DASHint_SLASHlit16] = ACTIONS(271),
    [anon_sym_and_DASHint_SLASHlit16] = ACTIONS(271),
    [anon_sym_or_DASHint_SLASHlit16] = ACTIONS(271),
    [anon_sym_xor_DASHint_SLASHlit16] = ACTIONS(271),
    [anon_sym_add_DASHint_SLASHlit8] = ACTIONS(271),
    [anon_sym_sub_DASHint_SLASHlit8] = ACTIONS(271),
    [anon_sym_mul_DASHint_SLASHlit8] = ACTIONS(271),
    [anon_sym_div_DASHint_SLASHlit8] = ACTIONS(271),
    [anon_sym_rem_DASHint_SLASHlit8] = ACTIONS(271),
    [anon_sym_and_DASHint_SLASHlit8] = ACTIONS(271),
    [anon_sym_or_DASHint_SLASHlit8] = ACTIONS(271),
    [anon_sym_xor_DASHint_SLASHlit8] = ACTIONS(271),
    [anon_sym_shl_DASHint_SLASHlit8] = ACTIONS(271),
    [anon_sym_shr_DASHint_SLASHlit8] = ACTIONS(271),
    [anon_sym_ushr_DASHint_SLASHlit8] = ACTIONS(271),
    [anon_sym_static_DASHget] = ACTIONS(271),
    [anon_sym_static_DASHput] = ACTIONS(271),
    [anon_sym_instance_DASHget] = ACTIONS(271),
    [anon_sym_instance_DASHput] = ACTIONS(271),
    [anon_sym_execute_DASHinline] = ACTIONS(273),
    [anon_sym_execute_DASHinline_SLASHrange] = ACTIONS(271),
    [anon_sym_iget_DASHquick] = ACTIONS(271),
    [anon_sym_iget_DASHwide_DASHquick] = ACTIONS(271),
    [anon_sym_iget_DASHobject_DASHquick] = ACTIONS(271),
    [anon_sym_iput_DASHquick] = ACTIONS(271),
    [anon_sym_iput_DASHwide_DASHquick] = ACTIONS(271),
    [anon_sym_iput_DASHobject_DASHquick] = ACTIONS(271),
    [anon_sym_iput_DASHboolean_DASHquick] = ACTIONS(271),
    [anon_sym_iput_DASHbyte_DASHquick] = ACTIONS(271),
    [anon_sym_iput_DASHchar_DASHquick] = ACTIONS(271),
    [anon_sym_iput_DASHshort_DASHquick] = ACTIONS(271),
    [anon_sym_invoke_DASHvirtual_DASHquick] = ACTIONS(273),
    [anon_sym_invoke_DASHvirtual_DASHquick_SLASHrange] = ACTIONS(271),
    [anon_sym_invoke_DASHsuper_DASHquick] = ACTIONS(273),
    [anon_sym_invoke_DASHsuper_DASHquick_SLASHrange] = ACTIONS(271),
    [anon_sym_rsub_DASHint] = ACTIONS(273),
    [anon_sym_rsub_DASHint_SLASHlit8] = ACTIONS(271),
    [anon_sym_DOTline] = ACTIONS(271),
    [anon_sym_DOTlocals] = ACTIONS(271),
    [anon_sym_DOTlocal] = ACTIONS(273),
    [anon_sym_DOTendlocal] = ACTIONS(271),
    [anon_sym_DOTrestartlocal] = ACTIONS(271),
    [anon_sym_DOTregisters] = ACTIONS(271),
    [anon_sym_DOTcatch] = ACTIONS(273),
    [anon_sym_DOT_DOT] = ACTIONS(271),
    [anon_sym_RBRACE] = ACTIONS(271),
    [anon_sym_DOTcatchall] = ACTIONS(271),
    [anon_sym_DOTpacked_DASHswitch] = ACTIONS(271),
    [anon_sym_DOTsparse_DASHswitch] = ACTIONS(271),
    [anon_sym_DOTarray_DASHdata] = ACTIONS(271),
    [sym_prologue_directive] = ACTIONS(271),
    [sym_epilogue_directive] = ACTIONS(271),
    [aux_sym_label_token1] = ACTIONS(271),
    [aux_sym_jmp_label_token1] = ACTIONS(271),
    [sym_comment] = ACTIONS(3),
  },
  [27] = {
    [ts_builtin_sym_end] = ACTIONS(275),
    [anon_sym_DOTsource] = ACTIONS(275),
    [anon_sym_DOTfield] = ACTIONS(275),
    [anon_sym_DOTendfield] = ACTIONS(275),
    [anon_sym_DOTmethod] = ACTIONS(275),
    [anon_sym_DOTendmethod] = ACTIONS(275),
    [anon_sym_DOTannotation] = ACTIONS(275),
    [anon_sym_DOTparam] = ACTIONS(277),
    [anon_sym_COMMA] = ACTIONS(275),
    [anon_sym_DOTparameter] = ACTIONS(275),
    [anon_sym_nop] = ACTIONS(277),
    [anon_sym_move] = ACTIONS(277),
    [anon_sym_move_SLASHfrom16] = ACTIONS(275),
    [anon_sym_move_SLASH16] = ACTIONS(275),
    [anon_sym_move_DASHwide] = ACTIONS(277),
    [anon_sym_move_DASHwide_SLASHfrom16] = ACTIONS(275),
    [anon_sym_move_DASHwide_SLASH16] = ACTIONS(275),
    [anon_sym_move_DASHobject] = ACTIONS(277),
    [anon_sym_move_DASHobject_SLASHfrom16] = ACTIONS(275),
    [anon_sym_move_DASHobject_SLASH16] = ACTIONS(275),
    [anon_sym_move_DASHresult] = ACTIONS(277),
    [anon_sym_move_DASHresult_DASHwide] = ACTIONS(275),
    [anon_sym_move_DASHresult_DASHobject] = ACTIONS(275),
    [anon_sym_move_DASHexception] = ACTIONS(275),
    [anon_sym_return_DASHvoid] = ACTIONS(275),
    [anon_sym_return] = ACTIONS(277),
    [anon_sym_return_DASHwide] = ACTIONS(275),
    [anon_sym_return_DASHobject] = ACTIONS(275),
    [anon_sym_const_SLASH4] = ACTIONS(275),
    [anon_sym_const_SLASH16] = ACTIONS(275),
    [anon_sym_const] = ACTIONS(277),
    [anon_sym_const_SLASHhigh16] = ACTIONS(275),
    [anon_sym_const_DASHwide_SLASH16] = ACTIONS(275),
    [anon_sym_const_DASHwide_SLASH32] = ACTIONS(275),
    [anon_sym_const_DASHwide] = ACTIONS(277),
    [anon_sym_const_DASHwide_SLASHhigh16] = ACTIONS(275),
    [anon_sym_const_DASHstring] = ACTIONS(277),
    [anon_sym_const_DASHstring_SLASHjumbo] = ACTIONS(275),
    [anon_sym_const_DASHclass] = ACTIONS(275),
    [anon_sym_const_DASHmethod_DASHhandle] = ACTIONS(275),
    [anon_sym_const_DASHmethod_DASHtype] = ACTIONS(275),
    [anon_sym_monitor_DASHenter] = ACTIONS(275),
    [anon_sym_monitor_DASHexit] = ACTIONS(275),
    [anon_sym_check_DASHcast] = ACTIONS(275),
    [anon_sym_instance_DASHof] = ACTIONS(275),
    [anon_sym_array_DASHlength] = ACTIONS(275),
    [anon_sym_new_DASHinstance] = ACTIONS(275),
    [anon_sym_new_DASHarray] = ACTIONS(275),
    [anon_sym_filled_DASHnew_DASHarray] = ACTIONS(277),
    [anon_sym_filled_DASHnew_DASHarray_SLASHrange] = ACTIONS(275),
    [anon_sym_fill_DASHarray_DASHdata] = ACTIONS(275),
    [anon_sym_throw] = ACTIONS(277),
    [anon_sym_throw_DASHverification_DASHerror] = ACTIONS(275),
    [anon_sym_goto] = ACTIONS(277),
    [anon_sym_goto_SLASH16] = ACTIONS(275),
    [anon_sym_goto_SLASH32] = ACTIONS(275),
    [anon_sym_packed_DASHswitch] = ACTIONS(275),
    [anon_sym_sparse_DASHswitch] = ACTIONS(275),
    [anon_sym_cmpl_DASHfloat] = ACTIONS(275),
    [anon_sym_cmpg_DASHfloat] = ACTIONS(275),
    [anon_sym_cmpl_DASHdouble] = ACTIONS(275),
    [anon_sym_cmpg_DASHdouble] = ACTIONS(275),
    [anon_sym_cmp_DASHlong] = ACTIONS(275),
    [anon_sym_if_DASHeq] = ACTIONS(277),
    [anon_sym_if_DASHne] = ACTIONS(277),
    [anon_sym_if_DASHlt] = ACTIONS(277),
    [anon_sym_if_DASHge] = ACTIONS(277),
    [anon_sym_if_DASHgt] = ACTIONS(277),
    [anon_sym_if_DASHle] = ACTIONS(277),
    [anon_sym_if_DASHeqz] = ACTIONS(275),
    [anon_sym_if_DASHnez] = ACTIONS(275),
    [anon_sym_if_DASHltz] = ACTIONS(275),
    [anon_sym_if_DASHgez] = ACTIONS(275),
    [anon_sym_if_DASHgtz] = ACTIONS(275),
    [anon_sym_if_DASHlez] = ACTIONS(275),
    [anon_sym_aget] = ACTIONS(277),
    [anon_sym_aget_DASHwide] = ACTIONS(275),
    [anon_sym_aget_DASHobject] = ACTIONS(275),
    [anon_sym_aget_DASHboolean] = ACTIONS(275),
    [anon_sym_aget_DASHbyte] = ACTIONS(275),
    [anon_sym_aget_DASHchar] = ACTIONS(275),
    [anon_sym_aget_DASHshort] = ACTIONS(275),
    [anon_sym_aput] = ACTIONS(277),
    [anon_sym_aput_DASHwide] = ACTIONS(275),
    [anon_sym_aput_DASHobject] = ACTIONS(275),
    [anon_sym_aput_DASHboolean] = ACTIONS(275),
    [anon_sym_aput_DASHbyte] = ACTIONS(275),
    [anon_sym_aput_DASHchar] = ACTIONS(275),
    [anon_sym_aput_DASHshort] = ACTIONS(275),
    [anon_sym_iget] = ACTIONS(277),
    [anon_sym_iget_DASHwide] = ACTIONS(277),
    [anon_sym_iget_DASHobject] = ACTIONS(277),
    [anon_sym_iget_DASHboolean] = ACTIONS(275),
    [anon_sym_iget_DASHbyte] = ACTIONS(275),
    [anon_sym_iget_DASHchar] = ACTIONS(275),
    [anon_sym_iget_DASHshort] = ACTIONS(275),
    [anon_sym_iget_DASHvolatile] = ACTIONS(275),
    [anon_sym_iget_DASHwide_DASHvolatile] = ACTIONS(275),
    [anon_sym_iget_DASHobject_DASHvolatile] = ACTIONS(275),
    [anon_sym_iput] = ACTIONS(277),
    [anon_sym_iput_DASHwide] = ACTIONS(277),
    [anon_sym_iput_DASHobject] = ACTIONS(277),
    [anon_sym_iput_DASHboolean] = ACTIONS(277),
    [anon_sym_iput_DASHbyte] = ACTIONS(277),
    [anon_sym_iput_DASHchar] = ACTIONS(277),
    [anon_sym_iput_DASHshort] = ACTIONS(277),
    [anon_sym_iput_DASHvolatile] = ACTIONS(275),
    [anon_sym_iput_DASHwide_DASHvolatile] = ACTIONS(275),
    [anon_sym_iput_DASHobject_DASHvolatile] = ACTIONS(275),
    [anon_sym_sget] = ACTIONS(277),
    [anon_sym_sget_DASHwide] = ACTIONS(277),
    [anon_sym_sget_DASHobject] = ACTIONS(277),
    [anon_sym_sget_DASHboolean] = ACTIONS(275),
    [anon_sym_sget_DASHbyte] = ACTIONS(275),
    [anon_sym_sget_DASHchar] = ACTIONS(275),
    [anon_sym_sget_DASHshort] = ACTIONS(275),
    [anon_sym_sget_DASHvolatile] = ACTIONS(275),
    [anon_sym_sget_DASHwide_DASHvolatile] = ACTIONS(275),
    [anon_sym_sget_DASHobject_DASHvolatile] = ACTIONS(275),
    [anon_sym_sput] = ACTIONS(277),
    [anon_sym_sput_DASHwide] = ACTIONS(277),
    [anon_sym_sput_DASHobject] = ACTIONS(277),
    [anon_sym_sput_DASHboolean] = ACTIONS(275),
    [anon_sym_sput_DASHbyte] = ACTIONS(275),
    [anon_sym_sput_DASHchar] = ACTIONS(275),
    [anon_sym_sput_DASHshort] = ACTIONS(275),
    [anon_sym_sput_DASHvolatile] = ACTIONS(275),
    [anon_sym_sput_DASHwide_DASHvolatile] = ACTIONS(275),
    [anon_sym_sput_DASHobject_DASHvolatile] = ACTIONS(275),
    [anon_sym_invoke_DASHconstructor] = ACTIONS(275),
    [anon_sym_invoke_DASHcustom] = ACTIONS(277),
    [anon_sym_invoke_DASHdirect] = ACTIONS(277),
    [anon_sym_invoke_DASHdirect_DASHempty] = ACTIONS(275),
    [anon_sym_invoke_DASHinstance] = ACTIONS(275),
    [anon_sym_invoke_DASHinterface] = ACTIONS(277),
    [anon_sym_invoke_DASHpolymorphic] = ACTIONS(277),
    [anon_sym_invoke_DASHstatic] = ACTIONS(277),
    [anon_sym_invoke_DASHsuper] = ACTIONS(277),
    [anon_sym_invoke_DASHvirtual] = ACTIONS(277),
    [anon_sym_invoke_DASHcustom_SLASHrange] = ACTIONS(275),
    [anon_sym_invoke_DASHdirect_SLASHrange] = ACTIONS(275),
    [anon_sym_invoke_DASHinterface_SLASHrange] = ACTIONS(275),
    [anon_sym_invoke_DASHobject_DASHinit_SLASHrange] = ACTIONS(275),
    [anon_sym_invoke_DASHpolymorphic_SLASHrange] = ACTIONS(275),
    [anon_sym_invoke_DASHstatic_SLASHrange] = ACTIONS(275),
    [anon_sym_invoke_DASHsuper_SLASHrange] = ACTIONS(275),
    [anon_sym_invoke_DASHvirtual_SLASHrange] = ACTIONS(275),
    [anon_sym_neg_DASHint] = ACTIONS(275),
    [anon_sym_not_DASHint] = ACTIONS(275),
    [anon_sym_neg_DASHlong] = ACTIONS(275),
    [anon_sym_not_DASHlong] = ACTIONS(275),
    [anon_sym_neg_DASHfloat] = ACTIONS(275),
    [anon_sym_neg_DASHdouble] = ACTIONS(275),
    [anon_sym_int_DASHto_DASHlong] = ACTIONS(275),
    [anon_sym_int_DASHto_DASHfloat] = ACTIONS(275),
    [anon_sym_int_DASHto_DASHdouble] = ACTIONS(275),
    [anon_sym_long_DASHto_DASHint] = ACTIONS(275),
    [anon_sym_long_DASHto_DASHfloat] = ACTIONS(275),
    [anon_sym_long_DASHto_DASHdouble] = ACTIONS(275),
    [anon_sym_float_DASHto_DASHint] = ACTIONS(275),
    [anon_sym_float_DASHto_DASHlong] = ACTIONS(275),
    [anon_sym_float_DASHto_DASHdouble] = ACTIONS(275),
    [anon_sym_double_DASHto_DASHint] = ACTIONS(275),
    [anon_sym_double_DASHto_DASHlong] = ACTIONS(275),
    [anon_sym_double_DASHto_DASHfloat] = ACTIONS(275),
    [anon_sym_int_DASHto_DASHbyte] = ACTIONS(275),
    [anon_sym_int_DASHto_DASHchar] = ACTIONS(275),
    [anon_sym_int_DASHto_DASHshort] = ACTIONS(275),
    [anon_sym_add_DASHint] = ACTIONS(277),
    [anon_sym_sub_DASHint] = ACTIONS(277),
    [anon_sym_mul_DASHint] = ACTIONS(277),
    [anon_sym_div_DASHint] = ACTIONS(277),
    [anon_sym_rem_DASHint] = ACTIONS(277),
    [anon_sym_and_DASHint] = ACTIONS(277),
    [anon_sym_or_DASHint] = ACTIONS(277),
    [anon_sym_xor_DASHint] = ACTIONS(277),
    [anon_sym_shl_DASHint] = ACTIONS(277),
    [anon_sym_shr_DASHint] = ACTIONS(277),
    [anon_sym_ushr_DASHint] = ACTIONS(277),
    [anon_sym_add_DASHlong] = ACTIONS(277),
    [anon_sym_sub_DASHlong] = ACTIONS(277),
    [anon_sym_mul_DASHlong] = ACTIONS(277),
    [anon_sym_div_DASHlong] = ACTIONS(277),
    [anon_sym_rem_DASHlong] = ACTIONS(277),
    [anon_sym_and_DASHlong] = ACTIONS(277),
    [anon_sym_or_DASHlong] = ACTIONS(277),
    [anon_sym_xor_DASHlong] = ACTIONS(277),
    [anon_sym_shl_DASHlong] = ACTIONS(277),
    [anon_sym_shr_DASHlong] = ACTIONS(277),
    [anon_sym_ushr_DASHlong] = ACTIONS(277),
    [anon_sym_add_DASHfloat] = ACTIONS(277),
    [anon_sym_sub_DASHfloat] = ACTIONS(277),
    [anon_sym_mul_DASHfloat] = ACTIONS(277),
    [anon_sym_div_DASHfloat] = ACTIONS(277),
    [anon_sym_rem_DASHfloat] = ACTIONS(277),
    [anon_sym_add_DASHdouble] = ACTIONS(277),
    [anon_sym_sub_DASHdouble] = ACTIONS(277),
    [anon_sym_mul_DASHdouble] = ACTIONS(277),
    [anon_sym_div_DASHdouble] = ACTIONS(277),
    [anon_sym_rem_DASHdouble] = ACTIONS(277),
    [anon_sym_add_DASHint_SLASH2addr] = ACTIONS(275),
    [anon_sym_sub_DASHint_SLASH2addr] = ACTIONS(275),
    [anon_sym_mul_DASHint_SLASH2addr] = ACTIONS(275),
    [anon_sym_div_DASHint_SLASH2addr] = ACTIONS(275),
    [anon_sym_rem_DASHint_SLASH2addr] = ACTIONS(275),
    [anon_sym_and_DASHint_SLASH2addr] = ACTIONS(275),
    [anon_sym_or_DASHint_SLASH2addr] = ACTIONS(275),
    [anon_sym_xor_DASHint_SLASH2addr] = ACTIONS(275),
    [anon_sym_shl_DASHint_SLASH2addr] = ACTIONS(275),
    [anon_sym_shr_DASHint_SLASH2addr] = ACTIONS(275),
    [anon_sym_ushr_DASHint_SLASH2addr] = ACTIONS(275),
    [anon_sym_add_DASHlong_SLASH2addr] = ACTIONS(275),
    [anon_sym_sub_DASHlong_SLASH2addr] = ACTIONS(275),
    [anon_sym_mul_DASHlong_SLASH2addr] = ACTIONS(275),
    [anon_sym_div_DASHlong_SLASH2addr] = ACTIONS(275),
    [anon_sym_rem_DASHlong_SLASH2addr] = ACTIONS(275),
    [anon_sym_and_DASHlong_SLASH2addr] = ACTIONS(275),
    [anon_sym_or_DASHlong_SLASH2addr] = ACTIONS(275),
    [anon_sym_xor_DASHlong_SLASH2addr] = ACTIONS(275),
    [anon_sym_shl_DASHlong_SLASH2addr] = ACTIONS(275),
    [anon_sym_shr_DASHlong_SLASH2addr] = ACTIONS(275),
    [anon_sym_ushr_DASHlong_SLASH2addr] = ACTIONS(275),
    [anon_sym_add_DASHfloat_SLASH2addr] = ACTIONS(275),
    [anon_sym_sub_DASHfloat_SLASH2addr] = ACTIONS(275),
    [anon_sym_mul_DASHfloat_SLASH2addr] = ACTIONS(275),
    [anon_sym_div_DASHfloat_SLASH2addr] = ACTIONS(275),
    [anon_sym_rem_DASHfloat_SLASH2addr] = ACTIONS(275),
    [anon_sym_add_DASHdouble_SLASH2addr] = ACTIONS(275),
    [anon_sym_sub_DASHdouble_SLASH2addr] = ACTIONS(275),
    [anon_sym_mul_DASHdouble_SLASH2addr] = ACTIONS(275),
    [anon_sym_div_DASHdouble_SLASH2addr] = ACTIONS(275),
    [anon_sym_rem_DASHdouble_SLASH2addr] = ACTIONS(275),
    [anon_sym_add_DASHint_SLASHlit16] = ACTIONS(275),
    [anon_sym_sub_DASHint_SLASHlit16] = ACTIONS(275),
    [anon_sym_mul_DASHint_SLASHlit16] = ACTIONS(275),
    [anon_sym_div_DASHint_SLASHlit16] = ACTIONS(275),
    [anon_sym_rem_DASHint_SLASHlit16] = ACTIONS(275),
    [anon_sym_and_DASHint_SLASHlit16] = ACTIONS(275),
    [anon_sym_or_DASHint_SLASHlit16] = ACTIONS(275),
    [anon_sym_xor_DASHint_SLASHlit16] = ACTIONS(275),
    [anon_sym_add_DASHint_SLASHlit8] = ACTIONS(275),
    [anon_sym_sub_DASHint_SLASHlit8] = ACTIONS(275),
    [anon_sym_mul_DASHint_SLASHlit8] = ACTIONS(275),
    [anon_sym_div_DASHint_SLASHlit8] = ACTIONS(275),
    [anon_sym_rem_DASHint_SLASHlit8] = ACTIONS(275),
    [anon_sym_and_DASHint_SLASHlit8] = ACTIONS(275),
    [anon_sym_or_DASHint_SLASHlit8] = ACTIONS(275),
    [anon_sym_xor_DASHint_SLASHlit8] = ACTIONS(275),
    [anon_sym_shl_DASHint_SLASHlit8] = ACTIONS(275),
    [anon_sym_shr_DASHint_SLASHlit8] = ACTIONS(275),
    [anon_sym_ushr_DASHint_SLASHlit8] = ACTIONS(275),
    [anon_sym_static_DASHget] = ACTIONS(275),
    [anon_sym_static_DASHput] = ACTIONS(275),
    [anon_sym_instance_DASHget] = ACTIONS(275),
    [anon_sym_instance_DASHput] = ACTIONS(275),
    [anon_sym_execute_DASHinline] = ACTIONS(277),
    [anon_sym_execute_DASHinline_SLASHrange] = ACTIONS(275),
    [anon_sym_iget_DASHquick] = ACTIONS(275),
    [anon_sym_iget_DASHwide_DASHquick] = ACTIONS(275),
    [anon_sym_iget_DASHobject_DASHquick] = ACTIONS(275),
    [anon_sym_iput_DASHquick] = ACTIONS(275),
    [anon_sym_iput_DASHwide_DASHquick] = ACTIONS(275),
    [anon_sym_iput_DASHobject_DASHquick] = ACTIONS(275),
    [anon_sym_iput_DASHboolean_DASHquick] = ACTIONS(275),
    [anon_sym_iput_DASHbyte_DASHquick] = ACTIONS(275),
    [anon_sym_iput_DASHchar_DASHquick] = ACTIONS(275),
    [anon_sym_iput_DASHshort_DASHquick] = ACTIONS(275),
    [anon_sym_invoke_DASHvirtual_DASHquick] = ACTIONS(277),
    [anon_sym_invoke_DASHvirtual_DASHquick_SLASHrange] = ACTIONS(275),
    [anon_sym_invoke_DASHsuper_DASHquick] = ACTIONS(277),
    [anon_sym_invoke_DASHsuper_DASHquick_SLASHrange] = ACTIONS(275),
    [anon_sym_rsub_DASHint] = ACTIONS(277),
    [anon_sym_rsub_DASHint_SLASHlit8] = ACTIONS(275),
    [anon_sym_DOTline] = ACTIONS(275),
    [anon_sym_DOTlocals] = ACTIONS(275),
    [anon_sym_DOTlocal] = ACTIONS(277),
    [anon_sym_DOTendlocal] = ACTIONS(275),
    [anon_sym_DOTrestartlocal] = ACTIONS(275),
    [anon_sym_DOTregisters] = ACTIONS(275),
    [anon_sym_DOTcatch] = ACTIONS(277),
    [anon_sym_RBRACE] = ACTIONS(275),
    [anon_sym_DOTcatchall] = ACTIONS(275),
    [anon_sym_DOTpacked_DASHswitch] = ACTIONS(275),
    [anon_sym_DOTsparse_DASHswitch] = ACTIONS(275),
    [anon_sym_DOTarray_DASHdata] = ACTIONS(275),
    [sym_prologue_directive] = ACTIONS(275),
    [sym_epilogue_directive] = ACTIONS(275),
    [aux_sym_label_token1] = ACTIONS(275),
    [aux_sym_jmp_label_token1] = ACTIONS(275),
    [anon_sym_RPAREN] = ACTIONS(275),
    [sym_comment] = ACTIONS(3),
  },
  [28] = {
    [ts_builtin_sym_end] = ACTIONS(279),
    [anon_sym_DOTsource] = ACTIONS(279),
    [anon_sym_DOTfield] = ACTIONS(279),
    [anon_sym_DOTendfield] = ACTIONS(279),
    [anon_sym_DOTmethod] = ACTIONS(279),
    [anon_sym_DOTendmethod] = ACTIONS(279),
    [anon_sym_DOTannotation] = ACTIONS(279),
    [anon_sym_DOTparam] = ACTIONS(281),
    [anon_sym_COMMA] = ACTIONS(279),
    [anon_sym_DOTparameter] = ACTIONS(279),
    [anon_sym_nop] = ACTIONS(281),
    [anon_sym_move] = ACTIONS(281),
    [anon_sym_move_SLASHfrom16] = ACTIONS(279),
    [anon_sym_move_SLASH16] = ACTIONS(279),
    [anon_sym_move_DASHwide] = ACTIONS(281),
    [anon_sym_move_DASHwide_SLASHfrom16] = ACTIONS(279),
    [anon_sym_move_DASHwide_SLASH16] = ACTIONS(279),
    [anon_sym_move_DASHobject] = ACTIONS(281),
    [anon_sym_move_DASHobject_SLASHfrom16] = ACTIONS(279),
    [anon_sym_move_DASHobject_SLASH16] = ACTIONS(279),
    [anon_sym_move_DASHresult] = ACTIONS(281),
    [anon_sym_move_DASHresult_DASHwide] = ACTIONS(279),
    [anon_sym_move_DASHresult_DASHobject] = ACTIONS(279),
    [anon_sym_move_DASHexception] = ACTIONS(279),
    [anon_sym_return_DASHvoid] = ACTIONS(279),
    [anon_sym_return] = ACTIONS(281),
    [anon_sym_return_DASHwide] = ACTIONS(279),
    [anon_sym_return_DASHobject] = ACTIONS(279),
    [anon_sym_const_SLASH4] = ACTIONS(279),
    [anon_sym_const_SLASH16] = ACTIONS(279),
    [anon_sym_const] = ACTIONS(281),
    [anon_sym_const_SLASHhigh16] = ACTIONS(279),
    [anon_sym_const_DASHwide_SLASH16] = ACTIONS(279),
    [anon_sym_const_DASHwide_SLASH32] = ACTIONS(279),
    [anon_sym_const_DASHwide] = ACTIONS(281),
    [anon_sym_const_DASHwide_SLASHhigh16] = ACTIONS(279),
    [anon_sym_const_DASHstring] = ACTIONS(281),
    [anon_sym_const_DASHstring_SLASHjumbo] = ACTIONS(279),
    [anon_sym_const_DASHclass] = ACTIONS(279),
    [anon_sym_const_DASHmethod_DASHhandle] = ACTIONS(279),
    [anon_sym_const_DASHmethod_DASHtype] = ACTIONS(279),
    [anon_sym_monitor_DASHenter] = ACTIONS(279),
    [anon_sym_monitor_DASHexit] = ACTIONS(279),
    [anon_sym_check_DASHcast] = ACTIONS(279),
    [anon_sym_instance_DASHof] = ACTIONS(279),
    [anon_sym_array_DASHlength] = ACTIONS(279),
    [anon_sym_new_DASHinstance] = ACTIONS(279),
    [anon_sym_new_DASHarray] = ACTIONS(279),
    [anon_sym_filled_DASHnew_DASHarray] = ACTIONS(281),
    [anon_sym_filled_DASHnew_DASHarray_SLASHrange] = ACTIONS(279),
    [anon_sym_fill_DASHarray_DASHdata] = ACTIONS(279),
    [anon_sym_throw] = ACTIONS(281),
    [anon_sym_throw_DASHverification_DASHerror] = ACTIONS(279),
    [anon_sym_goto] = ACTIONS(281),
    [anon_sym_goto_SLASH16] = ACTIONS(279),
    [anon_sym_goto_SLASH32] = ACTIONS(279),
    [anon_sym_packed_DASHswitch] = ACTIONS(279),
    [anon_sym_sparse_DASHswitch] = ACTIONS(279),
    [anon_sym_cmpl_DASHfloat] = ACTIONS(279),
    [anon_sym_cmpg_DASHfloat] = ACTIONS(279),
    [anon_sym_cmpl_DASHdouble] = ACTIONS(279),
    [anon_sym_cmpg_DASHdouble] = ACTIONS(279),
    [anon_sym_cmp_DASHlong] = ACTIONS(279),
    [anon_sym_if_DASHeq] = ACTIONS(281),
    [anon_sym_if_DASHne] = ACTIONS(281),
    [anon_sym_if_DASHlt] = ACTIONS(281),
    [anon_sym_if_DASHge] = ACTIONS(281),
    [anon_sym_if_DASHgt] = ACTIONS(281),
    [anon_sym_if_DASHle] = ACTIONS(281),
    [anon_sym_if_DASHeqz] = ACTIONS(279),
    [anon_sym_if_DASHnez] = ACTIONS(279),
    [anon_sym_if_DASHltz] = ACTIONS(279),
    [anon_sym_if_DASHgez] = ACTIONS(279),
    [anon_sym_if_DASHgtz] = ACTIONS(279),
    [anon_sym_if_DASHlez] = ACTIONS(279),
    [anon_sym_aget] = ACTIONS(281),
    [anon_sym_aget_DASHwide] = ACTIONS(279),
    [anon_sym_aget_DASHobject] = ACTIONS(279),
    [anon_sym_aget_DASHboolean] = ACTIONS(279),
    [anon_sym_aget_DASHbyte] = ACTIONS(279),
    [anon_sym_aget_DASHchar] = ACTIONS(279),
    [anon_sym_aget_DASHshort] = ACTIONS(279),
    [anon_sym_aput] = ACTIONS(281),
    [anon_sym_aput_DASHwide] = ACTIONS(279),
    [anon_sym_aput_DASHobject] = ACTIONS(279),
    [anon_sym_aput_DASHboolean] = ACTIONS(279),
    [anon_sym_aput_DASHbyte] = ACTIONS(279),
    [anon_sym_aput_DASHchar] = ACTIONS(279),
    [anon_sym_aput_DASHshort] = ACTIONS(279),
    [anon_sym_iget] = ACTIONS(281),
    [anon_sym_iget_DASHwide] = ACTIONS(281),
    [anon_sym_iget_DASHobject] = ACTIONS(281),
    [anon_sym_iget_DASHboolean] = ACTIONS(279),
    [anon_sym_iget_DASHbyte] = ACTIONS(279),
    [anon_sym_iget_DASHchar] = ACTIONS(279),
    [anon_sym_iget_DASHshort] = ACTIONS(279),
    [anon_sym_iget_DASHvolatile] = ACTIONS(279),
    [anon_sym_iget_DASHwide_DASHvolatile] = ACTIONS(279),
    [anon_sym_iget_DASHobject_DASHvolatile] = ACTIONS(279),
    [anon_sym_iput] = ACTIONS(281),
    [anon_sym_iput_DASHwide] = ACTIONS(281),
    [anon_sym_iput_DASHobject] = ACTIONS(281),
    [anon_sym_iput_DASHboolean] = ACTIONS(281),
    [anon_sym_iput_DASHbyte] = ACTIONS(281),
    [anon_sym_iput_DASHchar] = ACTIONS(281),
    [anon_sym_iput_DASHshort] = ACTIONS(281),
    [anon_sym_iput_DASHvolatile] = ACTIONS(279),
    [anon_sym_iput_DASHwide_DASHvolatile] = ACTIONS(279),
    [anon_sym_iput_DASHobject_DASHvolatile] = ACTIONS(279),
    [anon_sym_sget] = ACTIONS(281),
    [anon_sym_sget_DASHwide] = ACTIONS(281),
    [anon_sym_sget_DASHobject] = ACTIONS(281),
    [anon_sym_sget_DASHboolean] = ACTIONS(279),
    [anon_sym_sget_DASHbyte] = ACTIONS(279),
    [anon_sym_sget_DASHchar] = ACTIONS(279),
    [anon_sym_sget_DASHshort] = ACTIONS(279),
    [anon_sym_sget_DASHvolatile] = ACTIONS(279),
    [anon_sym_sget_DASHwide_DASHvolatile] = ACTIONS(279),
    [anon_sym_sget_DASHobject_DASHvolatile] = ACTIONS(279),
    [anon_sym_sput] = ACTIONS(281),
    [anon_sym_sput_DASHwide] = ACTIONS(281),
    [anon_sym_sput_DASHobject] = ACTIONS(281),
    [anon_sym_sput_DASHboolean] = ACTIONS(279),
    [anon_sym_sput_DASHbyte] = ACTIONS(279),
    [anon_sym_sput_DASHchar] = ACTIONS(279),
    [anon_sym_sput_DASHshort] = ACTIONS(279),
    [anon_sym_sput_DASHvolatile] = ACTIONS(279),
    [anon_sym_sput_DASHwide_DASHvolatile] = ACTIONS(279),
    [anon_sym_sput_DASHobject_DASHvolatile] = ACTIONS(279),
    [anon_sym_invoke_DASHconstructor] = ACTIONS(279),
    [anon_sym_invoke_DASHcustom] = ACTIONS(281),
    [anon_sym_invoke_DASHdirect] = ACTIONS(281),
    [anon_sym_invoke_DASHdirect_DASHempty] = ACTIONS(279),
    [anon_sym_invoke_DASHinstance] = ACTIONS(279),
    [anon_sym_invoke_DASHinterface] = ACTIONS(281),
    [anon_sym_invoke_DASHpolymorphic] = ACTIONS(281),
    [anon_sym_invoke_DASHstatic] = ACTIONS(281),
    [anon_sym_invoke_DASHsuper] = ACTIONS(281),
    [anon_sym_invoke_DASHvirtual] = ACTIONS(281),
    [anon_sym_invoke_DASHcustom_SLASHrange] = ACTIONS(279),
    [anon_sym_invoke_DASHdirect_SLASHrange] = ACTIONS(279),
    [anon_sym_invoke_DASHinterface_SLASHrange] = ACTIONS(279),
    [anon_sym_invoke_DASHobject_DASHinit_SLASHrange] = ACTIONS(279),
    [anon_sym_invoke_DASHpolymorphic_SLASHrange] = ACTIONS(279),
    [anon_sym_invoke_DASHstatic_SLASHrange] = ACTIONS(279),
    [anon_sym_invoke_DASHsuper_SLASHrange] = ACTIONS(279),
    [anon_sym_invoke_DASHvirtual_SLASHrange] = ACTIONS(279),
    [anon_sym_neg_DASHint] = ACTIONS(279),
    [anon_sym_not_DASHint] = ACTIONS(279),
    [anon_sym_neg_DASHlong] = ACTIONS(279),
    [anon_sym_not_DASHlong] = ACTIONS(279),
    [anon_sym_neg_DASHfloat] = ACTIONS(279),
    [anon_sym_neg_DASHdouble] = ACTIONS(279),
    [anon_sym_int_DASHto_DASHlong] = ACTIONS(279),
    [anon_sym_int_DASHto_DASHfloat] = ACTIONS(279),
    [anon_sym_int_DASHto_DASHdouble] = ACTIONS(279),
    [anon_sym_long_DASHto_DASHint] = ACTIONS(279),
    [anon_sym_long_DASHto_DASHfloat] = ACTIONS(279),
    [anon_sym_long_DASHto_DASHdouble] = ACTIONS(279),
    [anon_sym_float_DASHto_DASHint] = ACTIONS(279),
    [anon_sym_float_DASHto_DASHlong] = ACTIONS(279),
    [anon_sym_float_DASHto_DASHdouble] = ACTIONS(279),
    [anon_sym_double_DASHto_DASHint] = ACTIONS(279),
    [anon_sym_double_DASHto_DASHlong] = ACTIONS(279),
    [anon_sym_double_DASHto_DASHfloat] = ACTIONS(279),
    [anon_sym_int_DASHto_DASHbyte] = ACTIONS(279),
    [anon_sym_int_DASHto_DASHchar] = ACTIONS(279),
    [anon_sym_int_DASHto_DASHshort] = ACTIONS(279),
    [anon_sym_add_DASHint] = ACTIONS(281),
    [anon_sym_sub_DASHint] = ACTIONS(281),
    [anon_sym_mul_DASHint] = ACTIONS(281),
    [anon_sym_div_DASHint] = ACTIONS(281),
    [anon_sym_rem_DASHint] = ACTIONS(281),
    [anon_sym_and_DASHint] = ACTIONS(281),
    [anon_sym_or_DASHint] = ACTIONS(281),
    [anon_sym_xor_DASHint] = ACTIONS(281),
    [anon_sym_shl_DASHint] = ACTIONS(281),
    [anon_sym_shr_DASHint] = ACTIONS(281),
    [anon_sym_ushr_DASHint] = ACTIONS(281),
    [anon_sym_add_DASHlong] = ACTIONS(281),
    [anon_sym_sub_DASHlong] = ACTIONS(281),
    [anon_sym_mul_DASHlong] = ACTIONS(281),
    [anon_sym_div_DASHlong] = ACTIONS(281),
    [anon_sym_rem_DASHlong] = ACTIONS(281),
    [anon_sym_and_DASHlong] = ACTIONS(281),
    [anon_sym_or_DASHlong] = ACTIONS(281),
    [anon_sym_xor_DASHlong] = ACTIONS(281),
    [anon_sym_shl_DASHlong] = ACTIONS(281),
    [anon_sym_shr_DASHlong] = ACTIONS(281),
    [anon_sym_ushr_DASHlong] = ACTIONS(281),
    [anon_sym_add_DASHfloat] = ACTIONS(281),
    [anon_sym_sub_DASHfloat] = ACTIONS(281),
    [anon_sym_mul_DASHfloat] = ACTIONS(281),
    [anon_sym_div_DASHfloat] = ACTIONS(281),
    [anon_sym_rem_DASHfloat] = ACTIONS(281),
    [anon_sym_add_DASHdouble] = ACTIONS(281),
    [anon_sym_sub_DASHdouble] = ACTIONS(281),
    [anon_sym_mul_DASHdouble] = ACTIONS(281),
    [anon_sym_div_DASHdouble] = ACTIONS(281),
    [anon_sym_rem_DASHdouble] = ACTIONS(281),
    [anon_sym_add_DASHint_SLASH2addr] = ACTIONS(279),
    [anon_sym_sub_DASHint_SLASH2addr] = ACTIONS(279),
    [anon_sym_mul_DASHint_SLASH2addr] = ACTIONS(279),
    [anon_sym_div_DASHint_SLASH2addr] = ACTIONS(279),
    [anon_sym_rem_DASHint_SLASH2addr] = ACTIONS(279),
    [anon_sym_and_DASHint_SLASH2addr] = ACTIONS(279),
    [anon_sym_or_DASHint_SLASH2addr] = ACTIONS(279),
    [anon_sym_xor_DASHint_SLASH2addr] = ACTIONS(279),
    [anon_sym_shl_DASHint_SLASH2addr] = ACTIONS(279),
    [anon_sym_shr_DASHint_SLASH2addr] = ACTIONS(279),
    [anon_sym_ushr_DASHint_SLASH2addr] = ACTIONS(279),
    [anon_sym_add_DASHlong_SLASH2addr] = ACTIONS(279),
    [anon_sym_sub_DASHlong_SLASH2addr] = ACTIONS(279),
    [anon_sym_mul_DASHlong_SLASH2addr] = ACTIONS(279),
    [anon_sym_div_DASHlong_SLASH2addr] = ACTIONS(279),
    [anon_sym_rem_DASHlong_SLASH2addr] = ACTIONS(279),
    [anon_sym_and_DASHlong_SLASH2addr] = ACTIONS(279),
    [anon_sym_or_DASHlong_SLASH2addr] = ACTIONS(279),
    [anon_sym_xor_DASHlong_SLASH2addr] = ACTIONS(279),
    [anon_sym_shl_DASHlong_SLASH2addr] = ACTIONS(279),
    [anon_sym_shr_DASHlong_SLASH2addr] = ACTIONS(279),
    [anon_sym_ushr_DASHlong_SLASH2addr] = ACTIONS(279),
    [anon_sym_add_DASHfloat_SLASH2addr] = ACTIONS(279),
    [anon_sym_sub_DASHfloat_SLASH2addr] = ACTIONS(279),
    [anon_sym_mul_DASHfloat_SLASH2addr] = ACTIONS(279),
    [anon_sym_div_DASHfloat_SLASH2addr] = ACTIONS(279),
    [anon_sym_rem_DASHfloat_SLASH2addr] = ACTIONS(279),
    [anon_sym_add_DASHdouble_SLASH2addr] = ACTIONS(279),
    [anon_sym_sub_DASHdouble_SLASH2addr] = ACTIONS(279),
    [anon_sym_mul_DASHdouble_SLASH2addr] = ACTIONS(279),
    [anon_sym_div_DASHdouble_SLASH2addr] = ACTIONS(279),
    [anon_sym_rem_DASHdouble_SLASH2addr] = ACTIONS(279),
    [anon_sym_add_DASHint_SLASHlit16] = ACTIONS(279),
    [anon_sym_sub_DASHint_SLASHlit16] = ACTIONS(279),
    [anon_sym_mul_DASHint_SLASHlit16] = ACTIONS(279),
    [anon_sym_div_DASHint_SLASHlit16] = ACTIONS(279),
    [anon_sym_rem_DASHint_SLASHlit16] = ACTIONS(279),
    [anon_sym_and_DASHint_SLASHlit16] = ACTIONS(279),
    [anon_sym_or_DASHint_SLASHlit16] = ACTIONS(279),
    [anon_sym_xor_DASHint_SLASHlit16] = ACTIONS(279),
    [anon_sym_add_DASHint_SLASHlit8] = ACTIONS(279),
    [anon_sym_sub_DASHint_SLASHlit8] = ACTIONS(279),
    [anon_sym_mul_DASHint_SLASHlit8] = ACTIONS(279),
    [anon_sym_div_DASHint_SLASHlit8] = ACTIONS(279),
    [anon_sym_rem_DASHint_SLASHlit8] = ACTIONS(279),
    [anon_sym_and_DASHint_SLASHlit8] = ACTIONS(279),
    [anon_sym_or_DASHint_SLASHlit8] = ACTIONS(279),
    [anon_sym_xor_DASHint_SLASHlit8] = ACTIONS(279),
    [anon_sym_shl_DASHint_SLASHlit8] = ACTIONS(279),
    [anon_sym_shr_DASHint_SLASHlit8] = ACTIONS(279),
    [anon_sym_ushr_DASHint_SLASHlit8] = ACTIONS(279),
    [anon_sym_static_DASHget] = ACTIONS(279),
    [anon_sym_static_DASHput] = ACTIONS(279),
    [anon_sym_instance_DASHget] = ACTIONS(279),
    [anon_sym_instance_DASHput] = ACTIONS(279),
    [anon_sym_execute_DASHinline] = ACTIONS(281),
    [anon_sym_execute_DASHinline_SLASHrange] = ACTIONS(279),
    [anon_sym_iget_DASHquick] = ACTIONS(279),
    [anon_sym_iget_DASHwide_DASHquick] = ACTIONS(279),
    [anon_sym_iget_DASHobject_DASHquick] = ACTIONS(279),
    [anon_sym_iput_DASHquick] = ACTIONS(279),
    [anon_sym_iput_DASHwide_DASHquick] = ACTIONS(279),
    [anon_sym_iput_DASHobject_DASHquick] = ACTIONS(279),
    [anon_sym_iput_DASHboolean_DASHquick] = ACTIONS(279),
    [anon_sym_iput_DASHbyte_DASHquick] = ACTIONS(279),
    [anon_sym_iput_DASHchar_DASHquick] = ACTIONS(279),
    [anon_sym_iput_DASHshort_DASHquick] = ACTIONS(279),
    [anon_sym_invoke_DASHvirtual_DASHquick] = ACTIONS(281),
    [anon_sym_invoke_DASHvirtual_DASHquick_SLASHrange] = ACTIONS(279),
    [anon_sym_invoke_DASHsuper_DASHquick] = ACTIONS(281),
    [anon_sym_invoke_DASHsuper_DASHquick_SLASHrange] = ACTIONS(279),
    [anon_sym_rsub_DASHint] = ACTIONS(281),
    [anon_sym_rsub_DASHint_SLASHlit8] = ACTIONS(279),
    [anon_sym_DOTline] = ACTIONS(279),
    [anon_sym_DOTlocals] = ACTIONS(279),
    [anon_sym_DOTlocal] = ACTIONS(281),
    [anon_sym_DOTendlocal] = ACTIONS(279),
    [anon_sym_DOTrestartlocal] = ACTIONS(279),
    [anon_sym_DOTregisters] = ACTIONS(279),
    [anon_sym_DOTcatch] = ACTIONS(281),
    [anon_sym_RBRACE] = ACTIONS(279),
    [anon_sym_DOTcatchall] = ACTIONS(279),
    [anon_sym_DOTpacked_DASHswitch] = ACTIONS(279),
    [anon_sym_DOTsparse_DASHswitch] = ACTIONS(279),
    [anon_sym_DOTarray_DASHdata] = ACTIONS(279),
    [sym_prologue_directive] = ACTIONS(279),
    [sym_epilogue_directive] = ACTIONS(279),
    [aux_sym_label_token1] = ACTIONS(279),
    [aux_sym_jmp_label_token1] = ACTIONS(279),
    [anon_sym_RPAREN] = ACTIONS(279),
    [sym_comment] = ACTIONS(3),
  },
  [29] = {
    [ts_builtin_sym_end] = ACTIONS(283),
    [anon_sym_DOTsource] = ACTIONS(283),
    [anon_sym_DOTfield] = ACTIONS(283),
    [anon_sym_DOTendfield] = ACTIONS(283),
    [anon_sym_DOTmethod] = ACTIONS(283),
    [anon_sym_DOTendmethod] = ACTIONS(283),
    [anon_sym_DOTannotation] = ACTIONS(283),
    [anon_sym_DOTparam] = ACTIONS(285),
    [anon_sym_COMMA] = ACTIONS(283),
    [anon_sym_DOTparameter] = ACTIONS(283),
    [anon_sym_nop] = ACTIONS(285),
    [anon_sym_move] = ACTIONS(285),
    [anon_sym_move_SLASHfrom16] = ACTIONS(283),
    [anon_sym_move_SLASH16] = ACTIONS(283),
    [anon_sym_move_DASHwide] = ACTIONS(285),
    [anon_sym_move_DASHwide_SLASHfrom16] = ACTIONS(283),
    [anon_sym_move_DASHwide_SLASH16] = ACTIONS(283),
    [anon_sym_move_DASHobject] = ACTIONS(285),
    [anon_sym_move_DASHobject_SLASHfrom16] = ACTIONS(283),
    [anon_sym_move_DASHobject_SLASH16] = ACTIONS(283),
    [anon_sym_move_DASHresult] = ACTIONS(285),
    [anon_sym_move_DASHresult_DASHwide] = ACTIONS(283),
    [anon_sym_move_DASHresult_DASHobject] = ACTIONS(283),
    [anon_sym_move_DASHexception] = ACTIONS(283),
    [anon_sym_return_DASHvoid] = ACTIONS(283),
    [anon_sym_return] = ACTIONS(285),
    [anon_sym_return_DASHwide] = ACTIONS(283),
    [anon_sym_return_DASHobject] = ACTIONS(283),
    [anon_sym_const_SLASH4] = ACTIONS(283),
    [anon_sym_const_SLASH16] = ACTIONS(283),
    [anon_sym_const] = ACTIONS(285),
    [anon_sym_const_SLASHhigh16] = ACTIONS(283),
    [anon_sym_const_DASHwide_SLASH16] = ACTIONS(283),
    [anon_sym_const_DASHwide_SLASH32] = ACTIONS(283),
    [anon_sym_const_DASHwide] = ACTIONS(285),
    [anon_sym_const_DASHwide_SLASHhigh16] = ACTIONS(283),
    [anon_sym_const_DASHstring] = ACTIONS(285),
    [anon_sym_const_DASHstring_SLASHjumbo] = ACTIONS(283),
    [anon_sym_const_DASHclass] = ACTIONS(283),
    [anon_sym_const_DASHmethod_DASHhandle] = ACTIONS(283),
    [anon_sym_const_DASHmethod_DASHtype] = ACTIONS(283),
    [anon_sym_monitor_DASHenter] = ACTIONS(283),
    [anon_sym_monitor_DASHexit] = ACTIONS(283),
    [anon_sym_check_DASHcast] = ACTIONS(283),
    [anon_sym_instance_DASHof] = ACTIONS(283),
    [anon_sym_array_DASHlength] = ACTIONS(283),
    [anon_sym_new_DASHinstance] = ACTIONS(283),
    [anon_sym_new_DASHarray] = ACTIONS(283),
    [anon_sym_filled_DASHnew_DASHarray] = ACTIONS(285),
    [anon_sym_filled_DASHnew_DASHarray_SLASHrange] = ACTIONS(283),
    [anon_sym_fill_DASHarray_DASHdata] = ACTIONS(283),
    [anon_sym_throw] = ACTIONS(285),
    [anon_sym_throw_DASHverification_DASHerror] = ACTIONS(283),
    [anon_sym_goto] = ACTIONS(285),
    [anon_sym_goto_SLASH16] = ACTIONS(283),
    [anon_sym_goto_SLASH32] = ACTIONS(283),
    [anon_sym_packed_DASHswitch] = ACTIONS(283),
    [anon_sym_sparse_DASHswitch] = ACTIONS(283),
    [anon_sym_cmpl_DASHfloat] = ACTIONS(283),
    [anon_sym_cmpg_DASHfloat] = ACTIONS(283),
    [anon_sym_cmpl_DASHdouble] = ACTIONS(283),
    [anon_sym_cmpg_DASHdouble] = ACTIONS(283),
    [anon_sym_cmp_DASHlong] = ACTIONS(283),
    [anon_sym_if_DASHeq] = ACTIONS(285),
    [anon_sym_if_DASHne] = ACTIONS(285),
    [anon_sym_if_DASHlt] = ACTIONS(285),
    [anon_sym_if_DASHge] = ACTIONS(285),
    [anon_sym_if_DASHgt] = ACTIONS(285),
    [anon_sym_if_DASHle] = ACTIONS(285),
    [anon_sym_if_DASHeqz] = ACTIONS(283),
    [anon_sym_if_DASHnez] = ACTIONS(283),
    [anon_sym_if_DASHltz] = ACTIONS(283),
    [anon_sym_if_DASHgez] = ACTIONS(283),
    [anon_sym_if_DASHgtz] = ACTIONS(283),
    [anon_sym_if_DASHlez] = ACTIONS(283),
    [anon_sym_aget] = ACTIONS(285),
    [anon_sym_aget_DASHwide] = ACTIONS(283),
    [anon_sym_aget_DASHobject] = ACTIONS(283),
    [anon_sym_aget_DASHboolean] = ACTIONS(283),
    [anon_sym_aget_DASHbyte] = ACTIONS(283),
    [anon_sym_aget_DASHchar] = ACTIONS(283),
    [anon_sym_aget_DASHshort] = ACTIONS(283),
    [anon_sym_aput] = ACTIONS(285),
    [anon_sym_aput_DASHwide] = ACTIONS(283),
    [anon_sym_aput_DASHobject] = ACTIONS(283),
    [anon_sym_aput_DASHboolean] = ACTIONS(283),
    [anon_sym_aput_DASHbyte] = ACTIONS(283),
    [anon_sym_aput_DASHchar] = ACTIONS(283),
    [anon_sym_aput_DASHshort] = ACTIONS(283),
    [anon_sym_iget] = ACTIONS(285),
    [anon_sym_iget_DASHwide] = ACTIONS(285),
    [anon_sym_iget_DASHobject] = ACTIONS(285),
    [anon_sym_iget_DASHboolean] = ACTIONS(283),
    [anon_sym_iget_DASHbyte] = ACTIONS(283),
    [anon_sym_iget_DASHchar] = ACTIONS(283),
    [anon_sym_iget_DASHshort] = ACTIONS(283),
    [anon_sym_iget_DASHvolatile] = ACTIONS(283),
    [anon_sym_iget_DASHwide_DASHvolatile] = ACTIONS(283),
    [anon_sym_iget_DASHobject_DASHvolatile] = ACTIONS(283),
    [anon_sym_iput] = ACTIONS(285),
    [anon_sym_iput_DASHwide] = ACTIONS(285),
    [anon_sym_iput_DASHobject] = ACTIONS(285),
    [anon_sym_iput_DASHboolean] = ACTIONS(285),
    [anon_sym_iput_DASHbyte] = ACTIONS(285),
    [anon_sym_iput_DASHchar] = ACTIONS(285),
    [anon_sym_iput_DASHshort] = ACTIONS(285),
    [anon_sym_iput_DASHvolatile] = ACTIONS(283),
    [anon_sym_iput_DASHwide_DASHvolatile] = ACTIONS(283),
    [anon_sym_iput_DASHobject_DASHvolatile] = ACTIONS(283),
    [anon_sym_sget] = ACTIONS(285),
    [anon_sym_sget_DASHwide] = ACTIONS(285),
    [anon_sym_sget_DASHobject] = ACTIONS(285),
    [anon_sym_sget_DASHboolean] = ACTIONS(283),
    [anon_sym_sget_DASHbyte] = ACTIONS(283),
    [anon_sym_sget_DASHchar] = ACTIONS(283),
    [anon_sym_sget_DASHshort] = ACTIONS(283),
    [anon_sym_sget_DASHvolatile] = ACTIONS(283),
    [anon_sym_sget_DASHwide_DASHvolatile] = ACTIONS(283),
    [anon_sym_sget_DASHobject_DASHvolatile] = ACTIONS(283),
    [anon_sym_sput] = ACTIONS(285),
    [anon_sym_sput_DASHwide] = ACTIONS(285),
    [anon_sym_sput_DASHobject] = ACTIONS(285),
    [anon_sym_sput_DASHboolean] = ACTIONS(283),
    [anon_sym_sput_DASHbyte] = ACTIONS(283),
    [anon_sym_sput_DASHchar] = ACTIONS(283),
    [anon_sym_sput_DASHshort] = ACTIONS(283),
    [anon_sym_sput_DASHvolatile] = ACTIONS(283),
    [anon_sym_sput_DASHwide_DASHvolatile] = ACTIONS(283),
    [anon_sym_sput_DASHobject_DASHvolatile] = ACTIONS(283),
    [anon_sym_invoke_DASHconstructor] = ACTIONS(283),
    [anon_sym_invoke_DASHcustom] = ACTIONS(285),
    [anon_sym_invoke_DASHdirect] = ACTIONS(285),
    [anon_sym_invoke_DASHdirect_DASHempty] = ACTIONS(283),
    [anon_sym_invoke_DASHinstance] = ACTIONS(283),
    [anon_sym_invoke_DASHinterface] = ACTIONS(285),
    [anon_sym_invoke_DASHpolymorphic] = ACTIONS(285),
    [anon_sym_invoke_DASHstatic] = ACTIONS(285),
    [anon_sym_invoke_DASHsuper] = ACTIONS(285),
    [anon_sym_invoke_DASHvirtual] = ACTIONS(285),
    [anon_sym_invoke_DASHcustom_SLASHrange] = ACTIONS(283),
    [anon_sym_invoke_DASHdirect_SLASHrange] = ACTIONS(283),
    [anon_sym_invoke_DASHinterface_SLASHrange] = ACTIONS(283),
    [anon_sym_invoke_DASHobject_DASHinit_SLASHrange] = ACTIONS(283),
    [anon_sym_invoke_DASHpolymorphic_SLASHrange] = ACTIONS(283),
    [anon_sym_invoke_DASHstatic_SLASHrange] = ACTIONS(283),
    [anon_sym_invoke_DASHsuper_SLASHrange] = ACTIONS(283),
    [anon_sym_invoke_DASHvirtual_SLASHrange] = ACTIONS(283),
    [anon_sym_neg_DASHint] = ACTIONS(283),
    [anon_sym_not_DASHint] = ACTIONS(283),
    [anon_sym_neg_DASHlong] = ACTIONS(283),
    [anon_sym_not_DASHlong] = ACTIONS(283),
    [anon_sym_neg_DASHfloat] = ACTIONS(283),
    [anon_sym_neg_DASHdouble] = ACTIONS(283),
    [anon_sym_int_DASHto_DASHlong] = ACTIONS(283),
    [anon_sym_int_DASHto_DASHfloat] = ACTIONS(283),
    [anon_sym_int_DASHto_DASHdouble] = ACTIONS(283),
    [anon_sym_long_DASHto_DASHint] = ACTIONS(283),
    [anon_sym_long_DASHto_DASHfloat] = ACTIONS(283),
    [anon_sym_long_DASHto_DASHdouble] = ACTIONS(283),
    [anon_sym_float_DASHto_DASHint] = ACTIONS(283),
    [anon_sym_float_DASHto_DASHlong] = ACTIONS(283),
    [anon_sym_float_DASHto_DASHdouble] = ACTIONS(283),
    [anon_sym_double_DASHto_DASHint] = ACTIONS(283),
    [anon_sym_double_DASHto_DASHlong] = ACTIONS(283),
    [anon_sym_double_DASHto_DASHfloat] = ACTIONS(283),
    [anon_sym_int_DASHto_DASHbyte] = ACTIONS(283),
    [anon_sym_int_DASHto_DASHchar] = ACTIONS(283),
    [anon_sym_int_DASHto_DASHshort] = ACTIONS(283),
    [anon_sym_add_DASHint] = ACTIONS(285),
    [anon_sym_sub_DASHint] = ACTIONS(285),
    [anon_sym_mul_DASHint] = ACTIONS(285),
    [anon_sym_div_DASHint] = ACTIONS(285),
    [anon_sym_rem_DASHint] = ACTIONS(285),
    [anon_sym_and_DASHint] = ACTIONS(285),
    [anon_sym_or_DASHint] = ACTIONS(285),
    [anon_sym_xor_DASHint] = ACTIONS(285),
    [anon_sym_shl_DASHint] = ACTIONS(285),
    [anon_sym_shr_DASHint] = ACTIONS(285),
    [anon_sym_ushr_DASHint] = ACTIONS(285),
    [anon_sym_add_DASHlong] = ACTIONS(285),
    [anon_sym_sub_DASHlong] = ACTIONS(285),
    [anon_sym_mul_DASHlong] = ACTIONS(285),
    [anon_sym_div_DASHlong] = ACTIONS(285),
    [anon_sym_rem_DASHlong] = ACTIONS(285),
    [anon_sym_and_DASHlong] = ACTIONS(285),
    [anon_sym_or_DASHlong] = ACTIONS(285),
    [anon_sym_xor_DASHlong] = ACTIONS(285),
    [anon_sym_shl_DASHlong] = ACTIONS(285),
    [anon_sym_shr_DASHlong] = ACTIONS(285),
    [anon_sym_ushr_DASHlong] = ACTIONS(285),
    [anon_sym_add_DASHfloat] = ACTIONS(285),
    [anon_sym_sub_DASHfloat] = ACTIONS(285),
    [anon_sym_mul_DASHfloat] = ACTIONS(285),
    [anon_sym_div_DASHfloat] = ACTIONS(285),
    [anon_sym_rem_DASHfloat] = ACTIONS(285),
    [anon_sym_add_DASHdouble] = ACTIONS(285),
    [anon_sym_sub_DASHdouble] = ACTIONS(285),
    [anon_sym_mul_DASHdouble] = ACTIONS(285),
    [anon_sym_div_DASHdouble] = ACTIONS(285),
    [anon_sym_rem_DASHdouble] = ACTIONS(285),
    [anon_sym_add_DASHint_SLASH2addr] = ACTIONS(283),
    [anon_sym_sub_DASHint_SLASH2addr] = ACTIONS(283),
    [anon_sym_mul_DASHint_SLASH2addr] = ACTIONS(283),
    [anon_sym_div_DASHint_SLASH2addr] = ACTIONS(283),
    [anon_sym_rem_DASHint_SLASH2addr] = ACTIONS(283),
    [anon_sym_and_DASHint_SLASH2addr] = ACTIONS(283),
    [anon_sym_or_DASHint_SLASH2addr] = ACTIONS(283),
    [anon_sym_xor_DASHint_SLASH2addr] = ACTIONS(283),
    [anon_sym_shl_DASHint_SLASH2addr] = ACTIONS(283),
    [anon_sym_shr_DASHint_SLASH2addr] = ACTIONS(283),
    [anon_sym_ushr_DASHint_SLASH2addr] = ACTIONS(283),
    [anon_sym_add_DASHlong_SLASH2addr] = ACTIONS(283),
    [anon_sym_sub_DASHlong_SLASH2addr] = ACTIONS(283),
    [anon_sym_mul_DASHlong_SLASH2addr] = ACTIONS(283),
    [anon_sym_div_DASHlong_SLASH2addr] = ACTIONS(283),
    [anon_sym_rem_DASHlong_SLASH2addr] = ACTIONS(283),
    [anon_sym_and_DASHlong_SLASH2addr] = ACTIONS(283),
    [anon_sym_or_DASHlong_SLASH2addr] = ACTIONS(283),
    [anon_sym_xor_DASHlong_SLASH2addr] = ACTIONS(283),
    [anon_sym_shl_DASHlong_SLASH2addr] = ACTIONS(283),
    [anon_sym_shr_DASHlong_SLASH2addr] = ACTIONS(283),
    [anon_sym_ushr_DASHlong_SLASH2addr] = ACTIONS(283),
    [anon_sym_add_DASHfloat_SLASH2addr] = ACTIONS(283),
    [anon_sym_sub_DASHfloat_SLASH2addr] = ACTIONS(283),
    [anon_sym_mul_DASHfloat_SLASH2addr] = ACTIONS(283),
    [anon_sym_div_DASHfloat_SLASH2addr] = ACTIONS(283),
    [anon_sym_rem_DASHfloat_SLASH2addr] = ACTIONS(283),
    [anon_sym_add_DASHdouble_SLASH2addr] = ACTIONS(283),
    [anon_sym_sub_DASHdouble_SLASH2addr] = ACTIONS(283),
    [anon_sym_mul_DASHdouble_SLASH2addr] = ACTIONS(283),
    [anon_sym_div_DASHdouble_SLASH2addr] = ACTIONS(283),
    [anon_sym_rem_DASHdouble_SLASH2addr] = ACTIONS(283),
    [anon_sym_add_DASHint_SLASHlit16] = ACTIONS(283),
    [anon_sym_sub_DASHint_SLASHlit16] = ACTIONS(283),
    [anon_sym_mul_DASHint_SLASHlit16] = ACTIONS(283),
    [anon_sym_div_DASHint_SLASHlit16] = ACTIONS(283),
    [anon_sym_rem_DASHint_SLASHlit16] = ACTIONS(283),
    [anon_sym_and_DASHint_SLASHlit16] = ACTIONS(283),
    [anon_sym_or_DASHint_SLASHlit16] = ACTIONS(283),
    [anon_sym_xor_DASHint_SLASHlit16] = ACTIONS(283),
    [anon_sym_add_DASHint_SLASHlit8] = ACTIONS(283),
    [anon_sym_sub_DASHint_SLASHlit8] = ACTIONS(283),
    [anon_sym_mul_DASHint_SLASHlit8] = ACTIONS(283),
    [anon_sym_div_DASHint_SLASHlit8] = ACTIONS(283),
    [anon_sym_rem_DASHint_SLASHlit8] = ACTIONS(283),
    [anon_sym_and_DASHint_SLASHlit8] = ACTIONS(283),
    [anon_sym_or_DASHint_SLASHlit8] = ACTIONS(283),
    [anon_sym_xor_DASHint_SLASHlit8] = ACTIONS(283),
    [anon_sym_shl_DASHint_SLASHlit8] = ACTIONS(283),
    [anon_sym_shr_DASHint_SLASHlit8] = ACTIONS(283),
    [anon_sym_ushr_DASHint_SLASHlit8] = ACTIONS(283),
    [anon_sym_static_DASHget] = ACTIONS(283),
    [anon_sym_static_DASHput] = ACTIONS(283),
    [anon_sym_instance_DASHget] = ACTIONS(283),
    [anon_sym_instance_DASHput] = ACTIONS(283),
    [anon_sym_execute_DASHinline] = ACTIONS(285),
    [anon_sym_execute_DASHinline_SLASHrange] = ACTIONS(283),
    [anon_sym_iget_DASHquick] = ACTIONS(283),
    [anon_sym_iget_DASHwide_DASHquick] = ACTIONS(283),
    [anon_sym_iget_DASHobject_DASHquick] = ACTIONS(283),
    [anon_sym_iput_DASHquick] = ACTIONS(283),
    [anon_sym_iput_DASHwide_DASHquick] = ACTIONS(283),
    [anon_sym_iput_DASHobject_DASHquick] = ACTIONS(283),
    [anon_sym_iput_DASHboolean_DASHquick] = ACTIONS(283),
    [anon_sym_iput_DASHbyte_DASHquick] = ACTIONS(283),
    [anon_sym_iput_DASHchar_DASHquick] = ACTIONS(283),
    [anon_sym_iput_DASHshort_DASHquick] = ACTIONS(283),
    [anon_sym_invoke_DASHvirtual_DASHquick] = ACTIONS(285),
    [anon_sym_invoke_DASHvirtual_DASHquick_SLASHrange] = ACTIONS(283),
    [anon_sym_invoke_DASHsuper_DASHquick] = ACTIONS(285),
    [anon_sym_invoke_DASHsuper_DASHquick_SLASHrange] = ACTIONS(283),
    [anon_sym_rsub_DASHint] = ACTIONS(285),
    [anon_sym_rsub_DASHint_SLASHlit8] = ACTIONS(283),
    [anon_sym_DOTline] = ACTIONS(283),
    [anon_sym_DOTlocals] = ACTIONS(283),
    [anon_sym_DOTlocal] = ACTIONS(285),
    [anon_sym_DOTendlocal] = ACTIONS(283),
    [anon_sym_DOTrestartlocal] = ACTIONS(283),
    [anon_sym_DOTregisters] = ACTIONS(283),
    [anon_sym_DOTcatch] = ACTIONS(285),
    [anon_sym_RBRACE] = ACTIONS(283),
    [anon_sym_DOTcatchall] = ACTIONS(283),
    [anon_sym_DOTpacked_DASHswitch] = ACTIONS(283),
    [anon_sym_DOTsparse_DASHswitch] = ACTIONS(283),
    [anon_sym_DOTarray_DASHdata] = ACTIONS(283),
    [sym_prologue_directive] = ACTIONS(283),
    [sym_epilogue_directive] = ACTIONS(283),
    [aux_sym_label_token1] = ACTIONS(283),
    [aux_sym_jmp_label_token1] = ACTIONS(283),
    [anon_sym_RPAREN] = ACTIONS(283),
    [sym_comment] = ACTIONS(3),
  },
  [30] = {
    [ts_builtin_sym_end] = ACTIONS(287),
    [anon_sym_DOTsource] = ACTIONS(287),
    [anon_sym_DOTfield] = ACTIONS(287),
    [anon_sym_DOTendfield] = ACTIONS(287),
    [anon_sym_DOTmethod] = ACTIONS(287),
    [anon_sym_DOTendmethod] = ACTIONS(287),
    [anon_sym_DOTannotation] = ACTIONS(287),
    [anon_sym_DOTparam] = ACTIONS(289),
    [anon_sym_COMMA] = ACTIONS(287),
    [anon_sym_DOTparameter] = ACTIONS(287),
    [anon_sym_DOTendparameter] = ACTIONS(287),
    [anon_sym_nop] = ACTIONS(289),
    [anon_sym_move] = ACTIONS(289),
    [anon_sym_move_SLASHfrom16] = ACTIONS(287),
    [anon_sym_move_SLASH16] = ACTIONS(287),
    [anon_sym_move_DASHwide] = ACTIONS(289),
    [anon_sym_move_DASHwide_SLASHfrom16] = ACTIONS(287),
    [anon_sym_move_DASHwide_SLASH16] = ACTIONS(287),
    [anon_sym_move_DASHobject] = ACTIONS(289),
    [anon_sym_move_DASHobject_SLASHfrom16] = ACTIONS(287),
    [anon_sym_move_DASHobject_SLASH16] = ACTIONS(287),
    [anon_sym_move_DASHresult] = ACTIONS(289),
    [anon_sym_move_DASHresult_DASHwide] = ACTIONS(287),
    [anon_sym_move_DASHresult_DASHobject] = ACTIONS(287),
    [anon_sym_move_DASHexception] = ACTIONS(287),
    [anon_sym_return_DASHvoid] = ACTIONS(287),
    [anon_sym_return] = ACTIONS(289),
    [anon_sym_return_DASHwide] = ACTIONS(287),
    [anon_sym_return_DASHobject] = ACTIONS(287),
    [anon_sym_const_SLASH4] = ACTIONS(287),
    [anon_sym_const_SLASH16] = ACTIONS(287),
    [anon_sym_const] = ACTIONS(289),
    [anon_sym_const_SLASHhigh16] = ACTIONS(287),
    [anon_sym_const_DASHwide_SLASH16] = ACTIONS(287),
    [anon_sym_const_DASHwide_SLASH32] = ACTIONS(287),
    [anon_sym_const_DASHwide] = ACTIONS(289),
    [anon_sym_const_DASHwide_SLASHhigh16] = ACTIONS(287),
    [anon_sym_const_DASHstring] = ACTIONS(289),
    [anon_sym_const_DASHstring_SLASHjumbo] = ACTIONS(287),
    [anon_sym_const_DASHclass] = ACTIONS(287),
    [anon_sym_const_DASHmethod_DASHhandle] = ACTIONS(287),
    [anon_sym_const_DASHmethod_DASHtype] = ACTIONS(287),
    [anon_sym_monitor_DASHenter] = ACTIONS(287),
    [anon_sym_monitor_DASHexit] = ACTIONS(287),
    [anon_sym_check_DASHcast] = ACTIONS(287),
    [anon_sym_instance_DASHof] = ACTIONS(287),
    [anon_sym_array_DASHlength] = ACTIONS(287),
    [anon_sym_new_DASHinstance] = ACTIONS(287),
    [anon_sym_new_DASHarray] = ACTIONS(287),
    [anon_sym_filled_DASHnew_DASHarray] = ACTIONS(289),
    [anon_sym_filled_DASHnew_DASHarray_SLASHrange] = ACTIONS(287),
    [anon_sym_fill_DASHarray_DASHdata] = ACTIONS(287),
    [anon_sym_throw] = ACTIONS(289),
    [anon_sym_throw_DASHverification_DASHerror] = ACTIONS(287),
    [anon_sym_goto] = ACTIONS(289),
    [anon_sym_goto_SLASH16] = ACTIONS(287),
    [anon_sym_goto_SLASH32] = ACTIONS(287),
    [anon_sym_packed_DASHswitch] = ACTIONS(287),
    [anon_sym_sparse_DASHswitch] = ACTIONS(287),
    [anon_sym_cmpl_DASHfloat] = ACTIONS(287),
    [anon_sym_cmpg_DASHfloat] = ACTIONS(287),
    [anon_sym_cmpl_DASHdouble] = ACTIONS(287),
    [anon_sym_cmpg_DASHdouble] = ACTIONS(287),
    [anon_sym_cmp_DASHlong] = ACTIONS(287),
    [anon_sym_if_DASHeq] = ACTIONS(289),
    [anon_sym_if_DASHne] = ACTIONS(289),
    [anon_sym_if_DASHlt] = ACTIONS(289),
    [anon_sym_if_DASHge] = ACTIONS(289),
    [anon_sym_if_DASHgt] = ACTIONS(289),
    [anon_sym_if_DASHle] = ACTIONS(289),
    [anon_sym_if_DASHeqz] = ACTIONS(287),
    [anon_sym_if_DASHnez] = ACTIONS(287),
    [anon_sym_if_DASHltz] = ACTIONS(287),
    [anon_sym_if_DASHgez] = ACTIONS(287),
    [anon_sym_if_DASHgtz] = ACTIONS(287),
    [anon_sym_if_DASHlez] = ACTIONS(287),
    [anon_sym_aget] = ACTIONS(289),
    [anon_sym_aget_DASHwide] = ACTIONS(287),
    [anon_sym_aget_DASHobject] = ACTIONS(287),
    [anon_sym_aget_DASHboolean] = ACTIONS(287),
    [anon_sym_aget_DASHbyte] = ACTIONS(287),
    [anon_sym_aget_DASHchar] = ACTIONS(287),
    [anon_sym_aget_DASHshort] = ACTIONS(287),
    [anon_sym_aput] = ACTIONS(289),
    [anon_sym_aput_DASHwide] = ACTIONS(287),
    [anon_sym_aput_DASHobject] = ACTIONS(287),
    [anon_sym_aput_DASHboolean] = ACTIONS(287),
    [anon_sym_aput_DASHbyte] = ACTIONS(287),
    [anon_sym_aput_DASHchar] = ACTIONS(287),
    [anon_sym_aput_DASHshort] = ACTIONS(287),
    [anon_sym_iget] = ACTIONS(289),
    [anon_sym_iget_DASHwide] = ACTIONS(289),
    [anon_sym_iget_DASHobject] = ACTIONS(289),
    [anon_sym_iget_DASHboolean] = ACTIONS(287),
    [anon_sym_iget_DASHbyte] = ACTIONS(287),
    [anon_sym_iget_DASHchar] = ACTIONS(287),
    [anon_sym_iget_DASHshort] = ACTIONS(287),
    [anon_sym_iget_DASHvolatile] = ACTIONS(287),
    [anon_sym_iget_DASHwide_DASHvolatile] = ACTIONS(287),
    [anon_sym_iget_DASHobject_DASHvolatile] = ACTIONS(287),
    [anon_sym_iput] = ACTIONS(289),
    [anon_sym_iput_DASHwide] = ACTIONS(289),
    [anon_sym_iput_DASHobject] = ACTIONS(289),
    [anon_sym_iput_DASHboolean] = ACTIONS(289),
    [anon_sym_iput_DASHbyte] = ACTIONS(289),
    [anon_sym_iput_DASHchar] = ACTIONS(289),
    [anon_sym_iput_DASHshort] = ACTIONS(289),
    [anon_sym_iput_DASHvolatile] = ACTIONS(287),
    [anon_sym_iput_DASHwide_DASHvolatile] = ACTIONS(287),
    [anon_sym_iput_DASHobject_DASHvolatile] = ACTIONS(287),
    [anon_sym_sget] = ACTIONS(289),
    [anon_sym_sget_DASHwide] = ACTIONS(289),
    [anon_sym_sget_DASHobject] = ACTIONS(289),
    [anon_sym_sget_DASHboolean] = ACTIONS(287),
    [anon_sym_sget_DASHbyte] = ACTIONS(287),
    [anon_sym_sget_DASHchar] = ACTIONS(287),
    [anon_sym_sget_DASHshort] = ACTIONS(287),
    [anon_sym_sget_DASHvolatile] = ACTIONS(287),
    [anon_sym_sget_DASHwide_DASHvolatile] = ACTIONS(287),
    [anon_sym_sget_DASHobject_DASHvolatile] = ACTIONS(287),
    [anon_sym_sput] = ACTIONS(289),
    [anon_sym_sput_DASHwide] = ACTIONS(289),
    [anon_sym_sput_DASHobject] = ACTIONS(289),
    [anon_sym_sput_DASHboolean] = ACTIONS(287),
    [anon_sym_sput_DASHbyte] = ACTIONS(287),
    [anon_sym_sput_DASHchar] = ACTIONS(287),
    [anon_sym_sput_DASHshort] = ACTIONS(287),
    [anon_sym_sput_DASHvolatile] = ACTIONS(287),
    [anon_sym_sput_DASHwide_DASHvolatile] = ACTIONS(287),
    [anon_sym_sput_DASHobject_DASHvolatile] = ACTIONS(287),
    [anon_sym_invoke_DASHconstructor] = ACTIONS(287),
    [anon_sym_invoke_DASHcustom] = ACTIONS(289),
    [anon_sym_invoke_DASHdirect] = ACTIONS(289),
    [anon_sym_invoke_DASHdirect_DASHempty] = ACTIONS(287),
    [anon_sym_invoke_DASHinstance] = ACTIONS(287),
    [anon_sym_invoke_DASHinterface] = ACTIONS(289),
    [anon_sym_invoke_DASHpolymorphic] = ACTIONS(289),
    [anon_sym_invoke_DASHstatic] = ACTIONS(289),
    [anon_sym_invoke_DASHsuper] = ACTIONS(289),
    [anon_sym_invoke_DASHvirtual] = ACTIONS(289),
    [anon_sym_invoke_DASHcustom_SLASHrange] = ACTIONS(287),
    [anon_sym_invoke_DASHdirect_SLASHrange] = ACTIONS(287),
    [anon_sym_invoke_DASHinterface_SLASHrange] = ACTIONS(287),
    [anon_sym_invoke_DASHobject_DASHinit_SLASHrange] = ACTIONS(287),
    [anon_sym_invoke_DASHpolymorphic_SLASHrange] = ACTIONS(287),
    [anon_sym_invoke_DASHstatic_SLASHrange] = ACTIONS(287),
    [anon_sym_invoke_DASHsuper_SLASHrange] = ACTIONS(287),
    [anon_sym_invoke_DASHvirtual_SLASHrange] = ACTIONS(287),
    [anon_sym_neg_DASHint] = ACTIONS(287),
    [anon_sym_not_DASHint] = ACTIONS(287),
    [anon_sym_neg_DASHlong] = ACTIONS(287),
    [anon_sym_not_DASHlong] = ACTIONS(287),
    [anon_sym_neg_DASHfloat] = ACTIONS(287),
    [anon_sym_neg_DASHdouble] = ACTIONS(287),
    [anon_sym_int_DASHto_DASHlong] = ACTIONS(287),
    [anon_sym_int_DASHto_DASHfloat] = ACTIONS(287),
    [anon_sym_int_DASHto_DASHdouble] = ACTIONS(287),
    [anon_sym_long_DASHto_DASHint] = ACTIONS(287),
    [anon_sym_long_DASHto_DASHfloat] = ACTIONS(287),
    [anon_sym_long_DASHto_DASHdouble] = ACTIONS(287),
    [anon_sym_float_DASHto_DASHint] = ACTIONS(287),
    [anon_sym_float_DASHto_DASHlong] = ACTIONS(287),
    [anon_sym_float_DASHto_DASHdouble] = ACTIONS(287),
    [anon_sym_double_DASHto_DASHint] = ACTIONS(287),
    [anon_sym_double_DASHto_DASHlong] = ACTIONS(287),
    [anon_sym_double_DASHto_DASHfloat] = ACTIONS(287),
    [anon_sym_int_DASHto_DASHbyte] = ACTIONS(287),
    [anon_sym_int_DASHto_DASHchar] = ACTIONS(287),
    [anon_sym_int_DASHto_DASHshort] = ACTIONS(287),
    [anon_sym_add_DASHint] = ACTIONS(289),
    [anon_sym_sub_DASHint] = ACTIONS(289),
    [anon_sym_mul_DASHint] = ACTIONS(289),
    [anon_sym_div_DASHint] = ACTIONS(289),
    [anon_sym_rem_DASHint] = ACTIONS(289),
    [anon_sym_and_DASHint] = ACTIONS(289),
    [anon_sym_or_DASHint] = ACTIONS(289),
    [anon_sym_xor_DASHint] = ACTIONS(289),
    [anon_sym_shl_DASHint] = ACTIONS(289),
    [anon_sym_shr_DASHint] = ACTIONS(289),
    [anon_sym_ushr_DASHint] = ACTIONS(289),
    [anon_sym_add_DASHlong] = ACTIONS(289),
    [anon_sym_sub_DASHlong] = ACTIONS(289),
    [anon_sym_mul_DASHlong] = ACTIONS(289),
    [anon_sym_div_DASHlong] = ACTIONS(289),
    [anon_sym_rem_DASHlong] = ACTIONS(289),
    [anon_sym_and_DASHlong] = ACTIONS(289),
    [anon_sym_or_DASHlong] = ACTIONS(289),
    [anon_sym_xor_DASHlong] = ACTIONS(289),
    [anon_sym_shl_DASHlong] = ACTIONS(289),
    [anon_sym_shr_DASHlong] = ACTIONS(289),
    [anon_sym_ushr_DASHlong] = ACTIONS(289),
    [anon_sym_add_DASHfloat] = ACTIONS(289),
    [anon_sym_sub_DASHfloat] = ACTIONS(289),
    [anon_sym_mul_DASHfloat] = ACTIONS(289),
    [anon_sym_div_DASHfloat] = ACTIONS(289),
    [anon_sym_rem_DASHfloat] = ACTIONS(289),
    [anon_sym_add_DASHdouble] = ACTIONS(289),
    [anon_sym_sub_DASHdouble] = ACTIONS(289),
    [anon_sym_mul_DASHdouble] = ACTIONS(289),
    [anon_sym_div_DASHdouble] = ACTIONS(289),
    [anon_sym_rem_DASHdouble] = ACTIONS(289),
    [anon_sym_add_DASHint_SLASH2addr] = ACTIONS(287),
    [anon_sym_sub_DASHint_SLASH2addr] = ACTIONS(287),
    [anon_sym_mul_DASHint_SLASH2addr] = ACTIONS(287),
    [anon_sym_div_DASHint_SLASH2addr] = ACTIONS(287),
    [anon_sym_rem_DASHint_SLASH2addr] = ACTIONS(287),
    [anon_sym_and_DASHint_SLASH2addr] = ACTIONS(287),
    [anon_sym_or_DASHint_SLASH2addr] = ACTIONS(287),
    [anon_sym_xor_DASHint_SLASH2addr] = ACTIONS(287),
    [anon_sym_shl_DASHint_SLASH2addr] = ACTIONS(287),
    [anon_sym_shr_DASHint_SLASH2addr] = ACTIONS(287),
    [anon_sym_ushr_DASHint_SLASH2addr] = ACTIONS(287),
    [anon_sym_add_DASHlong_SLASH2addr] = ACTIONS(287),
    [anon_sym_sub_DASHlong_SLASH2addr] = ACTIONS(287),
    [anon_sym_mul_DASHlong_SLASH2addr] = ACTIONS(287),
    [anon_sym_div_DASHlong_SLASH2addr] = ACTIONS(287),
    [anon_sym_rem_DASHlong_SLASH2addr] = ACTIONS(287),
    [anon_sym_and_DASHlong_SLASH2addr] = ACTIONS(287),
    [anon_sym_or_DASHlong_SLASH2addr] = ACTIONS(287),
    [anon_sym_xor_DASHlong_SLASH2addr] = ACTIONS(287),
    [anon_sym_shl_DASHlong_SLASH2addr] = ACTIONS(287),
    [anon_sym_shr_DASHlong_SLASH2addr] = ACTIONS(287),
    [anon_sym_ushr_DASHlong_SLASH2addr] = ACTIONS(287),
    [anon_sym_add_DASHfloat_SLASH2addr] = ACTIONS(287),
    [anon_sym_sub_DASHfloat_SLASH2addr] = ACTIONS(287),
    [anon_sym_mul_DASHfloat_SLASH2addr] = ACTIONS(287),
    [anon_sym_div_DASHfloat_SLASH2addr] = ACTIONS(287),
    [anon_sym_rem_DASHfloat_SLASH2addr] = ACTIONS(287),
    [anon_sym_add_DASHdouble_SLASH2addr] = ACTIONS(287),
    [anon_sym_sub_DASHdouble_SLASH2addr] = ACTIONS(287),
    [anon_sym_mul_DASHdouble_SLASH2addr] = ACTIONS(287),
    [anon_sym_div_DASHdouble_SLASH2addr] = ACTIONS(287),
    [anon_sym_rem_DASHdouble_SLASH2addr] = ACTIONS(287),
    [anon_sym_add_DASHint_SLASHlit16] = ACTIONS(287),
    [anon_sym_sub_DASHint_SLASHlit16] = ACTIONS(287),
    [anon_sym_mul_DASHint_SLASHlit16] = ACTIONS(287),
    [anon_sym_div_DASHint_SLASHlit16] = ACTIONS(287),
    [anon_sym_rem_DASHint_SLASHlit16] = ACTIONS(287),
    [anon_sym_and_DASHint_SLASHlit16] = ACTIONS(287),
    [anon_sym_or_DASHint_SLASHlit16] = ACTIONS(287),
    [anon_sym_xor_DASHint_SLASHlit16] = ACTIONS(287),
    [anon_sym_add_DASHint_SLASHlit8] = ACTIONS(287),
    [anon_sym_sub_DASHint_SLASHlit8] = ACTIONS(287),
    [anon_sym_mul_DASHint_SLASHlit8] = ACTIONS(287),
    [anon_sym_div_DASHint_SLASHlit8] = ACTIONS(287),
    [anon_sym_rem_DASHint_SLASHlit8] = ACTIONS(287),
    [anon_sym_and_DASHint_SLASHlit8] = ACTIONS(287),
    [anon_sym_or_DASHint_SLASHlit8] = ACTIONS(287),
    [anon_sym_xor_DASHint_SLASHlit8] = ACTIONS(287),
    [anon_sym_shl_DASHint_SLASHlit8] = ACTIONS(287),
    [anon_sym_shr_DASHint_SLASHlit8] = ACTIONS(287),
    [anon_sym_ushr_DASHint_SLASHlit8] = ACTIONS(287),
    [anon_sym_static_DASHget] = ACTIONS(287),
    [anon_sym_static_DASHput] = ACTIONS(287),
    [anon_sym_instance_DASHget] = ACTIONS(287),
    [anon_sym_instance_DASHput] = ACTIONS(287),
    [anon_sym_execute_DASHinline] = ACTIONS(289),
    [anon_sym_execute_DASHinline_SLASHrange] = ACTIONS(287),
    [anon_sym_iget_DASHquick] = ACTIONS(287),
    [anon_sym_iget_DASHwide_DASHquick] = ACTIONS(287),
    [anon_sym_iget_DASHobject_DASHquick] = ACTIONS(287),
    [anon_sym_iput_DASHquick] = ACTIONS(287),
    [anon_sym_iput_DASHwide_DASHquick] = ACTIONS(287),
    [anon_sym_iput_DASHobject_DASHquick] = ACTIONS(287),
    [anon_sym_iput_DASHboolean_DASHquick] = ACTIONS(287),
    [anon_sym_iput_DASHbyte_DASHquick] = ACTIONS(287),
    [anon_sym_iput_DASHchar_DASHquick] = ACTIONS(287),
    [anon_sym_iput_DASHshort_DASHquick] = ACTIONS(287),
    [anon_sym_invoke_DASHvirtual_DASHquick] = ACTIONS(289),
    [anon_sym_invoke_DASHvirtual_DASHquick_SLASHrange] = ACTIONS(287),
    [anon_sym_invoke_DASHsuper_DASHquick] = ACTIONS(289),
    [anon_sym_invoke_DASHsuper_DASHquick_SLASHrange] = ACTIONS(287),
    [anon_sym_rsub_DASHint] = ACTIONS(289),
    [anon_sym_rsub_DASHint_SLASHlit8] = ACTIONS(287),
    [anon_sym_DOTline] = ACTIONS(287),
    [anon_sym_DOTlocals] = ACTIONS(287),
    [anon_sym_DOTlocal] = ACTIONS(289),
    [anon_sym_DOTendlocal] = ACTIONS(287),
    [anon_sym_DOTrestartlocal] = ACTIONS(287),
    [anon_sym_DOTregisters] = ACTIONS(287),
    [anon_sym_DOTcatch] = ACTIONS(289),
    [anon_sym_RBRACE] = ACTIONS(287),
    [anon_sym_DOTcatchall] = ACTIONS(287),
    [anon_sym_DOTpacked_DASHswitch] = ACTIONS(287),
    [anon_sym_DOTsparse_DASHswitch] = ACTIONS(287),
    [anon_sym_DOTarray_DASHdata] = ACTIONS(287),
    [sym_prologue_directive] = ACTIONS(287),
    [sym_epilogue_directive] = ACTIONS(287),
    [aux_sym_label_token1] = ACTIONS(287),
    [aux_sym_jmp_label_token1] = ACTIONS(287),
    [sym_comment] = ACTIONS(3),
  },
  [31] = {
    [ts_builtin_sym_end] = ACTIONS(291),
    [anon_sym_DOTsource] = ACTIONS(291),
    [anon_sym_DOTfield] = ACTIONS(291),
    [anon_sym_DOTendfield] = ACTIONS(291),
    [anon_sym_DOTmethod] = ACTIONS(291),
    [anon_sym_DOTendmethod] = ACTIONS(291),
    [anon_sym_DOTannotation] = ACTIONS(291),
    [anon_sym_DOTparam] = ACTIONS(293),
    [anon_sym_COMMA] = ACTIONS(291),
    [anon_sym_DOTparameter] = ACTIONS(291),
    [anon_sym_DOTendparameter] = ACTIONS(291),
    [anon_sym_nop] = ACTIONS(293),
    [anon_sym_move] = ACTIONS(293),
    [anon_sym_move_SLASHfrom16] = ACTIONS(291),
    [anon_sym_move_SLASH16] = ACTIONS(291),
    [anon_sym_move_DASHwide] = ACTIONS(293),
    [anon_sym_move_DASHwide_SLASHfrom16] = ACTIONS(291),
    [anon_sym_move_DASHwide_SLASH16] = ACTIONS(291),
    [anon_sym_move_DASHobject] = ACTIONS(293),
    [anon_sym_move_DASHobject_SLASHfrom16] = ACTIONS(291),
    [anon_sym_move_DASHobject_SLASH16] = ACTIONS(291),
    [anon_sym_move_DASHresult] = ACTIONS(293),
    [anon_sym_move_DASHresult_DASHwide] = ACTIONS(291),
    [anon_sym_move_DASHresult_DASHobject] = ACTIONS(291),
    [anon_sym_move_DASHexception] = ACTIONS(291),
    [anon_sym_return_DASHvoid] = ACTIONS(291),
    [anon_sym_return] = ACTIONS(293),
    [anon_sym_return_DASHwide] = ACTIONS(291),
    [anon_sym_return_DASHobject] = ACTIONS(291),
    [anon_sym_const_SLASH4] = ACTIONS(291),
    [anon_sym_const_SLASH16] = ACTIONS(291),
    [anon_sym_const] = ACTIONS(293),
    [anon_sym_const_SLASHhigh16] = ACTIONS(291),
    [anon_sym_const_DASHwide_SLASH16] = ACTIONS(291),
    [anon_sym_const_DASHwide_SLASH32] = ACTIONS(291),
    [anon_sym_const_DASHwide] = ACTIONS(293),
    [anon_sym_const_DASHwide_SLASHhigh16] = ACTIONS(291),
    [anon_sym_const_DASHstring] = ACTIONS(293),
    [anon_sym_const_DASHstring_SLASHjumbo] = ACTIONS(291),
    [anon_sym_const_DASHclass] = ACTIONS(291),
    [anon_sym_const_DASHmethod_DASHhandle] = ACTIONS(291),
    [anon_sym_const_DASHmethod_DASHtype] = ACTIONS(291),
    [anon_sym_monitor_DASHenter] = ACTIONS(291),
    [anon_sym_monitor_DASHexit] = ACTIONS(291),
    [anon_sym_check_DASHcast] = ACTIONS(291),
    [anon_sym_instance_DASHof] = ACTIONS(291),
    [anon_sym_array_DASHlength] = ACTIONS(291),
    [anon_sym_new_DASHinstance] = ACTIONS(291),
    [anon_sym_new_DASHarray] = ACTIONS(291),
    [anon_sym_filled_DASHnew_DASHarray] = ACTIONS(293),
    [anon_sym_filled_DASHnew_DASHarray_SLASHrange] = ACTIONS(291),
    [anon_sym_fill_DASHarray_DASHdata] = ACTIONS(291),
    [anon_sym_throw] = ACTIONS(293),
    [anon_sym_throw_DASHverification_DASHerror] = ACTIONS(291),
    [anon_sym_goto] = ACTIONS(293),
    [anon_sym_goto_SLASH16] = ACTIONS(291),
    [anon_sym_goto_SLASH32] = ACTIONS(291),
    [anon_sym_packed_DASHswitch] = ACTIONS(291),
    [anon_sym_sparse_DASHswitch] = ACTIONS(291),
    [anon_sym_cmpl_DASHfloat] = ACTIONS(291),
    [anon_sym_cmpg_DASHfloat] = ACTIONS(291),
    [anon_sym_cmpl_DASHdouble] = ACTIONS(291),
    [anon_sym_cmpg_DASHdouble] = ACTIONS(291),
    [anon_sym_cmp_DASHlong] = ACTIONS(291),
    [anon_sym_if_DASHeq] = ACTIONS(293),
    [anon_sym_if_DASHne] = ACTIONS(293),
    [anon_sym_if_DASHlt] = ACTIONS(293),
    [anon_sym_if_DASHge] = ACTIONS(293),
    [anon_sym_if_DASHgt] = ACTIONS(293),
    [anon_sym_if_DASHle] = ACTIONS(293),
    [anon_sym_if_DASHeqz] = ACTIONS(291),
    [anon_sym_if_DASHnez] = ACTIONS(291),
    [anon_sym_if_DASHltz] = ACTIONS(291),
    [anon_sym_if_DASHgez] = ACTIONS(291),
    [anon_sym_if_DASHgtz] = ACTIONS(291),
    [anon_sym_if_DASHlez] = ACTIONS(291),
    [anon_sym_aget] = ACTIONS(293),
    [anon_sym_aget_DASHwide] = ACTIONS(291),
    [anon_sym_aget_DASHobject] = ACTIONS(291),
    [anon_sym_aget_DASHboolean] = ACTIONS(291),
    [anon_sym_aget_DASHbyte] = ACTIONS(291),
    [anon_sym_aget_DASHchar] = ACTIONS(291),
    [anon_sym_aget_DASHshort] = ACTIONS(291),
    [anon_sym_aput] = ACTIONS(293),
    [anon_sym_aput_DASHwide] = ACTIONS(291),
    [anon_sym_aput_DASHobject] = ACTIONS(291),
    [anon_sym_aput_DASHboolean] = ACTIONS(291),
    [anon_sym_aput_DASHbyte] = ACTIONS(291),
    [anon_sym_aput_DASHchar] = ACTIONS(291),
    [anon_sym_aput_DASHshort] = ACTIONS(291),
    [anon_sym_iget] = ACTIONS(293),
    [anon_sym_iget_DASHwide] = ACTIONS(293),
    [anon_sym_iget_DASHobject] = ACTIONS(293),
    [anon_sym_iget_DASHboolean] = ACTIONS(291),
    [anon_sym_iget_DASHbyte] = ACTIONS(291),
    [anon_sym_iget_DASHchar] = ACTIONS(291),
    [anon_sym_iget_DASHshort] = ACTIONS(291),
    [anon_sym_iget_DASHvolatile] = ACTIONS(291),
    [anon_sym_iget_DASHwide_DASHvolatile] = ACTIONS(291),
    [anon_sym_iget_DASHobject_DASHvolatile] = ACTIONS(291),
    [anon_sym_iput] = ACTIONS(293),
    [anon_sym_iput_DASHwide] = ACTIONS(293),
    [anon_sym_iput_DASHobject] = ACTIONS(293),
    [anon_sym_iput_DASHboolean] = ACTIONS(293),
    [anon_sym_iput_DASHbyte] = ACTIONS(293),
    [anon_sym_iput_DASHchar] = ACTIONS(293),
    [anon_sym_iput_DASHshort] = ACTIONS(293),
    [anon_sym_iput_DASHvolatile] = ACTIONS(291),
    [anon_sym_iput_DASHwide_DASHvolatile] = ACTIONS(291),
    [anon_sym_iput_DASHobject_DASHvolatile] = ACTIONS(291),
    [anon_sym_sget] = ACTIONS(293),
    [anon_sym_sget_DASHwide] = ACTIONS(293),
    [anon_sym_sget_DASHobject] = ACTIONS(293),
    [anon_sym_sget_DASHboolean] = ACTIONS(291),
    [anon_sym_sget_DASHbyte] = ACTIONS(291),
    [anon_sym_sget_DASHchar] = ACTIONS(291),
    [anon_sym_sget_DASHshort] = ACTIONS(291),
    [anon_sym_sget_DASHvolatile] = ACTIONS(291),
    [anon_sym_sget_DASHwide_DASHvolatile] = ACTIONS(291),
    [anon_sym_sget_DASHobject_DASHvolatile] = ACTIONS(291),
    [anon_sym_sput] = ACTIONS(293),
    [anon_sym_sput_DASHwide] = ACTIONS(293),
    [anon_sym_sput_DASHobject] = ACTIONS(293),
    [anon_sym_sput_DASHboolean] = ACTIONS(291),
    [anon_sym_sput_DASHbyte] = ACTIONS(291),
    [anon_sym_sput_DASHchar] = ACTIONS(291),
    [anon_sym_sput_DASHshort] = ACTIONS(291),
    [anon_sym_sput_DASHvolatile] = ACTIONS(291),
    [anon_sym_sput_DASHwide_DASHvolatile] = ACTIONS(291),
    [anon_sym_sput_DASHobject_DASHvolatile] = ACTIONS(291),
    [anon_sym_invoke_DASHconstructor] = ACTIONS(291),
    [anon_sym_invoke_DASHcustom] = ACTIONS(293),
    [anon_sym_invoke_DASHdirect] = ACTIONS(293),
    [anon_sym_invoke_DASHdirect_DASHempty] = ACTIONS(291),
    [anon_sym_invoke_DASHinstance] = ACTIONS(291),
    [anon_sym_invoke_DASHinterface] = ACTIONS(293),
    [anon_sym_invoke_DASHpolymorphic] = ACTIONS(293),
    [anon_sym_invoke_DASHstatic] = ACTIONS(293),
    [anon_sym_invoke_DASHsuper] = ACTIONS(293),
    [anon_sym_invoke_DASHvirtual] = ACTIONS(293),
    [anon_sym_invoke_DASHcustom_SLASHrange] = ACTIONS(291),
    [anon_sym_invoke_DASHdirect_SLASHrange] = ACTIONS(291),
    [anon_sym_invoke_DASHinterface_SLASHrange] = ACTIONS(291),
    [anon_sym_invoke_DASHobject_DASHinit_SLASHrange] = ACTIONS(291),
    [anon_sym_invoke_DASHpolymorphic_SLASHrange] = ACTIONS(291),
    [anon_sym_invoke_DASHstatic_SLASHrange] = ACTIONS(291),
    [anon_sym_invoke_DASHsuper_SLASHrange] = ACTIONS(291),
    [anon_sym_invoke_DASHvirtual_SLASHrange] = ACTIONS(291),
    [anon_sym_neg_DASHint] = ACTIONS(291),
    [anon_sym_not_DASHint] = ACTIONS(291),
    [anon_sym_neg_DASHlong] = ACTIONS(291),
    [anon_sym_not_DASHlong] = ACTIONS(291),
    [anon_sym_neg_DASHfloat] = ACTIONS(291),
    [anon_sym_neg_DASHdouble] = ACTIONS(291),
    [anon_sym_int_DASHto_DASHlong] = ACTIONS(291),
    [anon_sym_int_DASHto_DASHfloat] = ACTIONS(291),
    [anon_sym_int_DASHto_DASHdouble] = ACTIONS(291),
    [anon_sym_long_DASHto_DASHint] = ACTIONS(291),
    [anon_sym_long_DASHto_DASHfloat] = ACTIONS(291),
    [anon_sym_long_DASHto_DASHdouble] = ACTIONS(291),
    [anon_sym_float_DASHto_DASHint] = ACTIONS(291),
    [anon_sym_float_DASHto_DASHlong] = ACTIONS(291),
    [anon_sym_float_DASHto_DASHdouble] = ACTIONS(291),
    [anon_sym_double_DASHto_DASHint] = ACTIONS(291),
    [anon_sym_double_DASHto_DASHlong] = ACTIONS(291),
    [anon_sym_double_DASHto_DASHfloat] = ACTIONS(291),
    [anon_sym_int_DASHto_DASHbyte] = ACTIONS(291),
    [anon_sym_int_DASHto_DASHchar] = ACTIONS(291),
    [anon_sym_int_DASHto_DASHshort] = ACTIONS(291),
    [anon_sym_add_DASHint] = ACTIONS(293),
    [anon_sym_sub_DASHint] = ACTIONS(293),
    [anon_sym_mul_DASHint] = ACTIONS(293),
    [anon_sym_div_DASHint] = ACTIONS(293),
    [anon_sym_rem_DASHint] = ACTIONS(293),
    [anon_sym_and_DASHint] = ACTIONS(293),
    [anon_sym_or_DASHint] = ACTIONS(293),
    [anon_sym_xor_DASHint] = ACTIONS(293),
    [anon_sym_shl_DASHint] = ACTIONS(293),
    [anon_sym_shr_DASHint] = ACTIONS(293),
    [anon_sym_ushr_DASHint] = ACTIONS(293),
    [anon_sym_add_DASHlong] = ACTIONS(293),
    [anon_sym_sub_DASHlong] = ACTIONS(293),
    [anon_sym_mul_DASHlong] = ACTIONS(293),
    [anon_sym_div_DASHlong] = ACTIONS(293),
    [anon_sym_rem_DASHlong] = ACTIONS(293),
    [anon_sym_and_DASHlong] = ACTIONS(293),
    [anon_sym_or_DASHlong] = ACTIONS(293),
    [anon_sym_xor_DASHlong] = ACTIONS(293),
    [anon_sym_shl_DASHlong] = ACTIONS(293),
    [anon_sym_shr_DASHlong] = ACTIONS(293),
    [anon_sym_ushr_DASHlong] = ACTIONS(293),
    [anon_sym_add_DASHfloat] = ACTIONS(293),
    [anon_sym_sub_DASHfloat] = ACTIONS(293),
    [anon_sym_mul_DASHfloat] = ACTIONS(293),
    [anon_sym_div_DASHfloat] = ACTIONS(293),
    [anon_sym_rem_DASHfloat] = ACTIONS(293),
    [anon_sym_add_DASHdouble] = ACTIONS(293),
    [anon_sym_sub_DASHdouble] = ACTIONS(293),
    [anon_sym_mul_DASHdouble] = ACTIONS(293),
    [anon_sym_div_DASHdouble] = ACTIONS(293),
    [anon_sym_rem_DASHdouble] = ACTIONS(293),
    [anon_sym_add_DASHint_SLASH2addr] = ACTIONS(291),
    [anon_sym_sub_DASHint_SLASH2addr] = ACTIONS(291),
    [anon_sym_mul_DASHint_SLASH2addr] = ACTIONS(291),
    [anon_sym_div_DASHint_SLASH2addr] = ACTIONS(291),
    [anon_sym_rem_DASHint_SLASH2addr] = ACTIONS(291),
    [anon_sym_and_DASHint_SLASH2addr] = ACTIONS(291),
    [anon_sym_or_DASHint_SLASH2addr] = ACTIONS(291),
    [anon_sym_xor_DASHint_SLASH2addr] = ACTIONS(291),
    [anon_sym_shl_DASHint_SLASH2addr] = ACTIONS(291),
    [anon_sym_shr_DASHint_SLASH2addr] = ACTIONS(291),
    [anon_sym_ushr_DASHint_SLASH2addr] = ACTIONS(291),
    [anon_sym_add_DASHlong_SLASH2addr] = ACTIONS(291),
    [anon_sym_sub_DASHlong_SLASH2addr] = ACTIONS(291),
    [anon_sym_mul_DASHlong_SLASH2addr] = ACTIONS(291),
    [anon_sym_div_DASHlong_SLASH2addr] = ACTIONS(291),
    [anon_sym_rem_DASHlong_SLASH2addr] = ACTIONS(291),
    [anon_sym_and_DASHlong_SLASH2addr] = ACTIONS(291),
    [anon_sym_or_DASHlong_SLASH2addr] = ACTIONS(291),
    [anon_sym_xor_DASHlong_SLASH2addr] = ACTIONS(291),
    [anon_sym_shl_DASHlong_SLASH2addr] = ACTIONS(291),
    [anon_sym_shr_DASHlong_SLASH2addr] = ACTIONS(291),
    [anon_sym_ushr_DASHlong_SLASH2addr] = ACTIONS(291),
    [anon_sym_add_DASHfloat_SLASH2addr] = ACTIONS(291),
    [anon_sym_sub_DASHfloat_SLASH2addr] = ACTIONS(291),
    [anon_sym_mul_DASHfloat_SLASH2addr] = ACTIONS(291),
    [anon_sym_div_DASHfloat_SLASH2addr] = ACTIONS(291),
    [anon_sym_rem_DASHfloat_SLASH2addr] = ACTIONS(291),
    [anon_sym_add_DASHdouble_SLASH2addr] = ACTIONS(291),
    [anon_sym_sub_DASHdouble_SLASH2addr] = ACTIONS(291),
    [anon_sym_mul_DASHdouble_SLASH2addr] = ACTIONS(291),
    [anon_sym_div_DASHdouble_SLASH2addr] = ACTIONS(291),
    [anon_sym_rem_DASHdouble_SLASH2addr] = ACTIONS(291),
    [anon_sym_add_DASHint_SLASHlit16] = ACTIONS(291),
    [anon_sym_sub_DASHint_SLASHlit16] = ACTIONS(291),
    [anon_sym_mul_DASHint_SLASHlit16] = ACTIONS(291),
    [anon_sym_div_DASHint_SLASHlit16] = ACTIONS(291),
    [anon_sym_rem_DASHint_SLASHlit16] = ACTIONS(291),
    [anon_sym_and_DASHint_SLASHlit16] = ACTIONS(291),
    [anon_sym_or_DASHint_SLASHlit16] = ACTIONS(291),
    [anon_sym_xor_DASHint_SLASHlit16] = ACTIONS(291),
    [anon_sym_add_DASHint_SLASHlit8] = ACTIONS(291),
    [anon_sym_sub_DASHint_SLASHlit8] = ACTIONS(291),
    [anon_sym_mul_DASHint_SLASHlit8] = ACTIONS(291),
    [anon_sym_div_DASHint_SLASHlit8] = ACTIONS(291),
    [anon_sym_rem_DASHint_SLASHlit8] = ACTIONS(291),
    [anon_sym_and_DASHint_SLASHlit8] = ACTIONS(291),
    [anon_sym_or_DASHint_SLASHlit8] = ACTIONS(291),
    [anon_sym_xor_DASHint_SLASHlit8] = ACTIONS(291),
    [anon_sym_shl_DASHint_SLASHlit8] = ACTIONS(291),
    [anon_sym_shr_DASHint_SLASHlit8] = ACTIONS(291),
    [anon_sym_ushr_DASHint_SLASHlit8] = ACTIONS(291),
    [anon_sym_static_DASHget] = ACTIONS(291),
    [anon_sym_static_DASHput] = ACTIONS(291),
    [anon_sym_instance_DASHget] = ACTIONS(291),
    [anon_sym_instance_DASHput] = ACTIONS(291),
    [anon_sym_execute_DASHinline] = ACTIONS(293),
    [anon_sym_execute_DASHinline_SLASHrange] = ACTIONS(291),
    [anon_sym_iget_DASHquick] = ACTIONS(291),
    [anon_sym_iget_DASHwide_DASHquick] = ACTIONS(291),
    [anon_sym_iget_DASHobject_DASHquick] = ACTIONS(291),
    [anon_sym_iput_DASHquick] = ACTIONS(291),
    [anon_sym_iput_DASHwide_DASHquick] = ACTIONS(291),
    [anon_sym_iput_DASHobject_DASHquick] = ACTIONS(291),
    [anon_sym_iput_DASHboolean_DASHquick] = ACTIONS(291),
    [anon_sym_iput_DASHbyte_DASHquick] = ACTIONS(291),
    [anon_sym_iput_DASHchar_DASHquick] = ACTIONS(291),
    [anon_sym_iput_DASHshort_DASHquick] = ACTIONS(291),
    [anon_sym_invoke_DASHvirtual_DASHquick] = ACTIONS(293),
    [anon_sym_invoke_DASHvirtual_DASHquick_SLASHrange] = ACTIONS(291),
    [anon_sym_invoke_DASHsuper_DASHquick] = ACTIONS(293),
    [anon_sym_invoke_DASHsuper_DASHquick_SLASHrange] = ACTIONS(291),
    [anon_sym_rsub_DASHint] = ACTIONS(293),
    [anon_sym_rsub_DASHint_SLASHlit8] = ACTIONS(291),
    [anon_sym_DOTline] = ACTIONS(291),
    [anon_sym_DOTlocals] = ACTIONS(291),
    [anon_sym_DOTlocal] = ACTIONS(293),
    [anon_sym_DOTendlocal] = ACTIONS(291),
    [anon_sym_DOTrestartlocal] = ACTIONS(291),
    [anon_sym_DOTregisters] = ACTIONS(291),
    [anon_sym_DOTcatch] = ACTIONS(293),
    [anon_sym_RBRACE] = ACTIONS(291),
    [anon_sym_DOTcatchall] = ACTIONS(291),
    [anon_sym_DOTpacked_DASHswitch] = ACTIONS(291),
    [anon_sym_DOTsparse_DASHswitch] = ACTIONS(291),
    [anon_sym_DOTarray_DASHdata] = ACTIONS(291),
    [sym_prologue_directive] = ACTIONS(291),
    [sym_epilogue_directive] = ACTIONS(291),
    [aux_sym_label_token1] = ACTIONS(291),
    [aux_sym_jmp_label_token1] = ACTIONS(291),
    [sym_comment] = ACTIONS(3),
  },
  [32] = {
    [ts_builtin_sym_end] = ACTIONS(295),
    [anon_sym_DOTsource] = ACTIONS(295),
    [anon_sym_DOTfield] = ACTIONS(295),
    [anon_sym_DOTendfield] = ACTIONS(295),
    [anon_sym_DOTmethod] = ACTIONS(295),
    [anon_sym_DOTendmethod] = ACTIONS(295),
    [anon_sym_DOTannotation] = ACTIONS(295),
    [anon_sym_DOTparam] = ACTIONS(297),
    [anon_sym_COMMA] = ACTIONS(295),
    [anon_sym_DOTparameter] = ACTIONS(295),
    [anon_sym_nop] = ACTIONS(297),
    [anon_sym_move] = ACTIONS(297),
    [anon_sym_move_SLASHfrom16] = ACTIONS(295),
    [anon_sym_move_SLASH16] = ACTIONS(295),
    [anon_sym_move_DASHwide] = ACTIONS(297),
    [anon_sym_move_DASHwide_SLASHfrom16] = ACTIONS(295),
    [anon_sym_move_DASHwide_SLASH16] = ACTIONS(295),
    [anon_sym_move_DASHobject] = ACTIONS(297),
    [anon_sym_move_DASHobject_SLASHfrom16] = ACTIONS(295),
    [anon_sym_move_DASHobject_SLASH16] = ACTIONS(295),
    [anon_sym_move_DASHresult] = ACTIONS(297),
    [anon_sym_move_DASHresult_DASHwide] = ACTIONS(295),
    [anon_sym_move_DASHresult_DASHobject] = ACTIONS(295),
    [anon_sym_move_DASHexception] = ACTIONS(295),
    [anon_sym_return_DASHvoid] = ACTIONS(295),
    [anon_sym_return] = ACTIONS(297),
    [anon_sym_return_DASHwide] = ACTIONS(295),
    [anon_sym_return_DASHobject] = ACTIONS(295),
    [anon_sym_const_SLASH4] = ACTIONS(295),
    [anon_sym_const_SLASH16] = ACTIONS(295),
    [anon_sym_const] = ACTIONS(297),
    [anon_sym_const_SLASHhigh16] = ACTIONS(295),
    [anon_sym_const_DASHwide_SLASH16] = ACTIONS(295),
    [anon_sym_const_DASHwide_SLASH32] = ACTIONS(295),
    [anon_sym_const_DASHwide] = ACTIONS(297),
    [anon_sym_const_DASHwide_SLASHhigh16] = ACTIONS(295),
    [anon_sym_const_DASHstring] = ACTIONS(297),
    [anon_sym_const_DASHstring_SLASHjumbo] = ACTIONS(295),
    [anon_sym_const_DASHclass] = ACTIONS(295),
    [anon_sym_const_DASHmethod_DASHhandle] = ACTIONS(295),
    [anon_sym_const_DASHmethod_DASHtype] = ACTIONS(295),
    [anon_sym_monitor_DASHenter] = ACTIONS(295),
    [anon_sym_monitor_DASHexit] = ACTIONS(295),
    [anon_sym_check_DASHcast] = ACTIONS(295),
    [anon_sym_instance_DASHof] = ACTIONS(295),
    [anon_sym_array_DASHlength] = ACTIONS(295),
    [anon_sym_new_DASHinstance] = ACTIONS(295),
    [anon_sym_new_DASHarray] = ACTIONS(295),
    [anon_sym_filled_DASHnew_DASHarray] = ACTIONS(297),
    [anon_sym_filled_DASHnew_DASHarray_SLASHrange] = ACTIONS(295),
    [anon_sym_fill_DASHarray_DASHdata] = ACTIONS(295),
    [anon_sym_throw] = ACTIONS(297),
    [anon_sym_throw_DASHverification_DASHerror] = ACTIONS(295),
    [anon_sym_goto] = ACTIONS(297),
    [anon_sym_goto_SLASH16] = ACTIONS(295),
    [anon_sym_goto_SLASH32] = ACTIONS(295),
    [anon_sym_packed_DASHswitch] = ACTIONS(295),
    [anon_sym_sparse_DASHswitch] = ACTIONS(295),
    [anon_sym_cmpl_DASHfloat] = ACTIONS(295),
    [anon_sym_cmpg_DASHfloat] = ACTIONS(295),
    [anon_sym_cmpl_DASHdouble] = ACTIONS(295),
    [anon_sym_cmpg_DASHdouble] = ACTIONS(295),
    [anon_sym_cmp_DASHlong] = ACTIONS(295),
    [anon_sym_if_DASHeq] = ACTIONS(297),
    [anon_sym_if_DASHne] = ACTIONS(297),
    [anon_sym_if_DASHlt] = ACTIONS(297),
    [anon_sym_if_DASHge] = ACTIONS(297),
    [anon_sym_if_DASHgt] = ACTIONS(297),
    [anon_sym_if_DASHle] = ACTIONS(297),
    [anon_sym_if_DASHeqz] = ACTIONS(295),
    [anon_sym_if_DASHnez] = ACTIONS(295),
    [anon_sym_if_DASHltz] = ACTIONS(295),
    [anon_sym_if_DASHgez] = ACTIONS(295),
    [anon_sym_if_DASHgtz] = ACTIONS(295),
    [anon_sym_if_DASHlez] = ACTIONS(295),
    [anon_sym_aget] = ACTIONS(297),
    [anon_sym_aget_DASHwide] = ACTIONS(295),
    [anon_sym_aget_DASHobject] = ACTIONS(295),
    [anon_sym_aget_DASHboolean] = ACTIONS(295),
    [anon_sym_aget_DASHbyte] = ACTIONS(295),
    [anon_sym_aget_DASHchar] = ACTIONS(295),
    [anon_sym_aget_DASHshort] = ACTIONS(295),
    [anon_sym_aput] = ACTIONS(297),
    [anon_sym_aput_DASHwide] = ACTIONS(295),
    [anon_sym_aput_DASHobject] = ACTIONS(295),
    [anon_sym_aput_DASHboolean] = ACTIONS(295),
    [anon_sym_aput_DASHbyte] = ACTIONS(295),
    [anon_sym_aput_DASHchar] = ACTIONS(295),
    [anon_sym_aput_DASHshort] = ACTIONS(295),
    [anon_sym_iget] = ACTIONS(297),
    [anon_sym_iget_DASHwide] = ACTIONS(297),
    [anon_sym_iget_DASHobject] = ACTIONS(297),
    [anon_sym_iget_DASHboolean] = ACTIONS(295),
    [anon_sym_iget_DASHbyte] = ACTIONS(295),
    [anon_sym_iget_DASHchar] = ACTIONS(295),
    [anon_sym_iget_DASHshort] = ACTIONS(295),
    [anon_sym_iget_DASHvolatile] = ACTIONS(295),
    [anon_sym_iget_DASHwide_DASHvolatile] = ACTIONS(295),
    [anon_sym_iget_DASHobject_DASHvolatile] = ACTIONS(295),
    [anon_sym_iput] = ACTIONS(297),
    [anon_sym_iput_DASHwide] = ACTIONS(297),
    [anon_sym_iput_DASHobject] = ACTIONS(297),
    [anon_sym_iput_DASHboolean] = ACTIONS(297),
    [anon_sym_iput_DASHbyte] = ACTIONS(297),
    [anon_sym_iput_DASHchar] = ACTIONS(297),
    [anon_sym_iput_DASHshort] = ACTIONS(297),
    [anon_sym_iput_DASHvolatile] = ACTIONS(295),
    [anon_sym_iput_DASHwide_DASHvolatile] = ACTIONS(295),
    [anon_sym_iput_DASHobject_DASHvolatile] = ACTIONS(295),
    [anon_sym_sget] = ACTIONS(297),
    [anon_sym_sget_DASHwide] = ACTIONS(297),
    [anon_sym_sget_DASHobject] = ACTIONS(297),
    [anon_sym_sget_DASHboolean] = ACTIONS(295),
    [anon_sym_sget_DASHbyte] = ACTIONS(295),
    [anon_sym_sget_DASHchar] = ACTIONS(295),
    [anon_sym_sget_DASHshort] = ACTIONS(295),
    [anon_sym_sget_DASHvolatile] = ACTIONS(295),
    [anon_sym_sget_DASHwide_DASHvolatile] = ACTIONS(295),
    [anon_sym_sget_DASHobject_DASHvolatile] = ACTIONS(295),
    [anon_sym_sput] = ACTIONS(297),
    [anon_sym_sput_DASHwide] = ACTIONS(297),
    [anon_sym_sput_DASHobject] = ACTIONS(297),
    [anon_sym_sput_DASHboolean] = ACTIONS(295),
    [anon_sym_sput_DASHbyte] = ACTIONS(295),
    [anon_sym_sput_DASHchar] = ACTIONS(295),
    [anon_sym_sput_DASHshort] = ACTIONS(295),
    [anon_sym_sput_DASHvolatile] = ACTIONS(295),
    [anon_sym_sput_DASHwide_DASHvolatile] = ACTIONS(295),
    [anon_sym_sput_DASHobject_DASHvolatile] = ACTIONS(295),
    [anon_sym_invoke_DASHconstructor] = ACTIONS(295),
    [anon_sym_invoke_DASHcustom] = ACTIONS(297),
    [anon_sym_invoke_DASHdirect] = ACTIONS(297),
    [anon_sym_invoke_DASHdirect_DASHempty] = ACTIONS(295),
    [anon_sym_invoke_DASHinstance] = ACTIONS(295),
    [anon_sym_invoke_DASHinterface] = ACTIONS(297),
    [anon_sym_invoke_DASHpolymorphic] = ACTIONS(297),
    [anon_sym_invoke_DASHstatic] = ACTIONS(297),
    [anon_sym_invoke_DASHsuper] = ACTIONS(297),
    [anon_sym_invoke_DASHvirtual] = ACTIONS(297),
    [anon_sym_invoke_DASHcustom_SLASHrange] = ACTIONS(295),
    [anon_sym_invoke_DASHdirect_SLASHrange] = ACTIONS(295),
    [anon_sym_invoke_DASHinterface_SLASHrange] = ACTIONS(295),
    [anon_sym_invoke_DASHobject_DASHinit_SLASHrange] = ACTIONS(295),
    [anon_sym_invoke_DASHpolymorphic_SLASHrange] = ACTIONS(295),
    [anon_sym_invoke_DASHstatic_SLASHrange] = ACTIONS(295),
    [anon_sym_invoke_DASHsuper_SLASHrange] = ACTIONS(295),
    [anon_sym_invoke_DASHvirtual_SLASHrange] = ACTIONS(295),
    [anon_sym_neg_DASHint] = ACTIONS(295),
    [anon_sym_not_DASHint] = ACTIONS(295),
    [anon_sym_neg_DASHlong] = ACTIONS(295),
    [anon_sym_not_DASHlong] = ACTIONS(295),
    [anon_sym_neg_DASHfloat] = ACTIONS(295),
    [anon_sym_neg_DASHdouble] = ACTIONS(295),
    [anon_sym_int_DASHto_DASHlong] = ACTIONS(295),
    [anon_sym_int_DASHto_DASHfloat] = ACTIONS(295),
    [anon_sym_int_DASHto_DASHdouble] = ACTIONS(295),
    [anon_sym_long_DASHto_DASHint] = ACTIONS(295),
    [anon_sym_long_DASHto_DASHfloat] = ACTIONS(295),
    [anon_sym_long_DASHto_DASHdouble] = ACTIONS(295),
    [anon_sym_float_DASHto_DASHint] = ACTIONS(295),
    [anon_sym_float_DASHto_DASHlong] = ACTIONS(295),
    [anon_sym_float_DASHto_DASHdouble] = ACTIONS(295),
    [anon_sym_double_DASHto_DASHint] = ACTIONS(295),
    [anon_sym_double_DASHto_DASHlong] = ACTIONS(295),
    [anon_sym_double_DASHto_DASHfloat] = ACTIONS(295),
    [anon_sym_int_DASHto_DASHbyte] = ACTIONS(295),
    [anon_sym_int_DASHto_DASHchar] = ACTIONS(295),
    [anon_sym_int_DASHto_DASHshort] = ACTIONS(295),
    [anon_sym_add_DASHint] = ACTIONS(297),
    [anon_sym_sub_DASHint] = ACTIONS(297),
    [anon_sym_mul_DASHint] = ACTIONS(297),
    [anon_sym_div_DASHint] = ACTIONS(297),
    [anon_sym_rem_DASHint] = ACTIONS(297),
    [anon_sym_and_DASHint] = ACTIONS(297),
    [anon_sym_or_DASHint] = ACTIONS(297),
    [anon_sym_xor_DASHint] = ACTIONS(297),
    [anon_sym_shl_DASHint] = ACTIONS(297),
    [anon_sym_shr_DASHint] = ACTIONS(297),
    [anon_sym_ushr_DASHint] = ACTIONS(297),
    [anon_sym_add_DASHlong] = ACTIONS(297),
    [anon_sym_sub_DASHlong] = ACTIONS(297),
    [anon_sym_mul_DASHlong] = ACTIONS(297),
    [anon_sym_div_DASHlong] = ACTIONS(297),
    [anon_sym_rem_DASHlong] = ACTIONS(297),
    [anon_sym_and_DASHlong] = ACTIONS(297),
    [anon_sym_or_DASHlong] = ACTIONS(297),
    [anon_sym_xor_DASHlong] = ACTIONS(297),
    [anon_sym_shl_DASHlong] = ACTIONS(297),
    [anon_sym_shr_DASHlong] = ACTIONS(297),
    [anon_sym_ushr_DASHlong] = ACTIONS(297),
    [anon_sym_add_DASHfloat] = ACTIONS(297),
    [anon_sym_sub_DASHfloat] = ACTIONS(297),
    [anon_sym_mul_DASHfloat] = ACTIONS(297),
    [anon_sym_div_DASHfloat] = ACTIONS(297),
    [anon_sym_rem_DASHfloat] = ACTIONS(297),
    [anon_sym_add_DASHdouble] = ACTIONS(297),
    [anon_sym_sub_DASHdouble] = ACTIONS(297),
    [anon_sym_mul_DASHdouble] = ACTIONS(297),
    [anon_sym_div_DASHdouble] = ACTIONS(297),
    [anon_sym_rem_DASHdouble] = ACTIONS(297),
    [anon_sym_add_DASHint_SLASH2addr] = ACTIONS(295),
    [anon_sym_sub_DASHint_SLASH2addr] = ACTIONS(295),
    [anon_sym_mul_DASHint_SLASH2addr] = ACTIONS(295),
    [anon_sym_div_DASHint_SLASH2addr] = ACTIONS(295),
    [anon_sym_rem_DASHint_SLASH2addr] = ACTIONS(295),
    [anon_sym_and_DASHint_SLASH2addr] = ACTIONS(295),
    [anon_sym_or_DASHint_SLASH2addr] = ACTIONS(295),
    [anon_sym_xor_DASHint_SLASH2addr] = ACTIONS(295),
    [anon_sym_shl_DASHint_SLASH2addr] = ACTIONS(295),
    [anon_sym_shr_DASHint_SLASH2addr] = ACTIONS(295),
    [anon_sym_ushr_DASHint_SLASH2addr] = ACTIONS(295),
    [anon_sym_add_DASHlong_SLASH2addr] = ACTIONS(295),
    [anon_sym_sub_DASHlong_SLASH2addr] = ACTIONS(295),
    [anon_sym_mul_DASHlong_SLASH2addr] = ACTIONS(295),
    [anon_sym_div_DASHlong_SLASH2addr] = ACTIONS(295),
    [anon_sym_rem_DASHlong_SLASH2addr] = ACTIONS(295),
    [anon_sym_and_DASHlong_SLASH2addr] = ACTIONS(295),
    [anon_sym_or_DASHlong_SLASH2addr] = ACTIONS(295),
    [anon_sym_xor_DASHlong_SLASH2addr] = ACTIONS(295),
    [anon_sym_shl_DASHlong_SLASH2addr] = ACTIONS(295),
    [anon_sym_shr_DASHlong_SLASH2addr] = ACTIONS(295),
    [anon_sym_ushr_DASHlong_SLASH2addr] = ACTIONS(295),
    [anon_sym_add_DASHfloat_SLASH2addr] = ACTIONS(295),
    [anon_sym_sub_DASHfloat_SLASH2addr] = ACTIONS(295),
    [anon_sym_mul_DASHfloat_SLASH2addr] = ACTIONS(295),
    [anon_sym_div_DASHfloat_SLASH2addr] = ACTIONS(295),
    [anon_sym_rem_DASHfloat_SLASH2addr] = ACTIONS(295),
    [anon_sym_add_DASHdouble_SLASH2addr] = ACTIONS(295),
    [anon_sym_sub_DASHdouble_SLASH2addr] = ACTIONS(295),
    [anon_sym_mul_DASHdouble_SLASH2addr] = ACTIONS(295),
    [anon_sym_div_DASHdouble_SLASH2addr] = ACTIONS(295),
    [anon_sym_rem_DASHdouble_SLASH2addr] = ACTIONS(295),
    [anon_sym_add_DASHint_SLASHlit16] = ACTIONS(295),
    [anon_sym_sub_DASHint_SLASHlit16] = ACTIONS(295),
    [anon_sym_mul_DASHint_SLASHlit16] = ACTIONS(295),
    [anon_sym_div_DASHint_SLASHlit16] = ACTIONS(295),
    [anon_sym_rem_DASHint_SLASHlit16] = ACTIONS(295),
    [anon_sym_and_DASHint_SLASHlit16] = ACTIONS(295),
    [anon_sym_or_DASHint_SLASHlit16] = ACTIONS(295),
    [anon_sym_xor_DASHint_SLASHlit16] = ACTIONS(295),
    [anon_sym_add_DASHint_SLASHlit8] = ACTIONS(295),
    [anon_sym_sub_DASHint_SLASHlit8] = ACTIONS(295),
    [anon_sym_mul_DASHint_SLASHlit8] = ACTIONS(295),
    [anon_sym_div_DASHint_SLASHlit8] = ACTIONS(295),
    [anon_sym_rem_DASHint_SLASHlit8] = ACTIONS(295),
    [anon_sym_and_DASHint_SLASHlit8] = ACTIONS(295),
    [anon_sym_or_DASHint_SLASHlit8] = ACTIONS(295),
    [anon_sym_xor_DASHint_SLASHlit8] = ACTIONS(295),
    [anon_sym_shl_DASHint_SLASHlit8] = ACTIONS(295),
    [anon_sym_shr_DASHint_SLASHlit8] = ACTIONS(295),
    [anon_sym_ushr_DASHint_SLASHlit8] = ACTIONS(295),
    [anon_sym_static_DASHget] = ACTIONS(295),
    [anon_sym_static_DASHput] = ACTIONS(295),
    [anon_sym_instance_DASHget] = ACTIONS(295),
    [anon_sym_instance_DASHput] = ACTIONS(295),
    [anon_sym_execute_DASHinline] = ACTIONS(297),
    [anon_sym_execute_DASHinline_SLASHrange] = ACTIONS(295),
    [anon_sym_iget_DASHquick] = ACTIONS(295),
    [anon_sym_iget_DASHwide_DASHquick] = ACTIONS(295),
    [anon_sym_iget_DASHobject_DASHquick] = ACTIONS(295),
    [anon_sym_iput_DASHquick] = ACTIONS(295),
    [anon_sym_iput_DASHwide_DASHquick] = ACTIONS(295),
    [anon_sym_iput_DASHobject_DASHquick] = ACTIONS(295),
    [anon_sym_iput_DASHboolean_DASHquick] = ACTIONS(295),
    [anon_sym_iput_DASHbyte_DASHquick] = ACTIONS(295),
    [anon_sym_iput_DASHchar_DASHquick] = ACTIONS(295),
    [anon_sym_iput_DASHshort_DASHquick] = ACTIONS(295),
    [anon_sym_invoke_DASHvirtual_DASHquick] = ACTIONS(297),
    [anon_sym_invoke_DASHvirtual_DASHquick_SLASHrange] = ACTIONS(295),
    [anon_sym_invoke_DASHsuper_DASHquick] = ACTIONS(297),
    [anon_sym_invoke_DASHsuper_DASHquick_SLASHrange] = ACTIONS(295),
    [anon_sym_rsub_DASHint] = ACTIONS(297),
    [anon_sym_rsub_DASHint_SLASHlit8] = ACTIONS(295),
    [anon_sym_DOTline] = ACTIONS(295),
    [anon_sym_DOTlocals] = ACTIONS(295),
    [anon_sym_DOTlocal] = ACTIONS(297),
    [anon_sym_DOTendlocal] = ACTIONS(295),
    [anon_sym_DOTrestartlocal] = ACTIONS(295),
    [anon_sym_DOTregisters] = ACTIONS(295),
    [anon_sym_DOTcatch] = ACTIONS(297),
    [anon_sym_RBRACE] = ACTIONS(295),
    [anon_sym_DOTcatchall] = ACTIONS(295),
    [anon_sym_DOTpacked_DASHswitch] = ACTIONS(295),
    [anon_sym_DOTsparse_DASHswitch] = ACTIONS(295),
    [anon_sym_DOTarray_DASHdata] = ACTIONS(295),
    [sym_prologue_directive] = ACTIONS(295),
    [sym_epilogue_directive] = ACTIONS(295),
    [aux_sym_label_token1] = ACTIONS(295),
    [aux_sym_jmp_label_token1] = ACTIONS(295),
    [anon_sym_RPAREN] = ACTIONS(295),
    [sym_comment] = ACTIONS(3),
  },
  [33] = {
    [ts_builtin_sym_end] = ACTIONS(299),
    [anon_sym_DOTsource] = ACTIONS(299),
    [anon_sym_DOTfield] = ACTIONS(299),
    [anon_sym_DOTendfield] = ACTIONS(299),
    [anon_sym_DOTmethod] = ACTIONS(299),
    [anon_sym_DOTendmethod] = ACTIONS(299),
    [anon_sym_DOTannotation] = ACTIONS(299),
    [anon_sym_DOTparam] = ACTIONS(301),
    [anon_sym_DOTparameter] = ACTIONS(299),
    [anon_sym_DOTendparameter] = ACTIONS(299),
    [anon_sym_nop] = ACTIONS(301),
    [anon_sym_move] = ACTIONS(301),
    [anon_sym_move_SLASHfrom16] = ACTIONS(299),
    [anon_sym_move_SLASH16] = ACTIONS(299),
    [anon_sym_move_DASHwide] = ACTIONS(301),
    [anon_sym_move_DASHwide_SLASHfrom16] = ACTIONS(299),
    [anon_sym_move_DASHwide_SLASH16] = ACTIONS(299),
    [anon_sym_move_DASHobject] = ACTIONS(301),
    [anon_sym_move_DASHobject_SLASHfrom16] = ACTIONS(299),
    [anon_sym_move_DASHobject_SLASH16] = ACTIONS(299),
    [anon_sym_move_DASHresult] = ACTIONS(301),
    [anon_sym_move_DASHresult_DASHwide] = ACTIONS(299),
    [anon_sym_move_DASHresult_DASHobject] = ACTIONS(299),
    [anon_sym_move_DASHexception] = ACTIONS(299),
    [anon_sym_return_DASHvoid] = ACTIONS(299),
    [anon_sym_return] = ACTIONS(301),
    [anon_sym_return_DASHwide] = ACTIONS(299),
    [anon_sym_return_DASHobject] = ACTIONS(299),
    [anon_sym_const_SLASH4] = ACTIONS(299),
    [anon_sym_const_SLASH16] = ACTIONS(299),
    [anon_sym_const] = ACTIONS(301),
    [anon_sym_const_SLASHhigh16] = ACTIONS(299),
    [anon_sym_const_DASHwide_SLASH16] = ACTIONS(299),
    [anon_sym_const_DASHwide_SLASH32] = ACTIONS(299),
    [anon_sym_const_DASHwide] = ACTIONS(301),
    [anon_sym_const_DASHwide_SLASHhigh16] = ACTIONS(299),
    [anon_sym_const_DASHstring] = ACTIONS(301),
    [anon_sym_const_DASHstring_SLASHjumbo] = ACTIONS(299),
    [anon_sym_const_DASHclass] = ACTIONS(299),
    [anon_sym_const_DASHmethod_DASHhandle] = ACTIONS(299),
    [anon_sym_const_DASHmethod_DASHtype] = ACTIONS(299),
    [anon_sym_monitor_DASHenter] = ACTIONS(299),
    [anon_sym_monitor_DASHexit] = ACTIONS(299),
    [anon_sym_check_DASHcast] = ACTIONS(299),
    [anon_sym_instance_DASHof] = ACTIONS(299),
    [anon_sym_array_DASHlength] = ACTIONS(299),
    [anon_sym_new_DASHinstance] = ACTIONS(299),
    [anon_sym_new_DASHarray] = ACTIONS(299),
    [anon_sym_filled_DASHnew_DASHarray] = ACTIONS(301),
    [anon_sym_filled_DASHnew_DASHarray_SLASHrange] = ACTIONS(299),
    [anon_sym_fill_DASHarray_DASHdata] = ACTIONS(299),
    [anon_sym_throw] = ACTIONS(301),
    [anon_sym_throw_DASHverification_DASHerror] = ACTIONS(299),
    [anon_sym_goto] = ACTIONS(301),
    [anon_sym_goto_SLASH16] = ACTIONS(299),
    [anon_sym_goto_SLASH32] = ACTIONS(299),
    [anon_sym_packed_DASHswitch] = ACTIONS(299),
    [anon_sym_sparse_DASHswitch] = ACTIONS(299),
    [anon_sym_cmpl_DASHfloat] = ACTIONS(299),
    [anon_sym_cmpg_DASHfloat] = ACTIONS(299),
    [anon_sym_cmpl_DASHdouble] = ACTIONS(299),
    [anon_sym_cmpg_DASHdouble] = ACTIONS(299),
    [anon_sym_cmp_DASHlong] = ACTIONS(299),
    [anon_sym_if_DASHeq] = ACTIONS(301),
    [anon_sym_if_DASHne] = ACTIONS(301),
    [anon_sym_if_DASHlt] = ACTIONS(301),
    [anon_sym_if_DASHge] = ACTIONS(301),
    [anon_sym_if_DASHgt] = ACTIONS(301),
    [anon_sym_if_DASHle] = ACTIONS(301),
    [anon_sym_if_DASHeqz] = ACTIONS(299),
    [anon_sym_if_DASHnez] = ACTIONS(299),
    [anon_sym_if_DASHltz] = ACTIONS(299),
    [anon_sym_if_DASHgez] = ACTIONS(299),
    [anon_sym_if_DASHgtz] = ACTIONS(299),
    [anon_sym_if_DASHlez] = ACTIONS(299),
    [anon_sym_aget] = ACTIONS(301),
    [anon_sym_aget_DASHwide] = ACTIONS(299),
    [anon_sym_aget_DASHobject] = ACTIONS(299),
    [anon_sym_aget_DASHboolean] = ACTIONS(299),
    [anon_sym_aget_DASHbyte] = ACTIONS(299),
    [anon_sym_aget_DASHchar] = ACTIONS(299),
    [anon_sym_aget_DASHshort] = ACTIONS(299),
    [anon_sym_aput] = ACTIONS(301),
    [anon_sym_aput_DASHwide] = ACTIONS(299),
    [anon_sym_aput_DASHobject] = ACTIONS(299),
    [anon_sym_aput_DASHboolean] = ACTIONS(299),
    [anon_sym_aput_DASHbyte] = ACTIONS(299),
    [anon_sym_aput_DASHchar] = ACTIONS(299),
    [anon_sym_aput_DASHshort] = ACTIONS(299),
    [anon_sym_iget] = ACTIONS(301),
    [anon_sym_iget_DASHwide] = ACTIONS(301),
    [anon_sym_iget_DASHobject] = ACTIONS(301),
    [anon_sym_iget_DASHboolean] = ACTIONS(299),
    [anon_sym_iget_DASHbyte] = ACTIONS(299),
    [anon_sym_iget_DASHchar] = ACTIONS(299),
    [anon_sym_iget_DASHshort] = ACTIONS(299),
    [anon_sym_iget_DASHvolatile] = ACTIONS(299),
    [anon_sym_iget_DASHwide_DASHvolatile] = ACTIONS(299),
    [anon_sym_iget_DASHobject_DASHvolatile] = ACTIONS(299),
    [anon_sym_iput] = ACTIONS(301),
    [anon_sym_iput_DASHwide] = ACTIONS(301),
    [anon_sym_iput_DASHobject] = ACTIONS(301),
    [anon_sym_iput_DASHboolean] = ACTIONS(301),
    [anon_sym_iput_DASHbyte] = ACTIONS(301),
    [anon_sym_iput_DASHchar] = ACTIONS(301),
    [anon_sym_iput_DASHshort] = ACTIONS(301),
    [anon_sym_iput_DASHvolatile] = ACTIONS(299),
    [anon_sym_iput_DASHwide_DASHvolatile] = ACTIONS(299),
    [anon_sym_iput_DASHobject_DASHvolatile] = ACTIONS(299),
    [anon_sym_sget] = ACTIONS(301),
    [anon_sym_sget_DASHwide] = ACTIONS(301),
    [anon_sym_sget_DASHobject] = ACTIONS(301),
    [anon_sym_sget_DASHboolean] = ACTIONS(299),
    [anon_sym_sget_DASHbyte] = ACTIONS(299),
    [anon_sym_sget_DASHchar] = ACTIONS(299),
    [anon_sym_sget_DASHshort] = ACTIONS(299),
    [anon_sym_sget_DASHvolatile] = ACTIONS(299),
    [anon_sym_sget_DASHwide_DASHvolatile] = ACTIONS(299),
    [anon_sym_sget_DASHobject_DASHvolatile] = ACTIONS(299),
    [anon_sym_sput] = ACTIONS(301),
    [anon_sym_sput_DASHwide] = ACTIONS(301),
    [anon_sym_sput_DASHobject] = ACTIONS(301),
    [anon_sym_sput_DASHboolean] = ACTIONS(299),
    [anon_sym_sput_DASHbyte] = ACTIONS(299),
    [anon_sym_sput_DASHchar] = ACTIONS(299),
    [anon_sym_sput_DASHshort] = ACTIONS(299),
    [anon_sym_sput_DASHvolatile] = ACTIONS(299),
    [anon_sym_sput_DASHwide_DASHvolatile] = ACTIONS(299),
    [anon_sym_sput_DASHobject_DASHvolatile] = ACTIONS(299),
    [anon_sym_invoke_DASHconstructor] = ACTIONS(299),
    [anon_sym_invoke_DASHcustom] = ACTIONS(301),
    [anon_sym_invoke_DASHdirect] = ACTIONS(301),
    [anon_sym_invoke_DASHdirect_DASHempty] = ACTIONS(299),
    [anon_sym_invoke_DASHinstance] = ACTIONS(299),
    [anon_sym_invoke_DASHinterface] = ACTIONS(301),
    [anon_sym_invoke_DASHpolymorphic] = ACTIONS(301),
    [anon_sym_invoke_DASHstatic] = ACTIONS(301),
    [anon_sym_invoke_DASHsuper] = ACTIONS(301),
    [anon_sym_invoke_DASHvirtual] = ACTIONS(301),
    [anon_sym_invoke_DASHcustom_SLASHrange] = ACTIONS(299),
    [anon_sym_invoke_DASHdirect_SLASHrange] = ACTIONS(299),
    [anon_sym_invoke_DASHinterface_SLASHrange] = ACTIONS(299),
    [anon_sym_invoke_DASHobject_DASHinit_SLASHrange] = ACTIONS(299),
    [anon_sym_invoke_DASHpolymorphic_SLASHrange] = ACTIONS(299),
    [anon_sym_invoke_DASHstatic_SLASHrange] = ACTIONS(299),
    [anon_sym_invoke_DASHsuper_SLASHrange] = ACTIONS(299),
    [anon_sym_invoke_DASHvirtual_SLASHrange] = ACTIONS(299),
    [anon_sym_neg_DASHint] = ACTIONS(299),
    [anon_sym_not_DASHint] = ACTIONS(299),
    [anon_sym_neg_DASHlong] = ACTIONS(299),
    [anon_sym_not_DASHlong] = ACTIONS(299),
    [anon_sym_neg_DASHfloat] = ACTIONS(299),
    [anon_sym_neg_DASHdouble] = ACTIONS(299),
    [anon_sym_int_DASHto_DASHlong] = ACTIONS(299),
    [anon_sym_int_DASHto_DASHfloat] = ACTIONS(299),
    [anon_sym_int_DASHto_DASHdouble] = ACTIONS(299),
    [anon_sym_long_DASHto_DASHint] = ACTIONS(299),
    [anon_sym_long_DASHto_DASHfloat] = ACTIONS(299),
    [anon_sym_long_DASHto_DASHdouble] = ACTIONS(299),
    [anon_sym_float_DASHto_DASHint] = ACTIONS(299),
    [anon_sym_float_DASHto_DASHlong] = ACTIONS(299),
    [anon_sym_float_DASHto_DASHdouble] = ACTIONS(299),
    [anon_sym_double_DASHto_DASHint] = ACTIONS(299),
    [anon_sym_double_DASHto_DASHlong] = ACTIONS(299),
    [anon_sym_double_DASHto_DASHfloat] = ACTIONS(299),
    [anon_sym_int_DASHto_DASHbyte] = ACTIONS(299),
    [anon_sym_int_DASHto_DASHchar] = ACTIONS(299),
    [anon_sym_int_DASHto_DASHshort] = ACTIONS(299),
    [anon_sym_add_DASHint] = ACTIONS(301),
    [anon_sym_sub_DASHint] = ACTIONS(301),
    [anon_sym_mul_DASHint] = ACTIONS(301),
    [anon_sym_div_DASHint] = ACTIONS(301),
    [anon_sym_rem_DASHint] = ACTIONS(301),
    [anon_sym_and_DASHint] = ACTIONS(301),
    [anon_sym_or_DASHint] = ACTIONS(301),
    [anon_sym_xor_DASHint] = ACTIONS(301),
    [anon_sym_shl_DASHint] = ACTIONS(301),
    [anon_sym_shr_DASHint] = ACTIONS(301),
    [anon_sym_ushr_DASHint] = ACTIONS(301),
    [anon_sym_add_DASHlong] = ACTIONS(301),
    [anon_sym_sub_DASHlong] = ACTIONS(301),
    [anon_sym_mul_DASHlong] = ACTIONS(301),
    [anon_sym_div_DASHlong] = ACTIONS(301),
    [anon_sym_rem_DASHlong] = ACTIONS(301),
    [anon_sym_and_DASHlong] = ACTIONS(301),
    [anon_sym_or_DASHlong] = ACTIONS(301),
    [anon_sym_xor_DASHlong] = ACTIONS(301),
    [anon_sym_shl_DASHlong] = ACTIONS(301),
    [anon_sym_shr_DASHlong] = ACTIONS(301),
    [anon_sym_ushr_DASHlong] = ACTIONS(301),
    [anon_sym_add_DASHfloat] = ACTIONS(301),
    [anon_sym_sub_DASHfloat] = ACTIONS(301),
    [anon_sym_mul_DASHfloat] = ACTIONS(301),
    [anon_sym_div_DASHfloat] = ACTIONS(301),
    [anon_sym_rem_DASHfloat] = ACTIONS(301),
    [anon_sym_add_DASHdouble] = ACTIONS(301),
    [anon_sym_sub_DASHdouble] = ACTIONS(301),
    [anon_sym_mul_DASHdouble] = ACTIONS(301),
    [anon_sym_div_DASHdouble] = ACTIONS(301),
    [anon_sym_rem_DASHdouble] = ACTIONS(301),
    [anon_sym_add_DASHint_SLASH2addr] = ACTIONS(299),
    [anon_sym_sub_DASHint_SLASH2addr] = ACTIONS(299),
    [anon_sym_mul_DASHint_SLASH2addr] = ACTIONS(299),
    [anon_sym_div_DASHint_SLASH2addr] = ACTIONS(299),
    [anon_sym_rem_DASHint_SLASH2addr] = ACTIONS(299),
    [anon_sym_and_DASHint_SLASH2addr] = ACTIONS(299),
    [anon_sym_or_DASHint_SLASH2addr] = ACTIONS(299),
    [anon_sym_xor_DASHint_SLASH2addr] = ACTIONS(299),
    [anon_sym_shl_DASHint_SLASH2addr] = ACTIONS(299),
    [anon_sym_shr_DASHint_SLASH2addr] = ACTIONS(299),
    [anon_sym_ushr_DASHint_SLASH2addr] = ACTIONS(299),
    [anon_sym_add_DASHlong_SLASH2addr] = ACTIONS(299),
    [anon_sym_sub_DASHlong_SLASH2addr] = ACTIONS(299),
    [anon_sym_mul_DASHlong_SLASH2addr] = ACTIONS(299),
    [anon_sym_div_DASHlong_SLASH2addr] = ACTIONS(299),
    [anon_sym_rem_DASHlong_SLASH2addr] = ACTIONS(299),
    [anon_sym_and_DASHlong_SLASH2addr] = ACTIONS(299),
    [anon_sym_or_DASHlong_SLASH2addr] = ACTIONS(299),
    [anon_sym_xor_DASHlong_SLASH2addr] = ACTIONS(299),
    [anon_sym_shl_DASHlong_SLASH2addr] = ACTIONS(299),
    [anon_sym_shr_DASHlong_SLASH2addr] = ACTIONS(299),
    [anon_sym_ushr_DASHlong_SLASH2addr] = ACTIONS(299),
    [anon_sym_add_DASHfloat_SLASH2addr] = ACTIONS(299),
    [anon_sym_sub_DASHfloat_SLASH2addr] = ACTIONS(299),
    [anon_sym_mul_DASHfloat_SLASH2addr] = ACTIONS(299),
    [anon_sym_div_DASHfloat_SLASH2addr] = ACTIONS(299),
    [anon_sym_rem_DASHfloat_SLASH2addr] = ACTIONS(299),
    [anon_sym_add_DASHdouble_SLASH2addr] = ACTIONS(299),
    [anon_sym_sub_DASHdouble_SLASH2addr] = ACTIONS(299),
    [anon_sym_mul_DASHdouble_SLASH2addr] = ACTIONS(299),
    [anon_sym_div_DASHdouble_SLASH2addr] = ACTIONS(299),
    [anon_sym_rem_DASHdouble_SLASH2addr] = ACTIONS(299),
    [anon_sym_add_DASHint_SLASHlit16] = ACTIONS(299),
    [anon_sym_sub_DASHint_SLASHlit16] = ACTIONS(299),
    [anon_sym_mul_DASHint_SLASHlit16] = ACTIONS(299),
    [anon_sym_div_DASHint_SLASHlit16] = ACTIONS(299),
    [anon_sym_rem_DASHint_SLASHlit16] = ACTIONS(299),
    [anon_sym_and_DASHint_SLASHlit16] = ACTIONS(299),
    [anon_sym_or_DASHint_SLASHlit16] = ACTIONS(299),
    [anon_sym_xor_DASHint_SLASHlit16] = ACTIONS(299),
    [anon_sym_add_DASHint_SLASHlit8] = ACTIONS(299),
    [anon_sym_sub_DASHint_SLASHlit8] = ACTIONS(299),
    [anon_sym_mul_DASHint_SLASHlit8] = ACTIONS(299),
    [anon_sym_div_DASHint_SLASHlit8] = ACTIONS(299),
    [anon_sym_rem_DASHint_SLASHlit8] = ACTIONS(299),
    [anon_sym_and_DASHint_SLASHlit8] = ACTIONS(299),
    [anon_sym_or_DASHint_SLASHlit8] = ACTIONS(299),
    [anon_sym_xor_DASHint_SLASHlit8] = ACTIONS(299),
    [anon_sym_shl_DASHint_SLASHlit8] = ACTIONS(299),
    [anon_sym_shr_DASHint_SLASHlit8] = ACTIONS(299),
    [anon_sym_ushr_DASHint_SLASHlit8] = ACTIONS(299),
    [anon_sym_static_DASHget] = ACTIONS(299),
    [anon_sym_static_DASHput] = ACTIONS(299),
    [anon_sym_instance_DASHget] = ACTIONS(299),
    [anon_sym_instance_DASHput] = ACTIONS(299),
    [anon_sym_execute_DASHinline] = ACTIONS(301),
    [anon_sym_execute_DASHinline_SLASHrange] = ACTIONS(299),
    [anon_sym_iget_DASHquick] = ACTIONS(299),
    [anon_sym_iget_DASHwide_DASHquick] = ACTIONS(299),
    [anon_sym_iget_DASHobject_DASHquick] = ACTIONS(299),
    [anon_sym_iput_DASHquick] = ACTIONS(299),
    [anon_sym_iput_DASHwide_DASHquick] = ACTIONS(299),
    [anon_sym_iput_DASHobject_DASHquick] = ACTIONS(299),
    [anon_sym_iput_DASHboolean_DASHquick] = ACTIONS(299),
    [anon_sym_iput_DASHbyte_DASHquick] = ACTIONS(299),
    [anon_sym_iput_DASHchar_DASHquick] = ACTIONS(299),
    [anon_sym_iput_DASHshort_DASHquick] = ACTIONS(299),
    [anon_sym_invoke_DASHvirtual_DASHquick] = ACTIONS(301),
    [anon_sym_invoke_DASHvirtual_DASHquick_SLASHrange] = ACTIONS(299),
    [anon_sym_invoke_DASHsuper_DASHquick] = ACTIONS(301),
    [anon_sym_invoke_DASHsuper_DASHquick_SLASHrange] = ACTIONS(299),
    [anon_sym_rsub_DASHint] = ACTIONS(301),
    [anon_sym_rsub_DASHint_SLASHlit8] = ACTIONS(299),
    [anon_sym_DOTline] = ACTIONS(299),
    [anon_sym_DOTlocals] = ACTIONS(299),
    [anon_sym_DOTlocal] = ACTIONS(301),
    [anon_sym_DOTendlocal] = ACTIONS(299),
    [anon_sym_DOTrestartlocal] = ACTIONS(299),
    [anon_sym_DOTregisters] = ACTIONS(299),
    [anon_sym_DOTcatch] = ACTIONS(301),
    [anon_sym_DOTcatchall] = ACTIONS(299),
    [anon_sym_DOTpacked_DASHswitch] = ACTIONS(299),
    [anon_sym_DOTsparse_DASHswitch] = ACTIONS(299),
    [anon_sym_DOTarray_DASHdata] = ACTIONS(299),
    [sym_prologue_directive] = ACTIONS(299),
    [sym_epilogue_directive] = ACTIONS(299),
    [aux_sym_label_token1] = ACTIONS(299),
    [aux_sym_jmp_label_token1] = ACTIONS(299),
    [sym_comment] = ACTIONS(3),
  },
  [34] = {
    [ts_builtin_sym_end] = ACTIONS(303),
    [anon_sym_DOTsource] = ACTIONS(303),
    [anon_sym_DOTfield] = ACTIONS(303),
    [anon_sym_DOTendfield] = ACTIONS(303),
    [anon_sym_DOTmethod] = ACTIONS(303),
    [anon_sym_DOTendmethod] = ACTIONS(303),
    [anon_sym_DOTannotation] = ACTIONS(303),
    [anon_sym_DOTparam] = ACTIONS(305),
    [anon_sym_DOTparameter] = ACTIONS(303),
    [anon_sym_DOTendparameter] = ACTIONS(303),
    [anon_sym_nop] = ACTIONS(305),
    [anon_sym_move] = ACTIONS(305),
    [anon_sym_move_SLASHfrom16] = ACTIONS(303),
    [anon_sym_move_SLASH16] = ACTIONS(303),
    [anon_sym_move_DASHwide] = ACTIONS(305),
    [anon_sym_move_DASHwide_SLASHfrom16] = ACTIONS(303),
    [anon_sym_move_DASHwide_SLASH16] = ACTIONS(303),
    [anon_sym_move_DASHobject] = ACTIONS(305),
    [anon_sym_move_DASHobject_SLASHfrom16] = ACTIONS(303),
    [anon_sym_move_DASHobject_SLASH16] = ACTIONS(303),
    [anon_sym_move_DASHresult] = ACTIONS(305),
    [anon_sym_move_DASHresult_DASHwide] = ACTIONS(303),
    [anon_sym_move_DASHresult_DASHobject] = ACTIONS(303),
    [anon_sym_move_DASHexception] = ACTIONS(303),
    [anon_sym_return_DASHvoid] = ACTIONS(303),
    [anon_sym_return] = ACTIONS(305),
    [anon_sym_return_DASHwide] = ACTIONS(303),
    [anon_sym_return_DASHobject] = ACTIONS(303),
    [anon_sym_const_SLASH4] = ACTIONS(303),
    [anon_sym_const_SLASH16] = ACTIONS(303),
    [anon_sym_const] = ACTIONS(305),
    [anon_sym_const_SLASHhigh16] = ACTIONS(303),
    [anon_sym_const_DASHwide_SLASH16] = ACTIONS(303),
    [anon_sym_const_DASHwide_SLASH32] = ACTIONS(303),
    [anon_sym_const_DASHwide] = ACTIONS(305),
    [anon_sym_const_DASHwide_SLASHhigh16] = ACTIONS(303),
    [anon_sym_const_DASHstring] = ACTIONS(305),
    [anon_sym_const_DASHstring_SLASHjumbo] = ACTIONS(303),
    [anon_sym_const_DASHclass] = ACTIONS(303),
    [anon_sym_const_DASHmethod_DASHhandle] = ACTIONS(303),
    [anon_sym_const_DASHmethod_DASHtype] = ACTIONS(303),
    [anon_sym_monitor_DASHenter] = ACTIONS(303),
    [anon_sym_monitor_DASHexit] = ACTIONS(303),
    [anon_sym_check_DASHcast] = ACTIONS(303),
    [anon_sym_instance_DASHof] = ACTIONS(303),
    [anon_sym_array_DASHlength] = ACTIONS(303),
    [anon_sym_new_DASHinstance] = ACTIONS(303),
    [anon_sym_new_DASHarray] = ACTIONS(303),
    [anon_sym_filled_DASHnew_DASHarray] = ACTIONS(305),
    [anon_sym_filled_DASHnew_DASHarray_SLASHrange] = ACTIONS(303),
    [anon_sym_fill_DASHarray_DASHdata] = ACTIONS(303),
    [anon_sym_throw] = ACTIONS(305),
    [anon_sym_throw_DASHverification_DASHerror] = ACTIONS(303),
    [anon_sym_goto] = ACTIONS(305),
    [anon_sym_goto_SLASH16] = ACTIONS(303),
    [anon_sym_goto_SLASH32] = ACTIONS(303),
    [anon_sym_packed_DASHswitch] = ACTIONS(303),
    [anon_sym_sparse_DASHswitch] = ACTIONS(303),
    [anon_sym_cmpl_DASHfloat] = ACTIONS(303),
    [anon_sym_cmpg_DASHfloat] = ACTIONS(303),
    [anon_sym_cmpl_DASHdouble] = ACTIONS(303),
    [anon_sym_cmpg_DASHdouble] = ACTIONS(303),
    [anon_sym_cmp_DASHlong] = ACTIONS(303),
    [anon_sym_if_DASHeq] = ACTIONS(305),
    [anon_sym_if_DASHne] = ACTIONS(305),
    [anon_sym_if_DASHlt] = ACTIONS(305),
    [anon_sym_if_DASHge] = ACTIONS(305),
    [anon_sym_if_DASHgt] = ACTIONS(305),
    [anon_sym_if_DASHle] = ACTIONS(305),
    [anon_sym_if_DASHeqz] = ACTIONS(303),
    [anon_sym_if_DASHnez] = ACTIONS(303),
    [anon_sym_if_DASHltz] = ACTIONS(303),
    [anon_sym_if_DASHgez] = ACTIONS(303),
    [anon_sym_if_DASHgtz] = ACTIONS(303),
    [anon_sym_if_DASHlez] = ACTIONS(303),
    [anon_sym_aget] = ACTIONS(305),
    [anon_sym_aget_DASHwide] = ACTIONS(303),
    [anon_sym_aget_DASHobject] = ACTIONS(303),
    [anon_sym_aget_DASHboolean] = ACTIONS(303),
    [anon_sym_aget_DASHbyte] = ACTIONS(303),
    [anon_sym_aget_DASHchar] = ACTIONS(303),
    [anon_sym_aget_DASHshort] = ACTIONS(303),
    [anon_sym_aput] = ACTIONS(305),
    [anon_sym_aput_DASHwide] = ACTIONS(303),
    [anon_sym_aput_DASHobject] = ACTIONS(303),
    [anon_sym_aput_DASHboolean] = ACTIONS(303),
    [anon_sym_aput_DASHbyte] = ACTIONS(303),
    [anon_sym_aput_DASHchar] = ACTIONS(303),
    [anon_sym_aput_DASHshort] = ACTIONS(303),
    [anon_sym_iget] = ACTIONS(305),
    [anon_sym_iget_DASHwide] = ACTIONS(305),
    [anon_sym_iget_DASHobject] = ACTIONS(305),
    [anon_sym_iget_DASHboolean] = ACTIONS(303),
    [anon_sym_iget_DASHbyte] = ACTIONS(303),
    [anon_sym_iget_DASHchar] = ACTIONS(303),
    [anon_sym_iget_DASHshort] = ACTIONS(303),
    [anon_sym_iget_DASHvolatile] = ACTIONS(303),
    [anon_sym_iget_DASHwide_DASHvolatile] = ACTIONS(303),
    [anon_sym_iget_DASHobject_DASHvolatile] = ACTIONS(303),
    [anon_sym_iput] = ACTIONS(305),
    [anon_sym_iput_DASHwide] = ACTIONS(305),
    [anon_sym_iput_DASHobject] = ACTIONS(305),
    [anon_sym_iput_DASHboolean] = ACTIONS(305),
    [anon_sym_iput_DASHbyte] = ACTIONS(305),
    [anon_sym_iput_DASHchar] = ACTIONS(305),
    [anon_sym_iput_DASHshort] = ACTIONS(305),
    [anon_sym_iput_DASHvolatile] = ACTIONS(303),
    [anon_sym_iput_DASHwide_DASHvolatile] = ACTIONS(303),
    [anon_sym_iput_DASHobject_DASHvolatile] = ACTIONS(303),
    [anon_sym_sget] = ACTIONS(305),
    [anon_sym_sget_DASHwide] = ACTIONS(305),
    [anon_sym_sget_DASHobject] = ACTIONS(305),
    [anon_sym_sget_DASHboolean] = ACTIONS(303),
    [anon_sym_sget_DASHbyte] = ACTIONS(303),
    [anon_sym_sget_DASHchar] = ACTIONS(303),
    [anon_sym_sget_DASHshort] = ACTIONS(303),
    [anon_sym_sget_DASHvolatile] = ACTIONS(303),
    [anon_sym_sget_DASHwide_DASHvolatile] = ACTIONS(303),
    [anon_sym_sget_DASHobject_DASHvolatile] = ACTIONS(303),
    [anon_sym_sput] = ACTIONS(305),
    [anon_sym_sput_DASHwide] = ACTIONS(305),
    [anon_sym_sput_DASHobject] = ACTIONS(305),
    [anon_sym_sput_DASHboolean] = ACTIONS(303),
    [anon_sym_sput_DASHbyte] = ACTIONS(303),
    [anon_sym_sput_DASHchar] = ACTIONS(303),
    [anon_sym_sput_DASHshort] = ACTIONS(303),
    [anon_sym_sput_DASHvolatile] = ACTIONS(303),
    [anon_sym_sput_DASHwide_DASHvolatile] = ACTIONS(303),
    [anon_sym_sput_DASHobject_DASHvolatile] = ACTIONS(303),
    [anon_sym_invoke_DASHconstructor] = ACTIONS(303),
    [anon_sym_invoke_DASHcustom] = ACTIONS(305),
    [anon_sym_invoke_DASHdirect] = ACTIONS(305),
    [anon_sym_invoke_DASHdirect_DASHempty] = ACTIONS(303),
    [anon_sym_invoke_DASHinstance] = ACTIONS(303),
    [anon_sym_invoke_DASHinterface] = ACTIONS(305),
    [anon_sym_invoke_DASHpolymorphic] = ACTIONS(305),
    [anon_sym_invoke_DASHstatic] = ACTIONS(305),
    [anon_sym_invoke_DASHsuper] = ACTIONS(305),
    [anon_sym_invoke_DASHvirtual] = ACTIONS(305),
    [anon_sym_invoke_DASHcustom_SLASHrange] = ACTIONS(303),
    [anon_sym_invoke_DASHdirect_SLASHrange] = ACTIONS(303),
    [anon_sym_invoke_DASHinterface_SLASHrange] = ACTIONS(303),
    [anon_sym_invoke_DASHobject_DASHinit_SLASHrange] = ACTIONS(303),
    [anon_sym_invoke_DASHpolymorphic_SLASHrange] = ACTIONS(303),
    [anon_sym_invoke_DASHstatic_SLASHrange] = ACTIONS(303),
    [anon_sym_invoke_DASHsuper_SLASHrange] = ACTIONS(303),
    [anon_sym_invoke_DASHvirtual_SLASHrange] = ACTIONS(303),
    [anon_sym_neg_DASHint] = ACTIONS(303),
    [anon_sym_not_DASHint] = ACTIONS(303),
    [anon_sym_neg_DASHlong] = ACTIONS(303),
    [anon_sym_not_DASHlong] = ACTIONS(303),
    [anon_sym_neg_DASHfloat] = ACTIONS(303),
    [anon_sym_neg_DASHdouble] = ACTIONS(303),
    [anon_sym_int_DASHto_DASHlong] = ACTIONS(303),
    [anon_sym_int_DASHto_DASHfloat] = ACTIONS(303),
    [anon_sym_int_DASHto_DASHdouble] = ACTIONS(303),
    [anon_sym_long_DASHto_DASHint] = ACTIONS(303),
    [anon_sym_long_DASHto_DASHfloat] = ACTIONS(303),
    [anon_sym_long_DASHto_DASHdouble] = ACTIONS(303),
    [anon_sym_float_DASHto_DASHint] = ACTIONS(303),
    [anon_sym_float_DASHto_DASHlong] = ACTIONS(303),
    [anon_sym_float_DASHto_DASHdouble] = ACTIONS(303),
    [anon_sym_double_DASHto_DASHint] = ACTIONS(303),
    [anon_sym_double_DASHto_DASHlong] = ACTIONS(303),
    [anon_sym_double_DASHto_DASHfloat] = ACTIONS(303),
    [anon_sym_int_DASHto_DASHbyte] = ACTIONS(303),
    [anon_sym_int_DASHto_DASHchar] = ACTIONS(303),
    [anon_sym_int_DASHto_DASHshort] = ACTIONS(303),
    [anon_sym_add_DASHint] = ACTIONS(305),
    [anon_sym_sub_DASHint] = ACTIONS(305),
    [anon_sym_mul_DASHint] = ACTIONS(305),
    [anon_sym_div_DASHint] = ACTIONS(305),
    [anon_sym_rem_DASHint] = ACTIONS(305),
    [anon_sym_and_DASHint] = ACTIONS(305),
    [anon_sym_or_DASHint] = ACTIONS(305),
    [anon_sym_xor_DASHint] = ACTIONS(305),
    [anon_sym_shl_DASHint] = ACTIONS(305),
    [anon_sym_shr_DASHint] = ACTIONS(305),
    [anon_sym_ushr_DASHint] = ACTIONS(305),
    [anon_sym_add_DASHlong] = ACTIONS(305),
    [anon_sym_sub_DASHlong] = ACTIONS(305),
    [anon_sym_mul_DASHlong] = ACTIONS(305),
    [anon_sym_div_DASHlong] = ACTIONS(305),
    [anon_sym_rem_DASHlong] = ACTIONS(305),
    [anon_sym_and_DASHlong] = ACTIONS(305),
    [anon_sym_or_DASHlong] = ACTIONS(305),
    [anon_sym_xor_DASHlong] = ACTIONS(305),
    [anon_sym_shl_DASHlong] = ACTIONS(305),
    [anon_sym_shr_DASHlong] = ACTIONS(305),
    [anon_sym_ushr_DASHlong] = ACTIONS(305),
    [anon_sym_add_DASHfloat] = ACTIONS(305),
    [anon_sym_sub_DASHfloat] = ACTIONS(305),
    [anon_sym_mul_DASHfloat] = ACTIONS(305),
    [anon_sym_div_DASHfloat] = ACTIONS(305),
    [anon_sym_rem_DASHfloat] = ACTIONS(305),
    [anon_sym_add_DASHdouble] = ACTIONS(305),
    [anon_sym_sub_DASHdouble] = ACTIONS(305),
    [anon_sym_mul_DASHdouble] = ACTIONS(305),
    [anon_sym_div_DASHdouble] = ACTIONS(305),
    [anon_sym_rem_DASHdouble] = ACTIONS(305),
    [anon_sym_add_DASHint_SLASH2addr] = ACTIONS(303),
    [anon_sym_sub_DASHint_SLASH2addr] = ACTIONS(303),
    [anon_sym_mul_DASHint_SLASH2addr] = ACTIONS(303),
    [anon_sym_div_DASHint_SLASH2addr] = ACTIONS(303),
    [anon_sym_rem_DASHint_SLASH2addr] = ACTIONS(303),
    [anon_sym_and_DASHint_SLASH2addr] = ACTIONS(303),
    [anon_sym_or_DASHint_SLASH2addr] = ACTIONS(303),
    [anon_sym_xor_DASHint_SLASH2addr] = ACTIONS(303),
    [anon_sym_shl_DASHint_SLASH2addr] = ACTIONS(303),
    [anon_sym_shr_DASHint_SLASH2addr] = ACTIONS(303),
    [anon_sym_ushr_DASHint_SLASH2addr] = ACTIONS(303),
    [anon_sym_add_DASHlong_SLASH2addr] = ACTIONS(303),
    [anon_sym_sub_DASHlong_SLASH2addr] = ACTIONS(303),
    [anon_sym_mul_DASHlong_SLASH2addr] = ACTIONS(303),
    [anon_sym_div_DASHlong_SLASH2addr] = ACTIONS(303),
    [anon_sym_rem_DASHlong_SLASH2addr] = ACTIONS(303),
    [anon_sym_and_DASHlong_SLASH2addr] = ACTIONS(303),
    [anon_sym_or_DASHlong_SLASH2addr] = ACTIONS(303),
