#include <tree_sitter/parser.h>

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#define LANGUAGE_VERSION 13
#define STATE_COUNT 4208
#define LARGE_STATE_COUNT 979
#define SYMBOL_COUNT 348
#define ALIAS_COUNT 8
#define TOKEN_COUNT 156
#define EXTERNAL_TOKEN_COUNT 5
#define FIELD_COUNT 39
#define MAX_ALIAS_SEQUENCE_LENGTH 10
#define PRODUCTION_ID_COUNT 267

enum {
  sym_identifier = 1,
  sym_hash_bang_line = 2,
  anon_sym_export = 3,
  anon_sym_STAR = 4,
  anon_sym_default = 5,
  anon_sym_type = 6,
  anon_sym_EQ = 7,
  anon_sym_as = 8,
  anon_sym_namespace = 9,
  anon_sym_LBRACE = 10,
  anon_sym_COMMA = 11,
  anon_sym_RBRACE = 12,
  anon_sym_typeof = 13,
  anon_sym_import = 14,
  anon_sym_from = 15,
  anon_sym_var = 16,
  anon_sym_let = 17,
  anon_sym_const = 18,
  anon_sym_BANG = 19,
  anon_sym_else = 20,
  anon_sym_if = 21,
  anon_sym_switch = 22,
  anon_sym_for = 23,
  anon_sym_LPAREN = 24,
  anon_sym_RPAREN = 25,
  anon_sym_await = 26,
  anon_sym_in = 27,
  anon_sym_of = 28,
  anon_sym_while = 29,
  anon_sym_do = 30,
  anon_sym_try = 31,
  anon_sym_with = 32,
  anon_sym_break = 33,
  anon_sym_continue = 34,
  anon_sym_debugger = 35,
  anon_sym_return = 36,
  anon_sym_throw = 37,
  anon_sym_SEMI = 38,
  anon_sym_COLON = 39,
  anon_sym_case = 40,
  anon_sym_catch = 41,
  anon_sym_finally = 42,
  anon_sym_yield = 43,
  anon_sym_LBRACK = 44,
  anon_sym_RBRACK = 45,
  anon_sym_LT = 46,
  anon_sym_GT = 47,
  anon_sym_SLASH = 48,
  anon_sym_DOT = 49,
  anon_sym_class = 50,
  anon_sym_async = 51,
  anon_sym_function = 52,
  anon_sym_EQ_GT = 53,
  anon_sym_QMARK_DOT = 54,
  anon_sym_new = 55,
  anon_sym_PLUS_EQ = 56,
  anon_sym_DASH_EQ = 57,
  anon_sym_STAR_EQ = 58,
  anon_sym_SLASH_EQ = 59,
  anon_sym_PERCENT_EQ = 60,
  anon_sym_CARET_EQ = 61,
  anon_sym_AMP_EQ = 62,
  anon_sym_PIPE_EQ = 63,
  anon_sym_GT_GT_EQ = 64,
  anon_sym_GT_GT_GT_EQ = 65,
  anon_sym_LT_LT_EQ = 66,
  anon_sym_STAR_STAR_EQ = 67,
  anon_sym_AMP_AMP_EQ = 68,
  anon_sym_PIPE_PIPE_EQ = 69,
  anon_sym_QMARK_QMARK_EQ = 70,
  anon_sym_DOT_DOT_DOT = 71,
  anon_sym_AMP_AMP = 72,
  anon_sym_PIPE_PIPE = 73,
  anon_sym_GT_GT = 74,
  anon_sym_GT_GT_GT = 75,
  anon_sym_LT_LT = 76,
  anon_sym_AMP = 77,
  anon_sym_CARET = 78,
  anon_sym_PIPE = 79,
  anon_sym_PLUS = 80,
  anon_sym_DASH = 81,
  anon_sym_PERCENT = 82,
  anon_sym_STAR_STAR = 83,
  anon_sym_LT_EQ = 84,
  anon_sym_EQ_EQ = 85,
  anon_sym_EQ_EQ_EQ = 86,
  anon_sym_BANG_EQ = 87,
  anon_sym_BANG_EQ_EQ = 88,
  anon_sym_GT_EQ = 89,
  anon_sym_QMARK_QMARK = 90,
  anon_sym_instanceof = 91,
  anon_sym_TILDE = 92,
  anon_sym_void = 93,
  anon_sym_delete = 94,
  anon_sym_PLUS_PLUS = 95,
  anon_sym_DASH_DASH = 96,
  anon_sym_DQUOTE = 97,
  anon_sym_SQUOTE = 98,
  sym_unescaped_double_string_fragment = 99,
  sym_unescaped_single_string_fragment = 100,
  sym_escape_sequence = 101,
  sym_comment = 102,
  anon_sym_BQUOTE = 103,
  anon_sym_DOLLAR_LBRACE = 104,
  anon_sym_SLASH2 = 105,
  sym_regex_pattern = 106,
  sym_regex_flags = 107,
  sym_number = 108,
  sym_private_property_identifier = 109,
  anon_sym_target = 110,
  sym_this = 111,
  sym_super = 112,
  sym_true = 113,
  sym_false = 114,
  sym_null = 115,
  sym_undefined = 116,
  anon_sym_AT = 117,
  anon_sym_static = 118,
  anon_sym_readonly = 119,
  anon_sym_get = 120,
  anon_sym_set = 121,
  anon_sym_QMARK = 122,
  anon_sym_declare = 123,
  anon_sym_public = 124,
  anon_sym_private = 125,
  anon_sym_protected = 126,
  anon_sym_override = 127,
  anon_sym_module = 128,
  anon_sym_any = 129,
  anon_sym_number = 130,
  anon_sym_boolean = 131,
  anon_sym_string = 132,
  anon_sym_symbol = 133,
  anon_sym_abstract = 134,
  anon_sym_require = 135,
  anon_sym_extends = 136,
  anon_sym_implements = 137,
  anon_sym_global = 138,
  anon_sym_interface = 139,
  anon_sym_enum = 140,
  anon_sym_DASH_QMARK_COLON = 141,
  anon_sym_QMARK_COLON = 142,
  anon_sym_asserts = 143,
  anon_sym_infer = 144,
  anon_sym_is = 145,
  anon_sym_keyof = 146,
  anon_sym_unknown = 147,
  anon_sym_never = 148,
  anon_sym_object = 149,
  anon_sym_LBRACE_PIPE = 150,
  anon_sym_PIPE_RBRACE = 151,
  sym__automatic_semicolon = 152,
  sym__template_chars = 153,
  sym__ternary_qmark = 154,
  sym__function_signature_automatic_semicolon = 155,
  sym_program = 156,
  sym_export_statement = 157,
  sym_export_clause = 158,
  sym__import_export_specifier = 159,
  sym_declaration = 160,
  sym_import = 161,
  sym_import_statement = 162,
  sym_import_clause = 163,
  sym__from_clause = 164,
  sym_namespace_import_export = 165,
  sym_named_imports = 166,
  sym_expression_statement = 167,
  sym_variable_declaration = 168,
  sym_lexical_declaration = 169,
  sym_variable_declarator = 170,
  sym_statement_block = 171,
  sym_else_clause = 172,
  sym_if_statement = 173,
  sym_switch_statement = 174,
  sym_for_statement = 175,
  sym_for_in_statement = 176,
  sym__for_header = 177,
  sym_while_statement = 178,
  sym_do_statement = 179,
  sym_try_statement = 180,
  sym_with_statement = 181,
  sym_break_statement = 182,
  sym_continue_statement = 183,
  sym_debugger_statement = 184,
  sym_return_statement = 185,
  sym_throw_statement = 186,
  sym_empty_statement = 187,
  sym_labeled_statement = 188,
  sym_switch_body = 189,
  sym_switch_case = 190,
  sym_switch_default = 191,
  sym_catch_clause = 192,
  sym_finally_clause = 193,
  sym_parenthesized_expression = 194,
  sym_expression = 195,
  sym_primary_expression = 196,
  sym_yield_expression = 197,
  sym_object = 198,
  sym_object_pattern = 199,
  sym_assignment_pattern = 200,
  sym_object_assignment_pattern = 201,
  sym_array = 202,
  sym_array_pattern = 203,
  sym_nested_identifier = 204,
  sym_class = 205,
  sym_class_declaration = 206,
  sym_class_heritage = 207,
  sym_function = 208,
  sym_function_declaration = 209,
  sym_generator_function = 210,
  sym_generator_function_declaration = 211,
  sym_arrow_function = 212,
  sym__call_signature = 213,
  sym__formal_parameter = 214,
  sym_call_expression = 215,
  sym_new_expression = 216,
  sym_await_expression = 217,
  sym_member_expression = 218,
  sym_subscript_expression = 219,
  sym_assignment_expression = 220,
  sym__augmented_assignment_lhs = 221,
  sym_augmented_assignment_expression = 222,
  sym__initializer = 223,
  sym__destructuring_pattern = 224,
  sym_spread_element = 225,
  sym_ternary_expression = 226,
  sym_binary_expression = 227,
  sym_unary_expression = 228,
  sym_update_expression = 229,
  sym_sequence_expression = 230,
  sym_string = 231,
  sym_template_string = 232,
  sym_template_substitution = 233,
  sym_regex = 234,
  sym_meta_property = 235,
  sym_arguments = 236,
  sym_decorator = 237,
  sym_decorator_member_expression = 238,
  sym_decorator_call_expression = 239,
  sym_class_body = 240,
  sym_formal_parameters = 241,
  sym_pattern = 242,
  sym_rest_pattern = 243,
  sym_method_definition = 244,
  sym_pair = 245,
  sym_pair_pattern = 246,
  sym__property_name = 247,
  sym_computed_property_name = 248,
  sym_public_field_definition = 249,
  sym_non_null_expression = 250,
  sym_method_signature = 251,
  sym_abstract_method_signature = 252,
  sym_function_signature = 253,
  sym_type_assertion = 254,
  sym_as_expression = 255,
  sym_import_require_clause = 256,
  sym_extends_clause = 257,
  sym_implements_clause = 258,
  sym_ambient_declaration = 259,
  sym_abstract_class_declaration = 260,
  sym_module = 261,
  sym_internal_module = 262,
  sym__module = 263,
  sym_import_alias = 264,
  sym_nested_type_identifier = 265,
  sym_interface_declaration = 266,
  sym_extends_type_clause = 267,
  sym_enum_declaration = 268,
  sym_enum_body = 269,
  sym_enum_assignment = 270,
  sym_type_alias_declaration = 271,
  sym_accessibility_modifier = 272,
  sym_override_modifier = 273,
  sym_required_parameter = 274,
  sym_optional_parameter = 275,
  sym__parameter_name = 276,
  sym_omitting_type_annotation = 277,
  sym_opting_type_annotation = 278,
  sym_type_annotation = 279,
  sym_asserts = 280,
  sym__type = 281,
  sym_tuple_parameter = 282,
  sym_optional_tuple_parameter = 283,
  sym_optional_type = 284,
  sym_rest_type = 285,
  sym__tuple_type_member = 286,
  sym_constructor_type = 287,
  sym__primary_type = 288,
  sym_template_type = 289,
  sym_template_literal_type = 290,
  sym_infer_type = 291,
  sym_conditional_type = 292,
  sym_generic_type = 293,
  sym_type_predicate = 294,
  sym_type_predicate_annotation = 295,
  sym__type_query_member_expression = 296,
  sym__type_query_subscript_expression = 297,
  sym__type_query_call_expression = 298,
  sym_type_query = 299,
  sym_index_type_query = 300,
  sym_lookup_type = 301,
  sym_mapped_type_clause = 302,
  sym_literal_type = 303,
  sym__number = 304,
  sym_existential_type = 305,
  sym_flow_maybe_type = 306,
  sym_parenthesized_type = 307,
  sym_predefined_type = 308,
  sym_type_arguments = 309,
  sym_object_type = 310,
  sym_call_signature = 311,
  sym_property_signature = 312,
  sym_type_parameters = 313,
  sym_type_parameter = 314,
  sym_default_type = 315,
  sym_constraint = 316,
  sym_construct_signature = 317,
  sym_index_signature = 318,
  sym_array_type = 319,
  sym_tuple_type = 320,
  sym_readonly_type = 321,
  sym_union_type = 322,
  sym_intersection_type = 323,
  sym_function_type = 324,
  aux_sym_program_repeat1 = 325,
  aux_sym_export_statement_repeat1 = 326,
  aux_sym_export_clause_repeat1 = 327,
  aux_sym_named_imports_repeat1 = 328,
  aux_sym_variable_declaration_repeat1 = 329,
  aux_sym_switch_body_repeat1 = 330,
  aux_sym_object_repeat1 = 331,
  aux_sym_object_pattern_repeat1 = 332,
  aux_sym_array_repeat1 = 333,
  aux_sym_array_pattern_repeat1 = 334,
  aux_sym_string_repeat1 = 335,
  aux_sym_string_repeat2 = 336,
  aux_sym_template_string_repeat1 = 337,
  aux_sym_class_body_repeat1 = 338,
  aux_sym_formal_parameters_repeat1 = 339,
  aux_sym_extends_clause_repeat1 = 340,
  aux_sym_implements_clause_repeat1 = 341,
  aux_sym_extends_type_clause_repeat1 = 342,
  aux_sym_enum_body_repeat1 = 343,
  aux_sym_template_literal_type_repeat1 = 344,
  aux_sym_object_type_repeat1 = 345,
  aux_sym_type_parameters_repeat1 = 346,
  aux_sym_tuple_type_repeat1 = 347,
  alias_sym_import_specifier = 348,
  alias_sym_namespace_export = 349,
  alias_sym_property_identifier = 350,
  alias_sym_shorthand_property_identifier = 351,
  alias_sym_shorthand_property_identifier_pattern = 352,
  alias_sym_statement_identifier = 353,
  alias_sym_this_type = 354,
  alias_sym_type_identifier = 355,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym_identifier] = "identifier",
  [sym_hash_bang_line] = "hash_bang_line",
  [anon_sym_export] = "export",
  [anon_sym_STAR] = "*",
  [anon_sym_default] = "default",
  [anon_sym_type] = "type",
  [anon_sym_EQ] = "=",
  [anon_sym_as] = "as",
  [anon_sym_namespace] = "namespace",
  [anon_sym_LBRACE] = "{",
  [anon_sym_COMMA] = ",",
  [anon_sym_RBRACE] = "}",
  [anon_sym_typeof] = "typeof",
  [anon_sym_import] = "import",
  [anon_sym_from] = "from",
  [anon_sym_var] = "var",
  [anon_sym_let] = "let",
  [anon_sym_const] = "const",
  [anon_sym_BANG] = "!",
  [anon_sym_else] = "else",
  [anon_sym_if] = "if",
  [anon_sym_switch] = "switch",
  [anon_sym_for] = "for",
  [anon_sym_LPAREN] = "(",
  [anon_sym_RPAREN] = ")",
  [anon_sym_await] = "await",
  [anon_sym_in] = "in",
  [anon_sym_of] = "of",
  [anon_sym_while] = "while",
  [anon_sym_do] = "do",
  [anon_sym_try] = "try",
  [anon_sym_with] = "with",
  [anon_sym_break] = "break",
  [anon_sym_continue] = "continue",
  [anon_sym_debugger] = "debugger",
  [anon_sym_return] = "return",
  [anon_sym_throw] = "throw",
  [anon_sym_SEMI] = ";",
  [anon_sym_COLON] = ":",
  [anon_sym_case] = "case",
  [anon_sym_catch] = "catch",
  [anon_sym_finally] = "finally",
  [anon_sym_yield] = "yield",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [anon_sym_LT] = "<",
  [anon_sym_GT] = ">",
  [anon_sym_SLASH] = "/",
  [anon_sym_DOT] = ".",
  [anon_sym_class] = "class",
  [anon_sym_async] = "async",
  [anon_sym_function] = "function",
  [anon_sym_EQ_GT] = "=>",
  [anon_sym_QMARK_DOT] = "\?.",
  [anon_sym_new] = "new",
  [anon_sym_PLUS_EQ] = "+=",
  [anon_sym_DASH_EQ] = "-=",
  [anon_sym_STAR_EQ] = "*=",
  [anon_sym_SLASH_EQ] = "/=",
  [anon_sym_PERCENT_EQ] = "%=",
  [anon_sym_CARET_EQ] = "^=",
  [anon_sym_AMP_EQ] = "&=",
  [anon_sym_PIPE_EQ] = "|=",
  [anon_sym_GT_GT_EQ] = ">>=",
  [anon_sym_GT_GT_GT_EQ] = ">>>=",
  [anon_sym_LT_LT_EQ] = "<<=",
  [anon_sym_STAR_STAR_EQ] = "**=",
  [anon_sym_AMP_AMP_EQ] = "&&=",
  [anon_sym_PIPE_PIPE_EQ] = "||=",
  [anon_sym_QMARK_QMARK_EQ] = "\?\?=",
  [anon_sym_DOT_DOT_DOT] = "...",
  [anon_sym_AMP_AMP] = "&&",
  [anon_sym_PIPE_PIPE] = "||",
  [anon_sym_GT_GT] = ">>",
  [anon_sym_GT_GT_GT] = ">>>",
  [anon_sym_LT_LT] = "<<",
  [anon_sym_AMP] = "&",
  [anon_sym_CARET] = "^",
  [anon_sym_PIPE] = "|",
  [anon_sym_PLUS] = "+",
  [anon_sym_DASH] = "-",
  [anon_sym_PERCENT] = "%",
  [anon_sym_STAR_STAR] = "**",
  [anon_sym_LT_EQ] = "<=",
  [anon_sym_EQ_EQ] = "==",
  [anon_sym_EQ_EQ_EQ] = "===",
  [anon_sym_BANG_EQ] = "!=",
  [anon_sym_BANG_EQ_EQ] = "!==",
  [anon_sym_GT_EQ] = ">=",
  [anon_sym_QMARK_QMARK] = "\?\?",
  [anon_sym_instanceof] = "instanceof",
  [anon_sym_TILDE] = "~",
  [anon_sym_void] = "void",
  [anon_sym_delete] = "delete",
  [anon_sym_PLUS_PLUS] = "++",
  [anon_sym_DASH_DASH] = "--",
  [anon_sym_DQUOTE] = "\"",
  [anon_sym_SQUOTE] = "'",
  [sym_unescaped_double_string_fragment] = "string_fragment",
  [sym_unescaped_single_string_fragment] = "string_fragment",
  [sym_escape_sequence] = "escape_sequence",
  [sym_comment] = "comment",
  [anon_sym_BQUOTE] = "`",
  [anon_sym_DOLLAR_LBRACE] = "${",
  [anon_sym_SLASH2] = "/",
  [sym_regex_pattern] = "regex_pattern",
  [sym_regex_flags] = "regex_flags",
  [sym_number] = "number",
  [sym_private_property_identifier] = "private_property_identifier",
  [anon_sym_target] = "target",
  [sym_this] = "this",
  [sym_super] = "super",
  [sym_true] = "true",
  [sym_false] = "false",
  [sym_null] = "null",
  [sym_undefined] = "undefined",
  [anon_sym_AT] = "@",
  [anon_sym_static] = "static",
  [anon_sym_readonly] = "readonly",
  [anon_sym_get] = "get",
  [anon_sym_set] = "set",
  [anon_sym_QMARK] = "\?",
  [anon_sym_declare] = "declare",
  [anon_sym_public] = "public",
  [anon_sym_private] = "private",
  [anon_sym_protected] = "protected",
  [anon_sym_override] = "override",
  [anon_sym_module] = "module",
  [anon_sym_any] = "any",
  [anon_sym_number] = "number",
  [anon_sym_boolean] = "boolean",
  [anon_sym_string] = "string",
  [anon_sym_symbol] = "symbol",
  [anon_sym_abstract] = "abstract",
  [anon_sym_require] = "require",
  [anon_sym_extends] = "extends",
  [anon_sym_implements] = "implements",
  [anon_sym_global] = "global",
  [anon_sym_interface] = "interface",
  [anon_sym_enum] = "enum",
  [anon_sym_DASH_QMARK_COLON] = "-\?:",
  [anon_sym_QMARK_COLON] = "\?:",
  [anon_sym_asserts] = "asserts",
  [anon_sym_infer] = "infer",
  [anon_sym_is] = "is",
  [anon_sym_keyof] = "keyof",
  [anon_sym_unknown] = "unknown",
  [anon_sym_never] = "never",
  [anon_sym_object] = "object",
  [anon_sym_LBRACE_PIPE] = "{|",
  [anon_sym_PIPE_RBRACE] = "|}",
  [sym__automatic_semicolon] = "_automatic_semicolon",
  [sym__template_chars] = "_template_chars",
  [sym__ternary_qmark] = "\?",
  [sym__function_signature_automatic_semicolon] = "_function_signature_automatic_semicolon",
  [sym_program] = "program",
  [sym_export_statement] = "export_statement",
  [sym_export_clause] = "export_clause",
  [sym__import_export_specifier] = "export_specifier",
  [sym_declaration] = "declaration",
  [sym_import] = "import",
  [sym_import_statement] = "import_statement",
  [sym_import_clause] = "import_clause",
  [sym__from_clause] = "_from_clause",
  [sym_namespace_import_export] = "namespace_import",
  [sym_named_imports] = "named_imports",
  [sym_expression_statement] = "expression_statement",
  [sym_variable_declaration] = "variable_declaration",
  [sym_lexical_declaration] = "lexical_declaration",
  [sym_variable_declarator] = "variable_declarator",
  [sym_statement_block] = "statement_block",
  [sym_else_clause] = "else_clause",
  [sym_if_statement] = "if_statement",
  [sym_switch_statement] = "switch_statement",
  [sym_for_statement] = "for_statement",
  [sym_for_in_statement] = "for_in_statement",
  [sym__for_header] = "_for_header",
  [sym_while_statement] = "while_statement",
  [sym_do_statement] = "do_statement",
  [sym_try_statement] = "try_statement",
  [sym_with_statement] = "with_statement",
  [sym_break_statement] = "break_statement",
  [sym_continue_statement] = "continue_statement",
  [sym_debugger_statement] = "debugger_statement",
  [sym_return_statement] = "return_statement",
  [sym_throw_statement] = "throw_statement",
  [sym_empty_statement] = "empty_statement",
  [sym_labeled_statement] = "labeled_statement",
  [sym_switch_body] = "switch_body",
  [sym_switch_case] = "switch_case",
  [sym_switch_default] = "switch_default",
  [sym_catch_clause] = "catch_clause",
  [sym_finally_clause] = "finally_clause",
  [sym_parenthesized_expression] = "parenthesized_expression",
  [sym_expression] = "expression",
  [sym_primary_expression] = "primary_expression",
  [sym_yield_expression] = "yield_expression",
  [sym_object] = "object",
  [sym_object_pattern] = "object_pattern",
  [sym_assignment_pattern] = "assignment_pattern",
  [sym_object_assignment_pattern] = "object_assignment_pattern",
  [sym_array] = "array",
  [sym_array_pattern] = "array_pattern",
  [sym_nested_identifier] = "nested_identifier",
  [sym_class] = "class",
  [sym_class_declaration] = "class_declaration",
  [sym_class_heritage] = "class_heritage",
  [sym_function] = "function",
  [sym_function_declaration] = "function_declaration",
  [sym_generator_function] = "generator_function",
  [sym_generator_function_declaration] = "generator_function_declaration",
  [sym_arrow_function] = "arrow_function",
  [sym__call_signature] = "_call_signature",
  [sym__formal_parameter] = "_formal_parameter",
  [sym_call_expression] = "call_expression",
  [sym_new_expression] = "new_expression",
  [sym_await_expression] = "await_expression",
  [sym_member_expression] = "member_expression",
  [sym_subscript_expression] = "subscript_expression",
  [sym_assignment_expression] = "assignment_expression",
  [sym__augmented_assignment_lhs] = "_augmented_assignment_lhs",
  [sym_augmented_assignment_expression] = "augmented_assignment_expression",
  [sym__initializer] = "_initializer",
  [sym__destructuring_pattern] = "_destructuring_pattern",
  [sym_spread_element] = "spread_element",
  [sym_ternary_expression] = "ternary_expression",
  [sym_binary_expression] = "binary_expression",
  [sym_unary_expression] = "unary_expression",
  [sym_update_expression] = "update_expression",
  [sym_sequence_expression] = "sequence_expression",
  [sym_string] = "string",
  [sym_template_string] = "template_string",
  [sym_template_substitution] = "template_substitution",
  [sym_regex] = "regex",
  [sym_meta_property] = "meta_property",
  [sym_arguments] = "arguments",
  [sym_decorator] = "decorator",
  [sym_decorator_member_expression] = "member_expression",
  [sym_decorator_call_expression] = "call_expression",
  [sym_class_body] = "class_body",
  [sym_formal_parameters] = "formal_parameters",
  [sym_pattern] = "pattern",
  [sym_rest_pattern] = "rest_pattern",
  [sym_method_definition] = "method_definition",
  [sym_pair] = "pair",
  [sym_pair_pattern] = "pair_pattern",
  [sym__property_name] = "_property_name",
  [sym_computed_property_name] = "computed_property_name",
  [sym_public_field_definition] = "public_field_definition",
  [sym_non_null_expression] = "non_null_expression",
  [sym_method_signature] = "method_signature",
  [sym_abstract_method_signature] = "abstract_method_signature",
  [sym_function_signature] = "function_signature",
  [sym_type_assertion] = "type_assertion",
  [sym_as_expression] = "as_expression",
  [sym_import_require_clause] = "import_require_clause",
  [sym_extends_clause] = "extends_clause",
  [sym_implements_clause] = "implements_clause",
  [sym_ambient_declaration] = "ambient_declaration",
  [sym_abstract_class_declaration] = "abstract_class_declaration",
  [sym_module] = "module",
  [sym_internal_module] = "internal_module",
  [sym__module] = "_module",
  [sym_import_alias] = "import_alias",
  [sym_nested_type_identifier] = "nested_type_identifier",
  [sym_interface_declaration] = "interface_declaration",
  [sym_extends_type_clause] = "extends_type_clause",
  [sym_enum_declaration] = "enum_declaration",
  [sym_enum_body] = "enum_body",
  [sym_enum_assignment] = "enum_assignment",
  [sym_type_alias_declaration] = "type_alias_declaration",
  [sym_accessibility_modifier] = "accessibility_modifier",
  [sym_override_modifier] = "override_modifier",
  [sym_required_parameter] = "required_parameter",
  [sym_optional_parameter] = "optional_parameter",
  [sym__parameter_name] = "_parameter_name",
  [sym_omitting_type_annotation] = "omitting_type_annotation",
  [sym_opting_type_annotation] = "opting_type_annotation",
  [sym_type_annotation] = "type_annotation",
  [sym_asserts] = "asserts",
  [sym__type] = "_type",
  [sym_tuple_parameter] = "required_parameter",
  [sym_optional_tuple_parameter] = "optional_parameter",
  [sym_optional_type] = "optional_type",
  [sym_rest_type] = "rest_type",
  [sym__tuple_type_member] = "_tuple_type_member",
  [sym_constructor_type] = "constructor_type",
  [sym__primary_type] = "_primary_type",
  [sym_template_type] = "template_type",
  [sym_template_literal_type] = "template_literal_type",
  [sym_infer_type] = "infer_type",
  [sym_conditional_type] = "conditional_type",
  [sym_generic_type] = "generic_type",
  [sym_type_predicate] = "type_predicate",
  [sym_type_predicate_annotation] = "type_predicate_annotation",
  [sym__type_query_member_expression] = "member_expression",
  [sym__type_query_subscript_expression] = "subscript_expression",
  [sym__type_query_call_expression] = "call_expression",
  [sym_type_query] = "type_query",
  [sym_index_type_query] = "index_type_query",
  [sym_lookup_type] = "lookup_type",
  [sym_mapped_type_clause] = "mapped_type_clause",
  [sym_literal_type] = "literal_type",
  [sym__number] = "unary_expression",
  [sym_existential_type] = "existential_type",
  [sym_flow_maybe_type] = "flow_maybe_type",
  [sym_parenthesized_type] = "parenthesized_type",
  [sym_predefined_type] = "predefined_type",
  [sym_type_arguments] = "type_arguments",
  [sym_object_type] = "object_type",
  [sym_call_signature] = "call_signature",
  [sym_property_signature] = "property_signature",
  [sym_type_parameters] = "type_parameters",
  [sym_type_parameter] = "type_parameter",
  [sym_default_type] = "default_type",
  [sym_constraint] = "constraint",
  [sym_construct_signature] = "construct_signature",
  [sym_index_signature] = "index_signature",
  [sym_array_type] = "array_type",
  [sym_tuple_type] = "tuple_type",
  [sym_readonly_type] = "readonly_type",
  [sym_union_type] = "union_type",
  [sym_intersection_type] = "intersection_type",
  [sym_function_type] = "function_type",
  [aux_sym_program_repeat1] = "program_repeat1",
  [aux_sym_export_statement_repeat1] = "export_statement_repeat1",
  [aux_sym_export_clause_repeat1] = "export_clause_repeat1",
  [aux_sym_named_imports_repeat1] = "named_imports_repeat1",
  [aux_sym_variable_declaration_repeat1] = "variable_declaration_repeat1",
  [aux_sym_switch_body_repeat1] = "switch_body_repeat1",
  [aux_sym_object_repeat1] = "object_repeat1",
  [aux_sym_object_pattern_repeat1] = "object_pattern_repeat1",
  [aux_sym_array_repeat1] = "array_repeat1",
  [aux_sym_array_pattern_repeat1] = "array_pattern_repeat1",
  [aux_sym_string_repeat1] = "string_repeat1",
  [aux_sym_string_repeat2] = "string_repeat2",
  [aux_sym_template_string_repeat1] = "template_string_repeat1",
  [aux_sym_class_body_repeat1] = "class_body_repeat1",
  [aux_sym_formal_parameters_repeat1] = "formal_parameters_repeat1",
  [aux_sym_extends_clause_repeat1] = "extends_clause_repeat1",
  [aux_sym_implements_clause_repeat1] = "implements_clause_repeat1",
  [aux_sym_extends_type_clause_repeat1] = "extends_type_clause_repeat1",
  [aux_sym_enum_body_repeat1] = "enum_body_repeat1",
  [aux_sym_template_literal_type_repeat1] = "template_literal_type_repeat1",
  [aux_sym_object_type_repeat1] = "object_type_repeat1",
  [aux_sym_type_parameters_repeat1] = "type_parameters_repeat1",
  [aux_sym_tuple_type_repeat1] = "tuple_type_repeat1",
  [alias_sym_import_specifier] = "import_specifier",
  [alias_sym_namespace_export] = "namespace_export",
  [alias_sym_property_identifier] = "property_identifier",
  [alias_sym_shorthand_property_identifier] = "shorthand_property_identifier",
  [alias_sym_shorthand_property_identifier_pattern] = "shorthand_property_identifier_pattern",
  [alias_sym_statement_identifier] = "statement_identifier",
  [alias_sym_this_type] = "this_type",
  [alias_sym_type_identifier] = "type_identifier",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym_identifier] = sym_identifier,
  [sym_hash_bang_line] = sym_hash_bang_line,
  [anon_sym_export] = anon_sym_export,
  [anon_sym_STAR] = anon_sym_STAR,
  [anon_sym_default] = anon_sym_default,
  [anon_sym_type] = anon_sym_type,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_as] = anon_sym_as,
  [anon_sym_namespace] = anon_sym_namespace,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_typeof] = anon_sym_typeof,
  [anon_sym_import] = anon_sym_import,
  [anon_sym_from] = anon_sym_from,
  [anon_sym_var] = anon_sym_var,
  [anon_sym_let] = anon_sym_let,
  [anon_sym_const] = anon_sym_const,
  [anon_sym_BANG] = anon_sym_BANG,
  [anon_sym_else] = anon_sym_else,
  [anon_sym_if] = anon_sym_if,
  [anon_sym_switch] = anon_sym_switch,
  [anon_sym_for] = anon_sym_for,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_await] = anon_sym_await,
  [anon_sym_in] = anon_sym_in,
  [anon_sym_of] = anon_sym_of,
  [anon_sym_while] = anon_sym_while,
  [anon_sym_do] = anon_sym_do,
  [anon_sym_try] = anon_sym_try,
  [anon_sym_with] = anon_sym_with,
  [anon_sym_break] = anon_sym_break,
  [anon_sym_continue] = anon_sym_continue,
  [anon_sym_debugger] = anon_sym_debugger,
  [anon_sym_return] = anon_sym_return,
  [anon_sym_throw] = anon_sym_throw,
  [anon_sym_SEMI] = anon_sym_SEMI,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_case] = anon_sym_case,
  [anon_sym_catch] = anon_sym_catch,
  [anon_sym_finally] = anon_sym_finally,
  [anon_sym_yield] = anon_sym_yield,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_GT] = anon_sym_GT,
  [anon_sym_SLASH] = anon_sym_SLASH,
  [anon_sym_DOT] = anon_sym_DOT,
  [anon_sym_class] = anon_sym_class,
  [anon_sym_async] = anon_sym_async,
  [anon_sym_function] = anon_sym_function,
  [anon_sym_EQ_GT] = anon_sym_EQ_GT,
  [anon_sym_QMARK_DOT] = anon_sym_QMARK_DOT,
  [anon_sym_new] = anon_sym_new,
  [anon_sym_PLUS_EQ] = anon_sym_PLUS_EQ,
  [anon_sym_DASH_EQ] = anon_sym_DASH_EQ,
  [anon_sym_STAR_EQ] = anon_sym_STAR_EQ,
  [anon_sym_SLASH_EQ] = anon_sym_SLASH_EQ,
  [anon_sym_PERCENT_EQ] = anon_sym_PERCENT_EQ,
  [anon_sym_CARET_EQ] = anon_sym_CARET_EQ,
  [anon_sym_AMP_EQ] = anon_sym_AMP_EQ,
  [anon_sym_PIPE_EQ] = anon_sym_PIPE_EQ,
  [anon_sym_GT_GT_EQ] = anon_sym_GT_GT_EQ,
  [anon_sym_GT_GT_GT_EQ] = anon_sym_GT_GT_GT_EQ,
  [anon_sym_LT_LT_EQ] = anon_sym_LT_LT_EQ,
  [anon_sym_STAR_STAR_EQ] = anon_sym_STAR_STAR_EQ,
  [anon_sym_AMP_AMP_EQ] = anon_sym_AMP_AMP_EQ,
  [anon_sym_PIPE_PIPE_EQ] = anon_sym_PIPE_PIPE_EQ,
  [anon_sym_QMARK_QMARK_EQ] = anon_sym_QMARK_QMARK_EQ,
  [anon_sym_DOT_DOT_DOT] = anon_sym_DOT_DOT_DOT,
  [anon_sym_AMP_AMP] = anon_sym_AMP_AMP,
  [anon_sym_PIPE_PIPE] = anon_sym_PIPE_PIPE,
  [anon_sym_GT_GT] = anon_sym_GT_GT,
  [anon_sym_GT_GT_GT] = anon_sym_GT_GT_GT,
  [anon_sym_LT_LT] = anon_sym_LT_LT,
  [anon_sym_AMP] = anon_sym_AMP,
  [anon_sym_CARET] = anon_sym_CARET,
  [anon_sym_PIPE] = anon_sym_PIPE,
  [anon_sym_PLUS] = anon_sym_PLUS,
  [anon_sym_DASH] = anon_sym_DASH,
  [anon_sym_PERCENT] = anon_sym_PERCENT,
  [anon_sym_STAR_STAR] = anon_sym_STAR_STAR,
  [anon_sym_LT_EQ] = anon_sym_LT_EQ,
  [anon_sym_EQ_EQ] = anon_sym_EQ_EQ,
  [anon_sym_EQ_EQ_EQ] = anon_sym_EQ_EQ_EQ,
  [anon_sym_BANG_EQ] = anon_sym_BANG_EQ,
  [anon_sym_BANG_EQ_EQ] = anon_sym_BANG_EQ_EQ,
  [anon_sym_GT_EQ] = anon_sym_GT_EQ,
  [anon_sym_QMARK_QMARK] = anon_sym_QMARK_QMARK,
  [anon_sym_instanceof] = anon_sym_instanceof,
  [anon_sym_TILDE] = anon_sym_TILDE,
  [anon_sym_void] = anon_sym_void,
  [anon_sym_delete] = anon_sym_delete,
  [anon_sym_PLUS_PLUS] = anon_sym_PLUS_PLUS,
  [anon_sym_DASH_DASH] = anon_sym_DASH_DASH,
  [anon_sym_DQUOTE] = anon_sym_DQUOTE,
  [anon_sym_SQUOTE] = anon_sym_SQUOTE,
  [sym_unescaped_double_string_fragment] = sym_unescaped_double_string_fragment,
  [sym_unescaped_single_string_fragment] = sym_unescaped_double_string_fragment,
  [sym_escape_sequence] = sym_escape_sequence,
  [sym_comment] = sym_comment,
  [anon_sym_BQUOTE] = anon_sym_BQUOTE,
  [anon_sym_DOLLAR_LBRACE] = anon_sym_DOLLAR_LBRACE,
  [anon_sym_SLASH2] = anon_sym_SLASH,
  [sym_regex_pattern] = sym_regex_pattern,
  [sym_regex_flags] = sym_regex_flags,
  [sym_number] = sym_number,
  [sym_private_property_identifier] = sym_private_property_identifier,
  [anon_sym_target] = anon_sym_target,
  [sym_this] = sym_this,
  [sym_super] = sym_super,
  [sym_true] = sym_true,
  [sym_false] = sym_false,
  [sym_null] = sym_null,
  [sym_undefined] = sym_undefined,
  [anon_sym_AT] = anon_sym_AT,
  [anon_sym_static] = anon_sym_static,
  [anon_sym_readonly] = anon_sym_readonly,
  [anon_sym_get] = anon_sym_get,
  [anon_sym_set] = anon_sym_set,
  [anon_sym_QMARK] = anon_sym_QMARK,
  [anon_sym_declare] = anon_sym_declare,
  [anon_sym_public] = anon_sym_public,
  [anon_sym_private] = anon_sym_private,
  [anon_sym_protected] = anon_sym_protected,
  [anon_sym_override] = anon_sym_override,
  [anon_sym_module] = anon_sym_module,
  [anon_sym_any] = anon_sym_any,
  [anon_sym_number] = anon_sym_number,
  [anon_sym_boolean] = anon_sym_boolean,
  [anon_sym_string] = anon_sym_string,
  [anon_sym_symbol] = anon_sym_symbol,
  [anon_sym_abstract] = anon_sym_abstract,
  [anon_sym_require] = anon_sym_require,
  [anon_sym_extends] = anon_sym_extends,
  [anon_sym_implements] = anon_sym_implements,
  [anon_sym_global] = anon_sym_global,
  [anon_sym_interface] = anon_sym_interface,
  [anon_sym_enum] = anon_sym_enum,
  [anon_sym_DASH_QMARK_COLON] = anon_sym_DASH_QMARK_COLON,
  [anon_sym_QMARK_COLON] = anon_sym_QMARK_COLON,
  [anon_sym_asserts] = anon_sym_asserts,
  [anon_sym_infer] = anon_sym_infer,
  [anon_sym_is] = anon_sym_is,
  [anon_sym_keyof] = anon_sym_keyof,
  [anon_sym_unknown] = anon_sym_unknown,
  [anon_sym_never] = anon_sym_never,
  [anon_sym_object] = anon_sym_object,
  [anon_sym_LBRACE_PIPE] = anon_sym_LBRACE_PIPE,
  [anon_sym_PIPE_RBRACE] = anon_sym_PIPE_RBRACE,
  [sym__automatic_semicolon] = sym__automatic_semicolon,
  [sym__template_chars] = sym__template_chars,
  [sym__ternary_qmark] = anon_sym_QMARK,
  [sym__function_signature_automatic_semicolon] = sym__function_signature_automatic_semicolon,
  [sym_program] = sym_program,
  [sym_export_statement] = sym_export_statement,
  [sym_export_clause] = sym_export_clause,
  [sym__import_export_specifier] = sym__import_export_specifier,
  [sym_declaration] = sym_declaration,
  [sym_import] = sym_import,
  [sym_import_statement] = sym_import_statement,
  [sym_import_clause] = sym_import_clause,
  [sym__from_clause] = sym__from_clause,
  [sym_namespace_import_export] = sym_namespace_import_export,
  [sym_named_imports] = sym_named_imports,
  [sym_expression_statement] = sym_expression_statement,
  [sym_variable_declaration] = sym_variable_declaration,
  [sym_lexical_declaration] = sym_lexical_declaration,
  [sym_variable_declarator] = sym_variable_declarator,
  [sym_statement_block] = sym_statement_block,
  [sym_else_clause] = sym_else_clause,
  [sym_if_statement] = sym_if_statement,
  [sym_switch_statement] = sym_switch_statement,
  [sym_for_statement] = sym_for_statement,
  [sym_for_in_statement] = sym_for_in_statement,
  [sym__for_header] = sym__for_header,
  [sym_while_statement] = sym_while_statement,
  [sym_do_statement] = sym_do_statement,
  [sym_try_statement] = sym_try_statement,
  [sym_with_statement] = sym_with_statement,
  [sym_break_statement] = sym_break_statement,
  [sym_continue_statement] = sym_continue_statement,
  [sym_debugger_statement] = sym_debugger_statement,
  [sym_return_statement] = sym_return_statement,
  [sym_throw_statement] = sym_throw_statement,
  [sym_empty_statement] = sym_empty_statement,
  [sym_labeled_statement] = sym_labeled_statement,
  [sym_switch_body] = sym_switch_body,
  [sym_switch_case] = sym_switch_case,
  [sym_switch_default] = sym_switch_default,
  [sym_catch_clause] = sym_catch_clause,
  [sym_finally_clause] = sym_finally_clause,
  [sym_parenthesized_expression] = sym_parenthesized_expression,
  [sym_expression] = sym_expression,
  [sym_primary_expression] = sym_primary_expression,
  [sym_yield_expression] = sym_yield_expression,
  [sym_object] = sym_object,
  [sym_object_pattern] = sym_object_pattern,
  [sym_assignment_pattern] = sym_assignment_pattern,
  [sym_object_assignment_pattern] = sym_object_assignment_pattern,
  [sym_array] = sym_array,
  [sym_array_pattern] = sym_array_pattern,
  [sym_nested_identifier] = sym_nested_identifier,
  [sym_class] = sym_class,
  [sym_class_declaration] = sym_class_declaration,
  [sym_class_heritage] = sym_class_heritage,
  [sym_function] = sym_function,
  [sym_function_declaration] = sym_function_declaration,
  [sym_generator_function] = sym_generator_function,
  [sym_generator_function_declaration] = sym_generator_function_declaration,
  [sym_arrow_function] = sym_arrow_function,
  [sym__call_signature] = sym__call_signature,
  [sym__formal_parameter] = sym__formal_parameter,
  [sym_call_expression] = sym_call_expression,
  [sym_new_expression] = sym_new_expression,
  [sym_await_expression] = sym_await_expression,
  [sym_member_expression] = sym_member_expression,
  [sym_subscript_expression] = sym_subscript_expression,
  [sym_assignment_expression] = sym_assignment_expression,
  [sym__augmented_assignment_lhs] = sym__augmented_assignment_lhs,
  [sym_augmented_assignment_expression] = sym_augmented_assignment_expression,
  [sym__initializer] = sym__initializer,
  [sym__destructuring_pattern] = sym__destructuring_pattern,
  [sym_spread_element] = sym_spread_element,
  [sym_ternary_expression] = sym_ternary_expression,
  [sym_binary_expression] = sym_binary_expression,
  [sym_unary_expression] = sym_unary_expression,
  [sym_update_expression] = sym_update_expression,
  [sym_sequence_expression] = sym_sequence_expression,
  [sym_string] = sym_string,
  [sym_template_string] = sym_template_string,
  [sym_template_substitution] = sym_template_substitution,
  [sym_regex] = sym_regex,
  [sym_meta_property] = sym_meta_property,
  [sym_arguments] = sym_arguments,
  [sym_decorator] = sym_decorator,
  [sym_decorator_member_expression] = sym_member_expression,
  [sym_decorator_call_expression] = sym_call_expression,
  [sym_class_body] = sym_class_body,
  [sym_formal_parameters] = sym_formal_parameters,
  [sym_pattern] = sym_pattern,
  [sym_rest_pattern] = sym_rest_pattern,
  [sym_method_definition] = sym_method_definition,
  [sym_pair] = sym_pair,
  [sym_pair_pattern] = sym_pair_pattern,
  [sym__property_name] = sym__property_name,
  [sym_computed_property_name] = sym_computed_property_name,
  [sym_public_field_definition] = sym_public_field_definition,
  [sym_non_null_expression] = sym_non_null_expression,
  [sym_method_signature] = sym_method_signature,
  [sym_abstract_method_signature] = sym_abstract_method_signature,
  [sym_function_signature] = sym_function_signature,
  [sym_type_assertion] = sym_type_assertion,
  [sym_as_expression] = sym_as_expression,
  [sym_import_require_clause] = sym_import_require_clause,
  [sym_extends_clause] = sym_extends_clause,
  [sym_implements_clause] = sym_implements_clause,
  [sym_ambient_declaration] = sym_ambient_declaration,
  [sym_abstract_class_declaration] = sym_abstract_class_declaration,
  [sym_module] = sym_module,
  [sym_internal_module] = sym_internal_module,
  [sym__module] = sym__module,
  [sym_import_alias] = sym_import_alias,
  [sym_nested_type_identifier] = sym_nested_type_identifier,
  [sym_interface_declaration] = sym_interface_declaration,
  [sym_extends_type_clause] = sym_extends_type_clause,
  [sym_enum_declaration] = sym_enum_declaration,
  [sym_enum_body] = sym_enum_body,
  [sym_enum_assignment] = sym_enum_assignment,
  [sym_type_alias_declaration] = sym_type_alias_declaration,
  [sym_accessibility_modifier] = sym_accessibility_modifier,
  [sym_override_modifier] = sym_override_modifier,
  [sym_required_parameter] = sym_required_parameter,
  [sym_optional_parameter] = sym_optional_parameter,
  [sym__parameter_name] = sym__parameter_name,
  [sym_omitting_type_annotation] = sym_omitting_type_annotation,
  [sym_opting_type_annotation] = sym_opting_type_annotation,
  [sym_type_annotation] = sym_type_annotation,
  [sym_asserts] = sym_asserts,
  [sym__type] = sym__type,
  [sym_tuple_parameter] = sym_required_parameter,
  [sym_optional_tuple_parameter] = sym_optional_parameter,
  [sym_optional_type] = sym_optional_type,
  [sym_rest_type] = sym_rest_type,
  [sym__tuple_type_member] = sym__tuple_type_member,
  [sym_constructor_type] = sym_constructor_type,
  [sym__primary_type] = sym__primary_type,
  [sym_template_type] = sym_template_type,
  [sym_template_literal_type] = sym_template_literal_type,
  [sym_infer_type] = sym_infer_type,
  [sym_conditional_type] = sym_conditional_type,
  [sym_generic_type] = sym_generic_type,
  [sym_type_predicate] = sym_type_predicate,
  [sym_type_predicate_annotation] = sym_type_predicate_annotation,
  [sym__type_query_member_expression] = sym_member_expression,
  [sym__type_query_subscript_expression] = sym_subscript_expression,
  [sym__type_query_call_expression] = sym_call_expression,
  [sym_type_query] = sym_type_query,
  [sym_index_type_query] = sym_index_type_query,
  [sym_lookup_type] = sym_lookup_type,
  [sym_mapped_type_clause] = sym_mapped_type_clause,
  [sym_literal_type] = sym_literal_type,
  [sym__number] = sym_unary_expression,
  [sym_existential_type] = sym_existential_type,
  [sym_flow_maybe_type] = sym_flow_maybe_type,
  [sym_parenthesized_type] = sym_parenthesized_type,
  [sym_predefined_type] = sym_predefined_type,
  [sym_type_arguments] = sym_type_arguments,
  [sym_object_type] = sym_object_type,
  [sym_call_signature] = sym_call_signature,
  [sym_property_signature] = sym_property_signature,
  [sym_type_parameters] = sym_type_parameters,
  [sym_type_parameter] = sym_type_parameter,
  [sym_default_type] = sym_default_type,
  [sym_constraint] = sym_constraint,
  [sym_construct_signature] = sym_construct_signature,
  [sym_index_signature] = sym_index_signature,
  [sym_array_type] = sym_array_type,
  [sym_tuple_type] = sym_tuple_type,
  [sym_readonly_type] = sym_readonly_type,
  [sym_union_type] = sym_union_type,
  [sym_intersection_type] = sym_intersection_type,
  [sym_function_type] = sym_function_type,
  [aux_sym_program_repeat1] = aux_sym_program_repeat1,
  [aux_sym_export_statement_repeat1] = aux_sym_export_statement_repeat1,
  [aux_sym_export_clause_repeat1] = aux_sym_export_clause_repeat1,
  [aux_sym_named_imports_repeat1] = aux_sym_named_imports_repeat1,
  [aux_sym_variable_declaration_repeat1] = aux_sym_variable_declaration_repeat1,
  [aux_sym_switch_body_repeat1] = aux_sym_switch_body_repeat1,
  [aux_sym_object_repeat1] = aux_sym_object_repeat1,
  [aux_sym_object_pattern_repeat1] = aux_sym_object_pattern_repeat1,
  [aux_sym_array_repeat1] = aux_sym_array_repeat1,
  [aux_sym_array_pattern_repeat1] = aux_sym_array_pattern_repeat1,
  [aux_sym_string_repeat1] = aux_sym_string_repeat1,
  [aux_sym_string_repeat2] = aux_sym_string_repeat2,
  [aux_sym_template_string_repeat1] = aux_sym_template_string_repeat1,
  [aux_sym_class_body_repeat1] = aux_sym_class_body_repeat1,
  [aux_sym_formal_parameters_repeat1] = aux_sym_formal_parameters_repeat1,
  [aux_sym_extends_clause_repeat1] = aux_sym_extends_clause_repeat1,
  [aux_sym_implements_clause_repeat1] = aux_sym_implements_clause_repeat1,
  [aux_sym_extends_type_clause_repeat1] = aux_sym_extends_type_clause_repeat1,
  [aux_sym_enum_body_repeat1] = aux_sym_enum_body_repeat1,
  [aux_sym_template_literal_type_repeat1] = aux_sym_template_literal_type_repeat1,
  [aux_sym_object_type_repeat1] = aux_sym_object_type_repeat1,
  [aux_sym_type_parameters_repeat1] = aux_sym_type_parameters_repeat1,
  [aux_sym_tuple_type_repeat1] = aux_sym_tuple_type_repeat1,
  [alias_sym_import_specifier] = alias_sym_import_specifier,
  [alias_sym_namespace_export] = alias_sym_namespace_export,
  [alias_sym_property_identifier] = alias_sym_property_identifier,
  [alias_sym_shorthand_property_identifier] = alias_sym_shorthand_property_identifier,
  [alias_sym_shorthand_property_identifier_pattern] = alias_sym_shorthand_property_identifier_pattern,
  [alias_sym_statement_identifier] = alias_sym_statement_identifier,
  [alias_sym_this_type] = alias_sym_this_type,
  [alias_sym_type_identifier] = alias_sym_type_identifier,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_hash_bang_line] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_export] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_default] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_type] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_as] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_namespace] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_typeof] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_import] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_from] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_var] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_let] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_const] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_else] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_if] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_switch] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_for] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_await] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_in] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_of] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_while] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_do] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_try] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_with] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_break] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_continue] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_debugger] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_return] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_throw] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SEMI] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_case] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_catch] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_finally] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_yield] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_class] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_async] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_function] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_new] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_STAR_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_AMP_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_PIPE_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK_QMARK_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT_DOT_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK_QMARK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_instanceof] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_TILDE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_void] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_delete] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SQUOTE] = {
    .visible = true,
    .named = false,
  },
  [sym_unescaped_double_string_fragment] = {
    .visible = true,
    .named = true,
  },
  [sym_unescaped_single_string_fragment] = {
    .visible = true,
    .named = true,
  },
  [sym_escape_sequence] = {
    .visible = true,
    .named = true,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_BQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOLLAR_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH2] = {
    .visible = true,
    .named = false,
  },
  [sym_regex_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_regex_flags] = {
    .visible = true,
    .named = true,
  },
  [sym_number] = {
    .visible = true,
    .named = true,
  },
  [sym_private_property_identifier] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_target] = {
    .visible = true,
    .named = false,
  },
  [sym_this] = {
    .visible = true,
    .named = true,
  },
  [sym_super] = {
    .visible = true,
    .named = true,
  },
  [sym_true] = {
    .visible = true,
    .named = true,
  },
  [sym_false] = {
    .visible = true,
    .named = true,
  },
  [sym_null] = {
    .visible = true,
    .named = true,
  },
  [sym_undefined] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_AT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_static] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_readonly] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_get] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_set] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_declare] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_public] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_private] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_protected] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_override] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_module] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_any] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_number] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_boolean] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_string] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_symbol] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_abstract] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_require] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_extends] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_implements] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_global] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_interface] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_enum] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_QMARK_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_asserts] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_infer] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_is] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_keyof] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_unknown] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_never] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_object] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [sym__automatic_semicolon] = {
    .visible = false,
    .named = true,
  },
  [sym__template_chars] = {
    .visible = false,
    .named = true,
  },
  [sym__ternary_qmark] = {
    .visible = true,
    .named = false,
  },
  [sym__function_signature_automatic_semicolon] = {
    .visible = false,
    .named = true,
  },
  [sym_program] = {
    .visible = true,
    .named = true,
  },
  [sym_export_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_export_clause] = {
    .visible = true,
    .named = true,
  },
  [sym__import_export_specifier] = {
    .visible = true,
    .named = true,
  },
  [sym_declaration] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_import] = {
    .visible = true,
    .named = true,
  },
  [sym_import_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_import_clause] = {
    .visible = true,
    .named = true,
  },
  [sym__from_clause] = {
    .visible = false,
    .named = true,
  },
  [sym_namespace_import_export] = {
    .visible = true,
    .named = true,
  },
  [sym_named_imports] = {
    .visible = true,
    .named = true,
  },
  [sym_expression_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_variable_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_lexical_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_variable_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_statement_block] = {
    .visible = true,
    .named = true,
  },
  [sym_else_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_if_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_switch_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_for_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_for_in_statement] = {
    .visible = true,
    .named = true,
  },
  [sym__for_header] = {
    .visible = false,
    .named = true,
  },
  [sym_while_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_do_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_try_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_with_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_break_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_continue_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_debugger_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_return_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_throw_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_empty_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_labeled_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_switch_body] = {
    .visible = true,
    .named = true,
  },
  [sym_switch_case] = {
    .visible = true,
    .named = true,
  },
  [sym_switch_default] = {
    .visible = true,
    .named = true,
  },
  [sym_catch_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_finally_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_parenthesized_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_expression] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_primary_expression] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_yield_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_object] = {
    .visible = true,
    .named = true,
  },
  [sym_object_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_assignment_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_object_assignment_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_array] = {
    .visible = true,
    .named = true,
  },
  [sym_array_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_nested_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_class] = {
    .visible = true,
    .named = true,
  },
  [sym_class_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_class_heritage] = {
    .visible = true,
    .named = true,
  },
  [sym_function] = {
    .visible = true,
    .named = true,
  },
  [sym_function_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_generator_function] = {
    .visible = true,
    .named = true,
  },
  [sym_generator_function_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_arrow_function] = {
    .visible = true,
    .named = true,
  },
  [sym__call_signature] = {
    .visible = false,
    .named = true,
  },
  [sym__formal_parameter] = {
    .visible = false,
    .named = true,
  },
  [sym_call_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_new_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_await_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_member_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_subscript_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_assignment_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__augmented_assignment_lhs] = {
    .visible = false,
    .named = true,
  },
  [sym_augmented_assignment_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__initializer] = {
    .visible = false,
    .named = true,
  },
  [sym__destructuring_pattern] = {
    .visible = false,
    .named = true,
  },
  [sym_spread_element] = {
    .visible = true,
    .named = true,
  },
  [sym_ternary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_binary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_unary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_update_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_sequence_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_string] = {
    .visible = true,
    .named = true,
  },
  [sym_template_string] = {
    .visible = true,
    .named = true,
  },
  [sym_template_substitution] = {
    .visible = true,
    .named = true,
  },
  [sym_regex] = {
    .visible = true,
    .named = true,
  },
  [sym_meta_property] = {
    .visible = true,
    .named = true,
  },
  [sym_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym_decorator] = {
    .visible = true,
    .named = true,
  },
  [sym_decorator_member_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_decorator_call_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_class_body] = {
    .visible = true,
    .named = true,
  },
  [sym_formal_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym_pattern] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_rest_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_method_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_pair] = {
    .visible = true,
    .named = true,
  },
  [sym_pair_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym__property_name] = {
    .visible = false,
    .named = true,
  },
  [sym_computed_property_name] = {
    .visible = true,
    .named = true,
  },
  [sym_public_field_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_non_null_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_method_signature] = {
    .visible = true,
    .named = true,
  },
  [sym_abstract_method_signature] = {
    .visible = true,
    .named = true,
  },
  [sym_function_signature] = {
    .visible = true,
    .named = true,
  },
  [sym_type_assertion] = {
    .visible = true,
    .named = true,
  },
  [sym_as_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_import_require_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_extends_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_implements_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_ambient_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_abstract_class_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_module] = {
    .visible = true,
    .named = true,
  },
  [sym_internal_module] = {
    .visible = true,
    .named = true,
  },
  [sym__module] = {
    .visible = false,
    .named = true,
  },
  [sym_import_alias] = {
    .visible = true,
    .named = true,
  },
  [sym_nested_type_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_interface_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_extends_type_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_enum_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_enum_body] = {
    .visible = true,
    .named = true,
  },
  [sym_enum_assignment] = {
    .visible = true,
    .named = true,
  },
  [sym_type_alias_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_accessibility_modifier] = {
    .visible = true,
    .named = true,
  },
  [sym_override_modifier] = {
    .visible = true,
    .named = true,
  },
  [sym_required_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_optional_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym__parameter_name] = {
    .visible = false,
    .named = true,
  },
  [sym_omitting_type_annotation] = {
    .visible = true,
    .named = true,
  },
  [sym_opting_type_annotation] = {
    .visible = true,
    .named = true,
  },
  [sym_type_annotation] = {
    .visible = true,
    .named = true,
  },
  [sym_asserts] = {
    .visible = true,
    .named = true,
  },
  [sym__type] = {
    .visible = false,
    .named = true,
  },
  [sym_tuple_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_optional_tuple_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_optional_type] = {
    .visible = true,
    .named = true,
  },
  [sym_rest_type] = {
    .visible = true,
    .named = true,
  },
  [sym__tuple_type_member] = {
    .visible = false,
    .named = true,
  },
  [sym_constructor_type] = {
    .visible = true,
    .named = true,
  },
  [sym__primary_type] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_template_type] = {
    .visible = true,
    .named = true,
  },
  [sym_template_literal_type] = {
    .visible = true,
    .named = true,
  },
  [sym_infer_type] = {
    .visible = true,
    .named = true,
  },
  [sym_conditional_type] = {
    .visible = true,
    .named = true,
  },
  [sym_generic_type] = {
    .visible = true,
    .named = true,
  },
  [sym_type_predicate] = {
    .visible = true,
    .named = true,
  },
  [sym_type_predicate_annotation] = {
    .visible = true,
    .named = true,
  },
  [sym__type_query_member_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__type_query_subscript_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__type_query_call_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_type_query] = {
    .visible = true,
    .named = true,
  },
  [sym_index_type_query] = {
    .visible = true,
    .named = true,
  },
  [sym_lookup_type] = {
    .visible = true,
    .named = true,
  },
  [sym_mapped_type_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_literal_type] = {
    .visible = true,
    .named = true,
  },
  [sym__number] = {
    .visible = true,
    .named = true,
  },
  [sym_existential_type] = {
    .visible = true,
    .named = true,
  },
  [sym_flow_maybe_type] = {
    .visible = true,
    .named = true,
  },
  [sym_parenthesized_type] = {
    .visible = true,
    .named = true,
  },
  [sym_predefined_type] = {
    .visible = true,
    .named = true,
  },
  [sym_type_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym_object_type] = {
    .visible = true,
    .named = true,
  },
  [sym_call_signature] = {
    .visible = true,
    .named = true,
  },
  [sym_property_signature] = {
    .visible = true,
    .named = true,
  },
  [sym_type_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym_type_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_default_type] = {
    .visible = true,
    .named = true,
  },
  [sym_constraint] = {
    .visible = true,
    .named = true,
  },
  [sym_construct_signature] = {
    .visible = true,
    .named = true,
  },
  [sym_index_signature] = {
    .visible = true,
    .named = true,
  },
  [sym_array_type] = {
    .visible = true,
    .named = true,
  },
  [sym_tuple_type] = {
    .visible = true,
    .named = true,
  },
  [sym_readonly_type] = {
    .visible = true,
    .named = true,
  },
  [sym_union_type] = {
    .visible = true,
    .named = true,
  },
  [sym_intersection_type] = {
    .visible = true,
    .named = true,
  },
  [sym_function_type] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_program_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_export_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_export_clause_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_named_imports_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_variable_declaration_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_switch_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_object_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_object_pattern_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_array_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_array_pattern_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_string_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_template_string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_class_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_formal_parameters_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_extends_clause_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_implements_clause_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_extends_type_clause_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_enum_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_template_literal_type_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_object_type_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_type_parameters_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_tuple_type_repeat1] = {
    .visible = false,
    .named = false,
  },
  [alias_sym_import_specifier] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_namespace_export] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_property_identifier] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_shorthand_property_identifier] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_shorthand_property_identifier_pattern] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_statement_identifier] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_this_type] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_type_identifier] = {
    .visible = true,
    .named = true,
  },
};

enum {
  field_alias = 1,
  field_alternative = 2,
  field_argument = 3,
  field_arguments = 4,
  field_body = 5,
  field_condition = 6,
  field_consequence = 7,
  field_constraint = 8,
  field_constructor = 9,
  field_declaration = 10,
  field_decorator = 11,
  field_finalizer = 12,
  field_flags = 13,
  field_function = 14,
  field_handler = 15,
  field_increment = 16,
  field_index = 17,
  field_index_type = 18,
  field_initializer = 19,
  field_key = 20,
  field_kind = 21,
  field_label = 22,
  field_left = 23,
  field_module = 24,
  field_name = 25,
  field_object = 26,
  field_operator = 27,
  field_parameter = 28,
  field_parameters = 29,
  field_pattern = 30,
  field_property = 31,
  field_return_type = 32,
  field_right = 33,
  field_sign = 34,
  field_source = 35,
  field_type = 36,
  field_type_arguments = 37,
  field_type_parameters = 38,
  field_value = 39,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_alias] = "alias",
  [field_alternative] = "alternative",
  [field_argument] = "argument",
  [field_arguments] = "arguments",
  [field_body] = "body",
  [field_condition] = "condition",
  [field_consequence] = "consequence",
  [field_constraint] = "constraint",
  [field_constructor] = "constructor",
  [field_declaration] = "declaration",
  [field_decorator] = "decorator",
  [field_finalizer] = "finalizer",
  [field_flags] = "flags",
  [field_function] = "function",
  [field_handler] = "handler",
  [field_increment] = "increment",
  [field_index] = "index",
  [field_index_type] = "index_type",
  [field_initializer] = "initializer",
  [field_key] = "key",
  [field_kind] = "kind",
  [field_label] = "label",
  [field_left] = "left",
  [field_module] = "module",
  [field_name] = "name",
  [field_object] = "object",
  [field_operator] = "operator",
  [field_parameter] = "parameter",
  [field_parameters] = "parameters",
  [field_pattern] = "pattern",
  [field_property] = "property",
  [field_return_type] = "return_type",
  [field_right] = "right",
  [field_sign] = "sign",
  [field_source] = "source",
  [field_type] = "type",
  [field_type_arguments] = "type_arguments",
  [field_type_parameters] = "type_parameters",
  [field_value] = "value",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [2] = {.index = 0, .length = 1},
  [3] = {.index = 1, .length = 1},
  [4] = {.index = 2, .length = 1},
  [5] = {.index = 3, .length = 1},
  [6] = {.index = 4, .length = 2},
  [8] = {.index = 6, .length = 2},
  [9] = {.index = 8, .length = 1},
  [10] = {.index = 9, .length = 2},
  [11] = {.index = 11, .length = 1},
  [13] = {.index = 3, .length = 1},
  [15] = {.index = 12, .length = 2},
  [16] = {.index = 14, .length = 1},
  [17] = {.index = 15, .length = 2},
  [18] = {.index = 17, .length = 2},
  [19] = {.index = 19, .length = 2},
  [20] = {.index = 21, .length = 2},
  [21] = {.index = 23, .length = 2},
  [22] = {.index = 25, .length = 1},
  [23] = {.index = 26, .length = 2},
  [24] = {.index = 28, .length = 2},
  [25] = {.index = 30, .length = 2},
  [26] = {.index = 32, .length = 2},
  [30] = {.index = 34, .length = 1},
  [31] = {.index = 35, .length = 2},
  [32] = {.index = 37, .length = 2},
  [33] = {.index = 39, .length = 1},
  [34] = {.index = 40, .length = 2},
  [35] = {.index = 42, .length = 2},
  [36] = {.index = 44, .length = 6},
  [37] = {.index = 50, .length = 1},
  [38] = {.index = 51, .length = 3},
  [39] = {.index = 54, .length = 3},
  [40] = {.index = 57, .length = 2},
  [41] = {.index = 59, .length = 2},
  [42] = {.index = 61, .length = 2},
  [43] = {.index = 63, .length = 2},
  [44] = {.index = 65, .length = 2},
  [45] = {.index = 67, .length = 1},
  [46] = {.index = 68, .length = 3},
  [47] = {.index = 71, .length = 2},
  [48] = {.index = 73, .length = 2},
  [49] = {.index = 75, .length = 2},
  [50] = {.index = 77, .length = 2},
  [51] = {.index = 79, .length = 2},
  [52] = {.index = 81, .length = 2},
  [54] = {.index = 77, .length = 2},
  [55] = {.index = 83, .length = 2},
  [56] = {.index = 85, .length = 1},
  [57] = {.index = 86, .length = 1},
  [58] = {.index = 87, .length = 2},
  [59] = {.index = 89, .length = 4},
  [60] = {.index = 93, .length = 2},
  [61] = {.index = 95, .length = 2},
  [62] = {.index = 26, .length = 2},
  [63] = {.index = 30, .length = 2},
  [64] = {.index = 83, .length = 2},
  [65] = {.index = 97, .length = 3},
  [66] = {.index = 100, .length = 2},
  [67] = {.index = 100, .length = 2},
  [68] = {.index = 102, .length = 3},
  [69] = {.index = 105, .length = 2},
  [70] = {.index = 107, .length = 4},
  [71] = {.index = 111, .length = 3},
  [72] = {.index = 114, .length = 2},
  [73] = {.index = 116, .length = 2},
  [74] = {.index = 118, .length = 1},
  [75] = {.index = 119, .length = 1},
  [76] = {.index = 120, .length = 1},
  [77] = {.index = 121, .length = 2},
  [78] = {.index = 118, .length = 1},
  [79] = {.index = 26, .length = 2},
  [80] = {.index = 123, .length = 2},
  [81] = {.index = 125, .length = 5},
  [82] = {.index = 130, .length = 1},
  [83] = {.index = 121, .length = 2},
  [84] = {.index = 131, .length = 2},
  [85] = {.index = 133, .length = 3},
  [86] = {.index = 136, .length = 2},
  [87] = {.index = 138, .length = 3},
  [88] = {.index = 141, .length = 6},
  [89] = {.index = 147, .length = 1},
  [90] = {.index = 148, .length = 1},
  [91] = {.index = 149, .length = 3},
  [92] = {.index = 152, .length = 3},
  [93] = {.index = 155, .length = 4},
  [94] = {.index = 159, .length = 2},
  [95] = {.index = 161, .length = 3},
  [96] = {.index = 164, .length = 1},
  [97] = {.index = 165, .length = 4},
  [98] = {.index = 169, .length = 4},
  [99] = {.index = 173, .length = 4},
  [100] = {.index = 177, .length = 2},
  [101] = {.index = 179, .length = 3},
  [102] = {.index = 182, .length = 2},
  [103] = {.index = 184, .length = 2},
  [104] = {.index = 186, .length = 2},
  [105] = {.index = 188, .length = 3},
  [106] = {.index = 191, .length = 2},
  [107] = {.index = 193, .length = 3},
  [108] = {.index = 196, .length = 2},
  [109] = {.index = 198, .length = 2},
  [110] = {.index = 200, .length = 4},
  [111] = {.index = 198, .length = 2},
  [112] = {.index = 204, .length = 4},
  [113] = {.index = 208, .length = 4},
  [114] = {.index = 212, .length = 5},
  [115] = {.index = 217, .length = 3},
  [116] = {.index = 136, .length = 2},
  [117] = {.index = 220, .length = 1},
  [118] = {.index = 220, .length = 1},
  [119] = {.index = 221, .length = 2},
  [120] = {.index = 223, .length = 3},
  [121] = {.index = 226, .length = 2},
  [122] = {.index = 228, .length = 3},
  [123] = {.index = 231, .length = 2},
  [124] = {.index = 233, .length = 3},
  [125] = {.index = 236, .length = 1},
  [126] = {.index = 237, .length = 2},
  [127] = {.index = 239, .length = 2},
  [128] = {.index = 241, .length = 5},
  [129] = {.index = 246, .length = 1},
  [130] = {.index = 247, .length = 4},
  [131] = {.index = 251, .length = 2},
  [132] = {.index = 253, .length = 2},
  [133] = {.index = 255, .length = 2},
  [134] = {.index = 257, .length = 2},
  [135] = {.index = 259, .length = 1},
  [136] = {.index = 260, .length = 2},
  [137] = {.index = 262, .length = 1},
  [138] = {.index = 263, .length = 4},
  [139] = {.index = 267, .length = 4},
  [140] = {.index = 267, .length = 4},
  [141] = {.index = 271, .length = 4},
  [142] = {.index = 271, .length = 4},
  [143] = {.index = 275, .length = 4},
  [144] = {.index = 275, .length = 4},
  [145] = {.index = 279, .length = 2},
  [146] = {.index = 281, .length = 3},
  [147] = {.index = 284, .length = 2},
  [148] = {.index = 286, .length = 2},
  [149] = {.index = 288, .length = 3},
  [150] = {.index = 291, .length = 4},
  [151] = {.index = 295, .length = 4},
  [152] = {.index = 299, .length = 4},
  [153] = {.index = 303, .length = 4},
  [154] = {.index = 307, .length = 5},
  [155] = {.index = 312, .length = 2},
  [156] = {.index = 314, .length = 3},
  [157] = {.index = 317, .length = 2},
  [158] = {.index = 317, .length = 2},
  [159] = {.index = 319, .length = 3},
  [160] = {.index = 322, .length = 2},
  [161] = {.index = 131, .length = 2},
  [162] = {.index = 324, .length = 2},
  [163] = {.index = 326, .length = 3},
  [164] = {.index = 329, .length = 4},
  [165] = {.index = 333, .length = 3},
  [166] = {.index = 336, .length = 3},
  [167] = {.index = 339, .length = 2},
  [168] = {.index = 341, .length = 3},
  [169] = {.index = 344, .length = 5},
  [170] = {.index = 349, .length = 3},
  [171] = {.index = 349, .length = 3},
  [172] = {.index = 352, .length = 3},
  [173] = {.index = 355, .length = 2},
  [174] = {.index = 357, .length = 4},
  [175] = {.index = 131, .length = 2},
  [176] = {.index = 361, .length = 1},
  [177] = {.index = 362, .length = 3},
  [178] = {.index = 365, .length = 2},
  [179] = {.index = 367, .length = 2},
  [180] = {.index = 369, .length = 1},
  [181] = {.index = 370, .length = 2},
  [182] = {.index = 372, .length = 2},
  [183] = {.index = 374, .length = 4},
  [184] = {.index = 378, .length = 4},
  [185] = {.index = 382, .length = 4},
  [186] = {.index = 386, .length = 3},
  [187] = {.index = 389, .length = 2},
  [188] = {.index = 391, .length = 2},
  [189] = {.index = 393, .length = 2},
  [190] = {.index = 395, .length = 3},
  [191] = {.index = 398, .length = 3},
  [192] = {.index = 401, .length = 5},
  [193] = {.index = 406, .length = 3},
  [194] = {.index = 409, .length = 2},
  [195] = {.index = 411, .length = 2},
  [196] = {.index = 413, .length = 2},
  [197] = {.index = 415, .length = 1},
  [198] = {.index = 416, .length = 4},
  [199] = {.index = 420, .length = 3},
  [200] = {.index = 423, .length = 4},
  [201] = {.index = 427, .length = 5},
  [202] = {.index = 432, .length = 1},
  [203] = {.index = 433, .length = 2},
  [204] = {.index = 435, .length = 4},
  [205] = {.index = 439, .length = 4},
  [206] = {.index = 443, .length = 2},
  [207] = {.index = 445, .length = 4},
  [208] = {.index = 449, .length = 4},
  [209] = {.index = 453, .length = 2},
  [210] = {.index = 455, .length = 2},
  [211] = {.index = 457, .length = 1},
  [212] = {.index = 458, .length = 3},
  [213] = {.index = 461, .length = 1},
  [214] = {.index = 462, .length = 4},
  [215] = {.index = 466, .length = 4},
  [216] = {.index = 470, .length = 4},
  [217] = {.index = 474, .length = 3},
  [218] = {.index = 477, .length = 2},
  [219] = {.index = 479, .length = 3},
  [220] = {.index = 482, .length = 3},
  [221] = {.index = 485, .length = 2},
  [223] = {.index = 487, .length = 4},
  [224] = {.index = 491, .length = 5},
  [225] = {.index = 496, .length = 5},
  [226] = {.index = 501, .length = 5},
  [227] = {.index = 506, .length = 3},
  [228] = {.index = 509, .length = 3},
  [229] = {.index = 512, .length = 3},
  [230] = {.index = 509, .length = 3},
  [231] = {.index = 515, .length = 2},
  [232] = {.index = 517, .length = 4},
  [233] = {.index = 521, .length = 4},
  [234] = {.index = 525, .length = 2},
  [235] = {.index = 527, .length = 2},
  [236] = {.index = 529, .length = 4},
  [237] = {.index = 533, .length = 3},
  [238] = {.index = 536, .length = 2},
  [239] = {.index = 538, .length = 3},
  [240] = {.index = 541, .length = 2},
  [241] = {.index = 543, .length = 1},
  [242] = {.index = 544, .length = 5},
  [243] = {.index = 549, .length = 5},
  [244] = {.index = 554, .length = 4},
  [245] = {.index = 558, .length = 4},
  [246] = {.index = 562, .length = 3},
  [247] = {.index = 562, .length = 3},
  [248] = {.index = 565, .length = 2},
  [249] = {.index = 567, .length = 3},
  [250] = {.index = 570, .length = 2},
  [251] = {.index = 572, .length = 3},
  [252] = {.index = 575, .length = 2},
  [253] = {.index = 577, .length = 2},
  [254] = {.index = 579, .length = 5},
  [255] = {.index = 584, .length = 5},
  [256] = {.index = 589, .length = 4},
  [257] = {.index = 589, .length = 4},
  [258] = {.index = 593, .length = 4},
  [259] = {.index = 597, .length = 4},
  [260] = {.index = 601, .length = 3},
  [261] = {.index = 604, .length = 2},
  [262] = {.index = 606, .length = 2},
  [263] = {.index = 608, .length = 3},
  [264] = {.index = 611, .length = 5},
  [265] = {.index = 616, .length = 4},
  [266] = {.index = 620, .length = 3},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_decorator, 0},
  [1] =
    {field_parameters, 0},
  [2] =
    {field_declaration, 1},
  [3] =
    {field_name, 0},
  [4] =
    {field_body, 1, .inherited = true},
    {field_name, 1, .inherited = true},
  [6] =
    {field_argument, 1},
    {field_operator, 0},
  [8] =
    {field_pattern, 0},
  [9] =
    {field_decorator, 0, .inherited = true},
    {field_pattern, 0, .inherited = true},
  [11] =
    {field_body, 1},
  [12] =
    {field_argument, 0, .inherited = true},
    {field_operator, 0, .inherited = true},
  [14] =
    {field_constructor, 1},
  [15] =
    {field_argument, 0},
    {field_operator, 1},
  [17] =
    {field_arguments, 1},
    {field_function, 0},
  [19] =
    {field_parameters, 0},
    {field_return_type, 1},
  [21] =
    {field_parameters, 1},
    {field_type_parameters, 0},
  [23] =
    {field_decorator, 0, .inherited = true},
    {field_decorator, 1, .inherited = true},
  [25] =
    {field_declaration, 2},
  [26] =
    {field_left, 0},
    {field_right, 2},
  [28] =
    {field_body, 2},
    {field_label, 0},
  [30] =
    {field_body, 2},
    {field_parameter, 0},
  [32] =
    {field_body, 1},
    {field_name, 0},
  [34] =
    {field_source, 1},
  [35] =
    {field_name, 0},
    {field_value, 1, .inherited = true},
  [37] =
    {field_name, 0},
    {field_type, 1},
  [39] =
    {field_kind, 0},
  [40] =
    {field_condition, 1},
    {field_consequence, 2},
  [42] =
    {field_body, 2},
    {field_value, 1},
  [44] =
    {field_body, 2},
    {field_kind, 1, .inherited = true},
    {field_left, 1, .inherited = true},
    {field_operator, 1, .inherited = true},
    {field_right, 1, .inherited = true},
    {field_value, 1, .inherited = true},
  [50] =
    {field_pattern, 1},
  [51] =
    {field_decorator, 0, .inherited = true},
    {field_pattern, 0, .inherited = true},
    {field_value, 1, .inherited = true},
  [54] =
    {field_decorator, 0, .inherited = true},
    {field_pattern, 0, .inherited = true},
    {field_type, 1},
  [57] =
    {field_decorator, 0, .inherited = true},
    {field_pattern, 1},
  [59] =
    {field_body, 2},
    {field_condition, 1},
  [61] =
    {field_body, 1},
    {field_handler, 2},
  [63] =
    {field_body, 1},
    {field_finalizer, 2},
  [65] =
    {field_body, 2},
    {field_object, 1},
  [67] =
    {field_label, 1},
  [68] =
    {field_parameters, 0, .inherited = true},
    {field_return_type, 0, .inherited = true},
    {field_type_parameters, 0, .inherited = true},
  [71] =
    {field_object, 1, .inherited = true},
    {field_property, 1, .inherited = true},
  [73] =
    {field_index, 1, .inherited = true},
    {field_object, 1, .inherited = true},
  [75] =
    {field_arguments, 1, .inherited = true},
    {field_function, 1, .inherited = true},
  [77] =
    {field_name, 0},
    {field_type_arguments, 1},
  [79] =
    {field_name, 0},
    {field_value, 1},
  [81] =
    {field_constraint, 1},
    {field_name, 0},
  [83] =
    {field_body, 2},
    {field_name, 1},
  [85] =
    {field_value, 1},
  [86] =
    {field_body, 2},
  [87] =
    {field_body, 2},
    {field_type_parameters, 1},
  [89] =
    {field_body, 2},
    {field_parameters, 1, .inherited = true},
    {field_return_type, 1, .inherited = true},
    {field_type_parameters, 1, .inherited = true},
  [93] =
    {field_arguments, 2},
    {field_constructor, 1},
  [95] =
    {field_constructor, 1},
    {field_type_arguments, 2},
  [97] =
    {field_left, 0},
    {field_operator, 1},
    {field_right, 2},
  [100] =
    {field_object, 0},
    {field_property, 2},
  [102] =
    {field_arguments, 2},
    {field_function, 0},
    {field_type_arguments, 1},
  [105] =
    {field_arguments, 2},
    {field_function, 0},
  [107] =
    {field_body, 2},
    {field_parameters, 0, .inherited = true},
    {field_return_type, 0, .inherited = true},
    {field_type_parameters, 0, .inherited = true},
  [111] =
    {field_parameters, 1},
    {field_return_type, 2},
    {field_type_parameters, 0},
  [114] =
    {field_declaration, 2},
    {field_decorator, 0, .inherited = true},
  [116] =
    {field_body, 2},
    {field_decorator, 0, .inherited = true},
  [118] =
    {field_source, 2, .inherited = true},
  [119] =
    {field_value, 2},
  [120] =
    {field_name, 1},
  [121] =
    {field_alias, 1, .inherited = true},
    {field_name, 1, .inherited = true},
  [123] =
    {field_key, 0},
    {field_value, 2},
  [125] =
    {field_body, 2},
    {field_name, 0},
    {field_parameters, 1, .inherited = true},
    {field_return_type, 1, .inherited = true},
    {field_type_parameters, 1, .inherited = true},
  [130] =
    {field_source, 2},
  [131] =
    {field_name, 0},
    {field_type, 2},
  [133] =
    {field_name, 0},
    {field_type, 1},
    {field_value, 2, .inherited = true},
  [136] =
    {field_body, 3},
    {field_name, 2},
  [138] =
    {field_alternative, 3},
    {field_condition, 1},
    {field_consequence, 2},
  [141] =
    {field_body, 3},
    {field_kind, 2, .inherited = true},
    {field_left, 2, .inherited = true},
    {field_operator, 2, .inherited = true},
    {field_right, 2, .inherited = true},
    {field_value, 2, .inherited = true},
  [147] =
    {field_type, 2},
  [148] =
    {field_pattern, 2},
  [149] =
    {field_decorator, 0, .inherited = true},
    {field_pattern, 0, .inherited = true},
    {field_value, 2, .inherited = true},
  [152] =
    {field_decorator, 0, .inherited = true},
    {field_pattern, 0, .inherited = true},
    {field_type, 2},
  [155] =
    {field_decorator, 0, .inherited = true},
    {field_pattern, 0, .inherited = true},
    {field_type, 1},
    {field_value, 2, .inherited = true},
  [159] =
    {field_decorator, 0, .inherited = true},
    {field_pattern, 2},
  [161] =
    {field_body, 1},
    {field_finalizer, 3},
    {field_handler, 2},
  [164] =
    {field_parameters, 1},
  [165] =
    {field_name, 0},
    {field_parameters, 1, .inherited = true},
    {field_return_type, 1, .inherited = true},
    {field_type_parameters, 1, .inherited = true},
  [169] =
    {field_arguments, 1},
    {field_function, 0},
    {field_object, 0, .inherited = true},
    {field_property, 0, .inherited = true},
  [173] =
    {field_arguments, 1},
    {field_function, 0},
    {field_index, 0, .inherited = true},
    {field_object, 0, .inherited = true},
  [177] =
    {field_module, 0},
    {field_name, 2},
  [179] =
    {field_constraint, 1},
    {field_name, 0},
    {field_value, 2},
  [182] =
    {field_parameters, 0},
    {field_return_type, 2},
  [184] =
    {field_flags, 3},
    {field_pattern, 1},
  [186] =
    {field_body, 3},
    {field_name, 1},
  [188] =
    {field_body, 3},
    {field_name, 1},
    {field_type_parameters, 2},
  [191] =
    {field_type_arguments, 2},
    {field_value, 1},
  [193] =
    {field_type_arguments, 2, .inherited = true},
    {field_value, 1},
    {field_value, 2, .inherited = true},
  [196] =
    {field_body, 3},
    {field_type_parameters, 1},
  [198] =
    {field_body, 3},
    {field_parameter, 1},
  [200] =
    {field_body, 3},
    {field_parameters, 2, .inherited = true},
    {field_return_type, 2, .inherited = true},
    {field_type_parameters, 2, .inherited = true},
  [204] =
    {field_body, 3},
    {field_parameters, 1, .inherited = true},
    {field_return_type, 1, .inherited = true},
    {field_type_parameters, 1, .inherited = true},
  [208] =
    {field_name, 1},
    {field_parameters, 2, .inherited = true},
    {field_return_type, 2, .inherited = true},
    {field_type_parameters, 2, .inherited = true},
  [212] =
    {field_body, 3},
    {field_name, 1},
    {field_parameters, 2, .inherited = true},
    {field_return_type, 2, .inherited = true},
    {field_type_parameters, 2, .inherited = true},
  [217] =
    {field_arguments, 3},
    {field_constructor, 1},
    {field_type_arguments, 2},
  [220] =
    {field_type, 1},
  [221] =
    {field_index, 2},
    {field_object, 0},
  [223] =
    {field_arguments, 3},
    {field_function, 0},
    {field_type_arguments, 2},
  [226] =
    {field_declaration, 3},
    {field_decorator, 0, .inherited = true},
  [228] =
    {field_body, 3},
    {field_decorator, 0, .inherited = true},
    {field_name, 2},
  [231] =
    {field_body, 3},
    {field_decorator, 0, .inherited = true},
  [233] =
    {field_body, 3},
    {field_decorator, 0, .inherited = true},
    {field_type_parameters, 2},
  [236] =
    {field_source, 3, .inherited = true},
  [237] =
    {field_alias, 2},
    {field_name, 0},
  [239] =
    {field_name, 1},
    {field_value, 3},
  [241] =
    {field_body, 3},
    {field_name, 0},
    {field_parameters, 2, .inherited = true},
    {field_return_type, 2, .inherited = true},
    {field_type_parameters, 2, .inherited = true},
  [246] =
    {field_pattern, 3},
  [247] =
    {field_decorator, 0, .inherited = true},
    {field_pattern, 0, .inherited = true},
    {field_type, 2},
    {field_value, 3, .inherited = true},
  [251] =
    {field_decorator, 0, .inherited = true},
    {field_pattern, 3},
  [253] =
    {field_body, 1},
    {field_condition, 3},
  [255] =
    {field_parameters, 1},
    {field_type, 2},
  [257] =
    {field_parameters, 2},
    {field_type_parameters, 1},
  [259] =
    {field_name, 2},
  [260] =
    {field_name, 1},
    {field_type, 2},
  [262] =
    {field_parameters, 2},
  [263] =
    {field_name, 0},
    {field_parameters, 2, .inherited = true},
    {field_return_type, 2, .inherited = true},
    {field_type_parameters, 2, .inherited = true},
  [267] =
    {field_object, 0},
    {field_object, 0, .inherited = true},
    {field_property, 0, .inherited = true},
    {field_property, 2},
  [271] =
    {field_index, 0, .inherited = true},
    {field_object, 0},
    {field_object, 0, .inherited = true},
    {field_property, 2},
  [275] =
    {field_arguments, 0, .inherited = true},
    {field_function, 0, .inherited = true},
    {field_object, 0},
    {field_property, 2},
  [279] =
    {field_parameters, 1},
    {field_type, 3},
  [281] =
    {field_parameters, 1},
    {field_return_type, 3},
    {field_type_parameters, 0},
  [284] =
    {field_name, 1},
    {field_value, 2, .inherited = true},
  [286] =
    {field_name, 0},
    {field_value, 2, .inherited = true},
  [288] =
    {field_body, 4},
    {field_name, 1},
    {field_type_parameters, 2},
  [291] =
    {field_type_arguments, 2},
    {field_type_arguments, 3, .inherited = true},
    {field_value, 1},
    {field_value, 3, .inherited = true},
  [295] =
    {field_type_arguments, 0, .inherited = true},
    {field_type_arguments, 1, .inherited = true},
    {field_value, 0, .inherited = true},
    {field_value, 1, .inherited = true},
  [299] =
    {field_body, 4},
    {field_parameters, 3, .inherited = true},
    {field_return_type, 3, .inherited = true},
    {field_type_parameters, 3, .inherited = true},
  [303] =
    {field_name, 2},
    {field_parameters, 3, .inherited = true},
    {field_return_type, 3, .inherited = true},
    {field_type_parameters, 3, .inherited = true},
  [307] =
    {field_body, 4},
    {field_name, 2},
    {field_parameters, 3, .inherited = true},
    {field_return_type, 3, .inherited = true},
    {field_type_parameters, 3, .inherited = true},
  [312] =
    {field_body, 4},
    {field_name, 2},
  [314] =
    {field_body, 4},
    {field_name, 2},
    {field_type_parameters, 3},
  [317] =
    {field_type, 1},
    {field_type, 2, .inherited = true},
  [319] =
    {field_alternative, 4},
    {field_condition, 0},
    {field_consequence, 2},
  [322] =
    {field_index, 3},
    {field_object, 0},
  [324] =
    {field_decorator, 0, .inherited = true},
    {field_value, 3},
  [326] =
    {field_body, 4},
    {field_decorator, 0, .inherited = true},
    {field_name, 2},
  [329] =
    {field_body, 4},
    {field_decorator, 0, .inherited = true},
    {field_name, 2},
    {field_type_parameters, 3},
  [333] =
    {field_body, 4},
    {field_decorator, 0, .inherited = true},
    {field_type_parameters, 2},
  [336] =
    {field_body, 4},
    {field_decorator, 0, .inherited = true},
    {field_name, 3},
  [339] =
    {field_alias, 3},
    {field_name, 1},
  [341] =
    {field_name, 1},
    {field_type_parameters, 2},
    {field_value, 4},
  [344] =
    {field_body, 4},
    {field_name, 1},
    {field_parameters, 3, .inherited = true},
    {field_return_type, 3, .inherited = true},
    {field_type_parameters, 3, .inherited = true},
  [349] =
    {field_left, 1},
    {field_operator, 2},
    {field_right, 3},
  [352] =
    {field_body, 5},
    {field_condition, 3},
    {field_initializer, 2},
  [355] =
    {field_decorator, 0, .inherited = true},
    {field_pattern, 4},
  [357] =
    {field_name, 1},
    {field_parameters, 3, .inherited = true},
    {field_return_type, 3, .inherited = true},
    {field_type_parameters, 3, .inherited = true},
  [361] =
    {field_type, 3},
  [362] =
    {field_parameters, 2},
    {field_type, 3},
    {field_type_parameters, 1},
  [365] =
    {field_name, 2},
    {field_type, 3},
  [367] =
    {field_name, 1},
    {field_type, 3},
  [369] =
    {field_name, 3},
  [370] =
    {field_parameters, 2},
    {field_type, 3},
  [372] =
    {field_parameters, 3},
    {field_type_parameters, 2},
  [374] =
    {field_index, 2},
    {field_object, 0},
    {field_object, 0, .inherited = true},
    {field_property, 0, .inherited = true},
  [378] =
    {field_index, 0, .inherited = true},
    {field_index, 2},
    {field_object, 0},
    {field_object, 0, .inherited = true},
  [382] =
    {field_arguments, 0, .inherited = true},
    {field_function, 0, .inherited = true},
    {field_index, 2},
    {field_object, 0},
  [386] =
    {field_parameters, 2},
    {field_type, 4},
    {field_type_parameters, 1},
  [389] =
    {field_parameters, 2},
    {field_type, 4},
  [391] =
    {field_name, 2},
    {field_value, 3, .inherited = true},
  [393] =
    {field_name, 1},
    {field_value, 3, .inherited = true},
  [395] =
    {field_name, 1},
    {field_type, 2},
    {field_value, 3, .inherited = true},
  [398] =
    {field_name, 0},
    {field_type, 2},
    {field_value, 3, .inherited = true},
  [401] =
    {field_body, 5},
    {field_name, 3},
    {field_parameters, 4, .inherited = true},
    {field_return_type, 4, .inherited = true},
    {field_type_parameters, 4, .inherited = true},
  [406] =
    {field_body, 5},
    {field_name, 2},
    {field_type_parameters, 3},
  [409] =
    {field_type, 0, .inherited = true},
    {field_type, 1, .inherited = true},
  [411] =
    {field_name, 1},
    {field_name, 2, .inherited = true},
  [413] =
    {field_name, 0, .inherited = true},
    {field_name, 1, .inherited = true},
  [415] =
    {field_name, 2, .inherited = true},
  [416] =
    {field_body, 5},
    {field_decorator, 0, .inherited = true},
    {field_name, 2},
    {field_type_parameters, 3},
  [420] =
    {field_body, 5},
    {field_decorator, 0, .inherited = true},
    {field_name, 3},
  [423] =
    {field_body, 5},
    {field_decorator, 0, .inherited = true},
    {field_name, 3},
    {field_type_parameters, 4},
  [427] =
    {field_body, 5},
    {field_name, 2},
    {field_parameters, 4, .inherited = true},
    {field_return_type, 4, .inherited = true},
    {field_type_parameters, 4, .inherited = true},
  [432] =
    {field_source, 4},
  [433] =
    {field_body, 3},
    {field_value, 1},
  [435] =
    {field_kind, 1},
    {field_left, 2},
    {field_operator, 3},
    {field_right, 4},
  [439] =
    {field_body, 6},
    {field_condition, 3},
    {field_increment, 4},
    {field_initializer, 2},
  [443] =
    {field_body, 4},
    {field_parameter, 2},
  [445] =
    {field_name, 2},
    {field_parameters, 4, .inherited = true},
    {field_return_type, 4, .inherited = true},
    {field_type_parameters, 4, .inherited = true},
  [449] =
    {field_name, 3},
    {field_parameters, 4, .inherited = true},
    {field_return_type, 4, .inherited = true},
    {field_type_parameters, 4, .inherited = true},
  [453] =
    {field_name, 2},
    {field_type, 4},
  [455] =
    {field_name, 3},
    {field_type, 4},
  [457] =
    {field_type, 4},
  [458] =
    {field_parameters, 3},
    {field_type, 4},
    {field_type_parameters, 2},
  [461] =
    {field_name, 4},
  [462] =
    {field_index, 3},
    {field_object, 0},
    {field_object, 0, .inherited = true},
    {field_property, 0, .inherited = true},
  [466] =
    {field_index, 0, .inherited = true},
    {field_index, 3},
    {field_object, 0},
    {field_object, 0, .inherited = true},
  [470] =
    {field_arguments, 0, .inherited = true},
    {field_function, 0, .inherited = true},
    {field_index, 3},
    {field_object, 0},
  [474] =
    {field_parameters, 3},
    {field_type, 5},
    {field_type_parameters, 2},
  [477] =
    {field_name, 2},
    {field_value, 4, .inherited = true},
  [479] =
    {field_name, 2},
    {field_type, 3},
    {field_value, 4, .inherited = true},
  [482] =
    {field_name, 1},
    {field_type, 3},
    {field_value, 4, .inherited = true},
  [485] =
    {field_name, 3},
    {field_value, 4, .inherited = true},
  [487] =
    {field_body, 6},
    {field_decorator, 0, .inherited = true},
    {field_name, 3},
    {field_type_parameters, 4},
  [491] =
    {field_body, 6},
    {field_name, 3},
    {field_parameters, 5, .inherited = true},
    {field_return_type, 5, .inherited = true},
    {field_type_parameters, 5, .inherited = true},
  [496] =
    {field_body, 6},
    {field_name, 4},
    {field_parameters, 5, .inherited = true},
    {field_return_type, 5, .inherited = true},
    {field_type_parameters, 5, .inherited = true},
  [501] =
    {field_kind, 1},
    {field_left, 2},
    {field_operator, 4},
    {field_right, 5},
    {field_value, 3, .inherited = true},
  [506] =
    {field_body, 5},
    {field_parameter, 2},
    {field_type, 3},
  [509] =
    {field_index_type, 3},
    {field_name, 1},
    {field_type, 5},
  [512] =
    {field_alias, 4},
    {field_name, 0},
    {field_type, 2},
  [515] =
    {field_sign, 0},
    {field_type, 5},
  [517] =
    {field_name, 3},
    {field_parameters, 5, .inherited = true},
    {field_return_type, 5, .inherited = true},
    {field_type_parameters, 5, .inherited = true},
  [521] =
    {field_name, 4},
    {field_parameters, 5, .inherited = true},
    {field_return_type, 5, .inherited = true},
    {field_type_parameters, 5, .inherited = true},
  [525] =
    {field_name, 3},
    {field_type, 5},
  [527] =
    {field_name, 4},
    {field_type, 5},
  [529] =
    {field_alternative, 6},
    {field_consequence, 4},
    {field_left, 0},
    {field_right, 2},
  [533] =
    {field_name, 2},
    {field_type, 4},
    {field_value, 5, .inherited = true},
  [536] =
    {field_name, 3},
    {field_value, 5, .inherited = true},
  [538] =
    {field_name, 3},
    {field_type, 4},
    {field_value, 5, .inherited = true},
  [541] =
    {field_name, 4},
    {field_value, 5, .inherited = true},
  [543] =
    {field_name, 5},
  [544] =
    {field_body, 7},
    {field_name, 4},
    {field_parameters, 6, .inherited = true},
    {field_return_type, 6, .inherited = true},
    {field_type_parameters, 6, .inherited = true},
  [549] =
    {field_body, 7},
    {field_name, 5},
    {field_parameters, 6, .inherited = true},
    {field_return_type, 6, .inherited = true},
    {field_type_parameters, 6, .inherited = true},
  [554] =
    {field_name, 4},
    {field_parameters, 6, .inherited = true},
    {field_return_type, 6, .inherited = true},
    {field_type_parameters, 6, .inherited = true},
  [558] =
    {field_name, 5},
    {field_parameters, 6, .inherited = true},
    {field_return_type, 6, .inherited = true},
    {field_type_parameters, 6, .inherited = true},
  [562] =
    {field_index_type, 4},
    {field_name, 2},
    {field_type, 6},
  [565] =
    {field_name, 4},
    {field_type, 6},
  [567] =
    {field_name, 3},
    {field_type, 5},
    {field_value, 6, .inherited = true},
  [570] =
    {field_name, 4},
    {field_value, 6, .inherited = true},
  [572] =
    {field_name, 4},
    {field_type, 5},
    {field_value, 6, .inherited = true},
  [575] =
    {field_name, 5},
    {field_value, 6, .inherited = true},
  [577] =
    {field_name, 5},
    {field_type, 6},
  [579] =
    {field_body, 8},
    {field_name, 5},
    {field_parameters, 7, .inherited = true},
    {field_return_type, 7, .inherited = true},
    {field_type_parameters, 7, .inherited = true},
  [584] =
    {field_body, 8},
    {field_name, 6},
    {field_parameters, 7, .inherited = true},
    {field_return_type, 7, .inherited = true},
    {field_type_parameters, 7, .inherited = true},
  [589] =
    {field_index_type, 5},
    {field_name, 3},
    {field_sign, 0},
    {field_type, 7},
  [593] =
    {field_name, 5},
    {field_parameters, 7, .inherited = true},
    {field_return_type, 7, .inherited = true},
    {field_type_parameters, 7, .inherited = true},
  [597] =
    {field_name, 6},
    {field_parameters, 7, .inherited = true},
    {field_return_type, 7, .inherited = true},
    {field_type_parameters, 7, .inherited = true},
  [601] =
    {field_name, 4},
    {field_type, 6},
    {field_value, 7, .inherited = true},
  [604] =
    {field_name, 5},
    {field_value, 7, .inherited = true},
  [606] =
    {field_name, 5},
    {field_type, 7},
  [608] =
    {field_name, 5},
    {field_type, 6},
    {field_value, 7, .inherited = true},
  [611] =
    {field_body, 9},
    {field_name, 6},
    {field_parameters, 8, .inherited = true},
    {field_return_type, 8, .inherited = true},
    {field_type_parameters, 8, .inherited = true},
  [616] =
    {field_name, 6},
    {field_parameters, 8, .inherited = true},
    {field_return_type, 8, .inherited = true},
    {field_type_parameters, 8, .inherited = true},
  [620] =
    {field_name, 5},
    {field_type, 7},
    {field_value, 8, .inherited = true},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
  [1] = {
    [0] = sym_identifier,
  },
  [7] = {
    [0] = alias_sym_property_identifier,
  },
  [12] = {
    [0] = alias_sym_type_identifier,
  },
  [13] = {
    [0] = alias_sym_type_identifier,
  },
  [14] = {
    [0] = alias_sym_this_type,
  },
  [23] = {
    [0] = sym_identifier,
  },
  [24] = {
    [0] = alias_sym_statement_identifier,
  },
  [25] = {
    [0] = sym_identifier,
  },
  [27] = {
    [1] = alias_sym_shorthand_property_identifier,
  },
  [28] = {
    [1] = alias_sym_shorthand_property_identifier_pattern,
  },
  [29] = {
    [1] = sym_identifier,
  },
  [45] = {
    [1] = alias_sym_statement_identifier,
  },
  [50] = {
    [0] = alias_sym_type_identifier,
  },
  [51] = {
    [0] = alias_sym_type_identifier,
  },
  [52] = {
    [0] = alias_sym_type_identifier,
  },
  [53] = {
    [1] = alias_sym_type_identifier,
  },
  [55] = {
    [1] = alias_sym_type_identifier,
  },
  [66] = {
    [2] = alias_sym_property_identifier,
  },
  [78] = {
    [1] = alias_sym_namespace_export,
  },
  [79] = {
    [0] = alias_sym_shorthand_property_identifier_pattern,
  },
  [83] = {
    [1] = alias_sym_import_specifier,
  },
  [100] = {
    [2] = alias_sym_type_identifier,
  },
  [101] = {
    [0] = alias_sym_type_identifier,
  },
  [104] = {
    [1] = alias_sym_type_identifier,
  },
  [105] = {
    [1] = alias_sym_type_identifier,
  },
  [109] = {
    [1] = sym_identifier,
  },
  [116] = {
    [2] = alias_sym_type_identifier,
  },
  [117] = {
    [1] = alias_sym_type_identifier,
  },
  [122] = {
    [2] = alias_sym_type_identifier,
  },
  [127] = {
    [1] = alias_sym_type_identifier,
  },
  [139] = {
    [2] = alias_sym_property_identifier,
  },
  [141] = {
    [2] = alias_sym_property_identifier,
  },
  [143] = {
    [2] = alias_sym_property_identifier,
  },
  [149] = {
    [1] = alias_sym_type_identifier,
  },
  [155] = {
    [2] = alias_sym_type_identifier,
  },
  [156] = {
    [2] = alias_sym_type_identifier,
  },
  [157] = {
    [1] = alias_sym_type_identifier,
  },
  [161] = {
    [0] = sym_identifier,
  },
  [163] = {
    [2] = alias_sym_type_identifier,
  },
  [164] = {
    [2] = alias_sym_type_identifier,
  },
  [166] = {
    [3] = alias_sym_type_identifier,
  },
  [168] = {
    [1] = alias_sym_type_identifier,
  },
  [170] = {
    [1] = sym_identifier,
  },
  [175] = {
    [0] = alias_sym_type_identifier,
  },
  [193] = {
    [2] = alias_sym_type_identifier,
  },
  [198] = {
    [2] = alias_sym_type_identifier,
  },
  [199] = {
    [3] = alias_sym_type_identifier,
  },
  [200] = {
    [3] = alias_sym_type_identifier,
  },
  [222] = {
    [3] = alias_sym_property_identifier,
  },
  [223] = {
    [3] = alias_sym_type_identifier,
  },
  [228] = {
    [1] = sym_identifier,
  },
  [229] = {
    [0] = alias_sym_type_identifier,
  },
  [246] = {
    [2] = sym_identifier,
  },
  [256] = {
    [3] = sym_identifier,
  },
};

static const uint16_t ts_non_terminal_alias_map[] = {
  sym__import_export_specifier, 2,
    sym__import_export_specifier,
    alias_sym_import_specifier,
  sym_namespace_import_export, 2,
    sym_namespace_import_export,
    alias_sym_namespace_export,
  sym_predefined_type, 2,
    sym_predefined_type,
    sym_identifier,
  0,
};

static inline bool anon_sym_BANG_character_set_1(int32_t c) {
  return (c < 8192
    ? (c < ' '
      ? (c < '\r'
        ? (c >= '\t' && c <= '\n')
        : c <= '\r')
      : (c <= ' ' || (c < 5760
        ? c == 160
        : c <= 5760)))
    : (c <= 8203 || (c < 12288
      ? (c < 8287
        ? c == 8239
        : c <= 8288)
      : (c <= 12288 || c == 65279))));
}

static inline bool sym_regex_pattern_character_set_1(int32_t c) {
  return (c < 8192
    ? (c < ' '
      ? (c < '\r'
        ? c == '\t'
        : c <= '\r')
      : (c <= ' ' || (c < 5760
        ? c == 160
        : c <= 5760)))
    : (c <= 8203 || (c < 12288
      ? (c < 8287
        ? c == 8239
        : c <= 8288)
      : (c <= 12288 || c == 65279))));
}

static inline bool sym_identifier_character_set_1(int32_t c) {
  return (c < 160
    ? (c < ':'
      ? (c < 0
        ? c == 0
        : (c <= '#' || (c >= '%' && c <= '/')))
      : (c <= '@' || (c < '`'
        ? (c >= '[' && c <= '^')
        : (c <= '`' || (c >= '{' && c <= '~')))))
    : (c <= 160 || (c < 8287
      ? (c < 8192
        ? c == 5760
        : (c <= 8203 || c == 8239))
      : (c <= 8288 || (c < 65279
        ? c == 12288
        : c <= 65279)))));
}

static inline bool sym_identifier_character_set_2(int32_t c) {
  return (c < 160
    ? (c < ':'
      ? (c < 0
        ? c == 0
        : (c <= '#' || (c >= '%' && c <= '/')))
      : (c <= '@' || (c < '`'
        ? (c >= '[' && c <= '^')
        : c <= '~')))
    : (c <= 160 || (c < 8287
      ? (c < 8192
        ? c == 5760
        : (c <= 8203 || c == 8239))
      : (c <= 8288 || (c < 65279
        ? c == 12288
        : c <= 65279)))));
}

static inline bool sym_identifier_character_set_3(int32_t c) {
  return (c < 160
    ? (c < ':'
      ? (c < 0
        ? c == 0
        : (c <= '#' || (c >= '%' && c <= '/')))
      : (c <= '@' || (c < '`'
        ? (c >= '[' && c <= '^')
        : (c <= '`' || (c >= '|' && c <= '~')))))
    : (c <= 160 || (c < 8287
      ? (c < 8192
        ? c == 5760
        : (c <= 8203 || c == 8239))
      : (c <= 8288 || (c < 65279
        ? c == 12288
        : c <= 65279)))));
}

static inline bool sym_private_property_identifier_character_set_1(int32_t c) {
  return (c < 160
    ? (c < '['
      ? (c < 0
        ? c == 0
        : (c <= '#' || (c >= '%' && c <= '@')))
      : (c <= '^' || (c < '{'
        ? c == '`'
        : c <= '~')))
    : (c <= 160 || (c < 8287
      ? (c < 8192
        ? c == 5760
        : (c <= 8203 || c == 8239))
      : (c <= 8288 || (c < 65279
        ? c == 12288
        : c <= 65279)))));
}

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(72);
      if (lookahead == '!') ADVANCE(85);
      if (lookahead == '"') ADVANCE(164);
      if (lookahead == '#') ADVANCE(6);
      if (lookahead == '$') ADVANCE(200);
      if (lookahead == '%') ADVANCE(150);
      if (lookahead == '&') ADVANCE(132);
      if (lookahead == '\'') ADVANCE(165);
      if (lookahead == '(') ADVANCE(86);
      if (lookahead == ')') ADVANCE(87);
      if (lookahead == '*') ADVANCE(75);
      if (lookahead == '+') ADVANCE(144);
      if (lookahead == ',') ADVANCE(82);
      if (lookahead == '-') ADVANCE(148);
      if (lookahead == '.') ADVANCE(101);
      if (lookahead == '/') ADVANCE(186);
      if (lookahead == '0') ADVANCE(191);
      if (lookahead == ':') ADVANCE(89);
      if (lookahead == ';') ADVANCE(88);
      if (lookahead == '<') ADVANCE(93);
      if (lookahead == '=') ADVANCE(78);
      if (lookahead == '>') ADVANCE(96);
      if (lookahead == '?') ADVANCE(206);
      if (lookahead == '@') ADVANCE(203);
      if (lookahead == '[') ADVANCE(90);
      if (lookahead == '\\') ADVANCE(29);
      if (lookahead == ']') ADVANCE(91);
      if (lookahead == '^') ADVANCE(135);
      if (lookahead == '`') ADVANCE(184);
      if (lookahead == '{') ADVANCE(81);
      if (lookahead == '|') ADVANCE(138);
      if (lookahead == '}') ADVANCE(83);
      if (lookahead == '~') ADVANCE(161);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(192);
      if (anon_sym_BANG_character_set_1(lookahead)) SKIP(69)
      if (lookahead != 0 &&
          lookahead > 31) ADVANCE(201);
      END_STATE();
    case 1:
      if (lookahead == '\n') SKIP(22)
      if (lookahead == '/') ADVANCE(16);
      if (lookahead == '[') ADVANCE(28);
      if (lookahead == '\\') ADVANCE(68);
      if (sym_regex_pattern_character_set_1(lookahead)) ADVANCE(187);
      if (lookahead != 0) ADVANCE(188);
      END_STATE();
    case 2:
      if (lookahead == '!') ADVANCE(85);
      if (lookahead == '"') ADVANCE(164);
      if (lookahead == '#') ADVANCE(27);
      if (lookahead == '%') ADVANCE(150);
      if (lookahead == '&') ADVANCE(132);
      if (lookahead == '\'') ADVANCE(165);
      if (lookahead == '(') ADVANCE(86);
      if (lookahead == ')') ADVANCE(87);
      if (lookahead == '*') ADVANCE(75);
      if (lookahead == '+') ADVANCE(144);
      if (lookahead == ',') ADVANCE(82);
      if (lookahead == '-') ADVANCE(147);
      if (lookahead == '.') ADVANCE(101);
      if (lookahead == '/') ADVANCE(99);
      if (lookahead == '0') ADVANCE(191);
      if (lookahead == ':') ADVANCE(89);
      if (lookahead == ';') ADVANCE(88);
      if (lookahead == '<') ADVANCE(93);
      if (lookahead == '=') ADVANCE(78);
      if (lookahead == '>') ADVANCE(96);
      if (lookahead == '?') ADVANCE(206);
      if (lookahead == '@') ADVANCE(203);
      if (lookahead == '[') ADVANCE(90);
      if (lookahead == '\\') ADVANCE(31);
      if (lookahead == ']') ADVANCE(91);
      if (lookahead == '^') ADVANCE(135);
      if (lookahead == '`') ADVANCE(184);
      if (lookahead == '{') ADVANCE(81);
      if (lookahead == '|') ADVANCE(138);
      if (lookahead == '}') ADVANCE(83);
      if (lookahead == '~') ADVANCE(161);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(192);
      if (anon_sym_BANG_character_set_1(lookahead)) SKIP(2)
      if (lookahead != 0 &&
          lookahead > 31) ADVANCE(201);
      END_STATE();
    case 3:
      if (lookahead == '!') ADVANCE(85);
      if (lookahead == '"') ADVANCE(164);
      if (lookahead == '%') ADVANCE(150);
      if (lookahead == '&') ADVANCE(132);
      if (lookahead == '\'') ADVANCE(165);
      if (lookahead == '(') ADVANCE(86);
      if (lookahead == ')') ADVANCE(87);
      if (lookahead == '*') ADVANCE(75);
      if (lookahead == '+') ADVANCE(144);
      if (lookahead == ',') ADVANCE(82);
      if (lookahead == '-') ADVANCE(147);
      if (lookahead == '.') ADVANCE(101);
      if (lookahead == '/') ADVANCE(99);
      if (lookahead == '0') ADVANCE(191);
      if (lookahead == ':') ADVANCE(89);
      if (lookahead == ';') ADVANCE(88);
      if (lookahead == '<') ADVANCE(93);
      if (lookahead == '=') ADVANCE(78);
      if (lookahead == '>') ADVANCE(96);
      if (lookahead == '?') ADVANCE(206);
      if (lookahead == '@') ADVANCE(203);
      if (lookahead == '[') ADVANCE(90);
      if (lookahead == '\\') ADVANCE(31);
      if (lookahead == ']') ADVANCE(91);
      if (lookahead == '^') ADVANCE(135);
      if (lookahead == '`') ADVANCE(184);
      if (lookahead == '{') ADVANCE(80);
      if (lookahead == '|') ADVANCE(137);
      if (lookahead == '}') ADVANCE(83);
      if (lookahead == '~') ADVANCE(161);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(192);
      if (anon_sym_BANG_character_set_1(lookahead)) SKIP(3)
      if (lookahead != 0 &&
          lookahead > '#') ADVANCE(201);
      END_STATE();
    case 4:
      if (lookahead == '!') ADVANCE(85);
      if (lookahead == '%') ADVANCE(149);
      if (lookahead == '&') ADVANCE(133);
      if (lookahead == '(') ADVANCE(86);
      if (lookahead == ')') ADVANCE(87);
      if (lookahead == '*') ADVANCE(76);
      if (lookahead == '+') ADVANCE(143);
      if (lookahead == ',') ADVANCE(82);
      if (lookahead == '-') ADVANCE(146);
      if (lookahead == '.') ADVANCE(100);
      if (lookahead == '/') ADVANCE(98);
      if (lookahead == ':') ADVANCE(89);
      if (lookahead == ';') ADVANCE(88);
      if (lookahead == '<') ADVANCE(94);
      if (lookahead == '=') ADVANCE(25);
      if (lookahead == '>') ADVANCE(97);
      if (lookahead == '?') ADVANCE(20);
      if (lookahead == '[') ADVANCE(90);
      if (lookahead == '\\') ADVANCE(31);
      if (lookahead == ']') ADVANCE(91);
      if (lookahead == '^') ADVANCE(134);
      if (lookahead == '`') ADVANCE(184);
      if (lookahead == '{') ADVANCE(80);
      if (lookahead == '|') ADVANCE(139);
      if (lookahead == '}') ADVANCE(83);
      if (anon_sym_BANG_character_set_1(lookahead)) SKIP(5)
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(189);
      if (lookahead != 0 &&
          lookahead > '#' &&
          (lookahead < '\'' || '@' < lookahead) &&
          lookahead != '~') ADVANCE(201);
      END_STATE();
    case 5:
      if (lookahead == '!') ADVANCE(85);
      if (lookahead == '%') ADVANCE(149);
      if (lookahead == '&') ADVANCE(133);
      if (lookahead == '(') ADVANCE(86);
      if (lookahead == ')') ADVANCE(87);
      if (lookahead == '*') ADVANCE(76);
      if (lookahead == '+') ADVANCE(143);
      if (lookahead == ',') ADVANCE(82);
      if (lookahead == '-') ADVANCE(146);
      if (lookahead == '.') ADVANCE(100);
      if (lookahead == '/') ADVANCE(98);
      if (lookahead == ':') ADVANCE(89);
      if (lookahead == ';') ADVANCE(88);
      if (lookahead == '<') ADVANCE(94);
      if (lookahead == '=') ADVANCE(25);
      if (lookahead == '>') ADVANCE(97);
      if (lookahead == '?') ADVANCE(20);
      if (lookahead == '[') ADVANCE(90);
      if (lookahead == '\\') ADVANCE(31);
      if (lookahead == ']') ADVANCE(91);
      if (lookahead == '^') ADVANCE(134);
      if (lookahead == '`') ADVANCE(184);
      if (lookahead == '{') ADVANCE(80);
      if (lookahead == '|') ADVANCE(139);
      if (lookahead == '}') ADVANCE(83);
      if (anon_sym_BANG_character_set_1(lookahead)) SKIP(5)
      if (lookahead != 0 &&
          lookahead > '#' &&
          (lookahead < '\'' || '@' < lookahead) &&
          lookahead != '~') ADVANCE(201);
      END_STATE();
    case 6:
      if (lookahead == '!') ADVANCE(73);
      if (lookahead == '\\') ADVANCE(30);
      if (!sym_private_property_identifier_character_set_1(lookahead)) ADVANCE(202);
      END_STATE();
    case 7:
      if (lookahead == '!') ADVANCE(84);
      if (lookahead == '"') ADVANCE(164);
      if (lookahead == '&') ADVANCE(131);
      if (lookahead == '\'') ADVANCE(165);
      if (lookahead == '(') ADVANCE(86);
      if (lookahead == ')') ADVANCE(87);
      if (lookahead == '*') ADVANCE(74);
      if (lookahead == '+') ADVANCE(143);
      if (lookahead == ',') ADVANCE(82);
      if (lookahead == '-') ADVANCE(146);
      if (lookahead == '.') ADVANCE(101);
      if (lookahead == '/') ADVANCE(98);
      if (lookahead == '0') ADVANCE(191);
      if (lookahead == '<') ADVANCE(92);
      if (lookahead == '?') ADVANCE(204);
      if (lookahead == '@') ADVANCE(203);
      if (lookahead == '[') ADVANCE(90);
      if (lookahead == '\\') ADVANCE(31);
      if (lookahead == ']') ADVANCE(91);
      if (lookahead == '`') ADVANCE(184);
      if (lookahead == '{') ADVANCE(81);
      if (lookahead == '|') ADVANCE(136);
      if (lookahead == '~') ADVANCE(161);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(192);
      if (anon_sym_BANG_character_set_1(lookahead)) SKIP(7)
      if (lookahead != 0 &&
          lookahead > '#' &&
          (lookahead < '%' || '>' < lookahead) &&
          lookahead != '^' &&
          lookahead != '}') ADVANCE(201);
      END_STATE();
    case 8:
      if (lookahead == '!') ADVANCE(84);
      if (lookahead == '"') ADVANCE(164);
      if (lookahead == '&') ADVANCE(131);
      if (lookahead == '\'') ADVANCE(165);
      if (lookahead == '(') ADVANCE(86);
      if (lookahead == ')') ADVANCE(87);
      if (lookahead == '+') ADVANCE(143);
      if (lookahead == ',') ADVANCE(82);
      if (lookahead == '-') ADVANCE(146);
      if (lookahead == '.') ADVANCE(101);
      if (lookahead == '/') ADVANCE(98);
      if (lookahead == '0') ADVANCE(191);
      if (lookahead == ':') ADVANCE(89);
      if (lookahead == ';') ADVANCE(88);
      if (lookahead == '<') ADVANCE(92);
      if (lookahead == '=') ADVANCE(79);
      if (lookahead == '>') ADVANCE(95);
      if (lookahead == '?') ADVANCE(205);
      if (lookahead == '@') ADVANCE(203);
      if (lookahead == '[') ADVANCE(90);
      if (lookahead == '\\') ADVANCE(31);
      if (lookahead == ']') ADVANCE(91);
      if (lookahead == '`') ADVANCE(184);
      if (lookahead == '{') ADVANCE(80);
      if (lookahead == '|') ADVANCE(141);
      if (lookahead == '}') ADVANCE(83);
      if (lookahead == '~') ADVANCE(161);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(192);
      if (anon_sym_BANG_character_set_1(lookahead)) SKIP(8)
      if (lookahead != 0 &&
          lookahead > '#' &&
          (lookahead < '%' || '*' < lookahead) &&
          lookahead != '^') ADVANCE(201);
      END_STATE();
    case 9:
      if (lookahead == '"') ADVANCE(164);
      if (lookahead == '#') ADVANCE(27);
      if (lookahead == '&') ADVANCE(131);
      if (lookahead == '\'') ADVANCE(165);
      if (lookahead == '(') ADVANCE(86);
      if (lookahead == '*') ADVANCE(74);
      if (lookahead == '+') ADVANCE(142);
      if (lookahead == ',') ADVANCE(82);
      if (lookahead == '-') ADVANCE(145);
      if (lookahead == '.') ADVANCE(101);
      if (lookahead == '/') ADVANCE(186);
      if (lookahead == '0') ADVANCE(191);
      if (lookahead == ';') ADVANCE(88);
      if (lookahead == '<') ADVANCE(92);
      if (lookahead == '>') ADVANCE(95);
      if (lookahead == '?') ADVANCE(204);
      if (lookahead == '@') ADVANCE(203);
      if (lookahead == '[') ADVANCE(90);
      if (lookahead == '\\') ADVANCE(31);
      if (lookahead == ']') ADVANCE(91);
      if (lookahead == '`') ADVANCE(184);
      if (lookahead == '{') ADVANCE(81);
      if (lookahead == '|') ADVANCE(141);
      if (lookahead == '}') ADVANCE(83);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(192);
      if (anon_sym_BANG_character_set_1(lookahead)) SKIP(10)
      if (lookahead != 0 &&
          lookahead > '!' &&
          (lookahead < '%' || '=' < lookahead) &&
          lookahead != '^' &&
          lookahead != '~') ADVANCE(201);
      END_STATE();
    case 10:
      if (lookahead == '"') ADVANCE(164);
      if (lookahead == '#') ADVANCE(27);
      if (lookahead == '&') ADVANCE(131);
      if (lookahead == '\'') ADVANCE(165);
      if (lookahead == '(') ADVANCE(86);
      if (lookahead == '*') ADVANCE(74);
      if (lookahead == '+') ADVANCE(142);
      if (lookahead == ',') ADVANCE(82);
      if (lookahead == '-') ADVANCE(145);
      if (lookahead == '.') ADVANCE(101);
      if (lookahead == '/') ADVANCE(16);
      if (lookahead == '0') ADVANCE(191);
      if (lookahead == ';') ADVANCE(88);
      if (lookahead == '<') ADVANCE(92);
      if (lookahead == '>') ADVANCE(95);
      if (lookahead == '?') ADVANCE(204);
      if (lookahead == '@') ADVANCE(203);
      if (lookahead == '[') ADVANCE(90);
      if (lookahead == '\\') ADVANCE(31);
      if (lookahead == ']') ADVANCE(91);
      if (lookahead == '`') ADVANCE(184);
      if (lookahead == '{') ADVANCE(81);
      if (lookahead == '|') ADVANCE(141);
      if (lookahead == '}') ADVANCE(83);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(192);
      if (anon_sym_BANG_character_set_1(lookahead)) SKIP(10)
      if (lookahead != 0 &&
          lookahead > '!' &&
          (lookahead < '%' || '=' < lookahead) &&
          lookahead != '^' &&
          lookahead != '~') ADVANCE(201);
      END_STATE();
    case 11:
      if (lookahead == '"') ADVANCE(164);
      if (lookahead == '#') ADVANCE(27);
      if (lookahead == '\'') ADVANCE(165);
      if (lookahead == '(') ADVANCE(86);
      if (lookahead == '*') ADVANCE(74);
      if (lookahead == ',') ADVANCE(82);
      if (lookahead == '-') ADVANCE(145);
      if (lookahead == '.') ADVANCE(19);
      if (lookahead == '/') ADVANCE(16);
      if (lookahead == '0') ADVANCE(191);
      if (lookahead == ';') ADVANCE(88);
      if (lookahead == '<') ADVANCE(92);
      if (lookahead == '@') ADVANCE(203);
      if (lookahead == '[') ADVANCE(90);
      if (lookahead == '\\') ADVANCE(31);
      if (lookahead == '{') ADVANCE(80);
      if (lookahead == '|') ADVANCE(41);
      if (lookahead == '}') ADVANCE(83);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(192);
      if (anon_sym_BANG_character_set_1(lookahead)) SKIP(11)
      if (lookahead != 0 &&
          lookahead > '!' &&
          (lookahead < '%' || '?' < lookahead) &&
          lookahead != ']' &&
          lookahead != '^' &&
          lookahead != '`' &&
          lookahead != '~') ADVANCE(201);
      END_STATE();
    case 12:
      if (lookahead == '"') ADVANCE(164);
      if (lookahead == '/') ADVANCE(167);
      if (lookahead == '\\') ADVANCE(32);
      if (anon_sym_BANG_character_set_1(lookahead)) ADVANCE(170);
      if (lookahead != 0) ADVANCE(171);
      END_STATE();
    case 13:
      if (lookahead == '$') ADVANCE(33);
      if (lookahead == '-') ADVANCE(26);
      if (lookahead == '/') ADVANCE(16);
      if (lookahead == ':') ADVANCE(89);
      if (lookahead == '?') ADVANCE(24);
      if (lookahead == '\\') ADVANCE(32);
      if (lookahead == '`') ADVANCE(184);
      if (anon_sym_BANG_character_set_1(lookahead)) SKIP(14)
      END_STATE();
    case 14:
      if (lookahead == '$') ADVANCE(33);
      if (lookahead == '-') ADVANCE(26);
      if (lookahead == '/') ADVANCE(16);
      if (lookahead == ':') ADVANCE(89);
      if (lookahead == '?') ADVANCE(24);
      if (lookahead == '`') ADVANCE(184);
      if (anon_sym_BANG_character_set_1(lookahead)) SKIP(14)
      END_STATE();
    case 15:
      if (lookahead == '\'') ADVANCE(165);
      if (lookahead == '/') ADVANCE(173);
      if (lookahead == '\\') ADVANCE(32);
      if (anon_sym_BANG_character_set_1(lookahead)) ADVANCE(176);
      if (lookahead != 0) ADVANCE(177);
      END_STATE();
    case 16:
      if (lookahead == '*') ADVANCE(18);
      if (lookahead == '/') ADVANCE(183);
      END_STATE();
    case 17:
      if (lookahead == '*') ADVANCE(17);
      if (lookahead == '/') ADVANCE(182);
      if (lookahead != 0) ADVANCE(18);
      END_STATE();
    case 18:
      if (lookahead == '*') ADVANCE(17);
      if (lookahead != 0) ADVANCE(18);
      END_STATE();
    case 19:
      if (lookahead == '.') ADVANCE(21);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(198);
      END_STATE();
    case 20:
      if (lookahead == '.') ADVANCE(104);
      if (lookahead == '?') ADVANCE(159);
      END_STATE();
    case 21:
      if (lookahead == '.') ADVANCE(120);
      END_STATE();
    case 22:
      if (lookahead == '/') ADVANCE(16);
      if (anon_sym_BANG_character_set_1(lookahead)) SKIP(22)
      END_STATE();
    case 23:
      if (lookahead == ':') ADVANCE(208);
      END_STATE();
    case 24:
      if (lookahead == ':') ADVANCE(209);
      END_STATE();
    case 25:
      if (lookahead == '=') ADVANCE(154);
      END_STATE();
    case 26:
      if (lookahead == '?') ADVANCE(23);
      END_STATE();
    case 27:
      if (lookahead == '\\') ADVANCE(30);
      if (!sym_private_property_identifier_character_set_1(lookahead)) ADVANCE(202);
      END_STATE();
    case 28:
      if (lookahead == '\\') ADVANCE(67);
      if (lookahead == ']') ADVANCE(188);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(28);
      END_STATE();
    case 29:
      if (lookahead == 'u') ADVANCE(34);
      if (lookahead == 'x') ADVANCE(59);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(181);
      if (lookahead != 0) ADVANCE(178);
      END_STATE();
    case 30:
      if (lookahead == 'u') ADVANCE(35);
      END_STATE();
    case 31:
      if (lookahead == 'u') ADVANCE(36);
      END_STATE();
    case 32:
      if (lookahead == 'u') ADVANCE(37);
      if (lookahead == 'x') ADVANCE(59);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(181);
      if (lookahead != 0) ADVANCE(178);
      END_STATE();
    case 33:
      if (lookahead == '{') ADVANCE(185);
      END_STATE();
    case 34:
      if (lookahead == '{') ADVANCE(54);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(64);
      END_STATE();
    case 35:
      if (lookahead == '{') ADVANCE(57);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(65);
      END_STATE();
    case 36:
      if (lookahead == '{') ADVANCE(58);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(66);
      END_STATE();
    case 37:
      if (lookahead == '{') ADVANCE(60);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(56);
      END_STATE();
    case 38:
      if (lookahead == '}') ADVANCE(201);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(38);
      END_STATE();
    case 39:
      if (lookahead == '}') ADVANCE(202);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(39);
      END_STATE();
    case 40:
      if (lookahead == '}') ADVANCE(178);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(40);
      END_STATE();
    case 41:
      if (lookahead == '}') ADVANCE(211);
      END_STATE();
    case 42:
      if (lookahead == '}') ADVANCE(179);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(42);
      END_STATE();
    case 43:
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(49);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(197);
      END_STATE();
    case 44:
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(193);
      END_STATE();
    case 45:
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(194);
      END_STATE();
    case 46:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(192);
      END_STATE();
    case 47:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(198);
      END_STATE();
    case 48:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(196);
      END_STATE();
    case 49:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(197);
      END_STATE();
    case 50:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(201);
      END_STATE();
    case 51:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(202);
      END_STATE();
    case 52:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(178);
      END_STATE();
    case 53:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(195);
      END_STATE();
    case 54:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(42);
      END_STATE();
    case 55:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(179);
      END_STATE();
    case 56:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(59);
      END_STATE();
    case 57:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(39);
      END_STATE();
    case 58:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(38);
      END_STATE();
    case 59:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(52);
      END_STATE();
    case 60:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(40);
      END_STATE();
    case 61:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(55);
      END_STATE();
    case 62:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(51);
      END_STATE();
    case 63:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(50);
      END_STATE();
    case 64:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(61);
      END_STATE();
    case 65:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(62);
      END_STATE();
    case 66:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(63);
      END_STATE();
    case 67:
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(28);
      END_STATE();
    case 68:
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(188);
      END_STATE();
    case 69:
      if (eof) ADVANCE(72);
      if (lookahead == '!') ADVANCE(85);
      if (lookahead == '"') ADVANCE(164);
      if (lookahead == '#') ADVANCE(6);
      if (lookahead == '$') ADVANCE(200);
      if (lookahead == '%') ADVANCE(150);
      if (lookahead == '&') ADVANCE(132);
      if (lookahead == '\'') ADVANCE(165);
      if (lookahead == '(') ADVANCE(86);
      if (lookahead == ')') ADVANCE(87);
      if (lookahead == '*') ADVANCE(75);
      if (lookahead == '+') ADVANCE(144);
      if (lookahead == ',') ADVANCE(82);
      if (lookahead == '-') ADVANCE(148);
      if (lookahead == '.') ADVANCE(101);
      if (lookahead == '/') ADVANCE(98);
      if (lookahead == '0') ADVANCE(191);
      if (lookahead == ':') ADVANCE(89);
      if (lookahead == ';') ADVANCE(88);
      if (lookahead == '<') ADVANCE(93);
      if (lookahead == '=') ADVANCE(78);
      if (lookahead == '>') ADVANCE(96);
      if (lookahead == '?') ADVANCE(206);
      if (lookahead == '@') ADVANCE(203);
      if (lookahead == '[') ADVANCE(90);
      if (lookahead == '\\') ADVANCE(31);
      if (lookahead == ']') ADVANCE(91);
      if (lookahead == '^') ADVANCE(135);
      if (lookahead == '`') ADVANCE(184);
      if (lookahead == '{') ADVANCE(81);
      if (lookahead == '|') ADVANCE(138);
      if (lookahead == '}') ADVANCE(83);
      if (lookahead == '~') ADVANCE(161);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(192);
      if (anon_sym_BANG_character_set_1(lookahead)) SKIP(69)
      if (lookahead != 0 &&
          lookahead > 31) ADVANCE(201);
      END_STATE();
    case 70:
      if (eof) ADVANCE(72);
      if (lookahead == '!') ADVANCE(85);
      if (lookahead == '"') ADVANCE(164);
      if (lookahead == '%') ADVANCE(149);
      if (lookahead == '&') ADVANCE(133);
      if (lookahead == '\'') ADVANCE(165);
      if (lookahead == '(') ADVANCE(86);
      if (lookahead == ')') ADVANCE(87);
      if (lookahead == '*') ADVANCE(76);
      if (lookahead == '+') ADVANCE(143);
      if (lookahead == ',') ADVANCE(82);
      if (lookahead == '-') ADVANCE(146);
      if (lookahead == '.') ADVANCE(102);
      if (lookahead == '/') ADVANCE(98);
      if (lookahead == '0') ADVANCE(191);
      if (lookahead == ':') ADVANCE(89);
      if (lookahead == ';') ADVANCE(88);
      if (lookahead == '<') ADVANCE(94);
      if (lookahead == '=') ADVANCE(77);
      if (lookahead == '>') ADVANCE(97);
      if (lookahead == '?') ADVANCE(207);
      if (lookahead == '@') ADVANCE(203);
      if (lookahead == '[') ADVANCE(90);
      if (lookahead == '\\') ADVANCE(31);
      if (lookahead == ']') ADVANCE(91);
      if (lookahead == '^') ADVANCE(134);
      if (lookahead == '`') ADVANCE(184);
      if (lookahead == '{') ADVANCE(80);
      if (lookahead == '|') ADVANCE(140);
      if (lookahead == '}') ADVANCE(83);
      if (lookahead == '~') ADVANCE(161);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(192);
      if (anon_sym_BANG_character_set_1(lookahead)) SKIP(70)
      if (lookahead != 0 &&
          lookahead > '#') ADVANCE(201);
      END_STATE();
    case 71:
      if (eof) ADVANCE(72);
      if (lookahead == '!') ADVANCE(84);
      if (lookahead == '"') ADVANCE(164);
      if (lookahead == '#') ADVANCE(6);
      if (lookahead == '&') ADVANCE(131);
      if (lookahead == '\'') ADVANCE(165);
      if (lookahead == '(') ADVANCE(86);
      if (lookahead == ')') ADVANCE(87);
      if (lookahead == '*') ADVANCE(74);
      if (lookahead == '+') ADVANCE(143);
      if (lookahead == ',') ADVANCE(82);
      if (lookahead == '-') ADVANCE(146);
      if (lookahead == '.') ADVANCE(101);
      if (lookahead == '/') ADVANCE(98);
      if (lookahead == '0') ADVANCE(191);
      if (lookahead == ':') ADVANCE(89);
      if (lookahead == ';') ADVANCE(88);
      if (lookahead == '<') ADVANCE(92);
      if (lookahead == '=') ADVANCE(79);
      if (lookahead == '>') ADVANCE(95);
      if (lookahead == '?') ADVANCE(204);
      if (lookahead == '@') ADVANCE(203);
      if (lookahead == '[') ADVANCE(90);
      if (lookahead == '\\') ADVANCE(31);
      if (lookahead == ']') ADVANCE(91);
      if (lookahead == '`') ADVANCE(184);
      if (lookahead == '{') ADVANCE(80);
      if (lookahead == '|') ADVANCE(141);
      if (lookahead == '}') ADVANCE(83);
      if (lookahead == '~') ADVANCE(161);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(192);
      if (anon_sym_BANG_character_set_1(lookahead)) SKIP(71)
      if (lookahead != 0 &&
          lookahead > 31 &&
          lookahead != '%' &&
          lookahead != '^') ADVANCE(201);
      END_STATE();
    case 72:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 73:
      ACCEPT_TOKEN(sym_hash_bang_line);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(73);
      END_STATE();
    case 74:
      ACCEPT_TOKEN(anon_sym_STAR);
      END_STATE();
    case 75:
      ACCEPT_TOKEN(anon_sym_STAR);
      if (lookahead == '*') ADVANCE(152);
      if (lookahead == '=') ADVANCE(107);
      END_STATE();
    case 76:
      ACCEPT_TOKEN(anon_sym_STAR);
      if (lookahead == '*') ADVANCE(151);
      END_STATE();
    case 77:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(154);
      END_STATE();
    case 78:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(154);
      if (lookahead == '>') ADVANCE(103);
      END_STATE();
    case 79:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '>') ADVANCE(103);
      END_STATE();
    case 80:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 81:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      if (lookahead == '|') ADVANCE(210);
      END_STATE();
    case 82:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 83:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 84:
      ACCEPT_TOKEN(anon_sym_BANG);
      END_STATE();
    case 85:
      ACCEPT_TOKEN(anon_sym_BANG);
      if (lookahead == '=') ADVANCE(156);
      END_STATE();
    case 86:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 87:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 88:
      ACCEPT_TOKEN(anon_sym_SEMI);
      END_STATE();
    case 89:
      ACCEPT_TOKEN(anon_sym_COLON);
      END_STATE();
    case 90:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 91:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 92:
      ACCEPT_TOKEN(anon_sym_LT);
      END_STATE();
    case 93:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '<') ADVANCE(130);
      if (lookahead == '=') ADVANCE(153);
      END_STATE();
    case 94:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '<') ADVANCE(129);
      if (lookahead == '=') ADVANCE(153);
      END_STATE();
    case 95:
      ACCEPT_TOKEN(anon_sym_GT);
      END_STATE();
    case 96:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(158);
      if (lookahead == '>') ADVANCE(125);
      END_STATE();
    case 97:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(158);
      if (lookahead == '>') ADVANCE(126);
      END_STATE();
    case 98:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '*') ADVANCE(18);
      if (lookahead == '/') ADVANCE(183);
      END_STATE();
    case 99:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '*') ADVANCE(18);
      if (lookahead == '/') ADVANCE(183);
      if (lookahead == '=') ADVANCE(108);
      END_STATE();
    case 100:
      ACCEPT_TOKEN(anon_sym_DOT);
      END_STATE();
    case 101:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '.') ADVANCE(21);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(198);
      END_STATE();
    case 102:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(198);
      END_STATE();
    case 103:
      ACCEPT_TOKEN(anon_sym_EQ_GT);
      END_STATE();
    case 104:
      ACCEPT_TOKEN(anon_sym_QMARK_DOT);
      END_STATE();
    case 105:
      ACCEPT_TOKEN(anon_sym_PLUS_EQ);
      END_STATE();
    case 106:
      ACCEPT_TOKEN(anon_sym_DASH_EQ);
      END_STATE();
    case 107:
      ACCEPT_TOKEN(anon_sym_STAR_EQ);
      END_STATE();
    case 108:
      ACCEPT_TOKEN(anon_sym_SLASH_EQ);
      END_STATE();
    case 109:
      ACCEPT_TOKEN(anon_sym_PERCENT_EQ);
      END_STATE();
    case 110:
      ACCEPT_TOKEN(anon_sym_CARET_EQ);
      END_STATE();
    case 111:
      ACCEPT_TOKEN(anon_sym_AMP_EQ);
      END_STATE();
    case 112:
      ACCEPT_TOKEN(anon_sym_PIPE_EQ);
      END_STATE();
    case 113:
      ACCEPT_TOKEN(anon_sym_GT_GT_EQ);
      END_STATE();
    case 114:
      ACCEPT_TOKEN(anon_sym_GT_GT_GT_EQ);
      END_STATE();
    case 115:
      ACCEPT_TOKEN(anon_sym_LT_LT_EQ);
      END_STATE();
    case 116:
      ACCEPT_TOKEN(anon_sym_STAR_STAR_EQ);
      END_STATE();
    case 117:
      ACCEPT_TOKEN(anon_sym_AMP_AMP_EQ);
      END_STATE();
    case 118:
      ACCEPT_TOKEN(anon_sym_PIPE_PIPE_EQ);
      END_STATE();
    case 119:
      ACCEPT_TOKEN(anon_sym_QMARK_QMARK_EQ);
      END_STATE();
    case 120:
      ACCEPT_TOKEN(anon_sym_DOT_DOT_DOT);
      END_STATE();
    case 121:
      ACCEPT_TOKEN(anon_sym_AMP_AMP);
      END_STATE();
    case 122:
      ACCEPT_TOKEN(anon_sym_AMP_AMP);
      if (lookahead == '=') ADVANCE(117);
      END_STATE();
    case 123:
      ACCEPT_TOKEN(anon_sym_PIPE_PIPE);
      END_STATE();
    case 124:
      ACCEPT_TOKEN(anon_sym_PIPE_PIPE);
      if (lookahead == '=') ADVANCE(118);
      END_STATE();
    case 125:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      if (lookahead == '=') ADVANCE(113);
      if (lookahead == '>') ADVANCE(128);
      END_STATE();
    case 126:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      if (lookahead == '>') ADVANCE(127);
      END_STATE();
    case 127:
      ACCEPT_TOKEN(anon_sym_GT_GT_GT);
      END_STATE();
    case 128:
      ACCEPT_TOKEN(anon_sym_GT_GT_GT);
      if (lookahead == '=') ADVANCE(114);
      END_STATE();
    case 129:
      ACCEPT_TOKEN(anon_sym_LT_LT);
      END_STATE();
    case 130:
      ACCEPT_TOKEN(anon_sym_LT_LT);
      if (lookahead == '=') ADVANCE(115);
      END_STATE();
    case 131:
      ACCEPT_TOKEN(anon_sym_AMP);
      END_STATE();
    case 132:
      ACCEPT_TOKEN(anon_sym_AMP);
      if (lookahead == '&') ADVANCE(122);
      if (lookahead == '=') ADVANCE(111);
      END_STATE();
    case 133:
      ACCEPT_TOKEN(anon_sym_AMP);
      if (lookahead == '&') ADVANCE(121);
      END_STATE();
    case 134:
      ACCEPT_TOKEN(anon_sym_CARET);
      END_STATE();
    case 135:
      ACCEPT_TOKEN(anon_sym_CARET);
      if (lookahead == '=') ADVANCE(110);
      END_STATE();
    case 136:
      ACCEPT_TOKEN(anon_sym_PIPE);
      END_STATE();
    case 137:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '=') ADVANCE(112);
      if (lookahead == '|') ADVANCE(124);
      END_STATE();
    case 138:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '=') ADVANCE(112);
      if (lookahead == '|') ADVANCE(124);
      if (lookahead == '}') ADVANCE(211);
      END_STATE();
    case 139:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '|') ADVANCE(123);
      END_STATE();
    case 140:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '|') ADVANCE(123);
      if (lookahead == '}') ADVANCE(211);
      END_STATE();
    case 141:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '}') ADVANCE(211);
      END_STATE();
    case 142:
      ACCEPT_TOKEN(anon_sym_PLUS);
      END_STATE();
    case 143:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '+') ADVANCE(162);
      END_STATE();
    case 144:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '+') ADVANCE(162);
      if (lookahead == '=') ADVANCE(105);
      END_STATE();
    case 145:
      ACCEPT_TOKEN(anon_sym_DASH);
      END_STATE();
    case 146:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(163);
      END_STATE();
    case 147:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(163);
      if (lookahead == '=') ADVANCE(106);
      END_STATE();
    case 148:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(163);
      if (lookahead == '=') ADVANCE(106);
      if (lookahead == '?') ADVANCE(23);
      END_STATE();
    case 149:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      END_STATE();
    case 150:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      if (lookahead == '=') ADVANCE(109);
      END_STATE();
    case 151:
      ACCEPT_TOKEN(anon_sym_STAR_STAR);
      END_STATE();
    case 152:
      ACCEPT_TOKEN(anon_sym_STAR_STAR);
      if (lookahead == '=') ADVANCE(116);
      END_STATE();
    case 153:
      ACCEPT_TOKEN(anon_sym_LT_EQ);
      END_STATE();
    case 154:
      ACCEPT_TOKEN(anon_sym_EQ_EQ);
      if (lookahead == '=') ADVANCE(155);
      END_STATE();
    case 155:
      ACCEPT_TOKEN(anon_sym_EQ_EQ_EQ);
      END_STATE();
    case 156:
      ACCEPT_TOKEN(anon_sym_BANG_EQ);
      if (lookahead == '=') ADVANCE(157);
      END_STATE();
    case 157:
      ACCEPT_TOKEN(anon_sym_BANG_EQ_EQ);
      END_STATE();
    case 158:
      ACCEPT_TOKEN(anon_sym_GT_EQ);
      END_STATE();
    case 159:
      ACCEPT_TOKEN(anon_sym_QMARK_QMARK);
      END_STATE();
    case 160:
      ACCEPT_TOKEN(anon_sym_QMARK_QMARK);
      if (lookahead == '=') ADVANCE(119);
      END_STATE();
    case 161:
      ACCEPT_TOKEN(anon_sym_TILDE);
      END_STATE();
    case 162:
      ACCEPT_TOKEN(anon_sym_PLUS_PLUS);
      END_STATE();
    case 163:
      ACCEPT_TOKEN(anon_sym_DASH_DASH);
      END_STATE();
    case 164:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      END_STATE();
    case 165:
      ACCEPT_TOKEN(anon_sym_SQUOTE);
      END_STATE();
    case 166:
      ACCEPT_TOKEN(sym_unescaped_double_string_fragment);
      if (lookahead == '\n') ADVANCE(171);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(166);
      END_STATE();
    case 167:
      ACCEPT_TOKEN(sym_unescaped_double_string_fragment);
      if (lookahead == '*') ADVANCE(169);
      if (lookahead == '/') ADVANCE(166);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(171);
      END_STATE();
    case 168:
      ACCEPT_TOKEN(sym_unescaped_double_string_fragment);
      if (lookahead == '*') ADVANCE(168);
      if (lookahead == '/') ADVANCE(171);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(169);
      END_STATE();
    case 169:
      ACCEPT_TOKEN(sym_unescaped_double_string_fragment);
      if (lookahead == '*') ADVANCE(168);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(169);
      END_STATE();
    case 170:
      ACCEPT_TOKEN(sym_unescaped_double_string_fragment);
      if (lookahead == '/') ADVANCE(167);
      if (anon_sym_BANG_character_set_1(lookahead)) ADVANCE(170);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(171);
      END_STATE();
    case 171:
      ACCEPT_TOKEN(sym_unescaped_double_string_fragment);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(171);
      END_STATE();
    case 172:
      ACCEPT_TOKEN(sym_unescaped_single_string_fragment);
      if (lookahead == '\n') ADVANCE(177);
      if (lookahead != 0 &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(172);
      END_STATE();
    case 173:
      ACCEPT_TOKEN(sym_unescaped_single_string_fragment);
      if (lookahead == '*') ADVANCE(175);
      if (lookahead == '/') ADVANCE(172);
      if (lookahead != 0 &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(177);
      END_STATE();
    case 174:
      ACCEPT_TOKEN(sym_unescaped_single_string_fragment);
      if (lookahead == '*') ADVANCE(174);
      if (lookahead == '/') ADVANCE(177);
      if (lookahead != 0 &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(175);
      END_STATE();
    case 175:
      ACCEPT_TOKEN(sym_unescaped_single_string_fragment);
      if (lookahead == '*') ADVANCE(174);
      if (lookahead != 0 &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(175);
      END_STATE();
    case 176:
      ACCEPT_TOKEN(sym_unescaped_single_string_fragment);
      if (lookahead == '/') ADVANCE(173);
      if (anon_sym_BANG_character_set_1(lookahead)) ADVANCE(176);
      if (lookahead != 0 &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(177);
      END_STATE();
    case 177:
      ACCEPT_TOKEN(sym_unescaped_single_string_fragment);
      if (lookahead != 0 &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(177);
      END_STATE();
    case 178:
      ACCEPT_TOKEN(sym_escape_sequence);
      END_STATE();
    case 179:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (lookahead == '\\') ADVANCE(31);
      if (!sym_identifier_character_set_1(lookahead)) ADVANCE(201);
      END_STATE();
    case 180:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(178);
      END_STATE();
    case 181:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(180);
      END_STATE();
    case 182:
      ACCEPT_TOKEN(sym_comment);
      END_STATE();
    case 183:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(183);
      END_STATE();
    case 184:
      ACCEPT_TOKEN(anon_sym_BQUOTE);
      END_STATE();
    case 185:
      ACCEPT_TOKEN(anon_sym_DOLLAR_LBRACE);
      END_STATE();
    case 186:
      ACCEPT_TOKEN(anon_sym_SLASH2);
      if (lookahead == '*') ADVANCE(18);
      if (lookahead == '/') ADVANCE(183);
      END_STATE();
    case 187:
      ACCEPT_TOKEN(sym_regex_pattern);
      if (lookahead == '\n') SKIP(22)
      if (lookahead == '/') ADVANCE(16);
      if (lookahead == '[') ADVANCE(28);
      if (lookahead == '\\') ADVANCE(68);
      if (sym_regex_pattern_character_set_1(lookahead)) ADVANCE(187);
      if (lookahead != 0) ADVANCE(188);
      END_STATE();
    case 188:
      ACCEPT_TOKEN(sym_regex_pattern);
      if (lookahead == '[') ADVANCE(28);
      if (lookahead == '\\') ADVANCE(68);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '/') ADVANCE(188);
      END_STATE();
    case 189:
      ACCEPT_TOKEN(sym_regex_flags);
      if (lookahead == '\\') ADVANCE(31);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(189);
      if (!sym_identifier_character_set_2(lookahead)) ADVANCE(201);
      END_STATE();
    case 190:
      ACCEPT_TOKEN(sym_number);
      END_STATE();
    case 191:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '.') ADVANCE(199);
      if (lookahead == '0') ADVANCE(196);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(44);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(43);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(45);
      if (lookahead == 'X' ||
          lookahead == 'x') ADVANCE(53);
      if (lookahead == '_') ADVANCE(48);
      if (lookahead == 'n') ADVANCE(190);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(192);
      END_STATE();
    case 192:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '.') ADVANCE(199);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(43);
      if (lookahead == '_') ADVANCE(46);
      if (lookahead == 'n') ADVANCE(190);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(192);
      END_STATE();
    case 193:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '_') ADVANCE(44);
      if (lookahead == 'n') ADVANCE(190);
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(193);
      END_STATE();
    case 194:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '_') ADVANCE(45);
      if (lookahead == 'n') ADVANCE(190);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(194);
      END_STATE();
    case 195:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '_') ADVANCE(53);
      if (lookahead == 'n') ADVANCE(190);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(195);
      END_STATE();
    case 196:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '_') ADVANCE(48);
      if (lookahead == 'n') ADVANCE(190);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(196);
      END_STATE();
    case 197:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '_') ADVANCE(49);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(197);
      END_STATE();
    case 198:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(43);
      if (lookahead == '_') ADVANCE(47);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(198);
      END_STATE();
    case 199:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(43);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(198);
      END_STATE();
    case 200:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '\\') ADVANCE(31);
      if (lookahead == '{') ADVANCE(185);
      if (!sym_identifier_character_set_3(lookahead)) ADVANCE(201);
      END_STATE();
    case 201:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '\\') ADVANCE(31);
      if (!sym_identifier_character_set_1(lookahead)) ADVANCE(201);
      END_STATE();
    case 202:
      ACCEPT_TOKEN(sym_private_property_identifier);
      if (lookahead == '\\') ADVANCE(30);
      if (!sym_identifier_character_set_1(lookahead)) ADVANCE(202);
      END_STATE();
    case 203:
      ACCEPT_TOKEN(anon_sym_AT);
      END_STATE();
    case 204:
      ACCEPT_TOKEN(anon_sym_QMARK);
      END_STATE();
    case 205:
      ACCEPT_TOKEN(anon_sym_QMARK);
      if (lookahead == '.') ADVANCE(104);
      END_STATE();
    case 206:
      ACCEPT_TOKEN(anon_sym_QMARK);
      if (lookahead == '.') ADVANCE(104);
      if (lookahead == '?') ADVANCE(160);
      END_STATE();
    case 207:
      ACCEPT_TOKEN(anon_sym_QMARK);
      if (lookahead == '.') ADVANCE(104);
      if (lookahead == '?') ADVANCE(159);
      END_STATE();
    case 208:
      ACCEPT_TOKEN(anon_sym_DASH_QMARK_COLON);
      END_STATE();
    case 209:
      ACCEPT_TOKEN(anon_sym_QMARK_COLON);
      END_STATE();
    case 210:
      ACCEPT_TOKEN(anon_sym_LBRACE_PIPE);
      END_STATE();
    case 211:
      ACCEPT_TOKEN(anon_sym_PIPE_RBRACE);
      END_STATE();
    default:
      return false;
  }
}

static bool ts_lex_keywords(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (lookahead == 'a') ADVANCE(1);
      if (lookahead == 'b') ADVANCE(2);
      if (lookahead == 'c') ADVANCE(3);
      if (lookahead == 'd') ADVANCE(4);
      if (lookahead == 'e') ADVANCE(5);
      if (lookahead == 'f') ADVANCE(6);
      if (lookahead == 'g') ADVANCE(7);
      if (lookahead == 'i') ADVANCE(8);
      if (lookahead == 'k') ADVANCE(9);
      if (lookahead == 'l') ADVANCE(10);
      if (lookahead == 'm') ADVANCE(11);
      if (lookahead == 'n') ADVANCE(12);
      if (lookahead == 'o') ADVANCE(13);
      if (lookahead == 'p') ADVANCE(14);
      if (lookahead == 'r') ADVANCE(15);
      if (lookahead == 's') ADVANCE(16);
      if (lookahead == 't') ADVANCE(17);
      if (lookahead == 'u') ADVANCE(18);
      if (lookahead == 'v') ADVANCE(19);
      if (lookahead == 'w') ADVANCE(20);
      if (lookahead == 'y') ADVANCE(21);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 5760 ||
          (8192 <= lookahead && lookahead <= 8203) ||
          lookahead == 8239 ||
          lookahead == 8287 ||
          lookahead == 8288 ||
          lookahead == 12288 ||
          lookahead == 65279) SKIP(0)
      END_STATE();
    case 1:
      if (lookahead == 'b') ADVANCE(22);
      if (lookahead == 'n') ADVANCE(23);
      if (lookahead == 's') ADVANCE(24);
      if (lookahead == 'w') ADVANCE(25);
      END_STATE();
    case 2:
      if (lookahead == 'o') ADVANCE(26);
      if (lookahead == 'r') ADVANCE(27);
      END_STATE();
    case 3:
      if (lookahead == 'a') ADVANCE(28);
      if (lookahead == 'l') ADVANCE(29);
      if (lookahead == 'o') ADVANCE(30);
      END_STATE();
    case 4:
      if (lookahead == 'e') ADVANCE(31);
      if (lookahead == 'o') ADVANCE(32);
      END_STATE();
    case 5:
      if (lookahead == 'l') ADVANCE(33);
      if (lookahead == 'n') ADVANCE(34);
      if (lookahead == 'x') ADVANCE(35);
      END_STATE();
    case 6:
      if (lookahead == 'a') ADVANCE(36);
      if (lookahead == 'i') ADVANCE(37);
      if (lookahead == 'o') ADVANCE(38);
      if (lookahead == 'r') ADVANCE(39);
      if (lookahead == 'u') ADVANCE(40);
      END_STATE();
    case 7:
      if (lookahead == 'e') ADVANCE(41);
      if (lookahead == 'l') ADVANCE(42);
      END_STATE();
    case 8:
      if (lookahead == 'f') ADVANCE(43);
      if (lookahead == 'm') ADVANCE(44);
      if (lookahead == 'n') ADVANCE(45);
      if (lookahead == 's') ADVANCE(46);
      END_STATE();
    case 9:
      if (lookahead == 'e') ADVANCE(47);
      END_STATE();
    case 10:
      if (lookahead == 'e') ADVANCE(48);
      END_STATE();
    case 11:
      if (lookahead == 'o') ADVANCE(49);
      END_STATE();
    case 12:
      if (lookahead == 'a') ADVANCE(50);
      if (lookahead == 'e') ADVANCE(51);
      if (lookahead == 'u') ADVANCE(52);
      END_STATE();
    case 13:
      if (lookahead == 'b') ADVANCE(53);
      if (lookahead == 'f') ADVANCE(54);
      if (lookahead == 'v') ADVANCE(55);
      END_STATE();
    case 14:
      if (lookahead == 'r') ADVANCE(56);
      if (lookahead == 'u') ADVANCE(57);
      END_STATE();
    case 15:
      if (lookahead == 'e') ADVANCE(58);
      END_STATE();
    case 16:
      if (lookahead == 'e') ADVANCE(59);
      if (lookahead == 't') ADVANCE(60);
      if (lookahead == 'u') ADVANCE(61);
      if (lookahead == 'w') ADVANCE(62);
      if (lookahead == 'y') ADVANCE(63);
      END_STATE();
    case 17:
      if (lookahead == 'a') ADVANCE(64);
      if (lookahead == 'h') ADVANCE(65);
      if (lookahead == 'r') ADVANCE(66);
      if (lookahead == 'y') ADVANCE(67);
      END_STATE();
    case 18:
      if (lookahead == 'n') ADVANCE(68);
      END_STATE();
    case 19:
      if (lookahead == 'a') ADVANCE(69);
      if (lookahead == 'o') ADVANCE(70);
      END_STATE();
    case 20:
      if (lookahead == 'h') ADVANCE(71);
      if (lookahead == 'i') ADVANCE(72);
      END_STATE();
    case 21:
      if (lookahead == 'i') ADVANCE(73);
      END_STATE();
    case 22:
      if (lookahead == 's') ADVANCE(74);
      END_STATE();
    case 23:
      if (lookahead == 'y') ADVANCE(75);
      END_STATE();
    case 24:
      ACCEPT_TOKEN(anon_sym_as);
      if (lookahead == 's') ADVANCE(76);
      if (lookahead == 'y') ADVANCE(77);
      END_STATE();
    case 25:
      if (lookahead == 'a') ADVANCE(78);
      END_STATE();
    case 26:
      if (lookahead == 'o') ADVANCE(79);
      END_STATE();
    case 27:
      if (lookahead == 'e') ADVANCE(80);
      END_STATE();
    case 28:
      if (lookahead == 's') ADVANCE(81);
      if (lookahead == 't') ADVANCE(82);
      END_STATE();
    case 29:
      if (lookahead == 'a') ADVANCE(83);
      END_STATE();
    case 30:
      if (lookahead == 'n') ADVANCE(84);
      END_STATE();
    case 31:
      if (lookahead == 'b') ADVANCE(85);
      if (lookahead == 'c') ADVANCE(86);
      if (lookahead == 'f') ADVANCE(87);
      if (lookahead == 'l') ADVANCE(88);
      END_STATE();
    case 32:
      ACCEPT_TOKEN(anon_sym_do);
      END_STATE();
    case 33:
      if (lookahead == 's') ADVANCE(89);
      END_STATE();
    case 34:
      if (lookahead == 'u') ADVANCE(90);
      END_STATE();
    case 35:
      if (lookahead == 'p') ADVANCE(91);
      if (lookahead == 't') ADVANCE(92);
      END_STATE();
    case 36:
      if (lookahead == 'l') ADVANCE(93);
      END_STATE();
    case 37:
      if (lookahead == 'n') ADVANCE(94);
      END_STATE();
    case 38:
      if (lookahead == 'r') ADVANCE(95);
      END_STATE();
    case 39:
      if (lookahead == 'o') ADVANCE(96);
      END_STATE();
    case 40:
      if (lookahead == 'n') ADVANCE(97);
      END_STATE();
    case 41:
      if (lookahead == 't') ADVANCE(98);
      END_STATE();
    case 42:
      if (lookahead == 'o') ADVANCE(99);
      END_STATE();
    case 43:
      ACCEPT_TOKEN(anon_sym_if);
      END_STATE();
    case 44:
      if (lookahead == 'p') ADVANCE(100);
      END_STATE();
    case 45:
      ACCEPT_TOKEN(anon_sym_in);
      if (lookahead == 'f') ADVANCE(101);
      if (lookahead == 's') ADVANCE(102);
      if (lookahead == 't') ADVANCE(103);
      END_STATE();
    case 46:
      ACCEPT_TOKEN(anon_sym_is);
      END_STATE();
    case 47:
      if (lookahead == 'y') ADVANCE(104);
      END_STATE();
    case 48:
      if (lookahead == 't') ADVANCE(105);
      END_STATE();
    case 49:
      if (lookahead == 'd') ADVANCE(106);
      END_STATE();
    case 50:
      if (lookahead == 'm') ADVANCE(107);
      END_STATE();
    case 51:
      if (lookahead == 'v') ADVANCE(108);
      if (lookahead == 'w') ADVANCE(109);
      END_STATE();
    case 52:
      if (lookahead == 'l') ADVANCE(110);
      if (lookahead == 'm') ADVANCE(111);
      END_STATE();
    case 53:
      if (lookahead == 'j') ADVANCE(112);
      END_STATE();
    case 54:
      ACCEPT_TOKEN(anon_sym_of);
      END_STATE();
    case 55:
      if (lookahead == 'e') ADVANCE(113);
      END_STATE();
    case 56:
      if (lookahead == 'i') ADVANCE(114);
      if (lookahead == 'o') ADVANCE(115);
      END_STATE();
    case 57:
      if (lookahead == 'b') ADVANCE(116);
      END_STATE();
    case 58:
      if (lookahead == 'a') ADVANCE(117);
      if (lookahead == 'q') ADVANCE(118);
      if (lookahead == 't') ADVANCE(119);
      END_STATE();
    case 59:
      if (lookahead == 't') ADVANCE(120);
      END_STATE();
    case 60:
      if (lookahead == 'a') ADVANCE(121);
      if (lookahead == 'r') ADVANCE(122);
      END_STATE();
    case 61:
      if (lookahead == 'p') ADVANCE(123);
      END_STATE();
    case 62:
      if (lookahead == 'i') ADVANCE(124);
      END_STATE();
    case 63:
      if (lookahead == 'm') ADVANCE(125);
      END_STATE();
    case 64:
      if (lookahead == 'r') ADVANCE(126);
      END_STATE();
    case 65:
      if (lookahead == 'i') ADVANCE(127);
      if (lookahead == 'r') ADVANCE(128);
      END_STATE();
    case 66:
      if (lookahead == 'u') ADVANCE(129);
      if (lookahead == 'y') ADVANCE(130);
      END_STATE();
    case 67:
      if (lookahead == 'p') ADVANCE(131);
      END_STATE();
    case 68:
      if (lookahead == 'd') ADVANCE(132);
      if (lookahead == 'k') ADVANCE(133);
      END_STATE();
    case 69:
      if (lookahead == 'r') ADVANCE(134);
      END_STATE();
    case 70:
      if (lookahead == 'i') ADVANCE(135);
      END_STATE();
    case 71:
      if (lookahead == 'i') ADVANCE(136);
      END_STATE();
    case 72:
      if (lookahead == 't') ADVANCE(137);
      END_STATE();
    case 73:
      if (lookahead == 'e') ADVANCE(138);
      END_STATE();
    case 74:
      if (lookahead == 't') ADVANCE(139);
      END_STATE();
    case 75:
      ACCEPT_TOKEN(anon_sym_any);
      END_STATE();
    case 76:
      if (lookahead == 'e') ADVANCE(140);
      END_STATE();
    case 77:
      if (lookahead == 'n') ADVANCE(141);
      END_STATE();
    case 78:
      if (lookahead == 'i') ADVANCE(142);
      END_STATE();
    case 79:
      if (lookahead == 'l') ADVANCE(143);
      END_STATE();
    case 80:
      if (lookahead == 'a') ADVANCE(144);
      END_STATE();
    case 81:
      if (lookahead == 'e') ADVANCE(145);
      END_STATE();
    case 82:
      if (lookahead == 'c') ADVANCE(146);
      END_STATE();
    case 83:
      if (lookahead == 's') ADVANCE(147);
      END_STATE();
    case 84:
      if (lookahead == 's') ADVANCE(148);
      if (lookahead == 't') ADVANCE(149);
      END_STATE();
    case 85:
      if (lookahead == 'u') ADVANCE(150);
      END_STATE();
    case 86:
      if (lookahead == 'l') ADVANCE(151);
      END_STATE();
    case 87:
      if (lookahead == 'a') ADVANCE(152);
      END_STATE();
    case 88:
      if (lookahead == 'e') ADVANCE(153);
      END_STATE();
    case 89:
      if (lookahead == 'e') ADVANCE(154);
      END_STATE();
    case 90:
      if (lookahead == 'm') ADVANCE(155);
      END_STATE();
    case 91:
      if (lookahead == 'o') ADVANCE(156);
      END_STATE();
    case 92:
      if (lookahead == 'e') ADVANCE(157);
      END_STATE();
    case 93:
      if (lookahead == 's') ADVANCE(158);
      END_STATE();
    case 94:
      if (lookahead == 'a') ADVANCE(159);
      END_STATE();
    case 95:
      ACCEPT_TOKEN(anon_sym_for);
      END_STATE();
    case 96:
      if (lookahead == 'm') ADVANCE(160);
      END_STATE();
    case 97:
      if (lookahead == 'c') ADVANCE(161);
      END_STATE();
    case 98:
      ACCEPT_TOKEN(anon_sym_get);
      END_STATE();
    case 99:
      if (lookahead == 'b') ADVANCE(162);
      END_STATE();
    case 100:
      if (lookahead == 'l') ADVANCE(163);
      if (lookahead == 'o') ADVANCE(164);
      END_STATE();
    case 101:
      if (lookahead == 'e') ADVANCE(165);
      END_STATE();
    case 102:
      if (lookahead == 't') ADVANCE(166);
      END_STATE();
    case 103:
      if (lookahead == 'e') ADVANCE(167);
      END_STATE();
    case 104:
      if (lookahead == 'o') ADVANCE(168);
      END_STATE();
    case 105:
      ACCEPT_TOKEN(anon_sym_let);
      END_STATE();
    case 106:
      if (lookahead == 'u') ADVANCE(169);
      END_STATE();
    case 107:
      if (lookahead == 'e') ADVANCE(170);
      END_STATE();
    case 108:
      if (lookahead == 'e') ADVANCE(171);
      END_STATE();
    case 109:
      ACCEPT_TOKEN(anon_sym_new);
      END_STATE();
    case 110:
      if (lookahead == 'l') ADVANCE(172);
      END_STATE();
    case 111:
      if (lookahead == 'b') ADVANCE(173);
      END_STATE();
    case 112:
      if (lookahead == 'e') ADVANCE(174);
      END_STATE();
    case 113:
      if (lookahead == 'r') ADVANCE(175);
      END_STATE();
    case 114:
      if (lookahead == 'v') ADVANCE(176);
      END_STATE();
    case 115:
      if (lookahead == 't') ADVANCE(177);
      END_STATE();
    case 116:
      if (lookahead == 'l') ADVANCE(178);
      END_STATE();
    case 117:
      if (lookahead == 'd') ADVANCE(179);
      END_STATE();
    case 118:
      if (lookahead == 'u') ADVANCE(180);
      END_STATE();
    case 119:
      if (lookahead == 'u') ADVANCE(181);
      END_STATE();
    case 120:
      ACCEPT_TOKEN(anon_sym_set);
      END_STATE();
    case 121:
      if (lookahead == 't') ADVANCE(182);
      END_STATE();
    case 122:
      if (lookahead == 'i') ADVANCE(183);
      END_STATE();
    case 123:
      if (lookahead == 'e') ADVANCE(184);
      END_STATE();
    case 124:
      if (lookahead == 't') ADVANCE(185);
      END_STATE();
    case 125:
      if (lookahead == 'b') ADVANCE(186);
      END_STATE();
    case 126:
      if (lookahead == 'g') ADVANCE(187);
      END_STATE();
    case 127:
      if (lookahead == 's') ADVANCE(188);
      END_STATE();
    case 128:
      if (lookahead == 'o') ADVANCE(189);
      END_STATE();
    case 129:
      if (lookahead == 'e') ADVANCE(190);
      END_STATE();
    case 130:
      ACCEPT_TOKEN(anon_sym_try);
      END_STATE();
    case 131:
      if (lookahead == 'e') ADVANCE(191);
      END_STATE();
    case 132:
      if (lookahead == 'e') ADVANCE(192);
      END_STATE();
    case 133:
      if (lookahead == 'n') ADVANCE(193);
      END_STATE();
    case 134:
      ACCEPT_TOKEN(anon_sym_var);
      END_STATE();
    case 135:
      if (lookahead == 'd') ADVANCE(194);
      END_STATE();
    case 136:
      if (lookahead == 'l') ADVANCE(195);
      END_STATE();
    case 137:
      if (lookahead == 'h') ADVANCE(196);
      END_STATE();
    case 138:
      if (lookahead == 'l') ADVANCE(197);
      END_STATE();
    case 139:
      if (lookahead == 'r') ADVANCE(198);
      END_STATE();
    case 140:
      if (lookahead == 'r') ADVANCE(199);
      END_STATE();
    case 141:
      if (lookahead == 'c') ADVANCE(200);
      END_STATE();
    case 142:
      if (lookahead == 't') ADVANCE(201);
      END_STATE();
    case 143:
      if (lookahead == 'e') ADVANCE(202);
      END_STATE();
    case 144:
      if (lookahead == 'k') ADVANCE(203);
      END_STATE();
    case 145:
      ACCEPT_TOKEN(anon_sym_case);
      END_STATE();
    case 146:
      if (lookahead == 'h') ADVANCE(204);
      END_STATE();
    case 147:
      if (lookahead == 's') ADVANCE(205);
      END_STATE();
    case 148:
      if (lookahead == 't') ADVANCE(206);
      END_STATE();
    case 149:
      if (lookahead == 'i') ADVANCE(207);
      END_STATE();
    case 150:
      if (lookahead == 'g') ADVANCE(208);
      END_STATE();
    case 151:
      if (lookahead == 'a') ADVANCE(209);
      END_STATE();
    case 152:
      if (lookahead == 'u') ADVANCE(210);
      END_STATE();
    case 153:
      if (lookahead == 't') ADVANCE(211);
      END_STATE();
    case 154:
      ACCEPT_TOKEN(anon_sym_else);
      END_STATE();
    case 155:
      ACCEPT_TOKEN(anon_sym_enum);
      END_STATE();
    case 156:
      if (lookahead == 'r') ADVANCE(212);
      END_STATE();
    case 157:
      if (lookahead == 'n') ADVANCE(213);
      END_STATE();
    case 158:
      if (lookahead == 'e') ADVANCE(214);
      END_STATE();
    case 159:
      if (lookahead == 'l') ADVANCE(215);
      END_STATE();
    case 160:
      ACCEPT_TOKEN(anon_sym_from);
      END_STATE();
    case 161:
      if (lookahead == 't') ADVANCE(216);
      END_STATE();
    case 162:
      if (lookahead == 'a') ADVANCE(217);
      END_STATE();
    case 163:
      if (lookahead == 'e') ADVANCE(218);
      END_STATE();
    case 164:
      if (lookahead == 'r') ADVANCE(219);
      END_STATE();
    case 165:
      if (lookahead == 'r') ADVANCE(220);
      END_STATE();
    case 166:
      if (lookahead == 'a') ADVANCE(221);
      END_STATE();
    case 167:
      if (lookahead == 'r') ADVANCE(222);
      END_STATE();
    case 168:
      if (lookahead == 'f') ADVANCE(223);
      END_STATE();
    case 169:
      if (lookahead == 'l') ADVANCE(224);
      END_STATE();
    case 170:
      if (lookahead == 's') ADVANCE(225);
      END_STATE();
    case 171:
      if (lookahead == 'r') ADVANCE(226);
      END_STATE();
    case 172:
      ACCEPT_TOKEN(sym_null);
      END_STATE();
    case 173:
      if (lookahead == 'e') ADVANCE(227);
      END_STATE();
    case 174:
      if (lookahead == 'c') ADVANCE(228);
      END_STATE();
    case 175:
      if (lookahead == 'r') ADVANCE(229);
      END_STATE();
    case 176:
      if (lookahead == 'a') ADVANCE(230);
      END_STATE();
    case 177:
      if (lookahead == 'e') ADVANCE(231);
      END_STATE();
    case 178:
      if (lookahead == 'i') ADVANCE(232);
      END_STATE();
    case 179:
      if (lookahead == 'o') ADVANCE(233);
      END_STATE();
    case 180:
      if (lookahead == 'i') ADVANCE(234);
      END_STATE();
    case 181:
      if (lookahead == 'r') ADVANCE(235);
      END_STATE();
    case 182:
      if (lookahead == 'i') ADVANCE(236);
      END_STATE();
    case 183:
      if (lookahead == 'n') ADVANCE(237);
      END_STATE();
    case 184:
      if (lookahead == 'r') ADVANCE(238);
      END_STATE();
    case 185:
      if (lookahead == 'c') ADVANCE(239);
      END_STATE();
    case 186:
      if (lookahead == 'o') ADVANCE(240);
      END_STATE();
    case 187:
      if (lookahead == 'e') ADVANCE(241);
      END_STATE();
    case 188:
      ACCEPT_TOKEN(sym_this);
      END_STATE();
    case 189:
      if (lookahead == 'w') ADVANCE(242);
      END_STATE();
    case 190:
      ACCEPT_TOKEN(sym_true);
      END_STATE();
    case 191:
      ACCEPT_TOKEN(anon_sym_type);
      if (lookahead == 'o') ADVANCE(243);
      END_STATE();
    case 192:
      if (lookahead == 'f') ADVANCE(244);
      END_STATE();
    case 193:
      if (lookahead == 'o') ADVANCE(245);
      END_STATE();
    case 194:
      ACCEPT_TOKEN(anon_sym_void);
      END_STATE();
    case 195:
      if (lookahead == 'e') ADVANCE(246);
      END_STATE();
    case 196:
      ACCEPT_TOKEN(anon_sym_with);
      END_STATE();
    case 197:
      if (lookahead == 'd') ADVANCE(247);
      END_STATE();
    case 198:
      if (lookahead == 'a') ADVANCE(248);
      END_STATE();
    case 199:
      if (lookahead == 't') ADVANCE(249);
      END_STATE();
    case 200:
      ACCEPT_TOKEN(anon_sym_async);
      END_STATE();
    case 201:
      ACCEPT_TOKEN(anon_sym_await);
      END_STATE();
    case 202:
      if (lookahead == 'a') ADVANCE(250);
      END_STATE();
    case 203:
      ACCEPT_TOKEN(anon_sym_break);
      END_STATE();
    case 204:
      ACCEPT_TOKEN(anon_sym_catch);
      END_STATE();
    case 205:
      ACCEPT_TOKEN(anon_sym_class);
      END_STATE();
    case 206:
      ACCEPT_TOKEN(anon_sym_const);
      END_STATE();
    case 207:
      if (lookahead == 'n') ADVANCE(251);
      END_STATE();
    case 208:
      if (lookahead == 'g') ADVANCE(252);
      END_STATE();
    case 209:
      if (lookahead == 'r') ADVANCE(253);
      END_STATE();
    case 210:
      if (lookahead == 'l') ADVANCE(254);
      END_STATE();
    case 211:
      if (lookahead == 'e') ADVANCE(255);
      END_STATE();
    case 212:
      if (lookahead == 't') ADVANCE(256);
      END_STATE();
    case 213:
      if (lookahead == 'd') ADVANCE(257);
      END_STATE();
    case 214:
      ACCEPT_TOKEN(sym_false);
      END_STATE();
    case 215:
      if (lookahead == 'l') ADVANCE(258);
      END_STATE();
    case 216:
      if (lookahead == 'i') ADVANCE(259);
      END_STATE();
    case 217:
      if (lookahead == 'l') ADVANCE(260);
      END_STATE();
    case 218:
      if (lookahead == 'm') ADVANCE(261);
      END_STATE();
    case 219:
      if (lookahead == 't') ADVANCE(262);
      END_STATE();
    case 220:
      ACCEPT_TOKEN(anon_sym_infer);
      END_STATE();
    case 221:
      if (lookahead == 'n') ADVANCE(263);
      END_STATE();
    case 222:
      if (lookahead == 'f') ADVANCE(264);
      END_STATE();
    case 223:
      ACCEPT_TOKEN(anon_sym_keyof);
      END_STATE();
    case 224:
      if (lookahead == 'e') ADVANCE(265);
      END_STATE();
    case 225:
      if (lookahead == 'p') ADVANCE(266);
      END_STATE();
    case 226:
      ACCEPT_TOKEN(anon_sym_never);
      END_STATE();
    case 227:
      if (lookahead == 'r') ADVANCE(267);
      END_STATE();
    case 228:
      if (lookahead == 't') ADVANCE(268);
      END_STATE();
    case 229:
      if (lookahead == 'i') ADVANCE(269);
      END_STATE();
    case 230:
      if (lookahead == 't') ADVANCE(270);
      END_STATE();
    case 231:
      if (lookahead == 'c') ADVANCE(271);
      END_STATE();
    case 232:
      if (lookahead == 'c') ADVANCE(272);
      END_STATE();
    case 233:
      if (lookahead == 'n') ADVANCE(273);
      END_STATE();
    case 234:
      if (lookahead == 'r') ADVANCE(274);
      END_STATE();
    case 235:
      if (lookahead == 'n') ADVANCE(275);
      END_STATE();
    case 236:
      if (lookahead == 'c') ADVANCE(276);
      END_STATE();
    case 237:
      if (lookahead == 'g') ADVANCE(277);
      END_STATE();
    case 238:
      ACCEPT_TOKEN(sym_super);
      END_STATE();
    case 239:
      if (lookahead == 'h') ADVANCE(278);
      END_STATE();
    case 240:
      if (lookahead == 'l') ADVANCE(279);
      END_STATE();
    case 241:
      if (lookahead == 't') ADVANCE(280);
      END_STATE();
    case 242:
      ACCEPT_TOKEN(anon_sym_throw);
      END_STATE();
    case 243:
      if (lookahead == 'f') ADVANCE(281);
      END_STATE();
    case 244:
      if (lookahead == 'i') ADVANCE(282);
      END_STATE();
    case 245:
      if (lookahead == 'w') ADVANCE(283);
      END_STATE();
    case 246:
      ACCEPT_TOKEN(anon_sym_while);
      END_STATE();
    case 247:
      ACCEPT_TOKEN(anon_sym_yield);
      END_STATE();
    case 248:
      if (lookahead == 'c') ADVANCE(284);
      END_STATE();
    case 249:
      if (lookahead == 's') ADVANCE(285);
      END_STATE();
    case 250:
      if (lookahead == 'n') ADVANCE(286);
      END_STATE();
    case 251:
      if (lookahead == 'u') ADVANCE(287);
      END_STATE();
    case 252:
      if (lookahead == 'e') ADVANCE(288);
      END_STATE();
    case 253:
      if (lookahead == 'e') ADVANCE(289);
      END_STATE();
    case 254:
      if (lookahead == 't') ADVANCE(290);
      END_STATE();
    case 255:
      ACCEPT_TOKEN(anon_sym_delete);
      END_STATE();
    case 256:
      ACCEPT_TOKEN(anon_sym_export);
      END_STATE();
    case 257:
      if (lookahead == 's') ADVANCE(291);
      END_STATE();
    case 258:
      if (lookahead == 'y') ADVANCE(292);
      END_STATE();
    case 259:
      if (lookahead == 'o') ADVANCE(293);
      END_STATE();
    case 260:
      ACCEPT_TOKEN(anon_sym_global);
      END_STATE();
    case 261:
      if (lookahead == 'e') ADVANCE(294);
      END_STATE();
    case 262:
      ACCEPT_TOKEN(anon_sym_import);
      END_STATE();
    case 263:
      if (lookahead == 'c') ADVANCE(295);
      END_STATE();
    case 264:
      if (lookahead == 'a') ADVANCE(296);
      END_STATE();
    case 265:
      ACCEPT_TOKEN(anon_sym_module);
      END_STATE();
    case 266:
      if (lookahead == 'a') ADVANCE(297);
      END_STATE();
    case 267:
      ACCEPT_TOKEN(anon_sym_number);
      END_STATE();
    case 268:
      ACCEPT_TOKEN(anon_sym_object);
      END_STATE();
    case 269:
      if (lookahead == 'd') ADVANCE(298);
      END_STATE();
    case 270:
      if (lookahead == 'e') ADVANCE(299);
      END_STATE();
    case 271:
      if (lookahead == 't') ADVANCE(300);
      END_STATE();
    case 272:
      ACCEPT_TOKEN(anon_sym_public);
      END_STATE();
    case 273:
      if (lookahead == 'l') ADVANCE(301);
      END_STATE();
    case 274:
      if (lookahead == 'e') ADVANCE(302);
      END_STATE();
    case 275:
      ACCEPT_TOKEN(anon_sym_return);
      END_STATE();
    case 276:
      ACCEPT_TOKEN(anon_sym_static);
      END_STATE();
    case 277:
      ACCEPT_TOKEN(anon_sym_string);
      END_STATE();
    case 278:
      ACCEPT_TOKEN(anon_sym_switch);
      END_STATE();
    case 279:
      ACCEPT_TOKEN(anon_sym_symbol);
      END_STATE();
    case 280:
      ACCEPT_TOKEN(anon_sym_target);
      END_STATE();
    case 281:
      ACCEPT_TOKEN(anon_sym_typeof);
      END_STATE();
    case 282:
      if (lookahead == 'n') ADVANCE(303);
      END_STATE();
    case 283:
      if (lookahead == 'n') ADVANCE(304);
      END_STATE();
    case 284:
      if (lookahead == 't') ADVANCE(305);
      END_STATE();
    case 285:
      ACCEPT_TOKEN(anon_sym_asserts);
      END_STATE();
    case 286:
      ACCEPT_TOKEN(anon_sym_boolean);
      END_STATE();
    case 287:
      if (lookahead == 'e') ADVANCE(306);
      END_STATE();
    case 288:
      if (lookahead == 'r') ADVANCE(307);
      END_STATE();
    case 289:
      ACCEPT_TOKEN(anon_sym_declare);
      END_STATE();
    case 290:
      ACCEPT_TOKEN(anon_sym_default);
      END_STATE();
    case 291:
      ACCEPT_TOKEN(anon_sym_extends);
      END_STATE();
    case 292:
      ACCEPT_TOKEN(anon_sym_finally);
      END_STATE();
    case 293:
      if (lookahead == 'n') ADVANCE(308);
      END_STATE();
    case 294:
      if (lookahead == 'n') ADVANCE(309);
      END_STATE();
    case 295:
      if (lookahead == 'e') ADVANCE(310);
      END_STATE();
    case 296:
      if (lookahead == 'c') ADVANCE(311);
      END_STATE();
    case 297:
      if (lookahead == 'c') ADVANCE(312);
      END_STATE();
    case 298:
      if (lookahead == 'e') ADVANCE(313);
      END_STATE();
    case 299:
      ACCEPT_TOKEN(anon_sym_private);
      END_STATE();
    case 300:
      if (lookahead == 'e') ADVANCE(314);
      END_STATE();
    case 301:
      if (lookahead == 'y') ADVANCE(315);
      END_STATE();
    case 302:
      ACCEPT_TOKEN(anon_sym_require);
      END_STATE();
    case 303:
      if (lookahead == 'e') ADVANCE(316);
      END_STATE();
    case 304:
      ACCEPT_TOKEN(anon_sym_unknown);
      END_STATE();
    case 305:
      ACCEPT_TOKEN(anon_sym_abstract);
      END_STATE();
    case 306:
      ACCEPT_TOKEN(anon_sym_continue);
      END_STATE();
    case 307:
      ACCEPT_TOKEN(anon_sym_debugger);
      END_STATE();
    case 308:
      ACCEPT_TOKEN(anon_sym_function);
      END_STATE();
    case 309:
      if (lookahead == 't') ADVANCE(317);
      END_STATE();
    case 310:
      if (lookahead == 'o') ADVANCE(318);
      END_STATE();
    case 311:
      if (lookahead == 'e') ADVANCE(319);
      END_STATE();
    case 312:
      if (lookahead == 'e') ADVANCE(320);
      END_STATE();
    case 313:
      ACCEPT_TOKEN(anon_sym_override);
      END_STATE();
    case 314:
      if (lookahead == 'd') ADVANCE(321);
      END_STATE();
    case 315:
      ACCEPT_TOKEN(anon_sym_readonly);
      END_STATE();
    case 316:
      if (lookahead == 'd') ADVANCE(322);
      END_STATE();
    case 317:
      if (lookahead == 's') ADVANCE(323);
      END_STATE();
    case 318:
      if (lookahead == 'f') ADVANCE(324);
      END_STATE();
    case 319:
      ACCEPT_TOKEN(anon_sym_interface);
      END_STATE();
    case 320:
      ACCEPT_TOKEN(anon_sym_namespace);
      END_STATE();
    case 321:
      ACCEPT_TOKEN(anon_sym_protected);
      END_STATE();
    case 322:
      ACCEPT_TOKEN(sym_undefined);
      END_STATE();
    case 323:
      ACCEPT_TOKEN(anon_sym_implements);
      END_STATE();
    case 324:
      ACCEPT_TOKEN(anon_sym_instanceof);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0, .external_lex_state = 1},
  [1] = {.lex_state = 71},
  [2] = {.lex_state = 2, .external_lex_state = 2},
  [3] = {.lex_state = 2, .external_lex_state = 2},
  [4] = {.lex_state = 71},
  [5] = {.lex_state = 71},
  [6] = {.lex_state = 71},
  [7] = {.lex_state = 71},
  [8] = {.lex_state = 71},
  [9] = {.lex_state = 71},
  [10] = {.lex_state = 71},
  [11] = {.lex_state = 71},
  [12] = {.lex_state = 71},
  [13] = {.lex_state = 71},
  [14] = {.lex_state = 71},
  [15] = {.lex_state = 71},
  [16] = {.lex_state = 71},
  [17] = {.lex_state = 71},
  [18] = {.lex_state = 71},
  [19] = {.lex_state = 71},
  [20] = {.lex_state = 71},
  [21] = {.lex_state = 71},
  [22] = {.lex_state = 71},
  [23] = {.lex_state = 71},
  [24] = {.lex_state = 71},
  [25] = {.lex_state = 71},
  [26] = {.lex_state = 71},
  [27] = {.lex_state = 71},
  [28] = {.lex_state = 71},
  [29] = {.lex_state = 71},
  [30] = {.lex_state = 71},
  [31] = {.lex_state = 71},
  [32] = {.lex_state = 71},
  [33] = {.lex_state = 71},
  [34] = {.lex_state = 71},
  [35] = {.lex_state = 71},
  [36] = {.lex_state = 71},
  [37] = {.lex_state = 71},
  [38] = {.lex_state = 71},
  [39] = {.lex_state = 71},
  [40] = {.lex_state = 71},
  [41] = {.lex_state = 71},
  [42] = {.lex_state = 71},
  [43] = {.lex_state = 71},
  [44] = {.lex_state = 71},
  [45] = {.lex_state = 71},
  [46] = {.lex_state = 71},
  [47] = {.lex_state = 71},
  [48] = {.lex_state = 7},
  [49] = {.lex_state = 7},
  [50] = {.lex_state = 7},
  [51] = {.lex_state = 7},
  [52] = {.lex_state = 7},
  [53] = {.lex_state = 7},
  [54] = {.lex_state = 7},
  [55] = {.lex_state = 7},
  [56] = {.lex_state = 7},
  [57] = {.lex_state = 7},
  [58] = {.lex_state = 3, .external_lex_state = 2},
  [59] = {.lex_state = 3, .external_lex_state = 2},
  [60] = {.lex_state = 3, .external_lex_state = 2},
  [61] = {.lex_state = 3, .external_lex_state = 2},
  [62] = {.lex_state = 3, .external_lex_state = 2},
  [63] = {.lex_state = 3, .external_lex_state = 2},
  [64] = {.lex_state = 3, .external_lex_state = 2},
  [65] = {.lex_state = 3, .external_lex_state = 2},
  [66] = {.lex_state = 7},
  [67] = {.lex_state = 7},
  [68] = {.lex_state = 7},
  [69] = {.lex_state = 7},
  [70] = {.lex_state = 7},
  [71] = {.lex_state = 7},
  [72] = {.lex_state = 7},
  [73] = {.lex_state = 7},
  [74] = {.lex_state = 7},
  [75] = {.lex_state = 7},
  [76] = {.lex_state = 7},
  [77] = {.lex_state = 7},
  [78] = {.lex_state = 7},
  [79] = {.lex_state = 7},
  [80] = {.lex_state = 7},
  [81] = {.lex_state = 7},
  [82] = {.lex_state = 7},
  [83] = {.lex_state = 7},
  [84] = {.lex_state = 7},
  [85] = {.lex_state = 7},
  [86] = {.lex_state = 70, .external_lex_state = 2},
  [87] = {.lex_state = 70, .external_lex_state = 3},
  [88] = {.lex_state = 70, .external_lex_state = 3},
  [89] = {.lex_state = 70, .external_lex_state = 2},
  [90] = {.lex_state = 70, .external_lex_state = 3},
  [91] = {.lex_state = 70, .external_lex_state = 2},
  [92] = {.lex_state = 70, .external_lex_state = 2},
  [93] = {.lex_state = 70, .external_lex_state = 2},
  [94] = {.lex_state = 2, .external_lex_state = 2},
  [95] = {.lex_state = 71},
  [96] = {.lex_state = 2, .external_lex_state = 3},
  [97] = {.lex_state = 2, .external_lex_state = 3},
  [98] = {.lex_state = 71},
  [99] = {.lex_state = 71},
  [100] = {.lex_state = 71},
  [101] = {.lex_state = 71},
  [102] = {.lex_state = 71},
  [103] = {.lex_state = 2, .external_lex_state = 2},
  [104] = {.lex_state = 2, .external_lex_state = 2},
  [105] = {.lex_state = 2, .external_lex_state = 2},
  [106] = {.lex_state = 2, .external_lex_state = 3},
  [107] = {.lex_state = 2, .external_lex_state = 2},
  [108] = {.lex_state = 2, .external_lex_state = 2},
  [109] = {.lex_state = 2, .external_lex_state = 2},
  [110] = {.lex_state = 2, .external_lex_state = 2},
  [111] = {.lex_state = 2, .external_lex_state = 2},
  [112] = {.lex_state = 2, .external_lex_state = 2},
  [113] = {.lex_state = 70, .external_lex_state = 3},
  [114] = {.lex_state = 70, .external_lex_state = 3},
  [115] = {.lex_state = 70, .external_lex_state = 3},
  [116] = {.lex_state = 70, .external_lex_state = 3},
  [117] = {.lex_state = 71},
  [118] = {.lex_state = 70, .external_lex_state = 3},
  [119] = {.lex_state = 70, .external_lex_state = 3},
  [120] = {.lex_state = 70, .external_lex_state = 3},
  [121] = {.lex_state = 70, .external_lex_state = 3},
  [122] = {.lex_state = 70, .external_lex_state = 3},
  [123] = {.lex_state = 70, .external_lex_state = 3},
  [124] = {.lex_state = 71},
  [125] = {.lex_state = 70, .external_lex_state = 3},
  [126] = {.lex_state = 70, .external_lex_state = 3},
  [127] = {.lex_state = 70, .external_lex_state = 3},
  [128] = {.lex_state = 70, .external_lex_state = 3},
  [129] = {.lex_state = 70, .external_lex_state = 3},
  [130] = {.lex_state = 70, .external_lex_state = 3},
  [131] = {.lex_state = 70, .external_lex_state = 3},
  [132] = {.lex_state = 70, .external_lex_state = 3},
  [133] = {.lex_state = 70, .external_lex_state = 3},
  [134] = {.lex_state = 70, .external_lex_state = 3},
  [135] = {.lex_state = 70, .external_lex_state = 3},
  [136] = {.lex_state = 70, .external_lex_state = 3},
  [137] = {.lex_state = 70, .external_lex_state = 3},
  [138] = {.lex_state = 70, .external_lex_state = 3},
  [139] = {.lex_state = 70, .external_lex_state = 3},
  [140] = {.lex_state = 70, .external_lex_state = 3},
  [141] = {.lex_state = 70, .external_lex_state = 3},
  [142] = {.lex_state = 71},
  [143] = {.lex_state = 71},
  [144] = {.lex_state = 71},
  [145] = {.lex_state = 71},
  [146] = {.lex_state = 71},
  [147] = {.lex_state = 71},
  [148] = {.lex_state = 71},
  [149] = {.lex_state = 71},
  [150] = {.lex_state = 71},
  [151] = {.lex_state = 71},
  [152] = {.lex_state = 71},
  [153] = {.lex_state = 71},
  [154] = {.lex_state = 71},
  [155] = {.lex_state = 71},
  [156] = {.lex_state = 71},
  [157] = {.lex_state = 71},
  [158] = {.lex_state = 71},
  [159] = {.lex_state = 71},
  [160] = {.lex_state = 71},
  [161] = {.lex_state = 71},
  [162] = {.lex_state = 71},
  [163] = {.lex_state = 71, .external_lex_state = 4},
  [164] = {.lex_state = 71},
  [165] = {.lex_state = 3, .external_lex_state = 2},
  [166] = {.lex_state = 71},
  [167] = {.lex_state = 3, .external_lex_state = 2},
  [168] = {.lex_state = 71},
  [169] = {.lex_state = 71},
  [170] = {.lex_state = 71},
  [171] = {.lex_state = 3, .external_lex_state = 2},
  [172] = {.lex_state = 71},
  [173] = {.lex_state = 71},
  [174] = {.lex_state = 3, .external_lex_state = 2},
  [175] = {.lex_state = 71},
  [176] = {.lex_state = 71},
  [177] = {.lex_state = 71},
  [178] = {.lex_state = 71},
  [179] = {.lex_state = 71},
  [180] = {.lex_state = 71},
  [181] = {.lex_state = 71},
  [182] = {.lex_state = 71},
  [183] = {.lex_state = 71},
  [184] = {.lex_state = 71},
  [185] = {.lex_state = 3, .external_lex_state = 3},
  [186] = {.lex_state = 71},
  [187] = {.lex_state = 71},
  [188] = {.lex_state = 71},
  [189] = {.lex_state = 71},
  [190] = {.lex_state = 3, .external_lex_state = 3},
  [191] = {.lex_state = 3, .external_lex_state = 3},
  [192] = {.lex_state = 71},
  [193] = {.lex_state = 71},
  [194] = {.lex_state = 71},
  [195] = {.lex_state = 71},
  [196] = {.lex_state = 71},
  [197] = {.lex_state = 71},
  [198] = {.lex_state = 71},
  [199] = {.lex_state = 71},
  [200] = {.lex_state = 71},
  [201] = {.lex_state = 71},
  [202] = {.lex_state = 71},
  [203] = {.lex_state = 71},
  [204] = {.lex_state = 71},
  [205] = {.lex_state = 71},
  [206] = {.lex_state = 71},
  [207] = {.lex_state = 71},
  [208] = {.lex_state = 71, .external_lex_state = 4},
  [209] = {.lex_state = 71},
  [210] = {.lex_state = 71},
  [211] = {.lex_state = 71},
  [212] = {.lex_state = 71},
  [213] = {.lex_state = 71},
  [214] = {.lex_state = 71},
  [215] = {.lex_state = 71},
  [216] = {.lex_state = 71},
  [217] = {.lex_state = 71},
  [218] = {.lex_state = 71},
  [219] = {.lex_state = 71},
  [220] = {.lex_state = 71},
  [221] = {.lex_state = 2, .external_lex_state = 3},
  [222] = {.lex_state = 2, .external_lex_state = 3},
  [223] = {.lex_state = 71},
  [224] = {.lex_state = 2, .external_lex_state = 3},
  [225] = {.lex_state = 71},
  [226] = {.lex_state = 71},
  [227] = {.lex_state = 71},
  [228] = {.lex_state = 71},
  [229] = {.lex_state = 71},
  [230] = {.lex_state = 71},
  [231] = {.lex_state = 71},
  [232] = {.lex_state = 71},
  [233] = {.lex_state = 71},
  [234] = {.lex_state = 71},
  [235] = {.lex_state = 71},
  [236] = {.lex_state = 71},
  [237] = {.lex_state = 71},
  [238] = {.lex_state = 71},
  [239] = {.lex_state = 71},
  [240] = {.lex_state = 71},
  [241] = {.lex_state = 71},
  [242] = {.lex_state = 3, .external_lex_state = 3},
  [243] = {.lex_state = 71},
  [244] = {.lex_state = 71},
  [245] = {.lex_state = 71},
  [246] = {.lex_state = 71},
  [247] = {.lex_state = 71},
  [248] = {.lex_state = 71},
  [249] = {.lex_state = 71},
  [250] = {.lex_state = 71},
  [251] = {.lex_state = 71},
  [252] = {.lex_state = 71},
  [253] = {.lex_state = 71},
  [254] = {.lex_state = 71},
  [255] = {.lex_state = 71},
  [256] = {.lex_state = 71},
  [257] = {.lex_state = 71},
  [258] = {.lex_state = 71},
  [259] = {.lex_state = 71},
  [260] = {.lex_state = 71},
  [261] = {.lex_state = 3, .external_lex_state = 3},
  [262] = {.lex_state = 71},
  [263] = {.lex_state = 71},
  [264] = {.lex_state = 71},
  [265] = {.lex_state = 71},
  [266] = {.lex_state = 71},
  [267] = {.lex_state = 71},
  [268] = {.lex_state = 71},
  [269] = {.lex_state = 71},
  [270] = {.lex_state = 71},
  [271] = {.lex_state = 71},
  [272] = {.lex_state = 71},
  [273] = {.lex_state = 71},
  [274] = {.lex_state = 71},
  [275] = {.lex_state = 71},
  [276] = {.lex_state = 71},
  [277] = {.lex_state = 71},
  [278] = {.lex_state = 71},
  [279] = {.lex_state = 71},
  [280] = {.lex_state = 71},
  [281] = {.lex_state = 71},
  [282] = {.lex_state = 71},
  [283] = {.lex_state = 71},
  [284] = {.lex_state = 71},
  [285] = {.lex_state = 71},
  [286] = {.lex_state = 71},
  [287] = {.lex_state = 71},
  [288] = {.lex_state = 71},
  [289] = {.lex_state = 71},
  [290] = {.lex_state = 71},
  [291] = {.lex_state = 71},
  [292] = {.lex_state = 71},
  [293] = {.lex_state = 71},
  [294] = {.lex_state = 71},
  [295] = {.lex_state = 71},
  [296] = {.lex_state = 71},
  [297] = {.lex_state = 71},
  [298] = {.lex_state = 71},
  [299] = {.lex_state = 71},
  [300] = {.lex_state = 71},
  [301] = {.lex_state = 71},
  [302] = {.lex_state = 71},
  [303] = {.lex_state = 71},
  [304] = {.lex_state = 71},
  [305] = {.lex_state = 71},
  [306] = {.lex_state = 71},
  [307] = {.lex_state = 71},
  [308] = {.lex_state = 71},
  [309] = {.lex_state = 71},
  [310] = {.lex_state = 71},
  [311] = {.lex_state = 71},
  [312] = {.lex_state = 71},
  [313] = {.lex_state = 71},
  [314] = {.lex_state = 71},
  [315] = {.lex_state = 71},
  [316] = {.lex_state = 71},
  [317] = {.lex_state = 71},
  [318] = {.lex_state = 71},
  [319] = {.lex_state = 71},
  [320] = {.lex_state = 71},
  [321] = {.lex_state = 71},
  [322] = {.lex_state = 71},
  [323] = {.lex_state = 71},
  [324] = {.lex_state = 71},
  [325] = {.lex_state = 71},
  [326] = {.lex_state = 71},
  [327] = {.lex_state = 71},
  [328] = {.lex_state = 71},
  [329] = {.lex_state = 71},
  [330] = {.lex_state = 71},
  [331] = {.lex_state = 71},
  [332] = {.lex_state = 71},
  [333] = {.lex_state = 71},
  [334] = {.lex_state = 71},
  [335] = {.lex_state = 71},
  [336] = {.lex_state = 71},
  [337] = {.lex_state = 71},
  [338] = {.lex_state = 71},
  [339] = {.lex_state = 71},
  [340] = {.lex_state = 71},
  [341] = {.lex_state = 71},
  [342] = {.lex_state = 71},
  [343] = {.lex_state = 71},
  [344] = {.lex_state = 71},
  [345] = {.lex_state = 71},
  [346] = {.lex_state = 71},
  [347] = {.lex_state = 71},
  [348] = {.lex_state = 71},
  [349] = {.lex_state = 71},
  [350] = {.lex_state = 71},
  [351] = {.lex_state = 71},
  [352] = {.lex_state = 71},
  [353] = {.lex_state = 71},
  [354] = {.lex_state = 71},
  [355] = {.lex_state = 71},
  [356] = {.lex_state = 71},
  [357] = {.lex_state = 71},
  [358] = {.lex_state = 71},
  [359] = {.lex_state = 71},
  [360] = {.lex_state = 71},
  [361] = {.lex_state = 71},
  [362] = {.lex_state = 71},
  [363] = {.lex_state = 71},
  [364] = {.lex_state = 71},
  [365] = {.lex_state = 71},
  [366] = {.lex_state = 71},
  [367] = {.lex_state = 71},
  [368] = {.lex_state = 71},
  [369] = {.lex_state = 71},
  [370] = {.lex_state = 71},
  [371] = {.lex_state = 71},
  [372] = {.lex_state = 71},
  [373] = {.lex_state = 71},
  [374] = {.lex_state = 71},
  [375] = {.lex_state = 71},
  [376] = {.lex_state = 71},
  [377] = {.lex_state = 71},
  [378] = {.lex_state = 71},
  [379] = {.lex_state = 71},
  [380] = {.lex_state = 71},
  [381] = {.lex_state = 71},
  [382] = {.lex_state = 71},
  [383] = {.lex_state = 71},
  [384] = {.lex_state = 71},
  [385] = {.lex_state = 71},
  [386] = {.lex_state = 71},
  [387] = {.lex_state = 2, .external_lex_state = 3},
  [388] = {.lex_state = 71},
  [389] = {.lex_state = 71},
  [390] = {.lex_state = 71},
  [391] = {.lex_state = 71},
  [392] = {.lex_state = 71},
  [393] = {.lex_state = 71},
  [394] = {.lex_state = 71},
  [395] = {.lex_state = 71},
  [396] = {.lex_state = 71},
  [397] = {.lex_state = 71},
  [398] = {.lex_state = 71},
  [399] = {.lex_state = 71},
  [400] = {.lex_state = 71},
  [401] = {.lex_state = 71},
  [402] = {.lex_state = 71},
  [403] = {.lex_state = 71},
  [404] = {.lex_state = 71},
  [405] = {.lex_state = 71},
  [406] = {.lex_state = 71},
  [407] = {.lex_state = 71},
  [408] = {.lex_state = 71},
  [409] = {.lex_state = 71},
  [410] = {.lex_state = 71},
  [411] = {.lex_state = 71},
  [412] = {.lex_state = 71},
  [413] = {.lex_state = 71},
  [414] = {.lex_state = 71},
  [415] = {.lex_state = 71},
  [416] = {.lex_state = 71},
  [417] = {.lex_state = 71},
  [418] = {.lex_state = 71},
  [419] = {.lex_state = 71},
  [420] = {.lex_state = 71},
  [421] = {.lex_state = 71},
  [422] = {.lex_state = 71},
  [423] = {.lex_state = 71},
  [424] = {.lex_state = 71},
  [425] = {.lex_state = 71},
  [426] = {.lex_state = 71},
  [427] = {.lex_state = 71},
  [428] = {.lex_state = 71},
  [429] = {.lex_state = 71},
  [430] = {.lex_state = 71},
  [431] = {.lex_state = 71},
  [432] = {.lex_state = 71},
  [433] = {.lex_state = 71},
  [434] = {.lex_state = 71},
  [435] = {.lex_state = 71},
  [436] = {.lex_state = 71},
  [437] = {.lex_state = 71},
  [438] = {.lex_state = 71},
  [439] = {.lex_state = 71},
  [440] = {.lex_state = 71},
  [441] = {.lex_state = 71},
  [442] = {.lex_state = 71},
  [443] = {.lex_state = 71},
  [444] = {.lex_state = 71},
  [445] = {.lex_state = 71},
  [446] = {.lex_state = 71},
  [447] = {.lex_state = 71},
  [448] = {.lex_state = 71},
  [449] = {.lex_state = 71},
  [450] = {.lex_state = 71},
  [451] = {.lex_state = 71},
  [452] = {.lex_state = 71},
  [453] = {.lex_state = 71},
  [454] = {.lex_state = 71},
  [455] = {.lex_state = 71},
  [456] = {.lex_state = 71},
  [457] = {.lex_state = 71},
  [458] = {.lex_state = 71},
  [459] = {.lex_state = 71},
  [460] = {.lex_state = 2, .external_lex_state = 3},
  [461] = {.lex_state = 71},
  [462] = {.lex_state = 71},
  [463] = {.lex_state = 71},
  [464] = {.lex_state = 71},
  [465] = {.lex_state = 71},
  [466] = {.lex_state = 71},
  [467] = {.lex_state = 71},
  [468] = {.lex_state = 71},
  [469] = {.lex_state = 71},
  [470] = {.lex_state = 71},
  [471] = {.lex_state = 71},
  [472] = {.lex_state = 71},
  [473] = {.lex_state = 71},
  [474] = {.lex_state = 71},
  [475] = {.lex_state = 71},
  [476] = {.lex_state = 71},
  [477] = {.lex_state = 71},
  [478] = {.lex_state = 71},
  [479] = {.lex_state = 71},
  [480] = {.lex_state = 71},
  [481] = {.lex_state = 71},
  [482] = {.lex_state = 71},
  [483] = {.lex_state = 71},
  [484] = {.lex_state = 71},
  [485] = {.lex_state = 71},
  [486] = {.lex_state = 71},
  [487] = {.lex_state = 71},
  [488] = {.lex_state = 71},
  [489] = {.lex_state = 71},
  [490] = {.lex_state = 71},
  [491] = {.lex_state = 71},
  [492] = {.lex_state = 71},
  [493] = {.lex_state = 71},
  [494] = {.lex_state = 71},
  [495] = {.lex_state = 71},
  [496] = {.lex_state = 71},
  [497] = {.lex_state = 71},
  [498] = {.lex_state = 71},
  [499] = {.lex_state = 71},
  [500] = {.lex_state = 71},
  [501] = {.lex_state = 2, .external_lex_state = 3},
  [502] = {.lex_state = 71},
  [503] = {.lex_state = 71},
  [504] = {.lex_state = 71},
  [505] = {.lex_state = 71},
  [506] = {.lex_state = 71},
  [507] = {.lex_state = 71},
  [508] = {.lex_state = 71},
  [509] = {.lex_state = 71},
  [510] = {.lex_state = 71},
  [511] = {.lex_state = 71},
  [512] = {.lex_state = 71},
  [513] = {.lex_state = 71},
  [514] = {.lex_state = 71},
  [515] = {.lex_state = 71},
  [516] = {.lex_state = 71},
  [517] = {.lex_state = 71},
  [518] = {.lex_state = 71},
  [519] = {.lex_state = 71},
  [520] = {.lex_state = 71},
  [521] = {.lex_state = 71},
  [522] = {.lex_state = 71},
  [523] = {.lex_state = 71},
  [524] = {.lex_state = 71},
  [525] = {.lex_state = 71},
  [526] = {.lex_state = 71},
  [527] = {.lex_state = 2, .external_lex_state = 3},
  [528] = {.lex_state = 2, .external_lex_state = 3},
  [529] = {.lex_state = 2, .external_lex_state = 3},
  [530] = {.lex_state = 2, .external_lex_state = 3},
  [531] = {.lex_state = 2, .external_lex_state = 3},
  [532] = {.lex_state = 2, .external_lex_state = 3},
  [533] = {.lex_state = 2, .external_lex_state = 3},
  [534] = {.lex_state = 2, .external_lex_state = 3},
  [535] = {.lex_state = 2, .external_lex_state = 3},
  [536] = {.lex_state = 2, .external_lex_state = 3},
  [537] = {.lex_state = 2, .external_lex_state = 3},
  [538] = {.lex_state = 2, .external_lex_state = 3},
  [539] = {.lex_state = 2, .external_lex_state = 3},
  [540] = {.lex_state = 71},
  [541] = {.lex_state = 71},
  [542] = {.lex_state = 71},
  [543] = {.lex_state = 71},
  [544] = {.lex_state = 71},
  [545] = {.lex_state = 71},
  [546] = {.lex_state = 71},
  [547] = {.lex_state = 2, .external_lex_state = 3},
  [548] = {.lex_state = 2, .external_lex_state = 3},
  [549] = {.lex_state = 2, .external_lex_state = 3},
  [550] = {.lex_state = 2, .external_lex_state = 3},
  [551] = {.lex_state = 2, .external_lex_state = 3},
  [552] = {.lex_state = 2, .external_lex_state = 3},
  [553] = {.lex_state = 2, .external_lex_state = 2},
  [554] = {.lex_state = 2, .external_lex_state = 2},
  [555] = {.lex_state = 2, .external_lex_state = 2},
  [556] = {.lex_state = 2, .external_lex_state = 2},
  [557] = {.lex_state = 2, .external_lex_state = 2},
  [558] = {.lex_state = 2, .external_lex_state = 3},
  [559] = {.lex_state = 2, .external_lex_state = 3},
  [560] = {.lex_state = 2, .external_lex_state = 2},
  [561] = {.lex_state = 2, .external_lex_state = 3},
  [562] = {.lex_state = 2, .external_lex_state = 3},
  [563] = {.lex_state = 2, .external_lex_state = 3},
  [564] = {.lex_state = 2, .external_lex_state = 3},
  [565] = {.lex_state = 2, .external_lex_state = 3},
  [566] = {.lex_state = 3, .external_lex_state = 2},
  [567] = {.lex_state = 2, .external_lex_state = 2},
  [568] = {.lex_state = 3, .external_lex_state = 2},
  [569] = {.lex_state = 71},
  [570] = {.lex_state = 71, .external_lex_state = 4},
  [571] = {.lex_state = 71, .external_lex_state = 4},
  [572] = {.lex_state = 2, .external_lex_state = 2},
  [573] = {.lex_state = 71, .external_lex_state = 4},
  [574] = {.lex_state = 2, .external_lex_state = 3},
  [575] = {.lex_state = 71, .external_lex_state = 4},
  [576] = {.lex_state = 2, .external_lex_state = 2},
  [577] = {.lex_state = 2, .external_lex_state = 2},
  [578] = {.lex_state = 2, .external_lex_state = 2},
  [579] = {.lex_state = 71},
  [580] = {.lex_state = 2, .external_lex_state = 3},
  [581] = {.lex_state = 2, .external_lex_state = 3},
  [582] = {.lex_state = 71, .external_lex_state = 4},
  [583] = {.lex_state = 2, .external_lex_state = 2},
  [584] = {.lex_state = 2, .external_lex_state = 3},
  [585] = {.lex_state = 71, .external_lex_state = 4},
  [586] = {.lex_state = 71},
  [587] = {.lex_state = 2, .external_lex_state = 3},
  [588] = {.lex_state = 71, .external_lex_state = 4},
  [589] = {.lex_state = 71, .external_lex_state = 4},
  [590] = {.lex_state = 2, .external_lex_state = 2},
  [591] = {.lex_state = 2, .external_lex_state = 2},
  [592] = {.lex_state = 71},
  [593] = {.lex_state = 2, .external_lex_state = 2},
  [594] = {.lex_state = 2, .external_lex_state = 2},
  [595] = {.lex_state = 71},
  [596] = {.lex_state = 71},
  [597] = {.lex_state = 71, .external_lex_state = 4},
  [598] = {.lex_state = 71, .external_lex_state = 4},
  [599] = {.lex_state = 71},
  [600] = {.lex_state = 71, .external_lex_state = 4},
  [601] = {.lex_state = 71, .external_lex_state = 4},
  [602] = {.lex_state = 71, .external_lex_state = 4},
  [603] = {.lex_state = 71},
  [604] = {.lex_state = 71},
  [605] = {.lex_state = 71, .external_lex_state = 4},
  [606] = {.lex_state = 2, .external_lex_state = 2},
  [607] = {.lex_state = 71, .external_lex_state = 4},
  [608] = {.lex_state = 71, .external_lex_state = 4},
  [609] = {.lex_state = 71, .external_lex_state = 4},
  [610] = {.lex_state = 71, .external_lex_state = 4},
  [611] = {.lex_state = 71},
  [612] = {.lex_state = 71, .external_lex_state = 4},
  [613] = {.lex_state = 71, .external_lex_state = 4},
  [614] = {.lex_state = 71},
  [615] = {.lex_state = 71},
  [616] = {.lex_state = 71},
  [617] = {.lex_state = 71},
  [618] = {.lex_state = 71},
  [619] = {.lex_state = 71},
  [620] = {.lex_state = 71},
  [621] = {.lex_state = 71},
  [622] = {.lex_state = 71},
  [623] = {.lex_state = 71},
  [624] = {.lex_state = 71},
  [625] = {.lex_state = 71},
  [626] = {.lex_state = 71},
  [627] = {.lex_state = 71},
  [628] = {.lex_state = 71},
  [629] = {.lex_state = 71},
  [630] = {.lex_state = 71},
  [631] = {.lex_state = 71},
  [632] = {.lex_state = 71},
  [633] = {.lex_state = 71},
  [634] = {.lex_state = 71},
  [635] = {.lex_state = 71},
  [636] = {.lex_state = 71},
  [637] = {.lex_state = 71},
  [638] = {.lex_state = 71},
  [639] = {.lex_state = 71},
  [640] = {.lex_state = 71},
  [641] = {.lex_state = 71},
  [642] = {.lex_state = 71},
  [643] = {.lex_state = 71},
  [644] = {.lex_state = 71},
  [645] = {.lex_state = 71},
  [646] = {.lex_state = 71},
  [647] = {.lex_state = 71},
  [648] = {.lex_state = 71},
  [649] = {.lex_state = 71},
  [650] = {.lex_state = 71},
  [651] = {.lex_state = 71},
  [652] = {.lex_state = 71},
  [653] = {.lex_state = 71},
  [654] = {.lex_state = 71},
  [655] = {.lex_state = 71},
  [656] = {.lex_state = 71},
  [657] = {.lex_state = 71},
  [658] = {.lex_state = 71},
  [659] = {.lex_state = 71},
  [660] = {.lex_state = 71},
  [661] = {.lex_state = 71},
  [662] = {.lex_state = 71},
  [663] = {.lex_state = 71},
  [664] = {.lex_state = 71},
  [665] = {.lex_state = 71},
  [666] = {.lex_state = 71},
  [667] = {.lex_state = 71},
  [668] = {.lex_state = 71},
  [669] = {.lex_state = 71},
  [670] = {.lex_state = 71},
  [671] = {.lex_state = 71},
  [672] = {.lex_state = 71},
  [673] = {.lex_state = 71},
  [674] = {.lex_state = 71},
  [675] = {.lex_state = 71},
  [676] = {.lex_state = 71},
  [677] = {.lex_state = 71},
  [678] = {.lex_state = 71},
  [679] = {.lex_state = 71},
  [680] = {.lex_state = 71},
  [681] = {.lex_state = 71},
  [682] = {.lex_state = 71},
  [683] = {.lex_state = 71},
  [684] = {.lex_state = 71},
  [685] = {.lex_state = 71},
  [686] = {.lex_state = 71},
  [687] = {.lex_state = 71},
  [688] = {.lex_state = 71},
  [689] = {.lex_state = 71},
  [690] = {.lex_state = 71},
  [691] = {.lex_state = 71},
  [692] = {.lex_state = 71},
  [693] = {.lex_state = 71},
  [694] = {.lex_state = 71},
  [695] = {.lex_state = 71},
  [696] = {.lex_state = 71},
  [697] = {.lex_state = 71},
  [698] = {.lex_state = 71},
  [699] = {.lex_state = 71},
  [700] = {.lex_state = 71},
  [701] = {.lex_state = 71},
  [702] = {.lex_state = 71},
  [703] = {.lex_state = 71},
  [704] = {.lex_state = 71},
  [705] = {.lex_state = 71},
  [706] = {.lex_state = 71},
  [707] = {.lex_state = 71},
  [708] = {.lex_state = 71},
  [709] = {.lex_state = 71},
  [710] = {.lex_state = 71},
  [711] = {.lex_state = 71},
  [712] = {.lex_state = 71},
  [713] = {.lex_state = 71},
  [714] = {.lex_state = 71},
  [715] = {.lex_state = 71},
  [716] = {.lex_state = 71},
  [717] = {.lex_state = 71},
  [718] = {.lex_state = 71},
  [719] = {.lex_state = 71},
  [720] = {.lex_state = 71},
  [721] = {.lex_state = 71},
  [722] = {.lex_state = 71},
  [723] = {.lex_state = 71},
  [724] = {.lex_state = 71},
  [725] = {.lex_state = 71},
  [726] = {.lex_state = 71},
  [727] = {.lex_state = 71},
  [728] = {.lex_state = 71},
  [729] = {.lex_state = 71},
  [730] = {.lex_state = 71},
  [731] = {.lex_state = 71},
  [732] = {.lex_state = 71},
  [733] = {.lex_state = 71},
  [734] = {.lex_state = 71},
  [735] = {.lex_state = 71},
  [736] = {.lex_state = 71},
  [737] = {.lex_state = 71},
  [738] = {.lex_state = 71},
  [739] = {.lex_state = 71},
  [740] = {.lex_state = 71},
  [741] = {.lex_state = 71},
  [742] = {.lex_state = 71},
  [743] = {.lex_state = 71},
  [744] = {.lex_state = 71},
  [745] = {.lex_state = 71},
  [746] = {.lex_state = 71},
  [747] = {.lex_state = 71},
  [748] = {.lex_state = 71},
  [749] = {.lex_state = 71},
  [750] = {.lex_state = 71},
  [751] = {.lex_state = 71},
  [752] = {.lex_state = 71},
  [753] = {.lex_state = 71},
  [754] = {.lex_state = 71},
  [755] = {.lex_state = 71},
  [756] = {.lex_state = 71},
  [757] = {.lex_state = 71},
  [758] = {.lex_state = 71},
  [759] = {.lex_state = 71},
  [760] = {.lex_state = 71},
  [761] = {.lex_state = 71},
  [762] = {.lex_state = 71},
  [763] = {.lex_state = 9},
  [764] = {.lex_state = 9},
  [765] = {.lex_state = 9},
  [766] = {.lex_state = 9},
  [767] = {.lex_state = 9},
  [768] = {.lex_state = 9},
  [769] = {.lex_state = 9},
  [770] = {.lex_state = 9},
  [771] = {.lex_state = 9},
  [772] = {.lex_state = 9},
  [773] = {.lex_state = 9},
  [774] = {.lex_state = 9},
  [775] = {.lex_state = 9},
  [776] = {.lex_state = 9},
  [777] = {.lex_state = 9},
  [778] = {.lex_state = 9},
  [779] = {.lex_state = 71},
  [780] = {.lex_state = 71},
  [781] = {.lex_state = 71},
  [782] = {.lex_state = 71},
  [783] = {.lex_state = 71},
  [784] = {.lex_state = 71},
  [785] = {.lex_state = 71},
  [786] = {.lex_state = 71},
  [787] = {.lex_state = 71},
  [788] = {.lex_state = 71},
  [789] = {.lex_state = 71},
  [790] = {.lex_state = 71},
  [791] = {.lex_state = 71},
  [792] = {.lex_state = 8},
  [793] = {.lex_state = 8},
  [794] = {.lex_state = 8},
  [795] = {.lex_state = 2, .external_lex_state = 3},
  [796] = {.lex_state = 2, .external_lex_state = 3},
  [797] = {.lex_state = 2, .external_lex_state = 3},
  [798] = {.lex_state = 2, .external_lex_state = 3},
  [799] = {.lex_state = 2, .external_lex_state = 3},
  [800] = {.lex_state = 9},
  [801] = {.lex_state = 9},
  [802] = {.lex_state = 9},
  [803] = {.lex_state = 2, .external_lex_state = 3},
  [804] = {.lex_state = 11},
  [805] = {.lex_state = 11},
  [806] = {.lex_state = 11},
  [807] = {.lex_state = 11},
  [808] = {.lex_state = 9},
  [809] = {.lex_state = 11},
  [810] = {.lex_state = 9},
  [811] = {.lex_state = 9},
  [812] = {.lex_state = 9},
  [813] = {.lex_state = 9},
  [814] = {.lex_state = 9},
  [815] = {.lex_state = 9},
  [816] = {.lex_state = 9},
  [817] = {.lex_state = 9},
  [818] = {.lex_state = 9},
  [819] = {.lex_state = 9},
  [820] = {.lex_state = 9},
  [821] = {.lex_state = 9},
  [822] = {.lex_state = 9},
  [823] = {.lex_state = 9},
  [824] = {.lex_state = 11},
  [825] = {.lex_state = 11},
  [826] = {.lex_state = 9},
  [827] = {.lex_state = 11},
  [828] = {.lex_state = 9},
  [829] = {.lex_state = 11},
  [830] = {.lex_state = 9},
  [831] = {.lex_state = 9},
  [832] = {.lex_state = 9},
  [833] = {.lex_state = 11},
  [834] = {.lex_state = 11},
  [835] = {.lex_state = 9},
  [836] = {.lex_state = 11},
  [837] = {.lex_state = 9},
  [838] = {.lex_state = 9},
  [839] = {.lex_state = 9},
  [840] = {.lex_state = 9},
  [841] = {.lex_state = 9},
  [842] = {.lex_state = 9},
  [843] = {.lex_state = 9},
  [844] = {.lex_state = 9},
  [845] = {.lex_state = 9},
  [846] = {.lex_state = 2, .external_lex_state = 2},
  [847] = {.lex_state = 9},
  [848] = {.lex_state = 9},
  [849] = {.lex_state = 9},
  [850] = {.lex_state = 9},
  [851] = {.lex_state = 9},
  [852] = {.lex_state = 9},
  [853] = {.lex_state = 9},
  [854] = {.lex_state = 9},
  [855] = {.lex_state = 9},
  [856] = {.lex_state = 9},
  [857] = {.lex_state = 9},
  [858] = {.lex_state = 9},
  [859] = {.lex_state = 9},
  [860] = {.lex_state = 9},
  [861] = {.lex_state = 9},
  [862] = {.lex_state = 9},
  [863] = {.lex_state = 9},
  [864] = {.lex_state = 9},
  [865] = {.lex_state = 9},
  [866] = {.lex_state = 9},
  [867] = {.lex_state = 9},
  [868] = {.lex_state = 9},
  [869] = {.lex_state = 9},
  [870] = {.lex_state = 9},
  [871] = {.lex_state = 9},
  [872] = {.lex_state = 9},
  [873] = {.lex_state = 9},
  [874] = {.lex_state = 9},
  [875] = {.lex_state = 9},
  [876] = {.lex_state = 9},
  [877] = {.lex_state = 9},
  [878] = {.lex_state = 9},
  [879] = {.lex_state = 9},
  [880] = {.lex_state = 9},
  [881] = {.lex_state = 9},
  [882] = {.lex_state = 9},
  [883] = {.lex_state = 9},
  [884] = {.lex_state = 9},
  [885] = {.lex_state = 9},
  [886] = {.lex_state = 9},
  [887] = {.lex_state = 9},
  [888] = {.lex_state = 71},
  [889] = {.lex_state = 9},
  [890] = {.lex_state = 9},
  [891] = {.lex_state = 9},
  [892] = {.lex_state = 9},
  [893] = {.lex_state = 9},
  [894] = {.lex_state = 9},
  [895] = {.lex_state = 9},
  [896] = {.lex_state = 9},
  [897] = {.lex_state = 9},
  [898] = {.lex_state = 9},
  [899] = {.lex_state = 9},
  [900] = {.lex_state = 9},
  [901] = {.lex_state = 9},
  [902] = {.lex_state = 9},
  [903] = {.lex_state = 9},
  [904] = {.lex_state = 9},
  [905] = {.lex_state = 9},
  [906] = {.lex_state = 9},
  [907] = {.lex_state = 9},
  [908] = {.lex_state = 9},
  [909] = {.lex_state = 9},
  [910] = {.lex_state = 9},
  [911] = {.lex_state = 9},
  [912] = {.lex_state = 9},
  [913] = {.lex_state = 9},
  [914] = {.lex_state = 9},
  [915] = {.lex_state = 9},
  [916] = {.lex_state = 9},
  [917] = {.lex_state = 9},
  [918] = {.lex_state = 9},
  [919] = {.lex_state = 9},
  [920] = {.lex_state = 9},
  [921] = {.lex_state = 9},
  [922] = {.lex_state = 9},
  [923] = {.lex_state = 9},
  [924] = {.lex_state = 9},
  [925] = {.lex_state = 9},
  [926] = {.lex_state = 9},
  [927] = {.lex_state = 2, .external_lex_state = 2},
  [928] = {.lex_state = 9},
  [929] = {.lex_state = 9},
  [930] = {.lex_state = 9},
  [931] = {.lex_state = 9},
  [932] = {.lex_state = 9},
  [933] = {.lex_state = 9},
  [934] = {.lex_state = 9},
  [935] = {.lex_state = 9},
  [936] = {.lex_state = 9},
  [937] = {.lex_state = 9},
  [938] = {.lex_state = 9},
  [939] = {.lex_state = 9},
  [940] = {.lex_state = 9},
  [941] = {.lex_state = 9},
  [942] = {.lex_state = 9},
  [943] = {.lex_state = 9},
  [944] = {.lex_state = 9},
  [945] = {.lex_state = 9},
  [946] = {.lex_state = 9},
  [947] = {.lex_state = 9},
  [948] = {.lex_state = 9},
  [949] = {.lex_state = 9},
  [950] = {.lex_state = 9},
  [951] = {.lex_state = 9},
  [952] = {.lex_state = 9},
  [953] = {.lex_state = 9},
  [954] = {.lex_state = 2, .external_lex_state = 2},
  [955] = {.lex_state = 9},
  [956] = {.lex_state = 9},
  [957] = {.lex_state = 9},
  [958] = {.lex_state = 9},
  [959] = {.lex_state = 9},
  [960] = {.lex_state = 9},
  [961] = {.lex_state = 9},
  [962] = {.lex_state = 9},
  [963] = {.lex_state = 71},
  [964] = {.lex_state = 9},
  [965] = {.lex_state = 9},
  [966] = {.lex_state = 9},
  [967] = {.lex_state = 9},
  [968] = {.lex_state = 9},
  [969] = {.lex_state = 9},
  [970] = {.lex_state = 9},
  [971] = {.lex_state = 71},
  [972] = {.lex_state = 9},
  [973] = {.lex_state = 9},
  [974] = {.lex_state = 9},
  [975] = {.lex_state = 9},
  [976] = {.lex_state = 9},
  [977] = {.lex_state = 9},
  [978] = {.lex_state = 9},
  [979] = {.lex_state = 2, .external_lex_state = 2},
  [980] = {.lex_state = 2, .external_lex_state = 2},
  [981] = {.lex_state = 2, .external_lex_state = 3},
  [982] = {.lex_state = 2, .external_lex_state = 3},
  [983] = {.lex_state = 2, .external_lex_state = 3},
  [984] = {.lex_state = 2, .external_lex_state = 3},
  [985] = {.lex_state = 2, .external_lex_state = 2},
  [986] = {.lex_state = 2, .external_lex_state = 3},
  [987] = {.lex_state = 2, .external_lex_state = 3},
  [988] = {.lex_state = 2, .external_lex_state = 3},
  [989] = {.lex_state = 2, .external_lex_state = 3},
  [990] = {.lex_state = 2, .external_lex_state = 3},
  [991] = {.lex_state = 11},
  [992] = {.lex_state = 2, .external_lex_state = 3},
  [993] = {.lex_state = 3, .external_lex_state = 2},
  [994] = {.lex_state = 2, .external_lex_state = 2},
  [995] = {.lex_state = 11},
  [996] = {.lex_state = 3, .external_lex_state = 2},
  [997] = {.lex_state = 2, .external_lex_state = 3},
  [998] = {.lex_state = 2, .external_lex_state = 3},
  [999] = {.lex_state = 2, .external_lex_state = 2},
  [1000] = {.lex_state = 2, .external_lex_state = 3},
  [1001] = {.lex_state = 2, .external_lex_state = 3},
  [1002] = {.lex_state = 3, .external_lex_state = 2},
  [1003] = {.lex_state = 2, .external_lex_state = 3},
  [1004] = {.lex_state = 2, .external_lex_state = 3},
  [1005] = {.lex_state = 2, .external_lex_state = 3},
  [1006] = {.lex_state = 2, .external_lex_state = 3},
  [1007] = {.lex_state = 3, .external_lex_state = 2},
  [1008] = {.lex_state = 2, .external_lex_state = 2},
  [1009] = {.lex_state = 2, .external_lex_state = 3},
  [1010] = {.lex_state = 2, .external_lex_state = 3},
  [1011] = {.lex_state = 3, .external_lex_state = 2},
  [1012] = {.lex_state = 2, .external_lex_state = 3},
  [1013] = {.lex_state = 2, .external_lex_state = 2},
  [1014] = {.lex_state = 2, .external_lex_state = 3},
  [1015] = {.lex_state = 3, .external_lex_state = 2},
  [1016] = {.lex_state = 2, .external_lex_state = 3},
  [1017] = {.lex_state = 2, .external_lex_state = 2},
  [1018] = {.lex_state = 3, .external_lex_state = 2},
  [1019] = {.lex_state = 2, .external_lex_state = 2},
  [1020] = {.lex_state = 2, .external_lex_state = 3},
  [1021] = {.lex_state = 2, .external_lex_state = 2},
  [1022] = {.lex_state = 2, .external_lex_state = 2},
  [1023] = {.lex_state = 3, .external_lex_state = 2},
  [1024] = {.lex_state = 2, .external_lex_state = 2},
  [1025] = {.lex_state = 3, .external_lex_state = 2},
  [1026] = {.lex_state = 2, .external_lex_state = 3},
  [1027] = {.lex_state = 2, .external_lex_state = 2},
  [1028] = {.lex_state = 3, .external_lex_state = 2},
  [1029] = {.lex_state = 2, .external_lex_state = 2},
  [1030] = {.lex_state = 2, .external_lex_state = 2},
  [1031] = {.lex_state = 2, .external_lex_state = 2},
  [1032] = {.lex_state = 2, .external_lex_state = 2},
  [1033] = {.lex_state = 2, .external_lex_state = 2},
  [1034] = {.lex_state = 2, .external_lex_state = 2},
  [1035] = {.lex_state = 2, .external_lex_state = 3},
  [1036] = {.lex_state = 2, .external_lex_state = 2},
  [1037] = {.lex_state = 2, .external_lex_state = 2},
  [1038] = {.lex_state = 2, .external_lex_state = 2},
  [1039] = {.lex_state = 2, .external_lex_state = 3},
  [1040] = {.lex_state = 2, .external_lex_state = 2},
  [1041] = {.lex_state = 2, .external_lex_state = 3},
  [1042] = {.lex_state = 2, .external_lex_state = 3},
  [1043] = {.lex_state = 2, .external_lex_state = 3},
  [1044] = {.lex_state = 2, .external_lex_state = 2},
  [1045] = {.lex_state = 2, .external_lex_state = 2},
  [1046] = {.lex_state = 2, .external_lex_state = 2},
  [1047] = {.lex_state = 2, .external_lex_state = 2},
  [1048] = {.lex_state = 2, .external_lex_state = 3},
  [1049] = {.lex_state = 2, .external_lex_state = 2},
  [1050] = {.lex_state = 2, .external_lex_state = 2},
  [1051] = {.lex_state = 2, .external_lex_state = 2},
  [1052] = {.lex_state = 2, .external_lex_state = 3},
  [1053] = {.lex_state = 2, .external_lex_state = 2},
  [1054] = {.lex_state = 2, .external_lex_state = 2},
  [1055] = {.lex_state = 2, .external_lex_state = 2},
  [1056] = {.lex_state = 2, .external_lex_state = 2},
  [1057] = {.lex_state = 2, .external_lex_state = 3},
  [1058] = {.lex_state = 2, .external_lex_state = 2},
  [1059] = {.lex_state = 2, .external_lex_state = 2},
  [1060] = {.lex_state = 2, .external_lex_state = 3},
  [1061] = {.lex_state = 2, .external_lex_state = 3},
  [1062] = {.lex_state = 2, .external_lex_state = 2},
  [1063] = {.lex_state = 2, .external_lex_state = 2},
  [1064] = {.lex_state = 2, .external_lex_state = 3},
  [1065] = {.lex_state = 2, .external_lex_state = 2},
  [1066] = {.lex_state = 2, .external_lex_state = 2},
  [1067] = {.lex_state = 2, .external_lex_state = 2},
  [1068] = {.lex_state = 3, .external_lex_state = 2},
  [1069] = {.lex_state = 3, .external_lex_state = 2},
  [1070] = {.lex_state = 2, .external_lex_state = 3},
  [1071] = {.lex_state = 2, .external_lex_state = 2},
  [1072] = {.lex_state = 2, .external_lex_state = 2},
  [1073] = {.lex_state = 2, .external_lex_state = 3},
  [1074] = {.lex_state = 2, .external_lex_state = 3},
  [1075] = {.lex_state = 2, .external_lex_state = 3},
  [1076] = {.lex_state = 2, .external_lex_state = 3},
  [1077] = {.lex_state = 2, .external_lex_state = 3},
  [1078] = {.lex_state = 2, .external_lex_state = 2},
  [1079] = {.lex_state = 2, .external_lex_state = 3},
  [1080] = {.lex_state = 2, .external_lex_state = 2},
  [1081] = {.lex_state = 2, .external_lex_state = 2},
  [1082] = {.lex_state = 2, .external_lex_state = 2},
  [1083] = {.lex_state = 2, .external_lex_state = 3},
  [1084] = {.lex_state = 2, .external_lex_state = 3},
  [1085] = {.lex_state = 2, .external_lex_state = 3},
  [1086] = {.lex_state = 2, .external_lex_state = 3},
  [1087] = {.lex_state = 2, .external_lex_state = 3},
  [1088] = {.lex_state = 2, .external_lex_state = 3},
  [1089] = {.lex_state = 2, .external_lex_state = 3},
  [1090] = {.lex_state = 2, .external_lex_state = 3},
  [1091] = {.lex_state = 2, .external_lex_state = 3},
  [1092] = {.lex_state = 3, .external_lex_state = 2},
  [1093] = {.lex_state = 2, .external_lex_state = 3},
  [1094] = {.lex_state = 2, .external_lex_state = 2},
  [1095] = {.lex_state = 2, .external_lex_state = 3},
  [1096] = {.lex_state = 2, .external_lex_state = 3},
  [1097] = {.lex_state = 2, .external_lex_state = 3},
  [1098] = {.lex_state = 2, .external_lex_state = 3},
  [1099] = {.lex_state = 2, .external_lex_state = 2},
  [1100] = {.lex_state = 2, .external_lex_state = 3},
  [1101] = {.lex_state = 2, .external_lex_state = 3},
  [1102] = {.lex_state = 2, .external_lex_state = 2},
  [1103] = {.lex_state = 2, .external_lex_state = 2},
  [1104] = {.lex_state = 2, .external_lex_state = 2},
  [1105] = {.lex_state = 2, .external_lex_state = 2},
  [1106] = {.lex_state = 2, .external_lex_state = 3},
  [1107] = {.lex_state = 71},
  [1108] = {.lex_state = 3, .external_lex_state = 2},
  [1109] = {.lex_state = 2, .external_lex_state = 2},
  [1110] = {.lex_state = 2, .external_lex_state = 3},
  [1111] = {.lex_state = 3, .external_lex_state = 2},
  [1112] = {.lex_state = 2, .external_lex_state = 2},
  [1113] = {.lex_state = 3, .external_lex_state = 2},
  [1114] = {.lex_state = 2, .external_lex_state = 3},
  [1115] = {.lex_state = 2, .external_lex_state = 2},
  [1116] = {.lex_state = 2, .external_lex_state = 3},
  [1117] = {.lex_state = 3, .external_lex_state = 2},
  [1118] = {.lex_state = 2, .external_lex_state = 2},
  [1119] = {.lex_state = 2, .external_lex_state = 2},
  [1120] = {.lex_state = 2, .external_lex_state = 3},
  [1121] = {.lex_state = 2, .external_lex_state = 2},
  [1122] = {.lex_state = 71},
  [1123] = {.lex_state = 2, .external_lex_state = 2},
  [1124] = {.lex_state = 2, .external_lex_state = 2},
  [1125] = {.lex_state = 3, .external_lex_state = 2},
  [1126] = {.lex_state = 2, .external_lex_state = 2},
  [1127] = {.lex_state = 2, .external_lex_state = 2},
  [1128] = {.lex_state = 2, .external_lex_state = 2},
  [1129] = {.lex_state = 71},
  [1130] = {.lex_state = 71},
  [1131] = {.lex_state = 2, .external_lex_state = 3},
  [1132] = {.lex_state = 2, .external_lex_state = 2},
  [1133] = {.lex_state = 2, .external_lex_state = 3},
  [1134] = {.lex_state = 2, .external_lex_state = 2},
  [1135] = {.lex_state = 2, .external_lex_state = 2},
  [1136] = {.lex_state = 2, .external_lex_state = 2},
  [1137] = {.lex_state = 2, .external_lex_state = 2},
  [1138] = {.lex_state = 2, .external_lex_state = 3},
  [1139] = {.lex_state = 2, .external_lex_state = 3},
  [1140] = {.lex_state = 2, .external_lex_state = 2},
  [1141] = {.lex_state = 2, .external_lex_state = 2},
  [1142] = {.lex_state = 2, .external_lex_state = 3},
  [1143] = {.lex_state = 2, .external_lex_state = 2},
  [1144] = {.lex_state = 2, .external_lex_state = 2},
  [1145] = {.lex_state = 2, .external_lex_state = 2},
  [1146] = {.lex_state = 71},
  [1147] = {.lex_state = 2, .external_lex_state = 2},
  [1148] = {.lex_state = 2, .external_lex_state = 2},
  [1149] = {.lex_state = 71},
  [1150] = {.lex_state = 71},
  [1151] = {.lex_state = 2, .external_lex_state = 2},
  [1152] = {.lex_state = 2, .external_lex_state = 2},
  [1153] = {.lex_state = 2, .external_lex_state = 2},
  [1154] = {.lex_state = 2, .external_lex_state = 2},
  [1155] = {.lex_state = 9},
  [1156] = {.lex_state = 2, .external_lex_state = 2},
  [1157] = {.lex_state = 9},
  [1158] = {.lex_state = 2, .external_lex_state = 2},
  [1159] = {.lex_state = 2, .external_lex_state = 2},
  [1160] = {.lex_state = 2, .external_lex_state = 2},
  [1161] = {.lex_state = 9},
  [1162] = {.lex_state = 9},
  [1163] = {.lex_state = 9},
  [1164] = {.lex_state = 9},
  [1165] = {.lex_state = 2, .external_lex_state = 2},
  [1166] = {.lex_state = 9},
  [1167] = {.lex_state = 9},
  [1168] = {.lex_state = 9},
  [1169] = {.lex_state = 71, .external_lex_state = 4},
  [1170] = {.lex_state = 9},
  [1171] = {.lex_state = 9},
  [1172] = {.lex_state = 9},
  [1173] = {.lex_state = 9},
  [1174] = {.lex_state = 9},
  [1175] = {.lex_state = 9},
  [1176] = {.lex_state = 9},
  [1177] = {.lex_state = 9},
  [1178] = {.lex_state = 9},
  [1179] = {.lex_state = 9},
  [1180] = {.lex_state = 71, .external_lex_state = 4},
  [1181] = {.lex_state = 9},
  [1182] = {.lex_state = 9},
  [1183] = {.lex_state = 9},
  [1184] = {.lex_state = 9},
  [1185] = {.lex_state = 9},
  [1186] = {.lex_state = 71, .external_lex_state = 4},
  [1187] = {.lex_state = 71, .external_lex_state = 4},
  [1188] = {.lex_state = 71, .external_lex_state = 4},
  [1189] = {.lex_state = 70, .external_lex_state = 3},
  [1190] = {.lex_state = 71, .external_lex_state = 4},
  [1191] = {.lex_state = 9},
  [1192] = {.lex_state = 9},
  [1193] = {.lex_state = 9},
  [1194] = {.lex_state = 9},
  [1195] = {.lex_state = 9},
  [1196] = {.lex_state = 71, .external_lex_state = 4},
  [1197] = {.lex_state = 9},
  [1198] = {.lex_state = 9},
  [1199] = {.lex_state = 70, .external_lex_state = 3},
  [1200] = {.lex_state = 70, .external_lex_state = 3},
  [1201] = {.lex_state = 71},
  [1202] = {.lex_state = 70, .external_lex_state = 2},
  [1203] = {.lex_state = 71},
  [1204] = {.lex_state = 71},
  [1205] = {.lex_state = 71},
  [1206] = {.lex_state = 71},
  [1207] = {.lex_state = 71},
  [1208] = {.lex_state = 71},
  [1209] = {.lex_state = 70, .external_lex_state = 2},
  [1210] = {.lex_state = 70, .external_lex_state = 2},
  [1211] = {.lex_state = 70, .external_lex_state = 2},
  [1212] = {.lex_state = 70, .external_lex_state = 2},
  [1213] = {.lex_state = 70, .external_lex_state = 2},
  [1214] = {.lex_state = 70, .external_lex_state = 2},
  [1215] = {.lex_state = 70, .external_lex_state = 3},
  [1216] = {.lex_state = 70, .external_lex_state = 2},
  [1217] = {.lex_state = 70, .external_lex_state = 3},
  [1218] = {.lex_state = 70, .external_lex_state = 3},
  [1219] = {.lex_state = 70, .external_lex_state = 2},
  [1220] = {.lex_state = 70, .external_lex_state = 2},
  [1221] = {.lex_state = 70, .external_lex_state = 2},
  [1222] = {.lex_state = 70, .external_lex_state = 2},
  [1223] = {.lex_state = 70, .external_lex_state = 3},
  [1224] = {.lex_state = 70, .external_lex_state = 2},
  [1225] = {.lex_state = 70, .external_lex_state = 2},
  [1226] = {.lex_state = 70, .external_lex_state = 2},
  [1227] = {.lex_state = 70, .external_lex_state = 2},
  [1228] = {.lex_state = 70, .external_lex_state = 2},
  [1229] = {.lex_state = 70, .external_lex_state = 3},
  [1230] = {.lex_state = 70, .external_lex_state = 2},
  [1231] = {.lex_state = 70, .external_lex_state = 2},
  [1232] = {.lex_state = 70, .external_lex_state = 2},
  [1233] = {.lex_state = 70, .external_lex_state = 2},
  [1234] = {.lex_state = 70, .external_lex_state = 2},
  [1235] = {.lex_state = 70, .external_lex_state = 2},
  [1236] = {.lex_state = 70, .external_lex_state = 2},
  [1237] = {.lex_state = 70, .external_lex_state = 2},
  [1238] = {.lex_state = 70, .external_lex_state = 2},
  [1239] = {.lex_state = 70, .external_lex_state = 2},
  [1240] = {.lex_state = 70, .external_lex_state = 2},
  [1241] = {.lex_state = 70, .external_lex_state = 2},
  [1242] = {.lex_state = 70, .external_lex_state = 2},
  [1243] = {.lex_state = 70, .external_lex_state = 2},
  [1244] = {.lex_state = 70, .external_lex_state = 2},
  [1245] = {.lex_state = 70, .external_lex_state = 2},
  [1246] = {.lex_state = 70, .external_lex_state = 2},
  [1247] = {.lex_state = 70, .external_lex_state = 2},
  [1248] = {.lex_state = 70, .external_lex_state = 2},
  [1249] = {.lex_state = 70, .external_lex_state = 2},
  [1250] = {.lex_state = 70, .external_lex_state = 2},
  [1251] = {.lex_state = 70, .external_lex_state = 2},
  [1252] = {.lex_state = 70, .external_lex_state = 2},
  [1253] = {.lex_state = 70, .external_lex_state = 2},
  [1254] = {.lex_state = 70, .external_lex_state = 2},
  [1255] = {.lex_state = 70, .external_lex_state = 2},
  [1256] = {.lex_state = 70, .external_lex_state = 2},
  [1257] = {.lex_state = 70, .external_lex_state = 2},
  [1258] = {.lex_state = 70, .external_lex_state = 2},
  [1259] = {.lex_state = 70, .external_lex_state = 2},
  [1260] = {.lex_state = 70, .external_lex_state = 2},
  [1261] = {.lex_state = 70, .external_lex_state = 2},
  [1262] = {.lex_state = 70, .external_lex_state = 2},
  [1263] = {.lex_state = 70, .external_lex_state = 2},
  [1264] = {.lex_state = 70, .external_lex_state = 2},
  [1265] = {.lex_state = 70, .external_lex_state = 2},
  [1266] = {.lex_state = 70, .external_lex_state = 2},
  [1267] = {.lex_state = 70, .external_lex_state = 2},
  [1268] = {.lex_state = 70, .external_lex_state = 2},
  [1269] = {.lex_state = 70, .external_lex_state = 2},
  [1270] = {.lex_state = 70, .external_lex_state = 2},
  [1271] = {.lex_state = 70, .external_lex_state = 2},
  [1272] = {.lex_state = 70, .external_lex_state = 2},
  [1273] = {.lex_state = 70, .external_lex_state = 2},
  [1274] = {.lex_state = 70, .external_lex_state = 2},
  [1275] = {.lex_state = 70, .external_lex_state = 2},
  [1276] = {.lex_state = 70, .external_lex_state = 2},
  [1277] = {.lex_state = 70, .external_lex_state = 2},
  [1278] = {.lex_state = 70, .external_lex_state = 2},
  [1279] = {.lex_state = 70, .external_lex_state = 2},
  [1280] = {.lex_state = 70, .external_lex_state = 2},
  [1281] = {.lex_state = 70, .external_lex_state = 2},
  [1282] = {.lex_state = 70, .external_lex_state = 2},
  [1283] = {.lex_state = 70, .external_lex_state = 2},
  [1284] = {.lex_state = 70, .external_lex_state = 2},
  [1285] = {.lex_state = 70, .external_lex_state = 2},
  [1286] = {.lex_state = 70, .external_lex_state = 2},
  [1287] = {.lex_state = 70, .external_lex_state = 2},
  [1288] = {.lex_state = 70, .external_lex_state = 2},
  [1289] = {.lex_state = 70, .external_lex_state = 2},
  [1290] = {.lex_state = 70, .external_lex_state = 2},
  [1291] = {.lex_state = 70, .external_lex_state = 2},
  [1292] = {.lex_state = 70, .external_lex_state = 2},
  [1293] = {.lex_state = 70, .external_lex_state = 2},
  [1294] = {.lex_state = 70, .external_lex_state = 2},
  [1295] = {.lex_state = 70, .external_lex_state = 2},
  [1296] = {.lex_state = 70, .external_lex_state = 2},
  [1297] = {.lex_state = 70, .external_lex_state = 2},
  [1298] = {.lex_state = 70, .external_lex_state = 2},
  [1299] = {.lex_state = 70, .external_lex_state = 2},
  [1300] = {.lex_state = 70, .external_lex_state = 2},
  [1301] = {.lex_state = 70, .external_lex_state = 2},
  [1302] = {.lex_state = 70, .external_lex_state = 2},
  [1303] = {.lex_state = 70, .external_lex_state = 2},
  [1304] = {.lex_state = 70, .external_lex_state = 2},
  [1305] = {.lex_state = 70, .external_lex_state = 2},
  [1306] = {.lex_state = 70, .external_lex_state = 2},
  [1307] = {.lex_state = 70, .external_lex_state = 2},
  [1308] = {.lex_state = 70, .external_lex_state = 3},
  [1309] = {.lex_state = 70, .external_lex_state = 2},
  [1310] = {.lex_state = 70, .external_lex_state = 2},
  [1311] = {.lex_state = 70, .external_lex_state = 2},
  [1312] = {.lex_state = 70, .external_lex_state = 2},
  [1313] = {.lex_state = 70, .external_lex_state = 2},
  [1314] = {.lex_state = 70, .external_lex_state = 2},
  [1315] = {.lex_state = 70, .external_lex_state = 2},
  [1316] = {.lex_state = 70, .external_lex_state = 2},
  [1317] = {.lex_state = 70, .external_lex_state = 2},
  [1318] = {.lex_state = 70, .external_lex_state = 2},
  [1319] = {.lex_state = 70, .external_lex_state = 2},
  [1320] = {.lex_state = 70, .external_lex_state = 2},
  [1321] = {.lex_state = 70, .external_lex_state = 2},
  [1322] = {.lex_state = 71},
  [1323] = {.lex_state = 70, .external_lex_state = 2},
  [1324] = {.lex_state = 70, .external_lex_state = 2},
  [1325] = {.lex_state = 70, .external_lex_state = 2},
  [1326] = {.lex_state = 70, .external_lex_state = 2},
  [1327] = {.lex_state = 70, .external_lex_state = 2},
  [1328] = {.lex_state = 70, .external_lex_state = 2},
  [1329] = {.lex_state = 70, .external_lex_state = 2},
  [1330] = {.lex_state = 70, .external_lex_state = 3},
  [1331] = {.lex_state = 70, .external_lex_state = 2},
  [1332] = {.lex_state = 70, .external_lex_state = 2},
  [1333] = {.lex_state = 70, .external_lex_state = 3},
  [1334] = {.lex_state = 70, .external_lex_state = 2},
  [1335] = {.lex_state = 70, .external_lex_state = 2},
  [1336] = {.lex_state = 70, .external_lex_state = 2},
  [1337] = {.lex_state = 70, .external_lex_state = 2},
  [1338] = {.lex_state = 70, .external_lex_state = 2},
  [1339] = {.lex_state = 70, .external_lex_state = 3},
  [1340] = {.lex_state = 70, .external_lex_state = 2},
  [1341] = {.lex_state = 70, .external_lex_state = 2},
  [1342] = {.lex_state = 70, .external_lex_state = 2},
  [1343] = {.lex_state = 70, .external_lex_state = 2},
  [1344] = {.lex_state = 70, .external_lex_state = 2},
  [1345] = {.lex_state = 70, .external_lex_state = 2},
  [1346] = {.lex_state = 70, .external_lex_state = 2},
  [1347] = {.lex_state = 70, .external_lex_state = 3},
  [1348] = {.lex_state = 70, .external_lex_state = 2},
  [1349] = {.lex_state = 70, .external_lex_state = 2},
  [1350] = {.lex_state = 70, .external_lex_state = 2},
  [1351] = {.lex_state = 70, .external_lex_state = 2},
  [1352] = {.lex_state = 70, .external_lex_state = 2},
  [1353] = {.lex_state = 70, .external_lex_state = 2},
  [1354] = {.lex_state = 70, .external_lex_state = 2},
  [1355] = {.lex_state = 70, .external_lex_state = 2},
  [1356] = {.lex_state = 70, .external_lex_state = 2},
  [1357] = {.lex_state = 70, .external_lex_state = 2},
  [1358] = {.lex_state = 70, .external_lex_state = 2},
  [1359] = {.lex_state = 70, .external_lex_state = 2},
  [1360] = {.lex_state = 70, .external_lex_state = 2},
  [1361] = {.lex_state = 70, .external_lex_state = 2},
  [1362] = {.lex_state = 70, .external_lex_state = 2},
  [1363] = {.lex_state = 70, .external_lex_state = 2},
  [1364] = {.lex_state = 70, .external_lex_state = 2},
  [1365] = {.lex_state = 70, .external_lex_state = 2},
  [1366] = {.lex_state = 70, .external_lex_state = 2},
  [1367] = {.lex_state = 70, .external_lex_state = 2},
  [1368] = {.lex_state = 70, .external_lex_state = 3},
  [1369] = {.lex_state = 70, .external_lex_state = 2},
  [1370] = {.lex_state = 70, .external_lex_state = 2},
  [1371] = {.lex_state = 70, .external_lex_state = 3},
  [1372] = {.lex_state = 70, .external_lex_state = 2},
  [1373] = {.lex_state = 70, .external_lex_state = 2},
  [1374] = {.lex_state = 70, .external_lex_state = 2},
  [1375] = {.lex_state = 70, .external_lex_state = 2},
  [1376] = {.lex_state = 70, .external_lex_state = 2},
  [1377] = {.lex_state = 70, .external_lex_state = 3},
  [1378] = {.lex_state = 70, .external_lex_state = 2},
  [1379] = {.lex_state = 70, .external_lex_state = 2},
  [1380] = {.lex_state = 70, .external_lex_state = 2},
  [1381] = {.lex_state = 70, .external_lex_state = 3},
  [1382] = {.lex_state = 70, .external_lex_state = 2},
  [1383] = {.lex_state = 70, .external_lex_state = 2},
  [1384] = {.lex_state = 70, .external_lex_state = 2},
  [1385] = {.lex_state = 70, .external_lex_state = 2},
  [1386] = {.lex_state = 70, .external_lex_state = 2},
  [1387] = {.lex_state = 70, .external_lex_state = 2},
  [1388] = {.lex_state = 70, .external_lex_state = 2},
  [1389] = {.lex_state = 70, .external_lex_state = 2},
  [1390] = {.lex_state = 70, .external_lex_state = 2},
  [1391] = {.lex_state = 70, .external_lex_state = 2},
  [1392] = {.lex_state = 70, .external_lex_state = 2},
  [1393] = {.lex_state = 70, .external_lex_state = 2},
  [1394] = {.lex_state = 70, .external_lex_state = 2},
  [1395] = {.lex_state = 70, .external_lex_state = 2},
  [1396] = {.lex_state = 70, .external_lex_state = 2},
  [1397] = {.lex_state = 70, .external_lex_state = 2},
  [1398] = {.lex_state = 70, .external_lex_state = 2},
  [1399] = {.lex_state = 70, .external_lex_state = 2},
  [1400] = {.lex_state = 70, .external_lex_state = 2},
  [1401] = {.lex_state = 70, .external_lex_state = 2},
  [1402] = {.lex_state = 70, .external_lex_state = 2},
  [1403] = {.lex_state = 70, .external_lex_state = 2},
  [1404] = {.lex_state = 70, .external_lex_state = 2},
  [1405] = {.lex_state = 70, .external_lex_state = 2},
  [1406] = {.lex_state = 70, .external_lex_state = 3},
  [1407] = {.lex_state = 70, .external_lex_state = 2},
  [1408] = {.lex_state = 70, .external_lex_state = 2},
  [1409] = {.lex_state = 70, .external_lex_state = 2},
  [1410] = {.lex_state = 70, .external_lex_state = 2},
  [1411] = {.lex_state = 70, .external_lex_state = 2},
  [1412] = {.lex_state = 70, .external_lex_state = 2},
  [1413] = {.lex_state = 70, .external_lex_state = 2},
  [1414] = {.lex_state = 70, .external_lex_state = 2},
  [1415] = {.lex_state = 70, .external_lex_state = 2},
  [1416] = {.lex_state = 70, .external_lex_state = 2},
  [1417] = {.lex_state = 70, .external_lex_state = 2},
  [1418] = {.lex_state = 70, .external_lex_state = 2},
  [1419] = {.lex_state = 70, .external_lex_state = 2},
  [1420] = {.lex_state = 70, .external_lex_state = 2},
  [1421] = {.lex_state = 70, .external_lex_state = 2},
  [1422] = {.lex_state = 70, .external_lex_state = 2},
  [1423] = {.lex_state = 70, .external_lex_state = 2},
  [1424] = {.lex_state = 70, .external_lex_state = 2},
  [1425] = {.lex_state = 70, .external_lex_state = 2},
  [1426] = {.lex_state = 70, .external_lex_state = 2},
  [1427] = {.lex_state = 70, .external_lex_state = 2},
  [1428] = {.lex_state = 70, .external_lex_state = 3},
  [1429] = {.lex_state = 70, .external_lex_state = 3},
  [1430] = {.lex_state = 70, .external_lex_state = 2},
  [1431] = {.lex_state = 70, .external_lex_state = 3},
  [1432] = {.lex_state = 70, .external_lex_state = 3},
  [1433] = {.lex_state = 70, .external_lex_state = 3},
  [1434] = {.lex_state = 70, .external_lex_state = 3},
  [1435] = {.lex_state = 70, .external_lex_state = 3},
  [1436] = {.lex_state = 70, .external_lex_state = 3},
  [1437] = {.lex_state = 70, .external_lex_state = 3},
  [1438] = {.lex_state = 70, .external_lex_state = 3},
  [1439] = {.lex_state = 70, .external_lex_state = 3},
  [1440] = {.lex_state = 9},
  [1441] = {.lex_state = 70, .external_lex_state = 3},
  [1442] = {.lex_state = 70, .external_lex_state = 3},
  [1443] = {.lex_state = 70, .external_lex_state = 3},
  [1444] = {.lex_state = 9},
  [1445] = {.lex_state = 9},
  [1446] = {.lex_state = 70, .external_lex_state = 3},
  [1447] = {.lex_state = 70, .external_lex_state = 3},
  [1448] = {.lex_state = 70, .external_lex_state = 3},
  [1449] = {.lex_state = 9},
  [1450] = {.lex_state = 70, .external_lex_state = 3},
  [1451] = {.lex_state = 9},
  [1452] = {.lex_state = 70, .external_lex_state = 3},
  [1453] = {.lex_state = 70, .external_lex_state = 3},
  [1454] = {.lex_state = 70, .external_lex_state = 3},
  [1455] = {.lex_state = 70, .external_lex_state = 2},
  [1456] = {.lex_state = 70, .external_lex_state = 3},
  [1457] = {.lex_state = 70, .external_lex_state = 3},
  [1458] = {.lex_state = 70, .external_lex_state = 3},
  [1459] = {.lex_state = 70, .external_lex_state = 3},
  [1460] = {.lex_state = 70, .external_lex_state = 3},
  [1461] = {.lex_state = 70, .external_lex_state = 3},
  [1462] = {.lex_state = 71, .external_lex_state = 4},
  [1463] = {.lex_state = 70, .external_lex_state = 3},
  [1464] = {.lex_state = 70, .external_lex_state = 3},
  [1465] = {.lex_state = 70, .external_lex_state = 3},
  [1466] = {.lex_state = 70, .external_lex_state = 3},
  [1467] = {.lex_state = 70, .external_lex_state = 3},
  [1468] = {.lex_state = 70, .external_lex_state = 3},
  [1469] = {.lex_state = 9},
  [1470] = {.lex_state = 70, .external_lex_state = 3},
  [1471] = {.lex_state = 71, .external_lex_state = 4},
  [1472] = {.lex_state = 70, .external_lex_state = 3},
  [1473] = {.lex_state = 9},
  [1474] = {.lex_state = 70, .external_lex_state = 2},
  [1475] = {.lex_state = 70, .external_lex_state = 3},
  [1476] = {.lex_state = 70, .external_lex_state = 3},
  [1477] = {.lex_state = 70, .external_lex_state = 3},
  [1478] = {.lex_state = 70, .external_lex_state = 3},
  [1479] = {.lex_state = 70, .external_lex_state = 3},
  [1480] = {.lex_state = 70, .external_lex_state = 2},
  [1481] = {.lex_state = 70, .external_lex_state = 3},
  [1482] = {.lex_state = 70, .external_lex_state = 2},
  [1483] = {.lex_state = 70, .external_lex_state = 3},
  [1484] = {.lex_state = 9},
  [1485] = {.lex_state = 70, .external_lex_state = 3},
  [1486] = {.lex_state = 70, .external_lex_state = 3},
  [1487] = {.lex_state = 70, .external_lex_state = 3},
  [1488] = {.lex_state = 70, .external_lex_state = 3},
  [1489] = {.lex_state = 70, .external_lex_state = 3},
  [1490] = {.lex_state = 70, .external_lex_state = 2},
  [1491] = {.lex_state = 70, .external_lex_state = 2},
  [1492] = {.lex_state = 70, .external_lex_state = 3},
  [1493] = {.lex_state = 70, .external_lex_state = 2},
  [1494] = {.lex_state = 70, .external_lex_state = 3},
  [1495] = {.lex_state = 71, .external_lex_state = 4},
  [1496] = {.lex_state = 9},
  [1497] = {.lex_state = 70, .external_lex_state = 3},
  [1498] = {.lex_state = 70, .external_lex_state = 3},
  [1499] = {.lex_state = 70, .external_lex_state = 3},
  [1500] = {.lex_state = 70, .external_lex_state = 3},
  [1501] = {.lex_state = 70, .external_lex_state = 3},
  [1502] = {.lex_state = 71, .external_lex_state = 4},
  [1503] = {.lex_state = 70, .external_lex_state = 3},
  [1504] = {.lex_state = 70, .external_lex_state = 3},
  [1505] = {.lex_state = 70, .external_lex_state = 3},
  [1506] = {.lex_state = 70, .external_lex_state = 3},
  [1507] = {.lex_state = 9},
  [1508] = {.lex_state = 70, .external_lex_state = 3},
  [1509] = {.lex_state = 70, .external_lex_state = 3},
  [1510] = {.lex_state = 70, .external_lex_state = 3},
  [1511] = {.lex_state = 70, .external_lex_state = 3},
  [1512] = {.lex_state = 70, .external_lex_state = 3},
  [1513] = {.lex_state = 70, .external_lex_state = 3},
  [1514] = {.lex_state = 70, .external_lex_state = 3},
  [1515] = {.lex_state = 70, .external_lex_state = 3},
  [1516] = {.lex_state = 70, .external_lex_state = 3},
  [1517] = {.lex_state = 70, .external_lex_state = 2},
  [1518] = {.lex_state = 70, .external_lex_state = 3},
  [1519] = {.lex_state = 70, .external_lex_state = 3},
  [1520] = {.lex_state = 70, .external_lex_state = 3},
  [1521] = {.lex_state = 70, .external_lex_state = 3},
  [1522] = {.lex_state = 70, .external_lex_state = 3},
  [1523] = {.lex_state = 70, .external_lex_state = 3},
  [1524] = {.lex_state = 70, .external_lex_state = 3},
  [1525] = {.lex_state = 70, .external_lex_state = 2},
  [1526] = {.lex_state = 70, .external_lex_state = 3},
  [1527] = {.lex_state = 71, .external_lex_state = 4},
  [1528] = {.lex_state = 70, .external_lex_state = 2},
  [1529] = {.lex_state = 70, .external_lex_state = 2},
  [1530] = {.lex_state = 70, .external_lex_state = 2},
  [1531] = {.lex_state = 9},
  [1532] = {.lex_state = 70, .external_lex_state = 3},
  [1533] = {.lex_state = 70, .external_lex_state = 2},
  [1534] = {.lex_state = 70, .external_lex_state = 3},
  [1535] = {.lex_state = 70, .external_lex_state = 3},
  [1536] = {.lex_state = 70, .external_lex_state = 3},
  [1537] = {.lex_state = 70, .external_lex_state = 3},
  [1538] = {.lex_state = 70, .external_lex_state = 3},
  [1539] = {.lex_state = 70, .external_lex_state = 3},
  [1540] = {.lex_state = 70, .external_lex_state = 3},
  [1541] = {.lex_state = 70, .external_lex_state = 3},
  [1542] = {.lex_state = 70, .external_lex_state = 3},
  [1543] = {.lex_state = 70, .external_lex_state = 3},
  [1544] = {.lex_state = 70, .external_lex_state = 3},
  [1545] = {.lex_state = 70, .external_lex_state = 3},
  [1546] = {.lex_state = 70, .external_lex_state = 3},
  [1547] = {.lex_state = 70, .external_lex_state = 3},
  [1548] = {.lex_state = 70, .external_lex_state = 3},
  [1549] = {.lex_state = 70, .external_lex_state = 3},
  [1550] = {.lex_state = 70, .external_lex_state = 3},
  [1551] = {.lex_state = 70, .external_lex_state = 3},
  [1552] = {.lex_state = 70, .external_lex_state = 3},
  [1553] = {.lex_state = 70, .external_lex_state = 3},
  [1554] = {.lex_state = 70, .external_lex_state = 3},
  [1555] = {.lex_state = 70, .external_lex_state = 3},
  [1556] = {.lex_state = 70, .external_lex_state = 3},
  [1557] = {.lex_state = 70, .external_lex_state = 2},
  [1558] = {.lex_state = 70, .external_lex_state = 2},
  [1559] = {.lex_state = 70, .external_lex_state = 2},
  [1560] = {.lex_state = 70, .external_lex_state = 2},
  [1561] = {.lex_state = 70, .external_lex_state = 3},
  [1562] = {.lex_state = 70, .external_lex_state = 3},
  [1563] = {.lex_state = 70, .external_lex_state = 3},
  [1564] = {.lex_state = 70, .external_lex_state = 3},
  [1565] = {.lex_state = 70, .external_lex_state = 3},
  [1566] = {.lex_state = 70, .external_lex_state = 3},
  [1567] = {.lex_state = 70, .external_lex_state = 3},
  [1568] = {.lex_state = 70, .external_lex_state = 3},
  [1569] = {.lex_state = 70, .external_lex_state = 3},
  [1570] = {.lex_state = 70, .external_lex_state = 3},
  [1571] = {.lex_state = 70, .external_lex_state = 3},
  [1572] = {.lex_state = 70, .external_lex_state = 3},
  [1573] = {.lex_state = 70, .external_lex_state = 2},
  [1574] = {.lex_state = 70, .external_lex_state = 2},
  [1575] = {.lex_state = 71, .external_lex_state = 4},
  [1576] = {.lex_state = 71, .external_lex_state = 4},
  [1577] = {.lex_state = 70, .external_lex_state = 3},
  [1578] = {.lex_state = 70, .external_lex_state = 3},
  [1579] = {.lex_state = 70, .external_lex_state = 3},
  [1580] = {.lex_state = 70, .external_lex_state = 3},
  [1581] = {.lex_state = 70, .external_lex_state = 3},
  [1582] = {.lex_state = 70, .external_lex_state = 3},
  [1583] = {.lex_state = 70, .external_lex_state = 3},
  [1584] = {.lex_state = 70, .external_lex_state = 3},
  [1585] = {.lex_state = 70, .external_lex_state = 3},
  [1586] = {.lex_state = 70, .external_lex_state = 3},
  [1587] = {.lex_state = 70, .external_lex_state = 3},
  [1588] = {.lex_state = 70, .external_lex_state = 3},
  [1589] = {.lex_state = 70, .external_lex_state = 3},
  [1590] = {.lex_state = 70, .external_lex_state = 3},
  [1591] = {.lex_state = 70, .external_lex_state = 3},
  [1592] = {.lex_state = 70, .external_lex_state = 3},
  [1593] = {.lex_state = 70, .external_lex_state = 3},
  [1594] = {.lex_state = 70, .external_lex_state = 3},
  [1595] = {.lex_state = 71, .external_lex_state = 4},
  [1596] = {.lex_state = 71, .external_lex_state = 4},
  [1597] = {.lex_state = 70, .external_lex_state = 3},
  [1598] = {.lex_state = 70, .external_lex_state = 2},
  [1599] = {.lex_state = 70, .external_lex_state = 2},
  [1600] = {.lex_state = 70, .external_lex_state = 2},
  [1601] = {.lex_state = 70, .external_lex_state = 3},
  [1602] = {.lex_state = 70, .external_lex_state = 3},
  [1603] = {.lex_state = 70, .external_lex_state = 2},
  [1604] = {.lex_state = 70, .external_lex_state = 3},
  [1605] = {.lex_state = 70, .external_lex_state = 2},
  [1606] = {.lex_state = 70, .external_lex_state = 3},
  [1607] = {.lex_state = 71, .external_lex_state = 4},
  [1608] = {.lex_state = 70, .external_lex_state = 3},
  [1609] = {.lex_state = 71, .external_lex_state = 4},
  [1610] = {.lex_state = 70, .external_lex_state = 2},
  [1611] = {.lex_state = 70, .external_lex_state = 3},
  [1612] = {.lex_state = 70, .external_lex_state = 3},
  [1613] = {.lex_state = 70, .external_lex_state = 3},
  [1614] = {.lex_state = 70, .external_lex_state = 3},
  [1615] = {.lex_state = 70, .external_lex_state = 3},
  [1616] = {.lex_state = 70, .external_lex_state = 3},
  [1617] = {.lex_state = 70, .external_lex_state = 3},
  [1618] = {.lex_state = 70, .external_lex_state = 3},
  [1619] = {.lex_state = 70, .external_lex_state = 3},
  [1620] = {.lex_state = 70, .external_lex_state = 3},
  [1621] = {.lex_state = 70, .external_lex_state = 3},
  [1622] = {.lex_state = 70, .external_lex_state = 3},
  [1623] = {.lex_state = 70, .external_lex_state = 3},
  [1624] = {.lex_state = 70, .external_lex_state = 3},
  [1625] = {.lex_state = 70, .external_lex_state = 3},
  [1626] = {.lex_state = 70, .external_lex_state = 3},
  [1627] = {.lex_state = 70, .external_lex_state = 2},
  [1628] = {.lex_state = 70, .external_lex_state = 3},
  [1629] = {.lex_state = 70, .external_lex_state = 2},
  [1630] = {.lex_state = 70, .external_lex_state = 2},
  [1631] = {.lex_state = 70, .external_lex_state = 2},
  [1632] = {.lex_state = 70, .external_lex_state = 2},
  [1633] = {.lex_state = 70, .external_lex_state = 2},
  [1634] = {.lex_state = 70, .external_lex_state = 2},
  [1635] = {.lex_state = 70, .external_lex_state = 2},
  [1636] = {.lex_state = 70, .external_lex_state = 3},
  [1637] = {.lex_state = 70, .external_lex_state = 3},
  [1638] = {.lex_state = 70, .external_lex_state = 2},
  [1639] = {.lex_state = 70, .external_lex_state = 2},
  [1640] = {.lex_state = 70, .external_lex_state = 3},
  [1641] = {.lex_state = 70, .external_lex_state = 2},
  [1642] = {.lex_state = 70, .external_lex_state = 2},
  [1643] = {.lex_state = 70, .external_lex_state = 3},
  [1644] = {.lex_state = 70, .external_lex_state = 2},
  [1645] = {.lex_state = 70, .external_lex_state = 2},
  [1646] = {.lex_state = 70, .external_lex_state = 2},
  [1647] = {.lex_state = 70, .external_lex_state = 2},
  [1648] = {.lex_state = 70, .external_lex_state = 2},
  [1649] = {.lex_state = 70, .external_lex_state = 2},
  [1650] = {.lex_state = 70, .external_lex_state = 2},
  [1651] = {.lex_state = 4, .external_lex_state = 2},
  [1652] = {.lex_state = 70, .external_lex_state = 2},
  [1653] = {.lex_state = 70, .external_lex_state = 2},
  [1654] = {.lex_state = 70, .external_lex_state = 3},
  [1655] = {.lex_state = 71, .external_lex_state = 4},
  [1656] = {.lex_state = 70, .external_lex_state = 3},
  [1657] = {.lex_state = 70, .external_lex_state = 3},
  [1658] = {.lex_state = 70, .external_lex_state = 3},
  [1659] = {.lex_state = 70, .external_lex_state = 3},
  [1660] = {.lex_state = 70, .external_lex_state = 3},
  [1661] = {.lex_state = 70, .external_lex_state = 3},
  [1662] = {.lex_state = 70, .external_lex_state = 3},
  [1663] = {.lex_state = 70, .external_lex_state = 3},
  [1664] = {.lex_state = 70, .external_lex_state = 2},
  [1665] = {.lex_state = 70, .external_lex_state = 2},
  [1666] = {.lex_state = 70, .external_lex_state = 3},
  [1667] = {.lex_state = 70, .external_lex_state = 3},
  [1668] = {.lex_state = 70, .external_lex_state = 3},
  [1669] = {.lex_state = 71, .external_lex_state = 4},
  [1670] = {.lex_state = 70, .external_lex_state = 2},
  [1671] = {.lex_state = 70, .external_lex_state = 3},
  [1672] = {.lex_state = 70, .external_lex_state = 3},
  [1673] = {.lex_state = 70, .external_lex_state = 3},
  [1674] = {.lex_state = 70, .external_lex_state = 2},
  [1675] = {.lex_state = 70, .external_lex_state = 2},
  [1676] = {.lex_state = 70, .external_lex_state = 2},
  [1677] = {.lex_state = 70, .external_lex_state = 2},
  [1678] = {.lex_state = 70, .external_lex_state = 3},
  [1679] = {.lex_state = 70, .external_lex_state = 3},
  [1680] = {.lex_state = 70, .external_lex_state = 3},
  [1681] = {.lex_state = 70, .external_lex_state = 2},
  [1682] = {.lex_state = 70, .external_lex_state = 3},
  [1683] = {.lex_state = 70, .external_lex_state = 2},
  [1684] = {.lex_state = 70, .external_lex_state = 2},
  [1685] = {.lex_state = 70, .external_lex_state = 2},
  [1686] = {.lex_state = 70, .external_lex_state = 2},
  [1687] = {.lex_state = 70, .external_lex_state = 2},
  [1688] = {.lex_state = 70, .external_lex_state = 2},
  [1689] = {.lex_state = 70, .external_lex_state = 2},
  [1690] = {.lex_state = 70, .external_lex_state = 3},
  [1691] = {.lex_state = 70, .external_lex_state = 3},
  [1692] = {.lex_state = 70, .external_lex_state = 2},
  [1693] = {.lex_state = 70, .external_lex_state = 3},
  [1694] = {.lex_state = 70, .external_lex_state = 3},
  [1695] = {.lex_state = 70, .external_lex_state = 2},
  [1696] = {.lex_state = 70, .external_lex_state = 2},
  [1697] = {.lex_state = 70, .external_lex_state = 3},
  [1698] = {.lex_state = 70, .external_lex_state = 3},
  [1699] = {.lex_state = 70, .external_lex_state = 2},
  [1700] = {.lex_state = 70, .external_lex_state = 2},
  [1701] = {.lex_state = 70, .external_lex_state = 3},
  [1702] = {.lex_state = 70, .external_lex_state = 3},
  [1703] = {.lex_state = 70, .external_lex_state = 2},
  [1704] = {.lex_state = 70, .external_lex_state = 3},
  [1705] = {.lex_state = 70, .external_lex_state = 3},
  [1706] = {.lex_state = 70, .external_lex_state = 3},
  [1707] = {.lex_state = 70, .external_lex_state = 3},
  [1708] = {.lex_state = 71, .external_lex_state = 4},
  [1709] = {.lex_state = 70, .external_lex_state = 3},
  [1710] = {.lex_state = 71, .external_lex_state = 4},
  [1711] = {.lex_state = 70, .external_lex_state = 3},
  [1712] = {.lex_state = 70, .external_lex_state = 2},
  [1713] = {.lex_state = 70, .external_lex_state = 2},
  [1714] = {.lex_state = 70, .external_lex_state = 3},
  [1715] = {.lex_state = 70, .external_lex_state = 3},
  [1716] = {.lex_state = 70, .external_lex_state = 3},
  [1717] = {.lex_state = 70, .external_lex_state = 3},
  [1718] = {.lex_state = 70, .external_lex_state = 3},
  [1719] = {.lex_state = 70, .external_lex_state = 3},
  [1720] = {.lex_state = 70, .external_lex_state = 3},
  [1721] = {.lex_state = 70, .external_lex_state = 2},
  [1722] = {.lex_state = 70, .external_lex_state = 2},
  [1723] = {.lex_state = 70, .external_lex_state = 2},
  [1724] = {.lex_state = 70, .external_lex_state = 2},
  [1725] = {.lex_state = 70, .external_lex_state = 2},
  [1726] = {.lex_state = 70, .external_lex_state = 3},
  [1727] = {.lex_state = 70, .external_lex_state = 3},
  [1728] = {.lex_state = 70, .external_lex_state = 3},
  [1729] = {.lex_state = 70, .external_lex_state = 3},
  [1730] = {.lex_state = 70, .external_lex_state = 2},
  [1731] = {.lex_state = 70, .external_lex_state = 2},
  [1732] = {.lex_state = 70, .external_lex_state = 2},
  [1733] = {.lex_state = 71, .external_lex_state = 4},
  [1734] = {.lex_state = 70, .external_lex_state = 3},
  [1735] = {.lex_state = 70, .external_lex_state = 3},
  [1736] = {.lex_state = 70, .external_lex_state = 2},
  [1737] = {.lex_state = 70, .external_lex_state = 3},
  [1738] = {.lex_state = 70, .external_lex_state = 3},
  [1739] = {.lex_state = 70, .external_lex_state = 3},
  [1740] = {.lex_state = 70, .external_lex_state = 2},
  [1741] = {.lex_state = 70, .external_lex_state = 2},
  [1742] = {.lex_state = 70, .external_lex_state = 3},
  [1743] = {.lex_state = 70, .external_lex_state = 3},
  [1744] = {.lex_state = 70, .external_lex_state = 2},
  [1745] = {.lex_state = 70, .external_lex_state = 2},
  [1746] = {.lex_state = 70, .external_lex_state = 3},
  [1747] = {.lex_state = 70, .external_lex_state = 3},
  [1748] = {.lex_state = 70, .external_lex_state = 2},
  [1749] = {.lex_state = 70, .external_lex_state = 3},
  [1750] = {.lex_state = 70, .external_lex_state = 2},
  [1751] = {.lex_state = 70, .external_lex_state = 3},
  [1752] = {.lex_state = 70, .external_lex_state = 3},
  [1753] = {.lex_state = 70, .external_lex_state = 3},
  [1754] = {.lex_state = 70, .external_lex_state = 3},
  [1755] = {.lex_state = 70, .external_lex_state = 3},
  [1756] = {.lex_state = 70, .external_lex_state = 2},
  [1757] = {.lex_state = 70, .external_lex_state = 3},
  [1758] = {.lex_state = 70, .external_lex_state = 3},
  [1759] = {.lex_state = 70, .external_lex_state = 3},
  [1760] = {.lex_state = 70, .external_lex_state = 3},
  [1761] = {.lex_state = 71, .external_lex_state = 4},
  [1762] = {.lex_state = 70, .external_lex_state = 3},
  [1763] = {.lex_state = 70, .external_lex_state = 3},
  [1764] = {.lex_state = 70, .external_lex_state = 2},
  [1765] = {.lex_state = 70, .external_lex_state = 2},
  [1766] = {.lex_state = 70, .external_lex_state = 2},
  [1767] = {.lex_state = 70, .external_lex_state = 3},
  [1768] = {.lex_state = 70, .external_lex_state = 3},
  [1769] = {.lex_state = 70, .external_lex_state = 2},
  [1770] = {.lex_state = 70, .external_lex_state = 3},
  [1771] = {.lex_state = 70, .external_lex_state = 2},
  [1772] = {.lex_state = 70, .external_lex_state = 3},
  [1773] = {.lex_state = 70, .external_lex_state = 2},
  [1774] = {.lex_state = 70, .external_lex_state = 3},
  [1775] = {.lex_state = 70, .external_lex_state = 3},
  [1776] = {.lex_state = 70, .external_lex_state = 3},
  [1777] = {.lex_state = 70, .external_lex_state = 3},
  [1778] = {.lex_state = 70, .external_lex_state = 3},
  [1779] = {.lex_state = 70, .external_lex_state = 3},
  [1780] = {.lex_state = 70, .external_lex_state = 2},
  [1781] = {.lex_state = 70, .external_lex_state = 2},
  [1782] = {.lex_state = 70, .external_lex_state = 3},
  [1783] = {.lex_state = 70, .external_lex_state = 3},
  [1784] = {.lex_state = 70, .external_lex_state = 2},
  [1785] = {.lex_state = 70, .external_lex_state = 3},
  [1786] = {.lex_state = 70, .external_lex_state = 2},
  [1787] = {.lex_state = 70, .external_lex_state = 3},
  [1788] = {.lex_state = 70, .external_lex_state = 2},
  [1789] = {.lex_state = 71, .external_lex_state = 4},
  [1790] = {.lex_state = 70, .external_lex_state = 3},
  [1791] = {.lex_state = 70, .external_lex_state = 3},
  [1792] = {.lex_state = 70, .external_lex_state = 3},
  [1793] = {.lex_state = 70, .external_lex_state = 3},
  [1794] = {.lex_state = 70, .external_lex_state = 2},
  [1795] = {.lex_state = 70, .external_lex_state = 3},
  [1796] = {.lex_state = 70, .external_lex_state = 2},
  [1797] = {.lex_state = 70, .external_lex_state = 3},
  [1798] = {.lex_state = 70, .external_lex_state = 3},
  [1799] = {.lex_state = 70, .external_lex_state = 3},
  [1800] = {.lex_state = 70, .external_lex_state = 3},
  [1801] = {.lex_state = 70, .external_lex_state = 3},
  [1802] = {.lex_state = 70, .external_lex_state = 3},
  [1803] = {.lex_state = 70, .external_lex_state = 3},
  [1804] = {.lex_state = 70, .external_lex_state = 2},
  [1805] = {.lex_state = 70, .external_lex_state = 3},
  [1806] = {.lex_state = 70, .external_lex_state = 3},
  [1807] = {.lex_state = 70, .external_lex_state = 3},
  [1808] = {.lex_state = 70, .external_lex_state = 3},
  [1809] = {.lex_state = 71, .external_lex_state = 4},
  [1810] = {.lex_state = 70, .external_lex_state = 3},
  [1811] = {.lex_state = 70, .external_lex_state = 3},
  [1812] = {.lex_state = 70, .external_lex_state = 2},
  [1813] = {.lex_state = 70, .external_lex_state = 3},
  [1814] = {.lex_state = 70, .external_lex_state = 2},
  [1815] = {.lex_state = 70, .external_lex_state = 2},
  [1816] = {.lex_state = 70, .external_lex_state = 3},
  [1817] = {.lex_state = 70, .external_lex_state = 3},
  [1818] = {.lex_state = 70, .external_lex_state = 3},
  [1819] = {.lex_state = 70, .external_lex_state = 3},
  [1820] = {.lex_state = 70, .external_lex_state = 3},
  [1821] = {.lex_state = 70, .external_lex_state = 3},
  [1822] = {.lex_state = 70, .external_lex_state = 2},
  [1823] = {.lex_state = 70, .external_lex_state = 3},
  [1824] = {.lex_state = 70, .external_lex_state = 2},
  [1825] = {.lex_state = 70, .external_lex_state = 2},
  [1826] = {.lex_state = 70, .external_lex_state = 2},
  [1827] = {.lex_state = 70, .external_lex_state = 2},
  [1828] = {.lex_state = 70, .external_lex_state = 3},
  [1829] = {.lex_state = 70, .external_lex_state = 2},
  [1830] = {.lex_state = 70, .external_lex_state = 2},
  [1831] = {.lex_state = 70, .external_lex_state = 2},
  [1832] = {.lex_state = 70, .external_lex_state = 3},
  [1833] = {.lex_state = 70, .external_lex_state = 3},
  [1834] = {.lex_state = 70, .external_lex_state = 3},
  [1835] = {.lex_state = 70, .external_lex_state = 3},
  [1836] = {.lex_state = 70, .external_lex_state = 2},
  [1837] = {.lex_state = 70, .external_lex_state = 2},
  [1838] = {.lex_state = 70, .external_lex_state = 2},
  [1839] = {.lex_state = 70, .external_lex_state = 3},
  [1840] = {.lex_state = 70, .external_lex_state = 3},
  [1841] = {.lex_state = 70, .external_lex_state = 3},
  [1842] = {.lex_state = 70, .external_lex_state = 2},
  [1843] = {.lex_state = 70, .external_lex_state = 2},
  [1844] = {.lex_state = 70, .external_lex_state = 3},
  [1845] = {.lex_state = 70, .external_lex_state = 2},
  [1846] = {.lex_state = 70, .external_lex_state = 2},
  [1847] = {.lex_state = 70, .external_lex_state = 2},
  [1848] = {.lex_state = 70, .external_lex_state = 3},
  [1849] = {.lex_state = 70, .external_lex_state = 3},
  [1850] = {.lex_state = 70, .external_lex_state = 3},
  [1851] = {.lex_state = 70, .external_lex_state = 2},
  [1852] = {.lex_state = 71, .external_lex_state = 4},
  [1853] = {.lex_state = 70, .external_lex_state = 2},
  [1854] = {.lex_state = 70, .external_lex_state = 2},
  [1855] = {.lex_state = 70, .external_lex_state = 3},
  [1856] = {.lex_state = 70, .external_lex_state = 3},
  [1857] = {.lex_state = 70, .external_lex_state = 2},
  [1858] = {.lex_state = 70, .external_lex_state = 3},
  [1859] = {.lex_state = 70, .external_lex_state = 2},
  [1860] = {.lex_state = 4, .external_lex_state = 3},
  [1861] = {.lex_state = 70, .external_lex_state = 2},
  [1862] = {.lex_state = 70, .external_lex_state = 2},
  [1863] = {.lex_state = 70, .external_lex_state = 2},
  [1864] = {.lex_state = 70, .external_lex_state = 2},
  [1865] = {.lex_state = 70, .external_lex_state = 3},
  [1866] = {.lex_state = 70, .external_lex_state = 3},
  [1867] = {.lex_state = 70, .external_lex_state = 3},
  [1868] = {.lex_state = 70, .external_lex_state = 3},
  [1869] = {.lex_state = 70, .external_lex_state = 3},
  [1870] = {.lex_state = 70, .external_lex_state = 3},
  [1871] = {.lex_state = 70, .external_lex_state = 3},
  [1872] = {.lex_state = 70, .external_lex_state = 3},
  [1873] = {.lex_state = 70, .external_lex_state = 3},
  [1874] = {.lex_state = 70, .external_lex_state = 3},
  [1875] = {.lex_state = 71, .external_lex_state = 4},
  [1876] = {.lex_state = 70, .external_lex_state = 3},
  [1877] = {.lex_state = 70, .external_lex_state = 3},
  [1878] = {.lex_state = 70, .external_lex_state = 3},
  [1879] = {.lex_state = 70, .external_lex_state = 3},
  [1880] = {.lex_state = 70, .external_lex_state = 3},
  [1881] = {.lex_state = 70, .external_lex_state = 3},
  [1882] = {.lex_state = 70, .external_lex_state = 3},
  [1883] = {.lex_state = 70, .external_lex_state = 2},
  [1884] = {.lex_state = 70, .external_lex_state = 2},
  [1885] = {.lex_state = 70, .external_lex_state = 3},
  [1886] = {.lex_state = 70, .external_lex_state = 3},
  [1887] = {.lex_state = 70, .external_lex_state = 2},
  [1888] = {.lex_state = 70, .external_lex_state = 3},
  [1889] = {.lex_state = 70, .external_lex_state = 3},
  [1890] = {.lex_state = 70, .external_lex_state = 3},
  [1891] = {.lex_state = 70, .external_lex_state = 2},
  [1892] = {.lex_state = 71, .external_lex_state = 4},
  [1893] = {.lex_state = 70, .external_lex_state = 2},
  [1894] = {.lex_state = 70, .external_lex_state = 3},
  [1895] = {.lex_state = 70, .external_lex_state = 2},
  [1896] = {.lex_state = 70, .external_lex_state = 3},
  [1897] = {.lex_state = 70, .external_lex_state = 3},
  [1898] = {.lex_state = 70, .external_lex_state = 3},
  [1899] = {.lex_state = 70, .external_lex_state = 3},
  [1900] = {.lex_state = 70, .external_lex_state = 2},
  [1901] = {.lex_state = 70, .external_lex_state = 3},
  [1902] = {.lex_state = 70, .external_lex_state = 2},
  [1903] = {.lex_state = 70, .external_lex_state = 3},
  [1904] = {.lex_state = 70, .external_lex_state = 3},
  [1905] = {.lex_state = 70, .external_lex_state = 3},
  [1906] = {.lex_state = 70, .external_lex_state = 2},
  [1907] = {.lex_state = 4, .external_lex_state = 3},
  [1908] = {.lex_state = 70, .external_lex_state = 2},
  [1909] = {.lex_state = 70, .external_lex_state = 2},
  [1910] = {.lex_state = 70, .external_lex_state = 2},
  [1911] = {.lex_state = 70, .external_lex_state = 2},
  [1912] = {.lex_state = 70, .external_lex_state = 3},
  [1913] = {.lex_state = 70, .external_lex_state = 3},
  [1914] = {.lex_state = 70, .external_lex_state = 2},
  [1915] = {.lex_state = 70, .external_lex_state = 2},
  [1916] = {.lex_state = 70, .external_lex_state = 2},
  [1917] = {.lex_state = 70, .external_lex_state = 2},
  [1918] = {.lex_state = 70, .external_lex_state = 2},
  [1919] = {.lex_state = 71},
  [1920] = {.lex_state = 70, .external_lex_state = 2},
  [1921] = {.lex_state = 70, .external_lex_state = 2},
  [1922] = {.lex_state = 70, .external_lex_state = 2},
  [1923] = {.lex_state = 70, .external_lex_state = 3},
  [1924] = {.lex_state = 70, .external_lex_state = 2},
  [1925] = {.lex_state = 70, .external_lex_state = 2},
  [1926] = {.lex_state = 71},
  [1927] = {.lex_state = 4, .external_lex_state = 2},
  [1928] = {.lex_state = 70, .external_lex_state = 2},
  [1929] = {.lex_state = 70, .external_lex_state = 2},
  [1930] = {.lex_state = 70, .external_lex_state = 3},
  [1931] = {.lex_state = 70, .external_lex_state = 2},
  [1932] = {.lex_state = 70, .external_lex_state = 2},
  [1933] = {.lex_state = 71},
  [1934] = {.lex_state = 70, .external_lex_state = 2},
  [1935] = {.lex_state = 70, .external_lex_state = 2},
  [1936] = {.lex_state = 70, .external_lex_state = 2},
  [1937] = {.lex_state = 70, .external_lex_state = 2},
  [1938] = {.lex_state = 70, .external_lex_state = 2},
  [1939] = {.lex_state = 70, .external_lex_state = 2},
  [1940] = {.lex_state = 70, .external_lex_state = 2},
  [1941] = {.lex_state = 70, .external_lex_state = 2},
  [1942] = {.lex_state = 70, .external_lex_state = 2},
  [1943] = {.lex_state = 70, .external_lex_state = 2},
  [1944] = {.lex_state = 70, .external_lex_state = 2},
  [1945] = {.lex_state = 70, .external_lex_state = 2},
  [1946] = {.lex_state = 70, .external_lex_state = 3},
  [1947] = {.lex_state = 70, .external_lex_state = 2},
  [1948] = {.lex_state = 70, .external_lex_state = 2},
  [1949] = {.lex_state = 70, .external_lex_state = 2},
  [1950] = {.lex_state = 70, .external_lex_state = 2},
  [1951] = {.lex_state = 70, .external_lex_state = 2},
  [1952] = {.lex_state = 70, .external_lex_state = 2},
  [1953] = {.lex_state = 70, .external_lex_state = 2},
  [1954] = {.lex_state = 70, .external_lex_state = 2},
  [1955] = {.lex_state = 71},
  [1956] = {.lex_state = 70, .external_lex_state = 2},
  [1957] = {.lex_state = 71, .external_lex_state = 4},
  [1958] = {.lex_state = 71, .external_lex_state = 4},
  [1959] = {.lex_state = 71, .external_lex_state = 4},
  [1960] = {.lex_state = 70, .external_lex_state = 2},
  [1961] = {.lex_state = 71},
  [1962] = {.lex_state = 71, .external_lex_state = 4},
  [1963] = {.lex_state = 70, .external_lex_state = 2},
  [1964] = {.lex_state = 70, .external_lex_state = 2},
  [1965] = {.lex_state = 70, .external_lex_state = 2},
  [1966] = {.lex_state = 70, .external_lex_state = 2},
  [1967] = {.lex_state = 71, .external_lex_state = 4},
  [1968] = {.lex_state = 70, .external_lex_state = 2},
  [1969] = {.lex_state = 71, .external_lex_state = 4},
  [1970] = {.lex_state = 71},
  [1971] = {.lex_state = 70, .external_lex_state = 2},
  [1972] = {.lex_state = 71, .external_lex_state = 4},
  [1973] = {.lex_state = 71, .external_lex_state = 4},
  [1974] = {.lex_state = 70, .external_lex_state = 2},
  [1975] = {.lex_state = 71, .external_lex_state = 4},
  [1976] = {.lex_state = 70, .external_lex_state = 2},
  [1977] = {.lex_state = 71},
  [1978] = {.lex_state = 70, .external_lex_state = 2},
  [1979] = {.lex_state = 71},
  [1980] = {.lex_state = 70, .external_lex_state = 2},
  [1981] = {.lex_state = 70, .external_lex_state = 2},
  [1982] = {.lex_state = 70, .external_lex_state = 2},
  [1983] = {.lex_state = 71},
  [1984] = {.lex_state = 70, .external_lex_state = 2},
  [1985] = {.lex_state = 70, .external_lex_state = 2},
  [1986] = {.lex_state = 71, .external_lex_state = 4},
  [1987] = {.lex_state = 70, .external_lex_state = 2},
  [1988] = {.lex_state = 70, .external_lex_state = 2},
  [1989] = {.lex_state = 71, .external_lex_state = 4},
  [1990] = {.lex_state = 71, .external_lex_state = 4},
  [1991] = {.lex_state = 70, .external_lex_state = 2},
  [1992] = {.lex_state = 70, .external_lex_state = 2},
  [1993] = {.lex_state = 70, .external_lex_state = 2},
  [1994] = {.lex_state = 70, .external_lex_state = 2},
  [1995] = {.lex_state = 70, .external_lex_state = 2},
  [1996] = {.lex_state = 71, .external_lex_state = 4},
  [1997] = {.lex_state = 71, .external_lex_state = 4},
  [1998] = {.lex_state = 71},
  [1999] = {.lex_state = 71, .external_lex_state = 4},
  [2000] = {.lex_state = 71},
  [2001] = {.lex_state = 70, .external_lex_state = 2},
  [2002] = {.lex_state = 71, .external_lex_state = 4},
  [2003] = {.lex_state = 71, .external_lex_state = 4},
  [2004] = {.lex_state = 71, .external_lex_state = 4},
  [2005] = {.lex_state = 70, .external_lex_state = 2},
  [2006] = {.lex_state = 71, .external_lex_state = 4},
  [2007] = {.lex_state = 71, .external_lex_state = 4},
  [2008] = {.lex_state = 71, .external_lex_state = 4},
  [2009] = {.lex_state = 71, .external_lex_state = 4},
  [2010] = {.lex_state = 70, .external_lex_state = 2},
  [2011] = {.lex_state = 71},
  [2012] = {.lex_state = 71, .external_lex_state = 4},
  [2013] = {.lex_state = 71},
  [2014] = {.lex_state = 71, .external_lex_state = 4},
  [2015] = {.lex_state = 70, .external_lex_state = 2},
  [2016] = {.lex_state = 70, .external_lex_state = 2},
  [2017] = {.lex_state = 71},
  [2018] = {.lex_state = 71},
  [2019] = {.lex_state = 71, .external_lex_state = 4},
  [2020] = {.lex_state = 71, .external_lex_state = 4},
  [2021] = {.lex_state = 70, .external_lex_state = 2},
  [2022] = {.lex_state = 70, .external_lex_state = 3},
  [2023] = {.lex_state = 71, .external_lex_state = 4},
  [2024] = {.lex_state = 70, .external_lex_state = 2},
  [2025] = {.lex_state = 71, .external_lex_state = 4},
  [2026] = {.lex_state = 71, .external_lex_state = 4},
  [2027] = {.lex_state = 71, .external_lex_state = 4},
  [2028] = {.lex_state = 71, .external_lex_state = 4},
  [2029] = {.lex_state = 71},
  [2030] = {.lex_state = 70, .external_lex_state = 2},
  [2031] = {.lex_state = 71, .external_lex_state = 4},
  [2032] = {.lex_state = 71, .external_lex_state = 4},
  [2033] = {.lex_state = 70, .external_lex_state = 2},
  [2034] = {.lex_state = 70, .external_lex_state = 2},
  [2035] = {.lex_state = 71, .external_lex_state = 4},
  [2036] = {.lex_state = 70, .external_lex_state = 2},
  [2037] = {.lex_state = 71, .external_lex_state = 4},
  [2038] = {.lex_state = 71},
  [2039] = {.lex_state = 71},
  [2040] = {.lex_state = 70, .external_lex_state = 2},
  [2041] = {.lex_state = 71},
  [2042] = {.lex_state = 70, .external_lex_state = 2},
  [2043] = {.lex_state = 70, .external_lex_state = 2},
  [2044] = {.lex_state = 71, .external_lex_state = 4},
  [2045] = {.lex_state = 70, .external_lex_state = 2},
  [2046] = {.lex_state = 70, .external_lex_state = 2},
  [2047] = {.lex_state = 70, .external_lex_state = 2},
  [2048] = {.lex_state = 70, .external_lex_state = 2},
  [2049] = {.lex_state = 71},
  [2050] = {.lex_state = 71},
  [2051] = {.lex_state = 70, .external_lex_state = 2},
  [2052] = {.lex_state = 70, .external_lex_state = 3},
  [2053] = {.lex_state = 70, .external_lex_state = 2},
  [2054] = {.lex_state = 70, .external_lex_state = 2},
  [2055] = {.lex_state = 70, .external_lex_state = 2},
  [2056] = {.lex_state = 70, .external_lex_state = 2},
  [2057] = {.lex_state = 70, .external_lex_state = 2},
  [2058] = {.lex_state = 70, .external_lex_state = 2},
  [2059] = {.lex_state = 70, .external_lex_state = 2},
  [2060] = {.lex_state = 70, .external_lex_state = 2},
  [2061] = {.lex_state = 70, .external_lex_state = 2},
  [2062] = {.lex_state = 70, .external_lex_state = 2},
  [2063] = {.lex_state = 70, .external_lex_state = 2},
  [2064] = {.lex_state = 70, .external_lex_state = 2},
  [2065] = {.lex_state = 70, .external_lex_state = 2},
  [2066] = {.lex_state = 71},
  [2067] = {.lex_state = 71, .external_lex_state = 4},
  [2068] = {.lex_state = 70, .external_lex_state = 2},
  [2069] = {.lex_state = 70, .external_lex_state = 3},
  [2070] = {.lex_state = 71, .external_lex_state = 4},
  [2071] = {.lex_state = 71, .external_lex_state = 4},
  [2072] = {.lex_state = 70, .external_lex_state = 2},
  [2073] = {.lex_state = 70, .external_lex_state = 2},
  [2074] = {.lex_state = 70, .external_lex_state = 2},
  [2075] = {.lex_state = 70, .external_lex_state = 2},
  [2076] = {.lex_state = 70, .external_lex_state = 2},
  [2077] = {.lex_state = 71},
  [2078] = {.lex_state = 70, .external_lex_state = 2},
  [2079] = {.lex_state = 70, .external_lex_state = 2},
  [2080] = {.lex_state = 71},
  [2081] = {.lex_state = 71, .external_lex_state = 4},
  [2082] = {.lex_state = 71, .external_lex_state = 4},
  [2083] = {.lex_state = 71, .external_lex_state = 4},
  [2084] = {.lex_state = 71, .external_lex_state = 4},
  [2085] = {.lex_state = 70, .external_lex_state = 2},
  [2086] = {.lex_state = 71, .external_lex_state = 4},
  [2087] = {.lex_state = 71, .external_lex_state = 4},
  [2088] = {.lex_state = 70, .external_lex_state = 2},
  [2089] = {.lex_state = 71, .external_lex_state = 4},
  [2090] = {.lex_state = 71, .external_lex_state = 4},
  [2091] = {.lex_state = 71, .external_lex_state = 4},
  [2092] = {.lex_state = 70, .external_lex_state = 2},
  [2093] = {.lex_state = 70, .external_lex_state = 2},
  [2094] = {.lex_state = 71},
  [2095] = {.lex_state = 71, .external_lex_state = 4},
  [2096] = {.lex_state = 71, .external_lex_state = 4},
  [2097] = {.lex_state = 71},
  [2098] = {.lex_state = 71, .external_lex_state = 4},
  [2099] = {.lex_state = 71, .external_lex_state = 4},
  [2100] = {.lex_state = 71, .external_lex_state = 4},
  [2101] = {.lex_state = 71, .external_lex_state = 4},
  [2102] = {.lex_state = 71, .external_lex_state = 4},
  [2103] = {.lex_state = 71},
  [2104] = {.lex_state = 71},
  [2105] = {.lex_state = 71, .external_lex_state = 4},
  [2106] = {.lex_state = 71},
  [2107] = {.lex_state = 71},
  [2108] = {.lex_state = 4, .external_lex_state = 2},
  [2109] = {.lex_state = 71},
  [2110] = {.lex_state = 71},
  [2111] = {.lex_state = 70, .external_lex_state = 2},
  [2112] = {.lex_state = 71, .external_lex_state = 4},
  [2113] = {.lex_state = 71, .external_lex_state = 4},
  [2114] = {.lex_state = 70, .external_lex_state = 2},
  [2115] = {.lex_state = 70, .external_lex_state = 2},
  [2116] = {.lex_state = 71},
  [2117] = {.lex_state = 71, .external_lex_state = 4},
  [2118] = {.lex_state = 71, .external_lex_state = 4},
  [2119] = {.lex_state = 71, .external_lex_state = 4},
  [2120] = {.lex_state = 71, .external_lex_state = 4},
  [2121] = {.lex_state = 71, .external_lex_state = 4},
  [2122] = {.lex_state = 71, .external_lex_state = 4},
  [2123] = {.lex_state = 71, .external_lex_state = 4},
  [2124] = {.lex_state = 71},
  [2125] = {.lex_state = 71, .external_lex_state = 4},
  [2126] = {.lex_state = 71, .external_lex_state = 4},
  [2127] = {.lex_state = 71, .external_lex_state = 4},
  [2128] = {.lex_state = 71, .external_lex_state = 4},
  [2129] = {.lex_state = 71},
  [2130] = {.lex_state = 71},
  [2131] = {.lex_state = 71, .external_lex_state = 4},
  [2132] = {.lex_state = 71},
  [2133] = {.lex_state = 71, .external_lex_state = 4},
  [2134] = {.lex_state = 71},
  [2135] = {.lex_state = 71},
  [2136] = {.lex_state = 71},
  [2137] = {.lex_state = 71},
  [2138] = {.lex_state = 71},
  [2139] = {.lex_state = 71},
  [2140] = {.lex_state = 71},
  [2141] = {.lex_state = 71, .external_lex_state = 4},
  [2142] = {.lex_state = 71},
  [2143] = {.lex_state = 71},
  [2144] = {.lex_state = 71},
  [2145] = {.lex_state = 71},
  [2146] = {.lex_state = 71},
  [2147] = {.lex_state = 71},
  [2148] = {.lex_state = 71},
  [2149] = {.lex_state = 71},
  [2150] = {.lex_state = 71},
  [2151] = {.lex_state = 71},
  [2152] = {.lex_state = 9},
  [2153] = {.lex_state = 71},
  [2154] = {.lex_state = 71},
  [2155] = {.lex_state = 71},
  [2156] = {.lex_state = 71},
  [2157] = {.lex_state = 71},
  [2158] = {.lex_state = 71},
  [2159] = {.lex_state = 71},
  [2160] = {.lex_state = 71},
  [2161] = {.lex_state = 9, .external_lex_state = 4},
  [2162] = {.lex_state = 9, .external_lex_state = 4},
  [2163] = {.lex_state = 9, .external_lex_state = 4},
  [2164] = {.lex_state = 9, .external_lex_state = 4},
  [2165] = {.lex_state = 9, .external_lex_state = 4},
  [2166] = {.lex_state = 9, .external_lex_state = 4},
  [2167] = {.lex_state = 9, .external_lex_state = 4},
  [2168] = {.lex_state = 71},
  [2169] = {.lex_state = 9, .external_lex_state = 4},
  [2170] = {.lex_state = 9, .external_lex_state = 4},
  [2171] = {.lex_state = 9, .external_lex_state = 4},
  [2172] = {.lex_state = 71},
  [2173] = {.lex_state = 9, .external_lex_state = 4},
  [2174] = {.lex_state = 9},
  [2175] = {.lex_state = 71},
  [2176] = {.lex_state = 9, .external_lex_state = 4},
  [2177] = {.lex_state = 9, .external_lex_state = 4},
  [2178] = {.lex_state = 9, .external_lex_state = 4},
  [2179] = {.lex_state = 9, .external_lex_state = 4},
  [2180] = {.lex_state = 9, .external_lex_state = 4},
  [2181] = {.lex_state = 71},
  [2182] = {.lex_state = 9, .external_lex_state = 4},
  [2183] = {.lex_state = 71},
  [2184] = {.lex_state = 71},
  [2185] = {.lex_state = 9, .external_lex_state = 4},
  [2186] = {.lex_state = 71},
  [2187] = {.lex_state = 71},
  [2188] = {.lex_state = 9, .external_lex_state = 4},
  [2189] = {.lex_state = 9, .external_lex_state = 4},
  [2190] = {.lex_state = 71},
  [2191] = {.lex_state = 9, .external_lex_state = 4},
  [2192] = {.lex_state = 71},
  [2193] = {.lex_state = 9, .external_lex_state = 4},
  [2194] = {.lex_state = 9, .external_lex_state = 4},
  [2195] = {.lex_state = 9, .external_lex_state = 4},
  [2196] = {.lex_state = 9, .external_lex_state = 4},
  [2197] = {.lex_state = 9, .external_lex_state = 4},
  [2198] = {.lex_state = 9, .external_lex_state = 4},
  [2199] = {.lex_state = 71},
  [2200] = {.lex_state = 71},
  [2201] = {.lex_state = 71},
  [2202] = {.lex_state = 71},
  [2203] = {.lex_state = 71},
  [2204] = {.lex_state = 71},
  [2205] = {.lex_state = 71},
  [2206] = {.lex_state = 71},
  [2207] = {.lex_state = 71},
  [2208] = {.lex_state = 71},
  [2209] = {.lex_state = 71},
  [2210] = {.lex_state = 71},
  [2211] = {.lex_state = 71},
  [2212] = {.lex_state = 71},
  [2213] = {.lex_state = 71},
  [2214] = {.lex_state = 71},
  [2215] = {.lex_state = 71},
  [2216] = {.lex_state = 71},
  [2217] = {.lex_state = 71},
  [2218] = {.lex_state = 71},
  [2219] = {.lex_state = 71},
  [2220] = {.lex_state = 9},
  [2221] = {.lex_state = 71},
  [2222] = {.lex_state = 71},
  [2223] = {.lex_state = 9},
  [2224] = {.lex_state = 71},
  [2225] = {.lex_state = 71},
  [2226] = {.lex_state = 9},
  [2227] = {.lex_state = 71},
  [2228] = {.lex_state = 9},
  [2229] = {.lex_state = 9},
  [2230] = {.lex_state = 9},
  [2231] = {.lex_state = 71},
  [2232] = {.lex_state = 71},
  [2233] = {.lex_state = 71},
  [2234] = {.lex_state = 71},
  [2235] = {.lex_state = 71},
  [2236] = {.lex_state = 71},
  [2237] = {.lex_state = 71},
  [2238] = {.lex_state = 71},
  [2239] = {.lex_state = 71},
  [2240] = {.lex_state = 71},
  [2241] = {.lex_state = 71},
  [2242] = {.lex_state = 71},
  [2243] = {.lex_state = 71},
  [2244] = {.lex_state = 71},
  [2245] = {.lex_state = 71},
  [2246] = {.lex_state = 71},
  [2247] = {.lex_state = 71},
  [2248] = {.lex_state = 71},
  [2249] = {.lex_state = 71},
  [2250] = {.lex_state = 71},
  [2251] = {.lex_state = 71},
  [2252] = {.lex_state = 71},
  [2253] = {.lex_state = 71},
  [2254] = {.lex_state = 71},
  [2255] = {.lex_state = 71},
  [2256] = {.lex_state = 71},
  [2257] = {.lex_state = 71},
  [2258] = {.lex_state = 71},
  [2259] = {.lex_state = 71},
  [2260] = {.lex_state = 71},
  [2261] = {.lex_state = 71},
  [2262] = {.lex_state = 71},
  [2263] = {.lex_state = 71},
  [2264] = {.lex_state = 71},
  [2265] = {.lex_state = 71},
  [2266] = {.lex_state = 71},
  [2267] = {.lex_state = 71},
  [2268] = {.lex_state = 71},
  [2269] = {.lex_state = 71},
  [2270] = {.lex_state = 71},
  [2271] = {.lex_state = 71},
  [2272] = {.lex_state = 71},
  [2273] = {.lex_state = 71},
  [2274] = {.lex_state = 71},
  [2275] = {.lex_state = 71},
  [2276] = {.lex_state = 71},
  [2277] = {.lex_state = 71},
  [2278] = {.lex_state = 71},
  [2279] = {.lex_state = 71},
  [2280] = {.lex_state = 71},
  [2281] = {.lex_state = 71},
  [2282] = {.lex_state = 71},
  [2283] = {.lex_state = 71},
  [2284] = {.lex_state = 71},
  [2285] = {.lex_state = 71},
  [2286] = {.lex_state = 71},
  [2287] = {.lex_state = 71},
  [2288] = {.lex_state = 71},
  [2289] = {.lex_state = 8},
  [2290] = {.lex_state = 8},
  [2291] = {.lex_state = 8},
  [2292] = {.lex_state = 8},
  [2293] = {.lex_state = 8},
  [2294] = {.lex_state = 8},
  [2295] = {.lex_state = 8},
  [2296] = {.lex_state = 8},
  [2297] = {.lex_state = 8},
  [2298] = {.lex_state = 8},
  [2299] = {.lex_state = 8},
  [2300] = {.lex_state = 8},
  [2301] = {.lex_state = 8},
  [2302] = {.lex_state = 8},
  [2303] = {.lex_state = 8},
  [2304] = {.lex_state = 8},
  [2305] = {.lex_state = 8},
  [2306] = {.lex_state = 8},
  [2307] = {.lex_state = 8},
  [2308] = {.lex_state = 8},
  [2309] = {.lex_state = 8},
  [2310] = {.lex_state = 8},
  [2311] = {.lex_state = 8},
  [2312] = {.lex_state = 8},
  [2313] = {.lex_state = 8},
  [2314] = {.lex_state = 8},
  [2315] = {.lex_state = 8},
  [2316] = {.lex_state = 71},
  [2317] = {.lex_state = 8},
  [2318] = {.lex_state = 8},
  [2319] = {.lex_state = 8},
  [2320] = {.lex_state = 8},
  [2321] = {.lex_state = 8},
  [2322] = {.lex_state = 8},
  [2323] = {.lex_state = 8},
  [2324] = {.lex_state = 8},
  [2325] = {.lex_state = 8},
  [2326] = {.lex_state = 8},
  [2327] = {.lex_state = 8},
  [2328] = {.lex_state = 8},
  [2329] = {.lex_state = 8},
  [2330] = {.lex_state = 71},
  [2331] = {.lex_state = 8},
  [2332] = {.lex_state = 71},
  [2333] = {.lex_state = 71, .external_lex_state = 4},
  [2334] = {.lex_state = 71, .external_lex_state = 4},
  [2335] = {.lex_state = 71},
  [2336] = {.lex_state = 71},
  [2337] = {.lex_state = 8, .external_lex_state = 4},
  [2338] = {.lex_state = 71},
  [2339] = {.lex_state = 71},
  [2340] = {.lex_state = 2},
  [2341] = {.lex_state = 71},
  [2342] = {.lex_state = 71},
  [2343] = {.lex_state = 8, .external_lex_state = 4},
  [2344] = {.lex_state = 2},
  [2345] = {.lex_state = 8, .external_lex_state = 4},
  [2346] = {.lex_state = 71},
  [2347] = {.lex_state = 2},
  [2348] = {.lex_state = 71},
  [2349] = {.lex_state = 2},
  [2350] = {.lex_state = 2},
  [2351] = {.lex_state = 71},
  [2352] = {.lex_state = 71},
  [2353] = {.lex_state = 71},
  [2354] = {.lex_state = 71},
  [2355] = {.lex_state = 71},
  [2356] = {.lex_state = 71},
  [2357] = {.lex_state = 2},
  [2358] = {.lex_state = 71},
  [2359] = {.lex_state = 71},
  [2360] = {.lex_state = 71},
  [2361] = {.lex_state = 2},
  [2362] = {.lex_state = 2},
  [2363] = {.lex_state = 71},
  [2364] = {.lex_state = 71},
  [2365] = {.lex_state = 71},
  [2366] = {.lex_state = 71},
  [2367] = {.lex_state = 71},
  [2368] = {.lex_state = 71, .external_lex_state = 4},
  [2369] = {.lex_state = 71},
  [2370] = {.lex_state = 71},
  [2371] = {.lex_state = 71},
  [2372] = {.lex_state = 71},
  [2373] = {.lex_state = 71},
  [2374] = {.lex_state = 71},
  [2375] = {.lex_state = 71},
  [2376] = {.lex_state = 71},
  [2377] = {.lex_state = 71},
  [2378] = {.lex_state = 71},
  [2379] = {.lex_state = 71},
  [2380] = {.lex_state = 71},
  [2381] = {.lex_state = 71, .external_lex_state = 4},
  [2382] = {.lex_state = 71, .external_lex_state = 4},
  [2383] = {.lex_state = 71},
  [2384] = {.lex_state = 8, .external_lex_state = 4},
  [2385] = {.lex_state = 8, .external_lex_state = 4},
  [2386] = {.lex_state = 8, .external_lex_state = 4},
  [2387] = {.lex_state = 8, .external_lex_state = 4},
  [2388] = {.lex_state = 8, .external_lex_state = 4},
  [2389] = {.lex_state = 8, .external_lex_state = 4},
  [2390] = {.lex_state = 8, .external_lex_state = 4},
  [2391] = {.lex_state = 8, .external_lex_state = 4},
  [2392] = {.lex_state = 8, .external_lex_state = 4},
  [2393] = {.lex_state = 8, .external_lex_state = 4},
  [2394] = {.lex_state = 71},
  [2395] = {.lex_state = 71},
  [2396] = {.lex_state = 71},
  [2397] = {.lex_state = 71},
  [2398] = {.lex_state = 71},
  [2399] = {.lex_state = 8, .external_lex_state = 4},
  [2400] = {.lex_state = 8, .external_lex_state = 4},
  [2401] = {.lex_state = 8, .external_lex_state = 4},
  [2402] = {.lex_state = 8, .external_lex_state = 4},
  [2403] = {.lex_state = 8, .external_lex_state = 4},
  [2404] = {.lex_state = 8, .external_lex_state = 4},
  [2405] = {.lex_state = 8, .external_lex_state = 4},
  [2406] = {.lex_state = 8, .external_lex_state = 4},
  [2407] = {.lex_state = 8, .external_lex_state = 4},
  [2408] = {.lex_state = 8, .external_lex_state = 4},
  [2409] = {.lex_state = 71},
  [2410] = {.lex_state = 71, .external_lex_state = 4},
  [2411] = {.lex_state = 71},
  [2412] = {.lex_state = 8, .external_lex_state = 4},
  [2413] = {.lex_state = 71},
  [2414] = {.lex_state = 71},
  [2415] = {.lex_state = 71},
  [2416] = {.lex_state = 71},
  [2417] = {.lex_state = 71},
  [2418] = {.lex_state = 8, .external_lex_state = 4},
  [2419] = {.lex_state = 8, .external_lex_state = 4},
  [2420] = {.lex_state = 8, .external_lex_state = 4},
  [2421] = {.lex_state = 8, .external_lex_state = 4},
  [2422] = {.lex_state = 8, .external_lex_state = 4},
  [2423] = {.lex_state = 71},
  [2424] = {.lex_state = 8, .external_lex_state = 4},
  [2425] = {.lex_state = 8, .external_lex_state = 4},
  [2426] = {.lex_state = 71},
  [2427] = {.lex_state = 8, .external_lex_state = 4},
  [2428] = {.lex_state = 8, .external_lex_state = 4},
  [2429] = {.lex_state = 8, .external_lex_state = 4},
  [2430] = {.lex_state = 8, .external_lex_state = 4},
  [2431] = {.lex_state = 71},
  [2432] = {.lex_state = 71},
  [2433] = {.lex_state = 8, .external_lex_state = 4},
  [2434] = {.lex_state = 8, .external_lex_state = 4},
  [2435] = {.lex_state = 71, .external_lex_state = 4},
  [2436] = {.lex_state = 71},
  [2437] = {.lex_state = 71},
  [2438] = {.lex_state = 71, .external_lex_state = 4},
  [2439] = {.lex_state = 71, .external_lex_state = 4},
  [2440] = {.lex_state = 71, .external_lex_state = 4},
  [2441] = {.lex_state = 71},
  [2442] = {.lex_state = 71, .external_lex_state = 4},
  [2443] = {.lex_state = 71},
  [2444] = {.lex_state = 71},
  [2445] = {.lex_state = 71},
  [2446] = {.lex_state = 71},
  [2447] = {.lex_state = 71},
  [2448] = {.lex_state = 71},
  [2449] = {.lex_state = 71},
  [2450] = {.lex_state = 8, .external_lex_state = 4},
  [2451] = {.lex_state = 71, .external_lex_state = 4},
  [2452] = {.lex_state = 71, .external_lex_state = 4},
  [2453] = {.lex_state = 71, .external_lex_state = 4},
  [2454] = {.lex_state = 71, .external_lex_state = 4},
  [2455] = {.lex_state = 71},
  [2456] = {.lex_state = 71, .external_lex_state = 4},
  [2457] = {.lex_state = 8, .external_lex_state = 5},
  [2458] = {.lex_state = 8, .external_lex_state = 4},
  [2459] = {.lex_state = 8, .external_lex_state = 4},
  [2460] = {.lex_state = 71},
  [2461] = {.lex_state = 71, .external_lex_state = 4},
  [2462] = {.lex_state = 8, .external_lex_state = 4},
  [2463] = {.lex_state = 71, .external_lex_state = 4},
  [2464] = {.lex_state = 71},
  [2465] = {.lex_state = 71, .external_lex_state = 4},
  [2466] = {.lex_state = 71, .external_lex_state = 4},
  [2467] = {.lex_state = 71, .external_lex_state = 4},
  [2468] = {.lex_state = 8, .external_lex_state = 4},
  [2469] = {.lex_state = 8, .external_lex_state = 5},
  [2470] = {.lex_state = 8, .external_lex_state = 5},
  [2471] = {.lex_state = 71, .external_lex_state = 4},
  [2472] = {.lex_state = 8, .external_lex_state = 4},
  [2473] = {.lex_state = 71, .external_lex_state = 5},
  [2474] = {.lex_state = 8, .external_lex_state = 4},
  [2475] = {.lex_state = 71, .external_lex_state = 4},
  [2476] = {.lex_state = 71},
  [2477] = {.lex_state = 8, .external_lex_state = 5},
  [2478] = {.lex_state = 8, .external_lex_state = 5},
  [2479] = {.lex_state = 8, .external_lex_state = 5},
  [2480] = {.lex_state = 8, .external_lex_state = 5},
  [2481] = {.lex_state = 8, .external_lex_state = 5},
  [2482] = {.lex_state = 8, .external_lex_state = 5},
  [2483] = {.lex_state = 71, .external_lex_state = 4},
  [2484] = {.lex_state = 71, .external_lex_state = 4},
  [2485] = {.lex_state = 71, .external_lex_state = 4},
  [2486] = {.lex_state = 8, .external_lex_state = 5},
  [2487] = {.lex_state = 8, .external_lex_state = 5},
  [2488] = {.lex_state = 71, .external_lex_state = 4},
  [2489] = {.lex_state = 71, .external_lex_state = 4},
  [2490] = {.lex_state = 71, .external_lex_state = 4},
  [2491] = {.lex_state = 71, .external_lex_state = 4},
  [2492] = {.lex_state = 8, .external_lex_state = 5},
  [2493] = {.lex_state = 71, .external_lex_state = 4},
  [2494] = {.lex_state = 8, .external_lex_state = 5},
  [2495] = {.lex_state = 71, .external_lex_state = 4},
  [2496] = {.lex_state = 71, .external_lex_state = 4},
  [2497] = {.lex_state = 8, .external_lex_state = 5},
  [2498] = {.lex_state = 8, .external_lex_state = 5},
  [2499] = {.lex_state = 71},
  [2500] = {.lex_state = 8, .external_lex_state = 5},
  [2501] = {.lex_state = 71, .external_lex_state = 4},
  [2502] = {.lex_state = 71, .external_lex_state = 4},
  [2503] = {.lex_state = 8, .external_lex_state = 5},
  [2504] = {.lex_state = 8, .external_lex_state = 5},
  [2505] = {.lex_state = 8, .external_lex_state = 5},
  [2506] = {.lex_state = 8, .external_lex_state = 5},
  [2507] = {.lex_state = 71, .external_lex_state = 4},
  [2508] = {.lex_state = 8, .external_lex_state = 5},
  [2509] = {.lex_state = 8, .external_lex_state = 5},
  [2510] = {.lex_state = 8, .external_lex_state = 5},
  [2511] = {.lex_state = 8, .external_lex_state = 5},
  [2512] = {.lex_state = 8, .external_lex_state = 5},
  [2513] = {.lex_state = 8, .external_lex_state = 5},
  [2514] = {.lex_state = 8, .external_lex_state = 5},
  [2515] = {.lex_state = 8, .external_lex_state = 5},
  [2516] = {.lex_state = 8, .external_lex_state = 5},
  [2517] = {.lex_state = 8, .external_lex_state = 5},
  [2518] = {.lex_state = 8, .external_lex_state = 5},
  [2519] = {.lex_state = 71, .external_lex_state = 4},
  [2520] = {.lex_state = 8, .external_lex_state = 5},
  [2521] = {.lex_state = 8, .external_lex_state = 5},
  [2522] = {.lex_state = 8, .external_lex_state = 5},
  [2523] = {.lex_state = 8, .external_lex_state = 5},
  [2524] = {.lex_state = 71, .external_lex_state = 4},
  [2525] = {.lex_state = 71, .external_lex_state = 4},
  [2526] = {.lex_state = 71, .external_lex_state = 4},
  [2527] = {.lex_state = 8, .external_lex_state = 5},
  [2528] = {.lex_state = 71, .external_lex_state = 4},
  [2529] = {.lex_state = 8, .external_lex_state = 5},
  [2530] = {.lex_state = 71, .external_lex_state = 4},
  [2531] = {.lex_state = 71, .external_lex_state = 4},
  [2532] = {.lex_state = 71, .external_lex_state = 4},
  [2533] = {.lex_state = 71, .external_lex_state = 5},
  [2534] = {.lex_state = 71, .external_lex_state = 4},
  [2535] = {.lex_state = 71, .external_lex_state = 4},
  [2536] = {.lex_state = 71, .external_lex_state = 4},
  [2537] = {.lex_state = 71, .external_lex_state = 4},
  [2538] = {.lex_state = 71, .external_lex_state = 4},
  [2539] = {.lex_state = 71, .external_lex_state = 5},
  [2540] = {.lex_state = 71, .external_lex_state = 4},
  [2541] = {.lex_state = 71, .external_lex_state = 4},
  [2542] = {.lex_state = 71, .external_lex_state = 4},
  [2543] = {.lex_state = 71, .external_lex_state = 4},
  [2544] = {.lex_state = 71, .external_lex_state = 4},
  [2545] = {.lex_state = 71, .external_lex_state = 4},
  [2546] = {.lex_state = 71, .external_lex_state = 4},
  [2547] = {.lex_state = 71, .external_lex_state = 4},
  [2548] = {.lex_state = 71, .external_lex_state = 4},
  [2549] = {.lex_state = 71, .external_lex_state = 4},
  [2550] = {.lex_state = 71, .external_lex_state = 4},
  [2551] = {.lex_state = 71, .external_lex_state = 4},
  [2552] = {.lex_state = 71, .external_lex_state = 4},
  [2553] = {.lex_state = 71, .external_lex_state = 4},
  [2554] = {.lex_state = 71, .external_lex_state = 4},
  [2555] = {.lex_state = 71, .external_lex_state = 4},
  [2556] = {.lex_state = 71, .external_lex_state = 4},
  [2557] = {.lex_state = 71, .external_lex_state = 4},
  [2558] = {.lex_state = 71, .external_lex_state = 4},
  [2559] = {.lex_state = 8, .external_lex_state = 5},
  [2560] = {.lex_state = 71, .external_lex_state = 4},
  [2561] = {.lex_state = 71, .external_lex_state = 4},
  [2562] = {.lex_state = 71, .external_lex_state = 4},
  [2563] = {.lex_state = 71, .external_lex_state = 4},
  [2564] = {.lex_state = 71, .external_lex_state = 4},
  [2565] = {.lex_state = 71, .external_lex_state = 4},
  [2566] = {.lex_state = 71, .external_lex_state = 4},
  [2567] = {.lex_state = 71, .external_lex_state = 4},
  [2568] = {.lex_state = 8, .external_lex_state = 5},
  [2569] = {.lex_state = 71, .external_lex_state = 4},
  [2570] = {.lex_state = 71, .external_lex_state = 4},
  [2571] = {.lex_state = 71, .external_lex_state = 5},
  [2572] = {.lex_state = 71, .external_lex_state = 4},
  [2573] = {.lex_state = 71, .external_lex_state = 4},
  [2574] = {.lex_state = 71, .external_lex_state = 4},
  [2575] = {.lex_state = 8, .external_lex_state = 5},
  [2576] = {.lex_state = 8, .external_lex_state = 5},
  [2577] = {.lex_state = 8, .external_lex_state = 5},
  [2578] = {.lex_state = 71, .external_lex_state = 4},
  [2579] = {.lex_state = 71, .external_lex_state = 4},
  [2580] = {.lex_state = 71, .external_lex_state = 4},
  [2581] = {.lex_state = 71, .external_lex_state = 4},
  [2582] = {.lex_state = 8, .external_lex_state = 5},
  [2583] = {.lex_state = 71, .external_lex_state = 4},
  [2584] = {.lex_state = 71, .external_lex_state = 4},
  [2585] = {.lex_state = 71, .external_lex_state = 4},
  [2586] = {.lex_state = 71, .external_lex_state = 4},
  [2587] = {.lex_state = 71, .external_lex_state = 4},
  [2588] = {.lex_state = 71, .external_lex_state = 4},
  [2589] = {.lex_state = 71, .external_lex_state = 4},
  [2590] = {.lex_state = 71, .external_lex_state = 4},
  [2591] = {.lex_state = 71, .external_lex_state = 4},
  [2592] = {.lex_state = 8, .external_lex_state = 5},
  [2593] = {.lex_state = 71, .external_lex_state = 4},
  [2594] = {.lex_state = 71, .external_lex_state = 5},
  [2595] = {.lex_state = 8},
  [2596] = {.lex_state = 8},
  [2597] = {.lex_state = 8},
  [2598] = {.lex_state = 71},
  [2599] = {.lex_state = 71, .external_lex_state = 4},
  [2600] = {.lex_state = 71, .external_lex_state = 4},
  [2601] = {.lex_state = 71},
  [2602] = {.lex_state = 71, .external_lex_state = 4},
  [2603] = {.lex_state = 71},
  [2604] = {.lex_state = 71},
  [2605] = {.lex_state = 71},
  [2606] = {.lex_state = 71, .external_lex_state = 4},
  [2607] = {.lex_state = 71, .external_lex_state = 4},
  [2608] = {.lex_state = 71},
  [2609] = {.lex_state = 71},
  [2610] = {.lex_state = 71, .external_lex_state = 5},
  [2611] = {.lex_state = 71},
  [2612] = {.lex_state = 71},
  [2613] = {.lex_state = 71, .external_lex_state = 4},
  [2614] = {.lex_state = 71, .external_lex_state = 5},
  [2615] = {.lex_state = 71},
  [2616] = {.lex_state = 71},
  [2617] = {.lex_state = 71},
  [2618] = {.lex_state = 71},
  [2619] = {.lex_state = 71, .external_lex_state = 5},
  [2620] = {.lex_state = 71},
  [2621] = {.lex_state = 71},
  [2622] = {.lex_state = 71, .external_lex_state = 5},
  [2623] = {.lex_state = 71, .external_lex_state = 4},
  [2624] = {.lex_state = 71},
  [2625] = {.lex_state = 71, .external_lex_state = 5},
  [2626] = {.lex_state = 71},
  [2627] = {.lex_state = 71},
  [2628] = {.lex_state = 71, .external_lex_state = 5},
  [2629] = {.lex_state = 71, .external_lex_state = 4},
  [2630] = {.lex_state = 71},
  [2631] = {.lex_state = 71, .external_lex_state = 5},
  [2632] = {.lex_state = 71},
  [2633] = {.lex_state = 71, .external_lex_state = 5},
  [2634] = {.lex_state = 71},
  [2635] = {.lex_state = 71, .external_lex_state = 5},
  [2636] = {.lex_state = 71, .external_lex_state = 5},
  [2637] = {.lex_state = 71, .external_lex_state = 5},
  [2638] = {.lex_state = 71},
  [2639] = {.lex_state = 71, .external_lex_state = 5},
  [2640] = {.lex_state = 71, .external_lex_state = 5},
  [2641] = {.lex_state = 71, .external_lex_state = 5},
  [2642] = {.lex_state = 71, .external_lex_state = 5},
  [2643] = {.lex_state = 71, .external_lex_state = 4},
  [2644] = {.lex_state = 71, .external_lex_state = 5},
  [2645] = {.lex_state = 71, .external_lex_state = 5},
  [2646] = {.lex_state = 7},
  [2647] = {.lex_state = 71, .external_lex_state = 5},
  [2648] = {.lex_state = 71, .external_lex_state = 5},
  [2649] = {.lex_state = 71, .external_lex_state = 5},
  [2650] = {.lex_state = 71},
  [2651] = {.lex_state = 71},
  [2652] = {.lex_state = 71, .external_lex_state = 5},
  [2653] = {.lex_state = 71, .external_lex_state = 5},
  [2654] = {.lex_state = 71, .external_lex_state = 5},
  [2655] = {.lex_state = 71},
  [2656] = {.lex_state = 71},
  [2657] = {.lex_state = 71},
  [2658] = {.lex_state = 71, .external_lex_state = 5},
  [2659] = {.lex_state = 71},
  [2660] = {.lex_state = 71, .external_lex_state = 5},
  [2661] = {.lex_state = 71, .external_lex_state = 5},
  [2662] = {.lex_state = 71, .external_lex_state = 5},
  [2663] = {.lex_state = 71},
  [2664] = {.lex_state = 71},
  [2665] = {.lex_state = 7},
  [2666] = {.lex_state = 71, .external_lex_state = 5},
  [2667] = {.lex_state = 71, .external_lex_state = 5},
  [2668] = {.lex_state = 71, .external_lex_state = 5},
  [2669] = {.lex_state = 71, .external_lex_state = 5},
  [2670] = {.lex_state = 71, .external_lex_state = 4},
  [2671] = {.lex_state = 71, .external_lex_state = 5},
  [2672] = {.lex_state = 71, .external_lex_state = 5},
  [2673] = {.lex_state = 71},
  [2674] = {.lex_state = 71, .external_lex_state = 5},
  [2675] = {.lex_state = 71},
  [2676] = {.lex_state = 71},
  [2677] = {.lex_state = 71, .external_lex_state = 5},
  [2678] = {.lex_state = 71, .external_lex_state = 5},
  [2679] = {.lex_state = 71},
  [2680] = {.lex_state = 71, .external_lex_state = 4},
  [2681] = {.lex_state = 7},
  [2682] = {.lex_state = 71, .external_lex_state = 5},
  [2683] = {.lex_state = 71, .external_lex_state = 5},
  [2684] = {.lex_state = 71, .external_lex_state = 5},
  [2685] = {.lex_state = 71, .external_lex_state = 5},
  [2686] = {.lex_state = 71},
  [2687] = {.lex_state = 71, .external_lex_state = 5},
  [2688] = {.lex_state = 71},
  [2689] = {.lex_state = 71},
  [2690] = {.lex_state = 71},
  [2691] = {.lex_state = 71, .external_lex_state = 5},
  [2692] = {.lex_state = 71},
  [2693] = {.lex_state = 71},
  [2694] = {.lex_state = 71},
  [2695] = {.lex_state = 71, .external_lex_state = 4},
  [2696] = {.lex_state = 71, .external_lex_state = 5},
  [2697] = {.lex_state = 71, .external_lex_state = 5},
  [2698] = {.lex_state = 71, .external_lex_state = 5},
  [2699] = {.lex_state = 71},
  [2700] = {.lex_state = 71, .external_lex_state = 5},
  [2701] = {.lex_state = 71, .external_lex_state = 4},
  [2702] = {.lex_state = 71, .external_lex_state = 5},
  [2703] = {.lex_state = 71, .external_lex_state = 5},
  [2704] = {.lex_state = 71},
  [2705] = {.lex_state = 71},
  [2706] = {.lex_state = 71},
  [2707] = {.lex_state = 71},
  [2708] = {.lex_state = 71, .external_lex_state = 5},
  [2709] = {.lex_state = 71, .external_lex_state = 5},
  [2710] = {.lex_state = 71, .external_lex_state = 5},
  [2711] = {.lex_state = 71},
  [2712] = {.lex_state = 13, .external_lex_state = 6},
  [2713] = {.lex_state = 8},
  [2714] = {.lex_state = 8},
  [2715] = {.lex_state = 13, .external_lex_state = 6},
  [2716] = {.lex_state = 8},
  [2717] = {.lex_state = 71},
  [2718] = {.lex_state = 71, .external_lex_state = 4},
  [2719] = {.lex_state = 13, .external_lex_state = 6},
  [2720] = {.lex_state = 71, .external_lex_state = 4},
  [2721] = {.lex_state = 13, .external_lex_state = 6},
  [2722] = {.lex_state = 71, .external_lex_state = 4},
  [2723] = {.lex_state = 13, .external_lex_state = 6},
  [2724] = {.lex_state = 71, .external_lex_state = 5},
  [2725] = {.lex_state = 13, .external_lex_state = 6},
  [2726] = {.lex_state = 13, .external_lex_state = 6},
  [2727] = {.lex_state = 71},
  [2728] = {.lex_state = 71, .external_lex_state = 4},
  [2729] = {.lex_state = 71},
  [2730] = {.lex_state = 13, .external_lex_state = 6},
  [2731] = {.lex_state = 71},
  [2732] = {.lex_state = 71, .external_lex_state = 4},
  [2733] = {.lex_state = 71},
  [2734] = {.lex_state = 71},
  [2735] = {.lex_state = 71, .external_lex_state = 4},
  [2736] = {.lex_state = 71},
  [2737] = {.lex_state = 71},
  [2738] = {.lex_state = 71, .external_lex_state = 4},
  [2739] = {.lex_state = 71, .external_lex_state = 4},
  [2740] = {.lex_state = 71},
  [2741] = {.lex_state = 71},
  [2742] = {.lex_state = 71},
  [2743] = {.lex_state = 71},
  [2744] = {.lex_state = 71, .external_lex_state = 4},
  [2745] = {.lex_state = 71},
  [2746] = {.lex_state = 71, .external_lex_state = 4},
  [2747] = {.lex_state = 71},
  [2748] = {.lex_state = 71},
  [2749] = {.lex_state = 71, .external_lex_state = 4},
  [2750] = {.lex_state = 71},
  [2751] = {.lex_state = 71, .external_lex_state = 4},
  [2752] = {.lex_state = 71},
  [2753] = {.lex_state = 71},
  [2754] = {.lex_state = 71},
  [2755] = {.lex_state = 71, .external_lex_state = 4},
  [2756] = {.lex_state = 71, .external_lex_state = 4},
  [2757] = {.lex_state = 71, .external_lex_state = 4},
  [2758] = {.lex_state = 71},
  [2759] = {.lex_state = 71, .external_lex_state = 4},
  [2760] = {.lex_state = 71},
  [2761] = {.lex_state = 0, .external_lex_state = 4},
  [2762] = {.lex_state = 71},
  [2763] = {.lex_state = 0, .external_lex_state = 4},
  [2764] = {.lex_state = 71, .external_lex_state = 4},
  [2765] = {.lex_state = 71, .external_lex_state = 4},
  [2766] = {.lex_state = 71, .external_lex_state = 4},
  [2767] = {.lex_state = 71},
  [2768] = {.lex_state = 0, .external_lex_state = 4},
  [2769] = {.lex_state = 71, .external_lex_state = 4},
  [2770] = {.lex_state = 0, .external_lex_state = 4},
  [2771] = {.lex_state = 71},
  [2772] = {.lex_state = 71},
  [2773] = {.lex_state = 71, .external_lex_state = 4},
  [2774] = {.lex_state = 71, .external_lex_state = 4},
  [2775] = {.lex_state = 71},
  [2776] = {.lex_state = 0, .external_lex_state = 4},
  [2777] = {.lex_state = 71},
  [2778] = {.lex_state = 71},
  [2779] = {.lex_state = 71, .external_lex_state = 4},
  [2780] = {.lex_state = 71, .external_lex_state = 4},
  [2781] = {.lex_state = 71, .external_lex_state = 4},
  [2782] = {.lex_state = 71, .external_lex_state = 4},
  [2783] = {.lex_state = 0, .external_lex_state = 4},
  [2784] = {.lex_state = 71},
  [2785] = {.lex_state = 71, .external_lex_state = 4},
  [2786] = {.lex_state = 71},
  [2787] = {.lex_state = 0, .external_lex_state = 4},
  [2788] = {.lex_state = 71},
  [2789] = {.lex_state = 71},
  [2790] = {.lex_state = 71},
  [2791] = {.lex_state = 71, .external_lex_state = 4},
  [2792] = {.lex_state = 71},
  [2793] = {.lex_state = 71, .external_lex_state = 4},
  [2794] = {.lex_state = 71, .external_lex_state = 4},
  [2795] = {.lex_state = 71},
  [2796] = {.lex_state = 71},
  [2797] = {.lex_state = 7},
  [2798] = {.lex_state = 71},
  [2799] = {.lex_state = 71, .external_lex_state = 4},
  [2800] = {.lex_state = 71},
  [2801] = {.lex_state = 71},
  [2802] = {.lex_state = 71, .external_lex_state = 4},
  [2803] = {.lex_state = 71},
  [2804] = {.lex_state = 71},
  [2805] = {.lex_state = 71, .external_lex_state = 4},
  [2806] = {.lex_state = 0, .external_lex_state = 4},
  [2807] = {.lex_state = 0, .external_lex_state = 4},
  [2808] = {.lex_state = 71},
  [2809] = {.lex_state = 71},
  [2810] = {.lex_state = 71},
  [2811] = {.lex_state = 71, .external_lex_state = 4},
  [2812] = {.lex_state = 71},
  [2813] = {.lex_state = 71, .external_lex_state = 4},
  [2814] = {.lex_state = 71, .external_lex_state = 4},
  [2815] = {.lex_state = 71, .external_lex_state = 4},
  [2816] = {.lex_state = 71},
  [2817] = {.lex_state = 71},
  [2818] = {.lex_state = 71},
  [2819] = {.lex_state = 71},
  [2820] = {.lex_state = 71},
  [2821] = {.lex_state = 71, .external_lex_state = 4},
  [2822] = {.lex_state = 71},
  [2823] = {.lex_state = 71},
  [2824] = {.lex_state = 7},
  [2825] = {.lex_state = 71, .external_lex_state = 4},
  [2826] = {.lex_state = 71, .external_lex_state = 4},
  [2827] = {.lex_state = 71},
  [2828] = {.lex_state = 71},
  [2829] = {.lex_state = 7},
  [2830] = {.lex_state = 71},
  [2831] = {.lex_state = 0, .external_lex_state = 4},
  [2832] = {.lex_state = 0, .external_lex_state = 4},
  [2833] = {.lex_state = 71},
  [2834] = {.lex_state = 71, .external_lex_state = 4},
  [2835] = {.lex_state = 71},
  [2836] = {.lex_state = 71},
  [2837] = {.lex_state = 71},
  [2838] = {.lex_state = 71},
  [2839] = {.lex_state = 71},
  [2840] = {.lex_state = 7},
  [2841] = {.lex_state = 0, .external_lex_state = 4},
  [2842] = {.lex_state = 71, .external_lex_state = 5},
  [2843] = {.lex_state = 71, .external_lex_state = 5},
  [2844] = {.lex_state = 71, .external_lex_state = 5},
  [2845] = {.lex_state = 0, .external_lex_state = 4},
  [2846] = {.lex_state = 13, .external_lex_state = 6},
  [2847] = {.lex_state = 0, .external_lex_state = 4},
  [2848] = {.lex_state = 71},
  [2849] = {.lex_state = 71},
  [2850] = {.lex_state = 0, .external_lex_state = 4},
  [2851] = {.lex_state = 71},
  [2852] = {.lex_state = 71},
  [2853] = {.lex_state = 71, .external_lex_state = 5},
  [2854] = {.lex_state = 71},
  [2855] = {.lex_state = 71, .external_lex_state = 5},
  [2856] = {.lex_state = 71},
  [2857] = {.lex_state = 71, .external_lex_state = 5},
  [2858] = {.lex_state = 0, .external_lex_state = 4},
  [2859] = {.lex_state = 71},
  [2860] = {.lex_state = 71},
  [2861] = {.lex_state = 71, .external_lex_state = 5},
  [2862] = {.lex_state = 71},
  [2863] = {.lex_state = 71, .external_lex_state = 5},
  [2864] = {.lex_state = 71},
  [2865] = {.lex_state = 71},
  [2866] = {.lex_state = 71},
  [2867] = {.lex_state = 71, .external_lex_state = 5},
  [2868] = {.lex_state = 13, .external_lex_state = 6},
  [2869] = {.lex_state = 71},
  [2870] = {.lex_state = 71},
  [2871] = {.lex_state = 0, .external_lex_state = 4},
  [2872] = {.lex_state = 0, .external_lex_state = 4},
  [2873] = {.lex_state = 7},
  [2874] = {.lex_state = 71},
  [2875] = {.lex_state = 71, .external_lex_state = 5},
  [2876] = {.lex_state = 71, .external_lex_state = 5},
  [2877] = {.lex_state = 71, .external_lex_state = 5},
  [2878] = {.lex_state = 71},
  [2879] = {.lex_state = 0, .external_lex_state = 4},
  [2880] = {.lex_state = 13},
  [2881] = {.lex_state = 71},
  [2882] = {.lex_state = 71},
  [2883] = {.lex_state = 71},
  [2884] = {.lex_state = 13},
  [2885] = {.lex_state = 0, .external_lex_state = 4},
  [2886] = {.lex_state = 13},
  [2887] = {.lex_state = 0, .external_lex_state = 4},
  [2888] = {.lex_state = 0, .external_lex_state = 4},
  [2889] = {.lex_state = 71, .external_lex_state = 5},
  [2890] = {.lex_state = 71},
  [2891] = {.lex_state = 71},
  [2892] = {.lex_state = 13, .external_lex_state = 6},
  [2893] = {.lex_state = 71},
  [2894] = {.lex_state = 0, .external_lex_state = 4},
  [2895] = {.lex_state = 0, .external_lex_state = 4},
  [2896] = {.lex_state = 13, .external_lex_state = 6},
  [2897] = {.lex_state = 0, .external_lex_state = 4},
  [2898] = {.lex_state = 71, .external_lex_state = 5},
  [2899] = {.lex_state = 71, .external_lex_state = 4},
  [2900] = {.lex_state = 71},
  [2901] = {.lex_state = 71},
  [2902] = {.lex_state = 71},
  [2903] = {.lex_state = 71},
  [2904] = {.lex_state = 0, .external_lex_state = 4},
  [2905] = {.lex_state = 0, .external_lex_state = 4},
  [2906] = {.lex_state = 71},
  [2907] = {.lex_state = 0},
  [2908] = {.lex_state = 71},
  [2909] = {.lex_state = 71},
  [2910] = {.lex_state = 0, .external_lex_state = 4},
  [2911] = {.lex_state = 71},
  [2912] = {.lex_state = 0, .external_lex_state = 4},
  [2913] = {.lex_state = 71},
  [2914] = {.lex_state = 71},
  [2915] = {.lex_state = 71, .external_lex_state = 5},
  [2916] = {.lex_state = 0, .external_lex_state = 4},
  [2917] = {.lex_state = 71},
  [2918] = {.lex_state = 71},
  [2919] = {.lex_state = 71},
  [2920] = {.lex_state = 13},
  [2921] = {.lex_state = 71},
  [2922] = {.lex_state = 71, .external_lex_state = 5},
  [2923] = {.lex_state = 13, .external_lex_state = 6},
  [2924] = {.lex_state = 71},
  [2925] = {.lex_state = 71, .external_lex_state = 5},
  [2926] = {.lex_state = 0, .external_lex_state = 4},
  [2927] = {.lex_state = 71, .external_lex_state = 5},
  [2928] = {.lex_state = 71},
  [2929] = {.lex_state = 71},
  [2930] = {.lex_state = 13},
  [2931] = {.lex_state = 0, .external_lex_state = 4},
  [2932] = {.lex_state = 71},
  [2933] = {.lex_state = 71},
  [2934] = {.lex_state = 71},
  [2935] = {.lex_state = 71},
  [2936] = {.lex_state = 71},
  [2937] = {.lex_state = 71},
  [2938] = {.lex_state = 71, .external_lex_state = 5},
  [2939] = {.lex_state = 71},
  [2940] = {.lex_state = 71, .external_lex_state = 4},
  [2941] = {.lex_state = 13},
  [2942] = {.lex_state = 71},
  [2943] = {.lex_state = 71},
  [2944] = {.lex_state = 71},
  [2945] = {.lex_state = 71},
  [2946] = {.lex_state = 71, .external_lex_state = 4},
  [2947] = {.lex_state = 71},
  [2948] = {.lex_state = 71, .external_lex_state = 4},
  [2949] = {.lex_state = 71},
  [2950] = {.lex_state = 71},
  [2951] = {.lex_state = 13},
  [2952] = {.lex_state = 71},
  [2953] = {.lex_state = 71},
  [2954] = {.lex_state = 71},
  [2955] = {.lex_state = 71},
  [2956] = {.lex_state = 71},
  [2957] = {.lex_state = 71},
  [2958] = {.lex_state = 0, .external_lex_state = 4},
  [2959] = {.lex_state = 71, .external_lex_state = 5},
  [2960] = {.lex_state = 71},
  [2961] = {.lex_state = 71},
  [2962] = {.lex_state = 0, .external_lex_state = 4},
  [2963] = {.lex_state = 71, .external_lex_state = 5},
  [2964] = {.lex_state = 71, .external_lex_state = 5},
  [2965] = {.lex_state = 71},
  [2966] = {.lex_state = 71},
  [2967] = {.lex_state = 71},
  [2968] = {.lex_state = 13},
  [2969] = {.lex_state = 71},
  [2970] = {.lex_state = 71},
  [2971] = {.lex_state = 71, .external_lex_state = 5},
  [2972] = {.lex_state = 71, .external_lex_state = 5},
  [2973] = {.lex_state = 71, .external_lex_state = 5},
  [2974] = {.lex_state = 13},
  [2975] = {.lex_state = 71},
  [2976] = {.lex_state = 71, .external_lex_state = 5},
  [2977] = {.lex_state = 71},
  [2978] = {.lex_state = 71},
  [2979] = {.lex_state = 71},
  [2980] = {.lex_state = 71},
  [2981] = {.lex_state = 71},
  [2982] = {.lex_state = 71},
  [2983] = {.lex_state = 71},
  [2984] = {.lex_state = 71},
  [2985] = {.lex_state = 71},
  [2986] = {.lex_state = 71, .external_lex_state = 5},
  [2987] = {.lex_state = 71},
  [2988] = {.lex_state = 71},
  [2989] = {.lex_state = 71},
  [2990] = {.lex_state = 71},
  [2991] = {.lex_state = 0, .external_lex_state = 4},
  [2992] = {.lex_state = 0, .external_lex_state = 4},
  [2993] = {.lex_state = 71},
  [2994] = {.lex_state = 71},
  [2995] = {.lex_state = 71},
  [2996] = {.lex_state = 71},
  [2997] = {.lex_state = 71},
  [2998] = {.lex_state = 0, .external_lex_state = 4},
  [2999] = {.lex_state = 0, .external_lex_state = 4},
  [3000] = {.lex_state = 0, .external_lex_state = 4},
  [3001] = {.lex_state = 0, .external_lex_state = 4},
  [3002] = {.lex_state = 0, .external_lex_state = 4},
  [3003] = {.lex_state = 0, .external_lex_state = 4},
  [3004] = {.lex_state = 0, .external_lex_state = 4},
  [3005] = {.lex_state = 71},
  [3006] = {.lex_state = 71},
  [3007] = {.lex_state = 0, .external_lex_state = 4},
  [3008] = {.lex_state = 0},
  [3009] = {.lex_state = 0},
  [3010] = {.lex_state = 0},
  [3011] = {.lex_state = 71},
  [3012] = {.lex_state = 0, .external_lex_state = 4},
  [3013] = {.lex_state = 71},
  [3014] = {.lex_state = 0, .external_lex_state = 4},
  [3015] = {.lex_state = 71},
  [3016] = {.lex_state = 71, .external_lex_state = 5},
  [3017] = {.lex_state = 0, .external_lex_state = 4},
  [3018] = {.lex_state = 71, .external_lex_state = 5},
  [3019] = {.lex_state = 71},
  [3020] = {.lex_state = 71},
  [3021] = {.lex_state = 71},
  [3022] = {.lex_state = 71},
  [3023] = {.lex_state = 0, .external_lex_state = 4},
  [3024] = {.lex_state = 71},
  [3025] = {.lex_state = 71, .external_lex_state = 5},
  [3026] = {.lex_state = 71, .external_lex_state = 4},
  [3027] = {.lex_state = 0, .external_lex_state = 4},
  [3028] = {.lex_state = 0, .external_lex_state = 4},
  [3029] = {.lex_state = 0, .external_lex_state = 4},
  [3030] = {.lex_state = 71, .external_lex_state = 5},
  [3031] = {.lex_state = 7},
  [3032] = {.lex_state = 0},
  [3033] = {.lex_state = 0, .external_lex_state = 4},
  [3034] = {.lex_state = 0, .external_lex_state = 4},
  [3035] = {.lex_state = 0, .external_lex_state = 4},
  [3036] = {.lex_state = 2},
  [3037] = {.lex_state = 71},
  [3038] = {.lex_state = 0, .external_lex_state = 4},
  [3039] = {.lex_state = 0, .external_lex_state = 4},
  [3040] = {.lex_state = 0, .external_lex_state = 4},
  [3041] = {.lex_state = 0, .external_lex_state = 4},
  [3042] = {.lex_state = 0, .external_lex_state = 4},
  [3043] = {.lex_state = 0, .external_lex_state = 4},
  [3044] = {.lex_state = 71},
  [3045] = {.lex_state = 0, .external_lex_state = 4},
  [3046] = {.lex_state = 71, .external_lex_state = 5},
  [3047] = {.lex_state = 0, .external_lex_state = 4},
  [3048] = {.lex_state = 71},
  [3049] = {.lex_state = 71},
  [3050] = {.lex_state = 71, .external_lex_state = 4},
  [3051] = {.lex_state = 0, .external_lex_state = 4},
  [3052] = {.lex_state = 0, .external_lex_state = 4},
  [3053] = {.lex_state = 0},
  [3054] = {.lex_state = 71},
  [3055] = {.lex_state = 0, .external_lex_state = 4},
  [3056] = {.lex_state = 71},
  [3057] = {.lex_state = 0, .external_lex_state = 4},
  [3058] = {.lex_state = 71},
  [3059] = {.lex_state = 0, .external_lex_state = 4},
  [3060] = {.lex_state = 0, .external_lex_state = 4},
  [3061] = {.lex_state = 71},
  [3062] = {.lex_state = 0, .external_lex_state = 4},
  [3063] = {.lex_state = 0, .external_lex_state = 4},
  [3064] = {.lex_state = 71, .external_lex_state = 5},
  [3065] = {.lex_state = 0, .external_lex_state = 4},
  [3066] = {.lex_state = 71},
  [3067] = {.lex_state = 71},
  [3068] = {.lex_state = 0, .external_lex_state = 4},
  [3069] = {.lex_state = 0},
  [3070] = {.lex_state = 71},
  [3071] = {.lex_state = 71},
  [3072] = {.lex_state = 0, .external_lex_state = 4},
  [3073] = {.lex_state = 0, .external_lex_state = 4},
  [3074] = {.lex_state = 0, .external_lex_state = 4},
  [3075] = {.lex_state = 71},
  [3076] = {.lex_state = 0, .external_lex_state = 4},
  [3077] = {.lex_state = 0, .external_lex_state = 4},
  [3078] = {.lex_state = 0, .external_lex_state = 4},
  [3079] = {.lex_state = 0, .external_lex_state = 4},
  [3080] = {.lex_state = 71},
  [3081] = {.lex_state = 0, .external_lex_state = 4},
  [3082] = {.lex_state = 0, .external_lex_state = 4},
  [3083] = {.lex_state = 71},
  [3084] = {.lex_state = 0, .external_lex_state = 4},
  [3085] = {.lex_state = 0, .external_lex_state = 4},
  [3086] = {.lex_state = 0, .external_lex_state = 4},
  [3087] = {.lex_state = 71},
  [3088] = {.lex_state = 2},
  [3089] = {.lex_state = 0, .external_lex_state = 4},
  [3090] = {.lex_state = 0, .external_lex_state = 4},
  [3091] = {.lex_state = 0, .external_lex_state = 4},
  [3092] = {.lex_state = 0, .external_lex_state = 4},
  [3093] = {.lex_state = 0, .external_lex_state = 4},
  [3094] = {.lex_state = 0, .external_lex_state = 4},
  [3095] = {.lex_state = 0, .external_lex_state = 4},
  [3096] = {.lex_state = 71},
  [3097] = {.lex_state = 71},
  [3098] = {.lex_state = 71},
  [3099] = {.lex_state = 71},
  [3100] = {.lex_state = 0, .external_lex_state = 4},
  [3101] = {.lex_state = 71},
  [3102] = {.lex_state = 71, .external_lex_state = 5},
  [3103] = {.lex_state = 0, .external_lex_state = 4},
  [3104] = {.lex_state = 0, .external_lex_state = 4},
  [3105] = {.lex_state = 0, .external_lex_state = 4},
  [3106] = {.lex_state = 13, .external_lex_state = 6},
  [3107] = {.lex_state = 13, .external_lex_state = 6},
  [3108] = {.lex_state = 71},
  [3109] = {.lex_state = 0, .external_lex_state = 4},
  [3110] = {.lex_state = 71, .external_lex_state = 4},
  [3111] = {.lex_state = 71},
  [3112] = {.lex_state = 0, .external_lex_state = 4},
  [3113] = {.lex_state = 0},
  [3114] = {.lex_state = 0, .external_lex_state = 4},
  [3115] = {.lex_state = 0, .external_lex_state = 4},
  [3116] = {.lex_state = 71},
  [3117] = {.lex_state = 13, .external_lex_state = 6},
  [3118] = {.lex_state = 71},
  [3119] = {.lex_state = 71},
  [3120] = {.lex_state = 0, .external_lex_state = 4},
  [3121] = {.lex_state = 71},
  [3122] = {.lex_state = 0, .external_lex_state = 4},
  [3123] = {.lex_state = 71},
  [3124] = {.lex_state = 0, .external_lex_state = 4},
  [3125] = {.lex_state = 0, .external_lex_state = 4},
  [3126] = {.lex_state = 0, .external_lex_state = 4},
  [3127] = {.lex_state = 0, .external_lex_state = 4},
  [3128] = {.lex_state = 0, .external_lex_state = 4},
  [3129] = {.lex_state = 0, .external_lex_state = 4},
  [3130] = {.lex_state = 71},
  [3131] = {.lex_state = 0, .external_lex_state = 4},
  [3132] = {.lex_state = 71, .external_lex_state = 5},
  [3133] = {.lex_state = 0, .external_lex_state = 4},
  [3134] = {.lex_state = 0, .external_lex_state = 4},
  [3135] = {.lex_state = 0, .external_lex_state = 4},
  [3136] = {.lex_state = 0, .external_lex_state = 4},
  [3137] = {.lex_state = 0, .external_lex_state = 4},
  [3138] = {.lex_state = 71},
  [3139] = {.lex_state = 0, .external_lex_state = 4},
  [3140] = {.lex_state = 71, .external_lex_state = 4},
  [3141] = {.lex_state = 0, .external_lex_state = 4},
  [3142] = {.lex_state = 0, .external_lex_state = 4},
  [3143] = {.lex_state = 0, .external_lex_state = 4},
  [3144] = {.lex_state = 0, .external_lex_state = 4},
  [3145] = {.lex_state = 0, .external_lex_state = 4},
  [3146] = {.lex_state = 0, .external_lex_state = 4},
  [3147] = {.lex_state = 0, .external_lex_state = 4},
  [3148] = {.lex_state = 71},
  [3149] = {.lex_state = 0, .external_lex_state = 4},
  [3150] = {.lex_state = 0, .external_lex_state = 4},
  [3151] = {.lex_state = 13, .external_lex_state = 6},
  [3152] = {.lex_state = 0, .external_lex_state = 4},
  [3153] = {.lex_state = 0, .external_lex_state = 4},
  [3154] = {.lex_state = 0, .external_lex_state = 4},
  [3155] = {.lex_state = 0},
  [3156] = {.lex_state = 0, .external_lex_state = 4},
  [3157] = {.lex_state = 0, .external_lex_state = 4},
  [3158] = {.lex_state = 0, .external_lex_state = 4},
  [3159] = {.lex_state = 71},
  [3160] = {.lex_state = 0, .external_lex_state = 4},
  [3161] = {.lex_state = 71},
  [3162] = {.lex_state = 71},
  [3163] = {.lex_state = 0, .external_lex_state = 4},
  [3164] = {.lex_state = 13, .external_lex_state = 6},
  [3165] = {.lex_state = 71},
  [3166] = {.lex_state = 71},
  [3167] = {.lex_state = 71},
  [3168] = {.lex_state = 0, .external_lex_state = 4},
  [3169] = {.lex_state = 0, .external_lex_state = 4},
  [3170] = {.lex_state = 0},
  [3171] = {.lex_state = 71},
  [3172] = {.lex_state = 0, .external_lex_state = 4},
  [3173] = {.lex_state = 7},
  [3174] = {.lex_state = 0, .external_lex_state = 4},
  [3175] = {.lex_state = 0, .external_lex_state = 4},
  [3176] = {.lex_state = 0},
  [3177] = {.lex_state = 71, .external_lex_state = 4},
  [3178] = {.lex_state = 71, .external_lex_state = 4},
  [3179] = {.lex_state = 71},
  [3180] = {.lex_state = 0, .external_lex_state = 4},
  [3181] = {.lex_state = 71, .external_lex_state = 4},
  [3182] = {.lex_state = 71},
  [3183] = {.lex_state = 71},
  [3184] = {.lex_state = 71, .external_lex_state = 5},
  [3185] = {.lex_state = 13, .external_lex_state = 6},
  [3186] = {.lex_state = 0, .external_lex_state = 4},
  [3187] = {.lex_state = 0, .external_lex_state = 4},
  [3188] = {.lex_state = 71},
  [3189] = {.lex_state = 13, .external_lex_state = 6},
  [3190] = {.lex_state = 0},
  [3191] = {.lex_state = 71},
  [3192] = {.lex_state = 71},
  [3193] = {.lex_state = 71},
  [3194] = {.lex_state = 71},
  [3195] = {.lex_state = 71},
  [3196] = {.lex_state = 0, .external_lex_state = 4},
  [3197] = {.lex_state = 0, .external_lex_state = 4},
  [3198] = {.lex_state = 71},
  [3199] = {.lex_state = 0, .external_lex_state = 4},
  [3200] = {.lex_state = 71},
  [3201] = {.lex_state = 71},
  [3202] = {.lex_state = 0},
  [3203] = {.lex_state = 71, .external_lex_state = 5},
  [3204] = {.lex_state = 71},
  [3205] = {.lex_state = 0, .external_lex_state = 4},
  [3206] = {.lex_state = 71},
  [3207] = {.lex_state = 0, .external_lex_state = 4},
  [3208] = {.lex_state = 0, .external_lex_state = 4},
  [3209] = {.lex_state = 71},
  [3210] = {.lex_state = 0, .external_lex_state = 4},
  [3211] = {.lex_state = 71},
  [3212] = {.lex_state = 71},
  [3213] = {.lex_state = 71, .external_lex_state = 5},
  [3214] = {.lex_state = 13, .external_lex_state = 6},
  [3215] = {.lex_state = 13, .external_lex_state = 6},
  [3216] = {.lex_state = 71},
  [3217] = {.lex_state = 0, .external_lex_state = 4},
  [3218] = {.lex_state = 71},
  [3219] = {.lex_state = 71},
  [3220] = {.lex_state = 0, .external_lex_state = 4},
  [3221] = {.lex_state = 71},
  [3222] = {.lex_state = 0, .external_lex_state = 4},
  [3223] = {.lex_state = 0, .external_lex_state = 4},
  [3224] = {.lex_state = 0, .external_lex_state = 4},
  [3225] = {.lex_state = 0, .external_lex_state = 4},
  [3226] = {.lex_state = 71, .external_lex_state = 5},
  [3227] = {.lex_state = 0},
  [3228] = {.lex_state = 0, .external_lex_state = 4},
  [3229] = {.lex_state = 0, .external_lex_state = 4},
  [3230] = {.lex_state = 0, .external_lex_state = 4},
  [3231] = {.lex_state = 0, .external_lex_state = 4},
  [3232] = {.lex_state = 71},
  [3233] = {.lex_state = 0, .external_lex_state = 4},
  [3234] = {.lex_state = 0, .external_lex_state = 4},
  [3235] = {.lex_state = 0, .external_lex_state = 4},
  [3236] = {.lex_state = 0, .external_lex_state = 4},
  [3237] = {.lex_state = 0, .external_lex_state = 4},
  [3238] = {.lex_state = 0, .external_lex_state = 4},
  [3239] = {.lex_state = 71},
  [3240] = {.lex_state = 0, .external_lex_state = 4},
  [3241] = {.lex_state = 0, .external_lex_state = 4},
  [3242] = {.lex_state = 0, .external_lex_state = 4},
  [3243] = {.lex_state = 13, .external_lex_state = 6},
  [3244] = {.lex_state = 0, .external_lex_state = 4},
  [3245] = {.lex_state = 71},
  [3246] = {.lex_state = 71},
  [3247] = {.lex_state = 0, .external_lex_state = 4},
  [3248] = {.lex_state = 71, .external_lex_state = 5},
  [3249] = {.lex_state = 71},
  [3250] = {.lex_state = 71},
  [3251] = {.lex_state = 0, .external_lex_state = 4},
  [3252] = {.lex_state = 71},
  [3253] = {.lex_state = 71, .external_lex_state = 4},
  [3254] = {.lex_state = 13, .external_lex_state = 6},
  [3255] = {.lex_state = 0, .external_lex_state = 4},
  [3256] = {.lex_state = 71, .external_lex_state = 5},
  [3257] = {.lex_state = 0, .external_lex_state = 4},
  [3258] = {.lex_state = 71},
  [3259] = {.lex_state = 71},
  [3260] = {.lex_state = 0},
  [3261] = {.lex_state = 0, .external_lex_state = 4},
  [3262] = {.lex_state = 71},
  [3263] = {.lex_state = 0, .external_lex_state = 4},
  [3264] = {.lex_state = 71},
  [3265] = {.lex_state = 71},
  [3266] = {.lex_state = 0, .external_lex_state = 4},
  [3267] = {.lex_state = 0, .external_lex_state = 4},
  [3268] = {.lex_state = 71},
  [3269] = {.lex_state = 71},
  [3270] = {.lex_state = 71},
  [3271] = {.lex_state = 71},
  [3272] = {.lex_state = 71},
  [3273] = {.lex_state = 12},
  [3274] = {.lex_state = 71},
  [3275] = {.lex_state = 0},
  [3276] = {.lex_state = 71},
  [3277] = {.lex_state = 71},
  [3278] = {.lex_state = 71},
  [3279] = {.lex_state = 71, .external_lex_state = 4},
  [3280] = {.lex_state = 71},
  [3281] = {.lex_state = 71},
  [3282] = {.lex_state = 0},
  [3283] = {.lex_state = 12},
  [3284] = {.lex_state = 15},
  [3285] = {.lex_state = 71},
  [3286] = {.lex_state = 71},
  [3287] = {.lex_state = 71},
  [3288] = {.lex_state = 0},
  [3289] = {.lex_state = 71},
  [3290] = {.lex_state = 71},
  [3291] = {.lex_state = 0, .external_lex_state = 4},
  [3292] = {.lex_state = 71},
  [3293] = {.lex_state = 0},
  [3294] = {.lex_state = 71},
  [3295] = {.lex_state = 71},
  [3296] = {.lex_state = 0, .external_lex_state = 4},
  [3297] = {.lex_state = 0, .external_lex_state = 4},
  [3298] = {.lex_state = 71},
  [3299] = {.lex_state = 0},
  [3300] = {.lex_state = 0},
  [3301] = {.lex_state = 71},
  [3302] = {.lex_state = 0},
  [3303] = {.lex_state = 12},
  [3304] = {.lex_state = 15},
  [3305] = {.lex_state = 71},
  [3306] = {.lex_state = 71},
  [3307] = {.lex_state = 71},
  [3308] = {.lex_state = 12},
  [3309] = {.lex_state = 15},
  [3310] = {.lex_state = 71},
  [3311] = {.lex_state = 0},
  [3312] = {.lex_state = 13, .external_lex_state = 6},
  [3313] = {.lex_state = 71, .external_lex_state = 4},
  [3314] = {.lex_state = 15},
  [3315] = {.lex_state = 15},
  [3316] = {.lex_state = 12},
  [3317] = {.lex_state = 71},
  [3318] = {.lex_state = 0},
  [3319] = {.lex_state = 13, .external_lex_state = 6},
  [3320] = {.lex_state = 12},
  [3321] = {.lex_state = 15},
  [3322] = {.lex_state = 0},
  [3323] = {.lex_state = 0},
  [3324] = {.lex_state = 0, .external_lex_state = 4},
  [3325] = {.lex_state = 71},
  [3326] = {.lex_state = 71},
  [3327] = {.lex_state = 71},
  [3328] = {.lex_state = 12},
  [3329] = {.lex_state = 71},
  [3330] = {.lex_state = 0, .external_lex_state = 4},
  [3331] = {.lex_state = 71},
  [3332] = {.lex_state = 15},
  [3333] = {.lex_state = 71, .external_lex_state = 4},
  [3334] = {.lex_state = 71},
  [3335] = {.lex_state = 0, .external_lex_state = 4},
  [3336] = {.lex_state = 71},
  [3337] = {.lex_state = 12},
  [3338] = {.lex_state = 15},
  [3339] = {.lex_state = 12},
  [3340] = {.lex_state = 0, .external_lex_state = 5},
  [3341] = {.lex_state = 15},
  [3342] = {.lex_state = 12},
  [3343] = {.lex_state = 15},
  [3344] = {.lex_state = 0, .external_lex_state = 4},
  [3345] = {.lex_state = 71},
  [3346] = {.lex_state = 15},
  [3347] = {.lex_state = 12},
  [3348] = {.lex_state = 71},
  [3349] = {.lex_state = 71},
  [3350] = {.lex_state = 71},
  [3351] = {.lex_state = 71},
  [3352] = {.lex_state = 71},
  [3353] = {.lex_state = 71, .external_lex_state = 4},
  [3354] = {.lex_state = 71},
  [3355] = {.lex_state = 71},
  [3356] = {.lex_state = 71},
  [3357] = {.lex_state = 0},
  [3358] = {.lex_state = 15},
  [3359] = {.lex_state = 0, .external_lex_state = 4},
  [3360] = {.lex_state = 71},
  [3361] = {.lex_state = 12},
  [3362] = {.lex_state = 71},
  [3363] = {.lex_state = 71},
  [3364] = {.lex_state = 71},
  [3365] = {.lex_state = 71},
  [3366] = {.lex_state = 71},
  [3367] = {.lex_state = 71},
  [3368] = {.lex_state = 71},
  [3369] = {.lex_state = 12},
  [3370] = {.lex_state = 15},
  [3371] = {.lex_state = 71},
  [3372] = {.lex_state = 71},
  [3373] = {.lex_state = 71},
  [3374] = {.lex_state = 71},
  [3375] = {.lex_state = 71},
  [3376] = {.lex_state = 15},
  [3377] = {.lex_state = 0},
  [3378] = {.lex_state = 71},
  [3379] = {.lex_state = 71},
  [3380] = {.lex_state = 0},
  [3381] = {.lex_state = 71},
  [3382] = {.lex_state = 71},
  [3383] = {.lex_state = 0, .external_lex_state = 4},
  [3384] = {.lex_state = 71},
  [3385] = {.lex_state = 71},
  [3386] = {.lex_state = 71},
  [3387] = {.lex_state = 12},
  [3388] = {.lex_state = 71},
  [3389] = {.lex_state = 71},
  [3390] = {.lex_state = 71},
  [3391] = {.lex_state = 0},
  [3392] = {.lex_state = 12},
  [3393] = {.lex_state = 15},
  [3394] = {.lex_state = 71},
  [3395] = {.lex_state = 0},
  [3396] = {.lex_state = 0},
  [3397] = {.lex_state = 0, .external_lex_state = 4},
  [3398] = {.lex_state = 0},
  [3399] = {.lex_state = 0},
  [3400] = {.lex_state = 0},
  [3401] = {.lex_state = 0},
  [3402] = {.lex_state = 0},
  [3403] = {.lex_state = 71},
  [3404] = {.lex_state = 71, .external_lex_state = 4},
  [3405] = {.lex_state = 0},
  [3406] = {.lex_state = 0, .external_lex_state = 4},
  [3407] = {.lex_state = 0},
  [3408] = {.lex_state = 0},
  [3409] = {.lex_state = 0},
  [3410] = {.lex_state = 0, .external_lex_state = 4},
  [3411] = {.lex_state = 71},
  [3412] = {.lex_state = 0},
  [3413] = {.lex_state = 0},
  [3414] = {.lex_state = 71},
  [3415] = {.lex_state = 0, .external_lex_state = 4},
  [3416] = {.lex_state = 0, .external_lex_state = 4},
  [3417] = {.lex_state = 0},
  [3418] = {.lex_state = 71},
  [3419] = {.lex_state = 0},
  [3420] = {.lex_state = 71, .external_lex_state = 4},
  [3421] = {.lex_state = 71},
  [3422] = {.lex_state = 71},
  [3423] = {.lex_state = 0, .external_lex_state = 4},
  [3424] = {.lex_state = 0},
  [3425] = {.lex_state = 0},
  [3426] = {.lex_state = 0, .external_lex_state = 4},
  [3427] = {.lex_state = 0, .external_lex_state = 4},
  [3428] = {.lex_state = 71},
  [3429] = {.lex_state = 0, .external_lex_state = 4},
  [3430] = {.lex_state = 0},
  [3431] = {.lex_state = 0},
  [3432] = {.lex_state = 0, .external_lex_state = 4},
  [3433] = {.lex_state = 0, .external_lex_state = 4},
  [3434] = {.lex_state = 0, .external_lex_state = 4},
  [3435] = {.lex_state = 71},
  [3436] = {.lex_state = 71, .external_lex_state = 4},
  [3437] = {.lex_state = 0, .external_lex_state = 4},
  [3438] = {.lex_state = 0, .external_lex_state = 4},
  [3439] = {.lex_state = 71},
  [3440] = {.lex_state = 0},
  [3441] = {.lex_state = 0, .external_lex_state = 4},
  [3442] = {.lex_state = 0, .external_lex_state = 4},
  [3443] = {.lex_state = 71},
  [3444] = {.lex_state = 71},
  [3445] = {.lex_state = 71},
  [3446] = {.lex_state = 2},
  [3447] = {.lex_state = 71},
  [3448] = {.lex_state = 0},
  [3449] = {.lex_state = 0},
  [3450] = {.lex_state = 0},
  [3451] = {.lex_state = 0},
  [3452] = {.lex_state = 0},
  [3453] = {.lex_state = 0},
  [3454] = {.lex_state = 0},
  [3455] = {.lex_state = 0},
  [3456] = {.lex_state = 0},
  [3457] = {.lex_state = 0},
  [3458] = {.lex_state = 71},
  [3459] = {.lex_state = 71},
  [3460] = {.lex_state = 71},
  [3461] = {.lex_state = 0, .external_lex_state = 4},
  [3462] = {.lex_state = 71},
  [3463] = {.lex_state = 0},
  [3464] = {.lex_state = 71},
  [3465] = {.lex_state = 71},
  [3466] = {.lex_state = 0},
  [3467] = {.lex_state = 71, .external_lex_state = 4},
  [3468] = {.lex_state = 71, .external_lex_state = 4},
  [3469] = {.lex_state = 0},
  [3470] = {.lex_state = 71},
  [3471] = {.lex_state = 0},
  [3472] = {.lex_state = 0},
  [3473] = {.lex_state = 0},
  [3474] = {.lex_state = 0},
  [3475] = {.lex_state = 0, .external_lex_state = 4},
  [3476] = {.lex_state = 0, .external_lex_state = 4},
  [3477] = {.lex_state = 0},
  [3478] = {.lex_state = 71},
  [3479] = {.lex_state = 0, .external_lex_state = 4},
  [3480] = {.lex_state = 71},
  [3481] = {.lex_state = 0},
  [3482] = {.lex_state = 0},
  [3483] = {.lex_state = 0, .external_lex_state = 4},
  [3484] = {.lex_state = 0},
  [3485] = {.lex_state = 71},
  [3486] = {.lex_state = 71},
  [3487] = {.lex_state = 71},
  [3488] = {.lex_state = 0},
  [3489] = {.lex_state = 0, .external_lex_state = 4},
  [3490] = {.lex_state = 0},
  [3491] = {.lex_state = 71},
  [3492] = {.lex_state = 0},
  [3493] = {.lex_state = 0},
  [3494] = {.lex_state = 0},
  [3495] = {.lex_state = 0},
  [3496] = {.lex_state = 0},
  [3497] = {.lex_state = 71},
  [3498] = {.lex_state = 71},
  [3499] = {.lex_state = 0},
  [3500] = {.lex_state = 0},
  [3501] = {.lex_state = 0},
  [3502] = {.lex_state = 0},
  [3503] = {.lex_state = 0},
  [3504] = {.lex_state = 0},
  [3505] = {.lex_state = 0},
  [3506] = {.lex_state = 71},
  [3507] = {.lex_state = 71},
  [3508] = {.lex_state = 0, .external_lex_state = 4},
  [3509] = {.lex_state = 0},
  [3510] = {.lex_state = 0},
  [3511] = {.lex_state = 71},
  [3512] = {.lex_state = 71},
  [3513] = {.lex_state = 0},
  [3514] = {.lex_state = 0},
  [3515] = {.lex_state = 0},
  [3516] = {.lex_state = 0},
  [3517] = {.lex_state = 71},
  [3518] = {.lex_state = 0, .external_lex_state = 4},
  [3519] = {.lex_state = 0},
  [3520] = {.lex_state = 0},
  [3521] = {.lex_state = 0, .external_lex_state = 4},
  [3522] = {.lex_state = 71},
  [3523] = {.lex_state = 0, .external_lex_state = 4},
  [3524] = {.lex_state = 0, .external_lex_state = 4},
  [3525] = {.lex_state = 0},
  [3526] = {.lex_state = 0},
  [3527] = {.lex_state = 0},
  [3528] = {.lex_state = 71},
  [3529] = {.lex_state = 71},
  [3530] = {.lex_state = 0, .external_lex_state = 4},
  [3531] = {.lex_state = 71},
  [3532] = {.lex_state = 0, .external_lex_state = 4},
  [3533] = {.lex_state = 0, .external_lex_state = 4},
  [3534] = {.lex_state = 0, .external_lex_state = 4},
  [3535] = {.lex_state = 71},
  [3536] = {.lex_state = 71},
  [3537] = {.lex_state = 0, .external_lex_state = 4},
  [3538] = {.lex_state = 2},
  [3539] = {.lex_state = 0},
  [3540] = {.lex_state = 0},
  [3541] = {.lex_state = 0},
  [3542] = {.lex_state = 0},
  [3543] = {.lex_state = 71},
  [3544] = {.lex_state = 0},
  [3545] = {.lex_state = 71},
  [3546] = {.lex_state = 71},
  [3547] = {.lex_state = 71},
  [3548] = {.lex_state = 71},
  [3549] = {.lex_state = 71},
  [3550] = {.lex_state = 71},
  [3551] = {.lex_state = 0},
  [3552] = {.lex_state = 71},
  [3553] = {.lex_state = 71},
  [3554] = {.lex_state = 0},
  [3555] = {.lex_state = 71},
  [3556] = {.lex_state = 71},
  [3557] = {.lex_state = 71},
  [3558] = {.lex_state = 0},
  [3559] = {.lex_state = 71},
  [3560] = {.lex_state = 0, .external_lex_state = 4},
  [3561] = {.lex_state = 2},
  [3562] = {.lex_state = 0, .external_lex_state = 4},
  [3563] = {.lex_state = 0},
  [3564] = {.lex_state = 0, .external_lex_state = 4},
  [3565] = {.lex_state = 0},
  [3566] = {.lex_state = 0},
  [3567] = {.lex_state = 0},
  [3568] = {.lex_state = 0, .external_lex_state = 4},
  [3569] = {.lex_state = 0},
  [3570] = {.lex_state = 0, .external_lex_state = 4},
  [3571] = {.lex_state = 71},
  [3572] = {.lex_state = 71},
  [3573] = {.lex_state = 0},
  [3574] = {.lex_state = 0, .external_lex_state = 4},
  [3575] = {.lex_state = 71, .external_lex_state = 4},
  [3576] = {.lex_state = 0, .external_lex_state = 4},
  [3577] = {.lex_state = 0, .external_lex_state = 4},
  [3578] = {.lex_state = 0, .external_lex_state = 4},
  [3579] = {.lex_state = 71, .external_lex_state = 4},
  [3580] = {.lex_state = 0, .external_lex_state = 4},
  [3581] = {.lex_state = 0, .external_lex_state = 4},
  [3582] = {.lex_state = 0},
  [3583] = {.lex_state = 0},
  [3584] = {.lex_state = 0, .external_lex_state = 4},
  [3585] = {.lex_state = 0, .external_lex_state = 4},
  [3586] = {.lex_state = 0},
  [3587] = {.lex_state = 0, .external_lex_state = 4},
  [3588] = {.lex_state = 0, .external_lex_state = 4},
  [3589] = {.lex_state = 0},
  [3590] = {.lex_state = 71},
  [3591] = {.lex_state = 0},
  [3592] = {.lex_state = 71},
  [3593] = {.lex_state = 71, .external_lex_state = 4},
  [3594] = {.lex_state = 0},
  [3595] = {.lex_state = 71},
  [3596] = {.lex_state = 0},
  [3597] = {.lex_state = 0},
  [3598] = {.lex_state = 0},
  [3599] = {.lex_state = 0, .external_lex_state = 4},
  [3600] = {.lex_state = 0, .external_lex_state = 4},
  [3601] = {.lex_state = 0, .external_lex_state = 4},
  [3602] = {.lex_state = 0},
  [3603] = {.lex_state = 0},
  [3604] = {.lex_state = 0, .external_lex_state = 4},
  [3605] = {.lex_state = 0, .external_lex_state = 4},
  [3606] = {.lex_state = 0, .external_lex_state = 4},
  [3607] = {.lex_state = 0},
  [3608] = {.lex_state = 71},
  [3609] = {.lex_state = 0},
  [3610] = {.lex_state = 0},
  [3611] = {.lex_state = 71},
  [3612] = {.lex_state = 71},
  [3613] = {.lex_state = 0},
  [3614] = {.lex_state = 0},
  [3615] = {.lex_state = 0},
  [3616] = {.lex_state = 13, .external_lex_state = 6},
  [3617] = {.lex_state = 0},
  [3618] = {.lex_state = 71},
  [3619] = {.lex_state = 0},
  [3620] = {.lex_state = 0},
  [3621] = {.lex_state = 0, .external_lex_state = 4},
  [3622] = {.lex_state = 71},
  [3623] = {.lex_state = 0},
  [3624] = {.lex_state = 0},
  [3625] = {.lex_state = 0},
  [3626] = {.lex_state = 0},
  [3627] = {.lex_state = 0},
  [3628] = {.lex_state = 0},
  [3629] = {.lex_state = 71},
  [3630] = {.lex_state = 0},
  [3631] = {.lex_state = 0},
  [3632] = {.lex_state = 0, .external_lex_state = 4},
  [3633] = {.lex_state = 0},
  [3634] = {.lex_state = 71},
  [3635] = {.lex_state = 71},
  [3636] = {.lex_state = 0},
  [3637] = {.lex_state = 0, .external_lex_state = 4},
  [3638] = {.lex_state = 0},
  [3639] = {.lex_state = 0},
  [3640] = {.lex_state = 0},
  [3641] = {.lex_state = 0},
  [3642] = {.lex_state = 71},
  [3643] = {.lex_state = 0},
  [3644] = {.lex_state = 71},
  [3645] = {.lex_state = 0},
  [3646] = {.lex_state = 71},
  [3647] = {.lex_state = 0},
  [3648] = {.lex_state = 0},
  [3649] = {.lex_state = 0},
  [3650] = {.lex_state = 0},
  [3651] = {.lex_state = 0},
  [3652] = {.lex_state = 71},
  [3653] = {.lex_state = 0},
  [3654] = {.lex_state = 0},
  [3655] = {.lex_state = 0, .external_lex_state = 4},
  [3656] = {.lex_state = 0},
  [3657] = {.lex_state = 71},
  [3658] = {.lex_state = 71},
  [3659] = {.lex_state = 71},
  [3660] = {.lex_state = 71},
  [3661] = {.lex_state = 0},
  [3662] = {.lex_state = 0, .external_lex_state = 4},
  [3663] = {.lex_state = 0},
  [3664] = {.lex_state = 71},
  [3665] = {.lex_state = 0},
  [3666] = {.lex_state = 0},
  [3667] = {.lex_state = 0},
  [3668] = {.lex_state = 0},
  [3669] = {.lex_state = 0},
  [3670] = {.lex_state = 0},
  [3671] = {.lex_state = 0},
  [3672] = {.lex_state = 71},
  [3673] = {.lex_state = 0},
  [3674] = {.lex_state = 0, .external_lex_state = 4},
  [3675] = {.lex_state = 71},
  [3676] = {.lex_state = 0, .external_lex_state = 4},
  [3677] = {.lex_state = 71},
  [3678] = {.lex_state = 0},
  [3679] = {.lex_state = 71},
  [3680] = {.lex_state = 71},
  [3681] = {.lex_state = 0},
  [3682] = {.lex_state = 71},
  [3683] = {.lex_state = 71},
  [3684] = {.lex_state = 71},
  [3685] = {.lex_state = 0},
  [3686] = {.lex_state = 71},
  [3687] = {.lex_state = 71},
  [3688] = {.lex_state = 0},
  [3689] = {.lex_state = 71},
  [3690] = {.lex_state = 71},
  [3691] = {.lex_state = 0, .external_lex_state = 4},
  [3692] = {.lex_state = 0},
  [3693] = {.lex_state = 0},
  [3694] = {.lex_state = 71},
  [3695] = {.lex_state = 71},
  [3696] = {.lex_state = 0},
  [3697] = {.lex_state = 71},
  [3698] = {.lex_state = 0},
  [3699] = {.lex_state = 71},
  [3700] = {.lex_state = 71},
  [3701] = {.lex_state = 71},
  [3702] = {.lex_state = 71},
  [3703] = {.lex_state = 71},
  [3704] = {.lex_state = 71},
  [3705] = {.lex_state = 71},
  [3706] = {.lex_state = 71},
  [3707] = {.lex_state = 71},
  [3708] = {.lex_state = 71},
  [3709] = {.lex_state = 0, .external_lex_state = 4},
  [3710] = {.lex_state = 0, .external_lex_state = 4},
  [3711] = {.lex_state = 0},
  [3712] = {.lex_state = 0, .external_lex_state = 4},
  [3713] = {.lex_state = 0, .external_lex_state = 4},
  [3714] = {.lex_state = 71},
  [3715] = {.lex_state = 0},
  [3716] = {.lex_state = 71},
  [3717] = {.lex_state = 71},
  [3718] = {.lex_state = 71},
  [3719] = {.lex_state = 0},
  [3720] = {.lex_state = 71},
  [3721] = {.lex_state = 0},
  [3722] = {.lex_state = 71},
  [3723] = {.lex_state = 71},
  [3724] = {.lex_state = 0},
  [3725] = {.lex_state = 71},
  [3726] = {.lex_state = 71},
  [3727] = {.lex_state = 0, .external_lex_state = 4},
  [3728] = {.lex_state = 71},
  [3729] = {.lex_state = 71},
  [3730] = {.lex_state = 71},
  [3731] = {.lex_state = 0},
  [3732] = {.lex_state = 71},
  [3733] = {.lex_state = 0, .external_lex_state = 4},
  [3734] = {.lex_state = 0, .external_lex_state = 4},
  [3735] = {.lex_state = 0, .external_lex_state = 4},
  [3736] = {.lex_state = 71},
  [3737] = {.lex_state = 71},
  [3738] = {.lex_state = 71},
  [3739] = {.lex_state = 71},
  [3740] = {.lex_state = 71},
  [3741] = {.lex_state = 71},
  [3742] = {.lex_state = 0, .external_lex_state = 4},
  [3743] = {.lex_state = 71},
  [3744] = {.lex_state = 0},
  [3745] = {.lex_state = 0, .external_lex_state = 4},
  [3746] = {.lex_state = 71},
  [3747] = {.lex_state = 0, .external_lex_state = 4},
  [3748] = {.lex_state = 0},
  [3749] = {.lex_state = 71},
  [3750] = {.lex_state = 71},
  [3751] = {.lex_state = 71},
  [3752] = {.lex_state = 0, .external_lex_state = 4},
  [3753] = {.lex_state = 71},
  [3754] = {.lex_state = 71},
  [3755] = {.lex_state = 71},
  [3756] = {.lex_state = 0},
  [3757] = {.lex_state = 71},
  [3758] = {.lex_state = 71},
  [3759] = {.lex_state = 0, .external_lex_state = 4},
  [3760] = {.lex_state = 71},
  [3761] = {.lex_state = 71},
  [3762] = {.lex_state = 71},
  [3763] = {.lex_state = 0},
  [3764] = {.lex_state = 71},
  [3765] = {.lex_state = 71},
  [3766] = {.lex_state = 71},
  [3767] = {.lex_state = 71},
  [3768] = {.lex_state = 71},
  [3769] = {.lex_state = 71},
  [3770] = {.lex_state = 71},
  [3771] = {.lex_state = 0},
  [3772] = {.lex_state = 0, .external_lex_state = 4},
  [3773] = {.lex_state = 71},
  [3774] = {.lex_state = 71},
  [3775] = {.lex_state = 0},
  [3776] = {.lex_state = 0, .external_lex_state = 4},
  [3777] = {.lex_state = 71},
  [3778] = {.lex_state = 71},
  [3779] = {.lex_state = 0},
  [3780] = {.lex_state = 71},
  [3781] = {.lex_state = 71},
  [3782] = {.lex_state = 71},
  [3783] = {.lex_state = 71},
  [3784] = {.lex_state = 0, .external_lex_state = 4},
  [3785] = {.lex_state = 71},
  [3786] = {.lex_state = 0, .external_lex_state = 4},
  [3787] = {.lex_state = 71},
  [3788] = {.lex_state = 71},
  [3789] = {.lex_state = 0},
  [3790] = {.lex_state = 71},
  [3791] = {.lex_state = 71},
  [3792] = {.lex_state = 71},
  [3793] = {.lex_state = 71},
  [3794] = {.lex_state = 0},
  [3795] = {.lex_state = 0},
  [3796] = {.lex_state = 71},
  [3797] = {.lex_state = 71},
  [3798] = {.lex_state = 0},
  [3799] = {.lex_state = 71},
  [3800] = {.lex_state = 71},
  [3801] = {.lex_state = 71},
  [3802] = {.lex_state = 71},
  [3803] = {.lex_state = 71},
  [3804] = {.lex_state = 71},
  [3805] = {.lex_state = 0},
  [3806] = {.lex_state = 0},
  [3807] = {.lex_state = 71},
  [3808] = {.lex_state = 71},
  [3809] = {.lex_state = 71},
  [3810] = {.lex_state = 71},
  [3811] = {.lex_state = 71},
  [3812] = {.lex_state = 71},
  [3813] = {.lex_state = 0},
  [3814] = {.lex_state = 0},
  [3815] = {.lex_state = 71},
  [3816] = {.lex_state = 71},
  [3817] = {.lex_state = 71},
  [3818] = {.lex_state = 71},
  [3819] = {.lex_state = 71},
  [3820] = {.lex_state = 0},
  [3821] = {.lex_state = 0},
  [3822] = {.lex_state = 0},
  [3823] = {.lex_state = 71},
  [3824] = {.lex_state = 71},
  [3825] = {.lex_state = 71},
  [3826] = {.lex_state = 71},
  [3827] = {.lex_state = 71},
  [3828] = {.lex_state = 0},
  [3829] = {.lex_state = 0},
  [3830] = {.lex_state = 0},
  [3831] = {.lex_state = 0},
  [3832] = {.lex_state = 71},
  [3833] = {.lex_state = 71},
  [3834] = {.lex_state = 71},
  [3835] = {.lex_state = 71},
  [3836] = {.lex_state = 71},
  [3837] = {.lex_state = 71},
  [3838] = {.lex_state = 71},
  [3839] = {.lex_state = 0},
  [3840] = {.lex_state = 71},
  [3841] = {.lex_state = 71},
  [3842] = {.lex_state = 71},
  [3843] = {.lex_state = 0, .external_lex_state = 4},
  [3844] = {.lex_state = 71},
  [3845] = {.lex_state = 71},
  [3846] = {.lex_state = 0},
  [3847] = {.lex_state = 0, .external_lex_state = 4},
  [3848] = {.lex_state = 0},
  [3849] = {.lex_state = 71},
  [3850] = {.lex_state = 0},
  [3851] = {.lex_state = 71},
  [3852] = {.lex_state = 71},
  [3853] = {.lex_state = 71},
  [3854] = {.lex_state = 0, .external_lex_state = 4},
  [3855] = {.lex_state = 71},
  [3856] = {.lex_state = 0},
  [3857] = {.lex_state = 0},
  [3858] = {.lex_state = 71},
  [3859] = {.lex_state = 0},
  [3860] = {.lex_state = 0},
  [3861] = {.lex_state = 71},
  [3862] = {.lex_state = 0},
  [3863] = {.lex_state = 71},
  [3864] = {.lex_state = 0},
  [3865] = {.lex_state = 71},
  [3866] = {.lex_state = 0},
  [3867] = {.lex_state = 71},
  [3868] = {.lex_state = 71},
  [3869] = {.lex_state = 0},
  [3870] = {.lex_state = 71},
  [3871] = {.lex_state = 71},
  [3872] = {.lex_state = 0},
  [3873] = {.lex_state = 0},
  [3874] = {.lex_state = 71},
  [3875] = {.lex_state = 0},
  [3876] = {.lex_state = 0},
  [3877] = {.lex_state = 71},
  [3878] = {.lex_state = 9},
  [3879] = {.lex_state = 0},
  [3880] = {.lex_state = 71},
  [3881] = {.lex_state = 0},
  [3882] = {.lex_state = 71},
  [3883] = {.lex_state = 0},
  [3884] = {.lex_state = 0},
  [3885] = {.lex_state = 0},
  [3886] = {.lex_state = 0},
  [3887] = {.lex_state = 0},
  [3888] = {.lex_state = 0},
  [3889] = {.lex_state = 0},
  [3890] = {.lex_state = 1},
  [3891] = {.lex_state = 0},
  [3892] = {.lex_state = 0},
  [3893] = {.lex_state = 0},
  [3894] = {.lex_state = 71},
  [3895] = {.lex_state = 0},
  [3896] = {.lex_state = 0},
  [3897] = {.lex_state = 71},
  [3898] = {.lex_state = 0},
  [3899] = {.lex_state = 0},
  [3900] = {.lex_state = 0},
  [3901] = {.lex_state = 71},
  [3902] = {.lex_state = 0},
  [3903] = {.lex_state = 0},
  [3904] = {.lex_state = 0},
  [3905] = {.lex_state = 0},
  [3906] = {.lex_state = 71},
  [3907] = {.lex_state = 0},
  [3908] = {.lex_state = 0},
  [3909] = {.lex_state = 0},
  [3910] = {.lex_state = 0},
  [3911] = {.lex_state = 71},
  [3912] = {.lex_state = 0},
  [3913] = {.lex_state = 0},
  [3914] = {.lex_state = 0},
  [3915] = {.lex_state = 71},
  [3916] = {.lex_state = 0},
  [3917] = {.lex_state = 0},
  [3918] = {.lex_state = 71},
  [3919] = {.lex_state = 0},
  [3920] = {.lex_state = 0},
  [3921] = {.lex_state = 0},
  [3922] = {.lex_state = 0},
  [3923] = {.lex_state = 0},
  [3924] = {.lex_state = 0},
  [3925] = {.lex_state = 0},
  [3926] = {.lex_state = 0},
  [3927] = {.lex_state = 0},
  [3928] = {.lex_state = 0},
  [3929] = {.lex_state = 0},
  [3930] = {.lex_state = 0},
  [3931] = {.lex_state = 0},
  [3932] = {.lex_state = 0},
  [3933] = {.lex_state = 0},
  [3934] = {.lex_state = 0},
  [3935] = {.lex_state = 0},
  [3936] = {.lex_state = 0},
  [3937] = {.lex_state = 0},
  [3938] = {.lex_state = 0},
  [3939] = {.lex_state = 0},
  [3940] = {.lex_state = 0},
  [3941] = {.lex_state = 0},
  [3942] = {.lex_state = 0},
  [3943] = {.lex_state = 0},
  [3944] = {.lex_state = 1},
  [3945] = {.lex_state = 0},
  [3946] = {.lex_state = 0},
  [3947] = {.lex_state = 0},
  [3948] = {.lex_state = 0},
  [3949] = {.lex_state = 0},
  [3950] = {.lex_state = 0},
  [3951] = {.lex_state = 0},
  [3952] = {.lex_state = 0},
  [3953] = {.lex_state = 0},
  [3954] = {.lex_state = 0},
  [3955] = {.lex_state = 0},
  [3956] = {.lex_state = 0},
  [3957] = {.lex_state = 0},
  [3958] = {.lex_state = 0},
  [3959] = {.lex_state = 71},
  [3960] = {.lex_state = 0},
  [3961] = {.lex_state = 0},
  [3962] = {.lex_state = 0},
  [3963] = {.lex_state = 0},
  [3964] = {.lex_state = 0},
  [3965] = {.lex_state = 0},
  [3966] = {.lex_state = 0},
  [3967] = {.lex_state = 0},
  [3968] = {.lex_state = 0},
  [3969] = {.lex_state = 0},
  [3970] = {.lex_state = 71},
  [3971] = {.lex_state = 0},
  [3972] = {.lex_state = 0},
  [3973] = {.lex_state = 0},
  [3974] = {.lex_state = 71},
  [3975] = {.lex_state = 0},
  [3976] = {.lex_state = 0},
  [3977] = {.lex_state = 71},
  [3978] = {.lex_state = 71},
  [3979] = {.lex_state = 71},
  [3980] = {.lex_state = 0},
  [3981] = {.lex_state = 0},
  [3982] = {.lex_state = 0},
  [3983] = {.lex_state = 71},
  [3984] = {.lex_state = 0},
  [3985] = {.lex_state = 0},
  [3986] = {.lex_state = 0},
  [3987] = {.lex_state = 0},
  [3988] = {.lex_state = 0},
  [3989] = {.lex_state = 0},
  [3990] = {.lex_state = 71},
  [3991] = {.lex_state = 0},
  [3992] = {.lex_state = 0},
  [3993] = {.lex_state = 0},
  [3994] = {.lex_state = 71},
  [3995] = {.lex_state = 71},
  [3996] = {.lex_state = 0},
  [3997] = {.lex_state = 0},
  [3998] = {.lex_state = 0},
  [3999] = {.lex_state = 0},
  [4000] = {.lex_state = 9},
  [4001] = {.lex_state = 71},
  [4002] = {.lex_state = 71},
  [4003] = {.lex_state = 71},
  [4004] = {.lex_state = 1},
  [4005] = {.lex_state = 71},
  [4006] = {.lex_state = 0},
  [4007] = {.lex_state = 0},
  [4008] = {.lex_state = 0},
  [4009] = {.lex_state = 0},
  [4010] = {.lex_state = 71},
  [4011] = {.lex_state = 0},
  [4012] = {.lex_state = 0},
  [4013] = {.lex_state = 0},
  [4014] = {.lex_state = 0},
  [4015] = {.lex_state = 0},
  [4016] = {.lex_state = 0},
  [4017] = {.lex_state = 0},
  [4018] = {.lex_state = 0},
  [4019] = {.lex_state = 71},
  [4020] = {.lex_state = 71},
  [4021] = {.lex_state = 0},
  [4022] = {.lex_state = 0},
  [4023] = {.lex_state = 71},
  [4024] = {.lex_state = 0},
  [4025] = {.lex_state = 71},
  [4026] = {.lex_state = 0},
  [4027] = {.lex_state = 0},
  [4028] = {.lex_state = 71},
  [4029] = {.lex_state = 0},
  [4030] = {.lex_state = 0},
  [4031] = {.lex_state = 71},
  [4032] = {.lex_state = 0},
  [4033] = {.lex_state = 71},
  [4034] = {.lex_state = 71},
  [4035] = {.lex_state = 0},
  [4036] = {.lex_state = 0},
  [4037] = {.lex_state = 71},
  [4038] = {.lex_state = 0},
  [4039] = {.lex_state = 0},
  [4040] = {.lex_state = 0},
  [4041] = {.lex_state = 0},
  [4042] = {.lex_state = 0},
  [4043] = {.lex_state = 0},
  [4044] = {.lex_state = 0},
  [4045] = {.lex_state = 0},
  [4046] = {.lex_state = 0},
  [4047] = {.lex_state = 0},
  [4048] = {.lex_state = 71},
  [4049] = {.lex_state = 0},
  [4050] = {.lex_state = 71},
  [4051] = {.lex_state = 0},
  [4052] = {.lex_state = 71},
  [4053] = {.lex_state = 0},
  [4054] = {.lex_state = 0},
  [4055] = {.lex_state = 0},
  [4056] = {.lex_state = 0},
  [4057] = {.lex_state = 0},
  [4058] = {.lex_state = 0},
  [4059] = {.lex_state = 0},
  [4060] = {.lex_state = 0},
  [4061] = {.lex_state = 71},
  [4062] = {.lex_state = 71},
  [4063] = {.lex_state = 71},
  [4064] = {.lex_state = 71},
  [4065] = {.lex_state = 9},
  [4066] = {.lex_state = 0},
  [4067] = {.lex_state = 0},
  [4068] = {.lex_state = 0},
  [4069] = {.lex_state = 0},
  [4070] = {.lex_state = 0},
  [4071] = {.lex_state = 71},
  [4072] = {.lex_state = 0},
  [4073] = {.lex_state = 0},
  [4074] = {.lex_state = 0},
  [4075] = {.lex_state = 71},
  [4076] = {.lex_state = 71},
  [4077] = {.lex_state = 9},
  [4078] = {.lex_state = 0},
  [4079] = {.lex_state = 0},
  [4080] = {.lex_state = 0},
  [4081] = {.lex_state = 0},
  [4082] = {.lex_state = 0},
  [4083] = {.lex_state = 71},
  [4084] = {.lex_state = 0},
  [4085] = {.lex_state = 0},
  [4086] = {.lex_state = 0},
  [4087] = {.lex_state = 9},
  [4088] = {.lex_state = 71},
  [4089] = {.lex_state = 0},
  [4090] = {.lex_state = 0},
  [4091] = {.lex_state = 0},
  [4092] = {.lex_state = 0},
  [4093] = {.lex_state = 71},
  [4094] = {.lex_state = 0},
  [4095] = {.lex_state = 0},
  [4096] = {.lex_state = 71},
  [4097] = {.lex_state = 0},
  [4098] = {.lex_state = 0},
  [4099] = {.lex_state = 0},
  [4100] = {.lex_state = 0},
  [4101] = {.lex_state = 0},
  [4102] = {.lex_state = 0},
  [4103] = {.lex_state = 71},
  [4104] = {.lex_state = 0},
  [4105] = {.lex_state = 71},
  [4106] = {.lex_state = 0},
  [4107] = {.lex_state = 0},
  [4108] = {.lex_state = 0},
  [4109] = {.lex_state = 71},
  [4110] = {.lex_state = 0},
  [4111] = {.lex_state = 71},
  [4112] = {.lex_state = 71},
  [4113] = {.lex_state = 0},
  [4114] = {.lex_state = 0},
  [4115] = {.lex_state = 0},
  [4116] = {.lex_state = 0},
  [4117] = {.lex_state = 0},
  [4118] = {.lex_state = 0},
  [4119] = {.lex_state = 71},
  [4120] = {.lex_state = 0},
  [4121] = {.lex_state = 0},
  [4122] = {.lex_state = 0},
  [4123] = {.lex_state = 0},
  [4124] = {.lex_state = 71},
  [4125] = {.lex_state = 0},
  [4126] = {.lex_state = 0},
  [4127] = {.lex_state = 0},
  [4128] = {.lex_state = 0},
  [4129] = {.lex_state = 0},
  [4130] = {.lex_state = 0},
  [4131] = {.lex_state = 0},
  [4132] = {.lex_state = 0},
  [4133] = {.lex_state = 0},
  [4134] = {.lex_state = 0},
  [4135] = {.lex_state = 0},
  [4136] = {.lex_state = 0},
  [4137] = {.lex_state = 0},
  [4138] = {.lex_state = 71},
  [4139] = {.lex_state = 0},
  [4140] = {.lex_state = 0},
  [4141] = {.lex_state = 0},
  [4142] = {.lex_state = 0},
  [4143] = {.lex_state = 0},
  [4144] = {.lex_state = 0},
  [4145] = {.lex_state = 71},
  [4146] = {.lex_state = 0},
  [4147] = {.lex_state = 71},
  [4148] = {.lex_state = 71},
  [4149] = {.lex_state = 0},
  [4150] = {.lex_state = 0},
  [4151] = {.lex_state = 0},
  [4152] = {.lex_state = 0},
  [4153] = {.lex_state = 0},
  [4154] = {.lex_state = 71},
  [4155] = {.lex_state = 0},
  [4156] = {.lex_state = 0},
  [4157] = {.lex_state = 0},
  [4158] = {.lex_state = 0},
  [4159] = {.lex_state = 0},
  [4160] = {.lex_state = 0},
  [4161] = {.lex_state = 0},
  [4162] = {.lex_state = 71},
  [4163] = {.lex_state = 0},
  [4164] = {.lex_state = 0},
  [4165] = {.lex_state = 0},
  [4166] = {.lex_state = 0},
  [4167] = {.lex_state = 0},
  [4168] = {.lex_state = 0},
  [4169] = {.lex_state = 71},
  [4170] = {.lex_state = 0},
  [4171] = {.lex_state = 0},
  [4172] = {.lex_state = 0},
  [4173] = {.lex_state = 0},
  [4174] = {.lex_state = 71},
  [4175] = {.lex_state = 1},
  [4176] = {.lex_state = 0},
  [4177] = {.lex_state = 0},
  [4178] = {.lex_state = 71},
  [4179] = {.lex_state = 71},
  [4180] = {.lex_state = 0},
  [4181] = {.lex_state = 71},
  [4182] = {.lex_state = 71},
  [4183] = {.lex_state = 0},
  [4184] = {.lex_state = 71},
  [4185] = {.lex_state = 71},
  [4186] = {.lex_state = 71},
  [4187] = {.lex_state = 71},
  [4188] = {.lex_state = 71},
  [4189] = {.lex_state = 0},
  [4190] = {.lex_state = 0},
  [4191] = {.lex_state = 71},
  [4192] = {.lex_state = 0},
  [4193] = {.lex_state = 71},
  [4194] = {.lex_state = 71},
  [4195] = {.lex_state = 71},
  [4196] = {.lex_state = 1},
  [4197] = {.lex_state = 71},
  [4198] = {.lex_state = 0},
  [4199] = {.lex_state = 71},
  [4200] = {.lex_state = 71},
  [4201] = {.lex_state = 71},
  [4202] = {.lex_state = 71},
  [4203] = {.lex_state = 71},
  [4204] = {.lex_state = 0},
  [4205] = {.lex_state = 71},
  [4206] = {.lex_state = 71},
  [4207] = {.lex_state = 0},
};

enum {
  ts_external_token__automatic_semicolon = 0,
  ts_external_token__template_chars = 1,
  ts_external_token__ternary_qmark = 2,
  ts_external_token_PIPE_PIPE = 3,
  ts_external_token__function_signature_automatic_semicolon = 4,
};

static const TSSymbol ts_external_scanner_symbol_map[EXTERNAL_TOKEN_COUNT] = {
  [ts_external_token__automatic_semicolon] = sym__automatic_semicolon,
  [ts_external_token__template_chars] = sym__template_chars,
  [ts_external_token__ternary_qmark] = sym__ternary_qmark,
  [ts_external_token_PIPE_PIPE] = anon_sym_PIPE_PIPE,
  [ts_external_token__function_signature_automatic_semicolon] = sym__function_signature_automatic_semicolon,
};

static const bool ts_external_scanner_states[7][EXTERNAL_TOKEN_COUNT] = {
  [1] = {
    [ts_external_token__automatic_semicolon] = true,
    [ts_external_token__template_chars] = true,
    [ts_external_token__ternary_qmark] = true,
    [ts_external_token_PIPE_PIPE] = true,
    [ts_external_token__function_signature_automatic_semicolon] = true,
  },
  [2] = {
    [ts_external_token__ternary_qmark] = true,
    [ts_external_token_PIPE_PIPE] = true,
  },
  [3] = {
    [ts_external_token__automatic_semicolon] = true,
    [ts_external_token__ternary_qmark] = true,
    [ts_external_token_PIPE_PIPE] = true,
  },
  [4] = {
    [ts_external_token__automatic_semicolon] = true,
  },
  [5] = {
    [ts_external_token__automatic_semicolon] = true,
    [ts_external_token__function_signature_automatic_semicolon] = true,
  },
  [6] = {
    [ts_external_token__template_chars] = true,
  },
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym_identifier] = ACTIONS(1),
    [sym_hash_bang_line] = ACTIONS(1),
    [anon_sym_export] = ACTIONS(1),
    [anon_sym_STAR] = ACTIONS(1),
    [anon_sym_default] = ACTIONS(1),
    [anon_sym_type] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_as] = ACTIONS(1),
    [anon_sym_namespace] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_typeof] = ACTIONS(1),
    [anon_sym_import] = ACTIONS(1),
    [anon_sym_from] = ACTIONS(1),
    [anon_sym_var] = ACTIONS(1),
    [anon_sym_let] = ACTIONS(1),
    [anon_sym_const] = ACTIONS(1),
    [anon_sym_BANG] = ACTIONS(1),
    [anon_sym_else] = ACTIONS(1),
    [anon_sym_if] = ACTIONS(1),
    [anon_sym_switch] = ACTIONS(1),
    [anon_sym_for] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_await] = ACTIONS(1),
    [anon_sym_in] = ACTIONS(1),
    [anon_sym_of] = ACTIONS(1),
    [anon_sym_while] = ACTIONS(1),
    [anon_sym_do] = ACTIONS(1),
    [anon_sym_try] = ACTIONS(1),
    [anon_sym_with] = ACTIONS(1),
    [anon_sym_break] = ACTIONS(1),
    [anon_sym_continue] = ACTIONS(1),
    [anon_sym_debugger] = ACTIONS(1),
    [anon_sym_return] = ACTIONS(1),
    [anon_sym_throw] = ACTIONS(1),
    [anon_sym_SEMI] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_case] = ACTIONS(1),
    [anon_sym_catch] = ACTIONS(1),
    [anon_sym_finally] = ACTIONS(1),
    [anon_sym_yield] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [anon_sym_SLASH] = ACTIONS(1),
    [anon_sym_DOT] = ACTIONS(1),
    [anon_sym_class] = ACTIONS(1),
    [anon_sym_async] = ACTIONS(1),
    [anon_sym_function] = ACTIONS(1),
    [anon_sym_EQ_GT] = ACTIONS(1),
    [anon_sym_QMARK_DOT] = ACTIONS(1),
    [anon_sym_new] = ACTIONS(1),
    [anon_sym_PLUS_EQ] = ACTIONS(1),
    [anon_sym_DASH_EQ] = ACTIONS(1),
    [anon_sym_STAR_EQ] = ACTIONS(1),
    [anon_sym_PERCENT_EQ] = ACTIONS(1),
    [anon_sym_CARET_EQ] = ACTIONS(1),
    [anon_sym_AMP_EQ] = ACTIONS(1),
    [anon_sym_PIPE_EQ] = ACTIONS(1),
    [anon_sym_GT_GT_EQ] = ACTIONS(1),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(1),
    [anon_sym_LT_LT_EQ] = ACTIONS(1),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(1),
    [anon_sym_AMP_AMP_EQ] = ACTIONS(1),
    [anon_sym_PIPE_PIPE_EQ] = ACTIONS(1),
    [anon_sym_QMARK_QMARK_EQ] = ACTIONS(1),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(1),
    [anon_sym_AMP_AMP] = ACTIONS(1),
    [anon_sym_PIPE_PIPE] = ACTIONS(1),
    [anon_sym_GT_GT] = ACTIONS(1),
    [anon_sym_GT_GT_GT] = ACTIONS(1),
    [anon_sym_LT_LT] = ACTIONS(1),
    [anon_sym_AMP] = ACTIONS(1),
    [anon_sym_CARET] = ACTIONS(1),
    [anon_sym_PIPE] = ACTIONS(1),
    [anon_sym_PLUS] = ACTIONS(1),
    [anon_sym_DASH] = ACTIONS(1),
    [anon_sym_PERCENT] = ACTIONS(1),
    [anon_sym_STAR_STAR] = ACTIONS(1),
    [anon_sym_LT_EQ] = ACTIONS(1),
    [anon_sym_EQ_EQ] = ACTIONS(1),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(1),
    [anon_sym_BANG_EQ] = ACTIONS(1),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(1),
    [anon_sym_GT_EQ] = ACTIONS(1),
    [anon_sym_QMARK_QMARK] = ACTIONS(1),
    [anon_sym_instanceof] = ACTIONS(1),
    [anon_sym_TILDE] = ACTIONS(1),
    [anon_sym_void] = ACTIONS(1),
    [anon_sym_delete] = ACTIONS(1),
    [anon_sym_PLUS_PLUS] = ACTIONS(1),
    [anon_sym_DASH_DASH] = ACTIONS(1),
    [anon_sym_DQUOTE] = ACTIONS(1),
    [anon_sym_SQUOTE] = ACTIONS(1),
    [sym_escape_sequence] = ACTIONS(1),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(1),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1),
    [anon_sym_SLASH2] = ACTIONS(1),
    [sym_number] = ACTIONS(1),
    [sym_private_property_identifier] = ACTIONS(1),
    [anon_sym_target] = ACTIONS(1),
    [sym_this] = ACTIONS(1),
    [sym_super] = ACTIONS(1),
    [sym_true] = ACTIONS(1),
    [sym_false] = ACTIONS(1),
    [sym_null] = ACTIONS(1),
    [sym_undefined] = ACTIONS(1),
    [anon_sym_AT] = ACTIONS(1),
    [anon_sym_static] = ACTIONS(1),
    [anon_sym_readonly] = ACTIONS(1),
    [anon_sym_get] = ACTIONS(1),
    [anon_sym_set] = ACTIONS(1),
    [anon_sym_QMARK] = ACTIONS(1),
    [anon_sym_declare] = ACTIONS(1),
    [anon_sym_public] = ACTIONS(1),
    [anon_sym_private] = ACTIONS(1),
    [anon_sym_protected] = ACTIONS(1),
    [anon_sym_override] = ACTIONS(1),
    [anon_sym_module] = ACTIONS(1),
    [anon_sym_any] = ACTIONS(1),
    [anon_sym_number] = ACTIONS(1),
    [anon_sym_boolean] = ACTIONS(1),
    [anon_sym_string] = ACTIONS(1),
    [anon_sym_symbol] = ACTIONS(1),
    [anon_sym_abstract] = ACTIONS(1),
    [anon_sym_require] = ACTIONS(1),
    [anon_sym_extends] = ACTIONS(1),
    [anon_sym_implements] = ACTIONS(1),
    [anon_sym_global] = ACTIONS(1),
    [anon_sym_interface] = ACTIONS(1),
    [anon_sym_enum] = ACTIONS(1),
    [anon_sym_DASH_QMARK_COLON] = ACTIONS(1),
    [anon_sym_asserts] = ACTIONS(1),
    [anon_sym_infer] = ACTIONS(1),
    [anon_sym_is] = ACTIONS(1),
    [anon_sym_keyof] = ACTIONS(1),
    [anon_sym_unknown] = ACTIONS(1),
    [anon_sym_never] = ACTIONS(1),
    [anon_sym_object] = ACTIONS(1),
    [anon_sym_LBRACE_PIPE] = ACTIONS(1),
    [anon_sym_PIPE_RBRACE] = ACTIONS(1),
    [sym__automatic_semicolon] = ACTIONS(1),
    [sym__template_chars] = ACTIONS(1),
    [sym__ternary_qmark] = ACTIONS(1),
    [sym__function_signature_automatic_semicolon] = ACTIONS(1),
  },
  [1] = {
    [sym_program] = STATE(4177),
    [sym_export_statement] = STATE(17),
    [sym_declaration] = STATE(17),
    [sym_import] = STATE(1844),
    [sym_import_statement] = STATE(17),
    [sym_expression_statement] = STATE(17),
    [sym_variable_declaration] = STATE(741),
    [sym_lexical_declaration] = STATE(741),
    [sym_statement_block] = STATE(17),
    [sym_if_statement] = STATE(17),
    [sym_switch_statement] = STATE(17),
    [sym_for_statement] = STATE(17),
    [sym_for_in_statement] = STATE(17),
    [sym_while_statement] = STATE(17),
    [sym_do_statement] = STATE(17),
    [sym_try_statement] = STATE(17),
    [sym_with_statement] = STATE(17),
    [sym_break_statement] = STATE(17),
    [sym_continue_statement] = STATE(17),
    [sym_debugger_statement] = STATE(17),
    [sym_return_statement] = STATE(17),
    [sym_throw_statement] = STATE(17),
    [sym_empty_statement] = STATE(17),
    [sym_labeled_statement] = STATE(17),
    [sym_parenthesized_expression] = STATE(1116),
    [sym_expression] = STATE(1697),
    [sym_primary_expression] = STATE(1799),
    [sym_yield_expression] = STATE(1798),
    [sym_object] = STATE(1844),
    [sym_object_pattern] = STATE(4170),
    [sym_array] = STATE(1844),
    [sym_array_pattern] = STATE(4170),
    [sym_class] = STATE(1844),
    [sym_class_declaration] = STATE(741),
    [sym_function] = STATE(1844),
    [sym_function_declaration] = STATE(741),
    [sym_generator_function] = STATE(1844),
    [sym_generator_function_declaration] = STATE(741),
    [sym_arrow_function] = STATE(1844),
    [sym__call_signature] = STATE(4172),
    [sym_call_expression] = STATE(1844),
    [sym_new_expression] = STATE(1798),
    [sym_await_expression] = STATE(1798),
    [sym_member_expression] = STATE(1116),
    [sym_subscript_expression] = STATE(1116),
    [sym_assignment_expression] = STATE(1798),
    [sym__augmented_assignment_lhs] = STATE(2357),
    [sym_augmented_assignment_expression] = STATE(1798),
    [sym__destructuring_pattern] = STATE(4170),
    [sym_ternary_expression] = STATE(1798),
    [sym_binary_expression] = STATE(1798),
    [sym_unary_expression] = STATE(1798),
    [sym_update_expression] = STATE(1798),
    [sym_sequence_expression] = STATE(3662),
    [sym_string] = STATE(1844),
    [sym_template_string] = STATE(1844),
    [sym_regex] = STATE(1844),
    [sym_meta_property] = STATE(1844),
    [sym_decorator] = STATE(1149),
    [sym_formal_parameters] = STATE(2903),
    [sym_non_null_expression] = STATE(1116),
    [sym_function_signature] = STATE(741),
    [sym_type_assertion] = STATE(1798),
    [sym_as_expression] = STATE(1798),
    [sym_ambient_declaration] = STATE(741),
    [sym_abstract_class_declaration] = STATE(741),
    [sym_module] = STATE(741),
    [sym_internal_module] = STATE(140),
    [sym_import_alias] = STATE(741),
    [sym_interface_declaration] = STATE(741),
    [sym_enum_declaration] = STATE(741),
    [sym_type_alias_declaration] = STATE(741),
    [sym_type_arguments] = STATE(482),
    [sym_type_parameters] = STATE(3670),
    [aux_sym_program_repeat1] = STATE(17),
    [aux_sym_export_statement_repeat1] = STATE(2947),
    [ts_builtin_sym_end] = ACTIONS(5),
    [sym_identifier] = ACTIONS(7),
    [sym_hash_bang_line] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_type] = ACTIONS(13),
    [anon_sym_namespace] = ACTIONS(15),
    [anon_sym_LBRACE] = ACTIONS(17),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_for] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_await] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(41),
    [anon_sym_do] = ACTIONS(43),
    [anon_sym_try] = ACTIONS(45),
    [anon_sym_with] = ACTIONS(47),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_debugger] = ACTIONS(53),
    [anon_sym_return] = ACTIONS(55),
    [anon_sym_throw] = ACTIONS(57),
    [anon_sym_SEMI] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(69),
    [anon_sym_async] = ACTIONS(71),
    [anon_sym_function] = ACTIONS(73),
    [anon_sym_new] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_void] = ACTIONS(19),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(77),
    [anon_sym_DASH_DASH] = ACTIONS(77),
    [anon_sym_DQUOTE] = ACTIONS(79),
    [anon_sym_SQUOTE] = ACTIONS(81),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(83),
    [sym_number] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(93),
    [anon_sym_readonly] = ACTIONS(93),
    [anon_sym_get] = ACTIONS(93),
    [anon_sym_set] = ACTIONS(93),
    [anon_sym_declare] = ACTIONS(95),
    [anon_sym_public] = ACTIONS(93),
    [anon_sym_private] = ACTIONS(93),
    [anon_sym_protected] = ACTIONS(93),
    [anon_sym_override] = ACTIONS(93),
    [anon_sym_module] = ACTIONS(97),
    [anon_sym_any] = ACTIONS(93),
    [anon_sym_number] = ACTIONS(93),
    [anon_sym_boolean] = ACTIONS(93),
    [anon_sym_string] = ACTIONS(93),
    [anon_sym_symbol] = ACTIONS(93),
    [anon_sym_abstract] = ACTIONS(99),
    [anon_sym_interface] = ACTIONS(101),
    [anon_sym_enum] = ACTIONS(103),
  },
  [2] = {
    [sym_import] = STATE(1405),
    [sym_parenthesized_expression] = STATE(1023),
    [sym_expression] = STATE(2015),
    [sym_primary_expression] = STATE(1404),
    [sym_yield_expression] = STATE(1403),
    [sym_object] = STATE(1405),
    [sym_object_pattern] = STATE(2733),
    [sym_array] = STATE(1405),
    [sym_array_pattern] = STATE(2733),
    [sym_nested_identifier] = STATE(4074),
    [sym_class] = STATE(1405),
    [sym_function] = STATE(1405),
    [sym_generator_function] = STATE(1405),
    [sym_arrow_function] = STATE(1405),
    [sym__call_signature] = STATE(4016),
    [sym_call_expression] = STATE(1405),
    [sym_new_expression] = STATE(1403),
    [sym_await_expression] = STATE(1403),
    [sym_member_expression] = STATE(1058),
    [sym_subscript_expression] = STATE(1058),
    [sym_assignment_expression] = STATE(1403),
    [sym__augmented_assignment_lhs] = STATE(2340),
    [sym_augmented_assignment_expression] = STATE(1403),
    [sym__destructuring_pattern] = STATE(2733),
    [sym_ternary_expression] = STATE(1403),
    [sym_binary_expression] = STATE(1403),
    [sym_unary_expression] = STATE(1403),
    [sym_update_expression] = STATE(1403),
    [sym_string] = STATE(1853),
    [sym_template_string] = STATE(1405),
    [sym_regex] = STATE(1405),
    [sym_meta_property] = STATE(1405),
    [sym_decorator] = STATE(1149),
    [sym_formal_parameters] = STATE(3260),
    [sym_pattern] = STATE(3191),
    [sym_rest_pattern] = STATE(2817),
    [sym_non_null_expression] = STATE(1058),
    [sym_type_assertion] = STATE(1403),
    [sym_as_expression] = STATE(1403),
    [sym_internal_module] = STATE(1403),
    [sym_nested_type_identifier] = STATE(2336),
    [sym__type] = STATE(2398),
    [sym_constructor_type] = STATE(2398),
    [sym__primary_type] = STATE(2373),
    [sym_template_literal_type] = STATE(2359),
    [sym_infer_type] = STATE(2398),
    [sym_conditional_type] = STATE(2359),
    [sym_generic_type] = STATE(2359),
    [sym_type_query] = STATE(2359),
    [sym_index_type_query] = STATE(2359),
    [sym_lookup_type] = STATE(2359),
    [sym_literal_type] = STATE(2359),
    [sym__number] = STATE(2355),
    [sym_existential_type] = STATE(2359),
    [sym_flow_maybe_type] = STATE(2359),
    [sym_parenthesized_type] = STATE(2359),
    [sym_predefined_type] = STATE(2359),
    [sym_type_arguments] = STATE(519),
    [sym_object_type] = STATE(2359),
    [sym_type_parameters] = STATE(3839),
    [sym_array_type] = STATE(2359),
    [sym_tuple_type] = STATE(2359),
    [sym_readonly_type] = STATE(2398),
    [sym_union_type] = STATE(2359),
    [sym_intersection_type] = STATE(2359),
    [sym_function_type] = STATE(2398),
    [aux_sym_export_statement_repeat1] = STATE(3368),
    [sym_identifier] = ACTIONS(105),
    [anon_sym_export] = ACTIONS(107),
    [anon_sym_STAR] = ACTIONS(109),
    [anon_sym_type] = ACTIONS(107),
    [anon_sym_EQ] = ACTIONS(111),
    [anon_sym_as] = ACTIONS(114),
    [anon_sym_namespace] = ACTIONS(116),
    [anon_sym_LBRACE] = ACTIONS(118),
    [anon_sym_COMMA] = ACTIONS(120),
    [anon_sym_typeof] = ACTIONS(123),
    [anon_sym_import] = ACTIONS(125),
    [anon_sym_BANG] = ACTIONS(127),
    [anon_sym_LPAREN] = ACTIONS(130),
    [anon_sym_RPAREN] = ACTIONS(120),
    [anon_sym_await] = ACTIONS(132),
    [anon_sym_in] = ACTIONS(114),
    [anon_sym_COLON] = ACTIONS(120),
    [anon_sym_yield] = ACTIONS(134),
    [anon_sym_LBRACK] = ACTIONS(136),
    [anon_sym_LT] = ACTIONS(138),
    [anon_sym_GT] = ACTIONS(114),
    [anon_sym_SLASH] = ACTIONS(140),
    [anon_sym_DOT] = ACTIONS(114),
    [anon_sym_class] = ACTIONS(143),
    [anon_sym_async] = ACTIONS(145),
    [anon_sym_function] = ACTIONS(147),
    [anon_sym_EQ_GT] = ACTIONS(149),
    [anon_sym_QMARK_DOT] = ACTIONS(151),
    [anon_sym_new] = ACTIONS(153),
    [anon_sym_PLUS_EQ] = ACTIONS(155),
    [anon_sym_DASH_EQ] = ACTIONS(155),
    [anon_sym_STAR_EQ] = ACTIONS(155),
    [anon_sym_SLASH_EQ] = ACTIONS(155),
    [anon_sym_PERCENT_EQ] = ACTIONS(155),
    [anon_sym_CARET_EQ] = ACTIONS(155),
    [anon_sym_AMP_EQ] = ACTIONS(155),
    [anon_sym_PIPE_EQ] = ACTIONS(155),
    [anon_sym_GT_GT_EQ] = ACTIONS(155),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(155),
    [anon_sym_LT_LT_EQ] = ACTIONS(155),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(155),
    [anon_sym_AMP_AMP_EQ] = ACTIONS(155),
    [anon_sym_PIPE_PIPE_EQ] = ACTIONS(155),
    [anon_sym_QMARK_QMARK_EQ] = ACTIONS(155),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(157),
    [anon_sym_AMP_AMP] = ACTIONS(114),
    [anon_sym_PIPE_PIPE] = ACTIONS(114),
    [anon_sym_GT_GT] = ACTIONS(114),
    [anon_sym_GT_GT_GT] = ACTIONS(114),
    [anon_sym_LT_LT] = ACTIONS(114),
    [anon_sym_AMP] = ACTIONS(159),
    [anon_sym_CARET] = ACTIONS(114),
    [anon_sym_PIPE] = ACTIONS(161),
    [anon_sym_PLUS] = ACTIONS(163),
    [anon_sym_DASH] = ACTIONS(163),
    [anon_sym_PERCENT] = ACTIONS(114),
    [anon_sym_STAR_STAR] = ACTIONS(114),
    [anon_sym_LT_EQ] = ACTIONS(151),
    [anon_sym_EQ_EQ] = ACTIONS(114),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(151),
    [anon_sym_BANG_EQ] = ACTIONS(114),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(151),
    [anon_sym_GT_EQ] = ACTIONS(151),
    [anon_sym_QMARK_QMARK] = ACTIONS(114),
    [anon_sym_instanceof] = ACTIONS(114),
    [anon_sym_TILDE] = ACTIONS(165),
    [anon_sym_void] = ACTIONS(167),
    [anon_sym_delete] = ACTIONS(169),
    [anon_sym_PLUS_PLUS] = ACTIONS(171),
    [anon_sym_DASH_DASH] = ACTIONS(171),
    [anon_sym_DQUOTE] = ACTIONS(174),
    [anon_sym_SQUOTE] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(178),
    [sym_number] = ACTIONS(180),
    [sym_this] = ACTIONS(182),
    [sym_super] = ACTIONS(184),
    [sym_true] = ACTIONS(186),
    [sym_false] = ACTIONS(186),
    [sym_null] = ACTIONS(186),
    [sym_undefined] = ACTIONS(188),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(107),
    [anon_sym_readonly] = ACTIONS(190),
    [anon_sym_get] = ACTIONS(107),
    [anon_sym_set] = ACTIONS(107),
    [anon_sym_QMARK] = ACTIONS(192),
    [anon_sym_declare] = ACTIONS(107),
    [anon_sym_public] = ACTIONS(107),
    [anon_sym_private] = ACTIONS(107),
    [anon_sym_protected] = ACTIONS(107),
    [anon_sym_override] = ACTIONS(107),
    [anon_sym_module] = ACTIONS(107),
    [anon_sym_any] = ACTIONS(194),
    [anon_sym_number] = ACTIONS(194),
    [anon_sym_boolean] = ACTIONS(194),
    [anon_sym_string] = ACTIONS(194),
    [anon_sym_symbol] = ACTIONS(194),
    [anon_sym_abstract] = ACTIONS(196),
    [anon_sym_infer] = ACTIONS(198),
    [anon_sym_keyof] = ACTIONS(200),
    [anon_sym_unknown] = ACTIONS(202),
    [anon_sym_never] = ACTIONS(202),
    [anon_sym_object] = ACTIONS(202),
    [anon_sym_LBRACE_PIPE] = ACTIONS(204),
    [sym__ternary_qmark] = ACTIONS(151),
  },
  [3] = {
    [sym_import] = STATE(1405),
    [sym_parenthesized_expression] = STATE(1023),
    [sym_expression] = STATE(2015),
    [sym_primary_expression] = STATE(1404),
    [sym_yield_expression] = STATE(1403),
    [sym_object] = STATE(1405),
    [sym_object_pattern] = STATE(2733),
    [sym_array] = STATE(1405),
    [sym_array_pattern] = STATE(2733),
    [sym_nested_identifier] = STATE(4074),
    [sym_class] = STATE(1405),
    [sym_function] = STATE(1405),
    [sym_generator_function] = STATE(1405),
    [sym_arrow_function] = STATE(1405),
    [sym__call_signature] = STATE(4016),
    [sym_call_expression] = STATE(1405),
    [sym_new_expression] = STATE(1403),
    [sym_await_expression] = STATE(1403),
    [sym_member_expression] = STATE(1058),
    [sym_subscript_expression] = STATE(1058),
    [sym_assignment_expression] = STATE(1403),
    [sym__augmented_assignment_lhs] = STATE(2340),
    [sym_augmented_assignment_expression] = STATE(1403),
    [sym__destructuring_pattern] = STATE(2733),
    [sym_ternary_expression] = STATE(1403),
    [sym_binary_expression] = STATE(1403),
    [sym_unary_expression] = STATE(1403),
    [sym_update_expression] = STATE(1403),
    [sym_string] = STATE(1853),
    [sym_template_string] = STATE(1405),
    [sym_regex] = STATE(1405),
    [sym_meta_property] = STATE(1405),
    [sym_decorator] = STATE(1149),
    [sym_formal_parameters] = STATE(3260),
    [sym_pattern] = STATE(3191),
    [sym_rest_pattern] = STATE(2817),
    [sym_non_null_expression] = STATE(1058),
    [sym_type_assertion] = STATE(1403),
    [sym_as_expression] = STATE(1403),
    [sym_internal_module] = STATE(1403),
    [sym_nested_type_identifier] = STATE(2336),
    [sym__type] = STATE(2398),
    [sym_constructor_type] = STATE(2398),
    [sym__primary_type] = STATE(2373),
    [sym_template_literal_type] = STATE(2359),
    [sym_infer_type] = STATE(2398),
    [sym_conditional_type] = STATE(2359),
    [sym_generic_type] = STATE(2359),
    [sym_type_query] = STATE(2359),
    [sym_index_type_query] = STATE(2359),
    [sym_lookup_type] = STATE(2359),
    [sym_literal_type] = STATE(2359),
    [sym__number] = STATE(2355),
    [sym_existential_type] = STATE(2359),
    [sym_flow_maybe_type] = STATE(2359),
    [sym_parenthesized_type] = STATE(2359),
    [sym_predefined_type] = STATE(2359),
    [sym_type_arguments] = STATE(519),
    [sym_object_type] = STATE(2359),
    [sym_type_parameters] = STATE(3839),
    [sym_array_type] = STATE(2359),
    [sym_tuple_type] = STATE(2359),
    [sym_readonly_type] = STATE(2398),
    [sym_union_type] = STATE(2359),
    [sym_intersection_type] = STATE(2359),
    [sym_function_type] = STATE(2398),
    [aux_sym_export_statement_repeat1] = STATE(3368),
    [sym_identifier] = ACTIONS(105),
    [anon_sym_export] = ACTIONS(107),
    [anon_sym_STAR] = ACTIONS(109),
    [anon_sym_type] = ACTIONS(107),
    [anon_sym_EQ] = ACTIONS(206),
    [anon_sym_as] = ACTIONS(114),
    [anon_sym_namespace] = ACTIONS(116),
    [anon_sym_LBRACE] = ACTIONS(118),
    [anon_sym_COMMA] = ACTIONS(209),
    [anon_sym_typeof] = ACTIONS(123),
    [anon_sym_import] = ACTIONS(125),
    [anon_sym_BANG] = ACTIONS(127),
    [anon_sym_LPAREN] = ACTIONS(130),
    [anon_sym_RPAREN] = ACTIONS(209),
    [anon_sym_await] = ACTIONS(132),
    [anon_sym_in] = ACTIONS(114),
    [anon_sym_COLON] = ACTIONS(209),
    [anon_sym_yield] = ACTIONS(134),
    [anon_sym_LBRACK] = ACTIONS(136),
    [anon_sym_LT] = ACTIONS(138),
    [anon_sym_GT] = ACTIONS(114),
    [anon_sym_SLASH] = ACTIONS(140),
    [anon_sym_DOT] = ACTIONS(114),
    [anon_sym_class] = ACTIONS(143),
    [anon_sym_async] = ACTIONS(145),
    [anon_sym_function] = ACTIONS(147),
    [anon_sym_EQ_GT] = ACTIONS(211),
    [anon_sym_QMARK_DOT] = ACTIONS(151),
    [anon_sym_new] = ACTIONS(153),
    [anon_sym_PLUS_EQ] = ACTIONS(155),
    [anon_sym_DASH_EQ] = ACTIONS(155),
    [anon_sym_STAR_EQ] = ACTIONS(155),
    [anon_sym_SLASH_EQ] = ACTIONS(155),
    [anon_sym_PERCENT_EQ] = ACTIONS(155),
    [anon_sym_CARET_EQ] = ACTIONS(155),
    [anon_sym_AMP_EQ] = ACTIONS(155),
    [anon_sym_PIPE_EQ] = ACTIONS(155),
    [anon_sym_GT_GT_EQ] = ACTIONS(155),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(155),
    [anon_sym_LT_LT_EQ] = ACTIONS(155),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(155),
    [anon_sym_AMP_AMP_EQ] = ACTIONS(155),
    [anon_sym_PIPE_PIPE_EQ] = ACTIONS(155),
    [anon_sym_QMARK_QMARK_EQ] = ACTIONS(155),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(157),
    [anon_sym_AMP_AMP] = ACTIONS(114),
    [anon_sym_PIPE_PIPE] = ACTIONS(114),
    [anon_sym_GT_GT] = ACTIONS(114),
    [anon_sym_GT_GT_GT] = ACTIONS(114),
    [anon_sym_LT_LT] = ACTIONS(114),
    [anon_sym_AMP] = ACTIONS(159),
    [anon_sym_CARET] = ACTIONS(114),
    [anon_sym_PIPE] = ACTIONS(161),
    [anon_sym_PLUS] = ACTIONS(163),
    [anon_sym_DASH] = ACTIONS(163),
    [anon_sym_PERCENT] = ACTIONS(114),
    [anon_sym_STAR_STAR] = ACTIONS(114),
    [anon_sym_LT_EQ] = ACTIONS(151),
    [anon_sym_EQ_EQ] = ACTIONS(114),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(151),
    [anon_sym_BANG_EQ] = ACTIONS(114),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(151),
    [anon_sym_GT_EQ] = ACTIONS(151),
    [anon_sym_QMARK_QMARK] = ACTIONS(114),
    [anon_sym_instanceof] = ACTIONS(114),
    [anon_sym_TILDE] = ACTIONS(165),
    [anon_sym_void] = ACTIONS(167),
    [anon_sym_delete] = ACTIONS(169),
    [anon_sym_PLUS_PLUS] = ACTIONS(171),
    [anon_sym_DASH_DASH] = ACTIONS(171),
    [anon_sym_DQUOTE] = ACTIONS(174),
    [anon_sym_SQUOTE] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(178),
    [sym_number] = ACTIONS(180),
    [sym_this] = ACTIONS(182),
    [sym_super] = ACTIONS(184),
    [sym_true] = ACTIONS(186),
    [sym_false] = ACTIONS(186),
    [sym_null] = ACTIONS(186),
    [sym_undefined] = ACTIONS(188),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(107),
    [anon_sym_readonly] = ACTIONS(190),
    [anon_sym_get] = ACTIONS(107),
    [anon_sym_set] = ACTIONS(107),
    [anon_sym_QMARK] = ACTIONS(192),
    [anon_sym_declare] = ACTIONS(107),
    [anon_sym_public] = ACTIONS(107),
    [anon_sym_private] = ACTIONS(107),
    [anon_sym_protected] = ACTIONS(107),
    [anon_sym_override] = ACTIONS(107),
    [anon_sym_module] = ACTIONS(107),
    [anon_sym_any] = ACTIONS(194),
    [anon_sym_number] = ACTIONS(194),
    [anon_sym_boolean] = ACTIONS(194),
    [anon_sym_string] = ACTIONS(194),
    [anon_sym_symbol] = ACTIONS(194),
    [anon_sym_abstract] = ACTIONS(196),
    [anon_sym_infer] = ACTIONS(198),
    [anon_sym_keyof] = ACTIONS(200),
    [anon_sym_unknown] = ACTIONS(202),
    [anon_sym_never] = ACTIONS(202),
    [anon_sym_object] = ACTIONS(202),
    [anon_sym_LBRACE_PIPE] = ACTIONS(204),
    [sym__ternary_qmark] = ACTIONS(151),
  },
  [4] = {
    [sym_export_statement] = STATE(23),
    [sym_declaration] = STATE(23),
    [sym_import] = STATE(1844),
    [sym_import_statement] = STATE(23),
    [sym_expression_statement] = STATE(23),
    [sym_variable_declaration] = STATE(741),
    [sym_lexical_declaration] = STATE(741),
    [sym_statement_block] = STATE(23),
    [sym_if_statement] = STATE(23),
    [sym_switch_statement] = STATE(23),
    [sym_for_statement] = STATE(23),
    [sym_for_in_statement] = STATE(23),
    [sym_while_statement] = STATE(23),
    [sym_do_statement] = STATE(23),
    [sym_try_statement] = STATE(23),
    [sym_with_statement] = STATE(23),
    [sym_break_statement] = STATE(23),
    [sym_continue_statement] = STATE(23),
    [sym_debugger_statement] = STATE(23),
    [sym_return_statement] = STATE(23),
    [sym_throw_statement] = STATE(23),
    [sym_empty_statement] = STATE(23),
    [sym_labeled_statement] = STATE(23),
    [sym_parenthesized_expression] = STATE(1116),
    [sym_expression] = STATE(1697),
    [sym_primary_expression] = STATE(1799),
    [sym_yield_expression] = STATE(1798),
    [sym_object] = STATE(1844),
    [sym_object_pattern] = STATE(4134),
    [sym_object_assignment_pattern] = STATE(3609),
    [sym_array] = STATE(1844),
    [sym_array_pattern] = STATE(4134),
    [sym_class] = STATE(1844),
    [sym_class_declaration] = STATE(741),
    [sym_function] = STATE(1844),
    [sym_function_declaration] = STATE(741),
    [sym_generator_function] = STATE(1844),
    [sym_generator_function_declaration] = STATE(741),
    [sym_arrow_function] = STATE(1844),
    [sym__call_signature] = STATE(4172),
    [sym_call_expression] = STATE(1844),
    [sym_new_expression] = STATE(1798),
    [sym_await_expression] = STATE(1798),
    [sym_member_expression] = STATE(1116),
    [sym_subscript_expression] = STATE(1116),
    [sym_assignment_expression] = STATE(1798),
    [sym__augmented_assignment_lhs] = STATE(2357),
    [sym_augmented_assignment_expression] = STATE(1798),
    [sym__destructuring_pattern] = STATE(4134),
    [sym_spread_element] = STATE(3613),
    [sym_ternary_expression] = STATE(1798),
    [sym_binary_expression] = STATE(1798),
    [sym_unary_expression] = STATE(1798),
    [sym_update_expression] = STATE(1798),
    [sym_sequence_expression] = STATE(3662),
    [sym_string] = STATE(1747),
    [sym_template_string] = STATE(1844),
    [sym_regex] = STATE(1844),
    [sym_meta_property] = STATE(1844),
    [sym_decorator] = STATE(1149),
    [sym_formal_parameters] = STATE(2903),
    [sym_rest_pattern] = STATE(3609),
    [sym_method_definition] = STATE(3613),
    [sym_pair] = STATE(3613),
    [sym_pair_pattern] = STATE(3609),
    [sym__property_name] = STATE(2745),
    [sym_computed_property_name] = STATE(2745),
    [sym_non_null_expression] = STATE(1116),
    [sym_function_signature] = STATE(741),
    [sym_type_assertion] = STATE(1798),
    [sym_as_expression] = STATE(1798),
    [sym_ambient_declaration] = STATE(741),
    [sym_abstract_class_declaration] = STATE(741),
    [sym_module] = STATE(741),
    [sym_internal_module] = STATE(140),
    [sym_import_alias] = STATE(741),
    [sym_interface_declaration] = STATE(741),
    [sym_enum_declaration] = STATE(741),
    [sym_type_alias_declaration] = STATE(741),
    [sym_accessibility_modifier] = STATE(2239),
    [sym_override_modifier] = STATE(2250),
    [sym_type_arguments] = STATE(482),
    [sym_type_parameters] = STATE(3670),
    [aux_sym_program_repeat1] = STATE(23),
    [aux_sym_export_statement_repeat1] = STATE(2947),
    [aux_sym_object_repeat1] = STATE(3591),
    [aux_sym_object_pattern_repeat1] = STATE(3583),
    [sym_identifier] = ACTIONS(213),
    [anon_sym_export] = ACTIONS(215),
    [anon_sym_STAR] = ACTIONS(217),
    [anon_sym_type] = ACTIONS(219),
    [anon_sym_namespace] = ACTIONS(221),
    [anon_sym_LBRACE] = ACTIONS(17),
    [anon_sym_COMMA] = ACTIONS(223),
    [anon_sym_RBRACE] = ACTIONS(225),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_for] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_await] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(41),
    [anon_sym_do] = ACTIONS(43),
    [anon_sym_try] = ACTIONS(45),
    [anon_sym_with] = ACTIONS(47),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_debugger] = ACTIONS(53),
    [anon_sym_return] = ACTIONS(55),
    [anon_sym_throw] = ACTIONS(57),
    [anon_sym_SEMI] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(227),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(69),
    [anon_sym_async] = ACTIONS(229),
    [anon_sym_function] = ACTIONS(73),
    [anon_sym_new] = ACTIONS(75),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(231),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_void] = ACTIONS(19),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(77),
    [anon_sym_DASH_DASH] = ACTIONS(77),
    [anon_sym_DQUOTE] = ACTIONS(79),
    [anon_sym_SQUOTE] = ACTIONS(81),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(83),
    [sym_number] = ACTIONS(233),
    [sym_private_property_identifier] = ACTIONS(235),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(237),
    [anon_sym_readonly] = ACTIONS(239),
    [anon_sym_get] = ACTIONS(241),
    [anon_sym_set] = ACTIONS(241),
    [anon_sym_declare] = ACTIONS(243),
    [anon_sym_public] = ACTIONS(245),
    [anon_sym_private] = ACTIONS(245),
    [anon_sym_protected] = ACTIONS(245),
    [anon_sym_override] = ACTIONS(247),
    [anon_sym_module] = ACTIONS(249),
    [anon_sym_any] = ACTIONS(251),
    [anon_sym_number] = ACTIONS(251),
    [anon_sym_boolean] = ACTIONS(251),
    [anon_sym_string] = ACTIONS(251),
    [anon_sym_symbol] = ACTIONS(251),
    [anon_sym_abstract] = ACTIONS(99),
    [anon_sym_interface] = ACTIONS(101),
    [anon_sym_enum] = ACTIONS(103),
  },
  [5] = {
    [sym_export_statement] = STATE(28),
    [sym_declaration] = STATE(28),
    [sym_import] = STATE(1844),
    [sym_import_statement] = STATE(28),
    [sym_expression_statement] = STATE(28),
    [sym_variable_declaration] = STATE(741),
    [sym_lexical_declaration] = STATE(741),
    [sym_statement_block] = STATE(28),
    [sym_if_statement] = STATE(28),
    [sym_switch_statement] = STATE(28),
    [sym_for_statement] = STATE(28),
    [sym_for_in_statement] = STATE(28),
    [sym_while_statement] = STATE(28),
    [sym_do_statement] = STATE(28),
    [sym_try_statement] = STATE(28),
    [sym_with_statement] = STATE(28),
    [sym_break_statement] = STATE(28),
    [sym_continue_statement] = STATE(28),
    [sym_debugger_statement] = STATE(28),
    [sym_return_statement] = STATE(28),
    [sym_throw_statement] = STATE(28),
    [sym_empty_statement] = STATE(28),
    [sym_labeled_statement] = STATE(28),
    [sym_parenthesized_expression] = STATE(1116),
    [sym_expression] = STATE(1697),
    [sym_primary_expression] = STATE(1799),
    [sym_yield_expression] = STATE(1798),
    [sym_object] = STATE(1844),
    [sym_object_pattern] = STATE(4134),
    [sym_object_assignment_pattern] = STATE(3609),
    [sym_array] = STATE(1844),
    [sym_array_pattern] = STATE(4134),
    [sym_class] = STATE(1844),
    [sym_class_declaration] = STATE(741),
    [sym_function] = STATE(1844),
    [sym_function_declaration] = STATE(741),
    [sym_generator_function] = STATE(1844),
    [sym_generator_function_declaration] = STATE(741),
    [sym_arrow_function] = STATE(1844),
    [sym__call_signature] = STATE(4172),
    [sym_call_expression] = STATE(1844),
    [sym_new_expression] = STATE(1798),
    [sym_await_expression] = STATE(1798),
    [sym_member_expression] = STATE(1116),
    [sym_subscript_expression] = STATE(1116),
    [sym_assignment_expression] = STATE(1798),
    [sym__augmented_assignment_lhs] = STATE(2357),
    [sym_augmented_assignment_expression] = STATE(1798),
    [sym__destructuring_pattern] = STATE(4134),
    [sym_spread_element] = STATE(3613),
    [sym_ternary_expression] = STATE(1798),
    [sym_binary_expression] = STATE(1798),
    [sym_unary_expression] = STATE(1798),
    [sym_update_expression] = STATE(1798),
    [sym_sequence_expression] = STATE(3662),
    [sym_string] = STATE(1747),
    [sym_template_string] = STATE(1844),
    [sym_regex] = STATE(1844),
    [sym_meta_property] = STATE(1844),
    [sym_decorator] = STATE(1149),
    [sym_formal_parameters] = STATE(2903),
    [sym_rest_pattern] = STATE(3609),
    [sym_method_definition] = STATE(3613),
    [sym_pair] = STATE(3613),
    [sym_pair_pattern] = STATE(3609),
    [sym__property_name] = STATE(2745),
    [sym_computed_property_name] = STATE(2745),
    [sym_non_null_expression] = STATE(1116),
    [sym_function_signature] = STATE(741),
    [sym_type_assertion] = STATE(1798),
    [sym_as_expression] = STATE(1798),
    [sym_ambient_declaration] = STATE(741),
    [sym_abstract_class_declaration] = STATE(741),
    [sym_module] = STATE(741),
    [sym_internal_module] = STATE(140),
    [sym_import_alias] = STATE(741),
    [sym_interface_declaration] = STATE(741),
    [sym_enum_declaration] = STATE(741),
    [sym_type_alias_declaration] = STATE(741),
    [sym_accessibility_modifier] = STATE(2239),
    [sym_override_modifier] = STATE(2250),
    [sym_type_arguments] = STATE(482),
    [sym_type_parameters] = STATE(3670),
    [aux_sym_program_repeat1] = STATE(28),
    [aux_sym_export_statement_repeat1] = STATE(2947),
    [aux_sym_object_repeat1] = STATE(3591),
    [aux_sym_object_pattern_repeat1] = STATE(3583),
    [sym_identifier] = ACTIONS(213),
    [anon_sym_export] = ACTIONS(215),
    [anon_sym_STAR] = ACTIONS(217),
    [anon_sym_type] = ACTIONS(219),
    [anon_sym_namespace] = ACTIONS(221),
    [anon_sym_LBRACE] = ACTIONS(17),
    [anon_sym_COMMA] = ACTIONS(223),
    [anon_sym_RBRACE] = ACTIONS(253),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_for] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_await] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(41),
    [anon_sym_do] = ACTIONS(43),
    [anon_sym_try] = ACTIONS(45),
    [anon_sym_with] = ACTIONS(47),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_debugger] = ACTIONS(53),
    [anon_sym_return] = ACTIONS(55),
    [anon_sym_throw] = ACTIONS(57),
    [anon_sym_SEMI] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(227),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(69),
    [anon_sym_async] = ACTIONS(229),
    [anon_sym_function] = ACTIONS(73),
    [anon_sym_new] = ACTIONS(75),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(231),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_void] = ACTIONS(19),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(77),
    [anon_sym_DASH_DASH] = ACTIONS(77),
    [anon_sym_DQUOTE] = ACTIONS(79),
    [anon_sym_SQUOTE] = ACTIONS(81),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(83),
    [sym_number] = ACTIONS(233),
    [sym_private_property_identifier] = ACTIONS(235),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(237),
    [anon_sym_readonly] = ACTIONS(239),
    [anon_sym_get] = ACTIONS(241),
    [anon_sym_set] = ACTIONS(241),
    [anon_sym_declare] = ACTIONS(243),
    [anon_sym_public] = ACTIONS(245),
    [anon_sym_private] = ACTIONS(245),
    [anon_sym_protected] = ACTIONS(245),
    [anon_sym_override] = ACTIONS(247),
    [anon_sym_module] = ACTIONS(249),
    [anon_sym_any] = ACTIONS(251),
    [anon_sym_number] = ACTIONS(251),
    [anon_sym_boolean] = ACTIONS(251),
    [anon_sym_string] = ACTIONS(251),
    [anon_sym_symbol] = ACTIONS(251),
    [anon_sym_abstract] = ACTIONS(99),
    [anon_sym_interface] = ACTIONS(101),
    [anon_sym_enum] = ACTIONS(103),
  },
  [6] = {
    [sym_export_statement] = STATE(20),
    [sym_declaration] = STATE(20),
    [sym_import] = STATE(1844),
    [sym_import_statement] = STATE(20),
    [sym_expression_statement] = STATE(20),
    [sym_variable_declaration] = STATE(741),
    [sym_lexical_declaration] = STATE(741),
    [sym_statement_block] = STATE(20),
    [sym_if_statement] = STATE(20),
    [sym_switch_statement] = STATE(20),
    [sym_for_statement] = STATE(20),
    [sym_for_in_statement] = STATE(20),
    [sym_while_statement] = STATE(20),
    [sym_do_statement] = STATE(20),
    [sym_try_statement] = STATE(20),
    [sym_with_statement] = STATE(20),
    [sym_break_statement] = STATE(20),
    [sym_continue_statement] = STATE(20),
    [sym_debugger_statement] = STATE(20),
    [sym_return_statement] = STATE(20),
    [sym_throw_statement] = STATE(20),
    [sym_empty_statement] = STATE(20),
    [sym_labeled_statement] = STATE(20),
    [sym_parenthesized_expression] = STATE(1116),
    [sym_expression] = STATE(1697),
    [sym_primary_expression] = STATE(1799),
    [sym_yield_expression] = STATE(1798),
    [sym_object] = STATE(1844),
    [sym_object_pattern] = STATE(4134),
    [sym_object_assignment_pattern] = STATE(3609),
    [sym_array] = STATE(1844),
    [sym_array_pattern] = STATE(4134),
    [sym_class] = STATE(1844),
    [sym_class_declaration] = STATE(741),
    [sym_function] = STATE(1844),
    [sym_function_declaration] = STATE(741),
    [sym_generator_function] = STATE(1844),
    [sym_generator_function_declaration] = STATE(741),
    [sym_arrow_function] = STATE(1844),
    [sym__call_signature] = STATE(4172),
    [sym_call_expression] = STATE(1844),
    [sym_new_expression] = STATE(1798),
    [sym_await_expression] = STATE(1798),
    [sym_member_expression] = STATE(1116),
    [sym_subscript_expression] = STATE(1116),
    [sym_assignment_expression] = STATE(1798),
    [sym__augmented_assignment_lhs] = STATE(2357),
    [sym_augmented_assignment_expression] = STATE(1798),
    [sym__destructuring_pattern] = STATE(4134),
    [sym_spread_element] = STATE(3456),
    [sym_ternary_expression] = STATE(1798),
    [sym_binary_expression] = STATE(1798),
    [sym_unary_expression] = STATE(1798),
    [sym_update_expression] = STATE(1798),
    [sym_sequence_expression] = STATE(3662),
    [sym_string] = STATE(1747),
    [sym_template_string] = STATE(1844),
    [sym_regex] = STATE(1844),
    [sym_meta_property] = STATE(1844),
    [sym_decorator] = STATE(1149),
    [sym_formal_parameters] = STATE(2903),
    [sym_rest_pattern] = STATE(3609),
    [sym_method_definition] = STATE(3456),
    [sym_pair] = STATE(3456),
    [sym_pair_pattern] = STATE(3609),
    [sym__property_name] = STATE(2745),
    [sym_computed_property_name] = STATE(2745),
    [sym_non_null_expression] = STATE(1116),
    [sym_function_signature] = STATE(741),
    [sym_type_assertion] = STATE(1798),
    [sym_as_expression] = STATE(1798),
    [sym_ambient_declaration] = STATE(741),
    [sym_abstract_class_declaration] = STATE(741),
    [sym_module] = STATE(741),
    [sym_internal_module] = STATE(140),
    [sym_import_alias] = STATE(741),
    [sym_interface_declaration] = STATE(741),
    [sym_enum_declaration] = STATE(741),
    [sym_type_alias_declaration] = STATE(741),
    [sym_accessibility_modifier] = STATE(2239),
    [sym_override_modifier] = STATE(2250),
    [sym_type_arguments] = STATE(482),
    [sym_type_parameters] = STATE(3670),
    [aux_sym_program_repeat1] = STATE(20),
    [aux_sym_export_statement_repeat1] = STATE(2947),
    [aux_sym_object_repeat1] = STATE(3455),
    [aux_sym_object_pattern_repeat1] = STATE(3583),
    [sym_identifier] = ACTIONS(255),
    [anon_sym_export] = ACTIONS(257),
    [anon_sym_STAR] = ACTIONS(217),
    [anon_sym_type] = ACTIONS(259),
    [anon_sym_namespace] = ACTIONS(261),
    [anon_sym_LBRACE] = ACTIONS(17),
    [anon_sym_COMMA] = ACTIONS(223),
    [anon_sym_RBRACE] = ACTIONS(263),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_for] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_await] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(41),
    [anon_sym_do] = ACTIONS(43),
    [anon_sym_try] = ACTIONS(45),
    [anon_sym_with] = ACTIONS(47),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_debugger] = ACTIONS(53),
    [anon_sym_return] = ACTIONS(55),
    [anon_sym_throw] = ACTIONS(57),
    [anon_sym_SEMI] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(227),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(69),
    [anon_sym_async] = ACTIONS(265),
    [anon_sym_function] = ACTIONS(73),
    [anon_sym_new] = ACTIONS(75),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(231),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_void] = ACTIONS(19),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(77),
    [anon_sym_DASH_DASH] = ACTIONS(77),
    [anon_sym_DQUOTE] = ACTIONS(79),
    [anon_sym_SQUOTE] = ACTIONS(81),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(83),
    [sym_number] = ACTIONS(233),
    [sym_private_property_identifier] = ACTIONS(235),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(267),
    [anon_sym_readonly] = ACTIONS(269),
    [anon_sym_get] = ACTIONS(271),
    [anon_sym_set] = ACTIONS(271),
    [anon_sym_declare] = ACTIONS(273),
    [anon_sym_public] = ACTIONS(275),
    [anon_sym_private] = ACTIONS(275),
    [anon_sym_protected] = ACTIONS(275),
    [anon_sym_override] = ACTIONS(277),
    [anon_sym_module] = ACTIONS(279),
    [anon_sym_any] = ACTIONS(281),
    [anon_sym_number] = ACTIONS(281),
    [anon_sym_boolean] = ACTIONS(281),
    [anon_sym_string] = ACTIONS(281),
    [anon_sym_symbol] = ACTIONS(281),
    [anon_sym_abstract] = ACTIONS(99),
    [anon_sym_interface] = ACTIONS(101),
    [anon_sym_enum] = ACTIONS(103),
  },
  [7] = {
    [sym_export_statement] = STATE(20),
    [sym_declaration] = STATE(20),
    [sym_import] = STATE(1844),
    [sym_import_statement] = STATE(20),
    [sym_expression_statement] = STATE(20),
    [sym_variable_declaration] = STATE(741),
    [sym_lexical_declaration] = STATE(741),
    [sym_statement_block] = STATE(20),
    [sym_if_statement] = STATE(20),
    [sym_switch_statement] = STATE(20),
    [sym_for_statement] = STATE(20),
    [sym_for_in_statement] = STATE(20),
    [sym_while_statement] = STATE(20),
    [sym_do_statement] = STATE(20),
    [sym_try_statement] = STATE(20),
    [sym_with_statement] = STATE(20),
    [sym_break_statement] = STATE(20),
    [sym_continue_statement] = STATE(20),
    [sym_debugger_statement] = STATE(20),
    [sym_return_statement] = STATE(20),
    [sym_throw_statement] = STATE(20),
    [sym_empty_statement] = STATE(20),
    [sym_labeled_statement] = STATE(20),
    [sym_parenthesized_expression] = STATE(1116),
    [sym_expression] = STATE(1697),
    [sym_primary_expression] = STATE(1799),
    [sym_yield_expression] = STATE(1798),
    [sym_object] = STATE(1844),
    [sym_object_pattern] = STATE(4134),
    [sym_object_assignment_pattern] = STATE(3609),
    [sym_array] = STATE(1844),
    [sym_array_pattern] = STATE(4134),
    [sym_class] = STATE(1844),
    [sym_class_declaration] = STATE(741),
    [sym_function] = STATE(1844),
    [sym_function_declaration] = STATE(741),
    [sym_generator_function] = STATE(1844),
    [sym_generator_function_declaration] = STATE(741),
    [sym_arrow_function] = STATE(1844),
    [sym__call_signature] = STATE(4172),
    [sym_call_expression] = STATE(1844),
    [sym_new_expression] = STATE(1798),
    [sym_await_expression] = STATE(1798),
    [sym_member_expression] = STATE(1116),
    [sym_subscript_expression] = STATE(1116),
    [sym_assignment_expression] = STATE(1798),
    [sym__augmented_assignment_lhs] = STATE(2357),
    [sym_augmented_assignment_expression] = STATE(1798),
    [sym__destructuring_pattern] = STATE(4134),
    [sym_spread_element] = STATE(3456),
    [sym_ternary_expression] = STATE(1798),
    [sym_binary_expression] = STATE(1798),
    [sym_unary_expression] = STATE(1798),
    [sym_update_expression] = STATE(1798),
    [sym_sequence_expression] = STATE(3662),
    [sym_string] = STATE(1747),
    [sym_template_string] = STATE(1844),
    [sym_regex] = STATE(1844),
    [sym_meta_property] = STATE(1844),
    [sym_decorator] = STATE(1149),
    [sym_formal_parameters] = STATE(2903),
    [sym_rest_pattern] = STATE(3609),
    [sym_method_definition] = STATE(3456),
    [sym_pair] = STATE(3456),
    [sym_pair_pattern] = STATE(3609),
    [sym__property_name] = STATE(2745),
    [sym_computed_property_name] = STATE(2745),
    [sym_non_null_expression] = STATE(1116),
    [sym_function_signature] = STATE(741),
    [sym_type_assertion] = STATE(1798),
    [sym_as_expression] = STATE(1798),
    [sym_ambient_declaration] = STATE(741),
    [sym_abstract_class_declaration] = STATE(741),
    [sym_module] = STATE(741),
    [sym_internal_module] = STATE(140),
    [sym_import_alias] = STATE(741),
    [sym_interface_declaration] = STATE(741),
    [sym_enum_declaration] = STATE(741),
    [sym_type_alias_declaration] = STATE(741),
    [sym_accessibility_modifier] = STATE(2239),
    [sym_override_modifier] = STATE(2250),
    [sym_type_arguments] = STATE(482),
    [sym_type_parameters] = STATE(3670),
    [aux_sym_program_repeat1] = STATE(20),
    [aux_sym_export_statement_repeat1] = STATE(2947),
    [aux_sym_object_repeat1] = STATE(3455),
    [aux_sym_object_pattern_repeat1] = STATE(3583),
    [sym_identifier] = ACTIONS(283),
    [anon_sym_export] = ACTIONS(285),
    [anon_sym_STAR] = ACTIONS(217),
    [anon_sym_type] = ACTIONS(287),
    [anon_sym_namespace] = ACTIONS(289),
    [anon_sym_LBRACE] = ACTIONS(17),
    [anon_sym_COMMA] = ACTIONS(223),
    [anon_sym_RBRACE] = ACTIONS(263),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_for] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_await] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(41),
    [anon_sym_do] = ACTIONS(43),
    [anon_sym_try] = ACTIONS(45),
    [anon_sym_with] = ACTIONS(47),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_debugger] = ACTIONS(53),
    [anon_sym_return] = ACTIONS(55),
    [anon_sym_throw] = ACTIONS(57),
    [anon_sym_SEMI] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(227),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(69),
    [anon_sym_async] = ACTIONS(291),
    [anon_sym_function] = ACTIONS(73),
    [anon_sym_new] = ACTIONS(75),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(231),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_void] = ACTIONS(19),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(77),
    [anon_sym_DASH_DASH] = ACTIONS(77),
    [anon_sym_DQUOTE] = ACTIONS(79),
    [anon_sym_SQUOTE] = ACTIONS(81),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(83),
    [sym_number] = ACTIONS(233),
    [sym_private_property_identifier] = ACTIONS(235),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(293),
    [anon_sym_readonly] = ACTIONS(295),
    [anon_sym_get] = ACTIONS(297),
    [anon_sym_set] = ACTIONS(297),
    [anon_sym_declare] = ACTIONS(299),
    [anon_sym_public] = ACTIONS(301),
    [anon_sym_private] = ACTIONS(301),
    [anon_sym_protected] = ACTIONS(301),
    [anon_sym_override] = ACTIONS(303),
    [anon_sym_module] = ACTIONS(305),
    [anon_sym_any] = ACTIONS(307),
    [anon_sym_number] = ACTIONS(307),
    [anon_sym_boolean] = ACTIONS(307),
    [anon_sym_string] = ACTIONS(307),
    [anon_sym_symbol] = ACTIONS(307),
    [anon_sym_abstract] = ACTIONS(99),
    [anon_sym_interface] = ACTIONS(101),
    [anon_sym_enum] = ACTIONS(103),
  },
  [8] = {
    [sym_export_statement] = STATE(23),
    [sym_declaration] = STATE(23),
    [sym_import] = STATE(1844),
    [sym_import_statement] = STATE(23),
    [sym_expression_statement] = STATE(23),
    [sym_variable_declaration] = STATE(741),
    [sym_lexical_declaration] = STATE(741),
    [sym_statement_block] = STATE(23),
    [sym_if_statement] = STATE(23),
    [sym_switch_statement] = STATE(23),
    [sym_for_statement] = STATE(23),
    [sym_for_in_statement] = STATE(23),
    [sym_while_statement] = STATE(23),
    [sym_do_statement] = STATE(23),
    [sym_try_statement] = STATE(23),
    [sym_with_statement] = STATE(23),
    [sym_break_statement] = STATE(23),
    [sym_continue_statement] = STATE(23),
    [sym_debugger_statement] = STATE(23),
    [sym_return_statement] = STATE(23),
    [sym_throw_statement] = STATE(23),
    [sym_empty_statement] = STATE(23),
    [sym_labeled_statement] = STATE(23),
    [sym_parenthesized_expression] = STATE(1116),
    [sym_expression] = STATE(1697),
    [sym_primary_expression] = STATE(1799),
    [sym_yield_expression] = STATE(1798),
    [sym_object] = STATE(1844),
    [sym_object_pattern] = STATE(4134),
    [sym_object_assignment_pattern] = STATE(3609),
    [sym_array] = STATE(1844),
    [sym_array_pattern] = STATE(4134),
    [sym_class] = STATE(1844),
    [sym_class_declaration] = STATE(741),
    [sym_function] = STATE(1844),
    [sym_function_declaration] = STATE(741),
    [sym_generator_function] = STATE(1844),
    [sym_generator_function_declaration] = STATE(741),
    [sym_arrow_function] = STATE(1844),
    [sym__call_signature] = STATE(4172),
    [sym_call_expression] = STATE(1844),
    [sym_new_expression] = STATE(1798),
    [sym_await_expression] = STATE(1798),
    [sym_member_expression] = STATE(1116),
    [sym_subscript_expression] = STATE(1116),
    [sym_assignment_expression] = STATE(1798),
    [sym__augmented_assignment_lhs] = STATE(2357),
    [sym_augmented_assignment_expression] = STATE(1798),
    [sym__destructuring_pattern] = STATE(4134),
    [sym_spread_element] = STATE(3613),
    [sym_ternary_expression] = STATE(1798),
    [sym_binary_expression] = STATE(1798),
    [sym_unary_expression] = STATE(1798),
    [sym_update_expression] = STATE(1798),
    [sym_sequence_expression] = STATE(3662),
    [sym_string] = STATE(1747),
    [sym_template_string] = STATE(1844),
    [sym_regex] = STATE(1844),
    [sym_meta_property] = STATE(1844),
    [sym_decorator] = STATE(1149),
    [sym_formal_parameters] = STATE(2903),
    [sym_rest_pattern] = STATE(3609),
    [sym_method_definition] = STATE(3613),
    [sym_pair] = STATE(3613),
    [sym_pair_pattern] = STATE(3609),
    [sym__property_name] = STATE(2745),
    [sym_computed_property_name] = STATE(2745),
    [sym_non_null_expression] = STATE(1116),
    [sym_function_signature] = STATE(741),
    [sym_type_assertion] = STATE(1798),
    [sym_as_expression] = STATE(1798),
    [sym_ambient_declaration] = STATE(741),
    [sym_abstract_class_declaration] = STATE(741),
    [sym_module] = STATE(741),
    [sym_internal_module] = STATE(140),
    [sym_import_alias] = STATE(741),
    [sym_interface_declaration] = STATE(741),
    [sym_enum_declaration] = STATE(741),
    [sym_type_alias_declaration] = STATE(741),
    [sym_accessibility_modifier] = STATE(2239),
    [sym_override_modifier] = STATE(2250),
    [sym_type_arguments] = STATE(482),
    [sym_type_parameters] = STATE(3670),
    [aux_sym_program_repeat1] = STATE(23),
    [aux_sym_export_statement_repeat1] = STATE(2947),
    [aux_sym_object_repeat1] = STATE(3591),
    [aux_sym_object_pattern_repeat1] = STATE(3583),
    [sym_identifier] = ACTIONS(213),
    [anon_sym_export] = ACTIONS(215),
    [anon_sym_STAR] = ACTIONS(217),
    [anon_sym_type] = ACTIONS(219),
    [anon_sym_namespace] = ACTIONS(221),
    [anon_sym_LBRACE] = ACTIONS(17),
    [anon_sym_COMMA] = ACTIONS(223),
    [anon_sym_RBRACE] = ACTIONS(309),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_for] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_await] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(41),
    [anon_sym_do] = ACTIONS(43),
    [anon_sym_try] = ACTIONS(45),
    [anon_sym_with] = ACTIONS(47),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_debugger] = ACTIONS(53),
    [anon_sym_return] = ACTIONS(55),
    [anon_sym_throw] = ACTIONS(57),
    [anon_sym_SEMI] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(227),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(69),
    [anon_sym_async] = ACTIONS(229),
    [anon_sym_function] = ACTIONS(73),
    [anon_sym_new] = ACTIONS(75),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(231),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_void] = ACTIONS(19),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(77),
    [anon_sym_DASH_DASH] = ACTIONS(77),
    [anon_sym_DQUOTE] = ACTIONS(79),
    [anon_sym_SQUOTE] = ACTIONS(81),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(83),
    [sym_number] = ACTIONS(233),
    [sym_private_property_identifier] = ACTIONS(235),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(237),
    [anon_sym_readonly] = ACTIONS(239),
    [anon_sym_get] = ACTIONS(241),
    [anon_sym_set] = ACTIONS(241),
    [anon_sym_declare] = ACTIONS(243),
    [anon_sym_public] = ACTIONS(245),
    [anon_sym_private] = ACTIONS(245),
    [anon_sym_protected] = ACTIONS(245),
    [anon_sym_override] = ACTIONS(247),
    [anon_sym_module] = ACTIONS(249),
    [anon_sym_any] = ACTIONS(251),
    [anon_sym_number] = ACTIONS(251),
    [anon_sym_boolean] = ACTIONS(251),
    [anon_sym_string] = ACTIONS(251),
    [anon_sym_symbol] = ACTIONS(251),
    [anon_sym_abstract] = ACTIONS(99),
    [anon_sym_interface] = ACTIONS(101),
    [anon_sym_enum] = ACTIONS(103),
  },
  [9] = {
    [sym_export_statement] = STATE(9),
    [sym_declaration] = STATE(9),
    [sym_import] = STATE(1844),
    [sym_import_statement] = STATE(9),
    [sym_expression_statement] = STATE(9),
    [sym_variable_declaration] = STATE(741),
    [sym_lexical_declaration] = STATE(741),
    [sym_statement_block] = STATE(9),
    [sym_if_statement] = STATE(9),
    [sym_switch_statement] = STATE(9),
    [sym_for_statement] = STATE(9),
    [sym_for_in_statement] = STATE(9),
    [sym_while_statement] = STATE(9),
    [sym_do_statement] = STATE(9),
    [sym_try_statement] = STATE(9),
    [sym_with_statement] = STATE(9),
    [sym_break_statement] = STATE(9),
    [sym_continue_statement] = STATE(9),
    [sym_debugger_statement] = STATE(9),
    [sym_return_statement] = STATE(9),
    [sym_throw_statement] = STATE(9),
    [sym_empty_statement] = STATE(9),
    [sym_labeled_statement] = STATE(9),
    [sym_parenthesized_expression] = STATE(1116),
    [sym_expression] = STATE(1697),
    [sym_primary_expression] = STATE(1799),
    [sym_yield_expression] = STATE(1798),
    [sym_object] = STATE(1844),
    [sym_object_pattern] = STATE(4170),
    [sym_array] = STATE(1844),
    [sym_array_pattern] = STATE(4170),
    [sym_class] = STATE(1844),
    [sym_class_declaration] = STATE(741),
    [sym_function] = STATE(1844),
    [sym_function_declaration] = STATE(741),
    [sym_generator_function] = STATE(1844),
    [sym_generator_function_declaration] = STATE(741),
    [sym_arrow_function] = STATE(1844),
    [sym__call_signature] = STATE(4172),
    [sym_call_expression] = STATE(1844),
    [sym_new_expression] = STATE(1798),
    [sym_await_expression] = STATE(1798),
    [sym_member_expression] = STATE(1116),
    [sym_subscript_expression] = STATE(1116),
    [sym_assignment_expression] = STATE(1798),
    [sym__augmented_assignment_lhs] = STATE(2357),
    [sym_augmented_assignment_expression] = STATE(1798),
    [sym__destructuring_pattern] = STATE(4170),
    [sym_ternary_expression] = STATE(1798),
    [sym_binary_expression] = STATE(1798),
    [sym_unary_expression] = STATE(1798),
    [sym_update_expression] = STATE(1798),
    [sym_sequence_expression] = STATE(3662),
    [sym_string] = STATE(1844),
    [sym_template_string] = STATE(1844),
    [sym_regex] = STATE(1844),
    [sym_meta_property] = STATE(1844),
    [sym_decorator] = STATE(1149),
    [sym_formal_parameters] = STATE(2903),
    [sym_non_null_expression] = STATE(1116),
    [sym_function_signature] = STATE(741),
    [sym_type_assertion] = STATE(1798),
    [sym_as_expression] = STATE(1798),
    [sym_ambient_declaration] = STATE(741),
    [sym_abstract_class_declaration] = STATE(741),
    [sym_module] = STATE(741),
    [sym_internal_module] = STATE(140),
    [sym_import_alias] = STATE(741),
    [sym_interface_declaration] = STATE(741),
    [sym_enum_declaration] = STATE(741),
    [sym_type_alias_declaration] = STATE(741),
    [sym_type_arguments] = STATE(482),
    [sym_type_parameters] = STATE(3670),
    [aux_sym_program_repeat1] = STATE(9),
    [aux_sym_export_statement_repeat1] = STATE(2947),
    [ts_builtin_sym_end] = ACTIONS(311),
    [sym_identifier] = ACTIONS(313),
    [anon_sym_export] = ACTIONS(316),
    [anon_sym_default] = ACTIONS(319),
    [anon_sym_type] = ACTIONS(321),
    [anon_sym_namespace] = ACTIONS(324),
    [anon_sym_LBRACE] = ACTIONS(327),
    [anon_sym_RBRACE] = ACTIONS(311),
    [anon_sym_typeof] = ACTIONS(330),
    [anon_sym_import] = ACTIONS(333),
    [anon_sym_var] = ACTIONS(336),
    [anon_sym_let] = ACTIONS(339),
    [anon_sym_const] = ACTIONS(342),
    [anon_sym_BANG] = ACTIONS(345),
    [anon_sym_if] = ACTIONS(348),
    [anon_sym_switch] = ACTIONS(351),
    [anon_sym_for] = ACTIONS(354),
    [anon_sym_LPAREN] = ACTIONS(357),
    [anon_sym_await] = ACTIONS(360),
    [anon_sym_while] = ACTIONS(363),
    [anon_sym_do] = ACTIONS(366),
    [anon_sym_try] = ACTIONS(369),
    [anon_sym_with] = ACTIONS(372),
    [anon_sym_break] = ACTIONS(375),
    [anon_sym_continue] = ACTIONS(378),
    [anon_sym_debugger] = ACTIONS(381),
    [anon_sym_return] = ACTIONS(384),
    [anon_sym_throw] = ACTIONS(387),
    [anon_sym_SEMI] = ACTIONS(390),
    [anon_sym_case] = ACTIONS(319),
    [anon_sym_yield] = ACTIONS(393),
    [anon_sym_LBRACK] = ACTIONS(396),
    [anon_sym_LT] = ACTIONS(399),
    [anon_sym_SLASH] = ACTIONS(402),
    [anon_sym_class] = ACTIONS(405),
    [anon_sym_async] = ACTIONS(408),
    [anon_sym_function] = ACTIONS(411),
    [anon_sym_new] = ACTIONS(414),
    [anon_sym_PLUS] = ACTIONS(330),
    [anon_sym_DASH] = ACTIONS(330),
    [anon_sym_TILDE] = ACTIONS(345),
    [anon_sym_void] = ACTIONS(330),
    [anon_sym_delete] = ACTIONS(330),
    [anon_sym_PLUS_PLUS] = ACTIONS(417),
    [anon_sym_DASH_DASH] = ACTIONS(417),
    [anon_sym_DQUOTE] = ACTIONS(420),
    [anon_sym_SQUOTE] = ACTIONS(423),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(426),
    [sym_number] = ACTIONS(429),
    [sym_this] = ACTIONS(432),
    [sym_super] = ACTIONS(432),
    [sym_true] = ACTIONS(432),
    [sym_false] = ACTIONS(432),
    [sym_null] = ACTIONS(432),
    [sym_undefined] = ACTIONS(435),
    [anon_sym_AT] = ACTIONS(438),
    [anon_sym_static] = ACTIONS(441),
    [anon_sym_readonly] = ACTIONS(441),
    [anon_sym_get] = ACTIONS(441),
    [anon_sym_set] = ACTIONS(441),
    [anon_sym_declare] = ACTIONS(444),
    [anon_sym_public] = ACTIONS(441),
    [anon_sym_private] = ACTIONS(441),
    [anon_sym_protected] = ACTIONS(441),
    [anon_sym_override] = ACTIONS(441),
    [anon_sym_module] = ACTIONS(447),
    [anon_sym_any] = ACTIONS(441),
    [anon_sym_number] = ACTIONS(441),
    [anon_sym_boolean] = ACTIONS(441),
    [anon_sym_string] = ACTIONS(441),
    [anon_sym_symbol] = ACTIONS(441),
    [anon_sym_abstract] = ACTIONS(450),
    [anon_sym_interface] = ACTIONS(453),
    [anon_sym_enum] = ACTIONS(456),
  },
  [10] = {
    [sym_export_statement] = STATE(12),
    [sym_declaration] = STATE(12),
    [sym_import] = STATE(1844),
    [sym_import_statement] = STATE(12),
    [sym_expression_statement] = STATE(12),
    [sym_variable_declaration] = STATE(741),
    [sym_lexical_declaration] = STATE(741),
    [sym_statement_block] = STATE(12),
    [sym_if_statement] = STATE(12),
    [sym_switch_statement] = STATE(12),
    [sym_for_statement] = STATE(12),
    [sym_for_in_statement] = STATE(12),
    [sym_while_statement] = STATE(12),
    [sym_do_statement] = STATE(12),
    [sym_try_statement] = STATE(12),
    [sym_with_statement] = STATE(12),
    [sym_break_statement] = STATE(12),
    [sym_continue_statement] = STATE(12),
    [sym_debugger_statement] = STATE(12),
    [sym_return_statement] = STATE(12),
    [sym_throw_statement] = STATE(12),
    [sym_empty_statement] = STATE(12),
    [sym_labeled_statement] = STATE(12),
    [sym_parenthesized_expression] = STATE(1116),
    [sym_expression] = STATE(1697),
    [sym_primary_expression] = STATE(1799),
    [sym_yield_expression] = STATE(1798),
    [sym_object] = STATE(1844),
    [sym_object_pattern] = STATE(4170),
    [sym_array] = STATE(1844),
    [sym_array_pattern] = STATE(4170),
    [sym_class] = STATE(1844),
    [sym_class_declaration] = STATE(741),
    [sym_function] = STATE(1844),
    [sym_function_declaration] = STATE(741),
    [sym_generator_function] = STATE(1844),
    [sym_generator_function_declaration] = STATE(741),
    [sym_arrow_function] = STATE(1844),
    [sym__call_signature] = STATE(4172),
    [sym_call_expression] = STATE(1844),
    [sym_new_expression] = STATE(1798),
    [sym_await_expression] = STATE(1798),
    [sym_member_expression] = STATE(1116),
    [sym_subscript_expression] = STATE(1116),
    [sym_assignment_expression] = STATE(1798),
    [sym__augmented_assignment_lhs] = STATE(2357),
    [sym_augmented_assignment_expression] = STATE(1798),
    [sym__destructuring_pattern] = STATE(4170),
    [sym_ternary_expression] = STATE(1798),
    [sym_binary_expression] = STATE(1798),
    [sym_unary_expression] = STATE(1798),
    [sym_update_expression] = STATE(1798),
    [sym_sequence_expression] = STATE(3662),
    [sym_string] = STATE(1844),
    [sym_template_string] = STATE(1844),
    [sym_regex] = STATE(1844),
    [sym_meta_property] = STATE(1844),
    [sym_decorator] = STATE(1149),
    [sym_formal_parameters] = STATE(2903),
    [sym_non_null_expression] = STATE(1116),
    [sym_function_signature] = STATE(741),
    [sym_type_assertion] = STATE(1798),
    [sym_as_expression] = STATE(1798),
    [sym_ambient_declaration] = STATE(741),
    [sym_abstract_class_declaration] = STATE(741),
    [sym_module] = STATE(741),
    [sym_internal_module] = STATE(140),
    [sym_import_alias] = STATE(741),
    [sym_interface_declaration] = STATE(741),
    [sym_enum_declaration] = STATE(741),
    [sym_type_alias_declaration] = STATE(741),
    [sym_type_arguments] = STATE(482),
    [sym_type_parameters] = STATE(3670),
    [aux_sym_program_repeat1] = STATE(12),
    [aux_sym_export_statement_repeat1] = STATE(2947),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_default] = ACTIONS(459),
    [anon_sym_type] = ACTIONS(13),
    [anon_sym_namespace] = ACTIONS(15),
    [anon_sym_LBRACE] = ACTIONS(17),
    [anon_sym_RBRACE] = ACTIONS(461),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_for] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_await] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(41),
    [anon_sym_do] = ACTIONS(43),
    [anon_sym_try] = ACTIONS(45),
    [anon_sym_with] = ACTIONS(47),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_debugger] = ACTIONS(53),
    [anon_sym_return] = ACTIONS(55),
    [anon_sym_throw] = ACTIONS(57),
    [anon_sym_SEMI] = ACTIONS(59),
    [anon_sym_case] = ACTIONS(459),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(69),
    [anon_sym_async] = ACTIONS(71),
    [anon_sym_function] = ACTIONS(73),
    [anon_sym_new] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_void] = ACTIONS(19),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(77),
    [anon_sym_DASH_DASH] = ACTIONS(77),
    [anon_sym_DQUOTE] = ACTIONS(79),
    [anon_sym_SQUOTE] = ACTIONS(81),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(83),
    [sym_number] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(93),
    [anon_sym_readonly] = ACTIONS(93),
    [anon_sym_get] = ACTIONS(93),
    [anon_sym_set] = ACTIONS(93),
    [anon_sym_declare] = ACTIONS(95),
    [anon_sym_public] = ACTIONS(93),
    [anon_sym_private] = ACTIONS(93),
    [anon_sym_protected] = ACTIONS(93),
    [anon_sym_override] = ACTIONS(93),
    [anon_sym_module] = ACTIONS(97),
    [anon_sym_any] = ACTIONS(93),
    [anon_sym_number] = ACTIONS(93),
    [anon_sym_boolean] = ACTIONS(93),
    [anon_sym_string] = ACTIONS(93),
    [anon_sym_symbol] = ACTIONS(93),
    [anon_sym_abstract] = ACTIONS(99),
    [anon_sym_interface] = ACTIONS(101),
    [anon_sym_enum] = ACTIONS(103),
  },
  [11] = {
    [sym_export_statement] = STATE(9),
    [sym_declaration] = STATE(9),
    [sym_import] = STATE(1844),
    [sym_import_statement] = STATE(9),
    [sym_expression_statement] = STATE(9),
    [sym_variable_declaration] = STATE(741),
    [sym_lexical_declaration] = STATE(741),
    [sym_statement_block] = STATE(9),
    [sym_if_statement] = STATE(9),
    [sym_switch_statement] = STATE(9),
    [sym_for_statement] = STATE(9),
    [sym_for_in_statement] = STATE(9),
    [sym_while_statement] = STATE(9),
    [sym_do_statement] = STATE(9),
    [sym_try_statement] = STATE(9),
    [sym_with_statement] = STATE(9),
    [sym_break_statement] = STATE(9),
    [sym_continue_statement] = STATE(9),
    [sym_debugger_statement] = STATE(9),
    [sym_return_statement] = STATE(9),
    [sym_throw_statement] = STATE(9),
    [sym_empty_statement] = STATE(9),
    [sym_labeled_statement] = STATE(9),
    [sym_parenthesized_expression] = STATE(1116),
    [sym_expression] = STATE(1697),
    [sym_primary_expression] = STATE(1799),
    [sym_yield_expression] = STATE(1798),
    [sym_object] = STATE(1844),
    [sym_object_pattern] = STATE(4170),
    [sym_array] = STATE(1844),
    [sym_array_pattern] = STATE(4170),
    [sym_class] = STATE(1844),
    [sym_class_declaration] = STATE(741),
    [sym_function] = STATE(1844),
    [sym_function_declaration] = STATE(741),
    [sym_generator_function] = STATE(1844),
    [sym_generator_function_declaration] = STATE(741),
    [sym_arrow_function] = STATE(1844),
    [sym__call_signature] = STATE(4172),
    [sym_call_expression] = STATE(1844),
    [sym_new_expression] = STATE(1798),
    [sym_await_expression] = STATE(1798),
    [sym_member_expression] = STATE(1116),
    [sym_subscript_expression] = STATE(1116),
    [sym_assignment_expression] = STATE(1798),
    [sym__augmented_assignment_lhs] = STATE(2357),
    [sym_augmented_assignment_expression] = STATE(1798),
    [sym__destructuring_pattern] = STATE(4170),
    [sym_ternary_expression] = STATE(1798),
    [sym_binary_expression] = STATE(1798),
    [sym_unary_expression] = STATE(1798),
    [sym_update_expression] = STATE(1798),
    [sym_sequence_expression] = STATE(3662),
    [sym_string] = STATE(1844),
    [sym_template_string] = STATE(1844),
    [sym_regex] = STATE(1844),
    [sym_meta_property] = STATE(1844),
    [sym_decorator] = STATE(1149),
    [sym_formal_parameters] = STATE(2903),
    [sym_non_null_expression] = STATE(1116),
    [sym_function_signature] = STATE(741),
    [sym_type_assertion] = STATE(1798),
    [sym_as_expression] = STATE(1798),
    [sym_ambient_declaration] = STATE(741),
    [sym_abstract_class_declaration] = STATE(741),
    [sym_module] = STATE(741),
    [sym_internal_module] = STATE(140),
    [sym_import_alias] = STATE(741),
    [sym_interface_declaration] = STATE(741),
    [sym_enum_declaration] = STATE(741),
    [sym_type_alias_declaration] = STATE(741),
    [sym_type_arguments] = STATE(482),
    [sym_type_parameters] = STATE(3670),
    [aux_sym_program_repeat1] = STATE(9),
    [aux_sym_export_statement_repeat1] = STATE(2947),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_default] = ACTIONS(463),
    [anon_sym_type] = ACTIONS(13),
    [anon_sym_namespace] = ACTIONS(15),
    [anon_sym_LBRACE] = ACTIONS(17),
    [anon_sym_RBRACE] = ACTIONS(465),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_for] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_await] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(41),
    [anon_sym_do] = ACTIONS(43),
    [anon_sym_try] = ACTIONS(45),
    [anon_sym_with] = ACTIONS(47),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_debugger] = ACTIONS(53),
    [anon_sym_return] = ACTIONS(55),
    [anon_sym_throw] = ACTIONS(57),
    [anon_sym_SEMI] = ACTIONS(59),
    [anon_sym_case] = ACTIONS(463),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(69),
    [anon_sym_async] = ACTIONS(71),
    [anon_sym_function] = ACTIONS(73),
    [anon_sym_new] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_void] = ACTIONS(19),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(77),
    [anon_sym_DASH_DASH] = ACTIONS(77),
    [anon_sym_DQUOTE] = ACTIONS(79),
    [anon_sym_SQUOTE] = ACTIONS(81),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(83),
    [sym_number] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(93),
    [anon_sym_readonly] = ACTIONS(93),
    [anon_sym_get] = ACTIONS(93),
    [anon_sym_set] = ACTIONS(93),
    [anon_sym_declare] = ACTIONS(95),
    [anon_sym_public] = ACTIONS(93),
    [anon_sym_private] = ACTIONS(93),
    [anon_sym_protected] = ACTIONS(93),
    [anon_sym_override] = ACTIONS(93),
    [anon_sym_module] = ACTIONS(97),
    [anon_sym_any] = ACTIONS(93),
    [anon_sym_number] = ACTIONS(93),
    [anon_sym_boolean] = ACTIONS(93),
    [anon_sym_string] = ACTIONS(93),
    [anon_sym_symbol] = ACTIONS(93),
    [anon_sym_abstract] = ACTIONS(99),
    [anon_sym_interface] = ACTIONS(101),
    [anon_sym_enum] = ACTIONS(103),
  },
  [12] = {
    [sym_export_statement] = STATE(9),
    [sym_declaration] = STATE(9),
    [sym_import] = STATE(1844),
    [sym_import_statement] = STATE(9),
    [sym_expression_statement] = STATE(9),
    [sym_variable_declaration] = STATE(741),
    [sym_lexical_declaration] = STATE(741),
    [sym_statement_block] = STATE(9),
    [sym_if_statement] = STATE(9),
    [sym_switch_statement] = STATE(9),
    [sym_for_statement] = STATE(9),
    [sym_for_in_statement] = STATE(9),
    [sym_while_statement] = STATE(9),
    [sym_do_statement] = STATE(9),
    [sym_try_statement] = STATE(9),
    [sym_with_statement] = STATE(9),
    [sym_break_statement] = STATE(9),
    [sym_continue_statement] = STATE(9),
    [sym_debugger_statement] = STATE(9),
    [sym_return_statement] = STATE(9),
    [sym_throw_statement] = STATE(9),
    [sym_empty_statement] = STATE(9),
    [sym_labeled_statement] = STATE(9),
    [sym_parenthesized_expression] = STATE(1116),
    [sym_expression] = STATE(1697),
    [sym_primary_expression] = STATE(1799),
    [sym_yield_expression] = STATE(1798),
    [sym_object] = STATE(1844),
    [sym_object_pattern] = STATE(4170),
    [sym_array] = STATE(1844),
    [sym_array_pattern] = STATE(4170),
    [sym_class] = STATE(1844),
    [sym_class_declaration] = STATE(741),
    [sym_function] = STATE(1844),
    [sym_function_declaration] = STATE(741),
    [sym_generator_function] = STATE(1844),
    [sym_generator_function_declaration] = STATE(741),
    [sym_arrow_function] = STATE(1844),
    [sym__call_signature] = STATE(4172),
    [sym_call_expression] = STATE(1844),
    [sym_new_expression] = STATE(1798),
    [sym_await_expression] = STATE(1798),
    [sym_member_expression] = STATE(1116),
    [sym_subscript_expression] = STATE(1116),
    [sym_assignment_expression] = STATE(1798),
    [sym__augmented_assignment_lhs] = STATE(2357),
    [sym_augmented_assignment_expression] = STATE(1798),
    [sym__destructuring_pattern] = STATE(4170),
    [sym_ternary_expression] = STATE(1798),
    [sym_binary_expression] = STATE(1798),
    [sym_unary_expression] = STATE(1798),
    [sym_update_expression] = STATE(1798),
    [sym_sequence_expression] = STATE(3662),
    [sym_string] = STATE(1844),
    [sym_template_string] = STATE(1844),
    [sym_regex] = STATE(1844),
    [sym_meta_property] = STATE(1844),
    [sym_decorator] = STATE(1149),
    [sym_formal_parameters] = STATE(2903),
    [sym_non_null_expression] = STATE(1116),
    [sym_function_signature] = STATE(741),
    [sym_type_assertion] = STATE(1798),
    [sym_as_expression] = STATE(1798),
    [sym_ambient_declaration] = STATE(741),
    [sym_abstract_class_declaration] = STATE(741),
    [sym_module] = STATE(741),
    [sym_internal_module] = STATE(140),
    [sym_import_alias] = STATE(741),
    [sym_interface_declaration] = STATE(741),
    [sym_enum_declaration] = STATE(741),
    [sym_type_alias_declaration] = STATE(741),
    [sym_type_arguments] = STATE(482),
    [sym_type_parameters] = STATE(3670),
    [aux_sym_program_repeat1] = STATE(9),
    [aux_sym_export_statement_repeat1] = STATE(2947),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_default] = ACTIONS(467),
    [anon_sym_type] = ACTIONS(13),
    [anon_sym_namespace] = ACTIONS(15),
    [anon_sym_LBRACE] = ACTIONS(17),
    [anon_sym_RBRACE] = ACTIONS(469),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_for] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_await] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(41),
    [anon_sym_do] = ACTIONS(43),
    [anon_sym_try] = ACTIONS(45),
    [anon_sym_with] = ACTIONS(47),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_debugger] = ACTIONS(53),
    [anon_sym_return] = ACTIONS(55),
    [anon_sym_throw] = ACTIONS(57),
    [anon_sym_SEMI] = ACTIONS(59),
    [anon_sym_case] = ACTIONS(467),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(69),
    [anon_sym_async] = ACTIONS(71),
    [anon_sym_function] = ACTIONS(73),
    [anon_sym_new] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_void] = ACTIONS(19),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(77),
    [anon_sym_DASH_DASH] = ACTIONS(77),
    [anon_sym_DQUOTE] = ACTIONS(79),
    [anon_sym_SQUOTE] = ACTIONS(81),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(83),
    [sym_number] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(93),
    [anon_sym_readonly] = ACTIONS(93),
    [anon_sym_get] = ACTIONS(93),
    [anon_sym_set] = ACTIONS(93),
    [anon_sym_declare] = ACTIONS(95),
    [anon_sym_public] = ACTIONS(93),
    [anon_sym_private] = ACTIONS(93),
    [anon_sym_protected] = ACTIONS(93),
    [anon_sym_override] = ACTIONS(93),
    [anon_sym_module] = ACTIONS(97),
    [anon_sym_any] = ACTIONS(93),
    [anon_sym_number] = ACTIONS(93),
    [anon_sym_boolean] = ACTIONS(93),
    [anon_sym_string] = ACTIONS(93),
    [anon_sym_symbol] = ACTIONS(93),
    [anon_sym_abstract] = ACTIONS(99),
    [anon_sym_interface] = ACTIONS(101),
    [anon_sym_enum] = ACTIONS(103),
  },
  [13] = {
    [sym_export_statement] = STATE(11),
    [sym_declaration] = STATE(11),
    [sym_import] = STATE(1844),
    [sym_import_statement] = STATE(11),
    [sym_expression_statement] = STATE(11),
    [sym_variable_declaration] = STATE(741),
    [sym_lexical_declaration] = STATE(741),
    [sym_statement_block] = STATE(11),
    [sym_if_statement] = STATE(11),
    [sym_switch_statement] = STATE(11),
    [sym_for_statement] = STATE(11),
    [sym_for_in_statement] = STATE(11),
    [sym_while_statement] = STATE(11),
    [sym_do_statement] = STATE(11),
    [sym_try_statement] = STATE(11),
    [sym_with_statement] = STATE(11),
    [sym_break_statement] = STATE(11),
    [sym_continue_statement] = STATE(11),
    [sym_debugger_statement] = STATE(11),
    [sym_return_statement] = STATE(11),
    [sym_throw_statement] = STATE(11),
    [sym_empty_statement] = STATE(11),
    [sym_labeled_statement] = STATE(11),
    [sym_parenthesized_expression] = STATE(1116),
    [sym_expression] = STATE(1697),
    [sym_primary_expression] = STATE(1799),
    [sym_yield_expression] = STATE(1798),
    [sym_object] = STATE(1844),
    [sym_object_pattern] = STATE(4170),
    [sym_array] = STATE(1844),
    [sym_array_pattern] = STATE(4170),
    [sym_class] = STATE(1844),
    [sym_class_declaration] = STATE(741),
    [sym_function] = STATE(1844),
    [sym_function_declaration] = STATE(741),
    [sym_generator_function] = STATE(1844),
    [sym_generator_function_declaration] = STATE(741),
    [sym_arrow_function] = STATE(1844),
    [sym__call_signature] = STATE(4172),
    [sym_call_expression] = STATE(1844),
    [sym_new_expression] = STATE(1798),
    [sym_await_expression] = STATE(1798),
    [sym_member_expression] = STATE(1116),
    [sym_subscript_expression] = STATE(1116),
    [sym_assignment_expression] = STATE(1798),
    [sym__augmented_assignment_lhs] = STATE(2357),
    [sym_augmented_assignment_expression] = STATE(1798),
    [sym__destructuring_pattern] = STATE(4170),
    [sym_ternary_expression] = STATE(1798),
    [sym_binary_expression] = STATE(1798),
    [sym_unary_expression] = STATE(1798),
    [sym_update_expression] = STATE(1798),
    [sym_sequence_expression] = STATE(3662),
    [sym_string] = STATE(1844),
    [sym_template_string] = STATE(1844),
    [sym_regex] = STATE(1844),
    [sym_meta_property] = STATE(1844),
    [sym_decorator] = STATE(1149),
    [sym_formal_parameters] = STATE(2903),
    [sym_non_null_expression] = STATE(1116),
    [sym_function_signature] = STATE(741),
    [sym_type_assertion] = STATE(1798),
    [sym_as_expression] = STATE(1798),
    [sym_ambient_declaration] = STATE(741),
    [sym_abstract_class_declaration] = STATE(741),
    [sym_module] = STATE(741),
    [sym_internal_module] = STATE(140),
    [sym_import_alias] = STATE(741),
    [sym_interface_declaration] = STATE(741),
    [sym_enum_declaration] = STATE(741),
    [sym_type_alias_declaration] = STATE(741),
    [sym_type_arguments] = STATE(482),
    [sym_type_parameters] = STATE(3670),
    [aux_sym_program_repeat1] = STATE(11),
    [aux_sym_export_statement_repeat1] = STATE(2947),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_default] = ACTIONS(471),
    [anon_sym_type] = ACTIONS(13),
    [anon_sym_namespace] = ACTIONS(15),
    [anon_sym_LBRACE] = ACTIONS(17),
    [anon_sym_RBRACE] = ACTIONS(473),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_for] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_await] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(41),
    [anon_sym_do] = ACTIONS(43),
    [anon_sym_try] = ACTIONS(45),
    [anon_sym_with] = ACTIONS(47),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_debugger] = ACTIONS(53),
    [anon_sym_return] = ACTIONS(55),
    [anon_sym_throw] = ACTIONS(57),
    [anon_sym_SEMI] = ACTIONS(59),
    [anon_sym_case] = ACTIONS(471),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(69),
    [anon_sym_async] = ACTIONS(71),
    [anon_sym_function] = ACTIONS(73),
    [anon_sym_new] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_void] = ACTIONS(19),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(77),
    [anon_sym_DASH_DASH] = ACTIONS(77),
    [anon_sym_DQUOTE] = ACTIONS(79),
    [anon_sym_SQUOTE] = ACTIONS(81),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(83),
    [sym_number] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(93),
    [anon_sym_readonly] = ACTIONS(93),
    [anon_sym_get] = ACTIONS(93),
    [anon_sym_set] = ACTIONS(93),
    [anon_sym_declare] = ACTIONS(95),
    [anon_sym_public] = ACTIONS(93),
    [anon_sym_private] = ACTIONS(93),
    [anon_sym_protected] = ACTIONS(93),
    [anon_sym_override] = ACTIONS(93),
    [anon_sym_module] = ACTIONS(97),
    [anon_sym_any] = ACTIONS(93),
    [anon_sym_number] = ACTIONS(93),
    [anon_sym_boolean] = ACTIONS(93),
    [anon_sym_string] = ACTIONS(93),
    [anon_sym_symbol] = ACTIONS(93),
    [anon_sym_abstract] = ACTIONS(99),
    [anon_sym_interface] = ACTIONS(101),
    [anon_sym_enum] = ACTIONS(103),
  },
  [14] = {
    [sym_export_statement] = STATE(9),
    [sym_declaration] = STATE(9),
    [sym_import] = STATE(1844),
    [sym_import_statement] = STATE(9),
    [sym_expression_statement] = STATE(9),
    [sym_variable_declaration] = STATE(741),
    [sym_lexical_declaration] = STATE(741),
    [sym_statement_block] = STATE(9),
    [sym_if_statement] = STATE(9),
    [sym_switch_statement] = STATE(9),
    [sym_for_statement] = STATE(9),
    [sym_for_in_statement] = STATE(9),
    [sym_while_statement] = STATE(9),
    [sym_do_statement] = STATE(9),
    [sym_try_statement] = STATE(9),
    [sym_with_statement] = STATE(9),
    [sym_break_statement] = STATE(9),
    [sym_continue_statement] = STATE(9),
    [sym_debugger_statement] = STATE(9),
    [sym_return_statement] = STATE(9),
    [sym_throw_statement] = STATE(9),
    [sym_empty_statement] = STATE(9),
    [sym_labeled_statement] = STATE(9),
    [sym_parenthesized_expression] = STATE(1116),
    [sym_expression] = STATE(1697),
    [sym_primary_expression] = STATE(1799),
    [sym_yield_expression] = STATE(1798),
    [sym_object] = STATE(1844),
    [sym_object_pattern] = STATE(4170),
    [sym_array] = STATE(1844),
    [sym_array_pattern] = STATE(4170),
    [sym_class] = STATE(1844),
    [sym_class_declaration] = STATE(741),
    [sym_function] = STATE(1844),
    [sym_function_declaration] = STATE(741),
    [sym_generator_function] = STATE(1844),
    [sym_generator_function_declaration] = STATE(741),
    [sym_arrow_function] = STATE(1844),
    [sym__call_signature] = STATE(4172),
    [sym_call_expression] = STATE(1844),
    [sym_new_expression] = STATE(1798),
    [sym_await_expression] = STATE(1798),
    [sym_member_expression] = STATE(1116),
    [sym_subscript_expression] = STATE(1116),
    [sym_assignment_expression] = STATE(1798),
    [sym__augmented_assignment_lhs] = STATE(2357),
    [sym_augmented_assignment_expression] = STATE(1798),
    [sym__destructuring_pattern] = STATE(4170),
    [sym_ternary_expression] = STATE(1798),
    [sym_binary_expression] = STATE(1798),
    [sym_unary_expression] = STATE(1798),
    [sym_update_expression] = STATE(1798),
    [sym_sequence_expression] = STATE(3662),
    [sym_string] = STATE(1844),
    [sym_template_string] = STATE(1844),
    [sym_regex] = STATE(1844),
    [sym_meta_property] = STATE(1844),
    [sym_decorator] = STATE(1149),
    [sym_formal_parameters] = STATE(2903),
    [sym_non_null_expression] = STATE(1116),
    [sym_function_signature] = STATE(741),
    [sym_type_assertion] = STATE(1798),
    [sym_as_expression] = STATE(1798),
    [sym_ambient_declaration] = STATE(741),
    [sym_abstract_class_declaration] = STATE(741),
    [sym_module] = STATE(741),
    [sym_internal_module] = STATE(140),
    [sym_import_alias] = STATE(741),
    [sym_interface_declaration] = STATE(741),
    [sym_enum_declaration] = STATE(741),
    [sym_type_alias_declaration] = STATE(741),
    [sym_type_arguments] = STATE(482),
    [sym_type_parameters] = STATE(3670),
    [aux_sym_program_repeat1] = STATE(9),
    [aux_sym_export_statement_repeat1] = STATE(2947),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_type] = ACTIONS(13),
    [anon_sym_namespace] = ACTIONS(15),
    [anon_sym_LBRACE] = ACTIONS(17),
    [anon_sym_RBRACE] = ACTIONS(475),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_for] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_await] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(41),
    [anon_sym_do] = ACTIONS(43),
    [anon_sym_try] = ACTIONS(45),
    [anon_sym_with] = ACTIONS(47),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_debugger] = ACTIONS(53),
    [anon_sym_return] = ACTIONS(55),
    [anon_sym_throw] = ACTIONS(57),
    [anon_sym_SEMI] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(69),
    [anon_sym_async] = ACTIONS(71),
    [anon_sym_function] = ACTIONS(73),
    [anon_sym_new] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_void] = ACTIONS(19),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(77),
    [anon_sym_DASH_DASH] = ACTIONS(77),
    [anon_sym_DQUOTE] = ACTIONS(79),
    [anon_sym_SQUOTE] = ACTIONS(81),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(83),
    [sym_number] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(93),
    [anon_sym_readonly] = ACTIONS(93),
    [anon_sym_get] = ACTIONS(93),
    [anon_sym_set] = ACTIONS(93),
    [anon_sym_declare] = ACTIONS(95),
    [anon_sym_public] = ACTIONS(93),
    [anon_sym_private] = ACTIONS(93),
    [anon_sym_protected] = ACTIONS(93),
    [anon_sym_override] = ACTIONS(93),
    [anon_sym_module] = ACTIONS(97),
    [anon_sym_any] = ACTIONS(93),
    [anon_sym_number] = ACTIONS(93),
    [anon_sym_boolean] = ACTIONS(93),
    [anon_sym_string] = ACTIONS(93),
    [anon_sym_symbol] = ACTIONS(93),
    [anon_sym_abstract] = ACTIONS(99),
    [anon_sym_interface] = ACTIONS(101),
    [anon_sym_enum] = ACTIONS(103),
  },
  [15] = {
    [sym_export_statement] = STATE(9),
    [sym_declaration] = STATE(9),
    [sym_import] = STATE(1844),
    [sym_import_statement] = STATE(9),
    [sym_expression_statement] = STATE(9),
    [sym_variable_declaration] = STATE(741),
    [sym_lexical_declaration] = STATE(741),
    [sym_statement_block] = STATE(9),
    [sym_if_statement] = STATE(9),
    [sym_switch_statement] = STATE(9),
    [sym_for_statement] = STATE(9),
    [sym_for_in_statement] = STATE(9),
    [sym_while_statement] = STATE(9),
    [sym_do_statement] = STATE(9),
    [sym_try_statement] = STATE(9),
    [sym_with_statement] = STATE(9),
    [sym_break_statement] = STATE(9),
    [sym_continue_statement] = STATE(9),
    [sym_debugger_statement] = STATE(9),
    [sym_return_statement] = STATE(9),
    [sym_throw_statement] = STATE(9),
    [sym_empty_statement] = STATE(9),
    [sym_labeled_statement] = STATE(9),
    [sym_parenthesized_expression] = STATE(1116),
    [sym_expression] = STATE(1697),
    [sym_primary_expression] = STATE(1799),
    [sym_yield_expression] = STATE(1798),
    [sym_object] = STATE(1844),
    [sym_object_pattern] = STATE(4170),
    [sym_array] = STATE(1844),
    [sym_array_pattern] = STATE(4170),
    [sym_class] = STATE(1844),
    [sym_class_declaration] = STATE(741),
    [sym_function] = STATE(1844),
    [sym_function_declaration] = STATE(741),
    [sym_generator_function] = STATE(1844),
    [sym_generator_function_declaration] = STATE(741),
    [sym_arrow_function] = STATE(1844),
    [sym__call_signature] = STATE(4172),
    [sym_call_expression] = STATE(1844),
    [sym_new_expression] = STATE(1798),
    [sym_await_expression] = STATE(1798),
    [sym_member_expression] = STATE(1116),
    [sym_subscript_expression] = STATE(1116),
    [sym_assignment_expression] = STATE(1798),
    [sym__augmented_assignment_lhs] = STATE(2357),
    [sym_augmented_assignment_expression] = STATE(1798),
    [sym__destructuring_pattern] = STATE(4170),
    [sym_ternary_expression] = STATE(1798),
    [sym_binary_expression] = STATE(1798),
    [sym_unary_expression] = STATE(1798),
    [sym_update_expression] = STATE(1798),
    [sym_sequence_expression] = STATE(3662),
    [sym_string] = STATE(1844),
    [sym_template_string] = STATE(1844),
    [sym_regex] = STATE(1844),
    [sym_meta_property] = STATE(1844),
    [sym_decorator] = STATE(1149),
    [sym_formal_parameters] = STATE(2903),
    [sym_non_null_expression] = STATE(1116),
    [sym_function_signature] = STATE(741),
    [sym_type_assertion] = STATE(1798),
    [sym_as_expression] = STATE(1798),
    [sym_ambient_declaration] = STATE(741),
    [sym_abstract_class_declaration] = STATE(741),
    [sym_module] = STATE(741),
    [sym_internal_module] = STATE(140),
    [sym_import_alias] = STATE(741),
    [sym_interface_declaration] = STATE(741),
    [sym_enum_declaration] = STATE(741),
    [sym_type_alias_declaration] = STATE(741),
    [sym_type_arguments] = STATE(482),
    [sym_type_parameters] = STATE(3670),
    [aux_sym_program_repeat1] = STATE(9),
    [aux_sym_export_statement_repeat1] = STATE(2947),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_type] = ACTIONS(13),
    [anon_sym_namespace] = ACTIONS(15),
    [anon_sym_LBRACE] = ACTIONS(17),
    [anon_sym_RBRACE] = ACTIONS(477),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_for] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_await] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(41),
    [anon_sym_do] = ACTIONS(43),
    [anon_sym_try] = ACTIONS(45),
    [anon_sym_with] = ACTIONS(47),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_debugger] = ACTIONS(53),
    [anon_sym_return] = ACTIONS(55),
    [anon_sym_throw] = ACTIONS(57),
    [anon_sym_SEMI] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(69),
    [anon_sym_async] = ACTIONS(71),
    [anon_sym_function] = ACTIONS(73),
    [anon_sym_new] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_void] = ACTIONS(19),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(77),
    [anon_sym_DASH_DASH] = ACTIONS(77),
    [anon_sym_DQUOTE] = ACTIONS(79),
    [anon_sym_SQUOTE] = ACTIONS(81),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(83),
    [sym_number] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(93),
    [anon_sym_readonly] = ACTIONS(93),
    [anon_sym_get] = ACTIONS(93),
    [anon_sym_set] = ACTIONS(93),
    [anon_sym_declare] = ACTIONS(95),
    [anon_sym_public] = ACTIONS(93),
    [anon_sym_private] = ACTIONS(93),
    [anon_sym_protected] = ACTIONS(93),
    [anon_sym_override] = ACTIONS(93),
    [anon_sym_module] = ACTIONS(97),
    [anon_sym_any] = ACTIONS(93),
    [anon_sym_number] = ACTIONS(93),
    [anon_sym_boolean] = ACTIONS(93),
    [anon_sym_string] = ACTIONS(93),
    [anon_sym_symbol] = ACTIONS(93),
    [anon_sym_abstract] = ACTIONS(99),
    [anon_sym_interface] = ACTIONS(101),
    [anon_sym_enum] = ACTIONS(103),
  },
  [16] = {
    [sym_export_statement] = STATE(9),
    [sym_declaration] = STATE(9),
    [sym_import] = STATE(1844),
    [sym_import_statement] = STATE(9),
    [sym_expression_statement] = STATE(9),
    [sym_variable_declaration] = STATE(741),
    [sym_lexical_declaration] = STATE(741),
    [sym_statement_block] = STATE(9),
    [sym_if_statement] = STATE(9),
    [sym_switch_statement] = STATE(9),
    [sym_for_statement] = STATE(9),
    [sym_for_in_statement] = STATE(9),
    [sym_while_statement] = STATE(9),
    [sym_do_statement] = STATE(9),
    [sym_try_statement] = STATE(9),
    [sym_with_statement] = STATE(9),
    [sym_break_statement] = STATE(9),
    [sym_continue_statement] = STATE(9),
    [sym_debugger_statement] = STATE(9),
    [sym_return_statement] = STATE(9),
    [sym_throw_statement] = STATE(9),
    [sym_empty_statement] = STATE(9),
    [sym_labeled_statement] = STATE(9),
    [sym_parenthesized_expression] = STATE(1116),
    [sym_expression] = STATE(1697),
    [sym_primary_expression] = STATE(1799),
    [sym_yield_expression] = STATE(1798),
    [sym_object] = STATE(1844),
    [sym_object_pattern] = STATE(4170),
    [sym_array] = STATE(1844),
    [sym_array_pattern] = STATE(4170),
    [sym_class] = STATE(1844),
    [sym_class_declaration] = STATE(741),
    [sym_function] = STATE(1844),
    [sym_function_declaration] = STATE(741),
    [sym_generator_function] = STATE(1844),
    [sym_generator_function_declaration] = STATE(741),
    [sym_arrow_function] = STATE(1844),
    [sym__call_signature] = STATE(4172),
    [sym_call_expression] = STATE(1844),
    [sym_new_expression] = STATE(1798),
    [sym_await_expression] = STATE(1798),
    [sym_member_expression] = STATE(1116),
    [sym_subscript_expression] = STATE(1116),
    [sym_assignment_expression] = STATE(1798),
    [sym__augmented_assignment_lhs] = STATE(2357),
    [sym_augmented_assignment_expression] = STATE(1798),
    [sym__destructuring_pattern] = STATE(4170),
    [sym_ternary_expression] = STATE(1798),
    [sym_binary_expression] = STATE(1798),
    [sym_unary_expression] = STATE(1798),
    [sym_update_expression] = STATE(1798),
    [sym_sequence_expression] = STATE(3662),
    [sym_string] = STATE(1844),
    [sym_template_string] = STATE(1844),
    [sym_regex] = STATE(1844),
    [sym_meta_property] = STATE(1844),
    [sym_decorator] = STATE(1149),
    [sym_formal_parameters] = STATE(2903),
    [sym_non_null_expression] = STATE(1116),
    [sym_function_signature] = STATE(741),
    [sym_type_assertion] = STATE(1798),
    [sym_as_expression] = STATE(1798),
    [sym_ambient_declaration] = STATE(741),
    [sym_abstract_class_declaration] = STATE(741),
    [sym_module] = STATE(741),
    [sym_internal_module] = STATE(140),
    [sym_import_alias] = STATE(741),
    [sym_interface_declaration] = STATE(741),
    [sym_enum_declaration] = STATE(741),
    [sym_type_alias_declaration] = STATE(741),
    [sym_type_arguments] = STATE(482),
    [sym_type_parameters] = STATE(3670),
    [aux_sym_program_repeat1] = STATE(9),
    [aux_sym_export_statement_repeat1] = STATE(2947),
    [ts_builtin_sym_end] = ACTIONS(479),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_type] = ACTIONS(13),
    [anon_sym_namespace] = ACTIONS(15),
    [anon_sym_LBRACE] = ACTIONS(17),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_for] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_await] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(41),
    [anon_sym_do] = ACTIONS(43),
    [anon_sym_try] = ACTIONS(45),
    [anon_sym_with] = ACTIONS(47),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_debugger] = ACTIONS(53),
    [anon_sym_return] = ACTIONS(55),
    [anon_sym_throw] = ACTIONS(57),
    [anon_sym_SEMI] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(69),
    [anon_sym_async] = ACTIONS(71),
    [anon_sym_function] = ACTIONS(73),
    [anon_sym_new] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_void] = ACTIONS(19),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(77),
    [anon_sym_DASH_DASH] = ACTIONS(77),
    [anon_sym_DQUOTE] = ACTIONS(79),
    [anon_sym_SQUOTE] = ACTIONS(81),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(83),
    [sym_number] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(93),
    [anon_sym_readonly] = ACTIONS(93),
    [anon_sym_get] = ACTIONS(93),
    [anon_sym_set] = ACTIONS(93),
    [anon_sym_declare] = ACTIONS(95),
    [anon_sym_public] = ACTIONS(93),
    [anon_sym_private] = ACTIONS(93),
    [anon_sym_protected] = ACTIONS(93),
    [anon_sym_override] = ACTIONS(93),
    [anon_sym_module] = ACTIONS(97),
    [anon_sym_any] = ACTIONS(93),
    [anon_sym_number] = ACTIONS(93),
    [anon_sym_boolean] = ACTIONS(93),
    [anon_sym_string] = ACTIONS(93),
    [anon_sym_symbol] = ACTIONS(93),
    [anon_sym_abstract] = ACTIONS(99),
    [anon_sym_interface] = ACTIONS(101),
    [anon_sym_enum] = ACTIONS(103),
  },
  [17] = {
    [sym_export_statement] = STATE(9),
    [sym_declaration] = STATE(9),
    [sym_import] = STATE(1844),
    [sym_import_statement] = STATE(9),
    [sym_expression_statement] = STATE(9),
    [sym_variable_declaration] = STATE(741),
    [sym_lexical_declaration] = STATE(741),
    [sym_statement_block] = STATE(9),
    [sym_if_statement] = STATE(9),
    [sym_switch_statement] = STATE(9),
    [sym_for_statement] = STATE(9),
    [sym_for_in_statement] = STATE(9),
    [sym_while_statement] = STATE(9),
    [sym_do_statement] = STATE(9),
    [sym_try_statement] = STATE(9),
    [sym_with_statement] = STATE(9),
    [sym_break_statement] = STATE(9),
    [sym_continue_statement] = STATE(9),
    [sym_debugger_statement] = STATE(9),
    [sym_return_statement] = STATE(9),
    [sym_throw_statement] = STATE(9),
    [sym_empty_statement] = STATE(9),
    [sym_labeled_statement] = STATE(9),
    [sym_parenthesized_expression] = STATE(1116),
    [sym_expression] = STATE(1697),
    [sym_primary_expression] = STATE(1799),
    [sym_yield_expression] = STATE(1798),
    [sym_object] = STATE(1844),
    [sym_object_pattern] = STATE(4170),
    [sym_array] = STATE(1844),
    [sym_array_pattern] = STATE(4170),
    [sym_class] = STATE(1844),
    [sym_class_declaration] = STATE(741),
    [sym_function] = STATE(1844),
    [sym_function_declaration] = STATE(741),
    [sym_generator_function] = STATE(1844),
    [sym_generator_function_declaration] = STATE(741),
    [sym_arrow_function] = STATE(1844),
    [sym__call_signature] = STATE(4172),
    [sym_call_expression] = STATE(1844),
    [sym_new_expression] = STATE(1798),
    [sym_await_expression] = STATE(1798),
    [sym_member_expression] = STATE(1116),
    [sym_subscript_expression] = STATE(1116),
    [sym_assignment_expression] = STATE(1798),
    [sym__augmented_assignment_lhs] = STATE(2357),
    [sym_augmented_assignment_expression] = STATE(1798),
    [sym__destructuring_pattern] = STATE(4170),
    [sym_ternary_expression] = STATE(1798),
    [sym_binary_expression] = STATE(1798),
    [sym_unary_expression] = STATE(1798),
    [sym_update_expression] = STATE(1798),
    [sym_sequence_expression] = STATE(3662),
    [sym_string] = STATE(1844),
    [sym_template_string] = STATE(1844),
    [sym_regex] = STATE(1844),
    [sym_meta_property] = STATE(1844),
    [sym_decorator] = STATE(1149),
    [sym_formal_parameters] = STATE(2903),
    [sym_non_null_expression] = STATE(1116),
    [sym_function_signature] = STATE(741),
    [sym_type_assertion] = STATE(1798),
    [sym_as_expression] = STATE(1798),
    [sym_ambient_declaration] = STATE(741),
    [sym_abstract_class_declaration] = STATE(741),
    [sym_module] = STATE(741),
    [sym_internal_module] = STATE(140),
    [sym_import_alias] = STATE(741),
    [sym_interface_declaration] = STATE(741),
    [sym_enum_declaration] = STATE(741),
    [sym_type_alias_declaration] = STATE(741),
    [sym_type_arguments] = STATE(482),
    [sym_type_parameters] = STATE(3670),
    [aux_sym_program_repeat1] = STATE(9),
    [aux_sym_export_statement_repeat1] = STATE(2947),
    [ts_builtin_sym_end] = ACTIONS(481),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_type] = ACTIONS(13),
    [anon_sym_namespace] = ACTIONS(15),
    [anon_sym_LBRACE] = ACTIONS(17),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_for] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_await] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(41),
    [anon_sym_do] = ACTIONS(43),
    [anon_sym_try] = ACTIONS(45),
    [anon_sym_with] = ACTIONS(47),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_debugger] = ACTIONS(53),
    [anon_sym_return] = ACTIONS(55),
    [anon_sym_throw] = ACTIONS(57),
    [anon_sym_SEMI] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(69),
    [anon_sym_async] = ACTIONS(71),
    [anon_sym_function] = ACTIONS(73),
    [anon_sym_new] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_void] = ACTIONS(19),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(77),
    [anon_sym_DASH_DASH] = ACTIONS(77),
    [anon_sym_DQUOTE] = ACTIONS(79),
    [anon_sym_SQUOTE] = ACTIONS(81),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(83),
    [sym_number] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(93),
    [anon_sym_readonly] = ACTIONS(93),
    [anon_sym_get] = ACTIONS(93),
    [anon_sym_set] = ACTIONS(93),
    [anon_sym_declare] = ACTIONS(95),
    [anon_sym_public] = ACTIONS(93),
    [anon_sym_private] = ACTIONS(93),
    [anon_sym_protected] = ACTIONS(93),
    [anon_sym_override] = ACTIONS(93),
    [anon_sym_module] = ACTIONS(97),
    [anon_sym_any] = ACTIONS(93),
    [anon_sym_number] = ACTIONS(93),
    [anon_sym_boolean] = ACTIONS(93),
    [anon_sym_string] = ACTIONS(93),
    [anon_sym_symbol] = ACTIONS(93),
    [anon_sym_abstract] = ACTIONS(99),
    [anon_sym_interface] = ACTIONS(101),
    [anon_sym_enum] = ACTIONS(103),
  },
  [18] = {
    [sym_export_statement] = STATE(20),
    [sym_declaration] = STATE(20),
    [sym_import] = STATE(1844),
    [sym_import_statement] = STATE(20),
    [sym_expression_statement] = STATE(20),
    [sym_variable_declaration] = STATE(741),
    [sym_lexical_declaration] = STATE(741),
    [sym_statement_block] = STATE(20),
    [sym_if_statement] = STATE(20),
    [sym_switch_statement] = STATE(20),
    [sym_for_statement] = STATE(20),
    [sym_for_in_statement] = STATE(20),
    [sym_while_statement] = STATE(20),
    [sym_do_statement] = STATE(20),
    [sym_try_statement] = STATE(20),
    [sym_with_statement] = STATE(20),
    [sym_break_statement] = STATE(20),
    [sym_continue_statement] = STATE(20),
    [sym_debugger_statement] = STATE(20),
    [sym_return_statement] = STATE(20),
    [sym_throw_statement] = STATE(20),
    [sym_empty_statement] = STATE(20),
    [sym_labeled_statement] = STATE(20),
    [sym_parenthesized_expression] = STATE(1116),
    [sym_expression] = STATE(1697),
    [sym_primary_expression] = STATE(1799),
    [sym_yield_expression] = STATE(1798),
    [sym_object] = STATE(1844),
    [sym_object_pattern] = STATE(4170),
    [sym_array] = STATE(1844),
    [sym_array_pattern] = STATE(4170),
    [sym_class] = STATE(1844),
    [sym_class_declaration] = STATE(741),
    [sym_function] = STATE(1844),
    [sym_function_declaration] = STATE(741),
    [sym_generator_function] = STATE(1844),
    [sym_generator_function_declaration] = STATE(741),
    [sym_arrow_function] = STATE(1844),
    [sym__call_signature] = STATE(4172),
    [sym_call_expression] = STATE(1844),
    [sym_new_expression] = STATE(1798),
    [sym_await_expression] = STATE(1798),
    [sym_member_expression] = STATE(1116),
    [sym_subscript_expression] = STATE(1116),
    [sym_assignment_expression] = STATE(1798),
    [sym__augmented_assignment_lhs] = STATE(2357),
    [sym_augmented_assignment_expression] = STATE(1798),
    [sym__destructuring_pattern] = STATE(4170),
    [sym_ternary_expression] = STATE(1798),
    [sym_binary_expression] = STATE(1798),
    [sym_unary_expression] = STATE(1798),
    [sym_update_expression] = STATE(1798),
    [sym_sequence_expression] = STATE(3662),
    [sym_string] = STATE(1844),
    [sym_template_string] = STATE(1844),
    [sym_regex] = STATE(1844),
    [sym_meta_property] = STATE(1844),
    [sym_decorator] = STATE(1149),
    [sym_formal_parameters] = STATE(2903),
    [sym_non_null_expression] = STATE(1116),
    [sym_function_signature] = STATE(741),
    [sym_type_assertion] = STATE(1798),
    [sym_as_expression] = STATE(1798),
    [sym_ambient_declaration] = STATE(741),
    [sym_abstract_class_declaration] = STATE(741),
    [sym_module] = STATE(741),
    [sym_internal_module] = STATE(140),
    [sym_import_alias] = STATE(741),
    [sym_interface_declaration] = STATE(741),
    [sym_enum_declaration] = STATE(741),
    [sym_type_alias_declaration] = STATE(741),
    [sym_type_arguments] = STATE(482),
    [sym_type_parameters] = STATE(3670),
    [aux_sym_program_repeat1] = STATE(20),
    [aux_sym_export_statement_repeat1] = STATE(2947),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_type] = ACTIONS(13),
    [anon_sym_namespace] = ACTIONS(15),
    [anon_sym_LBRACE] = ACTIONS(17),
    [anon_sym_RBRACE] = ACTIONS(483),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_for] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_await] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(41),
    [anon_sym_do] = ACTIONS(43),
    [anon_sym_try] = ACTIONS(45),
    [anon_sym_with] = ACTIONS(47),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_debugger] = ACTIONS(53),
    [anon_sym_return] = ACTIONS(55),
    [anon_sym_throw] = ACTIONS(57),
    [anon_sym_SEMI] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(69),
    [anon_sym_async] = ACTIONS(71),
    [anon_sym_function] = ACTIONS(73),
    [anon_sym_new] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_void] = ACTIONS(19),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(77),
    [anon_sym_DASH_DASH] = ACTIONS(77),
    [anon_sym_DQUOTE] = ACTIONS(79),
    [anon_sym_SQUOTE] = ACTIONS(81),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(83),
    [sym_number] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(93),
    [anon_sym_readonly] = ACTIONS(93),
    [anon_sym_get] = ACTIONS(93),
    [anon_sym_set] = ACTIONS(93),
    [anon_sym_declare] = ACTIONS(95),
    [anon_sym_public] = ACTIONS(93),
    [anon_sym_private] = ACTIONS(93),
    [anon_sym_protected] = ACTIONS(93),
    [anon_sym_override] = ACTIONS(93),
    [anon_sym_module] = ACTIONS(97),
    [anon_sym_any] = ACTIONS(93),
    [anon_sym_number] = ACTIONS(93),
    [anon_sym_boolean] = ACTIONS(93),
    [anon_sym_string] = ACTIONS(93),
    [anon_sym_symbol] = ACTIONS(93),
    [anon_sym_abstract] = ACTIONS(99),
    [anon_sym_interface] = ACTIONS(101),
    [anon_sym_enum] = ACTIONS(103),
  },
  [19] = {
    [sym_export_statement] = STATE(16),
    [sym_declaration] = STATE(16),
    [sym_import] = STATE(1844),
    [sym_import_statement] = STATE(16),
    [sym_expression_statement] = STATE(16),
    [sym_variable_declaration] = STATE(741),
    [sym_lexical_declaration] = STATE(741),
    [sym_statement_block] = STATE(16),
    [sym_if_statement] = STATE(16),
    [sym_switch_statement] = STATE(16),
    [sym_for_statement] = STATE(16),
    [sym_for_in_statement] = STATE(16),
    [sym_while_statement] = STATE(16),
    [sym_do_statement] = STATE(16),
    [sym_try_statement] = STATE(16),
    [sym_with_statement] = STATE(16),
    [sym_break_statement] = STATE(16),
    [sym_continue_statement] = STATE(16),
    [sym_debugger_statement] = STATE(16),
    [sym_return_statement] = STATE(16),
    [sym_throw_statement] = STATE(16),
    [sym_empty_statement] = STATE(16),
    [sym_labeled_statement] = STATE(16),
    [sym_parenthesized_expression] = STATE(1116),
    [sym_expression] = STATE(1697),
    [sym_primary_expression] = STATE(1799),
    [sym_yield_expression] = STATE(1798),
    [sym_object] = STATE(1844),
    [sym_object_pattern] = STATE(4170),
    [sym_array] = STATE(1844),
    [sym_array_pattern] = STATE(4170),
    [sym_class] = STATE(1844),
    [sym_class_declaration] = STATE(741),
    [sym_function] = STATE(1844),
    [sym_function_declaration] = STATE(741),
    [sym_generator_function] = STATE(1844),
    [sym_generator_function_declaration] = STATE(741),
    [sym_arrow_function] = STATE(1844),
    [sym__call_signature] = STATE(4172),
    [sym_call_expression] = STATE(1844),
    [sym_new_expression] = STATE(1798),
    [sym_await_expression] = STATE(1798),
    [sym_member_expression] = STATE(1116),
    [sym_subscript_expression] = STATE(1116),
    [sym_assignment_expression] = STATE(1798),
    [sym__augmented_assignment_lhs] = STATE(2357),
    [sym_augmented_assignment_expression] = STATE(1798),
    [sym__destructuring_pattern] = STATE(4170),
    [sym_ternary_expression] = STATE(1798),
    [sym_binary_expression] = STATE(1798),
    [sym_unary_expression] = STATE(1798),
    [sym_update_expression] = STATE(1798),
    [sym_sequence_expression] = STATE(3662),
    [sym_string] = STATE(1844),
    [sym_template_string] = STATE(1844),
    [sym_regex] = STATE(1844),
    [sym_meta_property] = STATE(1844),
    [sym_decorator] = STATE(1149),
    [sym_formal_parameters] = STATE(2903),
    [sym_non_null_expression] = STATE(1116),
    [sym_function_signature] = STATE(741),
    [sym_type_assertion] = STATE(1798),
    [sym_as_expression] = STATE(1798),
    [sym_ambient_declaration] = STATE(741),
    [sym_abstract_class_declaration] = STATE(741),
    [sym_module] = STATE(741),
    [sym_internal_module] = STATE(140),
    [sym_import_alias] = STATE(741),
    [sym_interface_declaration] = STATE(741),
    [sym_enum_declaration] = STATE(741),
    [sym_type_alias_declaration] = STATE(741),
    [sym_type_arguments] = STATE(482),
    [sym_type_parameters] = STATE(3670),
    [aux_sym_program_repeat1] = STATE(16),
    [aux_sym_export_statement_repeat1] = STATE(2947),
    [ts_builtin_sym_end] = ACTIONS(481),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_type] = ACTIONS(13),
    [anon_sym_namespace] = ACTIONS(15),
    [anon_sym_LBRACE] = ACTIONS(17),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_for] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_await] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(41),
    [anon_sym_do] = ACTIONS(43),
    [anon_sym_try] = ACTIONS(45),
    [anon_sym_with] = ACTIONS(47),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_debugger] = ACTIONS(53),
    [anon_sym_return] = ACTIONS(55),
    [anon_sym_throw] = ACTIONS(57),
    [anon_sym_SEMI] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(69),
    [anon_sym_async] = ACTIONS(71),
    [anon_sym_function] = ACTIONS(73),
    [anon_sym_new] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_void] = ACTIONS(19),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(77),
    [anon_sym_DASH_DASH] = ACTIONS(77),
    [anon_sym_DQUOTE] = ACTIONS(79),
    [anon_sym_SQUOTE] = ACTIONS(81),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(83),
    [sym_number] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(93),
    [anon_sym_readonly] = ACTIONS(93),
    [anon_sym_get] = ACTIONS(93),
    [anon_sym_set] = ACTIONS(93),
    [anon_sym_declare] = ACTIONS(95),
    [anon_sym_public] = ACTIONS(93),
    [anon_sym_private] = ACTIONS(93),
    [anon_sym_protected] = ACTIONS(93),
    [anon_sym_override] = ACTIONS(93),
    [anon_sym_module] = ACTIONS(97),
    [anon_sym_any] = ACTIONS(93),
    [anon_sym_number] = ACTIONS(93),
    [anon_sym_boolean] = ACTIONS(93),
    [anon_sym_string] = ACTIONS(93),
    [anon_sym_symbol] = ACTIONS(93),
    [anon_sym_abstract] = ACTIONS(99),
    [anon_sym_interface] = ACTIONS(101),
    [anon_sym_enum] = ACTIONS(103),
  },
  [20] = {
    [sym_export_statement] = STATE(9),
    [sym_declaration] = STATE(9),
    [sym_import] = STATE(1844),
    [sym_import_statement] = STATE(9),
    [sym_expression_statement] = STATE(9),
    [sym_variable_declaration] = STATE(741),
    [sym_lexical_declaration] = STATE(741),
    [sym_statement_block] = STATE(9),
    [sym_if_statement] = STATE(9),
    [sym_switch_statement] = STATE(9),
    [sym_for_statement] = STATE(9),
    [sym_for_in_statement] = STATE(9),
    [sym_while_statement] = STATE(9),
    [sym_do_statement] = STATE(9),
    [sym_try_statement] = STATE(9),
    [sym_with_statement] = STATE(9),
    [sym_break_statement] = STATE(9),
    [sym_continue_statement] = STATE(9),
    [sym_debugger_statement] = STATE(9),
    [sym_return_statement] = STATE(9),
    [sym_throw_statement] = STATE(9),
    [sym_empty_statement] = STATE(9),
    [sym_labeled_statement] = STATE(9),
    [sym_parenthesized_expression] = STATE(1116),
    [sym_expression] = STATE(1697),
    [sym_primary_expression] = STATE(1799),
    [sym_yield_expression] = STATE(1798),
    [sym_object] = STATE(1844),
    [sym_object_pattern] = STATE(4170),
    [sym_array] = STATE(1844),
    [sym_array_pattern] = STATE(4170),
    [sym_class] = STATE(1844),
    [sym_class_declaration] = STATE(741),
    [sym_function] = STATE(1844),
    [sym_function_declaration] = STATE(741),
    [sym_generator_function] = STATE(1844),
    [sym_generator_function_declaration] = STATE(741),
    [sym_arrow_function] = STATE(1844),
    [sym__call_signature] = STATE(4172),
    [sym_call_expression] = STATE(1844),
    [sym_new_expression] = STATE(1798),
    [sym_await_expression] = STATE(1798),
    [sym_member_expression] = STATE(1116),
    [sym_subscript_expression] = STATE(1116),
    [sym_assignment_expression] = STATE(1798),
    [sym__augmented_assignment_lhs] = STATE(2357),
    [sym_augmented_assignment_expression] = STATE(1798),
    [sym__destructuring_pattern] = STATE(4170),
    [sym_ternary_expression] = STATE(1798),
    [sym_binary_expression] = STATE(1798),
    [sym_unary_expression] = STATE(1798),
    [sym_update_expression] = STATE(1798),
    [sym_sequence_expression] = STATE(3662),
    [sym_string] = STATE(1844),
    [sym_template_string] = STATE(1844),
    [sym_regex] = STATE(1844),
    [sym_meta_property] = STATE(1844),
    [sym_decorator] = STATE(1149),
    [sym_formal_parameters] = STATE(2903),
    [sym_non_null_expression] = STATE(1116),
    [sym_function_signature] = STATE(741),
    [sym_type_assertion] = STATE(1798),
    [sym_as_expression] = STATE(1798),
    [sym_ambient_declaration] = STATE(741),
    [sym_abstract_class_declaration] = STATE(741),
    [sym_module] = STATE(741),
    [sym_internal_module] = STATE(140),
    [sym_import_alias] = STATE(741),
    [sym_interface_declaration] = STATE(741),
    [sym_enum_declaration] = STATE(741),
    [sym_type_alias_declaration] = STATE(741),
    [sym_type_arguments] = STATE(482),
    [sym_type_parameters] = STATE(3670),
    [aux_sym_program_repeat1] = STATE(9),
    [aux_sym_export_statement_repeat1] = STATE(2947),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_type] = ACTIONS(13),
    [anon_sym_namespace] = ACTIONS(15),
    [anon_sym_LBRACE] = ACTIONS(17),
    [anon_sym_RBRACE] = ACTIONS(485),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_for] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_await] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(41),
    [anon_sym_do] = ACTIONS(43),
    [anon_sym_try] = ACTIONS(45),
    [anon_sym_with] = ACTIONS(47),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_debugger] = ACTIONS(53),
    [anon_sym_return] = ACTIONS(55),
    [anon_sym_throw] = ACTIONS(57),
    [anon_sym_SEMI] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(69),
    [anon_sym_async] = ACTIONS(71),
    [anon_sym_function] = ACTIONS(73),
    [anon_sym_new] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_void] = ACTIONS(19),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(77),
    [anon_sym_DASH_DASH] = ACTIONS(77),
    [anon_sym_DQUOTE] = ACTIONS(79),
    [anon_sym_SQUOTE] = ACTIONS(81),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(83),
    [sym_number] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(93),
    [anon_sym_readonly] = ACTIONS(93),
    [anon_sym_get] = ACTIONS(93),
    [anon_sym_set] = ACTIONS(93),
    [anon_sym_declare] = ACTIONS(95),
    [anon_sym_public] = ACTIONS(93),
    [anon_sym_private] = ACTIONS(93),
    [anon_sym_protected] = ACTIONS(93),
    [anon_sym_override] = ACTIONS(93),
    [anon_sym_module] = ACTIONS(97),
    [anon_sym_any] = ACTIONS(93),
    [anon_sym_number] = ACTIONS(93),
    [anon_sym_boolean] = ACTIONS(93),
    [anon_sym_string] = ACTIONS(93),
    [anon_sym_symbol] = ACTIONS(93),
    [anon_sym_abstract] = ACTIONS(99),
    [anon_sym_interface] = ACTIONS(101),
    [anon_sym_enum] = ACTIONS(103),
  },
  [21] = {
    [sym_export_statement] = STATE(15),
    [sym_declaration] = STATE(15),
    [sym_import] = STATE(1844),
    [sym_import_statement] = STATE(15),
    [sym_expression_statement] = STATE(15),
    [sym_variable_declaration] = STATE(741),
    [sym_lexical_declaration] = STATE(741),
    [sym_statement_block] = STATE(15),
    [sym_if_statement] = STATE(15),
    [sym_switch_statement] = STATE(15),
    [sym_for_statement] = STATE(15),
    [sym_for_in_statement] = STATE(15),
    [sym_while_statement] = STATE(15),
    [sym_do_statement] = STATE(15),
    [sym_try_statement] = STATE(15),
    [sym_with_statement] = STATE(15),
    [sym_break_statement] = STATE(15),
    [sym_continue_statement] = STATE(15),
    [sym_debugger_statement] = STATE(15),
    [sym_return_statement] = STATE(15),
    [sym_throw_statement] = STATE(15),
    [sym_empty_statement] = STATE(15),
    [sym_labeled_statement] = STATE(15),
    [sym_parenthesized_expression] = STATE(1116),
    [sym_expression] = STATE(1697),
    [sym_primary_expression] = STATE(1799),
    [sym_yield_expression] = STATE(1798),
    [sym_object] = STATE(1844),
    [sym_object_pattern] = STATE(4170),
    [sym_array] = STATE(1844),
    [sym_array_pattern] = STATE(4170),
    [sym_class] = STATE(1844),
    [sym_class_declaration] = STATE(741),
    [sym_function] = STATE(1844),
    [sym_function_declaration] = STATE(741),
    [sym_generator_function] = STATE(1844),
    [sym_generator_function_declaration] = STATE(741),
    [sym_arrow_function] = STATE(1844),
    [sym__call_signature] = STATE(4172),
    [sym_call_expression] = STATE(1844),
    [sym_new_expression] = STATE(1798),
    [sym_await_expression] = STATE(1798),
    [sym_member_expression] = STATE(1116),
    [sym_subscript_expression] = STATE(1116),
    [sym_assignment_expression] = STATE(1798),
    [sym__augmented_assignment_lhs] = STATE(2357),
    [sym_augmented_assignment_expression] = STATE(1798),
    [sym__destructuring_pattern] = STATE(4170),
    [sym_ternary_expression] = STATE(1798),
    [sym_binary_expression] = STATE(1798),
    [sym_unary_expression] = STATE(1798),
    [sym_update_expression] = STATE(1798),
    [sym_sequence_expression] = STATE(3662),
    [sym_string] = STATE(1844),
    [sym_template_string] = STATE(1844),
    [sym_regex] = STATE(1844),
    [sym_meta_property] = STATE(1844),
    [sym_decorator] = STATE(1149),
    [sym_formal_parameters] = STATE(2903),
    [sym_non_null_expression] = STATE(1116),
    [sym_function_signature] = STATE(741),
    [sym_type_assertion] = STATE(1798),
    [sym_as_expression] = STATE(1798),
    [sym_ambient_declaration] = STATE(741),
    [sym_abstract_class_declaration] = STATE(741),
    [sym_module] = STATE(741),
    [sym_internal_module] = STATE(140),
    [sym_import_alias] = STATE(741),
    [sym_interface_declaration] = STATE(741),
    [sym_enum_declaration] = STATE(741),
    [sym_type_alias_declaration] = STATE(741),
    [sym_type_arguments] = STATE(482),
    [sym_type_parameters] = STATE(3670),
    [aux_sym_program_repeat1] = STATE(15),
    [aux_sym_export_statement_repeat1] = STATE(2947),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_type] = ACTIONS(13),
    [anon_sym_namespace] = ACTIONS(15),
    [anon_sym_LBRACE] = ACTIONS(17),
    [anon_sym_RBRACE] = ACTIONS(487),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_for] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_await] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(41),
    [anon_sym_do] = ACTIONS(43),
    [anon_sym_try] = ACTIONS(45),
    [anon_sym_with] = ACTIONS(47),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_debugger] = ACTIONS(53),
    [anon_sym_return] = ACTIONS(55),
    [anon_sym_throw] = ACTIONS(57),
    [anon_sym_SEMI] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(69),
    [anon_sym_async] = ACTIONS(71),
    [anon_sym_function] = ACTIONS(73),
    [anon_sym_new] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_void] = ACTIONS(19),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(77),
    [anon_sym_DASH_DASH] = ACTIONS(77),
    [anon_sym_DQUOTE] = ACTIONS(79),
    [anon_sym_SQUOTE] = ACTIONS(81),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(83),
    [sym_number] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(93),
    [anon_sym_readonly] = ACTIONS(93),
    [anon_sym_get] = ACTIONS(93),
    [anon_sym_set] = ACTIONS(93),
    [anon_sym_declare] = ACTIONS(95),
    [anon_sym_public] = ACTIONS(93),
    [anon_sym_private] = ACTIONS(93),
    [anon_sym_protected] = ACTIONS(93),
    [anon_sym_override] = ACTIONS(93),
    [anon_sym_module] = ACTIONS(97),
    [anon_sym_any] = ACTIONS(93),
    [anon_sym_number] = ACTIONS(93),
    [anon_sym_boolean] = ACTIONS(93),
    [anon_sym_string] = ACTIONS(93),
    [anon_sym_symbol] = ACTIONS(93),
    [anon_sym_abstract] = ACTIONS(99),
    [anon_sym_interface] = ACTIONS(101),
    [anon_sym_enum] = ACTIONS(103),
  },
  [22] = {
    [sym_export_statement] = STATE(25),
    [sym_declaration] = STATE(25),
    [sym_import] = STATE(1844),
    [sym_import_statement] = STATE(25),
    [sym_expression_statement] = STATE(25),
    [sym_variable_declaration] = STATE(741),
    [sym_lexical_declaration] = STATE(741),
    [sym_statement_block] = STATE(25),
    [sym_if_statement] = STATE(25),
    [sym_switch_statement] = STATE(25),
    [sym_for_statement] = STATE(25),
    [sym_for_in_statement] = STATE(25),
    [sym_while_statement] = STATE(25),
    [sym_do_statement] = STATE(25),
    [sym_try_statement] = STATE(25),
    [sym_with_statement] = STATE(25),
    [sym_break_statement] = STATE(25),
    [sym_continue_statement] = STATE(25),
    [sym_debugger_statement] = STATE(25),
    [sym_return_statement] = STATE(25),
    [sym_throw_statement] = STATE(25),
    [sym_empty_statement] = STATE(25),
    [sym_labeled_statement] = STATE(25),
    [sym_parenthesized_expression] = STATE(1116),
    [sym_expression] = STATE(1697),
    [sym_primary_expression] = STATE(1799),
    [sym_yield_expression] = STATE(1798),
    [sym_object] = STATE(1844),
    [sym_object_pattern] = STATE(4170),
    [sym_array] = STATE(1844),
    [sym_array_pattern] = STATE(4170),
    [sym_class] = STATE(1844),
    [sym_class_declaration] = STATE(741),
    [sym_function] = STATE(1844),
    [sym_function_declaration] = STATE(741),
    [sym_generator_function] = STATE(1844),
    [sym_generator_function_declaration] = STATE(741),
    [sym_arrow_function] = STATE(1844),
    [sym__call_signature] = STATE(4172),
    [sym_call_expression] = STATE(1844),
    [sym_new_expression] = STATE(1798),
    [sym_await_expression] = STATE(1798),
    [sym_member_expression] = STATE(1116),
    [sym_subscript_expression] = STATE(1116),
    [sym_assignment_expression] = STATE(1798),
    [sym__augmented_assignment_lhs] = STATE(2357),
    [sym_augmented_assignment_expression] = STATE(1798),
    [sym__destructuring_pattern] = STATE(4170),
    [sym_ternary_expression] = STATE(1798),
    [sym_binary_expression] = STATE(1798),
    [sym_unary_expression] = STATE(1798),
    [sym_update_expression] = STATE(1798),
    [sym_sequence_expression] = STATE(3662),
    [sym_string] = STATE(1844),
    [sym_template_string] = STATE(1844),
    [sym_regex] = STATE(1844),
    [sym_meta_property] = STATE(1844),
    [sym_decorator] = STATE(1149),
    [sym_formal_parameters] = STATE(2903),
    [sym_non_null_expression] = STATE(1116),
    [sym_function_signature] = STATE(741),
    [sym_type_assertion] = STATE(1798),
    [sym_as_expression] = STATE(1798),
    [sym_ambient_declaration] = STATE(741),
    [sym_abstract_class_declaration] = STATE(741),
    [sym_module] = STATE(741),
    [sym_internal_module] = STATE(140),
    [sym_import_alias] = STATE(741),
    [sym_interface_declaration] = STATE(741),
    [sym_enum_declaration] = STATE(741),
    [sym_type_alias_declaration] = STATE(741),
    [sym_type_arguments] = STATE(482),
    [sym_type_parameters] = STATE(3670),
    [aux_sym_program_repeat1] = STATE(25),
    [aux_sym_export_statement_repeat1] = STATE(2947),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_type] = ACTIONS(13),
    [anon_sym_namespace] = ACTIONS(15),
    [anon_sym_LBRACE] = ACTIONS(17),
    [anon_sym_RBRACE] = ACTIONS(489),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_for] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_await] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(41),
    [anon_sym_do] = ACTIONS(43),
    [anon_sym_try] = ACTIONS(45),
    [anon_sym_with] = ACTIONS(47),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_debugger] = ACTIONS(53),
    [anon_sym_return] = ACTIONS(55),
    [anon_sym_throw] = ACTIONS(57),
    [anon_sym_SEMI] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(69),
    [anon_sym_async] = ACTIONS(71),
    [anon_sym_function] = ACTIONS(73),
    [anon_sym_new] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_void] = ACTIONS(19),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(77),
    [anon_sym_DASH_DASH] = ACTIONS(77),
    [anon_sym_DQUOTE] = ACTIONS(79),
    [anon_sym_SQUOTE] = ACTIONS(81),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(83),
    [sym_number] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(93),
    [anon_sym_readonly] = ACTIONS(93),
    [anon_sym_get] = ACTIONS(93),
    [anon_sym_set] = ACTIONS(93),
    [anon_sym_declare] = ACTIONS(95),
    [anon_sym_public] = ACTIONS(93),
    [anon_sym_private] = ACTIONS(93),
    [anon_sym_protected] = ACTIONS(93),
    [anon_sym_override] = ACTIONS(93),
    [anon_sym_module] = ACTIONS(97),
    [anon_sym_any] = ACTIONS(93),
    [anon_sym_number] = ACTIONS(93),
    [anon_sym_boolean] = ACTIONS(93),
    [anon_sym_string] = ACTIONS(93),
    [anon_sym_symbol] = ACTIONS(93),
    [anon_sym_abstract] = ACTIONS(99),
    [anon_sym_interface] = ACTIONS(101),
    [anon_sym_enum] = ACTIONS(103),
  },
  [23] = {
    [sym_export_statement] = STATE(9),
    [sym_declaration] = STATE(9),
    [sym_import] = STATE(1844),
    [sym_import_statement] = STATE(9),
    [sym_expression_statement] = STATE(9),
    [sym_variable_declaration] = STATE(741),
    [sym_lexical_declaration] = STATE(741),
    [sym_statement_block] = STATE(9),
    [sym_if_statement] = STATE(9),
    [sym_switch_statement] = STATE(9),
    [sym_for_statement] = STATE(9),
    [sym_for_in_statement] = STATE(9),
    [sym_while_statement] = STATE(9),
    [sym_do_statement] = STATE(9),
    [sym_try_statement] = STATE(9),
    [sym_with_statement] = STATE(9),
    [sym_break_statement] = STATE(9),
    [sym_continue_statement] = STATE(9),
    [sym_debugger_statement] = STATE(9),
    [sym_return_statement] = STATE(9),
    [sym_throw_statement] = STATE(9),
    [sym_empty_statement] = STATE(9),
    [sym_labeled_statement] = STATE(9),
    [sym_parenthesized_expression] = STATE(1116),
    [sym_expression] = STATE(1697),
    [sym_primary_expression] = STATE(1799),
    [sym_yield_expression] = STATE(1798),
    [sym_object] = STATE(1844),
    [sym_object_pattern] = STATE(4170),
    [sym_array] = STATE(1844),
    [sym_array_pattern] = STATE(4170),
    [sym_class] = STATE(1844),
    [sym_class_declaration] = STATE(741),
    [sym_function] = STATE(1844),
    [sym_function_declaration] = STATE(741),
    [sym_generator_function] = STATE(1844),
    [sym_generator_function_declaration] = STATE(741),
    [sym_arrow_function] = STATE(1844),
    [sym__call_signature] = STATE(4172),
    [sym_call_expression] = STATE(1844),
    [sym_new_expression] = STATE(1798),
    [sym_await_expression] = STATE(1798),
    [sym_member_expression] = STATE(1116),
    [sym_subscript_expression] = STATE(1116),
    [sym_assignment_expression] = STATE(1798),
    [sym__augmented_assignment_lhs] = STATE(2357),
    [sym_augmented_assignment_expression] = STATE(1798),
    [sym__destructuring_pattern] = STATE(4170),
    [sym_ternary_expression] = STATE(1798),
    [sym_binary_expression] = STATE(1798),
    [sym_unary_expression] = STATE(1798),
    [sym_update_expression] = STATE(1798),
    [sym_sequence_expression] = STATE(3662),
    [sym_string] = STATE(1844),
    [sym_template_string] = STATE(1844),
    [sym_regex] = STATE(1844),
    [sym_meta_property] = STATE(1844),
    [sym_decorator] = STATE(1149),
    [sym_formal_parameters] = STATE(2903),
    [sym_non_null_expression] = STATE(1116),
    [sym_function_signature] = STATE(741),
    [sym_type_assertion] = STATE(1798),
    [sym_as_expression] = STATE(1798),
    [sym_ambient_declaration] = STATE(741),
    [sym_abstract_class_declaration] = STATE(741),
    [sym_module] = STATE(741),
    [sym_internal_module] = STATE(140),
    [sym_import_alias] = STATE(741),
    [sym_interface_declaration] = STATE(741),
    [sym_enum_declaration] = STATE(741),
    [sym_type_alias_declaration] = STATE(741),
    [sym_type_arguments] = STATE(482),
    [sym_type_parameters] = STATE(3670),
    [aux_sym_program_repeat1] = STATE(9),
    [aux_sym_export_statement_repeat1] = STATE(2947),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_type] = ACTIONS(13),
    [anon_sym_namespace] = ACTIONS(15),
    [anon_sym_LBRACE] = ACTIONS(17),
    [anon_sym_RBRACE] = ACTIONS(491),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_for] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_await] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(41),
    [anon_sym_do] = ACTIONS(43),
    [anon_sym_try] = ACTIONS(45),
    [anon_sym_with] = ACTIONS(47),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_debugger] = ACTIONS(53),
    [anon_sym_return] = ACTIONS(55),
    [anon_sym_throw] = ACTIONS(57),
    [anon_sym_SEMI] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(69),
    [anon_sym_async] = ACTIONS(71),
    [anon_sym_function] = ACTIONS(73),
    [anon_sym_new] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_void] = ACTIONS(19),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(77),
    [anon_sym_DASH_DASH] = ACTIONS(77),
    [anon_sym_DQUOTE] = ACTIONS(79),
    [anon_sym_SQUOTE] = ACTIONS(81),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(83),
    [sym_number] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(93),
    [anon_sym_readonly] = ACTIONS(93),
    [anon_sym_get] = ACTIONS(93),
    [anon_sym_set] = ACTIONS(93),
    [anon_sym_declare] = ACTIONS(95),
    [anon_sym_public] = ACTIONS(93),
    [anon_sym_private] = ACTIONS(93),
    [anon_sym_protected] = ACTIONS(93),
    [anon_sym_override] = ACTIONS(93),
    [anon_sym_module] = ACTIONS(97),
    [anon_sym_any] = ACTIONS(93),
    [anon_sym_number] = ACTIONS(93),
    [anon_sym_boolean] = ACTIONS(93),
    [anon_sym_string] = ACTIONS(93),
    [anon_sym_symbol] = ACTIONS(93),
    [anon_sym_abstract] = ACTIONS(99),
    [anon_sym_interface] = ACTIONS(101),
    [anon_sym_enum] = ACTIONS(103),
  },
  [24] = {
    [sym_export_statement] = STATE(23),
    [sym_declaration] = STATE(23),
    [sym_import] = STATE(1844),
    [sym_import_statement] = STATE(23),
    [sym_expression_statement] = STATE(23),
    [sym_variable_declaration] = STATE(741),
    [sym_lexical_declaration] = STATE(741),
    [sym_statement_block] = STATE(23),
    [sym_if_statement] = STATE(23),
    [sym_switch_statement] = STATE(23),
    [sym_for_statement] = STATE(23),
    [sym_for_in_statement] = STATE(23),
    [sym_while_statement] = STATE(23),
    [sym_do_statement] = STATE(23),
    [sym_try_statement] = STATE(23),
    [sym_with_statement] = STATE(23),
    [sym_break_statement] = STATE(23),
    [sym_continue_statement] = STATE(23),
    [sym_debugger_statement] = STATE(23),
    [sym_return_statement] = STATE(23),
    [sym_throw_statement] = STATE(23),
    [sym_empty_statement] = STATE(23),
    [sym_labeled_statement] = STATE(23),
    [sym_parenthesized_expression] = STATE(1116),
    [sym_expression] = STATE(1697),
    [sym_primary_expression] = STATE(1799),
    [sym_yield_expression] = STATE(1798),
    [sym_object] = STATE(1844),
    [sym_object_pattern] = STATE(4170),
    [sym_array] = STATE(1844),
    [sym_array_pattern] = STATE(4170),
    [sym_class] = STATE(1844),
    [sym_class_declaration] = STATE(741),
    [sym_function] = STATE(1844),
    [sym_function_declaration] = STATE(741),
    [sym_generator_function] = STATE(1844),
    [sym_generator_function_declaration] = STATE(741),
    [sym_arrow_function] = STATE(1844),
    [sym__call_signature] = STATE(4172),
    [sym_call_expression] = STATE(1844),
    [sym_new_expression] = STATE(1798),
    [sym_await_expression] = STATE(1798),
    [sym_member_expression] = STATE(1116),
    [sym_subscript_expression] = STATE(1116),
    [sym_assignment_expression] = STATE(1798),
    [sym__augmented_assignment_lhs] = STATE(2357),
    [sym_augmented_assignment_expression] = STATE(1798),
    [sym__destructuring_pattern] = STATE(4170),
    [sym_ternary_expression] = STATE(1798),
    [sym_binary_expression] = STATE(1798),
    [sym_unary_expression] = STATE(1798),
    [sym_update_expression] = STATE(1798),
    [sym_sequence_expression] = STATE(3662),
    [sym_string] = STATE(1844),
    [sym_template_string] = STATE(1844),
    [sym_regex] = STATE(1844),
    [sym_meta_property] = STATE(1844),
    [sym_decorator] = STATE(1149),
    [sym_formal_parameters] = STATE(2903),
    [sym_non_null_expression] = STATE(1116),
    [sym_function_signature] = STATE(741),
    [sym_type_assertion] = STATE(1798),
    [sym_as_expression] = STATE(1798),
    [sym_ambient_declaration] = STATE(741),
    [sym_abstract_class_declaration] = STATE(741),
    [sym_module] = STATE(741),
    [sym_internal_module] = STATE(140),
    [sym_import_alias] = STATE(741),
    [sym_interface_declaration] = STATE(741),
    [sym_enum_declaration] = STATE(741),
    [sym_type_alias_declaration] = STATE(741),
    [sym_type_arguments] = STATE(482),
    [sym_type_parameters] = STATE(3670),
    [aux_sym_program_repeat1] = STATE(23),
    [aux_sym_export_statement_repeat1] = STATE(2947),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_type] = ACTIONS(13),
    [anon_sym_namespace] = ACTIONS(15),
    [anon_sym_LBRACE] = ACTIONS(17),
    [anon_sym_RBRACE] = ACTIONS(493),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_for] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_await] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(41),
    [anon_sym_do] = ACTIONS(43),
    [anon_sym_try] = ACTIONS(45),
    [anon_sym_with] = ACTIONS(47),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_debugger] = ACTIONS(53),
    [anon_sym_return] = ACTIONS(55),
    [anon_sym_throw] = ACTIONS(57),
    [anon_sym_SEMI] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(69),
    [anon_sym_async] = ACTIONS(71),
    [anon_sym_function] = ACTIONS(73),
    [anon_sym_new] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_void] = ACTIONS(19),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(77),
    [anon_sym_DASH_DASH] = ACTIONS(77),
    [anon_sym_DQUOTE] = ACTIONS(79),
    [anon_sym_SQUOTE] = ACTIONS(81),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(83),
    [sym_number] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(93),
    [anon_sym_readonly] = ACTIONS(93),
    [anon_sym_get] = ACTIONS(93),
    [anon_sym_set] = ACTIONS(93),
    [anon_sym_declare] = ACTIONS(95),
    [anon_sym_public] = ACTIONS(93),
    [anon_sym_private] = ACTIONS(93),
    [anon_sym_protected] = ACTIONS(93),
    [anon_sym_override] = ACTIONS(93),
    [anon_sym_module] = ACTIONS(97),
    [anon_sym_any] = ACTIONS(93),
    [anon_sym_number] = ACTIONS(93),
    [anon_sym_boolean] = ACTIONS(93),
    [anon_sym_string] = ACTIONS(93),
    [anon_sym_symbol] = ACTIONS(93),
    [anon_sym_abstract] = ACTIONS(99),
    [anon_sym_interface] = ACTIONS(101),
    [anon_sym_enum] = ACTIONS(103),
  },
  [25] = {
    [sym_export_statement] = STATE(9),
    [sym_declaration] = STATE(9),
    [sym_import] = STATE(1844),
    [sym_import_statement] = STATE(9),
    [sym_expression_statement] = STATE(9),
    [sym_variable_declaration] = STATE(741),
    [sym_lexical_declaration] = STATE(741),
    [sym_statement_block] = STATE(9),
    [sym_if_statement] = STATE(9),
    [sym_switch_statement] = STATE(9),
    [sym_for_statement] = STATE(9),
    [sym_for_in_statement] = STATE(9),
    [sym_while_statement] = STATE(9),
    [sym_do_statement] = STATE(9),
    [sym_try_statement] = STATE(9),
    [sym_with_statement] = STATE(9),
    [sym_break_statement] = STATE(9),
    [sym_continue_statement] = STATE(9),
    [sym_debugger_statement] = STATE(9),
    [sym_return_statement] = STATE(9),
    [sym_throw_statement] = STATE(9),
    [sym_empty_statement] = STATE(9),
    [sym_labeled_statement] = STATE(9),
    [sym_parenthesized_expression] = STATE(1116),
    [sym_expression] = STATE(1697),
    [sym_primary_expression] = STATE(1799),
    [sym_yield_expression] = STATE(1798),
    [sym_object] = STATE(1844),
    [sym_object_pattern] = STATE(4170),
    [sym_array] = STATE(1844),
    [sym_array_pattern] = STATE(4170),
    [sym_class] = STATE(1844),
    [sym_class_declaration] = STATE(741),
    [sym_function] = STATE(1844),
    [sym_function_declaration] = STATE(741),
    [sym_generator_function] = STATE(1844),
    [sym_generator_function_declaration] = STATE(741),
    [sym_arrow_function] = STATE(1844),
    [sym__call_signature] = STATE(4172),
    [sym_call_expression] = STATE(1844),
    [sym_new_expression] = STATE(1798),
    [sym_await_expression] = STATE(1798),
    [sym_member_expression] = STATE(1116),
    [sym_subscript_expression] = STATE(1116),
    [sym_assignment_expression] = STATE(1798),
    [sym__augmented_assignment_lhs] = STATE(2357),
    [sym_augmented_assignment_expression] = STATE(1798),
    [sym__destructuring_pattern] = STATE(4170),
    [sym_ternary_expression] = STATE(1798),
    [sym_binary_expression] = STATE(1798),
    [sym_unary_expression] = STATE(1798),
    [sym_update_expression] = STATE(1798),
    [sym_sequence_expression] = STATE(3662),
    [sym_string] = STATE(1844),
    [sym_template_string] = STATE(1844),
    [sym_regex] = STATE(1844),
    [sym_meta_property] = STATE(1844),
    [sym_decorator] = STATE(1149),
    [sym_formal_parameters] = STATE(2903),
    [sym_non_null_expression] = STATE(1116),
    [sym_function_signature] = STATE(741),
    [sym_type_assertion] = STATE(1798),
    [sym_as_expression] = STATE(1798),
    [sym_ambient_declaration] = STATE(741),
    [sym_abstract_class_declaration] = STATE(741),
    [sym_module] = STATE(741),
    [sym_internal_module] = STATE(140),
    [sym_import_alias] = STATE(741),
    [sym_interface_declaration] = STATE(741),
    [sym_enum_declaration] = STATE(741),
    [sym_type_alias_declaration] = STATE(741),
    [sym_type_arguments] = STATE(482),
    [sym_type_parameters] = STATE(3670),
    [aux_sym_program_repeat1] = STATE(9),
    [aux_sym_export_statement_repeat1] = STATE(2947),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_type] = ACTIONS(13),
    [anon_sym_namespace] = ACTIONS(15),
    [anon_sym_LBRACE] = ACTIONS(17),
    [anon_sym_RBRACE] = ACTIONS(495),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_for] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_await] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(41),
    [anon_sym_do] = ACTIONS(43),
    [anon_sym_try] = ACTIONS(45),
    [anon_sym_with] = ACTIONS(47),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_debugger] = ACTIONS(53),
    [anon_sym_return] = ACTIONS(55),
    [anon_sym_throw] = ACTIONS(57),
    [anon_sym_SEMI] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(69),
    [anon_sym_async] = ACTIONS(71),
    [anon_sym_function] = ACTIONS(73),
    [anon_sym_new] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_void] = ACTIONS(19),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(77),
    [anon_sym_DASH_DASH] = ACTIONS(77),
    [anon_sym_DQUOTE] = ACTIONS(79),
    [anon_sym_SQUOTE] = ACTIONS(81),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(83),
    [sym_number] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(93),
    [anon_sym_readonly] = ACTIONS(93),
    [anon_sym_get] = ACTIONS(93),
    [anon_sym_set] = ACTIONS(93),
    [anon_sym_declare] = ACTIONS(95),
    [anon_sym_public] = ACTIONS(93),
    [anon_sym_private] = ACTIONS(93),
    [anon_sym_protected] = ACTIONS(93),
    [anon_sym_override] = ACTIONS(93),
    [anon_sym_module] = ACTIONS(97),
    [anon_sym_any] = ACTIONS(93),
    [anon_sym_number] = ACTIONS(93),
    [anon_sym_boolean] = ACTIONS(93),
    [anon_sym_string] = ACTIONS(93),
    [anon_sym_symbol] = ACTIONS(93),
    [anon_sym_abstract] = ACTIONS(99),
    [anon_sym_interface] = ACTIONS(101),
    [anon_sym_enum] = ACTIONS(103),
  },
  [26] = {
    [sym_export_statement] = STATE(14),
    [sym_declaration] = STATE(14),
    [sym_import] = STATE(1844),
    [sym_import_statement] = STATE(14),
    [sym_expression_statement] = STATE(14),
    [sym_variable_declaration] = STATE(741),
    [sym_lexical_declaration] = STATE(741),
    [sym_statement_block] = STATE(14),
    [sym_if_statement] = STATE(14),
    [sym_switch_statement] = STATE(14),
    [sym_for_statement] = STATE(14),
    [sym_for_in_statement] = STATE(14),
    [sym_while_statement] = STATE(14),
    [sym_do_statement] = STATE(14),
    [sym_try_statement] = STATE(14),
    [sym_with_statement] = STATE(14),
    [sym_break_statement] = STATE(14),
    [sym_continue_statement] = STATE(14),
    [sym_debugger_statement] = STATE(14),
    [sym_return_statement] = STATE(14),
    [sym_throw_statement] = STATE(14),
    [sym_empty_statement] = STATE(14),
    [sym_labeled_statement] = STATE(14),
    [sym_parenthesized_expression] = STATE(1116),
    [sym_expression] = STATE(1697),
    [sym_primary_expression] = STATE(1799),
    [sym_yield_expression] = STATE(1798),
    [sym_object] = STATE(1844),
    [sym_object_pattern] = STATE(4170),
    [sym_array] = STATE(1844),
    [sym_array_pattern] = STATE(4170),
    [sym_class] = STATE(1844),
    [sym_class_declaration] = STATE(741),
    [sym_function] = STATE(1844),
    [sym_function_declaration] = STATE(741),
    [sym_generator_function] = STATE(1844),
    [sym_generator_function_declaration] = STATE(741),
    [sym_arrow_function] = STATE(1844),
    [sym__call_signature] = STATE(4172),
    [sym_call_expression] = STATE(1844),
    [sym_new_expression] = STATE(1798),
    [sym_await_expression] = STATE(1798),
    [sym_member_expression] = STATE(1116),
    [sym_subscript_expression] = STATE(1116),
    [sym_assignment_expression] = STATE(1798),
    [sym__augmented_assignment_lhs] = STATE(2357),
    [sym_augmented_assignment_expression] = STATE(1798),
    [sym__destructuring_pattern] = STATE(4170),
    [sym_ternary_expression] = STATE(1798),
    [sym_binary_expression] = STATE(1798),
    [sym_unary_expression] = STATE(1798),
    [sym_update_expression] = STATE(1798),
    [sym_sequence_expression] = STATE(3662),
    [sym_string] = STATE(1844),
    [sym_template_string] = STATE(1844),
    [sym_regex] = STATE(1844),
    [sym_meta_property] = STATE(1844),
    [sym_decorator] = STATE(1149),
    [sym_formal_parameters] = STATE(2903),
    [sym_non_null_expression] = STATE(1116),
    [sym_function_signature] = STATE(741),
    [sym_type_assertion] = STATE(1798),
    [sym_as_expression] = STATE(1798),
    [sym_ambient_declaration] = STATE(741),
    [sym_abstract_class_declaration] = STATE(741),
    [sym_module] = STATE(741),
    [sym_internal_module] = STATE(140),
    [sym_import_alias] = STATE(741),
    [sym_interface_declaration] = STATE(741),
    [sym_enum_declaration] = STATE(741),
    [sym_type_alias_declaration] = STATE(741),
    [sym_type_arguments] = STATE(482),
    [sym_type_parameters] = STATE(3670),
    [aux_sym_program_repeat1] = STATE(14),
    [aux_sym_export_statement_repeat1] = STATE(2947),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_type] = ACTIONS(13),
    [anon_sym_namespace] = ACTIONS(15),
    [anon_sym_LBRACE] = ACTIONS(17),
    [anon_sym_RBRACE] = ACTIONS(497),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_for] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_await] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(41),
    [anon_sym_do] = ACTIONS(43),
    [anon_sym_try] = ACTIONS(45),
    [anon_sym_with] = ACTIONS(47),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_debugger] = ACTIONS(53),
    [anon_sym_return] = ACTIONS(55),
    [anon_sym_throw] = ACTIONS(57),
    [anon_sym_SEMI] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(69),
    [anon_sym_async] = ACTIONS(71),
    [anon_sym_function] = ACTIONS(73),
    [anon_sym_new] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_void] = ACTIONS(19),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(77),
    [anon_sym_DASH_DASH] = ACTIONS(77),
    [anon_sym_DQUOTE] = ACTIONS(79),
    [anon_sym_SQUOTE] = ACTIONS(81),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(83),
    [sym_number] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(93),
    [anon_sym_readonly] = ACTIONS(93),
    [anon_sym_get] = ACTIONS(93),
    [anon_sym_set] = ACTIONS(93),
    [anon_sym_declare] = ACTIONS(95),
    [anon_sym_public] = ACTIONS(93),
    [anon_sym_private] = ACTIONS(93),
    [anon_sym_protected] = ACTIONS(93),
    [anon_sym_override] = ACTIONS(93),
    [anon_sym_module] = ACTIONS(97),
    [anon_sym_any] = ACTIONS(93),
    [anon_sym_number] = ACTIONS(93),
    [anon_sym_boolean] = ACTIONS(93),
    [anon_sym_string] = ACTIONS(93),
    [anon_sym_symbol] = ACTIONS(93),
    [anon_sym_abstract] = ACTIONS(99),
    [anon_sym_interface] = ACTIONS(101),
    [anon_sym_enum] = ACTIONS(103),
  },
  [27] = {
    [sym_export_statement] = STATE(28),
    [sym_declaration] = STATE(28),
    [sym_import] = STATE(1844),
    [sym_import_statement] = STATE(28),
    [sym_expression_statement] = STATE(28),
    [sym_variable_declaration] = STATE(741),
    [sym_lexical_declaration] = STATE(741),
    [sym_statement_block] = STATE(28),
    [sym_if_statement] = STATE(28),
    [sym_switch_statement] = STATE(28),
    [sym_for_statement] = STATE(28),
    [sym_for_in_statement] = STATE(28),
    [sym_while_statement] = STATE(28),
    [sym_do_statement] = STATE(28),
    [sym_try_statement] = STATE(28),
    [sym_with_statement] = STATE(28),
    [sym_break_statement] = STATE(28),
    [sym_continue_statement] = STATE(28),
    [sym_debugger_statement] = STATE(28),
    [sym_return_statement] = STATE(28),
    [sym_throw_statement] = STATE(28),
    [sym_empty_statement] = STATE(28),
    [sym_labeled_statement] = STATE(28),
    [sym_parenthesized_expression] = STATE(1116),
    [sym_expression] = STATE(1697),
    [sym_primary_expression] = STATE(1799),
    [sym_yield_expression] = STATE(1798),
    [sym_object] = STATE(1844),
    [sym_object_pattern] = STATE(4170),
    [sym_array] = STATE(1844),
    [sym_array_pattern] = STATE(4170),
    [sym_class] = STATE(1844),
    [sym_class_declaration] = STATE(741),
    [sym_function] = STATE(1844),
    [sym_function_declaration] = STATE(741),
    [sym_generator_function] = STATE(1844),
    [sym_generator_function_declaration] = STATE(741),
    [sym_arrow_function] = STATE(1844),
    [sym__call_signature] = STATE(4172),
    [sym_call_expression] = STATE(1844),
    [sym_new_expression] = STATE(1798),
    [sym_await_expression] = STATE(1798),
    [sym_member_expression] = STATE(1116),
    [sym_subscript_expression] = STATE(1116),
    [sym_assignment_expression] = STATE(1798),
    [sym__augmented_assignment_lhs] = STATE(2357),
    [sym_augmented_assignment_expression] = STATE(1798),
    [sym__destructuring_pattern] = STATE(4170),
    [sym_ternary_expression] = STATE(1798),
    [sym_binary_expression] = STATE(1798),
    [sym_unary_expression] = STATE(1798),
    [sym_update_expression] = STATE(1798),
    [sym_sequence_expression] = STATE(3662),
    [sym_string] = STATE(1844),
    [sym_template_string] = STATE(1844),
    [sym_regex] = STATE(1844),
    [sym_meta_property] = STATE(1844),
    [sym_decorator] = STATE(1149),
    [sym_formal_parameters] = STATE(2903),
    [sym_non_null_expression] = STATE(1116),
    [sym_function_signature] = STATE(741),
    [sym_type_assertion] = STATE(1798),
    [sym_as_expression] = STATE(1798),
    [sym_ambient_declaration] = STATE(741),
    [sym_abstract_class_declaration] = STATE(741),
    [sym_module] = STATE(741),
    [sym_internal_module] = STATE(140),
    [sym_import_alias] = STATE(741),
    [sym_interface_declaration] = STATE(741),
    [sym_enum_declaration] = STATE(741),
    [sym_type_alias_declaration] = STATE(741),
    [sym_type_arguments] = STATE(482),
    [sym_type_parameters] = STATE(3670),
    [aux_sym_program_repeat1] = STATE(28),
    [aux_sym_export_statement_repeat1] = STATE(2947),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_type] = ACTIONS(13),
    [anon_sym_namespace] = ACTIONS(15),
    [anon_sym_LBRACE] = ACTIONS(17),
    [anon_sym_RBRACE] = ACTIONS(499),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_for] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_await] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(41),
    [anon_sym_do] = ACTIONS(43),
    [anon_sym_try] = ACTIONS(45),
    [anon_sym_with] = ACTIONS(47),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_debugger] = ACTIONS(53),
    [anon_sym_return] = ACTIONS(55),
    [anon_sym_throw] = ACTIONS(57),
    [anon_sym_SEMI] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(69),
    [anon_sym_async] = ACTIONS(71),
    [anon_sym_function] = ACTIONS(73),
    [anon_sym_new] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_void] = ACTIONS(19),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(77),
    [anon_sym_DASH_DASH] = ACTIONS(77),
    [anon_sym_DQUOTE] = ACTIONS(79),
    [anon_sym_SQUOTE] = ACTIONS(81),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(83),
    [sym_number] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(93),
    [anon_sym_readonly] = ACTIONS(93),
    [anon_sym_get] = ACTIONS(93),
    [anon_sym_set] = ACTIONS(93),
    [anon_sym_declare] = ACTIONS(95),
    [anon_sym_public] = ACTIONS(93),
    [anon_sym_private] = ACTIONS(93),
    [anon_sym_protected] = ACTIONS(93),
    [anon_sym_override] = ACTIONS(93),
    [anon_sym_module] = ACTIONS(97),
    [anon_sym_any] = ACTIONS(93),
    [anon_sym_number] = ACTIONS(93),
    [anon_sym_boolean] = ACTIONS(93),
    [anon_sym_string] = ACTIONS(93),
    [anon_sym_symbol] = ACTIONS(93),
    [anon_sym_abstract] = ACTIONS(99),
    [anon_sym_interface] = ACTIONS(101),
    [anon_sym_enum] = ACTIONS(103),
  },
  [28] = {
    [sym_export_statement] = STATE(9),
    [sym_declaration] = STATE(9),
    [sym_import] = STATE(1844),
    [sym_import_statement] = STATE(9),
    [sym_expression_statement] = STATE(9),
    [sym_variable_declaration] = STATE(741),
    [sym_lexical_declaration] = STATE(741),
    [sym_statement_block] = STATE(9),
    [sym_if_statement] = STATE(9),
    [sym_switch_statement] = STATE(9),
    [sym_for_statement] = STATE(9),
    [sym_for_in_statement] = STATE(9),
    [sym_while_statement] = STATE(9),
    [sym_do_statement] = STATE(9),
    [sym_try_statement] = STATE(9),
    [sym_with_statement] = STATE(9),
    [sym_break_statement] = STATE(9),
    [sym_continue_statement] = STATE(9),
    [sym_debugger_statement] = STATE(9),
    [sym_return_statement] = STATE(9),
    [sym_throw_statement] = STATE(9),
    [sym_empty_statement] = STATE(9),
    [sym_labeled_statement] = STATE(9),
    [sym_parenthesized_expression] = STATE(1116),
    [sym_expression] = STATE(1697),
    [sym_primary_expression] = STATE(1799),
    [sym_yield_expression] = STATE(1798),
    [sym_object] = STATE(1844),
    [sym_object_pattern] = STATE(4170),
    [sym_array] = STATE(1844),
    [sym_array_pattern] = STATE(4170),
    [sym_class] = STATE(1844),
    [sym_class_declaration] = STATE(741),
    [sym_function] = STATE(1844),
    [sym_function_declaration] = STATE(741),
    [sym_generator_function] = STATE(1844),
    [sym_generator_function_declaration] = STATE(741),
    [sym_arrow_function] = STATE(1844),
    [sym__call_signature] = STATE(4172),
    [sym_call_expression] = STATE(1844),
    [sym_new_expression] = STATE(1798),
    [sym_await_expression] = STATE(1798),
    [sym_member_expression] = STATE(1116),
    [sym_subscript_expression] = STATE(1116),
    [sym_assignment_expression] = STATE(1798),
    [sym__augmented_assignment_lhs] = STATE(2357),
    [sym_augmented_assignment_expression] = STATE(1798),
    [sym__destructuring_pattern] = STATE(4170),
    [sym_ternary_expression] = STATE(1798),
    [sym_binary_expression] = STATE(1798),
    [sym_unary_expression] = STATE(1798),
    [sym_update_expression] = STATE(1798),
    [sym_sequence_expression] = STATE(3662),
    [sym_string] = STATE(1844),
    [sym_template_string] = STATE(1844),
    [sym_regex] = STATE(1844),
    [sym_meta_property] = STATE(1844),
    [sym_decorator] = STATE(1149),
    [sym_formal_parameters] = STATE(2903),
    [sym_non_null_expression] = STATE(1116),
    [sym_function_signature] = STATE(741),
    [sym_type_assertion] = STATE(1798),
    [sym_as_expression] = STATE(1798),
    [sym_ambient_declaration] = STATE(741),
    [sym_abstract_class_declaration] = STATE(741),
    [sym_module] = STATE(741),
    [sym_internal_module] = STATE(140),
    [sym_import_alias] = STATE(741),
    [sym_interface_declaration] = STATE(741),
    [sym_enum_declaration] = STATE(741),
    [sym_type_alias_declaration] = STATE(741),
    [sym_type_arguments] = STATE(482),
    [sym_type_parameters] = STATE(3670),
    [aux_sym_program_repeat1] = STATE(9),
    [aux_sym_export_statement_repeat1] = STATE(2947),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_type] = ACTIONS(13),
    [anon_sym_namespace] = ACTIONS(15),
    [anon_sym_LBRACE] = ACTIONS(17),
    [anon_sym_RBRACE] = ACTIONS(501),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_for] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_await] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(41),
    [anon_sym_do] = ACTIONS(43),
    [anon_sym_try] = ACTIONS(45),
    [anon_sym_with] = ACTIONS(47),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_debugger] = ACTIONS(53),
    [anon_sym_return] = ACTIONS(55),
    [anon_sym_throw] = ACTIONS(57),
    [anon_sym_SEMI] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(69),
    [anon_sym_async] = ACTIONS(71),
    [anon_sym_function] = ACTIONS(73),
    [anon_sym_new] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_void] = ACTIONS(19),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(77),
    [anon_sym_DASH_DASH] = ACTIONS(77),
    [anon_sym_DQUOTE] = ACTIONS(79),
    [anon_sym_SQUOTE] = ACTIONS(81),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(83),
    [sym_number] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(93),
    [anon_sym_readonly] = ACTIONS(93),
    [anon_sym_get] = ACTIONS(93),
    [anon_sym_set] = ACTIONS(93),
    [anon_sym_declare] = ACTIONS(95),
    [anon_sym_public] = ACTIONS(93),
    [anon_sym_private] = ACTIONS(93),
    [anon_sym_protected] = ACTIONS(93),
    [anon_sym_override] = ACTIONS(93),
    [anon_sym_module] = ACTIONS(97),
    [anon_sym_any] = ACTIONS(93),
    [anon_sym_number] = ACTIONS(93),
    [anon_sym_boolean] = ACTIONS(93),
    [anon_sym_string] = ACTIONS(93),
    [anon_sym_symbol] = ACTIONS(93),
    [anon_sym_abstract] = ACTIONS(99),
    [anon_sym_interface] = ACTIONS(101),
    [anon_sym_enum] = ACTIONS(103),
  },
  [29] = {
    [sym_export_statement] = STATE(620),
    [sym_declaration] = STATE(621),
    [sym_import] = STATE(1844),
    [sym_import_statement] = STATE(674),
    [sym_expression_statement] = STATE(675),
    [sym_variable_declaration] = STATE(741),
    [sym_lexical_declaration] = STATE(741),
    [sym_statement_block] = STATE(676),
    [sym_if_statement] = STATE(677),
    [sym_switch_statement] = STATE(679),
    [sym_for_statement] = STATE(680),
    [sym_for_in_statement] = STATE(681),
    [sym_while_statement] = STATE(686),
    [sym_do_statement] = STATE(687),
    [sym_try_statement] = STATE(690),
    [sym_with_statement] = STATE(692),
    [sym_break_statement] = STATE(696),
    [sym_continue_statement] = STATE(720),
    [sym_debugger_statement] = STATE(727),
    [sym_return_statement] = STATE(730),
    [sym_throw_statement] = STATE(736),
    [sym_empty_statement] = STATE(739),
    [sym_labeled_statement] = STATE(744),
    [sym_parenthesized_expression] = STATE(1116),
    [sym_expression] = STATE(1697),
    [sym_primary_expression] = STATE(1799),
    [sym_yield_expression] = STATE(1798),
    [sym_object] = STATE(1844),
    [sym_object_pattern] = STATE(4170),
    [sym_array] = STATE(1844),
    [sym_array_pattern] = STATE(4170),
    [sym_class] = STATE(1844),
    [sym_class_declaration] = STATE(741),
    [sym_function] = STATE(1844),
    [sym_function_declaration] = STATE(741),
    [sym_generator_function] = STATE(1844),
    [sym_generator_function_declaration] = STATE(741),
    [sym_arrow_function] = STATE(1844),
    [sym__call_signature] = STATE(4172),
    [sym_call_expression] = STATE(1844),
    [sym_new_expression] = STATE(1798),
    [sym_await_expression] = STATE(1798),
    [sym_member_expression] = STATE(1116),
    [sym_subscript_expression] = STATE(1116),
    [sym_assignment_expression] = STATE(1798),
    [sym__augmented_assignment_lhs] = STATE(2357),
    [sym_augmented_assignment_expression] = STATE(1798),
    [sym__destructuring_pattern] = STATE(4170),
    [sym_ternary_expression] = STATE(1798),
    [sym_binary_expression] = STATE(1798),
    [sym_unary_expression] = STATE(1798),
    [sym_update_expression] = STATE(1798),
    [sym_sequence_expression] = STATE(3662),
    [sym_string] = STATE(1844),
    [sym_template_string] = STATE(1844),
    [sym_regex] = STATE(1844),
    [sym_meta_property] = STATE(1844),
    [sym_decorator] = STATE(1149),
    [sym_formal_parameters] = STATE(2903),
    [sym_non_null_expression] = STATE(1116),
    [sym_function_signature] = STATE(741),
    [sym_type_assertion] = STATE(1798),
    [sym_as_expression] = STATE(1798),
    [sym_ambient_declaration] = STATE(741),
    [sym_abstract_class_declaration] = STATE(741),
    [sym_module] = STATE(741),
    [sym_internal_module] = STATE(1746),
    [sym_import_alias] = STATE(741),
    [sym_interface_declaration] = STATE(741),
    [sym_enum_declaration] = STATE(741),
    [sym_type_alias_declaration] = STATE(741),
    [sym_type_arguments] = STATE(482),
    [sym_type_parameters] = STATE(3670),
    [aux_sym_export_statement_repeat1] = STATE(2949),
    [sym_identifier] = ACTIONS(503),
    [anon_sym_export] = ACTIONS(505),
    [anon_sym_type] = ACTIONS(507),
    [anon_sym_namespace] = ACTIONS(509),
    [anon_sym_LBRACE] = ACTIONS(511),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(513),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_for] = ACTIONS(515),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_await] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(517),
    [anon_sym_do] = ACTIONS(43),
    [anon_sym_try] = ACTIONS(45),
    [anon_sym_with] = ACTIONS(519),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_debugger] = ACTIONS(53),
    [anon_sym_return] = ACTIONS(55),
    [anon_sym_throw] = ACTIONS(57),
    [anon_sym_SEMI] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(521),
    [anon_sym_async] = ACTIONS(523),
    [anon_sym_function] = ACTIONS(525),
    [anon_sym_new] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_void] = ACTIONS(19),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(77),
    [anon_sym_DASH_DASH] = ACTIONS(77),
    [anon_sym_DQUOTE] = ACTIONS(79),
    [anon_sym_SQUOTE] = ACTIONS(81),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(83),
    [sym_number] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(527),
    [anon_sym_readonly] = ACTIONS(527),
    [anon_sym_get] = ACTIONS(527),
    [anon_sym_set] = ACTIONS(527),
    [anon_sym_declare] = ACTIONS(529),
    [anon_sym_public] = ACTIONS(527),
    [anon_sym_private] = ACTIONS(527),
    [anon_sym_protected] = ACTIONS(527),
    [anon_sym_override] = ACTIONS(527),
    [anon_sym_module] = ACTIONS(531),
    [anon_sym_any] = ACTIONS(527),
    [anon_sym_number] = ACTIONS(527),
    [anon_sym_boolean] = ACTIONS(527),
    [anon_sym_string] = ACTIONS(527),
    [anon_sym_symbol] = ACTIONS(527),
    [anon_sym_abstract] = ACTIONS(99),
    [anon_sym_interface] = ACTIONS(101),
    [anon_sym_enum] = ACTIONS(103),
  },
  [30] = {
    [sym_export_statement] = STATE(721),
    [sym_declaration] = STATE(721),
    [sym_import] = STATE(1844),
    [sym_import_statement] = STATE(721),
    [sym_expression_statement] = STATE(721),
    [sym_variable_declaration] = STATE(741),
    [sym_lexical_declaration] = STATE(741),
    [sym_statement_block] = STATE(721),
    [sym_if_statement] = STATE(721),
    [sym_switch_statement] = STATE(721),
    [sym_for_statement] = STATE(721),
    [sym_for_in_statement] = STATE(721),
    [sym_while_statement] = STATE(721),
    [sym_do_statement] = STATE(721),
    [sym_try_statement] = STATE(721),
    [sym_with_statement] = STATE(721),
    [sym_break_statement] = STATE(721),
    [sym_continue_statement] = STATE(721),
    [sym_debugger_statement] = STATE(721),
    [sym_return_statement] = STATE(721),
    [sym_throw_statement] = STATE(721),
    [sym_empty_statement] = STATE(721),
    [sym_labeled_statement] = STATE(721),
    [sym_parenthesized_expression] = STATE(1116),
    [sym_expression] = STATE(1697),
    [sym_primary_expression] = STATE(1799),
    [sym_yield_expression] = STATE(1798),
    [sym_object] = STATE(1844),
    [sym_object_pattern] = STATE(4170),
    [sym_array] = STATE(1844),
    [sym_array_pattern] = STATE(4170),
    [sym_class] = STATE(1844),
    [sym_class_declaration] = STATE(741),
    [sym_function] = STATE(1844),
    [sym_function_declaration] = STATE(741),
    [sym_generator_function] = STATE(1844),
    [sym_generator_function_declaration] = STATE(741),
    [sym_arrow_function] = STATE(1844),
    [sym__call_signature] = STATE(4172),
    [sym_call_expression] = STATE(1844),
    [sym_new_expression] = STATE(1798),
    [sym_await_expression] = STATE(1798),
    [sym_member_expression] = STATE(1116),
    [sym_subscript_expression] = STATE(1116),
    [sym_assignment_expression] = STATE(1798),
    [sym__augmented_assignment_lhs] = STATE(2357),
    [sym_augmented_assignment_expression] = STATE(1798),
    [sym__destructuring_pattern] = STATE(4170),
    [sym_ternary_expression] = STATE(1798),
    [sym_binary_expression] = STATE(1798),
    [sym_unary_expression] = STATE(1798),
    [sym_update_expression] = STATE(1798),
    [sym_sequence_expression] = STATE(3662),
    [sym_string] = STATE(1844),
    [sym_template_string] = STATE(1844),
    [sym_regex] = STATE(1844),
    [sym_meta_property] = STATE(1844),
    [sym_decorator] = STATE(1149),
    [sym_formal_parameters] = STATE(2903),
    [sym_non_null_expression] = STATE(1116),
    [sym_function_signature] = STATE(741),
    [sym_type_assertion] = STATE(1798),
    [sym_as_expression] = STATE(1798),
    [sym_ambient_declaration] = STATE(741),
    [sym_abstract_class_declaration] = STATE(741),
    [sym_module] = STATE(741),
    [sym_internal_module] = STATE(140),
    [sym_import_alias] = STATE(741),
    [sym_interface_declaration] = STATE(741),
    [sym_enum_declaration] = STATE(741),
    [sym_type_alias_declaration] = STATE(741),
    [sym_type_arguments] = STATE(482),
    [sym_type_parameters] = STATE(3670),
    [aux_sym_export_statement_repeat1] = STATE(2947),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_type] = ACTIONS(13),
    [anon_sym_namespace] = ACTIONS(15),
    [anon_sym_LBRACE] = ACTIONS(17),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_for] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_await] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(41),
    [anon_sym_do] = ACTIONS(43),
    [anon_sym_try] = ACTIONS(45),
    [anon_sym_with] = ACTIONS(47),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_debugger] = ACTIONS(53),
    [anon_sym_return] = ACTIONS(55),
    [anon_sym_throw] = ACTIONS(57),
    [anon_sym_SEMI] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(69),
    [anon_sym_async] = ACTIONS(71),
    [anon_sym_function] = ACTIONS(73),
    [anon_sym_new] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_void] = ACTIONS(19),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(77),
    [anon_sym_DASH_DASH] = ACTIONS(77),
    [anon_sym_DQUOTE] = ACTIONS(79),
    [anon_sym_SQUOTE] = ACTIONS(81),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(83),
    [sym_number] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(93),
    [anon_sym_readonly] = ACTIONS(93),
    [anon_sym_get] = ACTIONS(93),
    [anon_sym_set] = ACTIONS(93),
    [anon_sym_declare] = ACTIONS(95),
    [anon_sym_public] = ACTIONS(93),
    [anon_sym_private] = ACTIONS(93),
    [anon_sym_protected] = ACTIONS(93),
    [anon_sym_override] = ACTIONS(93),
    [anon_sym_module] = ACTIONS(97),
    [anon_sym_any] = ACTIONS(93),
    [anon_sym_number] = ACTIONS(93),
    [anon_sym_boolean] = ACTIONS(93),
    [anon_sym_string] = ACTIONS(93),
    [anon_sym_symbol] = ACTIONS(93),
    [anon_sym_abstract] = ACTIONS(99),
    [anon_sym_interface] = ACTIONS(101),
    [anon_sym_enum] = ACTIONS(103),
  },
  [31] = {
    [sym_export_statement] = STATE(754),
    [sym_declaration] = STATE(754),
    [sym_import] = STATE(1844),
    [sym_import_statement] = STATE(754),
    [sym_expression_statement] = STATE(754),
    [sym_variable_declaration] = STATE(741),
    [sym_lexical_declaration] = STATE(741),
    [sym_statement_block] = STATE(754),
    [sym_if_statement] = STATE(754),
    [sym_switch_statement] = STATE(754),
    [sym_for_statement] = STATE(754),
    [sym_for_in_statement] = STATE(754),
    [sym_while_statement] = STATE(754),
    [sym_do_statement] = STATE(754),
    [sym_try_statement] = STATE(754),
    [sym_with_statement] = STATE(754),
    [sym_break_statement] = STATE(754),
    [sym_continue_statement] = STATE(754),
    [sym_debugger_statement] = STATE(754),
    [sym_return_statement] = STATE(754),
    [sym_throw_statement] = STATE(754),
    [sym_empty_statement] = STATE(754),
    [sym_labeled_statement] = STATE(754),
    [sym_parenthesized_expression] = STATE(1116),
    [sym_expression] = STATE(1697),
    [sym_primary_expression] = STATE(1799),
    [sym_yield_expression] = STATE(1798),
    [sym_object] = STATE(1844),
    [sym_object_pattern] = STATE(4170),
    [sym_array] = STATE(1844),
    [sym_array_pattern] = STATE(4170),
    [sym_class] = STATE(1844),
    [sym_class_declaration] = STATE(741),
    [sym_function] = STATE(1844),
    [sym_function_declaration] = STATE(741),
    [sym_generator_function] = STATE(1844),
    [sym_generator_function_declaration] = STATE(741),
    [sym_arrow_function] = STATE(1844),
    [sym__call_signature] = STATE(4172),
    [sym_call_expression] = STATE(1844),
    [sym_new_expression] = STATE(1798),
    [sym_await_expression] = STATE(1798),
    [sym_member_expression] = STATE(1116),
    [sym_subscript_expression] = STATE(1116),
    [sym_assignment_expression] = STATE(1798),
    [sym__augmented_assignment_lhs] = STATE(2357),
    [sym_augmented_assignment_expression] = STATE(1798),
    [sym__destructuring_pattern] = STATE(4170),
    [sym_ternary_expression] = STATE(1798),
    [sym_binary_expression] = STATE(1798),
    [sym_unary_expression] = STATE(1798),
    [sym_update_expression] = STATE(1798),
    [sym_sequence_expression] = STATE(3662),
    [sym_string] = STATE(1844),
    [sym_template_string] = STATE(1844),
    [sym_regex] = STATE(1844),
    [sym_meta_property] = STATE(1844),
    [sym_decorator] = STATE(1149),
    [sym_formal_parameters] = STATE(2903),
    [sym_non_null_expression] = STATE(1116),
    [sym_function_signature] = STATE(741),
    [sym_type_assertion] = STATE(1798),
    [sym_as_expression] = STATE(1798),
    [sym_ambient_declaration] = STATE(741),
    [sym_abstract_class_declaration] = STATE(741),
    [sym_module] = STATE(741),
    [sym_internal_module] = STATE(1746),
    [sym_import_alias] = STATE(741),
    [sym_interface_declaration] = STATE(741),
    [sym_enum_declaration] = STATE(741),
    [sym_type_alias_declaration] = STATE(741),
    [sym_type_arguments] = STATE(482),
    [sym_type_parameters] = STATE(3670),
    [aux_sym_export_statement_repeat1] = STATE(2949),
    [sym_identifier] = ACTIONS(503),
    [anon_sym_export] = ACTIONS(505),
    [anon_sym_type] = ACTIONS(507),
    [anon_sym_namespace] = ACTIONS(509),
    [anon_sym_LBRACE] = ACTIONS(511),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(513),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_for] = ACTIONS(515),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_await] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(517),
    [anon_sym_do] = ACTIONS(43),
    [anon_sym_try] = ACTIONS(45),
    [anon_sym_with] = ACTIONS(519),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_debugger] = ACTIONS(53),
    [anon_sym_return] = ACTIONS(55),
    [anon_sym_throw] = ACTIONS(57),
    [anon_sym_SEMI] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(521),
    [anon_sym_async] = ACTIONS(523),
    [anon_sym_function] = ACTIONS(525),
    [anon_sym_new] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_void] = ACTIONS(19),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(77),
    [anon_sym_DASH_DASH] = ACTIONS(77),
    [anon_sym_DQUOTE] = ACTIONS(79),
    [anon_sym_SQUOTE] = ACTIONS(81),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(83),
    [sym_number] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(527),
    [anon_sym_readonly] = ACTIONS(527),
    [anon_sym_get] = ACTIONS(527),
    [anon_sym_set] = ACTIONS(527),
    [anon_sym_declare] = ACTIONS(529),
    [anon_sym_public] = ACTIONS(527),
    [anon_sym_private] = ACTIONS(527),
    [anon_sym_protected] = ACTIONS(527),
    [anon_sym_override] = ACTIONS(527),
    [anon_sym_module] = ACTIONS(531),
    [anon_sym_any] = ACTIONS(527),
    [anon_sym_number] = ACTIONS(527),
    [anon_sym_boolean] = ACTIONS(527),
    [anon_sym_string] = ACTIONS(527),
    [anon_sym_symbol] = ACTIONS(527),
    [anon_sym_abstract] = ACTIONS(99),
    [anon_sym_interface] = ACTIONS(101),
    [anon_sym_enum] = ACTIONS(103),
  },
  [32] = {
    [sym_export_statement] = STATE(673),
    [sym_declaration] = STATE(673),
    [sym_import] = STATE(1844),
    [sym_import_statement] = STATE(673),
    [sym_expression_statement] = STATE(673),
    [sym_variable_declaration] = STATE(741),
    [sym_lexical_declaration] = STATE(741),
    [sym_statement_block] = STATE(673),
    [sym_if_statement] = STATE(673),
    [sym_switch_statement] = STATE(673),
    [sym_for_statement] = STATE(673),
    [sym_for_in_statement] = STATE(673),
    [sym_while_statement] = STATE(673),
    [sym_do_statement] = STATE(673),
    [sym_try_statement] = STATE(673),
    [sym_with_statement] = STATE(673),
    [sym_break_statement] = STATE(673),
    [sym_continue_statement] = STATE(673),
    [sym_debugger_statement] = STATE(673),
    [sym_return_statement] = STATE(673),
    [sym_throw_statement] = STATE(673),
    [sym_empty_statement] = STATE(673),
    [sym_labeled_statement] = STATE(673),
    [sym_parenthesized_expression] = STATE(1116),
    [sym_expression] = STATE(1697),
    [sym_primary_expression] = STATE(1799),
    [sym_yield_expression] = STATE(1798),
    [sym_object] = STATE(1844),
    [sym_object_pattern] = STATE(4170),
    [sym_array] = STATE(1844),
    [sym_array_pattern] = STATE(4170),
    [sym_class] = STATE(1844),
    [sym_class_declaration] = STATE(741),
    [sym_function] = STATE(1844),
    [sym_function_declaration] = STATE(741),
    [sym_generator_function] = STATE(1844),
    [sym_generator_function_declaration] = STATE(741),
    [sym_arrow_function] = STATE(1844),
    [sym__call_signature] = STATE(4172),
    [sym_call_expression] = STATE(1844),
    [sym_new_expression] = STATE(1798),
    [sym_await_expression] = STATE(1798),
    [sym_member_expression] = STATE(1116),
    [sym_subscript_expression] = STATE(1116),
    [sym_assignment_expression] = STATE(1798),
    [sym__augmented_assignment_lhs] = STATE(2357),
    [sym_augmented_assignment_expression] = STATE(1798),
    [sym__destructuring_pattern] = STATE(4170),
    [sym_ternary_expression] = STATE(1798),
    [sym_binary_expression] = STATE(1798),
    [sym_unary_expression] = STATE(1798),
    [sym_update_expression] = STATE(1798),
    [sym_sequence_expression] = STATE(3662),
    [sym_string] = STATE(1844),
    [sym_template_string] = STATE(1844),
    [sym_regex] = STATE(1844),
    [sym_meta_property] = STATE(1844),
    [sym_decorator] = STATE(1149),
    [sym_formal_parameters] = STATE(2903),
    [sym_non_null_expression] = STATE(1116),
    [sym_function_signature] = STATE(741),
    [sym_type_assertion] = STATE(1798),
    [sym_as_expression] = STATE(1798),
    [sym_ambient_declaration] = STATE(741),
    [sym_abstract_class_declaration] = STATE(741),
    [sym_module] = STATE(741),
    [sym_internal_module] = STATE(1746),
    [sym_import_alias] = STATE(741),
    [sym_interface_declaration] = STATE(741),
    [sym_enum_declaration] = STATE(741),
    [sym_type_alias_declaration] = STATE(741),
    [sym_type_arguments] = STATE(482),
    [sym_type_parameters] = STATE(3670),
    [aux_sym_export_statement_repeat1] = STATE(2949),
    [sym_identifier] = ACTIONS(503),
    [anon_sym_export] = ACTIONS(505),
    [anon_sym_type] = ACTIONS(507),
    [anon_sym_namespace] = ACTIONS(509),
    [anon_sym_LBRACE] = ACTIONS(511),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(513),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_for] = ACTIONS(515),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_await] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(517),
    [anon_sym_do] = ACTIONS(43),
    [anon_sym_try] = ACTIONS(45),
    [anon_sym_with] = ACTIONS(519),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_debugger] = ACTIONS(53),
    [anon_sym_return] = ACTIONS(55),
    [anon_sym_throw] = ACTIONS(57),
    [anon_sym_SEMI] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(521),
    [anon_sym_async] = ACTIONS(523),
    [anon_sym_function] = ACTIONS(525),
    [anon_sym_new] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_void] = ACTIONS(19),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(77),
    [anon_sym_DASH_DASH] = ACTIONS(77),
    [anon_sym_DQUOTE] = ACTIONS(79),
    [anon_sym_SQUOTE] = ACTIONS(81),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(83),
    [sym_number] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(527),
    [anon_sym_readonly] = ACTIONS(527),
    [anon_sym_get] = ACTIONS(527),
    [anon_sym_set] = ACTIONS(527),
    [anon_sym_declare] = ACTIONS(529),
    [anon_sym_public] = ACTIONS(527),
    [anon_sym_private] = ACTIONS(527),
    [anon_sym_protected] = ACTIONS(527),
    [anon_sym_override] = ACTIONS(527),
    [anon_sym_module] = ACTIONS(531),
    [anon_sym_any] = ACTIONS(527),
    [anon_sym_number] = ACTIONS(527),
    [anon_sym_boolean] = ACTIONS(527),
    [anon_sym_string] = ACTIONS(527),
    [anon_sym_symbol] = ACTIONS(527),
    [anon_sym_abstract] = ACTIONS(99),
    [anon_sym_interface] = ACTIONS(101),
    [anon_sym_enum] = ACTIONS(103),
  },
  [33] = {
    [sym_export_statement] = STATE(722),
    [sym_declaration] = STATE(722),
    [sym_import] = STATE(1844),
    [sym_import_statement] = STATE(722),
    [sym_expression_statement] = STATE(722),
    [sym_variable_declaration] = STATE(741),
    [sym_lexical_declaration] = STATE(741),
    [sym_statement_block] = STATE(722),
    [sym_if_statement] = STATE(722),
    [sym_switch_statement] = STATE(722),
    [sym_for_statement] = STATE(722),
    [sym_for_in_statement] = STATE(722),
    [sym_while_statement] = STATE(722),
    [sym_do_statement] = STATE(722),
    [sym_try_statement] = STATE(722),
    [sym_with_statement] = STATE(722),
    [sym_break_statement] = STATE(722),
    [sym_continue_statement] = STATE(722),
    [sym_debugger_statement] = STATE(722),
    [sym_return_statement] = STATE(722),
    [sym_throw_statement] = STATE(722),
    [sym_empty_statement] = STATE(722),
    [sym_labeled_statement] = STATE(722),
    [sym_parenthesized_expression] = STATE(1116),
    [sym_expression] = STATE(1697),
    [sym_primary_expression] = STATE(1799),
    [sym_yield_expression] = STATE(1798),
    [sym_object] = STATE(1844),
    [sym_object_pattern] = STATE(4170),
    [sym_array] = STATE(1844),
    [sym_array_pattern] = STATE(4170),
    [sym_class] = STATE(1844),
    [sym_class_declaration] = STATE(741),
    [sym_function] = STATE(1844),
    [sym_function_declaration] = STATE(741),
    [sym_generator_function] = STATE(1844),
    [sym_generator_function_declaration] = STATE(741),
    [sym_arrow_function] = STATE(1844),
    [sym__call_signature] = STATE(4172),
    [sym_call_expression] = STATE(1844),
    [sym_new_expression] = STATE(1798),
    [sym_await_expression] = STATE(1798),
    [sym_member_expression] = STATE(1116),
    [sym_subscript_expression] = STATE(1116),
    [sym_assignment_expression] = STATE(1798),
    [sym__augmented_assignment_lhs] = STATE(2357),
    [sym_augmented_assignment_expression] = STATE(1798),
    [sym__destructuring_pattern] = STATE(4170),
    [sym_ternary_expression] = STATE(1798),
    [sym_binary_expression] = STATE(1798),
    [sym_unary_expression] = STATE(1798),
    [sym_update_expression] = STATE(1798),
    [sym_sequence_expression] = STATE(3662),
    [sym_string] = STATE(1844),
    [sym_template_string] = STATE(1844),
    [sym_regex] = STATE(1844),
    [sym_meta_property] = STATE(1844),
    [sym_decorator] = STATE(1149),
    [sym_formal_parameters] = STATE(2903),
    [sym_non_null_expression] = STATE(1116),
    [sym_function_signature] = STATE(741),
    [sym_type_assertion] = STATE(1798),
    [sym_as_expression] = STATE(1798),
    [sym_ambient_declaration] = STATE(741),
    [sym_abstract_class_declaration] = STATE(741),
    [sym_module] = STATE(741),
    [sym_internal_module] = STATE(140),
    [sym_import_alias] = STATE(741),
    [sym_interface_declaration] = STATE(741),
    [sym_enum_declaration] = STATE(741),
    [sym_type_alias_declaration] = STATE(741),
    [sym_type_arguments] = STATE(482),
    [sym_type_parameters] = STATE(3670),
    [aux_sym_export_statement_repeat1] = STATE(2947),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_type] = ACTIONS(13),
    [anon_sym_namespace] = ACTIONS(15),
    [anon_sym_LBRACE] = ACTIONS(17),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_for] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_await] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(41),
    [anon_sym_do] = ACTIONS(43),
    [anon_sym_try] = ACTIONS(45),
    [anon_sym_with] = ACTIONS(47),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_debugger] = ACTIONS(53),
    [anon_sym_return] = ACTIONS(55),
    [anon_sym_throw] = ACTIONS(57),
    [anon_sym_SEMI] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(69),
    [anon_sym_async] = ACTIONS(71),
    [anon_sym_function] = ACTIONS(73),
    [anon_sym_new] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_void] = ACTIONS(19),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(77),
    [anon_sym_DASH_DASH] = ACTIONS(77),
    [anon_sym_DQUOTE] = ACTIONS(79),
    [anon_sym_SQUOTE] = ACTIONS(81),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(83),
    [sym_number] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(93),
    [anon_sym_readonly] = ACTIONS(93),
    [anon_sym_get] = ACTIONS(93),
    [anon_sym_set] = ACTIONS(93),
    [anon_sym_declare] = ACTIONS(95),
    [anon_sym_public] = ACTIONS(93),
    [anon_sym_private] = ACTIONS(93),
    [anon_sym_protected] = ACTIONS(93),
    [anon_sym_override] = ACTIONS(93),
    [anon_sym_module] = ACTIONS(97),
    [anon_sym_any] = ACTIONS(93),
    [anon_sym_number] = ACTIONS(93),
    [anon_sym_boolean] = ACTIONS(93),
    [anon_sym_string] = ACTIONS(93),
    [anon_sym_symbol] = ACTIONS(93),
    [anon_sym_abstract] = ACTIONS(99),
    [anon_sym_interface] = ACTIONS(101),
    [anon_sym_enum] = ACTIONS(103),
  },
  [34] = {
    [sym_export_statement] = STATE(3612),
    [sym_declaration] = STATE(3612),
    [sym_import] = STATE(1844),
    [sym_import_statement] = STATE(3612),
    [sym_expression_statement] = STATE(3612),
    [sym_variable_declaration] = STATE(741),
    [sym_lexical_declaration] = STATE(741),
    [sym_statement_block] = STATE(3612),
    [sym_if_statement] = STATE(3612),
    [sym_switch_statement] = STATE(3612),
    [sym_for_statement] = STATE(3612),
    [sym_for_in_statement] = STATE(3612),
    [sym_while_statement] = STATE(3612),
    [sym_do_statement] = STATE(3612),
    [sym_try_statement] = STATE(3612),
    [sym_with_statement] = STATE(3612),
    [sym_break_statement] = STATE(3612),
    [sym_continue_statement] = STATE(3612),
    [sym_debugger_statement] = STATE(3612),
    [sym_return_statement] = STATE(3612),
    [sym_throw_statement] = STATE(3612),
    [sym_empty_statement] = STATE(3612),
    [sym_labeled_statement] = STATE(3612),
    [sym_parenthesized_expression] = STATE(1116),
    [sym_expression] = STATE(1697),
    [sym_primary_expression] = STATE(1799),
    [sym_yield_expression] = STATE(1798),
    [sym_object] = STATE(1844),
    [sym_object_pattern] = STATE(4170),
    [sym_array] = STATE(1844),
    [sym_array_pattern] = STATE(4170),
    [sym_class] = STATE(1844),
    [sym_class_declaration] = STATE(741),
    [sym_function] = STATE(1844),
    [sym_function_declaration] = STATE(741),
    [sym_generator_function] = STATE(1844),
    [sym_generator_function_declaration] = STATE(741),
    [sym_arrow_function] = STATE(1844),
    [sym__call_signature] = STATE(4172),
    [sym_call_expression] = STATE(1844),
    [sym_new_expression] = STATE(1798),
    [sym_await_expression] = STATE(1798),
    [sym_member_expression] = STATE(1116),
    [sym_subscript_expression] = STATE(1116),
    [sym_assignment_expression] = STATE(1798),
    [sym__augmented_assignment_lhs] = STATE(2357),
    [sym_augmented_assignment_expression] = STATE(1798),
    [sym__destructuring_pattern] = STATE(4170),
    [sym_ternary_expression] = STATE(1798),
    [sym_binary_expression] = STATE(1798),
    [sym_unary_expression] = STATE(1798),
    [sym_update_expression] = STATE(1798),
    [sym_sequence_expression] = STATE(3662),
    [sym_string] = STATE(1844),
    [sym_template_string] = STATE(1844),
    [sym_regex] = STATE(1844),
    [sym_meta_property] = STATE(1844),
    [sym_decorator] = STATE(1149),
    [sym_formal_parameters] = STATE(2903),
    [sym_non_null_expression] = STATE(1116),
    [sym_function_signature] = STATE(741),
    [sym_type_assertion] = STATE(1798),
    [sym_as_expression] = STATE(1798),
    [sym_ambient_declaration] = STATE(741),
    [sym_abstract_class_declaration] = STATE(741),
    [sym_module] = STATE(741),
    [sym_internal_module] = STATE(1746),
    [sym_import_alias] = STATE(741),
    [sym_interface_declaration] = STATE(741),
    [sym_enum_declaration] = STATE(741),
    [sym_type_alias_declaration] = STATE(741),
    [sym_type_arguments] = STATE(482),
    [sym_type_parameters] = STATE(3670),
    [aux_sym_export_statement_repeat1] = STATE(2949),
    [sym_identifier] = ACTIONS(503),
    [anon_sym_export] = ACTIONS(505),
    [anon_sym_type] = ACTIONS(507),
    [anon_sym_namespace] = ACTIONS(509),
    [anon_sym_LBRACE] = ACTIONS(511),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(513),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_for] = ACTIONS(515),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_await] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(517),
    [anon_sym_do] = ACTIONS(43),
    [anon_sym_try] = ACTIONS(45),
    [anon_sym_with] = ACTIONS(519),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_debugger] = ACTIONS(53),
    [anon_sym_return] = ACTIONS(55),
    [anon_sym_throw] = ACTIONS(57),
    [anon_sym_SEMI] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(521),
    [anon_sym_async] = ACTIONS(523),
    [anon_sym_function] = ACTIONS(525),
    [anon_sym_new] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_void] = ACTIONS(19),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(77),
    [anon_sym_DASH_DASH] = ACTIONS(77),
    [anon_sym_DQUOTE] = ACTIONS(79),
    [anon_sym_SQUOTE] = ACTIONS(81),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(83),
    [sym_number] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(527),
    [anon_sym_readonly] = ACTIONS(527),
    [anon_sym_get] = ACTIONS(527),
    [anon_sym_set] = ACTIONS(527),
    [anon_sym_declare] = ACTIONS(529),
    [anon_sym_public] = ACTIONS(527),
    [anon_sym_private] = ACTIONS(527),
    [anon_sym_protected] = ACTIONS(527),
    [anon_sym_override] = ACTIONS(527),
    [anon_sym_module] = ACTIONS(531),
    [anon_sym_any] = ACTIONS(527),
    [anon_sym_number] = ACTIONS(527),
    [anon_sym_boolean] = ACTIONS(527),
    [anon_sym_string] = ACTIONS(527),
    [anon_sym_symbol] = ACTIONS(527),
    [anon_sym_abstract] = ACTIONS(99),
    [anon_sym_interface] = ACTIONS(101),
    [anon_sym_enum] = ACTIONS(103),
  },
  [35] = {
    [sym_export_statement] = STATE(660),
    [sym_declaration] = STATE(660),
    [sym_import] = STATE(1844),
    [sym_import_statement] = STATE(660),
    [sym_expression_statement] = STATE(660),
    [sym_variable_declaration] = STATE(741),
    [sym_lexical_declaration] = STATE(741),
    [sym_statement_block] = STATE(660),
    [sym_if_statement] = STATE(660),
    [sym_switch_statement] = STATE(660),
    [sym_for_statement] = STATE(660),
    [sym_for_in_statement] = STATE(660),
    [sym_while_statement] = STATE(660),
    [sym_do_statement] = STATE(660),
    [sym_try_statement] = STATE(660),
    [sym_with_statement] = STATE(660),
    [sym_break_statement] = STATE(660),
    [sym_continue_statement] = STATE(660),
    [sym_debugger_statement] = STATE(660),
    [sym_return_statement] = STATE(660),
    [sym_throw_statement] = STATE(660),
    [sym_empty_statement] = STATE(660),
    [sym_labeled_statement] = STATE(660),
    [sym_parenthesized_expression] = STATE(1116),
    [sym_expression] = STATE(1697),
    [sym_primary_expression] = STATE(1799),
    [sym_yield_expression] = STATE(1798),
    [sym_object] = STATE(1844),
    [sym_object_pattern] = STATE(4170),
    [sym_array] = STATE(1844),
    [sym_array_pattern] = STATE(4170),
    [sym_class] = STATE(1844),
    [sym_class_declaration] = STATE(741),
    [sym_function] = STATE(1844),
    [sym_function_declaration] = STATE(741),
    [sym_generator_function] = STATE(1844),
    [sym_generator_function_declaration] = STATE(741),
    [sym_arrow_function] = STATE(1844),
    [sym__call_signature] = STATE(4172),
    [sym_call_expression] = STATE(1844),
    [sym_new_expression] = STATE(1798),
    [sym_await_expression] = STATE(1798),
    [sym_member_expression] = STATE(1116),
    [sym_subscript_expression] = STATE(1116),
    [sym_assignment_expression] = STATE(1798),
    [sym__augmented_assignment_lhs] = STATE(2357),
    [sym_augmented_assignment_expression] = STATE(1798),
    [sym__destructuring_pattern] = STATE(4170),
    [sym_ternary_expression] = STATE(1798),
    [sym_binary_expression] = STATE(1798),
    [sym_unary_expression] = STATE(1798),
    [sym_update_expression] = STATE(1798),
    [sym_sequence_expression] = STATE(3662),
    [sym_string] = STATE(1844),
    [sym_template_string] = STATE(1844),
    [sym_regex] = STATE(1844),
    [sym_meta_property] = STATE(1844),
    [sym_decorator] = STATE(1149),
    [sym_formal_parameters] = STATE(2903),
    [sym_non_null_expression] = STATE(1116),
    [sym_function_signature] = STATE(741),
    [sym_type_assertion] = STATE(1798),
    [sym_as_expression] = STATE(1798),
    [sym_ambient_declaration] = STATE(741),
    [sym_abstract_class_declaration] = STATE(741),
    [sym_module] = STATE(741),
    [sym_internal_module] = STATE(140),
    [sym_import_alias] = STATE(741),
    [sym_interface_declaration] = STATE(741),
    [sym_enum_declaration] = STATE(741),
    [sym_type_alias_declaration] = STATE(741),
    [sym_type_arguments] = STATE(482),
    [sym_type_parameters] = STATE(3670),
    [aux_sym_export_statement_repeat1] = STATE(2947),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_type] = ACTIONS(13),
    [anon_sym_namespace] = ACTIONS(15),
    [anon_sym_LBRACE] = ACTIONS(17),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_for] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_await] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(41),
    [anon_sym_do] = ACTIONS(43),
    [anon_sym_try] = ACTIONS(45),
    [anon_sym_with] = ACTIONS(47),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_debugger] = ACTIONS(53),
    [anon_sym_return] = ACTIONS(55),
    [anon_sym_throw] = ACTIONS(57),
    [anon_sym_SEMI] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(69),
    [anon_sym_async] = ACTIONS(71),
    [anon_sym_function] = ACTIONS(73),
    [anon_sym_new] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_void] = ACTIONS(19),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(77),
    [anon_sym_DASH_DASH] = ACTIONS(77),
    [anon_sym_DQUOTE] = ACTIONS(79),
    [anon_sym_SQUOTE] = ACTIONS(81),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(83),
    [sym_number] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(93),
    [anon_sym_readonly] = ACTIONS(93),
    [anon_sym_get] = ACTIONS(93),
    [anon_sym_set] = ACTIONS(93),
    [anon_sym_declare] = ACTIONS(95),
    [anon_sym_public] = ACTIONS(93),
    [anon_sym_private] = ACTIONS(93),
    [anon_sym_protected] = ACTIONS(93),
    [anon_sym_override] = ACTIONS(93),
    [anon_sym_module] = ACTIONS(97),
    [anon_sym_any] = ACTIONS(93),
    [anon_sym_number] = ACTIONS(93),
    [anon_sym_boolean] = ACTIONS(93),
    [anon_sym_string] = ACTIONS(93),
    [anon_sym_symbol] = ACTIONS(93),
    [anon_sym_abstract] = ACTIONS(99),
    [anon_sym_interface] = ACTIONS(101),
    [anon_sym_enum] = ACTIONS(103),
  },
  [36] = {
    [sym_export_statement] = STATE(756),
    [sym_declaration] = STATE(756),
    [sym_import] = STATE(1844),
    [sym_import_statement] = STATE(756),
    [sym_expression_statement] = STATE(756),
    [sym_variable_declaration] = STATE(741),
    [sym_lexical_declaration] = STATE(741),
    [sym_statement_block] = STATE(756),
    [sym_if_statement] = STATE(756),
    [sym_switch_statement] = STATE(756),
    [sym_for_statement] = STATE(756),
    [sym_for_in_statement] = STATE(756),
    [sym_while_statement] = STATE(756),
    [sym_do_statement] = STATE(756),
    [sym_try_statement] = STATE(756),
    [sym_with_statement] = STATE(756),
    [sym_break_statement] = STATE(756),
    [sym_continue_statement] = STATE(756),
    [sym_debugger_statement] = STATE(756),
    [sym_return_statement] = STATE(756),
    [sym_throw_statement] = STATE(756),
    [sym_empty_statement] = STATE(756),
    [sym_labeled_statement] = STATE(756),
    [sym_parenthesized_expression] = STATE(1116),
    [sym_expression] = STATE(1697),
    [sym_primary_expression] = STATE(1799),
    [sym_yield_expression] = STATE(1798),
    [sym_object] = STATE(1844),
    [sym_object_pattern] = STATE(4170),
    [sym_array] = STATE(1844),
    [sym_array_pattern] = STATE(4170),
    [sym_class] = STATE(1844),
    [sym_class_declaration] = STATE(741),
    [sym_function] = STATE(1844),
    [sym_function_declaration] = STATE(741),
    [sym_generator_function] = STATE(1844),
    [sym_generator_function_declaration] = STATE(741),
    [sym_arrow_function] = STATE(1844),
    [sym__call_signature] = STATE(4172),
    [sym_call_expression] = STATE(1844),
    [sym_new_expression] = STATE(1798),
    [sym_await_expression] = STATE(1798),
    [sym_member_expression] = STATE(1116),
    [sym_subscript_expression] = STATE(1116),
    [sym_assignment_expression] = STATE(1798),
    [sym__augmented_assignment_lhs] = STATE(2357),
    [sym_augmented_assignment_expression] = STATE(1798),
    [sym__destructuring_pattern] = STATE(4170),
    [sym_ternary_expression] = STATE(1798),
    [sym_binary_expression] = STATE(1798),
    [sym_unary_expression] = STATE(1798),
    [sym_update_expression] = STATE(1798),
    [sym_sequence_expression] = STATE(3662),
    [sym_string] = STATE(1844),
    [sym_template_string] = STATE(1844),
    [sym_regex] = STATE(1844),
    [sym_meta_property] = STATE(1844),
    [sym_decorator] = STATE(1149),
    [sym_formal_parameters] = STATE(2903),
    [sym_non_null_expression] = STATE(1116),
    [sym_function_signature] = STATE(741),
    [sym_type_assertion] = STATE(1798),
    [sym_as_expression] = STATE(1798),
    [sym_ambient_declaration] = STATE(741),
    [sym_abstract_class_declaration] = STATE(741),
    [sym_module] = STATE(741),
    [sym_internal_module] = STATE(140),
    [sym_import_alias] = STATE(741),
    [sym_interface_declaration] = STATE(741),
    [sym_enum_declaration] = STATE(741),
    [sym_type_alias_declaration] = STATE(741),
    [sym_type_arguments] = STATE(482),
    [sym_type_parameters] = STATE(3670),
    [aux_sym_export_statement_repeat1] = STATE(2947),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_type] = ACTIONS(13),
    [anon_sym_namespace] = ACTIONS(15),
    [anon_sym_LBRACE] = ACTIONS(17),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_for] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_await] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(41),
    [anon_sym_do] = ACTIONS(43),
    [anon_sym_try] = ACTIONS(45),
    [anon_sym_with] = ACTIONS(47),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_debugger] = ACTIONS(53),
    [anon_sym_return] = ACTIONS(55),
    [anon_sym_throw] = ACTIONS(57),
    [anon_sym_SEMI] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(69),
    [anon_sym_async] = ACTIONS(71),
    [anon_sym_function] = ACTIONS(73),
    [anon_sym_new] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_void] = ACTIONS(19),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(77),
    [anon_sym_DASH_DASH] = ACTIONS(77),
    [anon_sym_DQUOTE] = ACTIONS(79),
    [anon_sym_SQUOTE] = ACTIONS(81),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(83),
    [sym_number] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(93),
    [anon_sym_readonly] = ACTIONS(93),
    [anon_sym_get] = ACTIONS(93),
    [anon_sym_set] = ACTIONS(93),
    [anon_sym_declare] = ACTIONS(95),
    [anon_sym_public] = ACTIONS(93),
    [anon_sym_private] = ACTIONS(93),
    [anon_sym_protected] = ACTIONS(93),
    [anon_sym_override] = ACTIONS(93),
    [anon_sym_module] = ACTIONS(97),
    [anon_sym_any] = ACTIONS(93),
    [anon_sym_number] = ACTIONS(93),
    [anon_sym_boolean] = ACTIONS(93),
    [anon_sym_string] = ACTIONS(93),
    [anon_sym_symbol] = ACTIONS(93),
    [anon_sym_abstract] = ACTIONS(99),
    [anon_sym_interface] = ACTIONS(101),
    [anon_sym_enum] = ACTIONS(103),
  },
  [37] = {
    [sym_export_statement] = STATE(756),
    [sym_declaration] = STATE(756),
    [sym_import] = STATE(1844),
    [sym_import_statement] = STATE(756),
    [sym_expression_statement] = STATE(756),
    [sym_variable_declaration] = STATE(741),
    [sym_lexical_declaration] = STATE(741),
    [sym_statement_block] = STATE(756),
    [sym_if_statement] = STATE(756),
    [sym_switch_statement] = STATE(756),
    [sym_for_statement] = STATE(756),
    [sym_for_in_statement] = STATE(756),
    [sym_while_statement] = STATE(756),
    [sym_do_statement] = STATE(756),
    [sym_try_statement] = STATE(756),
    [sym_with_statement] = STATE(756),
    [sym_break_statement] = STATE(756),
    [sym_continue_statement] = STATE(756),
    [sym_debugger_statement] = STATE(756),
    [sym_return_statement] = STATE(756),
    [sym_throw_statement] = STATE(756),
    [sym_empty_statement] = STATE(756),
    [sym_labeled_statement] = STATE(756),
    [sym_parenthesized_expression] = STATE(1116),
    [sym_expression] = STATE(1697),
    [sym_primary_expression] = STATE(1799),
    [sym_yield_expression] = STATE(1798),
    [sym_object] = STATE(1844),
    [sym_object_pattern] = STATE(4170),
    [sym_array] = STATE(1844),
    [sym_array_pattern] = STATE(4170),
    [sym_class] = STATE(1844),
    [sym_class_declaration] = STATE(741),
    [sym_function] = STATE(1844),
    [sym_function_declaration] = STATE(741),
    [sym_generator_function] = STATE(1844),
    [sym_generator_function_declaration] = STATE(741),
    [sym_arrow_function] = STATE(1844),
    [sym__call_signature] = STATE(4172),
    [sym_call_expression] = STATE(1844),
    [sym_new_expression] = STATE(1798),
    [sym_await_expression] = STATE(1798),
    [sym_member_expression] = STATE(1116),
    [sym_subscript_expression] = STATE(1116),
    [sym_assignment_expression] = STATE(1798),
    [sym__augmented_assignment_lhs] = STATE(2357),
    [sym_augmented_assignment_expression] = STATE(1798),
    [sym__destructuring_pattern] = STATE(4170),
    [sym_ternary_expression] = STATE(1798),
    [sym_binary_expression] = STATE(1798),
    [sym_unary_expression] = STATE(1798),
    [sym_update_expression] = STATE(1798),
    [sym_sequence_expression] = STATE(3662),
    [sym_string] = STATE(1844),
    [sym_template_string] = STATE(1844),
    [sym_regex] = STATE(1844),
    [sym_meta_property] = STATE(1844),
    [sym_decorator] = STATE(1149),
    [sym_formal_parameters] = STATE(2903),
    [sym_non_null_expression] = STATE(1116),
    [sym_function_signature] = STATE(741),
    [sym_type_assertion] = STATE(1798),
    [sym_as_expression] = STATE(1798),
    [sym_ambient_declaration] = STATE(741),
    [sym_abstract_class_declaration] = STATE(741),
    [sym_module] = STATE(741),
    [sym_internal_module] = STATE(1746),
    [sym_import_alias] = STATE(741),
    [sym_interface_declaration] = STATE(741),
    [sym_enum_declaration] = STATE(741),
    [sym_type_alias_declaration] = STATE(741),
    [sym_type_arguments] = STATE(482),
    [sym_type_parameters] = STATE(3670),
    [aux_sym_export_statement_repeat1] = STATE(2949),
    [sym_identifier] = ACTIONS(503),
    [anon_sym_export] = ACTIONS(505),
    [anon_sym_type] = ACTIONS(507),
    [anon_sym_namespace] = ACTIONS(509),
    [anon_sym_LBRACE] = ACTIONS(511),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(513),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_for] = ACTIONS(515),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_await] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(517),
    [anon_sym_do] = ACTIONS(43),
    [anon_sym_try] = ACTIONS(45),
    [anon_sym_with] = ACTIONS(519),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_debugger] = ACTIONS(53),
    [anon_sym_return] = ACTIONS(55),
    [anon_sym_throw] = ACTIONS(57),
    [anon_sym_SEMI] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(521),
    [anon_sym_async] = ACTIONS(523),
    [anon_sym_function] = ACTIONS(525),
    [anon_sym_new] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_void] = ACTIONS(19),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(77),
    [anon_sym_DASH_DASH] = ACTIONS(77),
    [anon_sym_DQUOTE] = ACTIONS(79),
    [anon_sym_SQUOTE] = ACTIONS(81),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(83),
    [sym_number] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(527),
    [anon_sym_readonly] = ACTIONS(527),
    [anon_sym_get] = ACTIONS(527),
    [anon_sym_set] = ACTIONS(527),
    [anon_sym_declare] = ACTIONS(529),
    [anon_sym_public] = ACTIONS(527),
    [anon_sym_private] = ACTIONS(527),
    [anon_sym_protected] = ACTIONS(527),
    [anon_sym_override] = ACTIONS(527),
    [anon_sym_module] = ACTIONS(531),
    [anon_sym_any] = ACTIONS(527),
    [anon_sym_number] = ACTIONS(527),
    [anon_sym_boolean] = ACTIONS(527),
    [anon_sym_string] = ACTIONS(527),
    [anon_sym_symbol] = ACTIONS(527),
    [anon_sym_abstract] = ACTIONS(99),
    [anon_sym_interface] = ACTIONS(101),
    [anon_sym_enum] = ACTIONS(103),
  },
  [38] = {
    [sym_export_statement] = STATE(722),
    [sym_declaration] = STATE(722),
    [sym_import] = STATE(1844),
    [sym_import_statement] = STATE(722),
    [sym_expression_statement] = STATE(722),
    [sym_variable_declaration] = STATE(741),
    [sym_lexical_declaration] = STATE(741),
    [sym_statement_block] = STATE(722),
    [sym_if_statement] = STATE(722),
    [sym_switch_statement] = STATE(722),
    [sym_for_statement] = STATE(722),
    [sym_for_in_statement] = STATE(722),
    [sym_while_statement] = STATE(722),
    [sym_do_statement] = STATE(722),
    [sym_try_statement] = STATE(722),
    [sym_with_statement] = STATE(722),
    [sym_break_statement] = STATE(722),
    [sym_continue_statement] = STATE(722),
    [sym_debugger_statement] = STATE(722),
    [sym_return_statement] = STATE(722),
    [sym_throw_statement] = STATE(722),
    [sym_empty_statement] = STATE(722),
    [sym_labeled_statement] = STATE(722),
    [sym_parenthesized_expression] = STATE(1116),
    [sym_expression] = STATE(1697),
    [sym_primary_expression] = STATE(1799),
    [sym_yield_expression] = STATE(1798),
    [sym_object] = STATE(1844),
    [sym_object_pattern] = STATE(4170),
    [sym_array] = STATE(1844),
    [sym_array_pattern] = STATE(4170),
    [sym_class] = STATE(1844),
    [sym_class_declaration] = STATE(741),
    [sym_function] = STATE(1844),
    [sym_function_declaration] = STATE(741),
    [sym_generator_function] = STATE(1844),
    [sym_generator_function_declaration] = STATE(741),
    [sym_arrow_function] = STATE(1844),
    [sym__call_signature] = STATE(4172),
    [sym_call_expression] = STATE(1844),
    [sym_new_expression] = STATE(1798),
    [sym_await_expression] = STATE(1798),
    [sym_member_expression] = STATE(1116),
    [sym_subscript_expression] = STATE(1116),
    [sym_assignment_expression] = STATE(1798),
    [sym__augmented_assignment_lhs] = STATE(2357),
    [sym_augmented_assignment_expression] = STATE(1798),
    [sym__destructuring_pattern] = STATE(4170),
    [sym_ternary_expression] = STATE(1798),
    [sym_binary_expression] = STATE(1798),
    [sym_unary_expression] = STATE(1798),
    [sym_update_expression] = STATE(1798),
    [sym_sequence_expression] = STATE(3662),
    [sym_string] = STATE(1844),
    [sym_template_string] = STATE(1844),
    [sym_regex] = STATE(1844),
    [sym_meta_property] = STATE(1844),
    [sym_decorator] = STATE(1149),
    [sym_formal_parameters] = STATE(2903),
    [sym_non_null_expression] = STATE(1116),
    [sym_function_signature] = STATE(741),
    [sym_type_assertion] = STATE(1798),
    [sym_as_expression] = STATE(1798),
    [sym_ambient_declaration] = STATE(741),
    [sym_abstract_class_declaration] = STATE(741),
    [sym_module] = STATE(741),
    [sym_internal_module] = STATE(1746),
    [sym_import_alias] = STATE(741),
    [sym_interface_declaration] = STATE(741),
    [sym_enum_declaration] = STATE(741),
    [sym_type_alias_declaration] = STATE(741),
    [sym_type_arguments] = STATE(482),
    [sym_type_parameters] = STATE(3670),
    [aux_sym_export_statement_repeat1] = STATE(2949),
    [sym_identifier] = ACTIONS(503),
    [anon_sym_export] = ACTIONS(505),
    [anon_sym_type] = ACTIONS(507),
    [anon_sym_namespace] = ACTIONS(509),
    [anon_sym_LBRACE] = ACTIONS(511),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(513),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_for] = ACTIONS(515),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_await] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(517),
    [anon_sym_do] = ACTIONS(43),
    [anon_sym_try] = ACTIONS(45),
    [anon_sym_with] = ACTIONS(519),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_debugger] = ACTIONS(53),
    [anon_sym_return] = ACTIONS(55),
    [anon_sym_throw] = ACTIONS(57),
    [anon_sym_SEMI] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(521),
    [anon_sym_async] = ACTIONS(523),
    [anon_sym_function] = ACTIONS(525),
    [anon_sym_new] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_void] = ACTIONS(19),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(77),
    [anon_sym_DASH_DASH] = ACTIONS(77),
    [anon_sym_DQUOTE] = ACTIONS(79),
    [anon_sym_SQUOTE] = ACTIONS(81),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(83),
    [sym_number] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(527),
    [anon_sym_readonly] = ACTIONS(527),
    [anon_sym_get] = ACTIONS(527),
    [anon_sym_set] = ACTIONS(527),
    [anon_sym_declare] = ACTIONS(529),
    [anon_sym_public] = ACTIONS(527),
    [anon_sym_private] = ACTIONS(527),
    [anon_sym_protected] = ACTIONS(527),
    [anon_sym_override] = ACTIONS(527),
    [anon_sym_module] = ACTIONS(531),
    [anon_sym_any] = ACTIONS(527),
    [anon_sym_number] = ACTIONS(527),
    [anon_sym_boolean] = ACTIONS(527),
    [anon_sym_string] = ACTIONS(527),
    [anon_sym_symbol] = ACTIONS(527),
    [anon_sym_abstract] = ACTIONS(99),
    [anon_sym_interface] = ACTIONS(101),
    [anon_sym_enum] = ACTIONS(103),
  },
  [39] = {
    [sym_export_statement] = STATE(754),
    [sym_declaration] = STATE(754),
    [sym_import] = STATE(1844),
    [sym_import_statement] = STATE(754),
    [sym_expression_statement] = STATE(754),
    [sym_variable_declaration] = STATE(741),
    [sym_lexical_declaration] = STATE(741),
    [sym_statement_block] = STATE(754),
    [sym_if_statement] = STATE(754),
    [sym_switch_statement] = STATE(754),
    [sym_for_statement] = STATE(754),
    [sym_for_in_statement] = STATE(754),
    [sym_while_statement] = STATE(754),
    [sym_do_statement] = STATE(754),
    [sym_try_statement] = STATE(754),
    [sym_with_statement] = STATE(754),
    [sym_break_statement] = STATE(754),
    [sym_continue_statement] = STATE(754),
    [sym_debugger_statement] = STATE(754),
    [sym_return_statement] = STATE(754),
    [sym_throw_statement] = STATE(754),
    [sym_empty_statement] = STATE(754),
    [sym_labeled_statement] = STATE(754),
    [sym_parenthesized_expression] = STATE(1116),
    [sym_expression] = STATE(1697),
    [sym_primary_expression] = STATE(1799),
    [sym_yield_expression] = STATE(1798),
    [sym_object] = STATE(1844),
    [sym_object_pattern] = STATE(4170),
    [sym_array] = STATE(1844),
    [sym_array_pattern] = STATE(4170),
    [sym_class] = STATE(1844),
    [sym_class_declaration] = STATE(741),
    [sym_function] = STATE(1844),
    [sym_function_declaration] = STATE(741),
    [sym_generator_function] = STATE(1844),
    [sym_generator_function_declaration] = STATE(741),
    [sym_arrow_function] = STATE(1844),
    [sym__call_signature] = STATE(4172),
    [sym_call_expression] = STATE(1844),
    [sym_new_expression] = STATE(1798),
    [sym_await_expression] = STATE(1798),
    [sym_member_expression] = STATE(1116),
    [sym_subscript_expression] = STATE(1116),
    [sym_assignment_expression] = STATE(1798),
    [sym__augmented_assignment_lhs] = STATE(2357),
    [sym_augmented_assignment_expression] = STATE(1798),
    [sym__destructuring_pattern] = STATE(4170),
    [sym_ternary_expression] = STATE(1798),
    [sym_binary_expression] = STATE(1798),
    [sym_unary_expression] = STATE(1798),
    [sym_update_expression] = STATE(1798),
    [sym_sequence_expression] = STATE(3662),
    [sym_string] = STATE(1844),
    [sym_template_string] = STATE(1844),
    [sym_regex] = STATE(1844),
    [sym_meta_property] = STATE(1844),
    [sym_decorator] = STATE(1149),
    [sym_formal_parameters] = STATE(2903),
    [sym_non_null_expression] = STATE(1116),
    [sym_function_signature] = STATE(741),
    [sym_type_assertion] = STATE(1798),
    [sym_as_expression] = STATE(1798),
    [sym_ambient_declaration] = STATE(741),
    [sym_abstract_class_declaration] = STATE(741),
    [sym_module] = STATE(741),
    [sym_internal_module] = STATE(140),
    [sym_import_alias] = STATE(741),
    [sym_interface_declaration] = STATE(741),
    [sym_enum_declaration] = STATE(741),
    [sym_type_alias_declaration] = STATE(741),
    [sym_type_arguments] = STATE(482),
    [sym_type_parameters] = STATE(3670),
    [aux_sym_export_statement_repeat1] = STATE(2947),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_type] = ACTIONS(13),
    [anon_sym_namespace] = ACTIONS(15),
    [anon_sym_LBRACE] = ACTIONS(17),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_for] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_await] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(41),
    [anon_sym_do] = ACTIONS(43),
    [anon_sym_try] = ACTIONS(45),
    [anon_sym_with] = ACTIONS(47),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_debugger] = ACTIONS(53),
    [anon_sym_return] = ACTIONS(55),
    [anon_sym_throw] = ACTIONS(57),
    [anon_sym_SEMI] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(69),
    [anon_sym_async] = ACTIONS(71),
    [anon_sym_function] = ACTIONS(73),
    [anon_sym_new] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_void] = ACTIONS(19),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(77),
    [anon_sym_DASH_DASH] = ACTIONS(77),
    [anon_sym_DQUOTE] = ACTIONS(79),
    [anon_sym_SQUOTE] = ACTIONS(81),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(83),
    [sym_number] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(93),
    [anon_sym_readonly] = ACTIONS(93),
    [anon_sym_get] = ACTIONS(93),
    [anon_sym_set] = ACTIONS(93),
    [anon_sym_declare] = ACTIONS(95),
    [anon_sym_public] = ACTIONS(93),
    [anon_sym_private] = ACTIONS(93),
    [anon_sym_protected] = ACTIONS(93),
    [anon_sym_override] = ACTIONS(93),
    [anon_sym_module] = ACTIONS(97),
    [anon_sym_any] = ACTIONS(93),
    [anon_sym_number] = ACTIONS(93),
    [anon_sym_boolean] = ACTIONS(93),
    [anon_sym_string] = ACTIONS(93),
    [anon_sym_symbol] = ACTIONS(93),
    [anon_sym_abstract] = ACTIONS(99),
    [anon_sym_interface] = ACTIONS(101),
    [anon_sym_enum] = ACTIONS(103),
  },
  [40] = {
    [sym_export_statement] = STATE(721),
    [sym_declaration] = STATE(721),
    [sym_import] = STATE(1844),
    [sym_import_statement] = STATE(721),
    [sym_expression_statement] = STATE(721),
    [sym_variable_declaration] = STATE(741),
    [sym_lexical_declaration] = STATE(741),
    [sym_statement_block] = STATE(721),
    [sym_if_statement] = STATE(721),
    [sym_switch_statement] = STATE(721),
    [sym_for_statement] = STATE(721),
    [sym_for_in_statement] = STATE(721),
    [sym_while_statement] = STATE(721),
    [sym_do_statement] = STATE(721),
    [sym_try_statement] = STATE(721),
    [sym_with_statement] = STATE(721),
    [sym_break_statement] = STATE(721),
    [sym_continue_statement] = STATE(721),
    [sym_debugger_statement] = STATE(721),
    [sym_return_statement] = STATE(721),
    [sym_throw_statement] = STATE(721),
    [sym_empty_statement] = STATE(721),
    [sym_labeled_statement] = STATE(721),
    [sym_parenthesized_expression] = STATE(1116),
    [sym_expression] = STATE(1697),
    [sym_primary_expression] = STATE(1799),
    [sym_yield_expression] = STATE(1798),
    [sym_object] = STATE(1844),
    [sym_object_pattern] = STATE(4170),
    [sym_array] = STATE(1844),
    [sym_array_pattern] = STATE(4170),
    [sym_class] = STATE(1844),
    [sym_class_declaration] = STATE(741),
    [sym_function] = STATE(1844),
    [sym_function_declaration] = STATE(741),
    [sym_generator_function] = STATE(1844),
    [sym_generator_function_declaration] = STATE(741),
    [sym_arrow_function] = STATE(1844),
    [sym__call_signature] = STATE(4172),
    [sym_call_expression] = STATE(1844),
    [sym_new_expression] = STATE(1798),
    [sym_await_expression] = STATE(1798),
    [sym_member_expression] = STATE(1116),
    [sym_subscript_expression] = STATE(1116),
    [sym_assignment_expression] = STATE(1798),
    [sym__augmented_assignment_lhs] = STATE(2357),
    [sym_augmented_assignment_expression] = STATE(1798),
    [sym__destructuring_pattern] = STATE(4170),
    [sym_ternary_expression] = STATE(1798),
    [sym_binary_expression] = STATE(1798),
    [sym_unary_expression] = STATE(1798),
    [sym_update_expression] = STATE(1798),
    [sym_sequence_expression] = STATE(3662),
    [sym_string] = STATE(1844),
    [sym_template_string] = STATE(1844),
    [sym_regex] = STATE(1844),
    [sym_meta_property] = STATE(1844),
    [sym_decorator] = STATE(1149),
    [sym_formal_parameters] = STATE(2903),
    [sym_non_null_expression] = STATE(1116),
    [sym_function_signature] = STATE(741),
    [sym_type_assertion] = STATE(1798),
    [sym_as_expression] = STATE(1798),
    [sym_ambient_declaration] = STATE(741),
    [sym_abstract_class_declaration] = STATE(741),
    [sym_module] = STATE(741),
    [sym_internal_module] = STATE(1746),
    [sym_import_alias] = STATE(741),
    [sym_interface_declaration] = STATE(741),
    [sym_enum_declaration] = STATE(741),
    [sym_type_alias_declaration] = STATE(741),
    [sym_type_arguments] = STATE(482),
    [sym_type_parameters] = STATE(3670),
    [aux_sym_export_statement_repeat1] = STATE(2949),
    [sym_identifier] = ACTIONS(503),
    [anon_sym_export] = ACTIONS(505),
    [anon_sym_type] = ACTIONS(507),
    [anon_sym_namespace] = ACTIONS(509),
    [anon_sym_LBRACE] = ACTIONS(511),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(513),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_for] = ACTIONS(515),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_await] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(517),
    [anon_sym_do] = ACTIONS(43),
    [anon_sym_try] = ACTIONS(45),
    [anon_sym_with] = ACTIONS(519),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_debugger] = ACTIONS(53),
    [anon_sym_return] = ACTIONS(55),
    [anon_sym_throw] = ACTIONS(57),
    [anon_sym_SEMI] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(521),
    [anon_sym_async] = ACTIONS(523),
    [anon_sym_function] = ACTIONS(525),
    [anon_sym_new] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_void] = ACTIONS(19),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(77),
    [anon_sym_DASH_DASH] = ACTIONS(77),
    [anon_sym_DQUOTE] = ACTIONS(79),
    [anon_sym_SQUOTE] = ACTIONS(81),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(83),
    [sym_number] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(527),
    [anon_sym_readonly] = ACTIONS(527),
    [anon_sym_get] = ACTIONS(527),
    [anon_sym_set] = ACTIONS(527),
    [anon_sym_declare] = ACTIONS(529),
    [anon_sym_public] = ACTIONS(527),
    [anon_sym_private] = ACTIONS(527),
    [anon_sym_protected] = ACTIONS(527),
    [anon_sym_override] = ACTIONS(527),
    [anon_sym_module] = ACTIONS(531),
    [anon_sym_any] = ACTIONS(527),
    [anon_sym_number] = ACTIONS(527),
    [anon_sym_boolean] = ACTIONS(527),
    [anon_sym_string] = ACTIONS(527),
    [anon_sym_symbol] = ACTIONS(527),
    [anon_sym_abstract] = ACTIONS(99),
    [anon_sym_interface] = ACTIONS(101),
    [anon_sym_enum] = ACTIONS(103),
  },
  [41] = {
    [sym_export_statement] = STATE(604),
    [sym_declaration] = STATE(604),
    [sym_import] = STATE(1844),
    [sym_import_statement] = STATE(604),
    [sym_expression_statement] = STATE(604),
    [sym_variable_declaration] = STATE(741),
    [sym_lexical_declaration] = STATE(741),
    [sym_statement_block] = STATE(604),
    [sym_if_statement] = STATE(604),
    [sym_switch_statement] = STATE(604),
    [sym_for_statement] = STATE(604),
    [sym_for_in_statement] = STATE(604),
    [sym_while_statement] = STATE(604),
    [sym_do_statement] = STATE(604),
    [sym_try_statement] = STATE(604),
    [sym_with_statement] = STATE(604),
    [sym_break_statement] = STATE(604),
    [sym_continue_statement] = STATE(604),
    [sym_debugger_statement] = STATE(604),
    [sym_return_statement] = STATE(604),
    [sym_throw_statement] = STATE(604),
    [sym_empty_statement] = STATE(604),
    [sym_labeled_statement] = STATE(604),
    [sym_parenthesized_expression] = STATE(1116),
    [sym_expression] = STATE(1697),
    [sym_primary_expression] = STATE(1799),
    [sym_yield_expression] = STATE(1798),
    [sym_object] = STATE(1844),
    [sym_object_pattern] = STATE(4170),
    [sym_array] = STATE(1844),
    [sym_array_pattern] = STATE(4170),
    [sym_class] = STATE(1844),
    [sym_class_declaration] = STATE(741),
    [sym_function] = STATE(1844),
    [sym_function_declaration] = STATE(741),
    [sym_generator_function] = STATE(1844),
    [sym_generator_function_declaration] = STATE(741),
    [sym_arrow_function] = STATE(1844),
    [sym__call_signature] = STATE(4172),
    [sym_call_expression] = STATE(1844),
    [sym_new_expression] = STATE(1798),
    [sym_await_expression] = STATE(1798),
    [sym_member_expression] = STATE(1116),
    [sym_subscript_expression] = STATE(1116),
    [sym_assignment_expression] = STATE(1798),
    [sym__augmented_assignment_lhs] = STATE(2357),
    [sym_augmented_assignment_expression] = STATE(1798),
    [sym__destructuring_pattern] = STATE(4170),
    [sym_ternary_expression] = STATE(1798),
    [sym_binary_expression] = STATE(1798),
    [sym_unary_expression] = STATE(1798),
    [sym_update_expression] = STATE(1798),
    [sym_sequence_expression] = STATE(3662),
    [sym_string] = STATE(1844),
    [sym_template_string] = STATE(1844),
    [sym_regex] = STATE(1844),
    [sym_meta_property] = STATE(1844),
    [sym_decorator] = STATE(1149),
    [sym_formal_parameters] = STATE(2903),
    [sym_non_null_expression] = STATE(1116),
    [sym_function_signature] = STATE(741),
    [sym_type_assertion] = STATE(1798),
    [sym_as_expression] = STATE(1798),
    [sym_ambient_declaration] = STATE(741),
    [sym_abstract_class_declaration] = STATE(741),
    [sym_module] = STATE(741),
    [sym_internal_module] = STATE(140),
    [sym_import_alias] = STATE(741),
    [sym_interface_declaration] = STATE(741),
    [sym_enum_declaration] = STATE(741),
    [sym_type_alias_declaration] = STATE(741),
    [sym_type_arguments] = STATE(482),
    [sym_type_parameters] = STATE(3670),
    [aux_sym_export_statement_repeat1] = STATE(2947),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_type] = ACTIONS(13),
    [anon_sym_namespace] = ACTIONS(15),
    [anon_sym_LBRACE] = ACTIONS(17),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_for] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_await] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(41),
    [anon_sym_do] = ACTIONS(43),
    [anon_sym_try] = ACTIONS(45),
    [anon_sym_with] = ACTIONS(47),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_debugger] = ACTIONS(53),
    [anon_sym_return] = ACTIONS(55),
    [anon_sym_throw] = ACTIONS(57),
    [anon_sym_SEMI] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(69),
    [anon_sym_async] = ACTIONS(71),
    [anon_sym_function] = ACTIONS(73),
    [anon_sym_new] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_void] = ACTIONS(19),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(77),
    [anon_sym_DASH_DASH] = ACTIONS(77),
    [anon_sym_DQUOTE] = ACTIONS(79),
    [anon_sym_SQUOTE] = ACTIONS(81),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(83),
    [sym_number] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(93),
    [anon_sym_readonly] = ACTIONS(93),
    [anon_sym_get] = ACTIONS(93),
    [anon_sym_set] = ACTIONS(93),
    [anon_sym_declare] = ACTIONS(95),
    [anon_sym_public] = ACTIONS(93),
    [anon_sym_private] = ACTIONS(93),
    [anon_sym_protected] = ACTIONS(93),
    [anon_sym_override] = ACTIONS(93),
    [anon_sym_module] = ACTIONS(97),
    [anon_sym_any] = ACTIONS(93),
    [anon_sym_number] = ACTIONS(93),
    [anon_sym_boolean] = ACTIONS(93),
    [anon_sym_string] = ACTIONS(93),
    [anon_sym_symbol] = ACTIONS(93),
    [anon_sym_abstract] = ACTIONS(99),
    [anon_sym_interface] = ACTIONS(101),
    [anon_sym_enum] = ACTIONS(103),
  },
  [42] = {
    [sym_export_statement] = STATE(4096),
    [sym_declaration] = STATE(4096),
    [sym_import] = STATE(1844),
    [sym_import_statement] = STATE(4096),
    [sym_expression_statement] = STATE(4096),
    [sym_variable_declaration] = STATE(741),
    [sym_lexical_declaration] = STATE(741),
    [sym_statement_block] = STATE(4096),
    [sym_if_statement] = STATE(4096),
    [sym_switch_statement] = STATE(4096),
    [sym_for_statement] = STATE(4096),
    [sym_for_in_statement] = STATE(4096),
    [sym_while_statement] = STATE(4096),
    [sym_do_statement] = STATE(4096),
    [sym_try_statement] = STATE(4096),
    [sym_with_statement] = STATE(4096),
    [sym_break_statement] = STATE(4096),
    [sym_continue_statement] = STATE(4096),
    [sym_debugger_statement] = STATE(4096),
    [sym_return_statement] = STATE(4096),
    [sym_throw_statement] = STATE(4096),
    [sym_empty_statement] = STATE(4096),
    [sym_labeled_statement] = STATE(4096),
    [sym_parenthesized_expression] = STATE(1116),
    [sym_expression] = STATE(1697),
    [sym_primary_expression] = STATE(1799),
    [sym_yield_expression] = STATE(1798),
    [sym_object] = STATE(1844),
    [sym_object_pattern] = STATE(4170),
    [sym_array] = STATE(1844),
    [sym_array_pattern] = STATE(4170),
    [sym_class] = STATE(1844),
    [sym_class_declaration] = STATE(741),
    [sym_function] = STATE(1844),
    [sym_function_declaration] = STATE(741),
    [sym_generator_function] = STATE(1844),
    [sym_generator_function_declaration] = STATE(741),
    [sym_arrow_function] = STATE(1844),
    [sym__call_signature] = STATE(4172),
    [sym_call_expression] = STATE(1844),
    [sym_new_expression] = STATE(1798),
    [sym_await_expression] = STATE(1798),
    [sym_member_expression] = STATE(1116),
    [sym_subscript_expression] = STATE(1116),
    [sym_assignment_expression] = STATE(1798),
    [sym__augmented_assignment_lhs] = STATE(2357),
    [sym_augmented_assignment_expression] = STATE(1798),
    [sym__destructuring_pattern] = STATE(4170),
    [sym_ternary_expression] = STATE(1798),
    [sym_binary_expression] = STATE(1798),
    [sym_unary_expression] = STATE(1798),
    [sym_update_expression] = STATE(1798),
    [sym_sequence_expression] = STATE(3662),
    [sym_string] = STATE(1844),
    [sym_template_string] = STATE(1844),
    [sym_regex] = STATE(1844),
    [sym_meta_property] = STATE(1844),
    [sym_decorator] = STATE(1149),
    [sym_formal_parameters] = STATE(2903),
    [sym_non_null_expression] = STATE(1116),
    [sym_function_signature] = STATE(741),
    [sym_type_assertion] = STATE(1798),
    [sym_as_expression] = STATE(1798),
    [sym_ambient_declaration] = STATE(741),
    [sym_abstract_class_declaration] = STATE(741),
    [sym_module] = STATE(741),
    [sym_internal_module] = STATE(1746),
    [sym_import_alias] = STATE(741),
    [sym_interface_declaration] = STATE(741),
    [sym_enum_declaration] = STATE(741),
    [sym_type_alias_declaration] = STATE(741),
    [sym_type_arguments] = STATE(482),
    [sym_type_parameters] = STATE(3670),
    [aux_sym_export_statement_repeat1] = STATE(2949),
    [sym_identifier] = ACTIONS(503),
    [anon_sym_export] = ACTIONS(505),
    [anon_sym_type] = ACTIONS(507),
    [anon_sym_namespace] = ACTIONS(509),
    [anon_sym_LBRACE] = ACTIONS(511),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(513),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_for] = ACTIONS(515),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_await] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(517),
    [anon_sym_do] = ACTIONS(43),
    [anon_sym_try] = ACTIONS(45),
    [anon_sym_with] = ACTIONS(519),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_debugger] = ACTIONS(53),
    [anon_sym_return] = ACTIONS(55),
    [anon_sym_throw] = ACTIONS(57),
    [anon_sym_SEMI] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(521),
    [anon_sym_async] = ACTIONS(523),
    [anon_sym_function] = ACTIONS(525),
    [anon_sym_new] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_void] = ACTIONS(19),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(77),
    [anon_sym_DASH_DASH] = ACTIONS(77),
    [anon_sym_DQUOTE] = ACTIONS(79),
    [anon_sym_SQUOTE] = ACTIONS(81),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(83),
    [sym_number] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(527),
    [anon_sym_readonly] = ACTIONS(527),
    [anon_sym_get] = ACTIONS(527),
    [anon_sym_set] = ACTIONS(527),
    [anon_sym_declare] = ACTIONS(529),
    [anon_sym_public] = ACTIONS(527),
    [anon_sym_private] = ACTIONS(527),
    [anon_sym_protected] = ACTIONS(527),
    [anon_sym_override] = ACTIONS(527),
    [anon_sym_module] = ACTIONS(531),
    [anon_sym_any] = ACTIONS(527),
    [anon_sym_number] = ACTIONS(527),
    [anon_sym_boolean] = ACTIONS(527),
    [anon_sym_string] = ACTIONS(527),
    [anon_sym_symbol] = ACTIONS(527),
    [anon_sym_abstract] = ACTIONS(99),
    [anon_sym_interface] = ACTIONS(101),
    [anon_sym_enum] = ACTIONS(103),
  },
  [43] = {
    [sym_export_statement] = STATE(620),
    [sym_declaration] = STATE(621),
    [sym_import] = STATE(1844),
    [sym_import_statement] = STATE(674),
    [sym_expression_statement] = STATE(675),
    [sym_variable_declaration] = STATE(741),
    [sym_lexical_declaration] = STATE(741),
    [sym_statement_block] = STATE(676),
    [sym_if_statement] = STATE(677),
    [sym_switch_statement] = STATE(679),
    [sym_for_statement] = STATE(680),
    [sym_for_in_statement] = STATE(681),
    [sym_while_statement] = STATE(686),
    [sym_do_statement] = STATE(687),
    [sym_try_statement] = STATE(690),
    [sym_with_statement] = STATE(692),
    [sym_break_statement] = STATE(696),
    [sym_continue_statement] = STATE(720),
    [sym_debugger_statement] = STATE(727),
    [sym_return_statement] = STATE(730),
    [sym_throw_statement] = STATE(736),
    [sym_empty_statement] = STATE(739),
    [sym_labeled_statement] = STATE(744),
    [sym_parenthesized_expression] = STATE(1116),
    [sym_expression] = STATE(1697),
    [sym_primary_expression] = STATE(1799),
    [sym_yield_expression] = STATE(1798),
    [sym_object] = STATE(1844),
    [sym_object_pattern] = STATE(4170),
    [sym_array] = STATE(1844),
    [sym_array_pattern] = STATE(4170),
    [sym_class] = STATE(1844),
    [sym_class_declaration] = STATE(741),
    [sym_function] = STATE(1844),
    [sym_function_declaration] = STATE(741),
    [sym_generator_function] = STATE(1844),
    [sym_generator_function_declaration] = STATE(741),
    [sym_arrow_function] = STATE(1844),
    [sym__call_signature] = STATE(4172),
    [sym_call_expression] = STATE(1844),
    [sym_new_expression] = STATE(1798),
    [sym_await_expression] = STATE(1798),
    [sym_member_expression] = STATE(1116),
    [sym_subscript_expression] = STATE(1116),
    [sym_assignment_expression] = STATE(1798),
    [sym__augmented_assignment_lhs] = STATE(2357),
    [sym_augmented_assignment_expression] = STATE(1798),
    [sym__destructuring_pattern] = STATE(4170),
    [sym_ternary_expression] = STATE(1798),
    [sym_binary_expression] = STATE(1798),
    [sym_unary_expression] = STATE(1798),
    [sym_update_expression] = STATE(1798),
    [sym_sequence_expression] = STATE(3662),
    [sym_string] = STATE(1844),
    [sym_template_string] = STATE(1844),
    [sym_regex] = STATE(1844),
    [sym_meta_property] = STATE(1844),
    [sym_decorator] = STATE(1149),
    [sym_formal_parameters] = STATE(2903),
    [sym_non_null_expression] = STATE(1116),
    [sym_function_signature] = STATE(741),
    [sym_type_assertion] = STATE(1798),
    [sym_as_expression] = STATE(1798),
    [sym_ambient_declaration] = STATE(741),
    [sym_abstract_class_declaration] = STATE(741),
    [sym_module] = STATE(741),
    [sym_internal_module] = STATE(140),
    [sym_import_alias] = STATE(741),
    [sym_interface_declaration] = STATE(741),
    [sym_enum_declaration] = STATE(741),
    [sym_type_alias_declaration] = STATE(741),
    [sym_type_arguments] = STATE(482),
    [sym_type_parameters] = STATE(3670),
    [aux_sym_export_statement_repeat1] = STATE(2947),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_type] = ACTIONS(13),
    [anon_sym_namespace] = ACTIONS(15),
    [anon_sym_LBRACE] = ACTIONS(17),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_for] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_await] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(41),
    [anon_sym_do] = ACTIONS(43),
    [anon_sym_try] = ACTIONS(45),
    [anon_sym_with] = ACTIONS(47),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_debugger] = ACTIONS(53),
    [anon_sym_return] = ACTIONS(55),
    [anon_sym_throw] = ACTIONS(57),
    [anon_sym_SEMI] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(69),
    [anon_sym_async] = ACTIONS(71),
    [anon_sym_function] = ACTIONS(73),
    [anon_sym_new] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_void] = ACTIONS(19),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(77),
    [anon_sym_DASH_DASH] = ACTIONS(77),
    [anon_sym_DQUOTE] = ACTIONS(79),
    [anon_sym_SQUOTE] = ACTIONS(81),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(83),
    [sym_number] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(93),
    [anon_sym_readonly] = ACTIONS(93),
    [anon_sym_get] = ACTIONS(93),
    [anon_sym_set] = ACTIONS(93),
    [anon_sym_declare] = ACTIONS(95),
    [anon_sym_public] = ACTIONS(93),
    [anon_sym_private] = ACTIONS(93),
    [anon_sym_protected] = ACTIONS(93),
    [anon_sym_override] = ACTIONS(93),
    [anon_sym_module] = ACTIONS(97),
    [anon_sym_any] = ACTIONS(93),
    [anon_sym_number] = ACTIONS(93),
    [anon_sym_boolean] = ACTIONS(93),
    [anon_sym_string] = ACTIONS(93),
    [anon_sym_symbol] = ACTIONS(93),
    [anon_sym_abstract] = ACTIONS(99),
    [anon_sym_interface] = ACTIONS(101),
    [anon_sym_enum] = ACTIONS(103),
  },
  [44] = {
    [sym_export_statement] = STATE(672),
    [sym_declaration] = STATE(671),
    [sym_import] = STATE(1844),
    [sym_import_statement] = STATE(670),
    [sym_expression_statement] = STATE(668),
    [sym_variable_declaration] = STATE(741),
    [sym_lexical_declaration] = STATE(741),
    [sym_statement_block] = STATE(667),
    [sym_if_statement] = STATE(663),
    [sym_switch_statement] = STATE(662),
    [sym_for_statement] = STATE(656),
    [sym_for_in_statement] = STATE(653),
    [sym_while_statement] = STATE(649),
    [sym_do_statement] = STATE(648),
    [sym_try_statement] = STATE(646),
    [sym_with_statement] = STATE(642),
    [sym_break_statement] = STATE(636),
    [sym_continue_statement] = STATE(633),
    [sym_debugger_statement] = STATE(627),
    [sym_return_statement] = STATE(626),
    [sym_throw_statement] = STATE(625),
    [sym_empty_statement] = STATE(624),
    [sym_labeled_statement] = STATE(623),
    [sym_parenthesized_expression] = STATE(1116),
    [sym_expression] = STATE(1697),
    [sym_primary_expression] = STATE(1799),
    [sym_yield_expression] = STATE(1798),
    [sym_object] = STATE(1844),
    [sym_object_pattern] = STATE(4170),
    [sym_array] = STATE(1844),
    [sym_array_pattern] = STATE(4170),
    [sym_class] = STATE(1844),
    [sym_class_declaration] = STATE(741),
    [sym_function] = STATE(1844),
    [sym_function_declaration] = STATE(741),
    [sym_generator_function] = STATE(1844),
    [sym_generator_function_declaration] = STATE(741),
    [sym_arrow_function] = STATE(1844),
    [sym__call_signature] = STATE(4172),
    [sym_call_expression] = STATE(1844),
    [sym_new_expression] = STATE(1798),
    [sym_await_expression] = STATE(1798),
    [sym_member_expression] = STATE(1116),
    [sym_subscript_expression] = STATE(1116),
    [sym_assignment_expression] = STATE(1798),
    [sym__augmented_assignment_lhs] = STATE(2357),
    [sym_augmented_assignment_expression] = STATE(1798),
    [sym__destructuring_pattern] = STATE(4170),
    [sym_ternary_expression] = STATE(1798),
    [sym_binary_expression] = STATE(1798),
    [sym_unary_expression] = STATE(1798),
    [sym_update_expression] = STATE(1798),
    [sym_sequence_expression] = STATE(3662),
    [sym_string] = STATE(1844),
    [sym_template_string] = STATE(1844),
    [sym_regex] = STATE(1844),
    [sym_meta_property] = STATE(1844),
    [sym_decorator] = STATE(1149),
    [sym_formal_parameters] = STATE(2903),
    [sym_non_null_expression] = STATE(1116),
    [sym_function_signature] = STATE(741),
    [sym_type_assertion] = STATE(1798),
    [sym_as_expression] = STATE(1798),
    [sym_ambient_declaration] = STATE(741),
    [sym_abstract_class_declaration] = STATE(741),
    [sym_module] = STATE(741),
    [sym_internal_module] = STATE(1746),
    [sym_import_alias] = STATE(741),
    [sym_interface_declaration] = STATE(741),
    [sym_enum_declaration] = STATE(741),
    [sym_type_alias_declaration] = STATE(741),
    [sym_type_arguments] = STATE(482),
    [sym_type_parameters] = STATE(3670),
    [aux_sym_export_statement_repeat1] = STATE(2949),
    [sym_identifier] = ACTIONS(503),
    [anon_sym_export] = ACTIONS(505),
    [anon_sym_type] = ACTIONS(507),
    [anon_sym_namespace] = ACTIONS(509),
    [anon_sym_LBRACE] = ACTIONS(511),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(513),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_for] = ACTIONS(515),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_await] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(517),
    [anon_sym_do] = ACTIONS(43),
    [anon_sym_try] = ACTIONS(45),
    [anon_sym_with] = ACTIONS(519),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_debugger] = ACTIONS(53),
    [anon_sym_return] = ACTIONS(55),
    [anon_sym_throw] = ACTIONS(57),
    [anon_sym_SEMI] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(521),
    [anon_sym_async] = ACTIONS(523),
    [anon_sym_function] = ACTIONS(525),
    [anon_sym_new] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_void] = ACTIONS(19),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(77),
    [anon_sym_DASH_DASH] = ACTIONS(77),
    [anon_sym_DQUOTE] = ACTIONS(79),
    [anon_sym_SQUOTE] = ACTIONS(81),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(83),
    [sym_number] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(527),
    [anon_sym_readonly] = ACTIONS(527),
    [anon_sym_get] = ACTIONS(527),
    [anon_sym_set] = ACTIONS(527),
    [anon_sym_declare] = ACTIONS(529),
    [anon_sym_public] = ACTIONS(527),
    [anon_sym_private] = ACTIONS(527),
    [anon_sym_protected] = ACTIONS(527),
    [anon_sym_override] = ACTIONS(527),
    [anon_sym_module] = ACTIONS(531),
    [anon_sym_any] = ACTIONS(527),
    [anon_sym_number] = ACTIONS(527),
    [anon_sym_boolean] = ACTIONS(527),
    [anon_sym_string] = ACTIONS(527),
    [anon_sym_symbol] = ACTIONS(527),
    [anon_sym_abstract] = ACTIONS(99),
    [anon_sym_interface] = ACTIONS(101),
    [anon_sym_enum] = ACTIONS(103),
  },
  [45] = {
    [sym_export_statement] = STATE(660),
    [sym_declaration] = STATE(660),
    [sym_import] = STATE(1844),
    [sym_import_statement] = STATE(660),
    [sym_expression_statement] = STATE(660),
    [sym_variable_declaration] = STATE(741),
    [sym_lexical_declaration] = STATE(741),
    [sym_statement_block] = STATE(660),
    [sym_if_statement] = STATE(660),
    [sym_switch_statement] = STATE(660),
    [sym_for_statement] = STATE(660),
    [sym_for_in_statement] = STATE(660),
    [sym_while_statement] = STATE(660),
    [sym_do_statement] = STATE(660),
    [sym_try_statement] = STATE(660),
    [sym_with_statement] = STATE(660),
    [sym_break_statement] = STATE(660),
    [sym_continue_statement] = STATE(660),
    [sym_debugger_statement] = STATE(660),
    [sym_return_statement] = STATE(660),
    [sym_throw_statement] = STATE(660),
    [sym_empty_statement] = STATE(660),
    [sym_labeled_statement] = STATE(660),
    [sym_parenthesized_expression] = STATE(1116),
    [sym_expression] = STATE(1697),
    [sym_primary_expression] = STATE(1799),
    [sym_yield_expression] = STATE(1798),
    [sym_object] = STATE(1844),
    [sym_object_pattern] = STATE(4170),
    [sym_array] = STATE(1844),
    [sym_array_pattern] = STATE(4170),
    [sym_class] = STATE(1844),
    [sym_class_declaration] = STATE(741),
    [sym_function] = STATE(1844),
    [sym_function_declaration] = STATE(741),
    [sym_generator_function] = STATE(1844),
    [sym_generator_function_declaration] = STATE(741),
    [sym_arrow_function] = STATE(1844),
    [sym__call_signature] = STATE(4172),
    [sym_call_expression] = STATE(1844),
    [sym_new_expression] = STATE(1798),
    [sym_await_expression] = STATE(1798),
    [sym_member_expression] = STATE(1116),
    [sym_subscript_expression] = STATE(1116),
    [sym_assignment_expression] = STATE(1798),
    [sym__augmented_assignment_lhs] = STATE(2357),
    [sym_augmented_assignment_expression] = STATE(1798),
    [sym__destructuring_pattern] = STATE(4170),
    [sym_ternary_expression] = STATE(1798),
    [sym_binary_expression] = STATE(1798),
    [sym_unary_expression] = STATE(1798),
    [sym_update_expression] = STATE(1798),
    [sym_sequence_expression] = STATE(3662),
    [sym_string] = STATE(1844),
    [sym_template_string] = STATE(1844),
    [sym_regex] = STATE(1844),
    [sym_meta_property] = STATE(1844),
    [sym_decorator] = STATE(1149),
    [sym_formal_parameters] = STATE(2903),
    [sym_non_null_expression] = STATE(1116),
    [sym_function_signature] = STATE(741),
    [sym_type_assertion] = STATE(1798),
    [sym_as_expression] = STATE(1798),
    [sym_ambient_declaration] = STATE(741),
    [sym_abstract_class_declaration] = STATE(741),
    [sym_module] = STATE(741),
    [sym_internal_module] = STATE(1746),
    [sym_import_alias] = STATE(741),
    [sym_interface_declaration] = STATE(741),
    [sym_enum_declaration] = STATE(741),
    [sym_type_alias_declaration] = STATE(741),
    [sym_type_arguments] = STATE(482),
    [sym_type_parameters] = STATE(3670),
    [aux_sym_export_statement_repeat1] = STATE(2949),
    [sym_identifier] = ACTIONS(503),
    [anon_sym_export] = ACTIONS(505),
    [anon_sym_type] = ACTIONS(507),
    [anon_sym_namespace] = ACTIONS(509),
    [anon_sym_LBRACE] = ACTIONS(511),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(513),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_for] = ACTIONS(515),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_await] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(517),
    [anon_sym_do] = ACTIONS(43),
    [anon_sym_try] = ACTIONS(45),
    [anon_sym_with] = ACTIONS(519),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_debugger] = ACTIONS(53),
    [anon_sym_return] = ACTIONS(55),
    [anon_sym_throw] = ACTIONS(57),
    [anon_sym_SEMI] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(521),
    [anon_sym_async] = ACTIONS(523),
    [anon_sym_function] = ACTIONS(525),
    [anon_sym_new] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_void] = ACTIONS(19),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(77),
    [anon_sym_DASH_DASH] = ACTIONS(77),
    [anon_sym_DQUOTE] = ACTIONS(79),
    [anon_sym_SQUOTE] = ACTIONS(81),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(83),
    [sym_number] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(527),
    [anon_sym_readonly] = ACTIONS(527),
    [anon_sym_get] = ACTIONS(527),
    [anon_sym_set] = ACTIONS(527),
    [anon_sym_declare] = ACTIONS(529),
    [anon_sym_public] = ACTIONS(527),
    [anon_sym_private] = ACTIONS(527),
    [anon_sym_protected] = ACTIONS(527),
    [anon_sym_override] = ACTIONS(527),
    [anon_sym_module] = ACTIONS(531),
    [anon_sym_any] = ACTIONS(527),
    [anon_sym_number] = ACTIONS(527),
    [anon_sym_boolean] = ACTIONS(527),
    [anon_sym_string] = ACTIONS(527),
    [anon_sym_symbol] = ACTIONS(527),
    [anon_sym_abstract] = ACTIONS(99),
    [anon_sym_interface] = ACTIONS(101),
    [anon_sym_enum] = ACTIONS(103),
  },
  [46] = {
    [sym_export_statement] = STATE(673),
    [sym_declaration] = STATE(673),
    [sym_import] = STATE(1844),
    [sym_import_statement] = STATE(673),
    [sym_expression_statement] = STATE(673),
    [sym_variable_declaration] = STATE(741),
    [sym_lexical_declaration] = STATE(741),
    [sym_statement_block] = STATE(673),
    [sym_if_statement] = STATE(673),
    [sym_switch_statement] = STATE(673),
    [sym_for_statement] = STATE(673),
    [sym_for_in_statement] = STATE(673),
    [sym_while_statement] = STATE(673),
    [sym_do_statement] = STATE(673),
    [sym_try_statement] = STATE(673),
    [sym_with_statement] = STATE(673),
    [sym_break_statement] = STATE(673),
    [sym_continue_statement] = STATE(673),
    [sym_debugger_statement] = STATE(673),
    [sym_return_statement] = STATE(673),
    [sym_throw_statement] = STATE(673),
    [sym_empty_statement] = STATE(673),
    [sym_labeled_statement] = STATE(673),
    [sym_parenthesized_expression] = STATE(1116),
    [sym_expression] = STATE(1697),
    [sym_primary_expression] = STATE(1799),
    [sym_yield_expression] = STATE(1798),
    [sym_object] = STATE(1844),
    [sym_object_pattern] = STATE(4170),
    [sym_array] = STATE(1844),
    [sym_array_pattern] = STATE(4170),
    [sym_class] = STATE(1844),
    [sym_class_declaration] = STATE(741),
    [sym_function] = STATE(1844),
    [sym_function_declaration] = STATE(741),
    [sym_generator_function] = STATE(1844),
    [sym_generator_function_declaration] = STATE(741),
    [sym_arrow_function] = STATE(1844),
    [sym__call_signature] = STATE(4172),
    [sym_call_expression] = STATE(1844),
    [sym_new_expression] = STATE(1798),
    [sym_await_expression] = STATE(1798),
    [sym_member_expression] = STATE(1116),
    [sym_subscript_expression] = STATE(1116),
    [sym_assignment_expression] = STATE(1798),
    [sym__augmented_assignment_lhs] = STATE(2357),
    [sym_augmented_assignment_expression] = STATE(1798),
    [sym__destructuring_pattern] = STATE(4170),
    [sym_ternary_expression] = STATE(1798),
    [sym_binary_expression] = STATE(1798),
    [sym_unary_expression] = STATE(1798),
    [sym_update_expression] = STATE(1798),
    [sym_sequence_expression] = STATE(3662),
    [sym_string] = STATE(1844),
    [sym_template_string] = STATE(1844),
    [sym_regex] = STATE(1844),
    [sym_meta_property] = STATE(1844),
    [sym_decorator] = STATE(1149),
    [sym_formal_parameters] = STATE(2903),
    [sym_non_null_expression] = STATE(1116),
    [sym_function_signature] = STATE(741),
    [sym_type_assertion] = STATE(1798),
    [sym_as_expression] = STATE(1798),
    [sym_ambient_declaration] = STATE(741),
    [sym_abstract_class_declaration] = STATE(741),
    [sym_module] = STATE(741),
    [sym_internal_module] = STATE(140),
    [sym_import_alias] = STATE(741),
    [sym_interface_declaration] = STATE(741),
    [sym_enum_declaration] = STATE(741),
    [sym_type_alias_declaration] = STATE(741),
    [sym_type_arguments] = STATE(482),
    [sym_type_parameters] = STATE(3670),
    [aux_sym_export_statement_repeat1] = STATE(2947),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_type] = ACTIONS(13),
    [anon_sym_namespace] = ACTIONS(15),
    [anon_sym_LBRACE] = ACTIONS(17),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_for] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_await] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(41),
    [anon_sym_do] = ACTIONS(43),
    [anon_sym_try] = ACTIONS(45),
    [anon_sym_with] = ACTIONS(47),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_debugger] = ACTIONS(53),
    [anon_sym_return] = ACTIONS(55),
    [anon_sym_throw] = ACTIONS(57),
    [anon_sym_SEMI] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(69),
    [anon_sym_async] = ACTIONS(71),
    [anon_sym_function] = ACTIONS(73),
    [anon_sym_new] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_void] = ACTIONS(19),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(77),
    [anon_sym_DASH_DASH] = ACTIONS(77),
    [anon_sym_DQUOTE] = ACTIONS(79),
    [anon_sym_SQUOTE] = ACTIONS(81),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(83),
    [sym_number] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(93),
    [anon_sym_readonly] = ACTIONS(93),
    [anon_sym_get] = ACTIONS(93),
    [anon_sym_set] = ACTIONS(93),
    [anon_sym_declare] = ACTIONS(95),
    [anon_sym_public] = ACTIONS(93),
    [anon_sym_private] = ACTIONS(93),
    [anon_sym_protected] = ACTIONS(93),
    [anon_sym_override] = ACTIONS(93),
    [anon_sym_module] = ACTIONS(97),
    [anon_sym_any] = ACTIONS(93),
    [anon_sym_number] = ACTIONS(93),
    [anon_sym_boolean] = ACTIONS(93),
    [anon_sym_string] = ACTIONS(93),
    [anon_sym_symbol] = ACTIONS(93),
    [anon_sym_abstract] = ACTIONS(99),
    [anon_sym_interface] = ACTIONS(101),
    [anon_sym_enum] = ACTIONS(103),
  },
  [47] = {
    [sym_export_statement] = STATE(672),
    [sym_declaration] = STATE(671),
    [sym_import] = STATE(1844),
    [sym_import_statement] = STATE(670),
    [sym_expression_statement] = STATE(668),
    [sym_variable_declaration] = STATE(741),
    [sym_lexical_declaration] = STATE(741),
    [sym_statement_block] = STATE(667),
    [sym_if_statement] = STATE(663),
    [sym_switch_statement] = STATE(662),
    [sym_for_statement] = STATE(656),
    [sym_for_in_statement] = STATE(653),
    [sym_while_statement] = STATE(649),
    [sym_do_statement] = STATE(648),
    [sym_try_statement] = STATE(646),
    [sym_with_statement] = STATE(642),
    [sym_break_statement] = STATE(636),
    [sym_continue_statement] = STATE(633),
    [sym_debugger_statement] = STATE(627),
    [sym_return_statement] = STATE(626),
    [sym_throw_statement] = STATE(625),
    [sym_empty_statement] = STATE(624),
    [sym_labeled_statement] = STATE(623),
    [sym_parenthesized_expression] = STATE(1116),
    [sym_expression] = STATE(1697),
    [sym_primary_expression] = STATE(1799),
    [sym_yield_expression] = STATE(1798),
    [sym_object] = STATE(1844),
    [sym_object_pattern] = STATE(4170),
    [sym_array] = STATE(1844),
    [sym_array_pattern] = STATE(4170),
    [sym_class] = STATE(1844),
    [sym_class_declaration] = STATE(741),
    [sym_function] = STATE(1844),
    [sym_function_declaration] = STATE(741),
    [sym_generator_function] = STATE(1844),
    [sym_generator_function_declaration] = STATE(741),
    [sym_arrow_function] = STATE(1844),
    [sym__call_signature] = STATE(4172),
    [sym_call_expression] = STATE(1844),
    [sym_new_expression] = STATE(1798),
    [sym_await_expression] = STATE(1798),
    [sym_member_expression] = STATE(1116),
    [sym_subscript_expression] = STATE(1116),
    [sym_assignment_expression] = STATE(1798),
    [sym__augmented_assignment_lhs] = STATE(2357),
    [sym_augmented_assignment_expression] = STATE(1798),
    [sym__destructuring_pattern] = STATE(4170),
    [sym_ternary_expression] = STATE(1798),
    [sym_binary_expression] = STATE(1798),
    [sym_unary_expression] = STATE(1798),
    [sym_update_expression] = STATE(1798),
    [sym_sequence_expression] = STATE(3662),
    [sym_string] = STATE(1844),
    [sym_template_string] = STATE(1844),
    [sym_regex] = STATE(1844),
    [sym_meta_property] = STATE(1844),
    [sym_decorator] = STATE(1149),
    [sym_formal_parameters] = STATE(2903),
    [sym_non_null_expression] = STATE(1116),
    [sym_function_signature] = STATE(741),
    [sym_type_assertion] = STATE(1798),
    [sym_as_expression] = STATE(1798),
    [sym_ambient_declaration] = STATE(741),
    [sym_abstract_class_declaration] = STATE(741),
    [sym_module] = STATE(741),
    [sym_internal_module] = STATE(140),
    [sym_import_alias] = STATE(741),
    [sym_interface_declaration] = STATE(741),
    [sym_enum_declaration] = STATE(741),
    [sym_type_alias_declaration] = STATE(741),
    [sym_type_arguments] = STATE(482),
    [sym_type_parameters] = STATE(3670),
    [aux_sym_export_statement_repeat1] = STATE(2947),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_type] = ACTIONS(13),
    [anon_sym_namespace] = ACTIONS(15),
    [anon_sym_LBRACE] = ACTIONS(17),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_for] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_await] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(41),
    [anon_sym_do] = ACTIONS(43),
    [anon_sym_try] = ACTIONS(45),
    [anon_sym_with] = ACTIONS(47),
    [anon_sym_break] = ACTIONS(49),
    [anon_sym_continue] = ACTIONS(51),
    [anon_sym_debugger] = ACTIONS(53),
    [anon_sym_return] = ACTIONS(55),
    [anon_sym_throw] = ACTIONS(57),
    [anon_sym_SEMI] = ACTIONS(59),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(69),
    [anon_sym_async] = ACTIONS(71),
    [anon_sym_function] = ACTIONS(73),
    [anon_sym_new] = ACTIONS(75),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_void] = ACTIONS(19),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(77),
    [anon_sym_DASH_DASH] = ACTIONS(77),
    [anon_sym_DQUOTE] = ACTIONS(79),
    [anon_sym_SQUOTE] = ACTIONS(81),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(83),
    [sym_number] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(93),
    [anon_sym_readonly] = ACTIONS(93),
    [anon_sym_get] = ACTIONS(93),
    [anon_sym_set] = ACTIONS(93),
    [anon_sym_declare] = ACTIONS(95),
    [anon_sym_public] = ACTIONS(93),
    [anon_sym_private] = ACTIONS(93),
    [anon_sym_protected] = ACTIONS(93),
    [anon_sym_override] = ACTIONS(93),
    [anon_sym_module] = ACTIONS(97),
    [anon_sym_any] = ACTIONS(93),
    [anon_sym_number] = ACTIONS(93),
    [anon_sym_boolean] = ACTIONS(93),
    [anon_sym_string] = ACTIONS(93),
    [anon_sym_symbol] = ACTIONS(93),
    [anon_sym_abstract] = ACTIONS(99),
    [anon_sym_interface] = ACTIONS(101),
    [anon_sym_enum] = ACTIONS(103),
  },
  [48] = {
    [sym_import] = STATE(1405),
    [sym_parenthesized_expression] = STATE(1072),
    [sym_expression] = STATE(1692),
    [sym_primary_expression] = STATE(1404),
    [sym_yield_expression] = STATE(1403),
    [sym_object] = STATE(1405),
    [sym_object_pattern] = STATE(2812),
    [sym_assignment_pattern] = STATE(3431),
    [sym_array] = STATE(1405),
    [sym_array_pattern] = STATE(2812),
    [sym_nested_identifier] = STATE(4074),
    [sym_class] = STATE(1405),
    [sym_function] = STATE(1405),
    [sym_generator_function] = STATE(1405),
    [sym_arrow_function] = STATE(1405),
    [sym__call_signature] = STATE(4121),
    [sym_call_expression] = STATE(1405),
    [sym_new_expression] = STATE(1403),
    [sym_await_expression] = STATE(1403),
    [sym_member_expression] = STATE(1056),
    [sym_subscript_expression] = STATE(1056),
    [sym_assignment_expression] = STATE(1403),
    [sym__augmented_assignment_lhs] = STATE(2344),
    [sym_augmented_assignment_expression] = STATE(1403),
    [sym__destructuring_pattern] = STATE(2812),
    [sym_spread_element] = STATE(3396),
    [sym_ternary_expression] = STATE(1403),
    [sym_binary_expression] = STATE(1403),
    [sym_unary_expression] = STATE(1403),
    [sym_update_expression] = STATE(1403),
    [sym_string] = STATE(1853),
    [sym_template_string] = STATE(1405),
    [sym_regex] = STATE(1405),
    [sym_meta_property] = STATE(1405),
    [sym_decorator] = STATE(1149),
    [sym_formal_parameters] = STATE(3260),
    [sym_pattern] = STATE(3391),
    [sym_rest_pattern] = STATE(3170),
    [sym_non_null_expression] = STATE(1056),
    [sym_type_assertion] = STATE(1403),
    [sym_as_expression] = STATE(1403),
    [sym_internal_module] = STATE(1403),
    [sym_nested_type_identifier] = STATE(2336),
    [sym__type] = STATE(2883),
    [sym_tuple_parameter] = STATE(3474),
    [sym_optional_tuple_parameter] = STATE(3474),
    [sym_optional_type] = STATE(3474),
    [sym_rest_type] = STATE(3474),
    [sym__tuple_type_member] = STATE(3474),
    [sym_constructor_type] = STATE(2883),
    [sym__primary_type] = STATE(2373),
    [sym_template_literal_type] = STATE(2359),
    [sym_infer_type] = STATE(2883),
    [sym_conditional_type] = STATE(2359),
    [sym_generic_type] = STATE(2359),
    [sym_type_query] = STATE(2359),
    [sym_index_type_query] = STATE(2359),
    [sym_lookup_type] = STATE(2359),
    [sym_literal_type] = STATE(2359),
    [sym__number] = STATE(2355),
    [sym_existential_type] = STATE(2359),
    [sym_flow_maybe_type] = STATE(2359),
    [sym_parenthesized_type] = STATE(2359),
    [sym_predefined_type] = STATE(2359),
    [sym_type_arguments] = STATE(502),
    [sym_object_type] = STATE(2359),
    [sym_type_parameters] = STATE(3839),
    [sym_array_type] = STATE(2359),
    [sym_tuple_type] = STATE(2359),
    [sym_readonly_type] = STATE(2883),
    [sym_union_type] = STATE(2359),
    [sym_intersection_type] = STATE(2359),
    [sym_function_type] = STATE(2883),
    [aux_sym_export_statement_repeat1] = STATE(3368),
    [aux_sym_array_repeat1] = STATE(3405),
    [aux_sym_array_pattern_repeat1] = STATE(3400),
    [sym_identifier] = ACTIONS(533),
    [anon_sym_export] = ACTIONS(535),
    [anon_sym_STAR] = ACTIONS(537),
    [anon_sym_type] = ACTIONS(535),
    [anon_sym_namespace] = ACTIONS(539),
    [anon_sym_LBRACE] = ACTIONS(541),
    [anon_sym_COMMA] = ACTIONS(543),
    [anon_sym_typeof] = ACTIONS(545),
    [anon_sym_import] = ACTIONS(125),
    [anon_sym_BANG] = ACTIONS(547),
    [anon_sym_LPAREN] = ACTIONS(130),
    [anon_sym_await] = ACTIONS(549),
    [anon_sym_yield] = ACTIONS(551),
    [anon_sym_LBRACK] = ACTIONS(553),
    [anon_sym_RBRACK] = ACTIONS(555),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(557),
    [anon_sym_class] = ACTIONS(143),
    [anon_sym_async] = ACTIONS(559),
    [anon_sym_function] = ACTIONS(147),
    [anon_sym_new] = ACTIONS(561),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(563),
    [anon_sym_AMP] = ACTIONS(565),
    [anon_sym_PIPE] = ACTIONS(567),
    [anon_sym_PLUS] = ACTIONS(569),
    [anon_sym_DASH] = ACTIONS(569),
    [anon_sym_TILDE] = ACTIONS(547),
    [anon_sym_void] = ACTIONS(571),
    [anon_sym_delete] = ACTIONS(573),
    [anon_sym_PLUS_PLUS] = ACTIONS(575),
    [anon_sym_DASH_DASH] = ACTIONS(575),
    [anon_sym_DQUOTE] = ACTIONS(174),
    [anon_sym_SQUOTE] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(178),
    [sym_number] = ACTIONS(180),
    [sym_this] = ACTIONS(577),
    [sym_super] = ACTIONS(184),
    [sym_true] = ACTIONS(186),
    [sym_false] = ACTIONS(186),
    [sym_null] = ACTIONS(186),
    [sym_undefined] = ACTIONS(579),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(535),
    [anon_sym_readonly] = ACTIONS(581),
    [anon_sym_get] = ACTIONS(535),
    [anon_sym_set] = ACTIONS(535),
    [anon_sym_QMARK] = ACTIONS(583),
    [anon_sym_declare] = ACTIONS(535),
    [anon_sym_public] = ACTIONS(535),
    [anon_sym_private] = ACTIONS(535),
    [anon_sym_protected] = ACTIONS(535),
    [anon_sym_override] = ACTIONS(535),
    [anon_sym_module] = ACTIONS(535),
    [anon_sym_any] = ACTIONS(585),
    [anon_sym_number] = ACTIONS(585),
    [anon_sym_boolean] = ACTIONS(585),
    [anon_sym_string] = ACTIONS(585),
    [anon_sym_symbol] = ACTIONS(585),
    [anon_sym_abstract] = ACTIONS(196),
    [anon_sym_infer] = ACTIONS(198),
    [anon_sym_keyof] = ACTIONS(200),
    [anon_sym_unknown] = ACTIONS(202),
    [anon_sym_never] = ACTIONS(202),
    [anon_sym_object] = ACTIONS(202),
    [anon_sym_LBRACE_PIPE] = ACTIONS(204),
  },
  [49] = {
    [sym_import] = STATE(1405),
    [sym_parenthesized_expression] = STATE(1072),
    [sym_expression] = STATE(1692),
    [sym_primary_expression] = STATE(1404),
    [sym_yield_expression] = STATE(1403),
    [sym_object] = STATE(1405),
    [sym_object_pattern] = STATE(2812),
    [sym_assignment_pattern] = STATE(3431),
    [sym_array] = STATE(1405),
    [sym_array_pattern] = STATE(2812),
    [sym_nested_identifier] = STATE(4074),
    [sym_class] = STATE(1405),
    [sym_function] = STATE(1405),
    [sym_generator_function] = STATE(1405),
    [sym_arrow_function] = STATE(1405),
    [sym__call_signature] = STATE(4121),
    [sym_call_expression] = STATE(1405),
    [sym_new_expression] = STATE(1403),
    [sym_await_expression] = STATE(1403),
    [sym_member_expression] = STATE(1056),
    [sym_subscript_expression] = STATE(1056),
    [sym_assignment_expression] = STATE(1403),
    [sym__augmented_assignment_lhs] = STATE(2344),
    [sym_augmented_assignment_expression] = STATE(1403),
    [sym__destructuring_pattern] = STATE(2812),
    [sym_spread_element] = STATE(3396),
    [sym_ternary_expression] = STATE(1403),
    [sym_binary_expression] = STATE(1403),
    [sym_unary_expression] = STATE(1403),
    [sym_update_expression] = STATE(1403),
    [sym_string] = STATE(1853),
    [sym_template_string] = STATE(1405),
    [sym_regex] = STATE(1405),
    [sym_meta_property] = STATE(1405),
    [sym_decorator] = STATE(1149),
    [sym_formal_parameters] = STATE(3260),
    [sym_pattern] = STATE(3391),
    [sym_rest_pattern] = STATE(3170),
    [sym_non_null_expression] = STATE(1056),
    [sym_type_assertion] = STATE(1403),
    [sym_as_expression] = STATE(1403),
    [sym_internal_module] = STATE(1403),
    [sym_nested_type_identifier] = STATE(2336),
    [sym__type] = STATE(2883),
    [sym_tuple_parameter] = STATE(3474),
    [sym_optional_tuple_parameter] = STATE(3474),
    [sym_optional_type] = STATE(3474),
    [sym_rest_type] = STATE(3474),
    [sym__tuple_type_member] = STATE(3474),
    [sym_constructor_type] = STATE(2883),
    [sym__primary_type] = STATE(2373),
    [sym_template_literal_type] = STATE(2359),
    [sym_infer_type] = STATE(2883),
    [sym_conditional_type] = STATE(2359),
    [sym_generic_type] = STATE(2359),
    [sym_type_query] = STATE(2359),
    [sym_index_type_query] = STATE(2359),
    [sym_lookup_type] = STATE(2359),
    [sym_literal_type] = STATE(2359),
    [sym__number] = STATE(2355),
    [sym_existential_type] = STATE(2359),
    [sym_flow_maybe_type] = STATE(2359),
    [sym_parenthesized_type] = STATE(2359),
    [sym_predefined_type] = STATE(2359),
    [sym_type_arguments] = STATE(502),
    [sym_object_type] = STATE(2359),
    [sym_type_parameters] = STATE(3839),
    [sym_array_type] = STATE(2359),
    [sym_tuple_type] = STATE(2359),
    [sym_readonly_type] = STATE(2883),
    [sym_union_type] = STATE(2359),
    [sym_intersection_type] = STATE(2359),
    [sym_function_type] = STATE(2883),
    [aux_sym_export_statement_repeat1] = STATE(3368),
    [aux_sym_array_repeat1] = STATE(3405),
    [aux_sym_array_pattern_repeat1] = STATE(3400),
    [sym_identifier] = ACTIONS(533),
    [anon_sym_export] = ACTIONS(535),
    [anon_sym_STAR] = ACTIONS(537),
    [anon_sym_type] = ACTIONS(535),
    [anon_sym_namespace] = ACTIONS(539),
    [anon_sym_LBRACE] = ACTIONS(541),
    [anon_sym_COMMA] = ACTIONS(543),
    [anon_sym_typeof] = ACTIONS(545),
    [anon_sym_import] = ACTIONS(125),
    [anon_sym_BANG] = ACTIONS(547),
    [anon_sym_LPAREN] = ACTIONS(130),
    [anon_sym_await] = ACTIONS(549),
    [anon_sym_yield] = ACTIONS(551),
    [anon_sym_LBRACK] = ACTIONS(553),
    [anon_sym_RBRACK] = ACTIONS(587),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(557),
    [anon_sym_class] = ACTIONS(143),
    [anon_sym_async] = ACTIONS(559),
    [anon_sym_function] = ACTIONS(147),
    [anon_sym_new] = ACTIONS(561),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(563),
    [anon_sym_AMP] = ACTIONS(565),
    [anon_sym_PIPE] = ACTIONS(567),
    [anon_sym_PLUS] = ACTIONS(569),
    [anon_sym_DASH] = ACTIONS(569),
    [anon_sym_TILDE] = ACTIONS(547),
    [anon_sym_void] = ACTIONS(571),
    [anon_sym_delete] = ACTIONS(573),
    [anon_sym_PLUS_PLUS] = ACTIONS(575),
    [anon_sym_DASH_DASH] = ACTIONS(575),
    [anon_sym_DQUOTE] = ACTIONS(174),
    [anon_sym_SQUOTE] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(178),
    [sym_number] = ACTIONS(180),
    [sym_this] = ACTIONS(577),
    [sym_super] = ACTIONS(184),
    [sym_true] = ACTIONS(186),
    [sym_false] = ACTIONS(186),
    [sym_null] = ACTIONS(186),
    [sym_undefined] = ACTIONS(579),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(535),
    [anon_sym_readonly] = ACTIONS(581),
    [anon_sym_get] = ACTIONS(535),
    [anon_sym_set] = ACTIONS(535),
    [anon_sym_QMARK] = ACTIONS(583),
    [anon_sym_declare] = ACTIONS(535),
    [anon_sym_public] = ACTIONS(535),
    [anon_sym_private] = ACTIONS(535),
    [anon_sym_protected] = ACTIONS(535),
    [anon_sym_override] = ACTIONS(535),
    [anon_sym_module] = ACTIONS(535),
    [anon_sym_any] = ACTIONS(585),
    [anon_sym_number] = ACTIONS(585),
    [anon_sym_boolean] = ACTIONS(585),
    [anon_sym_string] = ACTIONS(585),
    [anon_sym_symbol] = ACTIONS(585),
    [anon_sym_abstract] = ACTIONS(196),
    [anon_sym_infer] = ACTIONS(198),
    [anon_sym_keyof] = ACTIONS(200),
    [anon_sym_unknown] = ACTIONS(202),
    [anon_sym_never] = ACTIONS(202),
    [anon_sym_object] = ACTIONS(202),
    [anon_sym_LBRACE_PIPE] = ACTIONS(204),
  },
  [50] = {
    [sym_import] = STATE(1405),
    [sym_parenthesized_expression] = STATE(1072),
    [sym_expression] = STATE(1692),
    [sym_primary_expression] = STATE(1404),
    [sym_yield_expression] = STATE(1403),
    [sym_object] = STATE(1405),
    [sym_object_pattern] = STATE(2812),
    [sym_assignment_pattern] = STATE(3431),
    [sym_array] = STATE(1405),
    [sym_array_pattern] = STATE(2812),
    [sym_nested_identifier] = STATE(4074),
    [sym_class] = STATE(1405),
    [sym_function] = STATE(1405),
    [sym_generator_function] = STATE(1405),
    [sym_arrow_function] = STATE(1405),
    [sym__call_signature] = STATE(4121),
    [sym_call_expression] = STATE(1405),
    [sym_new_expression] = STATE(1403),
    [sym_await_expression] = STATE(1403),
    [sym_member_expression] = STATE(1056),
    [sym_subscript_expression] = STATE(1056),
    [sym_assignment_expression] = STATE(1403),
    [sym__augmented_assignment_lhs] = STATE(2344),
    [sym_augmented_assignment_expression] = STATE(1403),
    [sym__destructuring_pattern] = STATE(2812),
    [sym_spread_element] = STATE(3396),
    [sym_ternary_expression] = STATE(1403),
    [sym_binary_expression] = STATE(1403),
    [sym_unary_expression] = STATE(1403),
    [sym_update_expression] = STATE(1403),
    [sym_string] = STATE(1853),
    [sym_template_string] = STATE(1405),
    [sym_regex] = STATE(1405),
    [sym_meta_property] = STATE(1405),
    [sym_decorator] = STATE(1149),
    [sym_formal_parameters] = STATE(3260),
    [sym_pattern] = STATE(3391),
    [sym_rest_pattern] = STATE(3170),
    [sym_non_null_expression] = STATE(1056),
    [sym_type_assertion] = STATE(1403),
    [sym_as_expression] = STATE(1403),
    [sym_internal_module] = STATE(1403),
    [sym_nested_type_identifier] = STATE(2336),
    [sym__type] = STATE(2883),
    [sym_tuple_parameter] = STATE(3474),
    [sym_optional_tuple_parameter] = STATE(3474),
    [sym_optional_type] = STATE(3474),
    [sym_rest_type] = STATE(3474),
    [sym__tuple_type_member] = STATE(3474),
    [sym_constructor_type] = STATE(2883),
    [sym__primary_type] = STATE(2373),
    [sym_template_literal_type] = STATE(2359),
    [sym_infer_type] = STATE(2883),
    [sym_conditional_type] = STATE(2359),
    [sym_generic_type] = STATE(2359),
    [sym_type_query] = STATE(2359),
    [sym_index_type_query] = STATE(2359),
    [sym_lookup_type] = STATE(2359),
    [sym_literal_type] = STATE(2359),
    [sym__number] = STATE(2355),
    [sym_existential_type] = STATE(2359),
    [sym_flow_maybe_type] = STATE(2359),
    [sym_parenthesized_type] = STATE(2359),
    [sym_predefined_type] = STATE(2359),
    [sym_type_arguments] = STATE(502),
    [sym_object_type] = STATE(2359),
    [sym_type_parameters] = STATE(3839),
    [sym_array_type] = STATE(2359),
    [sym_tuple_type] = STATE(2359),
    [sym_readonly_type] = STATE(2883),
    [sym_union_type] = STATE(2359),
    [sym_intersection_type] = STATE(2359),
    [sym_function_type] = STATE(2883),
    [aux_sym_export_statement_repeat1] = STATE(3368),
    [aux_sym_array_repeat1] = STATE(3405),
    [aux_sym_array_pattern_repeat1] = STATE(3400),
    [sym_identifier] = ACTIONS(533),
    [anon_sym_export] = ACTIONS(535),
    [anon_sym_STAR] = ACTIONS(537),
    [anon_sym_type] = ACTIONS(535),
    [anon_sym_namespace] = ACTIONS(539),
    [anon_sym_LBRACE] = ACTIONS(541),
    [anon_sym_COMMA] = ACTIONS(543),
    [anon_sym_typeof] = ACTIONS(545),
    [anon_sym_import] = ACTIONS(125),
    [anon_sym_BANG] = ACTIONS(547),
    [anon_sym_LPAREN] = ACTIONS(130),
    [anon_sym_await] = ACTIONS(549),
    [anon_sym_yield] = ACTIONS(551),
    [anon_sym_LBRACK] = ACTIONS(553),
    [anon_sym_RBRACK] = ACTIONS(589),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(557),
    [anon_sym_class] = ACTIONS(143),
    [anon_sym_async] = ACTIONS(559),
    [anon_sym_function] = ACTIONS(147),
    [anon_sym_new] = ACTIONS(561),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(563),
    [anon_sym_AMP] = ACTIONS(565),
    [anon_sym_PIPE] = ACTIONS(567),
    [anon_sym_PLUS] = ACTIONS(569),
    [anon_sym_DASH] = ACTIONS(569),
    [anon_sym_TILDE] = ACTIONS(547),
    [anon_sym_void] = ACTIONS(571),
    [anon_sym_delete] = ACTIONS(573),
    [anon_sym_PLUS_PLUS] = ACTIONS(575),
    [anon_sym_DASH_DASH] = ACTIONS(575),
    [anon_sym_DQUOTE] = ACTIONS(174),
    [anon_sym_SQUOTE] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(178),
    [sym_number] = ACTIONS(180),
    [sym_this] = ACTIONS(577),
    [sym_super] = ACTIONS(184),
    [sym_true] = ACTIONS(186),
    [sym_false] = ACTIONS(186),
    [sym_null] = ACTIONS(186),
    [sym_undefined] = ACTIONS(579),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(535),
    [anon_sym_readonly] = ACTIONS(581),
    [anon_sym_get] = ACTIONS(535),
    [anon_sym_set] = ACTIONS(535),
    [anon_sym_QMARK] = ACTIONS(583),
    [anon_sym_declare] = ACTIONS(535),
    [anon_sym_public] = ACTIONS(535),
    [anon_sym_private] = ACTIONS(535),
    [anon_sym_protected] = ACTIONS(535),
    [anon_sym_override] = ACTIONS(535),
    [anon_sym_module] = ACTIONS(535),
    [anon_sym_any] = ACTIONS(585),
    [anon_sym_number] = ACTIONS(585),
    [anon_sym_boolean] = ACTIONS(585),
    [anon_sym_string] = ACTIONS(585),
    [anon_sym_symbol] = ACTIONS(585),
    [anon_sym_abstract] = ACTIONS(196),
    [anon_sym_infer] = ACTIONS(198),
    [anon_sym_keyof] = ACTIONS(200),
    [anon_sym_unknown] = ACTIONS(202),
    [anon_sym_never] = ACTIONS(202),
    [anon_sym_object] = ACTIONS(202),
    [anon_sym_LBRACE_PIPE] = ACTIONS(204),
  },
  [51] = {
    [sym_import] = STATE(1405),
    [sym_parenthesized_expression] = STATE(1072),
    [sym_expression] = STATE(1689),
    [sym_primary_expression] = STATE(1404),
    [sym_yield_expression] = STATE(1403),
    [sym_object] = STATE(1405),
    [sym_object_pattern] = STATE(2812),
    [sym_assignment_pattern] = STATE(3431),
    [sym_array] = STATE(1405),
    [sym_array_pattern] = STATE(2812),
    [sym_nested_identifier] = STATE(4074),
    [sym_class] = STATE(1405),
    [sym_function] = STATE(1405),
    [sym_generator_function] = STATE(1405),
    [sym_arrow_function] = STATE(1405),
    [sym__call_signature] = STATE(4121),
    [sym_call_expression] = STATE(1405),
    [sym_new_expression] = STATE(1403),
    [sym_await_expression] = STATE(1403),
    [sym_member_expression] = STATE(1056),
    [sym_subscript_expression] = STATE(1056),
    [sym_assignment_expression] = STATE(1403),
    [sym__augmented_assignment_lhs] = STATE(2344),
    [sym_augmented_assignment_expression] = STATE(1403),
    [sym__destructuring_pattern] = STATE(2812),
    [sym_spread_element] = STATE(3419),
    [sym_ternary_expression] = STATE(1403),
    [sym_binary_expression] = STATE(1403),
    [sym_unary_expression] = STATE(1403),
    [sym_update_expression] = STATE(1403),
    [sym_string] = STATE(1853),
    [sym_template_string] = STATE(1405),
    [sym_regex] = STATE(1405),
    [sym_meta_property] = STATE(1405),
    [sym_decorator] = STATE(1149),
    [sym_formal_parameters] = STATE(3260),
    [sym_pattern] = STATE(3391),
    [sym_rest_pattern] = STATE(3170),
    [sym_non_null_expression] = STATE(1056),
    [sym_type_assertion] = STATE(1403),
    [sym_as_expression] = STATE(1403),
    [sym_internal_module] = STATE(1403),
    [sym_nested_type_identifier] = STATE(2336),
    [sym__type] = STATE(2883),
    [sym_tuple_parameter] = STATE(3474),
    [sym_optional_tuple_parameter] = STATE(3474),
    [sym_optional_type] = STATE(3474),
    [sym_rest_type] = STATE(3474),
    [sym__tuple_type_member] = STATE(3474),
    [sym_constructor_type] = STATE(2883),
    [sym__primary_type] = STATE(2373),
    [sym_template_literal_type] = STATE(2359),
    [sym_infer_type] = STATE(2883),
    [sym_conditional_type] = STATE(2359),
    [sym_generic_type] = STATE(2359),
    [sym_type_query] = STATE(2359),
    [sym_index_type_query] = STATE(2359),
    [sym_lookup_type] = STATE(2359),
    [sym_literal_type] = STATE(2359),
    [sym__number] = STATE(2355),
    [sym_existential_type] = STATE(2359),
    [sym_flow_maybe_type] = STATE(2359),
    [sym_parenthesized_type] = STATE(2359),
    [sym_predefined_type] = STATE(2359),
    [sym_type_arguments] = STATE(502),
    [sym_object_type] = STATE(2359),
    [sym_type_parameters] = STATE(3839),
    [sym_array_type] = STATE(2359),
    [sym_tuple_type] = STATE(2359),
    [sym_readonly_type] = STATE(2883),
    [sym_union_type] = STATE(2359),
    [sym_intersection_type] = STATE(2359),
    [sym_function_type] = STATE(2883),
    [aux_sym_export_statement_repeat1] = STATE(3368),
    [aux_sym_array_repeat1] = STATE(3402),
    [aux_sym_array_pattern_repeat1] = STATE(3400),
    [sym_identifier] = ACTIONS(533),
    [anon_sym_export] = ACTIONS(535),
    [anon_sym_STAR] = ACTIONS(537),
    [anon_sym_type] = ACTIONS(535),
    [anon_sym_namespace] = ACTIONS(539),
    [anon_sym_LBRACE] = ACTIONS(541),
    [anon_sym_COMMA] = ACTIONS(543),
    [anon_sym_typeof] = ACTIONS(545),
    [anon_sym_import] = ACTIONS(125),
    [anon_sym_BANG] = ACTIONS(547),
    [anon_sym_LPAREN] = ACTIONS(130),
    [anon_sym_await] = ACTIONS(549),
    [anon_sym_yield] = ACTIONS(551),
    [anon_sym_LBRACK] = ACTIONS(553),
    [anon_sym_RBRACK] = ACTIONS(591),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(557),
    [anon_sym_class] = ACTIONS(143),
    [anon_sym_async] = ACTIONS(559),
    [anon_sym_function] = ACTIONS(147),
    [anon_sym_new] = ACTIONS(561),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(563),
    [anon_sym_AMP] = ACTIONS(565),
    [anon_sym_PIPE] = ACTIONS(567),
    [anon_sym_PLUS] = ACTIONS(569),
    [anon_sym_DASH] = ACTIONS(569),
    [anon_sym_TILDE] = ACTIONS(547),
    [anon_sym_void] = ACTIONS(571),
    [anon_sym_delete] = ACTIONS(573),
    [anon_sym_PLUS_PLUS] = ACTIONS(575),
    [anon_sym_DASH_DASH] = ACTIONS(575),
    [anon_sym_DQUOTE] = ACTIONS(174),
    [anon_sym_SQUOTE] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(178),
    [sym_number] = ACTIONS(180),
    [sym_this] = ACTIONS(577),
    [sym_super] = ACTIONS(184),
    [sym_true] = ACTIONS(186),
    [sym_false] = ACTIONS(186),
    [sym_null] = ACTIONS(186),
    [sym_undefined] = ACTIONS(579),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(535),
    [anon_sym_readonly] = ACTIONS(581),
    [anon_sym_get] = ACTIONS(535),
    [anon_sym_set] = ACTIONS(535),
    [anon_sym_QMARK] = ACTIONS(583),
    [anon_sym_declare] = ACTIONS(535),
    [anon_sym_public] = ACTIONS(535),
    [anon_sym_private] = ACTIONS(535),
    [anon_sym_protected] = ACTIONS(535),
    [anon_sym_override] = ACTIONS(535),
    [anon_sym_module] = ACTIONS(535),
    [anon_sym_any] = ACTIONS(585),
    [anon_sym_number] = ACTIONS(585),
    [anon_sym_boolean] = ACTIONS(585),
    [anon_sym_string] = ACTIONS(585),
    [anon_sym_symbol] = ACTIONS(585),
    [anon_sym_abstract] = ACTIONS(196),
    [anon_sym_infer] = ACTIONS(198),
    [anon_sym_keyof] = ACTIONS(200),
    [anon_sym_unknown] = ACTIONS(202),
    [anon_sym_never] = ACTIONS(202),
    [anon_sym_object] = ACTIONS(202),
    [anon_sym_LBRACE_PIPE] = ACTIONS(204),
  },
  [52] = {
    [sym_import] = STATE(1405),
    [sym_parenthesized_expression] = STATE(1072),
    [sym_expression] = STATE(1689),
    [sym_primary_expression] = STATE(1404),
    [sym_yield_expression] = STATE(1403),
    [sym_object] = STATE(1405),
    [sym_object_pattern] = STATE(2812),
    [sym_assignment_pattern] = STATE(3431),
    [sym_array] = STATE(1405),
    [sym_array_pattern] = STATE(2812),
    [sym_nested_identifier] = STATE(4074),
    [sym_class] = STATE(1405),
    [sym_function] = STATE(1405),
    [sym_generator_function] = STATE(1405),
    [sym_arrow_function] = STATE(1405),
    [sym__call_signature] = STATE(4121),
    [sym_call_expression] = STATE(1405),
    [sym_new_expression] = STATE(1403),
    [sym_await_expression] = STATE(1403),
    [sym_member_expression] = STATE(1056),
    [sym_subscript_expression] = STATE(1056),
    [sym_assignment_expression] = STATE(1403),
    [sym__augmented_assignment_lhs] = STATE(2344),
    [sym_augmented_assignment_expression] = STATE(1403),
    [sym__destructuring_pattern] = STATE(2812),
    [sym_spread_element] = STATE(3419),
    [sym_ternary_expression] = STATE(1403),
    [sym_binary_expression] = STATE(1403),
    [sym_unary_expression] = STATE(1403),
    [sym_update_expression] = STATE(1403),
    [sym_string] = STATE(1853),
    [sym_template_string] = STATE(1405),
    [sym_regex] = STATE(1405),
    [sym_meta_property] = STATE(1405),
    [sym_decorator] = STATE(1149),
    [sym_formal_parameters] = STATE(3260),
    [sym_pattern] = STATE(3391),
    [sym_rest_pattern] = STATE(3170),
    [sym_non_null_expression] = STATE(1056),
    [sym_type_assertion] = STATE(1403),
    [sym_as_expression] = STATE(1403),
    [sym_internal_module] = STATE(1403),
    [sym_nested_type_identifier] = STATE(2336),
    [sym__type] = STATE(2883),
    [sym_tuple_parameter] = STATE(3474),
    [sym_optional_tuple_parameter] = STATE(3474),
    [sym_optional_type] = STATE(3474),
    [sym_rest_type] = STATE(3474),
    [sym__tuple_type_member] = STATE(3474),
    [sym_constructor_type] = STATE(2883),
    [sym__primary_type] = STATE(2373),
    [sym_template_literal_type] = STATE(2359),
    [sym_infer_type] = STATE(2883),
    [sym_conditional_type] = STATE(2359),
    [sym_generic_type] = STATE(2359),
    [sym_type_query] = STATE(2359),
    [sym_index_type_query] = STATE(2359),
    [sym_lookup_type] = STATE(2359),
    [sym_literal_type] = STATE(2359),
    [sym__number] = STATE(2355),
    [sym_existential_type] = STATE(2359),
    [sym_flow_maybe_type] = STATE(2359),
    [sym_parenthesized_type] = STATE(2359),
    [sym_predefined_type] = STATE(2359),
    [sym_type_arguments] = STATE(502),
    [sym_object_type] = STATE(2359),
    [sym_type_parameters] = STATE(3839),
    [sym_array_type] = STATE(2359),
    [sym_tuple_type] = STATE(2359),
    [sym_readonly_type] = STATE(2883),
    [sym_union_type] = STATE(2359),
    [sym_intersection_type] = STATE(2359),
    [sym_function_type] = STATE(2883),
    [aux_sym_export_statement_repeat1] = STATE(3368),
    [aux_sym_array_repeat1] = STATE(3402),
    [aux_sym_array_pattern_repeat1] = STATE(3400),
    [sym_identifier] = ACTIONS(533),
    [anon_sym_export] = ACTIONS(535),
    [anon_sym_STAR] = ACTIONS(537),
    [anon_sym_type] = ACTIONS(535),
    [anon_sym_namespace] = ACTIONS(539),
    [anon_sym_LBRACE] = ACTIONS(541),
    [anon_sym_COMMA] = ACTIONS(543),
    [anon_sym_typeof] = ACTIONS(545),
    [anon_sym_import] = ACTIONS(125),
    [anon_sym_BANG] = ACTIONS(547),
    [anon_sym_LPAREN] = ACTIONS(130),
    [anon_sym_await] = ACTIONS(549),
    [anon_sym_yield] = ACTIONS(551),
    [anon_sym_LBRACK] = ACTIONS(553),
    [anon_sym_RBRACK] = ACTIONS(593),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(557),
    [anon_sym_class] = ACTIONS(143),
    [anon_sym_async] = ACTIONS(559),
    [anon_sym_function] = ACTIONS(147),
    [anon_sym_new] = ACTIONS(561),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(563),
    [anon_sym_AMP] = ACTIONS(565),
    [anon_sym_PIPE] = ACTIONS(567),
    [anon_sym_PLUS] = ACTIONS(569),
    [anon_sym_DASH] = ACTIONS(569),
    [anon_sym_TILDE] = ACTIONS(547),
    [anon_sym_void] = ACTIONS(571),
    [anon_sym_delete] = ACTIONS(573),
    [anon_sym_PLUS_PLUS] = ACTIONS(575),
    [anon_sym_DASH_DASH] = ACTIONS(575),
    [anon_sym_DQUOTE] = ACTIONS(174),
    [anon_sym_SQUOTE] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(178),
    [sym_number] = ACTIONS(180),
    [sym_this] = ACTIONS(577),
    [sym_super] = ACTIONS(184),
    [sym_true] = ACTIONS(186),
    [sym_false] = ACTIONS(186),
    [sym_null] = ACTIONS(186),
    [sym_undefined] = ACTIONS(579),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(535),
    [anon_sym_readonly] = ACTIONS(581),
    [anon_sym_get] = ACTIONS(535),
    [anon_sym_set] = ACTIONS(535),
    [anon_sym_QMARK] = ACTIONS(583),
    [anon_sym_declare] = ACTIONS(535),
    [anon_sym_public] = ACTIONS(535),
    [anon_sym_private] = ACTIONS(535),
    [anon_sym_protected] = ACTIONS(535),
    [anon_sym_override] = ACTIONS(535),
    [anon_sym_module] = ACTIONS(535),
    [anon_sym_any] = ACTIONS(585),
    [anon_sym_number] = ACTIONS(585),
    [anon_sym_boolean] = ACTIONS(585),
    [anon_sym_string] = ACTIONS(585),
    [anon_sym_symbol] = ACTIONS(585),
    [anon_sym_abstract] = ACTIONS(196),
    [anon_sym_infer] = ACTIONS(198),
    [anon_sym_keyof] = ACTIONS(200),
    [anon_sym_unknown] = ACTIONS(202),
    [anon_sym_never] = ACTIONS(202),
    [anon_sym_object] = ACTIONS(202),
    [anon_sym_LBRACE_PIPE] = ACTIONS(204),
  },
  [53] = {
    [sym_import] = STATE(1405),
    [sym_parenthesized_expression] = STATE(1072),
    [sym_expression] = STATE(1692),
    [sym_primary_expression] = STATE(1404),
    [sym_yield_expression] = STATE(1403),
    [sym_object] = STATE(1405),
    [sym_object_pattern] = STATE(2812),
    [sym_assignment_pattern] = STATE(3431),
    [sym_array] = STATE(1405),
    [sym_array_pattern] = STATE(2812),
    [sym_nested_identifier] = STATE(4074),
    [sym_class] = STATE(1405),
    [sym_function] = STATE(1405),
    [sym_generator_function] = STATE(1405),
    [sym_arrow_function] = STATE(1405),
    [sym__call_signature] = STATE(4121),
    [sym_call_expression] = STATE(1405),
    [sym_new_expression] = STATE(1403),
    [sym_await_expression] = STATE(1403),
    [sym_member_expression] = STATE(1056),
    [sym_subscript_expression] = STATE(1056),
    [sym_assignment_expression] = STATE(1403),
    [sym__augmented_assignment_lhs] = STATE(2344),
    [sym_augmented_assignment_expression] = STATE(1403),
    [sym__destructuring_pattern] = STATE(2812),
    [sym_spread_element] = STATE(3396),
    [sym_ternary_expression] = STATE(1403),
    [sym_binary_expression] = STATE(1403),
    [sym_unary_expression] = STATE(1403),
    [sym_update_expression] = STATE(1403),
    [sym_string] = STATE(1853),
    [sym_template_string] = STATE(1405),
    [sym_regex] = STATE(1405),
    [sym_meta_property] = STATE(1405),
    [sym_decorator] = STATE(1149),
    [sym_formal_parameters] = STATE(3260),
    [sym_pattern] = STATE(3391),
    [sym_rest_pattern] = STATE(3170),
    [sym_non_null_expression] = STATE(1056),
    [sym_type_assertion] = STATE(1403),
    [sym_as_expression] = STATE(1403),
    [sym_internal_module] = STATE(1403),
    [sym_nested_type_identifier] = STATE(2336),
    [sym__type] = STATE(2883),
    [sym_tuple_parameter] = STATE(3500),
    [sym_optional_tuple_parameter] = STATE(3500),
    [sym_optional_type] = STATE(3500),
    [sym_rest_type] = STATE(3500),
    [sym__tuple_type_member] = STATE(3500),
    [sym_constructor_type] = STATE(2883),
    [sym__primary_type] = STATE(2373),
    [sym_template_literal_type] = STATE(2359),
    [sym_infer_type] = STATE(2883),
    [sym_conditional_type] = STATE(2359),
    [sym_generic_type] = STATE(2359),
    [sym_type_query] = STATE(2359),
    [sym_index_type_query] = STATE(2359),
    [sym_lookup_type] = STATE(2359),
    [sym_literal_type] = STATE(2359),
    [sym__number] = STATE(2355),
    [sym_existential_type] = STATE(2359),
    [sym_flow_maybe_type] = STATE(2359),
    [sym_parenthesized_type] = STATE(2359),
    [sym_predefined_type] = STATE(2359),
    [sym_type_arguments] = STATE(502),
    [sym_object_type] = STATE(2359),
    [sym_type_parameters] = STATE(3839),
    [sym_array_type] = STATE(2359),
    [sym_tuple_type] = STATE(2359),
    [sym_readonly_type] = STATE(2883),
    [sym_union_type] = STATE(2359),
    [sym_intersection_type] = STATE(2359),
    [sym_function_type] = STATE(2883),
    [aux_sym_export_statement_repeat1] = STATE(3368),
    [aux_sym_array_repeat1] = STATE(3405),
    [aux_sym_array_pattern_repeat1] = STATE(3400),
    [sym_identifier] = ACTIONS(533),
    [anon_sym_export] = ACTIONS(535),
    [anon_sym_STAR] = ACTIONS(537),
    [anon_sym_type] = ACTIONS(535),
    [anon_sym_namespace] = ACTIONS(539),
    [anon_sym_LBRACE] = ACTIONS(541),
    [anon_sym_COMMA] = ACTIONS(595),
    [anon_sym_typeof] = ACTIONS(545),
    [anon_sym_import] = ACTIONS(125),
    [anon_sym_BANG] = ACTIONS(547),
    [anon_sym_LPAREN] = ACTIONS(130),
    [anon_sym_await] = ACTIONS(549),
    [anon_sym_yield] = ACTIONS(551),
    [anon_sym_LBRACK] = ACTIONS(553),
    [anon_sym_RBRACK] = ACTIONS(597),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(557),
    [anon_sym_class] = ACTIONS(143),
    [anon_sym_async] = ACTIONS(559),
    [anon_sym_function] = ACTIONS(147),
    [anon_sym_new] = ACTIONS(561),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(563),
    [anon_sym_AMP] = ACTIONS(565),
    [anon_sym_PIPE] = ACTIONS(567),
    [anon_sym_PLUS] = ACTIONS(569),
    [anon_sym_DASH] = ACTIONS(569),
    [anon_sym_TILDE] = ACTIONS(547),
    [anon_sym_void] = ACTIONS(571),
    [anon_sym_delete] = ACTIONS(573),
    [anon_sym_PLUS_PLUS] = ACTIONS(575),
    [anon_sym_DASH_DASH] = ACTIONS(575),
    [anon_sym_DQUOTE] = ACTIONS(174),
    [anon_sym_SQUOTE] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(178),
    [sym_number] = ACTIONS(180),
    [sym_this] = ACTIONS(577),
    [sym_super] = ACTIONS(184),
    [sym_true] = ACTIONS(186),
    [sym_false] = ACTIONS(186),
    [sym_null] = ACTIONS(186),
    [sym_undefined] = ACTIONS(579),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(535),
    [anon_sym_readonly] = ACTIONS(581),
    [anon_sym_get] = ACTIONS(535),
    [anon_sym_set] = ACTIONS(535),
    [anon_sym_QMARK] = ACTIONS(583),
    [anon_sym_declare] = ACTIONS(535),
    [anon_sym_public] = ACTIONS(535),
    [anon_sym_private] = ACTIONS(535),
    [anon_sym_protected] = ACTIONS(535),
    [anon_sym_override] = ACTIONS(535),
    [anon_sym_module] = ACTIONS(535),
    [anon_sym_any] = ACTIONS(585),
    [anon_sym_number] = ACTIONS(585),
    [anon_sym_boolean] = ACTIONS(585),
    [anon_sym_string] = ACTIONS(585),
    [anon_sym_symbol] = ACTIONS(585),
    [anon_sym_abstract] = ACTIONS(196),
    [anon_sym_infer] = ACTIONS(198),
    [anon_sym_keyof] = ACTIONS(200),
    [anon_sym_unknown] = ACTIONS(202),
    [anon_sym_never] = ACTIONS(202),
    [anon_sym_object] = ACTIONS(202),
    [anon_sym_LBRACE_PIPE] = ACTIONS(204),
  },
  [54] = {
    [sym_import] = STATE(1405),
    [sym_parenthesized_expression] = STATE(1072),
    [sym_expression] = STATE(1692),
    [sym_primary_expression] = STATE(1404),
    [sym_yield_expression] = STATE(1403),
    [sym_object] = STATE(1405),
    [sym_object_pattern] = STATE(2812),
    [sym_assignment_pattern] = STATE(3431),
    [sym_array] = STATE(1405),
    [sym_array_pattern] = STATE(2812),
    [sym_nested_identifier] = STATE(4074),
    [sym_class] = STATE(1405),
    [sym_function] = STATE(1405),
    [sym_generator_function] = STATE(1405),
    [sym_arrow_function] = STATE(1405),
    [sym__call_signature] = STATE(4121),
    [sym_call_expression] = STATE(1405),
    [sym_new_expression] = STATE(1403),
    [sym_await_expression] = STATE(1403),
    [sym_member_expression] = STATE(1056),
    [sym_subscript_expression] = STATE(1056),
    [sym_assignment_expression] = STATE(1403),
    [sym__augmented_assignment_lhs] = STATE(2344),
    [sym_augmented_assignment_expression] = STATE(1403),
    [sym__destructuring_pattern] = STATE(2812),
    [sym_spread_element] = STATE(3396),
    [sym_ternary_expression] = STATE(1403),
    [sym_binary_expression] = STATE(1403),
    [sym_unary_expression] = STATE(1403),
    [sym_update_expression] = STATE(1403),
    [sym_string] = STATE(1853),
    [sym_template_string] = STATE(1405),
    [sym_regex] = STATE(1405),
    [sym_meta_property] = STATE(1405),
    [sym_decorator] = STATE(1149),
    [sym_formal_parameters] = STATE(3260),
    [sym_pattern] = STATE(3391),
    [sym_rest_pattern] = STATE(3170),
    [sym_non_null_expression] = STATE(1056),
    [sym_type_assertion] = STATE(1403),
    [sym_as_expression] = STATE(1403),
    [sym_internal_module] = STATE(1403),
    [sym_nested_type_identifier] = STATE(2336),
    [sym__type] = STATE(2883),
    [sym_tuple_parameter] = STATE(3474),
    [sym_optional_tuple_parameter] = STATE(3474),
    [sym_optional_type] = STATE(3474),
    [sym_rest_type] = STATE(3474),
    [sym__tuple_type_member] = STATE(3474),
    [sym_constructor_type] = STATE(2883),
    [sym__primary_type] = STATE(2373),
    [sym_template_literal_type] = STATE(2359),
    [sym_infer_type] = STATE(2883),
    [sym_conditional_type] = STATE(2359),
    [sym_generic_type] = STATE(2359),
    [sym_type_query] = STATE(2359),
    [sym_index_type_query] = STATE(2359),
    [sym_lookup_type] = STATE(2359),
    [sym_literal_type] = STATE(2359),
    [sym__number] = STATE(2355),
    [sym_existential_type] = STATE(2359),
    [sym_flow_maybe_type] = STATE(2359),
    [sym_parenthesized_type] = STATE(2359),
    [sym_predefined_type] = STATE(2359),
    [sym_type_arguments] = STATE(502),
    [sym_object_type] = STATE(2359),
    [sym_type_parameters] = STATE(3839),
    [sym_array_type] = STATE(2359),
    [sym_tuple_type] = STATE(2359),
    [sym_readonly_type] = STATE(2883),
    [sym_union_type] = STATE(2359),
    [sym_intersection_type] = STATE(2359),
    [sym_function_type] = STATE(2883),
    [aux_sym_export_statement_repeat1] = STATE(3368),
    [aux_sym_array_repeat1] = STATE(3405),
    [aux_sym_array_pattern_repeat1] = STATE(3400),
    [sym_identifier] = ACTIONS(533),
    [anon_sym_export] = ACTIONS(535),
    [anon_sym_STAR] = ACTIONS(537),
    [anon_sym_type] = ACTIONS(535),
    [anon_sym_namespace] = ACTIONS(539),
    [anon_sym_LBRACE] = ACTIONS(541),
    [anon_sym_COMMA] = ACTIONS(543),
    [anon_sym_typeof] = ACTIONS(545),
    [anon_sym_import] = ACTIONS(125),
    [anon_sym_BANG] = ACTIONS(547),
    [anon_sym_LPAREN] = ACTIONS(130),
    [anon_sym_await] = ACTIONS(549),
    [anon_sym_yield] = ACTIONS(551),
    [anon_sym_LBRACK] = ACTIONS(553),
    [anon_sym_RBRACK] = ACTIONS(599),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(557),
    [anon_sym_class] = ACTIONS(143),
    [anon_sym_async] = ACTIONS(559),
    [anon_sym_function] = ACTIONS(147),
    [anon_sym_new] = ACTIONS(561),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(563),
    [anon_sym_AMP] = ACTIONS(565),
    [anon_sym_PIPE] = ACTIONS(567),
    [anon_sym_PLUS] = ACTIONS(569),
    [anon_sym_DASH] = ACTIONS(569),
    [anon_sym_TILDE] = ACTIONS(547),
    [anon_sym_void] = ACTIONS(571),
    [anon_sym_delete] = ACTIONS(573),
    [anon_sym_PLUS_PLUS] = ACTIONS(575),
    [anon_sym_DASH_DASH] = ACTIONS(575),
    [anon_sym_DQUOTE] = ACTIONS(174),
    [anon_sym_SQUOTE] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(178),
    [sym_number] = ACTIONS(180),
    [sym_this] = ACTIONS(577),
    [sym_super] = ACTIONS(184),
    [sym_true] = ACTIONS(186),
    [sym_false] = ACTIONS(186),
    [sym_null] = ACTIONS(186),
    [sym_undefined] = ACTIONS(579),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(535),
    [anon_sym_readonly] = ACTIONS(581),
    [anon_sym_get] = ACTIONS(535),
    [anon_sym_set] = ACTIONS(535),
    [anon_sym_QMARK] = ACTIONS(583),
    [anon_sym_declare] = ACTIONS(535),
    [anon_sym_public] = ACTIONS(535),
    [anon_sym_private] = ACTIONS(535),
    [anon_sym_protected] = ACTIONS(535),
    [anon_sym_override] = ACTIONS(535),
    [anon_sym_module] = ACTIONS(535),
    [anon_sym_any] = ACTIONS(585),
    [anon_sym_number] = ACTIONS(585),
    [anon_sym_boolean] = ACTIONS(585),
    [anon_sym_string] = ACTIONS(585),
    [anon_sym_symbol] = ACTIONS(585),
    [anon_sym_abstract] = ACTIONS(196),
    [anon_sym_infer] = ACTIONS(198),
    [anon_sym_keyof] = ACTIONS(200),
    [anon_sym_unknown] = ACTIONS(202),
    [anon_sym_never] = ACTIONS(202),
    [anon_sym_object] = ACTIONS(202),
    [anon_sym_LBRACE_PIPE] = ACTIONS(204),
  },
  [55] = {
    [sym_import] = STATE(1405),
    [sym_parenthesized_expression] = STATE(1072),
    [sym_expression] = STATE(1692),
    [sym_primary_expression] = STATE(1404),
    [sym_yield_expression] = STATE(1403),
    [sym_object] = STATE(1405),
    [sym_object_pattern] = STATE(2812),
    [sym_assignment_pattern] = STATE(3431),
    [sym_array] = STATE(1405),
    [sym_array_pattern] = STATE(2812),
    [sym_nested_identifier] = STATE(4074),
    [sym_class] = STATE(1405),
    [sym_function] = STATE(1405),
    [sym_generator_function] = STATE(1405),
    [sym_arrow_function] = STATE(1405),
    [sym__call_signature] = STATE(4121),
    [sym_call_expression] = STATE(1405),
    [sym_new_expression] = STATE(1403),
    [sym_await_expression] = STATE(1403),
    [sym_member_expression] = STATE(1056),
    [sym_subscript_expression] = STATE(1056),
    [sym_assignment_expression] = STATE(1403),
    [sym__augmented_assignment_lhs] = STATE(2344),
    [sym_augmented_assignment_expression] = STATE(1403),
    [sym__destructuring_pattern] = STATE(2812),
    [sym_spread_element] = STATE(3396),
    [sym_ternary_expression] = STATE(1403),
    [sym_binary_expression] = STATE(1403),
    [sym_unary_expression] = STATE(1403),
    [sym_update_expression] = STATE(1403),
    [sym_string] = STATE(1853),
    [sym_template_string] = STATE(1405),
    [sym_regex] = STATE(1405),
    [sym_meta_property] = STATE(1405),
    [sym_decorator] = STATE(1149),
    [sym_formal_parameters] = STATE(3260),
    [sym_pattern] = STATE(3391),
    [sym_rest_pattern] = STATE(3170),
    [sym_non_null_expression] = STATE(1056),
    [sym_type_assertion] = STATE(1403),
    [sym_as_expression] = STATE(1403),
    [sym_internal_module] = STATE(1403),
    [sym_nested_type_identifier] = STATE(2336),
    [sym__type] = STATE(2883),
    [sym_tuple_parameter] = STATE(3474),
    [sym_optional_tuple_parameter] = STATE(3474),
    [sym_optional_type] = STATE(3474),
    [sym_rest_type] = STATE(3474),
    [sym__tuple_type_member] = STATE(3474),
    [sym_constructor_type] = STATE(2883),
    [sym__primary_type] = STATE(2373),
    [sym_template_literal_type] = STATE(2359),
    [sym_infer_type] = STATE(2883),
    [sym_conditional_type] = STATE(2359),
    [sym_generic_type] = STATE(2359),
    [sym_type_query] = STATE(2359),
    [sym_index_type_query] = STATE(2359),
    [sym_lookup_type] = STATE(2359),
    [sym_literal_type] = STATE(2359),
    [sym__number] = STATE(2355),
    [sym_existential_type] = STATE(2359),
    [sym_flow_maybe_type] = STATE(2359),
    [sym_parenthesized_type] = STATE(2359),
    [sym_predefined_type] = STATE(2359),
    [sym_type_arguments] = STATE(502),
    [sym_object_type] = STATE(2359),
    [sym_type_parameters] = STATE(3839),
    [sym_array_type] = STATE(2359),
    [sym_tuple_type] = STATE(2359),
    [sym_readonly_type] = STATE(2883),
    [sym_union_type] = STATE(2359),
    [sym_intersection_type] = STATE(2359),
    [sym_function_type] = STATE(2883),
    [aux_sym_export_statement_repeat1] = STATE(3368),
    [aux_sym_array_repeat1] = STATE(3405),
    [aux_sym_array_pattern_repeat1] = STATE(3400),
    [sym_identifier] = ACTIONS(533),
    [anon_sym_export] = ACTIONS(535),
    [anon_sym_STAR] = ACTIONS(537),
    [anon_sym_type] = ACTIONS(535),
    [anon_sym_namespace] = ACTIONS(539),
    [anon_sym_LBRACE] = ACTIONS(541),
    [anon_sym_COMMA] = ACTIONS(543),
    [anon_sym_typeof] = ACTIONS(545),
    [anon_sym_import] = ACTIONS(125),
    [anon_sym_BANG] = ACTIONS(547),
    [anon_sym_LPAREN] = ACTIONS(130),
    [anon_sym_await] = ACTIONS(549),
    [anon_sym_yield] = ACTIONS(551),
    [anon_sym_LBRACK] = ACTIONS(553),
    [anon_sym_RBRACK] = ACTIONS(601),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(557),
    [anon_sym_class] = ACTIONS(143),
    [anon_sym_async] = ACTIONS(559),
    [anon_sym_function] = ACTIONS(147),
    [anon_sym_new] = ACTIONS(561),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(563),
    [anon_sym_AMP] = ACTIONS(565),
    [anon_sym_PIPE] = ACTIONS(567),
    [anon_sym_PLUS] = ACTIONS(569),
    [anon_sym_DASH] = ACTIONS(569),
    [anon_sym_TILDE] = ACTIONS(547),
    [anon_sym_void] = ACTIONS(571),
    [anon_sym_delete] = ACTIONS(573),
    [anon_sym_PLUS_PLUS] = ACTIONS(575),
    [anon_sym_DASH_DASH] = ACTIONS(575),
    [anon_sym_DQUOTE] = ACTIONS(174),
    [anon_sym_SQUOTE] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(178),
    [sym_number] = ACTIONS(180),
    [sym_this] = ACTIONS(577),
    [sym_super] = ACTIONS(184),
    [sym_true] = ACTIONS(186),
    [sym_false] = ACTIONS(186),
    [sym_null] = ACTIONS(186),
    [sym_undefined] = ACTIONS(579),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(535),
    [anon_sym_readonly] = ACTIONS(581),
    [anon_sym_get] = ACTIONS(535),
    [anon_sym_set] = ACTIONS(535),
    [anon_sym_QMARK] = ACTIONS(583),
    [anon_sym_declare] = ACTIONS(535),
    [anon_sym_public] = ACTIONS(535),
    [anon_sym_private] = ACTIONS(535),
    [anon_sym_protected] = ACTIONS(535),
    [anon_sym_override] = ACTIONS(535),
    [anon_sym_module] = ACTIONS(535),
    [anon_sym_any] = ACTIONS(585),
    [anon_sym_number] = ACTIONS(585),
    [anon_sym_boolean] = ACTIONS(585),
    [anon_sym_string] = ACTIONS(585),
    [anon_sym_symbol] = ACTIONS(585),
    [anon_sym_abstract] = ACTIONS(196),
    [anon_sym_infer] = ACTIONS(198),
    [anon_sym_keyof] = ACTIONS(200),
    [anon_sym_unknown] = ACTIONS(202),
    [anon_sym_never] = ACTIONS(202),
    [anon_sym_object] = ACTIONS(202),
    [anon_sym_LBRACE_PIPE] = ACTIONS(204),
  },
  [56] = {
    [sym_import] = STATE(1405),
    [sym_parenthesized_expression] = STATE(1072),
    [sym_expression] = STATE(1692),
    [sym_primary_expression] = STATE(1404),
    [sym_yield_expression] = STATE(1403),
    [sym_object] = STATE(1405),
    [sym_object_pattern] = STATE(2812),
    [sym_assignment_pattern] = STATE(3431),
    [sym_array] = STATE(1405),
    [sym_array_pattern] = STATE(2812),
    [sym_nested_identifier] = STATE(4074),
    [sym_class] = STATE(1405),
    [sym_function] = STATE(1405),
    [sym_generator_function] = STATE(1405),
    [sym_arrow_function] = STATE(1405),
    [sym__call_signature] = STATE(4121),
    [sym_call_expression] = STATE(1405),
    [sym_new_expression] = STATE(1403),
    [sym_await_expression] = STATE(1403),
    [sym_member_expression] = STATE(1056),
    [sym_subscript_expression] = STATE(1056),
    [sym_assignment_expression] = STATE(1403),
    [sym__augmented_assignment_lhs] = STATE(2344),
    [sym_augmented_assignment_expression] = STATE(1403),
    [sym__destructuring_pattern] = STATE(2812),
    [sym_spread_element] = STATE(3396),
    [sym_ternary_expression] = STATE(1403),
    [sym_binary_expression] = STATE(1403),
    [sym_unary_expression] = STATE(1403),
    [sym_update_expression] = STATE(1403),
    [sym_string] = STATE(1853),
    [sym_template_string] = STATE(1405),
    [sym_regex] = STATE(1405),
    [sym_meta_property] = STATE(1405),
    [sym_decorator] = STATE(1149),
    [sym_formal_parameters] = STATE(3260),
    [sym_pattern] = STATE(3391),
    [sym_rest_pattern] = STATE(3170),
    [sym_non_null_expression] = STATE(1056),
    [sym_type_assertion] = STATE(1403),
    [sym_as_expression] = STATE(1403),
    [sym_internal_module] = STATE(1403),
    [sym_nested_type_identifier] = STATE(2336),
    [sym__type] = STATE(2883),
    [sym_tuple_parameter] = STATE(3474),
    [sym_optional_tuple_parameter] = STATE(3474),
    [sym_optional_type] = STATE(3474),
    [sym_rest_type] = STATE(3474),
    [sym__tuple_type_member] = STATE(3474),
    [sym_constructor_type] = STATE(2883),
    [sym__primary_type] = STATE(2373),
    [sym_template_literal_type] = STATE(2359),
    [sym_infer_type] = STATE(2883),
    [sym_conditional_type] = STATE(2359),
    [sym_generic_type] = STATE(2359),
    [sym_type_query] = STATE(2359),
    [sym_index_type_query] = STATE(2359),
    [sym_lookup_type] = STATE(2359),
    [sym_literal_type] = STATE(2359),
    [sym__number] = STATE(2355),
    [sym_existential_type] = STATE(2359),
    [sym_flow_maybe_type] = STATE(2359),
    [sym_parenthesized_type] = STATE(2359),
    [sym_predefined_type] = STATE(2359),
    [sym_type_arguments] = STATE(502),
    [sym_object_type] = STATE(2359),
    [sym_type_parameters] = STATE(3839),
    [sym_array_type] = STATE(2359),
    [sym_tuple_type] = STATE(2359),
    [sym_readonly_type] = STATE(2883),
    [sym_union_type] = STATE(2359),
    [sym_intersection_type] = STATE(2359),
    [sym_function_type] = STATE(2883),
    [aux_sym_export_statement_repeat1] = STATE(3368),
    [aux_sym_array_repeat1] = STATE(3405),
    [aux_sym_array_pattern_repeat1] = STATE(3400),
    [sym_identifier] = ACTIONS(533),
    [anon_sym_export] = ACTIONS(535),
    [anon_sym_STAR] = ACTIONS(537),
    [anon_sym_type] = ACTIONS(535),
    [anon_sym_namespace] = ACTIONS(539),
    [anon_sym_LBRACE] = ACTIONS(541),
    [anon_sym_COMMA] = ACTIONS(543),
    [anon_sym_typeof] = ACTIONS(545),
    [anon_sym_import] = ACTIONS(125),
    [anon_sym_BANG] = ACTIONS(547),
    [anon_sym_LPAREN] = ACTIONS(130),
    [anon_sym_await] = ACTIONS(549),
    [anon_sym_yield] = ACTIONS(551),
    [anon_sym_LBRACK] = ACTIONS(553),
    [anon_sym_RBRACK] = ACTIONS(603),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(557),
    [anon_sym_class] = ACTIONS(143),
    [anon_sym_async] = ACTIONS(559),
    [anon_sym_function] = ACTIONS(147),
    [anon_sym_new] = ACTIONS(561),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(563),
    [anon_sym_AMP] = ACTIONS(565),
    [anon_sym_PIPE] = ACTIONS(567),
    [anon_sym_PLUS] = ACTIONS(569),
    [anon_sym_DASH] = ACTIONS(569),
    [anon_sym_TILDE] = ACTIONS(547),
    [anon_sym_void] = ACTIONS(571),
    [anon_sym_delete] = ACTIONS(573),
    [anon_sym_PLUS_PLUS] = ACTIONS(575),
    [anon_sym_DASH_DASH] = ACTIONS(575),
    [anon_sym_DQUOTE] = ACTIONS(174),
    [anon_sym_SQUOTE] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(178),
    [sym_number] = ACTIONS(180),
    [sym_this] = ACTIONS(577),
    [sym_super] = ACTIONS(184),
    [sym_true] = ACTIONS(186),
    [sym_false] = ACTIONS(186),
    [sym_null] = ACTIONS(186),
    [sym_undefined] = ACTIONS(579),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(535),
    [anon_sym_readonly] = ACTIONS(581),
    [anon_sym_get] = ACTIONS(535),
    [anon_sym_set] = ACTIONS(535),
    [anon_sym_QMARK] = ACTIONS(583),
    [anon_sym_declare] = ACTIONS(535),
    [anon_sym_public] = ACTIONS(535),
    [anon_sym_private] = ACTIONS(535),
    [anon_sym_protected] = ACTIONS(535),
    [anon_sym_override] = ACTIONS(535),
    [anon_sym_module] = ACTIONS(535),
    [anon_sym_any] = ACTIONS(585),
    [anon_sym_number] = ACTIONS(585),
    [anon_sym_boolean] = ACTIONS(585),
    [anon_sym_string] = ACTIONS(585),
    [anon_sym_symbol] = ACTIONS(585),
    [anon_sym_abstract] = ACTIONS(196),
    [anon_sym_infer] = ACTIONS(198),
    [anon_sym_keyof] = ACTIONS(200),
    [anon_sym_unknown] = ACTIONS(202),
    [anon_sym_never] = ACTIONS(202),
    [anon_sym_object] = ACTIONS(202),
    [anon_sym_LBRACE_PIPE] = ACTIONS(204),
  },
  [57] = {
    [sym_import] = STATE(1405),
    [sym_parenthesized_expression] = STATE(1072),
    [sym_expression] = STATE(1692),
    [sym_primary_expression] = STATE(1404),
    [sym_yield_expression] = STATE(1403),
    [sym_object] = STATE(1405),
    [sym_object_pattern] = STATE(2812),
    [sym_assignment_pattern] = STATE(3431),
    [sym_array] = STATE(1405),
    [sym_array_pattern] = STATE(2812),
    [sym_nested_identifier] = STATE(4074),
    [sym_class] = STATE(1405),
    [sym_function] = STATE(1405),
    [sym_generator_function] = STATE(1405),
    [sym_arrow_function] = STATE(1405),
    [sym__call_signature] = STATE(4121),
    [sym_call_expression] = STATE(1405),
    [sym_new_expression] = STATE(1403),
    [sym_await_expression] = STATE(1403),
    [sym_member_expression] = STATE(1056),
    [sym_subscript_expression] = STATE(1056),
    [sym_assignment_expression] = STATE(1403),
    [sym__augmented_assignment_lhs] = STATE(2344),
    [sym_augmented_assignment_expression] = STATE(1403),
    [sym__destructuring_pattern] = STATE(2812),
    [sym_spread_element] = STATE(3396),
    [sym_ternary_expression] = STATE(1403),
    [sym_binary_expression] = STATE(1403),
    [sym_unary_expression] = STATE(1403),
    [sym_update_expression] = STATE(1403),
    [sym_string] = STATE(1853),
    [sym_template_string] = STATE(1405),
    [sym_regex] = STATE(1405),
    [sym_meta_property] = STATE(1405),
    [sym_decorator] = STATE(1149),
    [sym_formal_parameters] = STATE(3260),
    [sym_pattern] = STATE(3391),
    [sym_rest_pattern] = STATE(3170),
    [sym_non_null_expression] = STATE(1056),
    [sym_type_assertion] = STATE(1403),
    [sym_as_expression] = STATE(1403),
    [sym_internal_module] = STATE(1403),
    [sym_nested_type_identifier] = STATE(2336),
    [sym__type] = STATE(2883),
    [sym_tuple_parameter] = STATE(3474),
    [sym_optional_tuple_parameter] = STATE(3474),
    [sym_optional_type] = STATE(3474),
    [sym_rest_type] = STATE(3474),
    [sym__tuple_type_member] = STATE(3474),
    [sym_constructor_type] = STATE(2883),
    [sym__primary_type] = STATE(2373),
    [sym_template_literal_type] = STATE(2359),
    [sym_infer_type] = STATE(2883),
    [sym_conditional_type] = STATE(2359),
    [sym_generic_type] = STATE(2359),
    [sym_type_query] = STATE(2359),
    [sym_index_type_query] = STATE(2359),
    [sym_lookup_type] = STATE(2359),
    [sym_literal_type] = STATE(2359),
    [sym__number] = STATE(2355),
    [sym_existential_type] = STATE(2359),
    [sym_flow_maybe_type] = STATE(2359),
    [sym_parenthesized_type] = STATE(2359),
    [sym_predefined_type] = STATE(2359),
    [sym_type_arguments] = STATE(502),
    [sym_object_type] = STATE(2359),
    [sym_type_parameters] = STATE(3839),
    [sym_array_type] = STATE(2359),
    [sym_tuple_type] = STATE(2359),
    [sym_readonly_type] = STATE(2883),
    [sym_union_type] = STATE(2359),
    [sym_intersection_type] = STATE(2359),
    [sym_function_type] = STATE(2883),
    [aux_sym_export_statement_repeat1] = STATE(3368),
    [aux_sym_array_repeat1] = STATE(3405),
    [aux_sym_array_pattern_repeat1] = STATE(3400),
    [sym_identifier] = ACTIONS(533),
    [anon_sym_export] = ACTIONS(535),
    [anon_sym_STAR] = ACTIONS(537),
    [anon_sym_type] = ACTIONS(535),
    [anon_sym_namespace] = ACTIONS(539),
    [anon_sym_LBRACE] = ACTIONS(541),
    [anon_sym_COMMA] = ACTIONS(543),
    [anon_sym_typeof] = ACTIONS(545),
    [anon_sym_import] = ACTIONS(125),
    [anon_sym_BANG] = ACTIONS(547),
    [anon_sym_LPAREN] = ACTIONS(130),
    [anon_sym_await] = ACTIONS(549),
    [anon_sym_yield] = ACTIONS(551),
    [anon_sym_LBRACK] = ACTIONS(553),
    [anon_sym_RBRACK] = ACTIONS(605),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(557),
    [anon_sym_class] = ACTIONS(143),
    [anon_sym_async] = ACTIONS(559),
    [anon_sym_function] = ACTIONS(147),
    [anon_sym_new] = ACTIONS(561),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(563),
    [anon_sym_AMP] = ACTIONS(565),
    [anon_sym_PIPE] = ACTIONS(567),
    [anon_sym_PLUS] = ACTIONS(569),
    [anon_sym_DASH] = ACTIONS(569),
    [anon_sym_TILDE] = ACTIONS(547),
    [anon_sym_void] = ACTIONS(571),
    [anon_sym_delete] = ACTIONS(573),
    [anon_sym_PLUS_PLUS] = ACTIONS(575),
    [anon_sym_DASH_DASH] = ACTIONS(575),
    [anon_sym_DQUOTE] = ACTIONS(174),
    [anon_sym_SQUOTE] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(178),
    [sym_number] = ACTIONS(180),
    [sym_this] = ACTIONS(577),
    [sym_super] = ACTIONS(184),
    [sym_true] = ACTIONS(186),
    [sym_false] = ACTIONS(186),
    [sym_null] = ACTIONS(186),
    [sym_undefined] = ACTIONS(579),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(535),
    [anon_sym_readonly] = ACTIONS(581),
    [anon_sym_get] = ACTIONS(535),
    [anon_sym_set] = ACTIONS(535),
    [anon_sym_QMARK] = ACTIONS(583),
    [anon_sym_declare] = ACTIONS(535),
    [anon_sym_public] = ACTIONS(535),
    [anon_sym_private] = ACTIONS(535),
    [anon_sym_protected] = ACTIONS(535),
    [anon_sym_override] = ACTIONS(535),
    [anon_sym_module] = ACTIONS(535),
    [anon_sym_any] = ACTIONS(585),
    [anon_sym_number] = ACTIONS(585),
    [anon_sym_boolean] = ACTIONS(585),
    [anon_sym_string] = ACTIONS(585),
    [anon_sym_symbol] = ACTIONS(585),
    [anon_sym_abstract] = ACTIONS(196),
    [anon_sym_infer] = ACTIONS(198),
    [anon_sym_keyof] = ACTIONS(200),
    [anon_sym_unknown] = ACTIONS(202),
    [anon_sym_never] = ACTIONS(202),
    [anon_sym_object] = ACTIONS(202),
    [anon_sym_LBRACE_PIPE] = ACTIONS(204),
  },
  [58] = {
    [sym_import] = STATE(1405),
    [sym_parenthesized_expression] = STATE(1023),
    [sym_expression] = STATE(2015),
    [sym_primary_expression] = STATE(1404),
    [sym_yield_expression] = STATE(1403),
    [sym_object] = STATE(1405),
    [sym_object_pattern] = STATE(2733),
    [sym_array] = STATE(1405),
    [sym_array_pattern] = STATE(2733),
    [sym_class] = STATE(1405),
    [sym_function] = STATE(1405),
    [sym_generator_function] = STATE(1405),
    [sym_arrow_function] = STATE(1405),
    [sym__call_signature] = STATE(4016),
    [sym_call_expression] = STATE(1405),
    [sym_new_expression] = STATE(1403),
    [sym_await_expression] = STATE(1403),
    [sym_member_expression] = STATE(1058),
    [sym_subscript_expression] = STATE(1058),
    [sym_assignment_expression] = STATE(1403),
    [sym__augmented_assignment_lhs] = STATE(2340),
    [sym_augmented_assignment_expression] = STATE(1403),
    [sym__destructuring_pattern] = STATE(2733),
    [sym_ternary_expression] = STATE(1403),
    [sym_binary_expression] = STATE(1403),
    [sym_unary_expression] = STATE(1403),
    [sym_update_expression] = STATE(1403),
    [sym_string] = STATE(1405),
    [sym_template_string] = STATE(1405),
    [sym_regex] = STATE(1405),
    [sym_meta_property] = STATE(1405),
    [sym_decorator] = STATE(1149),
    [sym_formal_parameters] = STATE(2903),
    [sym_pattern] = STATE(3166),
    [sym_rest_pattern] = STATE(2817),
    [sym_non_null_expression] = STATE(1058),
    [sym_type_assertion] = STATE(1403),
    [sym_as_expression] = STATE(1403),
    [sym_internal_module] = STATE(1403),
    [sym_type_arguments] = STATE(519),
    [sym_type_parameters] = STATE(3670),
    [aux_sym_export_statement_repeat1] = STATE(3368),
    [sym_identifier] = ACTIONS(607),
    [anon_sym_export] = ACTIONS(107),
    [anon_sym_STAR] = ACTIONS(114),
    [anon_sym_type] = ACTIONS(107),
    [anon_sym_EQ] = ACTIONS(206),
    [anon_sym_as] = ACTIONS(114),
    [anon_sym_namespace] = ACTIONS(116),
    [anon_sym_LBRACE] = ACTIONS(609),
    [anon_sym_COMMA] = ACTIONS(209),
    [anon_sym_typeof] = ACTIONS(169),
    [anon_sym_import] = ACTIONS(125),
    [anon_sym_BANG] = ACTIONS(127),
    [anon_sym_LPAREN] = ACTIONS(611),
    [anon_sym_RPAREN] = ACTIONS(209),
    [anon_sym_await] = ACTIONS(132),
    [anon_sym_in] = ACTIONS(114),
    [anon_sym_COLON] = ACTIONS(209),
    [anon_sym_yield] = ACTIONS(134),
    [anon_sym_LBRACK] = ACTIONS(614),
    [anon_sym_LT] = ACTIONS(617),
    [anon_sym_GT] = ACTIONS(114),
    [anon_sym_SLASH] = ACTIONS(140),
    [anon_sym_DOT] = ACTIONS(114),
    [anon_sym_class] = ACTIONS(143),
    [anon_sym_async] = ACTIONS(145),
    [anon_sym_function] = ACTIONS(147),
    [anon_sym_EQ_GT] = ACTIONS(211),
    [anon_sym_QMARK_DOT] = ACTIONS(151),
    [anon_sym_new] = ACTIONS(620),
    [anon_sym_PLUS_EQ] = ACTIONS(155),
    [anon_sym_DASH_EQ] = ACTIONS(155),
    [anon_sym_STAR_EQ] = ACTIONS(155),
    [anon_sym_SLASH_EQ] = ACTIONS(155),
    [anon_sym_PERCENT_EQ] = ACTIONS(155),
    [anon_sym_CARET_EQ] = ACTIONS(155),
    [anon_sym_AMP_EQ] = ACTIONS(155),
    [anon_sym_PIPE_EQ] = ACTIONS(155),
    [anon_sym_GT_GT_EQ] = ACTIONS(155),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(155),
    [anon_sym_LT_LT_EQ] = ACTIONS(155),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(155),
    [anon_sym_AMP_AMP_EQ] = ACTIONS(155),
    [anon_sym_PIPE_PIPE_EQ] = ACTIONS(155),
    [anon_sym_QMARK_QMARK_EQ] = ACTIONS(155),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(157),
    [anon_sym_AMP_AMP] = ACTIONS(114),
    [anon_sym_PIPE_PIPE] = ACTIONS(114),
    [anon_sym_GT_GT] = ACTIONS(114),
    [anon_sym_GT_GT_GT] = ACTIONS(114),
    [anon_sym_LT_LT] = ACTIONS(114),
    [anon_sym_AMP] = ACTIONS(114),
    [anon_sym_CARET] = ACTIONS(114),
    [anon_sym_PIPE] = ACTIONS(114),
    [anon_sym_PLUS] = ACTIONS(127),
    [anon_sym_DASH] = ACTIONS(127),
    [anon_sym_PERCENT] = ACTIONS(114),
    [anon_sym_STAR_STAR] = ACTIONS(114),
    [anon_sym_LT_EQ] = ACTIONS(151),
    [anon_sym_EQ_EQ] = ACTIONS(114),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(151),
    [anon_sym_BANG_EQ] = ACTIONS(114),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(151),
    [anon_sym_GT_EQ] = ACTIONS(151),
    [anon_sym_QMARK_QMARK] = ACTIONS(114),
    [anon_sym_instanceof] = ACTIONS(114),
    [anon_sym_TILDE] = ACTIONS(165),
    [anon_sym_void] = ACTIONS(169),
    [anon_sym_delete] = ACTIONS(169),
    [anon_sym_PLUS_PLUS] = ACTIONS(171),
    [anon_sym_DASH_DASH] = ACTIONS(171),
    [anon_sym_DQUOTE] = ACTIONS(174),
    [anon_sym_SQUOTE] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(622),
    [sym_number] = ACTIONS(625),
    [sym_this] = ACTIONS(627),
    [sym_super] = ACTIONS(184),
    [sym_true] = ACTIONS(184),
    [sym_false] = ACTIONS(184),
    [sym_null] = ACTIONS(184),
    [sym_undefined] = ACTIONS(629),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(107),
    [anon_sym_readonly] = ACTIONS(107),
    [anon_sym_get] = ACTIONS(107),
    [anon_sym_set] = ACTIONS(107),
    [anon_sym_QMARK] = ACTIONS(631),
    [anon_sym_declare] = ACTIONS(107),
    [anon_sym_public] = ACTIONS(107),
    [anon_sym_private] = ACTIONS(107),
    [anon_sym_protected] = ACTIONS(107),
    [anon_sym_override] = ACTIONS(107),
    [anon_sym_module] = ACTIONS(107),
    [anon_sym_any] = ACTIONS(107),
    [anon_sym_number] = ACTIONS(107),
    [anon_sym_boolean] = ACTIONS(107),
    [anon_sym_string] = ACTIONS(107),
    [anon_sym_symbol] = ACTIONS(107),
    [sym__ternary_qmark] = ACTIONS(151),
  },
  [59] = {
    [sym_import] = STATE(1405),
    [sym_parenthesized_expression] = STATE(1023),
    [sym_expression] = STATE(2015),
    [sym_primary_expression] = STATE(1404),
    [sym_yield_expression] = STATE(1403),
    [sym_object] = STATE(1405),
    [sym_object_pattern] = STATE(2733),
    [sym_array] = STATE(1405),
    [sym_array_pattern] = STATE(2733),
    [sym_class] = STATE(1405),
    [sym_function] = STATE(1405),
    [sym_generator_function] = STATE(1405),
    [sym_arrow_function] = STATE(1405),
    [sym__call_signature] = STATE(4016),
    [sym_call_expression] = STATE(1405),
    [sym_new_expression] = STATE(1403),
    [sym_await_expression] = STATE(1403),
    [sym_member_expression] = STATE(1058),
    [sym_subscript_expression] = STATE(1058),
    [sym_assignment_expression] = STATE(1403),
    [sym__augmented_assignment_lhs] = STATE(2340),
    [sym_augmented_assignment_expression] = STATE(1403),
    [sym__destructuring_pattern] = STATE(2733),
    [sym_ternary_expression] = STATE(1403),
    [sym_binary_expression] = STATE(1403),
    [sym_unary_expression] = STATE(1403),
    [sym_update_expression] = STATE(1403),
    [sym_string] = STATE(1405),
    [sym_template_string] = STATE(1405),
    [sym_regex] = STATE(1405),
    [sym_meta_property] = STATE(1405),
    [sym_decorator] = STATE(1149),
    [sym_formal_parameters] = STATE(2903),
    [sym_pattern] = STATE(3061),
    [sym_rest_pattern] = STATE(2817),
    [sym_non_null_expression] = STATE(1058),
    [sym_type_assertion] = STATE(1403),
    [sym_as_expression] = STATE(1403),
    [sym_internal_module] = STATE(1403),
    [sym_type_arguments] = STATE(519),
    [sym_type_parameters] = STATE(3670),
    [aux_sym_export_statement_repeat1] = STATE(3368),
    [sym_identifier] = ACTIONS(607),
    [anon_sym_export] = ACTIONS(107),
    [anon_sym_STAR] = ACTIONS(114),
    [anon_sym_type] = ACTIONS(107),
    [anon_sym_EQ] = ACTIONS(206),
    [anon_sym_as] = ACTIONS(114),
    [anon_sym_namespace] = ACTIONS(116),
    [anon_sym_LBRACE] = ACTIONS(609),
    [anon_sym_COMMA] = ACTIONS(209),
    [anon_sym_typeof] = ACTIONS(169),
    [anon_sym_import] = ACTIONS(125),
    [anon_sym_BANG] = ACTIONS(127),
    [anon_sym_LPAREN] = ACTIONS(611),
    [anon_sym_RPAREN] = ACTIONS(209),
    [anon_sym_await] = ACTIONS(132),
    [anon_sym_in] = ACTIONS(114),
    [anon_sym_COLON] = ACTIONS(209),
    [anon_sym_yield] = ACTIONS(134),
    [anon_sym_LBRACK] = ACTIONS(614),
    [anon_sym_LT] = ACTIONS(617),
    [anon_sym_GT] = ACTIONS(114),
    [anon_sym_SLASH] = ACTIONS(140),
    [anon_sym_DOT] = ACTIONS(114),
    [anon_sym_class] = ACTIONS(143),
    [anon_sym_async] = ACTIONS(145),
    [anon_sym_function] = ACTIONS(147),
    [anon_sym_EQ_GT] = ACTIONS(211),
    [anon_sym_QMARK_DOT] = ACTIONS(151),
    [anon_sym_new] = ACTIONS(620),
    [anon_sym_PLUS_EQ] = ACTIONS(155),
    [anon_sym_DASH_EQ] = ACTIONS(155),
    [anon_sym_STAR_EQ] = ACTIONS(155),
    [anon_sym_SLASH_EQ] = ACTIONS(155),
    [anon_sym_PERCENT_EQ] = ACTIONS(155),
    [anon_sym_CARET_EQ] = ACTIONS(155),
    [anon_sym_AMP_EQ] = ACTIONS(155),
    [anon_sym_PIPE_EQ] = ACTIONS(155),
    [anon_sym_GT_GT_EQ] = ACTIONS(155),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(155),
    [anon_sym_LT_LT_EQ] = ACTIONS(155),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(155),
    [anon_sym_AMP_AMP_EQ] = ACTIONS(155),
    [anon_sym_PIPE_PIPE_EQ] = ACTIONS(155),
    [anon_sym_QMARK_QMARK_EQ] = ACTIONS(155),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(157),
    [anon_sym_AMP_AMP] = ACTIONS(114),
    [anon_sym_PIPE_PIPE] = ACTIONS(114),
    [anon_sym_GT_GT] = ACTIONS(114),
    [anon_sym_GT_GT_GT] = ACTIONS(114),
    [anon_sym_LT_LT] = ACTIONS(114),
    [anon_sym_AMP] = ACTIONS(114),
    [anon_sym_CARET] = ACTIONS(114),
    [anon_sym_PIPE] = ACTIONS(114),
    [anon_sym_PLUS] = ACTIONS(127),
    [anon_sym_DASH] = ACTIONS(127),
    [anon_sym_PERCENT] = ACTIONS(114),
    [anon_sym_STAR_STAR] = ACTIONS(114),
    [anon_sym_LT_EQ] = ACTIONS(151),
    [anon_sym_EQ_EQ] = ACTIONS(114),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(151),
    [anon_sym_BANG_EQ] = ACTIONS(114),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(151),
    [anon_sym_GT_EQ] = ACTIONS(151),
    [anon_sym_QMARK_QMARK] = ACTIONS(114),
    [anon_sym_instanceof] = ACTIONS(114),
    [anon_sym_TILDE] = ACTIONS(165),
    [anon_sym_void] = ACTIONS(169),
    [anon_sym_delete] = ACTIONS(169),
    [anon_sym_PLUS_PLUS] = ACTIONS(171),
    [anon_sym_DASH_DASH] = ACTIONS(171),
    [anon_sym_DQUOTE] = ACTIONS(174),
    [anon_sym_SQUOTE] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(622),
    [sym_number] = ACTIONS(625),
    [sym_this] = ACTIONS(633),
    [sym_super] = ACTIONS(184),
    [sym_true] = ACTIONS(184),
    [sym_false] = ACTIONS(184),
    [sym_null] = ACTIONS(184),
    [sym_undefined] = ACTIONS(629),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(107),
    [anon_sym_readonly] = ACTIONS(107),
    [anon_sym_get] = ACTIONS(107),
    [anon_sym_set] = ACTIONS(107),
    [anon_sym_QMARK] = ACTIONS(631),
    [anon_sym_declare] = ACTIONS(107),
    [anon_sym_public] = ACTIONS(107),
    [anon_sym_private] = ACTIONS(107),
    [anon_sym_protected] = ACTIONS(107),
    [anon_sym_override] = ACTIONS(107),
    [anon_sym_module] = ACTIONS(107),
    [anon_sym_any] = ACTIONS(107),
    [anon_sym_number] = ACTIONS(107),
    [anon_sym_boolean] = ACTIONS(107),
    [anon_sym_string] = ACTIONS(107),
    [anon_sym_symbol] = ACTIONS(107),
    [sym__ternary_qmark] = ACTIONS(151),
  },
  [60] = {
    [sym_import] = STATE(1405),
    [sym_parenthesized_expression] = STATE(1023),
    [sym_expression] = STATE(2015),
    [sym_primary_expression] = STATE(1404),
    [sym_yield_expression] = STATE(1403),
    [sym_object] = STATE(1405),
    [sym_object_pattern] = STATE(2733),
    [sym_array] = STATE(1405),
    [sym_array_pattern] = STATE(2733),
    [sym_class] = STATE(1405),
    [sym_function] = STATE(1405),
    [sym_generator_function] = STATE(1405),
    [sym_arrow_function] = STATE(1405),
    [sym__call_signature] = STATE(4016),
    [sym_call_expression] = STATE(1405),
    [sym_new_expression] = STATE(1403),
    [sym_await_expression] = STATE(1403),
    [sym_member_expression] = STATE(1058),
    [sym_subscript_expression] = STATE(1058),
    [sym_assignment_expression] = STATE(1403),
    [sym__augmented_assignment_lhs] = STATE(2340),
    [sym_augmented_assignment_expression] = STATE(1403),
    [sym__destructuring_pattern] = STATE(2733),
    [sym_ternary_expression] = STATE(1403),
    [sym_binary_expression] = STATE(1403),
    [sym_unary_expression] = STATE(1403),
    [sym_update_expression] = STATE(1403),
    [sym_string] = STATE(1405),
    [sym_template_string] = STATE(1405),
    [sym_regex] = STATE(1405),
    [sym_meta_property] = STATE(1405),
    [sym_decorator] = STATE(1149),
    [sym_formal_parameters] = STATE(2903),
    [sym_pattern] = STATE(3249),
    [sym_rest_pattern] = STATE(2817),
    [sym_non_null_expression] = STATE(1058),
    [sym_type_assertion] = STATE(1403),
    [sym_as_expression] = STATE(1403),
    [sym_internal_module] = STATE(1403),
    [sym_type_arguments] = STATE(519),
    [sym_type_parameters] = STATE(3670),
    [aux_sym_export_statement_repeat1] = STATE(3368),
    [sym_identifier] = ACTIONS(607),
    [anon_sym_export] = ACTIONS(107),
    [anon_sym_STAR] = ACTIONS(114),
    [anon_sym_type] = ACTIONS(107),
    [anon_sym_EQ] = ACTIONS(206),
    [anon_sym_as] = ACTIONS(114),
    [anon_sym_namespace] = ACTIONS(116),
    [anon_sym_LBRACE] = ACTIONS(609),
    [anon_sym_COMMA] = ACTIONS(209),
    [anon_sym_typeof] = ACTIONS(169),
    [anon_sym_import] = ACTIONS(125),
    [anon_sym_BANG] = ACTIONS(127),
    [anon_sym_LPAREN] = ACTIONS(611),
    [anon_sym_RPAREN] = ACTIONS(209),
    [anon_sym_await] = ACTIONS(132),
    [anon_sym_in] = ACTIONS(114),
    [anon_sym_COLON] = ACTIONS(209),
    [anon_sym_yield] = ACTIONS(134),
    [anon_sym_LBRACK] = ACTIONS(614),
    [anon_sym_LT] = ACTIONS(617),
    [anon_sym_GT] = ACTIONS(114),
    [anon_sym_SLASH] = ACTIONS(140),
    [anon_sym_DOT] = ACTIONS(114),
    [anon_sym_class] = ACTIONS(143),
    [anon_sym_async] = ACTIONS(145),
    [anon_sym_function] = ACTIONS(147),
    [anon_sym_EQ_GT] = ACTIONS(211),
    [anon_sym_QMARK_DOT] = ACTIONS(151),
    [anon_sym_new] = ACTIONS(620),
    [anon_sym_PLUS_EQ] = ACTIONS(155),
    [anon_sym_DASH_EQ] = ACTIONS(155),
    [anon_sym_STAR_EQ] = ACTIONS(155),
    [anon_sym_SLASH_EQ] = ACTIONS(155),
    [anon_sym_PERCENT_EQ] = ACTIONS(155),
    [anon_sym_CARET_EQ] = ACTIONS(155),
    [anon_sym_AMP_EQ] = ACTIONS(155),
    [anon_sym_PIPE_EQ] = ACTIONS(155),
    [anon_sym_GT_GT_EQ] = ACTIONS(155),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(155),
    [anon_sym_LT_LT_EQ] = ACTIONS(155),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(155),
    [anon_sym_AMP_AMP_EQ] = ACTIONS(155),
    [anon_sym_PIPE_PIPE_EQ] = ACTIONS(155),
    [anon_sym_QMARK_QMARK_EQ] = ACTIONS(155),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(157),
    [anon_sym_AMP_AMP] = ACTIONS(114),
    [anon_sym_PIPE_PIPE] = ACTIONS(114),
    [anon_sym_GT_GT] = ACTIONS(114),
    [anon_sym_GT_GT_GT] = ACTIONS(114),
    [anon_sym_LT_LT] = ACTIONS(114),
    [anon_sym_AMP] = ACTIONS(114),
    [anon_sym_CARET] = ACTIONS(114),
    [anon_sym_PIPE] = ACTIONS(114),
    [anon_sym_PLUS] = ACTIONS(127),
    [anon_sym_DASH] = ACTIONS(127),
    [anon_sym_PERCENT] = ACTIONS(114),
    [anon_sym_STAR_STAR] = ACTIONS(114),
    [anon_sym_LT_EQ] = ACTIONS(151),
    [anon_sym_EQ_EQ] = ACTIONS(114),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(151),
    [anon_sym_BANG_EQ] = ACTIONS(114),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(151),
    [anon_sym_GT_EQ] = ACTIONS(151),
    [anon_sym_QMARK_QMARK] = ACTIONS(114),
    [anon_sym_instanceof] = ACTIONS(114),
    [anon_sym_TILDE] = ACTIONS(165),
    [anon_sym_void] = ACTIONS(169),
    [anon_sym_delete] = ACTIONS(169),
    [anon_sym_PLUS_PLUS] = ACTIONS(171),
    [anon_sym_DASH_DASH] = ACTIONS(171),
    [anon_sym_DQUOTE] = ACTIONS(174),
    [anon_sym_SQUOTE] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(622),
    [sym_number] = ACTIONS(625),
    [sym_this] = ACTIONS(635),
    [sym_super] = ACTIONS(184),
    [sym_true] = ACTIONS(184),
    [sym_false] = ACTIONS(184),
    [sym_null] = ACTIONS(184),
    [sym_undefined] = ACTIONS(629),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(107),
    [anon_sym_readonly] = ACTIONS(107),
    [anon_sym_get] = ACTIONS(107),
    [anon_sym_set] = ACTIONS(107),
    [anon_sym_QMARK] = ACTIONS(631),
    [anon_sym_declare] = ACTIONS(107),
    [anon_sym_public] = ACTIONS(107),
    [anon_sym_private] = ACTIONS(107),
    [anon_sym_protected] = ACTIONS(107),
    [anon_sym_override] = ACTIONS(107),
    [anon_sym_module] = ACTIONS(107),
    [anon_sym_any] = ACTIONS(107),
    [anon_sym_number] = ACTIONS(107),
    [anon_sym_boolean] = ACTIONS(107),
    [anon_sym_string] = ACTIONS(107),
    [anon_sym_symbol] = ACTIONS(107),
    [sym__ternary_qmark] = ACTIONS(151),
  },
  [61] = {
    [sym_import] = STATE(1405),
    [sym_parenthesized_expression] = STATE(1023),
    [sym_expression] = STATE(2015),
    [sym_primary_expression] = STATE(1404),
    [sym_yield_expression] = STATE(1403),
    [sym_object] = STATE(1405),
    [sym_object_pattern] = STATE(2733),
    [sym_array] = STATE(1405),
    [sym_array_pattern] = STATE(2733),
    [sym_class] = STATE(1405),
    [sym_function] = STATE(1405),
    [sym_generator_function] = STATE(1405),
    [sym_arrow_function] = STATE(1405),
    [sym__call_signature] = STATE(4016),
    [sym_call_expression] = STATE(1405),
    [sym_new_expression] = STATE(1403),
    [sym_await_expression] = STATE(1403),
    [sym_member_expression] = STATE(1058),
    [sym_subscript_expression] = STATE(1058),
    [sym_assignment_expression] = STATE(1403),
    [sym__augmented_assignment_lhs] = STATE(2340),
    [sym_augmented_assignment_expression] = STATE(1403),
    [sym__destructuring_pattern] = STATE(2733),
    [sym_ternary_expression] = STATE(1403),
    [sym_binary_expression] = STATE(1403),
    [sym_unary_expression] = STATE(1403),
    [sym_update_expression] = STATE(1403),
    [sym_string] = STATE(1405),
    [sym_template_string] = STATE(1405),
    [sym_regex] = STATE(1405),
    [sym_meta_property] = STATE(1405),
    [sym_decorator] = STATE(1149),
    [sym_formal_parameters] = STATE(2903),
    [sym_pattern] = STATE(3191),
    [sym_rest_pattern] = STATE(2817),
    [sym_non_null_expression] = STATE(1058),
    [sym_type_assertion] = STATE(1403),
    [sym_as_expression] = STATE(1403),
    [sym_internal_module] = STATE(1403),
    [sym_type_arguments] = STATE(519),
    [sym_type_parameters] = STATE(3670),
    [aux_sym_export_statement_repeat1] = STATE(3368),
    [sym_identifier] = ACTIONS(607),
    [anon_sym_export] = ACTIONS(107),
    [anon_sym_STAR] = ACTIONS(114),
    [anon_sym_type] = ACTIONS(107),
    [anon_sym_EQ] = ACTIONS(111),
    [anon_sym_as] = ACTIONS(114),
    [anon_sym_namespace] = ACTIONS(116),
    [anon_sym_LBRACE] = ACTIONS(609),
    [anon_sym_COMMA] = ACTIONS(120),
    [anon_sym_typeof] = ACTIONS(169),
    [anon_sym_import] = ACTIONS(125),
    [anon_sym_BANG] = ACTIONS(127),
    [anon_sym_LPAREN] = ACTIONS(611),
    [anon_sym_RPAREN] = ACTIONS(120),
    [anon_sym_await] = ACTIONS(132),
    [anon_sym_in] = ACTIONS(114),
    [anon_sym_COLON] = ACTIONS(120),
    [anon_sym_yield] = ACTIONS(134),
    [anon_sym_LBRACK] = ACTIONS(614),
    [anon_sym_LT] = ACTIONS(617),
    [anon_sym_GT] = ACTIONS(114),
    [anon_sym_SLASH] = ACTIONS(140),
    [anon_sym_DOT] = ACTIONS(114),
    [anon_sym_class] = ACTIONS(143),
    [anon_sym_async] = ACTIONS(145),
    [anon_sym_function] = ACTIONS(147),
    [anon_sym_EQ_GT] = ACTIONS(149),
    [anon_sym_QMARK_DOT] = ACTIONS(151),
    [anon_sym_new] = ACTIONS(620),
    [anon_sym_PLUS_EQ] = ACTIONS(155),
    [anon_sym_DASH_EQ] = ACTIONS(155),
    [anon_sym_STAR_EQ] = ACTIONS(155),
    [anon_sym_SLASH_EQ] = ACTIONS(155),
    [anon_sym_PERCENT_EQ] = ACTIONS(155),
    [anon_sym_CARET_EQ] = ACTIONS(155),
    [anon_sym_AMP_EQ] = ACTIONS(155),
    [anon_sym_PIPE_EQ] = ACTIONS(155),
    [anon_sym_GT_GT_EQ] = ACTIONS(155),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(155),
    [anon_sym_LT_LT_EQ] = ACTIONS(155),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(155),
    [anon_sym_AMP_AMP_EQ] = ACTIONS(155),
    [anon_sym_PIPE_PIPE_EQ] = ACTIONS(155),
    [anon_sym_QMARK_QMARK_EQ] = ACTIONS(155),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(157),
    [anon_sym_AMP_AMP] = ACTIONS(114),
    [anon_sym_PIPE_PIPE] = ACTIONS(114),
    [anon_sym_GT_GT] = ACTIONS(114),
    [anon_sym_GT_GT_GT] = ACTIONS(114),
    [anon_sym_LT_LT] = ACTIONS(114),
    [anon_sym_AMP] = ACTIONS(114),
    [anon_sym_CARET] = ACTIONS(114),
    [anon_sym_PIPE] = ACTIONS(114),
    [anon_sym_PLUS] = ACTIONS(127),
    [anon_sym_DASH] = ACTIONS(127),
    [anon_sym_PERCENT] = ACTIONS(114),
    [anon_sym_STAR_STAR] = ACTIONS(114),
    [anon_sym_LT_EQ] = ACTIONS(151),
    [anon_sym_EQ_EQ] = ACTIONS(114),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(151),
    [anon_sym_BANG_EQ] = ACTIONS(114),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(151),
    [anon_sym_GT_EQ] = ACTIONS(151),
    [anon_sym_QMARK_QMARK] = ACTIONS(114),
    [anon_sym_instanceof] = ACTIONS(114),
    [anon_sym_TILDE] = ACTIONS(165),
    [anon_sym_void] = ACTIONS(169),
    [anon_sym_delete] = ACTIONS(169),
    [anon_sym_PLUS_PLUS] = ACTIONS(171),
    [anon_sym_DASH_DASH] = ACTIONS(171),
    [anon_sym_DQUOTE] = ACTIONS(174),
    [anon_sym_SQUOTE] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(622),
    [sym_number] = ACTIONS(625),
    [sym_this] = ACTIONS(637),
    [sym_super] = ACTIONS(184),
    [sym_true] = ACTIONS(184),
    [sym_false] = ACTIONS(184),
    [sym_null] = ACTIONS(184),
    [sym_undefined] = ACTIONS(629),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(107),
    [anon_sym_readonly] = ACTIONS(107),
    [anon_sym_get] = ACTIONS(107),
    [anon_sym_set] = ACTIONS(107),
    [anon_sym_QMARK] = ACTIONS(631),
    [anon_sym_declare] = ACTIONS(107),
    [anon_sym_public] = ACTIONS(107),
    [anon_sym_private] = ACTIONS(107),
    [anon_sym_protected] = ACTIONS(107),
    [anon_sym_override] = ACTIONS(107),
    [anon_sym_module] = ACTIONS(107),
    [anon_sym_any] = ACTIONS(107),
    [anon_sym_number] = ACTIONS(107),
    [anon_sym_boolean] = ACTIONS(107),
    [anon_sym_string] = ACTIONS(107),
    [anon_sym_symbol] = ACTIONS(107),
    [sym__ternary_qmark] = ACTIONS(151),
  },
  [62] = {
    [sym_import] = STATE(1405),
    [sym_parenthesized_expression] = STATE(1023),
    [sym_expression] = STATE(2015),
    [sym_primary_expression] = STATE(1404),
    [sym_yield_expression] = STATE(1403),
    [sym_object] = STATE(1405),
    [sym_object_pattern] = STATE(2733),
    [sym_array] = STATE(1405),
    [sym_array_pattern] = STATE(2733),
    [sym_class] = STATE(1405),
    [sym_function] = STATE(1405),
    [sym_generator_function] = STATE(1405),
    [sym_arrow_function] = STATE(1405),
    [sym__call_signature] = STATE(4016),
    [sym_call_expression] = STATE(1405),
    [sym_new_expression] = STATE(1403),
    [sym_await_expression] = STATE(1403),
    [sym_member_expression] = STATE(1058),
    [sym_subscript_expression] = STATE(1058),
    [sym_assignment_expression] = STATE(1403),
    [sym__augmented_assignment_lhs] = STATE(2340),
    [sym_augmented_assignment_expression] = STATE(1403),
    [sym__destructuring_pattern] = STATE(2733),
    [sym_ternary_expression] = STATE(1403),
    [sym_binary_expression] = STATE(1403),
    [sym_unary_expression] = STATE(1403),
    [sym_update_expression] = STATE(1403),
    [sym_string] = STATE(1405),
    [sym_template_string] = STATE(1405),
    [sym_regex] = STATE(1405),
    [sym_meta_property] = STATE(1405),
    [sym_decorator] = STATE(1149),
    [sym_formal_parameters] = STATE(2903),
    [sym_pattern] = STATE(3191),
    [sym_rest_pattern] = STATE(2817),
    [sym_non_null_expression] = STATE(1058),
    [sym_type_assertion] = STATE(1403),
    [sym_as_expression] = STATE(1403),
    [sym_internal_module] = STATE(1403),
    [sym_type_arguments] = STATE(519),
    [sym_type_parameters] = STATE(3670),
    [aux_sym_export_statement_repeat1] = STATE(3368),
    [sym_identifier] = ACTIONS(607),
    [anon_sym_export] = ACTIONS(107),
    [anon_sym_STAR] = ACTIONS(114),
    [anon_sym_type] = ACTIONS(107),
    [anon_sym_EQ] = ACTIONS(206),
    [anon_sym_as] = ACTIONS(114),
    [anon_sym_namespace] = ACTIONS(116),
    [anon_sym_LBRACE] = ACTIONS(609),
    [anon_sym_COMMA] = ACTIONS(209),
    [anon_sym_typeof] = ACTIONS(169),
    [anon_sym_import] = ACTIONS(125),
    [anon_sym_BANG] = ACTIONS(127),
    [anon_sym_LPAREN] = ACTIONS(611),
    [anon_sym_RPAREN] = ACTIONS(209),
    [anon_sym_await] = ACTIONS(132),
    [anon_sym_in] = ACTIONS(114),
    [anon_sym_COLON] = ACTIONS(209),
    [anon_sym_yield] = ACTIONS(134),
    [anon_sym_LBRACK] = ACTIONS(614),
    [anon_sym_LT] = ACTIONS(617),
    [anon_sym_GT] = ACTIONS(114),
    [anon_sym_SLASH] = ACTIONS(140),
    [anon_sym_DOT] = ACTIONS(114),
    [anon_sym_class] = ACTIONS(143),
    [anon_sym_async] = ACTIONS(145),
    [anon_sym_function] = ACTIONS(147),
    [anon_sym_EQ_GT] = ACTIONS(211),
    [anon_sym_QMARK_DOT] = ACTIONS(151),
    [anon_sym_new] = ACTIONS(620),
    [anon_sym_PLUS_EQ] = ACTIONS(155),
    [anon_sym_DASH_EQ] = ACTIONS(155),
    [anon_sym_STAR_EQ] = ACTIONS(155),
    [anon_sym_SLASH_EQ] = ACTIONS(155),
    [anon_sym_PERCENT_EQ] = ACTIONS(155),
    [anon_sym_CARET_EQ] = ACTIONS(155),
    [anon_sym_AMP_EQ] = ACTIONS(155),
    [anon_sym_PIPE_EQ] = ACTIONS(155),
    [anon_sym_GT_GT_EQ] = ACTIONS(155),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(155),
    [anon_sym_LT_LT_EQ] = ACTIONS(155),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(155),
    [anon_sym_AMP_AMP_EQ] = ACTIONS(155),
    [anon_sym_PIPE_PIPE_EQ] = ACTIONS(155),
    [anon_sym_QMARK_QMARK_EQ] = ACTIONS(155),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(157),
    [anon_sym_AMP_AMP] = ACTIONS(114),
    [anon_sym_PIPE_PIPE] = ACTIONS(114),
    [anon_sym_GT_GT] = ACTIONS(114),
    [anon_sym_GT_GT_GT] = ACTIONS(114),
    [anon_sym_LT_LT] = ACTIONS(114),
    [anon_sym_AMP] = ACTIONS(114),
    [anon_sym_CARET] = ACTIONS(114),
    [anon_sym_PIPE] = ACTIONS(114),
    [anon_sym_PLUS] = ACTIONS(127),
    [anon_sym_DASH] = ACTIONS(127),
    [anon_sym_PERCENT] = ACTIONS(114),
    [anon_sym_STAR_STAR] = ACTIONS(114),
    [anon_sym_LT_EQ] = ACTIONS(151),
    [anon_sym_EQ_EQ] = ACTIONS(114),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(151),
    [anon_sym_BANG_EQ] = ACTIONS(114),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(151),
    [anon_sym_GT_EQ] = ACTIONS(151),
    [anon_sym_QMARK_QMARK] = ACTIONS(114),
    [anon_sym_instanceof] = ACTIONS(114),
    [anon_sym_TILDE] = ACTIONS(165),
    [anon_sym_void] = ACTIONS(169),
    [anon_sym_delete] = ACTIONS(169),
    [anon_sym_PLUS_PLUS] = ACTIONS(171),
    [anon_sym_DASH_DASH] = ACTIONS(171),
    [anon_sym_DQUOTE] = ACTIONS(174),
    [anon_sym_SQUOTE] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(622),
    [sym_number] = ACTIONS(625),
    [sym_this] = ACTIONS(637),
    [sym_super] = ACTIONS(184),
    [sym_true] = ACTIONS(184),
    [sym_false] = ACTIONS(184),
    [sym_null] = ACTIONS(184),
    [sym_undefined] = ACTIONS(629),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(107),
    [anon_sym_readonly] = ACTIONS(107),
    [anon_sym_get] = ACTIONS(107),
    [anon_sym_set] = ACTIONS(107),
    [anon_sym_QMARK] = ACTIONS(631),
    [anon_sym_declare] = ACTIONS(107),
    [anon_sym_public] = ACTIONS(107),
    [anon_sym_private] = ACTIONS(107),
    [anon_sym_protected] = ACTIONS(107),
    [anon_sym_override] = ACTIONS(107),
    [anon_sym_module] = ACTIONS(107),
    [anon_sym_any] = ACTIONS(107),
    [anon_sym_number] = ACTIONS(107),
    [anon_sym_boolean] = ACTIONS(107),
    [anon_sym_string] = ACTIONS(107),
    [anon_sym_symbol] = ACTIONS(107),
    [sym__ternary_qmark] = ACTIONS(151),
  },
  [63] = {
    [sym_import] = STATE(1405),
    [sym_parenthesized_expression] = STATE(1023),
    [sym_expression] = STATE(2015),
    [sym_primary_expression] = STATE(1404),
    [sym_yield_expression] = STATE(1403),
    [sym_object] = STATE(1405),
    [sym_object_pattern] = STATE(2733),
    [sym_array] = STATE(1405),
    [sym_array_pattern] = STATE(2733),
    [sym_class] = STATE(1405),
    [sym_function] = STATE(1405),
    [sym_generator_function] = STATE(1405),
    [sym_arrow_function] = STATE(1405),
    [sym__call_signature] = STATE(4016),
    [sym_call_expression] = STATE(1405),
    [sym_new_expression] = STATE(1403),
    [sym_await_expression] = STATE(1403),
    [sym_member_expression] = STATE(1058),
    [sym_subscript_expression] = STATE(1058),
    [sym_assignment_expression] = STATE(1403),
    [sym__augmented_assignment_lhs] = STATE(2340),
    [sym_augmented_assignment_expression] = STATE(1403),
    [sym__destructuring_pattern] = STATE(2733),
    [sym_ternary_expression] = STATE(1403),
    [sym_binary_expression] = STATE(1403),
    [sym_unary_expression] = STATE(1403),
    [sym_update_expression] = STATE(1403),
    [sym_string] = STATE(1405),
    [sym_template_string] = STATE(1405),
    [sym_regex] = STATE(1405),
    [sym_meta_property] = STATE(1405),
    [sym_decorator] = STATE(1149),
    [sym_formal_parameters] = STATE(2903),
    [sym_pattern] = STATE(3161),
    [sym_rest_pattern] = STATE(2817),
    [sym_non_null_expression] = STATE(1058),
    [sym_type_assertion] = STATE(1403),
    [sym_as_expression] = STATE(1403),
    [sym_internal_module] = STATE(1403),
    [sym_type_arguments] = STATE(519),
    [sym_type_parameters] = STATE(3670),
    [aux_sym_export_statement_repeat1] = STATE(3368),
    [sym_identifier] = ACTIONS(607),
    [anon_sym_export] = ACTIONS(107),
    [anon_sym_STAR] = ACTIONS(114),
    [anon_sym_type] = ACTIONS(107),
    [anon_sym_EQ] = ACTIONS(206),
    [anon_sym_as] = ACTIONS(114),
    [anon_sym_namespace] = ACTIONS(116),
    [anon_sym_LBRACE] = ACTIONS(609),
    [anon_sym_COMMA] = ACTIONS(209),
    [anon_sym_typeof] = ACTIONS(169),
    [anon_sym_import] = ACTIONS(125),
    [anon_sym_BANG] = ACTIONS(127),
    [anon_sym_LPAREN] = ACTIONS(611),
    [anon_sym_RPAREN] = ACTIONS(209),
    [anon_sym_await] = ACTIONS(132),
    [anon_sym_in] = ACTIONS(114),
    [anon_sym_COLON] = ACTIONS(209),
    [anon_sym_yield] = ACTIONS(134),
    [anon_sym_LBRACK] = ACTIONS(614),
    [anon_sym_LT] = ACTIONS(617),
    [anon_sym_GT] = ACTIONS(114),
    [anon_sym_SLASH] = ACTIONS(140),
    [anon_sym_DOT] = ACTIONS(114),
    [anon_sym_class] = ACTIONS(143),
    [anon_sym_async] = ACTIONS(145),
    [anon_sym_function] = ACTIONS(147),
    [anon_sym_EQ_GT] = ACTIONS(211),
    [anon_sym_QMARK_DOT] = ACTIONS(151),
    [anon_sym_new] = ACTIONS(620),
    [anon_sym_PLUS_EQ] = ACTIONS(155),
    [anon_sym_DASH_EQ] = ACTIONS(155),
    [anon_sym_STAR_EQ] = ACTIONS(155),
    [anon_sym_SLASH_EQ] = ACTIONS(155),
    [anon_sym_PERCENT_EQ] = ACTIONS(155),
    [anon_sym_CARET_EQ] = ACTIONS(155),
    [anon_sym_AMP_EQ] = ACTIONS(155),
    [anon_sym_PIPE_EQ] = ACTIONS(155),
    [anon_sym_GT_GT_EQ] = ACTIONS(155),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(155),
    [anon_sym_LT_LT_EQ] = ACTIONS(155),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(155),
    [anon_sym_AMP_AMP_EQ] = ACTIONS(155),
    [anon_sym_PIPE_PIPE_EQ] = ACTIONS(155),
    [anon_sym_QMARK_QMARK_EQ] = ACTIONS(155),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(157),
    [anon_sym_AMP_AMP] = ACTIONS(114),
    [anon_sym_PIPE_PIPE] = ACTIONS(114),
    [anon_sym_GT_GT] = ACTIONS(114),
    [anon_sym_GT_GT_GT] = ACTIONS(114),
    [anon_sym_LT_LT] = ACTIONS(114),
    [anon_sym_AMP] = ACTIONS(114),
    [anon_sym_CARET] = ACTIONS(114),
    [anon_sym_PIPE] = ACTIONS(114),
    [anon_sym_PLUS] = ACTIONS(127),
    [anon_sym_DASH] = ACTIONS(127),
    [anon_sym_PERCENT] = ACTIONS(114),
    [anon_sym_STAR_STAR] = ACTIONS(114),
    [anon_sym_LT_EQ] = ACTIONS(151),
    [anon_sym_EQ_EQ] = ACTIONS(114),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(151),
    [anon_sym_BANG_EQ] = ACTIONS(114),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(151),
    [anon_sym_GT_EQ] = ACTIONS(151),
    [anon_sym_QMARK_QMARK] = ACTIONS(114),
    [anon_sym_instanceof] = ACTIONS(114),
    [anon_sym_TILDE] = ACTIONS(165),
    [anon_sym_void] = ACTIONS(169),
    [anon_sym_delete] = ACTIONS(169),
    [anon_sym_PLUS_PLUS] = ACTIONS(171),
    [anon_sym_DASH_DASH] = ACTIONS(171),
    [anon_sym_DQUOTE] = ACTIONS(174),
    [anon_sym_SQUOTE] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(622),
    [sym_number] = ACTIONS(625),
    [sym_this] = ACTIONS(639),
    [sym_super] = ACTIONS(184),
    [sym_true] = ACTIONS(184),
    [sym_false] = ACTIONS(184),
    [sym_null] = ACTIONS(184),
    [sym_undefined] = ACTIONS(629),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(107),
    [anon_sym_readonly] = ACTIONS(107),
    [anon_sym_get] = ACTIONS(107),
    [anon_sym_set] = ACTIONS(107),
    [anon_sym_QMARK] = ACTIONS(631),
    [anon_sym_declare] = ACTIONS(107),
    [anon_sym_public] = ACTIONS(107),
    [anon_sym_private] = ACTIONS(107),
    [anon_sym_protected] = ACTIONS(107),
    [anon_sym_override] = ACTIONS(107),
    [anon_sym_module] = ACTIONS(107),
    [anon_sym_any] = ACTIONS(107),
    [anon_sym_number] = ACTIONS(107),
    [anon_sym_boolean] = ACTIONS(107),
    [anon_sym_string] = ACTIONS(107),
    [anon_sym_symbol] = ACTIONS(107),
    [sym__ternary_qmark] = ACTIONS(151),
  },
  [64] = {
    [sym_import] = STATE(1405),
    [sym_parenthesized_expression] = STATE(1023),
    [sym_expression] = STATE(2015),
    [sym_primary_expression] = STATE(1404),
    [sym_yield_expression] = STATE(1403),
    [sym_object] = STATE(1405),
    [sym_object_pattern] = STATE(2733),
    [sym_array] = STATE(1405),
    [sym_array_pattern] = STATE(2733),
    [sym_class] = STATE(1405),
    [sym_function] = STATE(1405),
    [sym_generator_function] = STATE(1405),
    [sym_arrow_function] = STATE(1405),
    [sym__call_signature] = STATE(4016),
    [sym_call_expression] = STATE(1405),
    [sym_new_expression] = STATE(1403),
    [sym_await_expression] = STATE(1403),
    [sym_member_expression] = STATE(1058),
    [sym_subscript_expression] = STATE(1058),
    [sym_assignment_expression] = STATE(1403),
    [sym__augmented_assignment_lhs] = STATE(2340),
    [sym_augmented_assignment_expression] = STATE(1403),
    [sym__destructuring_pattern] = STATE(2733),
    [sym_ternary_expression] = STATE(1403),
    [sym_binary_expression] = STATE(1403),
    [sym_unary_expression] = STATE(1403),
    [sym_update_expression] = STATE(1403),
    [sym_string] = STATE(1405),
    [sym_template_string] = STATE(1405),
    [sym_regex] = STATE(1405),
    [sym_meta_property] = STATE(1405),
    [sym_decorator] = STATE(1149),
    [sym_formal_parameters] = STATE(2903),
    [sym_pattern] = STATE(3037),
    [sym_rest_pattern] = STATE(2817),
    [sym_non_null_expression] = STATE(1058),
    [sym_type_assertion] = STATE(1403),
    [sym_as_expression] = STATE(1403),
    [sym_internal_module] = STATE(1403),
    [sym_type_arguments] = STATE(519),
    [sym_type_parameters] = STATE(3670),
    [aux_sym_export_statement_repeat1] = STATE(3368),
    [sym_identifier] = ACTIONS(607),
    [anon_sym_export] = ACTIONS(107),
    [anon_sym_STAR] = ACTIONS(114),
    [anon_sym_type] = ACTIONS(107),
    [anon_sym_EQ] = ACTIONS(206),
    [anon_sym_as] = ACTIONS(114),
    [anon_sym_namespace] = ACTIONS(116),
    [anon_sym_LBRACE] = ACTIONS(609),
    [anon_sym_COMMA] = ACTIONS(209),
    [anon_sym_typeof] = ACTIONS(169),
    [anon_sym_import] = ACTIONS(125),
    [anon_sym_BANG] = ACTIONS(127),
    [anon_sym_LPAREN] = ACTIONS(611),
    [anon_sym_RPAREN] = ACTIONS(209),
    [anon_sym_await] = ACTIONS(132),
    [anon_sym_in] = ACTIONS(114),
    [anon_sym_COLON] = ACTIONS(209),
    [anon_sym_yield] = ACTIONS(134),
    [anon_sym_LBRACK] = ACTIONS(614),
    [anon_sym_LT] = ACTIONS(617),
    [anon_sym_GT] = ACTIONS(114),
    [anon_sym_SLASH] = ACTIONS(140),
    [anon_sym_DOT] = ACTIONS(114),
    [anon_sym_class] = ACTIONS(143),
    [anon_sym_async] = ACTIONS(145),
    [anon_sym_function] = ACTIONS(147),
    [anon_sym_EQ_GT] = ACTIONS(211),
    [anon_sym_QMARK_DOT] = ACTIONS(151),
    [anon_sym_new] = ACTIONS(620),
    [anon_sym_PLUS_EQ] = ACTIONS(155),
    [anon_sym_DASH_EQ] = ACTIONS(155),
    [anon_sym_STAR_EQ] = ACTIONS(155),
    [anon_sym_SLASH_EQ] = ACTIONS(155),
    [anon_sym_PERCENT_EQ] = ACTIONS(155),
    [anon_sym_CARET_EQ] = ACTIONS(155),
    [anon_sym_AMP_EQ] = ACTIONS(155),
    [anon_sym_PIPE_EQ] = ACTIONS(155),
    [anon_sym_GT_GT_EQ] = ACTIONS(155),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(155),
    [anon_sym_LT_LT_EQ] = ACTIONS(155),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(155),
    [anon_sym_AMP_AMP_EQ] = ACTIONS(155),
    [anon_sym_PIPE_PIPE_EQ] = ACTIONS(155),
    [anon_sym_QMARK_QMARK_EQ] = ACTIONS(155),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(157),
    [anon_sym_AMP_AMP] = ACTIONS(114),
    [anon_sym_PIPE_PIPE] = ACTIONS(114),
    [anon_sym_GT_GT] = ACTIONS(114),
    [anon_sym_GT_GT_GT] = ACTIONS(114),
    [anon_sym_LT_LT] = ACTIONS(114),
    [anon_sym_AMP] = ACTIONS(114),
    [anon_sym_CARET] = ACTIONS(114),
    [anon_sym_PIPE] = ACTIONS(114),
    [anon_sym_PLUS] = ACTIONS(127),
    [anon_sym_DASH] = ACTIONS(127),
    [anon_sym_PERCENT] = ACTIONS(114),
    [anon_sym_STAR_STAR] = ACTIONS(114),
    [anon_sym_LT_EQ] = ACTIONS(151),
    [anon_sym_EQ_EQ] = ACTIONS(114),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(151),
    [anon_sym_BANG_EQ] = ACTIONS(114),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(151),
    [anon_sym_GT_EQ] = ACTIONS(151),
    [anon_sym_QMARK_QMARK] = ACTIONS(114),
    [anon_sym_instanceof] = ACTIONS(114),
    [anon_sym_TILDE] = ACTIONS(165),
    [anon_sym_void] = ACTIONS(169),
    [anon_sym_delete] = ACTIONS(169),
    [anon_sym_PLUS_PLUS] = ACTIONS(171),
    [anon_sym_DASH_DASH] = ACTIONS(171),
    [anon_sym_DQUOTE] = ACTIONS(174),
    [anon_sym_SQUOTE] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(622),
    [sym_number] = ACTIONS(625),
    [sym_this] = ACTIONS(641),
    [sym_super] = ACTIONS(184),
    [sym_true] = ACTIONS(184),
    [sym_false] = ACTIONS(184),
    [sym_null] = ACTIONS(184),
    [sym_undefined] = ACTIONS(629),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(107),
    [anon_sym_readonly] = ACTIONS(107),
    [anon_sym_get] = ACTIONS(107),
    [anon_sym_set] = ACTIONS(107),
    [anon_sym_QMARK] = ACTIONS(631),
    [anon_sym_declare] = ACTIONS(107),
    [anon_sym_public] = ACTIONS(107),
    [anon_sym_private] = ACTIONS(107),
    [anon_sym_protected] = ACTIONS(107),
    [anon_sym_override] = ACTIONS(107),
    [anon_sym_module] = ACTIONS(107),
    [anon_sym_any] = ACTIONS(107),
    [anon_sym_number] = ACTIONS(107),
    [anon_sym_boolean] = ACTIONS(107),
    [anon_sym_string] = ACTIONS(107),
    [anon_sym_symbol] = ACTIONS(107),
    [sym__ternary_qmark] = ACTIONS(151),
  },
  [65] = {
    [sym_import] = STATE(1405),
    [sym_parenthesized_expression] = STATE(1023),
    [sym_expression] = STATE(2015),
    [sym_primary_expression] = STATE(1404),
    [sym_yield_expression] = STATE(1403),
    [sym_object] = STATE(1405),
    [sym_object_pattern] = STATE(2733),
    [sym_array] = STATE(1405),
    [sym_array_pattern] = STATE(2733),
    [sym_class] = STATE(1405),
    [sym_function] = STATE(1405),
    [sym_generator_function] = STATE(1405),
    [sym_arrow_function] = STATE(1405),
    [sym__call_signature] = STATE(4016),
    [sym_call_expression] = STATE(1405),
    [sym_new_expression] = STATE(1403),
    [sym_await_expression] = STATE(1403),
    [sym_member_expression] = STATE(1058),
    [sym_subscript_expression] = STATE(1058),
    [sym_assignment_expression] = STATE(1403),
    [sym__augmented_assignment_lhs] = STATE(2340),
    [sym_augmented_assignment_expression] = STATE(1403),
    [sym__destructuring_pattern] = STATE(2733),
    [sym_ternary_expression] = STATE(1403),
    [sym_binary_expression] = STATE(1403),
    [sym_unary_expression] = STATE(1403),
    [sym_update_expression] = STATE(1403),
    [sym_string] = STATE(1405),
    [sym_template_string] = STATE(1405),
    [sym_regex] = STATE(1405),
    [sym_meta_property] = STATE(1405),
    [sym_decorator] = STATE(1149),
    [sym_formal_parameters] = STATE(2903),
    [sym_pattern] = STATE(3171),
    [sym_rest_pattern] = STATE(2817),
    [sym_non_null_expression] = STATE(1058),
    [sym_type_assertion] = STATE(1403),
    [sym_as_expression] = STATE(1403),
    [sym_internal_module] = STATE(1403),
    [sym_type_arguments] = STATE(519),
    [sym_type_parameters] = STATE(3670),
    [aux_sym_export_statement_repeat1] = STATE(3368),
    [sym_identifier] = ACTIONS(607),
    [anon_sym_export] = ACTIONS(107),
    [anon_sym_STAR] = ACTIONS(114),
    [anon_sym_type] = ACTIONS(107),
    [anon_sym_EQ] = ACTIONS(206),
    [anon_sym_as] = ACTIONS(114),
    [anon_sym_namespace] = ACTIONS(116),
    [anon_sym_LBRACE] = ACTIONS(609),
    [anon_sym_COMMA] = ACTIONS(209),
    [anon_sym_typeof] = ACTIONS(169),
    [anon_sym_import] = ACTIONS(125),
    [anon_sym_BANG] = ACTIONS(127),
    [anon_sym_LPAREN] = ACTIONS(611),
    [anon_sym_RPAREN] = ACTIONS(209),
    [anon_sym_await] = ACTIONS(132),
    [anon_sym_in] = ACTIONS(114),
    [anon_sym_COLON] = ACTIONS(209),
    [anon_sym_yield] = ACTIONS(134),
    [anon_sym_LBRACK] = ACTIONS(614),
    [anon_sym_LT] = ACTIONS(617),
    [anon_sym_GT] = ACTIONS(114),
    [anon_sym_SLASH] = ACTIONS(140),
    [anon_sym_DOT] = ACTIONS(114),
    [anon_sym_class] = ACTIONS(143),
    [anon_sym_async] = ACTIONS(145),
    [anon_sym_function] = ACTIONS(147),
    [anon_sym_EQ_GT] = ACTIONS(211),
    [anon_sym_QMARK_DOT] = ACTIONS(151),
    [anon_sym_new] = ACTIONS(620),
    [anon_sym_PLUS_EQ] = ACTIONS(155),
    [anon_sym_DASH_EQ] = ACTIONS(155),
    [anon_sym_STAR_EQ] = ACTIONS(155),
    [anon_sym_SLASH_EQ] = ACTIONS(155),
    [anon_sym_PERCENT_EQ] = ACTIONS(155),
    [anon_sym_CARET_EQ] = ACTIONS(155),
    [anon_sym_AMP_EQ] = ACTIONS(155),
    [anon_sym_PIPE_EQ] = ACTIONS(155),
    [anon_sym_GT_GT_EQ] = ACTIONS(155),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(155),
    [anon_sym_LT_LT_EQ] = ACTIONS(155),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(155),
    [anon_sym_AMP_AMP_EQ] = ACTIONS(155),
    [anon_sym_PIPE_PIPE_EQ] = ACTIONS(155),
    [anon_sym_QMARK_QMARK_EQ] = ACTIONS(155),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(157),
    [anon_sym_AMP_AMP] = ACTIONS(114),
    [anon_sym_PIPE_PIPE] = ACTIONS(114),
    [anon_sym_GT_GT] = ACTIONS(114),
    [anon_sym_GT_GT_GT] = ACTIONS(114),
    [anon_sym_LT_LT] = ACTIONS(114),
    [anon_sym_AMP] = ACTIONS(114),
    [anon_sym_CARET] = ACTIONS(114),
    [anon_sym_PIPE] = ACTIONS(114),
    [anon_sym_PLUS] = ACTIONS(127),
    [anon_sym_DASH] = ACTIONS(127),
    [anon_sym_PERCENT] = ACTIONS(114),
    [anon_sym_STAR_STAR] = ACTIONS(114),
    [anon_sym_LT_EQ] = ACTIONS(151),
    [anon_sym_EQ_EQ] = ACTIONS(114),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(151),
    [anon_sym_BANG_EQ] = ACTIONS(114),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(151),
    [anon_sym_GT_EQ] = ACTIONS(151),
    [anon_sym_QMARK_QMARK] = ACTIONS(114),
    [anon_sym_instanceof] = ACTIONS(114),
    [anon_sym_TILDE] = ACTIONS(165),
    [anon_sym_void] = ACTIONS(169),
    [anon_sym_delete] = ACTIONS(169),
    [anon_sym_PLUS_PLUS] = ACTIONS(171),
    [anon_sym_DASH_DASH] = ACTIONS(171),
    [anon_sym_DQUOTE] = ACTIONS(174),
    [anon_sym_SQUOTE] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(622),
    [sym_number] = ACTIONS(625),
    [sym_this] = ACTIONS(643),
    [sym_super] = ACTIONS(184),
    [sym_true] = ACTIONS(184),
    [sym_false] = ACTIONS(184),
    [sym_null] = ACTIONS(184),
    [sym_undefined] = ACTIONS(629),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(107),
    [anon_sym_readonly] = ACTIONS(107),
    [anon_sym_get] = ACTIONS(107),
    [anon_sym_set] = ACTIONS(107),
    [anon_sym_QMARK] = ACTIONS(631),
    [anon_sym_declare] = ACTIONS(107),
    [anon_sym_public] = ACTIONS(107),
    [anon_sym_private] = ACTIONS(107),
    [anon_sym_protected] = ACTIONS(107),
    [anon_sym_override] = ACTIONS(107),
    [anon_sym_module] = ACTIONS(107),
    [anon_sym_any] = ACTIONS(107),
    [anon_sym_number] = ACTIONS(107),
    [anon_sym_boolean] = ACTIONS(107),
    [anon_sym_string] = ACTIONS(107),
    [anon_sym_symbol] = ACTIONS(107),
    [sym__ternary_qmark] = ACTIONS(151),
  },
  [66] = {
    [sym_import] = STATE(1405),
    [sym_parenthesized_expression] = STATE(1072),
    [sym_expression] = STATE(1493),
    [sym_primary_expression] = STATE(1404),
    [sym_yield_expression] = STATE(1403),
    [sym_object] = STATE(1405),
    [sym_object_pattern] = STATE(2812),
    [sym_array] = STATE(1405),
    [sym_array_pattern] = STATE(2812),
    [sym_nested_identifier] = STATE(4074),
    [sym_class] = STATE(1405),
    [sym_function] = STATE(1405),
    [sym_generator_function] = STATE(1405),
    [sym_arrow_function] = STATE(1405),
    [sym__call_signature] = STATE(4121),
    [sym__formal_parameter] = STATE(3477),
    [sym_call_expression] = STATE(1405),
    [sym_new_expression] = STATE(1403),
    [sym_await_expression] = STATE(1403),
    [sym_member_expression] = STATE(1056),
    [sym_subscript_expression] = STATE(1056),
    [sym_assignment_expression] = STATE(1403),
    [sym__augmented_assignment_lhs] = STATE(2344),
    [sym_augmented_assignment_expression] = STATE(1403),
    [sym__destructuring_pattern] = STATE(2812),
    [sym_ternary_expression] = STATE(1403),
    [sym_binary_expression] = STATE(1403),
    [sym_unary_expression] = STATE(1403),
    [sym_update_expression] = STATE(1403),
    [sym_sequence_expression] = STATE(4106),
    [sym_string] = STATE(1900),
    [sym_template_string] = STATE(1405),
    [sym_regex] = STATE(1405),
    [sym_meta_property] = STATE(1405),
    [sym_decorator] = STATE(1149),
    [sym_formal_parameters] = STATE(3260),
    [sym_pattern] = STATE(3265),
    [sym_rest_pattern] = STATE(2817),
    [sym_non_null_expression] = STATE(1056),
    [sym_type_assertion] = STATE(1403),
    [sym_as_expression] = STATE(1403),
    [sym_internal_module] = STATE(1403),
    [sym_nested_type_identifier] = STATE(2336),
    [sym_accessibility_modifier] = STATE(200),
    [sym_override_modifier] = STATE(206),
    [sym_required_parameter] = STATE(3477),
    [sym_optional_parameter] = STATE(3477),
    [sym__parameter_name] = STATE(2820),
    [sym__type] = STATE(3281),
    [sym_constructor_type] = STATE(3281),
    [sym__primary_type] = STATE(2373),
    [sym_template_literal_type] = STATE(2359),
    [sym_infer_type] = STATE(3281),
    [sym_conditional_type] = STATE(2359),
    [sym_generic_type] = STATE(2359),
    [sym_type_query] = STATE(2359),
    [sym_index_type_query] = STATE(2359),
    [sym_lookup_type] = STATE(2359),
    [sym_literal_type] = STATE(2359),
    [sym__number] = STATE(2355),
    [sym_existential_type] = STATE(2359),
    [sym_flow_maybe_type] = STATE(2359),
    [sym_parenthesized_type] = STATE(2359),
    [sym_predefined_type] = STATE(2359),
    [sym_type_arguments] = STATE(502),
    [sym_object_type] = STATE(2359),
    [sym_type_parameters] = STATE(3839),
    [sym_array_type] = STATE(2359),
    [sym_tuple_type] = STATE(2359),
    [sym_readonly_type] = STATE(3281),
    [sym_union_type] = STATE(2359),
    [sym_intersection_type] = STATE(2359),
    [sym_function_type] = STATE(3281),
    [aux_sym_export_statement_repeat1] = STATE(181),
    [sym_identifier] = ACTIONS(645),
    [anon_sym_export] = ACTIONS(535),
    [anon_sym_STAR] = ACTIONS(537),
    [anon_sym_type] = ACTIONS(535),
    [anon_sym_namespace] = ACTIONS(539),
    [anon_sym_LBRACE] = ACTIONS(647),
    [anon_sym_typeof] = ACTIONS(649),
    [anon_sym_import] = ACTIONS(125),
    [anon_sym_BANG] = ACTIONS(547),
    [anon_sym_LPAREN] = ACTIONS(130),
    [anon_sym_RPAREN] = ACTIONS(651),
    [anon_sym_await] = ACTIONS(549),
    [anon_sym_yield] = ACTIONS(551),
    [anon_sym_LBRACK] = ACTIONS(653),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(557),
    [anon_sym_class] = ACTIONS(143),
    [anon_sym_async] = ACTIONS(559),
    [anon_sym_function] = ACTIONS(147),
    [anon_sym_new] = ACTIONS(561),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(157),
    [anon_sym_AMP] = ACTIONS(565),
    [anon_sym_PIPE] = ACTIONS(567),
    [anon_sym_PLUS] = ACTIONS(655),
    [anon_sym_DASH] = ACTIONS(655),
    [anon_sym_TILDE] = ACTIONS(547),
    [anon_sym_void] = ACTIONS(571),
    [anon_sym_delete] = ACTIONS(573),
    [anon_sym_PLUS_PLUS] = ACTIONS(575),
    [anon_sym_DASH_DASH] = ACTIONS(575),
    [anon_sym_DQUOTE] = ACTIONS(174),
    [anon_sym_SQUOTE] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(657),
    [sym_number] = ACTIONS(659),
    [sym_this] = ACTIONS(661),
    [sym_super] = ACTIONS(184),
    [sym_true] = ACTIONS(663),
    [sym_false] = ACTIONS(663),
    [sym_null] = ACTIONS(663),
    [sym_undefined] = ACTIONS(665),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(535),
    [anon_sym_readonly] = ACTIONS(667),
    [anon_sym_get] = ACTIONS(535),
    [anon_sym_set] = ACTIONS(535),
    [anon_sym_QMARK] = ACTIONS(583),
    [anon_sym_declare] = ACTIONS(535),
    [anon_sym_public] = ACTIONS(669),
    [anon_sym_private] = ACTIONS(669),
    [anon_sym_protected] = ACTIONS(669),
    [anon_sym_override] = ACTIONS(671),
    [anon_sym_module] = ACTIONS(535),
    [anon_sym_any] = ACTIONS(673),
    [anon_sym_number] = ACTIONS(673),
    [anon_sym_boolean] = ACTIONS(673),
    [anon_sym_string] = ACTIONS(673),
    [anon_sym_symbol] = ACTIONS(673),
    [anon_sym_abstract] = ACTIONS(196),
    [anon_sym_infer] = ACTIONS(198),
    [anon_sym_keyof] = ACTIONS(200),
    [anon_sym_unknown] = ACTIONS(202),
    [anon_sym_never] = ACTIONS(202),
    [anon_sym_object] = ACTIONS(202),
    [anon_sym_LBRACE_PIPE] = ACTIONS(204),
  },
  [67] = {
    [sym_import] = STATE(1405),
    [sym_parenthesized_expression] = STATE(1072),
    [sym_expression] = STATE(1482),
    [sym_primary_expression] = STATE(1404),
    [sym_yield_expression] = STATE(1403),
    [sym_object] = STATE(1405),
    [sym_object_pattern] = STATE(2812),
    [sym_array] = STATE(1405),
    [sym_array_pattern] = STATE(2812),
    [sym_nested_identifier] = STATE(4074),
    [sym_class] = STATE(1405),
    [sym_function] = STATE(1405),
    [sym_generator_function] = STATE(1405),
    [sym_arrow_function] = STATE(1405),
    [sym__call_signature] = STATE(4121),
    [sym__formal_parameter] = STATE(3477),
    [sym_call_expression] = STATE(1405),
    [sym_new_expression] = STATE(1403),
    [sym_await_expression] = STATE(1403),
    [sym_member_expression] = STATE(1056),
    [sym_subscript_expression] = STATE(1056),
    [sym_assignment_expression] = STATE(1403),
    [sym__augmented_assignment_lhs] = STATE(2344),
    [sym_augmented_assignment_expression] = STATE(1403),
    [sym__destructuring_pattern] = STATE(2812),
    [sym_ternary_expression] = STATE(1403),
    [sym_binary_expression] = STATE(1403),
    [sym_unary_expression] = STATE(1403),
    [sym_update_expression] = STATE(1403),
    [sym_sequence_expression] = STATE(3884),
    [sym_string] = STATE(1900),
    [sym_template_string] = STATE(1405),
    [sym_regex] = STATE(1405),
    [sym_meta_property] = STATE(1405),
    [sym_decorator] = STATE(1149),
    [sym_formal_parameters] = STATE(3260),
    [sym_pattern] = STATE(3265),
    [sym_rest_pattern] = STATE(2817),
    [sym_non_null_expression] = STATE(1056),
    [sym_type_assertion] = STATE(1403),
    [sym_as_expression] = STATE(1403),
    [sym_internal_module] = STATE(1403),
    [sym_nested_type_identifier] = STATE(2336),
    [sym_accessibility_modifier] = STATE(200),
    [sym_override_modifier] = STATE(206),
    [sym_required_parameter] = STATE(3477),
    [sym_optional_parameter] = STATE(3477),
    [sym__parameter_name] = STATE(2820),
    [sym__type] = STATE(3281),
    [sym_constructor_type] = STATE(3281),
    [sym__primary_type] = STATE(2373),
    [sym_template_literal_type] = STATE(2359),
    [sym_infer_type] = STATE(3281),
    [sym_conditional_type] = STATE(2359),
    [sym_generic_type] = STATE(2359),
    [sym_type_query] = STATE(2359),
    [sym_index_type_query] = STATE(2359),
    [sym_lookup_type] = STATE(2359),
    [sym_literal_type] = STATE(2359),
    [sym__number] = STATE(2355),
    [sym_existential_type] = STATE(2359),
    [sym_flow_maybe_type] = STATE(2359),
    [sym_parenthesized_type] = STATE(2359),
    [sym_predefined_type] = STATE(2359),
    [sym_type_arguments] = STATE(502),
    [sym_object_type] = STATE(2359),
    [sym_type_parameters] = STATE(3839),
    [sym_array_type] = STATE(2359),
    [sym_tuple_type] = STATE(2359),
    [sym_readonly_type] = STATE(3281),
    [sym_union_type] = STATE(2359),
    [sym_intersection_type] = STATE(2359),
    [sym_function_type] = STATE(3281),
    [aux_sym_export_statement_repeat1] = STATE(181),
    [sym_identifier] = ACTIONS(645),
    [anon_sym_export] = ACTIONS(535),
    [anon_sym_STAR] = ACTIONS(537),
    [anon_sym_type] = ACTIONS(535),
    [anon_sym_namespace] = ACTIONS(539),
    [anon_sym_LBRACE] = ACTIONS(647),
    [anon_sym_typeof] = ACTIONS(649),
    [anon_sym_import] = ACTIONS(125),
    [anon_sym_BANG] = ACTIONS(547),
    [anon_sym_LPAREN] = ACTIONS(130),
    [anon_sym_RPAREN] = ACTIONS(651),
    [anon_sym_await] = ACTIONS(549),
    [anon_sym_yield] = ACTIONS(551),
    [anon_sym_LBRACK] = ACTIONS(653),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(557),
    [anon_sym_class] = ACTIONS(143),
    [anon_sym_async] = ACTIONS(559),
    [anon_sym_function] = ACTIONS(147),
    [anon_sym_new] = ACTIONS(561),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(157),
    [anon_sym_AMP] = ACTIONS(565),
    [anon_sym_PIPE] = ACTIONS(567),
    [anon_sym_PLUS] = ACTIONS(655),
    [anon_sym_DASH] = ACTIONS(655),
    [anon_sym_TILDE] = ACTIONS(547),
    [anon_sym_void] = ACTIONS(571),
    [anon_sym_delete] = ACTIONS(573),
    [anon_sym_PLUS_PLUS] = ACTIONS(575),
    [anon_sym_DASH_DASH] = ACTIONS(575),
    [anon_sym_DQUOTE] = ACTIONS(174),
    [anon_sym_SQUOTE] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(657),
    [sym_number] = ACTIONS(659),
    [sym_this] = ACTIONS(661),
    [sym_super] = ACTIONS(184),
    [sym_true] = ACTIONS(663),
    [sym_false] = ACTIONS(663),
    [sym_null] = ACTIONS(663),
    [sym_undefined] = ACTIONS(665),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(535),
    [anon_sym_readonly] = ACTIONS(667),
    [anon_sym_get] = ACTIONS(535),
    [anon_sym_set] = ACTIONS(535),
    [anon_sym_QMARK] = ACTIONS(583),
    [anon_sym_declare] = ACTIONS(535),
    [anon_sym_public] = ACTIONS(669),
    [anon_sym_private] = ACTIONS(669),
    [anon_sym_protected] = ACTIONS(669),
    [anon_sym_override] = ACTIONS(671),
    [anon_sym_module] = ACTIONS(535),
    [anon_sym_any] = ACTIONS(673),
    [anon_sym_number] = ACTIONS(673),
    [anon_sym_boolean] = ACTIONS(673),
    [anon_sym_string] = ACTIONS(673),
    [anon_sym_symbol] = ACTIONS(673),
    [anon_sym_abstract] = ACTIONS(196),
    [anon_sym_infer] = ACTIONS(198),
    [anon_sym_keyof] = ACTIONS(200),
    [anon_sym_unknown] = ACTIONS(202),
    [anon_sym_never] = ACTIONS(202),
    [anon_sym_object] = ACTIONS(202),
    [anon_sym_LBRACE_PIPE] = ACTIONS(204),
  },
  [68] = {
    [sym_import] = STATE(1405),
    [sym_parenthesized_expression] = STATE(1072),
    [sym_expression] = STATE(1482),
    [sym_primary_expression] = STATE(1404),
    [sym_yield_expression] = STATE(1403),
    [sym_object] = STATE(1405),
    [sym_object_pattern] = STATE(2812),
    [sym_array] = STATE(1405),
    [sym_array_pattern] = STATE(2812),
    [sym_nested_identifier] = STATE(4074),
    [sym_class] = STATE(1405),
    [sym_function] = STATE(1405),
    [sym_generator_function] = STATE(1405),
    [sym_arrow_function] = STATE(1405),
    [sym__call_signature] = STATE(4121),
    [sym__formal_parameter] = STATE(3477),
    [sym_call_expression] = STATE(1405),
    [sym_new_expression] = STATE(1403),
    [sym_await_expression] = STATE(1403),
    [sym_member_expression] = STATE(1056),
    [sym_subscript_expression] = STATE(1056),
    [sym_assignment_expression] = STATE(1403),
    [sym__augmented_assignment_lhs] = STATE(2344),
    [sym_augmented_assignment_expression] = STATE(1403),
    [sym__destructuring_pattern] = STATE(2812),
    [sym_ternary_expression] = STATE(1403),
    [sym_binary_expression] = STATE(1403),
    [sym_unary_expression] = STATE(1403),
    [sym_update_expression] = STATE(1403),
    [sym_sequence_expression] = STATE(3884),
    [sym_string] = STATE(1900),
    [sym_template_string] = STATE(1405),
    [sym_regex] = STATE(1405),
    [sym_meta_property] = STATE(1405),
    [sym_decorator] = STATE(1149),
    [sym_formal_parameters] = STATE(3260),
    [sym_pattern] = STATE(3265),
    [sym_rest_pattern] = STATE(2817),
    [sym_non_null_expression] = STATE(1056),
    [sym_type_assertion] = STATE(1403),
    [sym_as_expression] = STATE(1403),
    [sym_internal_module] = STATE(1403),
    [sym_nested_type_identifier] = STATE(2336),
    [sym_accessibility_modifier] = STATE(200),
    [sym_override_modifier] = STATE(206),
    [sym_required_parameter] = STATE(3477),
    [sym_optional_parameter] = STATE(3477),
    [sym__parameter_name] = STATE(2820),
    [sym__type] = STATE(3305),
    [sym_constructor_type] = STATE(3305),
    [sym__primary_type] = STATE(2373),
    [sym_template_literal_type] = STATE(2359),
    [sym_infer_type] = STATE(3305),
    [sym_conditional_type] = STATE(2359),
    [sym_generic_type] = STATE(2359),
    [sym_type_query] = STATE(2359),
    [sym_index_type_query] = STATE(2359),
    [sym_lookup_type] = STATE(2359),
    [sym_literal_type] = STATE(2359),
    [sym__number] = STATE(2355),
    [sym_existential_type] = STATE(2359),
    [sym_flow_maybe_type] = STATE(2359),
    [sym_parenthesized_type] = STATE(2359),
    [sym_predefined_type] = STATE(2359),
    [sym_type_arguments] = STATE(502),
    [sym_object_type] = STATE(2359),
    [sym_type_parameters] = STATE(3839),
    [sym_array_type] = STATE(2359),
    [sym_tuple_type] = STATE(2359),
    [sym_readonly_type] = STATE(3305),
    [sym_union_type] = STATE(2359),
    [sym_intersection_type] = STATE(2359),
    [sym_function_type] = STATE(3305),
    [aux_sym_export_statement_repeat1] = STATE(181),
    [sym_identifier] = ACTIONS(645),
    [anon_sym_export] = ACTIONS(535),
    [anon_sym_STAR] = ACTIONS(537),
    [anon_sym_type] = ACTIONS(535),
    [anon_sym_namespace] = ACTIONS(539),
    [anon_sym_LBRACE] = ACTIONS(647),
    [anon_sym_typeof] = ACTIONS(649),
    [anon_sym_import] = ACTIONS(125),
    [anon_sym_BANG] = ACTIONS(547),
    [anon_sym_LPAREN] = ACTIONS(130),
    [anon_sym_RPAREN] = ACTIONS(651),
    [anon_sym_await] = ACTIONS(549),
    [anon_sym_yield] = ACTIONS(551),
    [anon_sym_LBRACK] = ACTIONS(653),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(557),
    [anon_sym_class] = ACTIONS(143),
    [anon_sym_async] = ACTIONS(559),
    [anon_sym_function] = ACTIONS(147),
    [anon_sym_new] = ACTIONS(561),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(157),
    [anon_sym_AMP] = ACTIONS(565),
    [anon_sym_PIPE] = ACTIONS(567),
    [anon_sym_PLUS] = ACTIONS(655),
    [anon_sym_DASH] = ACTIONS(655),
    [anon_sym_TILDE] = ACTIONS(547),
    [anon_sym_void] = ACTIONS(571),
    [anon_sym_delete] = ACTIONS(573),
    [anon_sym_PLUS_PLUS] = ACTIONS(575),
    [anon_sym_DASH_DASH] = ACTIONS(575),
    [anon_sym_DQUOTE] = ACTIONS(174),
    [anon_sym_SQUOTE] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(657),
    [sym_number] = ACTIONS(659),
    [sym_this] = ACTIONS(661),
    [sym_super] = ACTIONS(184),
    [sym_true] = ACTIONS(663),
    [sym_false] = ACTIONS(663),
    [sym_null] = ACTIONS(663),
    [sym_undefined] = ACTIONS(665),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(535),
    [anon_sym_readonly] = ACTIONS(667),
    [anon_sym_get] = ACTIONS(535),
    [anon_sym_set] = ACTIONS(535),
    [anon_sym_QMARK] = ACTIONS(583),
    [anon_sym_declare] = ACTIONS(535),
    [anon_sym_public] = ACTIONS(669),
    [anon_sym_private] = ACTIONS(669),
    [anon_sym_protected] = ACTIONS(669),
    [anon_sym_override] = ACTIONS(671),
    [anon_sym_module] = ACTIONS(535),
    [anon_sym_any] = ACTIONS(673),
    [anon_sym_number] = ACTIONS(673),
    [anon_sym_boolean] = ACTIONS(673),
    [anon_sym_string] = ACTIONS(673),
    [anon_sym_symbol] = ACTIONS(673),
    [anon_sym_abstract] = ACTIONS(196),
    [anon_sym_infer] = ACTIONS(198),
    [anon_sym_keyof] = ACTIONS(200),
    [anon_sym_unknown] = ACTIONS(202),
    [anon_sym_never] = ACTIONS(202),
    [anon_sym_object] = ACTIONS(202),
    [anon_sym_LBRACE_PIPE] = ACTIONS(204),
  },
  [69] = {
    [sym_import] = STATE(1405),
    [sym_parenthesized_expression] = STATE(1023),
    [sym_expression] = STATE(2015),
    [sym_primary_expression] = STATE(1404),
    [sym_yield_expression] = STATE(1403),
    [sym_object] = STATE(1405),
    [sym_object_pattern] = STATE(2733),
    [sym_array] = STATE(1405),
    [sym_array_pattern] = STATE(2733),
    [sym_nested_identifier] = STATE(4074),
    [sym_class] = STATE(1405),
    [sym_function] = STATE(1405),
    [sym_generator_function] = STATE(1405),
    [sym_arrow_function] = STATE(1405),
    [sym__call_signature] = STATE(4016),
    [sym__formal_parameter] = STATE(3477),
    [sym_call_expression] = STATE(1405),
    [sym_new_expression] = STATE(1403),
    [sym_await_expression] = STATE(1403),
    [sym_member_expression] = STATE(1058),
    [sym_subscript_expression] = STATE(1058),
    [sym_assignment_expression] = STATE(1403),
    [sym__augmented_assignment_lhs] = STATE(2340),
    [sym_augmented_assignment_expression] = STATE(1403),
    [sym__destructuring_pattern] = STATE(2733),
    [sym_ternary_expression] = STATE(1403),
    [sym_binary_expression] = STATE(1403),
    [sym_unary_expression] = STATE(1403),
    [sym_update_expression] = STATE(1403),
    [sym_string] = STATE(1853),
    [sym_template_string] = STATE(1405),
    [sym_regex] = STATE(1405),
    [sym_meta_property] = STATE(1405),
    [sym_decorator] = STATE(1149),
    [sym_formal_parameters] = STATE(3260),
    [sym_pattern] = STATE(3265),
    [sym_rest_pattern] = STATE(2817),
    [sym_non_null_expression] = STATE(1058),
    [sym_type_assertion] = STATE(1403),
    [sym_as_expression] = STATE(1403),
    [sym_internal_module] = STATE(1403),
    [sym_nested_type_identifier] = STATE(2336),
    [sym_accessibility_modifier] = STATE(200),
    [sym_override_modifier] = STATE(206),
    [sym_required_parameter] = STATE(3477),
    [sym_optional_parameter] = STATE(3477),
    [sym__parameter_name] = STATE(2820),
    [sym__type] = STATE(3349),
    [sym_constructor_type] = STATE(3349),
    [sym__primary_type] = STATE(2373),
    [sym_template_literal_type] = STATE(2359),
    [sym_infer_type] = STATE(3349),
    [sym_conditional_type] = STATE(2359),
    [sym_generic_type] = STATE(2359),
    [sym_type_query] = STATE(2359),
    [sym_index_type_query] = STATE(2359),
    [sym_lookup_type] = STATE(2359),
    [sym_literal_type] = STATE(2359),
    [sym__number] = STATE(2355),
    [sym_existential_type] = STATE(2359),
    [sym_flow_maybe_type] = STATE(2359),
    [sym_parenthesized_type] = STATE(2359),
    [sym_predefined_type] = STATE(2359),
    [sym_type_arguments] = STATE(519),
    [sym_object_type] = STATE(2359),
    [sym_type_parameters] = STATE(3839),
    [sym_array_type] = STATE(2359),
    [sym_tuple_type] = STATE(2359),
    [sym_readonly_type] = STATE(3349),
    [sym_union_type] = STATE(2359),
    [sym_intersection_type] = STATE(2359),
    [sym_function_type] = STATE(3349),
    [aux_sym_export_statement_repeat1] = STATE(181),
    [sym_identifier] = ACTIONS(105),
    [anon_sym_export] = ACTIONS(107),
    [anon_sym_STAR] = ACTIONS(537),
    [anon_sym_type] = ACTIONS(107),
    [anon_sym_namespace] = ACTIONS(116),
    [anon_sym_LBRACE] = ACTIONS(118),
    [anon_sym_typeof] = ACTIONS(123),
    [anon_sym_import] = ACTIONS(125),
    [anon_sym_BANG] = ACTIONS(165),
    [anon_sym_LPAREN] = ACTIONS(130),
    [anon_sym_RPAREN] = ACTIONS(651),
    [anon_sym_await] = ACTIONS(132),
    [anon_sym_yield] = ACTIONS(134),
    [anon_sym_LBRACK] = ACTIONS(136),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(557),
    [anon_sym_class] = ACTIONS(143),
    [anon_sym_async] = ACTIONS(145),
    [anon_sym_function] = ACTIONS(147),
    [anon_sym_new] = ACTIONS(153),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(157),
    [anon_sym_AMP] = ACTIONS(565),
    [anon_sym_PIPE] = ACTIONS(567),
    [anon_sym_PLUS] = ACTIONS(163),
    [anon_sym_DASH] = ACTIONS(163),
    [anon_sym_TILDE] = ACTIONS(165),
    [anon_sym_void] = ACTIONS(167),
    [anon_sym_delete] = ACTIONS(169),
    [anon_sym_PLUS_PLUS] = ACTIONS(675),
    [anon_sym_DASH_DASH] = ACTIONS(675),
    [anon_sym_DQUOTE] = ACTIONS(174),
    [anon_sym_SQUOTE] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(178),
    [sym_number] = ACTIONS(180),
    [sym_this] = ACTIONS(677),
    [sym_super] = ACTIONS(184),
    [sym_true] = ACTIONS(186),
    [sym_false] = ACTIONS(186),
    [sym_null] = ACTIONS(186),
    [sym_undefined] = ACTIONS(188),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(107),
    [anon_sym_readonly] = ACTIONS(679),
    [anon_sym_get] = ACTIONS(107),
    [anon_sym_set] = ACTIONS(107),
    [anon_sym_QMARK] = ACTIONS(583),
    [anon_sym_declare] = ACTIONS(107),
    [anon_sym_public] = ACTIONS(681),
    [anon_sym_private] = ACTIONS(681),
    [anon_sym_protected] = ACTIONS(681),
    [anon_sym_override] = ACTIONS(683),
    [anon_sym_module] = ACTIONS(107),
    [anon_sym_any] = ACTIONS(194),
    [anon_sym_number] = ACTIONS(194),
    [anon_sym_boolean] = ACTIONS(194),
    [anon_sym_string] = ACTIONS(194),
    [anon_sym_symbol] = ACTIONS(194),
    [anon_sym_abstract] = ACTIONS(196),
    [anon_sym_infer] = ACTIONS(198),
    [anon_sym_keyof] = ACTIONS(200),
    [anon_sym_unknown] = ACTIONS(202),
    [anon_sym_never] = ACTIONS(202),
    [anon_sym_object] = ACTIONS(202),
    [anon_sym_LBRACE_PIPE] = ACTIONS(204),
  },
  [70] = {
    [sym_import] = STATE(1405),
    [sym_parenthesized_expression] = STATE(1023),
    [sym_expression] = STATE(2015),
    [sym_primary_expression] = STATE(1404),
    [sym_yield_expression] = STATE(1403),
    [sym_object] = STATE(1405),
    [sym_object_pattern] = STATE(2733),
    [sym_array] = STATE(1405),
    [sym_array_pattern] = STATE(2733),
    [sym_nested_identifier] = STATE(4074),
    [sym_class] = STATE(1405),
    [sym_function] = STATE(1405),
    [sym_generator_function] = STATE(1405),
    [sym_arrow_function] = STATE(1405),
    [sym__call_signature] = STATE(4016),
    [sym__formal_parameter] = STATE(3477),
    [sym_call_expression] = STATE(1405),
    [sym_new_expression] = STATE(1403),
    [sym_await_expression] = STATE(1403),
    [sym_member_expression] = STATE(1058),
    [sym_subscript_expression] = STATE(1058),
    [sym_assignment_expression] = STATE(1403),
    [sym__augmented_assignment_lhs] = STATE(2340),
    [sym_augmented_assignment_expression] = STATE(1403),
    [sym__destructuring_pattern] = STATE(2733),
    [sym_ternary_expression] = STATE(1403),
    [sym_binary_expression] = STATE(1403),
    [sym_unary_expression] = STATE(1403),
    [sym_update_expression] = STATE(1403),
    [sym_string] = STATE(1853),
    [sym_template_string] = STATE(1405),
    [sym_regex] = STATE(1405),
    [sym_meta_property] = STATE(1405),
    [sym_decorator] = STATE(1149),
    [sym_formal_parameters] = STATE(3260),
    [sym_pattern] = STATE(3265),
    [sym_rest_pattern] = STATE(2817),
    [sym_non_null_expression] = STATE(1058),
    [sym_type_assertion] = STATE(1403),
    [sym_as_expression] = STATE(1403),
    [sym_internal_module] = STATE(1403),
    [sym_nested_type_identifier] = STATE(2336),
    [sym_accessibility_modifier] = STATE(200),
    [sym_override_modifier] = STATE(206),
    [sym_required_parameter] = STATE(3477),
    [sym_optional_parameter] = STATE(3477),
    [sym__parameter_name] = STATE(2820),
    [sym__type] = STATE(3281),
    [sym_constructor_type] = STATE(3281),
    [sym__primary_type] = STATE(2373),
    [sym_template_literal_type] = STATE(2359),
    [sym_infer_type] = STATE(3281),
    [sym_conditional_type] = STATE(2359),
    [sym_generic_type] = STATE(2359),
    [sym_type_query] = STATE(2359),
    [sym_index_type_query] = STATE(2359),
    [sym_lookup_type] = STATE(2359),
    [sym_literal_type] = STATE(2359),
    [sym__number] = STATE(2355),
    [sym_existential_type] = STATE(2359),
    [sym_flow_maybe_type] = STATE(2359),
    [sym_parenthesized_type] = STATE(2359),
    [sym_predefined_type] = STATE(2359),
    [sym_type_arguments] = STATE(519),
    [sym_object_type] = STATE(2359),
    [sym_type_parameters] = STATE(3839),
    [sym_array_type] = STATE(2359),
    [sym_tuple_type] = STATE(2359),
    [sym_readonly_type] = STATE(3281),
    [sym_union_type] = STATE(2359),
    [sym_intersection_type] = STATE(2359),
    [sym_function_type] = STATE(3281),
    [aux_sym_export_statement_repeat1] = STATE(181),
    [sym_identifier] = ACTIONS(105),
    [anon_sym_export] = ACTIONS(107),
    [anon_sym_STAR] = ACTIONS(537),
    [anon_sym_type] = ACTIONS(107),
    [anon_sym_namespace] = ACTIONS(116),
    [anon_sym_LBRACE] = ACTIONS(118),
    [anon_sym_typeof] = ACTIONS(123),
    [anon_sym_import] = ACTIONS(125),
    [anon_sym_BANG] = ACTIONS(165),
    [anon_sym_LPAREN] = ACTIONS(130),
    [anon_sym_RPAREN] = ACTIONS(651),
    [anon_sym_await] = ACTIONS(132),
    [anon_sym_yield] = ACTIONS(134),
    [anon_sym_LBRACK] = ACTIONS(136),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(557),
    [anon_sym_class] = ACTIONS(143),
    [anon_sym_async] = ACTIONS(145),
    [anon_sym_function] = ACTIONS(147),
    [anon_sym_new] = ACTIONS(153),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(157),
    [anon_sym_AMP] = ACTIONS(565),
    [anon_sym_PIPE] = ACTIONS(567),
    [anon_sym_PLUS] = ACTIONS(163),
    [anon_sym_DASH] = ACTIONS(163),
    [anon_sym_TILDE] = ACTIONS(165),
    [anon_sym_void] = ACTIONS(167),
    [anon_sym_delete] = ACTIONS(169),
    [anon_sym_PLUS_PLUS] = ACTIONS(675),
    [anon_sym_DASH_DASH] = ACTIONS(675),
    [anon_sym_DQUOTE] = ACTIONS(174),
    [anon_sym_SQUOTE] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(178),
    [sym_number] = ACTIONS(180),
    [sym_this] = ACTIONS(677),
    [sym_super] = ACTIONS(184),
    [sym_true] = ACTIONS(186),
    [sym_false] = ACTIONS(186),
    [sym_null] = ACTIONS(186),
    [sym_undefined] = ACTIONS(188),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(107),
    [anon_sym_readonly] = ACTIONS(679),
    [anon_sym_get] = ACTIONS(107),
    [anon_sym_set] = ACTIONS(107),
    [anon_sym_QMARK] = ACTIONS(583),
    [anon_sym_declare] = ACTIONS(107),
    [anon_sym_public] = ACTIONS(681),
    [anon_sym_private] = ACTIONS(681),
    [anon_sym_protected] = ACTIONS(681),
    [anon_sym_override] = ACTIONS(683),
    [anon_sym_module] = ACTIONS(107),
    [anon_sym_any] = ACTIONS(194),
    [anon_sym_number] = ACTIONS(194),
    [anon_sym_boolean] = ACTIONS(194),
    [anon_sym_string] = ACTIONS(194),
    [anon_sym_symbol] = ACTIONS(194),
    [anon_sym_abstract] = ACTIONS(196),
    [anon_sym_infer] = ACTIONS(198),
    [anon_sym_keyof] = ACTIONS(200),
    [anon_sym_unknown] = ACTIONS(202),
    [anon_sym_never] = ACTIONS(202),
    [anon_sym_object] = ACTIONS(202),
    [anon_sym_LBRACE_PIPE] = ACTIONS(204),
  },
  [71] = {
    [sym_import] = STATE(1405),
    [sym_parenthesized_expression] = STATE(1023),
    [sym_expression] = STATE(2015),
    [sym_primary_expression] = STATE(1404),
    [sym_yield_expression] = STATE(1403),
    [sym_object] = STATE(1405),
    [sym_object_pattern] = STATE(2733),
    [sym_array] = STATE(1405),
    [sym_array_pattern] = STATE(2733),
    [sym_nested_identifier] = STATE(4074),
    [sym_class] = STATE(1405),
    [sym_function] = STATE(1405),
    [sym_generator_function] = STATE(1405),
    [sym_arrow_function] = STATE(1405),
    [sym__call_signature] = STATE(4016),
    [sym__formal_parameter] = STATE(3477),
    [sym_call_expression] = STATE(1405),
    [sym_new_expression] = STATE(1403),
    [sym_await_expression] = STATE(1403),
    [sym_member_expression] = STATE(1058),
    [sym_subscript_expression] = STATE(1058),
    [sym_assignment_expression] = STATE(1403),
    [sym__augmented_assignment_lhs] = STATE(2340),
    [sym_augmented_assignment_expression] = STATE(1403),
    [sym__destructuring_pattern] = STATE(2733),
    [sym_ternary_expression] = STATE(1403),
    [sym_binary_expression] = STATE(1403),
    [sym_unary_expression] = STATE(1403),
    [sym_update_expression] = STATE(1403),
    [sym_string] = STATE(1853),
    [sym_template_string] = STATE(1405),
    [sym_regex] = STATE(1405),
    [sym_meta_property] = STATE(1405),
    [sym_decorator] = STATE(1149),
    [sym_formal_parameters] = STATE(3260),
    [sym_pattern] = STATE(3265),
    [sym_rest_pattern] = STATE(2817),
    [sym_non_null_expression] = STATE(1058),
    [sym_type_assertion] = STATE(1403),
    [sym_as_expression] = STATE(1403),
    [sym_internal_module] = STATE(1403),
    [sym_nested_type_identifier] = STATE(2336),
    [sym_accessibility_modifier] = STATE(200),
    [sym_override_modifier] = STATE(206),
    [sym_required_parameter] = STATE(3477),
    [sym_optional_parameter] = STATE(3477),
    [sym__parameter_name] = STATE(2820),
    [sym__type] = STATE(3336),
    [sym_constructor_type] = STATE(3336),
    [sym__primary_type] = STATE(2373),
    [sym_template_literal_type] = STATE(2359),
    [sym_infer_type] = STATE(3336),
    [sym_conditional_type] = STATE(2359),
    [sym_generic_type] = STATE(2359),
    [sym_type_query] = STATE(2359),
    [sym_index_type_query] = STATE(2359),
    [sym_lookup_type] = STATE(2359),
    [sym_literal_type] = STATE(2359),
    [sym__number] = STATE(2355),
    [sym_existential_type] = STATE(2359),
    [sym_flow_maybe_type] = STATE(2359),
    [sym_parenthesized_type] = STATE(2359),
    [sym_predefined_type] = STATE(2359),
    [sym_type_arguments] = STATE(519),
    [sym_object_type] = STATE(2359),
    [sym_type_parameters] = STATE(3839),
    [sym_array_type] = STATE(2359),
    [sym_tuple_type] = STATE(2359),
    [sym_readonly_type] = STATE(3336),
    [sym_union_type] = STATE(2359),
    [sym_intersection_type] = STATE(2359),
    [sym_function_type] = STATE(3336),
    [aux_sym_export_statement_repeat1] = STATE(181),
    [sym_identifier] = ACTIONS(105),
    [anon_sym_export] = ACTIONS(107),
    [anon_sym_STAR] = ACTIONS(537),
    [anon_sym_type] = ACTIONS(107),
    [anon_sym_namespace] = ACTIONS(116),
    [anon_sym_LBRACE] = ACTIONS(118),
    [anon_sym_typeof] = ACTIONS(123),
    [anon_sym_import] = ACTIONS(125),
    [anon_sym_BANG] = ACTIONS(165),
    [anon_sym_LPAREN] = ACTIONS(130),
    [anon_sym_RPAREN] = ACTIONS(651),
    [anon_sym_await] = ACTIONS(132),
    [anon_sym_yield] = ACTIONS(134),
    [anon_sym_LBRACK] = ACTIONS(136),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(557),
    [anon_sym_class] = ACTIONS(143),
    [anon_sym_async] = ACTIONS(145),
    [anon_sym_function] = ACTIONS(147),
    [anon_sym_new] = ACTIONS(153),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(157),
    [anon_sym_AMP] = ACTIONS(565),
    [anon_sym_PIPE] = ACTIONS(567),
    [anon_sym_PLUS] = ACTIONS(163),
    [anon_sym_DASH] = ACTIONS(163),
    [anon_sym_TILDE] = ACTIONS(165),
    [anon_sym_void] = ACTIONS(167),
    [anon_sym_delete] = ACTIONS(169),
    [anon_sym_PLUS_PLUS] = ACTIONS(675),
    [anon_sym_DASH_DASH] = ACTIONS(675),
    [anon_sym_DQUOTE] = ACTIONS(174),
    [anon_sym_SQUOTE] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(178),
    [sym_number] = ACTIONS(180),
    [sym_this] = ACTIONS(677),
    [sym_super] = ACTIONS(184),
    [sym_true] = ACTIONS(186),
    [sym_false] = ACTIONS(186),
    [sym_null] = ACTIONS(186),
    [sym_undefined] = ACTIONS(188),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(107),
    [anon_sym_readonly] = ACTIONS(679),
    [anon_sym_get] = ACTIONS(107),
    [anon_sym_set] = ACTIONS(107),
    [anon_sym_QMARK] = ACTIONS(583),
    [anon_sym_declare] = ACTIONS(107),
    [anon_sym_public] = ACTIONS(681),
    [anon_sym_private] = ACTIONS(681),
    [anon_sym_protected] = ACTIONS(681),
    [anon_sym_override] = ACTIONS(683),
    [anon_sym_module] = ACTIONS(107),
    [anon_sym_any] = ACTIONS(194),
    [anon_sym_number] = ACTIONS(194),
    [anon_sym_boolean] = ACTIONS(194),
    [anon_sym_string] = ACTIONS(194),
    [anon_sym_symbol] = ACTIONS(194),
    [anon_sym_abstract] = ACTIONS(196),
    [anon_sym_infer] = ACTIONS(198),
    [anon_sym_keyof] = ACTIONS(200),
    [anon_sym_unknown] = ACTIONS(202),
    [anon_sym_never] = ACTIONS(202),
    [anon_sym_object] = ACTIONS(202),
    [anon_sym_LBRACE_PIPE] = ACTIONS(204),
  },
  [72] = {
    [sym_import] = STATE(1405),
    [sym_parenthesized_expression] = STATE(1023),
    [sym_expression] = STATE(2015),
    [sym_primary_expression] = STATE(1404),
    [sym_yield_expression] = STATE(1403),
    [sym_object] = STATE(1405),
    [sym_object_pattern] = STATE(2733),
    [sym_array] = STATE(1405),
    [sym_array_pattern] = STATE(2733),
    [sym_nested_identifier] = STATE(4074),
    [sym_class] = STATE(1405),
    [sym_function] = STATE(1405),
    [sym_generator_function] = STATE(1405),
    [sym_arrow_function] = STATE(1405),
    [sym__call_signature] = STATE(4016),
    [sym__formal_parameter] = STATE(3477),
    [sym_call_expression] = STATE(1405),
    [sym_new_expression] = STATE(1403),
    [sym_await_expression] = STATE(1403),
    [sym_member_expression] = STATE(1058),
    [sym_subscript_expression] = STATE(1058),
    [sym_assignment_expression] = STATE(1403),
    [sym__augmented_assignment_lhs] = STATE(2340),
    [sym_augmented_assignment_expression] = STATE(1403),
    [sym__destructuring_pattern] = STATE(2733),
    [sym_ternary_expression] = STATE(1403),
    [sym_binary_expression] = STATE(1403),
    [sym_unary_expression] = STATE(1403),
    [sym_update_expression] = STATE(1403),
    [sym_string] = STATE(1853),
    [sym_template_string] = STATE(1405),
    [sym_regex] = STATE(1405),
    [sym_meta_property] = STATE(1405),
    [sym_decorator] = STATE(1149),
    [sym_formal_parameters] = STATE(3260),
    [sym_pattern] = STATE(3265),
    [sym_rest_pattern] = STATE(2817),
    [sym_non_null_expression] = STATE(1058),
    [sym_type_assertion] = STATE(1403),
    [sym_as_expression] = STATE(1403),
    [sym_internal_module] = STATE(1403),
    [sym_nested_type_identifier] = STATE(2336),
    [sym_accessibility_modifier] = STATE(200),
    [sym_override_modifier] = STATE(206),
    [sym_required_parameter] = STATE(3477),
    [sym_optional_parameter] = STATE(3477),
    [sym__parameter_name] = STATE(2820),
    [sym__type] = STATE(3305),
    [sym_constructor_type] = STATE(3305),
    [sym__primary_type] = STATE(2373),
    [sym_template_literal_type] = STATE(2359),
    [sym_infer_type] = STATE(3305),
    [sym_conditional_type] = STATE(2359),
    [sym_generic_type] = STATE(2359),
    [sym_type_query] = STATE(2359),
    [sym_index_type_query] = STATE(2359),
    [sym_lookup_type] = STATE(2359),
    [sym_literal_type] = STATE(2359),
    [sym__number] = STATE(2355),
    [sym_existential_type] = STATE(2359),
    [sym_flow_maybe_type] = STATE(2359),
    [sym_parenthesized_type] = STATE(2359),
    [sym_predefined_type] = STATE(2359),
    [sym_type_arguments] = STATE(519),
    [sym_object_type] = STATE(2359),
    [sym_type_parameters] = STATE(3839),
    [sym_array_type] = STATE(2359),
    [sym_tuple_type] = STATE(2359),
    [sym_readonly_type] = STATE(3305),
    [sym_union_type] = STATE(2359),
    [sym_intersection_type] = STATE(2359),
    [sym_function_type] = STATE(3305),
    [aux_sym_export_statement_repeat1] = STATE(181),
    [sym_identifier] = ACTIONS(105),
    [anon_sym_export] = ACTIONS(107),
    [anon_sym_STAR] = ACTIONS(537),
    [anon_sym_type] = ACTIONS(107),
    [anon_sym_namespace] = ACTIONS(116),
    [anon_sym_LBRACE] = ACTIONS(118),
    [anon_sym_typeof] = ACTIONS(123),
    [anon_sym_import] = ACTIONS(125),
    [anon_sym_BANG] = ACTIONS(165),
    [anon_sym_LPAREN] = ACTIONS(130),
    [anon_sym_RPAREN] = ACTIONS(651),
    [anon_sym_await] = ACTIONS(132),
    [anon_sym_yield] = ACTIONS(134),
    [anon_sym_LBRACK] = ACTIONS(136),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(557),
    [anon_sym_class] = ACTIONS(143),
    [anon_sym_async] = ACTIONS(145),
    [anon_sym_function] = ACTIONS(147),
    [anon_sym_new] = ACTIONS(153),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(157),
    [anon_sym_AMP] = ACTIONS(565),
    [anon_sym_PIPE] = ACTIONS(567),
    [anon_sym_PLUS] = ACTIONS(163),
    [anon_sym_DASH] = ACTIONS(163),
    [anon_sym_TILDE] = ACTIONS(165),
    [anon_sym_void] = ACTIONS(167),
    [anon_sym_delete] = ACTIONS(169),
    [anon_sym_PLUS_PLUS] = ACTIONS(675),
    [anon_sym_DASH_DASH] = ACTIONS(675),
    [anon_sym_DQUOTE] = ACTIONS(174),
    [anon_sym_SQUOTE] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(178),
    [sym_number] = ACTIONS(180),
    [sym_this] = ACTIONS(677),
    [sym_super] = ACTIONS(184),
    [sym_true] = ACTIONS(186),
    [sym_false] = ACTIONS(186),
    [sym_null] = ACTIONS(186),
    [sym_undefined] = ACTIONS(188),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(107),
    [anon_sym_readonly] = ACTIONS(679),
    [anon_sym_get] = ACTIONS(107),
    [anon_sym_set] = ACTIONS(107),
    [anon_sym_QMARK] = ACTIONS(583),
    [anon_sym_declare] = ACTIONS(107),
    [anon_sym_public] = ACTIONS(681),
    [anon_sym_private] = ACTIONS(681),
    [anon_sym_protected] = ACTIONS(681),
    [anon_sym_override] = ACTIONS(683),
    [anon_sym_module] = ACTIONS(107),
    [anon_sym_any] = ACTIONS(194),
    [anon_sym_number] = ACTIONS(194),
    [anon_sym_boolean] = ACTIONS(194),
    [anon_sym_string] = ACTIONS(194),
    [anon_sym_symbol] = ACTIONS(194),
    [anon_sym_abstract] = ACTIONS(196),
    [anon_sym_infer] = ACTIONS(198),
    [anon_sym_keyof] = ACTIONS(200),
    [anon_sym_unknown] = ACTIONS(202),
    [anon_sym_never] = ACTIONS(202),
    [anon_sym_object] = ACTIONS(202),
    [anon_sym_LBRACE_PIPE] = ACTIONS(204),
  },
  [73] = {
    [sym_import] = STATE(1405),
    [sym_parenthesized_expression] = STATE(1023),
    [sym_expression] = STATE(2015),
    [sym_primary_expression] = STATE(1404),
    [sym_yield_expression] = STATE(1403),
    [sym_object] = STATE(1405),
    [sym_object_pattern] = STATE(2733),
    [sym_array] = STATE(1405),
    [sym_array_pattern] = STATE(2733),
    [sym_nested_identifier] = STATE(4074),
    [sym_class] = STATE(1405),
    [sym_function] = STATE(1405),
    [sym_generator_function] = STATE(1405),
    [sym_arrow_function] = STATE(1405),
    [sym__call_signature] = STATE(4016),
    [sym__formal_parameter] = STATE(3477),
    [sym_call_expression] = STATE(1405),
    [sym_new_expression] = STATE(1403),
    [sym_await_expression] = STATE(1403),
    [sym_member_expression] = STATE(1058),
    [sym_subscript_expression] = STATE(1058),
    [sym_assignment_expression] = STATE(1403),
    [sym__augmented_assignment_lhs] = STATE(2340),
    [sym_augmented_assignment_expression] = STATE(1403),
    [sym__destructuring_pattern] = STATE(2733),
    [sym_ternary_expression] = STATE(1403),
    [sym_binary_expression] = STATE(1403),
    [sym_unary_expression] = STATE(1403),
    [sym_update_expression] = STATE(1403),
    [sym_string] = STATE(1853),
    [sym_template_string] = STATE(1405),
    [sym_regex] = STATE(1405),
    [sym_meta_property] = STATE(1405),
    [sym_decorator] = STATE(1149),
    [sym_formal_parameters] = STATE(3260),
    [sym_pattern] = STATE(3265),
    [sym_rest_pattern] = STATE(2817),
    [sym_non_null_expression] = STATE(1058),
    [sym_type_assertion] = STATE(1403),
    [sym_as_expression] = STATE(1403),
    [sym_internal_module] = STATE(1403),
    [sym_nested_type_identifier] = STATE(2336),
    [sym_accessibility_modifier] = STATE(200),
    [sym_override_modifier] = STATE(206),
    [sym_required_parameter] = STATE(3477),
    [sym_optional_parameter] = STATE(3477),
    [sym__parameter_name] = STATE(2820),
    [sym__type] = STATE(3326),
    [sym_constructor_type] = STATE(3326),
    [sym__primary_type] = STATE(2373),
    [sym_template_literal_type] = STATE(2359),
    [sym_infer_type] = STATE(3326),
    [sym_conditional_type] = STATE(2359),
    [sym_generic_type] = STATE(2359),
    [sym_type_query] = STATE(2359),
    [sym_index_type_query] = STATE(2359),
    [sym_lookup_type] = STATE(2359),
    [sym_literal_type] = STATE(2359),
    [sym__number] = STATE(2355),
    [sym_existential_type] = STATE(2359),
    [sym_flow_maybe_type] = STATE(2359),
    [sym_parenthesized_type] = STATE(2359),
    [sym_predefined_type] = STATE(2359),
    [sym_type_arguments] = STATE(519),
    [sym_object_type] = STATE(2359),
    [sym_type_parameters] = STATE(3839),
    [sym_array_type] = STATE(2359),
    [sym_tuple_type] = STATE(2359),
    [sym_readonly_type] = STATE(3326),
    [sym_union_type] = STATE(2359),
    [sym_intersection_type] = STATE(2359),
    [sym_function_type] = STATE(3326),
    [aux_sym_export_statement_repeat1] = STATE(181),
    [sym_identifier] = ACTIONS(105),
    [anon_sym_export] = ACTIONS(107),
    [anon_sym_STAR] = ACTIONS(537),
    [anon_sym_type] = ACTIONS(107),
    [anon_sym_namespace] = ACTIONS(116),
    [anon_sym_LBRACE] = ACTIONS(118),
    [anon_sym_typeof] = ACTIONS(123),
    [anon_sym_import] = ACTIONS(125),
    [anon_sym_BANG] = ACTIONS(165),
    [anon_sym_LPAREN] = ACTIONS(130),
    [anon_sym_RPAREN] = ACTIONS(651),
    [anon_sym_await] = ACTIONS(132),
    [anon_sym_yield] = ACTIONS(134),
    [anon_sym_LBRACK] = ACTIONS(136),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(557),
    [anon_sym_class] = ACTIONS(143),
    [anon_sym_async] = ACTIONS(145),
    [anon_sym_function] = ACTIONS(147),
    [anon_sym_new] = ACTIONS(153),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(157),
    [anon_sym_AMP] = ACTIONS(565),
    [anon_sym_PIPE] = ACTIONS(567),
    [anon_sym_PLUS] = ACTIONS(163),
    [anon_sym_DASH] = ACTIONS(163),
    [anon_sym_TILDE] = ACTIONS(165),
    [anon_sym_void] = ACTIONS(167),
    [anon_sym_delete] = ACTIONS(169),
    [anon_sym_PLUS_PLUS] = ACTIONS(675),
    [anon_sym_DASH_DASH] = ACTIONS(675),
    [anon_sym_DQUOTE] = ACTIONS(174),
    [anon_sym_SQUOTE] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(178),
    [sym_number] = ACTIONS(180),
    [sym_this] = ACTIONS(677),
    [sym_super] = ACTIONS(184),
    [sym_true] = ACTIONS(186),
    [sym_false] = ACTIONS(186),
    [sym_null] = ACTIONS(186),
    [sym_undefined] = ACTIONS(188),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(107),
    [anon_sym_readonly] = ACTIONS(679),
    [anon_sym_get] = ACTIONS(107),
    [anon_sym_set] = ACTIONS(107),
    [anon_sym_QMARK] = ACTIONS(583),
    [anon_sym_declare] = ACTIONS(107),
    [anon_sym_public] = ACTIONS(681),
    [anon_sym_private] = ACTIONS(681),
    [anon_sym_protected] = ACTIONS(681),
    [anon_sym_override] = ACTIONS(683),
    [anon_sym_module] = ACTIONS(107),
    [anon_sym_any] = ACTIONS(194),
    [anon_sym_number] = ACTIONS(194),
    [anon_sym_boolean] = ACTIONS(194),
    [anon_sym_string] = ACTIONS(194),
    [anon_sym_symbol] = ACTIONS(194),
    [anon_sym_abstract] = ACTIONS(196),
    [anon_sym_infer] = ACTIONS(198),
    [anon_sym_keyof] = ACTIONS(200),
    [anon_sym_unknown] = ACTIONS(202),
    [anon_sym_never] = ACTIONS(202),
    [anon_sym_object] = ACTIONS(202),
    [anon_sym_LBRACE_PIPE] = ACTIONS(204),
  },
  [74] = {
    [sym_import] = STATE(1405),
    [sym_parenthesized_expression] = STATE(1072),
    [sym_expression] = STATE(1766),
    [sym_primary_expression] = STATE(1404),
    [sym_yield_expression] = STATE(1403),
    [sym_object] = STATE(1405),
    [sym_object_pattern] = STATE(2812),
    [sym_assignment_pattern] = STATE(3666),
    [sym_array] = STATE(1405),
    [sym_array_pattern] = STATE(2812),
    [sym_nested_identifier] = STATE(3984),
    [sym_class] = STATE(1405),
    [sym_function] = STATE(1405),
    [sym_generator_function] = STATE(1405),
    [sym_arrow_function] = STATE(1405),
    [sym__call_signature] = STATE(4121),
    [sym_call_expression] = STATE(1405),
    [sym_new_expression] = STATE(1403),
    [sym_await_expression] = STATE(1403),
    [sym_member_expression] = STATE(1056),
    [sym_subscript_expression] = STATE(1056),
    [sym_assignment_expression] = STATE(1403),
    [sym__augmented_assignment_lhs] = STATE(2344),
    [sym_augmented_assignment_expression] = STATE(1403),
    [sym__destructuring_pattern] = STATE(2812),
    [sym_ternary_expression] = STATE(1403),
    [sym_binary_expression] = STATE(1403),
    [sym_unary_expression] = STATE(1403),
    [sym_update_expression] = STATE(1403),
    [sym_string] = STATE(1662),
    [sym_template_string] = STATE(1405),
    [sym_regex] = STATE(1405),
    [sym_meta_property] = STATE(1405),
    [sym_decorator] = STATE(1149),
    [sym_formal_parameters] = STATE(3155),
    [sym_pattern] = STATE(3503),
    [sym_rest_pattern] = STATE(2817),
    [sym_non_null_expression] = STATE(1056),
    [sym_type_assertion] = STATE(1403),
    [sym_as_expression] = STATE(1403),
    [sym_internal_module] = STATE(1403),
    [sym_nested_type_identifier] = STATE(2466),
    [sym__type] = STATE(2602),
    [sym_constructor_type] = STATE(2602),
    [sym__primary_type] = STATE(2543),
    [sym_template_literal_type] = STATE(2544),
    [sym_infer_type] = STATE(2602),
    [sym_conditional_type] = STATE(2544),
    [sym_generic_type] = STATE(2544),
    [sym_type_query] = STATE(2544),
    [sym_index_type_query] = STATE(2544),
    [sym_lookup_type] = STATE(2544),
    [sym_literal_type] = STATE(2544),
    [sym__number] = STATE(2545),
    [sym_existential_type] = STATE(2544),
    [sym_flow_maybe_type] = STATE(2544),
    [sym_parenthesized_type] = STATE(2544),
    [sym_predefined_type] = STATE(2544),
    [sym_type_arguments] = STATE(502),
    [sym_object_type] = STATE(2544),
    [sym_type_parameters] = STATE(3647),
    [sym_array_type] = STATE(2544),
    [sym_tuple_type] = STATE(2544),
    [sym_readonly_type] = STATE(2602),
    [sym_union_type] = STATE(2544),
    [sym_intersection_type] = STATE(2544),
    [sym_function_type] = STATE(2602),
    [aux_sym_export_statement_repeat1] = STATE(3368),
    [sym_identifier] = ACTIONS(685),
    [anon_sym_export] = ACTIONS(535),
    [anon_sym_STAR] = ACTIONS(687),
    [anon_sym_type] = ACTIONS(535),
    [anon_sym_namespace] = ACTIONS(539),
    [anon_sym_LBRACE] = ACTIONS(689),
    [anon_sym_typeof] = ACTIONS(691),
    [anon_sym_import] = ACTIONS(125),
    [anon_sym_BANG] = ACTIONS(547),
    [anon_sym_LPAREN] = ACTIONS(693),
    [anon_sym_await] = ACTIONS(549),
    [anon_sym_yield] = ACTIONS(551),
    [anon_sym_LBRACK] = ACTIONS(695),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(557),
    [anon_sym_class] = ACTIONS(143),
    [anon_sym_async] = ACTIONS(559),
    [anon_sym_function] = ACTIONS(147),
    [anon_sym_new] = ACTIONS(697),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(157),
    [anon_sym_AMP] = ACTIONS(699),
    [anon_sym_PIPE] = ACTIONS(701),
    [anon_sym_PLUS] = ACTIONS(703),
    [anon_sym_DASH] = ACTIONS(703),
    [anon_sym_TILDE] = ACTIONS(547),
    [anon_sym_void] = ACTIONS(705),
    [anon_sym_delete] = ACTIONS(573),
    [anon_sym_PLUS_PLUS] = ACTIONS(575),
    [anon_sym_DASH_DASH] = ACTIONS(575),
    [anon_sym_DQUOTE] = ACTIONS(79),
    [anon_sym_SQUOTE] = ACTIONS(81),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(707),
    [sym_number] = ACTIONS(709),
    [sym_this] = ACTIONS(711),
    [sym_super] = ACTIONS(184),
    [sym_true] = ACTIONS(713),
    [sym_false] = ACTIONS(713),
    [sym_null] = ACTIONS(713),
    [sym_undefined] = ACTIONS(715),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(535),
    [anon_sym_readonly] = ACTIONS(717),
    [anon_sym_get] = ACTIONS(535),
    [anon_sym_set] = ACTIONS(535),
    [anon_sym_QMARK] = ACTIONS(719),
    [anon_sym_declare] = ACTIONS(535),
    [anon_sym_public] = ACTIONS(535),
    [anon_sym_private] = ACTIONS(535),
    [anon_sym_protected] = ACTIONS(535),
    [anon_sym_override] = ACTIONS(535),
    [anon_sym_module] = ACTIONS(535),
    [anon_sym_any] = ACTIONS(721),
    [anon_sym_number] = ACTIONS(721),
    [anon_sym_boolean] = ACTIONS(721),
    [anon_sym_string] = ACTIONS(721),
    [anon_sym_symbol] = ACTIONS(721),
    [anon_sym_abstract] = ACTIONS(723),
    [anon_sym_infer] = ACTIONS(725),
    [anon_sym_keyof] = ACTIONS(727),
    [anon_sym_unknown] = ACTIONS(729),
    [anon_sym_never] = ACTIONS(729),
    [anon_sym_object] = ACTIONS(729),
    [anon_sym_LBRACE_PIPE] = ACTIONS(731),
  },
  [75] = {
    [sym_import] = STATE(1405),
    [sym_parenthesized_expression] = STATE(1072),
    [sym_expression] = STATE(1851),
    [sym_primary_expression] = STATE(1404),
    [sym_yield_expression] = STATE(1403),
    [sym_object] = STATE(1405),
    [sym_object_pattern] = STATE(4013),
    [sym_array] = STATE(1405),
    [sym_array_pattern] = STATE(4013),
    [sym_nested_identifier] = STATE(4074),
    [sym_class] = STATE(1405),
    [sym_function] = STATE(1405),
    [sym_generator_function] = STATE(1405),
    [sym_arrow_function] = STATE(1405),
    [sym__call_signature] = STATE(4121),
    [sym_call_expression] = STATE(1405),
    [sym_new_expression] = STATE(1403),
    [sym_await_expression] = STATE(1403),
    [sym_member_expression] = STATE(1072),
    [sym_subscript_expression] = STATE(1072),
    [sym_assignment_expression] = STATE(1403),
    [sym__augmented_assignment_lhs] = STATE(2344),
    [sym_augmented_assignment_expression] = STATE(1403),
    [sym__destructuring_pattern] = STATE(4013),
    [sym_ternary_expression] = STATE(1403),
    [sym_binary_expression] = STATE(1403),
    [sym_unary_expression] = STATE(1403),
    [sym_update_expression] = STATE(1403),
    [sym_sequence_expression] = STATE(4029),
    [sym_string] = STATE(1900),
    [sym_template_string] = STATE(1405),
    [sym_regex] = STATE(1405),
    [sym_meta_property] = STATE(1405),
    [sym_decorator] = STATE(1149),
    [sym_formal_parameters] = STATE(3260),
    [sym_non_null_expression] = STATE(1072),
    [sym_type_assertion] = STATE(1403),
    [sym_as_expression] = STATE(1403),
    [sym_internal_module] = STATE(1403),
    [sym_nested_type_identifier] = STATE(2336),
    [sym__type] = STATE(3470),
    [sym_constructor_type] = STATE(3470),
    [sym__primary_type] = STATE(3239),
    [sym_template_literal_type] = STATE(2359),
    [sym_infer_type] = STATE(3292),
    [sym_conditional_type] = STATE(2359),
    [sym_generic_type] = STATE(2359),
    [sym_type_query] = STATE(2359),
    [sym_index_type_query] = STATE(2359),
    [sym_lookup_type] = STATE(2359),
    [sym_literal_type] = STATE(2359),
    [sym__number] = STATE(2355),
    [sym_existential_type] = STATE(2359),
    [sym_flow_maybe_type] = STATE(2359),
    [sym_parenthesized_type] = STATE(2359),
    [sym_predefined_type] = STATE(2359),
    [sym_type_arguments] = STATE(502),
    [sym_object_type] = STATE(2359),
    [sym_type_parameters] = STATE(3839),
    [sym_array_type] = STATE(2359),
    [sym_tuple_type] = STATE(2359),
    [sym_readonly_type] = STATE(3470),
    [sym_union_type] = STATE(2359),
    [sym_intersection_type] = STATE(2359),
    [sym_function_type] = STATE(3470),
    [aux_sym_export_statement_repeat1] = STATE(3368),
    [sym_identifier] = ACTIONS(733),
    [anon_sym_export] = ACTIONS(735),
    [anon_sym_STAR] = ACTIONS(537),
    [anon_sym_type] = ACTIONS(735),
    [anon_sym_namespace] = ACTIONS(737),
    [anon_sym_LBRACE] = ACTIONS(739),
    [anon_sym_typeof] = ACTIONS(649),
    [anon_sym_import] = ACTIONS(125),
    [anon_sym_BANG] = ACTIONS(547),
    [anon_sym_LPAREN] = ACTIONS(130),
    [anon_sym_await] = ACTIONS(549),
    [anon_sym_yield] = ACTIONS(551),
    [anon_sym_LBRACK] = ACTIONS(741),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(557),
    [anon_sym_class] = ACTIONS(143),
    [anon_sym_async] = ACTIONS(743),
    [anon_sym_function] = ACTIONS(147),
    [anon_sym_new] = ACTIONS(561),
    [anon_sym_AMP] = ACTIONS(565),
    [anon_sym_PIPE] = ACTIONS(567),
    [anon_sym_PLUS] = ACTIONS(655),
    [anon_sym_DASH] = ACTIONS(655),
    [anon_sym_TILDE] = ACTIONS(547),
    [anon_sym_void] = ACTIONS(571),
    [anon_sym_delete] = ACTIONS(573),
    [anon_sym_PLUS_PLUS] = ACTIONS(575),
    [anon_sym_DASH_DASH] = ACTIONS(575),
    [anon_sym_DQUOTE] = ACTIONS(174),
    [anon_sym_SQUOTE] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(657),
    [sym_number] = ACTIONS(659),
    [sym_this] = ACTIONS(745),
    [sym_super] = ACTIONS(184),
    [sym_true] = ACTIONS(663),
    [sym_false] = ACTIONS(663),
    [sym_null] = ACTIONS(663),
    [sym_undefined] = ACTIONS(747),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(735),
    [anon_sym_readonly] = ACTIONS(749),
    [anon_sym_get] = ACTIONS(735),
    [anon_sym_set] = ACTIONS(735),
    [anon_sym_QMARK] = ACTIONS(583),
    [anon_sym_declare] = ACTIONS(735),
    [anon_sym_public] = ACTIONS(735),
    [anon_sym_private] = ACTIONS(735),
    [anon_sym_protected] = ACTIONS(735),
    [anon_sym_override] = ACTIONS(735),
    [anon_sym_module] = ACTIONS(735),
    [anon_sym_any] = ACTIONS(751),
    [anon_sym_number] = ACTIONS(751),
    [anon_sym_boolean] = ACTIONS(751),
    [anon_sym_string] = ACTIONS(751),
    [anon_sym_symbol] = ACTIONS(751),
    [anon_sym_abstract] = ACTIONS(196),
    [anon_sym_infer] = ACTIONS(198),
    [anon_sym_keyof] = ACTIONS(200),
    [anon_sym_unknown] = ACTIONS(202),
    [anon_sym_never] = ACTIONS(202),
    [anon_sym_object] = ACTIONS(202),
    [anon_sym_LBRACE_PIPE] = ACTIONS(204),
  },
  [76] = {
    [sym_import] = STATE(1844),
    [sym_parenthesized_expression] = STATE(1120),
    [sym_expression] = STATE(1472),
    [sym_primary_expression] = STATE(1799),
    [sym_yield_expression] = STATE(1798),
    [sym_object] = STATE(1844),
    [sym_object_pattern] = STATE(4151),
    [sym_array] = STATE(1844),
    [sym_array_pattern] = STATE(4151),
    [sym_nested_identifier] = STATE(4074),
    [sym_class] = STATE(1844),
    [sym_function] = STATE(1844),
    [sym_generator_function] = STATE(1844),
    [sym_arrow_function] = STATE(1844),
    [sym__call_signature] = STATE(4149),
    [sym_call_expression] = STATE(1844),
    [sym_new_expression] = STATE(1798),
    [sym_await_expression] = STATE(1798),
    [sym_member_expression] = STATE(1120),
    [sym_subscript_expression] = STATE(1120),
    [sym_assignment_expression] = STATE(1798),
    [sym__augmented_assignment_lhs] = STATE(2362),
    [sym_augmented_assignment_expression] = STATE(1798),
    [sym__destructuring_pattern] = STATE(4151),
    [sym_ternary_expression] = STATE(1798),
    [sym_binary_expression] = STATE(1798),
    [sym_unary_expression] = STATE(1798),
    [sym_update_expression] = STATE(1798),
    [sym_string] = STATE(1678),
    [sym_template_string] = STATE(1844),
    [sym_regex] = STATE(1844),
    [sym_meta_property] = STATE(1844),
    [sym_decorator] = STATE(1149),
    [sym_formal_parameters] = STATE(3260),
    [sym_non_null_expression] = STATE(1120),
    [sym_type_assertion] = STATE(1798),
    [sym_as_expression] = STATE(1798),
    [sym_internal_module] = STATE(1798),
    [sym_nested_type_identifier] = STATE(2336),
    [sym__type] = STATE(2859),
    [sym_constructor_type] = STATE(2859),
    [sym__primary_type] = STATE(2373),
    [sym_template_literal_type] = STATE(2359),
    [sym_infer_type] = STATE(2859),
    [sym_conditional_type] = STATE(2359),
    [sym_generic_type] = STATE(2359),
    [sym_type_query] = STATE(2359),
    [sym_index_type_query] = STATE(2359),
    [sym_lookup_type] = STATE(2359),
    [sym_literal_type] = STATE(2359),
    [sym__number] = STATE(2355),
    [sym_existential_type] = STATE(2359),
    [sym_flow_maybe_type] = STATE(2359),
    [sym_parenthesized_type] = STATE(2359),
    [sym_predefined_type] = STATE(2359),
    [sym_type_arguments] = STATE(344),
    [sym_object_type] = STATE(2359),
    [sym_type_parameters] = STATE(3839),
    [sym_array_type] = STATE(2359),
    [sym_tuple_type] = STATE(2359),
    [sym_readonly_type] = STATE(2859),
    [sym_union_type] = STATE(2359),
    [sym_intersection_type] = STATE(2359),
    [sym_function_type] = STATE(2859),
    [aux_sym_export_statement_repeat1] = STATE(3372),
    [sym_identifier] = ACTIONS(753),
    [anon_sym_export] = ACTIONS(755),
    [anon_sym_STAR] = ACTIONS(537),
    [anon_sym_type] = ACTIONS(755),
    [anon_sym_namespace] = ACTIONS(757),
    [anon_sym_LBRACE] = ACTIONS(759),
    [anon_sym_typeof] = ACTIONS(761),
    [anon_sym_import] = ACTIONS(763),
    [anon_sym_BANG] = ACTIONS(765),
    [anon_sym_LPAREN] = ACTIONS(767),
    [anon_sym_await] = ACTIONS(769),
    [anon_sym_yield] = ACTIONS(771),
    [anon_sym_LBRACK] = ACTIONS(773),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(775),
    [anon_sym_class] = ACTIONS(777),
    [anon_sym_async] = ACTIONS(779),
    [anon_sym_function] = ACTIONS(781),
    [anon_sym_new] = ACTIONS(783),
    [anon_sym_AMP] = ACTIONS(565),
    [anon_sym_PIPE] = ACTIONS(567),
    [anon_sym_PLUS] = ACTIONS(785),
    [anon_sym_DASH] = ACTIONS(785),
    [anon_sym_TILDE] = ACTIONS(765),
    [anon_sym_void] = ACTIONS(787),
    [anon_sym_delete] = ACTIONS(789),
    [anon_sym_PLUS_PLUS] = ACTIONS(791),
    [anon_sym_DASH_DASH] = ACTIONS(791),
    [anon_sym_DQUOTE] = ACTIONS(79),
    [anon_sym_SQUOTE] = ACTIONS(81),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(793),
    [sym_number] = ACTIONS(795),
    [sym_this] = ACTIONS(797),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(799),
    [sym_false] = ACTIONS(799),
    [sym_null] = ACTIONS(799),
    [sym_undefined] = ACTIONS(801),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(755),
    [anon_sym_readonly] = ACTIONS(803),
    [anon_sym_get] = ACTIONS(755),
    [anon_sym_set] = ACTIONS(755),
    [anon_sym_QMARK] = ACTIONS(583),
    [anon_sym_declare] = ACTIONS(755),
    [anon_sym_public] = ACTIONS(755),
    [anon_sym_private] = ACTIONS(755),
    [anon_sym_protected] = ACTIONS(755),
    [anon_sym_override] = ACTIONS(755),
    [anon_sym_module] = ACTIONS(755),
    [anon_sym_any] = ACTIONS(805),
    [anon_sym_number] = ACTIONS(805),
    [anon_sym_boolean] = ACTIONS(805),
    [anon_sym_string] = ACTIONS(805),
    [anon_sym_symbol] = ACTIONS(805),
    [anon_sym_abstract] = ACTIONS(196),
    [anon_sym_infer] = ACTIONS(198),
    [anon_sym_keyof] = ACTIONS(200),
    [anon_sym_unknown] = ACTIONS(202),
    [anon_sym_never] = ACTIONS(202),
    [anon_sym_object] = ACTIONS(202),
    [anon_sym_LBRACE_PIPE] = ACTIONS(204),
  },
  [77] = {
    [sym_import] = STATE(1405),
    [sym_parenthesized_expression] = STATE(1072),
    [sym_expression] = STATE(1430),
    [sym_primary_expression] = STATE(1404),
    [sym_yield_expression] = STATE(1403),
    [sym_object] = STATE(1405),
    [sym_object_pattern] = STATE(3053),
    [sym_array] = STATE(1405),
    [sym_array_pattern] = STATE(3053),
    [sym_nested_identifier] = STATE(4074),
    [sym_class] = STATE(1405),
    [sym_function] = STATE(1405),
    [sym_generator_function] = STATE(1405),
    [sym_arrow_function] = STATE(1405),
    [sym__call_signature] = STATE(4121),
    [sym_call_expression] = STATE(1405),
    [sym_new_expression] = STATE(1403),
    [sym_await_expression] = STATE(1403),
    [sym_member_expression] = STATE(1104),
    [sym_subscript_expression] = STATE(1104),
    [sym_assignment_expression] = STATE(1403),
    [sym__augmented_assignment_lhs] = STATE(2344),
    [sym_augmented_assignment_expression] = STATE(1403),
    [sym__destructuring_pattern] = STATE(3053),
    [sym_ternary_expression] = STATE(1403),
    [sym_binary_expression] = STATE(1403),
    [sym_unary_expression] = STATE(1403),
    [sym_update_expression] = STATE(1403),
    [sym_string] = STATE(1853),
    [sym_template_string] = STATE(1405),
    [sym_regex] = STATE(1405),
    [sym_meta_property] = STATE(1405),
    [sym_decorator] = STATE(1149),
    [sym_formal_parameters] = STATE(3260),
    [sym_non_null_expression] = STATE(1104),
    [sym_type_assertion] = STATE(1403),
    [sym_as_expression] = STATE(1403),
    [sym_internal_module] = STATE(1403),
    [sym_nested_type_identifier] = STATE(2336),
    [sym__type] = STATE(3198),
    [sym_constructor_type] = STATE(3198),
    [sym__primary_type] = STATE(2373),
    [sym_template_literal_type] = STATE(2359),
    [sym_infer_type] = STATE(3198),
    [sym_conditional_type] = STATE(2359),
    [sym_generic_type] = STATE(2359),
    [sym_type_query] = STATE(2359),
    [sym_index_type_query] = STATE(2359),
    [sym_lookup_type] = STATE(2359),
    [sym_literal_type] = STATE(2359),
    [sym__number] = STATE(2355),
    [sym_existential_type] = STATE(2359),
    [sym_flow_maybe_type] = STATE(2359),
    [sym_parenthesized_type] = STATE(2359),
    [sym_predefined_type] = STATE(2359),
    [sym_type_arguments] = STATE(502),
    [sym_object_type] = STATE(2359),
    [sym_type_parameters] = STATE(3839),
    [sym_array_type] = STATE(2359),
    [sym_tuple_type] = STATE(2359),
    [sym_readonly_type] = STATE(3198),
    [sym_union_type] = STATE(2359),
    [sym_intersection_type] = STATE(2359),
    [sym_function_type] = STATE(3198),
    [aux_sym_export_statement_repeat1] = STATE(3368),
    [sym_identifier] = ACTIONS(807),
    [anon_sym_export] = ACTIONS(809),
    [anon_sym_STAR] = ACTIONS(537),
    [anon_sym_type] = ACTIONS(809),
    [anon_sym_namespace] = ACTIONS(811),
    [anon_sym_LBRACE] = ACTIONS(813),
    [anon_sym_typeof] = ACTIONS(545),
    [anon_sym_import] = ACTIONS(125),
    [anon_sym_BANG] = ACTIONS(547),
    [anon_sym_LPAREN] = ACTIONS(130),
    [anon_sym_await] = ACTIONS(549),
    [anon_sym_yield] = ACTIONS(551),
    [anon_sym_LBRACK] = ACTIONS(553),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(557),
    [anon_sym_class] = ACTIONS(143),
    [anon_sym_async] = ACTIONS(815),
    [anon_sym_function] = ACTIONS(147),
    [anon_sym_new] = ACTIONS(561),
    [anon_sym_AMP] = ACTIONS(565),
    [anon_sym_PIPE] = ACTIONS(567),
    [anon_sym_PLUS] = ACTIONS(569),
    [anon_sym_DASH] = ACTIONS(569),
    [anon_sym_TILDE] = ACTIONS(547),
    [anon_sym_void] = ACTIONS(571),
    [anon_sym_delete] = ACTIONS(573),
    [anon_sym_PLUS_PLUS] = ACTIONS(575),
    [anon_sym_DASH_DASH] = ACTIONS(575),
    [anon_sym_DQUOTE] = ACTIONS(174),
    [anon_sym_SQUOTE] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(178),
    [sym_number] = ACTIONS(180),
    [sym_this] = ACTIONS(577),
    [sym_super] = ACTIONS(184),
    [sym_true] = ACTIONS(186),
    [sym_false] = ACTIONS(186),
    [sym_null] = ACTIONS(186),
    [sym_undefined] = ACTIONS(817),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(809),
    [anon_sym_readonly] = ACTIONS(819),
    [anon_sym_get] = ACTIONS(809),
    [anon_sym_set] = ACTIONS(809),
    [anon_sym_QMARK] = ACTIONS(583),
    [anon_sym_declare] = ACTIONS(809),
    [anon_sym_public] = ACTIONS(809),
    [anon_sym_private] = ACTIONS(809),
    [anon_sym_protected] = ACTIONS(809),
    [anon_sym_override] = ACTIONS(809),
    [anon_sym_module] = ACTIONS(809),
    [anon_sym_any] = ACTIONS(821),
    [anon_sym_number] = ACTIONS(821),
    [anon_sym_boolean] = ACTIONS(821),
    [anon_sym_string] = ACTIONS(821),
    [anon_sym_symbol] = ACTIONS(821),
    [anon_sym_abstract] = ACTIONS(196),
    [anon_sym_infer] = ACTIONS(198),
    [anon_sym_keyof] = ACTIONS(200),
    [anon_sym_unknown] = ACTIONS(202),
    [anon_sym_never] = ACTIONS(202),
    [anon_sym_object] = ACTIONS(202),
    [anon_sym_LBRACE_PIPE] = ACTIONS(204),
  },
  [78] = {
    [sym_import] = STATE(1405),
    [sym_parenthesized_expression] = STATE(1023),
    [sym_expression] = STATE(2024),
    [sym_primary_expression] = STATE(1404),
    [sym_yield_expression] = STATE(1403),
    [sym_object] = STATE(1405),
    [sym_object_pattern] = STATE(4117),
    [sym_array] = STATE(1405),
    [sym_array_pattern] = STATE(4117),
    [sym_nested_identifier] = STATE(4074),
    [sym_class] = STATE(1405),
    [sym_function] = STATE(1405),
    [sym_generator_function] = STATE(1405),
    [sym_arrow_function] = STATE(1405),
    [sym__call_signature] = STATE(4016),
    [sym_call_expression] = STATE(1405),
    [sym_new_expression] = STATE(1403),
    [sym_await_expression] = STATE(1403),
    [sym_member_expression] = STATE(1023),
    [sym_subscript_expression] = STATE(1023),
    [sym_assignment_expression] = STATE(1403),
    [sym__augmented_assignment_lhs] = STATE(2340),
    [sym_augmented_assignment_expression] = STATE(1403),
    [sym__destructuring_pattern] = STATE(4117),
    [sym_ternary_expression] = STATE(1403),
    [sym_binary_expression] = STATE(1403),
    [sym_unary_expression] = STATE(1403),
    [sym_update_expression] = STATE(1403),
    [sym_string] = STATE(1822),
    [sym_template_string] = STATE(1405),
    [sym_regex] = STATE(1405),
    [sym_meta_property] = STATE(1405),
    [sym_decorator] = STATE(1149),
    [sym_formal_parameters] = STATE(3260),
    [sym_non_null_expression] = STATE(1023),
    [sym_type_assertion] = STATE(1403),
    [sym_as_expression] = STATE(1403),
    [sym_internal_module] = STATE(1403),
    [sym_nested_type_identifier] = STATE(2336),
    [sym__type] = STATE(2859),
    [sym_constructor_type] = STATE(2859),
    [sym__primary_type] = STATE(2373),
    [sym_template_literal_type] = STATE(2359),
    [sym_infer_type] = STATE(2859),
    [sym_conditional_type] = STATE(2359),
    [sym_generic_type] = STATE(2359),
    [sym_type_query] = STATE(2359),
    [sym_index_type_query] = STATE(2359),
    [sym_lookup_type] = STATE(2359),
    [sym_literal_type] = STATE(2359),
    [sym__number] = STATE(2355),
    [sym_existential_type] = STATE(2359),
    [sym_flow_maybe_type] = STATE(2359),
    [sym_parenthesized_type] = STATE(2359),
    [sym_predefined_type] = STATE(2359),
    [sym_type_arguments] = STATE(519),
    [sym_object_type] = STATE(2359),
    [sym_type_parameters] = STATE(3839),
    [sym_array_type] = STATE(2359),
    [sym_tuple_type] = STATE(2359),
    [sym_readonly_type] = STATE(2859),
    [sym_union_type] = STATE(2359),
    [sym_intersection_type] = STATE(2359),
    [sym_function_type] = STATE(2859),
    [aux_sym_export_statement_repeat1] = STATE(3368),
    [sym_identifier] = ACTIONS(823),
    [anon_sym_export] = ACTIONS(825),
    [anon_sym_STAR] = ACTIONS(537),
    [anon_sym_type] = ACTIONS(825),
    [anon_sym_namespace] = ACTIONS(827),
    [anon_sym_LBRACE] = ACTIONS(829),
    [anon_sym_typeof] = ACTIONS(831),
    [anon_sym_import] = ACTIONS(125),
    [anon_sym_BANG] = ACTIONS(165),
    [anon_sym_LPAREN] = ACTIONS(130),
    [anon_sym_await] = ACTIONS(132),
    [anon_sym_yield] = ACTIONS(134),
    [anon_sym_LBRACK] = ACTIONS(833),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(557),
    [anon_sym_class] = ACTIONS(143),
    [anon_sym_async] = ACTIONS(835),
    [anon_sym_function] = ACTIONS(147),
    [anon_sym_new] = ACTIONS(153),
    [anon_sym_AMP] = ACTIONS(565),
    [anon_sym_PIPE] = ACTIONS(567),
    [anon_sym_PLUS] = ACTIONS(837),
    [anon_sym_DASH] = ACTIONS(837),
    [anon_sym_TILDE] = ACTIONS(165),
    [anon_sym_void] = ACTIONS(167),
    [anon_sym_delete] = ACTIONS(169),
    [anon_sym_PLUS_PLUS] = ACTIONS(675),
    [anon_sym_DASH_DASH] = ACTIONS(675),
    [anon_sym_DQUOTE] = ACTIONS(174),
    [anon_sym_SQUOTE] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(839),
    [sym_number] = ACTIONS(841),
    [sym_this] = ACTIONS(843),
    [sym_super] = ACTIONS(184),
    [sym_true] = ACTIONS(845),
    [sym_false] = ACTIONS(845),
    [sym_null] = ACTIONS(845),
    [sym_undefined] = ACTIONS(847),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(825),
    [anon_sym_readonly] = ACTIONS(849),
    [anon_sym_get] = ACTIONS(825),
    [anon_sym_set] = ACTIONS(825),
    [anon_sym_QMARK] = ACTIONS(583),
    [anon_sym_declare] = ACTIONS(825),
    [anon_sym_public] = ACTIONS(825),
    [anon_sym_private] = ACTIONS(825),
    [anon_sym_protected] = ACTIONS(825),
    [anon_sym_override] = ACTIONS(825),
    [anon_sym_module] = ACTIONS(825),
    [anon_sym_any] = ACTIONS(851),
    [anon_sym_number] = ACTIONS(851),
    [anon_sym_boolean] = ACTIONS(851),
    [anon_sym_string] = ACTIONS(851),
    [anon_sym_symbol] = ACTIONS(851),
    [anon_sym_abstract] = ACTIONS(196),
    [anon_sym_infer] = ACTIONS(198),
    [anon_sym_keyof] = ACTIONS(200),
    [anon_sym_unknown] = ACTIONS(202),
    [anon_sym_never] = ACTIONS(202),
    [anon_sym_object] = ACTIONS(202),
    [anon_sym_LBRACE_PIPE] = ACTIONS(204),
  },
  [79] = {
    [sym_import] = STATE(1844),
    [sym_parenthesized_expression] = STATE(1116),
    [sym_expression] = STATE(1456),
    [sym_primary_expression] = STATE(1799),
    [sym_yield_expression] = STATE(1798),
    [sym_object] = STATE(1844),
    [sym_object_pattern] = STATE(4170),
    [sym_array] = STATE(1844),
    [sym_array_pattern] = STATE(4170),
    [sym_nested_identifier] = STATE(4074),
    [sym_class] = STATE(1844),
    [sym_function] = STATE(1844),
    [sym_generator_function] = STATE(1844),
    [sym_arrow_function] = STATE(1844),
    [sym__call_signature] = STATE(4172),
    [sym_call_expression] = STATE(1844),
    [sym_new_expression] = STATE(1798),
    [sym_await_expression] = STATE(1798),
    [sym_member_expression] = STATE(1116),
    [sym_subscript_expression] = STATE(1116),
    [sym_assignment_expression] = STATE(1798),
    [sym__augmented_assignment_lhs] = STATE(2357),
    [sym_augmented_assignment_expression] = STATE(1798),
    [sym__destructuring_pattern] = STATE(4170),
    [sym_ternary_expression] = STATE(1798),
    [sym_binary_expression] = STATE(1798),
    [sym_unary_expression] = STATE(1798),
    [sym_update_expression] = STATE(1798),
    [sym_string] = STATE(1678),
    [sym_template_string] = STATE(1844),
    [sym_regex] = STATE(1844),
    [sym_meta_property] = STATE(1844),
    [sym_decorator] = STATE(1149),
    [sym_formal_parameters] = STATE(3260),
    [sym_non_null_expression] = STATE(1116),
    [sym_type_assertion] = STATE(1798),
    [sym_as_expression] = STATE(1798),
    [sym_internal_module] = STATE(1798),
    [sym_nested_type_identifier] = STATE(2336),
    [sym__type] = STATE(2859),
    [sym_constructor_type] = STATE(2859),
    [sym__primary_type] = STATE(2373),
    [sym_template_literal_type] = STATE(2359),
    [sym_infer_type] = STATE(2859),
    [sym_conditional_type] = STATE(2359),
    [sym_generic_type] = STATE(2359),
    [sym_type_query] = STATE(2359),
    [sym_index_type_query] = STATE(2359),
    [sym_lookup_type] = STATE(2359),
    [sym_literal_type] = STATE(2359),
    [sym__number] = STATE(2355),
    [sym_existential_type] = STATE(2359),
    [sym_flow_maybe_type] = STATE(2359),
    [sym_parenthesized_type] = STATE(2359),
    [sym_predefined_type] = STATE(2359),
    [sym_type_arguments] = STATE(482),
    [sym_object_type] = STATE(2359),
    [sym_type_parameters] = STATE(3839),
    [sym_array_type] = STATE(2359),
    [sym_tuple_type] = STATE(2359),
    [sym_readonly_type] = STATE(2859),
    [sym_union_type] = STATE(2359),
    [sym_intersection_type] = STATE(2359),
    [sym_function_type] = STATE(2859),
    [aux_sym_export_statement_repeat1] = STATE(3372),
    [sym_identifier] = ACTIONS(853),
    [anon_sym_export] = ACTIONS(855),
    [anon_sym_STAR] = ACTIONS(537),
    [anon_sym_type] = ACTIONS(855),
    [anon_sym_namespace] = ACTIONS(857),
    [anon_sym_LBRACE] = ACTIONS(759),
    [anon_sym_typeof] = ACTIONS(859),
    [anon_sym_import] = ACTIONS(763),
    [anon_sym_BANG] = ACTIONS(29),
    [anon_sym_LPAREN] = ACTIONS(767),
    [anon_sym_await] = ACTIONS(39),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(773),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(777),
    [anon_sym_async] = ACTIONS(861),
    [anon_sym_function] = ACTIONS(781),
    [anon_sym_new] = ACTIONS(863),
    [anon_sym_AMP] = ACTIONS(565),
    [anon_sym_PIPE] = ACTIONS(567),
    [anon_sym_PLUS] = ACTIONS(865),
    [anon_sym_DASH] = ACTIONS(865),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_void] = ACTIONS(867),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(77),
    [anon_sym_DASH_DASH] = ACTIONS(77),
    [anon_sym_DQUOTE] = ACTIONS(79),
    [anon_sym_SQUOTE] = ACTIONS(81),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(793),
    [sym_number] = ACTIONS(795),
    [sym_this] = ACTIONS(797),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(799),
    [sym_false] = ACTIONS(799),
    [sym_null] = ACTIONS(799),
    [sym_undefined] = ACTIONS(869),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(855),
    [anon_sym_readonly] = ACTIONS(871),
    [anon_sym_get] = ACTIONS(855),
    [anon_sym_set] = ACTIONS(855),
    [anon_sym_QMARK] = ACTIONS(583),
    [anon_sym_declare] = ACTIONS(855),
    [anon_sym_public] = ACTIONS(855),
    [anon_sym_private] = ACTIONS(855),
    [anon_sym_protected] = ACTIONS(855),
    [anon_sym_override] = ACTIONS(855),
    [anon_sym_module] = ACTIONS(855),
    [anon_sym_any] = ACTIONS(873),
    [anon_sym_number] = ACTIONS(873),
    [anon_sym_boolean] = ACTIONS(873),
    [anon_sym_string] = ACTIONS(873),
    [anon_sym_symbol] = ACTIONS(873),
    [anon_sym_abstract] = ACTIONS(196),
    [anon_sym_infer] = ACTIONS(198),
    [anon_sym_keyof] = ACTIONS(200),
    [anon_sym_unknown] = ACTIONS(202),
    [anon_sym_never] = ACTIONS(202),
    [anon_sym_object] = ACTIONS(202),
    [anon_sym_LBRACE_PIPE] = ACTIONS(204),
  },
  [80] = {
    [sym_import] = STATE(1844),
    [sym_parenthesized_expression] = STATE(1142),
    [sym_expression] = STATE(1901),
    [sym_primary_expression] = STATE(1799),
    [sym_yield_expression] = STATE(1798),
    [sym_object] = STATE(1844),
    [sym_object_pattern] = STATE(3982),
    [sym_array] = STATE(1844),
    [sym_array_pattern] = STATE(3982),
    [sym_nested_identifier] = STATE(4074),
    [sym_class] = STATE(1844),
    [sym_function] = STATE(1844),
    [sym_generator_function] = STATE(1844),
    [sym_arrow_function] = STATE(1844),
    [sym__call_signature] = STATE(3980),
    [sym_call_expression] = STATE(1844),
    [sym_new_expression] = STATE(1798),
    [sym_await_expression] = STATE(1798),
    [sym_member_expression] = STATE(1142),
    [sym_subscript_expression] = STATE(1142),
    [sym_assignment_expression] = STATE(1798),
    [sym__augmented_assignment_lhs] = STATE(2347),
    [sym_augmented_assignment_expression] = STATE(1798),
    [sym__destructuring_pattern] = STATE(3982),
    [sym_ternary_expression] = STATE(1798),
    [sym_binary_expression] = STATE(1798),
    [sym_unary_expression] = STATE(1798),
    [sym_update_expression] = STATE(1798),
    [sym_string] = STATE(1923),
    [sym_template_string] = STATE(1844),
    [sym_regex] = STATE(1844),
    [sym_meta_property] = STATE(1844),
    [sym_decorator] = STATE(1149),
    [sym_formal_parameters] = STATE(3260),
    [sym_non_null_expression] = STATE(1142),
    [sym_type_assertion] = STATE(1798),
    [sym_as_expression] = STATE(1798),
    [sym_internal_module] = STATE(1798),
    [sym_nested_type_identifier] = STATE(2336),
    [sym__type] = STATE(2859),
    [sym_constructor_type] = STATE(2859),
    [sym__primary_type] = STATE(2373),
    [sym_template_literal_type] = STATE(2359),
    [sym_infer_type] = STATE(2859),
    [sym_conditional_type] = STATE(2359),
    [sym_generic_type] = STATE(2359),
    [sym_type_query] = STATE(2359),
    [sym_index_type_query] = STATE(2359),
    [sym_lookup_type] = STATE(2359),
    [sym_literal_type] = STATE(2359),
    [sym__number] = STATE(2355),
    [sym_existential_type] = STATE(2359),
    [sym_flow_maybe_type] = STATE(2359),
    [sym_parenthesized_type] = STATE(2359),
    [sym_predefined_type] = STATE(2359),
    [sym_type_arguments] = STATE(398),
    [sym_object_type] = STATE(2359),
    [sym_type_parameters] = STATE(3839),
    [sym_array_type] = STATE(2359),
    [sym_tuple_type] = STATE(2359),
    [sym_readonly_type] = STATE(2859),
    [sym_union_type] = STATE(2359),
    [sym_intersection_type] = STATE(2359),
    [sym_function_type] = STATE(2859),
    [aux_sym_export_statement_repeat1] = STATE(3372),
    [sym_identifier] = ACTIONS(875),
    [anon_sym_export] = ACTIONS(877),
    [anon_sym_STAR] = ACTIONS(537),
    [anon_sym_type] = ACTIONS(877),
    [anon_sym_namespace] = ACTIONS(879),
    [anon_sym_LBRACE] = ACTIONS(881),
    [anon_sym_typeof] = ACTIONS(883),
    [anon_sym_import] = ACTIONS(763),
    [anon_sym_BANG] = ACTIONS(885),
    [anon_sym_LPAREN] = ACTIONS(767),
    [anon_sym_await] = ACTIONS(887),
    [anon_sym_yield] = ACTIONS(889),
    [anon_sym_LBRACK] = ACTIONS(891),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(777),
    [anon_sym_async] = ACTIONS(893),
    [anon_sym_function] = ACTIONS(781),
    [anon_sym_new] = ACTIONS(895),
    [anon_sym_AMP] = ACTIONS(565),
    [anon_sym_PIPE] = ACTIONS(567),
    [anon_sym_PLUS] = ACTIONS(897),
    [anon_sym_DASH] = ACTIONS(897),
    [anon_sym_TILDE] = ACTIONS(885),
    [anon_sym_void] = ACTIONS(899),
    [anon_sym_delete] = ACTIONS(901),
    [anon_sym_PLUS_PLUS] = ACTIONS(903),
    [anon_sym_DASH_DASH] = ACTIONS(903),
    [anon_sym_DQUOTE] = ACTIONS(79),
    [anon_sym_SQUOTE] = ACTIONS(81),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(905),
    [sym_number] = ACTIONS(907),
    [sym_this] = ACTIONS(909),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(911),
    [sym_false] = ACTIONS(911),
    [sym_null] = ACTIONS(911),
    [sym_undefined] = ACTIONS(913),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(877),
    [anon_sym_readonly] = ACTIONS(915),
    [anon_sym_get] = ACTIONS(877),
    [anon_sym_set] = ACTIONS(877),
    [anon_sym_QMARK] = ACTIONS(583),
    [anon_sym_declare] = ACTIONS(877),
    [anon_sym_public] = ACTIONS(877),
    [anon_sym_private] = ACTIONS(877),
    [anon_sym_protected] = ACTIONS(877),
    [anon_sym_override] = ACTIONS(877),
    [anon_sym_module] = ACTIONS(877),
    [anon_sym_any] = ACTIONS(917),
    [anon_sym_number] = ACTIONS(917),
    [anon_sym_boolean] = ACTIONS(917),
    [anon_sym_string] = ACTIONS(917),
    [anon_sym_symbol] = ACTIONS(917),
    [anon_sym_abstract] = ACTIONS(196),
    [anon_sym_infer] = ACTIONS(198),
    [anon_sym_keyof] = ACTIONS(200),
    [anon_sym_unknown] = ACTIONS(202),
    [anon_sym_never] = ACTIONS(202),
    [anon_sym_object] = ACTIONS(202),
    [anon_sym_LBRACE_PIPE] = ACTIONS(204),
  },
  [81] = {
    [sym_import] = STATE(1405),
    [sym_parenthesized_expression] = STATE(1152),
    [sym_expression] = STATE(1891),
    [sym_primary_expression] = STATE(1404),
    [sym_yield_expression] = STATE(1403),
    [sym_object] = STATE(1405),
    [sym_object_pattern] = STATE(4099),
    [sym_array] = STATE(1405),
    [sym_array_pattern] = STATE(4099),
    [sym_nested_identifier] = STATE(4074),
    [sym_class] = STATE(1405),
    [sym_function] = STATE(1405),
    [sym_generator_function] = STATE(1405),
    [sym_arrow_function] = STATE(1405),
    [sym__call_signature] = STATE(3883),
    [sym_call_expression] = STATE(1405),
    [sym_new_expression] = STATE(1403),
    [sym_await_expression] = STATE(1403),
    [sym_member_expression] = STATE(1152),
    [sym_subscript_expression] = STATE(1152),
    [sym_assignment_expression] = STATE(1403),
    [sym__augmented_assignment_lhs] = STATE(2349),
    [sym_augmented_assignment_expression] = STATE(1403),
    [sym__destructuring_pattern] = STATE(4099),
    [sym_ternary_expression] = STATE(1403),
    [sym_binary_expression] = STATE(1403),
    [sym_unary_expression] = STATE(1403),
    [sym_update_expression] = STATE(1403),
    [sym_string] = STATE(1822),
    [sym_template_string] = STATE(1405),
    [sym_regex] = STATE(1405),
    [sym_meta_property] = STATE(1405),
    [sym_decorator] = STATE(1149),
    [sym_formal_parameters] = STATE(3260),
    [sym_non_null_expression] = STATE(1152),
    [sym_type_assertion] = STATE(1403),
    [sym_as_expression] = STATE(1403),
    [sym_internal_module] = STATE(1403),
    [sym_nested_type_identifier] = STATE(2336),
    [sym__type] = STATE(2859),
    [sym_constructor_type] = STATE(2859),
    [sym__primary_type] = STATE(2373),
    [sym_template_literal_type] = STATE(2359),
    [sym_infer_type] = STATE(2859),
    [sym_conditional_type] = STATE(2359),
    [sym_generic_type] = STATE(2359),
    [sym_type_query] = STATE(2359),
    [sym_index_type_query] = STATE(2359),
    [sym_lookup_type] = STATE(2359),
    [sym_literal_type] = STATE(2359),
    [sym__number] = STATE(2355),
    [sym_existential_type] = STATE(2359),
    [sym_flow_maybe_type] = STATE(2359),
    [sym_parenthesized_type] = STATE(2359),
    [sym_predefined_type] = STATE(2359),
    [sym_type_arguments] = STATE(476),
    [sym_object_type] = STATE(2359),
    [sym_type_parameters] = STATE(3839),
    [sym_array_type] = STATE(2359),
    [sym_tuple_type] = STATE(2359),
    [sym_readonly_type] = STATE(2859),
    [sym_union_type] = STATE(2359),
    [sym_intersection_type] = STATE(2359),
    [sym_function_type] = STATE(2859),
    [aux_sym_export_statement_repeat1] = STATE(3368),
    [sym_identifier] = ACTIONS(919),
    [anon_sym_export] = ACTIONS(921),
    [anon_sym_STAR] = ACTIONS(537),
    [anon_sym_type] = ACTIONS(921),
    [anon_sym_namespace] = ACTIONS(923),
    [anon_sym_LBRACE] = ACTIONS(925),
    [anon_sym_typeof] = ACTIONS(927),
    [anon_sym_import] = ACTIONS(125),
    [anon_sym_BANG] = ACTIONS(929),
    [anon_sym_LPAREN] = ACTIONS(130),
    [anon_sym_await] = ACTIONS(931),
    [anon_sym_yield] = ACTIONS(933),
    [anon_sym_LBRACK] = ACTIONS(833),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(557),
    [anon_sym_class] = ACTIONS(143),
    [anon_sym_async] = ACTIONS(935),
    [anon_sym_function] = ACTIONS(147),
    [anon_sym_new] = ACTIONS(937),
    [anon_sym_AMP] = ACTIONS(565),
    [anon_sym_PIPE] = ACTIONS(567),
    [anon_sym_PLUS] = ACTIONS(939),
    [anon_sym_DASH] = ACTIONS(939),
    [anon_sym_TILDE] = ACTIONS(929),
    [anon_sym_void] = ACTIONS(941),
    [anon_sym_delete] = ACTIONS(943),
    [anon_sym_PLUS_PLUS] = ACTIONS(945),
    [anon_sym_DASH_DASH] = ACTIONS(945),
    [anon_sym_DQUOTE] = ACTIONS(174),
    [anon_sym_SQUOTE] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(839),
    [sym_number] = ACTIONS(841),
    [sym_this] = ACTIONS(843),
    [sym_super] = ACTIONS(184),
    [sym_true] = ACTIONS(845),
    [sym_false] = ACTIONS(845),
    [sym_null] = ACTIONS(845),
    [sym_undefined] = ACTIONS(947),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(921),
    [anon_sym_readonly] = ACTIONS(949),
    [anon_sym_get] = ACTIONS(921),
    [anon_sym_set] = ACTIONS(921),
    [anon_sym_QMARK] = ACTIONS(583),
    [anon_sym_declare] = ACTIONS(921),
    [anon_sym_public] = ACTIONS(921),
    [anon_sym_private] = ACTIONS(921),
    [anon_sym_protected] = ACTIONS(921),
    [anon_sym_override] = ACTIONS(921),
    [anon_sym_module] = ACTIONS(921),
    [anon_sym_any] = ACTIONS(951),
    [anon_sym_number] = ACTIONS(951),
    [anon_sym_boolean] = ACTIONS(951),
    [anon_sym_string] = ACTIONS(951),
    [anon_sym_symbol] = ACTIONS(951),
    [anon_sym_abstract] = ACTIONS(196),
    [anon_sym_infer] = ACTIONS(198),
    [anon_sym_keyof] = ACTIONS(200),
    [anon_sym_unknown] = ACTIONS(202),
    [anon_sym_never] = ACTIONS(202),
    [anon_sym_object] = ACTIONS(202),
    [anon_sym_LBRACE_PIPE] = ACTIONS(204),
  },
  [82] = {
    [sym_import] = STATE(1405),
    [sym_parenthesized_expression] = STATE(1125),
    [sym_expression] = STATE(1630),
    [sym_primary_expression] = STATE(1404),
    [sym_yield_expression] = STATE(1403),
    [sym_object] = STATE(1405),
    [sym_object_pattern] = STATE(4142),
    [sym_array] = STATE(1405),
    [sym_array_pattern] = STATE(4142),
    [sym_nested_identifier] = STATE(4074),
    [sym_class] = STATE(1405),
    [sym_function] = STATE(1405),
    [sym_generator_function] = STATE(1405),
    [sym_arrow_function] = STATE(1405),
    [sym__call_signature] = STATE(4097),
    [sym_call_expression] = STATE(1405),
    [sym_new_expression] = STATE(1403),
    [sym_await_expression] = STATE(1403),
    [sym_member_expression] = STATE(1125),
    [sym_subscript_expression] = STATE(1125),
    [sym_assignment_expression] = STATE(1403),
    [sym__augmented_assignment_lhs] = STATE(2361),
    [sym_augmented_assignment_expression] = STATE(1403),
    [sym__destructuring_pattern] = STATE(4142),
    [sym_ternary_expression] = STATE(1403),
    [sym_binary_expression] = STATE(1403),
    [sym_unary_expression] = STATE(1403),
    [sym_update_expression] = STATE(1403),
    [sym_string] = STATE(1352),
    [sym_template_string] = STATE(1405),
    [sym_regex] = STATE(1405),
    [sym_meta_property] = STATE(1405),
    [sym_decorator] = STATE(1149),
    [sym_formal_parameters] = STATE(3260),
    [sym_non_null_expression] = STATE(1125),
    [sym_type_assertion] = STATE(1403),
    [sym_as_expression] = STATE(1403),
    [sym_internal_module] = STATE(1403),
    [sym_nested_type_identifier] = STATE(2336),
    [sym__type] = STATE(2859),
    [sym_constructor_type] = STATE(2859),
    [sym__primary_type] = STATE(2373),
    [sym_template_literal_type] = STATE(2359),
    [sym_infer_type] = STATE(2859),
    [sym_conditional_type] = STATE(2359),
    [sym_generic_type] = STATE(2359),
    [sym_type_query] = STATE(2359),
    [sym_index_type_query] = STATE(2359),
    [sym_lookup_type] = STATE(2359),
    [sym_literal_type] = STATE(2359),
    [sym__number] = STATE(2355),
    [sym_existential_type] = STATE(2359),
    [sym_flow_maybe_type] = STATE(2359),
    [sym_parenthesized_type] = STATE(2359),
    [sym_predefined_type] = STATE(2359),
    [sym_type_arguments] = STATE(338),
    [sym_object_type] = STATE(2359),
    [sym_type_parameters] = STATE(3839),
    [sym_array_type] = STATE(2359),
    [sym_tuple_type] = STATE(2359),
    [sym_readonly_type] = STATE(2859),
    [sym_union_type] = STATE(2359),
    [sym_intersection_type] = STATE(2359),
    [sym_function_type] = STATE(2859),
    [aux_sym_export_statement_repeat1] = STATE(3368),
    [sym_identifier] = ACTIONS(953),
    [anon_sym_export] = ACTIONS(955),
    [anon_sym_STAR] = ACTIONS(537),
    [anon_sym_type] = ACTIONS(955),
    [anon_sym_namespace] = ACTIONS(957),
    [anon_sym_LBRACE] = ACTIONS(959),
    [anon_sym_typeof] = ACTIONS(961),
    [anon_sym_import] = ACTIONS(125),
    [anon_sym_BANG] = ACTIONS(963),
    [anon_sym_LPAREN] = ACTIONS(130),
    [anon_sym_await] = ACTIONS(965),
    [anon_sym_yield] = ACTIONS(967),
    [anon_sym_LBRACK] = ACTIONS(969),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(971),
    [anon_sym_class] = ACTIONS(143),
    [anon_sym_async] = ACTIONS(973),
    [anon_sym_function] = ACTIONS(147),
    [anon_sym_new] = ACTIONS(975),
    [anon_sym_AMP] = ACTIONS(565),
    [anon_sym_PIPE] = ACTIONS(567),
    [anon_sym_PLUS] = ACTIONS(977),
    [anon_sym_DASH] = ACTIONS(977),
    [anon_sym_TILDE] = ACTIONS(963),
    [anon_sym_void] = ACTIONS(979),
    [anon_sym_delete] = ACTIONS(981),
    [anon_sym_PLUS_PLUS] = ACTIONS(983),
    [anon_sym_DASH_DASH] = ACTIONS(983),
    [anon_sym_DQUOTE] = ACTIONS(174),
    [anon_sym_SQUOTE] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(985),
    [sym_number] = ACTIONS(987),
    [sym_this] = ACTIONS(989),
    [sym_super] = ACTIONS(184),
    [sym_true] = ACTIONS(991),
    [sym_false] = ACTIONS(991),
    [sym_null] = ACTIONS(991),
    [sym_undefined] = ACTIONS(993),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(955),
    [anon_sym_readonly] = ACTIONS(995),
    [anon_sym_get] = ACTIONS(955),
    [anon_sym_set] = ACTIONS(955),
    [anon_sym_QMARK] = ACTIONS(583),
    [anon_sym_declare] = ACTIONS(955),
    [anon_sym_public] = ACTIONS(955),
    [anon_sym_private] = ACTIONS(955),
    [anon_sym_protected] = ACTIONS(955),
    [anon_sym_override] = ACTIONS(955),
    [anon_sym_module] = ACTIONS(955),
    [anon_sym_any] = ACTIONS(997),
    [anon_sym_number] = ACTIONS(997),
    [anon_sym_boolean] = ACTIONS(997),
    [anon_sym_string] = ACTIONS(997),
    [anon_sym_symbol] = ACTIONS(997),
    [anon_sym_abstract] = ACTIONS(196),
    [anon_sym_infer] = ACTIONS(198),
    [anon_sym_keyof] = ACTIONS(200),
    [anon_sym_unknown] = ACTIONS(202),
    [anon_sym_never] = ACTIONS(202),
    [anon_sym_object] = ACTIONS(202),
    [anon_sym_LBRACE_PIPE] = ACTIONS(204),
  },
  [83] = {
    [sym_import] = STATE(1405),
    [sym_parenthesized_expression] = STATE(1072),
    [sym_expression] = STATE(1409),
    [sym_primary_expression] = STATE(1404),
    [sym_yield_expression] = STATE(1403),
    [sym_object] = STATE(1405),
    [sym_object_pattern] = STATE(4013),
    [sym_array] = STATE(1405),
    [sym_array_pattern] = STATE(4013),
    [sym_nested_identifier] = STATE(4074),
    [sym_class] = STATE(1405),
    [sym_function] = STATE(1405),
    [sym_generator_function] = STATE(1405),
    [sym_arrow_function] = STATE(1405),
    [sym__call_signature] = STATE(4121),
    [sym_call_expression] = STATE(1405),
    [sym_new_expression] = STATE(1403),
    [sym_await_expression] = STATE(1403),
    [sym_member_expression] = STATE(1072),
    [sym_subscript_expression] = STATE(1072),
    [sym_assignment_expression] = STATE(1403),
    [sym__augmented_assignment_lhs] = STATE(2344),
    [sym_augmented_assignment_expression] = STATE(1403),
    [sym__destructuring_pattern] = STATE(4013),
    [sym_ternary_expression] = STATE(1403),
    [sym_binary_expression] = STATE(1403),
    [sym_unary_expression] = STATE(1403),
    [sym_update_expression] = STATE(1403),
    [sym_string] = STATE(1352),
    [sym_template_string] = STATE(1405),
    [sym_regex] = STATE(1405),
    [sym_meta_property] = STATE(1405),
    [sym_decorator] = STATE(1149),
    [sym_formal_parameters] = STATE(3260),
    [sym_non_null_expression] = STATE(1072),
    [sym_type_assertion] = STATE(1403),
    [sym_as_expression] = STATE(1403),
    [sym_internal_module] = STATE(1403),
    [sym_nested_type_identifier] = STATE(2336),
    [sym__type] = STATE(2859),
    [sym_constructor_type] = STATE(2859),
    [sym__primary_type] = STATE(2373),
    [sym_template_literal_type] = STATE(2359),
    [sym_infer_type] = STATE(2859),
    [sym_conditional_type] = STATE(2359),
    [sym_generic_type] = STATE(2359),
    [sym_type_query] = STATE(2359),
    [sym_index_type_query] = STATE(2359),
    [sym_lookup_type] = STATE(2359),
    [sym_literal_type] = STATE(2359),
    [sym__number] = STATE(2355),
    [sym_existential_type] = STATE(2359),
    [sym_flow_maybe_type] = STATE(2359),
    [sym_parenthesized_type] = STATE(2359),
    [sym_predefined_type] = STATE(2359),
    [sym_type_arguments] = STATE(502),
    [sym_object_type] = STATE(2359),
    [sym_type_parameters] = STATE(3839),
    [sym_array_type] = STATE(2359),
    [sym_tuple_type] = STATE(2359),
    [sym_readonly_type] = STATE(2859),
    [sym_union_type] = STATE(2359),
    [sym_intersection_type] = STATE(2359),
    [sym_function_type] = STATE(2859),
    [aux_sym_export_statement_repeat1] = STATE(3368),
    [sym_identifier] = ACTIONS(999),
    [anon_sym_export] = ACTIONS(735),
    [anon_sym_STAR] = ACTIONS(537),
    [anon_sym_type] = ACTIONS(735),
    [anon_sym_namespace] = ACTIONS(737),
    [anon_sym_LBRACE] = ACTIONS(959),
    [anon_sym_typeof] = ACTIONS(1001),
    [anon_sym_import] = ACTIONS(125),
    [anon_sym_BANG] = ACTIONS(547),
    [anon_sym_LPAREN] = ACTIONS(130),
    [anon_sym_await] = ACTIONS(549),
    [anon_sym_yield] = ACTIONS(551),
    [anon_sym_LBRACK] = ACTIONS(969),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(557),
    [anon_sym_class] = ACTIONS(143),
    [anon_sym_async] = ACTIONS(743),
    [anon_sym_function] = ACTIONS(147),
    [anon_sym_new] = ACTIONS(561),
    [anon_sym_AMP] = ACTIONS(565),
    [anon_sym_PIPE] = ACTIONS(567),
    [anon_sym_PLUS] = ACTIONS(1003),
    [anon_sym_DASH] = ACTIONS(1003),
    [anon_sym_TILDE] = ACTIONS(547),
    [anon_sym_void] = ACTIONS(571),
    [anon_sym_delete] = ACTIONS(573),
    [anon_sym_PLUS_PLUS] = ACTIONS(575),
    [anon_sym_DASH_DASH] = ACTIONS(575),
    [anon_sym_DQUOTE] = ACTIONS(174),
    [anon_sym_SQUOTE] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(985),
    [sym_number] = ACTIONS(987),
    [sym_this] = ACTIONS(989),
    [sym_super] = ACTIONS(184),
    [sym_true] = ACTIONS(991),
    [sym_false] = ACTIONS(991),
    [sym_null] = ACTIONS(991),
    [sym_undefined] = ACTIONS(1005),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(735),
    [anon_sym_readonly] = ACTIONS(749),
    [anon_sym_get] = ACTIONS(735),
    [anon_sym_set] = ACTIONS(735),
    [anon_sym_QMARK] = ACTIONS(583),
    [anon_sym_declare] = ACTIONS(735),
    [anon_sym_public] = ACTIONS(735),
    [anon_sym_private] = ACTIONS(735),
    [anon_sym_protected] = ACTIONS(735),
    [anon_sym_override] = ACTIONS(735),
    [anon_sym_module] = ACTIONS(735),
    [anon_sym_any] = ACTIONS(1007),
    [anon_sym_number] = ACTIONS(1007),
    [anon_sym_boolean] = ACTIONS(1007),
    [anon_sym_string] = ACTIONS(1007),
    [anon_sym_symbol] = ACTIONS(1007),
    [anon_sym_abstract] = ACTIONS(196),
    [anon_sym_infer] = ACTIONS(198),
    [anon_sym_keyof] = ACTIONS(200),
    [anon_sym_unknown] = ACTIONS(202),
    [anon_sym_never] = ACTIONS(202),
    [anon_sym_object] = ACTIONS(202),
    [anon_sym_LBRACE_PIPE] = ACTIONS(204),
  },
  [84] = {
    [sym_import] = STATE(1405),
    [sym_parenthesized_expression] = STATE(1023),
    [sym_expression] = STATE(2015),
    [sym_primary_expression] = STATE(1404),
    [sym_yield_expression] = STATE(1403),
    [sym_object] = STATE(1405),
    [sym_object_pattern] = STATE(2742),
    [sym_array] = STATE(1405),
    [sym_array_pattern] = STATE(2742),
    [sym_nested_identifier] = STATE(4074),
    [sym_class] = STATE(1405),
    [sym_function] = STATE(1405),
    [sym_generator_function] = STATE(1405),
    [sym_arrow_function] = STATE(1405),
    [sym__call_signature] = STATE(4016),
    [sym_call_expression] = STATE(1405),
    [sym_new_expression] = STATE(1403),
    [sym_await_expression] = STATE(1403),
    [sym_member_expression] = STATE(1158),
    [sym_subscript_expression] = STATE(1158),
    [sym_assignment_expression] = STATE(1403),
    [sym__augmented_assignment_lhs] = STATE(2340),
    [sym_augmented_assignment_expression] = STATE(1403),
    [sym__destructuring_pattern] = STATE(2742),
    [sym_ternary_expression] = STATE(1403),
    [sym_binary_expression] = STATE(1403),
    [sym_unary_expression] = STATE(1403),
    [sym_update_expression] = STATE(1403),
    [sym_string] = STATE(2034),
    [sym_template_string] = STATE(1405),
    [sym_regex] = STATE(1405),
    [sym_meta_property] = STATE(1405),
    [sym_decorator] = STATE(1149),
    [sym_formal_parameters] = STATE(3260),
    [sym_non_null_expression] = STATE(1158),
    [sym_type_assertion] = STATE(1403),
    [sym_as_expression] = STATE(1403),
    [sym_internal_module] = STATE(1403),
    [sym_nested_type_identifier] = STATE(2336),
    [sym__type] = STATE(3198),
    [sym_constructor_type] = STATE(3198),
    [sym__primary_type] = STATE(2373),
    [sym_template_literal_type] = STATE(2359),
    [sym_infer_type] = STATE(3198),
    [sym_conditional_type] = STATE(2359),
    [sym_generic_type] = STATE(2359),
    [sym_type_query] = STATE(2359),
    [sym_index_type_query] = STATE(2359),
    [sym_lookup_type] = STATE(2359),
    [sym_literal_type] = STATE(2359),
    [sym__number] = STATE(2355),
    [sym_existential_type] = STATE(2359),
    [sym_flow_maybe_type] = STATE(2359),
    [sym_parenthesized_type] = STATE(2359),
    [sym_predefined_type] = STATE(2359),
    [sym_type_arguments] = STATE(519),
    [sym_object_type] = STATE(2359),
    [sym_type_parameters] = STATE(3839),
    [sym_array_type] = STATE(2359),
    [sym_tuple_type] = STATE(2359),
    [sym_readonly_type] = STATE(3198),
    [sym_union_type] = STATE(2359),
    [sym_intersection_type] = STATE(2359),
    [sym_function_type] = STATE(3198),
    [aux_sym_export_statement_repeat1] = STATE(3368),
    [sym_identifier] = ACTIONS(1009),
    [anon_sym_export] = ACTIONS(1011),
    [anon_sym_STAR] = ACTIONS(537),
    [anon_sym_type] = ACTIONS(1011),
    [anon_sym_namespace] = ACTIONS(1013),
    [anon_sym_LBRACE] = ACTIONS(1015),
    [anon_sym_typeof] = ACTIONS(1017),
    [anon_sym_import] = ACTIONS(125),
    [anon_sym_BANG] = ACTIONS(165),
    [anon_sym_LPAREN] = ACTIONS(130),
    [anon_sym_await] = ACTIONS(132),
    [anon_sym_yield] = ACTIONS(134),
    [anon_sym_LBRACK] = ACTIONS(1019),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(557),
    [anon_sym_class] = ACTIONS(143),
    [anon_sym_async] = ACTIONS(1021),
    [anon_sym_function] = ACTIONS(147),
    [anon_sym_new] = ACTIONS(153),
    [anon_sym_AMP] = ACTIONS(565),
    [anon_sym_PIPE] = ACTIONS(567),
    [anon_sym_PLUS] = ACTIONS(1023),
    [anon_sym_DASH] = ACTIONS(1023),
    [anon_sym_TILDE] = ACTIONS(165),
    [anon_sym_void] = ACTIONS(167),
    [anon_sym_delete] = ACTIONS(169),
    [anon_sym_PLUS_PLUS] = ACTIONS(675),
    [anon_sym_DASH_DASH] = ACTIONS(675),
    [anon_sym_DQUOTE] = ACTIONS(174),
    [anon_sym_SQUOTE] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(1025),
    [sym_number] = ACTIONS(1027),
    [sym_this] = ACTIONS(1029),
    [sym_super] = ACTIONS(184),
    [sym_true] = ACTIONS(1031),
    [sym_false] = ACTIONS(1031),
    [sym_null] = ACTIONS(1031),
    [sym_undefined] = ACTIONS(1033),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(1011),
    [anon_sym_readonly] = ACTIONS(1035),
    [anon_sym_get] = ACTIONS(1011),
    [anon_sym_set] = ACTIONS(1011),
    [anon_sym_QMARK] = ACTIONS(583),
    [anon_sym_declare] = ACTIONS(1011),
    [anon_sym_public] = ACTIONS(1011),
    [anon_sym_private] = ACTIONS(1011),
    [anon_sym_protected] = ACTIONS(1011),
    [anon_sym_override] = ACTIONS(1011),
    [anon_sym_module] = ACTIONS(1011),
    [anon_sym_any] = ACTIONS(1037),
    [anon_sym_number] = ACTIONS(1037),
    [anon_sym_boolean] = ACTIONS(1037),
    [anon_sym_string] = ACTIONS(1037),
    [anon_sym_symbol] = ACTIONS(1037),
    [anon_sym_abstract] = ACTIONS(196),
    [anon_sym_infer] = ACTIONS(198),
    [anon_sym_keyof] = ACTIONS(200),
    [anon_sym_unknown] = ACTIONS(202),
    [anon_sym_never] = ACTIONS(202),
    [anon_sym_object] = ACTIONS(202),
    [anon_sym_LBRACE_PIPE] = ACTIONS(204),
  },
  [85] = {
    [sym_import] = STATE(1405),
    [sym_parenthesized_expression] = STATE(1159),
    [sym_expression] = STATE(1939),
    [sym_primary_expression] = STATE(1404),
    [sym_yield_expression] = STATE(1403),
    [sym_object] = STATE(1405),
    [sym_object_pattern] = STATE(4173),
    [sym_array] = STATE(1405),
    [sym_array_pattern] = STATE(4173),
    [sym_nested_identifier] = STATE(4074),
    [sym_class] = STATE(1405),
    [sym_function] = STATE(1405),
    [sym_generator_function] = STATE(1405),
    [sym_arrow_function] = STATE(1405),
    [sym__call_signature] = STATE(3938),
    [sym_call_expression] = STATE(1405),
    [sym_new_expression] = STATE(1403),
    [sym_await_expression] = STATE(1403),
    [sym_member_expression] = STATE(1159),
    [sym_subscript_expression] = STATE(1159),
    [sym_assignment_expression] = STATE(1403),
    [sym__augmented_assignment_lhs] = STATE(2350),
    [sym_augmented_assignment_expression] = STATE(1403),
    [sym__destructuring_pattern] = STATE(4173),
    [sym_ternary_expression] = STATE(1403),
    [sym_binary_expression] = STATE(1403),
    [sym_unary_expression] = STATE(1403),
    [sym_update_expression] = STATE(1403),
    [sym_string] = STATE(1822),
    [sym_template_string] = STATE(1405),
    [sym_regex] = STATE(1405),
    [sym_meta_property] = STATE(1405),
    [sym_decorator] = STATE(1149),
    [sym_formal_parameters] = STATE(3260),
    [sym_non_null_expression] = STATE(1159),
    [sym_type_assertion] = STATE(1403),
    [sym_as_expression] = STATE(1403),
    [sym_internal_module] = STATE(1403),
    [sym_nested_type_identifier] = STATE(2336),
    [sym__type] = STATE(2859),
    [sym_constructor_type] = STATE(2859),
    [sym__primary_type] = STATE(2373),
    [sym_template_literal_type] = STATE(2359),
    [sym_infer_type] = STATE(2859),
    [sym_conditional_type] = STATE(2359),
    [sym_generic_type] = STATE(2359),
    [sym_type_query] = STATE(2359),
    [sym_index_type_query] = STATE(2359),
    [sym_lookup_type] = STATE(2359),
    [sym_literal_type] = STATE(2359),
    [sym__number] = STATE(2355),
    [sym_existential_type] = STATE(2359),
    [sym_flow_maybe_type] = STATE(2359),
    [sym_parenthesized_type] = STATE(2359),
    [sym_predefined_type] = STATE(2359),
    [sym_type_arguments] = STATE(421),
    [sym_object_type] = STATE(2359),
    [sym_type_parameters] = STATE(3839),
    [sym_array_type] = STATE(2359),
    [sym_tuple_type] = STATE(2359),
    [sym_readonly_type] = STATE(2859),
    [sym_union_type] = STATE(2359),
    [sym_intersection_type] = STATE(2359),
    [sym_function_type] = STATE(2859),
    [aux_sym_export_statement_repeat1] = STATE(3368),
    [sym_identifier] = ACTIONS(1039),
    [anon_sym_export] = ACTIONS(1041),
    [anon_sym_STAR] = ACTIONS(537),
    [anon_sym_type] = ACTIONS(1041),
    [anon_sym_namespace] = ACTIONS(1043),
    [anon_sym_LBRACE] = ACTIONS(829),
    [anon_sym_typeof] = ACTIONS(1045),
    [anon_sym_import] = ACTIONS(125),
    [anon_sym_BANG] = ACTIONS(1047),
    [anon_sym_LPAREN] = ACTIONS(130),
    [anon_sym_await] = ACTIONS(1049),
    [anon_sym_yield] = ACTIONS(1051),
    [anon_sym_LBRACK] = ACTIONS(833),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(1053),
    [anon_sym_class] = ACTIONS(143),
    [anon_sym_async] = ACTIONS(1055),
    [anon_sym_function] = ACTIONS(147),
    [anon_sym_new] = ACTIONS(1057),
    [anon_sym_AMP] = ACTIONS(565),
    [anon_sym_PIPE] = ACTIONS(567),
    [anon_sym_PLUS] = ACTIONS(1059),
    [anon_sym_DASH] = ACTIONS(1059),
    [anon_sym_TILDE] = ACTIONS(1047),
    [anon_sym_void] = ACTIONS(1061),
    [anon_sym_delete] = ACTIONS(1063),
    [anon_sym_PLUS_PLUS] = ACTIONS(1065),
    [anon_sym_DASH_DASH] = ACTIONS(1065),
    [anon_sym_DQUOTE] = ACTIONS(174),
    [anon_sym_SQUOTE] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(839),
    [sym_number] = ACTIONS(841),
    [sym_this] = ACTIONS(843),
    [sym_super] = ACTIONS(184),
    [sym_true] = ACTIONS(845),
    [sym_false] = ACTIONS(845),
    [sym_null] = ACTIONS(845),
    [sym_undefined] = ACTIONS(1067),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(1041),
    [anon_sym_readonly] = ACTIONS(1069),
    [anon_sym_get] = ACTIONS(1041),
    [anon_sym_set] = ACTIONS(1041),
    [anon_sym_QMARK] = ACTIONS(583),
    [anon_sym_declare] = ACTIONS(1041),
    [anon_sym_public] = ACTIONS(1041),
    [anon_sym_private] = ACTIONS(1041),
    [anon_sym_protected] = ACTIONS(1041),
    [anon_sym_override] = ACTIONS(1041),
    [anon_sym_module] = ACTIONS(1041),
    [anon_sym_any] = ACTIONS(1071),
    [anon_sym_number] = ACTIONS(1071),
    [anon_sym_boolean] = ACTIONS(1071),
    [anon_sym_string] = ACTIONS(1071),
    [anon_sym_symbol] = ACTIONS(1071),
    [anon_sym_abstract] = ACTIONS(196),
    [anon_sym_infer] = ACTIONS(198),
    [anon_sym_keyof] = ACTIONS(200),
    [anon_sym_unknown] = ACTIONS(202),
    [anon_sym_never] = ACTIONS(202),
    [anon_sym_object] = ACTIONS(202),
    [anon_sym_LBRACE_PIPE] = ACTIONS(204),
  },
  [86] = {
    [sym_import] = STATE(1405),
    [sym_parenthesized_expression] = STATE(1072),
    [sym_expression] = STATE(1386),
    [sym_primary_expression] = STATE(1404),
    [sym_yield_expression] = STATE(1403),
    [sym_object] = STATE(1405),
    [sym_object_pattern] = STATE(4013),
    [sym_array] = STATE(1405),
    [sym_array_pattern] = STATE(4013),
    [sym_class] = STATE(1405),
    [sym_function] = STATE(1405),
    [sym_generator_function] = STATE(1405),
    [sym_arrow_function] = STATE(1405),
    [sym__call_signature] = STATE(4121),
    [sym_call_expression] = STATE(1405),
    [sym_new_expression] = STATE(1403),
    [sym_await_expression] = STATE(1403),
    [sym_member_expression] = STATE(1072),
    [sym_subscript_expression] = STATE(1072),
    [sym_assignment_expression] = STATE(1403),
    [sym__augmented_assignment_lhs] = STATE(2344),
    [sym_augmented_assignment_expression] = STATE(1403),
    [sym__destructuring_pattern] = STATE(4013),
    [sym_ternary_expression] = STATE(1403),
    [sym_binary_expression] = STATE(1403),
    [sym_unary_expression] = STATE(1403),
    [sym_update_expression] = STATE(1403),
    [sym_string] = STATE(1405),
    [sym_template_string] = STATE(1405),
    [sym_regex] = STATE(1405),
    [sym_meta_property] = STATE(1405),
    [sym_decorator] = STATE(1149),
    [sym_formal_parameters] = STATE(2903),
    [sym_non_null_expression] = STATE(1072),
    [sym_type_assertion] = STATE(1403),
    [sym_as_expression] = STATE(1403),
    [sym_internal_module] = STATE(1403),
    [sym_type_arguments] = STATE(502),
    [sym_type_parameters] = STATE(3670),
    [aux_sym_export_statement_repeat1] = STATE(3368),
    [sym_identifier] = ACTIONS(1073),
    [anon_sym_export] = ACTIONS(735),
    [anon_sym_STAR] = ACTIONS(1075),
    [anon_sym_type] = ACTIONS(735),
    [anon_sym_as] = ACTIONS(1077),
    [anon_sym_namespace] = ACTIONS(737),
    [anon_sym_LBRACE] = ACTIONS(1079),
    [anon_sym_COMMA] = ACTIONS(1081),
    [anon_sym_RBRACE] = ACTIONS(1081),
    [anon_sym_typeof] = ACTIONS(573),
    [anon_sym_import] = ACTIONS(125),
    [anon_sym_BANG] = ACTIONS(573),
    [anon_sym_LPAREN] = ACTIONS(1083),
    [anon_sym_RPAREN] = ACTIONS(1081),
    [anon_sym_await] = ACTIONS(549),
    [anon_sym_in] = ACTIONS(1077),
    [anon_sym_COLON] = ACTIONS(1081),
    [anon_sym_yield] = ACTIONS(551),
    [anon_sym_LBRACK] = ACTIONS(1085),
    [anon_sym_RBRACK] = ACTIONS(1081),
    [anon_sym_LT] = ACTIONS(138),
    [anon_sym_GT] = ACTIONS(1077),
    [anon_sym_SLASH] = ACTIONS(557),
    [anon_sym_DOT] = ACTIONS(1077),
    [anon_sym_class] = ACTIONS(143),
    [anon_sym_async] = ACTIONS(743),
    [anon_sym_function] = ACTIONS(147),
    [anon_sym_QMARK_DOT] = ACTIONS(1081),
    [anon_sym_new] = ACTIONS(1087),
    [anon_sym_AMP_AMP] = ACTIONS(1081),
    [anon_sym_PIPE_PIPE] = ACTIONS(1081),
    [anon_sym_GT_GT] = ACTIONS(1077),
    [anon_sym_GT_GT_GT] = ACTIONS(1081),
    [anon_sym_LT_LT] = ACTIONS(1081),
    [anon_sym_AMP] = ACTIONS(1077),
    [anon_sym_CARET] = ACTIONS(1081),
    [anon_sym_PIPE] = ACTIONS(1077),
    [anon_sym_PLUS] = ACTIONS(573),
    [anon_sym_DASH] = ACTIONS(573),
    [anon_sym_PERCENT] = ACTIONS(1081),
    [anon_sym_STAR_STAR] = ACTIONS(1081),
    [anon_sym_LT_EQ] = ACTIONS(1081),
    [anon_sym_EQ_EQ] = ACTIONS(1077),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(1081),
    [anon_sym_BANG_EQ] = ACTIONS(1077),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(1081),
    [anon_sym_GT_EQ] = ACTIONS(1081),
    [anon_sym_QMARK_QMARK] = ACTIONS(1081),
    [anon_sym_instanceof] = ACTIONS(1077),
    [anon_sym_TILDE] = ACTIONS(547),
    [anon_sym_void] = ACTIONS(573),
    [anon_sym_delete] = ACTIONS(573),
    [anon_sym_PLUS_PLUS] = ACTIONS(575),
    [anon_sym_DASH_DASH] = ACTIONS(575),
    [anon_sym_DQUOTE] = ACTIONS(174),
    [anon_sym_SQUOTE] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(1089),
    [sym_number] = ACTIONS(625),
    [sym_this] = ACTIONS(184),
    [sym_super] = ACTIONS(184),
    [sym_true] = ACTIONS(184),
    [sym_false] = ACTIONS(184),
    [sym_null] = ACTIONS(184),
    [sym_undefined] = ACTIONS(1091),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(735),
    [anon_sym_readonly] = ACTIONS(735),
    [anon_sym_get] = ACTIONS(735),
    [anon_sym_set] = ACTIONS(735),
    [anon_sym_declare] = ACTIONS(735),
    [anon_sym_public] = ACTIONS(735),
    [anon_sym_private] = ACTIONS(735),
    [anon_sym_protected] = ACTIONS(735),
    [anon_sym_override] = ACTIONS(735),
    [anon_sym_module] = ACTIONS(735),
    [anon_sym_any] = ACTIONS(735),
    [anon_sym_number] = ACTIONS(735),
    [anon_sym_boolean] = ACTIONS(735),
    [anon_sym_string] = ACTIONS(735),
    [anon_sym_symbol] = ACTIONS(735),
    [sym__ternary_qmark] = ACTIONS(1081),
  },
  [87] = {
    [sym_import] = STATE(1844),
    [sym_parenthesized_expression] = STATE(1120),
    [sym_expression] = STATE(1454),
    [sym_primary_expression] = STATE(1799),
    [sym_yield_expression] = STATE(1798),
    [sym_object] = STATE(1844),
    [sym_object_pattern] = STATE(4151),
    [sym_array] = STATE(1844),
    [sym_array_pattern] = STATE(4151),
    [sym_class] = STATE(1844),
    [sym_function] = STATE(1844),
    [sym_generator_function] = STATE(1844),
    [sym_arrow_function] = STATE(1844),
    [sym__call_signature] = STATE(4149),
    [sym_call_expression] = STATE(1844),
    [sym_new_expression] = STATE(1798),
    [sym_await_expression] = STATE(1798),
    [sym_member_expression] = STATE(1120),
    [sym_subscript_expression] = STATE(1120),
    [sym_assignment_expression] = STATE(1798),
    [sym__augmented_assignment_lhs] = STATE(2362),
    [sym_augmented_assignment_expression] = STATE(1798),
    [sym__destructuring_pattern] = STATE(4151),
    [sym_ternary_expression] = STATE(1798),
    [sym_binary_expression] = STATE(1798),
    [sym_unary_expression] = STATE(1798),
    [sym_update_expression] = STATE(1798),
    [sym_string] = STATE(1844),
    [sym_template_string] = STATE(1844),
    [sym_regex] = STATE(1844),
    [sym_meta_property] = STATE(1844),
    [sym_decorator] = STATE(1149),
    [sym_formal_parameters] = STATE(2903),
    [sym_non_null_expression] = STATE(1120),
    [sym_type_assertion] = STATE(1798),
    [sym_as_expression] = STATE(1798),
    [sym_internal_module] = STATE(1798),
    [sym_type_arguments] = STATE(344),
    [sym_type_parameters] = STATE(3670),
    [aux_sym_export_statement_repeat1] = STATE(3372),
    [sym_identifier] = ACTIONS(1093),
    [anon_sym_export] = ACTIONS(755),
    [anon_sym_STAR] = ACTIONS(1095),
    [anon_sym_type] = ACTIONS(755),
    [anon_sym_as] = ACTIONS(1077),
    [anon_sym_namespace] = ACTIONS(757),
    [anon_sym_LBRACE] = ACTIONS(1097),
    [anon_sym_COMMA] = ACTIONS(1081),
    [anon_sym_typeof] = ACTIONS(789),
    [anon_sym_import] = ACTIONS(763),
    [anon_sym_BANG] = ACTIONS(789),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_await] = ACTIONS(769),
    [anon_sym_in] = ACTIONS(1077),
    [anon_sym_of] = ACTIONS(1077),
    [anon_sym_SEMI] = ACTIONS(1081),
    [anon_sym_yield] = ACTIONS(771),
    [anon_sym_LBRACK] = ACTIONS(63),
    [anon_sym_LT] = ACTIONS(138),
    [anon_sym_GT] = ACTIONS(1077),
    [anon_sym_SLASH] = ACTIONS(775),
    [anon_sym_DOT] = ACTIONS(1077),
    [anon_sym_class] = ACTIONS(777),
    [anon_sym_async] = ACTIONS(779),
    [anon_sym_function] = ACTIONS(781),
    [anon_sym_QMARK_DOT] = ACTIONS(1081),
    [anon_sym_new] = ACTIONS(1099),
    [anon_sym_AMP_AMP] = ACTIONS(1081),
    [anon_sym_PIPE_PIPE] = ACTIONS(1081),
    [anon_sym_GT_GT] = ACTIONS(1077),
    [anon_sym_GT_GT_GT] = ACTIONS(1081),
    [anon_sym_LT_LT] = ACTIONS(1081),
    [anon_sym_AMP] = ACTIONS(1077),
    [anon_sym_CARET] = ACTIONS(1081),
    [anon_sym_PIPE] = ACTIONS(1077),
    [anon_sym_PLUS] = ACTIONS(789),
    [anon_sym_DASH] = ACTIONS(789),
    [anon_sym_PERCENT] = ACTIONS(1081),
    [anon_sym_STAR_STAR] = ACTIONS(1081),
    [anon_sym_LT_EQ] = ACTIONS(1081),
    [anon_sym_EQ_EQ] = ACTIONS(1077),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(1081),
    [anon_sym_BANG_EQ] = ACTIONS(1077),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(1081),
    [anon_sym_GT_EQ] = ACTIONS(1081),
    [anon_sym_QMARK_QMARK] = ACTIONS(1081),
    [anon_sym_instanceof] = ACTIONS(1077),
    [anon_sym_TILDE] = ACTIONS(765),
    [anon_sym_void] = ACTIONS(789),
    [anon_sym_delete] = ACTIONS(789),
    [anon_sym_PLUS_PLUS] = ACTIONS(791),
    [anon_sym_DASH_DASH] = ACTIONS(791),
    [anon_sym_DQUOTE] = ACTIONS(79),
    [anon_sym_SQUOTE] = ACTIONS(81),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(83),
    [sym_number] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(1101),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(755),
    [anon_sym_readonly] = ACTIONS(755),
    [anon_sym_get] = ACTIONS(755),
    [anon_sym_set] = ACTIONS(755),
    [anon_sym_declare] = ACTIONS(755),
    [anon_sym_public] = ACTIONS(755),
    [anon_sym_private] = ACTIONS(755),
    [anon_sym_protected] = ACTIONS(755),
    [anon_sym_override] = ACTIONS(755),
    [anon_sym_module] = ACTIONS(755),
    [anon_sym_any] = ACTIONS(755),
    [anon_sym_number] = ACTIONS(755),
    [anon_sym_boolean] = ACTIONS(755),
    [anon_sym_string] = ACTIONS(755),
    [anon_sym_symbol] = ACTIONS(755),
    [sym__automatic_semicolon] = ACTIONS(1081),
    [sym__ternary_qmark] = ACTIONS(1081),
  },
  [88] = {
    [sym_import] = STATE(1844),
    [sym_parenthesized_expression] = STATE(1116),
    [sym_expression] = STATE(1520),
    [sym_primary_expression] = STATE(1799),
    [sym_yield_expression] = STATE(1798),
    [sym_object] = STATE(1844),
    [sym_object_pattern] = STATE(4170),
    [sym_array] = STATE(1844),
    [sym_array_pattern] = STATE(4170),
    [sym_class] = STATE(1844),
    [sym_function] = STATE(1844),
    [sym_generator_function] = STATE(1844),
    [sym_arrow_function] = STATE(1844),
    [sym__call_signature] = STATE(4172),
    [sym_call_expression] = STATE(1844),
    [sym_new_expression] = STATE(1798),
    [sym_await_expression] = STATE(1798),
    [sym_member_expression] = STATE(1116),
    [sym_subscript_expression] = STATE(1116),
    [sym_assignment_expression] = STATE(1798),
    [sym__augmented_assignment_lhs] = STATE(2357),
    [sym_augmented_assignment_expression] = STATE(1798),
    [sym__destructuring_pattern] = STATE(4170),
    [sym_ternary_expression] = STATE(1798),
    [sym_binary_expression] = STATE(1798),
    [sym_unary_expression] = STATE(1798),
    [sym_update_expression] = STATE(1798),
    [sym_string] = STATE(1844),
    [sym_template_string] = STATE(1844),
    [sym_regex] = STATE(1844),
    [sym_meta_property] = STATE(1844),
    [sym_decorator] = STATE(1149),
    [sym_formal_parameters] = STATE(2903),
    [sym_non_null_expression] = STATE(1116),
    [sym_type_assertion] = STATE(1798),
    [sym_as_expression] = STATE(1798),
    [sym_internal_module] = STATE(1798),
    [sym_type_arguments] = STATE(482),
    [sym_type_parameters] = STATE(3670),
    [aux_sym_export_statement_repeat1] = STATE(3372),
    [sym_identifier] = ACTIONS(1103),
    [anon_sym_export] = ACTIONS(855),
    [anon_sym_STAR] = ACTIONS(1105),
    [anon_sym_type] = ACTIONS(855),
    [anon_sym_as] = ACTIONS(1077),
    [anon_sym_namespace] = ACTIONS(857),
    [anon_sym_LBRACE] = ACTIONS(1097),
    [anon_sym_COMMA] = ACTIONS(1081),
    [anon_sym_RBRACE] = ACTIONS(1081),
    [anon_sym_typeof] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(763),
    [anon_sym_BANG] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_await] = ACTIONS(39),
    [anon_sym_in] = ACTIONS(1077),
    [anon_sym_SEMI] = ACTIONS(1081),
    [anon_sym_yield] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(63),
    [anon_sym_LT] = ACTIONS(138),
    [anon_sym_GT] = ACTIONS(1077),
    [anon_sym_SLASH] = ACTIONS(67),
    [anon_sym_DOT] = ACTIONS(1077),
    [anon_sym_class] = ACTIONS(777),
    [anon_sym_async] = ACTIONS(861),
    [anon_sym_function] = ACTIONS(781),
    [anon_sym_QMARK_DOT] = ACTIONS(1081),
    [anon_sym_new] = ACTIONS(75),
    [anon_sym_AMP_AMP] = ACTIONS(1081),
    [anon_sym_PIPE_PIPE] = ACTIONS(1081),
    [anon_sym_GT_GT] = ACTIONS(1077),
    [anon_sym_GT_GT_GT] = ACTIONS(1081),
    [anon_sym_LT_LT] = ACTIONS(1081),
    [anon_sym_AMP] = ACTIONS(1077),
    [anon_sym_CARET] = ACTIONS(1081),
    [anon_sym_PIPE] = ACTIONS(1077),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_PERCENT] = ACTIONS(1081),
    [anon_sym_STAR_STAR] = ACTIONS(1081),
    [anon_sym_LT_EQ] = ACTIONS(1081),
    [anon_sym_EQ_EQ] = ACTIONS(1077),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(1081),
    [anon_sym_BANG_EQ] = ACTIONS(1077),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(1081),
    [anon_sym_GT_EQ] = ACTIONS(1081),
    [anon_sym_QMARK_QMARK] = ACTIONS(1081),
    [anon_sym_instanceof] = ACTIONS(1077),
    [anon_sym_TILDE] = ACTIONS(29),
    [anon_sym_void] = ACTIONS(19),
    [anon_sym_delete] = ACTIONS(19),
    [anon_sym_PLUS_PLUS] = ACTIONS(77),
    [anon_sym_DASH_DASH] = ACTIONS(77),
    [anon_sym_DQUOTE] = ACTIONS(79),
    [anon_sym_SQUOTE] = ACTIONS(81),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(83),
    [sym_number] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(89),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(855),
    [anon_sym_readonly] = ACTIONS(855),
    [anon_sym_get] = ACTIONS(855),
    [anon_sym_set] = ACTIONS(855),
    [anon_sym_declare] = ACTIONS(855),
    [anon_sym_public] = ACTIONS(855),
    [anon_sym_private] = ACTIONS(855),
    [anon_sym_protected] = ACTIONS(855),
    [anon_sym_override] = ACTIONS(855),
    [anon_sym_module] = ACTIONS(855),
    [anon_sym_any] = ACTIONS(855),
    [anon_sym_number] = ACTIONS(855),
    [anon_sym_boolean] = ACTIONS(855),
    [anon_sym_string] = ACTIONS(855),
    [anon_sym_symbol] = ACTIONS(855),
    [sym__automatic_semicolon] = ACTIONS(1081),
    [sym__ternary_qmark] = ACTIONS(1081),
  },
  [89] = {
    [sym_import] = STATE(1405),
    [sym_parenthesized_expression] = STATE(1152),
    [sym_expression] = STATE(1845),
    [sym_primary_expression] = STATE(1404),
    [sym_yield_expression] = STATE(1403),
    [sym_object] = STATE(1405),
    [sym_object_pattern] = STATE(4099),
    [sym_array] = STATE(1405),
    [sym_array_pattern] = STATE(4099),
    [sym_class] = STATE(1405),
    [sym_function] = STATE(1405),
    [sym_generator_function] = STATE(1405),
    [sym_arrow_function] = STATE(1405),
    [sym__call_signature] = STATE(3883),
    [sym_call_expression] = STATE(1405),
    [sym_new_expression] = STATE(1403),
    [sym_await_expression] = STATE(1403),
    [sym_member_expression] = STATE(1152),
    [sym_subscript_expression] = STATE(1152),
    [sym_assignment_expression] = STATE(1403),
    [sym__augmented_assignment_lhs] = STATE(2349),
    [sym_augmented_assignment_expression] = STATE(1403),
    [sym__destructuring_pattern] = STATE(4099),
    [sym_ternary_expression] = STATE(1403),
    [sym_binary_expression] = STATE(1403),
    [sym_unary_expression] = STATE(1403),
    [sym_update_expression] = STATE(1403),
    [sym_string] = STATE(1405),
    [sym_template_string] = STATE(1405),
    [sym_regex] = STATE(1405),
    [sym_meta_property] = STATE(1405),
    [sym_decorator] = STATE(1149),
    [sym_formal_parameters] = STATE(2903),
    [sym_non_null_expression] = STATE(1152),
    [sym_type_assertion] = STATE(1403),
    [sym_as_expression] = STATE(1403),
    [sym_internal_module] = STATE(1403),
    [sym_type_arguments] = STATE(476),
    [sym_type_parameters] = STATE(3670),
    [aux_sym_export_statement_repeat1] = STATE(3368),
    [sym_identifier] = ACTIONS(1107),
    [anon_sym_export] = ACTIONS(921),
    [anon_sym_STAR] = ACTIONS(1109),
    [anon_sym_type] = ACTIONS(921),
    [anon_sym_as] = ACTIONS(1077),
    [anon_sym_namespace] = ACTIONS(923),
    [anon_sym_LBRACE] = ACTIONS(1079),
    [anon_sym_typeof] = ACTIONS(943),
    [anon_sym_import] = ACTIONS(125),
    [anon_sym_BANG] = ACTIONS(943),
    [anon_sym_LPAREN] = ACTIONS(1083),
    [anon_sym_await] = ACTIONS(931),
    [anon_sym_in] = ACTIONS(1077),
    [anon_sym_COLON] = ACTIONS(1081),
    [anon_sym_yield] = ACTIONS(933),
    [anon_sym_LBRACK] = ACTIONS(1085),
    [anon_sym_RBRACK] = ACTIONS(1081),
    [anon_sym_LT] = ACTIONS(138),
    [anon_sym_GT] = ACTIONS(1077),
    [anon_sym_SLASH] = ACTIONS(557),
    [anon_sym_DOT] = ACTIONS(1077),
    [anon_sym_class] = ACTIONS(143),
    [anon_sym_async] = ACTIONS(935),
    [anon_sym_function] = ACTIONS(147),
    [anon_sym_QMARK_DOT] = ACTIONS(1081),
    [anon_sym_new] = ACTIONS(1111),
    [anon_sym_AMP_AMP] = ACTIONS(1081),
    [anon_sym_PIPE_PIPE] = ACTIONS(1081),
    [anon_sym_GT_GT] = ACTIONS(1077),
    [anon_sym_GT_GT_GT] = ACTIONS(1081),
    [anon_sym_LT_LT] = ACTIONS(1081),
    [anon_sym_AMP] = ACTIONS(1077),
    [anon_sym_CARET] = ACTIONS(1081),
    [anon_sym_PIPE] = ACTIONS(1077),
    [anon_sym_PLUS] = ACTIONS(943),
    [anon_sym_DASH] = ACTIONS(943),
    [anon_sym_PERCENT] = ACTIONS(1081),
    [anon_sym_STAR_STAR] = ACTIONS(1081),
    [anon_sym_LT_EQ] = ACTIONS(1081),
    [anon_sym_EQ_EQ] = ACTIONS(1077),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(1081),
    [anon_sym_BANG_EQ] = ACTIONS(1077),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(1081),
    [anon_sym_GT_EQ] = ACTIONS(1081),
    [anon_sym_QMARK_QMARK] = ACTIONS(1081),
    [anon_sym_instanceof] = ACTIONS(1077),
    [anon_sym_TILDE] = ACTIONS(929),
    [anon_sym_void] = ACTIONS(943),
    [anon_sym_delete] = ACTIONS(943),
    [anon_sym_PLUS_PLUS] = ACTIONS(945),
    [anon_sym_DASH_DASH] = ACTIONS(945),
    [anon_sym_DQUOTE] = ACTIONS(174),
    [anon_sym_SQUOTE] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(1089),
    [sym_number] = ACTIONS(625),
    [sym_this] = ACTIONS(184),
    [sym_super] = ACTIONS(184),
    [sym_true] = ACTIONS(184),
    [sym_false] = ACTIONS(184),
    [sym_null] = ACTIONS(184),
    [sym_undefined] = ACTIONS(1113),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(921),
    [anon_sym_readonly] = ACTIONS(921),
    [anon_sym_get] = ACTIONS(921),
    [anon_sym_set] = ACTIONS(921),
    [anon_sym_declare] = ACTIONS(921),
    [anon_sym_public] = ACTIONS(921),
    [anon_sym_private] = ACTIONS(921),
    [anon_sym_protected] = ACTIONS(921),
    [anon_sym_override] = ACTIONS(921),
    [anon_sym_module] = ACTIONS(921),
    [anon_sym_any] = ACTIONS(921),
    [anon_sym_number] = ACTIONS(921),
    [anon_sym_boolean] = ACTIONS(921),
    [anon_sym_string] = ACTIONS(921),
    [anon_sym_symbol] = ACTIONS(921),
    [sym__ternary_qmark] = ACTIONS(1081),
  },
  [90] = {
    [sym_import] = STATE(1844),
    [sym_parenthesized_expression] = STATE(1142),
    [sym_expression] = STATE(1738),
    [sym_primary_expression] = STATE(1799),
    [sym_yield_expression] = STATE(1798),
    [sym_object] = STATE(1844),
    [sym_object_pattern] = STATE(3982),
    [sym_array] = STATE(1844),
    [sym_array_pattern] = STATE(3982),
    [sym_class] = STATE(1844),
    [sym_function] = STATE(1844),
    [sym_generator_function] = STATE(1844),
    [sym_arrow_function] = STATE(1844),
    [sym__call_signature] = STATE(3980),
    [sym_call_expression] = STATE(1844),
    [sym_new_expression] = STATE(1798),
    [sym_await_expression] = STATE(1798),
    [sym_member_expression] = STATE(1142),
    [sym_subscript_expression] = STATE(1142),
    [sym_assignment_expression] = STATE(1798),
    [sym__augmented_assignment_lhs] = STATE(2347),
    [sym_augmented_assignment_expression] = STATE(1798),
    [sym__destructuring_pattern] = STATE(3982),
    [sym_ternary_expression] = STATE(1798),
    [sym_binary_expression] = STATE(1798),
    [sym_unary_expression] = STATE(1798),
    [sym_update_expression] = STATE(1798),
    [sym_string] = STATE(1844),
    [sym_template_string] = STATE(1844),
    [sym_regex] = STATE(1844),
    [sym_meta_property] = STATE(1844),
    [sym_decorator] = STATE(1149),
    [sym_formal_parameters] = STATE(2903),
    [sym_non_null_expression] = STATE(1142),
    [sym_type_assertion] = STATE(1798),
    [sym_as_expression] = STATE(1798),
    [sym_internal_module] = STATE(1798),
    [sym_type_arguments] = STATE(398),
    [sym_type_parameters] = STATE(3670),
    [aux_sym_export_statement_repeat1] = STATE(3372),
    [sym_identifier] = ACTIONS(1115),
    [anon_sym_export] = ACTIONS(877),
    [anon_sym_STAR] = ACTIONS(1117),
    [anon_sym_type] = ACTIONS(877),
    [anon_sym_as] = ACTIONS(1077),
    [anon_sym_namespace] = ACTIONS(879),
    [anon_sym_LBRACE] = ACTIONS(1097),
    [anon_sym_typeof] = ACTIONS(901),
    [anon_sym_import] = ACTIONS(763),
    [anon_sym_BANG] = ACTIONS(901),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_await] = ACTIONS(887),
    [anon_sym_in] = ACTIONS(1077),
    [anon_sym_SEMI] = ACTIONS(1081),
    [anon_sym_yield] = ACTIONS(889),
    [anon_sym_LBRACK] = ACTIONS(63),
    [anon_sym_LT] = ACTIONS(138),
    [anon_sym_GT] = ACTIONS(1077),
    [anon_sym_SLASH] = ACTIONS(67),
    [anon_sym_DOT] = ACTIONS(1077),
    [anon_sym_class] = ACTIONS(777),
    [anon_sym_async] = ACTIONS(893),
    [anon_sym_function] = ACTIONS(781),
    [anon_sym_QMARK_DOT] = ACTIONS(1081),
    [anon_sym_new] = ACTIONS(1119),
    [anon_sym_AMP_AMP] = ACTIONS(1081),
    [anon_sym_PIPE_PIPE] = ACTIONS(1081),
    [anon_sym_GT_GT] = ACTIONS(1077),
    [anon_sym_GT_GT_GT] = ACTIONS(1081),
    [anon_sym_LT_LT] = ACTIONS(1081),
    [anon_sym_AMP] = ACTIONS(1077),
    [anon_sym_CARET] = ACTIONS(1081),
    [anon_sym_PIPE] = ACTIONS(1077),
    [anon_sym_PLUS] = ACTIONS(901),
    [anon_sym_DASH] = ACTIONS(901),
    [anon_sym_PERCENT] = ACTIONS(1081),
    [anon_sym_STAR_STAR] = ACTIONS(1081),
    [anon_sym_LT_EQ] = ACTIONS(1081),
    [anon_sym_EQ_EQ] = ACTIONS(1077),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(1081),
    [anon_sym_BANG_EQ] = ACTIONS(1077),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(1081),
    [anon_sym_GT_EQ] = ACTIONS(1081),
    [anon_sym_QMARK_QMARK] = ACTIONS(1081),
    [anon_sym_instanceof] = ACTIONS(1077),
    [anon_sym_TILDE] = ACTIONS(885),
    [anon_sym_void] = ACTIONS(901),
    [anon_sym_delete] = ACTIONS(901),
    [anon_sym_PLUS_PLUS] = ACTIONS(903),
    [anon_sym_DASH_DASH] = ACTIONS(903),
    [anon_sym_DQUOTE] = ACTIONS(79),
    [anon_sym_SQUOTE] = ACTIONS(81),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(83),
    [sym_number] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(1121),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(877),
    [anon_sym_readonly] = ACTIONS(877),
    [anon_sym_get] = ACTIONS(877),
    [anon_sym_set] = ACTIONS(877),
    [anon_sym_declare] = ACTIONS(877),
    [anon_sym_public] = ACTIONS(877),
    [anon_sym_private] = ACTIONS(877),
    [anon_sym_protected] = ACTIONS(877),
    [anon_sym_override] = ACTIONS(877),
    [anon_sym_module] = ACTIONS(877),
    [anon_sym_any] = ACTIONS(877),
    [anon_sym_number] = ACTIONS(877),
    [anon_sym_boolean] = ACTIONS(877),
    [anon_sym_string] = ACTIONS(877),
    [anon_sym_symbol] = ACTIONS(877),
    [sym__automatic_semicolon] = ACTIONS(1081),
    [sym__ternary_qmark] = ACTIONS(1081),
  },
  [91] = {
    [sym_import] = STATE(1405),
    [sym_parenthesized_expression] = STATE(1125),
    [sym_expression] = STATE(1646),
    [sym_primary_expression] = STATE(1404),
    [sym_yield_expression] = STATE(1403),
    [sym_object] = STATE(1405),
    [sym_object_pattern] = STATE(4142),
    [sym_array] = STATE(1405),
    [sym_array_pattern] = STATE(4142),
    [sym_class] = STATE(1405),
    [sym_function] = STATE(1405),
    [sym_generator_function] = STATE(1405),
    [sym_arrow_function] = STATE(1405),
    [sym__call_signature] = STATE(4097),
    [sym_call_expression] = STATE(1405),
    [sym_new_expression] = STATE(1403),
    [sym_await_expression] = STATE(1403),
    [sym_member_expression] = STATE(1125),
    [sym_subscript_expression] = STATE(1125),
    [sym_assignment_expression] = STATE(1403),
    [sym__augmented_assignment_lhs] = STATE(2361),
    [sym_augmented_assignment_expression] = STATE(1403),
    [sym__destructuring_pattern] = STATE(4142),
    [sym_ternary_expression] = STATE(1403),
    [sym_binary_expression] = STATE(1403),
    [sym_unary_expression] = STATE(1403),
    [sym_update_expression] = STATE(1403),
    [sym_string] = STATE(1405),
    [sym_template_string] = STATE(1405),
    [sym_regex] = STATE(1405),
    [sym_meta_property] = STATE(1405),
    [sym_decorator] = STATE(1149),
    [sym_formal_parameters] = STATE(2903),
    [sym_non_null_expression] = STATE(1125),
    [sym_type_assertion] = STATE(1403),
    [sym_as_expression] = STATE(1403),
    [sym_internal_module] = STATE(1403),
    [sym_type_arguments] = STATE(338),
    [sym_type_parameters] = STATE(3670),
    [aux_sym_export_statement_repeat1] = STATE(3368),
    [sym_identifier] = ACTIONS(1123),
    [anon_sym_export] = ACTIONS(955),
    [anon_sym_STAR] = ACTIONS(1125),
    [anon_sym_type] = ACTIONS(955),
    [anon_sym_as] = ACTIONS(1077),
    [anon_sym_namespace] = ACTIONS(957),
    [anon_sym_LBRACE] = ACTIONS(1079),
    [anon_sym_COMMA] = ACTIONS(1081),
    [anon_sym_typeof] = ACTIONS(981),
    [anon_sym_import] = ACTIONS(125),
    [anon_sym_BANG] = ACTIONS(981),
    [anon_sym_LPAREN] = ACTIONS(1083),
    [anon_sym_await] = ACTIONS(965),
    [anon_sym_in] = ACTIONS(1077),
    [anon_sym_yield] = ACTIONS(967),
    [anon_sym_LBRACK] = ACTIONS(1085),
    [anon_sym_LT] = ACTIONS(138),
    [anon_sym_GT] = ACTIONS(1077),
    [anon_sym_SLASH] = ACTIONS(971),
    [anon_sym_DOT] = ACTIONS(1077),
    [anon_sym_class] = ACTIONS(143),
    [anon_sym_async] = ACTIONS(973),
    [anon_sym_function] = ACTIONS(147),
    [anon_sym_QMARK_DOT] = ACTIONS(1081),
    [anon_sym_new] = ACTIONS(1127),
    [anon_sym_AMP_AMP] = ACTIONS(1081),
    [anon_sym_PIPE_PIPE] = ACTIONS(1081),
    [anon_sym_GT_GT] = ACTIONS(1077),
    [anon_sym_GT_GT_GT] = ACTIONS(1081),
    [anon_sym_LT_LT] = ACTIONS(1081),
    [anon_sym_AMP] = ACTIONS(1077),
    [anon_sym_CARET] = ACTIONS(1081),
    [anon_sym_PIPE] = ACTIONS(1077),
    [anon_sym_PLUS] = ACTIONS(981),
    [anon_sym_DASH] = ACTIONS(981),
    [anon_sym_PERCENT] = ACTIONS(1081),
    [anon_sym_STAR_STAR] = ACTIONS(1081),
    [anon_sym_LT_EQ] = ACTIONS(1081),
    [anon_sym_EQ_EQ] = ACTIONS(1077),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(1081),
    [anon_sym_BANG_EQ] = ACTIONS(1077),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(1081),
    [anon_sym_GT_EQ] = ACTIONS(1081),
    [anon_sym_QMARK_QMARK] = ACTIONS(1081),
    [anon_sym_instanceof] = ACTIONS(1077),
    [anon_sym_TILDE] = ACTIONS(963),
    [anon_sym_void] = ACTIONS(981),
    [anon_sym_delete] = ACTIONS(981),
    [anon_sym_PLUS_PLUS] = ACTIONS(983),
    [anon_sym_DASH_DASH] = ACTIONS(983),
    [anon_sym_DQUOTE] = ACTIONS(174),
    [anon_sym_SQUOTE] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(1089),
    [sym_number] = ACTIONS(625),
    [sym_this] = ACTIONS(184),
    [sym_super] = ACTIONS(184),
    [sym_true] = ACTIONS(184),
    [sym_false] = ACTIONS(184),
    [sym_null] = ACTIONS(184),
    [sym_undefined] = ACTIONS(1129),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(955),
    [anon_sym_readonly] = ACTIONS(955),
    [anon_sym_get] = ACTIONS(955),
    [anon_sym_set] = ACTIONS(955),
    [anon_sym_declare] = ACTIONS(955),
    [anon_sym_public] = ACTIONS(955),
    [anon_sym_private] = ACTIONS(955),
    [anon_sym_protected] = ACTIONS(955),
    [anon_sym_override] = ACTIONS(955),
    [anon_sym_module] = ACTIONS(955),
    [anon_sym_any] = ACTIONS(955),
    [anon_sym_number] = ACTIONS(955),
    [anon_sym_boolean] = ACTIONS(955),
    [anon_sym_string] = ACTIONS(955),
    [anon_sym_symbol] = ACTIONS(955),
    [anon_sym_implements] = ACTIONS(1077),
    [sym__ternary_qmark] = ACTIONS(1081),
  },
  [92] = {
    [sym_import] = STATE(1405),
    [sym_parenthesized_expression] = STATE(1159),
    [sym_expression] = STATE(1942),
    [sym_primary_expression] = STATE(1404),
    [sym_yield_expression] = STATE(1403),
    [sym_object] = STATE(1405),
    [sym_object_pattern] = STATE(4173),
    [sym_array] = STATE(1405),
    [sym_array_pattern] = STATE(4173),
    [sym_class] = STATE(1405),
    [sym_function] = STATE(1405),
    [sym_generator_function] = STATE(1405),
    [sym_arrow_function] = STATE(1405),
    [sym__call_signature] = STATE(3938),
    [sym_call_expression] = STATE(1405),
    [sym_new_expression] = STATE(1403),
    [sym_await_expression] = STATE(1403),
    [sym_member_expression] = STATE(1159),
    [sym_subscript_expression] = STATE(1159),
    [sym_assignment_expression] = STATE(1403),
    [sym__augmented_assignment_lhs] = STATE(2350),
    [sym_augmented_assignment_expression] = STATE(1403),
    [sym__destructuring_pattern] = STATE(4173),
    [sym_ternary_expression] = STATE(1403),
    [sym_binary_expression] = STATE(1403),
    [sym_unary_expression] = STATE(1403),
    [sym_update_expression] = STATE(1403),
    [sym_string] = STATE(1405),
    [sym_template_string] = STATE(1405),
    [sym_regex] = STATE(1405),
    [sym_meta_property] = STATE(1405),
    [sym_decorator] = STATE(1149),
    [sym_formal_parameters] = STATE(2903),
    [sym_non_null_expression] = STATE(1159),
    [sym_type_assertion] = STATE(1403),
    [sym_as_expression] = STATE(1403),
    [sym_internal_module] = STATE(1403),
    [sym_type_arguments] = STATE(421),
    [sym_type_parameters] = STATE(3670),
    [aux_sym_export_statement_repeat1] = STATE(3368),
    [sym_identifier] = ACTIONS(1131),
    [anon_sym_export] = ACTIONS(1041),
    [anon_sym_STAR] = ACTIONS(1133),
    [anon_sym_type] = ACTIONS(1041),
    [anon_sym_as] = ACTIONS(1077),
    [anon_sym_namespace] = ACTIONS(1043),
    [anon_sym_LBRACE] = ACTIONS(1135),
    [anon_sym_typeof] = ACTIONS(1063),
    [anon_sym_import] = ACTIONS(125),
    [anon_sym_BANG] = ACTIONS(1063),
    [anon_sym_LPAREN] = ACTIONS(1083),
    [anon_sym_await] = ACTIONS(1049),
    [anon_sym_in] = ACTIONS(1077),
    [anon_sym_of] = ACTIONS(1077),
    [anon_sym_yield] = ACTIONS(1051),
    [anon_sym_LBRACK] = ACTIONS(1137),
    [anon_sym_LT] = ACTIONS(138),
    [anon_sym_GT] = ACTIONS(1077),
    [anon_sym_SLASH] = ACTIONS(1053),
    [anon_sym_DOT] = ACTIONS(1077),
    [anon_sym_class] = ACTIONS(143),
    [anon_sym_async] = ACTIONS(1055),
    [anon_sym_function] = ACTIONS(147),
    [anon_sym_QMARK_DOT] = ACTIONS(1081),
    [anon_sym_new] = ACTIONS(1139),
    [anon_sym_AMP_AMP] = ACTIONS(1081),
    [anon_sym_PIPE_PIPE] = ACTIONS(1081),
    [anon_sym_GT_GT] = ACTIONS(1077),
    [anon_sym_GT_GT_GT] = ACTIONS(1081),
    [anon_sym_LT_LT] = ACTIONS(1081),
    [anon_sym_AMP] = ACTIONS(1077),
    [anon_sym_CARET] = ACTIONS(1081),
    [anon_sym_PIPE] = ACTIONS(1077),
    [anon_sym_PLUS] = ACTIONS(1063),
    [anon_sym_DASH] = ACTIONS(1063),
    [anon_sym_PERCENT] = ACTIONS(1081),
    [anon_sym_STAR_STAR] = ACTIONS(1081),
    [anon_sym_LT_EQ] = ACTIONS(1081),
    [anon_sym_EQ_EQ] = ACTIONS(1077),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(1081),
    [anon_sym_BANG_EQ] = ACTIONS(1077),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(1081),
    [anon_sym_GT_EQ] = ACTIONS(1081),
    [anon_sym_QMARK_QMARK] = ACTIONS(1081),
    [anon_sym_instanceof] = ACTIONS(1077),
    [anon_sym_TILDE] = ACTIONS(1047),
    [anon_sym_void] = ACTIONS(1063),
    [anon_sym_delete] = ACTIONS(1063),
    [anon_sym_PLUS_PLUS] = ACTIONS(1065),
    [anon_sym_DASH_DASH] = ACTIONS(1065),
    [anon_sym_DQUOTE] = ACTIONS(174),
    [anon_sym_SQUOTE] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(1089),
    [sym_number] = ACTIONS(625),
    [sym_this] = ACTIONS(184),
    [sym_super] = ACTIONS(184),
    [sym_true] = ACTIONS(184),
    [sym_false] = ACTIONS(184),
    [sym_null] = ACTIONS(184),
    [sym_undefined] = ACTIONS(1141),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(1041),
    [anon_sym_readonly] = ACTIONS(1041),
    [anon_sym_get] = ACTIONS(1041),
    [anon_sym_set] = ACTIONS(1041),
    [anon_sym_declare] = ACTIONS(1041),
    [anon_sym_public] = ACTIONS(1041),
    [anon_sym_private] = ACTIONS(1041),
    [anon_sym_protected] = ACTIONS(1041),
    [anon_sym_override] = ACTIONS(1041),
    [anon_sym_module] = ACTIONS(1041),
    [anon_sym_any] = ACTIONS(1041),
    [anon_sym_number] = ACTIONS(1041),
    [anon_sym_boolean] = ACTIONS(1041),
    [anon_sym_string] = ACTIONS(1041),
    [anon_sym_symbol] = ACTIONS(1041),
    [sym__ternary_qmark] = ACTIONS(1081),
  },
  [93] = {
    [sym_import] = STATE(1405),
    [sym_parenthesized_expression] = STATE(1023),
    [sym_expression] = STATE(1993),
    [sym_primary_expression] = STATE(1404),
    [sym_yield_expression] = STATE(1403),
    [sym_object] = STATE(1405),
    [sym_object_pattern] = STATE(4117),
    [sym_array] = STATE(1405),
    [sym_array_pattern] = STATE(4117),
    [sym_class] = STATE(1405),
    [sym_function] = STATE(1405),
    [sym_generator_function] = STATE(1405),
    [sym_arrow_function] = STATE(1405),
    [sym__call_signature] = STATE(4016),
    [sym_call_expression] = STATE(1405),
    [sym_new_expression] = STATE(1403),
    [sym_await_expression] = STATE(1403),
    [sym_member_expression] = STATE(1023),
    [sym_subscript_expression] = STATE(1023),
    [sym_assignment_expression] = STATE(1403),
    [sym__augmented_assignment_lhs] = STATE(2340),
    [sym_augmented_assignment_expression] = STATE(1403),
    [sym__destructuring_pattern] = STATE(4117),
    [sym_ternary_expression] = STATE(1403),
    [sym_binary_expression] = STATE(1403),
    [sym_unary_expression] = STATE(1403),
    [sym_update_expression] = STATE(1403),
    [sym_string] = STATE(1405),
    [sym_template_string] = STATE(1405),
    [sym_regex] = STATE(1405),
    [sym_meta_property] = STATE(1405),
    [sym_decorator] = STATE(1149),
    [sym_formal_parameters] = STATE(2903),
    [sym_non_null_expression] = STATE(1023),
    [sym_type_assertion] = STATE(1403),
    [sym_as_expression] = STATE(1403),
    [sym_internal_module] = STATE(1403),
    [sym_type_arguments] = STATE(519),
    [sym_type_parameters] = STATE(3670),
    [aux_sym_export_statement_repeat1] = STATE(3368),
    [sym_identifier] = ACTIONS(1143),
    [anon_sym_export] = ACTIONS(825),
    [anon_sym_STAR] = ACTIONS(1145),
    [anon_sym_type] = ACTIONS(825),
    [anon_sym_as] = ACTIONS(1077),
    [anon_sym_namespace] = ACTIONS(827),
    [anon_sym_LBRACE] = ACTIONS(1135),
    [anon_sym_typeof] = ACTIONS(169),
    [anon_sym_import] = ACTIONS(125),
    [anon_sym_BANG] = ACTIONS(169),
    [anon_sym_LPAREN] = ACTIONS(1083),
    [anon_sym_await] = ACTIONS(132),
    [anon_sym_in] = ACTIONS(1077),
    [anon_sym_yield] = ACTIONS(134),
    [anon_sym_LBRACK] = ACTIONS(1137),
    [anon_sym_LT] = ACTIONS(138),
    [anon_sym_GT] = ACTIONS(1077),
    [anon_sym_SLASH] = ACTIONS(557),
    [anon_sym_DOT] = ACTIONS(1077),
    [anon_sym_class] = ACTIONS(143),
    [anon_sym_async] = ACTIONS(835),
    [anon_sym_function] = ACTIONS(147),
    [anon_sym_QMARK_DOT] = ACTIONS(1081),
    [anon_sym_new] = ACTIONS(620),
    [anon_sym_AMP_AMP] = ACTIONS(1081),
    [anon_sym_PIPE_PIPE] = ACTIONS(1081),
    [anon_sym_GT_GT] = ACTIONS(1077),
    [anon_sym_GT_GT_GT] = ACTIONS(1081),
    [anon_sym_LT_LT] = ACTIONS(1081),
    [anon_sym_AMP] = ACTIONS(1077),
    [anon_sym_CARET] = ACTIONS(1081),
    [anon_sym_PIPE] = ACTIONS(1077),
    [anon_sym_PLUS] = ACTIONS(169),
    [anon_sym_DASH] = ACTIONS(169),
    [anon_sym_PERCENT] = ACTIONS(1081),
    [anon_sym_STAR_STAR] = ACTIONS(1081),
    [anon_sym_LT_EQ] = ACTIONS(1081),
    [anon_sym_EQ_EQ] = ACTIONS(1077),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(1081),
    [anon_sym_BANG_EQ] = ACTIONS(1077),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(1081),
    [anon_sym_GT_EQ] = ACTIONS(1081),
    [anon_sym_QMARK_QMARK] = ACTIONS(1081),
    [anon_sym_instanceof] = ACTIONS(1077),
    [anon_sym_TILDE] = ACTIONS(165),
    [anon_sym_void] = ACTIONS(169),
    [anon_sym_delete] = ACTIONS(169),
    [anon_sym_PLUS_PLUS] = ACTIONS(675),
    [anon_sym_DASH_DASH] = ACTIONS(675),
    [anon_sym_DQUOTE] = ACTIONS(174),
    [anon_sym_SQUOTE] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(1089),
    [sym_number] = ACTIONS(625),
    [sym_this] = ACTIONS(184),
    [sym_super] = ACTIONS(184),
    [sym_true] = ACTIONS(184),
    [sym_false] = ACTIONS(184),
    [sym_null] = ACTIONS(184),
    [sym_undefined] = ACTIONS(1147),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(825),
    [anon_sym_readonly] = ACTIONS(825),
    [anon_sym_get] = ACTIONS(825),
    [anon_sym_set] = ACTIONS(825),
    [anon_sym_declare] = ACTIONS(825),
    [anon_sym_public] = ACTIONS(825),
    [anon_sym_private] = ACTIONS(825),
    [anon_sym_protected] = ACTIONS(825),
    [anon_sym_override] = ACTIONS(825),
    [anon_sym_module] = ACTIONS(825),
    [anon_sym_any] = ACTIONS(825),
    [anon_sym_number] = ACTIONS(825),
    [anon_sym_boolean] = ACTIONS(825),
    [anon_sym_string] = ACTIONS(825),
    [anon_sym_symbol] = ACTIONS(825),
    [sym__ternary_qmark] = ACTIONS(1081),
  },
  [94] = {
    [sym_nested_identifier] = STATE(4074),
    [sym_string] = STATE(2367),
    [sym_formal_parameters] = STATE(4073),
    [sym_nested_type_identifier] = STATE(2336),
    [sym__type] = STATE(2398),
    [sym_constructor_type] = STATE(2398),
    [sym__primary_type] = STATE(2373),
    [sym_template_literal_type] = STATE(2359),
    [sym_infer_type] = STATE(2398),
    [sym_conditional_type] = STATE(2359),
    [sym_generic_type] = STATE(2359),
    [sym_type_query] = STATE(2359),
    [sym_index_type_query] = STATE(2359),
    [sym_lookup_type] = STATE(2359),
    [sym_literal_type] = STATE(2359),
    [sym__number] = STATE(2355),
    [sym_existential_type] = STATE(2359),
    [sym_flow_maybe_type] = STATE(2359),
    [sym_parenthesized_type] = STATE(2359),
    [sym_predefined_type] = STATE(2359),
    [sym_object_type] = STATE(2359),
    [sym_type_parameters] = STATE(3731),
    [sym_array_type] = STATE(2359),
    [sym_tuple_type] = STATE(2359),
    [sym_readonly_type] = STATE(2398),
    [sym_union_type] = STATE(2359),
    [sym_intersection_type] = STATE(2359),
    [sym_function_type] = STATE(2398),
    [sym_identifier] = ACTIONS(1149),
    [anon_sym_STAR] = ACTIONS(109),
    [anon_sym_EQ] = ACTIONS(1151),
    [anon_sym_as] = ACTIONS(114),
    [anon_sym_LBRACE] = ACTIONS(1153),
    [anon_sym_COMMA] = ACTIONS(151),
    [anon_sym_RBRACE] = ACTIONS(151),
    [anon_sym_typeof] = ACTIONS(1155),
    [anon_sym_BANG] = ACTIONS(114),
    [anon_sym_LPAREN] = ACTIONS(1157),
    [anon_sym_RPAREN] = ACTIONS(151),
    [anon_sym_in] = ACTIONS(114),
    [anon_sym_COLON] = ACTIONS(151),
    [anon_sym_LBRACK] = ACTIONS(1159),
    [anon_sym_RBRACK] = ACTIONS(151),
    [anon_sym_LT] = ACTIONS(1161),
    [anon_sym_GT] = ACTIONS(114),
    [anon_sym_SLASH] = ACTIONS(114),
    [anon_sym_DOT] = ACTIONS(114),
    [anon_sym_EQ_GT] = ACTIONS(149),
    [anon_sym_QMARK_DOT] = ACTIONS(151),
    [anon_sym_new] = ACTIONS(1163),
    [anon_sym_PLUS_EQ] = ACTIONS(155),
    [anon_sym_DASH_EQ] = ACTIONS(155),
    [anon_sym_STAR_EQ] = ACTIONS(155),
    [anon_sym_SLASH_EQ] = ACTIONS(155),
    [anon_sym_PERCENT_EQ] = ACTIONS(155),
    [anon_sym_CARET_EQ] = ACTIONS(155),
    [anon_sym_AMP_EQ] = ACTIONS(155),
    [anon_sym_PIPE_EQ] = ACTIONS(155),
    [anon_sym_GT_GT_EQ] = ACTIONS(155),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(155),
    [anon_sym_LT_LT_EQ] = ACTIONS(155),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(155),
    [anon_sym_AMP_AMP_EQ] = ACTIONS(155),
    [anon_sym_PIPE_PIPE_EQ] = ACTIONS(155),
    [anon_sym_QMARK_QMARK_EQ] = ACTIONS(155),
    [anon_sym_AMP_AMP] = ACTIONS(114),
    [anon_sym_PIPE_PIPE] = ACTIONS(114),
    [anon_sym_GT_GT] = ACTIONS(114),
    [anon_sym_GT_GT_GT] = ACTIONS(114),
    [anon_sym_LT_LT] = ACTIONS(114),
    [anon_sym_AMP] = ACTIONS(159),
    [anon_sym_CARET] = ACTIONS(114),
    [anon_sym_PIPE] = ACTIONS(161),
    [anon_sym_PLUS] = ACTIONS(1165),
    [anon_sym_DASH] = ACTIONS(1165),
    [anon_sym_PERCENT] = ACTIONS(114),
    [anon_sym_STAR_STAR] = ACTIONS(114),
    [anon_sym_LT_EQ] = ACTIONS(151),
    [anon_sym_EQ_EQ] = ACTIONS(114),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(151),
    [anon_sym_BANG_EQ] = ACTIONS(114),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(151),
    [anon_sym_GT_EQ] = ACTIONS(151),
    [anon_sym_QMARK_QMARK] = ACTIONS(114),
    [anon_sym_instanceof] = ACTIONS(114),
    [anon_sym_void] = ACTIONS(202),
    [anon_sym_PLUS_PLUS] = ACTIONS(151),
    [anon_sym_DASH_DASH] = ACTIONS(151),
    [anon_sym_DQUOTE] = ACTIONS(1167),
    [anon_sym_SQUOTE] = ACTIONS(1169),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(1171),
    [sym_number] = ACTIONS(1173),
    [sym_this] = ACTIONS(1175),
    [sym_true] = ACTIONS(1177),
    [sym_false] = ACTIONS(1177),
    [sym_null] = ACTIONS(1177),
    [sym_undefined] = ACTIONS(1177),
    [anon_sym_readonly] = ACTIONS(1179),
    [anon_sym_QMARK] = ACTIONS(192),
    [anon_sym_any] = ACTIONS(202),
    [anon_sym_number] = ACTIONS(202),
    [anon_sym_boolean] = ACTIONS(202),
    [anon_sym_string] = ACTIONS(202),
    [anon_sym_symbol] = ACTIONS(202),
    [anon_sym_abstract] = ACTIONS(196),
    [anon_sym_infer] = ACTIONS(198),
    [anon_sym_keyof] = ACTIONS(200),
    [anon_sym_unknown] = ACTIONS(202),
    [anon_sym_never] = ACTIONS(202),
    [anon_sym_object] = ACTIONS(202),
    [anon_sym_LBRACE_PIPE] = ACTIONS(204),
    [sym__ternary_qmark] = ACTIONS(151),
  },
  [95] = {
    [sym_declaration] = STATE(3157),
    [sym_import] = STATE(1844),
    [sym_variable_declaration] = STATE(3112),
    [sym_lexical_declaration] = STATE(3112),
    [sym_parenthesized_expression] = STATE(1142),
    [sym_expression] = STATE(1770),
    [sym_primary_expression] = STATE(1799),
    [sym_yield_expression] = STATE(1798),
    [sym_object] = STATE(1844),
    [sym_object_pattern] = STATE(3982),
    [sym_array] = STATE(1844),
    [sym_array_pattern] = STATE(3982),
    [sym_class] = STATE(1844),
    [sym_class_declaration] = STATE(3112),
    [sym_function] = STATE(1844),
    [sym_function_declaration] = STATE(3112),
    [sym_generator_function] = STATE(1844),
    [sym_generator_function_declaration] = STATE(3112),
    [sym_arrow_function] = STATE(1844),
    [sym__call_signature] = STATE(3980),
    [sym_call_expression] = STATE(1844),
    [sym_new_expression] = STATE(1798),
    [sym_await_expression] = STATE(1798),
    [sym_member_expression] = STATE(1142),
    [sym_subscript_expression] = STATE(1142),
    [sym_assignment_expression] = STATE(1798),
    [sym__augmented_assignment_lhs] = STATE(2347),
    [sym_augmented_assignment_expression] = STATE(1798),
    [sym__destructuring_pattern] = STATE(3982),
    [sym_ternary_expression] = STATE(1798),
    [sym_binary_expression] = STATE(1798),
    [sym_unary_expression] = STATE(1798),
    [sym_update_expression] = STATE(1798),
    [sym_string] = STATE(1844),
    [sym_template_string] = STATE(1844),
    [sym_regex] = STATE(1844),
    [sym_meta_property] = STATE(1844),
    [sym_decorator] = STATE(1149),
    [sym_formal_parameters] = STATE(2903),
    [sym_non_null_expression] = STATE(1142),
    [sym_function_signature] = STATE(3112),
    [sym_type_assertion] = STATE(1798),
    [sym_as_expression] = STATE(1798),
    [sym_ambient_declaration] = STATE(3112),
    [sym_abstract_class_declaration] = STATE(3112),
    [sym_module] = STATE(3112),
    [sym_internal_module] = STATE(1894),
    [sym_import_alias] = STATE(3112),
    [sym_interface_declaration] = STATE(3112),
    [sym_enum_declaration] = STATE(3112),
    [sym_type_alias_declaration] = STATE(3112),
    [sym_type_arguments] = STATE(398),
    [sym_type_parameters] = STATE(3670),
    [aux_sym_export_statement_repeat1] = STATE(3268),
    [sym_identifier] = ACTIONS(1115),
    [anon_sym_export] = ACTIONS(877),
    [anon_sym_type] = ACTIONS(1181),
    [anon_sym_namespace] = ACTIONS(879),
    [anon_sym_LBRACE] = ACTIONS(1097),
    [anon_sym_typeof] = ACTIONS(901),
    [anon_sym_import] = ACTIONS(1183),
    [anon_sym_var] = ACTIONS(1185),
    [anon_sym_let] = ACTIONS(1187),
    [anon_sym_const] = ACTIONS(1189),
    [anon_sym_BANG] = ACTIONS(885),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_await] = ACTIONS(887),
    [anon_sym_yield] = ACTIONS(889),
    [anon_sym_LBRACK] = ACTIONS(63),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(1191),
    [anon_sym_async] = ACTIONS(1193),
    [anon_sym_function] = ACTIONS(1195),
    [anon_sym_new] = ACTIONS(1119),
    [anon_sym_PLUS] = ACTIONS(901),
    [anon_sym_DASH] = ACTIONS(901),
    [anon_sym_TILDE] = ACTIONS(885),
    [anon_sym_void] = ACTIONS(901),
    [anon_sym_delete] = ACTIONS(901),
    [anon_sym_PLUS_PLUS] = ACTIONS(903),
    [anon_sym_DASH_DASH] = ACTIONS(903),
    [anon_sym_DQUOTE] = ACTIONS(79),
    [anon_sym_SQUOTE] = ACTIONS(81),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(83),
    [sym_number] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(1121),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(877),
    [anon_sym_readonly] = ACTIONS(877),
    [anon_sym_get] = ACTIONS(877),
    [anon_sym_set] = ACTIONS(877),
    [anon_sym_declare] = ACTIONS(1197),
    [anon_sym_public] = ACTIONS(877),
    [anon_sym_private] = ACTIONS(877),
    [anon_sym_protected] = ACTIONS(877),
    [anon_sym_override] = ACTIONS(877),
    [anon_sym_module] = ACTIONS(1199),
    [anon_sym_any] = ACTIONS(877),
    [anon_sym_number] = ACTIONS(877),
    [anon_sym_boolean] = ACTIONS(877),
    [anon_sym_string] = ACTIONS(877),
    [anon_sym_symbol] = ACTIONS(877),
    [anon_sym_abstract] = ACTIONS(1201),
    [anon_sym_interface] = ACTIONS(1203),
    [anon_sym_enum] = ACTIONS(1205),
  },
  [96] = {
    [sym_nested_identifier] = STATE(4074),
    [sym_string] = STATE(2367),
    [sym_formal_parameters] = STATE(4073),
    [sym_nested_type_identifier] = STATE(2336),
    [sym__type] = STATE(2398),
    [sym_constructor_type] = STATE(2398),
    [sym__primary_type] = STATE(2373),
    [sym_template_literal_type] = STATE(2359),
    [sym_infer_type] = STATE(2398),
    [sym_conditional_type] = STATE(2359),
    [sym_generic_type] = STATE(2359),
    [sym_type_query] = STATE(2359),
    [sym_index_type_query] = STATE(2359),
    [sym_lookup_type] = STATE(2359),
    [sym_literal_type] = STATE(2359),
    [sym__number] = STATE(2355),
    [sym_existential_type] = STATE(2359),
    [sym_flow_maybe_type] = STATE(2359),
    [sym_parenthesized_type] = STATE(2359),
    [sym_predefined_type] = STATE(2359),
    [sym_object_type] = STATE(2359),
    [sym_type_parameters] = STATE(3731),
    [sym_array_type] = STATE(2359),
    [sym_tuple_type] = STATE(2359),
    [sym_readonly_type] = STATE(2398),
    [sym_union_type] = STATE(2359),
    [sym_intersection_type] = STATE(2359),
    [sym_function_type] = STATE(2398),
    [sym_identifier] = ACTIONS(1149),
    [anon_sym_STAR] = ACTIONS(109),
    [anon_sym_EQ] = ACTIONS(1207),
    [anon_sym_as] = ACTIONS(114),
    [anon_sym_LBRACE] = ACTIONS(1153),
    [anon_sym_COMMA] = ACTIONS(151),
    [anon_sym_typeof] = ACTIONS(1155),
    [anon_sym_BANG] = ACTIONS(114),
    [anon_sym_LPAREN] = ACTIONS(1157),
    [anon_sym_in] = ACTIONS(114),
    [anon_sym_of] = ACTIONS(114),
    [anon_sym_SEMI] = ACTIONS(151),
    [anon_sym_LBRACK] = ACTIONS(1159),
    [anon_sym_LT] = ACTIONS(1161),
    [anon_sym_GT] = ACTIONS(114),
    [anon_sym_SLASH] = ACTIONS(114),
    [anon_sym_DOT] = ACTIONS(114),
    [anon_sym_EQ_GT] = ACTIONS(1209),
    [anon_sym_QMARK_DOT] = ACTIONS(151),
    [anon_sym_new] = ACTIONS(1163),
    [anon_sym_PLUS_EQ] = ACTIONS(155),
    [anon_sym_DASH_EQ] = ACTIONS(155),
    [anon_sym_STAR_EQ] = ACTIONS(155),
    [anon_sym_SLASH_EQ] = ACTIONS(155),
    [anon_sym_PERCENT_EQ] = ACTIONS(155),
    [anon_sym_CARET_EQ] = ACTIONS(155),
    [anon_sym_AMP_EQ] = ACTIONS(155),
    [anon_sym_PIPE_EQ] = ACTIONS(155),
    [anon_sym_GT_GT_EQ] = ACTIONS(155),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(155),
    [anon_sym_LT_LT_EQ] = ACTIONS(155),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(155),
    [anon_sym_AMP_AMP_EQ] = ACTIONS(155),
    [anon_sym_PIPE_PIPE_EQ] = ACTIONS(155),
    [anon_sym_QMARK_QMARK_EQ] = ACTIONS(155),
    [anon_sym_AMP_AMP] = ACTIONS(114),
    [anon_sym_PIPE_PIPE] = ACTIONS(114),
    [anon_sym_GT_GT] = ACTIONS(114),
    [anon_sym_GT_GT_GT] = ACTIONS(114),
    [anon_sym_LT_LT] = ACTIONS(114),
    [anon_sym_AMP] = ACTIONS(159),
    [anon_sym_CARET] = ACTIONS(114),
    [anon_sym_PIPE] = ACTIONS(161),
    [anon_sym_PLUS] = ACTIONS(1165),
    [anon_sym_DASH] = ACTIONS(1165),
    [anon_sym_PERCENT] = ACTIONS(114),
    [anon_sym_STAR_STAR] = ACTIONS(114),
    [anon_sym_LT_EQ] = ACTIONS(151),
    [anon_sym_EQ_EQ] = ACTIONS(114),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(151),
    [anon_sym_BANG_EQ] = ACTIONS(114),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(151),
    [anon_sym_GT_EQ] = ACTIONS(151),
    [anon_sym_QMARK_QMARK] = ACTIONS(114),
    [anon_sym_instanceof] = ACTIONS(114),
    [anon_sym_void] = ACTIONS(202),
    [anon_sym_PLUS_PLUS] = ACTIONS(151),
    [anon_sym_DASH_DASH] = ACTIONS(151),
    [anon_sym_DQUOTE] = ACTIONS(1167),
    [anon_sym_SQUOTE] = ACTIONS(1169),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(1171),
    [sym_number] = ACTIONS(1173),
    [sym_this] = ACTIONS(1175),
    [sym_true] = ACTIONS(1177),
    [sym_false] = ACTIONS(1177),
    [sym_null] = ACTIONS(1177),
    [sym_undefined] = ACTIONS(1177),
    [anon_sym_readonly] = ACTIONS(1179),
    [anon_sym_QMARK] = ACTIONS(192),
    [anon_sym_any] = ACTIONS(202),
    [anon_sym_number] = ACTIONS(202),
    [anon_sym_boolean] = ACTIONS(202),
    [anon_sym_string] = ACTIONS(202),
    [anon_sym_symbol] = ACTIONS(202),
    [anon_sym_abstract] = ACTIONS(196),
    [anon_sym_infer] = ACTIONS(198),
    [anon_sym_keyof] = ACTIONS(200),
    [anon_sym_unknown] = ACTIONS(202),
    [anon_sym_never] = ACTIONS(202),
    [anon_sym_object] = ACTIONS(202),
    [anon_sym_LBRACE_PIPE] = ACTIONS(204),
    [sym__automatic_semicolon] = ACTIONS(151),
    [sym__ternary_qmark] = ACTIONS(151),
  },
  [97] = {
    [sym_nested_identifier] = STATE(4074),
    [sym_string] = STATE(2367),
    [sym_formal_parameters] = STATE(4073),
    [sym_nested_type_identifier] = STATE(2336),
    [sym__type] = STATE(2398),
    [sym_constructor_type] = STATE(2398),
    [sym__primary_type] = STATE(2373),
    [sym_template_literal_type] = STATE(2359),
    [sym_infer_type] = STATE(2398),
    [sym_conditional_type] = STATE(2359),
    [sym_generic_type] = STATE(2359),
    [sym_type_query] = STATE(2359),
    [sym_index_type_query] = STATE(2359),
    [sym_lookup_type] = STATE(2359),
    [sym_literal_type] = STATE(2359),
    [sym__number] = STATE(2355),
    [sym_existential_type] = STATE(2359),
    [sym_flow_maybe_type] = STATE(2359),
    [sym_parenthesized_type] = STATE(2359),
    [sym_predefined_type] = STATE(2359),
    [sym_object_type] = STATE(2359),
    [sym_type_parameters] = STATE(3731),
    [sym_array_type] = STATE(2359),
    [sym_tuple_type] = STATE(2359),
    [sym_readonly_type] = STATE(2398),
    [sym_union_type] = STATE(2359),
    [sym_intersection_type] = STATE(2359),
    [sym_function_type] = STATE(2398),
    [sym_identifier] = ACTIONS(1149),
    [anon_sym_STAR] = ACTIONS(109),
    [anon_sym_EQ] = ACTIONS(1211),
    [anon_sym_as] = ACTIONS(114),
    [anon_sym_LBRACE] = ACTIONS(1153),
    [anon_sym_COMMA] = ACTIONS(151),
    [anon_sym_RBRACE] = ACTIONS(151),
    [anon_sym_typeof] = ACTIONS(1155),
    [anon_sym_BANG] = ACTIONS(114),
    [anon_sym_LPAREN] = ACTIONS(1157),
    [anon_sym_in] = ACTIONS(114),
    [anon_sym_SEMI] = ACTIONS(151),
    [anon_sym_LBRACK] = ACTIONS(1159),
    [anon_sym_LT] = ACTIONS(1161),
    [anon_sym_GT] = ACTIONS(114),
    [anon_sym_SLASH] = ACTIONS(114),
    [anon_sym_DOT] = ACTIONS(114),
    [anon_sym_EQ_GT] = ACTIONS(1213),
    [anon_sym_QMARK_DOT] = ACTIONS(151),
    [anon_sym_new] = ACTIONS(1163),
    [anon_sym_PLUS_EQ] = ACTIONS(155),
    [anon_sym_DASH_EQ] = ACTIONS(155),
    [anon_sym_STAR_EQ] = ACTIONS(155),
    [anon_sym_SLASH_EQ] = ACTIONS(155),
    [anon_sym_PERCENT_EQ] = ACTIONS(155),
    [anon_sym_CARET_EQ] = ACTIONS(155),
    [anon_sym_AMP_EQ] = ACTIONS(155),
    [anon_sym_PIPE_EQ] = ACTIONS(155),
    [anon_sym_GT_GT_EQ] = ACTIONS(155),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(155),
    [anon_sym_LT_LT_EQ] = ACTIONS(155),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(155),
    [anon_sym_AMP_AMP_EQ] = ACTIONS(155),
    [anon_sym_PIPE_PIPE_EQ] = ACTIONS(155),
    [anon_sym_QMARK_QMARK_EQ] = ACTIONS(155),
    [anon_sym_AMP_AMP] = ACTIONS(114),
    [anon_sym_PIPE_PIPE] = ACTIONS(114),
    [anon_sym_GT_GT] = ACTIONS(114),
    [anon_sym_GT_GT_GT] = ACTIONS(114),
    [anon_sym_LT_LT] = ACTIONS(114),
    [anon_sym_AMP] = ACTIONS(159),
    [anon_sym_CARET] = ACTIONS(114),
    [anon_sym_PIPE] = ACTIONS(161),
    [anon_sym_PLUS] = ACTIONS(1165),
    [anon_sym_DASH] = ACTIONS(1165),
    [anon_sym_PERCENT] = ACTIONS(114),
    [anon_sym_STAR_STAR] = ACTIONS(114),
    [anon_sym_LT_EQ] = ACTIONS(151),
    [anon_sym_EQ_EQ] = ACTIONS(114),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(151),
    [anon_sym_BANG_EQ] = ACTIONS(114),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(151),
    [anon_sym_GT_EQ] = ACTIONS(151),
    [anon_sym_QMARK_QMARK] = ACTIONS(114),
    [anon_sym_instanceof] = ACTIONS(114),
    [anon_sym_void] = ACTIONS(202),
    [anon_sym_PLUS_PLUS] = ACTIONS(151),
    [anon_sym_DASH_DASH] = ACTIONS(151),
    [anon_sym_DQUOTE] = ACTIONS(1167),
    [anon_sym_SQUOTE] = ACTIONS(1169),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(1171),
    [sym_number] = ACTIONS(1173),
    [sym_this] = ACTIONS(1175),
    [sym_true] = ACTIONS(1177),
    [sym_false] = ACTIONS(1177),
    [sym_null] = ACTIONS(1177),
    [sym_undefined] = ACTIONS(1177),
    [anon_sym_readonly] = ACTIONS(1179),
    [anon_sym_QMARK] = ACTIONS(192),
    [anon_sym_any] = ACTIONS(202),
    [anon_sym_number] = ACTIONS(202),
    [anon_sym_boolean] = ACTIONS(202),
    [anon_sym_string] = ACTIONS(202),
    [anon_sym_symbol] = ACTIONS(202),
    [anon_sym_abstract] = ACTIONS(196),
    [anon_sym_infer] = ACTIONS(198),
    [anon_sym_keyof] = ACTIONS(200),
    [anon_sym_unknown] = ACTIONS(202),
    [anon_sym_never] = ACTIONS(202),
    [anon_sym_object] = ACTIONS(202),
    [anon_sym_LBRACE_PIPE] = ACTIONS(204),
    [sym__automatic_semicolon] = ACTIONS(151),
    [sym__ternary_qmark] = ACTIONS(151),
  },
  [98] = {
    [sym_declaration] = STATE(688),
    [sym_import] = STATE(1844),
    [sym_variable_declaration] = STATE(741),
    [sym_lexical_declaration] = STATE(741),
    [sym_parenthesized_expression] = STATE(1142),
    [sym_expression] = STATE(1729),
    [sym_primary_expression] = STATE(1799),
    [sym_yield_expression] = STATE(1798),
    [sym_object] = STATE(1844),
    [sym_object_pattern] = STATE(3982),
    [sym_array] = STATE(1844),
    [sym_array_pattern] = STATE(3982),
    [sym_class] = STATE(1844),
    [sym_class_declaration] = STATE(741),
    [sym_function] = STATE(1844),
    [sym_function_declaration] = STATE(741),
    [sym_generator_function] = STATE(1844),
    [sym_generator_function_declaration] = STATE(741),
    [sym_arrow_function] = STATE(1844),
    [sym__call_signature] = STATE(3980),
    [sym_call_expression] = STATE(1844),
    [sym_new_expression] = STATE(1798),
    [sym_await_expression] = STATE(1798),
    [sym_member_expression] = STATE(1142),
    [sym_subscript_expression] = STATE(1142),
    [sym_assignment_expression] = STATE(1798),
    [sym__augmented_assignment_lhs] = STATE(2347),
    [sym_augmented_assignment_expression] = STATE(1798),
    [sym__destructuring_pattern] = STATE(3982),
    [sym_ternary_expression] = STATE(1798),
    [sym_binary_expression] = STATE(1798),
    [sym_unary_expression] = STATE(1798),
    [sym_update_expression] = STATE(1798),
    [sym_string] = STATE(1844),
    [sym_template_string] = STATE(1844),
    [sym_regex] = STATE(1844),
    [sym_meta_property] = STATE(1844),
    [sym_decorator] = STATE(1149),
    [sym_formal_parameters] = STATE(2903),
    [sym_non_null_expression] = STATE(1142),
    [sym_function_signature] = STATE(741),
    [sym_type_assertion] = STATE(1798),
    [sym_as_expression] = STATE(1798),
    [sym_ambient_declaration] = STATE(741),
    [sym_abstract_class_declaration] = STATE(741),
    [sym_module] = STATE(741),
    [sym_internal_module] = STATE(140),
    [sym_import_alias] = STATE(741),
    [sym_interface_declaration] = STATE(741),
    [sym_enum_declaration] = STATE(741),
    [sym_type_alias_declaration] = STATE(741),
    [sym_type_arguments] = STATE(398),
    [sym_type_parameters] = STATE(3670),
    [aux_sym_export_statement_repeat1] = STATE(3118),
    [sym_identifier] = ACTIONS(1115),
    [anon_sym_export] = ACTIONS(877),
    [anon_sym_type] = ACTIONS(1215),
    [anon_sym_namespace] = ACTIONS(1217),
    [anon_sym_LBRACE] = ACTIONS(1097),
    [anon_sym_typeof] = ACTIONS(901),
    [anon_sym_import] = ACTIONS(1219),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(885),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_await] = ACTIONS(887),
    [anon_sym_yield] = ACTIONS(889),
    [anon_sym_LBRACK] = ACTIONS(63),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(69),
    [anon_sym_async] = ACTIONS(1221),
    [anon_sym_function] = ACTIONS(73),
    [anon_sym_new] = ACTIONS(1119),
    [anon_sym_PLUS] = ACTIONS(901),
    [anon_sym_DASH] = ACTIONS(901),
    [anon_sym_TILDE] = ACTIONS(885),
    [anon_sym_void] = ACTIONS(901),
    [anon_sym_delete] = ACTIONS(901),
    [anon_sym_PLUS_PLUS] = ACTIONS(903),
    [anon_sym_DASH_DASH] = ACTIONS(903),
    [anon_sym_DQUOTE] = ACTIONS(79),
    [anon_sym_SQUOTE] = ACTIONS(81),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(83),
    [sym_number] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(1121),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(877),
    [anon_sym_readonly] = ACTIONS(877),
    [anon_sym_get] = ACTIONS(877),
    [anon_sym_set] = ACTIONS(877),
    [anon_sym_declare] = ACTIONS(1223),
    [anon_sym_public] = ACTIONS(877),
    [anon_sym_private] = ACTIONS(877),
    [anon_sym_protected] = ACTIONS(877),
    [anon_sym_override] = ACTIONS(877),
    [anon_sym_module] = ACTIONS(1225),
    [anon_sym_any] = ACTIONS(877),
    [anon_sym_number] = ACTIONS(877),
    [anon_sym_boolean] = ACTIONS(877),
    [anon_sym_string] = ACTIONS(877),
    [anon_sym_symbol] = ACTIONS(877),
    [anon_sym_abstract] = ACTIONS(99),
    [anon_sym_interface] = ACTIONS(101),
    [anon_sym_enum] = ACTIONS(103),
  },
  [99] = {
    [sym_declaration] = STATE(688),
    [sym_import] = STATE(1844),
    [sym_variable_declaration] = STATE(741),
    [sym_lexical_declaration] = STATE(741),
    [sym_parenthesized_expression] = STATE(1142),
    [sym_expression] = STATE(1729),
    [sym_primary_expression] = STATE(1799),
    [sym_yield_expression] = STATE(1798),
    [sym_object] = STATE(1844),
    [sym_object_pattern] = STATE(3982),
    [sym_array] = STATE(1844),
    [sym_array_pattern] = STATE(3982),
    [sym_class] = STATE(1844),
    [sym_class_declaration] = STATE(741),
    [sym_function] = STATE(1844),
    [sym_function_declaration] = STATE(741),
    [sym_generator_function] = STATE(1844),
    [sym_generator_function_declaration] = STATE(741),
    [sym_arrow_function] = STATE(1844),
    [sym__call_signature] = STATE(3980),
    [sym_call_expression] = STATE(1844),
    [sym_new_expression] = STATE(1798),
    [sym_await_expression] = STATE(1798),
    [sym_member_expression] = STATE(1142),
    [sym_subscript_expression] = STATE(1142),
    [sym_assignment_expression] = STATE(1798),
    [sym__augmented_assignment_lhs] = STATE(2347),
    [sym_augmented_assignment_expression] = STATE(1798),
    [sym__destructuring_pattern] = STATE(3982),
    [sym_ternary_expression] = STATE(1798),
    [sym_binary_expression] = STATE(1798),
    [sym_unary_expression] = STATE(1798),
    [sym_update_expression] = STATE(1798),
    [sym_string] = STATE(1844),
    [sym_template_string] = STATE(1844),
    [sym_regex] = STATE(1844),
    [sym_meta_property] = STATE(1844),
    [sym_decorator] = STATE(1149),
    [sym_formal_parameters] = STATE(2903),
    [sym_non_null_expression] = STATE(1142),
    [sym_function_signature] = STATE(741),
    [sym_type_assertion] = STATE(1798),
    [sym_as_expression] = STATE(1798),
    [sym_ambient_declaration] = STATE(741),
    [sym_abstract_class_declaration] = STATE(741),
    [sym_module] = STATE(741),
    [sym_internal_module] = STATE(1746),
    [sym_import_alias] = STATE(741),
    [sym_interface_declaration] = STATE(741),
    [sym_enum_declaration] = STATE(741),
    [sym_type_alias_declaration] = STATE(741),
    [sym_type_arguments] = STATE(398),
    [sym_type_parameters] = STATE(3670),
    [aux_sym_export_statement_repeat1] = STATE(3022),
    [sym_identifier] = ACTIONS(1115),
    [anon_sym_export] = ACTIONS(877),
    [anon_sym_type] = ACTIONS(1215),
    [anon_sym_namespace] = ACTIONS(879),
    [anon_sym_LBRACE] = ACTIONS(1097),
    [anon_sym_typeof] = ACTIONS(901),
    [anon_sym_import] = ACTIONS(1219),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(885),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_await] = ACTIONS(887),
    [anon_sym_yield] = ACTIONS(889),
    [anon_sym_LBRACK] = ACTIONS(63),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(521),
    [anon_sym_async] = ACTIONS(1227),
    [anon_sym_function] = ACTIONS(525),
    [anon_sym_new] = ACTIONS(1119),
    [anon_sym_PLUS] = ACTIONS(901),
    [anon_sym_DASH] = ACTIONS(901),
    [anon_sym_TILDE] = ACTIONS(885),
    [anon_sym_void] = ACTIONS(901),
    [anon_sym_delete] = ACTIONS(901),
    [anon_sym_PLUS_PLUS] = ACTIONS(903),
    [anon_sym_DASH_DASH] = ACTIONS(903),
    [anon_sym_DQUOTE] = ACTIONS(79),
    [anon_sym_SQUOTE] = ACTIONS(81),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(83),
    [sym_number] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(1121),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(877),
    [anon_sym_readonly] = ACTIONS(877),
    [anon_sym_get] = ACTIONS(877),
    [anon_sym_set] = ACTIONS(877),
    [anon_sym_declare] = ACTIONS(1223),
    [anon_sym_public] = ACTIONS(877),
    [anon_sym_private] = ACTIONS(877),
    [anon_sym_protected] = ACTIONS(877),
    [anon_sym_override] = ACTIONS(877),
    [anon_sym_module] = ACTIONS(1225),
    [anon_sym_any] = ACTIONS(877),
    [anon_sym_number] = ACTIONS(877),
    [anon_sym_boolean] = ACTIONS(877),
    [anon_sym_string] = ACTIONS(877),
    [anon_sym_symbol] = ACTIONS(877),
    [anon_sym_abstract] = ACTIONS(99),
    [anon_sym_interface] = ACTIONS(101),
    [anon_sym_enum] = ACTIONS(103),
  },
  [100] = {
    [sym_declaration] = STATE(3196),
    [sym_import] = STATE(1844),
    [sym_variable_declaration] = STATE(3112),
    [sym_lexical_declaration] = STATE(3112),
    [sym_parenthesized_expression] = STATE(1142),
    [sym_expression] = STATE(1897),
    [sym_primary_expression] = STATE(1799),
    [sym_yield_expression] = STATE(1798),
    [sym_object] = STATE(1844),
    [sym_object_pattern] = STATE(3982),
    [sym_array] = STATE(1844),
    [sym_array_pattern] = STATE(3982),
    [sym_class] = STATE(1844),
    [sym_class_declaration] = STATE(3112),
    [sym_function] = STATE(1844),
    [sym_function_declaration] = STATE(3112),
    [sym_generator_function] = STATE(1844),
    [sym_generator_function_declaration] = STATE(3112),
    [sym_arrow_function] = STATE(1844),
    [sym__call_signature] = STATE(3980),
    [sym_call_expression] = STATE(1844),
    [sym_new_expression] = STATE(1798),
    [sym_await_expression] = STATE(1798),
    [sym_member_expression] = STATE(1142),
    [sym_subscript_expression] = STATE(1142),
    [sym_assignment_expression] = STATE(1798),
    [sym__augmented_assignment_lhs] = STATE(2347),
    [sym_augmented_assignment_expression] = STATE(1798),
    [sym__destructuring_pattern] = STATE(3982),
    [sym_ternary_expression] = STATE(1798),
    [sym_binary_expression] = STATE(1798),
    [sym_unary_expression] = STATE(1798),
    [sym_update_expression] = STATE(1798),
    [sym_string] = STATE(1844),
    [sym_template_string] = STATE(1844),
    [sym_regex] = STATE(1844),
    [sym_meta_property] = STATE(1844),
    [sym_decorator] = STATE(1149),
    [sym_formal_parameters] = STATE(2903),
    [sym_non_null_expression] = STATE(1142),
    [sym_function_signature] = STATE(3112),
    [sym_type_assertion] = STATE(1798),
    [sym_as_expression] = STATE(1798),
    [sym_ambient_declaration] = STATE(3112),
    [sym_abstract_class_declaration] = STATE(3112),
    [sym_module] = STATE(3112),
    [sym_internal_module] = STATE(1894),
    [sym_import_alias] = STATE(3112),
    [sym_interface_declaration] = STATE(3112),
    [sym_enum_declaration] = STATE(3112),
    [sym_type_alias_declaration] = STATE(3112),
    [sym_type_arguments] = STATE(398),
    [sym_type_parameters] = STATE(3670),
    [aux_sym_export_statement_repeat1] = STATE(3268),
    [sym_identifier] = ACTIONS(1115),
    [anon_sym_export] = ACTIONS(877),
    [anon_sym_type] = ACTIONS(1181),
    [anon_sym_namespace] = ACTIONS(879),
    [anon_sym_LBRACE] = ACTIONS(1097),
    [anon_sym_typeof] = ACTIONS(901),
    [anon_sym_import] = ACTIONS(1183),
    [anon_sym_var] = ACTIONS(1185),
    [anon_sym_let] = ACTIONS(1187),
    [anon_sym_const] = ACTIONS(1189),
    [anon_sym_BANG] = ACTIONS(885),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_await] = ACTIONS(887),
    [anon_sym_yield] = ACTIONS(889),
    [anon_sym_LBRACK] = ACTIONS(63),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(1191),
    [anon_sym_async] = ACTIONS(1193),
    [anon_sym_function] = ACTIONS(1195),
    [anon_sym_new] = ACTIONS(1119),
    [anon_sym_PLUS] = ACTIONS(901),
    [anon_sym_DASH] = ACTIONS(901),
    [anon_sym_TILDE] = ACTIONS(885),
    [anon_sym_void] = ACTIONS(901),
    [anon_sym_delete] = ACTIONS(901),
    [anon_sym_PLUS_PLUS] = ACTIONS(903),
    [anon_sym_DASH_DASH] = ACTIONS(903),
    [anon_sym_DQUOTE] = ACTIONS(79),
    [anon_sym_SQUOTE] = ACTIONS(81),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(83),
    [sym_number] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(1121),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(877),
    [anon_sym_readonly] = ACTIONS(877),
    [anon_sym_get] = ACTIONS(877),
    [anon_sym_set] = ACTIONS(877),
    [anon_sym_declare] = ACTIONS(1197),
    [anon_sym_public] = ACTIONS(877),
    [anon_sym_private] = ACTIONS(877),
    [anon_sym_protected] = ACTIONS(877),
    [anon_sym_override] = ACTIONS(877),
    [anon_sym_module] = ACTIONS(1199),
    [anon_sym_any] = ACTIONS(877),
    [anon_sym_number] = ACTIONS(877),
    [anon_sym_boolean] = ACTIONS(877),
    [anon_sym_string] = ACTIONS(877),
    [anon_sym_symbol] = ACTIONS(877),
    [anon_sym_abstract] = ACTIONS(1201),
    [anon_sym_interface] = ACTIONS(1203),
    [anon_sym_enum] = ACTIONS(1205),
  },
  [101] = {
    [sym_declaration] = STATE(689),
    [sym_import] = STATE(1844),
    [sym_variable_declaration] = STATE(741),
    [sym_lexical_declaration] = STATE(741),
    [sym_parenthesized_expression] = STATE(1142),
    [sym_expression] = STATE(1841),
    [sym_primary_expression] = STATE(1799),
    [sym_yield_expression] = STATE(1798),
    [sym_object] = STATE(1844),
    [sym_object_pattern] = STATE(3982),
    [sym_array] = STATE(1844),
    [sym_array_pattern] = STATE(3982),
    [sym_class] = STATE(1844),
    [sym_class_declaration] = STATE(741),
    [sym_function] = STATE(1844),
    [sym_function_declaration] = STATE(741),
    [sym_generator_function] = STATE(1844),
    [sym_generator_function_declaration] = STATE(741),
    [sym_arrow_function] = STATE(1844),
    [sym__call_signature] = STATE(3980),
    [sym_call_expression] = STATE(1844),
    [sym_new_expression] = STATE(1798),
    [sym_await_expression] = STATE(1798),
    [sym_member_expression] = STATE(1142),
    [sym_subscript_expression] = STATE(1142),
    [sym_assignment_expression] = STATE(1798),
    [sym__augmented_assignment_lhs] = STATE(2347),
    [sym_augmented_assignment_expression] = STATE(1798),
    [sym__destructuring_pattern] = STATE(3982),
    [sym_ternary_expression] = STATE(1798),
    [sym_binary_expression] = STATE(1798),
    [sym_unary_expression] = STATE(1798),
    [sym_update_expression] = STATE(1798),
    [sym_string] = STATE(1844),
    [sym_template_string] = STATE(1844),
    [sym_regex] = STATE(1844),
    [sym_meta_property] = STATE(1844),
    [sym_decorator] = STATE(1149),
    [sym_formal_parameters] = STATE(2903),
    [sym_non_null_expression] = STATE(1142),
    [sym_function_signature] = STATE(741),
    [sym_type_assertion] = STATE(1798),
    [sym_as_expression] = STATE(1798),
    [sym_ambient_declaration] = STATE(741),
    [sym_abstract_class_declaration] = STATE(741),
    [sym_module] = STATE(741),
    [sym_internal_module] = STATE(140),
    [sym_import_alias] = STATE(741),
    [sym_interface_declaration] = STATE(741),
    [sym_enum_declaration] = STATE(741),
    [sym_type_alias_declaration] = STATE(741),
    [sym_type_arguments] = STATE(398),
    [sym_type_parameters] = STATE(3670),
    [aux_sym_export_statement_repeat1] = STATE(3118),
    [sym_identifier] = ACTIONS(1115),
    [anon_sym_export] = ACTIONS(877),
    [anon_sym_type] = ACTIONS(1215),
    [anon_sym_namespace] = ACTIONS(1217),
    [anon_sym_LBRACE] = ACTIONS(1097),
    [anon_sym_typeof] = ACTIONS(901),
    [anon_sym_import] = ACTIONS(1219),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(885),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_await] = ACTIONS(887),
    [anon_sym_yield] = ACTIONS(889),
    [anon_sym_LBRACK] = ACTIONS(63),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(69),
    [anon_sym_async] = ACTIONS(1221),
    [anon_sym_function] = ACTIONS(73),
    [anon_sym_new] = ACTIONS(1119),
    [anon_sym_PLUS] = ACTIONS(901),
    [anon_sym_DASH] = ACTIONS(901),
    [anon_sym_TILDE] = ACTIONS(885),
    [anon_sym_void] = ACTIONS(901),
    [anon_sym_delete] = ACTIONS(901),
    [anon_sym_PLUS_PLUS] = ACTIONS(903),
    [anon_sym_DASH_DASH] = ACTIONS(903),
    [anon_sym_DQUOTE] = ACTIONS(79),
    [anon_sym_SQUOTE] = ACTIONS(81),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(83),
    [sym_number] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(1121),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(877),
    [anon_sym_readonly] = ACTIONS(877),
    [anon_sym_get] = ACTIONS(877),
    [anon_sym_set] = ACTIONS(877),
    [anon_sym_declare] = ACTIONS(1223),
    [anon_sym_public] = ACTIONS(877),
    [anon_sym_private] = ACTIONS(877),
    [anon_sym_protected] = ACTIONS(877),
    [anon_sym_override] = ACTIONS(877),
    [anon_sym_module] = ACTIONS(1225),
    [anon_sym_any] = ACTIONS(877),
    [anon_sym_number] = ACTIONS(877),
    [anon_sym_boolean] = ACTIONS(877),
    [anon_sym_string] = ACTIONS(877),
    [anon_sym_symbol] = ACTIONS(877),
    [anon_sym_abstract] = ACTIONS(99),
    [anon_sym_interface] = ACTIONS(101),
    [anon_sym_enum] = ACTIONS(103),
  },
  [102] = {
    [sym_declaration] = STATE(689),
    [sym_import] = STATE(1844),
    [sym_variable_declaration] = STATE(741),
    [sym_lexical_declaration] = STATE(741),
    [sym_parenthesized_expression] = STATE(1142),
    [sym_expression] = STATE(1841),
    [sym_primary_expression] = STATE(1799),
    [sym_yield_expression] = STATE(1798),
    [sym_object] = STATE(1844),
    [sym_object_pattern] = STATE(3982),
    [sym_array] = STATE(1844),
    [sym_array_pattern] = STATE(3982),
    [sym_class] = STATE(1844),
    [sym_class_declaration] = STATE(741),
    [sym_function] = STATE(1844),
    [sym_function_declaration] = STATE(741),
    [sym_generator_function] = STATE(1844),
    [sym_generator_function_declaration] = STATE(741),
    [sym_arrow_function] = STATE(1844),
    [sym__call_signature] = STATE(3980),
    [sym_call_expression] = STATE(1844),
    [sym_new_expression] = STATE(1798),
    [sym_await_expression] = STATE(1798),
    [sym_member_expression] = STATE(1142),
    [sym_subscript_expression] = STATE(1142),
    [sym_assignment_expression] = STATE(1798),
    [sym__augmented_assignment_lhs] = STATE(2347),
    [sym_augmented_assignment_expression] = STATE(1798),
    [sym__destructuring_pattern] = STATE(3982),
    [sym_ternary_expression] = STATE(1798),
    [sym_binary_expression] = STATE(1798),
    [sym_unary_expression] = STATE(1798),
    [sym_update_expression] = STATE(1798),
    [sym_string] = STATE(1844),
    [sym_template_string] = STATE(1844),
    [sym_regex] = STATE(1844),
    [sym_meta_property] = STATE(1844),
    [sym_decorator] = STATE(1149),
    [sym_formal_parameters] = STATE(2903),
    [sym_non_null_expression] = STATE(1142),
    [sym_function_signature] = STATE(741),
    [sym_type_assertion] = STATE(1798),
    [sym_as_expression] = STATE(1798),
    [sym_ambient_declaration] = STATE(741),
    [sym_abstract_class_declaration] = STATE(741),
    [sym_module] = STATE(741),
    [sym_internal_module] = STATE(1746),
    [sym_import_alias] = STATE(741),
    [sym_interface_declaration] = STATE(741),
    [sym_enum_declaration] = STATE(741),
    [sym_type_alias_declaration] = STATE(741),
    [sym_type_arguments] = STATE(398),
    [sym_type_parameters] = STATE(3670),
    [aux_sym_export_statement_repeat1] = STATE(3022),
    [sym_identifier] = ACTIONS(1115),
    [anon_sym_export] = ACTIONS(877),
    [anon_sym_type] = ACTIONS(1215),
    [anon_sym_namespace] = ACTIONS(879),
    [anon_sym_LBRACE] = ACTIONS(1097),
    [anon_sym_typeof] = ACTIONS(901),
    [anon_sym_import] = ACTIONS(1219),
    [anon_sym_var] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_BANG] = ACTIONS(885),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_await] = ACTIONS(887),
    [anon_sym_yield] = ACTIONS(889),
    [anon_sym_LBRACK] = ACTIONS(63),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(67),
    [anon_sym_class] = ACTIONS(521),
    [anon_sym_async] = ACTIONS(1227),
    [anon_sym_function] = ACTIONS(525),
    [anon_sym_new] = ACTIONS(1119),
    [anon_sym_PLUS] = ACTIONS(901),
    [anon_sym_DASH] = ACTIONS(901),
    [anon_sym_TILDE] = ACTIONS(885),
    [anon_sym_void] = ACTIONS(901),
    [anon_sym_delete] = ACTIONS(901),
    [anon_sym_PLUS_PLUS] = ACTIONS(903),
    [anon_sym_DASH_DASH] = ACTIONS(903),
    [anon_sym_DQUOTE] = ACTIONS(79),
    [anon_sym_SQUOTE] = ACTIONS(81),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(83),
    [sym_number] = ACTIONS(85),
    [sym_this] = ACTIONS(87),
    [sym_super] = ACTIONS(87),
    [sym_true] = ACTIONS(87),
    [sym_false] = ACTIONS(87),
    [sym_null] = ACTIONS(87),
    [sym_undefined] = ACTIONS(1121),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(877),
    [anon_sym_readonly] = ACTIONS(877),
    [anon_sym_get] = ACTIONS(877),
    [anon_sym_set] = ACTIONS(877),
    [anon_sym_declare] = ACTIONS(1223),
    [anon_sym_public] = ACTIONS(877),
    [anon_sym_private] = ACTIONS(877),
    [anon_sym_protected] = ACTIONS(877),
    [anon_sym_override] = ACTIONS(877),
    [anon_sym_module] = ACTIONS(1225),
    [anon_sym_any] = ACTIONS(877),
    [anon_sym_number] = ACTIONS(877),
    [anon_sym_boolean] = ACTIONS(877),
    [anon_sym_string] = ACTIONS(877),
    [anon_sym_symbol] = ACTIONS(877),
    [anon_sym_abstract] = ACTIONS(99),
    [anon_sym_interface] = ACTIONS(101),
    [anon_sym_enum] = ACTIONS(103),
  },
  [103] = {
    [sym_nested_identifier] = STATE(4074),
    [sym_string] = STATE(2367),
    [sym_formal_parameters] = STATE(4073),
    [sym_nested_type_identifier] = STATE(2336),
    [sym__type] = STATE(2398),
    [sym_constructor_type] = STATE(2398),
    [sym__primary_type] = STATE(2373),
    [sym_template_literal_type] = STATE(2359),
    [sym_infer_type] = STATE(2398),
    [sym_conditional_type] = STATE(2359),
    [sym_generic_type] = STATE(2359),
    [sym_type_query] = STATE(2359),
    [sym_index_type_query] = STATE(2359),
    [sym_lookup_type] = STATE(2359),
    [sym_literal_type] = STATE(2359),
    [sym__number] = STATE(2355),
    [sym_existential_type] = STATE(2359),
    [sym_flow_maybe_type] = STATE(2359),
    [sym_parenthesized_type] = STATE(2359),
    [sym_predefined_type] = STATE(2359),
    [sym_object_type] = STATE(2359),
    [sym_type_parameters] = STATE(3731),
    [sym_array_type] = STATE(2359),
    [sym_tuple_type] = STATE(2359),
    [sym_readonly_type] = STATE(2398),
    [sym_union_type] = STATE(2359),
    [sym_intersection_type] = STATE(2359),
    [sym_function_type] = STATE(2398),
    [sym_identifier] = ACTIONS(1149),
    [anon_sym_STAR] = ACTIONS(109),
    [anon_sym_EQ] = ACTIONS(206),
    [anon_sym_as] = ACTIONS(114),
    [anon_sym_LBRACE] = ACTIONS(1153),
    [anon_sym_COMMA] = ACTIONS(209),
    [anon_sym_typeof] = ACTIONS(1155),
    [anon_sym_BANG] = ACTIONS(114),
    [anon_sym_LPAREN] = ACTIONS(1157),
    [anon_sym_RPAREN] = ACTIONS(209),
    [anon_sym_in] = ACTIONS(114),
    [anon_sym_COLON] = ACTIONS(209),
    [anon_sym_LBRACK] = ACTIONS(1159),
    [anon_sym_LT] = ACTIONS(1161),
    [anon_sym_GT] = ACTIONS(114),
    [anon_sym_SLASH] = ACTIONS(114),
    [anon_sym_DOT] = ACTIONS(114),
    [anon_sym_EQ_GT] = ACTIONS(211),
    [anon_sym_QMARK_DOT] = ACTIONS(151),
    [anon_sym_new] = ACTIONS(1163),
    [anon_sym_PLUS_EQ] = ACTIONS(155),
    [anon_sym_DASH_EQ] = ACTIONS(155),
    [anon_sym_STAR_EQ] = ACTIONS(155),
    [anon_sym_SLASH_EQ] = ACTIONS(155),
    [anon_sym_PERCENT_EQ] = ACTIONS(155),
    [anon_sym_CARET_EQ] = ACTIONS(155),
    [anon_sym_AMP_EQ] = ACTIONS(155),
    [anon_sym_PIPE_EQ] = ACTIONS(155),
    [anon_sym_GT_GT_EQ] = ACTIONS(155),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(155),
    [anon_sym_LT_LT_EQ] = ACTIONS(155),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(155),
    [anon_sym_AMP_AMP_EQ] = ACTIONS(155),
    [anon_sym_PIPE_PIPE_EQ] = ACTIONS(155),
    [anon_sym_QMARK_QMARK_EQ] = ACTIONS(155),
    [anon_sym_AMP_AMP] = ACTIONS(114),
    [anon_sym_PIPE_PIPE] = ACTIONS(114),
    [anon_sym_GT_GT] = ACTIONS(114),
    [anon_sym_GT_GT_GT] = ACTIONS(114),
    [anon_sym_LT_LT] = ACTIONS(114),
    [anon_sym_AMP] = ACTIONS(159),
    [anon_sym_CARET] = ACTIONS(114),
    [anon_sym_PIPE] = ACTIONS(161),
    [anon_sym_PLUS] = ACTIONS(1165),
    [anon_sym_DASH] = ACTIONS(1165),
    [anon_sym_PERCENT] = ACTIONS(114),
    [anon_sym_STAR_STAR] = ACTIONS(114),
    [anon_sym_LT_EQ] = ACTIONS(151),
    [anon_sym_EQ_EQ] = ACTIONS(114),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(151),
    [anon_sym_BANG_EQ] = ACTIONS(114),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(151),
    [anon_sym_GT_EQ] = ACTIONS(151),
    [anon_sym_QMARK_QMARK] = ACTIONS(114),
    [anon_sym_instanceof] = ACTIONS(114),
    [anon_sym_void] = ACTIONS(202),
    [anon_sym_PLUS_PLUS] = ACTIONS(151),
    [anon_sym_DASH_DASH] = ACTIONS(151),
    [anon_sym_DQUOTE] = ACTIONS(1167),
    [anon_sym_SQUOTE] = ACTIONS(1169),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(1171),
    [sym_number] = ACTIONS(1173),
    [sym_this] = ACTIONS(1175),
    [sym_true] = ACTIONS(1177),
    [sym_false] = ACTIONS(1177),
    [sym_null] = ACTIONS(1177),
    [sym_undefined] = ACTIONS(1177),
    [anon_sym_readonly] = ACTIONS(1179),
    [anon_sym_QMARK] = ACTIONS(192),
    [anon_sym_any] = ACTIONS(202),
    [anon_sym_number] = ACTIONS(202),
    [anon_sym_boolean] = ACTIONS(202),
    [anon_sym_string] = ACTIONS(202),
    [anon_sym_symbol] = ACTIONS(202),
    [anon_sym_abstract] = ACTIONS(196),
    [anon_sym_infer] = ACTIONS(198),
    [anon_sym_keyof] = ACTIONS(200),
    [anon_sym_unknown] = ACTIONS(202),
    [anon_sym_never] = ACTIONS(202),
    [anon_sym_object] = ACTIONS(202),
    [anon_sym_LBRACE_PIPE] = ACTIONS(204),
    [sym__ternary_qmark] = ACTIONS(151),
  },
  [104] = {
    [sym_nested_identifier] = STATE(4074),
    [sym_string] = STATE(2367),
    [sym_formal_parameters] = STATE(4073),
    [sym_nested_type_identifier] = STATE(2336),
    [sym__type] = STATE(2398),
    [sym_constructor_type] = STATE(2398),
    [sym__primary_type] = STATE(2373),
    [sym_template_literal_type] = STATE(2359),
    [sym_infer_type] = STATE(2398),
    [sym_conditional_type] = STATE(2359),
    [sym_generic_type] = STATE(2359),
    [sym_type_query] = STATE(2359),
    [sym_index_type_query] = STATE(2359),
    [sym_lookup_type] = STATE(2359),
    [sym_literal_type] = STATE(2359),
    [sym__number] = STATE(2355),
    [sym_existential_type] = STATE(2359),
    [sym_flow_maybe_type] = STATE(2359),
    [sym_parenthesized_type] = STATE(2359),
    [sym_predefined_type] = STATE(2359),
    [sym_object_type] = STATE(2359),
    [sym_type_parameters] = STATE(3731),
    [sym_array_type] = STATE(2359),
    [sym_tuple_type] = STATE(2359),
    [sym_readonly_type] = STATE(2398),
    [sym_union_type] = STATE(2359),
    [sym_intersection_type] = STATE(2359),
    [sym_function_type] = STATE(2398),
    [sym_identifier] = ACTIONS(1149),
    [anon_sym_STAR] = ACTIONS(109),
    [anon_sym_EQ] = ACTIONS(1151),
    [anon_sym_as] = ACTIONS(114),
    [anon_sym_LBRACE] = ACTIONS(1153),
    [anon_sym_COMMA] = ACTIONS(1229),
    [anon_sym_typeof] = ACTIONS(1155),
    [anon_sym_BANG] = ACTIONS(114),
    [anon_sym_LPAREN] = ACTIONS(1157),
    [anon_sym_in] = ACTIONS(114),
    [anon_sym_COLON] = ACTIONS(1232),
    [anon_sym_LBRACK] = ACTIONS(1159),
    [anon_sym_RBRACK] = ACTIONS(1229),
    [anon_sym_LT] = ACTIONS(1161),
    [anon_sym_GT] = ACTIONS(114),
    [anon_sym_SLASH] = ACTIONS(114),
    [anon_sym_DOT] = ACTIONS(114),
    [anon_sym_EQ_GT] = ACTIONS(149),
    [anon_sym_QMARK_DOT] = ACTIONS(151),
    [anon_sym_new] = ACTIONS(1163),
    [anon_sym_PLUS_EQ] = ACTIONS(155),
    [anon_sym_DASH_EQ] = ACTIONS(155),
    [anon_sym_STAR_EQ] = ACTIONS(155),
    [anon_sym_SLASH_EQ] = ACTIONS(155),
    [anon_sym_PERCENT_EQ] = ACTIONS(155),
    [anon_sym_CARET_EQ] = ACTIONS(155),
    [anon_sym_AMP_EQ] = ACTIONS(155),
    [anon_sym_PIPE_EQ] = ACTIONS(155),
    [anon_sym_GT_GT_EQ] = ACTIONS(155),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(155),
    [anon_sym_LT_LT_EQ] = ACTIONS(155),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(155),
    [anon_sym_AMP_AMP_EQ] = ACTIONS(155),
    [anon_sym_PIPE_PIPE_EQ] = ACTIONS(155),
    [anon_sym_QMARK_QMARK_EQ] = ACTIONS(155),
    [anon_sym_AMP_AMP] = ACTIONS(114),
    [anon_sym_PIPE_PIPE] = ACTIONS(114),
    [anon_sym_GT_GT] = ACTIONS(114),
    [anon_sym_GT_GT_GT] = ACTIONS(114),
    [anon_sym_LT_LT] = ACTIONS(114),
    [anon_sym_AMP] = ACTIONS(159),
    [anon_sym_CARET] = ACTIONS(114),
    [anon_sym_PIPE] = ACTIONS(161),
    [anon_sym_PLUS] = ACTIONS(1165),
    [anon_sym_DASH] = ACTIONS(1165),
    [anon_sym_PERCENT] = ACTIONS(114),
    [anon_sym_STAR_STAR] = ACTIONS(114),
    [anon_sym_LT_EQ] = ACTIONS(151),
    [anon_sym_EQ_EQ] = ACTIONS(114),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(151),
    [anon_sym_BANG_EQ] = ACTIONS(114),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(151),
    [anon_sym_GT_EQ] = ACTIONS(151),
    [anon_sym_QMARK_QMARK] = ACTIONS(114),
    [anon_sym_instanceof] = ACTIONS(114),
    [anon_sym_void] = ACTIONS(202),
    [anon_sym_PLUS_PLUS] = ACTIONS(151),
    [anon_sym_DASH_DASH] = ACTIONS(151),
    [anon_sym_DQUOTE] = ACTIONS(1167),
    [anon_sym_SQUOTE] = ACTIONS(1169),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(1171),
    [sym_number] = ACTIONS(1173),
    [sym_this] = ACTIONS(1175),
    [sym_true] = ACTIONS(1177),
    [sym_false] = ACTIONS(1177),
    [sym_null] = ACTIONS(1177),
    [sym_undefined] = ACTIONS(1177),
    [anon_sym_readonly] = ACTIONS(1179),
    [anon_sym_QMARK] = ACTIONS(192),
    [anon_sym_any] = ACTIONS(202),
    [anon_sym_number] = ACTIONS(202),
    [anon_sym_boolean] = ACTIONS(202),
    [anon_sym_string] = ACTIONS(202),
    [anon_sym_symbol] = ACTIONS(202),
    [anon_sym_abstract] = ACTIONS(196),
    [anon_sym_infer] = ACTIONS(198),
    [anon_sym_keyof] = ACTIONS(200),
    [anon_sym_unknown] = ACTIONS(202),
    [anon_sym_never] = ACTIONS(202),
    [anon_sym_object] = ACTIONS(202),
    [anon_sym_LBRACE_PIPE] = ACTIONS(204),
    [sym__ternary_qmark] = ACTIONS(151),
  },
  [105] = {
    [sym_nested_identifier] = STATE(4074),
    [sym_string] = STATE(2367),
    [sym_formal_parameters] = STATE(4073),
    [sym_nested_type_identifier] = STATE(2336),
    [sym__type] = STATE(2398),
    [sym_constructor_type] = STATE(2398),
    [sym__primary_type] = STATE(2373),
    [sym_template_literal_type] = STATE(2359),
    [sym_infer_type] = STATE(2398),
    [sym_conditional_type] = STATE(2359),
    [sym_generic_type] = STATE(2359),
    [sym_type_query] = STATE(2359),
    [sym_index_type_query] = STATE(2359),
    [sym_lookup_type] = STATE(2359),
    [sym_literal_type] = STATE(2359),
    [sym__number] = STATE(2355),
    [sym_existential_type] = STATE(2359),
    [sym_flow_maybe_type] = STATE(2359),
    [sym_parenthesized_type] = STATE(2359),
    [sym_predefined_type] = STATE(2359),
    [sym_object_type] = STATE(2359),
    [sym_type_parameters] = STATE(3731),
    [sym_array_type] = STATE(2359),
    [sym_tuple_type] = STATE(2359),
    [sym_readonly_type] = STATE(2398),
    [sym_union_type] = STATE(2359),
    [sym_intersection_type] = STATE(2359),
    [sym_function_type] = STATE(2398),
    [sym_identifier] = ACTIONS(1149),
    [anon_sym_STAR] = ACTIONS(109),
    [anon_sym_EQ] = ACTIONS(111),
    [anon_sym_as] = ACTIONS(114),
    [anon_sym_LBRACE] = ACTIONS(1153),
    [anon_sym_COMMA] = ACTIONS(120),
    [anon_sym_typeof] = ACTIONS(1155),
    [anon_sym_BANG] = ACTIONS(114),
    [anon_sym_LPAREN] = ACTIONS(1157),
    [anon_sym_in] = ACTIONS(114),
    [anon_sym_LBRACK] = ACTIONS(1159),
    [anon_sym_RBRACK] = ACTIONS(120),
    [anon_sym_LT] = ACTIONS(1161),
    [anon_sym_GT] = ACTIONS(114),
    [anon_sym_SLASH] = ACTIONS(114),
    [anon_sym_DOT] = ACTIONS(114),
    [anon_sym_EQ_GT] = ACTIONS(149),
    [anon_sym_QMARK_DOT] = ACTIONS(151),
    [anon_sym_new] = ACTIONS(1163),
    [anon_sym_PLUS_EQ] = ACTIONS(155),
    [anon_sym_DASH_EQ] = ACTIONS(155),
    [anon_sym_STAR_EQ] = ACTIONS(155),
    [anon_sym_SLASH_EQ] = ACTIONS(155),
    [anon_sym_PERCENT_EQ] = ACTIONS(155),
    [anon_sym_CARET_EQ] = ACTIONS(155),
    [anon_sym_AMP_EQ] = ACTIONS(155),
    [anon_sym_PIPE_EQ] = ACTIONS(155),
    [anon_sym_GT_GT_EQ] = ACTIONS(155),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(155),
    [anon_sym_LT_LT_EQ] = ACTIONS(155),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(155),
    [anon_sym_AMP_AMP_EQ] = ACTIONS(155),
    [anon_sym_PIPE_PIPE_EQ] = ACTIONS(155),
    [anon_sym_QMARK_QMARK_EQ] = ACTIONS(155),
    [anon_sym_AMP_AMP] = ACTIONS(114),
    [anon_sym_PIPE_PIPE] = ACTIONS(114),
    [anon_sym_GT_GT] = ACTIONS(114),
    [anon_sym_GT_GT_GT] = ACTIONS(114),
    [anon_sym_LT_LT] = ACTIONS(114),
    [anon_sym_AMP] = ACTIONS(159),
    [anon_sym_CARET] = ACTIONS(114),
    [anon_sym_PIPE] = ACTIONS(161),
    [anon_sym_PLUS] = ACTIONS(1165),
    [anon_sym_DASH] = ACTIONS(1165),
    [anon_sym_PERCENT] = ACTIONS(114),
    [anon_sym_STAR_STAR] = ACTIONS(114),
    [anon_sym_LT_EQ] = ACTIONS(151),
    [anon_sym_EQ_EQ] = ACTIONS(114),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(151),
    [anon_sym_BANG_EQ] = ACTIONS(114),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(151),
    [anon_sym_GT_EQ] = ACTIONS(151),
    [anon_sym_QMARK_QMARK] = ACTIONS(114),
    [anon_sym_instanceof] = ACTIONS(114),
    [anon_sym_void] = ACTIONS(202),
    [anon_sym_PLUS_PLUS] = ACTIONS(151),
    [anon_sym_DASH_DASH] = ACTIONS(151),
    [anon_sym_DQUOTE] = ACTIONS(1167),
    [anon_sym_SQUOTE] = ACTIONS(1169),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(1171),
    [sym_number] = ACTIONS(1173),
    [sym_this] = ACTIONS(1175),
    [sym_true] = ACTIONS(1177),
    [sym_false] = ACTIONS(1177),
    [sym_null] = ACTIONS(1177),
    [sym_undefined] = ACTIONS(1177),
    [anon_sym_readonly] = ACTIONS(1179),
    [anon_sym_QMARK] = ACTIONS(192),
    [anon_sym_any] = ACTIONS(202),
    [anon_sym_number] = ACTIONS(202),
    [anon_sym_boolean] = ACTIONS(202),
    [anon_sym_string] = ACTIONS(202),
    [anon_sym_symbol] = ACTIONS(202),
    [anon_sym_abstract] = ACTIONS(196),
    [anon_sym_infer] = ACTIONS(198),
    [anon_sym_keyof] = ACTIONS(200),
    [anon_sym_unknown] = ACTIONS(202),
    [anon_sym_never] = ACTIONS(202),
    [anon_sym_object] = ACTIONS(202),
    [anon_sym_LBRACE_PIPE] = ACTIONS(204),
    [sym__ternary_qmark] = ACTIONS(151),
  },
  [106] = {
    [sym_nested_identifier] = STATE(4074),
    [sym_string] = STATE(2367),
    [sym_formal_parameters] = STATE(4073),
    [sym_nested_type_identifier] = STATE(2336),
    [sym__type] = STATE(2398),
    [sym_constructor_type] = STATE(2398),
    [sym__primary_type] = STATE(2373),
    [sym_template_literal_type] = STATE(2359),
    [sym_infer_type] = STATE(2398),
    [sym_conditional_type] = STATE(2359),
    [sym_generic_type] = STATE(2359),
    [sym_type_query] = STATE(2359),
    [sym_index_type_query] = STATE(2359),
    [sym_lookup_type] = STATE(2359),
    [sym_literal_type] = STATE(2359),
    [sym__number] = STATE(2355),
    [sym_existential_type] = STATE(2359),
    [sym_flow_maybe_type] = STATE(2359),
    [sym_parenthesized_type] = STATE(2359),
    [sym_predefined_type] = STATE(2359),
    [sym_object_type] = STATE(2359),
    [sym_type_parameters] = STATE(3731),
    [sym_array_type] = STATE(2359),
    [sym_tuple_type] = STATE(2359),
    [sym_readonly_type] = STATE(2398),
    [sym_union_type] = STATE(2359),
    [sym_intersection_type] = STATE(2359),
    [sym_function_type] = STATE(2398),
    [sym_identifier] = ACTIONS(1149),
    [anon_sym_STAR] = ACTIONS(109),
    [anon_sym_EQ] = ACTIONS(1234),
    [anon_sym_as] = ACTIONS(114),
    [anon_sym_LBRACE] = ACTIONS(1153),
    [anon_sym_typeof] = ACTIONS(1155),
    [anon_sym_BANG] = ACTIONS(114),
    [anon_sym_LPAREN] = ACTIONS(1157),
    [anon_sym_in] = ACTIONS(114),
    [anon_sym_SEMI] = ACTIONS(151),
    [anon_sym_LBRACK] = ACTIONS(1159),
    [anon_sym_LT] = ACTIONS(1161),
    [anon_sym_GT] = ACTIONS(114),
    [anon_sym_SLASH] = ACTIONS(114),
    [anon_sym_DOT] = ACTIONS(114),
    [anon_sym_EQ_GT] = ACTIONS(1236),
    [anon_sym_QMARK_DOT] = ACTIONS(151),
    [anon_sym_new] = ACTIONS(1163),
    [anon_sym_PLUS_EQ] = ACTIONS(155),
    [anon_sym_DASH_EQ] = ACTIONS(155),
    [anon_sym_STAR_EQ] = ACTIONS(155),
    [anon_sym_SLASH_EQ] = ACTIONS(155),
    [anon_sym_PERCENT_EQ] = ACTIONS(155),
    [anon_sym_CARET_EQ] = ACTIONS(155),
    [anon_sym_AMP_EQ] = ACTIONS(155),
    [anon_sym_PIPE_EQ] = ACTIONS(155),
    [anon_sym_GT_GT_EQ] = ACTIONS(155),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(155),
    [anon_sym_LT_LT_EQ] = ACTIONS(155),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(155),
    [anon_sym_AMP_AMP_EQ] = ACTIONS(155),
    [anon_sym_PIPE_PIPE_EQ] = ACTIONS(155),
    [anon_sym_QMARK_QMARK_EQ] = ACTIONS(155),
    [anon_sym_AMP_AMP] = ACTIONS(114),
    [anon_sym_PIPE_PIPE] = ACTIONS(114),
    [anon_sym_GT_GT] = ACTIONS(114),
    [anon_sym_GT_GT_GT] = ACTIONS(114),
    [anon_sym_LT_LT] = ACTIONS(114),
    [anon_sym_AMP] = ACTIONS(159),
    [anon_sym_CARET] = ACTIONS(114),
    [anon_sym_PIPE] = ACTIONS(161),
    [anon_sym_PLUS] = ACTIONS(1165),
    [anon_sym_DASH] = ACTIONS(1165),
    [anon_sym_PERCENT] = ACTIONS(114),
    [anon_sym_STAR_STAR] = ACTIONS(114),
    [anon_sym_LT_EQ] = ACTIONS(151),
    [anon_sym_EQ_EQ] = ACTIONS(114),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(151),
    [anon_sym_BANG_EQ] = ACTIONS(114),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(151),
    [anon_sym_GT_EQ] = ACTIONS(151),
    [anon_sym_QMARK_QMARK] = ACTIONS(114),
    [anon_sym_instanceof] = ACTIONS(114),
    [anon_sym_void] = ACTIONS(202),
    [anon_sym_PLUS_PLUS] = ACTIONS(151),
    [anon_sym_DASH_DASH] = ACTIONS(151),
    [anon_sym_DQUOTE] = ACTIONS(1167),
    [anon_sym_SQUOTE] = ACTIONS(1169),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(1171),
    [sym_number] = ACTIONS(1173),
    [sym_this] = ACTIONS(1175),
    [sym_true] = ACTIONS(1177),
    [sym_false] = ACTIONS(1177),
    [sym_null] = ACTIONS(1177),
    [sym_undefined] = ACTIONS(1177),
    [anon_sym_readonly] = ACTIONS(1179),
    [anon_sym_QMARK] = ACTIONS(192),
    [anon_sym_any] = ACTIONS(202),
    [anon_sym_number] = ACTIONS(202),
    [anon_sym_boolean] = ACTIONS(202),
    [anon_sym_string] = ACTIONS(202),
    [anon_sym_symbol] = ACTIONS(202),
    [anon_sym_abstract] = ACTIONS(196),
    [anon_sym_infer] = ACTIONS(198),
    [anon_sym_keyof] = ACTIONS(200),
    [anon_sym_unknown] = ACTIONS(202),
    [anon_sym_never] = ACTIONS(202),
    [anon_sym_object] = ACTIONS(202),
    [anon_sym_LBRACE_PIPE] = ACTIONS(204),
    [sym__automatic_semicolon] = ACTIONS(151),
    [sym__ternary_qmark] = ACTIONS(151),
  },
  [107] = {
    [sym_nested_identifier] = STATE(4074),
    [sym_string] = STATE(2367),
    [sym_formal_parameters] = STATE(4073),
    [sym_nested_type_identifier] = STATE(2336),
    [sym__type] = STATE(2398),
    [sym_constructor_type] = STATE(2398),
    [sym__primary_type] = STATE(2373),
    [sym_template_literal_type] = STATE(2359),
    [sym_infer_type] = STATE(2398),
    [sym_conditional_type] = STATE(2359),
    [sym_generic_type] = STATE(2359),
    [sym_type_query] = STATE(2359),
    [sym_index_type_query] = STATE(2359),
    [sym_lookup_type] = STATE(2359),
    [sym_literal_type] = STATE(2359),
    [sym__number] = STATE(2355),
    [sym_existential_type] = STATE(2359),
    [sym_flow_maybe_type] = STATE(2359),
    [sym_parenthesized_type] = STATE(2359),
    [sym_predefined_type] = STATE(2359),
    [sym_object_type] = STATE(2359),
    [sym_type_parameters] = STATE(3731),
    [sym_array_type] = STATE(2359),
    [sym_tuple_type] = STATE(2359),
    [sym_readonly_type] = STATE(2398),
    [sym_union_type] = STATE(2359),
    [sym_intersection_type] = STATE(2359),
    [sym_function_type] = STATE(2398),
    [sym_identifier] = ACTIONS(1149),
    [anon_sym_STAR] = ACTIONS(109),
    [anon_sym_EQ] = ACTIONS(1238),
    [anon_sym_as] = ACTIONS(114),
    [anon_sym_LBRACE] = ACTIONS(1153),
    [anon_sym_COMMA] = ACTIONS(151),
    [anon_sym_typeof] = ACTIONS(1155),
    [anon_sym_BANG] = ACTIONS(114),
    [anon_sym_LPAREN] = ACTIONS(1157),
    [anon_sym_in] = ACTIONS(114),
    [anon_sym_LBRACK] = ACTIONS(1159),
    [anon_sym_LT] = ACTIONS(1161),
    [anon_sym_GT] = ACTIONS(114),
    [anon_sym_SLASH] = ACTIONS(114),
    [anon_sym_DOT] = ACTIONS(114),
    [anon_sym_EQ_GT] = ACTIONS(1240),
    [anon_sym_QMARK_DOT] = ACTIONS(151),
    [anon_sym_new] = ACTIONS(1163),
    [anon_sym_PLUS_EQ] = ACTIONS(155),
    [anon_sym_DASH_EQ] = ACTIONS(155),
    [anon_sym_STAR_EQ] = ACTIONS(155),
    [anon_sym_SLASH_EQ] = ACTIONS(155),
    [anon_sym_PERCENT_EQ] = ACTIONS(155),
    [anon_sym_CARET_EQ] = ACTIONS(155),
    [anon_sym_AMP_EQ] = ACTIONS(155),
    [anon_sym_PIPE_EQ] = ACTIONS(155),
    [anon_sym_GT_GT_EQ] = ACTIONS(155),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(155),
    [anon_sym_LT_LT_EQ] = ACTIONS(155),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(155),
    [anon_sym_AMP_AMP_EQ] = ACTIONS(155),
    [anon_sym_PIPE_PIPE_EQ] = ACTIONS(155),
    [anon_sym_QMARK_QMARK_EQ] = ACTIONS(155),
    [anon_sym_AMP_AMP] = ACTIONS(114),
    [anon_sym_PIPE_PIPE] = ACTIONS(114),
    [anon_sym_GT_GT] = ACTIONS(114),
    [anon_sym_GT_GT_GT] = ACTIONS(114),
    [anon_sym_LT_LT] = ACTIONS(114),
    [anon_sym_AMP] = ACTIONS(159),
    [anon_sym_CARET] = ACTIONS(114),
    [anon_sym_PIPE] = ACTIONS(161),
    [anon_sym_PLUS] = ACTIONS(1165),
    [anon_sym_DASH] = ACTIONS(1165),
    [anon_sym_PERCENT] = ACTIONS(114),
    [anon_sym_STAR_STAR] = ACTIONS(114),
    [anon_sym_LT_EQ] = ACTIONS(151),
    [anon_sym_EQ_EQ] = ACTIONS(114),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(151),
    [anon_sym_BANG_EQ] = ACTIONS(114),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(151),
    [anon_sym_GT_EQ] = ACTIONS(151),
    [anon_sym_QMARK_QMARK] = ACTIONS(114),
    [anon_sym_instanceof] = ACTIONS(114),
    [anon_sym_void] = ACTIONS(202),
    [anon_sym_PLUS_PLUS] = ACTIONS(151),
    [anon_sym_DASH_DASH] = ACTIONS(151),
    [anon_sym_DQUOTE] = ACTIONS(1167),
    [anon_sym_SQUOTE] = ACTIONS(1169),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(1171),
    [sym_number] = ACTIONS(1173),
    [sym_this] = ACTIONS(1175),
    [sym_true] = ACTIONS(1177),
    [sym_false] = ACTIONS(1177),
    [sym_null] = ACTIONS(1177),
    [sym_undefined] = ACTIONS(1177),
    [anon_sym_readonly] = ACTIONS(1179),
    [anon_sym_QMARK] = ACTIONS(192),
    [anon_sym_any] = ACTIONS(202),
    [anon_sym_number] = ACTIONS(202),
    [anon_sym_boolean] = ACTIONS(202),
    [anon_sym_string] = ACTIONS(202),
    [anon_sym_symbol] = ACTIONS(202),
    [anon_sym_abstract] = ACTIONS(196),
    [anon_sym_implements] = ACTIONS(114),
    [anon_sym_infer] = ACTIONS(198),
    [anon_sym_keyof] = ACTIONS(200),
    [anon_sym_unknown] = ACTIONS(202),
    [anon_sym_never] = ACTIONS(202),
    [anon_sym_object] = ACTIONS(202),
    [anon_sym_LBRACE_PIPE] = ACTIONS(204),
    [sym__ternary_qmark] = ACTIONS(151),
  },
  [108] = {
    [sym_nested_identifier] = STATE(4074),
    [sym_string] = STATE(2367),
    [sym_formal_parameters] = STATE(4073),
    [sym_nested_type_identifier] = STATE(2336),
    [sym__type] = STATE(2398),
    [sym_constructor_type] = STATE(2398),
    [sym__primary_type] = STATE(2373),
    [sym_template_literal_type] = STATE(2359),
    [sym_infer_type] = STATE(2398),
    [sym_conditional_type] = STATE(2359),
    [sym_generic_type] = STATE(2359),
    [sym_type_query] = STATE(2359),
    [sym_index_type_query] = STATE(2359),
    [sym_lookup_type] = STATE(2359),
    [sym_literal_type] = STATE(2359),
    [sym__number] = STATE(2355),
    [sym_existential_type] = STATE(2359),
    [sym_flow_maybe_type] = STATE(2359),
    [sym_parenthesized_type] = STATE(2359),
    [sym_predefined_type] = STATE(2359),
    [sym_object_type] = STATE(2359),
    [sym_type_parameters] = STATE(3731),
    [sym_array_type] = STATE(2359),
    [sym_tuple_type] = STATE(2359),
    [sym_readonly_type] = STATE(2398),
    [sym_union_type] = STATE(2359),
    [sym_intersection_type] = STATE(2359),
    [sym_function_type] = STATE(2398),
    [sym_identifier] = ACTIONS(1149),
    [anon_sym_STAR] = ACTIONS(109),
    [anon_sym_EQ] = ACTIONS(1242),
    [anon_sym_as] = ACTIONS(114),
    [anon_sym_LBRACE] = ACTIONS(1153),
    [anon_sym_typeof] = ACTIONS(1155),
    [anon_sym_BANG] = ACTIONS(114),
    [anon_sym_LPAREN] = ACTIONS(1157),
    [anon_sym_in] = ACTIONS(114),
    [anon_sym_COLON] = ACTIONS(151),
    [anon_sym_LBRACK] = ACTIONS(1159),
    [anon_sym_RBRACK] = ACTIONS(151),
    [anon_sym_LT] = ACTIONS(1161),
    [anon_sym_GT] = ACTIONS(114),
    [anon_sym_SLASH] = ACTIONS(114),
    [anon_sym_DOT] = ACTIONS(114),
    [anon_sym_EQ_GT] = ACTIONS(1244),
    [anon_sym_QMARK_DOT] = ACTIONS(151),
    [anon_sym_new] = ACTIONS(1163),
    [anon_sym_PLUS_EQ] = ACTIONS(155),
    [anon_sym_DASH_EQ] = ACTIONS(155),
    [anon_sym_STAR_EQ] = ACTIONS(155),
    [anon_sym_SLASH_EQ] = ACTIONS(155),
    [anon_sym_PERCENT_EQ] = ACTIONS(155),
    [anon_sym_CARET_EQ] = ACTIONS(155),
    [anon_sym_AMP_EQ] = ACTIONS(155),
    [anon_sym_PIPE_EQ] = ACTIONS(155),
    [anon_sym_GT_GT_EQ] = ACTIONS(155),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(155),
    [anon_sym_LT_LT_EQ] = ACTIONS(155),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(155),
    [anon_sym_AMP_AMP_EQ] = ACTIONS(155),
    [anon_sym_PIPE_PIPE_EQ] = ACTIONS(155),
    [anon_sym_QMARK_QMARK_EQ] = ACTIONS(155),
    [anon_sym_AMP_AMP] = ACTIONS(114),
    [anon_sym_PIPE_PIPE] = ACTIONS(114),
    [anon_sym_GT_GT] = ACTIONS(114),
    [anon_sym_GT_GT_GT] = ACTIONS(114),
    [anon_sym_LT_LT] = ACTIONS(114),
    [anon_sym_AMP] = ACTIONS(159),
    [anon_sym_CARET] = ACTIONS(114),
    [anon_sym_PIPE] = ACTIONS(161),
    [anon_sym_PLUS] = ACTIONS(1165),
    [anon_sym_DASH] = ACTIONS(1165),
    [anon_sym_PERCENT] = ACTIONS(114),
    [anon_sym_STAR_STAR] = ACTIONS(114),
    [anon_sym_LT_EQ] = ACTIONS(151),
    [anon_sym_EQ_EQ] = ACTIONS(114),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(151),
    [anon_sym_BANG_EQ] = ACTIONS(114),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(151),
    [anon_sym_GT_EQ] = ACTIONS(151),
    [anon_sym_QMARK_QMARK] = ACTIONS(114),
    [anon_sym_instanceof] = ACTIONS(114),
    [anon_sym_void] = ACTIONS(202),
    [anon_sym_PLUS_PLUS] = ACTIONS(151),
    [anon_sym_DASH_DASH] = ACTIONS(151),
    [anon_sym_DQUOTE] = ACTIONS(1167),
    [anon_sym_SQUOTE] = ACTIONS(1169),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(1171),
    [sym_number] = ACTIONS(1173),
    [sym_this] = ACTIONS(1175),
    [sym_true] = ACTIONS(1177),
    [sym_false] = ACTIONS(1177),
    [sym_null] = ACTIONS(1177),
    [sym_undefined] = ACTIONS(1177),
    [anon_sym_readonly] = ACTIONS(1179),
    [anon_sym_QMARK] = ACTIONS(192),
    [anon_sym_any] = ACTIONS(202),
    [anon_sym_number] = ACTIONS(202),
    [anon_sym_boolean] = ACTIONS(202),
    [anon_sym_string] = ACTIONS(202),
    [anon_sym_symbol] = ACTIONS(202),
    [anon_sym_abstract] = ACTIONS(196),
    [anon_sym_infer] = ACTIONS(198),
    [anon_sym_keyof] = ACTIONS(200),
    [anon_sym_unknown] = ACTIONS(202),
    [anon_sym_never] = ACTIONS(202),
    [anon_sym_object] = ACTIONS(202),
    [anon_sym_LBRACE_PIPE] = ACTIONS(204),
    [sym__ternary_qmark] = ACTIONS(151),
  },
  [109] = {
    [sym_nested_identifier] = STATE(3984),
    [sym_string] = STATE(2541),
    [sym_formal_parameters] = STATE(3879),
    [sym_nested_type_identifier] = STATE(2466),
    [sym__type] = STATE(2560),
    [sym_constructor_type] = STATE(2560),
    [sym__primary_type] = STATE(2543),
    [sym_template_literal_type] = STATE(2544),
    [sym_infer_type] = STATE(2560),
    [sym_conditional_type] = STATE(2544),
    [sym_generic_type] = STATE(2544),
    [sym_type_query] = STATE(2544),
    [sym_index_type_query] = STATE(2544),
    [sym_lookup_type] = STATE(2544),
    [sym_literal_type] = STATE(2544),
    [sym__number] = STATE(2545),
    [sym_existential_type] = STATE(2544),
    [sym_flow_maybe_type] = STATE(2544),
    [sym_parenthesized_type] = STATE(2544),
    [sym_predefined_type] = STATE(2544),
    [sym_object_type] = STATE(2544),
    [sym_type_parameters] = STATE(3798),
    [sym_array_type] = STATE(2544),
    [sym_tuple_type] = STATE(2544),
    [sym_readonly_type] = STATE(2560),
    [sym_union_type] = STATE(2544),
    [sym_intersection_type] = STATE(2544),
    [sym_function_type] = STATE(2560),
    [sym_identifier] = ACTIONS(1246),
    [anon_sym_STAR] = ACTIONS(1248),
    [anon_sym_EQ] = ACTIONS(111),
    [anon_sym_as] = ACTIONS(114),
    [anon_sym_LBRACE] = ACTIONS(1250),
    [anon_sym_COMMA] = ACTIONS(120),
    [anon_sym_RBRACE] = ACTIONS(120),
    [anon_sym_typeof] = ACTIONS(1252),
    [anon_sym_BANG] = ACTIONS(114),
    [anon_sym_LPAREN] = ACTIONS(1254),
    [anon_sym_in] = ACTIONS(114),
    [anon_sym_LBRACK] = ACTIONS(1256),
    [anon_sym_LT] = ACTIONS(1161),
    [anon_sym_GT] = ACTIONS(114),
    [anon_sym_SLASH] = ACTIONS(114),
    [anon_sym_DOT] = ACTIONS(114),
    [anon_sym_EQ_GT] = ACTIONS(149),
    [anon_sym_QMARK_DOT] = ACTIONS(151),
    [anon_sym_new] = ACTIONS(1258),
    [anon_sym_PLUS_EQ] = ACTIONS(155),
    [anon_sym_DASH_EQ] = ACTIONS(155),
    [anon_sym_STAR_EQ] = ACTIONS(155),
    [anon_sym_SLASH_EQ] = ACTIONS(155),
    [anon_sym_PERCENT_EQ] = ACTIONS(155),
    [anon_sym_CARET_EQ] = ACTIONS(155),
    [anon_sym_AMP_EQ] = ACTIONS(155),
    [anon_sym_PIPE_EQ] = ACTIONS(155),
    [anon_sym_GT_GT_EQ] = ACTIONS(155),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(155),
    [anon_sym_LT_LT_EQ] = ACTIONS(155),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(155),
    [anon_sym_AMP_AMP_EQ] = ACTIONS(155),
    [anon_sym_PIPE_PIPE_EQ] = ACTIONS(155),
    [anon_sym_QMARK_QMARK_EQ] = ACTIONS(155),
    [anon_sym_AMP_AMP] = ACTIONS(114),
    [anon_sym_PIPE_PIPE] = ACTIONS(114),
    [anon_sym_GT_GT] = ACTIONS(114),
    [anon_sym_GT_GT_GT] = ACTIONS(114),
    [anon_sym_LT_LT] = ACTIONS(114),
    [anon_sym_AMP] = ACTIONS(1260),
    [anon_sym_CARET] = ACTIONS(114),
    [anon_sym_PIPE] = ACTIONS(1262),
    [anon_sym_PLUS] = ACTIONS(1264),
    [anon_sym_DASH] = ACTIONS(1264),
    [anon_sym_PERCENT] = ACTIONS(114),
    [anon_sym_STAR_STAR] = ACTIONS(114),
    [anon_sym_LT_EQ] = ACTIONS(151),
    [anon_sym_EQ_EQ] = ACTIONS(114),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(151),
    [anon_sym_BANG_EQ] = ACTIONS(114),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(151),
    [anon_sym_GT_EQ] = ACTIONS(151),
    [anon_sym_QMARK_QMARK] = ACTIONS(114),
    [anon_sym_instanceof] = ACTIONS(114),
    [anon_sym_void] = ACTIONS(729),
    [anon_sym_PLUS_PLUS] = ACTIONS(151),
    [anon_sym_DASH_DASH] = ACTIONS(151),
    [anon_sym_DQUOTE] = ACTIONS(1266),
    [anon_sym_SQUOTE] = ACTIONS(1268),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(1270),
    [sym_number] = ACTIONS(1272),
    [sym_this] = ACTIONS(1274),
    [sym_true] = ACTIONS(1276),
    [sym_false] = ACTIONS(1276),
    [sym_null] = ACTIONS(1276),
    [sym_undefined] = ACTIONS(1276),
    [anon_sym_readonly] = ACTIONS(1278),
    [anon_sym_QMARK] = ACTIONS(1280),
    [anon_sym_any] = ACTIONS(729),
    [anon_sym_number] = ACTIONS(729),
    [anon_sym_boolean] = ACTIONS(729),
    [anon_sym_string] = ACTIONS(729),
    [anon_sym_symbol] = ACTIONS(729),
    [anon_sym_abstract] = ACTIONS(723),
    [anon_sym_infer] = ACTIONS(725),
    [anon_sym_keyof] = ACTIONS(727),
    [anon_sym_unknown] = ACTIONS(729),
    [anon_sym_never] = ACTIONS(729),
    [anon_sym_object] = ACTIONS(729),
    [anon_sym_LBRACE_PIPE] = ACTIONS(731),
    [sym__ternary_qmark] = ACTIONS(151),
  },
  [110] = {
    [sym_nested_identifier] = STATE(4074),
    [sym_string] = STATE(2367),
    [sym_formal_parameters] = STATE(4073),
    [sym_nested_type_identifier] = STATE(2336),
    [sym__type] = STATE(2398),
    [sym_constructor_type] = STATE(2398),
    [sym__primary_type] = STATE(2373),
    [sym_template_literal_type] = STATE(2359),
    [sym_infer_type] = STATE(2398),
    [sym_conditional_type] = STATE(2359),
    [sym_generic_type] = STATE(2359),
    [sym_type_query] = STATE(2359),
    [sym_index_type_query] = STATE(2359),
    [sym_lookup_type] = STATE(2359),
    [sym_literal_type] = STATE(2359),
    [sym__number] = STATE(2355),
    [sym_existential_type] = STATE(2359),
    [sym_flow_maybe_type] = STATE(2359),
    [sym_parenthesized_type] = STATE(2359),
    [sym_predefined_type] = STATE(2359),
    [sym_object_type] = STATE(2359),
    [sym_type_parameters] = STATE(3731),
    [sym_array_type] = STATE(2359),
    [sym_tuple_type] = STATE(2359),
    [sym_readonly_type] = STATE(2398),
    [sym_union_type] = STATE(2359),
    [sym_intersection_type] = STATE(2359),
    [sym_function_type] = STATE(2398),
    [sym_identifier] = ACTIONS(1149),
    [anon_sym_STAR] = ACTIONS(109),
    [anon_sym_EQ] = ACTIONS(1282),
    [anon_sym_as] = ACTIONS(114),
    [anon_sym_LBRACE] = ACTIONS(1153),
    [anon_sym_typeof] = ACTIONS(1155),
    [anon_sym_BANG] = ACTIONS(114),
    [anon_sym_LPAREN] = ACTIONS(1157),
    [anon_sym_in] = ACTIONS(114),
    [anon_sym_of] = ACTIONS(114),
    [anon_sym_LBRACK] = ACTIONS(1159),
    [anon_sym_LT] = ACTIONS(1161),
    [anon_sym_GT] = ACTIONS(114),
    [anon_sym_SLASH] = ACTIONS(114),
    [anon_sym_DOT] = ACTIONS(114),
    [anon_sym_EQ_GT] = ACTIONS(1284),
    [anon_sym_QMARK_DOT] = ACTIONS(151),
    [anon_sym_new] = ACTIONS(1163),
    [anon_sym_PLUS_EQ] = ACTIONS(155),
    [anon_sym_DASH_EQ] = ACTIONS(155),
    [anon_sym_STAR_EQ] = ACTIONS(155),
    [anon_sym_SLASH_EQ] = ACTIONS(155),
    [anon_sym_PERCENT_EQ] = ACTIONS(155),
    [anon_sym_CARET_EQ] = ACTIONS(155),
    [anon_sym_AMP_EQ] = ACTIONS(155),
    [anon_sym_PIPE_EQ] = ACTIONS(155),
    [anon_sym_GT_GT_EQ] = ACTIONS(155),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(155),
    [anon_sym_LT_LT_EQ] = ACTIONS(155),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(155),
    [anon_sym_AMP_AMP_EQ] = ACTIONS(155),
    [anon_sym_PIPE_PIPE_EQ] = ACTIONS(155),
    [anon_sym_QMARK_QMARK_EQ] = ACTIONS(155),
    [anon_sym_AMP_AMP] = ACTIONS(114),
    [anon_sym_PIPE_PIPE] = ACTIONS(114),
    [anon_sym_GT_GT] = ACTIONS(114),
    [anon_sym_GT_GT_GT] = ACTIONS(114),
    [anon_sym_LT_LT] = ACTIONS(114),
    [anon_sym_AMP] = ACTIONS(159),
    [anon_sym_CARET] = ACTIONS(114),
    [anon_sym_PIPE] = ACTIONS(161),
    [anon_sym_PLUS] = ACTIONS(1165),
    [anon_sym_DASH] = ACTIONS(1165),
    [anon_sym_PERCENT] = ACTIONS(114),
    [anon_sym_STAR_STAR] = ACTIONS(114),
    [anon_sym_LT_EQ] = ACTIONS(151),
    [anon_sym_EQ_EQ] = ACTIONS(114),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(151),
    [anon_sym_BANG_EQ] = ACTIONS(114),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(151),
    [anon_sym_GT_EQ] = ACTIONS(151),
    [anon_sym_QMARK_QMARK] = ACTIONS(114),
    [anon_sym_instanceof] = ACTIONS(114),
    [anon_sym_void] = ACTIONS(202),
    [anon_sym_PLUS_PLUS] = ACTIONS(151),
    [anon_sym_DASH_DASH] = ACTIONS(151),
    [anon_sym_DQUOTE] = ACTIONS(1167),
    [anon_sym_SQUOTE] = ACTIONS(1169),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(1171),
    [sym_number] = ACTIONS(1173),
    [sym_this] = ACTIONS(1175),
    [sym_true] = ACTIONS(1177),
    [sym_false] = ACTIONS(1177),
    [sym_null] = ACTIONS(1177),
    [sym_undefined] = ACTIONS(1177),
    [anon_sym_readonly] = ACTIONS(1179),
    [anon_sym_QMARK] = ACTIONS(192),
    [anon_sym_any] = ACTIONS(202),
    [anon_sym_number] = ACTIONS(202),
    [anon_sym_boolean] = ACTIONS(202),
    [anon_sym_string] = ACTIONS(202),
    [anon_sym_symbol] = ACTIONS(202),
    [anon_sym_abstract] = ACTIONS(196),
    [anon_sym_infer] = ACTIONS(198),
    [anon_sym_keyof] = ACTIONS(200),
    [anon_sym_unknown] = ACTIONS(202),
    [anon_sym_never] = ACTIONS(202),
    [anon_sym_object] = ACTIONS(202),
    [anon_sym_LBRACE_PIPE] = ACTIONS(204),
    [sym__ternary_qmark] = ACTIONS(151),
  },
  [111] = {
    [sym_nested_identifier] = STATE(4074),
    [sym_string] = STATE(2367),
    [sym_formal_parameters] = STATE(4073),
    [sym_nested_type_identifier] = STATE(2336),
    [sym__type] = STATE(2398),
    [sym_constructor_type] = STATE(2398),
    [sym__primary_type] = STATE(2373),
    [sym_template_literal_type] = STATE(2359),
    [sym_infer_type] = STATE(2398),
    [sym_conditional_type] = STATE(2359),
    [sym_generic_type] = STATE(2359),
    [sym_type_query] = STATE(2359),
    [sym_index_type_query] = STATE(2359),
    [sym_lookup_type] = STATE(2359),
    [sym_literal_type] = STATE(2359),
    [sym__number] = STATE(2355),
    [sym_existential_type] = STATE(2359),
    [sym_flow_maybe_type] = STATE(2359),
    [sym_parenthesized_type] = STATE(2359),
    [sym_predefined_type] = STATE(2359),
    [sym_object_type] = STATE(2359),
    [sym_type_parameters] = STATE(3731),
    [sym_array_type] = STATE(2359),
    [sym_tuple_type] = STATE(2359),
    [sym_readonly_type] = STATE(2398),
    [sym_union_type] = STATE(2359),
    [sym_intersection_type] = STATE(2359),
    [sym_function_type] = STATE(2398),
    [sym_identifier] = ACTIONS(1149),
    [anon_sym_STAR] = ACTIONS(109),
    [anon_sym_EQ] = ACTIONS(1286),
    [anon_sym_as] = ACTIONS(114),
    [anon_sym_LBRACE] = ACTIONS(1153),
    [anon_sym_typeof] = ACTIONS(1155),
    [anon_sym_BANG] = ACTIONS(114),
    [anon_sym_LPAREN] = ACTIONS(1157),
    [anon_sym_in] = ACTIONS(114),
    [anon_sym_COLON] = ACTIONS(1232),
    [anon_sym_LBRACK] = ACTIONS(1159),
    [anon_sym_LT] = ACTIONS(1161),
    [anon_sym_GT] = ACTIONS(114),
    [anon_sym_SLASH] = ACTIONS(114),
    [anon_sym_DOT] = ACTIONS(114),
    [anon_sym_EQ_GT] = ACTIONS(211),
    [anon_sym_QMARK_DOT] = ACTIONS(151),
    [anon_sym_new] = ACTIONS(1163),
    [anon_sym_PLUS_EQ] = ACTIONS(155),
    [anon_sym_DASH_EQ] = ACTIONS(155),
    [anon_sym_STAR_EQ] = ACTIONS(155),
    [anon_sym_SLASH_EQ] = ACTIONS(155),
    [anon_sym_PERCENT_EQ] = ACTIONS(155),
    [anon_sym_CARET_EQ] = ACTIONS(155),
    [anon_sym_AMP_EQ] = ACTIONS(155),
    [anon_sym_PIPE_EQ] = ACTIONS(155),
    [anon_sym_GT_GT_EQ] = ACTIONS(155),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(155),
    [anon_sym_LT_LT_EQ] = ACTIONS(155),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(155),
    [anon_sym_AMP_AMP_EQ] = ACTIONS(155),
    [anon_sym_PIPE_PIPE_EQ] = ACTIONS(155),
    [anon_sym_QMARK_QMARK_EQ] = ACTIONS(155),
    [anon_sym_AMP_AMP] = ACTIONS(114),
    [anon_sym_PIPE_PIPE] = ACTIONS(114),
    [anon_sym_GT_GT] = ACTIONS(114),
    [anon_sym_GT_GT_GT] = ACTIONS(114),
    [anon_sym_LT_LT] = ACTIONS(114),
    [anon_sym_AMP] = ACTIONS(159),
    [anon_sym_CARET] = ACTIONS(114),
    [anon_sym_PIPE] = ACTIONS(161),
    [anon_sym_PLUS] = ACTIONS(1165),
    [anon_sym_DASH] = ACTIONS(1165),
    [anon_sym_PERCENT] = ACTIONS(114),
    [anon_sym_STAR_STAR] = ACTIONS(114),
    [anon_sym_LT_EQ] = ACTIONS(151),
    [anon_sym_EQ_EQ] = ACTIONS(114),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(151),
    [anon_sym_BANG_EQ] = ACTIONS(114),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(151),
    [anon_sym_GT_EQ] = ACTIONS(151),
    [anon_sym_QMARK_QMARK] = ACTIONS(114),
    [anon_sym_instanceof] = ACTIONS(114),
    [anon_sym_void] = ACTIONS(202),
    [anon_sym_PLUS_PLUS] = ACTIONS(151),
    [anon_sym_DASH_DASH] = ACTIONS(151),
    [anon_sym_DQUOTE] = ACTIONS(1167),
    [anon_sym_SQUOTE] = ACTIONS(1169),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(1171),
    [sym_number] = ACTIONS(1173),
    [sym_this] = ACTIONS(1175),
    [sym_true] = ACTIONS(1177),
    [sym_false] = ACTIONS(1177),
    [sym_null] = ACTIONS(1177),
    [sym_undefined] = ACTIONS(1177),
    [anon_sym_readonly] = ACTIONS(1179),
    [anon_sym_QMARK] = ACTIONS(192),
    [anon_sym_any] = ACTIONS(202),
    [anon_sym_number] = ACTIONS(202),
    [anon_sym_boolean] = ACTIONS(202),
    [anon_sym_string] = ACTIONS(202),
    [anon_sym_symbol] = ACTIONS(202),
    [anon_sym_abstract] = ACTIONS(196),
    [anon_sym_infer] = ACTIONS(198),
    [anon_sym_keyof] = ACTIONS(200),
    [anon_sym_unknown] = ACTIONS(202),
    [anon_sym_never] = ACTIONS(202),
    [anon_sym_object] = ACTIONS(202),
    [anon_sym_LBRACE_PIPE] = ACTIONS(204),
    [sym__ternary_qmark] = ACTIONS(151),
  },
  [112] = {
    [sym_nested_identifier] = STATE(4074),
    [sym_string] = STATE(2367),
    [sym_formal_parameters] = STATE(4073),
    [sym_nested_type_identifier] = STATE(2336),
    [sym__type] = STATE(2398),
    [sym_constructor_type] = STATE(2398),
    [sym__primary_type] = STATE(2373),
    [sym_template_literal_type] = STATE(2359),
    [sym_infer_type] = STATE(2398),
    [sym_conditional_type] = STATE(2359),
    [sym_generic_type] = STATE(2359),
    [sym_type_query] = STATE(2359),
    [sym_index_type_query] = STATE(2359),
    [sym_lookup_type] = STATE(2359),
    [sym_literal_type] = STATE(2359),
    [sym__number] = STATE(2355),
    [sym_existential_type] = STATE(2359),
    [sym_flow_maybe_type] = STATE(2359),
    [sym_parenthesized_type] = STATE(2359),
    [sym_predefined_type] = STATE(2359),
    [sym_object_type] = STATE(2359),
    [sym_type_parameters] = STATE(3731),
    [sym_array_type] = STATE(2359),
    [sym_tuple_type] = STATE(2359),
    [sym_readonly_type] = STATE(2398),
    [sym_union_type] = STATE(2359),
    [sym_intersection_type] = STATE(2359),
    [sym_function_type] = STATE(2398),
    [sym_identifier] = ACTIONS(1149),
    [anon_sym_STAR] = ACTIONS(109),
    [anon_sym_EQ] = ACTIONS(1286),
    [anon_sym_as] = ACTIONS(114),
    [anon_sym_LBRACE] = ACTIONS(1153),
    [anon_sym_typeof] = ACTIONS(1155),
    [anon_sym_BANG] = ACTIONS(114),
    [anon_sym_LPAREN] = ACTIONS(1157),
    [anon_sym_in] = ACTIONS(114),
    [anon_sym_LBRACK] = ACTIONS(1159),
    [anon_sym_LT] = ACTIONS(1161),
    [anon_sym_GT] = ACTIONS(114),
    [anon_sym_SLASH] = ACTIONS(114),
    [anon_sym_DOT] = ACTIONS(114),
    [anon_sym_EQ_GT] = ACTIONS(211),
    [anon_sym_QMARK_DOT] = ACTIONS(151),
    [anon_sym_new] = ACTIONS(1163),
    [anon_sym_PLUS_EQ] = ACTIONS(155),
    [anon_sym_DASH_EQ] = ACTIONS(155),
    [anon_sym_STAR_EQ] = ACTIONS(155),
    [anon_sym_SLASH_EQ] = ACTIONS(155),
    [anon_sym_PERCENT_EQ] = ACTIONS(155),
    [anon_sym_CARET_EQ] = ACTIONS(155),
    [anon_sym_AMP_EQ] = ACTIONS(155),
    [anon_sym_PIPE_EQ] = ACTIONS(155),
    [anon_sym_GT_GT_EQ] = ACTIONS(155),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(155),
    [anon_sym_LT_LT_EQ] = ACTIONS(155),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(155),
    [anon_sym_AMP_AMP_EQ] = ACTIONS(155),
    [anon_sym_PIPE_PIPE_EQ] = ACTIONS(155),
    [anon_sym_QMARK_QMARK_EQ] = ACTIONS(155),
    [anon_sym_AMP_AMP] = ACTIONS(114),
    [anon_sym_PIPE_PIPE] = ACTIONS(114),
    [anon_sym_GT_GT] = ACTIONS(114),
    [anon_sym_GT_GT_GT] = ACTIONS(114),
    [anon_sym_LT_LT] = ACTIONS(114),
    [anon_sym_AMP] = ACTIONS(159),
    [anon_sym_CARET] = ACTIONS(114),
    [anon_sym_PIPE] = ACTIONS(161),
    [anon_sym_PLUS] = ACTIONS(1165),
    [anon_sym_DASH] = ACTIONS(1165),
    [anon_sym_PERCENT] = ACTIONS(114),
    [anon_sym_STAR_STAR] = ACTIONS(114),
    [anon_sym_LT_EQ] = ACTIONS(151),
    [anon_sym_EQ_EQ] = ACTIONS(114),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(151),
    [anon_sym_BANG_EQ] = ACTIONS(114),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(151),
    [anon_sym_GT_EQ] = ACTIONS(151),
    [anon_sym_QMARK_QMARK] = ACTIONS(114),
    [anon_sym_instanceof] = ACTIONS(114),
    [anon_sym_void] = ACTIONS(202),
    [anon_sym_PLUS_PLUS] = ACTIONS(151),
    [anon_sym_DASH_DASH] = ACTIONS(151),
    [anon_sym_DQUOTE] = ACTIONS(1167),
    [anon_sym_SQUOTE] = ACTIONS(1169),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(1171),
    [sym_number] = ACTIONS(1173),
    [sym_this] = ACTIONS(1175),
    [sym_true] = ACTIONS(1177),
    [sym_false] = ACTIONS(1177),
    [sym_null] = ACTIONS(1177),
    [sym_undefined] = ACTIONS(1177),
    [anon_sym_readonly] = ACTIONS(1179),
    [anon_sym_QMARK] = ACTIONS(192),
    [anon_sym_any] = ACTIONS(202),
    [anon_sym_number] = ACTIONS(202),
    [anon_sym_boolean] = ACTIONS(202),
    [anon_sym_string] = ACTIONS(202),
    [anon_sym_symbol] = ACTIONS(202),
    [anon_sym_abstract] = ACTIONS(196),
    [anon_sym_infer] = ACTIONS(198),
    [anon_sym_keyof] = ACTIONS(200),
    [anon_sym_unknown] = ACTIONS(202),
    [anon_sym_never] = ACTIONS(202),
    [anon_sym_object] = ACTIONS(202),
    [anon_sym_LBRACE_PIPE] = ACTIONS(204),
    [sym__ternary_qmark] = ACTIONS(151),
  },
  [113] = {
    [ts_builtin_sym_end] = ACTIONS(1288),
    [sym_identifier] = ACTIONS(1290),
    [anon_sym_export] = ACTIONS(1290),
    [anon_sym_STAR] = ACTIONS(1292),
    [anon_sym_default] = ACTIONS(1290),
    [anon_sym_type] = ACTIONS(1290),
    [anon_sym_EQ] = ACTIONS(1294),
    [anon_sym_as] = ACTIONS(1292),
    [anon_sym_namespace] = ACTIONS(1290),
    [anon_sym_LBRACE] = ACTIONS(1288),
    [anon_sym_COMMA] = ACTIONS(1296),
    [anon_sym_RBRACE] = ACTIONS(1288),
    [anon_sym_typeof] = ACTIONS(1290),
    [anon_sym_import] = ACTIONS(1290),
    [anon_sym_var] = ACTIONS(1290),
    [anon_sym_let] = ACTIONS(1290),
    [anon_sym_const] = ACTIONS(1290),
    [anon_sym_BANG] = ACTIONS(1290),
    [anon_sym_else] = ACTIONS(1290),
    [anon_sym_if] = ACTIONS(1290),
    [anon_sym_switch] = ACTIONS(1290),
    [anon_sym_for] = ACTIONS(1290),
    [anon_sym_LPAREN] = ACTIONS(1288),
    [anon_sym_await] = ACTIONS(1290),
    [anon_sym_in] = ACTIONS(1292),
    [anon_sym_while] = ACTIONS(1290),
    [anon_sym_do] = ACTIONS(1290),
    [anon_sym_try] = ACTIONS(1290),
    [anon_sym_with] = ACTIONS(1290),
    [anon_sym_break] = ACTIONS(1290),
    [anon_sym_continue] = ACTIONS(1290),
    [anon_sym_debugger] = ACTIONS(1290),
    [anon_sym_return] = ACTIONS(1290),
    [anon_sym_throw] = ACTIONS(1290),
    [anon_sym_SEMI] = ACTIONS(1288),
    [anon_sym_case] = ACTIONS(1290),
    [anon_sym_yield] = ACTIONS(1290),
    [anon_sym_LBRACK] = ACTIONS(1288),
    [anon_sym_LT] = ACTIONS(1290),
    [anon_sym_GT] = ACTIONS(1292),
    [anon_sym_SLASH] = ACTIONS(1290),
    [anon_sym_DOT] = ACTIONS(1292),
    [anon_sym_class] = ACTIONS(1290),
    [anon_sym_async] = ACTIONS(1290),
    [anon_sym_function] = ACTIONS(1290),
    [anon_sym_QMARK_DOT] = ACTIONS(1296),
    [anon_sym_new] = ACTIONS(1290),
    [anon_sym_AMP_AMP] = ACTIONS(1296),
    [anon_sym_PIPE_PIPE] = ACTIONS(1296),
    [anon_sym_GT_GT] = ACTIONS(1292),
    [anon_sym_GT_GT_GT] = ACTIONS(1296),
    [anon_sym_LT_LT] = ACTIONS(1296),
    [anon_sym_AMP] = ACTIONS(1292),
    [anon_sym_CARET] = ACTIONS(1296),
    [anon_sym_PIPE] = ACTIONS(1292),
    [anon_sym_PLUS] = ACTIONS(1290),
    [anon_sym_DASH] = ACTIONS(1290),
    [anon_sym_PERCENT] = ACTIONS(1296),
    [anon_sym_STAR_STAR] = ACTIONS(1296),
    [anon_sym_LT_EQ] = ACTIONS(1296),
    [anon_sym_EQ_EQ] = ACTIONS(1292),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(1296),
    [anon_sym_BANG_EQ] = ACTIONS(1292),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(1296),
    [anon_sym_GT_EQ] = ACTIONS(1296),
    [anon_sym_QMARK_QMARK] = ACTIONS(1296),
    [anon_sym_instanceof] = ACTIONS(1292),
    [anon_sym_TILDE] = ACTIONS(1288),
    [anon_sym_void] = ACTIONS(1290),
    [anon_sym_delete] = ACTIONS(1290),
    [anon_sym_PLUS_PLUS] = ACTIONS(1288),
    [anon_sym_DASH_DASH] = ACTIONS(1288),
    [anon_sym_DQUOTE] = ACTIONS(1288),
    [anon_sym_SQUOTE] = ACTIONS(1288),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(1288),
    [sym_number] = ACTIONS(1288),
    [sym_this] = ACTIONS(1290),
    [sym_super] = ACTIONS(1290),
    [sym_true] = ACTIONS(1290),
    [sym_false] = ACTIONS(1290),
    [sym_null] = ACTIONS(1290),
    [sym_undefined] = ACTIONS(1290),
    [anon_sym_AT] = ACTIONS(1288),
    [anon_sym_static] = ACTIONS(1290),
    [anon_sym_readonly] = ACTIONS(1290),
    [anon_sym_get] = ACTIONS(1290),
    [anon_sym_set] = ACTIONS(1290),
    [anon_sym_declare] = ACTIONS(1290),
    [anon_sym_public] = ACTIONS(1290),
    [anon_sym_private] = ACTIONS(1290),
    [anon_sym_protected] = ACTIONS(1290),
    [anon_sym_override] = ACTIONS(1290),
    [anon_sym_module] = ACTIONS(1290),
    [anon_sym_any] = ACTIONS(1290),
    [anon_sym_number] = ACTIONS(1290),
    [anon_sym_boolean] = ACTIONS(1290),
    [anon_sym_string] = ACTIONS(1290),
    [anon_sym_symbol] = ACTIONS(1290),
    [anon_sym_abstract] = ACTIONS(1290),
    [anon_sym_interface] = ACTIONS(1290),
    [anon_sym_enum] = ACTIONS(1290),
    [sym__automatic_semicolon] = ACTIONS(1298),
    [sym__ternary_qmark] = ACTIONS(1296),
  },
  [114] = {
    [sym_statement_block] = STATE(134),
    [ts_builtin_sym_end] = ACTIONS(1300),
    [sym_identifier] = ACTIONS(1302),
    [anon_sym_export] = ACTIONS(1302),
    [anon_sym_STAR] = ACTIONS(1302),
    [anon_sym_default] = ACTIONS(1302),
    [anon_sym_type] = ACTIONS(1302),
    [anon_sym_as] = ACTIONS(1302),
    [anon_sym_namespace] = ACTIONS(1302),
    [anon_sym_LBRACE] = ACTIONS(1304),
    [anon_sym_COMMA] = ACTIONS(1300),
    [anon_sym_RBRACE] = ACTIONS(1300),
    [anon_sym_typeof] = ACTIONS(1302),
    [anon_sym_import] = ACTIONS(1302),
    [anon_sym_var] = ACTIONS(1302),
    [anon_sym_let] = ACTIONS(1302),
    [anon_sym_const] = ACTIONS(1302),
    [anon_sym_BANG] = ACTIONS(1302),
    [anon_sym_else] = ACTIONS(1302),
    [anon_sym_if] = ACTIONS(1302),
    [anon_sym_switch] = ACTIONS(1302),
    [anon_sym_for] = ACTIONS(1302),
    [anon_sym_LPAREN] = ACTIONS(1300),
    [anon_sym_await] = ACTIONS(1302),
    [anon_sym_in] = ACTIONS(1302),
    [anon_sym_while] = ACTIONS(1302),
    [anon_sym_do] = ACTIONS(1302),
    [anon_sym_try] = ACTIONS(1302),
    [anon_sym_with] = ACTIONS(1302),
    [anon_sym_break] = ACTIONS(1302),
    [anon_sym_continue] = ACTIONS(1302),
    [anon_sym_debugger] = ACTIONS(1302),
    [anon_sym_return] = ACTIONS(1302),
    [anon_sym_throw] = ACTIONS(1302),
    [anon_sym_SEMI] = ACTIONS(1300),
    [anon_sym_case] = ACTIONS(1302),
    [anon_sym_yield] = ACTIONS(1302),
    [anon_sym_LBRACK] = ACTIONS(1300),
    [anon_sym_LT] = ACTIONS(1302),
    [anon_sym_GT] = ACTIONS(1302),
    [anon_sym_SLASH] = ACTIONS(1302),
    [anon_sym_DOT] = ACTIONS(1302),
    [anon_sym_class] = ACTIONS(1302),
    [anon_sym_async] = ACTIONS(1302),
    [anon_sym_function] = ACTIONS(1302),
    [anon_sym_QMARK_DOT] = ACTIONS(1300),
    [anon_sym_new] = ACTIONS(1302),
    [anon_sym_AMP_AMP] = ACTIONS(1300),
    [anon_sym_PIPE_PIPE] = ACTIONS(1300),
    [anon_sym_GT_GT] = ACTIONS(1302),
    [anon_sym_GT_GT_GT] = ACTIONS(1300),
    [anon_sym_LT_LT] = ACTIONS(1300),
    [anon_sym_AMP] = ACTIONS(1302),
    [anon_sym_CARET] = ACTIONS(1300),
    [anon_sym_PIPE] = ACTIONS(1302),
    [anon_sym_PLUS] = ACTIONS(1302),
    [anon_sym_DASH] = ACTIONS(1302),
    [anon_sym_PERCENT] = ACTIONS(1300),
    [anon_sym_STAR_STAR] = ACTIONS(1300),
    [anon_sym_LT_EQ] = ACTIONS(1300),
    [anon_sym_EQ_EQ] = ACTIONS(1302),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(1300),
    [anon_sym_BANG_EQ] = ACTIONS(1302),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(1300),
    [anon_sym_GT_EQ] = ACTIONS(1300),
    [anon_sym_QMARK_QMARK] = ACTIONS(1300),
    [anon_sym_instanceof] = ACTIONS(1302),
    [anon_sym_TILDE] = ACTIONS(1300),
    [anon_sym_void] = ACTIONS(1302),
    [anon_sym_delete] = ACTIONS(1302),
    [anon_sym_PLUS_PLUS] = ACTIONS(1300),
    [anon_sym_DASH_DASH] = ACTIONS(1300),
    [anon_sym_DQUOTE] = ACTIONS(1300),
    [anon_sym_SQUOTE] = ACTIONS(1300),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(1300),
    [sym_number] = ACTIONS(1300),
    [sym_this] = ACTIONS(1302),
    [sym_super] = ACTIONS(1302),
    [sym_true] = ACTIONS(1302),
    [sym_false] = ACTIONS(1302),
    [sym_null] = ACTIONS(1302),
    [sym_undefined] = ACTIONS(1302),
    [anon_sym_AT] = ACTIONS(1300),
    [anon_sym_static] = ACTIONS(1302),
    [anon_sym_readonly] = ACTIONS(1302),
    [anon_sym_get] = ACTIONS(1302),
    [anon_sym_set] = ACTIONS(1302),
    [anon_sym_declare] = ACTIONS(1302),
    [anon_sym_public] = ACTIONS(1302),
    [anon_sym_private] = ACTIONS(1302),
    [anon_sym_protected] = ACTIONS(1302),
    [anon_sym_override] = ACTIONS(1302),
    [anon_sym_module] = ACTIONS(1302),
    [anon_sym_any] = ACTIONS(1302),
    [anon_sym_number] = ACTIONS(1302),
    [anon_sym_boolean] = ACTIONS(1302),
    [anon_sym_string] = ACTIONS(1302),
    [anon_sym_symbol] = ACTIONS(1302),
    [anon_sym_abstract] = ACTIONS(1302),
    [anon_sym_interface] = ACTIONS(1302),
    [anon_sym_enum] = ACTIONS(1302),
    [sym__automatic_semicolon] = ACTIONS(1300),
    [sym__ternary_qmark] = ACTIONS(1300),
  },
  [115] = {
    [sym_statement_block] = STATE(134),
    [ts_builtin_sym_end] = ACTIONS(1300),
    [sym_identifier] = ACTIONS(1302),
    [anon_sym_export] = ACTIONS(1302),
    [anon_sym_STAR] = ACTIONS(1302),
    [anon_sym_default] = ACTIONS(1302),
    [anon_sym_type] = ACTIONS(1302),
    [anon_sym_as] = ACTIONS(1302),
    [anon_sym_namespace] = ACTIONS(1302),
    [anon_sym_LBRACE] = ACTIONS(1304),
    [anon_sym_COMMA] = ACTIONS(1300),
    [anon_sym_RBRACE] = ACTIONS(1300),
    [anon_sym_typeof] = ACTIONS(1302),
    [anon_sym_import] = ACTIONS(1302),
    [anon_sym_var] = ACTIONS(1302),
    [anon_sym_let] = ACTIONS(1302),
    [anon_sym_const] = ACTIONS(1302),
    [anon_sym_BANG] = ACTIONS(1302),
    [anon_sym_else] = ACTIONS(1302),
    [anon_sym_if] = ACTIONS(1302),
    [anon_sym_switch] = ACTIONS(1302),
    [anon_sym_for] = ACTIONS(1302),
    [anon_sym_LPAREN] = ACTIONS(1300),
    [anon_sym_await] = ACTIONS(1302),
    [anon_sym_in] = ACTIONS(1302),
    [anon_sym_while] = ACTIONS(1302),
    [anon_sym_do] = ACTIONS(1302),
    [anon_sym_try] = ACTIONS(1302),
    [anon_sym_with] = ACTIONS(1302),
    [anon_sym_break] = ACTIONS(1302),
    [anon_sym_continue] = ACTIONS(1302),
    [anon_sym_debugger] = ACTIONS(1302),
    [anon_sym_return] = ACTIONS(1302),
    [anon_sym_throw] = ACTIONS(1302),
    [anon_sym_SEMI] = ACTIONS(1300),
    [anon_sym_case] = ACTIONS(1302),
    [anon_sym_yield] = ACTIONS(1302),
    [anon_sym_LBRACK] = ACTIONS(1300),
    [anon_sym_LT] = ACTIONS(1302),
    [anon_sym_GT] = ACTIONS(1302),
    [anon_sym_SLASH] = ACTIONS(1302),
    [anon_sym_DOT] = ACTIONS(1306),
    [anon_sym_class] = ACTIONS(1302),
    [anon_sym_async] = ACTIONS(1302),
    [anon_sym_function] = ACTIONS(1302),
    [anon_sym_QMARK_DOT] = ACTIONS(1300),
    [anon_sym_new] = ACTIONS(1302),
    [anon_sym_AMP_AMP] = ACTIONS(1300),
    [anon_sym_PIPE_PIPE] = ACTIONS(1300),
    [anon_sym_GT_GT] = ACTIONS(1302),
    [anon_sym_GT_GT_GT] = ACTIONS(1300),
    [anon_sym_LT_LT] = ACTIONS(1300),
    [anon_sym_AMP] = ACTIONS(1302),
    [anon_sym_CARET] = ACTIONS(1300),
    [anon_sym_PIPE] = ACTIONS(1302),
    [anon_sym_PLUS] = ACTIONS(1302),
    [anon_sym_DASH] = ACTIONS(1302),
    [anon_sym_PERCENT] = ACTIONS(1300),
    [anon_sym_STAR_STAR] = ACTIONS(1300),
    [anon_sym_LT_EQ] = ACTIONS(1300),
    [anon_sym_EQ_EQ] = ACTIONS(1302),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(1300),
    [anon_sym_BANG_EQ] = ACTIONS(1302),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(1300),
    [anon_sym_GT_EQ] = ACTIONS(1300),
    [anon_sym_QMARK_QMARK] = ACTIONS(1300),
    [anon_sym_instanceof] = ACTIONS(1302),
    [anon_sym_TILDE] = ACTIONS(1300),
    [anon_sym_void] = ACTIONS(1302),
    [anon_sym_delete] = ACTIONS(1302),
    [anon_sym_PLUS_PLUS] = ACTIONS(1300),
    [anon_sym_DASH_DASH] = ACTIONS(1300),
    [anon_sym_DQUOTE] = ACTIONS(1300),
    [anon_sym_SQUOTE] = ACTIONS(1300),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(1300),
    [sym_number] = ACTIONS(1300),
    [sym_this] = ACTIONS(1302),
    [sym_super] = ACTIONS(1302),
    [sym_true] = ACTIONS(1302),
    [sym_false] = ACTIONS(1302),
    [sym_null] = ACTIONS(1302),
    [sym_undefined] = ACTIONS(1302),
    [anon_sym_AT] = ACTIONS(1300),
    [anon_sym_static] = ACTIONS(1302),
    [anon_sym_readonly] = ACTIONS(1302),
    [anon_sym_get] = ACTIONS(1302),
    [anon_sym_set] = ACTIONS(1302),
    [anon_sym_declare] = ACTIONS(1302),
    [anon_sym_public] = ACTIONS(1302),
    [anon_sym_private] = ACTIONS(1302),
    [anon_sym_protected] = ACTIONS(1302),
    [anon_sym_override] = ACTIONS(1302),
    [anon_sym_module] = ACTIONS(1302),
    [anon_sym_any] = ACTIONS(1302),
    [anon_sym_number] = ACTIONS(1302),
    [anon_sym_boolean] = ACTIONS(1302),
    [anon_sym_string] = ACTIONS(1302),
    [anon_sym_symbol] = ACTIONS(1302),
    [anon_sym_abstract] = ACTIONS(1302),
    [anon_sym_interface] = ACTIONS(1302),
    [anon_sym_enum] = ACTIONS(1302),
    [sym__automatic_semicolon] = ACTIONS(1300),
    [sym__ternary_qmark] = ACTIONS(1300),
  },
  [116] = {
    [ts_builtin_sym_end] = ACTIONS(1308),
    [sym_identifier] = ACTIONS(1310),
    [anon_sym_export] = ACTIONS(1310),
    [anon_sym_STAR] = ACTIONS(1310),
    [anon_sym_default] = ACTIONS(1310),
    [anon_sym_type] = ACTIONS(1310),
    [anon_sym_as] = ACTIONS(1310),
    [anon_sym_namespace] = ACTIONS(1310),
    [anon_sym_LBRACE] = ACTIONS(1308),
    [anon_sym_COMMA] = ACTIONS(1308),
    [anon_sym_RBRACE] = ACTIONS(1308),
    [anon_sym_typeof] = ACTIONS(1310),
    [anon_sym_import] = ACTIONS(1310),
    [anon_sym_var] = ACTIONS(1310),
    [anon_sym_let] = ACTIONS(1310),
    [anon_sym_const] = ACTIONS(1310),
    [anon_sym_BANG] = ACTIONS(1310),
    [anon_sym_else] = ACTIONS(1310),
    [anon_sym_if] = ACTIONS(1310),
    [anon_sym_switch] = ACTIONS(1310),
    [anon_sym_for] = ACTIONS(1310),
    [anon_sym_LPAREN] = ACTIONS(1308),
    [anon_sym_await] = ACTIONS(1310),
    [anon_sym_in] = ACTIONS(1310),
    [anon_sym_while] = ACTIONS(1310),
    [anon_sym_do] = ACTIONS(1310),
    [anon_sym_try] = ACTIONS(1310),
    [anon_sym_with] = ACTIONS(1310),
    [anon_sym_break] = ACTIONS(1310),
    [anon_sym_continue] = ACTIONS(1310),
    [anon_sym_debugger] = ACTIONS(1310),
    [anon_sym_return] = ACTIONS(1310),
    [anon_sym_throw] = ACTIONS(1310),
    [anon_sym_SEMI] = ACTIONS(1308),
    [anon_sym_case] = ACTIONS(1310),
    [anon_sym_yield] = ACTIONS(1310),
    [anon_sym_LBRACK] = ACTIONS(1308),
    [anon_sym_LT] = ACTIONS(1310),
    [anon_sym_GT] = ACTIONS(1310),
    [anon_sym_SLASH] = ACTIONS(1310),
    [anon_sym_DOT] = ACTIONS(1310),
    [anon_sym_class] = ACTIONS(1310),
    [anon_sym_async] = ACTIONS(1310),
    [anon_sym_function] = ACTIONS(1310),
    [anon_sym_QMARK_DOT] = ACTIONS(1308),
    [anon_sym_new] = ACTIONS(1310),
    [anon_sym_AMP_AMP] = ACTIONS(1308),
    [anon_sym_PIPE_PIPE] = ACTIONS(1308),
    [anon_sym_GT_GT] = ACTIONS(1310),
    [anon_sym_GT_GT_GT] = ACTIONS(1308),
    [anon_sym_LT_LT] = ACTIONS(1308),
    [anon_sym_AMP] = ACTIONS(1310),
    [anon_sym_CARET] = ACTIONS(1308),
    [anon_sym_PIPE] = ACTIONS(1310),
    [anon_sym_PLUS] = ACTIONS(1310),
    [anon_sym_DASH] = ACTIONS(1310),
    [anon_sym_PERCENT] = ACTIONS(1308),
    [anon_sym_STAR_STAR] = ACTIONS(1308),
    [anon_sym_LT_EQ] = ACTIONS(1308),
    [anon_sym_EQ_EQ] = ACTIONS(1310),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(1308),
    [anon_sym_BANG_EQ] = ACTIONS(1310),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(1308),
    [anon_sym_GT_EQ] = ACTIONS(1308),
    [anon_sym_QMARK_QMARK] = ACTIONS(1308),
    [anon_sym_instanceof] = ACTIONS(1310),
    [anon_sym_TILDE] = ACTIONS(1308),
    [anon_sym_void] = ACTIONS(1310),
    [anon_sym_delete] = ACTIONS(1310),
    [anon_sym_PLUS_PLUS] = ACTIONS(1308),
    [anon_sym_DASH_DASH] = ACTIONS(1308),
    [anon_sym_DQUOTE] = ACTIONS(1308),
    [anon_sym_SQUOTE] = ACTIONS(1308),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(1308),
    [sym_number] = ACTIONS(1308),
    [sym_this] = ACTIONS(1310),
    [sym_super] = ACTIONS(1310),
    [sym_true] = ACTIONS(1310),
    [sym_false] = ACTIONS(1310),
    [sym_null] = ACTIONS(1310),
    [sym_undefined] = ACTIONS(1310),
    [anon_sym_AT] = ACTIONS(1308),
    [anon_sym_static] = ACTIONS(1310),
    [anon_sym_readonly] = ACTIONS(1310),
    [anon_sym_get] = ACTIONS(1310),
    [anon_sym_set] = ACTIONS(1310),
    [anon_sym_declare] = ACTIONS(1310),
    [anon_sym_public] = ACTIONS(1310),
    [anon_sym_private] = ACTIONS(1310),
    [anon_sym_protected] = ACTIONS(1310),
    [anon_sym_override] = ACTIONS(1310),
    [anon_sym_module] = ACTIONS(1310),
    [anon_sym_any] = ACTIONS(1310),
    [anon_sym_number] = ACTIONS(1310),
    [anon_sym_boolean] = ACTIONS(1310),
    [anon_sym_string] = ACTIONS(1310),
    [anon_sym_symbol] = ACTIONS(1310),
    [anon_sym_abstract] = ACTIONS(1310),
    [anon_sym_interface] = ACTIONS(1310),
    [anon_sym_enum] = ACTIONS(1310),
    [sym__automatic_semicolon] = ACTIONS(1308),
    [sym__ternary_qmark] = ACTIONS(1308),
  },
  [117] = {
    [sym_import] = STATE(1405),
    [sym_parenthesized_expression] = STATE(1072),
    [sym_expression] = STATE(1493),
    [sym_primary_expression] = STATE(1404),
    [sym_yield_expression] = STATE(1403),
    [sym_object] = STATE(1405),
    [sym_object_pattern] = STATE(2812),
    [sym_array] = STATE(1405),
    [sym_array_pattern] = STATE(2812),
    [sym_class] = STATE(1405),
    [sym_function] = STATE(1405),
    [sym_generator_function] = STATE(1405),
    [sym_arrow_function] = STATE(1405),
    [sym__call_signature] = STATE(4121),
    [sym__formal_parameter] = STATE(3477),
    [sym_call_expression] = STATE(1405),
    [sym_new_expression] = STATE(1403),
    [sym_await_expression] = STATE(1403),
    [sym_member_expression] = STATE(1056),
    [sym_subscript_expression] = STATE(1056),
    [sym_assignment_expression] = STATE(1403),
    [sym__augmented_assignment_lhs] = STATE(2344),
    [sym_augmented_assignment_expression] = STATE(1403),
    [sym__destructuring_pattern] = STATE(2812),
    [sym_ternary_expression] = STATE(1403),
    [sym_binary_expression] = STATE(1403),
    [sym_unary_expression] = STATE(1403),
    [sym_update_expression] = STATE(1403),
    [sym_sequence_expression] = STATE(4106),
    [sym_string] = STATE(1405),
    [sym_template_string] = STATE(1405),
    [sym_regex] = STATE(1405),
    [sym_meta_property] = STATE(1405),
    [sym_decorator] = STATE(1149),
    [sym_formal_parameters] = STATE(2903),
    [sym_pattern] = STATE(3265),
    [sym_rest_pattern] = STATE(2817),
    [sym_non_null_expression] = STATE(1056),
    [sym_type_assertion] = STATE(1403),
    [sym_as_expression] = STATE(1403),
    [sym_internal_module] = STATE(1403),
    [sym_accessibility_modifier] = STATE(200),
    [sym_override_modifier] = STATE(206),
    [sym_required_parameter] = STATE(3477),
    [sym_optional_parameter] = STATE(3477),
    [sym__parameter_name] = STATE(2820),
    [sym_type_arguments] = STATE(502),
    [sym_type_parameters] = STATE(3670),
    [aux_sym_export_statement_repeat1] = STATE(181),
    [sym_identifier] = ACTIONS(1312),
    [anon_sym_export] = ACTIONS(535),
    [anon_sym_type] = ACTIONS(535),
    [anon_sym_namespace] = ACTIONS(539),
    [anon_sym_LBRACE] = ACTIONS(1135),
    [anon_sym_typeof] = ACTIONS(573),
    [anon_sym_import] = ACTIONS(125),
    [anon_sym_BANG] = ACTIONS(547),
    [anon_sym_LPAREN] = ACTIONS(1083),
    [anon_sym_RPAREN] = ACTIONS(651),
    [anon_sym_await] = ACTIONS(549),
    [anon_sym_yield] = ACTIONS(551),
    [anon_sym_LBRACK] = ACTIONS(1137),
    [anon_sym_LT] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(557),
    [anon_sym_class] = ACTIONS(143),
    [anon_sym_async] = ACTIONS(559),
    [anon_sym_function] = ACTIONS(147),
    [anon_sym_new] = ACTIONS(1087),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(157),
    [anon_sym_PLUS] = ACTIONS(573),
    [anon_sym_DASH] = ACTIONS(573),
    [anon_sym_TILDE] = ACTIONS(547),
    [anon_sym_void] = ACTIONS(573),
    [anon_sym_delete] = ACTIONS(573),
    [anon_sym_PLUS_PLUS] = ACTIONS(575),
    [anon_sym_DASH_DASH] = ACTIONS(575),
    [anon_sym_DQUOTE] = ACTIONS(174),
    [anon_sym_SQUOTE] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(1089),
    [sym_number] = ACTIONS(625),
    [sym_this] = ACTIONS(1314),
    [sym_super] = ACTIONS(184),
    [sym_true] = ACTIONS(184),
    [sym_false] = ACTIONS(184),
    [sym_null] = ACTIONS(184),
    [sym_undefined] = ACTIONS(1316),
    [anon_sym_AT] = ACTIONS(91),
    [anon_sym_static] = ACTIONS(535),
    [anon_sym_readonly] = ACTIONS(1318),
    [anon_sym_get] = ACTIONS(535),
    [anon_sym_set] = ACTIONS(535),
    [anon_sym_declare] = ACTIONS(535),
    [anon_sym_public] = ACTIONS(669),
    [anon_sym_private] = ACTIONS(669),
    [anon_sym_protected] = ACTIONS(669),
    [anon_sym_override] = ACTIONS(671),
    [anon_sym_module] = ACTIONS(535),
    [anon_sym_any] = ACTIONS(535),
    [anon_sym_number] = ACTIONS(535),
    [anon_sym_boolean] = ACTIONS(535),
    [anon_sym_string] = ACTIONS(535),
    [anon_sym_symbol] = ACTIONS(535),
  },
  [118] = {
    [ts_builtin_sym_end] = ACTIONS(1320),
    [sym_identifier] = ACTIONS(1322),
    [anon_sym_export] = ACTIONS(1322),
    [anon_sym_STAR] = ACTIONS(1322),
    [anon_sym_default] = ACTIONS(1322),
    [anon_sym_type] = ACTIONS(1322),
    [anon_sym_as] = ACTIONS(1322),
    [anon_sym_namespace] = ACTIONS(1322),
    [anon_sym_LBRACE] = ACTIONS(1320),
    [anon_sym_COMMA] = ACTIONS(1320),
    [anon_sym_RBRACE] = ACTIONS(1320),
    [anon_sym_typeof] = ACTIONS(1322),
    [anon_sym_import] = ACTIONS(1322),
    [anon_sym_var] = ACTIONS(1322),
    [anon_sym_let] = ACTIONS(1322),
    [anon_sym_const] = ACTIONS(1322),
    [anon_sym_BANG] = ACTIONS(1322),
    [anon_sym_else] = ACTIONS(1322),
    [anon_sym_if] = ACTIONS(1322),
    [anon_sym_switch] = ACTIONS(1322),
    [anon_sym_for] = ACTIONS(1322),
    [anon_sym_LPAREN] = ACTIONS(1320),
    [anon_sym_await] = ACTIONS(1322),
    [anon_sym_in] = ACTIONS(1322),
    [anon_sym_while] = ACTIONS(1322),
    [anon_sym_do] = ACTIONS(1322),
    [anon_sym_try] = ACTIONS(1322),
    [anon_sym_with] = ACTIONS(1322),
    [anon_sym_break] = ACTIONS(1322),
    [anon_sym_continue] = ACTIONS(1322),
    [anon_sym_debugger] = ACTIONS(1322),
    [anon_sym_return] = ACTIONS(1322),
    [anon_sym_throw] = ACTIONS(1322),
    [anon_sym_SEMI] = ACTIONS(1320),
    [anon_sym_case] = ACTIONS(1322),
    [anon_sym_yield] = ACTIONS(1322),
    [anon_sym_LBRACK] = ACTIONS(1320),
    [anon_sym_LT] = ACTIONS(1322),
    [anon_sym_GT] = ACTIONS(1322),
    [anon_sym_SLASH] = ACTIONS(1322),
    [anon_sym_DOT] = ACTIONS(1322),
    [anon_sym_class] = ACTIONS(1322),
    [anon_sym_async] = ACTIONS(1322),
    [anon_sym_function] = ACTIONS(1322),
    [anon_sym_QMARK_DOT] = ACTIONS(1320),
    [anon_sym_new] = ACTIONS(1322),
    [anon_sym_AMP_AMP] = ACTIONS(1320),
    [anon_sym_PIPE_PIPE] = ACTIONS(1320),
    [anon_sym_GT_GT] = ACTIONS(1322),
    [anon_sym_GT_GT_GT] = ACTIONS(1320),
    [anon_sym_LT_LT] = ACTIONS(1320),
    [anon_sym_AMP] = ACTIONS(1322),
    [anon_sym_CARET] = ACTIONS(1320),
    [anon_sym_PIPE] = ACTIONS(1322),
    [anon_sym_PLUS] = ACTIONS(1322),
    [anon_sym_DASH] = ACTIONS(1322),
    [anon_sym_PERCENT] = ACTIONS(1320),
    [anon_sym_STAR_STAR] = ACTIONS(1320),
    [anon_sym_LT_EQ] = ACTIONS(1320),
    [anon_sym_EQ_EQ] = ACTIONS(1322),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(1320),
    [anon_sym_BANG_EQ] = ACTIONS(1322),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(1320),
    [anon_sym_GT_EQ] = ACTIONS(1320),
    [anon_sym_QMARK_QMARK] = ACTIONS(1320),
    [anon_sym_instanceof] = ACTIONS(1322),
    [anon_sym_TILDE] = ACTIONS(1320),
    [anon_sym_void] = ACTIONS(1322),
    [anon_sym_delete] = ACTIONS(1322),
    [anon_sym_PLUS_PLUS] = ACTIONS(1320),
    [anon_sym_DASH_DASH] = ACTIONS(1320),
    [anon_sym_DQUOTE] = ACTIONS(1320),
    [anon_sym_SQUOTE] = ACTIONS(1320),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(1320),
    [sym_number] = ACTIONS(1320),
    [sym_this] = ACTIONS(1322),
    [sym_super] = ACTIONS(1322),
    [sym_true] = ACTIONS(1322),
    [sym_false] = ACTIONS(1322),
    [sym_null] = ACTIONS(1322),
    [sym_undefined] = ACTIONS(1322),
    [anon_sym_AT] = ACTIONS(1320),
    [anon_sym_static] = ACTIONS(1322),
    [anon_sym_readonly] = ACTIONS(1322),
    [anon_sym_get] = ACTIONS(1322),
    [anon_sym_set] = ACTIONS(1322),
    [anon_sym_declare] = ACTIONS(1322),
    [anon_sym_public] = ACTIONS(1322),
    [anon_sym_private] = ACTIONS(1322),
    [anon_sym_protected] = ACTIONS(1322),
    [anon_sym_override] = ACTIONS(1322),
    [anon_sym_module] = ACTIONS(1322),
    [anon_sym_any] = ACTIONS(1322),
    [anon_sym_number] = ACTIONS(1322),
    [anon_sym_boolean] = ACTIONS(1322),
    [anon_sym_string] = ACTIONS(1322),
    [anon_sym_symbol] = ACTIONS(1322),
    [anon_sym_abstract] = ACTIONS(1322),
    [anon_sym_interface] = ACTIONS(1322),
    [anon_sym_enum] = ACTIONS(1322),
    [sym__automatic_semicolon] = ACTIONS(1320),
    [sym__ternary_qmark] = ACTIONS(1320),
  },
  [119] = {
    [ts_builtin_sym_end] = ACTIONS(1324),
    [sym_identifier] = ACTIONS(1326),
    [anon_sym_export] = ACTIONS(1326),
    [anon_sym_STAR] = ACTIONS(1328),
    [anon_sym_default] = ACTIONS(1326),
    [anon_sym_type] = ACTIONS(1326),
    [anon_sym_as] = ACTIONS(1328),
    [anon_sym_namespace] = ACTIONS(1326),
    [anon_sym_LBRACE] = ACTIONS(1324),
    [anon_sym_COMMA] = ACTIONS(1330),
    [anon_sym_RBRACE] = ACTIONS(1324),
    [anon_sym_typeof] = ACTIONS(1326),
    [anon_sym_import] = ACTIONS(1326),
    [anon_sym_var] = ACTIONS(1326),
    [anon_sym_let] = ACTIONS(1326),
    [anon_sym_const] = ACTIONS(1326),
    [anon_sym_BANG] = ACTIONS(1326),
    [anon_sym_else] = ACTIONS(1326),
    [anon_sym_if] = ACTIONS(1326),
    [anon_sym_switch] = ACTIONS(1326),
    [anon_sym_for] = ACTIONS(1326),
    [anon_sym_LPAREN] = ACTIONS(1324),
    [anon_sym_await] = ACTIONS(1326),
    [anon_sym_in] = ACTIONS(1328),
    [anon_sym_while] = ACTIONS(1326),
    [anon_sym_do] = ACTIONS(1326),
    [anon_sym_try] = ACTIONS(1326),
    [anon_sym_with] = ACTIONS(1326),
    [anon_sym_break] = ACTIONS(1326),
    [anon_sym_continue] = ACTIONS(1326),
    [anon_sym_debugger] = ACTIONS(1326),
    [anon_sym_return] = ACTIONS(1326),
    [anon_sym_throw] = ACTIONS(1326),
    [anon_sym_SEMI] = ACTIONS(1324),
    [anon_sym_case] = ACTIONS(1326),
    [anon_sym_yield] = ACTIONS(1326),
    [anon_sym_LBRACK] = ACTIONS(1324),
    [anon_sym_LT] = ACTIONS(1326),
    [anon_sym_GT] = ACTIONS(1328),
    [anon_sym_SLASH] = ACTIONS(1326),
    [anon_sym_DOT] = ACTIONS(1328),
    [anon_sym_class] = ACTIONS(1326),
    [anon_sym_async] = ACTIONS(1326),
    [anon_sym_function] = ACTIONS(1326),
    [anon_sym_QMARK_DOT] = ACTIONS(1330),
    [anon_sym_new] = ACTIONS(1326),
    [anon_sym_AMP_AMP] = ACTIONS(1330),
    [anon_sym_PIPE_PIPE] = ACTIONS(1330),
    [anon_sym_GT_GT] = ACTIONS(1328),
    [anon_sym_GT_GT_GT] = ACTIONS(1330),
    [anon_sym_LT_LT] = ACTIONS(1330),
    [anon_sym_AMP] = ACTIONS(1328),
    [anon_sym_CARET] = ACTIONS(1330),
    [anon_sym_PIPE] = ACTIONS(1328),
    [anon_sym_PLUS] = ACTIONS(1326),
    [anon_sym_DASH] = ACTIONS(1326),
    [anon_sym_PERCENT] = ACTIONS(1330),
    [anon_sym_STAR_STAR] = ACTIONS(1330),
    [anon_sym_LT_EQ] = ACTIONS(1330),
    [anon_sym_EQ_EQ] = ACTIONS(1328),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(1330),
    [anon_sym_BANG_EQ] = ACTIONS(1328),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(1330),
    [anon_sym_GT_EQ] = ACTIONS(1330),
    [anon_sym_QMARK_QMARK] = ACTIONS(1330),
    [anon_sym_instanceof] = ACTIONS(1328),
    [anon_sym_TILDE] = ACTIONS(1324),
    [anon_sym_void] = ACTIONS(1326),
    [anon_sym_delete] = ACTIONS(1326),
    [anon_sym_PLUS_PLUS] = ACTIONS(1324),
    [anon_sym_DASH_DASH] = ACTIONS(1324),
    [anon_sym_DQUOTE] = ACTIONS(1324),
    [anon_sym_SQUOTE] = ACTIONS(1324),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(1324),
    [sym_number] = ACTIONS(1324),
    [sym_this] = ACTIONS(1326),
    [sym_super] = ACTIONS(1326),
    [sym_true] = ACTIONS(1326),
    [sym_false] = ACTIONS(1326),
    [sym_null] = ACTIONS(1326),
    [sym_undefined] = ACTIONS(1326),
    [anon_sym_AT] = ACTIONS(1324),
    [anon_sym_static] = ACTIONS(1326),
    [anon_sym_readonly] = ACTIONS(1326),
    [anon_sym_get] = ACTIONS(1326),
    [anon_sym_set] = ACTIONS(1326),
    [anon_sym_declare] = ACTIONS(1326),
    [anon_sym_public] = ACTIONS(1326),
    [anon_sym_private] = ACTIONS(1326),
    [anon_sym_protected] = ACTIONS(1326),
    [anon_sym_override] = ACTIONS(1326),
    [anon_sym_module] = ACTIONS(1326),
    [anon_sym_any] = ACTIONS(1326),
    [anon_sym_number] = ACTIONS(1326),
    [anon_sym_boolean] = ACTIONS(1326),
    [anon_sym_string] = ACTIONS(1326),
    [anon_sym_symbol] = ACTIONS(1326),
    [anon_sym_abstract] = ACTIONS(1326),
    [anon_sym_interface] = ACTIONS(1326),
    [anon_sym_enum] = ACTIONS(1326),
    [sym__automatic_semicolon] = ACTIONS(1332),
    [sym__ternary_qmark] = ACTIONS(1330),
  },
  [120] = {
    [ts_builtin_sym_end] = ACTIONS(1334),
    [sym_identifier] = ACTIONS(1336),
    [anon_sym_export] = ACTIONS(1336),
    [anon_sym_STAR] = ACTIONS(1336),
    [anon_sym_default] = ACTIONS(1336),
    [anon_sym_type] = ACTIONS(1336),
    [anon_sym_as] = ACTIONS(1336),
    [anon_sym_namespace] = ACTIONS(1336),
    [anon_sym_LBRACE] = ACTIONS(1334),
    [anon_sym_COMMA] = ACTIONS(1334),
    [anon_sym_RBRACE] = ACTIONS(1334),
    [anon_sym_typeof] = ACTIONS(1336),
    [anon_sym_import] = ACTIONS(1336),
    [anon_sym_var] = ACTIONS(1336),
    [anon_sym_let] = ACTIONS(1336),
    [anon_sym_const] = ACTIONS(1336),
    [anon_sym_BANG] = ACTIONS(1336),
    [anon_sym_else] = ACTIONS(1336),
    [anon_sym_if] = ACTIONS(1336),
    [anon_sym_switch] = ACTIONS(1336),
    [anon_sym_for] = ACTIONS(1336),
    [anon_sym_LPAREN] = ACTIONS(1334),
    [anon_sym_await] = ACTIONS(1336),
    [anon_sym_in] = ACTIONS(1336),
    [anon_sym_while] = ACTIONS(1336),
    [anon_sym_do] = ACTIONS(1336),
    [anon_sym_try] = ACTIONS(1336),
    [anon_sym_with] = ACTIONS(1336),
    [anon_sym_break] = ACTIONS(1336),
    [anon_sym_continue] = ACTIONS(1336),
    [anon_sym_debugger] = ACTIONS(1336),
    [anon_sym_return] = ACTIONS(1336),
    [anon_sym_throw] = ACTIONS(1336),
    [anon_sym_SEMI] = ACTIONS(1334),
    [anon_sym_case] = ACTIONS(1336),
    [anon_sym_yield] = ACTIONS(1336),
    [anon_sym_LBRACK] = ACTIONS(1334),
    [anon_sym_LT] = ACTIONS(1336),
    [anon_sym_GT] = ACTIONS(1336),
    [anon_sym_SLASH] = ACTIONS(1336),
    [anon_sym_DOT] = ACTIONS(1336),
    [anon_sym_class] = ACTIONS(1336),
    [anon_sym_async] = ACTIONS(1336),
    [anon_sym_function] = ACTIONS(1336),
    [anon_sym_QMARK_DOT] = ACTIONS(1334),
    [anon_sym_new] = ACTIONS(1336),
    [anon_sym_AMP_AMP] = ACTIONS(1334),
    [anon_sym_PIPE_PIPE] = ACTIONS(1334),
    [anon_sym_GT_GT] = ACTIONS(1336),
    [anon_sym_GT_GT_GT] = ACTIONS(1334),
    [anon_sym_LT_LT] = ACTIONS(1334),
    [anon_sym_AMP] = ACTIONS(1336),
    [anon_sym_CARET] = ACTIONS(1334),
    [anon_sym_PIPE] = ACTIONS(1336),
    [anon_sym_PLUS] = ACTIONS(1336),
    [anon_sym_DASH] = ACTIONS(1336),
    [anon_sym_PERCENT] = ACTIONS(1334),
    [anon_sym_STAR_STAR] = ACTIONS(1334),
    [anon_sym_LT_EQ] = ACTIONS(1334),
    [anon_sym_EQ_EQ] = ACTIONS(1336),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(1334),
    [anon_sym_BANG_EQ] = ACTIONS(1336),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(1334),
    [anon_sym_GT_EQ] = ACTIONS(1334),
    [anon_sym_QMARK_QMARK] = ACTIONS(1334),
    [anon_sym_instanceof] = ACTIONS(1336),
    [anon_sym_TILDE] = ACTIONS(1334),
    [anon_sym_void] = ACTIONS(1336),
    [anon_sym_delete] = ACTIONS(1336),
    [anon_sym_PLUS_PLUS] = ACTIONS(1334),
    [anon_sym_DASH_DASH] = ACTIONS(1334),
    [anon_sym_DQUOTE] = ACTIONS(1334),
    [anon_sym_SQUOTE] = ACTIONS(1334),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(1334),
    [sym_number] = ACTIONS(1334),
    [sym_this] = ACTIONS(1336),
    [sym_super] = ACTIONS(1336),
    [sym_true] = ACTIONS(1336),
    [sym_false] = ACTIONS(1336),
    [sym_null] = ACTIONS(1336),
    [sym_undefined] = ACTIONS(1336),
    [anon_sym_AT] = ACTIONS(1334),
    [anon_sym_static] = ACTIONS(1336),
    [anon_sym_readonly] = ACTIONS(1336),
    [anon_sym_get] = ACTIONS(1336),
    [anon_sym_set] = ACTIONS(1336),
    [anon_sym_declare] = ACTIONS(1336),
    [anon_sym_public] = ACTIONS(1336),
    [anon_sym_private] = ACTIONS(1336),
    [anon_sym_protected] = ACTIONS(1336),
    [anon_sym_override] = ACTIONS(1336),
    [anon_sym_module] = ACTIONS(1336),
    [anon_sym_any] = ACTIONS(1336),
    [anon_sym_number] = ACTIONS(1336),
    [anon_sym_boolean] = ACTIONS(1336),
    [anon_sym_string] = ACTIONS(1336),
    [anon_sym_symbol] = ACTIONS(1336),
    [anon_sym_abstract] = ACTIONS(1336),
    [anon_sym_interface] = ACTIONS(1336),
    [anon_sym_enum] = ACTIONS(1336),
    [sym__automatic_semicolon] = ACTIONS(1334),
    [sym__ternary_qmark] = ACTIONS(1334),
  },
  [121] = {
    [ts_builtin_sym_end] = ACTIONS(1338),
    [sym_identifier] = ACTIONS(1340),
    [anon_sym_export] = ACTIONS(1340),
    [anon_sym_STAR] = ACTIONS(1342),
    [anon_sym_default] = ACTIONS(1340),
    [anon_sym_type] = ACTIONS(1340),
    [anon_sym_as] = ACTIONS(1342),
    [anon_sym_namespace] = ACTIONS(1340),
    [anon_sym_LBRACE] = ACTIONS(1338),
    [anon_sym_COMMA] = ACTIONS(1344),
    [anon_sym_RBRACE] = ACTIONS(1338),
    [anon_sym_typeof] = ACTIONS(1340),
    [anon_sym_import] = ACTIONS(1340),
    [anon_sym_var] = ACTIONS(1340),
    [anon_sym_let] = ACTIONS(1340),
    [anon_sym_const] = ACTIONS(1340),
    [anon_sym_BANG] = ACTIONS(1340),
    [anon_sym_else] = ACTIONS(1340),
    [anon_sym_if] = ACTIONS(1340),
    [anon_sym_switch] = ACTIONS(1340),
    [anon_sym_for] = ACTIONS(1340),
    [anon_sym_LPAREN] = ACTIONS(1338),
    [anon_sym_await] = ACTIONS(1340),
    [anon_sym_in] = ACTIONS(1342),
    [anon_sym_while] = ACTIONS(1340),
    [anon_sym_do] = ACTIONS(1340),
    [anon_sym_try] = ACTIONS(1340),
    [anon_sym_with] = ACTIONS(1340),
    [anon_sym_break] = ACTIONS(1340),
    [anon_sym_continue] = ACTIONS(1340),
    [anon_sym_debugger] = ACTIONS(1340),
    [anon_sym_return] = ACTIONS(1340),
    [anon_sym_throw] = ACTIONS(1340),
    [anon_sym_SEMI] = ACTIONS(1338),
    [anon_sym_case] = ACTIONS(1340),
    [anon_sym_yield] = ACTIONS(1340),
    [anon_sym_LBRACK] = ACTIONS(1338),
    [anon_sym_LT] = ACTIONS(1340),
    [anon_sym_GT] = ACTIONS(1342),
    [anon_sym_SLASH] = ACTIONS(1340),
    [anon_sym_DOT] = ACTIONS(1342),
    [anon_sym_class] = ACTIONS(1340),
    [anon_sym_async] = ACTIONS(1340),
    [anon_sym_function] = ACTIONS(1340),
    [anon_sym_QMARK_DOT] = ACTIONS(1344),
    [anon_sym_new] = ACTIONS(1340),
    [anon_sym_AMP_AMP] = ACTIONS(1344),
    [anon_sym_PIPE_PIPE] = ACTIONS(1344),
    [anon_sym_GT_GT] = ACTIONS(1342),
    [anon_sym_GT_GT_GT] = ACTIONS(1344),
    [anon_sym_LT_LT] = ACTIONS(1344),
    [anon_sym_AMP] = ACTIONS(1342),
    [anon_sym_CARET] = ACTIONS(1344),
    [anon_sym_PIPE] = ACTIONS(1342),
    [anon_sym_PLUS] = ACTIONS(1340),
    [anon_sym_DASH] = ACTIONS(1340),
    [anon_sym_PERCENT] = ACTIONS(1344),
    [anon_sym_STAR_STAR] = ACTIONS(1344),
    [anon_sym_LT_EQ] = ACTIONS(1344),
    [anon_sym_EQ_EQ] = ACTIONS(1342),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(1344),
    [anon_sym_BANG_EQ] = ACTIONS(1342),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(1344),
    [anon_sym_GT_EQ] = ACTIONS(1344),
    [anon_sym_QMARK_QMARK] = ACTIONS(1344),
    [anon_sym_instanceof] = ACTIONS(1342),
    [anon_sym_TILDE] = ACTIONS(1338),
    [anon_sym_void] = ACTIONS(1340),
    [anon_sym_delete] = ACTIONS(1340),
    [anon_sym_PLUS_PLUS] = ACTIONS(1338),
    [anon_sym_DASH_DASH] = ACTIONS(1338),
    [anon_sym_DQUOTE] = ACTIONS(1338),
    [anon_sym_SQUOTE] = ACTIONS(1338),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(1338),
    [sym_number] = ACTIONS(1338),
    [sym_this] = ACTIONS(1340),
    [sym_super] = ACTIONS(1340),
    [sym_true] = ACTIONS(1340),
    [sym_false] = ACTIONS(1340),
    [sym_null] = ACTIONS(1340),
    [sym_undefined] = ACTIONS(1340),
    [anon_sym_AT] = ACTIONS(1338),
    [anon_sym_static] = ACTIONS(1340),
    [anon_sym_readonly] = ACTIONS(1340),
    [anon_sym_get] = ACTIONS(1340),
    [anon_sym_set] = ACTIONS(1340),
    [anon_sym_declare] = ACTIONS(1340),
    [anon_sym_public] = ACTIONS(1340),
    [anon_sym_private] = ACTIONS(1340),
    [anon_sym_protected] = ACTIONS(1340),
    [anon_sym_override] = ACTIONS(1340),
    [anon_sym_module] = ACTIONS(1340),
    [anon_sym_any] = ACTIONS(1340),
    [anon_sym_number] = ACTIONS(1340),
    [anon_sym_boolean] = ACTIONS(1340),
    [anon_sym_string] = ACTIONS(1340),
    [anon_sym_symbol] = ACTIONS(1340),
    [anon_sym_abstract] = ACTIONS(1340),
    [anon_sym_interface] = ACTIONS(1340),
    [anon_sym_enum] = ACTIONS(1340),
    [sym__automatic_semicolon] = ACTIONS(1346),
    [sym__ternary_qmark] = ACTIONS(1344),
  },
  [122] = {
    [ts_builtin_sym_end] = ACTIONS(1348),
    [sym_identifier] = ACTIONS(1350),
    [anon_sym_export] = ACTIONS(1350),
    [anon_sym_STAR] = ACTIONS(1352),
    [anon_sym_default] = ACTIONS(1350),
    [anon_sym_type] = ACTIONS(1350),
    [anon_sym_as] = ACTIONS(1352),
    [anon_sym_namespace] = ACTIONS(1350),
    [anon_sym_LBRACE] = ACTIONS(1348),
    [anon_sym_COMMA] = ACTIONS(1354),
    [anon_sym_RBRACE] = ACTIONS(1348),
    [anon_sym_typeof] = ACTIONS(1350),
    [anon_sym_import] = ACTIONS(1350),
    [anon_sym_var] = ACTIONS(1350),
    [anon_sym_let] = ACTIONS(1350),
    [anon_sym_const] = ACTIONS(1350),
    [anon_sym_BANG] = ACTIONS(1350),
    [anon_sym_else] = ACTIONS(1350),
    [anon_sym_if] = ACTIONS(1350),
    [anon_sym_switch] = ACTIONS(1350),
    [anon_sym_for] = ACTIONS(1350),
    [anon_sym_LPAREN] = ACTIONS(1348),
    [anon_sym_await] = ACTIONS(1350),
    [anon_sym_in] = ACTIONS(1352),
    [anon_sym_while] = ACTIONS(1350),
    [anon_sym_do] = ACTIONS(1350),
    [anon_sym_try] = ACTIONS(1350),
    [anon_sym_with] = ACTIONS(1350),
    [anon_sym_break] = ACTIONS(1350),
    [anon_sym_continue] = ACTIONS(1350),
    [anon_sym_debugger] = ACTIONS(1350),
    [anon_sym_return] = ACTIONS(1350),
    [anon_sym_throw] = ACTIONS(1350),
    [anon_sym_SEMI] = ACTIONS(1348),
    [anon_sym_case] = ACTIONS(1350),
    [anon_sym_yield] = ACTIONS(1350),
    [anon_sym_LBRACK] = ACTIONS(1348),
    [anon_sym_LT] = ACTIONS(1350),
    [anon_sym_GT] = ACTIONS(1352),
    [anon_sym_SLASH] = ACTIONS(1350),
    [anon_sym_DOT] = ACTIONS(1352),
    [anon_sym_class] = ACTIONS(1350),
    [anon_sym_async] = ACTIONS(1350),
    [anon_sym_function] = ACTIONS(1350),
    [anon_sym_QMARK_DOT] = ACTIONS(1354),
    [anon_sym_new] = ACTIONS(1350),
    [anon_sym_AMP_AMP] = ACTIONS(1354),
    [anon_sym_PIPE_PIPE] = ACTIONS(1354),
    [anon_sym_GT_GT] = ACTIONS(1352),
    [anon_sym_GT_GT_GT] = ACTIONS(1354),
    [anon_sym_LT_LT] = ACTIONS(1354),
    [anon_sym_AMP] = ACTIONS(1352),
    [anon_sym_CARET] = ACTIONS(1354),
    [anon_sym_PIPE] = ACTIONS(1352),
    [anon_sym_PLUS] = ACTIONS(1350),
    [anon_sym_DASH] = ACTIONS(1350),
    [anon_sym_PERCENT] = ACTIONS(1354),
    [anon_sym_STAR_STAR] = ACTIONS(1354),
    [anon_sym_LT_EQ] = ACTIONS(1354),
    [anon_sym_EQ_EQ] = ACTIONS(1352),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(1354),
    [anon_sym_BANG_EQ] = ACTIONS(1352),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(1354),
    [anon_sym_GT_EQ] = ACTIONS(1354),
    [anon_sym_QMARK_QMARK] = ACTIONS(1354),
    [anon_sym_instanceof] = ACTIONS(1352),
    [anon_sym_TILDE] = ACTIONS(1348),
    [anon_sym_void] = ACTIONS(1350),
    [anon_sym_delete] = ACTIONS(1350),
    [anon_sym_PLUS_PLUS] = ACTIONS(1348),
    [anon_sym_DASH_DASH] = ACTIONS(1348),
    [anon_sym_DQUOTE] = ACTIONS(1348),
    [anon_sym_SQUOTE] = ACTIONS(1348),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(1348),
    [sym_number] = ACTIONS(1348),
    [sym_this] = ACTIONS(1350),
    [sym_super] = ACTIONS(1350),
    [sym_true] = ACTIONS(1350),
    [sym_false] = ACTIONS(1350),
    [sym_null] = ACTIONS(1350),
    [sym_undefined] = ACTIONS(1350),
    [anon_sym_AT] = ACTIONS(1348),
    [anon_sym_static] = ACTIONS(1350),
    [anon_sym_readonly] = ACTIONS(1350),
    [anon_sym_get] = ACTIONS(1350),
    [anon_sym_set] = ACTIONS(1350),
    [anon_sym_declare] = ACTIONS(1350),
    [anon_sym_public] = ACTIONS(1350),
    [anon_sym_private] = ACTIONS(1350),
    [anon_sym_protected] = ACTIONS(1350),
    [anon_sym_override] = ACTIONS(1350),
    [anon_sym_module] = ACTIONS(1350),
    [anon_sym_any] = ACTIONS(1350),
    [anon_sym_number] = ACTIONS(1350),
    [anon_sym_boolean] = ACTIONS(1350),
    [anon_sym_string] = ACTIONS(1350),
    [anon_sym_symbol] = ACTIONS(1350),
    [anon_sym_abstract] = ACTIONS(1350),
    [anon_sym_interface] = ACTIONS(1350),
    [anon_sym_enum] = ACTIONS(1350),
    [sym__automatic_semicolon] = ACTIONS(1356),
    [sym__ternary_qmark] = ACTIONS(1354),
  },
  [123] = {
    [ts_builtin_sym_end] = ACTIONS(1358),
    [sym_identifier] = ACTIONS(1360),
    [anon_sym_export] = ACTIONS(1360),
    [anon_sym_STAR] = ACTIONS(1362),
    [anon_sym_default] = ACTIONS(1360),
    [anon_sym_type] = ACTIONS(1360),
    [anon_sym_as] = ACTIONS(1362),
    [anon_sym_namespace] = ACTIONS(1360),
    [anon_sym_LBRACE] = ACTIONS(1358),
    [anon_sym_COMMA] = ACTIONS(1364),
    [anon_sym_RBRACE] = ACTIONS(1358),
    [anon_sym_typeof] = ACTIONS(1360),
    [anon_sym_import] = ACTIONS(1360),
    [anon_sym_var] = ACTIONS(1360),
    [anon_sym_let] = ACTIONS(1360),
    [anon_sym_const] = ACTIONS(1360),
    [anon_sym_BANG] = ACTIONS(1360),
    [anon_sym_else] = ACTIONS(1360),
    [anon_sym_if] = ACTIONS(1360),
    [anon_sym_switch] = ACTIONS(1360),
    [anon_sym_for] = ACTIONS(1360),
    [anon_sym_LPAREN] = ACTIONS(1358),
    [anon_sym_await] = ACTIONS(1360),
    [anon_sym_in] = ACTIONS(1362),
    [anon_sym_while] = ACTIONS(1360),
    [anon_sym_do] = ACTIONS(1360),
    [anon_sym_try] = ACTIONS(1360),
    [anon_sym_with] = ACTIONS(1360),
    [anon_sym_break] = ACTIONS(1360),
    [anon_sym_continue] = ACTIONS(1360),
    [anon_sym_debugger] = ACTIONS(1360),
    [anon_sym_return] = ACTIONS(1360),
    [anon_sym_throw] = ACTIONS(1360),
    [anon_sym_SEMI] = ACTIONS(1358),
    [anon_sym_case] = ACTIONS(1360),
    [anon_sym_yield] = ACTIONS(1360),
    [anon_sym_LBRACK] = ACTIONS(1358),
    [anon_sym_LT] = ACTIONS(1360),
    [anon_sym_GT] = ACTIONS(1362),
    [anon_sym_SLASH] = ACTIONS(1360),
    [anon_sym_DOT] = ACTIONS(1362),
    [anon_sym_class] = ACTIONS(1360),
    [anon_sym_async] = ACTIONS(1360),
    [anon_sym_function] = ACTIONS(1360),
    [anon_sym_QMARK_DOT] = ACTIONS(1364),
    [anon_sym_new] = ACTIONS(1360),
    [anon_sym_AMP_AMP] = ACTIONS(1364),
    [anon_sym_PIPE_PIPE] = ACTIONS(1364),
    [anon_sym_GT_GT] = ACTIONS(1362),
    [anon_sym_GT_GT_GT] = ACTIONS(1364),
    [anon_sym_LT_LT] = ACTIONS(1364),
    [anon_sym_AMP] = ACTIONS(1362),
    [anon_sym_CARET] = ACTIONS(1364),
    [anon_sym_PIPE] = ACTIONS(1362),
    [anon_sym_PLUS] = ACTIONS(1360),
    [anon_sym_DASH] = ACTIONS(1360),
    [anon_sym_PERCENT] = ACTIONS(1364),
    [anon_sym_STAR_STAR] = ACTIONS(1364),
    [anon_sym_LT_EQ] = ACTIONS(1364),
    [anon_sym_EQ_EQ] = ACTIONS(1362),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(1364),
    [anon_sym_BANG_EQ] = ACTIONS(1362),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(1364),
    [anon_sym_GT_EQ] = ACTIONS(1364),
    [anon_sym_QMARK_QMARK] = ACTIONS(1364),
    [anon_sym_instanceof] = ACTIONS(1362),
    [anon_sym_TILDE] = ACTIONS(1358),
    [anon_sym_void] = ACTIONS(1360),
    [anon_sym_delete] = ACTIONS(1360),
    [anon_sym_PLUS_PLUS] = ACTIONS(1358),
    [anon_sym_DASH_DASH] = ACTIONS(1358),
    [anon_sym_DQUOTE] = ACTIONS(1358),
    [anon_sym_SQUOTE] = ACTIONS(1358),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(1358),
    [sym_number] = ACTIONS(1358),
    [sym_this] = ACTIONS(1360),
    [sym_super] = ACTIONS(1360),
    [sym_true] = ACTIONS(1360),
    [sym_false] = ACTIONS(1360),
    [sym_null] = ACTIONS(1360),
    [sym_undefined] = ACTIONS(1360),
    [anon_sym_AT] = ACTIONS(1358),
    [anon_sym_static] = ACTIONS(1360),
    [anon_sym_readonly] = ACTIONS(1360),
    [anon_sym_get] = ACTIONS(1360),
    [anon_sym_set] = ACTIONS(1360),
    [anon_sym_declare] = ACTIONS(1360),
    [anon_sym_public] = ACTIONS(1360),
    [anon_sym_private] = ACTIONS(1360),
    [anon_sym_protected] = ACTIONS(1360),
    [anon_sym_override] = ACTIONS(1360),
    [anon_sym_module] = ACTIONS(1360),
    [anon_sym_any] = ACTIONS(1360),
    [anon_sym_number] = ACTIONS(1360),
    [anon_sym_boolean] = ACTIONS(1360),
    [anon_sym_string] = ACTIONS(1360),
    [anon_sym_symbol] = ACTIONS(1360),
    [anon_sym_abstract] = ACTIONS(1360),
    [anon_sym_interface] = ACTIONS(1360),
    [anon_sym_enum] = ACTIONS(1360),
    [sym__automatic_semicolon] = ACTIONS(1366),
    [sym__ternary_qmark] = ACTIONS(1364),
  },
  [124] = {
    [sym_import] = STATE(1405),
    [sym_parenthesized_expression] = STATE(1072),
    [sym_expression] = STATE(1482),
    [sym_primary_expression] = STATE(1404),
    [sym_yield_expression] = STATE(1403),
    [sym_object] = STATE(1405),
    [sym_object_pattern] = STATE(2812),
    [sym_array] = STATE(1405),
    [sym_array_pattern] = STATE(2812),
    [sym_class] = STATE(1405),
    [sym_function] = STATE(1405),
    [sym_generator_function] = STATE(1405),
    [sym_arrow_function] = STATE(1405),
    [sym__call_signature] = STATE(4121),
    [sym__formal_parameter] = STATE(3477),
    [sym_call_expression] = STATE(1405),
    [sym_new_expression] = STATE(1403),
    [sym_await_expression] = STATE(1403),
    [sym_member_expression] = STATE(1056),
    [sym_subscript_expression] = STATE(1056),
    [sym_assignment_expression] = STATE(1403),
    [sym__augmented_assignment_lhs] = STATE(2344),
    [sym_augmented_assignment_expression] = STATE(1403),
    [sym__destructuring_pattern] = STATE(2812),
    [sym_ternary_expression] = STATE(1403),
    [sym_binary_expression] = STATE(1403),
    [sym_unary_expression] = STATE(1403),
    [sym_update_expression] = STATE(1403),
    [sym_sequence_expression] = STATE(3884),
    [sym_string] = STATE(1405),
    [sym_template_string] = STATE(1405),
    [sym_regex] = STATE(1405),
    [sym_meta_property] = STATE(1405),
    [sym_decorator] = STATE(1149),
    [sym_formal_parameters] = STATE(2903),
    [sym_pattern] = STATE(3265),
    [sym_rest_pattern] = STATE(2817),
    [sym_non_null_expression] = STATE(1056),
    [sym_type_assertion] = STATE(1403),
    [sym_as_expression] = STATE(1403),
    [sym_internal_module] = STATE(1403),
    [sym_accessibility_modifier] = STATE(200),
    [sym_override_modifier] = STATE(206),
    [sym_required_parameter] = STATE(3477),
    [sym_optional_parameter] = STATE(3477),
    [sym__parameter_name] = STATE(2820),
    [sym_type_arguments] = STATE(502),
    [sym_type_parameters] = STATE(3670),
    [aux_sym_export_statement_repeat1] = STATE(181),
    [sym_identifier] = ACTIONS(1312),
    [anon_sym_export] = ACTIONS(535),
    [anon_sym_type] = ACTIONS(535),
    [anon_sym_namespace] = ACTIONS(539),
    [anon_sym_LBRACE] = ACTIONS(1135),
    [anon_sym_typeof] = ACTIONS(573),
    [anon_sym_import] = ACTIONS(125),
    [anon_sym_BANG] = ACTIONS(547),
    [anon_sym_LPAREN] = ACTIONS(1083),
    [anon_sym_RPAREN] = ACTIONS(651),
    [anon_sym_await] = ACTIONS(549),
    [anon_sym_yield] = ACTIONS(551),
    [anon_sym_LBRACK] = ACTIONS