#include <tree_sitter/parser.h>

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#define LANGUAGE_VERSION 13
#define STATE_COUNT 1581
#define LARGE_STATE_COUNT 289
#define SYMBOL_COUNT 242
#define ALIAS_COUNT 6
#define TOKEN_COUNT 125
#define EXTERNAL_TOKEN_COUNT 3
#define FIELD_COUNT 35
#define MAX_ALIAS_SEQUENCE_LENGTH 7
#define PRODUCTION_ID_COUNT 106

enum {
  sym_identifier = 1,
  sym_hash_bang_line = 2,
  anon_sym_export = 3,
  anon_sym_STAR = 4,
  anon_sym_default = 5,
  anon_sym_LBRACE = 6,
  anon_sym_COMMA = 7,
  anon_sym_RBRACE = 8,
  anon_sym_as = 9,
  anon_sym_import = 10,
  anon_sym_from = 11,
  anon_sym_var = 12,
  anon_sym_let = 13,
  anon_sym_const = 14,
  anon_sym_else = 15,
  anon_sym_if = 16,
  anon_sym_switch = 17,
  anon_sym_for = 18,
  anon_sym_LPAREN = 19,
  anon_sym_RPAREN = 20,
  anon_sym_await = 21,
  anon_sym_in = 22,
  anon_sym_of = 23,
  anon_sym_while = 24,
  anon_sym_do = 25,
  anon_sym_try = 26,
  anon_sym_with = 27,
  anon_sym_break = 28,
  anon_sym_continue = 29,
  anon_sym_debugger = 30,
  anon_sym_return = 31,
  anon_sym_throw = 32,
  anon_sym_SEMI = 33,
  anon_sym_COLON = 34,
  anon_sym_case = 35,
  anon_sym_catch = 36,
  anon_sym_finally = 37,
  anon_sym_yield = 38,
  anon_sym_EQ = 39,
  anon_sym_LBRACK = 40,
  anon_sym_RBRACK = 41,
  anon_sym_LT = 42,
  anon_sym_GT = 43,
  anon_sym_SLASH = 44,
  sym_jsx_text = 45,
  sym_jsx_identifier = 46,
  anon_sym_DOT = 47,
  anon_sym_class = 48,
  anon_sym_extends = 49,
  anon_sym_async = 50,
  anon_sym_function = 51,
  anon_sym_EQ_GT = 52,
  anon_sym_QMARK_DOT = 53,
  anon_sym_new = 54,
  anon_sym_PLUS_EQ = 55,
  anon_sym_DASH_EQ = 56,
  anon_sym_STAR_EQ = 57,
  anon_sym_SLASH_EQ = 58,
  anon_sym_PERCENT_EQ = 59,
  anon_sym_CARET_EQ = 60,
  anon_sym_AMP_EQ = 61,
  anon_sym_PIPE_EQ = 62,
  anon_sym_GT_GT_EQ = 63,
  anon_sym_GT_GT_GT_EQ = 64,
  anon_sym_LT_LT_EQ = 65,
  anon_sym_STAR_STAR_EQ = 66,
  anon_sym_AMP_AMP_EQ = 67,
  anon_sym_PIPE_PIPE_EQ = 68,
  anon_sym_QMARK_QMARK_EQ = 69,
  anon_sym_DOT_DOT_DOT = 70,
  anon_sym_AMP_AMP = 71,
  anon_sym_PIPE_PIPE = 72,
  anon_sym_GT_GT = 73,
  anon_sym_GT_GT_GT = 74,
  anon_sym_LT_LT = 75,
  anon_sym_AMP = 76,
  anon_sym_CARET = 77,
  anon_sym_PIPE = 78,
  anon_sym_PLUS = 79,
  anon_sym_DASH = 80,
  anon_sym_PERCENT = 81,
  anon_sym_STAR_STAR = 82,
  anon_sym_LT_EQ = 83,
  anon_sym_EQ_EQ = 84,
  anon_sym_EQ_EQ_EQ = 85,
  anon_sym_BANG_EQ = 86,
  anon_sym_BANG_EQ_EQ = 87,
  anon_sym_GT_EQ = 88,
  anon_sym_QMARK_QMARK = 89,
  anon_sym_instanceof = 90,
  anon_sym_BANG = 91,
  anon_sym_TILDE = 92,
  anon_sym_typeof = 93,
  anon_sym_void = 94,
  anon_sym_delete = 95,
  anon_sym_PLUS_PLUS = 96,
  anon_sym_DASH_DASH = 97,
  anon_sym_DQUOTE = 98,
  anon_sym_SQUOTE = 99,
  sym_unescaped_double_string_fragment = 100,
  sym_unescaped_single_string_fragment = 101,
  sym_escape_sequence = 102,
  sym_comment = 103,
  anon_sym_BQUOTE = 104,
  anon_sym_DOLLAR_LBRACE = 105,
  anon_sym_SLASH2 = 106,
  sym_regex_pattern = 107,
  sym_regex_flags = 108,
  sym_number = 109,
  sym_private_property_identifier = 110,
  anon_sym_target = 111,
  sym_this = 112,
  sym_super = 113,
  sym_true = 114,
  sym_false = 115,
  sym_null = 116,
  sym_undefined = 117,
  anon_sym_AT = 118,
  anon_sym_static = 119,
  anon_sym_get = 120,
  anon_sym_set = 121,
  sym__automatic_semicolon = 122,
  sym__template_chars = 123,
  sym__ternary_qmark = 124,
  sym_program = 125,
  sym_export_statement = 126,
  sym_export_clause = 127,
  sym__import_export_specifier = 128,
  sym_declaration = 129,
  sym_import = 130,
  sym_import_statement = 131,
  sym_import_clause = 132,
  sym__from_clause = 133,
  sym_namespace_import_export = 134,
  sym_named_imports = 135,
  sym_expression_statement = 136,
  sym_variable_declaration = 137,
  sym_lexical_declaration = 138,
  sym_variable_declarator = 139,
  sym_statement_block = 140,
  sym_else_clause = 141,
  sym_if_statement = 142,
  sym_switch_statement = 143,
  sym_for_statement = 144,
  sym_for_in_statement = 145,
  sym__for_header = 146,
  sym_while_statement = 147,
  sym_do_statement = 148,
  sym_try_statement = 149,
  sym_with_statement = 150,
  sym_break_statement = 151,
  sym_continue_statement = 152,
  sym_debugger_statement = 153,
  sym_return_statement = 154,
  sym_throw_statement = 155,
  sym_empty_statement = 156,
  sym_labeled_statement = 157,
  sym_switch_body = 158,
  sym_switch_case = 159,
  sym_switch_default = 160,
  sym_catch_clause = 161,
  sym_finally_clause = 162,
  sym_parenthesized_expression = 163,
  sym_expression = 164,
  sym_primary_expression = 165,
  sym_yield_expression = 166,
  sym_object = 167,
  sym_object_pattern = 168,
  sym_assignment_pattern = 169,
  sym_object_assignment_pattern = 170,
  sym_array = 171,
  sym_array_pattern = 172,
  sym_jsx_element = 173,
  sym_jsx_fragment = 174,
  sym_jsx_expression = 175,
  sym_jsx_opening_element = 176,
  sym_nested_identifier = 177,
  sym_jsx_namespace_name = 178,
  sym_jsx_closing_element = 179,
  sym_jsx_self_closing_element = 180,
  sym_jsx_attribute = 181,
  sym_class = 182,
  sym_class_declaration = 183,
  sym_class_heritage = 184,
  sym_function = 185,
  sym_function_declaration = 186,
  sym_generator_function = 187,
  sym_generator_function_declaration = 188,
  sym_arrow_function = 189,
  sym_call_expression = 190,
  sym_new_expression = 191,
  sym_await_expression = 192,
  sym_member_expression = 193,
  sym_subscript_expression = 194,
  sym_assignment_expression = 195,
  sym__augmented_assignment_lhs = 196,
  sym_augmented_assignment_expression = 197,
  sym__initializer = 198,
  sym__destructuring_pattern = 199,
  sym_spread_element = 200,
  sym_ternary_expression = 201,
  sym_binary_expression = 202,
  sym_unary_expression = 203,
  sym_update_expression = 204,
  sym_sequence_expression = 205,
  sym_string = 206,
  sym_template_string = 207,
  sym_template_substitution = 208,
  sym_regex = 209,
  sym_meta_property = 210,
  sym_arguments = 211,
  sym_decorator = 212,
  sym_decorator_member_expression = 213,
  sym_decorator_call_expression = 214,
  sym_class_body = 215,
  sym_field_definition = 216,
  sym_formal_parameters = 217,
  sym_pattern = 218,
  sym_rest_pattern = 219,
  sym_method_definition = 220,
  sym_pair = 221,
  sym_pair_pattern = 222,
  sym__property_name = 223,
  sym_computed_property_name = 224,
  aux_sym_program_repeat1 = 225,
  aux_sym_export_statement_repeat1 = 226,
  aux_sym_export_clause_repeat1 = 227,
  aux_sym_named_imports_repeat1 = 228,
  aux_sym_variable_declaration_repeat1 = 229,
  aux_sym_switch_body_repeat1 = 230,
  aux_sym_object_repeat1 = 231,
  aux_sym_object_pattern_repeat1 = 232,
  aux_sym_array_repeat1 = 233,
  aux_sym_array_pattern_repeat1 = 234,
  aux_sym_jsx_element_repeat1 = 235,
  aux_sym_jsx_opening_element_repeat1 = 236,
  aux_sym_string_repeat1 = 237,
  aux_sym_string_repeat2 = 238,
  aux_sym_template_string_repeat1 = 239,
  aux_sym_class_body_repeat1 = 240,
  aux_sym_formal_parameters_repeat1 = 241,
  alias_sym_import_specifier = 242,
  alias_sym_namespace_export = 243,
  alias_sym_property_identifier = 244,
  alias_sym_shorthand_property_identifier = 245,
  alias_sym_shorthand_property_identifier_pattern = 246,
  alias_sym_statement_identifier = 247,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym_identifier] = "identifier",
  [sym_hash_bang_line] = "hash_bang_line",
  [anon_sym_export] = "export",
  [anon_sym_STAR] = "*",
  [anon_sym_default] = "default",
  [anon_sym_LBRACE] = "{",
  [anon_sym_COMMA] = ",",
  [anon_sym_RBRACE] = "}",
  [anon_sym_as] = "as",
  [anon_sym_import] = "import",
  [anon_sym_from] = "from",
  [anon_sym_var] = "var",
  [anon_sym_let] = "let",
  [anon_sym_const] = "const",
  [anon_sym_else] = "else",
  [anon_sym_if] = "if",
  [anon_sym_switch] = "switch",
  [anon_sym_for] = "for",
  [anon_sym_LPAREN] = "(",
  [anon_sym_RPAREN] = ")",
  [anon_sym_await] = "await",
  [anon_sym_in] = "in",
  [anon_sym_of] = "of",
  [anon_sym_while] = "while",
  [anon_sym_do] = "do",
  [anon_sym_try] = "try",
  [anon_sym_with] = "with",
  [anon_sym_break] = "break",
  [anon_sym_continue] = "continue",
  [anon_sym_debugger] = "debugger",
  [anon_sym_return] = "return",
  [anon_sym_throw] = "throw",
  [anon_sym_SEMI] = ";",
  [anon_sym_COLON] = ":",
  [anon_sym_case] = "case",
  [anon_sym_catch] = "catch",
  [anon_sym_finally] = "finally",
  [anon_sym_yield] = "yield",
  [anon_sym_EQ] = "=",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [anon_sym_LT] = "<",
  [anon_sym_GT] = ">",
  [anon_sym_SLASH] = "/",
  [sym_jsx_text] = "jsx_text",
  [sym_jsx_identifier] = "identifier",
  [anon_sym_DOT] = ".",
  [anon_sym_class] = "class",
  [anon_sym_extends] = "extends",
  [anon_sym_async] = "async",
  [anon_sym_function] = "function",
  [anon_sym_EQ_GT] = "=>",
  [anon_sym_QMARK_DOT] = "\?.",
  [anon_sym_new] = "new",
  [anon_sym_PLUS_EQ] = "+=",
  [anon_sym_DASH_EQ] = "-=",
  [anon_sym_STAR_EQ] = "*=",
  [anon_sym_SLASH_EQ] = "/=",
  [anon_sym_PERCENT_EQ] = "%=",
  [anon_sym_CARET_EQ] = "^=",
  [anon_sym_AMP_EQ] = "&=",
  [anon_sym_PIPE_EQ] = "|=",
  [anon_sym_GT_GT_EQ] = ">>=",
  [anon_sym_GT_GT_GT_EQ] = ">>>=",
  [anon_sym_LT_LT_EQ] = "<<=",
  [anon_sym_STAR_STAR_EQ] = "**=",
  [anon_sym_AMP_AMP_EQ] = "&&=",
  [anon_sym_PIPE_PIPE_EQ] = "||=",
  [anon_sym_QMARK_QMARK_EQ] = "\?\?=",
  [anon_sym_DOT_DOT_DOT] = "...",
  [anon_sym_AMP_AMP] = "&&",
  [anon_sym_PIPE_PIPE] = "||",
  [anon_sym_GT_GT] = ">>",
  [anon_sym_GT_GT_GT] = ">>>",
  [anon_sym_LT_LT] = "<<",
  [anon_sym_AMP] = "&",
  [anon_sym_CARET] = "^",
  [anon_sym_PIPE] = "|",
  [anon_sym_PLUS] = "+",
  [anon_sym_DASH] = "-",
  [anon_sym_PERCENT] = "%",
  [anon_sym_STAR_STAR] = "**",
  [anon_sym_LT_EQ] = "<=",
  [anon_sym_EQ_EQ] = "==",
  [anon_sym_EQ_EQ_EQ] = "===",
  [anon_sym_BANG_EQ] = "!=",
  [anon_sym_BANG_EQ_EQ] = "!==",
  [anon_sym_GT_EQ] = ">=",
  [anon_sym_QMARK_QMARK] = "\?\?",
  [anon_sym_instanceof] = "instanceof",
  [anon_sym_BANG] = "!",
  [anon_sym_TILDE] = "~",
  [anon_sym_typeof] = "typeof",
  [anon_sym_void] = "void",
  [anon_sym_delete] = "delete",
  [anon_sym_PLUS_PLUS] = "++",
  [anon_sym_DASH_DASH] = "--",
  [anon_sym_DQUOTE] = "\"",
  [anon_sym_SQUOTE] = "'",
  [sym_unescaped_double_string_fragment] = "string_fragment",
  [sym_unescaped_single_string_fragment] = "string_fragment",
  [sym_escape_sequence] = "escape_sequence",
  [sym_comment] = "comment",
  [anon_sym_BQUOTE] = "`",
  [anon_sym_DOLLAR_LBRACE] = "${",
  [anon_sym_SLASH2] = "/",
  [sym_regex_pattern] = "regex_pattern",
  [sym_regex_flags] = "regex_flags",
  [sym_number] = "number",
  [sym_private_property_identifier] = "private_property_identifier",
  [anon_sym_target] = "target",
  [sym_this] = "this",
  [sym_super] = "super",
  [sym_true] = "true",
  [sym_false] = "false",
  [sym_null] = "null",
  [sym_undefined] = "undefined",
  [anon_sym_AT] = "@",
  [anon_sym_static] = "static",
  [anon_sym_get] = "get",
  [anon_sym_set] = "set",
  [sym__automatic_semicolon] = "_automatic_semicolon",
  [sym__template_chars] = "_template_chars",
  [sym__ternary_qmark] = "\?",
  [sym_program] = "program",
  [sym_export_statement] = "export_statement",
  [sym_export_clause] = "export_clause",
  [sym__import_export_specifier] = "export_specifier",
  [sym_declaration] = "declaration",
  [sym_import] = "import",
  [sym_import_statement] = "import_statement",
  [sym_import_clause] = "import_clause",
  [sym__from_clause] = "_from_clause",
  [sym_namespace_import_export] = "namespace_import",
  [sym_named_imports] = "named_imports",
  [sym_expression_statement] = "expression_statement",
  [sym_variable_declaration] = "variable_declaration",
  [sym_lexical_declaration] = "lexical_declaration",
  [sym_variable_declarator] = "variable_declarator",
  [sym_statement_block] = "statement_block",
  [sym_else_clause] = "else_clause",
  [sym_if_statement] = "if_statement",
  [sym_switch_statement] = "switch_statement",
  [sym_for_statement] = "for_statement",
  [sym_for_in_statement] = "for_in_statement",
  [sym__for_header] = "_for_header",
  [sym_while_statement] = "while_statement",
  [sym_do_statement] = "do_statement",
  [sym_try_statement] = "try_statement",
  [sym_with_statement] = "with_statement",
  [sym_break_statement] = "break_statement",
  [sym_continue_statement] = "continue_statement",
  [sym_debugger_statement] = "debugger_statement",
  [sym_return_statement] = "return_statement",
  [sym_throw_statement] = "throw_statement",
  [sym_empty_statement] = "empty_statement",
  [sym_labeled_statement] = "labeled_statement",
  [sym_switch_body] = "switch_body",
  [sym_switch_case] = "switch_case",
  [sym_switch_default] = "switch_default",
  [sym_catch_clause] = "catch_clause",
  [sym_finally_clause] = "finally_clause",
  [sym_parenthesized_expression] = "parenthesized_expression",
  [sym_expression] = "expression",
  [sym_primary_expression] = "primary_expression",
  [sym_yield_expression] = "yield_expression",
  [sym_object] = "object",
  [sym_object_pattern] = "object_pattern",
  [sym_assignment_pattern] = "assignment_pattern",
  [sym_object_assignment_pattern] = "object_assignment_pattern",
  [sym_array] = "array",
  [sym_array_pattern] = "array_pattern",
  [sym_jsx_element] = "jsx_element",
  [sym_jsx_fragment] = "jsx_fragment",
  [sym_jsx_expression] = "jsx_expression",
  [sym_jsx_opening_element] = "jsx_opening_element",
  [sym_nested_identifier] = "nested_identifier",
  [sym_jsx_namespace_name] = "jsx_namespace_name",
  [sym_jsx_closing_element] = "jsx_closing_element",
  [sym_jsx_self_closing_element] = "jsx_self_closing_element",
  [sym_jsx_attribute] = "jsx_attribute",
  [sym_class] = "class",
  [sym_class_declaration] = "class_declaration",
  [sym_class_heritage] = "class_heritage",
  [sym_function] = "function",
  [sym_function_declaration] = "function_declaration",
  [sym_generator_function] = "generator_function",
  [sym_generator_function_declaration] = "generator_function_declaration",
  [sym_arrow_function] = "arrow_function",
  [sym_call_expression] = "call_expression",
  [sym_new_expression] = "new_expression",
  [sym_await_expression] = "await_expression",
  [sym_member_expression] = "member_expression",
  [sym_subscript_expression] = "subscript_expression",
  [sym_assignment_expression] = "assignment_expression",
  [sym__augmented_assignment_lhs] = "_augmented_assignment_lhs",
  [sym_augmented_assignment_expression] = "augmented_assignment_expression",
  [sym__initializer] = "_initializer",
  [sym__destructuring_pattern] = "_destructuring_pattern",
  [sym_spread_element] = "spread_element",
  [sym_ternary_expression] = "ternary_expression",
  [sym_binary_expression] = "binary_expression",
  [sym_unary_expression] = "unary_expression",
  [sym_update_expression] = "update_expression",
  [sym_sequence_expression] = "sequence_expression",
  [sym_string] = "string",
  [sym_template_string] = "template_string",
  [sym_template_substitution] = "template_substitution",
  [sym_regex] = "regex",
  [sym_meta_property] = "meta_property",
  [sym_arguments] = "arguments",
  [sym_decorator] = "decorator",
  [sym_decorator_member_expression] = "member_expression",
  [sym_decorator_call_expression] = "call_expression",
  [sym_class_body] = "class_body",
  [sym_field_definition] = "field_definition",
  [sym_formal_parameters] = "formal_parameters",
  [sym_pattern] = "pattern",
  [sym_rest_pattern] = "rest_pattern",
  [sym_method_definition] = "method_definition",
  [sym_pair] = "pair",
  [sym_pair_pattern] = "pair_pattern",
  [sym__property_name] = "_property_name",
  [sym_computed_property_name] = "computed_property_name",
  [aux_sym_program_repeat1] = "program_repeat1",
  [aux_sym_export_statement_repeat1] = "export_statement_repeat1",
  [aux_sym_export_clause_repeat1] = "export_clause_repeat1",
  [aux_sym_named_imports_repeat1] = "named_imports_repeat1",
  [aux_sym_variable_declaration_repeat1] = "variable_declaration_repeat1",
  [aux_sym_switch_body_repeat1] = "switch_body_repeat1",
  [aux_sym_object_repeat1] = "object_repeat1",
  [aux_sym_object_pattern_repeat1] = "object_pattern_repeat1",
  [aux_sym_array_repeat1] = "array_repeat1",
  [aux_sym_array_pattern_repeat1] = "array_pattern_repeat1",
  [aux_sym_jsx_element_repeat1] = "jsx_element_repeat1",
  [aux_sym_jsx_opening_element_repeat1] = "jsx_opening_element_repeat1",
  [aux_sym_string_repeat1] = "string_repeat1",
  [aux_sym_string_repeat2] = "string_repeat2",
  [aux_sym_template_string_repeat1] = "template_string_repeat1",
  [aux_sym_class_body_repeat1] = "class_body_repeat1",
  [aux_sym_formal_parameters_repeat1] = "formal_parameters_repeat1",
  [alias_sym_import_specifier] = "import_specifier",
  [alias_sym_namespace_export] = "namespace_export",
  [alias_sym_property_identifier] = "property_identifier",
  [alias_sym_shorthand_property_identifier] = "shorthand_property_identifier",
  [alias_sym_shorthand_property_identifier_pattern] = "shorthand_property_identifier_pattern",
  [alias_sym_statement_identifier] = "statement_identifier",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym_identifier] = sym_identifier,
  [sym_hash_bang_line] = sym_hash_bang_line,
  [anon_sym_export] = anon_sym_export,
  [anon_sym_STAR] = anon_sym_STAR,
  [anon_sym_default] = anon_sym_default,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_as] = anon_sym_as,
  [anon_sym_import] = anon_sym_import,
  [anon_sym_from] = anon_sym_from,
  [anon_sym_var] = anon_sym_var,
  [anon_sym_let] = anon_sym_let,
  [anon_sym_const] = anon_sym_const,
  [anon_sym_else] = anon_sym_else,
  [anon_sym_if] = anon_sym_if,
  [anon_sym_switch] = anon_sym_switch,
  [anon_sym_for] = anon_sym_for,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_await] = anon_sym_await,
  [anon_sym_in] = anon_sym_in,
  [anon_sym_of] = anon_sym_of,
  [anon_sym_while] = anon_sym_while,
  [anon_sym_do] = anon_sym_do,
  [anon_sym_try] = anon_sym_try,
  [anon_sym_with] = anon_sym_with,
  [anon_sym_break] = anon_sym_break,
  [anon_sym_continue] = anon_sym_continue,
  [anon_sym_debugger] = anon_sym_debugger,
  [anon_sym_return] = anon_sym_return,
  [anon_sym_throw] = anon_sym_throw,
  [anon_sym_SEMI] = anon_sym_SEMI,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_case] = anon_sym_case,
  [anon_sym_catch] = anon_sym_catch,
  [anon_sym_finally] = anon_sym_finally,
  [anon_sym_yield] = anon_sym_yield,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_GT] = anon_sym_GT,
  [anon_sym_SLASH] = anon_sym_SLASH,
  [sym_jsx_text] = sym_jsx_text,
  [sym_jsx_identifier] = sym_identifier,
  [anon_sym_DOT] = anon_sym_DOT,
  [anon_sym_class] = anon_sym_class,
  [anon_sym_extends] = anon_sym_extends,
  [anon_sym_async] = anon_sym_async,
  [anon_sym_function] = anon_sym_function,
  [anon_sym_EQ_GT] = anon_sym_EQ_GT,
  [anon_sym_QMARK_DOT] = anon_sym_QMARK_DOT,
  [anon_sym_new] = anon_sym_new,
  [anon_sym_PLUS_EQ] = anon_sym_PLUS_EQ,
  [anon_sym_DASH_EQ] = anon_sym_DASH_EQ,
  [anon_sym_STAR_EQ] = anon_sym_STAR_EQ,
  [anon_sym_SLASH_EQ] = anon_sym_SLASH_EQ,
  [anon_sym_PERCENT_EQ] = anon_sym_PERCENT_EQ,
  [anon_sym_CARET_EQ] = anon_sym_CARET_EQ,
  [anon_sym_AMP_EQ] = anon_sym_AMP_EQ,
  [anon_sym_PIPE_EQ] = anon_sym_PIPE_EQ,
  [anon_sym_GT_GT_EQ] = anon_sym_GT_GT_EQ,
  [anon_sym_GT_GT_GT_EQ] = anon_sym_GT_GT_GT_EQ,
  [anon_sym_LT_LT_EQ] = anon_sym_LT_LT_EQ,
  [anon_sym_STAR_STAR_EQ] = anon_sym_STAR_STAR_EQ,
  [anon_sym_AMP_AMP_EQ] = anon_sym_AMP_AMP_EQ,
  [anon_sym_PIPE_PIPE_EQ] = anon_sym_PIPE_PIPE_EQ,
  [anon_sym_QMARK_QMARK_EQ] = anon_sym_QMARK_QMARK_EQ,
  [anon_sym_DOT_DOT_DOT] = anon_sym_DOT_DOT_DOT,
  [anon_sym_AMP_AMP] = anon_sym_AMP_AMP,
  [anon_sym_PIPE_PIPE] = anon_sym_PIPE_PIPE,
  [anon_sym_GT_GT] = anon_sym_GT_GT,
  [anon_sym_GT_GT_GT] = anon_sym_GT_GT_GT,
  [anon_sym_LT_LT] = anon_sym_LT_LT,
  [anon_sym_AMP] = anon_sym_AMP,
  [anon_sym_CARET] = anon_sym_CARET,
  [anon_sym_PIPE] = anon_sym_PIPE,
  [anon_sym_PLUS] = anon_sym_PLUS,
  [anon_sym_DASH] = anon_sym_DASH,
  [anon_sym_PERCENT] = anon_sym_PERCENT,
  [anon_sym_STAR_STAR] = anon_sym_STAR_STAR,
  [anon_sym_LT_EQ] = anon_sym_LT_EQ,
  [anon_sym_EQ_EQ] = anon_sym_EQ_EQ,
  [anon_sym_EQ_EQ_EQ] = anon_sym_EQ_EQ_EQ,
  [anon_sym_BANG_EQ] = anon_sym_BANG_EQ,
  [anon_sym_BANG_EQ_EQ] = anon_sym_BANG_EQ_EQ,
  [anon_sym_GT_EQ] = anon_sym_GT_EQ,
  [anon_sym_QMARK_QMARK] = anon_sym_QMARK_QMARK,
  [anon_sym_instanceof] = anon_sym_instanceof,
  [anon_sym_BANG] = anon_sym_BANG,
  [anon_sym_TILDE] = anon_sym_TILDE,
  [anon_sym_typeof] = anon_sym_typeof,
  [anon_sym_void] = anon_sym_void,
  [anon_sym_delete] = anon_sym_delete,
  [anon_sym_PLUS_PLUS] = anon_sym_PLUS_PLUS,
  [anon_sym_DASH_DASH] = anon_sym_DASH_DASH,
  [anon_sym_DQUOTE] = anon_sym_DQUOTE,
  [anon_sym_SQUOTE] = anon_sym_SQUOTE,
  [sym_unescaped_double_string_fragment] = sym_unescaped_double_string_fragment,
  [sym_unescaped_single_string_fragment] = sym_unescaped_double_string_fragment,
  [sym_escape_sequence] = sym_escape_sequence,
  [sym_comment] = sym_comment,
  [anon_sym_BQUOTE] = anon_sym_BQUOTE,
  [anon_sym_DOLLAR_LBRACE] = anon_sym_DOLLAR_LBRACE,
  [anon_sym_SLASH2] = anon_sym_SLASH,
  [sym_regex_pattern] = sym_regex_pattern,
  [sym_regex_flags] = sym_regex_flags,
  [sym_number] = sym_number,
  [sym_private_property_identifier] = sym_private_property_identifier,
  [anon_sym_target] = anon_sym_target,
  [sym_this] = sym_this,
  [sym_super] = sym_super,
  [sym_true] = sym_true,
  [sym_false] = sym_false,
  [sym_null] = sym_null,
  [sym_undefined] = sym_undefined,
  [anon_sym_AT] = anon_sym_AT,
  [anon_sym_static] = anon_sym_static,
  [anon_sym_get] = anon_sym_get,
  [anon_sym_set] = anon_sym_set,
  [sym__automatic_semicolon] = sym__automatic_semicolon,
  [sym__template_chars] = sym__template_chars,
  [sym__ternary_qmark] = sym__ternary_qmark,
  [sym_program] = sym_program,
  [sym_export_statement] = sym_export_statement,
  [sym_export_clause] = sym_export_clause,
  [sym__import_export_specifier] = sym__import_export_specifier,
  [sym_declaration] = sym_declaration,
  [sym_import] = sym_import,
  [sym_import_statement] = sym_import_statement,
  [sym_import_clause] = sym_import_clause,
  [sym__from_clause] = sym__from_clause,
  [sym_namespace_import_export] = sym_namespace_import_export,
  [sym_named_imports] = sym_named_imports,
  [sym_expression_statement] = sym_expression_statement,
  [sym_variable_declaration] = sym_variable_declaration,
  [sym_lexical_declaration] = sym_lexical_declaration,
  [sym_variable_declarator] = sym_variable_declarator,
  [sym_statement_block] = sym_statement_block,
  [sym_else_clause] = sym_else_clause,
  [sym_if_statement] = sym_if_statement,
  [sym_switch_statement] = sym_switch_statement,
  [sym_for_statement] = sym_for_statement,
  [sym_for_in_statement] = sym_for_in_statement,
  [sym__for_header] = sym__for_header,
  [sym_while_statement] = sym_while_statement,
  [sym_do_statement] = sym_do_statement,
  [sym_try_statement] = sym_try_statement,
  [sym_with_statement] = sym_with_statement,
  [sym_break_statement] = sym_break_statement,
  [sym_continue_statement] = sym_continue_statement,
  [sym_debugger_statement] = sym_debugger_statement,
  [sym_return_statement] = sym_return_statement,
  [sym_throw_statement] = sym_throw_statement,
  [sym_empty_statement] = sym_empty_statement,
  [sym_labeled_statement] = sym_labeled_statement,
  [sym_switch_body] = sym_switch_body,
  [sym_switch_case] = sym_switch_case,
  [sym_switch_default] = sym_switch_default,
  [sym_catch_clause] = sym_catch_clause,
  [sym_finally_clause] = sym_finally_clause,
  [sym_parenthesized_expression] = sym_parenthesized_expression,
  [sym_expression] = sym_expression,
  [sym_primary_expression] = sym_primary_expression,
  [sym_yield_expression] = sym_yield_expression,
  [sym_object] = sym_object,
  [sym_object_pattern] = sym_object_pattern,
  [sym_assignment_pattern] = sym_assignment_pattern,
  [sym_object_assignment_pattern] = sym_object_assignment_pattern,
  [sym_array] = sym_array,
  [sym_array_pattern] = sym_array_pattern,
  [sym_jsx_element] = sym_jsx_element,
  [sym_jsx_fragment] = sym_jsx_fragment,
  [sym_jsx_expression] = sym_jsx_expression,
  [sym_jsx_opening_element] = sym_jsx_opening_element,
  [sym_nested_identifier] = sym_nested_identifier,
  [sym_jsx_namespace_name] = sym_jsx_namespace_name,
  [sym_jsx_closing_element] = sym_jsx_closing_element,
  [sym_jsx_self_closing_element] = sym_jsx_self_closing_element,
  [sym_jsx_attribute] = sym_jsx_attribute,
  [sym_class] = sym_class,
  [sym_class_declaration] = sym_class_declaration,
  [sym_class_heritage] = sym_class_heritage,
  [sym_function] = sym_function,
  [sym_function_declaration] = sym_function_declaration,
  [sym_generator_function] = sym_generator_function,
  [sym_generator_function_declaration] = sym_generator_function_declaration,
  [sym_arrow_function] = sym_arrow_function,
  [sym_call_expression] = sym_call_expression,
  [sym_new_expression] = sym_new_expression,
  [sym_await_expression] = sym_await_expression,
  [sym_member_expression] = sym_member_expression,
  [sym_subscript_expression] = sym_subscript_expression,
  [sym_assignment_expression] = sym_assignment_expression,
  [sym__augmented_assignment_lhs] = sym__augmented_assignment_lhs,
  [sym_augmented_assignment_expression] = sym_augmented_assignment_expression,
  [sym__initializer] = sym__initializer,
  [sym__destructuring_pattern] = sym__destructuring_pattern,
  [sym_spread_element] = sym_spread_element,
  [sym_ternary_expression] = sym_ternary_expression,
  [sym_binary_expression] = sym_binary_expression,
  [sym_unary_expression] = sym_unary_expression,
  [sym_update_expression] = sym_update_expression,
  [sym_sequence_expression] = sym_sequence_expression,
  [sym_string] = sym_string,
  [sym_template_string] = sym_template_string,
  [sym_template_substitution] = sym_template_substitution,
  [sym_regex] = sym_regex,
  [sym_meta_property] = sym_meta_property,
  [sym_arguments] = sym_arguments,
  [sym_decorator] = sym_decorator,
  [sym_decorator_member_expression] = sym_member_expression,
  [sym_decorator_call_expression] = sym_call_expression,
  [sym_class_body] = sym_class_body,
  [sym_field_definition] = sym_field_definition,
  [sym_formal_parameters] = sym_formal_parameters,
  [sym_pattern] = sym_pattern,
  [sym_rest_pattern] = sym_rest_pattern,
  [sym_method_definition] = sym_method_definition,
  [sym_pair] = sym_pair,
  [sym_pair_pattern] = sym_pair_pattern,
  [sym__property_name] = sym__property_name,
  [sym_computed_property_name] = sym_computed_property_name,
  [aux_sym_program_repeat1] = aux_sym_program_repeat1,
  [aux_sym_export_statement_repeat1] = aux_sym_export_statement_repeat1,
  [aux_sym_export_clause_repeat1] = aux_sym_export_clause_repeat1,
  [aux_sym_named_imports_repeat1] = aux_sym_named_imports_repeat1,
  [aux_sym_variable_declaration_repeat1] = aux_sym_variable_declaration_repeat1,
  [aux_sym_switch_body_repeat1] = aux_sym_switch_body_repeat1,
  [aux_sym_object_repeat1] = aux_sym_object_repeat1,
  [aux_sym_object_pattern_repeat1] = aux_sym_object_pattern_repeat1,
  [aux_sym_array_repeat1] = aux_sym_array_repeat1,
  [aux_sym_array_pattern_repeat1] = aux_sym_array_pattern_repeat1,
  [aux_sym_jsx_element_repeat1] = aux_sym_jsx_element_repeat1,
  [aux_sym_jsx_opening_element_repeat1] = aux_sym_jsx_opening_element_repeat1,
  [aux_sym_string_repeat1] = aux_sym_string_repeat1,
  [aux_sym_string_repeat2] = aux_sym_string_repeat2,
  [aux_sym_template_string_repeat1] = aux_sym_template_string_repeat1,
  [aux_sym_class_body_repeat1] = aux_sym_class_body_repeat1,
  [aux_sym_formal_parameters_repeat1] = aux_sym_formal_parameters_repeat1,
  [alias_sym_import_specifier] = alias_sym_import_specifier,
  [alias_sym_namespace_export] = alias_sym_namespace_export,
  [alias_sym_property_identifier] = alias_sym_property_identifier,
  [alias_sym_shorthand_property_identifier] = alias_sym_shorthand_property_identifier,
  [alias_sym_shorthand_property_identifier_pattern] = alias_sym_shorthand_property_identifier_pattern,
  [alias_sym_statement_identifier] = alias_sym_statement_identifier,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_hash_bang_line] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_export] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_default] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_as] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_import] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_from] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_var] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_let] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_const] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_else] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_if] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_switch] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_for] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_await] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_in] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_of] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_while] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_do] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_try] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_with] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_break] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_continue] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_debugger] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_return] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_throw] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SEMI] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_case] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_catch] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_finally] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_yield] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = false,
  },
  [sym_jsx_text] = {
    .visible = true,
    .named = true,
  },
  [sym_jsx_identifier] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_class] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_extends] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_async] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_function] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_new] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_STAR_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_AMP_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_PIPE_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK_QMARK_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT_DOT_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK_QMARK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_instanceof] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_TILDE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_typeof] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_void] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_delete] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SQUOTE] = {
    .visible = true,
    .named = false,
  },
  [sym_unescaped_double_string_fragment] = {
    .visible = true,
    .named = true,
  },
  [sym_unescaped_single_string_fragment] = {
    .visible = true,
    .named = true,
  },
  [sym_escape_sequence] = {
    .visible = true,
    .named = true,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_BQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOLLAR_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH2] = {
    .visible = true,
    .named = false,
  },
  [sym_regex_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_regex_flags] = {
    .visible = true,
    .named = true,
  },
  [sym_number] = {
    .visible = true,
    .named = true,
  },
  [sym_private_property_identifier] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_target] = {
    .visible = true,
    .named = false,
  },
  [sym_this] = {
    .visible = true,
    .named = true,
  },
  [sym_super] = {
    .visible = true,
    .named = true,
  },
  [sym_true] = {
    .visible = true,
    .named = true,
  },
  [sym_false] = {
    .visible = true,
    .named = true,
  },
  [sym_null] = {
    .visible = true,
    .named = true,
  },
  [sym_undefined] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_AT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_static] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_get] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_set] = {
    .visible = true,
    .named = false,
  },
  [sym__automatic_semicolon] = {
    .visible = false,
    .named = true,
  },
  [sym__template_chars] = {
    .visible = false,
    .named = true,
  },
  [sym__ternary_qmark] = {
    .visible = true,
    .named = false,
  },
  [sym_program] = {
    .visible = true,
    .named = true,
  },
  [sym_export_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_export_clause] = {
    .visible = true,
    .named = true,
  },
  [sym__import_export_specifier] = {
    .visible = true,
    .named = true,
  },
  [sym_declaration] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_import] = {
    .visible = true,
    .named = true,
  },
  [sym_import_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_import_clause] = {
    .visible = true,
    .named = true,
  },
  [sym__from_clause] = {
    .visible = false,
    .named = true,
  },
  [sym_namespace_import_export] = {
    .visible = true,
    .named = true,
  },
  [sym_named_imports] = {
    .visible = true,
    .named = true,
  },
  [sym_expression_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_variable_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_lexical_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_variable_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_statement_block] = {
    .visible = true,
    .named = true,
  },
  [sym_else_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_if_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_switch_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_for_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_for_in_statement] = {
    .visible = true,
    .named = true,
  },
  [sym__for_header] = {
    .visible = false,
    .named = true,
  },
  [sym_while_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_do_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_try_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_with_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_break_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_continue_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_debugger_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_return_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_throw_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_empty_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_labeled_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_switch_body] = {
    .visible = true,
    .named = true,
  },
  [sym_switch_case] = {
    .visible = true,
    .named = true,
  },
  [sym_switch_default] = {
    .visible = true,
    .named = true,
  },
  [sym_catch_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_finally_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_parenthesized_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_expression] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_primary_expression] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_yield_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_object] = {
    .visible = true,
    .named = true,
  },
  [sym_object_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_assignment_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_object_assignment_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_array] = {
    .visible = true,
    .named = true,
  },
  [sym_array_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_jsx_element] = {
    .visible = true,
    .named = true,
  },
  [sym_jsx_fragment] = {
    .visible = true,
    .named = true,
  },
  [sym_jsx_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_jsx_opening_element] = {
    .visible = true,
    .named = true,
  },
  [sym_nested_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_jsx_namespace_name] = {
    .visible = true,
    .named = true,
  },
  [sym_jsx_closing_element] = {
    .visible = true,
    .named = true,
  },
  [sym_jsx_self_closing_element] = {
    .visible = true,
    .named = true,
  },
  [sym_jsx_attribute] = {
    .visible = true,
    .named = true,
  },
  [sym_class] = {
    .visible = true,
    .named = true,
  },
  [sym_class_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_class_heritage] = {
    .visible = true,
    .named = true,
  },
  [sym_function] = {
    .visible = true,
    .named = true,
  },
  [sym_function_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_generator_function] = {
    .visible = true,
    .named = true,
  },
  [sym_generator_function_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_arrow_function] = {
    .visible = true,
    .named = true,
  },
  [sym_call_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_new_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_await_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_member_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_subscript_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_assignment_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__augmented_assignment_lhs] = {
    .visible = false,
    .named = true,
  },
  [sym_augmented_assignment_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__initializer] = {
    .visible = false,
    .named = true,
  },
  [sym__destructuring_pattern] = {
    .visible = false,
    .named = true,
  },
  [sym_spread_element] = {
    .visible = true,
    .named = true,
  },
  [sym_ternary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_binary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_unary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_update_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_sequence_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_string] = {
    .visible = true,
    .named = true,
  },
  [sym_template_string] = {
    .visible = true,
    .named = true,
  },
  [sym_template_substitution] = {
    .visible = true,
    .named = true,
  },
  [sym_regex] = {
    .visible = true,
    .named = true,
  },
  [sym_meta_property] = {
    .visible = true,
    .named = true,
  },
  [sym_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym_decorator] = {
    .visible = true,
    .named = true,
  },
  [sym_decorator_member_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_decorator_call_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_class_body] = {
    .visible = true,
    .named = true,
  },
  [sym_field_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_formal_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym_pattern] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_rest_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_method_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_pair] = {
    .visible = true,
    .named = true,
  },
  [sym_pair_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym__property_name] = {
    .visible = false,
    .named = true,
  },
  [sym_computed_property_name] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_program_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_export_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_export_clause_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_named_imports_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_variable_declaration_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_switch_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_object_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_object_pattern_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_array_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_array_pattern_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_jsx_element_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_jsx_opening_element_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_string_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_template_string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_class_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_formal_parameters_repeat1] = {
    .visible = false,
    .named = false,
  },
  [alias_sym_import_specifier] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_namespace_export] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_property_identifier] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_shorthand_property_identifier] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_shorthand_property_identifier_pattern] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_statement_identifier] = {
    .visible = true,
    .named = true,
  },
};

enum {
  field_alias = 1,
  field_alternative = 2,
  field_argument = 3,
  field_arguments = 4,
  field_attribute = 5,
  field_body = 6,
  field_close_tag = 7,
  field_condition = 8,
  field_consequence = 9,
  field_constructor = 10,
  field_declaration = 11,
  field_decorator = 12,
  field_finalizer = 13,
  field_flags = 14,
  field_function = 15,
  field_handler = 16,
  field_increment = 17,
  field_index = 18,
  field_initializer = 19,
  field_key = 20,
  field_kind = 21,
  field_label = 22,
  field_left = 23,
  field_member = 24,
  field_name = 25,
  field_object = 26,
  field_open_tag = 27,
  field_operator = 28,
  field_parameter = 29,
  field_parameters = 30,
  field_pattern = 31,
  field_property = 32,
  field_right = 33,
  field_source = 34,
  field_value = 35,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_alias] = "alias",
  [field_alternative] = "alternative",
  [field_argument] = "argument",
  [field_arguments] = "arguments",
  [field_attribute] = "attribute",
  [field_body] = "body",
  [field_close_tag] = "close_tag",
  [field_condition] = "condition",
  [field_consequence] = "consequence",
  [field_constructor] = "constructor",
  [field_declaration] = "declaration",
  [field_decorator] = "decorator",
  [field_finalizer] = "finalizer",
  [field_flags] = "flags",
  [field_function] = "function",
  [field_handler] = "handler",
  [field_increment] = "increment",
  [field_index] = "index",
  [field_initializer] = "initializer",
  [field_key] = "key",
  [field_kind] = "kind",
  [field_label] = "label",
  [field_left] = "left",
  [field_member] = "member",
  [field_name] = "name",
  [field_object] = "object",
  [field_open_tag] = "open_tag",
  [field_operator] = "operator",
  [field_parameter] = "parameter",
  [field_parameters] = "parameters",
  [field_pattern] = "pattern",
  [field_property] = "property",
  [field_right] = "right",
  [field_source] = "source",
  [field_value] = "value",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [2] = {.index = 0, .length = 1},
  [3] = {.index = 1, .length = 1},
  [5] = {.index = 2, .length = 1},
  [6] = {.index = 3, .length = 1},
  [7] = {.index = 4, .length = 1},
  [8] = {.index = 5, .length = 2},
  [9] = {.index = 7, .length = 2},
  [10] = {.index = 9, .length = 2},
  [11] = {.index = 11, .length = 2},
  [12] = {.index = 13, .length = 2},
  [13] = {.index = 15, .length = 1},
  [14] = {.index = 16, .length = 2},
  [15] = {.index = 18, .length = 2},
  [16] = {.index = 20, .length = 2},
  [20] = {.index = 22, .length = 1},
  [21] = {.index = 23, .length = 2},
  [22] = {.index = 25, .length = 1},
  [23] = {.index = 26, .length = 2},
  [24] = {.index = 28, .length = 2},
  [25] = {.index = 30, .length = 6},
  [26] = {.index = 36, .length = 2},
  [27] = {.index = 38, .length = 2},
  [28] = {.index = 40, .length = 2},
  [29] = {.index = 42, .length = 2},
  [30] = {.index = 44, .length = 1},
  [31] = {.index = 45, .length = 1},
  [32] = {.index = 46, .length = 1},
  [33] = {.index = 47, .length = 1},
  [34] = {.index = 48, .length = 1},
  [35] = {.index = 49, .length = 1},
  [36] = {.index = 50, .length = 2},
  [37] = {.index = 52, .length = 1},
  [38] = {.index = 53, .length = 2},
  [39] = {.index = 55, .length = 2},
  [40] = {.index = 18, .length = 2},
  [41] = {.index = 20, .length = 2},
  [42] = {.index = 57, .length = 3},
  [43] = {.index = 60, .length = 2},
  [44] = {.index = 60, .length = 2},
  [45] = {.index = 62, .length = 2},
  [46] = {.index = 64, .length = 2},
  [47] = {.index = 66, .length = 2},
  [48] = {.index = 68, .length = 2},
  [49] = {.index = 70, .length = 2},
  [50] = {.index = 72, .length = 1},
  [51] = {.index = 73, .length = 1},
  [52] = {.index = 74, .length = 2},
  [53] = {.index = 72, .length = 1},
  [54] = {.index = 18, .length = 2},
  [55] = {.index = 76, .length = 2},
  [56] = {.index = 78, .length = 3},
  [57] = {.index = 74, .length = 2},
  [58] = {.index = 81, .length = 1},
  [59] = {.index = 82, .length = 3},
  [60] = {.index = 85, .length = 6},
  [61] = {.index = 91, .length = 3},
  [62] = {.index = 94, .length = 2},
  [63] = {.index = 96, .length = 2},
  [64] = {.index = 98, .length = 2},
  [65] = {.index = 100, .length = 1},
  [66] = {.index = 101, .length = 2},
  [67] = {.index = 103, .length = 2},
  [68] = {.index = 105, .length = 1},
  [69] = {.index = 106, .length = 2},
  [70] = {.index = 108, .length = 2},
  [71] = {.index = 110, .length = 2},
  [72] = {.index = 112, .length = 2},
  [73] = {.index = 110, .length = 2},
  [74] = {.index = 114, .length = 2},
  [75] = {.index = 116, .length = 3},
  [76] = {.index = 119, .length = 2},
  [77] = {.index = 121, .length = 2},
  [78] = {.index = 123, .length = 3},
  [79] = {.index = 126, .length = 2},
  [80] = {.index = 128, .length = 2},
  [81] = {.index = 130, .length = 4},
  [82] = {.index = 134, .length = 2},
  [83] = {.index = 136, .length = 2},
  [84] = {.index = 138, .length = 2},
  [85] = {.index = 140, .length = 3},
  [86] = {.index = 143, .length = 2},
  [87] = {.index = 145, .length = 3},
  [88] = {.index = 148, .length = 3},
  [89] = {.index = 151, .length = 2},
  [90] = {.index = 153, .length = 1},
  [91] = {.index = 154, .length = 2},
  [92] = {.index = 156, .length = 3},
  [93] = {.index = 159, .length = 4},
  [94] = {.index = 163, .length = 3},
  [95] = {.index = 163, .length = 3},
  [96] = {.index = 166, .length = 3},
  [97] = {.index = 169, .length = 3},
  [98] = {.index = 172, .length = 3},
  [99] = {.index = 175, .length = 4},
  [100] = {.index = 179, .length = 2},
  [101] = {.index = 181, .length = 4},
  [102] = {.index = 185, .length = 4},
  [103] = {.index = 189, .length = 2},
  [104] = {.index = 191, .length = 4},
  [105] = {.index = 195, .length = 5},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_decorator, 0},
  [1] =
    {field_declaration, 1},
  [2] =
    {field_name, 0},
  [3] =
    {field_body, 1},
  [4] =
    {field_constructor, 1},
  [5] =
    {field_argument, 1},
    {field_operator, 0},
  [7] =
    {field_argument, 0},
    {field_operator, 1},
  [9] =
    {field_arguments, 1},
    {field_function, 0},
  [11] =
    {field_close_tag, 1},
    {field_open_tag, 0},
  [13] =
    {field_decorator, 0, .inherited = true},
    {field_decorator, 1, .inherited = true},
  [15] =
    {field_declaration, 2},
  [16] =
    {field_body, 2},
    {field_label, 0},
  [18] =
    {field_left, 0},
    {field_right, 2},
  [20] =
    {field_body, 2},
    {field_parameter, 0},
  [22] =
    {field_source, 1},
  [23] =
    {field_name, 0},
    {field_value, 1, .inherited = true},
  [25] =
    {field_kind, 0},
  [26] =
    {field_condition, 1},
    {field_consequence, 2},
  [28] =
    {field_body, 2},
    {field_value, 1},
  [30] =
    {field_body, 2},
    {field_kind, 1, .inherited = true},
    {field_left, 1, .inherited = true},
    {field_operator, 1, .inherited = true},
    {field_right, 1, .inherited = true},
    {field_value, 1, .inherited = true},
  [36] =
    {field_body, 2},
    {field_condition, 1},
  [38] =
    {field_body, 1},
    {field_handler, 2},
  [40] =
    {field_body, 1},
    {field_finalizer, 2},
  [42] =
    {field_body, 2},
    {field_object, 1},
  [44] =
    {field_label, 1},
  [45] =
    {field_name, 1},
  [46] =
    {field_attribute, 0},
  [47] =
    {field_pattern, 1},
  [48] =
    {field_member, 0},
  [49] =
    {field_property, 0},
  [50] =
    {field_body, 2},
    {field_name, 1},
  [52] =
    {field_body, 2},
  [53] =
    {field_body, 2},
    {field_parameters, 1},
  [55] =
    {field_arguments, 2},
    {field_constructor, 1},
  [57] =
    {field_left, 0},
    {field_operator, 1},
    {field_right, 2},
  [60] =
    {field_object, 0},
    {field_property, 2},
  [62] =
    {field_arguments, 2},
    {field_function, 0},
  [64] =
    {field_close_tag, 2},
    {field_open_tag, 0},
  [66] =
    {field_body, 2},
    {field_parameters, 0},
  [68] =
    {field_declaration, 2},
    {field_decorator, 0, .inherited = true},
  [70] =
    {field_body, 2},
    {field_decorator, 0, .inherited = true},
  [72] =
    {field_source, 2, .inherited = true},
  [73] =
    {field_value, 2},
  [74] =
    {field_alias, 1, .inherited = true},
    {field_name, 1, .inherited = true},
  [76] =
    {field_key, 0},
    {field_value, 2},
  [78] =
    {field_body, 2},
    {field_name, 0},
    {field_parameters, 1},
  [81] =
    {field_value, 1},
  [82] =
    {field_alternative, 3},
    {field_condition, 1},
    {field_consequence, 2},
  [85] =
    {field_body, 3},
    {field_kind, 2, .inherited = true},
    {field_left, 2, .inherited = true},
    {field_operator, 2, .inherited = true},
    {field_right, 2, .inherited = true},
    {field_value, 2, .inherited = true},
  [91] =
    {field_body, 1},
    {field_finalizer, 3},
    {field_handler, 2},
  [94] =
    {field_attribute, 2, .inherited = true},
    {field_name, 1},
  [96] =
    {field_attribute, 0, .inherited = true},
    {field_attribute, 1, .inherited = true},
  [98] =
    {field_flags, 3},
    {field_pattern, 1},
  [100] =
    {field_property, 1},
  [101] =
    {field_property, 0},
    {field_value, 1, .inherited = true},
  [103] =
    {field_decorator, 0, .inherited = true},
    {field_property, 1},
  [105] =
    {field_member, 1, .inherited = true},
  [106] =
    {field_member, 0, .inherited = true},
    {field_member, 1, .inherited = true},
  [108] =
    {field_body, 3},
    {field_name, 1},
  [110] =
    {field_body, 3},
    {field_parameter, 1},
  [112] =
    {field_body, 3},
    {field_parameters, 2},
  [114] =
    {field_body, 3},
    {field_parameters, 1},
  [116] =
    {field_body, 3},
    {field_name, 1},
    {field_parameters, 2},
  [119] =
    {field_index, 2},
    {field_object, 0},
  [121] =
    {field_declaration, 3},
    {field_decorator, 0, .inherited = true},
  [123] =
    {field_body, 3},
    {field_decorator, 0, .inherited = true},
    {field_name, 2},
  [126] =
    {field_body, 3},
    {field_decorator, 0, .inherited = true},
  [128] =
    {field_alias, 2},
    {field_name, 0},
  [130] =
    {field_body, 3},
    {field_decorator, 0, .inherited = true},
    {field_name, 1},
    {field_parameters, 2},
  [134] =
    {field_body, 1},
    {field_condition, 3},
  [136] =
    {field_property, 1},
    {field_value, 2, .inherited = true},
  [138] =
    {field_decorator, 0, .inherited = true},
    {field_property, 2},
  [140] =
    {field_decorator, 0, .inherited = true},
    {field_property, 1},
    {field_value, 2, .inherited = true},
  [143] =
    {field_body, 4},
    {field_parameters, 3},
  [145] =
    {field_body, 4},
    {field_name, 2},
    {field_parameters, 3},
  [148] =
    {field_alternative, 4},
    {field_condition, 0},
    {field_consequence, 2},
  [151] =
    {field_index, 3},
    {field_object, 0},
  [153] =
    {field_name, 2},
  [154] =
    {field_decorator, 0, .inherited = true},
    {field_value, 3},
  [156] =
    {field_body, 4},
    {field_decorator, 0, .inherited = true},
    {field_name, 2},
  [159] =
    {field_body, 4},
    {field_decorator, 0, .inherited = true},
    {field_name, 2},
    {field_parameters, 3},
  [163] =
    {field_left, 1},
    {field_operator, 2},
    {field_right, 3},
  [166] =
    {field_body, 5},
    {field_condition, 3},
    {field_initializer, 2},
  [169] =
    {field_decorator, 0, .inherited = true},
    {field_property, 2},
    {field_value, 3, .inherited = true},
  [172] =
    {field_body, 5},
    {field_name, 3},
    {field_parameters, 4},
  [175] =
    {field_body, 5},
    {field_decorator, 0, .inherited = true},
    {field_name, 3},
    {field_parameters, 4},
  [179] =
    {field_body, 3},
    {field_value, 1},
  [181] =
    {field_kind, 1},
    {field_left, 2},
    {field_operator, 3},
    {field_right, 4},
  [185] =
    {field_body, 6},
    {field_condition, 3},
    {field_increment, 4},
    {field_initializer, 2},
  [189] =
    {field_body, 4},
    {field_parameter, 2},
  [191] =
    {field_body, 6},
    {field_decorator, 0, .inherited = true},
    {field_name, 4},
    {field_parameters, 5},
  [195] =
    {field_kind, 1},
    {field_left, 2},
    {field_operator, 4},
    {field_right, 5},
    {field_value, 3, .inherited = true},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
  [1] = {
    [0] = sym_identifier,
  },
  [4] = {
    [0] = alias_sym_property_identifier,
  },
  [14] = {
    [0] = alias_sym_statement_identifier,
  },
  [15] = {
    [0] = sym_identifier,
  },
  [16] = {
    [0] = sym_identifier,
  },
  [17] = {
    [1] = alias_sym_shorthand_property_identifier,
  },
  [18] = {
    [1] = alias_sym_shorthand_property_identifier_pattern,
  },
  [19] = {
    [1] = sym_identifier,
  },
  [30] = {
    [1] = alias_sym_statement_identifier,
  },
  [43] = {
    [2] = alias_sym_property_identifier,
  },
  [53] = {
    [1] = alias_sym_namespace_export,
  },
  [54] = {
    [0] = alias_sym_shorthand_property_identifier_pattern,
  },
  [57] = {
    [1] = alias_sym_import_specifier,
  },
  [71] = {
    [1] = sym_identifier,
  },
  [94] = {
    [1] = sym_identifier,
  },
};

static const uint16_t ts_non_terminal_alias_map[] = {
  sym__import_export_specifier, 2,
    sym__import_export_specifier,
    alias_sym_import_specifier,
  sym_namespace_import_export, 2,
    sym_namespace_import_export,
    alias_sym_namespace_export,
  0,
};

static inline bool anon_sym_BANG_character_set_1(int32_t c) {
  return (c < 8192
    ? (c < ' '
      ? (c < '\r'
        ? (c >= '\t' && c <= '\n')
        : c <= '\r')
      : (c <= ' ' || (c < 5760
        ? c == 160
        : c <= 5760)))
    : (c <= 8203 || (c < 12288
      ? (c < 8287
        ? c == 8239
        : c <= 8288)
      : (c <= 12288 || c == 65279))));
}

static inline bool sym_regex_pattern_character_set_1(int32_t c) {
  return (c < 8192
    ? (c < ' '
      ? (c < '\r'
        ? c == '\t'
        : c <= '\r')
      : (c <= ' ' || (c < 5760
        ? c == 160
        : c <= 5760)))
    : (c <= 8203 || (c < 12288
      ? (c < 8287
        ? c == 8239
        : c <= 8288)
      : (c <= 12288 || c == 65279))));
}

static inline bool sym_identifier_character_set_1(int32_t c) {
  return (c < 160
    ? (c < ':'
      ? (c < 0
        ? c == 0
        : (c <= '#' || (c >= '%' && c <= '/')))
      : (c <= '@' || (c < '`'
        ? (c >= '[' && c <= '^')
        : (c <= '`' || (c >= '{' && c <= '~')))))
    : (c <= 160 || (c < 8287
      ? (c < 8192
        ? c == 5760
        : (c <= 8203 || c == 8239))
      : (c <= 8288 || (c < 65279
        ? c == 12288
        : c <= 65279)))));
}

static inline bool sym_identifier_character_set_2(int32_t c) {
  return (c < 160
    ? (c < ':'
      ? (c < 0
        ? c == 0
        : (c <= '#' || (c >= '%' && c <= '/')))
      : (c <= '@' || (c < '`'
        ? (c >= '[' && c <= '^')
        : c <= '~')))
    : (c <= 160 || (c < 8287
      ? (c < 8192
        ? c == 5760
        : (c <= 8203 || c == 8239))
      : (c <= 8288 || (c < 65279
        ? c == 12288
        : c <= 65279)))));
}

static inline bool sym_identifier_character_set_3(int32_t c) {
  return (c < 8192
    ? (c < 160
      ? (c < 0
        ? c == 0
        : c <= '~')
      : (c <= 160 || c == 5760))
    : (c <= 8203 || (c < 12288
      ? (c < 8287
        ? c == 8239
        : c <= 8288)
      : (c <= 12288 || c == 65279))));
}

static inline bool sym_identifier_character_set_4(int32_t c) {
  return (c < 160
    ? (c < ':'
      ? (c < 0
        ? c == 0
        : (c <= '#' || (c >= '%' && c <= '/')))
      : (c <= '@' || (c < '`'
        ? (c >= '[' && c <= '^')
        : (c <= '`' || (c >= '|' && c <= '~')))))
    : (c <= 160 || (c < 8287
      ? (c < 8192
        ? c == 5760
        : (c <= 8203 || c == 8239))
      : (c <= 8288 || (c < 65279
        ? c == 12288
        : c <= 65279)))));
}

static inline bool sym_private_property_identifier_character_set_1(int32_t c) {
  return (c < 160
    ? (c < '['
      ? (c < 0
        ? c == 0
        : (c <= '#' || (c >= '%' && c <= '@')))
      : (c <= '^' || (c < '{'
        ? c == '`'
        : c <= '~')))
    : (c <= 160 || (c < 8287
      ? (c < 8192
        ? c == 5760
        : (c <= 8203 || c == 8239))
      : (c <= 8288 || (c < 65279
        ? c == 12288
        : c <= 65279)))));
}

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(67);
      if (lookahead == '!') ADVANCE(154);
      if (lookahead == '"') ADVANCE(158);
      if (lookahead == '#') ADVANCE(2);
      if (lookahead == '$') ADVANCE(195);
      if (lookahead == '%') ADVANCE(142);
      if (lookahead == '&') ADVANCE(131);
      if (lookahead == '\'') ADVANCE(159);
      if (lookahead == '(') ADVANCE(75);
      if (lookahead == ')') ADVANCE(76);
      if (lookahead == '*') ADVANCE(70);
      if (lookahead == '+') ADVANCE(138);
      if (lookahead == ',') ADVANCE(73);
      if (lookahead == '-') ADVANCE(140);
      if (lookahead == '.') ADVANCE(101);
      if (lookahead == '/') ADVANCE(180);
      if (lookahead == '0') ADVANCE(185);
      if (lookahead == ':') ADVANCE(78);
      if (lookahead == ';') ADVANCE(77);
      if (lookahead == '<') ADVANCE(86);
      if (lookahead == '=') ADVANCE(81);
      if (lookahead == '>') ADVANCE(89);
      if (lookahead == '?') ADVANCE(16);
      if (lookahead == '@') ADVANCE(198);
      if (lookahead == '[') ADVANCE(83);
      if (lookahead == '\\') ADVANCE(25);
      if (lookahead == ']') ADVANCE(84);
      if (lookahead == '^') ADVANCE(134);
      if (lookahead == '`') ADVANCE(178);
      if (lookahead == '{') ADVANCE(72);
      if (lookahead == '|') ADVANCE(135);
      if (lookahead == '}') ADVANCE(74);
      if (lookahead == '~') ADVANCE(155);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(186);
      if (anon_sym_BANG_character_set_1(lookahead)) SKIP(64)
      if (lookahead != 0 &&
          lookahead > 31) ADVANCE(196);
      END_STATE();
    case 1:
      if (lookahead == '\n') SKIP(20)
      if (lookahead == '/') ADVANCE(12);
      if (lookahead == '[') ADVANCE(24);
      if (lookahead == '\\') ADVANCE(63);
      if (sym_regex_pattern_character_set_1(lookahead)) ADVANCE(181);
      if (lookahead != 0) ADVANCE(182);
      END_STATE();
    case 2:
      if (lookahead == '!') ADVANCE(68);
      if (lookahead == '\\') ADVANCE(26);
      if (!sym_private_property_identifier_character_set_1(lookahead)) ADVANCE(197);
      END_STATE();
    case 3:
      if (lookahead == '!') ADVANCE(153);
      if (lookahead == '"') ADVANCE(158);
      if (lookahead == '\'') ADVANCE(159);
      if (lookahead == '(') ADVANCE(75);
      if (lookahead == '+') ADVANCE(137);
      if (lookahead == '-') ADVANCE(139);
      if (lookahead == '.') ADVANCE(102);
      if (lookahead == '/') ADVANCE(91);
      if (lookahead == '0') ADVANCE(185);
      if (lookahead == ':') ADVANCE(78);
      if (lookahead == '<') ADVANCE(85);
      if (lookahead == '>') ADVANCE(88);
      if (lookahead == '@') ADVANCE(198);
      if (lookahead == '[') ADVANCE(83);
      if (lookahead == '\\') ADVANCE(27);
      if (lookahead == '`') ADVANCE(178);
      if (lookahead == '{') ADVANCE(72);
      if (lookahead == '~') ADVANCE(155);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(186);
      if (anon_sym_BANG_character_set_1(lookahead)) SKIP(3)
      if (lookahead != 0 &&
          lookahead > '#' &&
          (lookahead < '%' || '?' < lookahead) &&
          lookahead != ']' &&
          lookahead != '^' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(196);
      END_STATE();
    case 4:
      if (lookahead == '!') ADVANCE(21);
      if (lookahead == '"') ADVANCE(158);
      if (lookahead == '#') ADVANCE(23);
      if (lookahead == '%') ADVANCE(142);
      if (lookahead == '&') ADVANCE(131);
      if (lookahead == '\'') ADVANCE(159);
      if (lookahead == '(') ADVANCE(75);
      if (lookahead == ')') ADVANCE(76);
      if (lookahead == '*') ADVANCE(70);
      if (lookahead == '+') ADVANCE(138);
      if (lookahead == ',') ADVANCE(73);
      if (lookahead == '-') ADVANCE(140);
      if (lookahead == '.') ADVANCE(102);
      if (lookahead == '/') ADVANCE(92);
      if (lookahead == '0') ADVANCE(185);
      if (lookahead == ':') ADVANCE(78);
      if (lookahead == ';') ADVANCE(77);
      if (lookahead == '<') ADVANCE(86);
      if (lookahead == '=') ADVANCE(81);
      if (lookahead == '>') ADVANCE(89);
      if (lookahead == '?') ADVANCE(16);
      if (lookahead == '@') ADVANCE(198);
      if (lookahead == '[') ADVANCE(83);
      if (lookahead == '\\') ADVANCE(27);
      if (lookahead == ']') ADVANCE(84);
      if (lookahead == '^') ADVANCE(134);
      if (lookahead == '`') ADVANCE(178);
      if (lookahead == '{') ADVANCE(72);
      if (lookahead == '|') ADVANCE(135);
      if (lookahead == '}') ADVANCE(74);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(186);
      if (anon_sym_BANG_character_set_1(lookahead)) SKIP(4)
      if (lookahead != 0 &&
          lookahead > 31 &&
          lookahead != '~') ADVANCE(196);
      END_STATE();
    case 5:
      if (lookahead == '!') ADVANCE(21);
      if (lookahead == '%') ADVANCE(141);
      if (lookahead == '&') ADVANCE(132);
      if (lookahead == '(') ADVANCE(75);
      if (lookahead == ')') ADVANCE(76);
      if (lookahead == '*') ADVANCE(71);
      if (lookahead == '+') ADVANCE(137);
      if (lookahead == ',') ADVANCE(73);
      if (lookahead == '-') ADVANCE(139);
      if (lookahead == '.') ADVANCE(100);
      if (lookahead == '/') ADVANCE(91);
      if (lookahead == ':') ADVANCE(78);
      if (lookahead == ';') ADVANCE(77);
      if (lookahead == '<') ADVANCE(87);
      if (lookahead == '=') ADVANCE(22);
      if (lookahead == '>') ADVANCE(90);
      if (lookahead == '?') ADVANCE(17);
      if (lookahead == '[') ADVANCE(83);
      if (lookahead == '\\') ADVANCE(27);
      if (lookahead == ']') ADVANCE(84);
      if (lookahead == '^') ADVANCE(133);
      if (lookahead == '`') ADVANCE(178);
      if (lookahead == '{') ADVANCE(72);
      if (lookahead == '|') ADVANCE(136);
      if (lookahead == '}') ADVANCE(74);
      if (anon_sym_BANG_character_set_1(lookahead)) SKIP(6)
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(183);
      if (lookahead != 0 &&
          lookahead > '#' &&
          (lookahead < '\'' || '@' < lookahead) &&
          lookahead != '~') ADVANCE(196);
      END_STATE();
    case 6:
      if (lookahead == '!') ADVANCE(21);
      if (lookahead == '%') ADVANCE(141);
      if (lookahead == '&') ADVANCE(132);
      if (lookahead == '(') ADVANCE(75);
      if (lookahead == ')') ADVANCE(76);
      if (lookahead == '*') ADVANCE(71);
      if (lookahead == '+') ADVANCE(137);
      if (lookahead == ',') ADVANCE(73);
      if (lookahead == '-') ADVANCE(139);
      if (lookahead == '.') ADVANCE(100);
      if (lookahead == '/') ADVANCE(91);
      if (lookahead == ':') ADVANCE(78);
      if (lookahead == ';') ADVANCE(77);
      if (lookahead == '<') ADVANCE(87);
      if (lookahead == '=') ADVANCE(22);
      if (lookahead == '>') ADVANCE(90);
      if (lookahead == '?') ADVANCE(17);
      if (lookahead == '[') ADVANCE(83);
      if (lookahead == '\\') ADVANCE(27);
      if (lookahead == ']') ADVANCE(84);
      if (lookahead == '^') ADVANCE(133);
      if (lookahead == '`') ADVANCE(178);
      if (lookahead == '{') ADVANCE(72);
      if (lookahead == '|') ADVANCE(136);
      if (lookahead == '}') ADVANCE(74);
      if (anon_sym_BANG_character_set_1(lookahead)) SKIP(6)
      if (lookahead != 0 &&
          lookahead > '#' &&
          (lookahead < '\'' || '@' < lookahead) &&
          lookahead != '~') ADVANCE(196);
      END_STATE();
    case 7:
      if (lookahead == '"') ADVANCE(158);
      if (lookahead == '/') ADVANCE(161);
      if (lookahead == '\\') ADVANCE(28);
      if (anon_sym_BANG_character_set_1(lookahead)) ADVANCE(164);
      if (lookahead != 0) ADVANCE(165);
      END_STATE();
    case 8:
      if (lookahead == '$') ADVANCE(29);
      if (lookahead == '/') ADVANCE(180);
      if (lookahead == '\\') ADVANCE(28);
      if (lookahead == '`') ADVANCE(178);
      if (anon_sym_BANG_character_set_1(lookahead)) SKIP(9)
      END_STATE();
    case 9:
      if (lookahead == '$') ADVANCE(29);
      if (lookahead == '/') ADVANCE(12);
      if (lookahead == '`') ADVANCE(178);
      if (anon_sym_BANG_character_set_1(lookahead)) SKIP(9)
      END_STATE();
    case 10:
      if (lookahead == '\'') ADVANCE(159);
      if (lookahead == '/') ADVANCE(167);
      if (lookahead == '\\') ADVANCE(28);
      if (anon_sym_BANG_character_set_1(lookahead)) ADVANCE(170);
      if (lookahead != 0) ADVANCE(171);
      END_STATE();
    case 11:
      if (lookahead == '(') ADVANCE(75);
      if (lookahead == '.') ADVANCE(100);
      if (lookahead == '/') ADVANCE(91);
      if (lookahead == ':') ADVANCE(78);
      if (lookahead == '=') ADVANCE(79);
      if (lookahead == '>') ADVANCE(88);
      if (lookahead == '\\') ADVANCE(27);
      if (lookahead == '{') ADVANCE(72);
      if (anon_sym_BANG_character_set_1(lookahead)) SKIP(11)
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      if (lookahead != 0 &&
          lookahead > '~') ADVANCE(196);
      END_STATE();
    case 12:
      if (lookahead == '*') ADVANCE(14);
      if (lookahead == '/') ADVANCE(177);
      END_STATE();
    case 13:
      if (lookahead == '*') ADVANCE(13);
      if (lookahead == '/') ADVANCE(176);
      if (lookahead != 0) ADVANCE(14);
      END_STATE();
    case 14:
      if (lookahead == '*') ADVANCE(13);
      if (lookahead != 0) ADVANCE(14);
      END_STATE();
    case 15:
      if (lookahead == '.') ADVANCE(18);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(192);
      END_STATE();
    case 16:
      if (lookahead == '.') ADVANCE(104);
      if (lookahead == '?') ADVANCE(152);
      END_STATE();
    case 17:
      if (lookahead == '.') ADVANCE(104);
      if (lookahead == '?') ADVANCE(151);
      END_STATE();
    case 18:
      if (lookahead == '.') ADVANCE(120);
      END_STATE();
    case 19:
      if (lookahead == '/') ADVANCE(94);
      if (lookahead == '<') ADVANCE(85);
      if (lookahead == '{') ADVANCE(72);
      if (anon_sym_BANG_character_set_1(lookahead)) ADVANCE(97);
      if (lookahead != 0 &&
          lookahead != '>' &&
          lookahead != '}') ADVANCE(98);
      END_STATE();
    case 20:
      if (lookahead == '/') ADVANCE(12);
      if (anon_sym_BANG_character_set_1(lookahead)) SKIP(20)
      END_STATE();
    case 21:
      if (lookahead == '=') ADVANCE(148);
      END_STATE();
    case 22:
      if (lookahead == '=') ADVANCE(146);
      END_STATE();
    case 23:
      if (lookahead == '\\') ADVANCE(26);
      if (!sym_private_property_identifier_character_set_1(lookahead)) ADVANCE(197);
      END_STATE();
    case 24:
      if (lookahead == '\\') ADVANCE(62);
      if (lookahead == ']') ADVANCE(182);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(24);
      END_STATE();
    case 25:
      if (lookahead == 'u') ADVANCE(30);
      if (lookahead == 'x') ADVANCE(54);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(175);
      if (lookahead != 0) ADVANCE(172);
      END_STATE();
    case 26:
      if (lookahead == 'u') ADVANCE(31);
      END_STATE();
    case 27:
      if (lookahead == 'u') ADVANCE(32);
      END_STATE();
    case 28:
      if (lookahead == 'u') ADVANCE(33);
      if (lookahead == 'x') ADVANCE(54);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(175);
      if (lookahead != 0) ADVANCE(172);
      END_STATE();
    case 29:
      if (lookahead == '{') ADVANCE(179);
      END_STATE();
    case 30:
      if (lookahead == '{') ADVANCE(49);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(59);
      END_STATE();
    case 31:
      if (lookahead == '{') ADVANCE(52);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(60);
      END_STATE();
    case 32:
      if (lookahead == '{') ADVANCE(53);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(61);
      END_STATE();
    case 33:
      if (lookahead == '{') ADVANCE(55);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(51);
      END_STATE();
    case 34:
      if (lookahead == '}') ADVANCE(196);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(34);
      END_STATE();
    case 35:
      if (lookahead == '}') ADVANCE(197);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(35);
      END_STATE();
    case 36:
      if (lookahead == '}') ADVANCE(172);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(36);
      END_STATE();
    case 37:
      if (lookahead == '}') ADVANCE(173);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(37);
      END_STATE();
    case 38:
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(44);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(191);
      END_STATE();
    case 39:
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(187);
      END_STATE();
    case 40:
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(188);
      END_STATE();
    case 41:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(186);
      END_STATE();
    case 42:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(192);
      END_STATE();
    case 43:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(190);
      END_STATE();
    case 44:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(191);
      END_STATE();
    case 45:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(196);
      END_STATE();
    case 46:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(197);
      END_STATE();
    case 47:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(172);
      END_STATE();
    case 48:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(189);
      END_STATE();
    case 49:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(37);
      END_STATE();
    case 50:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(173);
      END_STATE();
    case 51:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(54);
      END_STATE();
    case 52:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(35);
      END_STATE();
    case 53:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(34);
      END_STATE();
    case 54:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(47);
      END_STATE();
    case 55:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(36);
      END_STATE();
    case 56:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(50);
      END_STATE();
    case 57:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(46);
      END_STATE();
    case 58:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(45);
      END_STATE();
    case 59:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(56);
      END_STATE();
    case 60:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(57);
      END_STATE();
    case 61:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(58);
      END_STATE();
    case 62:
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(24);
      END_STATE();
    case 63:
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(182);
      END_STATE();
    case 64:
      if (eof) ADVANCE(67);
      if (lookahead == '!') ADVANCE(154);
      if (lookahead == '"') ADVANCE(158);
      if (lookahead == '#') ADVANCE(2);
      if (lookahead == '$') ADVANCE(195);
      if (lookahead == '%') ADVANCE(142);
      if (lookahead == '&') ADVANCE(131);
      if (lookahead == '\'') ADVANCE(159);
      if (lookahead == '(') ADVANCE(75);
      if (lookahead == ')') ADVANCE(76);
      if (lookahead == '*') ADVANCE(70);
      if (lookahead == '+') ADVANCE(138);
      if (lookahead == ',') ADVANCE(73);
      if (lookahead == '-') ADVANCE(140);
      if (lookahead == '.') ADVANCE(101);
      if (lookahead == '/') ADVANCE(91);
      if (lookahead == '0') ADVANCE(185);
      if (lookahead == ':') ADVANCE(78);
      if (lookahead == ';') ADVANCE(77);
      if (lookahead == '<') ADVANCE(86);
      if (lookahead == '=') ADVANCE(81);
      if (lookahead == '>') ADVANCE(89);
      if (lookahead == '?') ADVANCE(16);
      if (lookahead == '@') ADVANCE(198);
      if (lookahead == '[') ADVANCE(83);
      if (lookahead == '\\') ADVANCE(27);
      if (lookahead == ']') ADVANCE(84);
      if (lookahead == '^') ADVANCE(134);
      if (lookahead == '`') ADVANCE(178);
      if (lookahead == '{') ADVANCE(72);
      if (lookahead == '|') ADVANCE(135);
      if (lookahead == '}') ADVANCE(74);
      if (lookahead == '~') ADVANCE(155);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(186);
      if (anon_sym_BANG_character_set_1(lookahead)) SKIP(64)
      if (lookahead != 0 &&
          lookahead > 31) ADVANCE(196);
      END_STATE();
    case 65:
      if (eof) ADVANCE(67);
      if (lookahead == '!') ADVANCE(154);
      if (lookahead == '"') ADVANCE(158);
      if (lookahead == '#') ADVANCE(23);
      if (lookahead == '%') ADVANCE(141);
      if (lookahead == '&') ADVANCE(132);
      if (lookahead == '\'') ADVANCE(159);
      if (lookahead == '(') ADVANCE(75);
      if (lookahead == ')') ADVANCE(76);
      if (lookahead == '*') ADVANCE(71);
      if (lookahead == '+') ADVANCE(137);
      if (lookahead == ',') ADVANCE(73);
      if (lookahead == '-') ADVANCE(139);
      if (lookahead == '.') ADVANCE(102);
      if (lookahead == '/') ADVANCE(91);
      if (lookahead == '0') ADVANCE(185);
      if (lookahead == ':') ADVANCE(78);
      if (lookahead == ';') ADVANCE(77);
      if (lookahead == '<') ADVANCE(87);
      if (lookahead == '=') ADVANCE(80);
      if (lookahead == '>') ADVANCE(90);
      if (lookahead == '?') ADVANCE(17);
      if (lookahead == '@') ADVANCE(198);
      if (lookahead == '[') ADVANCE(83);
      if (lookahead == '\\') ADVANCE(27);
      if (lookahead == ']') ADVANCE(84);
      if (lookahead == '^') ADVANCE(133);
      if (lookahead == '`') ADVANCE(178);
      if (lookahead == '{') ADVANCE(72);
      if (lookahead == '|') ADVANCE(136);
      if (lookahead == '}') ADVANCE(74);
      if (lookahead == '~') ADVANCE(155);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(186);
      if (anon_sym_BANG_character_set_1(lookahead)) SKIP(65)
      if (lookahead != 0 &&
          lookahead > 31) ADVANCE(196);
      END_STATE();
    case 66:
      if (eof) ADVANCE(67);
      if (lookahead == '!') ADVANCE(153);
      if (lookahead == '"') ADVANCE(158);
      if (lookahead == '#') ADVANCE(2);
      if (lookahead == '\'') ADVANCE(159);
      if (lookahead == '(') ADVANCE(75);
      if (lookahead == ')') ADVANCE(76);
      if (lookahead == '*') ADVANCE(69);
      if (lookahead == '+') ADVANCE(137);
      if (lookahead == ',') ADVANCE(73);
      if (lookahead == '-') ADVANCE(139);
      if (lookahead == '.') ADVANCE(15);
      if (lookahead == '/') ADVANCE(91);
      if (lookahead == '0') ADVANCE(185);
      if (lookahead == ':') ADVANCE(78);
      if (lookahead == ';') ADVANCE(77);
      if (lookahead == '<') ADVANCE(85);
      if (lookahead == '=') ADVANCE(82);
      if (lookahead == '>') ADVANCE(88);
      if (lookahead == '@') ADVANCE(198);
      if (lookahead == '[') ADVANCE(83);
      if (lookahead == '\\') ADVANCE(27);
      if (lookahead == ']') ADVANCE(84);
      if (lookahead == '`') ADVANCE(178);
      if (lookahead == '{') ADVANCE(72);
      if (lookahead == '}') ADVANCE(74);
      if (lookahead == '~') ADVANCE(155);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(186);
      if (anon_sym_BANG_character_set_1(lookahead)) SKIP(66)
      if (lookahead != 0 &&
          lookahead > 31 &&
          (lookahead < '%' || '?' < lookahead) &&
          lookahead != '^' &&
          lookahead != '|') ADVANCE(196);
      END_STATE();
    case 67:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 68:
      ACCEPT_TOKEN(sym_hash_bang_line);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(68);
      END_STATE();
    case 69:
      ACCEPT_TOKEN(anon_sym_STAR);
      END_STATE();
    case 70:
      ACCEPT_TOKEN(anon_sym_STAR);
      if (lookahead == '*') ADVANCE(144);
      if (lookahead == '=') ADVANCE(107);
      END_STATE();
    case 71:
      ACCEPT_TOKEN(anon_sym_STAR);
      if (lookahead == '*') ADVANCE(143);
      END_STATE();
    case 72:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 73:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 74:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 75:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 76:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 77:
      ACCEPT_TOKEN(anon_sym_SEMI);
      END_STATE();
    case 78:
      ACCEPT_TOKEN(anon_sym_COLON);
      END_STATE();
    case 79:
      ACCEPT_TOKEN(anon_sym_EQ);
      END_STATE();
    case 80:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(146);
      END_STATE();
    case 81:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(146);
      if (lookahead == '>') ADVANCE(103);
      END_STATE();
    case 82:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '>') ADVANCE(103);
      END_STATE();
    case 83:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 84:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 85:
      ACCEPT_TOKEN(anon_sym_LT);
      END_STATE();
    case 86:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '<') ADVANCE(130);
      if (lookahead == '=') ADVANCE(145);
      END_STATE();
    case 87:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '<') ADVANCE(129);
      if (lookahead == '=') ADVANCE(145);
      END_STATE();
    case 88:
      ACCEPT_TOKEN(anon_sym_GT);
      END_STATE();
    case 89:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(150);
      if (lookahead == '>') ADVANCE(125);
      END_STATE();
    case 90:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(150);
      if (lookahead == '>') ADVANCE(126);
      END_STATE();
    case 91:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '*') ADVANCE(14);
      if (lookahead == '/') ADVANCE(177);
      END_STATE();
    case 92:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '*') ADVANCE(14);
      if (lookahead == '/') ADVANCE(177);
      if (lookahead == '=') ADVANCE(108);
      END_STATE();
    case 93:
      ACCEPT_TOKEN(sym_jsx_text);
      if (lookahead == '\n') ADVANCE(98);
      if (lookahead == '<' ||
          lookahead == '>' ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(177);
      if (lookahead != 0) ADVANCE(93);
      END_STATE();
    case 94:
      ACCEPT_TOKEN(sym_jsx_text);
      if (lookahead == '*') ADVANCE(96);
      if (lookahead == '/') ADVANCE(93);
      if (lookahead != 0 &&
          lookahead != '<' &&
          lookahead != '>' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(98);
      END_STATE();
    case 95:
      ACCEPT_TOKEN(sym_jsx_text);
      if (lookahead == '*') ADVANCE(95);
      if (lookahead == '/') ADVANCE(98);
      if (lookahead == '<' ||
          lookahead == '>' ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(14);
      if (lookahead != 0) ADVANCE(96);
      END_STATE();
    case 96:
      ACCEPT_TOKEN(sym_jsx_text);
      if (lookahead == '*') ADVANCE(95);
      if (lookahead == '<' ||
          lookahead == '>' ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(14);
      if (lookahead != 0) ADVANCE(96);
      END_STATE();
    case 97:
      ACCEPT_TOKEN(sym_jsx_text);
      if (lookahead == '/') ADVANCE(94);
      if (anon_sym_BANG_character_set_1(lookahead)) ADVANCE(97);
      if (lookahead != 0 &&
          lookahead != '<' &&
          lookahead != '>' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(98);
      END_STATE();
    case 98:
      ACCEPT_TOKEN(sym_jsx_text);
      if (lookahead != 0 &&
          lookahead != '<' &&
          lookahead != '>' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(98);
      END_STATE();
    case 99:
      ACCEPT_TOKEN(sym_jsx_identifier);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(99);
      END_STATE();
    case 100:
      ACCEPT_TOKEN(anon_sym_DOT);
      END_STATE();
    case 101:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '.') ADVANCE(18);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(192);
      END_STATE();
    case 102:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(192);
      END_STATE();
    case 103:
      ACCEPT_TOKEN(anon_sym_EQ_GT);
      END_STATE();
    case 104:
      ACCEPT_TOKEN(anon_sym_QMARK_DOT);
      END_STATE();
    case 105:
      ACCEPT_TOKEN(anon_sym_PLUS_EQ);
      END_STATE();
    case 106:
      ACCEPT_TOKEN(anon_sym_DASH_EQ);
      END_STATE();
    case 107:
      ACCEPT_TOKEN(anon_sym_STAR_EQ);
      END_STATE();
    case 108:
      ACCEPT_TOKEN(anon_sym_SLASH_EQ);
      END_STATE();
    case 109:
      ACCEPT_TOKEN(anon_sym_PERCENT_EQ);
      END_STATE();
    case 110:
      ACCEPT_TOKEN(anon_sym_CARET_EQ);
      END_STATE();
    case 111:
      ACCEPT_TOKEN(anon_sym_AMP_EQ);
      END_STATE();
    case 112:
      ACCEPT_TOKEN(anon_sym_PIPE_EQ);
      END_STATE();
    case 113:
      ACCEPT_TOKEN(anon_sym_GT_GT_EQ);
      END_STATE();
    case 114:
      ACCEPT_TOKEN(anon_sym_GT_GT_GT_EQ);
      END_STATE();
    case 115:
      ACCEPT_TOKEN(anon_sym_LT_LT_EQ);
      END_STATE();
    case 116:
      ACCEPT_TOKEN(anon_sym_STAR_STAR_EQ);
      END_STATE();
    case 117:
      ACCEPT_TOKEN(anon_sym_AMP_AMP_EQ);
      END_STATE();
    case 118:
      ACCEPT_TOKEN(anon_sym_PIPE_PIPE_EQ);
      END_STATE();
    case 119:
      ACCEPT_TOKEN(anon_sym_QMARK_QMARK_EQ);
      END_STATE();
    case 120:
      ACCEPT_TOKEN(anon_sym_DOT_DOT_DOT);
      END_STATE();
    case 121:
      ACCEPT_TOKEN(anon_sym_AMP_AMP);
      END_STATE();
    case 122:
      ACCEPT_TOKEN(anon_sym_AMP_AMP);
      if (lookahead == '=') ADVANCE(117);
      END_STATE();
    case 123:
      ACCEPT_TOKEN(anon_sym_PIPE_PIPE);
      END_STATE();
    case 124:
      ACCEPT_TOKEN(anon_sym_PIPE_PIPE);
      if (lookahead == '=') ADVANCE(118);
      END_STATE();
    case 125:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      if (lookahead == '=') ADVANCE(113);
      if (lookahead == '>') ADVANCE(128);
      END_STATE();
    case 126:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      if (lookahead == '>') ADVANCE(127);
      END_STATE();
    case 127:
      ACCEPT_TOKEN(anon_sym_GT_GT_GT);
      END_STATE();
    case 128:
      ACCEPT_TOKEN(anon_sym_GT_GT_GT);
      if (lookahead == '=') ADVANCE(114);
      END_STATE();
    case 129:
      ACCEPT_TOKEN(anon_sym_LT_LT);
      END_STATE();
    case 130:
      ACCEPT_TOKEN(anon_sym_LT_LT);
      if (lookahead == '=') ADVANCE(115);
      END_STATE();
    case 131:
      ACCEPT_TOKEN(anon_sym_AMP);
      if (lookahead == '&') ADVANCE(122);
      if (lookahead == '=') ADVANCE(111);
      END_STATE();
    case 132:
      ACCEPT_TOKEN(anon_sym_AMP);
      if (lookahead == '&') ADVANCE(121);
      END_STATE();
    case 133:
      ACCEPT_TOKEN(anon_sym_CARET);
      END_STATE();
    case 134:
      ACCEPT_TOKEN(anon_sym_CARET);
      if (lookahead == '=') ADVANCE(110);
      END_STATE();
    case 135:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '=') ADVANCE(112);
      if (lookahead == '|') ADVANCE(124);
      END_STATE();
    case 136:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '|') ADVANCE(123);
      END_STATE();
    case 137:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '+') ADVANCE(156);
      END_STATE();
    case 138:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '+') ADVANCE(156);
      if (lookahead == '=') ADVANCE(105);
      END_STATE();
    case 139:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(157);
      END_STATE();
    case 140:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(157);
      if (lookahead == '=') ADVANCE(106);
      END_STATE();
    case 141:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      END_STATE();
    case 142:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      if (lookahead == '=') ADVANCE(109);
      END_STATE();
    case 143:
      ACCEPT_TOKEN(anon_sym_STAR_STAR);
      END_STATE();
    case 144:
      ACCEPT_TOKEN(anon_sym_STAR_STAR);
      if (lookahead == '=') ADVANCE(116);
      END_STATE();
    case 145:
      ACCEPT_TOKEN(anon_sym_LT_EQ);
      END_STATE();
    case 146:
      ACCEPT_TOKEN(anon_sym_EQ_EQ);
      if (lookahead == '=') ADVANCE(147);
      END_STATE();
    case 147:
      ACCEPT_TOKEN(anon_sym_EQ_EQ_EQ);
      END_STATE();
    case 148:
      ACCEPT_TOKEN(anon_sym_BANG_EQ);
      if (lookahead == '=') ADVANCE(149);
      END_STATE();
    case 149:
      ACCEPT_TOKEN(anon_sym_BANG_EQ_EQ);
      END_STATE();
    case 150:
      ACCEPT_TOKEN(anon_sym_GT_EQ);
      END_STATE();
    case 151:
      ACCEPT_TOKEN(anon_sym_QMARK_QMARK);
      END_STATE();
    case 152:
      ACCEPT_TOKEN(anon_sym_QMARK_QMARK);
      if (lookahead == '=') ADVANCE(119);
      END_STATE();
    case 153:
      ACCEPT_TOKEN(anon_sym_BANG);
      END_STATE();
    case 154:
      ACCEPT_TOKEN(anon_sym_BANG);
      if (lookahead == '=') ADVANCE(148);
      END_STATE();
    case 155:
      ACCEPT_TOKEN(anon_sym_TILDE);
      END_STATE();
    case 156:
      ACCEPT_TOKEN(anon_sym_PLUS_PLUS);
      END_STATE();
    case 157:
      ACCEPT_TOKEN(anon_sym_DASH_DASH);
      END_STATE();
    case 158:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      END_STATE();
    case 159:
      ACCEPT_TOKEN(anon_sym_SQUOTE);
      END_STATE();
    case 160:
      ACCEPT_TOKEN(sym_unescaped_double_string_fragment);
      if (lookahead == '\n') ADVANCE(165);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(160);
      END_STATE();
    case 161:
      ACCEPT_TOKEN(sym_unescaped_double_string_fragment);
      if (lookahead == '*') ADVANCE(163);
      if (lookahead == '/') ADVANCE(160);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(165);
      END_STATE();
    case 162:
      ACCEPT_TOKEN(sym_unescaped_double_string_fragment);
      if (lookahead == '*') ADVANCE(162);
      if (lookahead == '/') ADVANCE(165);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(163);
      END_STATE();
    case 163:
      ACCEPT_TOKEN(sym_unescaped_double_string_fragment);
      if (lookahead == '*') ADVANCE(162);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(163);
      END_STATE();
    case 164:
      ACCEPT_TOKEN(sym_unescaped_double_string_fragment);
      if (lookahead == '/') ADVANCE(161);
      if (anon_sym_BANG_character_set_1(lookahead)) ADVANCE(164);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(165);
      END_STATE();
    case 165:
      ACCEPT_TOKEN(sym_unescaped_double_string_fragment);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(165);
      END_STATE();
    case 166:
      ACCEPT_TOKEN(sym_unescaped_single_string_fragment);
      if (lookahead == '\n') ADVANCE(171);
      if (lookahead != 0 &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(166);
      END_STATE();
    case 167:
      ACCEPT_TOKEN(sym_unescaped_single_string_fragment);
      if (lookahead == '*') ADVANCE(169);
      if (lookahead == '/') ADVANCE(166);
      if (lookahead != 0 &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(171);
      END_STATE();
    case 168:
      ACCEPT_TOKEN(sym_unescaped_single_string_fragment);
      if (lookahead == '*') ADVANCE(168);
      if (lookahead == '/') ADVANCE(171);
      if (lookahead != 0 &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(169);
      END_STATE();
    case 169:
      ACCEPT_TOKEN(sym_unescaped_single_string_fragment);
      if (lookahead == '*') ADVANCE(168);
      if (lookahead != 0 &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(169);
      END_STATE();
    case 170:
      ACCEPT_TOKEN(sym_unescaped_single_string_fragment);
      if (lookahead == '/') ADVANCE(167);
      if (anon_sym_BANG_character_set_1(lookahead)) ADVANCE(170);
      if (lookahead != 0 &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(171);
      END_STATE();
    case 171:
      ACCEPT_TOKEN(sym_unescaped_single_string_fragment);
      if (lookahead != 0 &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(171);
      END_STATE();
    case 172:
      ACCEPT_TOKEN(sym_escape_sequence);
      END_STATE();
    case 173:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (lookahead == '\\') ADVANCE(27);
      if (!sym_identifier_character_set_1(lookahead)) ADVANCE(196);
      END_STATE();
    case 174:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(172);
      END_STATE();
    case 175:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(174);
      END_STATE();
    case 176:
      ACCEPT_TOKEN(sym_comment);
      END_STATE();
    case 177:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(177);
      END_STATE();
    case 178:
      ACCEPT_TOKEN(anon_sym_BQUOTE);
      END_STATE();
    case 179:
      ACCEPT_TOKEN(anon_sym_DOLLAR_LBRACE);
      END_STATE();
    case 180:
      ACCEPT_TOKEN(anon_sym_SLASH2);
      if (lookahead == '*') ADVANCE(14);
      if (lookahead == '/') ADVANCE(177);
      END_STATE();
    case 181:
      ACCEPT_TOKEN(sym_regex_pattern);
      if (lookahead == '\n') SKIP(20)
      if (lookahead == '/') ADVANCE(12);
      if (lookahead == '[') ADVANCE(24);
      if (lookahead == '\\') ADVANCE(63);
      if (sym_regex_pattern_character_set_1(lookahead)) ADVANCE(181);
      if (lookahead != 0) ADVANCE(182);
      END_STATE();
    case 182:
      ACCEPT_TOKEN(sym_regex_pattern);
      if (lookahead == '[') ADVANCE(24);
      if (lookahead == '\\') ADVANCE(63);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '/') ADVANCE(182);
      END_STATE();
    case 183:
      ACCEPT_TOKEN(sym_regex_flags);
      if (lookahead == '\\') ADVANCE(27);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(183);
      if (!sym_identifier_character_set_2(lookahead)) ADVANCE(196);
      END_STATE();
    case 184:
      ACCEPT_TOKEN(sym_number);
      END_STATE();
    case 185:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '.') ADVANCE(193);
      if (lookahead == '0') ADVANCE(190);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(39);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(38);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(40);
      if (lookahead == 'X' ||
          lookahead == 'x') ADVANCE(48);
      if (lookahead == '_') ADVANCE(43);
      if (lookahead == 'n') ADVANCE(184);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(186);
      END_STATE();
    case 186:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '.') ADVANCE(193);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(38);
      if (lookahead == '_') ADVANCE(41);
      if (lookahead == 'n') ADVANCE(184);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(186);
      END_STATE();
    case 187:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '_') ADVANCE(39);
      if (lookahead == 'n') ADVANCE(184);
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(187);
      END_STATE();
    case 188:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '_') ADVANCE(40);
      if (lookahead == 'n') ADVANCE(184);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(188);
      END_STATE();
    case 189:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '_') ADVANCE(48);
      if (lookahead == 'n') ADVANCE(184);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(189);
      END_STATE();
    case 190:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '_') ADVANCE(43);
      if (lookahead == 'n') ADVANCE(184);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(190);
      END_STATE();
    case 191:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '_') ADVANCE(44);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(191);
      END_STATE();
    case 192:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(38);
      if (lookahead == '_') ADVANCE(42);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(192);
      END_STATE();
    case 193:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(38);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(192);
      END_STATE();
    case 194:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '-') ADVANCE(99);
      if (lookahead == '\\') ADVANCE(27);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(194);
      if (!sym_identifier_character_set_3(lookahead)) ADVANCE(196);
      END_STATE();
    case 195:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '\\') ADVANCE(27);
      if (lookahead == '{') ADVANCE(179);
      if (!sym_identifier_character_set_4(lookahead)) ADVANCE(196);
      END_STATE();
    case 196:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '\\') ADVANCE(27);
      if (!sym_identifier_character_set_1(lookahead)) ADVANCE(196);
      END_STATE();
    case 197:
      ACCEPT_TOKEN(sym_private_property_identifier);
      if (lookahead == '\\') ADVANCE(26);
      if (!sym_identifier_character_set_1(lookahead)) ADVANCE(197);
      END_STATE();
    case 198:
      ACCEPT_TOKEN(anon_sym_AT);
      END_STATE();
    default:
      return false;
  }
}

static bool ts_lex_keywords(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (lookahead == 'a') ADVANCE(1);
      if (lookahead == 'b') ADVANCE(2);
      if (lookahead == 'c') ADVANCE(3);
      if (lookahead == 'd') ADVANCE(4);
      if (lookahead == 'e') ADVANCE(5);
      if (lookahead == 'f') ADVANCE(6);
      if (lookahead == 'g') ADVANCE(7);
      if (lookahead == 'i') ADVANCE(8);
      if (lookahead == 'l') ADVANCE(9);
      if (lookahead == 'n') ADVANCE(10);
      if (lookahead == 'o') ADVANCE(11);
      if (lookahead == 'r') ADVANCE(12);
      if (lookahead == 's') ADVANCE(13);
      if (lookahead == 't') ADVANCE(14);
      if (lookahead == 'u') ADVANCE(15);
      if (lookahead == 'v') ADVANCE(16);
      if (lookahead == 'w') ADVANCE(17);
      if (lookahead == 'y') ADVANCE(18);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 5760 ||
          (8192 <= lookahead && lookahead <= 8203) ||
          lookahead == 8239 ||
          lookahead == 8287 ||
          lookahead == 8288 ||
          lookahead == 12288 ||
          lookahead == 65279) SKIP(0)
      END_STATE();
    case 1:
      if (lookahead == 's') ADVANCE(19);
      if (lookahead == 'w') ADVANCE(20);
      END_STATE();
    case 2:
      if (lookahead == 'r') ADVANCE(21);
      END_STATE();
    case 3:
      if (lookahead == 'a') ADVANCE(22);
      if (lookahead == 'l') ADVANCE(23);
      if (lookahead == 'o') ADVANCE(24);
      END_STATE();
    case 4:
      if (lookahead == 'e') ADVANCE(25);
      if (lookahead == 'o') ADVANCE(26);
      END_STATE();
    case 5:
      if (lookahead == 'l') ADVANCE(27);
      if (lookahead == 'x') ADVANCE(28);
      END_STATE();
    case 6:
      if (lookahead == 'a') ADVANCE(29);
      if (lookahead == 'i') ADVANCE(30);
      if (lookahead == 'o') ADVANCE(31);
      if (lookahead == 'r') ADVANCE(32);
      if (lookahead == 'u') ADVANCE(33);
      END_STATE();
    case 7:
      if (lookahead == 'e') ADVANCE(34);
      END_STATE();
    case 8:
      if (lookahead == 'f') ADVANCE(35);
      if (lookahead == 'm') ADVANCE(36);
      if (lookahead == 'n') ADVANCE(37);
      END_STATE();
    case 9:
      if (lookahead == 'e') ADVANCE(38);
      END_STATE();
    case 10:
      if (lookahead == 'e') ADVANCE(39);
      if (lookahead == 'u') ADVANCE(40);
      END_STATE();
    case 11:
      if (lookahead == 'f') ADVANCE(41);
      END_STATE();
    case 12:
      if (lookahead == 'e') ADVANCE(42);
      END_STATE();
    case 13:
      if (lookahead == 'e') ADVANCE(43);
      if (lookahead == 't') ADVANCE(44);
      if (lookahead == 'u') ADVANCE(45);
      if (lookahead == 'w') ADVANCE(46);
      END_STATE();
    case 14:
      if (lookahead == 'a') ADVANCE(47);
      if (lookahead == 'h') ADVANCE(48);
      if (lookahead == 'r') ADVANCE(49);
      if (lookahead == 'y') ADVANCE(50);
      END_STATE();
    case 15:
      if (lookahead == 'n') ADVANCE(51);
      END_STATE();
    case 16:
      if (lookahead == 'a') ADVANCE(52);
      if (lookahead == 'o') ADVANCE(53);
      END_STATE();
    case 17:
      if (lookahead == 'h') ADVANCE(54);
      if (lookahead == 'i') ADVANCE(55);
      END_STATE();
    case 18:
      if (lookahead == 'i') ADVANCE(56);
      END_STATE();
    case 19:
      ACCEPT_TOKEN(anon_sym_as);
      if (lookahead == 'y') ADVANCE(57);
      END_STATE();
    case 20:
      if (lookahead == 'a') ADVANCE(58);
      END_STATE();
    case 21:
      if (lookahead == 'e') ADVANCE(59);
      END_STATE();
    case 22:
      if (lookahead == 's') ADVANCE(60);
      if (lookahead == 't') ADVANCE(61);
      END_STATE();
    case 23:
      if (lookahead == 'a') ADVANCE(62);
      END_STATE();
    case 24:
      if (lookahead == 'n') ADVANCE(63);
      END_STATE();
    case 25:
      if (lookahead == 'b') ADVANCE(64);
      if (lookahead == 'f') ADVANCE(65);
      if (lookahead == 'l') ADVANCE(66);
      END_STATE();
    case 26:
      ACCEPT_TOKEN(anon_sym_do);
      END_STATE();
    case 27:
      if (lookahead == 's') ADVANCE(67);
      END_STATE();
    case 28:
      if (lookahead == 'p') ADVANCE(68);
      if (lookahead == 't') ADVANCE(69);
      END_STATE();
    case 29:
      if (lookahead == 'l') ADVANCE(70);
      END_STATE();
    case 30:
      if (lookahead == 'n') ADVANCE(71);
      END_STATE();
    case 31:
      if (lookahead == 'r') ADVANCE(72);
      END_STATE();
    case 32:
      if (lookahead == 'o') ADVANCE(73);
      END_STATE();
    case 33:
      if (lookahead == 'n') ADVANCE(74);
      END_STATE();
    case 34:
      if (lookahead == 't') ADVANCE(75);
      END_STATE();
    case 35:
      ACCEPT_TOKEN(anon_sym_if);
      END_STATE();
    case 36:
      if (lookahead == 'p') ADVANCE(76);
      END_STATE();
    case 37:
      ACCEPT_TOKEN(anon_sym_in);
      if (lookahead == 's') ADVANCE(77);
      END_STATE();
    case 38:
      if (lookahead == 't') ADVANCE(78);
      END_STATE();
    case 39:
      if (lookahead == 'w') ADVANCE(79);
      END_STATE();
    case 40:
      if (lookahead == 'l') ADVANCE(80);
      END_STATE();
    case 41:
      ACCEPT_TOKEN(anon_sym_of);
      END_STATE();
    case 42:
      if (lookahead == 't') ADVANCE(81);
      END_STATE();
    case 43:
      if (lookahead == 't') ADVANCE(82);
      END_STATE();
    case 44:
      if (lookahead == 'a') ADVANCE(83);
      END_STATE();
    case 45:
      if (lookahead == 'p') ADVANCE(84);
      END_STATE();
    case 46:
      if (lookahead == 'i') ADVANCE(85);
      END_STATE();
    case 47:
      if (lookahead == 'r') ADVANCE(86);
      END_STATE();
    case 48:
      if (lookahead == 'i') ADVANCE(87);
      if (lookahead == 'r') ADVANCE(88);
      END_STATE();
    case 49:
      if (lookahead == 'u') ADVANCE(89);
      if (lookahead == 'y') ADVANCE(90);
      END_STATE();
    case 50:
      if (lookahead == 'p') ADVANCE(91);
      END_STATE();
    case 51:
      if (lookahead == 'd') ADVANCE(92);
      END_STATE();
    case 52:
      if (lookahead == 'r') ADVANCE(93);
      END_STATE();
    case 53:
      if (lookahead == 'i') ADVANCE(94);
      END_STATE();
    case 54:
      if (lookahead == 'i') ADVANCE(95);
      END_STATE();
    case 55:
      if (lookahead == 't') ADVANCE(96);
      END_STATE();
    case 56:
      if (lookahead == 'e') ADVANCE(97);
      END_STATE();
    case 57:
      if (lookahead == 'n') ADVANCE(98);
      END_STATE();
    case 58:
      if (lookahead == 'i') ADVANCE(99);
      END_STATE();
    case 59:
      if (lookahead == 'a') ADVANCE(100);
      END_STATE();
    case 60:
      if (lookahead == 'e') ADVANCE(101);
      END_STATE();
    case 61:
      if (lookahead == 'c') ADVANCE(102);
      END_STATE();
    case 62:
      if (lookahead == 's') ADVANCE(103);
      END_STATE();
    case 63:
      if (lookahead == 's') ADVANCE(104);
      if (lookahead == 't') ADVANCE(105);
      END_STATE();
    case 64:
      if (lookahead == 'u') ADVANCE(106);
      END_STATE();
    case 65:
      if (lookahead == 'a') ADVANCE(107);
      END_STATE();
    case 66:
      if (lookahead == 'e') ADVANCE(108);
      END_STATE();
    case 67:
      if (lookahead == 'e') ADVANCE(109);
      END_STATE();
    case 68:
      if (lookahead == 'o') ADVANCE(110);
      END_STATE();
    case 69:
      if (lookahead == 'e') ADVANCE(111);
      END_STATE();
    case 70:
      if (lookahead == 's') ADVANCE(112);
      END_STATE();
    case 71:
      if (lookahead == 'a') ADVANCE(113);
      END_STATE();
    case 72:
      ACCEPT_TOKEN(anon_sym_for);
      END_STATE();
    case 73:
      if (lookahead == 'm') ADVANCE(114);
      END_STATE();
    case 74:
      if (lookahead == 'c') ADVANCE(115);
      END_STATE();
    case 75:
      ACCEPT_TOKEN(anon_sym_get);
      END_STATE();
    case 76:
      if (lookahead == 'o') ADVANCE(116);
      END_STATE();
    case 77:
      if (lookahead == 't') ADVANCE(117);
      END_STATE();
    case 78:
      ACCEPT_TOKEN(anon_sym_let);
      END_STATE();
    case 79:
      ACCEPT_TOKEN(anon_sym_new);
      END_STATE();
    case 80:
      if (lookahead == 'l') ADVANCE(118);
      END_STATE();
    case 81:
      if (lookahead == 'u') ADVANCE(119);
      END_STATE();
    case 82:
      ACCEPT_TOKEN(anon_sym_set);
      END_STATE();
    case 83:
      if (lookahead == 't') ADVANCE(120);
      END_STATE();
    case 84:
      if (lookahead == 'e') ADVANCE(121);
      END_STATE();
    case 85:
      if (lookahead == 't') ADVANCE(122);
      END_STATE();
    case 86:
      if (lookahead == 'g') ADVANCE(123);
      END_STATE();
    case 87:
      if (lookahead == 's') ADVANCE(124);
      END_STATE();
    case 88:
      if (lookahead == 'o') ADVANCE(125);
      END_STATE();
    case 89:
      if (lookahead == 'e') ADVANCE(126);
      END_STATE();
    case 90:
      ACCEPT_TOKEN(anon_sym_try);
      END_STATE();
    case 91:
      if (lookahead == 'e') ADVANCE(127);
      END_STATE();
    case 92:
      if (lookahead == 'e') ADVANCE(128);
      END_STATE();
    case 93:
      ACCEPT_TOKEN(anon_sym_var);
      END_STATE();
    case 94:
      if (lookahead == 'd') ADVANCE(129);
      END_STATE();
    case 95:
      if (lookahead == 'l') ADVANCE(130);
      END_STATE();
    case 96:
      if (lookahead == 'h') ADVANCE(131);
      END_STATE();
    case 97:
      if (lookahead == 'l') ADVANCE(132);
      END_STATE();
    case 98:
      if (lookahead == 'c') ADVANCE(133);
      END_STATE();
    case 99:
      if (lookahead == 't') ADVANCE(134);
      END_STATE();
    case 100:
      if (lookahead == 'k') ADVANCE(135);
      END_STATE();
    case 101:
      ACCEPT_TOKEN(anon_sym_case);
      END_STATE();
    case 102:
      if (lookahead == 'h') ADVANCE(136);
      END_STATE();
    case 103:
      if (lookahead == 's') ADVANCE(137);
      END_STATE();
    case 104:
      if (lookahead == 't') ADVANCE(138);
      END_STATE();
    case 105:
      if (lookahead == 'i') ADVANCE(139);
      END_STATE();
    case 106:
      if (lookahead == 'g') ADVANCE(140);
      END_STATE();
    case 107:
      if (lookahead == 'u') ADVANCE(141);
      END_STATE();
    case 108:
      if (lookahead == 't') ADVANCE(142);
      END_STATE();
    case 109:
      ACCEPT_TOKEN(anon_sym_else);
      END_STATE();
    case 110:
      if (lookahead == 'r') ADVANCE(143);
      END_STATE();
    case 111:
      if (lookahead == 'n') ADVANCE(144);
      END_STATE();
    case 112:
      if (lookahead == 'e') ADVANCE(145);
      END_STATE();
    case 113:
      if (lookahead == 'l') ADVANCE(146);
      END_STATE();
    case 114:
      ACCEPT_TOKEN(anon_sym_from);
      END_STATE();
    case 115:
      if (lookahead == 't') ADVANCE(147);
      END_STATE();
    case 116:
      if (lookahead == 'r') ADVANCE(148);
      END_STATE();
    case 117:
      if (lookahead == 'a') ADVANCE(149);
      END_STATE();
    case 118:
      ACCEPT_TOKEN(sym_null);
      END_STATE();
    case 119:
      if (lookahead == 'r') ADVANCE(150);
      END_STATE();
    case 120:
      if (lookahead == 'i') ADVANCE(151);
      END_STATE();
    case 121:
      if (lookahead == 'r') ADVANCE(152);
      END_STATE();
    case 122:
      if (lookahead == 'c') ADVANCE(153);
      END_STATE();
    case 123:
      if (lookahead == 'e') ADVANCE(154);
      END_STATE();
    case 124:
      ACCEPT_TOKEN(sym_this);
      END_STATE();
    case 125:
      if (lookahead == 'w') ADVANCE(155);
      END_STATE();
    case 126:
      ACCEPT_TOKEN(sym_true);
      END_STATE();
    case 127:
      if (lookahead == 'o') ADVANCE(156);
      END_STATE();
    case 128:
      if (lookahead == 'f') ADVANCE(157);
      END_STATE();
    case 129:
      ACCEPT_TOKEN(anon_sym_void);
      END_STATE();
    case 130:
      if (lookahead == 'e') ADVANCE(158);
      END_STATE();
    case 131:
      ACCEPT_TOKEN(anon_sym_with);
      END_STATE();
    case 132:
      if (lookahead == 'd') ADVANCE(159);
      END_STATE();
    case 133:
      ACCEPT_TOKEN(anon_sym_async);
      END_STATE();
    case 134:
      ACCEPT_TOKEN(anon_sym_await);
      END_STATE();
    case 135:
      ACCEPT_TOKEN(anon_sym_break);
      END_STATE();
    case 136:
      ACCEPT_TOKEN(anon_sym_catch);
      END_STATE();
    case 137:
      ACCEPT_TOKEN(anon_sym_class);
      END_STATE();
    case 138:
      ACCEPT_TOKEN(anon_sym_const);
      END_STATE();
    case 139:
      if (lookahead == 'n') ADVANCE(160);
      END_STATE();
    case 140:
      if (lookahead == 'g') ADVANCE(161);
      END_STATE();
    case 141:
      if (lookahead == 'l') ADVANCE(162);
      END_STATE();
    case 142:
      if (lookahead == 'e') ADVANCE(163);
      END_STATE();
    case 143:
      if (lookahead == 't') ADVANCE(164);
      END_STATE();
    case 144:
      if (lookahead == 'd') ADVANCE(165);
      END_STATE();
    case 145:
      ACCEPT_TOKEN(sym_false);
      END_STATE();
    case 146:
      if (lookahead == 'l') ADVANCE(166);
      END_STATE();
    case 147:
      if (lookahead == 'i') ADVANCE(167);
      END_STATE();
    case 148:
      if (lookahead == 't') ADVANCE(168);
      END_STATE();
    case 149:
      if (lookahead == 'n') ADVANCE(169);
      END_STATE();
    case 150:
      if (lookahead == 'n') ADVANCE(170);
      END_STATE();
    case 151:
      if (lookahead == 'c') ADVANCE(171);
      END_STATE();
    case 152:
      ACCEPT_TOKEN(sym_super);
      END_STATE();
    case 153:
      if (lookahead == 'h') ADVANCE(172);
      END_STATE();
    case 154:
      if (lookahead == 't') ADVANCE(173);
      END_STATE();
    case 155:
      ACCEPT_TOKEN(anon_sym_throw);
      END_STATE();
    case 156:
      if (lookahead == 'f') ADVANCE(174);
      END_STATE();
    case 157:
      if (lookahead == 'i') ADVANCE(175);
      END_STATE();
    case 158:
      ACCEPT_TOKEN(anon_sym_while);
      END_STATE();
    case 159:
      ACCEPT_TOKEN(anon_sym_yield);
      END_STATE();
    case 160:
      if (lookahead == 'u') ADVANCE(176);
      END_STATE();
    case 161:
      if (lookahead == 'e') ADVANCE(177);
      END_STATE();
    case 162:
      if (lookahead == 't') ADVANCE(178);
      END_STATE();
    case 163:
      ACCEPT_TOKEN(anon_sym_delete);
      END_STATE();
    case 164:
      ACCEPT_TOKEN(anon_sym_export);
      END_STATE();
    case 165:
      if (lookahead == 's') ADVANCE(179);
      END_STATE();
    case 166:
      if (lookahead == 'y') ADVANCE(180);
      END_STATE();
    case 167:
      if (lookahead == 'o') ADVANCE(181);
      END_STATE();
    case 168:
      ACCEPT_TOKEN(anon_sym_import);
      END_STATE();
    case 169:
      if (lookahead == 'c') ADVANCE(182);
      END_STATE();
    case 170:
      ACCEPT_TOKEN(anon_sym_return);
      END_STATE();
    case 171:
      ACCEPT_TOKEN(anon_sym_static);
      END_STATE();
    case 172:
      ACCEPT_TOKEN(anon_sym_switch);
      END_STATE();
    case 173:
      ACCEPT_TOKEN(anon_sym_target);
      END_STATE();
    case 174:
      ACCEPT_TOKEN(anon_sym_typeof);
      END_STATE();
    case 175:
      if (lookahead == 'n') ADVANCE(183);
      END_STATE();
    case 176:
      if (lookahead == 'e') ADVANCE(184);
      END_STATE();
    case 177:
      if (lookahead == 'r') ADVANCE(185);
      END_STATE();
    case 178:
      ACCEPT_TOKEN(anon_sym_default);
      END_STATE();
    case 179:
      ACCEPT_TOKEN(anon_sym_extends);
      END_STATE();
    case 180:
      ACCEPT_TOKEN(anon_sym_finally);
      END_STATE();
    case 181:
      if (lookahead == 'n') ADVANCE(186);
      END_STATE();
    case 182:
      if (lookahead == 'e') ADVANCE(187);
      END_STATE();
    case 183:
      if (lookahead == 'e') ADVANCE(188);
      END_STATE();
    case 184:
      ACCEPT_TOKEN(anon_sym_continue);
      END_STATE();
    case 185:
      ACCEPT_TOKEN(anon_sym_debugger);
      END_STATE();
    case 186:
      ACCEPT_TOKEN(anon_sym_function);
      END_STATE();
    case 187:
      if (lookahead == 'o') ADVANCE(189);
      END_STATE();
    case 188:
      if (lookahead == 'd') ADVANCE(190);
      END_STATE();
    case 189:
      if (lookahead == 'f') ADVANCE(191);
      END_STATE();
    case 190:
      ACCEPT_TOKEN(sym_undefined);
      END_STATE();
    case 191:
      ACCEPT_TOKEN(anon_sym_instanceof);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0, .external_lex_state = 1},
  [1] = {.lex_state = 66},
  [2] = {.lex_state = 66},
  [3] = {.lex_state = 66},
  [4] = {.lex_state = 66},
  [5] = {.lex_state = 66},
  [6] = {.lex_state = 66},
  [7] = {.lex_state = 66},
  [8] = {.lex_state = 66},
  [9] = {.lex_state = 66},
  [10] = {.lex_state = 66},
  [11] = {.lex_state = 66},
  [12] = {.lex_state = 66},
  [13] = {.lex_state = 66},
  [14] = {.lex_state = 66},
  [15] = {.lex_state = 66},
  [16] = {.lex_state = 66},
  [17] = {.lex_state = 66},
  [18] = {.lex_state = 66},
  [19] = {.lex_state = 66},
  [20] = {.lex_state = 66},
  [21] = {.lex_state = 66},
  [22] = {.lex_state = 66},
  [23] = {.lex_state = 66},
  [24] = {.lex_state = 66},
  [25] = {.lex_state = 66},
  [26] = {.lex_state = 66},
  [27] = {.lex_state = 66},
  [28] = {.lex_state = 66},
  [29] = {.lex_state = 66},
  [30] = {.lex_state = 66},
  [31] = {.lex_state = 66},
  [32] = {.lex_state = 66},
  [33] = {.lex_state = 66},
  [34] = {.lex_state = 66},
  [35] = {.lex_state = 66},
  [36] = {.lex_state = 66},
  [37] = {.lex_state = 66},
  [38] = {.lex_state = 66},
  [39] = {.lex_state = 66},
  [40] = {.lex_state = 66},
  [41] = {.lex_state = 66},
  [42] = {.lex_state = 65, .external_lex_state = 2},
  [43] = {.lex_state = 65, .external_lex_state = 3},
  [44] = {.lex_state = 65, .external_lex_state = 3},
  [45] = {.lex_state = 65, .external_lex_state = 2},
  [46] = {.lex_state = 65, .external_lex_state = 2},
  [47] = {.lex_state = 65, .external_lex_state = 3},
  [48] = {.lex_state = 65, .external_lex_state = 3},
  [49] = {.lex_state = 65, .external_lex_state = 3},
  [50] = {.lex_state = 65, .external_lex_state = 3},
  [51] = {.lex_state = 65, .external_lex_state = 3},
  [52] = {.lex_state = 65, .external_lex_state = 3},
  [53] = {.lex_state = 65, .external_lex_state = 3},
  [54] = {.lex_state = 65, .external_lex_state = 3},
  [55] = {.lex_state = 65, .external_lex_state = 3},
  [56] = {.lex_state = 65, .external_lex_state = 3},
  [57] = {.lex_state = 65, .external_lex_state = 3},
  [58] = {.lex_state = 65, .external_lex_state = 3},
  [59] = {.lex_state = 65, .external_lex_state = 3},
  [60] = {.lex_state = 65, .external_lex_state = 3},
  [61] = {.lex_state = 65, .external_lex_state = 3},
  [62] = {.lex_state = 66},
  [63] = {.lex_state = 66},
  [64] = {.lex_state = 66},
  [65] = {.lex_state = 66},
  [66] = {.lex_state = 66},
  [67] = {.lex_state = 66},
  [68] = {.lex_state = 66},
  [69] = {.lex_state = 66},
  [70] = {.lex_state = 66},
  [71] = {.lex_state = 66},
  [72] = {.lex_state = 66},
  [73] = {.lex_state = 66},
  [74] = {.lex_state = 66},
  [75] = {.lex_state = 66},
  [76] = {.lex_state = 66},
  [77] = {.lex_state = 66},
  [78] = {.lex_state = 66},
  [79] = {.lex_state = 66},
  [80] = {.lex_state = 66},
  [81] = {.lex_state = 66},
  [82] = {.lex_state = 66},
  [83] = {.lex_state = 66},
  [84] = {.lex_state = 66},
  [85] = {.lex_state = 66},
  [86] = {.lex_state = 66},
  [87] = {.lex_state = 66},
  [88] = {.lex_state = 66},
  [89] = {.lex_state = 66},
  [90] = {.lex_state = 66},
  [91] = {.lex_state = 66},
  [92] = {.lex_state = 66},
  [93] = {.lex_state = 66},
  [94] = {.lex_state = 66},
  [95] = {.lex_state = 66},
  [96] = {.lex_state = 66},
  [97] = {.lex_state = 66},
  [98] = {.lex_state = 66, .external_lex_state = 4},
  [99] = {.lex_state = 4, .external_lex_state = 3},
  [100] = {.lex_state = 66},
  [101] = {.lex_state = 4, .external_lex_state = 3},
  [102] = {.lex_state = 4, .external_lex_state = 3},
  [103] = {.lex_state = 66},
  [104] = {.lex_state = 66},
  [105] = {.lex_state = 66},
  [106] = {.lex_state = 66},
  [107] = {.lex_state = 66},
  [108] = {.lex_state = 66},
  [109] = {.lex_state = 66},
  [110] = {.lex_state = 66},
  [111] = {.lex_state = 66},
  [112] = {.lex_state = 3},
  [113] = {.lex_state = 66},
  [114] = {.lex_state = 66},
  [115] = {.lex_state = 66},
  [116] = {.lex_state = 66},
  [117] = {.lex_state = 66},
  [118] = {.lex_state = 66},
  [119] = {.lex_state = 66},
  [120] = {.lex_state = 66},
  [121] = {.lex_state = 66},
  [122] = {.lex_state = 66},
  [123] = {.lex_state = 66},
  [124] = {.lex_state = 66},
  [125] = {.lex_state = 3},
  [126] = {.lex_state = 66},
  [127] = {.lex_state = 66},
  [128] = {.lex_state = 66},
  [129] = {.lex_state = 66},
  [130] = {.lex_state = 66},
  [131] = {.lex_state = 66},
  [132] = {.lex_state = 66},
  [133] = {.lex_state = 66},
  [134] = {.lex_state = 66},
  [135] = {.lex_state = 66},
  [136] = {.lex_state = 66},
  [137] = {.lex_state = 66},
  [138] = {.lex_state = 66},
  [139] = {.lex_state = 3},
  [140] = {.lex_state = 3},
  [141] = {.lex_state = 66},
  [142] = {.lex_state = 66},
  [143] = {.lex_state = 66},
  [144] = {.lex_state = 66},
  [145] = {.lex_state = 66},
  [146] = {.lex_state = 66},
  [147] = {.lex_state = 66},
  [148] = {.lex_state = 66},
  [149] = {.lex_state = 66},
  [150] = {.lex_state = 66},
  [151] = {.lex_state = 66},
  [152] = {.lex_state = 66},
  [153] = {.lex_state = 66},
  [154] = {.lex_state = 3},
  [155] = {.lex_state = 66},
  [156] = {.lex_state = 66},
  [157] = {.lex_state = 66},
  [158] = {.lex_state = 66},
  [159] = {.lex_state = 66},
  [160] = {.lex_state = 66},
  [161] = {.lex_state = 66},
  [162] = {.lex_state = 66},
  [163] = {.lex_state = 66},
  [164] = {.lex_state = 66},
  [165] = {.lex_state = 66},
  [166] = {.lex_state = 66},
  [167] = {.lex_state = 66},
  [168] = {.lex_state = 66},
  [169] = {.lex_state = 66},
  [170] = {.lex_state = 66},
  [171] = {.lex_state = 66},
  [172] = {.lex_state = 66},
  [173] = {.lex_state = 66},
  [174] = {.lex_state = 66},
  [175] = {.lex_state = 66},
  [176] = {.lex_state = 66},
  [177] = {.lex_state = 66},
  [178] = {.lex_state = 66},
  [179] = {.lex_state = 66},
  [180] = {.lex_state = 66},
  [181] = {.lex_state = 66},
  [182] = {.lex_state = 66},
  [183] = {.lex_state = 66},
  [184] = {.lex_state = 66},
  [185] = {.lex_state = 66},
  [186] = {.lex_state = 66},
  [187] = {.lex_state = 66},
  [188] = {.lex_state = 66},
  [189] = {.lex_state = 66},
  [190] = {.lex_state = 66},
  [191] = {.lex_state = 66},
  [192] = {.lex_state = 66},
  [193] = {.lex_state = 66},
  [194] = {.lex_state = 66},
  [195] = {.lex_state = 66},
  [196] = {.lex_state = 66},
  [197] = {.lex_state = 66},
  [198] = {.lex_state = 66},
  [199] = {.lex_state = 66},
  [200] = {.lex_state = 66},
  [201] = {.lex_state = 66},
  [202] = {.lex_state = 66},
  [203] = {.lex_state = 66},
  [204] = {.lex_state = 66},
  [205] = {.lex_state = 66},
  [206] = {.lex_state = 66},
  [207] = {.lex_state = 66},
  [208] = {.lex_state = 66},
  [209] = {.lex_state = 66},
  [210] = {.lex_state = 66},
  [211] = {.lex_state = 66},
  [212] = {.lex_state = 66},
  [213] = {.lex_state = 66},
  [214] = {.lex_state = 66},
  [215] = {.lex_state = 66},
  [216] = {.lex_state = 66},
  [217] = {.lex_state = 66},
  [218] = {.lex_state = 66},
  [219] = {.lex_state = 66},
  [220] = {.lex_state = 66},
  [221] = {.lex_state = 66},
  [222] = {.lex_state = 66},
  [223] = {.lex_state = 66},
  [224] = {.lex_state = 66},
  [225] = {.lex_state = 66},
  [226] = {.lex_state = 66},
  [227] = {.lex_state = 66},
  [228] = {.lex_state = 66},
  [229] = {.lex_state = 66},
  [230] = {.lex_state = 66},
  [231] = {.lex_state = 66},
  [232] = {.lex_state = 66},
  [233] = {.lex_state = 66},
  [234] = {.lex_state = 66},
  [235] = {.lex_state = 66},
  [236] = {.lex_state = 66},
  [237] = {.lex_state = 66},
  [238] = {.lex_state = 66},
  [239] = {.lex_state = 66},
  [240] = {.lex_state = 66},
  [241] = {.lex_state = 66},
  [242] = {.lex_state = 66},
  [243] = {.lex_state = 66},
  [244] = {.lex_state = 66},
  [245] = {.lex_state = 66},
  [246] = {.lex_state = 66},
  [247] = {.lex_state = 66},
  [248] = {.lex_state = 66},
  [249] = {.lex_state = 66},
  [250] = {.lex_state = 66},
  [251] = {.lex_state = 66},
  [252] = {.lex_state = 66},
  [253] = {.lex_state = 66},
  [254] = {.lex_state = 66},
  [255] = {.lex_state = 66},
  [256] = {.lex_state = 66},
  [257] = {.lex_state = 66},
  [258] = {.lex_state = 66},
  [259] = {.lex_state = 66},
  [260] = {.lex_state = 66},
  [261] = {.lex_state = 66},
  [262] = {.lex_state = 66},
  [263] = {.lex_state = 66},
  [264] = {.lex_state = 66},
  [265] = {.lex_state = 66},
  [266] = {.lex_state = 66},
  [267] = {.lex_state = 66},
  [268] = {.lex_state = 66},
  [269] = {.lex_state = 66},
  [270] = {.lex_state = 66},
  [271] = {.lex_state = 66},
  [272] = {.lex_state = 66},
  [273] = {.lex_state = 66},
  [274] = {.lex_state = 66},
  [275] = {.lex_state = 66},
  [276] = {.lex_state = 4, .external_lex_state = 3},
  [277] = {.lex_state = 4, .external_lex_state = 3},
  [278] = {.lex_state = 4, .external_lex_state = 3},
  [279] = {.lex_state = 4, .external_lex_state = 3},
  [280] = {.lex_state = 4, .external_lex_state = 3},
  [281] = {.lex_state = 4, .external_lex_state = 3},
  [282] = {.lex_state = 4, .external_lex_state = 3},
  [283] = {.lex_state = 4, .external_lex_state = 3},
  [284] = {.lex_state = 4, .external_lex_state = 3},
  [285] = {.lex_state = 4, .external_lex_state = 3},
  [286] = {.lex_state = 4, .external_lex_state = 3},
  [287] = {.lex_state = 66, .external_lex_state = 4},
  [288] = {.lex_state = 66, .external_lex_state = 4},
  [289] = {.lex_state = 4, .external_lex_state = 2},
  [290] = {.lex_state = 66},
  [291] = {.lex_state = 66},
  [292] = {.lex_state = 4, .external_lex_state = 2},
  [293] = {.lex_state = 4, .external_lex_state = 3},
  [294] = {.lex_state = 4, .external_lex_state = 3},
  [295] = {.lex_state = 4, .external_lex_state = 2},
  [296] = {.lex_state = 66},
  [297] = {.lex_state = 4, .external_lex_state = 3},
  [298] = {.lex_state = 4, .external_lex_state = 2},
  [299] = {.lex_state = 4, .external_lex_state = 3},
  [300] = {.lex_state = 4, .external_lex_state = 3},
  [301] = {.lex_state = 4, .external_lex_state = 3},
  [302] = {.lex_state = 4, .external_lex_state = 2},
  [303] = {.lex_state = 4, .external_lex_state = 3},
  [304] = {.lex_state = 4, .external_lex_state = 2},
  [305] = {.lex_state = 4, .external_lex_state = 3},
  [306] = {.lex_state = 66},
  [307] = {.lex_state = 4, .external_lex_state = 2},
  [308] = {.lex_state = 4, .external_lex_state = 3},
  [309] = {.lex_state = 4, .external_lex_state = 2},
  [310] = {.lex_state = 66, .external_lex_state = 4},
  [311] = {.lex_state = 66, .external_lex_state = 4},
  [312] = {.lex_state = 66},
  [313] = {.lex_state = 66},
  [314] = {.lex_state = 66},
  [315] = {.lex_state = 66, .external_lex_state = 4},
  [316] = {.lex_state = 66},
  [317] = {.lex_state = 66, .external_lex_state = 4},
  [318] = {.lex_state = 4, .external_lex_state = 2},
  [319] = {.lex_state = 66, .external_lex_state = 4},
  [320] = {.lex_state = 66, .external_lex_state = 4},
  [321] = {.lex_state = 66, .external_lex_state = 4},
  [322] = {.lex_state = 66, .external_lex_state = 4},
  [323] = {.lex_state = 66, .external_lex_state = 4},
  [324] = {.lex_state = 66, .external_lex_state = 4},
  [325] = {.lex_state = 66},
  [326] = {.lex_state = 66, .external_lex_state = 4},
  [327] = {.lex_state = 4, .external_lex_state = 2},
  [328] = {.lex_state = 4, .external_lex_state = 2},
  [329] = {.lex_state = 66, .external_lex_state = 4},
  [330] = {.lex_state = 66, .external_lex_state = 4},
  [331] = {.lex_state = 66, .external_lex_state = 4},
  [332] = {.lex_state = 66},
  [333] = {.lex_state = 66},
  [334] = {.lex_state = 66},
  [335] = {.lex_state = 66},
  [336] = {.lex_state = 66},
  [337] = {.lex_state = 66},
  [338] = {.lex_state = 66},
  [339] = {.lex_state = 66},
  [340] = {.lex_state = 66},
  [341] = {.lex_state = 66},
  [342] = {.lex_state = 66},
  [343] = {.lex_state = 66},
  [344] = {.lex_state = 66},
  [345] = {.lex_state = 66},
  [346] = {.lex_state = 66},
  [347] = {.lex_state = 66},
  [348] = {.lex_state = 66},
  [349] = {.lex_state = 66},
  [350] = {.lex_state = 66},
  [351] = {.lex_state = 66},
  [352] = {.lex_state = 66},
  [353] = {.lex_state = 66},
  [354] = {.lex_state = 66},
  [355] = {.lex_state = 66},
  [356] = {.lex_state = 66},
  [357] = {.lex_state = 66},
  [358] = {.lex_state = 66},
  [359] = {.lex_state = 66},
  [360] = {.lex_state = 66},
  [361] = {.lex_state = 66},
  [362] = {.lex_state = 66},
  [363] = {.lex_state = 66},
  [364] = {.lex_state = 66},
  [365] = {.lex_state = 66},
  [366] = {.lex_state = 66},
  [367] = {.lex_state = 66},
  [368] = {.lex_state = 66},
  [369] = {.lex_state = 66},
  [370] = {.lex_state = 66},
  [371] = {.lex_state = 66},
  [372] = {.lex_state = 66},
  [373] = {.lex_state = 66},
  [374] = {.lex_state = 66},
  [375] = {.lex_state = 66},
  [376] = {.lex_state = 66},
  [377] = {.lex_state = 66},
  [378] = {.lex_state = 66},
  [379] = {.lex_state = 66},
  [380] = {.lex_state = 66},
  [381] = {.lex_state = 66},
  [382] = {.lex_state = 66},
  [383] = {.lex_state = 66},
  [384] = {.lex_state = 66},
  [385] = {.lex_state = 66},
  [386] = {.lex_state = 66},
  [387] = {.lex_state = 66},
  [388] = {.lex_state = 66},
  [389] = {.lex_state = 66},
  [390] = {.lex_state = 66},
  [391] = {.lex_state = 66},
  [392] = {.lex_state = 66},
  [393] = {.lex_state = 66},
  [394] = {.lex_state = 66},
  [395] = {.lex_state = 66},
  [396] = {.lex_state = 66},
  [397] = {.lex_state = 66},
  [398] = {.lex_state = 66},
  [399] = {.lex_state = 66},
  [400] = {.lex_state = 66},
  [401] = {.lex_state = 66},
  [402] = {.lex_state = 66},
  [403] = {.lex_state = 66},
  [404] = {.lex_state = 66},
  [405] = {.lex_state = 66},
  [406] = {.lex_state = 66},
  [407] = {.lex_state = 66},
  [408] = {.lex_state = 66},
  [409] = {.lex_state = 66},
  [410] = {.lex_state = 66},
  [411] = {.lex_state = 66},
  [412] = {.lex_state = 66},
  [413] = {.lex_state = 66},
  [414] = {.lex_state = 66},
  [415] = {.lex_state = 66},
  [416] = {.lex_state = 66},
  [417] = {.lex_state = 66},
  [418] = {.lex_state = 66},
  [419] = {.lex_state = 66},
  [420] = {.lex_state = 66},
  [421] = {.lex_state = 66},
  [422] = {.lex_state = 66},
  [423] = {.lex_state = 66},
  [424] = {.lex_state = 4, .external_lex_state = 3},
  [425] = {.lex_state = 4, .external_lex_state = 3},
  [426] = {.lex_state = 4, .external_lex_state = 3},
  [427] = {.lex_state = 4, .external_lex_state = 2},
  [428] = {.lex_state = 4, .external_lex_state = 2},
  [429] = {.lex_state = 4, .external_lex_state = 2},
  [430] = {.lex_state = 4, .external_lex_state = 2},
  [431] = {.lex_state = 4, .external_lex_state = 2},
  [432] = {.lex_state = 4, .external_lex_state = 2},
  [433] = {.lex_state = 4, .external_lex_state = 2},
  [434] = {.lex_state = 4, .external_lex_state = 2},
  [435] = {.lex_state = 4, .external_lex_state = 2},
  [436] = {.lex_state = 4, .external_lex_state = 2},
  [437] = {.lex_state = 4, .external_lex_state = 2},
  [438] = {.lex_state = 4, .external_lex_state = 3},
  [439] = {.lex_state = 4, .external_lex_state = 3},
  [440] = {.lex_state = 4, .external_lex_state = 3},
  [441] = {.lex_state = 4, .external_lex_state = 3},
  [442] = {.lex_state = 4, .external_lex_state = 3},
  [443] = {.lex_state = 4, .external_lex_state = 3},
  [444] = {.lex_state = 4, .external_lex_state = 2},
  [445] = {.lex_state = 4, .external_lex_state = 3},
  [446] = {.lex_state = 4, .external_lex_state = 3},
  [447] = {.lex_state = 4, .external_lex_state = 3},
  [448] = {.lex_state = 4, .external_lex_state = 3},
  [449] = {.lex_state = 4, .external_lex_state = 2},
  [450] = {.lex_state = 4, .external_lex_state = 3},
  [451] = {.lex_state = 4, .external_lex_state = 3},
  [452] = {.lex_state = 4, .external_lex_state = 3},
  [453] = {.lex_state = 4, .external_lex_state = 3},
  [454] = {.lex_state = 4, .external_lex_state = 2},
  [455] = {.lex_state = 4, .external_lex_state = 2},
  [456] = {.lex_state = 4, .external_lex_state = 3},
  [457] = {.lex_state = 4, .external_lex_state = 2},
  [458] = {.lex_state = 4, .external_lex_state = 2},
  [459] = {.lex_state = 4, .external_lex_state = 3},
  [460] = {.lex_state = 4, .external_lex_state = 3},
  [461] = {.lex_state = 4, .external_lex_state = 3},
  [462] = {.lex_state = 4, .external_lex_state = 3},
  [463] = {.lex_state = 4, .external_lex_state = 3},
  [464] = {.lex_state = 66},
  [465] = {.lex_state = 4, .external_lex_state = 2},
  [466] = {.lex_state = 4, .external_lex_state = 3},
  [467] = {.lex_state = 66},
  [468] = {.lex_state = 4, .external_lex_state = 2},
  [469] = {.lex_state = 4, .external_lex_state = 2},
  [470] = {.lex_state = 66},
  [471] = {.lex_state = 66},
  [472] = {.lex_state = 4, .external_lex_state = 3},
  [473] = {.lex_state = 4, .external_lex_state = 2},
  [474] = {.lex_state = 4, .external_lex_state = 2},
  [475] = {.lex_state = 66},
  [476] = {.lex_state = 66},
  [477] = {.lex_state = 66},
  [478] = {.lex_state = 66},
  [479] = {.lex_state = 4, .external_lex_state = 3},
  [480] = {.lex_state = 4, .external_lex_state = 2},
  [481] = {.lex_state = 4, .external_lex_state = 2},
  [482] = {.lex_state = 4, .external_lex_state = 2},
  [483] = {.lex_state = 4, .external_lex_state = 2},
  [484] = {.lex_state = 4, .external_lex_state = 2},
  [485] = {.lex_state = 4, .external_lex_state = 2},
  [486] = {.lex_state = 4, .external_lex_state = 2},
  [487] = {.lex_state = 4, .external_lex_state = 2},
  [488] = {.lex_state = 4, .external_lex_state = 2},
  [489] = {.lex_state = 4, .external_lex_state = 2},
  [490] = {.lex_state = 4, .external_lex_state = 2},
  [491] = {.lex_state = 4, .external_lex_state = 2},
  [492] = {.lex_state = 4, .external_lex_state = 2},
  [493] = {.lex_state = 4, .external_lex_state = 2},
  [494] = {.lex_state = 65, .external_lex_state = 3},
  [495] = {.lex_state = 65, .external_lex_state = 2},
  [496] = {.lex_state = 65, .external_lex_state = 2},
  [497] = {.lex_state = 65, .external_lex_state = 3},
  [498] = {.lex_state = 65, .external_lex_state = 2},
  [499] = {.lex_state = 65, .external_lex_state = 2},
  [500] = {.lex_state = 65, .external_lex_state = 2},
  [501] = {.lex_state = 65, .external_lex_state = 2},
  [502] = {.lex_state = 65, .external_lex_state = 2},
  [503] = {.lex_state = 65, .external_lex_state = 2},
  [504] = {.lex_state = 65, .external_lex_state = 2},
  [505] = {.lex_state = 65, .external_lex_state = 3},
  [506] = {.lex_state = 65, .external_lex_state = 2},
  [507] = {.lex_state = 65, .external_lex_state = 3},
  [508] = {.lex_state = 65, .external_lex_state = 2},
  [509] = {.lex_state = 65, .external_lex_state = 2},
  [510] = {.lex_state = 65, .external_lex_state = 2},
  [511] = {.lex_state = 65, .external_lex_state = 2},
  [512] = {.lex_state = 65, .external_lex_state = 2},
  [513] = {.lex_state = 65, .external_lex_state = 2},
  [514] = {.lex_state = 65, .external_lex_state = 2},
  [515] = {.lex_state = 65, .external_lex_state = 2},
  [516] = {.lex_state = 65, .external_lex_state = 2},
  [517] = {.lex_state = 65, .external_lex_state = 2},
  [518] = {.lex_state = 65, .external_lex_state = 2},
  [519] = {.lex_state = 65, .external_lex_state = 2},
  [520] = {.lex_state = 65, .external_lex_state = 2},
  [521] = {.lex_state = 65, .external_lex_state = 2},
  [522] = {.lex_state = 65, .external_lex_state = 2},
  [523] = {.lex_state = 65, .external_lex_state = 2},
  [524] = {.lex_state = 65, .external_lex_state = 2},
  [525] = {.lex_state = 65, .external_lex_state = 2},
  [526] = {.lex_state = 65, .external_lex_state = 2},
  [527] = {.lex_state = 65, .external_lex_state = 2},
  [528] = {.lex_state = 65, .external_lex_state = 2},
  [529] = {.lex_state = 65, .external_lex_state = 2},
  [530] = {.lex_state = 65, .external_lex_state = 2},
  [531] = {.lex_state = 65, .external_lex_state = 2},
  [532] = {.lex_state = 65, .external_lex_state = 2},
  [533] = {.lex_state = 65, .external_lex_state = 2},
  [534] = {.lex_state = 65, .external_lex_state = 2},
  [535] = {.lex_state = 65, .external_lex_state = 2},
  [536] = {.lex_state = 65, .external_lex_state = 2},
  [537] = {.lex_state = 65, .external_lex_state = 2},
  [538] = {.lex_state = 65, .external_lex_state = 2},
  [539] = {.lex_state = 65, .external_lex_state = 2},
  [540] = {.lex_state = 65, .external_lex_state = 2},
  [541] = {.lex_state = 65, .external_lex_state = 2},
  [542] = {.lex_state = 65, .external_lex_state = 2},
  [543] = {.lex_state = 65, .external_lex_state = 2},
  [544] = {.lex_state = 65, .external_lex_state = 2},
  [545] = {.lex_state = 65, .external_lex_state = 2},
  [546] = {.lex_state = 65, .external_lex_state = 2},
  [547] = {.lex_state = 65, .external_lex_state = 2},
  [548] = {.lex_state = 65, .external_lex_state = 2},
  [549] = {.lex_state = 65, .external_lex_state = 2},
  [550] = {.lex_state = 65, .external_lex_state = 2},
  [551] = {.lex_state = 65, .external_lex_state = 2},
  [552] = {.lex_state = 65, .external_lex_state = 2},
  [553] = {.lex_state = 65, .external_lex_state = 2},
  [554] = {.lex_state = 65, .external_lex_state = 2},
  [555] = {.lex_state = 65, .external_lex_state = 2},
  [556] = {.lex_state = 65, .external_lex_state = 2},
  [557] = {.lex_state = 65, .external_lex_state = 2},
  [558] = {.lex_state = 65, .external_lex_state = 2},
  [559] = {.lex_state = 65, .external_lex_state = 2},
  [560] = {.lex_state = 65, .external_lex_state = 2},
  [561] = {.lex_state = 65, .external_lex_state = 2},
  [562] = {.lex_state = 5, .external_lex_state = 2},
  [563] = {.lex_state = 65, .external_lex_state = 2},
  [564] = {.lex_state = 65, .external_lex_state = 2},
  [565] = {.lex_state = 65, .external_lex_state = 2},
  [566] = {.lex_state = 65, .external_lex_state = 2},
  [567] = {.lex_state = 65, .external_lex_state = 2},
  [568] = {.lex_state = 65, .external_lex_state = 2},
  [569] = {.lex_state = 65, .external_lex_state = 2},
  [570] = {.lex_state = 65, .external_lex_state = 3},
  [571] = {.lex_state = 65, .external_lex_state = 2},
  [572] = {.lex_state = 65, .external_lex_state = 3},
  [573] = {.lex_state = 65, .external_lex_state = 2},
  [574] = {.lex_state = 65, .external_lex_state = 3},
  [575] = {.lex_state = 65, .external_lex_state = 2},
  [576] = {.lex_state = 65, .external_lex_state = 2},
  [577] = {.lex_state = 65, .external_lex_state = 2},
  [578] = {.lex_state = 65, .external_lex_state = 2},
  [579] = {.lex_state = 65, .external_lex_state = 2},
  [580] = {.lex_state = 65, .external_lex_state = 2},
  [581] = {.lex_state = 65, .external_lex_state = 2},
  [582] = {.lex_state = 65, .external_lex_state = 2},
  [583] = {.lex_state = 65, .external_lex_state = 2},
  [584] = {.lex_state = 65, .external_lex_state = 2},
  [585] = {.lex_state = 65, .external_lex_state = 2},
  [586] = {.lex_state = 65, .external_lex_state = 2},
  [587] = {.lex_state = 65, .external_lex_state = 2},
  [588] = {.lex_state = 65, .external_lex_state = 2},
  [589] = {.lex_state = 65, .external_lex_state = 2},
  [590] = {.lex_state = 65, .external_lex_state = 2},
  [591] = {.lex_state = 65, .external_lex_state = 2},
  [592] = {.lex_state = 65, .external_lex_state = 3},
  [593] = {.lex_state = 65, .external_lex_state = 2},
  [594] = {.lex_state = 65, .external_lex_state = 2},
  [595] = {.lex_state = 65, .external_lex_state = 3},
  [596] = {.lex_state = 65, .external_lex_state = 2},
  [597] = {.lex_state = 65, .external_lex_state = 3},
  [598] = {.lex_state = 65, .external_lex_state = 3},
  [599] = {.lex_state = 65, .external_lex_state = 3},
  [600] = {.lex_state = 65, .external_lex_state = 3},
  [601] = {.lex_state = 65, .external_lex_state = 3},
  [602] = {.lex_state = 65, .external_lex_state = 3},
  [603] = {.lex_state = 65, .external_lex_state = 3},
  [604] = {.lex_state = 65, .external_lex_state = 3},
  [605] = {.lex_state = 65, .external_lex_state = 3},
  [606] = {.lex_state = 65, .external_lex_state = 2},
  [607] = {.lex_state = 65, .external_lex_state = 3},
  [608] = {.lex_state = 65, .external_lex_state = 3},
  [609] = {.lex_state = 65, .external_lex_state = 3},
  [610] = {.lex_state = 65, .external_lex_state = 3},
  [611] = {.lex_state = 65, .external_lex_state = 3},
  [612] = {.lex_state = 65, .external_lex_state = 3},
  [613] = {.lex_state = 65, .external_lex_state = 3},
  [614] = {.lex_state = 65, .external_lex_state = 3},
  [615] = {.lex_state = 65, .external_lex_state = 3},
  [616] = {.lex_state = 65, .external_lex_state = 3},
  [617] = {.lex_state = 65, .external_lex_state = 3},
  [618] = {.lex_state = 65, .external_lex_state = 3},
  [619] = {.lex_state = 65, .external_lex_state = 3},
  [620] = {.lex_state = 65, .external_lex_state = 3},
  [621] = {.lex_state = 65, .external_lex_state = 3},
  [622] = {.lex_state = 65, .external_lex_state = 3},
  [623] = {.lex_state = 65, .external_lex_state = 3},
  [624] = {.lex_state = 65, .external_lex_state = 3},
  [625] = {.lex_state = 65, .external_lex_state = 3},
  [626] = {.lex_state = 65, .external_lex_state = 3},
  [627] = {.lex_state = 65, .external_lex_state = 3},
  [628] = {.lex_state = 65, .external_lex_state = 3},
  [629] = {.lex_state = 65, .external_lex_state = 3},
  [630] = {.lex_state = 65, .external_lex_state = 3},
  [631] = {.lex_state = 65, .external_lex_state = 3},
  [632] = {.lex_state = 65, .external_lex_state = 3},
  [633] = {.lex_state = 65, .external_lex_state = 3},
  [634] = {.lex_state = 65, .external_lex_state = 3},
  [635] = {.lex_state = 65, .external_lex_state = 3},
  [636] = {.lex_state = 65, .external_lex_state = 3},
  [637] = {.lex_state = 65, .external_lex_state = 3},
  [638] = {.lex_state = 65, .external_lex_state = 3},
  [639] = {.lex_state = 65, .external_lex_state = 3},
  [640] = {.lex_state = 65, .external_lex_state = 3},
  [641] = {.lex_state = 65, .external_lex_state = 3},
  [642] = {.lex_state = 65, .external_lex_state = 3},
  [643] = {.lex_state = 65, .external_lex_state = 3},
  [644] = {.lex_state = 65, .external_lex_state = 3},
  [645] = {.lex_state = 65, .external_lex_state = 3},
  [646] = {.lex_state = 65, .external_lex_state = 3},
  [647] = {.lex_state = 65, .external_lex_state = 3},
  [648] = {.lex_state = 65, .external_lex_state = 3},
  [649] = {.lex_state = 65, .external_lex_state = 3},
  [650] = {.lex_state = 65, .external_lex_state = 3},
  [651] = {.lex_state = 65, .external_lex_state = 3},
  [652] = {.lex_state = 65, .external_lex_state = 2},
  [653] = {.lex_state = 65, .external_lex_state = 2},
  [654] = {.lex_state = 65, .external_lex_state = 3},
  [655] = {.lex_state = 65, .external_lex_state = 3},
  [656] = {.lex_state = 65, .external_lex_state = 2},
  [657] = {.lex_state = 65, .external_lex_state = 3},
  [658] = {.lex_state = 65, .external_lex_state = 3},
  [659] = {.lex_state = 65, .external_lex_state = 2},
  [660] = {.lex_state = 65, .external_lex_state = 3},
  [661] = {.lex_state = 65, .external_lex_state = 3},
  [662] = {.lex_state = 65, .external_lex_state = 3},
  [663] = {.lex_state = 65, .external_lex_state = 2},
  [664] = {.lex_state = 65, .external_lex_state = 3},
  [665] = {.lex_state = 65, .external_lex_state = 3},
  [666] = {.lex_state = 65, .external_lex_state = 3},
  [667] = {.lex_state = 65, .external_lex_state = 2},
  [668] = {.lex_state = 65, .external_lex_state = 3},
  [669] = {.lex_state = 65, .external_lex_state = 3},
  [670] = {.lex_state = 65, .external_lex_state = 3},
  [671] = {.lex_state = 65, .external_lex_state = 3},
  [672] = {.lex_state = 65, .external_lex_state = 2},
  [673] = {.lex_state = 65, .external_lex_state = 3},
  [674] = {.lex_state = 65, .external_lex_state = 3},
  [675] = {.lex_state = 65, .external_lex_state = 2},
  [676] = {.lex_state = 65, .external_lex_state = 3},
  [677] = {.lex_state = 65, .external_lex_state = 3},
  [678] = {.lex_state = 65, .external_lex_state = 2},
  [679] = {.lex_state = 65, .external_lex_state = 3},
  [680] = {.lex_state = 65, .external_lex_state = 3},
  [681] = {.lex_state = 65, .external_lex_state = 3},
  [682] = {.lex_state = 65, .external_lex_state = 3},
  [683] = {.lex_state = 65, .external_lex_state = 3},
  [684] = {.lex_state = 65, .external_lex_state = 3},
  [685] = {.lex_state = 65, .external_lex_state = 3},
  [686] = {.lex_state = 65, .external_lex_state = 3},
  [687] = {.lex_state = 65, .external_lex_state = 3},
  [688] = {.lex_state = 65, .external_lex_state = 3},
  [689] = {.lex_state = 65, .external_lex_state = 3},
  [690] = {.lex_state = 65, .external_lex_state = 2},
  [691] = {.lex_state = 65, .external_lex_state = 3},
  [692] = {.lex_state = 65, .external_lex_state = 2},
  [693] = {.lex_state = 65, .external_lex_state = 3},
  [694] = {.lex_state = 65, .external_lex_state = 3},
  [695] = {.lex_state = 65, .external_lex_state = 3},
  [696] = {.lex_state = 65, .external_lex_state = 3},
  [697] = {.lex_state = 65, .external_lex_state = 3},
  [698] = {.lex_state = 65, .external_lex_state = 3},
  [699] = {.lex_state = 65, .external_lex_state = 3},
  [700] = {.lex_state = 65, .external_lex_state = 3},
  [701] = {.lex_state = 65, .external_lex_state = 3},
  [702] = {.lex_state = 65, .external_lex_state = 3},
  [703] = {.lex_state = 65, .external_lex_state = 3},
  [704] = {.lex_state = 65, .external_lex_state = 3},
  [705] = {.lex_state = 65, .external_lex_state = 2},
  [706] = {.lex_state = 65, .external_lex_state = 3},
  [707] = {.lex_state = 65, .external_lex_state = 3},
  [708] = {.lex_state = 65, .external_lex_state = 3},
  [709] = {.lex_state = 65, .external_lex_state = 3},
  [710] = {.lex_state = 65, .external_lex_state = 2},
  [711] = {.lex_state = 65, .external_lex_state = 3},
  [712] = {.lex_state = 65, .external_lex_state = 2},
  [713] = {.lex_state = 65, .external_lex_state = 2},
  [714] = {.lex_state = 65, .external_lex_state = 3},
  [715] = {.lex_state = 65, .external_lex_state = 2},
  [716] = {.lex_state = 65, .external_lex_state = 3},
  [717] = {.lex_state = 65, .external_lex_state = 3},
  [718] = {.lex_state = 65, .external_lex_state = 3},
  [719] = {.lex_state = 65, .external_lex_state = 3},
  [720] = {.lex_state = 65, .external_lex_state = 3},
  [721] = {.lex_state = 65, .external_lex_state = 3},
  [722] = {.lex_state = 65, .external_lex_state = 3},
  [723] = {.lex_state = 65, .external_lex_state = 3},
  [724] = {.lex_state = 65, .external_lex_state = 3},
  [725] = {.lex_state = 65, .external_lex_state = 3},
  [726] = {.lex_state = 65, .external_lex_state = 2},
  [727] = {.lex_state = 65, .external_lex_state = 3},
  [728] = {.lex_state = 65, .external_lex_state = 3},
  [729] = {.lex_state = 65, .external_lex_state = 3},
  [730] = {.lex_state = 65, .external_lex_state = 3},
  [731] = {.lex_state = 5, .external_lex_state = 3},
  [732] = {.lex_state = 65, .external_lex_state = 3},
  [733] = {.lex_state = 65, .external_lex_state = 3},
  [734] = {.lex_state = 65, .external_lex_state = 3},
  [735] = {.lex_state = 65, .external_lex_state = 3},
  [736] = {.lex_state = 65, .external_lex_state = 3},
  [737] = {.lex_state = 65, .external_lex_state = 3},
  [738] = {.lex_state = 65, .external_lex_state = 3},
  [739] = {.lex_state = 65, .external_lex_state = 3},
  [740] = {.lex_state = 65, .external_lex_state = 3},
  [741] = {.lex_state = 65, .external_lex_state = 3},
  [742] = {.lex_state = 65, .external_lex_state = 3},
  [743] = {.lex_state = 65, .external_lex_state = 3},
  [744] = {.lex_state = 65, .external_lex_state = 3},
  [745] = {.lex_state = 5, .external_lex_state = 3},
  [746] = {.lex_state = 65, .external_lex_state = 3},
  [747] = {.lex_state = 65, .external_lex_state = 2},
  [748] = {.lex_state = 65, .external_lex_state = 2},
  [749] = {.lex_state = 65, .external_lex_state = 2},
  [750] = {.lex_state = 65, .external_lex_state = 2},
  [751] = {.lex_state = 65, .external_lex_state = 2},
  [752] = {.lex_state = 65, .external_lex_state = 2},
  [753] = {.lex_state = 65, .external_lex_state = 2},
  [754] = {.lex_state = 65, .external_lex_state = 2},
  [755] = {.lex_state = 65, .external_lex_state = 2},
  [756] = {.lex_state = 65, .external_lex_state = 2},
  [757] = {.lex_state = 65, .external_lex_state = 2},
  [758] = {.lex_state = 65, .external_lex_state = 2},
  [759] = {.lex_state = 65, .external_lex_state = 2},
  [760] = {.lex_state = 65, .external_lex_state = 2},
  [761] = {.lex_state = 65, .external_lex_state = 2},
  [762] = {.lex_state = 65, .external_lex_state = 2},
  [763] = {.lex_state = 65, .external_lex_state = 2},
  [764] = {.lex_state = 65, .external_lex_state = 2},
  [765] = {.lex_state = 65, .external_lex_state = 2},
  [766] = {.lex_state = 65, .external_lex_state = 2},
  [767] = {.lex_state = 65, .external_lex_state = 2},
  [768] = {.lex_state = 65, .external_lex_state = 2},
  [769] = {.lex_state = 65, .external_lex_state = 3},
  [770] = {.lex_state = 65, .external_lex_state = 2},
  [771] = {.lex_state = 65, .external_lex_state = 2},
  [772] = {.lex_state = 65, .external_lex_state = 2},
  [773] = {.lex_state = 65, .external_lex_state = 2},
  [774] = {.lex_state = 65, .external_lex_state = 2},
  [775] = {.lex_state = 65, .external_lex_state = 2},
  [776] = {.lex_state = 65, .external_lex_state = 3},
  [777] = {.lex_state = 65, .external_lex_state = 2},
  [778] = {.lex_state = 65, .external_lex_state = 2},
  [779] = {.lex_state = 65, .external_lex_state = 2},
  [780] = {.lex_state = 65, .external_lex_state = 2},
  [781] = {.lex_state = 65, .external_lex_state = 2},
  [782] = {.lex_state = 65, .external_lex_state = 2},
  [783] = {.lex_state = 65, .external_lex_state = 2},
  [784] = {.lex_state = 65, .external_lex_state = 2},
  [785] = {.lex_state = 65, .external_lex_state = 2},
  [786] = {.lex_state = 65, .external_lex_state = 2},
  [787] = {.lex_state = 65, .external_lex_state = 2},
  [788] = {.lex_state = 65, .external_lex_state = 2},
  [789] = {.lex_state = 65, .external_lex_state = 2},
  [790] = {.lex_state = 65, .external_lex_state = 2},
  [791] = {.lex_state = 65, .external_lex_state = 2},
  [792] = {.lex_state = 65, .external_lex_state = 2},
  [793] = {.lex_state = 65, .external_lex_state = 2},
  [794] = {.lex_state = 65, .external_lex_state = 3},
  [795] = {.lex_state = 65, .external_lex_state = 2},
  [796] = {.lex_state = 65, .external_lex_state = 3},
  [797] = {.lex_state = 65, .external_lex_state = 2},
  [798] = {.lex_state = 65, .external_lex_state = 2},
  [799] = {.lex_state = 65, .external_lex_state = 2},
  [800] = {.lex_state = 65, .external_lex_state = 2},
  [801] = {.lex_state = 65, .external_lex_state = 2},
  [802] = {.lex_state = 65, .external_lex_state = 2},
  [803] = {.lex_state = 65, .external_lex_state = 2},
  [804] = {.lex_state = 65, .external_lex_state = 2},
  [805] = {.lex_state = 65, .external_lex_state = 2},
  [806] = {.lex_state = 65, .external_lex_state = 2},
  [807] = {.lex_state = 65, .external_lex_state = 2},
  [808] = {.lex_state = 65, .external_lex_state = 2},
  [809] = {.lex_state = 65, .external_lex_state = 2},
  [810] = {.lex_state = 65, .external_lex_state = 2},
  [811] = {.lex_state = 65, .external_lex_state = 2},
  [812] = {.lex_state = 65, .external_lex_state = 2},
  [813] = {.lex_state = 65, .external_lex_state = 2},
  [814] = {.lex_state = 65, .external_lex_state = 2},
  [815] = {.lex_state = 65, .external_lex_state = 2},
  [816] = {.lex_state = 65, .external_lex_state = 2},
  [817] = {.lex_state = 65, .external_lex_state = 2},
  [818] = {.lex_state = 65, .external_lex_state = 2},
  [819] = {.lex_state = 65, .external_lex_state = 2},
  [820] = {.lex_state = 65, .external_lex_state = 2},
  [821] = {.lex_state = 65, .external_lex_state = 2},
  [822] = {.lex_state = 65, .external_lex_state = 2},
  [823] = {.lex_state = 65, .external_lex_state = 2},
  [824] = {.lex_state = 65, .external_lex_state = 2},
  [825] = {.lex_state = 65, .external_lex_state = 2},
  [826] = {.lex_state = 65, .external_lex_state = 2},
  [827] = {.lex_state = 65, .external_lex_state = 2},
  [828] = {.lex_state = 65, .external_lex_state = 2},
  [829] = {.lex_state = 65, .external_lex_state = 2},
  [830] = {.lex_state = 65, .external_lex_state = 2},
  [831] = {.lex_state = 65, .external_lex_state = 2},
  [832] = {.lex_state = 65, .external_lex_state = 2},
  [833] = {.lex_state = 5, .external_lex_state = 2},
  [834] = {.lex_state = 65, .external_lex_state = 2},
  [835] = {.lex_state = 65, .external_lex_state = 2},
  [836] = {.lex_state = 65, .external_lex_state = 2},
  [837] = {.lex_state = 65, .external_lex_state = 2},
  [838] = {.lex_state = 65, .external_lex_state = 2},
  [839] = {.lex_state = 65, .external_lex_state = 2},
  [840] = {.lex_state = 65, .external_lex_state = 2},
  [841] = {.lex_state = 66},
  [842] = {.lex_state = 66},
  [843] = {.lex_state = 66},
  [844] = {.lex_state = 66},
  [845] = {.lex_state = 66},
  [846] = {.lex_state = 66},
  [847] = {.lex_state = 66},
  [848] = {.lex_state = 66},
  [849] = {.lex_state = 66},
  [850] = {.lex_state = 66},
  [851] = {.lex_state = 66},
  [852] = {.lex_state = 66},
  [853] = {.lex_state = 66},
  [854] = {.lex_state = 66},
  [855] = {.lex_state = 66},
  [856] = {.lex_state = 66},
  [857] = {.lex_state = 66},
  [858] = {.lex_state = 66},
  [859] = {.lex_state = 66},
  [860] = {.lex_state = 66},
  [861] = {.lex_state = 66},
  [862] = {.lex_state = 66},
  [863] = {.lex_state = 66},
  [864] = {.lex_state = 66},
  [865] = {.lex_state = 66},
  [866] = {.lex_state = 66},
  [867] = {.lex_state = 66},
  [868] = {.lex_state = 66},
  [869] = {.lex_state = 66},
  [870] = {.lex_state = 66},
  [871] = {.lex_state = 66},
  [872] = {.lex_state = 66},
  [873] = {.lex_state = 66},
  [874] = {.lex_state = 66},
  [875] = {.lex_state = 66},
  [876] = {.lex_state = 66},
  [877] = {.lex_state = 66},
  [878] = {.lex_state = 66},
  [879] = {.lex_state = 66},
  [880] = {.lex_state = 66},
  [881] = {.lex_state = 66},
  [882] = {.lex_state = 66},
  [883] = {.lex_state = 66},
  [884] = {.lex_state = 66},
  [885] = {.lex_state = 66},
  [886] = {.lex_state = 66, .external_lex_state = 4},
  [887] = {.lex_state = 66, .external_lex_state = 4},
  [888] = {.lex_state = 66},
  [889] = {.lex_state = 66, .external_lex_state = 4},
  [890] = {.lex_state = 66, .external_lex_state = 4},
  [891] = {.lex_state = 66, .external_lex_state = 4},
  [892] = {.lex_state = 66, .external_lex_state = 4},
  [893] = {.lex_state = 66, .external_lex_state = 4},
  [894] = {.lex_state = 66, .external_lex_state = 4},
  [895] = {.lex_state = 66},
  [896] = {.lex_state = 66},
  [897] = {.lex_state = 66, .external_lex_state = 4},
  [898] = {.lex_state = 66, .external_lex_state = 4},
  [899] = {.lex_state = 66, .external_lex_state = 4},
  [900] = {.lex_state = 66, .external_lex_state = 4},
  [901] = {.lex_state = 66},
  [902] = {.lex_state = 66},
  [903] = {.lex_state = 65},
  [904] = {.lex_state = 66},
  [905] = {.lex_state = 66},
  [906] = {.lex_state = 66},
  [907] = {.lex_state = 66},
  [908] = {.lex_state = 66},
  [909] = {.lex_state = 66},
  [910] = {.lex_state = 66},
  [911] = {.lex_state = 66},
  [912] = {.lex_state = 65},
  [913] = {.lex_state = 66},
  [914] = {.lex_state = 66},
  [915] = {.lex_state = 66},
  [916] = {.lex_state = 66},
  [917] = {.lex_state = 66},
  [918] = {.lex_state = 66},
  [919] = {.lex_state = 66},
  [920] = {.lex_state = 66},
  [921] = {.lex_state = 66},
  [922] = {.lex_state = 66},
  [923] = {.lex_state = 66},
  [924] = {.lex_state = 66},
  [925] = {.lex_state = 66},
  [926] = {.lex_state = 66},
  [927] = {.lex_state = 66},
  [928] = {.lex_state = 66},
  [929] = {.lex_state = 66},
  [930] = {.lex_state = 66},
  [931] = {.lex_state = 66},
  [932] = {.lex_state = 66},
  [933] = {.lex_state = 4},
  [934] = {.lex_state = 66},
  [935] = {.lex_state = 66},
  [936] = {.lex_state = 66},
  [937] = {.lex_state = 4},
  [938] = {.lex_state = 66},
  [939] = {.lex_state = 66},
  [940] = {.lex_state = 4},
  [941] = {.lex_state = 66},
  [942] = {.lex_state = 4},
  [943] = {.lex_state = 4},
  [944] = {.lex_state = 66},
  [945] = {.lex_state = 66},
  [946] = {.lex_state = 66},
  [947] = {.lex_state = 66},
  [948] = {.lex_state = 66},
  [949] = {.lex_state = 66},
  [950] = {.lex_state = 66},
  [951] = {.lex_state = 66},
  [952] = {.lex_state = 66},
  [953] = {.lex_state = 66},
  [954] = {.lex_state = 66},
  [955] = {.lex_state = 66},
  [956] = {.lex_state = 66},
  [957] = {.lex_state = 66},
  [958] = {.lex_state = 66},
  [959] = {.lex_state = 66},
  [960] = {.lex_state = 66},
  [961] = {.lex_state = 66},
  [962] = {.lex_state = 66},
  [963] = {.lex_state = 11},
  [964] = {.lex_state = 11},
  [965] = {.lex_state = 11},
  [966] = {.lex_state = 11},
  [967] = {.lex_state = 11},
  [968] = {.lex_state = 66},
  [969] = {.lex_state = 19},
  [970] = {.lex_state = 11},
  [971] = {.lex_state = 11},
  [972] = {.lex_state = 19},
  [973] = {.lex_state = 19},
  [974] = {.lex_state = 11},
  [975] = {.lex_state = 19},
  [976] = {.lex_state = 11},
  [977] = {.lex_state = 19},
  [978] = {.lex_state = 11},
  [979] = {.lex_state = 19},
  [980] = {.lex_state = 19},
  [981] = {.lex_state = 19},
  [982] = {.lex_state = 11},
  [983] = {.lex_state = 66},
  [984] = {.lex_state = 11},
  [985] = {.lex_state = 11},
  [986] = {.lex_state = 11},
  [987] = {.lex_state = 11},
  [988] = {.lex_state = 11},
  [989] = {.lex_state = 11},
  [990] = {.lex_state = 19},
  [991] = {.lex_state = 11},
  [992] = {.lex_state = 11},
  [993] = {.lex_state = 19},
  [994] = {.lex_state = 11},
  [995] = {.lex_state = 11},
  [996] = {.lex_state = 11},
  [997] = {.lex_state = 11},
  [998] = {.lex_state = 11},
  [999] = {.lex_state = 11},
  [1000] = {.lex_state = 11},
  [1001] = {.lex_state = 19},
  [1002] = {.lex_state = 11},
  [1003] = {.lex_state = 11},
  [1004] = {.lex_state = 19},
  [1005] = {.lex_state = 11},
  [1006] = {.lex_state = 19},
  [1007] = {.lex_state = 11},
  [1008] = {.lex_state = 19},
  [1009] = {.lex_state = 19},
  [1010] = {.lex_state = 19},
  [1011] = {.lex_state = 19},
  [1012] = {.lex_state = 11},
  [1013] = {.lex_state = 11},
  [1014] = {.lex_state = 11},
  [1015] = {.lex_state = 0},
  [1016] = {.lex_state = 66},
  [1017] = {.lex_state = 66},
  [1018] = {.lex_state = 11},
  [1019] = {.lex_state = 66, .external_lex_state = 4},
  [1020] = {.lex_state = 66},
  [1021] = {.lex_state = 66, .external_lex_state = 4},
  [1022] = {.lex_state = 66},
  [1023] = {.lex_state = 0},
  [1024] = {.lex_state = 11},
  [1025] = {.lex_state = 0},
  [1026] = {.lex_state = 66},
  [1027] = {.lex_state = 66},
  [1028] = {.lex_state = 11},
  [1029] = {.lex_state = 0},
  [1030] = {.lex_state = 66},
  [1031] = {.lex_state = 66},
  [1032] = {.lex_state = 66},
  [1033] = {.lex_state = 66},
  [1034] = {.lex_state = 0},
  [1035] = {.lex_state = 0},
  [1036] = {.lex_state = 0},
  [1037] = {.lex_state = 66},
  [1038] = {.lex_state = 66, .external_lex_state = 4},
  [1039] = {.lex_state = 11},
  [1040] = {.lex_state = 11},
  [1041] = {.lex_state = 0, .external_lex_state = 4},
  [1042] = {.lex_state = 11},
  [1043] = {.lex_state = 11},
  [1044] = {.lex_state = 66, .external_lex_state = 4},
  [1045] = {.lex_state = 0, .external_lex_state = 4},
  [1046] = {.lex_state = 0, .external_lex_state = 4},
  [1047] = {.lex_state = 11},
  [1048] = {.lex_state = 66, .external_lex_state = 4},
  [1049] = {.lex_state = 11},
  [1050] = {.lex_state = 66},
  [1051] = {.lex_state = 8, .external_lex_state = 5},
  [1052] = {.lex_state = 8, .external_lex_state = 5},
  [1053] = {.lex_state = 66},
  [1054] = {.lex_state = 11},
  [1055] = {.lex_state = 66},
  [1056] = {.lex_state = 8, .external_lex_state = 5},
  [1057] = {.lex_state = 66},
  [1058] = {.lex_state = 66, .external_lex_state = 4},
  [1059] = {.lex_state = 0, .external_lex_state = 4},
  [1060] = {.lex_state = 11},
  [1061] = {.lex_state = 11},
  [1062] = {.lex_state = 11},
  [1063] = {.lex_state = 11},
  [1064] = {.lex_state = 11},
  [1065] = {.lex_state = 66, .external_lex_state = 4},
  [1066] = {.lex_state = 11},
  [1067] = {.lex_state = 8, .external_lex_state = 5},
  [1068] = {.lex_state = 11},
  [1069] = {.lex_state = 66, .external_lex_state = 4},
  [1070] = {.lex_state = 66, .external_lex_state = 4},
  [1071] = {.lex_state = 66, .external_lex_state = 4},
  [1072] = {.lex_state = 66},
  [1073] = {.lex_state = 11},
  [1074] = {.lex_state = 8, .external_lex_state = 5},
  [1075] = {.lex_state = 11},
  [1076] = {.lex_state = 0},
  [1077] = {.lex_state = 11},
  [1078] = {.lex_state = 11},
  [1079] = {.lex_state = 11},
  [1080] = {.lex_state = 11},
  [1081] = {.lex_state = 11},
  [1082] = {.lex_state = 66},
  [1083] = {.lex_state = 0},
  [1084] = {.lex_state = 0},
  [1085] = {.lex_state = 66, .external_lex_state = 4},
  [1086] = {.lex_state = 11},
  [1087] = {.lex_state = 11},
  [1088] = {.lex_state = 0},
  [1089] = {.lex_state = 11},
  [1090] = {.lex_state = 11},
  [1091] = {.lex_state = 66},
  [1092] = {.lex_state = 11},
  [1093] = {.lex_state = 66},
  [1094] = {.lex_state = 0},
  [1095] = {.lex_state = 66},
  [1096] = {.lex_state = 11},
  [1097] = {.lex_state = 66},
  [1098] = {.lex_state = 66},
  [1099] = {.lex_state = 66},
  [1100] = {.lex_state = 0},
  [1101] = {.lex_state = 11},
  [1102] = {.lex_state = 66},
  [1103] = {.lex_state = 11},
  [1104] = {.lex_state = 66},
  [1105] = {.lex_state = 66},
  [1106] = {.lex_state = 11},
  [1107] = {.lex_state = 11},
  [1108] = {.lex_state = 66},
  [1109] = {.lex_state = 0, .external_lex_state = 4},
  [1110] = {.lex_state = 66},
  [1111] = {.lex_state = 11},
  [1112] = {.lex_state = 0},
  [1113] = {.lex_state = 11},
  [1114] = {.lex_state = 11},
  [1115] = {.lex_state = 66},
  [1116] = {.lex_state = 66},
  [1117] = {.lex_state = 11},
  [1118] = {.lex_state = 0, .external_lex_state = 4},
  [1119] = {.lex_state = 66},
  [1120] = {.lex_state = 66},
  [1121] = {.lex_state = 66},
  [1122] = {.lex_state = 0, .external_lex_state = 4},
  [1123] = {.lex_state = 0, .external_lex_state = 4},
  [1124] = {.lex_state = 0},
  [1125] = {.lex_state = 66},
  [1126] = {.lex_state = 11},
  [1127] = {.lex_state = 0},
  [1128] = {.lex_state = 0},
  [1129] = {.lex_state = 7},
  [1130] = {.lex_state = 10},
  [1131] = {.lex_state = 7},
  [1132] = {.lex_state = 10},
  [1133] = {.lex_state = 10},
  [1134] = {.lex_state = 7},
  [1135] = {.lex_state = 10},
  [1136] = {.lex_state = 7},
  [1137] = {.lex_state = 66},
  [1138] = {.lex_state = 66},
  [1139] = {.lex_state = 0},
  [1140] = {.lex_state = 0},
  [1141] = {.lex_state = 0},
  [1142] = {.lex_state = 11},
  [1143] = {.lex_state = 66},
  [1144] = {.lex_state = 66},
  [1145] = {.lex_state = 0, .external_lex_state = 4},
  [1146] = {.lex_state = 0, .external_lex_state = 4},
  [1147] = {.lex_state = 66},
  [1148] = {.lex_state = 8, .external_lex_state = 5},
  [1149] = {.lex_state = 66},
  [1150] = {.lex_state = 7},
  [1151] = {.lex_state = 66},
  [1152] = {.lex_state = 66},
  [1153] = {.lex_state = 7},
  [1154] = {.lex_state = 66},
  [1155] = {.lex_state = 66},
  [1156] = {.lex_state = 66},
  [1157] = {.lex_state = 7},
  [1158] = {.lex_state = 0, .external_lex_state = 4},
  [1159] = {.lex_state = 10},
  [1160] = {.lex_state = 66},
  [1161] = {.lex_state = 10},
  [1162] = {.lex_state = 7},
  [1163] = {.lex_state = 66},
  [1164] = {.lex_state = 10},
  [1165] = {.lex_state = 0},
  [1166] = {.lex_state = 11},
  [1167] = {.lex_state = 66},
  [1168] = {.lex_state = 66},
  [1169] = {.lex_state = 66, .external_lex_state = 4},
  [1170] = {.lex_state = 66},
  [1171] = {.lex_state = 0, .external_lex_state = 4},
  [1172] = {.lex_state = 0},
  [1173] = {.lex_state = 66},
  [1174] = {.lex_state = 66},
  [1175] = {.lex_state = 66},
  [1176] = {.lex_state = 0, .external_lex_state = 4},
  [1177] = {.lex_state = 0, .external_lex_state = 4},
  [1178] = {.lex_state = 10},
  [1179] = {.lex_state = 7},
  [1180] = {.lex_state = 10},
  [1181] = {.lex_state = 0},
  [1182] = {.lex_state = 66},
  [1183] = {.lex_state = 66},
  [1184] = {.lex_state = 66},
  [1185] = {.lex_state = 66},
  [1186] = {.lex_state = 66},
  [1187] = {.lex_state = 3},
  [1188] = {.lex_state = 0},
  [1189] = {.lex_state = 0},
  [1190] = {.lex_state = 19},
  [1191] = {.lex_state = 0},
  [1192] = {.lex_state = 66},
  [1193] = {.lex_state = 0},
  [1194] = {.lex_state = 0},
  [1195] = {.lex_state = 19},
  [1196] = {.lex_state = 19},
  [1197] = {.lex_state = 19},
  [1198] = {.lex_state = 19},
  [1199] = {.lex_state = 0, .external_lex_state = 4},
  [1200] = {.lex_state = 19},
  [1201] = {.lex_state = 19},
  [1202] = {.lex_state = 0},
  [1203] = {.lex_state = 19},
  [1204] = {.lex_state = 19},
  [1205] = {.lex_state = 0},
  [1206] = {.lex_state = 19},
  [1207] = {.lex_state = 19},
  [1208] = {.lex_state = 0},
  [1209] = {.lex_state = 66, .external_lex_state = 4},
  [1210] = {.lex_state = 19},
  [1211] = {.lex_state = 0},
  [1212] = {.lex_state = 0},
  [1213] = {.lex_state = 0},
  [1214] = {.lex_state = 0},
  [1215] = {.lex_state = 0},
  [1216] = {.lex_state = 0},
  [1217] = {.lex_state = 66},
  [1218] = {.lex_state = 19},
  [1219] = {.lex_state = 66},
  [1220] = {.lex_state = 0},
  [1221] = {.lex_state = 66},
  [1222] = {.lex_state = 0},
  [1223] = {.lex_state = 19},
  [1224] = {.lex_state = 66},
  [1225] = {.lex_state = 0},
  [1226] = {.lex_state = 0},
  [1227] = {.lex_state = 66},
  [1228] = {.lex_state = 0, .external_lex_state = 4},
  [1229] = {.lex_state = 0},
  [1230] = {.lex_state = 66},
  [1231] = {.lex_state = 0},
  [1232] = {.lex_state = 66},
  [1233] = {.lex_state = 66},
  [1234] = {.lex_state = 0},
  [1235] = {.lex_state = 66, .external_lex_state = 4},
  [1236] = {.lex_state = 0},
  [1237] = {.lex_state = 0},
  [1238] = {.lex_state = 0},
  [1239] = {.lex_state = 0},
  [1240] = {.lex_state = 0},
  [1241] = {.lex_state = 0},
  [1242] = {.lex_state = 0},
  [1243] = {.lex_state = 0},
  [1244] = {.lex_state = 19},
  [1245] = {.lex_state = 3},
  [1246] = {.lex_state = 0},
  [1247] = {.lex_state = 0},
  [1248] = {.lex_state = 0},
  [1249] = {.lex_state = 0},
  [1250] = {.lex_state = 0},
  [1251] = {.lex_state = 66, .external_lex_state = 4},
  [1252] = {.lex_state = 0},
  [1253] = {.lex_state = 0},
  [1254] = {.lex_state = 66},
  [1255] = {.lex_state = 66},
  [1256] = {.lex_state = 0},
  [1257] = {.lex_state = 0},
  [1258] = {.lex_state = 66},
  [1259] = {.lex_state = 66, .external_lex_state = 4},
  [1260] = {.lex_state = 0},
  [1261] = {.lex_state = 66, .external_lex_state = 4},
  [1262] = {.lex_state = 66},
  [1263] = {.lex_state = 66, .external_lex_state = 4},
  [1264] = {.lex_state = 66, .external_lex_state = 4},
  [1265] = {.lex_state = 19},
  [1266] = {.lex_state = 66},
  [1267] = {.lex_state = 0},
  [1268] = {.lex_state = 0},
  [1269] = {.lex_state = 0},
  [1270] = {.lex_state = 0},
  [1271] = {.lex_state = 66},
  [1272] = {.lex_state = 66},
  [1273] = {.lex_state = 66, .external_lex_state = 4},
  [1274] = {.lex_state = 0},
  [1275] = {.lex_state = 0},
  [1276] = {.lex_state = 0},
  [1277] = {.lex_state = 0},
  [1278] = {.lex_state = 66},
  [1279] = {.lex_state = 0},
  [1280] = {.lex_state = 19},
  [1281] = {.lex_state = 3},
  [1282] = {.lex_state = 66},
  [1283] = {.lex_state = 0},
  [1284] = {.lex_state = 0},
  [1285] = {.lex_state = 0},
  [1286] = {.lex_state = 0},
  [1287] = {.lex_state = 0},
  [1288] = {.lex_state = 0},
  [1289] = {.lex_state = 66},
  [1290] = {.lex_state = 66},
  [1291] = {.lex_state = 66},
  [1292] = {.lex_state = 0},
  [1293] = {.lex_state = 0},
  [1294] = {.lex_state = 0},
  [1295] = {.lex_state = 3},
  [1296] = {.lex_state = 66},
  [1297] = {.lex_state = 0},
  [1298] = {.lex_state = 66},
  [1299] = {.lex_state = 3},
  [1300] = {.lex_state = 0},
  [1301] = {.lex_state = 0},
  [1302] = {.lex_state = 0},
  [1303] = {.lex_state = 0},
  [1304] = {.lex_state = 0},
  [1305] = {.lex_state = 0},
  [1306] = {.lex_state = 0},
  [1307] = {.lex_state = 0, .external_lex_state = 4},
  [1308] = {.lex_state = 0},
  [1309] = {.lex_state = 0},
  [1310] = {.lex_state = 0},
  [1311] = {.lex_state = 66},
  [1312] = {.lex_state = 0},
  [1313] = {.lex_state = 0},
  [1314] = {.lex_state = 0},
  [1315] = {.lex_state = 0},
  [1316] = {.lex_state = 0},
  [1317] = {.lex_state = 0},
  [1318] = {.lex_state = 66},
  [1319] = {.lex_state = 0, .external_lex_state = 4},
  [1320] = {.lex_state = 0},
  [1321] = {.lex_state = 0},
  [1322] = {.lex_state = 0},
  [1323] = {.lex_state = 0},
  [1324] = {.lex_state = 66},
  [1325] = {.lex_state = 0},
  [1326] = {.lex_state = 3},
  [1327] = {.lex_state = 0},
  [1328] = {.lex_state = 0},
  [1329] = {.lex_state = 0},
  [1330] = {.lex_state = 0, .external_lex_state = 4},
  [1331] = {.lex_state = 0, .external_lex_state = 4},
  [1332] = {.lex_state = 0},
  [1333] = {.lex_state = 0},
  [1334] = {.lex_state = 0},
  [1335] = {.lex_state = 66},
  [1336] = {.lex_state = 0},
  [1337] = {.lex_state = 0},
  [1338] = {.lex_state = 0},
  [1339] = {.lex_state = 66},
  [1340] = {.lex_state = 0},
  [1341] = {.lex_state = 66},
  [1342] = {.lex_state = 11},
  [1343] = {.lex_state = 0, .external_lex_state = 4},
  [1344] = {.lex_state = 0},
  [1345] = {.lex_state = 0},
  [1346] = {.lex_state = 0},
  [1347] = {.lex_state = 0, .external_lex_state = 4},
  [1348] = {.lex_state = 0},
  [1349] = {.lex_state = 0},
  [1350] = {.lex_state = 0, .external_lex_state = 4},
  [1351] = {.lex_state = 66},
  [1352] = {.lex_state = 66},
  [1353] = {.lex_state = 3},
  [1354] = {.lex_state = 0},
  [1355] = {.lex_state = 0},
  [1356] = {.lex_state = 0},
  [1357] = {.lex_state = 0},
  [1358] = {.lex_state = 0},
  [1359] = {.lex_state = 0},
  [1360] = {.lex_state = 0},
  [1361] = {.lex_state = 0},
  [1362] = {.lex_state = 0},
  [1363] = {.lex_state = 0},
  [1364] = {.lex_state = 0},
  [1365] = {.lex_state = 0},
  [1366] = {.lex_state = 0},
  [1367] = {.lex_state = 0},
  [1368] = {.lex_state = 0},
  [1369] = {.lex_state = 0},
  [1370] = {.lex_state = 0, .external_lex_state = 4},
  [1371] = {.lex_state = 0},
  [1372] = {.lex_state = 0},
  [1373] = {.lex_state = 0},
  [1374] = {.lex_state = 0},
  [1375] = {.lex_state = 0},
  [1376] = {.lex_state = 0},
  [1377] = {.lex_state = 0},
  [1378] = {.lex_state = 0},
  [1379] = {.lex_state = 0},
  [1380] = {.lex_state = 0},
  [1381] = {.lex_state = 0, .external_lex_state = 4},
  [1382] = {.lex_state = 0},
  [1383] = {.lex_state = 0},
  [1384] = {.lex_state = 0},
  [1385] = {.lex_state = 0, .external_lex_state = 4},
  [1386] = {.lex_state = 0},
  [1387] = {.lex_state = 0},
  [1388] = {.lex_state = 0, .external_lex_state = 4},
  [1389] = {.lex_state = 0},
  [1390] = {.lex_state = 0},
  [1391] = {.lex_state = 0},
  [1392] = {.lex_state = 66},
  [1393] = {.lex_state = 0},
  [1394] = {.lex_state = 0},
  [1395] = {.lex_state = 0},
  [1396] = {.lex_state = 0},
  [1397] = {.lex_state = 0},
  [1398] = {.lex_state = 0, .external_lex_state = 4},
  [1399] = {.lex_state = 3},
  [1400] = {.lex_state = 66},
  [1401] = {.lex_state = 0, .external_lex_state = 4},
  [1402] = {.lex_state = 0},
  [1403] = {.lex_state = 0},
  [1404] = {.lex_state = 0, .external_lex_state = 4},
  [1405] = {.lex_state = 0},
  [1406] = {.lex_state = 0},
  [1407] = {.lex_state = 0},
  [1408] = {.lex_state = 0},
  [1409] = {.lex_state = 0},
  [1410] = {.lex_state = 0},
  [1411] = {.lex_state = 0},
  [1412] = {.lex_state = 0},
  [1413] = {.lex_state = 0},
  [1414] = {.lex_state = 0},
  [1415] = {.lex_state = 66},
  [1416] = {.lex_state = 0},
  [1417] = {.lex_state = 0},
  [1418] = {.lex_state = 0},
  [1419] = {.lex_state = 0},
  [1420] = {.lex_state = 0},
  [1421] = {.lex_state = 0},
  [1422] = {.lex_state = 0},
  [1423] = {.lex_state = 0},
  [1424] = {.lex_state = 0, .external_lex_state = 4},
  [1425] = {.lex_state = 0},
  [1426] = {.lex_state = 0, .external_lex_state = 4},
  [1427] = {.lex_state = 0, .external_lex_state = 4},
  [1428] = {.lex_state = 0},
  [1429] = {.lex_state = 0},
  [1430] = {.lex_state = 0},
  [1431] = {.lex_state = 0},
  [1432] = {.lex_state = 0},
  [1433] = {.lex_state = 0},
  [1434] = {.lex_state = 0},
  [1435] = {.lex_state = 0},
  [1436] = {.lex_state = 0},
  [1437] = {.lex_state = 0},
  [1438] = {.lex_state = 0},
  [1439] = {.lex_state = 0, .external_lex_state = 4},
  [1440] = {.lex_state = 0},
  [1441] = {.lex_state = 0},
  [1442] = {.lex_state = 0},
  [1443] = {.lex_state = 0},
  [1444] = {.lex_state = 0},
  [1445] = {.lex_state = 0, .external_lex_state = 4},
  [1446] = {.lex_state = 0},
  [1447] = {.lex_state = 0},
  [1448] = {.lex_state = 0},
  [1449] = {.lex_state = 0},
  [1450] = {.lex_state = 0},
  [1451] = {.lex_state = 66},
  [1452] = {.lex_state = 0, .external_lex_state = 4},
  [1453] = {.lex_state = 0},
  [1454] = {.lex_state = 0},
  [1455] = {.lex_state = 0},
  [1456] = {.lex_state = 66},
  [1457] = {.lex_state = 0},
  [1458] = {.lex_state = 0},
  [1459] = {.lex_state = 0},
  [1460] = {.lex_state = 0},
  [1461] = {.lex_state = 0},
  [1462] = {.lex_state = 0},
  [1463] = {.lex_state = 0},
  [1464] = {.lex_state = 0},
  [1465] = {.lex_state = 0},
  [1466] = {.lex_state = 0},
  [1467] = {.lex_state = 1},
  [1468] = {.lex_state = 0},
  [1469] = {.lex_state = 8},
  [1470] = {.lex_state = 0},
  [1471] = {.lex_state = 0},
  [1472] = {.lex_state = 66},
  [1473] = {.lex_state = 0},
  [1474] = {.lex_state = 66},
  [1475] = {.lex_state = 66},
  [1476] = {.lex_state = 66},
  [1477] = {.lex_state = 1},
  [1478] = {.lex_state = 66},
  [1479] = {.lex_state = 0},
  [1480] = {.lex_state = 66},
  [1481] = {.lex_state = 66},
  [1482] = {.lex_state = 0},
  [1483] = {.lex_state = 0},
  [1484] = {.lex_state = 0},
  [1485] = {.lex_state = 0},
  [1486] = {.lex_state = 0},
  [1487] = {.lex_state = 0},
  [1488] = {.lex_state = 0},
  [1489] = {.lex_state = 8},
  [1490] = {.lex_state = 66},
  [1491] = {.lex_state = 66},
  [1492] = {.lex_state = 0},
  [1493] = {.lex_state = 0},
  [1494] = {.lex_state = 0},
  [1495] = {.lex_state = 0},
  [1496] = {.lex_state = 0},
  [1497] = {.lex_state = 0},
  [1498] = {.lex_state = 0},
  [1499] = {.lex_state = 66},
  [1500] = {.lex_state = 66},
  [1501] = {.lex_state = 66},
  [1502] = {.lex_state = 66},
  [1503] = {.lex_state = 66},
  [1504] = {.lex_state = 66},
  [1505] = {.lex_state = 66},
  [1506] = {.lex_state = 66},
  [1507] = {.lex_state = 0},
  [1508] = {.lex_state = 0},
  [1509] = {.lex_state = 66},
  [1510] = {.lex_state = 66},
  [1511] = {.lex_state = 0},
  [1512] = {.lex_state = 0},
  [1513] = {.lex_state = 0},
  [1514] = {.lex_state = 0},
  [1515] = {.lex_state = 0},
  [1516] = {.lex_state = 66},
  [1517] = {.lex_state = 66},
  [1518] = {.lex_state = 0},
  [1519] = {.lex_state = 66},
  [1520] = {.lex_state = 66},
  [1521] = {.lex_state = 66},
  [1522] = {.lex_state = 0},
  [1523] = {.lex_state = 66},
  [1524] = {.lex_state = 66},
  [1525] = {.lex_state = 66},
  [1526] = {.lex_state = 66},
  [1527] = {.lex_state = 66},
  [1528] = {.lex_state = 0},
  [1529] = {.lex_state = 0},
  [1530] = {.lex_state = 66},
  [1531] = {.lex_state = 66},
  [1532] = {.lex_state = 1},
  [1533] = {.lex_state = 0},
  [1534] = {.lex_state = 66},
  [1535] = {.lex_state = 0},
  [1536] = {.lex_state = 66},
  [1537] = {.lex_state = 66},
  [1538] = {.lex_state = 0},
  [1539] = {.lex_state = 8},
  [1540] = {.lex_state = 0},
  [1541] = {.lex_state = 66},
  [1542] = {.lex_state = 66},
  [1543] = {.lex_state = 66},
  [1544] = {.lex_state = 0},
  [1545] = {.lex_state = 0},
  [1546] = {.lex_state = 0},
  [1547] = {.lex_state = 0},
  [1548] = {.lex_state = 0},
  [1549] = {.lex_state = 0},
  [1550] = {.lex_state = 0},
  [1551] = {.lex_state = 66},
  [1552] = {.lex_state = 66},
  [1553] = {.lex_state = 66},
  [1554] = {.lex_state = 66},
  [1555] = {.lex_state = 0},
  [1556] = {.lex_state = 0},
  [1557] = {.lex_state = 0},
  [1558] = {.lex_state = 0},
  [1559] = {.lex_state = 66},
  [1560] = {.lex_state = 1},
  [1561] = {.lex_state = 66},
  [1562] = {.lex_state = 66},
  [1563] = {.lex_state = 0},
  [1564] = {.lex_state = 66},
  [1565] = {.lex_state = 8},
  [1566] = {.lex_state = 0},
  [1567] = {.lex_state = 0},
  [1568] = {.lex_state = 0},
  [1569] = {.lex_state = 66},
  [1570] = {.lex_state = 66},
  [1571] = {.lex_state = 66},
  [1572] = {.lex_state = 66},
  [1573] = {.lex_state = 66},
  [1574] = {.lex_state = 66},
  [1575] = {.lex_state = 66},
  [1576] = {.lex_state = 66},
  [1577] = {.lex_state = 0},
  [1578] = {.lex_state = 66},
  [1579] = {.lex_state = 0},
  [1580] = {.lex_state = 0},
};

enum {
  ts_external_token__automatic_semicolon = 0,
  ts_external_token__template_chars = 1,
  ts_external_token__ternary_qmark = 2,
};

static const TSSymbol ts_external_scanner_symbol_map[EXTERNAL_TOKEN_COUNT] = {
  [ts_external_token__automatic_semicolon] = sym__automatic_semicolon,
  [ts_external_token__template_chars] = sym__template_chars,
  [ts_external_token__ternary_qmark] = sym__ternary_qmark,
};

static const bool ts_external_scanner_states[6][EXTERNAL_TOKEN_COUNT] = {
  [1] = {
    [ts_external_token__automatic_semicolon] = true,
    [ts_external_token__template_chars] = true,
    [ts_external_token__ternary_qmark] = true,
  },
  [2] = {
    [ts_external_token__ternary_qmark] = true,
  },
  [3] = {
    [ts_external_token__automatic_semicolon] = true,
    [ts_external_token__ternary_qmark] = true,
  },
  [4] = {
    [ts_external_token__automatic_semicolon] = true,
  },
  [5] = {
    [ts_external_token__template_chars] = true,
  },
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym_identifier] = ACTIONS(1),
    [sym_hash_bang_line] = ACTIONS(1),
    [anon_sym_export] = ACTIONS(1),
    [anon_sym_STAR] = ACTIONS(1),
    [anon_sym_default] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_as] = ACTIONS(1),
    [anon_sym_import] = ACTIONS(1),
    [anon_sym_from] = ACTIONS(1),
    [anon_sym_var] = ACTIONS(1),
    [anon_sym_let] = ACTIONS(1),
    [anon_sym_const] = ACTIONS(1),
    [anon_sym_else] = ACTIONS(1),
    [anon_sym_if] = ACTIONS(1),
    [anon_sym_switch] = ACTIONS(1),
    [anon_sym_for] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_await] = ACTIONS(1),
    [anon_sym_in] = ACTIONS(1),
    [anon_sym_of] = ACTIONS(1),
    [anon_sym_while] = ACTIONS(1),
    [anon_sym_do] = ACTIONS(1),
    [anon_sym_try] = ACTIONS(1),
    [anon_sym_with] = ACTIONS(1),
    [anon_sym_break] = ACTIONS(1),
    [anon_sym_continue] = ACTIONS(1),
    [anon_sym_debugger] = ACTIONS(1),
    [anon_sym_return] = ACTIONS(1),
    [anon_sym_throw] = ACTIONS(1),
    [anon_sym_SEMI] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_case] = ACTIONS(1),
    [anon_sym_catch] = ACTIONS(1),
    [anon_sym_finally] = ACTIONS(1),
    [anon_sym_yield] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [anon_sym_SLASH] = ACTIONS(1),
    [anon_sym_DOT] = ACTIONS(1),
    [anon_sym_class] = ACTIONS(1),
    [anon_sym_extends] = ACTIONS(1),
    [anon_sym_async] = ACTIONS(1),
    [anon_sym_function] = ACTIONS(1),
    [anon_sym_EQ_GT] = ACTIONS(1),
    [anon_sym_QMARK_DOT] = ACTIONS(1),
    [anon_sym_new] = ACTIONS(1),
    [anon_sym_PLUS_EQ] = ACTIONS(1),
    [anon_sym_DASH_EQ] = ACTIONS(1),
    [anon_sym_STAR_EQ] = ACTIONS(1),
    [anon_sym_PERCENT_EQ] = ACTIONS(1),
    [anon_sym_CARET_EQ] = ACTIONS(1),
    [anon_sym_AMP_EQ] = ACTIONS(1),
    [anon_sym_PIPE_EQ] = ACTIONS(1),
    [anon_sym_GT_GT_EQ] = ACTIONS(1),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(1),
    [anon_sym_LT_LT_EQ] = ACTIONS(1),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(1),
    [anon_sym_AMP_AMP_EQ] = ACTIONS(1),
    [anon_sym_PIPE_PIPE_EQ] = ACTIONS(1),
    [anon_sym_QMARK_QMARK_EQ] = ACTIONS(1),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(1),
    [anon_sym_AMP_AMP] = ACTIONS(1),
    [anon_sym_PIPE_PIPE] = ACTIONS(1),
    [anon_sym_GT_GT] = ACTIONS(1),
    [anon_sym_GT_GT_GT] = ACTIONS(1),
    [anon_sym_LT_LT] = ACTIONS(1),
    [anon_sym_AMP] = ACTIONS(1),
    [anon_sym_CARET] = ACTIONS(1),
    [anon_sym_PIPE] = ACTIONS(1),
    [anon_sym_PLUS] = ACTIONS(1),
    [anon_sym_DASH] = ACTIONS(1),
    [anon_sym_PERCENT] = ACTIONS(1),
    [anon_sym_STAR_STAR] = ACTIONS(1),
    [anon_sym_LT_EQ] = ACTIONS(1),
    [anon_sym_EQ_EQ] = ACTIONS(1),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(1),
    [anon_sym_BANG_EQ] = ACTIONS(1),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(1),
    [anon_sym_GT_EQ] = ACTIONS(1),
    [anon_sym_QMARK_QMARK] = ACTIONS(1),
    [anon_sym_instanceof] = ACTIONS(1),
    [anon_sym_BANG] = ACTIONS(1),
    [anon_sym_TILDE] = ACTIONS(1),
    [anon_sym_typeof] = ACTIONS(1),
    [anon_sym_void] = ACTIONS(1),
    [anon_sym_delete] = ACTIONS(1),
    [anon_sym_PLUS_PLUS] = ACTIONS(1),
    [anon_sym_DASH_DASH] = ACTIONS(1),
    [anon_sym_DQUOTE] = ACTIONS(1),
    [anon_sym_SQUOTE] = ACTIONS(1),
    [sym_escape_sequence] = ACTIONS(1),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(1),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1),
    [anon_sym_SLASH2] = ACTIONS(1),
    [sym_number] = ACTIONS(1),
    [sym_private_property_identifier] = ACTIONS(1),
    [anon_sym_target] = ACTIONS(1),
    [sym_this] = ACTIONS(1),
    [sym_super] = ACTIONS(1),
    [sym_true] = ACTIONS(1),
    [sym_false] = ACTIONS(1),
    [sym_null] = ACTIONS(1),
    [sym_undefined] = ACTIONS(1),
    [anon_sym_AT] = ACTIONS(1),
    [anon_sym_static] = ACTIONS(1),
    [anon_sym_get] = ACTIONS(1),
    [anon_sym_set] = ACTIONS(1),
    [sym__automatic_semicolon] = ACTIONS(1),
    [sym__template_chars] = ACTIONS(1),
    [sym__ternary_qmark] = ACTIONS(1),
  },
  [1] = {
    [sym_program] = STATE(1549),
    [sym_export_statement] = STATE(20),
    [sym_declaration] = STATE(20),
    [sym_import] = STATE(721),
    [sym_import_statement] = STATE(20),
    [sym_expression_statement] = STATE(20),
    [sym_variable_declaration] = STATE(415),
    [sym_lexical_declaration] = STATE(415),
    [sym_statement_block] = STATE(20),
    [sym_if_statement] = STATE(20),
    [sym_switch_statement] = STATE(20),
    [sym_for_statement] = STATE(20),
    [sym_for_in_statement] = STATE(20),
    [sym_while_statement] = STATE(20),
    [sym_do_statement] = STATE(20),
    [sym_try_statement] = STATE(20),
    [sym_with_statement] = STATE(20),
    [sym_break_statement] = STATE(20),
    [sym_continue_statement] = STATE(20),
    [sym_debugger_statement] = STATE(20),
    [sym_return_statement] = STATE(20),
    [sym_throw_statement] = STATE(20),
    [sym_empty_statement] = STATE(20),
    [sym_labeled_statement] = STATE(20),
    [sym_parenthesized_expression] = STATE(479),
    [sym_expression] = STATE(674),
    [sym_primary_expression] = STATE(743),
    [sym_yield_expression] = STATE(740),
    [sym_object] = STATE(721),
    [sym_object_pattern] = STATE(1548),
    [sym_array] = STATE(721),
    [sym_array_pattern] = STATE(1548),
    [sym_jsx_element] = STATE(740),
    [sym_jsx_fragment] = STATE(740),
    [sym_jsx_opening_element] = STATE(972),
    [sym_jsx_self_closing_element] = STATE(740),
    [sym_class] = STATE(721),
    [sym_class_declaration] = STATE(415),
    [sym_function] = STATE(721),
    [sym_function_declaration] = STATE(415),
    [sym_generator_function] = STATE(721),
    [sym_generator_function_declaration] = STATE(415),
    [sym_arrow_function] = STATE(721),
    [sym_call_expression] = STATE(721),
    [sym_new_expression] = STATE(740),
    [sym_await_expression] = STATE(740),
    [sym_member_expression] = STATE(479),
    [sym_subscript_expression] = STATE(479),
    [sym_assignment_expression] = STATE(740),
    [sym__augmented_assignment_lhs] = STATE(942),
    [sym_augmented_assignment_expression] = STATE(740),
    [sym__destructuring_pattern] = STATE(1548),
    [sym_ternary_expression] = STATE(740),
    [sym_binary_expression] = STATE(740),
    [sym_unary_expression] = STATE(740),
    [sym_update_expression] = STATE(740),
    [sym_sequence_expression] = STATE(1331),
    [sym_string] = STATE(721),
    [sym_template_string] = STATE(721),
    [sym_regex] = STATE(721),
    [sym_meta_property] = STATE(721),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1546),
    [aux_sym_program_repeat1] = STATE(20),
    [aux_sym_export_statement_repeat1] = STATE(1091),
    [ts_builtin_sym_end] = ACTIONS(5),
    [sym_identifier] = ACTIONS(7),
    [sym_hash_bang_line] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(61),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(67),
    [anon_sym_void] = ACTIONS(67),
    [anon_sym_delete] = ACTIONS(67),
    [anon_sym_PLUS_PLUS] = ACTIONS(71),
    [anon_sym_DASH_DASH] = ACTIONS(71),
    [anon_sym_DQUOTE] = ACTIONS(73),
    [anon_sym_SQUOTE] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(77),
    [sym_number] = ACTIONS(79),
    [sym_this] = ACTIONS(81),
    [sym_super] = ACTIONS(81),
    [sym_true] = ACTIONS(81),
    [sym_false] = ACTIONS(81),
    [sym_null] = ACTIONS(81),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(87),
    [anon_sym_get] = ACTIONS(87),
    [anon_sym_set] = ACTIONS(87),
  },
  [2] = {
    [sym_export_statement] = STATE(17),
    [sym_declaration] = STATE(17),
    [sym_import] = STATE(721),
    [sym_import_statement] = STATE(17),
    [sym_expression_statement] = STATE(17),
    [sym_variable_declaration] = STATE(415),
    [sym_lexical_declaration] = STATE(415),
    [sym_statement_block] = STATE(17),
    [sym_if_statement] = STATE(17),
    [sym_switch_statement] = STATE(17),
    [sym_for_statement] = STATE(17),
    [sym_for_in_statement] = STATE(17),
    [sym_while_statement] = STATE(17),
    [sym_do_statement] = STATE(17),
    [sym_try_statement] = STATE(17),
    [sym_with_statement] = STATE(17),
    [sym_break_statement] = STATE(17),
    [sym_continue_statement] = STATE(17),
    [sym_debugger_statement] = STATE(17),
    [sym_return_statement] = STATE(17),
    [sym_throw_statement] = STATE(17),
    [sym_empty_statement] = STATE(17),
    [sym_labeled_statement] = STATE(17),
    [sym_parenthesized_expression] = STATE(479),
    [sym_expression] = STATE(674),
    [sym_primary_expression] = STATE(743),
    [sym_yield_expression] = STATE(740),
    [sym_object] = STATE(721),
    [sym_object_pattern] = STATE(1535),
    [sym_object_assignment_pattern] = STATE(1215),
    [sym_array] = STATE(721),
    [sym_array_pattern] = STATE(1535),
    [sym_jsx_element] = STATE(740),
    [sym_jsx_fragment] = STATE(740),
    [sym_jsx_opening_element] = STATE(972),
    [sym_jsx_self_closing_element] = STATE(740),
    [sym_class] = STATE(721),
    [sym_class_declaration] = STATE(415),
    [sym_function] = STATE(721),
    [sym_function_declaration] = STATE(415),
    [sym_generator_function] = STATE(721),
    [sym_generator_function_declaration] = STATE(415),
    [sym_arrow_function] = STATE(721),
    [sym_call_expression] = STATE(721),
    [sym_new_expression] = STATE(740),
    [sym_await_expression] = STATE(740),
    [sym_member_expression] = STATE(479),
    [sym_subscript_expression] = STATE(479),
    [sym_assignment_expression] = STATE(740),
    [sym__augmented_assignment_lhs] = STATE(942),
    [sym_augmented_assignment_expression] = STATE(740),
    [sym__destructuring_pattern] = STATE(1535),
    [sym_spread_element] = STATE(1214),
    [sym_ternary_expression] = STATE(740),
    [sym_binary_expression] = STATE(740),
    [sym_unary_expression] = STATE(740),
    [sym_update_expression] = STATE(740),
    [sym_sequence_expression] = STATE(1331),
    [sym_string] = STATE(796),
    [sym_template_string] = STATE(721),
    [sym_regex] = STATE(721),
    [sym_meta_property] = STATE(721),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1546),
    [sym_rest_pattern] = STATE(1215),
    [sym_method_definition] = STATE(1214),
    [sym_pair] = STATE(1214),
    [sym_pair_pattern] = STATE(1215),
    [sym__property_name] = STATE(1208),
    [sym_computed_property_name] = STATE(1208),
    [aux_sym_program_repeat1] = STATE(17),
    [aux_sym_export_statement_repeat1] = STATE(883),
    [aux_sym_object_repeat1] = STATE(1205),
    [aux_sym_object_pattern_repeat1] = STATE(1202),
    [sym_identifier] = ACTIONS(89),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_STAR] = ACTIONS(93),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_COMMA] = ACTIONS(95),
    [anon_sym_RBRACE] = ACTIONS(97),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(99),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(101),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(103),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(67),
    [anon_sym_void] = ACTIONS(67),
    [anon_sym_delete] = ACTIONS(67),
    [anon_sym_PLUS_PLUS] = ACTIONS(71),
    [anon_sym_DASH_DASH] = ACTIONS(71),
    [anon_sym_DQUOTE] = ACTIONS(73),
    [anon_sym_SQUOTE] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(77),
    [sym_number] = ACTIONS(105),
    [sym_private_property_identifier] = ACTIONS(107),
    [sym_this] = ACTIONS(81),
    [sym_super] = ACTIONS(81),
    [sym_true] = ACTIONS(81),
    [sym_false] = ACTIONS(81),
    [sym_null] = ACTIONS(81),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(109),
    [anon_sym_get] = ACTIONS(111),
    [anon_sym_set] = ACTIONS(111),
  },
  [3] = {
    [sym_export_statement] = STATE(18),
    [sym_declaration] = STATE(18),
    [sym_import] = STATE(721),
    [sym_import_statement] = STATE(18),
    [sym_expression_statement] = STATE(18),
    [sym_variable_declaration] = STATE(415),
    [sym_lexical_declaration] = STATE(415),
    [sym_statement_block] = STATE(18),
    [sym_if_statement] = STATE(18),
    [sym_switch_statement] = STATE(18),
    [sym_for_statement] = STATE(18),
    [sym_for_in_statement] = STATE(18),
    [sym_while_statement] = STATE(18),
    [sym_do_statement] = STATE(18),
    [sym_try_statement] = STATE(18),
    [sym_with_statement] = STATE(18),
    [sym_break_statement] = STATE(18),
    [sym_continue_statement] = STATE(18),
    [sym_debugger_statement] = STATE(18),
    [sym_return_statement] = STATE(18),
    [sym_throw_statement] = STATE(18),
    [sym_empty_statement] = STATE(18),
    [sym_labeled_statement] = STATE(18),
    [sym_parenthesized_expression] = STATE(479),
    [sym_expression] = STATE(674),
    [sym_primary_expression] = STATE(743),
    [sym_yield_expression] = STATE(740),
    [sym_object] = STATE(721),
    [sym_object_pattern] = STATE(1535),
    [sym_object_assignment_pattern] = STATE(1215),
    [sym_array] = STATE(721),
    [sym_array_pattern] = STATE(1535),
    [sym_jsx_element] = STATE(740),
    [sym_jsx_fragment] = STATE(740),
    [sym_jsx_opening_element] = STATE(972),
    [sym_jsx_self_closing_element] = STATE(740),
    [sym_class] = STATE(721),
    [sym_class_declaration] = STATE(415),
    [sym_function] = STATE(721),
    [sym_function_declaration] = STATE(415),
    [sym_generator_function] = STATE(721),
    [sym_generator_function_declaration] = STATE(415),
    [sym_arrow_function] = STATE(721),
    [sym_call_expression] = STATE(721),
    [sym_new_expression] = STATE(740),
    [sym_await_expression] = STATE(740),
    [sym_member_expression] = STATE(479),
    [sym_subscript_expression] = STATE(479),
    [sym_assignment_expression] = STATE(740),
    [sym__augmented_assignment_lhs] = STATE(942),
    [sym_augmented_assignment_expression] = STATE(740),
    [sym__destructuring_pattern] = STATE(1535),
    [sym_spread_element] = STATE(1277),
    [sym_ternary_expression] = STATE(740),
    [sym_binary_expression] = STATE(740),
    [sym_unary_expression] = STATE(740),
    [sym_update_expression] = STATE(740),
    [sym_sequence_expression] = STATE(1331),
    [sym_string] = STATE(796),
    [sym_template_string] = STATE(721),
    [sym_regex] = STATE(721),
    [sym_meta_property] = STATE(721),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1546),
    [sym_rest_pattern] = STATE(1215),
    [sym_method_definition] = STATE(1277),
    [sym_pair] = STATE(1277),
    [sym_pair_pattern] = STATE(1215),
    [sym__property_name] = STATE(1208),
    [sym_computed_property_name] = STATE(1208),
    [aux_sym_program_repeat1] = STATE(18),
    [aux_sym_export_statement_repeat1] = STATE(883),
    [aux_sym_object_repeat1] = STATE(1276),
    [aux_sym_object_pattern_repeat1] = STATE(1202),
    [sym_identifier] = ACTIONS(113),
    [anon_sym_export] = ACTIONS(115),
    [anon_sym_STAR] = ACTIONS(93),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_COMMA] = ACTIONS(95),
    [anon_sym_RBRACE] = ACTIONS(117),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(99),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(119),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(103),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(67),
    [anon_sym_void] = ACTIONS(67),
    [anon_sym_delete] = ACTIONS(67),
    [anon_sym_PLUS_PLUS] = ACTIONS(71),
    [anon_sym_DASH_DASH] = ACTIONS(71),
    [anon_sym_DQUOTE] = ACTIONS(73),
    [anon_sym_SQUOTE] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(77),
    [sym_number] = ACTIONS(105),
    [sym_private_property_identifier] = ACTIONS(107),
    [sym_this] = ACTIONS(81),
    [sym_super] = ACTIONS(81),
    [sym_true] = ACTIONS(81),
    [sym_false] = ACTIONS(81),
    [sym_null] = ACTIONS(81),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(121),
    [anon_sym_get] = ACTIONS(123),
    [anon_sym_set] = ACTIONS(123),
  },
  [4] = {
    [sym_export_statement] = STATE(18),
    [sym_declaration] = STATE(18),
    [sym_import] = STATE(721),
    [sym_import_statement] = STATE(18),
    [sym_expression_statement] = STATE(18),
    [sym_variable_declaration] = STATE(415),
    [sym_lexical_declaration] = STATE(415),
    [sym_statement_block] = STATE(18),
    [sym_if_statement] = STATE(18),
    [sym_switch_statement] = STATE(18),
    [sym_for_statement] = STATE(18),
    [sym_for_in_statement] = STATE(18),
    [sym_while_statement] = STATE(18),
    [sym_do_statement] = STATE(18),
    [sym_try_statement] = STATE(18),
    [sym_with_statement] = STATE(18),
    [sym_break_statement] = STATE(18),
    [sym_continue_statement] = STATE(18),
    [sym_debugger_statement] = STATE(18),
    [sym_return_statement] = STATE(18),
    [sym_throw_statement] = STATE(18),
    [sym_empty_statement] = STATE(18),
    [sym_labeled_statement] = STATE(18),
    [sym_parenthesized_expression] = STATE(479),
    [sym_expression] = STATE(674),
    [sym_primary_expression] = STATE(743),
    [sym_yield_expression] = STATE(740),
    [sym_object] = STATE(721),
    [sym_object_pattern] = STATE(1535),
    [sym_object_assignment_pattern] = STATE(1215),
    [sym_array] = STATE(721),
    [sym_array_pattern] = STATE(1535),
    [sym_jsx_element] = STATE(740),
    [sym_jsx_fragment] = STATE(740),
    [sym_jsx_opening_element] = STATE(972),
    [sym_jsx_self_closing_element] = STATE(740),
    [sym_class] = STATE(721),
    [sym_class_declaration] = STATE(415),
    [sym_function] = STATE(721),
    [sym_function_declaration] = STATE(415),
    [sym_generator_function] = STATE(721),
    [sym_generator_function_declaration] = STATE(415),
    [sym_arrow_function] = STATE(721),
    [sym_call_expression] = STATE(721),
    [sym_new_expression] = STATE(740),
    [sym_await_expression] = STATE(740),
    [sym_member_expression] = STATE(479),
    [sym_subscript_expression] = STATE(479),
    [sym_assignment_expression] = STATE(740),
    [sym__augmented_assignment_lhs] = STATE(942),
    [sym_augmented_assignment_expression] = STATE(740),
    [sym__destructuring_pattern] = STATE(1535),
    [sym_spread_element] = STATE(1277),
    [sym_ternary_expression] = STATE(740),
    [sym_binary_expression] = STATE(740),
    [sym_unary_expression] = STATE(740),
    [sym_update_expression] = STATE(740),
    [sym_sequence_expression] = STATE(1331),
    [sym_string] = STATE(796),
    [sym_template_string] = STATE(721),
    [sym_regex] = STATE(721),
    [sym_meta_property] = STATE(721),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1546),
    [sym_rest_pattern] = STATE(1215),
    [sym_method_definition] = STATE(1277),
    [sym_pair] = STATE(1277),
    [sym_pair_pattern] = STATE(1215),
    [sym__property_name] = STATE(1208),
    [sym_computed_property_name] = STATE(1208),
    [aux_sym_program_repeat1] = STATE(18),
    [aux_sym_export_statement_repeat1] = STATE(883),
    [aux_sym_object_repeat1] = STATE(1276),
    [aux_sym_object_pattern_repeat1] = STATE(1202),
    [sym_identifier] = ACTIONS(125),
    [anon_sym_export] = ACTIONS(127),
    [anon_sym_STAR] = ACTIONS(93),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_COMMA] = ACTIONS(95),
    [anon_sym_RBRACE] = ACTIONS(117),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(99),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(129),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(103),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(67),
    [anon_sym_void] = ACTIONS(67),
    [anon_sym_delete] = ACTIONS(67),
    [anon_sym_PLUS_PLUS] = ACTIONS(71),
    [anon_sym_DASH_DASH] = ACTIONS(71),
    [anon_sym_DQUOTE] = ACTIONS(73),
    [anon_sym_SQUOTE] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(77),
    [sym_number] = ACTIONS(105),
    [sym_private_property_identifier] = ACTIONS(107),
    [sym_this] = ACTIONS(81),
    [sym_super] = ACTIONS(81),
    [sym_true] = ACTIONS(81),
    [sym_false] = ACTIONS(81),
    [sym_null] = ACTIONS(81),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(131),
    [anon_sym_get] = ACTIONS(133),
    [anon_sym_set] = ACTIONS(133),
  },
  [5] = {
    [sym_export_statement] = STATE(12),
    [sym_declaration] = STATE(12),
    [sym_import] = STATE(721),
    [sym_import_statement] = STATE(12),
    [sym_expression_statement] = STATE(12),
    [sym_variable_declaration] = STATE(415),
    [sym_lexical_declaration] = STATE(415),
    [sym_statement_block] = STATE(12),
    [sym_if_statement] = STATE(12),
    [sym_switch_statement] = STATE(12),
    [sym_for_statement] = STATE(12),
    [sym_for_in_statement] = STATE(12),
    [sym_while_statement] = STATE(12),
    [sym_do_statement] = STATE(12),
    [sym_try_statement] = STATE(12),
    [sym_with_statement] = STATE(12),
    [sym_break_statement] = STATE(12),
    [sym_continue_statement] = STATE(12),
    [sym_debugger_statement] = STATE(12),
    [sym_return_statement] = STATE(12),
    [sym_throw_statement] = STATE(12),
    [sym_empty_statement] = STATE(12),
    [sym_labeled_statement] = STATE(12),
    [sym_parenthesized_expression] = STATE(479),
    [sym_expression] = STATE(674),
    [sym_primary_expression] = STATE(743),
    [sym_yield_expression] = STATE(740),
    [sym_object] = STATE(721),
    [sym_object_pattern] = STATE(1535),
    [sym_object_assignment_pattern] = STATE(1215),
    [sym_array] = STATE(721),
    [sym_array_pattern] = STATE(1535),
    [sym_jsx_element] = STATE(740),
    [sym_jsx_fragment] = STATE(740),
    [sym_jsx_opening_element] = STATE(972),
    [sym_jsx_self_closing_element] = STATE(740),
    [sym_class] = STATE(721),
    [sym_class_declaration] = STATE(415),
    [sym_function] = STATE(721),
    [sym_function_declaration] = STATE(415),
    [sym_generator_function] = STATE(721),
    [sym_generator_function_declaration] = STATE(415),
    [sym_arrow_function] = STATE(721),
    [sym_call_expression] = STATE(721),
    [sym_new_expression] = STATE(740),
    [sym_await_expression] = STATE(740),
    [sym_member_expression] = STATE(479),
    [sym_subscript_expression] = STATE(479),
    [sym_assignment_expression] = STATE(740),
    [sym__augmented_assignment_lhs] = STATE(942),
    [sym_augmented_assignment_expression] = STATE(740),
    [sym__destructuring_pattern] = STATE(1535),
    [sym_spread_element] = STATE(1214),
    [sym_ternary_expression] = STATE(740),
    [sym_binary_expression] = STATE(740),
    [sym_unary_expression] = STATE(740),
    [sym_update_expression] = STATE(740),
    [sym_sequence_expression] = STATE(1331),
    [sym_string] = STATE(796),
    [sym_template_string] = STATE(721),
    [sym_regex] = STATE(721),
    [sym_meta_property] = STATE(721),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1546),
    [sym_rest_pattern] = STATE(1215),
    [sym_method_definition] = STATE(1214),
    [sym_pair] = STATE(1214),
    [sym_pair_pattern] = STATE(1215),
    [sym__property_name] = STATE(1208),
    [sym_computed_property_name] = STATE(1208),
    [aux_sym_program_repeat1] = STATE(12),
    [aux_sym_export_statement_repeat1] = STATE(883),
    [aux_sym_object_repeat1] = STATE(1205),
    [aux_sym_object_pattern_repeat1] = STATE(1202),
    [sym_identifier] = ACTIONS(89),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_STAR] = ACTIONS(93),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_COMMA] = ACTIONS(95),
    [anon_sym_RBRACE] = ACTIONS(135),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(99),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(101),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(103),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(67),
    [anon_sym_void] = ACTIONS(67),
    [anon_sym_delete] = ACTIONS(67),
    [anon_sym_PLUS_PLUS] = ACTIONS(71),
    [anon_sym_DASH_DASH] = ACTIONS(71),
    [anon_sym_DQUOTE] = ACTIONS(73),
    [anon_sym_SQUOTE] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(77),
    [sym_number] = ACTIONS(105),
    [sym_private_property_identifier] = ACTIONS(107),
    [sym_this] = ACTIONS(81),
    [sym_super] = ACTIONS(81),
    [sym_true] = ACTIONS(81),
    [sym_false] = ACTIONS(81),
    [sym_null] = ACTIONS(81),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(109),
    [anon_sym_get] = ACTIONS(111),
    [anon_sym_set] = ACTIONS(111),
  },
  [6] = {
    [sym_export_statement] = STATE(12),
    [sym_declaration] = STATE(12),
    [sym_import] = STATE(721),
    [sym_import_statement] = STATE(12),
    [sym_expression_statement] = STATE(12),
    [sym_variable_declaration] = STATE(415),
    [sym_lexical_declaration] = STATE(415),
    [sym_statement_block] = STATE(12),
    [sym_if_statement] = STATE(12),
    [sym_switch_statement] = STATE(12),
    [sym_for_statement] = STATE(12),
    [sym_for_in_statement] = STATE(12),
    [sym_while_statement] = STATE(12),
    [sym_do_statement] = STATE(12),
    [sym_try_statement] = STATE(12),
    [sym_with_statement] = STATE(12),
    [sym_break_statement] = STATE(12),
    [sym_continue_statement] = STATE(12),
    [sym_debugger_statement] = STATE(12),
    [sym_return_statement] = STATE(12),
    [sym_throw_statement] = STATE(12),
    [sym_empty_statement] = STATE(12),
    [sym_labeled_statement] = STATE(12),
    [sym_parenthesized_expression] = STATE(479),
    [sym_expression] = STATE(674),
    [sym_primary_expression] = STATE(743),
    [sym_yield_expression] = STATE(740),
    [sym_object] = STATE(721),
    [sym_object_pattern] = STATE(1535),
    [sym_object_assignment_pattern] = STATE(1215),
    [sym_array] = STATE(721),
    [sym_array_pattern] = STATE(1535),
    [sym_jsx_element] = STATE(740),
    [sym_jsx_fragment] = STATE(740),
    [sym_jsx_opening_element] = STATE(972),
    [sym_jsx_self_closing_element] = STATE(740),
    [sym_class] = STATE(721),
    [sym_class_declaration] = STATE(415),
    [sym_function] = STATE(721),
    [sym_function_declaration] = STATE(415),
    [sym_generator_function] = STATE(721),
    [sym_generator_function_declaration] = STATE(415),
    [sym_arrow_function] = STATE(721),
    [sym_call_expression] = STATE(721),
    [sym_new_expression] = STATE(740),
    [sym_await_expression] = STATE(740),
    [sym_member_expression] = STATE(479),
    [sym_subscript_expression] = STATE(479),
    [sym_assignment_expression] = STATE(740),
    [sym__augmented_assignment_lhs] = STATE(942),
    [sym_augmented_assignment_expression] = STATE(740),
    [sym__destructuring_pattern] = STATE(1535),
    [sym_spread_element] = STATE(1214),
    [sym_ternary_expression] = STATE(740),
    [sym_binary_expression] = STATE(740),
    [sym_unary_expression] = STATE(740),
    [sym_update_expression] = STATE(740),
    [sym_sequence_expression] = STATE(1331),
    [sym_string] = STATE(796),
    [sym_template_string] = STATE(721),
    [sym_regex] = STATE(721),
    [sym_meta_property] = STATE(721),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1546),
    [sym_rest_pattern] = STATE(1215),
    [sym_method_definition] = STATE(1214),
    [sym_pair] = STATE(1214),
    [sym_pair_pattern] = STATE(1215),
    [sym__property_name] = STATE(1208),
    [sym_computed_property_name] = STATE(1208),
    [aux_sym_program_repeat1] = STATE(12),
    [aux_sym_export_statement_repeat1] = STATE(883),
    [aux_sym_object_repeat1] = STATE(1205),
    [aux_sym_object_pattern_repeat1] = STATE(1202),
    [sym_identifier] = ACTIONS(89),
    [anon_sym_export] = ACTIONS(91),
    [anon_sym_STAR] = ACTIONS(93),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_COMMA] = ACTIONS(95),
    [anon_sym_RBRACE] = ACTIONS(137),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(99),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(101),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(103),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(67),
    [anon_sym_void] = ACTIONS(67),
    [anon_sym_delete] = ACTIONS(67),
    [anon_sym_PLUS_PLUS] = ACTIONS(71),
    [anon_sym_DASH_DASH] = ACTIONS(71),
    [anon_sym_DQUOTE] = ACTIONS(73),
    [anon_sym_SQUOTE] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(77),
    [sym_number] = ACTIONS(105),
    [sym_private_property_identifier] = ACTIONS(107),
    [sym_this] = ACTIONS(81),
    [sym_super] = ACTIONS(81),
    [sym_true] = ACTIONS(81),
    [sym_false] = ACTIONS(81),
    [sym_null] = ACTIONS(81),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(109),
    [anon_sym_get] = ACTIONS(111),
    [anon_sym_set] = ACTIONS(111),
  },
  [7] = {
    [sym_export_statement] = STATE(7),
    [sym_declaration] = STATE(7),
    [sym_import] = STATE(721),
    [sym_import_statement] = STATE(7),
    [sym_expression_statement] = STATE(7),
    [sym_variable_declaration] = STATE(415),
    [sym_lexical_declaration] = STATE(415),
    [sym_statement_block] = STATE(7),
    [sym_if_statement] = STATE(7),
    [sym_switch_statement] = STATE(7),
    [sym_for_statement] = STATE(7),
    [sym_for_in_statement] = STATE(7),
    [sym_while_statement] = STATE(7),
    [sym_do_statement] = STATE(7),
    [sym_try_statement] = STATE(7),
    [sym_with_statement] = STATE(7),
    [sym_break_statement] = STATE(7),
    [sym_continue_statement] = STATE(7),
    [sym_debugger_statement] = STATE(7),
    [sym_return_statement] = STATE(7),
    [sym_throw_statement] = STATE(7),
    [sym_empty_statement] = STATE(7),
    [sym_labeled_statement] = STATE(7),
    [sym_parenthesized_expression] = STATE(479),
    [sym_expression] = STATE(674),
    [sym_primary_expression] = STATE(743),
    [sym_yield_expression] = STATE(740),
    [sym_object] = STATE(721),
    [sym_object_pattern] = STATE(1548),
    [sym_array] = STATE(721),
    [sym_array_pattern] = STATE(1548),
    [sym_jsx_element] = STATE(740),
    [sym_jsx_fragment] = STATE(740),
    [sym_jsx_opening_element] = STATE(972),
    [sym_jsx_self_closing_element] = STATE(740),
    [sym_class] = STATE(721),
    [sym_class_declaration] = STATE(415),
    [sym_function] = STATE(721),
    [sym_function_declaration] = STATE(415),
    [sym_generator_function] = STATE(721),
    [sym_generator_function_declaration] = STATE(415),
    [sym_arrow_function] = STATE(721),
    [sym_call_expression] = STATE(721),
    [sym_new_expression] = STATE(740),
    [sym_await_expression] = STATE(740),
    [sym_member_expression] = STATE(479),
    [sym_subscript_expression] = STATE(479),
    [sym_assignment_expression] = STATE(740),
    [sym__augmented_assignment_lhs] = STATE(942),
    [sym_augmented_assignment_expression] = STATE(740),
    [sym__destructuring_pattern] = STATE(1548),
    [sym_ternary_expression] = STATE(740),
    [sym_binary_expression] = STATE(740),
    [sym_unary_expression] = STATE(740),
    [sym_update_expression] = STATE(740),
    [sym_sequence_expression] = STATE(1331),
    [sym_string] = STATE(721),
    [sym_template_string] = STATE(721),
    [sym_regex] = STATE(721),
    [sym_meta_property] = STATE(721),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1546),
    [aux_sym_program_repeat1] = STATE(7),
    [aux_sym_export_statement_repeat1] = STATE(1091),
    [ts_builtin_sym_end] = ACTIONS(139),
    [sym_identifier] = ACTIONS(141),
    [anon_sym_export] = ACTIONS(144),
    [anon_sym_default] = ACTIONS(147),
    [anon_sym_LBRACE] = ACTIONS(149),
    [anon_sym_RBRACE] = ACTIONS(139),
    [anon_sym_import] = ACTIONS(152),
    [anon_sym_var] = ACTIONS(155),
    [anon_sym_let] = ACTIONS(158),
    [anon_sym_const] = ACTIONS(158),
    [anon_sym_if] = ACTIONS(161),
    [anon_sym_switch] = ACTIONS(164),
    [anon_sym_for] = ACTIONS(167),
    [anon_sym_LPAREN] = ACTIONS(170),
    [anon_sym_await] = ACTIONS(173),
    [anon_sym_while] = ACTIONS(176),
    [anon_sym_do] = ACTIONS(179),
    [anon_sym_try] = ACTIONS(182),
    [anon_sym_with] = ACTIONS(185),
    [anon_sym_break] = ACTIONS(188),
    [anon_sym_continue] = ACTIONS(191),
    [anon_sym_debugger] = ACTIONS(194),
    [anon_sym_return] = ACTIONS(197),
    [anon_sym_throw] = ACTIONS(200),
    [anon_sym_SEMI] = ACTIONS(203),
    [anon_sym_case] = ACTIONS(147),
    [anon_sym_yield] = ACTIONS(206),
    [anon_sym_LBRACK] = ACTIONS(209),
    [anon_sym_LT] = ACTIONS(212),
    [anon_sym_SLASH] = ACTIONS(215),
    [anon_sym_class] = ACTIONS(218),
    [anon_sym_async] = ACTIONS(221),
    [anon_sym_function] = ACTIONS(224),
    [anon_sym_new] = ACTIONS(227),
    [anon_sym_PLUS] = ACTIONS(230),
    [anon_sym_DASH] = ACTIONS(230),
    [anon_sym_BANG] = ACTIONS(233),
    [anon_sym_TILDE] = ACTIONS(233),
    [anon_sym_typeof] = ACTIONS(230),
    [anon_sym_void] = ACTIONS(230),
    [anon_sym_delete] = ACTIONS(230),
    [anon_sym_PLUS_PLUS] = ACTIONS(236),
    [anon_sym_DASH_DASH] = ACTIONS(236),
    [anon_sym_DQUOTE] = ACTIONS(239),
    [anon_sym_SQUOTE] = ACTIONS(242),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(245),
    [sym_number] = ACTIONS(248),
    [sym_this] = ACTIONS(251),
    [sym_super] = ACTIONS(251),
    [sym_true] = ACTIONS(251),
    [sym_false] = ACTIONS(251),
    [sym_null] = ACTIONS(251),
    [sym_undefined] = ACTIONS(254),
    [anon_sym_AT] = ACTIONS(257),
    [anon_sym_static] = ACTIONS(260),
    [anon_sym_get] = ACTIONS(260),
    [anon_sym_set] = ACTIONS(260),
  },
  [8] = {
    [sym_export_statement] = STATE(10),
    [sym_declaration] = STATE(10),
    [sym_import] = STATE(721),
    [sym_import_statement] = STATE(10),
    [sym_expression_statement] = STATE(10),
    [sym_variable_declaration] = STATE(415),
    [sym_lexical_declaration] = STATE(415),
    [sym_statement_block] = STATE(10),
    [sym_if_statement] = STATE(10),
    [sym_switch_statement] = STATE(10),
    [sym_for_statement] = STATE(10),
    [sym_for_in_statement] = STATE(10),
    [sym_while_statement] = STATE(10),
    [sym_do_statement] = STATE(10),
    [sym_try_statement] = STATE(10),
    [sym_with_statement] = STATE(10),
    [sym_break_statement] = STATE(10),
    [sym_continue_statement] = STATE(10),
    [sym_debugger_statement] = STATE(10),
    [sym_return_statement] = STATE(10),
    [sym_throw_statement] = STATE(10),
    [sym_empty_statement] = STATE(10),
    [sym_labeled_statement] = STATE(10),
    [sym_parenthesized_expression] = STATE(479),
    [sym_expression] = STATE(674),
    [sym_primary_expression] = STATE(743),
    [sym_yield_expression] = STATE(740),
    [sym_object] = STATE(721),
    [sym_object_pattern] = STATE(1548),
    [sym_array] = STATE(721),
    [sym_array_pattern] = STATE(1548),
    [sym_jsx_element] = STATE(740),
    [sym_jsx_fragment] = STATE(740),
    [sym_jsx_opening_element] = STATE(972),
    [sym_jsx_self_closing_element] = STATE(740),
    [sym_class] = STATE(721),
    [sym_class_declaration] = STATE(415),
    [sym_function] = STATE(721),
    [sym_function_declaration] = STATE(415),
    [sym_generator_function] = STATE(721),
    [sym_generator_function_declaration] = STATE(415),
    [sym_arrow_function] = STATE(721),
    [sym_call_expression] = STATE(721),
    [sym_new_expression] = STATE(740),
    [sym_await_expression] = STATE(740),
    [sym_member_expression] = STATE(479),
    [sym_subscript_expression] = STATE(479),
    [sym_assignment_expression] = STATE(740),
    [sym__augmented_assignment_lhs] = STATE(942),
    [sym_augmented_assignment_expression] = STATE(740),
    [sym__destructuring_pattern] = STATE(1548),
    [sym_ternary_expression] = STATE(740),
    [sym_binary_expression] = STATE(740),
    [sym_unary_expression] = STATE(740),
    [sym_update_expression] = STATE(740),
    [sym_sequence_expression] = STATE(1331),
    [sym_string] = STATE(721),
    [sym_template_string] = STATE(721),
    [sym_regex] = STATE(721),
    [sym_meta_property] = STATE(721),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1546),
    [aux_sym_program_repeat1] = STATE(10),
    [aux_sym_export_statement_repeat1] = STATE(1091),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_default] = ACTIONS(263),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_RBRACE] = ACTIONS(265),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_case] = ACTIONS(263),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(61),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(67),
    [anon_sym_void] = ACTIONS(67),
    [anon_sym_delete] = ACTIONS(67),
    [anon_sym_PLUS_PLUS] = ACTIONS(71),
    [anon_sym_DASH_DASH] = ACTIONS(71),
    [anon_sym_DQUOTE] = ACTIONS(73),
    [anon_sym_SQUOTE] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(77),
    [sym_number] = ACTIONS(79),
    [sym_this] = ACTIONS(81),
    [sym_super] = ACTIONS(81),
    [sym_true] = ACTIONS(81),
    [sym_false] = ACTIONS(81),
    [sym_null] = ACTIONS(81),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(87),
    [anon_sym_get] = ACTIONS(87),
    [anon_sym_set] = ACTIONS(87),
  },
  [9] = {
    [sym_export_statement] = STATE(7),
    [sym_declaration] = STATE(7),
    [sym_import] = STATE(721),
    [sym_import_statement] = STATE(7),
    [sym_expression_statement] = STATE(7),
    [sym_variable_declaration] = STATE(415),
    [sym_lexical_declaration] = STATE(415),
    [sym_statement_block] = STATE(7),
    [sym_if_statement] = STATE(7),
    [sym_switch_statement] = STATE(7),
    [sym_for_statement] = STATE(7),
    [sym_for_in_statement] = STATE(7),
    [sym_while_statement] = STATE(7),
    [sym_do_statement] = STATE(7),
    [sym_try_statement] = STATE(7),
    [sym_with_statement] = STATE(7),
    [sym_break_statement] = STATE(7),
    [sym_continue_statement] = STATE(7),
    [sym_debugger_statement] = STATE(7),
    [sym_return_statement] = STATE(7),
    [sym_throw_statement] = STATE(7),
    [sym_empty_statement] = STATE(7),
    [sym_labeled_statement] = STATE(7),
    [sym_parenthesized_expression] = STATE(479),
    [sym_expression] = STATE(674),
    [sym_primary_expression] = STATE(743),
    [sym_yield_expression] = STATE(740),
    [sym_object] = STATE(721),
    [sym_object_pattern] = STATE(1548),
    [sym_array] = STATE(721),
    [sym_array_pattern] = STATE(1548),
    [sym_jsx_element] = STATE(740),
    [sym_jsx_fragment] = STATE(740),
    [sym_jsx_opening_element] = STATE(972),
    [sym_jsx_self_closing_element] = STATE(740),
    [sym_class] = STATE(721),
    [sym_class_declaration] = STATE(415),
    [sym_function] = STATE(721),
    [sym_function_declaration] = STATE(415),
    [sym_generator_function] = STATE(721),
    [sym_generator_function_declaration] = STATE(415),
    [sym_arrow_function] = STATE(721),
    [sym_call_expression] = STATE(721),
    [sym_new_expression] = STATE(740),
    [sym_await_expression] = STATE(740),
    [sym_member_expression] = STATE(479),
    [sym_subscript_expression] = STATE(479),
    [sym_assignment_expression] = STATE(740),
    [sym__augmented_assignment_lhs] = STATE(942),
    [sym_augmented_assignment_expression] = STATE(740),
    [sym__destructuring_pattern] = STATE(1548),
    [sym_ternary_expression] = STATE(740),
    [sym_binary_expression] = STATE(740),
    [sym_unary_expression] = STATE(740),
    [sym_update_expression] = STATE(740),
    [sym_sequence_expression] = STATE(1331),
    [sym_string] = STATE(721),
    [sym_template_string] = STATE(721),
    [sym_regex] = STATE(721),
    [sym_meta_property] = STATE(721),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1546),
    [aux_sym_program_repeat1] = STATE(7),
    [aux_sym_export_statement_repeat1] = STATE(1091),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_default] = ACTIONS(267),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_RBRACE] = ACTIONS(269),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_case] = ACTIONS(267),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(61),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(67),
    [anon_sym_void] = ACTIONS(67),
    [anon_sym_delete] = ACTIONS(67),
    [anon_sym_PLUS_PLUS] = ACTIONS(71),
    [anon_sym_DASH_DASH] = ACTIONS(71),
    [anon_sym_DQUOTE] = ACTIONS(73),
    [anon_sym_SQUOTE] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(77),
    [sym_number] = ACTIONS(79),
    [sym_this] = ACTIONS(81),
    [sym_super] = ACTIONS(81),
    [sym_true] = ACTIONS(81),
    [sym_false] = ACTIONS(81),
    [sym_null] = ACTIONS(81),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(87),
    [anon_sym_get] = ACTIONS(87),
    [anon_sym_set] = ACTIONS(87),
  },
  [10] = {
    [sym_export_statement] = STATE(7),
    [sym_declaration] = STATE(7),
    [sym_import] = STATE(721),
    [sym_import_statement] = STATE(7),
    [sym_expression_statement] = STATE(7),
    [sym_variable_declaration] = STATE(415),
    [sym_lexical_declaration] = STATE(415),
    [sym_statement_block] = STATE(7),
    [sym_if_statement] = STATE(7),
    [sym_switch_statement] = STATE(7),
    [sym_for_statement] = STATE(7),
    [sym_for_in_statement] = STATE(7),
    [sym_while_statement] = STATE(7),
    [sym_do_statement] = STATE(7),
    [sym_try_statement] = STATE(7),
    [sym_with_statement] = STATE(7),
    [sym_break_statement] = STATE(7),
    [sym_continue_statement] = STATE(7),
    [sym_debugger_statement] = STATE(7),
    [sym_return_statement] = STATE(7),
    [sym_throw_statement] = STATE(7),
    [sym_empty_statement] = STATE(7),
    [sym_labeled_statement] = STATE(7),
    [sym_parenthesized_expression] = STATE(479),
    [sym_expression] = STATE(674),
    [sym_primary_expression] = STATE(743),
    [sym_yield_expression] = STATE(740),
    [sym_object] = STATE(721),
    [sym_object_pattern] = STATE(1548),
    [sym_array] = STATE(721),
    [sym_array_pattern] = STATE(1548),
    [sym_jsx_element] = STATE(740),
    [sym_jsx_fragment] = STATE(740),
    [sym_jsx_opening_element] = STATE(972),
    [sym_jsx_self_closing_element] = STATE(740),
    [sym_class] = STATE(721),
    [sym_class_declaration] = STATE(415),
    [sym_function] = STATE(721),
    [sym_function_declaration] = STATE(415),
    [sym_generator_function] = STATE(721),
    [sym_generator_function_declaration] = STATE(415),
    [sym_arrow_function] = STATE(721),
    [sym_call_expression] = STATE(721),
    [sym_new_expression] = STATE(740),
    [sym_await_expression] = STATE(740),
    [sym_member_expression] = STATE(479),
    [sym_subscript_expression] = STATE(479),
    [sym_assignment_expression] = STATE(740),
    [sym__augmented_assignment_lhs] = STATE(942),
    [sym_augmented_assignment_expression] = STATE(740),
    [sym__destructuring_pattern] = STATE(1548),
    [sym_ternary_expression] = STATE(740),
    [sym_binary_expression] = STATE(740),
    [sym_unary_expression] = STATE(740),
    [sym_update_expression] = STATE(740),
    [sym_sequence_expression] = STATE(1331),
    [sym_string] = STATE(721),
    [sym_template_string] = STATE(721),
    [sym_regex] = STATE(721),
    [sym_meta_property] = STATE(721),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1546),
    [aux_sym_program_repeat1] = STATE(7),
    [aux_sym_export_statement_repeat1] = STATE(1091),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_default] = ACTIONS(271),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_RBRACE] = ACTIONS(273),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_case] = ACTIONS(271),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(61),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(67),
    [anon_sym_void] = ACTIONS(67),
    [anon_sym_delete] = ACTIONS(67),
    [anon_sym_PLUS_PLUS] = ACTIONS(71),
    [anon_sym_DASH_DASH] = ACTIONS(71),
    [anon_sym_DQUOTE] = ACTIONS(73),
    [anon_sym_SQUOTE] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(77),
    [sym_number] = ACTIONS(79),
    [sym_this] = ACTIONS(81),
    [sym_super] = ACTIONS(81),
    [sym_true] = ACTIONS(81),
    [sym_false] = ACTIONS(81),
    [sym_null] = ACTIONS(81),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(87),
    [anon_sym_get] = ACTIONS(87),
    [anon_sym_set] = ACTIONS(87),
  },
  [11] = {
    [sym_export_statement] = STATE(9),
    [sym_declaration] = STATE(9),
    [sym_import] = STATE(721),
    [sym_import_statement] = STATE(9),
    [sym_expression_statement] = STATE(9),
    [sym_variable_declaration] = STATE(415),
    [sym_lexical_declaration] = STATE(415),
    [sym_statement_block] = STATE(9),
    [sym_if_statement] = STATE(9),
    [sym_switch_statement] = STATE(9),
    [sym_for_statement] = STATE(9),
    [sym_for_in_statement] = STATE(9),
    [sym_while_statement] = STATE(9),
    [sym_do_statement] = STATE(9),
    [sym_try_statement] = STATE(9),
    [sym_with_statement] = STATE(9),
    [sym_break_statement] = STATE(9),
    [sym_continue_statement] = STATE(9),
    [sym_debugger_statement] = STATE(9),
    [sym_return_statement] = STATE(9),
    [sym_throw_statement] = STATE(9),
    [sym_empty_statement] = STATE(9),
    [sym_labeled_statement] = STATE(9),
    [sym_parenthesized_expression] = STATE(479),
    [sym_expression] = STATE(674),
    [sym_primary_expression] = STATE(743),
    [sym_yield_expression] = STATE(740),
    [sym_object] = STATE(721),
    [sym_object_pattern] = STATE(1548),
    [sym_array] = STATE(721),
    [sym_array_pattern] = STATE(1548),
    [sym_jsx_element] = STATE(740),
    [sym_jsx_fragment] = STATE(740),
    [sym_jsx_opening_element] = STATE(972),
    [sym_jsx_self_closing_element] = STATE(740),
    [sym_class] = STATE(721),
    [sym_class_declaration] = STATE(415),
    [sym_function] = STATE(721),
    [sym_function_declaration] = STATE(415),
    [sym_generator_function] = STATE(721),
    [sym_generator_function_declaration] = STATE(415),
    [sym_arrow_function] = STATE(721),
    [sym_call_expression] = STATE(721),
    [sym_new_expression] = STATE(740),
    [sym_await_expression] = STATE(740),
    [sym_member_expression] = STATE(479),
    [sym_subscript_expression] = STATE(479),
    [sym_assignment_expression] = STATE(740),
    [sym__augmented_assignment_lhs] = STATE(942),
    [sym_augmented_assignment_expression] = STATE(740),
    [sym__destructuring_pattern] = STATE(1548),
    [sym_ternary_expression] = STATE(740),
    [sym_binary_expression] = STATE(740),
    [sym_unary_expression] = STATE(740),
    [sym_update_expression] = STATE(740),
    [sym_sequence_expression] = STATE(1331),
    [sym_string] = STATE(721),
    [sym_template_string] = STATE(721),
    [sym_regex] = STATE(721),
    [sym_meta_property] = STATE(721),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1546),
    [aux_sym_program_repeat1] = STATE(9),
    [aux_sym_export_statement_repeat1] = STATE(1091),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_default] = ACTIONS(275),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_RBRACE] = ACTIONS(277),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_case] = ACTIONS(275),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(61),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(67),
    [anon_sym_void] = ACTIONS(67),
    [anon_sym_delete] = ACTIONS(67),
    [anon_sym_PLUS_PLUS] = ACTIONS(71),
    [anon_sym_DASH_DASH] = ACTIONS(71),
    [anon_sym_DQUOTE] = ACTIONS(73),
    [anon_sym_SQUOTE] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(77),
    [sym_number] = ACTIONS(79),
    [sym_this] = ACTIONS(81),
    [sym_super] = ACTIONS(81),
    [sym_true] = ACTIONS(81),
    [sym_false] = ACTIONS(81),
    [sym_null] = ACTIONS(81),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(87),
    [anon_sym_get] = ACTIONS(87),
    [anon_sym_set] = ACTIONS(87),
  },
  [12] = {
    [sym_export_statement] = STATE(7),
    [sym_declaration] = STATE(7),
    [sym_import] = STATE(721),
    [sym_import_statement] = STATE(7),
    [sym_expression_statement] = STATE(7),
    [sym_variable_declaration] = STATE(415),
    [sym_lexical_declaration] = STATE(415),
    [sym_statement_block] = STATE(7),
    [sym_if_statement] = STATE(7),
    [sym_switch_statement] = STATE(7),
    [sym_for_statement] = STATE(7),
    [sym_for_in_statement] = STATE(7),
    [sym_while_statement] = STATE(7),
    [sym_do_statement] = STATE(7),
    [sym_try_statement] = STATE(7),
    [sym_with_statement] = STATE(7),
    [sym_break_statement] = STATE(7),
    [sym_continue_statement] = STATE(7),
    [sym_debugger_statement] = STATE(7),
    [sym_return_statement] = STATE(7),
    [sym_throw_statement] = STATE(7),
    [sym_empty_statement] = STATE(7),
    [sym_labeled_statement] = STATE(7),
    [sym_parenthesized_expression] = STATE(479),
    [sym_expression] = STATE(674),
    [sym_primary_expression] = STATE(743),
    [sym_yield_expression] = STATE(740),
    [sym_object] = STATE(721),
    [sym_object_pattern] = STATE(1548),
    [sym_array] = STATE(721),
    [sym_array_pattern] = STATE(1548),
    [sym_jsx_element] = STATE(740),
    [sym_jsx_fragment] = STATE(740),
    [sym_jsx_opening_element] = STATE(972),
    [sym_jsx_self_closing_element] = STATE(740),
    [sym_class] = STATE(721),
    [sym_class_declaration] = STATE(415),
    [sym_function] = STATE(721),
    [sym_function_declaration] = STATE(415),
    [sym_generator_function] = STATE(721),
    [sym_generator_function_declaration] = STATE(415),
    [sym_arrow_function] = STATE(721),
    [sym_call_expression] = STATE(721),
    [sym_new_expression] = STATE(740),
    [sym_await_expression] = STATE(740),
    [sym_member_expression] = STATE(479),
    [sym_subscript_expression] = STATE(479),
    [sym_assignment_expression] = STATE(740),
    [sym__augmented_assignment_lhs] = STATE(942),
    [sym_augmented_assignment_expression] = STATE(740),
    [sym__destructuring_pattern] = STATE(1548),
    [sym_ternary_expression] = STATE(740),
    [sym_binary_expression] = STATE(740),
    [sym_unary_expression] = STATE(740),
    [sym_update_expression] = STATE(740),
    [sym_sequence_expression] = STATE(1331),
    [sym_string] = STATE(721),
    [sym_template_string] = STATE(721),
    [sym_regex] = STATE(721),
    [sym_meta_property] = STATE(721),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1546),
    [aux_sym_program_repeat1] = STATE(7),
    [aux_sym_export_statement_repeat1] = STATE(1091),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_RBRACE] = ACTIONS(279),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(61),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(67),
    [anon_sym_void] = ACTIONS(67),
    [anon_sym_delete] = ACTIONS(67),
    [anon_sym_PLUS_PLUS] = ACTIONS(71),
    [anon_sym_DASH_DASH] = ACTIONS(71),
    [anon_sym_DQUOTE] = ACTIONS(73),
    [anon_sym_SQUOTE] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(77),
    [sym_number] = ACTIONS(79),
    [sym_this] = ACTIONS(81),
    [sym_super] = ACTIONS(81),
    [sym_true] = ACTIONS(81),
    [sym_false] = ACTIONS(81),
    [sym_null] = ACTIONS(81),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(87),
    [anon_sym_get] = ACTIONS(87),
    [anon_sym_set] = ACTIONS(87),
  },
  [13] = {
    [sym_export_statement] = STATE(14),
    [sym_declaration] = STATE(14),
    [sym_import] = STATE(721),
    [sym_import_statement] = STATE(14),
    [sym_expression_statement] = STATE(14),
    [sym_variable_declaration] = STATE(415),
    [sym_lexical_declaration] = STATE(415),
    [sym_statement_block] = STATE(14),
    [sym_if_statement] = STATE(14),
    [sym_switch_statement] = STATE(14),
    [sym_for_statement] = STATE(14),
    [sym_for_in_statement] = STATE(14),
    [sym_while_statement] = STATE(14),
    [sym_do_statement] = STATE(14),
    [sym_try_statement] = STATE(14),
    [sym_with_statement] = STATE(14),
    [sym_break_statement] = STATE(14),
    [sym_continue_statement] = STATE(14),
    [sym_debugger_statement] = STATE(14),
    [sym_return_statement] = STATE(14),
    [sym_throw_statement] = STATE(14),
    [sym_empty_statement] = STATE(14),
    [sym_labeled_statement] = STATE(14),
    [sym_parenthesized_expression] = STATE(479),
    [sym_expression] = STATE(674),
    [sym_primary_expression] = STATE(743),
    [sym_yield_expression] = STATE(740),
    [sym_object] = STATE(721),
    [sym_object_pattern] = STATE(1548),
    [sym_array] = STATE(721),
    [sym_array_pattern] = STATE(1548),
    [sym_jsx_element] = STATE(740),
    [sym_jsx_fragment] = STATE(740),
    [sym_jsx_opening_element] = STATE(972),
    [sym_jsx_self_closing_element] = STATE(740),
    [sym_class] = STATE(721),
    [sym_class_declaration] = STATE(415),
    [sym_function] = STATE(721),
    [sym_function_declaration] = STATE(415),
    [sym_generator_function] = STATE(721),
    [sym_generator_function_declaration] = STATE(415),
    [sym_arrow_function] = STATE(721),
    [sym_call_expression] = STATE(721),
    [sym_new_expression] = STATE(740),
    [sym_await_expression] = STATE(740),
    [sym_member_expression] = STATE(479),
    [sym_subscript_expression] = STATE(479),
    [sym_assignment_expression] = STATE(740),
    [sym__augmented_assignment_lhs] = STATE(942),
    [sym_augmented_assignment_expression] = STATE(740),
    [sym__destructuring_pattern] = STATE(1548),
    [sym_ternary_expression] = STATE(740),
    [sym_binary_expression] = STATE(740),
    [sym_unary_expression] = STATE(740),
    [sym_update_expression] = STATE(740),
    [sym_sequence_expression] = STATE(1331),
    [sym_string] = STATE(721),
    [sym_template_string] = STATE(721),
    [sym_regex] = STATE(721),
    [sym_meta_property] = STATE(721),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1546),
    [aux_sym_program_repeat1] = STATE(14),
    [aux_sym_export_statement_repeat1] = STATE(1091),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_RBRACE] = ACTIONS(281),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(61),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(67),
    [anon_sym_void] = ACTIONS(67),
    [anon_sym_delete] = ACTIONS(67),
    [anon_sym_PLUS_PLUS] = ACTIONS(71),
    [anon_sym_DASH_DASH] = ACTIONS(71),
    [anon_sym_DQUOTE] = ACTIONS(73),
    [anon_sym_SQUOTE] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(77),
    [sym_number] = ACTIONS(79),
    [sym_this] = ACTIONS(81),
    [sym_super] = ACTIONS(81),
    [sym_true] = ACTIONS(81),
    [sym_false] = ACTIONS(81),
    [sym_null] = ACTIONS(81),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(87),
    [anon_sym_get] = ACTIONS(87),
    [anon_sym_set] = ACTIONS(87),
  },
  [14] = {
    [sym_export_statement] = STATE(7),
    [sym_declaration] = STATE(7),
    [sym_import] = STATE(721),
    [sym_import_statement] = STATE(7),
    [sym_expression_statement] = STATE(7),
    [sym_variable_declaration] = STATE(415),
    [sym_lexical_declaration] = STATE(415),
    [sym_statement_block] = STATE(7),
    [sym_if_statement] = STATE(7),
    [sym_switch_statement] = STATE(7),
    [sym_for_statement] = STATE(7),
    [sym_for_in_statement] = STATE(7),
    [sym_while_statement] = STATE(7),
    [sym_do_statement] = STATE(7),
    [sym_try_statement] = STATE(7),
    [sym_with_statement] = STATE(7),
    [sym_break_statement] = STATE(7),
    [sym_continue_statement] = STATE(7),
    [sym_debugger_statement] = STATE(7),
    [sym_return_statement] = STATE(7),
    [sym_throw_statement] = STATE(7),
    [sym_empty_statement] = STATE(7),
    [sym_labeled_statement] = STATE(7),
    [sym_parenthesized_expression] = STATE(479),
    [sym_expression] = STATE(674),
    [sym_primary_expression] = STATE(743),
    [sym_yield_expression] = STATE(740),
    [sym_object] = STATE(721),
    [sym_object_pattern] = STATE(1548),
    [sym_array] = STATE(721),
    [sym_array_pattern] = STATE(1548),
    [sym_jsx_element] = STATE(740),
    [sym_jsx_fragment] = STATE(740),
    [sym_jsx_opening_element] = STATE(972),
    [sym_jsx_self_closing_element] = STATE(740),
    [sym_class] = STATE(721),
    [sym_class_declaration] = STATE(415),
    [sym_function] = STATE(721),
    [sym_function_declaration] = STATE(415),
    [sym_generator_function] = STATE(721),
    [sym_generator_function_declaration] = STATE(415),
    [sym_arrow_function] = STATE(721),
    [sym_call_expression] = STATE(721),
    [sym_new_expression] = STATE(740),
    [sym_await_expression] = STATE(740),
    [sym_member_expression] = STATE(479),
    [sym_subscript_expression] = STATE(479),
    [sym_assignment_expression] = STATE(740),
    [sym__augmented_assignment_lhs] = STATE(942),
    [sym_augmented_assignment_expression] = STATE(740),
    [sym__destructuring_pattern] = STATE(1548),
    [sym_ternary_expression] = STATE(740),
    [sym_binary_expression] = STATE(740),
    [sym_unary_expression] = STATE(740),
    [sym_update_expression] = STATE(740),
    [sym_sequence_expression] = STATE(1331),
    [sym_string] = STATE(721),
    [sym_template_string] = STATE(721),
    [sym_regex] = STATE(721),
    [sym_meta_property] = STATE(721),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1546),
    [aux_sym_program_repeat1] = STATE(7),
    [aux_sym_export_statement_repeat1] = STATE(1091),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_RBRACE] = ACTIONS(283),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(61),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(67),
    [anon_sym_void] = ACTIONS(67),
    [anon_sym_delete] = ACTIONS(67),
    [anon_sym_PLUS_PLUS] = ACTIONS(71),
    [anon_sym_DASH_DASH] = ACTIONS(71),
    [anon_sym_DQUOTE] = ACTIONS(73),
    [anon_sym_SQUOTE] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(77),
    [sym_number] = ACTIONS(79),
    [sym_this] = ACTIONS(81),
    [sym_super] = ACTIONS(81),
    [sym_true] = ACTIONS(81),
    [sym_false] = ACTIONS(81),
    [sym_null] = ACTIONS(81),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(87),
    [anon_sym_get] = ACTIONS(87),
    [anon_sym_set] = ACTIONS(87),
  },
  [15] = {
    [sym_export_statement] = STATE(19),
    [sym_declaration] = STATE(19),
    [sym_import] = STATE(721),
    [sym_import_statement] = STATE(19),
    [sym_expression_statement] = STATE(19),
    [sym_variable_declaration] = STATE(415),
    [sym_lexical_declaration] = STATE(415),
    [sym_statement_block] = STATE(19),
    [sym_if_statement] = STATE(19),
    [sym_switch_statement] = STATE(19),
    [sym_for_statement] = STATE(19),
    [sym_for_in_statement] = STATE(19),
    [sym_while_statement] = STATE(19),
    [sym_do_statement] = STATE(19),
    [sym_try_statement] = STATE(19),
    [sym_with_statement] = STATE(19),
    [sym_break_statement] = STATE(19),
    [sym_continue_statement] = STATE(19),
    [sym_debugger_statement] = STATE(19),
    [sym_return_statement] = STATE(19),
    [sym_throw_statement] = STATE(19),
    [sym_empty_statement] = STATE(19),
    [sym_labeled_statement] = STATE(19),
    [sym_parenthesized_expression] = STATE(479),
    [sym_expression] = STATE(674),
    [sym_primary_expression] = STATE(743),
    [sym_yield_expression] = STATE(740),
    [sym_object] = STATE(721),
    [sym_object_pattern] = STATE(1548),
    [sym_array] = STATE(721),
    [sym_array_pattern] = STATE(1548),
    [sym_jsx_element] = STATE(740),
    [sym_jsx_fragment] = STATE(740),
    [sym_jsx_opening_element] = STATE(972),
    [sym_jsx_self_closing_element] = STATE(740),
    [sym_class] = STATE(721),
    [sym_class_declaration] = STATE(415),
    [sym_function] = STATE(721),
    [sym_function_declaration] = STATE(415),
    [sym_generator_function] = STATE(721),
    [sym_generator_function_declaration] = STATE(415),
    [sym_arrow_function] = STATE(721),
    [sym_call_expression] = STATE(721),
    [sym_new_expression] = STATE(740),
    [sym_await_expression] = STATE(740),
    [sym_member_expression] = STATE(479),
    [sym_subscript_expression] = STATE(479),
    [sym_assignment_expression] = STATE(740),
    [sym__augmented_assignment_lhs] = STATE(942),
    [sym_augmented_assignment_expression] = STATE(740),
    [sym__destructuring_pattern] = STATE(1548),
    [sym_ternary_expression] = STATE(740),
    [sym_binary_expression] = STATE(740),
    [sym_unary_expression] = STATE(740),
    [sym_update_expression] = STATE(740),
    [sym_sequence_expression] = STATE(1331),
    [sym_string] = STATE(721),
    [sym_template_string] = STATE(721),
    [sym_regex] = STATE(721),
    [sym_meta_property] = STATE(721),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1546),
    [aux_sym_program_repeat1] = STATE(19),
    [aux_sym_export_statement_repeat1] = STATE(1091),
    [ts_builtin_sym_end] = ACTIONS(285),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(61),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(67),
    [anon_sym_void] = ACTIONS(67),
    [anon_sym_delete] = ACTIONS(67),
    [anon_sym_PLUS_PLUS] = ACTIONS(71),
    [anon_sym_DASH_DASH] = ACTIONS(71),
    [anon_sym_DQUOTE] = ACTIONS(73),
    [anon_sym_SQUOTE] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(77),
    [sym_number] = ACTIONS(79),
    [sym_this] = ACTIONS(81),
    [sym_super] = ACTIONS(81),
    [sym_true] = ACTIONS(81),
    [sym_false] = ACTIONS(81),
    [sym_null] = ACTIONS(81),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(87),
    [anon_sym_get] = ACTIONS(87),
    [anon_sym_set] = ACTIONS(87),
  },
  [16] = {
    [sym_export_statement] = STATE(17),
    [sym_declaration] = STATE(17),
    [sym_import] = STATE(721),
    [sym_import_statement] = STATE(17),
    [sym_expression_statement] = STATE(17),
    [sym_variable_declaration] = STATE(415),
    [sym_lexical_declaration] = STATE(415),
    [sym_statement_block] = STATE(17),
    [sym_if_statement] = STATE(17),
    [sym_switch_statement] = STATE(17),
    [sym_for_statement] = STATE(17),
    [sym_for_in_statement] = STATE(17),
    [sym_while_statement] = STATE(17),
    [sym_do_statement] = STATE(17),
    [sym_try_statement] = STATE(17),
    [sym_with_statement] = STATE(17),
    [sym_break_statement] = STATE(17),
    [sym_continue_statement] = STATE(17),
    [sym_debugger_statement] = STATE(17),
    [sym_return_statement] = STATE(17),
    [sym_throw_statement] = STATE(17),
    [sym_empty_statement] = STATE(17),
    [sym_labeled_statement] = STATE(17),
    [sym_parenthesized_expression] = STATE(479),
    [sym_expression] = STATE(674),
    [sym_primary_expression] = STATE(743),
    [sym_yield_expression] = STATE(740),
    [sym_object] = STATE(721),
    [sym_object_pattern] = STATE(1548),
    [sym_array] = STATE(721),
    [sym_array_pattern] = STATE(1548),
    [sym_jsx_element] = STATE(740),
    [sym_jsx_fragment] = STATE(740),
    [sym_jsx_opening_element] = STATE(972),
    [sym_jsx_self_closing_element] = STATE(740),
    [sym_class] = STATE(721),
    [sym_class_declaration] = STATE(415),
    [sym_function] = STATE(721),
    [sym_function_declaration] = STATE(415),
    [sym_generator_function] = STATE(721),
    [sym_generator_function_declaration] = STATE(415),
    [sym_arrow_function] = STATE(721),
    [sym_call_expression] = STATE(721),
    [sym_new_expression] = STATE(740),
    [sym_await_expression] = STATE(740),
    [sym_member_expression] = STATE(479),
    [sym_subscript_expression] = STATE(479),
    [sym_assignment_expression] = STATE(740),
    [sym__augmented_assignment_lhs] = STATE(942),
    [sym_augmented_assignment_expression] = STATE(740),
    [sym__destructuring_pattern] = STATE(1548),
    [sym_ternary_expression] = STATE(740),
    [sym_binary_expression] = STATE(740),
    [sym_unary_expression] = STATE(740),
    [sym_update_expression] = STATE(740),
    [sym_sequence_expression] = STATE(1331),
    [sym_string] = STATE(721),
    [sym_template_string] = STATE(721),
    [sym_regex] = STATE(721),
    [sym_meta_property] = STATE(721),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1546),
    [aux_sym_program_repeat1] = STATE(17),
    [aux_sym_export_statement_repeat1] = STATE(1091),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_RBRACE] = ACTIONS(287),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(61),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(67),
    [anon_sym_void] = ACTIONS(67),
    [anon_sym_delete] = ACTIONS(67),
    [anon_sym_PLUS_PLUS] = ACTIONS(71),
    [anon_sym_DASH_DASH] = ACTIONS(71),
    [anon_sym_DQUOTE] = ACTIONS(73),
    [anon_sym_SQUOTE] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(77),
    [sym_number] = ACTIONS(79),
    [sym_this] = ACTIONS(81),
    [sym_super] = ACTIONS(81),
    [sym_true] = ACTIONS(81),
    [sym_false] = ACTIONS(81),
    [sym_null] = ACTIONS(81),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(87),
    [anon_sym_get] = ACTIONS(87),
    [anon_sym_set] = ACTIONS(87),
  },
  [17] = {
    [sym_export_statement] = STATE(7),
    [sym_declaration] = STATE(7),
    [sym_import] = STATE(721),
    [sym_import_statement] = STATE(7),
    [sym_expression_statement] = STATE(7),
    [sym_variable_declaration] = STATE(415),
    [sym_lexical_declaration] = STATE(415),
    [sym_statement_block] = STATE(7),
    [sym_if_statement] = STATE(7),
    [sym_switch_statement] = STATE(7),
    [sym_for_statement] = STATE(7),
    [sym_for_in_statement] = STATE(7),
    [sym_while_statement] = STATE(7),
    [sym_do_statement] = STATE(7),
    [sym_try_statement] = STATE(7),
    [sym_with_statement] = STATE(7),
    [sym_break_statement] = STATE(7),
    [sym_continue_statement] = STATE(7),
    [sym_debugger_statement] = STATE(7),
    [sym_return_statement] = STATE(7),
    [sym_throw_statement] = STATE(7),
    [sym_empty_statement] = STATE(7),
    [sym_labeled_statement] = STATE(7),
    [sym_parenthesized_expression] = STATE(479),
    [sym_expression] = STATE(674),
    [sym_primary_expression] = STATE(743),
    [sym_yield_expression] = STATE(740),
    [sym_object] = STATE(721),
    [sym_object_pattern] = STATE(1548),
    [sym_array] = STATE(721),
    [sym_array_pattern] = STATE(1548),
    [sym_jsx_element] = STATE(740),
    [sym_jsx_fragment] = STATE(740),
    [sym_jsx_opening_element] = STATE(972),
    [sym_jsx_self_closing_element] = STATE(740),
    [sym_class] = STATE(721),
    [sym_class_declaration] = STATE(415),
    [sym_function] = STATE(721),
    [sym_function_declaration] = STATE(415),
    [sym_generator_function] = STATE(721),
    [sym_generator_function_declaration] = STATE(415),
    [sym_arrow_function] = STATE(721),
    [sym_call_expression] = STATE(721),
    [sym_new_expression] = STATE(740),
    [sym_await_expression] = STATE(740),
    [sym_member_expression] = STATE(479),
    [sym_subscript_expression] = STATE(479),
    [sym_assignment_expression] = STATE(740),
    [sym__augmented_assignment_lhs] = STATE(942),
    [sym_augmented_assignment_expression] = STATE(740),
    [sym__destructuring_pattern] = STATE(1548),
    [sym_ternary_expression] = STATE(740),
    [sym_binary_expression] = STATE(740),
    [sym_unary_expression] = STATE(740),
    [sym_update_expression] = STATE(740),
    [sym_sequence_expression] = STATE(1331),
    [sym_string] = STATE(721),
    [sym_template_string] = STATE(721),
    [sym_regex] = STATE(721),
    [sym_meta_property] = STATE(721),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1546),
    [aux_sym_program_repeat1] = STATE(7),
    [aux_sym_export_statement_repeat1] = STATE(1091),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_RBRACE] = ACTIONS(289),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(61),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(67),
    [anon_sym_void] = ACTIONS(67),
    [anon_sym_delete] = ACTIONS(67),
    [anon_sym_PLUS_PLUS] = ACTIONS(71),
    [anon_sym_DASH_DASH] = ACTIONS(71),
    [anon_sym_DQUOTE] = ACTIONS(73),
    [anon_sym_SQUOTE] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(77),
    [sym_number] = ACTIONS(79),
    [sym_this] = ACTIONS(81),
    [sym_super] = ACTIONS(81),
    [sym_true] = ACTIONS(81),
    [sym_false] = ACTIONS(81),
    [sym_null] = ACTIONS(81),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(87),
    [anon_sym_get] = ACTIONS(87),
    [anon_sym_set] = ACTIONS(87),
  },
  [18] = {
    [sym_export_statement] = STATE(7),
    [sym_declaration] = STATE(7),
    [sym_import] = STATE(721),
    [sym_import_statement] = STATE(7),
    [sym_expression_statement] = STATE(7),
    [sym_variable_declaration] = STATE(415),
    [sym_lexical_declaration] = STATE(415),
    [sym_statement_block] = STATE(7),
    [sym_if_statement] = STATE(7),
    [sym_switch_statement] = STATE(7),
    [sym_for_statement] = STATE(7),
    [sym_for_in_statement] = STATE(7),
    [sym_while_statement] = STATE(7),
    [sym_do_statement] = STATE(7),
    [sym_try_statement] = STATE(7),
    [sym_with_statement] = STATE(7),
    [sym_break_statement] = STATE(7),
    [sym_continue_statement] = STATE(7),
    [sym_debugger_statement] = STATE(7),
    [sym_return_statement] = STATE(7),
    [sym_throw_statement] = STATE(7),
    [sym_empty_statement] = STATE(7),
    [sym_labeled_statement] = STATE(7),
    [sym_parenthesized_expression] = STATE(479),
    [sym_expression] = STATE(674),
    [sym_primary_expression] = STATE(743),
    [sym_yield_expression] = STATE(740),
    [sym_object] = STATE(721),
    [sym_object_pattern] = STATE(1548),
    [sym_array] = STATE(721),
    [sym_array_pattern] = STATE(1548),
    [sym_jsx_element] = STATE(740),
    [sym_jsx_fragment] = STATE(740),
    [sym_jsx_opening_element] = STATE(972),
    [sym_jsx_self_closing_element] = STATE(740),
    [sym_class] = STATE(721),
    [sym_class_declaration] = STATE(415),
    [sym_function] = STATE(721),
    [sym_function_declaration] = STATE(415),
    [sym_generator_function] = STATE(721),
    [sym_generator_function_declaration] = STATE(415),
    [sym_arrow_function] = STATE(721),
    [sym_call_expression] = STATE(721),
    [sym_new_expression] = STATE(740),
    [sym_await_expression] = STATE(740),
    [sym_member_expression] = STATE(479),
    [sym_subscript_expression] = STATE(479),
    [sym_assignment_expression] = STATE(740),
    [sym__augmented_assignment_lhs] = STATE(942),
    [sym_augmented_assignment_expression] = STATE(740),
    [sym__destructuring_pattern] = STATE(1548),
    [sym_ternary_expression] = STATE(740),
    [sym_binary_expression] = STATE(740),
    [sym_unary_expression] = STATE(740),
    [sym_update_expression] = STATE(740),
    [sym_sequence_expression] = STATE(1331),
    [sym_string] = STATE(721),
    [sym_template_string] = STATE(721),
    [sym_regex] = STATE(721),
    [sym_meta_property] = STATE(721),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1546),
    [aux_sym_program_repeat1] = STATE(7),
    [aux_sym_export_statement_repeat1] = STATE(1091),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_RBRACE] = ACTIONS(291),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(61),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(67),
    [anon_sym_void] = ACTIONS(67),
    [anon_sym_delete] = ACTIONS(67),
    [anon_sym_PLUS_PLUS] = ACTIONS(71),
    [anon_sym_DASH_DASH] = ACTIONS(71),
    [anon_sym_DQUOTE] = ACTIONS(73),
    [anon_sym_SQUOTE] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(77),
    [sym_number] = ACTIONS(79),
    [sym_this] = ACTIONS(81),
    [sym_super] = ACTIONS(81),
    [sym_true] = ACTIONS(81),
    [sym_false] = ACTIONS(81),
    [sym_null] = ACTIONS(81),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(87),
    [anon_sym_get] = ACTIONS(87),
    [anon_sym_set] = ACTIONS(87),
  },
  [19] = {
    [sym_export_statement] = STATE(7),
    [sym_declaration] = STATE(7),
    [sym_import] = STATE(721),
    [sym_import_statement] = STATE(7),
    [sym_expression_statement] = STATE(7),
    [sym_variable_declaration] = STATE(415),
    [sym_lexical_declaration] = STATE(415),
    [sym_statement_block] = STATE(7),
    [sym_if_statement] = STATE(7),
    [sym_switch_statement] = STATE(7),
    [sym_for_statement] = STATE(7),
    [sym_for_in_statement] = STATE(7),
    [sym_while_statement] = STATE(7),
    [sym_do_statement] = STATE(7),
    [sym_try_statement] = STATE(7),
    [sym_with_statement] = STATE(7),
    [sym_break_statement] = STATE(7),
    [sym_continue_statement] = STATE(7),
    [sym_debugger_statement] = STATE(7),
    [sym_return_statement] = STATE(7),
    [sym_throw_statement] = STATE(7),
    [sym_empty_statement] = STATE(7),
    [sym_labeled_statement] = STATE(7),
    [sym_parenthesized_expression] = STATE(479),
    [sym_expression] = STATE(674),
    [sym_primary_expression] = STATE(743),
    [sym_yield_expression] = STATE(740),
    [sym_object] = STATE(721),
    [sym_object_pattern] = STATE(1548),
    [sym_array] = STATE(721),
    [sym_array_pattern] = STATE(1548),
    [sym_jsx_element] = STATE(740),
    [sym_jsx_fragment] = STATE(740),
    [sym_jsx_opening_element] = STATE(972),
    [sym_jsx_self_closing_element] = STATE(740),
    [sym_class] = STATE(721),
    [sym_class_declaration] = STATE(415),
    [sym_function] = STATE(721),
    [sym_function_declaration] = STATE(415),
    [sym_generator_function] = STATE(721),
    [sym_generator_function_declaration] = STATE(415),
    [sym_arrow_function] = STATE(721),
    [sym_call_expression] = STATE(721),
    [sym_new_expression] = STATE(740),
    [sym_await_expression] = STATE(740),
    [sym_member_expression] = STATE(479),
    [sym_subscript_expression] = STATE(479),
    [sym_assignment_expression] = STATE(740),
    [sym__augmented_assignment_lhs] = STATE(942),
    [sym_augmented_assignment_expression] = STATE(740),
    [sym__destructuring_pattern] = STATE(1548),
    [sym_ternary_expression] = STATE(740),
    [sym_binary_expression] = STATE(740),
    [sym_unary_expression] = STATE(740),
    [sym_update_expression] = STATE(740),
    [sym_sequence_expression] = STATE(1331),
    [sym_string] = STATE(721),
    [sym_template_string] = STATE(721),
    [sym_regex] = STATE(721),
    [sym_meta_property] = STATE(721),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1546),
    [aux_sym_program_repeat1] = STATE(7),
    [aux_sym_export_statement_repeat1] = STATE(1091),
    [ts_builtin_sym_end] = ACTIONS(293),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(61),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(67),
    [anon_sym_void] = ACTIONS(67),
    [anon_sym_delete] = ACTIONS(67),
    [anon_sym_PLUS_PLUS] = ACTIONS(71),
    [anon_sym_DASH_DASH] = ACTIONS(71),
    [anon_sym_DQUOTE] = ACTIONS(73),
    [anon_sym_SQUOTE] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(77),
    [sym_number] = ACTIONS(79),
    [sym_this] = ACTIONS(81),
    [sym_super] = ACTIONS(81),
    [sym_true] = ACTIONS(81),
    [sym_false] = ACTIONS(81),
    [sym_null] = ACTIONS(81),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(87),
    [anon_sym_get] = ACTIONS(87),
    [anon_sym_set] = ACTIONS(87),
  },
  [20] = {
    [sym_export_statement] = STATE(7),
    [sym_declaration] = STATE(7),
    [sym_import] = STATE(721),
    [sym_import_statement] = STATE(7),
    [sym_expression_statement] = STATE(7),
    [sym_variable_declaration] = STATE(415),
    [sym_lexical_declaration] = STATE(415),
    [sym_statement_block] = STATE(7),
    [sym_if_statement] = STATE(7),
    [sym_switch_statement] = STATE(7),
    [sym_for_statement] = STATE(7),
    [sym_for_in_statement] = STATE(7),
    [sym_while_statement] = STATE(7),
    [sym_do_statement] = STATE(7),
    [sym_try_statement] = STATE(7),
    [sym_with_statement] = STATE(7),
    [sym_break_statement] = STATE(7),
    [sym_continue_statement] = STATE(7),
    [sym_debugger_statement] = STATE(7),
    [sym_return_statement] = STATE(7),
    [sym_throw_statement] = STATE(7),
    [sym_empty_statement] = STATE(7),
    [sym_labeled_statement] = STATE(7),
    [sym_parenthesized_expression] = STATE(479),
    [sym_expression] = STATE(674),
    [sym_primary_expression] = STATE(743),
    [sym_yield_expression] = STATE(740),
    [sym_object] = STATE(721),
    [sym_object_pattern] = STATE(1548),
    [sym_array] = STATE(721),
    [sym_array_pattern] = STATE(1548),
    [sym_jsx_element] = STATE(740),
    [sym_jsx_fragment] = STATE(740),
    [sym_jsx_opening_element] = STATE(972),
    [sym_jsx_self_closing_element] = STATE(740),
    [sym_class] = STATE(721),
    [sym_class_declaration] = STATE(415),
    [sym_function] = STATE(721),
    [sym_function_declaration] = STATE(415),
    [sym_generator_function] = STATE(721),
    [sym_generator_function_declaration] = STATE(415),
    [sym_arrow_function] = STATE(721),
    [sym_call_expression] = STATE(721),
    [sym_new_expression] = STATE(740),
    [sym_await_expression] = STATE(740),
    [sym_member_expression] = STATE(479),
    [sym_subscript_expression] = STATE(479),
    [sym_assignment_expression] = STATE(740),
    [sym__augmented_assignment_lhs] = STATE(942),
    [sym_augmented_assignment_expression] = STATE(740),
    [sym__destructuring_pattern] = STATE(1548),
    [sym_ternary_expression] = STATE(740),
    [sym_binary_expression] = STATE(740),
    [sym_unary_expression] = STATE(740),
    [sym_update_expression] = STATE(740),
    [sym_sequence_expression] = STATE(1331),
    [sym_string] = STATE(721),
    [sym_template_string] = STATE(721),
    [sym_regex] = STATE(721),
    [sym_meta_property] = STATE(721),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1546),
    [aux_sym_program_repeat1] = STATE(7),
    [aux_sym_export_statement_repeat1] = STATE(1091),
    [ts_builtin_sym_end] = ACTIONS(285),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(61),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(67),
    [anon_sym_void] = ACTIONS(67),
    [anon_sym_delete] = ACTIONS(67),
    [anon_sym_PLUS_PLUS] = ACTIONS(71),
    [anon_sym_DASH_DASH] = ACTIONS(71),
    [anon_sym_DQUOTE] = ACTIONS(73),
    [anon_sym_SQUOTE] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(77),
    [sym_number] = ACTIONS(79),
    [sym_this] = ACTIONS(81),
    [sym_super] = ACTIONS(81),
    [sym_true] = ACTIONS(81),
    [sym_false] = ACTIONS(81),
    [sym_null] = ACTIONS(81),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(87),
    [anon_sym_get] = ACTIONS(87),
    [anon_sym_set] = ACTIONS(87),
  },
  [21] = {
    [sym_export_statement] = STATE(18),
    [sym_declaration] = STATE(18),
    [sym_import] = STATE(721),
    [sym_import_statement] = STATE(18),
    [sym_expression_statement] = STATE(18),
    [sym_variable_declaration] = STATE(415),
    [sym_lexical_declaration] = STATE(415),
    [sym_statement_block] = STATE(18),
    [sym_if_statement] = STATE(18),
    [sym_switch_statement] = STATE(18),
    [sym_for_statement] = STATE(18),
    [sym_for_in_statement] = STATE(18),
    [sym_while_statement] = STATE(18),
    [sym_do_statement] = STATE(18),
    [sym_try_statement] = STATE(18),
    [sym_with_statement] = STATE(18),
    [sym_break_statement] = STATE(18),
    [sym_continue_statement] = STATE(18),
    [sym_debugger_statement] = STATE(18),
    [sym_return_statement] = STATE(18),
    [sym_throw_statement] = STATE(18),
    [sym_empty_statement] = STATE(18),
    [sym_labeled_statement] = STATE(18),
    [sym_parenthesized_expression] = STATE(479),
    [sym_expression] = STATE(674),
    [sym_primary_expression] = STATE(743),
    [sym_yield_expression] = STATE(740),
    [sym_object] = STATE(721),
    [sym_object_pattern] = STATE(1548),
    [sym_array] = STATE(721),
    [sym_array_pattern] = STATE(1548),
    [sym_jsx_element] = STATE(740),
    [sym_jsx_fragment] = STATE(740),
    [sym_jsx_opening_element] = STATE(972),
    [sym_jsx_self_closing_element] = STATE(740),
    [sym_class] = STATE(721),
    [sym_class_declaration] = STATE(415),
    [sym_function] = STATE(721),
    [sym_function_declaration] = STATE(415),
    [sym_generator_function] = STATE(721),
    [sym_generator_function_declaration] = STATE(415),
    [sym_arrow_function] = STATE(721),
    [sym_call_expression] = STATE(721),
    [sym_new_expression] = STATE(740),
    [sym_await_expression] = STATE(740),
    [sym_member_expression] = STATE(479),
    [sym_subscript_expression] = STATE(479),
    [sym_assignment_expression] = STATE(740),
    [sym__augmented_assignment_lhs] = STATE(942),
    [sym_augmented_assignment_expression] = STATE(740),
    [sym__destructuring_pattern] = STATE(1548),
    [sym_ternary_expression] = STATE(740),
    [sym_binary_expression] = STATE(740),
    [sym_unary_expression] = STATE(740),
    [sym_update_expression] = STATE(740),
    [sym_sequence_expression] = STATE(1331),
    [sym_string] = STATE(721),
    [sym_template_string] = STATE(721),
    [sym_regex] = STATE(721),
    [sym_meta_property] = STATE(721),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1546),
    [aux_sym_program_repeat1] = STATE(18),
    [aux_sym_export_statement_repeat1] = STATE(1091),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_RBRACE] = ACTIONS(295),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(61),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(67),
    [anon_sym_void] = ACTIONS(67),
    [anon_sym_delete] = ACTIONS(67),
    [anon_sym_PLUS_PLUS] = ACTIONS(71),
    [anon_sym_DASH_DASH] = ACTIONS(71),
    [anon_sym_DQUOTE] = ACTIONS(73),
    [anon_sym_SQUOTE] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(77),
    [sym_number] = ACTIONS(79),
    [sym_this] = ACTIONS(81),
    [sym_super] = ACTIONS(81),
    [sym_true] = ACTIONS(81),
    [sym_false] = ACTIONS(81),
    [sym_null] = ACTIONS(81),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(87),
    [anon_sym_get] = ACTIONS(87),
    [anon_sym_set] = ACTIONS(87),
  },
  [22] = {
    [sym_export_statement] = STATE(12),
    [sym_declaration] = STATE(12),
    [sym_import] = STATE(721),
    [sym_import_statement] = STATE(12),
    [sym_expression_statement] = STATE(12),
    [sym_variable_declaration] = STATE(415),
    [sym_lexical_declaration] = STATE(415),
    [sym_statement_block] = STATE(12),
    [sym_if_statement] = STATE(12),
    [sym_switch_statement] = STATE(12),
    [sym_for_statement] = STATE(12),
    [sym_for_in_statement] = STATE(12),
    [sym_while_statement] = STATE(12),
    [sym_do_statement] = STATE(12),
    [sym_try_statement] = STATE(12),
    [sym_with_statement] = STATE(12),
    [sym_break_statement] = STATE(12),
    [sym_continue_statement] = STATE(12),
    [sym_debugger_statement] = STATE(12),
    [sym_return_statement] = STATE(12),
    [sym_throw_statement] = STATE(12),
    [sym_empty_statement] = STATE(12),
    [sym_labeled_statement] = STATE(12),
    [sym_parenthesized_expression] = STATE(479),
    [sym_expression] = STATE(674),
    [sym_primary_expression] = STATE(743),
    [sym_yield_expression] = STATE(740),
    [sym_object] = STATE(721),
    [sym_object_pattern] = STATE(1548),
    [sym_array] = STATE(721),
    [sym_array_pattern] = STATE(1548),
    [sym_jsx_element] = STATE(740),
    [sym_jsx_fragment] = STATE(740),
    [sym_jsx_opening_element] = STATE(972),
    [sym_jsx_self_closing_element] = STATE(740),
    [sym_class] = STATE(721),
    [sym_class_declaration] = STATE(415),
    [sym_function] = STATE(721),
    [sym_function_declaration] = STATE(415),
    [sym_generator_function] = STATE(721),
    [sym_generator_function_declaration] = STATE(415),
    [sym_arrow_function] = STATE(721),
    [sym_call_expression] = STATE(721),
    [sym_new_expression] = STATE(740),
    [sym_await_expression] = STATE(740),
    [sym_member_expression] = STATE(479),
    [sym_subscript_expression] = STATE(479),
    [sym_assignment_expression] = STATE(740),
    [sym__augmented_assignment_lhs] = STATE(942),
    [sym_augmented_assignment_expression] = STATE(740),
    [sym__destructuring_pattern] = STATE(1548),
    [sym_ternary_expression] = STATE(740),
    [sym_binary_expression] = STATE(740),
    [sym_unary_expression] = STATE(740),
    [sym_update_expression] = STATE(740),
    [sym_sequence_expression] = STATE(1331),
    [sym_string] = STATE(721),
    [sym_template_string] = STATE(721),
    [sym_regex] = STATE(721),
    [sym_meta_property] = STATE(721),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1546),
    [aux_sym_program_repeat1] = STATE(12),
    [aux_sym_export_statement_repeat1] = STATE(1091),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_RBRACE] = ACTIONS(297),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(61),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(67),
    [anon_sym_void] = ACTIONS(67),
    [anon_sym_delete] = ACTIONS(67),
    [anon_sym_PLUS_PLUS] = ACTIONS(71),
    [anon_sym_DASH_DASH] = ACTIONS(71),
    [anon_sym_DQUOTE] = ACTIONS(73),
    [anon_sym_SQUOTE] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(77),
    [sym_number] = ACTIONS(79),
    [sym_this] = ACTIONS(81),
    [sym_super] = ACTIONS(81),
    [sym_true] = ACTIONS(81),
    [sym_false] = ACTIONS(81),
    [sym_null] = ACTIONS(81),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(87),
    [anon_sym_get] = ACTIONS(87),
    [anon_sym_set] = ACTIONS(87),
  },
  [23] = {
    [sym_export_statement] = STATE(367),
    [sym_declaration] = STATE(367),
    [sym_import] = STATE(721),
    [sym_import_statement] = STATE(367),
    [sym_expression_statement] = STATE(367),
    [sym_variable_declaration] = STATE(415),
    [sym_lexical_declaration] = STATE(415),
    [sym_statement_block] = STATE(367),
    [sym_if_statement] = STATE(367),
    [sym_switch_statement] = STATE(367),
    [sym_for_statement] = STATE(367),
    [sym_for_in_statement] = STATE(367),
    [sym_while_statement] = STATE(367),
    [sym_do_statement] = STATE(367),
    [sym_try_statement] = STATE(367),
    [sym_with_statement] = STATE(367),
    [sym_break_statement] = STATE(367),
    [sym_continue_statement] = STATE(367),
    [sym_debugger_statement] = STATE(367),
    [sym_return_statement] = STATE(367),
    [sym_throw_statement] = STATE(367),
    [sym_empty_statement] = STATE(367),
    [sym_labeled_statement] = STATE(367),
    [sym_parenthesized_expression] = STATE(479),
    [sym_expression] = STATE(674),
    [sym_primary_expression] = STATE(743),
    [sym_yield_expression] = STATE(740),
    [sym_object] = STATE(721),
    [sym_object_pattern] = STATE(1548),
    [sym_array] = STATE(721),
    [sym_array_pattern] = STATE(1548),
    [sym_jsx_element] = STATE(740),
    [sym_jsx_fragment] = STATE(740),
    [sym_jsx_opening_element] = STATE(972),
    [sym_jsx_self_closing_element] = STATE(740),
    [sym_class] = STATE(721),
    [sym_class_declaration] = STATE(415),
    [sym_function] = STATE(721),
    [sym_function_declaration] = STATE(415),
    [sym_generator_function] = STATE(721),
    [sym_generator_function_declaration] = STATE(415),
    [sym_arrow_function] = STATE(721),
    [sym_call_expression] = STATE(721),
    [sym_new_expression] = STATE(740),
    [sym_await_expression] = STATE(740),
    [sym_member_expression] = STATE(479),
    [sym_subscript_expression] = STATE(479),
    [sym_assignment_expression] = STATE(740),
    [sym__augmented_assignment_lhs] = STATE(942),
    [sym_augmented_assignment_expression] = STATE(740),
    [sym__destructuring_pattern] = STATE(1548),
    [sym_ternary_expression] = STATE(740),
    [sym_binary_expression] = STATE(740),
    [sym_unary_expression] = STATE(740),
    [sym_update_expression] = STATE(740),
    [sym_sequence_expression] = STATE(1331),
    [sym_string] = STATE(721),
    [sym_template_string] = STATE(721),
    [sym_regex] = STATE(721),
    [sym_meta_property] = STATE(721),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1546),
    [aux_sym_export_statement_repeat1] = STATE(1098),
    [sym_identifier] = ACTIONS(299),
    [anon_sym_export] = ACTIONS(301),
    [anon_sym_LBRACE] = ACTIONS(303),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(305),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(307),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(309),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(311),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(313),
    [anon_sym_async] = ACTIONS(315),
    [anon_sym_function] = ACTIONS(317),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(67),
    [anon_sym_void] = ACTIONS(67),
    [anon_sym_delete] = ACTIONS(67),
    [anon_sym_PLUS_PLUS] = ACTIONS(71),
    [anon_sym_DASH_DASH] = ACTIONS(71),
    [anon_sym_DQUOTE] = ACTIONS(73),
    [anon_sym_SQUOTE] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(77),
    [sym_number] = ACTIONS(79),
    [sym_this] = ACTIONS(81),
    [sym_super] = ACTIONS(81),
    [sym_true] = ACTIONS(81),
    [sym_false] = ACTIONS(81),
    [sym_null] = ACTIONS(81),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(319),
    [anon_sym_get] = ACTIONS(319),
    [anon_sym_set] = ACTIONS(319),
  },
  [24] = {
    [sym_export_statement] = STATE(383),
    [sym_declaration] = STATE(383),
    [sym_import] = STATE(721),
    [sym_import_statement] = STATE(383),
    [sym_expression_statement] = STATE(383),
    [sym_variable_declaration] = STATE(415),
    [sym_lexical_declaration] = STATE(415),
    [sym_statement_block] = STATE(383),
    [sym_if_statement] = STATE(383),
    [sym_switch_statement] = STATE(383),
    [sym_for_statement] = STATE(383),
    [sym_for_in_statement] = STATE(383),
    [sym_while_statement] = STATE(383),
    [sym_do_statement] = STATE(383),
    [sym_try_statement] = STATE(383),
    [sym_with_statement] = STATE(383),
    [sym_break_statement] = STATE(383),
    [sym_continue_statement] = STATE(383),
    [sym_debugger_statement] = STATE(383),
    [sym_return_statement] = STATE(383),
    [sym_throw_statement] = STATE(383),
    [sym_empty_statement] = STATE(383),
    [sym_labeled_statement] = STATE(383),
    [sym_parenthesized_expression] = STATE(479),
    [sym_expression] = STATE(674),
    [sym_primary_expression] = STATE(743),
    [sym_yield_expression] = STATE(740),
    [sym_object] = STATE(721),
    [sym_object_pattern] = STATE(1548),
    [sym_array] = STATE(721),
    [sym_array_pattern] = STATE(1548),
    [sym_jsx_element] = STATE(740),
    [sym_jsx_fragment] = STATE(740),
    [sym_jsx_opening_element] = STATE(972),
    [sym_jsx_self_closing_element] = STATE(740),
    [sym_class] = STATE(721),
    [sym_class_declaration] = STATE(415),
    [sym_function] = STATE(721),
    [sym_function_declaration] = STATE(415),
    [sym_generator_function] = STATE(721),
    [sym_generator_function_declaration] = STATE(415),
    [sym_arrow_function] = STATE(721),
    [sym_call_expression] = STATE(721),
    [sym_new_expression] = STATE(740),
    [sym_await_expression] = STATE(740),
    [sym_member_expression] = STATE(479),
    [sym_subscript_expression] = STATE(479),
    [sym_assignment_expression] = STATE(740),
    [sym__augmented_assignment_lhs] = STATE(942),
    [sym_augmented_assignment_expression] = STATE(740),
    [sym__destructuring_pattern] = STATE(1548),
    [sym_ternary_expression] = STATE(740),
    [sym_binary_expression] = STATE(740),
    [sym_unary_expression] = STATE(740),
    [sym_update_expression] = STATE(740),
    [sym_sequence_expression] = STATE(1331),
    [sym_string] = STATE(721),
    [sym_template_string] = STATE(721),
    [sym_regex] = STATE(721),
    [sym_meta_property] = STATE(721),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1546),
    [aux_sym_export_statement_repeat1] = STATE(1098),
    [sym_identifier] = ACTIONS(299),
    [anon_sym_export] = ACTIONS(301),
    [anon_sym_LBRACE] = ACTIONS(303),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(305),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(307),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(309),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(311),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(313),
    [anon_sym_async] = ACTIONS(315),
    [anon_sym_function] = ACTIONS(317),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(67),
    [anon_sym_void] = ACTIONS(67),
    [anon_sym_delete] = ACTIONS(67),
    [anon_sym_PLUS_PLUS] = ACTIONS(71),
    [anon_sym_DASH_DASH] = ACTIONS(71),
    [anon_sym_DQUOTE] = ACTIONS(73),
    [anon_sym_SQUOTE] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(77),
    [sym_number] = ACTIONS(79),
    [sym_this] = ACTIONS(81),
    [sym_super] = ACTIONS(81),
    [sym_true] = ACTIONS(81),
    [sym_false] = ACTIONS(81),
    [sym_null] = ACTIONS(81),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(319),
    [anon_sym_get] = ACTIONS(319),
    [anon_sym_set] = ACTIONS(319),
  },
  [25] = {
    [sym_export_statement] = STATE(418),
    [sym_declaration] = STATE(418),
    [sym_import] = STATE(721),
    [sym_import_statement] = STATE(418),
    [sym_expression_statement] = STATE(418),
    [sym_variable_declaration] = STATE(415),
    [sym_lexical_declaration] = STATE(415),
    [sym_statement_block] = STATE(418),
    [sym_if_statement] = STATE(418),
    [sym_switch_statement] = STATE(418),
    [sym_for_statement] = STATE(418),
    [sym_for_in_statement] = STATE(418),
    [sym_while_statement] = STATE(418),
    [sym_do_statement] = STATE(418),
    [sym_try_statement] = STATE(418),
    [sym_with_statement] = STATE(418),
    [sym_break_statement] = STATE(418),
    [sym_continue_statement] = STATE(418),
    [sym_debugger_statement] = STATE(418),
    [sym_return_statement] = STATE(418),
    [sym_throw_statement] = STATE(418),
    [sym_empty_statement] = STATE(418),
    [sym_labeled_statement] = STATE(418),
    [sym_parenthesized_expression] = STATE(479),
    [sym_expression] = STATE(674),
    [sym_primary_expression] = STATE(743),
    [sym_yield_expression] = STATE(740),
    [sym_object] = STATE(721),
    [sym_object_pattern] = STATE(1548),
    [sym_array] = STATE(721),
    [sym_array_pattern] = STATE(1548),
    [sym_jsx_element] = STATE(740),
    [sym_jsx_fragment] = STATE(740),
    [sym_jsx_opening_element] = STATE(972),
    [sym_jsx_self_closing_element] = STATE(740),
    [sym_class] = STATE(721),
    [sym_class_declaration] = STATE(415),
    [sym_function] = STATE(721),
    [sym_function_declaration] = STATE(415),
    [sym_generator_function] = STATE(721),
    [sym_generator_function_declaration] = STATE(415),
    [sym_arrow_function] = STATE(721),
    [sym_call_expression] = STATE(721),
    [sym_new_expression] = STATE(740),
    [sym_await_expression] = STATE(740),
    [sym_member_expression] = STATE(479),
    [sym_subscript_expression] = STATE(479),
    [sym_assignment_expression] = STATE(740),
    [sym__augmented_assignment_lhs] = STATE(942),
    [sym_augmented_assignment_expression] = STATE(740),
    [sym__destructuring_pattern] = STATE(1548),
    [sym_ternary_expression] = STATE(740),
    [sym_binary_expression] = STATE(740),
    [sym_unary_expression] = STATE(740),
    [sym_update_expression] = STATE(740),
    [sym_sequence_expression] = STATE(1331),
    [sym_string] = STATE(721),
    [sym_template_string] = STATE(721),
    [sym_regex] = STATE(721),
    [sym_meta_property] = STATE(721),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1546),
    [aux_sym_export_statement_repeat1] = STATE(1091),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(61),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(67),
    [anon_sym_void] = ACTIONS(67),
    [anon_sym_delete] = ACTIONS(67),
    [anon_sym_PLUS_PLUS] = ACTIONS(71),
    [anon_sym_DASH_DASH] = ACTIONS(71),
    [anon_sym_DQUOTE] = ACTIONS(73),
    [anon_sym_SQUOTE] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(77),
    [sym_number] = ACTIONS(79),
    [sym_this] = ACTIONS(81),
    [sym_super] = ACTIONS(81),
    [sym_true] = ACTIONS(81),
    [sym_false] = ACTIONS(81),
    [sym_null] = ACTIONS(81),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(87),
    [anon_sym_get] = ACTIONS(87),
    [anon_sym_set] = ACTIONS(87),
  },
  [26] = {
    [sym_export_statement] = STATE(419),
    [sym_declaration] = STATE(419),
    [sym_import] = STATE(721),
    [sym_import_statement] = STATE(419),
    [sym_expression_statement] = STATE(419),
    [sym_variable_declaration] = STATE(415),
    [sym_lexical_declaration] = STATE(415),
    [sym_statement_block] = STATE(419),
    [sym_if_statement] = STATE(419),
    [sym_switch_statement] = STATE(419),
    [sym_for_statement] = STATE(419),
    [sym_for_in_statement] = STATE(419),
    [sym_while_statement] = STATE(419),
    [sym_do_statement] = STATE(419),
    [sym_try_statement] = STATE(419),
    [sym_with_statement] = STATE(419),
    [sym_break_statement] = STATE(419),
    [sym_continue_statement] = STATE(419),
    [sym_debugger_statement] = STATE(419),
    [sym_return_statement] = STATE(419),
    [sym_throw_statement] = STATE(419),
    [sym_empty_statement] = STATE(419),
    [sym_labeled_statement] = STATE(419),
    [sym_parenthesized_expression] = STATE(479),
    [sym_expression] = STATE(674),
    [sym_primary_expression] = STATE(743),
    [sym_yield_expression] = STATE(740),
    [sym_object] = STATE(721),
    [sym_object_pattern] = STATE(1548),
    [sym_array] = STATE(721),
    [sym_array_pattern] = STATE(1548),
    [sym_jsx_element] = STATE(740),
    [sym_jsx_fragment] = STATE(740),
    [sym_jsx_opening_element] = STATE(972),
    [sym_jsx_self_closing_element] = STATE(740),
    [sym_class] = STATE(721),
    [sym_class_declaration] = STATE(415),
    [sym_function] = STATE(721),
    [sym_function_declaration] = STATE(415),
    [sym_generator_function] = STATE(721),
    [sym_generator_function_declaration] = STATE(415),
    [sym_arrow_function] = STATE(721),
    [sym_call_expression] = STATE(721),
    [sym_new_expression] = STATE(740),
    [sym_await_expression] = STATE(740),
    [sym_member_expression] = STATE(479),
    [sym_subscript_expression] = STATE(479),
    [sym_assignment_expression] = STATE(740),
    [sym__augmented_assignment_lhs] = STATE(942),
    [sym_augmented_assignment_expression] = STATE(740),
    [sym__destructuring_pattern] = STATE(1548),
    [sym_ternary_expression] = STATE(740),
    [sym_binary_expression] = STATE(740),
    [sym_unary_expression] = STATE(740),
    [sym_update_expression] = STATE(740),
    [sym_sequence_expression] = STATE(1331),
    [sym_string] = STATE(721),
    [sym_template_string] = STATE(721),
    [sym_regex] = STATE(721),
    [sym_meta_property] = STATE(721),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1546),
    [aux_sym_export_statement_repeat1] = STATE(1091),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(61),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(67),
    [anon_sym_void] = ACTIONS(67),
    [anon_sym_delete] = ACTIONS(67),
    [anon_sym_PLUS_PLUS] = ACTIONS(71),
    [anon_sym_DASH_DASH] = ACTIONS(71),
    [anon_sym_DQUOTE] = ACTIONS(73),
    [anon_sym_SQUOTE] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(77),
    [sym_number] = ACTIONS(79),
    [sym_this] = ACTIONS(81),
    [sym_super] = ACTIONS(81),
    [sym_true] = ACTIONS(81),
    [sym_false] = ACTIONS(81),
    [sym_null] = ACTIONS(81),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(87),
    [anon_sym_get] = ACTIONS(87),
    [anon_sym_set] = ACTIONS(87),
  },
  [27] = {
    [sym_export_statement] = STATE(383),
    [sym_declaration] = STATE(383),
    [sym_import] = STATE(721),
    [sym_import_statement] = STATE(383),
    [sym_expression_statement] = STATE(383),
    [sym_variable_declaration] = STATE(415),
    [sym_lexical_declaration] = STATE(415),
    [sym_statement_block] = STATE(383),
    [sym_if_statement] = STATE(383),
    [sym_switch_statement] = STATE(383),
    [sym_for_statement] = STATE(383),
    [sym_for_in_statement] = STATE(383),
    [sym_while_statement] = STATE(383),
    [sym_do_statement] = STATE(383),
    [sym_try_statement] = STATE(383),
    [sym_with_statement] = STATE(383),
    [sym_break_statement] = STATE(383),
    [sym_continue_statement] = STATE(383),
    [sym_debugger_statement] = STATE(383),
    [sym_return_statement] = STATE(383),
    [sym_throw_statement] = STATE(383),
    [sym_empty_statement] = STATE(383),
    [sym_labeled_statement] = STATE(383),
    [sym_parenthesized_expression] = STATE(479),
    [sym_expression] = STATE(674),
    [sym_primary_expression] = STATE(743),
    [sym_yield_expression] = STATE(740),
    [sym_object] = STATE(721),
    [sym_object_pattern] = STATE(1548),
    [sym_array] = STATE(721),
    [sym_array_pattern] = STATE(1548),
    [sym_jsx_element] = STATE(740),
    [sym_jsx_fragment] = STATE(740),
    [sym_jsx_opening_element] = STATE(972),
    [sym_jsx_self_closing_element] = STATE(740),
    [sym_class] = STATE(721),
    [sym_class_declaration] = STATE(415),
    [sym_function] = STATE(721),
    [sym_function_declaration] = STATE(415),
    [sym_generator_function] = STATE(721),
    [sym_generator_function_declaration] = STATE(415),
    [sym_arrow_function] = STATE(721),
    [sym_call_expression] = STATE(721),
    [sym_new_expression] = STATE(740),
    [sym_await_expression] = STATE(740),
    [sym_member_expression] = STATE(479),
    [sym_subscript_expression] = STATE(479),
    [sym_assignment_expression] = STATE(740),
    [sym__augmented_assignment_lhs] = STATE(942),
    [sym_augmented_assignment_expression] = STATE(740),
    [sym__destructuring_pattern] = STATE(1548),
    [sym_ternary_expression] = STATE(740),
    [sym_binary_expression] = STATE(740),
    [sym_unary_expression] = STATE(740),
    [sym_update_expression] = STATE(740),
    [sym_sequence_expression] = STATE(1331),
    [sym_string] = STATE(721),
    [sym_template_string] = STATE(721),
    [sym_regex] = STATE(721),
    [sym_meta_property] = STATE(721),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1546),
    [aux_sym_export_statement_repeat1] = STATE(1091),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(61),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(67),
    [anon_sym_void] = ACTIONS(67),
    [anon_sym_delete] = ACTIONS(67),
    [anon_sym_PLUS_PLUS] = ACTIONS(71),
    [anon_sym_DASH_DASH] = ACTIONS(71),
    [anon_sym_DQUOTE] = ACTIONS(73),
    [anon_sym_SQUOTE] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(77),
    [sym_number] = ACTIONS(79),
    [sym_this] = ACTIONS(81),
    [sym_super] = ACTIONS(81),
    [sym_true] = ACTIONS(81),
    [sym_false] = ACTIONS(81),
    [sym_null] = ACTIONS(81),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(87),
    [anon_sym_get] = ACTIONS(87),
    [anon_sym_set] = ACTIONS(87),
  },
  [28] = {
    [sym_export_statement] = STATE(375),
    [sym_declaration] = STATE(375),
    [sym_import] = STATE(721),
    [sym_import_statement] = STATE(375),
    [sym_expression_statement] = STATE(375),
    [sym_variable_declaration] = STATE(415),
    [sym_lexical_declaration] = STATE(415),
    [sym_statement_block] = STATE(375),
    [sym_if_statement] = STATE(375),
    [sym_switch_statement] = STATE(375),
    [sym_for_statement] = STATE(375),
    [sym_for_in_statement] = STATE(375),
    [sym_while_statement] = STATE(375),
    [sym_do_statement] = STATE(375),
    [sym_try_statement] = STATE(375),
    [sym_with_statement] = STATE(375),
    [sym_break_statement] = STATE(375),
    [sym_continue_statement] = STATE(375),
    [sym_debugger_statement] = STATE(375),
    [sym_return_statement] = STATE(375),
    [sym_throw_statement] = STATE(375),
    [sym_empty_statement] = STATE(375),
    [sym_labeled_statement] = STATE(375),
    [sym_parenthesized_expression] = STATE(479),
    [sym_expression] = STATE(674),
    [sym_primary_expression] = STATE(743),
    [sym_yield_expression] = STATE(740),
    [sym_object] = STATE(721),
    [sym_object_pattern] = STATE(1548),
    [sym_array] = STATE(721),
    [sym_array_pattern] = STATE(1548),
    [sym_jsx_element] = STATE(740),
    [sym_jsx_fragment] = STATE(740),
    [sym_jsx_opening_element] = STATE(972),
    [sym_jsx_self_closing_element] = STATE(740),
    [sym_class] = STATE(721),
    [sym_class_declaration] = STATE(415),
    [sym_function] = STATE(721),
    [sym_function_declaration] = STATE(415),
    [sym_generator_function] = STATE(721),
    [sym_generator_function_declaration] = STATE(415),
    [sym_arrow_function] = STATE(721),
    [sym_call_expression] = STATE(721),
    [sym_new_expression] = STATE(740),
    [sym_await_expression] = STATE(740),
    [sym_member_expression] = STATE(479),
    [sym_subscript_expression] = STATE(479),
    [sym_assignment_expression] = STATE(740),
    [sym__augmented_assignment_lhs] = STATE(942),
    [sym_augmented_assignment_expression] = STATE(740),
    [sym__destructuring_pattern] = STATE(1548),
    [sym_ternary_expression] = STATE(740),
    [sym_binary_expression] = STATE(740),
    [sym_unary_expression] = STATE(740),
    [sym_update_expression] = STATE(740),
    [sym_sequence_expression] = STATE(1331),
    [sym_string] = STATE(721),
    [sym_template_string] = STATE(721),
    [sym_regex] = STATE(721),
    [sym_meta_property] = STATE(721),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1546),
    [aux_sym_export_statement_repeat1] = STATE(1091),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(61),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(67),
    [anon_sym_void] = ACTIONS(67),
    [anon_sym_delete] = ACTIONS(67),
    [anon_sym_PLUS_PLUS] = ACTIONS(71),
    [anon_sym_DASH_DASH] = ACTIONS(71),
    [anon_sym_DQUOTE] = ACTIONS(73),
    [anon_sym_SQUOTE] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(77),
    [sym_number] = ACTIONS(79),
    [sym_this] = ACTIONS(81),
    [sym_super] = ACTIONS(81),
    [sym_true] = ACTIONS(81),
    [sym_false] = ACTIONS(81),
    [sym_null] = ACTIONS(81),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(87),
    [anon_sym_get] = ACTIONS(87),
    [anon_sym_set] = ACTIONS(87),
  },
  [29] = {
    [sym_export_statement] = STATE(359),
    [sym_declaration] = STATE(361),
    [sym_import] = STATE(721),
    [sym_import_statement] = STATE(362),
    [sym_expression_statement] = STATE(363),
    [sym_variable_declaration] = STATE(415),
    [sym_lexical_declaration] = STATE(415),
    [sym_statement_block] = STATE(364),
    [sym_if_statement] = STATE(365),
    [sym_switch_statement] = STATE(372),
    [sym_for_statement] = STATE(373),
    [sym_for_in_statement] = STATE(391),
    [sym_while_statement] = STATE(334),
    [sym_do_statement] = STATE(335),
    [sym_try_statement] = STATE(336),
    [sym_with_statement] = STATE(337),
    [sym_break_statement] = STATE(338),
    [sym_continue_statement] = STATE(339),
    [sym_debugger_statement] = STATE(340),
    [sym_return_statement] = STATE(341),
    [sym_throw_statement] = STATE(342),
    [sym_empty_statement] = STATE(343),
    [sym_labeled_statement] = STATE(344),
    [sym_parenthesized_expression] = STATE(479),
    [sym_expression] = STATE(674),
    [sym_primary_expression] = STATE(743),
    [sym_yield_expression] = STATE(740),
    [sym_object] = STATE(721),
    [sym_object_pattern] = STATE(1548),
    [sym_array] = STATE(721),
    [sym_array_pattern] = STATE(1548),
    [sym_jsx_element] = STATE(740),
    [sym_jsx_fragment] = STATE(740),
    [sym_jsx_opening_element] = STATE(972),
    [sym_jsx_self_closing_element] = STATE(740),
    [sym_class] = STATE(721),
    [sym_class_declaration] = STATE(415),
    [sym_function] = STATE(721),
    [sym_function_declaration] = STATE(415),
    [sym_generator_function] = STATE(721),
    [sym_generator_function_declaration] = STATE(415),
    [sym_arrow_function] = STATE(721),
    [sym_call_expression] = STATE(721),
    [sym_new_expression] = STATE(740),
    [sym_await_expression] = STATE(740),
    [sym_member_expression] = STATE(479),
    [sym_subscript_expression] = STATE(479),
    [sym_assignment_expression] = STATE(740),
    [sym__augmented_assignment_lhs] = STATE(942),
    [sym_augmented_assignment_expression] = STATE(740),
    [sym__destructuring_pattern] = STATE(1548),
    [sym_ternary_expression] = STATE(740),
    [sym_binary_expression] = STATE(740),
    [sym_unary_expression] = STATE(740),
    [sym_update_expression] = STATE(740),
    [sym_sequence_expression] = STATE(1331),
    [sym_string] = STATE(721),
    [sym_template_string] = STATE(721),
    [sym_regex] = STATE(721),
    [sym_meta_property] = STATE(721),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1546),
    [aux_sym_export_statement_repeat1] = STATE(1098),
    [sym_identifier] = ACTIONS(299),
    [anon_sym_export] = ACTIONS(301),
    [anon_sym_LBRACE] = ACTIONS(303),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(305),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(307),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(309),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(311),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(313),
    [anon_sym_async] = ACTIONS(315),
    [anon_sym_function] = ACTIONS(317),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(67),
    [anon_sym_void] = ACTIONS(67),
    [anon_sym_delete] = ACTIONS(67),
    [anon_sym_PLUS_PLUS] = ACTIONS(71),
    [anon_sym_DASH_DASH] = ACTIONS(71),
    [anon_sym_DQUOTE] = ACTIONS(73),
    [anon_sym_SQUOTE] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(77),
    [sym_number] = ACTIONS(79),
    [sym_this] = ACTIONS(81),
    [sym_super] = ACTIONS(81),
    [sym_true] = ACTIONS(81),
    [sym_false] = ACTIONS(81),
    [sym_null] = ACTIONS(81),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(319),
    [anon_sym_get] = ACTIONS(319),
    [anon_sym_set] = ACTIONS(319),
  },
  [30] = {
    [sym_export_statement] = STATE(387),
    [sym_declaration] = STATE(389),
    [sym_import] = STATE(721),
    [sym_import_statement] = STATE(333),
    [sym_expression_statement] = STATE(393),
    [sym_variable_declaration] = STATE(415),
    [sym_lexical_declaration] = STATE(415),
    [sym_statement_block] = STATE(394),
    [sym_if_statement] = STATE(396),
    [sym_switch_statement] = STATE(397),
    [sym_for_statement] = STATE(400),
    [sym_for_in_statement] = STATE(401),
    [sym_while_statement] = STATE(402),
    [sym_do_statement] = STATE(403),
    [sym_try_statement] = STATE(405),
    [sym_with_statement] = STATE(406),
    [sym_break_statement] = STATE(408),
    [sym_continue_statement] = STATE(409),
    [sym_debugger_statement] = STATE(411),
    [sym_return_statement] = STATE(412),
    [sym_throw_statement] = STATE(413),
    [sym_empty_statement] = STATE(414),
    [sym_labeled_statement] = STATE(416),
    [sym_parenthesized_expression] = STATE(479),
    [sym_expression] = STATE(674),
    [sym_primary_expression] = STATE(743),
    [sym_yield_expression] = STATE(740),
    [sym_object] = STATE(721),
    [sym_object_pattern] = STATE(1548),
    [sym_array] = STATE(721),
    [sym_array_pattern] = STATE(1548),
    [sym_jsx_element] = STATE(740),
    [sym_jsx_fragment] = STATE(740),
    [sym_jsx_opening_element] = STATE(972),
    [sym_jsx_self_closing_element] = STATE(740),
    [sym_class] = STATE(721),
    [sym_class_declaration] = STATE(415),
    [sym_function] = STATE(721),
    [sym_function_declaration] = STATE(415),
    [sym_generator_function] = STATE(721),
    [sym_generator_function_declaration] = STATE(415),
    [sym_arrow_function] = STATE(721),
    [sym_call_expression] = STATE(721),
    [sym_new_expression] = STATE(740),
    [sym_await_expression] = STATE(740),
    [sym_member_expression] = STATE(479),
    [sym_subscript_expression] = STATE(479),
    [sym_assignment_expression] = STATE(740),
    [sym__augmented_assignment_lhs] = STATE(942),
    [sym_augmented_assignment_expression] = STATE(740),
    [sym__destructuring_pattern] = STATE(1548),
    [sym_ternary_expression] = STATE(740),
    [sym_binary_expression] = STATE(740),
    [sym_unary_expression] = STATE(740),
    [sym_update_expression] = STATE(740),
    [sym_sequence_expression] = STATE(1331),
    [sym_string] = STATE(721),
    [sym_template_string] = STATE(721),
    [sym_regex] = STATE(721),
    [sym_meta_property] = STATE(721),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1546),
    [aux_sym_export_statement_repeat1] = STATE(1091),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(61),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(67),
    [anon_sym_void] = ACTIONS(67),
    [anon_sym_delete] = ACTIONS(67),
    [anon_sym_PLUS_PLUS] = ACTIONS(71),
    [anon_sym_DASH_DASH] = ACTIONS(71),
    [anon_sym_DQUOTE] = ACTIONS(73),
    [anon_sym_SQUOTE] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(77),
    [sym_number] = ACTIONS(79),
    [sym_this] = ACTIONS(81),
    [sym_super] = ACTIONS(81),
    [sym_true] = ACTIONS(81),
    [sym_false] = ACTIONS(81),
    [sym_null] = ACTIONS(81),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(87),
    [anon_sym_get] = ACTIONS(87),
    [anon_sym_set] = ACTIONS(87),
  },
  [31] = {
    [sym_export_statement] = STATE(360),
    [sym_declaration] = STATE(360),
    [sym_import] = STATE(721),
    [sym_import_statement] = STATE(360),
    [sym_expression_statement] = STATE(360),
    [sym_variable_declaration] = STATE(415),
    [sym_lexical_declaration] = STATE(415),
    [sym_statement_block] = STATE(360),
    [sym_if_statement] = STATE(360),
    [sym_switch_statement] = STATE(360),
    [sym_for_statement] = STATE(360),
    [sym_for_in_statement] = STATE(360),
    [sym_while_statement] = STATE(360),
    [sym_do_statement] = STATE(360),
    [sym_try_statement] = STATE(360),
    [sym_with_statement] = STATE(360),
    [sym_break_statement] = STATE(360),
    [sym_continue_statement] = STATE(360),
    [sym_debugger_statement] = STATE(360),
    [sym_return_statement] = STATE(360),
    [sym_throw_statement] = STATE(360),
    [sym_empty_statement] = STATE(360),
    [sym_labeled_statement] = STATE(360),
    [sym_parenthesized_expression] = STATE(479),
    [sym_expression] = STATE(674),
    [sym_primary_expression] = STATE(743),
    [sym_yield_expression] = STATE(740),
    [sym_object] = STATE(721),
    [sym_object_pattern] = STATE(1548),
    [sym_array] = STATE(721),
    [sym_array_pattern] = STATE(1548),
    [sym_jsx_element] = STATE(740),
    [sym_jsx_fragment] = STATE(740),
    [sym_jsx_opening_element] = STATE(972),
    [sym_jsx_self_closing_element] = STATE(740),
    [sym_class] = STATE(721),
    [sym_class_declaration] = STATE(415),
    [sym_function] = STATE(721),
    [sym_function_declaration] = STATE(415),
    [sym_generator_function] = STATE(721),
    [sym_generator_function_declaration] = STATE(415),
    [sym_arrow_function] = STATE(721),
    [sym_call_expression] = STATE(721),
    [sym_new_expression] = STATE(740),
    [sym_await_expression] = STATE(740),
    [sym_member_expression] = STATE(479),
    [sym_subscript_expression] = STATE(479),
    [sym_assignment_expression] = STATE(740),
    [sym__augmented_assignment_lhs] = STATE(942),
    [sym_augmented_assignment_expression] = STATE(740),
    [sym__destructuring_pattern] = STATE(1548),
    [sym_ternary_expression] = STATE(740),
    [sym_binary_expression] = STATE(740),
    [sym_unary_expression] = STATE(740),
    [sym_update_expression] = STATE(740),
    [sym_sequence_expression] = STATE(1331),
    [sym_string] = STATE(721),
    [sym_template_string] = STATE(721),
    [sym_regex] = STATE(721),
    [sym_meta_property] = STATE(721),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1546),
    [aux_sym_export_statement_repeat1] = STATE(1098),
    [sym_identifier] = ACTIONS(299),
    [anon_sym_export] = ACTIONS(301),
    [anon_sym_LBRACE] = ACTIONS(303),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(305),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(307),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(309),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(311),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(313),
    [anon_sym_async] = ACTIONS(315),
    [anon_sym_function] = ACTIONS(317),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(67),
    [anon_sym_void] = ACTIONS(67),
    [anon_sym_delete] = ACTIONS(67),
    [anon_sym_PLUS_PLUS] = ACTIONS(71),
    [anon_sym_DASH_DASH] = ACTIONS(71),
    [anon_sym_DQUOTE] = ACTIONS(73),
    [anon_sym_SQUOTE] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(77),
    [sym_number] = ACTIONS(79),
    [sym_this] = ACTIONS(81),
    [sym_super] = ACTIONS(81),
    [sym_true] = ACTIONS(81),
    [sym_false] = ACTIONS(81),
    [sym_null] = ACTIONS(81),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(319),
    [anon_sym_get] = ACTIONS(319),
    [anon_sym_set] = ACTIONS(319),
  },
  [32] = {
    [sym_export_statement] = STATE(1510),
    [sym_declaration] = STATE(1510),
    [sym_import] = STATE(721),
    [sym_import_statement] = STATE(1510),
    [sym_expression_statement] = STATE(1510),
    [sym_variable_declaration] = STATE(415),
    [sym_lexical_declaration] = STATE(415),
    [sym_statement_block] = STATE(1510),
    [sym_if_statement] = STATE(1510),
    [sym_switch_statement] = STATE(1510),
    [sym_for_statement] = STATE(1510),
    [sym_for_in_statement] = STATE(1510),
    [sym_while_statement] = STATE(1510),
    [sym_do_statement] = STATE(1510),
    [sym_try_statement] = STATE(1510),
    [sym_with_statement] = STATE(1510),
    [sym_break_statement] = STATE(1510),
    [sym_continue_statement] = STATE(1510),
    [sym_debugger_statement] = STATE(1510),
    [sym_return_statement] = STATE(1510),
    [sym_throw_statement] = STATE(1510),
    [sym_empty_statement] = STATE(1510),
    [sym_labeled_statement] = STATE(1510),
    [sym_parenthesized_expression] = STATE(479),
    [sym_expression] = STATE(674),
    [sym_primary_expression] = STATE(743),
    [sym_yield_expression] = STATE(740),
    [sym_object] = STATE(721),
    [sym_object_pattern] = STATE(1548),
    [sym_array] = STATE(721),
    [sym_array_pattern] = STATE(1548),
    [sym_jsx_element] = STATE(740),
    [sym_jsx_fragment] = STATE(740),
    [sym_jsx_opening_element] = STATE(972),
    [sym_jsx_self_closing_element] = STATE(740),
    [sym_class] = STATE(721),
    [sym_class_declaration] = STATE(415),
    [sym_function] = STATE(721),
    [sym_function_declaration] = STATE(415),
    [sym_generator_function] = STATE(721),
    [sym_generator_function_declaration] = STATE(415),
    [sym_arrow_function] = STATE(721),
    [sym_call_expression] = STATE(721),
    [sym_new_expression] = STATE(740),
    [sym_await_expression] = STATE(740),
    [sym_member_expression] = STATE(479),
    [sym_subscript_expression] = STATE(479),
    [sym_assignment_expression] = STATE(740),
    [sym__augmented_assignment_lhs] = STATE(942),
    [sym_augmented_assignment_expression] = STATE(740),
    [sym__destructuring_pattern] = STATE(1548),
    [sym_ternary_expression] = STATE(740),
    [sym_binary_expression] = STATE(740),
    [sym_unary_expression] = STATE(740),
    [sym_update_expression] = STATE(740),
    [sym_sequence_expression] = STATE(1331),
    [sym_string] = STATE(721),
    [sym_template_string] = STATE(721),
    [sym_regex] = STATE(721),
    [sym_meta_property] = STATE(721),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1546),
    [aux_sym_export_statement_repeat1] = STATE(1098),
    [sym_identifier] = ACTIONS(299),
    [anon_sym_export] = ACTIONS(301),
    [anon_sym_LBRACE] = ACTIONS(303),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(305),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(307),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(309),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(311),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(313),
    [anon_sym_async] = ACTIONS(315),
    [anon_sym_function] = ACTIONS(317),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(67),
    [anon_sym_void] = ACTIONS(67),
    [anon_sym_delete] = ACTIONS(67),
    [anon_sym_PLUS_PLUS] = ACTIONS(71),
    [anon_sym_DASH_DASH] = ACTIONS(71),
    [anon_sym_DQUOTE] = ACTIONS(73),
    [anon_sym_SQUOTE] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(77),
    [sym_number] = ACTIONS(79),
    [sym_this] = ACTIONS(81),
    [sym_super] = ACTIONS(81),
    [sym_true] = ACTIONS(81),
    [sym_false] = ACTIONS(81),
    [sym_null] = ACTIONS(81),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(319),
    [anon_sym_get] = ACTIONS(319),
    [anon_sym_set] = ACTIONS(319),
  },
  [33] = {
    [sym_export_statement] = STATE(387),
    [sym_declaration] = STATE(389),
    [sym_import] = STATE(721),
    [sym_import_statement] = STATE(333),
    [sym_expression_statement] = STATE(393),
    [sym_variable_declaration] = STATE(415),
    [sym_lexical_declaration] = STATE(415),
    [sym_statement_block] = STATE(394),
    [sym_if_statement] = STATE(396),
    [sym_switch_statement] = STATE(397),
    [sym_for_statement] = STATE(400),
    [sym_for_in_statement] = STATE(401),
    [sym_while_statement] = STATE(402),
    [sym_do_statement] = STATE(403),
    [sym_try_statement] = STATE(405),
    [sym_with_statement] = STATE(406),
    [sym_break_statement] = STATE(408),
    [sym_continue_statement] = STATE(409),
    [sym_debugger_statement] = STATE(411),
    [sym_return_statement] = STATE(412),
    [sym_throw_statement] = STATE(413),
    [sym_empty_statement] = STATE(414),
    [sym_labeled_statement] = STATE(416),
    [sym_parenthesized_expression] = STATE(479),
    [sym_expression] = STATE(674),
    [sym_primary_expression] = STATE(743),
    [sym_yield_expression] = STATE(740),
    [sym_object] = STATE(721),
    [sym_object_pattern] = STATE(1548),
    [sym_array] = STATE(721),
    [sym_array_pattern] = STATE(1548),
    [sym_jsx_element] = STATE(740),
    [sym_jsx_fragment] = STATE(740),
    [sym_jsx_opening_element] = STATE(972),
    [sym_jsx_self_closing_element] = STATE(740),
    [sym_class] = STATE(721),
    [sym_class_declaration] = STATE(415),
    [sym_function] = STATE(721),
    [sym_function_declaration] = STATE(415),
    [sym_generator_function] = STATE(721),
    [sym_generator_function_declaration] = STATE(415),
    [sym_arrow_function] = STATE(721),
    [sym_call_expression] = STATE(721),
    [sym_new_expression] = STATE(740),
    [sym_await_expression] = STATE(740),
    [sym_member_expression] = STATE(479),
    [sym_subscript_expression] = STATE(479),
    [sym_assignment_expression] = STATE(740),
    [sym__augmented_assignment_lhs] = STATE(942),
    [sym_augmented_assignment_expression] = STATE(740),
    [sym__destructuring_pattern] = STATE(1548),
    [sym_ternary_expression] = STATE(740),
    [sym_binary_expression] = STATE(740),
    [sym_unary_expression] = STATE(740),
    [sym_update_expression] = STATE(740),
    [sym_sequence_expression] = STATE(1331),
    [sym_string] = STATE(721),
    [sym_template_string] = STATE(721),
    [sym_regex] = STATE(721),
    [sym_meta_property] = STATE(721),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1546),
    [aux_sym_export_statement_repeat1] = STATE(1098),
    [sym_identifier] = ACTIONS(299),
    [anon_sym_export] = ACTIONS(301),
    [anon_sym_LBRACE] = ACTIONS(303),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(305),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(307),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(309),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(311),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(313),
    [anon_sym_async] = ACTIONS(315),
    [anon_sym_function] = ACTIONS(317),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(67),
    [anon_sym_void] = ACTIONS(67),
    [anon_sym_delete] = ACTIONS(67),
    [anon_sym_PLUS_PLUS] = ACTIONS(71),
    [anon_sym_DASH_DASH] = ACTIONS(71),
    [anon_sym_DQUOTE] = ACTIONS(73),
    [anon_sym_SQUOTE] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(77),
    [sym_number] = ACTIONS(79),
    [sym_this] = ACTIONS(81),
    [sym_super] = ACTIONS(81),
    [sym_true] = ACTIONS(81),
    [sym_false] = ACTIONS(81),
    [sym_null] = ACTIONS(81),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(319),
    [anon_sym_get] = ACTIONS(319),
    [anon_sym_set] = ACTIONS(319),
  },
  [34] = {
    [sym_export_statement] = STATE(419),
    [sym_declaration] = STATE(419),
    [sym_import] = STATE(721),
    [sym_import_statement] = STATE(419),
    [sym_expression_statement] = STATE(419),
    [sym_variable_declaration] = STATE(415),
    [sym_lexical_declaration] = STATE(415),
    [sym_statement_block] = STATE(419),
    [sym_if_statement] = STATE(419),
    [sym_switch_statement] = STATE(419),
    [sym_for_statement] = STATE(419),
    [sym_for_in_statement] = STATE(419),
    [sym_while_statement] = STATE(419),
    [sym_do_statement] = STATE(419),
    [sym_try_statement] = STATE(419),
    [sym_with_statement] = STATE(419),
    [sym_break_statement] = STATE(419),
    [sym_continue_statement] = STATE(419),
    [sym_debugger_statement] = STATE(419),
    [sym_return_statement] = STATE(419),
    [sym_throw_statement] = STATE(419),
    [sym_empty_statement] = STATE(419),
    [sym_labeled_statement] = STATE(419),
    [sym_parenthesized_expression] = STATE(479),
    [sym_expression] = STATE(674),
    [sym_primary_expression] = STATE(743),
    [sym_yield_expression] = STATE(740),
    [sym_object] = STATE(721),
    [sym_object_pattern] = STATE(1548),
    [sym_array] = STATE(721),
    [sym_array_pattern] = STATE(1548),
    [sym_jsx_element] = STATE(740),
    [sym_jsx_fragment] = STATE(740),
    [sym_jsx_opening_element] = STATE(972),
    [sym_jsx_self_closing_element] = STATE(740),
    [sym_class] = STATE(721),
    [sym_class_declaration] = STATE(415),
    [sym_function] = STATE(721),
    [sym_function_declaration] = STATE(415),
    [sym_generator_function] = STATE(721),
    [sym_generator_function_declaration] = STATE(415),
    [sym_arrow_function] = STATE(721),
    [sym_call_expression] = STATE(721),
    [sym_new_expression] = STATE(740),
    [sym_await_expression] = STATE(740),
    [sym_member_expression] = STATE(479),
    [sym_subscript_expression] = STATE(479),
    [sym_assignment_expression] = STATE(740),
    [sym__augmented_assignment_lhs] = STATE(942),
    [sym_augmented_assignment_expression] = STATE(740),
    [sym__destructuring_pattern] = STATE(1548),
    [sym_ternary_expression] = STATE(740),
    [sym_binary_expression] = STATE(740),
    [sym_unary_expression] = STATE(740),
    [sym_update_expression] = STATE(740),
    [sym_sequence_expression] = STATE(1331),
    [sym_string] = STATE(721),
    [sym_template_string] = STATE(721),
    [sym_regex] = STATE(721),
    [sym_meta_property] = STATE(721),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1546),
    [aux_sym_export_statement_repeat1] = STATE(1098),
    [sym_identifier] = ACTIONS(299),
    [anon_sym_export] = ACTIONS(301),
    [anon_sym_LBRACE] = ACTIONS(303),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(305),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(307),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(309),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(311),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(313),
    [anon_sym_async] = ACTIONS(315),
    [anon_sym_function] = ACTIONS(317),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(67),
    [anon_sym_void] = ACTIONS(67),
    [anon_sym_delete] = ACTIONS(67),
    [anon_sym_PLUS_PLUS] = ACTIONS(71),
    [anon_sym_DASH_DASH] = ACTIONS(71),
    [anon_sym_DQUOTE] = ACTIONS(73),
    [anon_sym_SQUOTE] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(77),
    [sym_number] = ACTIONS(79),
    [sym_this] = ACTIONS(81),
    [sym_super] = ACTIONS(81),
    [sym_true] = ACTIONS(81),
    [sym_false] = ACTIONS(81),
    [sym_null] = ACTIONS(81),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(319),
    [anon_sym_get] = ACTIONS(319),
    [anon_sym_set] = ACTIONS(319),
  },
  [35] = {
    [sym_export_statement] = STATE(418),
    [sym_declaration] = STATE(418),
    [sym_import] = STATE(721),
    [sym_import_statement] = STATE(418),
    [sym_expression_statement] = STATE(418),
    [sym_variable_declaration] = STATE(415),
    [sym_lexical_declaration] = STATE(415),
    [sym_statement_block] = STATE(418),
    [sym_if_statement] = STATE(418),
    [sym_switch_statement] = STATE(418),
    [sym_for_statement] = STATE(418),
    [sym_for_in_statement] = STATE(418),
    [sym_while_statement] = STATE(418),
    [sym_do_statement] = STATE(418),
    [sym_try_statement] = STATE(418),
    [sym_with_statement] = STATE(418),
    [sym_break_statement] = STATE(418),
    [sym_continue_statement] = STATE(418),
    [sym_debugger_statement] = STATE(418),
    [sym_return_statement] = STATE(418),
    [sym_throw_statement] = STATE(418),
    [sym_empty_statement] = STATE(418),
    [sym_labeled_statement] = STATE(418),
    [sym_parenthesized_expression] = STATE(479),
    [sym_expression] = STATE(674),
    [sym_primary_expression] = STATE(743),
    [sym_yield_expression] = STATE(740),
    [sym_object] = STATE(721),
    [sym_object_pattern] = STATE(1548),
    [sym_array] = STATE(721),
    [sym_array_pattern] = STATE(1548),
    [sym_jsx_element] = STATE(740),
    [sym_jsx_fragment] = STATE(740),
    [sym_jsx_opening_element] = STATE(972),
    [sym_jsx_self_closing_element] = STATE(740),
    [sym_class] = STATE(721),
    [sym_class_declaration] = STATE(415),
    [sym_function] = STATE(721),
    [sym_function_declaration] = STATE(415),
    [sym_generator_function] = STATE(721),
    [sym_generator_function_declaration] = STATE(415),
    [sym_arrow_function] = STATE(721),
    [sym_call_expression] = STATE(721),
    [sym_new_expression] = STATE(740),
    [sym_await_expression] = STATE(740),
    [sym_member_expression] = STATE(479),
    [sym_subscript_expression] = STATE(479),
    [sym_assignment_expression] = STATE(740),
    [sym__augmented_assignment_lhs] = STATE(942),
    [sym_augmented_assignment_expression] = STATE(740),
    [sym__destructuring_pattern] = STATE(1548),
    [sym_ternary_expression] = STATE(740),
    [sym_binary_expression] = STATE(740),
    [sym_unary_expression] = STATE(740),
    [sym_update_expression] = STATE(740),
    [sym_sequence_expression] = STATE(1331),
    [sym_string] = STATE(721),
    [sym_template_string] = STATE(721),
    [sym_regex] = STATE(721),
    [sym_meta_property] = STATE(721),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1546),
    [aux_sym_export_statement_repeat1] = STATE(1098),
    [sym_identifier] = ACTIONS(299),
    [anon_sym_export] = ACTIONS(301),
    [anon_sym_LBRACE] = ACTIONS(303),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(305),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(307),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(309),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(311),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(313),
    [anon_sym_async] = ACTIONS(315),
    [anon_sym_function] = ACTIONS(317),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(67),
    [anon_sym_void] = ACTIONS(67),
    [anon_sym_delete] = ACTIONS(67),
    [anon_sym_PLUS_PLUS] = ACTIONS(71),
    [anon_sym_DASH_DASH] = ACTIONS(71),
    [anon_sym_DQUOTE] = ACTIONS(73),
    [anon_sym_SQUOTE] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(77),
    [sym_number] = ACTIONS(79),
    [sym_this] = ACTIONS(81),
    [sym_super] = ACTIONS(81),
    [sym_true] = ACTIONS(81),
    [sym_false] = ACTIONS(81),
    [sym_null] = ACTIONS(81),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(319),
    [anon_sym_get] = ACTIONS(319),
    [anon_sym_set] = ACTIONS(319),
  },
  [36] = {
    [sym_export_statement] = STATE(1186),
    [sym_declaration] = STATE(1186),
    [sym_import] = STATE(721),
    [sym_import_statement] = STATE(1186),
    [sym_expression_statement] = STATE(1186),
    [sym_variable_declaration] = STATE(415),
    [sym_lexical_declaration] = STATE(415),
    [sym_statement_block] = STATE(1186),
    [sym_if_statement] = STATE(1186),
    [sym_switch_statement] = STATE(1186),
    [sym_for_statement] = STATE(1186),
    [sym_for_in_statement] = STATE(1186),
    [sym_while_statement] = STATE(1186),
    [sym_do_statement] = STATE(1186),
    [sym_try_statement] = STATE(1186),
    [sym_with_statement] = STATE(1186),
    [sym_break_statement] = STATE(1186),
    [sym_continue_statement] = STATE(1186),
    [sym_debugger_statement] = STATE(1186),
    [sym_return_statement] = STATE(1186),
    [sym_throw_statement] = STATE(1186),
    [sym_empty_statement] = STATE(1186),
    [sym_labeled_statement] = STATE(1186),
    [sym_parenthesized_expression] = STATE(479),
    [sym_expression] = STATE(674),
    [sym_primary_expression] = STATE(743),
    [sym_yield_expression] = STATE(740),
    [sym_object] = STATE(721),
    [sym_object_pattern] = STATE(1548),
    [sym_array] = STATE(721),
    [sym_array_pattern] = STATE(1548),
    [sym_jsx_element] = STATE(740),
    [sym_jsx_fragment] = STATE(740),
    [sym_jsx_opening_element] = STATE(972),
    [sym_jsx_self_closing_element] = STATE(740),
    [sym_class] = STATE(721),
    [sym_class_declaration] = STATE(415),
    [sym_function] = STATE(721),
    [sym_function_declaration] = STATE(415),
    [sym_generator_function] = STATE(721),
    [sym_generator_function_declaration] = STATE(415),
    [sym_arrow_function] = STATE(721),
    [sym_call_expression] = STATE(721),
    [sym_new_expression] = STATE(740),
    [sym_await_expression] = STATE(740),
    [sym_member_expression] = STATE(479),
    [sym_subscript_expression] = STATE(479),
    [sym_assignment_expression] = STATE(740),
    [sym__augmented_assignment_lhs] = STATE(942),
    [sym_augmented_assignment_expression] = STATE(740),
    [sym__destructuring_pattern] = STATE(1548),
    [sym_ternary_expression] = STATE(740),
    [sym_binary_expression] = STATE(740),
    [sym_unary_expression] = STATE(740),
    [sym_update_expression] = STATE(740),
    [sym_sequence_expression] = STATE(1331),
    [sym_string] = STATE(721),
    [sym_template_string] = STATE(721),
    [sym_regex] = STATE(721),
    [sym_meta_property] = STATE(721),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1546),
    [aux_sym_export_statement_repeat1] = STATE(1098),
    [sym_identifier] = ACTIONS(299),
    [anon_sym_export] = ACTIONS(301),
    [anon_sym_LBRACE] = ACTIONS(303),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(305),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(307),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(309),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(311),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(313),
    [anon_sym_async] = ACTIONS(315),
    [anon_sym_function] = ACTIONS(317),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(67),
    [anon_sym_void] = ACTIONS(67),
    [anon_sym_delete] = ACTIONS(67),
    [anon_sym_PLUS_PLUS] = ACTIONS(71),
    [anon_sym_DASH_DASH] = ACTIONS(71),
    [anon_sym_DQUOTE] = ACTIONS(73),
    [anon_sym_SQUOTE] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(77),
    [sym_number] = ACTIONS(79),
    [sym_this] = ACTIONS(81),
    [sym_super] = ACTIONS(81),
    [sym_true] = ACTIONS(81),
    [sym_false] = ACTIONS(81),
    [sym_null] = ACTIONS(81),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(319),
    [anon_sym_get] = ACTIONS(319),
    [anon_sym_set] = ACTIONS(319),
  },
  [37] = {
    [sym_export_statement] = STATE(359),
    [sym_declaration] = STATE(361),
    [sym_import] = STATE(721),
    [sym_import_statement] = STATE(362),
    [sym_expression_statement] = STATE(363),
    [sym_variable_declaration] = STATE(415),
    [sym_lexical_declaration] = STATE(415),
    [sym_statement_block] = STATE(364),
    [sym_if_statement] = STATE(365),
    [sym_switch_statement] = STATE(372),
    [sym_for_statement] = STATE(373),
    [sym_for_in_statement] = STATE(391),
    [sym_while_statement] = STATE(334),
    [sym_do_statement] = STATE(335),
    [sym_try_statement] = STATE(336),
    [sym_with_statement] = STATE(337),
    [sym_break_statement] = STATE(338),
    [sym_continue_statement] = STATE(339),
    [sym_debugger_statement] = STATE(340),
    [sym_return_statement] = STATE(341),
    [sym_throw_statement] = STATE(342),
    [sym_empty_statement] = STATE(343),
    [sym_labeled_statement] = STATE(344),
    [sym_parenthesized_expression] = STATE(479),
    [sym_expression] = STATE(674),
    [sym_primary_expression] = STATE(743),
    [sym_yield_expression] = STATE(740),
    [sym_object] = STATE(721),
    [sym_object_pattern] = STATE(1548),
    [sym_array] = STATE(721),
    [sym_array_pattern] = STATE(1548),
    [sym_jsx_element] = STATE(740),
    [sym_jsx_fragment] = STATE(740),
    [sym_jsx_opening_element] = STATE(972),
    [sym_jsx_self_closing_element] = STATE(740),
    [sym_class] = STATE(721),
    [sym_class_declaration] = STATE(415),
    [sym_function] = STATE(721),
    [sym_function_declaration] = STATE(415),
    [sym_generator_function] = STATE(721),
    [sym_generator_function_declaration] = STATE(415),
    [sym_arrow_function] = STATE(721),
    [sym_call_expression] = STATE(721),
    [sym_new_expression] = STATE(740),
    [sym_await_expression] = STATE(740),
    [sym_member_expression] = STATE(479),
    [sym_subscript_expression] = STATE(479),
    [sym_assignment_expression] = STATE(740),
    [sym__augmented_assignment_lhs] = STATE(942),
    [sym_augmented_assignment_expression] = STATE(740),
    [sym__destructuring_pattern] = STATE(1548),
    [sym_ternary_expression] = STATE(740),
    [sym_binary_expression] = STATE(740),
    [sym_unary_expression] = STATE(740),
    [sym_update_expression] = STATE(740),
    [sym_sequence_expression] = STATE(1331),
    [sym_string] = STATE(721),
    [sym_template_string] = STATE(721),
    [sym_regex] = STATE(721),
    [sym_meta_property] = STATE(721),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1546),
    [aux_sym_export_statement_repeat1] = STATE(1091),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(61),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(67),
    [anon_sym_void] = ACTIONS(67),
    [anon_sym_delete] = ACTIONS(67),
    [anon_sym_PLUS_PLUS] = ACTIONS(71),
    [anon_sym_DASH_DASH] = ACTIONS(71),
    [anon_sym_DQUOTE] = ACTIONS(73),
    [anon_sym_SQUOTE] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(77),
    [sym_number] = ACTIONS(79),
    [sym_this] = ACTIONS(81),
    [sym_super] = ACTIONS(81),
    [sym_true] = ACTIONS(81),
    [sym_false] = ACTIONS(81),
    [sym_null] = ACTIONS(81),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(87),
    [anon_sym_get] = ACTIONS(87),
    [anon_sym_set] = ACTIONS(87),
  },
  [38] = {
    [sym_export_statement] = STATE(375),
    [sym_declaration] = STATE(375),
    [sym_import] = STATE(721),
    [sym_import_statement] = STATE(375),
    [sym_expression_statement] = STATE(375),
    [sym_variable_declaration] = STATE(415),
    [sym_lexical_declaration] = STATE(415),
    [sym_statement_block] = STATE(375),
    [sym_if_statement] = STATE(375),
    [sym_switch_statement] = STATE(375),
    [sym_for_statement] = STATE(375),
    [sym_for_in_statement] = STATE(375),
    [sym_while_statement] = STATE(375),
    [sym_do_statement] = STATE(375),
    [sym_try_statement] = STATE(375),
    [sym_with_statement] = STATE(375),
    [sym_break_statement] = STATE(375),
    [sym_continue_statement] = STATE(375),
    [sym_debugger_statement] = STATE(375),
    [sym_return_statement] = STATE(375),
    [sym_throw_statement] = STATE(375),
    [sym_empty_statement] = STATE(375),
    [sym_labeled_statement] = STATE(375),
    [sym_parenthesized_expression] = STATE(479),
    [sym_expression] = STATE(674),
    [sym_primary_expression] = STATE(743),
    [sym_yield_expression] = STATE(740),
    [sym_object] = STATE(721),
    [sym_object_pattern] = STATE(1548),
    [sym_array] = STATE(721),
    [sym_array_pattern] = STATE(1548),
    [sym_jsx_element] = STATE(740),
    [sym_jsx_fragment] = STATE(740),
    [sym_jsx_opening_element] = STATE(972),
    [sym_jsx_self_closing_element] = STATE(740),
    [sym_class] = STATE(721),
    [sym_class_declaration] = STATE(415),
    [sym_function] = STATE(721),
    [sym_function_declaration] = STATE(415),
    [sym_generator_function] = STATE(721),
    [sym_generator_function_declaration] = STATE(415),
    [sym_arrow_function] = STATE(721),
    [sym_call_expression] = STATE(721),
    [sym_new_expression] = STATE(740),
    [sym_await_expression] = STATE(740),
    [sym_member_expression] = STATE(479),
    [sym_subscript_expression] = STATE(479),
    [sym_assignment_expression] = STATE(740),
    [sym__augmented_assignment_lhs] = STATE(942),
    [sym_augmented_assignment_expression] = STATE(740),
    [sym__destructuring_pattern] = STATE(1548),
    [sym_ternary_expression] = STATE(740),
    [sym_binary_expression] = STATE(740),
    [sym_unary_expression] = STATE(740),
    [sym_update_expression] = STATE(740),
    [sym_sequence_expression] = STATE(1331),
    [sym_string] = STATE(721),
    [sym_template_string] = STATE(721),
    [sym_regex] = STATE(721),
    [sym_meta_property] = STATE(721),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1546),
    [aux_sym_export_statement_repeat1] = STATE(1098),
    [sym_identifier] = ACTIONS(299),
    [anon_sym_export] = ACTIONS(301),
    [anon_sym_LBRACE] = ACTIONS(303),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(305),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(307),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(309),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(311),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(313),
    [anon_sym_async] = ACTIONS(315),
    [anon_sym_function] = ACTIONS(317),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(67),
    [anon_sym_void] = ACTIONS(67),
    [anon_sym_delete] = ACTIONS(67),
    [anon_sym_PLUS_PLUS] = ACTIONS(71),
    [anon_sym_DASH_DASH] = ACTIONS(71),
    [anon_sym_DQUOTE] = ACTIONS(73),
    [anon_sym_SQUOTE] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(77),
    [sym_number] = ACTIONS(79),
    [sym_this] = ACTIONS(81),
    [sym_super] = ACTIONS(81),
    [sym_true] = ACTIONS(81),
    [sym_false] = ACTIONS(81),
    [sym_null] = ACTIONS(81),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(319),
    [anon_sym_get] = ACTIONS(319),
    [anon_sym_set] = ACTIONS(319),
  },
  [39] = {
    [sym_export_statement] = STATE(360),
    [sym_declaration] = STATE(360),
    [sym_import] = STATE(721),
    [sym_import_statement] = STATE(360),
    [sym_expression_statement] = STATE(360),
    [sym_variable_declaration] = STATE(415),
    [sym_lexical_declaration] = STATE(415),
    [sym_statement_block] = STATE(360),
    [sym_if_statement] = STATE(360),
    [sym_switch_statement] = STATE(360),
    [sym_for_statement] = STATE(360),
    [sym_for_in_statement] = STATE(360),
    [sym_while_statement] = STATE(360),
    [sym_do_statement] = STATE(360),
    [sym_try_statement] = STATE(360),
    [sym_with_statement] = STATE(360),
    [sym_break_statement] = STATE(360),
    [sym_continue_statement] = STATE(360),
    [sym_debugger_statement] = STATE(360),
    [sym_return_statement] = STATE(360),
    [sym_throw_statement] = STATE(360),
    [sym_empty_statement] = STATE(360),
    [sym_labeled_statement] = STATE(360),
    [sym_parenthesized_expression] = STATE(479),
    [sym_expression] = STATE(674),
    [sym_primary_expression] = STATE(743),
    [sym_yield_expression] = STATE(740),
    [sym_object] = STATE(721),
    [sym_object_pattern] = STATE(1548),
    [sym_array] = STATE(721),
    [sym_array_pattern] = STATE(1548),
    [sym_jsx_element] = STATE(740),
    [sym_jsx_fragment] = STATE(740),
    [sym_jsx_opening_element] = STATE(972),
    [sym_jsx_self_closing_element] = STATE(740),
    [sym_class] = STATE(721),
    [sym_class_declaration] = STATE(415),
    [sym_function] = STATE(721),
    [sym_function_declaration] = STATE(415),
    [sym_generator_function] = STATE(721),
    [sym_generator_function_declaration] = STATE(415),
    [sym_arrow_function] = STATE(721),
    [sym_call_expression] = STATE(721),
    [sym_new_expression] = STATE(740),
    [sym_await_expression] = STATE(740),
    [sym_member_expression] = STATE(479),
    [sym_subscript_expression] = STATE(479),
    [sym_assignment_expression] = STATE(740),
    [sym__augmented_assignment_lhs] = STATE(942),
    [sym_augmented_assignment_expression] = STATE(740),
    [sym__destructuring_pattern] = STATE(1548),
    [sym_ternary_expression] = STATE(740),
    [sym_binary_expression] = STATE(740),
    [sym_unary_expression] = STATE(740),
    [sym_update_expression] = STATE(740),
    [sym_sequence_expression] = STATE(1331),
    [sym_string] = STATE(721),
    [sym_template_string] = STATE(721),
    [sym_regex] = STATE(721),
    [sym_meta_property] = STATE(721),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1546),
    [aux_sym_export_statement_repeat1] = STATE(1091),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(61),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(67),
    [anon_sym_void] = ACTIONS(67),
    [anon_sym_delete] = ACTIONS(67),
    [anon_sym_PLUS_PLUS] = ACTIONS(71),
    [anon_sym_DASH_DASH] = ACTIONS(71),
    [anon_sym_DQUOTE] = ACTIONS(73),
    [anon_sym_SQUOTE] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(77),
    [sym_number] = ACTIONS(79),
    [sym_this] = ACTIONS(81),
    [sym_super] = ACTIONS(81),
    [sym_true] = ACTIONS(81),
    [sym_false] = ACTIONS(81),
    [sym_null] = ACTIONS(81),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(87),
    [anon_sym_get] = ACTIONS(87),
    [anon_sym_set] = ACTIONS(87),
  },
  [40] = {
    [sym_export_statement] = STATE(367),
    [sym_declaration] = STATE(367),
    [sym_import] = STATE(721),
    [sym_import_statement] = STATE(367),
    [sym_expression_statement] = STATE(367),
    [sym_variable_declaration] = STATE(415),
    [sym_lexical_declaration] = STATE(415),
    [sym_statement_block] = STATE(367),
    [sym_if_statement] = STATE(367),
    [sym_switch_statement] = STATE(367),
    [sym_for_statement] = STATE(367),
    [sym_for_in_statement] = STATE(367),
    [sym_while_statement] = STATE(367),
    [sym_do_statement] = STATE(367),
    [sym_try_statement] = STATE(367),
    [sym_with_statement] = STATE(367),
    [sym_break_statement] = STATE(367),
    [sym_continue_statement] = STATE(367),
    [sym_debugger_statement] = STATE(367),
    [sym_return_statement] = STATE(367),
    [sym_throw_statement] = STATE(367),
    [sym_empty_statement] = STATE(367),
    [sym_labeled_statement] = STATE(367),
    [sym_parenthesized_expression] = STATE(479),
    [sym_expression] = STATE(674),
    [sym_primary_expression] = STATE(743),
    [sym_yield_expression] = STATE(740),
    [sym_object] = STATE(721),
    [sym_object_pattern] = STATE(1548),
    [sym_array] = STATE(721),
    [sym_array_pattern] = STATE(1548),
    [sym_jsx_element] = STATE(740),
    [sym_jsx_fragment] = STATE(740),
    [sym_jsx_opening_element] = STATE(972),
    [sym_jsx_self_closing_element] = STATE(740),
    [sym_class] = STATE(721),
    [sym_class_declaration] = STATE(415),
    [sym_function] = STATE(721),
    [sym_function_declaration] = STATE(415),
    [sym_generator_function] = STATE(721),
    [sym_generator_function_declaration] = STATE(415),
    [sym_arrow_function] = STATE(721),
    [sym_call_expression] = STATE(721),
    [sym_new_expression] = STATE(740),
    [sym_await_expression] = STATE(740),
    [sym_member_expression] = STATE(479),
    [sym_subscript_expression] = STATE(479),
    [sym_assignment_expression] = STATE(740),
    [sym__augmented_assignment_lhs] = STATE(942),
    [sym_augmented_assignment_expression] = STATE(740),
    [sym__destructuring_pattern] = STATE(1548),
    [sym_ternary_expression] = STATE(740),
    [sym_binary_expression] = STATE(740),
    [sym_unary_expression] = STATE(740),
    [sym_update_expression] = STATE(740),
    [sym_sequence_expression] = STATE(1331),
    [sym_string] = STATE(721),
    [sym_template_string] = STATE(721),
    [sym_regex] = STATE(721),
    [sym_meta_property] = STATE(721),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1546),
    [aux_sym_export_statement_repeat1] = STATE(1091),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(61),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(67),
    [anon_sym_void] = ACTIONS(67),
    [anon_sym_delete] = ACTIONS(67),
    [anon_sym_PLUS_PLUS] = ACTIONS(71),
    [anon_sym_DASH_DASH] = ACTIONS(71),
    [anon_sym_DQUOTE] = ACTIONS(73),
    [anon_sym_SQUOTE] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(77),
    [sym_number] = ACTIONS(79),
    [sym_this] = ACTIONS(81),
    [sym_super] = ACTIONS(81),
    [sym_true] = ACTIONS(81),
    [sym_false] = ACTIONS(81),
    [sym_null] = ACTIONS(81),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(87),
    [anon_sym_get] = ACTIONS(87),
    [anon_sym_set] = ACTIONS(87),
  },
  [41] = {
    [sym_export_statement] = STATE(312),
    [sym_declaration] = STATE(312),
    [sym_import] = STATE(721),
    [sym_import_statement] = STATE(312),
    [sym_expression_statement] = STATE(312),
    [sym_variable_declaration] = STATE(415),
    [sym_lexical_declaration] = STATE(415),
    [sym_statement_block] = STATE(312),
    [sym_if_statement] = STATE(312),
    [sym_switch_statement] = STATE(312),
    [sym_for_statement] = STATE(312),
    [sym_for_in_statement] = STATE(312),
    [sym_while_statement] = STATE(312),
    [sym_do_statement] = STATE(312),
    [sym_try_statement] = STATE(312),
    [sym_with_statement] = STATE(312),
    [sym_break_statement] = STATE(312),
    [sym_continue_statement] = STATE(312),
    [sym_debugger_statement] = STATE(312),
    [sym_return_statement] = STATE(312),
    [sym_throw_statement] = STATE(312),
    [sym_empty_statement] = STATE(312),
    [sym_labeled_statement] = STATE(312),
    [sym_parenthesized_expression] = STATE(479),
    [sym_expression] = STATE(674),
    [sym_primary_expression] = STATE(743),
    [sym_yield_expression] = STATE(740),
    [sym_object] = STATE(721),
    [sym_object_pattern] = STATE(1548),
    [sym_array] = STATE(721),
    [sym_array_pattern] = STATE(1548),
    [sym_jsx_element] = STATE(740),
    [sym_jsx_fragment] = STATE(740),
    [sym_jsx_opening_element] = STATE(972),
    [sym_jsx_self_closing_element] = STATE(740),
    [sym_class] = STATE(721),
    [sym_class_declaration] = STATE(415),
    [sym_function] = STATE(721),
    [sym_function_declaration] = STATE(415),
    [sym_generator_function] = STATE(721),
    [sym_generator_function_declaration] = STATE(415),
    [sym_arrow_function] = STATE(721),
    [sym_call_expression] = STATE(721),
    [sym_new_expression] = STATE(740),
    [sym_await_expression] = STATE(740),
    [sym_member_expression] = STATE(479),
    [sym_subscript_expression] = STATE(479),
    [sym_assignment_expression] = STATE(740),
    [sym__augmented_assignment_lhs] = STATE(942),
    [sym_augmented_assignment_expression] = STATE(740),
    [sym__destructuring_pattern] = STATE(1548),
    [sym_ternary_expression] = STATE(740),
    [sym_binary_expression] = STATE(740),
    [sym_unary_expression] = STATE(740),
    [sym_update_expression] = STATE(740),
    [sym_sequence_expression] = STATE(1331),
    [sym_string] = STATE(721),
    [sym_template_string] = STATE(721),
    [sym_regex] = STATE(721),
    [sym_meta_property] = STATE(721),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1546),
    [aux_sym_export_statement_repeat1] = STATE(1091),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(61),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(67),
    [anon_sym_void] = ACTIONS(67),
    [anon_sym_delete] = ACTIONS(67),
    [anon_sym_PLUS_PLUS] = ACTIONS(71),
    [anon_sym_DASH_DASH] = ACTIONS(71),
    [anon_sym_DQUOTE] = ACTIONS(73),
    [anon_sym_SQUOTE] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(77),
    [sym_number] = ACTIONS(79),
    [sym_this] = ACTIONS(81),
    [sym_super] = ACTIONS(81),
    [sym_true] = ACTIONS(81),
    [sym_false] = ACTIONS(81),
    [sym_null] = ACTIONS(81),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(87),
    [anon_sym_get] = ACTIONS(87),
    [anon_sym_set] = ACTIONS(87),
  },
  [42] = {
    [sym_import] = STATE(575),
    [sym_parenthesized_expression] = STATE(449),
    [sym_expression] = STATE(580),
    [sym_primary_expression] = STATE(576),
    [sym_yield_expression] = STATE(577),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1528),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1528),
    [sym_jsx_element] = STATE(577),
    [sym_jsx_fragment] = STATE(577),
    [sym_jsx_opening_element] = STATE(975),
    [sym_jsx_self_closing_element] = STATE(577),
    [sym_class] = STATE(575),
    [sym_function] = STATE(575),
    [sym_generator_function] = STATE(575),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(577),
    [sym_await_expression] = STATE(577),
    [sym_member_expression] = STATE(449),
    [sym_subscript_expression] = STATE(449),
    [sym_assignment_expression] = STATE(577),
    [sym__augmented_assignment_lhs] = STATE(943),
    [sym_augmented_assignment_expression] = STATE(577),
    [sym__destructuring_pattern] = STATE(1528),
    [sym_ternary_expression] = STATE(577),
    [sym_binary_expression] = STATE(577),
    [sym_unary_expression] = STATE(577),
    [sym_update_expression] = STATE(577),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1496),
    [aux_sym_export_statement_repeat1] = STATE(1182),
    [sym_identifier] = ACTIONS(321),
    [anon_sym_export] = ACTIONS(323),
    [anon_sym_STAR] = ACTIONS(325),
    [anon_sym_LBRACE] = ACTIONS(327),
    [anon_sym_COMMA] = ACTIONS(329),
    [anon_sym_RBRACE] = ACTIONS(329),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_RPAREN] = ACTIONS(329),
    [anon_sym_await] = ACTIONS(335),
    [anon_sym_in] = ACTIONS(337),
    [anon_sym_COLON] = ACTIONS(329),
    [anon_sym_yield] = ACTIONS(339),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_RBRACK] = ACTIONS(329),
    [anon_sym_LT] = ACTIONS(343),
    [anon_sym_GT] = ACTIONS(337),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_DOT] = ACTIONS(337),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(349),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_QMARK_DOT] = ACTIONS(329),
    [anon_sym_new] = ACTIONS(353),
    [anon_sym_AMP_AMP] = ACTIONS(329),
    [anon_sym_PIPE_PIPE] = ACTIONS(329),
    [anon_sym_GT_GT] = ACTIONS(337),
    [anon_sym_GT_GT_GT] = ACTIONS(329),
    [anon_sym_LT_LT] = ACTIONS(329),
    [anon_sym_AMP] = ACTIONS(337),
    [anon_sym_CARET] = ACTIONS(329),
    [anon_sym_PIPE] = ACTIONS(337),
    [anon_sym_PLUS] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(355),
    [anon_sym_PERCENT] = ACTIONS(329),
    [anon_sym_STAR_STAR] = ACTIONS(329),
    [anon_sym_LT_EQ] = ACTIONS(329),
    [anon_sym_EQ_EQ] = ACTIONS(337),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(329),
    [anon_sym_BANG_EQ] = ACTIONS(337),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(329),
    [anon_sym_GT_EQ] = ACTIONS(329),
    [anon_sym_QMARK_QMARK] = ACTIONS(329),
    [anon_sym_instanceof] = ACTIONS(337),
    [anon_sym_BANG] = ACTIONS(355),
    [anon_sym_TILDE] = ACTIONS(357),
    [anon_sym_typeof] = ACTIONS(355),
    [anon_sym_void] = ACTIONS(355),
    [anon_sym_delete] = ACTIONS(355),
    [anon_sym_PLUS_PLUS] = ACTIONS(359),
    [anon_sym_DASH_DASH] = ACTIONS(359),
    [anon_sym_DQUOTE] = ACTIONS(361),
    [anon_sym_SQUOTE] = ACTIONS(363),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(365),
    [sym_number] = ACTIONS(367),
    [sym_this] = ACTIONS(369),
    [sym_super] = ACTIONS(369),
    [sym_true] = ACTIONS(369),
    [sym_false] = ACTIONS(369),
    [sym_null] = ACTIONS(369),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(323),
    [anon_sym_get] = ACTIONS(323),
    [anon_sym_set] = ACTIONS(323),
    [sym__ternary_qmark] = ACTIONS(329),
  },
  [43] = {
    [sym_import] = STATE(721),
    [sym_parenthesized_expression] = STATE(466),
    [sym_expression] = STATE(602),
    [sym_primary_expression] = STATE(743),
    [sym_yield_expression] = STATE(740),
    [sym_object] = STATE(721),
    [sym_object_pattern] = STATE(1486),
    [sym_array] = STATE(721),
    [sym_array_pattern] = STATE(1486),
    [sym_jsx_element] = STATE(740),
    [sym_jsx_fragment] = STATE(740),
    [sym_jsx_opening_element] = STATE(972),
    [sym_jsx_self_closing_element] = STATE(740),
    [sym_class] = STATE(721),
    [sym_function] = STATE(721),
    [sym_generator_function] = STATE(721),
    [sym_arrow_function] = STATE(721),
    [sym_call_expression] = STATE(721),
    [sym_new_expression] = STATE(740),
    [sym_await_expression] = STATE(740),
    [sym_member_expression] = STATE(466),
    [sym_subscript_expression] = STATE(466),
    [sym_assignment_expression] = STATE(740),
    [sym__augmented_assignment_lhs] = STATE(940),
    [sym_augmented_assignment_expression] = STATE(740),
    [sym__destructuring_pattern] = STATE(1486),
    [sym_ternary_expression] = STATE(740),
    [sym_binary_expression] = STATE(740),
    [sym_unary_expression] = STATE(740),
    [sym_update_expression] = STATE(740),
    [sym_string] = STATE(721),
    [sym_template_string] = STATE(721),
    [sym_regex] = STATE(721),
    [sym_meta_property] = STATE(721),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1487),
    [aux_sym_export_statement_repeat1] = STATE(1154),
    [sym_identifier] = ACTIONS(373),
    [anon_sym_export] = ACTIONS(375),
    [anon_sym_STAR] = ACTIONS(377),
    [anon_sym_LBRACE] = ACTIONS(379),
    [anon_sym_COMMA] = ACTIONS(329),
    [anon_sym_import] = ACTIONS(381),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(383),
    [anon_sym_in] = ACTIONS(337),
    [anon_sym_of] = ACTIONS(337),
    [anon_sym_SEMI] = ACTIONS(329),
    [anon_sym_yield] = ACTIONS(385),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(387),
    [anon_sym_GT] = ACTIONS(337),
    [anon_sym_SLASH] = ACTIONS(389),
    [anon_sym_DOT] = ACTIONS(337),
    [anon_sym_class] = ACTIONS(391),
    [anon_sym_async] = ACTIONS(393),
    [anon_sym_function] = ACTIONS(395),
    [anon_sym_QMARK_DOT] = ACTIONS(329),
    [anon_sym_new] = ACTIONS(397),
    [anon_sym_AMP_AMP] = ACTIONS(329),
    [anon_sym_PIPE_PIPE] = ACTIONS(329),
    [anon_sym_GT_GT] = ACTIONS(337),
    [anon_sym_GT_GT_GT] = ACTIONS(329),
    [anon_sym_LT_LT] = ACTIONS(329),
    [anon_sym_AMP] = ACTIONS(337),
    [anon_sym_CARET] = ACTIONS(329),
    [anon_sym_PIPE] = ACTIONS(337),
    [anon_sym_PLUS] = ACTIONS(399),
    [anon_sym_DASH] = ACTIONS(399),
    [anon_sym_PERCENT] = ACTIONS(329),
    [anon_sym_STAR_STAR] = ACTIONS(329),
    [anon_sym_LT_EQ] = ACTIONS(329),
    [anon_sym_EQ_EQ] = ACTIONS(337),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(329),
    [anon_sym_BANG_EQ] = ACTIONS(337),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(329),
    [anon_sym_GT_EQ] = ACTIONS(329),
    [anon_sym_QMARK_QMARK] = ACTIONS(329),
    [anon_sym_instanceof] = ACTIONS(337),
    [anon_sym_BANG] = ACTIONS(399),
    [anon_sym_TILDE] = ACTIONS(401),
    [anon_sym_typeof] = ACTIONS(399),
    [anon_sym_void] = ACTIONS(399),
    [anon_sym_delete] = ACTIONS(399),
    [anon_sym_PLUS_PLUS] = ACTIONS(403),
    [anon_sym_DASH_DASH] = ACTIONS(403),
    [anon_sym_DQUOTE] = ACTIONS(73),
    [anon_sym_SQUOTE] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(77),
    [sym_number] = ACTIONS(79),
    [sym_this] = ACTIONS(81),
    [sym_super] = ACTIONS(81),
    [sym_true] = ACTIONS(81),
    [sym_false] = ACTIONS(81),
    [sym_null] = ACTIONS(81),
    [sym_undefined] = ACTIONS(405),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(375),
    [anon_sym_get] = ACTIONS(375),
    [anon_sym_set] = ACTIONS(375),
    [sym__automatic_semicolon] = ACTIONS(329),
    [sym__ternary_qmark] = ACTIONS(329),
  },
  [44] = {
    [sym_import] = STATE(721),
    [sym_parenthesized_expression] = STATE(479),
    [sym_expression] = STATE(601),
    [sym_primary_expression] = STATE(743),
    [sym_yield_expression] = STATE(740),
    [sym_object] = STATE(721),
    [sym_object_pattern] = STATE(1548),
    [sym_array] = STATE(721),
    [sym_array_pattern] = STATE(1548),
    [sym_jsx_element] = STATE(740),
    [sym_jsx_fragment] = STATE(740),
    [sym_jsx_opening_element] = STATE(972),
    [sym_jsx_self_closing_element] = STATE(740),
    [sym_class] = STATE(721),
    [sym_function] = STATE(721),
    [sym_generator_function] = STATE(721),
    [sym_arrow_function] = STATE(721),
    [sym_call_expression] = STATE(721),
    [sym_new_expression] = STATE(740),
    [sym_await_expression] = STATE(740),
    [sym_member_expression] = STATE(479),
    [sym_subscript_expression] = STATE(479),
    [sym_assignment_expression] = STATE(740),
    [sym__augmented_assignment_lhs] = STATE(942),
    [sym_augmented_assignment_expression] = STATE(740),
    [sym__destructuring_pattern] = STATE(1548),
    [sym_ternary_expression] = STATE(740),
    [sym_binary_expression] = STATE(740),
    [sym_unary_expression] = STATE(740),
    [sym_update_expression] = STATE(740),
    [sym_string] = STATE(721),
    [sym_template_string] = STATE(721),
    [sym_regex] = STATE(721),
    [sym_meta_property] = STATE(721),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1546),
    [aux_sym_export_statement_repeat1] = STATE(1154),
    [sym_identifier] = ACTIONS(407),
    [anon_sym_export] = ACTIONS(409),
    [anon_sym_STAR] = ACTIONS(411),
    [anon_sym_LBRACE] = ACTIONS(379),
    [anon_sym_COMMA] = ACTIONS(329),
    [anon_sym_RBRACE] = ACTIONS(329),
    [anon_sym_import] = ACTIONS(381),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_in] = ACTIONS(337),
    [anon_sym_SEMI] = ACTIONS(329),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(387),
    [anon_sym_GT] = ACTIONS(337),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_DOT] = ACTIONS(337),
    [anon_sym_class] = ACTIONS(391),
    [anon_sym_async] = ACTIONS(413),
    [anon_sym_function] = ACTIONS(395),
    [anon_sym_QMARK_DOT] = ACTIONS(329),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_AMP_AMP] = ACTIONS(329),
    [anon_sym_PIPE_PIPE] = ACTIONS(329),
    [anon_sym_GT_GT] = ACTIONS(337),
    [anon_sym_GT_GT_GT] = ACTIONS(329),
    [anon_sym_LT_LT] = ACTIONS(329),
    [anon_sym_AMP] = ACTIONS(337),
    [anon_sym_CARET] = ACTIONS(329),
    [anon_sym_PIPE] = ACTIONS(337),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_PERCENT] = ACTIONS(329),
    [anon_sym_STAR_STAR] = ACTIONS(329),
    [anon_sym_LT_EQ] = ACTIONS(329),
    [anon_sym_EQ_EQ] = ACTIONS(337),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(329),
    [anon_sym_BANG_EQ] = ACTIONS(337),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(329),
    [anon_sym_GT_EQ] = ACTIONS(329),
    [anon_sym_QMARK_QMARK] = ACTIONS(329),
    [anon_sym_instanceof] = ACTIONS(337),
    [anon_sym_BANG] = ACTIONS(67),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(67),
    [anon_sym_void] = ACTIONS(67),
    [anon_sym_delete] = ACTIONS(67),
    [anon_sym_PLUS_PLUS] = ACTIONS(71),
    [anon_sym_DASH_DASH] = ACTIONS(71),
    [anon_sym_DQUOTE] = ACTIONS(73),
    [anon_sym_SQUOTE] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(77),
    [sym_number] = ACTIONS(79),
    [sym_this] = ACTIONS(81),
    [sym_super] = ACTIONS(81),
    [sym_true] = ACTIONS(81),
    [sym_false] = ACTIONS(81),
    [sym_null] = ACTIONS(81),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(409),
    [anon_sym_get] = ACTIONS(409),
    [anon_sym_set] = ACTIONS(409),
    [sym__automatic_semicolon] = ACTIONS(329),
    [sym__ternary_qmark] = ACTIONS(329),
  },
  [45] = {
    [sym_import] = STATE(575),
    [sym_parenthesized_expression] = STATE(493),
    [sym_expression] = STATE(802),
    [sym_primary_expression] = STATE(576),
    [sym_yield_expression] = STATE(577),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1580),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1580),
    [sym_jsx_element] = STATE(577),
    [sym_jsx_fragment] = STATE(577),
    [sym_jsx_opening_element] = STATE(975),
    [sym_jsx_self_closing_element] = STATE(577),
    [sym_class] = STATE(575),
    [sym_function] = STATE(575),
    [sym_generator_function] = STATE(575),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(577),
    [sym_await_expression] = STATE(577),
    [sym_member_expression] = STATE(493),
    [sym_subscript_expression] = STATE(493),
    [sym_assignment_expression] = STATE(577),
    [sym__augmented_assignment_lhs] = STATE(933),
    [sym_augmented_assignment_expression] = STATE(577),
    [sym__destructuring_pattern] = STATE(1580),
    [sym_ternary_expression] = STATE(577),
    [sym_binary_expression] = STATE(577),
    [sym_unary_expression] = STATE(577),
    [sym_update_expression] = STATE(577),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1555),
    [aux_sym_export_statement_repeat1] = STATE(1182),
    [sym_identifier] = ACTIONS(415),
    [anon_sym_export] = ACTIONS(417),
    [anon_sym_STAR] = ACTIONS(419),
    [anon_sym_LBRACE] = ACTIONS(421),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(423),
    [anon_sym_in] = ACTIONS(337),
    [anon_sym_of] = ACTIONS(337),
    [anon_sym_yield] = ACTIONS(425),
    [anon_sym_LBRACK] = ACTIONS(427),
    [anon_sym_LT] = ACTIONS(343),
    [anon_sym_GT] = ACTIONS(337),
    [anon_sym_SLASH] = ACTIONS(429),
    [anon_sym_DOT] = ACTIONS(337),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(431),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_QMARK_DOT] = ACTIONS(329),
    [anon_sym_new] = ACTIONS(433),
    [anon_sym_AMP_AMP] = ACTIONS(329),
    [anon_sym_PIPE_PIPE] = ACTIONS(329),
    [anon_sym_GT_GT] = ACTIONS(337),
    [anon_sym_GT_GT_GT] = ACTIONS(329),
    [anon_sym_LT_LT] = ACTIONS(329),
    [anon_sym_AMP] = ACTIONS(337),
    [anon_sym_CARET] = ACTIONS(329),
    [anon_sym_PIPE] = ACTIONS(337),
    [anon_sym_PLUS] = ACTIONS(435),
    [anon_sym_DASH] = ACTIONS(435),
    [anon_sym_PERCENT] = ACTIONS(329),
    [anon_sym_STAR_STAR] = ACTIONS(329),
    [anon_sym_LT_EQ] = ACTIONS(329),
    [anon_sym_EQ_EQ] = ACTIONS(337),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(329),
    [anon_sym_BANG_EQ] = ACTIONS(337),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(329),
    [anon_sym_GT_EQ] = ACTIONS(329),
    [anon_sym_QMARK_QMARK] = ACTIONS(329),
    [anon_sym_instanceof] = ACTIONS(337),
    [anon_sym_BANG] = ACTIONS(435),
    [anon_sym_TILDE] = ACTIONS(437),
    [anon_sym_typeof] = ACTIONS(435),
    [anon_sym_void] = ACTIONS(435),
    [anon_sym_delete] = ACTIONS(435),
    [anon_sym_PLUS_PLUS] = ACTIONS(439),
    [anon_sym_DASH_DASH] = ACTIONS(439),
    [anon_sym_DQUOTE] = ACTIONS(361),
    [anon_sym_SQUOTE] = ACTIONS(363),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(365),
    [sym_number] = ACTIONS(367),
    [sym_this] = ACTIONS(369),
    [sym_super] = ACTIONS(369),
    [sym_true] = ACTIONS(369),
    [sym_false] = ACTIONS(369),
    [sym_null] = ACTIONS(369),
    [sym_undefined] = ACTIONS(441),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(417),
    [anon_sym_get] = ACTIONS(417),
    [anon_sym_set] = ACTIONS(417),
    [sym__ternary_qmark] = ACTIONS(329),
  },
  [46] = {
    [sym_import] = STATE(575),
    [sym_parenthesized_expression] = STATE(430),
    [sym_expression] = STATE(792),
    [sym_primary_expression] = STATE(576),
    [sym_yield_expression] = STATE(577),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1497),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1497),
    [sym_jsx_element] = STATE(577),
    [sym_jsx_fragment] = STATE(577),
    [sym_jsx_opening_element] = STATE(975),
    [sym_jsx_self_closing_element] = STATE(577),
    [sym_class] = STATE(575),
    [sym_function] = STATE(575),
    [sym_generator_function] = STATE(575),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(577),
    [sym_await_expression] = STATE(577),
    [sym_member_expression] = STATE(430),
    [sym_subscript_expression] = STATE(430),
    [sym_assignment_expression] = STATE(577),
    [sym__augmented_assignment_lhs] = STATE(937),
    [sym_augmented_assignment_expression] = STATE(577),
    [sym__destructuring_pattern] = STATE(1497),
    [sym_ternary_expression] = STATE(577),
    [sym_binary_expression] = STATE(577),
    [sym_unary_expression] = STATE(577),
    [sym_update_expression] = STATE(577),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1533),
    [aux_sym_export_statement_repeat1] = STATE(1182),
    [sym_identifier] = ACTIONS(443),
    [anon_sym_export] = ACTIONS(445),
    [anon_sym_STAR] = ACTIONS(447),
    [anon_sym_LBRACE] = ACTIONS(421),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(449),
    [anon_sym_in] = ACTIONS(337),
    [anon_sym_COLON] = ACTIONS(329),
    [anon_sym_yield] = ACTIONS(451),
    [anon_sym_LBRACK] = ACTIONS(427),
    [anon_sym_LT] = ACTIONS(343),
    [anon_sym_GT] = ACTIONS(337),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_DOT] = ACTIONS(337),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(453),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_QMARK_DOT] = ACTIONS(329),
    [anon_sym_new] = ACTIONS(455),
    [anon_sym_AMP_AMP] = ACTIONS(329),
    [anon_sym_PIPE_PIPE] = ACTIONS(329),
    [anon_sym_GT_GT] = ACTIONS(337),
    [anon_sym_GT_GT_GT] = ACTIONS(329),
    [anon_sym_LT_LT] = ACTIONS(329),
    [anon_sym_AMP] = ACTIONS(337),
    [anon_sym_CARET] = ACTIONS(329),
    [anon_sym_PIPE] = ACTIONS(337),
    [anon_sym_PLUS] = ACTIONS(457),
    [anon_sym_DASH] = ACTIONS(457),
    [anon_sym_PERCENT] = ACTIONS(329),
    [anon_sym_STAR_STAR] = ACTIONS(329),
    [anon_sym_LT_EQ] = ACTIONS(329),
    [anon_sym_EQ_EQ] = ACTIONS(337),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(329),
    [anon_sym_BANG_EQ] = ACTIONS(337),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(329),
    [anon_sym_GT_EQ] = ACTIONS(329),
    [anon_sym_QMARK_QMARK] = ACTIONS(329),
    [anon_sym_instanceof] = ACTIONS(337),
    [anon_sym_BANG] = ACTIONS(457),
    [anon_sym_TILDE] = ACTIONS(459),
    [anon_sym_typeof] = ACTIONS(457),
    [anon_sym_void] = ACTIONS(457),
    [anon_sym_delete] = ACTIONS(457),
    [anon_sym_PLUS_PLUS] = ACTIONS(461),
    [anon_sym_DASH_DASH] = ACTIONS(461),
    [anon_sym_DQUOTE] = ACTIONS(361),
    [anon_sym_SQUOTE] = ACTIONS(363),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(365),
    [sym_number] = ACTIONS(367),
    [sym_this] = ACTIONS(369),
    [sym_super] = ACTIONS(369),
    [sym_true] = ACTIONS(369),
    [sym_false] = ACTIONS(369),
    [sym_null] = ACTIONS(369),
    [sym_undefined] = ACTIONS(463),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(445),
    [anon_sym_get] = ACTIONS(445),
    [anon_sym_set] = ACTIONS(445),
    [sym__ternary_qmark] = ACTIONS(329),
  },
  [47] = {
    [ts_builtin_sym_end] = ACTIONS(465),
    [sym_identifier] = ACTIONS(467),
    [anon_sym_export] = ACTIONS(467),
    [anon_sym_STAR] = ACTIONS(469),
    [anon_sym_default] = ACTIONS(467),
    [anon_sym_LBRACE] = ACTIONS(465),
    [anon_sym_COMMA] = ACTIONS(471),
    [anon_sym_RBRACE] = ACTIONS(465),
    [anon_sym_import] = ACTIONS(467),
    [anon_sym_var] = ACTIONS(467),
    [anon_sym_let] = ACTIONS(467),
    [anon_sym_const] = ACTIONS(467),
    [anon_sym_else] = ACTIONS(467),
    [anon_sym_if] = ACTIONS(467),
    [anon_sym_switch] = ACTIONS(467),
    [anon_sym_for] = ACTIONS(467),
    [anon_sym_LPAREN] = ACTIONS(465),
    [anon_sym_await] = ACTIONS(467),
    [anon_sym_in] = ACTIONS(469),
    [anon_sym_while] = ACTIONS(467),
    [anon_sym_do] = ACTIONS(467),
    [anon_sym_try] = ACTIONS(467),
    [anon_sym_with] = ACTIONS(467),
    [anon_sym_break] = ACTIONS(467),
    [anon_sym_continue] = ACTIONS(467),
    [anon_sym_debugger] = ACTIONS(467),
    [anon_sym_return] = ACTIONS(467),
    [anon_sym_throw] = ACTIONS(467),
    [anon_sym_SEMI] = ACTIONS(465),
    [anon_sym_case] = ACTIONS(467),
    [anon_sym_yield] = ACTIONS(467),
    [anon_sym_EQ] = ACTIONS(473),
    [anon_sym_LBRACK] = ACTIONS(465),
    [anon_sym_LT] = ACTIONS(467),
    [anon_sym_GT] = ACTIONS(469),
    [anon_sym_SLASH] = ACTIONS(467),
    [anon_sym_DOT] = ACTIONS(469),
    [anon_sym_class] = ACTIONS(467),
    [anon_sym_async] = ACTIONS(467),
    [anon_sym_function] = ACTIONS(467),
    [anon_sym_QMARK_DOT] = ACTIONS(471),
    [anon_sym_new] = ACTIONS(467),
    [anon_sym_AMP_AMP] = ACTIONS(471),
    [anon_sym_PIPE_PIPE] = ACTIONS(471),
    [anon_sym_GT_GT] = ACTIONS(469),
    [anon_sym_GT_GT_GT] = ACTIONS(471),
    [anon_sym_LT_LT] = ACTIONS(471),
    [anon_sym_AMP] = ACTIONS(469),
    [anon_sym_CARET] = ACTIONS(471),
    [anon_sym_PIPE] = ACTIONS(469),
    [anon_sym_PLUS] = ACTIONS(467),
    [anon_sym_DASH] = ACTIONS(467),
    [anon_sym_PERCENT] = ACTIONS(471),
    [anon_sym_STAR_STAR] = ACTIONS(471),
    [anon_sym_LT_EQ] = ACTIONS(471),
    [anon_sym_EQ_EQ] = ACTIONS(469),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(471),
    [anon_sym_BANG_EQ] = ACTIONS(469),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(471),
    [anon_sym_GT_EQ] = ACTIONS(471),
    [anon_sym_QMARK_QMARK] = ACTIONS(471),
    [anon_sym_instanceof] = ACTIONS(469),
    [anon_sym_BANG] = ACTIONS(467),
    [anon_sym_TILDE] = ACTIONS(465),
    [anon_sym_typeof] = ACTIONS(467),
    [anon_sym_void] = ACTIONS(467),
    [anon_sym_delete] = ACTIONS(467),
    [anon_sym_PLUS_PLUS] = ACTIONS(465),
    [anon_sym_DASH_DASH] = ACTIONS(465),
    [anon_sym_DQUOTE] = ACTIONS(465),
    [anon_sym_SQUOTE] = ACTIONS(465),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(465),
    [sym_number] = ACTIONS(465),
    [sym_this] = ACTIONS(467),
    [sym_super] = ACTIONS(467),
    [sym_true] = ACTIONS(467),
    [sym_false] = ACTIONS(467),
    [sym_null] = ACTIONS(467),
    [sym_undefined] = ACTIONS(467),
    [anon_sym_AT] = ACTIONS(465),
    [anon_sym_static] = ACTIONS(467),
    [anon_sym_get] = ACTIONS(467),
    [anon_sym_set] = ACTIONS(467),
    [sym__automatic_semicolon] = ACTIONS(475),
    [sym__ternary_qmark] = ACTIONS(471),
  },
  [48] = {
    [ts_builtin_sym_end] = ACTIONS(465),
    [sym_identifier] = ACTIONS(467),
    [anon_sym_export] = ACTIONS(467),
    [anon_sym_STAR] = ACTIONS(467),
    [anon_sym_default] = ACTIONS(467),
    [anon_sym_LBRACE] = ACTIONS(465),
    [anon_sym_COMMA] = ACTIONS(465),
    [anon_sym_RBRACE] = ACTIONS(465),
    [anon_sym_import] = ACTIONS(467),
    [anon_sym_var] = ACTIONS(467),
    [anon_sym_let] = ACTIONS(467),
    [anon_sym_const] = ACTIONS(467),
    [anon_sym_else] = ACTIONS(467),
    [anon_sym_if] = ACTIONS(467),
    [anon_sym_switch] = ACTIONS(467),
    [anon_sym_for] = ACTIONS(467),
    [anon_sym_LPAREN] = ACTIONS(465),
    [anon_sym_await] = ACTIONS(467),
    [anon_sym_in] = ACTIONS(467),
    [anon_sym_of] = ACTIONS(467),
    [anon_sym_while] = ACTIONS(467),
    [anon_sym_do] = ACTIONS(467),
    [anon_sym_try] = ACTIONS(467),
    [anon_sym_with] = ACTIONS(467),
    [anon_sym_break] = ACTIONS(467),
    [anon_sym_continue] = ACTIONS(467),
    [anon_sym_debugger] = ACTIONS(467),
    [anon_sym_return] = ACTIONS(467),
    [anon_sym_throw] = ACTIONS(467),
    [anon_sym_SEMI] = ACTIONS(465),
    [anon_sym_case] = ACTIONS(467),
    [anon_sym_yield] = ACTIONS(467),
    [anon_sym_LBRACK] = ACTIONS(465),
    [anon_sym_LT] = ACTIONS(467),
    [anon_sym_GT] = ACTIONS(467),
    [anon_sym_SLASH] = ACTIONS(467),
    [anon_sym_DOT] = ACTIONS(467),
    [anon_sym_class] = ACTIONS(467),
    [anon_sym_async] = ACTIONS(467),
    [anon_sym_function] = ACTIONS(467),
    [anon_sym_QMARK_DOT] = ACTIONS(465),
    [anon_sym_new] = ACTIONS(467),
    [anon_sym_AMP_AMP] = ACTIONS(465),
    [anon_sym_PIPE_PIPE] = ACTIONS(465),
    [anon_sym_GT_GT] = ACTIONS(467),
    [anon_sym_GT_GT_GT] = ACTIONS(465),
    [anon_sym_LT_LT] = ACTIONS(465),
    [anon_sym_AMP] = ACTIONS(467),
    [anon_sym_CARET] = ACTIONS(465),
    [anon_sym_PIPE] = ACTIONS(467),
    [anon_sym_PLUS] = ACTIONS(467),
    [anon_sym_DASH] = ACTIONS(467),
    [anon_sym_PERCENT] = ACTIONS(465),
    [anon_sym_STAR_STAR] = ACTIONS(465),
    [anon_sym_LT_EQ] = ACTIONS(465),
    [anon_sym_EQ_EQ] = ACTIONS(467),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(465),
    [anon_sym_BANG_EQ] = ACTIONS(467),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(465),
    [anon_sym_GT_EQ] = ACTIONS(465),
    [anon_sym_QMARK_QMARK] = ACTIONS(465),
    [anon_sym_instanceof] = ACTIONS(467),
    [anon_sym_BANG] = ACTIONS(467),
    [anon_sym_TILDE] = ACTIONS(465),
    [anon_sym_typeof] = ACTIONS(467),
    [anon_sym_void] = ACTIONS(467),
    [anon_sym_delete] = ACTIONS(467),
    [anon_sym_PLUS_PLUS] = ACTIONS(465),
    [anon_sym_DASH_DASH] = ACTIONS(465),
    [anon_sym_DQUOTE] = ACTIONS(465),
    [anon_sym_SQUOTE] = ACTIONS(465),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(465),
    [sym_number] = ACTIONS(465),
    [sym_this] = ACTIONS(467),
    [sym_super] = ACTIONS(467),
    [sym_true] = ACTIONS(467),
    [sym_false] = ACTIONS(467),
    [sym_null] = ACTIONS(467),
    [sym_undefined] = ACTIONS(467),
    [anon_sym_AT] = ACTIONS(465),
    [anon_sym_static] = ACTIONS(467),
    [anon_sym_get] = ACTIONS(467),
    [anon_sym_set] = ACTIONS(467),
    [sym__automatic_semicolon] = ACTIONS(477),
    [sym__ternary_qmark] = ACTIONS(465),
  },
  [49] = {
    [ts_builtin_sym_end] = ACTIONS(479),
    [sym_identifier] = ACTIONS(481),
    [anon_sym_export] = ACTIONS(481),
    [anon_sym_STAR] = ACTIONS(481),
    [anon_sym_default] = ACTIONS(481),
    [anon_sym_LBRACE] = ACTIONS(479),
    [anon_sym_COMMA] = ACTIONS(479),
    [anon_sym_RBRACE] = ACTIONS(479),
    [anon_sym_import] = ACTIONS(481),
    [anon_sym_var] = ACTIONS(481),
    [anon_sym_let] = ACTIONS(481),
    [anon_sym_const] = ACTIONS(481),
    [anon_sym_else] = ACTIONS(481),
    [anon_sym_if] = ACTIONS(481),
    [anon_sym_switch] = ACTIONS(481),
    [anon_sym_for] = ACTIONS(481),
    [anon_sym_LPAREN] = ACTIONS(479),
    [anon_sym_await] = ACTIONS(481),
    [anon_sym_in] = ACTIONS(481),
    [anon_sym_of] = ACTIONS(481),
    [anon_sym_while] = ACTIONS(481),
    [anon_sym_do] = ACTIONS(481),
    [anon_sym_try] = ACTIONS(481),
    [anon_sym_with] = ACTIONS(481),
    [anon_sym_break] = ACTIONS(481),
    [anon_sym_continue] = ACTIONS(481),
    [anon_sym_debugger] = ACTIONS(481),
    [anon_sym_return] = ACTIONS(481),
    [anon_sym_throw] = ACTIONS(481),
    [anon_sym_SEMI] = ACTIONS(479),
    [anon_sym_case] = ACTIONS(481),
    [anon_sym_yield] = ACTIONS(481),
    [anon_sym_LBRACK] = ACTIONS(479),
    [anon_sym_LT] = ACTIONS(481),
    [anon_sym_GT] = ACTIONS(481),
    [anon_sym_SLASH] = ACTIONS(481),
    [anon_sym_DOT] = ACTIONS(481),
    [anon_sym_class] = ACTIONS(481),
    [anon_sym_async] = ACTIONS(481),
    [anon_sym_function] = ACTIONS(481),
    [anon_sym_QMARK_DOT] = ACTIONS(479),
    [anon_sym_new] = ACTIONS(481),
    [anon_sym_AMP_AMP] = ACTIONS(479),
    [anon_sym_PIPE_PIPE] = ACTIONS(479),
    [anon_sym_GT_GT] = ACTIONS(481),
    [anon_sym_GT_GT_GT] = ACTIONS(479),
    [anon_sym_LT_LT] = ACTIONS(479),
    [anon_sym_AMP] = ACTIONS(481),
    [anon_sym_CARET] = ACTIONS(479),
    [anon_sym_PIPE] = ACTIONS(481),
    [anon_sym_PLUS] = ACTIONS(481),
    [anon_sym_DASH] = ACTIONS(481),
    [anon_sym_PERCENT] = ACTIONS(479),
    [anon_sym_STAR_STAR] = ACTIONS(479),
    [anon_sym_LT_EQ] = ACTIONS(479),
    [anon_sym_EQ_EQ] = ACTIONS(481),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(479),
    [anon_sym_BANG_EQ] = ACTIONS(481),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(479),
    [anon_sym_GT_EQ] = ACTIONS(479),
    [anon_sym_QMARK_QMARK] = ACTIONS(479),
    [anon_sym_instanceof] = ACTIONS(481),
    [anon_sym_BANG] = ACTIONS(481),
    [anon_sym_TILDE] = ACTIONS(479),
    [anon_sym_typeof] = ACTIONS(481),
    [anon_sym_void] = ACTIONS(481),
    [anon_sym_delete] = ACTIONS(481),
    [anon_sym_PLUS_PLUS] = ACTIONS(479),
    [anon_sym_DASH_DASH] = ACTIONS(479),
    [anon_sym_DQUOTE] = ACTIONS(479),
    [anon_sym_SQUOTE] = ACTIONS(479),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(479),
    [sym_number] = ACTIONS(479),
    [sym_this] = ACTIONS(481),
    [sym_super] = ACTIONS(481),
    [sym_true] = ACTIONS(481),
    [sym_false] = ACTIONS(481),
    [sym_null] = ACTIONS(481),
    [sym_undefined] = ACTIONS(481),
    [anon_sym_AT] = ACTIONS(479),
    [anon_sym_static] = ACTIONS(481),
    [anon_sym_get] = ACTIONS(481),
    [anon_sym_set] = ACTIONS(481),
    [sym__automatic_semicolon] = ACTIONS(483),
    [sym__ternary_qmark] = ACTIONS(479),
  },
  [50] = {
    [ts_builtin_sym_end] = ACTIONS(485),
    [sym_identifier] = ACTIONS(487),
    [anon_sym_export] = ACTIONS(487),
    [anon_sym_STAR] = ACTIONS(487),
    [anon_sym_default] = ACTIONS(487),
    [anon_sym_LBRACE] = ACTIONS(485),
    [anon_sym_COMMA] = ACTIONS(485),
    [anon_sym_RBRACE] = ACTIONS(485),
    [anon_sym_import] = ACTIONS(487),
    [anon_sym_var] = ACTIONS(487),
    [anon_sym_let] = ACTIONS(487),
    [anon_sym_const] = ACTIONS(487),
    [anon_sym_else] = ACTIONS(487),
    [anon_sym_if] = ACTIONS(487),
    [anon_sym_switch] = ACTIONS(487),
    [anon_sym_for] = ACTIONS(487),
    [anon_sym_LPAREN] = ACTIONS(485),
    [anon_sym_await] = ACTIONS(487),
    [anon_sym_in] = ACTIONS(487),
    [anon_sym_of] = ACTIONS(487),
    [anon_sym_while] = ACTIONS(487),
    [anon_sym_do] = ACTIONS(487),
    [anon_sym_try] = ACTIONS(487),
    [anon_sym_with] = ACTIONS(487),
    [anon_sym_break] = ACTIONS(487),
    [anon_sym_continue] = ACTIONS(487),
    [anon_sym_debugger] = ACTIONS(487),
    [anon_sym_return] = ACTIONS(487),
    [anon_sym_throw] = ACTIONS(487),
    [anon_sym_SEMI] = ACTIONS(485),
    [anon_sym_case] = ACTIONS(487),
    [anon_sym_yield] = ACTIONS(487),
    [anon_sym_LBRACK] = ACTIONS(485),
    [anon_sym_LT] = ACTIONS(487),
    [anon_sym_GT] = ACTIONS(487),
    [anon_sym_SLASH] = ACTIONS(487),
    [anon_sym_DOT] = ACTIONS(487),
    [anon_sym_class] = ACTIONS(487),
    [anon_sym_async] = ACTIONS(487),
    [anon_sym_function] = ACTIONS(487),
    [anon_sym_QMARK_DOT] = ACTIONS(485),
    [anon_sym_new] = ACTIONS(487),
    [anon_sym_AMP_AMP] = ACTIONS(485),
    [anon_sym_PIPE_PIPE] = ACTIONS(485),
    [anon_sym_GT_GT] = ACTIONS(487),
    [anon_sym_GT_GT_GT] = ACTIONS(485),
    [anon_sym_LT_LT] = ACTIONS(485),
    [anon_sym_AMP] = ACTIONS(487),
    [anon_sym_CARET] = ACTIONS(485),
    [anon_sym_PIPE] = ACTIONS(487),
    [anon_sym_PLUS] = ACTIONS(487),
    [anon_sym_DASH] = ACTIONS(487),
    [anon_sym_PERCENT] = ACTIONS(485),
    [anon_sym_STAR_STAR] = ACTIONS(485),
    [anon_sym_LT_EQ] = ACTIONS(485),
    [anon_sym_EQ_EQ] = ACTIONS(487),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(485),
    [anon_sym_BANG_EQ] = ACTIONS(487),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(485),
    [anon_sym_GT_EQ] = ACTIONS(485),
    [anon_sym_QMARK_QMARK] = ACTIONS(485),
    [anon_sym_instanceof] = ACTIONS(487),
    [anon_sym_BANG] = ACTIONS(487),
    [anon_sym_TILDE] = ACTIONS(485),
    [anon_sym_typeof] = ACTIONS(487),
    [anon_sym_void] = ACTIONS(487),
    [anon_sym_delete] = ACTIONS(487),
    [anon_sym_PLUS_PLUS] = ACTIONS(485),
    [anon_sym_DASH_DASH] = ACTIONS(485),
    [anon_sym_DQUOTE] = ACTIONS(485),
    [anon_sym_SQUOTE] = ACTIONS(485),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(485),
    [sym_number] = ACTIONS(485),
    [sym_this] = ACTIONS(487),
    [sym_super] = ACTIONS(487),
    [sym_true] = ACTIONS(487),
    [sym_false] = ACTIONS(487),
    [sym_null] = ACTIONS(487),
    [sym_undefined] = ACTIONS(487),
    [anon_sym_AT] = ACTIONS(485),
    [anon_sym_static] = ACTIONS(487),
    [anon_sym_get] = ACTIONS(487),
    [anon_sym_set] = ACTIONS(487),
    [sym__automatic_semicolon] = ACTIONS(485),
    [sym__ternary_qmark] = ACTIONS(485),
  },
  [51] = {
    [ts_builtin_sym_end] = ACTIONS(489),
    [sym_identifier] = ACTIONS(491),
    [anon_sym_export] = ACTIONS(491),
    [anon_sym_STAR] = ACTIONS(491),
    [anon_sym_default] = ACTIONS(491),
    [anon_sym_LBRACE] = ACTIONS(489),
    [anon_sym_COMMA] = ACTIONS(489),
    [anon_sym_RBRACE] = ACTIONS(489),
    [anon_sym_import] = ACTIONS(491),
    [anon_sym_var] = ACTIONS(491),
    [anon_sym_let] = ACTIONS(491),
    [anon_sym_const] = ACTIONS(491),
    [anon_sym_else] = ACTIONS(491),
    [anon_sym_if] = ACTIONS(491),
    [anon_sym_switch] = ACTIONS(491),
    [anon_sym_for] = ACTIONS(491),
    [anon_sym_LPAREN] = ACTIONS(489),
    [anon_sym_await] = ACTIONS(491),
    [anon_sym_in] = ACTIONS(491),
    [anon_sym_of] = ACTIONS(491),
    [anon_sym_while] = ACTIONS(491),
    [anon_sym_do] = ACTIONS(491),
    [anon_sym_try] = ACTIONS(491),
    [anon_sym_with] = ACTIONS(491),
    [anon_sym_break] = ACTIONS(491),
    [anon_sym_continue] = ACTIONS(491),
    [anon_sym_debugger] = ACTIONS(491),
    [anon_sym_return] = ACTIONS(491),
    [anon_sym_throw] = ACTIONS(491),
    [anon_sym_SEMI] = ACTIONS(489),
    [anon_sym_case] = ACTIONS(491),
    [anon_sym_yield] = ACTIONS(491),
    [anon_sym_LBRACK] = ACTIONS(489),
    [anon_sym_LT] = ACTIONS(491),
    [anon_sym_GT] = ACTIONS(491),
    [anon_sym_SLASH] = ACTIONS(491),
    [anon_sym_DOT] = ACTIONS(491),
    [anon_sym_class] = ACTIONS(491),
    [anon_sym_async] = ACTIONS(491),
    [anon_sym_function] = ACTIONS(491),
    [anon_sym_QMARK_DOT] = ACTIONS(489),
    [anon_sym_new] = ACTIONS(491),
    [anon_sym_AMP_AMP] = ACTIONS(489),
    [anon_sym_PIPE_PIPE] = ACTIONS(489),
    [anon_sym_GT_GT] = ACTIONS(491),
    [anon_sym_GT_GT_GT] = ACTIONS(489),
    [anon_sym_LT_LT] = ACTIONS(489),
    [anon_sym_AMP] = ACTIONS(491),
    [anon_sym_CARET] = ACTIONS(489),
    [anon_sym_PIPE] = ACTIONS(491),
    [anon_sym_PLUS] = ACTIONS(491),
    [anon_sym_DASH] = ACTIONS(491),
    [anon_sym_PERCENT] = ACTIONS(489),
    [anon_sym_STAR_STAR] = ACTIONS(489),
    [anon_sym_LT_EQ] = ACTIONS(489),
    [anon_sym_EQ_EQ] = ACTIONS(491),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(489),
    [anon_sym_BANG_EQ] = ACTIONS(491),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(489),
    [anon_sym_GT_EQ] = ACTIONS(489),
    [anon_sym_QMARK_QMARK] = ACTIONS(489),
    [anon_sym_instanceof] = ACTIONS(491),
    [anon_sym_BANG] = ACTIONS(491),
    [anon_sym_TILDE] = ACTIONS(489),
    [anon_sym_typeof] = ACTIONS(491),
    [anon_sym_void] = ACTIONS(491),
    [anon_sym_delete] = ACTIONS(491),
    [anon_sym_PLUS_PLUS] = ACTIONS(489),
    [anon_sym_DASH_DASH] = ACTIONS(489),
    [anon_sym_DQUOTE] = ACTIONS(489),
    [anon_sym_SQUOTE] = ACTIONS(489),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(489),
    [sym_number] = ACTIONS(489),
    [sym_this] = ACTIONS(491),
    [sym_super] = ACTIONS(491),
    [sym_true] = ACTIONS(491),
    [sym_false] = ACTIONS(491),
    [sym_null] = ACTIONS(491),
    [sym_undefined] = ACTIONS(491),
    [anon_sym_AT] = ACTIONS(489),
    [anon_sym_static] = ACTIONS(491),
    [anon_sym_get] = ACTIONS(491),
    [anon_sym_set] = ACTIONS(491),
    [sym__automatic_semicolon] = ACTIONS(489),
    [sym__ternary_qmark] = ACTIONS(489),
  },
  [52] = {
    [ts_builtin_sym_end] = ACTIONS(493),
    [sym_identifier] = ACTIONS(495),
    [anon_sym_export] = ACTIONS(495),
    [anon_sym_STAR] = ACTIONS(495),
    [anon_sym_default] = ACTIONS(495),
    [anon_sym_LBRACE] = ACTIONS(493),
    [anon_sym_COMMA] = ACTIONS(493),
    [anon_sym_RBRACE] = ACTIONS(493),
    [anon_sym_import] = ACTIONS(495),
    [anon_sym_var] = ACTIONS(495),
    [anon_sym_let] = ACTIONS(495),
    [anon_sym_const] = ACTIONS(495),
    [anon_sym_else] = ACTIONS(495),
    [anon_sym_if] = ACTIONS(495),
    [anon_sym_switch] = ACTIONS(495),
    [anon_sym_for] = ACTIONS(495),
    [anon_sym_LPAREN] = ACTIONS(493),
    [anon_sym_await] = ACTIONS(495),
    [anon_sym_in] = ACTIONS(495),
    [anon_sym_of] = ACTIONS(495),
    [anon_sym_while] = ACTIONS(495),
    [anon_sym_do] = ACTIONS(495),
    [anon_sym_try] = ACTIONS(495),
    [anon_sym_with] = ACTIONS(495),
    [anon_sym_break] = ACTIONS(495),
    [anon_sym_continue] = ACTIONS(495),
    [anon_sym_debugger] = ACTIONS(495),
    [anon_sym_return] = ACTIONS(495),
    [anon_sym_throw] = ACTIONS(495),
    [anon_sym_SEMI] = ACTIONS(493),
    [anon_sym_case] = ACTIONS(495),
    [anon_sym_yield] = ACTIONS(495),
    [anon_sym_LBRACK] = ACTIONS(493),
    [anon_sym_LT] = ACTIONS(495),
    [anon_sym_GT] = ACTIONS(495),
    [anon_sym_SLASH] = ACTIONS(495),
    [anon_sym_DOT] = ACTIONS(495),
    [anon_sym_class] = ACTIONS(495),
    [anon_sym_async] = ACTIONS(495),
    [anon_sym_function] = ACTIONS(495),
    [anon_sym_QMARK_DOT] = ACTIONS(493),
    [anon_sym_new] = ACTIONS(495),
    [anon_sym_AMP_AMP] = ACTIONS(493),
    [anon_sym_PIPE_PIPE] = ACTIONS(493),
    [anon_sym_GT_GT] = ACTIONS(495),
    [anon_sym_GT_GT_GT] = ACTIONS(493),
    [anon_sym_LT_LT] = ACTIONS(493),
    [anon_sym_AMP] = ACTIONS(495),
    [anon_sym_CARET] = ACTIONS(493),
    [anon_sym_PIPE] = ACTIONS(495),
    [anon_sym_PLUS] = ACTIONS(495),
    [anon_sym_DASH] = ACTIONS(495),
    [anon_sym_PERCENT] = ACTIONS(493),
    [anon_sym_STAR_STAR] = ACTIONS(493),
    [anon_sym_LT_EQ] = ACTIONS(493),
    [anon_sym_EQ_EQ] = ACTIONS(495),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(493),
    [anon_sym_BANG_EQ] = ACTIONS(495),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(493),
    [anon_sym_GT_EQ] = ACTIONS(493),
    [anon_sym_QMARK_QMARK] = ACTIONS(493),
    [anon_sym_instanceof] = ACTIONS(495),
    [anon_sym_BANG] = ACTIONS(495),
    [anon_sym_TILDE] = ACTIONS(493),
    [anon_sym_typeof] = ACTIONS(495),
    [anon_sym_void] = ACTIONS(495),
    [anon_sym_delete] = ACTIONS(495),
    [anon_sym_PLUS_PLUS] = ACTIONS(493),
    [anon_sym_DASH_DASH] = ACTIONS(493),
    [anon_sym_DQUOTE] = ACTIONS(493),
    [anon_sym_SQUOTE] = ACTIONS(493),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(493),
    [sym_number] = ACTIONS(493),
    [sym_this] = ACTIONS(495),
    [sym_super] = ACTIONS(495),
    [sym_true] = ACTIONS(495),
    [sym_false] = ACTIONS(495),
    [sym_null] = ACTIONS(495),
    [sym_undefined] = ACTIONS(495),
    [anon_sym_AT] = ACTIONS(493),
    [anon_sym_static] = ACTIONS(495),
    [anon_sym_get] = ACTIONS(495),
    [anon_sym_set] = ACTIONS(495),
    [sym__automatic_semicolon] = ACTIONS(493),
    [sym__ternary_qmark] = ACTIONS(493),
  },
  [53] = {
    [ts_builtin_sym_end] = ACTIONS(479),
    [sym_identifier] = ACTIONS(481),
    [anon_sym_export] = ACTIONS(481),
    [anon_sym_STAR] = ACTIONS(481),
    [anon_sym_default] = ACTIONS(481),
    [anon_sym_LBRACE] = ACTIONS(479),
    [anon_sym_COMMA] = ACTIONS(479),
    [anon_sym_RBRACE] = ACTIONS(479),
    [anon_sym_import] = ACTIONS(481),
    [anon_sym_var] = ACTIONS(481),
    [anon_sym_let] = ACTIONS(481),
    [anon_sym_const] = ACTIONS(481),
    [anon_sym_else] = ACTIONS(481),
    [anon_sym_if] = ACTIONS(481),
    [anon_sym_switch] = ACTIONS(481),
    [anon_sym_for] = ACTIONS(481),
    [anon_sym_LPAREN] = ACTIONS(479),
    [anon_sym_await] = ACTIONS(481),
    [anon_sym_in] = ACTIONS(481),
    [anon_sym_of] = ACTIONS(481),
    [anon_sym_while] = ACTIONS(481),
    [anon_sym_do] = ACTIONS(481),
    [anon_sym_try] = ACTIONS(481),
    [anon_sym_with] = ACTIONS(481),
    [anon_sym_break] = ACTIONS(481),
    [anon_sym_continue] = ACTIONS(481),
    [anon_sym_debugger] = ACTIONS(481),
    [anon_sym_return] = ACTIONS(481),
    [anon_sym_throw] = ACTIONS(481),
    [anon_sym_SEMI] = ACTIONS(479),
    [anon_sym_case] = ACTIONS(481),
    [anon_sym_yield] = ACTIONS(481),
    [anon_sym_LBRACK] = ACTIONS(479),
    [anon_sym_LT] = ACTIONS(481),
    [anon_sym_GT] = ACTIONS(481),
    [anon_sym_SLASH] = ACTIONS(481),
    [anon_sym_DOT] = ACTIONS(481),
    [anon_sym_class] = ACTIONS(481),
    [anon_sym_async] = ACTIONS(481),
    [anon_sym_function] = ACTIONS(481),
    [anon_sym_QMARK_DOT] = ACTIONS(479),
    [anon_sym_new] = ACTIONS(481),
    [anon_sym_AMP_AMP] = ACTIONS(479),
    [anon_sym_PIPE_PIPE] = ACTIONS(479),
    [anon_sym_GT_GT] = ACTIONS(481),
    [anon_sym_GT_GT_GT] = ACTIONS(479),
    [anon_sym_LT_LT] = ACTIONS(479),
    [anon_sym_AMP] = ACTIONS(481),
    [anon_sym_CARET] = ACTIONS(479),
    [anon_sym_PIPE] = ACTIONS(481),
    [anon_sym_PLUS] = ACTIONS(481),
    [anon_sym_DASH] = ACTIONS(481),
    [anon_sym_PERCENT] = ACTIONS(479),
    [anon_sym_STAR_STAR] = ACTIONS(479),
    [anon_sym_LT_EQ] = ACTIONS(479),
    [anon_sym_EQ_EQ] = ACTIONS(481),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(479),
    [anon_sym_BANG_EQ] = ACTIONS(481),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(479),
    [anon_sym_GT_EQ] = ACTIONS(479),
    [anon_sym_QMARK_QMARK] = ACTIONS(479),
    [anon_sym_instanceof] = ACTIONS(481),
    [anon_sym_BANG] = ACTIONS(481),
    [anon_sym_TILDE] = ACTIONS(479),
    [anon_sym_typeof] = ACTIONS(481),
    [anon_sym_void] = ACTIONS(481),
    [anon_sym_delete] = ACTIONS(481),
    [anon_sym_PLUS_PLUS] = ACTIONS(479),
    [anon_sym_DASH_DASH] = ACTIONS(479),
    [anon_sym_DQUOTE] = ACTIONS(479),
    [anon_sym_SQUOTE] = ACTIONS(479),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(479),
    [sym_number] = ACTIONS(479),
    [sym_this] = ACTIONS(481),
    [sym_super] = ACTIONS(481),
    [sym_true] = ACTIONS(481),
    [sym_false] = ACTIONS(481),
    [sym_null] = ACTIONS(481),
    [sym_undefined] = ACTIONS(481),
    [anon_sym_AT] = ACTIONS(479),
    [anon_sym_static] = ACTIONS(481),
    [anon_sym_get] = ACTIONS(481),
    [anon_sym_set] = ACTIONS(481),
    [sym__automatic_semicolon] = ACTIONS(479),
    [sym__ternary_qmark] = ACTIONS(479),
  },
  [54] = {
    [ts_builtin_sym_end] = ACTIONS(497),
    [sym_identifier] = ACTIONS(499),
    [anon_sym_export] = ACTIONS(499),
    [anon_sym_STAR] = ACTIONS(501),
    [anon_sym_default] = ACTIONS(499),
    [anon_sym_LBRACE] = ACTIONS(497),
    [anon_sym_COMMA] = ACTIONS(503),
    [anon_sym_RBRACE] = ACTIONS(497),
    [anon_sym_import] = ACTIONS(499),
    [anon_sym_var] = ACTIONS(499),
    [anon_sym_let] = ACTIONS(499),
    [anon_sym_const] = ACTIONS(499),
    [anon_sym_else] = ACTIONS(499),
    [anon_sym_if] = ACTIONS(499),
    [anon_sym_switch] = ACTIONS(499),
    [anon_sym_for] = ACTIONS(499),
    [anon_sym_LPAREN] = ACTIONS(497),
    [anon_sym_await] = ACTIONS(499),
    [anon_sym_in] = ACTIONS(501),
    [anon_sym_while] = ACTIONS(499),
    [anon_sym_do] = ACTIONS(499),
    [anon_sym_try] = ACTIONS(499),
    [anon_sym_with] = ACTIONS(499),
    [anon_sym_break] = ACTIONS(499),
    [anon_sym_continue] = ACTIONS(499),
    [anon_sym_debugger] = ACTIONS(499),
    [anon_sym_return] = ACTIONS(499),
    [anon_sym_throw] = ACTIONS(499),
    [anon_sym_SEMI] = ACTIONS(497),
    [anon_sym_case] = ACTIONS(499),
    [anon_sym_yield] = ACTIONS(499),
    [anon_sym_LBRACK] = ACTIONS(497),
    [anon_sym_LT] = ACTIONS(499),
    [anon_sym_GT] = ACTIONS(501),
    [anon_sym_SLASH] = ACTIONS(499),
    [anon_sym_DOT] = ACTIONS(501),
    [anon_sym_class] = ACTIONS(499),
    [anon_sym_async] = ACTIONS(499),
    [anon_sym_function] = ACTIONS(499),
    [anon_sym_QMARK_DOT] = ACTIONS(503),
    [anon_sym_new] = ACTIONS(499),
    [anon_sym_AMP_AMP] = ACTIONS(503),
    [anon_sym_PIPE_PIPE] = ACTIONS(503),
    [anon_sym_GT_GT] = ACTIONS(501),
    [anon_sym_GT_GT_GT] = ACTIONS(503),
    [anon_sym_LT_LT] = ACTIONS(503),
    [anon_sym_AMP] = ACTIONS(501),
    [anon_sym_CARET] = ACTIONS(503),
    [anon_sym_PIPE] = ACTIONS(501),
    [anon_sym_PLUS] = ACTIONS(499),
    [anon_sym_DASH] = ACTIONS(499),
    [anon_sym_PERCENT] = ACTIONS(503),
    [anon_sym_STAR_STAR] = ACTIONS(503),
    [anon_sym_LT_EQ] = ACTIONS(503),
    [anon_sym_EQ_EQ] = ACTIONS(501),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(503),
    [anon_sym_BANG_EQ] = ACTIONS(501),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(503),
    [anon_sym_GT_EQ] = ACTIONS(503),
    [anon_sym_QMARK_QMARK] = ACTIONS(503),
    [anon_sym_instanceof] = ACTIONS(501),
    [anon_sym_BANG] = ACTIONS(499),
    [anon_sym_TILDE] = ACTIONS(497),
    [anon_sym_typeof] = ACTIONS(499),
    [anon_sym_void] = ACTIONS(499),
    [anon_sym_delete] = ACTIONS(499),
    [anon_sym_PLUS_PLUS] = ACTIONS(497),
    [anon_sym_DASH_DASH] = ACTIONS(497),
    [anon_sym_DQUOTE] = ACTIONS(497),
    [anon_sym_SQUOTE] = ACTIONS(497),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(497),
    [sym_number] = ACTIONS(497),
    [sym_this] = ACTIONS(499),
    [sym_super] = ACTIONS(499),
    [sym_true] = ACTIONS(499),
    [sym_false] = ACTIONS(499),
    [sym_null] = ACTIONS(499),
    [sym_undefined] = ACTIONS(499),
    [anon_sym_AT] = ACTIONS(497),
    [anon_sym_static] = ACTIONS(499),
    [anon_sym_get] = ACTIONS(499),
    [anon_sym_set] = ACTIONS(499),
    [sym__automatic_semicolon] = ACTIONS(505),
    [sym__ternary_qmark] = ACTIONS(503),
  },
  [55] = {
    [ts_builtin_sym_end] = ACTIONS(507),
    [sym_identifier] = ACTIONS(509),
    [anon_sym_export] = ACTIONS(509),
    [anon_sym_STAR] = ACTIONS(511),
    [anon_sym_default] = ACTIONS(509),
    [anon_sym_LBRACE] = ACTIONS(507),
    [anon_sym_COMMA] = ACTIONS(513),
    [anon_sym_RBRACE] = ACTIONS(507),
    [anon_sym_import] = ACTIONS(509),
    [anon_sym_var] = ACTIONS(509),
    [anon_sym_let] = ACTIONS(509),
    [anon_sym_const] = ACTIONS(509),
    [anon_sym_else] = ACTIONS(509),
    [anon_sym_if] = ACTIONS(509),
    [anon_sym_switch] = ACTIONS(509),
    [anon_sym_for] = ACTIONS(509),
    [anon_sym_LPAREN] = ACTIONS(507),
    [anon_sym_await] = ACTIONS(509),
    [anon_sym_in] = ACTIONS(511),
    [anon_sym_while] = ACTIONS(509),
    [anon_sym_do] = ACTIONS(509),
    [anon_sym_try] = ACTIONS(509),
    [anon_sym_with] = ACTIONS(509),
    [anon_sym_break] = ACTIONS(509),
    [anon_sym_continue] = ACTIONS(509),
    [anon_sym_debugger] = ACTIONS(509),
    [anon_sym_return] = ACTIONS(509),
    [anon_sym_throw] = ACTIONS(509),
    [anon_sym_SEMI] = ACTIONS(507),
    [anon_sym_case] = ACTIONS(509),
    [anon_sym_yield] = ACTIONS(509),
    [anon_sym_LBRACK] = ACTIONS(507),
    [anon_sym_LT] = ACTIONS(509),
    [anon_sym_GT] = ACTIONS(511),
    [anon_sym_SLASH] = ACTIONS(509),
    [anon_sym_DOT] = ACTIONS(511),
    [anon_sym_class] = ACTIONS(509),
    [anon_sym_async] = ACTIONS(509),
    [anon_sym_function] = ACTIONS(509),
    [anon_sym_QMARK_DOT] = ACTIONS(513),
    [anon_sym_new] = ACTIONS(509),
    [anon_sym_AMP_AMP] = ACTIONS(513),
    [anon_sym_PIPE_PIPE] = ACTIONS(513),
    [anon_sym_GT_GT] = ACTIONS(511),
    [anon_sym_GT_GT_GT] = ACTIONS(513),
    [anon_sym_LT_LT] = ACTIONS(513),
    [anon_sym_AMP] = ACTIONS(511),
    [anon_sym_CARET] = ACTIONS(513),
    [anon_sym_PIPE] = ACTIONS(511),
    [anon_sym_PLUS] = ACTIONS(509),
    [anon_sym_DASH] = ACTIONS(509),
    [anon_sym_PERCENT] = ACTIONS(513),
    [anon_sym_STAR_STAR] = ACTIONS(513),
    [anon_sym_LT_EQ] = ACTIONS(513),
    [anon_sym_EQ_EQ] = ACTIONS(511),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(513),
    [anon_sym_BANG_EQ] = ACTIONS(511),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(513),
    [anon_sym_GT_EQ] = ACTIONS(513),
    [anon_sym_QMARK_QMARK] = ACTIONS(513),
    [anon_sym_instanceof] = ACTIONS(511),
    [anon_sym_BANG] = ACTIONS(509),
    [anon_sym_TILDE] = ACTIONS(507),
    [anon_sym_typeof] = ACTIONS(509),
    [anon_sym_void] = ACTIONS(509),
    [anon_sym_delete] = ACTIONS(509),
    [anon_sym_PLUS_PLUS] = ACTIONS(507),
    [anon_sym_DASH_DASH] = ACTIONS(507),
    [anon_sym_DQUOTE] = ACTIONS(507),
    [anon_sym_SQUOTE] = ACTIONS(507),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(507),
    [sym_number] = ACTIONS(507),
    [sym_this] = ACTIONS(509),
    [sym_super] = ACTIONS(509),
    [sym_true] = ACTIONS(509),
    [sym_false] = ACTIONS(509),
    [sym_null] = ACTIONS(509),
    [sym_undefined] = ACTIONS(509),
    [anon_sym_AT] = ACTIONS(507),
    [anon_sym_static] = ACTIONS(509),
    [anon_sym_get] = ACTIONS(509),
    [anon_sym_set] = ACTIONS(509),
    [sym__automatic_semicolon] = ACTIONS(515),
    [sym__ternary_qmark] = ACTIONS(513),
  },
  [56] = {
    [ts_builtin_sym_end] = ACTIONS(517),
    [sym_identifier] = ACTIONS(519),
    [anon_sym_export] = ACTIONS(519),
    [anon_sym_STAR] = ACTIONS(521),
    [anon_sym_default] = ACTIONS(519),
    [anon_sym_LBRACE] = ACTIONS(517),
    [anon_sym_COMMA] = ACTIONS(523),
    [anon_sym_RBRACE] = ACTIONS(517),
    [anon_sym_import] = ACTIONS(519),
    [anon_sym_var] = ACTIONS(519),
    [anon_sym_let] = ACTIONS(519),
    [anon_sym_const] = ACTIONS(519),
    [anon_sym_else] = ACTIONS(519),
    [anon_sym_if] = ACTIONS(519),
    [anon_sym_switch] = ACTIONS(519),
    [anon_sym_for] = ACTIONS(519),
    [anon_sym_LPAREN] = ACTIONS(517),
    [anon_sym_await] = ACTIONS(519),
    [anon_sym_in] = ACTIONS(521),
    [anon_sym_while] = ACTIONS(519),
    [anon_sym_do] = ACTIONS(519),
    [anon_sym_try] = ACTIONS(519),
    [anon_sym_with] = ACTIONS(519),
    [anon_sym_break] = ACTIONS(519),
    [anon_sym_continue] = ACTIONS(519),
    [anon_sym_debugger] = ACTIONS(519),
    [anon_sym_return] = ACTIONS(519),
    [anon_sym_throw] = ACTIONS(519),
    [anon_sym_SEMI] = ACTIONS(517),
    [anon_sym_case] = ACTIONS(519),
    [anon_sym_yield] = ACTIONS(519),
    [anon_sym_LBRACK] = ACTIONS(517),
    [anon_sym_LT] = ACTIONS(519),
    [anon_sym_GT] = ACTIONS(521),
    [anon_sym_SLASH] = ACTIONS(519),
    [anon_sym_DOT] = ACTIONS(521),
    [anon_sym_class] = ACTIONS(519),
    [anon_sym_async] = ACTIONS(519),
    [anon_sym_function] = ACTIONS(519),
    [anon_sym_QMARK_DOT] = ACTIONS(523),
    [anon_sym_new] = ACTIONS(519),
    [anon_sym_AMP_AMP] = ACTIONS(523),
    [anon_sym_PIPE_PIPE] = ACTIONS(523),
    [anon_sym_GT_GT] = ACTIONS(521),
    [anon_sym_GT_GT_GT] = ACTIONS(523),
    [anon_sym_LT_LT] = ACTIONS(523),
    [anon_sym_AMP] = ACTIONS(521),
    [anon_sym_CARET] = ACTIONS(523),
    [anon_sym_PIPE] = ACTIONS(521),
    [anon_sym_PLUS] = ACTIONS(519),
    [anon_sym_DASH] = ACTIONS(519),
    [anon_sym_PERCENT] = ACTIONS(523),
    [anon_sym_STAR_STAR] = ACTIONS(523),
    [anon_sym_LT_EQ] = ACTIONS(523),
    [anon_sym_EQ_EQ] = ACTIONS(521),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(523),
    [anon_sym_BANG_EQ] = ACTIONS(521),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(523),
    [anon_sym_GT_EQ] = ACTIONS(523),
    [anon_sym_QMARK_QMARK] = ACTIONS(523),
    [anon_sym_instanceof] = ACTIONS(521),
    [anon_sym_BANG] = ACTIONS(519),
    [anon_sym_TILDE] = ACTIONS(517),
    [anon_sym_typeof] = ACTIONS(519),
    [anon_sym_void] = ACTIONS(519),
    [anon_sym_delete] = ACTIONS(519),
    [anon_sym_PLUS_PLUS] = ACTIONS(517),
    [anon_sym_DASH_DASH] = ACTIONS(517),
    [anon_sym_DQUOTE] = ACTIONS(517),
    [anon_sym_SQUOTE] = ACTIONS(517),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(517),
    [sym_number] = ACTIONS(517),
    [sym_this] = ACTIONS(519),
    [sym_super] = ACTIONS(519),
    [sym_true] = ACTIONS(519),
    [sym_false] = ACTIONS(519),
    [sym_null] = ACTIONS(519),
    [sym_undefined] = ACTIONS(519),
    [anon_sym_AT] = ACTIONS(517),
    [anon_sym_static] = ACTIONS(519),
    [anon_sym_get] = ACTIONS(519),
    [anon_sym_set] = ACTIONS(519),
    [sym__automatic_semicolon] = ACTIONS(525),
    [sym__ternary_qmark] = ACTIONS(523),
  },
  [57] = {
    [ts_builtin_sym_end] = ACTIONS(527),
    [sym_identifier] = ACTIONS(529),
    [anon_sym_export] = ACTIONS(529),
    [anon_sym_STAR] = ACTIONS(531),
    [anon_sym_default] = ACTIONS(529),
    [anon_sym_LBRACE] = ACTIONS(527),
    [anon_sym_COMMA] = ACTIONS(533),
    [anon_sym_RBRACE] = ACTIONS(527),
    [anon_sym_import] = ACTIONS(529),
    [anon_sym_var] = ACTIONS(529),
    [anon_sym_let] = ACTIONS(529),
    [anon_sym_const] = ACTIONS(529),
    [anon_sym_else] = ACTIONS(529),
    [anon_sym_if] = ACTIONS(529),
    [anon_sym_switch] = ACTIONS(529),
    [anon_sym_for] = ACTIONS(529),
    [anon_sym_LPAREN] = ACTIONS(527),
    [anon_sym_await] = ACTIONS(529),
    [anon_sym_in] = ACTIONS(531),
    [anon_sym_while] = ACTIONS(529),
    [anon_sym_do] = ACTIONS(529),
    [anon_sym_try] = ACTIONS(529),
    [anon_sym_with] = ACTIONS(529),
    [anon_sym_break] = ACTIONS(529),
    [anon_sym_continue] = ACTIONS(529),
    [anon_sym_debugger] = ACTIONS(529),
    [anon_sym_return] = ACTIONS(529),
    [anon_sym_throw] = ACTIONS(529),
    [anon_sym_SEMI] = ACTIONS(527),
    [anon_sym_case] = ACTIONS(529),
    [anon_sym_yield] = ACTIONS(529),
    [anon_sym_LBRACK] = ACTIONS(527),
    [anon_sym_LT] = ACTIONS(529),
    [anon_sym_GT] = ACTIONS(531),
    [anon_sym_SLASH] = ACTIONS(529),
    [anon_sym_DOT] = ACTIONS(531),
    [anon_sym_class] = ACTIONS(529),
    [anon_sym_async] = ACTIONS(529),
    [anon_sym_function] = ACTIONS(529),
    [anon_sym_QMARK_DOT] = ACTIONS(533),
    [anon_sym_new] = ACTIONS(529),
    [anon_sym_AMP_AMP] = ACTIONS(533),
    [anon_sym_PIPE_PIPE] = ACTIONS(533),
    [anon_sym_GT_GT] = ACTIONS(531),
    [anon_sym_GT_GT_GT] = ACTIONS(533),
    [anon_sym_LT_LT] = ACTIONS(533),
    [anon_sym_AMP] = ACTIONS(531),
    [anon_sym_CARET] = ACTIONS(533),
    [anon_sym_PIPE] = ACTIONS(531),
    [anon_sym_PLUS] = ACTIONS(529),
    [anon_sym_DASH] = ACTIONS(529),
    [anon_sym_PERCENT] = ACTIONS(533),
    [anon_sym_STAR_STAR] = ACTIONS(533),
    [anon_sym_LT_EQ] = ACTIONS(533),
    [anon_sym_EQ_EQ] = ACTIONS(531),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(533),
    [anon_sym_BANG_EQ] = ACTIONS(531),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(533),
    [anon_sym_GT_EQ] = ACTIONS(533),
    [anon_sym_QMARK_QMARK] = ACTIONS(533),
    [anon_sym_instanceof] = ACTIONS(531),
    [anon_sym_BANG] = ACTIONS(529),
    [anon_sym_TILDE] = ACTIONS(527),
    [anon_sym_typeof] = ACTIONS(529),
    [anon_sym_void] = ACTIONS(529),
    [anon_sym_delete] = ACTIONS(529),
    [anon_sym_PLUS_PLUS] = ACTIONS(527),
    [anon_sym_DASH_DASH] = ACTIONS(527),
    [anon_sym_DQUOTE] = ACTIONS(527),
    [anon_sym_SQUOTE] = ACTIONS(527),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(527),
    [sym_number] = ACTIONS(527),
    [sym_this] = ACTIONS(529),
    [sym_super] = ACTIONS(529),
    [sym_true] = ACTIONS(529),
    [sym_false] = ACTIONS(529),
    [sym_null] = ACTIONS(529),
    [sym_undefined] = ACTIONS(529),
    [anon_sym_AT] = ACTIONS(527),
    [anon_sym_static] = ACTIONS(529),
    [anon_sym_get] = ACTIONS(529),
    [anon_sym_set] = ACTIONS(529),
    [sym__automatic_semicolon] = ACTIONS(535),
    [sym__ternary_qmark] = ACTIONS(533),
  },
  [58] = {
    [ts_builtin_sym_end] = ACTIONS(537),
    [sym_identifier] = ACTIONS(539),
    [anon_sym_export] = ACTIONS(539),
    [anon_sym_STAR] = ACTIONS(541),
    [anon_sym_default] = ACTIONS(539),
    [anon_sym_LBRACE] = ACTIONS(537),
    [anon_sym_COMMA] = ACTIONS(543),
    [anon_sym_RBRACE] = ACTIONS(537),
    [anon_sym_import] = ACTIONS(539),
    [anon_sym_var] = ACTIONS(539),
    [anon_sym_let] = ACTIONS(539),
    [anon_sym_const] = ACTIONS(539),
    [anon_sym_else] = ACTIONS(539),
    [anon_sym_if] = ACTIONS(539),
    [anon_sym_switch] = ACTIONS(539),
    [anon_sym_for] = ACTIONS(539),
    [anon_sym_LPAREN] = ACTIONS(537),
    [anon_sym_await] = ACTIONS(539),
    [anon_sym_in] = ACTIONS(541),
    [anon_sym_while] = ACTIONS(539),
    [anon_sym_do] = ACTIONS(539),
    [anon_sym_try] = ACTIONS(539),
    [anon_sym_with] = ACTIONS(539),
    [anon_sym_break] = ACTIONS(539),
    [anon_sym_continue] = ACTIONS(539),
    [anon_sym_debugger] = ACTIONS(539),
    [anon_sym_return] = ACTIONS(539),
    [anon_sym_throw] = ACTIONS(539),
    [anon_sym_SEMI] = ACTIONS(537),
    [anon_sym_case] = ACTIONS(539),
    [anon_sym_yield] = ACTIONS(539),
    [anon_sym_LBRACK] = ACTIONS(537),
    [anon_sym_LT] = ACTIONS(539),
    [anon_sym_GT] = ACTIONS(541),
    [anon_sym_SLASH] = ACTIONS(539),
    [anon_sym_DOT] = ACTIONS(541),
    [anon_sym_class] = ACTIONS(539),
    [anon_sym_async] = ACTIONS(539),
    [anon_sym_function] = ACTIONS(539),
    [anon_sym_QMARK_DOT] = ACTIONS(543),
    [anon_sym_new] = ACTIONS(539),
    [anon_sym_AMP_AMP] = ACTIONS(543),
    [anon_sym_PIPE_PIPE] = ACTIONS(543),
    [anon_sym_GT_GT] = ACTIONS(541),
    [anon_sym_GT_GT_GT] = ACTIONS(543),
    [anon_sym_LT_LT] = ACTIONS(543),
    [anon_sym_AMP] = ACTIONS(541),
    [anon_sym_CARET] = ACTIONS(543),
    [anon_sym_PIPE] = ACTIONS(541),
    [anon_sym_PLUS] = ACTIONS(539),
    [anon_sym_DASH] = ACTIONS(539),
    [anon_sym_PERCENT] = ACTIONS(543),
    [anon_sym_STAR_STAR] = ACTIONS(543),
    [anon_sym_LT_EQ] = ACTIONS(543),
    [anon_sym_EQ_EQ] = ACTIONS(541),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(543),
    [anon_sym_BANG_EQ] = ACTIONS(541),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(543),
    [anon_sym_GT_EQ] = ACTIONS(543),
    [anon_sym_QMARK_QMARK] = ACTIONS(543),
    [anon_sym_instanceof] = ACTIONS(541),
    [anon_sym_BANG] = ACTIONS(539),
    [anon_sym_TILDE] = ACTIONS(537),
    [anon_sym_typeof] = ACTIONS(539),
    [anon_sym_void] = ACTIONS(539),
    [anon_sym_delete] = ACTIONS(539),
    [anon_sym_PLUS_PLUS] = ACTIONS(537),
    [anon_sym_DASH_DASH] = ACTIONS(537),
    [anon_sym_DQUOTE] = ACTIONS(537),
    [anon_sym_SQUOTE] = ACTIONS(537),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(537),
    [sym_number] = ACTIONS(537),
    [sym_this] = ACTIONS(539),
    [sym_super] = ACTIONS(539),
    [sym_true] = ACTIONS(539),
    [sym_false] = ACTIONS(539),
    [sym_null] = ACTIONS(539),
    [sym_undefined] = ACTIONS(539),
    [anon_sym_AT] = ACTIONS(537),
    [anon_sym_static] = ACTIONS(539),
    [anon_sym_get] = ACTIONS(539),
    [anon_sym_set] = ACTIONS(539),
    [sym__automatic_semicolon] = ACTIONS(545),
    [sym__ternary_qmark] = ACTIONS(543),
  },
  [59] = {
    [ts_builtin_sym_end] = ACTIONS(547),
    [sym_identifier] = ACTIONS(549),
    [anon_sym_export] = ACTIONS(549),
    [anon_sym_STAR] = ACTIONS(551),
    [anon_sym_default] = ACTIONS(549),
    [anon_sym_LBRACE] = ACTIONS(547),
    [anon_sym_COMMA] = ACTIONS(553),
    [anon_sym_RBRACE] = ACTIONS(547),
    [anon_sym_import] = ACTIONS(549),
    [anon_sym_var] = ACTIONS(549),
    [anon_sym_let] = ACTIONS(549),
    [anon_sym_const] = ACTIONS(549),
    [anon_sym_else] = ACTIONS(549),
    [anon_sym_if] = ACTIONS(549),
    [anon_sym_switch] = ACTIONS(549),
    [anon_sym_for] = ACTIONS(549),
    [anon_sym_LPAREN] = ACTIONS(547),
    [anon_sym_await] = ACTIONS(549),
    [anon_sym_in] = ACTIONS(551),
    [anon_sym_while] = ACTIONS(549),
    [anon_sym_do] = ACTIONS(549),
    [anon_sym_try] = ACTIONS(549),
    [anon_sym_with] = ACTIONS(549),
    [anon_sym_break] = ACTIONS(549),
    [anon_sym_continue] = ACTIONS(549),
    [anon_sym_debugger] = ACTIONS(549),
    [anon_sym_return] = ACTIONS(549),
    [anon_sym_throw] = ACTIONS(549),
    [anon_sym_SEMI] = ACTIONS(547),
    [anon_sym_case] = ACTIONS(549),
    [anon_sym_yield] = ACTIONS(549),
    [anon_sym_LBRACK] = ACTIONS(547),
    [anon_sym_LT] = ACTIONS(549),
    [anon_sym_GT] = ACTIONS(551),
    [anon_sym_SLASH] = ACTIONS(549),
    [anon_sym_DOT] = ACTIONS(551),
    [anon_sym_class] = ACTIONS(549),
    [anon_sym_async] = ACTIONS(549),
    [anon_sym_function] = ACTIONS(549),
    [anon_sym_QMARK_DOT] = ACTIONS(553),
    [anon_sym_new] = ACTIONS(549),
    [anon_sym_AMP_AMP] = ACTIONS(553),
    [anon_sym_PIPE_PIPE] = ACTIONS(553),
    [anon_sym_GT_GT] = ACTIONS(551),
    [anon_sym_GT_GT_GT] = ACTIONS(553),
    [anon_sym_LT_LT] = ACTIONS(553),
    [anon_sym_AMP] = ACTIONS(551),
    [anon_sym_CARET] = ACTIONS(553),
    [anon_sym_PIPE] = ACTIONS(551),
    [anon_sym_PLUS] = ACTIONS(549),
    [anon_sym_DASH] = ACTIONS(549),
    [anon_sym_PERCENT] = ACTIONS(553),
    [anon_sym_STAR_STAR] = ACTIONS(553),
    [anon_sym_LT_EQ] = ACTIONS(553),
    [anon_sym_EQ_EQ] = ACTIONS(551),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(553),
    [anon_sym_BANG_EQ] = ACTIONS(551),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(553),
    [anon_sym_GT_EQ] = ACTIONS(553),
    [anon_sym_QMARK_QMARK] = ACTIONS(553),
    [anon_sym_instanceof] = ACTIONS(551),
    [anon_sym_BANG] = ACTIONS(549),
    [anon_sym_TILDE] = ACTIONS(547),
    [anon_sym_typeof] = ACTIONS(549),
    [anon_sym_void] = ACTIONS(549),
    [anon_sym_delete] = ACTIONS(549),
    [anon_sym_PLUS_PLUS] = ACTIONS(547),
    [anon_sym_DASH_DASH] = ACTIONS(547),
    [anon_sym_DQUOTE] = ACTIONS(547),
    [anon_sym_SQUOTE] = ACTIONS(547),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(547),
    [sym_number] = ACTIONS(547),
    [sym_this] = ACTIONS(549),
    [sym_super] = ACTIONS(549),
    [sym_true] = ACTIONS(549),
    [sym_false] = ACTIONS(549),
    [sym_null] = ACTIONS(549),
    [sym_undefined] = ACTIONS(549),
    [anon_sym_AT] = ACTIONS(547),
    [anon_sym_static] = ACTIONS(549),
    [anon_sym_get] = ACTIONS(549),
    [anon_sym_set] = ACTIONS(549),
    [sym__automatic_semicolon] = ACTIONS(555),
    [sym__ternary_qmark] = ACTIONS(553),
  },
  [60] = {
    [ts_builtin_sym_end] = ACTIONS(557),
    [sym_identifier] = ACTIONS(559),
    [anon_sym_export] = ACTIONS(559),
    [anon_sym_STAR] = ACTIONS(561),
    [anon_sym_default] = ACTIONS(559),
    [anon_sym_LBRACE] = ACTIONS(557),
    [anon_sym_COMMA] = ACTIONS(563),
    [anon_sym_RBRACE] = ACTIONS(557),
    [anon_sym_import] = ACTIONS(559),
    [anon_sym_var] = ACTIONS(559),
    [anon_sym_let] = ACTIONS(559),
    [anon_sym_const] = ACTIONS(559),
    [anon_sym_else] = ACTIONS(559),
    [anon_sym_if] = ACTIONS(559),
    [anon_sym_switch] = ACTIONS(559),
    [anon_sym_for] = ACTIONS(559),
    [anon_sym_LPAREN] = ACTIONS(557),
    [anon_sym_await] = ACTIONS(559),
    [anon_sym_in] = ACTIONS(561),
    [anon_sym_while] = ACTIONS(559),
    [anon_sym_do] = ACTIONS(559),
    [anon_sym_try] = ACTIONS(559),
    [anon_sym_with] = ACTIONS(559),
    [anon_sym_break] = ACTIONS(559),
    [anon_sym_continue] = ACTIONS(559),
    [anon_sym_debugger] = ACTIONS(559),
    [anon_sym_return] = ACTIONS(559),
    [anon_sym_throw] = ACTIONS(559),
    [anon_sym_SEMI] = ACTIONS(557),
    [anon_sym_case] = ACTIONS(559),
    [anon_sym_yield] = ACTIONS(559),
    [anon_sym_LBRACK] = ACTIONS(557),
    [anon_sym_LT] = ACTIONS(559),
    [anon_sym_GT] = ACTIONS(561),
    [anon_sym_SLASH] = ACTIONS(559),
    [anon_sym_DOT] = ACTIONS(561),
    [anon_sym_class] = ACTIONS(559),
    [anon_sym_async] = ACTIONS(559),
    [anon_sym_function] = ACTIONS(559),
    [anon_sym_QMARK_DOT] = ACTIONS(563),
    [anon_sym_new] = ACTIONS(559),
    [anon_sym_AMP_AMP] = ACTIONS(563),
    [anon_sym_PIPE_PIPE] = ACTIONS(563),
    [anon_sym_GT_GT] = ACTIONS(561),
    [anon_sym_GT_GT_GT] = ACTIONS(563),
    [anon_sym_LT_LT] = ACTIONS(563),
    [anon_sym_AMP] = ACTIONS(561),
    [anon_sym_CARET] = ACTIONS(563),
    [anon_sym_PIPE] = ACTIONS(561),
    [anon_sym_PLUS] = ACTIONS(559),
    [anon_sym_DASH] = ACTIONS(559),
    [anon_sym_PERCENT] = ACTIONS(563),
    [anon_sym_STAR_STAR] = ACTIONS(563),
    [anon_sym_LT_EQ] = ACTIONS(563),
    [anon_sym_EQ_EQ] = ACTIONS(561),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(563),
    [anon_sym_BANG_EQ] = ACTIONS(561),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(563),
    [anon_sym_GT_EQ] = ACTIONS(563),
    [anon_sym_QMARK_QMARK] = ACTIONS(563),
    [anon_sym_instanceof] = ACTIONS(561),
    [anon_sym_BANG] = ACTIONS(559),
    [anon_sym_TILDE] = ACTIONS(557),
    [anon_sym_typeof] = ACTIONS(559),
    [anon_sym_void] = ACTIONS(559),
    [anon_sym_delete] = ACTIONS(559),
    [anon_sym_PLUS_PLUS] = ACTIONS(557),
    [anon_sym_DASH_DASH] = ACTIONS(557),
    [anon_sym_DQUOTE] = ACTIONS(557),
    [anon_sym_SQUOTE] = ACTIONS(557),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(557),
    [sym_number] = ACTIONS(557),
    [sym_this] = ACTIONS(559),
    [sym_super] = ACTIONS(559),
    [sym_true] = ACTIONS(559),
    [sym_false] = ACTIONS(559),
    [sym_null] = ACTIONS(559),
    [sym_undefined] = ACTIONS(559),
    [anon_sym_AT] = ACTIONS(557),
    [anon_sym_static] = ACTIONS(559),
    [anon_sym_get] = ACTIONS(559),
    [anon_sym_set] = ACTIONS(559),
    [sym__automatic_semicolon] = ACTIONS(565),
    [sym__ternary_qmark] = ACTIONS(563),
  },
  [61] = {
    [ts_builtin_sym_end] = ACTIONS(567),
    [sym_identifier] = ACTIONS(569),
    [anon_sym_export] = ACTIONS(569),
    [anon_sym_STAR] = ACTIONS(571),
    [anon_sym_default] = ACTIONS(569),
    [anon_sym_LBRACE] = ACTIONS(567),
    [anon_sym_COMMA] = ACTIONS(573),
    [anon_sym_RBRACE] = ACTIONS(567),
    [anon_sym_import] = ACTIONS(569),
    [anon_sym_var] = ACTIONS(569),
    [anon_sym_let] = ACTIONS(569),
    [anon_sym_const] = ACTIONS(569),
    [anon_sym_else] = ACTIONS(569),
    [anon_sym_if] = ACTIONS(569),
    [anon_sym_switch] = ACTIONS(569),
    [anon_sym_for] = ACTIONS(569),
    [anon_sym_LPAREN] = ACTIONS(567),
    [anon_sym_await] = ACTIONS(569),
    [anon_sym_in] = ACTIONS(571),
    [anon_sym_while] = ACTIONS(569),
    [anon_sym_do] = ACTIONS(569),
    [anon_sym_try] = ACTIONS(569),
    [anon_sym_with] = ACTIONS(569),
    [anon_sym_break] = ACTIONS(569),
    [anon_sym_continue] = ACTIONS(569),
    [anon_sym_debugger] = ACTIONS(569),
    [anon_sym_return] = ACTIONS(569),
    [anon_sym_throw] = ACTIONS(569),
    [anon_sym_SEMI] = ACTIONS(567),
    [anon_sym_case] = ACTIONS(569),
    [anon_sym_yield] = ACTIONS(569),
    [anon_sym_LBRACK] = ACTIONS(567),
    [anon_sym_LT] = ACTIONS(569),
    [anon_sym_GT] = ACTIONS(571),
    [anon_sym_SLASH] = ACTIONS(569),
    [anon_sym_DOT] = ACTIONS(571),
    [anon_sym_class] = ACTIONS(569),
    [anon_sym_async] = ACTIONS(569),
    [anon_sym_function] = ACTIONS(569),
    [anon_sym_QMARK_DOT] = ACTIONS(573),
    [anon_sym_new] = ACTIONS(569),
    [anon_sym_AMP_AMP] = ACTIONS(573),
    [anon_sym_PIPE_PIPE] = ACTIONS(573),
    [anon_sym_GT_GT] = ACTIONS(571),
    [anon_sym_GT_GT_GT] = ACTIONS(573),
    [anon_sym_LT_LT] = ACTIONS(573),
    [anon_sym_AMP] = ACTIONS(571),
    [anon_sym_CARET] = ACTIONS(573),
    [anon_sym_PIPE] = ACTIONS(571),
    [anon_sym_PLUS] = ACTIONS(569),
    [anon_sym_DASH] = ACTIONS(569),
    [anon_sym_PERCENT] = ACTIONS(573),
    [anon_sym_STAR_STAR] = ACTIONS(573),
    [anon_sym_LT_EQ] = ACTIONS(573),
    [anon_sym_EQ_EQ] = ACTIONS(571),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(573),
    [anon_sym_BANG_EQ] = ACTIONS(571),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(573),
    [anon_sym_GT_EQ] = ACTIONS(573),
    [anon_sym_QMARK_QMARK] = ACTIONS(573),
    [anon_sym_instanceof] = ACTIONS(571),
    [anon_sym_BANG] = ACTIONS(569),
    [anon_sym_TILDE] = ACTIONS(567),
    [anon_sym_typeof] = ACTIONS(569),
    [anon_sym_void] = ACTIONS(569),
    [anon_sym_delete] = ACTIONS(569),
    [anon_sym_PLUS_PLUS] = ACTIONS(567),
    [anon_sym_DASH_DASH] = ACTIONS(567),
    [anon_sym_DQUOTE] = ACTIONS(567),
    [anon_sym_SQUOTE] = ACTIONS(567),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(567),
    [sym_number] = ACTIONS(567),
    [sym_this] = ACTIONS(569),
    [sym_super] = ACTIONS(569),
    [sym_true] = ACTIONS(569),
    [sym_false] = ACTIONS(569),
    [sym_null] = ACTIONS(569),
    [sym_undefined] = ACTIONS(569),
    [anon_sym_AT] = ACTIONS(567),
    [anon_sym_static] = ACTIONS(569),
    [anon_sym_get] = ACTIONS(569),
    [anon_sym_set] = ACTIONS(569),
    [sym__automatic_semicolon] = ACTIONS(575),
    [sym__ternary_qmark] = ACTIONS(573),
  },
  [62] = {
    [sym_import] = STATE(575),
    [sym_parenthesized_expression] = STATE(449),
    [sym_expression] = STATE(675),
    [sym_primary_expression] = STATE(576),
    [sym_yield_expression] = STATE(577),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1112),
    [sym_assignment_pattern] = STATE(1191),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1112),
    [sym_jsx_element] = STATE(577),
    [sym_jsx_fragment] = STATE(577),
    [sym_jsx_opening_element] = STATE(975),
    [sym_jsx_self_closing_element] = STATE(577),
    [sym_class] = STATE(575),
    [sym_function] = STATE(575),
    [sym_generator_function] = STATE(575),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(577),
    [sym_await_expression] = STATE(577),
    [sym_member_expression] = STATE(468),
    [sym_subscript_expression] = STATE(468),
    [sym_assignment_expression] = STATE(577),
    [sym__augmented_assignment_lhs] = STATE(943),
    [sym_augmented_assignment_expression] = STATE(577),
    [sym__destructuring_pattern] = STATE(1112),
    [sym_spread_element] = STATE(1269),
    [sym_ternary_expression] = STATE(577),
    [sym_binary_expression] = STATE(577),
    [sym_unary_expression] = STATE(577),
    [sym_update_expression] = STATE(577),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1496),
    [sym_pattern] = STATE(1165),
    [sym_rest_pattern] = STATE(1083),
    [aux_sym_export_statement_repeat1] = STATE(1182),
    [aux_sym_array_repeat1] = STATE(1268),
    [aux_sym_array_pattern_repeat1] = STATE(1285),
    [sym_identifier] = ACTIONS(577),
    [anon_sym_export] = ACTIONS(579),
    [anon_sym_LBRACE] = ACTIONS(421),
    [anon_sym_COMMA] = ACTIONS(581),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(335),
    [anon_sym_yield] = ACTIONS(339),
    [anon_sym_LBRACK] = ACTIONS(427),
    [anon_sym_RBRACK] = ACTIONS(583),
    [anon_sym_LT] = ACTIONS(585),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(587),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(353),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(103),
    [anon_sym_PLUS] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(355),
    [anon_sym_BANG] = ACTIONS(357),
    [anon_sym_TILDE] = ACTIONS(357),
    [anon_sym_typeof] = ACTIONS(355),
    [anon_sym_void] = ACTIONS(355),
    [anon_sym_delete] = ACTIONS(355),
    [anon_sym_PLUS_PLUS] = ACTIONS(359),
    [anon_sym_DASH_DASH] = ACTIONS(359),
    [anon_sym_DQUOTE] = ACTIONS(361),
    [anon_sym_SQUOTE] = ACTIONS(363),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(365),
    [sym_number] = ACTIONS(367),
    [sym_this] = ACTIONS(369),
    [sym_super] = ACTIONS(369),
    [sym_true] = ACTIONS(369),
    [sym_false] = ACTIONS(369),
    [sym_null] = ACTIONS(369),
    [sym_undefined] = ACTIONS(589),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(579),
    [anon_sym_get] = ACTIONS(579),
    [anon_sym_set] = ACTIONS(579),
  },
  [63] = {
    [sym_declaration] = STATE(423),
    [sym_import] = STATE(721),
    [sym_variable_declaration] = STATE(415),
    [sym_lexical_declaration] = STATE(415),
    [sym_parenthesized_expression] = STATE(479),
    [sym_expression] = STATE(776),
    [sym_primary_expression] = STATE(743),
    [sym_yield_expression] = STATE(740),
    [sym_object] = STATE(721),
    [sym_object_pattern] = STATE(1548),
    [sym_array] = STATE(721),
    [sym_array_pattern] = STATE(1548),
    [sym_jsx_element] = STATE(740),
    [sym_jsx_fragment] = STATE(740),
    [sym_jsx_opening_element] = STATE(972),
    [sym_jsx_self_closing_element] = STATE(740),
    [sym_class] = STATE(721),
    [sym_class_declaration] = STATE(415),
    [sym_function] = STATE(721),
    [sym_function_declaration] = STATE(415),
    [sym_generator_function] = STATE(721),
    [sym_generator_function_declaration] = STATE(415),
    [sym_arrow_function] = STATE(721),
    [sym_call_expression] = STATE(721),
    [sym_new_expression] = STATE(740),
    [sym_await_expression] = STATE(740),
    [sym_member_expression] = STATE(479),
    [sym_subscript_expression] = STATE(479),
    [sym_assignment_expression] = STATE(740),
    [sym__augmented_assignment_lhs] = STATE(942),
    [sym_augmented_assignment_expression] = STATE(740),
    [sym__destructuring_pattern] = STATE(1548),
    [sym_ternary_expression] = STATE(740),
    [sym_binary_expression] = STATE(740),
    [sym_unary_expression] = STATE(740),
    [sym_update_expression] = STATE(740),
    [sym_string] = STATE(721),
    [sym_template_string] = STATE(721),
    [sym_regex] = STATE(721),
    [sym_meta_property] = STATE(721),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1546),
    [aux_sym_export_statement_repeat1] = STATE(1155),
    [sym_identifier] = ACTIONS(407),
    [anon_sym_export] = ACTIONS(409),
    [anon_sym_LBRACE] = ACTIONS(379),
    [anon_sym_import] = ACTIONS(381),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(591),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(67),
    [anon_sym_void] = ACTIONS(67),
    [anon_sym_delete] = ACTIONS(67),
    [anon_sym_PLUS_PLUS] = ACTIONS(71),
    [anon_sym_DASH_DASH] = ACTIONS(71),
    [anon_sym_DQUOTE] = ACTIONS(73),
    [anon_sym_SQUOTE] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(77),
    [sym_number] = ACTIONS(79),
    [sym_this] = ACTIONS(81),
    [sym_super] = ACTIONS(81),
    [sym_true] = ACTIONS(81),
    [sym_false] = ACTIONS(81),
    [sym_null] = ACTIONS(81),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(409),
    [anon_sym_get] = ACTIONS(409),
    [anon_sym_set] = ACTIONS(409),
  },
  [64] = {
    [sym_declaration] = STATE(386),
    [sym_import] = STATE(721),
    [sym_variable_declaration] = STATE(415),
    [sym_lexical_declaration] = STATE(415),
    [sym_parenthesized_expression] = STATE(479),
    [sym_expression] = STATE(794),
    [sym_primary_expression] = STATE(743),
    [sym_yield_expression] = STATE(740),
    [sym_object] = STATE(721),
    [sym_object_pattern] = STATE(1548),
    [sym_array] = STATE(721),
    [sym_array_pattern] = STATE(1548),
    [sym_jsx_element] = STATE(740),
    [sym_jsx_fragment] = STATE(740),
    [sym_jsx_opening_element] = STATE(972),
    [sym_jsx_self_closing_element] = STATE(740),
    [sym_class] = STATE(721),
    [sym_class_declaration] = STATE(415),
    [sym_function] = STATE(721),
    [sym_function_declaration] = STATE(415),
    [sym_generator_function] = STATE(721),
    [sym_generator_function_declaration] = STATE(415),
    [sym_arrow_function] = STATE(721),
    [sym_call_expression] = STATE(721),
    [sym_new_expression] = STATE(740),
    [sym_await_expression] = STATE(740),
    [sym_member_expression] = STATE(479),
    [sym_subscript_expression] = STATE(479),
    [sym_assignment_expression] = STATE(740),
    [sym__augmented_assignment_lhs] = STATE(942),
    [sym_augmented_assignment_expression] = STATE(740),
    [sym__destructuring_pattern] = STATE(1548),
    [sym_ternary_expression] = STATE(740),
    [sym_binary_expression] = STATE(740),
    [sym_unary_expression] = STATE(740),
    [sym_update_expression] = STATE(740),
    [sym_string] = STATE(721),
    [sym_template_string] = STATE(721),
    [sym_regex] = STATE(721),
    [sym_meta_property] = STATE(721),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1546),
    [aux_sym_export_statement_repeat1] = STATE(1155),
    [sym_identifier] = ACTIONS(407),
    [anon_sym_export] = ACTIONS(409),
    [anon_sym_LBRACE] = ACTIONS(379),
    [anon_sym_import] = ACTIONS(381),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(59),
    [anon_sym_async] = ACTIONS(591),
    [anon_sym_function] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(67),
    [anon_sym_void] = ACTIONS(67),
    [anon_sym_delete] = ACTIONS(67),
    [anon_sym_PLUS_PLUS] = ACTIONS(71),
    [anon_sym_DASH_DASH] = ACTIONS(71),
    [anon_sym_DQUOTE] = ACTIONS(73),
    [anon_sym_SQUOTE] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(77),
    [sym_number] = ACTIONS(79),
    [sym_this] = ACTIONS(81),
    [sym_super] = ACTIONS(81),
    [sym_true] = ACTIONS(81),
    [sym_false] = ACTIONS(81),
    [sym_null] = ACTIONS(81),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(409),
    [anon_sym_get] = ACTIONS(409),
    [anon_sym_set] = ACTIONS(409),
  },
  [65] = {
    [sym_import] = STATE(575),
    [sym_parenthesized_expression] = STATE(449),
    [sym_expression] = STATE(690),
    [sym_primary_expression] = STATE(576),
    [sym_yield_expression] = STATE(577),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1112),
    [sym_assignment_pattern] = STATE(1191),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1112),
    [sym_jsx_element] = STATE(577),
    [sym_jsx_fragment] = STATE(577),
    [sym_jsx_opening_element] = STATE(975),
    [sym_jsx_self_closing_element] = STATE(577),
    [sym_class] = STATE(575),
    [sym_function] = STATE(575),
    [sym_generator_function] = STATE(575),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(577),
    [sym_await_expression] = STATE(577),
    [sym_member_expression] = STATE(468),
    [sym_subscript_expression] = STATE(468),
    [sym_assignment_expression] = STATE(577),
    [sym__augmented_assignment_lhs] = STATE(943),
    [sym_augmented_assignment_expression] = STATE(577),
    [sym__destructuring_pattern] = STATE(1112),
    [sym_spread_element] = STATE(1292),
    [sym_ternary_expression] = STATE(577),
    [sym_binary_expression] = STATE(577),
    [sym_unary_expression] = STATE(577),
    [sym_update_expression] = STATE(577),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1496),
    [sym_pattern] = STATE(1165),
    [sym_rest_pattern] = STATE(1083),
    [aux_sym_export_statement_repeat1] = STATE(1182),
    [aux_sym_array_repeat1] = STATE(1288),
    [aux_sym_array_pattern_repeat1] = STATE(1285),
    [sym_identifier] = ACTIONS(577),
    [anon_sym_export] = ACTIONS(579),
    [anon_sym_LBRACE] = ACTIONS(421),
    [anon_sym_COMMA] = ACTIONS(581),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(335),
    [anon_sym_yield] = ACTIONS(339),
    [anon_sym_LBRACK] = ACTIONS(427),
    [anon_sym_RBRACK] = ACTIONS(593),
    [anon_sym_LT] = ACTIONS(585),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(587),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(353),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(103),
    [anon_sym_PLUS] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(355),
    [anon_sym_BANG] = ACTIONS(357),
    [anon_sym_TILDE] = ACTIONS(357),
    [anon_sym_typeof] = ACTIONS(355),
    [anon_sym_void] = ACTIONS(355),
    [anon_sym_delete] = ACTIONS(355),
    [anon_sym_PLUS_PLUS] = ACTIONS(359),
    [anon_sym_DASH_DASH] = ACTIONS(359),
    [anon_sym_DQUOTE] = ACTIONS(361),
    [anon_sym_SQUOTE] = ACTIONS(363),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(365),
    [sym_number] = ACTIONS(367),
    [sym_this] = ACTIONS(369),
    [sym_super] = ACTIONS(369),
    [sym_true] = ACTIONS(369),
    [sym_false] = ACTIONS(369),
    [sym_null] = ACTIONS(369),
    [sym_undefined] = ACTIONS(589),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(579),
    [anon_sym_get] = ACTIONS(579),
    [anon_sym_set] = ACTIONS(579),
  },
  [66] = {
    [sym_import] = STATE(575),
    [sym_parenthesized_expression] = STATE(449),
    [sym_expression] = STATE(675),
    [sym_primary_expression] = STATE(576),
    [sym_yield_expression] = STATE(577),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1112),
    [sym_assignment_pattern] = STATE(1191),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1112),
    [sym_jsx_element] = STATE(577),
    [sym_jsx_fragment] = STATE(577),
    [sym_jsx_opening_element] = STATE(975),
    [sym_jsx_self_closing_element] = STATE(577),
    [sym_class] = STATE(575),
    [sym_function] = STATE(575),
    [sym_generator_function] = STATE(575),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(577),
    [sym_await_expression] = STATE(577),
    [sym_member_expression] = STATE(468),
    [sym_subscript_expression] = STATE(468),
    [sym_assignment_expression] = STATE(577),
    [sym__augmented_assignment_lhs] = STATE(943),
    [sym_augmented_assignment_expression] = STATE(577),
    [sym__destructuring_pattern] = STATE(1112),
    [sym_spread_element] = STATE(1269),
    [sym_ternary_expression] = STATE(577),
    [sym_binary_expression] = STATE(577),
    [sym_unary_expression] = STATE(577),
    [sym_update_expression] = STATE(577),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1496),
    [sym_pattern] = STATE(1165),
    [sym_rest_pattern] = STATE(1083),
    [aux_sym_export_statement_repeat1] = STATE(1182),
    [aux_sym_array_repeat1] = STATE(1268),
    [aux_sym_array_pattern_repeat1] = STATE(1285),
    [sym_identifier] = ACTIONS(577),
    [anon_sym_export] = ACTIONS(579),
    [anon_sym_LBRACE] = ACTIONS(421),
    [anon_sym_COMMA] = ACTIONS(581),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(335),
    [anon_sym_yield] = ACTIONS(339),
    [anon_sym_LBRACK] = ACTIONS(427),
    [anon_sym_RBRACK] = ACTIONS(595),
    [anon_sym_LT] = ACTIONS(585),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(587),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(353),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(103),
    [anon_sym_PLUS] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(355),
    [anon_sym_BANG] = ACTIONS(357),
    [anon_sym_TILDE] = ACTIONS(357),
    [anon_sym_typeof] = ACTIONS(355),
    [anon_sym_void] = ACTIONS(355),
    [anon_sym_delete] = ACTIONS(355),
    [anon_sym_PLUS_PLUS] = ACTIONS(359),
    [anon_sym_DASH_DASH] = ACTIONS(359),
    [anon_sym_DQUOTE] = ACTIONS(361),
    [anon_sym_SQUOTE] = ACTIONS(363),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(365),
    [sym_number] = ACTIONS(367),
    [sym_this] = ACTIONS(369),
    [sym_super] = ACTIONS(369),
    [sym_true] = ACTIONS(369),
    [sym_false] = ACTIONS(369),
    [sym_null] = ACTIONS(369),
    [sym_undefined] = ACTIONS(589),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(579),
    [anon_sym_get] = ACTIONS(579),
    [anon_sym_set] = ACTIONS(579),
  },
  [67] = {
    [sym_import] = STATE(575),
    [sym_parenthesized_expression] = STATE(449),
    [sym_expression] = STATE(675),
    [sym_primary_expression] = STATE(576),
    [sym_yield_expression] = STATE(577),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1112),
    [sym_assignment_pattern] = STATE(1191),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1112),
    [sym_jsx_element] = STATE(577),
    [sym_jsx_fragment] = STATE(577),
    [sym_jsx_opening_element] = STATE(975),
    [sym_jsx_self_closing_element] = STATE(577),
    [sym_class] = STATE(575),
    [sym_function] = STATE(575),
    [sym_generator_function] = STATE(575),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(577),
    [sym_await_expression] = STATE(577),
    [sym_member_expression] = STATE(468),
    [sym_subscript_expression] = STATE(468),
    [sym_assignment_expression] = STATE(577),
    [sym__augmented_assignment_lhs] = STATE(943),
    [sym_augmented_assignment_expression] = STATE(577),
    [sym__destructuring_pattern] = STATE(1112),
    [sym_spread_element] = STATE(1269),
    [sym_ternary_expression] = STATE(577),
    [sym_binary_expression] = STATE(577),
    [sym_unary_expression] = STATE(577),
    [sym_update_expression] = STATE(577),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1496),
    [sym_pattern] = STATE(1165),
    [sym_rest_pattern] = STATE(1083),
    [aux_sym_export_statement_repeat1] = STATE(1182),
    [aux_sym_array_repeat1] = STATE(1268),
    [aux_sym_array_pattern_repeat1] = STATE(1285),
    [sym_identifier] = ACTIONS(577),
    [anon_sym_export] = ACTIONS(579),
    [anon_sym_LBRACE] = ACTIONS(421),
    [anon_sym_COMMA] = ACTIONS(581),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(335),
    [anon_sym_yield] = ACTIONS(339),
    [anon_sym_LBRACK] = ACTIONS(427),
    [anon_sym_RBRACK] = ACTIONS(597),
    [anon_sym_LT] = ACTIONS(585),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(587),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(353),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(103),
    [anon_sym_PLUS] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(355),
    [anon_sym_BANG] = ACTIONS(357),
    [anon_sym_TILDE] = ACTIONS(357),
    [anon_sym_typeof] = ACTIONS(355),
    [anon_sym_void] = ACTIONS(355),
    [anon_sym_delete] = ACTIONS(355),
    [anon_sym_PLUS_PLUS] = ACTIONS(359),
    [anon_sym_DASH_DASH] = ACTIONS(359),
    [anon_sym_DQUOTE] = ACTIONS(361),
    [anon_sym_SQUOTE] = ACTIONS(363),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(365),
    [sym_number] = ACTIONS(367),
    [sym_this] = ACTIONS(369),
    [sym_super] = ACTIONS(369),
    [sym_true] = ACTIONS(369),
    [sym_false] = ACTIONS(369),
    [sym_null] = ACTIONS(369),
    [sym_undefined] = ACTIONS(589),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(579),
    [anon_sym_get] = ACTIONS(579),
    [anon_sym_set] = ACTIONS(579),
  },
  [68] = {
    [sym_import] = STATE(575),
    [sym_parenthesized_expression] = STATE(449),
    [sym_expression] = STATE(690),
    [sym_primary_expression] = STATE(576),
    [sym_yield_expression] = STATE(577),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1112),
    [sym_assignment_pattern] = STATE(1191),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1112),
    [sym_jsx_element] = STATE(577),
    [sym_jsx_fragment] = STATE(577),
    [sym_jsx_opening_element] = STATE(975),
    [sym_jsx_self_closing_element] = STATE(577),
    [sym_class] = STATE(575),
    [sym_function] = STATE(575),
    [sym_generator_function] = STATE(575),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(577),
    [sym_await_expression] = STATE(577),
    [sym_member_expression] = STATE(468),
    [sym_subscript_expression] = STATE(468),
    [sym_assignment_expression] = STATE(577),
    [sym__augmented_assignment_lhs] = STATE(943),
    [sym_augmented_assignment_expression] = STATE(577),
    [sym__destructuring_pattern] = STATE(1112),
    [sym_spread_element] = STATE(1292),
    [sym_ternary_expression] = STATE(577),
    [sym_binary_expression] = STATE(577),
    [sym_unary_expression] = STATE(577),
    [sym_update_expression] = STATE(577),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1496),
    [sym_pattern] = STATE(1165),
    [sym_rest_pattern] = STATE(1083),
    [aux_sym_export_statement_repeat1] = STATE(1182),
    [aux_sym_array_repeat1] = STATE(1288),
    [aux_sym_array_pattern_repeat1] = STATE(1285),
    [sym_identifier] = ACTIONS(577),
    [anon_sym_export] = ACTIONS(579),
    [anon_sym_LBRACE] = ACTIONS(421),
    [anon_sym_COMMA] = ACTIONS(581),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(335),
    [anon_sym_yield] = ACTIONS(339),
    [anon_sym_LBRACK] = ACTIONS(427),
    [anon_sym_RBRACK] = ACTIONS(599),
    [anon_sym_LT] = ACTIONS(585),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(587),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(353),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(103),
    [anon_sym_PLUS] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(355),
    [anon_sym_BANG] = ACTIONS(357),
    [anon_sym_TILDE] = ACTIONS(357),
    [anon_sym_typeof] = ACTIONS(355),
    [anon_sym_void] = ACTIONS(355),
    [anon_sym_delete] = ACTIONS(355),
    [anon_sym_PLUS_PLUS] = ACTIONS(359),
    [anon_sym_DASH_DASH] = ACTIONS(359),
    [anon_sym_DQUOTE] = ACTIONS(361),
    [anon_sym_SQUOTE] = ACTIONS(363),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(365),
    [sym_number] = ACTIONS(367),
    [sym_this] = ACTIONS(369),
    [sym_super] = ACTIONS(369),
    [sym_true] = ACTIONS(369),
    [sym_false] = ACTIONS(369),
    [sym_null] = ACTIONS(369),
    [sym_undefined] = ACTIONS(589),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(579),
    [anon_sym_get] = ACTIONS(579),
    [anon_sym_set] = ACTIONS(579),
  },
  [69] = {
    [sym_import] = STATE(575),
    [sym_parenthesized_expression] = STATE(449),
    [sym_expression] = STATE(726),
    [sym_primary_expression] = STATE(576),
    [sym_yield_expression] = STATE(577),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1112),
    [sym_assignment_pattern] = STATE(1191),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1112),
    [sym_jsx_element] = STATE(577),
    [sym_jsx_fragment] = STATE(577),
    [sym_jsx_opening_element] = STATE(975),
    [sym_jsx_self_closing_element] = STATE(577),
    [sym_class] = STATE(575),
    [sym_function] = STATE(575),
    [sym_generator_function] = STATE(575),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(577),
    [sym_await_expression] = STATE(577),
    [sym_member_expression] = STATE(468),
    [sym_subscript_expression] = STATE(468),
    [sym_assignment_expression] = STATE(577),
    [sym__augmented_assignment_lhs] = STATE(943),
    [sym_augmented_assignment_expression] = STATE(577),
    [sym__destructuring_pattern] = STATE(1112),
    [sym_spread_element] = STATE(1292),
    [sym_ternary_expression] = STATE(577),
    [sym_binary_expression] = STATE(577),
    [sym_unary_expression] = STATE(577),
    [sym_update_expression] = STATE(577),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1496),
    [sym_pattern] = STATE(1165),
    [sym_rest_pattern] = STATE(1083),
    [aux_sym_export_statement_repeat1] = STATE(1182),
    [aux_sym_array_repeat1] = STATE(1288),
    [aux_sym_array_pattern_repeat1] = STATE(1285),
    [sym_identifier] = ACTIONS(577),
    [anon_sym_export] = ACTIONS(579),
    [anon_sym_LBRACE] = ACTIONS(421),
    [anon_sym_COMMA] = ACTIONS(581),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(335),
    [anon_sym_yield] = ACTIONS(339),
    [anon_sym_LBRACK] = ACTIONS(427),
    [anon_sym_RBRACK] = ACTIONS(599),
    [anon_sym_LT] = ACTIONS(585),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(587),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(353),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(103),
    [anon_sym_PLUS] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(355),
    [anon_sym_BANG] = ACTIONS(357),
    [anon_sym_TILDE] = ACTIONS(357),
    [anon_sym_typeof] = ACTIONS(355),
    [anon_sym_void] = ACTIONS(355),
    [anon_sym_delete] = ACTIONS(355),
    [anon_sym_PLUS_PLUS] = ACTIONS(359),
    [anon_sym_DASH_DASH] = ACTIONS(359),
    [anon_sym_DQUOTE] = ACTIONS(361),
    [anon_sym_SQUOTE] = ACTIONS(363),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(365),
    [sym_number] = ACTIONS(367),
    [sym_this] = ACTIONS(369),
    [sym_super] = ACTIONS(369),
    [sym_true] = ACTIONS(369),
    [sym_false] = ACTIONS(369),
    [sym_null] = ACTIONS(369),
    [sym_undefined] = ACTIONS(589),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(579),
    [anon_sym_get] = ACTIONS(579),
    [anon_sym_set] = ACTIONS(579),
  },
  [70] = {
    [sym_declaration] = STATE(386),
    [sym_import] = STATE(721),
    [sym_variable_declaration] = STATE(415),
    [sym_lexical_declaration] = STATE(415),
    [sym_parenthesized_expression] = STATE(479),
    [sym_expression] = STATE(794),
    [sym_primary_expression] = STATE(743),
    [sym_yield_expression] = STATE(740),
    [sym_object] = STATE(721),
    [sym_object_pattern] = STATE(1548),
    [sym_array] = STATE(721),
    [sym_array_pattern] = STATE(1548),
    [sym_jsx_element] = STATE(740),
    [sym_jsx_fragment] = STATE(740),
    [sym_jsx_opening_element] = STATE(972),
    [sym_jsx_self_closing_element] = STATE(740),
    [sym_class] = STATE(721),
    [sym_class_declaration] = STATE(415),
    [sym_function] = STATE(721),
    [sym_function_declaration] = STATE(415),
    [sym_generator_function] = STATE(721),
    [sym_generator_function_declaration] = STATE(415),
    [sym_arrow_function] = STATE(721),
    [sym_call_expression] = STATE(721),
    [sym_new_expression] = STATE(740),
    [sym_await_expression] = STATE(740),
    [sym_member_expression] = STATE(479),
    [sym_subscript_expression] = STATE(479),
    [sym_assignment_expression] = STATE(740),
    [sym__augmented_assignment_lhs] = STATE(942),
    [sym_augmented_assignment_expression] = STATE(740),
    [sym__destructuring_pattern] = STATE(1548),
    [sym_ternary_expression] = STATE(740),
    [sym_binary_expression] = STATE(740),
    [sym_unary_expression] = STATE(740),
    [sym_update_expression] = STATE(740),
    [sym_string] = STATE(721),
    [sym_template_string] = STATE(721),
    [sym_regex] = STATE(721),
    [sym_meta_property] = STATE(721),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1546),
    [aux_sym_export_statement_repeat1] = STATE(1183),
    [sym_identifier] = ACTIONS(407),
    [anon_sym_export] = ACTIONS(409),
    [anon_sym_LBRACE] = ACTIONS(379),
    [anon_sym_import] = ACTIONS(381),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(313),
    [anon_sym_async] = ACTIONS(601),
    [anon_sym_function] = ACTIONS(317),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(67),
    [anon_sym_void] = ACTIONS(67),
    [anon_sym_delete] = ACTIONS(67),
    [anon_sym_PLUS_PLUS] = ACTIONS(71),
    [anon_sym_DASH_DASH] = ACTIONS(71),
    [anon_sym_DQUOTE] = ACTIONS(73),
    [anon_sym_SQUOTE] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(77),
    [sym_number] = ACTIONS(79),
    [sym_this] = ACTIONS(81),
    [sym_super] = ACTIONS(81),
    [sym_true] = ACTIONS(81),
    [sym_false] = ACTIONS(81),
    [sym_null] = ACTIONS(81),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(409),
    [anon_sym_get] = ACTIONS(409),
    [anon_sym_set] = ACTIONS(409),
  },
  [71] = {
    [sym_import] = STATE(721),
    [sym_expression_statement] = STATE(96),
    [sym_variable_declaration] = STATE(96),
    [sym_lexical_declaration] = STATE(96),
    [sym_empty_statement] = STATE(96),
    [sym_parenthesized_expression] = STATE(472),
    [sym_expression] = STATE(674),
    [sym_primary_expression] = STATE(743),
    [sym_yield_expression] = STATE(740),
    [sym_object] = STATE(721),
    [sym_object_pattern] = STATE(1217),
    [sym_array] = STATE(721),
    [sym_array_pattern] = STATE(1217),
    [sym_jsx_element] = STATE(740),
    [sym_jsx_fragment] = STATE(740),
    [sym_jsx_opening_element] = STATE(972),
    [sym_jsx_self_closing_element] = STATE(740),
    [sym_class] = STATE(721),
    [sym_function] = STATE(721),
    [sym_generator_function] = STATE(721),
    [sym_arrow_function] = STATE(721),
    [sym_call_expression] = STATE(721),
    [sym_new_expression] = STATE(740),
    [sym_await_expression] = STATE(740),
    [sym_member_expression] = STATE(472),
    [sym_subscript_expression] = STATE(472),
    [sym_assignment_expression] = STATE(740),
    [sym__augmented_assignment_lhs] = STATE(942),
    [sym_augmented_assignment_expression] = STATE(740),
    [sym__destructuring_pattern] = STATE(1217),
    [sym_ternary_expression] = STATE(740),
    [sym_binary_expression] = STATE(740),
    [sym_unary_expression] = STATE(740),
    [sym_update_expression] = STATE(740),
    [sym_sequence_expression] = STATE(1331),
    [sym_string] = STATE(721),
    [sym_template_string] = STATE(721),
    [sym_regex] = STATE(721),
    [sym_meta_property] = STATE(721),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1546),
    [aux_sym_export_statement_repeat1] = STATE(1154),
    [sym_identifier] = ACTIONS(603),
    [anon_sym_export] = ACTIONS(605),
    [anon_sym_LBRACE] = ACTIONS(607),
    [anon_sym_import] = ACTIONS(381),
    [anon_sym_var] = ACTIONS(609),
    [anon_sym_let] = ACTIONS(611),
    [anon_sym_const] = ACTIONS(611),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(613),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(391),
    [anon_sym_async] = ACTIONS(615),
    [anon_sym_function] = ACTIONS(395),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(67),
    [anon_sym_void] = ACTIONS(67),
    [anon_sym_delete] = ACTIONS(67),
    [anon_sym_PLUS_PLUS] = ACTIONS(71),
    [anon_sym_DASH_DASH] = ACTIONS(71),
    [anon_sym_DQUOTE] = ACTIONS(73),
    [anon_sym_SQUOTE] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(77),
    [sym_number] = ACTIONS(79),
    [sym_this] = ACTIONS(81),
    [sym_super] = ACTIONS(81),
    [sym_true] = ACTIONS(81),
    [sym_false] = ACTIONS(81),
    [sym_null] = ACTIONS(81),
    [sym_undefined] = ACTIONS(617),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(605),
    [anon_sym_get] = ACTIONS(605),
    [anon_sym_set] = ACTIONS(605),
  },
  [72] = {
    [sym_import] = STATE(575),
    [sym_parenthesized_expression] = STATE(449),
    [sym_expression] = STATE(675),
    [sym_primary_expression] = STATE(576),
    [sym_yield_expression] = STATE(577),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1112),
    [sym_assignment_pattern] = STATE(1191),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1112),
    [sym_jsx_element] = STATE(577),
    [sym_jsx_fragment] = STATE(577),
    [sym_jsx_opening_element] = STATE(975),
    [sym_jsx_self_closing_element] = STATE(577),
    [sym_class] = STATE(575),
    [sym_function] = STATE(575),
    [sym_generator_function] = STATE(575),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(577),
    [sym_await_expression] = STATE(577),
    [sym_member_expression] = STATE(468),
    [sym_subscript_expression] = STATE(468),
    [sym_assignment_expression] = STATE(577),
    [sym__augmented_assignment_lhs] = STATE(943),
    [sym_augmented_assignment_expression] = STATE(577),
    [sym__destructuring_pattern] = STATE(1112),
    [sym_spread_element] = STATE(1269),
    [sym_ternary_expression] = STATE(577),
    [sym_binary_expression] = STATE(577),
    [sym_unary_expression] = STATE(577),
    [sym_update_expression] = STATE(577),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1496),
    [sym_pattern] = STATE(1165),
    [sym_rest_pattern] = STATE(1083),
    [aux_sym_export_statement_repeat1] = STATE(1182),
    [aux_sym_array_repeat1] = STATE(1268),
    [aux_sym_array_pattern_repeat1] = STATE(1285),
    [sym_identifier] = ACTIONS(577),
    [anon_sym_export] = ACTIONS(579),
    [anon_sym_LBRACE] = ACTIONS(421),
    [anon_sym_COMMA] = ACTIONS(581),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(335),
    [anon_sym_yield] = ACTIONS(339),
    [anon_sym_LBRACK] = ACTIONS(427),
    [anon_sym_RBRACK] = ACTIONS(619),
    [anon_sym_LT] = ACTIONS(585),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(587),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(353),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(103),
    [anon_sym_PLUS] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(355),
    [anon_sym_BANG] = ACTIONS(357),
    [anon_sym_TILDE] = ACTIONS(357),
    [anon_sym_typeof] = ACTIONS(355),
    [anon_sym_void] = ACTIONS(355),
    [anon_sym_delete] = ACTIONS(355),
    [anon_sym_PLUS_PLUS] = ACTIONS(359),
    [anon_sym_DASH_DASH] = ACTIONS(359),
    [anon_sym_DQUOTE] = ACTIONS(361),
    [anon_sym_SQUOTE] = ACTIONS(363),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(365),
    [sym_number] = ACTIONS(367),
    [sym_this] = ACTIONS(369),
    [sym_super] = ACTIONS(369),
    [sym_true] = ACTIONS(369),
    [sym_false] = ACTIONS(369),
    [sym_null] = ACTIONS(369),
    [sym_undefined] = ACTIONS(589),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(579),
    [anon_sym_get] = ACTIONS(579),
    [anon_sym_set] = ACTIONS(579),
  },
  [73] = {
    [sym_import] = STATE(575),
    [sym_parenthesized_expression] = STATE(449),
    [sym_expression] = STATE(675),
    [sym_primary_expression] = STATE(576),
    [sym_yield_expression] = STATE(577),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1112),
    [sym_assignment_pattern] = STATE(1191),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1112),
    [sym_jsx_element] = STATE(577),
    [sym_jsx_fragment] = STATE(577),
    [sym_jsx_opening_element] = STATE(975),
    [sym_jsx_self_closing_element] = STATE(577),
    [sym_class] = STATE(575),
    [sym_function] = STATE(575),
    [sym_generator_function] = STATE(575),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(577),
    [sym_await_expression] = STATE(577),
    [sym_member_expression] = STATE(468),
    [sym_subscript_expression] = STATE(468),
    [sym_assignment_expression] = STATE(577),
    [sym__augmented_assignment_lhs] = STATE(943),
    [sym_augmented_assignment_expression] = STATE(577),
    [sym__destructuring_pattern] = STATE(1112),
    [sym_spread_element] = STATE(1269),
    [sym_ternary_expression] = STATE(577),
    [sym_binary_expression] = STATE(577),
    [sym_unary_expression] = STATE(577),
    [sym_update_expression] = STATE(577),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1496),
    [sym_pattern] = STATE(1165),
    [sym_rest_pattern] = STATE(1083),
    [aux_sym_export_statement_repeat1] = STATE(1182),
    [aux_sym_array_repeat1] = STATE(1268),
    [aux_sym_array_pattern_repeat1] = STATE(1285),
    [sym_identifier] = ACTIONS(577),
    [anon_sym_export] = ACTIONS(579),
    [anon_sym_LBRACE] = ACTIONS(421),
    [anon_sym_COMMA] = ACTIONS(581),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(335),
    [anon_sym_yield] = ACTIONS(339),
    [anon_sym_LBRACK] = ACTIONS(427),
    [anon_sym_RBRACK] = ACTIONS(621),
    [anon_sym_LT] = ACTIONS(585),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(587),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(353),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(103),
    [anon_sym_PLUS] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(355),
    [anon_sym_BANG] = ACTIONS(357),
    [anon_sym_TILDE] = ACTIONS(357),
    [anon_sym_typeof] = ACTIONS(355),
    [anon_sym_void] = ACTIONS(355),
    [anon_sym_delete] = ACTIONS(355),
    [anon_sym_PLUS_PLUS] = ACTIONS(359),
    [anon_sym_DASH_DASH] = ACTIONS(359),
    [anon_sym_DQUOTE] = ACTIONS(361),
    [anon_sym_SQUOTE] = ACTIONS(363),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(365),
    [sym_number] = ACTIONS(367),
    [sym_this] = ACTIONS(369),
    [sym_super] = ACTIONS(369),
    [sym_true] = ACTIONS(369),
    [sym_false] = ACTIONS(369),
    [sym_null] = ACTIONS(369),
    [sym_undefined] = ACTIONS(589),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(579),
    [anon_sym_get] = ACTIONS(579),
    [anon_sym_set] = ACTIONS(579),
  },
  [74] = {
    [sym_declaration] = STATE(423),
    [sym_import] = STATE(721),
    [sym_variable_declaration] = STATE(415),
    [sym_lexical_declaration] = STATE(415),
    [sym_parenthesized_expression] = STATE(479),
    [sym_expression] = STATE(776),
    [sym_primary_expression] = STATE(743),
    [sym_yield_expression] = STATE(740),
    [sym_object] = STATE(721),
    [sym_object_pattern] = STATE(1548),
    [sym_array] = STATE(721),
    [sym_array_pattern] = STATE(1548),
    [sym_jsx_element] = STATE(740),
    [sym_jsx_fragment] = STATE(740),
    [sym_jsx_opening_element] = STATE(972),
    [sym_jsx_self_closing_element] = STATE(740),
    [sym_class] = STATE(721),
    [sym_class_declaration] = STATE(415),
    [sym_function] = STATE(721),
    [sym_function_declaration] = STATE(415),
    [sym_generator_function] = STATE(721),
    [sym_generator_function_declaration] = STATE(415),
    [sym_arrow_function] = STATE(721),
    [sym_call_expression] = STATE(721),
    [sym_new_expression] = STATE(740),
    [sym_await_expression] = STATE(740),
    [sym_member_expression] = STATE(479),
    [sym_subscript_expression] = STATE(479),
    [sym_assignment_expression] = STATE(740),
    [sym__augmented_assignment_lhs] = STATE(942),
    [sym_augmented_assignment_expression] = STATE(740),
    [sym__destructuring_pattern] = STATE(1548),
    [sym_ternary_expression] = STATE(740),
    [sym_binary_expression] = STATE(740),
    [sym_unary_expression] = STATE(740),
    [sym_update_expression] = STATE(740),
    [sym_string] = STATE(721),
    [sym_template_string] = STATE(721),
    [sym_regex] = STATE(721),
    [sym_meta_property] = STATE(721),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1546),
    [aux_sym_export_statement_repeat1] = STATE(1183),
    [sym_identifier] = ACTIONS(407),
    [anon_sym_export] = ACTIONS(409),
    [anon_sym_LBRACE] = ACTIONS(379),
    [anon_sym_import] = ACTIONS(381),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(313),
    [anon_sym_async] = ACTIONS(601),
    [anon_sym_function] = ACTIONS(317),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(67),
    [anon_sym_void] = ACTIONS(67),
    [anon_sym_delete] = ACTIONS(67),
    [anon_sym_PLUS_PLUS] = ACTIONS(71),
    [anon_sym_DASH_DASH] = ACTIONS(71),
    [anon_sym_DQUOTE] = ACTIONS(73),
    [anon_sym_SQUOTE] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(77),
    [sym_number] = ACTIONS(79),
    [sym_this] = ACTIONS(81),
    [sym_super] = ACTIONS(81),
    [sym_true] = ACTIONS(81),
    [sym_false] = ACTIONS(81),
    [sym_null] = ACTIONS(81),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(409),
    [anon_sym_get] = ACTIONS(409),
    [anon_sym_set] = ACTIONS(409),
  },
  [75] = {
    [sym_import] = STATE(721),
    [sym_expression_statement] = STATE(94),
    [sym_variable_declaration] = STATE(94),
    [sym_lexical_declaration] = STATE(94),
    [sym_empty_statement] = STATE(94),
    [sym_parenthesized_expression] = STATE(472),
    [sym_expression] = STATE(674),
    [sym_primary_expression] = STATE(743),
    [sym_yield_expression] = STATE(740),
    [sym_object] = STATE(721),
    [sym_object_pattern] = STATE(1217),
    [sym_array] = STATE(721),
    [sym_array_pattern] = STATE(1217),
    [sym_jsx_element] = STATE(740),
    [sym_jsx_fragment] = STATE(740),
    [sym_jsx_opening_element] = STATE(972),
    [sym_jsx_self_closing_element] = STATE(740),
    [sym_class] = STATE(721),
    [sym_function] = STATE(721),
    [sym_generator_function] = STATE(721),
    [sym_arrow_function] = STATE(721),
    [sym_call_expression] = STATE(721),
    [sym_new_expression] = STATE(740),
    [sym_await_expression] = STATE(740),
    [sym_member_expression] = STATE(472),
    [sym_subscript_expression] = STATE(472),
    [sym_assignment_expression] = STATE(740),
    [sym__augmented_assignment_lhs] = STATE(942),
    [sym_augmented_assignment_expression] = STATE(740),
    [sym__destructuring_pattern] = STATE(1217),
    [sym_ternary_expression] = STATE(740),
    [sym_binary_expression] = STATE(740),
    [sym_unary_expression] = STATE(740),
    [sym_update_expression] = STATE(740),
    [sym_sequence_expression] = STATE(1331),
    [sym_string] = STATE(721),
    [sym_template_string] = STATE(721),
    [sym_regex] = STATE(721),
    [sym_meta_property] = STATE(721),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1546),
    [aux_sym_export_statement_repeat1] = STATE(1154),
    [sym_identifier] = ACTIONS(603),
    [anon_sym_export] = ACTIONS(605),
    [anon_sym_LBRACE] = ACTIONS(607),
    [anon_sym_import] = ACTIONS(381),
    [anon_sym_var] = ACTIONS(609),
    [anon_sym_let] = ACTIONS(611),
    [anon_sym_const] = ACTIONS(611),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(613),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(391),
    [anon_sym_async] = ACTIONS(615),
    [anon_sym_function] = ACTIONS(395),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(67),
    [anon_sym_void] = ACTIONS(67),
    [anon_sym_delete] = ACTIONS(67),
    [anon_sym_PLUS_PLUS] = ACTIONS(71),
    [anon_sym_DASH_DASH] = ACTIONS(71),
    [anon_sym_DQUOTE] = ACTIONS(73),
    [anon_sym_SQUOTE] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(77),
    [sym_number] = ACTIONS(79),
    [sym_this] = ACTIONS(81),
    [sym_super] = ACTIONS(81),
    [sym_true] = ACTIONS(81),
    [sym_false] = ACTIONS(81),
    [sym_null] = ACTIONS(81),
    [sym_undefined] = ACTIONS(617),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(605),
    [anon_sym_get] = ACTIONS(605),
    [anon_sym_set] = ACTIONS(605),
  },
  [76] = {
    [sym_import] = STATE(575),
    [sym_parenthesized_expression] = STATE(449),
    [sym_expression] = STATE(800),
    [sym_primary_expression] = STATE(576),
    [sym_yield_expression] = STATE(577),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1112),
    [sym_assignment_pattern] = STATE(1191),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1112),
    [sym_jsx_element] = STATE(577),
    [sym_jsx_fragment] = STATE(577),
    [sym_jsx_opening_element] = STATE(975),
    [sym_jsx_self_closing_element] = STATE(577),
    [sym_class] = STATE(575),
    [sym_function] = STATE(575),
    [sym_generator_function] = STATE(575),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(577),
    [sym_await_expression] = STATE(577),
    [sym_member_expression] = STATE(487),
    [sym_subscript_expression] = STATE(487),
    [sym_assignment_expression] = STATE(577),
    [sym__augmented_assignment_lhs] = STATE(943),
    [sym_augmented_assignment_expression] = STATE(577),
    [sym__destructuring_pattern] = STATE(1112),
    [sym_ternary_expression] = STATE(577),
    [sym_binary_expression] = STATE(577),
    [sym_unary_expression] = STATE(577),
    [sym_update_expression] = STATE(577),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1496),
    [sym_pattern] = STATE(1165),
    [sym_rest_pattern] = STATE(1083),
    [aux_sym_export_statement_repeat1] = STATE(1182),
    [aux_sym_array_pattern_repeat1] = STATE(1285),
    [sym_identifier] = ACTIONS(623),
    [anon_sym_export] = ACTIONS(625),
    [anon_sym_LBRACE] = ACTIONS(627),
    [anon_sym_COMMA] = ACTIONS(629),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(335),
    [anon_sym_yield] = ACTIONS(339),
    [anon_sym_LBRACK] = ACTIONS(631),
    [anon_sym_RBRACK] = ACTIONS(633),
    [anon_sym_LT] = ACTIONS(585),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(635),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(353),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(637),
    [anon_sym_PLUS] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(355),
    [anon_sym_BANG] = ACTIONS(357),
    [anon_sym_TILDE] = ACTIONS(357),
    [anon_sym_typeof] = ACTIONS(355),
    [anon_sym_void] = ACTIONS(355),
    [anon_sym_delete] = ACTIONS(355),
    [anon_sym_PLUS_PLUS] = ACTIONS(359),
    [anon_sym_DASH_DASH] = ACTIONS(359),
    [anon_sym_DQUOTE] = ACTIONS(361),
    [anon_sym_SQUOTE] = ACTIONS(363),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(365),
    [sym_number] = ACTIONS(367),
    [sym_this] = ACTIONS(369),
    [sym_super] = ACTIONS(369),
    [sym_true] = ACTIONS(369),
    [sym_false] = ACTIONS(369),
    [sym_null] = ACTIONS(369),
    [sym_undefined] = ACTIONS(639),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(625),
    [anon_sym_get] = ACTIONS(625),
    [anon_sym_set] = ACTIONS(625),
  },
  [77] = {
    [sym_import] = STATE(575),
    [sym_parenthesized_expression] = STATE(430),
    [sym_expression] = STATE(835),
    [sym_primary_expression] = STATE(576),
    [sym_yield_expression] = STATE(577),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1094),
    [sym_assignment_pattern] = STATE(1270),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1094),
    [sym_jsx_element] = STATE(577),
    [sym_jsx_fragment] = STATE(577),
    [sym_jsx_opening_element] = STATE(975),
    [sym_jsx_self_closing_element] = STATE(577),
    [sym_class] = STATE(575),
    [sym_function] = STATE(575),
    [sym_generator_function] = STATE(575),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(577),
    [sym_await_expression] = STATE(577),
    [sym_member_expression] = STATE(473),
    [sym_subscript_expression] = STATE(473),
    [sym_assignment_expression] = STATE(577),
    [sym__augmented_assignment_lhs] = STATE(937),
    [sym_augmented_assignment_expression] = STATE(577),
    [sym__destructuring_pattern] = STATE(1094),
    [sym_ternary_expression] = STATE(577),
    [sym_binary_expression] = STATE(577),
    [sym_unary_expression] = STATE(577),
    [sym_update_expression] = STATE(577),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1533),
    [sym_pattern] = STATE(1124),
    [sym_rest_pattern] = STATE(1083),
    [aux_sym_export_statement_repeat1] = STATE(1182),
    [aux_sym_array_pattern_repeat1] = STATE(1267),
    [sym_identifier] = ACTIONS(641),
    [anon_sym_export] = ACTIONS(643),
    [anon_sym_LBRACE] = ACTIONS(645),
    [anon_sym_COMMA] = ACTIONS(629),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(449),
    [anon_sym_yield] = ACTIONS(451),
    [anon_sym_LBRACK] = ACTIONS(647),
    [anon_sym_RBRACK] = ACTIONS(649),
    [anon_sym_LT] = ACTIONS(585),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(651),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(455),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(637),
    [anon_sym_PLUS] = ACTIONS(457),
    [anon_sym_DASH] = ACTIONS(457),
    [anon_sym_BANG] = ACTIONS(459),
    [anon_sym_TILDE] = ACTIONS(459),
    [anon_sym_typeof] = ACTIONS(457),
    [anon_sym_void] = ACTIONS(457),
    [anon_sym_delete] = ACTIONS(457),
    [anon_sym_PLUS_PLUS] = ACTIONS(461),
    [anon_sym_DASH_DASH] = ACTIONS(461),
    [anon_sym_DQUOTE] = ACTIONS(361),
    [anon_sym_SQUOTE] = ACTIONS(363),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(365),
    [sym_number] = ACTIONS(367),
    [sym_this] = ACTIONS(369),
    [sym_super] = ACTIONS(369),
    [sym_true] = ACTIONS(369),
    [sym_false] = ACTIONS(369),
    [sym_null] = ACTIONS(369),
    [sym_undefined] = ACTIONS(653),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(643),
    [anon_sym_get] = ACTIONS(643),
    [anon_sym_set] = ACTIONS(643),
  },
  [78] = {
    [sym_import] = STATE(575),
    [sym_parenthesized_expression] = STATE(449),
    [sym_expression] = STATE(678),
    [sym_primary_expression] = STATE(576),
    [sym_yield_expression] = STATE(577),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1112),
    [sym_assignment_pattern] = STATE(1358),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1112),
    [sym_jsx_element] = STATE(577),
    [sym_jsx_fragment] = STATE(577),
    [sym_jsx_opening_element] = STATE(975),
    [sym_jsx_self_closing_element] = STATE(577),
    [sym_class] = STATE(575),
    [sym_function] = STATE(575),
    [sym_generator_function] = STATE(575),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(577),
    [sym_await_expression] = STATE(577),
    [sym_member_expression] = STATE(468),
    [sym_subscript_expression] = STATE(468),
    [sym_assignment_expression] = STATE(577),
    [sym__augmented_assignment_lhs] = STATE(943),
    [sym_augmented_assignment_expression] = STATE(577),
    [sym__destructuring_pattern] = STATE(1112),
    [sym_spread_element] = STATE(1240),
    [sym_ternary_expression] = STATE(577),
    [sym_binary_expression] = STATE(577),
    [sym_unary_expression] = STATE(577),
    [sym_update_expression] = STATE(577),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1496),
    [sym_pattern] = STATE(1247),
    [sym_rest_pattern] = STATE(1083),
    [aux_sym_export_statement_repeat1] = STATE(1182),
    [sym_identifier] = ACTIONS(577),
    [anon_sym_export] = ACTIONS(579),
    [anon_sym_LBRACE] = ACTIONS(421),
    [anon_sym_COMMA] = ACTIONS(655),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(335),
    [anon_sym_yield] = ACTIONS(339),
    [anon_sym_LBRACK] = ACTIONS(427),
    [anon_sym_RBRACK] = ACTIONS(655),
    [anon_sym_LT] = ACTIONS(585),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(587),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(353),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(103),
    [anon_sym_PLUS] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(355),
    [anon_sym_BANG] = ACTIONS(357),
    [anon_sym_TILDE] = ACTIONS(357),
    [anon_sym_typeof] = ACTIONS(355),
    [anon_sym_void] = ACTIONS(355),
    [anon_sym_delete] = ACTIONS(355),
    [anon_sym_PLUS_PLUS] = ACTIONS(359),
    [anon_sym_DASH_DASH] = ACTIONS(359),
    [anon_sym_DQUOTE] = ACTIONS(361),
    [anon_sym_SQUOTE] = ACTIONS(363),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(365),
    [sym_number] = ACTIONS(367),
    [sym_this] = ACTIONS(369),
    [sym_super] = ACTIONS(369),
    [sym_true] = ACTIONS(369),
    [sym_false] = ACTIONS(369),
    [sym_null] = ACTIONS(369),
    [sym_undefined] = ACTIONS(589),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(579),
    [anon_sym_get] = ACTIONS(579),
    [anon_sym_set] = ACTIONS(579),
  },
  [79] = {
    [sym_import] = STATE(575),
    [sym_parenthesized_expression] = STATE(430),
    [sym_expression] = STATE(835),
    [sym_primary_expression] = STATE(576),
    [sym_yield_expression] = STATE(577),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1094),
    [sym_assignment_pattern] = STATE(1191),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1094),
    [sym_jsx_element] = STATE(577),
    [sym_jsx_fragment] = STATE(577),
    [sym_jsx_opening_element] = STATE(975),
    [sym_jsx_self_closing_element] = STATE(577),
    [sym_class] = STATE(575),
    [sym_function] = STATE(575),
    [sym_generator_function] = STATE(575),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(577),
    [sym_await_expression] = STATE(577),
    [sym_member_expression] = STATE(473),
    [sym_subscript_expression] = STATE(473),
    [sym_assignment_expression] = STATE(577),
    [sym__augmented_assignment_lhs] = STATE(937),
    [sym_augmented_assignment_expression] = STATE(577),
    [sym__destructuring_pattern] = STATE(1094),
    [sym_ternary_expression] = STATE(577),
    [sym_binary_expression] = STATE(577),
    [sym_unary_expression] = STATE(577),
    [sym_update_expression] = STATE(577),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1533),
    [sym_pattern] = STATE(1165),
    [sym_rest_pattern] = STATE(1083),
    [aux_sym_export_statement_repeat1] = STATE(1182),
    [aux_sym_array_pattern_repeat1] = STATE(1285),
    [sym_identifier] = ACTIONS(641),
    [anon_sym_export] = ACTIONS(643),
    [anon_sym_LBRACE] = ACTIONS(645),
    [anon_sym_COMMA] = ACTIONS(629),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(449),
    [anon_sym_yield] = ACTIONS(451),
    [anon_sym_LBRACK] = ACTIONS(647),
    [anon_sym_RBRACK] = ACTIONS(633),
    [anon_sym_LT] = ACTIONS(585),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(651),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(455),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(637),
    [anon_sym_PLUS] = ACTIONS(457),
    [anon_sym_DASH] = ACTIONS(457),
    [anon_sym_BANG] = ACTIONS(459),
    [anon_sym_TILDE] = ACTIONS(459),
    [anon_sym_typeof] = ACTIONS(457),
    [anon_sym_void] = ACTIONS(457),
    [anon_sym_delete] = ACTIONS(457),
    [anon_sym_PLUS_PLUS] = ACTIONS(461),
    [anon_sym_DASH_DASH] = ACTIONS(461),
    [anon_sym_DQUOTE] = ACTIONS(361),
    [anon_sym_SQUOTE] = ACTIONS(363),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(365),
    [sym_number] = ACTIONS(367),
    [sym_this] = ACTIONS(369),
    [sym_super] = ACTIONS(369),
    [sym_true] = ACTIONS(369),
    [sym_false] = ACTIONS(369),
    [sym_null] = ACTIONS(369),
    [sym_undefined] = ACTIONS(653),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(643),
    [anon_sym_get] = ACTIONS(643),
    [anon_sym_set] = ACTIONS(643),
  },
  [80] = {
    [sym_import] = STATE(575),
    [sym_parenthesized_expression] = STATE(430),
    [sym_expression] = STATE(835),
    [sym_primary_expression] = STATE(576),
    [sym_yield_expression] = STATE(577),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1094),
    [sym_assignment_pattern] = STATE(1358),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1094),
    [sym_jsx_element] = STATE(577),
    [sym_jsx_fragment] = STATE(577),
    [sym_jsx_opening_element] = STATE(975),
    [sym_jsx_self_closing_element] = STATE(577),
    [sym_class] = STATE(575),
    [sym_function] = STATE(575),
    [sym_generator_function] = STATE(575),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(577),
    [sym_await_expression] = STATE(577),
    [sym_member_expression] = STATE(473),
    [sym_subscript_expression] = STATE(473),
    [sym_assignment_expression] = STATE(577),
    [sym__augmented_assignment_lhs] = STATE(937),
    [sym_augmented_assignment_expression] = STATE(577),
    [sym__destructuring_pattern] = STATE(1094),
    [sym_ternary_expression] = STATE(577),
    [sym_binary_expression] = STATE(577),
    [sym_unary_expression] = STATE(577),
    [sym_update_expression] = STATE(577),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1533),
    [sym_pattern] = STATE(1247),
    [sym_rest_pattern] = STATE(1083),
    [aux_sym_export_statement_repeat1] = STATE(1182),
    [sym_identifier] = ACTIONS(641),
    [anon_sym_export] = ACTIONS(643),
    [anon_sym_LBRACE] = ACTIONS(645),
    [anon_sym_COMMA] = ACTIONS(658),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(449),
    [anon_sym_yield] = ACTIONS(451),
    [anon_sym_LBRACK] = ACTIONS(647),
    [anon_sym_RBRACK] = ACTIONS(658),
    [anon_sym_LT] = ACTIONS(585),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(651),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(455),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(637),
    [anon_sym_PLUS] = ACTIONS(457),
    [anon_sym_DASH] = ACTIONS(457),
    [anon_sym_BANG] = ACTIONS(459),
    [anon_sym_TILDE] = ACTIONS(459),
    [anon_sym_typeof] = ACTIONS(457),
    [anon_sym_void] = ACTIONS(457),
    [anon_sym_delete] = ACTIONS(457),
    [anon_sym_PLUS_PLUS] = ACTIONS(461),
    [anon_sym_DASH_DASH] = ACTIONS(461),
    [anon_sym_DQUOTE] = ACTIONS(361),
    [anon_sym_SQUOTE] = ACTIONS(363),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(365),
    [sym_number] = ACTIONS(367),
    [sym_this] = ACTIONS(369),
    [sym_super] = ACTIONS(369),
    [sym_true] = ACTIONS(369),
    [sym_false] = ACTIONS(369),
    [sym_null] = ACTIONS(369),
    [sym_undefined] = ACTIONS(653),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(643),
    [anon_sym_get] = ACTIONS(643),
    [anon_sym_set] = ACTIONS(643),
  },
  [81] = {
    [sym_import] = STATE(575),
    [sym_parenthesized_expression] = STATE(449),
    [sym_expression] = STATE(793),
    [sym_primary_expression] = STATE(576),
    [sym_yield_expression] = STATE(577),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1112),
    [sym_assignment_pattern] = STATE(1256),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1112),
    [sym_jsx_element] = STATE(577),
    [sym_jsx_fragment] = STATE(577),
    [sym_jsx_opening_element] = STATE(975),
    [sym_jsx_self_closing_element] = STATE(577),
    [sym_class] = STATE(575),
    [sym_function] = STATE(575),
    [sym_generator_function] = STATE(575),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(577),
    [sym_await_expression] = STATE(577),
    [sym_member_expression] = STATE(468),
    [sym_subscript_expression] = STATE(468),
    [sym_assignment_expression] = STATE(577),
    [sym__augmented_assignment_lhs] = STATE(943),
    [sym_augmented_assignment_expression] = STATE(577),
    [sym__destructuring_pattern] = STATE(1112),
    [sym_ternary_expression] = STATE(577),
    [sym_binary_expression] = STATE(577),
    [sym_unary_expression] = STATE(577),
    [sym_update_expression] = STATE(577),
    [sym_sequence_expression] = STATE(1514),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1496),
    [sym_pattern] = STATE(1127),
    [sym_rest_pattern] = STATE(1083),
    [aux_sym_export_statement_repeat1] = STATE(1182),
    [sym_identifier] = ACTIONS(577),
    [anon_sym_export] = ACTIONS(579),
    [anon_sym_LBRACE] = ACTIONS(421),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_RPAREN] = ACTIONS(660),
    [anon_sym_await] = ACTIONS(335),
    [anon_sym_yield] = ACTIONS(339),
    [anon_sym_LBRACK] = ACTIONS(427),
    [anon_sym_LT] = ACTIONS(585),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(587),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(353),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(637),
    [anon_sym_PLUS] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(355),
    [anon_sym_BANG] = ACTIONS(357),
    [anon_sym_TILDE] = ACTIONS(357),
    [anon_sym_typeof] = ACTIONS(355),
    [anon_sym_void] = ACTIONS(355),
    [anon_sym_delete] = ACTIONS(355),
    [anon_sym_PLUS_PLUS] = ACTIONS(359),
    [anon_sym_DASH_DASH] = ACTIONS(359),
    [anon_sym_DQUOTE] = ACTIONS(361),
    [anon_sym_SQUOTE] = ACTIONS(363),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(365),
    [sym_number] = ACTIONS(367),
    [sym_this] = ACTIONS(369),
    [sym_super] = ACTIONS(369),
    [sym_true] = ACTIONS(369),
    [sym_false] = ACTIONS(369),
    [sym_null] = ACTIONS(369),
    [sym_undefined] = ACTIONS(589),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(579),
    [anon_sym_get] = ACTIONS(579),
    [anon_sym_set] = ACTIONS(579),
  },
  [82] = {
    [sym_import] = STATE(575),
    [sym_parenthesized_expression] = STATE(449),
    [sym_expression] = STATE(775),
    [sym_primary_expression] = STATE(576),
    [sym_yield_expression] = STATE(577),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1112),
    [sym_assignment_pattern] = STATE(1256),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1112),
    [sym_jsx_element] = STATE(577),
    [sym_jsx_fragment] = STATE(577),
    [sym_jsx_opening_element] = STATE(975),
    [sym_jsx_self_closing_element] = STATE(577),
    [sym_class] = STATE(575),
    [sym_function] = STATE(575),
    [sym_generator_function] = STATE(575),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(577),
    [sym_await_expression] = STATE(577),
    [sym_member_expression] = STATE(468),
    [sym_subscript_expression] = STATE(468),
    [sym_assignment_expression] = STATE(577),
    [sym__augmented_assignment_lhs] = STATE(943),
    [sym_augmented_assignment_expression] = STATE(577),
    [sym__destructuring_pattern] = STATE(1112),
    [sym_ternary_expression] = STATE(577),
    [sym_binary_expression] = STATE(577),
    [sym_unary_expression] = STATE(577),
    [sym_update_expression] = STATE(577),
    [sym_sequence_expression] = STATE(1538),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1496),
    [sym_pattern] = STATE(1127),
    [sym_rest_pattern] = STATE(1083),
    [aux_sym_export_statement_repeat1] = STATE(1182),
    [sym_identifier] = ACTIONS(577),
    [anon_sym_export] = ACTIONS(579),
    [anon_sym_LBRACE] = ACTIONS(421),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_RPAREN] = ACTIONS(660),
    [anon_sym_await] = ACTIONS(335),
    [anon_sym_yield] = ACTIONS(339),
    [anon_sym_LBRACK] = ACTIONS(427),
    [anon_sym_LT] = ACTIONS(585),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(587),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(353),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(637),
    [anon_sym_PLUS] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(355),
    [anon_sym_BANG] = ACTIONS(357),
    [anon_sym_TILDE] = ACTIONS(357),
    [anon_sym_typeof] = ACTIONS(355),
    [anon_sym_void] = ACTIONS(355),
    [anon_sym_delete] = ACTIONS(355),
    [anon_sym_PLUS_PLUS] = ACTIONS(359),
    [anon_sym_DASH_DASH] = ACTIONS(359),
    [anon_sym_DQUOTE] = ACTIONS(361),
    [anon_sym_SQUOTE] = ACTIONS(363),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(365),
    [sym_number] = ACTIONS(367),
    [sym_this] = ACTIONS(369),
    [sym_super] = ACTIONS(369),
    [sym_true] = ACTIONS(369),
    [sym_false] = ACTIONS(369),
    [sym_null] = ACTIONS(369),
    [sym_undefined] = ACTIONS(589),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(579),
    [anon_sym_get] = ACTIONS(579),
    [anon_sym_set] = ACTIONS(579),
  },
  [83] = {
    [sym_import] = STATE(575),
    [sym_parenthesized_expression] = STATE(430),
    [sym_expression] = STATE(835),
    [sym_primary_expression] = STATE(576),
    [sym_yield_expression] = STATE(577),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1094),
    [sym_assignment_pattern] = STATE(1380),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1094),
    [sym_jsx_element] = STATE(577),
    [sym_jsx_fragment] = STATE(577),
    [sym_jsx_opening_element] = STATE(975),
    [sym_jsx_self_closing_element] = STATE(577),
    [sym_class] = STATE(575),
    [sym_function] = STATE(575),
    [sym_generator_function] = STATE(575),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(577),
    [sym_await_expression] = STATE(577),
    [sym_member_expression] = STATE(473),
    [sym_subscript_expression] = STATE(473),
    [sym_assignment_expression] = STATE(577),
    [sym__augmented_assignment_lhs] = STATE(937),
    [sym_augmented_assignment_expression] = STATE(577),
    [sym__destructuring_pattern] = STATE(1094),
    [sym_ternary_expression] = STATE(577),
    [sym_binary_expression] = STATE(577),
    [sym_unary_expression] = STATE(577),
    [sym_update_expression] = STATE(577),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1533),
    [sym_pattern] = STATE(1213),
    [sym_rest_pattern] = STATE(1083),
    [aux_sym_export_statement_repeat1] = STATE(1182),
    [sym_identifier] = ACTIONS(641),
    [anon_sym_export] = ACTIONS(643),
    [anon_sym_LBRACE] = ACTIONS(645),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_RPAREN] = ACTIONS(662),
    [anon_sym_await] = ACTIONS(449),
    [anon_sym_yield] = ACTIONS(451),
    [anon_sym_LBRACK] = ACTIONS(647),
    [anon_sym_LT] = ACTIONS(585),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(651),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(455),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(637),
    [anon_sym_PLUS] = ACTIONS(457),
    [anon_sym_DASH] = ACTIONS(457),
    [anon_sym_BANG] = ACTIONS(459),
    [anon_sym_TILDE] = ACTIONS(459),
    [anon_sym_typeof] = ACTIONS(457),
    [anon_sym_void] = ACTIONS(457),
    [anon_sym_delete] = ACTIONS(457),
    [anon_sym_PLUS_PLUS] = ACTIONS(461),
    [anon_sym_DASH_DASH] = ACTIONS(461),
    [anon_sym_DQUOTE] = ACTIONS(361),
    [anon_sym_SQUOTE] = ACTIONS(363),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(365),
    [sym_number] = ACTIONS(367),
    [sym_this] = ACTIONS(369),
    [sym_super] = ACTIONS(369),
    [sym_true] = ACTIONS(369),
    [sym_false] = ACTIONS(369),
    [sym_null] = ACTIONS(369),
    [sym_undefined] = ACTIONS(653),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(643),
    [anon_sym_get] = ACTIONS(643),
    [anon_sym_set] = ACTIONS(643),
  },
  [84] = {
    [sym_import] = STATE(575),
    [sym_parenthesized_expression] = STATE(449),
    [sym_expression] = STATE(663),
    [sym_primary_expression] = STATE(576),
    [sym_yield_expression] = STATE(577),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1528),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1528),
    [sym_jsx_element] = STATE(577),
    [sym_jsx_fragment] = STATE(577),
    [sym_jsx_opening_element] = STATE(975),
    [sym_jsx_self_closing_element] = STATE(577),
    [sym_class] = STATE(575),
    [sym_function] = STATE(575),
    [sym_generator_function] = STATE(575),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(577),
    [sym_await_expression] = STATE(577),
    [sym_member_expression] = STATE(449),
    [sym_subscript_expression] = STATE(449),
    [sym_assignment_expression] = STATE(577),
    [sym__augmented_assignment_lhs] = STATE(943),
    [sym_augmented_assignment_expression] = STATE(577),
    [sym__destructuring_pattern] = STATE(1528),
    [sym_spread_element] = STATE(1284),
    [sym_ternary_expression] = STATE(577),
    [sym_binary_expression] = STATE(577),
    [sym_unary_expression] = STATE(577),
    [sym_update_expression] = STATE(577),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1496),
    [aux_sym_export_statement_repeat1] = STATE(1182),
    [aux_sym_array_repeat1] = STATE(1283),
    [sym_identifier] = ACTIONS(321),
    [anon_sym_export] = ACTIONS(323),
    [anon_sym_LBRACE] = ACTIONS(327),
    [anon_sym_COMMA] = ACTIONS(664),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_RPAREN] = ACTIONS(666),
    [anon_sym_await] = ACTIONS(335),
    [anon_sym_yield] = ACTIONS(339),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LT] = ACTIONS(585),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(349),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(353),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(668),
    [anon_sym_PLUS] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(355),
    [anon_sym_BANG] = ACTIONS(357),
    [anon_sym_TILDE] = ACTIONS(357),
    [anon_sym_typeof] = ACTIONS(355),
    [anon_sym_void] = ACTIONS(355),
    [anon_sym_delete] = ACTIONS(355),
    [anon_sym_PLUS_PLUS] = ACTIONS(359),
    [anon_sym_DASH_DASH] = ACTIONS(359),
    [anon_sym_DQUOTE] = ACTIONS(361),
    [anon_sym_SQUOTE] = ACTIONS(363),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(365),
    [sym_number] = ACTIONS(367),
    [sym_this] = ACTIONS(369),
    [sym_super] = ACTIONS(369),
    [sym_true] = ACTIONS(369),
    [sym_false] = ACTIONS(369),
    [sym_null] = ACTIONS(369),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(323),
    [anon_sym_get] = ACTIONS(323),
    [anon_sym_set] = ACTIONS(323),
  },
  [85] = {
    [sym_import] = STATE(575),
    [sym_parenthesized_expression] = STATE(430),
    [sym_expression] = STATE(835),
    [sym_primary_expression] = STATE(576),
    [sym_yield_expression] = STATE(577),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1094),
    [sym_assignment_pattern] = STATE(1380),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1094),
    [sym_jsx_element] = STATE(577),
    [sym_jsx_fragment] = STATE(577),
    [sym_jsx_opening_element] = STATE(975),
    [sym_jsx_self_closing_element] = STATE(577),
    [sym_class] = STATE(575),
    [sym_function] = STATE(575),
    [sym_generator_function] = STATE(575),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(577),
    [sym_await_expression] = STATE(577),
    [sym_member_expression] = STATE(473),
    [sym_subscript_expression] = STATE(473),
    [sym_assignment_expression] = STATE(577),
    [sym__augmented_assignment_lhs] = STATE(937),
    [sym_augmented_assignment_expression] = STATE(577),
    [sym__destructuring_pattern] = STATE(1094),
    [sym_ternary_expression] = STATE(577),
    [sym_binary_expression] = STATE(577),
    [sym_unary_expression] = STATE(577),
    [sym_update_expression] = STATE(577),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1533),
    [sym_pattern] = STATE(1213),
    [sym_rest_pattern] = STATE(1083),
    [aux_sym_export_statement_repeat1] = STATE(1182),
    [sym_identifier] = ACTIONS(641),
    [anon_sym_export] = ACTIONS(643),
    [anon_sym_LBRACE] = ACTIONS(645),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_RPAREN] = ACTIONS(670),
    [anon_sym_await] = ACTIONS(449),
    [anon_sym_yield] = ACTIONS(451),
    [anon_sym_LBRACK] = ACTIONS(647),
    [anon_sym_LT] = ACTIONS(585),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(651),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(455),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(637),
    [anon_sym_PLUS] = ACTIONS(457),
    [anon_sym_DASH] = ACTIONS(457),
    [anon_sym_BANG] = ACTIONS(459),
    [anon_sym_TILDE] = ACTIONS(459),
    [anon_sym_typeof] = ACTIONS(457),
    [anon_sym_void] = ACTIONS(457),
    [anon_sym_delete] = ACTIONS(457),
    [anon_sym_PLUS_PLUS] = ACTIONS(461),
    [anon_sym_DASH_DASH] = ACTIONS(461),
    [anon_sym_DQUOTE] = ACTIONS(361),
    [anon_sym_SQUOTE] = ACTIONS(363),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(365),
    [sym_number] = ACTIONS(367),
    [sym_this] = ACTIONS(369),
    [sym_super] = ACTIONS(369),
    [sym_true] = ACTIONS(369),
    [sym_false] = ACTIONS(369),
    [sym_null] = ACTIONS(369),
    [sym_undefined] = ACTIONS(653),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(643),
    [anon_sym_get] = ACTIONS(643),
    [anon_sym_set] = ACTIONS(643),
  },
  [86] = {
    [sym_import] = STATE(575),
    [sym_parenthesized_expression] = STATE(449),
    [sym_expression] = STATE(713),
    [sym_primary_expression] = STATE(576),
    [sym_yield_expression] = STATE(577),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1528),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1528),
    [sym_jsx_element] = STATE(577),
    [sym_jsx_fragment] = STATE(577),
    [sym_jsx_opening_element] = STATE(975),
    [sym_jsx_self_closing_element] = STATE(577),
    [sym_class] = STATE(575),
    [sym_function] = STATE(575),
    [sym_generator_function] = STATE(575),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(577),
    [sym_await_expression] = STATE(577),
    [sym_member_expression] = STATE(449),
    [sym_subscript_expression] = STATE(449),
    [sym_assignment_expression] = STATE(577),
    [sym__augmented_assignment_lhs] = STATE(943),
    [sym_augmented_assignment_expression] = STATE(577),
    [sym__destructuring_pattern] = STATE(1528),
    [sym_spread_element] = STATE(1226),
    [sym_ternary_expression] = STATE(577),
    [sym_binary_expression] = STATE(577),
    [sym_unary_expression] = STATE(577),
    [sym_update_expression] = STATE(577),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1496),
    [aux_sym_export_statement_repeat1] = STATE(1182),
    [aux_sym_array_repeat1] = STATE(1225),
    [sym_identifier] = ACTIONS(321),
    [anon_sym_export] = ACTIONS(323),
    [anon_sym_LBRACE] = ACTIONS(327),
    [anon_sym_COMMA] = ACTIONS(664),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_RPAREN] = ACTIONS(672),
    [anon_sym_await] = ACTIONS(335),
    [anon_sym_yield] = ACTIONS(339),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LT] = ACTIONS(585),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(349),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(353),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(668),
    [anon_sym_PLUS] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(355),
    [anon_sym_BANG] = ACTIONS(357),
    [anon_sym_TILDE] = ACTIONS(357),
    [anon_sym_typeof] = ACTIONS(355),
    [anon_sym_void] = ACTIONS(355),
    [anon_sym_delete] = ACTIONS(355),
    [anon_sym_PLUS_PLUS] = ACTIONS(359),
    [anon_sym_DASH_DASH] = ACTIONS(359),
    [anon_sym_DQUOTE] = ACTIONS(361),
    [anon_sym_SQUOTE] = ACTIONS(363),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(365),
    [sym_number] = ACTIONS(367),
    [sym_this] = ACTIONS(369),
    [sym_super] = ACTIONS(369),
    [sym_true] = ACTIONS(369),
    [sym_false] = ACTIONS(369),
    [sym_null] = ACTIONS(369),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(323),
    [anon_sym_get] = ACTIONS(323),
    [anon_sym_set] = ACTIONS(323),
  },
  [87] = {
    [sym_import] = STATE(575),
    [sym_parenthesized_expression] = STATE(449),
    [sym_expression] = STATE(678),
    [sym_primary_expression] = STATE(576),
    [sym_yield_expression] = STATE(577),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1528),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1528),
    [sym_jsx_element] = STATE(577),
    [sym_jsx_fragment] = STATE(577),
    [sym_jsx_opening_element] = STATE(975),
    [sym_jsx_self_closing_element] = STATE(577),
    [sym_class] = STATE(575),
    [sym_function] = STATE(575),
    [sym_generator_function] = STATE(575),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(577),
    [sym_await_expression] = STATE(577),
    [sym_member_expression] = STATE(449),
    [sym_subscript_expression] = STATE(449),
    [sym_assignment_expression] = STATE(577),
    [sym__augmented_assignment_lhs] = STATE(943),
    [sym_augmented_assignment_expression] = STATE(577),
    [sym__destructuring_pattern] = STATE(1528),
    [sym_spread_element] = STATE(1240),
    [sym_ternary_expression] = STATE(577),
    [sym_binary_expression] = STATE(577),
    [sym_unary_expression] = STATE(577),
    [sym_update_expression] = STATE(577),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1496),
    [aux_sym_export_statement_repeat1] = STATE(1182),
    [sym_identifier] = ACTIONS(321),
    [anon_sym_export] = ACTIONS(323),
    [anon_sym_LBRACE] = ACTIONS(327),
    [anon_sym_COMMA] = ACTIONS(674),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_RPAREN] = ACTIONS(674),
    [anon_sym_await] = ACTIONS(335),
    [anon_sym_yield] = ACTIONS(339),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_RBRACK] = ACTIONS(674),
    [anon_sym_LT] = ACTIONS(585),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(349),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(353),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(668),
    [anon_sym_PLUS] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(355),
    [anon_sym_BANG] = ACTIONS(357),
    [anon_sym_TILDE] = ACTIONS(357),
    [anon_sym_typeof] = ACTIONS(355),
    [anon_sym_void] = ACTIONS(355),
    [anon_sym_delete] = ACTIONS(355),
    [anon_sym_PLUS_PLUS] = ACTIONS(359),
    [anon_sym_DASH_DASH] = ACTIONS(359),
    [anon_sym_DQUOTE] = ACTIONS(361),
    [anon_sym_SQUOTE] = ACTIONS(363),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(365),
    [sym_number] = ACTIONS(367),
    [sym_this] = ACTIONS(369),
    [sym_super] = ACTIONS(369),
    [sym_true] = ACTIONS(369),
    [sym_false] = ACTIONS(369),
    [sym_null] = ACTIONS(369),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(323),
    [anon_sym_get] = ACTIONS(323),
    [anon_sym_set] = ACTIONS(323),
  },
  [88] = {
    [sym_import] = STATE(575),
    [sym_parenthesized_expression] = STATE(449),
    [sym_expression] = STATE(667),
    [sym_primary_expression] = STATE(576),
    [sym_yield_expression] = STATE(577),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1528),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1528),
    [sym_jsx_element] = STATE(577),
    [sym_jsx_fragment] = STATE(577),
    [sym_jsx_opening_element] = STATE(975),
    [sym_jsx_self_closing_element] = STATE(577),
    [sym_class] = STATE(575),
    [sym_function] = STATE(575),
    [sym_generator_function] = STATE(575),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(577),
    [sym_await_expression] = STATE(577),
    [sym_member_expression] = STATE(449),
    [sym_subscript_expression] = STATE(449),
    [sym_assignment_expression] = STATE(577),
    [sym__augmented_assignment_lhs] = STATE(943),
    [sym_augmented_assignment_expression] = STATE(577),
    [sym__destructuring_pattern] = STATE(1528),
    [sym_spread_element] = STATE(1286),
    [sym_ternary_expression] = STATE(577),
    [sym_binary_expression] = STATE(577),
    [sym_unary_expression] = STATE(577),
    [sym_update_expression] = STATE(577),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1496),
    [aux_sym_export_statement_repeat1] = STATE(1182),
    [aux_sym_array_repeat1] = STATE(1287),
    [sym_identifier] = ACTIONS(321),
    [anon_sym_export] = ACTIONS(323),
    [anon_sym_LBRACE] = ACTIONS(327),
    [anon_sym_COMMA] = ACTIONS(664),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_RPAREN] = ACTIONS(676),
    [anon_sym_await] = ACTIONS(335),
    [anon_sym_yield] = ACTIONS(339),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LT] = ACTIONS(585),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(349),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(353),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(668),
    [anon_sym_PLUS] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(355),
    [anon_sym_BANG] = ACTIONS(357),
    [anon_sym_TILDE] = ACTIONS(357),
    [anon_sym_typeof] = ACTIONS(355),
    [anon_sym_void] = ACTIONS(355),
    [anon_sym_delete] = ACTIONS(355),
    [anon_sym_PLUS_PLUS] = ACTIONS(359),
    [anon_sym_DASH_DASH] = ACTIONS(359),
    [anon_sym_DQUOTE] = ACTIONS(361),
    [anon_sym_SQUOTE] = ACTIONS(363),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(365),
    [sym_number] = ACTIONS(367),
    [sym_this] = ACTIONS(369),
    [sym_super] = ACTIONS(369),
    [sym_true] = ACTIONS(369),
    [sym_false] = ACTIONS(369),
    [sym_null] = ACTIONS(369),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(323),
    [anon_sym_get] = ACTIONS(323),
    [anon_sym_set] = ACTIONS(323),
  },
  [89] = {
    [sym_import] = STATE(575),
    [sym_parenthesized_expression] = STATE(430),
    [sym_expression] = STATE(835),
    [sym_primary_expression] = STATE(576),
    [sym_yield_expression] = STATE(577),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1094),
    [sym_assignment_pattern] = STATE(1256),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1094),
    [sym_jsx_element] = STATE(577),
    [sym_jsx_fragment] = STATE(577),
    [sym_jsx_opening_element] = STATE(975),
    [sym_jsx_self_closing_element] = STATE(577),
    [sym_class] = STATE(575),
    [sym_function] = STATE(575),
    [sym_generator_function] = STATE(575),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(577),
    [sym_await_expression] = STATE(577),
    [sym_member_expression] = STATE(473),
    [sym_subscript_expression] = STATE(473),
    [sym_assignment_expression] = STATE(577),
    [sym__augmented_assignment_lhs] = STATE(937),
    [sym_augmented_assignment_expression] = STATE(577),
    [sym__destructuring_pattern] = STATE(1094),
    [sym_ternary_expression] = STATE(577),
    [sym_binary_expression] = STATE(577),
    [sym_unary_expression] = STATE(577),
    [sym_update_expression] = STATE(577),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1533),
    [sym_pattern] = STATE(1127),
    [sym_rest_pattern] = STATE(1083),
    [aux_sym_export_statement_repeat1] = STATE(1182),
    [sym_identifier] = ACTIONS(641),
    [anon_sym_export] = ACTIONS(643),
    [anon_sym_LBRACE] = ACTIONS(645),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_RPAREN] = ACTIONS(660),
    [anon_sym_await] = ACTIONS(449),
    [anon_sym_yield] = ACTIONS(451),
    [anon_sym_LBRACK] = ACTIONS(647),
    [anon_sym_LT] = ACTIONS(585),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(651),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(455),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(637),
    [anon_sym_PLUS] = ACTIONS(457),
    [anon_sym_DASH] = ACTIONS(457),
    [anon_sym_BANG] = ACTIONS(459),
    [anon_sym_TILDE] = ACTIONS(459),
    [anon_sym_typeof] = ACTIONS(457),
    [anon_sym_void] = ACTIONS(457),
    [anon_sym_delete] = ACTIONS(457),
    [anon_sym_PLUS_PLUS] = ACTIONS(461),
    [anon_sym_DASH_DASH] = ACTIONS(461),
    [anon_sym_DQUOTE] = ACTIONS(361),
    [anon_sym_SQUOTE] = ACTIONS(363),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(365),
    [sym_number] = ACTIONS(367),
    [sym_this] = ACTIONS(369),
    [sym_super] = ACTIONS(369),
    [sym_true] = ACTIONS(369),
    [sym_false] = ACTIONS(369),
    [sym_null] = ACTIONS(369),
    [sym_undefined] = ACTIONS(653),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(643),
    [anon_sym_get] = ACTIONS(643),
    [anon_sym_set] = ACTIONS(643),
  },
  [90] = {
    [sym_import] = STATE(575),
    [sym_parenthesized_expression] = STATE(449),
    [sym_expression] = STATE(747),
    [sym_primary_expression] = STATE(576),
    [sym_yield_expression] = STATE(577),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1528),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1528),
    [sym_jsx_element] = STATE(577),
    [sym_jsx_fragment] = STATE(577),
    [sym_jsx_opening_element] = STATE(975),
    [sym_jsx_self_closing_element] = STATE(577),
    [sym_class] = STATE(575),
    [sym_function] = STATE(575),
    [sym_generator_function] = STATE(575),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(577),
    [sym_await_expression] = STATE(577),
    [sym_member_expression] = STATE(449),
    [sym_subscript_expression] = STATE(449),
    [sym_assignment_expression] = STATE(577),
    [sym__augmented_assignment_lhs] = STATE(943),
    [sym_augmented_assignment_expression] = STATE(577),
    [sym__destructuring_pattern] = STATE(1528),
    [sym_spread_element] = STATE(1547),
    [sym_ternary_expression] = STATE(577),
    [sym_binary_expression] = STATE(577),
    [sym_unary_expression] = STATE(577),
    [sym_update_expression] = STATE(577),
    [sym_sequence_expression] = STATE(1547),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1496),
    [aux_sym_export_statement_repeat1] = STATE(1182),
    [sym_identifier] = ACTIONS(321),
    [anon_sym_export] = ACTIONS(323),
    [anon_sym_LBRACE] = ACTIONS(327),
    [anon_sym_RBRACE] = ACTIONS(678),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(335),
    [anon_sym_yield] = ACTIONS(339),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LT] = ACTIONS(585),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(349),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(353),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(668),
    [anon_sym_PLUS] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(355),
    [anon_sym_BANG] = ACTIONS(357),
    [anon_sym_TILDE] = ACTIONS(357),
    [anon_sym_typeof] = ACTIONS(355),
    [anon_sym_void] = ACTIONS(355),
    [anon_sym_delete] = ACTIONS(355),
    [anon_sym_PLUS_PLUS] = ACTIONS(359),
    [anon_sym_DASH_DASH] = ACTIONS(359),
    [anon_sym_DQUOTE] = ACTIONS(361),
    [anon_sym_SQUOTE] = ACTIONS(363),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(365),
    [sym_number] = ACTIONS(367),
    [sym_this] = ACTIONS(369),
    [sym_super] = ACTIONS(369),
    [sym_true] = ACTIONS(369),
    [sym_false] = ACTIONS(369),
    [sym_null] = ACTIONS(369),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(323),
    [anon_sym_get] = ACTIONS(323),
    [anon_sym_set] = ACTIONS(323),
  },
  [91] = {
    [sym_import] = STATE(575),
    [sym_parenthesized_expression] = STATE(430),
    [sym_expression] = STATE(835),
    [sym_primary_expression] = STATE(576),
    [sym_yield_expression] = STATE(577),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1094),
    [sym_assignment_pattern] = STATE(1387),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1094),
    [sym_jsx_element] = STATE(577),
    [sym_jsx_fragment] = STATE(577),
    [sym_jsx_opening_element] = STATE(975),
    [sym_jsx_self_closing_element] = STATE(577),
    [sym_class] = STATE(575),
    [sym_function] = STATE(575),
    [sym_generator_function] = STATE(575),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(577),
    [sym_await_expression] = STATE(577),
    [sym_member_expression] = STATE(473),
    [sym_subscript_expression] = STATE(473),
    [sym_assignment_expression] = STATE(577),
    [sym__augmented_assignment_lhs] = STATE(937),
    [sym_augmented_assignment_expression] = STATE(577),
    [sym__destructuring_pattern] = STATE(1094),
    [sym_ternary_expression] = STATE(577),
    [sym_binary_expression] = STATE(577),
    [sym_unary_expression] = STATE(577),
    [sym_update_expression] = STATE(577),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1533),
    [sym_pattern] = STATE(1241),
    [sym_rest_pattern] = STATE(1083),
    [aux_sym_export_statement_repeat1] = STATE(1182),
    [sym_identifier] = ACTIONS(641),
    [anon_sym_export] = ACTIONS(643),
    [anon_sym_LBRACE] = ACTIONS(645),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(449),
    [anon_sym_yield] = ACTIONS(451),
    [anon_sym_LBRACK] = ACTIONS(647),
    [anon_sym_LT] = ACTIONS(585),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(651),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(455),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(637),
    [anon_sym_PLUS] = ACTIONS(457),
    [anon_sym_DASH] = ACTIONS(457),
    [anon_sym_BANG] = ACTIONS(459),
    [anon_sym_TILDE] = ACTIONS(459),
    [anon_sym_typeof] = ACTIONS(457),
    [anon_sym_void] = ACTIONS(457),
    [anon_sym_delete] = ACTIONS(457),
    [anon_sym_PLUS_PLUS] = ACTIONS(461),
    [anon_sym_DASH_DASH] = ACTIONS(461),
    [anon_sym_DQUOTE] = ACTIONS(361),
    [anon_sym_SQUOTE] = ACTIONS(363),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(365),
    [sym_number] = ACTIONS(367),
    [sym_this] = ACTIONS(369),
    [sym_super] = ACTIONS(369),
    [sym_true] = ACTIONS(369),
    [sym_false] = ACTIONS(369),
    [sym_null] = ACTIONS(369),
    [sym_undefined] = ACTIONS(653),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(643),
    [anon_sym_get] = ACTIONS(643),
    [anon_sym_set] = ACTIONS(643),
  },
  [92] = {
    [sym_import] = STATE(575),
    [sym_parenthesized_expression] = STATE(449),
    [sym_expression] = STATE(778),
    [sym_primary_expression] = STATE(576),
    [sym_yield_expression] = STATE(577),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1528),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1528),
    [sym_jsx_element] = STATE(577),
    [sym_jsx_fragment] = STATE(577),
    [sym_jsx_opening_element] = STATE(975),
    [sym_jsx_self_closing_element] = STATE(577),
    [sym_class] = STATE(575),
    [sym_function] = STATE(575),
    [sym_generator_function] = STATE(575),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(577),
    [sym_await_expression] = STATE(577),
    [sym_member_expression] = STATE(449),
    [sym_subscript_expression] = STATE(449),
    [sym_assignment_expression] = STATE(577),
    [sym__augmented_assignment_lhs] = STATE(943),
    [sym_augmented_assignment_expression] = STATE(577),
    [sym__destructuring_pattern] = STATE(1528),
    [sym_spread_element] = STATE(1488),
    [sym_ternary_expression] = STATE(577),
    [sym_binary_expression] = STATE(577),
    [sym_unary_expression] = STATE(577),
    [sym_update_expression] = STATE(577),
    [sym_sequence_expression] = STATE(1488),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1496),
    [aux_sym_export_statement_repeat1] = STATE(1182),
    [sym_identifier] = ACTIONS(321),
    [anon_sym_export] = ACTIONS(323),
    [anon_sym_LBRACE] = ACTIONS(327),
    [anon_sym_RBRACE] = ACTIONS(680),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(335),
    [anon_sym_yield] = ACTIONS(339),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LT] = ACTIONS(585),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(349),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(353),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(668),
    [anon_sym_PLUS] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(355),
    [anon_sym_BANG] = ACTIONS(357),
    [anon_sym_TILDE] = ACTIONS(357),
    [anon_sym_typeof] = ACTIONS(355),
    [anon_sym_void] = ACTIONS(355),
    [anon_sym_delete] = ACTIONS(355),
    [anon_sym_PLUS_PLUS] = ACTIONS(359),
    [anon_sym_DASH_DASH] = ACTIONS(359),
    [anon_sym_DQUOTE] = ACTIONS(361),
    [anon_sym_SQUOTE] = ACTIONS(363),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(365),
    [sym_number] = ACTIONS(367),
    [sym_this] = ACTIONS(369),
    [sym_super] = ACTIONS(369),
    [sym_true] = ACTIONS(369),
    [sym_false] = ACTIONS(369),
    [sym_null] = ACTIONS(369),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(323),
    [anon_sym_get] = ACTIONS(323),
    [anon_sym_set] = ACTIONS(323),
  },
  [93] = {
    [sym_import] = STATE(575),
    [sym_parenthesized_expression] = STATE(430),
    [sym_expression] = STATE(835),
    [sym_primary_expression] = STATE(576),
    [sym_yield_expression] = STATE(577),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1094),
    [sym_assignment_pattern] = STATE(1380),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1094),
    [sym_jsx_element] = STATE(577),
    [sym_jsx_fragment] = STATE(577),
    [sym_jsx_opening_element] = STATE(975),
    [sym_jsx_self_closing_element] = STATE(577),
    [sym_class] = STATE(575),
    [sym_function] = STATE(575),
    [sym_generator_function] = STATE(575),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(577),
    [sym_await_expression] = STATE(577),
    [sym_member_expression] = STATE(473),
    [sym_subscript_expression] = STATE(473),
    [sym_assignment_expression] = STATE(577),
    [sym__augmented_assignment_lhs] = STATE(937),
    [sym_augmented_assignment_expression] = STATE(577),
    [sym__destructuring_pattern] = STATE(1094),
    [sym_ternary_expression] = STATE(577),
    [sym_binary_expression] = STATE(577),
    [sym_unary_expression] = STATE(577),
    [sym_update_expression] = STATE(577),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1533),
    [sym_pattern] = STATE(1213),
    [sym_rest_pattern] = STATE(1083),
    [aux_sym_export_statement_repeat1] = STATE(1182),
    [sym_identifier] = ACTIONS(641),
    [anon_sym_export] = ACTIONS(643),
    [anon_sym_LBRACE] = ACTIONS(645),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(449),
    [anon_sym_yield] = ACTIONS(451),
    [anon_sym_LBRACK] = ACTIONS(647),
    [anon_sym_LT] = ACTIONS(585),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(651),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(455),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(637),
    [anon_sym_PLUS] = ACTIONS(457),
    [anon_sym_DASH] = ACTIONS(457),
    [anon_sym_BANG] = ACTIONS(459),
    [anon_sym_TILDE] = ACTIONS(459),
    [anon_sym_typeof] = ACTIONS(457),
    [anon_sym_void] = ACTIONS(457),
    [anon_sym_delete] = ACTIONS(457),
    [anon_sym_PLUS_PLUS] = ACTIONS(461),
    [anon_sym_DASH_DASH] = ACTIONS(461),
    [anon_sym_DQUOTE] = ACTIONS(361),
    [anon_sym_SQUOTE] = ACTIONS(363),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(365),
    [sym_number] = ACTIONS(367),
    [sym_this] = ACTIONS(369),
    [sym_super] = ACTIONS(369),
    [sym_true] = ACTIONS(369),
    [sym_false] = ACTIONS(369),
    [sym_null] = ACTIONS(369),
    [sym_undefined] = ACTIONS(653),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(643),
    [anon_sym_get] = ACTIONS(643),
    [anon_sym_set] = ACTIONS(643),
  },
  [94] = {
    [sym_import] = STATE(721),
    [sym_expression_statement] = STATE(100),
    [sym_empty_statement] = STATE(100),
    [sym_parenthesized_expression] = STATE(479),
    [sym_expression] = STATE(674),
    [sym_primary_expression] = STATE(743),
    [sym_yield_expression] = STATE(740),
    [sym_object] = STATE(721),
    [sym_object_pattern] = STATE(1548),
    [sym_array] = STATE(721),
    [sym_array_pattern] = STATE(1548),
    [sym_jsx_element] = STATE(740),
    [sym_jsx_fragment] = STATE(740),
    [sym_jsx_opening_element] = STATE(972),
    [sym_jsx_self_closing_element] = STATE(740),
    [sym_class] = STATE(721),
    [sym_function] = STATE(721),
    [sym_generator_function] = STATE(721),
    [sym_arrow_function] = STATE(721),
    [sym_call_expression] = STATE(721),
    [sym_new_expression] = STATE(740),
    [sym_await_expression] = STATE(740),
    [sym_member_expression] = STATE(479),
    [sym_subscript_expression] = STATE(479),
    [sym_assignment_expression] = STATE(740),
    [sym__augmented_assignment_lhs] = STATE(942),
    [sym_augmented_assignment_expression] = STATE(740),
    [sym__destructuring_pattern] = STATE(1548),
    [sym_ternary_expression] = STATE(740),
    [sym_binary_expression] = STATE(740),
    [sym_unary_expression] = STATE(740),
    [sym_update_expression] = STATE(740),
    [sym_sequence_expression] = STATE(1331),
    [sym_string] = STATE(721),
    [sym_template_string] = STATE(721),
    [sym_regex] = STATE(721),
    [sym_meta_property] = STATE(721),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1546),
    [aux_sym_export_statement_repeat1] = STATE(1154),
    [sym_identifier] = ACTIONS(407),
    [anon_sym_export] = ACTIONS(409),
    [anon_sym_LBRACE] = ACTIONS(379),
    [anon_sym_import] = ACTIONS(381),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(391),
    [anon_sym_async] = ACTIONS(413),
    [anon_sym_function] = ACTIONS(395),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(67),
    [anon_sym_void] = ACTIONS(67),
    [anon_sym_delete] = ACTIONS(67),
    [anon_sym_PLUS_PLUS] = ACTIONS(71),
    [anon_sym_DASH_DASH] = ACTIONS(71),
    [anon_sym_DQUOTE] = ACTIONS(73),
    [anon_sym_SQUOTE] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(77),
    [sym_number] = ACTIONS(79),
    [sym_this] = ACTIONS(81),
    [sym_super] = ACTIONS(81),
    [sym_true] = ACTIONS(81),
    [sym_false] = ACTIONS(81),
    [sym_null] = ACTIONS(81),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(409),
    [anon_sym_get] = ACTIONS(409),
    [anon_sym_set] = ACTIONS(409),
  },
  [95] = {
    [sym_import] = STATE(575),
    [sym_parenthesized_expression] = STATE(449),
    [sym_expression] = STATE(784),
    [sym_primary_expression] = STATE(576),
    [sym_yield_expression] = STATE(577),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1112),
    [sym_assignment_pattern] = STATE(1387),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1112),
    [sym_jsx_element] = STATE(577),
    [sym_jsx_fragment] = STATE(577),
    [sym_jsx_opening_element] = STATE(975),
    [sym_jsx_self_closing_element] = STATE(577),
    [sym_class] = STATE(575),
    [sym_function] = STATE(575),
    [sym_generator_function] = STATE(575),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(577),
    [sym_await_expression] = STATE(577),
    [sym_member_expression] = STATE(468),
    [sym_subscript_expression] = STATE(468),
    [sym_assignment_expression] = STATE(577),
    [sym__augmented_assignment_lhs] = STATE(943),
    [sym_augmented_assignment_expression] = STATE(577),
    [sym__destructuring_pattern] = STATE(1112),
    [sym_ternary_expression] = STATE(577),
    [sym_binary_expression] = STATE(577),
    [sym_unary_expression] = STATE(577),
    [sym_update_expression] = STATE(577),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1496),
    [sym_pattern] = STATE(1241),
    [sym_rest_pattern] = STATE(1083),
    [aux_sym_export_statement_repeat1] = STATE(1182),
    [sym_identifier] = ACTIONS(577),
    [anon_sym_export] = ACTIONS(579),
    [anon_sym_LBRACE] = ACTIONS(421),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(335),
    [anon_sym_yield] = ACTIONS(339),
    [anon_sym_LBRACK] = ACTIONS(427),
    [anon_sym_LT] = ACTIONS(585),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(587),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(353),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(637),
    [anon_sym_PLUS] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(355),
    [anon_sym_BANG] = ACTIONS(357),
    [anon_sym_TILDE] = ACTIONS(357),
    [anon_sym_typeof] = ACTIONS(355),
    [anon_sym_void] = ACTIONS(355),
    [anon_sym_delete] = ACTIONS(355),
    [anon_sym_PLUS_PLUS] = ACTIONS(359),
    [anon_sym_DASH_DASH] = ACTIONS(359),
    [anon_sym_DQUOTE] = ACTIONS(361),
    [anon_sym_SQUOTE] = ACTIONS(363),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(365),
    [sym_number] = ACTIONS(367),
    [sym_this] = ACTIONS(369),
    [sym_super] = ACTIONS(369),
    [sym_true] = ACTIONS(369),
    [sym_false] = ACTIONS(369),
    [sym_null] = ACTIONS(369),
    [sym_undefined] = ACTIONS(589),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(579),
    [anon_sym_get] = ACTIONS(579),
    [anon_sym_set] = ACTIONS(579),
  },
  [96] = {
    [sym_import] = STATE(721),
    [sym_expression_statement] = STATE(103),
    [sym_empty_statement] = STATE(103),
    [sym_parenthesized_expression] = STATE(479),
    [sym_expression] = STATE(674),
    [sym_primary_expression] = STATE(743),
    [sym_yield_expression] = STATE(740),
    [sym_object] = STATE(721),
    [sym_object_pattern] = STATE(1548),
    [sym_array] = STATE(721),
    [sym_array_pattern] = STATE(1548),
    [sym_jsx_element] = STATE(740),
    [sym_jsx_fragment] = STATE(740),
    [sym_jsx_opening_element] = STATE(972),
    [sym_jsx_self_closing_element] = STATE(740),
    [sym_class] = STATE(721),
    [sym_function] = STATE(721),
    [sym_generator_function] = STATE(721),
    [sym_arrow_function] = STATE(721),
    [sym_call_expression] = STATE(721),
    [sym_new_expression] = STATE(740),
    [sym_await_expression] = STATE(740),
    [sym_member_expression] = STATE(479),
    [sym_subscript_expression] = STATE(479),
    [sym_assignment_expression] = STATE(740),
    [sym__augmented_assignment_lhs] = STATE(942),
    [sym_augmented_assignment_expression] = STATE(740),
    [sym__destructuring_pattern] = STATE(1548),
    [sym_ternary_expression] = STATE(740),
    [sym_binary_expression] = STATE(740),
    [sym_unary_expression] = STATE(740),
    [sym_update_expression] = STATE(740),
    [sym_sequence_expression] = STATE(1331),
    [sym_string] = STATE(721),
    [sym_template_string] = STATE(721),
    [sym_regex] = STATE(721),
    [sym_meta_property] = STATE(721),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1546),
    [aux_sym_export_statement_repeat1] = STATE(1154),
    [sym_identifier] = ACTIONS(407),
    [anon_sym_export] = ACTIONS(409),
    [anon_sym_LBRACE] = ACTIONS(379),
    [anon_sym_import] = ACTIONS(381),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(391),
    [anon_sym_async] = ACTIONS(413),
    [anon_sym_function] = ACTIONS(395),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(67),
    [anon_sym_void] = ACTIONS(67),
    [anon_sym_delete] = ACTIONS(67),
    [anon_sym_PLUS_PLUS] = ACTIONS(71),
    [anon_sym_DASH_DASH] = ACTIONS(71),
    [anon_sym_DQUOTE] = ACTIONS(73),
    [anon_sym_SQUOTE] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(77),
    [sym_number] = ACTIONS(79),
    [sym_this] = ACTIONS(81),
    [sym_super] = ACTIONS(81),
    [sym_true] = ACTIONS(81),
    [sym_false] = ACTIONS(81),
    [sym_null] = ACTIONS(81),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(409),
    [anon_sym_get] = ACTIONS(409),
    [anon_sym_set] = ACTIONS(409),
  },
  [97] = {
    [sym_import] = STATE(575),
    [sym_parenthesized_expression] = STATE(492),
    [sym_expression] = STATE(835),
    [sym_primary_expression] = STATE(576),
    [sym_yield_expression] = STATE(577),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1278),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1278),
    [sym_jsx_element] = STATE(577),
    [sym_jsx_fragment] = STATE(577),
    [sym_jsx_opening_element] = STATE(975),
    [sym_jsx_self_closing_element] = STATE(577),
    [sym_class] = STATE(575),
    [sym_function] = STATE(575),
    [sym_generator_function] = STATE(575),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(577),
    [sym_await_expression] = STATE(577),
    [sym_member_expression] = STATE(492),
    [sym_subscript_expression] = STATE(492),
    [sym_assignment_expression] = STATE(577),
    [sym__augmented_assignment_lhs] = STATE(937),
    [sym_augmented_assignment_expression] = STATE(577),
    [sym__destructuring_pattern] = STATE(1278),
    [sym_ternary_expression] = STATE(577),
    [sym_binary_expression] = STATE(577),
    [sym_unary_expression] = STATE(577),
    [sym_update_expression] = STATE(577),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1533),
    [aux_sym_export_statement_repeat1] = STATE(1182),
    [sym_identifier] = ACTIONS(682),
    [anon_sym_export] = ACTIONS(684),
    [anon_sym_LBRACE] = ACTIONS(686),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_var] = ACTIONS(688),
    [anon_sym_let] = ACTIONS(690),
    [anon_sym_const] = ACTIONS(690),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(449),
    [anon_sym_yield] = ACTIONS(451),
    [anon_sym_LBRACK] = ACTIONS(692),
    [anon_sym_LT] = ACTIONS(585),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(694),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(455),
    [anon_sym_PLUS] = ACTIONS(457),
    [anon_sym_DASH] = ACTIONS(457),
    [anon_sym_BANG] = ACTIONS(459),
    [anon_sym_TILDE] = ACTIONS(459),
    [anon_sym_typeof] = ACTIONS(457),
    [anon_sym_void] = ACTIONS(457),
    [anon_sym_delete] = ACTIONS(457),
    [anon_sym_PLUS_PLUS] = ACTIONS(461),
    [anon_sym_DASH_DASH] = ACTIONS(461),
    [anon_sym_DQUOTE] = ACTIONS(361),
    [anon_sym_SQUOTE] = ACTIONS(363),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(365),
    [sym_number] = ACTIONS(367),
    [sym_this] = ACTIONS(369),
    [sym_super] = ACTIONS(369),
    [sym_true] = ACTIONS(369),
    [sym_false] = ACTIONS(369),
    [sym_null] = ACTIONS(369),
    [sym_undefined] = ACTIONS(696),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(684),
    [anon_sym_get] = ACTIONS(684),
    [anon_sym_set] = ACTIONS(684),
  },
  [98] = {
    [sym_import] = STATE(721),
    [sym_parenthesized_expression] = STATE(479),
    [sym_expression] = STATE(687),
    [sym_primary_expression] = STATE(743),
    [sym_yield_expression] = STATE(740),
    [sym_object] = STATE(721),
    [sym_object_pattern] = STATE(1548),
    [sym_array] = STATE(721),
    [sym_array_pattern] = STATE(1548),
    [sym_jsx_element] = STATE(740),
    [sym_jsx_fragment] = STATE(740),
    [sym_jsx_opening_element] = STATE(972),
    [sym_jsx_self_closing_element] = STATE(740),
    [sym_class] = STATE(721),
    [sym_function] = STATE(721),
    [sym_generator_function] = STATE(721),
    [sym_arrow_function] = STATE(721),
    [sym_call_expression] = STATE(721),
    [sym_new_expression] = STATE(740),
    [sym_await_expression] = STATE(740),
    [sym_member_expression] = STATE(479),
    [sym_subscript_expression] = STATE(479),
    [sym_assignment_expression] = STATE(740),
    [sym__augmented_assignment_lhs] = STATE(942),
    [sym_augmented_assignment_expression] = STATE(740),
    [sym__destructuring_pattern] = STATE(1548),
    [sym_ternary_expression] = STATE(740),
    [sym_binary_expression] = STATE(740),
    [sym_unary_expression] = STATE(740),
    [sym_update_expression] = STATE(740),
    [sym_sequence_expression] = STATE(1401),
    [sym_string] = STATE(721),
    [sym_template_string] = STATE(721),
    [sym_regex] = STATE(721),
    [sym_meta_property] = STATE(721),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1546),
    [aux_sym_export_statement_repeat1] = STATE(1154),
    [sym_identifier] = ACTIONS(407),
    [anon_sym_export] = ACTIONS(409),
    [anon_sym_LBRACE] = ACTIONS(379),
    [anon_sym_import] = ACTIONS(381),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_SEMI] = ACTIONS(698),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(391),
    [anon_sym_async] = ACTIONS(413),
    [anon_sym_function] = ACTIONS(395),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(67),
    [anon_sym_void] = ACTIONS(67),
    [anon_sym_delete] = ACTIONS(67),
    [anon_sym_PLUS_PLUS] = ACTIONS(71),
    [anon_sym_DASH_DASH] = ACTIONS(71),
    [anon_sym_DQUOTE] = ACTIONS(73),
    [anon_sym_SQUOTE] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(77),
    [sym_number] = ACTIONS(79),
    [sym_this] = ACTIONS(81),
    [sym_super] = ACTIONS(81),
    [sym_true] = ACTIONS(81),
    [sym_false] = ACTIONS(81),
    [sym_null] = ACTIONS(81),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(409),
    [anon_sym_get] = ACTIONS(409),
    [anon_sym_set] = ACTIONS(409),
    [sym__automatic_semicolon] = ACTIONS(698),
  },
  [99] = {
    [sym_export_clause] = STATE(1169),
    [sym_declaration] = STATE(395),
    [sym_namespace_import_export] = STATE(1339),
    [sym_variable_declaration] = STATE(415),
    [sym_lexical_declaration] = STATE(415),
    [sym_class_declaration] = STATE(415),
    [sym_function_declaration] = STATE(415),
    [sym_generator_function_declaration] = STATE(415),
    [sym_decorator] = STATE(959),
    [aux_sym_export_statement_repeat1] = STATE(1174),
    [aux_sym_object_repeat1] = STATE(1222),
    [aux_sym_object_pattern_repeat1] = STATE(1220),
    [anon_sym_STAR] = ACTIONS(700),
    [anon_sym_default] = ACTIONS(702),
    [anon_sym_LBRACE] = ACTIONS(704),
    [anon_sym_COMMA] = ACTIONS(706),
    [anon_sym_RBRACE] = ACTIONS(708),
    [anon_sym_var] = ACTIONS(710),
    [anon_sym_let] = ACTIONS(712),
    [anon_sym_const] = ACTIONS(712),
    [anon_sym_LPAREN] = ACTIONS(714),
    [anon_sym_in] = ACTIONS(717),
    [anon_sym_SEMI] = ACTIONS(706),
    [anon_sym_COLON] = ACTIONS(719),
    [anon_sym_EQ] = ACTIONS(722),
    [anon_sym_LBRACK] = ACTIONS(706),
    [anon_sym_LT] = ACTIONS(717),
    [anon_sym_GT] = ACTIONS(717),
    [anon_sym_SLASH] = ACTIONS(717),
    [anon_sym_DOT] = ACTIONS(706),
    [anon_sym_class] = ACTIONS(724),
    [anon_sym_async] = ACTIONS(726),
    [anon_sym_function] = ACTIONS(728),
    [anon_sym_EQ_GT] = ACTIONS(730),
    [anon_sym_QMARK_DOT] = ACTIONS(706),
    [anon_sym_PLUS_EQ] = ACTIONS(732),
    [anon_sym_DASH_EQ] = ACTIONS(732),
    [anon_sym_STAR_EQ] = ACTIONS(732),
    [anon_sym_SLASH_EQ] = ACTIONS(732),
    [anon_sym_PERCENT_EQ] = ACTIONS(732),
    [anon_sym_CARET_EQ] = ACTIONS(732),
    [anon_sym_AMP_EQ] = ACTIONS(732),
    [anon_sym_PIPE_EQ] = ACTIONS(732),
    [anon_sym_GT_GT_EQ] = ACTIONS(732),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(732),
    [anon_sym_LT_LT_EQ] = ACTIONS(732),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(732),
    [anon_sym_AMP_AMP_EQ] = ACTIONS(732),
    [anon_sym_PIPE_PIPE_EQ] = ACTIONS(732),
    [anon_sym_QMARK_QMARK_EQ] = ACTIONS(732),
    [anon_sym_AMP_AMP] = ACTIONS(717),
    [anon_sym_PIPE_PIPE] = ACTIONS(717),
    [anon_sym_GT_GT] = ACTIONS(717),
    [anon_sym_GT_GT_GT] = ACTIONS(717),
    [anon_sym_LT_LT] = ACTIONS(717),
    [anon_sym_AMP] = ACTIONS(717),
    [anon_sym_CARET] = ACTIONS(717),
    [anon_sym_PIPE] = ACTIONS(717),
    [anon_sym_PLUS] = ACTIONS(717),
    [anon_sym_DASH] = ACTIONS(717),
    [anon_sym_PERCENT] = ACTIONS(717),
    [anon_sym_STAR_STAR] = ACTIONS(717),
    [anon_sym_LT_EQ] = ACTIONS(706),
    [anon_sym_EQ_EQ] = ACTIONS(717),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(706),
    [anon_sym_BANG_EQ] = ACTIONS(717),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(706),
    [anon_sym_GT_EQ] = ACTIONS(706),
    [anon_sym_QMARK_QMARK] = ACTIONS(717),
    [anon_sym_instanceof] = ACTIONS(706),
    [anon_sym_PLUS_PLUS] = ACTIONS(706),
    [anon_sym_DASH_DASH] = ACTIONS(706),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(706),
    [anon_sym_AT] = ACTIONS(85),
    [sym__automatic_semicolon] = ACTIONS(706),
    [sym__ternary_qmark] = ACTIONS(706),
  },
  [100] = {
    [sym_import] = STATE(575),
    [sym_parenthesized_expression] = STATE(449),
    [sym_expression] = STATE(777),
    [sym_primary_expression] = STATE(576),
    [sym_yield_expression] = STATE(577),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1528),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1528),
    [sym_jsx_element] = STATE(577),
    [sym_jsx_fragment] = STATE(577),
    [sym_jsx_opening_element] = STATE(975),
    [sym_jsx_self_closing_element] = STATE(577),
    [sym_class] = STATE(575),
    [sym_function] = STATE(575),
    [sym_generator_function] = STATE(575),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(577),
    [sym_await_expression] = STATE(577),
    [sym_member_expression] = STATE(449),
    [sym_subscript_expression] = STATE(449),
    [sym_assignment_expression] = STATE(577),
    [sym__augmented_assignment_lhs] = STATE(943),
    [sym_augmented_assignment_expression] = STATE(577),
    [sym__destructuring_pattern] = STATE(1528),
    [sym_ternary_expression] = STATE(577),
    [sym_binary_expression] = STATE(577),
    [sym_unary_expression] = STATE(577),
    [sym_update_expression] = STATE(577),
    [sym_sequence_expression] = STATE(1482),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1496),
    [aux_sym_export_statement_repeat1] = STATE(1182),
    [sym_identifier] = ACTIONS(321),
    [anon_sym_export] = ACTIONS(323),
    [anon_sym_LBRACE] = ACTIONS(327),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_RPAREN] = ACTIONS(734),
    [anon_sym_await] = ACTIONS(335),
    [anon_sym_yield] = ACTIONS(339),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LT] = ACTIONS(585),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(349),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(353),
    [anon_sym_PLUS] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(355),
    [anon_sym_BANG] = ACTIONS(357),
    [anon_sym_TILDE] = ACTIONS(357),
    [anon_sym_typeof] = ACTIONS(355),
    [anon_sym_void] = ACTIONS(355),
    [anon_sym_delete] = ACTIONS(355),
    [anon_sym_PLUS_PLUS] = ACTIONS(359),
    [anon_sym_DASH_DASH] = ACTIONS(359),
    [anon_sym_DQUOTE] = ACTIONS(361),
    [anon_sym_SQUOTE] = ACTIONS(363),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(365),
    [sym_number] = ACTIONS(367),
    [sym_this] = ACTIONS(369),
    [sym_super] = ACTIONS(369),
    [sym_true] = ACTIONS(369),
    [sym_false] = ACTIONS(369),
    [sym_null] = ACTIONS(369),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(323),
    [anon_sym_get] = ACTIONS(323),
    [anon_sym_set] = ACTIONS(323),
  },
  [101] = {
    [sym_export_clause] = STATE(1169),
    [sym_declaration] = STATE(395),
    [sym_namespace_import_export] = STATE(1339),
    [sym_variable_declaration] = STATE(415),
    [sym_lexical_declaration] = STATE(415),
    [sym_class_declaration] = STATE(415),
    [sym_function_declaration] = STATE(415),
    [sym_generator_function_declaration] = STATE(415),
    [sym_decorator] = STATE(959),
    [aux_sym_export_statement_repeat1] = STATE(1174),
    [aux_sym_object_repeat1] = STATE(1253),
    [aux_sym_object_pattern_repeat1] = STATE(1220),
    [anon_sym_STAR] = ACTIONS(700),
    [anon_sym_default] = ACTIONS(702),
    [anon_sym_LBRACE] = ACTIONS(704),
    [anon_sym_COMMA] = ACTIONS(706),
    [anon_sym_RBRACE] = ACTIONS(736),
    [anon_sym_var] = ACTIONS(710),
    [anon_sym_let] = ACTIONS(712),
    [anon_sym_const] = ACTIONS(712),
    [anon_sym_LPAREN] = ACTIONS(714),
    [anon_sym_in] = ACTIONS(717),
    [anon_sym_SEMI] = ACTIONS(706),
    [anon_sym_COLON] = ACTIONS(719),
    [anon_sym_EQ] = ACTIONS(722),
    [anon_sym_LBRACK] = ACTIONS(706),
    [anon_sym_LT] = ACTIONS(717),
    [anon_sym_GT] = ACTIONS(717),
    [anon_sym_SLASH] = ACTIONS(717),
    [anon_sym_DOT] = ACTIONS(706),
    [anon_sym_class] = ACTIONS(724),
    [anon_sym_async] = ACTIONS(726),
    [anon_sym_function] = ACTIONS(728),
    [anon_sym_EQ_GT] = ACTIONS(730),
    [anon_sym_QMARK_DOT] = ACTIONS(706),
    [anon_sym_PLUS_EQ] = ACTIONS(732),
    [anon_sym_DASH_EQ] = ACTIONS(732),
    [anon_sym_STAR_EQ] = ACTIONS(732),
    [anon_sym_SLASH_EQ] = ACTIONS(732),
    [anon_sym_PERCENT_EQ] = ACTIONS(732),
    [anon_sym_CARET_EQ] = ACTIONS(732),
    [anon_sym_AMP_EQ] = ACTIONS(732),
    [anon_sym_PIPE_EQ] = ACTIONS(732),
    [anon_sym_GT_GT_EQ] = ACTIONS(732),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(732),
    [anon_sym_LT_LT_EQ] = ACTIONS(732),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(732),
    [anon_sym_AMP_AMP_EQ] = ACTIONS(732),
    [anon_sym_PIPE_PIPE_EQ] = ACTIONS(732),
    [anon_sym_QMARK_QMARK_EQ] = ACTIONS(732),
    [anon_sym_AMP_AMP] = ACTIONS(717),
    [anon_sym_PIPE_PIPE] = ACTIONS(717),
    [anon_sym_GT_GT] = ACTIONS(717),
    [anon_sym_GT_GT_GT] = ACTIONS(717),
    [anon_sym_LT_LT] = ACTIONS(717),
    [anon_sym_AMP] = ACTIONS(717),
    [anon_sym_CARET] = ACTIONS(717),
    [anon_sym_PIPE] = ACTIONS(717),
    [anon_sym_PLUS] = ACTIONS(717),
    [anon_sym_DASH] = ACTIONS(717),
    [anon_sym_PERCENT] = ACTIONS(717),
    [anon_sym_STAR_STAR] = ACTIONS(717),
    [anon_sym_LT_EQ] = ACTIONS(706),
    [anon_sym_EQ_EQ] = ACTIONS(717),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(706),
    [anon_sym_BANG_EQ] = ACTIONS(717),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(706),
    [anon_sym_GT_EQ] = ACTIONS(706),
    [anon_sym_QMARK_QMARK] = ACTIONS(717),
    [anon_sym_instanceof] = ACTIONS(706),
    [anon_sym_PLUS_PLUS] = ACTIONS(706),
    [anon_sym_DASH_DASH] = ACTIONS(706),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(706),
    [anon_sym_AT] = ACTIONS(85),
    [sym__automatic_semicolon] = ACTIONS(706),
    [sym__ternary_qmark] = ACTIONS(706),
  },
  [102] = {
    [sym_export_clause] = STATE(1169),
    [sym_declaration] = STATE(395),
    [sym_namespace_import_export] = STATE(1339),
    [sym_variable_declaration] = STATE(415),
    [sym_lexical_declaration] = STATE(415),
    [sym_class_declaration] = STATE(415),
    [sym_function_declaration] = STATE(415),
    [sym_generator_function_declaration] = STATE(415),
    [sym_decorator] = STATE(959),
    [aux_sym_export_statement_repeat1] = STATE(1174),
    [aux_sym_object_repeat1] = STATE(1253),
    [aux_sym_object_pattern_repeat1] = STATE(1220),
    [anon_sym_STAR] = ACTIONS(700),
    [anon_sym_default] = ACTIONS(702),
    [anon_sym_LBRACE] = ACTIONS(704),
    [anon_sym_COMMA] = ACTIONS(706),
    [anon_sym_RBRACE] = ACTIONS(738),
    [anon_sym_var] = ACTIONS(710),
    [anon_sym_let] = ACTIONS(712),
    [anon_sym_const] = ACTIONS(712),
    [anon_sym_LPAREN] = ACTIONS(714),
    [anon_sym_in] = ACTIONS(717),
    [anon_sym_SEMI] = ACTIONS(706),
    [anon_sym_COLON] = ACTIONS(719),
    [anon_sym_EQ] = ACTIONS(722),
    [anon_sym_LBRACK] = ACTIONS(706),
    [anon_sym_LT] = ACTIONS(717),
    [anon_sym_GT] = ACTIONS(717),
    [anon_sym_SLASH] = ACTIONS(717),
    [anon_sym_DOT] = ACTIONS(706),
    [anon_sym_class] = ACTIONS(724),
    [anon_sym_async] = ACTIONS(726),
    [anon_sym_function] = ACTIONS(728),
    [anon_sym_EQ_GT] = ACTIONS(730),
    [anon_sym_QMARK_DOT] = ACTIONS(706),
    [anon_sym_PLUS_EQ] = ACTIONS(732),
    [anon_sym_DASH_EQ] = ACTIONS(732),
    [anon_sym_STAR_EQ] = ACTIONS(732),
    [anon_sym_SLASH_EQ] = ACTIONS(732),
    [anon_sym_PERCENT_EQ] = ACTIONS(732),
    [anon_sym_CARET_EQ] = ACTIONS(732),
    [anon_sym_AMP_EQ] = ACTIONS(732),
    [anon_sym_PIPE_EQ] = ACTIONS(732),
    [anon_sym_GT_GT_EQ] = ACTIONS(732),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(732),
    [anon_sym_LT_LT_EQ] = ACTIONS(732),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(732),
    [anon_sym_AMP_AMP_EQ] = ACTIONS(732),
    [anon_sym_PIPE_PIPE_EQ] = ACTIONS(732),
    [anon_sym_QMARK_QMARK_EQ] = ACTIONS(732),
    [anon_sym_AMP_AMP] = ACTIONS(717),
    [anon_sym_PIPE_PIPE] = ACTIONS(717),
    [anon_sym_GT_GT] = ACTIONS(717),
    [anon_sym_GT_GT_GT] = ACTIONS(717),
    [anon_sym_LT_LT] = ACTIONS(717),
    [anon_sym_AMP] = ACTIONS(717),
    [anon_sym_CARET] = ACTIONS(717),
    [anon_sym_PIPE] = ACTIONS(717),
    [anon_sym_PLUS] = ACTIONS(717),
    [anon_sym_DASH] = ACTIONS(717),
    [anon_sym_PERCENT] = ACTIONS(717),
    [anon_sym_STAR_STAR] = ACTIONS(717),
    [anon_sym_LT_EQ] = ACTIONS(706),
    [anon_sym_EQ_EQ] = ACTIONS(717),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(706),
    [anon_sym_BANG_EQ] = ACTIONS(717),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(706),
    [anon_sym_GT_EQ] = ACTIONS(706),
    [anon_sym_QMARK_QMARK] = ACTIONS(717),
    [anon_sym_instanceof] = ACTIONS(706),
    [anon_sym_PLUS_PLUS] = ACTIONS(706),
    [anon_sym_DASH_DASH] = ACTIONS(706),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(706),
    [anon_sym_AT] = ACTIONS(85),
    [sym__automatic_semicolon] = ACTIONS(706),
    [sym__ternary_qmark] = ACTIONS(706),
  },
  [103] = {
    [sym_import] = STATE(575),
    [sym_parenthesized_expression] = STATE(449),
    [sym_expression] = STATE(758),
    [sym_primary_expression] = STATE(576),
    [sym_yield_expression] = STATE(577),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1528),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1528),
    [sym_jsx_element] = STATE(577),
    [sym_jsx_fragment] = STATE(577),
    [sym_jsx_opening_element] = STATE(975),
    [sym_jsx_self_closing_element] = STATE(577),
    [sym_class] = STATE(575),
    [sym_function] = STATE(575),
    [sym_generator_function] = STATE(575),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(577),
    [sym_await_expression] = STATE(577),
    [sym_member_expression] = STATE(449),
    [sym_subscript_expression] = STATE(449),
    [sym_assignment_expression] = STATE(577),
    [sym__augmented_assignment_lhs] = STATE(943),
    [sym_augmented_assignment_expression] = STATE(577),
    [sym__destructuring_pattern] = STATE(1528),
    [sym_ternary_expression] = STATE(577),
    [sym_binary_expression] = STATE(577),
    [sym_unary_expression] = STATE(577),
    [sym_update_expression] = STATE(577),
    [sym_sequence_expression] = STATE(1563),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1496),
    [aux_sym_export_statement_repeat1] = STATE(1182),
    [sym_identifier] = ACTIONS(321),
    [anon_sym_export] = ACTIONS(323),
    [anon_sym_LBRACE] = ACTIONS(327),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_RPAREN] = ACTIONS(740),
    [anon_sym_await] = ACTIONS(335),
    [anon_sym_yield] = ACTIONS(339),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LT] = ACTIONS(585),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(349),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(353),
    [anon_sym_PLUS] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(355),
    [anon_sym_BANG] = ACTIONS(357),
    [anon_sym_TILDE] = ACTIONS(357),
    [anon_sym_typeof] = ACTIONS(355),
    [anon_sym_void] = ACTIONS(355),
    [anon_sym_delete] = ACTIONS(355),
    [anon_sym_PLUS_PLUS] = ACTIONS(359),
    [anon_sym_DASH_DASH] = ACTIONS(359),
    [anon_sym_DQUOTE] = ACTIONS(361),
    [anon_sym_SQUOTE] = ACTIONS(363),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(365),
    [sym_number] = ACTIONS(367),
    [sym_this] = ACTIONS(369),
    [sym_super] = ACTIONS(369),
    [sym_true] = ACTIONS(369),
    [sym_false] = ACTIONS(369),
    [sym_null] = ACTIONS(369),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(323),
    [anon_sym_get] = ACTIONS(323),
    [anon_sym_set] = ACTIONS(323),
  },
  [104] = {
    [sym_import] = STATE(575),
    [sym_statement_block] = STATE(514),
    [sym_parenthesized_expression] = STATE(449),
    [sym_expression] = STATE(513),
    [sym_primary_expression] = STATE(576),
    [sym_yield_expression] = STATE(577),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1528),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1528),
    [sym_jsx_element] = STATE(577),
    [sym_jsx_fragment] = STATE(577),
    [sym_jsx_opening_element] = STATE(975),
    [sym_jsx_self_closing_element] = STATE(577),
    [sym_class] = STATE(575),
    [sym_function] = STATE(575),
    [sym_generator_function] = STATE(575),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(577),
    [sym_await_expression] = STATE(577),
    [sym_member_expression] = STATE(449),
    [sym_subscript_expression] = STATE(449),
    [sym_assignment_expression] = STATE(577),
    [sym__augmented_assignment_lhs] = STATE(943),
    [sym_augmented_assignment_expression] = STATE(577),
    [sym__destructuring_pattern] = STATE(1528),
    [sym_ternary_expression] = STATE(577),
    [sym_binary_expression] = STATE(577),
    [sym_unary_expression] = STATE(577),
    [sym_update_expression] = STATE(577),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1496),
    [aux_sym_export_statement_repeat1] = STATE(1182),
    [sym_identifier] = ACTIONS(321),
    [anon_sym_export] = ACTIONS(323),
    [anon_sym_LBRACE] = ACTIONS(742),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(335),
    [anon_sym_yield] = ACTIONS(339),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LT] = ACTIONS(585),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(349),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(353),
    [anon_sym_PLUS] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(355),
    [anon_sym_BANG] = ACTIONS(357),
    [anon_sym_TILDE] = ACTIONS(357),
    [anon_sym_typeof] = ACTIONS(355),
    [anon_sym_void] = ACTIONS(355),
    [anon_sym_delete] = ACTIONS(355),
    [anon_sym_PLUS_PLUS] = ACTIONS(359),
    [anon_sym_DASH_DASH] = ACTIONS(359),
    [anon_sym_DQUOTE] = ACTIONS(361),
    [anon_sym_SQUOTE] = ACTIONS(363),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(365),
    [sym_number] = ACTIONS(367),
    [sym_this] = ACTIONS(369),
    [sym_super] = ACTIONS(369),
    [sym_true] = ACTIONS(369),
    [sym_false] = ACTIONS(369),
    [sym_null] = ACTIONS(369),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(323),
    [anon_sym_get] = ACTIONS(323),
    [anon_sym_set] = ACTIONS(323),
  },
  [105] = {
    [sym_import] = STATE(575),
    [sym_parenthesized_expression] = STATE(449),
    [sym_expression] = STATE(774),
    [sym_primary_expression] = STATE(576),
    [sym_yield_expression] = STATE(577),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1528),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1528),
    [sym_jsx_element] = STATE(577),
    [sym_jsx_fragment] = STATE(577),
    [sym_jsx_opening_element] = STATE(975),
    [sym_jsx_self_closing_element] = STATE(577),
    [sym_class] = STATE(575),
    [sym_function] = STATE(575),
    [sym_generator_function] = STATE(575),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(577),
    [sym_await_expression] = STATE(577),
    [sym_member_expression] = STATE(449),
    [sym_subscript_expression] = STATE(449),
    [sym_assignment_expression] = STATE(577),
    [sym__augmented_assignment_lhs] = STATE(943),
    [sym_augmented_assignment_expression] = STATE(577),
    [sym__destructuring_pattern] = STATE(1528),
    [sym_ternary_expression] = STATE(577),
    [sym_binary_expression] = STATE(577),
    [sym_unary_expression] = STATE(577),
    [sym_update_expression] = STATE(577),
    [sym_sequence_expression] = STATE(1485),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1496),
    [aux_sym_export_statement_repeat1] = STATE(1182),
    [sym_identifier] = ACTIONS(321),
    [anon_sym_export] = ACTIONS(323),
    [anon_sym_LBRACE] = ACTIONS(327),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(335),
    [anon_sym_yield] = ACTIONS(339),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LT] = ACTIONS(585),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(349),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(353),
    [anon_sym_PLUS] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(355),
    [anon_sym_BANG] = ACTIONS(357),
    [anon_sym_TILDE] = ACTIONS(357),
    [anon_sym_typeof] = ACTIONS(355),
    [anon_sym_void] = ACTIONS(355),
    [anon_sym_delete] = ACTIONS(355),
    [anon_sym_PLUS_PLUS] = ACTIONS(359),
    [anon_sym_DASH_DASH] = ACTIONS(359),
    [anon_sym_DQUOTE] = ACTIONS(361),
    [anon_sym_SQUOTE] = ACTIONS(363),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(365),
    [sym_number] = ACTIONS(367),
    [sym_this] = ACTIONS(369),
    [sym_super] = ACTIONS(369),
    [sym_true] = ACTIONS(369),
    [sym_false] = ACTIONS(369),
    [sym_null] = ACTIONS(369),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(323),
    [anon_sym_get] = ACTIONS(323),
    [anon_sym_set] = ACTIONS(323),
  },
  [106] = {
    [sym_import] = STATE(575),
    [sym_statement_block] = STATE(516),
    [sym_parenthesized_expression] = STATE(493),
    [sym_expression] = STATE(817),
    [sym_primary_expression] = STATE(576),
    [sym_yield_expression] = STATE(577),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1580),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1580),
    [sym_jsx_element] = STATE(577),
    [sym_jsx_fragment] = STATE(577),
    [sym_jsx_opening_element] = STATE(975),
    [sym_jsx_self_closing_element] = STATE(577),
    [sym_class] = STATE(575),
    [sym_function] = STATE(575),
    [sym_generator_function] = STATE(575),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(577),
    [sym_await_expression] = STATE(577),
    [sym_member_expression] = STATE(493),
    [sym_subscript_expression] = STATE(493),
    [sym_assignment_expression] = STATE(577),
    [sym__augmented_assignment_lhs] = STATE(933),
    [sym_augmented_assignment_expression] = STATE(577),
    [sym__destructuring_pattern] = STATE(1580),
    [sym_ternary_expression] = STATE(577),
    [sym_binary_expression] = STATE(577),
    [sym_unary_expression] = STATE(577),
    [sym_update_expression] = STATE(577),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1555),
    [aux_sym_export_statement_repeat1] = STATE(1182),
    [sym_identifier] = ACTIONS(415),
    [anon_sym_export] = ACTIONS(417),
    [anon_sym_LBRACE] = ACTIONS(744),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(423),
    [anon_sym_yield] = ACTIONS(425),
    [anon_sym_LBRACK] = ACTIONS(427),
    [anon_sym_LT] = ACTIONS(585),
    [anon_sym_SLASH] = ACTIONS(429),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(431),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(433),
    [anon_sym_PLUS] = ACTIONS(435),
    [anon_sym_DASH] = ACTIONS(435),
    [anon_sym_BANG] = ACTIONS(437),
    [anon_sym_TILDE] = ACTIONS(437),
    [anon_sym_typeof] = ACTIONS(435),
    [anon_sym_void] = ACTIONS(435),
    [anon_sym_delete] = ACTIONS(435),
    [anon_sym_PLUS_PLUS] = ACTIONS(439),
    [anon_sym_DASH_DASH] = ACTIONS(439),
    [anon_sym_DQUOTE] = ACTIONS(361),
    [anon_sym_SQUOTE] = ACTIONS(363),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(365),
    [sym_number] = ACTIONS(367),
    [sym_this] = ACTIONS(369),
    [sym_super] = ACTIONS(369),
    [sym_true] = ACTIONS(369),
    [sym_false] = ACTIONS(369),
    [sym_null] = ACTIONS(369),
    [sym_undefined] = ACTIONS(441),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(417),
    [anon_sym_get] = ACTIONS(417),
    [anon_sym_set] = ACTIONS(417),
  },
  [107] = {
    [sym_import] = STATE(721),
    [sym_statement_block] = STATE(698),
    [sym_parenthesized_expression] = STATE(466),
    [sym_expression] = STATE(625),
    [sym_primary_expression] = STATE(743),
    [sym_yield_expression] = STATE(740),
    [sym_object] = STATE(721),
    [sym_object_pattern] = STATE(1486),
    [sym_array] = STATE(721),
    [sym_array_pattern] = STATE(1486),
    [sym_jsx_element] = STATE(740),
    [sym_jsx_fragment] = STATE(740),
    [sym_jsx_opening_element] = STATE(972),
    [sym_jsx_self_closing_element] = STATE(740),
    [sym_class] = STATE(721),
    [sym_function] = STATE(721),
    [sym_generator_function] = STATE(721),
    [sym_arrow_function] = STATE(721),
    [sym_call_expression] = STATE(721),
    [sym_new_expression] = STATE(740),
    [sym_await_expression] = STATE(740),
    [sym_member_expression] = STATE(466),
    [sym_subscript_expression] = STATE(466),
    [sym_assignment_expression] = STATE(740),
    [sym__augmented_assignment_lhs] = STATE(940),
    [sym_augmented_assignment_expression] = STATE(740),
    [sym__destructuring_pattern] = STATE(1486),
    [sym_ternary_expression] = STATE(740),
    [sym_binary_expression] = STATE(740),
    [sym_unary_expression] = STATE(740),
    [sym_update_expression] = STATE(740),
    [sym_string] = STATE(721),
    [sym_template_string] = STATE(721),
    [sym_regex] = STATE(721),
    [sym_meta_property] = STATE(721),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1487),
    [aux_sym_export_statement_repeat1] = STATE(1154),
    [sym_identifier] = ACTIONS(373),
    [anon_sym_export] = ACTIONS(375),
    [anon_sym_LBRACE] = ACTIONS(746),
    [anon_sym_import] = ACTIONS(381),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(383),
    [anon_sym_yield] = ACTIONS(385),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(389),
    [anon_sym_class] = ACTIONS(391),
    [anon_sym_async] = ACTIONS(393),
    [anon_sym_function] = ACTIONS(395),
    [anon_sym_new] = ACTIONS(397),
    [anon_sym_PLUS] = ACTIONS(399),
    [anon_sym_DASH] = ACTIONS(399),
    [anon_sym_BANG] = ACTIONS(401),
    [anon_sym_TILDE] = ACTIONS(401),
    [anon_sym_typeof] = ACTIONS(399),
    [anon_sym_void] = ACTIONS(399),
    [anon_sym_delete] = ACTIONS(399),
    [anon_sym_PLUS_PLUS] = ACTIONS(403),
    [anon_sym_DASH_DASH] = ACTIONS(403),
    [anon_sym_DQUOTE] = ACTIONS(73),
    [anon_sym_SQUOTE] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(77),
    [sym_number] = ACTIONS(79),
    [sym_this] = ACTIONS(81),
    [sym_super] = ACTIONS(81),
    [sym_true] = ACTIONS(81),
    [sym_false] = ACTIONS(81),
    [sym_null] = ACTIONS(81),
    [sym_undefined] = ACTIONS(405),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(375),
    [anon_sym_get] = ACTIONS(375),
    [anon_sym_set] = ACTIONS(375),
  },
  [108] = {
    [sym_import] = STATE(575),
    [sym_statement_block] = STATE(519),
    [sym_parenthesized_expression] = STATE(493),
    [sym_expression] = STATE(827),
    [sym_primary_expression] = STATE(576),
    [sym_yield_expression] = STATE(577),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1580),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1580),
    [sym_jsx_element] = STATE(577),
    [sym_jsx_fragment] = STATE(577),
    [sym_jsx_opening_element] = STATE(975),
    [sym_jsx_self_closing_element] = STATE(577),
    [sym_class] = STATE(575),
    [sym_function] = STATE(575),
    [sym_generator_function] = STATE(575),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(577),
    [sym_await_expression] = STATE(577),
    [sym_member_expression] = STATE(493),
    [sym_subscript_expression] = STATE(493),
    [sym_assignment_expression] = STATE(577),
    [sym__augmented_assignment_lhs] = STATE(933),
    [sym_augmented_assignment_expression] = STATE(577),
    [sym__destructuring_pattern] = STATE(1580),
    [sym_ternary_expression] = STATE(577),
    [sym_binary_expression] = STATE(577),
    [sym_unary_expression] = STATE(577),
    [sym_update_expression] = STATE(577),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1555),
    [aux_sym_export_statement_repeat1] = STATE(1182),
    [sym_identifier] = ACTIONS(415),
    [anon_sym_export] = ACTIONS(417),
    [anon_sym_LBRACE] = ACTIONS(744),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(423),
    [anon_sym_yield] = ACTIONS(425),
    [anon_sym_LBRACK] = ACTIONS(427),
    [anon_sym_LT] = ACTIONS(585),
    [anon_sym_SLASH] = ACTIONS(429),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(431),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(433),
    [anon_sym_PLUS] = ACTIONS(435),
    [anon_sym_DASH] = ACTIONS(435),
    [anon_sym_BANG] = ACTIONS(437),
    [anon_sym_TILDE] = ACTIONS(437),
    [anon_sym_typeof] = ACTIONS(435),
    [anon_sym_void] = ACTIONS(435),
    [anon_sym_delete] = ACTIONS(435),
    [anon_sym_PLUS_PLUS] = ACTIONS(439),
    [anon_sym_DASH_DASH] = ACTIONS(439),
    [anon_sym_DQUOTE] = ACTIONS(361),
    [anon_sym_SQUOTE] = ACTIONS(363),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(365),
    [sym_number] = ACTIONS(367),
    [sym_this] = ACTIONS(369),
    [sym_super] = ACTIONS(369),
    [sym_true] = ACTIONS(369),
    [sym_false] = ACTIONS(369),
    [sym_null] = ACTIONS(369),
    [sym_undefined] = ACTIONS(441),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(417),
    [anon_sym_get] = ACTIONS(417),
    [anon_sym_set] = ACTIONS(417),
  },
  [109] = {
    [sym_import] = STATE(721),
    [sym_statement_block] = STATE(722),
    [sym_parenthesized_expression] = STATE(466),
    [sym_expression] = STATE(650),
    [sym_primary_expression] = STATE(743),
    [sym_yield_expression] = STATE(740),
    [sym_object] = STATE(721),
    [sym_object_pattern] = STATE(1486),
    [sym_array] = STATE(721),
    [sym_array_pattern] = STATE(1486),
    [sym_jsx_element] = STATE(740),
    [sym_jsx_fragment] = STATE(740),
    [sym_jsx_opening_element] = STATE(972),
    [sym_jsx_self_closing_element] = STATE(740),
    [sym_class] = STATE(721),
    [sym_function] = STATE(721),
    [sym_generator_function] = STATE(721),
    [sym_arrow_function] = STATE(721),
    [sym_call_expression] = STATE(721),
    [sym_new_expression] = STATE(740),
    [sym_await_expression] = STATE(740),
    [sym_member_expression] = STATE(466),
    [sym_subscript_expression] = STATE(466),
    [sym_assignment_expression] = STATE(740),
    [sym__augmented_assignment_lhs] = STATE(940),
    [sym_augmented_assignment_expression] = STATE(740),
    [sym__destructuring_pattern] = STATE(1486),
    [sym_ternary_expression] = STATE(740),
    [sym_binary_expression] = STATE(740),
    [sym_unary_expression] = STATE(740),
    [sym_update_expression] = STATE(740),
    [sym_string] = STATE(721),
    [sym_template_string] = STATE(721),
    [sym_regex] = STATE(721),
    [sym_meta_property] = STATE(721),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1487),
    [aux_sym_export_statement_repeat1] = STATE(1154),
    [sym_identifier] = ACTIONS(373),
    [anon_sym_export] = ACTIONS(375),
    [anon_sym_LBRACE] = ACTIONS(746),
    [anon_sym_import] = ACTIONS(381),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(383),
    [anon_sym_yield] = ACTIONS(385),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(389),
    [anon_sym_class] = ACTIONS(391),
    [anon_sym_async] = ACTIONS(393),
    [anon_sym_function] = ACTIONS(395),
    [anon_sym_new] = ACTIONS(397),
    [anon_sym_PLUS] = ACTIONS(399),
    [anon_sym_DASH] = ACTIONS(399),
    [anon_sym_BANG] = ACTIONS(401),
    [anon_sym_TILDE] = ACTIONS(401),
    [anon_sym_typeof] = ACTIONS(399),
    [anon_sym_void] = ACTIONS(399),
    [anon_sym_delete] = ACTIONS(399),
    [anon_sym_PLUS_PLUS] = ACTIONS(403),
    [anon_sym_DASH_DASH] = ACTIONS(403),
    [anon_sym_DQUOTE] = ACTIONS(73),
    [anon_sym_SQUOTE] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(77),
    [sym_number] = ACTIONS(79),
    [sym_this] = ACTIONS(81),
    [sym_super] = ACTIONS(81),
    [sym_true] = ACTIONS(81),
    [sym_false] = ACTIONS(81),
    [sym_null] = ACTIONS(81),
    [sym_undefined] = ACTIONS(405),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(375),
    [anon_sym_get] = ACTIONS(375),
    [anon_sym_set] = ACTIONS(375),
  },
  [110] = {
    [sym_import] = STATE(575),
    [sym_parenthesized_expression] = STATE(449),
    [sym_expression] = STATE(545),
    [sym_primary_expression] = STATE(576),
    [sym_yield_expression] = STATE(577),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1528),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1528),
    [sym_jsx_element] = STATE(577),
    [sym_jsx_fragment] = STATE(577),
    [sym_jsx_opening_element] = STATE(975),
    [sym_jsx_self_closing_element] = STATE(577),
    [sym_class] = STATE(575),
    [sym_function] = STATE(575),
    [sym_generator_function] = STATE(575),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(577),
    [sym_await_expression] = STATE(577),
    [sym_member_expression] = STATE(449),
    [sym_subscript_expression] = STATE(449),
    [sym_assignment_expression] = STATE(577),
    [sym__augmented_assignment_lhs] = STATE(943),
    [sym_augmented_assignment_expression] = STATE(577),
    [sym__destructuring_pattern] = STATE(1528),
    [sym_ternary_expression] = STATE(577),
    [sym_binary_expression] = STATE(577),
    [sym_unary_expression] = STATE(577),
    [sym_update_expression] = STATE(577),
    [sym_sequence_expression] = STATE(1140),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1496),
    [aux_sym_export_statement_repeat1] = STATE(1182),
    [sym_identifier] = ACTIONS(321),
    [anon_sym_export] = ACTIONS(323),
    [anon_sym_LBRACE] = ACTIONS(327),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(335),
    [anon_sym_yield] = ACTIONS(339),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LT] = ACTIONS(585),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(349),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(353),
    [anon_sym_PLUS] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(355),
    [anon_sym_BANG] = ACTIONS(357),
    [anon_sym_TILDE] = ACTIONS(357),
    [anon_sym_typeof] = ACTIONS(355),
    [anon_sym_void] = ACTIONS(355),
    [anon_sym_delete] = ACTIONS(355),
    [anon_sym_PLUS_PLUS] = ACTIONS(359),
    [anon_sym_DASH_DASH] = ACTIONS(359),
    [anon_sym_DQUOTE] = ACTIONS(361),
    [anon_sym_SQUOTE] = ACTIONS(363),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(365),
    [sym_number] = ACTIONS(367),
    [sym_this] = ACTIONS(369),
    [sym_super] = ACTIONS(369),
    [sym_true] = ACTIONS(369),
    [sym_false] = ACTIONS(369),
    [sym_null] = ACTIONS(369),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(323),
    [anon_sym_get] = ACTIONS(323),
    [anon_sym_set] = ACTIONS(323),
  },
  [111] = {
    [sym_import] = STATE(575),
    [sym_parenthesized_expression] = STATE(449),
    [sym_expression] = STATE(790),
    [sym_primary_expression] = STATE(576),
    [sym_yield_expression] = STATE(577),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1528),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1528),
    [sym_jsx_element] = STATE(577),
    [sym_jsx_fragment] = STATE(577),
    [sym_jsx_opening_element] = STATE(975),
    [sym_jsx_self_closing_element] = STATE(577),
    [sym_class] = STATE(575),
    [sym_function] = STATE(575),
    [sym_generator_function] = STATE(575),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(577),
    [sym_await_expression] = STATE(577),
    [sym_member_expression] = STATE(449),
    [sym_subscript_expression] = STATE(449),
    [sym_assignment_expression] = STATE(577),
    [sym__augmented_assignment_lhs] = STATE(943),
    [sym_augmented_assignment_expression] = STATE(577),
    [sym__destructuring_pattern] = STATE(1528),
    [sym_ternary_expression] = STATE(577),
    [sym_binary_expression] = STATE(577),
    [sym_unary_expression] = STATE(577),
    [sym_update_expression] = STATE(577),
    [sym_sequence_expression] = STATE(1473),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1496),
    [aux_sym_export_statement_repeat1] = STATE(1182),
    [sym_identifier] = ACTIONS(321),
    [anon_sym_export] = ACTIONS(323),
    [anon_sym_LBRACE] = ACTIONS(327),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(335),
    [anon_sym_yield] = ACTIONS(339),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LT] = ACTIONS(585),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(349),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(353),
    [anon_sym_PLUS] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(355),
    [anon_sym_BANG] = ACTIONS(357),
    [anon_sym_TILDE] = ACTIONS(357),
    [anon_sym_typeof] = ACTIONS(355),
    [anon_sym_void] = ACTIONS(355),
    [anon_sym_delete] = ACTIONS(355),
    [anon_sym_PLUS_PLUS] = ACTIONS(359),
    [anon_sym_DASH_DASH] = ACTIONS(359),
    [anon_sym_DQUOTE] = ACTIONS(361),
    [anon_sym_SQUOTE] = ACTIONS(363),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(365),
    [sym_number] = ACTIONS(367),
    [sym_this] = ACTIONS(369),
    [sym_super] = ACTIONS(369),
    [sym_true] = ACTIONS(369),
    [sym_false] = ACTIONS(369),
    [sym_null] = ACTIONS(369),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(323),
    [anon_sym_get] = ACTIONS(323),
    [anon_sym_set] = ACTIONS(323),
  },
  [112] = {
    [sym_import] = STATE(575),
    [sym_parenthesized_expression] = STATE(430),
    [sym_expression] = STATE(835),
    [sym_primary_expression] = STATE(502),
    [sym_yield_expression] = STATE(577),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1497),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1497),
    [sym_jsx_element] = STATE(577),
    [sym_jsx_fragment] = STATE(577),
    [sym_jsx_opening_element] = STATE(975),
    [sym_jsx_self_closing_element] = STATE(577),
    [sym_class] = STATE(575),
    [sym_function] = STATE(575),
    [sym_generator_function] = STATE(575),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(500),
    [sym_await_expression] = STATE(577),
    [sym_member_expression] = STATE(430),
    [sym_subscript_expression] = STATE(430),
    [sym_assignment_expression] = STATE(577),
    [sym__augmented_assignment_lhs] = STATE(937),
    [sym_augmented_assignment_expression] = STATE(577),
    [sym__destructuring_pattern] = STATE(1497),
    [sym_ternary_expression] = STATE(577),
    [sym_binary_expression] = STATE(577),
    [sym_unary_expression] = STATE(577),
    [sym_update_expression] = STATE(577),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1496),
    [aux_sym_export_statement_repeat1] = STATE(1182),
    [sym_identifier] = ACTIONS(748),
    [anon_sym_export] = ACTIONS(750),
    [anon_sym_LBRACE] = ACTIONS(327),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(449),
    [anon_sym_yield] = ACTIONS(451),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LT] = ACTIONS(585),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_DOT] = ACTIONS(752),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(754),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(353),
    [anon_sym_PLUS] = ACTIONS(457),
    [anon_sym_DASH] = ACTIONS(457),
    [anon_sym_BANG] = ACTIONS(459),
    [anon_sym_TILDE] = ACTIONS(459),
    [anon_sym_typeof] = ACTIONS(457),
    [anon_sym_void] = ACTIONS(457),
    [anon_sym_delete] = ACTIONS(457),
    [anon_sym_PLUS_PLUS] = ACTIONS(461),
    [anon_sym_DASH_DASH] = ACTIONS(461),
    [anon_sym_DQUOTE] = ACTIONS(361),
    [anon_sym_SQUOTE] = ACTIONS(363),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(365),
    [sym_number] = ACTIONS(367),
    [sym_this] = ACTIONS(369),
    [sym_super] = ACTIONS(369),
    [sym_true] = ACTIONS(369),
    [sym_false] = ACTIONS(369),
    [sym_null] = ACTIONS(369),
    [sym_undefined] = ACTIONS(463),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(750),
    [anon_sym_get] = ACTIONS(750),
    [anon_sym_set] = ACTIONS(750),
  },
  [113] = {
    [sym_import] = STATE(575),
    [sym_parenthesized_expression] = STATE(449),
    [sym_expression] = STATE(763),
    [sym_primary_expression] = STATE(576),
    [sym_yield_expression] = STATE(577),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1528),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1528),
    [sym_jsx_element] = STATE(577),
    [sym_jsx_fragment] = STATE(577),
    [sym_jsx_opening_element] = STATE(975),
    [sym_jsx_self_closing_element] = STATE(577),
    [sym_class] = STATE(575),
    [sym_function] = STATE(575),
    [sym_generator_function] = STATE(575),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(577),
    [sym_await_expression] = STATE(577),
    [sym_member_expression] = STATE(449),
    [sym_subscript_expression] = STATE(449),
    [sym_assignment_expression] = STATE(577),
    [sym__augmented_assignment_lhs] = STATE(943),
    [sym_augmented_assignment_expression] = STATE(577),
    [sym__destructuring_pattern] = STATE(1528),
    [sym_ternary_expression] = STATE(577),
    [sym_binary_expression] = STATE(577),
    [sym_unary_expression] = STATE(577),
    [sym_update_expression] = STATE(577),
    [sym_sequence_expression] = STATE(1566),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1496),
    [aux_sym_export_statement_repeat1] = STATE(1182),
    [sym_identifier] = ACTIONS(321),
    [anon_sym_export] = ACTIONS(323),
    [anon_sym_LBRACE] = ACTIONS(327),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(335),
    [anon_sym_yield] = ACTIONS(339),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LT] = ACTIONS(585),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(349),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(353),
    [anon_sym_PLUS] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(355),
    [anon_sym_BANG] = ACTIONS(357),
    [anon_sym_TILDE] = ACTIONS(357),
    [anon_sym_typeof] = ACTIONS(355),
    [anon_sym_void] = ACTIONS(355),
    [anon_sym_delete] = ACTIONS(355),
    [anon_sym_PLUS_PLUS] = ACTIONS(359),
    [anon_sym_DASH_DASH] = ACTIONS(359),
    [anon_sym_DQUOTE] = ACTIONS(361),
    [anon_sym_SQUOTE] = ACTIONS(363),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(365),
    [sym_number] = ACTIONS(367),
    [sym_this] = ACTIONS(369),
    [sym_super] = ACTIONS(369),
    [sym_true] = ACTIONS(369),
    [sym_false] = ACTIONS(369),
    [sym_null] = ACTIONS(369),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(323),
    [anon_sym_get] = ACTIONS(323),
    [anon_sym_set] = ACTIONS(323),
  },
  [114] = {
    [sym_import] = STATE(721),
    [sym_statement_block] = STATE(711),
    [sym_parenthesized_expression] = STATE(466),
    [sym_expression] = STATE(623),
    [sym_primary_expression] = STATE(743),
    [sym_yield_expression] = STATE(740),
    [sym_object] = STATE(721),
    [sym_object_pattern] = STATE(1486),
    [sym_array] = STATE(721),
    [sym_array_pattern] = STATE(1486),
    [sym_jsx_element] = STATE(740),
    [sym_jsx_fragment] = STATE(740),
    [sym_jsx_opening_element] = STATE(972),
    [sym_jsx_self_closing_element] = STATE(740),
    [sym_class] = STATE(721),
    [sym_function] = STATE(721),
    [sym_generator_function] = STATE(721),
    [sym_arrow_function] = STATE(721),
    [sym_call_expression] = STATE(721),
    [sym_new_expression] = STATE(740),
    [sym_await_expression] = STATE(740),
    [sym_member_expression] = STATE(466),
    [sym_subscript_expression] = STATE(466),
    [sym_assignment_expression] = STATE(740),
    [sym__augmented_assignment_lhs] = STATE(940),
    [sym_augmented_assignment_expression] = STATE(740),
    [sym__destructuring_pattern] = STATE(1486),
    [sym_ternary_expression] = STATE(740),
    [sym_binary_expression] = STATE(740),
    [sym_unary_expression] = STATE(740),
    [sym_update_expression] = STATE(740),
    [sym_string] = STATE(721),
    [sym_template_string] = STATE(721),
    [sym_regex] = STATE(721),
    [sym_meta_property] = STATE(721),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1487),
    [aux_sym_export_statement_repeat1] = STATE(1154),
    [sym_identifier] = ACTIONS(373),
    [anon_sym_export] = ACTIONS(375),
    [anon_sym_LBRACE] = ACTIONS(746),
    [anon_sym_import] = ACTIONS(381),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(383),
    [anon_sym_yield] = ACTIONS(385),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(389),
    [anon_sym_class] = ACTIONS(391),
    [anon_sym_async] = ACTIONS(393),
    [anon_sym_function] = ACTIONS(395),
    [anon_sym_new] = ACTIONS(397),
    [anon_sym_PLUS] = ACTIONS(399),
    [anon_sym_DASH] = ACTIONS(399),
    [anon_sym_BANG] = ACTIONS(401),
    [anon_sym_TILDE] = ACTIONS(401),
    [anon_sym_typeof] = ACTIONS(399),
    [anon_sym_void] = ACTIONS(399),
    [anon_sym_delete] = ACTIONS(399),
    [anon_sym_PLUS_PLUS] = ACTIONS(403),
    [anon_sym_DASH_DASH] = ACTIONS(403),
    [anon_sym_DQUOTE] = ACTIONS(73),
    [anon_sym_SQUOTE] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(77),
    [sym_number] = ACTIONS(79),
    [sym_this] = ACTIONS(81),
    [sym_super] = ACTIONS(81),
    [sym_true] = ACTIONS(81),
    [sym_false] = ACTIONS(81),
    [sym_null] = ACTIONS(81),
    [sym_undefined] = ACTIONS(405),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(375),
    [anon_sym_get] = ACTIONS(375),
    [anon_sym_set] = ACTIONS(375),
  },
  [115] = {
    [sym_import] = STATE(721),
    [sym_statement_block] = STATE(729),
    [sym_parenthesized_expression] = STATE(466),
    [sym_expression] = STATE(622),
    [sym_primary_expression] = STATE(743),
    [sym_yield_expression] = STATE(740),
    [sym_object] = STATE(721),
    [sym_object_pattern] = STATE(1486),
    [sym_array] = STATE(721),
    [sym_array_pattern] = STATE(1486),
    [sym_jsx_element] = STATE(740),
    [sym_jsx_fragment] = STATE(740),
    [sym_jsx_opening_element] = STATE(972),
    [sym_jsx_self_closing_element] = STATE(740),
    [sym_class] = STATE(721),
    [sym_function] = STATE(721),
    [sym_generator_function] = STATE(721),
    [sym_arrow_function] = STATE(721),
    [sym_call_expression] = STATE(721),
    [sym_new_expression] = STATE(740),
    [sym_await_expression] = STATE(740),
    [sym_member_expression] = STATE(466),
    [sym_subscript_expression] = STATE(466),
    [sym_assignment_expression] = STATE(740),
    [sym__augmented_assignment_lhs] = STATE(940),
    [sym_augmented_assignment_expression] = STATE(740),
    [sym__destructuring_pattern] = STATE(1486),
    [sym_ternary_expression] = STATE(740),
    [sym_binary_expression] = STATE(740),
    [sym_unary_expression] = STATE(740),
    [sym_update_expression] = STATE(740),
    [sym_string] = STATE(721),
    [sym_template_string] = STATE(721),
    [sym_regex] = STATE(721),
    [sym_meta_property] = STATE(721),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1487),
    [aux_sym_export_statement_repeat1] = STATE(1154),
    [sym_identifier] = ACTIONS(373),
    [anon_sym_export] = ACTIONS(375),
    [anon_sym_LBRACE] = ACTIONS(746),
    [anon_sym_import] = ACTIONS(381),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(383),
    [anon_sym_yield] = ACTIONS(385),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(389),
    [anon_sym_class] = ACTIONS(391),
    [anon_sym_async] = ACTIONS(393),
    [anon_sym_function] = ACTIONS(395),
    [anon_sym_new] = ACTIONS(397),
    [anon_sym_PLUS] = ACTIONS(399),
    [anon_sym_DASH] = ACTIONS(399),
    [anon_sym_BANG] = ACTIONS(401),
    [anon_sym_TILDE] = ACTIONS(401),
    [anon_sym_typeof] = ACTIONS(399),
    [anon_sym_void] = ACTIONS(399),
    [anon_sym_delete] = ACTIONS(399),
    [anon_sym_PLUS_PLUS] = ACTIONS(403),
    [anon_sym_DASH_DASH] = ACTIONS(403),
    [anon_sym_DQUOTE] = ACTIONS(73),
    [anon_sym_SQUOTE] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(77),
    [sym_number] = ACTIONS(79),
    [sym_this] = ACTIONS(81),
    [sym_super] = ACTIONS(81),
    [sym_true] = ACTIONS(81),
    [sym_false] = ACTIONS(81),
    [sym_null] = ACTIONS(81),
    [sym_undefined] = ACTIONS(405),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(375),
    [anon_sym_get] = ACTIONS(375),
    [anon_sym_set] = ACTIONS(375),
  },
  [116] = {
    [sym_import] = STATE(575),
    [sym_statement_block] = STATE(528),
    [sym_parenthesized_expression] = STATE(493),
    [sym_expression] = STATE(828),
    [sym_primary_expression] = STATE(576),
    [sym_yield_expression] = STATE(577),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1580),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1580),
    [sym_jsx_element] = STATE(577),
    [sym_jsx_fragment] = STATE(577),
    [sym_jsx_opening_element] = STATE(975),
    [sym_jsx_self_closing_element] = STATE(577),
    [sym_class] = STATE(575),
    [sym_function] = STATE(575),
    [sym_generator_function] = STATE(575),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(577),
    [sym_await_expression] = STATE(577),
    [sym_member_expression] = STATE(493),
    [sym_subscript_expression] = STATE(493),
    [sym_assignment_expression] = STATE(577),
    [sym__augmented_assignment_lhs] = STATE(933),
    [sym_augmented_assignment_expression] = STATE(577),
    [sym__destructuring_pattern] = STATE(1580),
    [sym_ternary_expression] = STATE(577),
    [sym_binary_expression] = STATE(577),
    [sym_unary_expression] = STATE(577),
    [sym_update_expression] = STATE(577),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1555),
    [aux_sym_export_statement_repeat1] = STATE(1182),
    [sym_identifier] = ACTIONS(415),
    [anon_sym_export] = ACTIONS(417),
    [anon_sym_LBRACE] = ACTIONS(744),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(423),
    [anon_sym_yield] = ACTIONS(425),
    [anon_sym_LBRACK] = ACTIONS(427),
    [anon_sym_LT] = ACTIONS(585),
    [anon_sym_SLASH] = ACTIONS(429),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(431),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(433),
    [anon_sym_PLUS] = ACTIONS(435),
    [anon_sym_DASH] = ACTIONS(435),
    [anon_sym_BANG] = ACTIONS(437),
    [anon_sym_TILDE] = ACTIONS(437),
    [anon_sym_typeof] = ACTIONS(435),
    [anon_sym_void] = ACTIONS(435),
    [anon_sym_delete] = ACTIONS(435),
    [anon_sym_PLUS_PLUS] = ACTIONS(439),
    [anon_sym_DASH_DASH] = ACTIONS(439),
    [anon_sym_DQUOTE] = ACTIONS(361),
    [anon_sym_SQUOTE] = ACTIONS(363),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(365),
    [sym_number] = ACTIONS(367),
    [sym_this] = ACTIONS(369),
    [sym_super] = ACTIONS(369),
    [sym_true] = ACTIONS(369),
    [sym_false] = ACTIONS(369),
    [sym_null] = ACTIONS(369),
    [sym_undefined] = ACTIONS(441),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(417),
    [anon_sym_get] = ACTIONS(417),
    [anon_sym_set] = ACTIONS(417),
  },
  [117] = {
    [sym_import] = STATE(721),
    [sym_statement_block] = STATE(736),
    [sym_parenthesized_expression] = STATE(466),
    [sym_expression] = STATE(621),
    [sym_primary_expression] = STATE(743),
    [sym_yield_expression] = STATE(740),
    [sym_object] = STATE(721),
    [sym_object_pattern] = STATE(1486),
    [sym_array] = STATE(721),
    [sym_array_pattern] = STATE(1486),
    [sym_jsx_element] = STATE(740),
    [sym_jsx_fragment] = STATE(740),
    [sym_jsx_opening_element] = STATE(972),
    [sym_jsx_self_closing_element] = STATE(740),
    [sym_class] = STATE(721),
    [sym_function] = STATE(721),
    [sym_generator_function] = STATE(721),
    [sym_arrow_function] = STATE(721),
    [sym_call_expression] = STATE(721),
    [sym_new_expression] = STATE(740),
    [sym_await_expression] = STATE(740),
    [sym_member_expression] = STATE(466),
    [sym_subscript_expression] = STATE(466),
    [sym_assignment_expression] = STATE(740),
    [sym__augmented_assignment_lhs] = STATE(940),
    [sym_augmented_assignment_expression] = STATE(740),
    [sym__destructuring_pattern] = STATE(1486),
    [sym_ternary_expression] = STATE(740),
    [sym_binary_expression] = STATE(740),
    [sym_unary_expression] = STATE(740),
    [sym_update_expression] = STATE(740),
    [sym_string] = STATE(721),
    [sym_template_string] = STATE(721),
    [sym_regex] = STATE(721),
    [sym_meta_property] = STATE(721),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1487),
    [aux_sym_export_statement_repeat1] = STATE(1154),
    [sym_identifier] = ACTIONS(373),
    [anon_sym_export] = ACTIONS(375),
    [anon_sym_LBRACE] = ACTIONS(746),
    [anon_sym_import] = ACTIONS(381),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(383),
    [anon_sym_yield] = ACTIONS(385),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(389),
    [anon_sym_class] = ACTIONS(391),
    [anon_sym_async] = ACTIONS(393),
    [anon_sym_function] = ACTIONS(395),
    [anon_sym_new] = ACTIONS(397),
    [anon_sym_PLUS] = ACTIONS(399),
    [anon_sym_DASH] = ACTIONS(399),
    [anon_sym_BANG] = ACTIONS(401),
    [anon_sym_TILDE] = ACTIONS(401),
    [anon_sym_typeof] = ACTIONS(399),
    [anon_sym_void] = ACTIONS(399),
    [anon_sym_delete] = ACTIONS(399),
    [anon_sym_PLUS_PLUS] = ACTIONS(403),
    [anon_sym_DASH_DASH] = ACTIONS(403),
    [anon_sym_DQUOTE] = ACTIONS(73),
    [anon_sym_SQUOTE] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(77),
    [sym_number] = ACTIONS(79),
    [sym_this] = ACTIONS(81),
    [sym_super] = ACTIONS(81),
    [sym_true] = ACTIONS(81),
    [sym_false] = ACTIONS(81),
    [sym_null] = ACTIONS(81),
    [sym_undefined] = ACTIONS(405),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(375),
    [anon_sym_get] = ACTIONS(375),
    [anon_sym_set] = ACTIONS(375),
  },
  [118] = {
    [sym_import] = STATE(575),
    [sym_statement_block] = STATE(514),
    [sym_parenthesized_expression] = STATE(493),
    [sym_expression] = STATE(799),
    [sym_primary_expression] = STATE(576),
    [sym_yield_expression] = STATE(577),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1580),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1580),
    [sym_jsx_element] = STATE(577),
    [sym_jsx_fragment] = STATE(577),
    [sym_jsx_opening_element] = STATE(975),
    [sym_jsx_self_closing_element] = STATE(577),
    [sym_class] = STATE(575),
    [sym_function] = STATE(575),
    [sym_generator_function] = STATE(575),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(577),
    [sym_await_expression] = STATE(577),
    [sym_member_expression] = STATE(493),
    [sym_subscript_expression] = STATE(493),
    [sym_assignment_expression] = STATE(577),
    [sym__augmented_assignment_lhs] = STATE(933),
    [sym_augmented_assignment_expression] = STATE(577),
    [sym__destructuring_pattern] = STATE(1580),
    [sym_ternary_expression] = STATE(577),
    [sym_binary_expression] = STATE(577),
    [sym_unary_expression] = STATE(577),
    [sym_update_expression] = STATE(577),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1555),
    [aux_sym_export_statement_repeat1] = STATE(1182),
    [sym_identifier] = ACTIONS(415),
    [anon_sym_export] = ACTIONS(417),
    [anon_sym_LBRACE] = ACTIONS(744),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(423),
    [anon_sym_yield] = ACTIONS(425),
    [anon_sym_LBRACK] = ACTIONS(427),
    [anon_sym_LT] = ACTIONS(585),
    [anon_sym_SLASH] = ACTIONS(429),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(431),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(433),
    [anon_sym_PLUS] = ACTIONS(435),
    [anon_sym_DASH] = ACTIONS(435),
    [anon_sym_BANG] = ACTIONS(437),
    [anon_sym_TILDE] = ACTIONS(437),
    [anon_sym_typeof] = ACTIONS(435),
    [anon_sym_void] = ACTIONS(435),
    [anon_sym_delete] = ACTIONS(435),
    [anon_sym_PLUS_PLUS] = ACTIONS(439),
    [anon_sym_DASH_DASH] = ACTIONS(439),
    [anon_sym_DQUOTE] = ACTIONS(361),
    [anon_sym_SQUOTE] = ACTIONS(363),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(365),
    [sym_number] = ACTIONS(367),
    [sym_this] = ACTIONS(369),
    [sym_super] = ACTIONS(369),
    [sym_true] = ACTIONS(369),
    [sym_false] = ACTIONS(369),
    [sym_null] = ACTIONS(369),
    [sym_undefined] = ACTIONS(441),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(417),
    [anon_sym_get] = ACTIONS(417),
    [anon_sym_set] = ACTIONS(417),
  },
  [119] = {
    [sym_import] = STATE(575),
    [sym_parenthesized_expression] = STATE(449),
    [sym_expression] = STATE(779),
    [sym_primary_expression] = STATE(576),
    [sym_yield_expression] = STATE(577),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1528),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1528),
    [sym_jsx_element] = STATE(577),
    [sym_jsx_fragment] = STATE(577),
    [sym_jsx_opening_element] = STATE(975),
    [sym_jsx_self_closing_element] = STATE(577),
    [sym_class] = STATE(575),
    [sym_function] = STATE(575),
    [sym_generator_function] = STATE(575),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(577),
    [sym_await_expression] = STATE(577),
    [sym_member_expression] = STATE(449),
    [sym_subscript_expression] = STATE(449),
    [sym_assignment_expression] = STATE(577),
    [sym__augmented_assignment_lhs] = STATE(943),
    [sym_augmented_assignment_expression] = STATE(577),
    [sym__destructuring_pattern] = STATE(1528),
    [sym_ternary_expression] = STATE(577),
    [sym_binary_expression] = STATE(577),
    [sym_unary_expression] = STATE(577),
    [sym_update_expression] = STATE(577),
    [sym_sequence_expression] = STATE(1567),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1496),
    [aux_sym_export_statement_repeat1] = STATE(1182),
    [sym_identifier] = ACTIONS(321),
    [anon_sym_export] = ACTIONS(323),
    [anon_sym_LBRACE] = ACTIONS(327),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(335),
    [anon_sym_yield] = ACTIONS(339),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LT] = ACTIONS(585),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(349),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(353),
    [anon_sym_PLUS] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(355),
    [anon_sym_BANG] = ACTIONS(357),
    [anon_sym_TILDE] = ACTIONS(357),
    [anon_sym_typeof] = ACTIONS(355),
    [anon_sym_void] = ACTIONS(355),
    [anon_sym_delete] = ACTIONS(355),
    [anon_sym_PLUS_PLUS] = ACTIONS(359),
    [anon_sym_DASH_DASH] = ACTIONS(359),
    [anon_sym_DQUOTE] = ACTIONS(361),
    [anon_sym_SQUOTE] = ACTIONS(363),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(365),
    [sym_number] = ACTIONS(367),
    [sym_this] = ACTIONS(369),
    [sym_super] = ACTIONS(369),
    [sym_true] = ACTIONS(369),
    [sym_false] = ACTIONS(369),
    [sym_null] = ACTIONS(369),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(323),
    [anon_sym_get] = ACTIONS(323),
    [anon_sym_set] = ACTIONS(323),
  },
  [120] = {
    [sym_import] = STATE(721),
    [sym_statement_block] = STATE(669),
    [sym_parenthesized_expression] = STATE(466),
    [sym_expression] = STATE(660),
    [sym_primary_expression] = STATE(743),
    [sym_yield_expression] = STATE(740),
    [sym_object] = STATE(721),
    [sym_object_pattern] = STATE(1486),
    [sym_array] = STATE(721),
    [sym_array_pattern] = STATE(1486),
    [sym_jsx_element] = STATE(740),
    [sym_jsx_fragment] = STATE(740),
    [sym_jsx_opening_element] = STATE(972),
    [sym_jsx_self_closing_element] = STATE(740),
    [sym_class] = STATE(721),
    [sym_function] = STATE(721),
    [sym_generator_function] = STATE(721),
    [sym_arrow_function] = STATE(721),
    [sym_call_expression] = STATE(721),
    [sym_new_expression] = STATE(740),
    [sym_await_expression] = STATE(740),
    [sym_member_expression] = STATE(466),
    [sym_subscript_expression] = STATE(466),
    [sym_assignment_expression] = STATE(740),
    [sym__augmented_assignment_lhs] = STATE(940),
    [sym_augmented_assignment_expression] = STATE(740),
    [sym__destructuring_pattern] = STATE(1486),
    [sym_ternary_expression] = STATE(740),
    [sym_binary_expression] = STATE(740),
    [sym_unary_expression] = STATE(740),
    [sym_update_expression] = STATE(740),
    [sym_string] = STATE(721),
    [sym_template_string] = STATE(721),
    [sym_regex] = STATE(721),
    [sym_meta_property] = STATE(721),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1487),
    [aux_sym_export_statement_repeat1] = STATE(1154),
    [sym_identifier] = ACTIONS(373),
    [anon_sym_export] = ACTIONS(375),
    [anon_sym_LBRACE] = ACTIONS(746),
    [anon_sym_import] = ACTIONS(381),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(383),
    [anon_sym_yield] = ACTIONS(385),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(389),
    [anon_sym_class] = ACTIONS(391),
    [anon_sym_async] = ACTIONS(393),
    [anon_sym_function] = ACTIONS(395),
    [anon_sym_new] = ACTIONS(397),
    [anon_sym_PLUS] = ACTIONS(399),
    [anon_sym_DASH] = ACTIONS(399),
    [anon_sym_BANG] = ACTIONS(401),
    [anon_sym_TILDE] = ACTIONS(401),
    [anon_sym_typeof] = ACTIONS(399),
    [anon_sym_void] = ACTIONS(399),
    [anon_sym_delete] = ACTIONS(399),
    [anon_sym_PLUS_PLUS] = ACTIONS(403),
    [anon_sym_DASH_DASH] = ACTIONS(403),
    [anon_sym_DQUOTE] = ACTIONS(73),
    [anon_sym_SQUOTE] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(77),
    [sym_number] = ACTIONS(79),
    [sym_this] = ACTIONS(81),
    [sym_super] = ACTIONS(81),
    [sym_true] = ACTIONS(81),
    [sym_false] = ACTIONS(81),
    [sym_null] = ACTIONS(81),
    [sym_undefined] = ACTIONS(405),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(375),
    [anon_sym_get] = ACTIONS(375),
    [anon_sym_set] = ACTIONS(375),
  },
  [121] = {
    [sym_import] = STATE(575),
    [sym_statement_block] = STATE(551),
    [sym_parenthesized_expression] = STATE(493),
    [sym_expression] = STATE(815),
    [sym_primary_expression] = STATE(576),
    [sym_yield_expression] = STATE(577),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1580),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1580),
    [sym_jsx_element] = STATE(577),
    [sym_jsx_fragment] = STATE(577),
    [sym_jsx_opening_element] = STATE(975),
    [sym_jsx_self_closing_element] = STATE(577),
    [sym_class] = STATE(575),
    [sym_function] = STATE(575),
    [sym_generator_function] = STATE(575),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(577),
    [sym_await_expression] = STATE(577),
    [sym_member_expression] = STATE(493),
    [sym_subscript_expression] = STATE(493),
    [sym_assignment_expression] = STATE(577),
    [sym__augmented_assignment_lhs] = STATE(933),
    [sym_augmented_assignment_expression] = STATE(577),
    [sym__destructuring_pattern] = STATE(1580),
    [sym_ternary_expression] = STATE(577),
    [sym_binary_expression] = STATE(577),
    [sym_unary_expression] = STATE(577),
    [sym_update_expression] = STATE(577),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1555),
    [aux_sym_export_statement_repeat1] = STATE(1182),
    [sym_identifier] = ACTIONS(415),
    [anon_sym_export] = ACTIONS(417),
    [anon_sym_LBRACE] = ACTIONS(744),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(423),
    [anon_sym_yield] = ACTIONS(425),
    [anon_sym_LBRACK] = ACTIONS(427),
    [anon_sym_LT] = ACTIONS(585),
    [anon_sym_SLASH] = ACTIONS(429),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(431),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(433),
    [anon_sym_PLUS] = ACTIONS(435),
    [anon_sym_DASH] = ACTIONS(435),
    [anon_sym_BANG] = ACTIONS(437),
    [anon_sym_TILDE] = ACTIONS(437),
    [anon_sym_typeof] = ACTIONS(435),
    [anon_sym_void] = ACTIONS(435),
    [anon_sym_delete] = ACTIONS(435),
    [anon_sym_PLUS_PLUS] = ACTIONS(439),
    [anon_sym_DASH_DASH] = ACTIONS(439),
    [anon_sym_DQUOTE] = ACTIONS(361),
    [anon_sym_SQUOTE] = ACTIONS(363),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(365),
    [sym_number] = ACTIONS(367),
    [sym_this] = ACTIONS(369),
    [sym_super] = ACTIONS(369),
    [sym_true] = ACTIONS(369),
    [sym_false] = ACTIONS(369),
    [sym_null] = ACTIONS(369),
    [sym_undefined] = ACTIONS(441),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(417),
    [anon_sym_get] = ACTIONS(417),
    [anon_sym_set] = ACTIONS(417),
  },
  [122] = {
    [sym_import] = STATE(575),
    [sym_statement_block] = STATE(551),
    [sym_parenthesized_expression] = STATE(449),
    [sym_expression] = STATE(547),
    [sym_primary_expression] = STATE(576),
    [sym_yield_expression] = STATE(577),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1528),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1528),
    [sym_jsx_element] = STATE(577),
    [sym_jsx_fragment] = STATE(577),
    [sym_jsx_opening_element] = STATE(975),
    [sym_jsx_self_closing_element] = STATE(577),
    [sym_class] = STATE(575),
    [sym_function] = STATE(575),
    [sym_generator_function] = STATE(575),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(577),
    [sym_await_expression] = STATE(577),
    [sym_member_expression] = STATE(449),
    [sym_subscript_expression] = STATE(449),
    [sym_assignment_expression] = STATE(577),
    [sym__augmented_assignment_lhs] = STATE(943),
    [sym_augmented_assignment_expression] = STATE(577),
    [sym__destructuring_pattern] = STATE(1528),
    [sym_ternary_expression] = STATE(577),
    [sym_binary_expression] = STATE(577),
    [sym_unary_expression] = STATE(577),
    [sym_update_expression] = STATE(577),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1496),
    [aux_sym_export_statement_repeat1] = STATE(1182),
    [sym_identifier] = ACTIONS(321),
    [anon_sym_export] = ACTIONS(323),
    [anon_sym_LBRACE] = ACTIONS(742),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(335),
    [anon_sym_yield] = ACTIONS(339),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LT] = ACTIONS(585),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(349),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(353),
    [anon_sym_PLUS] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(355),
    [anon_sym_BANG] = ACTIONS(357),
    [anon_sym_TILDE] = ACTIONS(357),
    [anon_sym_typeof] = ACTIONS(355),
    [anon_sym_void] = ACTIONS(355),
    [anon_sym_delete] = ACTIONS(355),
    [anon_sym_PLUS_PLUS] = ACTIONS(359),
    [anon_sym_DASH_DASH] = ACTIONS(359),
    [anon_sym_DQUOTE] = ACTIONS(361),
    [anon_sym_SQUOTE] = ACTIONS(363),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(365),
    [sym_number] = ACTIONS(367),
    [sym_this] = ACTIONS(369),
    [sym_super] = ACTIONS(369),
    [sym_true] = ACTIONS(369),
    [sym_false] = ACTIONS(369),
    [sym_null] = ACTIONS(369),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(323),
    [anon_sym_get] = ACTIONS(323),
    [anon_sym_set] = ACTIONS(323),
  },
  [123] = {
    [sym_import] = STATE(575),
    [sym_parenthesized_expression] = STATE(449),
    [sym_expression] = STATE(788),
    [sym_primary_expression] = STATE(576),
    [sym_yield_expression] = STATE(577),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1528),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1528),
    [sym_jsx_element] = STATE(577),
    [sym_jsx_fragment] = STATE(577),
    [sym_jsx_opening_element] = STATE(975),
    [sym_jsx_self_closing_element] = STATE(577),
    [sym_class] = STATE(575),
    [sym_function] = STATE(575),
    [sym_generator_function] = STATE(575),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(577),
    [sym_await_expression] = STATE(577),
    [sym_member_expression] = STATE(449),
    [sym_subscript_expression] = STATE(449),
    [sym_assignment_expression] = STATE(577),
    [sym__augmented_assignment_lhs] = STATE(943),
    [sym_augmented_assignment_expression] = STATE(577),
    [sym__destructuring_pattern] = STATE(1528),
    [sym_ternary_expression] = STATE(577),
    [sym_binary_expression] = STATE(577),
    [sym_unary_expression] = STATE(577),
    [sym_update_expression] = STATE(577),
    [sym_sequence_expression] = STATE(1507),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1496),
    [aux_sym_export_statement_repeat1] = STATE(1182),
    [sym_identifier] = ACTIONS(321),
    [anon_sym_export] = ACTIONS(323),
    [anon_sym_LBRACE] = ACTIONS(327),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(335),
    [anon_sym_yield] = ACTIONS(339),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LT] = ACTIONS(585),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(349),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(353),
    [anon_sym_PLUS] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(355),
    [anon_sym_BANG] = ACTIONS(357),
    [anon_sym_TILDE] = ACTIONS(357),
    [anon_sym_typeof] = ACTIONS(355),
    [anon_sym_void] = ACTIONS(355),
    [anon_sym_delete] = ACTIONS(355),
    [anon_sym_PLUS_PLUS] = ACTIONS(359),
    [anon_sym_DASH_DASH] = ACTIONS(359),
    [anon_sym_DQUOTE] = ACTIONS(361),
    [anon_sym_SQUOTE] = ACTIONS(363),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(365),
    [sym_number] = ACTIONS(367),
    [sym_this] = ACTIONS(369),
    [sym_super] = ACTIONS(369),
    [sym_true] = ACTIONS(369),
    [sym_false] = ACTIONS(369),
    [sym_null] = ACTIONS(369),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(323),
    [anon_sym_get] = ACTIONS(323),
    [anon_sym_set] = ACTIONS(323),
  },
  [124] = {
    [sym_import] = STATE(575),
    [sym_statement_block] = STATE(514),
    [sym_parenthesized_expression] = STATE(430),
    [sym_expression] = STATE(791),
    [sym_primary_expression] = STATE(576),
    [sym_yield_expression] = STATE(577),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1497),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1497),
    [sym_jsx_element] = STATE(577),
    [sym_jsx_fragment] = STATE(577),
    [sym_jsx_opening_element] = STATE(975),
    [sym_jsx_self_closing_element] = STATE(577),
    [sym_class] = STATE(575),
    [sym_function] = STATE(575),
    [sym_generator_function] = STATE(575),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(577),
    [sym_await_expression] = STATE(577),
    [sym_member_expression] = STATE(430),
    [sym_subscript_expression] = STATE(430),
    [sym_assignment_expression] = STATE(577),
    [sym__augmented_assignment_lhs] = STATE(937),
    [sym_augmented_assignment_expression] = STATE(577),
    [sym__destructuring_pattern] = STATE(1497),
    [sym_ternary_expression] = STATE(577),
    [sym_binary_expression] = STATE(577),
    [sym_unary_expression] = STATE(577),
    [sym_update_expression] = STATE(577),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1533),
    [aux_sym_export_statement_repeat1] = STATE(1182),
    [sym_identifier] = ACTIONS(443),
    [anon_sym_export] = ACTIONS(445),
    [anon_sym_LBRACE] = ACTIONS(744),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(449),
    [anon_sym_yield] = ACTIONS(451),
    [anon_sym_LBRACK] = ACTIONS(427),
    [anon_sym_LT] = ACTIONS(585),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(453),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(455),
    [anon_sym_PLUS] = ACTIONS(457),
    [anon_sym_DASH] = ACTIONS(457),
    [anon_sym_BANG] = ACTIONS(459),
    [anon_sym_TILDE] = ACTIONS(459),
    [anon_sym_typeof] = ACTIONS(457),
    [anon_sym_void] = ACTIONS(457),
    [anon_sym_delete] = ACTIONS(457),
    [anon_sym_PLUS_PLUS] = ACTIONS(461),
    [anon_sym_DASH_DASH] = ACTIONS(461),
    [anon_sym_DQUOTE] = ACTIONS(361),
    [anon_sym_SQUOTE] = ACTIONS(363),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(365),
    [sym_number] = ACTIONS(367),
    [sym_this] = ACTIONS(369),
    [sym_super] = ACTIONS(369),
    [sym_true] = ACTIONS(369),
    [sym_false] = ACTIONS(369),
    [sym_null] = ACTIONS(369),
    [sym_undefined] = ACTIONS(463),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(445),
    [anon_sym_get] = ACTIONS(445),
    [anon_sym_set] = ACTIONS(445),
  },
  [125] = {
    [sym_import] = STATE(721),
    [sym_parenthesized_expression] = STATE(453),
    [sym_expression] = STATE(837),
    [sym_primary_expression] = STATE(608),
    [sym_yield_expression] = STATE(577),
    [sym_object] = STATE(721),
    [sym_object_pattern] = STATE(1497),
    [sym_array] = STATE(721),
    [sym_array_pattern] = STATE(1497),
    [sym_jsx_element] = STATE(577),
    [sym_jsx_fragment] = STATE(577),
    [sym_jsx_opening_element] = STATE(975),
    [sym_jsx_self_closing_element] = STATE(577),
    [sym_class] = STATE(721),
    [sym_function] = STATE(721),
    [sym_generator_function] = STATE(721),
    [sym_arrow_function] = STATE(721),
    [sym_call_expression] = STATE(721),
    [sym_new_expression] = STATE(609),
    [sym_await_expression] = STATE(577),
    [sym_member_expression] = STATE(453),
    [sym_subscript_expression] = STATE(453),
    [sym_assignment_expression] = STATE(577),
    [sym__augmented_assignment_lhs] = STATE(937),
    [sym_augmented_assignment_expression] = STATE(577),
    [sym__destructuring_pattern] = STATE(1497),
    [sym_ternary_expression] = STATE(577),
    [sym_binary_expression] = STATE(577),
    [sym_unary_expression] = STATE(577),
    [sym_update_expression] = STATE(577),
    [sym_string] = STATE(721),
    [sym_template_string] = STATE(721),
    [sym_regex] = STATE(721),
    [sym_meta_property] = STATE(721),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1487),
    [aux_sym_export_statement_repeat1] = STATE(1154),
    [sym_identifier] = ACTIONS(756),
    [anon_sym_export] = ACTIONS(758),
    [anon_sym_LBRACE] = ACTIONS(379),
    [anon_sym_import] = ACTIONS(381),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(449),
    [anon_sym_yield] = ACTIONS(451),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(585),
    [anon_sym_SLASH] = ACTIONS(389),
    [anon_sym_DOT] = ACTIONS(760),
    [anon_sym_class] = ACTIONS(391),
    [anon_sym_async] = ACTIONS(762),
    [anon_sym_function] = ACTIONS(395),
    [anon_sym_new] = ACTIONS(397),
    [anon_sym_PLUS] = ACTIONS(457),
    [anon_sym_DASH] = ACTIONS(457),
    [anon_sym_BANG] = ACTIONS(459),
    [anon_sym_TILDE] = ACTIONS(459),
    [anon_sym_typeof] = ACTIONS(457),
    [anon_sym_void] = ACTIONS(457),
    [anon_sym_delete] = ACTIONS(457),
    [anon_sym_PLUS_PLUS] = ACTIONS(461),
    [anon_sym_DASH_DASH] = ACTIONS(461),
    [anon_sym_DQUOTE] = ACTIONS(73),
    [anon_sym_SQUOTE] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(77),
    [sym_number] = ACTIONS(79),
    [sym_this] = ACTIONS(81),
    [sym_super] = ACTIONS(81),
    [sym_true] = ACTIONS(81),
    [sym_false] = ACTIONS(81),
    [sym_null] = ACTIONS(81),
    [sym_undefined] = ACTIONS(764),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(758),
    [anon_sym_get] = ACTIONS(758),
    [anon_sym_set] = ACTIONS(758),
  },
  [126] = {
    [sym_import] = STATE(721),
    [sym_statement_block] = STATE(722),
    [sym_parenthesized_expression] = STATE(479),
    [sym_expression] = STATE(631),
    [sym_primary_expression] = STATE(743),
    [sym_yield_expression] = STATE(740),
    [sym_object] = STATE(721),
    [sym_object_pattern] = STATE(1548),
    [sym_array] = STATE(721),
    [sym_array_pattern] = STATE(1548),
    [sym_jsx_element] = STATE(740),
    [sym_jsx_fragment] = STATE(740),
    [sym_jsx_opening_element] = STATE(972),
    [sym_jsx_self_closing_element] = STATE(740),
    [sym_class] = STATE(721),
    [sym_function] = STATE(721),
    [sym_generator_function] = STATE(721),
    [sym_arrow_function] = STATE(721),
    [sym_call_expression] = STATE(721),
    [sym_new_expression] = STATE(740),
    [sym_await_expression] = STATE(740),
    [sym_member_expression] = STATE(479),
    [sym_subscript_expression] = STATE(479),
    [sym_assignment_expression] = STATE(740),
    [sym__augmented_assignment_lhs] = STATE(942),
    [sym_augmented_assignment_expression] = STATE(740),
    [sym__destructuring_pattern] = STATE(1548),
    [sym_ternary_expression] = STATE(740),
    [sym_binary_expression] = STATE(740),
    [sym_unary_expression] = STATE(740),
    [sym_update_expression] = STATE(740),
    [sym_string] = STATE(721),
    [sym_template_string] = STATE(721),
    [sym_regex] = STATE(721),
    [sym_meta_property] = STATE(721),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1546),
    [aux_sym_export_statement_repeat1] = STATE(1154),
    [sym_identifier] = ACTIONS(407),
    [anon_sym_export] = ACTIONS(409),
    [anon_sym_LBRACE] = ACTIONS(746),
    [anon_sym_import] = ACTIONS(381),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(391),
    [anon_sym_async] = ACTIONS(413),
    [anon_sym_function] = ACTIONS(395),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(67),
    [anon_sym_void] = ACTIONS(67),
    [anon_sym_delete] = ACTIONS(67),
    [anon_sym_PLUS_PLUS] = ACTIONS(71),
    [anon_sym_DASH_DASH] = ACTIONS(71),
    [anon_sym_DQUOTE] = ACTIONS(73),
    [anon_sym_SQUOTE] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(77),
    [sym_number] = ACTIONS(79),
    [sym_this] = ACTIONS(81),
    [sym_super] = ACTIONS(81),
    [sym_true] = ACTIONS(81),
    [sym_false] = ACTIONS(81),
    [sym_null] = ACTIONS(81),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(409),
    [anon_sym_get] = ACTIONS(409),
    [anon_sym_set] = ACTIONS(409),
  },
  [127] = {
    [sym_import] = STATE(575),
    [sym_statement_block] = STATE(528),
    [sym_parenthesized_expression] = STATE(449),
    [sym_expression] = STATE(527),
    [sym_primary_expression] = STATE(576),
    [sym_yield_expression] = STATE(577),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1528),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1528),
    [sym_jsx_element] = STATE(577),
    [sym_jsx_fragment] = STATE(577),
    [sym_jsx_opening_element] = STATE(975),
    [sym_jsx_self_closing_element] = STATE(577),
    [sym_class] = STATE(575),
    [sym_function] = STATE(575),
    [sym_generator_function] = STATE(575),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(577),
    [sym_await_expression] = STATE(577),
    [sym_member_expression] = STATE(449),
    [sym_subscript_expression] = STATE(449),
    [sym_assignment_expression] = STATE(577),
    [sym__augmented_assignment_lhs] = STATE(943),
    [sym_augmented_assignment_expression] = STATE(577),
    [sym__destructuring_pattern] = STATE(1528),
    [sym_ternary_expression] = STATE(577),
    [sym_binary_expression] = STATE(577),
    [sym_unary_expression] = STATE(577),
    [sym_update_expression] = STATE(577),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1496),
    [aux_sym_export_statement_repeat1] = STATE(1182),
    [sym_identifier] = ACTIONS(321),
    [anon_sym_export] = ACTIONS(323),
    [anon_sym_LBRACE] = ACTIONS(742),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(335),
    [anon_sym_yield] = ACTIONS(339),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LT] = ACTIONS(585),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(349),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(353),
    [anon_sym_PLUS] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(355),
    [anon_sym_BANG] = ACTIONS(357),
    [anon_sym_TILDE] = ACTIONS(357),
    [anon_sym_typeof] = ACTIONS(355),
    [anon_sym_void] = ACTIONS(355),
    [anon_sym_delete] = ACTIONS(355),
    [anon_sym_PLUS_PLUS] = ACTIONS(359),
    [anon_sym_DASH_DASH] = ACTIONS(359),
    [anon_sym_DQUOTE] = ACTIONS(361),
    [anon_sym_SQUOTE] = ACTIONS(363),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(365),
    [sym_number] = ACTIONS(367),
    [sym_this] = ACTIONS(369),
    [sym_super] = ACTIONS(369),
    [sym_true] = ACTIONS(369),
    [sym_false] = ACTIONS(369),
    [sym_null] = ACTIONS(369),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(323),
    [anon_sym_get] = ACTIONS(323),
    [anon_sym_set] = ACTIONS(323),
  },
  [128] = {
    [sym_import] = STATE(721),
    [sym_statement_block] = STATE(711),
    [sym_parenthesized_expression] = STATE(479),
    [sym_expression] = STATE(629),
    [sym_primary_expression] = STATE(743),
    [sym_yield_expression] = STATE(740),
    [sym_object] = STATE(721),
    [sym_object_pattern] = STATE(1548),
    [sym_array] = STATE(721),
    [sym_array_pattern] = STATE(1548),
    [sym_jsx_element] = STATE(740),
    [sym_jsx_fragment] = STATE(740),
    [sym_jsx_opening_element] = STATE(972),
    [sym_jsx_self_closing_element] = STATE(740),
    [sym_class] = STATE(721),
    [sym_function] = STATE(721),
    [sym_generator_function] = STATE(721),
    [sym_arrow_function] = STATE(721),
    [sym_call_expression] = STATE(721),
    [sym_new_expression] = STATE(740),
    [sym_await_expression] = STATE(740),
    [sym_member_expression] = STATE(479),
    [sym_subscript_expression] = STATE(479),
    [sym_assignment_expression] = STATE(740),
    [sym__augmented_assignment_lhs] = STATE(942),
    [sym_augmented_assignment_expression] = STATE(740),
    [sym__destructuring_pattern] = STATE(1548),
    [sym_ternary_expression] = STATE(740),
    [sym_binary_expression] = STATE(740),
    [sym_unary_expression] = STATE(740),
    [sym_update_expression] = STATE(740),
    [sym_string] = STATE(721),
    [sym_template_string] = STATE(721),
    [sym_regex] = STATE(721),
    [sym_meta_property] = STATE(721),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1546),
    [aux_sym_export_statement_repeat1] = STATE(1154),
    [sym_identifier] = ACTIONS(407),
    [anon_sym_export] = ACTIONS(409),
    [anon_sym_LBRACE] = ACTIONS(746),
    [anon_sym_import] = ACTIONS(381),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(391),
    [anon_sym_async] = ACTIONS(413),
    [anon_sym_function] = ACTIONS(395),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(67),
    [anon_sym_void] = ACTIONS(67),
    [anon_sym_delete] = ACTIONS(67),
    [anon_sym_PLUS_PLUS] = ACTIONS(71),
    [anon_sym_DASH_DASH] = ACTIONS(71),
    [anon_sym_DQUOTE] = ACTIONS(73),
    [anon_sym_SQUOTE] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(77),
    [sym_number] = ACTIONS(79),
    [sym_this] = ACTIONS(81),
    [sym_super] = ACTIONS(81),
    [sym_true] = ACTIONS(81),
    [sym_false] = ACTIONS(81),
    [sym_null] = ACTIONS(81),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(409),
    [anon_sym_get] = ACTIONS(409),
    [anon_sym_set] = ACTIONS(409),
  },
  [129] = {
    [sym_import] = STATE(575),
    [sym_statement_block] = STATE(509),
    [sym_parenthesized_expression] = STATE(430),
    [sym_expression] = STATE(782),
    [sym_primary_expression] = STATE(576),
    [sym_yield_expression] = STATE(577),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1497),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1497),
    [sym_jsx_element] = STATE(577),
    [sym_jsx_fragment] = STATE(577),
    [sym_jsx_opening_element] = STATE(975),
    [sym_jsx_self_closing_element] = STATE(577),
    [sym_class] = STATE(575),
    [sym_function] = STATE(575),
    [sym_generator_function] = STATE(575),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(577),
    [sym_await_expression] = STATE(577),
    [sym_member_expression] = STATE(430),
    [sym_subscript_expression] = STATE(430),
    [sym_assignment_expression] = STATE(577),
    [sym__augmented_assignment_lhs] = STATE(937),
    [sym_augmented_assignment_expression] = STATE(577),
    [sym__destructuring_pattern] = STATE(1497),
    [sym_ternary_expression] = STATE(577),
    [sym_binary_expression] = STATE(577),
    [sym_unary_expression] = STATE(577),
    [sym_update_expression] = STATE(577),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1533),
    [aux_sym_export_statement_repeat1] = STATE(1182),
    [sym_identifier] = ACTIONS(443),
    [anon_sym_export] = ACTIONS(445),
    [anon_sym_LBRACE] = ACTIONS(744),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(449),
    [anon_sym_yield] = ACTIONS(451),
    [anon_sym_LBRACK] = ACTIONS(427),
    [anon_sym_LT] = ACTIONS(585),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(453),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(455),
    [anon_sym_PLUS] = ACTIONS(457),
    [anon_sym_DASH] = ACTIONS(457),
    [anon_sym_BANG] = ACTIONS(459),
    [anon_sym_TILDE] = ACTIONS(459),
    [anon_sym_typeof] = ACTIONS(457),
    [anon_sym_void] = ACTIONS(457),
    [anon_sym_delete] = ACTIONS(457),
    [anon_sym_PLUS_PLUS] = ACTIONS(461),
    [anon_sym_DASH_DASH] = ACTIONS(461),
    [anon_sym_DQUOTE] = ACTIONS(361),
    [anon_sym_SQUOTE] = ACTIONS(363),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(365),
    [sym_number] = ACTIONS(367),
    [sym_this] = ACTIONS(369),
    [sym_super] = ACTIONS(369),
    [sym_true] = ACTIONS(369),
    [sym_false] = ACTIONS(369),
    [sym_null] = ACTIONS(369),
    [sym_undefined] = ACTIONS(463),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(445),
    [anon_sym_get] = ACTIONS(445),
    [anon_sym_set] = ACTIONS(445),
  },
  [130] = {
    [sym_import] = STATE(575),
    [sym_statement_block] = STATE(519),
    [sym_parenthesized_expression] = STATE(449),
    [sym_expression] = STATE(518),
    [sym_primary_expression] = STATE(576),
    [sym_yield_expression] = STATE(577),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1528),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1528),
    [sym_jsx_element] = STATE(577),
    [sym_jsx_fragment] = STATE(577),
    [sym_jsx_opening_element] = STATE(975),
    [sym_jsx_self_closing_element] = STATE(577),
    [sym_class] = STATE(575),
    [sym_function] = STATE(575),
    [sym_generator_function] = STATE(575),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(577),
    [sym_await_expression] = STATE(577),
    [sym_member_expression] = STATE(449),
    [sym_subscript_expression] = STATE(449),
    [sym_assignment_expression] = STATE(577),
    [sym__augmented_assignment_lhs] = STATE(943),
    [sym_augmented_assignment_expression] = STATE(577),
    [sym__destructuring_pattern] = STATE(1528),
    [sym_ternary_expression] = STATE(577),
    [sym_binary_expression] = STATE(577),
    [sym_unary_expression] = STATE(577),
    [sym_update_expression] = STATE(577),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1496),
    [aux_sym_export_statement_repeat1] = STATE(1182),
    [sym_identifier] = ACTIONS(321),
    [anon_sym_export] = ACTIONS(323),
    [anon_sym_LBRACE] = ACTIONS(742),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(335),
    [anon_sym_yield] = ACTIONS(339),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LT] = ACTIONS(585),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(349),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(353),
    [anon_sym_PLUS] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(355),
    [anon_sym_BANG] = ACTIONS(357),
    [anon_sym_TILDE] = ACTIONS(357),
    [anon_sym_typeof] = ACTIONS(355),
    [anon_sym_void] = ACTIONS(355),
    [anon_sym_delete] = ACTIONS(355),
    [anon_sym_PLUS_PLUS] = ACTIONS(359),
    [anon_sym_DASH_DASH] = ACTIONS(359),
    [anon_sym_DQUOTE] = ACTIONS(361),
    [anon_sym_SQUOTE] = ACTIONS(363),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(365),
    [sym_number] = ACTIONS(367),
    [sym_this] = ACTIONS(369),
    [sym_super] = ACTIONS(369),
    [sym_true] = ACTIONS(369),
    [sym_false] = ACTIONS(369),
    [sym_null] = ACTIONS(369),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(323),
    [anon_sym_get] = ACTIONS(323),
    [anon_sym_set] = ACTIONS(323),
  },
  [131] = {
    [sym_import] = STATE(721),
    [sym_statement_block] = STATE(729),
    [sym_parenthesized_expression] = STATE(479),
    [sym_expression] = STATE(635),
    [sym_primary_expression] = STATE(743),
    [sym_yield_expression] = STATE(740),
    [sym_object] = STATE(721),
    [sym_object_pattern] = STATE(1548),
    [sym_array] = STATE(721),
    [sym_array_pattern] = STATE(1548),
    [sym_jsx_element] = STATE(740),
    [sym_jsx_fragment] = STATE(740),
    [sym_jsx_opening_element] = STATE(972),
    [sym_jsx_self_closing_element] = STATE(740),
    [sym_class] = STATE(721),
    [sym_function] = STATE(721),
    [sym_generator_function] = STATE(721),
    [sym_arrow_function] = STATE(721),
    [sym_call_expression] = STATE(721),
    [sym_new_expression] = STATE(740),
    [sym_await_expression] = STATE(740),
    [sym_member_expression] = STATE(479),
    [sym_subscript_expression] = STATE(479),
    [sym_assignment_expression] = STATE(740),
    [sym__augmented_assignment_lhs] = STATE(942),
    [sym_augmented_assignment_expression] = STATE(740),
    [sym__destructuring_pattern] = STATE(1548),
    [sym_ternary_expression] = STATE(740),
    [sym_binary_expression] = STATE(740),
    [sym_unary_expression] = STATE(740),
    [sym_update_expression] = STATE(740),
    [sym_string] = STATE(721),
    [sym_template_string] = STATE(721),
    [sym_regex] = STATE(721),
    [sym_meta_property] = STATE(721),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1546),
    [aux_sym_export_statement_repeat1] = STATE(1154),
    [sym_identifier] = ACTIONS(407),
    [anon_sym_export] = ACTIONS(409),
    [anon_sym_LBRACE] = ACTIONS(746),
    [anon_sym_import] = ACTIONS(381),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(391),
    [anon_sym_async] = ACTIONS(413),
    [anon_sym_function] = ACTIONS(395),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(67),
    [anon_sym_void] = ACTIONS(67),
    [anon_sym_delete] = ACTIONS(67),
    [anon_sym_PLUS_PLUS] = ACTIONS(71),
    [anon_sym_DASH_DASH] = ACTIONS(71),
    [anon_sym_DQUOTE] = ACTIONS(73),
    [anon_sym_SQUOTE] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(77),
    [sym_number] = ACTIONS(79),
    [sym_this] = ACTIONS(81),
    [sym_super] = ACTIONS(81),
    [sym_true] = ACTIONS(81),
    [sym_false] = ACTIONS(81),
    [sym_null] = ACTIONS(81),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(409),
    [anon_sym_get] = ACTIONS(409),
    [anon_sym_set] = ACTIONS(409),
  },
  [132] = {
    [sym_import] = STATE(575),
    [sym_statement_block] = STATE(509),
    [sym_parenthesized_expression] = STATE(493),
    [sym_expression] = STATE(823),
    [sym_primary_expression] = STATE(576),
    [sym_yield_expression] = STATE(577),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1580),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1580),
    [sym_jsx_element] = STATE(577),
    [sym_jsx_fragment] = STATE(577),
    [sym_jsx_opening_element] = STATE(975),
    [sym_jsx_self_closing_element] = STATE(577),
    [sym_class] = STATE(575),
    [sym_function] = STATE(575),
    [sym_generator_function] = STATE(575),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(577),
    [sym_await_expression] = STATE(577),
    [sym_member_expression] = STATE(493),
    [sym_subscript_expression] = STATE(493),
    [sym_assignment_expression] = STATE(577),
    [sym__augmented_assignment_lhs] = STATE(933),
    [sym_augmented_assignment_expression] = STATE(577),
    [sym__destructuring_pattern] = STATE(1580),
    [sym_ternary_expression] = STATE(577),
    [sym_binary_expression] = STATE(577),
    [sym_unary_expression] = STATE(577),
    [sym_update_expression] = STATE(577),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1555),
    [aux_sym_export_statement_repeat1] = STATE(1182),
    [sym_identifier] = ACTIONS(415),
    [anon_sym_export] = ACTIONS(417),
    [anon_sym_LBRACE] = ACTIONS(744),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(423),
    [anon_sym_yield] = ACTIONS(425),
    [anon_sym_LBRACK] = ACTIONS(427),
    [anon_sym_LT] = ACTIONS(585),
    [anon_sym_SLASH] = ACTIONS(429),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(431),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(433),
    [anon_sym_PLUS] = ACTIONS(435),
    [anon_sym_DASH] = ACTIONS(435),
    [anon_sym_BANG] = ACTIONS(437),
    [anon_sym_TILDE] = ACTIONS(437),
    [anon_sym_typeof] = ACTIONS(435),
    [anon_sym_void] = ACTIONS(435),
    [anon_sym_delete] = ACTIONS(435),
    [anon_sym_PLUS_PLUS] = ACTIONS(439),
    [anon_sym_DASH_DASH] = ACTIONS(439),
    [anon_sym_DQUOTE] = ACTIONS(361),
    [anon_sym_SQUOTE] = ACTIONS(363),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(365),
    [sym_number] = ACTIONS(367),
    [sym_this] = ACTIONS(369),
    [sym_super] = ACTIONS(369),
    [sym_true] = ACTIONS(369),
    [sym_false] = ACTIONS(369),
    [sym_null] = ACTIONS(369),
    [sym_undefined] = ACTIONS(441),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(417),
    [anon_sym_get] = ACTIONS(417),
    [anon_sym_set] = ACTIONS(417),
  },
  [133] = {
    [sym_import] = STATE(575),
    [sym_statement_block] = STATE(516),
    [sym_parenthesized_expression] = STATE(449),
    [sym_expression] = STATE(515),
    [sym_primary_expression] = STATE(576),
    [sym_yield_expression] = STATE(577),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1528),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1528),
    [sym_jsx_element] = STATE(577),
    [sym_jsx_fragment] = STATE(577),
    [sym_jsx_opening_element] = STATE(975),
    [sym_jsx_self_closing_element] = STATE(577),
    [sym_class] = STATE(575),
    [sym_function] = STATE(575),
    [sym_generator_function] = STATE(575),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(577),
    [sym_await_expression] = STATE(577),
    [sym_member_expression] = STATE(449),
    [sym_subscript_expression] = STATE(449),
    [sym_assignment_expression] = STATE(577),
    [sym__augmented_assignment_lhs] = STATE(943),
    [sym_augmented_assignment_expression] = STATE(577),
    [sym__destructuring_pattern] = STATE(1528),
    [sym_ternary_expression] = STATE(577),
    [sym_binary_expression] = STATE(577),
    [sym_unary_expression] = STATE(577),
    [sym_update_expression] = STATE(577),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1496),
    [aux_sym_export_statement_repeat1] = STATE(1182),
    [sym_identifier] = ACTIONS(321),
    [anon_sym_export] = ACTIONS(323),
    [anon_sym_LBRACE] = ACTIONS(742),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(335),
    [anon_sym_yield] = ACTIONS(339),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LT] = ACTIONS(585),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(349),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(353),
    [anon_sym_PLUS] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(355),
    [anon_sym_BANG] = ACTIONS(357),
    [anon_sym_TILDE] = ACTIONS(357),
    [anon_sym_typeof] = ACTIONS(355),
    [anon_sym_void] = ACTIONS(355),
    [anon_sym_delete] = ACTIONS(355),
    [anon_sym_PLUS_PLUS] = ACTIONS(359),
    [anon_sym_DASH_DASH] = ACTIONS(359),
    [anon_sym_DQUOTE] = ACTIONS(361),
    [anon_sym_SQUOTE] = ACTIONS(363),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(365),
    [sym_number] = ACTIONS(367),
    [sym_this] = ACTIONS(369),
    [sym_super] = ACTIONS(369),
    [sym_true] = ACTIONS(369),
    [sym_false] = ACTIONS(369),
    [sym_null] = ACTIONS(369),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(323),
    [anon_sym_get] = ACTIONS(323),
    [anon_sym_set] = ACTIONS(323),
  },
  [134] = {
    [sym_import] = STATE(721),
    [sym_statement_block] = STATE(736),
    [sym_parenthesized_expression] = STATE(479),
    [sym_expression] = STATE(637),
    [sym_primary_expression] = STATE(743),
    [sym_yield_expression] = STATE(740),
    [sym_object] = STATE(721),
    [sym_object_pattern] = STATE(1548),
    [sym_array] = STATE(721),
    [sym_array_pattern] = STATE(1548),
    [sym_jsx_element] = STATE(740),
    [sym_jsx_fragment] = STATE(740),
    [sym_jsx_opening_element] = STATE(972),
    [sym_jsx_self_closing_element] = STATE(740),
    [sym_class] = STATE(721),
    [sym_function] = STATE(721),
    [sym_generator_function] = STATE(721),
    [sym_arrow_function] = STATE(721),
    [sym_call_expression] = STATE(721),
    [sym_new_expression] = STATE(740),
    [sym_await_expression] = STATE(740),
    [sym_member_expression] = STATE(479),
    [sym_subscript_expression] = STATE(479),
    [sym_assignment_expression] = STATE(740),
    [sym__augmented_assignment_lhs] = STATE(942),
    [sym_augmented_assignment_expression] = STATE(740),
    [sym__destructuring_pattern] = STATE(1548),
    [sym_ternary_expression] = STATE(740),
    [sym_binary_expression] = STATE(740),
    [sym_unary_expression] = STATE(740),
    [sym_update_expression] = STATE(740),
    [sym_string] = STATE(721),
    [sym_template_string] = STATE(721),
    [sym_regex] = STATE(721),
    [sym_meta_property] = STATE(721),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1546),
    [aux_sym_export_statement_repeat1] = STATE(1154),
    [sym_identifier] = ACTIONS(407),
    [anon_sym_export] = ACTIONS(409),
    [anon_sym_LBRACE] = ACTIONS(746),
    [anon_sym_import] = ACTIONS(381),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(391),
    [anon_sym_async] = ACTIONS(413),
    [anon_sym_function] = ACTIONS(395),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(67),
    [anon_sym_void] = ACTIONS(67),
    [anon_sym_delete] = ACTIONS(67),
    [anon_sym_PLUS_PLUS] = ACTIONS(71),
    [anon_sym_DASH_DASH] = ACTIONS(71),
    [anon_sym_DQUOTE] = ACTIONS(73),
    [anon_sym_SQUOTE] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(77),
    [sym_number] = ACTIONS(79),
    [sym_this] = ACTIONS(81),
    [sym_super] = ACTIONS(81),
    [sym_true] = ACTIONS(81),
    [sym_false] = ACTIONS(81),
    [sym_null] = ACTIONS(81),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(409),
    [anon_sym_get] = ACTIONS(409),
    [anon_sym_set] = ACTIONS(409),
  },
  [135] = {
    [sym_import] = STATE(575),
    [sym_statement_block] = STATE(551),
    [sym_parenthesized_expression] = STATE(430),
    [sym_expression] = STATE(751),
    [sym_primary_expression] = STATE(576),
    [sym_yield_expression] = STATE(577),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1497),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1497),
    [sym_jsx_element] = STATE(577),
    [sym_jsx_fragment] = STATE(577),
    [sym_jsx_opening_element] = STATE(975),
    [sym_jsx_self_closing_element] = STATE(577),
    [sym_class] = STATE(575),
    [sym_function] = STATE(575),
    [sym_generator_function] = STATE(575),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(577),
    [sym_await_expression] = STATE(577),
    [sym_member_expression] = STATE(430),
    [sym_subscript_expression] = STATE(430),
    [sym_assignment_expression] = STATE(577),
    [sym__augmented_assignment_lhs] = STATE(937),
    [sym_augmented_assignment_expression] = STATE(577),
    [sym__destructuring_pattern] = STATE(1497),
    [sym_ternary_expression] = STATE(577),
    [sym_binary_expression] = STATE(577),
    [sym_unary_expression] = STATE(577),
    [sym_update_expression] = STATE(577),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1533),
    [aux_sym_export_statement_repeat1] = STATE(1182),
    [sym_identifier] = ACTIONS(443),
    [anon_sym_export] = ACTIONS(445),
    [anon_sym_LBRACE] = ACTIONS(744),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(449),
    [anon_sym_yield] = ACTIONS(451),
    [anon_sym_LBRACK] = ACTIONS(427),
    [anon_sym_LT] = ACTIONS(585),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(453),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(455),
    [anon_sym_PLUS] = ACTIONS(457),
    [anon_sym_DASH] = ACTIONS(457),
    [anon_sym_BANG] = ACTIONS(459),
    [anon_sym_TILDE] = ACTIONS(459),
    [anon_sym_typeof] = ACTIONS(457),
    [anon_sym_void] = ACTIONS(457),
    [anon_sym_delete] = ACTIONS(457),
    [anon_sym_PLUS_PLUS] = ACTIONS(461),
    [anon_sym_DASH_DASH] = ACTIONS(461),
    [anon_sym_DQUOTE] = ACTIONS(361),
    [anon_sym_SQUOTE] = ACTIONS(363),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(365),
    [sym_number] = ACTIONS(367),
    [sym_this] = ACTIONS(369),
    [sym_super] = ACTIONS(369),
    [sym_true] = ACTIONS(369),
    [sym_false] = ACTIONS(369),
    [sym_null] = ACTIONS(369),
    [sym_undefined] = ACTIONS(463),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(445),
    [anon_sym_get] = ACTIONS(445),
    [anon_sym_set] = ACTIONS(445),
  },
  [136] = {
    [sym_import] = STATE(575),
    [sym_statement_block] = STATE(509),
    [sym_parenthesized_expression] = STATE(449),
    [sym_expression] = STATE(584),
    [sym_primary_expression] = STATE(576),
    [sym_yield_expression] = STATE(577),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1528),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1528),
    [sym_jsx_element] = STATE(577),
    [sym_jsx_fragment] = STATE(577),
    [sym_jsx_opening_element] = STATE(975),
    [sym_jsx_self_closing_element] = STATE(577),
    [sym_class] = STATE(575),
    [sym_function] = STATE(575),
    [sym_generator_function] = STATE(575),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(577),
    [sym_await_expression] = STATE(577),
    [sym_member_expression] = STATE(449),
    [sym_subscript_expression] = STATE(449),
    [sym_assignment_expression] = STATE(577),
    [sym__augmented_assignment_lhs] = STATE(943),
    [sym_augmented_assignment_expression] = STATE(577),
    [sym__destructuring_pattern] = STATE(1528),
    [sym_ternary_expression] = STATE(577),
    [sym_binary_expression] = STATE(577),
    [sym_unary_expression] = STATE(577),
    [sym_update_expression] = STATE(577),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1496),
    [aux_sym_export_statement_repeat1] = STATE(1182),
    [sym_identifier] = ACTIONS(321),
    [anon_sym_export] = ACTIONS(323),
    [anon_sym_LBRACE] = ACTIONS(742),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(335),
    [anon_sym_yield] = ACTIONS(339),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LT] = ACTIONS(585),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(349),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(353),
    [anon_sym_PLUS] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(355),
    [anon_sym_BANG] = ACTIONS(357),
    [anon_sym_TILDE] = ACTIONS(357),
    [anon_sym_typeof] = ACTIONS(355),
    [anon_sym_void] = ACTIONS(355),
    [anon_sym_delete] = ACTIONS(355),
    [anon_sym_PLUS_PLUS] = ACTIONS(359),
    [anon_sym_DASH_DASH] = ACTIONS(359),
    [anon_sym_DQUOTE] = ACTIONS(361),
    [anon_sym_SQUOTE] = ACTIONS(363),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(365),
    [sym_number] = ACTIONS(367),
    [sym_this] = ACTIONS(369),
    [sym_super] = ACTIONS(369),
    [sym_true] = ACTIONS(369),
    [sym_false] = ACTIONS(369),
    [sym_null] = ACTIONS(369),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(323),
    [anon_sym_get] = ACTIONS(323),
    [anon_sym_set] = ACTIONS(323),
  },
  [137] = {
    [sym_import] = STATE(575),
    [sym_statement_block] = STATE(528),
    [sym_parenthesized_expression] = STATE(430),
    [sym_expression] = STATE(783),
    [sym_primary_expression] = STATE(576),
    [sym_yield_expression] = STATE(577),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1497),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1497),
    [sym_jsx_element] = STATE(577),
    [sym_jsx_fragment] = STATE(577),
    [sym_jsx_opening_element] = STATE(975),
    [sym_jsx_self_closing_element] = STATE(577),
    [sym_class] = STATE(575),
    [sym_function] = STATE(575),
    [sym_generator_function] = STATE(575),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(577),
    [sym_await_expression] = STATE(577),
    [sym_member_expression] = STATE(430),
    [sym_subscript_expression] = STATE(430),
    [sym_assignment_expression] = STATE(577),
    [sym__augmented_assignment_lhs] = STATE(937),
    [sym_augmented_assignment_expression] = STATE(577),
    [sym__destructuring_pattern] = STATE(1497),
    [sym_ternary_expression] = STATE(577),
    [sym_binary_expression] = STATE(577),
    [sym_unary_expression] = STATE(577),
    [sym_update_expression] = STATE(577),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1533),
    [aux_sym_export_statement_repeat1] = STATE(1182),
    [sym_identifier] = ACTIONS(443),
    [anon_sym_export] = ACTIONS(445),
    [anon_sym_LBRACE] = ACTIONS(744),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(449),
    [anon_sym_yield] = ACTIONS(451),
    [anon_sym_LBRACK] = ACTIONS(427),
    [anon_sym_LT] = ACTIONS(585),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(453),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(455),
    [anon_sym_PLUS] = ACTIONS(457),
    [anon_sym_DASH] = ACTIONS(457),
    [anon_sym_BANG] = ACTIONS(459),
    [anon_sym_TILDE] = ACTIONS(459),
    [anon_sym_typeof] = ACTIONS(457),
    [anon_sym_void] = ACTIONS(457),
    [anon_sym_delete] = ACTIONS(457),
    [anon_sym_PLUS_PLUS] = ACTIONS(461),
    [anon_sym_DASH_DASH] = ACTIONS(461),
    [anon_sym_DQUOTE] = ACTIONS(361),
    [anon_sym_SQUOTE] = ACTIONS(363),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(365),
    [sym_number] = ACTIONS(367),
    [sym_this] = ACTIONS(369),
    [sym_super] = ACTIONS(369),
    [sym_true] = ACTIONS(369),
    [sym_false] = ACTIONS(369),
    [sym_null] = ACTIONS(369),
    [sym_undefined] = ACTIONS(463),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(445),
    [anon_sym_get] = ACTIONS(445),
    [anon_sym_set] = ACTIONS(445),
  },
  [138] = {
    [sym_import] = STATE(575),
    [sym_parenthesized_expression] = STATE(449),
    [sym_expression] = STATE(750),
    [sym_primary_expression] = STATE(576),
    [sym_yield_expression] = STATE(577),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1528),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1528),
    [sym_jsx_element] = STATE(577),
    [sym_jsx_fragment] = STATE(577),
    [sym_jsx_opening_element] = STATE(975),
    [sym_jsx_self_closing_element] = STATE(577),
    [sym_class] = STATE(575),
    [sym_function] = STATE(575),
    [sym_generator_function] = STATE(575),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(577),
    [sym_await_expression] = STATE(577),
    [sym_member_expression] = STATE(449),
    [sym_subscript_expression] = STATE(449),
    [sym_assignment_expression] = STATE(577),
    [sym__augmented_assignment_lhs] = STATE(943),
    [sym_augmented_assignment_expression] = STATE(577),
    [sym__destructuring_pattern] = STATE(1528),
    [sym_ternary_expression] = STATE(577),
    [sym_binary_expression] = STATE(577),
    [sym_unary_expression] = STATE(577),
    [sym_update_expression] = STATE(577),
    [sym_sequence_expression] = STATE(1513),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1496),
    [aux_sym_export_statement_repeat1] = STATE(1182),
    [sym_identifier] = ACTIONS(321),
    [anon_sym_export] = ACTIONS(323),
    [anon_sym_LBRACE] = ACTIONS(327),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(335),
    [anon_sym_yield] = ACTIONS(339),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LT] = ACTIONS(585),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(349),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(353),
    [anon_sym_PLUS] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(355),
    [anon_sym_BANG] = ACTIONS(357),
    [anon_sym_TILDE] = ACTIONS(357),
    [anon_sym_typeof] = ACTIONS(355),
    [anon_sym_void] = ACTIONS(355),
    [anon_sym_delete] = ACTIONS(355),
    [anon_sym_PLUS_PLUS] = ACTIONS(359),
    [anon_sym_DASH_DASH] = ACTIONS(359),
    [anon_sym_DQUOTE] = ACTIONS(361),
    [anon_sym_SQUOTE] = ACTIONS(363),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(365),
    [sym_number] = ACTIONS(367),
    [sym_this] = ACTIONS(369),
    [sym_super] = ACTIONS(369),
    [sym_true] = ACTIONS(369),
    [sym_false] = ACTIONS(369),
    [sym_null] = ACTIONS(369),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(323),
    [anon_sym_get] = ACTIONS(323),
    [anon_sym_set] = ACTIONS(323),
  },
  [139] = {
    [sym_import] = STATE(721),
    [sym_parenthesized_expression] = STATE(453),
    [sym_expression] = STATE(837),
    [sym_primary_expression] = STATE(608),
    [sym_yield_expression] = STATE(577),
    [sym_object] = STATE(721),
    [sym_object_pattern] = STATE(1497),
    [sym_array] = STATE(721),
    [sym_array_pattern] = STATE(1497),
    [sym_jsx_element] = STATE(577),
    [sym_jsx_fragment] = STATE(577),
    [sym_jsx_opening_element] = STATE(975),
    [sym_jsx_self_closing_element] = STATE(577),
    [sym_class] = STATE(721),
    [sym_function] = STATE(721),
    [sym_generator_function] = STATE(721),
    [sym_arrow_function] = STATE(721),
    [sym_call_expression] = STATE(721),
    [sym_new_expression] = STATE(609),
    [sym_await_expression] = STATE(577),
    [sym_member_expression] = STATE(453),
    [sym_subscript_expression] = STATE(453),
    [sym_assignment_expression] = STATE(577),
    [sym__augmented_assignment_lhs] = STATE(937),
    [sym_augmented_assignment_expression] = STATE(577),
    [sym__destructuring_pattern] = STATE(1497),
    [sym_ternary_expression] = STATE(577),
    [sym_binary_expression] = STATE(577),
    [sym_unary_expression] = STATE(577),
    [sym_update_expression] = STATE(577),
    [sym_string] = STATE(721),
    [sym_template_string] = STATE(721),
    [sym_regex] = STATE(721),
    [sym_meta_property] = STATE(721),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1546),
    [aux_sym_export_statement_repeat1] = STATE(1154),
    [sym_identifier] = ACTIONS(766),
    [anon_sym_export] = ACTIONS(768),
    [anon_sym_LBRACE] = ACTIONS(379),
    [anon_sym_import] = ACTIONS(381),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(449),
    [anon_sym_yield] = ACTIONS(451),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(585),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_DOT] = ACTIONS(760),
    [anon_sym_class] = ACTIONS(391),
    [anon_sym_async] = ACTIONS(770),
    [anon_sym_function] = ACTIONS(395),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(457),
    [anon_sym_DASH] = ACTIONS(457),
    [anon_sym_BANG] = ACTIONS(459),
    [anon_sym_TILDE] = ACTIONS(459),
    [anon_sym_typeof] = ACTIONS(457),
    [anon_sym_void] = ACTIONS(457),
    [anon_sym_delete] = ACTIONS(457),
    [anon_sym_PLUS_PLUS] = ACTIONS(461),
    [anon_sym_DASH_DASH] = ACTIONS(461),
    [anon_sym_DQUOTE] = ACTIONS(73),
    [anon_sym_SQUOTE] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(77),
    [sym_number] = ACTIONS(79),
    [sym_this] = ACTIONS(81),
    [sym_super] = ACTIONS(81),
    [sym_true] = ACTIONS(81),
    [sym_false] = ACTIONS(81),
    [sym_null] = ACTIONS(81),
    [sym_undefined] = ACTIONS(764),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(768),
    [anon_sym_get] = ACTIONS(768),
    [anon_sym_set] = ACTIONS(768),
  },
  [140] = {
    [sym_import] = STATE(575),
    [sym_parenthesized_expression] = STATE(430),
    [sym_expression] = STATE(835),
    [sym_primary_expression] = STATE(502),
    [sym_yield_expression] = STATE(577),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1497),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1497),
    [sym_jsx_element] = STATE(577),
    [sym_jsx_fragment] = STATE(577),
    [sym_jsx_opening_element] = STATE(975),
    [sym_jsx_self_closing_element] = STATE(577),
    [sym_class] = STATE(575),
    [sym_function] = STATE(575),
    [sym_generator_function] = STATE(575),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(500),
    [sym_await_expression] = STATE(577),
    [sym_member_expression] = STATE(430),
    [sym_subscript_expression] = STATE(430),
    [sym_assignment_expression] = STATE(577),
    [sym__augmented_assignment_lhs] = STATE(937),
    [sym_augmented_assignment_expression] = STATE(577),
    [sym__destructuring_pattern] = STATE(1497),
    [sym_ternary_expression] = STATE(577),
    [sym_binary_expression] = STATE(577),
    [sym_unary_expression] = STATE(577),
    [sym_update_expression] = STATE(577),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1555),
    [aux_sym_export_statement_repeat1] = STATE(1182),
    [sym_identifier] = ACTIONS(772),
    [anon_sym_export] = ACTIONS(774),
    [anon_sym_LBRACE] = ACTIONS(421),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(449),
    [anon_sym_yield] = ACTIONS(451),
    [anon_sym_LBRACK] = ACTIONS(427),
    [anon_sym_LT] = ACTIONS(585),
    [anon_sym_SLASH] = ACTIONS(429),
    [anon_sym_DOT] = ACTIONS(752),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(776),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(433),
    [anon_sym_PLUS] = ACTIONS(457),
    [anon_sym_DASH] = ACTIONS(457),
    [anon_sym_BANG] = ACTIONS(459),
    [anon_sym_TILDE] = ACTIONS(459),
    [anon_sym_typeof] = ACTIONS(457),
    [anon_sym_void] = ACTIONS(457),
    [anon_sym_delete] = ACTIONS(457),
    [anon_sym_PLUS_PLUS] = ACTIONS(461),
    [anon_sym_DASH_DASH] = ACTIONS(461),
    [anon_sym_DQUOTE] = ACTIONS(361),
    [anon_sym_SQUOTE] = ACTIONS(363),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(365),
    [sym_number] = ACTIONS(367),
    [sym_this] = ACTIONS(369),
    [sym_super] = ACTIONS(369),
    [sym_true] = ACTIONS(369),
    [sym_false] = ACTIONS(369),
    [sym_null] = ACTIONS(369),
    [sym_undefined] = ACTIONS(463),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(774),
    [anon_sym_get] = ACTIONS(774),
    [anon_sym_set] = ACTIONS(774),
  },
  [141] = {
    [sym_import] = STATE(575),
    [sym_parenthesized_expression] = STATE(449),
    [sym_expression] = STATE(772),
    [sym_primary_expression] = STATE(576),
    [sym_yield_expression] = STATE(577),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1528),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1528),
    [sym_jsx_element] = STATE(577),
    [sym_jsx_fragment] = STATE(577),
    [sym_jsx_opening_element] = STATE(975),
    [sym_jsx_self_closing_element] = STATE(577),
    [sym_class] = STATE(575),
    [sym_function] = STATE(575),
    [sym_generator_function] = STATE(575),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(577),
    [sym_await_expression] = STATE(577),
    [sym_member_expression] = STATE(449),
    [sym_subscript_expression] = STATE(449),
    [sym_assignment_expression] = STATE(577),
    [sym__augmented_assignment_lhs] = STATE(943),
    [sym_augmented_assignment_expression] = STATE(577),
    [sym__destructuring_pattern] = STATE(1528),
    [sym_ternary_expression] = STATE(577),
    [sym_binary_expression] = STATE(577),
    [sym_unary_expression] = STATE(577),
    [sym_update_expression] = STATE(577),
    [sym_sequence_expression] = STATE(1568),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1496),
    [aux_sym_export_statement_repeat1] = STATE(1182),
    [sym_identifier] = ACTIONS(321),
    [anon_sym_export] = ACTIONS(323),
    [anon_sym_LBRACE] = ACTIONS(327),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(335),
    [anon_sym_yield] = ACTIONS(339),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LT] = ACTIONS(585),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(349),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(353),
    [anon_sym_PLUS] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(355),
    [anon_sym_BANG] = ACTIONS(357),
    [anon_sym_TILDE] = ACTIONS(357),
    [anon_sym_typeof] = ACTIONS(355),
    [anon_sym_void] = ACTIONS(355),
    [anon_sym_delete] = ACTIONS(355),
    [anon_sym_PLUS_PLUS] = ACTIONS(359),
    [anon_sym_DASH_DASH] = ACTIONS(359),
    [anon_sym_DQUOTE] = ACTIONS(361),
    [anon_sym_SQUOTE] = ACTIONS(363),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(365),
    [sym_number] = ACTIONS(367),
    [sym_this] = ACTIONS(369),
    [sym_super] = ACTIONS(369),
    [sym_true] = ACTIONS(369),
    [sym_false] = ACTIONS(369),
    [sym_null] = ACTIONS(369),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(323),
    [anon_sym_get] = ACTIONS(323),
    [anon_sym_set] = ACTIONS(323),
  },
  [142] = {
    [sym_import] = STATE(721),
    [sym_statement_block] = STATE(669),
    [sym_parenthesized_expression] = STATE(479),
    [sym_expression] = STATE(597),
    [sym_primary_expression] = STATE(743),
    [sym_yield_expression] = STATE(740),
    [sym_object] = STATE(721),
    [sym_object_pattern] = STATE(1548),
    [sym_array] = STATE(721),
    [sym_array_pattern] = STATE(1548),
    [sym_jsx_element] = STATE(740),
    [sym_jsx_fragment] = STATE(740),
    [sym_jsx_opening_element] = STATE(972),
    [sym_jsx_self_closing_element] = STATE(740),
    [sym_class] = STATE(721),
    [sym_function] = STATE(721),
    [sym_generator_function] = STATE(721),
    [sym_arrow_function] = STATE(721),
    [sym_call_expression] = STATE(721),
    [sym_new_expression] = STATE(740),
    [sym_await_expression] = STATE(740),
    [sym_member_expression] = STATE(479),
    [sym_subscript_expression] = STATE(479),
    [sym_assignment_expression] = STATE(740),
    [sym__augmented_assignment_lhs] = STATE(942),
    [sym_augmented_assignment_expression] = STATE(740),
    [sym__destructuring_pattern] = STATE(1548),
    [sym_ternary_expression] = STATE(740),
    [sym_binary_expression] = STATE(740),
    [sym_unary_expression] = STATE(740),
    [sym_update_expression] = STATE(740),
    [sym_string] = STATE(721),
    [sym_template_string] = STATE(721),
    [sym_regex] = STATE(721),
    [sym_meta_property] = STATE(721),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1546),
    [aux_sym_export_statement_repeat1] = STATE(1154),
    [sym_identifier] = ACTIONS(407),
    [anon_sym_export] = ACTIONS(409),
    [anon_sym_LBRACE] = ACTIONS(746),
    [anon_sym_import] = ACTIONS(381),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(391),
    [anon_sym_async] = ACTIONS(413),
    [anon_sym_function] = ACTIONS(395),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(67),
    [anon_sym_void] = ACTIONS(67),
    [anon_sym_delete] = ACTIONS(67),
    [anon_sym_PLUS_PLUS] = ACTIONS(71),
    [anon_sym_DASH_DASH] = ACTIONS(71),
    [anon_sym_DQUOTE] = ACTIONS(73),
    [anon_sym_SQUOTE] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(77),
    [sym_number] = ACTIONS(79),
    [sym_this] = ACTIONS(81),
    [sym_super] = ACTIONS(81),
    [sym_true] = ACTIONS(81),
    [sym_false] = ACTIONS(81),
    [sym_null] = ACTIONS(81),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(409),
    [anon_sym_get] = ACTIONS(409),
    [anon_sym_set] = ACTIONS(409),
  },
  [143] = {
    [sym_import] = STATE(721),
    [sym_parenthesized_expression] = STATE(479),
    [sym_expression] = STATE(665),
    [sym_primary_expression] = STATE(743),
    [sym_yield_expression] = STATE(740),
    [sym_object] = STATE(721),
    [sym_object_pattern] = STATE(1548),
    [sym_array] = STATE(721),
    [sym_array_pattern] = STATE(1548),
    [sym_jsx_element] = STATE(740),
    [sym_jsx_fragment] = STATE(740),
    [sym_jsx_opening_element] = STATE(972),
    [sym_jsx_self_closing_element] = STATE(740),
    [sym_class] = STATE(721),
    [sym_function] = STATE(721),
    [sym_generator_function] = STATE(721),
    [sym_arrow_function] = STATE(721),
    [sym_call_expression] = STATE(721),
    [sym_new_expression] = STATE(740),
    [sym_await_expression] = STATE(740),
    [sym_member_expression] = STATE(479),
    [sym_subscript_expression] = STATE(479),
    [sym_assignment_expression] = STATE(740),
    [sym__augmented_assignment_lhs] = STATE(942),
    [sym_augmented_assignment_expression] = STATE(740),
    [sym__destructuring_pattern] = STATE(1548),
    [sym_ternary_expression] = STATE(740),
    [sym_binary_expression] = STATE(740),
    [sym_unary_expression] = STATE(740),
    [sym_update_expression] = STATE(740),
    [sym_sequence_expression] = STATE(1439),
    [sym_string] = STATE(721),
    [sym_template_string] = STATE(721),
    [sym_regex] = STATE(721),
    [sym_meta_property] = STATE(721),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1546),
    [aux_sym_export_statement_repeat1] = STATE(1154),
    [sym_identifier] = ACTIONS(407),
    [anon_sym_export] = ACTIONS(409),
    [anon_sym_LBRACE] = ACTIONS(379),
    [anon_sym_import] = ACTIONS(381),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(391),
    [anon_sym_async] = ACTIONS(413),
    [anon_sym_function] = ACTIONS(395),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(67),
    [anon_sym_void] = ACTIONS(67),
    [anon_sym_delete] = ACTIONS(67),
    [anon_sym_PLUS_PLUS] = ACTIONS(71),
    [anon_sym_DASH_DASH] = ACTIONS(71),
    [anon_sym_DQUOTE] = ACTIONS(73),
    [anon_sym_SQUOTE] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(77),
    [sym_number] = ACTIONS(79),
    [sym_this] = ACTIONS(81),
    [sym_super] = ACTIONS(81),
    [sym_true] = ACTIONS(81),
    [sym_false] = ACTIONS(81),
    [sym_null] = ACTIONS(81),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(409),
    [anon_sym_get] = ACTIONS(409),
    [anon_sym_set] = ACTIONS(409),
  },
  [144] = {
    [sym_import] = STATE(575),
    [sym_parenthesized_expression] = STATE(449),
    [sym_expression] = STATE(760),
    [sym_primary_expression] = STATE(576),
    [sym_yield_expression] = STATE(577),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1528),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1528),
    [sym_jsx_element] = STATE(577),
    [sym_jsx_fragment] = STATE(577),
    [sym_jsx_opening_element] = STATE(975),
    [sym_jsx_self_closing_element] = STATE(577),
    [sym_class] = STATE(575),
    [sym_function] = STATE(575),
    [sym_generator_function] = STATE(575),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(577),
    [sym_await_expression] = STATE(577),
    [sym_member_expression] = STATE(449),
    [sym_subscript_expression] = STATE(449),
    [sym_assignment_expression] = STATE(577),
    [sym__augmented_assignment_lhs] = STATE(943),
    [sym_augmented_assignment_expression] = STATE(577),
    [sym__destructuring_pattern] = STATE(1528),
    [sym_ternary_expression] = STATE(577),
    [sym_binary_expression] = STATE(577),
    [sym_unary_expression] = STATE(577),
    [sym_update_expression] = STATE(577),
    [sym_sequence_expression] = STATE(1512),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1496),
    [aux_sym_export_statement_repeat1] = STATE(1182),
    [sym_identifier] = ACTIONS(321),
    [anon_sym_export] = ACTIONS(323),
    [anon_sym_LBRACE] = ACTIONS(327),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(335),
    [anon_sym_yield] = ACTIONS(339),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LT] = ACTIONS(585),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(349),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(353),
    [anon_sym_PLUS] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(355),
    [anon_sym_BANG] = ACTIONS(357),
    [anon_sym_TILDE] = ACTIONS(357),
    [anon_sym_typeof] = ACTIONS(355),
    [anon_sym_void] = ACTIONS(355),
    [anon_sym_delete] = ACTIONS(355),
    [anon_sym_PLUS_PLUS] = ACTIONS(359),
    [anon_sym_DASH_DASH] = ACTIONS(359),
    [anon_sym_DQUOTE] = ACTIONS(361),
    [anon_sym_SQUOTE] = ACTIONS(363),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(365),
    [sym_number] = ACTIONS(367),
    [sym_this] = ACTIONS(369),
    [sym_super] = ACTIONS(369),
    [sym_true] = ACTIONS(369),
    [sym_false] = ACTIONS(369),
    [sym_null] = ACTIONS(369),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(323),
    [anon_sym_get] = ACTIONS(323),
    [anon_sym_set] = ACTIONS(323),
  },
  [145] = {
    [sym_import] = STATE(575),
    [sym_parenthesized_expression] = STATE(449),
    [sym_expression] = STATE(757),
    [sym_primary_expression] = STATE(576),
    [sym_yield_expression] = STATE(577),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1528),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1528),
    [sym_jsx_element] = STATE(577),
    [sym_jsx_fragment] = STATE(577),
    [sym_jsx_opening_element] = STATE(975),
    [sym_jsx_self_closing_element] = STATE(577),
    [sym_class] = STATE(575),
    [sym_function] = STATE(575),
    [sym_generator_function] = STATE(575),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(577),
    [sym_await_expression] = STATE(577),
    [sym_member_expression] = STATE(449),
    [sym_subscript_expression] = STATE(449),
    [sym_assignment_expression] = STATE(577),
    [sym__augmented_assignment_lhs] = STATE(943),
    [sym_augmented_assignment_expression] = STATE(577),
    [sym__destructuring_pattern] = STATE(1528),
    [sym_ternary_expression] = STATE(577),
    [sym_binary_expression] = STATE(577),
    [sym_unary_expression] = STATE(577),
    [sym_update_expression] = STATE(577),
    [sym_sequence_expression] = STATE(1550),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1496),
    [aux_sym_export_statement_repeat1] = STATE(1182),
    [sym_identifier] = ACTIONS(321),
    [anon_sym_export] = ACTIONS(323),
    [anon_sym_LBRACE] = ACTIONS(327),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(335),
    [anon_sym_yield] = ACTIONS(339),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LT] = ACTIONS(585),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(349),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(353),
    [anon_sym_PLUS] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(355),
    [anon_sym_BANG] = ACTIONS(357),
    [anon_sym_TILDE] = ACTIONS(357),
    [anon_sym_typeof] = ACTIONS(355),
    [anon_sym_void] = ACTIONS(355),
    [anon_sym_delete] = ACTIONS(355),
    [anon_sym_PLUS_PLUS] = ACTIONS(359),
    [anon_sym_DASH_DASH] = ACTIONS(359),
    [anon_sym_DQUOTE] = ACTIONS(361),
    [anon_sym_SQUOTE] = ACTIONS(363),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(365),
    [sym_number] = ACTIONS(367),
    [sym_this] = ACTIONS(369),
    [sym_super] = ACTIONS(369),
    [sym_true] = ACTIONS(369),
    [sym_false] = ACTIONS(369),
    [sym_null] = ACTIONS(369),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(323),
    [anon_sym_get] = ACTIONS(323),
    [anon_sym_set] = ACTIONS(323),
  },
  [146] = {
    [sym_import] = STATE(575),
    [sym_parenthesized_expression] = STATE(449),
    [sym_expression] = STATE(762),
    [sym_primary_expression] = STATE(576),
    [sym_yield_expression] = STATE(577),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1528),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1528),
    [sym_jsx_element] = STATE(577),
    [sym_jsx_fragment] = STATE(577),
    [sym_jsx_opening_element] = STATE(975),
    [sym_jsx_self_closing_element] = STATE(577),
    [sym_class] = STATE(575),
    [sym_function] = STATE(575),
    [sym_generator_function] = STATE(575),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(577),
    [sym_await_expression] = STATE(577),
    [sym_member_expression] = STATE(449),
    [sym_subscript_expression] = STATE(449),
    [sym_assignment_expression] = STATE(577),
    [sym__augmented_assignment_lhs] = STATE(943),
    [sym_augmented_assignment_expression] = STATE(577),
    [sym__destructuring_pattern] = STATE(1528),
    [sym_ternary_expression] = STATE(577),
    [sym_binary_expression] = STATE(577),
    [sym_unary_expression] = STATE(577),
    [sym_update_expression] = STATE(577),
    [sym_sequence_expression] = STATE(1511),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1496),
    [aux_sym_export_statement_repeat1] = STATE(1182),
    [sym_identifier] = ACTIONS(321),
    [anon_sym_export] = ACTIONS(323),
    [anon_sym_LBRACE] = ACTIONS(327),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(335),
    [anon_sym_yield] = ACTIONS(339),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LT] = ACTIONS(585),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(349),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(353),
    [anon_sym_PLUS] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(355),
    [anon_sym_BANG] = ACTIONS(357),
    [anon_sym_TILDE] = ACTIONS(357),
    [anon_sym_typeof] = ACTIONS(355),
    [anon_sym_void] = ACTIONS(355),
    [anon_sym_delete] = ACTIONS(355),
    [anon_sym_PLUS_PLUS] = ACTIONS(359),
    [anon_sym_DASH_DASH] = ACTIONS(359),
    [anon_sym_DQUOTE] = ACTIONS(361),
    [anon_sym_SQUOTE] = ACTIONS(363),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(365),
    [sym_number] = ACTIONS(367),
    [sym_this] = ACTIONS(369),
    [sym_super] = ACTIONS(369),
    [sym_true] = ACTIONS(369),
    [sym_false] = ACTIONS(369),
    [sym_null] = ACTIONS(369),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(323),
    [anon_sym_get] = ACTIONS(323),
    [anon_sym_set] = ACTIONS(323),
  },
  [147] = {
    [sym_import] = STATE(721),
    [sym_parenthesized_expression] = STATE(479),
    [sym_expression] = STATE(683),
    [sym_primary_expression] = STATE(743),
    [sym_yield_expression] = STATE(740),
    [sym_object] = STATE(721),
    [sym_object_pattern] = STATE(1548),
    [sym_array] = STATE(721),
    [sym_array_pattern] = STATE(1548),
    [sym_jsx_element] = STATE(740),
    [sym_jsx_fragment] = STATE(740),
    [sym_jsx_opening_element] = STATE(972),
    [sym_jsx_self_closing_element] = STATE(740),
    [sym_class] = STATE(721),
    [sym_function] = STATE(721),
    [sym_generator_function] = STATE(721),
    [sym_arrow_function] = STATE(721),
    [sym_call_expression] = STATE(721),
    [sym_new_expression] = STATE(740),
    [sym_await_expression] = STATE(740),
    [sym_member_expression] = STATE(479),
    [sym_subscript_expression] = STATE(479),
    [sym_assignment_expression] = STATE(740),
    [sym__augmented_assignment_lhs] = STATE(942),
    [sym_augmented_assignment_expression] = STATE(740),
    [sym__destructuring_pattern] = STATE(1548),
    [sym_ternary_expression] = STATE(740),
    [sym_binary_expression] = STATE(740),
    [sym_unary_expression] = STATE(740),
    [sym_update_expression] = STATE(740),
    [sym_sequence_expression] = STATE(1404),
    [sym_string] = STATE(721),
    [sym_template_string] = STATE(721),
    [sym_regex] = STATE(721),
    [sym_meta_property] = STATE(721),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1546),
    [aux_sym_export_statement_repeat1] = STATE(1154),
    [sym_identifier] = ACTIONS(407),
    [anon_sym_export] = ACTIONS(409),
    [anon_sym_LBRACE] = ACTIONS(379),
    [anon_sym_import] = ACTIONS(381),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(391),
    [anon_sym_async] = ACTIONS(413),
    [anon_sym_function] = ACTIONS(395),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(67),
    [anon_sym_void] = ACTIONS(67),
    [anon_sym_delete] = ACTIONS(67),
    [anon_sym_PLUS_PLUS] = ACTIONS(71),
    [anon_sym_DASH_DASH] = ACTIONS(71),
    [anon_sym_DQUOTE] = ACTIONS(73),
    [anon_sym_SQUOTE] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(77),
    [sym_number] = ACTIONS(79),
    [sym_this] = ACTIONS(81),
    [sym_super] = ACTIONS(81),
    [sym_true] = ACTIONS(81),
    [sym_false] = ACTIONS(81),
    [sym_null] = ACTIONS(81),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(409),
    [anon_sym_get] = ACTIONS(409),
    [anon_sym_set] = ACTIONS(409),
  },
  [148] = {
    [sym_import] = STATE(575),
    [sym_statement_block] = STATE(519),
    [sym_parenthesized_expression] = STATE(430),
    [sym_expression] = STATE(785),
    [sym_primary_expression] = STATE(576),
    [sym_yield_expression] = STATE(577),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1497),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1497),
    [sym_jsx_element] = STATE(577),
    [sym_jsx_fragment] = STATE(577),
    [sym_jsx_opening_element] = STATE(975),
    [sym_jsx_self_closing_element] = STATE(577),
    [sym_class] = STATE(575),
    [sym_function] = STATE(575),
    [sym_generator_function] = STATE(575),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(577),
    [sym_await_expression] = STATE(577),
    [sym_member_expression] = STATE(430),
    [sym_subscript_expression] = STATE(430),
    [sym_assignment_expression] = STATE(577),
    [sym__augmented_assignment_lhs] = STATE(937),
    [sym_augmented_assignment_expression] = STATE(577),
    [sym__destructuring_pattern] = STATE(1497),
    [sym_ternary_expression] = STATE(577),
    [sym_binary_expression] = STATE(577),
    [sym_unary_expression] = STATE(577),
    [sym_update_expression] = STATE(577),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1533),
    [aux_sym_export_statement_repeat1] = STATE(1182),
    [sym_identifier] = ACTIONS(443),
    [anon_sym_export] = ACTIONS(445),
    [anon_sym_LBRACE] = ACTIONS(744),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(449),
    [anon_sym_yield] = ACTIONS(451),
    [anon_sym_LBRACK] = ACTIONS(427),
    [anon_sym_LT] = ACTIONS(585),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(453),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(455),
    [anon_sym_PLUS] = ACTIONS(457),
    [anon_sym_DASH] = ACTIONS(457),
    [anon_sym_BANG] = ACTIONS(459),
    [anon_sym_TILDE] = ACTIONS(459),
    [anon_sym_typeof] = ACTIONS(457),
    [anon_sym_void] = ACTIONS(457),
    [anon_sym_delete] = ACTIONS(457),
    [anon_sym_PLUS_PLUS] = ACTIONS(461),
    [anon_sym_DASH_DASH] = ACTIONS(461),
    [anon_sym_DQUOTE] = ACTIONS(361),
    [anon_sym_SQUOTE] = ACTIONS(363),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(365),
    [sym_number] = ACTIONS(367),
    [sym_this] = ACTIONS(369),
    [sym_super] = ACTIONS(369),
    [sym_true] = ACTIONS(369),
    [sym_false] = ACTIONS(369),
    [sym_null] = ACTIONS(369),
    [sym_undefined] = ACTIONS(463),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(445),
    [anon_sym_get] = ACTIONS(445),
    [anon_sym_set] = ACTIONS(445),
  },
  [149] = {
    [sym_import] = STATE(575),
    [sym_parenthesized_expression] = STATE(449),
    [sym_expression] = STATE(754),
    [sym_primary_expression] = STATE(576),
    [sym_yield_expression] = STATE(577),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1528),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1528),
    [sym_jsx_element] = STATE(577),
    [sym_jsx_fragment] = STATE(577),
    [sym_jsx_opening_element] = STATE(975),
    [sym_jsx_self_closing_element] = STATE(577),
    [sym_class] = STATE(575),
    [sym_function] = STATE(575),
    [sym_generator_function] = STATE(575),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(577),
    [sym_await_expression] = STATE(577),
    [sym_member_expression] = STATE(449),
    [sym_subscript_expression] = STATE(449),
    [sym_assignment_expression] = STATE(577),
    [sym__augmented_assignment_lhs] = STATE(943),
    [sym_augmented_assignment_expression] = STATE(577),
    [sym__destructuring_pattern] = STATE(1528),
    [sym_ternary_expression] = STATE(577),
    [sym_binary_expression] = STATE(577),
    [sym_unary_expression] = STATE(577),
    [sym_update_expression] = STATE(577),
    [sym_sequence_expression] = STATE(1579),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1496),
    [aux_sym_export_statement_repeat1] = STATE(1182),
    [sym_identifier] = ACTIONS(321),
    [anon_sym_export] = ACTIONS(323),
    [anon_sym_LBRACE] = ACTIONS(327),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(335),
    [anon_sym_yield] = ACTIONS(339),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LT] = ACTIONS(585),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(349),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(353),
    [anon_sym_PLUS] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(355),
    [anon_sym_BANG] = ACTIONS(357),
    [anon_sym_TILDE] = ACTIONS(357),
    [anon_sym_typeof] = ACTIONS(355),
    [anon_sym_void] = ACTIONS(355),
    [anon_sym_delete] = ACTIONS(355),
    [anon_sym_PLUS_PLUS] = ACTIONS(359),
    [anon_sym_DASH_DASH] = ACTIONS(359),
    [anon_sym_DQUOTE] = ACTIONS(361),
    [anon_sym_SQUOTE] = ACTIONS(363),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(365),
    [sym_number] = ACTIONS(367),
    [sym_this] = ACTIONS(369),
    [sym_super] = ACTIONS(369),
    [sym_true] = ACTIONS(369),
    [sym_false] = ACTIONS(369),
    [sym_null] = ACTIONS(369),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(323),
    [anon_sym_get] = ACTIONS(323),
    [anon_sym_set] = ACTIONS(323),
  },
  [150] = {
    [sym_import] = STATE(721),
    [sym_statement_block] = STATE(698),
    [sym_parenthesized_expression] = STATE(479),
    [sym_expression] = STATE(627),
    [sym_primary_expression] = STATE(743),
    [sym_yield_expression] = STATE(740),
    [sym_object] = STATE(721),
    [sym_object_pattern] = STATE(1548),
    [sym_array] = STATE(721),
    [sym_array_pattern] = STATE(1548),
    [sym_jsx_element] = STATE(740),
    [sym_jsx_fragment] = STATE(740),
    [sym_jsx_opening_element] = STATE(972),
    [sym_jsx_self_closing_element] = STATE(740),
    [sym_class] = STATE(721),
    [sym_function] = STATE(721),
    [sym_generator_function] = STATE(721),
    [sym_arrow_function] = STATE(721),
    [sym_call_expression] = STATE(721),
    [sym_new_expression] = STATE(740),
    [sym_await_expression] = STATE(740),
    [sym_member_expression] = STATE(479),
    [sym_subscript_expression] = STATE(479),
    [sym_assignment_expression] = STATE(740),
    [sym__augmented_assignment_lhs] = STATE(942),
    [sym_augmented_assignment_expression] = STATE(740),
    [sym__destructuring_pattern] = STATE(1548),
    [sym_ternary_expression] = STATE(740),
    [sym_binary_expression] = STATE(740),
    [sym_unary_expression] = STATE(740),
    [sym_update_expression] = STATE(740),
    [sym_string] = STATE(721),
    [sym_template_string] = STATE(721),
    [sym_regex] = STATE(721),
    [sym_meta_property] = STATE(721),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1546),
    [aux_sym_export_statement_repeat1] = STATE(1154),
    [sym_identifier] = ACTIONS(407),
    [anon_sym_export] = ACTIONS(409),
    [anon_sym_LBRACE] = ACTIONS(746),
    [anon_sym_import] = ACTIONS(381),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(391),
    [anon_sym_async] = ACTIONS(413),
    [anon_sym_function] = ACTIONS(395),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(67),
    [anon_sym_void] = ACTIONS(67),
    [anon_sym_delete] = ACTIONS(67),
    [anon_sym_PLUS_PLUS] = ACTIONS(71),
    [anon_sym_DASH_DASH] = ACTIONS(71),
    [anon_sym_DQUOTE] = ACTIONS(73),
    [anon_sym_SQUOTE] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(77),
    [sym_number] = ACTIONS(79),
    [sym_this] = ACTIONS(81),
    [sym_super] = ACTIONS(81),
    [sym_true] = ACTIONS(81),
    [sym_false] = ACTIONS(81),
    [sym_null] = ACTIONS(81),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(409),
    [anon_sym_get] = ACTIONS(409),
    [anon_sym_set] = ACTIONS(409),
  },
  [151] = {
    [sym_import] = STATE(575),
    [sym_parenthesized_expression] = STATE(449),
    [sym_expression] = STATE(764),
    [sym_primary_expression] = STATE(576),
    [sym_yield_expression] = STATE(577),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1528),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1528),
    [sym_jsx_element] = STATE(577),
    [sym_jsx_fragment] = STATE(577),
    [sym_jsx_opening_element] = STATE(975),
    [sym_jsx_self_closing_element] = STATE(577),
    [sym_class] = STATE(575),
    [sym_function] = STATE(575),
    [sym_generator_function] = STATE(575),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(577),
    [sym_await_expression] = STATE(577),
    [sym_member_expression] = STATE(449),
    [sym_subscript_expression] = STATE(449),
    [sym_assignment_expression] = STATE(577),
    [sym__augmented_assignment_lhs] = STATE(943),
    [sym_augmented_assignment_expression] = STATE(577),
    [sym__destructuring_pattern] = STATE(1528),
    [sym_ternary_expression] = STATE(577),
    [sym_binary_expression] = STATE(577),
    [sym_unary_expression] = STATE(577),
    [sym_update_expression] = STATE(577),
    [sym_sequence_expression] = STATE(1508),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1496),
    [aux_sym_export_statement_repeat1] = STATE(1182),
    [sym_identifier] = ACTIONS(321),
    [anon_sym_export] = ACTIONS(323),
    [anon_sym_LBRACE] = ACTIONS(327),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(335),
    [anon_sym_yield] = ACTIONS(339),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LT] = ACTIONS(585),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(349),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(353),
    [anon_sym_PLUS] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(355),
    [anon_sym_BANG] = ACTIONS(357),
    [anon_sym_TILDE] = ACTIONS(357),
    [anon_sym_typeof] = ACTIONS(355),
    [anon_sym_void] = ACTIONS(355),
    [anon_sym_delete] = ACTIONS(355),
    [anon_sym_PLUS_PLUS] = ACTIONS(359),
    [anon_sym_DASH_DASH] = ACTIONS(359),
    [anon_sym_DQUOTE] = ACTIONS(361),
    [anon_sym_SQUOTE] = ACTIONS(363),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(365),
    [sym_number] = ACTIONS(367),
    [sym_this] = ACTIONS(369),
    [sym_super] = ACTIONS(369),
    [sym_true] = ACTIONS(369),
    [sym_false] = ACTIONS(369),
    [sym_null] = ACTIONS(369),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(323),
    [anon_sym_get] = ACTIONS(323),
    [anon_sym_set] = ACTIONS(323),
  },
  [152] = {
    [sym_import] = STATE(575),
    [sym_parenthesized_expression] = STATE(449),
    [sym_expression] = STATE(753),
    [sym_primary_expression] = STATE(576),
    [sym_yield_expression] = STATE(577),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1528),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1528),
    [sym_jsx_element] = STATE(577),
    [sym_jsx_fragment] = STATE(577),
    [sym_jsx_opening_element] = STATE(975),
    [sym_jsx_self_closing_element] = STATE(577),
    [sym_class] = STATE(575),
    [sym_function] = STATE(575),
    [sym_generator_function] = STATE(575),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(577),
    [sym_await_expression] = STATE(577),
    [sym_member_expression] = STATE(449),
    [sym_subscript_expression] = STATE(449),
    [sym_assignment_expression] = STATE(577),
    [sym__augmented_assignment_lhs] = STATE(943),
    [sym_augmented_assignment_expression] = STATE(577),
    [sym__destructuring_pattern] = STATE(1528),
    [sym_ternary_expression] = STATE(577),
    [sym_binary_expression] = STATE(577),
    [sym_unary_expression] = STATE(577),
    [sym_update_expression] = STATE(577),
    [sym_sequence_expression] = STATE(1577),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1496),
    [aux_sym_export_statement_repeat1] = STATE(1182),
    [sym_identifier] = ACTIONS(321),
    [anon_sym_export] = ACTIONS(323),
    [anon_sym_LBRACE] = ACTIONS(327),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(335),
    [anon_sym_yield] = ACTIONS(339),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LT] = ACTIONS(585),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(349),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(353),
    [anon_sym_PLUS] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(355),
    [anon_sym_BANG] = ACTIONS(357),
    [anon_sym_TILDE] = ACTIONS(357),
    [anon_sym_typeof] = ACTIONS(355),
    [anon_sym_void] = ACTIONS(355),
    [anon_sym_delete] = ACTIONS(355),
    [anon_sym_PLUS_PLUS] = ACTIONS(359),
    [anon_sym_DASH_DASH] = ACTIONS(359),
    [anon_sym_DQUOTE] = ACTIONS(361),
    [anon_sym_SQUOTE] = ACTIONS(363),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(365),
    [sym_number] = ACTIONS(367),
    [sym_this] = ACTIONS(369),
    [sym_super] = ACTIONS(369),
    [sym_true] = ACTIONS(369),
    [sym_false] = ACTIONS(369),
    [sym_null] = ACTIONS(369),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(323),
    [anon_sym_get] = ACTIONS(323),
    [anon_sym_set] = ACTIONS(323),
  },
  [153] = {
    [sym_import] = STATE(575),
    [sym_statement_block] = STATE(516),
    [sym_parenthesized_expression] = STATE(430),
    [sym_expression] = STATE(748),
    [sym_primary_expression] = STATE(576),
    [sym_yield_expression] = STATE(577),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1497),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1497),
    [sym_jsx_element] = STATE(577),
    [sym_jsx_fragment] = STATE(577),
    [sym_jsx_opening_element] = STATE(975),
    [sym_jsx_self_closing_element] = STATE(577),
    [sym_class] = STATE(575),
    [sym_function] = STATE(575),
    [sym_generator_function] = STATE(575),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(577),
    [sym_await_expression] = STATE(577),
    [sym_member_expression] = STATE(430),
    [sym_subscript_expression] = STATE(430),
    [sym_assignment_expression] = STATE(577),
    [sym__augmented_assignment_lhs] = STATE(937),
    [sym_augmented_assignment_expression] = STATE(577),
    [sym__destructuring_pattern] = STATE(1497),
    [sym_ternary_expression] = STATE(577),
    [sym_binary_expression] = STATE(577),
    [sym_unary_expression] = STATE(577),
    [sym_update_expression] = STATE(577),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1533),
    [aux_sym_export_statement_repeat1] = STATE(1182),
    [sym_identifier] = ACTIONS(443),
    [anon_sym_export] = ACTIONS(445),
    [anon_sym_LBRACE] = ACTIONS(744),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(449),
    [anon_sym_yield] = ACTIONS(451),
    [anon_sym_LBRACK] = ACTIONS(427),
    [anon_sym_LT] = ACTIONS(585),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(453),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(455),
    [anon_sym_PLUS] = ACTIONS(457),
    [anon_sym_DASH] = ACTIONS(457),
    [anon_sym_BANG] = ACTIONS(459),
    [anon_sym_TILDE] = ACTIONS(459),
    [anon_sym_typeof] = ACTIONS(457),
    [anon_sym_void] = ACTIONS(457),
    [anon_sym_delete] = ACTIONS(457),
    [anon_sym_PLUS_PLUS] = ACTIONS(461),
    [anon_sym_DASH_DASH] = ACTIONS(461),
    [anon_sym_DQUOTE] = ACTIONS(361),
    [anon_sym_SQUOTE] = ACTIONS(363),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(365),
    [sym_number] = ACTIONS(367),
    [sym_this] = ACTIONS(369),
    [sym_super] = ACTIONS(369),
    [sym_true] = ACTIONS(369),
    [sym_false] = ACTIONS(369),
    [sym_null] = ACTIONS(369),
    [sym_undefined] = ACTIONS(463),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(445),
    [anon_sym_get] = ACTIONS(445),
    [anon_sym_set] = ACTIONS(445),
  },
  [154] = {
    [sym_import] = STATE(575),
    [sym_parenthesized_expression] = STATE(430),
    [sym_expression] = STATE(835),
    [sym_primary_expression] = STATE(502),
    [sym_yield_expression] = STATE(577),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1497),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1497),
    [sym_jsx_element] = STATE(577),
    [sym_jsx_fragment] = STATE(577),
    [sym_jsx_opening_element] = STATE(975),
    [sym_jsx_self_closing_element] = STATE(577),
    [sym_class] = STATE(575),
    [sym_function] = STATE(575),
    [sym_generator_function] = STATE(575),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(500),
    [sym_await_expression] = STATE(577),
    [sym_member_expression] = STATE(430),
    [sym_subscript_expression] = STATE(430),
    [sym_assignment_expression] = STATE(577),
    [sym__augmented_assignment_lhs] = STATE(937),
    [sym_augmented_assignment_expression] = STATE(577),
    [sym__destructuring_pattern] = STATE(1497),
    [sym_ternary_expression] = STATE(577),
    [sym_binary_expression] = STATE(577),
    [sym_unary_expression] = STATE(577),
    [sym_update_expression] = STATE(577),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1533),
    [aux_sym_export_statement_repeat1] = STATE(1182),
    [sym_identifier] = ACTIONS(443),
    [anon_sym_export] = ACTIONS(445),
    [anon_sym_LBRACE] = ACTIONS(421),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(449),
    [anon_sym_yield] = ACTIONS(451),
    [anon_sym_LBRACK] = ACTIONS(427),
    [anon_sym_LT] = ACTIONS(585),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_DOT] = ACTIONS(752),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(453),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(455),
    [anon_sym_PLUS] = ACTIONS(457),
    [anon_sym_DASH] = ACTIONS(457),
    [anon_sym_BANG] = ACTIONS(459),
    [anon_sym_TILDE] = ACTIONS(459),
    [anon_sym_typeof] = ACTIONS(457),
    [anon_sym_void] = ACTIONS(457),
    [anon_sym_delete] = ACTIONS(457),
    [anon_sym_PLUS_PLUS] = ACTIONS(461),
    [anon_sym_DASH_DASH] = ACTIONS(461),
    [anon_sym_DQUOTE] = ACTIONS(361),
    [anon_sym_SQUOTE] = ACTIONS(363),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(365),
    [sym_number] = ACTIONS(367),
    [sym_this] = ACTIONS(369),
    [sym_super] = ACTIONS(369),
    [sym_true] = ACTIONS(369),
    [sym_false] = ACTIONS(369),
    [sym_null] = ACTIONS(369),
    [sym_undefined] = ACTIONS(463),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(445),
    [anon_sym_get] = ACTIONS(445),
    [anon_sym_set] = ACTIONS(445),
  },
  [155] = {
    [sym_import] = STATE(575),
    [sym_parenthesized_expression] = STATE(493),
    [sym_expression] = STATE(821),
    [sym_primary_expression] = STATE(576),
    [sym_yield_expression] = STATE(577),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1580),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1580),
    [sym_jsx_element] = STATE(577),
    [sym_jsx_fragment] = STATE(577),
    [sym_jsx_opening_element] = STATE(975),
    [sym_jsx_self_closing_element] = STATE(577),
    [sym_class] = STATE(575),
    [sym_function] = STATE(575),
    [sym_generator_function] = STATE(575),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(577),
    [sym_await_expression] = STATE(577),
    [sym_member_expression] = STATE(493),
    [sym_subscript_expression] = STATE(493),
    [sym_assignment_expression] = STATE(577),
    [sym__augmented_assignment_lhs] = STATE(933),
    [sym_augmented_assignment_expression] = STATE(577),
    [sym__destructuring_pattern] = STATE(1580),
    [sym_ternary_expression] = STATE(577),
    [sym_binary_expression] = STATE(577),
    [sym_unary_expression] = STATE(577),
    [sym_update_expression] = STATE(577),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1555),
    [aux_sym_export_statement_repeat1] = STATE(1182),
    [sym_identifier] = ACTIONS(415),
    [anon_sym_export] = ACTIONS(417),
    [anon_sym_LBRACE] = ACTIONS(421),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(423),
    [anon_sym_yield] = ACTIONS(425),
    [anon_sym_LBRACK] = ACTIONS(427),
    [anon_sym_LT] = ACTIONS(585),
    [anon_sym_SLASH] = ACTIONS(429),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(431),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(433),
    [anon_sym_PLUS] = ACTIONS(435),
    [anon_sym_DASH] = ACTIONS(435),
    [anon_sym_BANG] = ACTIONS(437),
    [anon_sym_TILDE] = ACTIONS(437),
    [anon_sym_typeof] = ACTIONS(435),
    [anon_sym_void] = ACTIONS(435),
    [anon_sym_delete] = ACTIONS(435),
    [anon_sym_PLUS_PLUS] = ACTIONS(439),
    [anon_sym_DASH_DASH] = ACTIONS(439),
    [anon_sym_DQUOTE] = ACTIONS(361),
    [anon_sym_SQUOTE] = ACTIONS(363),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(365),
    [sym_number] = ACTIONS(367),
    [sym_this] = ACTIONS(369),
    [sym_super] = ACTIONS(369),
    [sym_true] = ACTIONS(369),
    [sym_false] = ACTIONS(369),
    [sym_null] = ACTIONS(369),
    [sym_undefined] = ACTIONS(441),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(417),
    [anon_sym_get] = ACTIONS(417),
    [anon_sym_set] = ACTIONS(417),
  },
  [156] = {
    [sym_import] = STATE(575),
    [sym_parenthesized_expression] = STATE(493),
    [sym_expression] = STATE(816),
    [sym_primary_expression] = STATE(576),
    [sym_yield_expression] = STATE(577),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1580),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1580),
    [sym_jsx_element] = STATE(577),
    [sym_jsx_fragment] = STATE(577),
    [sym_jsx_opening_element] = STATE(975),
    [sym_jsx_self_closing_element] = STATE(577),
    [sym_class] = STATE(575),
    [sym_function] = STATE(575),
    [sym_generator_function] = STATE(575),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(577),
    [sym_await_expression] = STATE(577),
    [sym_member_expression] = STATE(493),
    [sym_subscript_expression] = STATE(493),
    [sym_assignment_expression] = STATE(577),
    [sym__augmented_assignment_lhs] = STATE(933),
    [sym_augmented_assignment_expression] = STATE(577),
    [sym__destructuring_pattern] = STATE(1580),
    [sym_ternary_expression] = STATE(577),
    [sym_binary_expression] = STATE(577),
    [sym_unary_expression] = STATE(577),
    [sym_update_expression] = STATE(577),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1555),
    [aux_sym_export_statement_repeat1] = STATE(1182),
    [sym_identifier] = ACTIONS(415),
    [anon_sym_export] = ACTIONS(417),
    [anon_sym_LBRACE] = ACTIONS(421),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(423),
    [anon_sym_yield] = ACTIONS(425),
    [anon_sym_LBRACK] = ACTIONS(427),
    [anon_sym_LT] = ACTIONS(585),
    [anon_sym_SLASH] = ACTIONS(429),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(431),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(433),
    [anon_sym_PLUS] = ACTIONS(435),
    [anon_sym_DASH] = ACTIONS(435),
    [anon_sym_BANG] = ACTIONS(437),
    [anon_sym_TILDE] = ACTIONS(437),
    [anon_sym_typeof] = ACTIONS(435),
    [anon_sym_void] = ACTIONS(435),
    [anon_sym_delete] = ACTIONS(435),
    [anon_sym_PLUS_PLUS] = ACTIONS(439),
    [anon_sym_DASH_DASH] = ACTIONS(439),
    [anon_sym_DQUOTE] = ACTIONS(361),
    [anon_sym_SQUOTE] = ACTIONS(363),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(365),
    [sym_number] = ACTIONS(367),
    [sym_this] = ACTIONS(369),
    [sym_super] = ACTIONS(369),
    [sym_true] = ACTIONS(369),
    [sym_false] = ACTIONS(369),
    [sym_null] = ACTIONS(369),
    [sym_undefined] = ACTIONS(441),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(417),
    [anon_sym_get] = ACTIONS(417),
    [anon_sym_set] = ACTIONS(417),
  },
  [157] = {
    [sym_import] = STATE(575),
    [sym_parenthesized_expression] = STATE(449),
    [sym_expression] = STATE(586),
    [sym_primary_expression] = STATE(576),
    [sym_yield_expression] = STATE(577),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1528),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1528),
    [sym_jsx_element] = STATE(577),
    [sym_jsx_fragment] = STATE(577),
    [sym_jsx_opening_element] = STATE(975),
    [sym_jsx_self_closing_element] = STATE(577),
    [sym_class] = STATE(575),
    [sym_function] = STATE(575),
    [sym_generator_function] = STATE(575),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(577),
    [sym_await_expression] = STATE(577),
    [sym_member_expression] = STATE(449),
    [sym_subscript_expression] = STATE(449),
    [sym_assignment_expression] = STATE(577),
    [sym__augmented_assignment_lhs] = STATE(943),
    [sym_augmented_assignment_expression] = STATE(577),
    [sym__destructuring_pattern] = STATE(1528),
    [sym_ternary_expression] = STATE(577),
    [sym_binary_expression] = STATE(577),
    [sym_unary_expression] = STATE(577),
    [sym_update_expression] = STATE(577),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1496),
    [aux_sym_export_statement_repeat1] = STATE(1182),
    [sym_identifier] = ACTIONS(321),
    [anon_sym_export] = ACTIONS(323),
    [anon_sym_LBRACE] = ACTIONS(327),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(335),
    [anon_sym_yield] = ACTIONS(339),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LT] = ACTIONS(585),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(349),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(353),
    [anon_sym_PLUS] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(355),
    [anon_sym_BANG] = ACTIONS(357),
    [anon_sym_TILDE] = ACTIONS(357),
    [anon_sym_typeof] = ACTIONS(355),
    [anon_sym_void] = ACTIONS(355),
    [anon_sym_delete] = ACTIONS(355),
    [anon_sym_PLUS_PLUS] = ACTIONS(359),
    [anon_sym_DASH_DASH] = ACTIONS(359),
    [anon_sym_DQUOTE] = ACTIONS(361),
    [anon_sym_SQUOTE] = ACTIONS(363),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(365),
    [sym_number] = ACTIONS(367),
    [sym_this] = ACTIONS(369),
    [sym_super] = ACTIONS(369),
    [sym_true] = ACTIONS(369),
    [sym_false] = ACTIONS(369),
    [sym_null] = ACTIONS(369),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(323),
    [anon_sym_get] = ACTIONS(323),
    [anon_sym_set] = ACTIONS(323),
  },
  [158] = {
    [sym_import] = STATE(575),
    [sym_parenthesized_expression] = STATE(449),
    [sym_expression] = STATE(537),
    [sym_primary_expression] = STATE(576),
    [sym_yield_expression] = STATE(577),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1528),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1528),
    [sym_jsx_element] = STATE(577),
    [sym_jsx_fragment] = STATE(577),
    [sym_jsx_opening_element] = STATE(975),
    [sym_jsx_self_closing_element] = STATE(577),
    [sym_class] = STATE(575),
    [sym_function] = STATE(575),
    [sym_generator_function] = STATE(575),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(577),
    [sym_await_expression] = STATE(577),
    [sym_member_expression] = STATE(449),
    [sym_subscript_expression] = STATE(449),
    [sym_assignment_expression] = STATE(577),
    [sym__augmented_assignment_lhs] = STATE(943),
    [sym_augmented_assignment_expression] = STATE(577),
    [sym__destructuring_pattern] = STATE(1528),
    [sym_ternary_expression] = STATE(577),
    [sym_binary_expression] = STATE(577),
    [sym_unary_expression] = STATE(577),
    [sym_update_expression] = STATE(577),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1496),
    [aux_sym_export_statement_repeat1] = STATE(1182),
    [sym_identifier] = ACTIONS(321),
    [anon_sym_export] = ACTIONS(323),
    [anon_sym_LBRACE] = ACTIONS(327),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(335),
    [anon_sym_yield] = ACTIONS(339),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LT] = ACTIONS(585),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(349),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(353),
    [anon_sym_PLUS] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(355),
    [anon_sym_BANG] = ACTIONS(357),
    [anon_sym_TILDE] = ACTIONS(357),
    [anon_sym_typeof] = ACTIONS(355),
    [anon_sym_void] = ACTIONS(355),
    [anon_sym_delete] = ACTIONS(355),
    [anon_sym_PLUS_PLUS] = ACTIONS(359),
    [anon_sym_DASH_DASH] = ACTIONS(359),
    [anon_sym_DQUOTE] = ACTIONS(361),
    [anon_sym_SQUOTE] = ACTIONS(363),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(365),
    [sym_number] = ACTIONS(367),
    [sym_this] = ACTIONS(369),
    [sym_super] = ACTIONS(369),
    [sym_true] = ACTIONS(369),
    [sym_false] = ACTIONS(369),
    [sym_null] = ACTIONS(369),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(323),
    [anon_sym_get] = ACTIONS(323),
    [anon_sym_set] = ACTIONS(323),
  },
  [159] = {
    [sym_import] = STATE(575),
    [sym_parenthesized_expression] = STATE(430),
    [sym_expression] = STATE(818),
    [sym_primary_expression] = STATE(576),
    [sym_yield_expression] = STATE(577),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1497),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1497),
    [sym_jsx_element] = STATE(577),
    [sym_jsx_fragment] = STATE(577),
    [sym_jsx_opening_element] = STATE(975),
    [sym_jsx_self_closing_element] = STATE(577),
    [sym_class] = STATE(575),
    [sym_function] = STATE(575),
    [sym_generator_function] = STATE(575),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(577),
    [sym_await_expression] = STATE(577),
    [sym_member_expression] = STATE(430),
    [sym_subscript_expression] = STATE(430),
    [sym_assignment_expression] = STATE(577),
    [sym__augmented_assignment_lhs] = STATE(937),
    [sym_augmented_assignment_expression] = STATE(577),
    [sym__destructuring_pattern] = STATE(1497),
    [sym_ternary_expression] = STATE(577),
    [sym_binary_expression] = STATE(577),
    [sym_unary_expression] = STATE(577),
    [sym_update_expression] = STATE(577),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1533),
    [aux_sym_export_statement_repeat1] = STATE(1182),
    [sym_identifier] = ACTIONS(443),
    [anon_sym_export] = ACTIONS(445),
    [anon_sym_LBRACE] = ACTIONS(421),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(449),
    [anon_sym_yield] = ACTIONS(451),
    [anon_sym_LBRACK] = ACTIONS(427),
    [anon_sym_LT] = ACTIONS(585),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(453),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(455),
    [anon_sym_PLUS] = ACTIONS(457),
    [anon_sym_DASH] = ACTIONS(457),
    [anon_sym_BANG] = ACTIONS(459),
    [anon_sym_TILDE] = ACTIONS(459),
    [anon_sym_typeof] = ACTIONS(457),
    [anon_sym_void] = ACTIONS(457),
    [anon_sym_delete] = ACTIONS(457),
    [anon_sym_PLUS_PLUS] = ACTIONS(461),
    [anon_sym_DASH_DASH] = ACTIONS(461),
    [anon_sym_DQUOTE] = ACTIONS(361),
    [anon_sym_SQUOTE] = ACTIONS(363),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(365),
    [sym_number] = ACTIONS(367),
    [sym_this] = ACTIONS(369),
    [sym_super] = ACTIONS(369),
    [sym_true] = ACTIONS(369),
    [sym_false] = ACTIONS(369),
    [sym_null] = ACTIONS(369),
    [sym_undefined] = ACTIONS(463),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(445),
    [anon_sym_get] = ACTIONS(445),
    [anon_sym_set] = ACTIONS(445),
  },
  [160] = {
    [sym_import] = STATE(575),
    [sym_parenthesized_expression] = STATE(449),
    [sym_expression] = STATE(786),
    [sym_primary_expression] = STATE(576),
    [sym_yield_expression] = STATE(577),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1528),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1528),
    [sym_jsx_element] = STATE(577),
    [sym_jsx_fragment] = STATE(577),
    [sym_jsx_opening_element] = STATE(975),
    [sym_jsx_self_closing_element] = STATE(577),
    [sym_class] = STATE(575),
    [sym_function] = STATE(575),
    [sym_generator_function] = STATE(575),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(577),
    [sym_await_expression] = STATE(577),
    [sym_member_expression] = STATE(449),
    [sym_subscript_expression] = STATE(449),
    [sym_assignment_expression] = STATE(577),
    [sym__augmented_assignment_lhs] = STATE(943),
    [sym_augmented_assignment_expression] = STATE(577),
    [sym__destructuring_pattern] = STATE(1528),
    [sym_ternary_expression] = STATE(577),
    [sym_binary_expression] = STATE(577),
    [sym_unary_expression] = STATE(577),
    [sym_update_expression] = STATE(577),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1496),
    [aux_sym_export_statement_repeat1] = STATE(1182),
    [sym_identifier] = ACTIONS(321),
    [anon_sym_export] = ACTIONS(323),
    [anon_sym_LBRACE] = ACTIONS(327),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(335),
    [anon_sym_yield] = ACTIONS(339),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LT] = ACTIONS(585),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(349),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(353),
    [anon_sym_PLUS] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(355),
    [anon_sym_BANG] = ACTIONS(357),
    [anon_sym_TILDE] = ACTIONS(357),
    [anon_sym_typeof] = ACTIONS(355),
    [anon_sym_void] = ACTIONS(355),
    [anon_sym_delete] = ACTIONS(355),
    [anon_sym_PLUS_PLUS] = ACTIONS(359),
    [anon_sym_DASH_DASH] = ACTIONS(359),
    [anon_sym_DQUOTE] = ACTIONS(361),
    [anon_sym_SQUOTE] = ACTIONS(363),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(365),
    [sym_number] = ACTIONS(367),
    [sym_this] = ACTIONS(369),
    [sym_super] = ACTIONS(369),
    [sym_true] = ACTIONS(369),
    [sym_false] = ACTIONS(369),
    [sym_null] = ACTIONS(369),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(323),
    [anon_sym_get] = ACTIONS(323),
    [anon_sym_set] = ACTIONS(323),
  },
  [161] = {
    [sym_import] = STATE(575),
    [sym_parenthesized_expression] = STATE(449),
    [sym_expression] = STATE(496),
    [sym_primary_expression] = STATE(576),
    [sym_yield_expression] = STATE(577),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1528),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1528),
    [sym_jsx_element] = STATE(577),
    [sym_jsx_fragment] = STATE(577),
    [sym_jsx_opening_element] = STATE(975),
    [sym_jsx_self_closing_element] = STATE(577),
    [sym_class] = STATE(575),
    [sym_function] = STATE(575),
    [sym_generator_function] = STATE(575),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(577),
    [sym_await_expression] = STATE(577),
    [sym_member_expression] = STATE(449),
    [sym_subscript_expression] = STATE(449),
    [sym_assignment_expression] = STATE(577),
    [sym__augmented_assignment_lhs] = STATE(943),
    [sym_augmented_assignment_expression] = STATE(577),
    [sym__destructuring_pattern] = STATE(1528),
    [sym_ternary_expression] = STATE(577),
    [sym_binary_expression] = STATE(577),
    [sym_unary_expression] = STATE(577),
    [sym_update_expression] = STATE(577),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1496),
    [aux_sym_export_statement_repeat1] = STATE(1182),
    [sym_identifier] = ACTIONS(321),
    [anon_sym_export] = ACTIONS(323),
    [anon_sym_LBRACE] = ACTIONS(327),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(335),
    [anon_sym_yield] = ACTIONS(339),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LT] = ACTIONS(585),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(349),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(353),
    [anon_sym_PLUS] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(355),
    [anon_sym_BANG] = ACTIONS(357),
    [anon_sym_TILDE] = ACTIONS(357),
    [anon_sym_typeof] = ACTIONS(355),
    [anon_sym_void] = ACTIONS(355),
    [anon_sym_delete] = ACTIONS(355),
    [anon_sym_PLUS_PLUS] = ACTIONS(359),
    [anon_sym_DASH_DASH] = ACTIONS(359),
    [anon_sym_DQUOTE] = ACTIONS(361),
    [anon_sym_SQUOTE] = ACTIONS(363),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(365),
    [sym_number] = ACTIONS(367),
    [sym_this] = ACTIONS(369),
    [sym_super] = ACTIONS(369),
    [sym_true] = ACTIONS(369),
    [sym_false] = ACTIONS(369),
    [sym_null] = ACTIONS(369),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(323),
    [anon_sym_get] = ACTIONS(323),
    [anon_sym_set] = ACTIONS(323),
  },
  [162] = {
    [sym_import] = STATE(575),
    [sym_parenthesized_expression] = STATE(449),
    [sym_expression] = STATE(495),
    [sym_primary_expression] = STATE(576),
    [sym_yield_expression] = STATE(577),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1528),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1528),
    [sym_jsx_element] = STATE(577),
    [sym_jsx_fragment] = STATE(577),
    [sym_jsx_opening_element] = STATE(975),
    [sym_jsx_self_closing_element] = STATE(577),
    [sym_class] = STATE(575),
    [sym_function] = STATE(575),
    [sym_generator_function] = STATE(575),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(577),
    [sym_await_expression] = STATE(577),
    [sym_member_expression] = STATE(449),
    [sym_subscript_expression] = STATE(449),
    [sym_assignment_expression] = STATE(577),
    [sym__augmented_assignment_lhs] = STATE(943),
    [sym_augmented_assignment_expression] = STATE(577),
    [sym__destructuring_pattern] = STATE(1528),
    [sym_ternary_expression] = STATE(577),
    [sym_binary_expression] = STATE(577),
    [sym_unary_expression] = STATE(577),
    [sym_update_expression] = STATE(577),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1496),
    [aux_sym_export_statement_repeat1] = STATE(1182),
    [sym_identifier] = ACTIONS(321),
    [anon_sym_export] = ACTIONS(323),
    [anon_sym_LBRACE] = ACTIONS(327),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(335),
    [anon_sym_yield] = ACTIONS(339),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LT] = ACTIONS(585),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(349),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(353),
    [anon_sym_PLUS] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(355),
    [anon_sym_BANG] = ACTIONS(357),
    [anon_sym_TILDE] = ACTIONS(357),
    [anon_sym_typeof] = ACTIONS(355),
    [anon_sym_void] = ACTIONS(355),
    [anon_sym_delete] = ACTIONS(355),
    [anon_sym_PLUS_PLUS] = ACTIONS(359),
    [anon_sym_DASH_DASH] = ACTIONS(359),
    [anon_sym_DQUOTE] = ACTIONS(361),
    [anon_sym_SQUOTE] = ACTIONS(363),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(365),
    [sym_number] = ACTIONS(367),
    [sym_this] = ACTIONS(369),
    [sym_super] = ACTIONS(369),
    [sym_true] = ACTIONS(369),
    [sym_false] = ACTIONS(369),
    [sym_null] = ACTIONS(369),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(323),
    [anon_sym_get] = ACTIONS(323),
    [anon_sym_set] = ACTIONS(323),
  },
  [163] = {
    [sym_import] = STATE(575),
    [sym_parenthesized_expression] = STATE(449),
    [sym_expression] = STATE(787),
    [sym_primary_expression] = STATE(576),
    [sym_yield_expression] = STATE(577),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1528),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1528),
    [sym_jsx_element] = STATE(577),
    [sym_jsx_fragment] = STATE(577),
    [sym_jsx_opening_element] = STATE(975),
    [sym_jsx_self_closing_element] = STATE(577),
    [sym_class] = STATE(575),
    [sym_function] = STATE(575),
    [sym_generator_function] = STATE(575),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(577),
    [sym_await_expression] = STATE(577),
    [sym_member_expression] = STATE(449),
    [sym_subscript_expression] = STATE(449),
    [sym_assignment_expression] = STATE(577),
    [sym__augmented_assignment_lhs] = STATE(943),
    [sym_augmented_assignment_expression] = STATE(577),
    [sym__destructuring_pattern] = STATE(1528),
    [sym_ternary_expression] = STATE(577),
    [sym_binary_expression] = STATE(577),
    [sym_unary_expression] = STATE(577),
    [sym_update_expression] = STATE(577),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1496),
    [aux_sym_export_statement_repeat1] = STATE(1182),
    [sym_identifier] = ACTIONS(321),
    [anon_sym_export] = ACTIONS(323),
    [anon_sym_LBRACE] = ACTIONS(327),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(335),
    [anon_sym_yield] = ACTIONS(339),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LT] = ACTIONS(585),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(349),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(353),
    [anon_sym_PLUS] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(355),
    [anon_sym_BANG] = ACTIONS(357),
    [anon_sym_TILDE] = ACTIONS(357),
    [anon_sym_typeof] = ACTIONS(355),
    [anon_sym_void] = ACTIONS(355),
    [anon_sym_delete] = ACTIONS(355),
    [anon_sym_PLUS_PLUS] = ACTIONS(359),
    [anon_sym_DASH_DASH] = ACTIONS(359),
    [anon_sym_DQUOTE] = ACTIONS(361),
    [anon_sym_SQUOTE] = ACTIONS(363),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(365),
    [sym_number] = ACTIONS(367),
    [sym_this] = ACTIONS(369),
    [sym_super] = ACTIONS(369),
    [sym_true] = ACTIONS(369),
    [sym_false] = ACTIONS(369),
    [sym_null] = ACTIONS(369),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(323),
    [anon_sym_get] = ACTIONS(323),
    [anon_sym_set] = ACTIONS(323),
  },
  [164] = {
    [sym_import] = STATE(575),
    [sym_parenthesized_expression] = STATE(430),
    [sym_expression] = STATE(812),
    [sym_primary_expression] = STATE(576),
    [sym_yield_expression] = STATE(577),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1497),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1497),
    [sym_jsx_element] = STATE(577),
    [sym_jsx_fragment] = STATE(577),
    [sym_jsx_opening_element] = STATE(975),
    [sym_jsx_self_closing_element] = STATE(577),
    [sym_class] = STATE(575),
    [sym_function] = STATE(575),
    [sym_generator_function] = STATE(575),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(577),
    [sym_await_expression] = STATE(577),
    [sym_member_expression] = STATE(430),
    [sym_subscript_expression] = STATE(430),
    [sym_assignment_expression] = STATE(577),
    [sym__augmented_assignment_lhs] = STATE(937),
    [sym_augmented_assignment_expression] = STATE(577),
    [sym__destructuring_pattern] = STATE(1497),
    [sym_ternary_expression] = STATE(577),
    [sym_binary_expression] = STATE(577),
    [sym_unary_expression] = STATE(577),
    [sym_update_expression] = STATE(577),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1533),
    [aux_sym_export_statement_repeat1] = STATE(1182),
    [sym_identifier] = ACTIONS(443),
    [anon_sym_export] = ACTIONS(445),
    [anon_sym_LBRACE] = ACTIONS(421),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(449),
    [anon_sym_yield] = ACTIONS(451),
    [anon_sym_LBRACK] = ACTIONS(427),
    [anon_sym_LT] = ACTIONS(585),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(453),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(455),
    [anon_sym_PLUS] = ACTIONS(457),
    [anon_sym_DASH] = ACTIONS(457),
    [anon_sym_BANG] = ACTIONS(459),
    [anon_sym_TILDE] = ACTIONS(459),
    [anon_sym_typeof] = ACTIONS(457),
    [anon_sym_void] = ACTIONS(457),
    [anon_sym_delete] = ACTIONS(457),
    [anon_sym_PLUS_PLUS] = ACTIONS(461),
    [anon_sym_DASH_DASH] = ACTIONS(461),
    [anon_sym_DQUOTE] = ACTIONS(361),
    [anon_sym_SQUOTE] = ACTIONS(363),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(365),
    [sym_number] = ACTIONS(367),
    [sym_this] = ACTIONS(369),
    [sym_super] = ACTIONS(369),
    [sym_true] = ACTIONS(369),
    [sym_false] = ACTIONS(369),
    [sym_null] = ACTIONS(369),
    [sym_undefined] = ACTIONS(463),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(445),
    [anon_sym_get] = ACTIONS(445),
    [anon_sym_set] = ACTIONS(445),
  },
  [165] = {
    [sym_import] = STATE(721),
    [sym_parenthesized_expression] = STATE(466),
    [sym_expression] = STATE(592),
    [sym_primary_expression] = STATE(743),
    [sym_yield_expression] = STATE(740),
    [sym_object] = STATE(721),
    [sym_object_pattern] = STATE(1486),
    [sym_array] = STATE(721),
    [sym_array_pattern] = STATE(1486),
    [sym_jsx_element] = STATE(740),
    [sym_jsx_fragment] = STATE(740),
    [sym_jsx_opening_element] = STATE(972),
    [sym_jsx_self_closing_element] = STATE(740),
    [sym_class] = STATE(721),
    [sym_function] = STATE(721),
    [sym_generator_function] = STATE(721),
    [sym_arrow_function] = STATE(721),
    [sym_call_expression] = STATE(721),
    [sym_new_expression] = STATE(740),
    [sym_await_expression] = STATE(740),
    [sym_member_expression] = STATE(466),
    [sym_subscript_expression] = STATE(466),
    [sym_assignment_expression] = STATE(740),
    [sym__augmented_assignment_lhs] = STATE(940),
    [sym_augmented_assignment_expression] = STATE(740),
    [sym__destructuring_pattern] = STATE(1486),
    [sym_ternary_expression] = STATE(740),
    [sym_binary_expression] = STATE(740),
    [sym_unary_expression] = STATE(740),
    [sym_update_expression] = STATE(740),
    [sym_string] = STATE(721),
    [sym_template_string] = STATE(721),
    [sym_regex] = STATE(721),
    [sym_meta_property] = STATE(721),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1487),
    [aux_sym_export_statement_repeat1] = STATE(1154),
    [sym_identifier] = ACTIONS(373),
    [anon_sym_export] = ACTIONS(375),
    [anon_sym_LBRACE] = ACTIONS(379),
    [anon_sym_import] = ACTIONS(381),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(383),
    [anon_sym_yield] = ACTIONS(385),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(389),
    [anon_sym_class] = ACTIONS(391),
    [anon_sym_async] = ACTIONS(393),
    [anon_sym_function] = ACTIONS(395),
    [anon_sym_new] = ACTIONS(397),
    [anon_sym_PLUS] = ACTIONS(399),
    [anon_sym_DASH] = ACTIONS(399),
    [anon_sym_BANG] = ACTIONS(401),
    [anon_sym_TILDE] = ACTIONS(401),
    [anon_sym_typeof] = ACTIONS(399),
    [anon_sym_void] = ACTIONS(399),
    [anon_sym_delete] = ACTIONS(399),
    [anon_sym_PLUS_PLUS] = ACTIONS(403),
    [anon_sym_DASH_DASH] = ACTIONS(403),
    [anon_sym_DQUOTE] = ACTIONS(73),
    [anon_sym_SQUOTE] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(77),
    [sym_number] = ACTIONS(79),
    [sym_this] = ACTIONS(81),
    [sym_super] = ACTIONS(81),
    [sym_true] = ACTIONS(81),
    [sym_false] = ACTIONS(81),
    [sym_null] = ACTIONS(81),
    [sym_undefined] = ACTIONS(405),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(375),
    [anon_sym_get] = ACTIONS(375),
    [anon_sym_set] = ACTIONS(375),
  },
  [166] = {
    [sym_import] = STATE(575),
    [sym_parenthesized_expression] = STATE(493),
    [sym_expression] = STATE(496),
    [sym_primary_expression] = STATE(576),
    [sym_yield_expression] = STATE(577),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1580),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1580),
    [sym_jsx_element] = STATE(577),
    [sym_jsx_fragment] = STATE(577),
    [sym_jsx_opening_element] = STATE(975),
    [sym_jsx_self_closing_element] = STATE(577),
    [sym_class] = STATE(575),
    [sym_function] = STATE(575),
    [sym_generator_function] = STATE(575),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(577),
    [sym_await_expression] = STATE(577),
    [sym_member_expression] = STATE(493),
    [sym_subscript_expression] = STATE(493),
    [sym_assignment_expression] = STATE(577),
    [sym__augmented_assignment_lhs] = STATE(933),
    [sym_augmented_assignment_expression] = STATE(577),
    [sym__destructuring_pattern] = STATE(1580),
    [sym_ternary_expression] = STATE(577),
    [sym_binary_expression] = STATE(577),
    [sym_unary_expression] = STATE(577),
    [sym_update_expression] = STATE(577),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1555),
    [aux_sym_export_statement_repeat1] = STATE(1182),
    [sym_identifier] = ACTIONS(415),
    [anon_sym_export] = ACTIONS(417),
    [anon_sym_LBRACE] = ACTIONS(421),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(423),
    [anon_sym_yield] = ACTIONS(425),
    [anon_sym_LBRACK] = ACTIONS(427),
    [anon_sym_LT] = ACTIONS(585),
    [anon_sym_SLASH] = ACTIONS(429),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(431),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(433),
    [anon_sym_PLUS] = ACTIONS(435),
    [anon_sym_DASH] = ACTIONS(435),
    [anon_sym_BANG] = ACTIONS(437),
    [anon_sym_TILDE] = ACTIONS(437),
    [anon_sym_typeof] = ACTIONS(435),
    [anon_sym_void] = ACTIONS(435),
    [anon_sym_delete] = ACTIONS(435),
    [anon_sym_PLUS_PLUS] = ACTIONS(439),
    [anon_sym_DASH_DASH] = ACTIONS(439),
    [anon_sym_DQUOTE] = ACTIONS(361),
    [anon_sym_SQUOTE] = ACTIONS(363),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(365),
    [sym_number] = ACTIONS(367),
    [sym_this] = ACTIONS(369),
    [sym_super] = ACTIONS(369),
    [sym_true] = ACTIONS(369),
    [sym_false] = ACTIONS(369),
    [sym_null] = ACTIONS(369),
    [sym_undefined] = ACTIONS(441),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(417),
    [anon_sym_get] = ACTIONS(417),
    [anon_sym_set] = ACTIONS(417),
  },
  [167] = {
    [sym_import] = STATE(575),
    [sym_parenthesized_expression] = STATE(449),
    [sym_expression] = STATE(538),
    [sym_primary_expression] = STATE(576),
    [sym_yield_expression] = STATE(577),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1528),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1528),
    [sym_jsx_element] = STATE(577),
    [sym_jsx_fragment] = STATE(577),
    [sym_jsx_opening_element] = STATE(975),
    [sym_jsx_self_closing_element] = STATE(577),
    [sym_class] = STATE(575),
    [sym_function] = STATE(575),
    [sym_generator_function] = STATE(575),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(577),
    [sym_await_expression] = STATE(577),
    [sym_member_expression] = STATE(449),
    [sym_subscript_expression] = STATE(449),
    [sym_assignment_expression] = STATE(577),
    [sym__augmented_assignment_lhs] = STATE(943),
    [sym_augmented_assignment_expression] = STATE(577),
    [sym__destructuring_pattern] = STATE(1528),
    [sym_ternary_expression] = STATE(577),
    [sym_binary_expression] = STATE(577),
    [sym_unary_expression] = STATE(577),
    [sym_update_expression] = STATE(577),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1496),
    [aux_sym_export_statement_repeat1] = STATE(1182),
    [sym_identifier] = ACTIONS(321),
    [anon_sym_export] = ACTIONS(323),
    [anon_sym_LBRACE] = ACTIONS(327),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(335),
    [anon_sym_yield] = ACTIONS(339),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LT] = ACTIONS(585),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(349),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(353),
    [anon_sym_PLUS] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(355),
    [anon_sym_BANG] = ACTIONS(357),
    [anon_sym_TILDE] = ACTIONS(357),
    [anon_sym_typeof] = ACTIONS(355),
    [anon_sym_void] = ACTIONS(355),
    [anon_sym_delete] = ACTIONS(355),
    [anon_sym_PLUS_PLUS] = ACTIONS(359),
    [anon_sym_DASH_DASH] = ACTIONS(359),
    [anon_sym_DQUOTE] = ACTIONS(361),
    [anon_sym_SQUOTE] = ACTIONS(363),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(365),
    [sym_number] = ACTIONS(367),
    [sym_this] = ACTIONS(369),
    [sym_super] = ACTIONS(369),
    [sym_true] = ACTIONS(369),
    [sym_false] = ACTIONS(369),
    [sym_null] = ACTIONS(369),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(323),
    [anon_sym_get] = ACTIONS(323),
    [anon_sym_set] = ACTIONS(323),
  },
  [168] = {
    [sym_import] = STATE(721),
    [sym_parenthesized_expression] = STATE(466),
    [sym_expression] = STATE(648),
    [sym_primary_expression] = STATE(743),
    [sym_yield_expression] = STATE(740),
    [sym_object] = STATE(721),
    [sym_object_pattern] = STATE(1486),
    [sym_array] = STATE(721),
    [sym_array_pattern] = STATE(1486),
    [sym_jsx_element] = STATE(740),
    [sym_jsx_fragment] = STATE(740),
    [sym_jsx_opening_element] = STATE(972),
    [sym_jsx_self_closing_element] = STATE(740),
    [sym_class] = STATE(721),
    [sym_function] = STATE(721),
    [sym_generator_function] = STATE(721),
    [sym_arrow_function] = STATE(721),
    [sym_call_expression] = STATE(721),
    [sym_new_expression] = STATE(740),
    [sym_await_expression] = STATE(740),
    [sym_member_expression] = STATE(466),
    [sym_subscript_expression] = STATE(466),
    [sym_assignment_expression] = STATE(740),
    [sym__augmented_assignment_lhs] = STATE(940),
    [sym_augmented_assignment_expression] = STATE(740),
    [sym__destructuring_pattern] = STATE(1486),
    [sym_ternary_expression] = STATE(740),
    [sym_binary_expression] = STATE(740),
    [sym_unary_expression] = STATE(740),
    [sym_update_expression] = STATE(740),
    [sym_string] = STATE(721),
    [sym_template_string] = STATE(721),
    [sym_regex] = STATE(721),
    [sym_meta_property] = STATE(721),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1487),
    [aux_sym_export_statement_repeat1] = STATE(1154),
    [sym_identifier] = ACTIONS(373),
    [anon_sym_export] = ACTIONS(375),
    [anon_sym_LBRACE] = ACTIONS(379),
    [anon_sym_import] = ACTIONS(381),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(383),
    [anon_sym_yield] = ACTIONS(385),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(389),
    [anon_sym_class] = ACTIONS(391),
    [anon_sym_async] = ACTIONS(393),
    [anon_sym_function] = ACTIONS(395),
    [anon_sym_new] = ACTIONS(397),
    [anon_sym_PLUS] = ACTIONS(399),
    [anon_sym_DASH] = ACTIONS(399),
    [anon_sym_BANG] = ACTIONS(401),
    [anon_sym_TILDE] = ACTIONS(401),
    [anon_sym_typeof] = ACTIONS(399),
    [anon_sym_void] = ACTIONS(399),
    [anon_sym_delete] = ACTIONS(399),
    [anon_sym_PLUS_PLUS] = ACTIONS(403),
    [anon_sym_DASH_DASH] = ACTIONS(403),
    [anon_sym_DQUOTE] = ACTIONS(73),
    [anon_sym_SQUOTE] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(77),
    [sym_number] = ACTIONS(79),
    [sym_this] = ACTIONS(81),
    [sym_super] = ACTIONS(81),
    [sym_true] = ACTIONS(81),
    [sym_false] = ACTIONS(81),
    [sym_null] = ACTIONS(81),
    [sym_undefined] = ACTIONS(405),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(375),
    [anon_sym_get] = ACTIONS(375),
    [anon_sym_set] = ACTIONS(375),
  },
  [169] = {
    [sym_import] = STATE(575),
    [sym_parenthesized_expression] = STATE(430),
    [sym_expression] = STATE(498),
    [sym_primary_expression] = STATE(576),
    [sym_yield_expression] = STATE(577),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1497),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1497),
    [sym_jsx_element] = STATE(577),
    [sym_jsx_fragment] = STATE(577),
    [sym_jsx_opening_element] = STATE(975),
    [sym_jsx_self_closing_element] = STATE(577),
    [sym_class] = STATE(575),
    [sym_function] = STATE(575),
    [sym_generator_function] = STATE(575),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(577),
    [sym_await_expression] = STATE(577),
    [sym_member_expression] = STATE(430),
    [sym_subscript_expression] = STATE(430),
    [sym_assignment_expression] = STATE(577),
    [sym__augmented_assignment_lhs] = STATE(937),
    [sym_augmented_assignment_expression] = STATE(577),
    [sym__destructuring_pattern] = STATE(1497),
    [sym_ternary_expression] = STATE(577),
    [sym_binary_expression] = STATE(577),
    [sym_unary_expression] = STATE(577),
    [sym_update_expression] = STATE(577),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1533),
    [aux_sym_export_statement_repeat1] = STATE(1182),
    [sym_identifier] = ACTIONS(443),
    [anon_sym_export] = ACTIONS(445),
    [anon_sym_LBRACE] = ACTIONS(421),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(449),
    [anon_sym_yield] = ACTIONS(451),
    [anon_sym_LBRACK] = ACTIONS(427),
    [anon_sym_LT] = ACTIONS(585),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(453),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(455),
    [anon_sym_PLUS] = ACTIONS(457),
    [anon_sym_DASH] = ACTIONS(457),
    [anon_sym_BANG] = ACTIONS(459),
    [anon_sym_TILDE] = ACTIONS(459),
    [anon_sym_typeof] = ACTIONS(457),
    [anon_sym_void] = ACTIONS(457),
    [anon_sym_delete] = ACTIONS(457),
    [anon_sym_PLUS_PLUS] = ACTIONS(461),
    [anon_sym_DASH_DASH] = ACTIONS(461),
    [anon_sym_DQUOTE] = ACTIONS(361),
    [anon_sym_SQUOTE] = ACTIONS(363),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(365),
    [sym_number] = ACTIONS(367),
    [sym_this] = ACTIONS(369),
    [sym_super] = ACTIONS(369),
    [sym_true] = ACTIONS(369),
    [sym_false] = ACTIONS(369),
    [sym_null] = ACTIONS(369),
    [sym_undefined] = ACTIONS(463),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(445),
    [anon_sym_get] = ACTIONS(445),
    [anon_sym_set] = ACTIONS(445),
  },
  [170] = {
    [sym_import] = STATE(575),
    [sym_parenthesized_expression] = STATE(430),
    [sym_expression] = STATE(804),
    [sym_primary_expression] = STATE(576),
    [sym_yield_expression] = STATE(577),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1497),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1497),
    [sym_jsx_element] = STATE(577),
    [sym_jsx_fragment] = STATE(577),
    [sym_jsx_opening_element] = STATE(975),
    [sym_jsx_self_closing_element] = STATE(577),
    [sym_class] = STATE(575),
    [sym_function] = STATE(575),
    [sym_generator_function] = STATE(575),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(577),
    [sym_await_expression] = STATE(577),
    [sym_member_expression] = STATE(430),
    [sym_subscript_expression] = STATE(430),
    [sym_assignment_expression] = STATE(577),
    [sym__augmented_assignment_lhs] = STATE(937),
    [sym_augmented_assignment_expression] = STATE(577),
    [sym__destructuring_pattern] = STATE(1497),
    [sym_ternary_expression] = STATE(577),
    [sym_binary_expression] = STATE(577),
    [sym_unary_expression] = STATE(577),
    [sym_update_expression] = STATE(577),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1533),
    [aux_sym_export_statement_repeat1] = STATE(1182),
    [sym_identifier] = ACTIONS(443),
    [anon_sym_export] = ACTIONS(445),
    [anon_sym_LBRACE] = ACTIONS(421),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(449),
    [anon_sym_yield] = ACTIONS(451),
    [anon_sym_LBRACK] = ACTIONS(427),
    [anon_sym_LT] = ACTIONS(585),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(453),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(455),
    [anon_sym_PLUS] = ACTIONS(457),
    [anon_sym_DASH] = ACTIONS(457),
    [anon_sym_BANG] = ACTIONS(459),
    [anon_sym_TILDE] = ACTIONS(459),
    [anon_sym_typeof] = ACTIONS(457),
    [anon_sym_void] = ACTIONS(457),
    [anon_sym_delete] = ACTIONS(457),
    [anon_sym_PLUS_PLUS] = ACTIONS(461),
    [anon_sym_DASH_DASH] = ACTIONS(461),
    [anon_sym_DQUOTE] = ACTIONS(361),
    [anon_sym_SQUOTE] = ACTIONS(363),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(365),
    [sym_number] = ACTIONS(367),
    [sym_this] = ACTIONS(369),
    [sym_super] = ACTIONS(369),
    [sym_true] = ACTIONS(369),
    [sym_false] = ACTIONS(369),
    [sym_null] = ACTIONS(369),
    [sym_undefined] = ACTIONS(463),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(445),
    [anon_sym_get] = ACTIONS(445),
    [anon_sym_set] = ACTIONS(445),
  },
  [171] = {
    [sym_import] = STATE(721),
    [sym_parenthesized_expression] = STATE(479),
    [sym_expression] = STATE(592),
    [sym_primary_expression] = STATE(743),
    [sym_yield_expression] = STATE(740),
    [sym_object] = STATE(721),
    [sym_object_pattern] = STATE(1548),
    [sym_array] = STATE(721),
    [sym_array_pattern] = STATE(1548),
    [sym_jsx_element] = STATE(740),
    [sym_jsx_fragment] = STATE(740),
    [sym_jsx_opening_element] = STATE(972),
    [sym_jsx_self_closing_element] = STATE(740),
    [sym_class] = STATE(721),
    [sym_function] = STATE(721),
    [sym_generator_function] = STATE(721),
    [sym_arrow_function] = STATE(721),
    [sym_call_expression] = STATE(721),
    [sym_new_expression] = STATE(740),
    [sym_await_expression] = STATE(740),
    [sym_member_expression] = STATE(479),
    [sym_subscript_expression] = STATE(479),
    [sym_assignment_expression] = STATE(740),
    [sym__augmented_assignment_lhs] = STATE(942),
    [sym_augmented_assignment_expression] = STATE(740),
    [sym__destructuring_pattern] = STATE(1548),
    [sym_ternary_expression] = STATE(740),
    [sym_binary_expression] = STATE(740),
    [sym_unary_expression] = STATE(740),
    [sym_update_expression] = STATE(740),
    [sym_string] = STATE(721),
    [sym_template_string] = STATE(721),
    [sym_regex] = STATE(721),
    [sym_meta_property] = STATE(721),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1546),
    [aux_sym_export_statement_repeat1] = STATE(1154),
    [sym_identifier] = ACTIONS(407),
    [anon_sym_export] = ACTIONS(409),
    [anon_sym_LBRACE] = ACTIONS(379),
    [anon_sym_import] = ACTIONS(381),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(391),
    [anon_sym_async] = ACTIONS(413),
    [anon_sym_function] = ACTIONS(395),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(67),
    [anon_sym_void] = ACTIONS(67),
    [anon_sym_delete] = ACTIONS(67),
    [anon_sym_PLUS_PLUS] = ACTIONS(71),
    [anon_sym_DASH_DASH] = ACTIONS(71),
    [anon_sym_DQUOTE] = ACTIONS(73),
    [anon_sym_SQUOTE] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(77),
    [sym_number] = ACTIONS(79),
    [sym_this] = ACTIONS(81),
    [sym_super] = ACTIONS(81),
    [sym_true] = ACTIONS(81),
    [sym_false] = ACTIONS(81),
    [sym_null] = ACTIONS(81),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(409),
    [anon_sym_get] = ACTIONS(409),
    [anon_sym_set] = ACTIONS(409),
  },
  [172] = {
    [sym_import] = STATE(575),
    [sym_parenthesized_expression] = STATE(449),
    [sym_expression] = STATE(539),
    [sym_primary_expression] = STATE(576),
    [sym_yield_expression] = STATE(577),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1528),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1528),
    [sym_jsx_element] = STATE(577),
    [sym_jsx_fragment] = STATE(577),
    [sym_jsx_opening_element] = STATE(975),
    [sym_jsx_self_closing_element] = STATE(577),
    [sym_class] = STATE(575),
    [sym_function] = STATE(575),
    [sym_generator_function] = STATE(575),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(577),
    [sym_await_expression] = STATE(577),
    [sym_member_expression] = STATE(449),
    [sym_subscript_expression] = STATE(449),
    [sym_assignment_expression] = STATE(577),
    [sym__augmented_assignment_lhs] = STATE(943),
    [sym_augmented_assignment_expression] = STATE(577),
    [sym__destructuring_pattern] = STATE(1528),
    [sym_ternary_expression] = STATE(577),
    [sym_binary_expression] = STATE(577),
    [sym_unary_expression] = STATE(577),
    [sym_update_expression] = STATE(577),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1496),
    [aux_sym_export_statement_repeat1] = STATE(1182),
    [sym_identifier] = ACTIONS(321),
    [anon_sym_export] = ACTIONS(323),
    [anon_sym_LBRACE] = ACTIONS(327),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(335),
    [anon_sym_yield] = ACTIONS(339),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LT] = ACTIONS(585),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(349),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(353),
    [anon_sym_PLUS] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(355),
    [anon_sym_BANG] = ACTIONS(357),
    [anon_sym_TILDE] = ACTIONS(357),
    [anon_sym_typeof] = ACTIONS(355),
    [anon_sym_void] = ACTIONS(355),
    [anon_sym_delete] = ACTIONS(355),
    [anon_sym_PLUS_PLUS] = ACTIONS(359),
    [anon_sym_DASH_DASH] = ACTIONS(359),
    [anon_sym_DQUOTE] = ACTIONS(361),
    [anon_sym_SQUOTE] = ACTIONS(363),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(365),
    [sym_number] = ACTIONS(367),
    [sym_this] = ACTIONS(369),
    [sym_super] = ACTIONS(369),
    [sym_true] = ACTIONS(369),
    [sym_false] = ACTIONS(369),
    [sym_null] = ACTIONS(369),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(323),
    [anon_sym_get] = ACTIONS(323),
    [anon_sym_set] = ACTIONS(323),
  },
  [173] = {
    [sym_import] = STATE(575),
    [sym_parenthesized_expression] = STATE(430),
    [sym_expression] = STATE(805),
    [sym_primary_expression] = STATE(576),
    [sym_yield_expression] = STATE(577),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1497),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1497),
    [sym_jsx_element] = STATE(577),
    [sym_jsx_fragment] = STATE(577),
    [sym_jsx_opening_element] = STATE(975),
    [sym_jsx_self_closing_element] = STATE(577),
    [sym_class] = STATE(575),
    [sym_function] = STATE(575),
    [sym_generator_function] = STATE(575),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(577),
    [sym_await_expression] = STATE(577),
    [sym_member_expression] = STATE(430),
    [sym_subscript_expression] = STATE(430),
    [sym_assignment_expression] = STATE(577),
    [sym__augmented_assignment_lhs] = STATE(937),
    [sym_augmented_assignment_expression] = STATE(577),
    [sym__destructuring_pattern] = STATE(1497),
    [sym_ternary_expression] = STATE(577),
    [sym_binary_expression] = STATE(577),
    [sym_unary_expression] = STATE(577),
    [sym_update_expression] = STATE(577),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1533),
    [aux_sym_export_statement_repeat1] = STATE(1182),
    [sym_identifier] = ACTIONS(443),
    [anon_sym_export] = ACTIONS(445),
    [anon_sym_LBRACE] = ACTIONS(421),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(449),
    [anon_sym_yield] = ACTIONS(451),
    [anon_sym_LBRACK] = ACTIONS(427),
    [anon_sym_LT] = ACTIONS(585),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(453),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(455),
    [anon_sym_PLUS] = ACTIONS(457),
    [anon_sym_DASH] = ACTIONS(457),
    [anon_sym_BANG] = ACTIONS(459),
    [anon_sym_TILDE] = ACTIONS(459),
    [anon_sym_typeof] = ACTIONS(457),
    [anon_sym_void] = ACTIONS(457),
    [anon_sym_delete] = ACTIONS(457),
    [anon_sym_PLUS_PLUS] = ACTIONS(461),
    [anon_sym_DASH_DASH] = ACTIONS(461),
    [anon_sym_DQUOTE] = ACTIONS(361),
    [anon_sym_SQUOTE] = ACTIONS(363),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(365),
    [sym_number] = ACTIONS(367),
    [sym_this] = ACTIONS(369),
    [sym_super] = ACTIONS(369),
    [sym_true] = ACTIONS(369),
    [sym_false] = ACTIONS(369),
    [sym_null] = ACTIONS(369),
    [sym_undefined] = ACTIONS(463),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(445),
    [anon_sym_get] = ACTIONS(445),
    [anon_sym_set] = ACTIONS(445),
  },
  [174] = {
    [sym_import] = STATE(575),
    [sym_parenthesized_expression] = STATE(449),
    [sym_expression] = STATE(540),
    [sym_primary_expression] = STATE(576),
    [sym_yield_expression] = STATE(577),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1528),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1528),
    [sym_jsx_element] = STATE(577),
    [sym_jsx_fragment] = STATE(577),
    [sym_jsx_opening_element] = STATE(975),
    [sym_jsx_self_closing_element] = STATE(577),
    [sym_class] = STATE(575),
    [sym_function] = STATE(575),
    [sym_generator_function] = STATE(575),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(577),
    [sym_await_expression] = STATE(577),
    [sym_member_expression] = STATE(449),
    [sym_subscript_expression] = STATE(449),
    [sym_assignment_expression] = STATE(577),
    [sym__augmented_assignment_lhs] = STATE(943),
    [sym_augmented_assignment_expression] = STATE(577),
    [sym__destructuring_pattern] = STATE(1528),
    [sym_ternary_expression] = STATE(577),
    [sym_binary_expression] = STATE(577),
    [sym_unary_expression] = STATE(577),
    [sym_update_expression] = STATE(577),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1496),
    [aux_sym_export_statement_repeat1] = STATE(1182),
    [sym_identifier] = ACTIONS(321),
    [anon_sym_export] = ACTIONS(323),
    [anon_sym_LBRACE] = ACTIONS(327),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(335),
    [anon_sym_yield] = ACTIONS(339),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LT] = ACTIONS(585),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(349),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(353),
    [anon_sym_PLUS] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(355),
    [anon_sym_BANG] = ACTIONS(357),
    [anon_sym_TILDE] = ACTIONS(357),
    [anon_sym_typeof] = ACTIONS(355),
    [anon_sym_void] = ACTIONS(355),
    [anon_sym_delete] = ACTIONS(355),
    [anon_sym_PLUS_PLUS] = ACTIONS(359),
    [anon_sym_DASH_DASH] = ACTIONS(359),
    [anon_sym_DQUOTE] = ACTIONS(361),
    [anon_sym_SQUOTE] = ACTIONS(363),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(365),
    [sym_number] = ACTIONS(367),
    [sym_this] = ACTIONS(369),
    [sym_super] = ACTIONS(369),
    [sym_true] = ACTIONS(369),
    [sym_false] = ACTIONS(369),
    [sym_null] = ACTIONS(369),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(323),
    [anon_sym_get] = ACTIONS(323),
    [anon_sym_set] = ACTIONS(323),
  },
  [175] = {
    [sym_import] = STATE(575),
    [sym_parenthesized_expression] = STATE(449),
    [sym_expression] = STATE(596),
    [sym_primary_expression] = STATE(576),
    [sym_yield_expression] = STATE(577),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1528),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1528),
    [sym_jsx_element] = STATE(577),
    [sym_jsx_fragment] = STATE(577),
    [sym_jsx_opening_element] = STATE(975),
    [sym_jsx_self_closing_element] = STATE(577),
    [sym_class] = STATE(575),
    [sym_function] = STATE(575),
    [sym_generator_function] = STATE(575),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(577),
    [sym_await_expression] = STATE(577),
    [sym_member_expression] = STATE(449),
    [sym_subscript_expression] = STATE(449),
    [sym_assignment_expression] = STATE(577),
    [sym__augmented_assignment_lhs] = STATE(943),
    [sym_augmented_assignment_expression] = STATE(577),
    [sym__destructuring_pattern] = STATE(1528),
    [sym_ternary_expression] = STATE(577),
    [sym_binary_expression] = STATE(577),
    [sym_unary_expression] = STATE(577),
    [sym_update_expression] = STATE(577),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1496),
    [aux_sym_export_statement_repeat1] = STATE(1182),
    [sym_identifier] = ACTIONS(321),
    [anon_sym_export] = ACTIONS(323),
    [anon_sym_LBRACE] = ACTIONS(327),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(335),
    [anon_sym_yield] = ACTIONS(339),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LT] = ACTIONS(585),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(349),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(353),
    [anon_sym_PLUS] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(355),
    [anon_sym_BANG] = ACTIONS(357),
    [anon_sym_TILDE] = ACTIONS(357),
    [anon_sym_typeof] = ACTIONS(355),
    [anon_sym_void] = ACTIONS(355),
    [anon_sym_delete] = ACTIONS(355),
    [anon_sym_PLUS_PLUS] = ACTIONS(359),
    [anon_sym_DASH_DASH] = ACTIONS(359),
    [anon_sym_DQUOTE] = ACTIONS(361),
    [anon_sym_SQUOTE] = ACTIONS(363),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(365),
    [sym_number] = ACTIONS(367),
    [sym_this] = ACTIONS(369),
    [sym_super] = ACTIONS(369),
    [sym_true] = ACTIONS(369),
    [sym_false] = ACTIONS(369),
    [sym_null] = ACTIONS(369),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(323),
    [anon_sym_get] = ACTIONS(323),
    [anon_sym_set] = ACTIONS(323),
  },
  [176] = {
    [sym_import] = STATE(575),
    [sym_parenthesized_expression] = STATE(449),
    [sym_expression] = STATE(541),
    [sym_primary_expression] = STATE(576),
    [sym_yield_expression] = STATE(577),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1528),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1528),
    [sym_jsx_element] = STATE(577),
    [sym_jsx_fragment] = STATE(577),
    [sym_jsx_opening_element] = STATE(975),
    [sym_jsx_self_closing_element] = STATE(577),
    [sym_class] = STATE(575),
    [sym_function] = STATE(575),
    [sym_generator_function] = STATE(575),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(577),
    [sym_await_expression] = STATE(577),
    [sym_member_expression] = STATE(449),
    [sym_subscript_expression] = STATE(449),
    [sym_assignment_expression] = STATE(577),
    [sym__augmented_assignment_lhs] = STATE(943),
    [sym_augmented_assignment_expression] = STATE(577),
    [sym__destructuring_pattern] = STATE(1528),
    [sym_ternary_expression] = STATE(577),
    [sym_binary_expression] = STATE(577),
    [sym_unary_expression] = STATE(577),
    [sym_update_expression] = STATE(577),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1496),
    [aux_sym_export_statement_repeat1] = STATE(1182),
    [sym_identifier] = ACTIONS(321),
    [anon_sym_export] = ACTIONS(323),
    [anon_sym_LBRACE] = ACTIONS(327),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(335),
    [anon_sym_yield] = ACTIONS(339),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LT] = ACTIONS(585),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(349),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(353),
    [anon_sym_PLUS] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(355),
    [anon_sym_BANG] = ACTIONS(357),
    [anon_sym_TILDE] = ACTIONS(357),
    [anon_sym_typeof] = ACTIONS(355),
    [anon_sym_void] = ACTIONS(355),
    [anon_sym_delete] = ACTIONS(355),
    [anon_sym_PLUS_PLUS] = ACTIONS(359),
    [anon_sym_DASH_DASH] = ACTIONS(359),
    [anon_sym_DQUOTE] = ACTIONS(361),
    [anon_sym_SQUOTE] = ACTIONS(363),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(365),
    [sym_number] = ACTIONS(367),
    [sym_this] = ACTIONS(369),
    [sym_super] = ACTIONS(369),
    [sym_true] = ACTIONS(369),
    [sym_false] = ACTIONS(369),
    [sym_null] = ACTIONS(369),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(323),
    [anon_sym_get] = ACTIONS(323),
    [anon_sym_set] = ACTIONS(323),
  },
  [177] = {
    [sym_import] = STATE(575),
    [sym_parenthesized_expression] = STATE(449),
    [sym_expression] = STATE(546),
    [sym_primary_expression] = STATE(576),
    [sym_yield_expression] = STATE(577),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1528),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1528),
    [sym_jsx_element] = STATE(577),
    [sym_jsx_fragment] = STATE(577),
    [sym_jsx_opening_element] = STATE(975),
    [sym_jsx_self_closing_element] = STATE(577),
    [sym_class] = STATE(575),
    [sym_function] = STATE(575),
    [sym_generator_function] = STATE(575),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(577),
    [sym_await_expression] = STATE(577),
    [sym_member_expression] = STATE(449),
    [sym_subscript_expression] = STATE(449),
    [sym_assignment_expression] = STATE(577),
    [sym__augmented_assignment_lhs] = STATE(943),
    [sym_augmented_assignment_expression] = STATE(577),
    [sym__destructuring_pattern] = STATE(1528),
    [sym_ternary_expression] = STATE(577),
    [sym_binary_expression] = STATE(577),
    [sym_unary_expression] = STATE(577),
    [sym_update_expression] = STATE(577),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1496),
    [aux_sym_export_statement_repeat1] = STATE(1182),
    [sym_identifier] = ACTIONS(321),
    [anon_sym_export] = ACTIONS(323),
    [anon_sym_LBRACE] = ACTIONS(327),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(335),
    [anon_sym_yield] = ACTIONS(339),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LT] = ACTIONS(585),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(349),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(353),
    [anon_sym_PLUS] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(355),
    [anon_sym_BANG] = ACTIONS(357),
    [anon_sym_TILDE] = ACTIONS(357),
    [anon_sym_typeof] = ACTIONS(355),
    [anon_sym_void] = ACTIONS(355),
    [anon_sym_delete] = ACTIONS(355),
    [anon_sym_PLUS_PLUS] = ACTIONS(359),
    [anon_sym_DASH_DASH] = ACTIONS(359),
    [anon_sym_DQUOTE] = ACTIONS(361),
    [anon_sym_SQUOTE] = ACTIONS(363),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(365),
    [sym_number] = ACTIONS(367),
    [sym_this] = ACTIONS(369),
    [sym_super] = ACTIONS(369),
    [sym_true] = ACTIONS(369),
    [sym_false] = ACTIONS(369),
    [sym_null] = ACTIONS(369),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(323),
    [anon_sym_get] = ACTIONS(323),
    [anon_sym_set] = ACTIONS(323),
  },
  [178] = {
    [sym_import] = STATE(575),
    [sym_parenthesized_expression] = STATE(449),
    [sym_expression] = STATE(565),
    [sym_primary_expression] = STATE(576),
    [sym_yield_expression] = STATE(577),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1528),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1528),
    [sym_jsx_element] = STATE(577),
    [sym_jsx_fragment] = STATE(577),
    [sym_jsx_opening_element] = STATE(975),
    [sym_jsx_self_closing_element] = STATE(577),
    [sym_class] = STATE(575),
    [sym_function] = STATE(575),
    [sym_generator_function] = STATE(575),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(577),
    [sym_await_expression] = STATE(577),
    [sym_member_expression] = STATE(449),
    [sym_subscript_expression] = STATE(449),
    [sym_assignment_expression] = STATE(577),
    [sym__augmented_assignment_lhs] = STATE(943),
    [sym_augmented_assignment_expression] = STATE(577),
    [sym__destructuring_pattern] = STATE(1528),
    [sym_ternary_expression] = STATE(577),
    [sym_binary_expression] = STATE(577),
    [sym_unary_expression] = STATE(577),
    [sym_update_expression] = STATE(577),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1496),
    [aux_sym_export_statement_repeat1] = STATE(1182),
    [sym_identifier] = ACTIONS(321),
    [anon_sym_export] = ACTIONS(323),
    [anon_sym_LBRACE] = ACTIONS(327),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(335),
    [anon_sym_yield] = ACTIONS(339),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LT] = ACTIONS(585),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(349),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(353),
    [anon_sym_PLUS] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(355),
    [anon_sym_BANG] = ACTIONS(357),
    [anon_sym_TILDE] = ACTIONS(357),
    [anon_sym_typeof] = ACTIONS(355),
    [anon_sym_void] = ACTIONS(355),
    [anon_sym_delete] = ACTIONS(355),
    [anon_sym_PLUS_PLUS] = ACTIONS(359),
    [anon_sym_DASH_DASH] = ACTIONS(359),
    [anon_sym_DQUOTE] = ACTIONS(361),
    [anon_sym_SQUOTE] = ACTIONS(363),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(365),
    [sym_number] = ACTIONS(367),
    [sym_this] = ACTIONS(369),
    [sym_super] = ACTIONS(369),
    [sym_true] = ACTIONS(369),
    [sym_false] = ACTIONS(369),
    [sym_null] = ACTIONS(369),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(323),
    [anon_sym_get] = ACTIONS(323),
    [anon_sym_set] = ACTIONS(323),
  },
  [179] = {
    [sym_import] = STATE(721),
    [sym_parenthesized_expression] = STATE(466),
    [sym_expression] = STATE(651),
    [sym_primary_expression] = STATE(743),
    [sym_yield_expression] = STATE(740),
    [sym_object] = STATE(721),
    [sym_object_pattern] = STATE(1486),
    [sym_array] = STATE(721),
    [sym_array_pattern] = STATE(1486),
    [sym_jsx_element] = STATE(740),
    [sym_jsx_fragment] = STATE(740),
    [sym_jsx_opening_element] = STATE(972),
    [sym_jsx_self_closing_element] = STATE(740),
    [sym_class] = STATE(721),
    [sym_function] = STATE(721),
    [sym_generator_function] = STATE(721),
    [sym_arrow_function] = STATE(721),
    [sym_call_expression] = STATE(721),
    [sym_new_expression] = STATE(740),
    [sym_await_expression] = STATE(740),
    [sym_member_expression] = STATE(466),
    [sym_subscript_expression] = STATE(466),
    [sym_assignment_expression] = STATE(740),
    [sym__augmented_assignment_lhs] = STATE(940),
    [sym_augmented_assignment_expression] = STATE(740),
    [sym__destructuring_pattern] = STATE(1486),
    [sym_ternary_expression] = STATE(740),
    [sym_binary_expression] = STATE(740),
    [sym_unary_expression] = STATE(740),
    [sym_update_expression] = STATE(740),
    [sym_string] = STATE(721),
    [sym_template_string] = STATE(721),
    [sym_regex] = STATE(721),
    [sym_meta_property] = STATE(721),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1487),
    [aux_sym_export_statement_repeat1] = STATE(1154),
    [sym_identifier] = ACTIONS(373),
    [anon_sym_export] = ACTIONS(375),
    [anon_sym_LBRACE] = ACTIONS(379),
    [anon_sym_import] = ACTIONS(381),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(383),
    [anon_sym_yield] = ACTIONS(385),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(389),
    [anon_sym_class] = ACTIONS(391),
    [anon_sym_async] = ACTIONS(393),
    [anon_sym_function] = ACTIONS(395),
    [anon_sym_new] = ACTIONS(397),
    [anon_sym_PLUS] = ACTIONS(399),
    [anon_sym_DASH] = ACTIONS(399),
    [anon_sym_BANG] = ACTIONS(401),
    [anon_sym_TILDE] = ACTIONS(401),
    [anon_sym_typeof] = ACTIONS(399),
    [anon_sym_void] = ACTIONS(399),
    [anon_sym_delete] = ACTIONS(399),
    [anon_sym_PLUS_PLUS] = ACTIONS(403),
    [anon_sym_DASH_DASH] = ACTIONS(403),
    [anon_sym_DQUOTE] = ACTIONS(73),
    [anon_sym_SQUOTE] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(77),
    [sym_number] = ACTIONS(79),
    [sym_this] = ACTIONS(81),
    [sym_super] = ACTIONS(81),
    [sym_true] = ACTIONS(81),
    [sym_false] = ACTIONS(81),
    [sym_null] = ACTIONS(81),
    [sym_undefined] = ACTIONS(405),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(375),
    [anon_sym_get] = ACTIONS(375),
    [anon_sym_set] = ACTIONS(375),
  },
  [180] = {
    [sym_import] = STATE(575),
    [sym_parenthesized_expression] = STATE(449),
    [sym_expression] = STATE(582),
    [sym_primary_expression] = STATE(576),
    [sym_yield_expression] = STATE(577),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1528),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1528),
    [sym_jsx_element] = STATE(577),
    [sym_jsx_fragment] = STATE(577),
    [sym_jsx_opening_element] = STATE(975),
    [sym_jsx_self_closing_element] = STATE(577),
    [sym_class] = STATE(575),
    [sym_function] = STATE(575),
    [sym_generator_function] = STATE(575),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(577),
    [sym_await_expression] = STATE(577),
    [sym_member_expression] = STATE(449),
    [sym_subscript_expression] = STATE(449),
    [sym_assignment_expression] = STATE(577),
    [sym__augmented_assignment_lhs] = STATE(943),
    [sym_augmented_assignment_expression] = STATE(577),
    [sym__destructuring_pattern] = STATE(1528),
    [sym_ternary_expression] = STATE(577),
    [sym_binary_expression] = STATE(577),
    [sym_unary_expression] = STATE(577),
    [sym_update_expression] = STATE(577),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1496),
    [aux_sym_export_statement_repeat1] = STATE(1182),
    [sym_identifier] = ACTIONS(321),
    [anon_sym_export] = ACTIONS(323),
    [anon_sym_LBRACE] = ACTIONS(327),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(335),
    [anon_sym_yield] = ACTIONS(339),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LT] = ACTIONS(585),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(349),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(353),
    [anon_sym_PLUS] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(355),
    [anon_sym_BANG] = ACTIONS(357),
    [anon_sym_TILDE] = ACTIONS(357),
    [anon_sym_typeof] = ACTIONS(355),
    [anon_sym_void] = ACTIONS(355),
    [anon_sym_delete] = ACTIONS(355),
    [anon_sym_PLUS_PLUS] = ACTIONS(359),
    [anon_sym_DASH_DASH] = ACTIONS(359),
    [anon_sym_DQUOTE] = ACTIONS(361),
    [anon_sym_SQUOTE] = ACTIONS(363),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(365),
    [sym_number] = ACTIONS(367),
    [sym_this] = ACTIONS(369),
    [sym_super] = ACTIONS(369),
    [sym_true] = ACTIONS(369),
    [sym_false] = ACTIONS(369),
    [sym_null] = ACTIONS(369),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(323),
    [anon_sym_get] = ACTIONS(323),
    [anon_sym_set] = ACTIONS(323),
  },
  [181] = {
    [sym_import] = STATE(575),
    [sym_parenthesized_expression] = STATE(493),
    [sym_expression] = STATE(495),
    [sym_primary_expression] = STATE(576),
    [sym_yield_expression] = STATE(577),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1580),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1580),
    [sym_jsx_element] = STATE(577),
    [sym_jsx_fragment] = STATE(577),
    [sym_jsx_opening_element] = STATE(975),
    [sym_jsx_self_closing_element] = STATE(577),
    [sym_class] = STATE(575),
    [sym_function] = STATE(575),
    [sym_generator_function] = STATE(575),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(577),
    [sym_await_expression] = STATE(577),
    [sym_member_expression] = STATE(493),
    [sym_subscript_expression] = STATE(493),
    [sym_assignment_expression] = STATE(577),
    [sym__augmented_assignment_lhs] = STATE(933),
    [sym_augmented_assignment_expression] = STATE(577),
    [sym__destructuring_pattern] = STATE(1580),
    [sym_ternary_expression] = STATE(577),
    [sym_binary_expression] = STATE(577),
    [sym_unary_expression] = STATE(577),
    [sym_update_expression] = STATE(577),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1555),
    [aux_sym_export_statement_repeat1] = STATE(1182),
    [sym_identifier] = ACTIONS(415),
    [anon_sym_export] = ACTIONS(417),
    [anon_sym_LBRACE] = ACTIONS(421),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(423),
    [anon_sym_yield] = ACTIONS(425),
    [anon_sym_LBRACK] = ACTIONS(427),
    [anon_sym_LT] = ACTIONS(585),
    [anon_sym_SLASH] = ACTIONS(429),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(431),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(433),
    [anon_sym_PLUS] = ACTIONS(435),
    [anon_sym_DASH] = ACTIONS(435),
    [anon_sym_BANG] = ACTIONS(437),
    [anon_sym_TILDE] = ACTIONS(437),
    [anon_sym_typeof] = ACTIONS(435),
    [anon_sym_void] = ACTIONS(435),
    [anon_sym_delete] = ACTIONS(435),
    [anon_sym_PLUS_PLUS] = ACTIONS(439),
    [anon_sym_DASH_DASH] = ACTIONS(439),
    [anon_sym_DQUOTE] = ACTIONS(361),
    [anon_sym_SQUOTE] = ACTIONS(363),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(365),
    [sym_number] = ACTIONS(367),
    [sym_this] = ACTIONS(369),
    [sym_super] = ACTIONS(369),
    [sym_true] = ACTIONS(369),
    [sym_false] = ACTIONS(369),
    [sym_null] = ACTIONS(369),
    [sym_undefined] = ACTIONS(441),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(417),
    [anon_sym_get] = ACTIONS(417),
    [anon_sym_set] = ACTIONS(417),
  },
  [182] = {
    [sym_import] = STATE(575),
    [sym_parenthesized_expression] = STATE(493),
    [sym_expression] = STATE(830),
    [sym_primary_expression] = STATE(576),
    [sym_yield_expression] = STATE(577),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1580),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1580),
    [sym_jsx_element] = STATE(577),
    [sym_jsx_fragment] = STATE(577),
    [sym_jsx_opening_element] = STATE(975),
    [sym_jsx_self_closing_element] = STATE(577),
    [sym_class] = STATE(575),
    [sym_function] = STATE(575),
    [sym_generator_function] = STATE(575),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(577),
    [sym_await_expression] = STATE(577),
    [sym_member_expression] = STATE(493),
    [sym_subscript_expression] = STATE(493),
    [sym_assignment_expression] = STATE(577),
    [sym__augmented_assignment_lhs] = STATE(933),
    [sym_augmented_assignment_expression] = STATE(577),
    [sym__destructuring_pattern] = STATE(1580),
    [sym_ternary_expression] = STATE(577),
    [sym_binary_expression] = STATE(577),
    [sym_unary_expression] = STATE(577),
    [sym_update_expression] = STATE(577),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1555),
    [aux_sym_export_statement_repeat1] = STATE(1182),
    [sym_identifier] = ACTIONS(415),
    [anon_sym_export] = ACTIONS(417),
    [anon_sym_LBRACE] = ACTIONS(421),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(423),
    [anon_sym_yield] = ACTIONS(425),
    [anon_sym_LBRACK] = ACTIONS(427),
    [anon_sym_LT] = ACTIONS(585),
    [anon_sym_SLASH] = ACTIONS(429),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(431),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(433),
    [anon_sym_PLUS] = ACTIONS(435),
    [anon_sym_DASH] = ACTIONS(435),
    [anon_sym_BANG] = ACTIONS(437),
    [anon_sym_TILDE] = ACTIONS(437),
    [anon_sym_typeof] = ACTIONS(435),
    [anon_sym_void] = ACTIONS(435),
    [anon_sym_delete] = ACTIONS(435),
    [anon_sym_PLUS_PLUS] = ACTIONS(439),
    [anon_sym_DASH_DASH] = ACTIONS(439),
    [anon_sym_DQUOTE] = ACTIONS(361),
    [anon_sym_SQUOTE] = ACTIONS(363),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(365),
    [sym_number] = ACTIONS(367),
    [sym_this] = ACTIONS(369),
    [sym_super] = ACTIONS(369),
    [sym_true] = ACTIONS(369),
    [sym_false] = ACTIONS(369),
    [sym_null] = ACTIONS(369),
    [sym_undefined] = ACTIONS(441),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(417),
    [anon_sym_get] = ACTIONS(417),
    [anon_sym_set] = ACTIONS(417),
  },
  [183] = {
    [sym_import] = STATE(721),
    [sym_parenthesized_expression] = STATE(479),
    [sym_expression] = STATE(595),
    [sym_primary_expression] = STATE(743),
    [sym_yield_expression] = STATE(740),
    [sym_object] = STATE(721),
    [sym_object_pattern] = STATE(1548),
    [sym_array] = STATE(721),
    [sym_array_pattern] = STATE(1548),
    [sym_jsx_element] = STATE(740),
    [sym_jsx_fragment] = STATE(740),
    [sym_jsx_opening_element] = STATE(972),
    [sym_jsx_self_closing_element] = STATE(740),
    [sym_class] = STATE(721),
    [sym_function] = STATE(721),
    [sym_generator_function] = STATE(721),
    [sym_arrow_function] = STATE(721),
    [sym_call_expression] = STATE(721),
    [sym_new_expression] = STATE(740),
    [sym_await_expression] = STATE(740),
    [sym_member_expression] = STATE(479),
    [sym_subscript_expression] = STATE(479),
    [sym_assignment_expression] = STATE(740),
    [sym__augmented_assignment_lhs] = STATE(942),
    [sym_augmented_assignment_expression] = STATE(740),
    [sym__destructuring_pattern] = STATE(1548),
    [sym_ternary_expression] = STATE(740),
    [sym_binary_expression] = STATE(740),
    [sym_unary_expression] = STATE(740),
    [sym_update_expression] = STATE(740),
    [sym_string] = STATE(721),
    [sym_template_string] = STATE(721),
    [sym_regex] = STATE(721),
    [sym_meta_property] = STATE(721),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1546),
    [aux_sym_export_statement_repeat1] = STATE(1154),
    [sym_identifier] = ACTIONS(407),
    [anon_sym_export] = ACTIONS(409),
    [anon_sym_LBRACE] = ACTIONS(379),
    [anon_sym_import] = ACTIONS(381),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(391),
    [anon_sym_async] = ACTIONS(413),
    [anon_sym_function] = ACTIONS(395),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(67),
    [anon_sym_void] = ACTIONS(67),
    [anon_sym_delete] = ACTIONS(67),
    [anon_sym_PLUS_PLUS] = ACTIONS(71),
    [anon_sym_DASH_DASH] = ACTIONS(71),
    [anon_sym_DQUOTE] = ACTIONS(73),
    [anon_sym_SQUOTE] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(77),
    [sym_number] = ACTIONS(79),
    [sym_this] = ACTIONS(81),
    [sym_super] = ACTIONS(81),
    [sym_true] = ACTIONS(81),
    [sym_false] = ACTIONS(81),
    [sym_null] = ACTIONS(81),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(409),
    [anon_sym_get] = ACTIONS(409),
    [anon_sym_set] = ACTIONS(409),
  },
  [184] = {
    [sym_import] = STATE(721),
    [sym_parenthesized_expression] = STATE(479),
    [sym_expression] = STATE(649),
    [sym_primary_expression] = STATE(743),
    [sym_yield_expression] = STATE(740),
    [sym_object] = STATE(721),
    [sym_object_pattern] = STATE(1548),
    [sym_array] = STATE(721),
    [sym_array_pattern] = STATE(1548),
    [sym_jsx_element] = STATE(740),
    [sym_jsx_fragment] = STATE(740),
    [sym_jsx_opening_element] = STATE(972),
    [sym_jsx_self_closing_element] = STATE(740),
    [sym_class] = STATE(721),
    [sym_function] = STATE(721),
    [sym_generator_function] = STATE(721),
    [sym_arrow_function] = STATE(721),
    [sym_call_expression] = STATE(721),
    [sym_new_expression] = STATE(740),
    [sym_await_expression] = STATE(740),
    [sym_member_expression] = STATE(479),
    [sym_subscript_expression] = STATE(479),
    [sym_assignment_expression] = STATE(740),
    [sym__augmented_assignment_lhs] = STATE(942),
    [sym_augmented_assignment_expression] = STATE(740),
    [sym__destructuring_pattern] = STATE(1548),
    [sym_ternary_expression] = STATE(740),
    [sym_binary_expression] = STATE(740),
    [sym_unary_expression] = STATE(740),
    [sym_update_expression] = STATE(740),
    [sym_string] = STATE(721),
    [sym_template_string] = STATE(721),
    [sym_regex] = STATE(721),
    [sym_meta_property] = STATE(721),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1546),
    [aux_sym_export_statement_repeat1] = STATE(1154),
    [sym_identifier] = ACTIONS(407),
    [anon_sym_export] = ACTIONS(409),
    [anon_sym_LBRACE] = ACTIONS(379),
    [anon_sym_import] = ACTIONS(381),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(391),
    [anon_sym_async] = ACTIONS(413),
    [anon_sym_function] = ACTIONS(395),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(67),
    [anon_sym_void] = ACTIONS(67),
    [anon_sym_delete] = ACTIONS(67),
    [anon_sym_PLUS_PLUS] = ACTIONS(71),
    [anon_sym_DASH_DASH] = ACTIONS(71),
    [anon_sym_DQUOTE] = ACTIONS(73),
    [anon_sym_SQUOTE] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(77),
    [sym_number] = ACTIONS(79),
    [sym_this] = ACTIONS(81),
    [sym_super] = ACTIONS(81),
    [sym_true] = ACTIONS(81),
    [sym_false] = ACTIONS(81),
    [sym_null] = ACTIONS(81),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(409),
    [anon_sym_get] = ACTIONS(409),
    [anon_sym_set] = ACTIONS(409),
  },
  [185] = {
    [sym_import] = STATE(575),
    [sym_parenthesized_expression] = STATE(493),
    [sym_expression] = STATE(826),
    [sym_primary_expression] = STATE(576),
    [sym_yield_expression] = STATE(577),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1580),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1580),
    [sym_jsx_element] = STATE(577),
    [sym_jsx_fragment] = STATE(577),
    [sym_jsx_opening_element] = STATE(975),
    [sym_jsx_self_closing_element] = STATE(577),
    [sym_class] = STATE(575),
    [sym_function] = STATE(575),
    [sym_generator_function] = STATE(575),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(577),
    [sym_await_expression] = STATE(577),
    [sym_member_expression] = STATE(493),
    [sym_subscript_expression] = STATE(493),
    [sym_assignment_expression] = STATE(577),
    [sym__augmented_assignment_lhs] = STATE(933),
    [sym_augmented_assignment_expression] = STATE(577),
    [sym__destructuring_pattern] = STATE(1580),
    [sym_ternary_expression] = STATE(577),
    [sym_binary_expression] = STATE(577),
    [sym_unary_expression] = STATE(577),
    [sym_update_expression] = STATE(577),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1555),
    [aux_sym_export_statement_repeat1] = STATE(1182),
    [sym_identifier] = ACTIONS(415),
    [anon_sym_export] = ACTIONS(417),
    [anon_sym_LBRACE] = ACTIONS(421),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(423),
    [anon_sym_yield] = ACTIONS(425),
    [anon_sym_LBRACK] = ACTIONS(427),
    [anon_sym_LT] = ACTIONS(585),
    [anon_sym_SLASH] = ACTIONS(429),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(431),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(433),
    [anon_sym_PLUS] = ACTIONS(435),
    [anon_sym_DASH] = ACTIONS(435),
    [anon_sym_BANG] = ACTIONS(437),
    [anon_sym_TILDE] = ACTIONS(437),
    [anon_sym_typeof] = ACTIONS(435),
    [anon_sym_void] = ACTIONS(435),
    [anon_sym_delete] = ACTIONS(435),
    [anon_sym_PLUS_PLUS] = ACTIONS(439),
    [anon_sym_DASH_DASH] = ACTIONS(439),
    [anon_sym_DQUOTE] = ACTIONS(361),
    [anon_sym_SQUOTE] = ACTIONS(363),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(365),
    [sym_number] = ACTIONS(367),
    [sym_this] = ACTIONS(369),
    [sym_super] = ACTIONS(369),
    [sym_true] = ACTIONS(369),
    [sym_false] = ACTIONS(369),
    [sym_null] = ACTIONS(369),
    [sym_undefined] = ACTIONS(441),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(417),
    [anon_sym_get] = ACTIONS(417),
    [anon_sym_set] = ACTIONS(417),
  },
  [186] = {
    [sym_import] = STATE(575),
    [sym_parenthesized_expression] = STATE(493),
    [sym_expression] = STATE(825),
    [sym_primary_expression] = STATE(576),
    [sym_yield_expression] = STATE(577),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1580),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1580),
    [sym_jsx_element] = STATE(577),
    [sym_jsx_fragment] = STATE(577),
    [sym_jsx_opening_element] = STATE(975),
    [sym_jsx_self_closing_element] = STATE(577),
    [sym_class] = STATE(575),
    [sym_function] = STATE(575),
    [sym_generator_function] = STATE(575),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(577),
    [sym_await_expression] = STATE(577),
    [sym_member_expression] = STATE(493),
    [sym_subscript_expression] = STATE(493),
    [sym_assignment_expression] = STATE(577),
    [sym__augmented_assignment_lhs] = STATE(933),
    [sym_augmented_assignment_expression] = STATE(577),
    [sym__destructuring_pattern] = STATE(1580),
    [sym_ternary_expression] = STATE(577),
    [sym_binary_expression] = STATE(577),
    [sym_unary_expression] = STATE(577),
    [sym_update_expression] = STATE(577),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1555),
    [aux_sym_export_statement_repeat1] = STATE(1182),
    [sym_identifier] = ACTIONS(415),
    [anon_sym_export] = ACTIONS(417),
    [anon_sym_LBRACE] = ACTIONS(421),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(423),
    [anon_sym_yield] = ACTIONS(425),
    [anon_sym_LBRACK] = ACTIONS(427),
    [anon_sym_LT] = ACTIONS(585),
    [anon_sym_SLASH] = ACTIONS(429),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(431),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(433),
    [anon_sym_PLUS] = ACTIONS(435),
    [anon_sym_DASH] = ACTIONS(435),
    [anon_sym_BANG] = ACTIONS(437),
    [anon_sym_TILDE] = ACTIONS(437),
    [anon_sym_typeof] = ACTIONS(435),
    [anon_sym_void] = ACTIONS(435),
    [anon_sym_delete] = ACTIONS(435),
    [anon_sym_PLUS_PLUS] = ACTIONS(439),
    [anon_sym_DASH_DASH] = ACTIONS(439),
    [anon_sym_DQUOTE] = ACTIONS(361),
    [anon_sym_SQUOTE] = ACTIONS(363),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(365),
    [sym_number] = ACTIONS(367),
    [sym_this] = ACTIONS(369),
    [sym_super] = ACTIONS(369),
    [sym_true] = ACTIONS(369),
    [sym_false] = ACTIONS(369),
    [sym_null] = ACTIONS(369),
    [sym_undefined] = ACTIONS(441),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(417),
    [anon_sym_get] = ACTIONS(417),
    [anon_sym_set] = ACTIONS(417),
  },
  [187] = {
    [sym_import] = STATE(575),
    [sym_parenthesized_expression] = STATE(493),
    [sym_expression] = STATE(499),
    [sym_primary_expression] = STATE(576),
    [sym_yield_expression] = STATE(577),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1580),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1580),
    [sym_jsx_element] = STATE(577),
    [sym_jsx_fragment] = STATE(577),
    [sym_jsx_opening_element] = STATE(975),
    [sym_jsx_self_closing_element] = STATE(577),
    [sym_class] = STATE(575),
    [sym_function] = STATE(575),
    [sym_generator_function] = STATE(575),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(577),
    [sym_await_expression] = STATE(577),
    [sym_member_expression] = STATE(493),
    [sym_subscript_expression] = STATE(493),
    [sym_assignment_expression] = STATE(577),
    [sym__augmented_assignment_lhs] = STATE(933),
    [sym_augmented_assignment_expression] = STATE(577),
    [sym__destructuring_pattern] = STATE(1580),
    [sym_ternary_expression] = STATE(577),
    [sym_binary_expression] = STATE(577),
    [sym_unary_expression] = STATE(577),
    [sym_update_expression] = STATE(577),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1555),
    [aux_sym_export_statement_repeat1] = STATE(1182),
    [sym_identifier] = ACTIONS(415),
    [anon_sym_export] = ACTIONS(417),
    [anon_sym_LBRACE] = ACTIONS(421),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(423),
    [anon_sym_yield] = ACTIONS(425),
    [anon_sym_LBRACK] = ACTIONS(427),
    [anon_sym_LT] = ACTIONS(585),
    [anon_sym_SLASH] = ACTIONS(429),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(431),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(433),
    [anon_sym_PLUS] = ACTIONS(435),
    [anon_sym_DASH] = ACTIONS(435),
    [anon_sym_BANG] = ACTIONS(437),
    [anon_sym_TILDE] = ACTIONS(437),
    [anon_sym_typeof] = ACTIONS(435),
    [anon_sym_void] = ACTIONS(435),
    [anon_sym_delete] = ACTIONS(435),
    [anon_sym_PLUS_PLUS] = ACTIONS(439),
    [anon_sym_DASH_DASH] = ACTIONS(439),
    [anon_sym_DQUOTE] = ACTIONS(361),
    [anon_sym_SQUOTE] = ACTIONS(363),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(365),
    [sym_number] = ACTIONS(367),
    [sym_this] = ACTIONS(369),
    [sym_super] = ACTIONS(369),
    [sym_true] = ACTIONS(369),
    [sym_false] = ACTIONS(369),
    [sym_null] = ACTIONS(369),
    [sym_undefined] = ACTIONS(441),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(417),
    [anon_sym_get] = ACTIONS(417),
    [anon_sym_set] = ACTIONS(417),
  },
  [188] = {
    [sym_import] = STATE(575),
    [sym_parenthesized_expression] = STATE(430),
    [sym_expression] = STATE(810),
    [sym_primary_expression] = STATE(576),
    [sym_yield_expression] = STATE(577),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1497),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1497),
    [sym_jsx_element] = STATE(577),
    [sym_jsx_fragment] = STATE(577),
    [sym_jsx_opening_element] = STATE(975),
    [sym_jsx_self_closing_element] = STATE(577),
    [sym_class] = STATE(575),
    [sym_function] = STATE(575),
    [sym_generator_function] = STATE(575),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(577),
    [sym_await_expression] = STATE(577),
    [sym_member_expression] = STATE(430),
    [sym_subscript_expression] = STATE(430),
    [sym_assignment_expression] = STATE(577),
    [sym__augmented_assignment_lhs] = STATE(937),
    [sym_augmented_assignment_expression] = STATE(577),
    [sym__destructuring_pattern] = STATE(1497),
    [sym_ternary_expression] = STATE(577),
    [sym_binary_expression] = STATE(577),
    [sym_unary_expression] = STATE(577),
    [sym_update_expression] = STATE(577),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1533),
    [aux_sym_export_statement_repeat1] = STATE(1182),
    [sym_identifier] = ACTIONS(443),
    [anon_sym_export] = ACTIONS(445),
    [anon_sym_LBRACE] = ACTIONS(421),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(449),
    [anon_sym_yield] = ACTIONS(451),
    [anon_sym_LBRACK] = ACTIONS(427),
    [anon_sym_LT] = ACTIONS(585),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(453),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(455),
    [anon_sym_PLUS] = ACTIONS(457),
    [anon_sym_DASH] = ACTIONS(457),
    [anon_sym_BANG] = ACTIONS(459),
    [anon_sym_TILDE] = ACTIONS(459),
    [anon_sym_typeof] = ACTIONS(457),
    [anon_sym_void] = ACTIONS(457),
    [anon_sym_delete] = ACTIONS(457),
    [anon_sym_PLUS_PLUS] = ACTIONS(461),
    [anon_sym_DASH_DASH] = ACTIONS(461),
    [anon_sym_DQUOTE] = ACTIONS(361),
    [anon_sym_SQUOTE] = ACTIONS(363),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(365),
    [sym_number] = ACTIONS(367),
    [sym_this] = ACTIONS(369),
    [sym_super] = ACTIONS(369),
    [sym_true] = ACTIONS(369),
    [sym_false] = ACTIONS(369),
    [sym_null] = ACTIONS(369),
    [sym_undefined] = ACTIONS(463),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(445),
    [anon_sym_get] = ACTIONS(445),
    [anon_sym_set] = ACTIONS(445),
  },
  [189] = {
    [sym_import] = STATE(721),
    [sym_parenthesized_expression] = STATE(479),
    [sym_expression] = STATE(599),
    [sym_primary_expression] = STATE(743),
    [sym_yield_expression] = STATE(740),
    [sym_object] = STATE(721),
    [sym_object_pattern] = STATE(1548),
    [sym_array] = STATE(721),
    [sym_array_pattern] = STATE(1548),
    [sym_jsx_element] = STATE(740),
    [sym_jsx_fragment] = STATE(740),
    [sym_jsx_opening_element] = STATE(972),
    [sym_jsx_self_closing_element] = STATE(740),
    [sym_class] = STATE(721),
    [sym_function] = STATE(721),
    [sym_generator_function] = STATE(721),
    [sym_arrow_function] = STATE(721),
    [sym_call_expression] = STATE(721),
    [sym_new_expression] = STATE(740),
    [sym_await_expression] = STATE(740),
    [sym_member_expression] = STATE(479),
    [sym_subscript_expression] = STATE(479),
    [sym_assignment_expression] = STATE(740),
    [sym__augmented_assignment_lhs] = STATE(942),
    [sym_augmented_assignment_expression] = STATE(740),
    [sym__destructuring_pattern] = STATE(1548),
    [sym_ternary_expression] = STATE(740),
    [sym_binary_expression] = STATE(740),
    [sym_unary_expression] = STATE(740),
    [sym_update_expression] = STATE(740),
    [sym_string] = STATE(721),
    [sym_template_string] = STATE(721),
    [sym_regex] = STATE(721),
    [sym_meta_property] = STATE(721),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1546),
    [aux_sym_export_statement_repeat1] = STATE(1154),
    [sym_identifier] = ACTIONS(407),
    [anon_sym_export] = ACTIONS(409),
    [anon_sym_LBRACE] = ACTIONS(379),
    [anon_sym_import] = ACTIONS(381),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(391),
    [anon_sym_async] = ACTIONS(413),
    [anon_sym_function] = ACTIONS(395),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(67),
    [anon_sym_void] = ACTIONS(67),
    [anon_sym_delete] = ACTIONS(67),
    [anon_sym_PLUS_PLUS] = ACTIONS(71),
    [anon_sym_DASH_DASH] = ACTIONS(71),
    [anon_sym_DQUOTE] = ACTIONS(73),
    [anon_sym_SQUOTE] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(77),
    [sym_number] = ACTIONS(79),
    [sym_this] = ACTIONS(81),
    [sym_super] = ACTIONS(81),
    [sym_true] = ACTIONS(81),
    [sym_false] = ACTIONS(81),
    [sym_null] = ACTIONS(81),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(409),
    [anon_sym_get] = ACTIONS(409),
    [anon_sym_set] = ACTIONS(409),
  },
  [190] = {
    [sym_import] = STATE(721),
    [sym_parenthesized_expression] = STATE(479),
    [sym_expression] = STATE(574),
    [sym_primary_expression] = STATE(743),
    [sym_yield_expression] = STATE(740),
    [sym_object] = STATE(721),
    [sym_object_pattern] = STATE(1548),
    [sym_array] = STATE(721),
    [sym_array_pattern] = STATE(1548),
    [sym_jsx_element] = STATE(740),
    [sym_jsx_fragment] = STATE(740),
    [sym_jsx_opening_element] = STATE(972),
    [sym_jsx_self_closing_element] = STATE(740),
    [sym_class] = STATE(721),
    [sym_function] = STATE(721),
    [sym_generator_function] = STATE(721),
    [sym_arrow_function] = STATE(721),
    [sym_call_expression] = STATE(721),
    [sym_new_expression] = STATE(740),
    [sym_await_expression] = STATE(740),
    [sym_member_expression] = STATE(479),
    [sym_subscript_expression] = STATE(479),
    [sym_assignment_expression] = STATE(740),
    [sym__augmented_assignment_lhs] = STATE(942),
    [sym_augmented_assignment_expression] = STATE(740),
    [sym__destructuring_pattern] = STATE(1548),
    [sym_ternary_expression] = STATE(740),
    [sym_binary_expression] = STATE(740),
    [sym_unary_expression] = STATE(740),
    [sym_update_expression] = STATE(740),
    [sym_string] = STATE(721),
    [sym_template_string] = STATE(721),
    [sym_regex] = STATE(721),
    [sym_meta_property] = STATE(721),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1546),
    [aux_sym_export_statement_repeat1] = STATE(1154),
    [sym_identifier] = ACTIONS(407),
    [anon_sym_export] = ACTIONS(409),
    [anon_sym_LBRACE] = ACTIONS(379),
    [anon_sym_import] = ACTIONS(381),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(391),
    [anon_sym_async] = ACTIONS(413),
    [anon_sym_function] = ACTIONS(395),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(67),
    [anon_sym_void] = ACTIONS(67),
    [anon_sym_delete] = ACTIONS(67),
    [anon_sym_PLUS_PLUS] = ACTIONS(71),
    [anon_sym_DASH_DASH] = ACTIONS(71),
    [anon_sym_DQUOTE] = ACTIONS(73),
    [anon_sym_SQUOTE] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(77),
    [sym_number] = ACTIONS(79),
    [sym_this] = ACTIONS(81),
    [sym_super] = ACTIONS(81),
    [sym_true] = ACTIONS(81),
    [sym_false] = ACTIONS(81),
    [sym_null] = ACTIONS(81),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(409),
    [anon_sym_get] = ACTIONS(409),
    [anon_sym_set] = ACTIONS(409),
  },
  [191] = {
    [sym_import] = STATE(721),
    [sym_parenthesized_expression] = STATE(479),
    [sym_expression] = STATE(572),
    [sym_primary_expression] = STATE(743),
    [sym_yield_expression] = STATE(740),
    [sym_object] = STATE(721),
    [sym_object_pattern] = STATE(1548),
    [sym_array] = STATE(721),
    [sym_array_pattern] = STATE(1548),
    [sym_jsx_element] = STATE(740),
    [sym_jsx_fragment] = STATE(740),
    [sym_jsx_opening_element] = STATE(972),
    [sym_jsx_self_closing_element] = STATE(740),
    [sym_class] = STATE(721),
    [sym_function] = STATE(721),
    [sym_generator_function] = STATE(721),
    [sym_arrow_function] = STATE(721),
    [sym_call_expression] = STATE(721),
    [sym_new_expression] = STATE(740),
    [sym_await_expression] = STATE(740),
    [sym_member_expression] = STATE(479),
    [sym_subscript_expression] = STATE(479),
    [sym_assignment_expression] = STATE(740),
    [sym__augmented_assignment_lhs] = STATE(942),
    [sym_augmented_assignment_expression] = STATE(740),
    [sym__destructuring_pattern] = STATE(1548),
    [sym_ternary_expression] = STATE(740),
    [sym_binary_expression] = STATE(740),
    [sym_unary_expression] = STATE(740),
    [sym_update_expression] = STATE(740),
    [sym_string] = STATE(721),
    [sym_template_string] = STATE(721),
    [sym_regex] = STATE(721),
    [sym_meta_property] = STATE(721),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1546),
    [aux_sym_export_statement_repeat1] = STATE(1154),
    [sym_identifier] = ACTIONS(407),
    [anon_sym_export] = ACTIONS(409),
    [anon_sym_LBRACE] = ACTIONS(379),
    [anon_sym_import] = ACTIONS(381),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(391),
    [anon_sym_async] = ACTIONS(413),
    [anon_sym_function] = ACTIONS(395),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(67),
    [anon_sym_void] = ACTIONS(67),
    [anon_sym_delete] = ACTIONS(67),
    [anon_sym_PLUS_PLUS] = ACTIONS(71),
    [anon_sym_DASH_DASH] = ACTIONS(71),
    [anon_sym_DQUOTE] = ACTIONS(73),
    [anon_sym_SQUOTE] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(77),
    [sym_number] = ACTIONS(79),
    [sym_this] = ACTIONS(81),
    [sym_super] = ACTIONS(81),
    [sym_true] = ACTIONS(81),
    [sym_false] = ACTIONS(81),
    [sym_null] = ACTIONS(81),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(409),
    [anon_sym_get] = ACTIONS(409),
    [anon_sym_set] = ACTIONS(409),
  },
  [192] = {
    [sym_import] = STATE(721),
    [sym_parenthesized_expression] = STATE(479),
    [sym_expression] = STATE(600),
    [sym_primary_expression] = STATE(743),
    [sym_yield_expression] = STATE(740),
    [sym_object] = STATE(721),
    [sym_object_pattern] = STATE(1548),
    [sym_array] = STATE(721),
    [sym_array_pattern] = STATE(1548),
    [sym_jsx_element] = STATE(740),
    [sym_jsx_fragment] = STATE(740),
    [sym_jsx_opening_element] = STATE(972),
    [sym_jsx_self_closing_element] = STATE(740),
    [sym_class] = STATE(721),
    [sym_function] = STATE(721),
    [sym_generator_function] = STATE(721),
    [sym_arrow_function] = STATE(721),
    [sym_call_expression] = STATE(721),
    [sym_new_expression] = STATE(740),
    [sym_await_expression] = STATE(740),
    [sym_member_expression] = STATE(479),
    [sym_subscript_expression] = STATE(479),
    [sym_assignment_expression] = STATE(740),
    [sym__augmented_assignment_lhs] = STATE(942),
    [sym_augmented_assignment_expression] = STATE(740),
    [sym__destructuring_pattern] = STATE(1548),
    [sym_ternary_expression] = STATE(740),
    [sym_binary_expression] = STATE(740),
    [sym_unary_expression] = STATE(740),
    [sym_update_expression] = STATE(740),
    [sym_string] = STATE(721),
    [sym_template_string] = STATE(721),
    [sym_regex] = STATE(721),
    [sym_meta_property] = STATE(721),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1546),
    [aux_sym_export_statement_repeat1] = STATE(1154),
    [sym_identifier] = ACTIONS(407),
    [anon_sym_export] = ACTIONS(409),
    [anon_sym_LBRACE] = ACTIONS(379),
    [anon_sym_import] = ACTIONS(381),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(391),
    [anon_sym_async] = ACTIONS(413),
    [anon_sym_function] = ACTIONS(395),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(67),
    [anon_sym_void] = ACTIONS(67),
    [anon_sym_delete] = ACTIONS(67),
    [anon_sym_PLUS_PLUS] = ACTIONS(71),
    [anon_sym_DASH_DASH] = ACTIONS(71),
    [anon_sym_DQUOTE] = ACTIONS(73),
    [anon_sym_SQUOTE] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(77),
    [sym_number] = ACTIONS(79),
    [sym_this] = ACTIONS(81),
    [sym_super] = ACTIONS(81),
    [sym_true] = ACTIONS(81),
    [sym_false] = ACTIONS(81),
    [sym_null] = ACTIONS(81),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(409),
    [anon_sym_get] = ACTIONS(409),
    [anon_sym_set] = ACTIONS(409),
  },
  [193] = {
    [sym_import] = STATE(575),
    [sym_parenthesized_expression] = STATE(493),
    [sym_expression] = STATE(498),
    [sym_primary_expression] = STATE(576),
    [sym_yield_expression] = STATE(577),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1580),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1580),
    [sym_jsx_element] = STATE(577),
    [sym_jsx_fragment] = STATE(577),
    [sym_jsx_opening_element] = STATE(975),
    [sym_jsx_self_closing_element] = STATE(577),
    [sym_class] = STATE(575),
    [sym_function] = STATE(575),
    [sym_generator_function] = STATE(575),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(577),
    [sym_await_expression] = STATE(577),
    [sym_member_expression] = STATE(493),
    [sym_subscript_expression] = STATE(493),
    [sym_assignment_expression] = STATE(577),
    [sym__augmented_assignment_lhs] = STATE(933),
    [sym_augmented_assignment_expression] = STATE(577),
    [sym__destructuring_pattern] = STATE(1580),
    [sym_ternary_expression] = STATE(577),
    [sym_binary_expression] = STATE(577),
    [sym_unary_expression] = STATE(577),
    [sym_update_expression] = STATE(577),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1555),
    [aux_sym_export_statement_repeat1] = STATE(1182),
    [sym_identifier] = ACTIONS(415),
    [anon_sym_export] = ACTIONS(417),
    [anon_sym_LBRACE] = ACTIONS(421),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(423),
    [anon_sym_yield] = ACTIONS(425),
    [anon_sym_LBRACK] = ACTIONS(427),
    [anon_sym_LT] = ACTIONS(585),
    [anon_sym_SLASH] = ACTIONS(429),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(431),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(433),
    [anon_sym_PLUS] = ACTIONS(435),
    [anon_sym_DASH] = ACTIONS(435),
    [anon_sym_BANG] = ACTIONS(437),
    [anon_sym_TILDE] = ACTIONS(437),
    [anon_sym_typeof] = ACTIONS(435),
    [anon_sym_void] = ACTIONS(435),
    [anon_sym_delete] = ACTIONS(435),
    [anon_sym_PLUS_PLUS] = ACTIONS(439),
    [anon_sym_DASH_DASH] = ACTIONS(439),
    [anon_sym_DQUOTE] = ACTIONS(361),
    [anon_sym_SQUOTE] = ACTIONS(363),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(365),
    [sym_number] = ACTIONS(367),
    [sym_this] = ACTIONS(369),
    [sym_super] = ACTIONS(369),
    [sym_true] = ACTIONS(369),
    [sym_false] = ACTIONS(369),
    [sym_null] = ACTIONS(369),
    [sym_undefined] = ACTIONS(441),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(417),
    [anon_sym_get] = ACTIONS(417),
    [anon_sym_set] = ACTIONS(417),
  },
  [194] = {
    [sym_import] = STATE(721),
    [sym_parenthesized_expression] = STATE(466),
    [sym_expression] = STATE(655),
    [sym_primary_expression] = STATE(743),
    [sym_yield_expression] = STATE(740),
    [sym_object] = STATE(721),
    [sym_object_pattern] = STATE(1486),
    [sym_array] = STATE(721),
    [sym_array_pattern] = STATE(1486),
    [sym_jsx_element] = STATE(740),
    [sym_jsx_fragment] = STATE(740),
    [sym_jsx_opening_element] = STATE(972),
    [sym_jsx_self_closing_element] = STATE(740),
    [sym_class] = STATE(721),
    [sym_function] = STATE(721),
    [sym_generator_function] = STATE(721),
    [sym_arrow_function] = STATE(721),
    [sym_call_expression] = STATE(721),
    [sym_new_expression] = STATE(740),
    [sym_await_expression] = STATE(740),
    [sym_member_expression] = STATE(466),
    [sym_subscript_expression] = STATE(466),
    [sym_assignment_expression] = STATE(740),
    [sym__augmented_assignment_lhs] = STATE(940),
    [sym_augmented_assignment_expression] = STATE(740),
    [sym__destructuring_pattern] = STATE(1486),
    [sym_ternary_expression] = STATE(740),
    [sym_binary_expression] = STATE(740),
    [sym_unary_expression] = STATE(740),
    [sym_update_expression] = STATE(740),
    [sym_string] = STATE(721),
    [sym_template_string] = STATE(721),
    [sym_regex] = STATE(721),
    [sym_meta_property] = STATE(721),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1487),
    [aux_sym_export_statement_repeat1] = STATE(1154),
    [sym_identifier] = ACTIONS(373),
    [anon_sym_export] = ACTIONS(375),
    [anon_sym_LBRACE] = ACTIONS(379),
    [anon_sym_import] = ACTIONS(381),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(383),
    [anon_sym_yield] = ACTIONS(385),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(389),
    [anon_sym_class] = ACTIONS(391),
    [anon_sym_async] = ACTIONS(393),
    [anon_sym_function] = ACTIONS(395),
    [anon_sym_new] = ACTIONS(397),
    [anon_sym_PLUS] = ACTIONS(399),
    [anon_sym_DASH] = ACTIONS(399),
    [anon_sym_BANG] = ACTIONS(401),
    [anon_sym_TILDE] = ACTIONS(401),
    [anon_sym_typeof] = ACTIONS(399),
    [anon_sym_void] = ACTIONS(399),
    [anon_sym_delete] = ACTIONS(399),
    [anon_sym_PLUS_PLUS] = ACTIONS(403),
    [anon_sym_DASH_DASH] = ACTIONS(403),
    [anon_sym_DQUOTE] = ACTIONS(73),
    [anon_sym_SQUOTE] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(77),
    [sym_number] = ACTIONS(79),
    [sym_this] = ACTIONS(81),
    [sym_super] = ACTIONS(81),
    [sym_true] = ACTIONS(81),
    [sym_false] = ACTIONS(81),
    [sym_null] = ACTIONS(81),
    [sym_undefined] = ACTIONS(405),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(375),
    [anon_sym_get] = ACTIONS(375),
    [anon_sym_set] = ACTIONS(375),
  },
  [195] = {
    [sym_import] = STATE(575),
    [sym_parenthesized_expression] = STATE(449),
    [sym_expression] = STATE(653),
    [sym_primary_expression] = STATE(576),
    [sym_yield_expression] = STATE(577),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1528),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1528),
    [sym_jsx_element] = STATE(577),
    [sym_jsx_fragment] = STATE(577),
    [sym_jsx_opening_element] = STATE(975),
    [sym_jsx_self_closing_element] = STATE(577),
    [sym_class] = STATE(575),
    [sym_function] = STATE(575),
    [sym_generator_function] = STATE(575),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(577),
    [sym_await_expression] = STATE(577),
    [sym_member_expression] = STATE(449),
    [sym_subscript_expression] = STATE(449),
    [sym_assignment_expression] = STATE(577),
    [sym__augmented_assignment_lhs] = STATE(943),
    [sym_augmented_assignment_expression] = STATE(577),
    [sym__destructuring_pattern] = STATE(1528),
    [sym_ternary_expression] = STATE(577),
    [sym_binary_expression] = STATE(577),
    [sym_unary_expression] = STATE(577),
    [sym_update_expression] = STATE(577),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1496),
    [aux_sym_export_statement_repeat1] = STATE(1182),
    [sym_identifier] = ACTIONS(321),
    [anon_sym_export] = ACTIONS(323),
    [anon_sym_LBRACE] = ACTIONS(327),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(335),
    [anon_sym_yield] = ACTIONS(339),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LT] = ACTIONS(585),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(349),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(353),
    [anon_sym_PLUS] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(355),
    [anon_sym_BANG] = ACTIONS(357),
    [anon_sym_TILDE] = ACTIONS(357),
    [anon_sym_typeof] = ACTIONS(355),
    [anon_sym_void] = ACTIONS(355),
    [anon_sym_delete] = ACTIONS(355),
    [anon_sym_PLUS_PLUS] = ACTIONS(359),
    [anon_sym_DASH_DASH] = ACTIONS(359),
    [anon_sym_DQUOTE] = ACTIONS(361),
    [anon_sym_SQUOTE] = ACTIONS(363),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(365),
    [sym_number] = ACTIONS(367),
    [sym_this] = ACTIONS(369),
    [sym_super] = ACTIONS(369),
    [sym_true] = ACTIONS(369),
    [sym_false] = ACTIONS(369),
    [sym_null] = ACTIONS(369),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(323),
    [anon_sym_get] = ACTIONS(323),
    [anon_sym_set] = ACTIONS(323),
  },
  [196] = {
    [sym_import] = STATE(721),
    [sym_parenthesized_expression] = STATE(479),
    [sym_expression] = STATE(604),
    [sym_primary_expression] = STATE(743),
    [sym_yield_expression] = STATE(740),
    [sym_object] = STATE(721),
    [sym_object_pattern] = STATE(1548),
    [sym_array] = STATE(721),
    [sym_array_pattern] = STATE(1548),
    [sym_jsx_element] = STATE(740),
    [sym_jsx_fragment] = STATE(740),
    [sym_jsx_opening_element] = STATE(972),
    [sym_jsx_self_closing_element] = STATE(740),
    [sym_class] = STATE(721),
    [sym_function] = STATE(721),
    [sym_generator_function] = STATE(721),
    [sym_arrow_function] = STATE(721),
    [sym_call_expression] = STATE(721),
    [sym_new_expression] = STATE(740),
    [sym_await_expression] = STATE(740),
    [sym_member_expression] = STATE(479),
    [sym_subscript_expression] = STATE(479),
    [sym_assignment_expression] = STATE(740),
    [sym__augmented_assignment_lhs] = STATE(942),
    [sym_augmented_assignment_expression] = STATE(740),
    [sym__destructuring_pattern] = STATE(1548),
    [sym_ternary_expression] = STATE(740),
    [sym_binary_expression] = STATE(740),
    [sym_unary_expression] = STATE(740),
    [sym_update_expression] = STATE(740),
    [sym_string] = STATE(721),
    [sym_template_string] = STATE(721),
    [sym_regex] = STATE(721),
    [sym_meta_property] = STATE(721),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1546),
    [aux_sym_export_statement_repeat1] = STATE(1154),
    [sym_identifier] = ACTIONS(407),
    [anon_sym_export] = ACTIONS(409),
    [anon_sym_LBRACE] = ACTIONS(379),
    [anon_sym_import] = ACTIONS(381),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(391),
    [anon_sym_async] = ACTIONS(413),
    [anon_sym_function] = ACTIONS(395),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(67),
    [anon_sym_void] = ACTIONS(67),
    [anon_sym_delete] = ACTIONS(67),
    [anon_sym_PLUS_PLUS] = ACTIONS(71),
    [anon_sym_DASH_DASH] = ACTIONS(71),
    [anon_sym_DQUOTE] = ACTIONS(73),
    [anon_sym_SQUOTE] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(77),
    [sym_number] = ACTIONS(79),
    [sym_this] = ACTIONS(81),
    [sym_super] = ACTIONS(81),
    [sym_true] = ACTIONS(81),
    [sym_false] = ACTIONS(81),
    [sym_null] = ACTIONS(81),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(409),
    [anon_sym_get] = ACTIONS(409),
    [anon_sym_set] = ACTIONS(409),
  },
  [197] = {
    [sym_import] = STATE(721),
    [sym_parenthesized_expression] = STATE(479),
    [sym_expression] = STATE(605),
    [sym_primary_expression] = STATE(743),
    [sym_yield_expression] = STATE(740),
    [sym_object] = STATE(721),
    [sym_object_pattern] = STATE(1548),
    [sym_array] = STATE(721),
    [sym_array_pattern] = STATE(1548),
    [sym_jsx_element] = STATE(740),
    [sym_jsx_fragment] = STATE(740),
    [sym_jsx_opening_element] = STATE(972),
    [sym_jsx_self_closing_element] = STATE(740),
    [sym_class] = STATE(721),
    [sym_function] = STATE(721),
    [sym_generator_function] = STATE(721),
    [sym_arrow_function] = STATE(721),
    [sym_call_expression] = STATE(721),
    [sym_new_expression] = STATE(740),
    [sym_await_expression] = STATE(740),
    [sym_member_expression] = STATE(479),
    [sym_subscript_expression] = STATE(479),
    [sym_assignment_expression] = STATE(740),
    [sym__augmented_assignment_lhs] = STATE(942),
    [sym_augmented_assignment_expression] = STATE(740),
    [sym__destructuring_pattern] = STATE(1548),
    [sym_ternary_expression] = STATE(740),
    [sym_binary_expression] = STATE(740),
    [sym_unary_expression] = STATE(740),
    [sym_update_expression] = STATE(740),
    [sym_string] = STATE(721),
    [sym_template_string] = STATE(721),
    [sym_regex] = STATE(721),
    [sym_meta_property] = STATE(721),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1546),
    [aux_sym_export_statement_repeat1] = STATE(1154),
    [sym_identifier] = ACTIONS(407),
    [anon_sym_export] = ACTIONS(409),
    [anon_sym_LBRACE] = ACTIONS(379),
    [anon_sym_import] = ACTIONS(381),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(391),
    [anon_sym_async] = ACTIONS(413),
    [anon_sym_function] = ACTIONS(395),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(67),
    [anon_sym_void] = ACTIONS(67),
    [anon_sym_delete] = ACTIONS(67),
    [anon_sym_PLUS_PLUS] = ACTIONS(71),
    [anon_sym_DASH_DASH] = ACTIONS(71),
    [anon_sym_DQUOTE] = ACTIONS(73),
    [anon_sym_SQUOTE] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(77),
    [sym_number] = ACTIONS(79),
    [sym_this] = ACTIONS(81),
    [sym_super] = ACTIONS(81),
    [sym_true] = ACTIONS(81),
    [sym_false] = ACTIONS(81),
    [sym_null] = ACTIONS(81),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(409),
    [anon_sym_get] = ACTIONS(409),
    [anon_sym_set] = ACTIONS(409),
  },
  [198] = {
    [sym_import] = STATE(721),
    [sym_parenthesized_expression] = STATE(479),
    [sym_expression] = STATE(607),
    [sym_primary_expression] = STATE(743),
    [sym_yield_expression] = STATE(740),
    [sym_object] = STATE(721),
    [sym_object_pattern] = STATE(1548),
    [sym_array] = STATE(721),
    [sym_array_pattern] = STATE(1548),
    [sym_jsx_element] = STATE(740),
    [sym_jsx_fragment] = STATE(740),
    [sym_jsx_opening_element] = STATE(972),
    [sym_jsx_self_closing_element] = STATE(740),
    [sym_class] = STATE(721),
    [sym_function] = STATE(721),
    [sym_generator_function] = STATE(721),
    [sym_arrow_function] = STATE(721),
    [sym_call_expression] = STATE(721),
    [sym_new_expression] = STATE(740),
    [sym_await_expression] = STATE(740),
    [sym_member_expression] = STATE(479),
    [sym_subscript_expression] = STATE(479),
    [sym_assignment_expression] = STATE(740),
    [sym__augmented_assignment_lhs] = STATE(942),
    [sym_augmented_assignment_expression] = STATE(740),
    [sym__destructuring_pattern] = STATE(1548),
    [sym_ternary_expression] = STATE(740),
    [sym_binary_expression] = STATE(740),
    [sym_unary_expression] = STATE(740),
    [sym_update_expression] = STATE(740),
    [sym_string] = STATE(721),
    [sym_template_string] = STATE(721),
    [sym_regex] = STATE(721),
    [sym_meta_property] = STATE(721),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1546),
    [aux_sym_export_statement_repeat1] = STATE(1154),
    [sym_identifier] = ACTIONS(407),
    [anon_sym_export] = ACTIONS(409),
    [anon_sym_LBRACE] = ACTIONS(379),
    [anon_sym_import] = ACTIONS(381),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(391),
    [anon_sym_async] = ACTIONS(413),
    [anon_sym_function] = ACTIONS(395),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(67),
    [anon_sym_void] = ACTIONS(67),
    [anon_sym_delete] = ACTIONS(67),
    [anon_sym_PLUS_PLUS] = ACTIONS(71),
    [anon_sym_DASH_DASH] = ACTIONS(71),
    [anon_sym_DQUOTE] = ACTIONS(73),
    [anon_sym_SQUOTE] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(77),
    [sym_number] = ACTIONS(79),
    [sym_this] = ACTIONS(81),
    [sym_super] = ACTIONS(81),
    [sym_true] = ACTIONS(81),
    [sym_false] = ACTIONS(81),
    [sym_null] = ACTIONS(81),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(409),
    [anon_sym_get] = ACTIONS(409),
    [anon_sym_set] = ACTIONS(409),
  },
  [199] = {
    [sym_import] = STATE(721),
    [sym_parenthesized_expression] = STATE(479),
    [sym_expression] = STATE(610),
    [sym_primary_expression] = STATE(743),
    [sym_yield_expression] = STATE(740),
    [sym_object] = STATE(721),
    [sym_object_pattern] = STATE(1548),
    [sym_array] = STATE(721),
    [sym_array_pattern] = STATE(1548),
    [sym_jsx_element] = STATE(740),
    [sym_jsx_fragment] = STATE(740),
    [sym_jsx_opening_element] = STATE(972),
    [sym_jsx_self_closing_element] = STATE(740),
    [sym_class] = STATE(721),
    [sym_function] = STATE(721),
    [sym_generator_function] = STATE(721),
    [sym_arrow_function] = STATE(721),
    [sym_call_expression] = STATE(721),
    [sym_new_expression] = STATE(740),
    [sym_await_expression] = STATE(740),
    [sym_member_expression] = STATE(479),
    [sym_subscript_expression] = STATE(479),
    [sym_assignment_expression] = STATE(740),
    [sym__augmented_assignment_lhs] = STATE(942),
    [sym_augmented_assignment_expression] = STATE(740),
    [sym__destructuring_pattern] = STATE(1548),
    [sym_ternary_expression] = STATE(740),
    [sym_binary_expression] = STATE(740),
    [sym_unary_expression] = STATE(740),
    [sym_update_expression] = STATE(740),
    [sym_string] = STATE(721),
    [sym_template_string] = STATE(721),
    [sym_regex] = STATE(721),
    [sym_meta_property] = STATE(721),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1546),
    [aux_sym_export_statement_repeat1] = STATE(1154),
    [sym_identifier] = ACTIONS(407),
    [anon_sym_export] = ACTIONS(409),
    [anon_sym_LBRACE] = ACTIONS(379),
    [anon_sym_import] = ACTIONS(381),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(391),
    [anon_sym_async] = ACTIONS(413),
    [anon_sym_function] = ACTIONS(395),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(67),
    [anon_sym_void] = ACTIONS(67),
    [anon_sym_delete] = ACTIONS(67),
    [anon_sym_PLUS_PLUS] = ACTIONS(71),
    [anon_sym_DASH_DASH] = ACTIONS(71),
    [anon_sym_DQUOTE] = ACTIONS(73),
    [anon_sym_SQUOTE] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(77),
    [sym_number] = ACTIONS(79),
    [sym_this] = ACTIONS(81),
    [sym_super] = ACTIONS(81),
    [sym_true] = ACTIONS(81),
    [sym_false] = ACTIONS(81),
    [sym_null] = ACTIONS(81),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(409),
    [anon_sym_get] = ACTIONS(409),
    [anon_sym_set] = ACTIONS(409),
  },
  [200] = {
    [sym_import] = STATE(721),
    [sym_parenthesized_expression] = STATE(479),
    [sym_expression] = STATE(611),
    [sym_primary_expression] = STATE(743),
    [sym_yield_expression] = STATE(740),
    [sym_object] = STATE(721),
    [sym_object_pattern] = STATE(1548),
    [sym_array] = STATE(721),
    [sym_array_pattern] = STATE(1548),
    [sym_jsx_element] = STATE(740),
    [sym_jsx_fragment] = STATE(740),
    [sym_jsx_opening_element] = STATE(972),
    [sym_jsx_self_closing_element] = STATE(740),
    [sym_class] = STATE(721),
    [sym_function] = STATE(721),
    [sym_generator_function] = STATE(721),
    [sym_arrow_function] = STATE(721),
    [sym_call_expression] = STATE(721),
    [sym_new_expression] = STATE(740),
    [sym_await_expression] = STATE(740),
    [sym_member_expression] = STATE(479),
    [sym_subscript_expression] = STATE(479),
    [sym_assignment_expression] = STATE(740),
    [sym__augmented_assignment_lhs] = STATE(942),
    [sym_augmented_assignment_expression] = STATE(740),
    [sym__destructuring_pattern] = STATE(1548),
    [sym_ternary_expression] = STATE(740),
    [sym_binary_expression] = STATE(740),
    [sym_unary_expression] = STATE(740),
    [sym_update_expression] = STATE(740),
    [sym_string] = STATE(721),
    [sym_template_string] = STATE(721),
    [sym_regex] = STATE(721),
    [sym_meta_property] = STATE(721),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1546),
    [aux_sym_export_statement_repeat1] = STATE(1154),
    [sym_identifier] = ACTIONS(407),
    [anon_sym_export] = ACTIONS(409),
    [anon_sym_LBRACE] = ACTIONS(379),
    [anon_sym_import] = ACTIONS(381),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(391),
    [anon_sym_async] = ACTIONS(413),
    [anon_sym_function] = ACTIONS(395),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(67),
    [anon_sym_void] = ACTIONS(67),
    [anon_sym_delete] = ACTIONS(67),
    [anon_sym_PLUS_PLUS] = ACTIONS(71),
    [anon_sym_DASH_DASH] = ACTIONS(71),
    [anon_sym_DQUOTE] = ACTIONS(73),
    [anon_sym_SQUOTE] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(77),
    [sym_number] = ACTIONS(79),
    [sym_this] = ACTIONS(81),
    [sym_super] = ACTIONS(81),
    [sym_true] = ACTIONS(81),
    [sym_false] = ACTIONS(81),
    [sym_null] = ACTIONS(81),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(409),
    [anon_sym_get] = ACTIONS(409),
    [anon_sym_set] = ACTIONS(409),
  },
  [201] = {
    [sym_import] = STATE(721),
    [sym_parenthesized_expression] = STATE(479),
    [sym_expression] = STATE(612),
    [sym_primary_expression] = STATE(743),
    [sym_yield_expression] = STATE(740),
    [sym_object] = STATE(721),
    [sym_object_pattern] = STATE(1548),
    [sym_array] = STATE(721),
    [sym_array_pattern] = STATE(1548),
    [sym_jsx_element] = STATE(740),
    [sym_jsx_fragment] = STATE(740),
    [sym_jsx_opening_element] = STATE(972),
    [sym_jsx_self_closing_element] = STATE(740),
    [sym_class] = STATE(721),
    [sym_function] = STATE(721),
    [sym_generator_function] = STATE(721),
    [sym_arrow_function] = STATE(721),
    [sym_call_expression] = STATE(721),
    [sym_new_expression] = STATE(740),
    [sym_await_expression] = STATE(740),
    [sym_member_expression] = STATE(479),
    [sym_subscript_expression] = STATE(479),
    [sym_assignment_expression] = STATE(740),
    [sym__augmented_assignment_lhs] = STATE(942),
    [sym_augmented_assignment_expression] = STATE(740),
    [sym__destructuring_pattern] = STATE(1548),
    [sym_ternary_expression] = STATE(740),
    [sym_binary_expression] = STATE(740),
    [sym_unary_expression] = STATE(740),
    [sym_update_expression] = STATE(740),
    [sym_string] = STATE(721),
    [sym_template_string] = STATE(721),
    [sym_regex] = STATE(721),
    [sym_meta_property] = STATE(721),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1546),
    [aux_sym_export_statement_repeat1] = STATE(1154),
    [sym_identifier] = ACTIONS(407),
    [anon_sym_export] = ACTIONS(409),
    [anon_sym_LBRACE] = ACTIONS(379),
    [anon_sym_import] = ACTIONS(381),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(391),
    [anon_sym_async] = ACTIONS(413),
    [anon_sym_function] = ACTIONS(395),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(67),
    [anon_sym_void] = ACTIONS(67),
    [anon_sym_delete] = ACTIONS(67),
    [anon_sym_PLUS_PLUS] = ACTIONS(71),
    [anon_sym_DASH_DASH] = ACTIONS(71),
    [anon_sym_DQUOTE] = ACTIONS(73),
    [anon_sym_SQUOTE] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(77),
    [sym_number] = ACTIONS(79),
    [sym_this] = ACTIONS(81),
    [sym_super] = ACTIONS(81),
    [sym_true] = ACTIONS(81),
    [sym_false] = ACTIONS(81),
    [sym_null] = ACTIONS(81),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(409),
    [anon_sym_get] = ACTIONS(409),
    [anon_sym_set] = ACTIONS(409),
  },
  [202] = {
    [sym_import] = STATE(721),
    [sym_parenthesized_expression] = STATE(479),
    [sym_expression] = STATE(614),
    [sym_primary_expression] = STATE(743),
    [sym_yield_expression] = STATE(740),
    [sym_object] = STATE(721),
    [sym_object_pattern] = STATE(1548),
    [sym_array] = STATE(721),
    [sym_array_pattern] = STATE(1548),
    [sym_jsx_element] = STATE(740),
    [sym_jsx_fragment] = STATE(740),
    [sym_jsx_opening_element] = STATE(972),
    [sym_jsx_self_closing_element] = STATE(740),
    [sym_class] = STATE(721),
    [sym_function] = STATE(721),
    [sym_generator_function] = STATE(721),
    [sym_arrow_function] = STATE(721),
    [sym_call_expression] = STATE(721),
    [sym_new_expression] = STATE(740),
    [sym_await_expression] = STATE(740),
    [sym_member_expression] = STATE(479),
    [sym_subscript_expression] = STATE(479),
    [sym_assignment_expression] = STATE(740),
    [sym__augmented_assignment_lhs] = STATE(942),
    [sym_augmented_assignment_expression] = STATE(740),
    [sym__destructuring_pattern] = STATE(1548),
    [sym_ternary_expression] = STATE(740),
    [sym_binary_expression] = STATE(740),
    [sym_unary_expression] = STATE(740),
    [sym_update_expression] = STATE(740),
    [sym_string] = STATE(721),
    [sym_template_string] = STATE(721),
    [sym_regex] = STATE(721),
    [sym_meta_property] = STATE(721),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1546),
    [aux_sym_export_statement_repeat1] = STATE(1154),
    [sym_identifier] = ACTIONS(407),
    [anon_sym_export] = ACTIONS(409),
    [anon_sym_LBRACE] = ACTIONS(379),
    [anon_sym_import] = ACTIONS(381),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(391),
    [anon_sym_async] = ACTIONS(413),
    [anon_sym_function] = ACTIONS(395),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(67),
    [anon_sym_void] = ACTIONS(67),
    [anon_sym_delete] = ACTIONS(67),
    [anon_sym_PLUS_PLUS] = ACTIONS(71),
    [anon_sym_DASH_DASH] = ACTIONS(71),
    [anon_sym_DQUOTE] = ACTIONS(73),
    [anon_sym_SQUOTE] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(77),
    [sym_number] = ACTIONS(79),
    [sym_this] = ACTIONS(81),
    [sym_super] = ACTIONS(81),
    [sym_true] = ACTIONS(81),
    [sym_false] = ACTIONS(81),
    [sym_null] = ACTIONS(81),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(409),
    [anon_sym_get] = ACTIONS(409),
    [anon_sym_set] = ACTIONS(409),
  },
  [203] = {
    [sym_import] = STATE(721),
    [sym_parenthesized_expression] = STATE(479),
    [sym_expression] = STATE(570),
    [sym_primary_expression] = STATE(743),
    [sym_yield_expression] = STATE(740),
    [sym_object] = STATE(721),
    [sym_object_pattern] = STATE(1548),
    [sym_array] = STATE(721),
    [sym_array_pattern] = STATE(1548),
    [sym_jsx_element] = STATE(740),
    [sym_jsx_fragment] = STATE(740),
    [sym_jsx_opening_element] = STATE(972),
    [sym_jsx_self_closing_element] = STATE(740),
    [sym_class] = STATE(721),
    [sym_function] = STATE(721),
    [sym_generator_function] = STATE(721),
    [sym_arrow_function] = STATE(721),
    [sym_call_expression] = STATE(721),
    [sym_new_expression] = STATE(740),
    [sym_await_expression] = STATE(740),
    [sym_member_expression] = STATE(479),
    [sym_subscript_expression] = STATE(479),
    [sym_assignment_expression] = STATE(740),
    [sym__augmented_assignment_lhs] = STATE(942),
    [sym_augmented_assignment_expression] = STATE(740),
    [sym__destructuring_pattern] = STATE(1548),
    [sym_ternary_expression] = STATE(740),
    [sym_binary_expression] = STATE(740),
    [sym_unary_expression] = STATE(740),
    [sym_update_expression] = STATE(740),
    [sym_string] = STATE(721),
    [sym_template_string] = STATE(721),
    [sym_regex] = STATE(721),
    [sym_meta_property] = STATE(721),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1546),
    [aux_sym_export_statement_repeat1] = STATE(1154),
    [sym_identifier] = ACTIONS(407),
    [anon_sym_export] = ACTIONS(409),
    [anon_sym_LBRACE] = ACTIONS(379),
    [anon_sym_import] = ACTIONS(381),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(391),
    [anon_sym_async] = ACTIONS(413),
    [anon_sym_function] = ACTIONS(395),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(67),
    [anon_sym_void] = ACTIONS(67),
    [anon_sym_delete] = ACTIONS(67),
    [anon_sym_PLUS_PLUS] = ACTIONS(71),
    [anon_sym_DASH_DASH] = ACTIONS(71),
    [anon_sym_DQUOTE] = ACTIONS(73),
    [anon_sym_SQUOTE] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(77),
    [sym_number] = ACTIONS(79),
    [sym_this] = ACTIONS(81),
    [sym_super] = ACTIONS(81),
    [sym_true] = ACTIONS(81),
    [sym_false] = ACTIONS(81),
    [sym_null] = ACTIONS(81),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(409),
    [anon_sym_get] = ACTIONS(409),
    [anon_sym_set] = ACTIONS(409),
  },
  [204] = {
    [sym_import] = STATE(721),
    [sym_parenthesized_expression] = STATE(479),
    [sym_expression] = STATE(615),
    [sym_primary_expression] = STATE(743),
    [sym_yield_expression] = STATE(740),
    [sym_object] = STATE(721),
    [sym_object_pattern] = STATE(1548),
    [sym_array] = STATE(721),
    [sym_array_pattern] = STATE(1548),
    [sym_jsx_element] = STATE(740),
    [sym_jsx_fragment] = STATE(740),
    [sym_jsx_opening_element] = STATE(972),
    [sym_jsx_self_closing_element] = STATE(740),
    [sym_class] = STATE(721),
    [sym_function] = STATE(721),
    [sym_generator_function] = STATE(721),
    [sym_arrow_function] = STATE(721),
    [sym_call_expression] = STATE(721),
    [sym_new_expression] = STATE(740),
    [sym_await_expression] = STATE(740),
    [sym_member_expression] = STATE(479),
    [sym_subscript_expression] = STATE(479),
    [sym_assignment_expression] = STATE(740),
    [sym__augmented_assignment_lhs] = STATE(942),
    [sym_augmented_assignment_expression] = STATE(740),
    [sym__destructuring_pattern] = STATE(1548),
    [sym_ternary_expression] = STATE(740),
    [sym_binary_expression] = STATE(740),
    [sym_unary_expression] = STATE(740),
    [sym_update_expression] = STATE(740),
    [sym_string] = STATE(721),
    [sym_template_string] = STATE(721),
    [sym_regex] = STATE(721),
    [sym_meta_property] = STATE(721),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1546),
    [aux_sym_export_statement_repeat1] = STATE(1154),
    [sym_identifier] = ACTIONS(407),
    [anon_sym_export] = ACTIONS(409),
    [anon_sym_LBRACE] = ACTIONS(379),
    [anon_sym_import] = ACTIONS(381),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(391),
    [anon_sym_async] = ACTIONS(413),
    [anon_sym_function] = ACTIONS(395),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(67),
    [anon_sym_void] = ACTIONS(67),
    [anon_sym_delete] = ACTIONS(67),
    [anon_sym_PLUS_PLUS] = ACTIONS(71),
    [anon_sym_DASH_DASH] = ACTIONS(71),
    [anon_sym_DQUOTE] = ACTIONS(73),
    [anon_sym_SQUOTE] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(77),
    [sym_number] = ACTIONS(79),
    [sym_this] = ACTIONS(81),
    [sym_super] = ACTIONS(81),
    [sym_true] = ACTIONS(81),
    [sym_false] = ACTIONS(81),
    [sym_null] = ACTIONS(81),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(409),
    [anon_sym_get] = ACTIONS(409),
    [anon_sym_set] = ACTIONS(409),
  },
  [205] = {
    [sym_import] = STATE(721),
    [sym_parenthesized_expression] = STATE(479),
    [sym_expression] = STATE(616),
    [sym_primary_expression] = STATE(743),
    [sym_yield_expression] = STATE(740),
    [sym_object] = STATE(721),
    [sym_object_pattern] = STATE(1548),
    [sym_array] = STATE(721),
    [sym_array_pattern] = STATE(1548),
    [sym_jsx_element] = STATE(740),
    [sym_jsx_fragment] = STATE(740),
    [sym_jsx_opening_element] = STATE(972),
    [sym_jsx_self_closing_element] = STATE(740),
    [sym_class] = STATE(721),
    [sym_function] = STATE(721),
    [sym_generator_function] = STATE(721),
    [sym_arrow_function] = STATE(721),
    [sym_call_expression] = STATE(721),
    [sym_new_expression] = STATE(740),
    [sym_await_expression] = STATE(740),
    [sym_member_expression] = STATE(479),
    [sym_subscript_expression] = STATE(479),
    [sym_assignment_expression] = STATE(740),
    [sym__augmented_assignment_lhs] = STATE(942),
    [sym_augmented_assignment_expression] = STATE(740),
    [sym__destructuring_pattern] = STATE(1548),
    [sym_ternary_expression] = STATE(740),
    [sym_binary_expression] = STATE(740),
    [sym_unary_expression] = STATE(740),
    [sym_update_expression] = STATE(740),
    [sym_string] = STATE(721),
    [sym_template_string] = STATE(721),
    [sym_regex] = STATE(721),
    [sym_meta_property] = STATE(721),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1546),
    [aux_sym_export_statement_repeat1] = STATE(1154),
    [sym_identifier] = ACTIONS(407),
    [anon_sym_export] = ACTIONS(409),
    [anon_sym_LBRACE] = ACTIONS(379),
    [anon_sym_import] = ACTIONS(381),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(391),
    [anon_sym_async] = ACTIONS(413),
    [anon_sym_function] = ACTIONS(395),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(67),
    [anon_sym_void] = ACTIONS(67),
    [anon_sym_delete] = ACTIONS(67),
    [anon_sym_PLUS_PLUS] = ACTIONS(71),
    [anon_sym_DASH_DASH] = ACTIONS(71),
    [anon_sym_DQUOTE] = ACTIONS(73),
    [anon_sym_SQUOTE] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(77),
    [sym_number] = ACTIONS(79),
    [sym_this] = ACTIONS(81),
    [sym_super] = ACTIONS(81),
    [sym_true] = ACTIONS(81),
    [sym_false] = ACTIONS(81),
    [sym_null] = ACTIONS(81),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(409),
    [anon_sym_get] = ACTIONS(409),
    [anon_sym_set] = ACTIONS(409),
  },
  [206] = {
    [sym_import] = STATE(575),
    [sym_parenthesized_expression] = STATE(430),
    [sym_expression] = STATE(781),
    [sym_primary_expression] = STATE(576),
    [sym_yield_expression] = STATE(577),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1497),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1497),
    [sym_jsx_element] = STATE(577),
    [sym_jsx_fragment] = STATE(577),
    [sym_jsx_opening_element] = STATE(975),
    [sym_jsx_self_closing_element] = STATE(577),
    [sym_class] = STATE(575),
    [sym_function] = STATE(575),
    [sym_generator_function] = STATE(575),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(577),
    [sym_await_expression] = STATE(577),
    [sym_member_expression] = STATE(430),
    [sym_subscript_expression] = STATE(430),
    [sym_assignment_expression] = STATE(577),
    [sym__augmented_assignment_lhs] = STATE(937),
    [sym_augmented_assignment_expression] = STATE(577),
    [sym__destructuring_pattern] = STATE(1497),
    [sym_ternary_expression] = STATE(577),
    [sym_binary_expression] = STATE(577),
    [sym_unary_expression] = STATE(577),
    [sym_update_expression] = STATE(577),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1533),
    [aux_sym_export_statement_repeat1] = STATE(1182),
    [sym_identifier] = ACTIONS(443),
    [anon_sym_export] = ACTIONS(445),
    [anon_sym_LBRACE] = ACTIONS(421),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(449),
    [anon_sym_yield] = ACTIONS(451),
    [anon_sym_LBRACK] = ACTIONS(427),
    [anon_sym_LT] = ACTIONS(585),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(453),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(455),
    [anon_sym_PLUS] = ACTIONS(457),
    [anon_sym_DASH] = ACTIONS(457),
    [anon_sym_BANG] = ACTIONS(459),
    [anon_sym_TILDE] = ACTIONS(459),
    [anon_sym_typeof] = ACTIONS(457),
    [anon_sym_void] = ACTIONS(457),
    [anon_sym_delete] = ACTIONS(457),
    [anon_sym_PLUS_PLUS] = ACTIONS(461),
    [anon_sym_DASH_DASH] = ACTIONS(461),
    [anon_sym_DQUOTE] = ACTIONS(361),
    [anon_sym_SQUOTE] = ACTIONS(363),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(365),
    [sym_number] = ACTIONS(367),
    [sym_this] = ACTIONS(369),
    [sym_super] = ACTIONS(369),
    [sym_true] = ACTIONS(369),
    [sym_false] = ACTIONS(369),
    [sym_null] = ACTIONS(369),
    [sym_undefined] = ACTIONS(463),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(445),
    [anon_sym_get] = ACTIONS(445),
    [anon_sym_set] = ACTIONS(445),
  },
  [207] = {
    [sym_import] = STATE(575),
    [sym_parenthesized_expression] = STATE(430),
    [sym_expression] = STATE(761),
    [sym_primary_expression] = STATE(576),
    [sym_yield_expression] = STATE(577),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1497),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1497),
    [sym_jsx_element] = STATE(577),
    [sym_jsx_fragment] = STATE(577),
    [sym_jsx_opening_element] = STATE(975),
    [sym_jsx_self_closing_element] = STATE(577),
    [sym_class] = STATE(575),
    [sym_function] = STATE(575),
    [sym_generator_function] = STATE(575),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(577),
    [sym_await_expression] = STATE(577),
    [sym_member_expression] = STATE(430),
    [sym_subscript_expression] = STATE(430),
    [sym_assignment_expression] = STATE(577),
    [sym__augmented_assignment_lhs] = STATE(937),
    [sym_augmented_assignment_expression] = STATE(577),
    [sym__destructuring_pattern] = STATE(1497),
    [sym_ternary_expression] = STATE(577),
    [sym_binary_expression] = STATE(577),
    [sym_unary_expression] = STATE(577),
    [sym_update_expression] = STATE(577),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1533),
    [aux_sym_export_statement_repeat1] = STATE(1182),
    [sym_identifier] = ACTIONS(443),
    [anon_sym_export] = ACTIONS(445),
    [anon_sym_LBRACE] = ACTIONS(421),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(449),
    [anon_sym_yield] = ACTIONS(451),
    [anon_sym_LBRACK] = ACTIONS(427),
    [anon_sym_LT] = ACTIONS(585),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(453),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(455),
    [anon_sym_PLUS] = ACTIONS(457),
    [anon_sym_DASH] = ACTIONS(457),
    [anon_sym_BANG] = ACTIONS(459),
    [anon_sym_TILDE] = ACTIONS(459),
    [anon_sym_typeof] = ACTIONS(457),
    [anon_sym_void] = ACTIONS(457),
    [anon_sym_delete] = ACTIONS(457),
    [anon_sym_PLUS_PLUS] = ACTIONS(461),
    [anon_sym_DASH_DASH] = ACTIONS(461),
    [anon_sym_DQUOTE] = ACTIONS(361),
    [anon_sym_SQUOTE] = ACTIONS(363),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(365),
    [sym_number] = ACTIONS(367),
    [sym_this] = ACTIONS(369),
    [sym_super] = ACTIONS(369),
    [sym_true] = ACTIONS(369),
    [sym_false] = ACTIONS(369),
    [sym_null] = ACTIONS(369),
    [sym_undefined] = ACTIONS(463),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(445),
    [anon_sym_get] = ACTIONS(445),
    [anon_sym_set] = ACTIONS(445),
  },
  [208] = {
    [sym_import] = STATE(575),
    [sym_parenthesized_expression] = STATE(493),
    [sym_expression] = STATE(824),
    [sym_primary_expression] = STATE(576),
    [sym_yield_expression] = STATE(577),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1580),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1580),
    [sym_jsx_element] = STATE(577),
    [sym_jsx_fragment] = STATE(577),
    [sym_jsx_opening_element] = STATE(975),
    [sym_jsx_self_closing_element] = STATE(577),
    [sym_class] = STATE(575),
    [sym_function] = STATE(575),
    [sym_generator_function] = STATE(575),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(577),
    [sym_await_expression] = STATE(577),
    [sym_member_expression] = STATE(493),
    [sym_subscript_expression] = STATE(493),
    [sym_assignment_expression] = STATE(577),
    [sym__augmented_assignment_lhs] = STATE(933),
    [sym_augmented_assignment_expression] = STATE(577),
    [sym__destructuring_pattern] = STATE(1580),
    [sym_ternary_expression] = STATE(577),
    [sym_binary_expression] = STATE(577),
    [sym_unary_expression] = STATE(577),
    [sym_update_expression] = STATE(577),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1555),
    [aux_sym_export_statement_repeat1] = STATE(1182),
    [sym_identifier] = ACTIONS(415),
    [anon_sym_export] = ACTIONS(417),
    [anon_sym_LBRACE] = ACTIONS(421),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(423),
    [anon_sym_yield] = ACTIONS(425),
    [anon_sym_LBRACK] = ACTIONS(427),
    [anon_sym_LT] = ACTIONS(585),
    [anon_sym_SLASH] = ACTIONS(429),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(431),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(433),
    [anon_sym_PLUS] = ACTIONS(435),
    [anon_sym_DASH] = ACTIONS(435),
    [anon_sym_BANG] = ACTIONS(437),
    [anon_sym_TILDE] = ACTIONS(437),
    [anon_sym_typeof] = ACTIONS(435),
    [anon_sym_void] = ACTIONS(435),
    [anon_sym_delete] = ACTIONS(435),
    [anon_sym_PLUS_PLUS] = ACTIONS(439),
    [anon_sym_DASH_DASH] = ACTIONS(439),
    [anon_sym_DQUOTE] = ACTIONS(361),
    [anon_sym_SQUOTE] = ACTIONS(363),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(365),
    [sym_number] = ACTIONS(367),
    [sym_this] = ACTIONS(369),
    [sym_super] = ACTIONS(369),
    [sym_true] = ACTIONS(369),
    [sym_false] = ACTIONS(369),
    [sym_null] = ACTIONS(369),
    [sym_undefined] = ACTIONS(441),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(417),
    [anon_sym_get] = ACTIONS(417),
    [anon_sym_set] = ACTIONS(417),
  },
  [209] = {
    [sym_import] = STATE(575),
    [sym_parenthesized_expression] = STATE(430),
    [sym_expression] = STATE(789),
    [sym_primary_expression] = STATE(576),
    [sym_yield_expression] = STATE(577),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1497),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1497),
    [sym_jsx_element] = STATE(577),
    [sym_jsx_fragment] = STATE(577),
    [sym_jsx_opening_element] = STATE(975),
    [sym_jsx_self_closing_element] = STATE(577),
    [sym_class] = STATE(575),
    [sym_function] = STATE(575),
    [sym_generator_function] = STATE(575),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(577),
    [sym_await_expression] = STATE(577),
    [sym_member_expression] = STATE(430),
    [sym_subscript_expression] = STATE(430),
    [sym_assignment_expression] = STATE(577),
    [sym__augmented_assignment_lhs] = STATE(937),
    [sym_augmented_assignment_expression] = STATE(577),
    [sym__destructuring_pattern] = STATE(1497),
    [sym_ternary_expression] = STATE(577),
    [sym_binary_expression] = STATE(577),
    [sym_unary_expression] = STATE(577),
    [sym_update_expression] = STATE(577),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1533),
    [aux_sym_export_statement_repeat1] = STATE(1182),
    [sym_identifier] = ACTIONS(443),
    [anon_sym_export] = ACTIONS(445),
    [anon_sym_LBRACE] = ACTIONS(421),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(449),
    [anon_sym_yield] = ACTIONS(451),
    [anon_sym_LBRACK] = ACTIONS(427),
    [anon_sym_LT] = ACTIONS(585),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(453),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(455),
    [anon_sym_PLUS] = ACTIONS(457),
    [anon_sym_DASH] = ACTIONS(457),
    [anon_sym_BANG] = ACTIONS(459),
    [anon_sym_TILDE] = ACTIONS(459),
    [anon_sym_typeof] = ACTIONS(457),
    [anon_sym_void] = ACTIONS(457),
    [anon_sym_delete] = ACTIONS(457),
    [anon_sym_PLUS_PLUS] = ACTIONS(461),
    [anon_sym_DASH_DASH] = ACTIONS(461),
    [anon_sym_DQUOTE] = ACTIONS(361),
    [anon_sym_SQUOTE] = ACTIONS(363),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(365),
    [sym_number] = ACTIONS(367),
    [sym_this] = ACTIONS(369),
    [sym_super] = ACTIONS(369),
    [sym_true] = ACTIONS(369),
    [sym_false] = ACTIONS(369),
    [sym_null] = ACTIONS(369),
    [sym_undefined] = ACTIONS(463),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(445),
    [anon_sym_get] = ACTIONS(445),
    [anon_sym_set] = ACTIONS(445),
  },
  [210] = {
    [sym_import] = STATE(575),
    [sym_parenthesized_expression] = STATE(430),
    [sym_expression] = STATE(499),
    [sym_primary_expression] = STATE(576),
    [sym_yield_expression] = STATE(577),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1497),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1497),
    [sym_jsx_element] = STATE(577),
    [sym_jsx_fragment] = STATE(577),
    [sym_jsx_opening_element] = STATE(975),
    [sym_jsx_self_closing_element] = STATE(577),
    [sym_class] = STATE(575),
    [sym_function] = STATE(575),
    [sym_generator_function] = STATE(575),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(577),
    [sym_await_expression] = STATE(577),
    [sym_member_expression] = STATE(430),
    [sym_subscript_expression] = STATE(430),
    [sym_assignment_expression] = STATE(577),
    [sym__augmented_assignment_lhs] = STATE(937),
    [sym_augmented_assignment_expression] = STATE(577),
    [sym__destructuring_pattern] = STATE(1497),
    [sym_ternary_expression] = STATE(577),
    [sym_binary_expression] = STATE(577),
    [sym_unary_expression] = STATE(577),
    [sym_update_expression] = STATE(577),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1533),
    [aux_sym_export_statement_repeat1] = STATE(1182),
    [sym_identifier] = ACTIONS(443),
    [anon_sym_export] = ACTIONS(445),
    [anon_sym_LBRACE] = ACTIONS(421),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(449),
    [anon_sym_yield] = ACTIONS(451),
    [anon_sym_LBRACK] = ACTIONS(427),
    [anon_sym_LT] = ACTIONS(585),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(453),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(455),
    [anon_sym_PLUS] = ACTIONS(457),
    [anon_sym_DASH] = ACTIONS(457),
    [anon_sym_BANG] = ACTIONS(459),
    [anon_sym_TILDE] = ACTIONS(459),
    [anon_sym_typeof] = ACTIONS(457),
    [anon_sym_void] = ACTIONS(457),
    [anon_sym_delete] = ACTIONS(457),
    [anon_sym_PLUS_PLUS] = ACTIONS(461),
    [anon_sym_DASH_DASH] = ACTIONS(461),
    [anon_sym_DQUOTE] = ACTIONS(361),
    [anon_sym_SQUOTE] = ACTIONS(363),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(365),
    [sym_number] = ACTIONS(367),
    [sym_this] = ACTIONS(369),
    [sym_super] = ACTIONS(369),
    [sym_true] = ACTIONS(369),
    [sym_false] = ACTIONS(369),
    [sym_null] = ACTIONS(369),
    [sym_undefined] = ACTIONS(463),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(445),
    [anon_sym_get] = ACTIONS(445),
    [anon_sym_set] = ACTIONS(445),
  },
  [211] = {
    [sym_import] = STATE(575),
    [sym_parenthesized_expression] = STATE(430),
    [sym_expression] = STATE(770),
    [sym_primary_expression] = STATE(576),
    [sym_yield_expression] = STATE(577),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1497),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1497),
    [sym_jsx_element] = STATE(577),
    [sym_jsx_fragment] = STATE(577),
    [sym_jsx_opening_element] = STATE(975),
    [sym_jsx_self_closing_element] = STATE(577),
    [sym_class] = STATE(575),
    [sym_function] = STATE(575),
    [sym_generator_function] = STATE(575),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(577),
    [sym_await_expression] = STATE(577),
    [sym_member_expression] = STATE(430),
    [sym_subscript_expression] = STATE(430),
    [sym_assignment_expression] = STATE(577),
    [sym__augmented_assignment_lhs] = STATE(937),
    [sym_augmented_assignment_expression] = STATE(577),
    [sym__destructuring_pattern] = STATE(1497),
    [sym_ternary_expression] = STATE(577),
    [sym_binary_expression] = STATE(577),
    [sym_unary_expression] = STATE(577),
    [sym_update_expression] = STATE(577),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1533),
    [aux_sym_export_statement_repeat1] = STATE(1182),
    [sym_identifier] = ACTIONS(443),
    [anon_sym_export] = ACTIONS(445),
    [anon_sym_LBRACE] = ACTIONS(421),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(449),
    [anon_sym_yield] = ACTIONS(451),
    [anon_sym_LBRACK] = ACTIONS(427),
    [anon_sym_LT] = ACTIONS(585),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(453),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(455),
    [anon_sym_PLUS] = ACTIONS(457),
    [anon_sym_DASH] = ACTIONS(457),
    [anon_sym_BANG] = ACTIONS(459),
    [anon_sym_TILDE] = ACTIONS(459),
    [anon_sym_typeof] = ACTIONS(457),
    [anon_sym_void] = ACTIONS(457),
    [anon_sym_delete] = ACTIONS(457),
    [anon_sym_PLUS_PLUS] = ACTIONS(461),
    [anon_sym_DASH_DASH] = ACTIONS(461),
    [anon_sym_DQUOTE] = ACTIONS(361),
    [anon_sym_SQUOTE] = ACTIONS(363),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(365),
    [sym_number] = ACTIONS(367),
    [sym_this] = ACTIONS(369),
    [sym_super] = ACTIONS(369),
    [sym_true] = ACTIONS(369),
    [sym_false] = ACTIONS(369),
    [sym_null] = ACTIONS(369),
    [sym_undefined] = ACTIONS(463),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(445),
    [anon_sym_get] = ACTIONS(445),
    [anon_sym_set] = ACTIONS(445),
  },
  [212] = {
    [sym_import] = STATE(575),
    [sym_parenthesized_expression] = STATE(493),
    [sym_expression] = STATE(798),
    [sym_primary_expression] = STATE(576),
    [sym_yield_expression] = STATE(577),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1580),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1580),
    [sym_jsx_element] = STATE(577),
    [sym_jsx_fragment] = STATE(577),
    [sym_jsx_opening_element] = STATE(975),
    [sym_jsx_self_closing_element] = STATE(577),
    [sym_class] = STATE(575),
    [sym_function] = STATE(575),
    [sym_generator_function] = STATE(575),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(577),
    [sym_await_expression] = STATE(577),
    [sym_member_expression] = STATE(493),
    [sym_subscript_expression] = STATE(493),
    [sym_assignment_expression] = STATE(577),
    [sym__augmented_assignment_lhs] = STATE(933),
    [sym_augmented_assignment_expression] = STATE(577),
    [sym__destructuring_pattern] = STATE(1580),
    [sym_ternary_expression] = STATE(577),
    [sym_binary_expression] = STATE(577),
    [sym_unary_expression] = STATE(577),
    [sym_update_expression] = STATE(577),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1555),
    [aux_sym_export_statement_repeat1] = STATE(1182),
    [sym_identifier] = ACTIONS(415),
    [anon_sym_export] = ACTIONS(417),
    [anon_sym_LBRACE] = ACTIONS(421),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(423),
    [anon_sym_yield] = ACTIONS(425),
    [anon_sym_LBRACK] = ACTIONS(427),
    [anon_sym_LT] = ACTIONS(585),
    [anon_sym_SLASH] = ACTIONS(429),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(431),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(433),
    [anon_sym_PLUS] = ACTIONS(435),
    [anon_sym_DASH] = ACTIONS(435),
    [anon_sym_BANG] = ACTIONS(437),
    [anon_sym_TILDE] = ACTIONS(437),
    [anon_sym_typeof] = ACTIONS(435),
    [anon_sym_void] = ACTIONS(435),
    [anon_sym_delete] = ACTIONS(435),
    [anon_sym_PLUS_PLUS] = ACTIONS(439),
    [anon_sym_DASH_DASH] = ACTIONS(439),
    [anon_sym_DQUOTE] = ACTIONS(361),
    [anon_sym_SQUOTE] = ACTIONS(363),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(365),
    [sym_number] = ACTIONS(367),
    [sym_this] = ACTIONS(369),
    [sym_super] = ACTIONS(369),
    [sym_true] = ACTIONS(369),
    [sym_false] = ACTIONS(369),
    [sym_null] = ACTIONS(369),
    [sym_undefined] = ACTIONS(441),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(417),
    [anon_sym_get] = ACTIONS(417),
    [anon_sym_set] = ACTIONS(417),
  },
  [213] = {
    [sym_import] = STATE(721),
    [sym_parenthesized_expression] = STATE(479),
    [sym_expression] = STATE(618),
    [sym_primary_expression] = STATE(743),
    [sym_yield_expression] = STATE(740),
    [sym_object] = STATE(721),
    [sym_object_pattern] = STATE(1548),
    [sym_array] = STATE(721),
    [sym_array_pattern] = STATE(1548),
    [sym_jsx_element] = STATE(740),
    [sym_jsx_fragment] = STATE(740),
    [sym_jsx_opening_element] = STATE(972),
    [sym_jsx_self_closing_element] = STATE(740),
    [sym_class] = STATE(721),
    [sym_function] = STATE(721),
    [sym_generator_function] = STATE(721),
    [sym_arrow_function] = STATE(721),
    [sym_call_expression] = STATE(721),
    [sym_new_expression] = STATE(740),
    [sym_await_expression] = STATE(740),
    [sym_member_expression] = STATE(479),
    [sym_subscript_expression] = STATE(479),
    [sym_assignment_expression] = STATE(740),
    [sym__augmented_assignment_lhs] = STATE(942),
    [sym_augmented_assignment_expression] = STATE(740),
    [sym__destructuring_pattern] = STATE(1548),
    [sym_ternary_expression] = STATE(740),
    [sym_binary_expression] = STATE(740),
    [sym_unary_expression] = STATE(740),
    [sym_update_expression] = STATE(740),
    [sym_string] = STATE(721),
    [sym_template_string] = STATE(721),
    [sym_regex] = STATE(721),
    [sym_meta_property] = STATE(721),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1546),
    [aux_sym_export_statement_repeat1] = STATE(1154),
    [sym_identifier] = ACTIONS(407),
    [anon_sym_export] = ACTIONS(409),
    [anon_sym_LBRACE] = ACTIONS(379),
    [anon_sym_import] = ACTIONS(381),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(391),
    [anon_sym_async] = ACTIONS(413),
    [anon_sym_function] = ACTIONS(395),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(67),
    [anon_sym_void] = ACTIONS(67),
    [anon_sym_delete] = ACTIONS(67),
    [anon_sym_PLUS_PLUS] = ACTIONS(71),
    [anon_sym_DASH_DASH] = ACTIONS(71),
    [anon_sym_DQUOTE] = ACTIONS(73),
    [anon_sym_SQUOTE] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(77),
    [sym_number] = ACTIONS(79),
    [sym_this] = ACTIONS(81),
    [sym_super] = ACTIONS(81),
    [sym_true] = ACTIONS(81),
    [sym_false] = ACTIONS(81),
    [sym_null] = ACTIONS(81),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(409),
    [anon_sym_get] = ACTIONS(409),
    [anon_sym_set] = ACTIONS(409),
  },
  [214] = {
    [sym_import] = STATE(575),
    [sym_parenthesized_expression] = STATE(493),
    [sym_expression] = STATE(820),
    [sym_primary_expression] = STATE(576),
    [sym_yield_expression] = STATE(577),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1580),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1580),
    [sym_jsx_element] = STATE(577),
    [sym_jsx_fragment] = STATE(577),
    [sym_jsx_opening_element] = STATE(975),
    [sym_jsx_self_closing_element] = STATE(577),
    [sym_class] = STATE(575),
    [sym_function] = STATE(575),
    [sym_generator_function] = STATE(575),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(577),
    [sym_await_expression] = STATE(577),
    [sym_member_expression] = STATE(493),
    [sym_subscript_expression] = STATE(493),
    [sym_assignment_expression] = STATE(577),
    [sym__augmented_assignment_lhs] = STATE(933),
    [sym_augmented_assignment_expression] = STATE(577),
    [sym__destructuring_pattern] = STATE(1580),
    [sym_ternary_expression] = STATE(577),
    [sym_binary_expression] = STATE(577),
    [sym_unary_expression] = STATE(577),
    [sym_update_expression] = STATE(577),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1555),
    [aux_sym_export_statement_repeat1] = STATE(1182),
    [sym_identifier] = ACTIONS(415),
    [anon_sym_export] = ACTIONS(417),
    [anon_sym_LBRACE] = ACTIONS(421),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(423),
    [anon_sym_yield] = ACTIONS(425),
    [anon_sym_LBRACK] = ACTIONS(427),
    [anon_sym_LT] = ACTIONS(585),
    [anon_sym_SLASH] = ACTIONS(429),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(431),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(433),
    [anon_sym_PLUS] = ACTIONS(435),
    [anon_sym_DASH] = ACTIONS(435),
    [anon_sym_BANG] = ACTIONS(437),
    [anon_sym_TILDE] = ACTIONS(437),
    [anon_sym_typeof] = ACTIONS(435),
    [anon_sym_void] = ACTIONS(435),
    [anon_sym_delete] = ACTIONS(435),
    [anon_sym_PLUS_PLUS] = ACTIONS(439),
    [anon_sym_DASH_DASH] = ACTIONS(439),
    [anon_sym_DQUOTE] = ACTIONS(361),
    [anon_sym_SQUOTE] = ACTIONS(363),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(365),
    [sym_number] = ACTIONS(367),
    [sym_this] = ACTIONS(369),
    [sym_super] = ACTIONS(369),
    [sym_true] = ACTIONS(369),
    [sym_false] = ACTIONS(369),
    [sym_null] = ACTIONS(369),
    [sym_undefined] = ACTIONS(441),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(417),
    [anon_sym_get] = ACTIONS(417),
    [anon_sym_set] = ACTIONS(417),
  },
  [215] = {
    [sym_import] = STATE(575),
    [sym_parenthesized_expression] = STATE(430),
    [sym_expression] = STATE(767),
    [sym_primary_expression] = STATE(576),
    [sym_yield_expression] = STATE(577),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1497),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1497),
    [sym_jsx_element] = STATE(577),
    [sym_jsx_fragment] = STATE(577),
    [sym_jsx_opening_element] = STATE(975),
    [sym_jsx_self_closing_element] = STATE(577),
    [sym_class] = STATE(575),
    [sym_function] = STATE(575),
    [sym_generator_function] = STATE(575),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(577),
    [sym_await_expression] = STATE(577),
    [sym_member_expression] = STATE(430),
    [sym_subscript_expression] = STATE(430),
    [sym_assignment_expression] = STATE(577),
    [sym__augmented_assignment_lhs] = STATE(937),
    [sym_augmented_assignment_expression] = STATE(577),
    [sym__destructuring_pattern] = STATE(1497),
    [sym_ternary_expression] = STATE(577),
    [sym_binary_expression] = STATE(577),
    [sym_unary_expression] = STATE(577),
    [sym_update_expression] = STATE(577),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1533),
    [aux_sym_export_statement_repeat1] = STATE(1182),
    [sym_identifier] = ACTIONS(443),
    [anon_sym_export] = ACTIONS(445),
    [anon_sym_LBRACE] = ACTIONS(421),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(449),
    [anon_sym_yield] = ACTIONS(451),
    [anon_sym_LBRACK] = ACTIONS(427),
    [anon_sym_LT] = ACTIONS(585),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(453),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(455),
    [anon_sym_PLUS] = ACTIONS(457),
    [anon_sym_DASH] = ACTIONS(457),
    [anon_sym_BANG] = ACTIONS(459),
    [anon_sym_TILDE] = ACTIONS(459),
    [anon_sym_typeof] = ACTIONS(457),
    [anon_sym_void] = ACTIONS(457),
    [anon_sym_delete] = ACTIONS(457),
    [anon_sym_PLUS_PLUS] = ACTIONS(461),
    [anon_sym_DASH_DASH] = ACTIONS(461),
    [anon_sym_DQUOTE] = ACTIONS(361),
    [anon_sym_SQUOTE] = ACTIONS(363),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(365),
    [sym_number] = ACTIONS(367),
    [sym_this] = ACTIONS(369),
    [sym_super] = ACTIONS(369),
    [sym_true] = ACTIONS(369),
    [sym_false] = ACTIONS(369),
    [sym_null] = ACTIONS(369),
    [sym_undefined] = ACTIONS(463),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(445),
    [anon_sym_get] = ACTIONS(445),
    [anon_sym_set] = ACTIONS(445),
  },
  [216] = {
    [sym_import] = STATE(575),
    [sym_parenthesized_expression] = STATE(430),
    [sym_expression] = STATE(766),
    [sym_primary_expression] = STATE(576),
    [sym_yield_expression] = STATE(577),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1497),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1497),
    [sym_jsx_element] = STATE(577),
    [sym_jsx_fragment] = STATE(577),
    [sym_jsx_opening_element] = STATE(975),
    [sym_jsx_self_closing_element] = STATE(577),
    [sym_class] = STATE(575),
    [sym_function] = STATE(575),
    [sym_generator_function] = STATE(575),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(577),
    [sym_await_expression] = STATE(577),
    [sym_member_expression] = STATE(430),
    [sym_subscript_expression] = STATE(430),
    [sym_assignment_expression] = STATE(577),
    [sym__augmented_assignment_lhs] = STATE(937),
    [sym_augmented_assignment_expression] = STATE(577),
    [sym__destructuring_pattern] = STATE(1497),
    [sym_ternary_expression] = STATE(577),
    [sym_binary_expression] = STATE(577),
    [sym_unary_expression] = STATE(577),
    [sym_update_expression] = STATE(577),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1533),
    [aux_sym_export_statement_repeat1] = STATE(1182),
    [sym_identifier] = ACTIONS(443),
    [anon_sym_export] = ACTIONS(445),
    [anon_sym_LBRACE] = ACTIONS(421),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(449),
    [anon_sym_yield] = ACTIONS(451),
    [anon_sym_LBRACK] = ACTIONS(427),
    [anon_sym_LT] = ACTIONS(585),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(453),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(455),
    [anon_sym_PLUS] = ACTIONS(457),
    [anon_sym_DASH] = ACTIONS(457),
    [anon_sym_BANG] = ACTIONS(459),
    [anon_sym_TILDE] = ACTIONS(459),
    [anon_sym_typeof] = ACTIONS(457),
    [anon_sym_void] = ACTIONS(457),
    [anon_sym_delete] = ACTIONS(457),
    [anon_sym_PLUS_PLUS] = ACTIONS(461),
    [anon_sym_DASH_DASH] = ACTIONS(461),
    [anon_sym_DQUOTE] = ACTIONS(361),
    [anon_sym_SQUOTE] = ACTIONS(363),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(365),
    [sym_number] = ACTIONS(367),
    [sym_this] = ACTIONS(369),
    [sym_super] = ACTIONS(369),
    [sym_true] = ACTIONS(369),
    [sym_false] = ACTIONS(369),
    [sym_null] = ACTIONS(369),
    [sym_undefined] = ACTIONS(463),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(445),
    [anon_sym_get] = ACTIONS(445),
    [anon_sym_set] = ACTIONS(445),
  },
  [217] = {
    [sym_import] = STATE(575),
    [sym_parenthesized_expression] = STATE(430),
    [sym_expression] = STATE(759),
    [sym_primary_expression] = STATE(576),
    [sym_yield_expression] = STATE(577),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1497),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1497),
    [sym_jsx_element] = STATE(577),
    [sym_jsx_fragment] = STATE(577),
    [sym_jsx_opening_element] = STATE(975),
    [sym_jsx_self_closing_element] = STATE(577),
    [sym_class] = STATE(575),
    [sym_function] = STATE(575),
    [sym_generator_function] = STATE(575),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(577),
    [sym_await_expression] = STATE(577),
    [sym_member_expression] = STATE(430),
    [sym_subscript_expression] = STATE(430),
    [sym_assignment_expression] = STATE(577),
    [sym__augmented_assignment_lhs] = STATE(937),
    [sym_augmented_assignment_expression] = STATE(577),
    [sym__destructuring_pattern] = STATE(1497),
    [sym_ternary_expression] = STATE(577),
    [sym_binary_expression] = STATE(577),
    [sym_unary_expression] = STATE(577),
    [sym_update_expression] = STATE(577),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1533),
    [aux_sym_export_statement_repeat1] = STATE(1182),
    [sym_identifier] = ACTIONS(443),
    [anon_sym_export] = ACTIONS(445),
    [anon_sym_LBRACE] = ACTIONS(421),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(449),
    [anon_sym_yield] = ACTIONS(451),
    [anon_sym_LBRACK] = ACTIONS(427),
    [anon_sym_LT] = ACTIONS(585),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(453),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(455),
    [anon_sym_PLUS] = ACTIONS(457),
    [anon_sym_DASH] = ACTIONS(457),
    [anon_sym_BANG] = ACTIONS(459),
    [anon_sym_TILDE] = ACTIONS(459),
    [anon_sym_typeof] = ACTIONS(457),
    [anon_sym_void] = ACTIONS(457),
    [anon_sym_delete] = ACTIONS(457),
    [anon_sym_PLUS_PLUS] = ACTIONS(461),
    [anon_sym_DASH_DASH] = ACTIONS(461),
    [anon_sym_DQUOTE] = ACTIONS(361),
    [anon_sym_SQUOTE] = ACTIONS(363),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(365),
    [sym_number] = ACTIONS(367),
    [sym_this] = ACTIONS(369),
    [sym_super] = ACTIONS(369),
    [sym_true] = ACTIONS(369),
    [sym_false] = ACTIONS(369),
    [sym_null] = ACTIONS(369),
    [sym_undefined] = ACTIONS(463),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(445),
    [anon_sym_get] = ACTIONS(445),
    [anon_sym_set] = ACTIONS(445),
  },
  [218] = {
    [sym_import] = STATE(575),
    [sym_parenthesized_expression] = STATE(430),
    [sym_expression] = STATE(756),
    [sym_primary_expression] = STATE(576),
    [sym_yield_expression] = STATE(577),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1497),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1497),
    [sym_jsx_element] = STATE(577),
    [sym_jsx_fragment] = STATE(577),
    [sym_jsx_opening_element] = STATE(975),
    [sym_jsx_self_closing_element] = STATE(577),
    [sym_class] = STATE(575),
    [sym_function] = STATE(575),
    [sym_generator_function] = STATE(575),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(577),
    [sym_await_expression] = STATE(577),
    [sym_member_expression] = STATE(430),
    [sym_subscript_expression] = STATE(430),
    [sym_assignment_expression] = STATE(577),
    [sym__augmented_assignment_lhs] = STATE(937),
    [sym_augmented_assignment_expression] = STATE(577),
    [sym__destructuring_pattern] = STATE(1497),
    [sym_ternary_expression] = STATE(577),
    [sym_binary_expression] = STATE(577),
    [sym_unary_expression] = STATE(577),
    [sym_update_expression] = STATE(577),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1533),
    [aux_sym_export_statement_repeat1] = STATE(1182),
    [sym_identifier] = ACTIONS(443),
    [anon_sym_export] = ACTIONS(445),
    [anon_sym_LBRACE] = ACTIONS(421),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(449),
    [anon_sym_yield] = ACTIONS(451),
    [anon_sym_LBRACK] = ACTIONS(427),
    [anon_sym_LT] = ACTIONS(585),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(453),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(455),
    [anon_sym_PLUS] = ACTIONS(457),
    [anon_sym_DASH] = ACTIONS(457),
    [anon_sym_BANG] = ACTIONS(459),
    [anon_sym_TILDE] = ACTIONS(459),
    [anon_sym_typeof] = ACTIONS(457),
    [anon_sym_void] = ACTIONS(457),
    [anon_sym_delete] = ACTIONS(457),
    [anon_sym_PLUS_PLUS] = ACTIONS(461),
    [anon_sym_DASH_DASH] = ACTIONS(461),
    [anon_sym_DQUOTE] = ACTIONS(361),
    [anon_sym_SQUOTE] = ACTIONS(363),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(365),
    [sym_number] = ACTIONS(367),
    [sym_this] = ACTIONS(369),
    [sym_super] = ACTIONS(369),
    [sym_true] = ACTIONS(369),
    [sym_false] = ACTIONS(369),
    [sym_null] = ACTIONS(369),
    [sym_undefined] = ACTIONS(463),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(445),
    [anon_sym_get] = ACTIONS(445),
    [anon_sym_set] = ACTIONS(445),
  },
  [219] = {
    [sym_import] = STATE(575),
    [sym_parenthesized_expression] = STATE(430),
    [sym_expression] = STATE(755),
    [sym_primary_expression] = STATE(576),
    [sym_yield_expression] = STATE(577),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1497),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1497),
    [sym_jsx_element] = STATE(577),
    [sym_jsx_fragment] = STATE(577),
    [sym_jsx_opening_element] = STATE(975),
    [sym_jsx_self_closing_element] = STATE(577),
    [sym_class] = STATE(575),
    [sym_function] = STATE(575),
    [sym_generator_function] = STATE(575),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(577),
    [sym_await_expression] = STATE(577),
    [sym_member_expression] = STATE(430),
    [sym_subscript_expression] = STATE(430),
    [sym_assignment_expression] = STATE(577),
    [sym__augmented_assignment_lhs] = STATE(937),
    [sym_augmented_assignment_expression] = STATE(577),
    [sym__destructuring_pattern] = STATE(1497),
    [sym_ternary_expression] = STATE(577),
    [sym_binary_expression] = STATE(577),
    [sym_unary_expression] = STATE(577),
    [sym_update_expression] = STATE(577),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1533),
    [aux_sym_export_statement_repeat1] = STATE(1182),
    [sym_identifier] = ACTIONS(443),
    [anon_sym_export] = ACTIONS(445),
    [anon_sym_LBRACE] = ACTIONS(421),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(449),
    [anon_sym_yield] = ACTIONS(451),
    [anon_sym_LBRACK] = ACTIONS(427),
    [anon_sym_LT] = ACTIONS(585),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(453),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(455),
    [anon_sym_PLUS] = ACTIONS(457),
    [anon_sym_DASH] = ACTIONS(457),
    [anon_sym_BANG] = ACTIONS(459),
    [anon_sym_TILDE] = ACTIONS(459),
    [anon_sym_typeof] = ACTIONS(457),
    [anon_sym_void] = ACTIONS(457),
    [anon_sym_delete] = ACTIONS(457),
    [anon_sym_PLUS_PLUS] = ACTIONS(461),
    [anon_sym_DASH_DASH] = ACTIONS(461),
    [anon_sym_DQUOTE] = ACTIONS(361),
    [anon_sym_SQUOTE] = ACTIONS(363),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(365),
    [sym_number] = ACTIONS(367),
    [sym_this] = ACTIONS(369),
    [sym_super] = ACTIONS(369),
    [sym_true] = ACTIONS(369),
    [sym_false] = ACTIONS(369),
    [sym_null] = ACTIONS(369),
    [sym_undefined] = ACTIONS(463),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(445),
    [anon_sym_get] = ACTIONS(445),
    [anon_sym_set] = ACTIONS(445),
  },
  [220] = {
    [sym_import] = STATE(575),
    [sym_parenthesized_expression] = STATE(430),
    [sym_expression] = STATE(808),
    [sym_primary_expression] = STATE(576),
    [sym_yield_expression] = STATE(577),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1497),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1497),
    [sym_jsx_element] = STATE(577),
    [sym_jsx_fragment] = STATE(577),
    [sym_jsx_opening_element] = STATE(975),
    [sym_jsx_self_closing_element] = STATE(577),
    [sym_class] = STATE(575),
    [sym_function] = STATE(575),
    [sym_generator_function] = STATE(575),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(577),
    [sym_await_expression] = STATE(577),
    [sym_member_expression] = STATE(430),
    [sym_subscript_expression] = STATE(430),
    [sym_assignment_expression] = STATE(577),
    [sym__augmented_assignment_lhs] = STATE(937),
    [sym_augmented_assignment_expression] = STATE(577),
    [sym__destructuring_pattern] = STATE(1497),
    [sym_ternary_expression] = STATE(577),
    [sym_binary_expression] = STATE(577),
    [sym_unary_expression] = STATE(577),
    [sym_update_expression] = STATE(577),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1533),
    [aux_sym_export_statement_repeat1] = STATE(1182),
    [sym_identifier] = ACTIONS(443),
    [anon_sym_export] = ACTIONS(445),
    [anon_sym_LBRACE] = ACTIONS(421),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(449),
    [anon_sym_yield] = ACTIONS(451),
    [anon_sym_LBRACK] = ACTIONS(427),
    [anon_sym_LT] = ACTIONS(585),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(453),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(455),
    [anon_sym_PLUS] = ACTIONS(457),
    [anon_sym_DASH] = ACTIONS(457),
    [anon_sym_BANG] = ACTIONS(459),
    [anon_sym_TILDE] = ACTIONS(459),
    [anon_sym_typeof] = ACTIONS(457),
    [anon_sym_void] = ACTIONS(457),
    [anon_sym_delete] = ACTIONS(457),
    [anon_sym_PLUS_PLUS] = ACTIONS(461),
    [anon_sym_DASH_DASH] = ACTIONS(461),
    [anon_sym_DQUOTE] = ACTIONS(361),
    [anon_sym_SQUOTE] = ACTIONS(363),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(365),
    [sym_number] = ACTIONS(367),
    [sym_this] = ACTIONS(369),
    [sym_super] = ACTIONS(369),
    [sym_true] = ACTIONS(369),
    [sym_false] = ACTIONS(369),
    [sym_null] = ACTIONS(369),
    [sym_undefined] = ACTIONS(463),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(445),
    [anon_sym_get] = ACTIONS(445),
    [anon_sym_set] = ACTIONS(445),
  },
  [221] = {
    [sym_import] = STATE(721),
    [sym_parenthesized_expression] = STATE(466),
    [sym_expression] = STATE(646),
    [sym_primary_expression] = STATE(743),
    [sym_yield_expression] = STATE(740),
    [sym_object] = STATE(721),
    [sym_object_pattern] = STATE(1486),
    [sym_array] = STATE(721),
    [sym_array_pattern] = STATE(1486),
    [sym_jsx_element] = STATE(740),
    [sym_jsx_fragment] = STATE(740),
    [sym_jsx_opening_element] = STATE(972),
    [sym_jsx_self_closing_element] = STATE(740),
    [sym_class] = STATE(721),
    [sym_function] = STATE(721),
    [sym_generator_function] = STATE(721),
    [sym_arrow_function] = STATE(721),
    [sym_call_expression] = STATE(721),
    [sym_new_expression] = STATE(740),
    [sym_await_expression] = STATE(740),
    [sym_member_expression] = STATE(466),
    [sym_subscript_expression] = STATE(466),
    [sym_assignment_expression] = STATE(740),
    [sym__augmented_assignment_lhs] = STATE(940),
    [sym_augmented_assignment_expression] = STATE(740),
    [sym__destructuring_pattern] = STATE(1486),
    [sym_ternary_expression] = STATE(740),
    [sym_binary_expression] = STATE(740),
    [sym_unary_expression] = STATE(740),
    [sym_update_expression] = STATE(740),
    [sym_string] = STATE(721),
    [sym_template_string] = STATE(721),
    [sym_regex] = STATE(721),
    [sym_meta_property] = STATE(721),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1487),
    [aux_sym_export_statement_repeat1] = STATE(1154),
    [sym_identifier] = ACTIONS(373),
    [anon_sym_export] = ACTIONS(375),
    [anon_sym_LBRACE] = ACTIONS(379),
    [anon_sym_import] = ACTIONS(381),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(383),
    [anon_sym_yield] = ACTIONS(385),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(389),
    [anon_sym_class] = ACTIONS(391),
    [anon_sym_async] = ACTIONS(393),
    [anon_sym_function] = ACTIONS(395),
    [anon_sym_new] = ACTIONS(397),
    [anon_sym_PLUS] = ACTIONS(399),
    [anon_sym_DASH] = ACTIONS(399),
    [anon_sym_BANG] = ACTIONS(401),
    [anon_sym_TILDE] = ACTIONS(401),
    [anon_sym_typeof] = ACTIONS(399),
    [anon_sym_void] = ACTIONS(399),
    [anon_sym_delete] = ACTIONS(399),
    [anon_sym_PLUS_PLUS] = ACTIONS(403),
    [anon_sym_DASH_DASH] = ACTIONS(403),
    [anon_sym_DQUOTE] = ACTIONS(73),
    [anon_sym_SQUOTE] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(77),
    [sym_number] = ACTIONS(79),
    [sym_this] = ACTIONS(81),
    [sym_super] = ACTIONS(81),
    [sym_true] = ACTIONS(81),
    [sym_false] = ACTIONS(81),
    [sym_null] = ACTIONS(81),
    [sym_undefined] = ACTIONS(405),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(375),
    [anon_sym_get] = ACTIONS(375),
    [anon_sym_set] = ACTIONS(375),
  },
  [222] = {
    [sym_import] = STATE(721),
    [sym_parenthesized_expression] = STATE(466),
    [sym_expression] = STATE(645),
    [sym_primary_expression] = STATE(743),
    [sym_yield_expression] = STATE(740),
    [sym_object] = STATE(721),
    [sym_object_pattern] = STATE(1486),
    [sym_array] = STATE(721),
    [sym_array_pattern] = STATE(1486),
    [sym_jsx_element] = STATE(740),
    [sym_jsx_fragment] = STATE(740),
    [sym_jsx_opening_element] = STATE(972),
    [sym_jsx_self_closing_element] = STATE(740),
    [sym_class] = STATE(721),
    [sym_function] = STATE(721),
    [sym_generator_function] = STATE(721),
    [sym_arrow_function] = STATE(721),
    [sym_call_expression] = STATE(721),
    [sym_new_expression] = STATE(740),
    [sym_await_expression] = STATE(740),
    [sym_member_expression] = STATE(466),
    [sym_subscript_expression] = STATE(466),
    [sym_assignment_expression] = STATE(740),
    [sym__augmented_assignment_lhs] = STATE(940),
    [sym_augmented_assignment_expression] = STATE(740),
    [sym__destructuring_pattern] = STATE(1486),
    [sym_ternary_expression] = STATE(740),
    [sym_binary_expression] = STATE(740),
    [sym_unary_expression] = STATE(740),
    [sym_update_expression] = STATE(740),
    [sym_string] = STATE(721),
    [sym_template_string] = STATE(721),
    [sym_regex] = STATE(721),
    [sym_meta_property] = STATE(721),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1487),
    [aux_sym_export_statement_repeat1] = STATE(1154),
    [sym_identifier] = ACTIONS(373),
    [anon_sym_export] = ACTIONS(375),
    [anon_sym_LBRACE] = ACTIONS(379),
    [anon_sym_import] = ACTIONS(381),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(383),
    [anon_sym_yield] = ACTIONS(385),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(389),
    [anon_sym_class] = ACTIONS(391),
    [anon_sym_async] = ACTIONS(393),
    [anon_sym_function] = ACTIONS(395),
    [anon_sym_new] = ACTIONS(397),
    [anon_sym_PLUS] = ACTIONS(399),
    [anon_sym_DASH] = ACTIONS(399),
    [anon_sym_BANG] = ACTIONS(401),
    [anon_sym_TILDE] = ACTIONS(401),
    [anon_sym_typeof] = ACTIONS(399),
    [anon_sym_void] = ACTIONS(399),
    [anon_sym_delete] = ACTIONS(399),
    [anon_sym_PLUS_PLUS] = ACTIONS(403),
    [anon_sym_DASH_DASH] = ACTIONS(403),
    [anon_sym_DQUOTE] = ACTIONS(73),
    [anon_sym_SQUOTE] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(77),
    [sym_number] = ACTIONS(79),
    [sym_this] = ACTIONS(81),
    [sym_super] = ACTIONS(81),
    [sym_true] = ACTIONS(81),
    [sym_false] = ACTIONS(81),
    [sym_null] = ACTIONS(81),
    [sym_undefined] = ACTIONS(405),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(375),
    [anon_sym_get] = ACTIONS(375),
    [anon_sym_set] = ACTIONS(375),
  },
  [223] = {
    [sym_import] = STATE(575),
    [sym_parenthesized_expression] = STATE(430),
    [sym_expression] = STATE(752),
    [sym_primary_expression] = STATE(576),
    [sym_yield_expression] = STATE(577),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1497),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1497),
    [sym_jsx_element] = STATE(577),
    [sym_jsx_fragment] = STATE(577),
    [sym_jsx_opening_element] = STATE(975),
    [sym_jsx_self_closing_element] = STATE(577),
    [sym_class] = STATE(575),
    [sym_function] = STATE(575),
    [sym_generator_function] = STATE(575),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(577),
    [sym_await_expression] = STATE(577),
    [sym_member_expression] = STATE(430),
    [sym_subscript_expression] = STATE(430),
    [sym_assignment_expression] = STATE(577),
    [sym__augmented_assignment_lhs] = STATE(937),
    [sym_augmented_assignment_expression] = STATE(577),
    [sym__destructuring_pattern] = STATE(1497),
    [sym_ternary_expression] = STATE(577),
    [sym_binary_expression] = STATE(577),
    [sym_unary_expression] = STATE(577),
    [sym_update_expression] = STATE(577),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1533),
    [aux_sym_export_statement_repeat1] = STATE(1182),
    [sym_identifier] = ACTIONS(443),
    [anon_sym_export] = ACTIONS(445),
    [anon_sym_LBRACE] = ACTIONS(421),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(449),
    [anon_sym_yield] = ACTIONS(451),
    [anon_sym_LBRACK] = ACTIONS(427),
    [anon_sym_LT] = ACTIONS(585),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(453),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(455),
    [anon_sym_PLUS] = ACTIONS(457),
    [anon_sym_DASH] = ACTIONS(457),
    [anon_sym_BANG] = ACTIONS(459),
    [anon_sym_TILDE] = ACTIONS(459),
    [anon_sym_typeof] = ACTIONS(457),
    [anon_sym_void] = ACTIONS(457),
    [anon_sym_delete] = ACTIONS(457),
    [anon_sym_PLUS_PLUS] = ACTIONS(461),
    [anon_sym_DASH_DASH] = ACTIONS(461),
    [anon_sym_DQUOTE] = ACTIONS(361),
    [anon_sym_SQUOTE] = ACTIONS(363),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(365),
    [sym_number] = ACTIONS(367),
    [sym_this] = ACTIONS(369),
    [sym_super] = ACTIONS(369),
    [sym_true] = ACTIONS(369),
    [sym_false] = ACTIONS(369),
    [sym_null] = ACTIONS(369),
    [sym_undefined] = ACTIONS(463),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(445),
    [anon_sym_get] = ACTIONS(445),
    [anon_sym_set] = ACTIONS(445),
  },
  [224] = {
    [sym_import] = STATE(575),
    [sym_parenthesized_expression] = STATE(493),
    [sym_expression] = STATE(822),
    [sym_primary_expression] = STATE(576),
    [sym_yield_expression] = STATE(577),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1580),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1580),
    [sym_jsx_element] = STATE(577),
    [sym_jsx_fragment] = STATE(577),
    [sym_jsx_opening_element] = STATE(975),
    [sym_jsx_self_closing_element] = STATE(577),
    [sym_class] = STATE(575),
    [sym_function] = STATE(575),
    [sym_generator_function] = STATE(575),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(577),
    [sym_await_expression] = STATE(577),
    [sym_member_expression] = STATE(493),
    [sym_subscript_expression] = STATE(493),
    [sym_assignment_expression] = STATE(577),
    [sym__augmented_assignment_lhs] = STATE(933),
    [sym_augmented_assignment_expression] = STATE(577),
    [sym__destructuring_pattern] = STATE(1580),
    [sym_ternary_expression] = STATE(577),
    [sym_binary_expression] = STATE(577),
    [sym_unary_expression] = STATE(577),
    [sym_update_expression] = STATE(577),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1555),
    [aux_sym_export_statement_repeat1] = STATE(1182),
    [sym_identifier] = ACTIONS(415),
    [anon_sym_export] = ACTIONS(417),
    [anon_sym_LBRACE] = ACTIONS(421),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(423),
    [anon_sym_yield] = ACTIONS(425),
    [anon_sym_LBRACK] = ACTIONS(427),
    [anon_sym_LT] = ACTIONS(585),
    [anon_sym_SLASH] = ACTIONS(429),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(431),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(433),
    [anon_sym_PLUS] = ACTIONS(435),
    [anon_sym_DASH] = ACTIONS(435),
    [anon_sym_BANG] = ACTIONS(437),
    [anon_sym_TILDE] = ACTIONS(437),
    [anon_sym_typeof] = ACTIONS(435),
    [anon_sym_void] = ACTIONS(435),
    [anon_sym_delete] = ACTIONS(435),
    [anon_sym_PLUS_PLUS] = ACTIONS(439),
    [anon_sym_DASH_DASH] = ACTIONS(439),
    [anon_sym_DQUOTE] = ACTIONS(361),
    [anon_sym_SQUOTE] = ACTIONS(363),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(365),
    [sym_number] = ACTIONS(367),
    [sym_this] = ACTIONS(369),
    [sym_super] = ACTIONS(369),
    [sym_true] = ACTIONS(369),
    [sym_false] = ACTIONS(369),
    [sym_null] = ACTIONS(369),
    [sym_undefined] = ACTIONS(441),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(417),
    [anon_sym_get] = ACTIONS(417),
    [anon_sym_set] = ACTIONS(417),
  },
  [225] = {
    [sym_import] = STATE(721),
    [sym_parenthesized_expression] = STATE(466),
    [sym_expression] = STATE(620),
    [sym_primary_expression] = STATE(743),
    [sym_yield_expression] = STATE(740),
    [sym_object] = STATE(721),
    [sym_object_pattern] = STATE(1486),
    [sym_array] = STATE(721),
    [sym_array_pattern] = STATE(1486),
    [sym_jsx_element] = STATE(740),
    [sym_jsx_fragment] = STATE(740),
    [sym_jsx_opening_element] = STATE(972),
    [sym_jsx_self_closing_element] = STATE(740),
    [sym_class] = STATE(721),
    [sym_function] = STATE(721),
    [sym_generator_function] = STATE(721),
    [sym_arrow_function] = STATE(721),
    [sym_call_expression] = STATE(721),
    [sym_new_expression] = STATE(740),
    [sym_await_expression] = STATE(740),
    [sym_member_expression] = STATE(466),
    [sym_subscript_expression] = STATE(466),
    [sym_assignment_expression] = STATE(740),
    [sym__augmented_assignment_lhs] = STATE(940),
    [sym_augmented_assignment_expression] = STATE(740),
    [sym__destructuring_pattern] = STATE(1486),
    [sym_ternary_expression] = STATE(740),
    [sym_binary_expression] = STATE(740),
    [sym_unary_expression] = STATE(740),
    [sym_update_expression] = STATE(740),
    [sym_string] = STATE(721),
    [sym_template_string] = STATE(721),
    [sym_regex] = STATE(721),
    [sym_meta_property] = STATE(721),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1487),
    [aux_sym_export_statement_repeat1] = STATE(1154),
    [sym_identifier] = ACTIONS(373),
    [anon_sym_export] = ACTIONS(375),
    [anon_sym_LBRACE] = ACTIONS(379),
    [anon_sym_import] = ACTIONS(381),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(383),
    [anon_sym_yield] = ACTIONS(385),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(389),
    [anon_sym_class] = ACTIONS(391),
    [anon_sym_async] = ACTIONS(393),
    [anon_sym_function] = ACTIONS(395),
    [anon_sym_new] = ACTIONS(397),
    [anon_sym_PLUS] = ACTIONS(399),
    [anon_sym_DASH] = ACTIONS(399),
    [anon_sym_BANG] = ACTIONS(401),
    [anon_sym_TILDE] = ACTIONS(401),
    [anon_sym_typeof] = ACTIONS(399),
    [anon_sym_void] = ACTIONS(399),
    [anon_sym_delete] = ACTIONS(399),
    [anon_sym_PLUS_PLUS] = ACTIONS(403),
    [anon_sym_DASH_DASH] = ACTIONS(403),
    [anon_sym_DQUOTE] = ACTIONS(73),
    [anon_sym_SQUOTE] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(77),
    [sym_number] = ACTIONS(79),
    [sym_this] = ACTIONS(81),
    [sym_super] = ACTIONS(81),
    [sym_true] = ACTIONS(81),
    [sym_false] = ACTIONS(81),
    [sym_null] = ACTIONS(81),
    [sym_undefined] = ACTIONS(405),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(375),
    [anon_sym_get] = ACTIONS(375),
    [anon_sym_set] = ACTIONS(375),
  },
  [226] = {
    [sym_import] = STATE(575),
    [sym_parenthesized_expression] = STATE(449),
    [sym_expression] = STATE(552),
    [sym_primary_expression] = STATE(576),
    [sym_yield_expression] = STATE(577),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1528),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1528),
    [sym_jsx_element] = STATE(577),
    [sym_jsx_fragment] = STATE(577),
    [sym_jsx_opening_element] = STATE(975),
    [sym_jsx_self_closing_element] = STATE(577),
    [sym_class] = STATE(575),
    [sym_function] = STATE(575),
    [sym_generator_function] = STATE(575),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(577),
    [sym_await_expression] = STATE(577),
    [sym_member_expression] = STATE(449),
    [sym_subscript_expression] = STATE(449),
    [sym_assignment_expression] = STATE(577),
    [sym__augmented_assignment_lhs] = STATE(943),
    [sym_augmented_assignment_expression] = STATE(577),
    [sym__destructuring_pattern] = STATE(1528),
    [sym_ternary_expression] = STATE(577),
    [sym_binary_expression] = STATE(577),
    [sym_unary_expression] = STATE(577),
    [sym_update_expression] = STATE(577),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1496),
    [aux_sym_export_statement_repeat1] = STATE(1182),
    [sym_identifier] = ACTIONS(321),
    [anon_sym_export] = ACTIONS(323),
    [anon_sym_LBRACE] = ACTIONS(327),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(335),
    [anon_sym_yield] = ACTIONS(339),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LT] = ACTIONS(585),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(349),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(353),
    [anon_sym_PLUS] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(355),
    [anon_sym_BANG] = ACTIONS(357),
    [anon_sym_TILDE] = ACTIONS(357),
    [anon_sym_typeof] = ACTIONS(355),
    [anon_sym_void] = ACTIONS(355),
    [anon_sym_delete] = ACTIONS(355),
    [anon_sym_PLUS_PLUS] = ACTIONS(359),
    [anon_sym_DASH_DASH] = ACTIONS(359),
    [anon_sym_DQUOTE] = ACTIONS(361),
    [anon_sym_SQUOTE] = ACTIONS(363),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(365),
    [sym_number] = ACTIONS(367),
    [sym_this] = ACTIONS(369),
    [sym_super] = ACTIONS(369),
    [sym_true] = ACTIONS(369),
    [sym_false] = ACTIONS(369),
    [sym_null] = ACTIONS(369),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(323),
    [anon_sym_get] = ACTIONS(323),
    [anon_sym_set] = ACTIONS(323),
  },
  [227] = {
    [sym_import] = STATE(721),
    [sym_parenthesized_expression] = STATE(466),
    [sym_expression] = STATE(643),
    [sym_primary_expression] = STATE(743),
    [sym_yield_expression] = STATE(740),
    [sym_object] = STATE(721),
    [sym_object_pattern] = STATE(1486),
    [sym_array] = STATE(721),
    [sym_array_pattern] = STATE(1486),
    [sym_jsx_element] = STATE(740),
    [sym_jsx_fragment] = STATE(740),
    [sym_jsx_opening_element] = STATE(972),
    [sym_jsx_self_closing_element] = STATE(740),
    [sym_class] = STATE(721),
    [sym_function] = STATE(721),
    [sym_generator_function] = STATE(721),
    [sym_arrow_function] = STATE(721),
    [sym_call_expression] = STATE(721),
    [sym_new_expression] = STATE(740),
    [sym_await_expression] = STATE(740),
    [sym_member_expression] = STATE(466),
    [sym_subscript_expression] = STATE(466),
    [sym_assignment_expression] = STATE(740),
    [sym__augmented_assignment_lhs] = STATE(940),
    [sym_augmented_assignment_expression] = STATE(740),
    [sym__destructuring_pattern] = STATE(1486),
    [sym_ternary_expression] = STATE(740),
    [sym_binary_expression] = STATE(740),
    [sym_unary_expression] = STATE(740),
    [sym_update_expression] = STATE(740),
    [sym_string] = STATE(721),
    [sym_template_string] = STATE(721),
    [sym_regex] = STATE(721),
    [sym_meta_property] = STATE(721),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1487),
    [aux_sym_export_statement_repeat1] = STATE(1154),
    [sym_identifier] = ACTIONS(373),
    [anon_sym_export] = ACTIONS(375),
    [anon_sym_LBRACE] = ACTIONS(379),
    [anon_sym_import] = ACTIONS(381),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(383),
    [anon_sym_yield] = ACTIONS(385),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(389),
    [anon_sym_class] = ACTIONS(391),
    [anon_sym_async] = ACTIONS(393),
    [anon_sym_function] = ACTIONS(395),
    [anon_sym_new] = ACTIONS(397),
    [anon_sym_PLUS] = ACTIONS(399),
    [anon_sym_DASH] = ACTIONS(399),
    [anon_sym_BANG] = ACTIONS(401),
    [anon_sym_TILDE] = ACTIONS(401),
    [anon_sym_typeof] = ACTIONS(399),
    [anon_sym_void] = ACTIONS(399),
    [anon_sym_delete] = ACTIONS(399),
    [anon_sym_PLUS_PLUS] = ACTIONS(403),
    [anon_sym_DASH_DASH] = ACTIONS(403),
    [anon_sym_DQUOTE] = ACTIONS(73),
    [anon_sym_SQUOTE] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(77),
    [sym_number] = ACTIONS(79),
    [sym_this] = ACTIONS(81),
    [sym_super] = ACTIONS(81),
    [sym_true] = ACTIONS(81),
    [sym_false] = ACTIONS(81),
    [sym_null] = ACTIONS(81),
    [sym_undefined] = ACTIONS(405),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(375),
    [anon_sym_get] = ACTIONS(375),
    [anon_sym_set] = ACTIONS(375),
  },
  [228] = {
    [sym_import] = STATE(575),
    [sym_parenthesized_expression] = STATE(430),
    [sym_expression] = STATE(771),
    [sym_primary_expression] = STATE(576),
    [sym_yield_expression] = STATE(577),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1497),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1497),
    [sym_jsx_element] = STATE(577),
    [sym_jsx_fragment] = STATE(577),
    [sym_jsx_opening_element] = STATE(975),
    [sym_jsx_self_closing_element] = STATE(577),
    [sym_class] = STATE(575),
    [sym_function] = STATE(575),
    [sym_generator_function] = STATE(575),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(577),
    [sym_await_expression] = STATE(577),
    [sym_member_expression] = STATE(430),
    [sym_subscript_expression] = STATE(430),
    [sym_assignment_expression] = STATE(577),
    [sym__augmented_assignment_lhs] = STATE(937),
    [sym_augmented_assignment_expression] = STATE(577),
    [sym__destructuring_pattern] = STATE(1497),
    [sym_ternary_expression] = STATE(577),
    [sym_binary_expression] = STATE(577),
    [sym_unary_expression] = STATE(577),
    [sym_update_expression] = STATE(577),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1533),
    [aux_sym_export_statement_repeat1] = STATE(1182),
    [sym_identifier] = ACTIONS(443),
    [anon_sym_export] = ACTIONS(445),
    [anon_sym_LBRACE] = ACTIONS(421),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(449),
    [anon_sym_yield] = ACTIONS(451),
    [anon_sym_LBRACK] = ACTIONS(427),
    [anon_sym_LT] = ACTIONS(585),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(453),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(455),
    [anon_sym_PLUS] = ACTIONS(457),
    [anon_sym_DASH] = ACTIONS(457),
    [anon_sym_BANG] = ACTIONS(459),
    [anon_sym_TILDE] = ACTIONS(459),
    [anon_sym_typeof] = ACTIONS(457),
    [anon_sym_void] = ACTIONS(457),
    [anon_sym_delete] = ACTIONS(457),
    [anon_sym_PLUS_PLUS] = ACTIONS(461),
    [anon_sym_DASH_DASH] = ACTIONS(461),
    [anon_sym_DQUOTE] = ACTIONS(361),
    [anon_sym_SQUOTE] = ACTIONS(363),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(365),
    [sym_number] = ACTIONS(367),
    [sym_this] = ACTIONS(369),
    [sym_super] = ACTIONS(369),
    [sym_true] = ACTIONS(369),
    [sym_false] = ACTIONS(369),
    [sym_null] = ACTIONS(369),
    [sym_undefined] = ACTIONS(463),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(445),
    [anon_sym_get] = ACTIONS(445),
    [anon_sym_set] = ACTIONS(445),
  },
  [229] = {
    [sym_import] = STATE(575),
    [sym_parenthesized_expression] = STATE(430),
    [sym_expression] = STATE(749),
    [sym_primary_expression] = STATE(576),
    [sym_yield_expression] = STATE(577),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1497),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1497),
    [sym_jsx_element] = STATE(577),
    [sym_jsx_fragment] = STATE(577),
    [sym_jsx_opening_element] = STATE(975),
    [sym_jsx_self_closing_element] = STATE(577),
    [sym_class] = STATE(575),
    [sym_function] = STATE(575),
    [sym_generator_function] = STATE(575),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(577),
    [sym_await_expression] = STATE(577),
    [sym_member_expression] = STATE(430),
    [sym_subscript_expression] = STATE(430),
    [sym_assignment_expression] = STATE(577),
    [sym__augmented_assignment_lhs] = STATE(937),
    [sym_augmented_assignment_expression] = STATE(577),
    [sym__destructuring_pattern] = STATE(1497),
    [sym_ternary_expression] = STATE(577),
    [sym_binary_expression] = STATE(577),
    [sym_unary_expression] = STATE(577),
    [sym_update_expression] = STATE(577),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1533),
    [aux_sym_export_statement_repeat1] = STATE(1182),
    [sym_identifier] = ACTIONS(443),
    [anon_sym_export] = ACTIONS(445),
    [anon_sym_LBRACE] = ACTIONS(421),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(449),
    [anon_sym_yield] = ACTIONS(451),
    [anon_sym_LBRACK] = ACTIONS(427),
    [anon_sym_LT] = ACTIONS(585),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(453),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(455),
    [anon_sym_PLUS] = ACTIONS(457),
    [anon_sym_DASH] = ACTIONS(457),
    [anon_sym_BANG] = ACTIONS(459),
    [anon_sym_TILDE] = ACTIONS(459),
    [anon_sym_typeof] = ACTIONS(457),
    [anon_sym_void] = ACTIONS(457),
    [anon_sym_delete] = ACTIONS(457),
    [anon_sym_PLUS_PLUS] = ACTIONS(461),
    [anon_sym_DASH_DASH] = ACTIONS(461),
    [anon_sym_DQUOTE] = ACTIONS(361),
    [anon_sym_SQUOTE] = ACTIONS(363),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(365),
    [sym_number] = ACTIONS(367),
    [sym_this] = ACTIONS(369),
    [sym_super] = ACTIONS(369),
    [sym_true] = ACTIONS(369),
    [sym_false] = ACTIONS(369),
    [sym_null] = ACTIONS(369),
    [sym_undefined] = ACTIONS(463),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(445),
    [anon_sym_get] = ACTIONS(445),
    [anon_sym_set] = ACTIONS(445),
  },
  [230] = {
    [sym_import] = STATE(575),
    [sym_parenthesized_expression] = STATE(430),
    [sym_expression] = STATE(765),
    [sym_primary_expression] = STATE(576),
    [sym_yield_expression] = STATE(577),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1497),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1497),
    [sym_jsx_element] = STATE(577),
    [sym_jsx_fragment] = STATE(577),
    [sym_jsx_opening_element] = STATE(975),
    [sym_jsx_self_closing_element] = STATE(577),
    [sym_class] = STATE(575),
    [sym_function] = STATE(575),
    [sym_generator_function] = STATE(575),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(577),
    [sym_await_expression] = STATE(577),
    [sym_member_expression] = STATE(430),
    [sym_subscript_expression] = STATE(430),
    [sym_assignment_expression] = STATE(577),
    [sym__augmented_assignment_lhs] = STATE(937),
    [sym_augmented_assignment_expression] = STATE(577),
    [sym__destructuring_pattern] = STATE(1497),
    [sym_ternary_expression] = STATE(577),
    [sym_binary_expression] = STATE(577),
    [sym_unary_expression] = STATE(577),
    [sym_update_expression] = STATE(577),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1533),
    [aux_sym_export_statement_repeat1] = STATE(1182),
    [sym_identifier] = ACTIONS(443),
    [anon_sym_export] = ACTIONS(445),
    [anon_sym_LBRACE] = ACTIONS(421),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(449),
    [anon_sym_yield] = ACTIONS(451),
    [anon_sym_LBRACK] = ACTIONS(427),
    [anon_sym_LT] = ACTIONS(585),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(453),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(455),
    [anon_sym_PLUS] = ACTIONS(457),
    [anon_sym_DASH] = ACTIONS(457),
    [anon_sym_BANG] = ACTIONS(459),
    [anon_sym_TILDE] = ACTIONS(459),
    [anon_sym_typeof] = ACTIONS(457),
    [anon_sym_void] = ACTIONS(457),
    [anon_sym_delete] = ACTIONS(457),
    [anon_sym_PLUS_PLUS] = ACTIONS(461),
    [anon_sym_DASH_DASH] = ACTIONS(461),
    [anon_sym_DQUOTE] = ACTIONS(361),
    [anon_sym_SQUOTE] = ACTIONS(363),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(365),
    [sym_number] = ACTIONS(367),
    [sym_this] = ACTIONS(369),
    [sym_super] = ACTIONS(369),
    [sym_true] = ACTIONS(369),
    [sym_false] = ACTIONS(369),
    [sym_null] = ACTIONS(369),
    [sym_undefined] = ACTIONS(463),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(445),
    [anon_sym_get] = ACTIONS(445),
    [anon_sym_set] = ACTIONS(445),
  },
  [231] = {
    [sym_import] = STATE(575),
    [sym_parenthesized_expression] = STATE(430),
    [sym_expression] = STATE(780),
    [sym_primary_expression] = STATE(576),
    [sym_yield_expression] = STATE(577),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1497),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1497),
    [sym_jsx_element] = STATE(577),
    [sym_jsx_fragment] = STATE(577),
    [sym_jsx_opening_element] = STATE(975),
    [sym_jsx_self_closing_element] = STATE(577),
    [sym_class] = STATE(575),
    [sym_function] = STATE(575),
    [sym_generator_function] = STATE(575),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(577),
    [sym_await_expression] = STATE(577),
    [sym_member_expression] = STATE(430),
    [sym_subscript_expression] = STATE(430),
    [sym_assignment_expression] = STATE(577),
    [sym__augmented_assignment_lhs] = STATE(937),
    [sym_augmented_assignment_expression] = STATE(577),
    [sym__destructuring_pattern] = STATE(1497),
    [sym_ternary_expression] = STATE(577),
    [sym_binary_expression] = STATE(577),
    [sym_unary_expression] = STATE(577),
    [sym_update_expression] = STATE(577),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1533),
    [aux_sym_export_statement_repeat1] = STATE(1182),
    [sym_identifier] = ACTIONS(443),
    [anon_sym_export] = ACTIONS(445),
    [anon_sym_LBRACE] = ACTIONS(421),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(449),
    [anon_sym_yield] = ACTIONS(451),
    [anon_sym_LBRACK] = ACTIONS(427),
    [anon_sym_LT] = ACTIONS(585),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(453),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(455),
    [anon_sym_PLUS] = ACTIONS(457),
    [anon_sym_DASH] = ACTIONS(457),
    [anon_sym_BANG] = ACTIONS(459),
    [anon_sym_TILDE] = ACTIONS(459),
    [anon_sym_typeof] = ACTIONS(457),
    [anon_sym_void] = ACTIONS(457),
    [anon_sym_delete] = ACTIONS(457),
    [anon_sym_PLUS_PLUS] = ACTIONS(461),
    [anon_sym_DASH_DASH] = ACTIONS(461),
    [anon_sym_DQUOTE] = ACTIONS(361),
    [anon_sym_SQUOTE] = ACTIONS(363),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(365),
    [sym_number] = ACTIONS(367),
    [sym_this] = ACTIONS(369),
    [sym_super] = ACTIONS(369),
    [sym_true] = ACTIONS(369),
    [sym_false] = ACTIONS(369),
    [sym_null] = ACTIONS(369),
    [sym_undefined] = ACTIONS(463),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(445),
    [anon_sym_get] = ACTIONS(445),
    [anon_sym_set] = ACTIONS(445),
  },
  [232] = {
    [sym_import] = STATE(575),
    [sym_parenthesized_expression] = STATE(430),
    [sym_expression] = STATE(768),
    [sym_primary_expression] = STATE(576),
    [sym_yield_expression] = STATE(577),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1497),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1497),
    [sym_jsx_element] = STATE(577),
    [sym_jsx_fragment] = STATE(577),
    [sym_jsx_opening_element] = STATE(975),
    [sym_jsx_self_closing_element] = STATE(577),
    [sym_class] = STATE(575),
    [sym_function] = STATE(575),
    [sym_generator_function] = STATE(575),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(577),
    [sym_await_expression] = STATE(577),
    [sym_member_expression] = STATE(430),
    [sym_subscript_expression] = STATE(430),
    [sym_assignment_expression] = STATE(577),
    [sym__augmented_assignment_lhs] = STATE(937),
    [sym_augmented_assignment_expression] = STATE(577),
    [sym__destructuring_pattern] = STATE(1497),
    [sym_ternary_expression] = STATE(577),
    [sym_binary_expression] = STATE(577),
    [sym_unary_expression] = STATE(577),
    [sym_update_expression] = STATE(577),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1533),
    [aux_sym_export_statement_repeat1] = STATE(1182),
    [sym_identifier] = ACTIONS(443),
    [anon_sym_export] = ACTIONS(445),
    [anon_sym_LBRACE] = ACTIONS(421),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(449),
    [anon_sym_yield] = ACTIONS(451),
    [anon_sym_LBRACK] = ACTIONS(427),
    [anon_sym_LT] = ACTIONS(585),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(453),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(455),
    [anon_sym_PLUS] = ACTIONS(457),
    [anon_sym_DASH] = ACTIONS(457),
    [anon_sym_BANG] = ACTIONS(459),
    [anon_sym_TILDE] = ACTIONS(459),
    [anon_sym_typeof] = ACTIONS(457),
    [anon_sym_void] = ACTIONS(457),
    [anon_sym_delete] = ACTIONS(457),
    [anon_sym_PLUS_PLUS] = ACTIONS(461),
    [anon_sym_DASH_DASH] = ACTIONS(461),
    [anon_sym_DQUOTE] = ACTIONS(361),
    [anon_sym_SQUOTE] = ACTIONS(363),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(365),
    [sym_number] = ACTIONS(367),
    [sym_this] = ACTIONS(369),
    [sym_super] = ACTIONS(369),
    [sym_true] = ACTIONS(369),
    [sym_false] = ACTIONS(369),
    [sym_null] = ACTIONS(369),
    [sym_undefined] = ACTIONS(463),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(445),
    [anon_sym_get] = ACTIONS(445),
    [anon_sym_set] = ACTIONS(445),
  },
  [233] = {
    [sym_import] = STATE(721),
    [sym_parenthesized_expression] = STATE(466),
    [sym_expression] = STATE(641),
    [sym_primary_expression] = STATE(743),
    [sym_yield_expression] = STATE(740),
    [sym_object] = STATE(721),
    [sym_object_pattern] = STATE(1486),
    [sym_array] = STATE(721),
    [sym_array_pattern] = STATE(1486),
    [sym_jsx_element] = STATE(740),
    [sym_jsx_fragment] = STATE(740),
    [sym_jsx_opening_element] = STATE(972),
    [sym_jsx_self_closing_element] = STATE(740),
    [sym_class] = STATE(721),
    [sym_function] = STATE(721),
    [sym_generator_function] = STATE(721),
    [sym_arrow_function] = STATE(721),
    [sym_call_expression] = STATE(721),
    [sym_new_expression] = STATE(740),
    [sym_await_expression] = STATE(740),
    [sym_member_expression] = STATE(466),
    [sym_subscript_expression] = STATE(466),
    [sym_assignment_expression] = STATE(740),
    [sym__augmented_assignment_lhs] = STATE(940),
    [sym_augmented_assignment_expression] = STATE(740),
    [sym__destructuring_pattern] = STATE(1486),
    [sym_ternary_expression] = STATE(740),
    [sym_binary_expression] = STATE(740),
    [sym_unary_expression] = STATE(740),
    [sym_update_expression] = STATE(740),
    [sym_string] = STATE(721),
    [sym_template_string] = STATE(721),
    [sym_regex] = STATE(721),
    [sym_meta_property] = STATE(721),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1487),
    [aux_sym_export_statement_repeat1] = STATE(1154),
    [sym_identifier] = ACTIONS(373),
    [anon_sym_export] = ACTIONS(375),
    [anon_sym_LBRACE] = ACTIONS(379),
    [anon_sym_import] = ACTIONS(381),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(383),
    [anon_sym_yield] = ACTIONS(385),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(389),
    [anon_sym_class] = ACTIONS(391),
    [anon_sym_async] = ACTIONS(393),
    [anon_sym_function] = ACTIONS(395),
    [anon_sym_new] = ACTIONS(397),
    [anon_sym_PLUS] = ACTIONS(399),
    [anon_sym_DASH] = ACTIONS(399),
    [anon_sym_BANG] = ACTIONS(401),
    [anon_sym_TILDE] = ACTIONS(401),
    [anon_sym_typeof] = ACTIONS(399),
    [anon_sym_void] = ACTIONS(399),
    [anon_sym_delete] = ACTIONS(399),
    [anon_sym_PLUS_PLUS] = ACTIONS(403),
    [anon_sym_DASH_DASH] = ACTIONS(403),
    [anon_sym_DQUOTE] = ACTIONS(73),
    [anon_sym_SQUOTE] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(77),
    [sym_number] = ACTIONS(79),
    [sym_this] = ACTIONS(81),
    [sym_super] = ACTIONS(81),
    [sym_true] = ACTIONS(81),
    [sym_false] = ACTIONS(81),
    [sym_null] = ACTIONS(81),
    [sym_undefined] = ACTIONS(405),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(375),
    [anon_sym_get] = ACTIONS(375),
    [anon_sym_set] = ACTIONS(375),
  },
  [234] = {
    [sym_import] = STATE(575),
    [sym_parenthesized_expression] = STATE(430),
    [sym_expression] = STATE(795),
    [sym_primary_expression] = STATE(576),
    [sym_yield_expression] = STATE(577),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1497),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1497),
    [sym_jsx_element] = STATE(577),
    [sym_jsx_fragment] = STATE(577),
    [sym_jsx_opening_element] = STATE(975),
    [sym_jsx_self_closing_element] = STATE(577),
    [sym_class] = STATE(575),
    [sym_function] = STATE(575),
    [sym_generator_function] = STATE(575),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(577),
    [sym_await_expression] = STATE(577),
    [sym_member_expression] = STATE(430),
    [sym_subscript_expression] = STATE(430),
    [sym_assignment_expression] = STATE(577),
    [sym__augmented_assignment_lhs] = STATE(937),
    [sym_augmented_assignment_expression] = STATE(577),
    [sym__destructuring_pattern] = STATE(1497),
    [sym_ternary_expression] = STATE(577),
    [sym_binary_expression] = STATE(577),
    [sym_unary_expression] = STATE(577),
    [sym_update_expression] = STATE(577),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1533),
    [aux_sym_export_statement_repeat1] = STATE(1182),
    [sym_identifier] = ACTIONS(443),
    [anon_sym_export] = ACTIONS(445),
    [anon_sym_LBRACE] = ACTIONS(421),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(449),
    [anon_sym_yield] = ACTIONS(451),
    [anon_sym_LBRACK] = ACTIONS(427),
    [anon_sym_LT] = ACTIONS(585),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(453),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(455),
    [anon_sym_PLUS] = ACTIONS(457),
    [anon_sym_DASH] = ACTIONS(457),
    [anon_sym_BANG] = ACTIONS(459),
    [anon_sym_TILDE] = ACTIONS(459),
    [anon_sym_typeof] = ACTIONS(457),
    [anon_sym_void] = ACTIONS(457),
    [anon_sym_delete] = ACTIONS(457),
    [anon_sym_PLUS_PLUS] = ACTIONS(461),
    [anon_sym_DASH_DASH] = ACTIONS(461),
    [anon_sym_DQUOTE] = ACTIONS(361),
    [anon_sym_SQUOTE] = ACTIONS(363),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(365),
    [sym_number] = ACTIONS(367),
    [sym_this] = ACTIONS(369),
    [sym_super] = ACTIONS(369),
    [sym_true] = ACTIONS(369),
    [sym_false] = ACTIONS(369),
    [sym_null] = ACTIONS(369),
    [sym_undefined] = ACTIONS(463),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(445),
    [anon_sym_get] = ACTIONS(445),
    [anon_sym_set] = ACTIONS(445),
  },
  [235] = {
    [sym_import] = STATE(721),
    [sym_parenthesized_expression] = STATE(479),
    [sym_expression] = STATE(742),
    [sym_primary_expression] = STATE(743),
    [sym_yield_expression] = STATE(740),
    [sym_object] = STATE(721),
    [sym_object_pattern] = STATE(1548),
    [sym_array] = STATE(721),
    [sym_array_pattern] = STATE(1548),
    [sym_jsx_element] = STATE(740),
    [sym_jsx_fragment] = STATE(740),
    [sym_jsx_opening_element] = STATE(972),
    [sym_jsx_self_closing_element] = STATE(740),
    [sym_class] = STATE(721),
    [sym_function] = STATE(721),
    [sym_generator_function] = STATE(721),
    [sym_arrow_function] = STATE(721),
    [sym_call_expression] = STATE(721),
    [sym_new_expression] = STATE(740),
    [sym_await_expression] = STATE(740),
    [sym_member_expression] = STATE(479),
    [sym_subscript_expression] = STATE(479),
    [sym_assignment_expression] = STATE(740),
    [sym__augmented_assignment_lhs] = STATE(942),
    [sym_augmented_assignment_expression] = STATE(740),
    [sym__destructuring_pattern] = STATE(1548),
    [sym_ternary_expression] = STATE(740),
    [sym_binary_expression] = STATE(740),
    [sym_unary_expression] = STATE(740),
    [sym_update_expression] = STATE(740),
    [sym_string] = STATE(721),
    [sym_template_string] = STATE(721),
    [sym_regex] = STATE(721),
    [sym_meta_property] = STATE(721),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1546),
    [aux_sym_export_statement_repeat1] = STATE(1154),
    [sym_identifier] = ACTIONS(407),
    [anon_sym_export] = ACTIONS(409),
    [anon_sym_LBRACE] = ACTIONS(379),
    [anon_sym_import] = ACTIONS(381),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(391),
    [anon_sym_async] = ACTIONS(413),
    [anon_sym_function] = ACTIONS(395),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(67),
    [anon_sym_void] = ACTIONS(67),
    [anon_sym_delete] = ACTIONS(67),
    [anon_sym_PLUS_PLUS] = ACTIONS(71),
    [anon_sym_DASH_DASH] = ACTIONS(71),
    [anon_sym_DQUOTE] = ACTIONS(73),
    [anon_sym_SQUOTE] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(77),
    [sym_number] = ACTIONS(79),
    [sym_this] = ACTIONS(81),
    [sym_super] = ACTIONS(81),
    [sym_true] = ACTIONS(81),
    [sym_false] = ACTIONS(81),
    [sym_null] = ACTIONS(81),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(409),
    [anon_sym_get] = ACTIONS(409),
    [anon_sym_set] = ACTIONS(409),
  },
  [236] = {
    [sym_import] = STATE(721),
    [sym_parenthesized_expression] = STATE(466),
    [sym_expression] = STATE(640),
    [sym_primary_expression] = STATE(743),
    [sym_yield_expression] = STATE(740),
    [sym_object] = STATE(721),
    [sym_object_pattern] = STATE(1486),
    [sym_array] = STATE(721),
    [sym_array_pattern] = STATE(1486),
    [sym_jsx_element] = STATE(740),
    [sym_jsx_fragment] = STATE(740),
    [sym_jsx_opening_element] = STATE(972),
    [sym_jsx_self_closing_element] = STATE(740),
    [sym_class] = STATE(721),
    [sym_function] = STATE(721),
    [sym_generator_function] = STATE(721),
    [sym_arrow_function] = STATE(721),
    [sym_call_expression] = STATE(721),
    [sym_new_expression] = STATE(740),
    [sym_await_expression] = STATE(740),
    [sym_member_expression] = STATE(466),
    [sym_subscript_expression] = STATE(466),
    [sym_assignment_expression] = STATE(740),
    [sym__augmented_assignment_lhs] = STATE(940),
    [sym_augmented_assignment_expression] = STATE(740),
    [sym__destructuring_pattern] = STATE(1486),
    [sym_ternary_expression] = STATE(740),
    [sym_binary_expression] = STATE(740),
    [sym_unary_expression] = STATE(740),
    [sym_update_expression] = STATE(740),
    [sym_string] = STATE(721),
    [sym_template_string] = STATE(721),
    [sym_regex] = STATE(721),
    [sym_meta_property] = STATE(721),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1487),
    [aux_sym_export_statement_repeat1] = STATE(1154),
    [sym_identifier] = ACTIONS(373),
    [anon_sym_export] = ACTIONS(375),
    [anon_sym_LBRACE] = ACTIONS(379),
    [anon_sym_import] = ACTIONS(381),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(383),
    [anon_sym_yield] = ACTIONS(385),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(389),
    [anon_sym_class] = ACTIONS(391),
    [anon_sym_async] = ACTIONS(393),
    [anon_sym_function] = ACTIONS(395),
    [anon_sym_new] = ACTIONS(397),
    [anon_sym_PLUS] = ACTIONS(399),
    [anon_sym_DASH] = ACTIONS(399),
    [anon_sym_BANG] = ACTIONS(401),
    [anon_sym_TILDE] = ACTIONS(401),
    [anon_sym_typeof] = ACTIONS(399),
    [anon_sym_void] = ACTIONS(399),
    [anon_sym_delete] = ACTIONS(399),
    [anon_sym_PLUS_PLUS] = ACTIONS(403),
    [anon_sym_DASH_DASH] = ACTIONS(403),
    [anon_sym_DQUOTE] = ACTIONS(73),
    [anon_sym_SQUOTE] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(77),
    [sym_number] = ACTIONS(79),
    [sym_this] = ACTIONS(81),
    [sym_super] = ACTIONS(81),
    [sym_true] = ACTIONS(81),
    [sym_false] = ACTIONS(81),
    [sym_null] = ACTIONS(81),
    [sym_undefined] = ACTIONS(405),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(375),
    [anon_sym_get] = ACTIONS(375),
    [anon_sym_set] = ACTIONS(375),
  },
  [237] = {
    [sym_import] = STATE(721),
    [sym_parenthesized_expression] = STATE(466),
    [sym_expression] = STATE(639),
    [sym_primary_expression] = STATE(743),
    [sym_yield_expression] = STATE(740),
    [sym_object] = STATE(721),
    [sym_object_pattern] = STATE(1486),
    [sym_array] = STATE(721),
    [sym_array_pattern] = STATE(1486),
    [sym_jsx_element] = STATE(740),
    [sym_jsx_fragment] = STATE(740),
    [sym_jsx_opening_element] = STATE(972),
    [sym_jsx_self_closing_element] = STATE(740),
    [sym_class] = STATE(721),
    [sym_function] = STATE(721),
    [sym_generator_function] = STATE(721),
    [sym_arrow_function] = STATE(721),
    [sym_call_expression] = STATE(721),
    [sym_new_expression] = STATE(740),
    [sym_await_expression] = STATE(740),
    [sym_member_expression] = STATE(466),
    [sym_subscript_expression] = STATE(466),
    [sym_assignment_expression] = STATE(740),
    [sym__augmented_assignment_lhs] = STATE(940),
    [sym_augmented_assignment_expression] = STATE(740),
    [sym__destructuring_pattern] = STATE(1486),
    [sym_ternary_expression] = STATE(740),
    [sym_binary_expression] = STATE(740),
    [sym_unary_expression] = STATE(740),
    [sym_update_expression] = STATE(740),
    [sym_string] = STATE(721),
    [sym_template_string] = STATE(721),
    [sym_regex] = STATE(721),
    [sym_meta_property] = STATE(721),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1487),
    [aux_sym_export_statement_repeat1] = STATE(1154),
    [sym_identifier] = ACTIONS(373),
    [anon_sym_export] = ACTIONS(375),
    [anon_sym_LBRACE] = ACTIONS(379),
    [anon_sym_import] = ACTIONS(381),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(383),
    [anon_sym_yield] = ACTIONS(385),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(389),
    [anon_sym_class] = ACTIONS(391),
    [anon_sym_async] = ACTIONS(393),
    [anon_sym_function] = ACTIONS(395),
    [anon_sym_new] = ACTIONS(397),
    [anon_sym_PLUS] = ACTIONS(399),
    [anon_sym_DASH] = ACTIONS(399),
    [anon_sym_BANG] = ACTIONS(401),
    [anon_sym_TILDE] = ACTIONS(401),
    [anon_sym_typeof] = ACTIONS(399),
    [anon_sym_void] = ACTIONS(399),
    [anon_sym_delete] = ACTIONS(399),
    [anon_sym_PLUS_PLUS] = ACTIONS(403),
    [anon_sym_DASH_DASH] = ACTIONS(403),
    [anon_sym_DQUOTE] = ACTIONS(73),
    [anon_sym_SQUOTE] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(77),
    [sym_number] = ACTIONS(79),
    [sym_this] = ACTIONS(81),
    [sym_super] = ACTIONS(81),
    [sym_true] = ACTIONS(81),
    [sym_false] = ACTIONS(81),
    [sym_null] = ACTIONS(81),
    [sym_undefined] = ACTIONS(405),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(375),
    [anon_sym_get] = ACTIONS(375),
    [anon_sym_set] = ACTIONS(375),
  },
  [238] = {
    [sym_import] = STATE(575),
    [sym_parenthesized_expression] = STATE(430),
    [sym_expression] = STATE(496),
    [sym_primary_expression] = STATE(576),
    [sym_yield_expression] = STATE(577),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1497),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1497),
    [sym_jsx_element] = STATE(577),
    [sym_jsx_fragment] = STATE(577),
    [sym_jsx_opening_element] = STATE(975),
    [sym_jsx_self_closing_element] = STATE(577),
    [sym_class] = STATE(575),
    [sym_function] = STATE(575),
    [sym_generator_function] = STATE(575),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(577),
    [sym_await_expression] = STATE(577),
    [sym_member_expression] = STATE(430),
    [sym_subscript_expression] = STATE(430),
    [sym_assignment_expression] = STATE(577),
    [sym__augmented_assignment_lhs] = STATE(937),
    [sym_augmented_assignment_expression] = STATE(577),
    [sym__destructuring_pattern] = STATE(1497),
    [sym_ternary_expression] = STATE(577),
    [sym_binary_expression] = STATE(577),
    [sym_unary_expression] = STATE(577),
    [sym_update_expression] = STATE(577),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1533),
    [aux_sym_export_statement_repeat1] = STATE(1182),
    [sym_identifier] = ACTIONS(443),
    [anon_sym_export] = ACTIONS(445),
    [anon_sym_LBRACE] = ACTIONS(421),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(449),
    [anon_sym_yield] = ACTIONS(451),
    [anon_sym_LBRACK] = ACTIONS(427),
    [anon_sym_LT] = ACTIONS(585),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(453),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(455),
    [anon_sym_PLUS] = ACTIONS(457),
    [anon_sym_DASH] = ACTIONS(457),
    [anon_sym_BANG] = ACTIONS(459),
    [anon_sym_TILDE] = ACTIONS(459),
    [anon_sym_typeof] = ACTIONS(457),
    [anon_sym_void] = ACTIONS(457),
    [anon_sym_delete] = ACTIONS(457),
    [anon_sym_PLUS_PLUS] = ACTIONS(461),
    [anon_sym_DASH_DASH] = ACTIONS(461),
    [anon_sym_DQUOTE] = ACTIONS(361),
    [anon_sym_SQUOTE] = ACTIONS(363),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(365),
    [sym_number] = ACTIONS(367),
    [sym_this] = ACTIONS(369),
    [sym_super] = ACTIONS(369),
    [sym_true] = ACTIONS(369),
    [sym_false] = ACTIONS(369),
    [sym_null] = ACTIONS(369),
    [sym_undefined] = ACTIONS(463),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(445),
    [anon_sym_get] = ACTIONS(445),
    [anon_sym_set] = ACTIONS(445),
  },
  [239] = {
    [sym_import] = STATE(575),
    [sym_parenthesized_expression] = STATE(430),
    [sym_expression] = STATE(495),
    [sym_primary_expression] = STATE(576),
    [sym_yield_expression] = STATE(577),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1497),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1497),
    [sym_jsx_element] = STATE(577),
    [sym_jsx_fragment] = STATE(577),
    [sym_jsx_opening_element] = STATE(975),
    [sym_jsx_self_closing_element] = STATE(577),
    [sym_class] = STATE(575),
    [sym_function] = STATE(575),
    [sym_generator_function] = STATE(575),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(577),
    [sym_await_expression] = STATE(577),
    [sym_member_expression] = STATE(430),
    [sym_subscript_expression] = STATE(430),
    [sym_assignment_expression] = STATE(577),
    [sym__augmented_assignment_lhs] = STATE(937),
    [sym_augmented_assignment_expression] = STATE(577),
    [sym__destructuring_pattern] = STATE(1497),
    [sym_ternary_expression] = STATE(577),
    [sym_binary_expression] = STATE(577),
    [sym_unary_expression] = STATE(577),
    [sym_update_expression] = STATE(577),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1533),
    [aux_sym_export_statement_repeat1] = STATE(1182),
    [sym_identifier] = ACTIONS(443),
    [anon_sym_export] = ACTIONS(445),
    [anon_sym_LBRACE] = ACTIONS(421),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(449),
    [anon_sym_yield] = ACTIONS(451),
    [anon_sym_LBRACK] = ACTIONS(427),
    [anon_sym_LT] = ACTIONS(585),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(453),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(455),
    [anon_sym_PLUS] = ACTIONS(457),
    [anon_sym_DASH] = ACTIONS(457),
    [anon_sym_BANG] = ACTIONS(459),
    [anon_sym_TILDE] = ACTIONS(459),
    [anon_sym_typeof] = ACTIONS(457),
    [anon_sym_void] = ACTIONS(457),
    [anon_sym_delete] = ACTIONS(457),
    [anon_sym_PLUS_PLUS] = ACTIONS(461),
    [anon_sym_DASH_DASH] = ACTIONS(461),
    [anon_sym_DQUOTE] = ACTIONS(361),
    [anon_sym_SQUOTE] = ACTIONS(363),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(365),
    [sym_number] = ACTIONS(367),
    [sym_this] = ACTIONS(369),
    [sym_super] = ACTIONS(369),
    [sym_true] = ACTIONS(369),
    [sym_false] = ACTIONS(369),
    [sym_null] = ACTIONS(369),
    [sym_undefined] = ACTIONS(463),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(445),
    [anon_sym_get] = ACTIONS(445),
    [anon_sym_set] = ACTIONS(445),
  },
  [240] = {
    [sym_import] = STATE(721),
    [sym_parenthesized_expression] = STATE(466),
    [sym_expression] = STATE(638),
    [sym_primary_expression] = STATE(743),
    [sym_yield_expression] = STATE(740),
    [sym_object] = STATE(721),
    [sym_object_pattern] = STATE(1486),
    [sym_array] = STATE(721),
    [sym_array_pattern] = STATE(1486),
    [sym_jsx_element] = STATE(740),
    [sym_jsx_fragment] = STATE(740),
    [sym_jsx_opening_element] = STATE(972),
    [sym_jsx_self_closing_element] = STATE(740),
    [sym_class] = STATE(721),
    [sym_function] = STATE(721),
    [sym_generator_function] = STATE(721),
    [sym_arrow_function] = STATE(721),
    [sym_call_expression] = STATE(721),
    [sym_new_expression] = STATE(740),
    [sym_await_expression] = STATE(740),
    [sym_member_expression] = STATE(466),
    [sym_subscript_expression] = STATE(466),
    [sym_assignment_expression] = STATE(740),
    [sym__augmented_assignment_lhs] = STATE(940),
    [sym_augmented_assignment_expression] = STATE(740),
    [sym__destructuring_pattern] = STATE(1486),
    [sym_ternary_expression] = STATE(740),
    [sym_binary_expression] = STATE(740),
    [sym_unary_expression] = STATE(740),
    [sym_update_expression] = STATE(740),
    [sym_string] = STATE(721),
    [sym_template_string] = STATE(721),
    [sym_regex] = STATE(721),
    [sym_meta_property] = STATE(721),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1487),
    [aux_sym_export_statement_repeat1] = STATE(1154),
    [sym_identifier] = ACTIONS(373),
    [anon_sym_export] = ACTIONS(375),
    [anon_sym_LBRACE] = ACTIONS(379),
    [anon_sym_import] = ACTIONS(381),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(383),
    [anon_sym_yield] = ACTIONS(385),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(389),
    [anon_sym_class] = ACTIONS(391),
    [anon_sym_async] = ACTIONS(393),
    [anon_sym_function] = ACTIONS(395),
    [anon_sym_new] = ACTIONS(397),
    [anon_sym_PLUS] = ACTIONS(399),
    [anon_sym_DASH] = ACTIONS(399),
    [anon_sym_BANG] = ACTIONS(401),
    [anon_sym_TILDE] = ACTIONS(401),
    [anon_sym_typeof] = ACTIONS(399),
    [anon_sym_void] = ACTIONS(399),
    [anon_sym_delete] = ACTIONS(399),
    [anon_sym_PLUS_PLUS] = ACTIONS(403),
    [anon_sym_DASH_DASH] = ACTIONS(403),
    [anon_sym_DQUOTE] = ACTIONS(73),
    [anon_sym_SQUOTE] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(77),
    [sym_number] = ACTIONS(79),
    [sym_this] = ACTIONS(81),
    [sym_super] = ACTIONS(81),
    [sym_true] = ACTIONS(81),
    [sym_false] = ACTIONS(81),
    [sym_null] = ACTIONS(81),
    [sym_undefined] = ACTIONS(405),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(375),
    [anon_sym_get] = ACTIONS(375),
    [anon_sym_set] = ACTIONS(375),
  },
  [241] = {
    [sym_import] = STATE(721),
    [sym_parenthesized_expression] = STATE(466),
    [sym_expression] = STATE(634),
    [sym_primary_expression] = STATE(743),
    [sym_yield_expression] = STATE(740),
    [sym_object] = STATE(721),
    [sym_object_pattern] = STATE(1486),
    [sym_array] = STATE(721),
    [sym_array_pattern] = STATE(1486),
    [sym_jsx_element] = STATE(740),
    [sym_jsx_fragment] = STATE(740),
    [sym_jsx_opening_element] = STATE(972),
    [sym_jsx_self_closing_element] = STATE(740),
    [sym_class] = STATE(721),
    [sym_function] = STATE(721),
    [sym_generator_function] = STATE(721),
    [sym_arrow_function] = STATE(721),
    [sym_call_expression] = STATE(721),
    [sym_new_expression] = STATE(740),
    [sym_await_expression] = STATE(740),
    [sym_member_expression] = STATE(466),
    [sym_subscript_expression] = STATE(466),
    [sym_assignment_expression] = STATE(740),
    [sym__augmented_assignment_lhs] = STATE(940),
    [sym_augmented_assignment_expression] = STATE(740),
    [sym__destructuring_pattern] = STATE(1486),
    [sym_ternary_expression] = STATE(740),
    [sym_binary_expression] = STATE(740),
    [sym_unary_expression] = STATE(740),
    [sym_update_expression] = STATE(740),
    [sym_string] = STATE(721),
    [sym_template_string] = STATE(721),
    [sym_regex] = STATE(721),
    [sym_meta_property] = STATE(721),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1487),
    [aux_sym_export_statement_repeat1] = STATE(1154),
    [sym_identifier] = ACTIONS(373),
    [anon_sym_export] = ACTIONS(375),
    [anon_sym_LBRACE] = ACTIONS(379),
    [anon_sym_import] = ACTIONS(381),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(383),
    [anon_sym_yield] = ACTIONS(385),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(389),
    [anon_sym_class] = ACTIONS(391),
    [anon_sym_async] = ACTIONS(393),
    [anon_sym_function] = ACTIONS(395),
    [anon_sym_new] = ACTIONS(397),
    [anon_sym_PLUS] = ACTIONS(399),
    [anon_sym_DASH] = ACTIONS(399),
    [anon_sym_BANG] = ACTIONS(401),
    [anon_sym_TILDE] = ACTIONS(401),
    [anon_sym_typeof] = ACTIONS(399),
    [anon_sym_void] = ACTIONS(399),
    [anon_sym_delete] = ACTIONS(399),
    [anon_sym_PLUS_PLUS] = ACTIONS(403),
    [anon_sym_DASH_DASH] = ACTIONS(403),
    [anon_sym_DQUOTE] = ACTIONS(73),
    [anon_sym_SQUOTE] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(77),
    [sym_number] = ACTIONS(79),
    [sym_this] = ACTIONS(81),
    [sym_super] = ACTIONS(81),
    [sym_true] = ACTIONS(81),
    [sym_false] = ACTIONS(81),
    [sym_null] = ACTIONS(81),
    [sym_undefined] = ACTIONS(405),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(375),
    [anon_sym_get] = ACTIONS(375),
    [anon_sym_set] = ACTIONS(375),
  },
  [242] = {
    [sym_import] = STATE(721),
    [sym_parenthesized_expression] = STATE(466),
    [sym_expression] = STATE(633),
    [sym_primary_expression] = STATE(743),
    [sym_yield_expression] = STATE(740),
    [sym_object] = STATE(721),
    [sym_object_pattern] = STATE(1486),
    [sym_array] = STATE(721),
    [sym_array_pattern] = STATE(1486),
    [sym_jsx_element] = STATE(740),
    [sym_jsx_fragment] = STATE(740),
    [sym_jsx_opening_element] = STATE(972),
    [sym_jsx_self_closing_element] = STATE(740),
    [sym_class] = STATE(721),
    [sym_function] = STATE(721),
    [sym_generator_function] = STATE(721),
    [sym_arrow_function] = STATE(721),
    [sym_call_expression] = STATE(721),
    [sym_new_expression] = STATE(740),
    [sym_await_expression] = STATE(740),
    [sym_member_expression] = STATE(466),
    [sym_subscript_expression] = STATE(466),
    [sym_assignment_expression] = STATE(740),
    [sym__augmented_assignment_lhs] = STATE(940),
    [sym_augmented_assignment_expression] = STATE(740),
    [sym__destructuring_pattern] = STATE(1486),
    [sym_ternary_expression] = STATE(740),
    [sym_binary_expression] = STATE(740),
    [sym_unary_expression] = STATE(740),
    [sym_update_expression] = STATE(740),
    [sym_string] = STATE(721),
    [sym_template_string] = STATE(721),
    [sym_regex] = STATE(721),
    [sym_meta_property] = STATE(721),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1487),
    [aux_sym_export_statement_repeat1] = STATE(1154),
    [sym_identifier] = ACTIONS(373),
    [anon_sym_export] = ACTIONS(375),
    [anon_sym_LBRACE] = ACTIONS(379),
    [anon_sym_import] = ACTIONS(381),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(383),
    [anon_sym_yield] = ACTIONS(385),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(389),
    [anon_sym_class] = ACTIONS(391),
    [anon_sym_async] = ACTIONS(393),
    [anon_sym_function] = ACTIONS(395),
    [anon_sym_new] = ACTIONS(397),
    [anon_sym_PLUS] = ACTIONS(399),
    [anon_sym_DASH] = ACTIONS(399),
    [anon_sym_BANG] = ACTIONS(401),
    [anon_sym_TILDE] = ACTIONS(401),
    [anon_sym_typeof] = ACTIONS(399),
    [anon_sym_void] = ACTIONS(399),
    [anon_sym_delete] = ACTIONS(399),
    [anon_sym_PLUS_PLUS] = ACTIONS(403),
    [anon_sym_DASH_DASH] = ACTIONS(403),
    [anon_sym_DQUOTE] = ACTIONS(73),
    [anon_sym_SQUOTE] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(77),
    [sym_number] = ACTIONS(79),
    [sym_this] = ACTIONS(81),
    [sym_super] = ACTIONS(81),
    [sym_true] = ACTIONS(81),
    [sym_false] = ACTIONS(81),
    [sym_null] = ACTIONS(81),
    [sym_undefined] = ACTIONS(405),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(375),
    [anon_sym_get] = ACTIONS(375),
    [anon_sym_set] = ACTIONS(375),
  },
  [243] = {
    [sym_import] = STATE(721),
    [sym_parenthesized_expression] = STATE(479),
    [sym_expression] = STATE(628),
    [sym_primary_expression] = STATE(743),
    [sym_yield_expression] = STATE(740),
    [sym_object] = STATE(721),
    [sym_object_pattern] = STATE(1548),
    [sym_array] = STATE(721),
    [sym_array_pattern] = STATE(1548),
    [sym_jsx_element] = STATE(740),
    [sym_jsx_fragment] = STATE(740),
    [sym_jsx_opening_element] = STATE(972),
    [sym_jsx_self_closing_element] = STATE(740),
    [sym_class] = STATE(721),
    [sym_function] = STATE(721),
    [sym_generator_function] = STATE(721),
    [sym_arrow_function] = STATE(721),
    [sym_call_expression] = STATE(721),
    [sym_new_expression] = STATE(740),
    [sym_await_expression] = STATE(740),
    [sym_member_expression] = STATE(479),
    [sym_subscript_expression] = STATE(479),
    [sym_assignment_expression] = STATE(740),
    [sym__augmented_assignment_lhs] = STATE(942),
    [sym_augmented_assignment_expression] = STATE(740),
    [sym__destructuring_pattern] = STATE(1548),
    [sym_ternary_expression] = STATE(740),
    [sym_binary_expression] = STATE(740),
    [sym_unary_expression] = STATE(740),
    [sym_update_expression] = STATE(740),
    [sym_string] = STATE(721),
    [sym_template_string] = STATE(721),
    [sym_regex] = STATE(721),
    [sym_meta_property] = STATE(721),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1546),
    [aux_sym_export_statement_repeat1] = STATE(1154),
    [sym_identifier] = ACTIONS(407),
    [anon_sym_export] = ACTIONS(409),
    [anon_sym_LBRACE] = ACTIONS(379),
    [anon_sym_import] = ACTIONS(381),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(391),
    [anon_sym_async] = ACTIONS(413),
    [anon_sym_function] = ACTIONS(395),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(67),
    [anon_sym_void] = ACTIONS(67),
    [anon_sym_delete] = ACTIONS(67),
    [anon_sym_PLUS_PLUS] = ACTIONS(71),
    [anon_sym_DASH_DASH] = ACTIONS(71),
    [anon_sym_DQUOTE] = ACTIONS(73),
    [anon_sym_SQUOTE] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(77),
    [sym_number] = ACTIONS(79),
    [sym_this] = ACTIONS(81),
    [sym_super] = ACTIONS(81),
    [sym_true] = ACTIONS(81),
    [sym_false] = ACTIONS(81),
    [sym_null] = ACTIONS(81),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(409),
    [anon_sym_get] = ACTIONS(409),
    [anon_sym_set] = ACTIONS(409),
  },
  [244] = {
    [sym_import] = STATE(575),
    [sym_parenthesized_expression] = STATE(449),
    [sym_expression] = STATE(536),
    [sym_primary_expression] = STATE(576),
    [sym_yield_expression] = STATE(577),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1528),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1528),
    [sym_jsx_element] = STATE(577),
    [sym_jsx_fragment] = STATE(577),
    [sym_jsx_opening_element] = STATE(975),
    [sym_jsx_self_closing_element] = STATE(577),
    [sym_class] = STATE(575),
    [sym_function] = STATE(575),
    [sym_generator_function] = STATE(575),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(577),
    [sym_await_expression] = STATE(577),
    [sym_member_expression] = STATE(449),
    [sym_subscript_expression] = STATE(449),
    [sym_assignment_expression] = STATE(577),
    [sym__augmented_assignment_lhs] = STATE(943),
    [sym_augmented_assignment_expression] = STATE(577),
    [sym__destructuring_pattern] = STATE(1528),
    [sym_ternary_expression] = STATE(577),
    [sym_binary_expression] = STATE(577),
    [sym_unary_expression] = STATE(577),
    [sym_update_expression] = STATE(577),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1496),
    [aux_sym_export_statement_repeat1] = STATE(1182),
    [sym_identifier] = ACTIONS(321),
    [anon_sym_export] = ACTIONS(323),
    [anon_sym_LBRACE] = ACTIONS(327),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(335),
    [anon_sym_yield] = ACTIONS(339),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LT] = ACTIONS(585),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(349),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(353),
    [anon_sym_PLUS] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(355),
    [anon_sym_BANG] = ACTIONS(357),
    [anon_sym_TILDE] = ACTIONS(357),
    [anon_sym_typeof] = ACTIONS(355),
    [anon_sym_void] = ACTIONS(355),
    [anon_sym_delete] = ACTIONS(355),
    [anon_sym_PLUS_PLUS] = ACTIONS(359),
    [anon_sym_DASH_DASH] = ACTIONS(359),
    [anon_sym_DQUOTE] = ACTIONS(361),
    [anon_sym_SQUOTE] = ACTIONS(363),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(365),
    [sym_number] = ACTIONS(367),
    [sym_this] = ACTIONS(369),
    [sym_super] = ACTIONS(369),
    [sym_true] = ACTIONS(369),
    [sym_false] = ACTIONS(369),
    [sym_null] = ACTIONS(369),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(323),
    [anon_sym_get] = ACTIONS(323),
    [anon_sym_set] = ACTIONS(323),
  },
  [245] = {
    [sym_import] = STATE(721),
    [sym_parenthesized_expression] = STATE(466),
    [sym_expression] = STATE(570),
    [sym_primary_expression] = STATE(743),
    [sym_yield_expression] = STATE(740),
    [sym_object] = STATE(721),
    [sym_object_pattern] = STATE(1486),
    [sym_array] = STATE(721),
    [sym_array_pattern] = STATE(1486),
    [sym_jsx_element] = STATE(740),
    [sym_jsx_fragment] = STATE(740),
    [sym_jsx_opening_element] = STATE(972),
    [sym_jsx_self_closing_element] = STATE(740),
    [sym_class] = STATE(721),
    [sym_function] = STATE(721),
    [sym_generator_function] = STATE(721),
    [sym_arrow_function] = STATE(721),
    [sym_call_expression] = STATE(721),
    [sym_new_expression] = STATE(740),
    [sym_await_expression] = STATE(740),
    [sym_member_expression] = STATE(466),
    [sym_subscript_expression] = STATE(466),
    [sym_assignment_expression] = STATE(740),
    [sym__augmented_assignment_lhs] = STATE(940),
    [sym_augmented_assignment_expression] = STATE(740),
    [sym__destructuring_pattern] = STATE(1486),
    [sym_ternary_expression] = STATE(740),
    [sym_binary_expression] = STATE(740),
    [sym_unary_expression] = STATE(740),
    [sym_update_expression] = STATE(740),
    [sym_string] = STATE(721),
    [sym_template_string] = STATE(721),
    [sym_regex] = STATE(721),
    [sym_meta_property] = STATE(721),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1487),
    [aux_sym_export_statement_repeat1] = STATE(1154),
    [sym_identifier] = ACTIONS(373),
    [anon_sym_export] = ACTIONS(375),
    [anon_sym_LBRACE] = ACTIONS(379),
    [anon_sym_import] = ACTIONS(381),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(383),
    [anon_sym_yield] = ACTIONS(385),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(389),
    [anon_sym_class] = ACTIONS(391),
    [anon_sym_async] = ACTIONS(393),
    [anon_sym_function] = ACTIONS(395),
    [anon_sym_new] = ACTIONS(397),
    [anon_sym_PLUS] = ACTIONS(399),
    [anon_sym_DASH] = ACTIONS(399),
    [anon_sym_BANG] = ACTIONS(401),
    [anon_sym_TILDE] = ACTIONS(401),
    [anon_sym_typeof] = ACTIONS(399),
    [anon_sym_void] = ACTIONS(399),
    [anon_sym_delete] = ACTIONS(399),
    [anon_sym_PLUS_PLUS] = ACTIONS(403),
    [anon_sym_DASH_DASH] = ACTIONS(403),
    [anon_sym_DQUOTE] = ACTIONS(73),
    [anon_sym_SQUOTE] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(77),
    [sym_number] = ACTIONS(79),
    [sym_this] = ACTIONS(81),
    [sym_super] = ACTIONS(81),
    [sym_true] = ACTIONS(81),
    [sym_false] = ACTIONS(81),
    [sym_null] = ACTIONS(81),
    [sym_undefined] = ACTIONS(405),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(375),
    [anon_sym_get] = ACTIONS(375),
    [anon_sym_set] = ACTIONS(375),
  },
  [246] = {
    [sym_import] = STATE(721),
    [sym_parenthesized_expression] = STATE(479),
    [sym_expression] = STATE(624),
    [sym_primary_expression] = STATE(743),
    [sym_yield_expression] = STATE(740),
    [sym_object] = STATE(721),
    [sym_object_pattern] = STATE(1548),
    [sym_array] = STATE(721),
    [sym_array_pattern] = STATE(1548),
    [sym_jsx_element] = STATE(740),
    [sym_jsx_fragment] = STATE(740),
    [sym_jsx_opening_element] = STATE(972),
    [sym_jsx_self_closing_element] = STATE(740),
    [sym_class] = STATE(721),
    [sym_function] = STATE(721),
    [sym_generator_function] = STATE(721),
    [sym_arrow_function] = STATE(721),
    [sym_call_expression] = STATE(721),
    [sym_new_expression] = STATE(740),
    [sym_await_expression] = STATE(740),
    [sym_member_expression] = STATE(479),
    [sym_subscript_expression] = STATE(479),
    [sym_assignment_expression] = STATE(740),
    [sym__augmented_assignment_lhs] = STATE(942),
    [sym_augmented_assignment_expression] = STATE(740),
    [sym__destructuring_pattern] = STATE(1548),
    [sym_ternary_expression] = STATE(740),
    [sym_binary_expression] = STATE(740),
    [sym_unary_expression] = STATE(740),
    [sym_update_expression] = STATE(740),
    [sym_string] = STATE(721),
    [sym_template_string] = STATE(721),
    [sym_regex] = STATE(721),
    [sym_meta_property] = STATE(721),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1546),
    [aux_sym_export_statement_repeat1] = STATE(1154),
    [sym_identifier] = ACTIONS(407),
    [anon_sym_export] = ACTIONS(409),
    [anon_sym_LBRACE] = ACTIONS(379),
    [anon_sym_import] = ACTIONS(381),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(391),
    [anon_sym_async] = ACTIONS(413),
    [anon_sym_function] = ACTIONS(395),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(67),
    [anon_sym_void] = ACTIONS(67),
    [anon_sym_delete] = ACTIONS(67),
    [anon_sym_PLUS_PLUS] = ACTIONS(71),
    [anon_sym_DASH_DASH] = ACTIONS(71),
    [anon_sym_DQUOTE] = ACTIONS(73),
    [anon_sym_SQUOTE] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(77),
    [sym_number] = ACTIONS(79),
    [sym_this] = ACTIONS(81),
    [sym_super] = ACTIONS(81),
    [sym_true] = ACTIONS(81),
    [sym_false] = ACTIONS(81),
    [sym_null] = ACTIONS(81),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(409),
    [anon_sym_get] = ACTIONS(409),
    [anon_sym_set] = ACTIONS(409),
  },
  [247] = {
    [sym_import] = STATE(575),
    [sym_parenthesized_expression] = STATE(449),
    [sym_expression] = STATE(800),
    [sym_primary_expression] = STATE(576),
    [sym_yield_expression] = STATE(577),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1528),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1528),
    [sym_jsx_element] = STATE(577),
    [sym_jsx_fragment] = STATE(577),
    [sym_jsx_opening_element] = STATE(975),
    [sym_jsx_self_closing_element] = STATE(577),
    [sym_class] = STATE(575),
    [sym_function] = STATE(575),
    [sym_generator_function] = STATE(575),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(577),
    [sym_await_expression] = STATE(577),
    [sym_member_expression] = STATE(449),
    [sym_subscript_expression] = STATE(449),
    [sym_assignment_expression] = STATE(577),
    [sym__augmented_assignment_lhs] = STATE(943),
    [sym_augmented_assignment_expression] = STATE(577),
    [sym__destructuring_pattern] = STATE(1528),
    [sym_ternary_expression] = STATE(577),
    [sym_binary_expression] = STATE(577),
    [sym_unary_expression] = STATE(577),
    [sym_update_expression] = STATE(577),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1496),
    [aux_sym_export_statement_repeat1] = STATE(1182),
    [sym_identifier] = ACTIONS(321),
    [anon_sym_export] = ACTIONS(323),
    [anon_sym_LBRACE] = ACTIONS(327),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(335),
    [anon_sym_yield] = ACTIONS(339),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LT] = ACTIONS(585),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(349),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(353),
    [anon_sym_PLUS] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(355),
    [anon_sym_BANG] = ACTIONS(357),
    [anon_sym_TILDE] = ACTIONS(357),
    [anon_sym_typeof] = ACTIONS(355),
    [anon_sym_void] = ACTIONS(355),
    [anon_sym_delete] = ACTIONS(355),
    [anon_sym_PLUS_PLUS] = ACTIONS(359),
    [anon_sym_DASH_DASH] = ACTIONS(359),
    [anon_sym_DQUOTE] = ACTIONS(361),
    [anon_sym_SQUOTE] = ACTIONS(363),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(365),
    [sym_number] = ACTIONS(367),
    [sym_this] = ACTIONS(369),
    [sym_super] = ACTIONS(369),
    [sym_true] = ACTIONS(369),
    [sym_false] = ACTIONS(369),
    [sym_null] = ACTIONS(369),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(323),
    [anon_sym_get] = ACTIONS(323),
    [anon_sym_set] = ACTIONS(323),
  },
  [248] = {
    [sym_import] = STATE(575),
    [sym_parenthesized_expression] = STATE(449),
    [sym_expression] = STATE(529),
    [sym_primary_expression] = STATE(576),
    [sym_yield_expression] = STATE(577),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1528),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1528),
    [sym_jsx_element] = STATE(577),
    [sym_jsx_fragment] = STATE(577),
    [sym_jsx_opening_element] = STATE(975),
    [sym_jsx_self_closing_element] = STATE(577),
    [sym_class] = STATE(575),
    [sym_function] = STATE(575),
    [sym_generator_function] = STATE(575),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(577),
    [sym_await_expression] = STATE(577),
    [sym_member_expression] = STATE(449),
    [sym_subscript_expression] = STATE(449),
    [sym_assignment_expression] = STATE(577),
    [sym__augmented_assignment_lhs] = STATE(943),
    [sym_augmented_assignment_expression] = STATE(577),
    [sym__destructuring_pattern] = STATE(1528),
    [sym_ternary_expression] = STATE(577),
    [sym_binary_expression] = STATE(577),
    [sym_unary_expression] = STATE(577),
    [sym_update_expression] = STATE(577),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1496),
    [aux_sym_export_statement_repeat1] = STATE(1182),
    [sym_identifier] = ACTIONS(321),
    [anon_sym_export] = ACTIONS(323),
    [anon_sym_LBRACE] = ACTIONS(327),
    [anon_sym_import] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_await] = ACTIONS(335),
    [anon_sym_yield] = ACTIONS(339),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_LT] = ACTIONS(585),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_class] = ACTIONS(347),
    [anon_sym_async] = ACTIONS(349),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_new] = ACTIONS(353),
    [anon_sym_PLUS] = ACTIONS(355),
    [anon_sym_DASH] = ACTIONS(355),
    [anon_sym_BANG] = ACTIONS(357),
    [anon_sym_TILDE] = ACTIONS(357),
    [anon_sym_typeof] = ACTIONS(355),
    [anon_sym_void] = ACTIONS(355),
    [anon_sym_delete] = ACTIONS(355),
    [anon_sym_PLUS_PLUS] = ACTIONS(359),
    [anon_sym_DASH_DASH] = ACTIONS(359),
    [anon_sym_DQUOTE] = ACTIONS(361),
    [anon_sym_SQUOTE] = ACTIONS(363),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(365),
    [sym_number] = ACTIONS(367),
    [sym_this] = ACTIONS(369),
    [sym_super] = ACTIONS(369),
    [sym_true] = ACTIONS(369),
    [sym_false] = ACTIONS(369),
    [sym_null] = ACTIONS(369),
    [sym_undefined] = ACTIONS(371),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(323),
    [anon_sym_get] = ACTIONS(323),
    [anon_sym_set] = ACTIONS(323),
  },
  [249] = {
    [sym_import] = STATE(721),
    [sym_parenthesized_expression] = STATE(466),
    [sym_expression] = STATE(632),
    [sym_primary_expression] = STATE(743),
    [sym_yield_expression] = STATE(740),
    [sym_object] = STATE(721),
    [sym_object_pattern] = STATE(1486),
    [sym_array] = STATE(721),
    [sym_array_pattern] = STATE(1486),
    [sym_jsx_element] = STATE(740),
    [sym_jsx_fragment] = STATE(740),
    [sym_jsx_opening_element] = STATE(972),
    [sym_jsx_self_closing_element] = STATE(740),
    [sym_class] = STATE(721),
    [sym_function] = STATE(721),
    [sym_generator_function] = STATE(721),
    [sym_arrow_function] = STATE(721),
    [sym_call_expression] = STATE(721),
    [sym_new_expression] = STATE(740),
    [sym_await_expression] = STATE(740),
    [sym_member_expression] = STATE(466),
    [sym_subscript_expression] = STATE(466),
    [sym_assignment_expression] = STATE(740),
    [sym__augmented_assignment_lhs] = STATE(940),
    [sym_augmented_assignment_expression] = STATE(740),
    [sym__destructuring_pattern] = STATE(1486),
    [sym_ternary_expression] = STATE(740),
    [sym_binary_expression] = STATE(740),
    [sym_unary_expression] = STATE(740),
    [sym_update_expression] = STATE(740),
    [sym_string] = STATE(721),
    [sym_template_string] = STATE(721),
    [sym_regex] = STATE(721),
    [sym_meta_property] = STATE(721),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1487),
    [aux_sym_export_statement_repeat1] = STATE(1154),
    [sym_identifier] = ACTIONS(373),
    [anon_sym_export] = ACTIONS(375),
    [anon_sym_LBRACE] = ACTIONS(379),
    [anon_sym_import] = ACTIONS(381),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(383),
    [anon_sym_yield] = ACTIONS(385),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(389),
    [anon_sym_class] = ACTIONS(391),
    [anon_sym_async] = ACTIONS(393),
    [anon_sym_function] = ACTIONS(395),
    [anon_sym_new] = ACTIONS(397),
    [anon_sym_PLUS] = ACTIONS(399),
    [anon_sym_DASH] = ACTIONS(399),
    [anon_sym_BANG] = ACTIONS(401),
    [anon_sym_TILDE] = ACTIONS(401),
    [anon_sym_typeof] = ACTIONS(399),
    [anon_sym_void] = ACTIONS(399),
    [anon_sym_delete] = ACTIONS(399),
    [anon_sym_PLUS_PLUS] = ACTIONS(403),
    [anon_sym_DASH_DASH] = ACTIONS(403),
    [anon_sym_DQUOTE] = ACTIONS(73),
    [anon_sym_SQUOTE] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(77),
    [sym_number] = ACTIONS(79),
    [sym_this] = ACTIONS(81),
    [sym_super] = ACTIONS(81),
    [sym_true] = ACTIONS(81),
    [sym_false] = ACTIONS(81),
    [sym_null] = ACTIONS(81),
    [sym_undefined] = ACTIONS(405),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(375),
    [anon_sym_get] = ACTIONS(375),
    [anon_sym_set] = ACTIONS(375),
  },
  [250] = {
    [sym_import] = STATE(721),
    [sym_parenthesized_expression] = STATE(479),
    [sym_expression] = STATE(642),
    [sym_primary_expression] = STATE(743),
    [sym_yield_expression] = STATE(740),
    [sym_object] = STATE(721),
    [sym_object_pattern] = STATE(1548),
    [sym_array] = STATE(721),
    [sym_array_pattern] = STATE(1548),
    [sym_jsx_element] = STATE(740),
    [sym_jsx_fragment] = STATE(740),
    [sym_jsx_opening_element] = STATE(972),
    [sym_jsx_self_closing_element] = STATE(740),
    [sym_class] = STATE(721),
    [sym_function] = STATE(721),
    [sym_generator_function] = STATE(721),
    [sym_arrow_function] = STATE(721),
    [sym_call_expression] = STATE(721),
    [sym_new_expression] = STATE(740),
    [sym_await_expression] = STATE(740),
    [sym_member_expression] = STATE(479),
    [sym_subscript_expression] = STATE(479),
    [sym_assignment_expression] = STATE(740),
    [sym__augmented_assignment_lhs] = STATE(942),
    [sym_augmented_assignment_expression] = STATE(740),
    [sym__destructuring_pattern] = STATE(1548),
    [sym_ternary_expression] = STATE(740),
    [sym_binary_expression] = STATE(740),
    [sym_unary_expression] = STATE(740),
    [sym_update_expression] = STATE(740),
    [sym_string] = STATE(721),
    [sym_template_string] = STATE(721),
    [sym_regex] = STATE(721),
    [sym_meta_property] = STATE(721),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1546),
    [aux_sym_export_statement_repeat1] = STATE(1154),
    [sym_identifier] = ACTIONS(407),
    [anon_sym_export] = ACTIONS(409),
    [anon_sym_LBRACE] = ACTIONS(379),
    [anon_sym_import] = ACTIONS(381),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LT] = ACTIONS(55),
    [anon_sym_SLASH] = ACTIONS(57),
    [anon_sym_class] = ACTIONS(391),
    [anon_sym_async] = ACTIONS(413),
    [anon_sym_function] = ACTIONS(395),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_typeof] = ACTIONS(67),
    [anon_sym_void] = ACTIONS(67),
    [anon_sym_delete] = ACTIONS(67),
    [anon_sym_PLUS_PLUS] = ACTIONS(71),
    [anon_sym_DASH_DASH] = ACTIONS(71),
    [anon_sym_DQUOTE] = ACTIONS(73),
    [anon_sym_SQUOTE] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(77),
    [sym_number] = ACTIONS(79),
    [sym_this] = ACTIONS(81),
    [sym_super] = ACTIONS(81),
    [sym_true] = ACTIONS(81),
    [sym_false] = ACTIONS(81),
    [sym_null] = ACTIONS(81),
    [sym_undefined] = ACTIONS(83),
    [anon_sym_AT] = ACTIONS(85),
    [anon_sym_static] = ACTIONS(409),
    [anon_sym_get] = ACTIONS(409),
    [anon_sym_set] = ACTIONS(409),
  },
  [251] = {
    [sym_import] = STATE(575),
    [sym_parenthesized_expression] = STATE(449),
    [sym_expression] = STATE(532),
    [sym_primary_expression] = STATE(576),
    [sym_yield_expression] = STATE(577),
    [sym_object] = STATE(575),
    [sym_object_pattern] = STATE(1528),
    [sym_array] = STATE(575),
    [sym_array_pattern] = STATE(1528),
    [sym_jsx_element] = STATE(577),
    [sym_jsx_fragment] = STATE(577),
    [sym_jsx_opening_element] = STATE(975),
    [sym_jsx_self_closing_element] = STATE(577),
    [sym_class] = STATE(575),
    [sym_function] = STATE(575),
    [sym_generator_function] = STATE(575),
    [sym_arrow_function] = STATE(575),
    [sym_call_expression] = STATE(575),
    [sym_new_expression] = STATE(577),
    [sym_await_expression] = STATE(577),
    [sym_member_expression] = STATE(449),
    [sym_subscript_expression] = STATE(449),
    [sym_assignment_expression] = STATE(577),
    [sym__augmented_assignment_lhs] = STATE(943),
    [sym_augmented_assignment_expression] = STATE(577),
    [sym__destructuring_pattern] = STATE(1528),
    [sym_ternary_expression] = STATE(577),
    [sym_binary_expression] = STATE(577),
    [sym_unary_expression] = STATE(577),
    [sym_update_expression] = STATE(577),
    [sym_string] = STATE(575),
    [sym_template_string] = STATE(575),
    [sym_regex] = STATE(575),
    [sym_meta_property] = STATE(575),
    [sym_decorator] = STATE(959),
    [sym_formal_parameters] = STATE(1496),
    [aux_sym_export_statement_repeat1] = STATE(1182),
    [sym_identifier] = ACTIONS(321),
    [anon_s