#include <tree_sitter/parser.h>

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#ifdef _MSC_VER
#pragma optimize("", off)
#elif defined(__clang__)
#pragma clang optimize off
#elif defined(__GNUC__)
#pragma GCC optimize ("O0")
#endif

#define LANGUAGE_VERSION 13
#define STATE_COUNT 15265
#define LARGE_STATE_COUNT 3339
#define SYMBOL_COUNT 499
#define ALIAS_COUNT 36
#define TOKEN_COUNT 284
#define EXTERNAL_TOKEN_COUNT 3
#define FIELD_COUNT 31
#define MAX_ALIAS_SEQUENCE_LENGTH 21
#define PRODUCTION_ID_COUNT 238

enum {
  anon_sym_SEMI = 1,
  aux_sym_with_clause_token1 = 2,
  aux_sym_with_clause_token2 = 3,
  anon_sym_COMMA = 4,
  aux_sym_cte_token1 = 5,
  aux_sym_cte_token2 = 6,
  aux_sym_cte_token3 = 7,
  anon_sym_LPAREN = 8,
  anon_sym_RPAREN = 9,
  aux_sym_truncate_statement_token1 = 10,
  aux_sym_truncate_statement_token2 = 11,
  aux_sym_truncate_statement_token3 = 12,
  aux_sym_comment_statement_token1 = 13,
  aux_sym_comment_statement_token2 = 14,
  aux_sym_comment_statement_token3 = 15,
  aux_sym_comment_statement_token4 = 16,
  aux_sym_comment_statement_token5 = 17,
  aux_sym_comment_statement_token6 = 18,
  aux_sym_comment_statement_token7 = 19,
  aux_sym_begin_statement_token1 = 20,
  aux_sym_begin_statement_token2 = 21,
  aux_sym_begin_statement_token3 = 22,
  aux_sym_commit_statement_token1 = 23,
  aux_sym_rollback_statement_token1 = 24,
  aux_sym_create_statement_token1 = 25,
  aux_sym_create_statement_token2 = 26,
  aux_sym_create_statement_token3 = 27,
  aux_sym_alter_statement_token1 = 28,
  aux_sym_alter_table_token1 = 29,
  aux_sym_alter_table_token2 = 30,
  aux_sym_alter_schema_rename_action_token1 = 31,
  aux_sym_alter_schema_rename_action_token2 = 32,
  aux_sym_alter_owner_action_token1 = 33,
  anon_sym_CURRENT_USER = 34,
  anon_sym_CURRENT_ROLE = 35,
  anon_sym_SESSION_USER = 36,
  aux_sym_alter_table_action_alter_column_token1 = 37,
  aux_sym_alter_table_action_alter_column_token2 = 38,
  aux_sym_alter_table_action_add_token1 = 39,
  aux_sym_sequence_token1 = 40,
  aux_sym_sequence_token2 = 41,
  aux_sym_sequence_token3 = 42,
  aux_sym_sequence_token4 = 43,
  aux_sym_sequence_token5 = 44,
  aux_sym_sequence_token6 = 45,
  aux_sym_sequence_token7 = 46,
  aux_sym_sequence_token8 = 47,
  aux_sym_sequence_token9 = 48,
  aux_sym_pg_command_token1 = 49,
  aux_sym_pg_command_token2 = 50,
  anon_sym_COLON = 51,
  aux_sym__compound_statement_token1 = 52,
  aux_sym__compound_statement_token2 = 53,
  aux_sym_return_statement_token1 = 54,
  aux_sym_declare_statement_token1 = 55,
  aux_sym_create_function_statement_token1 = 56,
  aux_sym_create_function_statement_token2 = 57,
  aux_sym_create_function_statement_token3 = 58,
  aux_sym_create_function_statement_token4 = 59,
  aux_sym_create_function_statement_token5 = 60,
  aux_sym_create_function_statement_token6 = 61,
  aux_sym_create_function_statement_token7 = 62,
  aux_sym_create_function_statement_token8 = 63,
  aux_sym_create_function_statement_token9 = 64,
  aux_sym_create_function_statement_token10 = 65,
  aux_sym_create_function_statement_token11 = 66,
  aux_sym_external_hint_token1 = 67,
  aux_sym_external_hint_token2 = 68,
  aux_sym_external_hint_token3 = 69,
  aux_sym_external_hint_token4 = 70,
  aux_sym_optimizer_hint_token1 = 71,
  aux_sym_optimizer_hint_token2 = 72,
  aux_sym_optimizer_hint_token3 = 73,
  aux_sym_parallel_hint_token1 = 74,
  aux_sym_parallel_hint_token2 = 75,
  aux_sym_parallel_hint_token3 = 76,
  aux_sym_parallel_hint_token4 = 77,
  aux_sym_null_hint_token1 = 78,
  aux_sym_null_hint_token2 = 79,
  aux_sym_null_hint_token3 = 80,
  aux_sym_null_hint_token4 = 81,
  aux_sym_deterministic_hint_token1 = 82,
  aux_sym_sql_hint_token1 = 83,
  aux_sym_sql_hint_token2 = 84,
  aux_sym_sql_hint_token3 = 85,
  aux_sym_sql_hint_token4 = 86,
  aux_sym_sql_hint_token5 = 87,
  aux_sym__function_language_token1 = 88,
  aux_sym__function_language_token2 = 89,
  aux_sym__function_language_token3 = 90,
  aux_sym_setof_token1 = 91,
  aux_sym_create_function_parameter_token1 = 92,
  aux_sym_create_function_parameter_token2 = 93,
  aux_sym_create_function_parameter_token3 = 94,
  aux_sym_create_function_parameter_token4 = 95,
  anon_sym_EQ = 96,
  aux_sym_create_trigger_statement_token1 = 97,
  aux_sym_create_trigger_statement_token2 = 98,
  aux_sym_create_trigger_statement_token3 = 99,
  aux_sym_create_trigger_statement_token4 = 100,
  aux_sym_create_trigger_statement_token5 = 101,
  aux_sym_create_trigger_statement_token6 = 102,
  aux_sym_create_trigger_statement_token7 = 103,
  aux_sym_trigger_reference_token1 = 104,
  aux_sym_trigger_preferencing_token1 = 105,
  aux_sym_trigger_preferencing_token2 = 106,
  aux_sym_trigger_preferencing_token3 = 107,
  aux_sym_trigger_time_token1 = 108,
  aux_sym_trigger_time_token2 = 109,
  aux_sym_trigger_time_token3 = 110,
  aux_sym_trigger_time_token4 = 111,
  aux_sym_trigger_event_token1 = 112,
  aux_sym_trigger_event_token2 = 113,
  aux_sym_trigger_event_token3 = 114,
  aux_sym_trigger_condition_token1 = 115,
  aux_sym_trigger_order_token1 = 116,
  aux_sym_trigger_order_token2 = 117,
  aux_sym_trigger_body_token1 = 118,
  aux_sym_create_extension_statement_token1 = 119,
  aux_sym_create_extension_statement_token2 = 120,
  aux_sym_create_role_statement_token1 = 121,
  aux_sym_drop_statement_token1 = 122,
  aux_sym_drop_statement_token2 = 123,
  aux_sym_drop_statement_token3 = 124,
  aux_sym_drop_statement_token4 = 125,
  aux_sym_drop_statement_token5 = 126,
  aux_sym_drop_statement_token6 = 127,
  aux_sym_set_statement_token1 = 128,
  aux_sym_set_statement_token2 = 129,
  aux_sym_grant_statement_token1 = 130,
  aux_sym_grant_statement_token2 = 131,
  aux_sym_grant_statement_token3 = 132,
  aux_sym_grant_statement_token4 = 133,
  aux_sym_grant_statement_token5 = 134,
  aux_sym_grant_statement_token6 = 135,
  aux_sym_grant_statement_token7 = 136,
  aux_sym_grant_statement_token8 = 137,
  aux_sym_grant_statement_token9 = 138,
  aux_sym_grant_statement_token10 = 139,
  aux_sym_create_domain_statement_token1 = 140,
  aux_sym_type_spec_enum_token1 = 141,
  aux_sym_type_spec_range_token1 = 142,
  aux_sym_type_spec_range_token2 = 143,
  aux_sym_type_spec_range_token3 = 144,
  aux_sym_type_spec_range_token4 = 145,
  aux_sym_type_spec_range_token5 = 146,
  aux_sym_type_spec_range_token6 = 147,
  aux_sym_type_spec_range_token7 = 148,
  aux_sym_type_spec_base_token1 = 149,
  aux_sym_type_spec_base_token2 = 150,
  aux_sym_type_spec_base_token3 = 151,
  aux_sym_type_spec_base_token4 = 152,
  aux_sym_type_spec_base_token5 = 153,
  aux_sym_type_spec_base_token6 = 154,
  aux_sym_type_spec_base_token7 = 155,
  aux_sym_type_spec_base_token8 = 156,
  aux_sym_type_spec_base_token9 = 157,
  aux_sym_type_spec_base_token10 = 158,
  aux_sym_type_spec_base_token11 = 159,
  aux_sym_type_spec_base_token12 = 160,
  aux_sym_type_spec_base_token13 = 161,
  aux_sym_type_spec_base_token14 = 162,
  aux_sym_type_spec_base_token15 = 163,
  aux_sym_type_spec_base_token16 = 164,
  aux_sym_type_spec_base_token17 = 165,
  aux_sym_type_spec_base_token18 = 166,
  aux_sym_create_index_include_clause_token1 = 167,
  aux_sym_auto_increment_constraint_token1 = 168,
  aux_sym_direction_constraint_token1 = 169,
  aux_sym_direction_constraint_token2 = 170,
  anon_sym_CONSTRAINT = 171,
  aux_sym_mode_token1 = 172,
  aux_sym_initial_mode_token1 = 173,
  aux_sym_initial_mode_token2 = 174,
  aux_sym_initial_mode_token3 = 175,
  aux_sym_table_constraint_check_token1 = 176,
  aux_sym_table_constraint_exclude_token1 = 177,
  aux_sym_table_constraint_exclude_token2 = 178,
  aux_sym_table_constraint_foreign_key_token1 = 179,
  aux_sym_table_constraint_foreign_key_token2 = 180,
  aux_sym_table_constraint_unique_token1 = 181,
  aux_sym_table_constraint_primary_key_token1 = 182,
  aux_sym_create_table_statement_token1 = 183,
  aux_sym_create_table_statement_token2 = 184,
  aux_sym_view_check_option_token1 = 185,
  aux_sym_having_clause_token1 = 186,
  aux_sym_grouping_sets_clause_token1 = 187,
  aux_sym_grouping_sets_clause_token2 = 188,
  aux_sym_rollup_clause_token1 = 189,
  aux_sym_cube_clause_token1 = 190,
  aux_sym_order_expression_token1 = 191,
  aux_sym_order_expression_token2 = 192,
  aux_sym_order_expression_token3 = 193,
  aux_sym_order_by_clause_token1 = 194,
  aux_sym_limit_clause_token1 = 195,
  aux_sym_offset_clause_token1 = 196,
  aux_sym_fetch_clause_token1 = 197,
  aux_sym_fetch_clause_token2 = 198,
  aux_sym_where_clause_token1 = 199,
  aux_sym_select_clause_body_token1 = 200,
  aux_sym_join_type_token1 = 201,
  aux_sym_join_type_token2 = 202,
  aux_sym_join_type_token3 = 203,
  aux_sym_join_type_token4 = 204,
  aux_sym_join_type_token5 = 205,
  aux_sym_join_clause_token1 = 206,
  aux_sym_select_subexpression_token1 = 207,
  aux_sym_values_clause_token1 = 208,
  aux_sym_conditional_expression_token1 = 209,
  aux_sym_conditional_expression_token2 = 210,
  aux_sym_conditional_expression_token3 = 211,
  aux_sym__function_call_arguments_token1 = 212,
  aux_sym_within_group_clause_token1 = 213,
  aux_sym_filter_clause_token1 = 214,
  aux_sym_over_clause_token1 = 215,
  aux_sym_partition_by_clause_token1 = 216,
  aux_sym_frame_clause_token1 = 217,
  aux_sym_frame_clause_token2 = 218,
  aux_sym_frame_kind_token1 = 219,
  aux_sym_frame_bound_token1 = 220,
  aux_sym_frame_bound_token2 = 221,
  aux_sym_frame_bound_token3 = 222,
  aux_sym_frame_bound_token4 = 223,
  aux_sym_frame_exclusion_token1 = 224,
  aux_sym_frame_exclusion_token2 = 225,
  aux_sym_at_time_zone_expression_token1 = 226,
  aux_sym_at_time_zone_expression_token2 = 227,
  aux_sym_at_time_zone_expression_token3 = 228,
  aux_sym_TRUE_token1 = 229,
  aux_sym_FALSE_token1 = 230,
  sym_number = 231,
  sym__unquoted_identifier = 232,
  anon_sym_BQUOTE = 233,
  aux_sym__quoted_identifier_token1 = 234,
  anon_sym_DQUOTE = 235,
  aux_sym__quoted_identifier_token2 = 236,
  anon_sym_DOT = 237,
  anon_sym_SQUOTE = 238,
  aux_sym_string_token1 = 239,
  anon_sym_DASH_GT = 240,
  anon_sym_DASH_GT_GT = 241,
  anon_sym_POUND_GT = 242,
  anon_sym_POUND_GT_GT = 243,
  aux_sym_type_token1 = 244,
  aux_sym_type_token2 = 245,
  anon_sym_LBRACK = 246,
  anon_sym_RBRACK = 247,
  anon_sym_COLON_COLON = 248,
  sym_comment = 249,
  anon_sym_PLUS = 250,
  anon_sym_DASH = 251,
  anon_sym_BANG_BANG = 252,
  anon_sym_TILDE = 253,
  anon_sym_AT = 254,
  anon_sym_PIPE_SLASH = 255,
  anon_sym_PIPE_PIPE_SLASH = 256,
  anon_sym_CARET = 257,
  anon_sym_STAR = 258,
  anon_sym_SLASH = 259,
  anon_sym_PERCENT = 260,
  anon_sym_LT_LT = 261,
  anon_sym_GT_GT = 262,
  anon_sym_AMP = 263,
  anon_sym_PIPE = 264,
  anon_sym_POUND = 265,
  anon_sym_LT = 266,
  anon_sym_LT_EQ = 267,
  anon_sym_LT_GT = 268,
  anon_sym_BANG_EQ = 269,
  anon_sym_GT = 270,
  anon_sym_GT_EQ = 271,
  anon_sym_BANG_TILDE = 272,
  anon_sym_TILDE_STAR = 273,
  anon_sym_BANG_TILDE_STAR = 274,
  anon_sym_AMP_AMP = 275,
  anon_sym_PIPE_PIPE = 276,
  anon_sym_DOT_STAR = 277,
  aux_sym_interval_expression_token1 = 278,
  anon_sym_DOLLAR = 279,
  aux_sym_argument_reference_token1 = 280,
  sym__dollar_quoted_string_tag = 281,
  sym__dollar_quoted_string_content = 282,
  sym__dollar_quoted_string_end_tag = 283,
  sym_source_file = 284,
  sym__statement = 285,
  sym__simple_statement = 286,
  sym_with_clause = 287,
  sym_cte = 288,
  sym_select_statement = 289,
  sym_insert_statement = 290,
  sym_update_statement = 291,
  sym_delete_statement = 292,
  sym_truncate_statement = 293,
  sym_comment_statement = 294,
  sym_begin_statement = 295,
  sym_commit_statement = 296,
  sym_rollback_statement = 297,
  sym_create_statement = 298,
  sym_alter_statement = 299,
  sym_alter_table = 300,
  sym_alter_schema_rename_action = 301,
  sym_alter_owner_action = 302,
  sym_alter_schema = 303,
  sym_alter_table_action_alter_column = 304,
  sym_alter_table_action_add = 305,
  sym_alter_table_action_set = 306,
  sym_alter_table_rename_column = 307,
  sym_alter_table_action = 308,
  sym_sequence = 309,
  sym_pg_command = 310,
  sym__compound_statement = 311,
  sym_return_statement = 312,
  sym_declare_statement = 313,
  sym_create_function_statement = 314,
  sym_external_hint = 315,
  sym_optimizer_hint = 316,
  sym_parallel_hint = 317,
  sym_null_hint = 318,
  sym_deterministic_hint = 319,
  sym_sql_hint = 320,
  sym_sql_security_hint = 321,
  sym__function_language = 322,
  sym__create_function_return_type = 323,
  sym_setof = 324,
  sym_constrained_type = 325,
  sym_create_function_parameter = 326,
  sym_create_function_parameters = 327,
  sym_function_body = 328,
  sym_create_trigger_statement = 329,
  sym_trigger_reference = 330,
  sym_trigger_preferencing = 331,
  sym_trigger_time = 332,
  sym_trigger_event = 333,
  sym_trigger_condition = 334,
  sym_trigger_order = 335,
  sym_trigger_body = 336,
  sym_create_extension_statement = 337,
  sym_create_role_statement = 338,
  sym_create_schema_statement = 339,
  sym_drop_statement = 340,
  sym_set_statement = 341,
  sym_grant_statement = 342,
  sym_create_domain_statement = 343,
  sym_create_type_statement = 344,
  sym_type_spec_composite = 345,
  sym_type_spec_enum = 346,
  sym_type_spec_range = 347,
  sym_type_spec_base = 348,
  sym_create_index_with_clause = 349,
  sym_create_index_include_clause = 350,
  sym_create_index_statement = 351,
  sym_table_column = 352,
  sym_auto_increment_constraint = 353,
  sym_direction_constraint = 354,
  sym_named_constraint = 355,
  sym__column_default_expression = 356,
  sym_default_clause = 357,
  sym_table_parameters = 358,
  sym_mode = 359,
  sym_initial_mode = 360,
  sym__table_constraint = 361,
  sym_table_constraint_check = 362,
  sym_op_class = 363,
  sym_exclude_entry = 364,
  sym_table_constraint_exclude = 365,
  sym_table_constraint_foreign_key = 366,
  sym_table_constraint_unique = 367,
  sym_table_constraint_primary_key = 368,
  sym_primary_key_constraint = 369,
  sym_create_table_statement = 370,
  sym_using_clause = 371,
  sym_index_table_parameters = 372,
  sym_create_view_statement = 373,
  sym_view_columns = 374,
  sym_view_option = 375,
  sym_view_options = 376,
  sym_view_check_option = 377,
  sym_view_body = 378,
  sym_create_materialized_view_statement = 379,
  sym_tablespace_hint = 380,
  sym_data_hint = 381,
  sym__select_statement = 382,
  sym_group_by_clause = 383,
  sym_having_clause = 384,
  sym_group_expression = 385,
  sym_grouping_sets_clause = 386,
  sym_rollup_clause = 387,
  sym_cube_clause = 388,
  sym_expression_list = 389,
  sym_order_expression = 390,
  sym_window_clause = 391,
  sym_order_by_clause = 392,
  sym_limit_clause = 393,
  sym_offset_clause = 394,
  sym_fetch_clause = 395,
  sym_where_clause = 396,
  sym__aliased_expression = 397,
  sym__aliasable_expression = 398,
  sym_select_clause_body = 399,
  sym_select_clause = 400,
  sym_from_clause = 401,
  sym_join_type = 402,
  sym_join_clause = 403,
  sym_select_subexpression = 404,
  sym__update_statement = 405,
  sym_set_clause = 406,
  sym_set_clause_body = 407,
  sym_assigment_expression = 408,
  sym__insert_statement = 409,
  sym_values_clause = 410,
  sym_values_clause_item = 411,
  sym__delete_statement = 412,
  sym_conditional_expression = 413,
  sym_in_expression = 414,
  sym_tuple = 415,
  sym_references_constraint = 416,
  sym_on_update_action = 417,
  sym_on_delete_action = 418,
  sym__constraint_action = 419,
  sym_unique_constraint = 420,
  sym_null_constraint = 421,
  sym_check_constraint = 422,
  sym_function_call = 423,
  sym__function_call_arguments = 424,
  sym_within_group_clause = 425,
  sym_filter_clause = 426,
  sym_over_clause = 427,
  sym_window_definition = 428,
  sym_partition_by_clause = 429,
  sym_frame_clause = 430,
  sym_frame_kind = 431,
  sym_frame_bound = 432,
  sym_frame_exclusion = 433,
  sym__parenthesized_expression = 434,
  sym_is_expression = 435,
  sym_distinct_from = 436,
  sym_boolean_expression = 437,
  sym_at_time_zone_expression = 438,
  sym_NULL = 439,
  sym_TRUE = 440,
  sym_FALSE = 441,
  sym__quoted_identifier = 442,
  sym_identifier = 443,
  sym_dotted_name = 444,
  sym__identifier = 445,
  sym_string = 446,
  sym_json_access = 447,
  sym_ordered_expression = 448,
  sym_type = 449,
  sym_array_type = 450,
  sym__type = 451,
  sym_type_cast = 452,
  sym_array_element_access = 453,
  sym_unary_expression = 454,
  sym_binary_expression = 455,
  sym_binary_operator = 456,
  sym_asterisk_expression = 457,
  sym_interval_expression = 458,
  sym_argument_reference = 459,
  sym__expression = 460,
  aux_sym_source_file_repeat1 = 461,
  aux_sym_with_clause_repeat1 = 462,
  aux_sym_truncate_statement_repeat1 = 463,
  aux_sym_sequence_repeat1 = 464,
  aux_sym__compound_statement_repeat1 = 465,
  aux_sym_create_function_statement_repeat1 = 466,
  aux_sym_create_function_statement_repeat2 = 467,
  aux_sym_create_function_parameters_repeat1 = 468,
  aux_sym_trigger_preferencing_repeat1 = 469,
  aux_sym_trigger_event_repeat1 = 470,
  aux_sym_trigger_body_repeat1 = 471,
  aux_sym_create_extension_statement_repeat1 = 472,
  aux_sym_grant_statement_repeat1 = 473,
  aux_sym_create_domain_statement_repeat1 = 474,
  aux_sym_type_spec_composite_repeat1 = 475,
  aux_sym_type_spec_range_repeat1 = 476,
  aux_sym_type_spec_base_repeat1 = 477,
  aux_sym_table_column_repeat1 = 478,
  aux_sym_table_parameters_repeat1 = 479,
  aux_sym_table_constraint_exclude_repeat1 = 480,
  aux_sym_index_table_parameters_repeat1 = 481,
  aux_sym_view_options_repeat1 = 482,
  aux_sym__select_statement_repeat1 = 483,
  aux_sym__select_statement_repeat2 = 484,
  aux_sym_group_by_clause_repeat1 = 485,
  aux_sym_grouping_sets_clause_repeat1 = 486,
  aux_sym_rollup_clause_repeat1 = 487,
  aux_sym_expression_list_repeat1 = 488,
  aux_sym_order_by_clause_repeat1 = 489,
  aux_sym_select_clause_body_repeat1 = 490,
  aux_sym_from_clause_repeat1 = 491,
  aux_sym_set_clause_body_repeat1 = 492,
  aux_sym_values_clause_repeat1 = 493,
  aux_sym_conditional_expression_repeat1 = 494,
  aux_sym_references_constraint_repeat1 = 495,
  aux_sym_dotted_name_repeat1 = 496,
  aux_sym_type_repeat1 = 497,
  aux_sym_array_type_repeat1 = 498,
  anon_alias_sym_ALTER_COLUMN = 499,
  anon_alias_sym_BY = 500,
  anon_alias_sym_CHECK = 501,
  anon_alias_sym_CREATE_EXTENSION = 502,
  anon_alias_sym_CREATE_SCHEMA = 503,
  anon_alias_sym_DEFERRABLE = 504,
  anon_alias_sym_DEFINER = 505,
  anon_alias_sym_DISTINCT_FROM = 506,
  anon_alias_sym_EXCLUDE_CURRENT_ROW = 507,
  anon_alias_sym_EXCLUDE_GROUP = 508,
  anon_alias_sym_EXISTS = 509,
  anon_alias_sym_FUNCTION = 510,
  anon_alias_sym_IF = 511,
  anon_alias_sym_IF_EXISTS = 512,
  anon_alias_sym_INVOKER = 513,
  anon_alias_sym_MATERIALIZED = 514,
  anon_alias_sym_MATERIALIZED_VIEW = 515,
  anon_alias_sym_NOT = 516,
  anon_alias_sym_NO_SQL = 517,
  anon_alias_sym_NULL = 518,
  anon_alias_sym_OF = 519,
  anon_alias_sym_ON_DELETE = 520,
  anon_alias_sym_ON_UPDATE = 521,
  anon_alias_sym_OR = 522,
  anon_alias_sym_PRECEDING = 523,
  anon_alias_sym_PROCEDURE = 524,
  anon_alias_sym_RENAME_TO = 525,
  anon_alias_sym_SET_DEFAULT = 526,
  anon_alias_sym_SET_NULL = 527,
  anon_alias_sym_UNBOUNDED_FOLLOWING = 528,
  anon_alias_sym_WITH = 529,
  anon_alias_sym_WITHOUT = 530,
  alias_sym_alter_sequence = 531,
  anon_alias_sym_default = 532,
  alias_sym_default = 533,
  alias_sym_version = 534,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [anon_sym_SEMI] = ";",
  [aux_sym_with_clause_token1] = "WITH_GRANT_OPTION",
  [aux_sym_with_clause_token2] = "RECURSIVE",
  [anon_sym_COMMA] = ",",
  [aux_sym_cte_token1] = "AS",
  [aux_sym_cte_token2] = "IF_NOT_EXISTS",
  [aux_sym_cte_token3] = "CREATE_MATERIALIZED_VIEW",
  [anon_sym_LPAREN] = "(",
  [anon_sym_RPAREN] = ")",
  [aux_sym_truncate_statement_token1] = "TRUNCATE",
  [aux_sym_truncate_statement_token2] = "TABLE",
  [aux_sym_truncate_statement_token3] = "ONLY",
  [aux_sym_comment_statement_token1] = "COMMENT_ON",
  [aux_sym_comment_statement_token2] = "ON",
  [aux_sym_comment_statement_token3] = "COLUMN",
  [aux_sym_comment_statement_token4] = "EXTENSION",
  [aux_sym_comment_statement_token5] = "SCHEMA",
  [aux_sym_comment_statement_token6] = "CREATE_OR_REPLACE_FUNCTION",
  [aux_sym_comment_statement_token7] = "IS",
  [aux_sym_begin_statement_token1] = "BEGIN",
  [aux_sym_begin_statement_token2] = "WORK",
  [aux_sym_begin_statement_token3] = "TRANSACTION",
  [aux_sym_commit_statement_token1] = "COMMIT",
  [aux_sym_rollback_statement_token1] = "ROLLBACK",
  [aux_sym_create_statement_token1] = "CREATE",
  [aux_sym_create_statement_token2] = "TEMP",
  [aux_sym_create_statement_token3] = "TEMPORARY",
  [aux_sym_alter_statement_token1] = "ALTER",
  [aux_sym_alter_table_token1] = "IF_NOT_EXISTS",
  [aux_sym_alter_table_token2] = "IF_NOT_EXISTS",
  [aux_sym_alter_schema_rename_action_token1] = "RENAME",
  [aux_sym_alter_schema_rename_action_token2] = "TO",
  [aux_sym_alter_owner_action_token1] = "OWNER_TO",
  [anon_sym_CURRENT_USER] = "CURRENT_USER",
  [anon_sym_CURRENT_ROLE] = "CURRENT_ROLE",
  [anon_sym_SESSION_USER] = "SESSION_USER",
  [aux_sym_alter_table_action_alter_column_token1] = "SET",
  [aux_sym_alter_table_action_alter_column_token2] = "DEFAULT",
  [aux_sym_alter_table_action_add_token1] = "ADD",
  [aux_sym_sequence_token1] = "SEQUENCE",
  [aux_sym_sequence_token2] = "START",
  [aux_sym_sequence_token3] = "INCREMENT",
  [aux_sym_sequence_token4] = "GROUP_BY",
  [aux_sym_sequence_token5] = "NO",
  [aux_sym_sequence_token6] = "MINVALUE",
  [aux_sym_sequence_token7] = "MAXVALUE",
  [aux_sym_sequence_token8] = "CACHE",
  [aux_sym_sequence_token9] = "OWNED_BY",
  [aux_sym_pg_command_token1] = "pg_command_token1",
  [aux_sym_pg_command_token2] = "pg_command_token2",
  [anon_sym_COLON] = ":",
  [aux_sym__compound_statement_token1] = "ATOMIC",
  [aux_sym__compound_statement_token2] = "END",
  [aux_sym_return_statement_token1] = "RETURN",
  [aux_sym_declare_statement_token1] = "DECLARE",
  [aux_sym_create_function_statement_token1] = "create_function_statement_token1",
  [aux_sym_create_function_statement_token2] = "CREATE_OR_REPLACE_PROCEDURE",
  [aux_sym_create_function_statement_token3] = "RETURNS",
  [aux_sym_create_function_statement_token4] = "TRANSFORM_FOR_TYPE",
  [aux_sym_create_function_statement_token5] = "FOR",
  [aux_sym_create_function_statement_token6] = "CREATE_TYPE",
  [aux_sym_create_function_statement_token7] = "WINDOW",
  [aux_sym_create_function_statement_token8] = "LEAKPROOF",
  [aux_sym_create_function_statement_token9] = "COST",
  [aux_sym_create_function_statement_token10] = "ROWS",
  [aux_sym_create_function_statement_token11] = "SUPPORT",
  [aux_sym_external_hint_token1] = "EXTERNAL",
  [aux_sym_external_hint_token2] = "SECURITY_INVOKER",
  [aux_sym_external_hint_token3] = "SECURITY_INVOKER",
  [aux_sym_external_hint_token4] = "SECURITY_DEFINER",
  [aux_sym_optimizer_hint_token1] = "VOLATILE",
  [aux_sym_optimizer_hint_token2] = "IMMUTABLE",
  [aux_sym_optimizer_hint_token3] = "STABLE",
  [aux_sym_parallel_hint_token1] = "PARALLEL",
  [aux_sym_parallel_hint_token2] = "SAFE",
  [aux_sym_parallel_hint_token3] = "UNSAFE",
  [aux_sym_parallel_hint_token4] = "RESTRICTED",
  [aux_sym_null_hint_token1] = "CALLED_ON_NULL_INPUT",
  [aux_sym_null_hint_token2] = "RETURNS_NULL_ON_NULL_INPUT",
  [aux_sym_null_hint_token3] = "input",
  [aux_sym_null_hint_token4] = "STRICT",
  [aux_sym_deterministic_hint_token1] = "DETERMINISTIC",
  [aux_sym_sql_hint_token1] = "CONTAINS_SQL",
  [aux_sym_sql_hint_token2] = "SQL_SECURITY",
  [aux_sym_sql_hint_token3] = "READS_SQL_DATA",
  [aux_sym_sql_hint_token4] = "DATA",
  [aux_sym_sql_hint_token5] = "MODIFIES_SQL_DATA",
  [aux_sym__function_language_token1] = "LANGUAGE",
  [aux_sym__function_language_token2] = "language",
  [aux_sym__function_language_token3] = "language",
  [aux_sym_setof_token1] = "SETOF",
  [aux_sym_create_function_parameter_token1] = "IN",
  [aux_sym_create_function_parameter_token2] = "OUT",
  [aux_sym_create_function_parameter_token3] = "INOUT",
  [aux_sym_create_function_parameter_token4] = "VARIADIC",
  [anon_sym_EQ] = "=",
  [aux_sym_create_trigger_statement_token1] = "OR_REPLACE",
  [aux_sym_create_trigger_statement_token2] = "OR_REPLACE",
  [aux_sym_create_trigger_statement_token3] = "CONSTRAINT",
  [aux_sym_create_trigger_statement_token4] = "TRIGGER",
  [aux_sym_create_trigger_statement_token5] = "EACH",
  [aux_sym_create_trigger_statement_token6] = "ROW",
  [aux_sym_create_trigger_statement_token7] = "STATEMENT",
  [aux_sym_trigger_reference_token1] = "FROM",
  [aux_sym_trigger_preferencing_token1] = "REFERENCING",
  [aux_sym_trigger_preferencing_token2] = "NEW",
  [aux_sym_trigger_preferencing_token3] = "OLD",
  [aux_sym_trigger_time_token1] = "BEFORE",
  [aux_sym_trigger_time_token2] = "AFTER",
  [aux_sym_trigger_time_token3] = "INSTEAD_OF",
  [aux_sym_trigger_time_token4] = "INSTEAD_OF",
  [aux_sym_trigger_event_token1] = "INSERT",
  [aux_sym_trigger_event_token2] = "DELETE",
  [aux_sym_trigger_event_token3] = "UPDATE",
  [aux_sym_trigger_condition_token1] = "WHEN",
  [aux_sym_trigger_order_token1] = "FOLLOWS",
  [aux_sym_trigger_order_token2] = "PRECEDES",
  [aux_sym_trigger_body_token1] = "EXECUTE",
  [aux_sym_create_extension_statement_token1] = "VERSION",
  [aux_sym_create_extension_statement_token2] = "CASCADE",
  [aux_sym_create_role_statement_token1] = "CREATE_ROLE",
  [aux_sym_drop_statement_token1] = "DROP",
  [aux_sym_drop_statement_token2] = "VIEW",
  [aux_sym_drop_statement_token3] = "INDEX",
  [aux_sym_drop_statement_token4] = "TABLESPACE",
  [aux_sym_drop_statement_token5] = "CONCURRENTLY",
  [aux_sym_drop_statement_token6] = "RESTRICT",
  [aux_sym_set_statement_token1] = "SESSION",
  [aux_sym_set_statement_token2] = "LOCAL",
  [aux_sym_grant_statement_token1] = "GRANT",
  [aux_sym_grant_statement_token2] = "ALL",
  [aux_sym_grant_statement_token3] = "PRIVILEGES",
  [aux_sym_grant_statement_token4] = "SELECT",
  [aux_sym_grant_statement_token5] = "REFERENCES",
  [aux_sym_grant_statement_token6] = "USAGE",
  [aux_sym_grant_statement_token7] = "DATABASE",
  [aux_sym_grant_statement_token8] = "GROUP",
  [aux_sym_grant_statement_token9] = "PUBLIC",
  [aux_sym_grant_statement_token10] = "WITH_GRANT_OPTION",
  [aux_sym_create_domain_statement_token1] = "CREATE_DOMAIN",
  [aux_sym_type_spec_enum_token1] = "ENUM",
  [aux_sym_type_spec_range_token1] = "RANGE",
  [aux_sym_type_spec_range_token2] = "subtype",
  [aux_sym_type_spec_range_token3] = "subtype_opclass",
  [aux_sym_type_spec_range_token4] = "collation",
  [aux_sym_type_spec_range_token5] = "canonical",
  [aux_sym_type_spec_range_token6] = "subtype_diff",
  [aux_sym_type_spec_range_token7] = "multirange_type_name",
  [aux_sym_type_spec_base_token1] = "output",
  [aux_sym_type_spec_base_token2] = "receive",
  [aux_sym_type_spec_base_token3] = "send",
  [aux_sym_type_spec_base_token4] = "typmod_in",
  [aux_sym_type_spec_base_token5] = "typmod_out",
  [aux_sym_type_spec_base_token6] = "analyze",
  [aux_sym_type_spec_base_token7] = "subscript",
  [aux_sym_type_spec_base_token8] = "internallength",
  [aux_sym_type_spec_base_token9] = "VARIABLE",
  [aux_sym_type_spec_base_token10] = "passedbyvalue",
  [aux_sym_type_spec_base_token11] = "alignment",
  [aux_sym_type_spec_base_token12] = "storage",
  [aux_sym_type_spec_base_token13] = "like",
  [aux_sym_type_spec_base_token14] = "category",
  [aux_sym_type_spec_base_token15] = "preferred",
  [aux_sym_type_spec_base_token16] = "element",
  [aux_sym_type_spec_base_token17] = "delimiter",
  [aux_sym_type_spec_base_token18] = "collatable",
  [aux_sym_create_index_include_clause_token1] = "INCLUDE",
  [aux_sym_auto_increment_constraint_token1] = "AUTO_INCREMENT",
  [aux_sym_direction_constraint_token1] = "ASC",
  [aux_sym_direction_constraint_token2] = "DESC",
  [anon_sym_CONSTRAINT] = "CONSTRAINT",
  [aux_sym_mode_token1] = "NOT_DEFERRABLE",
  [aux_sym_initial_mode_token1] = "INITIALLY",
  [aux_sym_initial_mode_token2] = "DEFERRED",
  [aux_sym_initial_mode_token3] = "IMMEDIATE",
  [aux_sym_table_constraint_check_token1] = "CHECK_OPTION",
  [aux_sym_table_constraint_exclude_token1] = "EXCLUDE",
  [aux_sym_table_constraint_exclude_token2] = "USING",
  [aux_sym_table_constraint_foreign_key_token1] = "FOREIGN_KEY",
  [aux_sym_table_constraint_foreign_key_token2] = "PRIMARY_KEY",
  [aux_sym_table_constraint_unique_token1] = "UNIQUE",
  [aux_sym_table_constraint_primary_key_token1] = "PRIMARY_KEY",
  [aux_sym_create_table_statement_token1] = "WITHOUT_OIDS",
  [aux_sym_create_table_statement_token2] = "WITHOUT_OIDS",
  [aux_sym_view_check_option_token1] = "CASCADED",
  [aux_sym_having_clause_token1] = "HAVING",
  [aux_sym_grouping_sets_clause_token1] = "GROUPING_SETS",
  [aux_sym_grouping_sets_clause_token2] = "GROUPING_SETS",
  [aux_sym_rollup_clause_token1] = "ROLLUP",
  [aux_sym_cube_clause_token1] = "CUBE",
  [aux_sym_order_expression_token1] = "NULLS",
  [aux_sym_order_expression_token2] = "FIRST",
  [aux_sym_order_expression_token3] = "LAST",
  [aux_sym_order_by_clause_token1] = "ORDER_BY",
  [aux_sym_limit_clause_token1] = "LIMIT",
  [aux_sym_offset_clause_token1] = "OFFSET",
  [aux_sym_fetch_clause_token1] = "FETCH",
  [aux_sym_fetch_clause_token2] = "NEXT",
  [aux_sym_where_clause_token1] = "WHERE",
  [aux_sym_select_clause_body_token1] = "INTO",
  [aux_sym_join_type_token1] = "INNER",
  [aux_sym_join_type_token2] = "LEFT",
  [aux_sym_join_type_token3] = "RIGHT",
  [aux_sym_join_type_token4] = "FULL",
  [aux_sym_join_type_token5] = "OUTER",
  [aux_sym_join_clause_token1] = "JOIN",
  [aux_sym_select_subexpression_token1] = "LATERAL",
  [aux_sym_values_clause_token1] = "VALUES",
  [aux_sym_conditional_expression_token1] = "CASE",
  [aux_sym_conditional_expression_token2] = "THEN",
  [aux_sym_conditional_expression_token3] = "ELSE",
  [aux_sym__function_call_arguments_token1] = "DISTINCT",
  [aux_sym_within_group_clause_token1] = "WITHIN_GROUP",
  [aux_sym_filter_clause_token1] = "FILTER",
  [aux_sym_over_clause_token1] = "OVER",
  [aux_sym_partition_by_clause_token1] = "PARTITION_BY",
  [aux_sym_frame_clause_token1] = "BETWEEN",
  [aux_sym_frame_clause_token2] = "AND",
  [aux_sym_frame_kind_token1] = "GROUPS",
  [aux_sym_frame_bound_token1] = "UNBOUNDED_PRECEDING",
  [aux_sym_frame_bound_token2] = "UNBOUNDED_PRECEDING",
  [aux_sym_frame_bound_token3] = "CURRENT_ROW",
  [aux_sym_frame_bound_token4] = "FOLLOWING",
  [aux_sym_frame_exclusion_token1] = "EXCLUDE_TIES",
  [aux_sym_frame_exclusion_token2] = "EXCLUDE_NO_OTHERS",
  [aux_sym_at_time_zone_expression_token1] = "AT_TIME_ZONE",
  [aux_sym_at_time_zone_expression_token2] = "TIME_ZONE",
  [aux_sym_at_time_zone_expression_token3] = "TIME_ZONE",
  [aux_sym_TRUE_token1] = "TRUE",
  [aux_sym_FALSE_token1] = "FALSE",
  [sym_number] = "number",
  [sym__unquoted_identifier] = "_unquoted_identifier",
  [anon_sym_BQUOTE] = "`",
  [aux_sym__quoted_identifier_token1] = "_quoted_identifier_token1",
  [anon_sym_DQUOTE] = "\"",
  [aux_sym__quoted_identifier_token2] = "_quoted_identifier_token2",
  [anon_sym_DOT] = ".",
  [anon_sym_SQUOTE] = "'",
  [aux_sym_string_token1] = "content",
  [anon_sym_DASH_GT] = "->",
  [anon_sym_DASH_GT_GT] = "->>",
  [anon_sym_POUND_GT] = "#>",
  [anon_sym_POUND_GT_GT] = "#>>",
  [aux_sym_type_token1] = "VARYING",
  [aux_sym_type_token2] = "PRECISION",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [anon_sym_COLON_COLON] = "::",
  [sym_comment] = "comment",
  [anon_sym_PLUS] = "+",
  [anon_sym_DASH] = "-",
  [anon_sym_BANG_BANG] = "!!",
  [anon_sym_TILDE] = "~",
  [anon_sym_AT] = "@",
  [anon_sym_PIPE_SLASH] = "|/",
  [anon_sym_PIPE_PIPE_SLASH] = "||/",
  [anon_sym_CARET] = "^",
  [anon_sym_STAR] = "*",
  [anon_sym_SLASH] = "/",
  [anon_sym_PERCENT] = "%",
  [anon_sym_LT_LT] = "<<",
  [anon_sym_GT_GT] = ">>",
  [anon_sym_AMP] = "&",
  [anon_sym_PIPE] = "|",
  [anon_sym_POUND] = "#",
  [anon_sym_LT] = "<",
  [anon_sym_LT_EQ] = "<=",
  [anon_sym_LT_GT] = "<>",
  [anon_sym_BANG_EQ] = "!=",
  [anon_sym_GT] = ">",
  [anon_sym_GT_EQ] = ">=",
  [anon_sym_BANG_TILDE] = "!~",
  [anon_sym_TILDE_STAR] = "~*",
  [anon_sym_BANG_TILDE_STAR] = "!~*",
  [anon_sym_AMP_AMP] = "&&",
  [anon_sym_PIPE_PIPE] = "||",
  [anon_sym_DOT_STAR] = ".*",
  [aux_sym_interval_expression_token1] = "interval_expression_token1",
  [anon_sym_DOLLAR] = "$",
  [aux_sym_argument_reference_token1] = "argument_reference_token1",
  [sym__dollar_quoted_string_tag] = "_dollar_quoted_string_tag",
  [sym__dollar_quoted_string_content] = "content",
  [sym__dollar_quoted_string_end_tag] = "_dollar_quoted_string_end_tag",
  [sym_source_file] = "source_file",
  [sym__statement] = "_statement",
  [sym__simple_statement] = "_simple_statement",
  [sym_with_clause] = "with_clause",
  [sym_cte] = "cte",
  [sym_select_statement] = "select_statement",
  [sym_insert_statement] = "insert_statement",
  [sym_update_statement] = "update_statement",
  [sym_delete_statement] = "delete_statement",
  [sym_truncate_statement] = "truncate_statement",
  [sym_comment_statement] = "comment_statement",
  [sym_begin_statement] = "begin_statement",
  [sym_commit_statement] = "commit_statement",
  [sym_rollback_statement] = "rollback_statement",
  [sym_create_statement] = "create_statement",
  [sym_alter_statement] = "alter_statement",
  [sym_alter_table] = "alter_table",
  [sym_alter_schema_rename_action] = "rename",
  [sym_alter_owner_action] = "alter_owner",
  [sym_alter_schema] = "schema",
  [sym_alter_table_action_alter_column] = "alter_table_action_alter_column",
  [sym_alter_table_action_add] = "alter_table_action_add",
  [sym_alter_table_action_set] = "alter_table_action_set",
  [sym_alter_table_rename_column] = "alter_table_rename_column",
  [sym_alter_table_action] = "alter_table_action",
  [sym_sequence] = "create_sequence",
  [sym_pg_command] = "pg_command",
  [sym__compound_statement] = "_compound_statement",
  [sym_return_statement] = "return_statement",
  [sym_declare_statement] = "declare_statement",
  [sym_create_function_statement] = "create_function_statement",
  [sym_external_hint] = "external_hint",
  [sym_optimizer_hint] = "optimizer_hint",
  [sym_parallel_hint] = "parallel_hint",
  [sym_null_hint] = "null_hint",
  [sym_deterministic_hint] = "deterministic_hint",
  [sym_sql_hint] = "sql_hint",
  [sym_sql_security_hint] = "sql_security_hint",
  [sym__function_language] = "_function_language",
  [sym__create_function_return_type] = "_create_function_return_type",
  [sym_setof] = "setof",
  [sym_constrained_type] = "constrained_type",
  [sym_create_function_parameter] = "create_function_parameter",
  [sym_create_function_parameters] = "create_function_parameters",
  [sym_function_body] = "function_body",
  [sym_create_trigger_statement] = "create_trigger_statement",
  [sym_trigger_reference] = "trigger_reference",
  [sym_trigger_preferencing] = "trigger_preferencing",
  [sym_trigger_time] = "trigger_time",
  [sym_trigger_event] = "trigger_event",
  [sym_trigger_condition] = "trigger_condition",
  [sym_trigger_order] = "trigger_order",
  [sym_trigger_body] = "trigger_body",
  [sym_create_extension_statement] = "create_extension_statement",
  [sym_create_role_statement] = "create_role_statement",
  [sym_create_schema_statement] = "create_schema_statement",
  [sym_drop_statement] = "drop_statement",
  [sym_set_statement] = "set_statement",
  [sym_grant_statement] = "grant_statement",
  [sym_create_domain_statement] = "create_domain_statement",
  [sym_create_type_statement] = "create_type_statement",
  [sym_type_spec_composite] = "type_spec_composite",
  [sym_type_spec_enum] = "type_spec_enum",
  [sym_type_spec_range] = "type_spec_range",
  [sym_type_spec_base] = "type_spec_base",
  [sym_create_index_with_clause] = "create_index_with_clause",
  [sym_create_index_include_clause] = "create_index_include_clause",
  [sym_create_index_statement] = "create_index_statement",
  [sym_table_column] = "table_column",
  [sym_auto_increment_constraint] = "auto_increment_constraint",
  [sym_direction_constraint] = "direction_constraint",
  [sym_named_constraint] = "named_constraint",
  [sym__column_default_expression] = "_column_default_expression",
  [sym_default_clause] = "default_clause",
  [sym_table_parameters] = "table_parameters",
  [sym_mode] = "mode",
  [sym_initial_mode] = "initial_mode",
  [sym__table_constraint] = "_table_constraint",
  [sym_table_constraint_check] = "check",
  [sym_op_class] = "op_class",
  [sym_exclude_entry] = "exclude_entry",
  [sym_table_constraint_exclude] = "exclude",
  [sym_table_constraint_foreign_key] = "foreign_key",
  [sym_table_constraint_unique] = "unique",
  [sym_table_constraint_primary_key] = "primary_key",
  [sym_primary_key_constraint] = "primary_key_constraint",
  [sym_create_table_statement] = "create_table_statement",
  [sym_using_clause] = "using_clause",
  [sym_index_table_parameters] = "index_table_parameters",
  [sym_create_view_statement] = "create_view_statement",
  [sym_view_columns] = "view_columns",
  [sym_view_option] = "view_option",
  [sym_view_options] = "view_options",
  [sym_view_check_option] = "view_check_option",
  [sym_view_body] = "view_body",
  [sym_create_materialized_view_statement] = "create_materialized_view_statement",
  [sym_tablespace_hint] = "tablespace_hint",
  [sym_data_hint] = "data_hint",
  [sym__select_statement] = "_select_statement",
  [sym_group_by_clause] = "group_by_clause",
  [sym_having_clause] = "having_clause",
  [sym_group_expression] = "group_expression",
  [sym_grouping_sets_clause] = "grouping_sets_clause",
  [sym_rollup_clause] = "rollup_clause",
  [sym_cube_clause] = "cube_clause",
  [sym_expression_list] = "expression_list",
  [sym_order_expression] = "order_expression",
  [sym_window_clause] = "window_clause",
  [sym_order_by_clause] = "order_by_clause",
  [sym_limit_clause] = "limit_clause",
  [sym_offset_clause] = "offset_clause",
  [sym_fetch_clause] = "fetch_clause",
  [sym_where_clause] = "where_clause",
  [sym__aliased_expression] = "alias",
  [sym__aliasable_expression] = "_aliasable_expression",
  [sym_select_clause_body] = "select_clause_body",
  [sym_select_clause] = "select_clause",
  [sym_from_clause] = "from_clause",
  [sym_join_type] = "join_type",
  [sym_join_clause] = "join_clause",
  [sym_select_subexpression] = "select_subexpression",
  [sym__update_statement] = "_update_statement",
  [sym_set_clause] = "set_clause",
  [sym_set_clause_body] = "set_clause_body",
  [sym_assigment_expression] = "assigment_expression",
  [sym__insert_statement] = "_insert_statement",
  [sym_values_clause] = "values_clause",
  [sym_values_clause_item] = "values_clause_item",
  [sym__delete_statement] = "_delete_statement",
  [sym_conditional_expression] = "conditional_expression",
  [sym_in_expression] = "in_expression",
  [sym_tuple] = "tuple",
  [sym_references_constraint] = "references_constraint",
  [sym_on_update_action] = "on_update_action",
  [sym_on_delete_action] = "on_delete_action",
  [sym__constraint_action] = "_constraint_action",
  [sym_unique_constraint] = "unique_constraint",
  [sym_null_constraint] = "null_constraint",
  [sym_check_constraint] = "check_constraint",
  [sym_function_call] = "function_call",
  [sym__function_call_arguments] = "_function_call_arguments",
  [sym_within_group_clause] = "within_group_clause",
  [sym_filter_clause] = "filter_clause",
  [sym_over_clause] = "over_clause",
  [sym_window_definition] = "window_definition",
  [sym_partition_by_clause] = "partition_by_clause",
  [sym_frame_clause] = "frame_clause",
  [sym_frame_kind] = "frame_kind",
  [sym_frame_bound] = "frame_bound",
  [sym_frame_exclusion] = "frame_exclusion",
  [sym__parenthesized_expression] = "_parenthesized_expression",
  [sym_is_expression] = "is_expression",
  [sym_distinct_from] = "distinct_from",
  [sym_boolean_expression] = "boolean_expression",
  [sym_at_time_zone_expression] = "at_time_zone_expression",
  [sym_NULL] = "NULL",
  [sym_TRUE] = "TRUE",
  [sym_FALSE] = "FALSE",
  [sym__quoted_identifier] = "_quoted_identifier",
  [sym_identifier] = "identifier",
  [sym_dotted_name] = "dotted_name",
  [sym__identifier] = "_identifier",
  [sym_string] = "string",
  [sym_json_access] = "json_access",
  [sym_ordered_expression] = "ordered_expression",
  [sym_type] = "type",
  [sym_array_type] = "array_type",
  [sym__type] = "_type",
  [sym_type_cast] = "type_cast",
  [sym_array_element_access] = "array_element_access",
  [sym_unary_expression] = "unary_expression",
  [sym_binary_expression] = "binary_expression",
  [sym_binary_operator] = "binary_operator",
  [sym_asterisk_expression] = "asterisk_expression",
  [sym_interval_expression] = "interval_expression",
  [sym_argument_reference] = "argument_reference",
  [sym__expression] = "_expression",
  [aux_sym_source_file_repeat1] = "source_file_repeat1",
  [aux_sym_with_clause_repeat1] = "with_clause_repeat1",
  [aux_sym_truncate_statement_repeat1] = "truncate_statement_repeat1",
  [aux_sym_sequence_repeat1] = "sequence_repeat1",
  [aux_sym__compound_statement_repeat1] = "_compound_statement_repeat1",
  [aux_sym_create_function_statement_repeat1] = "create_function_statement_repeat1",
  [aux_sym_create_function_statement_repeat2] = "create_function_statement_repeat2",
  [aux_sym_create_function_parameters_repeat1] = "create_function_parameters_repeat1",
  [aux_sym_trigger_preferencing_repeat1] = "trigger_preferencing_repeat1",
  [aux_sym_trigger_event_repeat1] = "trigger_event_repeat1",
  [aux_sym_trigger_body_repeat1] = "trigger_body_repeat1",
  [aux_sym_create_extension_statement_repeat1] = "create_extension_statement_repeat1",
  [aux_sym_grant_statement_repeat1] = "grant_statement_repeat1",
  [aux_sym_create_domain_statement_repeat1] = "create_domain_statement_repeat1",
  [aux_sym_type_spec_composite_repeat1] = "type_spec_composite_repeat1",
  [aux_sym_type_spec_range_repeat1] = "type_spec_range_repeat1",
  [aux_sym_type_spec_base_repeat1] = "type_spec_base_repeat1",
  [aux_sym_table_column_repeat1] = "table_column_repeat1",
  [aux_sym_table_parameters_repeat1] = "table_parameters_repeat1",
  [aux_sym_table_constraint_exclude_repeat1] = "table_constraint_exclude_repeat1",
  [aux_sym_index_table_parameters_repeat1] = "index_table_parameters_repeat1",
  [aux_sym_view_options_repeat1] = "view_options_repeat1",
  [aux_sym__select_statement_repeat1] = "_select_statement_repeat1",
  [aux_sym__select_statement_repeat2] = "_select_statement_repeat2",
  [aux_sym_group_by_clause_repeat1] = "group_by_clause_repeat1",
  [aux_sym_grouping_sets_clause_repeat1] = "grouping_sets_clause_repeat1",
  [aux_sym_rollup_clause_repeat1] = "rollup_clause_repeat1",
  [aux_sym_expression_list_repeat1] = "expression_list_repeat1",
  [aux_sym_order_by_clause_repeat1] = "order_by_clause_repeat1",
  [aux_sym_select_clause_body_repeat1] = "select_clause_body_repeat1",
  [aux_sym_from_clause_repeat1] = "from_clause_repeat1",
  [aux_sym_set_clause_body_repeat1] = "set_clause_body_repeat1",
  [aux_sym_values_clause_repeat1] = "values_clause_repeat1",
  [aux_sym_conditional_expression_repeat1] = "conditional_expression_repeat1",
  [aux_sym_references_constraint_repeat1] = "references_constraint_repeat1",
  [aux_sym_dotted_name_repeat1] = "dotted_name_repeat1",
  [aux_sym_type_repeat1] = "type_repeat1",
  [aux_sym_array_type_repeat1] = "array_type_repeat1",
  [anon_alias_sym_ALTER_COLUMN] = "ALTER_COLUMN",
  [anon_alias_sym_BY] = "BY",
  [anon_alias_sym_CHECK] = "CHECK",
  [anon_alias_sym_CREATE_EXTENSION] = "CREATE_EXTENSION",
  [anon_alias_sym_CREATE_SCHEMA] = "CREATE_SCHEMA",
  [anon_alias_sym_DEFERRABLE] = "DEFERRABLE",
  [anon_alias_sym_DEFINER] = "DEFINER",
  [anon_alias_sym_DISTINCT_FROM] = "DISTINCT_FROM",
  [anon_alias_sym_EXCLUDE_CURRENT_ROW] = "EXCLUDE_CURRENT_ROW",
  [anon_alias_sym_EXCLUDE_GROUP] = "EXCLUDE_GROUP",
  [anon_alias_sym_EXISTS] = "EXISTS",
  [anon_alias_sym_FUNCTION] = "FUNCTION",
  [anon_alias_sym_IF] = "IF",
  [anon_alias_sym_IF_EXISTS] = "IF_EXISTS",
  [anon_alias_sym_INVOKER] = "INVOKER",
  [anon_alias_sym_MATERIALIZED] = "MATERIALIZED",
  [anon_alias_sym_MATERIALIZED_VIEW] = "MATERIALIZED_VIEW",
  [anon_alias_sym_NOT] = "NOT",
  [anon_alias_sym_NO_SQL] = "NO_SQL",
  [anon_alias_sym_NULL] = "NULL",
  [anon_alias_sym_OF] = "OF",
  [anon_alias_sym_ON_DELETE] = "ON_DELETE",
  [anon_alias_sym_ON_UPDATE] = "ON_UPDATE",
  [anon_alias_sym_OR] = "OR",
  [anon_alias_sym_PRECEDING] = "PRECEDING",
  [anon_alias_sym_PROCEDURE] = "PROCEDURE",
  [anon_alias_sym_RENAME_TO] = "RENAME_TO",
  [anon_alias_sym_SET_DEFAULT] = "SET_DEFAULT",
  [anon_alias_sym_SET_NULL] = "SET_NULL",
  [anon_alias_sym_UNBOUNDED_FOLLOWING] = "UNBOUNDED_FOLLOWING",
  [anon_alias_sym_WITH] = "WITH",
  [anon_alias_sym_WITHOUT] = "WITHOUT",
  [alias_sym_alter_sequence] = "alter_sequence",
  [anon_alias_sym_default] = "default",
  [alias_sym_default] = "default",
  [alias_sym_version] = "version",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [anon_sym_SEMI] = anon_sym_SEMI,
  [aux_sym_with_clause_token1] = aux_sym_with_clause_token1,
  [aux_sym_with_clause_token2] = aux_sym_with_clause_token2,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [aux_sym_cte_token1] = aux_sym_cte_token1,
  [aux_sym_cte_token2] = aux_sym_cte_token2,
  [aux_sym_cte_token3] = aux_sym_cte_token3,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [aux_sym_truncate_statement_token1] = aux_sym_truncate_statement_token1,
  [aux_sym_truncate_statement_token2] = aux_sym_truncate_statement_token2,
  [aux_sym_truncate_statement_token3] = aux_sym_truncate_statement_token3,
  [aux_sym_comment_statement_token1] = aux_sym_comment_statement_token1,
  [aux_sym_comment_statement_token2] = aux_sym_comment_statement_token2,
  [aux_sym_comment_statement_token3] = aux_sym_comment_statement_token3,
  [aux_sym_comment_statement_token4] = aux_sym_comment_statement_token4,
  [aux_sym_comment_statement_token5] = aux_sym_comment_statement_token5,
  [aux_sym_comment_statement_token6] = aux_sym_comment_statement_token6,
  [aux_sym_comment_statement_token7] = aux_sym_comment_statement_token7,
  [aux_sym_begin_statement_token1] = aux_sym_begin_statement_token1,
  [aux_sym_begin_statement_token2] = aux_sym_begin_statement_token2,
  [aux_sym_begin_statement_token3] = aux_sym_begin_statement_token3,
  [aux_sym_commit_statement_token1] = aux_sym_commit_statement_token1,
  [aux_sym_rollback_statement_token1] = aux_sym_rollback_statement_token1,
  [aux_sym_create_statement_token1] = aux_sym_create_statement_token1,
  [aux_sym_create_statement_token2] = aux_sym_create_statement_token2,
  [aux_sym_create_statement_token3] = aux_sym_create_statement_token3,
  [aux_sym_alter_statement_token1] = aux_sym_alter_statement_token1,
  [aux_sym_alter_table_token1] = aux_sym_cte_token2,
  [aux_sym_alter_table_token2] = aux_sym_cte_token2,
  [aux_sym_alter_schema_rename_action_token1] = aux_sym_alter_schema_rename_action_token1,
  [aux_sym_alter_schema_rename_action_token2] = aux_sym_alter_schema_rename_action_token2,
  [aux_sym_alter_owner_action_token1] = aux_sym_alter_owner_action_token1,
  [anon_sym_CURRENT_USER] = anon_sym_CURRENT_USER,
  [anon_sym_CURRENT_ROLE] = anon_sym_CURRENT_ROLE,
  [anon_sym_SESSION_USER] = anon_sym_SESSION_USER,
  [aux_sym_alter_table_action_alter_column_token1] = aux_sym_alter_table_action_alter_column_token1,
  [aux_sym_alter_table_action_alter_column_token2] = aux_sym_alter_table_action_alter_column_token2,
  [aux_sym_alter_table_action_add_token1] = aux_sym_alter_table_action_add_token1,
  [aux_sym_sequence_token1] = aux_sym_sequence_token1,
  [aux_sym_sequence_token2] = aux_sym_sequence_token2,
  [aux_sym_sequence_token3] = aux_sym_sequence_token3,
  [aux_sym_sequence_token4] = aux_sym_sequence_token4,
  [aux_sym_sequence_token5] = aux_sym_sequence_token5,
  [aux_sym_sequence_token6] = aux_sym_sequence_token6,
  [aux_sym_sequence_token7] = aux_sym_sequence_token7,
  [aux_sym_sequence_token8] = aux_sym_sequence_token8,
  [aux_sym_sequence_token9] = aux_sym_sequence_token9,
  [aux_sym_pg_command_token1] = aux_sym_pg_command_token1,
  [aux_sym_pg_command_token2] = aux_sym_pg_command_token2,
  [anon_sym_COLON] = anon_sym_COLON,
  [aux_sym__compound_statement_token1] = aux_sym__compound_statement_token1,
  [aux_sym__compound_statement_token2] = aux_sym__compound_statement_token2,
  [aux_sym_return_statement_token1] = aux_sym_return_statement_token1,
  [aux_sym_declare_statement_token1] = aux_sym_declare_statement_token1,
  [aux_sym_create_function_statement_token1] = aux_sym_create_function_statement_token1,
  [aux_sym_create_function_statement_token2] = aux_sym_create_function_statement_token2,
  [aux_sym_create_function_statement_token3] = aux_sym_create_function_statement_token3,
  [aux_sym_create_function_statement_token4] = aux_sym_create_function_statement_token4,
  [aux_sym_create_function_statement_token5] = aux_sym_create_function_statement_token5,
  [aux_sym_create_function_statement_token6] = aux_sym_create_function_statement_token6,
  [aux_sym_create_function_statement_token7] = aux_sym_create_function_statement_token7,
  [aux_sym_create_function_statement_token8] = aux_sym_create_function_statement_token8,
  [aux_sym_create_function_statement_token9] = aux_sym_create_function_statement_token9,
  [aux_sym_create_function_statement_token10] = aux_sym_create_function_statement_token10,
  [aux_sym_create_function_statement_token11] = aux_sym_create_function_statement_token11,
  [aux_sym_external_hint_token1] = aux_sym_external_hint_token1,
  [aux_sym_external_hint_token2] = aux_sym_external_hint_token2,
  [aux_sym_external_hint_token3] = aux_sym_external_hint_token2,
  [aux_sym_external_hint_token4] = aux_sym_external_hint_token4,
  [aux_sym_optimizer_hint_token1] = aux_sym_optimizer_hint_token1,
  [aux_sym_optimizer_hint_token2] = aux_sym_optimizer_hint_token2,
  [aux_sym_optimizer_hint_token3] = aux_sym_optimizer_hint_token3,
  [aux_sym_parallel_hint_token1] = aux_sym_parallel_hint_token1,
  [aux_sym_parallel_hint_token2] = aux_sym_parallel_hint_token2,
  [aux_sym_parallel_hint_token3] = aux_sym_parallel_hint_token3,
  [aux_sym_parallel_hint_token4] = aux_sym_parallel_hint_token4,
  [aux_sym_null_hint_token1] = aux_sym_null_hint_token1,
  [aux_sym_null_hint_token2] = aux_sym_null_hint_token2,
  [aux_sym_null_hint_token3] = aux_sym_null_hint_token3,
  [aux_sym_null_hint_token4] = aux_sym_null_hint_token4,
  [aux_sym_deterministic_hint_token1] = aux_sym_deterministic_hint_token1,
  [aux_sym_sql_hint_token1] = aux_sym_sql_hint_token1,
  [aux_sym_sql_hint_token2] = aux_sym_sql_hint_token2,
  [aux_sym_sql_hint_token3] = aux_sym_sql_hint_token3,
  [aux_sym_sql_hint_token4] = aux_sym_sql_hint_token4,
  [aux_sym_sql_hint_token5] = aux_sym_sql_hint_token5,
  [aux_sym__function_language_token1] = aux_sym__function_language_token1,
  [aux_sym__function_language_token2] = aux_sym__function_language_token2,
  [aux_sym__function_language_token3] = aux_sym__function_language_token2,
  [aux_sym_setof_token1] = aux_sym_setof_token1,
  [aux_sym_create_function_parameter_token1] = aux_sym_create_function_parameter_token1,
  [aux_sym_create_function_parameter_token2] = aux_sym_create_function_parameter_token2,
  [aux_sym_create_function_parameter_token3] = aux_sym_create_function_parameter_token3,
  [aux_sym_create_function_parameter_token4] = aux_sym_create_function_parameter_token4,
  [anon_sym_EQ] = anon_sym_EQ,
  [aux_sym_create_trigger_statement_token1] = aux_sym_create_trigger_statement_token1,
  [aux_sym_create_trigger_statement_token2] = aux_sym_create_trigger_statement_token1,
  [aux_sym_create_trigger_statement_token3] = anon_sym_CONSTRAINT,
  [aux_sym_create_trigger_statement_token4] = aux_sym_create_trigger_statement_token4,
  [aux_sym_create_trigger_statement_token5] = aux_sym_create_trigger_statement_token5,
  [aux_sym_create_trigger_statement_token6] = aux_sym_create_trigger_statement_token6,
  [aux_sym_create_trigger_statement_token7] = aux_sym_create_trigger_statement_token7,
  [aux_sym_trigger_reference_token1] = aux_sym_trigger_reference_token1,
  [aux_sym_trigger_preferencing_token1] = aux_sym_trigger_preferencing_token1,
  [aux_sym_trigger_preferencing_token2] = aux_sym_trigger_preferencing_token2,
  [aux_sym_trigger_preferencing_token3] = aux_sym_trigger_preferencing_token3,
  [aux_sym_trigger_time_token1] = aux_sym_trigger_time_token1,
  [aux_sym_trigger_time_token2] = aux_sym_trigger_time_token2,
  [aux_sym_trigger_time_token3] = aux_sym_trigger_time_token3,
  [aux_sym_trigger_time_token4] = aux_sym_trigger_time_token3,
  [aux_sym_trigger_event_token1] = aux_sym_trigger_event_token1,
  [aux_sym_trigger_event_token2] = aux_sym_trigger_event_token2,
  [aux_sym_trigger_event_token3] = aux_sym_trigger_event_token3,
  [aux_sym_trigger_condition_token1] = aux_sym_trigger_condition_token1,
  [aux_sym_trigger_order_token1] = aux_sym_trigger_order_token1,
  [aux_sym_trigger_order_token2] = aux_sym_trigger_order_token2,
  [aux_sym_trigger_body_token1] = aux_sym_trigger_body_token1,
  [aux_sym_create_extension_statement_token1] = aux_sym_create_extension_statement_token1,
  [aux_sym_create_extension_statement_token2] = aux_sym_create_extension_statement_token2,
  [aux_sym_create_role_statement_token1] = aux_sym_create_role_statement_token1,
  [aux_sym_drop_statement_token1] = aux_sym_drop_statement_token1,
  [aux_sym_drop_statement_token2] = aux_sym_drop_statement_token2,
  [aux_sym_drop_statement_token3] = aux_sym_drop_statement_token3,
  [aux_sym_drop_statement_token4] = aux_sym_drop_statement_token4,
  [aux_sym_drop_statement_token5] = aux_sym_drop_statement_token5,
  [aux_sym_drop_statement_token6] = aux_sym_drop_statement_token6,
  [aux_sym_set_statement_token1] = aux_sym_set_statement_token1,
  [aux_sym_set_statement_token2] = aux_sym_set_statement_token2,
  [aux_sym_grant_statement_token1] = aux_sym_grant_statement_token1,
  [aux_sym_grant_statement_token2] = aux_sym_grant_statement_token2,
  [aux_sym_grant_statement_token3] = aux_sym_grant_statement_token3,
  [aux_sym_grant_statement_token4] = aux_sym_grant_statement_token4,
  [aux_sym_grant_statement_token5] = aux_sym_grant_statement_token5,
  [aux_sym_grant_statement_token6] = aux_sym_grant_statement_token6,
  [aux_sym_grant_statement_token7] = aux_sym_grant_statement_token7,
  [aux_sym_grant_statement_token8] = aux_sym_grant_statement_token8,
  [aux_sym_grant_statement_token9] = aux_sym_grant_statement_token9,
  [aux_sym_grant_statement_token10] = aux_sym_with_clause_token1,
  [aux_sym_create_domain_statement_token1] = aux_sym_create_domain_statement_token1,
  [aux_sym_type_spec_enum_token1] = aux_sym_type_spec_enum_token1,
  [aux_sym_type_spec_range_token1] = aux_sym_type_spec_range_token1,
  [aux_sym_type_spec_range_token2] = aux_sym_type_spec_range_token2,
  [aux_sym_type_spec_range_token3] = aux_sym_type_spec_range_token3,
  [aux_sym_type_spec_range_token4] = aux_sym_type_spec_range_token4,
  [aux_sym_type_spec_range_token5] = aux_sym_type_spec_range_token5,
  [aux_sym_type_spec_range_token6] = aux_sym_type_spec_range_token6,
  [aux_sym_type_spec_range_token7] = aux_sym_type_spec_range_token7,
  [aux_sym_type_spec_base_token1] = aux_sym_type_spec_base_token1,
  [aux_sym_type_spec_base_token2] = aux_sym_type_spec_base_token2,
  [aux_sym_type_spec_base_token3] = aux_sym_type_spec_base_token3,
  [aux_sym_type_spec_base_token4] = aux_sym_type_spec_base_token4,
  [aux_sym_type_spec_base_token5] = aux_sym_type_spec_base_token5,
  [aux_sym_type_spec_base_token6] = aux_sym_type_spec_base_token6,
  [aux_sym_type_spec_base_token7] = aux_sym_type_spec_base_token7,
  [aux_sym_type_spec_base_token8] = aux_sym_type_spec_base_token8,
  [aux_sym_type_spec_base_token9] = aux_sym_type_spec_base_token9,
  [aux_sym_type_spec_base_token10] = aux_sym_type_spec_base_token10,
  [aux_sym_type_spec_base_token11] = aux_sym_type_spec_base_token11,
  [aux_sym_type_spec_base_token12] = aux_sym_type_spec_base_token12,
  [aux_sym_type_spec_base_token13] = aux_sym_type_spec_base_token13,
  [aux_sym_type_spec_base_token14] = aux_sym_type_spec_base_token14,
  [aux_sym_type_spec_base_token15] = aux_sym_type_spec_base_token15,
  [aux_sym_type_spec_base_token16] = aux_sym_type_spec_base_token16,
  [aux_sym_type_spec_base_token17] = aux_sym_type_spec_base_token17,
  [aux_sym_type_spec_base_token18] = aux_sym_type_spec_base_token18,
  [aux_sym_create_index_include_clause_token1] = aux_sym_create_index_include_clause_token1,
  [aux_sym_auto_increment_constraint_token1] = aux_sym_auto_increment_constraint_token1,
  [aux_sym_direction_constraint_token1] = aux_sym_direction_constraint_token1,
  [aux_sym_direction_constraint_token2] = aux_sym_direction_constraint_token2,
  [anon_sym_CONSTRAINT] = anon_sym_CONSTRAINT,
  [aux_sym_mode_token1] = aux_sym_mode_token1,
  [aux_sym_initial_mode_token1] = aux_sym_initial_mode_token1,
  [aux_sym_initial_mode_token2] = aux_sym_initial_mode_token2,
  [aux_sym_initial_mode_token3] = aux_sym_initial_mode_token3,
  [aux_sym_table_constraint_check_token1] = aux_sym_table_constraint_check_token1,
  [aux_sym_table_constraint_exclude_token1] = aux_sym_table_constraint_exclude_token1,
  [aux_sym_table_constraint_exclude_token2] = aux_sym_table_constraint_exclude_token2,
  [aux_sym_table_constraint_foreign_key_token1] = aux_sym_table_constraint_foreign_key_token1,
  [aux_sym_table_constraint_foreign_key_token2] = aux_sym_table_constraint_foreign_key_token2,
  [aux_sym_table_constraint_unique_token1] = aux_sym_table_constraint_unique_token1,
  [aux_sym_table_constraint_primary_key_token1] = aux_sym_table_constraint_foreign_key_token2,
  [aux_sym_create_table_statement_token1] = aux_sym_create_table_statement_token1,
  [aux_sym_create_table_statement_token2] = aux_sym_create_table_statement_token1,
  [aux_sym_view_check_option_token1] = aux_sym_view_check_option_token1,
  [aux_sym_having_clause_token1] = aux_sym_having_clause_token1,
  [aux_sym_grouping_sets_clause_token1] = aux_sym_grouping_sets_clause_token1,
  [aux_sym_grouping_sets_clause_token2] = aux_sym_grouping_sets_clause_token1,
  [aux_sym_rollup_clause_token1] = aux_sym_rollup_clause_token1,
  [aux_sym_cube_clause_token1] = aux_sym_cube_clause_token1,
  [aux_sym_order_expression_token1] = aux_sym_order_expression_token1,
  [aux_sym_order_expression_token2] = aux_sym_order_expression_token2,
  [aux_sym_order_expression_token3] = aux_sym_order_expression_token3,
  [aux_sym_order_by_clause_token1] = aux_sym_order_by_clause_token1,
  [aux_sym_limit_clause_token1] = aux_sym_limit_clause_token1,
  [aux_sym_offset_clause_token1] = aux_sym_offset_clause_token1,
  [aux_sym_fetch_clause_token1] = aux_sym_fetch_clause_token1,
  [aux_sym_fetch_clause_token2] = aux_sym_fetch_clause_token2,
  [aux_sym_where_clause_token1] = aux_sym_where_clause_token1,
  [aux_sym_select_clause_body_token1] = aux_sym_select_clause_body_token1,
  [aux_sym_join_type_token1] = aux_sym_join_type_token1,
  [aux_sym_join_type_token2] = aux_sym_join_type_token2,
  [aux_sym_join_type_token3] = aux_sym_join_type_token3,
  [aux_sym_join_type_token4] = aux_sym_join_type_token4,
  [aux_sym_join_type_token5] = aux_sym_join_type_token5,
  [aux_sym_join_clause_token1] = aux_sym_join_clause_token1,
  [aux_sym_select_subexpression_token1] = aux_sym_select_subexpression_token1,
  [aux_sym_values_clause_token1] = aux_sym_values_clause_token1,
  [aux_sym_conditional_expression_token1] = aux_sym_conditional_expression_token1,
  [aux_sym_conditional_expression_token2] = aux_sym_conditional_expression_token2,
  [aux_sym_conditional_expression_token3] = aux_sym_conditional_expression_token3,
  [aux_sym__function_call_arguments_token1] = aux_sym__function_call_arguments_token1,
  [aux_sym_within_group_clause_token1] = aux_sym_within_group_clause_token1,
  [aux_sym_filter_clause_token1] = aux_sym_filter_clause_token1,
  [aux_sym_over_clause_token1] = aux_sym_over_clause_token1,
  [aux_sym_partition_by_clause_token1] = aux_sym_partition_by_clause_token1,
  [aux_sym_frame_clause_token1] = aux_sym_frame_clause_token1,
  [aux_sym_frame_clause_token2] = aux_sym_frame_clause_token2,
  [aux_sym_frame_kind_token1] = aux_sym_frame_kind_token1,
  [aux_sym_frame_bound_token1] = aux_sym_frame_bound_token1,
  [aux_sym_frame_bound_token2] = aux_sym_frame_bound_token1,
  [aux_sym_frame_bound_token3] = aux_sym_frame_bound_token3,
  [aux_sym_frame_bound_token4] = aux_sym_frame_bound_token4,
  [aux_sym_frame_exclusion_token1] = aux_sym_frame_exclusion_token1,
  [aux_sym_frame_exclusion_token2] = aux_sym_frame_exclusion_token2,
  [aux_sym_at_time_zone_expression_token1] = aux_sym_at_time_zone_expression_token1,
  [aux_sym_at_time_zone_expression_token2] = aux_sym_at_time_zone_expression_token2,
  [aux_sym_at_time_zone_expression_token3] = aux_sym_at_time_zone_expression_token2,
  [aux_sym_TRUE_token1] = aux_sym_TRUE_token1,
  [aux_sym_FALSE_token1] = aux_sym_FALSE_token1,
  [sym_number] = sym_number,
  [sym__unquoted_identifier] = sym__unquoted_identifier,
  [anon_sym_BQUOTE] = anon_sym_BQUOTE,
  [aux_sym__quoted_identifier_token1] = aux_sym__quoted_identifier_token1,
  [anon_sym_DQUOTE] = anon_sym_DQUOTE,
  [aux_sym__quoted_identifier_token2] = aux_sym__quoted_identifier_token2,
  [anon_sym_DOT] = anon_sym_DOT,
  [anon_sym_SQUOTE] = anon_sym_SQUOTE,
  [aux_sym_string_token1] = sym__dollar_quoted_string_content,
  [anon_sym_DASH_GT] = anon_sym_DASH_GT,
  [anon_sym_DASH_GT_GT] = anon_sym_DASH_GT_GT,
  [anon_sym_POUND_GT] = anon_sym_POUND_GT,
  [anon_sym_POUND_GT_GT] = anon_sym_POUND_GT_GT,
  [aux_sym_type_token1] = aux_sym_type_token1,
  [aux_sym_type_token2] = aux_sym_type_token2,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_COLON_COLON] = anon_sym_COLON_COLON,
  [sym_comment] = sym_comment,
  [anon_sym_PLUS] = anon_sym_PLUS,
  [anon_sym_DASH] = anon_sym_DASH,
  [anon_sym_BANG_BANG] = anon_sym_BANG_BANG,
  [anon_sym_TILDE] = anon_sym_TILDE,
  [anon_sym_AT] = anon_sym_AT,
  [anon_sym_PIPE_SLASH] = anon_sym_PIPE_SLASH,
  [anon_sym_PIPE_PIPE_SLASH] = anon_sym_PIPE_PIPE_SLASH,
  [anon_sym_CARET] = anon_sym_CARET,
  [anon_sym_STAR] = anon_sym_STAR,
  [anon_sym_SLASH] = anon_sym_SLASH,
  [anon_sym_PERCENT] = anon_sym_PERCENT,
  [anon_sym_LT_LT] = anon_sym_LT_LT,
  [anon_sym_GT_GT] = anon_sym_GT_GT,
  [anon_sym_AMP] = anon_sym_AMP,
  [anon_sym_PIPE] = anon_sym_PIPE,
  [anon_sym_POUND] = anon_sym_POUND,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_LT_EQ] = anon_sym_LT_EQ,
  [anon_sym_LT_GT] = anon_sym_LT_GT,
  [anon_sym_BANG_EQ] = anon_sym_BANG_EQ,
  [anon_sym_GT] = anon_sym_GT,
  [anon_sym_GT_EQ] = anon_sym_GT_EQ,
  [anon_sym_BANG_TILDE] = anon_sym_BANG_TILDE,
  [anon_sym_TILDE_STAR] = anon_sym_TILDE_STAR,
  [anon_sym_BANG_TILDE_STAR] = anon_sym_BANG_TILDE_STAR,
  [anon_sym_AMP_AMP] = anon_sym_AMP_AMP,
  [anon_sym_PIPE_PIPE] = anon_sym_PIPE_PIPE,
  [anon_sym_DOT_STAR] = anon_sym_DOT_STAR,
  [aux_sym_interval_expression_token1] = aux_sym_interval_expression_token1,
  [anon_sym_DOLLAR] = anon_sym_DOLLAR,
  [aux_sym_argument_reference_token1] = aux_sym_argument_reference_token1,
  [sym__dollar_quoted_string_tag] = sym__dollar_quoted_string_tag,
  [sym__dollar_quoted_string_content] = sym__dollar_quoted_string_content,
  [sym__dollar_quoted_string_end_tag] = sym__dollar_quoted_string_end_tag,
  [sym_source_file] = sym_source_file,
  [sym__statement] = sym__statement,
  [sym__simple_statement] = sym__simple_statement,
  [sym_with_clause] = sym_with_clause,
  [sym_cte] = sym_cte,
  [sym_select_statement] = sym_select_statement,
  [sym_insert_statement] = sym_insert_statement,
  [sym_update_statement] = sym_update_statement,
  [sym_delete_statement] = sym_delete_statement,
  [sym_truncate_statement] = sym_truncate_statement,
  [sym_comment_statement] = sym_comment_statement,
  [sym_begin_statement] = sym_begin_statement,
  [sym_commit_statement] = sym_commit_statement,
  [sym_rollback_statement] = sym_rollback_statement,
  [sym_create_statement] = sym_create_statement,
  [sym_alter_statement] = sym_alter_statement,
  [sym_alter_table] = sym_alter_table,
  [sym_alter_schema_rename_action] = sym_alter_schema_rename_action,
  [sym_alter_owner_action] = sym_alter_owner_action,
  [sym_alter_schema] = sym_alter_schema,
  [sym_alter_table_action_alter_column] = sym_alter_table_action_alter_column,
  [sym_alter_table_action_add] = sym_alter_table_action_add,
  [sym_alter_table_action_set] = sym_alter_table_action_set,
  [sym_alter_table_rename_column] = sym_alter_table_rename_column,
  [sym_alter_table_action] = sym_alter_table_action,
  [sym_sequence] = sym_sequence,
  [sym_pg_command] = sym_pg_command,
  [sym__compound_statement] = sym__compound_statement,
  [sym_return_statement] = sym_return_statement,
  [sym_declare_statement] = sym_declare_statement,
  [sym_create_function_statement] = sym_create_function_statement,
  [sym_external_hint] = sym_external_hint,
  [sym_optimizer_hint] = sym_optimizer_hint,
  [sym_parallel_hint] = sym_parallel_hint,
  [sym_null_hint] = sym_null_hint,
  [sym_deterministic_hint] = sym_deterministic_hint,
  [sym_sql_hint] = sym_sql_hint,
  [sym_sql_security_hint] = sym_sql_security_hint,
  [sym__function_language] = sym__function_language,
  [sym__create_function_return_type] = sym__create_function_return_type,
  [sym_setof] = sym_setof,
  [sym_constrained_type] = sym_constrained_type,
  [sym_create_function_parameter] = sym_create_function_parameter,
  [sym_create_function_parameters] = sym_create_function_parameters,
  [sym_function_body] = sym_function_body,
  [sym_create_trigger_statement] = sym_create_trigger_statement,
  [sym_trigger_reference] = sym_trigger_reference,
  [sym_trigger_preferencing] = sym_trigger_preferencing,
  [sym_trigger_time] = sym_trigger_time,
  [sym_trigger_event] = sym_trigger_event,
  [sym_trigger_condition] = sym_trigger_condition,
  [sym_trigger_order] = sym_trigger_order,
  [sym_trigger_body] = sym_trigger_body,
  [sym_create_extension_statement] = sym_create_extension_statement,
  [sym_create_role_statement] = sym_create_role_statement,
  [sym_create_schema_statement] = sym_create_schema_statement,
  [sym_drop_statement] = sym_drop_statement,
  [sym_set_statement] = sym_set_statement,
  [sym_grant_statement] = sym_grant_statement,
  [sym_create_domain_statement] = sym_create_domain_statement,
  [sym_create_type_statement] = sym_create_type_statement,
  [sym_type_spec_composite] = sym_type_spec_composite,
  [sym_type_spec_enum] = sym_type_spec_enum,
  [sym_type_spec_range] = sym_type_spec_range,
  [sym_type_spec_base] = sym_type_spec_base,
  [sym_create_index_with_clause] = sym_create_index_with_clause,
  [sym_create_index_include_clause] = sym_create_index_include_clause,
  [sym_create_index_statement] = sym_create_index_statement,
  [sym_table_column] = sym_table_column,
  [sym_auto_increment_constraint] = sym_auto_increment_constraint,
  [sym_direction_constraint] = sym_direction_constraint,
  [sym_named_constraint] = sym_named_constraint,
  [sym__column_default_expression] = sym__column_default_expression,
  [sym_default_clause] = sym_default_clause,
  [sym_table_parameters] = sym_table_parameters,
  [sym_mode] = sym_mode,
  [sym_initial_mode] = sym_initial_mode,
  [sym__table_constraint] = sym__table_constraint,
  [sym_table_constraint_check] = sym_table_constraint_check,
  [sym_op_class] = sym_op_class,
  [sym_exclude_entry] = sym_exclude_entry,
  [sym_table_constraint_exclude] = sym_table_constraint_exclude,
  [sym_table_constraint_foreign_key] = sym_table_constraint_foreign_key,
  [sym_table_constraint_unique] = sym_table_constraint_unique,
  [sym_table_constraint_primary_key] = sym_table_constraint_primary_key,
  [sym_primary_key_constraint] = sym_primary_key_constraint,
  [sym_create_table_statement] = sym_create_table_statement,
  [sym_using_clause] = sym_using_clause,
  [sym_index_table_parameters] = sym_index_table_parameters,
  [sym_create_view_statement] = sym_create_view_statement,
  [sym_view_columns] = sym_view_columns,
  [sym_view_option] = sym_view_option,
  [sym_view_options] = sym_view_options,
  [sym_view_check_option] = sym_view_check_option,
  [sym_view_body] = sym_view_body,
  [sym_create_materialized_view_statement] = sym_create_materialized_view_statement,
  [sym_tablespace_hint] = sym_tablespace_hint,
  [sym_data_hint] = sym_data_hint,
  [sym__select_statement] = sym__select_statement,
  [sym_group_by_clause] = sym_group_by_clause,
  [sym_having_clause] = sym_having_clause,
  [sym_group_expression] = sym_group_expression,
  [sym_grouping_sets_clause] = sym_grouping_sets_clause,
  [sym_rollup_clause] = sym_rollup_clause,
  [sym_cube_clause] = sym_cube_clause,
  [sym_expression_list] = sym_expression_list,
  [sym_order_expression] = sym_order_expression,
  [sym_window_clause] = sym_window_clause,
  [sym_order_by_clause] = sym_order_by_clause,
  [sym_limit_clause] = sym_limit_clause,
  [sym_offset_clause] = sym_offset_clause,
  [sym_fetch_clause] = sym_fetch_clause,
  [sym_where_clause] = sym_where_clause,
  [sym__aliased_expression] = sym__aliased_expression,
  [sym__aliasable_expression] = sym__aliasable_expression,
  [sym_select_clause_body] = sym_select_clause_body,
  [sym_select_clause] = sym_select_clause,
  [sym_from_clause] = sym_from_clause,
  [sym_join_type] = sym_join_type,
  [sym_join_clause] = sym_join_clause,
  [sym_select_subexpression] = sym_select_subexpression,
  [sym__update_statement] = sym__update_statement,
  [sym_set_clause] = sym_set_clause,
  [sym_set_clause_body] = sym_set_clause_body,
  [sym_assigment_expression] = sym_assigment_expression,
  [sym__insert_statement] = sym__insert_statement,
  [sym_values_clause] = sym_values_clause,
  [sym_values_clause_item] = sym_values_clause_item,
  [sym__delete_statement] = sym__delete_statement,
  [sym_conditional_expression] = sym_conditional_expression,
  [sym_in_expression] = sym_in_expression,
  [sym_tuple] = sym_tuple,
  [sym_references_constraint] = sym_references_constraint,
  [sym_on_update_action] = sym_on_update_action,
  [sym_on_delete_action] = sym_on_delete_action,
  [sym__constraint_action] = sym__constraint_action,
  [sym_unique_constraint] = sym_unique_constraint,
  [sym_null_constraint] = sym_null_constraint,
  [sym_check_constraint] = sym_check_constraint,
  [sym_function_call] = sym_function_call,
  [sym__function_call_arguments] = sym__function_call_arguments,
  [sym_within_group_clause] = sym_within_group_clause,
  [sym_filter_clause] = sym_filter_clause,
  [sym_over_clause] = sym_over_clause,
  [sym_window_definition] = sym_window_definition,
  [sym_partition_by_clause] = sym_partition_by_clause,
  [sym_frame_clause] = sym_frame_clause,
  [sym_frame_kind] = sym_frame_kind,
  [sym_frame_bound] = sym_frame_bound,
  [sym_frame_exclusion] = sym_frame_exclusion,
  [sym__parenthesized_expression] = sym__parenthesized_expression,
  [sym_is_expression] = sym_is_expression,
  [sym_distinct_from] = sym_distinct_from,
  [sym_boolean_expression] = sym_boolean_expression,
  [sym_at_time_zone_expression] = sym_at_time_zone_expression,
  [sym_NULL] = sym_NULL,
  [sym_TRUE] = sym_TRUE,
  [sym_FALSE] = sym_FALSE,
  [sym__quoted_identifier] = sym__quoted_identifier,
  [sym_identifier] = sym_identifier,
  [sym_dotted_name] = sym_dotted_name,
  [sym__identifier] = sym__identifier,
  [sym_string] = sym_string,
  [sym_json_access] = sym_json_access,
  [sym_ordered_expression] = sym_ordered_expression,
  [sym_type] = sym_type,
  [sym_array_type] = sym_array_type,
  [sym__type] = sym__type,
  [sym_type_cast] = sym_type_cast,
  [sym_array_element_access] = sym_array_element_access,
  [sym_unary_expression] = sym_unary_expression,
  [sym_binary_expression] = sym_binary_expression,
  [sym_binary_operator] = sym_binary_operator,
  [sym_asterisk_expression] = sym_asterisk_expression,
  [sym_interval_expression] = sym_interval_expression,
  [sym_argument_reference] = sym_argument_reference,
  [sym__expression] = sym__expression,
  [aux_sym_source_file_repeat1] = aux_sym_source_file_repeat1,
  [aux_sym_with_clause_repeat1] = aux_sym_with_clause_repeat1,
  [aux_sym_truncate_statement_repeat1] = aux_sym_truncate_statement_repeat1,
  [aux_sym_sequence_repeat1] = aux_sym_sequence_repeat1,
  [aux_sym__compound_statement_repeat1] = aux_sym__compound_statement_repeat1,
  [aux_sym_create_function_statement_repeat1] = aux_sym_create_function_statement_repeat1,
  [aux_sym_create_function_statement_repeat2] = aux_sym_create_function_statement_repeat2,
  [aux_sym_create_function_parameters_repeat1] = aux_sym_create_function_parameters_repeat1,
  [aux_sym_trigger_preferencing_repeat1] = aux_sym_trigger_preferencing_repeat1,
  [aux_sym_trigger_event_repeat1] = aux_sym_trigger_event_repeat1,
  [aux_sym_trigger_body_repeat1] = aux_sym_trigger_body_repeat1,
  [aux_sym_create_extension_statement_repeat1] = aux_sym_create_extension_statement_repeat1,
  [aux_sym_grant_statement_repeat1] = aux_sym_grant_statement_repeat1,
  [aux_sym_create_domain_statement_repeat1] = aux_sym_create_domain_statement_repeat1,
  [aux_sym_type_spec_composite_repeat1] = aux_sym_type_spec_composite_repeat1,
  [aux_sym_type_spec_range_repeat1] = aux_sym_type_spec_range_repeat1,
  [aux_sym_type_spec_base_repeat1] = aux_sym_type_spec_base_repeat1,
  [aux_sym_table_column_repeat1] = aux_sym_table_column_repeat1,
  [aux_sym_table_parameters_repeat1] = aux_sym_table_parameters_repeat1,
  [aux_sym_table_constraint_exclude_repeat1] = aux_sym_table_constraint_exclude_repeat1,
  [aux_sym_index_table_parameters_repeat1] = aux_sym_index_table_parameters_repeat1,
  [aux_sym_view_options_repeat1] = aux_sym_view_options_repeat1,
  [aux_sym__select_statement_repeat1] = aux_sym__select_statement_repeat1,
  [aux_sym__select_statement_repeat2] = aux_sym__select_statement_repeat2,
  [aux_sym_group_by_clause_repeat1] = aux_sym_group_by_clause_repeat1,
  [aux_sym_grouping_sets_clause_repeat1] = aux_sym_grouping_sets_clause_repeat1,
  [aux_sym_rollup_clause_repeat1] = aux_sym_rollup_clause_repeat1,
  [aux_sym_expression_list_repeat1] = aux_sym_expression_list_repeat1,
  [aux_sym_order_by_clause_repeat1] = aux_sym_order_by_clause_repeat1,
  [aux_sym_select_clause_body_repeat1] = aux_sym_select_clause_body_repeat1,
  [aux_sym_from_clause_repeat1] = aux_sym_from_clause_repeat1,
  [aux_sym_set_clause_body_repeat1] = aux_sym_set_clause_body_repeat1,
  [aux_sym_values_clause_repeat1] = aux_sym_values_clause_repeat1,
  [aux_sym_conditional_expression_repeat1] = aux_sym_conditional_expression_repeat1,
  [aux_sym_references_constraint_repeat1] = aux_sym_references_constraint_repeat1,
  [aux_sym_dotted_name_repeat1] = aux_sym_dotted_name_repeat1,
  [aux_sym_type_repeat1] = aux_sym_type_repeat1,
  [aux_sym_array_type_repeat1] = aux_sym_array_type_repeat1,
  [anon_alias_sym_ALTER_COLUMN] = anon_alias_sym_ALTER_COLUMN,
  [anon_alias_sym_BY] = anon_alias_sym_BY,
  [anon_alias_sym_CHECK] = anon_alias_sym_CHECK,
  [anon_alias_sym_CREATE_EXTENSION] = anon_alias_sym_CREATE_EXTENSION,
  [anon_alias_sym_CREATE_SCHEMA] = anon_alias_sym_CREATE_SCHEMA,
  [anon_alias_sym_DEFERRABLE] = anon_alias_sym_DEFERRABLE,
  [anon_alias_sym_DEFINER] = anon_alias_sym_DEFINER,
  [anon_alias_sym_DISTINCT_FROM] = anon_alias_sym_DISTINCT_FROM,
  [anon_alias_sym_EXCLUDE_CURRENT_ROW] = anon_alias_sym_EXCLUDE_CURRENT_ROW,
  [anon_alias_sym_EXCLUDE_GROUP] = anon_alias_sym_EXCLUDE_GROUP,
  [anon_alias_sym_EXISTS] = anon_alias_sym_EXISTS,
  [anon_alias_sym_FUNCTION] = anon_alias_sym_FUNCTION,
  [anon_alias_sym_IF] = anon_alias_sym_IF,
  [anon_alias_sym_IF_EXISTS] = anon_alias_sym_IF_EXISTS,
  [anon_alias_sym_INVOKER] = anon_alias_sym_INVOKER,
  [anon_alias_sym_MATERIALIZED] = anon_alias_sym_MATERIALIZED,
  [anon_alias_sym_MATERIALIZED_VIEW] = anon_alias_sym_MATERIALIZED_VIEW,
  [anon_alias_sym_NOT] = anon_alias_sym_NOT,
  [anon_alias_sym_NO_SQL] = anon_alias_sym_NO_SQL,
  [anon_alias_sym_NULL] = anon_alias_sym_NULL,
  [anon_alias_sym_OF] = anon_alias_sym_OF,
  [anon_alias_sym_ON_DELETE] = anon_alias_sym_ON_DELETE,
  [anon_alias_sym_ON_UPDATE] = anon_alias_sym_ON_UPDATE,
  [anon_alias_sym_OR] = anon_alias_sym_OR,
  [anon_alias_sym_PRECEDING] = anon_alias_sym_PRECEDING,
  [anon_alias_sym_PROCEDURE] = anon_alias_sym_PROCEDURE,
  [anon_alias_sym_RENAME_TO] = anon_alias_sym_RENAME_TO,
  [anon_alias_sym_SET_DEFAULT] = anon_alias_sym_SET_DEFAULT,
  [anon_alias_sym_SET_NULL] = anon_alias_sym_SET_NULL,
  [anon_alias_sym_UNBOUNDED_FOLLOWING] = anon_alias_sym_UNBOUNDED_FOLLOWING,
  [anon_alias_sym_WITH] = anon_alias_sym_WITH,
  [anon_alias_sym_WITHOUT] = anon_alias_sym_WITHOUT,
  [alias_sym_alter_sequence] = alias_sym_alter_sequence,
  [anon_alias_sym_default] = anon_alias_sym_default,
  [alias_sym_default] = alias_sym_default,
  [alias_sym_version] = alias_sym_version,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [anon_sym_SEMI] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_with_clause_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_with_clause_token2] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_cte_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_cte_token2] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_cte_token3] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_truncate_statement_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_truncate_statement_token2] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_truncate_statement_token3] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_comment_statement_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_comment_statement_token2] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_comment_statement_token3] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_comment_statement_token4] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_comment_statement_token5] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_comment_statement_token6] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_comment_statement_token7] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_begin_statement_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_begin_statement_token2] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_begin_statement_token3] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_commit_statement_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_rollback_statement_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_create_statement_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_create_statement_token2] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_create_statement_token3] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_alter_statement_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_alter_table_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_alter_table_token2] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_alter_schema_rename_action_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_alter_schema_rename_action_token2] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_alter_owner_action_token1] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CURRENT_USER] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CURRENT_ROLE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SESSION_USER] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_alter_table_action_alter_column_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_alter_table_action_alter_column_token2] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_alter_table_action_add_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_sequence_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_sequence_token2] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_sequence_token3] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_sequence_token4] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_sequence_token5] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_sequence_token6] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_sequence_token7] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_sequence_token8] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_sequence_token9] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_pg_command_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_pg_command_token2] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [aux_sym__compound_statement_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym__compound_statement_token2] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_return_statement_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_declare_statement_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_create_function_statement_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_create_function_statement_token2] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_create_function_statement_token3] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_create_function_statement_token4] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_create_function_statement_token5] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_create_function_statement_token6] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_create_function_statement_token7] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_create_function_statement_token8] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_create_function_statement_token9] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_create_function_statement_token10] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_create_function_statement_token11] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_external_hint_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_external_hint_token2] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_external_hint_token3] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_external_hint_token4] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_optimizer_hint_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_optimizer_hint_token2] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_optimizer_hint_token3] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_parallel_hint_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_parallel_hint_token2] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_parallel_hint_token3] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_parallel_hint_token4] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_null_hint_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_null_hint_token2] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_null_hint_token3] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_null_hint_token4] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_deterministic_hint_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_sql_hint_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_sql_hint_token2] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_sql_hint_token3] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_sql_hint_token4] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_sql_hint_token5] = {
    .visible = true,
    .named = false,
  },
  [aux_sym__function_language_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym__function_language_token2] = {
    .visible = true,
    .named = true,
  },
  [aux_sym__function_language_token3] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_setof_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_create_function_parameter_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_create_function_parameter_token2] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_create_function_parameter_token3] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_create_function_parameter_token4] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_create_trigger_statement_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_create_trigger_statement_token2] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_create_trigger_statement_token3] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_create_trigger_statement_token4] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_create_trigger_statement_token5] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_create_trigger_statement_token6] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_create_trigger_statement_token7] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_trigger_reference_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_trigger_preferencing_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_trigger_preferencing_token2] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_trigger_preferencing_token3] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_trigger_time_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_trigger_time_token2] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_trigger_time_token3] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_trigger_time_token4] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_trigger_event_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_trigger_event_token2] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_trigger_event_token3] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_trigger_condition_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_trigger_order_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_trigger_order_token2] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_trigger_body_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_create_extension_statement_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_create_extension_statement_token2] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_create_role_statement_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_drop_statement_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_drop_statement_token2] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_drop_statement_token3] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_drop_statement_token4] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_drop_statement_token5] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_drop_statement_token6] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_set_statement_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_set_statement_token2] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_grant_statement_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_grant_statement_token2] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_grant_statement_token3] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_grant_statement_token4] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_grant_statement_token5] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_grant_statement_token6] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_grant_statement_token7] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_grant_statement_token8] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_grant_statement_token9] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_grant_statement_token10] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_create_domain_statement_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_type_spec_enum_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_type_spec_range_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_type_spec_range_token2] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_type_spec_range_token3] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_type_spec_range_token4] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_type_spec_range_token5] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_type_spec_range_token6] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_type_spec_range_token7] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_type_spec_base_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_type_spec_base_token2] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_type_spec_base_token3] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_type_spec_base_token4] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_type_spec_base_token5] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_type_spec_base_token6] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_type_spec_base_token7] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_type_spec_base_token8] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_type_spec_base_token9] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_type_spec_base_token10] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_type_spec_base_token11] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_type_spec_base_token12] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_type_spec_base_token13] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_type_spec_base_token14] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_type_spec_base_token15] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_type_spec_base_token16] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_type_spec_base_token17] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_type_spec_base_token18] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_create_index_include_clause_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_auto_increment_constraint_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_direction_constraint_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_direction_constraint_token2] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CONSTRAINT] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_mode_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_initial_mode_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_initial_mode_token2] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_initial_mode_token3] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_table_constraint_check_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_table_constraint_exclude_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_table_constraint_exclude_token2] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_table_constraint_foreign_key_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_table_constraint_foreign_key_token2] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_table_constraint_unique_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_table_constraint_primary_key_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_create_table_statement_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_create_table_statement_token2] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_view_check_option_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_having_clause_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_grouping_sets_clause_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_grouping_sets_clause_token2] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_rollup_clause_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_cube_clause_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_order_expression_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_order_expression_token2] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_order_expression_token3] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_order_by_clause_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_limit_clause_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_offset_clause_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_fetch_clause_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_fetch_clause_token2] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_where_clause_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_select_clause_body_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_join_type_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_join_type_token2] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_join_type_token3] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_join_type_token4] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_join_type_token5] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_join_clause_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_select_subexpression_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_values_clause_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_conditional_expression_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_conditional_expression_token2] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_conditional_expression_token3] = {
    .visible = true,
    .named = false,
  },
  [aux_sym__function_call_arguments_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_within_group_clause_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_filter_clause_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_over_clause_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_partition_by_clause_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_frame_clause_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_frame_clause_token2] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_frame_kind_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_frame_bound_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_frame_bound_token2] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_frame_bound_token3] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_frame_bound_token4] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_frame_exclusion_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_frame_exclusion_token2] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_at_time_zone_expression_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_at_time_zone_expression_token2] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_at_time_zone_expression_token3] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_TRUE_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_FALSE_token1] = {
    .visible = true,
    .named = false,
  },
  [sym_number] = {
    .visible = true,
    .named = true,
  },
  [sym__unquoted_identifier] = {
    .visible = false,
    .named = true,
  },
  [anon_sym_BQUOTE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym__quoted_identifier_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym__quoted_identifier_token2] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SQUOTE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_string_token1] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_DASH_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_GT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_POUND_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_POUND_GT_GT] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_type_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_type_token2] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON_COLON] = {
    .visible = true,
    .named = false,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_BANG] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_TILDE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_PIPE_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_POUND] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_TILDE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_TILDE_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_TILDE_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT_STAR] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_interval_expression_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_DOLLAR] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_argument_reference_token1] = {
    .visible = false,
    .named = false,
  },
  [sym__dollar_quoted_string_tag] = {
    .visible = false,
    .named = true,
  },
  [sym__dollar_quoted_string_content] = {
    .visible = true,
    .named = true,
  },
  [sym__dollar_quoted_string_end_tag] = {
    .visible = false,
    .named = true,
  },
  [sym_source_file] = {
    .visible = true,
    .named = true,
  },
  [sym__statement] = {
    .visible = false,
    .named = true,
  },
  [sym__simple_statement] = {
    .visible = false,
    .named = true,
  },
  [sym_with_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_cte] = {
    .visible = true,
    .named = true,
  },
  [sym_select_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_insert_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_update_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_delete_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_truncate_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_comment_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_begin_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_commit_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_rollback_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_create_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_alter_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_alter_table] = {
    .visible = true,
    .named = true,
  },
  [sym_alter_schema_rename_action] = {
    .visible = true,
    .named = true,
  },
  [sym_alter_owner_action] = {
    .visible = true,
    .named = true,
  },
  [sym_alter_schema] = {
    .visible = true,
    .named = true,
  },
  [sym_alter_table_action_alter_column] = {
    .visible = true,
    .named = true,
  },
  [sym_alter_table_action_add] = {
    .visible = true,
    .named = true,
  },
  [sym_alter_table_action_set] = {
    .visible = true,
    .named = true,
  },
  [sym_alter_table_rename_column] = {
    .visible = true,
    .named = true,
  },
  [sym_alter_table_action] = {
    .visible = true,
    .named = true,
  },
  [sym_sequence] = {
    .visible = true,
    .named = true,
  },
  [sym_pg_command] = {
    .visible = true,
    .named = true,
  },
  [sym__compound_statement] = {
    .visible = false,
    .named = true,
  },
  [sym_return_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_declare_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_create_function_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_external_hint] = {
    .visible = true,
    .named = true,
  },
  [sym_optimizer_hint] = {
    .visible = true,
    .named = true,
  },
  [sym_parallel_hint] = {
    .visible = true,
    .named = true,
  },
  [sym_null_hint] = {
    .visible = true,
    .named = true,
  },
  [sym_deterministic_hint] = {
    .visible = true,
    .named = true,
  },
  [sym_sql_hint] = {
    .visible = true,
    .named = true,
  },
  [sym_sql_security_hint] = {
    .visible = true,
    .named = true,
  },
  [sym__function_language] = {
    .visible = false,
    .named = true,
  },
  [sym__create_function_return_type] = {
    .visible = false,
    .named = true,
  },
  [sym_setof] = {
    .visible = true,
    .named = true,
  },
  [sym_constrained_type] = {
    .visible = true,
    .named = true,
  },
  [sym_create_function_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_create_function_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym_function_body] = {
    .visible = true,
    .named = true,
  },
  [sym_create_trigger_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_trigger_reference] = {
    .visible = true,
    .named = true,
  },
  [sym_trigger_preferencing] = {
    .visible = true,
    .named = true,
  },
  [sym_trigger_time] = {
    .visible = true,
    .named = true,
  },
  [sym_trigger_event] = {
    .visible = true,
    .named = true,
  },
  [sym_trigger_condition] = {
    .visible = true,
    .named = true,
  },
  [sym_trigger_order] = {
    .visible = true,
    .named = true,
  },
  [sym_trigger_body] = {
    .visible = true,
    .named = true,
  },
  [sym_create_extension_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_create_role_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_create_schema_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_drop_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_set_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_grant_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_create_domain_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_create_type_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_type_spec_composite] = {
    .visible = true,
    .named = true,
  },
  [sym_type_spec_enum] = {
    .visible = true,
    .named = true,
  },
  [sym_type_spec_range] = {
    .visible = true,
    .named = true,
  },
  [sym_type_spec_base] = {
    .visible = true,
    .named = true,
  },
  [sym_create_index_with_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_create_index_include_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_create_index_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_table_column] = {
    .visible = true,
    .named = true,
  },
  [sym_auto_increment_constraint] = {
    .visible = true,
    .named = true,
  },
  [sym_direction_constraint] = {
    .visible = true,
    .named = true,
  },
  [sym_named_constraint] = {
    .visible = true,
    .named = true,
  },
  [sym__column_default_expression] = {
    .visible = false,
    .named = true,
  },
  [sym_default_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_table_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym_mode] = {
    .visible = true,
    .named = true,
  },
  [sym_initial_mode] = {
    .visible = true,
    .named = true,
  },
  [sym__table_constraint] = {
    .visible = false,
    .named = true,
  },
  [sym_table_constraint_check] = {
    .visible = true,
    .named = true,
  },
  [sym_op_class] = {
    .visible = true,
    .named = true,
  },
  [sym_exclude_entry] = {
    .visible = true,
    .named = true,
  },
  [sym_table_constraint_exclude] = {
    .visible = true,
    .named = true,
  },
  [sym_table_constraint_foreign_key] = {
    .visible = true,
    .named = true,
  },
  [sym_table_constraint_unique] = {
    .visible = true,
    .named = true,
  },
  [sym_table_constraint_primary_key] = {
    .visible = true,
    .named = true,
  },
  [sym_primary_key_constraint] = {
    .visible = true,
    .named = true,
  },
  [sym_create_table_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_using_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_index_table_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym_create_view_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_view_columns] = {
    .visible = true,
    .named = true,
  },
  [sym_view_option] = {
    .visible = true,
    .named = true,
  },
  [sym_view_options] = {
    .visible = true,
    .named = true,
  },
  [sym_view_check_option] = {
    .visible = true,
    .named = true,
  },
  [sym_view_body] = {
    .visible = true,
    .named = true,
  },
  [sym_create_materialized_view_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_tablespace_hint] = {
    .visible = true,
    .named = true,
  },
  [sym_data_hint] = {
    .visible = true,
    .named = true,
  },
  [sym__select_statement] = {
    .visible = false,
    .named = true,
  },
  [sym_group_by_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_having_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_group_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_grouping_sets_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_rollup_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_cube_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_expression_list] = {
    .visible = true,
    .named = true,
  },
  [sym_order_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_window_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_order_by_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_limit_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_offset_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_fetch_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_where_clause] = {
    .visible = true,
    .named = true,
  },
  [sym__aliased_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__aliasable_expression] = {
    .visible = false,
    .named = true,
  },
  [sym_select_clause_body] = {
    .visible = true,
    .named = true,
  },
  [sym_select_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_from_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_join_type] = {
    .visible = true,
    .named = true,
  },
  [sym_join_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_select_subexpression] = {
    .visible = true,
    .named = true,
  },
  [sym__update_statement] = {
    .visible = false,
    .named = true,
  },
  [sym_set_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_set_clause_body] = {
    .visible = true,
    .named = true,
  },
  [sym_assigment_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__insert_statement] = {
    .visible = false,
    .named = true,
  },
  [sym_values_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_values_clause_item] = {
    .visible = true,
    .named = true,
  },
  [sym__delete_statement] = {
    .visible = false,
    .named = true,
  },
  [sym_conditional_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_in_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_tuple] = {
    .visible = true,
    .named = true,
  },
  [sym_references_constraint] = {
    .visible = true,
    .named = true,
  },
  [sym_on_update_action] = {
    .visible = true,
    .named = true,
  },
  [sym_on_delete_action] = {
    .visible = true,
    .named = true,
  },
  [sym__constraint_action] = {
    .visible = false,
    .named = true,
  },
  [sym_unique_constraint] = {
    .visible = true,
    .named = true,
  },
  [sym_null_constraint] = {
    .visible = true,
    .named = true,
  },
  [sym_check_constraint] = {
    .visible = true,
    .named = true,
  },
  [sym_function_call] = {
    .visible = true,
    .named = true,
  },
  [sym__function_call_arguments] = {
    .visible = false,
    .named = true,
  },
  [sym_within_group_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_filter_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_over_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_window_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_partition_by_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_frame_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_frame_kind] = {
    .visible = true,
    .named = true,
  },
  [sym_frame_bound] = {
    .visible = true,
    .named = true,
  },
  [sym_frame_exclusion] = {
    .visible = true,
    .named = true,
  },
  [sym__parenthesized_expression] = {
    .visible = false,
    .named = true,
  },
  [sym_is_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_distinct_from] = {
    .visible = true,
    .named = true,
  },
  [sym_boolean_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_at_time_zone_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_NULL] = {
    .visible = true,
    .named = true,
  },
  [sym_TRUE] = {
    .visible = true,
    .named = true,
  },
  [sym_FALSE] = {
    .visible = true,
    .named = true,
  },
  [sym__quoted_identifier] = {
    .visible = false,
    .named = true,
  },
  [sym_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_dotted_name] = {
    .visible = true,
    .named = true,
  },
  [sym__identifier] = {
    .visible = false,
    .named = true,
  },
  [sym_string] = {
    .visible = true,
    .named = true,
  },
  [sym_json_access] = {
    .visible = true,
    .named = true,
  },
  [sym_ordered_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_type] = {
    .visible = true,
    .named = true,
  },
  [sym_array_type] = {
    .visible = true,
    .named = true,
  },
  [sym__type] = {
    .visible = false,
    .named = true,
  },
  [sym_type_cast] = {
    .visible = true,
    .named = true,
  },
  [sym_array_element_access] = {
    .visible = true,
    .named = true,
  },
  [sym_unary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_binary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_binary_operator] = {
    .visible = true,
    .named = true,
  },
  [sym_asterisk_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_interval_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_argument_reference] = {
    .visible = true,
    .named = true,
  },
  [sym__expression] = {
    .visible = false,
    .named = true,
  },
  [aux_sym_source_file_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_with_clause_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_truncate_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_sequence_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__compound_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_create_function_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_create_function_statement_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_create_function_parameters_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_trigger_preferencing_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_trigger_event_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_trigger_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_create_extension_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_grant_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_create_domain_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_type_spec_composite_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_type_spec_range_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_type_spec_base_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_table_column_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_table_parameters_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_table_constraint_exclude_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_index_table_parameters_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_view_options_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__select_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__select_statement_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_group_by_clause_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_grouping_sets_clause_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_rollup_clause_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_expression_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_order_by_clause_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_select_clause_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_from_clause_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_set_clause_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_values_clause_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_conditional_expression_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_references_constraint_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_dotted_name_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_type_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_array_type_repeat1] = {
    .visible = false,
    .named = false,
  },
  [anon_alias_sym_ALTER_COLUMN] = {
    .visible = true,
    .named = false,
  },
  [anon_alias_sym_BY] = {
    .visible = true,
    .named = false,
  },
  [anon_alias_sym_CHECK] = {
    .visible = true,
    .named = false,
  },
  [anon_alias_sym_CREATE_EXTENSION] = {
    .visible = true,
    .named = false,
  },
  [anon_alias_sym_CREATE_SCHEMA] = {
    .visible = true,
    .named = false,
  },
  [anon_alias_sym_DEFERRABLE] = {
    .visible = true,
    .named = false,
  },
  [anon_alias_sym_DEFINER] = {
    .visible = true,
    .named = false,
  },
  [anon_alias_sym_DISTINCT_FROM] = {
    .visible = true,
    .named = false,
  },
  [anon_alias_sym_EXCLUDE_CURRENT_ROW] = {
    .visible = true,
    .named = false,
  },
  [anon_alias_sym_EXCLUDE_GROUP] = {
    .visible = true,
    .named = false,
  },
  [anon_alias_sym_EXISTS] = {
    .visible = true,
    .named = false,
  },
  [anon_alias_sym_FUNCTION] = {
    .visible = true,
    .named = false,
  },
  [anon_alias_sym_IF] = {
    .visible = true,
    .named = false,
  },
  [anon_alias_sym_IF_EXISTS] = {
    .visible = true,
    .named = false,
  },
  [anon_alias_sym_INVOKER] = {
    .visible = true,
    .named = false,
  },
  [anon_alias_sym_MATERIALIZED] = {
    .visible = true,
    .named = false,
  },
  [anon_alias_sym_MATERIALIZED_VIEW] = {
    .visible = true,
    .named = false,
  },
  [anon_alias_sym_NOT] = {
    .visible = true,
    .named = false,
  },
  [anon_alias_sym_NO_SQL] = {
    .visible = true,
    .named = false,
  },
  [anon_alias_sym_NULL] = {
    .visible = true,
    .named = false,
  },
  [anon_alias_sym_OF] = {
    .visible = true,
    .named = false,
  },
  [anon_alias_sym_ON_DELETE] = {
    .visible = true,
    .named = false,
  },
  [anon_alias_sym_ON_UPDATE] = {
    .visible = true,
    .named = false,
  },
  [anon_alias_sym_OR] = {
    .visible = true,
    .named = false,
  },
  [anon_alias_sym_PRECEDING] = {
    .visible = true,
    .named = false,
  },
  [anon_alias_sym_PROCEDURE] = {
    .visible = true,
    .named = false,
  },
  [anon_alias_sym_RENAME_TO] = {
    .visible = true,
    .named = false,
  },
  [anon_alias_sym_SET_DEFAULT] = {
    .visible = true,
    .named = false,
  },
  [anon_alias_sym_SET_NULL] = {
    .visible = true,
    .named = false,
  },
  [anon_alias_sym_UNBOUNDED_FOLLOWING] = {
    .visible = true,
    .named = false,
  },
  [anon_alias_sym_WITH] = {
    .visible = true,
    .named = false,
  },
  [anon_alias_sym_WITHOUT] = {
    .visible = true,
    .named = false,
  },
  [alias_sym_alter_sequence] = {
    .visible = true,
    .named = true,
  },
  [anon_alias_sym_default] = {
    .visible = true,
    .named = false,
  },
  [alias_sym_default] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_version] = {
    .visible = true,
    .named = true,
  },
};

enum {
  field_action = 1,
  field_argmode = 2,
  field_arguments = 3,
  field_begin_label = 4,
  field_content = 5,
  field_elements = 6,
  field_end_label = 7,
  field_frame_end = 8,
  field_frame_start = 9,
  field_function = 10,
  field_into = 11,
  field_kind = 12,
  field_left = 13,
  field_link_symbol = 14,
  field_method = 15,
  field_name = 16,
  field_obj_file = 17,
  field_on_table = 18,
  field_operand = 19,
  field_operator = 20,
  field_order = 21,
  field_replace = 22,
  field_right = 23,
  field_scope = 24,
  field_script = 25,
  field_storage_parameter = 26,
  field_table_name = 27,
  field_target = 28,
  field_type = 29,
  field_type_name = 30,
  field_value = 31,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_action] = "action",
  [field_argmode] = "argmode",
  [field_arguments] = "arguments",
  [field_begin_label] = "begin_label",
  [field_content] = "content",
  [field_elements] = "elements",
  [field_end_label] = "end_label",
  [field_frame_end] = "frame_end",
  [field_frame_start] = "frame_start",
  [field_function] = "function",
  [field_into] = "into",
  [field_kind] = "kind",
  [field_left] = "left",
  [field_link_symbol] = "link_symbol",
  [field_method] = "method",
  [field_name] = "name",
  [field_obj_file] = "obj_file",
  [field_on_table] = "on_table",
  [field_operand] = "operand",
  [field_operator] = "operator",
  [field_order] = "order",
  [field_replace] = "replace",
  [field_right] = "right",
  [field_scope] = "scope",
  [field_script] = "script",
  [field_storage_parameter] = "storage_parameter",
  [field_table_name] = "table_name",
  [field_target] = "target",
  [field_type] = "type",
  [field_type_name] = "type_name",
  [field_value] = "value",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [6] = {.index = 0, .length = 1},
  [9] = {.index = 1, .length = 2},
  [11] = {.index = 3, .length = 2},
  [12] = {.index = 5, .length = 1},
  [13] = {.index = 6, .length = 1},
  [18] = {.index = 7, .length = 3},
  [19] = {.index = 10, .length = 2},
  [20] = {.index = 12, .length = 3},
  [21] = {.index = 15, .length = 1},
  [22] = {.index = 16, .length = 1},
  [23] = {.index = 17, .length = 2},
  [24] = {.index = 19, .length = 1},
  [25] = {.index = 20, .length = 1},
  [26] = {.index = 21, .length = 3},
  [33] = {.index = 24, .length = 2},
  [35] = {.index = 26, .length = 1},
  [36] = {.index = 26, .length = 1},
  [37] = {.index = 27, .length = 1},
  [38] = {.index = 28, .length = 1},
  [39] = {.index = 29, .length = 1},
  [40] = {.index = 30, .length = 3},
  [41] = {.index = 33, .length = 4},
  [42] = {.index = 37, .length = 2},
  [43] = {.index = 39, .length = 3},
  [44] = {.index = 42, .length = 1},
  [45] = {.index = 43, .length = 2},
  [46] = {.index = 45, .length = 2},
  [51] = {.index = 47, .length = 1},
  [54] = {.index = 48, .length = 2},
  [55] = {.index = 50, .length = 1},
  [56] = {.index = 51, .length = 1},
  [64] = {.index = 52, .length = 1},
  [65] = {.index = 53, .length = 2},
  [69] = {.index = 55, .length = 3},
  [70] = {.index = 58, .length = 4},
  [71] = {.index = 62, .length = 3},
  [72] = {.index = 65, .length = 2},
  [73] = {.index = 67, .length = 2},
  [74] = {.index = 69, .length = 1},
  [76] = {.index = 70, .length = 1},
  [79] = {.index = 71, .length = 1},
  [80] = {.index = 72, .length = 2},
  [81] = {.index = 74, .length = 2},
  [85] = {.index = 76, .length = 2},
  [91] = {.index = 78, .length = 1},
  [92] = {.index = 79, .length = 2},
  [95] = {.index = 81, .length = 1},
  [96] = {.index = 82, .length = 1},
  [97] = {.index = 83, .length = 2},
  [98] = {.index = 85, .length = 2},
  [99] = {.index = 87, .length = 4},
  [100] = {.index = 91, .length = 3},
  [101] = {.index = 94, .length = 3},
  [102] = {.index = 97, .length = 1},
  [104] = {.index = 98, .length = 2},
  [105] = {.index = 100, .length = 1},
  [107] = {.index = 50, .length = 1},
  [109] = {.index = 101, .length = 1},
  [112] = {.index = 102, .length = 1},
  [113] = {.index = 102, .length = 1},
  [114] = {.index = 102, .length = 1},
  [115] = {.index = 102, .length = 1},
  [116] = {.index = 102, .length = 1},
  [117] = {.index = 102, .length = 1},
  [118] = {.index = 102, .length = 1},
  [119] = {.index = 102, .length = 1},
  [120] = {.index = 102, .length = 1},
  [121] = {.index = 102, .length = 1},
  [122] = {.index = 102, .length = 1},
  [123] = {.index = 102, .length = 1},
  [124] = {.index = 102, .length = 1},
  [125] = {.index = 102, .length = 1},
  [126] = {.index = 102, .length = 1},
  [127] = {.index = 102, .length = 1},
  [128] = {.index = 102, .length = 1},
  [129] = {.index = 102, .length = 1},
  [130] = {.index = 102, .length = 1},
  [131] = {.index = 103, .length = 2},
  [133] = {.index = 105, .length = 2},
  [134] = {.index = 107, .length = 1},
  [135] = {.index = 108, .length = 2},
  [136] = {.index = 110, .length = 4},
  [138] = {.index = 114, .length = 1},
  [145] = {.index = 50, .length = 1},
  [146] = {.index = 115, .length = 1},
  [148] = {.index = 116, .length = 1},
  [149] = {.index = 117, .length = 2},
  [150] = {.index = 117, .length = 2},
  [151] = {.index = 117, .length = 2},
  [152] = {.index = 117, .length = 2},
  [153] = {.index = 117, .length = 2},
  [154] = {.index = 117, .length = 2},
  [155] = {.index = 117, .length = 2},
  [156] = {.index = 117, .length = 2},
  [157] = {.index = 117, .length = 2},
  [158] = {.index = 117, .length = 2},
  [159] = {.index = 117, .length = 2},
  [160] = {.index = 117, .length = 2},
  [161] = {.index = 117, .length = 2},
  [162] = {.index = 117, .length = 2},
  [163] = {.index = 117, .length = 2},
  [164] = {.index = 117, .length = 2},
  [165] = {.index = 117, .length = 2},
  [166] = {.index = 117, .length = 2},
  [167] = {.index = 117, .length = 2},
  [168] = {.index = 119, .length = 2},
  [169] = {.index = 121, .length = 2},
  [170] = {.index = 123, .length = 2},
  [172] = {.index = 19, .length = 1},
  [180] = {.index = 125, .length = 2},
  [181] = {.index = 127, .length = 1},
  [182] = {.index = 127, .length = 1},
  [183] = {.index = 127, .length = 1},
  [184] = {.index = 127, .length = 1},
  [185] = {.index = 127, .length = 1},
  [186] = {.index = 127, .length = 1},
  [187] = {.index = 128, .length = 2},
  [188] = {.index = 130, .length = 2},
  [189] = {.index = 132, .length = 2},
  [190] = {.index = 19, .length = 1},
  [191] = {.index = 97, .length = 1},
  [195] = {.index = 134, .length = 2},
  [198] = {.index = 136, .length = 1},
  [199] = {.index = 136, .length = 1},
  [200] = {.index = 137, .length = 2},
  [201] = {.index = 139, .length = 2},
  [202] = {.index = 139, .length = 2},
  [203] = {.index = 139, .length = 2},
  [204] = {.index = 139, .length = 2},
  [205] = {.index = 139, .length = 2},
  [206] = {.index = 139, .length = 2},
  [207] = {.index = 141, .length = 2},
  [208] = {.index = 143, .length = 1},
  [209] = {.index = 144, .length = 2},
  [210] = {.index = 146, .length = 2},
  [211] = {.index = 97, .length = 1},
  [212] = {.index = 114, .length = 1},
  [217] = {.index = 148, .length = 2},
  [218] = {.index = 150, .length = 1},
  [219] = {.index = 150, .length = 1},
  [220] = {.index = 151, .length = 2},
  [221] = {.index = 114, .length = 1},
  [224] = {.index = 102, .length = 1},
  [225] = {.index = 102, .length = 1},
  [226] = {.index = 102, .length = 1},
  [227] = {.index = 102, .length = 1},
  [228] = {.index = 102, .length = 1},
  [229] = {.index = 102, .length = 1},
  [230] = {.index = 153, .length = 2},
  [231] = {.index = 155, .length = 2},
  [232] = {.index = 155, .length = 2},
  [235] = {.index = 157, .length = 2},
  [236] = {.index = 159, .length = 3},
  [237] = {.index = 159, .length = 3},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_type_name, 2},
  [1] =
    {field_kind, 1},
    {field_target, 2},
  [3] =
    {field_operand, 1},
    {field_operator, 0},
  [5] =
    {field_into, 1, .inherited = true},
  [6] =
    {field_name, 1},
  [7] =
    {field_kind, 1},
    {field_kind, 2},
    {field_target, 3},
  [10] =
    {field_kind, 1},
    {field_target, 3},
  [12] =
    {field_kind, 1},
    {field_target, 2},
    {field_target, 3},
  [15] =
    {field_content, 1},
  [16] =
    {field_into, 2},
  [17] =
    {field_into, 0, .inherited = true},
    {field_into, 1, .inherited = true},
  [19] =
    {field_type, 2},
  [20] =
    {field_function, 0},
  [21] =
    {field_left, 0},
    {field_operator, 1},
    {field_right, 2},
  [24] =
    {field_begin_label, 0, .inherited = true},
    {field_end_label, 0, .inherited = true},
  [26] =
    {field_replace, 1},
  [27] =
    {field_table_name, 3},
  [28] =
    {field_name, 1, .inherited = true},
  [29] =
    {field_scope, 1},
  [30] =
    {field_kind, 1},
    {field_kind, 2},
    {field_target, 4},
  [33] =
    {field_kind, 1},
    {field_kind, 2},
    {field_target, 3},
    {field_target, 4},
  [37] =
    {field_kind, 1},
    {field_target, 4},
  [39] =
    {field_kind, 1},
    {field_target, 3},
    {field_target, 4},
  [42] =
    {field_function, 1},
  [43] =
    {field_into, 2},
    {field_into, 3, .inherited = true},
  [45] =
    {field_arguments, 2},
    {field_function, 0},
  [47] =
    {field_method, 1},
  [48] =
    {field_name, 0},
    {field_type, 1},
  [50] =
    {field_argmode, 0},
  [51] =
    {field_script, 1},
  [52] =
    {field_table_name, 4},
  [53] =
    {field_name, 2},
    {field_table_name, 4},
  [55] =
    {field_kind, 1},
    {field_kind, 2},
    {field_target, 5},
  [58] =
    {field_kind, 1},
    {field_kind, 2},
    {field_target, 4},
    {field_target, 5},
  [62] =
    {field_kind, 1},
    {field_target, 4},
    {field_target, 5},
  [65] =
    {field_kind, 1},
    {field_target, 5},
  [67] =
    {field_arguments, 3},
    {field_function, 1},
  [69] =
    {field_into, 3},
  [70] =
    {field_elements, 1},
  [71] =
    {field_name, 2, .inherited = true},
  [72] =
    {field_name, 0, .inherited = true},
    {field_name, 1, .inherited = true},
  [74] =
    {field_name, 1, .inherited = true},
    {field_name, 2, .inherited = true},
  [76] =
    {field_link_symbol, 2},
    {field_obj_file, 1},
  [78] =
    {field_value, 2, .inherited = true},
  [79] =
    {field_value, 0, .inherited = true},
    {field_value, 1, .inherited = true},
  [81] =
    {field_order, 1},
  [82] =
    {field_table_name, 5},
  [83] =
    {field_name, 3},
    {field_table_name, 5},
  [85] =
    {field_name, 2},
    {field_table_name, 5},
  [87] =
    {field_kind, 1},
    {field_kind, 2},
    {field_target, 5},
    {field_target, 6},
  [91] =
    {field_kind, 1},
    {field_kind, 2},
    {field_target, 6},
  [94] =
    {field_kind, 1},
    {field_target, 5},
    {field_target, 6},
  [97] =
    {field_type, 3},
  [98] =
    {field_elements, 1},
    {field_elements, 2},
  [100] =
    {field_frame_start, 1},
  [101] =
    {field_end_label, 3},
  [102] =
    {field_value, 3},
  [103] =
    {field_name, 2},
    {field_on_table, 6},
  [105] =
    {field_name, 3},
    {field_table_name, 6},
  [107] =
    {field_table_name, 6},
  [108] =
    {field_name, 4},
    {field_table_name, 6},
  [110] =
    {field_kind, 1},
    {field_kind, 2},
    {field_target, 6},
    {field_target, 7},
  [114] =
    {field_type, 4},
  [115] =
    {field_end_label, 4},
  [116] =
    {field_begin_label, 0},
  [117] =
    {field_value, 3},
    {field_value, 4, .inherited = true},
  [119] =
    {field_name, 3},
    {field_on_table, 7},
  [121] =
    {field_name, 5},
    {field_table_name, 7},
  [123] =
    {field_name, 4},
    {field_table_name, 7},
  [125] =
    {field_begin_label, 0},
    {field_end_label, 5},
  [127] =
    {field_value, 5},
  [128] =
    {field_name, 4},
    {field_on_table, 8},
  [130] =
    {field_name, 5},
    {field_table_name, 8},
  [132] =
    {field_name, 6},
    {field_table_name, 8},
  [134] =
    {field_frame_end, 4},
    {field_frame_start, 2},
  [136] =
    {field_action, 2},
  [137] =
    {field_begin_label, 0},
    {field_end_label, 6},
  [139] =
    {field_value, 5},
    {field_value, 6, .inherited = true},
  [141] =
    {field_name, 5},
    {field_on_table, 9},
  [143] =
    {field_storage_parameter, 2},
  [144] =
    {field_name, 6},
    {field_table_name, 9},
  [146] =
    {field_name, 7},
    {field_table_name, 9},
  [148] =
    {field_name, 6},
    {field_on_table, 10},
  [150] =
    {field_function, 2},
  [151] =
    {field_name, 7},
    {field_table_name, 10},
  [153] =
    {field_name, 7},
    {field_on_table, 11},
  [155] =
    {field_arguments, 4},
    {field_function, 2},
  [157] =
    {field_name, 8},
    {field_on_table, 12},
  [159] =
    {field_arguments, 4},
    {field_arguments, 5},
    {field_function, 2},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
  [1] = {
    [0] = anon_alias_sym_WITH,
  },
  [2] = {
    [1] = alias_sym_alter_sequence,
  },
  [3] = {
    [0] = anon_alias_sym_NULL,
  },
  [4] = {
    [0] = anon_alias_sym_CREATE_EXTENSION,
    [1] = anon_alias_sym_CREATE_EXTENSION,
  },
  [5] = {
    [0] = anon_alias_sym_CREATE_SCHEMA,
    [1] = anon_alias_sym_CREATE_SCHEMA,
  },
  [6] = {
    [0] = aux_sym_create_function_statement_token6,
  },
  [7] = {
    [0] = aux_sym_create_role_statement_token1,
  },
  [8] = {
    [0] = aux_sym_create_domain_statement_token1,
  },
  [10] = {
    [0] = anon_alias_sym_NOT,
  },
  [14] = {
    [0] = anon_alias_sym_CREATE_EXTENSION,
    [1] = anon_alias_sym_CREATE_EXTENSION,
    [3] = anon_alias_sym_WITH,
  },
  [15] = {
    [0] = aux_sym_comment_statement_token6,
    [1] = aux_sym_comment_statement_token6,
  },
  [16] = {
    [0] = aux_sym_create_function_statement_token2,
    [1] = aux_sym_create_function_statement_token2,
  },
  [17] = {
    [0] = aux_sym_create_role_statement_token1,
    [3] = anon_alias_sym_WITH,
  },
  [18] = {
    [1] = anon_alias_sym_MATERIALIZED_VIEW,
    [2] = anon_alias_sym_MATERIALIZED_VIEW,
  },
  [27] = {
    [1] = anon_alias_sym_OR,
  },
  [28] = {
    [0] = aux_sym_sequence_token4,
  },
  [29] = {
    [1] = aux_sym_order_by_clause_token1,
  },
  [30] = {
    [0] = aux_sym_cte_token3,
    [2] = aux_sym_cte_token3,
  },
  [31] = {
    [1] = sym_alter_schema,
  },
  [32] = {
    [1] = alias_sym_version,
  },
  [34] = {
    [1] = anon_alias_sym_IF,
    [2] = anon_alias_sym_EXISTS,
  },
  [35] = {
    [0] = aux_sym_comment_statement_token6,
    [1] = aux_sym_comment_statement_token6,
  },
  [36] = {
    [0] = aux_sym_create_function_statement_token2,
    [1] = aux_sym_create_function_statement_token2,
  },
  [40] = {
    [1] = anon_alias_sym_MATERIALIZED_VIEW,
    [2] = anon_alias_sym_MATERIALIZED_VIEW,
  },
  [41] = {
    [1] = anon_alias_sym_MATERIALIZED_VIEW,
    [2] = anon_alias_sym_MATERIALIZED_VIEW,
  },
  [42] = {
    [2] = anon_alias_sym_IF_EXISTS,
    [3] = anon_alias_sym_IF_EXISTS,
  },
  [47] = {
    [1] = anon_alias_sym_NOT,
  },
  [48] = {
    [2] = anon_alias_sym_NOT,
  },
  [49] = {
    [1] = aux_sym_comment_statement_token1,
  },
  [50] = {
    [1] = aux_sym_comment_statement_token1,
    [2] = anon_alias_sym_FUNCTION,
  },
  [52] = {
    [0] = anon_alias_sym_CHECK,
  },
  [53] = {
    [0] = anon_alias_sym_DEFERRABLE,
  },
  [57] = {
    [0] = anon_alias_sym_NO_SQL,
    [1] = anon_alias_sym_NO_SQL,
  },
  [58] = {
    [0] = aux_sym_external_hint_token4,
    [1] = aux_sym_external_hint_token4,
  },
  [59] = {
    [1] = aux_sym_sql_hint_token1,
  },
  [60] = {
    [1] = anon_alias_sym_IF,
    [2] = anon_alias_sym_NOT,
    [3] = anon_alias_sym_EXISTS,
  },
  [61] = {
    [1] = anon_alias_sym_WITH,
  },
  [62] = {
    [1] = anon_alias_sym_BY,
  },
  [63] = {
    [1] = aux_sym_sequence_token9,
  },
  [66] = {
    [1] = anon_alias_sym_IF_EXISTS,
    [2] = anon_alias_sym_IF_EXISTS,
  },
  [67] = {
    [1] = aux_sym_alter_owner_action_token1,
  },
  [68] = {
    [0] = anon_alias_sym_RENAME_TO,
    [1] = anon_alias_sym_RENAME_TO,
  },
  [69] = {
    [1] = anon_alias_sym_MATERIALIZED_VIEW,
    [2] = anon_alias_sym_MATERIALIZED_VIEW,
    [3] = anon_alias_sym_IF_EXISTS,
    [4] = anon_alias_sym_IF_EXISTS,
  },
  [70] = {
    [1] = anon_alias_sym_MATERIALIZED_VIEW,
    [2] = anon_alias_sym_MATERIALIZED_VIEW,
  },
  [71] = {
    [2] = anon_alias_sym_IF_EXISTS,
    [3] = anon_alias_sym_IF_EXISTS,
  },
  [72] = {
    [3] = anon_alias_sym_IF_EXISTS,
    [4] = anon_alias_sym_IF_EXISTS,
  },
  [75] = {
    [0] = anon_alias_sym_DISTINCT_FROM,
    [1] = anon_alias_sym_DISTINCT_FROM,
  },
  [77] = {
    [2] = aux_sym_at_time_zone_expression_token1,
    [3] = aux_sym_at_time_zone_expression_token1,
  },
  [78] = {
    [2] = anon_alias_sym_MATERIALIZED,
  },
  [82] = {
    [0] = aux_sym_mode_token1,
  },
  [83] = {
    [0] = anon_alias_sym_CREATE_EXTENSION,
    [1] = anon_alias_sym_CREATE_EXTENSION,
    [6] = anon_alias_sym_WITH,
  },
  [84] = {
    [2] = alias_sym_default,
  },
  [86] = {
    [1] = aux_sym_external_hint_token4,
  },
  [87] = {
    [1] = aux_sym_sql_hint_token2,
    [2] = anon_alias_sym_INVOKER,
  },
  [88] = {
    [1] = aux_sym_sql_hint_token2,
    [2] = anon_alias_sym_DEFINER,
  },
  [89] = {
    [1] = aux_sym_sql_hint_token3,
    [2] = aux_sym_sql_hint_token3,
  },
  [90] = {
    [1] = aux_sym_sql_hint_token5,
    [2] = aux_sym_sql_hint_token5,
  },
  [93] = {
    [1] = anon_alias_sym_OF,
  },
  [94] = {
    [0] = anon_alias_sym_WITH,
    [2] = aux_sym_table_constraint_check_token1,
  },
  [99] = {
    [1] = anon_alias_sym_MATERIALIZED_VIEW,
    [2] = anon_alias_sym_MATERIALIZED_VIEW,
    [3] = anon_alias_sym_IF_EXISTS,
    [4] = anon_alias_sym_IF_EXISTS,
  },
  [100] = {
    [1] = anon_alias_sym_MATERIALIZED_VIEW,
    [2] = anon_alias_sym_MATERIALIZED_VIEW,
    [4] = anon_alias_sym_IF_EXISTS,
    [5] = anon_alias_sym_IF_EXISTS,
  },
  [101] = {
    [3] = anon_alias_sym_IF_EXISTS,
    [4] = anon_alias_sym_IF_EXISTS,
  },
  [103] = {
    [1] = anon_alias_sym_WITHOUT,
  },
  [106] = {
    [2] = anon_alias_sym_NOT,
    [3] = anon_alias_sym_MATERIALIZED,
  },
  [107] = {
    [3] = alias_sym_default,
  },
  [108] = {
    [3] = alias_sym_default,
  },
  [110] = {
    [1] = aux_sym_create_function_statement_token4,
    [2] = aux_sym_create_function_statement_token4,
  },
  [111] = {
    [1] = aux_sym_null_hint_token1,
    [2] = aux_sym_null_hint_token1,
    [3] = aux_sym_null_hint_token1,
  },
  [112] = {
    [1] = anon_alias_sym_default,
    [2] = anon_alias_sym_default,
    [3] = anon_alias_sym_default,
  },
  [113] = {
    [2] = aux_sym_null_hint_token3,
    [3] = aux_sym_null_hint_token3,
  },
  [114] = {
    [2] = aux_sym_type_spec_base_token1,
    [3] = aux_sym_type_spec_base_token1,
  },
  [115] = {
    [2] = aux_sym_type_spec_base_token2,
    [3] = aux_sym_type_spec_base_token2,
  },
  [116] = {
    [2] = aux_sym_type_spec_base_token3,
    [3] = aux_sym_type_spec_base_token3,
  },
  [117] = {
    [2] = aux_sym_type_spec_base_token4,
    [3] = aux_sym_type_spec_base_token4,
  },
  [118] = {
    [2] = aux_sym_type_spec_base_token5,
    [3] = aux_sym_type_spec_base_token5,
  },
  [119] = {
    [2] = aux_sym_type_spec_base_token6,
    [3] = aux_sym_type_spec_base_token6,
  },
  [120] = {
    [2] = aux_sym_type_spec_base_token7,
    [3] = aux_sym_type_spec_base_token7,
  },
  [121] = {
    [2] = aux_sym_type_spec_base_token8,
  },
  [122] = {
    [2] = aux_sym_type_spec_base_token8,
    [3] = aux_sym_type_spec_base_token8,
  },
  [123] = {
    [2] = aux_sym_type_spec_base_token11,
    [3] = aux_sym_type_spec_base_token11,
  },
  [124] = {
    [2] = aux_sym_type_spec_base_token12,
    [3] = aux_sym_type_spec_base_token12,
  },
  [125] = {
    [2] = aux_sym_type_spec_base_token13,
    [3] = aux_sym_type_spec_base_token13,
  },
  [126] = {
    [2] = aux_sym_type_spec_base_token14,
    [3] = aux_sym_type_spec_base_token14,
  },
  [127] = {
    [2] = aux_sym_type_spec_base_token15,
    [3] = aux_sym_type_spec_base_token15,
  },
  [128] = {
    [2] = aux_sym_type_spec_base_token16,
    [3] = aux_sym_type_spec_base_token16,
  },
  [129] = {
    [2] = aux_sym_type_spec_base_token17,
    [3] = aux_sym_type_spec_base_token17,
  },
  [130] = {
    [2] = aux_sym_type_spec_base_token18,
    [3] = aux_sym_type_spec_base_token18,
  },
  [132] = {
    [0] = anon_alias_sym_WITH,
    [2] = aux_sym_table_constraint_check_token1,
    [3] = aux_sym_table_constraint_check_token1,
  },
  [136] = {
    [1] = anon_alias_sym_MATERIALIZED_VIEW,
    [2] = anon_alias_sym_MATERIALIZED_VIEW,
    [4] = anon_alias_sym_IF_EXISTS,
    [5] = anon_alias_sym_IF_EXISTS,
  },
  [137] = {
    [6] = aux_sym_with_clause_token1,
    [7] = aux_sym_with_clause_token1,
  },
  [139] = {
    [2] = anon_alias_sym_WITH,
  },
  [140] = {
    [2] = anon_alias_sym_WITHOUT,
  },
  [141] = {
    [1] = aux_sym_partition_by_clause_token1,
  },
  [142] = {
    [0] = anon_alias_sym_UNBOUNDED_FOLLOWING,
    [1] = anon_alias_sym_UNBOUNDED_FOLLOWING,
  },
  [143] = {
    [1] = aux_sym_frame_bound_token3,
  },
  [144] = {
    [1] = anon_alias_sym_PRECEDING,
  },
  [145] = {
    [4] = alias_sym_default,
  },
  [147] = {
    [0] = aux_sym_null_hint_token2,
    [2] = aux_sym_null_hint_token2,
    [4] = aux_sym_null_hint_token2,
  },
  [149] = {
    [1] = anon_alias_sym_default,
    [2] = anon_alias_sym_default,
    [3] = anon_alias_sym_default,
  },
  [150] = {
    [2] = aux_sym_null_hint_token3,
    [3] = aux_sym_null_hint_token3,
  },
  [151] = {
    [2] = aux_sym_type_spec_base_token1,
    [3] = aux_sym_type_spec_base_token1,
  },
  [152] = {
    [2] = aux_sym_type_spec_base_token2,
    [3] = aux_sym_type_spec_base_token2,
  },
  [153] = {
    [2] = aux_sym_type_spec_base_token3,
    [3] = aux_sym_type_spec_base_token3,
  },
  [154] = {
    [2] = aux_sym_type_spec_base_token4,
    [3] = aux_sym_type_spec_base_token4,
  },
  [155] = {
    [2] = aux_sym_type_spec_base_token5,
    [3] = aux_sym_type_spec_base_token5,
  },
  [156] = {
    [2] = aux_sym_type_spec_base_token6,
    [3] = aux_sym_type_spec_base_token6,
  },
  [157] = {
    [2] = aux_sym_type_spec_base_token7,
    [3] = aux_sym_type_spec_base_token7,
  },
  [158] = {
    [2] = aux_sym_type_spec_base_token8,
  },
  [159] = {
    [2] = aux_sym_type_spec_base_token8,
    [3] = aux_sym_type_spec_base_token8,
  },
  [160] = {
    [2] = aux_sym_type_spec_base_token11,
    [3] = aux_sym_type_spec_base_token11,
  },
  [161] = {
    [2] = aux_sym_type_spec_base_token12,
    [3] = aux_sym_type_spec_base_token12,
  },
  [162] = {
    [2] = aux_sym_type_spec_base_token13,
    [3] = aux_sym_type_spec_base_token13,
  },
  [163] = {
    [2] = aux_sym_type_spec_base_token14,
    [3] = aux_sym_type_spec_base_token14,
  },
  [164] = {
    [2] = aux_sym_type_spec_base_token15,
    [3] = aux_sym_type_spec_base_token15,
  },
  [165] = {
    [2] = aux_sym_type_spec_base_token16,
    [3] = aux_sym_type_spec_base_token16,
  },
  [166] = {
    [2] = aux_sym_type_spec_base_token17,
    [3] = aux_sym_type_spec_base_token17,
  },
  [167] = {
    [2] = aux_sym_type_spec_base_token18,
    [3] = aux_sym_type_spec_base_token18,
  },
  [171] = {
    [0] = anon_alias_sym_ALTER_COLUMN,
    [1] = anon_alias_sym_ALTER_COLUMN,
    [3] = anon_alias_sym_SET_DEFAULT,
    [4] = anon_alias_sym_SET_DEFAULT,
  },
  [172] = {
    [6] = aux_sym_with_clause_token1,
    [7] = aux_sym_with_clause_token1,
    [8] = aux_sym_with_clause_token1,
  },
  [173] = {
    [6] = aux_sym_with_clause_token1,
    [7] = aux_sym_with_clause_token1,
    [8] = aux_sym_with_clause_token1,
  },
  [174] = {
    [3] = anon_alias_sym_WITH,
  },
  [175] = {
    [3] = anon_alias_sym_WITHOUT,
  },
  [176] = {
    [1] = aux_sym_within_group_clause_token1,
  },
  [177] = {
    [0] = anon_alias_sym_EXCLUDE_GROUP,
    [1] = anon_alias_sym_EXCLUDE_GROUP,
  },
  [178] = {
    [0] = aux_sym_frame_exclusion_token1,
  },
  [179] = {
    [1] = aux_sym_table_constraint_foreign_key_token1,
  },
  [181] = {
    [4] = aux_sym_type_spec_range_token2,
    [5] = aux_sym_type_spec_range_token2,
  },
  [182] = {
    [4] = aux_sym_type_spec_range_token3,
    [5] = aux_sym_type_spec_range_token3,
  },
  [183] = {
    [4] = aux_sym_type_spec_range_token4,
    [5] = aux_sym_type_spec_range_token4,
  },
  [184] = {
    [4] = aux_sym_type_spec_range_token5,
    [5] = aux_sym_type_spec_range_token5,
  },
  [185] = {
    [4] = aux_sym_type_spec_range_token6,
    [5] = aux_sym_type_spec_range_token6,
  },
  [186] = {
    [4] = aux_sym_type_spec_range_token7,
    [5] = aux_sym_type_spec_range_token7,
  },
  [190] = {
    [7] = aux_sym_with_clause_token1,
    [8] = aux_sym_with_clause_token1,
    [9] = aux_sym_with_clause_token1,
  },
  [191] = {
    [7] = aux_sym_with_clause_token1,
    [8] = aux_sym_with_clause_token1,
    [9] = aux_sym_with_clause_token1,
  },
  [192] = {
    [7] = aux_sym_with_clause_token1,
    [8] = aux_sym_with_clause_token1,
    [9] = aux_sym_with_clause_token1,
  },
  [193] = {
    [4] = anon_alias_sym_WITH,
  },
  [194] = {
    [4] = anon_alias_sym_WITHOUT,
  },
  [196] = {
    [0] = aux_sym_frame_exclusion_token2,
    [1] = aux_sym_frame_exclusion_token2,
  },
  [197] = {
    [0] = anon_alias_sym_EXCLUDE_CURRENT_ROW,
    [1] = anon_alias_sym_EXCLUDE_CURRENT_ROW,
    [2] = anon_alias_sym_EXCLUDE_CURRENT_ROW,
  },
  [198] = {
    [0] = anon_alias_sym_ON_DELETE,
    [1] = anon_alias_sym_ON_DELETE,
  },
  [199] = {
    [0] = anon_alias_sym_ON_UPDATE,
    [1] = anon_alias_sym_ON_UPDATE,
  },
  [201] = {
    [4] = aux_sym_type_spec_range_token2,
    [5] = aux_sym_type_spec_range_token2,
  },
  [202] = {
    [4] = aux_sym_type_spec_range_token3,
    [5] = aux_sym_type_spec_range_token3,
  },
  [203] = {
    [4] = aux_sym_type_spec_range_token4,
    [5] = aux_sym_type_spec_range_token4,
  },
  [204] = {
    [4] = aux_sym_type_spec_range_token5,
    [5] = aux_sym_type_spec_range_token5,
  },
  [205] = {
    [4] = aux_sym_type_spec_range_token6,
    [5] = aux_sym_type_spec_range_token6,
  },
  [206] = {
    [4] = aux_sym_type_spec_range_token7,
    [5] = aux_sym_type_spec_range_token7,
  },
  [208] = {
    [0] = anon_alias_sym_WITH,
  },
  [211] = {
    [8] = aux_sym_with_clause_token1,
    [9] = aux_sym_with_clause_token1,
    [10] = aux_sym_with_clause_token1,
  },
  [212] = {
    [8] = aux_sym_with_clause_token1,
    [9] = aux_sym_with_clause_token1,
    [10] = aux_sym_with_clause_token1,
  },
  [213] = {
    [8] = aux_sym_with_clause_token1,
    [9] = aux_sym_with_clause_token1,
    [10] = aux_sym_with_clause_token1,
  },
  [214] = {
    [5] = anon_alias_sym_WITH,
  },
  [215] = {
    [5] = anon_alias_sym_WITHOUT,
  },
  [216] = {
    [0] = anon_alias_sym_SET_NULL,
    [1] = anon_alias_sym_SET_NULL,
  },
  [218] = {
    [1] = anon_alias_sym_FUNCTION,
  },
  [219] = {
    [1] = anon_alias_sym_PROCEDURE,
  },
  [221] = {
    [9] = aux_sym_with_clause_token1,
    [10] = aux_sym_with_clause_token1,
  },
  [222] = {
    [6] = anon_alias_sym_WITH,
  },
  [223] = {
    [6] = anon_alias_sym_WITHOUT,
  },
  [224] = {
    [2] = aux_sym_type_spec_range_token2,
    [3] = aux_sym_type_spec_range_token2,
  },
  [225] = {
    [2] = aux_sym_type_spec_range_token3,
    [3] = aux_sym_type_spec_range_token3,
  },
  [226] = {
    [2] = aux_sym_type_spec_range_token4,
    [3] = aux_sym_type_spec_range_token4,
  },
  [227] = {
    [2] = aux_sym_type_spec_range_token5,
    [3] = aux_sym_type_spec_range_token5,
  },
  [228] = {
    [2] = aux_sym_type_spec_range_token6,
    [3] = aux_sym_type_spec_range_token6,
  },
  [229] = {
    [2] = aux_sym_type_spec_range_token7,
    [3] = aux_sym_type_spec_range_token7,
  },
  [231] = {
    [1] = anon_alias_sym_FUNCTION,
  },
  [232] = {
    [1] = anon_alias_sym_PROCEDURE,
  },
  [233] = {
    [7] = anon_alias_sym_WITH,
  },
  [234] = {
    [7] = anon_alias_sym_WITHOUT,
  },
  [236] = {
    [1] = anon_alias_sym_FUNCTION,
  },
  [237] = {
    [1] = anon_alias_sym_PROCEDURE,
  },
};

static const uint16_t ts_non_terminal_alias_map[] = {
  sym_sequence, 2,
    sym_sequence,
    alias_sym_alter_sequence,
  sym__identifier, 21,
    sym__identifier,
    aux_sym_null_hint_token3,
    aux_sym_type_spec_base_token1,
    aux_sym_type_spec_base_token11,
    aux_sym_type_spec_base_token12,
    aux_sym_type_spec_base_token13,
    aux_sym_type_spec_base_token16,
    aux_sym_type_spec_base_token18,
    aux_sym_type_spec_base_token2,
    aux_sym_type_spec_base_token3,
    aux_sym_type_spec_base_token4,
    aux_sym_type_spec_base_token5,
    aux_sym_type_spec_base_token6,
    aux_sym_type_spec_base_token7,
    aux_sym_type_spec_range_token2,
    aux_sym_type_spec_range_token3,
    aux_sym_type_spec_range_token4,
    aux_sym_type_spec_range_token5,
    aux_sym_type_spec_range_token6,
    aux_sym_type_spec_range_token7,
    sym_alter_schema,
  sym_string, 5,
    sym_string,
    alias_sym_version,
    aux_sym_type_spec_base_token14,
    aux_sym_type_spec_base_token15,
    aux_sym_type_spec_base_token17,
  sym__expression, 3,
    sym__expression,
    alias_sym_default,
    anon_alias_sym_default,
  0,
};

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(2216);
      if (lookahead == '!') ADVANCE(586);
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '#') ADVANCE(3428);
      if (lookahead == '$') ADVANCE(3442);
      if (lookahead == '%') ADVANCE(3422);
      if (lookahead == '&') ADVANCE(3426);
      if (lookahead == '\'') ADVANCE(3387);
      if (lookahead == '(') ADVANCE(2236);
      if (lookahead == ')') ADVANCE(2237);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == ',') ADVANCE(2228);
      if (lookahead == '-') ADVANCE(3412);
      if (lookahead == '.') ADVANCE(3386);
      if (lookahead == '/') ADVANCE(3421);
      if (lookahead == ':') ADVANCE(2311);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '<') ADVANCE(3429);
      if (lookahead == '=') ADVANCE(2401);
      if (lookahead == '>') ADVANCE(3433);
      if (lookahead == '@') ADVANCE(3416);
      if (lookahead == 'C') ADVANCE(906);
      if (lookahead == '[') ADVANCE(3403);
      if (lookahead == '\\') ADVANCE(2);
      if (lookahead == ']') ADVANCE(3404);
      if (lookahead == '^') ADVANCE(3419);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == 'c') ADVANCE(933);
      if (lookahead == '|') ADVANCE(3427);
      if (lookahead == '~') ADVANCE(3415);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1120);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(1158);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(950);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(934);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(936);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(1769);
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(937);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1343);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(1707);
      if (lookahead == 'K' ||
          lookahead == 'k') ADVANCE(1159);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(938);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(939);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1160);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1344);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(940);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(952);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(941);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(988);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(1611);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(951);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(1402);
      if (lookahead == 'Z' ||
          lookahead == 'z') ADVANCE(1742);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(0)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(3443);
      END_STATE();
    case 1:
      if (lookahead == '\n') SKIP(584)
      END_STATE();
    case 2:
      if (lookahead == '\n') SKIP(584)
      if (lookahead == '\r') SKIP(1)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 3:
      if (lookahead == '\n') SKIP(743)
      END_STATE();
    case 4:
      if (lookahead == '\n') SKIP(743)
      if (lookahead == '\r') SKIP(3)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 5:
      if (lookahead == '\n') SKIP(776)
      END_STATE();
    case 6:
      if (lookahead == '\n') SKIP(776)
      if (lookahead == '\r') SKIP(5)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 7:
      if (lookahead == '\n') SKIP(777)
      END_STATE();
    case 8:
      if (lookahead == '\n') SKIP(777)
      if (lookahead == '\r') SKIP(7)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 9:
      if (lookahead == '\n') SKIP(596)
      END_STATE();
    case 10:
      if (lookahead == '\n') SKIP(596)
      if (lookahead == '\r') SKIP(9)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 11:
      if (lookahead == '\n') SKIP(649)
      END_STATE();
    case 12:
      if (lookahead == '\n') SKIP(649)
      if (lookahead == '\r') SKIP(11)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 13:
      if (lookahead == '\n') SKIP(632)
      END_STATE();
    case 14:
      if (lookahead == '\n') SKIP(632)
      if (lookahead == '\r') SKIP(13)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 15:
      if (lookahead == '\n') SKIP(715)
      END_STATE();
    case 16:
      if (lookahead == '\n') SKIP(715)
      if (lookahead == '\r') SKIP(15)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 17:
      if (lookahead == '\n') SKIP(623)
      END_STATE();
    case 18:
      if (lookahead == '\n') SKIP(623)
      if (lookahead == '\r') SKIP(17)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 19:
      if (lookahead == '\n') SKIP(600)
      END_STATE();
    case 20:
      if (lookahead == '\n') SKIP(600)
      if (lookahead == '\r') SKIP(19)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 21:
      if (lookahead == '\n') SKIP(653)
      END_STATE();
    case 22:
      if (lookahead == '\n') SKIP(653)
      if (lookahead == '\r') SKIP(21)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 23:
      if (lookahead == '\n') SKIP(601)
      END_STATE();
    case 24:
      if (lookahead == '\n') SKIP(601)
      if (lookahead == '\r') SKIP(23)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 25:
      if (lookahead == '\n') SKIP(617)
      END_STATE();
    case 26:
      if (lookahead == '\n') SKIP(617)
      if (lookahead == '\r') SKIP(25)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 27:
      if (lookahead == '\n') SKIP(655)
      END_STATE();
    case 28:
      if (lookahead == '\n') SKIP(655)
      if (lookahead == '\r') SKIP(27)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 29:
      if (lookahead == '\n') SKIP(624)
      END_STATE();
    case 30:
      if (lookahead == '\n') SKIP(624)
      if (lookahead == '\r') SKIP(29)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 31:
      if (lookahead == '\n') SKIP(602)
      END_STATE();
    case 32:
      if (lookahead == '\n') SKIP(602)
      if (lookahead == '\r') SKIP(31)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 33:
      if (lookahead == '\n') SKIP(716)
      END_STATE();
    case 34:
      if (lookahead == '\n') SKIP(716)
      if (lookahead == '\r') SKIP(33)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 35:
      if (lookahead == '\n') SKIP(718)
      END_STATE();
    case 36:
      if (lookahead == '\n') SKIP(718)
      if (lookahead == '\r') SKIP(35)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 37:
      if (lookahead == '\n') SKIP(786)
      END_STATE();
    case 38:
      if (lookahead == '\n') SKIP(786)
      if (lookahead == '\r') SKIP(37)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 39:
      if (lookahead == '\n') SKIP(658)
      END_STATE();
    case 40:
      if (lookahead == '\n') SKIP(658)
      if (lookahead == '\r') SKIP(39)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 41:
      if (lookahead == '\n') SKIP(659)
      END_STATE();
    case 42:
      if (lookahead == '\n') SKIP(659)
      if (lookahead == '\r') SKIP(41)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 43:
      if (lookahead == '\n') SKIP(633)
      END_STATE();
    case 44:
      if (lookahead == '\n') SKIP(633)
      if (lookahead == '\r') SKIP(43)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 45:
      if (lookahead == '\n') SKIP(619)
      END_STATE();
    case 46:
      if (lookahead == '\n') SKIP(619)
      if (lookahead == '\r') SKIP(45)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 47:
      if (lookahead == '\n') SKIP(722)
      END_STATE();
    case 48:
      if (lookahead == '\n') SKIP(722)
      if (lookahead == '\r') SKIP(47)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 49:
      if (lookahead == '\n') SKIP(778)
      END_STATE();
    case 50:
      if (lookahead == '\n') SKIP(778)
      if (lookahead == '\r') SKIP(49)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 51:
      if (lookahead == '\n') SKIP(779)
      END_STATE();
    case 52:
      if (lookahead == '\n') SKIP(779)
      if (lookahead == '\r') SKIP(51)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 53:
      if (lookahead == '\n') SKIP(608)
      END_STATE();
    case 54:
      if (lookahead == '\n') SKIP(608)
      if (lookahead == '\r') SKIP(53)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 55:
      if (lookahead == '\n') SKIP(665)
      END_STATE();
    case 56:
      if (lookahead == '\n') SKIP(665)
      if (lookahead == '\r') SKIP(55)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 57:
      if (lookahead == '\n') SKIP(753)
      END_STATE();
    case 58:
      if (lookahead == '\n') SKIP(753)
      if (lookahead == '\r') SKIP(57)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 59:
      if (lookahead == '\n') SKIP(610)
      END_STATE();
    case 60:
      if (lookahead == '\n') SKIP(610)
      if (lookahead == '\r') SKIP(59)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 61:
      if (lookahead == '\n') SKIP(587)
      END_STATE();
    case 62:
      if (lookahead == '\n') SKIP(587)
      if (lookahead == '\r') SKIP(61)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 63:
      if (lookahead == '\n') SKIP(746)
      END_STATE();
    case 64:
      if (lookahead == '\n') SKIP(746)
      if (lookahead == '\r') SKIP(63)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 65:
      if (lookahead == '\n') SKIP(667)
      END_STATE();
    case 66:
      if (lookahead == '\n') SKIP(667)
      if (lookahead == '\r') SKIP(65)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 67:
      if (lookahead == '\n') SKIP(742)
      END_STATE();
    case 68:
      if (lookahead == '\n') SKIP(742)
      if (lookahead == '\r') SKIP(67)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 69:
      if (lookahead == '\n') SKIP(611)
      END_STATE();
    case 70:
      if (lookahead == '\n') SKIP(611)
      if (lookahead == '\r') SKIP(69)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 71:
      if (lookahead == '\n') SKIP(769)
      END_STATE();
    case 72:
      if (lookahead == '\n') SKIP(769)
      if (lookahead == '\r') SKIP(71)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 73:
      if (lookahead == '\n') SKIP(613)
      END_STATE();
    case 74:
      if (lookahead == '\n') SKIP(613)
      if (lookahead == '\r') SKIP(73)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 75:
      if (lookahead == '\n') SKIP(878)
      END_STATE();
    case 76:
      if (lookahead == '\n') SKIP(878)
      if (lookahead == '\r') SKIP(75)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 77:
      if (lookahead == '\n') SKIP(755)
      END_STATE();
    case 78:
      if (lookahead == '\n') SKIP(755)
      if (lookahead == '\r') SKIP(77)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 79:
      if (lookahead == '\n') SKIP(770)
      END_STATE();
    case 80:
      if (lookahead == '\n') SKIP(770)
      if (lookahead == '\r') SKIP(79)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 81:
      if (lookahead == '\n') SKIP(757)
      END_STATE();
    case 82:
      if (lookahead == '\n') SKIP(757)
      if (lookahead == '\r') SKIP(81)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 83:
      if (lookahead == '\n') SKIP(795)
      END_STATE();
    case 84:
      if (lookahead == '\n') SKIP(795)
      if (lookahead == '\r') SKIP(83)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 85:
      if (lookahead == '\n') SKIP(765)
      END_STATE();
    case 86:
      if (lookahead == '\n') SKIP(765)
      if (lookahead == '\r') SKIP(85)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 87:
      if (lookahead == '\n') SKIP(744)
      END_STATE();
    case 88:
      if (lookahead == '\n') SKIP(744)
      if (lookahead == '\r') SKIP(87)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 89:
      if (lookahead == '\n') SKIP(756)
      END_STATE();
    case 90:
      if (lookahead == '\n') SKIP(756)
      if (lookahead == '\r') SKIP(89)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 91:
      if (lookahead == '\n') SKIP(808)
      END_STATE();
    case 92:
      if (lookahead == '\n') SKIP(808)
      if (lookahead == '\r') SKIP(91)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 93:
      if (lookahead == '\n') SKIP(766)
      END_STATE();
    case 94:
      if (lookahead == '\n') SKIP(766)
      if (lookahead == '\r') SKIP(93)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 95:
      if (lookahead == '\n') SKIP(747)
      END_STATE();
    case 96:
      if (lookahead == '\n') SKIP(747)
      if (lookahead == '\r') SKIP(95)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 97:
      if (lookahead == '\n') SKIP(790)
      END_STATE();
    case 98:
      if (lookahead == '\n') SKIP(790)
      if (lookahead == '\r') SKIP(97)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 99:
      if (lookahead == '\n') SKIP(772)
      END_STATE();
    case 100:
      if (lookahead == '\n') SKIP(772)
      if (lookahead == '\r') SKIP(99)
      END_STATE();
    case 101:
      if (lookahead == '\n') SKIP(796)
      END_STATE();
    case 102:
      if (lookahead == '\n') SKIP(796)
      if (lookahead == '\r') SKIP(101)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 103:
      if (lookahead == '\n') SKIP(833)
      END_STATE();
    case 104:
      if (lookahead == '\n') SKIP(833)
      if (lookahead == '\r') SKIP(103)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 105:
      if (lookahead == '\n') SKIP(673)
      END_STATE();
    case 106:
      if (lookahead == '\n') SKIP(673)
      if (lookahead == '\r') SKIP(105)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 107:
      if (lookahead == '\n') SKIP(621)
      END_STATE();
    case 108:
      if (lookahead == '\n') SKIP(621)
      if (lookahead == '\r') SKIP(107)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 109:
      if (lookahead == '\n') SKIP(748)
      END_STATE();
    case 110:
      if (lookahead == '\n') SKIP(748)
      if (lookahead == '\r') SKIP(109)
      END_STATE();
    case 111:
      if (lookahead == '\n') SKIP(771)
      END_STATE();
    case 112:
      if (lookahead == '\n') SKIP(771)
      if (lookahead == '\r') SKIP(111)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 113:
      if (lookahead == '\n') SKIP(797)
      END_STATE();
    case 114:
      if (lookahead == '\n') SKIP(797)
      if (lookahead == '\r') SKIP(113)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 115:
      if (lookahead == '\n') SKIP(758)
      END_STATE();
    case 116:
      if (lookahead == '\n') SKIP(758)
      if (lookahead == '\r') SKIP(115)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 117:
      if (lookahead == '\n') SKIP(615)
      END_STATE();
    case 118:
      if (lookahead == '\n') SKIP(615)
      if (lookahead == '\r') SKIP(117)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 119:
      if (lookahead == '\n') SKIP(745)
      END_STATE();
    case 120:
      if (lookahead == '\n') SKIP(745)
      if (lookahead == '\r') SKIP(119)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 121:
      if (lookahead == '\n') SKIP(749)
      END_STATE();
    case 122:
      if (lookahead == '\n') SKIP(749)
      if (lookahead == '\r') SKIP(121)
      END_STATE();
    case 123:
      if (lookahead == '\n') SKIP(674)
      END_STATE();
    case 124:
      if (lookahead == '\n') SKIP(674)
      if (lookahead == '\r') SKIP(123)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 125:
      if (lookahead == '\n') SKIP(834)
      END_STATE();
    case 126:
      if (lookahead == '\n') SKIP(834)
      if (lookahead == '\r') SKIP(125)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 127:
      if (lookahead == '\n') SKIP(622)
      END_STATE();
    case 128:
      if (lookahead == '\n') SKIP(622)
      if (lookahead == '\r') SKIP(127)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 129:
      if (lookahead == '\n') SKIP(830)
      END_STATE();
    case 130:
      if (lookahead == '\n') SKIP(830)
      if (lookahead == '\r') SKIP(129)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 131:
      if (lookahead == '\n') SKIP(739)
      END_STATE();
    case 132:
      if (lookahead == '\n') SKIP(739)
      if (lookahead == '\r') SKIP(131)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 133:
      if (lookahead == '\n') SKIP(675)
      END_STATE();
    case 134:
      if (lookahead == '\n') SKIP(675)
      if (lookahead == '\r') SKIP(133)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 135:
      if (lookahead == '\n') SKIP(592)
      END_STATE();
    case 136:
      if (lookahead == '\n') SKIP(592)
      if (lookahead == '\r') SKIP(135)
      END_STATE();
    case 137:
      if (lookahead == '\n') SKIP(760)
      END_STATE();
    case 138:
      if (lookahead == '\n') SKIP(760)
      if (lookahead == '\r') SKIP(137)
      END_STATE();
    case 139:
      if (lookahead == '\n') SKIP(616)
      END_STATE();
    case 140:
      if (lookahead == '\n') SKIP(616)
      if (lookahead == '\r') SKIP(139)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 141:
      if (lookahead == '\n') SKIP(636)
      END_STATE();
    case 142:
      if (lookahead == '\n') SKIP(636)
      if (lookahead == '\r') SKIP(141)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 143:
      if (lookahead == '\n') SKIP(637)
      END_STATE();
    case 144:
      if (lookahead == '\n') SKIP(637)
      if (lookahead == '\r') SKIP(143)
      END_STATE();
    case 145:
      if (lookahead == '\n') SKIP(631)
      END_STATE();
    case 146:
      if (lookahead == '\n') SKIP(631)
      if (lookahead == '\r') SKIP(145)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 147:
      if (lookahead == '\n') SKIP(842)
      END_STATE();
    case 148:
      if (lookahead == '\n') SKIP(842)
      if (lookahead == '\r') SKIP(147)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 149:
      if (lookahead == '\n') SKIP(809)
      END_STATE();
    case 150:
      if (lookahead == '\n') SKIP(809)
      if (lookahead == '\r') SKIP(149)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 151:
      if (lookahead == '\n') SKIP(802)
      END_STATE();
    case 152:
      if (lookahead == '\n') SKIP(802)
      if (lookahead == '\r') SKIP(151)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 153:
      if (lookahead == '\n') SKIP(588)
      END_STATE();
    case 154:
      if (lookahead == '\n') SKIP(588)
      if (lookahead == '\r') SKIP(153)
      END_STATE();
    case 155:
      if (lookahead == '\n') SKIP(866)
      END_STATE();
    case 156:
      if (lookahead == '\n') SKIP(866)
      if (lookahead == '\r') SKIP(155)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 157:
      if (lookahead == '\n') SKIP(676)
      END_STATE();
    case 158:
      if (lookahead == '\n') SKIP(676)
      if (lookahead == '\r') SKIP(157)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 159:
      if (lookahead == '\n') SKIP(810)
      END_STATE();
    case 160:
      if (lookahead == '\n') SKIP(810)
      if (lookahead == '\r') SKIP(159)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 161:
      if (lookahead == '\n') SKIP(798)
      END_STATE();
    case 162:
      if (lookahead == '\n') SKIP(798)
      if (lookahead == '\r') SKIP(161)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 163:
      if (lookahead == '\n') SKIP(782)
      END_STATE();
    case 164:
      if (lookahead == '\n') SKIP(782)
      if (lookahead == '\r') SKIP(163)
      END_STATE();
    case 165:
      if (lookahead == '\n') SKIP(811)
      END_STATE();
    case 166:
      if (lookahead == '\n') SKIP(811)
      if (lookahead == '\r') SKIP(165)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 167:
      if (lookahead == '\n') SKIP(839)
      END_STATE();
    case 168:
      if (lookahead == '\n') SKIP(839)
      if (lookahead == '\r') SKIP(167)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 169:
      if (lookahead == '\n') SKIP(879)
      END_STATE();
    case 170:
      if (lookahead == '\n') SKIP(879)
      if (lookahead == '\r') SKIP(169)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 171:
      if (lookahead == '\n') SKIP(773)
      END_STATE();
    case 172:
      if (lookahead == '\n') SKIP(773)
      if (lookahead == '\r') SKIP(171)
      END_STATE();
    case 173:
      if (lookahead == '\n') SKIP(836)
      END_STATE();
    case 174:
      if (lookahead == '\n') SKIP(836)
      if (lookahead == '\r') SKIP(173)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 175:
      if (lookahead == '\n') SKIP(754)
      END_STATE();
    case 176:
      if (lookahead == '\n') SKIP(754)
      if (lookahead == '\r') SKIP(175)
      END_STATE();
    case 177:
      if (lookahead == '\n') SKIP(825)
      END_STATE();
    case 178:
      if (lookahead == '\n') SKIP(825)
      if (lookahead == '\r') SKIP(177)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 179:
      if (lookahead == '\n') SKIP(774)
      END_STATE();
    case 180:
      if (lookahead == '\n') SKIP(774)
      if (lookahead == '\r') SKIP(179)
      END_STATE();
    case 181:
      if (lookahead == '\n') SKIP(826)
      END_STATE();
    case 182:
      if (lookahead == '\n') SKIP(826)
      if (lookahead == '\r') SKIP(181)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 183:
      if (lookahead == '\n') SKIP(843)
      END_STATE();
    case 184:
      if (lookahead == '\n') SKIP(843)
      if (lookahead == '\r') SKIP(183)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 185:
      if (lookahead == '\n') SKIP(783)
      END_STATE();
    case 186:
      if (lookahead == '\n') SKIP(783)
      if (lookahead == '\r') SKIP(185)
      END_STATE();
    case 187:
      if (lookahead == '\n') SKIP(807)
      END_STATE();
    case 188:
      if (lookahead == '\n') SKIP(807)
      if (lookahead == '\r') SKIP(187)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 189:
      if (lookahead == '\n') SKIP(816)
      END_STATE();
    case 190:
      if (lookahead == '\n') SKIP(816)
      if (lookahead == '\r') SKIP(189)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 191:
      if (lookahead == '\n') SKIP(764)
      END_STATE();
    case 192:
      if (lookahead == '\n') SKIP(764)
      if (lookahead == '\r') SKIP(191)
      END_STATE();
    case 193:
      if (lookahead == '\n') SKIP(759)
      END_STATE();
    case 194:
      if (lookahead == '\n') SKIP(759)
      if (lookahead == '\r') SKIP(193)
      END_STATE();
    case 195:
      if (lookahead == '\n') SKIP(784)
      END_STATE();
    case 196:
      if (lookahead == '\n') SKIP(784)
      if (lookahead == '\r') SKIP(195)
      END_STATE();
    case 197:
      if (lookahead == '\n') SKIP(832)
      END_STATE();
    case 198:
      if (lookahead == '\n') SKIP(832)
      if (lookahead == '\r') SKIP(197)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 199:
      if (lookahead == '\n') SKIP(775)
      END_STATE();
    case 200:
      if (lookahead == '\n') SKIP(775)
      if (lookahead == '\r') SKIP(199)
      END_STATE();
    case 201:
      if (lookahead == '\n') SKIP(792)
      END_STATE();
    case 202:
      if (lookahead == '\n') SKIP(792)
      if (lookahead == '\r') SKIP(201)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 203:
      if (lookahead == '\n') SKIP(837)
      END_STATE();
    case 204:
      if (lookahead == '\n') SKIP(837)
      if (lookahead == '\r') SKIP(203)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 205:
      if (lookahead == '\n') SKIP(750)
      END_STATE();
    case 206:
      if (lookahead == '\n') SKIP(750)
      if (lookahead == '\r') SKIP(205)
      END_STATE();
    case 207:
      if (lookahead == '\n') SKIP(846)
      END_STATE();
    case 208:
      if (lookahead == '\n') SKIP(846)
      if (lookahead == '\r') SKIP(207)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 209:
      if (lookahead == '\n') SKIP(785)
      END_STATE();
    case 210:
      if (lookahead == '\n') SKIP(785)
      if (lookahead == '\r') SKIP(209)
      END_STATE();
    case 211:
      if (lookahead == '\n') SKIP(751)
      END_STATE();
    case 212:
      if (lookahead == '\n') SKIP(751)
      if (lookahead == '\r') SKIP(211)
      END_STATE();
    case 213:
      if (lookahead == '\n') SKIP(761)
      END_STATE();
    case 214:
      if (lookahead == '\n') SKIP(761)
      if (lookahead == '\r') SKIP(213)
      END_STATE();
    case 215:
      if (lookahead == '\n') SKIP(594)
      END_STATE();
    case 216:
      if (lookahead == '\n') SKIP(594)
      if (lookahead == '\r') SKIP(215)
      END_STATE();
    case 217:
      if (lookahead == '\n') SKIP(595)
      END_STATE();
    case 218:
      if (lookahead == '\n') SKIP(595)
      if (lookahead == '\r') SKIP(217)
      END_STATE();
    case 219:
      if (lookahead == '\n') SKIP(752)
      END_STATE();
    case 220:
      if (lookahead == '\n') SKIP(752)
      if (lookahead == '\r') SKIP(219)
      END_STATE();
    case 221:
      if (lookahead == '\n') SKIP(643)
      END_STATE();
    case 222:
      if (lookahead == '\n') SKIP(643)
      if (lookahead == '\r') SKIP(221)
      END_STATE();
    case 223:
      if (lookahead == '\n') SKIP(644)
      END_STATE();
    case 224:
      if (lookahead == '\n') SKIP(644)
      if (lookahead == '\r') SKIP(223)
      END_STATE();
    case 225:
      if (lookahead == '\n') SKIP(635)
      END_STATE();
    case 226:
      if (lookahead == '\n') SKIP(635)
      if (lookahead == '\r') SKIP(225)
      END_STATE();
    case 227:
      if (lookahead == '\n') SKIP(590)
      END_STATE();
    case 228:
      if (lookahead == '\n') SKIP(590)
      if (lookahead == '\r') SKIP(227)
      END_STATE();
    case 229:
      if (lookahead == '\n') SKIP(880)
      END_STATE();
    case 230:
      if (lookahead == '\n') SKIP(880)
      if (lookahead == '\r') SKIP(229)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 231:
      if (lookahead == '\n') SKIP(591)
      END_STATE();
    case 232:
      if (lookahead == '\n') SKIP(591)
      if (lookahead == '\r') SKIP(231)
      END_STATE();
    case 233:
      if (lookahead == '\n') SKIP(762)
      END_STATE();
    case 234:
      if (lookahead == '\n') SKIP(762)
      if (lookahead == '\r') SKIP(233)
      END_STATE();
    case 235:
      if (lookahead == '\n') SKIP(736)
      END_STATE();
    case 236:
      if (lookahead == '\n') SKIP(736)
      if (lookahead == '\r') SKIP(235)
      END_STATE();
    case 237:
      if (lookahead == '\n') SKIP(645)
      END_STATE();
    case 238:
      if (lookahead == '\n') SKIP(645)
      if (lookahead == '\r') SKIP(237)
      END_STATE();
    case 239:
      if (lookahead == '\n') SKIP(763)
      END_STATE();
    case 240:
      if (lookahead == '\n') SKIP(763)
      if (lookahead == '\r') SKIP(239)
      END_STATE();
    case 241:
      if (lookahead == '\n') SKIP(630)
      END_STATE();
    case 242:
      if (lookahead == '\n') SKIP(630)
      if (lookahead == '\r') SKIP(241)
      END_STATE();
    case 243:
      if (lookahead == '\n') SKIP(737)
      END_STATE();
    case 244:
      if (lookahead == '\n') SKIP(737)
      if (lookahead == '\r') SKIP(243)
      END_STATE();
    case 245:
      if (lookahead == '\n') SKIP(647)
      END_STATE();
    case 246:
      if (lookahead == '\n') SKIP(647)
      if (lookahead == '\r') SKIP(245)
      END_STATE();
    case 247:
      if (lookahead == '\n') SKIP(648)
      END_STATE();
    case 248:
      if (lookahead == '\n') SKIP(648)
      if (lookahead == '\r') SKIP(247)
      END_STATE();
    case 249:
      if (lookahead == '\n') SKIP(881)
      END_STATE();
    case 250:
      if (lookahead == '\n') SKIP(881)
      if (lookahead == '\r') SKIP(249)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 251:
      if (lookahead == '\n') SKIP(738)
      END_STATE();
    case 252:
      if (lookahead == '\n') SKIP(738)
      if (lookahead == '\r') SKIP(251)
      END_STATE();
    case 253:
      if (lookahead == '\n') SKIP(827)
      END_STATE();
    case 254:
      if (lookahead == '\n') SKIP(827)
      if (lookahead == '\r') SKIP(253)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 255:
      if (lookahead == '\n') SKIP(868)
      END_STATE();
    case 256:
      if (lookahead == '\n') SKIP(868)
      if (lookahead == '\r') SKIP(255)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 257:
      if (lookahead == '\n') SKIP(788)
      END_STATE();
    case 258:
      if (lookahead == '\n') SKIP(788)
      if (lookahead == '\r') SKIP(257)
      END_STATE();
    case 259:
      if (lookahead == '\n') SKIP(828)
      END_STATE();
    case 260:
      if (lookahead == '\n') SKIP(828)
      if (lookahead == '\r') SKIP(259)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 261:
      if (lookahead == '\n') SKIP(805)
      END_STATE();
    case 262:
      if (lookahead == '\n') SKIP(805)
      if (lookahead == '\r') SKIP(261)
      END_STATE();
    case 263:
      if (lookahead == '\n') SKIP(886)
      END_STATE();
    case 264:
      if (lookahead == '\n') SKIP(886)
      if (lookahead == '\r') SKIP(263)
      END_STATE();
    case 265:
      if (lookahead == '\n') SKIP(787)
      END_STATE();
    case 266:
      if (lookahead == '\n') SKIP(787)
      if (lookahead == '\r') SKIP(265)
      END_STATE();
    case 267:
      if (lookahead == '\n') SKIP(806)
      END_STATE();
    case 268:
      if (lookahead == '\n') SKIP(806)
      if (lookahead == '\r') SKIP(267)
      END_STATE();
    case 269:
      if (lookahead == '\n') SKIP(852)
      END_STATE();
    case 270:
      if (lookahead == '\n') SKIP(852)
      if (lookahead == '\r') SKIP(269)
      END_STATE();
    case 271:
      if (lookahead == '\n') SKIP(789)
      END_STATE();
    case 272:
      if (lookahead == '\n') SKIP(789)
      if (lookahead == '\r') SKIP(271)
      END_STATE();
    case 273:
      if (lookahead == '\n') SKIP(853)
      END_STATE();
    case 274:
      if (lookahead == '\n') SKIP(853)
      if (lookahead == '\r') SKIP(273)
      END_STATE();
    case 275:
      if (lookahead == '\n') SKIP(804)
      END_STATE();
    case 276:
      if (lookahead == '\n') SKIP(804)
      if (lookahead == '\r') SKIP(275)
      END_STATE();
    case 277:
      if (lookahead == '\n') SKIP(851)
      END_STATE();
    case 278:
      if (lookahead == '\n') SKIP(851)
      if (lookahead == '\r') SKIP(277)
      END_STATE();
    case 279:
      if (lookahead == '\n') SKIP(829)
      END_STATE();
    case 280:
      if (lookahead == '\n') SKIP(829)
      if (lookahead == '\r') SKIP(279)
      END_STATE();
    case 281:
      if (lookahead == '\n') SKIP(854)
      END_STATE();
    case 282:
      if (lookahead == '\n') SKIP(854)
      if (lookahead == '\r') SKIP(281)
      END_STATE();
    case 283:
      if (lookahead == '\n') SKIP(855)
      END_STATE();
    case 284:
      if (lookahead == '\n') SKIP(855)
      if (lookahead == '\r') SKIP(283)
      END_STATE();
    case 285:
      if (lookahead == '\n') SKIP(856)
      END_STATE();
    case 286:
      if (lookahead == '\n') SKIP(856)
      if (lookahead == '\r') SKIP(285)
      END_STATE();
    case 287:
      if (lookahead == '\n') SKIP(857)
      END_STATE();
    case 288:
      if (lookahead == '\n') SKIP(857)
      if (lookahead == '\r') SKIP(287)
      END_STATE();
    case 289:
      if (lookahead == '\n') SKIP(858)
      END_STATE();
    case 290:
      if (lookahead == '\n') SKIP(858)
      if (lookahead == '\r') SKIP(289)
      END_STATE();
    case 291:
      if (lookahead == '\n') SKIP(859)
      END_STATE();
    case 292:
      if (lookahead == '\n') SKIP(859)
      if (lookahead == '\r') SKIP(291)
      END_STATE();
    case 293:
      if (lookahead == '\n') SKIP(860)
      END_STATE();
    case 294:
      if (lookahead == '\n') SKIP(860)
      if (lookahead == '\r') SKIP(293)
      END_STATE();
    case 295:
      if (lookahead == '\n') SKIP(861)
      END_STATE();
    case 296:
      if (lookahead == '\n') SKIP(861)
      if (lookahead == '\r') SKIP(295)
      END_STATE();
    case 297:
      if (lookahead == '\n') SKIP(862)
      END_STATE();
    case 298:
      if (lookahead == '\n') SKIP(862)
      if (lookahead == '\r') SKIP(297)
      END_STATE();
    case 299:
      if (lookahead == '\n') SKIP(863)
      END_STATE();
    case 300:
      if (lookahead == '\n') SKIP(863)
      if (lookahead == '\r') SKIP(299)
      END_STATE();
    case 301:
      if (lookahead == '\n') SKIP(864)
      END_STATE();
    case 302:
      if (lookahead == '\n') SKIP(864)
      if (lookahead == '\r') SKIP(301)
      END_STATE();
    case 303:
      if (lookahead == '\n') SKIP(865)
      END_STATE();
    case 304:
      if (lookahead == '\n') SKIP(865)
      if (lookahead == '\r') SKIP(303)
      END_STATE();
    case 305:
      if (lookahead == '\n') SKIP(874)
      END_STATE();
    case 306:
      if (lookahead == '\n') SKIP(874)
      if (lookahead == '\r') SKIP(305)
      END_STATE();
    case 307:
      if (lookahead == '\n') SKIP(597)
      END_STATE();
    case 308:
      if (lookahead == '\n') SKIP(597)
      if (lookahead == '\r') SKIP(307)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 309:
      if (lookahead == '\n') SKIP(650)
      END_STATE();
    case 310:
      if (lookahead == '\n') SKIP(650)
      if (lookahead == '\r') SKIP(309)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 311:
      if (lookahead == '\n') SKIP(603)
      END_STATE();
    case 312:
      if (lookahead == '\n') SKIP(603)
      if (lookahead == '\r') SKIP(311)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 313:
      if (lookahead == '\n') SKIP(654)
      END_STATE();
    case 314:
      if (lookahead == '\n') SKIP(654)
      if (lookahead == '\r') SKIP(313)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 315:
      if (lookahead == '\n') SKIP(604)
      END_STATE();
    case 316:
      if (lookahead == '\n') SKIP(604)
      if (lookahead == '\r') SKIP(315)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 317:
      if (lookahead == '\n') SKIP(618)
      END_STATE();
    case 318:
      if (lookahead == '\n') SKIP(618)
      if (lookahead == '\r') SKIP(317)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 319:
      if (lookahead == '\n') SKIP(625)
      END_STATE();
    case 320:
      if (lookahead == '\n') SKIP(625)
      if (lookahead == '\r') SKIP(319)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 321:
      if (lookahead == '\n') SKIP(605)
      END_STATE();
    case 322:
      if (lookahead == '\n') SKIP(605)
      if (lookahead == '\r') SKIP(321)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 323:
      if (lookahead == '\n') SKIP(719)
      END_STATE();
    case 324:
      if (lookahead == '\n') SKIP(719)
      if (lookahead == '\r') SKIP(323)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 325:
      if (lookahead == '\n') SKIP(663)
      END_STATE();
    case 326:
      if (lookahead == '\n') SKIP(663)
      if (lookahead == '\r') SKIP(325)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 327:
      if (lookahead == '\n') SKIP(634)
      END_STATE();
    case 328:
      if (lookahead == '\n') SKIP(634)
      if (lookahead == '\r') SKIP(327)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 329:
      if (lookahead == '\n') SKIP(620)
      END_STATE();
    case 330:
      if (lookahead == '\n') SKIP(620)
      if (lookahead == '\r') SKIP(329)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 331:
      if (lookahead == '\n') SKIP(723)
      END_STATE();
    case 332:
      if (lookahead == '\n') SKIP(723)
      if (lookahead == '\r') SKIP(331)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 333:
      if (lookahead == '\n') SKIP(609)
      END_STATE();
    case 334:
      if (lookahead == '\n') SKIP(609)
      if (lookahead == '\r') SKIP(333)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 335:
      if (lookahead == '\n') SKIP(666)
      END_STATE();
    case 336:
      if (lookahead == '\n') SKIP(666)
      if (lookahead == '\r') SKIP(335)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 337:
      if (lookahead == '\n') SKIP(612)
      END_STATE();
    case 338:
      if (lookahead == '\n') SKIP(612)
      if (lookahead == '\r') SKIP(337)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 339:
      if (lookahead == '\n') SKIP(669)
      END_STATE();
    case 340:
      if (lookahead == '\n') SKIP(669)
      if (lookahead == '\r') SKIP(339)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 341:
      if (lookahead == '\n') SKIP(614)
      END_STATE();
    case 342:
      if (lookahead == '\n') SKIP(614)
      if (lookahead == '\r') SKIP(341)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 343:
      if (lookahead == '\n') SKIP(767)
      END_STATE();
    case 344:
      if (lookahead == '\n') SKIP(767)
      if (lookahead == '\r') SKIP(343)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 345:
      if (lookahead == '\n') SKIP(791)
      END_STATE();
    case 346:
      if (lookahead == '\n') SKIP(791)
      if (lookahead == '\r') SKIP(345)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 347:
      if (lookahead == '\n') SKIP(831)
      END_STATE();
    case 348:
      if (lookahead == '\n') SKIP(831)
      if (lookahead == '\r') SKIP(347)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 349:
      if (lookahead == '\n') SKIP(740)
      END_STATE();
    case 350:
      if (lookahead == '\n') SKIP(740)
      if (lookahead == '\r') SKIP(349)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 351:
      if (lookahead == '\n') SKIP(593)
      END_STATE();
    case 352:
      if (lookahead == '\n') SKIP(593)
      if (lookahead == '\r') SKIP(351)
      END_STATE();
    case 353:
      if (lookahead == '\n') SKIP(638)
      END_STATE();
    case 354:
      if (lookahead == '\n') SKIP(638)
      if (lookahead == '\r') SKIP(353)
      END_STATE();
    case 355:
      if (lookahead == '\n') SKIP(812)
      END_STATE();
    case 356:
      if (lookahead == '\n') SKIP(812)
      if (lookahead == '\r') SKIP(355)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 357:
      if (lookahead == '\n') SKIP(803)
      END_STATE();
    case 358:
      if (lookahead == '\n') SKIP(803)
      if (lookahead == '\r') SKIP(357)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 359:
      if (lookahead == '\n') SKIP(589)
      END_STATE();
    case 360:
      if (lookahead == '\n') SKIP(589)
      if (lookahead == '\r') SKIP(359)
      END_STATE();
    case 361:
      if (lookahead == '\n') SKIP(867)
      END_STATE();
    case 362:
      if (lookahead == '\n') SKIP(867)
      if (lookahead == '\r') SKIP(361)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 363:
      if (lookahead == '\n') SKIP(813)
      END_STATE();
    case 364:
      if (lookahead == '\n') SKIP(813)
      if (lookahead == '\r') SKIP(363)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 365:
      if (lookahead == '\n') SKIP(799)
      END_STATE();
    case 366:
      if (lookahead == '\n') SKIP(799)
      if (lookahead == '\r') SKIP(365)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 367:
      if (lookahead == '\n') SKIP(840)
      END_STATE();
    case 368:
      if (lookahead == '\n') SKIP(840)
      if (lookahead == '\r') SKIP(367)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 369:
      if (lookahead == '\n') SKIP(844)
      END_STATE();
    case 370:
      if (lookahead == '\n') SKIP(844)
      if (lookahead == '\r') SKIP(369)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 371:
      if (lookahead == '\n') SKIP(646)
      END_STATE();
    case 372:
      if (lookahead == '\n') SKIP(646)
      if (lookahead == '\r') SKIP(371)
      END_STATE();
    case 373:
      if (lookahead == '\n') SKIP(598)
      END_STATE();
    case 374:
      if (lookahead == '\n') SKIP(598)
      if (lookahead == '\r') SKIP(373)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 375:
      if (lookahead == '\n') SKIP(651)
      END_STATE();
    case 376:
      if (lookahead == '\n') SKIP(651)
      if (lookahead == '\r') SKIP(375)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 377:
      if (lookahead == '\n') SKIP(606)
      END_STATE();
    case 378:
      if (lookahead == '\n') SKIP(606)
      if (lookahead == '\r') SKIP(377)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 379:
      if (lookahead == '\n') SKIP(656)
      END_STATE();
    case 380:
      if (lookahead == '\n') SKIP(656)
      if (lookahead == '\r') SKIP(379)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 381:
      if (lookahead == '\n') SKIP(626)
      END_STATE();
    case 382:
      if (lookahead == '\n') SKIP(626)
      if (lookahead == '\r') SKIP(381)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 383:
      if (lookahead == '\n') SKIP(720)
      END_STATE();
    case 384:
      if (lookahead == '\n') SKIP(720)
      if (lookahead == '\r') SKIP(383)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 385:
      if (lookahead == '\n') SKIP(664)
      END_STATE();
    case 386:
      if (lookahead == '\n') SKIP(664)
      if (lookahead == '\r') SKIP(385)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 387:
      if (lookahead == '\n') SKIP(724)
      END_STATE();
    case 388:
      if (lookahead == '\n') SKIP(724)
      if (lookahead == '\r') SKIP(387)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 389:
      if (lookahead == '\n') SKIP(668)
      END_STATE();
    case 390:
      if (lookahead == '\n') SKIP(668)
      if (lookahead == '\r') SKIP(389)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 391:
      if (lookahead == '\n') SKIP(671)
      END_STATE();
    case 392:
      if (lookahead == '\n') SKIP(671)
      if (lookahead == '\r') SKIP(391)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 393:
      if (lookahead == '\n') SKIP(639)
      END_STATE();
    case 394:
      if (lookahead == '\n') SKIP(639)
      if (lookahead == '\r') SKIP(393)
      END_STATE();
    case 395:
      if (lookahead == '\n') SKIP(815)
      END_STATE();
    case 396:
      if (lookahead == '\n') SKIP(815)
      if (lookahead == '\r') SKIP(395)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 397:
      if (lookahead == '\n') SKIP(814)
      END_STATE();
    case 398:
      if (lookahead == '\n') SKIP(814)
      if (lookahead == '\r') SKIP(397)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 399:
      if (lookahead == '\n') SKIP(800)
      END_STATE();
    case 400:
      if (lookahead == '\n') SKIP(800)
      if (lookahead == '\r') SKIP(399)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 401:
      if (lookahead == '\n') SKIP(841)
      END_STATE();
    case 402:
      if (lookahead == '\n') SKIP(841)
      if (lookahead == '\r') SKIP(401)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 403:
      if (lookahead == '\n') SKIP(845)
      END_STATE();
    case 404:
      if (lookahead == '\n') SKIP(845)
      if (lookahead == '\r') SKIP(403)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 405:
      if (lookahead == '\n') SKIP(599)
      END_STATE();
    case 406:
      if (lookahead == '\n') SKIP(599)
      if (lookahead == '\r') SKIP(405)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 407:
      if (lookahead == '\n') SKIP(652)
      END_STATE();
    case 408:
      if (lookahead == '\n') SKIP(652)
      if (lookahead == '\r') SKIP(407)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 409:
      if (lookahead == '\n') SKIP(607)
      END_STATE();
    case 410:
      if (lookahead == '\n') SKIP(607)
      if (lookahead == '\r') SKIP(409)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 411:
      if (lookahead == '\n') SKIP(657)
      END_STATE();
    case 412:
      if (lookahead == '\n') SKIP(657)
      if (lookahead == '\r') SKIP(411)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 413:
      if (lookahead == '\n') SKIP(627)
      END_STATE();
    case 414:
      if (lookahead == '\n') SKIP(627)
      if (lookahead == '\r') SKIP(413)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 415:
      if (lookahead == '\n') SKIP(721)
      END_STATE();
    case 416:
      if (lookahead == '\n') SKIP(721)
      if (lookahead == '\r') SKIP(415)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 417:
      if (lookahead == '\n') SKIP(725)
      END_STATE();
    case 418:
      if (lookahead == '\n') SKIP(725)
      if (lookahead == '\r') SKIP(417)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 419:
      if (lookahead == '\n') SKIP(670)
      END_STATE();
    case 420:
      if (lookahead == '\n') SKIP(670)
      if (lookahead == '\r') SKIP(419)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 421:
      if (lookahead == '\n') SKIP(672)
      END_STATE();
    case 422:
      if (lookahead == '\n') SKIP(672)
      if (lookahead == '\r') SKIP(421)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 423:
      if (lookahead == '\n') SKIP(640)
      END_STATE();
    case 424:
      if (lookahead == '\n') SKIP(640)
      if (lookahead == '\r') SKIP(423)
      END_STATE();
    case 425:
      if (lookahead == '\n') SKIP(817)
      END_STATE();
    case 426:
      if (lookahead == '\n') SKIP(817)
      if (lookahead == '\r') SKIP(425)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 427:
      if (lookahead == '\n') SKIP(818)
      END_STATE();
    case 428:
      if (lookahead == '\n') SKIP(818)
      if (lookahead == '\r') SKIP(427)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 429:
      if (lookahead == '\n') SKIP(801)
      END_STATE();
    case 430:
      if (lookahead == '\n') SKIP(801)
      if (lookahead == '\r') SKIP(429)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 431:
      if (lookahead == '\n') SKIP(847)
      END_STATE();
    case 432:
      if (lookahead == '\n') SKIP(847)
      if (lookahead == '\r') SKIP(431)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 433:
      if (lookahead == '\n') SKIP(660)
      END_STATE();
    case 434:
      if (lookahead == '\n') SKIP(660)
      if (lookahead == '\r') SKIP(433)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 435:
      if (lookahead == '\n') SKIP(628)
      END_STATE();
    case 436:
      if (lookahead == '\n') SKIP(628)
      if (lookahead == '\r') SKIP(435)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 437:
      if (lookahead == '\n') SKIP(641)
      END_STATE();
    case 438:
      if (lookahead == '\n') SKIP(641)
      if (lookahead == '\r') SKIP(437)
      END_STATE();
    case 439:
      if (lookahead == '\n') SKIP(661)
      END_STATE();
    case 440:
      if (lookahead == '\n') SKIP(661)
      if (lookahead == '\r') SKIP(439)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 441:
      if (lookahead == '\n') SKIP(629)
      END_STATE();
    case 442:
      if (lookahead == '\n') SKIP(629)
      if (lookahead == '\r') SKIP(441)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 443:
      if (lookahead == '\n') SKIP(642)
      END_STATE();
    case 444:
      if (lookahead == '\n') SKIP(642)
      if (lookahead == '\r') SKIP(443)
      END_STATE();
    case 445:
      if (lookahead == '\n') SKIP(662)
      END_STATE();
    case 446:
      if (lookahead == '\n') SKIP(662)
      if (lookahead == '\r') SKIP(445)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 447:
      if (lookahead == '\n') SKIP(870)
      END_STATE();
    case 448:
      if (lookahead == '\n') SKIP(870)
      if (lookahead == '\r') SKIP(447)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 449:
      if (lookahead == '\n') SKIP(848)
      END_STATE();
    case 450:
      if (lookahead == '\n') SKIP(848)
      if (lookahead == '\r') SKIP(449)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 451:
      if (lookahead == '\n') SKIP(869)
      END_STATE();
    case 452:
      if (lookahead == '\n') SKIP(869)
      if (lookahead == '\r') SKIP(451)
      END_STATE();
    case 453:
      if (lookahead == '\n') SKIP(677)
      END_STATE();
    case 454:
      if (lookahead == '\n') SKIP(677)
      if (lookahead == '\r') SKIP(453)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 455:
      if (lookahead == '\n') SKIP(717)
      END_STATE();
    case 456:
      if (lookahead == '\n') SKIP(717)
      if (lookahead == '\r') SKIP(455)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 457:
      if (lookahead == '\n') SKIP(681)
      END_STATE();
    case 458:
      if (lookahead == '\n') SKIP(681)
      if (lookahead == '\r') SKIP(457)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 459:
      if (lookahead == '\n') SKIP(683)
      END_STATE();
    case 460:
      if (lookahead == '\n') SKIP(683)
      if (lookahead == '\r') SKIP(459)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 461:
      if (lookahead == '\n') SKIP(726)
      END_STATE();
    case 462:
      if (lookahead == '\n') SKIP(726)
      if (lookahead == '\r') SKIP(461)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 463:
      if (lookahead == '\n') SKIP(684)
      END_STATE();
    case 464:
      if (lookahead == '\n') SKIP(684)
      if (lookahead == '\r') SKIP(463)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 465:
      if (lookahead == '\n') SKIP(685)
      END_STATE();
    case 466:
      if (lookahead == '\n') SKIP(685)
      if (lookahead == '\r') SKIP(465)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 467:
      if (lookahead == '\n') SKIP(730)
      END_STATE();
    case 468:
      if (lookahead == '\n') SKIP(730)
      if (lookahead == '\r') SKIP(467)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 469:
      if (lookahead == '\n') SKIP(780)
      END_STATE();
    case 470:
      if (lookahead == '\n') SKIP(780)
      if (lookahead == '\r') SKIP(469)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 471:
      if (lookahead == '\n') SKIP(781)
      END_STATE();
    case 472:
      if (lookahead == '\n') SKIP(781)
      if (lookahead == '\r') SKIP(471)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 473:
      if (lookahead == '\n') SKIP(687)
      END_STATE();
    case 474:
      if (lookahead == '\n') SKIP(687)
      if (lookahead == '\r') SKIP(473)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 475:
      if (lookahead == '\n') SKIP(689)
      END_STATE();
    case 476:
      if (lookahead == '\n') SKIP(689)
      if (lookahead == '\r') SKIP(475)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 477:
      if (lookahead == '\n') SKIP(819)
      END_STATE();
    case 478:
      if (lookahead == '\n') SKIP(819)
      if (lookahead == '\r') SKIP(477)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 479:
      if (lookahead == '\n') SKIP(768)
      END_STATE();
    case 480:
      if (lookahead == '\n') SKIP(768)
      if (lookahead == '\r') SKIP(479)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 481:
      if (lookahead == '\n') SKIP(793)
      END_STATE();
    case 482:
      if (lookahead == '\n') SKIP(793)
      if (lookahead == '\r') SKIP(481)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 483:
      if (lookahead == '\n') SKIP(835)
      END_STATE();
    case 484:
      if (lookahead == '\n') SKIP(835)
      if (lookahead == '\r') SKIP(483)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 485:
      if (lookahead == '\n') SKIP(695)
      END_STATE();
    case 486:
      if (lookahead == '\n') SKIP(695)
      if (lookahead == '\r') SKIP(485)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 487:
      if (lookahead == '\n') SKIP(696)
      END_STATE();
    case 488:
      if (lookahead == '\n') SKIP(696)
      if (lookahead == '\r') SKIP(487)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 489:
      if (lookahead == '\n') SKIP(741)
      END_STATE();
    case 490:
      if (lookahead == '\n') SKIP(741)
      if (lookahead == '\r') SKIP(489)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 491:
      if (lookahead == '\n') SKIP(849)
      END_STATE();
    case 492:
      if (lookahead == '\n') SKIP(849)
      if (lookahead == '\r') SKIP(491)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 493:
      if (lookahead == '\n') SKIP(820)
      END_STATE();
    case 494:
      if (lookahead == '\n') SKIP(820)
      if (lookahead == '\r') SKIP(493)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 495:
      if (lookahead == '\n') SKIP(821)
      END_STATE();
    case 496:
      if (lookahead == '\n') SKIP(821)
      if (lookahead == '\r') SKIP(495)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 497:
      if (lookahead == '\n') SKIP(838)
      END_STATE();
    case 498:
      if (lookahead == '\n') SKIP(838)
      if (lookahead == '\r') SKIP(497)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 499:
      if (lookahead == '\n') SKIP(678)
      END_STATE();
    case 500:
      if (lookahead == '\n') SKIP(678)
      if (lookahead == '\r') SKIP(499)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 501:
      if (lookahead == '\n') SKIP(682)
      END_STATE();
    case 502:
      if (lookahead == '\n') SKIP(682)
      if (lookahead == '\r') SKIP(501)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 503:
      if (lookahead == '\n') SKIP(727)
      END_STATE();
    case 504:
      if (lookahead == '\n') SKIP(727)
      if (lookahead == '\r') SKIP(503)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 505:
      if (lookahead == '\n') SKIP(731)
      END_STATE();
    case 506:
      if (lookahead == '\n') SKIP(731)
      if (lookahead == '\r') SKIP(505)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 507:
      if (lookahead == '\n') SKIP(688)
      END_STATE();
    case 508:
      if (lookahead == '\n') SKIP(688)
      if (lookahead == '\r') SKIP(507)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 509:
      if (lookahead == '\n') SKIP(691)
      END_STATE();
    case 510:
      if (lookahead == '\n') SKIP(691)
      if (lookahead == '\r') SKIP(509)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 511:
      if (lookahead == '\n') SKIP(794)
      END_STATE();
    case 512:
      if (lookahead == '\n') SKIP(794)
      if (lookahead == '\r') SKIP(511)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 513:
      if (lookahead == '\n') SKIP(822)
      END_STATE();
    case 514:
      if (lookahead == '\n') SKIP(822)
      if (lookahead == '\r') SKIP(513)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 515:
      if (lookahead == '\n') SKIP(679)
      END_STATE();
    case 516:
      if (lookahead == '\n') SKIP(679)
      if (lookahead == '\r') SKIP(515)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 517:
      if (lookahead == '\n') SKIP(728)
      END_STATE();
    case 518:
      if (lookahead == '\n') SKIP(728)
      if (lookahead == '\r') SKIP(517)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 519:
      if (lookahead == '\n') SKIP(690)
      END_STATE();
    case 520:
      if (lookahead == '\n') SKIP(690)
      if (lookahead == '\r') SKIP(519)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 521:
      if (lookahead == '\n') SKIP(693)
      END_STATE();
    case 522:
      if (lookahead == '\n') SKIP(693)
      if (lookahead == '\r') SKIP(521)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 523:
      if (lookahead == '\n') SKIP(823)
      END_STATE();
    case 524:
      if (lookahead == '\n') SKIP(823)
      if (lookahead == '\r') SKIP(523)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 525:
      if (lookahead == '\n') SKIP(680)
      END_STATE();
    case 526:
      if (lookahead == '\n') SKIP(680)
      if (lookahead == '\r') SKIP(525)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 527:
      if (lookahead == '\n') SKIP(729)
      END_STATE();
    case 528:
      if (lookahead == '\n') SKIP(729)
      if (lookahead == '\r') SKIP(527)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 529:
      if (lookahead == '\n') SKIP(692)
      END_STATE();
    case 530:
      if (lookahead == '\n') SKIP(692)
      if (lookahead == '\r') SKIP(529)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 531:
      if (lookahead == '\n') SKIP(694)
      END_STATE();
    case 532:
      if (lookahead == '\n') SKIP(694)
      if (lookahead == '\r') SKIP(531)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 533:
      if (lookahead == '\n') SKIP(824)
      END_STATE();
    case 534:
      if (lookahead == '\n') SKIP(824)
      if (lookahead == '\r') SKIP(533)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 535:
      if (lookahead == '\n') SKIP(850)
      END_STATE();
    case 536:
      if (lookahead == '\n') SKIP(850)
      if (lookahead == '\r') SKIP(535)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 537:
      if (lookahead == '\n') SKIP(686)
      END_STATE();
    case 538:
      if (lookahead == '\n') SKIP(686)
      if (lookahead == '\r') SKIP(537)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 539:
      if (lookahead == '\n') SKIP(698)
      END_STATE();
    case 540:
      if (lookahead == '\n') SKIP(698)
      if (lookahead == '\r') SKIP(539)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 541:
      if (lookahead == '\n') SKIP(732)
      END_STATE();
    case 542:
      if (lookahead == '\n') SKIP(732)
      if (lookahead == '\r') SKIP(541)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 543:
      if (lookahead == '\n') SKIP(697)
      END_STATE();
    case 544:
      if (lookahead == '\n') SKIP(697)
      if (lookahead == '\r') SKIP(543)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 545:
      if (lookahead == '\n') SKIP(733)
      END_STATE();
    case 546:
      if (lookahead == '\n') SKIP(733)
      if (lookahead == '\r') SKIP(545)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 547:
      if (lookahead == '\n') SKIP(699)
      END_STATE();
    case 548:
      if (lookahead == '\n') SKIP(699)
      if (lookahead == '\r') SKIP(547)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 549:
      if (lookahead == '\n') SKIP(702)
      END_STATE();
    case 550:
      if (lookahead == '\n') SKIP(702)
      if (lookahead == '\r') SKIP(549)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 551:
      if (lookahead == '\n') SKIP(734)
      END_STATE();
    case 552:
      if (lookahead == '\n') SKIP(734)
      if (lookahead == '\r') SKIP(551)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 553:
      if (lookahead == '\n') SKIP(705)
      END_STATE();
    case 554:
      if (lookahead == '\n') SKIP(705)
      if (lookahead == '\r') SKIP(553)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 555:
      if (lookahead == '\n') SKIP(707)
      END_STATE();
    case 556:
      if (lookahead == '\n') SKIP(707)
      if (lookahead == '\r') SKIP(555)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 557:
      if (lookahead == '\n') SKIP(700)
      END_STATE();
    case 558:
      if (lookahead == '\n') SKIP(700)
      if (lookahead == '\r') SKIP(557)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 559:
      if (lookahead == '\n') SKIP(701)
      END_STATE();
    case 560:
      if (lookahead == '\n') SKIP(701)
      if (lookahead == '\r') SKIP(559)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 561:
      if (lookahead == '\n') SKIP(735)
      END_STATE();
    case 562:
      if (lookahead == '\n') SKIP(735)
      if (lookahead == '\r') SKIP(561)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 563:
      if (lookahead == '\n') SKIP(706)
      END_STATE();
    case 564:
      if (lookahead == '\n') SKIP(706)
      if (lookahead == '\r') SKIP(563)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 565:
      if (lookahead == '\n') SKIP(708)
      END_STATE();
    case 566:
      if (lookahead == '\n') SKIP(708)
      if (lookahead == '\r') SKIP(565)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 567:
      if (lookahead == '\n') SKIP(703)
      END_STATE();
    case 568:
      if (lookahead == '\n') SKIP(703)
      if (lookahead == '\r') SKIP(567)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 569:
      if (lookahead == '\n') SKIP(704)
      END_STATE();
    case 570:
      if (lookahead == '\n') SKIP(704)
      if (lookahead == '\r') SKIP(569)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 571:
      if (lookahead == '\n') SKIP(709)
      END_STATE();
    case 572:
      if (lookahead == '\n') SKIP(709)
      if (lookahead == '\r') SKIP(571)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 573:
      if (lookahead == '\n') SKIP(711)
      END_STATE();
    case 574:
      if (lookahead == '\n') SKIP(711)
      if (lookahead == '\r') SKIP(573)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 575:
      if (lookahead == '\n') SKIP(713)
      END_STATE();
    case 576:
      if (lookahead == '\n') SKIP(713)
      if (lookahead == '\r') SKIP(575)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 577:
      if (lookahead == '\n') SKIP(710)
      END_STATE();
    case 578:
      if (lookahead == '\n') SKIP(710)
      if (lookahead == '\r') SKIP(577)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 579:
      if (lookahead == '\n') SKIP(712)
      END_STATE();
    case 580:
      if (lookahead == '\n') SKIP(712)
      if (lookahead == '\r') SKIP(579)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 581:
      if (lookahead == '\n') SKIP(714)
      END_STATE();
    case 582:
      if (lookahead == '\n') SKIP(714)
      if (lookahead == '\r') SKIP(581)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2302);
      END_STATE();
    case 583:
      if (lookahead == ' ') ADVANCE(1811);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(1278);
      END_STATE();
    case 584:
      if (lookahead == '!') ADVANCE(586);
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '#') ADVANCE(3428);
      if (lookahead == '$') ADVANCE(3442);
      if (lookahead == '%') ADVANCE(3422);
      if (lookahead == '&') ADVANCE(3426);
      if (lookahead == '\'') ADVANCE(3387);
      if (lookahead == '(') ADVANCE(2236);
      if (lookahead == ')') ADVANCE(2237);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == ',') ADVANCE(2228);
      if (lookahead == '-') ADVANCE(3412);
      if (lookahead == '.') ADVANCE(3386);
      if (lookahead == '/') ADVANCE(3421);
      if (lookahead == ':') ADVANCE(2311);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '<') ADVANCE(3429);
      if (lookahead == '=') ADVANCE(2401);
      if (lookahead == '>') ADVANCE(3433);
      if (lookahead == '@') ADVANCE(3416);
      if (lookahead == 'C') ADVANCE(906);
      if (lookahead == '[') ADVANCE(3403);
      if (lookahead == '\\') ADVANCE(2);
      if (lookahead == ']') ADVANCE(3404);
      if (lookahead == '^') ADVANCE(3419);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == 'c') ADVANCE(933);
      if (lookahead == '|') ADVANCE(3427);
      if (lookahead == '~') ADVANCE(3415);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1120);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(1158);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(950);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(934);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(936);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(1769);
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(937);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1343);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(1707);
      if (lookahead == 'K' ||
          lookahead == 'k') ADVANCE(1159);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(938);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(939);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1160);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1344);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(940);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(952);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(941);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(988);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(1611);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(951);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(1402);
      if (lookahead == 'Z' ||
          lookahead == 'z') ADVANCE(1742);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(584)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(3443);
      END_STATE();
    case 585:
      if (lookahead == '!') ADVANCE(3413);
      END_STATE();
    case 586:
      if (lookahead == '!') ADVANCE(3413);
      if (lookahead == '=') ADVANCE(3432);
      if (lookahead == '~') ADVANCE(3435);
      END_STATE();
    case 587:
      if (lookahead == '!') ADVANCE(890);
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '#') ADVANCE(3428);
      if (lookahead == '%') ADVANCE(3422);
      if (lookahead == '&') ADVANCE(3425);
      if (lookahead == '(') ADVANCE(2236);
      if (lookahead == ')') ADVANCE(2237);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == ',') ADVANCE(2228);
      if (lookahead == '-') ADVANCE(3412);
      if (lookahead == '.') ADVANCE(3386);
      if (lookahead == '/') ADVANCE(3421);
      if (lookahead == ':') ADVANCE(889);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '<') ADVANCE(3429);
      if (lookahead == '=') ADVANCE(2401);
      if (lookahead == '>') ADVANCE(3433);
      if (lookahead == '[') ADVANCE(3403);
      if (lookahead == '\\') ADVANCE(62);
      if (lookahead == '^') ADVANCE(3419);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == '|') ADVANCE(3427);
      if (lookahead == '~') ADVANCE(3415);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2989);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(2785);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3159);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2860);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3201);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3186);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3076);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(3141);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2831);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3165);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(2891);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2937);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2811);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3213);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3179);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2925);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(587)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('E' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 588:
      if (lookahead == '!') ADVANCE(890);
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '#') ADVANCE(3428);
      if (lookahead == '%') ADVANCE(3422);
      if (lookahead == '&') ADVANCE(3425);
      if (lookahead == '(') ADVANCE(2236);
      if (lookahead == ')') ADVANCE(2237);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == ',') ADVANCE(2228);
      if (lookahead == '-') ADVANCE(3412);
      if (lookahead == '.') ADVANCE(3386);
      if (lookahead == '/') ADVANCE(3421);
      if (lookahead == ':') ADVANCE(889);
      if (lookahead == '<') ADVANCE(3429);
      if (lookahead == '=') ADVANCE(2401);
      if (lookahead == '>') ADVANCE(3433);
      if (lookahead == '[') ADVANCE(3403);
      if (lookahead == '\\') SKIP(154)
      if (lookahead == '^') ADVANCE(3419);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == '|') ADVANCE(3427);
      if (lookahead == '~') ADVANCE(3415);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3112);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3201);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3216);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3085);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(3141);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2831);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3165);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(2891);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2938);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2920);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(588)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('B' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 589:
      if (lookahead == '!') ADVANCE(890);
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '#') ADVANCE(3428);
      if (lookahead == '%') ADVANCE(3422);
      if (lookahead == '&') ADVANCE(3425);
      if (lookahead == '(') ADVANCE(2236);
      if (lookahead == ')') ADVANCE(2237);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == ',') ADVANCE(2228);
      if (lookahead == '-') ADVANCE(3412);
      if (lookahead == '.') ADVANCE(3386);
      if (lookahead == '/') ADVANCE(3421);
      if (lookahead == ':') ADVANCE(889);
      if (lookahead == '<') ADVANCE(3429);
      if (lookahead == '=') ADVANCE(2401);
      if (lookahead == '>') ADVANCE(3433);
      if (lookahead == '[') ADVANCE(3403);
      if (lookahead == '\\') SKIP(360)
      if (lookahead == '^') ADVANCE(3419);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == '|') ADVANCE(3427);
      if (lookahead == '~') ADVANCE(3415);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3112);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3320);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3216);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3086);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(3141);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2831);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3165);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(2891);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2938);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2920);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(589)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('B' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 590:
      if (lookahead == '!') ADVANCE(890);
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '#') ADVANCE(3428);
      if (lookahead == '%') ADVANCE(3422);
      if (lookahead == '&') ADVANCE(3425);
      if (lookahead == '(') ADVANCE(2236);
      if (lookahead == ')') ADVANCE(2237);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == ',') ADVANCE(2228);
      if (lookahead == '-') ADVANCE(3412);
      if (lookahead == '.') ADVANCE(3386);
      if (lookahead == '/') ADVANCE(3421);
      if (lookahead == ':') ADVANCE(889);
      if (lookahead == '<') ADVANCE(3429);
      if (lookahead == '=') ADVANCE(2401);
      if (lookahead == '>') ADVANCE(3433);
      if (lookahead == '[') ADVANCE(3403);
      if (lookahead == '\\') SKIP(228)
      if (lookahead == '^') ADVANCE(3419);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == '|') ADVANCE(3427);
      if (lookahead == '~') ADVANCE(3415);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3113);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2854);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3089);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3165);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3195);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(590)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('B' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 591:
      if (lookahead == '!') ADVANCE(890);
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '#') ADVANCE(3428);
      if (lookahead == '%') ADVANCE(3422);
      if (lookahead == '&') ADVANCE(3425);
      if (lookahead == '(') ADVANCE(2236);
      if (lookahead == ')') ADVANCE(2237);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == ',') ADVANCE(2228);
      if (lookahead == '-') ADVANCE(3412);
      if (lookahead == '.') ADVANCE(3386);
      if (lookahead == '/') ADVANCE(3421);
      if (lookahead == ':') ADVANCE(889);
      if (lookahead == '<') ADVANCE(3429);
      if (lookahead == '=') ADVANCE(2401);
      if (lookahead == '>') ADVANCE(3433);
      if (lookahead == '[') ADVANCE(3403);
      if (lookahead == '\\') SKIP(232)
      if (lookahead == '^') ADVANCE(3419);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == '|') ADVANCE(3427);
      if (lookahead == '~') ADVANCE(3415);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3112);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3089);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3165);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3195);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2929);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(591)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('B' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 592:
      if (lookahead == '!') ADVANCE(890);
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '#') ADVANCE(3428);
      if (lookahead == '%') ADVANCE(3422);
      if (lookahead == '&') ADVANCE(3425);
      if (lookahead == '(') ADVANCE(2236);
      if (lookahead == ')') ADVANCE(2237);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == ',') ADVANCE(2228);
      if (lookahead == '-') ADVANCE(3412);
      if (lookahead == '.') ADVANCE(3385);
      if (lookahead == '/') ADVANCE(3421);
      if (lookahead == '<') ADVANCE(3429);
      if (lookahead == '=') ADVANCE(2401);
      if (lookahead == '>') ADVANCE(3433);
      if (lookahead == '[') ADVANCE(3403);
      if (lookahead == '\\') SKIP(136)
      if (lookahead == '^') ADVANCE(3419);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == '|') ADVANCE(3427);
      if (lookahead == '~') ADVANCE(3415);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3112);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3201);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3216);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3085);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(3141);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2831);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3165);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(2891);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(3220);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2938);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(2691);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2919);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(592)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('B' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 593:
      if (lookahead == '!') ADVANCE(890);
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '#') ADVANCE(3428);
      if (lookahead == '%') ADVANCE(3422);
      if (lookahead == '&') ADVANCE(3425);
      if (lookahead == '(') ADVANCE(2236);
      if (lookahead == ')') ADVANCE(2237);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == ',') ADVANCE(2228);
      if (lookahead == '-') ADVANCE(3412);
      if (lookahead == '.') ADVANCE(3385);
      if (lookahead == '/') ADVANCE(3421);
      if (lookahead == '<') ADVANCE(3429);
      if (lookahead == '=') ADVANCE(2401);
      if (lookahead == '>') ADVANCE(3433);
      if (lookahead == '[') ADVANCE(3403);
      if (lookahead == '\\') SKIP(352)
      if (lookahead == '^') ADVANCE(3419);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == '|') ADVANCE(3427);
      if (lookahead == '~') ADVANCE(3415);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3112);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3320);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3216);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3086);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(3141);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2831);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3165);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(2891);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(3220);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2938);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(2691);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2919);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(593)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('B' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 594:
      if (lookahead == '!') ADVANCE(890);
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '#') ADVANCE(3428);
      if (lookahead == '%') ADVANCE(3422);
      if (lookahead == '&') ADVANCE(3425);
      if (lookahead == '(') ADVANCE(2236);
      if (lookahead == ')') ADVANCE(2237);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == ',') ADVANCE(2228);
      if (lookahead == '-') ADVANCE(3412);
      if (lookahead == '.') ADVANCE(3385);
      if (lookahead == '/') ADVANCE(3421);
      if (lookahead == '<') ADVANCE(3429);
      if (lookahead == '=') ADVANCE(2401);
      if (lookahead == '>') ADVANCE(3433);
      if (lookahead == '[') ADVANCE(3403);
      if (lookahead == '\\') SKIP(216)
      if (lookahead == '^') ADVANCE(3419);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == '|') ADVANCE(3427);
      if (lookahead == '~') ADVANCE(3415);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3112);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3089);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3165);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3195);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(3220);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(2691);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2922);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(594)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('B' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 595:
      if (lookahead == '!') ADVANCE(890);
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '#') ADVANCE(3428);
      if (lookahead == '%') ADVANCE(3422);
      if (lookahead == '&') ADVANCE(3425);
      if (lookahead == '(') ADVANCE(2236);
      if (lookahead == ')') ADVANCE(2237);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == ',') ADVANCE(2228);
      if (lookahead == '-') ADVANCE(3412);
      if (lookahead == '.') ADVANCE(3385);
      if (lookahead == '/') ADVANCE(3421);
      if (lookahead == '<') ADVANCE(3429);
      if (lookahead == '=') ADVANCE(2401);
      if (lookahead == '>') ADVANCE(3433);
      if (lookahead == '[') ADVANCE(3403);
      if (lookahead == '\\') SKIP(218)
      if (lookahead == '^') ADVANCE(3419);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == '|') ADVANCE(3427);
      if (lookahead == '~') ADVANCE(3415);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3113);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2854);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3089);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3165);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3195);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(3220);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(2691);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2970);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(595)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('B' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 596:
      if (lookahead == '!') ADVANCE(890);
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '#') ADVANCE(3428);
      if (lookahead == '%') ADVANCE(3422);
      if (lookahead == '&') ADVANCE(3425);
      if (lookahead == '(') ADVANCE(2236);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == ',') ADVANCE(2228);
      if (lookahead == '-') ADVANCE(3412);
      if (lookahead == '.') ADVANCE(3386);
      if (lookahead == '/') ADVANCE(3421);
      if (lookahead == ':') ADVANCE(889);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '<') ADVANCE(3429);
      if (lookahead == '=') ADVANCE(2401);
      if (lookahead == '>') ADVANCE(3433);
      if (lookahead == '[') ADVANCE(3403);
      if (lookahead == '\\') ADVANCE(10);
      if (lookahead == '^') ADVANCE(3419);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == '|') ADVANCE(3427);
      if (lookahead == '~') ADVANCE(3415);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2989);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(2785);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(2710);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2786);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3357);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3201);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3186);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3048);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(3141);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2684);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3142);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3145);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(2891);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2673);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2787);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2826);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3197);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3179);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(2690);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2919);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(596)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('H' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 597:
      if (lookahead == '!') ADVANCE(890);
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '#') ADVANCE(3428);
      if (lookahead == '%') ADVANCE(3422);
      if (lookahead == '&') ADVANCE(3425);
      if (lookahead == '(') ADVANCE(2236);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == ',') ADVANCE(2228);
      if (lookahead == '-') ADVANCE(3412);
      if (lookahead == '.') ADVANCE(3386);
      if (lookahead == '/') ADVANCE(3421);
      if (lookahead == ':') ADVANCE(889);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '<') ADVANCE(3429);
      if (lookahead == '=') ADVANCE(2401);
      if (lookahead == '>') ADVANCE(3433);
      if (lookahead == '[') ADVANCE(3403);
      if (lookahead == '\\') ADVANCE(308);
      if (lookahead == '^') ADVANCE(3419);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == '|') ADVANCE(3427);
      if (lookahead == '~') ADVANCE(3415);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2989);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(2785);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(2710);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2786);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3357);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3320);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3186);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3049);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(3141);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2684);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3142);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3145);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(2891);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2673);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2787);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2826);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3197);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3179);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(2690);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2919);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(597)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('H' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 598:
      if (lookahead == '!') ADVANCE(890);
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '#') ADVANCE(3428);
      if (lookahead == '%') ADVANCE(3422);
      if (lookahead == '&') ADVANCE(3425);
      if (lookahead == '(') ADVANCE(2236);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == ',') ADVANCE(2228);
      if (lookahead == '-') ADVANCE(3412);
      if (lookahead == '.') ADVANCE(3386);
      if (lookahead == '/') ADVANCE(3421);
      if (lookahead == ':') ADVANCE(889);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '<') ADVANCE(3429);
      if (lookahead == '=') ADVANCE(2401);
      if (lookahead == '>') ADVANCE(3433);
      if (lookahead == '[') ADVANCE(3403);
      if (lookahead == '\\') ADVANCE(374);
      if (lookahead == '^') ADVANCE(3419);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == '|') ADVANCE(3427);
      if (lookahead == '~') ADVANCE(3415);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2989);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(2785);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(2710);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2786);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3357);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3201);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3186);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3048);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(3141);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2684);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3142);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3145);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(2891);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2674);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2787);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2826);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3197);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3179);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3154);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2925);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(598)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('H' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 599:
      if (lookahead == '!') ADVANCE(890);
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '#') ADVANCE(3428);
      if (lookahead == '%') ADVANCE(3422);
      if (lookahead == '&') ADVANCE(3425);
      if (lookahead == '(') ADVANCE(2236);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == ',') ADVANCE(2228);
      if (lookahead == '-') ADVANCE(3412);
      if (lookahead == '.') ADVANCE(3386);
      if (lookahead == '/') ADVANCE(3421);
      if (lookahead == ':') ADVANCE(889);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '<') ADVANCE(3429);
      if (lookahead == '=') ADVANCE(2401);
      if (lookahead == '>') ADVANCE(3433);
      if (lookahead == '[') ADVANCE(3403);
      if (lookahead == '\\') ADVANCE(406);
      if (lookahead == '^') ADVANCE(3419);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == '|') ADVANCE(3427);
      if (lookahead == '~') ADVANCE(3415);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2989);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(2785);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(2710);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2786);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3357);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3320);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3186);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3049);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(3141);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2684);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3142);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3145);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(2891);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2674);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2787);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2826);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3197);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3179);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3154);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2925);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(599)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('H' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 600:
      if (lookahead == '!') ADVANCE(890);
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '#') ADVANCE(3428);
      if (lookahead == '%') ADVANCE(3422);
      if (lookahead == '&') ADVANCE(3425);
      if (lookahead == '(') ADVANCE(2236);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == ',') ADVANCE(2228);
      if (lookahead == '-') ADVANCE(3412);
      if (lookahead == '.') ADVANCE(3386);
      if (lookahead == '/') ADVANCE(3421);
      if (lookahead == ':') ADVANCE(889);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '<') ADVANCE(3429);
      if (lookahead == '=') ADVANCE(2401);
      if (lookahead == '>') ADVANCE(3433);
      if (lookahead == '[') ADVANCE(3403);
      if (lookahead == '\\') ADVANCE(20);
      if (lookahead == '^') ADVANCE(3419);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == '|') ADVANCE(3427);
      if (lookahead == '~') ADVANCE(3415);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2991);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(2785);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(2710);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2808);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3357);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3211);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3050);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2685);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3142);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3143);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(2893);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2673);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2788);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2826);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3197);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3179);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(2690);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2939);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(600)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('F' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 601:
      if (lookahead == '!') ADVANCE(890);
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '#') ADVANCE(3428);
      if (lookahead == '%') ADVANCE(3422);
      if (lookahead == '&') ADVANCE(3425);
      if (lookahead == '(') ADVANCE(2236);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == ',') ADVANCE(2228);
      if (lookahead == '-') ADVANCE(3412);
      if (lookahead == '.') ADVANCE(3386);
      if (lookahead == '/') ADVANCE(3421);
      if (lookahead == ':') ADVANCE(889);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '<') ADVANCE(3429);
      if (lookahead == '=') ADVANCE(2401);
      if (lookahead == '>') ADVANCE(3433);
      if (lookahead == '[') ADVANCE(3403);
      if (lookahead == '\\') ADVANCE(24);
      if (lookahead == '^') ADVANCE(3419);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == '|') ADVANCE(3427);
      if (lookahead == '~') ADVANCE(3415);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2989);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(2785);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(2710);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2786);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3357);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3211);
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(2668);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3050);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2685);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3142);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3145);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(2891);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2673);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2788);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2826);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3197);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3179);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(2690);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2939);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(601)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('F' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 602:
      if (lookahead == '!') ADVANCE(890);
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '#') ADVANCE(3428);
      if (lookahead == '%') ADVANCE(3422);
      if (lookahead == '&') ADVANCE(3425);
      if (lookahead == '(') ADVANCE(2236);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == ',') ADVANCE(2228);
      if (lookahead == '-') ADVANCE(3412);
      if (lookahead == '.') ADVANCE(3386);
      if (lookahead == '/') ADVANCE(3421);
      if (lookahead == ':') ADVANCE(889);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '<') ADVANCE(3429);
      if (lookahead == '=') ADVANCE(2401);
      if (lookahead == '>') ADVANCE(3433);
      if (lookahead == '[') ADVANCE(3403);
      if (lookahead == '\\') ADVANCE(32);
      if (lookahead == '^') ADVANCE(3419);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == '|') ADVANCE(3427);
      if (lookahead == '~') ADVANCE(3415);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2991);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(2785);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(2710);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2808);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3357);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(2863);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3211);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3050);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2685);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3142);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3143);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(2893);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2674);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2788);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2826);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3197);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3179);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3154);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2976);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(602)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('H' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 603:
      if (lookahead == '!') ADVANCE(890);
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '#') ADVANCE(3428);
      if (lookahead == '%') ADVANCE(3422);
      if (lookahead == '&') ADVANCE(3425);
      if (lookahead == '(') ADVANCE(2236);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == ',') ADVANCE(2228);
      if (lookahead == '-') ADVANCE(3412);
      if (lookahead == '.') ADVANCE(3386);
      if (lookahead == '/') ADVANCE(3421);
      if (lookahead == ':') ADVANCE(889);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '<') ADVANCE(3429);
      if (lookahead == '=') ADVANCE(2401);
      if (lookahead == '>') ADVANCE(3433);
      if (lookahead == '[') ADVANCE(3403);
      if (lookahead == '\\') ADVANCE(312);
      if (lookahead == '^') ADVANCE(3419);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == '|') ADVANCE(3427);
      if (lookahead == '~') ADVANCE(3415);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2991);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(2785);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(2710);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2808);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3357);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3211);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3050);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2685);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3142);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3143);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(2893);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2674);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2788);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2826);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3197);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3179);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3154);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2976);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(603)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('F' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 604:
      if (lookahead == '!') ADVANCE(890);
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '#') ADVANCE(3428);
      if (lookahead == '%') ADVANCE(3422);
      if (lookahead == '&') ADVANCE(3425);
      if (lookahead == '(') ADVANCE(2236);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == ',') ADVANCE(2228);
      if (lookahead == '-') ADVANCE(3412);
      if (lookahead == '.') ADVANCE(3386);
      if (lookahead == '/') ADVANCE(3421);
      if (lookahead == ':') ADVANCE(889);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '<') ADVANCE(3429);
      if (lookahead == '=') ADVANCE(2401);
      if (lookahead == '>') ADVANCE(3433);
      if (lookahead == '[') ADVANCE(3403);
      if (lookahead == '\\') ADVANCE(316);
      if (lookahead == '^') ADVANCE(3419);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == '|') ADVANCE(3427);
      if (lookahead == '~') ADVANCE(3415);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2989);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(2785);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(2710);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2786);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3357);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3211);
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(2668);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3050);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2685);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3142);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3145);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(2891);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2674);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2788);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2826);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3197);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3179);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3154);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2976);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(604)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('F' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 605:
      if (lookahead == '!') ADVANCE(890);
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '#') ADVANCE(3428);
      if (lookahead == '%') ADVANCE(3422);
      if (lookahead == '&') ADVANCE(3425);
      if (lookahead == '(') ADVANCE(2236);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == ',') ADVANCE(2228);
      if (lookahead == '-') ADVANCE(3412);
      if (lookahead == '.') ADVANCE(3386);
      if (lookahead == '/') ADVANCE(3421);
      if (lookahead == ':') ADVANCE(889);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '<') ADVANCE(3429);
      if (lookahead == '=') ADVANCE(2401);
      if (lookahead == '>') ADVANCE(3433);
      if (lookahead == '[') ADVANCE(3403);
      if (lookahead == '\\') ADVANCE(322);
      if (lookahead == '^') ADVANCE(3419);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == '|') ADVANCE(3427);
      if (lookahead == '~') ADVANCE(3415);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2989);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(2785);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(2710);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2786);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3357);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3202);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3211);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3050);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2686);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3142);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3145);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3195);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2674);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2788);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2826);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3197);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3179);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3154);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2925);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(605)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('H' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 606:
      if (lookahead == '!') ADVANCE(890);
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '#') ADVANCE(3428);
      if (lookahead == '%') ADVANCE(3422);
      if (lookahead == '&') ADVANCE(3425);
      if (lookahead == '(') ADVANCE(2236);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == ',') ADVANCE(2228);
      if (lookahead == '-') ADVANCE(3412);
      if (lookahead == '.') ADVANCE(3386);
      if (lookahead == '/') ADVANCE(3421);
      if (lookahead == ':') ADVANCE(889);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '<') ADVANCE(3429);
      if (lookahead == '=') ADVANCE(2401);
      if (lookahead == '>') ADVANCE(3433);
      if (lookahead == '[') ADVANCE(3403);
      if (lookahead == '\\') ADVANCE(378);
      if (lookahead == '^') ADVANCE(3419);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == '|') ADVANCE(3427);
      if (lookahead == '~') ADVANCE(3415);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2989);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(2785);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(2710);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2786);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3357);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3211);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3050);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2686);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3142);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3145);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3195);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2674);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2788);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2826);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3197);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3179);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3154);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2925);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(606)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('F' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 607:
      if (lookahead == '!') ADVANCE(890);
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '#') ADVANCE(3428);
      if (lookahead == '%') ADVANCE(3422);
      if (lookahead == '&') ADVANCE(3425);
      if (lookahead == '(') ADVANCE(2236);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == ',') ADVANCE(2228);
      if (lookahead == '-') ADVANCE(3412);
      if (lookahead == '.') ADVANCE(3386);
      if (lookahead == '/') ADVANCE(3421);
      if (lookahead == ':') ADVANCE(889);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '<') ADVANCE(3429);
      if (lookahead == '=') ADVANCE(2401);
      if (lookahead == '>') ADVANCE(3433);
      if (lookahead == '[') ADVANCE(3403);
      if (lookahead == '\\') ADVANCE(410);
      if (lookahead == '^') ADVANCE(3419);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == '|') ADVANCE(3427);
      if (lookahead == '~') ADVANCE(3415);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2989);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(2785);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(2710);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2786);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3357);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3211);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3050);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2686);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3142);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3145);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3195);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2674);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2788);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2826);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3197);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3179);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3154);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2976);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(607)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('F' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 608:
      if (lookahead == '!') ADVANCE(890);
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '#') ADVANCE(3428);
      if (lookahead == '%') ADVANCE(3422);
      if (lookahead == '&') ADVANCE(3425);
      if (lookahead == '(') ADVANCE(2236);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == ',') ADVANCE(2228);
      if (lookahead == '-') ADVANCE(3412);
      if (lookahead == '.') ADVANCE(3386);
      if (lookahead == '/') ADVANCE(3421);
      if (lookahead == ':') ADVANCE(889);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '<') ADVANCE(3429);
      if (lookahead == '=') ADVANCE(2401);
      if (lookahead == '>') ADVANCE(3433);
      if (lookahead == '[') ADVANCE(3403);
      if (lookahead == '\\') ADVANCE(54);
      if (lookahead == '^') ADVANCE(3419);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == '|') ADVANCE(3427);
      if (lookahead == '~') ADVANCE(3415);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2989);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(2785);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3159);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2860);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3201);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3186);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3076);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(3141);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2831);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3165);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(2891);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(3220);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2937);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2811);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3213);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3179);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(2691);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2919);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(608)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('E' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 609:
      if (lookahead == '!') ADVANCE(890);
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '#') ADVANCE(3428);
      if (lookahead == '%') ADVANCE(3422);
      if (lookahead == '&') ADVANCE(3425);
      if (lookahead == '(') ADVANCE(2236);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == ',') ADVANCE(2228);
      if (lookahead == '-') ADVANCE(3412);
      if (lookahead == '.') ADVANCE(3386);
      if (lookahead == '/') ADVANCE(3421);
      if (lookahead == ':') ADVANCE(889);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '<') ADVANCE(3429);
      if (lookahead == '=') ADVANCE(2401);
      if (lookahead == '>') ADVANCE(3433);
      if (lookahead == '[') ADVANCE(3403);
      if (lookahead == '\\') ADVANCE(334);
      if (lookahead == '^') ADVANCE(3419);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == '|') ADVANCE(3427);
      if (lookahead == '~') ADVANCE(3415);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2989);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(2785);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3159);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2860);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3320);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3186);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3078);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(3141);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2831);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3165);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(2891);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(3220);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2937);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2811);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3213);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3179);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(2691);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2919);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(609)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('E' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 610:
      if (lookahead == '!') ADVANCE(890);
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '#') ADVANCE(3428);
      if (lookahead == '%') ADVANCE(3422);
      if (lookahead == '&') ADVANCE(3425);
      if (lookahead == '(') ADVANCE(2236);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == ',') ADVANCE(2228);
      if (lookahead == '-') ADVANCE(3412);
      if (lookahead == '.') ADVANCE(3386);
      if (lookahead == '/') ADVANCE(3421);
      if (lookahead == ':') ADVANCE(889);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '<') ADVANCE(3429);
      if (lookahead == '=') ADVANCE(2401);
      if (lookahead == '>') ADVANCE(3433);
      if (lookahead == '[') ADVANCE(3403);
      if (lookahead == '\\') ADVANCE(60);
      if (lookahead == '^') ADVANCE(3419);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == '|') ADVANCE(3427);
      if (lookahead == '~') ADVANCE(3415);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2989);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3196);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2812);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3115);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3201);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3186);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3076);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(3141);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2831);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3165);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(2891);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(3220);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2867);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2811);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3179);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(2691);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2919);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(610)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('B' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 611:
      if (lookahead == '!') ADVANCE(890);
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '#') ADVANCE(3428);
      if (lookahead == '%') ADVANCE(3422);
      if (lookahead == '&') ADVANCE(3425);
      if (lookahead == '(') ADVANCE(2236);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == ',') ADVANCE(2228);
      if (lookahead == '-') ADVANCE(3412);
      if (lookahead == '.') ADVANCE(3386);
      if (lookahead == '/') ADVANCE(3421);
      if (lookahead == ':') ADVANCE(889);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '<') ADVANCE(3429);
      if (lookahead == '=') ADVANCE(2401);
      if (lookahead == '>') ADVANCE(3433);
      if (lookahead == '[') ADVANCE(3403);
      if (lookahead == '\\') ADVANCE(70);
      if (lookahead == '^') ADVANCE(3419);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == '|') ADVANCE(3427);
      if (lookahead == '~') ADVANCE(3415);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2989);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(2785);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3159);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2860);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3320);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3186);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3078);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(3141);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2831);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3165);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(2891);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2937);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2811);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3213);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3179);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2925);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(611)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('E' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 612:
      if (lookahead == '!') ADVANCE(890);
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '#') ADVANCE(3428);
      if (lookahead == '%') ADVANCE(3422);
      if (lookahead == '&') ADVANCE(3425);
      if (lookahead == '(') ADVANCE(2236);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == ',') ADVANCE(2228);
      if (lookahead == '-') ADVANCE(3412);
      if (lookahead == '.') ADVANCE(3386);
      if (lookahead == '/') ADVANCE(3421);
      if (lookahead == ':') ADVANCE(889);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '<') ADVANCE(3429);
      if (lookahead == '=') ADVANCE(2401);
      if (lookahead == '>') ADVANCE(3433);
      if (lookahead == '[') ADVANCE(3403);
      if (lookahead == '\\') ADVANCE(338);
      if (lookahead == '^') ADVANCE(3419);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == '|') ADVANCE(3427);
      if (lookahead == '~') ADVANCE(3415);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2989);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3196);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2812);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3115);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3320);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3186);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3078);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(3141);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2831);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3165);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(2891);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(3220);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2867);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2811);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3179);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(2691);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2919);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(612)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('B' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 613:
      if (lookahead == '!') ADVANCE(890);
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '#') ADVANCE(3428);
      if (lookahead == '%') ADVANCE(3422);
      if (lookahead == '&') ADVANCE(3425);
      if (lookahead == '(') ADVANCE(2236);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == ',') ADVANCE(2228);
      if (lookahead == '-') ADVANCE(3412);
      if (lookahead == '.') ADVANCE(3386);
      if (lookahead == '/') ADVANCE(3421);
      if (lookahead == ':') ADVANCE(889);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '<') ADVANCE(3429);
      if (lookahead == '=') ADVANCE(2401);
      if (lookahead == '>') ADVANCE(3433);
      if (lookahead == '[') ADVANCE(3403);
      if (lookahead == '\\') ADVANCE(74);
      if (lookahead == '^') ADVANCE(3419);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == '|') ADVANCE(3427);
      if (lookahead == '~') ADVANCE(3415);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2989);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3196);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2812);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3115);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3201);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3186);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3076);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(3141);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2831);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3165);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(2891);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2867);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2811);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3179);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2925);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(613)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('B' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 614:
      if (lookahead == '!') ADVANCE(890);
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '#') ADVANCE(3428);
      if (lookahead == '%') ADVANCE(3422);
      if (lookahead == '&') ADVANCE(3425);
      if (lookahead == '(') ADVANCE(2236);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == ',') ADVANCE(2228);
      if (lookahead == '-') ADVANCE(3412);
      if (lookahead == '.') ADVANCE(3386);
      if (lookahead == '/') ADVANCE(3421);
      if (lookahead == ':') ADVANCE(889);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '<') ADVANCE(3429);
      if (lookahead == '=') ADVANCE(2401);
      if (lookahead == '>') ADVANCE(3433);
      if (lookahead == '[') ADVANCE(3403);
      if (lookahead == '\\') ADVANCE(342);
      if (lookahead == '^') ADVANCE(3419);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == '|') ADVANCE(3427);
      if (lookahead == '~') ADVANCE(3415);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2989);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3196);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2812);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3115);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3320);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3186);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3078);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(3141);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2831);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3165);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(2891);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2867);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2811);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3179);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2925);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(614)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('B' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 615:
      if (lookahead == '!') ADVANCE(890);
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '#') ADVANCE(3428);
      if (lookahead == '%') ADVANCE(3422);
      if (lookahead == '&') ADVANCE(3425);
      if (lookahead == '(') ADVANCE(2236);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == ',') ADVANCE(2228);
      if (lookahead == '-') ADVANCE(3412);
      if (lookahead == '.') ADVANCE(3386);
      if (lookahead == '/') ADVANCE(3421);
      if (lookahead == ':') ADVANCE(889);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '<') ADVANCE(3429);
      if (lookahead == '=') ADVANCE(2401);
      if (lookahead == '>') ADVANCE(3433);
      if (lookahead == '[') ADVANCE(3403);
      if (lookahead == '\\') ADVANCE(118);
      if (lookahead == '^') ADVANCE(3419);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == '|') ADVANCE(3427);
      if (lookahead == '~') ADVANCE(3415);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2989);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(2785);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3159);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2860);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3211);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3079);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3165);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3195);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3172);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2811);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3213);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3179);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2923);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(615)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('E' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 616:
      if (lookahead == '!') ADVANCE(890);
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '#') ADVANCE(3428);
      if (lookahead == '%') ADVANCE(3422);
      if (lookahead == '&') ADVANCE(3425);
      if (lookahead == '(') ADVANCE(2236);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == ',') ADVANCE(2228);
      if (lookahead == '-') ADVANCE(3412);
      if (lookahead == '.') ADVANCE(3386);
      if (lookahead == '/') ADVANCE(3421);
      if (lookahead == ':') ADVANCE(889);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '<') ADVANCE(3429);
      if (lookahead == '=') ADVANCE(2401);
      if (lookahead == '>') ADVANCE(3433);
      if (lookahead == '[') ADVANCE(3403);
      if (lookahead == '\\') ADVANCE(140);
      if (lookahead == '^') ADVANCE(3419);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == '|') ADVANCE(3427);
      if (lookahead == '~') ADVANCE(3415);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2989);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3196);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2812);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3115);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3211);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3079);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3165);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3195);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2868);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2811);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3179);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2923);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(616)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('B' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 617:
      if (lookahead == '!') ADVANCE(890);
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '#') ADVANCE(3428);
      if (lookahead == '%') ADVANCE(3422);
      if (lookahead == '&') ADVANCE(3425);
      if (lookahead == '(') ADVANCE(2236);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == ',') ADVANCE(2228);
      if (lookahead == '-') ADVANCE(3412);
      if (lookahead == '.') ADVANCE(3385);
      if (lookahead == '/') ADVANCE(3421);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '<') ADVANCE(3429);
      if (lookahead == '=') ADVANCE(2401);
      if (lookahead == '>') ADVANCE(3433);
      if (lookahead == '[') ADVANCE(3403);
      if (lookahead == '\\') ADVANCE(26);
      if (lookahead == '^') ADVANCE(3419);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == '|') ADVANCE(3427);
      if (lookahead == '~') ADVANCE(3415);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2991);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(2785);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(2710);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2808);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3357);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(2863);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3211);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3050);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2685);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3142);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3143);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(2893);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2673);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2788);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2826);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3197);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3179);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(2690);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2939);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(617)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('H' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 618:
      if (lookahead == '!') ADVANCE(890);
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '#') ADVANCE(3428);
      if (lookahead == '%') ADVANCE(3422);
      if (lookahead == '&') ADVANCE(3425);
      if (lookahead == '(') ADVANCE(2236);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == ',') ADVANCE(2228);
      if (lookahead == '-') ADVANCE(3412);
      if (lookahead == '.') ADVANCE(3385);
      if (lookahead == '/') ADVANCE(3421);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '<') ADVANCE(3429);
      if (lookahead == '=') ADVANCE(2401);
      if (lookahead == '>') ADVANCE(3433);
      if (lookahead == '[') ADVANCE(3403);
      if (lookahead == '\\') ADVANCE(318);
      if (lookahead == '^') ADVANCE(3419);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == '|') ADVANCE(3427);
      if (lookahead == '~') ADVANCE(3415);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2989);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(2785);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(2710);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2786);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3357);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3202);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3211);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3050);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2686);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3142);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3145);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3195);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2673);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2788);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2826);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3197);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3179);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(2690);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2919);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(618)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('H' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 619:
      if (lookahead == '!') ADVANCE(890);
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '#') ADVANCE(3428);
      if (lookahead == '%') ADVANCE(3422);
      if (lookahead == '&') ADVANCE(3425);
      if (lookahead == '(') ADVANCE(2236);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == ',') ADVANCE(2228);
      if (lookahead == '-') ADVANCE(3412);
      if (lookahead == '.') ADVANCE(3385);
      if (lookahead == '/') ADVANCE(3421);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '<') ADVANCE(3429);
      if (lookahead == '=') ADVANCE(2401);
      if (lookahead == '>') ADVANCE(3433);
      if (lookahead == '[') ADVANCE(3403);
      if (lookahead == '\\') ADVANCE(46);
      if (lookahead == '^') ADVANCE(3419);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == '|') ADVANCE(3427);
      if (lookahead == '~') ADVANCE(3415);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2989);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(2785);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(2710);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2786);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3357);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3211);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3050);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2686);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3142);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3145);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3195);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2673);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2788);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2826);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3197);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3179);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(2690);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2919);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(619)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('F' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 620:
      if (lookahead == '!') ADVANCE(890);
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '#') ADVANCE(3428);
      if (lookahead == '%') ADVANCE(3422);
      if (lookahead == '&') ADVANCE(3425);
      if (lookahead == '(') ADVANCE(2236);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == ',') ADVANCE(2228);
      if (lookahead == '-') ADVANCE(3412);
      if (lookahead == '.') ADVANCE(3385);
      if (lookahead == '/') ADVANCE(3421);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '<') ADVANCE(3429);
      if (lookahead == '=') ADVANCE(2401);
      if (lookahead == '>') ADVANCE(3433);
      if (lookahead == '[') ADVANCE(3403);
      if (lookahead == '\\') ADVANCE(330);
      if (lookahead == '^') ADVANCE(3419);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == '|') ADVANCE(3427);
      if (lookahead == '~') ADVANCE(3415);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2989);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(2785);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(2710);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2786);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3357);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3211);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3050);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2686);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3142);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3145);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3195);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2673);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2788);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2826);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3197);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3179);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(2690);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2939);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(620)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('F' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 621:
      if (lookahead == '!') ADVANCE(890);
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '#') ADVANCE(3428);
      if (lookahead == '%') ADVANCE(3422);
      if (lookahead == '&') ADVANCE(3425);
      if (lookahead == '(') ADVANCE(2236);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == ',') ADVANCE(2228);
      if (lookahead == '-') ADVANCE(3412);
      if (lookahead == '.') ADVANCE(3385);
      if (lookahead == '/') ADVANCE(3421);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '<') ADVANCE(3429);
      if (lookahead == '=') ADVANCE(2401);
      if (lookahead == '>') ADVANCE(3433);
      if (lookahead == '[') ADVANCE(3403);
      if (lookahead == '\\') ADVANCE(108);
      if (lookahead == '^') ADVANCE(3419);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == '|') ADVANCE(3427);
      if (lookahead == '~') ADVANCE(3415);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2989);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(2785);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3159);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2860);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3211);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3079);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3165);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3195);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(3220);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3172);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2811);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3213);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3179);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(2691);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2922);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(621)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('E' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 622:
      if (lookahead == '!') ADVANCE(890);
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '#') ADVANCE(3428);
      if (lookahead == '%') ADVANCE(3422);
      if (lookahead == '&') ADVANCE(3425);
      if (lookahead == '(') ADVANCE(2236);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == ',') ADVANCE(2228);
      if (lookahead == '-') ADVANCE(3412);
      if (lookahead == '.') ADVANCE(3385);
      if (lookahead == '/') ADVANCE(3421);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '<') ADVANCE(3429);
      if (lookahead == '=') ADVANCE(2401);
      if (lookahead == '>') ADVANCE(3433);
      if (lookahead == '[') ADVANCE(3403);
      if (lookahead == '\\') ADVANCE(128);
      if (lookahead == '^') ADVANCE(3419);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == '|') ADVANCE(3427);
      if (lookahead == '~') ADVANCE(3415);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2989);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3196);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2812);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3115);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3211);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3079);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3165);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3195);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(3220);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2868);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2811);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3179);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(2691);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2922);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(622)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('B' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 623:
      if (lookahead == '!') ADVANCE(890);
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '#') ADVANCE(3428);
      if (lookahead == '%') ADVANCE(3422);
      if (lookahead == '&') ADVANCE(3425);
      if (lookahead == '(') ADVANCE(2236);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == '-') ADVANCE(3412);
      if (lookahead == '.') ADVANCE(3386);
      if (lookahead == '/') ADVANCE(3421);
      if (lookahead == ':') ADVANCE(889);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '<') ADVANCE(3429);
      if (lookahead == '=') ADVANCE(2401);
      if (lookahead == '>') ADVANCE(3433);
      if (lookahead == 'C') ADVANCE(2634);
      if (lookahead == '[') ADVANCE(3403);
      if (lookahead == '\\') ADVANCE(18);
      if (lookahead == '^') ADVANCE(3419);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == 'c') ADVANCE(2709);
      if (lookahead == '|') ADVANCE(3427);
      if (lookahead == '~') ADVANCE(3415);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2990);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(2785);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2805);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3357);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3211);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3050);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2686);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3142);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3144);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3195);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2672);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2806);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2826);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3197);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3118);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3154);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2976);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(623)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('F' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 624:
      if (lookahead == '!') ADVANCE(890);
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '#') ADVANCE(3428);
      if (lookahead == '%') ADVANCE(3422);
      if (lookahead == '&') ADVANCE(3425);
      if (lookahead == '(') ADVANCE(2236);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == '-') ADVANCE(3412);
      if (lookahead == '.') ADVANCE(3386);
      if (lookahead == '/') ADVANCE(3421);
      if (lookahead == ':') ADVANCE(889);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '<') ADVANCE(3429);
      if (lookahead == '=') ADVANCE(2401);
      if (lookahead == '>') ADVANCE(3433);
      if (lookahead == '[') ADVANCE(3403);
      if (lookahead == '\\') ADVANCE(30);
      if (lookahead == '^') ADVANCE(3419);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == '|') ADVANCE(3427);
      if (lookahead == '~') ADVANCE(3415);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2989);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(2785);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(2710);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2786);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3357);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3186);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3050);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2685);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3142);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3145);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(2891);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2673);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2788);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2826);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3197);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3179);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(2690);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2939);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(624)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('F' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 625:
      if (lookahead == '!') ADVANCE(890);
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '#') ADVANCE(3428);
      if (lookahead == '%') ADVANCE(3422);
      if (lookahead == '&') ADVANCE(3425);
      if (lookahead == '(') ADVANCE(2236);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == '-') ADVANCE(3412);
      if (lookahead == '.') ADVANCE(3386);
      if (lookahead == '/') ADVANCE(3421);
      if (lookahead == ':') ADVANCE(889);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '<') ADVANCE(3429);
      if (lookahead == '=') ADVANCE(2401);
      if (lookahead == '>') ADVANCE(3433);
      if (lookahead == '[') ADVANCE(3403);
      if (lookahead == '\\') ADVANCE(320);
      if (lookahead == '^') ADVANCE(3419);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == '|') ADVANCE(3427);
      if (lookahead == '~') ADVANCE(3415);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2989);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(2785);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(2710);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2786);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3357);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3211);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3050);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2685);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3142);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3145);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(2891);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2673);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2788);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2826);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3197);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3179);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(2690);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2939);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(625)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('F' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 626:
      if (lookahead == '!') ADVANCE(890);
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '#') ADVANCE(3428);
      if (lookahead == '%') ADVANCE(3422);
      if (lookahead == '&') ADVANCE(3425);
      if (lookahead == '(') ADVANCE(2236);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == '-') ADVANCE(3412);
      if (lookahead == '.') ADVANCE(3386);
      if (lookahead == '/') ADVANCE(3421);
      if (lookahead == ':') ADVANCE(889);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '<') ADVANCE(3429);
      if (lookahead == '=') ADVANCE(2401);
      if (lookahead == '>') ADVANCE(3433);
      if (lookahead == '[') ADVANCE(3403);
      if (lookahead == '\\') ADVANCE(382);
      if (lookahead == '^') ADVANCE(3419);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == '|') ADVANCE(3427);
      if (lookahead == '~') ADVANCE(3415);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2989);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(2785);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(2710);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2786);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3357);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3186);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3050);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2685);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3142);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3145);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(2891);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2674);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2788);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2826);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3197);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3179);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3154);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2976);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(626)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('F' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 627:
      if (lookahead == '!') ADVANCE(890);
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '#') ADVANCE(3428);
      if (lookahead == '%') ADVANCE(3422);
      if (lookahead == '&') ADVANCE(3425);
      if (lookahead == '(') ADVANCE(2236);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == '-') ADVANCE(3412);
      if (lookahead == '.') ADVANCE(3386);
      if (lookahead == '/') ADVANCE(3421);
      if (lookahead == ':') ADVANCE(889);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '<') ADVANCE(3429);
      if (lookahead == '=') ADVANCE(2401);
      if (lookahead == '>') ADVANCE(3433);
      if (lookahead == '[') ADVANCE(3403);
      if (lookahead == '\\') ADVANCE(414);
      if (lookahead == '^') ADVANCE(3419);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == '|') ADVANCE(3427);
      if (lookahead == '~') ADVANCE(3415);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2989);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(2785);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(2710);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2786);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3357);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3211);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3050);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2685);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3142);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3145);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(2891);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2674);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2788);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2826);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3197);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3179);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3154);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2976);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(627)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('F' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 628:
      if (lookahead == '!') ADVANCE(890);
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '#') ADVANCE(3428);
      if (lookahead == '%') ADVANCE(3422);
      if (lookahead == '&') ADVANCE(3425);
      if (lookahead == '(') ADVANCE(2236);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == '-') ADVANCE(3412);
      if (lookahead == '.') ADVANCE(3386);
      if (lookahead == '/') ADVANCE(3421);
      if (lookahead == ':') ADVANCE(889);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '<') ADVANCE(3429);
      if (lookahead == '=') ADVANCE(2401);
      if (lookahead == '>') ADVANCE(3433);
      if (lookahead == '[') ADVANCE(3403);
      if (lookahead == '\\') ADVANCE(436);
      if (lookahead == '^') ADVANCE(3419);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == '|') ADVANCE(3427);
      if (lookahead == '~') ADVANCE(3415);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2989);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(2785);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(2710);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2809);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3357);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3211);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3051);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2686);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3142);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3145);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3195);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2674);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2788);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2826);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3197);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3179);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3154);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2976);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(628)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('F' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 629:
      if (lookahead == '!') ADVANCE(890);
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '#') ADVANCE(3428);
      if (lookahead == '%') ADVANCE(3422);
      if (lookahead == '&') ADVANCE(3425);
      if (lookahead == '(') ADVANCE(2236);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == '-') ADVANCE(3412);
      if (lookahead == '.') ADVANCE(3386);
      if (lookahead == '/') ADVANCE(3421);
      if (lookahead == ':') ADVANCE(889);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '<') ADVANCE(3429);
      if (lookahead == '=') ADVANCE(2401);
      if (lookahead == '>') ADVANCE(3433);
      if (lookahead == '[') ADVANCE(3403);
      if (lookahead == '\\') ADVANCE(442);
      if (lookahead == '^') ADVANCE(3419);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == '|') ADVANCE(3427);
      if (lookahead == '~') ADVANCE(3415);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2989);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(2785);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(2709);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2786);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3357);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3211);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3050);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2686);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3142);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3144);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3195);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2674);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2788);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2826);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3197);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3179);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3154);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2976);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(629)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('F' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 630:
      if (lookahead == '!') ADVANCE(890);
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '#') ADVANCE(3428);
      if (lookahead == '%') ADVANCE(3422);
      if (lookahead == '&') ADVANCE(3425);
      if (lookahead == '(') ADVANCE(2236);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == '-') ADVANCE(3412);
      if (lookahead == '.') ADVANCE(3386);
      if (lookahead == '/') ADVANCE(3421);
      if (lookahead == ':') ADVANCE(889);
      if (lookahead == '<') ADVANCE(3429);
      if (lookahead == '=') ADVANCE(2401);
      if (lookahead == '>') ADVANCE(3433);
      if (lookahead == '[') ADVANCE(3403);
      if (lookahead == '\\') SKIP(242)
      if (lookahead == '^') ADVANCE(3419);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == '|') ADVANCE(3427);
      if (lookahead == '~') ADVANCE(3415);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3112);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3089);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3165);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3082);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(630)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('B' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 631:
      if (lookahead == '!') ADVANCE(890);
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '#') ADVANCE(3428);
      if (lookahead == '%') ADVANCE(3422);
      if (lookahead == '&') ADVANCE(3425);
      if (lookahead == '(') ADVANCE(2236);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == '-') ADVANCE(3412);
      if (lookahead == '.') ADVANCE(3386);
      if (lookahead == '/') ADVANCE(3421);
      if (lookahead == ':') ADVANCE(889);
      if (lookahead == '<') ADVANCE(3429);
      if (lookahead == '=') ADVANCE(2401);
      if (lookahead == '>') ADVANCE(3433);
      if (lookahead == '[') ADVANCE(3403);
      if (lookahead == '\\') ADVANCE(146);
      if (lookahead == '^') ADVANCE(3419);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == '|') ADVANCE(3427);
      if (lookahead == '~') ADVANCE(3415);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2992);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(2785);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3196);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2812);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3356);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3173);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3211);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3079);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3165);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3195);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(3223);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2868);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2811);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3179);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2971);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(631)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('H' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 632:
      if (lookahead == '!') ADVANCE(890);
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '#') ADVANCE(3428);
      if (lookahead == '%') ADVANCE(3422);
      if (lookahead == '&') ADVANCE(3425);
      if (lookahead == '(') ADVANCE(2236);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == '-') ADVANCE(3412);
      if (lookahead == '.') ADVANCE(3385);
      if (lookahead == '/') ADVANCE(3421);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '<') ADVANCE(3429);
      if (lookahead == '=') ADVANCE(2401);
      if (lookahead == '>') ADVANCE(3433);
      if (lookahead == 'C') ADVANCE(2634);
      if (lookahead == '[') ADVANCE(3403);
      if (lookahead == '\\') ADVANCE(14);
      if (lookahead == '^') ADVANCE(3419);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == 'c') ADVANCE(2709);
      if (lookahead == '|') ADVANCE(3427);
      if (lookahead == '~') ADVANCE(3415);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2990);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(2785);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2805);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3357);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3211);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3050);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2686);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3142);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3144);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3195);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2671);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2806);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2826);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3197);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3118);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(2690);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2939);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(632)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('F' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 633:
      if (lookahead == '!') ADVANCE(890);
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '#') ADVANCE(3428);
      if (lookahead == '%') ADVANCE(3422);
      if (lookahead == '&') ADVANCE(3425);
      if (lookahead == '(') ADVANCE(2236);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == '-') ADVANCE(3412);
      if (lookahead == '.') ADVANCE(3385);
      if (lookahead == '/') ADVANCE(3421);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '<') ADVANCE(3429);
      if (lookahead == '=') ADVANCE(2401);
      if (lookahead == '>') ADVANCE(3433);
      if (lookahead == '[') ADVANCE(3403);
      if (lookahead == '\\') ADVANCE(44);
      if (lookahead == '^') ADVANCE(3419);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == '|') ADVANCE(3427);
      if (lookahead == '~') ADVANCE(3415);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2989);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(2785);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(2709);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2786);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3357);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3211);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3050);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2686);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3142);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3144);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3195);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2673);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2788);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2826);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3197);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3179);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(2690);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2939);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(633)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('F' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 634:
      if (lookahead == '!') ADVANCE(890);
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '#') ADVANCE(3428);
      if (lookahead == '%') ADVANCE(3422);
      if (lookahead == '&') ADVANCE(3425);
      if (lookahead == '(') ADVANCE(2236);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == '-') ADVANCE(3412);
      if (lookahead == '.') ADVANCE(3385);
      if (lookahead == '/') ADVANCE(3421);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '<') ADVANCE(3429);
      if (lookahead == '=') ADVANCE(2401);
      if (lookahead == '>') ADVANCE(3433);
      if (lookahead == '[') ADVANCE(3403);
      if (lookahead == '\\') ADVANCE(328);
      if (lookahead == '^') ADVANCE(3419);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == '|') ADVANCE(3427);
      if (lookahead == '~') ADVANCE(3415);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2989);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(2785);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(2710);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2809);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3357);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3211);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3051);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2686);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3142);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3145);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3195);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2673);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2788);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2826);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3197);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3179);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(2690);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2939);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(634)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('F' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 635:
      if (lookahead == '!') ADVANCE(890);
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '#') ADVANCE(3428);
      if (lookahead == '%') ADVANCE(3422);
      if (lookahead == '&') ADVANCE(3425);
      if (lookahead == '(') ADVANCE(2236);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == '-') ADVANCE(3412);
      if (lookahead == '.') ADVANCE(3385);
      if (lookahead == '/') ADVANCE(3421);
      if (lookahead == '<') ADVANCE(3429);
      if (lookahead == '=') ADVANCE(2401);
      if (lookahead == '>') ADVANCE(3433);
      if (lookahead == '[') ADVANCE(3403);
      if (lookahead == '\\') SKIP(226)
      if (lookahead == '^') ADVANCE(3419);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == '|') ADVANCE(3427);
      if (lookahead == '~') ADVANCE(3415);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3112);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3089);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3165);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3082);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(3220);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(2691);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2970);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(635)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('B' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 636:
      if (lookahead == '!') ADVANCE(890);
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '#') ADVANCE(3428);
      if (lookahead == '%') ADVANCE(3422);
      if (lookahead == '&') ADVANCE(3425);
      if (lookahead == '(') ADVANCE(2236);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == '-') ADVANCE(3412);
      if (lookahead == '.') ADVANCE(3385);
      if (lookahead == '/') ADVANCE(3421);
      if (lookahead == '<') ADVANCE(3429);
      if (lookahead == '=') ADVANCE(2401);
      if (lookahead == '>') ADVANCE(3433);
      if (lookahead == '[') ADVANCE(3403);
      if (lookahead == '\\') ADVANCE(142);
      if (lookahead == '^') ADVANCE(3419);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == '|') ADVANCE(3427);
      if (lookahead == '~') ADVANCE(3415);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2992);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(2785);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3196);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2812);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3356);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3173);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3211);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3079);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3165);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3195);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(3225);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2868);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2811);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3179);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(2691);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2970);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(636)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('H' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 637:
      if (lookahead == '!') ADVANCE(890);
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '#') ADVANCE(3428);
      if (lookahead == '%') ADVANCE(3422);
      if (lookahead == '&') ADVANCE(3425);
      if (lookahead == ')') ADVANCE(2237);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == ',') ADVANCE(2228);
      if (lookahead == '-') ADVANCE(3412);
      if (lookahead == '/') ADVANCE(3421);
      if (lookahead == ':') ADVANCE(889);
      if (lookahead == '<') ADVANCE(3429);
      if (lookahead == '=') ADVANCE(2401);
      if (lookahead == '>') ADVANCE(3433);
      if (lookahead == '\\') SKIP(144)
      if (lookahead == '^') ADVANCE(3419);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == '|') ADVANCE(3427);
      if (lookahead == '~') ADVANCE(3415);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3112);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(2956);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3216);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3085);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(3141);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2831);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3165);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(2890);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2938);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2928);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(637)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('B' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 638:
      if (lookahead == '!') ADVANCE(890);
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '#') ADVANCE(3428);
      if (lookahead == '%') ADVANCE(3422);
      if (lookahead == '&') ADVANCE(3425);
      if (lookahead == ')') ADVANCE(2237);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == ',') ADVANCE(2228);
      if (lookahead == '-') ADVANCE(3412);
      if (lookahead == '/') ADVANCE(3421);
      if (lookahead == ':') ADVANCE(889);
      if (lookahead == '<') ADVANCE(3429);
      if (lookahead == '=') ADVANCE(2401);
      if (lookahead == '>') ADVANCE(3433);
      if (lookahead == '\\') SKIP(354)
      if (lookahead == '^') ADVANCE(3419);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == '|') ADVANCE(3427);
      if (lookahead == '~') ADVANCE(3415);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3112);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(2958);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3216);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3086);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(3141);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2831);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3165);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(2890);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2938);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2928);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(638)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('B' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 639:
      if (lookahead == '!') ADVANCE(890);
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '#') ADVANCE(3428);
      if (lookahead == '%') ADVANCE(3422);
      if (lookahead == '&') ADVANCE(3425);
      if (lookahead == ')') ADVANCE(2237);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == ',') ADVANCE(2228);
      if (lookahead == '-') ADVANCE(3412);
      if (lookahead == '/') ADVANCE(3421);
      if (lookahead == ':') ADVANCE(889);
      if (lookahead == '<') ADVANCE(3429);
      if (lookahead == '=') ADVANCE(2401);
      if (lookahead == '>') ADVANCE(3433);
      if (lookahead == '\\') SKIP(394)
      if (lookahead == '^') ADVANCE(3419);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == '|') ADVANCE(3427);
      if (lookahead == '~') ADVANCE(3415);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3112);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(2956);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3216);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3085);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(3141);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2831);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3165);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(2890);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2938);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2920);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(639)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('B' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 640:
      if (lookahead == '!') ADVANCE(890);
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '#') ADVANCE(3428);
      if (lookahead == '%') ADVANCE(3422);
      if (lookahead == '&') ADVANCE(3425);
      if (lookahead == ')') ADVANCE(2237);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == ',') ADVANCE(2228);
      if (lookahead == '-') ADVANCE(3412);
      if (lookahead == '/') ADVANCE(3421);
      if (lookahead == ':') ADVANCE(889);
      if (lookahead == '<') ADVANCE(3429);
      if (lookahead == '=') ADVANCE(2401);
      if (lookahead == '>') ADVANCE(3433);
      if (lookahead == '\\') SKIP(424)
      if (lookahead == '^') ADVANCE(3419);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == '|') ADVANCE(3427);
      if (lookahead == '~') ADVANCE(3415);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3112);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3201);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3216);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3085);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(3141);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2831);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3165);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(2890);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2938);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2920);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(640)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('B' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 641:
      if (lookahead == '!') ADVANCE(890);
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '#') ADVANCE(3428);
      if (lookahead == '%') ADVANCE(3422);
      if (lookahead == '&') ADVANCE(3425);
      if (lookahead == ')') ADVANCE(2237);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == ',') ADVANCE(2228);
      if (lookahead == '-') ADVANCE(3412);
      if (lookahead == '/') ADVANCE(3421);
      if (lookahead == ':') ADVANCE(889);
      if (lookahead == '<') ADVANCE(3429);
      if (lookahead == '=') ADVANCE(2401);
      if (lookahead == '>') ADVANCE(3433);
      if (lookahead == '\\') SKIP(438)
      if (lookahead == '^') ADVANCE(3419);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == '|') ADVANCE(3427);
      if (lookahead == '~') ADVANCE(3415);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3112);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(2958);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3216);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3086);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(3141);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2831);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3165);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(2890);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2938);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2920);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(641)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('B' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 642:
      if (lookahead == '!') ADVANCE(890);
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '#') ADVANCE(3428);
      if (lookahead == '%') ADVANCE(3422);
      if (lookahead == '&') ADVANCE(3425);
      if (lookahead == ')') ADVANCE(2237);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == ',') ADVANCE(2228);
      if (lookahead == '-') ADVANCE(3412);
      if (lookahead == '/') ADVANCE(3421);
      if (lookahead == ':') ADVANCE(889);
      if (lookahead == '<') ADVANCE(3429);
      if (lookahead == '=') ADVANCE(2401);
      if (lookahead == '>') ADVANCE(3433);
      if (lookahead == '\\') SKIP(444)
      if (lookahead == '^') ADVANCE(3419);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == '|') ADVANCE(3427);
      if (lookahead == '~') ADVANCE(3415);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3112);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3320);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3216);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3086);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(3141);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2831);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3165);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(2890);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2938);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2920);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(642)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('B' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 643:
      if (lookahead == '!') ADVANCE(890);
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '#') ADVANCE(3428);
      if (lookahead == '%') ADVANCE(3422);
      if (lookahead == '&') ADVANCE(3425);
      if (lookahead == ')') ADVANCE(2237);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == ',') ADVANCE(2228);
      if (lookahead == '-') ADVANCE(3412);
      if (lookahead == '/') ADVANCE(3421);
      if (lookahead == ':') ADVANCE(889);
      if (lookahead == '<') ADVANCE(3429);
      if (lookahead == '=') ADVANCE(2401);
      if (lookahead == '>') ADVANCE(3433);
      if (lookahead == '\\') SKIP(222)
      if (lookahead == '^') ADVANCE(3419);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == '|') ADVANCE(3427);
      if (lookahead == '~') ADVANCE(3415);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3112);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(2959);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3089);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3165);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3194);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2924);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(643)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('B' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 644:
      if (lookahead == '!') ADVANCE(890);
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '#') ADVANCE(3428);
      if (lookahead == '%') ADVANCE(3422);
      if (lookahead == '&') ADVANCE(3425);
      if (lookahead == ')') ADVANCE(2237);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == ',') ADVANCE(2228);
      if (lookahead == '-') ADVANCE(3412);
      if (lookahead == '/') ADVANCE(3421);
      if (lookahead == ':') ADVANCE(889);
      if (lookahead == '<') ADVANCE(3429);
      if (lookahead == '=') ADVANCE(2401);
      if (lookahead == '>') ADVANCE(3433);
      if (lookahead == '\\') SKIP(224)
      if (lookahead == '^') ADVANCE(3419);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == '|') ADVANCE(3427);
      if (lookahead == '~') ADVANCE(3415);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3113);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2854);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(2959);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3089);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3165);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3194);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2974);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(644)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('B' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 645:
      if (lookahead == '!') ADVANCE(890);
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '#') ADVANCE(3428);
      if (lookahead == '%') ADVANCE(3422);
      if (lookahead == '&') ADVANCE(3425);
      if (lookahead == ')') ADVANCE(2237);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == ',') ADVANCE(2228);
      if (lookahead == '-') ADVANCE(3412);
      if (lookahead == '/') ADVANCE(3421);
      if (lookahead == ':') ADVANCE(889);
      if (lookahead == '<') ADVANCE(3429);
      if (lookahead == '=') ADVANCE(2401);
      if (lookahead == '>') ADVANCE(3433);
      if (lookahead == '\\') SKIP(238)
      if (lookahead == '^') ADVANCE(3419);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == '|') ADVANCE(3427);
      if (lookahead == '~') ADVANCE(3415);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3113);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2854);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(2959);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3089);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3165);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3194);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(645)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('B' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 646:
      if (lookahead == '!') ADVANCE(890);
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '#') ADVANCE(3428);
      if (lookahead == '%') ADVANCE(3422);
      if (lookahead == '&') ADVANCE(3425);
      if (lookahead == ')') ADVANCE(2237);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == ',') ADVANCE(2228);
      if (lookahead == '-') ADVANCE(3412);
      if (lookahead == '/') ADVANCE(3421);
      if (lookahead == ':') ADVANCE(889);
      if (lookahead == '<') ADVANCE(3429);
      if (lookahead == '=') ADVANCE(2401);
      if (lookahead == '>') ADVANCE(3433);
      if (lookahead == '\\') SKIP(372)
      if (lookahead == '^') ADVANCE(3419);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == '|') ADVANCE(3427);
      if (lookahead == '~') ADVANCE(3415);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3112);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(2959);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3089);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3165);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3194);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2929);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(646)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('B' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 647:
      if (lookahead == '!') ADVANCE(890);
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '#') ADVANCE(3428);
      if (lookahead == '%') ADVANCE(3422);
      if (lookahead == '&') ADVANCE(3425);
      if (lookahead == ')') ADVANCE(2237);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == ',') ADVANCE(2228);
      if (lookahead == '-') ADVANCE(3412);
      if (lookahead == '/') ADVANCE(3421);
      if (lookahead == ':') ADVANCE(889);
      if (lookahead == '<') ADVANCE(3429);
      if (lookahead == '=') ADVANCE(2401);
      if (lookahead == '>') ADVANCE(3433);
      if (lookahead == '\\') SKIP(246)
      if (lookahead == '^') ADVANCE(3419);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == '|') ADVANCE(3427);
      if (lookahead == '~') ADVANCE(3415);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3113);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2854);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3089);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3165);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3194);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(647)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('B' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 648:
      if (lookahead == '!') ADVANCE(890);
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '#') ADVANCE(3428);
      if (lookahead == '%') ADVANCE(3422);
      if (lookahead == '&') ADVANCE(3425);
      if (lookahead == ')') ADVANCE(2237);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == ',') ADVANCE(2228);
      if (lookahead == '-') ADVANCE(3412);
      if (lookahead == '/') ADVANCE(3421);
      if (lookahead == ':') ADVANCE(889);
      if (lookahead == '<') ADVANCE(3429);
      if (lookahead == '=') ADVANCE(2401);
      if (lookahead == '>') ADVANCE(3433);
      if (lookahead == '\\') SKIP(248)
      if (lookahead == '^') ADVANCE(3419);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == '|') ADVANCE(3427);
      if (lookahead == '~') ADVANCE(3415);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3112);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3089);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3165);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3194);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2929);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(648)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('B' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 649:
      if (lookahead == '!') ADVANCE(890);
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '#') ADVANCE(3428);
      if (lookahead == '%') ADVANCE(3422);
      if (lookahead == '&') ADVANCE(3425);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == ',') ADVANCE(2228);
      if (lookahead == '-') ADVANCE(3412);
      if (lookahead == '/') ADVANCE(3421);
      if (lookahead == ':') ADVANCE(889);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '<') ADVANCE(3429);
      if (lookahead == '=') ADVANCE(2401);
      if (lookahead == '>') ADVANCE(3433);
      if (lookahead == '\\') ADVANCE(12);
      if (lookahead == '^') ADVANCE(3419);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == '|') ADVANCE(3427);
      if (lookahead == '~') ADVANCE(3415);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2989);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(2785);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(2710);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2786);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3357);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(2956);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3186);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3048);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(3141);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2684);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3142);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3145);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(2890);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2674);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2787);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2826);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3197);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3179);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3154);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2926);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(649)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('H' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 650:
      if (lookahead == '!') ADVANCE(890);
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '#') ADVANCE(3428);
      if (lookahead == '%') ADVANCE(3422);
      if (lookahead == '&') ADVANCE(3425);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == ',') ADVANCE(2228);
      if (lookahead == '-') ADVANCE(3412);
      if (lookahead == '/') ADVANCE(3421);
      if (lookahead == ':') ADVANCE(889);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '<') ADVANCE(3429);
      if (lookahead == '=') ADVANCE(2401);
      if (lookahead == '>') ADVANCE(3433);
      if (lookahead == '\\') ADVANCE(310);
      if (lookahead == '^') ADVANCE(3419);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == '|') ADVANCE(3427);
      if (lookahead == '~') ADVANCE(3415);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2989);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(2785);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(2710);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2786);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3357);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(2958);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3186);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3049);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(3141);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2684);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3142);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3145);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(2890);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2674);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2787);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2826);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3197);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3179);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3154);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2926);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(650)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('H' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 651:
      if (lookahead == '!') ADVANCE(890);
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '#') ADVANCE(3428);
      if (lookahead == '%') ADVANCE(3422);
      if (lookahead == '&') ADVANCE(3425);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == ',') ADVANCE(2228);
      if (lookahead == '-') ADVANCE(3412);
      if (lookahead == '/') ADVANCE(3421);
      if (lookahead == ':') ADVANCE(889);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '<') ADVANCE(3429);
      if (lookahead == '=') ADVANCE(2401);
      if (lookahead == '>') ADVANCE(3433);
      if (lookahead == '\\') ADVANCE(376);
      if (lookahead == '^') ADVANCE(3419);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == '|') ADVANCE(3427);
      if (lookahead == '~') ADVANCE(3415);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2989);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(2785);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(2710);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2786);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3357);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3201);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3186);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3048);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(3141);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2684);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3142);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3145);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(2890);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2674);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2787);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2826);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3197);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3179);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3154);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2919);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(651)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('H' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 652:
      if (lookahead == '!') ADVANCE(890);
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '#') ADVANCE(3428);
      if (lookahead == '%') ADVANCE(3422);
      if (lookahead == '&') ADVANCE(3425);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == ',') ADVANCE(2228);
      if (lookahead == '-') ADVANCE(3412);
      if (lookahead == '/') ADVANCE(3421);
      if (lookahead == ':') ADVANCE(889);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '<') ADVANCE(3429);
      if (lookahead == '=') ADVANCE(2401);
      if (lookahead == '>') ADVANCE(3433);
      if (lookahead == '\\') ADVANCE(408);
      if (lookahead == '^') ADVANCE(3419);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == '|') ADVANCE(3427);
      if (lookahead == '~') ADVANCE(3415);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2989);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(2785);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(2710);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2786);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3357);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3320);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3186);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3049);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(3141);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2684);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3142);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3145);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(2890);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2674);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2787);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2826);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3197);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3179);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3154);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2919);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(652)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('H' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 653:
      if (lookahead == '!') ADVANCE(890);
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '#') ADVANCE(3428);
      if (lookahead == '%') ADVANCE(3422);
      if (lookahead == '&') ADVANCE(3425);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == ',') ADVANCE(2228);
      if (lookahead == '-') ADVANCE(3412);
      if (lookahead == '/') ADVANCE(3421);
      if (lookahead == ':') ADVANCE(889);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '<') ADVANCE(3429);
      if (lookahead == '=') ADVANCE(2401);
      if (lookahead == '>') ADVANCE(3433);
      if (lookahead == '\\') ADVANCE(22);
      if (lookahead == '^') ADVANCE(3419);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == '|') ADVANCE(3427);
      if (lookahead == '~') ADVANCE(3415);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2991);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(2785);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(2710);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2808);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3357);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(2862);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3211);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3050);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2685);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3142);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3143);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(2892);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2674);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2788);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2826);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3197);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3179);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3154);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2982);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(653)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('H' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 654:
      if (lookahead == '!') ADVANCE(890);
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '#') ADVANCE(3428);
      if (lookahead == '%') ADVANCE(3422);
      if (lookahead == '&') ADVANCE(3425);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == ',') ADVANCE(2228);
      if (lookahead == '-') ADVANCE(3412);
      if (lookahead == '/') ADVANCE(3421);
      if (lookahead == ':') ADVANCE(889);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '<') ADVANCE(3429);
      if (lookahead == '=') ADVANCE(2401);
      if (lookahead == '>') ADVANCE(3433);
      if (lookahead == '\\') ADVANCE(314);
      if (lookahead == '^') ADVANCE(3419);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == '|') ADVANCE(3427);
      if (lookahead == '~') ADVANCE(3415);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2991);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(2785);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(2710);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2808);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3357);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(2959);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3211);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3050);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2685);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3142);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3143);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(2892);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2674);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2788);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2826);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3197);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3179);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3154);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2979);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(654)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('H' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 655:
      if (lookahead == '!') ADVANCE(890);
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '#') ADVANCE(3428);
      if (lookahead == '%') ADVANCE(3422);
      if (lookahead == '&') ADVANCE(3425);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == ',') ADVANCE(2228);
      if (lookahead == '-') ADVANCE(3412);
      if (lookahead == '/') ADVANCE(3421);
      if (lookahead == ':') ADVANCE(889);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '<') ADVANCE(3429);
      if (lookahead == '=') ADVANCE(2401);
      if (lookahead == '>') ADVANCE(3433);
      if (lookahead == '\\') ADVANCE(28);
      if (lookahead == '^') ADVANCE(3419);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == '|') ADVANCE(3427);
      if (lookahead == '~') ADVANCE(3415);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2989);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(2785);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(2710);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2786);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3357);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(2959);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3211);
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(2668);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3050);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2685);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3142);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3145);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(2890);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2674);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2788);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2826);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3197);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3179);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3154);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2979);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(655)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('J' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 656:
      if (lookahead == '!') ADVANCE(890);
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '#') ADVANCE(3428);
      if (lookahead == '%') ADVANCE(3422);
      if (lookahead == '&') ADVANCE(3425);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == ',') ADVANCE(2228);
      if (lookahead == '-') ADVANCE(3412);
      if (lookahead == '/') ADVANCE(3421);
      if (lookahead == ':') ADVANCE(889);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '<') ADVANCE(3429);
      if (lookahead == '=') ADVANCE(2401);
      if (lookahead == '>') ADVANCE(3433);
      if (lookahead == '\\') ADVANCE(380);
      if (lookahead == '^') ADVANCE(3419);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == '|') ADVANCE(3427);
      if (lookahead == '~') ADVANCE(3415);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2991);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(2785);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(2710);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2808);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3357);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(2863);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3211);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3050);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2685);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3142);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3143);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(2892);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2674);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2788);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2826);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3197);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3179);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3154);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2976);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(656)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('H' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 657:
      if (lookahead == '!') ADVANCE(890);
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '#') ADVANCE(3428);
      if (lookahead == '%') ADVANCE(3422);
      if (lookahead == '&') ADVANCE(3425);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == ',') ADVANCE(2228);
      if (lookahead == '-') ADVANCE(3412);
      if (lookahead == '/') ADVANCE(3421);
      if (lookahead == ':') ADVANCE(889);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '<') ADVANCE(3429);
      if (lookahead == '=') ADVANCE(2401);
      if (lookahead == '>') ADVANCE(3433);
      if (lookahead == '\\') ADVANCE(412);
      if (lookahead == '^') ADVANCE(3419);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == '|') ADVANCE(3427);
      if (lookahead == '~') ADVANCE(3415);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2989);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(2785);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(2710);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2786);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3357);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(2957);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3211);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3050);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2686);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3142);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3145);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3194);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2674);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2788);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2826);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3197);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3179);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3154);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2927);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(657)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('H' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 658:
      if (lookahead == '!') ADVANCE(890);
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '#') ADVANCE(3428);
      if (lookahead == '%') ADVANCE(3422);
      if (lookahead == '&') ADVANCE(3425);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == ',') ADVANCE(2228);
      if (lookahead == '-') ADVANCE(3412);
      if (lookahead == '/') ADVANCE(3421);
      if (lookahead == ':') ADVANCE(889);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '<') ADVANCE(3429);
      if (lookahead == '=') ADVANCE(2401);
      if (lookahead == '>') ADVANCE(3433);
      if (lookahead == '\\') ADVANCE(40);
      if (lookahead == '^') ADVANCE(3419);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == '|') ADVANCE(3427);
      if (lookahead == '~') ADVANCE(3415);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2991);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(2785);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(2710);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2808);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3357);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3211);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3050);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2685);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3142);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3143);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(2892);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2674);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2788);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2826);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3197);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3179);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3154);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2939);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(658)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('F' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 659:
      if (lookahead == '!') ADVANCE(890);
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '#') ADVANCE(3428);
      if (lookahead == '%') ADVANCE(3422);
      if (lookahead == '&') ADVANCE(3425);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == ',') ADVANCE(2228);
      if (lookahead == '-') ADVANCE(3412);
      if (lookahead == '/') ADVANCE(3421);
      if (lookahead == ':') ADVANCE(889);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '<') ADVANCE(3429);
      if (lookahead == '=') ADVANCE(2401);
      if (lookahead == '>') ADVANCE(3433);
      if (lookahead == '\\') ADVANCE(42);
      if (lookahead == '^') ADVANCE(3419);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == '|') ADVANCE(3427);
      if (lookahead == '~') ADVANCE(3415);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2989);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(2785);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(2710);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2786);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3357);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3211);
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(2668);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3050);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2685);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3142);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3145);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(2890);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2674);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2788);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2826);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3197);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3179);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3154);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2939);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(659)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('F' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 660:
      if (lookahead == '!') ADVANCE(890);
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '#') ADVANCE(3428);
      if (lookahead == '%') ADVANCE(3422);
      if (lookahead == '&') ADVANCE(3425);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == ',') ADVANCE(2228);
      if (lookahead == '-') ADVANCE(3412);
      if (lookahead == '/') ADVANCE(3421);
      if (lookahead == ':') ADVANCE(889);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '<') ADVANCE(3429);
      if (lookahead == '=') ADVANCE(2401);
      if (lookahead == '>') ADVANCE(3433);
      if (lookahead == '\\') ADVANCE(434);
      if (lookahead == '^') ADVANCE(3419);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == '|') ADVANCE(3427);
      if (lookahead == '~') ADVANCE(3415);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2989);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(2785);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(2710);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2786);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3357);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(2959);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3211);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3050);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2686);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3142);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3145);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3194);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2674);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2788);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2826);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3197);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3179);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3154);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2927);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(660)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('H' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 661:
      if (lookahead == '!') ADVANCE(890);
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '#') ADVANCE(3428);
      if (lookahead == '%') ADVANCE(3422);
      if (lookahead == '&') ADVANCE(3425);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == ',') ADVANCE(2228);
      if (lookahead == '-') ADVANCE(3412);
      if (lookahead == '/') ADVANCE(3421);
      if (lookahead == ':') ADVANCE(889);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '<') ADVANCE(3429);
      if (lookahead == '=') ADVANCE(2401);
      if (lookahead == '>') ADVANCE(3433);
      if (lookahead == '\\') ADVANCE(440);
      if (lookahead == '^') ADVANCE(3419);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == '|') ADVANCE(3427);
      if (lookahead == '~') ADVANCE(3415);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2989);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(2785);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(2710);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2786);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3357);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(2959);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3211);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3050);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2686);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3142);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3145);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3194);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2674);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2788);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2826);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3197);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3179);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3154);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2982);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(661)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('H' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 662:
      if (lookahead == '!') ADVANCE(890);
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '#') ADVANCE(3428);
      if (lookahead == '%') ADVANCE(3422);
      if (lookahead == '&') ADVANCE(3425);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == ',') ADVANCE(2228);
      if (lookahead == '-') ADVANCE(3412);
      if (lookahead == '/') ADVANCE(3421);
      if (lookahead == ':') ADVANCE(889);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '<') ADVANCE(3429);
      if (lookahead == '=') ADVANCE(2401);
      if (lookahead == '>') ADVANCE(3433);
      if (lookahead == '\\') ADVANCE(446);
      if (lookahead == '^') ADVANCE(3419);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == '|') ADVANCE(3427);
      if (lookahead == '~') ADVANCE(3415);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2989);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(2785);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(2710);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2786);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3357);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3202);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3211);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3050);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2686);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3142);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3145);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3194);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2674);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2788);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2826);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3197);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3179);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3154);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2925);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(662)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('H' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 663:
      if (lookahead == '!') ADVANCE(890);
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '#') ADVANCE(3428);
      if (lookahead == '%') ADVANCE(3422);
      if (lookahead == '&') ADVANCE(3425);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == ',') ADVANCE(2228);
      if (lookahead == '-') ADVANCE(3412);
      if (lookahead == '/') ADVANCE(3421);
      if (lookahead == ':') ADVANCE(889);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '<') ADVANCE(3429);
      if (lookahead == '=') ADVANCE(2401);
      if (lookahead == '>') ADVANCE(3433);
      if (lookahead == '\\') ADVANCE(326);
      if (lookahead == '^') ADVANCE(3419);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == '|') ADVANCE(3427);
      if (lookahead == '~') ADVANCE(3415);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2989);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(2785);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(2710);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2786);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3357);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3211);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3050);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2686);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3142);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3145);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3194);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2674);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2788);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2826);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3197);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3179);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3154);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2925);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(663)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('F' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 664:
      if (lookahead == '!') ADVANCE(890);
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '#') ADVANCE(3428);
      if (lookahead == '%') ADVANCE(3422);
      if (lookahead == '&') ADVANCE(3425);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == ',') ADVANCE(2228);
      if (lookahead == '-') ADVANCE(3412);
      if (lookahead == '/') ADVANCE(3421);
      if (lookahead == ':') ADVANCE(889);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '<') ADVANCE(3429);
      if (lookahead == '=') ADVANCE(2401);
      if (lookahead == '>') ADVANCE(3433);
      if (lookahead == '\\') ADVANCE(386);
      if (lookahead == '^') ADVANCE(3419);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == '|') ADVANCE(3427);
      if (lookahead == '~') ADVANCE(3415);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2989);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(2785);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(2710);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2786);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3357);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3211);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3050);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2686);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3142);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3145);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3194);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2674);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2788);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2826);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3197);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3179);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3154);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2976);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(664)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('F' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 665:
      if (lookahead == '!') ADVANCE(890);
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '#') ADVANCE(3428);
      if (lookahead == '%') ADVANCE(3422);
      if (lookahead == '&') ADVANCE(3425);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == ',') ADVANCE(2228);
      if (lookahead == '-') ADVANCE(3412);
      if (lookahead == '/') ADVANCE(3421);
      if (lookahead == ':') ADVANCE(889);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '<') ADVANCE(3429);
      if (lookahead == '=') ADVANCE(2401);
      if (lookahead == '>') ADVANCE(3433);
      if (lookahead == '\\') ADVANCE(56);
      if (lookahead == '^') ADVANCE(3419);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == '|') ADVANCE(3427);
      if (lookahead == '~') ADVANCE(3415);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2989);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(2785);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3159);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2860);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(2956);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3186);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3076);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(3141);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2831);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3165);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(2890);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2937);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2811);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3213);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3179);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2926);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(665)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('E' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 666:
      if (lookahead == '!') ADVANCE(890);
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '#') ADVANCE(3428);
      if (lookahead == '%') ADVANCE(3422);
      if (lookahead == '&') ADVANCE(3425);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == ',') ADVANCE(2228);
      if (lookahead == '-') ADVANCE(3412);
      if (lookahead == '/') ADVANCE(3421);
      if (lookahead == ':') ADVANCE(889);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '<') ADVANCE(3429);
      if (lookahead == '=') ADVANCE(2401);
      if (lookahead == '>') ADVANCE(3433);
      if (lookahead == '\\') ADVANCE(336);
      if (lookahead == '^') ADVANCE(3419);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == '|') ADVANCE(3427);
      if (lookahead == '~') ADVANCE(3415);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2989);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(2785);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3159);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2860);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(2958);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3186);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3078);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(3141);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2831);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3165);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(2890);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2937);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2811);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3213);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3179);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2926);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(666)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('E' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 667:
      if (lookahead == '!') ADVANCE(890);
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '#') ADVANCE(3428);
      if (lookahead == '%') ADVANCE(3422);
      if (lookahead == '&') ADVANCE(3425);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == ',') ADVANCE(2228);
      if (lookahead == '-') ADVANCE(3412);
      if (lookahead == '/') ADVANCE(3421);
      if (lookahead == ':') ADVANCE(889);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '<') ADVANCE(3429);
      if (lookahead == '=') ADVANCE(2401);
      if (lookahead == '>') ADVANCE(3433);
      if (lookahead == '\\') ADVANCE(66);
      if (lookahead == '^') ADVANCE(3419);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == '|') ADVANCE(3427);
      if (lookahead == '~') ADVANCE(3415);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2989);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3196);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2812);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3115);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(2956);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3186);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3076);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(3141);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2831);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3165);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(2890);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2867);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2811);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3179);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2926);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(667)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('B' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 668:
      if (lookahead == '!') ADVANCE(890);
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '#') ADVANCE(3428);
      if (lookahead == '%') ADVANCE(3422);
      if (lookahead == '&') ADVANCE(3425);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == ',') ADVANCE(2228);
      if (lookahead == '-') ADVANCE(3412);
      if (lookahead == '/') ADVANCE(3421);
      if (lookahead == ':') ADVANCE(889);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '<') ADVANCE(3429);
      if (lookahead == '=') ADVANCE(2401);
      if (lookahead == '>') ADVANCE(3433);
      if (lookahead == '\\') ADVANCE(390);
      if (lookahead == '^') ADVANCE(3419);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == '|') ADVANCE(3427);
      if (lookahead == '~') ADVANCE(3415);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2989);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(2785);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3159);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2860);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3201);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3186);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3076);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(3141);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2831);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3165);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(2890);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2937);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2811);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3213);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3179);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2919);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(668)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('E' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 669:
      if (lookahead == '!') ADVANCE(890);
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '#') ADVANCE(3428);
      if (lookahead == '%') ADVANCE(3422);
      if (lookahead == '&') ADVANCE(3425);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == ',') ADVANCE(2228);
      if (lookahead == '-') ADVANCE(3412);
      if (lookahead == '/') ADVANCE(3421);
      if (lookahead == ':') ADVANCE(889);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '<') ADVANCE(3429);
      if (lookahead == '=') ADVANCE(2401);
      if (lookahead == '>') ADVANCE(3433);
      if (lookahead == '\\') ADVANCE(340);
      if (lookahead == '^') ADVANCE(3419);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == '|') ADVANCE(3427);
      if (lookahead == '~') ADVANCE(3415);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2989);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3196);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2812);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3115);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(2958);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3186);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3078);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(3141);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2831);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3165);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(2890);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2867);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2811);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3179);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2926);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(669)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('B' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 670:
      if (lookahead == '!') ADVANCE(890);
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '#') ADVANCE(3428);
      if (lookahead == '%') ADVANCE(3422);
      if (lookahead == '&') ADVANCE(3425);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == ',') ADVANCE(2228);
      if (lookahead == '-') ADVANCE(3412);
      if (lookahead == '/') ADVANCE(3421);
      if (lookahead == ':') ADVANCE(889);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '<') ADVANCE(3429);
      if (lookahead == '=') ADVANCE(2401);
      if (lookahead == '>') ADVANCE(3433);
      if (lookahead == '\\') ADVANCE(420);
      if (lookahead == '^') ADVANCE(3419);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == '|') ADVANCE(3427);
      if (lookahead == '~') ADVANCE(3415);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2989);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(2785);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3159);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2860);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3320);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3186);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3078);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(3141);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2831);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3165);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(2890);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2937);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2811);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3213);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3179);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2919);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(670)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('E' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 671:
      if (lookahead == '!') ADVANCE(890);
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '#') ADVANCE(3428);
      if (lookahead == '%') ADVANCE(3422);
      if (lookahead == '&') ADVANCE(3425);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == ',') ADVANCE(2228);
      if (lookahead == '-') ADVANCE(3412);
      if (lookahead == '/') ADVANCE(3421);
      if (lookahead == ':') ADVANCE(889);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '<') ADVANCE(3429);
      if (lookahead == '=') ADVANCE(2401);
      if (lookahead == '>') ADVANCE(3433);
      if (lookahead == '\\') ADVANCE(392);
      if (lookahead == '^') ADVANCE(3419);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == '|') ADVANCE(3427);
      if (lookahead == '~') ADVANCE(3415);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2989);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3196);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2812);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3115);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3201);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3186);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3076);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(3141);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2831);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3165);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(2890);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2867);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2811);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3179);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2919);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(671)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('B' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 672:
      if (lookahead == '!') ADVANCE(890);
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '#') ADVANCE(3428);
      if (lookahead == '%') ADVANCE(3422);
      if (lookahead == '&') ADVANCE(3425);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == ',') ADVANCE(2228);
      if (lookahead == '-') ADVANCE(3412);
      if (lookahead == '/') ADVANCE(3421);
      if (lookahead == ':') ADVANCE(889);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '<') ADVANCE(3429);
      if (lookahead == '=') ADVANCE(2401);
      if (lookahead == '>') ADVANCE(3433);
      if (lookahead == '\\') ADVANCE(422);
      if (lookahead == '^') ADVANCE(3419);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == '|') ADVANCE(3427);
      if (lookahead == '~') ADVANCE(3415);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2989);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3196);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2812);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3115);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3320);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3186);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3078);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(3141);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2831);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3165);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(2890);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2867);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2811);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3179);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2919);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(672)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('B' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 673:
      if (lookahead == '!') ADVANCE(890);
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '#') ADVANCE(3428);
      if (lookahead == '%') ADVANCE(3422);
      if (lookahead == '&') ADVANCE(3425);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == ',') ADVANCE(2228);
      if (lookahead == '-') ADVANCE(3412);
      if (lookahead == '/') ADVANCE(3421);
      if (lookahead == ':') ADVANCE(889);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '<') ADVANCE(3429);
      if (lookahead == '=') ADVANCE(2401);
      if (lookahead == '>') ADVANCE(3433);
      if (lookahead == '\\') ADVANCE(106);
      if (lookahead == '^') ADVANCE(3419);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == '|') ADVANCE(3427);
      if (lookahead == '~') ADVANCE(3415);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2989);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(2785);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3159);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2860);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(2959);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3211);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3079);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3165);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3194);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3172);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2811);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3213);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3179);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2921);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(673)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('E' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 674:
      if (lookahead == '!') ADVANCE(890);
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '#') ADVANCE(3428);
      if (lookahead == '%') ADVANCE(3422);
      if (lookahead == '&') ADVANCE(3425);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == ',') ADVANCE(2228);
      if (lookahead == '-') ADVANCE(3412);
      if (lookahead == '/') ADVANCE(3421);
      if (lookahead == ':') ADVANCE(889);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '<') ADVANCE(3429);
      if (lookahead == '=') ADVANCE(2401);
      if (lookahead == '>') ADVANCE(3433);
      if (lookahead == '\\') ADVANCE(124);
      if (lookahead == '^') ADVANCE(3419);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == '|') ADVANCE(3427);
      if (lookahead == '~') ADVANCE(3415);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2989);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3196);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2812);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3115);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(2959);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3211);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3079);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3165);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3194);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2868);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2811);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3179);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2921);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(674)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('B' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 675:
      if (lookahead == '!') ADVANCE(890);
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '#') ADVANCE(3428);
      if (lookahead == '%') ADVANCE(3422);
      if (lookahead == '&') ADVANCE(3425);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == ',') ADVANCE(2228);
      if (lookahead == '-') ADVANCE(3412);
      if (lookahead == '/') ADVANCE(3421);
      if (lookahead == ':') ADVANCE(889);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '<') ADVANCE(3429);
      if (lookahead == '=') ADVANCE(2401);
      if (lookahead == '>') ADVANCE(3433);
      if (lookahead == '\\') ADVANCE(134);
      if (lookahead == '^') ADVANCE(3419);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == '|') ADVANCE(3427);
      if (lookahead == '~') ADVANCE(3415);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2989);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(2785);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3159);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2860);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3211);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3079);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3165);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3194);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3172);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2811);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3213);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3179);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2923);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(675)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('E' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 676:
      if (lookahead == '!') ADVANCE(890);
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '#') ADVANCE(3428);
      if (lookahead == '%') ADVANCE(3422);
      if (lookahead == '&') ADVANCE(3425);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == ',') ADVANCE(2228);
      if (lookahead == '-') ADVANCE(3412);
      if (lookahead == '/') ADVANCE(3421);
      if (lookahead == ':') ADVANCE(889);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '<') ADVANCE(3429);
      if (lookahead == '=') ADVANCE(2401);
      if (lookahead == '>') ADVANCE(3433);
      if (lookahead == '\\') ADVANCE(158);
      if (lookahead == '^') ADVANCE(3419);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == '|') ADVANCE(3427);
      if (lookahead == '~') ADVANCE(3415);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2989);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3196);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2812);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3115);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3211);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3079);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3165);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3194);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2868);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2811);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3179);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2923);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(676)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('B' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 677:
      if (lookahead == '!') ADVANCE(890);
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '#') ADVANCE(3428);
      if (lookahead == '%') ADVANCE(3422);
      if (lookahead == '&') ADVANCE(3425);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == ',') ADVANCE(2228);
      if (lookahead == '-') ADVANCE(3412);
      if (lookahead == '/') ADVANCE(3421);
      if (lookahead == ':') ADVANCE(889);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '<') ADVANCE(3429);
      if (lookahead == '=') ADVANCE(2401);
      if (lookahead == '>') ADVANCE(3433);
      if (lookahead == '\\') ADVANCE(454);
      if (lookahead == '^') ADVANCE(3419);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == '|') ADVANCE(3427);
      if (lookahead == '~') ADVANCE(3415);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2989);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(2785);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(2710);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2786);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3357);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(2956);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3186);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3048);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(3141);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2684);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3142);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3145);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(2890);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2674);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2787);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2826);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3197);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3179);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3154);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2919);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(677)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('H' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 678:
      if (lookahead == '!') ADVANCE(890);
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '#') ADVANCE(3428);
      if (lookahead == '%') ADVANCE(3422);
      if (lookahead == '&') ADVANCE(3425);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == ',') ADVANCE(2228);
      if (lookahead == '-') ADVANCE(3412);
      if (lookahead == '/') ADVANCE(3421);
      if (lookahead == ':') ADVANCE(889);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '<') ADVANCE(3429);
      if (lookahead == '=') ADVANCE(2401);
      if (lookahead == '>') ADVANCE(3433);
      if (lookahead == '\\') ADVANCE(500);
      if (lookahead == '^') ADVANCE(3419);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == '|') ADVANCE(3427);
      if (lookahead == '~') ADVANCE(3415);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2989);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(2785);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(2710);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2786);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3357);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(2958);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3186);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3049);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(3141);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2684);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3142);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3145);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(2890);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2674);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2787);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2826);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3197);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3179);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3154);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2919);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(678)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('H' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 679:
      if (lookahead == '!') ADVANCE(890);
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '#') ADVANCE(3428);
      if (lookahead == '%') ADVANCE(3422);
      if (lookahead == '&') ADVANCE(3425);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == ',') ADVANCE(2228);
      if (lookahead == '-') ADVANCE(3412);
      if (lookahead == '/') ADVANCE(3421);
      if (lookahead == ':') ADVANCE(889);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '<') ADVANCE(3429);
      if (lookahead == '=') ADVANCE(2401);
      if (lookahead == '>') ADVANCE(3433);
      if (lookahead == '\\') ADVANCE(516);
      if (lookahead == '^') ADVANCE(3419);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == '|') ADVANCE(3427);
      if (lookahead == '~') ADVANCE(3415);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2989);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(2785);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(2710);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2786);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3357);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3201);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3186);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3048);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(3141);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2684);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3142);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3145);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(2890);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2674);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2787);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2826);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3197);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3179);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3154);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2925);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(679)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('H' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 680:
      if (lookahead == '!') ADVANCE(890);
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '#') ADVANCE(3428);
      if (lookahead == '%') ADVANCE(3422);
      if (lookahead == '&') ADVANCE(3425);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == ',') ADVANCE(2228);
      if (lookahead == '-') ADVANCE(3412);
      if (lookahead == '/') ADVANCE(3421);
      if (lookahead == ':') ADVANCE(889);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '<') ADVANCE(3429);
      if (lookahead == '=') ADVANCE(2401);
      if (lookahead == '>') ADVANCE(3433);
      if (lookahead == '\\') ADVANCE(526);
      if (lookahead == '^') ADVANCE(3419);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == '|') ADVANCE(3427);
      if (lookahead == '~') ADVANCE(3415);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2989);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(2785);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(2710);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2786);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3357);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3320);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3186);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3049);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(3141);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2684);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3142);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3145);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(2890);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2674);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2787);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2826);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3197);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3179);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3154);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2925);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(680)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('H' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 681:
      if (lookahead == '!') ADVANCE(890);
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '#') ADVANCE(3428);
      if (lookahead == '%') ADVANCE(3422);
      if (lookahead == '&') ADVANCE(3425);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == ',') ADVANCE(2228);
      if (lookahead == '-') ADVANCE(3412);
      if (lookahead == '/') ADVANCE(3421);
      if (lookahead == ':') ADVANCE(889);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '<') ADVANCE(3429);
      if (lookahead == '=') ADVANCE(2401);
      if (lookahead == '>') ADVANCE(3433);
      if (lookahead == '\\') ADVANCE(458);
      if (lookahead == '^') ADVANCE(3419);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == '|') ADVANCE(3427);
      if (lookahead == '~') ADVANCE(3415);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2991);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(2785);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(2710);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2808);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3357);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(2862);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3211);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3050);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2685);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3142);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3143);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(2892);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2674);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2788);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2826);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3197);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3179);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3154);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2976);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(681)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('H' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 682:
      if (lookahead == '!') ADVANCE(890);
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '#') ADVANCE(3428);
      if (lookahead == '%') ADVANCE(3422);
      if (lookahead == '&') ADVANCE(3425);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == ',') ADVANCE(2228);
      if (lookahead == '-') ADVANCE(3412);
      if (lookahead == '/') ADVANCE(3421);
      if (lookahead == ':') ADVANCE(889);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '<') ADVANCE(3429);
      if (lookahead == '=') ADVANCE(2401);
      if (lookahead == '>') ADVANCE(3433);
      if (lookahead == '\\') ADVANCE(502);
      if (lookahead == '^') ADVANCE(3419);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == '|') ADVANCE(3427);
      if (lookahead == '~') ADVANCE(3415);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2991);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(2785);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(2710);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2808);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3357);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(2959);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3211);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3050);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2685);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3142);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3143);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(2892);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2674);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2788);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2826);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3197);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3179);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3154);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2939);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(682)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('H' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 683:
      if (lookahead == '!') ADVANCE(890);
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '#') ADVANCE(3428);
      if (lookahead == '%') ADVANCE(3422);
      if (lookahead == '&') ADVANCE(3425);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == ',') ADVANCE(2228);
      if (lookahead == '-') ADVANCE(3412);
      if (lookahead == '/') ADVANCE(3421);
      if (lookahead == ':') ADVANCE(889);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '<') ADVANCE(3429);
      if (lookahead == '=') ADVANCE(2401);
      if (lookahead == '>') ADVANCE(3433);
      if (lookahead == '\\') ADVANCE(460);
      if (lookahead == '^') ADVANCE(3419);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == '|') ADVANCE(3427);
      if (lookahead == '~') ADVANCE(3415);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2989);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(2785);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(2710);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2786);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3357);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(2959);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3211);
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(2668);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3050);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2685);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3142);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3145);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(2890);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2674);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2788);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2826);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3197);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3179);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3154);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2939);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(683)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('J' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 684:
      if (lookahead == '!') ADVANCE(890);
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '#') ADVANCE(3428);
      if (lookahead == '%') ADVANCE(3422);
      if (lookahead == '&') ADVANCE(3425);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == ',') ADVANCE(2228);
      if (lookahead == '-') ADVANCE(3412);
      if (lookahead == '/') ADVANCE(3421);
      if (lookahead == ':') ADVANCE(889);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '<') ADVANCE(3429);
      if (lookahead == '=') ADVANCE(2401);
      if (lookahead == '>') ADVANCE(3433);
      if (lookahead == '\\') ADVANCE(464);
      if (lookahead == '^') ADVANCE(3419);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == '|') ADVANCE(3427);
      if (lookahead == '~') ADVANCE(3415);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2991);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(2785);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(2710);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2808);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3357);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3211);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3050);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2685);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3142);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3143);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(2892);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2674);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2788);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2826);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3197);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3179);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3154);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2976);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(684)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('F' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 685:
      if (lookahead == '!') ADVANCE(890);
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '#') ADVANCE(3428);
      if (lookahead == '%') ADVANCE(3422);
      if (lookahead == '&') ADVANCE(3425);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == ',') ADVANCE(2228);
      if (lookahead == '-') ADVANCE(3412);
      if (lookahead == '/') ADVANCE(3421);
      if (lookahead == ':') ADVANCE(889);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '<') ADVANCE(3429);
      if (lookahead == '=') ADVANCE(2401);
      if (lookahead == '>') ADVANCE(3433);
      if (lookahead == '\\') ADVANCE(466);
      if (lookahead == '^') ADVANCE(3419);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == '|') ADVANCE(3427);
      if (lookahead == '~') ADVANCE(3415);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2989);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(2785);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(2710);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2786);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3357);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3211);
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(2668);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3050);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2685);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3142);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3145);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(2890);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2674);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2788);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2826);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3197);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3179);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3154);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2976);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(685)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('F' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 686:
      if (lookahead == '!') ADVANCE(890);
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '#') ADVANCE(3428);
      if (lookahead == '%') ADVANCE(3422);
      if (lookahead == '&') ADVANCE(3425);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == ',') ADVANCE(2228);
      if (lookahead == '-') ADVANCE(3412);
      if (lookahead == '/') ADVANCE(3421);
      if (lookahead == ':') ADVANCE(889);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '<') ADVANCE(3429);
      if (lookahead == '=') ADVANCE(2401);
      if (lookahead == '>') ADVANCE(3433);
      if (lookahead == '\\') ADVANCE(538);
      if (lookahead == '^') ADVANCE(3419);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == '|') ADVANCE(3427);
      if (lookahead == '~') ADVANCE(3415);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2989);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(2785);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(2710);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2786);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3357);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(2959);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3211);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3050);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2686);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3142);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3145);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3194);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2674);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2788);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2826);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3197);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3179);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3154);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2976);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(686)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('H' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 687:
      if (lookahead == '!') ADVANCE(890);
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '#') ADVANCE(3428);
      if (lookahead == '%') ADVANCE(3422);
      if (lookahead == '&') ADVANCE(3425);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == ',') ADVANCE(2228);
      if (lookahead == '-') ADVANCE(3412);
      if (lookahead == '/') ADVANCE(3421);
      if (lookahead == ':') ADVANCE(889);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '<') ADVANCE(3429);
      if (lookahead == '=') ADVANCE(2401);
      if (lookahead == '>') ADVANCE(3433);
      if (lookahead == '\\') ADVANCE(474);
      if (lookahead == '^') ADVANCE(3419);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == '|') ADVANCE(3427);
      if (lookahead == '~') ADVANCE(3415);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2989);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(2785);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3159);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2860);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(2956);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3186);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3076);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(3141);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2831);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3165);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(2890);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2937);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2811);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3213);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3179);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2919);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(687)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('E' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 688:
      if (lookahead == '!') ADVANCE(890);
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '#') ADVANCE(3428);
      if (lookahead == '%') ADVANCE(3422);
      if (lookahead == '&') ADVANCE(3425);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == ',') ADVANCE(2228);
      if (lookahead == '-') ADVANCE(3412);
      if (lookahead == '/') ADVANCE(3421);
      if (lookahead == ':') ADVANCE(889);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '<') ADVANCE(3429);
      if (lookahead == '=') ADVANCE(2401);
      if (lookahead == '>') ADVANCE(3433);
      if (lookahead == '\\') ADVANCE(508);
      if (lookahead == '^') ADVANCE(3419);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == '|') ADVANCE(3427);
      if (lookahead == '~') ADVANCE(3415);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2989);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(2785);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3159);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2860);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(2958);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3186);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3078);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(3141);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2831);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3165);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(2890);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2937);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2811);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3213);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3179);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2919);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(688)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('E' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 689:
      if (lookahead == '!') ADVANCE(890);
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '#') ADVANCE(3428);
      if (lookahead == '%') ADVANCE(3422);
      if (lookahead == '&') ADVANCE(3425);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == ',') ADVANCE(2228);
      if (lookahead == '-') ADVANCE(3412);
      if (lookahead == '/') ADVANCE(3421);
      if (lookahead == ':') ADVANCE(889);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '<') ADVANCE(3429);
      if (lookahead == '=') ADVANCE(2401);
      if (lookahead == '>') ADVANCE(3433);
      if (lookahead == '\\') ADVANCE(476);
      if (lookahead == '^') ADVANCE(3419);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == '|') ADVANCE(3427);
      if (lookahead == '~') ADVANCE(3415);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2989);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3196);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2812);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3115);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(2956);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3186);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3076);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(3141);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2831);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3165);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(2890);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2867);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2811);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3179);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2919);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(689)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('B' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 690:
      if (lookahead == '!') ADVANCE(890);
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '#') ADVANCE(3428);
      if (lookahead == '%') ADVANCE(3422);
      if (lookahead == '&') ADVANCE(3425);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == ',') ADVANCE(2228);
      if (lookahead == '-') ADVANCE(3412);
      if (lookahead == '/') ADVANCE(3421);
      if (lookahead == ':') ADVANCE(889);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '<') ADVANCE(3429);
      if (lookahead == '=') ADVANCE(2401);
      if (lookahead == '>') ADVANCE(3433);
      if (lookahead == '\\') ADVANCE(520);
      if (lookahead == '^') ADVANCE(3419);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == '|') ADVANCE(3427);
      if (lookahead == '~') ADVANCE(3415);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2989);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(2785);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3159);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2860);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3201);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3186);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3076);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(3141);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2831);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3165);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(2890);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2937);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2811);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3213);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3179);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2925);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(690)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('E' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 691:
      if (lookahead == '!') ADVANCE(890);
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '#') ADVANCE(3428);
      if (lookahead == '%') ADVANCE(3422);
      if (lookahead == '&') ADVANCE(3425);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == ',') ADVANCE(2228);
      if (lookahead == '-') ADVANCE(3412);
      if (lookahead == '/') ADVANCE(3421);
      if (lookahead == ':') ADVANCE(889);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '<') ADVANCE(3429);
      if (lookahead == '=') ADVANCE(2401);
      if (lookahead == '>') ADVANCE(3433);
      if (lookahead == '\\') ADVANCE(510);
      if (lookahead == '^') ADVANCE(3419);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == '|') ADVANCE(3427);
      if (lookahead == '~') ADVANCE(3415);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2989);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3196);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2812);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3115);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(2958);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3186);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3078);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(3141);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2831);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3165);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(2890);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2867);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2811);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3179);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2919);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(691)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('B' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 692:
      if (lookahead == '!') ADVANCE(890);
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '#') ADVANCE(3428);
      if (lookahead == '%') ADVANCE(3422);
      if (lookahead == '&') ADVANCE(3425);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == ',') ADVANCE(2228);
      if (lookahead == '-') ADVANCE(3412);
      if (lookahead == '/') ADVANCE(3421);
      if (lookahead == ':') ADVANCE(889);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '<') ADVANCE(3429);
      if (lookahead == '=') ADVANCE(2401);
      if (lookahead == '>') ADVANCE(3433);
      if (lookahead == '\\') ADVANCE(530);
      if (lookahead == '^') ADVANCE(3419);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == '|') ADVANCE(3427);
      if (lookahead == '~') ADVANCE(3415);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2989);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(2785);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3159);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2860);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3320);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3186);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3078);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(3141);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2831);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3165);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(2890);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2937);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2811);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3213);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3179);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2925);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(692)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('E' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 693:
      if (lookahead == '!') ADVANCE(890);
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '#') ADVANCE(3428);
      if (lookahead == '%') ADVANCE(3422);
      if (lookahead == '&') ADVANCE(3425);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == ',') ADVANCE(2228);
      if (lookahead == '-') ADVANCE(3412);
      if (lookahead == '/') ADVANCE(3421);
      if (lookahead == ':') ADVANCE(889);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '<') ADVANCE(3429);
      if (lookahead == '=') ADVANCE(2401);
      if (lookahead == '>') ADVANCE(3433);
      if (lookahead == '\\') ADVANCE(522);
      if (lookahead == '^') ADVANCE(3419);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == '|') ADVANCE(3427);
      if (lookahead == '~') ADVANCE(3415);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2989);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3196);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2812);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3115);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3201);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3186);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3076);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(3141);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2831);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3165);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(2890);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2867);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2811);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3179);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2925);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(693)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('B' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 694:
      if (lookahead == '!') ADVANCE(890);
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '#') ADVANCE(3428);
      if (lookahead == '%') ADVANCE(3422);
      if (lookahead == '&') ADVANCE(3425);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == ',') ADVANCE(2228);
      if (lookahead == '-') ADVANCE(3412);
      if (lookahead == '/') ADVANCE(3421);
      if (lookahead == ':') ADVANCE(889);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '<') ADVANCE(3429);
      if (lookahead == '=') ADVANCE(2401);
      if (lookahead == '>') ADVANCE(3433);
      if (lookahead == '\\') ADVANCE(532);
      if (lookahead == '^') ADVANCE(3419);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == '|') ADVANCE(3427);
      if (lookahead == '~') ADVANCE(3415);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2989);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3196);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2812);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3115);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3320);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3186);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3078);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(3141);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2831);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3165);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(2890);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2867);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2811);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3179);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2925);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(694)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('B' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 695:
      if (lookahead == '!') ADVANCE(890);
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '#') ADVANCE(3428);
      if (lookahead == '%') ADVANCE(3422);
      if (lookahead == '&') ADVANCE(3425);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == ',') ADVANCE(2228);
      if (lookahead == '-') ADVANCE(3412);
      if (lookahead == '/') ADVANCE(3421);
      if (lookahead == ':') ADVANCE(889);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '<') ADVANCE(3429);
      if (lookahead == '=') ADVANCE(2401);
      if (lookahead == '>') ADVANCE(3433);
      if (lookahead == '\\') ADVANCE(486);
      if (lookahead == '^') ADVANCE(3419);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == '|') ADVANCE(3427);
      if (lookahead == '~') ADVANCE(3415);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2989);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(2785);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3159);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2860);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(2959);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3211);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3079);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3165);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3194);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3172);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2811);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3213);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3179);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2923);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(695)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('E' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 696:
      if (lookahead == '!') ADVANCE(890);
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '#') ADVANCE(3428);
      if (lookahead == '%') ADVANCE(3422);
      if (lookahead == '&') ADVANCE(3425);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == ',') ADVANCE(2228);
      if (lookahead == '-') ADVANCE(3412);
      if (lookahead == '/') ADVANCE(3421);
      if (lookahead == ':') ADVANCE(889);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '<') ADVANCE(3429);
      if (lookahead == '=') ADVANCE(2401);
      if (lookahead == '>') ADVANCE(3433);
      if (lookahead == '\\') ADVANCE(488);
      if (lookahead == '^') ADVANCE(3419);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == '|') ADVANCE(3427);
      if (lookahead == '~') ADVANCE(3415);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2989);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3196);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2812);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3115);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(2959);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3211);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3079);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3165);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3194);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2868);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2811);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3179);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2923);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(696)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('B' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 697:
      if (lookahead == '!') ADVANCE(890);
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '#') ADVANCE(3428);
      if (lookahead == '%') ADVANCE(3422);
      if (lookahead == '&') ADVANCE(3425);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == ',') ADVANCE(2228);
      if (lookahead == '-') ADVANCE(3412);
      if (lookahead == '/') ADVANCE(3421);
      if (lookahead == ':') ADVANCE(889);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '<') ADVANCE(3429);
      if (lookahead == '=') ADVANCE(2401);
      if (lookahead == '>') ADVANCE(3433);
      if (lookahead == '\\') ADVANCE(544);
      if (lookahead == '^') ADVANCE(3419);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == '|') ADVANCE(3427);
      if (lookahead == '~') ADVANCE(3415);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2991);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(2785);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(2710);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2808);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3357);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(2959);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3211);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3050);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2685);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3142);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3143);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(2892);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2674);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2788);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2826);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3197);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3179);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3154);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2976);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(697)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('H' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 698:
      if (lookahead == '!') ADVANCE(890);
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '#') ADVANCE(3428);
      if (lookahead == '%') ADVANCE(3422);
      if (lookahead == '&') ADVANCE(3425);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == ',') ADVANCE(2228);
      if (lookahead == '-') ADVANCE(3412);
      if (lookahead == '/') ADVANCE(3421);
      if (lookahead == ':') ADVANCE(889);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '<') ADVANCE(3429);
      if (lookahead == '=') ADVANCE(2401);
      if (lookahead == '>') ADVANCE(3433);
      if (lookahead == '\\') ADVANCE(540);
      if (lookahead == '^') ADVANCE(3419);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == '|') ADVANCE(3427);
      if (lookahead == '~') ADVANCE(3415);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2989);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(2785);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(2710);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2786);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3357);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(2959);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3211);
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(2668);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3050);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2685);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3142);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3145);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(2890);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2674);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2788);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2826);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3197);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3179);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3154);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2976);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(698)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('J' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 699:
      if (lookahead == '!') ADVANCE(890);
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '#') ADVANCE(3428);
      if (lookahead == '%') ADVANCE(3422);
      if (lookahead == '&') ADVANCE(3425);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == ',') ADVANCE(2228);
      if (lookahead == '-') ADVANCE(3412);
      if (lookahead == '/') ADVANCE(3421);
      if (lookahead == ':') ADVANCE(889);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '<') ADVANCE(3429);
      if (lookahead == '=') ADVANCE(2401);
      if (lookahead == '>') ADVANCE(3433);
      if (lookahead == '\\') ADVANCE(548);
      if (lookahead == '^') ADVANCE(3419);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == '|') ADVANCE(3427);
      if (lookahead == '~') ADVANCE(3415);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2989);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(2785);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(2710);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2786);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3357);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(2956);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3186);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3048);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(3141);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2684);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3142);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3145);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(2890);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2674);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2787);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2826);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3197);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3179);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3154);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2927);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(699)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('H' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 700:
      if (lookahead == '!') ADVANCE(890);
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '#') ADVANCE(3428);
      if (lookahead == '%') ADVANCE(3422);
      if (lookahead == '&') ADVANCE(3425);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == ',') ADVANCE(2228);
      if (lookahead == '-') ADVANCE(3412);
      if (lookahead == '/') ADVANCE(3421);
      if (lookahead == ':') ADVANCE(889);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '<') ADVANCE(3429);
      if (lookahead == '=') ADVANCE(2401);
      if (lookahead == '>') ADVANCE(3433);
      if (lookahead == '\\') ADVANCE(558);
      if (lookahead == '^') ADVANCE(3419);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == '|') ADVANCE(3427);
      if (lookahead == '~') ADVANCE(3415);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2989);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(2785);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(2710);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2786);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3357);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(2958);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3186);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3049);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(3141);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2684);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3142);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3145);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(2890);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2674);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2787);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2826);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3197);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3179);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3154);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2927);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(700)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('H' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 701:
      if (lookahead == '!') ADVANCE(890);
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '#') ADVANCE(3428);
      if (lookahead == '%') ADVANCE(3422);
      if (lookahead == '&') ADVANCE(3425);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == ',') ADVANCE(2228);
      if (lookahead == '-') ADVANCE(3412);
      if (lookahead == '/') ADVANCE(3421);
      if (lookahead == ':') ADVANCE(889);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '<') ADVANCE(3429);
      if (lookahead == '=') ADVANCE(2401);
      if (lookahead == '>') ADVANCE(3433);
      if (lookahead == '\\') ADVANCE(560);
      if (lookahead == '^') ADVANCE(3419);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == '|') ADVANCE(3427);
      if (lookahead == '~') ADVANCE(3415);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2991);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(2785);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(2710);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2808);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3357);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(2959);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3211);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3050);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2685);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3142);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3143);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(2892);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2674);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2788);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2826);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3197);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3179);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3154);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2982);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(701)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('H' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 702:
      if (lookahead == '!') ADVANCE(890);
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '#') ADVANCE(3428);
      if (lookahead == '%') ADVANCE(3422);
      if (lookahead == '&') ADVANCE(3425);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == ',') ADVANCE(2228);
      if (lookahead == '-') ADVANCE(3412);
      if (lookahead == '/') ADVANCE(3421);
      if (lookahead == ':') ADVANCE(889);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '<') ADVANCE(3429);
      if (lookahead == '=') ADVANCE(2401);
      if (lookahead == '>') ADVANCE(3433);
      if (lookahead == '\\') ADVANCE(550);
      if (lookahead == '^') ADVANCE(3419);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == '|') ADVANCE(3427);
      if (lookahead == '~') ADVANCE(3415);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2989);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(2785);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(2710);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2786);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3357);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(2959);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3211);
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(2668);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3050);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2685);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3142);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3145);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(2890);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2674);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2788);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2826);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3197);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3179);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3154);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2982);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(702)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('J' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 703:
      if (lookahead == '!') ADVANCE(890);
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '#') ADVANCE(3428);
      if (lookahead == '%') ADVANCE(3422);
      if (lookahead == '&') ADVANCE(3425);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == ',') ADVANCE(2228);
      if (lookahead == '-') ADVANCE(3412);
      if (lookahead == '/') ADVANCE(3421);
      if (lookahead == ':') ADVANCE(889);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '<') ADVANCE(3429);
      if (lookahead == '=') ADVANCE(2401);
      if (lookahead == '>') ADVANCE(3433);
      if (lookahead == '\\') ADVANCE(568);
      if (lookahead == '^') ADVANCE(3419);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == '|') ADVANCE(3427);
      if (lookahead == '~') ADVANCE(3415);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2989);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(2785);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(2710);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2786);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3357);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(2957);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3211);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3050);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2686);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3142);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3145);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3194);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2674);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2788);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2826);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3197);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3179);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3154);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2925);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(703)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('H' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 704:
      if (lookahead == '!') ADVANCE(890);
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '#') ADVANCE(3428);
      if (lookahead == '%') ADVANCE(3422);
      if (lookahead == '&') ADVANCE(3425);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == ',') ADVANCE(2228);
      if (lookahead == '-') ADVANCE(3412);
      if (lookahead == '/') ADVANCE(3421);
      if (lookahead == ':') ADVANCE(889);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '<') ADVANCE(3429);
      if (lookahead == '=') ADVANCE(2401);
      if (lookahead == '>') ADVANCE(3433);
      if (lookahead == '\\') ADVANCE(570);
      if (lookahead == '^') ADVANCE(3419);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == '|') ADVANCE(3427);
      if (lookahead == '~') ADVANCE(3415);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2989);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(2785);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(2710);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2786);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3357);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(2959);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3211);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3050);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2686);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3142);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3145);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3194);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2674);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2788);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2826);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3197);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3179);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3154);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2925);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(704)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('H' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 705:
      if (lookahead == '!') ADVANCE(890);
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '#') ADVANCE(3428);
      if (lookahead == '%') ADVANCE(3422);
      if (lookahead == '&') ADVANCE(3425);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == ',') ADVANCE(2228);
      if (lookahead == '-') ADVANCE(3412);
      if (lookahead == '/') ADVANCE(3421);
      if (lookahead == ':') ADVANCE(889);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '<') ADVANCE(3429);
      if (lookahead == '=') ADVANCE(2401);
      if (lookahead == '>') ADVANCE(3433);
      if (lookahead == '\\') ADVANCE(554);
      if (lookahead == '^') ADVANCE(3419);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == '|') ADVANCE(3427);
      if (lookahead == '~') ADVANCE(3415);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2989);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(2785);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3159);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2860);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(2956);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3186);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3076);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(3141);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2831);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3165);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(2890);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2937);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2811);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3213);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3179);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2927);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(705)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('E' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 706:
      if (lookahead == '!') ADVANCE(890);
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '#') ADVANCE(3428);
      if (lookahead == '%') ADVANCE(3422);
      if (lookahead == '&') ADVANCE(3425);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == ',') ADVANCE(2228);
      if (lookahead == '-') ADVANCE(3412);
      if (lookahead == '/') ADVANCE(3421);
      if (lookahead == ':') ADVANCE(889);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '<') ADVANCE(3429);
      if (lookahead == '=') ADVANCE(2401);
      if (lookahead == '>') ADVANCE(3433);
      if (lookahead == '\\') ADVANCE(564);
      if (lookahead == '^') ADVANCE(3419);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == '|') ADVANCE(3427);
      if (lookahead == '~') ADVANCE(3415);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2989);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(2785);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3159);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2860);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(2958);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3186);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3078);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(3141);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2831);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3165);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(2890);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2937);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2811);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3213);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3179);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2927);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(706)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('E' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 707:
      if (lookahead == '!') ADVANCE(890);
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '#') ADVANCE(3428);
      if (lookahead == '%') ADVANCE(3422);
      if (lookahead == '&') ADVANCE(3425);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == ',') ADVANCE(2228);
      if (lookahead == '-') ADVANCE(3412);
      if (lookahead == '/') ADVANCE(3421);
      if (lookahead == ':') ADVANCE(889);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '<') ADVANCE(3429);
      if (lookahead == '=') ADVANCE(2401);
      if (lookahead == '>') ADVANCE(3433);
      if (lookahead == '\\') ADVANCE(556);
      if (lookahead == '^') ADVANCE(3419);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == '|') ADVANCE(3427);
      if (lookahead == '~') ADVANCE(3415);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2989);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3196);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2812);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3115);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(2956);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3186);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3076);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(3141);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2831);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3165);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(2890);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2867);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2811);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3179);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2927);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(707)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('B' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 708:
      if (lookahead == '!') ADVANCE(890);
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '#') ADVANCE(3428);
      if (lookahead == '%') ADVANCE(3422);
      if (lookahead == '&') ADVANCE(3425);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == ',') ADVANCE(2228);
      if (lookahead == '-') ADVANCE(3412);
      if (lookahead == '/') ADVANCE(3421);
      if (lookahead == ':') ADVANCE(889);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '<') ADVANCE(3429);
      if (lookahead == '=') ADVANCE(2401);
      if (lookahead == '>') ADVANCE(3433);
      if (lookahead == '\\') ADVANCE(566);
      if (lookahead == '^') ADVANCE(3419);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == '|') ADVANCE(3427);
      if (lookahead == '~') ADVANCE(3415);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2989);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3196);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2812);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3115);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(2958);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3186);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3078);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(3141);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2831);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3165);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(2890);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2867);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2811);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3179);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2927);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(708)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('B' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 709:
      if (lookahead == '!') ADVANCE(890);
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '#') ADVANCE(3428);
      if (lookahead == '%') ADVANCE(3422);
      if (lookahead == '&') ADVANCE(3425);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == ',') ADVANCE(2228);
      if (lookahead == '-') ADVANCE(3412);
      if (lookahead == '/') ADVANCE(3421);
      if (lookahead == ':') ADVANCE(889);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '<') ADVANCE(3429);
      if (lookahead == '=') ADVANCE(2401);
      if (lookahead == '>') ADVANCE(3433);
      if (lookahead == '\\') ADVANCE(572);
      if (lookahead == '^') ADVANCE(3419);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == '|') ADVANCE(3427);
      if (lookahead == '~') ADVANCE(3415);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2989);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(2785);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(2710);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2786);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3357);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(2956);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3186);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3048);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(3141);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2684);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3142);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3145);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(2890);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2674);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2787);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2826);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3197);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3179);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3154);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2925);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(709)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('H' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 710:
      if (lookahead == '!') ADVANCE(890);
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '#') ADVANCE(3428);
      if (lookahead == '%') ADVANCE(3422);
      if (lookahead == '&') ADVANCE(3425);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == ',') ADVANCE(2228);
      if (lookahead == '-') ADVANCE(3412);
      if (lookahead == '/') ADVANCE(3421);
      if (lookahead == ':') ADVANCE(889);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '<') ADVANCE(3429);
      if (lookahead == '=') ADVANCE(2401);
      if (lookahead == '>') ADVANCE(3433);
      if (lookahead == '\\') ADVANCE(578);
      if (lookahead == '^') ADVANCE(3419);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == '|') ADVANCE(3427);
      if (lookahead == '~') ADVANCE(3415);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2989);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(2785);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(2710);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2786);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3357);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(2958);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3186);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3049);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(3141);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2684);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3142);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3145);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(2890);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2674);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2787);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2826);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3197);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3179);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3154);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2925);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(710)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('H' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 711:
      if (lookahead == '!') ADVANCE(890);
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '#') ADVANCE(3428);
      if (lookahead == '%') ADVANCE(3422);
      if (lookahead == '&') ADVANCE(3425);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == ',') ADVANCE(2228);
      if (lookahead == '-') ADVANCE(3412);
      if (lookahead == '/') ADVANCE(3421);
      if (lookahead == ':') ADVANCE(889);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '<') ADVANCE(3429);
      if (lookahead == '=') ADVANCE(2401);
      if (lookahead == '>') ADVANCE(3433);
      if (lookahead == '\\') ADVANCE(574);
      if (lookahead == '^') ADVANCE(3419);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == '|') ADVANCE(3427);
      if (lookahead == '~') ADVANCE(3415);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2989);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(2785);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3159);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2860);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(2956);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3186);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3076);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(3141);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2831);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3165);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(2890);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2937);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2811);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3213);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3179);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2925);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(711)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('E' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 712:
      if (lookahead == '!') ADVANCE(890);
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '#') ADVANCE(3428);
      if (lookahead == '%') ADVANCE(3422);
      if (lookahead == '&') ADVANCE(3425);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == ',') ADVANCE(2228);
      if (lookahead == '-') ADVANCE(3412);
      if (lookahead == '/') ADVANCE(3421);
      if (lookahead == ':') ADVANCE(889);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '<') ADVANCE(3429);
      if (lookahead == '=') ADVANCE(2401);
      if (lookahead == '>') ADVANCE(3433);
      if (lookahead == '\\') ADVANCE(580);
      if (lookahead == '^') ADVANCE(3419);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == '|') ADVANCE(3427);
      if (lookahead == '~') ADVANCE(3415);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2989);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(2785);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3159);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2860);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(2958);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3186);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3078);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(3141);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2831);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3165);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(2890);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2937);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2811);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3213);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3179);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2925);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(712)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('E' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 713:
      if (lookahead == '!') ADVANCE(890);
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '#') ADVANCE(3428);
      if (lookahead == '%') ADVANCE(3422);
      if (lookahead == '&') ADVANCE(3425);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == ',') ADVANCE(2228);
      if (lookahead == '-') ADVANCE(3412);
      if (lookahead == '/') ADVANCE(3421);
      if (lookahead == ':') ADVANCE(889);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '<') ADVANCE(3429);
      if (lookahead == '=') ADVANCE(2401);
      if (lookahead == '>') ADVANCE(3433);
      if (lookahead == '\\') ADVANCE(576);
      if (lookahead == '^') ADVANCE(3419);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == '|') ADVANCE(3427);
      if (lookahead == '~') ADVANCE(3415);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2989);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3196);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2812);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3115);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(2956);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3186);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3076);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(3141);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2831);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3165);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(2890);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2867);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2811);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3179);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2925);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(713)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('B' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 714:
      if (lookahead == '!') ADVANCE(890);
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '#') ADVANCE(3428);
      if (lookahead == '%') ADVANCE(3422);
      if (lookahead == '&') ADVANCE(3425);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == ',') ADVANCE(2228);
      if (lookahead == '-') ADVANCE(3412);
      if (lookahead == '/') ADVANCE(3421);
      if (lookahead == ':') ADVANCE(889);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '<') ADVANCE(3429);
      if (lookahead == '=') ADVANCE(2401);
      if (lookahead == '>') ADVANCE(3433);
      if (lookahead == '\\') ADVANCE(582);
      if (lookahead == '^') ADVANCE(3419);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == '|') ADVANCE(3427);
      if (lookahead == '~') ADVANCE(3415);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2989);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3196);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2812);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3115);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(2958);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3186);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3078);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(3141);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2831);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3165);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(2890);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2867);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2811);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3179);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2925);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(714)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('B' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 715:
      if (lookahead == '!') ADVANCE(890);
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '#') ADVANCE(3428);
      if (lookahead == '%') ADVANCE(3422);
      if (lookahead == '&') ADVANCE(3425);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == '-') ADVANCE(3412);
      if (lookahead == '/') ADVANCE(3421);
      if (lookahead == ':') ADVANCE(889);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '<') ADVANCE(3429);
      if (lookahead == '=') ADVANCE(2401);
      if (lookahead == '>') ADVANCE(3433);
      if (lookahead == 'C') ADVANCE(2634);
      if (lookahead == '\\') ADVANCE(16);
      if (lookahead == '^') ADVANCE(3419);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == 'c') ADVANCE(2709);
      if (lookahead == '|') ADVANCE(3427);
      if (lookahead == '~') ADVANCE(3415);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2990);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(2785);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2805);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3357);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(2959);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3211);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3050);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2686);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3142);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3144);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3194);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2672);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2806);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2826);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3197);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3118);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3154);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2982);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(715)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('H' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 716:
      if (lookahead == '!') ADVANCE(890);
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '#') ADVANCE(3428);
      if (lookahead == '%') ADVANCE(3422);
      if (lookahead == '&') ADVANCE(3425);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == '-') ADVANCE(3412);
      if (lookahead == '/') ADVANCE(3421);
      if (lookahead == ':') ADVANCE(889);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '<') ADVANCE(3429);
      if (lookahead == '=') ADVANCE(2401);
      if (lookahead == '>') ADVANCE(3433);
      if (lookahead == 'C') ADVANCE(2634);
      if (lookahead == '\\') ADVANCE(34);
      if (lookahead == '^') ADVANCE(3419);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == 'c') ADVANCE(2709);
      if (lookahead == '|') ADVANCE(3427);
      if (lookahead == '~') ADVANCE(3415);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2990);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(2785);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2805);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3357);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3211);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3050);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2686);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3142);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3144);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3194);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2672);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2806);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2826);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3197);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3118);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3154);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2976);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(716)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('F' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 717:
      if (lookahead == '!') ADVANCE(890);
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '#') ADVANCE(3428);
      if (lookahead == '%') ADVANCE(3422);
      if (lookahead == '&') ADVANCE(3425);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == '-') ADVANCE(3412);
      if (lookahead == '/') ADVANCE(3421);
      if (lookahead == ':') ADVANCE(889);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '<') ADVANCE(3429);
      if (lookahead == '=') ADVANCE(2401);
      if (lookahead == '>') ADVANCE(3433);
      if (lookahead == 'C') ADVANCE(2634);
      if (lookahead == '\\') ADVANCE(456);
      if (lookahead == '^') ADVANCE(3419);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == 'c') ADVANCE(2709);
      if (lookahead == '|') ADVANCE(3427);
      if (lookahead == '~') ADVANCE(3415);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2990);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(2785);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2805);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3357);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(2959);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3211);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3050);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2686);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3142);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3144);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3194);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2672);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2806);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2826);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3197);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3118);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3154);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2976);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(717)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('H' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 718:
      if (lookahead == '!') ADVANCE(890);
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '#') ADVANCE(3428);
      if (lookahead == '%') ADVANCE(3422);
      if (lookahead == '&') ADVANCE(3425);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == '-') ADVANCE(3412);
      if (lookahead == '/') ADVANCE(3421);
      if (lookahead == ':') ADVANCE(889);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '<') ADVANCE(3429);
      if (lookahead == '=') ADVANCE(2401);
      if (lookahead == '>') ADVANCE(3433);
      if (lookahead == '\\') ADVANCE(36);
      if (lookahead == '^') ADVANCE(3419);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == '|') ADVANCE(3427);
      if (lookahead == '~') ADVANCE(3415);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2989);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(2785);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(2710);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2786);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3357);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(2959);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3186);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3050);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2685);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3142);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3145);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(2890);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2674);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2788);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2826);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3197);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3179);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3154);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2979);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(718)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('H' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 719:
      if (lookahead == '!') ADVANCE(890);
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '#') ADVANCE(3428);
      if (lookahead == '%') ADVANCE(3422);
      if (lookahead == '&') ADVANCE(3425);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == '-') ADVANCE(3412);
      if (lookahead == '/') ADVANCE(3421);
      if (lookahead == ':') ADVANCE(889);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '<') ADVANCE(3429);
      if (lookahead == '=') ADVANCE(2401);
      if (lookahead == '>') ADVANCE(3433);
      if (lookahead == '\\') ADVANCE(324);
      if (lookahead == '^') ADVANCE(3419);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == '|') ADVANCE(3427);
      if (lookahead == '~') ADVANCE(3415);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2989);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(2785);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(2710);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2786);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3357);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(2959);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3211);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3050);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2685);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3142);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3145);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(2890);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2674);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2788);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2826);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3197);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3179);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3154);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2979);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(719)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('H' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 720:
      if (lookahead == '!') ADVANCE(890);
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '#') ADVANCE(3428);
      if (lookahead == '%') ADVANCE(3422);
      if (lookahead == '&') ADVANCE(3425);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == '-') ADVANCE(3412);
      if (lookahead == '/') ADVANCE(3421);
      if (lookahead == ':') ADVANCE(889);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '<') ADVANCE(3429);
      if (lookahead == '=') ADVANCE(2401);
      if (lookahead == '>') ADVANCE(3433);
      if (lookahead == '\\') ADVANCE(384);
      if (lookahead == '^') ADVANCE(3419);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == '|') ADVANCE(3427);
      if (lookahead == '~') ADVANCE(3415);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2989);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(2785);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(2709);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2786);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3357);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(2959);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3211);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3050);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2686);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3142);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3144);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3194);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2674);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2788);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2826);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3197);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3179);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3154);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2982);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(720)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('H' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 721:
      if (lookahead == '!') ADVANCE(890);
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '#') ADVANCE(3428);
      if (lookahead == '%') ADVANCE(3422);
      if (lookahead == '&') ADVANCE(3425);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == '-') ADVANCE(3412);
      if (lookahead == '/') ADVANCE(3421);
      if (lookahead == ':') ADVANCE(889);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '<') ADVANCE(3429);
      if (lookahead == '=') ADVANCE(2401);
      if (lookahead == '>') ADVANCE(3433);
      if (lookahead == '\\') ADVANCE(416);
      if (lookahead == '^') ADVANCE(3419);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == '|') ADVANCE(3427);
      if (lookahead == '~') ADVANCE(3415);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2989);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(2785);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(2710);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2809);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3357);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(2959);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3211);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3051);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2686);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3142);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3145);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3194);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2674);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2788);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2826);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3197);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3179);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3154);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2982);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(721)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('H' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 722:
      if (lookahead == '!') ADVANCE(890);
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '#') ADVANCE(3428);
      if (lookahead == '%') ADVANCE(3422);
      if (lookahead == '&') ADVANCE(3425);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == '-') ADVANCE(3412);
      if (lookahead == '/') ADVANCE(3421);
      if (lookahead == ':') ADVANCE(889);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '<') ADVANCE(3429);
      if (lookahead == '=') ADVANCE(2401);
      if (lookahead == '>') ADVANCE(3433);
      if (lookahead == '\\') ADVANCE(48);
      if (lookahead == '^') ADVANCE(3419);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == '|') ADVANCE(3427);
      if (lookahead == '~') ADVANCE(3415);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2989);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(2785);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(2710);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2786);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3357);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3186);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3050);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2685);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3142);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3145);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(2890);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2674);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2788);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2826);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3197);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3179);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3154);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2939);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(722)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('F' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 723:
      if (lookahead == '!') ADVANCE(890);
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '#') ADVANCE(3428);
      if (lookahead == '%') ADVANCE(3422);
      if (lookahead == '&') ADVANCE(3425);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == '-') ADVANCE(3412);
      if (lookahead == '/') ADVANCE(3421);
      if (lookahead == ':') ADVANCE(889);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '<') ADVANCE(3429);
      if (lookahead == '=') ADVANCE(2401);
      if (lookahead == '>') ADVANCE(3433);
      if (lookahead == '\\') ADVANCE(332);
      if (lookahead == '^') ADVANCE(3419);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == '|') ADVANCE(3427);
      if (lookahead == '~') ADVANCE(3415);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2989);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(2785);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(2710);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2786);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3357);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3211);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3050);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2685);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3142);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3145);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(2890);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2674);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2788);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2826);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3197);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3179);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3154);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2939);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(723)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('F' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 724:
      if (lookahead == '!') ADVANCE(890);
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '#') ADVANCE(3428);
      if (lookahead == '%') ADVANCE(3422);
      if (lookahead == '&') ADVANCE(3425);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == '-') ADVANCE(3412);
      if (lookahead == '/') ADVANCE(3421);
      if (lookahead == ':') ADVANCE(889);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '<') ADVANCE(3429);
      if (lookahead == '=') ADVANCE(2401);
      if (lookahead == '>') ADVANCE(3433);
      if (lookahead == '\\') ADVANCE(388);
      if (lookahead == '^') ADVANCE(3419);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == '|') ADVANCE(3427);
      if (lookahead == '~') ADVANCE(3415);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2989);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(2785);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(2709);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2786);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3357);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3211);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3050);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2686);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3142);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3144);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3194);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2674);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2788);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2826);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3197);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3179);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3154);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2976);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(724)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('F' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 725:
      if (lookahead == '!') ADVANCE(890);
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '#') ADVANCE(3428);
      if (lookahead == '%') ADVANCE(3422);
      if (lookahead == '&') ADVANCE(3425);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == '-') ADVANCE(3412);
      if (lookahead == '/') ADVANCE(3421);
      if (lookahead == ':') ADVANCE(889);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '<') ADVANCE(3429);
      if (lookahead == '=') ADVANCE(2401);
      if (lookahead == '>') ADVANCE(3433);
      if (lookahead == '\\') ADVANCE(418);
      if (lookahead == '^') ADVANCE(3419);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == '|') ADVANCE(3427);
      if (lookahead == '~') ADVANCE(3415);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2989);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(2785);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(2710);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2809);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3357);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3211);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3051);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2686);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3142);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3145);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3194);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2674);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2788);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2826);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3197);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3179);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3154);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2976);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(725)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('F' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 726:
      if (lookahead == '!') ADVANCE(890);
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '#') ADVANCE(3428);
      if (lookahead == '%') ADVANCE(3422);
      if (lookahead == '&') ADVANCE(3425);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == '-') ADVANCE(3412);
      if (lookahead == '/') ADVANCE(3421);
      if (lookahead == ':') ADVANCE(889);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '<') ADVANCE(3429);
      if (lookahead == '=') ADVANCE(2401);
      if (lookahead == '>') ADVANCE(3433);
      if (lookahead == '\\') ADVANCE(462);
      if (lookahead == '^') ADVANCE(3419);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == '|') ADVANCE(3427);
      if (lookahead == '~') ADVANCE(3415);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2989);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(2785);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(2710);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2786);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3357);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(2959);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3186);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3050);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2685);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3142);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3145);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(2890);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2674);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2788);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2826);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3197);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3179);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3154);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2939);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(726)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('H' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 727:
      if (lookahead == '!') ADVANCE(890);
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '#') ADVANCE(3428);
      if (lookahead == '%') ADVANCE(3422);
      if (lookahead == '&') ADVANCE(3425);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == '-') ADVANCE(3412);
      if (lookahead == '/') ADVANCE(3421);
      if (lookahead == ':') ADVANCE(889);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '<') ADVANCE(3429);
      if (lookahead == '=') ADVANCE(2401);
      if (lookahead == '>') ADVANCE(3433);
      if (lookahead == '\\') ADVANCE(504);
      if (lookahead == '^') ADVANCE(3419);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == '|') ADVANCE(3427);
      if (lookahead == '~') ADVANCE(3415);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2989);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(2785);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(2710);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2786);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3357);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(2959);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3211);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3050);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2685);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3142);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3145);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(2890);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2674);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2788);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2826);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3197);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3179);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3154);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2939);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(727)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('H' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 728:
      if (lookahead == '!') ADVANCE(890);
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '#') ADVANCE(3428);
      if (lookahead == '%') ADVANCE(3422);
      if (lookahead == '&') ADVANCE(3425);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == '-') ADVANCE(3412);
      if (lookahead == '/') ADVANCE(3421);
      if (lookahead == ':') ADVANCE(889);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '<') ADVANCE(3429);
      if (lookahead == '=') ADVANCE(2401);
      if (lookahead == '>') ADVANCE(3433);
      if (lookahead == '\\') ADVANCE(518);
      if (lookahead == '^') ADVANCE(3419);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == '|') ADVANCE(3427);
      if (lookahead == '~') ADVANCE(3415);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2989);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(2785);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(2709);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2786);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3357);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(2959);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3211);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3050);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2686);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3142);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3144);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3194);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2674);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2788);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2826);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3197);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3179);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3154);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2976);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(728)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('H' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 729:
      if (lookahead == '!') ADVANCE(890);
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '#') ADVANCE(3428);
      if (lookahead == '%') ADVANCE(3422);
      if (lookahead == '&') ADVANCE(3425);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == '-') ADVANCE(3412);
      if (lookahead == '/') ADVANCE(3421);
      if (lookahead == ':') ADVANCE(889);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '<') ADVANCE(3429);
      if (lookahead == '=') ADVANCE(2401);
      if (lookahead == '>') ADVANCE(3433);
      if (lookahead == '\\') ADVANCE(528);
      if (lookahead == '^') ADVANCE(3419);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == '|') ADVANCE(3427);
      if (lookahead == '~') ADVANCE(3415);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2989);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(2785);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(2710);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2809);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3357);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(2959);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3211);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3051);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2686);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3142);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3145);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3194);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2674);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2788);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2826);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3197);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3179);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3154);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2976);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(729)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('H' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 730:
      if (lookahead == '!') ADVANCE(890);
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '#') ADVANCE(3428);
      if (lookahead == '%') ADVANCE(3422);
      if (lookahead == '&') ADVANCE(3425);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == '-') ADVANCE(3412);
      if (lookahead == '/') ADVANCE(3421);
      if (lookahead == ':') ADVANCE(889);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '<') ADVANCE(3429);
      if (lookahead == '=') ADVANCE(2401);
      if (lookahead == '>') ADVANCE(3433);
      if (lookahead == '\\') ADVANCE(468);
      if (lookahead == '^') ADVANCE(3419);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == '|') ADVANCE(3427);
      if (lookahead == '~') ADVANCE(3415);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2989);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(2785);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(2710);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2786);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3357);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3186);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3050);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2685);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3142);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3145);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(2890);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2674);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2788);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2826);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3197);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3179);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3154);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2976);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(730)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('F' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 731:
      if (lookahead == '!') ADVANCE(890);
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '#') ADVANCE(3428);
      if (lookahead == '%') ADVANCE(3422);
      if (lookahead == '&') ADVANCE(3425);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == '-') ADVANCE(3412);
      if (lookahead == '/') ADVANCE(3421);
      if (lookahead == ':') ADVANCE(889);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '<') ADVANCE(3429);
      if (lookahead == '=') ADVANCE(2401);
      if (lookahead == '>') ADVANCE(3433);
      if (lookahead == '\\') ADVANCE(506);
      if (lookahead == '^') ADVANCE(3419);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == '|') ADVANCE(3427);
      if (lookahead == '~') ADVANCE(3415);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2989);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(2785);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(2710);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2786);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3357);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3211);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3050);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2685);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3142);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3145);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(2890);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2674);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2788);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2826);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3197);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3179);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3154);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2976);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(731)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('F' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 732:
      if (lookahead == '!') ADVANCE(890);
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '#') ADVANCE(3428);
      if (lookahead == '%') ADVANCE(3422);
      if (lookahead == '&') ADVANCE(3425);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == '-') ADVANCE(3412);
      if (lookahead == '/') ADVANCE(3421);
      if (lookahead == ':') ADVANCE(889);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '<') ADVANCE(3429);
      if (lookahead == '=') ADVANCE(2401);
      if (lookahead == '>') ADVANCE(3433);
      if (lookahead == '\\') ADVANCE(542);
      if (lookahead == '^') ADVANCE(3419);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == '|') ADVANCE(3427);
      if (lookahead == '~') ADVANCE(3415);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2989);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(2785);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(2710);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2786);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3357);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(2959);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3186);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3050);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2685);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3142);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3145);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(2890);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2674);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2788);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2826);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3197);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3179);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3154);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2976);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(732)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('H' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 733:
      if (lookahead == '!') ADVANCE(890);
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '#') ADVANCE(3428);
      if (lookahead == '%') ADVANCE(3422);
      if (lookahead == '&') ADVANCE(3425);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == '-') ADVANCE(3412);
      if (lookahead == '/') ADVANCE(3421);
      if (lookahead == ':') ADVANCE(889);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '<') ADVANCE(3429);
      if (lookahead == '=') ADVANCE(2401);
      if (lookahead == '>') ADVANCE(3433);
      if (lookahead == '\\') ADVANCE(546);
      if (lookahead == '^') ADVANCE(3419);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == '|') ADVANCE(3427);
      if (lookahead == '~') ADVANCE(3415);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2989);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(2785);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(2710);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2786);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3357);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(2959);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3211);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3050);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2685);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3142);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3145);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(2890);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2674);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2788);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2826);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3197);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3179);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3154);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2976);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(733)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('H' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 734:
      if (lookahead == '!') ADVANCE(890);
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '#') ADVANCE(3428);
      if (lookahead == '%') ADVANCE(3422);
      if (lookahead == '&') ADVANCE(3425);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == '-') ADVANCE(3412);
      if (lookahead == '/') ADVANCE(3421);
      if (lookahead == ':') ADVANCE(889);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '<') ADVANCE(3429);
      if (lookahead == '=') ADVANCE(2401);
      if (lookahead == '>') ADVANCE(3433);
      if (lookahead == '\\') ADVANCE(552);
      if (lookahead == '^') ADVANCE(3419);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == '|') ADVANCE(3427);
      if (lookahead == '~') ADVANCE(3415);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2989);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(2785);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(2710);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2786);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3357);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(2959);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3186);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3050);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2685);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3142);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3145);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(2890);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2674);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2788);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2826);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3197);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3179);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3154);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2982);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(734)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('H' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 735:
      if (lookahead == '!') ADVANCE(890);
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '#') ADVANCE(3428);
      if (lookahead == '%') ADVANCE(3422);
      if (lookahead == '&') ADVANCE(3425);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == '-') ADVANCE(3412);
      if (lookahead == '/') ADVANCE(3421);
      if (lookahead == ':') ADVANCE(889);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '<') ADVANCE(3429);
      if (lookahead == '=') ADVANCE(2401);
      if (lookahead == '>') ADVANCE(3433);
      if (lookahead == '\\') ADVANCE(562);
      if (lookahead == '^') ADVANCE(3419);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == '|') ADVANCE(3427);
      if (lookahead == '~') ADVANCE(3415);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2989);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(2785);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(2710);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2786);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3357);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(2959);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3211);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3050);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2685);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3142);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3145);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(2890);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2674);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2788);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2826);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3197);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3179);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3154);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2982);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(735)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('H' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 736:
      if (lookahead == '!') ADVANCE(890);
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '#') ADVANCE(3428);
      if (lookahead == '%') ADVANCE(3422);
      if (lookahead == '&') ADVANCE(3425);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == '-') ADVANCE(3412);
      if (lookahead == '/') ADVANCE(3421);
      if (lookahead == ':') ADVANCE(889);
      if (lookahead == '<') ADVANCE(3429);
      if (lookahead == '=') ADVANCE(2401);
      if (lookahead == '>') ADVANCE(3433);
      if (lookahead == '\\') SKIP(236)
      if (lookahead == '^') ADVANCE(3419);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == '|') ADVANCE(3427);
      if (lookahead == '~') ADVANCE(3415);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3112);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(2959);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3089);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3165);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3081);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2974);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(736)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('B' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 737:
      if (lookahead == '!') ADVANCE(890);
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '#') ADVANCE(3428);
      if (lookahead == '%') ADVANCE(3422);
      if (lookahead == '&') ADVANCE(3425);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == '-') ADVANCE(3412);
      if (lookahead == '/') ADVANCE(3421);
      if (lookahead == ':') ADVANCE(889);
      if (lookahead == '<') ADVANCE(3429);
      if (lookahead == '=') ADVANCE(2401);
      if (lookahead == '>') ADVANCE(3433);
      if (lookahead == '\\') SKIP(244)
      if (lookahead == '^') ADVANCE(3419);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == '|') ADVANCE(3427);
      if (lookahead == '~') ADVANCE(3415);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3112);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(2959);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3089);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3165);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3081);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(737)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('B' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 738:
      if (lookahead == '!') ADVANCE(890);
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '#') ADVANCE(3428);
      if (lookahead == '%') ADVANCE(3422);
      if (lookahead == '&') ADVANCE(3425);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == '-') ADVANCE(3412);
      if (lookahead == '/') ADVANCE(3421);
      if (lookahead == ':') ADVANCE(889);
      if (lookahead == '<') ADVANCE(3429);
      if (lookahead == '=') ADVANCE(2401);
      if (lookahead == '>') ADVANCE(3433);
      if (lookahead == '\\') SKIP(252)
      if (lookahead == '^') ADVANCE(3419);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == '|') ADVANCE(3427);
      if (lookahead == '~') ADVANCE(3415);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3112);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3089);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3165);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3081);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(738)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('B' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 739:
      if (lookahead == '!') ADVANCE(890);
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '#') ADVANCE(3428);
      if (lookahead == '%') ADVANCE(3422);
      if (lookahead == '&') ADVANCE(3425);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == '-') ADVANCE(3412);
      if (lookahead == '/') ADVANCE(3421);
      if (lookahead == ':') ADVANCE(889);
      if (lookahead == '<') ADVANCE(3429);
      if (lookahead == '=') ADVANCE(2401);
      if (lookahead == '>') ADVANCE(3433);
      if (lookahead == '\\') ADVANCE(132);
      if (lookahead == '^') ADVANCE(3419);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == '|') ADVANCE(3427);
      if (lookahead == '~') ADVANCE(3415);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2992);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(2785);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3196);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2812);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3356);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(2955);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3211);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3079);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3165);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3194);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(3223);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2868);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2811);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3179);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2969);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(739)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('H' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 740:
      if (lookahead == '!') ADVANCE(890);
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '#') ADVANCE(3428);
      if (lookahead == '%') ADVANCE(3422);
      if (lookahead == '&') ADVANCE(3425);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == '-') ADVANCE(3412);
      if (lookahead == '/') ADVANCE(3421);
      if (lookahead == ':') ADVANCE(889);
      if (lookahead == '<') ADVANCE(3429);
      if (lookahead == '=') ADVANCE(2401);
      if (lookahead == '>') ADVANCE(3433);
      if (lookahead == '\\') ADVANCE(350);
      if (lookahead == '^') ADVANCE(3419);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == '|') ADVANCE(3427);
      if (lookahead == '~') ADVANCE(3415);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2992);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(2785);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3196);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2812);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3356);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3173);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3211);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3079);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3165);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3194);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(3223);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2868);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2811);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3179);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2971);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(740)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('H' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 741:
      if (lookahead == '!') ADVANCE(890);
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '#') ADVANCE(3428);
      if (lookahead == '%') ADVANCE(3422);
      if (lookahead == '&') ADVANCE(3425);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == '-') ADVANCE(3412);
      if (lookahead == '/') ADVANCE(3421);
      if (lookahead == ':') ADVANCE(889);
      if (lookahead == '<') ADVANCE(3429);
      if (lookahead == '=') ADVANCE(2401);
      if (lookahead == '>') ADVANCE(3433);
      if (lookahead == '\\') ADVANCE(490);
      if (lookahead == '^') ADVANCE(3419);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == '|') ADVANCE(3427);
      if (lookahead == '~') ADVANCE(3415);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2992);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(2785);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3196);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2812);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3356);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(2955);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3211);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3079);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3165);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3194);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(3223);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2868);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2811);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3179);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2971);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(741)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('H' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 742:
      if (lookahead == '!') ADVANCE(890);
      if (lookahead == '#') ADVANCE(3428);
      if (lookahead == '%') ADVANCE(3422);
      if (lookahead == '&') ADVANCE(3425);
      if (lookahead == '\'') ADVANCE(3387);
      if (lookahead == ')') ADVANCE(2237);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == ',') ADVANCE(2228);
      if (lookahead == '-') ADVANCE(3412);
      if (lookahead == '.') ADVANCE(2029);
      if (lookahead == '/') ADVANCE(3421);
      if (lookahead == ':') ADVANCE(889);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '<') ADVANCE(3429);
      if (lookahead == '=') ADVANCE(2401);
      if (lookahead == '>') ADVANCE(3433);
      if (lookahead == 'C') ADVANCE(911);
      if (lookahead == '\\') ADVANCE(68);
      if (lookahead == ']') ADVANCE(3404);
      if (lookahead == '^') ADVANCE(3419);
      if (lookahead == 'c') ADVANCE(1400);
      if (lookahead == '|') ADVANCE(3427);
      if (lookahead == '~') ADVANCE(3415);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1517);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(1277);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(1217);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1673);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(1452);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(1769);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1634);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(1707);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1256);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1739);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1355);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(1804);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(1224);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(1220);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(1826);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(1679);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(986);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(1410);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(742)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(2612);
      END_STATE();
    case 743:
      if (lookahead == '!') ADVANCE(890);
      if (lookahead == '#') ADVANCE(3428);
      if (lookahead == '%') ADVANCE(3422);
      if (lookahead == '&') ADVANCE(3425);
      if (lookahead == '(') ADVANCE(2236);
      if (lookahead == ')') ADVANCE(2237);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == ',') ADVANCE(2228);
      if (lookahead == '-') ADVANCE(3412);
      if (lookahead == '.') ADVANCE(3386);
      if (lookahead == '/') ADVANCE(3421);
      if (lookahead == ':') ADVANCE(889);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '<') ADVANCE(3429);
      if (lookahead == '=') ADVANCE(2401);
      if (lookahead == '>') ADVANCE(3433);
      if (lookahead == 'C') ADVANCE(908);
      if (lookahead == '[') ADVANCE(3403);
      if (lookahead == '\\') ADVANCE(4);
      if (lookahead == '^') ADVANCE(3419);
      if (lookahead == 'c') ADVANCE(974);
      if (lookahead == '|') ADVANCE(3427);
      if (lookahead == '~') ADVANCE(3415);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1581);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(1276);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(1217);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1674);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(1243);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(1769);
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(937);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1631);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(1707);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1027);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1709);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1350);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(1804);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(1218);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(1089);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(1030);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(1679);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(1024);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(1415);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(743)
      END_STATE();
    case 744:
      if (lookahead == '!') ADVANCE(890);
      if (lookahead == '#') ADVANCE(3428);
      if (lookahead == '%') ADVANCE(3422);
      if (lookahead == '&') ADVANCE(3425);
      if (lookahead == '(') ADVANCE(2236);
      if (lookahead == ')') ADVANCE(2237);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == ',') ADVANCE(2228);
      if (lookahead == '-') ADVANCE(3412);
      if (lookahead == '.') ADVANCE(3386);
      if (lookahead == '/') ADVANCE(3421);
      if (lookahead == ':') ADVANCE(889);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '<') ADVANCE(3429);
      if (lookahead == '=') ADVANCE(2401);
      if (lookahead == '>') ADVANCE(3433);
      if (lookahead == 'C') ADVANCE(911);
      if (lookahead == '[') ADVANCE(3403);
      if (lookahead == '\\') ADVANCE(88);
      if (lookahead == '^') ADVANCE(3419);
      if (lookahead == 'c') ADVANCE(1400);
      if (lookahead == '|') ADVANCE(3427);
      if (lookahead == '~') ADVANCE(3415);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1581);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(1276);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(1217);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1673);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(1244);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(1838);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1631);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1435);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1739);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1352);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(1804);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(953);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(1220);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(1826);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(1679);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(1413);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(744)
      END_STATE();
    case 745:
      if (lookahead == '!') ADVANCE(890);
      if (lookahead == '#') ADVANCE(3428);
      if (lookahead == '%') ADVANCE(3422);
      if (lookahead == '&') ADVANCE(3425);
      if (lookahead == '(') ADVANCE(2236);
      if (lookahead == ')') ADVANCE(2237);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == ',') ADVANCE(2228);
      if (lookahead == '-') ADVANCE(3412);
      if (lookahead == '.') ADVANCE(3386);
      if (lookahead == '/') ADVANCE(3421);
      if (lookahead == ':') ADVANCE(889);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '<') ADVANCE(3429);
      if (lookahead == '=') ADVANCE(2401);
      if (lookahead == '>') ADVANCE(3433);
      if (lookahead == 'C') ADVANCE(911);
      if (lookahead == '[') ADVANCE(3403);
      if (lookahead == '\\') ADVANCE(120);
      if (lookahead == '^') ADVANCE(3419);
      if (lookahead == 'c') ADVANCE(1400);
      if (lookahead == '|') ADVANCE(3427);
      if (lookahead == '~') ADVANCE(3415);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1581);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(1276);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(1238);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1673);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(1449);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(1809);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1637);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1739);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1609);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(1804);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(1227);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(1220);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(1826);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(1679);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(1458);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(745)
      END_STATE();
    case 746:
      if (lookahead == '!') ADVANCE(890);
      if (lookahead == '#') ADVANCE(3428);
      if (lookahead == '%') ADVANCE(3422);
      if (lookahead == '&') ADVANCE(3425);
      if (lookahead == '(') ADVANCE(2236);
      if (lookahead == ')') ADVANCE(2237);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == ',') ADVANCE(2228);
      if (lookahead == '-') ADVANCE(3412);
      if (lookahead == '.') ADVANCE(3386);
      if (lookahead == '/') ADVANCE(3421);
      if (lookahead == ':') ADVANCE(889);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '<') ADVANCE(3429);
      if (lookahead == '=') ADVANCE(2401);
      if (lookahead == '>') ADVANCE(3433);
      if (lookahead == '[') ADVANCE(3403);
      if (lookahead == '\\') ADVANCE(64);
      if (lookahead == '^') ADVANCE(3419);
      if (lookahead == '|') ADVANCE(3427);
      if (lookahead == '~') ADVANCE(3415);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1579);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(1276);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(1399);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(1223);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(935);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(1451);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(1769);
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(937);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1634);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(1707);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1256);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1740);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1354);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(1792);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(1309);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(1222);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(1032);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(1679);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(984);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(1416);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(746)
      END_STATE();
    case 747:
      if (lookahead == '!') ADVANCE(890);
      if (lookahead == '#') ADVANCE(3428);
      if (lookahead == '%') ADVANCE(3422);
      if (lookahead == '&') ADVANCE(3425);
      if (lookahead == '(') ADVANCE(2236);
      if (lookahead == ')') ADVANCE(2237);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == ',') ADVANCE(2228);
      if (lookahead == '-') ADVANCE(3412);
      if (lookahead == '.') ADVANCE(3386);
      if (lookahead == '/') ADVANCE(3421);
      if (lookahead == ':') ADVANCE(889);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '<') ADVANCE(3429);
      if (lookahead == '=') ADVANCE(2401);
      if (lookahead == '>') ADVANCE(3433);
      if (lookahead == '[') ADVANCE(3403);
      if (lookahead == '\\') ADVANCE(96);
      if (lookahead == '^') ADVANCE(3419);
      if (lookahead == '|') ADVANCE(3427);
      if (lookahead == '~') ADVANCE(3415);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1580);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(1276);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(1725);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(1233);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1673);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(1244);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(1838);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1631);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1435);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1740);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1356);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(955);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(1220);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(1826);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(1754);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(1413);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(747)
      END_STATE();
    case 748:
      if (lookahead == '!') ADVANCE(890);
      if (lookahead == '#') ADVANCE(3428);
      if (lookahead == '%') ADVANCE(3422);
      if (lookahead == '&') ADVANCE(3425);
      if (lookahead == '(') ADVANCE(2236);
      if (lookahead == ')') ADVANCE(2237);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == ',') ADVANCE(2228);
      if (lookahead == '-') ADVANCE(3412);
      if (lookahead == '.') ADVANCE(3386);
      if (lookahead == '/') ADVANCE(3421);
      if (lookahead == ':') ADVANCE(889);
      if (lookahead == '<') ADVANCE(3429);
      if (lookahead == '=') ADVANCE(2401);
      if (lookahead == '>') ADVANCE(3433);
      if (lookahead == 'C') ADVANCE(912);
      if (lookahead == '[') ADVANCE(3403);
      if (lookahead == '\\') SKIP(110)
      if (lookahead == ']') ADVANCE(3404);
      if (lookahead == '^') ADVANCE(3419);
      if (lookahead == 'c') ADVANCE(1398);
      if (lookahead == '|') ADVANCE(3427);
      if (lookahead == '~') ADVANCE(3415);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1670);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(1234);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1568);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(1450);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1636);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1739);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1609);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(1824);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(1325);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(1312);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(1401);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(1678);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(984);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(1403);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(748)
      END_STATE();
    case 749:
      if (lookahead == '!') ADVANCE(890);
      if (lookahead == '#') ADVANCE(3428);
      if (lookahead == '%') ADVANCE(3422);
      if (lookahead == '&') ADVANCE(3425);
      if (lookahead == '(') ADVANCE(2236);
      if (lookahead == ')') ADVANCE(2237);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == ',') ADVANCE(2228);
      if (lookahead == '-') ADVANCE(3412);
      if (lookahead == '.') ADVANCE(3386);
      if (lookahead == '/') ADVANCE(3421);
      if (lookahead == ':') ADVANCE(889);
      if (lookahead == '<') ADVANCE(3429);
      if (lookahead == '=') ADVANCE(2401);
      if (lookahead == '>') ADVANCE(3433);
      if (lookahead == '[') ADVANCE(3403);
      if (lookahead == '\\') SKIP(122)
      if (lookahead == ']') ADVANCE(3404);
      if (lookahead == '^') ADVANCE(3419);
      if (lookahead == '|') ADVANCE(3427);
      if (lookahead == '~') ADVANCE(3415);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1669);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(1301);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1568);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(1242);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(1805);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1636);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1435);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1740);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1356);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(1832);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(957);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(1401);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(984);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(1403);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(749)
      END_STATE();
    case 750:
      if (lookahead == '!') ADVANCE(890);
      if (lookahead == '#') ADVANCE(3428);
      if (lookahead == '%') ADVANCE(3422);
      if (lookahead == '&') ADVANCE(3425);
      if (lookahead == '(') ADVANCE(2236);
      if (lookahead == ')') ADVANCE(2237);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == ',') ADVANCE(2228);
      if (lookahead == '-') ADVANCE(3412);
      if (lookahead == '.') ADVANCE(3386);
      if (lookahead == '/') ADVANCE(3421);
      if (lookahead == ':') ADVANCE(889);
      if (lookahead == '<') ADVANCE(3429);
      if (lookahead == '=') ADVANCE(2401);
      if (lookahead == '>') ADVANCE(3433);
      if (lookahead == '[') ADVANCE(3403);
      if (lookahead == '\\') SKIP(206)
      if (lookahead == '^') ADVANCE(3419);
      if (lookahead == '|') ADVANCE(3427);
      if (lookahead == '~') ADVANCE(3415);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1671);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(1449);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(1828);
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(937);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1636);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1435);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1738);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1355);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(1829);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(984);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(1469);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(750)
      END_STATE();
    case 751:
      if (lookahead == '!') ADVANCE(890);
      if (lookahead == '#') ADVANCE(3428);
      if (lookahead == '%') ADVANCE(3422);
      if (lookahead == '&') ADVANCE(3425);
      if (lookahead == '(') ADVANCE(2236);
      if (lookahead == ')') ADVANCE(2237);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == ',') ADVANCE(2228);
      if (lookahead == '-') ADVANCE(3412);
      if (lookahead == '.') ADVANCE(3386);
      if (lookahead == '/') ADVANCE(3421);
      if (lookahead == ':') ADVANCE(889);
      if (lookahead == '<') ADVANCE(3429);
      if (lookahead == '=') ADVANCE(2401);
      if (lookahead == '>') ADVANCE(3433);
      if (lookahead == '[') ADVANCE(3403);
      if (lookahead == '\\') SKIP(212)
      if (lookahead == '^') ADVANCE(3419);
      if (lookahead == '|') ADVANCE(3427);
      if (lookahead == '~') ADVANCE(3415);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1671);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(1449);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(1805);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1636);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1738);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1781);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(1829);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(957);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(984);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(1456);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(751)
      END_STATE();
    case 752:
      if (lookahead == '!') ADVANCE(890);
      if (lookahead == '#') ADVANCE(3428);
      if (lookahead == '%') ADVANCE(3422);
      if (lookahead == '&') ADVANCE(3425);
      if (lookahead == '(') ADVANCE(2236);
      if (lookahead == ')') ADVANCE(2237);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == ',') ADVANCE(2228);
      if (lookahead == '-') ADVANCE(3412);
      if (lookahead == '.') ADVANCE(3386);
      if (lookahead == '/') ADVANCE(3421);
      if (lookahead == ':') ADVANCE(889);
      if (lookahead == '<') ADVANCE(3429);
      if (lookahead == '=') ADVANCE(2401);
      if (lookahead == '>') ADVANCE(3433);
      if (lookahead == '[') ADVANCE(3403);
      if (lookahead == '\\') SKIP(220)
      if (lookahead == '^') ADVANCE(3419);
      if (lookahead == '|') ADVANCE(3427);
      if (lookahead == '~') ADVANCE(3415);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1671);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(1339);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(1449);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1640);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1738);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1784);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(1829);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(984);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(1456);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(752)
      END_STATE();
    case 753:
      if (lookahead == '!') ADVANCE(890);
      if (lookahead == '#') ADVANCE(3428);
      if (lookahead == '%') ADVANCE(3422);
      if (lookahead == '&') ADVANCE(3425);
      if (lookahead == '(') ADVANCE(2236);
      if (lookahead == ')') ADVANCE(2237);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == ',') ADVANCE(2228);
      if (lookahead == '-') ADVANCE(3412);
      if (lookahead == '.') ADVANCE(3385);
      if (lookahead == '/') ADVANCE(3421);
      if (lookahead == ':') ADVANCE(889);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '<') ADVANCE(3429);
      if (lookahead == '=') ADVANCE(2401);
      if (lookahead == '>') ADVANCE(3433);
      if (lookahead == 'C') ADVANCE(910);
      if (lookahead == '[') ADVANCE(3403);
      if (lookahead == '\\') ADVANCE(58);
      if (lookahead == '^') ADVANCE(3419);
      if (lookahead == 'c') ADVANCE(1036);
      if (lookahead == '|') ADVANCE(3427);
      if (lookahead == '~') ADVANCE(3415);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1581);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(1276);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(1217);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1673);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(1245);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(1838);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1631);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1436);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1739);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1351);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(1792);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(956);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(942);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(1826);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(1643);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(984);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(1411);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(753)
      END_STATE();
    case 754:
      if (lookahead == '!') ADVANCE(890);
      if (lookahead == '#') ADVANCE(3428);
      if (lookahead == '%') ADVANCE(3422);
      if (lookahead == '&') ADVANCE(3425);
      if (lookahead == '(') ADVANCE(2236);
      if (lookahead == ')') ADVANCE(2237);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == '-') ADVANCE(3412);
      if (lookahead == '.') ADVANCE(3386);
      if (lookahead == '/') ADVANCE(3421);
      if (lookahead == ':') ADVANCE(889);
      if (lookahead == '<') ADVANCE(3429);
      if (lookahead == '=') ADVANCE(2401);
      if (lookahead == '>') ADVANCE(3433);
      if (lookahead == '[') ADVANCE(3403);
      if (lookahead == '\\') SKIP(176)
      if (lookahead == '^') ADVANCE(3419);
      if (lookahead == '|') ADVANCE(3427);
      if (lookahead == '~') ADVANCE(3415);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1671);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(1452);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(1828);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1639);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(1707);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1256);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1738);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1355);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(1829);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(1419);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(984);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(1416);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(754)
      END_STATE();
    case 755:
      if (lookahead == '!') ADVANCE(890);
      if (lookahead == '#') ADVANCE(3428);
      if (lookahead == '%') ADVANCE(3422);
      if (lookahead == '&') ADVANCE(3425);
      if (lookahead == '(') ADVANCE(2236);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == ',') ADVANCE(2228);
      if (lookahead == '-') ADVANCE(3412);
      if (lookahead == '.') ADVANCE(3386);
      if (lookahead == '/') ADVANCE(3421);
      if (lookahead == ':') ADVANCE(889);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '<') ADVANCE(3429);
      if (lookahead == '=') ADVANCE(2401);
      if (lookahead == '>') ADVANCE(3433);
      if (lookahead == '[') ADVANCE(3403);
      if (lookahead == '\\') ADVANCE(78);
      if (lookahead == '^') ADVANCE(3419);
      if (lookahead == '|') ADVANCE(3427);
      if (lookahead == '~') ADVANCE(3415);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1580);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(1276);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(1725);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(1233);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1673);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(1244);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(1809);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1631);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1435);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1740);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1356);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(1829);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(1311);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(1220);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(1826);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(1754);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(984);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(1411);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(755)
      END_STATE();
    case 756:
      if (lookahead == '!') ADVANCE(890);
      if (lookahead == '#') ADVANCE(3428);
      if (lookahead == '%') ADVANCE(3422);
      if (lookahead == '&') ADVANCE(3425);
      if (lookahead == '(') ADVANCE(2236);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == ',') ADVANCE(2228);
      if (lookahead == '-') ADVANCE(3412);
      if (lookahead == '.') ADVANCE(3386);
      if (lookahead == '/') ADVANCE(3421);
      if (lookahead == ':') ADVANCE(889);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '<') ADVANCE(3429);
      if (lookahead == '=') ADVANCE(2401);
      if (lookahead == '>') ADVANCE(3433);
      if (lookahead == '[') ADVANCE(3403);
      if (lookahead == '\\') ADVANCE(90);
      if (lookahead == '^') ADVANCE(3419);
      if (lookahead == '|') ADVANCE(3427);
      if (lookahead == '~') ADVANCE(3415);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1582);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(1276);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(1725);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(1223);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1673);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(1449);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(1769);
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(937);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1631);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1435);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1738);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1355);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(1829);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(1311);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(1220);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(1826);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(1754);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(984);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(1469);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(756)
      END_STATE();
    case 757:
      if (lookahead == '!') ADVANCE(890);
      if (lookahead == '#') ADVANCE(3428);
      if (lookahead == '%') ADVANCE(3422);
      if (lookahead == '&') ADVANCE(3425);
      if (lookahead == '(') ADVANCE(2236);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == '-') ADVANCE(3412);
      if (lookahead == '.') ADVANCE(3386);
      if (lookahead == '/') ADVANCE(3421);
      if (lookahead == ':') ADVANCE(889);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '<') ADVANCE(3429);
      if (lookahead == '=') ADVANCE(2401);
      if (lookahead == '>') ADVANCE(3433);
      if (lookahead == '[') ADVANCE(3403);
      if (lookahead == '\\') ADVANCE(82);
      if (lookahead == '^') ADVANCE(3419);
      if (lookahead == '|') ADVANCE(3427);
      if (lookahead == '~') ADVANCE(3415);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1582);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(1276);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(1725);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(1223);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1673);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(1452);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(1769);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1634);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(1707);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1256);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1738);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1355);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(1310);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(1220);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(1826);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(1754);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(1414);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(757)
      END_STATE();
    case 758:
      if (lookahead == '!') ADVANCE(890);
      if (lookahead == '#') ADVANCE(3428);
      if (lookahead == '%') ADVANCE(3422);
      if (lookahead == '&') ADVANCE(3425);
      if (lookahead == '(') ADVANCE(2236);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == '-') ADVANCE(3412);
      if (lookahead == '.') ADVANCE(3385);
      if (lookahead == '/') ADVANCE(3421);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '<') ADVANCE(3429);
      if (lookahead == '=') ADVANCE(2401);
      if (lookahead == '>') ADVANCE(3433);
      if (lookahead == '[') ADVANCE(3403);
      if (lookahead == '\\') ADVANCE(116);
      if (lookahead == '^') ADVANCE(3419);
      if (lookahead == '|') ADVANCE(3427);
      if (lookahead == '~') ADVANCE(3415);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1582);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(1276);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(1725);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(1239);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1673);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(1809);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1637);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1738);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1783);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(1829);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(1311);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(1220);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(1826);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(1754);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(984);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(1456);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(758)
      END_STATE();
    case 759:
      if (lookahead == '!') ADVANCE(890);
      if (lookahead == '#') ADVANCE(3428);
      if (lookahead == '%') ADVANCE(3422);
      if (lookahead == '&') ADVANCE(3425);
      if (lookahead == ')') ADVANCE(2237);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == ',') ADVANCE(2228);
      if (lookahead == '-') ADVANCE(3412);
      if (lookahead == '/') ADVANCE(3421);
      if (lookahead == ':') ADVANCE(889);
      if (lookahead == '<') ADVANCE(3429);
      if (lookahead == '=') ADVANCE(2401);
      if (lookahead == '>') ADVANCE(3433);
      if (lookahead == 'C') ADVANCE(912);
      if (lookahead == '\\') SKIP(194)
      if (lookahead == '^') ADVANCE(3419);
      if (lookahead == 'c') ADVANCE(1398);
      if (lookahead == '|') ADVANCE(3427);
      if (lookahead == '~') ADVANCE(3415);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1670);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(1234);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(1449);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1636);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1739);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1784);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(1804);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(1325);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(1678);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(1460);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(759)
      END_STATE();
    case 760:
      if (lookahead == '!') ADVANCE(890);
      if (lookahead == '#') ADVANCE(3428);
      if (lookahead == '%') ADVANCE(3422);
      if (lookahead == '&') ADVANCE(3425);
      if (lookahead == ')') ADVANCE(2237);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == ',') ADVANCE(2228);
      if (lookahead == '-') ADVANCE(3412);
      if (lookahead == '/') ADVANCE(3421);
      if (lookahead == ':') ADVANCE(889);
      if (lookahead == '<') ADVANCE(3429);
      if (lookahead == '=') ADVANCE(2401);
      if (lookahead == '>') ADVANCE(3433);
      if (lookahead == '\\') SKIP(138)
      if (lookahead == ']') ADVANCE(3404);
      if (lookahead == '^') ADVANCE(3419);
      if (lookahead == '|') ADVANCE(3427);
      if (lookahead == '~') ADVANCE(3415);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1669);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(1301);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1568);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(1242);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(1805);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1636);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1435);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1740);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1356);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(1835);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(957);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(1401);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(1404);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(760)
      END_STATE();
    case 761:
      if (lookahead == '!') ADVANCE(890);
      if (lookahead == '#') ADVANCE(3428);
      if (lookahead == '%') ADVANCE(3422);
      if (lookahead == '&') ADVANCE(3425);
      if (lookahead == ')') ADVANCE(2237);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == ',') ADVANCE(2228);
      if (lookahead == '-') ADVANCE(3412);
      if (lookahead == '/') ADVANCE(3421);
      if (lookahead == ':') ADVANCE(889);
      if (lookahead == '<') ADVANCE(3429);
      if (lookahead == '=') ADVANCE(2401);
      if (lookahead == '>') ADVANCE(3433);
      if (lookahead == '\\') SKIP(214)
      if (lookahead == '^') ADVANCE(3419);
      if (lookahead == '|') ADVANCE(3427);
      if (lookahead == '~') ADVANCE(3415);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1671);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(1449);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(1828);
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(937);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1636);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1435);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1738);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1355);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(1477);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(761)
      END_STATE();
    case 762:
      if (lookahead == '!') ADVANCE(890);
      if (lookahead == '#') ADVANCE(3428);
      if (lookahead == '%') ADVANCE(3422);
      if (lookahead == '&') ADVANCE(3425);
      if (lookahead == ')') ADVANCE(2237);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == ',') ADVANCE(2228);
      if (lookahead == '-') ADVANCE(3412);
      if (lookahead == '/') ADVANCE(3421);
      if (lookahead == ':') ADVANCE(889);
      if (lookahead == '<') ADVANCE(3429);
      if (lookahead == '=') ADVANCE(2401);
      if (lookahead == '>') ADVANCE(3433);
      if (lookahead == '\\') SKIP(234)
      if (lookahead == '^') ADVANCE(3419);
      if (lookahead == '|') ADVANCE(3427);
      if (lookahead == '~') ADVANCE(3415);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1671);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(1449);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(1805);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1636);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1738);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1781);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(957);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(1460);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(762)
      END_STATE();
    case 763:
      if (lookahead == '!') ADVANCE(890);
      if (lookahead == '#') ADVANCE(3428);
      if (lookahead == '%') ADVANCE(3422);
      if (lookahead == '&') ADVANCE(3425);
      if (lookahead == ')') ADVANCE(2237);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == ',') ADVANCE(2228);
      if (lookahead == '-') ADVANCE(3412);
      if (lookahead == '/') ADVANCE(3421);
      if (lookahead == ':') ADVANCE(889);
      if (lookahead == '<') ADVANCE(3429);
      if (lookahead == '=') ADVANCE(2401);
      if (lookahead == '>') ADVANCE(3433);
      if (lookahead == '\\') SKIP(240)
      if (lookahead == '^') ADVANCE(3419);
      if (lookahead == '|') ADVANCE(3427);
      if (lookahead == '~') ADVANCE(3415);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1671);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(1339);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(1449);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1640);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1738);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1784);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(1460);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(763)
      END_STATE();
    case 764:
      if (lookahead == '!') ADVANCE(890);
      if (lookahead == '#') ADVANCE(3428);
      if (lookahead == '%') ADVANCE(3422);
      if (lookahead == '&') ADVANCE(3425);
      if (lookahead == ')') ADVANCE(2237);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == '-') ADVANCE(3412);
      if (lookahead == '/') ADVANCE(3421);
      if (lookahead == ':') ADVANCE(889);
      if (lookahead == '<') ADVANCE(3429);
      if (lookahead == '=') ADVANCE(2401);
      if (lookahead == '>') ADVANCE(3433);
      if (lookahead == '\\') SKIP(192)
      if (lookahead == '^') ADVANCE(3419);
      if (lookahead == '|') ADVANCE(3427);
      if (lookahead == '~') ADVANCE(3415);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1671);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(1452);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(1828);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1639);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(1707);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1256);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1738);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1355);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(1419);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(1418);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(764)
      END_STATE();
    case 765:
      if (lookahead == '!') ADVANCE(890);
      if (lookahead == '#') ADVANCE(3428);
      if (lookahead == '%') ADVANCE(3422);
      if (lookahead == '&') ADVANCE(3425);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == ',') ADVANCE(2228);
      if (lookahead == '-') ADVANCE(3412);
      if (lookahead == '/') ADVANCE(3421);
      if (lookahead == ':') ADVANCE(889);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '<') ADVANCE(3429);
      if (lookahead == '=') ADVANCE(2401);
      if (lookahead == '>') ADVANCE(3433);
      if (lookahead == '\\') ADVANCE(86);
      if (lookahead == '^') ADVANCE(3419);
      if (lookahead == '|') ADVANCE(3427);
      if (lookahead == '~') ADVANCE(3415);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1580);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(1276);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(1725);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(1233);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1673);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(1244);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(1809);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1631);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1435);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1740);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1356);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(1311);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(1220);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(1826);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(1754);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(1412);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(765)
      END_STATE();
    case 766:
      if (lookahead == '!') ADVANCE(890);
      if (lookahead == '#') ADVANCE(3428);
      if (lookahead == '%') ADVANCE(3422);
      if (lookahead == '&') ADVANCE(3425);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == ',') ADVANCE(2228);
      if (lookahead == '-') ADVANCE(3412);
      if (lookahead == '/') ADVANCE(3421);
      if (lookahead == ':') ADVANCE(889);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '<') ADVANCE(3429);
      if (lookahead == '=') ADVANCE(2401);
      if (lookahead == '>') ADVANCE(3433);
      if (lookahead == '\\') ADVANCE(94);
      if (lookahead == '^') ADVANCE(3419);
      if (lookahead == '|') ADVANCE(3427);
      if (lookahead == '~') ADVANCE(3415);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1582);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(1276);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(1725);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(1223);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1673);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(1449);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(1769);
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(937);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1631);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1435);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1738);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1355);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(1311);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(1220);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(1826);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(1754);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(1420);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(766)
      END_STATE();
    case 767:
      if (lookahead == '!') ADVANCE(890);
      if (lookahead == '#') ADVANCE(3428);
      if (lookahead == '%') ADVANCE(3422);
      if (lookahead == '&') ADVANCE(3425);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == ',') ADVANCE(2228);
      if (lookahead == '-') ADVANCE(3412);
      if (lookahead == '/') ADVANCE(3421);
      if (lookahead == ':') ADVANCE(889);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '<') ADVANCE(3429);
      if (lookahead == '=') ADVANCE(2401);
      if (lookahead == '>') ADVANCE(3433);
      if (lookahead == '\\') ADVANCE(344);
      if (lookahead == '^') ADVANCE(3419);
      if (lookahead == '|') ADVANCE(3427);
      if (lookahead == '~') ADVANCE(3415);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1580);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(1276);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(1725);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(1233);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1673);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(1449);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(1809);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1631);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1435);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1740);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1356);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(1311);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(1220);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(1826);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(1754);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(1459);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(767)
      END_STATE();
    case 768:
      if (lookahead == '!') ADVANCE(890);
      if (lookahead == '#') ADVANCE(3428);
      if (lookahead == '%') ADVANCE(3422);
      if (lookahead == '&') ADVANCE(3425);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == ',') ADVANCE(2228);
      if (lookahead == '-') ADVANCE(3412);
      if (lookahead == '/') ADVANCE(3421);
      if (lookahead == ':') ADVANCE(889);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '<') ADVANCE(3429);
      if (lookahead == '=') ADVANCE(2401);
      if (lookahead == '>') ADVANCE(3433);
      if (lookahead == '\\') ADVANCE(480);
      if (lookahead == '^') ADVANCE(3419);
      if (lookahead == '|') ADVANCE(3427);
      if (lookahead == '~') ADVANCE(3415);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1582);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(1276);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(1725);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(1223);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1673);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(1449);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(1769);
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(937);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1631);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1435);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1738);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1355);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(1311);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(1220);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(1826);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(1754);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(1473);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(768)
      END_STATE();
    case 769:
      if (lookahead == '!') ADVANCE(890);
      if (lookahead == '#') ADVANCE(3428);
      if (lookahead == '%') ADVANCE(3422);
      if (lookahead == '&') ADVANCE(3425);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == '-') ADVANCE(3412);
      if (lookahead == '/') ADVANCE(3421);
      if (lookahead == ':') ADVANCE(889);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '<') ADVANCE(3429);
      if (lookahead == '=') ADVANCE(2401);
      if (lookahead == '>') ADVANCE(3433);
      if (lookahead == 'C') ADVANCE(911);
      if (lookahead == '\\') ADVANCE(72);
      if (lookahead == '^') ADVANCE(3419);
      if (lookahead == 'c') ADVANCE(1400);
      if (lookahead == '|') ADVANCE(3427);
      if (lookahead == '~') ADVANCE(3415);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1581);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(1276);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(1217);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1673);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(1452);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(1769);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1634);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(1707);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1256);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1739);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1355);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(1804);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(1226);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(1220);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(1826);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(1679);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(1417);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(769)
      END_STATE();
    case 770:
      if (lookahead == '!') ADVANCE(890);
      if (lookahead == '#') ADVANCE(3428);
      if (lookahead == '%') ADVANCE(3422);
      if (lookahead == '&') ADVANCE(3425);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == '-') ADVANCE(3412);
      if (lookahead == '/') ADVANCE(3421);
      if (lookahead == ':') ADVANCE(889);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '<') ADVANCE(3429);
      if (lookahead == '=') ADVANCE(2401);
      if (lookahead == '>') ADVANCE(3433);
      if (lookahead == 'C') ADVANCE(911);
      if (lookahead == '\\') ADVANCE(80);
      if (lookahead == '^') ADVANCE(3419);
      if (lookahead == 'c') ADVANCE(1400);
      if (lookahead == '|') ADVANCE(3427);
      if (lookahead == '~') ADVANCE(3415);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1581);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(1276);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(1217);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1673);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(1449);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(1809);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1631);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1739);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1784);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(1804);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(1227);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(1220);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(1826);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(1679);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(1457);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(770)
      END_STATE();
    case 771:
      if (lookahead == '!') ADVANCE(890);
      if (lookahead == '#') ADVANCE(3428);
      if (lookahead == '%') ADVANCE(3422);
      if (lookahead == '&') ADVANCE(3425);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == '-') ADVANCE(3412);
      if (lookahead == '/') ADVANCE(3421);
      if (lookahead == ':') ADVANCE(889);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '<') ADVANCE(3429);
      if (lookahead == '=') ADVANCE(2401);
      if (lookahead == '>') ADVANCE(3433);
      if (lookahead == '\\') ADVANCE(112);
      if (lookahead == '^') ADVANCE(3419);
      if (lookahead == '|') ADVANCE(3427);
      if (lookahead == '~') ADVANCE(3415);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1582);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(1276);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(1725);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(1239);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1673);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(1449);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(1809);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1637);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1738);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1784);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(1311);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(1220);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(1826);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(1754);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(1457);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(771)
      END_STATE();
    case 772:
      if (lookahead == '!') ADVANCE(585);
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '$') ADVANCE(3442);
      if (lookahead == '\'') ADVANCE(3387);
      if (lookahead == '(') ADVANCE(2236);
      if (lookahead == ')') ADVANCE(2237);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == '-') ADVANCE(3411);
      if (lookahead == '.') ADVANCE(2029);
      if (lookahead == '/') ADVANCE(882);
      if (lookahead == '@') ADVANCE(3416);
      if (lookahead == '\\') SKIP(100)
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == '|') ADVANCE(887);
      if (lookahead == '~') ADVANCE(3414);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(2708);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(2657);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3216);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3097);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(3141);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2717);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3164);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(2894);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2938);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3229);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2920);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(772)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(2611);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 773:
      if (lookahead == '!') ADVANCE(585);
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '$') ADVANCE(3442);
      if (lookahead == '\'') ADVANCE(3387);
      if (lookahead == '(') ADVANCE(2236);
      if (lookahead == ')') ADVANCE(2237);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == '-') ADVANCE(3411);
      if (lookahead == '.') ADVANCE(2029);
      if (lookahead == '/') ADVANCE(882);
      if (lookahead == '@') ADVANCE(3416);
      if (lookahead == '\\') SKIP(172)
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == '|') ADVANCE(887);
      if (lookahead == '~') ADVANCE(3414);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(2708);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(2658);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3140);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2718);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3164);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2887);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3229);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2971);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(773)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(2611);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 774:
      if (lookahead == '!') ADVANCE(585);
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '$') ADVANCE(3442);
      if (lookahead == '\'') ADVANCE(3387);
      if (lookahead == '(') ADVANCE(2236);
      if (lookahead == ')') ADVANCE(2237);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == '-') ADVANCE(3411);
      if (lookahead == '.') ADVANCE(2029);
      if (lookahead == '/') ADVANCE(882);
      if (lookahead == '@') ADVANCE(3416);
      if (lookahead == '\\') SKIP(180)
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == '|') ADVANCE(887);
      if (lookahead == '~') ADVANCE(3414);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3038);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(2708);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2978);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(2658);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3140);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2718);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3164);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3229);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(774)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(2611);
      if (('B' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 775:
      if (lookahead == '!') ADVANCE(585);
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '$') ADVANCE(3442);
      if (lookahead == '\'') ADVANCE(3387);
      if (lookahead == '(') ADVANCE(2236);
      if (lookahead == ')') ADVANCE(2237);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == '-') ADVANCE(3411);
      if (lookahead == '.') ADVANCE(2029);
      if (lookahead == '/') ADVANCE(882);
      if (lookahead == '@') ADVANCE(3416);
      if (lookahead == '\\') SKIP(200)
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == '|') ADVANCE(887);
      if (lookahead == '~') ADVANCE(3414);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(2708);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(2658);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3140);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2718);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3164);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3229);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(775)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(2611);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 776:
      if (lookahead == '!') ADVANCE(585);
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '$') ADVANCE(3442);
      if (lookahead == '\'') ADVANCE(3387);
      if (lookahead == '(') ADVANCE(2236);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == '-') ADVANCE(3411);
      if (lookahead == '.') ADVANCE(2029);
      if (lookahead == '/') ADVANCE(882);
      if (lookahead == ':') ADVANCE(2310);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '@') ADVANCE(3416);
      if (lookahead == '\\') ADVANCE(6);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == '|') ADVANCE(887);
      if (lookahead == '~') ADVANCE(3414);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2993);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(2785);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(2667);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2786);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3357);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(2657);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3186);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3047);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(3141);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2659);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3142);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3144);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(2894);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2674);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2787);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2826);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3187);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3179);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3154);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2919);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(776)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(2611);
      if (('H' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 777:
      if (lookahead == '!') ADVANCE(585);
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '$') ADVANCE(3442);
      if (lookahead == '\'') ADVANCE(3387);
      if (lookahead == '(') ADVANCE(2236);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == '-') ADVANCE(3411);
      if (lookahead == '.') ADVANCE(2029);
      if (lookahead == '/') ADVANCE(882);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '@') ADVANCE(3416);
      if (lookahead == '\\') ADVANCE(8);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == '|') ADVANCE(887);
      if (lookahead == '~') ADVANCE(3414);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2993);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(2785);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(2667);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2786);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3357);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(2657);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3186);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3047);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(3141);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2659);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3142);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3144);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(2894);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2674);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2787);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2826);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3187);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3179);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3154);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2925);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(777)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(2611);
      if (('H' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 778:
      if (lookahead == '!') ADVANCE(585);
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '$') ADVANCE(3442);
      if (lookahead == '\'') ADVANCE(3387);
      if (lookahead == '(') ADVANCE(2236);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == '-') ADVANCE(3411);
      if (lookahead == '.') ADVANCE(2029);
      if (lookahead == '/') ADVANCE(882);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '@') ADVANCE(3416);
      if (lookahead == '\\') ADVANCE(50);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == '|') ADVANCE(887);
      if (lookahead == '~') ADVANCE(3414);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2995);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(2785);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(2704);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2860);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(2657);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3186);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3072);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(3141);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2717);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3164);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(2894);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2937);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2811);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3209);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3179);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2919);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(778)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(2611);
      if (('E' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 779:
      if (lookahead == '!') ADVANCE(585);
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '$') ADVANCE(3442);
      if (lookahead == '\'') ADVANCE(3387);
      if (lookahead == '(') ADVANCE(2236);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == '-') ADVANCE(3411);
      if (lookahead == '.') ADVANCE(2029);
      if (lookahead == '/') ADVANCE(882);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '@') ADVANCE(3416);
      if (lookahead == '\\') ADVANCE(52);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == '|') ADVANCE(887);
      if (lookahead == '~') ADVANCE(3414);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2995);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(2705);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2812);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3115);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(2657);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3186);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3072);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(3141);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2717);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3164);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(2894);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2867);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2811);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3229);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3179);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2919);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(779)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(2611);
      if (('B' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 780:
      if (lookahead == '!') ADVANCE(585);
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '$') ADVANCE(3442);
      if (lookahead == '\'') ADVANCE(3387);
      if (lookahead == '(') ADVANCE(2236);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == '-') ADVANCE(3411);
      if (lookahead == '.') ADVANCE(2029);
      if (lookahead == '/') ADVANCE(882);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '@') ADVANCE(3416);
      if (lookahead == '\\') ADVANCE(470);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == '|') ADVANCE(887);
      if (lookahead == '~') ADVANCE(3414);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2995);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(2785);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(2704);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2860);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(2657);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3186);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3072);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(3141);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2717);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3164);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(2894);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2937);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2811);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3209);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3179);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2925);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(780)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(2611);
      if (('E' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 781:
      if (lookahead == '!') ADVANCE(585);
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '$') ADVANCE(3442);
      if (lookahead == '\'') ADVANCE(3387);
      if (lookahead == '(') ADVANCE(2236);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == '-') ADVANCE(3411);
      if (lookahead == '.') ADVANCE(2029);
      if (lookahead == '/') ADVANCE(882);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '@') ADVANCE(3416);
      if (lookahead == '\\') ADVANCE(472);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == '|') ADVANCE(887);
      if (lookahead == '~') ADVANCE(3414);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2995);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(2705);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2812);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3115);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(2657);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3186);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3072);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(3141);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2717);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3164);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(2894);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2867);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2811);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3229);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3179);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2925);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(781)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(2611);
      if (('B' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 782:
      if (lookahead == '!') ADVANCE(585);
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '$') ADVANCE(3442);
      if (lookahead == '\'') ADVANCE(3387);
      if (lookahead == '(') ADVANCE(2236);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == '-') ADVANCE(3411);
      if (lookahead == '.') ADVANCE(2029);
      if (lookahead == '/') ADVANCE(882);
      if (lookahead == '@') ADVANCE(3416);
      if (lookahead == '\\') SKIP(164)
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == '|') ADVANCE(887);
      if (lookahead == '~') ADVANCE(3414);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(2706);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(2658);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3230);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3140);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2718);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3164);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3174);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3229);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(782)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(2611);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 783:
      if (lookahead == '!') ADVANCE(585);
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '$') ADVANCE(3442);
      if (lookahead == '\'') ADVANCE(3387);
      if (lookahead == '(') ADVANCE(2236);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == '-') ADVANCE(3411);
      if (lookahead == '.') ADVANCE(2029);
      if (lookahead == '/') ADVANCE(882);
      if (lookahead == '@') ADVANCE(3416);
      if (lookahead == '\\') SKIP(186)
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == '|') ADVANCE(887);
      if (lookahead == '~') ADVANCE(3414);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(2870);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(2707);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(2658);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3140);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2718);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3164);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3229);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3099);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(783)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(2611);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 784:
      if (lookahead == '!') ADVANCE(585);
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '$') ADVANCE(3442);
      if (lookahead == '\'') ADVANCE(3387);
      if (lookahead == '(') ADVANCE(2236);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == '-') ADVANCE(3411);
      if (lookahead == '.') ADVANCE(2029);
      if (lookahead == '/') ADVANCE(882);
      if (lookahead == '@') ADVANCE(3416);
      if (lookahead == '\\') SKIP(196)
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == '|') ADVANCE(887);
      if (lookahead == '~') ADVANCE(3414);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(2707);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(2658);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3140);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2718);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3164);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3229);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3099);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(784)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(2611);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 785:
      if (lookahead == '!') ADVANCE(585);
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '$') ADVANCE(3442);
      if (lookahead == '\'') ADVANCE(3387);
      if (lookahead == '(') ADVANCE(2236);
      if (lookahead == '*') ADVANCE(3420);
      if (lookahead == '+') ADVANCE(3410);
      if (lookahead == '-') ADVANCE(3411);
      if (lookahead == '.') ADVANCE(2029);
      if (lookahead == '/') ADVANCE(882);
      if (lookahead == '@') ADVANCE(3416);
      if (lookahead == '\\') SKIP(210)
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == '|') ADVANCE(887);
      if (lookahead == '~') ADVANCE(3414);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(2708);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2840);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(2658);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3140);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2718);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3164);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3229);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(785)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(2611);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 786:
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '&') ADVANCE(873);
      if (lookahead == '\'') ADVANCE(3387);
      if (lookahead == '(') ADVANCE(2236);
      if (lookahead == ')') ADVANCE(2237);
      if (lookahead == ',') ADVANCE(2228);
      if (lookahead == '-') ADVANCE(885);
      if (lookahead == '.') ADVANCE(3385);
      if (lookahead == '/') ADVANCE(882);
      if (lookahead == ':') ADVANCE(889);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '=') ADVANCE(2401);
      if (lookahead == '[') ADVANCE(3403);
      if (lookahead == '\\') ADVANCE(38);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == '|') ADVANCE(931);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2993);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(2785);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(2710);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2786);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3357);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3211);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3057);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2686);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3142);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3145);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2674);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2788);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2826);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3197);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3179);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3154);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2976);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(786)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('F' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 787:
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '\'') ADVANCE(3387);
      if (lookahead == '(') ADVANCE(2236);
      if (lookahead == '-') ADVANCE(885);
      if (lookahead == '.') ADVANCE(2029);
      if (lookahead == '/') ADVANCE(882);
      if (lookahead == '\\') SKIP(266)
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2718);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(787)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(2611);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 788:
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '(') ADVANCE(2236);
      if (lookahead == ')') ADVANCE(2237);
      if (lookahead == ',') ADVANCE(2228);
      if (lookahead == '-') ADVANCE(885);
      if (lookahead == '.') ADVANCE(3385);
      if (lookahead == '/') ADVANCE(882);
      if (lookahead == '=') ADVANCE(2401);
      if (lookahead == '[') ADVANCE(3403);
      if (lookahead == '\\') SKIP(258)
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3164);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(3220);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(2691);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2970);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(788)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 789:
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '(') ADVANCE(2236);
      if (lookahead == ')') ADVANCE(2237);
      if (lookahead == ',') ADVANCE(2228);
      if (lookahead == '-') ADVANCE(885);
      if (lookahead == '.') ADVANCE(3385);
      if (lookahead == '/') ADVANCE(882);
      if (lookahead == '\\') SKIP(272)
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(789)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 790:
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '(') ADVANCE(2236);
      if (lookahead == ',') ADVANCE(2228);
      if (lookahead == '-') ADVANCE(885);
      if (lookahead == '/') ADVANCE(882);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '\\') ADVANCE(98);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2993);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(2785);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(2710);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2786);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3357);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3320);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3186);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3056);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(3141);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2684);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3142);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3145);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(2894);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2674);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2787);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2826);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3197);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3179);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3154);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2919);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(790)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('H' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 791:
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '(') ADVANCE(2236);
      if (lookahead == ',') ADVANCE(2228);
      if (lookahead == '-') ADVANCE(885);
      if (lookahead == '/') ADVANCE(882);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '\\') ADVANCE(346);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2993);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(2785);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(2710);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2786);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3357);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3201);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3186);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3054);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(3141);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2684);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3142);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3145);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(2894);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2674);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2787);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2826);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3197);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3179);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3154);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2919);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(791)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('H' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 792:
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '(') ADVANCE(2236);
      if (lookahead == ',') ADVANCE(2228);
      if (lookahead == '-') ADVANCE(885);
      if (lookahead == '/') ADVANCE(882);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '\\') ADVANCE(202);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2993);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(2785);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(2710);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2786);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3357);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3211);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3057);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2686);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3142);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3145);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2674);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2788);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2826);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3197);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3179);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3154);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2925);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(792)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('F' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 793:
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '(') ADVANCE(2236);
      if (lookahead == ',') ADVANCE(2228);
      if (lookahead == '-') ADVANCE(885);
      if (lookahead == '/') ADVANCE(882);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '\\') ADVANCE(482);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2993);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(2785);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(2710);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2786);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3357);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3320);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3186);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3056);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(3141);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2684);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3142);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3145);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(2894);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2674);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2787);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2826);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3197);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3179);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3154);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2925);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(793)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('H' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 794:
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '(') ADVANCE(2236);
      if (lookahead == ',') ADVANCE(2228);
      if (lookahead == '-') ADVANCE(885);
      if (lookahead == '/') ADVANCE(882);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '\\') ADVANCE(512);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2993);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(2785);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(2710);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2786);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3357);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3201);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3186);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3054);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(3141);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2684);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3142);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3145);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(2894);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2674);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2787);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2826);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3197);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3179);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3154);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2925);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(794)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('H' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 795:
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '(') ADVANCE(2236);
      if (lookahead == '-') ADVANCE(885);
      if (lookahead == '.') ADVANCE(3385);
      if (lookahead == '/') ADVANCE(882);
      if (lookahead == ':') ADVANCE(889);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == 'C') ADVANCE(2634);
      if (lookahead == '[') ADVANCE(3403);
      if (lookahead == '\\') ADVANCE(84);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == 'c') ADVANCE(2709);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2994);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(2785);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2805);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3357);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3211);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3057);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2686);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3142);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3144);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2672);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2806);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2826);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3197);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3118);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3154);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2976);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(795)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('F' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 796:
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '(') ADVANCE(2236);
      if (lookahead == '-') ADVANCE(885);
      if (lookahead == '.') ADVANCE(3385);
      if (lookahead == '/') ADVANCE(882);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == 'C') ADVANCE(2634);
      if (lookahead == '[') ADVANCE(3403);
      if (lookahead == '\\') ADVANCE(102);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == 'c') ADVANCE(2709);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2994);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(2785);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2805);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3357);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3211);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3057);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2686);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3142);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3144);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2671);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2806);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2826);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3197);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3118);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(2690);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2939);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(796)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('F' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 797:
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '(') ADVANCE(2236);
      if (lookahead == '-') ADVANCE(885);
      if (lookahead == '.') ADVANCE(3385);
      if (lookahead == '/') ADVANCE(882);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == 'C') ADVANCE(2634);
      if (lookahead == '\\') ADVANCE(114);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == 'c') ADVANCE(2709);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2994);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(2785);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2805);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3357);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3211);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3057);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2686);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3142);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3144);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3083);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2672);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2806);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2826);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3197);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3118);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3154);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2976);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(797)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('F' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 798:
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '(') ADVANCE(2236);
      if (lookahead == '-') ADVANCE(885);
      if (lookahead == '.') ADVANCE(3385);
      if (lookahead == '/') ADVANCE(882);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '[') ADVANCE(3403);
      if (lookahead == '\\') ADVANCE(162);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2993);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(2785);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(2709);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2786);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3357);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3211);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3057);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2686);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3142);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3144);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2673);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2788);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2826);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3197);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3179);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(2690);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2939);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(798)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('F' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 799:
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '(') ADVANCE(2236);
      if (lookahead == '-') ADVANCE(885);
      if (lookahead == '.') ADVANCE(3385);
      if (lookahead == '/') ADVANCE(882);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '[') ADVANCE(3403);
      if (lookahead == '\\') ADVANCE(366);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2993);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(2785);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(2710);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2786);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3357);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3211);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3057);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2686);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3142);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3144);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2673);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2788);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2826);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3197);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3179);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(2690);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2939);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(799)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('F' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 800:
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '(') ADVANCE(2236);
      if (lookahead == '-') ADVANCE(885);
      if (lookahead == '.') ADVANCE(3385);
      if (lookahead == '/') ADVANCE(882);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '[') ADVANCE(3403);
      if (lookahead == '\\') ADVANCE(400);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2993);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(2785);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(2710);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2828);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3357);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3211);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3057);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2686);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3142);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3145);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2673);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2788);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2826);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3197);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3179);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(2690);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2939);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(800)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('F' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 801:
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '(') ADVANCE(2236);
      if (lookahead == '-') ADVANCE(885);
      if (lookahead == '.') ADVANCE(3385);
      if (lookahead == '/') ADVANCE(882);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '[') ADVANCE(3403);
      if (lookahead == '\\') ADVANCE(430);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2993);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(2785);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(2710);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2786);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3357);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3211);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3057);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2686);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3142);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3145);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2673);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2788);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2826);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3197);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3179);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(2690);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2939);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(801)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('F' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 802:
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '(') ADVANCE(2236);
      if (lookahead == '-') ADVANCE(885);
      if (lookahead == '.') ADVANCE(3385);
      if (lookahead == '/') ADVANCE(882);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '\\') ADVANCE(152);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2993);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(2785);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(2669);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2786);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3357);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3211);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3052);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2686);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3142);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3145);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3353);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2673);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2788);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2827);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3197);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3179);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(2690);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2939);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(802)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('F' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 803:
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '(') ADVANCE(2236);
      if (lookahead == '-') ADVANCE(885);
      if (lookahead == '.') ADVANCE(3385);
      if (lookahead == '/') ADVANCE(882);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '\\') ADVANCE(358);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2993);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(2785);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(2710);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2809);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3357);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3211);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3053);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2686);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3142);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3145);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3083);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2674);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2788);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2826);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3197);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3179);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3154);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2976);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(803)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('F' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 804:
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == ')') ADVANCE(2237);
      if (lookahead == ',') ADVANCE(2228);
      if (lookahead == '-') ADVANCE(885);
      if (lookahead == '.') ADVANCE(3385);
      if (lookahead == '/') ADVANCE(882);
      if (lookahead == '\\') SKIP(276)
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2971);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(804)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 805:
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == ')') ADVANCE(2237);
      if (lookahead == '-') ADVANCE(885);
      if (lookahead == '/') ADVANCE(882);
      if (lookahead == '\\') SKIP(262)
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(2931);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3355);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3175);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(3214);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3119);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(805)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 806:
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == ')') ADVANCE(2237);
      if (lookahead == '-') ADVANCE(885);
      if (lookahead == '/') ADVANCE(882);
      if (lookahead == '\\') SKIP(268)
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3091);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3335);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(2694);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(806)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 807:
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == ',') ADVANCE(2228);
      if (lookahead == '-') ADVANCE(885);
      if (lookahead == '.') ADVANCE(3385);
      if (lookahead == '/') ADVANCE(882);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '\\') ADVANCE(188);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2993);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(2785);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(2670);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2786);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3357);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3211);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3057);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2686);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3142);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3145);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2674);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2819);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2826);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3197);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3179);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3154);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2976);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(807)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('F' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 808:
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == ',') ADVANCE(2228);
      if (lookahead == '-') ADVANCE(885);
      if (lookahead == '/') ADVANCE(882);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '\\') ADVANCE(92);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2993);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(2785);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(2710);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2786);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3357);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3201);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3186);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3056);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(3141);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2684);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3142);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3145);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(2894);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2674);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2787);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2826);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3197);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3179);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3154);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2919);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(808)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('H' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 809:
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == ',') ADVANCE(2228);
      if (lookahead == '-') ADVANCE(885);
      if (lookahead == '/') ADVANCE(882);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '\\') ADVANCE(150);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2993);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(2785);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(2710);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2786);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3357);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(2863);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3211);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3057);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2685);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3142);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3145);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(2894);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2674);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2788);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2826);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3197);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3179);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3154);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2976);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(809)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('H' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 810:
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == ',') ADVANCE(2228);
      if (lookahead == '-') ADVANCE(885);
      if (lookahead == '/') ADVANCE(882);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '\\') ADVANCE(160);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2993);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(2785);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(2710);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2786);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3357);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3211);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3057);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2685);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3142);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3145);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(2894);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2674);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2788);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2826);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3197);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3179);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3154);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2939);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(810)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('F' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 811:
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == ',') ADVANCE(2228);
      if (lookahead == '-') ADVANCE(885);
      if (lookahead == '/') ADVANCE(882);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '\\') ADVANCE(166);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2993);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(2785);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(2710);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2786);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3357);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3211);
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(2668);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3057);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2685);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3142);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3145);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(2894);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2674);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2788);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2826);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3197);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3179);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3154);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2939);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(811)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('F' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 812:
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == ',') ADVANCE(2228);
      if (lookahead == '-') ADVANCE(885);
      if (lookahead == '/') ADVANCE(882);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '\\') ADVANCE(356);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2993);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(2785);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(2710);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2786);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3357);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(2863);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3211);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3057);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2685);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3142);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3145);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(2895);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2674);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2788);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2826);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3197);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3179);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3154);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2976);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(812)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('H' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 813:
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == ',') ADVANCE(2228);
      if (lookahead == '-') ADVANCE(885);
      if (lookahead == '/') ADVANCE(882);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '\\') ADVANCE(364);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2993);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(2785);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(2710);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2786);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3357);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3211);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3057);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2685);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3142);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3145);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(2895);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2674);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2788);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2826);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3197);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3179);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3154);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2939);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(813)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('F' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 814:
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == ',') ADVANCE(2228);
      if (lookahead == '-') ADVANCE(885);
      if (lookahead == '/') ADVANCE(882);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '\\') ADVANCE(398);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2993);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(2785);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(2710);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2786);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3357);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3211);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3057);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2685);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3142);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3143);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(2895);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2674);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2788);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2826);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3197);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3179);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3154);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2939);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(814)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('F' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 815:
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == ',') ADVANCE(2228);
      if (lookahead == '-') ADVANCE(885);
      if (lookahead == '/') ADVANCE(882);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '\\') ADVANCE(396);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2993);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(2785);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(2710);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2786);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3357);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(2863);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3211);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3057);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2685);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3142);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3143);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(2895);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2674);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2788);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2826);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3197);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3179);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3154);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2976);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(815)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('H' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 816:
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == ',') ADVANCE(2228);
      if (lookahead == '-') ADVANCE(885);
      if (lookahead == '/') ADVANCE(882);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '\\') ADVANCE(190);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2993);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(2785);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(2710);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2786);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3357);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3202);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3211);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3057);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2686);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3142);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3145);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2674);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2788);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2826);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3197);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3179);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3154);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2925);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(816)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('H' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 817:
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == ',') ADVANCE(2228);
      if (lookahead == '-') ADVANCE(885);
      if (lookahead == '/') ADVANCE(882);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '\\') ADVANCE(426);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2993);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(2785);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(2710);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2786);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3357);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(2863);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3211);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3057);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2686);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3142);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3145);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(2895);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2674);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2788);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2826);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3197);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3179);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3154);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2976);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(817)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('H' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 818:
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == ',') ADVANCE(2228);
      if (lookahead == '-') ADVANCE(885);
      if (lookahead == '/') ADVANCE(882);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '\\') ADVANCE(428);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2993);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(2785);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(2710);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2786);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3357);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3211);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3057);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2686);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3142);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3145);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(2895);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2674);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2788);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2826);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3197);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3179);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3154);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2939);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(818)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('F' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 819:
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == ',') ADVANCE(2228);
      if (lookahead == '-') ADVANCE(885);
      if (lookahead == '/') ADVANCE(882);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '\\') ADVANCE(478);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2993);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(2785);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(2710);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2786);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3357);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3201);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3186);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3056);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(3141);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2684);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3142);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3145);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(2894);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2674);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2787);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2826);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3197);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3179);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3154);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2925);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(819)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('H' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 820:
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == ',') ADVANCE(2228);
      if (lookahead == '-') ADVANCE(885);
      if (lookahead == '/') ADVANCE(882);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '\\') ADVANCE(494);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2993);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(2785);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(2710);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2786);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3357);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3211);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3057);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2685);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3142);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3145);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(2894);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2674);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2788);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2826);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3197);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3179);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3154);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2976);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(820)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('F' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 821:
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == ',') ADVANCE(2228);
      if (lookahead == '-') ADVANCE(885);
      if (lookahead == '/') ADVANCE(882);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '\\') ADVANCE(496);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2993);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(2785);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(2710);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2786);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3357);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3211);
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(2668);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3057);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2685);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3142);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3145);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(2894);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2674);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2788);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2826);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3197);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3179);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3154);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2976);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(821)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('F' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 822:
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == ',') ADVANCE(2228);
      if (lookahead == '-') ADVANCE(885);
      if (lookahead == '/') ADVANCE(882);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '\\') ADVANCE(514);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2993);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(2785);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(2710);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2786);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3357);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3211);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3057);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2685);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3142);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3145);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(2895);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2674);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2788);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2826);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3197);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3179);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3154);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2976);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(822)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('F' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 823:
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == ',') ADVANCE(2228);
      if (lookahead == '-') ADVANCE(885);
      if (lookahead == '/') ADVANCE(882);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '\\') ADVANCE(524);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2993);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(2785);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(2710);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2786);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3357);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3211);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3057);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2685);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3142);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3143);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(2895);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2674);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2788);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2826);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3197);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3179);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3154);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2976);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(823)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('F' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 824:
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == ',') ADVANCE(2228);
      if (lookahead == '-') ADVANCE(885);
      if (lookahead == '/') ADVANCE(882);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '\\') ADVANCE(534);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2993);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(2785);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(2710);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2786);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3357);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3211);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3057);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2686);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3142);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3145);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(2895);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2674);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2788);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2826);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3197);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3179);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3154);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2976);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(824)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('F' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 825:
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '-') ADVANCE(885);
      if (lookahead == '.') ADVANCE(3385);
      if (lookahead == '/') ADVANCE(882);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '\\') ADVANCE(178);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2993);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(2785);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(2669);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2786);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3357);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3211);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3052);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2686);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3142);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3145);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3353);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2674);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2788);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2827);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3197);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3179);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3154);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2976);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(825)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('F' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 826:
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '-') ADVANCE(885);
      if (lookahead == '.') ADVANCE(3385);
      if (lookahead == '/') ADVANCE(882);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '\\') ADVANCE(182);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2993);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(2785);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(2670);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2786);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3357);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3211);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3057);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2686);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3142);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3145);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2674);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2788);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2758);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3197);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3179);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(2869);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2976);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(826)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('F' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 827:
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '-') ADVANCE(885);
      if (lookahead == '.') ADVANCE(3385);
      if (lookahead == '/') ADVANCE(882);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '\\') ADVANCE(254);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2995);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(2785);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3159);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2860);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3211);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3131);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(3172);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2811);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3213);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3179);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2971);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(827)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('E' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 828:
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '-') ADVANCE(885);
      if (lookahead == '.') ADVANCE(3385);
      if (lookahead == '/') ADVANCE(882);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '\\') ADVANCE(260);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2995);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3196);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2812);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3115);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3211);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3131);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2868);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2811);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3179);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2971);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(828)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('B' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 829:
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '-') ADVANCE(885);
      if (lookahead == '.') ADVANCE(3385);
      if (lookahead == '/') ADVANCE(882);
      if (lookahead == '\\') SKIP(280)
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3083);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(829)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 830:
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '-') ADVANCE(885);
      if (lookahead == '.') ADVANCE(3385);
      if (lookahead == '/') ADVANCE(882);
      if (lookahead == '\\') ADVANCE(130);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2995);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(2785);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3196);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2812);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3356);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3150);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3211);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3131);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(3223);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2813);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2811);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3179);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2932);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(830)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('H' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 831:
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '-') ADVANCE(885);
      if (lookahead == '.') ADVANCE(3385);
      if (lookahead == '/') ADVANCE(882);
      if (lookahead == '\\') ADVANCE(348);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2995);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(2785);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3196);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2812);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3356);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3151);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3211);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3131);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(3223);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2813);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2811);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3179);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2932);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(831)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('H' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 832:
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '-') ADVANCE(885);
      if (lookahead == '.') ADVANCE(3385);
      if (lookahead == '/') ADVANCE(882);
      if (lookahead == '\\') ADVANCE(198);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2995);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(2785);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3196);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2812);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3356);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3211);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3131);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2868);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2811);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3179);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2971);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(832)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('F' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 833:
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '-') ADVANCE(885);
      if (lookahead == '/') ADVANCE(882);
      if (lookahead == ':') ADVANCE(889);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == 'C') ADVANCE(2634);
      if (lookahead == '\\') ADVANCE(104);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == 'c') ADVANCE(2709);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2994);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(2785);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2805);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3357);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(2959);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3211);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3057);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2686);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3142);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3144);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3349);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2672);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2806);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2826);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3197);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3118);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3154);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2982);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(833)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('H' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 834:
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '-') ADVANCE(885);
      if (lookahead == '/') ADVANCE(882);
      if (lookahead == ':') ADVANCE(889);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == 'C') ADVANCE(2634);
      if (lookahead == '\\') ADVANCE(126);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == 'c') ADVANCE(2709);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2994);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(2785);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2805);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3357);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3211);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3057);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2686);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3142);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3144);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3349);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2672);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2806);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2826);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3197);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3118);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3154);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2976);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(834)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('F' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 835:
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '-') ADVANCE(885);
      if (lookahead == '/') ADVANCE(882);
      if (lookahead == ':') ADVANCE(889);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == 'C') ADVANCE(2634);
      if (lookahead == '\\') ADVANCE(484);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == 'c') ADVANCE(2709);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2994);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(2785);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2805);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3357);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(2959);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3211);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3057);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2686);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3142);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3144);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3349);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2672);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2806);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2826);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3197);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3118);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3154);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2976);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(835)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('H' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 836:
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '-') ADVANCE(885);
      if (lookahead == '/') ADVANCE(882);
      if (lookahead == ':') ADVANCE(889);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '\\') ADVANCE(174);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2993);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(2785);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(2710);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2786);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3357);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(2959);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3211);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3057);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2686);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3142);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3145);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3349);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2674);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2788);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2826);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3197);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3179);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3154);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2982);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(836)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('H' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 837:
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '-') ADVANCE(885);
      if (lookahead == '/') ADVANCE(882);
      if (lookahead == ':') ADVANCE(889);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '\\') ADVANCE(204);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2993);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(2785);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(2710);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2786);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3357);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3211);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3057);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2686);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3142);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3145);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3349);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2674);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2788);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2826);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3197);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3179);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3154);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2976);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(837)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('F' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 838:
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '-') ADVANCE(885);
      if (lookahead == '/') ADVANCE(882);
      if (lookahead == ':') ADVANCE(889);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '\\') ADVANCE(498);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2993);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(2785);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(2710);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2786);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3357);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(2959);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3211);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3057);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2686);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3142);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3145);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3349);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2674);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2788);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2826);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3197);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3179);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3154);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2976);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(838)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('H' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 839:
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '-') ADVANCE(885);
      if (lookahead == '/') ADVANCE(882);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '[') ADVANCE(3403);
      if (lookahead == '\\') ADVANCE(168);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2993);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(2785);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(2709);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2786);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3357);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3211);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3057);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2686);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3142);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3144);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2674);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2788);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2826);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3197);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3179);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3154);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2976);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(839)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('F' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 840:
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '-') ADVANCE(885);
      if (lookahead == '/') ADVANCE(882);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '[') ADVANCE(3403);
      if (lookahead == '\\') ADVANCE(368);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2993);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(2785);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(2710);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2786);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3357);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3211);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3057);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2686);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3142);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3144);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2674);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2788);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2826);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3197);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3179);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3154);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2976);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(840)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('F' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 841:
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '-') ADVANCE(885);
      if (lookahead == '/') ADVANCE(882);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '[') ADVANCE(3403);
      if (lookahead == '\\') ADVANCE(402);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2993);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(2785);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(2710);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2828);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3357);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3211);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3057);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2686);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3142);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3145);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2674);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2788);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2826);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3197);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3179);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3154);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2976);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(841)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('F' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 842:
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '-') ADVANCE(885);
      if (lookahead == '/') ADVANCE(882);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '\\') ADVANCE(148);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2993);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(2785);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(2710);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2786);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3357);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3186);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3057);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2685);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3142);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3145);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(2894);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2674);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2788);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2826);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3197);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3179);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3154);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2939);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(842)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('F' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 843:
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '-') ADVANCE(885);
      if (lookahead == '/') ADVANCE(882);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '\\') ADVANCE(184);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2993);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(2785);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(2710);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2786);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3357);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3211);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3055);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2686);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3142);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3145);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2674);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2788);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2826);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3197);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3179);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3154);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2925);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(843)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('F' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 844:
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '-') ADVANCE(885);
      if (lookahead == '/') ADVANCE(882);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '\\') ADVANCE(370);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2993);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(2785);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(2710);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2809);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3357);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3211);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3053);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2686);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3142);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3145);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2674);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2788);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2826);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3197);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3179);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3154);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2976);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(844)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('F' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 845:
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '-') ADVANCE(885);
      if (lookahead == '/') ADVANCE(882);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '\\') ADVANCE(404);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2993);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(2785);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(2710);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2786);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3357);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3211);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3053);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2686);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3142);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3145);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2674);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2788);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2826);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3197);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3179);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3154);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2976);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(845)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('F' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 846:
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '-') ADVANCE(885);
      if (lookahead == '/') ADVANCE(882);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '\\') ADVANCE(208);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2993);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(2785);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(2710);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2786);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3357);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(2863);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3211);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3057);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2686);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3142);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3145);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2674);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2788);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2826);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3197);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3179);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3154);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2976);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(846)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('H' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 847:
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '-') ADVANCE(885);
      if (lookahead == '/') ADVANCE(882);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '\\') ADVANCE(432);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2993);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(2785);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(2710);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2786);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3357);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3211);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3057);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2686);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3142);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3145);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2674);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2789);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2826);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3197);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3179);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3154);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2939);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(847)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('F' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 848:
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '-') ADVANCE(885);
      if (lookahead == '/') ADVANCE(882);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '\\') ADVANCE(450);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2993);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(2785);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(2710);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2786);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3357);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(2863);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3211);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3057);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2686);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3142);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3145);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2674);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2789);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2826);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3197);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3179);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3154);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2976);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(848)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('H' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 849:
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '-') ADVANCE(885);
      if (lookahead == '/') ADVANCE(882);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '\\') ADVANCE(492);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2993);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(2785);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(2710);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2786);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3357);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3186);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3057);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2685);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3142);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3145);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(2894);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2674);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2788);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2826);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3197);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3179);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3154);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2976);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(849)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('F' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 850:
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '-') ADVANCE(885);
      if (lookahead == '/') ADVANCE(882);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '\\') ADVANCE(536);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2993);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(2785);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(2710);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2786);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3357);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3211);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3057);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2686);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(3142);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3145);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2674);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2789);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2826);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(3197);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3179);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(3154);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2976);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(850)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('F' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 851:
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '-') ADVANCE(885);
      if (lookahead == '/') ADVANCE(882);
      if (lookahead == 'C') ADVANCE(2651);
      if (lookahead == 'S') ADVANCE(2622);
      if (lookahead == '\\') SKIP(278)
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(851)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 852:
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '-') ADVANCE(885);
      if (lookahead == '/') ADVANCE(882);
      if (lookahead == '\\') SKIP(270)
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3339);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2872);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(852)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 853:
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '-') ADVANCE(885);
      if (lookahead == '/') ADVANCE(882);
      if (lookahead == '\\') SKIP(274)
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2700);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2759);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(2719);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(853)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 854:
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '-') ADVANCE(885);
      if (lookahead == '/') ADVANCE(882);
      if (lookahead == '\\') SKIP(282)
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2718);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(854)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 855:
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '-') ADVANCE(885);
      if (lookahead == '/') ADVANCE(882);
      if (lookahead == '\\') SKIP(284)
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3124);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(2719);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(855)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 856:
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '-') ADVANCE(885);
      if (lookahead == '/') ADVANCE(882);
      if (lookahead == '\\') SKIP(286)
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3168);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(2898);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(856)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 857:
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '-') ADVANCE(885);
      if (lookahead == '/') ADVANCE(882);
      if (lookahead == '\\') SKIP(288)
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(2898);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3124);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(857)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 858:
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '-') ADVANCE(885);
      if (lookahead == '/') ADVANCE(882);
      if (lookahead == '\\') SKIP(290)
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3166);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(858)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 859:
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '-') ADVANCE(885);
      if (lookahead == '/') ADVANCE(882);
      if (lookahead == '\\') SKIP(292)
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3124);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(859)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 860:
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '-') ADVANCE(885);
      if (lookahead == '/') ADVANCE(882);
      if (lookahead == '\\') SKIP(294)
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(2898);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(860)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 861:
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '-') ADVANCE(885);
      if (lookahead == '/') ADVANCE(882);
      if (lookahead == '\\') SKIP(296)
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3168);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(2898);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3083);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(861)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 862:
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '-') ADVANCE(885);
      if (lookahead == '/') ADVANCE(882);
      if (lookahead == '\\') SKIP(298)
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3216);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(3337);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(862)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 863:
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '-') ADVANCE(885);
      if (lookahead == '/') ADVANCE(882);
      if (lookahead == '\\') SKIP(300)
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(3163);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2856);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(863)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 864:
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '-') ADVANCE(885);
      if (lookahead == '/') ADVANCE(882);
      if (lookahead == '\\') SKIP(302)
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2888);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(864)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 865:
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '-') ADVANCE(885);
      if (lookahead == '/') ADVANCE(882);
      if (lookahead == '\\') SKIP(304)
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(3241);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(865)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('B' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 866:
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '-') ADVANCE(885);
      if (lookahead == '/') ADVANCE(882);
      if (lookahead == '\\') ADVANCE(156);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2995);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(2785);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3196);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2812);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3356);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3151);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3211);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3131);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(3223);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2868);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2811);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3179);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2932);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(866)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('H' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 867:
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '-') ADVANCE(885);
      if (lookahead == '/') ADVANCE(882);
      if (lookahead == '\\') ADVANCE(362);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2995);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(2785);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3196);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2812);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3356);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3173);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3211);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3131);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(3223);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2868);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2811);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3179);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2971);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(867)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('H' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 868:
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '-') ADVANCE(885);
      if (lookahead == '/') ADVANCE(882);
      if (lookahead == '\\') ADVANCE(256);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2995);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(2785);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3196);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2812);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3356);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3151);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3211);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3131);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(2834);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3024);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(3223);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2868);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2811);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3179);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2932);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(868)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('H' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 869:
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '-') ADVANCE(885);
      if (lookahead == '/') ADVANCE(882);
      if (lookahead == '\\') SKIP(452)
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(2898);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(3083);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(869)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 870:
      if (lookahead == '"') ADVANCE(3375);
      if (lookahead == '-') ADVANCE(885);
      if (lookahead == '/') ADVANCE(882);
      if (lookahead == '\\') ADVANCE(448);
      if (lookahead == '`') ADVANCE(3365);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2995);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(2785);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(3196);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2812);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(3356);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(3173);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3211);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(3131);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(3223);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2868);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2811);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(3179);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2932);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(870)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('H' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(3364);
      END_STATE();
    case 871:
      if (lookahead == '"') ADVANCE(3382);
      END_STATE();
    case 872:
      if (lookahead == '"') ADVANCE(3384);
      if (lookahead == '*') ADVANCE(883);
      if (lookahead != 0) ADVANCE(884);
      END_STATE();
    case 873:
      if (lookahead == '&') ADVANCE(3438);
      END_STATE();
    case 874:
      if (lookahead == '\'') ADVANCE(2031);
      if (lookahead == '-') ADVANCE(885);
      if (lookahead == '/') ADVANCE(882);
      if (lookahead == '\\') SKIP(306)
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(874)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2377);
      END_STATE();
    case 875:
      if (lookahead == '\'') ADVANCE(2378);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(875);
      END_STATE();
    case 876:
      if (lookahead == '\'') ADVANCE(3394);
      END_STATE();
    case 877:
      if (lookahead == '\'') ADVANCE(3396);
      if (lookahead == '*') ADVANCE(883);
      if (lookahead != 0) ADVANCE(884);
      END_STATE();
    case 878:
      if (lookahead == '(') ADVANCE(2236);
      if (lookahead == ')') ADVANCE(2237);
      if (lookahead == ',') ADVANCE(2228);
      if (lookahead == '-') ADVANCE(885);
      if (lookahead == '.') ADVANCE(3385);
      if (lookahead == '/') ADVANCE(882);
      if (lookahead == ':') ADVANCE(2311);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '=') ADVANCE(2401);
      if (lookahead == '\\') ADVANCE(76);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1121);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(1228);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(949);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(1229);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1584);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(1747);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(1769);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1635);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(1707);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1255);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(1033);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1708);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1353);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(979);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(1230);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(1092);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(989);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(1680);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(1024);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(1414);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(878)
      END_STATE();
    case 879:
      if (lookahead == '(') ADVANCE(2236);
      if (lookahead == ')') ADVANCE(2237);
      if (lookahead == ',') ADVANCE(2228);
      if (lookahead == '-') ADVANCE(885);
      if (lookahead == '.') ADVANCE(3385);
      if (lookahead == '/') ADVANCE(882);
      if (lookahead == ':') ADVANCE(889);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '=') ADVANCE(2401);
      if (lookahead == '\\') ADVANCE(170);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1122);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(1276);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(948);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(1239);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1675);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(1746);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(1838);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1638);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1708);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1610);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(1007);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(954);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(1091);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(1031);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(1680);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(1023);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(1458);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(879)
      END_STATE();
    case 880:
      if (lookahead == '(') ADVANCE(2236);
      if (lookahead == ')') ADVANCE(2237);
      if (lookahead == ',') ADVANCE(2228);
      if (lookahead == '-') ADVANCE(885);
      if (lookahead == '.') ADVANCE(3385);
      if (lookahead == '/') ADVANCE(882);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '=') ADVANCE(2401);
      if (lookahead == 'C') ADVANCE(909);
      if (lookahead == '[') ADVANCE(3403);
      if (lookahead == '\\') ADVANCE(230);
      if (lookahead == 'c') ADVANCE(997);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1583);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(1276);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(1216);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1676);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(1789);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(1769);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1641);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(1707);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1256);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(1033);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1709);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1357);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(1792);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(1225);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(1090);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(1029);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(1679);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(985);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(1416);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(880)
      END_STATE();
    case 881:
      if (lookahead == ')') ADVANCE(2237);
      if (lookahead == ',') ADVANCE(2228);
      if (lookahead == '-') ADVANCE(885);
      if (lookahead == '/') ADVANCE(882);
      if (lookahead == ';') ADVANCE(2217);
      if (lookahead == '=') ADVANCE(2401);
      if (lookahead == 'C') ADVANCE(909);
      if (lookahead == '[') ADVANCE(3403);
      if (lookahead == '\\') ADVANCE(250);
      if (lookahead == 'c') ADVANCE(997);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1583);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(1276);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(1217);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1673);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(1809);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1642);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1709);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(2010);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(1804);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(1227);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(1221);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(1826);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(1679);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(1458);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(881)
      END_STATE();
    case 882:
      if (lookahead == '*') ADVANCE(884);
      END_STATE();
    case 883:
      if (lookahead == '*') ADVANCE(883);
      if (lookahead == '/') ADVANCE(3406);
      if (lookahead != 0) ADVANCE(884);
      END_STATE();
    case 884:
      if (lookahead == '*') ADVANCE(883);
      if (lookahead != 0) ADVANCE(884);
      END_STATE();
    case 885:
      if (lookahead == '-') ADVANCE(3409);
      END_STATE();
    case 886:
      if (lookahead == '-') ADVANCE(885);
      if (lookahead == '/') ADVANCE(882);
      if (lookahead == '\\') SKIP(264)
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(1737);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(1706);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(2013);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(1981);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1698);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(1033);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1786);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(1810);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(1748);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(1093);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(1028);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(1678);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(1431);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(886)
      END_STATE();
    case 887:
      if (lookahead == '/') ADVANCE(3417);
      if (lookahead == '|') ADVANCE(888);
      END_STATE();
    case 888:
      if (lookahead == '/') ADVANCE(3418);
      END_STATE();
    case 889:
      if (lookahead == ':') ADVANCE(3405);
      END_STATE();
    case 890:
      if (lookahead == '=') ADVANCE(3432);
      if (lookahead == '~') ADVANCE(3435);
      END_STATE();
    case 891:
      if (lookahead == 'A') ADVANCE(897);
      if (lookahead == 'a') ADVANCE(1485);
      END_STATE();
    case 892:
      if (lookahead == 'A') ADVANCE(896);
      END_STATE();
    case 893:
      if (lookahead == 'E') ADVANCE(900);
      if (lookahead == 'e') ADVANCE(1682);
      END_STATE();
    case 894:
      if (lookahead == 'E') ADVANCE(917);
      END_STATE();
    case 895:
      if (lookahead == 'E') ADVANCE(2279);
      END_STATE();
    case 896:
      if (lookahead == 'I') ADVANCE(904);
      END_STATE();
    case 897:
      if (lookahead == 'I') ADVANCE(905);
      if (lookahead == 'i') ADVANCE(1686);
      END_STATE();
    case 898:
      if (lookahead == 'L') ADVANCE(895);
      END_STATE();
    case 899:
      if (lookahead == 'N') ADVANCE(919);
      if (lookahead == 'n') ADVANCE(1108);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1565);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(1590);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(1890);
      END_STATE();
    case 900:
      if (lookahead == 'N') ADVANCE(922);
      if (lookahead == 'n') ADVANCE(1905);
      END_STATE();
    case 901:
      if (lookahead == 'N') ADVANCE(921);
      END_STATE();
    case 902:
      if (lookahead == 'N') ADVANCE(921);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1972);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(1590);
      END_STATE();
    case 903:
      if (lookahead == 'N') ADVANCE(921);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(1590);
      END_STATE();
    case 904:
      if (lookahead == 'N') ADVANCE(923);
      END_STATE();
    case 905:
      if (lookahead == 'N') ADVANCE(924);
      if (lookahead == 'n') ADVANCE(1915);
      END_STATE();
    case 906:
      if (lookahead == 'O') ADVANCE(899);
      if (lookahead == 'U') ADVANCE(913);
      if (lookahead == 'o') ADVANCE(1503);
      if (lookahead == 'u') ADVANCE(1042);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1105);
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(1240);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(1235);
      END_STATE();
    case 907:
      if (lookahead == 'O') ADVANCE(898);
      END_STATE();
    case 908:
      if (lookahead == 'O') ADVANCE(902);
      if (lookahead == 'o') ADVANCE(1528);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1880);
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(1240);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(1235);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(1788);
      END_STATE();
    case 909:
      if (lookahead == 'O') ADVANCE(903);
      if (lookahead == 'o') ADVANCE(1592);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1104);
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(1240);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(1235);
      END_STATE();
    case 910:
      if (lookahead == 'O') ADVANCE(903);
      if (lookahead == 'o') ADVANCE(1592);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1884);
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(1240);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(1235);
      END_STATE();
    case 911:
      if (lookahead == 'O') ADVANCE(903);
      if (lookahead == 'o') ADVANCE(1592);
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(1240);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(1235);
      END_STATE();
    case 912:
      if (lookahead == 'O') ADVANCE(901);
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(1240);
      END_STATE();
    case 913:
      if (lookahead == 'R') ADVANCE(914);
      if (lookahead == 'r') ADVANCE(1806);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(1163);
      END_STATE();
    case 914:
      if (lookahead == 'R') ADVANCE(893);
      if (lookahead == 'r') ADVANCE(1323);
      END_STATE();
    case 915:
      if (lookahead == 'R') ADVANCE(891);
      if (lookahead == 'r') ADVANCE(1015);
      END_STATE();
    case 916:
      if (lookahead == 'R') ADVANCE(907);
      if (lookahead == 'U') ADVANCE(920);
      END_STATE();
    case 917:
      if (lookahead == 'R') ADVANCE(2277);
      END_STATE();
    case 918:
      if (lookahead == 'R') ADVANCE(892);
      END_STATE();
    case 919:
      if (lookahead == 'S') ADVANCE(925);
      if (lookahead == 's') ADVANCE(1939);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(1978);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(1012);
      END_STATE();
    case 920:
      if (lookahead == 'S') ADVANCE(894);
      END_STATE();
    case 921:
      if (lookahead == 'S') ADVANCE(926);
      END_STATE();
    case 922:
      if (lookahead == 'T') ADVANCE(2597);
      if (lookahead == 't') ADVANCE(2596);
      END_STATE();
    case 923:
      if (lookahead == 'T') ADVANCE(2512);
      END_STATE();
    case 924:
      if (lookahead == 'T') ADVANCE(2512);
      if (lookahead == 't') ADVANCE(2409);
      END_STATE();
    case 925:
      if (lookahead == 'T') ADVANCE(915);
      if (lookahead == 't') ADVANCE(1841);
      END_STATE();
    case 926:
      if (lookahead == 'T') ADVANCE(918);
      END_STATE();
    case 927:
      if (lookahead == '_') ADVANCE(1453);
      END_STATE();
    case 928:
      if (lookahead == '_') ADVANCE(1700);
      END_STATE();
    case 929:
      if (lookahead == '_') ADVANCE(1965);
      END_STATE();
    case 930:
      if (lookahead == '_') ADVANCE(1448);
      END_STATE();
    case 931:
      if (lookahead == '|') ADVANCE(3439);
      END_STATE();
    case 932:
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(2030);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(2617);
      END_STATE();
    case 933:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1105);
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(1240);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1503);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(1235);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(1042);
      END_STATE();
    case 934:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1062);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1251);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1126);
      if (lookahead == 'X' ||
          lookahead == 'x') ADVANCE(1071);
      END_STATE();
    case 935:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1062);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1125);
      if (lookahead == 'X' ||
          lookahead == 'x') ADVANCE(1070);
      END_STATE();
    case 936:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1514);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1950);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1575);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1523);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(1721);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(1526);
      END_STATE();
    case 937:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2001);
      END_STATE();
    case 938:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1644);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(943);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1501);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1067);
      END_STATE();
    case 939:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1961);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1702);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1142);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(1532);
      END_STATE();
    case 940:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1770);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(1161);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(1043);
      END_STATE();
    case 941:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1360);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(1406);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1095);
      if (lookahead == 'Q' ||
          lookahead == 'q') ADVANCE(1506);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(944);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(1039);
      END_STATE();
    case 942:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1360);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1562);
      END_STATE();
    case 943:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1500);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(1892);
      END_STATE();
    case 944:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1048);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1798);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(1466);
      END_STATE();
    case 945:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2372);
      END_STATE();
    case 946:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1050);
      END_STATE();
    case 947:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(2252);
      END_STATE();
    case 948:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1106);
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(1240);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1592);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(1235);
      END_STATE();
    case 949:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1107);
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(1240);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1576);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(1235);
      END_STATE();
    case 950:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1923);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1097);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1866);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1591);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(1713);
      END_STATE();
    case 951:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1564);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1844);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1236);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1520);
      END_STATE();
    case 952:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1645);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(991);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1376);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1505);
      END_STATE();
    case 953:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1645);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1369);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1543);
      END_STATE();
    case 954:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1645);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1646);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1543);
      END_STATE();
    case 955:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1645);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1956);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1543);
      END_STATE();
    case 956:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1645);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1368);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1541);
      END_STATE();
    case 957:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1645);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(2009);
      END_STATE();
    case 958:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1668);
      END_STATE();
    case 959:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1668);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1971);
      END_STATE();
    case 960:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1668);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1973);
      END_STATE();
    case 961:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1991);
      END_STATE();
    case 962:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1991);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1807);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1699);
      END_STATE();
    case 963:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1991);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1834);
      END_STATE();
    case 964:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1991);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1834);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1699);
      END_STATE();
    case 965:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1515);
      END_STATE();
    case 966:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1515);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2590);
      END_STATE();
    case 967:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1653);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1377);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(1172);
      END_STATE();
    case 968:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1148);
      END_STATE();
    case 969:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1509);
      END_STATE();
    case 970:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1569);
      END_STATE();
    case 971:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1510);
      END_STATE();
    case 972:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1873);
      END_STATE();
    case 973:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1511);
      END_STATE();
    case 974:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1880);
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(1240);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1528);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(1235);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(1788);
      END_STATE();
    case 975:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1535);
      END_STATE();
    case 976:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1513);
      END_STATE();
    case 977:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1138);
      END_STATE();
    case 978:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1966);
      END_STATE();
    case 979:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1879);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(1322);
      END_STATE();
    case 980:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1790);
      END_STATE();
    case 981:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1922);
      END_STATE();
    case 982:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1794);
      END_STATE();
    case 983:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1677);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(1656);
      END_STATE();
    case 984:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1797);
      END_STATE();
    case 985:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1797);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1236);
      END_STATE();
    case 986:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1825);
      END_STATE();
    case 987:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1943);
      END_STATE();
    case 988:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1047);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1593);
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(1252);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1249);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(2275);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(967);
      if (lookahead == 'Y' ||
          lookahead == 'y') ADVANCE(1753);
      END_STATE();
    case 989:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1047);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(2275);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(1983);
      if (lookahead == 'Y' ||
          lookahead == 'y') ADVANCE(1756);
      END_STATE();
    case 990:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1362);
      END_STATE();
    case 991:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1144);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(1262);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(1326);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(995);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(1531);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(1938);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(1974);
      END_STATE();
    case 992:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1066);
      END_STATE();
    case 993:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1570);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(1495);
      END_STATE();
    case 994:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1381);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1654);
      END_STATE();
    case 995:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1600);
      END_STATE();
    case 996:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1082);
      END_STATE();
    case 997:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1104);
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(1240);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1592);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(1235);
      END_STATE();
    case 998:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1534);
      END_STATE();
    case 999:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1383);
      END_STATE();
    case 1000:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1601);
      END_STATE();
    case 1001:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1808);
      END_STATE();
    case 1002:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1808);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1798);
      END_STATE();
    case 1003:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1945);
      END_STATE();
    case 1004:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1384);
      END_STATE();
    case 1005:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1084);
      END_STATE();
    case 1006:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1151);
      END_STATE();
    case 1007:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1820);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(1468);
      END_STATE();
    case 1008:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1439);
      END_STATE();
    case 1009:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1818);
      END_STATE();
    case 1010:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1085);
      END_STATE();
    case 1011:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1947);
      END_STATE();
    case 1012:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1447);
      END_STATE();
    case 1013:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1948);
      END_STATE();
    case 1014:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1942);
      END_STATE();
    case 1015:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1485);
      END_STATE();
    case 1016:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1696);
      END_STATE();
    case 1017:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1571);
      END_STATE();
    case 1018:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1051);
      END_STATE();
    case 1019:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1573);
      END_STATE();
    case 1020:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1572);
      END_STATE();
    case 1021:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1052);
      END_STATE();
    case 1022:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1052);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1732);
      END_STATE();
    case 1023:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1563);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1844);
      END_STATE();
    case 1024:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1563);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1844);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1236);
      END_STATE();
    case 1025:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1053);
      END_STATE();
    case 1026:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1053);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1132);
      END_STATE();
    case 1027:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1959);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1589);
      END_STATE();
    case 1028:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1054);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1593);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(1429);
      if (lookahead == 'Y' ||
          lookahead == 'y') ADVANCE(1763);
      END_STATE();
    case 1029:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1054);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1593);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(1983);
      if (lookahead == 'Y' ||
          lookahead == 'y') ADVANCE(1763);
      END_STATE();
    case 1030:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1054);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1248);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(983);
      END_STATE();
    case 1031:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1055);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(2275);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(1983);
      END_STATE();
    case 1032:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1055);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(1430);
      END_STATE();
    case 1033:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1960);
      END_STATE();
    case 1034:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1049);
      END_STATE();
    case 1035:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1970);
      END_STATE();
    case 1036:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1884);
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(1240);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1592);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(1235);
      END_STATE();
    case 1037:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1116);
      END_STATE();
    case 1038:
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1116);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(1743);
      END_STATE();
    case 1039:
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(1868);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(1755);
      END_STATE();
    case 1040:
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(2026);
      END_STATE();
    case 1041:
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(1723);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1768);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(990);
      END_STATE();
    case 1042:
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(1163);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(1806);
      END_STATE();
    case 1043:
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(1566);
      END_STATE();
    case 1044:
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(992);
      END_STATE();
    case 1045:
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(992);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(1752);
      END_STATE();
    case 1046:
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(1867);
      END_STATE();
    case 1047:
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(1545);
      END_STATE();
    case 1048:
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(1547);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(1899);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(1340);
      END_STATE();
    case 1049:
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(1550);
      END_STATE();
    case 1050:
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(1550);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(1441);
      END_STATE();
    case 1051:
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(1552);
      END_STATE();
    case 1052:
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(1553);
      END_STATE();
    case 1053:
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(1554);
      END_STATE();
    case 1054:
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(1555);
      END_STATE();
    case 1055:
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(1556);
      END_STATE();
    case 1056:
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(2508);
      END_STATE();
    case 1057:
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(2510);
      END_STATE();
    case 1058:
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(2312);
      END_STATE();
    case 1059:
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(2474);
      END_STATE();
    case 1060:
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(2399);
      END_STATE();
    case 1061:
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(2364);
      END_STATE();
    case 1062:
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(1391);
      END_STATE();
    case 1063:
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(1267);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(1318);
      END_STATE();
    case 1064:
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(1498);
      END_STATE();
    case 1065:
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(1577);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(1231);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1927);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1266);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(1986);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(1269);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(1319);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(1719);
      END_STATE();
    case 1066:
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(1499);
      END_STATE();
    case 1067:
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(969);
      END_STATE();
    case 1068:
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(1393);
      END_STATE();
    case 1069:
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(1994);
      END_STATE();
    case 1070:
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(1519);
      END_STATE();
    case 1071:
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(1519);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1069);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1871);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(1237);
      END_STATE();
    case 1072:
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(1519);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(1305);
      END_STATE();
    case 1073:
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(968);
      END_STATE();
    case 1074:
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(968);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(2575);
      END_STATE();
    case 1075:
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(1496);
      END_STATE();
    case 1076:
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(1801);
      END_STATE();
    case 1077:
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(1270);
      END_STATE();
    case 1078:
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(1902);
      END_STATE();
    case 1079:
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(1903);
      END_STATE();
    case 1080:
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(1910);
      END_STATE();
    case 1081:
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(1911);
      END_STATE();
    case 1082:
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(1196);
      END_STATE();
    case 1083:
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(1202);
      END_STATE();
    case 1084:
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(1212);
      END_STATE();
    case 1085:
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(1213);
      END_STATE();
    case 1086:
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(1280);
      END_STATE();
    case 1087:
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(1261);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(995);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(1938);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(1980);
      END_STATE();
    case 1088:
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(1297);
      END_STATE();
    case 1089:
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(1406);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1561);
      END_STATE();
    case 1090:
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(1406);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1561);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(1001);
      END_STATE();
    case 1091:
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(1406);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1562);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(1001);
      END_STATE();
    case 1092:
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(1406);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1560);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(1002);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(1046);
      END_STATE();
    case 1093:
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(1406);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1767);
      END_STATE();
    case 1094:
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(1298);
      END_STATE();
    case 1095:
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(1975);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1260);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1128);
      if (lookahead == 'Q' ||
          lookahead == 'q') ADVANCE(1992);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(1883);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(2282);
      END_STATE();
    case 1096:
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(1281);
      END_STATE();
    case 1097:
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(1524);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(962);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1321);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(1057);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(1263);
      END_STATE();
    case 1098:
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(1524);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(963);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1320);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(1057);
      END_STATE();
    case 1099:
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(1524);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(961);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1320);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(1057);
      END_STATE();
    case 1100:
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(1524);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(964);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1321);
      END_STATE();
    case 1101:
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(1524);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(1306);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1320);
      END_STATE();
    case 1102:
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(1524);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1320);
      END_STATE();
    case 1103:
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(1524);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1320);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(1057);
      END_STATE();
    case 1104:
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(1407);
      END_STATE();
    case 1105:
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(1407);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1539);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1722);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(1074);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(1253);
      END_STATE();
    case 1106:
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(1407);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(1073);
      END_STATE();
    case 1107:
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(1407);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(1073);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(1253);
      END_STATE();
    case 1108:
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(1978);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(1939);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(1012);
      END_STATE();
    case 1109:
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(1537);
      END_STATE();
    case 1110:
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(976);
      END_STATE();
    case 1111:
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(1949);
      END_STATE();
    case 1112:
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(1846);
      END_STATE();
    case 1113:
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(1967);
      END_STATE();
    case 1114:
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(1006);
      END_STATE();
    case 1115:
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(1011);
      END_STATE();
    case 1116:
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(1969);
      END_STATE();
    case 1117:
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(1847);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(1231);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1266);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(1268);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(1712);
      END_STATE();
    case 1118:
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(1847);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(1231);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(1268);
      END_STATE();
    case 1119:
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(1847);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1927);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(1268);
      END_STATE();
    case 1120:
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(1123);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(1952);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1423);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(966);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2230);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(2603);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(1926);
      END_STATE();
    case 1121:
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(1123);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(1952);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1424);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(965);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2229);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(1717);
      END_STATE();
    case 1122:
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(1123);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1954);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2229);
      END_STATE();
    case 1123:
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2286);
      END_STATE();
    case 1124:
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2590);
      END_STATE();
    case 1125:
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2313);
      END_STATE();
    case 1126:
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2313);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(1586);
      END_STATE();
    case 1127:
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2423);
      END_STATE();
    case 1128:
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2488);
      END_STATE();
    case 1129:
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2300);
      END_STATE();
    case 1130:
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2300);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2276);
      END_STATE();
    case 1131:
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2357);
      END_STATE();
    case 1132:
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2518);
      END_STATE();
    case 1133:
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2500);
      END_STATE();
    case 1134:
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2593);
      END_STATE();
    case 1135:
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2235);
      END_STATE();
    case 1136:
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2535);
      END_STATE();
    case 1137:
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2356);
      END_STATE();
    case 1138:
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(2427);
      END_STATE();
    case 1139:
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(1040);
      END_STATE();
    case 1140:
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(927);
      END_STATE();
    case 1141:
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(1848);
      END_STATE();
    case 1142:
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(1425);
      END_STATE();
    case 1143:
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(1273);
      END_STATE();
    case 1144:
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(1851);
      END_STATE();
    case 1145:
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(1716);
      END_STATE();
    case 1146:
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(1493);
      END_STATE();
    case 1147:
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(1427);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1757);
      END_STATE();
    case 1148:
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(1190);
      END_STATE();
    case 1149:
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(1193);
      END_STATE();
    case 1150:
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(1282);
      END_STATE();
    case 1151:
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(1288);
      END_STATE();
    case 1152:
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(1231);
      END_STATE();
    case 1153:
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(1232);
      END_STATE();
    case 1154:
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(1996);
      END_STATE();
    case 1155:
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(1278);
      END_STATE();
    case 1156:
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(1003);
      END_STATE();
    case 1157:
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(1484);
      END_STATE();
    case 1158:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1349);
      if (lookahead == 'Y' ||
          lookahead == 'y') ADVANCE(2293);
      END_STATE();
    case 1159:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(2014);
      END_STATE();
    case 1160:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(2004);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(2294);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(1530);
      END_STATE();
    case 1161:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1063);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1595);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1077);
      END_STATE();
    case 1162:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1614);
      END_STATE();
    case 1163:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(2542);
      END_STATE();
    case 1164:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(2578);
      END_STATE();
    case 1165:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(2498);
      END_STATE();
    case 1166:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1130);
      END_STATE();
    case 1167:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(2447);
      END_STATE();
    case 1168:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(2447);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1045);
      END_STATE();
    case 1169:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(2447);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1044);
      END_STATE();
    case 1170:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(2354);
      END_STATE();
    case 1171:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(2605);
      END_STATE();
    case 1172:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(2607);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1115);
      END_STATE();
    case 1173:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(2329);
      END_STATE();
    case 1174:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(2329);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(1724);
      END_STATE();
    case 1175:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(2606);
      END_STATE();
    case 1176:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(2298);
      END_STATE();
    case 1177:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(2609);
      END_STATE();
    case 1178:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(2479);
      END_STATE();
    case 1179:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(2241);
      END_STATE();
    case 1180:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(2470);
      END_STATE();
    case 1181:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(2557);
      END_STATE();
    case 1182:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(2265);
      END_STATE();
    case 1183:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(2425);
      END_STATE();
    case 1184:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(2431);
      END_STATE();
    case 1185:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(2274);
      END_STATE();
    case 1186:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(2350);
      END_STATE();
    case 1187:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(2528);
      END_STATE();
    case 1188:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(2355);
      END_STATE();
    case 1189:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(2433);
      END_STATE();
    case 1190:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(2445);
      END_STATE();
    case 1191:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(2491);
      END_STATE();
    case 1192:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(2319);
      END_STATE();
    case 1193:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(2522);
      END_STATE();
    case 1194:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(2441);
      END_STATE();
    case 1195:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(2487);
      END_STATE();
    case 1196:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(2408);
      END_STATE();
    case 1197:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(2497);
      END_STATE();
    case 1198:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(2480);
      END_STATE();
    case 1199:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(2375);
      END_STATE();
    case 1200:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(2297);
      END_STATE();
    case 1201:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(2296);
      END_STATE();
    case 1202:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(2287);
      END_STATE();
    case 1203:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(2238);
      END_STATE();
    case 1204:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(2494);
      END_STATE();
    case 1205:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(2346);
      END_STATE();
    case 1206:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(2519);
      END_STATE();
    case 1207:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(2348);
      END_STATE();
    case 1208:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(2322);
      END_STATE();
    case 1209:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(2226);
      END_STATE();
    case 1210:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(2503);
      END_STATE();
    case 1211:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(2514);
      END_STATE();
    case 1212:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(2321);
      END_STATE();
    case 1213:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(2452);
      END_STATE();
    case 1214:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(2495);
      END_STATE();
    case 1215:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(2485);
      END_STATE();
    case 1216:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1099);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1591);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(1713);
      END_STATE();
    case 1217:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1099);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(1713);
      END_STATE();
    case 1218:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1367);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1541);
      END_STATE();
    case 1219:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(2240);
      END_STATE();
    case 1220:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1562);
      END_STATE();
    case 1221:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1562);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(1001);
      END_STATE();
    case 1222:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1562);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(1014);
      END_STATE();
    case 1223:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1102);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(1713);
      END_STATE();
    case 1224:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1369);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1376);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1541);
      END_STATE();
    case 1225:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1369);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1376);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1516);
      END_STATE();
    case 1226:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1369);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1376);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1540);
      END_STATE();
    case 1227:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1369);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1540);
      END_STATE();
    case 1228:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1348);
      END_STATE();
    case 1229:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1100);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(1713);
      END_STATE();
    case 1230:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1087);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1376);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1540);
      END_STATE();
    case 1231:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(2012);
      END_STATE();
    case 1232:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(2504);
      END_STATE();
    case 1233:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1103);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(1713);
      END_STATE();
    case 1234:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1361);
      END_STATE();
    case 1235:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(987);
      END_STATE();
    case 1236:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(2005);
      END_STATE();
    case 1237:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1705);
      END_STATE();
    case 1238:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1098);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(1713);
      END_STATE();
    case 1239:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1101);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(1713);
      END_STATE();
    case 1240:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1064);
      END_STATE();
    case 1241:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(929);
      END_STATE();
    case 1242:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1950);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1574);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1544);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(1721);
      END_STATE();
    case 1243:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1950);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1574);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1822);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(1721);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(1647);
      END_STATE();
    case 1244:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1950);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1574);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(1721);
      END_STATE();
    case 1245:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1950);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(1721);
      END_STATE();
    case 1246:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(928);
      END_STATE();
    case 1247:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1771);
      END_STATE();
    case 1248:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1850);
      END_STATE();
    case 1249:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1850);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(1171);
      END_STATE();
    case 1250:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1604);
      END_STATE();
    case 1251:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1604);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(1164);
      END_STATE();
    case 1252:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1613);
      END_STATE();
    case 1253:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1389);
      END_STATE();
    case 1254:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1772);
      END_STATE();
    case 1255:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1358);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1501);
      END_STATE();
    case 1256:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1358);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1589);
      END_STATE();
    case 1257:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1765);
      END_STATE();
    case 1258:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1773);
      END_STATE();
    case 1259:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1131);
      END_STATE();
    case 1260:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1078);
      END_STATE();
    case 1261:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1426);
      END_STATE();
    case 1262:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1426);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(1823);
      END_STATE();
    case 1263:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1795);
      END_STATE();
    case 1264:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1139);
      END_STATE();
    case 1265:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1854);
      END_STATE();
    case 1266:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1774);
      END_STATE();
    case 1267:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1143);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1887);
      END_STATE();
    case 1268:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1812);
      END_STATE();
    case 1269:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1812);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(1317);
      END_STATE();
    case 1270:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1154);
      END_STATE();
    case 1271:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1856);
      END_STATE();
    case 1272:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1831);
      END_STATE();
    case 1273:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1857);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1661);
      END_STATE();
    case 1274:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1800);
      END_STATE();
    case 1275:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1858);
      END_STATE();
    case 1276:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1388);
      END_STATE();
    case 1277:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1388);
      if (lookahead == 'Y' ||
          lookahead == 'y') ADVANCE(2293);
      END_STATE();
    case 1278:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1775);
      END_STATE();
    case 1279:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1133);
      END_STATE();
    case 1280:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1859);
      END_STATE();
    case 1281:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1859);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1663);
      END_STATE();
    case 1282:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1134);
      END_STATE();
    case 1283:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1135);
      END_STATE();
    case 1284:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1691);
      END_STATE();
    case 1285:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1075);
      END_STATE();
    case 1286:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1075);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1594);
      END_STATE();
    case 1287:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1512);
      END_STATE();
    case 1288:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1136);
      END_STATE();
    case 1289:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1137);
      END_STATE();
    case 1290:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1462);
      END_STATE();
    case 1291:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1777);
      END_STATE();
    case 1292:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1870);
      END_STATE();
    case 1293:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1094);
      END_STATE();
    case 1294:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1094);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1594);
      END_STATE();
    case 1295:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1621);
      END_STATE();
    case 1296:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1665);
      END_STATE();
    case 1297:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1157);
      END_STATE();
    case 1298:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1157);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1887);
      END_STATE();
    case 1299:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1129);
      END_STATE();
    case 1300:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1778);
      END_STATE();
    case 1301:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1865);
      END_STATE();
    case 1302:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1779);
      END_STATE();
    case 1303:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1780);
      END_STATE();
    case 1304:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1782);
      END_STATE();
    case 1305:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1704);
      END_STATE();
    case 1306:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1834);
      END_STATE();
    case 1307:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1785);
      END_STATE();
    case 1308:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1918);
      END_STATE();
    case 1309:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1956);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1376);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1542);
      END_STATE();
    case 1310:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1956);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1376);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1540);
      END_STATE();
    case 1311:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1956);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1540);
      END_STATE();
    case 1312:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1941);
      END_STATE();
    case 1313:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1599);
      END_STATE();
    case 1314:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1793);
      END_STATE();
    case 1315:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1146);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(1936);
      END_STATE();
    case 1316:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1681);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1900);
      END_STATE();
    case 1317:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(977);
      END_STATE();
    case 1318:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1836);
      END_STATE();
    case 1319:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1817);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(2559);
      END_STATE();
    case 1320:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1944);
      END_STATE();
    case 1321:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1944);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1597);
      END_STATE();
    case 1322:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1364);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1594);
      END_STATE();
    case 1323:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1682);
      END_STATE();
    case 1324:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1295);
      END_STATE();
    case 1325:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1366);
      END_STATE();
    case 1326:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1833);
      END_STATE();
    case 1327:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1683);
      END_STATE();
    case 1328:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1684);
      END_STATE();
    case 1329:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1386);
      END_STATE();
    case 1330:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1685);
      END_STATE();
    case 1331:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1088);
      END_STATE();
    case 1332:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1666);
      END_STATE();
    case 1333:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1687);
      END_STATE();
    case 1334:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1688);
      END_STATE();
    case 1335:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1813);
      END_STATE();
    case 1336:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1689);
      END_STATE();
    case 1337:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1840);
      END_STATE();
    case 1338:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1697);
      END_STATE();
    case 1339:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1365);
      END_STATE();
    case 1340:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1606);
      END_STATE();
    case 1341:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1607);
      END_STATE();
    case 1342:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1608);
      END_STATE();
    case 1343:
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(2271);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(1585);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(2382);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2255);
      END_STATE();
    case 1344:
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(2428);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1141);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1127);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(2247);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(1924);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2404);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(1405);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(1889);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(1247);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(1664);
      END_STATE();
    case 1345:
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(2332);
      END_STATE();
    case 1346:
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(2484);
      END_STATE();
    case 1347:
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(1346);
      END_STATE();
    case 1348:
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(1745);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(1432);
      END_STATE();
    case 1349:
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(1745);
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(1432);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(2008);
      END_STATE();
    case 1350:
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(1363);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(2247);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2406);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(1964);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(1247);
      END_STATE();
    case 1351:
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(1363);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(2247);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2402);
      END_STATE();
    case 1352:
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(1363);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(2247);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2402);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(1247);
      END_STATE();
    case 1353:
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(1363);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(2247);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(1155);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(1937);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(1664);
      END_STATE();
    case 1354:
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(1363);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1533);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2406);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(1247);
      END_STATE();
    case 1355:
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(1363);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2406);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(1247);
      END_STATE();
    case 1356:
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(1363);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2402);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(1247);
      END_STATE();
    case 1357:
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(1363);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(583);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(1690);
      END_STATE();
    case 1358:
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(1892);
      END_STATE();
    case 1359:
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(1455);
      END_STATE();
    case 1360:
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(1170);
      END_STATE();
    case 1361:
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(961);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(1057);
      END_STATE();
    case 1362:
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(1188);
      END_STATE();
    case 1363:
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(1878);
      END_STATE();
    case 1364:
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(1318);
      END_STATE();
    case 1365:
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(1306);
      END_STATE();
    case 1366:
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(1337);
      END_STATE();
    case 1367:
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(1337);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(1938);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(1980);
      END_STATE();
    case 1368:
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(1337);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(1953);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(1980);
      END_STATE();
    case 1369:
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(1337);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(1980);
      END_STATE();
    case 1370:
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(2524);
      END_STATE();
    case 1371:
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(2536);
      END_STATE();
    case 1372:
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(3401);
      END_STATE();
    case 1373:
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(2599);
      END_STATE();
    case 1374:
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(2595);
      END_STATE();
    case 1375:
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(2419);
      END_STATE();
    case 1376:
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(1408);
      END_STATE();
    case 1377:
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(1390);
      END_STATE();
    case 1378:
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(1997);
      END_STATE();
    case 1379:
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(1703);
      END_STATE();
    case 1380:
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(1178);
      END_STATE();
    case 1381:
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(1180);
      END_STATE();
    case 1382:
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(1633);
      END_STATE();
    case 1383:
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(1197);
      END_STATE();
    case 1384:
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(1199);
      END_STATE();
    case 1385:
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(1934);
      END_STATE();
    case 1386:
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(1275);
      END_STATE();
    case 1387:
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(1241);
      END_STATE();
    case 1388:
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(1432);
      END_STATE();
    case 1389:
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(1730);
      END_STATE();
    case 1390:
      if (lookahead == 'G' ||
          lookahead == 'g') ADVANCE(1302);
      END_STATE();
    case 1391:
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(2412);
      END_STATE();
    case 1392:
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(2222);
      END_STATE();
    case 1393:
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(2554);
      END_STATE();
    case 1394:
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(2218);
      END_STATE();
    case 1395:
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(2224);
      END_STATE();
    case 1396:
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(2221);
      END_STATE();
    case 1397:
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(2493);
      END_STATE();
    case 1398:
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(1240);
      END_STATE();
    case 1399:
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(1240);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1529);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(1235);
      END_STATE();
    case 1400:
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(1240);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1592);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(1235);
      END_STATE();
    case 1401:
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(1252);
      END_STATE();
    case 1402:
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(1162);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1648);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1787);
      END_STATE();
    case 1403:
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(1162);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1931);
      END_STATE();
    case 1404:
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(1162);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1935);
      END_STATE();
    case 1405:
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(1314);
      END_STATE();
    case 1406:
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(1313);
      END_STATE();
    case 1407:
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(1176);
      END_STATE();
    case 1408:
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(1898);
      END_STATE();
    case 1409:
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(1444);
      END_STATE();
    case 1410:
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(1335);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1648);
      END_STATE();
    case 1411:
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(1335);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1931);
      END_STATE();
    case 1412:
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(1335);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1933);
      END_STATE();
    case 1413:
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(1335);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1928);
      END_STATE();
    case 1414:
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(1335);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1649);
      END_STATE();
    case 1415:
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(1335);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1649);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1787);
      END_STATE();
    case 1416:
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(1335);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1650);
      END_STATE();
    case 1417:
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(1335);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1651);
      END_STATE();
    case 1418:
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(1335);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1652);
      END_STATE();
    case 1419:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1376);
      END_STATE();
    case 1420:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1648);
      END_STATE();
    case 1421:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1768);
      END_STATE();
    case 1422:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1768);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(990);
      END_STATE();
    case 1423:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1379);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2463);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(1258);
      END_STATE();
    case 1424:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1379);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(1258);
      END_STATE();
    case 1425:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1359);
      END_STATE();
    case 1426:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1998);
      END_STATE();
    case 1427:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1347);
      END_STATE();
    case 1428:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1612);
      END_STATE();
    case 1429:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1377);
      END_STATE();
    case 1430:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1377);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(1656);
      END_STATE();
    case 1431:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1236);
      END_STATE();
    case 1432:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1615);
      END_STATE();
    case 1433:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1058);
      END_STATE();
    case 1434:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1760);
      END_STATE();
    case 1435:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1589);
      END_STATE();
    case 1436:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1589);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1067);
      END_STATE();
    case 1437:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1059);
      END_STATE();
    case 1438:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1692);
      END_STATE();
    case 1439:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1617);
      END_STATE();
    case 1440:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(946);
      if (lookahead == 'Y' ||
          lookahead == 'y') ADVANCE(1475);
      END_STATE();
    case 1441:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1060);
      END_STATE();
    case 1442:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(998);
      END_STATE();
    case 1443:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1061);
      END_STATE();
    case 1444:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1620);
      END_STATE();
    case 1445:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1897);
      END_STATE();
    case 1446:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1111);
      END_STATE();
    case 1447:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1659);
      END_STATE();
    case 1448:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1662);
      END_STATE();
    case 1449:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1574);
      END_STATE();
    case 1450:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1574);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1544);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(1721);
      END_STATE();
    case 1451:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1574);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1822);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(1721);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(1525);
      END_STATE();
    case 1452:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1574);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(1525);
      END_STATE();
    case 1453:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1629);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1985);
      END_STATE();
    case 1454:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1930);
      END_STATE();
    case 1455:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1271);
      END_STATE();
    case 1456:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1931);
      END_STATE();
    case 1457:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1933);
      END_STATE();
    case 1458:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1928);
      END_STATE();
    case 1459:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1925);
      END_STATE();
    case 1460:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1935);
      END_STATE();
    case 1461:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(2028);
      END_STATE();
    case 1462:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1382);
      END_STATE();
    case 1463:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1999);
      END_STATE();
    case 1464:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1654);
      END_STATE();
    case 1465:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1803);
      END_STATE();
    case 1466:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1079);
      END_STATE();
    case 1467:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1667);
      END_STATE();
    case 1468:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1594);
      END_STATE();
    case 1469:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1650);
      END_STATE();
    case 1470:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1727);
      END_STATE();
    case 1471:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1655);
      END_STATE();
    case 1472:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1877);
      END_STATE();
    case 1473:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1651);
      END_STATE();
    case 1474:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1728);
      END_STATE();
    case 1475:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1658);
      END_STATE();
    case 1476:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1081);
      END_STATE();
    case 1477:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1652);
      END_STATE();
    case 1478:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1729);
      END_STATE();
    case 1479:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1660);
      END_STATE();
    case 1480:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1660);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2437);
      END_STATE();
    case 1481:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(975);
      END_STATE();
    case 1482:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1549);
      END_STATE();
    case 1483:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1731);
      END_STATE();
    case 1484:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1661);
      END_STATE();
    case 1485:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1686);
      END_STATE();
    case 1486:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1551);
      END_STATE();
    case 1487:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1733);
      END_STATE();
    case 1488:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1734);
      END_STATE();
    case 1489:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1735);
      END_STATE();
    case 1490:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1736);
      END_STATE();
    case 1491:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1110);
      END_STATE();
    case 1492:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1963);
      END_STATE();
    case 1493:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1013);
      END_STATE();
    case 1494:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1034);
      END_STATE();
    case 1495:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1968);
      END_STATE();
    case 1496:
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(1887);
      END_STATE();
    case 1497:
      if (lookahead == 'K' ||
          lookahead == 'k') ADVANCE(2259);
      END_STATE();
    case 1498:
      if (lookahead == 'K' ||
          lookahead == 'k') ADVANCE(2520);
      END_STATE();
    case 1499:
      if (lookahead == 'K' ||
          lookahead == 'k') ADVANCE(2263);
      END_STATE();
    case 1500:
      if (lookahead == 'K' ||
          lookahead == 'k') ADVANCE(1759);
      END_STATE();
    case 1501:
      if (lookahead == 'K' ||
          lookahead == 'k') ADVANCE(1165);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(1445);
      END_STATE();
    case 1502:
      if (lookahead == 'K' ||
          lookahead == 'k') ADVANCE(1307);
      END_STATE();
    case 1503:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1565);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(1590);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1108);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(1890);
      END_STATE();
    case 1504:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2463);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(1258);
      END_STATE();
    case 1505:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1168);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2414);
      END_STATE();
    case 1506:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2368);
      END_STATE();
    case 1507:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2567);
      END_STATE();
    case 1508:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2359);
      END_STATE();
    case 1509:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2459);
      END_STATE();
    case 1510:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2572);
      END_STATE();
    case 1511:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2340);
      END_STATE();
    case 1512:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2352);
      END_STATE();
    case 1513:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2483);
      END_STATE();
    case 1514:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1875);
      END_STATE();
    case 1515:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2015);
      END_STATE();
    case 1516:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1169);
      END_STATE();
    case 1517:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1504);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1124);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(1056);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(2602);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(1926);
      END_STATE();
    case 1518:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1044);
      END_STATE();
    case 1519:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1993);
      END_STATE();
    case 1520:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(978);
      END_STATE();
    case 1521:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2019);
      END_STATE();
    case 1522:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1715);
      END_STATE();
    case 1523:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1522);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2327);
      END_STATE();
    case 1524:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1009);
      END_STATE();
    case 1525:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1507);
      END_STATE();
    case 1526:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1507);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1113);
      END_STATE();
    case 1527:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2021);
      END_STATE();
    case 1528:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1972);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(1590);
      END_STATE();
    case 1529:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1972);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(1590);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1882);
      END_STATE();
    case 1530:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1508);
      END_STATE();
    case 1531:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(996);
      END_STATE();
    case 1532:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1929);
      END_STATE();
    case 1533:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(2022);
      END_STATE();
    case 1534:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1521);
      END_STATE();
    case 1535:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1461);
      END_STATE();
    case 1536:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1718);
      END_STATE();
    case 1537:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(972);
      END_STATE();
    case 1538:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1862);
      END_STATE();
    case 1539:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1259);
      END_STATE();
    case 1540:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1518);
      END_STATE();
    case 1541:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1518);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2414);
      END_STATE();
    case 1542:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1518);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(2413);
      END_STATE();
    case 1543:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1518);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(1849);
      END_STATE();
    case 1544:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1536);
      END_STATE();
    case 1545:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1179);
      END_STATE();
    case 1546:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1906);
      END_STATE();
    case 1547:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1186);
      END_STATE();
    case 1548:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1287);
      END_STATE();
    case 1549:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1329);
      END_STATE();
    case 1550:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1204);
      END_STATE();
    case 1551:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1205);
      END_STATE();
    case 1552:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1207);
      END_STATE();
    case 1553:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1210);
      END_STATE();
    case 1554:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1211);
      END_STATE();
    case 1555:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1219);
      END_STATE();
    case 1556:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1292);
      END_STATE();
    case 1557:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1332);
      END_STATE();
    case 1558:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1167);
      END_STATE();
    case 1559:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1538);
      END_STATE();
    case 1560:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1260);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1128);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(2282);
      END_STATE();
    case 1561:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1260);
      if (lookahead == 'Q' ||
          lookahead == 'q') ADVANCE(1992);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(2282);
      END_STATE();
    case 1562:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1260);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(2282);
      END_STATE();
    case 1563:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1979);
      END_STATE();
    case 1564:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1979);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(1440);
      END_STATE();
    case 1565:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(981);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(1598);
      END_STATE();
    case 1566:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1437);
      END_STATE();
    case 1567:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1035);
      END_STATE();
    case 1568:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1869);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1125);
      END_STATE();
    case 1569:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1988);
      END_STATE();
    case 1570:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1548);
      END_STATE();
    case 1571:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1989);
      END_STATE();
    case 1572:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1990);
      END_STATE();
    case 1573:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1557);
      END_STATE();
    case 1574:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1962);
      END_STATE();
    case 1575:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1962);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(1872);
      END_STATE();
    case 1576:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1567);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(1590);
      END_STATE();
    case 1577:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1995);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(1342);
      END_STATE();
    case 1578:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1005);
      END_STATE();
    case 1579:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1954);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1124);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2229);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(2602);
      END_STATE();
    case 1580:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1954);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1124);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(1056);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(2602);
      END_STATE();
    case 1581:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1954);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1124);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(1056);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(2602);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(1926);
      END_STATE();
    case 1582:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1954);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1124);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(2602);
      END_STATE();
    case 1583:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1954);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(1056);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(1926);
      END_STATE();
    case 1584:
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1250);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1125);
      if (lookahead == 'X' ||
          lookahead == 'x') ADVANCE(1072);
      END_STATE();
    case 1585:
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(1315);
      END_STATE();
    case 1586:
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(2478);
      END_STATE();
    case 1587:
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(2417);
      END_STATE();
    case 1588:
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(2325);
      END_STATE();
    case 1589:
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(1445);
      END_STATE();
    case 1590:
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(1316);
      END_STATE();
    case 1591:
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(1008);
      END_STATE();
    case 1592:
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(1590);
      END_STATE();
    case 1593:
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(1750);
      END_STATE();
    case 1594:
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(980);
      END_STATE();
    case 1595:
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(980);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(1482);
      END_STATE();
    case 1596:
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(1724);
      END_STATE();
    case 1597:
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(1492);
      END_STATE();
    case 1598:
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(1616);
      END_STATE();
    case 1599:
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(947);
      END_STATE();
    case 1600:
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(1185);
      END_STATE();
    case 1601:
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(1215);
      END_STATE();
    case 1602:
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(1433);
      END_STATE();
    case 1603:
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(1467);
      END_STATE();
    case 1604:
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(1327);
      END_STATE();
    case 1605:
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(1328);
      END_STATE();
    case 1606:
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(1330);
      END_STATE();
    case 1607:
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(1334);
      END_STATE();
    case 1608:
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(1336);
      END_STATE();
    case 1609:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(2247);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(2402);
      if (lookahead == 'V' ||
          lookahead == 'v') ADVANCE(1247);
      END_STATE();
    case 1610:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(2247);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(1155);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(1664);
      END_STATE();
    case 1611:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1041);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(1156);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(994);
      END_STATE();
    case 1612:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(2570);
      END_STATE();
    case 1613:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(2577);
      END_STATE();
    case 1614:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(2435);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(1181);
      END_STATE();
    case 1615:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(2257);
      END_STATE();
    case 1616:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(2249);
      END_STATE();
    case 1617:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(2477);
      END_STATE();
    case 1618:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(2476);
      END_STATE();
    case 1619:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(2316);
      END_STATE();
    case 1620:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(2581);
      END_STATE();
    case 1621:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(2588);
      END_STATE();
    case 1622:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(2457);
      END_STATE();
    case 1623:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(2443);
      END_STATE();
    case 1624:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(2254);
      END_STATE();
    case 1625:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(2482);
      END_STATE();
    case 1626:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(2251);
      END_STATE();
    case 1627:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(2587);
      END_STATE();
    case 1628:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(3402);
      END_STATE();
    case 1629:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(2489);
      END_STATE();
    case 1630:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(2260);
      END_STATE();
    case 1631:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(2393);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2255);
      END_STATE();
    case 1632:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(2315);
      END_STATE();
    case 1633:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(2525);
      END_STATE();
    case 1634:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(2390);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2255);
      END_STATE();
    case 1635:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1065);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2255);
      END_STATE();
    case 1636:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(2380);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2255);
      END_STATE();
    case 1637:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(2383);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2255);
      END_STATE();
    case 1638:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1119);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2255);
      END_STATE();
    case 1639:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(2389);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2255);
      END_STATE();
    case 1640:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(2381);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(2255);
      END_STATE();
    case 1641:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1117);
      END_STATE();
    case 1642:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1118);
      END_STATE();
    case 1643:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1422);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(1156);
      END_STATE();
    case 1644:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1378);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(1891);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(1272);
      END_STATE();
    case 1645:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1380);
      END_STATE();
    case 1646:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(995);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(1938);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(1980);
      END_STATE();
    case 1647:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1113);
      END_STATE();
    case 1648:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1145);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(1392);
      END_STATE();
    case 1649:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1145);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(1394);
      END_STATE();
    case 1650:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1145);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(1395);
      END_STATE();
    case 1651:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1145);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(1396);
      END_STATE();
    case 1652:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1145);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(1409);
      END_STATE();
    case 1653:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1864);
      END_STATE();
    case 1654:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1370);
      END_STATE();
    case 1655:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1371);
      END_STATE();
    case 1656:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1115);
      END_STATE();
    case 1657:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1491);
      END_STATE();
    case 1658:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1372);
      END_STATE();
    case 1659:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1855);
      END_STATE();
    case 1660:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1373);
      END_STATE();
    case 1661:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1374);
      END_STATE();
    case 1662:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1112);
      END_STATE();
    case 1663:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1375);
      END_STATE();
    case 1664:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1166);
      END_STATE();
    case 1665:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1096);
      END_STATE();
    case 1666:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1385);
      END_STATE();
    case 1667:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1472);
      END_STATE();
    case 1668:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1895);
      END_STATE();
    case 1669:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1124);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(1056);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(2602);
      END_STATE();
    case 1670:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1124);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(1056);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(2602);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(1926);
      END_STATE();
    case 1671:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1124);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(2602);
      END_STATE();
    case 1672:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1175);
      END_STATE();
    case 1673:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1125);
      END_STATE();
    case 1674:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1125);
      if (lookahead == 'X' ||
          lookahead == 'x') ADVANCE(1072);
      END_STATE();
    case 1675:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1125);
      if (lookahead == 'X' ||
          lookahead == 'x') ADVANCE(1070);
      END_STATE();
    case 1676:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1125);
      if (lookahead == 'X' ||
          lookahead == 'x') ADVANCE(1957);
      END_STATE();
    case 1677:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1874);
      END_STATE();
    case 1678:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1421);
      END_STATE();
    case 1679:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1421);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(1156);
      END_STATE();
    case 1680:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1421);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(1156);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(1464);
      END_STATE();
    case 1681:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1904);
      END_STATE();
    case 1682:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1905);
      END_STATE();
    case 1683:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1907);
      END_STATE();
    case 1684:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1912);
      END_STATE();
    case 1685:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1913);
      END_STATE();
    case 1686:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1915);
      END_STATE();
    case 1687:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1940);
      END_STATE();
    case 1688:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1917);
      END_STATE();
    case 1689:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1921);
      END_STATE();
    case 1690:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1299);
      END_STATE();
    case 1691:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1083);
      END_STATE();
    case 1692:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1080);
      END_STATE();
    case 1693:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1150);
      END_STATE();
    case 1694:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(973);
      END_STATE();
    case 1695:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1882);
      END_STATE();
    case 1696:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1387);
      END_STATE();
    case 1697:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1086);
      END_STATE();
    case 1698:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1152);
      END_STATE();
    case 1699:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1300);
      END_STATE();
    case 1700:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1000);
      END_STATE();
    case 1701:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1019);
      END_STATE();
    case 1702:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(2002);
      END_STATE();
    case 1703:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1605);
      END_STATE();
    case 1704:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1886);
      END_STATE();
    case 1705:
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(1886);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(1694);
      END_STATE();
    case 1706:
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1591);
      END_STATE();
    case 1707:
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1428);
      END_STATE();
    case 1708:
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(2294);
      END_STATE();
    case 1709:
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(2294);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(1530);
      END_STATE();
    case 1710:
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1971);
      END_STATE();
    case 1711:
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(930);
      END_STATE();
    case 1712:
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(2559);
      END_STATE();
    case 1713:
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1749);
      END_STATE();
    case 1714:
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1345);
      END_STATE();
    case 1715:
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(2006);
      END_STATE();
    case 1716:
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(2007);
      END_STATE();
    case 1717:
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1602);
      END_STATE();
    case 1718:
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(2011);
      END_STATE();
    case 1719:
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1502);
      END_STATE();
    case 1720:
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1077);
      END_STATE();
    case 1721:
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1587);
      END_STATE();
    case 1722:
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1657);
      END_STATE();
    case 1723:
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1976);
      END_STATE();
    case 1724:
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1140);
      END_STATE();
    case 1725:
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1592);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(1235);
      END_STATE();
    case 1726:
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1714);
      END_STATE();
    case 1727:
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1618);
      END_STATE();
    case 1728:
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1622);
      END_STATE();
    case 1729:
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1623);
      END_STATE();
    case 1730:
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1791);
      END_STATE();
    case 1731:
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1624);
      END_STATE();
    case 1732:
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1625);
      END_STATE();
    case 1733:
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1626);
      END_STATE();
    case 1734:
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1627);
      END_STATE();
    case 1735:
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1628);
      END_STATE();
    case 1736:
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1630);
      END_STATE();
    case 1737:
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1695);
      END_STATE();
    case 1738:
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1888);
      END_STATE();
    case 1739:
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1888);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(1530);
      END_STATE();
    case 1740:
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1888);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(1559);
      END_STATE();
    case 1741:
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1973);
      END_STATE();
    case 1742:
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1672);
      END_STATE();
    case 1743:
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1796);
      END_STATE();
    case 1744:
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1814);
      END_STATE();
    case 1745:
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1815);
      END_STATE();
    case 1746:
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1822);
      END_STATE();
    case 1747:
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1822);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(1721);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(1525);
      END_STATE();
    case 1748:
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(1558);
      END_STATE();
    case 1749:
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2448);
      END_STATE();
    case 1750:
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2267);
      END_STATE();
    case 1751:
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2472);
      END_STATE();
    case 1752:
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(2540);
      END_STATE();
    case 1753:
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(1174);
      END_STATE();
    case 1754:
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(1156);
      END_STATE();
    case 1755:
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(1744);
      END_STATE();
    case 1756:
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(1596);
      END_STATE();
    case 1757:
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(1109);
      END_STATE();
    case 1758:
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(1861);
      END_STATE();
    case 1759:
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(1799);
      END_STATE();
    case 1760:
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(1914);
      END_STATE();
    case 1761:
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(1198);
      END_STATE();
    case 1762:
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(1246);
      END_STATE();
    case 1763:
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(1173);
      END_STATE()