#include <tree_sitter/parser.h>

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#define LANGUAGE_VERSION 13
#define STATE_COUNT 2849
#define LARGE_STATE_COUNT 473
#define SYMBOL_COUNT 460
#define ALIAS_COUNT 1
#define TOKEN_COUNT 161
#define EXTERNAL_TOKEN_COUNT 8
#define FIELD_COUNT 21
#define MAX_ALIAS_SEQUENCE_LENGTH 9
#define PRODUCTION_ID_COUNT 82

enum {
  sym_identifier = 1,
  anon_sym_POUND = 2,
  sym_decimal_integer_literal = 3,
  sym_hex_integer_literal = 4,
  sym_decimal_floating_point_literal = 5,
  anon_sym_true = 6,
  anon_sym_false = 7,
  anon_sym_DQUOTE = 8,
  anon_sym_SQUOTE = 9,
  anon_sym_DQUOTE_DQUOTE_DQUOTE = 10,
  anon_sym_SQUOTE_SQUOTE_SQUOTE = 11,
  anon_sym_r_DQUOTE = 12,
  anon_sym_DOLLAR = 13,
  anon_sym_r_SQUOTE = 14,
  anon_sym_r_DQUOTE_DQUOTE_DQUOTE = 15,
  anon_sym_r_SQUOTE_SQUOTE_SQUOTE = 16,
  anon_sym_LBRACE = 17,
  anon_sym_RBRACE = 18,
  aux_sym__sub_string_test_token1 = 19,
  sym__unused_escape_sequence = 20,
  anon_sym_LBRACK = 21,
  anon_sym_COMMA = 22,
  anon_sym_RBRACK = 23,
  anon_sym_COLON = 24,
  anon_sym_null = 25,
  anon_sym_throw = 26,
  anon_sym_EQ = 27,
  anon_sym_PLUS_EQ = 28,
  anon_sym_DASH_EQ = 29,
  anon_sym_STAR_EQ = 30,
  anon_sym_SLASH_EQ = 31,
  anon_sym_PERCENT_EQ = 32,
  anon_sym_TILDE_SLASH_EQ = 33,
  anon_sym_LT_LT_EQ = 34,
  anon_sym_GT_GT_EQ = 35,
  anon_sym_GT_GT_GT_EQ = 36,
  anon_sym_AMP_EQ = 37,
  anon_sym_CARET_EQ = 38,
  anon_sym_PIPE_EQ = 39,
  anon_sym_QMARK_QMARK_EQ = 40,
  anon_sym_LPAREN = 41,
  anon_sym_RPAREN = 42,
  anon_sym_QMARK_QMARK = 43,
  anon_sym_QMARK = 44,
  anon_sym_PIPE_PIPE = 45,
  anon_sym_AMP_AMP = 46,
  sym_equality_operator = 47,
  anon_sym_LT = 48,
  anon_sym_GT = 49,
  anon_sym_LT_EQ = 50,
  anon_sym_GT_EQ = 51,
  anon_sym_PIPE = 52,
  anon_sym_CARET = 53,
  anon_sym_AMP = 54,
  anon_sym_LT_LT = 55,
  anon_sym_GT_GT = 56,
  anon_sym_GT_GT_GT = 57,
  sym__additive_operator = 58,
  anon_sym_STAR = 59,
  anon_sym_SLASH = 60,
  anon_sym_PERCENT = 61,
  anon_sym_TILDE_SLASH = 62,
  sym_increment_operator = 63,
  anon_sym_DOT_DOT_DOT = 64,
  sym_minus_operator = 65,
  sym__exclamation_operator = 66,
  anon_sym_TILDE = 67,
  anon_sym_await = 68,
  anon_sym_is = 69,
  anon_sym_as = 70,
  anon_sym_DOT = 71,
  anon_sym_QMARK_DOT = 72,
  anon_sym_DOT_DOT = 73,
  anon_sym_QMARK_DOT_DOT = 74,
  anon_sym_extends = 75,
  anon_sym_SEMI = 76,
  anon_sym_switch = 77,
  anon_sym_default = 78,
  anon_sym_do = 79,
  anon_sym_while = 80,
  anon_sym_continue = 81,
  anon_sym_yield = 82,
  anon_sym_return = 83,
  anon_sym_on = 84,
  anon_sym_try = 85,
  anon_sym_catch = 86,
  anon_sym_finally = 87,
  anon_sym_if = 88,
  anon_sym_else = 89,
  anon_sym_for = 90,
  anon_sym_in = 91,
  anon_sym_AT = 92,
  anon_sym_transitive = 93,
  anon_sym_part = 94,
  anon_sym_of = 95,
  anon_sym_EQ_EQ = 96,
  anon_sym_show = 97,
  anon_sym_hide = 98,
  anon_sym_enum = 99,
  anon_sym_abstract = 100,
  anon_sym_class = 101,
  anon_sym_extension = 102,
  anon_sym_with = 103,
  anon_sym_LBRACK_RBRACK = 104,
  anon_sym_LBRACK_RBRACK_EQ = 105,
  anon_sym_super = 106,
  sym_floating_point_type = 107,
  anon_sym_bool = 108,
  sym_void_type = 109,
  anon_sym_var = 110,
  anon_sym_async = 111,
  anon_sym_EQ_GT = 112,
  anon_sym_async_STAR = 113,
  anon_sym_sync_STAR = 114,
  anon_sym_throws = 115,
  anon_sym_POUND_BANG = 116,
  aux_sym_script_tag_token1 = 117,
  anon_sym_LF = 118,
  anon_sym_library = 119,
  sym__break_builtin = 120,
  sym__assert_builtin = 121,
  sym_case_builtin = 122,
  anon_sym_covariant = 123,
  anon_sym_deferred = 124,
  anon_sym_dynamic = 125,
  anon_sym_export = 126,
  anon_sym_factory = 127,
  anon_sym_Function = 128,
  anon_sym_get = 129,
  anon_sym_native = 130,
  anon_sym_implements = 131,
  anon_sym_import = 132,
  anon_sym_interface = 133,
  anon_sym_operator = 134,
  anon_sym_mixin = 135,
  anon_sym_required = 136,
  anon_sym_set = 137,
  anon_sym_static = 138,
  anon_sym_typedef = 139,
  anon_sym_new = 140,
  sym_const_builtin = 141,
  sym_final_builtin = 142,
  anon_sym_late = 143,
  anon_sym_external = 144,
  anon_sym_this = 145,
  sym_identifier_dollar_escaped = 146,
  anon_sym_SLASH_SLASH = 147,
  aux_sym_comment_token1 = 148,
  anon_sym_SLASH_STAR = 149,
  aux_sym_comment_token2 = 150,
  anon_sym_SLASH_SLASH_SLASH = 151,
  aux_sym_documentation_comment_token1 = 152,
  sym__automatic_semicolon = 153,
  sym__template_chars_double = 154,
  sym__template_chars_single = 155,
  sym__template_chars_double_single = 156,
  sym__template_chars_single_single = 157,
  sym__template_chars_raw_slash = 158,
  sym__block_comment = 159,
  sym__documentation_block_comment = 160,
  sym_program = 161,
  sym__top_level_definition = 162,
  sym__literal = 163,
  sym_symbol_literal = 164,
  sym_true = 165,
  sym_false = 166,
  sym_string_literal = 167,
  sym__string_literal_double_quotes = 168,
  sym__string_literal_single_quotes = 169,
  sym__string_literal_double_quotes_multiple = 170,
  sym__string_literal_single_quotes_multiple = 171,
  sym__raw_string_literal_double_quotes = 172,
  sym__raw_string_literal_single_quotes = 173,
  sym__raw_string_literal_double_quotes_multiple = 174,
  sym__raw_string_literal_single_quotes_multiple = 175,
  sym_template_substitution = 176,
  sym__sub_string_test = 177,
  sym_escape_sequence = 178,
  sym_list_literal = 179,
  sym_set_or_map_literal = 180,
  sym_pair = 181,
  sym__element = 182,
  sym_null_literal = 183,
  sym__expression = 184,
  sym__expression_without_cascade = 185,
  sym__real_expression = 186,
  sym_throw_expression = 187,
  sym_throw_expression_without_cascade = 188,
  sym_assignment_expression = 189,
  sym_assignment_expression_without_cascade = 190,
  sym_assignable_expression = 191,
  sym__assignable_selector_part = 192,
  sym__assignment_operator = 193,
  sym_lambda_expression = 194,
  sym_function_expression = 195,
  sym_if_null_expression = 196,
  aux_sym__if_null_expression = 197,
  sym_conditional_expression = 198,
  sym_logical_or_expression = 199,
  sym_logical_and_expression = 200,
  sym_equality_expression = 201,
  sym_type_cast_expression = 202,
  sym_type_test_expression = 203,
  sym_relational_expression = 204,
  sym_relational_operator = 205,
  sym_bitwise_or_expression = 206,
  sym_bitwise_xor_expression = 207,
  sym_bitwise_and_expression = 208,
  sym_shift_expression = 209,
  sym_additive_expression = 210,
  sym_multiplicative_expression = 211,
  sym_bitwise_operator = 212,
  sym__bitwise_operator = 213,
  sym_shift_operator = 214,
  sym__shift_operator = 215,
  sym_additive_operator = 216,
  sym_multiplicative_operator = 217,
  sym__multiplicative_operator = 218,
  sym__unary_expression = 219,
  sym_unary_expression = 220,
  sym__postfix_expression = 221,
  sym_postfix_expression = 222,
  sym_postfix_operator = 223,
  sym_spread_element = 224,
  sym_selector = 225,
  sym_prefix_operator = 226,
  sym_negation_operator = 227,
  sym_tilde_operator = 228,
  sym_await_expression = 229,
  sym_type_test = 230,
  sym_is_operator = 231,
  sym_type_cast = 232,
  sym_as_operator = 233,
  sym_new_expression = 234,
  sym__dot_identifier = 235,
  sym_const_object_expression = 236,
  sym__primary = 237,
  sym_parenthesized_expression = 238,
  sym_constructor_invocation = 239,
  sym_arguments = 240,
  sym__argument_list = 241,
  sym_argument = 242,
  sym_named_argument = 243,
  sym_cascade_section = 244,
  sym__cascade_subsection = 245,
  sym__cascade_assignment_section = 246,
  sym_cascade_selector = 247,
  sym_argument_part = 248,
  sym_unconditional_assignable_selector = 249,
  sym_conditional_assignable_selector = 250,
  sym__assignable_selector = 251,
  sym_type_arguments = 252,
  sym__statement = 253,
  sym_local_function_declaration = 254,
  sym_block = 255,
  sym_expression_statement = 256,
  sym_assert_statement = 257,
  sym_assertion = 258,
  sym_switch_statement = 259,
  sym_switch_block = 260,
  sym_switch_label = 261,
  sym_do_statement = 262,
  sym_break_statement = 263,
  sym_continue_statement = 264,
  sym_yield_statement = 265,
  sym_yield_each_statement = 266,
  sym_return_statement = 267,
  sym_try_statement = 268,
  sym__on_part = 269,
  sym__try_head = 270,
  sym_catch_clause = 271,
  sym_finally_clause = 272,
  sym_if_element = 273,
  sym_if_statement = 274,
  sym_while_statement = 275,
  sym_for_statement = 276,
  sym__for_loop_parts = 277,
  sym_for_element = 278,
  sym__annotation = 279,
  sym_marker_annotation = 280,
  sym_annotation = 281,
  sym_import_or_export = 282,
  sym_library_import = 283,
  sym_library_export = 284,
  sym_import_specification = 285,
  sym_part_directive = 286,
  sym_part_of_directive = 287,
  sym_uri = 288,
  sym_configurable_uri = 289,
  sym_configuration_uri = 290,
  sym_uri_test = 291,
  sym_combinator = 292,
  sym__identifier_list = 293,
  sym_enum_declaration = 294,
  sym_enum_body = 295,
  sym_enum_constant = 296,
  sym_type_alias = 297,
  sym_class_definition = 298,
  sym_extension_declaration = 299,
  sym__metadata = 300,
  sym_type_parameters = 301,
  sym_type_parameter = 302,
  sym_type_bound = 303,
  sym_superclass = 304,
  sym_mixins = 305,
  sym_mixin_application_class = 306,
  sym_mixin_application = 307,
  sym_mixin_declaration = 308,
  sym_interfaces = 309,
  sym_class_body = 310,
  sym_extension_body = 311,
  sym_getter_signature = 312,
  sym_setter_signature = 313,
  sym_method_signature = 314,
  sym_declaration = 315,
  sym_identifier_list = 316,
  sym_initialized_identifier_list = 317,
  sym_initialized_identifier = 318,
  sym_static_final_declaration_list = 319,
  sym_binary_operator = 320,
  sym_operator_signature = 321,
  sym_static_final_declaration = 322,
  sym__external_and_static = 323,
  sym__final_or_const = 324,
  sym_initializers = 325,
  sym_initializer_list_entry = 326,
  sym_field_initializer = 327,
  sym_factory_constructor_signature = 328,
  sym_redirecting_factory_constructor_signature = 329,
  sym_redirection = 330,
  sym_constructor_signature = 331,
  sym_constant_constructor_signature = 332,
  sym_scoped_identifier = 333,
  sym_initialized_variable_definition = 334,
  sym__declared_identifier = 335,
  sym__final_const_var_or_type = 336,
  sym__type = 337,
  sym__type_not_function = 338,
  sym__type_not_void_not_function = 339,
  sym_function_type = 340,
  aux_sym__function_type_tails = 341,
  sym__function_type_tail = 342,
  sym_parameter_type_list = 343,
  sym_normal_parameter_type = 344,
  sym_optional_parameter_types = 345,
  sym_optional_positional_parameter_types = 346,
  sym_named_parameter_types = 347,
  sym__named_parameter_type = 348,
  sym__type_not_void = 349,
  sym__type_not_void_list = 350,
  sym__type_name = 351,
  sym__type_dot_identifier = 352,
  sym_typed_identifier = 353,
  sym__nullable_type = 354,
  sym__var_or_type = 355,
  sym_inferred_type = 356,
  sym_function_body = 357,
  sym_function_expression_body = 358,
  sym_function_signature = 359,
  sym__formal_parameter_part = 360,
  sym_formal_parameter_list = 361,
  sym__strict_formal_parameter_list = 362,
  sym__normal_formal_parameters = 363,
  sym_optional_formal_parameters = 364,
  sym__optional_postional_formal_parameters = 365,
  sym__named_formal_parameters = 366,
  sym_formal_parameter = 367,
  sym__default_formal_parameter = 368,
  sym__default_named_parameter = 369,
  sym__normal_formal_parameter = 370,
  sym__function_formal_parameter = 371,
  sym__simple_formal_parameter = 372,
  sym_super_formal_parameter = 373,
  sym_constructor_param = 374,
  sym_local_variable_declaration = 375,
  sym_script_tag = 376,
  sym_library_name = 377,
  sym_dotted_identifier_list = 378,
  sym_qualified = 379,
  sym__as = 380,
  sym__covariant = 381,
  sym__deferred = 382,
  sym__export = 383,
  sym__external = 384,
  sym__factory = 385,
  sym__function_builtin_identifier = 386,
  sym__get = 387,
  sym__native = 388,
  sym__implements = 389,
  sym__import = 390,
  sym__operator = 391,
  sym__mixin = 392,
  sym__required = 393,
  sym__set = 394,
  sym__static = 395,
  sym__typedef = 396,
  sym__new_builtin = 397,
  sym__late_builtin = 398,
  sym__external_builtin = 399,
  sym_this = 400,
  sym_super = 401,
  sym_label = 402,
  sym__semicolon = 403,
  sym_comment = 404,
  sym_documentation_comment = 405,
  aux_sym_program_repeat1 = 406,
  aux_sym_program_repeat2 = 407,
  aux_sym_program_repeat3 = 408,
  aux_sym_program_repeat4 = 409,
  aux_sym_program_repeat5 = 410,
  aux_sym_string_literal_repeat1 = 411,
  aux_sym__string_literal_double_quotes_repeat1 = 412,
  aux_sym__string_literal_single_quotes_repeat1 = 413,
  aux_sym__string_literal_double_quotes_multiple_repeat1 = 414,
  aux_sym__string_literal_single_quotes_multiple_repeat1 = 415,
  aux_sym__raw_string_literal_double_quotes_repeat1 = 416,
  aux_sym__raw_string_literal_single_quotes_repeat1 = 417,
  aux_sym__raw_string_literal_double_quotes_multiple_repeat1 = 418,
  aux_sym__raw_string_literal_single_quotes_multiple_repeat1 = 419,
  aux_sym_list_literal_repeat1 = 420,
  aux_sym__expression_repeat1 = 421,
  aux_sym__assignable_selector_part_repeat1 = 422,
  aux_sym_inferred_parameters_repeat1 = 423,
  aux_sym_logical_or_expression_repeat1 = 424,
  aux_sym_logical_and_expression_repeat1 = 425,
  aux_sym_bitwise_or_expression_repeat1 = 426,
  aux_sym_bitwise_xor_expression_repeat1 = 427,
  aux_sym_bitwise_and_expression_repeat1 = 428,
  aux_sym_shift_expression_repeat1 = 429,
  aux_sym_additive_expression_repeat1 = 430,
  aux_sym_multiplicative_expression_repeat1 = 431,
  aux_sym__argument_list_repeat1 = 432,
  aux_sym__argument_list_repeat2 = 433,
  aux_sym__argument_list_repeat3 = 434,
  aux_sym_cascade_section_repeat1 = 435,
  aux_sym_cascade_section_repeat2 = 436,
  aux_sym_type_arguments_repeat1 = 437,
  aux_sym_switch_block_repeat1 = 438,
  aux_sym_switch_case_repeat1 = 439,
  aux_sym_try_statement_repeat1 = 440,
  aux_sym__for_loop_parts_repeat1 = 441,
  aux_sym__for_loop_parts_repeat2 = 442,
  aux_sym_library_export_repeat1 = 443,
  aux_sym_configurable_uri_repeat1 = 444,
  aux_sym_enum_body_repeat1 = 445,
  aux_sym__metadata_repeat1 = 446,
  aux_sym_type_parameters_repeat1 = 447,
  aux_sym_class_body_repeat1 = 448,
  aux_sym_extension_body_repeat1 = 449,
  aux_sym_initialized_identifier_list_repeat1 = 450,
  aux_sym_static_final_declaration_list_repeat1 = 451,
  aux_sym_initializers_repeat1 = 452,
  aux_sym_factory_constructor_signature_repeat1 = 453,
  aux_sym_parameter_type_list_repeat1 = 454,
  aux_sym_named_parameter_types_repeat1 = 455,
  aux_sym__type_not_void_list_repeat1 = 456,
  aux_sym__normal_formal_parameters_repeat1 = 457,
  aux_sym_positional_parameters_repeat1 = 458,
  aux_sym__named_formal_parameters_repeat1 = 459,
  alias_sym_type_identifier = 460,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym_identifier] = "identifier",
  [anon_sym_POUND] = "#",
  [sym_decimal_integer_literal] = "decimal_integer_literal",
  [sym_hex_integer_literal] = "hex_integer_literal",
  [sym_decimal_floating_point_literal] = "decimal_floating_point_literal",
  [anon_sym_true] = "true",
  [anon_sym_false] = "false",
  [anon_sym_DQUOTE] = "\"",
  [anon_sym_SQUOTE] = "'",
  [anon_sym_DQUOTE_DQUOTE_DQUOTE] = "\"\"\"",
  [anon_sym_SQUOTE_SQUOTE_SQUOTE] = "'''",
  [anon_sym_r_DQUOTE] = "r\"",
  [anon_sym_DOLLAR] = "$",
  [anon_sym_r_SQUOTE] = "r'",
  [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = "r\"\"\"",
  [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = "r'''",
  [anon_sym_LBRACE] = "{",
  [anon_sym_RBRACE] = "}",
  [aux_sym__sub_string_test_token1] = "_sub_string_test_token1",
  [sym__unused_escape_sequence] = "_unused_escape_sequence",
  [anon_sym_LBRACK] = "[",
  [anon_sym_COMMA] = ",",
  [anon_sym_RBRACK] = "]",
  [anon_sym_COLON] = ":",
  [anon_sym_null] = "null",
  [anon_sym_throw] = "throw",
  [anon_sym_EQ] = "=",
  [anon_sym_PLUS_EQ] = "+=",
  [anon_sym_DASH_EQ] = "-=",
  [anon_sym_STAR_EQ] = "*=",
  [anon_sym_SLASH_EQ] = "/=",
  [anon_sym_PERCENT_EQ] = "%=",
  [anon_sym_TILDE_SLASH_EQ] = "~/=",
  [anon_sym_LT_LT_EQ] = "<<=",
  [anon_sym_GT_GT_EQ] = ">>=",
  [anon_sym_GT_GT_GT_EQ] = ">>>=",
  [anon_sym_AMP_EQ] = "&=",
  [anon_sym_CARET_EQ] = "^=",
  [anon_sym_PIPE_EQ] = "|=",
  [anon_sym_QMARK_QMARK_EQ] = "\?\?=",
  [anon_sym_LPAREN] = "(",
  [anon_sym_RPAREN] = ")",
  [anon_sym_QMARK_QMARK] = "\?\?",
  [anon_sym_QMARK] = "\?",
  [anon_sym_PIPE_PIPE] = "||",
  [anon_sym_AMP_AMP] = "&&",
  [sym_equality_operator] = "equality_operator",
  [anon_sym_LT] = "<",
  [anon_sym_GT] = ">",
  [anon_sym_LT_EQ] = "<=",
  [anon_sym_GT_EQ] = ">=",
  [anon_sym_PIPE] = "|",
  [anon_sym_CARET] = "^",
  [anon_sym_AMP] = "&",
  [anon_sym_LT_LT] = "<<",
  [anon_sym_GT_GT] = ">>",
  [anon_sym_GT_GT_GT] = ">>>",
  [sym__additive_operator] = "_additive_operator",
  [anon_sym_STAR] = "*",
  [anon_sym_SLASH] = "/",
  [anon_sym_PERCENT] = "%",
  [anon_sym_TILDE_SLASH] = "~/",
  [sym_increment_operator] = "increment_operator",
  [anon_sym_DOT_DOT_DOT] = "...",
  [sym_minus_operator] = "minus_operator",
  [sym__exclamation_operator] = "_exclamation_operator",
  [anon_sym_TILDE] = "~",
  [anon_sym_await] = "await",
  [anon_sym_is] = "is",
  [anon_sym_as] = "as",
  [anon_sym_DOT] = ".",
  [anon_sym_QMARK_DOT] = "\?.",
  [anon_sym_DOT_DOT] = "..",
  [anon_sym_QMARK_DOT_DOT] = "\?..",
  [anon_sym_extends] = "extends",
  [anon_sym_SEMI] = ";",
  [anon_sym_switch] = "switch",
  [anon_sym_default] = "default",
  [anon_sym_do] = "do",
  [anon_sym_while] = "while",
  [anon_sym_continue] = "continue",
  [anon_sym_yield] = "yield",
  [anon_sym_return] = "return",
  [anon_sym_on] = "on",
  [anon_sym_try] = "try",
  [anon_sym_catch] = "catch",
  [anon_sym_finally] = "finally",
  [anon_sym_if] = "if",
  [anon_sym_else] = "else",
  [anon_sym_for] = "for",
  [anon_sym_in] = "in",
  [anon_sym_AT] = "@",
  [anon_sym_transitive] = "transitive",
  [anon_sym_part] = "part",
  [anon_sym_of] = "of",
  [anon_sym_EQ_EQ] = "==",
  [anon_sym_show] = "show",
  [anon_sym_hide] = "hide",
  [anon_sym_enum] = "enum",
  [anon_sym_abstract] = "abstract",
  [anon_sym_class] = "class",
  [anon_sym_extension] = "extension",
  [anon_sym_with] = "with",
  [anon_sym_LBRACK_RBRACK] = "[]",
  [anon_sym_LBRACK_RBRACK_EQ] = "[]=",
  [anon_sym_super] = "super",
  [sym_floating_point_type] = "floating_point_type",
  [anon_sym_bool] = "bool",
  [sym_void_type] = "void_type",
  [anon_sym_var] = "var",
  [anon_sym_async] = "async",
  [anon_sym_EQ_GT] = "=>",
  [anon_sym_async_STAR] = "async*",
  [anon_sym_sync_STAR] = "sync*",
  [anon_sym_throws] = "throws",
  [anon_sym_POUND_BANG] = "#!",
  [aux_sym_script_tag_token1] = "script_tag_token1",
  [anon_sym_LF] = "\n",
  [anon_sym_library] = "library",
  [sym__break_builtin] = "_break_builtin",
  [sym__assert_builtin] = "_assert_builtin",
  [sym_case_builtin] = "case_builtin",
  [anon_sym_covariant] = "covariant",
  [anon_sym_deferred] = "deferred",
  [anon_sym_dynamic] = "dynamic",
  [anon_sym_export] = "export",
  [anon_sym_factory] = "factory",
  [anon_sym_Function] = "Function",
  [anon_sym_get] = "get",
  [anon_sym_native] = "native",
  [anon_sym_implements] = "implements",
  [anon_sym_import] = "import",
  [anon_sym_interface] = "interface",
  [anon_sym_operator] = "operator",
  [anon_sym_mixin] = "mixin",
  [anon_sym_required] = "required",
  [anon_sym_set] = "set",
  [anon_sym_static] = "static",
  [anon_sym_typedef] = "typedef",
  [anon_sym_new] = "new",
  [sym_const_builtin] = "const_builtin",
  [sym_final_builtin] = "final_builtin",
  [anon_sym_late] = "late",
  [anon_sym_external] = "external",
  [anon_sym_this] = "this",
  [sym_identifier_dollar_escaped] = "identifier_dollar_escaped",
  [anon_sym_SLASH_SLASH] = "//",
  [aux_sym_comment_token1] = "comment_token1",
  [anon_sym_SLASH_STAR] = "/*",
  [aux_sym_comment_token2] = "comment_token2",
  [anon_sym_SLASH_SLASH_SLASH] = "///",
  [aux_sym_documentation_comment_token1] = "documentation_comment_token1",
  [sym__automatic_semicolon] = "_automatic_semicolon",
  [sym__template_chars_double] = "_template_chars_double",
  [sym__template_chars_single] = "_template_chars_single",
  [sym__template_chars_double_single] = "_template_chars_double_single",
  [sym__template_chars_single_single] = "_template_chars_single_single",
  [sym__template_chars_raw_slash] = "_template_chars_raw_slash",
  [sym__block_comment] = "_block_comment",
  [sym__documentation_block_comment] = "_documentation_block_comment",
  [sym_program] = "program",
  [sym__top_level_definition] = "_top_level_definition",
  [sym__literal] = "_literal",
  [sym_symbol_literal] = "symbol_literal",
  [sym_true] = "true",
  [sym_false] = "false",
  [sym_string_literal] = "string_literal",
  [sym__string_literal_double_quotes] = "_string_literal_double_quotes",
  [sym__string_literal_single_quotes] = "_string_literal_single_quotes",
  [sym__string_literal_double_quotes_multiple] = "_string_literal_double_quotes_multiple",
  [sym__string_literal_single_quotes_multiple] = "_string_literal_single_quotes_multiple",
  [sym__raw_string_literal_double_quotes] = "_raw_string_literal_double_quotes",
  [sym__raw_string_literal_single_quotes] = "_raw_string_literal_single_quotes",
  [sym__raw_string_literal_double_quotes_multiple] = "_raw_string_literal_double_quotes_multiple",
  [sym__raw_string_literal_single_quotes_multiple] = "_raw_string_literal_single_quotes_multiple",
  [sym_template_substitution] = "template_substitution",
  [sym__sub_string_test] = "_sub_string_test",
  [sym_escape_sequence] = "escape_sequence",
  [sym_list_literal] = "list_literal",
  [sym_set_or_map_literal] = "set_or_map_literal",
  [sym_pair] = "pair",
  [sym__element] = "_element",
  [sym_null_literal] = "null_literal",
  [sym__expression] = "_expression",
  [sym__expression_without_cascade] = "_expression_without_cascade",
  [sym__real_expression] = "_real_expression",
  [sym_throw_expression] = "throw_expression",
  [sym_throw_expression_without_cascade] = "throw_expression_without_cascade",
  [sym_assignment_expression] = "assignment_expression",
  [sym_assignment_expression_without_cascade] = "assignment_expression_without_cascade",
  [sym_assignable_expression] = "assignable_expression",
  [sym__assignable_selector_part] = "_assignable_selector_part",
  [sym__assignment_operator] = "_assignment_operator",
  [sym_lambda_expression] = "lambda_expression",
  [sym_function_expression] = "function_expression",
  [sym_if_null_expression] = "if_null_expression",
  [aux_sym__if_null_expression] = "_if_null_expression",
  [sym_conditional_expression] = "conditional_expression",
  [sym_logical_or_expression] = "logical_or_expression",
  [sym_logical_and_expression] = "logical_and_expression",
  [sym_equality_expression] = "equality_expression",
  [sym_type_cast_expression] = "type_cast_expression",
  [sym_type_test_expression] = "type_test_expression",
  [sym_relational_expression] = "relational_expression",
  [sym_relational_operator] = "relational_operator",
  [sym_bitwise_or_expression] = "bitwise_or_expression",
  [sym_bitwise_xor_expression] = "bitwise_xor_expression",
  [sym_bitwise_and_expression] = "bitwise_and_expression",
  [sym_shift_expression] = "shift_expression",
  [sym_additive_expression] = "additive_expression",
  [sym_multiplicative_expression] = "multiplicative_expression",
  [sym_bitwise_operator] = "bitwise_operator",
  [sym__bitwise_operator] = "_bitwise_operator",
  [sym_shift_operator] = "shift_operator",
  [sym__shift_operator] = "_shift_operator",
  [sym_additive_operator] = "additive_operator",
  [sym_multiplicative_operator] = "multiplicative_operator",
  [sym__multiplicative_operator] = "_multiplicative_operator",
  [sym__unary_expression] = "_unary_expression",
  [sym_unary_expression] = "unary_expression",
  [sym__postfix_expression] = "_postfix_expression",
  [sym_postfix_expression] = "postfix_expression",
  [sym_postfix_operator] = "postfix_operator",
  [sym_spread_element] = "spread_element",
  [sym_selector] = "selector",
  [sym_prefix_operator] = "prefix_operator",
  [sym_negation_operator] = "negation_operator",
  [sym_tilde_operator] = "tilde_operator",
  [sym_await_expression] = "await_expression",
  [sym_type_test] = "type_test",
  [sym_is_operator] = "is_operator",
  [sym_type_cast] = "type_cast",
  [sym_as_operator] = "as_operator",
  [sym_new_expression] = "new_expression",
  [sym__dot_identifier] = "_dot_identifier",
  [sym_const_object_expression] = "const_object_expression",
  [sym__primary] = "_primary",
  [sym_parenthesized_expression] = "parenthesized_expression",
  [sym_constructor_invocation] = "constructor_invocation",
  [sym_arguments] = "arguments",
  [sym__argument_list] = "_argument_list",
  [sym_argument] = "argument",
  [sym_named_argument] = "named_argument",
  [sym_cascade_section] = "cascade_section",
  [sym__cascade_subsection] = "_cascade_subsection",
  [sym__cascade_assignment_section] = "_cascade_assignment_section",
  [sym_cascade_selector] = "cascade_selector",
  [sym_argument_part] = "argument_part",
  [sym_unconditional_assignable_selector] = "unconditional_assignable_selector",
  [sym_conditional_assignable_selector] = "conditional_assignable_selector",
  [sym__assignable_selector] = "_assignable_selector",
  [sym_type_arguments] = "type_arguments",
  [sym__statement] = "_statement",
  [sym_local_function_declaration] = "local_function_declaration",
  [sym_block] = "block",
  [sym_expression_statement] = "expression_statement",
  [sym_assert_statement] = "assert_statement",
  [sym_assertion] = "assertion",
  [sym_switch_statement] = "switch_statement",
  [sym_switch_block] = "switch_block",
  [sym_switch_label] = "switch_label",
  [sym_do_statement] = "do_statement",
  [sym_break_statement] = "break_statement",
  [sym_continue_statement] = "continue_statement",
  [sym_yield_statement] = "yield_statement",
  [sym_yield_each_statement] = "yield_each_statement",
  [sym_return_statement] = "return_statement",
  [sym_try_statement] = "try_statement",
  [sym__on_part] = "_on_part",
  [sym__try_head] = "_try_head",
  [sym_catch_clause] = "catch_clause",
  [sym_finally_clause] = "finally_clause",
  [sym_if_element] = "if_element",
  [sym_if_statement] = "if_statement",
  [sym_while_statement] = "while_statement",
  [sym_for_statement] = "for_statement",
  [sym__for_loop_parts] = "_for_loop_parts",
  [sym_for_element] = "for_element",
  [sym__annotation] = "_annotation",
  [sym_marker_annotation] = "marker_annotation",
  [sym_annotation] = "annotation",
  [sym_import_or_export] = "import_or_export",
  [sym_library_import] = "library_import",
  [sym_library_export] = "library_export",
  [sym_import_specification] = "import_specification",
  [sym_part_directive] = "part_directive",
  [sym_part_of_directive] = "part_of_directive",
  [sym_uri] = "uri",
  [sym_configurable_uri] = "configurable_uri",
  [sym_configuration_uri] = "configuration_uri",
  [sym_uri_test] = "uri_test",
  [sym_combinator] = "combinator",
  [sym__identifier_list] = "_identifier_list",
  [sym_enum_declaration] = "enum_declaration",
  [sym_enum_body] = "enum_body",
  [sym_enum_constant] = "enum_constant",
  [sym_type_alias] = "type_alias",
  [sym_class_definition] = "class_definition",
  [sym_extension_declaration] = "extension_declaration",
  [sym__metadata] = "_metadata",
  [sym_type_parameters] = "type_parameters",
  [sym_type_parameter] = "type_parameter",
  [sym_type_bound] = "type_bound",
  [sym_superclass] = "superclass",
  [sym_mixins] = "mixins",
  [sym_mixin_application_class] = "mixin_application_class",
  [sym_mixin_application] = "mixin_application",
  [sym_mixin_declaration] = "mixin_declaration",
  [sym_interfaces] = "interfaces",
  [sym_class_body] = "class_body",
  [sym_extension_body] = "extension_body",
  [sym_getter_signature] = "getter_signature",
  [sym_setter_signature] = "setter_signature",
  [sym_method_signature] = "method_signature",
  [sym_declaration] = "declaration",
  [sym_identifier_list] = "identifier_list",
  [sym_initialized_identifier_list] = "initialized_identifier_list",
  [sym_initialized_identifier] = "initialized_identifier",
  [sym_static_final_declaration_list] = "static_final_declaration_list",
  [sym_binary_operator] = "binary_operator",
  [sym_operator_signature] = "operator_signature",
  [sym_static_final_declaration] = "static_final_declaration",
  [sym__external_and_static] = "_external_and_static",
  [sym__final_or_const] = "_final_or_const",
  [sym_initializers] = "initializers",
  [sym_initializer_list_entry] = "initializer_list_entry",
  [sym_field_initializer] = "field_initializer",
  [sym_factory_constructor_signature] = "factory_constructor_signature",
  [sym_redirecting_factory_constructor_signature] = "redirecting_factory_constructor_signature",
  [sym_redirection] = "redirection",
  [sym_constructor_signature] = "constructor_signature",
  [sym_constant_constructor_signature] = "constant_constructor_signature",
  [sym_scoped_identifier] = "scoped_identifier",
  [sym_initialized_variable_definition] = "initialized_variable_definition",
  [sym__declared_identifier] = "_declared_identifier",
  [sym__final_const_var_or_type] = "_final_const_var_or_type",
  [sym__type] = "_type",
  [sym__type_not_function] = "_type_not_function",
  [sym__type_not_void_not_function] = "_type_not_void_not_function",
  [sym_function_type] = "function_type",
  [aux_sym__function_type_tails] = "_function_type_tails",
  [sym__function_type_tail] = "_function_type_tail",
  [sym_parameter_type_list] = "parameter_type_list",
  [sym_normal_parameter_type] = "normal_parameter_type",
  [sym_optional_parameter_types] = "optional_parameter_types",
  [sym_optional_positional_parameter_types] = "optional_positional_parameter_types",
  [sym_named_parameter_types] = "named_parameter_types",
  [sym__named_parameter_type] = "_named_parameter_type",
  [sym__type_not_void] = "_type_not_void",
  [sym__type_not_void_list] = "_type_not_void_list",
  [sym__type_name] = "_type_name",
  [sym__type_dot_identifier] = "_type_dot_identifier",
  [sym_typed_identifier] = "typed_identifier",
  [sym__nullable_type] = "_nullable_type",
  [sym__var_or_type] = "_var_or_type",
  [sym_inferred_type] = "inferred_type",
  [sym_function_body] = "function_body",
  [sym_function_expression_body] = "function_expression_body",
  [sym_function_signature] = "function_signature",
  [sym__formal_parameter_part] = "_formal_parameter_part",
  [sym_formal_parameter_list] = "formal_parameter_list",
  [sym__strict_formal_parameter_list] = "_strict_formal_parameter_list",
  [sym__normal_formal_parameters] = "_normal_formal_parameters",
  [sym_optional_formal_parameters] = "optional_formal_parameters",
  [sym__optional_postional_formal_parameters] = "_optional_postional_formal_parameters",
  [sym__named_formal_parameters] = "_named_formal_parameters",
  [sym_formal_parameter] = "formal_parameter",
  [sym__default_formal_parameter] = "_default_formal_parameter",
  [sym__default_named_parameter] = "_default_named_parameter",
  [sym__normal_formal_parameter] = "_normal_formal_parameter",
  [sym__function_formal_parameter] = "_function_formal_parameter",
  [sym__simple_formal_parameter] = "_simple_formal_parameter",
  [sym_super_formal_parameter] = "super_formal_parameter",
  [sym_constructor_param] = "constructor_param",
  [sym_local_variable_declaration] = "local_variable_declaration",
  [sym_script_tag] = "script_tag",
  [sym_library_name] = "library_name",
  [sym_dotted_identifier_list] = "dotted_identifier_list",
  [sym_qualified] = "qualified",
  [sym__as] = "_as",
  [sym__covariant] = "_covariant",
  [sym__deferred] = "_deferred",
  [sym__export] = "_export",
  [sym__external] = "_external",
  [sym__factory] = "_factory",
  [sym__function_builtin_identifier] = "_function_builtin_identifier",
  [sym__get] = "_get",
  [sym__native] = "_native",
  [sym__implements] = "_implements",
  [sym__import] = "_import",
  [sym__operator] = "_operator",
  [sym__mixin] = "_mixin",
  [sym__required] = "_required",
  [sym__set] = "_set",
  [sym__static] = "_static",
  [sym__typedef] = "_typedef",
  [sym__new_builtin] = "_new_builtin",
  [sym__late_builtin] = "_late_builtin",
  [sym__external_builtin] = "_external_builtin",
  [sym_this] = "this",
  [sym_super] = "super",
  [sym_label] = "label",
  [sym__semicolon] = "_semicolon",
  [sym_comment] = "comment",
  [sym_documentation_comment] = "documentation_comment",
  [aux_sym_program_repeat1] = "program_repeat1",
  [aux_sym_program_repeat2] = "program_repeat2",
  [aux_sym_program_repeat3] = "program_repeat3",
  [aux_sym_program_repeat4] = "program_repeat4",
  [aux_sym_program_repeat5] = "program_repeat5",
  [aux_sym_string_literal_repeat1] = "string_literal_repeat1",
  [aux_sym__string_literal_double_quotes_repeat1] = "_string_literal_double_quotes_repeat1",
  [aux_sym__string_literal_single_quotes_repeat1] = "_string_literal_single_quotes_repeat1",
  [aux_sym__string_literal_double_quotes_multiple_repeat1] = "_string_literal_double_quotes_multiple_repeat1",
  [aux_sym__string_literal_single_quotes_multiple_repeat1] = "_string_literal_single_quotes_multiple_repeat1",
  [aux_sym__raw_string_literal_double_quotes_repeat1] = "_raw_string_literal_double_quotes_repeat1",
  [aux_sym__raw_string_literal_single_quotes_repeat1] = "_raw_string_literal_single_quotes_repeat1",
  [aux_sym__raw_string_literal_double_quotes_multiple_repeat1] = "_raw_string_literal_double_quotes_multiple_repeat1",
  [aux_sym__raw_string_literal_single_quotes_multiple_repeat1] = "_raw_string_literal_single_quotes_multiple_repeat1",
  [aux_sym_list_literal_repeat1] = "list_literal_repeat1",
  [aux_sym__expression_repeat1] = "_expression_repeat1",
  [aux_sym__assignable_selector_part_repeat1] = "_assignable_selector_part_repeat1",
  [aux_sym_inferred_parameters_repeat1] = "inferred_parameters_repeat1",
  [aux_sym_logical_or_expression_repeat1] = "logical_or_expression_repeat1",
  [aux_sym_logical_and_expression_repeat1] = "logical_and_expression_repeat1",
  [aux_sym_bitwise_or_expression_repeat1] = "bitwise_or_expression_repeat1",
  [aux_sym_bitwise_xor_expression_repeat1] = "bitwise_xor_expression_repeat1",
  [aux_sym_bitwise_and_expression_repeat1] = "bitwise_and_expression_repeat1",
  [aux_sym_shift_expression_repeat1] = "shift_expression_repeat1",
  [aux_sym_additive_expression_repeat1] = "additive_expression_repeat1",
  [aux_sym_multiplicative_expression_repeat1] = "multiplicative_expression_repeat1",
  [aux_sym__argument_list_repeat1] = "_argument_list_repeat1",
  [aux_sym__argument_list_repeat2] = "_argument_list_repeat2",
  [aux_sym__argument_list_repeat3] = "_argument_list_repeat3",
  [aux_sym_cascade_section_repeat1] = "cascade_section_repeat1",
  [aux_sym_cascade_section_repeat2] = "cascade_section_repeat2",
  [aux_sym_type_arguments_repeat1] = "type_arguments_repeat1",
  [aux_sym_switch_block_repeat1] = "switch_block_repeat1",
  [aux_sym_switch_case_repeat1] = "switch_case_repeat1",
  [aux_sym_try_statement_repeat1] = "try_statement_repeat1",
  [aux_sym__for_loop_parts_repeat1] = "_for_loop_parts_repeat1",
  [aux_sym__for_loop_parts_repeat2] = "_for_loop_parts_repeat2",
  [aux_sym_library_export_repeat1] = "library_export_repeat1",
  [aux_sym_configurable_uri_repeat1] = "configurable_uri_repeat1",
  [aux_sym_enum_body_repeat1] = "enum_body_repeat1",
  [aux_sym__metadata_repeat1] = "_metadata_repeat1",
  [aux_sym_type_parameters_repeat1] = "type_parameters_repeat1",
  [aux_sym_class_body_repeat1] = "class_body_repeat1",
  [aux_sym_extension_body_repeat1] = "extension_body_repeat1",
  [aux_sym_initialized_identifier_list_repeat1] = "initialized_identifier_list_repeat1",
  [aux_sym_static_final_declaration_list_repeat1] = "static_final_declaration_list_repeat1",
  [aux_sym_initializers_repeat1] = "initializers_repeat1",
  [aux_sym_factory_constructor_signature_repeat1] = "factory_constructor_signature_repeat1",
  [aux_sym_parameter_type_list_repeat1] = "parameter_type_list_repeat1",
  [aux_sym_named_parameter_types_repeat1] = "named_parameter_types_repeat1",
  [aux_sym__type_not_void_list_repeat1] = "_type_not_void_list_repeat1",
  [aux_sym__normal_formal_parameters_repeat1] = "_normal_formal_parameters_repeat1",
  [aux_sym_positional_parameters_repeat1] = "positional_parameters_repeat1",
  [aux_sym__named_formal_parameters_repeat1] = "_named_formal_parameters_repeat1",
  [alias_sym_type_identifier] = "type_identifier",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym_identifier] = sym_identifier,
  [anon_sym_POUND] = anon_sym_POUND,
  [sym_decimal_integer_literal] = sym_decimal_integer_literal,
  [sym_hex_integer_literal] = sym_hex_integer_literal,
  [sym_decimal_floating_point_literal] = sym_decimal_floating_point_literal,
  [anon_sym_true] = anon_sym_true,
  [anon_sym_false] = anon_sym_false,
  [anon_sym_DQUOTE] = anon_sym_DQUOTE,
  [anon_sym_SQUOTE] = anon_sym_SQUOTE,
  [anon_sym_DQUOTE_DQUOTE_DQUOTE] = anon_sym_DQUOTE_DQUOTE_DQUOTE,
  [anon_sym_SQUOTE_SQUOTE_SQUOTE] = anon_sym_SQUOTE_SQUOTE_SQUOTE,
  [anon_sym_r_DQUOTE] = anon_sym_r_DQUOTE,
  [anon_sym_DOLLAR] = anon_sym_DOLLAR,
  [anon_sym_r_SQUOTE] = anon_sym_r_SQUOTE,
  [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = anon_sym_r_DQUOTE_DQUOTE_DQUOTE,
  [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = anon_sym_r_SQUOTE_SQUOTE_SQUOTE,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [aux_sym__sub_string_test_token1] = aux_sym__sub_string_test_token1,
  [sym__unused_escape_sequence] = sym__unused_escape_sequence,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_null] = anon_sym_null,
  [anon_sym_throw] = anon_sym_throw,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_PLUS_EQ] = anon_sym_PLUS_EQ,
  [anon_sym_DASH_EQ] = anon_sym_DASH_EQ,
  [anon_sym_STAR_EQ] = anon_sym_STAR_EQ,
  [anon_sym_SLASH_EQ] = anon_sym_SLASH_EQ,
  [anon_sym_PERCENT_EQ] = anon_sym_PERCENT_EQ,
  [anon_sym_TILDE_SLASH_EQ] = anon_sym_TILDE_SLASH_EQ,
  [anon_sym_LT_LT_EQ] = anon_sym_LT_LT_EQ,
  [anon_sym_GT_GT_EQ] = anon_sym_GT_GT_EQ,
  [anon_sym_GT_GT_GT_EQ] = anon_sym_GT_GT_GT_EQ,
  [anon_sym_AMP_EQ] = anon_sym_AMP_EQ,
  [anon_sym_CARET_EQ] = anon_sym_CARET_EQ,
  [anon_sym_PIPE_EQ] = anon_sym_PIPE_EQ,
  [anon_sym_QMARK_QMARK_EQ] = anon_sym_QMARK_QMARK_EQ,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_QMARK_QMARK] = anon_sym_QMARK_QMARK,
  [anon_sym_QMARK] = anon_sym_QMARK,
  [anon_sym_PIPE_PIPE] = anon_sym_PIPE_PIPE,
  [anon_sym_AMP_AMP] = anon_sym_AMP_AMP,
  [sym_equality_operator] = sym_equality_operator,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_GT] = anon_sym_GT,
  [anon_sym_LT_EQ] = anon_sym_LT_EQ,
  [anon_sym_GT_EQ] = anon_sym_GT_EQ,
  [anon_sym_PIPE] = anon_sym_PIPE,
  [anon_sym_CARET] = anon_sym_CARET,
  [anon_sym_AMP] = anon_sym_AMP,
  [anon_sym_LT_LT] = anon_sym_LT_LT,
  [anon_sym_GT_GT] = anon_sym_GT_GT,
  [anon_sym_GT_GT_GT] = anon_sym_GT_GT_GT,
  [sym__additive_operator] = sym__additive_operator,
  [anon_sym_STAR] = anon_sym_STAR,
  [anon_sym_SLASH] = anon_sym_SLASH,
  [anon_sym_PERCENT] = anon_sym_PERCENT,
  [anon_sym_TILDE_SLASH] = anon_sym_TILDE_SLASH,
  [sym_increment_operator] = sym_increment_operator,
  [anon_sym_DOT_DOT_DOT] = anon_sym_DOT_DOT_DOT,
  [sym_minus_operator] = sym_minus_operator,
  [sym__exclamation_operator] = sym__exclamation_operator,
  [anon_sym_TILDE] = anon_sym_TILDE,
  [anon_sym_await] = anon_sym_await,
  [anon_sym_is] = anon_sym_is,
  [anon_sym_as] = anon_sym_as,
  [anon_sym_DOT] = anon_sym_DOT,
  [anon_sym_QMARK_DOT] = anon_sym_QMARK_DOT,
  [anon_sym_DOT_DOT] = anon_sym_DOT_DOT,
  [anon_sym_QMARK_DOT_DOT] = anon_sym_QMARK_DOT_DOT,
  [anon_sym_extends] = anon_sym_extends,
  [anon_sym_SEMI] = anon_sym_SEMI,
  [anon_sym_switch] = anon_sym_switch,
  [anon_sym_default] = anon_sym_default,
  [anon_sym_do] = anon_sym_do,
  [anon_sym_while] = anon_sym_while,
  [anon_sym_continue] = anon_sym_continue,
  [anon_sym_yield] = anon_sym_yield,
  [anon_sym_return] = anon_sym_return,
  [anon_sym_on] = anon_sym_on,
  [anon_sym_try] = anon_sym_try,
  [anon_sym_catch] = anon_sym_catch,
  [anon_sym_finally] = anon_sym_finally,
  [anon_sym_if] = anon_sym_if,
  [anon_sym_else] = anon_sym_else,
  [anon_sym_for] = anon_sym_for,
  [anon_sym_in] = anon_sym_in,
  [anon_sym_AT] = anon_sym_AT,
  [anon_sym_transitive] = anon_sym_transitive,
  [anon_sym_part] = anon_sym_part,
  [anon_sym_of] = anon_sym_of,
  [anon_sym_EQ_EQ] = anon_sym_EQ_EQ,
  [anon_sym_show] = anon_sym_show,
  [anon_sym_hide] = anon_sym_hide,
  [anon_sym_enum] = anon_sym_enum,
  [anon_sym_abstract] = anon_sym_abstract,
  [anon_sym_class] = anon_sym_class,
  [anon_sym_extension] = anon_sym_extension,
  [anon_sym_with] = anon_sym_with,
  [anon_sym_LBRACK_RBRACK] = anon_sym_LBRACK_RBRACK,
  [anon_sym_LBRACK_RBRACK_EQ] = anon_sym_LBRACK_RBRACK_EQ,
  [anon_sym_super] = anon_sym_super,
  [sym_floating_point_type] = sym_floating_point_type,
  [anon_sym_bool] = anon_sym_bool,
  [sym_void_type] = sym_void_type,
  [anon_sym_var] = anon_sym_var,
  [anon_sym_async] = anon_sym_async,
  [anon_sym_EQ_GT] = anon_sym_EQ_GT,
  [anon_sym_async_STAR] = anon_sym_async_STAR,
  [anon_sym_sync_STAR] = anon_sym_sync_STAR,
  [anon_sym_throws] = anon_sym_throws,
  [anon_sym_POUND_BANG] = anon_sym_POUND_BANG,
  [aux_sym_script_tag_token1] = aux_sym_script_tag_token1,
  [anon_sym_LF] = anon_sym_LF,
  [anon_sym_library] = anon_sym_library,
  [sym__break_builtin] = sym__break_builtin,
  [sym__assert_builtin] = sym__assert_builtin,
  [sym_case_builtin] = sym_case_builtin,
  [anon_sym_covariant] = anon_sym_covariant,
  [anon_sym_deferred] = anon_sym_deferred,
  [anon_sym_dynamic] = anon_sym_dynamic,
  [anon_sym_export] = anon_sym_export,
  [anon_sym_factory] = anon_sym_factory,
  [anon_sym_Function] = anon_sym_Function,
  [anon_sym_get] = anon_sym_get,
  [anon_sym_native] = anon_sym_native,
  [anon_sym_implements] = anon_sym_implements,
  [anon_sym_import] = anon_sym_import,
  [anon_sym_interface] = anon_sym_interface,
  [anon_sym_operator] = anon_sym_operator,
  [anon_sym_mixin] = anon_sym_mixin,
  [anon_sym_required] = anon_sym_required,
  [anon_sym_set] = anon_sym_set,
  [anon_sym_static] = anon_sym_static,
  [anon_sym_typedef] = anon_sym_typedef,
  [anon_sym_new] = anon_sym_new,
  [sym_const_builtin] = sym_const_builtin,
  [sym_final_builtin] = sym_final_builtin,
  [anon_sym_late] = anon_sym_late,
  [anon_sym_external] = anon_sym_external,
  [anon_sym_this] = anon_sym_this,
  [sym_identifier_dollar_escaped] = sym_identifier_dollar_escaped,
  [anon_sym_SLASH_SLASH] = anon_sym_SLASH_SLASH,
  [aux_sym_comment_token1] = aux_sym_comment_token1,
  [anon_sym_SLASH_STAR] = anon_sym_SLASH_STAR,
  [aux_sym_comment_token2] = aux_sym_comment_token2,
  [anon_sym_SLASH_SLASH_SLASH] = anon_sym_SLASH_SLASH_SLASH,
  [aux_sym_documentation_comment_token1] = aux_sym_documentation_comment_token1,
  [sym__automatic_semicolon] = sym__automatic_semicolon,
  [sym__template_chars_double] = sym__template_chars_double,
  [sym__template_chars_single] = sym__template_chars_single,
  [sym__template_chars_double_single] = sym__template_chars_double_single,
  [sym__template_chars_single_single] = sym__template_chars_single_single,
  [sym__template_chars_raw_slash] = sym__template_chars_raw_slash,
  [sym__block_comment] = sym__block_comment,
  [sym__documentation_block_comment] = sym__documentation_block_comment,
  [sym_program] = sym_program,
  [sym__top_level_definition] = sym__top_level_definition,
  [sym__literal] = sym__literal,
  [sym_symbol_literal] = sym_symbol_literal,
  [sym_true] = sym_true,
  [sym_false] = sym_false,
  [sym_string_literal] = sym_string_literal,
  [sym__string_literal_double_quotes] = sym__string_literal_double_quotes,
  [sym__string_literal_single_quotes] = sym__string_literal_single_quotes,
  [sym__string_literal_double_quotes_multiple] = sym__string_literal_double_quotes_multiple,
  [sym__string_literal_single_quotes_multiple] = sym__string_literal_single_quotes_multiple,
  [sym__raw_string_literal_double_quotes] = sym__raw_string_literal_double_quotes,
  [sym__raw_string_literal_single_quotes] = sym__raw_string_literal_single_quotes,
  [sym__raw_string_literal_double_quotes_multiple] = sym__raw_string_literal_double_quotes_multiple,
  [sym__raw_string_literal_single_quotes_multiple] = sym__raw_string_literal_single_quotes_multiple,
  [sym_template_substitution] = sym_template_substitution,
  [sym__sub_string_test] = sym__sub_string_test,
  [sym_escape_sequence] = sym_escape_sequence,
  [sym_list_literal] = sym_list_literal,
  [sym_set_or_map_literal] = sym_set_or_map_literal,
  [sym_pair] = sym_pair,
  [sym__element] = sym__element,
  [sym_null_literal] = sym_null_literal,
  [sym__expression] = sym__expression,
  [sym__expression_without_cascade] = sym__expression_without_cascade,
  [sym__real_expression] = sym__real_expression,
  [sym_throw_expression] = sym_throw_expression,
  [sym_throw_expression_without_cascade] = sym_throw_expression_without_cascade,
  [sym_assignment_expression] = sym_assignment_expression,
  [sym_assignment_expression_without_cascade] = sym_assignment_expression_without_cascade,
  [sym_assignable_expression] = sym_assignable_expression,
  [sym__assignable_selector_part] = sym__assignable_selector_part,
  [sym__assignment_operator] = sym__assignment_operator,
  [sym_lambda_expression] = sym_lambda_expression,
  [sym_function_expression] = sym_function_expression,
  [sym_if_null_expression] = sym_if_null_expression,
  [aux_sym__if_null_expression] = aux_sym__if_null_expression,
  [sym_conditional_expression] = sym_conditional_expression,
  [sym_logical_or_expression] = sym_logical_or_expression,
  [sym_logical_and_expression] = sym_logical_and_expression,
  [sym_equality_expression] = sym_equality_expression,
  [sym_type_cast_expression] = sym_type_cast_expression,
  [sym_type_test_expression] = sym_type_test_expression,
  [sym_relational_expression] = sym_relational_expression,
  [sym_relational_operator] = sym_relational_operator,
  [sym_bitwise_or_expression] = sym_bitwise_or_expression,
  [sym_bitwise_xor_expression] = sym_bitwise_xor_expression,
  [sym_bitwise_and_expression] = sym_bitwise_and_expression,
  [sym_shift_expression] = sym_shift_expression,
  [sym_additive_expression] = sym_additive_expression,
  [sym_multiplicative_expression] = sym_multiplicative_expression,
  [sym_bitwise_operator] = sym_bitwise_operator,
  [sym__bitwise_operator] = sym__bitwise_operator,
  [sym_shift_operator] = sym_shift_operator,
  [sym__shift_operator] = sym__shift_operator,
  [sym_additive_operator] = sym_additive_operator,
  [sym_multiplicative_operator] = sym_multiplicative_operator,
  [sym__multiplicative_operator] = sym__multiplicative_operator,
  [sym__unary_expression] = sym__unary_expression,
  [sym_unary_expression] = sym_unary_expression,
  [sym__postfix_expression] = sym__postfix_expression,
  [sym_postfix_expression] = sym_postfix_expression,
  [sym_postfix_operator] = sym_postfix_operator,
  [sym_spread_element] = sym_spread_element,
  [sym_selector] = sym_selector,
  [sym_prefix_operator] = sym_prefix_operator,
  [sym_negation_operator] = sym_negation_operator,
  [sym_tilde_operator] = sym_tilde_operator,
  [sym_await_expression] = sym_await_expression,
  [sym_type_test] = sym_type_test,
  [sym_is_operator] = sym_is_operator,
  [sym_type_cast] = sym_type_cast,
  [sym_as_operator] = sym_as_operator,
  [sym_new_expression] = sym_new_expression,
  [sym__dot_identifier] = sym__dot_identifier,
  [sym_const_object_expression] = sym_const_object_expression,
  [sym__primary] = sym__primary,
  [sym_parenthesized_expression] = sym_parenthesized_expression,
  [sym_constructor_invocation] = sym_constructor_invocation,
  [sym_arguments] = sym_arguments,
  [sym__argument_list] = sym__argument_list,
  [sym_argument] = sym_argument,
  [sym_named_argument] = sym_named_argument,
  [sym_cascade_section] = sym_cascade_section,
  [sym__cascade_subsection] = sym__cascade_subsection,
  [sym__cascade_assignment_section] = sym__cascade_assignment_section,
  [sym_cascade_selector] = sym_cascade_selector,
  [sym_argument_part] = sym_argument_part,
  [sym_unconditional_assignable_selector] = sym_unconditional_assignable_selector,
  [sym_conditional_assignable_selector] = sym_conditional_assignable_selector,
  [sym__assignable_selector] = sym__assignable_selector,
  [sym_type_arguments] = sym_type_arguments,
  [sym__statement] = sym__statement,
  [sym_local_function_declaration] = sym_local_function_declaration,
  [sym_block] = sym_block,
  [sym_expression_statement] = sym_expression_statement,
  [sym_assert_statement] = sym_assert_statement,
  [sym_assertion] = sym_assertion,
  [sym_switch_statement] = sym_switch_statement,
  [sym_switch_block] = sym_switch_block,
  [sym_switch_label] = sym_switch_label,
  [sym_do_statement] = sym_do_statement,
  [sym_break_statement] = sym_break_statement,
  [sym_continue_statement] = sym_continue_statement,
  [sym_yield_statement] = sym_yield_statement,
  [sym_yield_each_statement] = sym_yield_each_statement,
  [sym_return_statement] = sym_return_statement,
  [sym_try_statement] = sym_try_statement,
  [sym__on_part] = sym__on_part,
  [sym__try_head] = sym__try_head,
  [sym_catch_clause] = sym_catch_clause,
  [sym_finally_clause] = sym_finally_clause,
  [sym_if_element] = sym_if_element,
  [sym_if_statement] = sym_if_statement,
  [sym_while_statement] = sym_while_statement,
  [sym_for_statement] = sym_for_statement,
  [sym__for_loop_parts] = sym__for_loop_parts,
  [sym_for_element] = sym_for_element,
  [sym__annotation] = sym__annotation,
  [sym_marker_annotation] = sym_marker_annotation,
  [sym_annotation] = sym_annotation,
  [sym_import_or_export] = sym_import_or_export,
  [sym_library_import] = sym_library_import,
  [sym_library_export] = sym_library_export,
  [sym_import_specification] = sym_import_specification,
  [sym_part_directive] = sym_part_directive,
  [sym_part_of_directive] = sym_part_of_directive,
  [sym_uri] = sym_uri,
  [sym_configurable_uri] = sym_configurable_uri,
  [sym_configuration_uri] = sym_configuration_uri,
  [sym_uri_test] = sym_uri_test,
  [sym_combinator] = sym_combinator,
  [sym__identifier_list] = sym__identifier_list,
  [sym_enum_declaration] = sym_enum_declaration,
  [sym_enum_body] = sym_enum_body,
  [sym_enum_constant] = sym_enum_constant,
  [sym_type_alias] = sym_type_alias,
  [sym_class_definition] = sym_class_definition,
  [sym_extension_declaration] = sym_extension_declaration,
  [sym__metadata] = sym__metadata,
  [sym_type_parameters] = sym_type_parameters,
  [sym_type_parameter] = sym_type_parameter,
  [sym_type_bound] = sym_type_bound,
  [sym_superclass] = sym_superclass,
  [sym_mixins] = sym_mixins,
  [sym_mixin_application_class] = sym_mixin_application_class,
  [sym_mixin_application] = sym_mixin_application,
  [sym_mixin_declaration] = sym_mixin_declaration,
  [sym_interfaces] = sym_interfaces,
  [sym_class_body] = sym_class_body,
  [sym_extension_body] = sym_extension_body,
  [sym_getter_signature] = sym_getter_signature,
  [sym_setter_signature] = sym_setter_signature,
  [sym_method_signature] = sym_method_signature,
  [sym_declaration] = sym_declaration,
  [sym_identifier_list] = sym_identifier_list,
  [sym_initialized_identifier_list] = sym_initialized_identifier_list,
  [sym_initialized_identifier] = sym_initialized_identifier,
  [sym_static_final_declaration_list] = sym_static_final_declaration_list,
  [sym_binary_operator] = sym_binary_operator,
  [sym_operator_signature] = sym_operator_signature,
  [sym_static_final_declaration] = sym_static_final_declaration,
  [sym__external_and_static] = sym__external_and_static,
  [sym__final_or_const] = sym__final_or_const,
  [sym_initializers] = sym_initializers,
  [sym_initializer_list_entry] = sym_initializer_list_entry,
  [sym_field_initializer] = sym_field_initializer,
  [sym_factory_constructor_signature] = sym_factory_constructor_signature,
  [sym_redirecting_factory_constructor_signature] = sym_redirecting_factory_constructor_signature,
  [sym_redirection] = sym_redirection,
  [sym_constructor_signature] = sym_constructor_signature,
  [sym_constant_constructor_signature] = sym_constant_constructor_signature,
  [sym_scoped_identifier] = sym_scoped_identifier,
  [sym_initialized_variable_definition] = sym_initialized_variable_definition,
  [sym__declared_identifier] = sym__declared_identifier,
  [sym__final_const_var_or_type] = sym__final_const_var_or_type,
  [sym__type] = sym__type,
  [sym__type_not_function] = sym__type_not_function,
  [sym__type_not_void_not_function] = sym__type_not_void_not_function,
  [sym_function_type] = sym_function_type,
  [aux_sym__function_type_tails] = aux_sym__function_type_tails,
  [sym__function_type_tail] = sym__function_type_tail,
  [sym_parameter_type_list] = sym_parameter_type_list,
  [sym_normal_parameter_type] = sym_normal_parameter_type,
  [sym_optional_parameter_types] = sym_optional_parameter_types,
  [sym_optional_positional_parameter_types] = sym_optional_positional_parameter_types,
  [sym_named_parameter_types] = sym_named_parameter_types,
  [sym__named_parameter_type] = sym__named_parameter_type,
  [sym__type_not_void] = sym__type_not_void,
  [sym__type_not_void_list] = sym__type_not_void_list,
  [sym__type_name] = sym__type_name,
  [sym__type_dot_identifier] = sym__type_dot_identifier,
  [sym_typed_identifier] = sym_typed_identifier,
  [sym__nullable_type] = sym__nullable_type,
  [sym__var_or_type] = sym__var_or_type,
  [sym_inferred_type] = sym_inferred_type,
  [sym_function_body] = sym_function_body,
  [sym_function_expression_body] = sym_function_expression_body,
  [sym_function_signature] = sym_function_signature,
  [sym__formal_parameter_part] = sym__formal_parameter_part,
  [sym_formal_parameter_list] = sym_formal_parameter_list,
  [sym__strict_formal_parameter_list] = sym__strict_formal_parameter_list,
  [sym__normal_formal_parameters] = sym__normal_formal_parameters,
  [sym_optional_formal_parameters] = sym_optional_formal_parameters,
  [sym__optional_postional_formal_parameters] = sym__optional_postional_formal_parameters,
  [sym__named_formal_parameters] = sym__named_formal_parameters,
  [sym_formal_parameter] = sym_formal_parameter,
  [sym__default_formal_parameter] = sym__default_formal_parameter,
  [sym__default_named_parameter] = sym__default_named_parameter,
  [sym__normal_formal_parameter] = sym__normal_formal_parameter,
  [sym__function_formal_parameter] = sym__function_formal_parameter,
  [sym__simple_formal_parameter] = sym__simple_formal_parameter,
  [sym_super_formal_parameter] = sym_super_formal_parameter,
  [sym_constructor_param] = sym_constructor_param,
  [sym_local_variable_declaration] = sym_local_variable_declaration,
  [sym_script_tag] = sym_script_tag,
  [sym_library_name] = sym_library_name,
  [sym_dotted_identifier_list] = sym_dotted_identifier_list,
  [sym_qualified] = sym_qualified,
  [sym__as] = sym__as,
  [sym__covariant] = sym__covariant,
  [sym__deferred] = sym__deferred,
  [sym__export] = sym__export,
  [sym__external] = sym__external,
  [sym__factory] = sym__factory,
  [sym__function_builtin_identifier] = sym__function_builtin_identifier,
  [sym__get] = sym__get,
  [sym__native] = sym__native,
  [sym__implements] = sym__implements,
  [sym__import] = sym__import,
  [sym__operator] = sym__operator,
  [sym__mixin] = sym__mixin,
  [sym__required] = sym__required,
  [sym__set] = sym__set,
  [sym__static] = sym__static,
  [sym__typedef] = sym__typedef,
  [sym__new_builtin] = sym__new_builtin,
  [sym__late_builtin] = sym__late_builtin,
  [sym__external_builtin] = sym__external_builtin,
  [sym_this] = sym_this,
  [sym_super] = sym_super,
  [sym_label] = sym_label,
  [sym__semicolon] = sym__semicolon,
  [sym_comment] = sym_comment,
  [sym_documentation_comment] = sym_documentation_comment,
  [aux_sym_program_repeat1] = aux_sym_program_repeat1,
  [aux_sym_program_repeat2] = aux_sym_program_repeat2,
  [aux_sym_program_repeat3] = aux_sym_program_repeat3,
  [aux_sym_program_repeat4] = aux_sym_program_repeat4,
  [aux_sym_program_repeat5] = aux_sym_program_repeat5,
  [aux_sym_string_literal_repeat1] = aux_sym_string_literal_repeat1,
  [aux_sym__string_literal_double_quotes_repeat1] = aux_sym__string_literal_double_quotes_repeat1,
  [aux_sym__string_literal_single_quotes_repeat1] = aux_sym__string_literal_single_quotes_repeat1,
  [aux_sym__string_literal_double_quotes_multiple_repeat1] = aux_sym__string_literal_double_quotes_multiple_repeat1,
  [aux_sym__string_literal_single_quotes_multiple_repeat1] = aux_sym__string_literal_single_quotes_multiple_repeat1,
  [aux_sym__raw_string_literal_double_quotes_repeat1] = aux_sym__raw_string_literal_double_quotes_repeat1,
  [aux_sym__raw_string_literal_single_quotes_repeat1] = aux_sym__raw_string_literal_single_quotes_repeat1,
  [aux_sym__raw_string_literal_double_quotes_multiple_repeat1] = aux_sym__raw_string_literal_double_quotes_multiple_repeat1,
  [aux_sym__raw_string_literal_single_quotes_multiple_repeat1] = aux_sym__raw_string_literal_single_quotes_multiple_repeat1,
  [aux_sym_list_literal_repeat1] = aux_sym_list_literal_repeat1,
  [aux_sym__expression_repeat1] = aux_sym__expression_repeat1,
  [aux_sym__assignable_selector_part_repeat1] = aux_sym__assignable_selector_part_repeat1,
  [aux_sym_inferred_parameters_repeat1] = aux_sym_inferred_parameters_repeat1,
  [aux_sym_logical_or_expression_repeat1] = aux_sym_logical_or_expression_repeat1,
  [aux_sym_logical_and_expression_repeat1] = aux_sym_logical_and_expression_repeat1,
  [aux_sym_bitwise_or_expression_repeat1] = aux_sym_bitwise_or_expression_repeat1,
  [aux_sym_bitwise_xor_expression_repeat1] = aux_sym_bitwise_xor_expression_repeat1,
  [aux_sym_bitwise_and_expression_repeat1] = aux_sym_bitwise_and_expression_repeat1,
  [aux_sym_shift_expression_repeat1] = aux_sym_shift_expression_repeat1,
  [aux_sym_additive_expression_repeat1] = aux_sym_additive_expression_repeat1,
  [aux_sym_multiplicative_expression_repeat1] = aux_sym_multiplicative_expression_repeat1,
  [aux_sym__argument_list_repeat1] = aux_sym__argument_list_repeat1,
  [aux_sym__argument_list_repeat2] = aux_sym__argument_list_repeat2,
  [aux_sym__argument_list_repeat3] = aux_sym__argument_list_repeat3,
  [aux_sym_cascade_section_repeat1] = aux_sym_cascade_section_repeat1,
  [aux_sym_cascade_section_repeat2] = aux_sym_cascade_section_repeat2,
  [aux_sym_type_arguments_repeat1] = aux_sym_type_arguments_repeat1,
  [aux_sym_switch_block_repeat1] = aux_sym_switch_block_repeat1,
  [aux_sym_switch_case_repeat1] = aux_sym_switch_case_repeat1,
  [aux_sym_try_statement_repeat1] = aux_sym_try_statement_repeat1,
  [aux_sym__for_loop_parts_repeat1] = aux_sym__for_loop_parts_repeat1,
  [aux_sym__for_loop_parts_repeat2] = aux_sym__for_loop_parts_repeat2,
  [aux_sym_library_export_repeat1] = aux_sym_library_export_repeat1,
  [aux_sym_configurable_uri_repeat1] = aux_sym_configurable_uri_repeat1,
  [aux_sym_enum_body_repeat1] = aux_sym_enum_body_repeat1,
  [aux_sym__metadata_repeat1] = aux_sym__metadata_repeat1,
  [aux_sym_type_parameters_repeat1] = aux_sym_type_parameters_repeat1,
  [aux_sym_class_body_repeat1] = aux_sym_class_body_repeat1,
  [aux_sym_extension_body_repeat1] = aux_sym_extension_body_repeat1,
  [aux_sym_initialized_identifier_list_repeat1] = aux_sym_initialized_identifier_list_repeat1,
  [aux_sym_static_final_declaration_list_repeat1] = aux_sym_static_final_declaration_list_repeat1,
  [aux_sym_initializers_repeat1] = aux_sym_initializers_repeat1,
  [aux_sym_factory_constructor_signature_repeat1] = aux_sym_factory_constructor_signature_repeat1,
  [aux_sym_parameter_type_list_repeat1] = aux_sym_parameter_type_list_repeat1,
  [aux_sym_named_parameter_types_repeat1] = aux_sym_named_parameter_types_repeat1,
  [aux_sym__type_not_void_list_repeat1] = aux_sym__type_not_void_list_repeat1,
  [aux_sym__normal_formal_parameters_repeat1] = aux_sym__normal_formal_parameters_repeat1,
  [aux_sym_positional_parameters_repeat1] = aux_sym_positional_parameters_repeat1,
  [aux_sym__named_formal_parameters_repeat1] = aux_sym__named_formal_parameters_repeat1,
  [alias_sym_type_identifier] = alias_sym_type_identifier,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym_identifier] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_POUND] = {
    .visible = true,
    .named = false,
  },
  [sym_decimal_integer_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_hex_integer_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_decimal_floating_point_literal] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_true] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_false] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DQUOTE_DQUOTE_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SQUOTE_SQUOTE_SQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_r_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOLLAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_r_SQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym__sub_string_test_token1] = {
    .visible = false,
    .named = false,
  },
  [sym__unused_escape_sequence] = {
    .visible = false,
    .named = true,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_null] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_throw] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_TILDE_SLASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK_QMARK_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK_QMARK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_AMP] = {
    .visible = true,
    .named = false,
  },
  [sym_equality_operator] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT_GT] = {
    .visible = true,
    .named = false,
  },
  [sym__additive_operator] = {
    .visible = false,
    .named = true,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_TILDE_SLASH] = {
    .visible = true,
    .named = false,
  },
  [sym_increment_operator] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_DOT_DOT_DOT] = {
    .visible = true,
    .named = false,
  },
  [sym_minus_operator] = {
    .visible = true,
    .named = true,
  },
  [sym__exclamation_operator] = {
    .visible = false,
    .named = true,
  },
  [anon_sym_TILDE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_await] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_is] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_as] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK_DOT_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_extends] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SEMI] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_switch] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_default] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_do] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_while] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_continue] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_yield] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_return] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_on] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_try] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_catch] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_finally] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_if] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_else] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_for] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_in] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_transitive] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_part] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_of] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_show] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_hide] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_enum] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_abstract] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_class] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_extension] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_with] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK_RBRACK_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_super] = {
    .visible = true,
    .named = false,
  },
  [sym_floating_point_type] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_bool] = {
    .visible = true,
    .named = false,
  },
  [sym_void_type] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_var] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_async] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_async_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_sync_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_throws] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_POUND_BANG] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_script_tag_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_LF] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_library] = {
    .visible = true,
    .named = false,
  },
  [sym__break_builtin] = {
    .visible = false,
    .named = true,
  },
  [sym__assert_builtin] = {
    .visible = false,
    .named = true,
  },
  [sym_case_builtin] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_covariant] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_deferred] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_dynamic] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_export] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_factory] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_Function] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_get] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_native] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_implements] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_import] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_interface] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_operator] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_mixin] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_required] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_set] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_static] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_typedef] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_new] = {
    .visible = true,
    .named = false,
  },
  [sym_const_builtin] = {
    .visible = true,
    .named = true,
  },
  [sym_final_builtin] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_late] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_external] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_this] = {
    .visible = true,
    .named = false,
  },
  [sym_identifier_dollar_escaped] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_SLASH_SLASH] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_comment_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_SLASH_STAR] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_comment_token2] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_SLASH_SLASH_SLASH] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_documentation_comment_token1] = {
    .visible = false,
    .named = false,
  },
  [sym__automatic_semicolon] = {
    .visible = false,
    .named = true,
  },
  [sym__template_chars_double] = {
    .visible = false,
    .named = true,
  },
  [sym__template_chars_single] = {
    .visible = false,
    .named = true,
  },
  [sym__template_chars_double_single] = {
    .visible = false,
    .named = true,
  },
  [sym__template_chars_single_single] = {
    .visible = false,
    .named = true,
  },
  [sym__template_chars_raw_slash] = {
    .visible = false,
    .named = true,
  },
  [sym__block_comment] = {
    .visible = false,
    .named = true,
  },
  [sym__documentation_block_comment] = {
    .visible = false,
    .named = true,
  },
  [sym_program] = {
    .visible = true,
    .named = true,
  },
  [sym__top_level_definition] = {
    .visible = false,
    .named = true,
  },
  [sym__literal] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_symbol_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_true] = {
    .visible = true,
    .named = true,
  },
  [sym_false] = {
    .visible = true,
    .named = true,
  },
  [sym_string_literal] = {
    .visible = true,
    .named = true,
  },
  [sym__string_literal_double_quotes] = {
    .visible = false,
    .named = true,
  },
  [sym__string_literal_single_quotes] = {
    .visible = false,
    .named = true,
  },
  [sym__string_literal_double_quotes_multiple] = {
    .visible = false,
    .named = true,
  },
  [sym__string_literal_single_quotes_multiple] = {
    .visible = false,
    .named = true,
  },
  [sym__raw_string_literal_double_quotes] = {
    .visible = false,
    .named = true,
  },
  [sym__raw_string_literal_single_quotes] = {
    .visible = false,
    .named = true,
  },
  [sym__raw_string_literal_double_quotes_multiple] = {
    .visible = false,
    .named = true,
  },
  [sym__raw_string_literal_single_quotes_multiple] = {
    .visible = false,
    .named = true,
  },
  [sym_template_substitution] = {
    .visible = true,
    .named = true,
  },
  [sym__sub_string_test] = {
    .visible = false,
    .named = true,
  },
  [sym_escape_sequence] = {
    .visible = true,
    .named = true,
  },
  [sym_list_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_set_or_map_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_pair] = {
    .visible = true,
    .named = true,
  },
  [sym__element] = {
    .visible = false,
    .named = true,
  },
  [sym_null_literal] = {
    .visible = true,
    .named = true,
  },
  [sym__expression] = {
    .visible = false,
    .named = true,
  },
  [sym__expression_without_cascade] = {
    .visible = false,
    .named = true,
  },
  [sym__real_expression] = {
    .visible = false,
    .named = true,
  },
  [sym_throw_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_throw_expression_without_cascade] = {
    .visible = true,
    .named = true,
  },
  [sym_assignment_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_assignment_expression_without_cascade] = {
    .visible = true,
    .named = true,
  },
  [sym_assignable_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__assignable_selector_part] = {
    .visible = false,
    .named = true,
  },
  [sym__assignment_operator] = {
    .visible = false,
    .named = true,
  },
  [sym_lambda_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_function_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_if_null_expression] = {
    .visible = true,
    .named = true,
  },
  [aux_sym__if_null_expression] = {
    .visible = false,
    .named = false,
  },
  [sym_conditional_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_logical_or_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_logical_and_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_equality_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_type_cast_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_type_test_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_relational_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_relational_operator] = {
    .visible = true,
    .named = true,
  },
  [sym_bitwise_or_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_bitwise_xor_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_bitwise_and_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_shift_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_additive_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_multiplicative_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_bitwise_operator] = {
    .visible = true,
    .named = true,
  },
  [sym__bitwise_operator] = {
    .visible = false,
    .named = true,
  },
  [sym_shift_operator] = {
    .visible = true,
    .named = true,
  },
  [sym__shift_operator] = {
    .visible = false,
    .named = true,
  },
  [sym_additive_operator] = {
    .visible = true,
    .named = true,
  },
  [sym_multiplicative_operator] = {
    .visible = true,
    .named = true,
  },
  [sym__multiplicative_operator] = {
    .visible = false,
    .named = true,
  },
  [sym__unary_expression] = {
    .visible = false,
    .named = true,
  },
  [sym_unary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__postfix_expression] = {
    .visible = false,
    .named = true,
  },
  [sym_postfix_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_postfix_operator] = {
    .visible = true,
    .named = true,
  },
  [sym_spread_element] = {
    .visible = true,
    .named = true,
  },
  [sym_selector] = {
    .visible = true,
    .named = true,
  },
  [sym_prefix_operator] = {
    .visible = true,
    .named = true,
  },
  [sym_negation_operator] = {
    .visible = true,
    .named = true,
  },
  [sym_tilde_operator] = {
    .visible = true,
    .named = true,
  },
  [sym_await_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_type_test] = {
    .visible = true,
    .named = true,
  },
  [sym_is_operator] = {
    .visible = true,
    .named = true,
  },
  [sym_type_cast] = {
    .visible = true,
    .named = true,
  },
  [sym_as_operator] = {
    .visible = true,
    .named = true,
  },
  [sym_new_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__dot_identifier] = {
    .visible = false,
    .named = true,
  },
  [sym_const_object_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__primary] = {
    .visible = false,
    .named = true,
  },
  [sym_parenthesized_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_constructor_invocation] = {
    .visible = true,
    .named = true,
  },
  [sym_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym__argument_list] = {
    .visible = false,
    .named = true,
  },
  [sym_argument] = {
    .visible = true,
    .named = true,
  },
  [sym_named_argument] = {
    .visible = true,
    .named = true,
  },
  [sym_cascade_section] = {
    .visible = true,
    .named = true,
  },
  [sym__cascade_subsection] = {
    .visible = false,
    .named = true,
  },
  [sym__cascade_assignment_section] = {
    .visible = false,
    .named = true,
  },
  [sym_cascade_selector] = {
    .visible = true,
    .named = true,
  },
  [sym_argument_part] = {
    .visible = true,
    .named = true,
  },
  [sym_unconditional_assignable_selector] = {
    .visible = true,
    .named = true,
  },
  [sym_conditional_assignable_selector] = {
    .visible = true,
    .named = true,
  },
  [sym__assignable_selector] = {
    .visible = false,
    .named = true,
  },
  [sym_type_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym__statement] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_local_function_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_block] = {
    .visible = true,
    .named = true,
  },
  [sym_expression_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_assert_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_assertion] = {
    .visible = true,
    .named = true,
  },
  [sym_switch_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_switch_block] = {
    .visible = true,
    .named = true,
  },
  [sym_switch_label] = {
    .visible = true,
    .named = true,
  },
  [sym_do_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_break_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_continue_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_yield_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_yield_each_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_return_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_try_statement] = {
    .visible = true,
    .named = true,
  },
  [sym__on_part] = {
    .visible = false,
    .named = true,
  },
  [sym__try_head] = {
    .visible = false,
    .named = true,
  },
  [sym_catch_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_finally_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_if_element] = {
    .visible = true,
    .named = true,
  },
  [sym_if_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_while_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_for_statement] = {
    .visible = true,
    .named = true,
  },
  [sym__for_loop_parts] = {
    .visible = false,
    .named = true,
  },
  [sym_for_element] = {
    .visible = true,
    .named = true,
  },
  [sym__annotation] = {
    .visible = false,
    .named = true,
  },
  [sym_marker_annotation] = {
    .visible = true,
    .named = true,
  },
  [sym_annotation] = {
    .visible = true,
    .named = true,
  },
  [sym_import_or_export] = {
    .visible = true,
    .named = true,
  },
  [sym_library_import] = {
    .visible = true,
    .named = true,
  },
  [sym_library_export] = {
    .visible = true,
    .named = true,
  },
  [sym_import_specification] = {
    .visible = true,
    .named = true,
  },
  [sym_part_directive] = {
    .visible = true,
    .named = true,
  },
  [sym_part_of_directive] = {
    .visible = true,
    .named = true,
  },
  [sym_uri] = {
    .visible = true,
    .named = true,
  },
  [sym_configurable_uri] = {
    .visible = true,
    .named = true,
  },
  [sym_configuration_uri] = {
    .visible = true,
    .named = true,
  },
  [sym_uri_test] = {
    .visible = true,
    .named = true,
  },
  [sym_combinator] = {
    .visible = true,
    .named = true,
  },
  [sym__identifier_list] = {
    .visible = false,
    .named = true,
  },
  [sym_enum_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_enum_body] = {
    .visible = true,
    .named = true,
  },
  [sym_enum_constant] = {
    .visible = true,
    .named = true,
  },
  [sym_type_alias] = {
    .visible = true,
    .named = true,
  },
  [sym_class_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_extension_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym__metadata] = {
    .visible = false,
    .named = true,
  },
  [sym_type_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym_type_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_type_bound] = {
    .visible = true,
    .named = true,
  },
  [sym_superclass] = {
    .visible = true,
    .named = true,
  },
  [sym_mixins] = {
    .visible = true,
    .named = true,
  },
  [sym_mixin_application_class] = {
    .visible = true,
    .named = true,
  },
  [sym_mixin_application] = {
    .visible = true,
    .named = true,
  },
  [sym_mixin_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_interfaces] = {
    .visible = true,
    .named = true,
  },
  [sym_class_body] = {
    .visible = true,
    .named = true,
  },
  [sym_extension_body] = {
    .visible = true,
    .named = true,
  },
  [sym_getter_signature] = {
    .visible = true,
    .named = true,
  },
  [sym_setter_signature] = {
    .visible = true,
    .named = true,
  },
  [sym_method_signature] = {
    .visible = true,
    .named = true,
  },
  [sym_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_identifier_list] = {
    .visible = true,
    .named = true,
  },
  [sym_initialized_identifier_list] = {
    .visible = true,
    .named = true,
  },
  [sym_initialized_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_static_final_declaration_list] = {
    .visible = true,
    .named = true,
  },
  [sym_binary_operator] = {
    .visible = true,
    .named = true,
  },
  [sym_operator_signature] = {
    .visible = true,
    .named = true,
  },
  [sym_static_final_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym__external_and_static] = {
    .visible = false,
    .named = true,
  },
  [sym__final_or_const] = {
    .visible = false,
    .named = true,
  },
  [sym_initializers] = {
    .visible = true,
    .named = true,
  },
  [sym_initializer_list_entry] = {
    .visible = true,
    .named = true,
  },
  [sym_field_initializer] = {
    .visible = true,
    .named = true,
  },
  [sym_factory_constructor_signature] = {
    .visible = true,
    .named = true,
  },
  [sym_redirecting_factory_constructor_signature] = {
    .visible = true,
    .named = true,
  },
  [sym_redirection] = {
    .visible = true,
    .named = true,
  },
  [sym_constructor_signature] = {
    .visible = true,
    .named = true,
  },
  [sym_constant_constructor_signature] = {
    .visible = true,
    .named = true,
  },
  [sym_scoped_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_initialized_variable_definition] = {
    .visible = true,
    .named = true,
  },
  [sym__declared_identifier] = {
    .visible = false,
    .named = true,
  },
  [sym__final_const_var_or_type] = {
    .visible = false,
    .named = true,
  },
  [sym__type] = {
    .visible = false,
    .named = true,
  },
  [sym__type_not_function] = {
    .visible = false,
    .named = true,
  },
  [sym__type_not_void_not_function] = {
    .visible = false,
    .named = true,
  },
  [sym_function_type] = {
    .visible = true,
    .named = true,
  },
  [aux_sym__function_type_tails] = {
    .visible = false,
    .named = false,
  },
  [sym__function_type_tail] = {
    .visible = false,
    .named = true,
  },
  [sym_parameter_type_list] = {
    .visible = true,
    .named = true,
  },
  [sym_normal_parameter_type] = {
    .visible = true,
    .named = true,
  },
  [sym_optional_parameter_types] = {
    .visible = true,
    .named = true,
  },
  [sym_optional_positional_parameter_types] = {
    .visible = true,
    .named = true,
  },
  [sym_named_parameter_types] = {
    .visible = true,
    .named = true,
  },
  [sym__named_parameter_type] = {
    .visible = false,
    .named = true,
  },
  [sym__type_not_void] = {
    .visible = false,
    .named = true,
  },
  [sym__type_not_void_list] = {
    .visible = false,
    .named = true,
  },
  [sym__type_name] = {
    .visible = false,
    .named = true,
  },
  [sym__type_dot_identifier] = {
    .visible = false,
    .named = true,
  },
  [sym_typed_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym__nullable_type] = {
    .visible = false,
    .named = true,
  },
  [sym__var_or_type] = {
    .visible = false,
    .named = true,
  },
  [sym_inferred_type] = {
    .visible = true,
    .named = true,
  },
  [sym_function_body] = {
    .visible = true,
    .named = true,
  },
  [sym_function_expression_body] = {
    .visible = true,
    .named = true,
  },
  [sym_function_signature] = {
    .visible = true,
    .named = true,
  },
  [sym__formal_parameter_part] = {
    .visible = false,
    .named = true,
  },
  [sym_formal_parameter_list] = {
    .visible = true,
    .named = true,
  },
  [sym__strict_formal_parameter_list] = {
    .visible = false,
    .named = true,
  },
  [sym__normal_formal_parameters] = {
    .visible = false,
    .named = true,
  },
  [sym_optional_formal_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym__optional_postional_formal_parameters] = {
    .visible = false,
    .named = true,
  },
  [sym__named_formal_parameters] = {
    .visible = false,
    .named = true,
  },
  [sym_formal_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym__default_formal_parameter] = {
    .visible = false,
    .named = true,
  },
  [sym__default_named_parameter] = {
    .visible = false,
    .named = true,
  },
  [sym__normal_formal_parameter] = {
    .visible = false,
    .named = true,
  },
  [sym__function_formal_parameter] = {
    .visible = false,
    .named = true,
  },
  [sym__simple_formal_parameter] = {
    .visible = false,
    .named = true,
  },
  [sym_super_formal_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_constructor_param] = {
    .visible = true,
    .named = true,
  },
  [sym_local_variable_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_script_tag] = {
    .visible = true,
    .named = true,
  },
  [sym_library_name] = {
    .visible = true,
    .named = true,
  },
  [sym_dotted_identifier_list] = {
    .visible = true,
    .named = true,
  },
  [sym_qualified] = {
    .visible = true,
    .named = true,
  },
  [sym__as] = {
    .visible = false,
    .named = true,
  },
  [sym__covariant] = {
    .visible = false,
    .named = true,
  },
  [sym__deferred] = {
    .visible = false,
    .named = true,
  },
  [sym__export] = {
    .visible = false,
    .named = true,
  },
  [sym__external] = {
    .visible = false,
    .named = true,
  },
  [sym__factory] = {
    .visible = false,
    .named = true,
  },
  [sym__function_builtin_identifier] = {
    .visible = false,
    .named = true,
  },
  [sym__get] = {
    .visible = false,
    .named = true,
  },
  [sym__native] = {
    .visible = false,
    .named = true,
  },
  [sym__implements] = {
    .visible = false,
    .named = true,
  },
  [sym__import] = {
    .visible = false,
    .named = true,
  },
  [sym__operator] = {
    .visible = false,
    .named = true,
  },
  [sym__mixin] = {
    .visible = false,
    .named = true,
  },
  [sym__required] = {
    .visible = false,
    .named = true,
  },
  [sym__set] = {
    .visible = false,
    .named = true,
  },
  [sym__static] = {
    .visible = false,
    .named = true,
  },
  [sym__typedef] = {
    .visible = false,
    .named = true,
  },
  [sym__new_builtin] = {
    .visible = false,
    .named = true,
  },
  [sym__late_builtin] = {
    .visible = false,
    .named = true,
  },
  [sym__external_builtin] = {
    .visible = false,
    .named = true,
  },
  [sym_this] = {
    .visible = true,
    .named = true,
  },
  [sym_super] = {
    .visible = true,
    .named = true,
  },
  [sym_label] = {
    .visible = true,
    .named = true,
  },
  [sym__semicolon] = {
    .visible = false,
    .named = true,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_documentation_comment] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_program_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_program_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_program_repeat3] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_program_repeat4] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_program_repeat5] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_string_literal_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__string_literal_double_quotes_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__string_literal_single_quotes_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__string_literal_double_quotes_multiple_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__string_literal_single_quotes_multiple_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__raw_string_literal_double_quotes_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__raw_string_literal_single_quotes_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__raw_string_literal_double_quotes_multiple_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__raw_string_literal_single_quotes_multiple_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_list_literal_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__expression_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__assignable_selector_part_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_inferred_parameters_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_logical_or_expression_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_logical_and_expression_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_bitwise_or_expression_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_bitwise_xor_expression_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_bitwise_and_expression_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_shift_expression_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_additive_expression_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_multiplicative_expression_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__argument_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__argument_list_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__argument_list_repeat3] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_cascade_section_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_cascade_section_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_type_arguments_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_switch_block_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_switch_case_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_try_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__for_loop_parts_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__for_loop_parts_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_library_export_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_configurable_uri_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_enum_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__metadata_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_type_parameters_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_class_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_extension_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_initialized_identifier_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_static_final_declaration_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_initializers_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_factory_constructor_signature_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_parameter_type_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_named_parameter_types_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__type_not_void_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__normal_formal_parameters_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_positional_parameters_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__named_formal_parameters_repeat1] = {
    .visible = false,
    .named = false,
  },
  [alias_sym_type_identifier] = {
    .visible = true,
    .named = true,
  },
};

enum {
  field_alternative = 1,
  field_arguments = 2,
  field_body = 3,
  field_class = 4,
  field_condition = 5,
  field_consequence = 6,
  field_first = 7,
  field_init = 8,
  field_interfaces = 9,
  field_key = 10,
  field_left = 11,
  field_name = 12,
  field_operator = 13,
  field_parameters = 14,
  field_right = 15,
  field_scope = 16,
  field_second = 17,
  field_superclass = 18,
  field_type_parameters = 19,
  field_update = 20,
  field_value = 21,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_alternative] = "alternative",
  [field_arguments] = "arguments",
  [field_body] = "body",
  [field_class] = "class",
  [field_condition] = "condition",
  [field_consequence] = "consequence",
  [field_first] = "first",
  [field_init] = "init",
  [field_interfaces] = "interfaces",
  [field_key] = "key",
  [field_left] = "left",
  [field_name] = "name",
  [field_operator] = "operator",
  [field_parameters] = "parameters",
  [field_right] = "right",
  [field_scope] = "scope",
  [field_second] = "second",
  [field_superclass] = "superclass",
  [field_type_parameters] = "type_parameters",
  [field_update] = "update",
  [field_value] = "value",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [2] = {.index = 0, .length = 1},
  [3] = {.index = 1, .length = 1},
  [4] = {.index = 2, .length = 1},
  [5] = {.index = 3, .length = 1},
  [6] = {.index = 4, .length = 2},
  [7] = {.index = 6, .length = 1},
  [8] = {.index = 7, .length = 2},
  [9] = {.index = 3, .length = 1},
  [10] = {.index = 9, .length = 1},
  [12] = {.index = 10, .length = 2},
  [13] = {.index = 12, .length = 2},
  [14] = {.index = 14, .length = 2},
  [15] = {.index = 16, .length = 2},
  [16] = {.index = 18, .length = 1},
  [17] = {.index = 19, .length = 2},
  [18] = {.index = 21, .length = 3},
  [19] = {.index = 24, .length = 1},
  [20] = {.index = 25, .length = 2},
  [21] = {.index = 2, .length = 1},
  [22] = {.index = 27, .length = 2},
  [23] = {.index = 29, .length = 1},
  [24] = {.index = 30, .length = 1},
  [25] = {.index = 31, .length = 1},
  [26] = {.index = 32, .length = 2},
  [27] = {.index = 34, .length = 2},
  [28] = {.index = 36, .length = 3},
  [29] = {.index = 39, .length = 3},
  [30] = {.index = 42, .length = 3},
  [31] = {.index = 45, .length = 2},
  [32] = {.index = 47, .length = 1},
  [33] = {.index = 48, .length = 2},
  [34] = {.index = 50, .length = 3},
  [35] = {.index = 53, .length = 1},
  [36] = {.index = 54, .length = 1},
  [37] = {.index = 55, .length = 2},
  [38] = {.index = 57, .length = 2},
  [39] = {.index = 59, .length = 6},
  [40] = {.index = 65, .length = 2},
  [41] = {.index = 67, .length = 2},
  [42] = {.index = 69, .length = 1},
  [43] = {.index = 70, .length = 2},
  [44] = {.index = 72, .length = 1},
  [45] = {.index = 73, .length = 3},
  [46] = {.index = 76, .length = 3},
  [47] = {.index = 79, .length = 3},
  [48] = {.index = 82, .length = 2},
  [49] = {.index = 84, .length = 4},
  [50] = {.index = 88, .length = 4},
  [51] = {.index = 92, .length = 4},
  [52] = {.index = 96, .length = 3},
  [53] = {.index = 99, .length = 3},
  [54] = {.index = 102, .length = 2},
  [55] = {.index = 104, .length = 6},
  [56] = {.index = 110, .length = 2},
  [57] = {.index = 112, .length = 3},
  [58] = {.index = 115, .length = 2},
  [59] = {.index = 117, .length = 2},
  [60] = {.index = 119, .length = 3},
  [61] = {.index = 122, .length = 3},
  [62] = {.index = 125, .length = 2},
  [63] = {.index = 127, .length = 2},
  [64] = {.index = 129, .length = 2},
  [65] = {.index = 131, .length = 4},
  [66] = {.index = 135, .length = 4},
  [67] = {.index = 139, .length = 4},
  [68] = {.index = 143, .length = 5},
  [69] = {.index = 148, .length = 4},
  [70] = {.index = 152, .length = 3},
  [71] = {.index = 155, .length = 3},
  [72] = {.index = 158, .length = 3},
  [73] = {.index = 161, .length = 3},
  [74] = {.index = 164, .length = 4},
  [75] = {.index = 168, .length = 3},
  [76] = {.index = 171, .length = 5},
  [77] = {.index = 176, .length = 4},
  [78] = {.index = 180, .length = 4},
  [79] = {.index = 184, .length = 4},
  [80] = {.index = 188, .length = 4},
  [81] = {.index = 192, .length = 5},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_name, 0, .inherited = true},
  [1] =
    {field_body, 1},
  [2] =
    {field_name, 1},
  [3] =
    {field_name, 0},
  [4] =
    {field_first, 0},
    {field_second, 1, .inherited = true},
  [6] =
    {field_body, 0, .inherited = true},
  [7] =
    {field_body, 1},
    {field_parameters, 0},
  [9] =
    {field_name, 1, .inherited = true},
  [10] =
    {field_body, 2},
    {field_condition, 1},
  [12] =
    {field_condition, 1},
    {field_consequence, 2},
  [14] =
    {field_arguments, 2},
    {field_name, 1},
  [16] =
    {field_body, 2},
    {field_name, 1},
  [18] =
    {field_second, 1},
  [19] =
    {field_second, 0, .inherited = true},
    {field_second, 1, .inherited = true},
  [21] =
    {field_left, 0},
    {field_operator, 1},
    {field_right, 2},
  [24] =
    {field_name, 2},
  [25] =
    {field_name, 0, .inherited = true},
    {field_value, 2},
  [27] =
    {field_key, 0},
    {field_value, 2},
  [29] =
    {field_condition, 0},
  [30] =
    {field_init, 0},
  [31] =
    {field_update, 1},
  [32] =
    {field_name, 2},
    {field_scope, 0},
  [34] =
    {field_body, 3},
    {field_name, 2},
  [36] =
    {field_body, 3},
    {field_name, 1},
    {field_type_parameters, 2},
  [39] =
    {field_body, 3},
    {field_name, 1},
    {field_superclass, 2},
  [42] =
    {field_body, 3},
    {field_interfaces, 2},
    {field_name, 1},
  [45] =
    {field_body, 3},
    {field_class, 2},
  [47] =
    {field_name, 3},
  [48] =
    {field_body, 1},
    {field_condition, 3},
  [50] =
    {field_alternative, 4},
    {field_condition, 1},
    {field_consequence, 2},
  [53] =
    {field_value, 2},
  [54] =
    {field_init, 1},
  [55] =
    {field_condition, 0},
    {field_update, 2},
  [57] =
    {field_init, 0, .inherited = true},
    {field_init, 1, .inherited = true},
  [59] =
    {field_body, 4},
    {field_condition, 2, .inherited = true},
    {field_init, 2, .inherited = true},
    {field_name, 2, .inherited = true},
    {field_update, 2, .inherited = true},
    {field_value, 2, .inherited = true},
  [65] =
    {field_condition, 1},
    {field_init, 0},
  [67] =
    {field_init, 0},
    {field_update, 2},
  [69] =
    {field_condition, 1},
  [70] =
    {field_update, 1},
    {field_update, 2, .inherited = true},
  [72] =
    {field_update, 2},
  [73] =
    {field_body, 4},
    {field_name, 2},
    {field_type_parameters, 3},
  [76] =
    {field_body, 4},
    {field_name, 2},
    {field_superclass, 3},
  [79] =
    {field_body, 4},
    {field_interfaces, 3},
    {field_name, 2},
  [82] =
    {field_name, 0},
    {field_parameters, 1},
  [84] =
    {field_body, 4},
    {field_name, 1},
    {field_superclass, 3},
    {field_type_parameters, 2},
  [88] =
    {field_body, 4},
    {field_interfaces, 3},
    {field_name, 1},
    {field_type_parameters, 2},
  [92] =
    {field_body, 4},
    {field_interfaces, 3},
    {field_name, 1},
    {field_superclass, 2},
  [96] =
    {field_body, 4},
    {field_class, 3},
    {field_name, 1},
  [99] =
    {field_body, 4},
    {field_class, 3},
    {field_type_parameters, 1},
  [102] =
    {field_alternative, 4},
    {field_consequence, 2},
  [104] =
    {field_body, 5},
    {field_condition, 3, .inherited = true},
    {field_init, 3, .inherited = true},
    {field_name, 3, .inherited = true},
    {field_update, 3, .inherited = true},
    {field_value, 3, .inherited = true},
  [110] =
    {field_condition, 2},
    {field_init, 0},
  [112] =
    {field_condition, 0},
    {field_update, 2},
    {field_update, 3, .inherited = true},
  [115] =
    {field_init, 0},
    {field_update, 3},
  [117] =
    {field_init, 0},
    {field_init, 1, .inherited = true},
  [119] =
    {field_condition, 1},
    {field_init, 0},
    {field_update, 3},
  [122] =
    {field_init, 0},
    {field_update, 2},
    {field_update, 3, .inherited = true},
  [125] =
    {field_condition, 1},
    {field_update, 3},
  [127] =
    {field_update, 0, .inherited = true},
    {field_update, 1, .inherited = true},
  [129] =
    {field_update, 2},
    {field_update, 3, .inherited = true},
  [131] =
    {field_body, 5},
    {field_name, 2},
    {field_superclass, 4},
    {field_type_parameters, 3},
  [135] =
    {field_body, 5},
    {field_interfaces, 4},
    {field_name, 2},
    {field_type_parameters, 3},
  [139] =
    {field_body, 5},
    {field_interfaces, 4},
    {field_name, 2},
    {field_superclass, 3},
  [143] =
    {field_body, 5},
    {field_interfaces, 4},
    {field_name, 1},
    {field_superclass, 3},
    {field_type_parameters, 2},
  [148] =
    {field_body, 5},
    {field_class, 4},
    {field_name, 1},
    {field_type_parameters, 2},
  [152] =
    {field_condition, 2},
    {field_init, 0},
    {field_update, 4},
  [155] =
    {field_init, 0},
    {field_update, 3},
    {field_update, 4, .inherited = true},
  [158] =
    {field_condition, 3},
    {field_init, 0},
    {field_init, 1, .inherited = true},
  [161] =
    {field_init, 0},
    {field_init, 1, .inherited = true},
    {field_update, 4},
  [164] =
    {field_condition, 1},
    {field_init, 0},
    {field_update, 3},
    {field_update, 4, .inherited = true},
  [168] =
    {field_condition, 1},
    {field_update, 3},
    {field_update, 4, .inherited = true},
  [171] =
    {field_body, 6},
    {field_interfaces, 5},
    {field_name, 2},
    {field_superclass, 4},
    {field_type_parameters, 3},
  [176] =
    {field_name, 0},
    {field_name, 1},
    {field_name, 2},
    {field_parameters, 3},
  [180] =
    {field_condition, 2},
    {field_init, 0},
    {field_update, 4},
    {field_update, 5, .inherited = true},
  [184] =
    {field_condition, 3},
    {field_init, 0},
    {field_init, 1, .inherited = true},
    {field_update, 5},
  [188] =
    {field_init, 0},
    {field_init, 1, .inherited = true},
    {field_update, 4},
    {field_update, 5, .inherited = true},
  [192] =
    {field_condition, 3},
    {field_init, 0},
    {field_init, 1, .inherited = true},
    {field_update, 5},
    {field_update, 6, .inherited = true},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
  [1] = {
    [0] = alias_sym_type_identifier,
  },
  [9] = {
    [0] = sym_identifier,
  },
  [11] = {
    [1] = alias_sym_type_identifier,
  },
  [21] = {
    [1] = sym_identifier,
  },
};

static const uint16_t ts_non_terminal_alias_map[] = {
  sym__get, 2,
    sym__get,
    sym_identifier,
  sym__set, 2,
    sym__set,
    sym_identifier,
  0,
};

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(96);
      if (lookahead == '!') ADVANCE(211);
      if (lookahead == '"') ADVANCE(105);
      if (lookahead == '#') ADVANCE(98);
      if (lookahead == '$') ADVANCE(112);
      if (lookahead == '%') ADVANCE(203);
      if (lookahead == '&') ADVANCE(184);
      if (lookahead == '\'') ADVANCE(107);
      if (lookahead == '(') ADVANCE(151);
      if (lookahead == ')') ADVANCE(152);
      if (lookahead == '*') ADVANCE(199);
      if (lookahead == '+') ADVANCE(193);
      if (lookahead == ',') ADVANCE(130);
      if (lookahead == '-') ADVANCE(209);
      if (lookahead == '.') ADVANCE(219);
      if (lookahead == '/') ADVANCE(201);
      if (lookahead == '0') ADVANCE(100);
      if (lookahead == ':') ADVANCE(132);
      if (lookahead == ';') ADVANCE(228);
      if (lookahead == '<') ADVANCE(169);
      if (lookahead == '=') ADVANCE(136);
      if (lookahead == '>') ADVANCE(173);
      if (lookahead == '?') ADVANCE(157);
      if (lookahead == '@') ADVANCE(229);
      if (lookahead == '[') ADVANCE(129);
      if (lookahead == '\\') ADVANCE(79);
      if (lookahead == ']') ADVANCE(131);
      if (lookahead == '^') ADVANCE(181);
      if (lookahead == 'a') ADVANCE(249);
      if (lookahead == 'r') ADVANCE(243);
      if (lookahead == 's') ADVANCE(252);
      if (lookahead == '{') ADVANCE(116);
      if (lookahead == '|') ADVANCE(178);
      if (lookahead == '}') ADVANCE(117);
      if (lookahead == '~') ADVANCE(213);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(92)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(99);
      if (('A' <= lookahead && lookahead <= '_') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(254);
      END_STATE();
    case 1:
      if (lookahead == '\n') ADVANCE(242);
      if (lookahead == '/') ADVANCE(38);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(1)
      END_STATE();
    case 2:
      if (lookahead == '\n') SKIP(2)
      if (lookahead == '/') ADVANCE(239);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(240);
      if (lookahead != 0) ADVANCE(241);
      END_STATE();
    case 3:
      if (lookahead == '!') ADVANCE(211);
      if (lookahead == '"') ADVANCE(105);
      if (lookahead == '%') ADVANCE(202);
      if (lookahead == '&') ADVANCE(183);
      if (lookahead == '\'') ADVANCE(107);
      if (lookahead == '(') ADVANCE(151);
      if (lookahead == ')') ADVANCE(152);
      if (lookahead == '*') ADVANCE(198);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(191);
      if (lookahead == ',') ADVANCE(130);
      if (lookahead == '.') ADVANCE(220);
      if (lookahead == '/') ADVANCE(200);
      if (lookahead == ':') ADVANCE(132);
      if (lookahead == ';') ADVANCE(228);
      if (lookahead == '<') ADVANCE(170);
      if (lookahead == '=') ADVANCE(52);
      if (lookahead == '>') ADVANCE(174);
      if (lookahead == '?') ADVANCE(158);
      if (lookahead == '@') ADVANCE(229);
      if (lookahead == '[') ADVANCE(129);
      if (lookahead == ']') ADVANCE(131);
      if (lookahead == '^') ADVANCE(180);
      if (lookahead == 'a') ADVANCE(250);
      if (lookahead == 'r') ADVANCE(243);
      if (lookahead == '|') ADVANCE(179);
      if (lookahead == '}') ADVANCE(117);
      if (lookahead == '~') ADVANCE(49);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(3)
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(254);
      END_STATE();
    case 4:
      if (lookahead == '!') ADVANCE(211);
      if (lookahead == '"') ADVANCE(105);
      if (lookahead == '%') ADVANCE(202);
      if (lookahead == '&') ADVANCE(183);
      if (lookahead == '\'') ADVANCE(107);
      if (lookahead == '(') ADVANCE(151);
      if (lookahead == '*') ADVANCE(198);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(191);
      if (lookahead == ',') ADVANCE(130);
      if (lookahead == '.') ADVANCE(220);
      if (lookahead == '/') ADVANCE(200);
      if (lookahead == ';') ADVANCE(228);
      if (lookahead == '<') ADVANCE(170);
      if (lookahead == '=') ADVANCE(53);
      if (lookahead == '>') ADVANCE(174);
      if (lookahead == '?') ADVANCE(158);
      if (lookahead == '[') ADVANCE(129);
      if (lookahead == '^') ADVANCE(180);
      if (lookahead == 'a') ADVANCE(249);
      if (lookahead == 'r') ADVANCE(243);
      if (lookahead == 's') ADVANCE(252);
      if (lookahead == '{') ADVANCE(116);
      if (lookahead == '|') ADVANCE(179);
      if (lookahead == '~') ADVANCE(49);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(4)
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(254);
      END_STATE();
    case 5:
      if (lookahead == '!') ADVANCE(211);
      if (lookahead == '"') ADVANCE(105);
      if (lookahead == '%') ADVANCE(202);
      if (lookahead == '&') ADVANCE(183);
      if (lookahead == '\'') ADVANCE(107);
      if (lookahead == '(') ADVANCE(151);
      if (lookahead == '*') ADVANCE(198);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(191);
      if (lookahead == '.') ADVANCE(218);
      if (lookahead == '/') ADVANCE(200);
      if (lookahead == ':') ADVANCE(132);
      if (lookahead == '<') ADVANCE(170);
      if (lookahead == '=') ADVANCE(52);
      if (lookahead == '>') ADVANCE(174);
      if (lookahead == '?') ADVANCE(162);
      if (lookahead == '[') ADVANCE(129);
      if (lookahead == '^') ADVANCE(180);
      if (lookahead == 'a') ADVANCE(250);
      if (lookahead == 'r') ADVANCE(243);
      if (lookahead == '|') ADVANCE(179);
      if (lookahead == '~') ADVANCE(49);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(5)
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(254);
      END_STATE();
    case 6:
      if (lookahead == '!') ADVANCE(211);
      if (lookahead == '%') ADVANCE(203);
      if (lookahead == '&') ADVANCE(184);
      if (lookahead == '(') ADVANCE(151);
      if (lookahead == ')') ADVANCE(152);
      if (lookahead == '*') ADVANCE(199);
      if (lookahead == '+') ADVANCE(193);
      if (lookahead == ',') ADVANCE(130);
      if (lookahead == '-') ADVANCE(195);
      if (lookahead == '.') ADVANCE(220);
      if (lookahead == '/') ADVANCE(201);
      if (lookahead == ':') ADVANCE(132);
      if (lookahead == ';') ADVANCE(228);
      if (lookahead == '<') ADVANCE(169);
      if (lookahead == '=') ADVANCE(134);
      if (lookahead == '>') ADVANCE(173);
      if (lookahead == '?') ADVANCE(157);
      if (lookahead == '[') ADVANCE(129);
      if (lookahead == ']') ADVANCE(131);
      if (lookahead == '^') ADVANCE(181);
      if (lookahead == 'a') ADVANCE(250);
      if (lookahead == '|') ADVANCE(178);
      if (lookahead == '}') ADVANCE(117);
      if (lookahead == '~') ADVANCE(48);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(6)
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(254);
      END_STATE();
    case 7:
      if (lookahead == '!') ADVANCE(211);
      if (lookahead == '%') ADVANCE(203);
      if (lookahead == '&') ADVANCE(184);
      if (lookahead == '(') ADVANCE(151);
      if (lookahead == ')') ADVANCE(152);
      if (lookahead == '*') ADVANCE(199);
      if (lookahead == '+') ADVANCE(196);
      if (lookahead == ',') ADVANCE(130);
      if (lookahead == '-') ADVANCE(197);
      if (lookahead == '.') ADVANCE(220);
      if (lookahead == '/') ADVANCE(201);
      if (lookahead == ':') ADVANCE(132);
      if (lookahead == ';') ADVANCE(228);
      if (lookahead == '<') ADVANCE(169);
      if (lookahead == '=') ADVANCE(134);
      if (lookahead == '>') ADVANCE(173);
      if (lookahead == '?') ADVANCE(157);
      if (lookahead == '[') ADVANCE(129);
      if (lookahead == ']') ADVANCE(131);
      if (lookahead == '^') ADVANCE(181);
      if (lookahead == 'a') ADVANCE(250);
      if (lookahead == '|') ADVANCE(178);
      if (lookahead == '}') ADVANCE(117);
      if (lookahead == '~') ADVANCE(48);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(7)
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(254);
      END_STATE();
    case 8:
      if (lookahead == '!') ADVANCE(211);
      if (lookahead == '%') ADVANCE(203);
      if (lookahead == '&') ADVANCE(184);
      if (lookahead == '(') ADVANCE(151);
      if (lookahead == '*') ADVANCE(199);
      if (lookahead == '+') ADVANCE(193);
      if (lookahead == ',') ADVANCE(130);
      if (lookahead == '-') ADVANCE(195);
      if (lookahead == '.') ADVANCE(220);
      if (lookahead == '/') ADVANCE(201);
      if (lookahead == ';') ADVANCE(228);
      if (lookahead == '<') ADVANCE(169);
      if (lookahead == '=') ADVANCE(135);
      if (lookahead == '>') ADVANCE(173);
      if (lookahead == '?') ADVANCE(157);
      if (lookahead == '[') ADVANCE(129);
      if (lookahead == '^') ADVANCE(181);
      if (lookahead == 'a') ADVANCE(249);
      if (lookahead == 's') ADVANCE(252);
      if (lookahead == '{') ADVANCE(116);
      if (lookahead == '|') ADVANCE(178);
      if (lookahead == '~') ADVANCE(48);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(8)
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(254);
      END_STATE();
    case 9:
      if (lookahead == '!') ADVANCE(211);
      if (lookahead == '%') ADVANCE(203);
      if (lookahead == '&') ADVANCE(184);
      if (lookahead == '(') ADVANCE(151);
      if (lookahead == '*') ADVANCE(199);
      if (lookahead == '+') ADVANCE(193);
      if (lookahead == '-') ADVANCE(195);
      if (lookahead == '.') ADVANCE(218);
      if (lookahead == '/') ADVANCE(201);
      if (lookahead == ':') ADVANCE(132);
      if (lookahead == '<') ADVANCE(169);
      if (lookahead == '=') ADVANCE(134);
      if (lookahead == '>') ADVANCE(173);
      if (lookahead == '?') ADVANCE(161);
      if (lookahead == '[') ADVANCE(129);
      if (lookahead == '^') ADVANCE(181);
      if (lookahead == 'a') ADVANCE(250);
      if (lookahead == '|') ADVANCE(178);
      if (lookahead == '~') ADVANCE(48);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(9)
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(254);
      END_STATE();
    case 10:
      if (lookahead == '!') ADVANCE(211);
      if (lookahead == '%') ADVANCE(203);
      if (lookahead == '&') ADVANCE(184);
      if (lookahead == '(') ADVANCE(151);
      if (lookahead == '*') ADVANCE(199);
      if (lookahead == '+') ADVANCE(196);
      if (lookahead == ',') ADVANCE(130);
      if (lookahead == '-') ADVANCE(197);
      if (lookahead == '.') ADVANCE(220);
      if (lookahead == '/') ADVANCE(201);
      if (lookahead == ';') ADVANCE(228);
      if (lookahead == '<') ADVANCE(169);
      if (lookahead == '=') ADVANCE(135);
      if (lookahead == '>') ADVANCE(173);
      if (lookahead == '?') ADVANCE(157);
      if (lookahead == '[') ADVANCE(129);
      if (lookahead == '^') ADVANCE(181);
      if (lookahead == 'a') ADVANCE(249);
      if (lookahead == 's') ADVANCE(252);
      if (lookahead == '{') ADVANCE(116);
      if (lookahead == '|') ADVANCE(178);
      if (lookahead == '~') ADVANCE(48);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(10)
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(254);
      END_STATE();
    case 11:
      if (lookahead == '!') ADVANCE(211);
      if (lookahead == '%') ADVANCE(202);
      if (lookahead == '&') ADVANCE(183);
      if (lookahead == '(') ADVANCE(151);
      if (lookahead == ')') ADVANCE(152);
      if (lookahead == '*') ADVANCE(198);
      if (lookahead == '+') ADVANCE(192);
      if (lookahead == ',') ADVANCE(130);
      if (lookahead == '-') ADVANCE(194);
      if (lookahead == '.') ADVANCE(220);
      if (lookahead == '/') ADVANCE(200);
      if (lookahead == ':') ADVANCE(132);
      if (lookahead == ';') ADVANCE(228);
      if (lookahead == '<') ADVANCE(170);
      if (lookahead == '=') ADVANCE(52);
      if (lookahead == '>') ADVANCE(174);
      if (lookahead == '?') ADVANCE(158);
      if (lookahead == '[') ADVANCE(129);
      if (lookahead == ']') ADVANCE(131);
      if (lookahead == '^') ADVANCE(180);
      if (lookahead == 'a') ADVANCE(250);
      if (lookahead == '|') ADVANCE(179);
      if (lookahead == '}') ADVANCE(117);
      if (lookahead == '~') ADVANCE(49);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(11)
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(254);
      END_STATE();
    case 12:
      if (lookahead == '!') ADVANCE(211);
      if (lookahead == '%') ADVANCE(202);
      if (lookahead == '&') ADVANCE(183);
      if (lookahead == '(') ADVANCE(151);
      if (lookahead == '*') ADVANCE(198);
      if (lookahead == '+') ADVANCE(192);
      if (lookahead == ',') ADVANCE(130);
      if (lookahead == '-') ADVANCE(194);
      if (lookahead == '.') ADVANCE(220);
      if (lookahead == '/') ADVANCE(200);
      if (lookahead == ';') ADVANCE(228);
      if (lookahead == '<') ADVANCE(170);
      if (lookahead == '=') ADVANCE(53);
      if (lookahead == '>') ADVANCE(174);
      if (lookahead == '?') ADVANCE(158);
      if (lookahead == '[') ADVANCE(129);
      if (lookahead == '^') ADVANCE(180);
      if (lookahead == 'a') ADVANCE(249);
      if (lookahead == 's') ADVANCE(252);
      if (lookahead == '{') ADVANCE(116);
      if (lookahead == '|') ADVANCE(179);
      if (lookahead == '~') ADVANCE(49);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(12)
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(254);
      END_STATE();
    case 13:
      if (lookahead == '!') ADVANCE(211);
      if (lookahead == '%') ADVANCE(202);
      if (lookahead == '&') ADVANCE(183);
      if (lookahead == '(') ADVANCE(151);
      if (lookahead == '*') ADVANCE(198);
      if (lookahead == '+') ADVANCE(192);
      if (lookahead == '-') ADVANCE(194);
      if (lookahead == '.') ADVANCE(218);
      if (lookahead == '/') ADVANCE(200);
      if (lookahead == ':') ADVANCE(132);
      if (lookahead == '<') ADVANCE(170);
      if (lookahead == '=') ADVANCE(52);
      if (lookahead == '>') ADVANCE(174);
      if (lookahead == '?') ADVANCE(162);
      if (lookahead == '[') ADVANCE(129);
      if (lookahead == '^') ADVANCE(180);
      if (lookahead == 'a') ADVANCE(250);
      if (lookahead == '|') ADVANCE(179);
      if (lookahead == '~') ADVANCE(49);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(13)
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(254);
      END_STATE();
    case 14:
      if (lookahead == '!') ADVANCE(210);
      if (lookahead == '"') ADVANCE(105);
      if (lookahead == '\'') ADVANCE(107);
      if (lookahead == '(') ADVANCE(151);
      if (lookahead == '.') ADVANCE(218);
      if (lookahead == '/') ADVANCE(38);
      if (lookahead == ';') ADVANCE(228);
      if (lookahead == '<') ADVANCE(168);
      if (lookahead == '=') ADVANCE(67);
      if (lookahead == '?') ADVANCE(160);
      if (lookahead == '[') ADVANCE(129);
      if (lookahead == 'a') ADVANCE(78);
      if (lookahead == 'r') ADVANCE(27);
      if (lookahead == 's') ADVANCE(80);
      if (lookahead == '{') ADVANCE(116);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(14)
      END_STATE();
    case 15:
      if (lookahead == '!') ADVANCE(210);
      if (lookahead == '"') ADVANCE(104);
      if (lookahead == '$') ADVANCE(111);
      if (lookahead == '\'') ADVANCE(107);
      if (lookahead == '(') ADVANCE(151);
      if (lookahead == ',') ADVANCE(130);
      if (lookahead == '.') ADVANCE(220);
      if (lookahead == '/') ADVANCE(38);
      if (lookahead == ';') ADVANCE(228);
      if (lookahead == '<') ADVANCE(168);
      if (lookahead == '=') ADVANCE(67);
      if (lookahead == '?') ADVANCE(156);
      if (lookahead == '[') ADVANCE(129);
      if (lookahead == '\\') ADVANCE(79);
      if (lookahead == 'a') ADVANCE(78);
      if (lookahead == 's') ADVANCE(80);
      if (lookahead == '{') ADVANCE(116);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(16)
      END_STATE();
    case 16:
      if (lookahead == '!') ADVANCE(210);
      if (lookahead == '"') ADVANCE(104);
      if (lookahead == '$') ADVANCE(111);
      if (lookahead == '\'') ADVANCE(107);
      if (lookahead == '(') ADVANCE(151);
      if (lookahead == ',') ADVANCE(130);
      if (lookahead == '.') ADVANCE(220);
      if (lookahead == '/') ADVANCE(38);
      if (lookahead == ';') ADVANCE(228);
      if (lookahead == '<') ADVANCE(168);
      if (lookahead == '=') ADVANCE(67);
      if (lookahead == '?') ADVANCE(156);
      if (lookahead == '[') ADVANCE(129);
      if (lookahead == 'a') ADVANCE(78);
      if (lookahead == 's') ADVANCE(80);
      if (lookahead == '{') ADVANCE(116);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(16)
      END_STATE();
    case 17:
      if (lookahead == '!') ADVANCE(210);
      if (lookahead == '%') ADVANCE(54);
      if (lookahead == '&') ADVANCE(55);
      if (lookahead == '(') ADVANCE(151);
      if (lookahead == ')') ADVANCE(152);
      if (lookahead == '*') ADVANCE(56);
      if (lookahead == '+') ADVANCE(57);
      if (lookahead == ',') ADVANCE(130);
      if (lookahead == '-') ADVANCE(58);
      if (lookahead == '.') ADVANCE(220);
      if (lookahead == '/') ADVANCE(39);
      if (lookahead == ':') ADVANCE(132);
      if (lookahead == ';') ADVANCE(228);
      if (lookahead == '<') ADVANCE(171);
      if (lookahead == '=') ADVANCE(133);
      if (lookahead == '>') ADVANCE(68);
      if (lookahead == '?') ADVANCE(159);
      if (lookahead == '[') ADVANCE(129);
      if (lookahead == ']') ADVANCE(131);
      if (lookahead == '^') ADVANCE(60);
      if (lookahead == '|') ADVANCE(61);
      if (lookahead == '}') ADVANCE(117);
      if (lookahead == '~') ADVANCE(51);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(17)
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(254);
      END_STATE();
    case 18:
      if (lookahead == '!') ADVANCE(210);
      if (lookahead == '%') ADVANCE(54);
      if (lookahead == '&') ADVANCE(55);
      if (lookahead == '(') ADVANCE(151);
      if (lookahead == ')') ADVANCE(152);
      if (lookahead == '*') ADVANCE(56);
      if (lookahead == '+') ADVANCE(57);
      if (lookahead == ',') ADVANCE(130);
      if (lookahead == '-') ADVANCE(58);
      if (lookahead == '.') ADVANCE(220);
      if (lookahead == '/') ADVANCE(39);
      if (lookahead == ':') ADVANCE(132);
      if (lookahead == ';') ADVANCE(228);
      if (lookahead == '<') ADVANCE(171);
      if (lookahead == '=') ADVANCE(137);
      if (lookahead == '>') ADVANCE(68);
      if (lookahead == '?') ADVANCE(159);
      if (lookahead == '[') ADVANCE(129);
      if (lookahead == ']') ADVANCE(131);
      if (lookahead == '^') ADVANCE(60);
      if (lookahead == 'a') ADVANCE(251);
      if (lookahead == 's') ADVANCE(252);
      if (lookahead == '{') ADVANCE(116);
      if (lookahead == '|') ADVANCE(61);
      if (lookahead == '}') ADVANCE(117);
      if (lookahead == '~') ADVANCE(51);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(18)
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(254);
      END_STATE();
    case 19:
      if (lookahead == '!') ADVANCE(52);
      if (lookahead == '%') ADVANCE(202);
      if (lookahead == '&') ADVANCE(183);
      if (lookahead == '(') ADVANCE(151);
      if (lookahead == ')') ADVANCE(152);
      if (lookahead == '*') ADVANCE(198);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(191);
      if (lookahead == ',') ADVANCE(130);
      if (lookahead == '.') ADVANCE(220);
      if (lookahead == '/') ADVANCE(200);
      if (lookahead == ':') ADVANCE(132);
      if (lookahead == ';') ADVANCE(228);
      if (lookahead == '<') ADVANCE(170);
      if (lookahead == '=') ADVANCE(52);
      if (lookahead == '>') ADVANCE(174);
      if (lookahead == '?') ADVANCE(163);
      if (lookahead == ']') ADVANCE(131);
      if (lookahead == '^') ADVANCE(180);
      if (lookahead == 'a') ADVANCE(250);
      if (lookahead == '{') ADVANCE(116);
      if (lookahead == '|') ADVANCE(179);
      if (lookahead == '}') ADVANCE(117);
      if (lookahead == '~') ADVANCE(49);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(19)
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(254);
      END_STATE();
    case 20:
      if (lookahead == '!') ADVANCE(52);
      if (lookahead == '%') ADVANCE(202);
      if (lookahead == '&') ADVANCE(183);
      if (lookahead == '(') ADVANCE(151);
      if (lookahead == '*') ADVANCE(198);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(191);
      if (lookahead == ',') ADVANCE(130);
      if (lookahead == '.') ADVANCE(220);
      if (lookahead == '/') ADVANCE(200);
      if (lookahead == ';') ADVANCE(228);
      if (lookahead == '<') ADVANCE(170);
      if (lookahead == '=') ADVANCE(53);
      if (lookahead == '>') ADVANCE(174);
      if (lookahead == '?') ADVANCE(163);
      if (lookahead == '^') ADVANCE(180);
      if (lookahead == 'a') ADVANCE(249);
      if (lookahead == 's') ADVANCE(252);
      if (lookahead == '{') ADVANCE(116);
      if (lookahead == '|') ADVANCE(179);
      if (lookahead == '~') ADVANCE(49);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(20)
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(254);
      END_STATE();
    case 21:
      if (lookahead == '!') ADVANCE(52);
      if (lookahead == '%') ADVANCE(202);
      if (lookahead == '&') ADVANCE(183);
      if (lookahead == '(') ADVANCE(151);
      if (lookahead == '*') ADVANCE(198);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(191);
      if (lookahead == '.') ADVANCE(218);
      if (lookahead == '/') ADVANCE(200);
      if (lookahead == ':') ADVANCE(132);
      if (lookahead == '<') ADVANCE(170);
      if (lookahead == '=') ADVANCE(52);
      if (lookahead == '>') ADVANCE(174);
      if (lookahead == '?') ADVANCE(164);
      if (lookahead == '^') ADVANCE(180);
      if (lookahead == 'a') ADVANCE(250);
      if (lookahead == '|') ADVANCE(179);
      if (lookahead == '~') ADVANCE(49);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(21)
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(254);
      END_STATE();
    case 22:
      if (lookahead == '!') ADVANCE(52);
      if (lookahead == '%') ADVANCE(202);
      if (lookahead == '&') ADVANCE(182);
      if (lookahead == ')') ADVANCE(152);
      if (lookahead == '*') ADVANCE(198);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(191);
      if (lookahead == ',') ADVANCE(130);
      if (lookahead == '.') ADVANCE(218);
      if (lookahead == '/') ADVANCE(200);
      if (lookahead == ':') ADVANCE(132);
      if (lookahead == ';') ADVANCE(228);
      if (lookahead == '<') ADVANCE(170);
      if (lookahead == '=') ADVANCE(135);
      if (lookahead == '>') ADVANCE(174);
      if (lookahead == '?') ADVANCE(155);
      if (lookahead == '[') ADVANCE(129);
      if (lookahead == ']') ADVANCE(131);
      if (lookahead == '^') ADVANCE(180);
      if (lookahead == 'a') ADVANCE(251);
      if (lookahead == 's') ADVANCE(252);
      if (lookahead == '{') ADVANCE(116);
      if (lookahead == '|') ADVANCE(177);
      if (lookahead == '}') ADVANCE(117);
      if (lookahead == '~') ADVANCE(49);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(22)
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(254);
      END_STATE();
    case 23:
      if (lookahead == '"') ADVANCE(105);
      if (lookahead == '$') ADVANCE(111);
      if (lookahead == '%') ADVANCE(202);
      if (lookahead == '&') ADVANCE(182);
      if (lookahead == '\'') ADVANCE(106);
      if (lookahead == '*') ADVANCE(198);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(191);
      if (lookahead == '/') ADVANCE(200);
      if (lookahead == '<') ADVANCE(170);
      if (lookahead == '=') ADVANCE(59);
      if (lookahead == '>') ADVANCE(174);
      if (lookahead == '[') ADVANCE(69);
      if (lookahead == '\\') ADVANCE(79);
      if (lookahead == '^') ADVANCE(180);
      if (lookahead == 'a') ADVANCE(77);
      if (lookahead == '|') ADVANCE(177);
      if (lookahead == '~') ADVANCE(214);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(24)
      END_STATE();
    case 24:
      if (lookahead == '"') ADVANCE(105);
      if (lookahead == '$') ADVANCE(111);
      if (lookahead == '%') ADVANCE(202);
      if (lookahead == '&') ADVANCE(182);
      if (lookahead == '\'') ADVANCE(106);
      if (lookahead == '*') ADVANCE(198);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(191);
      if (lookahead == '/') ADVANCE(200);
      if (lookahead == '<') ADVANCE(170);
      if (lookahead == '=') ADVANCE(59);
      if (lookahead == '>') ADVANCE(174);
      if (lookahead == '[') ADVANCE(69);
      if (lookahead == '^') ADVANCE(180);
      if (lookahead == 'a') ADVANCE(77);
      if (lookahead == '|') ADVANCE(177);
      if (lookahead == '~') ADVANCE(214);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(24)
      END_STATE();
    case 25:
      if (lookahead == '"') ADVANCE(105);
      if (lookahead == '$') ADVANCE(111);
      if (lookahead == '\'') ADVANCE(106);
      if (lookahead == '/') ADVANCE(123);
      if (lookahead == '\\') ADVANCE(125);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(119);
      if (lookahead != 0 &&
          (lookahead < 'A' || 'Z' < lookahead) &&
          lookahead != '_' &&
          (lookahead < 'a' || '{' < lookahead)) ADVANCE(118);
      END_STATE();
    case 26:
      if (lookahead == '"') ADVANCE(105);
      if (lookahead == '%') ADVANCE(54);
      if (lookahead == '&') ADVANCE(55);
      if (lookahead == '\'') ADVANCE(107);
      if (lookahead == '(') ADVANCE(151);
      if (lookahead == '*') ADVANCE(56);
      if (lookahead == '+') ADVANCE(57);
      if (lookahead == ',') ADVANCE(130);
      if (lookahead == '-') ADVANCE(58);
      if (lookahead == '.') ADVANCE(220);
      if (lookahead == '/') ADVANCE(39);
      if (lookahead == ':') ADVANCE(132);
      if (lookahead == ';') ADVANCE(228);
      if (lookahead == '<') ADVANCE(171);
      if (lookahead == '=') ADVANCE(137);
      if (lookahead == '>') ADVANCE(68);
      if (lookahead == '?') ADVANCE(159);
      if (lookahead == '[') ADVANCE(129);
      if (lookahead == '^') ADVANCE(60);
      if (lookahead == 'a') ADVANCE(78);
      if (lookahead == 'r') ADVANCE(27);
      if (lookahead == 's') ADVANCE(80);
      if (lookahead == '{') ADVANCE(116);
      if (lookahead == '|') ADVANCE(61);
      if (lookahead == '~') ADVANCE(51);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(26)
      END_STATE();
    case 27:
      if (lookahead == '"') ADVANCE(110);
      if (lookahead == '\'') ADVANCE(113);
      END_STATE();
    case 28:
      if (lookahead == '"') ADVANCE(108);
      END_STATE();
    case 29:
      if (lookahead == '"') ADVANCE(114);
      END_STATE();
    case 30:
      if (lookahead == '"') ADVANCE(104);
      if (lookahead == '$') ADVANCE(111);
      if (lookahead == '\'') ADVANCE(107);
      if (lookahead == '/') ADVANCE(123);
      if (lookahead == '\\') ADVANCE(125);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(120);
      if (lookahead != 0 &&
          (lookahead < 'A' || 'Z' < lookahead) &&
          lookahead != '_' &&
          (lookahead < 'a' || '{' < lookahead)) ADVANCE(118);
      END_STATE();
    case 31:
      if (lookahead == '"') ADVANCE(104);
      if (lookahead == '$') ADVANCE(111);
      if (lookahead == '\'') ADVANCE(106);
      if (lookahead == '/') ADVANCE(38);
      if (lookahead == '\\') ADVANCE(79);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(32)
      END_STATE();
    case 32:
      if (lookahead == '"') ADVANCE(104);
      if (lookahead == '$') ADVANCE(111);
      if (lookahead == '\'') ADVANCE(106);
      if (lookahead == '/') ADVANCE(38);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(32)
      END_STATE();
    case 33:
      if (lookahead == '"') ADVANCE(104);
      if (lookahead == '$') ADVANCE(111);
      if (lookahead == '\'') ADVANCE(106);
      if (lookahead == '/') ADVANCE(123);
      if (lookahead == '\\') ADVANCE(125);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(121);
      if (lookahead != 0 &&
          (lookahead < 'A' || 'Z' < lookahead) &&
          lookahead != '_' &&
          (lookahead < 'a' || '{' < lookahead)) ADVANCE(118);
      END_STATE();
    case 34:
      if (lookahead == '$') ADVANCE(255);
      END_STATE();
    case 35:
      if (lookahead == '\'') ADVANCE(109);
      END_STATE();
    case 36:
      if (lookahead == '\'') ADVANCE(115);
      END_STATE();
    case 37:
      if (lookahead == '(') ADVANCE(151);
      if (lookahead == ')') ADVANCE(152);
      if (lookahead == ',') ADVANCE(130);
      if (lookahead == '.') ADVANCE(218);
      if (lookahead == '/') ADVANCE(38);
      if (lookahead == ':') ADVANCE(132);
      if (lookahead == ';') ADVANCE(228);
      if (lookahead == '<') ADVANCE(168);
      if (lookahead == '=') ADVANCE(133);
      if (lookahead == '>') ADVANCE(172);
      if (lookahead == '?') ADVANCE(155);
      if (lookahead == '[') ADVANCE(129);
      if (lookahead == ']') ADVANCE(131);
      if (lookahead == '{') ADVANCE(116);
      if (lookahead == '}') ADVANCE(117);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(37)
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(254);
      END_STATE();
    case 38:
      if (lookahead == '*') ADVANCE(265);
      if (lookahead == '/') ADVANCE(257);
      END_STATE();
    case 39:
      if (lookahead == '*') ADVANCE(265);
      if (lookahead == '/') ADVANCE(257);
      if (lookahead == '=') ADVANCE(141);
      END_STATE();
    case 40:
      if (lookahead == '*') ADVANCE(237);
      END_STATE();
    case 41:
      if (lookahead == '*') ADVANCE(270);
      if (lookahead == '/') ADVANCE(43);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(41);
      if (lookahead != 0) ADVANCE(42);
      END_STATE();
    case 42:
      if (lookahead == '*') ADVANCE(270);
      if (lookahead != 0) ADVANCE(42);
      END_STATE();
    case 43:
      if (lookahead == '*') ADVANCE(266);
      if (lookahead == '/') ADVANCE(256);
      if (lookahead != 0) ADVANCE(42);
      END_STATE();
    case 44:
      if (lookahead == '+') ADVANCE(206);
      END_STATE();
    case 45:
      if (lookahead == '.') ADVANCE(207);
      END_STATE();
    case 46:
      if (lookahead == '.') ADVANCE(227);
      END_STATE();
    case 47:
      if (lookahead == '.') ADVANCE(45);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(102);
      END_STATE();
    case 48:
      if (lookahead == '/') ADVANCE(205);
      END_STATE();
    case 49:
      if (lookahead == '/') ADVANCE(204);
      END_STATE();
    case 50:
      if (lookahead == '/') ADVANCE(123);
      if (lookahead == '\\') ADVANCE(122);
      if (lookahead == '{') ADVANCE(116);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(124);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(255);
      if (lookahead != 0) ADVANCE(118);
      END_STATE();
    case 51:
      if (lookahead == '/') ADVANCE(65);
      END_STATE();
    case 52:
      if (lookahead == '=') ADVANCE(167);
      END_STATE();
    case 53:
      if (lookahead == '=') ADVANCE(167);
      if (lookahead == '>') ADVANCE(235);
      END_STATE();
    case 54:
      if (lookahead == '=') ADVANCE(142);
      END_STATE();
    case 55:
      if (lookahead == '=') ADVANCE(147);
      END_STATE();
    case 56:
      if (lookahead == '=') ADVANCE(140);
      END_STATE();
    case 57:
      if (lookahead == '=') ADVANCE(138);
      END_STATE();
    case 58:
      if (lookahead == '=') ADVANCE(139);
      END_STATE();
    case 59:
      if (lookahead == '=') ADVANCE(230);
      END_STATE();
    case 60:
      if (lookahead == '=') ADVANCE(148);
      END_STATE();
    case 61:
      if (lookahead == '=') ADVANCE(149);
      END_STATE();
    case 62:
      if (lookahead == '=') ADVANCE(144);
      END_STATE();
    case 63:
      if (lookahead == '=') ADVANCE(145);
      if (lookahead == '>') ADVANCE(66);
      END_STATE();
    case 64:
      if (lookahead == '=') ADVANCE(150);
      END_STATE();
    case 65:
      if (lookahead == '=') ADVANCE(143);
      END_STATE();
    case 66:
      if (lookahead == '=') ADVANCE(146);
      END_STATE();
    case 67:
      if (lookahead == '>') ADVANCE(235);
      END_STATE();
    case 68:
      if (lookahead == '>') ADVANCE(63);
      END_STATE();
    case 69:
      if (lookahead == ']') ADVANCE(231);
      END_STATE();
    case 70:
      if (lookahead == '_') ADVANCE(70);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(99);
      END_STATE();
    case 71:
      if (lookahead == '_') ADVANCE(71);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(102);
      END_STATE();
    case 72:
      if (lookahead == '_') ADVANCE(72);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(103);
      END_STATE();
    case 73:
      if (lookahead == 'c') ADVANCE(40);
      END_STATE();
    case 74:
      if (lookahead == 'c') ADVANCE(233);
      END_STATE();
    case 75:
      if (lookahead == 'n') ADVANCE(73);
      END_STATE();
    case 76:
      if (lookahead == 'n') ADVANCE(74);
      END_STATE();
    case 77:
      if (lookahead == 's') ADVANCE(215);
      END_STATE();
    case 78:
      if (lookahead == 's') ADVANCE(81);
      END_STATE();
    case 79:
      if (lookahead == 'u') ADVANCE(82);
      if (lookahead == 'x') ADVANCE(91);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(128);
      if (lookahead != 0) ADVANCE(126);
      END_STATE();
    case 80:
      if (lookahead == 'y') ADVANCE(75);
      END_STATE();
    case 81:
      if (lookahead == 'y') ADVANCE(76);
      END_STATE();
    case 82:
      if (lookahead == '{') ADVANCE(89);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(90);
      END_STATE();
    case 83:
      if (lookahead == '}') ADVANCE(126);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(83);
      END_STATE();
    case 84:
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(86);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(103);
      END_STATE();
    case 85:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(102);
      END_STATE();
    case 86:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(103);
      END_STATE();
    case 87:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(126);
      END_STATE();
    case 88:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(101);
      END_STATE();
    case 89:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(83);
      END_STATE();
    case 90:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(91);
      END_STATE();
    case 91:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(87);
      END_STATE();
    case 92:
      if (eof) ADVANCE(96);
      if (lookahead == '!') ADVANCE(211);
      if (lookahead == '"') ADVANCE(105);
      if (lookahead == '#') ADVANCE(98);
      if (lookahead == '$') ADVANCE(112);
      if (lookahead == '%') ADVANCE(203);
      if (lookahead == '&') ADVANCE(184);
      if (lookahead == '\'') ADVANCE(107);
      if (lookahead == '(') ADVANCE(151);
      if (lookahead == ')') ADVANCE(152);
      if (lookahead == '*') ADVANCE(199);
      if (lookahead == '+') ADVANCE(193);
      if (lookahead == ',') ADVANCE(130);
      if (lookahead == '-') ADVANCE(209);
      if (lookahead == '.') ADVANCE(219);
      if (lookahead == '/') ADVANCE(201);
      if (lookahead == '0') ADVANCE(100);
      if (lookahead == ':') ADVANCE(132);
      if (lookahead == ';') ADVANCE(228);
      if (lookahead == '<') ADVANCE(169);
      if (lookahead == '=') ADVANCE(136);
      if (lookahead == '>') ADVANCE(173);
      if (lookahead == '?') ADVANCE(157);
      if (lookahead == '@') ADVANCE(229);
      if (lookahead == '[') ADVANCE(129);
      if (lookahead == ']') ADVANCE(131);
      if (lookahead == '^') ADVANCE(181);
      if (lookahead == 'a') ADVANCE(249);
      if (lookahead == 'r') ADVANCE(243);
      if (lookahead == 's') ADVANCE(252);
      if (lookahead == '{') ADVANCE(116);
      if (lookahead == '|') ADVANCE(178);
      if (lookahead == '}') ADVANCE(117);
      if (lookahead == '~') ADVANCE(213);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(92)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(99);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(254);
      END_STATE();
    case 93:
      if (eof) ADVANCE(96);
      if (lookahead == '!') ADVANCE(211);
      if (lookahead == '"') ADVANCE(105);
      if (lookahead == '#') ADVANCE(97);
      if (lookahead == '%') ADVANCE(202);
      if (lookahead == '&') ADVANCE(183);
      if (lookahead == '\'') ADVANCE(107);
      if (lookahead == '(') ADVANCE(151);
      if (lookahead == '*') ADVANCE(198);
      if (lookahead == '+') ADVANCE(192);
      if (lookahead == ',') ADVANCE(130);
      if (lookahead == '-') ADVANCE(208);
      if (lookahead == '.') ADVANCE(221);
      if (lookahead == '/') ADVANCE(200);
      if (lookahead == '0') ADVANCE(100);
      if (lookahead == ':') ADVANCE(132);
      if (lookahead == ';') ADVANCE(228);
      if (lookahead == '<') ADVANCE(170);
      if (lookahead == '=') ADVANCE(52);
      if (lookahead == '>') ADVANCE(174);
      if (lookahead == '?') ADVANCE(158);
      if (lookahead == '@') ADVANCE(229);
      if (lookahead == '[') ADVANCE(129);
      if (lookahead == '^') ADVANCE(180);
      if (lookahead == 'a') ADVANCE(250);
      if (lookahead == 'r') ADVANCE(243);
      if (lookahead == '{') ADVANCE(116);
      if (lookahead == '|') ADVANCE(179);
      if (lookahead == '}') ADVANCE(117);
      if (lookahead == '~') ADVANCE(214);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(93)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(99);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(254);
      END_STATE();
    case 94:
      if (eof) ADVANCE(96);
      if (lookahead == '!') ADVANCE(210);
      if (lookahead == '"') ADVANCE(105);
      if (lookahead == '#') ADVANCE(98);
      if (lookahead == '\'') ADVANCE(107);
      if (lookahead == '(') ADVANCE(151);
      if (lookahead == ')') ADVANCE(152);
      if (lookahead == '*') ADVANCE(198);
      if (lookahead == '+') ADVANCE(44);
      if (lookahead == ',') ADVANCE(130);
      if (lookahead == '-') ADVANCE(208);
      if (lookahead == '.') ADVANCE(47);
      if (lookahead == '/') ADVANCE(38);
      if (lookahead == '0') ADVANCE(100);
      if (lookahead == ':') ADVANCE(132);
      if (lookahead == ';') ADVANCE(228);
      if (lookahead == '<') ADVANCE(168);
      if (lookahead == '=') ADVANCE(133);
      if (lookahead == '>') ADVANCE(172);
      if (lookahead == '?') ADVANCE(155);
      if (lookahead == '@') ADVANCE(229);
      if (lookahead == '[') ADVANCE(129);
      if (lookahead == ']') ADVANCE(131);
      if (lookahead == 'r') ADVANCE(243);
      if (lookahead == '{') ADVANCE(116);
      if (lookahead == '}') ADVANCE(117);
      if (lookahead == '~') ADVANCE(212);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(94)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(99);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(254);
      END_STATE();
    case 95:
      if (eof) ADVANCE(96);
      if (lookahead == '!') ADVANCE(210);
      if (lookahead == '"') ADVANCE(105);
      if (lookahead == '#') ADVANCE(97);
      if (lookahead == '\'') ADVANCE(107);
      if (lookahead == '(') ADVANCE(151);
      if (lookahead == ')') ADVANCE(152);
      if (lookahead == '+') ADVANCE(44);
      if (lookahead == ',') ADVANCE(130);
      if (lookahead == '-') ADVANCE(208);
      if (lookahead == '.') ADVANCE(222);
      if (lookahead == '/') ADVANCE(38);
      if (lookahead == '0') ADVANCE(100);
      if (lookahead == ';') ADVANCE(228);
      if (lookahead == '<') ADVANCE(168);
      if (lookahead == '=') ADVANCE(59);
      if (lookahead == '>') ADVANCE(172);
      if (lookahead == '?') ADVANCE(160);
      if (lookahead == '@') ADVANCE(229);
      if (lookahead == '[') ADVANCE(129);
      if (lookahead == ']') ADVANCE(131);
      if (lookahead == 'r') ADVANCE(243);
      if (lookahead == '{') ADVANCE(116);
      if (lookahead == '}') ADVANCE(117);
      if (lookahead == '~') ADVANCE(212);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(95)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(99);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(254);
      END_STATE();
    case 96:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 97:
      ACCEPT_TOKEN(anon_sym_POUND);
      END_STATE();
    case 98:
      ACCEPT_TOKEN(anon_sym_POUND);
      if (lookahead == '!') ADVANCE(238);
      END_STATE();
    case 99:
      ACCEPT_TOKEN(sym_decimal_integer_literal);
      if (lookahead == '.') ADVANCE(85);
      if (lookahead == '_') ADVANCE(70);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(84);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(99);
      END_STATE();
    case 100:
      ACCEPT_TOKEN(sym_decimal_integer_literal);
      if (lookahead == '.') ADVANCE(85);
      if (lookahead == 'X' ||
          lookahead == 'x') ADVANCE(88);
      if (lookahead == '_') ADVANCE(70);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(84);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(99);
      END_STATE();
    case 101:
      ACCEPT_TOKEN(sym_hex_integer_literal);
      if (lookahead == '_') ADVANCE(88);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(101);
      END_STATE();
    case 102:
      ACCEPT_TOKEN(sym_decimal_floating_point_literal);
      if (lookahead == '_') ADVANCE(71);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(84);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(102);
      END_STATE();
    case 103:
      ACCEPT_TOKEN(sym_decimal_floating_point_literal);
      if (lookahead == '_') ADVANCE(72);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(103);
      END_STATE();
    case 104:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      END_STATE();
    case 105:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      if (lookahead == '"') ADVANCE(28);
      END_STATE();
    case 106:
      ACCEPT_TOKEN(anon_sym_SQUOTE);
      END_STATE();
    case 107:
      ACCEPT_TOKEN(anon_sym_SQUOTE);
      if (lookahead == '\'') ADVANCE(35);
      END_STATE();
    case 108:
      ACCEPT_TOKEN(anon_sym_DQUOTE_DQUOTE_DQUOTE);
      END_STATE();
    case 109:
      ACCEPT_TOKEN(anon_sym_SQUOTE_SQUOTE_SQUOTE);
      END_STATE();
    case 110:
      ACCEPT_TOKEN(anon_sym_r_DQUOTE);
      if (lookahead == '"') ADVANCE(29);
      END_STATE();
    case 111:
      ACCEPT_TOKEN(anon_sym_DOLLAR);
      END_STATE();
    case 112:
      ACCEPT_TOKEN(anon_sym_DOLLAR);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(254);
      END_STATE();
    case 113:
      ACCEPT_TOKEN(anon_sym_r_SQUOTE);
      if (lookahead == '\'') ADVANCE(36);
      END_STATE();
    case 114:
      ACCEPT_TOKEN(anon_sym_r_DQUOTE_DQUOTE_DQUOTE);
      END_STATE();
    case 115:
      ACCEPT_TOKEN(anon_sym_r_SQUOTE_SQUOTE_SQUOTE);
      END_STATE();
    case 116:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 117:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 118:
      ACCEPT_TOKEN(aux_sym__sub_string_test_token1);
      END_STATE();
    case 119:
      ACCEPT_TOKEN(aux_sym__sub_string_test_token1);
      if (lookahead == '"') ADVANCE(105);
      if (lookahead == '$') ADVANCE(111);
      if (lookahead == '\'') ADVANCE(106);
      if (lookahead == '/') ADVANCE(123);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(119);
      if (lookahead != 0 &&
          (lookahead < 'A' || 'Z' < lookahead) &&
          lookahead != '_' &&
          (lookahead < 'a' || '{' < lookahead)) ADVANCE(118);
      END_STATE();
    case 120:
      ACCEPT_TOKEN(aux_sym__sub_string_test_token1);
      if (lookahead == '"') ADVANCE(104);
      if (lookahead == '$') ADVANCE(111);
      if (lookahead == '\'') ADVANCE(107);
      if (lookahead == '/') ADVANCE(123);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(120);
      if (lookahead != 0 &&
          (lookahead < 'A' || 'Z' < lookahead) &&
          lookahead != '_' &&
          (lookahead < 'a' || '{' < lookahead)) ADVANCE(118);
      END_STATE();
    case 121:
      ACCEPT_TOKEN(aux_sym__sub_string_test_token1);
      if (lookahead == '"') ADVANCE(104);
      if (lookahead == '$') ADVANCE(111);
      if (lookahead == '\'') ADVANCE(106);
      if (lookahead == '/') ADVANCE(123);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(121);
      if (lookahead != 0 &&
          (lookahead < 'A' || 'Z' < lookahead) &&
          lookahead != '_' &&
          (lookahead < 'a' || '{' < lookahead)) ADVANCE(118);
      END_STATE();
    case 122:
      ACCEPT_TOKEN(aux_sym__sub_string_test_token1);
      if (lookahead == '$') ADVANCE(255);
      END_STATE();
    case 123:
      ACCEPT_TOKEN(aux_sym__sub_string_test_token1);
      if (lookahead == '*') ADVANCE(265);
      if (lookahead == '/') ADVANCE(257);
      END_STATE();
    case 124:
      ACCEPT_TOKEN(aux_sym__sub_string_test_token1);
      if (lookahead == '/') ADVANCE(123);
      if (lookahead == '\\') ADVANCE(122);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(124);
      if (lookahead != 0 &&
          (lookahead < 'A' || 'Z' < lookahead) &&
          lookahead != '_' &&
          (lookahead < 'a' || '{' < lookahead)) ADVANCE(118);
      END_STATE();
    case 125:
      ACCEPT_TOKEN(aux_sym__sub_string_test_token1);
      if (lookahead == 'u') ADVANCE(82);
      if (lookahead == 'x') ADVANCE(91);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(128);
      if (lookahead != 0) ADVANCE(126);
      END_STATE();
    case 126:
      ACCEPT_TOKEN(sym__unused_escape_sequence);
      END_STATE();
    case 127:
      ACCEPT_TOKEN(sym__unused_escape_sequence);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(126);
      END_STATE();
    case 128:
      ACCEPT_TOKEN(sym__unused_escape_sequence);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(127);
      END_STATE();
    case 129:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 130:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 131:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 132:
      ACCEPT_TOKEN(anon_sym_COLON);
      END_STATE();
    case 133:
      ACCEPT_TOKEN(anon_sym_EQ);
      END_STATE();
    case 134:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(167);
      END_STATE();
    case 135:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(167);
      if (lookahead == '>') ADVANCE(235);
      END_STATE();
    case 136:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(230);
      if (lookahead == '>') ADVANCE(235);
      END_STATE();
    case 137:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '>') ADVANCE(235);
      END_STATE();
    case 138:
      ACCEPT_TOKEN(anon_sym_PLUS_EQ);
      END_STATE();
    case 139:
      ACCEPT_TOKEN(anon_sym_DASH_EQ);
      END_STATE();
    case 140:
      ACCEPT_TOKEN(anon_sym_STAR_EQ);
      END_STATE();
    case 141:
      ACCEPT_TOKEN(anon_sym_SLASH_EQ);
      END_STATE();
    case 142:
      ACCEPT_TOKEN(anon_sym_PERCENT_EQ);
      END_STATE();
    case 143:
      ACCEPT_TOKEN(anon_sym_TILDE_SLASH_EQ);
      END_STATE();
    case 144:
      ACCEPT_TOKEN(anon_sym_LT_LT_EQ);
      END_STATE();
    case 145:
      ACCEPT_TOKEN(anon_sym_GT_GT_EQ);
      END_STATE();
    case 146:
      ACCEPT_TOKEN(anon_sym_GT_GT_GT_EQ);
      END_STATE();
    case 147:
      ACCEPT_TOKEN(anon_sym_AMP_EQ);
      END_STATE();
    case 148:
      ACCEPT_TOKEN(anon_sym_CARET_EQ);
      END_STATE();
    case 149:
      ACCEPT_TOKEN(anon_sym_PIPE_EQ);
      END_STATE();
    case 150:
      ACCEPT_TOKEN(anon_sym_QMARK_QMARK_EQ);
      END_STATE();
    case 151:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 152:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 153:
      ACCEPT_TOKEN(anon_sym_QMARK_QMARK);
      END_STATE();
    case 154:
      ACCEPT_TOKEN(anon_sym_QMARK_QMARK);
      if (lookahead == '=') ADVANCE(150);
      END_STATE();
    case 155:
      ACCEPT_TOKEN(anon_sym_QMARK);
      END_STATE();
    case 156:
      ACCEPT_TOKEN(anon_sym_QMARK);
      if (lookahead == '.') ADVANCE(224);
      END_STATE();
    case 157:
      ACCEPT_TOKEN(anon_sym_QMARK);
      if (lookahead == '.') ADVANCE(224);
      if (lookahead == '?') ADVANCE(154);
      END_STATE();
    case 158:
      ACCEPT_TOKEN(anon_sym_QMARK);
      if (lookahead == '.') ADVANCE(224);
      if (lookahead == '?') ADVANCE(153);
      END_STATE();
    case 159:
      ACCEPT_TOKEN(anon_sym_QMARK);
      if (lookahead == '.') ADVANCE(224);
      if (lookahead == '?') ADVANCE(64);
      END_STATE();
    case 160:
      ACCEPT_TOKEN(anon_sym_QMARK);
      if (lookahead == '.') ADVANCE(223);
      END_STATE();
    case 161:
      ACCEPT_TOKEN(anon_sym_QMARK);
      if (lookahead == '.') ADVANCE(223);
      if (lookahead == '?') ADVANCE(154);
      END_STATE();
    case 162:
      ACCEPT_TOKEN(anon_sym_QMARK);
      if (lookahead == '.') ADVANCE(223);
      if (lookahead == '?') ADVANCE(153);
      END_STATE();
    case 163:
      ACCEPT_TOKEN(anon_sym_QMARK);
      if (lookahead == '.') ADVANCE(46);
      if (lookahead == '?') ADVANCE(153);
      END_STATE();
    case 164:
      ACCEPT_TOKEN(anon_sym_QMARK);
      if (lookahead == '?') ADVANCE(153);
      END_STATE();
    case 165:
      ACCEPT_TOKEN(anon_sym_PIPE_PIPE);
      END_STATE();
    case 166:
      ACCEPT_TOKEN(anon_sym_AMP_AMP);
      END_STATE();
    case 167:
      ACCEPT_TOKEN(sym_equality_operator);
      END_STATE();
    case 168:
      ACCEPT_TOKEN(anon_sym_LT);
      END_STATE();
    case 169:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '<') ADVANCE(186);
      if (lookahead == '=') ADVANCE(175);
      END_STATE();
    case 170:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '<') ADVANCE(185);
      if (lookahead == '=') ADVANCE(175);
      END_STATE();
    case 171:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '<') ADVANCE(62);
      END_STATE();
    case 172:
      ACCEPT_TOKEN(anon_sym_GT);
      END_STATE();
    case 173:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(176);
      if (lookahead == '>') ADVANCE(187);
      END_STATE();
    case 174:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(176);
      if (lookahead == '>') ADVANCE(188);
      END_STATE();
    case 175:
      ACCEPT_TOKEN(anon_sym_LT_EQ);
      END_STATE();
    case 176:
      ACCEPT_TOKEN(anon_sym_GT_EQ);
      END_STATE();
    case 177:
      ACCEPT_TOKEN(anon_sym_PIPE);
      END_STATE();
    case 178:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '=') ADVANCE(149);
      if (lookahead == '|') ADVANCE(165);
      END_STATE();
    case 179:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '|') ADVANCE(165);
      END_STATE();
    case 180:
      ACCEPT_TOKEN(anon_sym_CARET);
      END_STATE();
    case 181:
      ACCEPT_TOKEN(anon_sym_CARET);
      if (lookahead == '=') ADVANCE(148);
      END_STATE();
    case 182:
      ACCEPT_TOKEN(anon_sym_AMP);
      END_STATE();
    case 183:
      ACCEPT_TOKEN(anon_sym_AMP);
      if (lookahead == '&') ADVANCE(166);
      END_STATE();
    case 184:
      ACCEPT_TOKEN(anon_sym_AMP);
      if (lookahead == '&') ADVANCE(166);
      if (lookahead == '=') ADVANCE(147);
      END_STATE();
    case 185:
      ACCEPT_TOKEN(anon_sym_LT_LT);
      END_STATE();
    case 186:
      ACCEPT_TOKEN(anon_sym_LT_LT);
      if (lookahead == '=') ADVANCE(144);
      END_STATE();
    case 187:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      if (lookahead == '=') ADVANCE(145);
      if (lookahead == '>') ADVANCE(190);
      END_STATE();
    case 188:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      if (lookahead == '>') ADVANCE(189);
      END_STATE();
    case 189:
      ACCEPT_TOKEN(anon_sym_GT_GT_GT);
      END_STATE();
    case 190:
      ACCEPT_TOKEN(anon_sym_GT_GT_GT);
      if (lookahead == '=') ADVANCE(146);
      END_STATE();
    case 191:
      ACCEPT_TOKEN(sym__additive_operator);
      END_STATE();
    case 192:
      ACCEPT_TOKEN(sym__additive_operator);
      if (lookahead == '+') ADVANCE(206);
      END_STATE();
    case 193:
      ACCEPT_TOKEN(sym__additive_operator);
      if (lookahead == '+') ADVANCE(206);
      if (lookahead == '=') ADVANCE(138);
      END_STATE();
    case 194:
      ACCEPT_TOKEN(sym__additive_operator);
      if (lookahead == '-') ADVANCE(206);
      END_STATE();
    case 195:
      ACCEPT_TOKEN(sym__additive_operator);
      if (lookahead == '-') ADVANCE(206);
      if (lookahead == '=') ADVANCE(139);
      END_STATE();
    case 196:
      ACCEPT_TOKEN(sym__additive_operator);
      if (lookahead == '=') ADVANCE(138);
      END_STATE();
    case 197:
      ACCEPT_TOKEN(sym__additive_operator);
      if (lookahead == '=') ADVANCE(139);
      END_STATE();
    case 198:
      ACCEPT_TOKEN(anon_sym_STAR);
      END_STATE();
    case 199:
      ACCEPT_TOKEN(anon_sym_STAR);
      if (lookahead == '=') ADVANCE(140);
      END_STATE();
    case 200:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '*') ADVANCE(265);
      if (lookahead == '/') ADVANCE(257);
      END_STATE();
    case 201:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '*') ADVANCE(265);
      if (lookahead == '/') ADVANCE(257);
      if (lookahead == '=') ADVANCE(141);
      END_STATE();
    case 202:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      END_STATE();
    case 203:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      if (lookahead == '=') ADVANCE(142);
      END_STATE();
    case 204:
      ACCEPT_TOKEN(anon_sym_TILDE_SLASH);
      END_STATE();
    case 205:
      ACCEPT_TOKEN(anon_sym_TILDE_SLASH);
      if (lookahead == '=') ADVANCE(143);
      END_STATE();
    case 206:
      ACCEPT_TOKEN(sym_increment_operator);
      END_STATE();
    case 207:
      ACCEPT_TOKEN(anon_sym_DOT_DOT_DOT);
      END_STATE();
    case 208:
      ACCEPT_TOKEN(sym_minus_operator);
      if (lookahead == '-') ADVANCE(206);
      END_STATE();
    case 209:
      ACCEPT_TOKEN(sym_minus_operator);
      if (lookahead == '-') ADVANCE(206);
      if (lookahead == '=') ADVANCE(139);
      END_STATE();
    case 210:
      ACCEPT_TOKEN(sym__exclamation_operator);
      END_STATE();
    case 211:
      ACCEPT_TOKEN(sym__exclamation_operator);
      if (lookahead == '=') ADVANCE(167);
      END_STATE();
    case 212:
      ACCEPT_TOKEN(anon_sym_TILDE);
      END_STATE();
    case 213:
      ACCEPT_TOKEN(anon_sym_TILDE);
      if (lookahead == '/') ADVANCE(205);
      END_STATE();
    case 214:
      ACCEPT_TOKEN(anon_sym_TILDE);
      if (lookahead == '/') ADVANCE(204);
      END_STATE();
    case 215:
      ACCEPT_TOKEN(anon_sym_as);
      END_STATE();
    case 216:
      ACCEPT_TOKEN(anon_sym_as);
      if (lookahead == 'y') ADVANCE(248);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(254);
      END_STATE();
    case 217:
      ACCEPT_TOKEN(anon_sym_as);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(254);
      END_STATE();
    case 218:
      ACCEPT_TOKEN(anon_sym_DOT);
      END_STATE();
    case 219:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '.') ADVANCE(226);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(102);
      END_STATE();
    case 220:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '.') ADVANCE(225);
      END_STATE();
    case 221:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '.') ADVANCE(225);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(102);
      END_STATE();
    case 222:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(102);
      END_STATE();
    case 223:
      ACCEPT_TOKEN(anon_sym_QMARK_DOT);
      END_STATE();
    case 224:
      ACCEPT_TOKEN(anon_sym_QMARK_DOT);
      if (lookahead == '.') ADVANCE(227);
      END_STATE();
    case 225:
      ACCEPT_TOKEN(anon_sym_DOT_DOT);
      END_STATE();
    case 226:
      ACCEPT_TOKEN(anon_sym_DOT_DOT);
      if (lookahead == '.') ADVANCE(207);
      END_STATE();
    case 227:
      ACCEPT_TOKEN(anon_sym_QMARK_DOT_DOT);
      END_STATE();
    case 228:
      ACCEPT_TOKEN(anon_sym_SEMI);
      END_STATE();
    case 229:
      ACCEPT_TOKEN(anon_sym_AT);
      END_STATE();
    case 230:
      ACCEPT_TOKEN(anon_sym_EQ_EQ);
      END_STATE();
    case 231:
      ACCEPT_TOKEN(anon_sym_LBRACK_RBRACK);
      if (lookahead == '=') ADVANCE(232);
      END_STATE();
    case 232:
      ACCEPT_TOKEN(anon_sym_LBRACK_RBRACK_EQ);
      END_STATE();
    case 233:
      ACCEPT_TOKEN(anon_sym_async);
      if (lookahead == '*') ADVANCE(236);
      END_STATE();
    case 234:
      ACCEPT_TOKEN(anon_sym_async);
      if (lookahead == '*') ADVANCE(236);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(254);
      END_STATE();
    case 235:
      ACCEPT_TOKEN(anon_sym_EQ_GT);
      END_STATE();
    case 236:
      ACCEPT_TOKEN(anon_sym_async_STAR);
      END_STATE();
    case 237:
      ACCEPT_TOKEN(anon_sym_sync_STAR);
      END_STATE();
    case 238:
      ACCEPT_TOKEN(anon_sym_POUND_BANG);
      END_STATE();
    case 239:
      ACCEPT_TOKEN(aux_sym_script_tag_token1);
      if (lookahead == '*') ADVANCE(268);
      if (lookahead == '/') ADVANCE(259);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(241);
      END_STATE();
    case 240:
      ACCEPT_TOKEN(aux_sym_script_tag_token1);
      if (lookahead == '/') ADVANCE(239);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(240);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(241);
      END_STATE();
    case 241:
      ACCEPT_TOKEN(aux_sym_script_tag_token1);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(241);
      END_STATE();
    case 242:
      ACCEPT_TOKEN(anon_sym_LF);
      if (lookahead == '\n') ADVANCE(242);
      END_STATE();
    case 243:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '"') ADVANCE(110);
      if (lookahead == '\'') ADVANCE(113);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(254);
      END_STATE();
    case 244:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '*') ADVANCE(237);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(254);
      END_STATE();
    case 245:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'c') ADVANCE(244);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(254);
      END_STATE();
    case 246:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'c') ADVANCE(234);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(254);
      END_STATE();
    case 247:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'n') ADVANCE(245);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(254);
      END_STATE();
    case 248:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'n') ADVANCE(246);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(254);
      END_STATE();
    case 249:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 's') ADVANCE(216);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(254);
      END_STATE();
    case 250:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 's') ADVANCE(217);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(254);
      END_STATE();
    case 251:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 's') ADVANCE(253);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(254);
      END_STATE();
    case 252:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'y') ADVANCE(247);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(254);
      END_STATE();
    case 253:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'y') ADVANCE(248);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(254);
      END_STATE();
    case 254:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(254);
      END_STATE();
    case 255:
      ACCEPT_TOKEN(sym_identifier_dollar_escaped);
      if (lookahead == '\\') ADVANCE(34);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(255);
      END_STATE();
    case 256:
      ACCEPT_TOKEN(anon_sym_SLASH_SLASH);
      if (lookahead == '*') ADVANCE(270);
      if (lookahead == '/') ADVANCE(272);
      if (lookahead != 0) ADVANCE(42);
      END_STATE();
    case 257:
      ACCEPT_TOKEN(anon_sym_SLASH_SLASH);
      if (lookahead == '/') ADVANCE(271);
      END_STATE();
    case 258:
      ACCEPT_TOKEN(anon_sym_SLASH_SLASH);
      if (lookahead == '/') ADVANCE(273);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(264);
      END_STATE();
    case 259:
      ACCEPT_TOKEN(anon_sym_SLASH_SLASH);
      if (lookahead == '/') ADVANCE(274);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(241);
      END_STATE();
    case 260:
      ACCEPT_TOKEN(anon_sym_SLASH_SLASH);
      if (lookahead == '/') ADVANCE(275);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(278);
      END_STATE();
    case 261:
      ACCEPT_TOKEN(aux_sym_comment_token1);
      if (lookahead == '*') ADVANCE(267);
      if (lookahead == '/') ADVANCE(258);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(264);
      END_STATE();
    case 262:
      ACCEPT_TOKEN(aux_sym_comment_token1);
      if (lookahead == '/') ADVANCE(261);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(262);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(264);
      END_STATE();
    case 263:
      ACCEPT_TOKEN(aux_sym_comment_token1);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(262);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '/') ADVANCE(264);
      END_STATE();
    case 264:
      ACCEPT_TOKEN(aux_sym_comment_token1);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(264);
      END_STATE();
    case 265:
      ACCEPT_TOKEN(anon_sym_SLASH_STAR);
      END_STATE();
    case 266:
      ACCEPT_TOKEN(anon_sym_SLASH_STAR);
      if (lookahead == '*') ADVANCE(270);
      if (lookahead != 0 &&
          lookahead != '/') ADVANCE(42);
      END_STATE();
    case 267:
      ACCEPT_TOKEN(anon_sym_SLASH_STAR);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(264);
      END_STATE();
    case 268:
      ACCEPT_TOKEN(anon_sym_SLASH_STAR);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(241);
      END_STATE();
    case 269:
      ACCEPT_TOKEN(anon_sym_SLASH_STAR);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(278);
      END_STATE();
    case 270:
      ACCEPT_TOKEN(aux_sym_comment_token2);
      if (lookahead == '*') ADVANCE(270);
      if (lookahead != 0 &&
          lookahead != '/') ADVANCE(42);
      END_STATE();
    case 271:
      ACCEPT_TOKEN(anon_sym_SLASH_SLASH_SLASH);
      END_STATE();
    case 272:
      ACCEPT_TOKEN(anon_sym_SLASH_SLASH_SLASH);
      if (lookahead == '*') ADVANCE(270);
      if (lookahead != 0) ADVANCE(42);
      END_STATE();
    case 273:
      ACCEPT_TOKEN(anon_sym_SLASH_SLASH_SLASH);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(264);
      END_STATE();
    case 274:
      ACCEPT_TOKEN(anon_sym_SLASH_SLASH_SLASH);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(241);
      END_STATE();
    case 275:
      ACCEPT_TOKEN(anon_sym_SLASH_SLASH_SLASH);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(278);
      END_STATE();
    case 276:
      ACCEPT_TOKEN(aux_sym_documentation_comment_token1);
      if (lookahead == '*') ADVANCE(269);
      if (lookahead == '/') ADVANCE(260);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(278);
      END_STATE();
    case 277:
      ACCEPT_TOKEN(aux_sym_documentation_comment_token1);
      if (lookahead == '/') ADVANCE(276);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(277);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(278);
      END_STATE();
    case 278:
      ACCEPT_TOKEN(aux_sym_documentation_comment_token1);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(278);
      END_STATE();
    default:
      return false;
  }
}

static bool ts_lex_keywords(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (lookahead == 'F') ADVANCE(1);
      if (lookahead == 'a') ADVANCE(2);
      if (lookahead == 'b') ADVANCE(3);
      if (lookahead == 'c') ADVANCE(4);
      if (lookahead == 'd') ADVANCE(5);
      if (lookahead == 'e') ADVANCE(6);
      if (lookahead == 'f') ADVANCE(7);
      if (lookahead == 'g') ADVANCE(8);
      if (lookahead == 'h') ADVANCE(9);
      if (lookahead == 'i') ADVANCE(10);
      if (lookahead == 'l') ADVANCE(11);
      if (lookahead == 'm') ADVANCE(12);
      if (lookahead == 'n') ADVANCE(13);
      if (lookahead == 'o') ADVANCE(14);
      if (lookahead == 'p') ADVANCE(15);
      if (lookahead == 'r') ADVANCE(16);
      if (lookahead == 's') ADVANCE(17);
      if (lookahead == 't') ADVANCE(18);
      if (lookahead == 'v') ADVANCE(19);
      if (lookahead == 'w') ADVANCE(20);
      if (lookahead == 'y') ADVANCE(21);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(0)
      END_STATE();
    case 1:
      if (lookahead == 'u') ADVANCE(22);
      END_STATE();
    case 2:
      if (lookahead == 'b') ADVANCE(23);
      if (lookahead == 's') ADVANCE(24);
      if (lookahead == 'w') ADVANCE(25);
      END_STATE();
    case 3:
      if (lookahead == 'o') ADVANCE(26);
      if (lookahead == 'r') ADVANCE(27);
      END_STATE();
    case 4:
      if (lookahead == 'a') ADVANCE(28);
      if (lookahead == 'l') ADVANCE(29);
      if (lookahead == 'o') ADVANCE(30);
      END_STATE();
    case 5:
      if (lookahead == 'e') ADVANCE(31);
      if (lookahead == 'o') ADVANCE(32);
      if (lookahead == 'y') ADVANCE(33);
      END_STATE();
    case 6:
      if (lookahead == 'l') ADVANCE(34);
      if (lookahead == 'n') ADVANCE(35);
      if (lookahead == 'x') ADVANCE(36);
      END_STATE();
    case 7:
      if (lookahead == 'a') ADVANCE(37);
      if (lookahead == 'i') ADVANCE(38);
      if (lookahead == 'o') ADVANCE(39);
      END_STATE();
    case 8:
      if (lookahead == 'e') ADVANCE(40);
      END_STATE();
    case 9:
      if (lookahead == 'i') ADVANCE(41);
      END_STATE();
    case 10:
      if (lookahead == 'f') ADVANCE(42);
      if (lookahead == 'm') ADVANCE(43);
      if (lookahead == 'n') ADVANCE(44);
      if (lookahead == 's') ADVANCE(45);
      END_STATE();
    case 11:
      if (lookahead == 'a') ADVANCE(46);
      if (lookahead == 'i') ADVANCE(47);
      END_STATE();
    case 12:
      if (lookahead == 'i') ADVANCE(48);
      END_STATE();
    case 13:
      if (lookahead == 'a') ADVANCE(49);
      if (lookahead == 'e') ADVANCE(50);
      if (lookahead == 'u') ADVANCE(51);
      END_STATE();
    case 14:
      if (lookahead == 'f') ADVANCE(52);
      if (lookahead == 'n') ADVANCE(53);
      if (lookahead == 'p') ADVANCE(54);
      END_STATE();
    case 15:
      if (lookahead == 'a') ADVANCE(55);
      END_STATE();
    case 16:
      if (lookahead == 'e') ADVANCE(56);
      END_STATE();
    case 17:
      if (lookahead == 'e') ADVANCE(57);
      if (lookahead == 'h') ADVANCE(58);
      if (lookahead == 't') ADVANCE(59);
      if (lookahead == 'u') ADVANCE(60);
      if (lookahead == 'w') ADVANCE(61);
      END_STATE();
    case 18:
      if (lookahead == 'h') ADVANCE(62);
      if (lookahead == 'r') ADVANCE(63);
      if (lookahead == 'y') ADVANCE(64);
      END_STATE();
    case 19:
      if (lookahead == 'a') ADVANCE(65);
      if (lookahead == 'o') ADVANCE(66);
      END_STATE();
    case 20:
      if (lookahead == 'h') ADVANCE(67);
      if (lookahead == 'i') ADVANCE(68);
      END_STATE();
    case 21:
      if (lookahead == 'i') ADVANCE(69);
      END_STATE();
    case 22:
      if (lookahead == 'n') ADVANCE(70);
      END_STATE();
    case 23:
      if (lookahead == 's') ADVANCE(71);
      END_STATE();
    case 24:
      if (lookahead == 's') ADVANCE(72);
      END_STATE();
    case 25:
      if (lookahead == 'a') ADVANCE(73);
      END_STATE();
    case 26:
      if (lookahead == 'o') ADVANCE(74);
      END_STATE();
    case 27:
      if (lookahead == 'e') ADVANCE(75);
      END_STATE();
    case 28:
      if (lookahead == 's') ADVANCE(76);
      if (lookahead == 't') ADVANCE(77);
      END_STATE();
    case 29:
      if (lookahead == 'a') ADVANCE(78);
      END_STATE();
    case 30:
      if (lookahead == 'n') ADVANCE(79);
      if (lookahead == 'v') ADVANCE(80);
      END_STATE();
    case 31:
      if (lookahead == 'f') ADVANCE(81);
      END_STATE();
    case 32:
      ACCEPT_TOKEN(anon_sym_do);
      if (lookahead == 'u') ADVANCE(82);
      END_STATE();
    case 33:
      if (lookahead == 'n') ADVANCE(83);
      END_STATE();
    case 34:
      if (lookahead == 's') ADVANCE(84);
      END_STATE();
    case 35:
      if (lookahead == 'u') ADVANCE(85);
      END_STATE();
    case 36:
      if (lookahead == 'p') ADVANCE(86);
      if (lookahead == 't') ADVANCE(87);
      END_STATE();
    case 37:
      if (lookahead == 'c') ADVANCE(88);
      if (lookahead == 'l') ADVANCE(89);
      END_STATE();
    case 38:
      if (lookahead == 'n') ADVANCE(90);
      END_STATE();
    case 39:
      if (lookahead == 'r') ADVANCE(91);
      END_STATE();
    case 40:
      if (lookahead == 't') ADVANCE(92);
      END_STATE();
    case 41:
      if (lookahead == 'd') ADVANCE(93);
      END_STATE();
    case 42:
      ACCEPT_TOKEN(anon_sym_if);
      END_STATE();
    case 43:
      if (lookahead == 'p') ADVANCE(94);
      END_STATE();
    case 44:
      ACCEPT_TOKEN(anon_sym_in);
      if (lookahead == 't') ADVANCE(95);
      END_STATE();
    case 45:
      ACCEPT_TOKEN(anon_sym_is);
      END_STATE();
    case 46:
      if (lookahead == 't') ADVANCE(96);
      END_STATE();
    case 47:
      if (lookahead == 'b') ADVANCE(97);
      END_STATE();
    case 48:
      if (lookahead == 'x') ADVANCE(98);
      END_STATE();
    case 49:
      if (lookahead == 't') ADVANCE(99);
      END_STATE();
    case 50:
      if (lookahead == 'w') ADVANCE(100);
      END_STATE();
    case 51:
      if (lookahead == 'l') ADVANCE(101);
      END_STATE();
    case 52:
      ACCEPT_TOKEN(anon_sym_of);
      END_STATE();
    case 53:
      ACCEPT_TOKEN(anon_sym_on);
      END_STATE();
    case 54:
      if (lookahead == 'e') ADVANCE(102);
      END_STATE();
    case 55:
      if (lookahead == 'r') ADVANCE(103);
      END_STATE();
    case 56:
      if (lookahead == 'q') ADVANCE(104);
      if (lookahead == 't') ADVANCE(105);
      END_STATE();
    case 57:
      if (lookahead == 't') ADVANCE(106);
      END_STATE();
    case 58:
      if (lookahead == 'o') ADVANCE(107);
      END_STATE();
    case 59:
      if (lookahead == 'a') ADVANCE(108);
      END_STATE();
    case 60:
      if (lookahead == 'p') ADVANCE(109);
      END_STATE();
    case 61:
      if (lookahead == 'i') ADVANCE(110);
      END_STATE();
    case 62:
      if (lookahead == 'i') ADVANCE(111);
      if (lookahead == 'r') ADVANCE(112);
      END_STATE();
    case 63:
      if (lookahead == 'a') ADVANCE(113);
      if (lookahead == 'u') ADVANCE(114);
      if (lookahead == 'y') ADVANCE(115);
      END_STATE();
    case 64:
      if (lookahead == 'p') ADVANCE(116);
      END_STATE();
    case 65:
      if (lookahead == 'r') ADVANCE(117);
      END_STATE();
    case 66:
      if (lookahead == 'i') ADVANCE(118);
      END_STATE();
    case 67:
      if (lookahead == 'i') ADVANCE(119);
      END_STATE();
    case 68:
      if (lookahead == 't') ADVANCE(120);
      END_STATE();
    case 69:
      if (lookahead == 'e') ADVANCE(121);
      END_STATE();
    case 70:
      if (lookahead == 'c') ADVANCE(122);
      END_STATE();
    case 71:
      if (lookahead == 't') ADVANCE(123);
      END_STATE();
    case 72:
      if (lookahead == 'e') ADVANCE(124);
      END_STATE();
    case 73:
      if (lookahead == 'i') ADVANCE(125);
      END_STATE();
    case 74:
      if (lookahead == 'l') ADVANCE(126);
      END_STATE();
    case 75:
      if (lookahead == 'a') ADVANCE(127);
      END_STATE();
    case 76:
      if (lookahead == 'e') ADVANCE(128);
      END_STATE();
    case 77:
      if (lookahead == 'c') ADVANCE(129);
      END_STATE();
    case 78:
      if (lookahead == 's') ADVANCE(130);
      END_STATE();
    case 79:
      if (lookahead == 's') ADVANCE(131);
      if (lookahead == 't') ADVANCE(132);
      END_STATE();
    case 80:
      if (lookahead == 'a') ADVANCE(133);
      END_STATE();
    case 81:
      if (lookahead == 'a') ADVANCE(134);
      if (lookahead == 'e') ADVANCE(135);
      END_STATE();
    case 82:
      if (lookahead == 'b') ADVANCE(136);
      END_STATE();
    case 83:
      if (lookahead == 'a') ADVANCE(137);
      END_STATE();
    case 84:
      if (lookahead == 'e') ADVANCE(138);
      END_STATE();
    case 85:
      if (lookahead == 'm') ADVANCE(139);
      END_STATE();
    case 86:
      if (lookahead == 'o') ADVANCE(140);
      END_STATE();
    case 87:
      if (lookahead == 'e') ADVANCE(141);
      END_STATE();
    case 88:
      if (lookahead == 't') ADVANCE(142);
      END_STATE();
    case 89:
      if (lookahead == 's') ADVANCE(143);
      END_STATE();
    case 90:
      if (lookahead == 'a') ADVANCE(144);
      END_STATE();
    case 91:
      ACCEPT_TOKEN(anon_sym_for);
      END_STATE();
    case 92:
      ACCEPT_TOKEN(anon_sym_get);
      END_STATE();
    case 93:
      if (lookahead == 'e') ADVANCE(145);
      END_STATE();
    case 94:
      if (lookahead == 'l') ADVANCE(146);
      if (lookahead == 'o') ADVANCE(147);
      END_STATE();
    case 95:
      if (lookahead == 'e') ADVANCE(148);
      END_STATE();
    case 96:
      if (lookahead == 'e') ADVANCE(149);
      END_STATE();
    case 97:
      if (lookahead == 'r') ADVANCE(150);
      END_STATE();
    case 98:
      if (lookahead == 'i') ADVANCE(151);
      END_STATE();
    case 99:
      if (lookahead == 'i') ADVANCE(152);
      END_STATE();
    case 100:
      ACCEPT_TOKEN(anon_sym_new);
      END_STATE();
    case 101:
      if (lookahead == 'l') ADVANCE(153);
      END_STATE();
    case 102:
      if (lookahead == 'r') ADVANCE(154);
      END_STATE();
    case 103:
      if (lookahead == 't') ADVANCE(155);
      END_STATE();
    case 104:
      if (lookahead == 'u') ADVANCE(156);
      END_STATE();
    case 105:
      if (lookahead == 'u') ADVANCE(157);
      END_STATE();
    case 106:
      ACCEPT_TOKEN(anon_sym_set);
      END_STATE();
    case 107:
      if (lookahead == 'w') ADVANCE(158);
      END_STATE();
    case 108:
      if (lookahead == 't') ADVANCE(159);
      END_STATE();
    case 109:
      if (lookahead == 'e') ADVANCE(160);
      END_STATE();
    case 110:
      if (lookahead == 't') ADVANCE(161);
      END_STATE();
    case 111:
      if (lookahead == 's') ADVANCE(162);
      END_STATE();
    case 112:
      if (lookahead == 'o') ADVANCE(163);
      END_STATE();
    case 113:
      if (lookahead == 'n') ADVANCE(164);
      END_STATE();
    case 114:
      if (lookahead == 'e') ADVANCE(165);
      END_STATE();
    case 115:
      ACCEPT_TOKEN(anon_sym_try);
      END_STATE();
    case 116:
      if (lookahead == 'e') ADVANCE(166);
      END_STATE();
    case 117:
      ACCEPT_TOKEN(anon_sym_var);
      END_STATE();
    case 118:
      if (lookahead == 'd') ADVANCE(167);
      END_STATE();
    case 119:
      if (lookahead == 'l') ADVANCE(168);
      END_STATE();
    case 120:
      if (lookahead == 'h') ADVANCE(169);
      END_STATE();
    case 121:
      if (lookahead == 'l') ADVANCE(170);
      END_STATE();
    case 122:
      if (lookahead == 't') ADVANCE(171);
      END_STATE();
    case 123:
      if (lookahead == 'r') ADVANCE(172);
      END_STATE();
    case 124:
      if (lookahead == 'r') ADVANCE(173);
      END_STATE();
    case 125:
      if (lookahead == 't') ADVANCE(174);
      END_STATE();
    case 126:
      ACCEPT_TOKEN(anon_sym_bool);
      END_STATE();
    case 127:
      if (lookahead == 'k') ADVANCE(175);
      END_STATE();
    case 128:
      ACCEPT_TOKEN(sym_case_builtin);
      END_STATE();
    case 129:
      if (lookahead == 'h') ADVANCE(176);
      END_STATE();
    case 130:
      if (lookahead == 's') ADVANCE(177);
      END_STATE();
    case 131:
      if (lookahead == 't') ADVANCE(178);
      END_STATE();
    case 132:
      if (lookahead == 'i') ADVANCE(179);
      END_STATE();
    case 133:
      if (lookahead == 'r') ADVANCE(180);
      END_STATE();
    case 134:
      if (lookahead == 'u') ADVANCE(181);
      END_STATE();
    case 135:
      if (lookahead == 'r') ADVANCE(182);
      END_STATE();
    case 136:
      if (lookahead == 'l') ADVANCE(183);
      END_STATE();
    case 137:
      if (lookahead == 'm') ADVANCE(184);
      END_STATE();
    case 138:
      ACCEPT_TOKEN(anon_sym_else);
      END_STATE();
    case 139:
      ACCEPT_TOKEN(anon_sym_enum);
      END_STATE();
    case 140:
      if (lookahead == 'r') ADVANCE(185);
      END_STATE();
    case 141:
      if (lookahead == 'n') ADVANCE(186);
      if (lookahead == 'r') ADVANCE(187);
      END_STATE();
    case 142:
      if (lookahead == 'o') ADVANCE(188);
      END_STATE();
    case 143:
      if (lookahead == 'e') ADVANCE(189);
      END_STATE();
    case 144:
      if (lookahead == 'l') ADVANCE(190);
      END_STATE();
    case 145:
      ACCEPT_TOKEN(anon_sym_hide);
      END_STATE();
    case 146:
      if (lookahead == 'e') ADVANCE(191);
      END_STATE();
    case 147:
      if (lookahead == 'r') ADVANCE(192);
      END_STATE();
    case 148:
      if (lookahead == 'r') ADVANCE(193);
      END_STATE();
    case 149:
      ACCEPT_TOKEN(anon_sym_late);
      END_STATE();
    case 150:
      if (lookahead == 'a') ADVANCE(194);
      END_STATE();
    case 151:
      if (lookahead == 'n') ADVANCE(195);
      END_STATE();
    case 152:
      if (lookahead == 'v') ADVANCE(196);
      END_STATE();
    case 153:
      ACCEPT_TOKEN(anon_sym_null);
      END_STATE();
    case 154:
      if (lookahead == 'a') ADVANCE(197);
      END_STATE();
    case 155:
      ACCEPT_TOKEN(anon_sym_part);
      END_STATE();
    case 156:
      if (lookahead == 'i') ADVANCE(198);
      END_STATE();
    case 157:
      if (lookahead == 'r') ADVANCE(199);
      END_STATE();
    case 158:
      ACCEPT_TOKEN(anon_sym_show);
      END_STATE();
    case 159:
      if (lookahead == 'i') ADVANCE(200);
      END_STATE();
    case 160:
      if (lookahead == 'r') ADVANCE(201);
      END_STATE();
    case 161:
      if (lookahead == 'c') ADVANCE(202);
      END_STATE();
    case 162:
      ACCEPT_TOKEN(anon_sym_this);
      END_STATE();
    case 163:
      if (lookahead == 'w') ADVANCE(203);
      END_STATE();
    case 164:
      if (lookahead == 's') ADVANCE(204);
      END_STATE();
    case 165:
      ACCEPT_TOKEN(anon_sym_true);
      END_STATE();
    case 166:
      if (lookahead == 'd') ADVANCE(205);
      END_STATE();
    case 167:
      ACCEPT_TOKEN(sym_void_type);
      END_STATE();
    case 168:
      if (lookahead == 'e') ADVANCE(206);
      END_STATE();
    case 169:
      ACCEPT_TOKEN(anon_sym_with);
      END_STATE();
    case 170:
      if (lookahead == 'd') ADVANCE(207);
      END_STATE();
    case 171:
      if (lookahead == 'i') ADVANCE(208);
      END_STATE();
    case 172:
      if (lookahead == 'a') ADVANCE(209);
      END_STATE();
    case 173:
      if (lookahead == 't') ADVANCE(210);
      END_STATE();
    case 174:
      ACCEPT_TOKEN(anon_sym_await);
      END_STATE();
    case 175:
      ACCEPT_TOKEN(sym__break_builtin);
      END_STATE();
    case 176:
      ACCEPT_TOKEN(anon_sym_catch);
      END_STATE();
    case 177:
      ACCEPT_TOKEN(anon_sym_class);
      END_STATE();
    case 178:
      ACCEPT_TOKEN(sym_const_builtin);
      END_STATE();
    case 179:
      if (lookahead == 'n') ADVANCE(211);
      END_STATE();
    case 180:
      if (lookahead == 'i') ADVANCE(212);
      END_STATE();
    case 181:
      if (lookahead == 'l') ADVANCE(213);
      END_STATE();
    case 182:
      if (lookahead == 'r') ADVANCE(214);
      END_STATE();
    case 183:
      if (lookahead == 'e') ADVANCE(215);
      END_STATE();
    case 184:
      if (lookahead == 'i') ADVANCE(216);
      END_STATE();
    case 185:
      if (lookahead == 't') ADVANCE(217);
      END_STATE();
    case 186:
      if (lookahead == 'd') ADVANCE(218);
      if (lookahead == 's') ADVANCE(219);
      END_STATE();
    case 187:
      if (lookahead == 'n') ADVANCE(220);
      END_STATE();
    case 188:
      if (lookahead == 'r') ADVANCE(221);
      END_STATE();
    case 189:
      ACCEPT_TOKEN(anon_sym_false);
      END_STATE();
    case 190:
      ACCEPT_TOKEN(sym_final_builtin);
      if (lookahead == 'l') ADVANCE(222);
      END_STATE();
    case 191:
      if (lookahead == 'm') ADVANCE(223);
      END_STATE();
    case 192:
      if (lookahead == 't') ADVANCE(224);
      END_STATE();
    case 193:
      if (lookahead == 'f') ADVANCE(225);
      END_STATE();
    case 194:
      if (lookahead == 'r') ADVANCE(226);
      END_STATE();
    case 195:
      ACCEPT_TOKEN(anon_sym_mixin);
      END_STATE();
    case 196:
      if (lookahead == 'e') ADVANCE(227);
      END_STATE();
    case 197:
      if (lookahead == 't') ADVANCE(228);
      END_STATE();
    case 198:
      if (lookahead == 'r') ADVANCE(229);
      END_STATE();
    case 199:
      if (lookahead == 'n') ADVANCE(230);
      END_STATE();
    case 200:
      if (lookahead == 'c') ADVANCE(231);
      END_STATE();
    case 201:
      ACCEPT_TOKEN(anon_sym_super);
      END_STATE();
    case 202:
      if (lookahead == 'h') ADVANCE(232);
      END_STATE();
    case 203:
      ACCEPT_TOKEN(anon_sym_throw);
      if (lookahead == 's') ADVANCE(233);
      END_STATE();
    case 204:
      if (lookahead == 'i') ADVANCE(234);
      END_STATE();
    case 205:
      if (lookahead == 'e') ADVANCE(235);
      END_STATE();
    case 206:
      ACCEPT_TOKEN(anon_sym_while);
      END_STATE();
    case 207:
      ACCEPT_TOKEN(anon_sym_yield);
      END_STATE();
    case 208:
      if (lookahead == 'o') ADVANCE(236);
      END_STATE();
    case 209:
      if (lookahead == 'c') ADVANCE(237);
      END_STATE();
    case 210:
      ACCEPT_TOKEN(sym__assert_builtin);
      END_STATE();
    case 211:
      if (lookahead == 'u') ADVANCE(238);
      END_STATE();
    case 212:
      if (lookahead == 'a') ADVANCE(239);
      END_STATE();
    case 213:
      if (lookahead == 't') ADVANCE(240);
      END_STATE();
    case 214:
      if (lookahead == 'e') ADVANCE(241);
      END_STATE();
    case 215:
      ACCEPT_TOKEN(sym_floating_point_type);
      END_STATE();
    case 216:
      if (lookahead == 'c') ADVANCE(242);
      END_STATE();
    case 217:
      ACCEPT_TOKEN(anon_sym_export);
      END_STATE();
    case 218:
      if (lookahead == 's') ADVANCE(243);
      END_STATE();
    case 219:
      if (lookahead == 'i') ADVANCE(244);
      END_STATE();
    case 220:
      if (lookahead == 'a') ADVANCE(245);
      END_STATE();
    case 221:
      if (lookahead == 'y') ADVANCE(246);
      END_STATE();
    case 222:
      if (lookahead == 'y') ADVANCE(247);
      END_STATE();
    case 223:
      if (lookahead == 'e') ADVANCE(248);
      END_STATE();
    case 224:
      ACCEPT_TOKEN(anon_sym_import);
      END_STATE();
    case 225:
      if (lookahead == 'a') ADVANCE(249);
      END_STATE();
    case 226:
      if (lookahead == 'y') ADVANCE(250);
      END_STATE();
    case 227:
      ACCEPT_TOKEN(anon_sym_native);
      END_STATE();
    case 228:
      if (lookahead == 'o') ADVANCE(251);
      END_STATE();
    case 229:
      if (lookahead == 'e') ADVANCE(252);
      END_STATE();
    case 230:
      ACCEPT_TOKEN(anon_sym_return);
      END_STATE();
    case 231:
      ACCEPT_TOKEN(anon_sym_static);
      END_STATE();
    case 232:
      ACCEPT_TOKEN(anon_sym_switch);
      END_STATE();
    case 233:
      ACCEPT_TOKEN(anon_sym_throws);
      END_STATE();
    case 234:
      if (lookahead == 't') ADVANCE(253);
      END_STATE();
    case 235:
      if (lookahead == 'f') ADVANCE(254);
      END_STATE();
    case 236:
      if (lookahead == 'n') ADVANCE(255);
      END_STATE();
    case 237:
      if (lookahead == 't') ADVANCE(256);
      END_STATE();
    case 238:
      if (lookahead == 'e') ADVANCE(257);
      END_STATE();
    case 239:
      if (lookahead == 'n') ADVANCE(258);
      END_STATE();
    case 240:
      ACCEPT_TOKEN(anon_sym_default);
      END_STATE();
    case 241:
      if (lookahead == 'd') ADVANCE(259);
      END_STATE();
    case 242:
      ACCEPT_TOKEN(anon_sym_dynamic);
      END_STATE();
    case 243:
      ACCEPT_TOKEN(anon_sym_extends);
      END_STATE();
    case 244:
      if (lookahead == 'o') ADVANCE(260);
      END_STATE();
    case 245:
      if (lookahead == 'l') ADVANCE(261);
      END_STATE();
    case 246:
      ACCEPT_TOKEN(anon_sym_factory);
      END_STATE();
    case 247:
      ACCEPT_TOKEN(anon_sym_finally);
      END_STATE();
    case 248:
      if (lookahead == 'n') ADVANCE(262);
      END_STATE();
    case 249:
      if (lookahead == 'c') ADVANCE(263);
      END_STATE();
    case 250:
      ACCEPT_TOKEN(anon_sym_library);
      END_STATE();
    case 251:
      if (lookahead == 'r') ADVANCE(264);
      END_STATE();
    case 252:
      if (lookahead == 'd') ADVANCE(265);
      END_STATE();
    case 253:
      if (lookahead == 'i') ADVANCE(266);
      END_STATE();
    case 254:
      ACCEPT_TOKEN(anon_sym_typedef);
      END_STATE();
    case 255:
      ACCEPT_TOKEN(anon_sym_Function);
      END_STATE();
    case 256:
      ACCEPT_TOKEN(anon_sym_abstract);
      END_STATE();
    case 257:
      ACCEPT_TOKEN(anon_sym_continue);
      END_STATE();
    case 258:
      if (lookahead == 't') ADVANCE(267);
      END_STATE();
    case 259:
      ACCEPT_TOKEN(anon_sym_deferred);
      END_STATE();
    case 260:
      if (lookahead == 'n') ADVANCE(268);
      END_STATE();
    case 261:
      ACCEPT_TOKEN(anon_sym_external);
      END_STATE();
    case 262:
      if (lookahead == 't') ADVANCE(269);
      END_STATE();
    case 263:
      if (lookahead == 'e') ADVANCE(270);
      END_STATE();
    case 264:
      ACCEPT_TOKEN(anon_sym_operator);
      END_STATE();
    case 265:
      ACCEPT_TOKEN(anon_sym_required);
      END_STATE();
    case 266:
      if (lookahead == 'v') ADVANCE(271);
      END_STATE();
    case 267:
      ACCEPT_TOKEN(anon_sym_covariant);
      END_STATE();
    case 268:
      ACCEPT_TOKEN(anon_sym_extension);
      END_STATE();
    case 269:
      if (lookahead == 's') ADVANCE(272);
      END_STATE();
    case 270:
      ACCEPT_TOKEN(anon_sym_interface);
      END_STATE();
    case 271:
      if (lookahead == 'e') ADVANCE(273);
      END_STATE();
    case 272:
      ACCEPT_TOKEN(anon_sym_implements);
      END_STATE();
    case 273:
      ACCEPT_TOKEN(anon_sym_transitive);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0, .external_lex_state = 1},
  [1] = {.lex_state = 94, .external_lex_state = 2},
  [2] = {.lex_state = 94, .external_lex_state = 2},
  [3] = {.lex_state = 94, .external_lex_state = 2},
  [4] = {.lex_state = 94, .external_lex_state = 2},
  [5] = {.lex_state = 94, .external_lex_state = 2},
  [6] = {.lex_state = 94, .external_lex_state = 2},
  [7] = {.lex_state = 94, .external_lex_state = 2},
  [8] = {.lex_state = 94, .external_lex_state = 2},
  [9] = {.lex_state = 94, .external_lex_state = 2},
  [10] = {.lex_state = 94, .external_lex_state = 2},
  [11] = {.lex_state = 94, .external_lex_state = 2},
  [12] = {.lex_state = 94, .external_lex_state = 2},
  [13] = {.lex_state = 94, .external_lex_state = 2},
  [14] = {.lex_state = 94, .external_lex_state = 2},
  [15] = {.lex_state = 94, .external_lex_state = 2},
  [16] = {.lex_state = 94, .external_lex_state = 2},
  [17] = {.lex_state = 94, .external_lex_state = 2},
  [18] = {.lex_state = 94, .external_lex_state = 2},
  [19] = {.lex_state = 94, .external_lex_state = 2},
  [20] = {.lex_state = 94, .external_lex_state = 2},
  [21] = {.lex_state = 94, .external_lex_state = 2},
  [22] = {.lex_state = 94, .external_lex_state = 2},
  [23] = {.lex_state = 94, .external_lex_state = 2},
  [24] = {.lex_state = 94, .external_lex_state = 2},
  [25] = {.lex_state = 94, .external_lex_state = 2},
  [26] = {.lex_state = 94, .external_lex_state = 2},
  [27] = {.lex_state = 94, .external_lex_state = 2},
  [28] = {.lex_state = 94, .external_lex_state = 2},
  [29] = {.lex_state = 94, .external_lex_state = 2},
  [30] = {.lex_state = 94, .external_lex_state = 2},
  [31] = {.lex_state = 94, .external_lex_state = 2},
  [32] = {.lex_state = 94, .external_lex_state = 2},
  [33] = {.lex_state = 94, .external_lex_state = 2},
  [34] = {.lex_state = 94, .external_lex_state = 2},
  [35] = {.lex_state = 94, .external_lex_state = 2},
  [36] = {.lex_state = 94, .external_lex_state = 2},
  [37] = {.lex_state = 94, .external_lex_state = 2},
  [38] = {.lex_state = 94, .external_lex_state = 2},
  [39] = {.lex_state = 94, .external_lex_state = 2},
  [40] = {.lex_state = 94, .external_lex_state = 2},
  [41] = {.lex_state = 94, .external_lex_state = 2},
  [42] = {.lex_state = 94, .external_lex_state = 2},
  [43] = {.lex_state = 94, .external_lex_state = 2},
  [44] = {.lex_state = 94, .external_lex_state = 2},
  [45] = {.lex_state = 94, .external_lex_state = 2},
  [46] = {.lex_state = 94, .external_lex_state = 2},
  [47] = {.lex_state = 94, .external_lex_state = 2},
  [48] = {.lex_state = 94, .external_lex_state = 2},
  [49] = {.lex_state = 94, .external_lex_state = 2},
  [50] = {.lex_state = 94, .external_lex_state = 2},
  [51] = {.lex_state = 94, .external_lex_state = 2},
  [52] = {.lex_state = 94, .external_lex_state = 2},
  [53] = {.lex_state = 94, .external_lex_state = 2},
  [54] = {.lex_state = 94, .external_lex_state = 2},
  [55] = {.lex_state = 94, .external_lex_state = 2},
  [56] = {.lex_state = 94, .external_lex_state = 2},
  [57] = {.lex_state = 94, .external_lex_state = 2},
  [58] = {.lex_state = 94, .external_lex_state = 2},
  [59] = {.lex_state = 94, .external_lex_state = 2},
  [60] = {.lex_state = 94, .external_lex_state = 2},
  [61] = {.lex_state = 94, .external_lex_state = 2},
  [62] = {.lex_state = 94, .external_lex_state = 2},
  [63] = {.lex_state = 94, .external_lex_state = 2},
  [64] = {.lex_state = 94, .external_lex_state = 2},
  [65] = {.lex_state = 94, .external_lex_state = 2},
  [66] = {.lex_state = 94, .external_lex_state = 2},
  [67] = {.lex_state = 94, .external_lex_state = 2},
  [68] = {.lex_state = 94, .external_lex_state = 2},
  [69] = {.lex_state = 94, .external_lex_state = 2},
  [70] = {.lex_state = 94, .external_lex_state = 2},
  [71] = {.lex_state = 94, .external_lex_state = 2},
  [72] = {.lex_state = 94, .external_lex_state = 2},
  [73] = {.lex_state = 94, .external_lex_state = 2},
  [74] = {.lex_state = 94, .external_lex_state = 2},
  [75] = {.lex_state = 94, .external_lex_state = 2},
  [76] = {.lex_state = 94, .external_lex_state = 2},
  [77] = {.lex_state = 94, .external_lex_state = 2},
  [78] = {.lex_state = 94, .external_lex_state = 2},
  [79] = {.lex_state = 94, .external_lex_state = 2},
  [80] = {.lex_state = 94, .external_lex_state = 2},
  [81] = {.lex_state = 94, .external_lex_state = 2},
  [82] = {.lex_state = 94, .external_lex_state = 2},
  [83] = {.lex_state = 94, .external_lex_state = 2},
  [84] = {.lex_state = 94, .external_lex_state = 2},
  [85] = {.lex_state = 94, .external_lex_state = 2},
  [86] = {.lex_state = 94, .external_lex_state = 2},
  [87] = {.lex_state = 94, .external_lex_state = 2},
  [88] = {.lex_state = 94, .external_lex_state = 2},
  [89] = {.lex_state = 94, .external_lex_state = 2},
  [90] = {.lex_state = 94, .external_lex_state = 2},
  [91] = {.lex_state = 94, .external_lex_state = 2},
  [92] = {.lex_state = 94, .external_lex_state = 2},
  [93] = {.lex_state = 94, .external_lex_state = 2},
  [94] = {.lex_state = 94, .external_lex_state = 2},
  [95] = {.lex_state = 94, .external_lex_state = 2},
  [96] = {.lex_state = 94, .external_lex_state = 2},
  [97] = {.lex_state = 94, .external_lex_state = 2},
  [98] = {.lex_state = 94, .external_lex_state = 2},
  [99] = {.lex_state = 94, .external_lex_state = 2},
  [100] = {.lex_state = 94, .external_lex_state = 2},
  [101] = {.lex_state = 94, .external_lex_state = 2},
  [102] = {.lex_state = 94, .external_lex_state = 2},
  [103] = {.lex_state = 94, .external_lex_state = 2},
  [104] = {.lex_state = 94, .external_lex_state = 2},
  [105] = {.lex_state = 94, .external_lex_state = 2},
  [106] = {.lex_state = 94, .external_lex_state = 2},
  [107] = {.lex_state = 94, .external_lex_state = 2},
  [108] = {.lex_state = 94, .external_lex_state = 2},
  [109] = {.lex_state = 94, .external_lex_state = 2},
  [110] = {.lex_state = 94, .external_lex_state = 2},
  [111] = {.lex_state = 94, .external_lex_state = 2},
  [112] = {.lex_state = 94, .external_lex_state = 2},
  [113] = {.lex_state = 94, .external_lex_state = 2},
  [114] = {.lex_state = 94, .external_lex_state = 2},
  [115] = {.lex_state = 94, .external_lex_state = 2},
  [116] = {.lex_state = 94, .external_lex_state = 2},
  [117] = {.lex_state = 94, .external_lex_state = 2},
  [118] = {.lex_state = 94, .external_lex_state = 2},
  [119] = {.lex_state = 94, .external_lex_state = 2},
  [120] = {.lex_state = 94, .external_lex_state = 2},
  [121] = {.lex_state = 94, .external_lex_state = 2},
  [122] = {.lex_state = 94, .external_lex_state = 2},
  [123] = {.lex_state = 94, .external_lex_state = 2},
  [124] = {.lex_state = 94, .external_lex_state = 2},
  [125] = {.lex_state = 94, .external_lex_state = 2},
  [126] = {.lex_state = 94, .external_lex_state = 2},
  [127] = {.lex_state = 94, .external_lex_state = 2},
  [128] = {.lex_state = 94, .external_lex_state = 2},
  [129] = {.lex_state = 94, .external_lex_state = 2},
  [130] = {.lex_state = 94, .external_lex_state = 2},
  [131] = {.lex_state = 94, .external_lex_state = 2},
  [132] = {.lex_state = 94, .external_lex_state = 2},
  [133] = {.lex_state = 94, .external_lex_state = 2},
  [134] = {.lex_state = 94, .external_lex_state = 2},
  [135] = {.lex_state = 94, .external_lex_state = 2},
  [136] = {.lex_state = 94, .external_lex_state = 2},
  [137] = {.lex_state = 94, .external_lex_state = 2},
  [138] = {.lex_state = 94, .external_lex_state = 2},
  [139] = {.lex_state = 94, .external_lex_state = 2},
  [140] = {.lex_state = 94, .external_lex_state = 2},
  [141] = {.lex_state = 94, .external_lex_state = 2},
  [142] = {.lex_state = 94, .external_lex_state = 2},
  [143] = {.lex_state = 94, .external_lex_state = 2},
  [144] = {.lex_state = 94, .external_lex_state = 2},
  [145] = {.lex_state = 94, .external_lex_state = 2},
  [146] = {.lex_state = 94, .external_lex_state = 2},
  [147] = {.lex_state = 94, .external_lex_state = 2},
  [148] = {.lex_state = 94, .external_lex_state = 2},
  [149] = {.lex_state = 94, .external_lex_state = 2},
  [150] = {.lex_state = 94, .external_lex_state = 2},
  [151] = {.lex_state = 94, .external_lex_state = 2},
  [152] = {.lex_state = 94, .external_lex_state = 2},
  [153] = {.lex_state = 94, .external_lex_state = 2},
  [154] = {.lex_state = 94, .external_lex_state = 2},
  [155] = {.lex_state = 94, .external_lex_state = 2},
  [156] = {.lex_state = 94, .external_lex_state = 2},
  [157] = {.lex_state = 94, .external_lex_state = 2},
  [158] = {.lex_state = 94, .external_lex_state = 2},
  [159] = {.lex_state = 94, .external_lex_state = 2},
  [160] = {.lex_state = 94, .external_lex_state = 2},
  [161] = {.lex_state = 94, .external_lex_state = 2},
  [162] = {.lex_state = 94, .external_lex_state = 2},
  [163] = {.lex_state = 94, .external_lex_state = 2},
  [164] = {.lex_state = 94, .external_lex_state = 2},
  [165] = {.lex_state = 94, .external_lex_state = 2},
  [166] = {.lex_state = 94, .external_lex_state = 2},
  [167] = {.lex_state = 94, .external_lex_state = 2},
  [168] = {.lex_state = 94, .external_lex_state = 2},
  [169] = {.lex_state = 94, .external_lex_state = 2},
  [170] = {.lex_state = 94, .external_lex_state = 2},
  [171] = {.lex_state = 94, .external_lex_state = 2},
  [172] = {.lex_state = 94, .external_lex_state = 2},
  [173] = {.lex_state = 94, .external_lex_state = 2},
  [174] = {.lex_state = 94, .external_lex_state = 2},
  [175] = {.lex_state = 94, .external_lex_state = 2},
  [176] = {.lex_state = 94, .external_lex_state = 2},
  [177] = {.lex_state = 94, .external_lex_state = 2},
  [178] = {.lex_state = 94, .external_lex_state = 2},
  [179] = {.lex_state = 94, .external_lex_state = 2},
  [180] = {.lex_state = 94, .external_lex_state = 2},
  [181] = {.lex_state = 94, .external_lex_state = 2},
  [182] = {.lex_state = 94, .external_lex_state = 2},
  [183] = {.lex_state = 94, .external_lex_state = 2},
  [184] = {.lex_state = 94, .external_lex_state = 2},
  [185] = {.lex_state = 94, .external_lex_state = 2},
  [186] = {.lex_state = 94, .external_lex_state = 2},
  [187] = {.lex_state = 94, .external_lex_state = 2},
  [188] = {.lex_state = 94, .external_lex_state = 2},
  [189] = {.lex_state = 94, .external_lex_state = 2},
  [190] = {.lex_state = 94, .external_lex_state = 2},
  [191] = {.lex_state = 94, .external_lex_state = 2},
  [192] = {.lex_state = 94, .external_lex_state = 2},
  [193] = {.lex_state = 94, .external_lex_state = 2},
  [194] = {.lex_state = 94, .external_lex_state = 2},
  [195] = {.lex_state = 94, .external_lex_state = 2},
  [196] = {.lex_state = 94, .external_lex_state = 2},
  [197] = {.lex_state = 94, .external_lex_state = 2},
  [198] = {.lex_state = 94, .external_lex_state = 2},
  [199] = {.lex_state = 94, .external_lex_state = 2},
  [200] = {.lex_state = 94, .external_lex_state = 2},
  [201] = {.lex_state = 94, .external_lex_state = 2},
  [202] = {.lex_state = 94, .external_lex_state = 2},
  [203] = {.lex_state = 94, .external_lex_state = 2},
  [204] = {.lex_state = 94, .external_lex_state = 2},
  [205] = {.lex_state = 94, .external_lex_state = 2},
  [206] = {.lex_state = 94, .external_lex_state = 2},
  [207] = {.lex_state = 94, .external_lex_state = 2},
  [208] = {.lex_state = 94, .external_lex_state = 2},
  [209] = {.lex_state = 94, .external_lex_state = 2},
  [210] = {.lex_state = 94, .external_lex_state = 2},
  [211] = {.lex_state = 94, .external_lex_state = 2},
  [212] = {.lex_state = 94, .external_lex_state = 2},
  [213] = {.lex_state = 94, .external_lex_state = 2},
  [214] = {.lex_state = 94, .external_lex_state = 2},
  [215] = {.lex_state = 94, .external_lex_state = 2},
  [216] = {.lex_state = 94, .external_lex_state = 2},
  [217] = {.lex_state = 94, .external_lex_state = 2},
  [218] = {.lex_state = 94, .external_lex_state = 2},
  [219] = {.lex_state = 94, .external_lex_state = 2},
  [220] = {.lex_state = 94, .external_lex_state = 2},
  [221] = {.lex_state = 94, .external_lex_state = 2},
  [222] = {.lex_state = 94, .external_lex_state = 2},
  [223] = {.lex_state = 94, .external_lex_state = 2},
  [224] = {.lex_state = 94, .external_lex_state = 2},
  [225] = {.lex_state = 94, .external_lex_state = 2},
  [226] = {.lex_state = 94, .external_lex_state = 2},
  [227] = {.lex_state = 94, .external_lex_state = 2},
  [228] = {.lex_state = 94, .external_lex_state = 2},
  [229] = {.lex_state = 94, .external_lex_state = 2},
  [230] = {.lex_state = 94, .external_lex_state = 2},
  [231] = {.lex_state = 94, .external_lex_state = 2},
  [232] = {.lex_state = 94, .external_lex_state = 2},
  [233] = {.lex_state = 94, .external_lex_state = 2},
  [234] = {.lex_state = 94, .external_lex_state = 2},
  [235] = {.lex_state = 94, .external_lex_state = 2},
  [236] = {.lex_state = 94, .external_lex_state = 2},
  [237] = {.lex_state = 94, .external_lex_state = 2},
  [238] = {.lex_state = 94, .external_lex_state = 2},
  [239] = {.lex_state = 94, .external_lex_state = 2},
  [240] = {.lex_state = 94, .external_lex_state = 2},
  [241] = {.lex_state = 94, .external_lex_state = 2},
  [242] = {.lex_state = 94, .external_lex_state = 2},
  [243] = {.lex_state = 94, .external_lex_state = 2},
  [244] = {.lex_state = 94, .external_lex_state = 2},
  [245] = {.lex_state = 94, .external_lex_state = 2},
  [246] = {.lex_state = 94, .external_lex_state = 2},
  [247] = {.lex_state = 94, .external_lex_state = 2},
  [248] = {.lex_state = 94, .external_lex_state = 2},
  [249] = {.lex_state = 94, .external_lex_state = 2},
  [250] = {.lex_state = 94, .external_lex_state = 2},
  [251] = {.lex_state = 94, .external_lex_state = 2},
  [252] = {.lex_state = 94, .external_lex_state = 2},
  [253] = {.lex_state = 94, .external_lex_state = 2},
  [254] = {.lex_state = 94, .external_lex_state = 2},
  [255] = {.lex_state = 94, .external_lex_state = 2},
  [256] = {.lex_state = 94, .external_lex_state = 2},
  [257] = {.lex_state = 94, .external_lex_state = 2},
  [258] = {.lex_state = 94, .external_lex_state = 2},
  [259] = {.lex_state = 94, .external_lex_state = 2},
  [260] = {.lex_state = 94, .external_lex_state = 2},
  [261] = {.lex_state = 94, .external_lex_state = 2},
  [262] = {.lex_state = 94, .external_lex_state = 2},
  [263] = {.lex_state = 94, .external_lex_state = 2},
  [264] = {.lex_state = 94, .external_lex_state = 2},
  [265] = {.lex_state = 94, .external_lex_state = 2},
  [266] = {.lex_state = 94, .external_lex_state = 2},
  [267] = {.lex_state = 94, .external_lex_state = 2},
  [268] = {.lex_state = 94, .external_lex_state = 2},
  [269] = {.lex_state = 94, .external_lex_state = 2},
  [270] = {.lex_state = 94, .external_lex_state = 2},
  [271] = {.lex_state = 94, .external_lex_state = 2},
  [272] = {.lex_state = 94, .external_lex_state = 2},
  [273] = {.lex_state = 94, .external_lex_state = 2},
  [274] = {.lex_state = 94, .external_lex_state = 2},
  [275] = {.lex_state = 94, .external_lex_state = 2},
  [276] = {.lex_state = 94, .external_lex_state = 2},
  [277] = {.lex_state = 94, .external_lex_state = 2},
  [278] = {.lex_state = 94, .external_lex_state = 2},
  [279] = {.lex_state = 94, .external_lex_state = 2},
  [280] = {.lex_state = 94, .external_lex_state = 2},
  [281] = {.lex_state = 94, .external_lex_state = 2},
  [282] = {.lex_state = 94, .external_lex_state = 2},
  [283] = {.lex_state = 94, .external_lex_state = 2},
  [284] = {.lex_state = 94, .external_lex_state = 2},
  [285] = {.lex_state = 94, .external_lex_state = 2},
  [286] = {.lex_state = 94, .external_lex_state = 2},
  [287] = {.lex_state = 94, .external_lex_state = 2},
  [288] = {.lex_state = 94, .external_lex_state = 2},
  [289] = {.lex_state = 94, .external_lex_state = 2},
  [290] = {.lex_state = 94, .external_lex_state = 2},
  [291] = {.lex_state = 94, .external_lex_state = 2},
  [292] = {.lex_state = 94, .external_lex_state = 2},
  [293] = {.lex_state = 94, .external_lex_state = 2},
  [294] = {.lex_state = 94, .external_lex_state = 2},
  [295] = {.lex_state = 94, .external_lex_state = 2},
  [296] = {.lex_state = 94, .external_lex_state = 2},
  [297] = {.lex_state = 94, .external_lex_state = 2},
  [298] = {.lex_state = 94, .external_lex_state = 2},
  [299] = {.lex_state = 94, .external_lex_state = 2},
  [300] = {.lex_state = 94, .external_lex_state = 2},
  [301] = {.lex_state = 94, .external_lex_state = 2},
  [302] = {.lex_state = 94, .external_lex_state = 2},
  [303] = {.lex_state = 94, .external_lex_state = 2},
  [304] = {.lex_state = 94, .external_lex_state = 2},
  [305] = {.lex_state = 94, .external_lex_state = 2},
  [306] = {.lex_state = 94, .external_lex_state = 2},
  [307] = {.lex_state = 94, .external_lex_state = 2},
  [308] = {.lex_state = 94, .external_lex_state = 2},
  [309] = {.lex_state = 94, .external_lex_state = 2},
  [310] = {.lex_state = 94, .external_lex_state = 2},
  [311] = {.lex_state = 94, .external_lex_state = 2},
  [312] = {.lex_state = 94, .external_lex_state = 2},
  [313] = {.lex_state = 94, .external_lex_state = 2},
  [314] = {.lex_state = 94, .external_lex_state = 2},
  [315] = {.lex_state = 94, .external_lex_state = 2},
  [316] = {.lex_state = 94, .external_lex_state = 2},
  [317] = {.lex_state = 94, .external_lex_state = 2},
  [318] = {.lex_state = 94, .external_lex_state = 2},
  [319] = {.lex_state = 94, .external_lex_state = 2},
  [320] = {.lex_state = 94, .external_lex_state = 2},
  [321] = {.lex_state = 94, .external_lex_state = 2},
  [322] = {.lex_state = 94, .external_lex_state = 2},
  [323] = {.lex_state = 94, .external_lex_state = 2},
  [324] = {.lex_state = 94, .external_lex_state = 2},
  [325] = {.lex_state = 94, .external_lex_state = 2},
  [326] = {.lex_state = 94, .external_lex_state = 2},
  [327] = {.lex_state = 94, .external_lex_state = 2},
  [328] = {.lex_state = 94, .external_lex_state = 2},
  [329] = {.lex_state = 94, .external_lex_state = 2},
  [330] = {.lex_state = 94, .external_lex_state = 2},
  [331] = {.lex_state = 94, .external_lex_state = 2},
  [332] = {.lex_state = 94, .external_lex_state = 2},
  [333] = {.lex_state = 94, .external_lex_state = 2},
  [334] = {.lex_state = 94, .external_lex_state = 2},
  [335] = {.lex_state = 94, .external_lex_state = 2},
  [336] = {.lex_state = 94, .external_lex_state = 2},
  [337] = {.lex_state = 94, .external_lex_state = 2},
  [338] = {.lex_state = 94, .external_lex_state = 2},
  [339] = {.lex_state = 94, .external_lex_state = 2},
  [340] = {.lex_state = 94, .external_lex_state = 2},
  [341] = {.lex_state = 94, .external_lex_state = 2},
  [342] = {.lex_state = 94, .external_lex_state = 2},
  [343] = {.lex_state = 94, .external_lex_state = 2},
  [344] = {.lex_state = 94, .external_lex_state = 2},
  [345] = {.lex_state = 94, .external_lex_state = 2},
  [346] = {.lex_state = 94, .external_lex_state = 2},
  [347] = {.lex_state = 94, .external_lex_state = 2},
  [348] = {.lex_state = 94, .external_lex_state = 2},
  [349] = {.lex_state = 93, .external_lex_state = 2},
  [350] = {.lex_state = 93, .external_lex_state = 2},
  [351] = {.lex_state = 93, .external_lex_state = 2},
  [352] = {.lex_state = 94, .external_lex_state = 2},
  [353] = {.lex_state = 94, .external_lex_state = 2},
  [354] = {.lex_state = 94, .external_lex_state = 2},
  [355] = {.lex_state = 94, .external_lex_state = 2},
  [356] = {.lex_state = 94, .external_lex_state = 2},
  [357] = {.lex_state = 94, .external_lex_state = 2},
  [358] = {.lex_state = 94, .external_lex_state = 2},
  [359] = {.lex_state = 94, .external_lex_state = 2},
  [360] = {.lex_state = 94, .external_lex_state = 2},
  [361] = {.lex_state = 94, .external_lex_state = 2},
  [362] = {.lex_state = 94, .external_lex_state = 2},
  [363] = {.lex_state = 94, .external_lex_state = 2},
  [364] = {.lex_state = 94, .external_lex_state = 2},
  [365] = {.lex_state = 94, .external_lex_state = 2},
  [366] = {.lex_state = 94, .external_lex_state = 2},
  [367] = {.lex_state = 94, .external_lex_state = 2},
  [368] = {.lex_state = 94, .external_lex_state = 2},
  [369] = {.lex_state = 94, .external_lex_state = 2},
  [370] = {.lex_state = 94, .external_lex_state = 2},
  [371] = {.lex_state = 94, .external_lex_state = 2},
  [372] = {.lex_state = 94, .external_lex_state = 2},
  [373] = {.lex_state = 94, .external_lex_state = 2},
  [374] = {.lex_state = 94, .external_lex_state = 2},
  [375] = {.lex_state = 95, .external_lex_state = 2},
  [376] = {.lex_state = 95, .external_lex_state = 2},
  [377] = {.lex_state = 94, .external_lex_state = 2},
  [378] = {.lex_state = 94, .external_lex_state = 2},
  [379] = {.lex_state = 94, .external_lex_state = 2},
  [380] = {.lex_state = 94, .external_lex_state = 2},
  [381] = {.lex_state = 94, .external_lex_state = 2},
  [382] = {.lex_state = 94, .external_lex_state = 2},
  [383] = {.lex_state = 10, .external_lex_state = 2},
  [384] = {.lex_state = 7, .external_lex_state = 2},
  [385] = {.lex_state = 94, .external_lex_state = 2},
  [386] = {.lex_state = 94, .external_lex_state = 2},
  [387] = {.lex_state = 7, .external_lex_state = 2},
  [388] = {.lex_state = 10, .external_lex_state = 2},
  [389] = {.lex_state = 94, .external_lex_state = 2},
  [390] = {.lex_state = 94, .external_lex_state = 2},
  [391] = {.lex_state = 94, .external_lex_state = 2},
  [392] = {.lex_state = 94, .external_lex_state = 2},
  [393] = {.lex_state = 94, .external_lex_state = 2},
  [394] = {.lex_state = 94, .external_lex_state = 2},
  [395] = {.lex_state = 94, .external_lex_state = 2},
  [396] = {.lex_state = 94, .external_lex_state = 2},
  [397] = {.lex_state = 94, .external_lex_state = 2},
  [398] = {.lex_state = 94, .external_lex_state = 2},
  [399] = {.lex_state = 94, .external_lex_state = 2},
  [400] = {.lex_state = 94, .external_lex_state = 2},
  [401] = {.lex_state = 94, .external_lex_state = 2},
  [402] = {.lex_state = 94, .external_lex_state = 2},
  [403] = {.lex_state = 94, .external_lex_state = 2},
  [404] = {.lex_state = 94, .external_lex_state = 2},
  [405] = {.lex_state = 94, .external_lex_state = 2},
  [406] = {.lex_state = 94, .external_lex_state = 2},
  [407] = {.lex_state = 94, .external_lex_state = 2},
  [408] = {.lex_state = 94, .external_lex_state = 2},
  [409] = {.lex_state = 94, .external_lex_state = 2},
  [410] = {.lex_state = 94, .external_lex_state = 2},
  [411] = {.lex_state = 94, .external_lex_state = 2},
  [412] = {.lex_state = 94, .external_lex_state = 2},
  [413] = {.lex_state = 94, .external_lex_state = 2},
  [414] = {.lex_state = 94, .external_lex_state = 2},
  [415] = {.lex_state = 94, .external_lex_state = 2},
  [416] = {.lex_state = 94, .external_lex_state = 2},
  [417] = {.lex_state = 94, .external_lex_state = 2},
  [418] = {.lex_state = 94, .external_lex_state = 2},
  [419] = {.lex_state = 7, .external_lex_state = 2},
  [420] = {.lex_state = 94, .external_lex_state = 2},
  [421] = {.lex_state = 94, .external_lex_state = 2},
  [422] = {.lex_state = 94, .external_lex_state = 2},
  [423] = {.lex_state = 94, .external_lex_state = 2},
  [424] = {.lex_state = 94, .external_lex_state = 2},
  [425] = {.lex_state = 94, .external_lex_state = 2},
  [426] = {.lex_state = 94, .external_lex_state = 2},
  [427] = {.lex_state = 94, .external_lex_state = 2},
  [428] = {.lex_state = 94, .external_lex_state = 2},
  [429] = {.lex_state = 94, .external_lex_state = 2},
  [430] = {.lex_state = 94, .external_lex_state = 2},
  [431] = {.lex_state = 94, .external_lex_state = 2},
  [432] = {.lex_state = 94, .external_lex_state = 2},
  [433] = {.lex_state = 94, .external_lex_state = 2},
  [434] = {.lex_state = 94, .external_lex_state = 2},
  [435] = {.lex_state = 94, .external_lex_state = 2},
  [436] = {.lex_state = 6, .external_lex_state = 2},
  [437] = {.lex_state = 94, .external_lex_state = 2},
  [438] = {.lex_state = 94, .external_lex_state = 2},
  [439] = {.lex_state = 94, .external_lex_state = 2},
  [440] = {.lex_state = 94, .external_lex_state = 2},
  [441] = {.lex_state = 94, .external_lex_state = 2},
  [442] = {.lex_state = 94, .external_lex_state = 2},
  [443] = {.lex_state = 94, .external_lex_state = 2},
  [444] = {.lex_state = 94, .external_lex_state = 2},
  [445] = {.lex_state = 94, .external_lex_state = 2},
  [446] = {.lex_state = 94, .external_lex_state = 2},
  [447] = {.lex_state = 94, .external_lex_state = 2},
  [448] = {.lex_state = 94, .external_lex_state = 2},
  [449] = {.lex_state = 94, .external_lex_state = 2},
  [450] = {.lex_state = 94, .external_lex_state = 2},
  [451] = {.lex_state = 94, .external_lex_state = 2},
  [452] = {.lex_state = 94, .external_lex_state = 2},
  [453] = {.lex_state = 94, .external_lex_state = 2},
  [454] = {.lex_state = 94, .external_lex_state = 2},
  [455] = {.lex_state = 94, .external_lex_state = 2},
  [456] = {.lex_state = 94, .external_lex_state = 2},
  [457] = {.lex_state = 94, .external_lex_state = 2},
  [458] = {.lex_state = 94, .external_lex_state = 2},
  [459] = {.lex_state = 94, .external_lex_state = 2},
  [460] = {.lex_state = 94, .external_lex_state = 2},
  [461] = {.lex_state = 94, .external_lex_state = 2},
  [462] = {.lex_state = 94, .external_lex_state = 2},
  [463] = {.lex_state = 94, .external_lex_state = 2},
  [464] = {.lex_state = 10, .external_lex_state = 2},
  [465] = {.lex_state = 94, .external_lex_state = 2},
  [466] = {.lex_state = 94, .external_lex_state = 2},
  [467] = {.lex_state = 7, .external_lex_state = 2},
  [468] = {.lex_state = 94, .external_lex_state = 2},
  [469] = {.lex_state = 94, .external_lex_state = 2},
  [470] = {.lex_state = 94, .external_lex_state = 2},
  [471] = {.lex_state = 94, .external_lex_state = 2},
  [472] = {.lex_state = 10, .external_lex_state = 2},
  [473] = {.lex_state = 3, .external_lex_state = 2},
  [474] = {.lex_state = 3, .external_lex_state = 2},
  [475] = {.lex_state = 94, .external_lex_state = 2},
  [476] = {.lex_state = 94, .external_lex_state = 2},
  [477] = {.lex_state = 94, .external_lex_state = 2},
  [478] = {.lex_state = 7, .external_lex_state = 2},
  [479] = {.lex_state = 6, .external_lex_state = 2},
  [480] = {.lex_state = 10, .external_lex_state = 2},
  [481] = {.lex_state = 94, .external_lex_state = 2},
  [482] = {.lex_state = 94, .external_lex_state = 2},
  [483] = {.lex_state = 6, .external_lex_state = 2},
  [484] = {.lex_state = 94, .external_lex_state = 2},
  [485] = {.lex_state = 94, .external_lex_state = 2},
  [486] = {.lex_state = 94, .external_lex_state = 2},
  [487] = {.lex_state = 94, .external_lex_state = 2},
  [488] = {.lex_state = 94, .external_lex_state = 2},
  [489] = {.lex_state = 94, .external_lex_state = 2},
  [490] = {.lex_state = 94, .external_lex_state = 2},
  [491] = {.lex_state = 94, .external_lex_state = 2},
  [492] = {.lex_state = 94, .external_lex_state = 2},
  [493] = {.lex_state = 6, .external_lex_state = 2},
  [494] = {.lex_state = 94, .external_lex_state = 2},
  [495] = {.lex_state = 94, .external_lex_state = 2},
  [496] = {.lex_state = 94, .external_lex_state = 2},
  [497] = {.lex_state = 94, .external_lex_state = 2},
  [498] = {.lex_state = 94, .external_lex_state = 2},
  [499] = {.lex_state = 94, .external_lex_state = 2},
  [500] = {.lex_state = 94, .external_lex_state = 2},
  [501] = {.lex_state = 94, .external_lex_state = 2},
  [502] = {.lex_state = 94, .external_lex_state = 2},
  [503] = {.lex_state = 94, .external_lex_state = 2},
  [504] = {.lex_state = 94, .external_lex_state = 2},
  [505] = {.lex_state = 94, .external_lex_state = 2},
  [506] = {.lex_state = 94, .external_lex_state = 2},
  [507] = {.lex_state = 6, .external_lex_state = 2},
  [508] = {.lex_state = 94, .external_lex_state = 2},
  [509] = {.lex_state = 94, .external_lex_state = 2},
  [510] = {.lex_state = 94, .external_lex_state = 2},
  [511] = {.lex_state = 94, .external_lex_state = 2},
  [512] = {.lex_state = 94, .external_lex_state = 2},
  [513] = {.lex_state = 94, .external_lex_state = 2},
  [514] = {.lex_state = 94, .external_lex_state = 2},
  [515] = {.lex_state = 4, .external_lex_state = 2},
  [516] = {.lex_state = 7, .external_lex_state = 2},
  [517] = {.lex_state = 94, .external_lex_state = 2},
  [518] = {.lex_state = 10, .external_lex_state = 2},
  [519] = {.lex_state = 7, .external_lex_state = 2},
  [520] = {.lex_state = 10, .external_lex_state = 2},
  [521] = {.lex_state = 3, .external_lex_state = 2},
  [522] = {.lex_state = 10, .external_lex_state = 2},
  [523] = {.lex_state = 7, .external_lex_state = 2},
  [524] = {.lex_state = 4, .external_lex_state = 2},
  [525] = {.lex_state = 94, .external_lex_state = 2},
  [526] = {.lex_state = 4, .external_lex_state = 2},
  [527] = {.lex_state = 94, .external_lex_state = 2},
  [528] = {.lex_state = 94, .external_lex_state = 2},
  [529] = {.lex_state = 94, .external_lex_state = 2},
  [530] = {.lex_state = 4, .external_lex_state = 2},
  [531] = {.lex_state = 4, .external_lex_state = 2},
  [532] = {.lex_state = 94, .external_lex_state = 2},
  [533] = {.lex_state = 4, .external_lex_state = 2},
  [534] = {.lex_state = 4, .external_lex_state = 2},
  [535] = {.lex_state = 4, .external_lex_state = 2},
  [536] = {.lex_state = 3, .external_lex_state = 2},
  [537] = {.lex_state = 94, .external_lex_state = 2},
  [538] = {.lex_state = 3, .external_lex_state = 2},
  [539] = {.lex_state = 94, .external_lex_state = 2},
  [540] = {.lex_state = 3, .external_lex_state = 2},
  [541] = {.lex_state = 4, .external_lex_state = 2},
  [542] = {.lex_state = 94, .external_lex_state = 2},
  [543] = {.lex_state = 4, .external_lex_state = 2},
  [544] = {.lex_state = 3, .external_lex_state = 2},
  [545] = {.lex_state = 94, .external_lex_state = 2},
  [546] = {.lex_state = 3, .external_lex_state = 2},
  [547] = {.lex_state = 3, .external_lex_state = 2},
  [548] = {.lex_state = 4, .external_lex_state = 2},
  [549] = {.lex_state = 4, .external_lex_state = 2},
  [550] = {.lex_state = 6, .external_lex_state = 2},
  [551] = {.lex_state = 94, .external_lex_state = 2},
  [552] = {.lex_state = 4, .external_lex_state = 2},
  [553] = {.lex_state = 3, .external_lex_state = 2},
  [554] = {.lex_state = 4, .external_lex_state = 2},
  [555] = {.lex_state = 3, .external_lex_state = 2},
  [556] = {.lex_state = 94, .external_lex_state = 2},
  [557] = {.lex_state = 3, .external_lex_state = 2},
  [558] = {.lex_state = 3, .external_lex_state = 2},
  [559] = {.lex_state = 94, .external_lex_state = 2},
  [560] = {.lex_state = 94, .external_lex_state = 2},
  [561] = {.lex_state = 94, .external_lex_state = 2},
  [562] = {.lex_state = 3, .external_lex_state = 2},
  [563] = {.lex_state = 8, .external_lex_state = 2},
  [564] = {.lex_state = 94, .external_lex_state = 2},
  [565] = {.lex_state = 6, .external_lex_state = 2},
  [566] = {.lex_state = 6, .external_lex_state = 2},
  [567] = {.lex_state = 8, .external_lex_state = 2},
  [568] = {.lex_state = 8, .external_lex_state = 2},
  [569] = {.lex_state = 8, .external_lex_state = 2},
  [570] = {.lex_state = 6, .external_lex_state = 2},
  [571] = {.lex_state = 8, .external_lex_state = 2},
  [572] = {.lex_state = 8, .external_lex_state = 2},
  [573] = {.lex_state = 8, .external_lex_state = 2},
  [574] = {.lex_state = 8, .external_lex_state = 2},
  [575] = {.lex_state = 8, .external_lex_state = 2},
  [576] = {.lex_state = 6, .external_lex_state = 2},
  [577] = {.lex_state = 94, .external_lex_state = 2},
  [578] = {.lex_state = 6, .external_lex_state = 2},
  [579] = {.lex_state = 6, .external_lex_state = 2},
  [580] = {.lex_state = 6, .external_lex_state = 2},
  [581] = {.lex_state = 6, .external_lex_state = 2},
  [582] = {.lex_state = 6, .external_lex_state = 2},
  [583] = {.lex_state = 6, .external_lex_state = 2},
  [584] = {.lex_state = 10, .external_lex_state = 2},
  [585] = {.lex_state = 7, .external_lex_state = 2},
  [586] = {.lex_state = 7, .external_lex_state = 2},
  [587] = {.lex_state = 10, .external_lex_state = 2},
  [588] = {.lex_state = 7, .external_lex_state = 2},
  [589] = {.lex_state = 7, .external_lex_state = 2},
  [590] = {.lex_state = 7, .external_lex_state = 2},
  [591] = {.lex_state = 10, .external_lex_state = 2},
  [592] = {.lex_state = 10, .external_lex_state = 2},
  [593] = {.lex_state = 7, .external_lex_state = 2},
  [594] = {.lex_state = 10, .external_lex_state = 2},
  [595] = {.lex_state = 6, .external_lex_state = 2},
  [596] = {.lex_state = 10, .external_lex_state = 2},
  [597] = {.lex_state = 10, .external_lex_state = 2},
  [598] = {.lex_state = 7, .external_lex_state = 2},
  [599] = {.lex_state = 10, .external_lex_state = 2},
  [600] = {.lex_state = 7, .external_lex_state = 2},
  [601] = {.lex_state = 7, .external_lex_state = 2},
  [602] = {.lex_state = 10, .external_lex_state = 2},
  [603] = {.lex_state = 7, .external_lex_state = 2},
  [604] = {.lex_state = 7, .external_lex_state = 2},
  [605] = {.lex_state = 6, .external_lex_state = 2},
  [606] = {.lex_state = 10, .external_lex_state = 2},
  [607] = {.lex_state = 10, .external_lex_state = 2},
  [608] = {.lex_state = 10, .external_lex_state = 2},
  [609] = {.lex_state = 7, .external_lex_state = 2},
  [610] = {.lex_state = 10, .external_lex_state = 2},
  [611] = {.lex_state = 7, .external_lex_state = 2},
  [612] = {.lex_state = 7, .external_lex_state = 2},
  [613] = {.lex_state = 7, .external_lex_state = 2},
  [614] = {.lex_state = 10, .external_lex_state = 2},
  [615] = {.lex_state = 10, .external_lex_state = 2},
  [616] = {.lex_state = 3, .external_lex_state = 2},
  [617] = {.lex_state = 3, .external_lex_state = 2},
  [618] = {.lex_state = 6, .external_lex_state = 2},
  [619] = {.lex_state = 3, .external_lex_state = 2},
  [620] = {.lex_state = 3, .external_lex_state = 2},
  [621] = {.lex_state = 3, .external_lex_state = 2},
  [622] = {.lex_state = 3, .external_lex_state = 2},
  [623] = {.lex_state = 3, .external_lex_state = 2},
  [624] = {.lex_state = 3, .external_lex_state = 2},
  [625] = {.lex_state = 3, .external_lex_state = 2},
  [626] = {.lex_state = 3, .external_lex_state = 2},
  [627] = {.lex_state = 3, .external_lex_state = 2},
  [628] = {.lex_state = 3, .external_lex_state = 2},
  [629] = {.lex_state = 3, .external_lex_state = 2},
  [630] = {.lex_state = 3, .external_lex_state = 2},
  [631] = {.lex_state = 3, .external_lex_state = 2},
  [632] = {.lex_state = 3, .external_lex_state = 2},
  [633] = {.lex_state = 3, .external_lex_state = 2},
  [634] = {.lex_state = 3, .external_lex_state = 2},
  [635] = {.lex_state = 4, .external_lex_state = 2},
  [636] = {.lex_state = 4, .external_lex_state = 2},
  [637] = {.lex_state = 4, .external_lex_state = 2},
  [638] = {.lex_state = 3, .external_lex_state = 2},
  [639] = {.lex_state = 4, .external_lex_state = 2},
  [640] = {.lex_state = 3, .external_lex_state = 2},
  [641] = {.lex_state = 3, .external_lex_state = 2},
  [642] = {.lex_state = 4, .external_lex_state = 2},
  [643] = {.lex_state = 4, .external_lex_state = 2},
  [644] = {.lex_state = 3, .external_lex_state = 2},
  [645] = {.lex_state = 4, .external_lex_state = 2},
  [646] = {.lex_state = 4, .external_lex_state = 2},
  [647] = {.lex_state = 94, .external_lex_state = 2},
  [648] = {.lex_state = 3, .external_lex_state = 2},
  [649] = {.lex_state = 3, .external_lex_state = 2},
  [650] = {.lex_state = 3, .external_lex_state = 2},
  [651] = {.lex_state = 3, .external_lex_state = 2},
  [652] = {.lex_state = 4, .external_lex_state = 2},
  [653] = {.lex_state = 3, .external_lex_state = 2},
  [654] = {.lex_state = 3, .external_lex_state = 2},
  [655] = {.lex_state = 94, .external_lex_state = 2},
  [656] = {.lex_state = 5, .external_lex_state = 2},
  [657] = {.lex_state = 4, .external_lex_state = 2},
  [658] = {.lex_state = 4, .external_lex_state = 2},
  [659] = {.lex_state = 20, .external_lex_state = 2},
  [660] = {.lex_state = 4, .external_lex_state = 2},
  [661] = {.lex_state = 20, .external_lex_state = 2},
  [662] = {.lex_state = 4, .external_lex_state = 2},
  [663] = {.lex_state = 3, .external_lex_state = 2},
  [664] = {.lex_state = 3, .external_lex_state = 2},
  [665] = {.lex_state = 4, .external_lex_state = 2},
  [666] = {.lex_state = 5, .external_lex_state = 2},
  [667] = {.lex_state = 4, .external_lex_state = 2},
  [668] = {.lex_state = 4, .external_lex_state = 2},
  [669] = {.lex_state = 3, .external_lex_state = 2},
  [670] = {.lex_state = 19, .external_lex_state = 2},
  [671] = {.lex_state = 3, .external_lex_state = 2},
  [672] = {.lex_state = 3, .external_lex_state = 2},
  [673] = {.lex_state = 3, .external_lex_state = 2},
  [674] = {.lex_state = 4, .external_lex_state = 2},
  [675] = {.lex_state = 3, .external_lex_state = 2},
  [676] = {.lex_state = 4, .external_lex_state = 2},
  [677] = {.lex_state = 4, .external_lex_state = 2},
  [678] = {.lex_state = 4, .external_lex_state = 2},
  [679] = {.lex_state = 4, .external_lex_state = 2},
  [680] = {.lex_state = 94, .external_lex_state = 2},
  [681] = {.lex_state = 9, .external_lex_state = 2},
  [682] = {.lex_state = 4, .external_lex_state = 2},
  [683] = {.lex_state = 4, .external_lex_state = 2},
  [684] = {.lex_state = 4, .external_lex_state = 2},
  [685] = {.lex_state = 4, .external_lex_state = 2},
  [686] = {.lex_state = 4, .external_lex_state = 2},
  [687] = {.lex_state = 4, .external_lex_state = 2},
  [688] = {.lex_state = 4, .external_lex_state = 2},
  [689] = {.lex_state = 4, .external_lex_state = 2},
  [690] = {.lex_state = 4, .external_lex_state = 2},
  [691] = {.lex_state = 4, .external_lex_state = 2},
  [692] = {.lex_state = 4, .external_lex_state = 2},
  [693] = {.lex_state = 4, .external_lex_state = 2},
  [694] = {.lex_state = 4, .external_lex_state = 2},
  [695] = {.lex_state = 94, .external_lex_state = 2},
  [696] = {.lex_state = 20, .external_lex_state = 2},
  [697] = {.lex_state = 19, .external_lex_state = 2},
  [698] = {.lex_state = 20, .external_lex_state = 2},
  [699] = {.lex_state = 9, .external_lex_state = 2},
  [700] = {.lex_state = 9, .external_lex_state = 2},
  [701] = {.lex_state = 19, .external_lex_state = 2},
  [702] = {.lex_state = 20, .external_lex_state = 2},
  [703] = {.lex_state = 19, .external_lex_state = 2},
  [704] = {.lex_state = 19, .external_lex_state = 2},
  [705] = {.lex_state = 19, .external_lex_state = 2},
  [706] = {.lex_state = 19, .external_lex_state = 2},
  [707] = {.lex_state = 9, .external_lex_state = 2},
  [708] = {.lex_state = 20, .external_lex_state = 2},
  [709] = {.lex_state = 20, .external_lex_state = 2},
  [710] = {.lex_state = 20, .external_lex_state = 2},
  [711] = {.lex_state = 9, .external_lex_state = 2},
  [712] = {.lex_state = 20, .external_lex_state = 2},
  [713] = {.lex_state = 20, .external_lex_state = 2},
  [714] = {.lex_state = 9, .external_lex_state = 2},
  [715] = {.lex_state = 20, .external_lex_state = 2},
  [716] = {.lex_state = 20, .external_lex_state = 2},
  [717] = {.lex_state = 20, .external_lex_state = 2},
  [718] = {.lex_state = 19, .external_lex_state = 2},
  [719] = {.lex_state = 19, .external_lex_state = 2},
  [720] = {.lex_state = 19, .external_lex_state = 2},
  [721] = {.lex_state = 9, .external_lex_state = 2},
  [722] = {.lex_state = 19, .external_lex_state = 2},
  [723] = {.lex_state = 3, .external_lex_state = 2},
  [724] = {.lex_state = 9, .external_lex_state = 2},
  [725] = {.lex_state = 9, .external_lex_state = 2},
  [726] = {.lex_state = 19, .external_lex_state = 2},
  [727] = {.lex_state = 94, .external_lex_state = 2},
  [728] = {.lex_state = 3, .external_lex_state = 2},
  [729] = {.lex_state = 3, .external_lex_state = 2},
  [730] = {.lex_state = 3, .external_lex_state = 2},
  [731] = {.lex_state = 94, .external_lex_state = 2},
  [732] = {.lex_state = 3, .external_lex_state = 2},
  [733] = {.lex_state = 3, .external_lex_state = 2},
  [734] = {.lex_state = 3, .external_lex_state = 2},
  [735] = {.lex_state = 3, .external_lex_state = 2},
  [736] = {.lex_state = 17, .external_lex_state = 2},
  [737] = {.lex_state = 94, .external_lex_state = 2},
  [738] = {.lex_state = 94, .external_lex_state = 2},
  [739] = {.lex_state = 3, .external_lex_state = 2},
  [740] = {.lex_state = 26, .external_lex_state = 2},
  [741] = {.lex_state = 3, .external_lex_state = 2},
  [742] = {.lex_state = 17, .external_lex_state = 2},
  [743] = {.lex_state = 3, .external_lex_state = 2},
  [744] = {.lex_state = 3, .external_lex_state = 2},
  [745] = {.lex_state = 3, .external_lex_state = 2},
  [746] = {.lex_state = 26, .external_lex_state = 2},
  [747] = {.lex_state = 3, .external_lex_state = 2},
  [748] = {.lex_state = 3, .external_lex_state = 2},
  [749] = {.lex_state = 19, .external_lex_state = 2},
  [750] = {.lex_state = 4, .external_lex_state = 2},
  [751] = {.lex_state = 3, .external_lex_state = 2},
  [752] = {.lex_state = 3, .external_lex_state = 2},
  [753] = {.lex_state = 3, .external_lex_state = 2},
  [754] = {.lex_state = 3, .external_lex_state = 2},
  [755] = {.lex_state = 4, .external_lex_state = 2},
  [756] = {.lex_state = 3, .external_lex_state = 2},
  [757] = {.lex_state = 94, .external_lex_state = 2},
  [758] = {.lex_state = 3, .external_lex_state = 2},
  [759] = {.lex_state = 4, .external_lex_state = 2},
  [760] = {.lex_state = 94, .external_lex_state = 2},
  [761] = {.lex_state = 3, .external_lex_state = 2},
  [762] = {.lex_state = 19, .external_lex_state = 2},
  [763] = {.lex_state = 4, .external_lex_state = 2},
  [764] = {.lex_state = 4, .external_lex_state = 2},
  [765] = {.lex_state = 4, .external_lex_state = 2},
  [766] = {.lex_state = 4, .external_lex_state = 2},
  [767] = {.lex_state = 4, .external_lex_state = 2},
  [768] = {.lex_state = 3, .external_lex_state = 2},
  [769] = {.lex_state = 3, .external_lex_state = 2},
  [770] = {.lex_state = 4, .external_lex_state = 2},
  [771] = {.lex_state = 18, .external_lex_state = 2},
  [772] = {.lex_state = 4, .external_lex_state = 2},
  [773] = {.lex_state = 4, .external_lex_state = 2},
  [774] = {.lex_state = 3, .external_lex_state = 2},
  [775] = {.lex_state = 4, .external_lex_state = 2},
  [776] = {.lex_state = 94, .external_lex_state = 2},
  [777] = {.lex_state = 3, .external_lex_state = 2},
  [778] = {.lex_state = 4, .external_lex_state = 2},
  [779] = {.lex_state = 3, .external_lex_state = 2},
  [780] = {.lex_state = 3, .external_lex_state = 2},
  [781] = {.lex_state = 3, .external_lex_state = 2},
  [782] = {.lex_state = 3, .external_lex_state = 2},
  [783] = {.lex_state = 94, .external_lex_state = 2},
  [784] = {.lex_state = 3, .external_lex_state = 2},
  [785] = {.lex_state = 4, .external_lex_state = 2},
  [786] = {.lex_state = 3, .external_lex_state = 2},
  [787] = {.lex_state = 4, .external_lex_state = 2},
  [788] = {.lex_state = 18, .external_lex_state = 2},
  [789] = {.lex_state = 94, .external_lex_state = 2},
  [790] = {.lex_state = 5, .external_lex_state = 2},
  [791] = {.lex_state = 5, .external_lex_state = 2},
  [792] = {.lex_state = 4, .external_lex_state = 2},
  [793] = {.lex_state = 3, .external_lex_state = 2},
  [794] = {.lex_state = 4, .external_lex_state = 2},
  [795] = {.lex_state = 4, .external_lex_state = 2},
  [796] = {.lex_state = 3, .external_lex_state = 2},
  [797] = {.lex_state = 3, .external_lex_state = 2},
  [798] = {.lex_state = 4, .external_lex_state = 2},
  [799] = {.lex_state = 3, .external_lex_state = 2},
  [800] = {.lex_state = 4, .external_lex_state = 2},
  [801] = {.lex_state = 4, .external_lex_state = 2},
  [802] = {.lex_state = 4, .external_lex_state = 2},
  [803] = {.lex_state = 3, .external_lex_state = 2},
  [804] = {.lex_state = 5, .external_lex_state = 2},
  [805] = {.lex_state = 5, .external_lex_state = 2},
  [806] = {.lex_state = 18, .external_lex_state = 2},
  [807] = {.lex_state = 3, .external_lex_state = 2},
  [808] = {.lex_state = 3, .external_lex_state = 2},
  [809] = {.lex_state = 3, .external_lex_state = 2},
  [810] = {.lex_state = 4, .external_lex_state = 2},
  [811] = {.lex_state = 12, .external_lex_state = 2},
  [812] = {.lex_state = 11, .external_lex_state = 2},
  [813] = {.lex_state = 18, .external_lex_state = 2},
  [814] = {.lex_state = 3, .external_lex_state = 2},
  [815] = {.lex_state = 94, .external_lex_state = 2},
  [816] = {.lex_state = 4, .external_lex_state = 2},
  [817] = {.lex_state = 4, .external_lex_state = 2},
  [818] = {.lex_state = 3, .external_lex_state = 2},
  [819] = {.lex_state = 3, .external_lex_state = 2},
  [820] = {.lex_state = 3, .external_lex_state = 2},
  [821] = {.lex_state = 5, .external_lex_state = 2},
  [822] = {.lex_state = 3, .external_lex_state = 2},
  [823] = {.lex_state = 4, .external_lex_state = 2},
  [824] = {.lex_state = 4, .external_lex_state = 2},
  [825] = {.lex_state = 4, .external_lex_state = 2},
  [826] = {.lex_state = 4, .external_lex_state = 2},
  [827] = {.lex_state = 4, .external_lex_state = 2},
  [828] = {.lex_state = 4, .external_lex_state = 2},
  [829] = {.lex_state = 4, .external_lex_state = 2},
  [830] = {.lex_state = 4, .external_lex_state = 2},
  [831] = {.lex_state = 12, .external_lex_state = 2},
  [832] = {.lex_state = 3, .external_lex_state = 2},
  [833] = {.lex_state = 4, .external_lex_state = 2},
  [834] = {.lex_state = 3, .external_lex_state = 2},
  [835] = {.lex_state = 3, .external_lex_state = 2},
  [836] = {.lex_state = 4, .external_lex_state = 2},
  [837] = {.lex_state = 4, .external_lex_state = 2},
  [838] = {.lex_state = 3, .external_lex_state = 2},
  [839] = {.lex_state = 12, .external_lex_state = 2},
  [840] = {.lex_state = 3, .external_lex_state = 2},
  [841] = {.lex_state = 4, .external_lex_state = 2},
  [842] = {.lex_state = 4, .external_lex_state = 2},
  [843] = {.lex_state = 3, .external_lex_state = 2},
  [844] = {.lex_state = 5, .external_lex_state = 2},
  [845] = {.lex_state = 12, .external_lex_state = 2},
  [846] = {.lex_state = 5, .external_lex_state = 2},
  [847] = {.lex_state = 3, .external_lex_state = 2},
  [848] = {.lex_state = 3, .external_lex_state = 2},
  [849] = {.lex_state = 3, .external_lex_state = 2},
  [850] = {.lex_state = 3, .external_lex_state = 2},
  [851] = {.lex_state = 12, .external_lex_state = 2},
  [852] = {.lex_state = 3, .external_lex_state = 2},
  [853] = {.lex_state = 3, .external_lex_state = 2},
  [854] = {.lex_state = 3, .external_lex_state = 2},
  [855] = {.lex_state = 3, .external_lex_state = 2},
  [856] = {.lex_state = 3, .external_lex_state = 2},
  [857] = {.lex_state = 4, .external_lex_state = 2},
  [858] = {.lex_state = 3, .external_lex_state = 2},
  [859] = {.lex_state = 4, .external_lex_state = 2},
  [860] = {.lex_state = 4, .external_lex_state = 2},
  [861] = {.lex_state = 11, .external_lex_state = 2},
  [862] = {.lex_state = 11, .external_lex_state = 2},
  [863] = {.lex_state = 4, .external_lex_state = 2},
  [864] = {.lex_state = 5, .external_lex_state = 2},
  [865] = {.lex_state = 4, .external_lex_state = 2},
  [866] = {.lex_state = 11, .external_lex_state = 2},
  [867] = {.lex_state = 3, .external_lex_state = 2},
  [868] = {.lex_state = 4, .external_lex_state = 2},
  [869] = {.lex_state = 4, .external_lex_state = 2},
  [870] = {.lex_state = 4, .external_lex_state = 2},
  [871] = {.lex_state = 4, .external_lex_state = 2},
  [872] = {.lex_state = 4, .external_lex_state = 2},
  [873] = {.lex_state = 4, .external_lex_state = 2},
  [874] = {.lex_state = 3, .external_lex_state = 2},
  [875] = {.lex_state = 3, .external_lex_state = 2},
  [876] = {.lex_state = 3, .external_lex_state = 2},
  [877] = {.lex_state = 3, .external_lex_state = 2},
  [878] = {.lex_state = 4, .external_lex_state = 2},
  [879] = {.lex_state = 3, .external_lex_state = 2},
  [880] = {.lex_state = 3, .external_lex_state = 2},
  [881] = {.lex_state = 4, .external_lex_state = 2},
  [882] = {.lex_state = 3, .external_lex_state = 2},
  [883] = {.lex_state = 3, .external_lex_state = 2},
  [884] = {.lex_state = 3, .external_lex_state = 2},
  [885] = {.lex_state = 3, .external_lex_state = 2},
  [886] = {.lex_state = 4, .external_lex_state = 2},
  [887] = {.lex_state = 4, .external_lex_state = 2},
  [888] = {.lex_state = 12, .external_lex_state = 2},
  [889] = {.lex_state = 3, .external_lex_state = 2},
  [890] = {.lex_state = 3, .external_lex_state = 2},
  [891] = {.lex_state = 11, .external_lex_state = 2},
  [892] = {.lex_state = 11, .external_lex_state = 2},
  [893] = {.lex_state = 11, .external_lex_state = 2},
  [894] = {.lex_state = 5, .external_lex_state = 2},
  [895] = {.lex_state = 3, .external_lex_state = 2},
  [896] = {.lex_state = 4, .external_lex_state = 2},
  [897] = {.lex_state = 4, .external_lex_state = 2},
  [898] = {.lex_state = 11, .external_lex_state = 2},
  [899] = {.lex_state = 11, .external_lex_state = 2},
  [900] = {.lex_state = 12, .external_lex_state = 2},
  [901] = {.lex_state = 3, .external_lex_state = 2},
  [902] = {.lex_state = 4, .external_lex_state = 2},
  [903] = {.lex_state = 12, .external_lex_state = 2},
  [904] = {.lex_state = 4, .external_lex_state = 2},
  [905] = {.lex_state = 4, .external_lex_state = 2},
  [906] = {.lex_state = 4, .external_lex_state = 2},
  [907] = {.lex_state = 3, .external_lex_state = 2},
  [908] = {.lex_state = 12, .external_lex_state = 2},
  [909] = {.lex_state = 4, .external_lex_state = 2},
  [910] = {.lex_state = 3, .external_lex_state = 2},
  [911] = {.lex_state = 4, .external_lex_state = 2},
  [912] = {.lex_state = 3, .external_lex_state = 2},
  [913] = {.lex_state = 3, .external_lex_state = 2},
  [914] = {.lex_state = 4, .external_lex_state = 2},
  [915] = {.lex_state = 4, .external_lex_state = 2},
  [916] = {.lex_state = 4, .external_lex_state = 2},
  [917] = {.lex_state = 4, .external_lex_state = 2},
  [918] = {.lex_state = 4, .external_lex_state = 2},
  [919] = {.lex_state = 3, .external_lex_state = 2},
  [920] = {.lex_state = 3, .external_lex_state = 2},
  [921] = {.lex_state = 3, .external_lex_state = 2},
  [922] = {.lex_state = 3, .external_lex_state = 2},
  [923] = {.lex_state = 4, .external_lex_state = 2},
  [924] = {.lex_state = 4, .external_lex_state = 2},
  [925] = {.lex_state = 3, .external_lex_state = 2},
  [926] = {.lex_state = 4, .external_lex_state = 2},
  [927] = {.lex_state = 4, .external_lex_state = 2},
  [928] = {.lex_state = 4, .external_lex_state = 2},
  [929] = {.lex_state = 3, .external_lex_state = 2},
  [930] = {.lex_state = 4, .external_lex_state = 2},
  [931] = {.lex_state = 3, .external_lex_state = 2},
  [932] = {.lex_state = 4, .external_lex_state = 2},
  [933] = {.lex_state = 4, .external_lex_state = 2},
  [934] = {.lex_state = 3, .external_lex_state = 2},
  [935] = {.lex_state = 4, .external_lex_state = 2},
  [936] = {.lex_state = 4, .external_lex_state = 2},
  [937] = {.lex_state = 4, .external_lex_state = 2},
  [938] = {.lex_state = 4, .external_lex_state = 2},
  [939] = {.lex_state = 4, .external_lex_state = 2},
  [940] = {.lex_state = 4, .external_lex_state = 2},
  [941] = {.lex_state = 4, .external_lex_state = 2},
  [942] = {.lex_state = 3, .external_lex_state = 2},
  [943] = {.lex_state = 3, .external_lex_state = 2},
  [944] = {.lex_state = 3, .external_lex_state = 2},
  [945] = {.lex_state = 3, .external_lex_state = 2},
  [946] = {.lex_state = 4, .external_lex_state = 2},
  [947] = {.lex_state = 3, .external_lex_state = 2},
  [948] = {.lex_state = 3, .external_lex_state = 2},
  [949] = {.lex_state = 3, .external_lex_state = 2},
  [950] = {.lex_state = 4, .external_lex_state = 2},
  [951] = {.lex_state = 4, .external_lex_state = 2},
  [952] = {.lex_state = 4, .external_lex_state = 2},
  [953] = {.lex_state = 4, .external_lex_state = 2},
  [954] = {.lex_state = 3, .external_lex_state = 2},
  [955] = {.lex_state = 3, .external_lex_state = 2},
  [956] = {.lex_state = 3, .external_lex_state = 2},
  [957] = {.lex_state = 3, .external_lex_state = 2},
  [958] = {.lex_state = 4, .external_lex_state = 2},
  [959] = {.lex_state = 4, .external_lex_state = 2},
  [960] = {.lex_state = 3, .external_lex_state = 2},
  [961] = {.lex_state = 4, .external_lex_state = 2},
  [962] = {.lex_state = 4, .external_lex_state = 2},
  [963] = {.lex_state = 4, .external_lex_state = 2},
  [964] = {.lex_state = 3, .external_lex_state = 2},
  [965] = {.lex_state = 3, .external_lex_state = 2},
  [966] = {.lex_state = 4, .external_lex_state = 2},
  [967] = {.lex_state = 3, .external_lex_state = 2},
  [968] = {.lex_state = 4, .external_lex_state = 2},
  [969] = {.lex_state = 4, .external_lex_state = 2},
  [970] = {.lex_state = 4, .external_lex_state = 2},
  [971] = {.lex_state = 4, .external_lex_state = 2},
  [972] = {.lex_state = 4, .external_lex_state = 2},
  [973] = {.lex_state = 4, .external_lex_state = 2},
  [974] = {.lex_state = 4, .external_lex_state = 2},
  [975] = {.lex_state = 4, .external_lex_state = 2},
  [976] = {.lex_state = 3, .external_lex_state = 2},
  [977] = {.lex_state = 3, .external_lex_state = 2},
  [978] = {.lex_state = 3, .external_lex_state = 2},
  [979] = {.lex_state = 3, .external_lex_state = 2},
  [980] = {.lex_state = 3, .external_lex_state = 2},
  [981] = {.lex_state = 4, .external_lex_state = 2},
  [982] = {.lex_state = 3, .external_lex_state = 2},
  [983] = {.lex_state = 3, .external_lex_state = 2},
  [984] = {.lex_state = 4, .external_lex_state = 2},
  [985] = {.lex_state = 3, .external_lex_state = 2},
  [986] = {.lex_state = 94, .external_lex_state = 2},
  [987] = {.lex_state = 4, .external_lex_state = 2},
  [988] = {.lex_state = 3, .external_lex_state = 2},
  [989] = {.lex_state = 4, .external_lex_state = 2},
  [990] = {.lex_state = 3, .external_lex_state = 2},
  [991] = {.lex_state = 4, .external_lex_state = 2},
  [992] = {.lex_state = 4, .external_lex_state = 2},
  [993] = {.lex_state = 3, .external_lex_state = 2},
  [994] = {.lex_state = 3, .external_lex_state = 2},
  [995] = {.lex_state = 4, .external_lex_state = 2},
  [996] = {.lex_state = 3, .external_lex_state = 2},
  [997] = {.lex_state = 3, .external_lex_state = 2},
  [998] = {.lex_state = 4, .external_lex_state = 2},
  [999] = {.lex_state = 4, .external_lex_state = 2},
  [1000] = {.lex_state = 3, .external_lex_state = 2},
  [1001] = {.lex_state = 4, .external_lex_state = 2},
  [1002] = {.lex_state = 4, .external_lex_state = 2},
  [1003] = {.lex_state = 3, .external_lex_state = 2},
  [1004] = {.lex_state = 3, .external_lex_state = 2},
  [1005] = {.lex_state = 3, .external_lex_state = 2},
  [1006] = {.lex_state = 4, .external_lex_state = 2},
  [1007] = {.lex_state = 4, .external_lex_state = 2},
  [1008] = {.lex_state = 4, .external_lex_state = 2},
  [1009] = {.lex_state = 4, .external_lex_state = 2},
  [1010] = {.lex_state = 4, .external_lex_state = 2},
  [1011] = {.lex_state = 3, .external_lex_state = 2},
  [1012] = {.lex_state = 4, .external_lex_state = 2},
  [1013] = {.lex_state = 3, .external_lex_state = 2},
  [1014] = {.lex_state = 3, .external_lex_state = 2},
  [1015] = {.lex_state = 5, .external_lex_state = 2},
  [1016] = {.lex_state = 3, .external_lex_state = 2},
  [1017] = {.lex_state = 3, .external_lex_state = 2},
  [1018] = {.lex_state = 5, .external_lex_state = 2},
  [1019] = {.lex_state = 5, .external_lex_state = 2},
  [1020] = {.lex_state = 5, .external_lex_state = 2},
  [1021] = {.lex_state = 5, .external_lex_state = 2},
  [1022] = {.lex_state = 5, .external_lex_state = 2},
  [1023] = {.lex_state = 5, .external_lex_state = 2},
  [1024] = {.lex_state = 5, .external_lex_state = 2},
  [1025] = {.lex_state = 5, .external_lex_state = 2},
  [1026] = {.lex_state = 3, .external_lex_state = 2},
  [1027] = {.lex_state = 4, .external_lex_state = 2},
  [1028] = {.lex_state = 3, .external_lex_state = 2},
  [1029] = {.lex_state = 3, .external_lex_state = 2},
  [1030] = {.lex_state = 3, .external_lex_state = 2},
  [1031] = {.lex_state = 3, .external_lex_state = 2},
  [1032] = {.lex_state = 4, .external_lex_state = 2},
  [1033] = {.lex_state = 4, .external_lex_state = 2},
  [1034] = {.lex_state = 4, .external_lex_state = 2},
  [1035] = {.lex_state = 4, .external_lex_state = 2},
  [1036] = {.lex_state = 3, .external_lex_state = 2},
  [1037] = {.lex_state = 3, .external_lex_state = 2},
  [1038] = {.lex_state = 3, .external_lex_state = 2},
  [1039] = {.lex_state = 4, .external_lex_state = 2},
  [1040] = {.lex_state = 3, .external_lex_state = 2},
  [1041] = {.lex_state = 4, .external_lex_state = 2},
  [1042] = {.lex_state = 3, .external_lex_state = 2},
  [1043] = {.lex_state = 5, .external_lex_state = 2},
  [1044] = {.lex_state = 3, .external_lex_state = 2},
  [1045] = {.lex_state = 4, .external_lex_state = 2},
  [1046] = {.lex_state = 4, .external_lex_state = 2},
  [1047] = {.lex_state = 4, .external_lex_state = 2},
  [1048] = {.lex_state = 5, .external_lex_state = 2},
  [1049] = {.lex_state = 3, .external_lex_state = 2},
  [1050] = {.lex_state = 3, .external_lex_state = 2},
  [1051] = {.lex_state = 4, .external_lex_state = 2},
  [1052] = {.lex_state = 3, .external_lex_state = 2},
  [1053] = {.lex_state = 4, .external_lex_state = 2},
  [1054] = {.lex_state = 4, .external_lex_state = 2},
  [1055] = {.lex_state = 3, .external_lex_state = 2},
  [1056] = {.lex_state = 4, .external_lex_state = 2},
  [1057] = {.lex_state = 4, .external_lex_state = 2},
  [1058] = {.lex_state = 4, .external_lex_state = 2},
  [1059] = {.lex_state = 3, .external_lex_state = 2},
  [1060] = {.lex_state = 3, .external_lex_state = 2},
  [1061] = {.lex_state = 5, .external_lex_state = 2},
  [1062] = {.lex_state = 5, .external_lex_state = 2},
  [1063] = {.lex_state = 3, .external_lex_state = 2},
  [1064] = {.lex_state = 3, .external_lex_state = 2},
  [1065] = {.lex_state = 3, .external_lex_state = 2},
  [1066] = {.lex_state = 5, .external_lex_state = 2},
  [1067] = {.lex_state = 5, .external_lex_state = 2},
  [1068] = {.lex_state = 3, .external_lex_state = 2},
  [1069] = {.lex_state = 4, .external_lex_state = 2},
  [1070] = {.lex_state = 3, .external_lex_state = 2},
  [1071] = {.lex_state = 4, .external_lex_state = 2},
  [1072] = {.lex_state = 5, .external_lex_state = 2},
  [1073] = {.lex_state = 4, .external_lex_state = 2},
  [1074] = {.lex_state = 4, .external_lex_state = 2},
  [1075] = {.lex_state = 3, .external_lex_state = 2},
  [1076] = {.lex_state = 5, .external_lex_state = 2},
  [1077] = {.lex_state = 95, .external_lex_state = 2},
  [1078] = {.lex_state = 18, .external_lex_state = 2},
  [1079] = {.lex_state = 18, .external_lex_state = 2},
  [1080] = {.lex_state = 95, .external_lex_state = 2},
  [1081] = {.lex_state = 21, .external_lex_state = 2},
  [1082] = {.lex_state = 18, .external_lex_state = 2},
  [1083] = {.lex_state = 21, .external_lex_state = 2},
  [1084] = {.lex_state = 18, .external_lex_state = 2},
  [1085] = {.lex_state = 21, .external_lex_state = 2},
  [1086] = {.lex_state = 18, .external_lex_state = 2},
  [1087] = {.lex_state = 21, .external_lex_state = 2},
  [1088] = {.lex_state = 18, .external_lex_state = 2},
  [1089] = {.lex_state = 21, .external_lex_state = 2},
  [1090] = {.lex_state = 21, .external_lex_state = 2},
  [1091] = {.lex_state = 18, .external_lex_state = 2},
  [1092] = {.lex_state = 21, .external_lex_state = 2},
  [1093] = {.lex_state = 18, .external_lex_state = 2},
  [1094] = {.lex_state = 17, .external_lex_state = 2},
  [1095] = {.lex_state = 17, .external_lex_state = 2},
  [1096] = {.lex_state = 18, .external_lex_state = 2},
  [1097] = {.lex_state = 18, .external_lex_state = 2},
  [1098] = {.lex_state = 17, .external_lex_state = 2},
  [1099] = {.lex_state = 21, .external_lex_state = 2},
  [1100] = {.lex_state = 18, .external_lex_state = 2},
  [1101] = {.lex_state = 18, .external_lex_state = 2},
  [1102] = {.lex_state = 21, .external_lex_state = 2},
  [1103] = {.lex_state = 95, .external_lex_state = 2},
  [1104] = {.lex_state = 26, .external_lex_state = 2},
  [1105] = {.lex_state = 26, .external_lex_state = 2},
  [1106] = {.lex_state = 18, .external_lex_state = 2},
  [1107] = {.lex_state = 18, .external_lex_state = 2},
  [1108] = {.lex_state = 18, .external_lex_state = 2},
  [1109] = {.lex_state = 21, .external_lex_state = 2},
  [1110] = {.lex_state = 21, .external_lex_state = 2},
  [1111] = {.lex_state = 17, .external_lex_state = 2},
  [1112] = {.lex_state = 20, .external_lex_state = 2},
  [1113] = {.lex_state = 3, .external_lex_state = 2},
  [1114] = {.lex_state = 20, .external_lex_state = 2},
  [1115] = {.lex_state = 20, .external_lex_state = 2},
  [1116] = {.lex_state = 19, .external_lex_state = 2},
  [1117] = {.lex_state = 19, .external_lex_state = 2},
  [1118] = {.lex_state = 19, .external_lex_state = 2},
  [1119] = {.lex_state = 22, .external_lex_state = 2},
  [1120] = {.lex_state = 22, .external_lex_state = 2},
  [1121] = {.lex_state = 22, .external_lex_state = 2},
  [1122] = {.lex_state = 22, .external_lex_state = 2},
  [1123] = {.lex_state = 22, .external_lex_state = 2},
  [1124] = {.lex_state = 22, .external_lex_state = 2},
  [1125] = {.lex_state = 22, .external_lex_state = 2},
  [1126] = {.lex_state = 22, .external_lex_state = 2},
  [1127] = {.lex_state = 22, .external_lex_state = 2},
  [1128] = {.lex_state = 22, .external_lex_state = 2},
  [1129] = {.lex_state = 22, .external_lex_state = 2},
  [1130] = {.lex_state = 22, .external_lex_state = 2},
  [1131] = {.lex_state = 22, .external_lex_state = 2},
  [1132] = {.lex_state = 22, .external_lex_state = 2},
  [1133] = {.lex_state = 19, .external_lex_state = 2},
  [1134] = {.lex_state = 22, .external_lex_state = 2},
  [1135] = {.lex_state = 3, .external_lex_state = 2},
  [1136] = {.lex_state = 20, .external_lex_state = 2},
  [1137] = {.lex_state = 3, .external_lex_state = 2},
  [1138] = {.lex_state = 3, .external_lex_state = 2},
  [1139] = {.lex_state = 19, .external_lex_state = 2},
  [1140] = {.lex_state = 19, .external_lex_state = 2},
  [1141] = {.lex_state = 20, .external_lex_state = 2},
  [1142] = {.lex_state = 3, .external_lex_state = 2},
  [1143] = {.lex_state = 94, .external_lex_state = 2},
  [1144] = {.lex_state = 94, .external_lex_state = 2},
  [1145] = {.lex_state = 94, .external_lex_state = 2},
  [1146] = {.lex_state = 20, .external_lex_state = 2},
  [1147] = {.lex_state = 19, .external_lex_state = 2},
  [1148] = {.lex_state = 20, .external_lex_state = 2},
  [1149] = {.lex_state = 20, .external_lex_state = 2},
  [1150] = {.lex_state = 20, .external_lex_state = 2},
  [1151] = {.lex_state = 20, .external_lex_state = 2},
  [1152] = {.lex_state = 17, .external_lex_state = 2},
  [1153] = {.lex_state = 19, .external_lex_state = 2},
  [1154] = {.lex_state = 19, .external_lex_state = 2},
  [1155] = {.lex_state = 20, .external_lex_state = 2},
  [1156] = {.lex_state = 20, .external_lex_state = 2},
  [1157] = {.lex_state = 20, .external_lex_state = 2},
  [1158] = {.lex_state = 20, .external_lex_state = 2},
  [1159] = {.lex_state = 20, .external_lex_state = 2},
  [1160] = {.lex_state = 95, .external_lex_state = 2},
  [1161] = {.lex_state = 19, .external_lex_state = 2},
  [1162] = {.lex_state = 20, .external_lex_state = 2},
  [1163] = {.lex_state = 17, .external_lex_state = 2},
  [1164] = {.lex_state = 19, .external_lex_state = 2},
  [1165] = {.lex_state = 19, .external_lex_state = 2},
  [1166] = {.lex_state = 19, .external_lex_state = 2},
  [1167] = {.lex_state = 20, .external_lex_state = 2},
  [1168] = {.lex_state = 20, .external_lex_state = 2},
  [1169] = {.lex_state = 19, .external_lex_state = 2},
  [1170] = {.lex_state = 19, .external_lex_state = 2},
  [1171] = {.lex_state = 19, .external_lex_state = 2},
  [1172] = {.lex_state = 20, .external_lex_state = 2},
  [1173] = {.lex_state = 20, .external_lex_state = 2},
  [1174] = {.lex_state = 20, .external_lex_state = 2},
  [1175] = {.lex_state = 19, .external_lex_state = 2},
  [1176] = {.lex_state = 19, .external_lex_state = 2},
  [1177] = {.lex_state = 19, .external_lex_state = 2},
  [1178] = {.lex_state = 19, .external_lex_state = 2},
  [1179] = {.lex_state = 19, .external_lex_state = 2},
  [1180] = {.lex_state = 19, .external_lex_state = 2},
  [1181] = {.lex_state = 20, .external_lex_state = 2},
  [1182] = {.lex_state = 19, .external_lex_state = 2},
  [1183] = {.lex_state = 20, .external_lex_state = 2},
  [1184] = {.lex_state = 14, .external_lex_state = 2},
  [1185] = {.lex_state = 13, .external_lex_state = 2},
  [1186] = {.lex_state = 94, .external_lex_state = 2},
  [1187] = {.lex_state = 19, .external_lex_state = 2},
  [1188] = {.lex_state = 94, .external_lex_state = 2},
  [1189] = {.lex_state = 20, .external_lex_state = 2},
  [1190] = {.lex_state = 94, .external_lex_state = 2},
  [1191] = {.lex_state = 20, .external_lex_state = 2},
  [1192] = {.lex_state = 19, .external_lex_state = 2},
  [1193] = {.lex_state = 19, .external_lex_state = 2},
  [1194] = {.lex_state = 14, .external_lex_state = 2},
  [1195] = {.lex_state = 94, .external_lex_state = 2},
  [1196] = {.lex_state = 19, .external_lex_state = 2},
  [1197] = {.lex_state = 94, .external_lex_state = 2},
  [1198] = {.lex_state = 95, .external_lex_state = 2},
  [1199] = {.lex_state = 94, .external_lex_state = 2},
  [1200] = {.lex_state = 20, .external_lex_state = 2},
  [1201] = {.lex_state = 19, .external_lex_state = 2},
  [1202] = {.lex_state = 13, .external_lex_state = 2},
  [1203] = {.lex_state = 13, .external_lex_state = 2},
  [1204] = {.lex_state = 94, .external_lex_state = 2},
  [1205] = {.lex_state = 20, .external_lex_state = 2},
  [1206] = {.lex_state = 94, .external_lex_state = 2},
  [1207] = {.lex_state = 94, .external_lex_state = 2},
  [1208] = {.lex_state = 19, .external_lex_state = 2},
  [1209] = {.lex_state = 13, .external_lex_state = 2},
  [1210] = {.lex_state = 19, .external_lex_state = 2},
  [1211] = {.lex_state = 20, .external_lex_state = 2},
  [1212] = {.lex_state = 94, .external_lex_state = 2},
  [1213] = {.lex_state = 20, .external_lex_state = 2},
  [1214] = {.lex_state = 20, .external_lex_state = 2},
  [1215] = {.lex_state = 20, .external_lex_state = 2},
  [1216] = {.lex_state = 20, .external_lex_state = 2},
  [1217] = {.lex_state = 20, .external_lex_state = 2},
  [1218] = {.lex_state = 13, .external_lex_state = 2},
  [1219] = {.lex_state = 13, .external_lex_state = 2},
  [1220] = {.lex_state = 17, .external_lex_state = 2},
  [1221] = {.lex_state = 13, .external_lex_state = 2},
  [1222] = {.lex_state = 94, .external_lex_state = 2},
  [1223] = {.lex_state = 20, .external_lex_state = 2},
  [1224] = {.lex_state = 19, .external_lex_state = 2},
  [1225] = {.lex_state = 19, .external_lex_state = 2},
  [1226] = {.lex_state = 19, .external_lex_state = 2},
  [1227] = {.lex_state = 19, .external_lex_state = 2},
  [1228] = {.lex_state = 13, .external_lex_state = 2},
  [1229] = {.lex_state = 20, .external_lex_state = 2},
  [1230] = {.lex_state = 20, .external_lex_state = 2},
  [1231] = {.lex_state = 94, .external_lex_state = 2},
  [1232] = {.lex_state = 94, .external_lex_state = 2},
  [1233] = {.lex_state = 94, .external_lex_state = 2},
  [1234] = {.lex_state = 19, .external_lex_state = 2},
  [1235] = {.lex_state = 5, .external_lex_state = 2},
  [1236] = {.lex_state = 13, .external_lex_state = 2},
  [1237] = {.lex_state = 19, .external_lex_state = 2},
  [1238] = {.lex_state = 94, .external_lex_state = 2},
  [1239] = {.lex_state = 19, .external_lex_state = 2},
  [1240] = {.lex_state = 19, .external_lex_state = 2},
  [1241] = {.lex_state = 5, .external_lex_state = 2},
  [1242] = {.lex_state = 19, .external_lex_state = 2},
  [1243] = {.lex_state = 19, .external_lex_state = 2},
  [1244] = {.lex_state = 19, .external_lex_state = 2},
  [1245] = {.lex_state = 5, .external_lex_state = 2},
  [1246] = {.lex_state = 19, .external_lex_state = 2},
  [1247] = {.lex_state = 19, .external_lex_state = 2},
  [1248] = {.lex_state = 23, .external_lex_state = 2},
  [1249] = {.lex_state = 5, .external_lex_state = 2},
  [1250] = {.lex_state = 20, .external_lex_state = 2},
  [1251] = {.lex_state = 19, .external_lex_state = 2},
  [1252] = {.lex_state = 19, .external_lex_state = 2},
  [1253] = {.lex_state = 5, .external_lex_state = 2},
  [1254] = {.lex_state = 5, .external_lex_state = 2},
  [1255] = {.lex_state = 5, .external_lex_state = 2},
  [1256] = {.lex_state = 3, .external_lex_state = 2},
  [1257] = {.lex_state = 19, .external_lex_state = 2},
  [1258] = {.lex_state = 5, .external_lex_state = 2},
  [1259] = {.lex_state = 20, .external_lex_state = 2},
  [1260] = {.lex_state = 20, .external_lex_state = 2},
  [1261] = {.lex_state = 20, .external_lex_state = 2},
  [1262] = {.lex_state = 5, .external_lex_state = 2},
  [1263] = {.lex_state = 20, .external_lex_state = 2},
  [1264] = {.lex_state = 19, .external_lex_state = 2},
  [1265] = {.lex_state = 23, .external_lex_state = 2},
  [1266] = {.lex_state = 20, .external_lex_state = 2},
  [1267] = {.lex_state = 23, .external_lex_state = 2},
  [1268] = {.lex_state = 19, .external_lex_state = 2},
  [1269] = {.lex_state = 5, .external_lex_state = 2},
  [1270] = {.lex_state = 5, .external_lex_state = 2},
  [1271] = {.lex_state = 5, .external_lex_state = 2},
  [1272] = {.lex_state = 20, .external_lex_state = 2},
  [1273] = {.lex_state = 20, .external_lex_state = 2},
  [1274] = {.lex_state = 20, .external_lex_state = 2},
  [1275] = {.lex_state = 20, .external_lex_state = 2},
  [1276] = {.lex_state = 20, .external_lex_state = 2},
  [1277] = {.lex_state = 5, .external_lex_state = 2},
  [1278] = {.lex_state = 3, .external_lex_state = 2},
  [1279] = {.lex_state = 20, .external_lex_state = 2},
  [1280] = {.lex_state = 5, .external_lex_state = 2},
  [1281] = {.lex_state = 5, .external_lex_state = 2},
  [1282] = {.lex_state = 5, .external_lex_state = 2},
  [1283] = {.lex_state = 94, .external_lex_state = 2},
  [1284] = {.lex_state = 5, .external_lex_state = 2},
  [1285] = {.lex_state = 5, .external_lex_state = 2},
  [1286] = {.lex_state = 19, .external_lex_state = 2},
  [1287] = {.lex_state = 94, .external_lex_state = 2},
  [1288] = {.lex_state = 5, .external_lex_state = 2},
  [1289] = {.lex_state = 94, .external_lex_state = 2},
  [1290] = {.lex_state = 20, .external_lex_state = 2},
  [1291] = {.lex_state = 5, .external_lex_state = 2},
  [1292] = {.lex_state = 20, .external_lex_state = 2},
  [1293] = {.lex_state = 5, .external_lex_state = 2},
  [1294] = {.lex_state = 5, .external_lex_state = 2},
  [1295] = {.lex_state = 20, .external_lex_state = 2},
  [1296] = {.lex_state = 20, .external_lex_state = 2},
  [1297] = {.lex_state = 19, .external_lex_state = 2},
  [1298] = {.lex_state = 5, .external_lex_state = 2},
  [1299] = {.lex_state = 19, .external_lex_state = 2},
  [1300] = {.lex_state = 19, .external_lex_state = 2},
  [1301] = {.lex_state = 5, .external_lex_state = 2},
  [1302] = {.lex_state = 19, .external_lex_state = 2},
  [1303] = {.lex_state = 5, .external_lex_state = 2},
  [1304] = {.lex_state = 5, .external_lex_state = 2},
  [1305] = {.lex_state = 5, .external_lex_state = 2},
  [1306] = {.lex_state = 19, .external_lex_state = 2},
  [1307] = {.lex_state = 19, .external_lex_state = 2},
  [1308] = {.lex_state = 19, .external_lex_state = 2},
  [1309] = {.lex_state = 5, .external_lex_state = 2},
  [1310] = {.lex_state = 5, .external_lex_state = 2},
  [1311] = {.lex_state = 19, .external_lex_state = 2},
  [1312] = {.lex_state = 5, .external_lex_state = 2},
  [1313] = {.lex_state = 20, .external_lex_state = 2},
  [1314] = {.lex_state = 5, .external_lex_state = 2},
  [1315] = {.lex_state = 19, .external_lex_state = 2},
  [1316] = {.lex_state = 19, .external_lex_state = 2},
  [1317] = {.lex_state = 19, .external_lex_state = 2},
  [1318] = {.lex_state = 19, .external_lex_state = 2},
  [1319] = {.lex_state = 20, .external_lex_state = 2},
  [1320] = {.lex_state = 19, .external_lex_state = 2},
  [1321] = {.lex_state = 20, .external_lex_state = 2},
  [1322] = {.lex_state = 20, .external_lex_state = 2},
  [1323] = {.lex_state = 20, .external_lex_state = 2},
  [1324] = {.lex_state = 5, .external_lex_state = 2},
  [1325] = {.lex_state = 23, .external_lex_state = 2},
  [1326] = {.lex_state = 20, .external_lex_state = 2},
  [1327] = {.lex_state = 19, .external_lex_state = 2},
  [1328] = {.lex_state = 5, .external_lex_state = 2},
  [1329] = {.lex_state = 5, .external_lex_state = 2},
  [1330] = {.lex_state = 5, .external_lex_state = 2},
  [1331] = {.lex_state = 5, .external_lex_state = 2},
  [1332] = {.lex_state = 5, .external_lex_state = 2},
  [1333] = {.lex_state = 5, .external_lex_state = 2},
  [1334] = {.lex_state = 19, .external_lex_state = 2},
  [1335] = {.lex_state = 5, .external_lex_state = 2},
  [1336] = {.lex_state = 20, .external_lex_state = 2},
  [1337] = {.lex_state = 20, .external_lex_state = 2},
  [1338] = {.lex_state = 20, .external_lex_state = 2},
  [1339] = {.lex_state = 20, .external_lex_state = 2},
  [1340] = {.lex_state = 5, .external_lex_state = 2},
  [1341] = {.lex_state = 20, .external_lex_state = 2},
  [1342] = {.lex_state = 5, .external_lex_state = 2},
  [1343] = {.lex_state = 5, .external_lex_state = 2},
  [1344] = {.lex_state = 20, .external_lex_state = 2},
  [1345] = {.lex_state = 20, .external_lex_state = 2},
  [1346] = {.lex_state = 19, .external_lex_state = 2},
  [1347] = {.lex_state = 20, .external_lex_state = 2},
  [1348] = {.lex_state = 5, .external_lex_state = 2},
  [1349] = {.lex_state = 5, .external_lex_state = 2},
  [1350] = {.lex_state = 5, .external_lex_state = 2},
  [1351] = {.lex_state = 5, .external_lex_state = 2},
  [1352] = {.lex_state = 19, .external_lex_state = 2},
  [1353] = {.lex_state = 19, .external_lex_state = 2},
  [1354] = {.lex_state = 5, .external_lex_state = 2},
  [1355] = {.lex_state = 5, .external_lex_state = 2},
  [1356] = {.lex_state = 5, .external_lex_state = 2},
  [1357] = {.lex_state = 5, .external_lex_state = 2},
  [1358] = {.lex_state = 19, .external_lex_state = 2},
  [1359] = {.lex_state = 94, .external_lex_state = 2},
  [1360] = {.lex_state = 19, .external_lex_state = 2},
  [1361] = {.lex_state = 20, .external_lex_state = 2},
  [1362] = {.lex_state = 20, .external_lex_state = 2},
  [1363] = {.lex_state = 20, .external_lex_state = 2},
  [1364] = {.lex_state = 19, .external_lex_state = 2},
  [1365] = {.lex_state = 20, .external_lex_state = 2},
  [1366] = {.lex_state = 19, .external_lex_state = 2},
  [1367] = {.lex_state = 19, .external_lex_state = 2},
  [1368] = {.lex_state = 17, .external_lex_state = 2},
  [1369] = {.lex_state = 20, .external_lex_state = 2},
  [1370] = {.lex_state = 19, .external_lex_state = 2},
  [1371] = {.lex_state = 17, .external_lex_state = 2},
  [1372] = {.lex_state = 19, .external_lex_state = 2},
  [1373] = {.lex_state = 20, .external_lex_state = 2},
  [1374] = {.lex_state = 19, .external_lex_state = 2},
  [1375] = {.lex_state = 3, .external_lex_state = 2},
  [1376] = {.lex_state = 20, .external_lex_state = 2},
  [1377] = {.lex_state = 19, .external_lex_state = 2},
  [1378] = {.lex_state = 3, .external_lex_state = 2},
  [1379] = {.lex_state = 20, .external_lex_state = 2},
  [1380] = {.lex_state = 20, .external_lex_state = 2},
  [1381] = {.lex_state = 20, .external_lex_state = 2},
  [1382] = {.lex_state = 94, .external_lex_state = 2},
  [1383] = {.lex_state = 3, .external_lex_state = 2},
  [1384] = {.lex_state = 21, .external_lex_state = 2},
  [1385] = {.lex_state = 21, .external_lex_state = 2},
  [1386] = {.lex_state = 3, .external_lex_state = 2},
  [1387] = {.lex_state = 3, .external_lex_state = 2},
  [1388] = {.lex_state = 3, .external_lex_state = 2},
  [1389] = {.lex_state = 3, .external_lex_state = 2},
  [1390] = {.lex_state = 3, .external_lex_state = 2},
  [1391] = {.lex_state = 3, .external_lex_state = 2},
  [1392] = {.lex_state = 3, .external_lex_state = 2},
  [1393] = {.lex_state = 3, .external_lex_state = 2},
  [1394] = {.lex_state = 3, .external_lex_state = 2},
  [1395] = {.lex_state = 3, .external_lex_state = 2},
  [1396] = {.lex_state = 21, .external_lex_state = 2},
  [1397] = {.lex_state = 3, .external_lex_state = 2},
  [1398] = {.lex_state = 94, .external_lex_state = 2},
  [1399] = {.lex_state = 94, .external_lex_state = 2},
  [1400] = {.lex_state = 94, .external_lex_state = 2},
  [1401] = {.lex_state = 94, .external_lex_state = 2},
  [1402] = {.lex_state = 94, .external_lex_state = 2},
  [1403] = {.lex_state = 94, .external_lex_state = 2},
  [1404] = {.lex_state = 94, .external_lex_state = 2},
  [1405] = {.lex_state = 94, .external_lex_state = 2},
  [1406] = {.lex_state = 94, .external_lex_state = 2},
  [1407] = {.lex_state = 94, .external_lex_state = 2},
  [1408] = {.lex_state = 94, .external_lex_state = 2},
  [1409] = {.lex_state = 94, .external_lex_state = 2},
  [1410] = {.lex_state = 94, .external_lex_state = 2},
  [1411] = {.lex_state = 94, .external_lex_state = 2},
  [1412] = {.lex_state = 94, .external_lex_state = 2},
  [1413] = {.lex_state = 94, .external_lex_state = 2},
  [1414] = {.lex_state = 94, .external_lex_state = 2},
  [1415] = {.lex_state = 94, .external_lex_state = 2},
  [1416] = {.lex_state = 94, .external_lex_state = 2},
  [1417] = {.lex_state = 26, .external_lex_state = 2},
  [1418] = {.lex_state = 21, .external_lex_state = 2},
  [1419] = {.lex_state = 21, .external_lex_state = 2},
  [1420] = {.lex_state = 37, .external_lex_state = 2},
  [1421] = {.lex_state = 94, .external_lex_state = 2},
  [1422] = {.lex_state = 21, .external_lex_state = 2},
  [1423] = {.lex_state = 21, .external_lex_state = 2},
  [1424] = {.lex_state = 37, .external_lex_state = 2},
  [1425] = {.lex_state = 21, .external_lex_state = 2},
  [1426] = {.lex_state = 21, .external_lex_state = 2},
  [1427] = {.lex_state = 21, .external_lex_state = 2},
  [1428] = {.lex_state = 21, .external_lex_state = 2},
  [1429] = {.lex_state = 21, .external_lex_state = 2},
  [1430] = {.lex_state = 21, .external_lex_state = 2},
  [1431] = {.lex_state = 21, .external_lex_state = 2},
  [1432] = {.lex_state = 21, .external_lex_state = 2},
  [1433] = {.lex_state = 21, .external_lex_state = 2},
  [1434] = {.lex_state = 21, .external_lex_state = 2},
  [1435] = {.lex_state = 21, .external_lex_state = 2},
  [1436] = {.lex_state = 21, .external_lex_state = 2},
  [1437] = {.lex_state = 37, .external_lex_state = 2},
  [1438] = {.lex_state = 21, .external_lex_state = 2},
  [1439] = {.lex_state = 21, .external_lex_state = 2},
  [1440] = {.lex_state = 21, .external_lex_state = 2},
  [1441] = {.lex_state = 94, .external_lex_state = 2},
  [1442] = {.lex_state = 37, .external_lex_state = 2},
  [1443] = {.lex_state = 94, .external_lex_state = 2},
  [1444] = {.lex_state = 21, .external_lex_state = 2},
  [1445] = {.lex_state = 37, .external_lex_state = 2},
  [1446] = {.lex_state = 21, .external_lex_state = 2},
  [1447] = {.lex_state = 21, .external_lex_state = 2},
  [1448] = {.lex_state = 37, .external_lex_state = 2},
  [1449] = {.lex_state = 21, .external_lex_state = 2},
  [1450] = {.lex_state = 14, .external_lex_state = 2},
  [1451] = {.lex_state = 21, .external_lex_state = 2},
  [1452] = {.lex_state = 14, .external_lex_state = 2},
  [1453] = {.lex_state = 21, .external_lex_state = 2},
  [1454] = {.lex_state = 37, .external_lex_state = 2},
  [1455] = {.lex_state = 21, .external_lex_state = 2},
  [1456] = {.lex_state = 21, .external_lex_state = 2},
  [1457] = {.lex_state = 21, .external_lex_state = 2},
  [1458] = {.lex_state = 14, .external_lex_state = 2},
  [1459] = {.lex_state = 21, .external_lex_state = 2},
  [1460] = {.lex_state = 14, .external_lex_state = 2},
  [1461] = {.lex_state = 94, .external_lex_state = 2},
  [1462] = {.lex_state = 21, .external_lex_state = 2},
  [1463] = {.lex_state = 14, .external_lex_state = 2},
  [1464] = {.lex_state = 14, .external_lex_state = 2},
  [1465] = {.lex_state = 14, .external_lex_state = 2},
  [1466] = {.lex_state = 94, .external_lex_state = 2},
  [1467] = {.lex_state = 21, .external_lex_state = 2},
  [1468] = {.lex_state = 14, .external_lex_state = 2},
  [1469] = {.lex_state = 14, .external_lex_state = 2},
  [1470] = {.lex_state = 14, .external_lex_state = 2},
  [1471] = {.lex_state = 37, .external_lex_state = 2},
  [1472] = {.lex_state = 14, .external_lex_state = 2},
  [1473] = {.lex_state = 21, .external_lex_state = 2},
  [1474] = {.lex_state = 21, .external_lex_state = 2},
  [1475] = {.lex_state = 37, .external_lex_state = 2},
  [1476] = {.lex_state = 94, .external_lex_state = 2},
  [1477] = {.lex_state = 94, .external_lex_state = 2},
  [1478] = {.lex_state = 14, .external_lex_state = 2},
  [1479] = {.lex_state = 14, .external_lex_state = 2},
  [1480] = {.lex_state = 14, .external_lex_state = 2},
  [1481] = {.lex_state = 94, .external_lex_state = 2},
  [1482] = {.lex_state = 37, .external_lex_state = 2},
  [1483] = {.lex_state = 37, .external_lex_state = 2},
  [1484] = {.lex_state = 37, .external_lex_state = 2},
  [1485] = {.lex_state = 37, .external_lex_state = 2},
  [1486] = {.lex_state = 14, .external_lex_state = 2},
  [1487] = {.lex_state = 14, .external_lex_state = 2},
  [1488] = {.lex_state = 14, .external_lex_state = 2},
  [1489] = {.lex_state = 37, .external_lex_state = 2},
  [1490] = {.lex_state = 94, .external_lex_state = 2},
  [1491] = {.lex_state = 21, .external_lex_state = 2},
  [1492] = {.lex_state = 37, .external_lex_state = 2},
  [1493] = {.lex_state = 21, .external_lex_state = 2},
  [1494] = {.lex_state = 21, .external_lex_state = 2},
  [1495] = {.lex_state = 94, .external_lex_state = 2},
  [1496] = {.lex_state = 21, .external_lex_state = 2},
  [1497] = {.lex_state = 21, .external_lex_state = 2},
  [1498] = {.lex_state = 37, .external_lex_state = 2},
  [1499] = {.lex_state = 21, .external_lex_state = 2},
  [1500] = {.lex_state = 21, .external_lex_state = 2},
  [1501] = {.lex_state = 21, .external_lex_state = 2},
  [1502] = {.lex_state = 21, .external_lex_state = 2},
  [1503] = {.lex_state = 37, .external_lex_state = 2},
  [1504] = {.lex_state = 37, .external_lex_state = 2},
  [1505] = {.lex_state = 21, .external_lex_state = 2},
  [1506] = {.lex_state = 21, .external_lex_state = 2},
  [1507] = {.lex_state = 0, .external_lex_state = 2},
  [1508] = {.lex_state = 0, .external_lex_state = 2},
  [1509] = {.lex_state = 37, .external_lex_state = 2},
  [1510] = {.lex_state = 21, .external_lex_state = 2},
  [1511] = {.lex_state = 21, .external_lex_state = 2},
  [1512] = {.lex_state = 21, .external_lex_state = 2},
  [1513] = {.lex_state = 21, .external_lex_state = 2},
  [1514] = {.lex_state = 37, .external_lex_state = 2},
  [1515] = {.lex_state = 21, .external_lex_state = 2},
  [1516] = {.lex_state = 94, .external_lex_state = 2},
  [1517] = {.lex_state = 21, .external_lex_state = 2},
  [1518] = {.lex_state = 37, .external_lex_state = 2},
  [1519] = {.lex_state = 21, .external_lex_state = 2},
  [1520] = {.lex_state = 21, .external_lex_state = 2},
  [1521] = {.lex_state = 37, .external_lex_state = 2},
  [1522] = {.lex_state = 21, .external_lex_state = 2},
  [1523] = {.lex_state = 21, .external_lex_state = 2},
  [1524] = {.lex_state = 21, .external_lex_state = 2},
  [1525] = {.lex_state = 21, .external_lex_state = 2},
  [1526] = {.lex_state = 37, .external_lex_state = 2},
  [1527] = {.lex_state = 21, .external_lex_state = 2},
  [1528] = {.lex_state = 21, .external_lex_state = 2},
  [1529] = {.lex_state = 21, .external_lex_state = 2},
  [1530] = {.lex_state = 21, .external_lex_state = 2},
  [1531] = {.lex_state = 94, .external_lex_state = 2},
  [1532] = {.lex_state = 21, .external_lex_state = 2},
  [1533] = {.lex_state = 0, .external_lex_state = 2},
  [1534] = {.lex_state = 21, .external_lex_state = 2},
  [1535] = {.lex_state = 94, .external_lex_state = 2},
  [1536] = {.lex_state = 37, .external_lex_state = 2},
  [1537] = {.lex_state = 21, .external_lex_state = 2},
  [1538] = {.lex_state = 94, .external_lex_state = 2},
  [1539] = {.lex_state = 37, .external_lex_state = 2},
  [1540] = {.lex_state = 37, .external_lex_state = 2},
  [1541] = {.lex_state = 94, .external_lex_state = 2},
  [1542] = {.lex_state = 37, .external_lex_state = 2},
  [1543] = {.lex_state = 21, .external_lex_state = 2},
  [1544] = {.lex_state = 94, .external_lex_state = 2},
  [1545] = {.lex_state = 37, .external_lex_state = 2},
  [1546] = {.lex_state = 21, .external_lex_state = 2},
  [1547] = {.lex_state = 94, .external_lex_state = 2},
  [1548] = {.lex_state = 22, .external_lex_state = 2},
  [1549] = {.lex_state = 0, .external_lex_state = 2},
  [1550] = {.lex_state = 21, .external_lex_state = 2},
  [1551] = {.lex_state = 21, .external_lex_state = 2},
  [1552] = {.lex_state = 94, .external_lex_state = 2},
  [1553] = {.lex_state = 0, .external_lex_state = 2},
  [1554] = {.lex_state = 21, .external_lex_state = 2},
  [1555] = {.lex_state = 94, .external_lex_state = 2},
  [1556] = {.lex_state = 21, .external_lex_state = 2},
  [1557] = {.lex_state = 21, .external_lex_state = 2},
  [1558] = {.lex_state = 21, .external_lex_state = 2},
  [1559] = {.lex_state = 21, .external_lex_state = 2},
  [1560] = {.lex_state = 37, .external_lex_state = 2},
  [1561] = {.lex_state = 37, .external_lex_state = 2},
  [1562] = {.lex_state = 94, .external_lex_state = 2},
  [1563] = {.lex_state = 23, .external_lex_state = 2},
  [1564] = {.lex_state = 37, .external_lex_state = 2},
  [1565] = {.lex_state = 21, .external_lex_state = 2},
  [1566] = {.lex_state = 37, .external_lex_state = 2},
  [1567] = {.lex_state = 0, .external_lex_state = 2},
  [1568] = {.lex_state = 37, .external_lex_state = 2},
  [1569] = {.lex_state = 37, .external_lex_state = 2},
  [1570] = {.lex_state = 0, .external_lex_state = 2},
  [1571] = {.lex_state = 0, .external_lex_state = 2},
  [1572] = {.lex_state = 95, .external_lex_state = 2},
  [1573] = {.lex_state = 94, .external_lex_state = 2},
  [1574] = {.lex_state = 95, .external_lex_state = 2},
  [1575] = {.lex_state = 94, .external_lex_state = 2},
  [1576] = {.lex_state = 94, .external_lex_state = 2},
  [1577] = {.lex_state = 6, .external_lex_state = 2},
  [1578] = {.lex_state = 6, .external_lex_state = 2},
  [1579] = {.lex_state = 37, .external_lex_state = 2},
  [1580] = {.lex_state = 6, .external_lex_state = 2},
  [1581] = {.lex_state = 6, .external_lex_state = 2},
  [1582] = {.lex_state = 6, .external_lex_state = 2},
  [1583] = {.lex_state = 6, .external_lex_state = 2},
  [1584] = {.lex_state = 94, .external_lex_state = 2},
  [1585] = {.lex_state = 6, .external_lex_state = 2},
  [1586] = {.lex_state = 6, .external_lex_state = 2},
  [1587] = {.lex_state = 6, .external_lex_state = 2},
  [1588] = {.lex_state = 6, .external_lex_state = 2},
  [1589] = {.lex_state = 6, .external_lex_state = 2},
  [1590] = {.lex_state = 6, .external_lex_state = 2},
  [1591] = {.lex_state = 95, .external_lex_state = 2},
  [1592] = {.lex_state = 95, .external_lex_state = 2},
  [1593] = {.lex_state = 95, .external_lex_state = 2},
  [1594] = {.lex_state = 6, .external_lex_state = 2},
  [1595] = {.lex_state = 95, .external_lex_state = 2},
  [1596] = {.lex_state = 95, .external_lex_state = 2},
  [1597] = {.lex_state = 6, .external_lex_state = 2},
  [1598] = {.lex_state = 94, .external_lex_state = 2},
  [1599] = {.lex_state = 95, .external_lex_state = 2},
  [1600] = {.lex_state = 15, .external_lex_state = 2},
  [1601] = {.lex_state = 95, .external_lex_state = 2},
  [1602] = {.lex_state = 15, .external_lex_state = 2},
  [1603] = {.lex_state = 15, .external_lex_state = 2},
  [1604] = {.lex_state = 95, .external_lex_state = 2},
  [1605] = {.lex_state = 15, .external_lex_state = 2},
  [1606] = {.lex_state = 95, .external_lex_state = 2},
  [1607] = {.lex_state = 15, .external_lex_state = 2},
  [1608] = {.lex_state = 95, .external_lex_state = 2},
  [1609] = {.lex_state = 15, .external_lex_state = 2},
  [1610] = {.lex_state = 95, .external_lex_state = 2},
  [1611] = {.lex_state = 94, .external_lex_state = 2},
  [1612] = {.lex_state = 94, .external_lex_state = 2},
  [1613] = {.lex_state = 15, .external_lex_state = 2},
  [1614] = {.lex_state = 15, .external_lex_state = 2},
  [1615] = {.lex_state = 94, .external_lex_state = 2},
  [1616] = {.lex_state = 94, .external_lex_state = 2},
  [1617] = {.lex_state = 94, .external_lex_state = 2},
  [1618] = {.lex_state = 94, .external_lex_state = 2},
  [1619] = {.lex_state = 6, .external_lex_state = 2},
  [1620] = {.lex_state = 94, .external_lex_state = 2},
  [1621] = {.lex_state = 94, .external_lex_state = 2},
  [1622] = {.lex_state = 94, .external_lex_state = 2},
  [1623] = {.lex_state = 94, .external_lex_state = 2},
  [1624] = {.lex_state = 94, .external_lex_state = 2},
  [1625] = {.lex_state = 94, .external_lex_state = 2},
  [1626] = {.lex_state = 22, .external_lex_state = 2},
  [1627] = {.lex_state = 94, .external_lex_state = 2},
  [1628] = {.lex_state = 22, .external_lex_state = 2},
  [1629] = {.lex_state = 22, .external_lex_state = 2},
  [1630] = {.lex_state = 94, .external_lex_state = 2},
  [1631] = {.lex_state = 22, .external_lex_state = 2},
  [1632] = {.lex_state = 22, .external_lex_state = 2},
  [1633] = {.lex_state = 37, .external_lex_state = 2},
  [1634] = {.lex_state = 94, .external_lex_state = 2},
  [1635] = {.lex_state = 94, .external_lex_state = 2},
  [1636] = {.lex_state = 22, .external_lex_state = 2},
  [1637] = {.lex_state = 22, .external_lex_state = 2},
  [1638] = {.lex_state = 94, .external_lex_state = 2},
  [1639] = {.lex_state = 94, .external_lex_state = 2},
  [1640] = {.lex_state = 94, .external_lex_state = 2},
  [1641] = {.lex_state = 94, .external_lex_state = 2},
  [1642] = {.lex_state = 94, .external_lex_state = 2},
  [1643] = {.lex_state = 94, .external_lex_state = 2},
  [1644] = {.lex_state = 94, .external_lex_state = 2},
  [1645] = {.lex_state = 94, .external_lex_state = 2},
  [1646] = {.lex_state = 94, .external_lex_state = 2},
  [1647] = {.lex_state = 94, .external_lex_state = 2},
  [1648] = {.lex_state = 94, .external_lex_state = 2},
  [1649] = {.lex_state = 94, .external_lex_state = 2},
  [1650] = {.lex_state = 94, .external_lex_state = 2},
  [1651] = {.lex_state = 94, .external_lex_state = 2},
  [1652] = {.lex_state = 37, .external_lex_state = 2},
  [1653] = {.lex_state = 94, .external_lex_state = 2},
  [1654] = {.lex_state = 37, .external_lex_state = 2},
  [1655] = {.lex_state = 94, .external_lex_state = 2},
  [1656] = {.lex_state = 95, .external_lex_state = 2},
  [1657] = {.lex_state = 94, .external_lex_state = 2},
  [1658] = {.lex_state = 94, .external_lex_state = 2},
  [1659] = {.lex_state = 94, .external_lex_state = 2},
  [1660] = {.lex_state = 94, .external_lex_state = 2},
  [1661] = {.lex_state = 94, .external_lex_state = 2},
  [1662] = {.lex_state = 94, .external_lex_state = 2},
  [1663] = {.lex_state = 94, .external_lex_state = 2},
  [1664] = {.lex_state = 94, .external_lex_state = 2},
  [1665] = {.lex_state = 94, .external_lex_state = 2},
  [1666] = {.lex_state = 94, .external_lex_state = 2},
  [1667] = {.lex_state = 94, .external_lex_state = 2},
  [1668] = {.lex_state = 94, .external_lex_state = 2},
  [1669] = {.lex_state = 94, .external_lex_state = 2},
  [1670] = {.lex_state = 94, .external_lex_state = 2},
  [1671] = {.lex_state = 94, .external_lex_state = 2},
  [1672] = {.lex_state = 94, .external_lex_state = 2},
  [1673] = {.lex_state = 94, .external_lex_state = 2},
  [1674] = {.lex_state = 94, .external_lex_state = 2},
  [1675] = {.lex_state = 94, .external_lex_state = 2},
  [1676] = {.lex_state = 94, .external_lex_state = 2},
  [1677] = {.lex_state = 94, .external_lex_state = 2},
  [1678] = {.lex_state = 94, .external_lex_state = 2},
  [1679] = {.lex_state = 94, .external_lex_state = 2},
  [1680] = {.lex_state = 94, .external_lex_state = 2},
  [1681] = {.lex_state = 94, .external_lex_state = 2},
  [1682] = {.lex_state = 94, .external_lex_state = 2},
  [1683] = {.lex_state = 94, .external_lex_state = 2},
  [1684] = {.lex_state = 94, .external_lex_state = 2},
  [1685] = {.lex_state = 94, .external_lex_state = 2},
  [1686] = {.lex_state = 94, .external_lex_state = 2},
  [1687] = {.lex_state = 94, .external_lex_state = 2},
  [1688] = {.lex_state = 94, .external_lex_state = 2},
  [1689] = {.lex_state = 17, .external_lex_state = 2},
  [1690] = {.lex_state = 94, .external_lex_state = 2},
  [1691] = {.lex_state = 94, .external_lex_state = 2},
  [1692] = {.lex_state = 94, .external_lex_state = 2},
  [1693] = {.lex_state = 94, .external_lex_state = 2},
  [1694] = {.lex_state = 94, .external_lex_state = 2},
  [1695] = {.lex_state = 15, .external_lex_state = 2},
  [1696] = {.lex_state = 15, .external_lex_state = 2},
  [1697] = {.lex_state = 94, .external_lex_state = 2},
  [1698] = {.lex_state = 37, .external_lex_state = 2},
  [1699] = {.lex_state = 94, .external_lex_state = 2},
  [1700] = {.lex_state = 94, .external_lex_state = 2},
  [1701] = {.lex_state = 94, .external_lex_state = 2},
  [1702] = {.lex_state = 37, .external_lex_state = 2},
  [1703] = {.lex_state = 94, .external_lex_state = 2},
  [1704] = {.lex_state = 94, .external_lex_state = 2},
  [1705] = {.lex_state = 94, .external_lex_state = 2},
  [1706] = {.lex_state = 94, .external_lex_state = 2},
  [1707] = {.lex_state = 26, .external_lex_state = 2},
  [1708] = {.lex_state = 94, .external_lex_state = 2},
  [1709] = {.lex_state = 94, .external_lex_state = 2},
  [1710] = {.lex_state = 94, .external_lex_state = 2},
  [1711] = {.lex_state = 26, .external_lex_state = 2},
  [1712] = {.lex_state = 17, .external_lex_state = 2},
  [1713] = {.lex_state = 94, .external_lex_state = 2},
  [1714] = {.lex_state = 26, .external_lex_state = 2},
  [1715] = {.lex_state = 94, .external_lex_state = 2},
  [1716] = {.lex_state = 94, .external_lex_state = 2},
  [1717] = {.lex_state = 94, .external_lex_state = 2},
  [1718] = {.lex_state = 94, .external_lex_state = 2},
  [1719] = {.lex_state = 94, .external_lex_state = 2},
  [1720] = {.lex_state = 94, .external_lex_state = 2},
  [1721] = {.lex_state = 94, .external_lex_state = 2},
  [1722] = {.lex_state = 94, .external_lex_state = 2},
  [1723] = {.lex_state = 23, .external_lex_state = 3},
  [1724] = {.lex_state = 15, .external_lex_state = 4},
  [1725] = {.lex_state = 15, .external_lex_state = 4},
  [1726] = {.lex_state = 94, .external_lex_state = 2},
  [1727] = {.lex_state = 94, .external_lex_state = 2},
  [1728] = {.lex_state = 15, .external_lex_state = 4},
  [1729] = {.lex_state = 23, .external_lex_state = 3},
  [1730] = {.lex_state = 94, .external_lex_state = 2},
  [1731] = {.lex_state = 15, .external_lex_state = 4},
  [1732] = {.lex_state = 37, .external_lex_state = 2},
  [1733] = {.lex_state = 15, .external_lex_state = 4},
  [1734] = {.lex_state = 15, .external_lex_state = 4},
  [1735] = {.lex_state = 23, .external_lex_state = 3},
  [1736] = {.lex_state = 23, .external_lex_state = 3},
  [1737] = {.lex_state = 37, .external_lex_state = 2},
  [1738] = {.lex_state = 23, .external_lex_state = 3},
  [1739] = {.lex_state = 15, .external_lex_state = 4},
  [1740] = {.lex_state = 37, .external_lex_state = 2},
  [1741] = {.lex_state = 23, .external_lex_state = 3},
  [1742] = {.lex_state = 94, .external_lex_state = 2},
  [1743] = {.lex_state = 15, .external_lex_state = 4},
  [1744] = {.lex_state = 23, .external_lex_state = 3},
  [1745] = {.lex_state = 23, .external_lex_state = 3},
  [1746] = {.lex_state = 37, .external_lex_state = 2},
  [1747] = {.lex_state = 23, .external_lex_state = 3},
  [1748] = {.lex_state = 94, .external_lex_state = 2},
  [1749] = {.lex_state = 15, .external_lex_state = 4},
  [1750] = {.lex_state = 37, .external_lex_state = 2},
  [1751] = {.lex_state = 37, .external_lex_state = 2},
  [1752] = {.lex_state = 95, .external_lex_state = 2},
  [1753] = {.lex_state = 37, .external_lex_state = 2},
  [1754] = {.lex_state = 31, .external_lex_state = 5},
  [1755] = {.lex_state = 15, .external_lex_state = 6},
  [1756] = {.lex_state = 37, .external_lex_state = 2},
  [1757] = {.lex_state = 31, .external_lex_state = 7},
  [1758] = {.lex_state = 31, .external_lex_state = 7},
  [1759] = {.lex_state = 94, .external_lex_state = 2},
  [1760] = {.lex_state = 94, .external_lex_state = 2},
  [1761] = {.lex_state = 37, .external_lex_state = 2},
  [1762] = {.lex_state = 31, .external_lex_state = 7},
  [1763] = {.lex_state = 31, .external_lex_state = 5},
  [1764] = {.lex_state = 26, .external_lex_state = 2},
  [1765] = {.lex_state = 31, .external_lex_state = 5},
  [1766] = {.lex_state = 23, .external_lex_state = 8},
  [1767] = {.lex_state = 31, .external_lex_state = 5},
  [1768] = {.lex_state = 31, .external_lex_state = 5},
  [1769] = {.lex_state = 23, .external_lex_state = 8},
  [1770] = {.lex_state = 26, .external_lex_state = 2},
  [1771] = {.lex_state = 31, .external_lex_state = 7},
  [1772] = {.lex_state = 94, .external_lex_state = 2},
  [1773] = {.lex_state = 23, .external_lex_state = 8},
  [1774] = {.lex_state = 31, .external_lex_state = 5},
  [1775] = {.lex_state = 37, .external_lex_state = 2},
  [1776] = {.lex_state = 94, .external_lex_state = 2},
  [1777] = {.lex_state = 94, .external_lex_state = 2},
  [1778] = {.lex_state = 37, .external_lex_state = 2},
  [1779] = {.lex_state = 37, .external_lex_state = 2},
  [1780] = {.lex_state = 31, .external_lex_state = 5},
  [1781] = {.lex_state = 15, .external_lex_state = 6},
  [1782] = {.lex_state = 23, .external_lex_state = 8},
  [1783] = {.lex_state = 37, .external_lex_state = 2},
  [1784] = {.lex_state = 15, .external_lex_state = 6},
  [1785] = {.lex_state = 93, .external_lex_state = 2},
  [1786] = {.lex_state = 31, .external_lex_state = 7},
  [1787] = {.lex_state = 23, .external_lex_state = 8},
  [1788] = {.lex_state = 15, .external_lex_state = 6},
  [1789] = {.lex_state = 31, .external_lex_state = 7},
  [1790] = {.lex_state = 37, .external_lex_state = 2},
  [1791] = {.lex_state = 26, .external_lex_state = 2},
  [1792] = {.lex_state = 31, .external_lex_state = 5},
  [1793] = {.lex_state = 23, .external_lex_state = 8},
  [1794] = {.lex_state = 15, .external_lex_state = 6},
  [1795] = {.lex_state = 94, .external_lex_state = 2},
  [1796] = {.lex_state = 23, .external_lex_state = 8},
  [1797] = {.lex_state = 15, .external_lex_state = 6},
  [1798] = {.lex_state = 23, .external_lex_state = 8},
  [1799] = {.lex_state = 15, .external_lex_state = 6},
  [1800] = {.lex_state = 15, .external_lex_state = 6},
  [1801] = {.lex_state = 23, .external_lex_state = 8},
  [1802] = {.lex_state = 31, .external_lex_state = 7},
  [1803] = {.lex_state = 31, .external_lex_state = 5},
  [1804] = {.lex_state = 15, .external_lex_state = 6},
  [1805] = {.lex_state = 31, .external_lex_state = 7},
  [1806] = {.lex_state = 31, .external_lex_state = 7},
  [1807] = {.lex_state = 94, .external_lex_state = 2},
  [1808] = {.lex_state = 18, .external_lex_state = 2},
  [1809] = {.lex_state = 94, .external_lex_state = 2},
  [1810] = {.lex_state = 18, .external_lex_state = 2},
  [1811] = {.lex_state = 94, .external_lex_state = 2},
  [1812] = {.lex_state = 31, .external_lex_state = 9},
  [1813] = {.lex_state = 31, .external_lex_state = 10},
  [1814] = {.lex_state = 26, .external_lex_state = 2},
  [1815] = {.lex_state = 18, .external_lex_state = 2},
  [1816] = {.lex_state = 18, .external_lex_state = 2},
  [1817] = {.lex_state = 18, .external_lex_state = 2},
  [1818] = {.lex_state = 18, .external_lex_state = 2},
  [1819] = {.lex_state = 94, .external_lex_state = 2},
  [1820] = {.lex_state = 94, .external_lex_state = 2},
  [1821] = {.lex_state = 94, .external_lex_state = 2},
  [1822] = {.lex_state = 94, .external_lex_state = 2},
  [1823] = {.lex_state = 31, .external_lex_state = 9},
  [1824] = {.lex_state = 31, .external_lex_state = 10},
  [1825] = {.lex_state = 31, .external_lex_state = 10},
  [1826] = {.lex_state = 31, .external_lex_state = 10},
  [1827] = {.lex_state = 26, .external_lex_state = 2},
  [1828] = {.lex_state = 31, .external_lex_state = 9},
  [1829] = {.lex_state = 37, .external_lex_state = 2},
  [1830] = {.lex_state = 31, .external_lex_state = 10},
  [1831] = {.lex_state = 31, .external_lex_state = 9},
  [1832] = {.lex_state = 18, .external_lex_state = 2},
  [1833] = {.lex_state = 18, .external_lex_state = 2},
  [1834] = {.lex_state = 31, .external_lex_state = 9},
  [1835] = {.lex_state = 94, .external_lex_state = 2},
  [1836] = {.lex_state = 94, .external_lex_state = 2},
  [1837] = {.lex_state = 94, .external_lex_state = 2},
  [1838] = {.lex_state = 25, .external_lex_state = 8},
  [1839] = {.lex_state = 30, .external_lex_state = 6},
  [1840] = {.lex_state = 94, .external_lex_state = 2},
  [1841] = {.lex_state = 31, .external_lex_state = 9},
  [1842] = {.lex_state = 31, .external_lex_state = 10},
  [1843] = {.lex_state = 94, .external_lex_state = 2},
  [1844] = {.lex_state = 94, .external_lex_state = 2},
  [1845] = {.lex_state = 94, .external_lex_state = 2},
  [1846] = {.lex_state = 31, .external_lex_state = 9},
  [1847] = {.lex_state = 31, .external_lex_state = 10},
  [1848] = {.lex_state = 94, .external_lex_state = 2},
  [1849] = {.lex_state = 31, .external_lex_state = 10},
  [1850] = {.lex_state = 31, .external_lex_state = 9},
  [1851] = {.lex_state = 94, .external_lex_state = 2},
  [1852] = {.lex_state = 94, .external_lex_state = 2},
  [1853] = {.lex_state = 94, .external_lex_state = 2},
  [1854] = {.lex_state = 94, .external_lex_state = 2},
  [1855] = {.lex_state = 31, .external_lex_state = 10},
  [1856] = {.lex_state = 94, .external_lex_state = 2},
  [1857] = {.lex_state = 31, .external_lex_state = 9},
  [1858] = {.lex_state = 26, .external_lex_state = 2},
  [1859] = {.lex_state = 18, .external_lex_state = 2},
  [1860] = {.lex_state = 0, .external_lex_state = 2},
  [1861] = {.lex_state = 93, .external_lex_state = 2},
  [1862] = {.lex_state = 94, .external_lex_state = 2},
  [1863] = {.lex_state = 94, .external_lex_state = 2},
  [1864] = {.lex_state = 18, .external_lex_state = 2},
  [1865] = {.lex_state = 0, .external_lex_state = 2},
  [1866] = {.lex_state = 94, .external_lex_state = 2},
  [1867] = {.lex_state = 18, .external_lex_state = 2},
  [1868] = {.lex_state = 95, .external_lex_state = 2},
  [1869] = {.lex_state = 95, .external_lex_state = 2},
  [1870] = {.lex_state = 37, .external_lex_state = 2},
  [1871] = {.lex_state = 95, .external_lex_state = 2},
  [1872] = {.lex_state = 95, .external_lex_state = 2},
  [1873] = {.lex_state = 95, .external_lex_state = 2},
  [1874] = {.lex_state = 18, .external_lex_state = 2},
  [1875] = {.lex_state = 95, .external_lex_state = 2},
  [1876] = {.lex_state = 95, .external_lex_state = 2},
  [1877] = {.lex_state = 95, .external_lex_state = 2},
  [1878] = {.lex_state = 95, .external_lex_state = 2},
  [1879] = {.lex_state = 26, .external_lex_state = 2},
  [1880] = {.lex_state = 95, .external_lex_state = 2},
  [1881] = {.lex_state = 93, .external_lex_state = 2},
  [1882] = {.lex_state = 95, .external_lex_state = 2},
  [1883] = {.lex_state = 26, .external_lex_state = 2},
  [1884] = {.lex_state = 95, .external_lex_state = 2},
  [1885] = {.lex_state = 26, .external_lex_state = 2},
  [1886] = {.lex_state = 26, .external_lex_state = 2},
  [1887] = {.lex_state = 94, .external_lex_state = 2},
  [1888] = {.lex_state = 94, .external_lex_state = 2},
  [1889] = {.lex_state = 26, .external_lex_state = 2},
  [1890] = {.lex_state = 94, .external_lex_state = 2},
  [1891] = {.lex_state = 95, .external_lex_state = 2},
  [1892] = {.lex_state = 94, .external_lex_state = 2},
  [1893] = {.lex_state = 95, .external_lex_state = 2},
  [1894] = {.lex_state = 95, .external_lex_state = 2},
  [1895] = {.lex_state = 95, .external_lex_state = 2},
  [1896] = {.lex_state = 95, .external_lex_state = 2},
  [1897] = {.lex_state = 95, .external_lex_state = 2},
  [1898] = {.lex_state = 95, .external_lex_state = 2},
  [1899] = {.lex_state = 95, .external_lex_state = 2},
  [1900] = {.lex_state = 95, .external_lex_state = 2},
  [1901] = {.lex_state = 95, .external_lex_state = 2},
  [1902] = {.lex_state = 95, .external_lex_state = 2},
  [1903] = {.lex_state = 26, .external_lex_state = 2},
  [1904] = {.lex_state = 95, .external_lex_state = 2},
  [1905] = {.lex_state = 95, .external_lex_state = 2},
  [1906] = {.lex_state = 95, .external_lex_state = 2},
  [1907] = {.lex_state = 95, .external_lex_state = 2},
  [1908] = {.lex_state = 26, .external_lex_state = 2},
  [1909] = {.lex_state = 95, .external_lex_state = 2},
  [1910] = {.lex_state = 95, .external_lex_state = 2},
  [1911] = {.lex_state = 26, .external_lex_state = 2},
  [1912] = {.lex_state = 95, .external_lex_state = 2},
  [1913] = {.lex_state = 94, .external_lex_state = 2},
  [1914] = {.lex_state = 15, .external_lex_state = 6},
  [1915] = {.lex_state = 26, .external_lex_state = 2},
  [1916] = {.lex_state = 95, .external_lex_state = 2},
  [1917] = {.lex_state = 94, .external_lex_state = 2},
  [1918] = {.lex_state = 95, .external_lex_state = 2},
  [1919] = {.lex_state = 95, .external_lex_state = 2},
  [1920] = {.lex_state = 95, .external_lex_state = 2},
  [1921] = {.lex_state = 95, .external_lex_state = 2},
  [1922] = {.lex_state = 15, .external_lex_state = 6},
  [1923] = {.lex_state = 23, .external_lex_state = 8},
  [1924] = {.lex_state = 18, .external_lex_state = 2},
  [1925] = {.lex_state = 23, .external_lex_state = 8},
  [1926] = {.lex_state = 95, .external_lex_state = 2},
  [1927] = {.lex_state = 94, .external_lex_state = 2},
  [1928] = {.lex_state = 26, .external_lex_state = 2},
  [1929] = {.lex_state = 94, .external_lex_state = 2},
  [1930] = {.lex_state = 95, .external_lex_state = 2},
  [1931] = {.lex_state = 26, .external_lex_state = 2},
  [1932] = {.lex_state = 94, .external_lex_state = 2},
  [1933] = {.lex_state = 95, .external_lex_state = 2},
  [1934] = {.lex_state = 26, .external_lex_state = 2},
  [1935] = {.lex_state = 26, .external_lex_state = 2},
  [1936] = {.lex_state = 37, .external_lex_state = 2},
  [1937] = {.lex_state = 95, .external_lex_state = 2},
  [1938] = {.lex_state = 95, .external_lex_state = 2},
  [1939] = {.lex_state = 94, .external_lex_state = 2},
  [1940] = {.lex_state = 94, .external_lex_state = 2},
  [1941] = {.lex_state = 94, .external_lex_state = 2},
  [1942] = {.lex_state = 33, .external_lex_state = 9},
  [1943] = {.lex_state = 95, .external_lex_state = 2},
  [1944] = {.lex_state = 94, .external_lex_state = 2},
  [1945] = {.lex_state = 26, .external_lex_state = 2},
  [1946] = {.lex_state = 26, .external_lex_state = 2},
  [1947] = {.lex_state = 33, .external_lex_state = 10},
  [1948] = {.lex_state = 26, .external_lex_state = 2},
  [1949] = {.lex_state = 26, .external_lex_state = 2},
  [1950] = {.lex_state = 93, .external_lex_state = 2},
  [1951] = {.lex_state = 18, .external_lex_state = 2},
  [1952] = {.lex_state = 94, .external_lex_state = 2},
  [1953] = {.lex_state = 26, .external_lex_state = 2},
  [1954] = {.lex_state = 26, .external_lex_state = 2},
  [1955] = {.lex_state = 94, .external_lex_state = 2},
  [1956] = {.lex_state = 94, .external_lex_state = 2},
  [1957] = {.lex_state = 94, .external_lex_state = 2},
  [1958] = {.lex_state = 94, .external_lex_state = 2},
  [1959] = {.lex_state = 26, .external_lex_state = 2},
  [1960] = {.lex_state = 94, .external_lex_state = 2},
  [1961] = {.lex_state = 26, .external_lex_state = 2},
  [1962] = {.lex_state = 94, .external_lex_state = 2},
  [1963] = {.lex_state = 15, .external_lex_state = 4},
  [1964] = {.lex_state = 94, .external_lex_state = 2},
  [1965] = {.lex_state = 94, .external_lex_state = 2},
  [1966] = {.lex_state = 94, .external_lex_state = 2},
  [1967] = {.lex_state = 15, .external_lex_state = 4},
  [1968] = {.lex_state = 94, .external_lex_state = 2},
  [1969] = {.lex_state = 94, .external_lex_state = 2},
  [1970] = {.lex_state = 94, .external_lex_state = 2},
  [1971] = {.lex_state = 94, .external_lex_state = 2},
  [1972] = {.lex_state = 15, .external_lex_state = 4},
  [1973] = {.lex_state = 94, .external_lex_state = 2},
  [1974] = {.lex_state = 94, .external_lex_state = 2},
  [1975] = {.lex_state = 94, .external_lex_state = 2},
  [1976] = {.lex_state = 26, .external_lex_state = 2},
  [1977] = {.lex_state = 94, .external_lex_state = 2},
  [1978] = {.lex_state = 94, .external_lex_state = 2},
  [1979] = {.lex_state = 95, .external_lex_state = 2},
  [1980] = {.lex_state = 94, .external_lex_state = 2},
  [1981] = {.lex_state = 94, .external_lex_state = 2},
  [1982] = {.lex_state = 94, .external_lex_state = 2},
  [1983] = {.lex_state = 94, .external_lex_state = 2},
  [1984] = {.lex_state = 94, .external_lex_state = 2},
  [1985] = {.lex_state = 94, .external_lex_state = 2},
  [1986] = {.lex_state = 94, .external_lex_state = 2},
  [1987] = {.lex_state = 0, .external_lex_state = 2},
  [1988] = {.lex_state = 26, .external_lex_state = 2},
  [1989] = {.lex_state = 94, .external_lex_state = 2},
  [1990] = {.lex_state = 15, .external_lex_state = 4},
  [1991] = {.lex_state = 15, .external_lex_state = 4},
  [1992] = {.lex_state = 94, .external_lex_state = 2},
  [1993] = {.lex_state = 26, .external_lex_state = 2},
  [1994] = {.lex_state = 94, .external_lex_state = 2},
  [1995] = {.lex_state = 94, .external_lex_state = 2},
  [1996] = {.lex_state = 31, .external_lex_state = 10},
  [1997] = {.lex_state = 94, .external_lex_state = 2},
  [1998] = {.lex_state = 26, .external_lex_state = 2},
  [1999] = {.lex_state = 26, .external_lex_state = 2},
  [2000] = {.lex_state = 26, .external_lex_state = 2},
  [2001] = {.lex_state = 26, .external_lex_state = 2},
  [2002] = {.lex_state = 23, .external_lex_state = 3},
  [2003] = {.lex_state = 94, .external_lex_state = 2},
  [2004] = {.lex_state = 23, .external_lex_state = 3},
  [2005] = {.lex_state = 26, .external_lex_state = 2},
  [2006] = {.lex_state = 93, .external_lex_state = 2},
  [2007] = {.lex_state = 94, .external_lex_state = 2},
  [2008] = {.lex_state = 94, .external_lex_state = 2},
  [2009] = {.lex_state = 94, .external_lex_state = 2},
  [2010] = {.lex_state = 23, .external_lex_state = 3},
  [2011] = {.lex_state = 94, .external_lex_state = 2},
  [2012] = {.lex_state = 94, .external_lex_state = 2},
  [2013] = {.lex_state = 94, .external_lex_state = 2},
  [2014] = {.lex_state = 94, .external_lex_state = 2},
  [2015] = {.lex_state = 94, .external_lex_state = 2},
  [2016] = {.lex_state = 31, .external_lex_state = 9},
  [2017] = {.lex_state = 94, .external_lex_state = 2},
  [2018] = {.lex_state = 31, .external_lex_state = 10},
  [2019] = {.lex_state = 23, .external_lex_state = 3},
  [2020] = {.lex_state = 94, .external_lex_state = 2},
  [2021] = {.lex_state = 94, .external_lex_state = 2},
  [2022] = {.lex_state = 94, .external_lex_state = 2},
  [2023] = {.lex_state = 94, .external_lex_state = 2},
  [2024] = {.lex_state = 23, .external_lex_state = 3},
  [2025] = {.lex_state = 93, .external_lex_state = 2},
  [2026] = {.lex_state = 93, .external_lex_state = 2},
  [2027] = {.lex_state = 94, .external_lex_state = 2},
  [2028] = {.lex_state = 94, .external_lex_state = 2},
  [2029] = {.lex_state = 26, .external_lex_state = 2},
  [2030] = {.lex_state = 31, .external_lex_state = 9},
  [2031] = {.lex_state = 94, .external_lex_state = 2},
  [2032] = {.lex_state = 94, .external_lex_state = 2},
  [2033] = {.lex_state = 26, .external_lex_state = 2},
  [2034] = {.lex_state = 26, .external_lex_state = 2},
  [2035] = {.lex_state = 93, .external_lex_state = 2},
  [2036] = {.lex_state = 31, .external_lex_state = 5},
  [2037] = {.lex_state = 22, .external_lex_state = 2},
  [2038] = {.lex_state = 22, .external_lex_state = 2},
  [2039] = {.lex_state = 94, .external_lex_state = 2},
  [2040] = {.lex_state = 93, .external_lex_state = 2},
  [2041] = {.lex_state = 94, .external_lex_state = 2},
  [2042] = {.lex_state = 95, .external_lex_state = 2},
  [2043] = {.lex_state = 31, .external_lex_state = 7},
  [2044] = {.lex_state = 22, .external_lex_state = 2},
  [2045] = {.lex_state = 94, .external_lex_state = 2},
  [2046] = {.lex_state = 26, .external_lex_state = 2},
  [2047] = {.lex_state = 94, .external_lex_state = 2},
  [2048] = {.lex_state = 94, .external_lex_state = 2},
  [2049] = {.lex_state = 31, .external_lex_state = 7},
  [2050] = {.lex_state = 95, .external_lex_state = 2},
  [2051] = {.lex_state = 22, .external_lex_state = 2},
  [2052] = {.lex_state = 94, .external_lex_state = 2},
  [2053] = {.lex_state = 94, .external_lex_state = 2},
  [2054] = {.lex_state = 94, .external_lex_state = 2},
  [2055] = {.lex_state = 93, .external_lex_state = 2},
  [2056] = {.lex_state = 22, .external_lex_state = 2},
  [2057] = {.lex_state = 31, .external_lex_state = 7},
  [2058] = {.lex_state = 94, .external_lex_state = 2},
  [2059] = {.lex_state = 94, .external_lex_state = 2},
  [2060] = {.lex_state = 94, .external_lex_state = 2},
  [2061] = {.lex_state = 31, .external_lex_state = 5},
  [2062] = {.lex_state = 94, .external_lex_state = 2},
  [2063] = {.lex_state = 31, .external_lex_state = 7},
  [2064] = {.lex_state = 94, .external_lex_state = 2},
  [2065] = {.lex_state = 94, .external_lex_state = 2},
  [2066] = {.lex_state = 94, .external_lex_state = 2},
  [2067] = {.lex_state = 93, .external_lex_state = 2},
  [2068] = {.lex_state = 31, .external_lex_state = 7},
  [2069] = {.lex_state = 22, .external_lex_state = 2},
  [2070] = {.lex_state = 31, .external_lex_state = 5},
  [2071] = {.lex_state = 94, .external_lex_state = 2},
  [2072] = {.lex_state = 0, .external_lex_state = 2},
  [2073] = {.lex_state = 94, .external_lex_state = 2},
  [2074] = {.lex_state = 0, .external_lex_state = 2},
  [2075] = {.lex_state = 94, .external_lex_state = 2},
  [2076] = {.lex_state = 95, .external_lex_state = 2},
  [2077] = {.lex_state = 94, .external_lex_state = 2},
  [2078] = {.lex_state = 93, .external_lex_state = 2},
  [2079] = {.lex_state = 94, .external_lex_state = 2},
  [2080] = {.lex_state = 94, .external_lex_state = 2},
  [2081] = {.lex_state = 94, .external_lex_state = 2},
  [2082] = {.lex_state = 94, .external_lex_state = 2},
  [2083] = {.lex_state = 94, .external_lex_state = 2},
  [2084] = {.lex_state = 22, .external_lex_state = 2},
  [2085] = {.lex_state = 94, .external_lex_state = 2},
  [2086] = {.lex_state = 94, .external_lex_state = 2},
  [2087] = {.lex_state = 93, .external_lex_state = 2},
  [2088] = {.lex_state = 94, .external_lex_state = 2},
  [2089] = {.lex_state = 94, .external_lex_state = 2},
  [2090] = {.lex_state = 22, .external_lex_state = 2},
  [2091] = {.lex_state = 94, .external_lex_state = 2},
  [2092] = {.lex_state = 94, .external_lex_state = 2},
  [2093] = {.lex_state = 95, .external_lex_state = 2},
  [2094] = {.lex_state = 94, .external_lex_state = 2},
  [2095] = {.lex_state = 94, .external_lex_state = 2},
  [2096] = {.lex_state = 94, .external_lex_state = 2},
  [2097] = {.lex_state = 93, .external_lex_state = 2},
  [2098] = {.lex_state = 94, .external_lex_state = 2},
  [2099] = {.lex_state = 31, .external_lex_state = 5},
  [2100] = {.lex_state = 93, .external_lex_state = 2},
  [2101] = {.lex_state = 31, .external_lex_state = 5},
  [2102] = {.lex_state = 94, .external_lex_state = 2},
  [2103] = {.lex_state = 94, .external_lex_state = 2},
  [2104] = {.lex_state = 94, .external_lex_state = 2},
  [2105] = {.lex_state = 93, .external_lex_state = 2},
  [2106] = {.lex_state = 94, .external_lex_state = 2},
  [2107] = {.lex_state = 0, .external_lex_state = 2},
  [2108] = {.lex_state = 94, .external_lex_state = 2},
  [2109] = {.lex_state = 94, .external_lex_state = 2},
  [2110] = {.lex_state = 94, .external_lex_state = 2},
  [2111] = {.lex_state = 94, .external_lex_state = 2},
  [2112] = {.lex_state = 94, .external_lex_state = 2},
  [2113] = {.lex_state = 94, .external_lex_state = 2},
  [2114] = {.lex_state = 94, .external_lex_state = 2},
  [2115] = {.lex_state = 0, .external_lex_state = 2},
  [2116] = {.lex_state = 94, .external_lex_state = 2},
  [2117] = {.lex_state = 94, .external_lex_state = 2},
  [2118] = {.lex_state = 0, .external_lex_state = 2},
  [2119] = {.lex_state = 94, .external_lex_state = 2},
  [2120] = {.lex_state = 94, .external_lex_state = 2},
  [2121] = {.lex_state = 93, .external_lex_state = 2},
  [2122] = {.lex_state = 94, .external_lex_state = 2},
  [2123] = {.lex_state = 94, .external_lex_state = 2},
  [2124] = {.lex_state = 94, .external_lex_state = 2},
  [2125] = {.lex_state = 0, .external_lex_state = 2},
  [2126] = {.lex_state = 0, .external_lex_state = 2},
  [2127] = {.lex_state = 94, .external_lex_state = 2},
  [2128] = {.lex_state = 93, .external_lex_state = 2},
  [2129] = {.lex_state = 0, .external_lex_state = 2},
  [2130] = {.lex_state = 94, .external_lex_state = 2},
  [2131] = {.lex_state = 94, .external_lex_state = 2},
  [2132] = {.lex_state = 94, .external_lex_state = 2},
  [2133] = {.lex_state = 94, .external_lex_state = 2},
  [2134] = {.lex_state = 94, .external_lex_state = 2},
  [2135] = {.lex_state = 94, .external_lex_state = 2},
  [2136] = {.lex_state = 94, .external_lex_state = 2},
  [2137] = {.lex_state = 93, .external_lex_state = 2},
  [2138] = {.lex_state = 94, .external_lex_state = 2},
  [2139] = {.lex_state = 0, .external_lex_state = 2},
  [2140] = {.lex_state = 94, .external_lex_state = 2},
  [2141] = {.lex_state = 93, .external_lex_state = 2},
  [2142] = {.lex_state = 94, .external_lex_state = 2},
  [2143] = {.lex_state = 93, .external_lex_state = 2},
  [2144] = {.lex_state = 93, .external_lex_state = 2},
  [2145] = {.lex_state = 94, .external_lex_state = 2},
  [2146] = {.lex_state = 94, .external_lex_state = 2},
  [2147] = {.lex_state = 94, .external_lex_state = 2},
  [2148] = {.lex_state = 94, .external_lex_state = 2},
  [2149] = {.lex_state = 94, .external_lex_state = 2},
  [2150] = {.lex_state = 94, .external_lex_state = 2},
  [2151] = {.lex_state = 94, .external_lex_state = 2},
  [2152] = {.lex_state = 94, .external_lex_state = 2},
  [2153] = {.lex_state = 93, .external_lex_state = 2},
  [2154] = {.lex_state = 94, .external_lex_state = 2},
  [2155] = {.lex_state = 0, .external_lex_state = 2},
  [2156] = {.lex_state = 93, .external_lex_state = 2},
  [2157] = {.lex_state = 0, .external_lex_state = 2},
  [2158] = {.lex_state = 0, .external_lex_state = 2},
  [2159] = {.lex_state = 0, .external_lex_state = 2},
  [2160] = {.lex_state = 0, .external_lex_state = 2},
  [2161] = {.lex_state = 50, .external_lex_state = 2},
  [2162] = {.lex_state = 0, .external_lex_state = 2},
  [2163] = {.lex_state = 50, .external_lex_state = 2},
  [2164] = {.lex_state = 0, .external_lex_state = 2},
  [2165] = {.lex_state = 94, .external_lex_state = 2},
  [2166] = {.lex_state = 0, .external_lex_state = 2},
  [2167] = {.lex_state = 0, .external_lex_state = 2},
  [2168] = {.lex_state = 0, .external_lex_state = 2},
  [2169] = {.lex_state = 0, .external_lex_state = 2},
  [2170] = {.lex_state = 94, .external_lex_state = 2},
  [2171] = {.lex_state = 0, .external_lex_state = 2},
  [2172] = {.lex_state = 0, .external_lex_state = 2},
  [2173] = {.lex_state = 0, .external_lex_state = 2},
  [2174] = {.lex_state = 0, .external_lex_state = 2},
  [2175] = {.lex_state = 0, .external_lex_state = 2},
  [2176] = {.lex_state = 0, .external_lex_state = 2},
  [2177] = {.lex_state = 93, .external_lex_state = 2},
  [2178] = {.lex_state = 94, .external_lex_state = 2},
  [2179] = {.lex_state = 94, .external_lex_state = 2},
  [2180] = {.lex_state = 0, .external_lex_state = 2},
  [2181] = {.lex_state = 94, .external_lex_state = 2},
  [2182] = {.lex_state = 0, .external_lex_state = 2},
  [2183] = {.lex_state = 0, .external_lex_state = 2},
  [2184] = {.lex_state = 0, .external_lex_state = 2},
  [2185] = {.lex_state = 94, .external_lex_state = 2},
  [2186] = {.lex_state = 0, .external_lex_state = 2},
  [2187] = {.lex_state = 94, .external_lex_state = 2},
  [2188] = {.lex_state = 0, .external_lex_state = 2},
  [2189] = {.lex_state = 0, .external_lex_state = 2},
  [2190] = {.lex_state = 94, .external_lex_state = 2},
  [2191] = {.lex_state = 0, .external_lex_state = 2},
  [2192] = {.lex_state = 0, .external_lex_state = 2},
  [2193] = {.lex_state = 0, .external_lex_state = 2},
  [2194] = {.lex_state = 0, .external_lex_state = 2},
  [2195] = {.lex_state = 94, .external_lex_state = 2},
  [2196] = {.lex_state = 0, .external_lex_state = 2},
  [2197] = {.lex_state = 94, .external_lex_state = 2},
  [2198] = {.lex_state = 0, .external_lex_state = 2},
  [2199] = {.lex_state = 94, .external_lex_state = 2},
  [2200] = {.lex_state = 94, .external_lex_state = 2},
  [2201] = {.lex_state = 94, .external_lex_state = 2},
  [2202] = {.lex_state = 94, .external_lex_state = 2},
  [2203] = {.lex_state = 0, .external_lex_state = 2},
  [2204] = {.lex_state = 0, .external_lex_state = 2},
  [2205] = {.lex_state = 0, .external_lex_state = 2},
  [2206] = {.lex_state = 0, .external_lex_state = 2},
  [2207] = {.lex_state = 94, .external_lex_state = 2},
  [2208] = {.lex_state = 94, .external_lex_state = 2},
  [2209] = {.lex_state = 0, .external_lex_state = 2},
  [2210] = {.lex_state = 0, .external_lex_state = 2},
  [2211] = {.lex_state = 0, .external_lex_state = 2},
  [2212] = {.lex_state = 0, .external_lex_state = 2},
  [2213] = {.lex_state = 94, .external_lex_state = 2},
  [2214] = {.lex_state = 94, .external_lex_state = 2},
  [2215] = {.lex_state = 0, .external_lex_state = 2},
  [2216] = {.lex_state = 94, .external_lex_state = 2},
  [2217] = {.lex_state = 0, .external_lex_state = 2},
  [2218] = {.lex_state = 0, .external_lex_state = 2},
  [2219] = {.lex_state = 0, .external_lex_state = 2},
  [2220] = {.lex_state = 0, .external_lex_state = 2},
  [2221] = {.lex_state = 0, .external_lex_state = 2},
  [2222] = {.lex_state = 94, .external_lex_state = 2},
  [2223] = {.lex_state = 94, .external_lex_state = 2},
  [2224] = {.lex_state = 0, .external_lex_state = 2},
  [2225] = {.lex_state = 94, .external_lex_state = 2},
  [2226] = {.lex_state = 0, .external_lex_state = 2},
  [2227] = {.lex_state = 0, .external_lex_state = 2},
  [2228] = {.lex_state = 0, .external_lex_state = 2},
  [2229] = {.lex_state = 0, .external_lex_state = 2},
  [2230] = {.lex_state = 94, .external_lex_state = 2},
  [2231] = {.lex_state = 94, .external_lex_state = 2},
  [2232] = {.lex_state = 0, .external_lex_state = 2},
  [2233] = {.lex_state = 0, .external_lex_state = 2},
  [2234] = {.lex_state = 0, .external_lex_state = 2},
  [2235] = {.lex_state = 94, .external_lex_state = 2},
  [2236] = {.lex_state = 94, .external_lex_state = 2},
  [2237] = {.lex_state = 0, .external_lex_state = 2},
  [2238] = {.lex_state = 0, .external_lex_state = 2},
  [2239] = {.lex_state = 94, .external_lex_state = 2},
  [2240] = {.lex_state = 0, .external_lex_state = 2},
  [2241] = {.lex_state = 94, .external_lex_state = 2},
  [2242] = {.lex_state = 0, .external_lex_state = 2},
  [2243] = {.lex_state = 0, .external_lex_state = 2},
  [2244] = {.lex_state = 0, .external_lex_state = 2},
  [2245] = {.lex_state = 0, .external_lex_state = 2},
  [2246] = {.lex_state = 94, .external_lex_state = 2},
  [2247] = {.lex_state = 94, .external_lex_state = 2},
  [2248] = {.lex_state = 94, .external_lex_state = 2},
  [2249] = {.lex_state = 94, .external_lex_state = 2},
  [2250] = {.lex_state = 94, .external_lex_state = 2},
  [2251] = {.lex_state = 0, .external_lex_state = 2},
  [2252] = {.lex_state = 0, .external_lex_state = 2},
  [2253] = {.lex_state = 0, .external_lex_state = 2},
  [2254] = {.lex_state = 94, .external_lex_state = 2},
  [2255] = {.lex_state = 0, .external_lex_state = 2},
  [2256] = {.lex_state = 0, .external_lex_state = 2},
  [2257] = {.lex_state = 0, .external_lex_state = 2},
  [2258] = {.lex_state = 0, .external_lex_state = 2},
  [2259] = {.lex_state = 0, .external_lex_state = 2},
  [2260] = {.lex_state = 0, .external_lex_state = 2},
  [2261] = {.lex_state = 0, .external_lex_state = 2},
  [2262] = {.lex_state = 0, .external_lex_state = 2},
  [2263] = {.lex_state = 0, .external_lex_state = 2},
  [2264] = {.lex_state = 0, .external_lex_state = 2},
  [2265] = {.lex_state = 94, .external_lex_state = 2},
  [2266] = {.lex_state = 94, .external_lex_state = 2},
  [2267] = {.lex_state = 94, .external_lex_state = 2},
  [2268] = {.lex_state = 0, .external_lex_state = 2},
  [2269] = {.lex_state = 94, .external_lex_state = 2},
  [2270] = {.lex_state = 0, .external_lex_state = 2},
  [2271] = {.lex_state = 0, .external_lex_state = 2},
  [2272] = {.lex_state = 0, .external_lex_state = 2},
  [2273] = {.lex_state = 0, .external_lex_state = 2},
  [2274] = {.lex_state = 94, .external_lex_state = 2},
  [2275] = {.lex_state = 94, .external_lex_state = 2},
  [2276] = {.lex_state = 0, .external_lex_state = 2},
  [2277] = {.lex_state = 0, .external_lex_state = 2},
  [2278] = {.lex_state = 94, .external_lex_state = 2},
  [2279] = {.lex_state = 94, .external_lex_state = 2},
  [2280] = {.lex_state = 0, .external_lex_state = 2},
  [2281] = {.lex_state = 0, .external_lex_state = 2},
  [2282] = {.lex_state = 0, .external_lex_state = 2},
  [2283] = {.lex_state = 0, .external_lex_state = 2},
  [2284] = {.lex_state = 94, .external_lex_state = 2},
  [2285] = {.lex_state = 0, .external_lex_state = 2},
  [2286] = {.lex_state = 94, .external_lex_state = 2},
  [2287] = {.lex_state = 94, .external_lex_state = 2},
  [2288] = {.lex_state = 50, .external_lex_state = 2},
  [2289] = {.lex_state = 0, .external_lex_state = 2},
  [2290] = {.lex_state = 93, .external_lex_state = 2},
  [2291] = {.lex_state = 0, .external_lex_state = 2},
  [2292] = {.lex_state = 94, .external_lex_state = 2},
  [2293] = {.lex_state = 0, .external_lex_state = 2},
  [2294] = {.lex_state = 94, .external_lex_state = 2},
  [2295] = {.lex_state = 0, .external_lex_state = 2},
  [2296] = {.lex_state = 0, .external_lex_state = 2},
  [2297] = {.lex_state = 0, .external_lex_state = 2},
  [2298] = {.lex_state = 94, .external_lex_state = 2},
  [2299] = {.lex_state = 0, .external_lex_state = 2},
  [2300] = {.lex_state = 0, .external_lex_state = 2},
  [2301] = {.lex_state = 94, .external_lex_state = 2},
  [2302] = {.lex_state = 94, .external_lex_state = 2},
  [2303] = {.lex_state = 0, .external_lex_state = 2},
  [2304] = {.lex_state = 0, .external_lex_state = 2},
  [2305] = {.lex_state = 0, .external_lex_state = 2},
  [2306] = {.lex_state = 0, .external_lex_state = 2},
  [2307] = {.lex_state = 0, .external_lex_state = 2},
  [2308] = {.lex_state = 0, .external_lex_state = 2},
  [2309] = {.lex_state = 0, .external_lex_state = 2},
  [2310] = {.lex_state = 0, .external_lex_state = 2},
  [2311] = {.lex_state = 0, .external_lex_state = 2},
  [2312] = {.lex_state = 94, .external_lex_state = 2},
  [2313] = {.lex_state = 0, .external_lex_state = 2},
  [2314] = {.lex_state = 94, .external_lex_state = 2},
  [2315] = {.lex_state = 0, .external_lex_state = 2},
  [2316] = {.lex_state = 94, .external_lex_state = 2},
  [2317] = {.lex_state = 94, .external_lex_state = 2},
  [2318] = {.lex_state = 94, .external_lex_state = 2},
  [2319] = {.lex_state = 94, .external_lex_state = 2},
  [2320] = {.lex_state = 0, .external_lex_state = 2},
  [2321] = {.lex_state = 0, .external_lex_state = 2},
  [2322] = {.lex_state = 0, .external_lex_state = 2},
  [2323] = {.lex_state = 94, .external_lex_state = 2},
  [2324] = {.lex_state = 94, .external_lex_state = 2},
  [2325] = {.lex_state = 94, .external_lex_state = 2},
  [2326] = {.lex_state = 94, .external_lex_state = 2},
  [2327] = {.lex_state = 0, .external_lex_state = 2},
  [2328] = {.lex_state = 0, .external_lex_state = 2},
  [2329] = {.lex_state = 0, .external_lex_state = 2},
  [2330] = {.lex_state = 94, .external_lex_state = 2},
  [2331] = {.lex_state = 0, .external_lex_state = 2},
  [2332] = {.lex_state = 94, .external_lex_state = 2},
  [2333] = {.lex_state = 0, .external_lex_state = 2},
  [2334] = {.lex_state = 94, .external_lex_state = 2},
  [2335] = {.lex_state = 0, .external_lex_state = 2},
  [2336] = {.lex_state = 0, .external_lex_state = 2},
  [2337] = {.lex_state = 94, .external_lex_state = 2},
  [2338] = {.lex_state = 94, .external_lex_state = 2},
  [2339] = {.lex_state = 94, .external_lex_state = 2},
  [2340] = {.lex_state = 0, .external_lex_state = 2},
  [2341] = {.lex_state = 94, .external_lex_state = 2},
  [2342] = {.lex_state = 0, .external_lex_state = 2},
  [2343] = {.lex_state = 0, .external_lex_state = 2},
  [2344] = {.lex_state = 94, .external_lex_state = 2},
  [2345] = {.lex_state = 0, .external_lex_state = 2},
  [2346] = {.lex_state = 94, .external_lex_state = 2},
  [2347] = {.lex_state = 0, .external_lex_state = 2},
  [2348] = {.lex_state = 0, .external_lex_state = 2},
  [2349] = {.lex_state = 0, .external_lex_state = 2},
  [2350] = {.lex_state = 0, .external_lex_state = 2},
  [2351] = {.lex_state = 94, .external_lex_state = 2},
  [2352] = {.lex_state = 94, .external_lex_state = 2},
  [2353] = {.lex_state = 94, .external_lex_state = 2},
  [2354] = {.lex_state = 0, .external_lex_state = 2},
  [2355] = {.lex_state = 0, .external_lex_state = 2},
  [2356] = {.lex_state = 94, .external_lex_state = 2},
  [2357] = {.lex_state = 0, .external_lex_state = 2},
  [2358] = {.lex_state = 0, .external_lex_state = 2},
  [2359] = {.lex_state = 50, .external_lex_state = 2},
  [2360] = {.lex_state = 94, .external_lex_state = 2},
  [2361] = {.lex_state = 93, .external_lex_state = 2},
  [2362] = {.lex_state = 0, .external_lex_state = 2},
  [2363] = {.lex_state = 0, .external_lex_state = 2},
  [2364] = {.lex_state = 0, .external_lex_state = 2},
  [2365] = {.lex_state = 0, .external_lex_state = 2},
  [2366] = {.lex_state = 94, .external_lex_state = 2},
  [2367] = {.lex_state = 0, .external_lex_state = 2},
  [2368] = {.lex_state = 0, .external_lex_state = 2},
  [2369] = {.lex_state = 94, .external_lex_state = 2},
  [2370] = {.lex_state = 0, .external_lex_state = 2},
  [2371] = {.lex_state = 0, .external_lex_state = 2},
  [2372] = {.lex_state = 94, .external_lex_state = 2},
  [2373] = {.lex_state = 94, .external_lex_state = 2},
  [2374] = {.lex_state = 94, .external_lex_state = 2},
  [2375] = {.lex_state = 0, .external_lex_state = 2},
  [2376] = {.lex_state = 0, .external_lex_state = 2},
  [2377] = {.lex_state = 0, .external_lex_state = 2},
  [2378] = {.lex_state = 0, .external_lex_state = 2},
  [2379] = {.lex_state = 94, .external_lex_state = 2},
  [2380] = {.lex_state = 0, .external_lex_state = 2},
  [2381] = {.lex_state = 94, .external_lex_state = 2},
  [2382] = {.lex_state = 94, .external_lex_state = 2},
  [2383] = {.lex_state = 0, .external_lex_state = 2},
  [2384] = {.lex_state = 94, .external_lex_state = 2},
  [2385] = {.lex_state = 0, .external_lex_state = 2},
  [2386] = {.lex_state = 0, .external_lex_state = 2},
  [2387] = {.lex_state = 0, .external_lex_state = 2},
  [2388] = {.lex_state = 94, .external_lex_state = 2},
  [2389] = {.lex_state = 0, .external_lex_state = 2},
  [2390] = {.lex_state = 0, .external_lex_state = 2},
  [2391] = {.lex_state = 94, .external_lex_state = 2},
  [2392] = {.lex_state = 0, .external_lex_state = 2},
  [2393] = {.lex_state = 0, .external_lex_state = 2},
  [2394] = {.lex_state = 94, .external_lex_state = 2},
  [2395] = {.lex_state = 94, .external_lex_state = 2},
  [2396] = {.lex_state = 94, .external_lex_state = 2},
  [2397] = {.lex_state = 0, .external_lex_state = 2},
  [2398] = {.lex_state = 0, .external_lex_state = 2},
  [2399] = {.lex_state = 0, .external_lex_state = 2},
  [2400] = {.lex_state = 94, .external_lex_state = 2},
  [2401] = {.lex_state = 0, .external_lex_state = 2},
  [2402] = {.lex_state = 93, .external_lex_state = 2},
  [2403] = {.lex_state = 0, .external_lex_state = 2},
  [2404] = {.lex_state = 0, .external_lex_state = 2},
  [2405] = {.lex_state = 93, .external_lex_state = 2},
  [2406] = {.lex_state = 94, .external_lex_state = 2},
  [2407] = {.lex_state = 93, .external_lex_state = 2},
  [2408] = {.lex_state = 0, .external_lex_state = 2},
  [2409] = {.lex_state = 0, .external_lex_state = 2},
  [2410] = {.lex_state = 0, .external_lex_state = 2},
  [2411] = {.lex_state = 0, .external_lex_state = 2},
  [2412] = {.lex_state = 0, .external_lex_state = 2},
  [2413] = {.lex_state = 0, .external_lex_state = 2},
  [2414] = {.lex_state = 0, .external_lex_state = 2},
  [2415] = {.lex_state = 94, .external_lex_state = 2},
  [2416] = {.lex_state = 94, .external_lex_state = 2},
  [2417] = {.lex_state = 0, .external_lex_state = 2},
  [2418] = {.lex_state = 0, .external_lex_state = 2},
  [2419] = {.lex_state = 94, .external_lex_state = 2},
  [2420] = {.lex_state = 0, .external_lex_state = 2},
  [2421] = {.lex_state = 0, .external_lex_state = 2},
  [2422] = {.lex_state = 94, .external_lex_state = 2},
  [2423] = {.lex_state = 94, .external_lex_state = 2},
  [2424] = {.lex_state = 0, .external_lex_state = 2},
  [2425] = {.lex_state = 0, .external_lex_state = 2},
  [2426] = {.lex_state = 0, .external_lex_state = 2},
  [2427] = {.lex_state = 0, .external_lex_state = 2},
  [2428] = {.lex_state = 0, .external_lex_state = 2},
  [2429] = {.lex_state = 0, .external_lex_state = 2},
  [2430] = {.lex_state = 0, .external_lex_state = 2},
  [2431] = {.lex_state = 94, .external_lex_state = 2},
  [2432] = {.lex_state = 0, .external_lex_state = 2},
  [2433] = {.lex_state = 0, .external_lex_state = 2},
  [2434] = {.lex_state = 0, .external_lex_state = 2},
  [2435] = {.lex_state = 0, .external_lex_state = 2},
  [2436] = {.lex_state = 0, .external_lex_state = 2},
  [2437] = {.lex_state = 0, .external_lex_state = 2},
  [2438] = {.lex_state = 0, .external_lex_state = 2},
  [2439] = {.lex_state = 0, .external_lex_state = 2},
  [2440] = {.lex_state = 0, .external_lex_state = 2},
  [2441] = {.lex_state = 0, .external_lex_state = 2},
  [2442] = {.lex_state = 94, .external_lex_state = 2},
  [2443] = {.lex_state = 0, .external_lex_state = 2},
  [2444] = {.lex_state = 0, .external_lex_state = 2},
  [2445] = {.lex_state = 0, .external_lex_state = 2},
  [2446] = {.lex_state = 94, .external_lex_state = 2},
  [2447] = {.lex_state = 0, .external_lex_state = 2},
  [2448] = {.lex_state = 0, .external_lex_state = 2},
  [2449] = {.lex_state = 0, .external_lex_state = 2},
  [2450] = {.lex_state = 0, .external_lex_state = 2},
  [2451] = {.lex_state = 0, .external_lex_state = 2},
  [2452] = {.lex_state = 95, .external_lex_state = 2},
  [2453] = {.lex_state = 94, .external_lex_state = 2},
  [2454] = {.lex_state = 0, .external_lex_state = 2},
  [2455] = {.lex_state = 0, .external_lex_state = 2},
  [2456] = {.lex_state = 94, .external_lex_state = 2},
  [2457] = {.lex_state = 0, .external_lex_state = 2},
  [2458] = {.lex_state = 0, .external_lex_state = 2},
  [2459] = {.lex_state = 0, .external_lex_state = 2},
  [2460] = {.lex_state = 0, .external_lex_state = 2},
  [2461] = {.lex_state = 0, .external_lex_state = 2},
  [2462] = {.lex_state = 0, .external_lex_state = 2},
  [2463] = {.lex_state = 0, .external_lex_state = 2},
  [2464] = {.lex_state = 0, .external_lex_state = 2},
  [2465] = {.lex_state = 0, .external_lex_state = 2},
  [2466] = {.lex_state = 0, .external_lex_state = 2},
  [2467] = {.lex_state = 0, .external_lex_state = 2},
  [2468] = {.lex_state = 0, .external_lex_state = 2},
  [2469] = {.lex_state = 94, .external_lex_state = 2},
  [2470] = {.lex_state = 0, .external_lex_state = 2},
  [2471] = {.lex_state = 94, .external_lex_state = 2},
  [2472] = {.lex_state = 0, .external_lex_state = 2},
  [2473] = {.lex_state = 94, .external_lex_state = 2},
  [2474] = {.lex_state = 0, .external_lex_state = 2},
  [2475] = {.lex_state = 94, .external_lex_state = 2},
  [2476] = {.lex_state = 0, .external_lex_state = 2},
  [2477] = {.lex_state = 0, .external_lex_state = 2},
  [2478] = {.lex_state = 0, .external_lex_state = 2},
  [2479] = {.lex_state = 94, .external_lex_state = 2},
  [2480] = {.lex_state = 0, .external_lex_state = 2},
  [2481] = {.lex_state = 93, .external_lex_state = 2},
  [2482] = {.lex_state = 0, .external_lex_state = 2},
  [2483] = {.lex_state = 0, .external_lex_state = 2},
  [2484] = {.lex_state = 0, .external_lex_state = 2},
  [2485] = {.lex_state = 0, .external_lex_state = 2},
  [2486] = {.lex_state = 0, .external_lex_state = 2},
  [2487] = {.lex_state = 0, .external_lex_state = 2},
  [2488] = {.lex_state = 94, .external_lex_state = 2},
  [2489] = {.lex_state = 0, .external_lex_state = 2},
  [2490] = {.lex_state = 0, .external_lex_state = 2},
  [2491] = {.lex_state = 94, .external_lex_state = 2},
  [2492] = {.lex_state = 0, .external_lex_state = 2},
  [2493] = {.lex_state = 0, .external_lex_state = 2},
  [2494] = {.lex_state = 94, .external_lex_state = 2},
  [2495] = {.lex_state = 0, .external_lex_state = 2},
  [2496] = {.lex_state = 0, .external_lex_state = 2},
  [2497] = {.lex_state = 0, .external_lex_state = 2},
  [2498] = {.lex_state = 0, .external_lex_state = 2},
  [2499] = {.lex_state = 0, .external_lex_state = 2},
  [2500] = {.lex_state = 0, .external_lex_state = 2},
  [2501] = {.lex_state = 0, .external_lex_state = 2},
  [2502] = {.lex_state = 0, .external_lex_state = 2},
  [2503] = {.lex_state = 0, .external_lex_state = 2},
  [2504] = {.lex_state = 0, .external_lex_state = 2},
  [2505] = {.lex_state = 0, .external_lex_state = 2},
  [2506] = {.lex_state = 0, .external_lex_state = 2},
  [2507] = {.lex_state = 0, .external_lex_state = 2},
  [2508] = {.lex_state = 0, .external_lex_state = 2},
  [2509] = {.lex_state = 0, .external_lex_state = 2},
  [2510] = {.lex_state = 0, .external_lex_state = 2},
  [2511] = {.lex_state = 0, .external_lex_state = 2},
  [2512] = {.lex_state = 94, .external_lex_state = 2},
  [2513] = {.lex_state = 0, .external_lex_state = 2},
  [2514] = {.lex_state = 0, .external_lex_state = 2},
  [2515] = {.lex_state = 0, .external_lex_state = 2},
  [2516] = {.lex_state = 94, .external_lex_state = 2},
  [2517] = {.lex_state = 0, .external_lex_state = 2},
  [2518] = {.lex_state = 0, .external_lex_state = 2},
  [2519] = {.lex_state = 0, .external_lex_state = 2},
  [2520] = {.lex_state = 0, .external_lex_state = 2},
  [2521] = {.lex_state = 0, .external_lex_state = 2},
  [2522] = {.lex_state = 0, .external_lex_state = 2},
  [2523] = {.lex_state = 94, .external_lex_state = 2},
  [2524] = {.lex_state = 94, .external_lex_state = 2},
  [2525] = {.lex_state = 0, .external_lex_state = 2},
  [2526] = {.lex_state = 0, .external_lex_state = 2},
  [2527] = {.lex_state = 0, .external_lex_state = 2},
  [2528] = {.lex_state = 0, .external_lex_state = 2},
  [2529] = {.lex_state = 0, .external_lex_state = 2},
  [2530] = {.lex_state = 0, .external_lex_state = 2},
  [2531] = {.lex_state = 0, .external_lex_state = 2},
  [2532] = {.lex_state = 23, .external_lex_state = 2},
  [2533] = {.lex_state = 0, .external_lex_state = 2},
  [2534] = {.lex_state = 0, .external_lex_state = 2},
  [2535] = {.lex_state = 0, .external_lex_state = 2},
  [2536] = {.lex_state = 0, .external_lex_state = 2},
  [2537] = {.lex_state = 0, .external_lex_state = 2},
  [2538] = {.lex_state = 0, .external_lex_state = 2},
  [2539] = {.lex_state = 0, .external_lex_state = 2},
  [2540] = {.lex_state = 0, .external_lex_state = 2},
  [2541] = {.lex_state = 0, .external_lex_state = 2},
  [2542] = {.lex_state = 0, .external_lex_state = 2},
  [2543] = {.lex_state = 0, .external_lex_state = 2},
  [2544] = {.lex_state = 0, .external_lex_state = 2},
  [2545] = {.lex_state = 94, .external_lex_state = 2},
  [2546] = {.lex_state = 0, .external_lex_state = 2},
  [2547] = {.lex_state = 0, .external_lex_state = 2},
  [2548] = {.lex_state = 0, .external_lex_state = 2},
  [2549] = {.lex_state = 0, .external_lex_state = 2},
  [2550] = {.lex_state = 0, .external_lex_state = 2},
  [2551] = {.lex_state = 0, .external_lex_state = 2},
  [2552] = {.lex_state = 0, .external_lex_state = 2},
  [2553] = {.lex_state = 0, .external_lex_state = 2},
  [2554] = {.lex_state = 0, .external_lex_state = 2},
  [2555] = {.lex_state = 94, .external_lex_state = 2},
  [2556] = {.lex_state = 0, .external_lex_state = 2},
  [2557] = {.lex_state = 94, .external_lex_state = 2},
  [2558] = {.lex_state = 94, .external_lex_state = 2},
  [2559] = {.lex_state = 94, .external_lex_state = 2},
  [2560] = {.lex_state = 94, .external_lex_state = 2},
  [2561] = {.lex_state = 0, .external_lex_state = 2},
  [2562] = {.lex_state = 0, .external_lex_state = 2},
  [2563] = {.lex_state = 0, .external_lex_state = 2},
  [2564] = {.lex_state = 0, .external_lex_state = 2},
  [2565] = {.lex_state = 0, .external_lex_state = 2},
  [2566] = {.lex_state = 94, .external_lex_state = 2},
  [2567] = {.lex_state = 94, .external_lex_state = 2},
  [2568] = {.lex_state = 0, .external_lex_state = 2},
  [2569] = {.lex_state = 0, .external_lex_state = 2},
  [2570] = {.lex_state = 0, .external_lex_state = 2},
  [2571] = {.lex_state = 0, .external_lex_state = 2},
  [2572] = {.lex_state = 94, .external_lex_state = 2},
  [2573] = {.lex_state = 94, .external_lex_state = 2},
  [2574] = {.lex_state = 94, .external_lex_state = 2},
  [2575] = {.lex_state = 94, .external_lex_state = 2},
  [2576] = {.lex_state = 94, .external_lex_state = 2},
  [2577] = {.lex_state = 0, .external_lex_state = 2},
  [2578] = {.lex_state = 94, .external_lex_state = 2},
  [2579] = {.lex_state = 0, .external_lex_state = 2},
  [2580] = {.lex_state = 0, .external_lex_state = 2},
  [2581] = {.lex_state = 94, .external_lex_state = 2},
  [2582] = {.lex_state = 0, .external_lex_state = 2},
  [2583] = {.lex_state = 0, .external_lex_state = 2},
  [2584] = {.lex_state = 0, .external_lex_state = 2},
  [2585] = {.lex_state = 94, .external_lex_state = 2},
  [2586] = {.lex_state = 0, .external_lex_state = 2},
  [2587] = {.lex_state = 0, .external_lex_state = 2},
  [2588] = {.lex_state = 0, .external_lex_state = 2},
  [2589] = {.lex_state = 94, .external_lex_state = 2},
  [2590] = {.lex_state = 94, .external_lex_state = 2},
  [2591] = {.lex_state = 94, .external_lex_state = 2},
  [2592] = {.lex_state = 94, .external_lex_state = 2},
  [2593] = {.lex_state = 94, .external_lex_state = 2},
  [2594] = {.lex_state = 0, .external_lex_state = 2},
  [2595] = {.lex_state = 94, .external_lex_state = 2},
  [2596] = {.lex_state = 0, .external_lex_state = 2},
  [2597] = {.lex_state = 0, .external_lex_state = 2},
  [2598] = {.lex_state = 94, .external_lex_state = 2},
  [2599] = {.lex_state = 0, .external_lex_state = 2},
  [2600] = {.lex_state = 0, .external_lex_state = 2},
  [2601] = {.lex_state = 0, .external_lex_state = 2},
  [2602] = {.lex_state = 0, .external_lex_state = 2},
  [2603] = {.lex_state = 0, .external_lex_state = 2},
  [2604] = {.lex_state = 23, .external_lex_state = 2},
  [2605] = {.lex_state = 0, .external_lex_state = 2},
  [2606] = {.lex_state = 0, .external_lex_state = 2},
  [2607] = {.lex_state = 0, .external_lex_state = 2},
  [2608] = {.lex_state = 0, .external_lex_state = 2},
  [2609] = {.lex_state = 0, .external_lex_state = 2},
  [2610] = {.lex_state = 94, .external_lex_state = 2},
  [2611] = {.lex_state = 0, .external_lex_state = 2},
  [2612] = {.lex_state = 0, .external_lex_state = 2},
  [2613] = {.lex_state = 94, .external_lex_state = 2},
  [2614] = {.lex_state = 94, .external_lex_state = 2},
  [2615] = {.lex_state = 94, .external_lex_state = 2},
  [2616] = {.lex_state = 94, .external_lex_state = 2},
  [2617] = {.lex_state = 94, .external_lex_state = 2},
  [2618] = {.lex_state = 94, .external_lex_state = 2},
  [2619] = {.lex_state = 94, .external_lex_state = 2},
  [2620] = {.lex_state = 94, .external_lex_state = 2},
  [2621] = {.lex_state = 94, .external_lex_state = 2},
  [2622] = {.lex_state = 0, .external_lex_state = 2},
  [2623] = {.lex_state = 0, .external_lex_state = 2},
  [2624] = {.lex_state = 0, .external_lex_state = 2},
  [2625] = {.lex_state = 0, .external_lex_state = 2},
  [2626] = {.lex_state = 0, .external_lex_state = 2},
  [2627] = {.lex_state = 0, .external_lex_state = 2},
  [2628] = {.lex_state = 0, .external_lex_state = 2},
  [2629] = {.lex_state = 0, .external_lex_state = 2},
  [2630] = {.lex_state = 0, .external_lex_state = 2},
  [2631] = {.lex_state = 0, .external_lex_state = 2},
  [2632] = {.lex_state = 0, .external_lex_state = 2},
  [2633] = {.lex_state = 0, .external_lex_state = 2},
  [2634] = {.lex_state = 0, .external_lex_state = 2},
  [2635] = {.lex_state = 0, .external_lex_state = 2},
  [2636] = {.lex_state = 94, .external_lex_state = 2},
  [2637] = {.lex_state = 94, .external_lex_state = 2},
  [2638] = {.lex_state = 94, .external_lex_state = 2},
  [2639] = {.lex_state = 94, .external_lex_state = 2},
  [2640] = {.lex_state = 0, .external_lex_state = 2},
  [2641] = {.lex_state = 94, .external_lex_state = 2},
  [2642] = {.lex_state = 0, .external_lex_state = 2},
  [2643] = {.lex_state = 0, .external_lex_state = 2},
  [2644] = {.lex_state = 94, .external_lex_state = 2},
  [2645] = {.lex_state = 0, .external_lex_state = 2},
  [2646] = {.lex_state = 94, .external_lex_state = 2},
  [2647] = {.lex_state = 94, .external_lex_state = 2},
  [2648] = {.lex_state = 0, .external_lex_state = 2},
  [2649] = {.lex_state = 0, .external_lex_state = 2},
  [2650] = {.lex_state = 94, .external_lex_state = 2},
  [2651] = {.lex_state = 94, .external_lex_state = 2},
  [2652] = {.lex_state = 94, .external_lex_state = 2},
  [2653] = {.lex_state = 0, .external_lex_state = 2},
  [2654] = {.lex_state = 0, .external_lex_state = 2},
  [2655] = {.lex_state = 0, .external_lex_state = 2},
  [2656] = {.lex_state = 94, .external_lex_state = 2},
  [2657] = {.lex_state = 94, .external_lex_state = 2},
  [2658] = {.lex_state = 0, .external_lex_state = 2},
  [2659] = {.lex_state = 0, .external_lex_state = 2},
  [2660] = {.lex_state = 0, .external_lex_state = 2},
  [2661] = {.lex_state = 94, .external_lex_state = 2},
  [2662] = {.lex_state = 94, .external_lex_state = 2},
  [2663] = {.lex_state = 0, .external_lex_state = 2},
  [2664] = {.lex_state = 0, .external_lex_state = 2},
  [2665] = {.lex_state = 0, .external_lex_state = 2},
  [2666] = {.lex_state = 94, .external_lex_state = 2},
  [2667] = {.lex_state = 94, .external_lex_state = 2},
  [2668] = {.lex_state = 0, .external_lex_state = 2},
  [2669] = {.lex_state = 0, .external_lex_state = 2},
  [2670] = {.lex_state = 94, .external_lex_state = 2},
  [2671] = {.lex_state = 94, .external_lex_state = 2},
  [2672] = {.lex_state = 0, .external_lex_state = 2},
  [2673] = {.lex_state = 0, .external_lex_state = 2},
  [2674] = {.lex_state = 0, .external_lex_state = 2},
  [2675] = {.lex_state = 0, .external_lex_state = 2},
  [2676] = {.lex_state = 94, .external_lex_state = 2},
  [2677] = {.lex_state = 94, .external_lex_state = 2},
  [2678] = {.lex_state = 94, .external_lex_state = 2},
  [2679] = {.lex_state = 0, .external_lex_state = 2},
  [2680] = {.lex_state = 93, .external_lex_state = 2},
  [2681] = {.lex_state = 93, .external_lex_state = 2},
  [2682] = {.lex_state = 93, .external_lex_state = 2},
  [2683] = {.lex_state = 93, .external_lex_state = 2},
  [2684] = {.lex_state = 93, .external_lex_state = 2},
  [2685] = {.lex_state = 94, .external_lex_state = 2},
  [2686] = {.lex_state = 94, .external_lex_state = 2},
  [2687] = {.lex_state = 94, .external_lex_state = 2},
  [2688] = {.lex_state = 0, .external_lex_state = 2},
  [2689] = {.lex_state = 94, .external_lex_state = 2},
  [2690] = {.lex_state = 0, .external_lex_state = 2},
  [2691] = {.lex_state = 0, .external_lex_state = 2},
  [2692] = {.lex_state = 0, .external_lex_state = 2},
  [2693] = {.lex_state = 94, .external_lex_state = 2},
  [2694] = {.lex_state = 94, .external_lex_state = 2},
  [2695] = {.lex_state = 0, .external_lex_state = 2},
  [2696] = {.lex_state = 0, .external_lex_state = 2},
  [2697] = {.lex_state = 94, .external_lex_state = 2},
  [2698] = {.lex_state = 94, .external_lex_state = 2},
  [2699] = {.lex_state = 263, .external_lex_state = 2},
  [2700] = {.lex_state = 0, .external_lex_state = 2},
  [2701] = {.lex_state = 94, .external_lex_state = 2},
  [2702] = {.lex_state = 94, .external_lex_state = 2},
  [2703] = {.lex_state = 0, .external_lex_state = 2},
  [2704] = {.lex_state = 94, .external_lex_state = 2},
  [2705] = {.lex_state = 0, .external_lex_state = 2},
  [2706] = {.lex_state = 0, .external_lex_state = 2},
  [2707] = {.lex_state = 0, .external_lex_state = 2},
  [2708] = {.lex_state = 0, .external_lex_state = 2},
  [2709] = {.lex_state = 94, .external_lex_state = 2},
  [2710] = {.lex_state = 0, .external_lex_state = 2},
  [2711] = {.lex_state = 0, .external_lex_state = 2},
  [2712] = {.lex_state = 0, .external_lex_state = 2},
  [2713] = {.lex_state = 0, .external_lex_state = 2},
  [2714] = {.lex_state = 0, .external_lex_state = 2},
  [2715] = {.lex_state = 0, .external_lex_state = 2},
  [2716] = {.lex_state = 94, .external_lex_state = 2},
  [2717] = {.lex_state = 0, .external_lex_state = 2},
  [2718] = {.lex_state = 94, .external_lex_state = 2},
  [2719] = {.lex_state = 94, .external_lex_state = 2},
  [2720] = {.lex_state = 93, .external_lex_state = 2},
  [2721] = {.lex_state = 94, .external_lex_state = 2},
  [2722] = {.lex_state = 0, .external_lex_state = 2},
  [2723] = {.lex_state = 41, .external_lex_state = 2},
  [2724] = {.lex_state = 94, .external_lex_state = 2},
  [2725] = {.lex_state = 0, .external_lex_state = 2},
  [2726] = {.lex_state = 0, .external_lex_state = 2},
  [2727] = {.lex_state = 0, .external_lex_state = 2},
  [2728] = {.lex_state = 0, .external_lex_state = 2},
  [2729] = {.lex_state = 94, .external_lex_state = 2},
  [2730] = {.lex_state = 0, .external_lex_state = 2},
  [2731] = {.lex_state = 0, .external_lex_state = 2},
  [2732] = {.lex_state = 1, .external_lex_state = 2},
  [2733] = {.lex_state = 0, .external_lex_state = 2},
  [2734] = {.lex_state = 94, .external_lex_state = 2},
  [2735] = {.lex_state = 0, .external_lex_state = 2},
  [2736] = {.lex_state = 0, .external_lex_state = 2},
  [2737] = {.lex_state = 0, .external_lex_state = 2},
  [2738] = {.lex_state = 0, .external_lex_state = 2},
  [2739] = {.lex_state = 0, .external_lex_state = 2},
  [2740] = {.lex_state = 0, .external_lex_state = 2},
  [2741] = {.lex_state = 0, .external_lex_state = 2},
  [2742] = {.lex_state = 0, .external_lex_state = 2},
  [2743] = {.lex_state = 0, .external_lex_state = 2},
  [2744] = {.lex_state = 0, .external_lex_state = 2},
  [2745] = {.lex_state = 0, .external_lex_state = 2},
  [2746] = {.lex_state = 94, .external_lex_state = 2},
  [2747] = {.lex_state = 94, .external_lex_state = 2},
  [2748] = {.lex_state = 0, .external_lex_state = 2},
  [2749] = {.lex_state = 0, .external_lex_state = 2},
  [2750] = {.lex_state = 0, .external_lex_state = 2},
  [2751] = {.lex_state = 94, .external_lex_state = 2},
  [2752] = {.lex_state = 0, .external_lex_state = 2},
  [2753] = {.lex_state = 0, .external_lex_state = 2},
  [2754] = {.lex_state = 0, .external_lex_state = 2},
  [2755] = {.lex_state = 94, .external_lex_state = 2},
  [2756] = {.lex_state = 94, .external_lex_state = 2},
  [2757] = {.lex_state = 0, .external_lex_state = 2},
  [2758] = {.lex_state = 0, .external_lex_state = 2},
  [2759] = {.lex_state = 0, .external_lex_state = 2},
  [2760] = {.lex_state = 0, .external_lex_state = 2},
  [2761] = {.lex_state = 94, .external_lex_state = 2},
  [2762] = {.lex_state = 0, .external_lex_state = 2},
  [2763] = {.lex_state = 94, .external_lex_state = 2},
  [2764] = {.lex_state = 0, .external_lex_state = 2},
  [2765] = {.lex_state = 0, .external_lex_state = 2},
  [2766] = {.lex_state = 0, .external_lex_state = 2},
  [2767] = {.lex_state = 0, .external_lex_state = 2},
  [2768] = {.lex_state = 0, .external_lex_state = 2},
  [2769] = {.lex_state = 0, .external_lex_state = 2},
  [2770] = {.lex_state = 0, .external_lex_state = 2},
  [2771] = {.lex_state = 0, .external_lex_state = 2},
  [2772] = {.lex_state = 94, .external_lex_state = 2},
  [2773] = {.lex_state = 0, .external_lex_state = 2},
  [2774] = {.lex_state = 0, .external_lex_state = 2},
  [2775] = {.lex_state = 0, .external_lex_state = 2},
  [2776] = {.lex_state = 2, .external_lex_state = 2},
  [2777] = {.lex_state = 94, .external_lex_state = 2},
  [2778] = {.lex_state = 0, .external_lex_state = 2},
  [2779] = {.lex_state = 0, .external_lex_state = 2},
  [2780] = {.lex_state = 0, .external_lex_state = 2},
  [2781] = {.lex_state = 94, .external_lex_state = 2},
  [2782] = {.lex_state = 94, .external_lex_state = 2},
  [2783] = {.lex_state = 94, .external_lex_state = 2},
  [2784] = {.lex_state = 94, .external_lex_state = 2},
  [2785] = {.lex_state = 0, .external_lex_state = 2},
  [2786] = {.lex_state = 94, .external_lex_state = 2},
  [2787] = {.lex_state = 0, .external_lex_state = 2},
  [2788] = {.lex_state = 0, .external_lex_state = 2},
  [2789] = {.lex_state = 0, .external_lex_state = 2},
  [2790] = {.lex_state = 0, .external_lex_state = 2},
  [2791] = {.lex_state = 94, .external_lex_state = 2},
  [2792] = {.lex_state = 0, .external_lex_state = 2},
  [2793] = {.lex_state = 94, .external_lex_state = 2},
  [2794] = {.lex_state = 94, .external_lex_state = 2},
  [2795] = {.lex_state = 94, .external_lex_state = 2},
  [2796] = {.lex_state = 94, .external_lex_state = 2},
  [2797] = {.lex_state = 94, .external_lex_state = 2},
  [2798] = {.lex_state = 0, .external_lex_state = 2},
  [2799] = {.lex_state = 94, .external_lex_state = 2},
  [2800] = {.lex_state = 94, .external_lex_state = 2},
  [2801] = {.lex_state = 94, .external_lex_state = 2},
  [2802] = {.lex_state = 0, .external_lex_state = 2},
  [2803] = {.lex_state = 0, .external_lex_state = 2},
  [2804] = {.lex_state = 0, .external_lex_state = 2},
  [2805] = {.lex_state = 93, .external_lex_state = 2},
  [2806] = {.lex_state = 94, .external_lex_state = 2},
  [2807] = {.lex_state = 93, .external_lex_state = 2},
  [2808] = {.lex_state = 94, .external_lex_state = 2},
  [2809] = {.lex_state = 0, .external_lex_state = 2},
  [2810] = {.lex_state = 0, .external_lex_state = 2},
  [2811] = {.lex_state = 0, .external_lex_state = 2},
  [2812] = {.lex_state = 0, .external_lex_state = 2},
  [2813] = {.lex_state = 0, .external_lex_state = 2},
  [2814] = {.lex_state = 0, .external_lex_state = 2},
  [2815] = {.lex_state = 94, .external_lex_state = 2},
  [2816] = {.lex_state = 0, .external_lex_state = 2},
  [2817] = {.lex_state = 0, .external_lex_state = 2},
  [2818] = {.lex_state = 94, .external_lex_state = 2},
  [2819] = {.lex_state = 0, .external_lex_state = 2},
  [2820] = {.lex_state = 94, .external_lex_state = 2},
  [2821] = {.lex_state = 94, .external_lex_state = 2},
  [2822] = {.lex_state = 0, .external_lex_state = 2},
  [2823] = {.lex_state = 93, .external_lex_state = 2},
  [2824] = {.lex_state = 277, .external_lex_state = 2},
  [2825] = {.lex_state = 0, .external_lex_state = 2},
  [2826] = {.lex_state = 0, .external_lex_state = 2},
  [2827] = {.lex_state = 93, .external_lex_state = 2},
  [2828] = {.lex_state = 0, .external_lex_state = 2},
  [2829] = {.lex_state = 0, .external_lex_state = 2},
  [2830] = {.lex_state = 0, .external_lex_state = 2},
  [2831] = {.lex_state = 0, .external_lex_state = 2},
  [2832] = {.lex_state = 0, .external_lex_state = 2},
  [2833] = {.lex_state = 0, .external_lex_state = 2},
  [2834] = {.lex_state = 0, .external_lex_state = 2},
  [2835] = {.lex_state = 0, .external_lex_state = 2},
  [2836] = {.lex_state = 0, .external_lex_state = 2},
  [2837] = {.lex_state = 0, .external_lex_state = 2},
  [2838] = {.lex_state = 0, .external_lex_state = 2},
  [2839] = {.lex_state = 94, .external_lex_state = 2},
  [2840] = {.lex_state = 0, .external_lex_state = 2},
  [2841] = {.lex_state = 0, .external_lex_state = 2},
  [2842] = {.lex_state = 0, .external_lex_state = 2},
  [2843] = {.lex_state = 0, .external_lex_state = 2},
  [2844] = {(TSStateId)(-1)},
  [2845] = {(TSStateId)(-1)},
  [2846] = {(TSStateId)(-1)},
  [2847] = {(TSStateId)(-1)},
  [2848] = {(TSStateId)(-1)},
};

enum {
  ts_external_token__automatic_semicolon = 0,
  ts_external_token__template_chars_double = 1,
  ts_external_token__template_chars_single = 2,
  ts_external_token__template_chars_double_single = 3,
  ts_external_token__template_chars_single_single = 4,
  ts_external_token__template_chars_raw_slash = 5,
  ts_external_token__block_comment = 6,
  ts_external_token__documentation_block_comment = 7,
};

static const TSSymbol ts_external_scanner_symbol_map[EXTERNAL_TOKEN_COUNT] = {
  [ts_external_token__automatic_semicolon] = sym__automatic_semicolon,
  [ts_external_token__template_chars_double] = sym__template_chars_double,
  [ts_external_token__template_chars_single] = sym__template_chars_single,
  [ts_external_token__template_chars_double_single] = sym__template_chars_double_single,
  [ts_external_token__template_chars_single_single] = sym__template_chars_single_single,
  [ts_external_token__template_chars_raw_slash] = sym__template_chars_raw_slash,
  [ts_external_token__block_comment] = sym__block_comment,
  [ts_external_token__documentation_block_comment] = sym__documentation_block_comment,
};

static const bool ts_external_scanner_states[11][EXTERNAL_TOKEN_COUNT] = {
  [1] = {
    [ts_external_token__automatic_semicolon] = true,
    [ts_external_token__template_chars_double] = true,
    [ts_external_token__template_chars_single] = true,
    [ts_external_token__template_chars_double_single] = true,
    [ts_external_token__template_chars_single_single] = true,
    [ts_external_token__template_chars_raw_slash] = true,
    [ts_external_token__block_comment] = true,
    [ts_external_token__documentation_block_comment] = true,
  },
  [2] = {
    [ts_external_token__block_comment] = true,
    [ts_external_token__documentation_block_comment] = true,
  },
  [3] = {
    [ts_external_token__template_chars_double] = true,
    [ts_external_token__block_comment] = true,
    [ts_external_token__documentation_block_comment] = true,
  },
  [4] = {
    [ts_external_token__template_chars_single] = true,
    [ts_external_token__block_comment] = true,
    [ts_external_token__documentation_block_comment] = true,
  },
  [5] = {
    [ts_external_token__template_chars_single_single] = true,
    [ts_external_token__block_comment] = true,
    [ts_external_token__documentation_block_comment] = true,
  },
  [6] = {
    [ts_external_token__template_chars_single] = true,
    [ts_external_token__template_chars_raw_slash] = true,
    [ts_external_token__block_comment] = true,
    [ts_external_token__documentation_block_comment] = true,
  },
  [7] = {
    [ts_external_token__template_chars_double_single] = true,
    [ts_external_token__block_comment] = true,
    [ts_external_token__documentation_block_comment] = true,
  },
  [8] = {
    [ts_external_token__template_chars_double] = true,
    [ts_external_token__template_chars_raw_slash] = true,
    [ts_external_token__block_comment] = true,
    [ts_external_token__documentation_block_comment] = true,
  },
  [9] = {
    [ts_external_token__template_chars_single_single] = true,
    [ts_external_token__template_chars_raw_slash] = true,
    [ts_external_token__block_comment] = true,
    [ts_external_token__documentation_block_comment] = true,
  },
  [10] = {
    [ts_external_token__template_chars_double_single] = true,
    [ts_external_token__template_chars_raw_slash] = true,
    [ts_external_token__block_comment] = true,
    [ts_external_token__documentation_block_comment] = true,
  },
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [sym_comment] = STATE(0),
    [sym_documentation_comment] = STATE(0),
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym_identifier] = ACTIONS(1),
    [anon_sym_POUND] = ACTIONS(1),
    [sym_decimal_integer_literal] = ACTIONS(1),
    [sym_hex_integer_literal] = ACTIONS(1),
    [sym_decimal_floating_point_literal] = ACTIONS(1),
    [anon_sym_true] = ACTIONS(1),
    [anon_sym_false] = ACTIONS(1),
    [anon_sym_DQUOTE] = ACTIONS(1),
    [anon_sym_SQUOTE] = ACTIONS(1),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(1),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(1),
    [anon_sym_r_DQUOTE] = ACTIONS(1),
    [anon_sym_DOLLAR] = ACTIONS(1),
    [anon_sym_r_SQUOTE] = ACTIONS(1),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(1),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [sym__unused_escape_sequence] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_null] = ACTIONS(1),
    [anon_sym_throw] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_PLUS_EQ] = ACTIONS(1),
    [anon_sym_DASH_EQ] = ACTIONS(1),
    [anon_sym_STAR_EQ] = ACTIONS(1),
    [anon_sym_SLASH_EQ] = ACTIONS(1),
    [anon_sym_PERCENT_EQ] = ACTIONS(1),
    [anon_sym_TILDE_SLASH_EQ] = ACTIONS(1),
    [anon_sym_LT_LT_EQ] = ACTIONS(1),
    [anon_sym_GT_GT_EQ] = ACTIONS(1),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(1),
    [anon_sym_AMP_EQ] = ACTIONS(1),
    [anon_sym_CARET_EQ] = ACTIONS(1),
    [anon_sym_PIPE_EQ] = ACTIONS(1),
    [anon_sym_QMARK_QMARK_EQ] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_QMARK_QMARK] = ACTIONS(1),
    [anon_sym_QMARK] = ACTIONS(1),
    [anon_sym_PIPE_PIPE] = ACTIONS(1),
    [anon_sym_AMP_AMP] = ACTIONS(1),
    [sym_equality_operator] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [anon_sym_LT_EQ] = ACTIONS(1),
    [anon_sym_GT_EQ] = ACTIONS(1),
    [anon_sym_PIPE] = ACTIONS(1),
    [anon_sym_CARET] = ACTIONS(1),
    [anon_sym_AMP] = ACTIONS(1),
    [anon_sym_LT_LT] = ACTIONS(1),
    [anon_sym_GT_GT] = ACTIONS(1),
    [anon_sym_GT_GT_GT] = ACTIONS(1),
    [sym__additive_operator] = ACTIONS(1),
    [anon_sym_STAR] = ACTIONS(1),
    [anon_sym_SLASH] = ACTIONS(1),
    [anon_sym_PERCENT] = ACTIONS(1),
    [anon_sym_TILDE_SLASH] = ACTIONS(1),
    [sym_increment_operator] = ACTIONS(1),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(1),
    [sym_minus_operator] = ACTIONS(1),
    [sym__exclamation_operator] = ACTIONS(1),
    [anon_sym_TILDE] = ACTIONS(1),
    [anon_sym_await] = ACTIONS(1),
    [anon_sym_is] = ACTIONS(1),
    [anon_sym_as] = ACTIONS(1),
    [anon_sym_DOT] = ACTIONS(1),
    [anon_sym_QMARK_DOT] = ACTIONS(1),
    [anon_sym_DOT_DOT] = ACTIONS(1),
    [anon_sym_QMARK_DOT_DOT] = ACTIONS(1),
    [anon_sym_extends] = ACTIONS(1),
    [anon_sym_SEMI] = ACTIONS(1),
    [anon_sym_switch] = ACTIONS(1),
    [anon_sym_default] = ACTIONS(1),
    [anon_sym_do] = ACTIONS(1),
    [anon_sym_while] = ACTIONS(1),
    [anon_sym_continue] = ACTIONS(1),
    [anon_sym_yield] = ACTIONS(1),
    [anon_sym_return] = ACTIONS(1),
    [anon_sym_on] = ACTIONS(1),
    [anon_sym_try] = ACTIONS(1),
    [anon_sym_catch] = ACTIONS(1),
    [anon_sym_finally] = ACTIONS(1),
    [anon_sym_if] = ACTIONS(1),
    [anon_sym_else] = ACTIONS(1),
    [anon_sym_for] = ACTIONS(1),
    [anon_sym_in] = ACTIONS(1),
    [anon_sym_AT] = ACTIONS(1),
    [anon_sym_transitive] = ACTIONS(1),
    [anon_sym_part] = ACTIONS(1),
    [anon_sym_of] = ACTIONS(1),
    [anon_sym_EQ_EQ] = ACTIONS(1),
    [anon_sym_show] = ACTIONS(1),
    [anon_sym_hide] = ACTIONS(1),
    [anon_sym_enum] = ACTIONS(1),
    [anon_sym_abstract] = ACTIONS(1),
    [anon_sym_class] = ACTIONS(1),
    [anon_sym_extension] = ACTIONS(1),
    [anon_sym_with] = ACTIONS(1),
    [anon_sym_super] = ACTIONS(1),
    [sym_floating_point_type] = ACTIONS(1),
    [anon_sym_bool] = ACTIONS(1),
    [sym_void_type] = ACTIONS(1),
    [anon_sym_var] = ACTIONS(1),
    [anon_sym_async] = ACTIONS(1),
    [anon_sym_EQ_GT] = ACTIONS(1),
    [anon_sym_async_STAR] = ACTIONS(1),
    [anon_sym_sync_STAR] = ACTIONS(1),
    [anon_sym_throws] = ACTIONS(1),
    [anon_sym_POUND_BANG] = ACTIONS(1),
    [anon_sym_library] = ACTIONS(1),
    [sym__break_builtin] = ACTIONS(1),
    [sym__assert_builtin] = ACTIONS(1),
    [sym_case_builtin] = ACTIONS(1),
    [anon_sym_covariant] = ACTIONS(1),
    [anon_sym_deferred] = ACTIONS(1),
    [anon_sym_dynamic] = ACTIONS(1),
    [anon_sym_export] = ACTIONS(1),
    [anon_sym_factory] = ACTIONS(1),
    [anon_sym_Function] = ACTIONS(1),
    [anon_sym_get] = ACTIONS(1),
    [anon_sym_native] = ACTIONS(1),
    [anon_sym_implements] = ACTIONS(1),
    [anon_sym_import] = ACTIONS(1),
    [anon_sym_interface] = ACTIONS(1),
    [anon_sym_operator] = ACTIONS(1),
    [anon_sym_mixin] = ACTIONS(1),
    [anon_sym_required] = ACTIONS(1),
    [anon_sym_set] = ACTIONS(1),
    [anon_sym_static] = ACTIONS(1),
    [anon_sym_typedef] = ACTIONS(1),
    [anon_sym_new] = ACTIONS(1),
    [sym_const_builtin] = ACTIONS(1),
    [sym_final_builtin] = ACTIONS(1),
    [anon_sym_late] = ACTIONS(1),
    [anon_sym_external] = ACTIONS(1),
    [anon_sym_this] = ACTIONS(1),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_SLASH_SLASH_SLASH] = ACTIONS(7),
    [sym__automatic_semicolon] = ACTIONS(1),
    [sym__template_chars_double] = ACTIONS(1),
    [sym__template_chars_single] = ACTIONS(1),
    [sym__template_chars_double_single] = ACTIONS(1),
    [sym__template_chars_single_single] = ACTIONS(1),
    [sym__template_chars_raw_slash] = ACTIONS(1),
    [sym__block_comment] = ACTIONS(9),
    [sym__documentation_block_comment] = ACTIONS(11),
  },
  [1] = {
    [sym_program] = STATE(2731),
    [sym__top_level_definition] = STATE(446),
    [sym__literal] = STATE(967),
    [sym_symbol_literal] = STATE(912),
    [sym_true] = STATE(912),
    [sym_false] = STATE(912),
    [sym_string_literal] = STATE(912),
    [sym__string_literal_double_quotes] = STATE(617),
    [sym__string_literal_single_quotes] = STATE(617),
    [sym__string_literal_double_quotes_multiple] = STATE(617),
    [sym__string_literal_single_quotes_multiple] = STATE(617),
    [sym__raw_string_literal_double_quotes] = STATE(617),
    [sym__raw_string_literal_single_quotes] = STATE(617),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(617),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(617),
    [sym_list_literal] = STATE(912),
    [sym_set_or_map_literal] = STATE(912),
    [sym_null_literal] = STATE(912),
    [sym__expression] = STATE(2450),
    [sym__real_expression] = STATE(670),
    [sym_throw_expression] = STATE(976),
    [sym_assignment_expression] = STATE(976),
    [sym_assignable_expression] = STATE(1582),
    [sym_lambda_expression] = STATE(494),
    [sym_function_expression] = STATE(967),
    [sym_if_null_expression] = STATE(1377),
    [sym_conditional_expression] = STATE(1377),
    [sym_logical_or_expression] = STATE(1377),
    [sym_logical_and_expression] = STATE(1377),
    [sym_equality_expression] = STATE(1377),
    [sym_type_cast_expression] = STATE(1377),
    [sym_type_test_expression] = STATE(1377),
    [sym_relational_expression] = STATE(1377),
    [sym_bitwise_or_expression] = STATE(1377),
    [sym_bitwise_xor_expression] = STATE(1377),
    [sym_bitwise_and_expression] = STATE(1377),
    [sym_shift_expression] = STATE(1377),
    [sym_additive_expression] = STATE(1377),
    [sym_multiplicative_expression] = STATE(1377),
    [sym__unary_expression] = STATE(1118),
    [sym_unary_expression] = STATE(1169),
    [sym__postfix_expression] = STATE(1169),
    [sym_postfix_expression] = STATE(1170),
    [sym_prefix_operator] = STATE(360),
    [sym_negation_operator] = STATE(1206),
    [sym_tilde_operator] = STATE(1188),
    [sym_await_expression] = STATE(1171),
    [sym_new_expression] = STATE(967),
    [sym_const_object_expression] = STATE(967),
    [sym__primary] = STATE(641),
    [sym_constructor_invocation] = STATE(638),
    [sym_type_arguments] = STATE(2454),
    [sym__statement] = STATE(532),
    [sym_local_function_declaration] = STATE(491),
    [sym_block] = STATE(488),
    [sym_expression_statement] = STATE(488),
    [sym_assert_statement] = STATE(488),
    [sym_assertion] = STATE(2726),
    [sym_switch_statement] = STATE(488),
    [sym_do_statement] = STATE(488),
    [sym_break_statement] = STATE(488),
    [sym_continue_statement] = STATE(488),
    [sym_yield_statement] = STATE(488),
    [sym_yield_each_statement] = STATE(488),
    [sym_return_statement] = STATE(488),
    [sym_try_statement] = STATE(488),
    [sym__try_head] = STATE(1927),
    [sym_if_statement] = STATE(488),
    [sym_while_statement] = STATE(488),
    [sym_for_statement] = STATE(488),
    [sym__annotation] = STATE(1287),
    [sym_marker_annotation] = STATE(1289),
    [sym_annotation] = STATE(1289),
    [sym_import_or_export] = STATE(392),
    [sym_library_import] = STATE(393),
    [sym_library_export] = STATE(393),
    [sym_import_specification] = STATE(394),
    [sym_part_directive] = STATE(405),
    [sym_part_of_directive] = STATE(406),
    [sym_enum_declaration] = STATE(466),
    [sym_type_alias] = STATE(466),
    [sym_class_definition] = STATE(466),
    [sym_extension_declaration] = STATE(466),
    [sym__metadata] = STATE(465),
    [sym_type_parameters] = STATE(2299),
    [sym_mixin_declaration] = STATE(466),
    [sym_getter_signature] = STATE(1770),
    [sym_setter_signature] = STATE(1770),
    [sym_initialized_variable_definition] = STATE(2472),
    [sym__declared_identifier] = STATE(2151),
    [sym__final_const_var_or_type] = STATE(2686),
    [sym__type] = STATE(1955),
    [sym__type_not_function] = STATE(1616),
    [sym__type_not_void_not_function] = STATE(1668),
    [sym_function_type] = STATE(1655),
    [aux_sym__function_type_tails] = STATE(1482),
    [sym__function_type_tail] = STATE(1568),
    [sym__type_name] = STATE(1722),
    [sym__var_or_type] = STATE(2325),
    [sym_inferred_type] = STATE(1644),
    [sym_function_signature] = STATE(1764),
    [sym__formal_parameter_part] = STATE(1915),
    [sym_formal_parameter_list] = STATE(1636),
    [sym__strict_formal_parameter_list] = STATE(1626),
    [sym_local_variable_declaration] = STATE(509),
    [sym_script_tag] = STATE(2),
    [sym_library_name] = STATE(3),
    [sym__covariant] = STATE(1552),
    [sym__export] = STATE(1508),
    [sym__function_builtin_identifier] = STATE(1424),
    [sym__get] = STATE(1952),
    [sym__import] = STATE(1507),
    [sym__mixin] = STATE(2576),
    [sym__set] = STATE(1892),
    [sym__typedef] = STATE(1699),
    [sym__new_builtin] = STATE(1701),
    [sym__late_builtin] = STATE(1621),
    [sym__external_builtin] = STATE(1573),
    [sym_this] = STATE(967),
    [sym_super] = STATE(1128),
    [sym_comment] = STATE(1),
    [sym_documentation_comment] = STATE(1),
    [aux_sym_program_repeat1] = STATE(4),
    [aux_sym_program_repeat2] = STATE(9),
    [aux_sym_program_repeat3] = STATE(13),
    [aux_sym_program_repeat4] = STATE(21),
    [aux_sym_program_repeat5] = STATE(43),
    [aux_sym_string_literal_repeat1] = STATE(473),
    [aux_sym__metadata_repeat1] = STATE(1143),
    [ts_builtin_sym_end] = ACTIONS(13),
    [sym_identifier] = ACTIONS(15),
    [anon_sym_POUND] = ACTIONS(17),
    [sym_decimal_integer_literal] = ACTIONS(19),
    [sym_hex_integer_literal] = ACTIONS(21),
    [sym_decimal_floating_point_literal] = ACTIONS(19),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(25),
    [anon_sym_DQUOTE] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_r_DQUOTE] = ACTIONS(35),
    [anon_sym_r_SQUOTE] = ACTIONS(37),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(39),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(43),
    [anon_sym_LBRACK] = ACTIONS(45),
    [anon_sym_null] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_LT] = ACTIONS(53),
    [sym_increment_operator] = ACTIONS(55),
    [sym_minus_operator] = ACTIONS(57),
    [sym__exclamation_operator] = ACTIONS(59),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_await] = ACTIONS(63),
    [anon_sym_switch] = ACTIONS(65),
    [anon_sym_do] = ACTIONS(67),
    [anon_sym_while] = ACTIONS(69),
    [anon_sym_continue] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [anon_sym_return] = ACTIONS(75),
    [anon_sym_try] = ACTIONS(77),
    [anon_sym_if] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_AT] = ACTIONS(83),
    [anon_sym_part] = ACTIONS(85),
    [anon_sym_enum] = ACTIONS(87),
    [anon_sym_abstract] = ACTIONS(89),
    [anon_sym_class] = ACTIONS(91),
    [anon_sym_extension] = ACTIONS(93),
    [anon_sym_super] = ACTIONS(95),
    [sym_void_type] = ACTIONS(97),
    [anon_sym_var] = ACTIONS(99),
    [anon_sym_POUND_BANG] = ACTIONS(101),
    [anon_sym_library] = ACTIONS(103),
    [sym__break_builtin] = ACTIONS(105),
    [sym__assert_builtin] = ACTIONS(107),
    [anon_sym_covariant] = ACTIONS(109),
    [anon_sym_export] = ACTIONS(111),
    [anon_sym_Function] = ACTIONS(113),
    [anon_sym_get] = ACTIONS(115),
    [anon_sym_import] = ACTIONS(117),
    [anon_sym_mixin] = ACTIONS(119),
    [anon_sym_set] = ACTIONS(121),
    [anon_sym_typedef] = ACTIONS(123),
    [anon_sym_new] = ACTIONS(125),
    [sym_const_builtin] = ACTIONS(127),
    [sym_final_builtin] = ACTIONS(129),
    [anon_sym_late] = ACTIONS(131),
    [anon_sym_external] = ACTIONS(133),
    [anon_sym_this] = ACTIONS(135),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_SLASH_SLASH_SLASH] = ACTIONS(7),
    [sym__block_comment] = ACTIONS(9),
    [sym__documentation_block_comment] = ACTIONS(11),
  },
  [2] = {
    [sym__top_level_definition] = STATE(446),
    [sym__literal] = STATE(967),
    [sym_symbol_literal] = STATE(912),
    [sym_true] = STATE(912),
    [sym_false] = STATE(912),
    [sym_string_literal] = STATE(912),
    [sym__string_literal_double_quotes] = STATE(617),
    [sym__string_literal_single_quotes] = STATE(617),
    [sym__string_literal_double_quotes_multiple] = STATE(617),
    [sym__string_literal_single_quotes_multiple] = STATE(617),
    [sym__raw_string_literal_double_quotes] = STATE(617),
    [sym__raw_string_literal_single_quotes] = STATE(617),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(617),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(617),
    [sym_list_literal] = STATE(912),
    [sym_set_or_map_literal] = STATE(912),
    [sym_null_literal] = STATE(912),
    [sym__expression] = STATE(2450),
    [sym__real_expression] = STATE(670),
    [sym_throw_expression] = STATE(976),
    [sym_assignment_expression] = STATE(976),
    [sym_assignable_expression] = STATE(1582),
    [sym_lambda_expression] = STATE(494),
    [sym_function_expression] = STATE(967),
    [sym_if_null_expression] = STATE(1377),
    [sym_conditional_expression] = STATE(1377),
    [sym_logical_or_expression] = STATE(1377),
    [sym_logical_and_expression] = STATE(1377),
    [sym_equality_expression] = STATE(1377),
    [sym_type_cast_expression] = STATE(1377),
    [sym_type_test_expression] = STATE(1377),
    [sym_relational_expression] = STATE(1377),
    [sym_bitwise_or_expression] = STATE(1377),
    [sym_bitwise_xor_expression] = STATE(1377),
    [sym_bitwise_and_expression] = STATE(1377),
    [sym_shift_expression] = STATE(1377),
    [sym_additive_expression] = STATE(1377),
    [sym_multiplicative_expression] = STATE(1377),
    [sym__unary_expression] = STATE(1118),
    [sym_unary_expression] = STATE(1169),
    [sym__postfix_expression] = STATE(1169),
    [sym_postfix_expression] = STATE(1170),
    [sym_prefix_operator] = STATE(360),
    [sym_negation_operator] = STATE(1206),
    [sym_tilde_operator] = STATE(1188),
    [sym_await_expression] = STATE(1171),
    [sym_new_expression] = STATE(967),
    [sym_const_object_expression] = STATE(967),
    [sym__primary] = STATE(641),
    [sym_constructor_invocation] = STATE(638),
    [sym_type_arguments] = STATE(2454),
    [sym__statement] = STATE(532),
    [sym_local_function_declaration] = STATE(491),
    [sym_block] = STATE(488),
    [sym_expression_statement] = STATE(488),
    [sym_assert_statement] = STATE(488),
    [sym_assertion] = STATE(2726),
    [sym_switch_statement] = STATE(488),
    [sym_do_statement] = STATE(488),
    [sym_break_statement] = STATE(488),
    [sym_continue_statement] = STATE(488),
    [sym_yield_statement] = STATE(488),
    [sym_yield_each_statement] = STATE(488),
    [sym_return_statement] = STATE(488),
    [sym_try_statement] = STATE(488),
    [sym__try_head] = STATE(1927),
    [sym_if_statement] = STATE(488),
    [sym_while_statement] = STATE(488),
    [sym_for_statement] = STATE(488),
    [sym__annotation] = STATE(1287),
    [sym_marker_annotation] = STATE(1289),
    [sym_annotation] = STATE(1289),
    [sym_import_or_export] = STATE(392),
    [sym_library_import] = STATE(393),
    [sym_library_export] = STATE(393),
    [sym_import_specification] = STATE(394),
    [sym_part_directive] = STATE(405),
    [sym_part_of_directive] = STATE(406),
    [sym_enum_declaration] = STATE(466),
    [sym_type_alias] = STATE(466),
    [sym_class_definition] = STATE(466),
    [sym_extension_declaration] = STATE(466),
    [sym__metadata] = STATE(465),
    [sym_type_parameters] = STATE(2299),
    [sym_mixin_declaration] = STATE(466),
    [sym_getter_signature] = STATE(1770),
    [sym_setter_signature] = STATE(1770),
    [sym_initialized_variable_definition] = STATE(2472),
    [sym__declared_identifier] = STATE(2151),
    [sym__final_const_var_or_type] = STATE(2686),
    [sym__type] = STATE(1955),
    [sym__type_not_function] = STATE(1616),
    [sym__type_not_void_not_function] = STATE(1668),
    [sym_function_type] = STATE(1655),
    [aux_sym__function_type_tails] = STATE(1482),
    [sym__function_type_tail] = STATE(1568),
    [sym__type_name] = STATE(1722),
    [sym__var_or_type] = STATE(2325),
    [sym_inferred_type] = STATE(1644),
    [sym_function_signature] = STATE(1764),
    [sym__formal_parameter_part] = STATE(1915),
    [sym_formal_parameter_list] = STATE(1636),
    [sym__strict_formal_parameter_list] = STATE(1626),
    [sym_local_variable_declaration] = STATE(509),
    [sym_library_name] = STATE(6),
    [sym__covariant] = STATE(1552),
    [sym__export] = STATE(1508),
    [sym__function_builtin_identifier] = STATE(1424),
    [sym__get] = STATE(1952),
    [sym__import] = STATE(1507),
    [sym__mixin] = STATE(2576),
    [sym__set] = STATE(1892),
    [sym__typedef] = STATE(1699),
    [sym__new_builtin] = STATE(1701),
    [sym__late_builtin] = STATE(1621),
    [sym__external_builtin] = STATE(1573),
    [sym_this] = STATE(967),
    [sym_super] = STATE(1128),
    [sym_comment] = STATE(2),
    [sym_documentation_comment] = STATE(2),
    [aux_sym_program_repeat1] = STATE(7),
    [aux_sym_program_repeat2] = STATE(10),
    [aux_sym_program_repeat3] = STATE(14),
    [aux_sym_program_repeat4] = STATE(19),
    [aux_sym_program_repeat5] = STATE(39),
    [aux_sym_string_literal_repeat1] = STATE(473),
    [aux_sym__metadata_repeat1] = STATE(1143),
    [ts_builtin_sym_end] = ACTIONS(137),
    [sym_identifier] = ACTIONS(15),
    [anon_sym_POUND] = ACTIONS(139),
    [sym_decimal_integer_literal] = ACTIONS(19),
    [sym_hex_integer_literal] = ACTIONS(21),
    [sym_decimal_floating_point_literal] = ACTIONS(19),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(25),
    [anon_sym_DQUOTE] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_r_DQUOTE] = ACTIONS(35),
    [anon_sym_r_SQUOTE] = ACTIONS(37),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(39),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(43),
    [anon_sym_LBRACK] = ACTIONS(45),
    [anon_sym_null] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_LT] = ACTIONS(53),
    [sym_increment_operator] = ACTIONS(55),
    [sym_minus_operator] = ACTIONS(57),
    [sym__exclamation_operator] = ACTIONS(59),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_await] = ACTIONS(63),
    [anon_sym_switch] = ACTIONS(65),
    [anon_sym_do] = ACTIONS(67),
    [anon_sym_while] = ACTIONS(69),
    [anon_sym_continue] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [anon_sym_return] = ACTIONS(75),
    [anon_sym_try] = ACTIONS(77),
    [anon_sym_if] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_AT] = ACTIONS(83),
    [anon_sym_part] = ACTIONS(85),
    [anon_sym_enum] = ACTIONS(87),
    [anon_sym_abstract] = ACTIONS(89),
    [anon_sym_class] = ACTIONS(91),
    [anon_sym_extension] = ACTIONS(93),
    [anon_sym_super] = ACTIONS(95),
    [sym_void_type] = ACTIONS(97),
    [anon_sym_var] = ACTIONS(99),
    [anon_sym_library] = ACTIONS(103),
    [sym__break_builtin] = ACTIONS(105),
    [sym__assert_builtin] = ACTIONS(107),
    [anon_sym_covariant] = ACTIONS(109),
    [anon_sym_export] = ACTIONS(111),
    [anon_sym_Function] = ACTIONS(113),
    [anon_sym_get] = ACTIONS(115),
    [anon_sym_import] = ACTIONS(117),
    [anon_sym_mixin] = ACTIONS(119),
    [anon_sym_set] = ACTIONS(121),
    [anon_sym_typedef] = ACTIONS(123),
    [anon_sym_new] = ACTIONS(125),
    [sym_const_builtin] = ACTIONS(127),
    [sym_final_builtin] = ACTIONS(129),
    [anon_sym_late] = ACTIONS(131),
    [anon_sym_external] = ACTIONS(133),
    [anon_sym_this] = ACTIONS(135),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_SLASH_SLASH_SLASH] = ACTIONS(7),
    [sym__block_comment] = ACTIONS(9),
    [sym__documentation_block_comment] = ACTIONS(11),
  },
  [3] = {
    [sym__top_level_definition] = STATE(446),
    [sym__literal] = STATE(967),
    [sym_symbol_literal] = STATE(912),
    [sym_true] = STATE(912),
    [sym_false] = STATE(912),
    [sym_string_literal] = STATE(912),
    [sym__string_literal_double_quotes] = STATE(617),
    [sym__string_literal_single_quotes] = STATE(617),
    [sym__string_literal_double_quotes_multiple] = STATE(617),
    [sym__string_literal_single_quotes_multiple] = STATE(617),
    [sym__raw_string_literal_double_quotes] = STATE(617),
    [sym__raw_string_literal_single_quotes] = STATE(617),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(617),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(617),
    [sym_list_literal] = STATE(912),
    [sym_set_or_map_literal] = STATE(912),
    [sym_null_literal] = STATE(912),
    [sym__expression] = STATE(2450),
    [sym__real_expression] = STATE(670),
    [sym_throw_expression] = STATE(976),
    [sym_assignment_expression] = STATE(976),
    [sym_assignable_expression] = STATE(1582),
    [sym_lambda_expression] = STATE(494),
    [sym_function_expression] = STATE(967),
    [sym_if_null_expression] = STATE(1377),
    [sym_conditional_expression] = STATE(1377),
    [sym_logical_or_expression] = STATE(1377),
    [sym_logical_and_expression] = STATE(1377),
    [sym_equality_expression] = STATE(1377),
    [sym_type_cast_expression] = STATE(1377),
    [sym_type_test_expression] = STATE(1377),
    [sym_relational_expression] = STATE(1377),
    [sym_bitwise_or_expression] = STATE(1377),
    [sym_bitwise_xor_expression] = STATE(1377),
    [sym_bitwise_and_expression] = STATE(1377),
    [sym_shift_expression] = STATE(1377),
    [sym_additive_expression] = STATE(1377),
    [sym_multiplicative_expression] = STATE(1377),
    [sym__unary_expression] = STATE(1118),
    [sym_unary_expression] = STATE(1169),
    [sym__postfix_expression] = STATE(1169),
    [sym_postfix_expression] = STATE(1170),
    [sym_prefix_operator] = STATE(360),
    [sym_negation_operator] = STATE(1206),
    [sym_tilde_operator] = STATE(1188),
    [sym_await_expression] = STATE(1171),
    [sym_new_expression] = STATE(967),
    [sym_const_object_expression] = STATE(967),
    [sym__primary] = STATE(641),
    [sym_constructor_invocation] = STATE(638),
    [sym_type_arguments] = STATE(2454),
    [sym__statement] = STATE(532),
    [sym_local_function_declaration] = STATE(491),
    [sym_block] = STATE(488),
    [sym_expression_statement] = STATE(488),
    [sym_assert_statement] = STATE(488),
    [sym_assertion] = STATE(2726),
    [sym_switch_statement] = STATE(488),
    [sym_do_statement] = STATE(488),
    [sym_break_statement] = STATE(488),
    [sym_continue_statement] = STATE(488),
    [sym_yield_statement] = STATE(488),
    [sym_yield_each_statement] = STATE(488),
    [sym_return_statement] = STATE(488),
    [sym_try_statement] = STATE(488),
    [sym__try_head] = STATE(1927),
    [sym_if_statement] = STATE(488),
    [sym_while_statement] = STATE(488),
    [sym_for_statement] = STATE(488),
    [sym__annotation] = STATE(1287),
    [sym_marker_annotation] = STATE(1289),
    [sym_annotation] = STATE(1289),
    [sym_import_or_export] = STATE(392),
    [sym_library_import] = STATE(393),
    [sym_library_export] = STATE(393),
    [sym_import_specification] = STATE(394),
    [sym_part_directive] = STATE(405),
    [sym_part_of_directive] = STATE(406),
    [sym_enum_declaration] = STATE(466),
    [sym_type_alias] = STATE(466),
    [sym_class_definition] = STATE(466),
    [sym_extension_declaration] = STATE(466),
    [sym__metadata] = STATE(475),
    [sym_type_parameters] = STATE(2299),
    [sym_mixin_declaration] = STATE(466),
    [sym_getter_signature] = STATE(1770),
    [sym_setter_signature] = STATE(1770),
    [sym_initialized_variable_definition] = STATE(2472),
    [sym__declared_identifier] = STATE(2151),
    [sym__final_const_var_or_type] = STATE(2686),
    [sym__type] = STATE(1955),
    [sym__type_not_function] = STATE(1616),
    [sym__type_not_void_not_function] = STATE(1668),
    [sym_function_type] = STATE(1655),
    [aux_sym__function_type_tails] = STATE(1482),
    [sym__function_type_tail] = STATE(1568),
    [sym__type_name] = STATE(1722),
    [sym__var_or_type] = STATE(2325),
    [sym_inferred_type] = STATE(1644),
    [sym_function_signature] = STATE(1764),
    [sym__formal_parameter_part] = STATE(1915),
    [sym_formal_parameter_list] = STATE(1636),
    [sym__strict_formal_parameter_list] = STATE(1626),
    [sym_local_variable_declaration] = STATE(509),
    [sym__covariant] = STATE(1552),
    [sym__export] = STATE(1508),
    [sym__function_builtin_identifier] = STATE(1424),
    [sym__get] = STATE(1952),
    [sym__import] = STATE(1507),
    [sym__mixin] = STATE(2576),
    [sym__set] = STATE(1892),
    [sym__typedef] = STATE(1699),
    [sym__new_builtin] = STATE(1701),
    [sym__late_builtin] = STATE(1621),
    [sym__external_builtin] = STATE(1573),
    [sym_this] = STATE(967),
    [sym_super] = STATE(1128),
    [sym_comment] = STATE(3),
    [sym_documentation_comment] = STATE(3),
    [aux_sym_program_repeat1] = STATE(7),
    [aux_sym_program_repeat2] = STATE(10),
    [aux_sym_program_repeat3] = STATE(14),
    [aux_sym_program_repeat4] = STATE(19),
    [aux_sym_program_repeat5] = STATE(39),
    [aux_sym_string_literal_repeat1] = STATE(473),
    [aux_sym__metadata_repeat1] = STATE(1143),
    [ts_builtin_sym_end] = ACTIONS(137),
    [sym_identifier] = ACTIONS(15),
    [anon_sym_POUND] = ACTIONS(139),
    [sym_decimal_integer_literal] = ACTIONS(19),
    [sym_hex_integer_literal] = ACTIONS(21),
    [sym_decimal_floating_point_literal] = ACTIONS(19),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(25),
    [anon_sym_DQUOTE] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_r_DQUOTE] = ACTIONS(35),
    [anon_sym_r_SQUOTE] = ACTIONS(37),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(39),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(43),
    [anon_sym_LBRACK] = ACTIONS(45),
    [anon_sym_null] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_LT] = ACTIONS(53),
    [sym_increment_operator] = ACTIONS(55),
    [sym_minus_operator] = ACTIONS(57),
    [sym__exclamation_operator] = ACTIONS(59),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_await] = ACTIONS(63),
    [anon_sym_switch] = ACTIONS(65),
    [anon_sym_do] = ACTIONS(67),
    [anon_sym_while] = ACTIONS(69),
    [anon_sym_continue] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [anon_sym_return] = ACTIONS(75),
    [anon_sym_try] = ACTIONS(77),
    [anon_sym_if] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_AT] = ACTIONS(83),
    [anon_sym_part] = ACTIONS(85),
    [anon_sym_enum] = ACTIONS(87),
    [anon_sym_abstract] = ACTIONS(89),
    [anon_sym_class] = ACTIONS(91),
    [anon_sym_extension] = ACTIONS(93),
    [anon_sym_super] = ACTIONS(95),
    [sym_void_type] = ACTIONS(97),
    [anon_sym_var] = ACTIONS(99),
    [sym__break_builtin] = ACTIONS(105),
    [sym__assert_builtin] = ACTIONS(107),
    [anon_sym_covariant] = ACTIONS(109),
    [anon_sym_export] = ACTIONS(111),
    [anon_sym_Function] = ACTIONS(113),
    [anon_sym_get] = ACTIONS(115),
    [anon_sym_import] = ACTIONS(117),
    [anon_sym_mixin] = ACTIONS(119),
    [anon_sym_set] = ACTIONS(121),
    [anon_sym_typedef] = ACTIONS(123),
    [anon_sym_new] = ACTIONS(125),
    [sym_const_builtin] = ACTIONS(127),
    [sym_final_builtin] = ACTIONS(129),
    [anon_sym_late] = ACTIONS(131),
    [anon_sym_external] = ACTIONS(133),
    [anon_sym_this] = ACTIONS(135),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_SLASH_SLASH_SLASH] = ACTIONS(7),
    [sym__block_comment] = ACTIONS(9),
    [sym__documentation_block_comment] = ACTIONS(11),
  },
  [4] = {
    [sym__top_level_definition] = STATE(446),
    [sym__literal] = STATE(967),
    [sym_symbol_literal] = STATE(912),
    [sym_true] = STATE(912),
    [sym_false] = STATE(912),
    [sym_string_literal] = STATE(912),
    [sym__string_literal_double_quotes] = STATE(617),
    [sym__string_literal_single_quotes] = STATE(617),
    [sym__string_literal_double_quotes_multiple] = STATE(617),
    [sym__string_literal_single_quotes_multiple] = STATE(617),
    [sym__raw_string_literal_double_quotes] = STATE(617),
    [sym__raw_string_literal_single_quotes] = STATE(617),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(617),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(617),
    [sym_list_literal] = STATE(912),
    [sym_set_or_map_literal] = STATE(912),
    [sym_null_literal] = STATE(912),
    [sym__expression] = STATE(2450),
    [sym__real_expression] = STATE(670),
    [sym_throw_expression] = STATE(976),
    [sym_assignment_expression] = STATE(976),
    [sym_assignable_expression] = STATE(1582),
    [sym_lambda_expression] = STATE(494),
    [sym_function_expression] = STATE(967),
    [sym_if_null_expression] = STATE(1377),
    [sym_conditional_expression] = STATE(1377),
    [sym_logical_or_expression] = STATE(1377),
    [sym_logical_and_expression] = STATE(1377),
    [sym_equality_expression] = STATE(1377),
    [sym_type_cast_expression] = STATE(1377),
    [sym_type_test_expression] = STATE(1377),
    [sym_relational_expression] = STATE(1377),
    [sym_bitwise_or_expression] = STATE(1377),
    [sym_bitwise_xor_expression] = STATE(1377),
    [sym_bitwise_and_expression] = STATE(1377),
    [sym_shift_expression] = STATE(1377),
    [sym_additive_expression] = STATE(1377),
    [sym_multiplicative_expression] = STATE(1377),
    [sym__unary_expression] = STATE(1118),
    [sym_unary_expression] = STATE(1169),
    [sym__postfix_expression] = STATE(1169),
    [sym_postfix_expression] = STATE(1170),
    [sym_prefix_operator] = STATE(360),
    [sym_negation_operator] = STATE(1206),
    [sym_tilde_operator] = STATE(1188),
    [sym_await_expression] = STATE(1171),
    [sym_new_expression] = STATE(967),
    [sym_const_object_expression] = STATE(967),
    [sym__primary] = STATE(641),
    [sym_constructor_invocation] = STATE(638),
    [sym_type_arguments] = STATE(2454),
    [sym__statement] = STATE(532),
    [sym_local_function_declaration] = STATE(491),
    [sym_block] = STATE(488),
    [sym_expression_statement] = STATE(488),
    [sym_assert_statement] = STATE(488),
    [sym_assertion] = STATE(2726),
    [sym_switch_statement] = STATE(488),
    [sym_do_statement] = STATE(488),
    [sym_break_statement] = STATE(488),
    [sym_continue_statement] = STATE(488),
    [sym_yield_statement] = STATE(488),
    [sym_yield_each_statement] = STATE(488),
    [sym_return_statement] = STATE(488),
    [sym_try_statement] = STATE(488),
    [sym__try_head] = STATE(1927),
    [sym_if_statement] = STATE(488),
    [sym_while_statement] = STATE(488),
    [sym_for_statement] = STATE(488),
    [sym__annotation] = STATE(1287),
    [sym_marker_annotation] = STATE(1289),
    [sym_annotation] = STATE(1289),
    [sym_import_or_export] = STATE(392),
    [sym_library_import] = STATE(393),
    [sym_library_export] = STATE(393),
    [sym_import_specification] = STATE(394),
    [sym_part_directive] = STATE(405),
    [sym_part_of_directive] = STATE(406),
    [sym_enum_declaration] = STATE(466),
    [sym_type_alias] = STATE(466),
    [sym_class_definition] = STATE(466),
    [sym_extension_declaration] = STATE(466),
    [sym__metadata] = STATE(475),
    [sym_type_parameters] = STATE(2299),
    [sym_mixin_declaration] = STATE(466),
    [sym_getter_signature] = STATE(1770),
    [sym_setter_signature] = STATE(1770),
    [sym_initialized_variable_definition] = STATE(2472),
    [sym__declared_identifier] = STATE(2151),
    [sym__final_const_var_or_type] = STATE(2686),
    [sym__type] = STATE(1955),
    [sym__type_not_function] = STATE(1616),
    [sym__type_not_void_not_function] = STATE(1668),
    [sym_function_type] = STATE(1655),
    [aux_sym__function_type_tails] = STATE(1482),
    [sym__function_type_tail] = STATE(1568),
    [sym__type_name] = STATE(1722),
    [sym__var_or_type] = STATE(2325),
    [sym_inferred_type] = STATE(1644),
    [sym_function_signature] = STATE(1764),
    [sym__formal_parameter_part] = STATE(1915),
    [sym_formal_parameter_list] = STATE(1636),
    [sym__strict_formal_parameter_list] = STATE(1626),
    [sym_local_variable_declaration] = STATE(509),
    [sym__covariant] = STATE(1552),
    [sym__export] = STATE(1508),
    [sym__function_builtin_identifier] = STATE(1424),
    [sym__get] = STATE(1952),
    [sym__import] = STATE(1507),
    [sym__mixin] = STATE(2576),
    [sym__set] = STATE(1892),
    [sym__typedef] = STATE(1699),
    [sym__new_builtin] = STATE(1701),
    [sym__late_builtin] = STATE(1621),
    [sym__external_builtin] = STATE(1573),
    [sym_this] = STATE(967),
    [sym_super] = STATE(1128),
    [sym_comment] = STATE(4),
    [sym_documentation_comment] = STATE(4),
    [aux_sym_program_repeat1] = STATE(352),
    [aux_sym_program_repeat2] = STATE(10),
    [aux_sym_program_repeat3] = STATE(14),
    [aux_sym_program_repeat4] = STATE(19),
    [aux_sym_program_repeat5] = STATE(39),
    [aux_sym_string_literal_repeat1] = STATE(473),
    [aux_sym__metadata_repeat1] = STATE(1143),
    [ts_builtin_sym_end] = ACTIONS(137),
    [sym_identifier] = ACTIONS(15),
    [anon_sym_POUND] = ACTIONS(139),
    [sym_decimal_integer_literal] = ACTIONS(19),
    [sym_hex_integer_literal] = ACTIONS(21),
    [sym_decimal_floating_point_literal] = ACTIONS(19),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(25),
    [anon_sym_DQUOTE] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_r_DQUOTE] = ACTIONS(35),
    [anon_sym_r_SQUOTE] = ACTIONS(37),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(39),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(43),
    [anon_sym_LBRACK] = ACTIONS(45),
    [anon_sym_null] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_LT] = ACTIONS(53),
    [sym_increment_operator] = ACTIONS(55),
    [sym_minus_operator] = ACTIONS(57),
    [sym__exclamation_operator] = ACTIONS(59),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_await] = ACTIONS(63),
    [anon_sym_switch] = ACTIONS(65),
    [anon_sym_do] = ACTIONS(67),
    [anon_sym_while] = ACTIONS(69),
    [anon_sym_continue] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [anon_sym_return] = ACTIONS(75),
    [anon_sym_try] = ACTIONS(77),
    [anon_sym_if] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_AT] = ACTIONS(83),
    [anon_sym_part] = ACTIONS(85),
    [anon_sym_enum] = ACTIONS(87),
    [anon_sym_abstract] = ACTIONS(89),
    [anon_sym_class] = ACTIONS(91),
    [anon_sym_extension] = ACTIONS(93),
    [anon_sym_super] = ACTIONS(95),
    [sym_void_type] = ACTIONS(97),
    [anon_sym_var] = ACTIONS(99),
    [sym__break_builtin] = ACTIONS(105),
    [sym__assert_builtin] = ACTIONS(107),
    [anon_sym_covariant] = ACTIONS(109),
    [anon_sym_export] = ACTIONS(111),
    [anon_sym_Function] = ACTIONS(113),
    [anon_sym_get] = ACTIONS(115),
    [anon_sym_import] = ACTIONS(117),
    [anon_sym_mixin] = ACTIONS(119),
    [anon_sym_set] = ACTIONS(121),
    [anon_sym_typedef] = ACTIONS(123),
    [anon_sym_new] = ACTIONS(125),
    [sym_const_builtin] = ACTIONS(127),
    [sym_final_builtin] = ACTIONS(129),
    [anon_sym_late] = ACTIONS(131),
    [anon_sym_external] = ACTIONS(133),
    [anon_sym_this] = ACTIONS(135),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_SLASH_SLASH_SLASH] = ACTIONS(7),
    [sym__block_comment] = ACTIONS(9),
    [sym__documentation_block_comment] = ACTIONS(11),
  },
  [5] = {
    [sym__top_level_definition] = STATE(446),
    [sym__literal] = STATE(967),
    [sym_symbol_literal] = STATE(912),
    [sym_true] = STATE(912),
    [sym_false] = STATE(912),
    [sym_string_literal] = STATE(912),
    [sym__string_literal_double_quotes] = STATE(617),
    [sym__string_literal_single_quotes] = STATE(617),
    [sym__string_literal_double_quotes_multiple] = STATE(617),
    [sym__string_literal_single_quotes_multiple] = STATE(617),
    [sym__raw_string_literal_double_quotes] = STATE(617),
    [sym__raw_string_literal_single_quotes] = STATE(617),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(617),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(617),
    [sym_list_literal] = STATE(912),
    [sym_set_or_map_literal] = STATE(912),
    [sym_null_literal] = STATE(912),
    [sym__expression] = STATE(2450),
    [sym__real_expression] = STATE(670),
    [sym_throw_expression] = STATE(976),
    [sym_assignment_expression] = STATE(976),
    [sym_assignable_expression] = STATE(1582),
    [sym_lambda_expression] = STATE(494),
    [sym_function_expression] = STATE(967),
    [sym_if_null_expression] = STATE(1377),
    [sym_conditional_expression] = STATE(1377),
    [sym_logical_or_expression] = STATE(1377),
    [sym_logical_and_expression] = STATE(1377),
    [sym_equality_expression] = STATE(1377),
    [sym_type_cast_expression] = STATE(1377),
    [sym_type_test_expression] = STATE(1377),
    [sym_relational_expression] = STATE(1377),
    [sym_bitwise_or_expression] = STATE(1377),
    [sym_bitwise_xor_expression] = STATE(1377),
    [sym_bitwise_and_expression] = STATE(1377),
    [sym_shift_expression] = STATE(1377),
    [sym_additive_expression] = STATE(1377),
    [sym_multiplicative_expression] = STATE(1377),
    [sym__unary_expression] = STATE(1118),
    [sym_unary_expression] = STATE(1169),
    [sym__postfix_expression] = STATE(1169),
    [sym_postfix_expression] = STATE(1170),
    [sym_prefix_operator] = STATE(360),
    [sym_negation_operator] = STATE(1206),
    [sym_tilde_operator] = STATE(1188),
    [sym_await_expression] = STATE(1171),
    [sym_new_expression] = STATE(967),
    [sym_const_object_expression] = STATE(967),
    [sym__primary] = STATE(641),
    [sym_constructor_invocation] = STATE(638),
    [sym_type_arguments] = STATE(2454),
    [sym__statement] = STATE(532),
    [sym_local_function_declaration] = STATE(491),
    [sym_block] = STATE(488),
    [sym_expression_statement] = STATE(488),
    [sym_assert_statement] = STATE(488),
    [sym_assertion] = STATE(2726),
    [sym_switch_statement] = STATE(488),
    [sym_do_statement] = STATE(488),
    [sym_break_statement] = STATE(488),
    [sym_continue_statement] = STATE(488),
    [sym_yield_statement] = STATE(488),
    [sym_yield_each_statement] = STATE(488),
    [sym_return_statement] = STATE(488),
    [sym_try_statement] = STATE(488),
    [sym__try_head] = STATE(1927),
    [sym_if_statement] = STATE(488),
    [sym_while_statement] = STATE(488),
    [sym_for_statement] = STATE(488),
    [sym__annotation] = STATE(1287),
    [sym_marker_annotation] = STATE(1289),
    [sym_annotation] = STATE(1289),
    [sym_import_or_export] = STATE(392),
    [sym_library_import] = STATE(393),
    [sym_library_export] = STATE(393),
    [sym_import_specification] = STATE(394),
    [sym_part_directive] = STATE(405),
    [sym_part_of_directive] = STATE(406),
    [sym_enum_declaration] = STATE(466),
    [sym_type_alias] = STATE(466),
    [sym_class_definition] = STATE(466),
    [sym_extension_declaration] = STATE(466),
    [sym__metadata] = STATE(475),
    [sym_type_parameters] = STATE(2299),
    [sym_mixin_declaration] = STATE(466),
    [sym_getter_signature] = STATE(1770),
    [sym_setter_signature] = STATE(1770),
    [sym_initialized_variable_definition] = STATE(2472),
    [sym__declared_identifier] = STATE(2151),
    [sym__final_const_var_or_type] = STATE(2686),
    [sym__type] = STATE(1955),
    [sym__type_not_function] = STATE(1616),
    [sym__type_not_void_not_function] = STATE(1668),
    [sym_function_type] = STATE(1655),
    [aux_sym__function_type_tails] = STATE(1482),
    [sym__function_type_tail] = STATE(1568),
    [sym__type_name] = STATE(1722),
    [sym__var_or_type] = STATE(2325),
    [sym_inferred_type] = STATE(1644),
    [sym_function_signature] = STATE(1764),
    [sym__formal_parameter_part] = STATE(1915),
    [sym_formal_parameter_list] = STATE(1636),
    [sym__strict_formal_parameter_list] = STATE(1626),
    [sym_local_variable_declaration] = STATE(509),
    [sym__covariant] = STATE(1552),
    [sym__export] = STATE(1508),
    [sym__function_builtin_identifier] = STATE(1424),
    [sym__get] = STATE(1952),
    [sym__import] = STATE(1507),
    [sym__mixin] = STATE(2576),
    [sym__set] = STATE(1892),
    [sym__typedef] = STATE(1699),
    [sym__new_builtin] = STATE(1701),
    [sym__late_builtin] = STATE(1621),
    [sym__external_builtin] = STATE(1573),
    [sym_this] = STATE(967),
    [sym_super] = STATE(1128),
    [sym_comment] = STATE(5),
    [sym_documentation_comment] = STATE(5),
    [aux_sym_program_repeat1] = STATE(352),
    [aux_sym_program_repeat2] = STATE(8),
    [aux_sym_program_repeat3] = STATE(12),
    [aux_sym_program_repeat4] = STATE(20),
    [aux_sym_program_repeat5] = STATE(54),
    [aux_sym_string_literal_repeat1] = STATE(473),
    [aux_sym__metadata_repeat1] = STATE(1143),
    [ts_builtin_sym_end] = ACTIONS(141),
    [sym_identifier] = ACTIONS(15),
    [anon_sym_POUND] = ACTIONS(139),
    [sym_decimal_integer_literal] = ACTIONS(19),
    [sym_hex_integer_literal] = ACTIONS(21),
    [sym_decimal_floating_point_literal] = ACTIONS(19),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(25),
    [anon_sym_DQUOTE] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_r_DQUOTE] = ACTIONS(35),
    [anon_sym_r_SQUOTE] = ACTIONS(37),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(39),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(43),
    [anon_sym_LBRACK] = ACTIONS(45),
    [anon_sym_null] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_LT] = ACTIONS(53),
    [sym_increment_operator] = ACTIONS(55),
    [sym_minus_operator] = ACTIONS(57),
    [sym__exclamation_operator] = ACTIONS(59),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_await] = ACTIONS(63),
    [anon_sym_switch] = ACTIONS(65),
    [anon_sym_do] = ACTIONS(67),
    [anon_sym_while] = ACTIONS(69),
    [anon_sym_continue] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [anon_sym_return] = ACTIONS(75),
    [anon_sym_try] = ACTIONS(77),
    [anon_sym_if] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_AT] = ACTIONS(83),
    [anon_sym_part] = ACTIONS(85),
    [anon_sym_enum] = ACTIONS(87),
    [anon_sym_abstract] = ACTIONS(89),
    [anon_sym_class] = ACTIONS(91),
    [anon_sym_extension] = ACTIONS(93),
    [anon_sym_super] = ACTIONS(95),
    [sym_void_type] = ACTIONS(97),
    [anon_sym_var] = ACTIONS(99),
    [sym__break_builtin] = ACTIONS(105),
    [sym__assert_builtin] = ACTIONS(107),
    [anon_sym_covariant] = ACTIONS(109),
    [anon_sym_export] = ACTIONS(111),
    [anon_sym_Function] = ACTIONS(113),
    [anon_sym_get] = ACTIONS(115),
    [anon_sym_import] = ACTIONS(117),
    [anon_sym_mixin] = ACTIONS(119),
    [anon_sym_set] = ACTIONS(121),
    [anon_sym_typedef] = ACTIONS(123),
    [anon_sym_new] = ACTIONS(125),
    [sym_const_builtin] = ACTIONS(127),
    [sym_final_builtin] = ACTIONS(129),
    [anon_sym_late] = ACTIONS(131),
    [anon_sym_external] = ACTIONS(133),
    [anon_sym_this] = ACTIONS(135),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_SLASH_SLASH_SLASH] = ACTIONS(7),
    [sym__block_comment] = ACTIONS(9),
    [sym__documentation_block_comment] = ACTIONS(11),
  },
  [6] = {
    [sym__top_level_definition] = STATE(446),
    [sym__literal] = STATE(967),
    [sym_symbol_literal] = STATE(912),
    [sym_true] = STATE(912),
    [sym_false] = STATE(912),
    [sym_string_literal] = STATE(912),
    [sym__string_literal_double_quotes] = STATE(617),
    [sym__string_literal_single_quotes] = STATE(617),
    [sym__string_literal_double_quotes_multiple] = STATE(617),
    [sym__string_literal_single_quotes_multiple] = STATE(617),
    [sym__raw_string_literal_double_quotes] = STATE(617),
    [sym__raw_string_literal_single_quotes] = STATE(617),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(617),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(617),
    [sym_list_literal] = STATE(912),
    [sym_set_or_map_literal] = STATE(912),
    [sym_null_literal] = STATE(912),
    [sym__expression] = STATE(2450),
    [sym__real_expression] = STATE(670),
    [sym_throw_expression] = STATE(976),
    [sym_assignment_expression] = STATE(976),
    [sym_assignable_expression] = STATE(1582),
    [sym_lambda_expression] = STATE(494),
    [sym_function_expression] = STATE(967),
    [sym_if_null_expression] = STATE(1377),
    [sym_conditional_expression] = STATE(1377),
    [sym_logical_or_expression] = STATE(1377),
    [sym_logical_and_expression] = STATE(1377),
    [sym_equality_expression] = STATE(1377),
    [sym_type_cast_expression] = STATE(1377),
    [sym_type_test_expression] = STATE(1377),
    [sym_relational_expression] = STATE(1377),
    [sym_bitwise_or_expression] = STATE(1377),
    [sym_bitwise_xor_expression] = STATE(1377),
    [sym_bitwise_and_expression] = STATE(1377),
    [sym_shift_expression] = STATE(1377),
    [sym_additive_expression] = STATE(1377),
    [sym_multiplicative_expression] = STATE(1377),
    [sym__unary_expression] = STATE(1118),
    [sym_unary_expression] = STATE(1169),
    [sym__postfix_expression] = STATE(1169),
    [sym_postfix_expression] = STATE(1170),
    [sym_prefix_operator] = STATE(360),
    [sym_negation_operator] = STATE(1206),
    [sym_tilde_operator] = STATE(1188),
    [sym_await_expression] = STATE(1171),
    [sym_new_expression] = STATE(967),
    [sym_const_object_expression] = STATE(967),
    [sym__primary] = STATE(641),
    [sym_constructor_invocation] = STATE(638),
    [sym_type_arguments] = STATE(2454),
    [sym__statement] = STATE(532),
    [sym_local_function_declaration] = STATE(491),
    [sym_block] = STATE(488),
    [sym_expression_statement] = STATE(488),
    [sym_assert_statement] = STATE(488),
    [sym_assertion] = STATE(2726),
    [sym_switch_statement] = STATE(488),
    [sym_do_statement] = STATE(488),
    [sym_break_statement] = STATE(488),
    [sym_continue_statement] = STATE(488),
    [sym_yield_statement] = STATE(488),
    [sym_yield_each_statement] = STATE(488),
    [sym_return_statement] = STATE(488),
    [sym_try_statement] = STATE(488),
    [sym__try_head] = STATE(1927),
    [sym_if_statement] = STATE(488),
    [sym_while_statement] = STATE(488),
    [sym_for_statement] = STATE(488),
    [sym__annotation] = STATE(1287),
    [sym_marker_annotation] = STATE(1289),
    [sym_annotation] = STATE(1289),
    [sym_import_or_export] = STATE(392),
    [sym_library_import] = STATE(393),
    [sym_library_export] = STATE(393),
    [sym_import_specification] = STATE(394),
    [sym_part_directive] = STATE(405),
    [sym_part_of_directive] = STATE(406),
    [sym_enum_declaration] = STATE(466),
    [sym_type_alias] = STATE(466),
    [sym_class_definition] = STATE(466),
    [sym_extension_declaration] = STATE(466),
    [sym__metadata] = STATE(475),
    [sym_type_parameters] = STATE(2299),
    [sym_mixin_declaration] = STATE(466),
    [sym_getter_signature] = STATE(1770),
    [sym_setter_signature] = STATE(1770),
    [sym_initialized_variable_definition] = STATE(2472),
    [sym__declared_identifier] = STATE(2151),
    [sym__final_const_var_or_type] = STATE(2686),
    [sym__type] = STATE(1955),
    [sym__type_not_function] = STATE(1616),
    [sym__type_not_void_not_function] = STATE(1668),
    [sym_function_type] = STATE(1655),
    [aux_sym__function_type_tails] = STATE(1482),
    [sym__function_type_tail] = STATE(1568),
    [sym__type_name] = STATE(1722),
    [sym__var_or_type] = STATE(2325),
    [sym_inferred_type] = STATE(1644),
    [sym_function_signature] = STATE(1764),
    [sym__formal_parameter_part] = STATE(1915),
    [sym_formal_parameter_list] = STATE(1636),
    [sym__strict_formal_parameter_list] = STATE(1626),
    [sym_local_variable_declaration] = STATE(509),
    [sym__covariant] = STATE(1552),
    [sym__export] = STATE(1508),
    [sym__function_builtin_identifier] = STATE(1424),
    [sym__get] = STATE(1952),
    [sym__import] = STATE(1507),
    [sym__mixin] = STATE(2576),
    [sym__set] = STATE(1892),
    [sym__typedef] = STATE(1699),
    [sym__new_builtin] = STATE(1701),
    [sym__late_builtin] = STATE(1621),
    [sym__external_builtin] = STATE(1573),
    [sym_this] = STATE(967),
    [sym_super] = STATE(1128),
    [sym_comment] = STATE(6),
    [sym_documentation_comment] = STATE(6),
    [aux_sym_program_repeat1] = STATE(5),
    [aux_sym_program_repeat2] = STATE(11),
    [aux_sym_program_repeat3] = STATE(15),
    [aux_sym_program_repeat4] = STATE(17),
    [aux_sym_program_repeat5] = STATE(51),
    [aux_sym_string_literal_repeat1] = STATE(473),
    [aux_sym__metadata_repeat1] = STATE(1143),
    [ts_builtin_sym_end] = ACTIONS(143),
    [sym_identifier] = ACTIONS(15),
    [anon_sym_POUND] = ACTIONS(139),
    [sym_decimal_integer_literal] = ACTIONS(19),
    [sym_hex_integer_literal] = ACTIONS(21),
    [sym_decimal_floating_point_literal] = ACTIONS(19),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(25),
    [anon_sym_DQUOTE] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_r_DQUOTE] = ACTIONS(35),
    [anon_sym_r_SQUOTE] = ACTIONS(37),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(39),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(43),
    [anon_sym_LBRACK] = ACTIONS(45),
    [anon_sym_null] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_LT] = ACTIONS(53),
    [sym_increment_operator] = ACTIONS(55),
    [sym_minus_operator] = ACTIONS(57),
    [sym__exclamation_operator] = ACTIONS(59),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_await] = ACTIONS(63),
    [anon_sym_switch] = ACTIONS(65),
    [anon_sym_do] = ACTIONS(67),
    [anon_sym_while] = ACTIONS(69),
    [anon_sym_continue] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [anon_sym_return] = ACTIONS(75),
    [anon_sym_try] = ACTIONS(77),
    [anon_sym_if] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_AT] = ACTIONS(83),
    [anon_sym_part] = ACTIONS(85),
    [anon_sym_enum] = ACTIONS(87),
    [anon_sym_abstract] = ACTIONS(89),
    [anon_sym_class] = ACTIONS(91),
    [anon_sym_extension] = ACTIONS(93),
    [anon_sym_super] = ACTIONS(95),
    [sym_void_type] = ACTIONS(97),
    [anon_sym_var] = ACTIONS(99),
    [sym__break_builtin] = ACTIONS(105),
    [sym__assert_builtin] = ACTIONS(107),
    [anon_sym_covariant] = ACTIONS(109),
    [anon_sym_export] = ACTIONS(111),
    [anon_sym_Function] = ACTIONS(113),
    [anon_sym_get] = ACTIONS(115),
    [anon_sym_import] = ACTIONS(117),
    [anon_sym_mixin] = ACTIONS(119),
    [anon_sym_set] = ACTIONS(121),
    [anon_sym_typedef] = ACTIONS(123),
    [anon_sym_new] = ACTIONS(125),
    [sym_const_builtin] = ACTIONS(127),
    [sym_final_builtin] = ACTIONS(129),
    [anon_sym_late] = ACTIONS(131),
    [anon_sym_external] = ACTIONS(133),
    [anon_sym_this] = ACTIONS(135),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_SLASH_SLASH_SLASH] = ACTIONS(7),
    [sym__block_comment] = ACTIONS(9),
    [sym__documentation_block_comment] = ACTIONS(11),
  },
  [7] = {
    [sym__top_level_definition] = STATE(446),
    [sym__literal] = STATE(967),
    [sym_symbol_literal] = STATE(912),
    [sym_true] = STATE(912),
    [sym_false] = STATE(912),
    [sym_string_literal] = STATE(912),
    [sym__string_literal_double_quotes] = STATE(617),
    [sym__string_literal_single_quotes] = STATE(617),
    [sym__string_literal_double_quotes_multiple] = STATE(617),
    [sym__string_literal_single_quotes_multiple] = STATE(617),
    [sym__raw_string_literal_double_quotes] = STATE(617),
    [sym__raw_string_literal_single_quotes] = STATE(617),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(617),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(617),
    [sym_list_literal] = STATE(912),
    [sym_set_or_map_literal] = STATE(912),
    [sym_null_literal] = STATE(912),
    [sym__expression] = STATE(2450),
    [sym__real_expression] = STATE(670),
    [sym_throw_expression] = STATE(976),
    [sym_assignment_expression] = STATE(976),
    [sym_assignable_expression] = STATE(1582),
    [sym_lambda_expression] = STATE(494),
    [sym_function_expression] = STATE(967),
    [sym_if_null_expression] = STATE(1377),
    [sym_conditional_expression] = STATE(1377),
    [sym_logical_or_expression] = STATE(1377),
    [sym_logical_and_expression] = STATE(1377),
    [sym_equality_expression] = STATE(1377),
    [sym_type_cast_expression] = STATE(1377),
    [sym_type_test_expression] = STATE(1377),
    [sym_relational_expression] = STATE(1377),
    [sym_bitwise_or_expression] = STATE(1377),
    [sym_bitwise_xor_expression] = STATE(1377),
    [sym_bitwise_and_expression] = STATE(1377),
    [sym_shift_expression] = STATE(1377),
    [sym_additive_expression] = STATE(1377),
    [sym_multiplicative_expression] = STATE(1377),
    [sym__unary_expression] = STATE(1118),
    [sym_unary_expression] = STATE(1169),
    [sym__postfix_expression] = STATE(1169),
    [sym_postfix_expression] = STATE(1170),
    [sym_prefix_operator] = STATE(360),
    [sym_negation_operator] = STATE(1206),
    [sym_tilde_operator] = STATE(1188),
    [sym_await_expression] = STATE(1171),
    [sym_new_expression] = STATE(967),
    [sym_const_object_expression] = STATE(967),
    [sym__primary] = STATE(641),
    [sym_constructor_invocation] = STATE(638),
    [sym_type_arguments] = STATE(2454),
    [sym__statement] = STATE(532),
    [sym_local_function_declaration] = STATE(491),
    [sym_block] = STATE(488),
    [sym_expression_statement] = STATE(488),
    [sym_assert_statement] = STATE(488),
    [sym_assertion] = STATE(2726),
    [sym_switch_statement] = STATE(488),
    [sym_do_statement] = STATE(488),
    [sym_break_statement] = STATE(488),
    [sym_continue_statement] = STATE(488),
    [sym_yield_statement] = STATE(488),
    [sym_yield_each_statement] = STATE(488),
    [sym_return_statement] = STATE(488),
    [sym_try_statement] = STATE(488),
    [sym__try_head] = STATE(1927),
    [sym_if_statement] = STATE(488),
    [sym_while_statement] = STATE(488),
    [sym_for_statement] = STATE(488),
    [sym__annotation] = STATE(1287),
    [sym_marker_annotation] = STATE(1289),
    [sym_annotation] = STATE(1289),
    [sym_import_or_export] = STATE(392),
    [sym_library_import] = STATE(393),
    [sym_library_export] = STATE(393),
    [sym_import_specification] = STATE(394),
    [sym_part_directive] = STATE(405),
    [sym_part_of_directive] = STATE(406),
    [sym_enum_declaration] = STATE(466),
    [sym_type_alias] = STATE(466),
    [sym_class_definition] = STATE(466),
    [sym_extension_declaration] = STATE(466),
    [sym__metadata] = STATE(475),
    [sym_type_parameters] = STATE(2299),
    [sym_mixin_declaration] = STATE(466),
    [sym_getter_signature] = STATE(1770),
    [sym_setter_signature] = STATE(1770),
    [sym_initialized_variable_definition] = STATE(2472),
    [sym__declared_identifier] = STATE(2151),
    [sym__final_const_var_or_type] = STATE(2686),
    [sym__type] = STATE(1955),
    [sym__type_not_function] = STATE(1616),
    [sym__type_not_void_not_function] = STATE(1668),
    [sym_function_type] = STATE(1655),
    [aux_sym__function_type_tails] = STATE(1482),
    [sym__function_type_tail] = STATE(1568),
    [sym__type_name] = STATE(1722),
    [sym__var_or_type] = STATE(2325),
    [sym_inferred_type] = STATE(1644),
    [sym_function_signature] = STATE(1764),
    [sym__formal_parameter_part] = STATE(1915),
    [sym_formal_parameter_list] = STATE(1636),
    [sym__strict_formal_parameter_list] = STATE(1626),
    [sym_local_variable_declaration] = STATE(509),
    [sym__covariant] = STATE(1552),
    [sym__export] = STATE(1508),
    [sym__function_builtin_identifier] = STATE(1424),
    [sym__get] = STATE(1952),
    [sym__import] = STATE(1507),
    [sym__mixin] = STATE(2576),
    [sym__set] = STATE(1892),
    [sym__typedef] = STATE(1699),
    [sym__new_builtin] = STATE(1701),
    [sym__late_builtin] = STATE(1621),
    [sym__external_builtin] = STATE(1573),
    [sym_this] = STATE(967),
    [sym_super] = STATE(1128),
    [sym_comment] = STATE(7),
    [sym_documentation_comment] = STATE(7),
    [aux_sym_program_repeat1] = STATE(352),
    [aux_sym_program_repeat2] = STATE(11),
    [aux_sym_program_repeat3] = STATE(15),
    [aux_sym_program_repeat4] = STATE(17),
    [aux_sym_program_repeat5] = STATE(51),
    [aux_sym_string_literal_repeat1] = STATE(473),
    [aux_sym__metadata_repeat1] = STATE(1143),
    [ts_builtin_sym_end] = ACTIONS(143),
    [sym_identifier] = ACTIONS(15),
    [anon_sym_POUND] = ACTIONS(139),
    [sym_decimal_integer_literal] = ACTIONS(19),
    [sym_hex_integer_literal] = ACTIONS(21),
    [sym_decimal_floating_point_literal] = ACTIONS(19),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(25),
    [anon_sym_DQUOTE] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_r_DQUOTE] = ACTIONS(35),
    [anon_sym_r_SQUOTE] = ACTIONS(37),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(39),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(43),
    [anon_sym_LBRACK] = ACTIONS(45),
    [anon_sym_null] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_LT] = ACTIONS(53),
    [sym_increment_operator] = ACTIONS(55),
    [sym_minus_operator] = ACTIONS(57),
    [sym__exclamation_operator] = ACTIONS(59),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_await] = ACTIONS(63),
    [anon_sym_switch] = ACTIONS(65),
    [anon_sym_do] = ACTIONS(67),
    [anon_sym_while] = ACTIONS(69),
    [anon_sym_continue] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [anon_sym_return] = ACTIONS(75),
    [anon_sym_try] = ACTIONS(77),
    [anon_sym_if] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_AT] = ACTIONS(83),
    [anon_sym_part] = ACTIONS(85),
    [anon_sym_enum] = ACTIONS(87),
    [anon_sym_abstract] = ACTIONS(89),
    [anon_sym_class] = ACTIONS(91),
    [anon_sym_extension] = ACTIONS(93),
    [anon_sym_super] = ACTIONS(95),
    [sym_void_type] = ACTIONS(97),
    [anon_sym_var] = ACTIONS(99),
    [sym__break_builtin] = ACTIONS(105),
    [sym__assert_builtin] = ACTIONS(107),
    [anon_sym_covariant] = ACTIONS(109),
    [anon_sym_export] = ACTIONS(111),
    [anon_sym_Function] = ACTIONS(113),
    [anon_sym_get] = ACTIONS(115),
    [anon_sym_import] = ACTIONS(117),
    [anon_sym_mixin] = ACTIONS(119),
    [anon_sym_set] = ACTIONS(121),
    [anon_sym_typedef] = ACTIONS(123),
    [anon_sym_new] = ACTIONS(125),
    [sym_const_builtin] = ACTIONS(127),
    [sym_final_builtin] = ACTIONS(129),
    [anon_sym_late] = ACTIONS(131),
    [anon_sym_external] = ACTIONS(133),
    [anon_sym_this] = ACTIONS(135),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_SLASH_SLASH_SLASH] = ACTIONS(7),
    [sym__block_comment] = ACTIONS(9),
    [sym__documentation_block_comment] = ACTIONS(11),
  },
  [8] = {
    [sym__top_level_definition] = STATE(446),
    [sym__literal] = STATE(967),
    [sym_symbol_literal] = STATE(912),
    [sym_true] = STATE(912),
    [sym_false] = STATE(912),
    [sym_string_literal] = STATE(912),
    [sym__string_literal_double_quotes] = STATE(617),
    [sym__string_literal_single_quotes] = STATE(617),
    [sym__string_literal_double_quotes_multiple] = STATE(617),
    [sym__string_literal_single_quotes_multiple] = STATE(617),
    [sym__raw_string_literal_double_quotes] = STATE(617),
    [sym__raw_string_literal_single_quotes] = STATE(617),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(617),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(617),
    [sym_list_literal] = STATE(912),
    [sym_set_or_map_literal] = STATE(912),
    [sym_null_literal] = STATE(912),
    [sym__expression] = STATE(2450),
    [sym__real_expression] = STATE(670),
    [sym_throw_expression] = STATE(976),
    [sym_assignment_expression] = STATE(976),
    [sym_assignable_expression] = STATE(1582),
    [sym_lambda_expression] = STATE(494),
    [sym_function_expression] = STATE(967),
    [sym_if_null_expression] = STATE(1377),
    [sym_conditional_expression] = STATE(1377),
    [sym_logical_or_expression] = STATE(1377),
    [sym_logical_and_expression] = STATE(1377),
    [sym_equality_expression] = STATE(1377),
    [sym_type_cast_expression] = STATE(1377),
    [sym_type_test_expression] = STATE(1377),
    [sym_relational_expression] = STATE(1377),
    [sym_bitwise_or_expression] = STATE(1377),
    [sym_bitwise_xor_expression] = STATE(1377),
    [sym_bitwise_and_expression] = STATE(1377),
    [sym_shift_expression] = STATE(1377),
    [sym_additive_expression] = STATE(1377),
    [sym_multiplicative_expression] = STATE(1377),
    [sym__unary_expression] = STATE(1118),
    [sym_unary_expression] = STATE(1169),
    [sym__postfix_expression] = STATE(1169),
    [sym_postfix_expression] = STATE(1170),
    [sym_prefix_operator] = STATE(360),
    [sym_negation_operator] = STATE(1206),
    [sym_tilde_operator] = STATE(1188),
    [sym_await_expression] = STATE(1171),
    [sym_new_expression] = STATE(967),
    [sym_const_object_expression] = STATE(967),
    [sym__primary] = STATE(641),
    [sym_constructor_invocation] = STATE(638),
    [sym_type_arguments] = STATE(2454),
    [sym__statement] = STATE(532),
    [sym_local_function_declaration] = STATE(491),
    [sym_block] = STATE(488),
    [sym_expression_statement] = STATE(488),
    [sym_assert_statement] = STATE(488),
    [sym_assertion] = STATE(2726),
    [sym_switch_statement] = STATE(488),
    [sym_do_statement] = STATE(488),
    [sym_break_statement] = STATE(488),
    [sym_continue_statement] = STATE(488),
    [sym_yield_statement] = STATE(488),
    [sym_yield_each_statement] = STATE(488),
    [sym_return_statement] = STATE(488),
    [sym_try_statement] = STATE(488),
    [sym__try_head] = STATE(1927),
    [sym_if_statement] = STATE(488),
    [sym_while_statement] = STATE(488),
    [sym_for_statement] = STATE(488),
    [sym__annotation] = STATE(1287),
    [sym_marker_annotation] = STATE(1289),
    [sym_annotation] = STATE(1289),
    [sym_part_directive] = STATE(405),
    [sym_part_of_directive] = STATE(406),
    [sym_enum_declaration] = STATE(466),
    [sym_type_alias] = STATE(466),
    [sym_class_definition] = STATE(466),
    [sym_extension_declaration] = STATE(466),
    [sym__metadata] = STATE(542),
    [sym_type_parameters] = STATE(2299),
    [sym_mixin_declaration] = STATE(466),
    [sym_getter_signature] = STATE(1770),
    [sym_setter_signature] = STATE(1770),
    [sym_initialized_variable_definition] = STATE(2472),
    [sym__declared_identifier] = STATE(2151),
    [sym__final_const_var_or_type] = STATE(2686),
    [sym__type] = STATE(1955),
    [sym__type_not_function] = STATE(1616),
    [sym__type_not_void_not_function] = STATE(1668),
    [sym_function_type] = STATE(1655),
    [aux_sym__function_type_tails] = STATE(1482),
    [sym__function_type_tail] = STATE(1568),
    [sym__type_name] = STATE(1722),
    [sym__var_or_type] = STATE(2325),
    [sym_inferred_type] = STATE(1644),
    [sym_function_signature] = STATE(1764),
    [sym__formal_parameter_part] = STATE(1915),
    [sym_formal_parameter_list] = STATE(1636),
    [sym__strict_formal_parameter_list] = STATE(1626),
    [sym_local_variable_declaration] = STATE(509),
    [sym__covariant] = STATE(1552),
    [sym__function_builtin_identifier] = STATE(1424),
    [sym__get] = STATE(1952),
    [sym__mixin] = STATE(2576),
    [sym__set] = STATE(1892),
    [sym__typedef] = STATE(1699),
    [sym__new_builtin] = STATE(1701),
    [sym__late_builtin] = STATE(1621),
    [sym__external_builtin] = STATE(1573),
    [sym_this] = STATE(967),
    [sym_super] = STATE(1128),
    [sym_comment] = STATE(8),
    [sym_documentation_comment] = STATE(8),
    [aux_sym_program_repeat2] = STATE(377),
    [aux_sym_program_repeat3] = STATE(16),
    [aux_sym_program_repeat4] = STATE(18),
    [aux_sym_program_repeat5] = STATE(47),
    [aux_sym_string_literal_repeat1] = STATE(473),
    [aux_sym__metadata_repeat1] = STATE(1143),
    [ts_builtin_sym_end] = ACTIONS(145),
    [sym_identifier] = ACTIONS(15),
    [anon_sym_POUND] = ACTIONS(139),
    [sym_decimal_integer_literal] = ACTIONS(19),
    [sym_hex_integer_literal] = ACTIONS(21),
    [sym_decimal_floating_point_literal] = ACTIONS(19),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(25),
    [anon_sym_DQUOTE] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_r_DQUOTE] = ACTIONS(35),
    [anon_sym_r_SQUOTE] = ACTIONS(37),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(39),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(43),
    [anon_sym_LBRACK] = ACTIONS(45),
    [anon_sym_null] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_LT] = ACTIONS(53),
    [sym_increment_operator] = ACTIONS(55),
    [sym_minus_operator] = ACTIONS(57),
    [sym__exclamation_operator] = ACTIONS(59),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_await] = ACTIONS(63),
    [anon_sym_switch] = ACTIONS(65),
    [anon_sym_do] = ACTIONS(67),
    [anon_sym_while] = ACTIONS(69),
    [anon_sym_continue] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [anon_sym_return] = ACTIONS(75),
    [anon_sym_try] = ACTIONS(77),
    [anon_sym_if] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_AT] = ACTIONS(83),
    [anon_sym_part] = ACTIONS(85),
    [anon_sym_enum] = ACTIONS(87),
    [anon_sym_abstract] = ACTIONS(89),
    [anon_sym_class] = ACTIONS(91),
    [anon_sym_extension] = ACTIONS(93),
    [anon_sym_super] = ACTIONS(95),
    [sym_void_type] = ACTIONS(97),
    [anon_sym_var] = ACTIONS(99),
    [sym__break_builtin] = ACTIONS(105),
    [sym__assert_builtin] = ACTIONS(107),
    [anon_sym_covariant] = ACTIONS(109),
    [anon_sym_Function] = ACTIONS(113),
    [anon_sym_get] = ACTIONS(115),
    [anon_sym_mixin] = ACTIONS(119),
    [anon_sym_set] = ACTIONS(121),
    [anon_sym_typedef] = ACTIONS(123),
    [anon_sym_new] = ACTIONS(125),
    [sym_const_builtin] = ACTIONS(127),
    [sym_final_builtin] = ACTIONS(129),
    [anon_sym_late] = ACTIONS(131),
    [anon_sym_external] = ACTIONS(133),
    [anon_sym_this] = ACTIONS(135),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_SLASH_SLASH_SLASH] = ACTIONS(7),
    [sym__block_comment] = ACTIONS(9),
    [sym__documentation_block_comment] = ACTIONS(11),
  },
  [9] = {
    [sym__top_level_definition] = STATE(446),
    [sym__literal] = STATE(967),
    [sym_symbol_literal] = STATE(912),
    [sym_true] = STATE(912),
    [sym_false] = STATE(912),
    [sym_string_literal] = STATE(912),
    [sym__string_literal_double_quotes] = STATE(617),
    [sym__string_literal_single_quotes] = STATE(617),
    [sym__string_literal_double_quotes_multiple] = STATE(617),
    [sym__string_literal_single_quotes_multiple] = STATE(617),
    [sym__raw_string_literal_double_quotes] = STATE(617),
    [sym__raw_string_literal_single_quotes] = STATE(617),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(617),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(617),
    [sym_list_literal] = STATE(912),
    [sym_set_or_map_literal] = STATE(912),
    [sym_null_literal] = STATE(912),
    [sym__expression] = STATE(2450),
    [sym__real_expression] = STATE(670),
    [sym_throw_expression] = STATE(976),
    [sym_assignment_expression] = STATE(976),
    [sym_assignable_expression] = STATE(1582),
    [sym_lambda_expression] = STATE(494),
    [sym_function_expression] = STATE(967),
    [sym_if_null_expression] = STATE(1377),
    [sym_conditional_expression] = STATE(1377),
    [sym_logical_or_expression] = STATE(1377),
    [sym_logical_and_expression] = STATE(1377),
    [sym_equality_expression] = STATE(1377),
    [sym_type_cast_expression] = STATE(1377),
    [sym_type_test_expression] = STATE(1377),
    [sym_relational_expression] = STATE(1377),
    [sym_bitwise_or_expression] = STATE(1377),
    [sym_bitwise_xor_expression] = STATE(1377),
    [sym_bitwise_and_expression] = STATE(1377),
    [sym_shift_expression] = STATE(1377),
    [sym_additive_expression] = STATE(1377),
    [sym_multiplicative_expression] = STATE(1377),
    [sym__unary_expression] = STATE(1118),
    [sym_unary_expression] = STATE(1169),
    [sym__postfix_expression] = STATE(1169),
    [sym_postfix_expression] = STATE(1170),
    [sym_prefix_operator] = STATE(360),
    [sym_negation_operator] = STATE(1206),
    [sym_tilde_operator] = STATE(1188),
    [sym_await_expression] = STATE(1171),
    [sym_new_expression] = STATE(967),
    [sym_const_object_expression] = STATE(967),
    [sym__primary] = STATE(641),
    [sym_constructor_invocation] = STATE(638),
    [sym_type_arguments] = STATE(2454),
    [sym__statement] = STATE(532),
    [sym_local_function_declaration] = STATE(491),
    [sym_block] = STATE(488),
    [sym_expression_statement] = STATE(488),
    [sym_assert_statement] = STATE(488),
    [sym_assertion] = STATE(2726),
    [sym_switch_statement] = STATE(488),
    [sym_do_statement] = STATE(488),
    [sym_break_statement] = STATE(488),
    [sym_continue_statement] = STATE(488),
    [sym_yield_statement] = STATE(488),
    [sym_yield_each_statement] = STATE(488),
    [sym_return_statement] = STATE(488),
    [sym_try_statement] = STATE(488),
    [sym__try_head] = STATE(1927),
    [sym_if_statement] = STATE(488),
    [sym_while_statement] = STATE(488),
    [sym_for_statement] = STATE(488),
    [sym__annotation] = STATE(1287),
    [sym_marker_annotation] = STATE(1289),
    [sym_annotation] = STATE(1289),
    [sym_part_directive] = STATE(405),
    [sym_part_of_directive] = STATE(406),
    [sym_enum_declaration] = STATE(466),
    [sym_type_alias] = STATE(466),
    [sym_class_definition] = STATE(466),
    [sym_extension_declaration] = STATE(466),
    [sym__metadata] = STATE(542),
    [sym_type_parameters] = STATE(2299),
    [sym_mixin_declaration] = STATE(466),
    [sym_getter_signature] = STATE(1770),
    [sym_setter_signature] = STATE(1770),
    [sym_initialized_variable_definition] = STATE(2472),
    [sym__declared_identifier] = STATE(2151),
    [sym__final_const_var_or_type] = STATE(2686),
    [sym__type] = STATE(1955),
    [sym__type_not_function] = STATE(1616),
    [sym__type_not_void_not_function] = STATE(1668),
    [sym_function_type] = STATE(1655),
    [aux_sym__function_type_tails] = STATE(1482),
    [sym__function_type_tail] = STATE(1568),
    [sym__type_name] = STATE(1722),
    [sym__var_or_type] = STATE(2325),
    [sym_inferred_type] = STATE(1644),
    [sym_function_signature] = STATE(1764),
    [sym__formal_parameter_part] = STATE(1915),
    [sym_formal_parameter_list] = STATE(1636),
    [sym__strict_formal_parameter_list] = STATE(1626),
    [sym_local_variable_declaration] = STATE(509),
    [sym__covariant] = STATE(1552),
    [sym__function_builtin_identifier] = STATE(1424),
    [sym__get] = STATE(1952),
    [sym__mixin] = STATE(2576),
    [sym__set] = STATE(1892),
    [sym__typedef] = STATE(1699),
    [sym__new_builtin] = STATE(1701),
    [sym__late_builtin] = STATE(1621),
    [sym__external_builtin] = STATE(1573),
    [sym_this] = STATE(967),
    [sym_super] = STATE(1128),
    [sym_comment] = STATE(9),
    [sym_documentation_comment] = STATE(9),
    [aux_sym_program_repeat2] = STATE(377),
    [aux_sym_program_repeat3] = STATE(14),
    [aux_sym_program_repeat4] = STATE(19),
    [aux_sym_program_repeat5] = STATE(39),
    [aux_sym_string_literal_repeat1] = STATE(473),
    [aux_sym__metadata_repeat1] = STATE(1143),
    [ts_builtin_sym_end] = ACTIONS(137),
    [sym_identifier] = ACTIONS(15),
    [anon_sym_POUND] = ACTIONS(139),
    [sym_decimal_integer_literal] = ACTIONS(19),
    [sym_hex_integer_literal] = ACTIONS(21),
    [sym_decimal_floating_point_literal] = ACTIONS(19),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(25),
    [anon_sym_DQUOTE] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_r_DQUOTE] = ACTIONS(35),
    [anon_sym_r_SQUOTE] = ACTIONS(37),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(39),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(43),
    [anon_sym_LBRACK] = ACTIONS(45),
    [anon_sym_null] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_LT] = ACTIONS(53),
    [sym_increment_operator] = ACTIONS(55),
    [sym_minus_operator] = ACTIONS(57),
    [sym__exclamation_operator] = ACTIONS(59),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_await] = ACTIONS(63),
    [anon_sym_switch] = ACTIONS(65),
    [anon_sym_do] = ACTIONS(67),
    [anon_sym_while] = ACTIONS(69),
    [anon_sym_continue] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [anon_sym_return] = ACTIONS(75),
    [anon_sym_try] = ACTIONS(77),
    [anon_sym_if] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_AT] = ACTIONS(83),
    [anon_sym_part] = ACTIONS(85),
    [anon_sym_enum] = ACTIONS(87),
    [anon_sym_abstract] = ACTIONS(89),
    [anon_sym_class] = ACTIONS(91),
    [anon_sym_extension] = ACTIONS(93),
    [anon_sym_super] = ACTIONS(95),
    [sym_void_type] = ACTIONS(97),
    [anon_sym_var] = ACTIONS(99),
    [sym__break_builtin] = ACTIONS(105),
    [sym__assert_builtin] = ACTIONS(107),
    [anon_sym_covariant] = ACTIONS(109),
    [anon_sym_Function] = ACTIONS(113),
    [anon_sym_get] = ACTIONS(115),
    [anon_sym_mixin] = ACTIONS(119),
    [anon_sym_set] = ACTIONS(121),
    [anon_sym_typedef] = ACTIONS(123),
    [anon_sym_new] = ACTIONS(125),
    [sym_const_builtin] = ACTIONS(127),
    [sym_final_builtin] = ACTIONS(129),
    [anon_sym_late] = ACTIONS(131),
    [anon_sym_external] = ACTIONS(133),
    [anon_sym_this] = ACTIONS(135),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_SLASH_SLASH_SLASH] = ACTIONS(7),
    [sym__block_comment] = ACTIONS(9),
    [sym__documentation_block_comment] = ACTIONS(11),
  },
  [10] = {
    [sym__top_level_definition] = STATE(446),
    [sym__literal] = STATE(967),
    [sym_symbol_literal] = STATE(912),
    [sym_true] = STATE(912),
    [sym_false] = STATE(912),
    [sym_string_literal] = STATE(912),
    [sym__string_literal_double_quotes] = STATE(617),
    [sym__string_literal_single_quotes] = STATE(617),
    [sym__string_literal_double_quotes_multiple] = STATE(617),
    [sym__string_literal_single_quotes_multiple] = STATE(617),
    [sym__raw_string_literal_double_quotes] = STATE(617),
    [sym__raw_string_literal_single_quotes] = STATE(617),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(617),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(617),
    [sym_list_literal] = STATE(912),
    [sym_set_or_map_literal] = STATE(912),
    [sym_null_literal] = STATE(912),
    [sym__expression] = STATE(2450),
    [sym__real_expression] = STATE(670),
    [sym_throw_expression] = STATE(976),
    [sym_assignment_expression] = STATE(976),
    [sym_assignable_expression] = STATE(1582),
    [sym_lambda_expression] = STATE(494),
    [sym_function_expression] = STATE(967),
    [sym_if_null_expression] = STATE(1377),
    [sym_conditional_expression] = STATE(1377),
    [sym_logical_or_expression] = STATE(1377),
    [sym_logical_and_expression] = STATE(1377),
    [sym_equality_expression] = STATE(1377),
    [sym_type_cast_expression] = STATE(1377),
    [sym_type_test_expression] = STATE(1377),
    [sym_relational_expression] = STATE(1377),
    [sym_bitwise_or_expression] = STATE(1377),
    [sym_bitwise_xor_expression] = STATE(1377),
    [sym_bitwise_and_expression] = STATE(1377),
    [sym_shift_expression] = STATE(1377),
    [sym_additive_expression] = STATE(1377),
    [sym_multiplicative_expression] = STATE(1377),
    [sym__unary_expression] = STATE(1118),
    [sym_unary_expression] = STATE(1169),
    [sym__postfix_expression] = STATE(1169),
    [sym_postfix_expression] = STATE(1170),
    [sym_prefix_operator] = STATE(360),
    [sym_negation_operator] = STATE(1206),
    [sym_tilde_operator] = STATE(1188),
    [sym_await_expression] = STATE(1171),
    [sym_new_expression] = STATE(967),
    [sym_const_object_expression] = STATE(967),
    [sym__primary] = STATE(641),
    [sym_constructor_invocation] = STATE(638),
    [sym_type_arguments] = STATE(2454),
    [sym__statement] = STATE(532),
    [sym_local_function_declaration] = STATE(491),
    [sym_block] = STATE(488),
    [sym_expression_statement] = STATE(488),
    [sym_assert_statement] = STATE(488),
    [sym_assertion] = STATE(2726),
    [sym_switch_statement] = STATE(488),
    [sym_do_statement] = STATE(488),
    [sym_break_statement] = STATE(488),
    [sym_continue_statement] = STATE(488),
    [sym_yield_statement] = STATE(488),
    [sym_yield_each_statement] = STATE(488),
    [sym_return_statement] = STATE(488),
    [sym_try_statement] = STATE(488),
    [sym__try_head] = STATE(1927),
    [sym_if_statement] = STATE(488),
    [sym_while_statement] = STATE(488),
    [sym_for_statement] = STATE(488),
    [sym__annotation] = STATE(1287),
    [sym_marker_annotation] = STATE(1289),
    [sym_annotation] = STATE(1289),
    [sym_part_directive] = STATE(405),
    [sym_part_of_directive] = STATE(406),
    [sym_enum_declaration] = STATE(466),
    [sym_type_alias] = STATE(466),
    [sym_class_definition] = STATE(466),
    [sym_extension_declaration] = STATE(466),
    [sym__metadata] = STATE(542),
    [sym_type_parameters] = STATE(2299),
    [sym_mixin_declaration] = STATE(466),
    [sym_getter_signature] = STATE(1770),
    [sym_setter_signature] = STATE(1770),
    [sym_initialized_variable_definition] = STATE(2472),
    [sym__declared_identifier] = STATE(2151),
    [sym__final_const_var_or_type] = STATE(2686),
    [sym__type] = STATE(1955),
    [sym__type_not_function] = STATE(1616),
    [sym__type_not_void_not_function] = STATE(1668),
    [sym_function_type] = STATE(1655),
    [aux_sym__function_type_tails] = STATE(1482),
    [sym__function_type_tail] = STATE(1568),
    [sym__type_name] = STATE(1722),
    [sym__var_or_type] = STATE(2325),
    [sym_inferred_type] = STATE(1644),
    [sym_function_signature] = STATE(1764),
    [sym__formal_parameter_part] = STATE(1915),
    [sym_formal_parameter_list] = STATE(1636),
    [sym__strict_formal_parameter_list] = STATE(1626),
    [sym_local_variable_declaration] = STATE(509),
    [sym__covariant] = STATE(1552),
    [sym__function_builtin_identifier] = STATE(1424),
    [sym__get] = STATE(1952),
    [sym__mixin] = STATE(2576),
    [sym__set] = STATE(1892),
    [sym__typedef] = STATE(1699),
    [sym__new_builtin] = STATE(1701),
    [sym__late_builtin] = STATE(1621),
    [sym__external_builtin] = STATE(1573),
    [sym_this] = STATE(967),
    [sym_super] = STATE(1128),
    [sym_comment] = STATE(10),
    [sym_documentation_comment] = STATE(10),
    [aux_sym_program_repeat2] = STATE(377),
    [aux_sym_program_repeat3] = STATE(15),
    [aux_sym_program_repeat4] = STATE(17),
    [aux_sym_program_repeat5] = STATE(51),
    [aux_sym_string_literal_repeat1] = STATE(473),
    [aux_sym__metadata_repeat1] = STATE(1143),
    [ts_builtin_sym_end] = ACTIONS(143),
    [sym_identifier] = ACTIONS(15),
    [anon_sym_POUND] = ACTIONS(139),
    [sym_decimal_integer_literal] = ACTIONS(19),
    [sym_hex_integer_literal] = ACTIONS(21),
    [sym_decimal_floating_point_literal] = ACTIONS(19),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(25),
    [anon_sym_DQUOTE] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_r_DQUOTE] = ACTIONS(35),
    [anon_sym_r_SQUOTE] = ACTIONS(37),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(39),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(43),
    [anon_sym_LBRACK] = ACTIONS(45),
    [anon_sym_null] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_LT] = ACTIONS(53),
    [sym_increment_operator] = ACTIONS(55),
    [sym_minus_operator] = ACTIONS(57),
    [sym__exclamation_operator] = ACTIONS(59),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_await] = ACTIONS(63),
    [anon_sym_switch] = ACTIONS(65),
    [anon_sym_do] = ACTIONS(67),
    [anon_sym_while] = ACTIONS(69),
    [anon_sym_continue] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [anon_sym_return] = ACTIONS(75),
    [anon_sym_try] = ACTIONS(77),
    [anon_sym_if] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_AT] = ACTIONS(83),
    [anon_sym_part] = ACTIONS(85),
    [anon_sym_enum] = ACTIONS(87),
    [anon_sym_abstract] = ACTIONS(89),
    [anon_sym_class] = ACTIONS(91),
    [anon_sym_extension] = ACTIONS(93),
    [anon_sym_super] = ACTIONS(95),
    [sym_void_type] = ACTIONS(97),
    [anon_sym_var] = ACTIONS(99),
    [sym__break_builtin] = ACTIONS(105),
    [sym__assert_builtin] = ACTIONS(107),
    [anon_sym_covariant] = ACTIONS(109),
    [anon_sym_Function] = ACTIONS(113),
    [anon_sym_get] = ACTIONS(115),
    [anon_sym_mixin] = ACTIONS(119),
    [anon_sym_set] = ACTIONS(121),
    [anon_sym_typedef] = ACTIONS(123),
    [anon_sym_new] = ACTIONS(125),
    [sym_const_builtin] = ACTIONS(127),
    [sym_final_builtin] = ACTIONS(129),
    [anon_sym_late] = ACTIONS(131),
    [anon_sym_external] = ACTIONS(133),
    [anon_sym_this] = ACTIONS(135),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_SLASH_SLASH_SLASH] = ACTIONS(7),
    [sym__block_comment] = ACTIONS(9),
    [sym__documentation_block_comment] = ACTIONS(11),
  },
  [11] = {
    [sym__top_level_definition] = STATE(446),
    [sym__literal] = STATE(967),
    [sym_symbol_literal] = STATE(912),
    [sym_true] = STATE(912),
    [sym_false] = STATE(912),
    [sym_string_literal] = STATE(912),
    [sym__string_literal_double_quotes] = STATE(617),
    [sym__string_literal_single_quotes] = STATE(617),
    [sym__string_literal_double_quotes_multiple] = STATE(617),
    [sym__string_literal_single_quotes_multiple] = STATE(617),
    [sym__raw_string_literal_double_quotes] = STATE(617),
    [sym__raw_string_literal_single_quotes] = STATE(617),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(617),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(617),
    [sym_list_literal] = STATE(912),
    [sym_set_or_map_literal] = STATE(912),
    [sym_null_literal] = STATE(912),
    [sym__expression] = STATE(2450),
    [sym__real_expression] = STATE(670),
    [sym_throw_expression] = STATE(976),
    [sym_assignment_expression] = STATE(976),
    [sym_assignable_expression] = STATE(1582),
    [sym_lambda_expression] = STATE(494),
    [sym_function_expression] = STATE(967),
    [sym_if_null_expression] = STATE(1377),
    [sym_conditional_expression] = STATE(1377),
    [sym_logical_or_expression] = STATE(1377),
    [sym_logical_and_expression] = STATE(1377),
    [sym_equality_expression] = STATE(1377),
    [sym_type_cast_expression] = STATE(1377),
    [sym_type_test_expression] = STATE(1377),
    [sym_relational_expression] = STATE(1377),
    [sym_bitwise_or_expression] = STATE(1377),
    [sym_bitwise_xor_expression] = STATE(1377),
    [sym_bitwise_and_expression] = STATE(1377),
    [sym_shift_expression] = STATE(1377),
    [sym_additive_expression] = STATE(1377),
    [sym_multiplicative_expression] = STATE(1377),
    [sym__unary_expression] = STATE(1118),
    [sym_unary_expression] = STATE(1169),
    [sym__postfix_expression] = STATE(1169),
    [sym_postfix_expression] = STATE(1170),
    [sym_prefix_operator] = STATE(360),
    [sym_negation_operator] = STATE(1206),
    [sym_tilde_operator] = STATE(1188),
    [sym_await_expression] = STATE(1171),
    [sym_new_expression] = STATE(967),
    [sym_const_object_expression] = STATE(967),
    [sym__primary] = STATE(641),
    [sym_constructor_invocation] = STATE(638),
    [sym_type_arguments] = STATE(2454),
    [sym__statement] = STATE(532),
    [sym_local_function_declaration] = STATE(491),
    [sym_block] = STATE(488),
    [sym_expression_statement] = STATE(488),
    [sym_assert_statement] = STATE(488),
    [sym_assertion] = STATE(2726),
    [sym_switch_statement] = STATE(488),
    [sym_do_statement] = STATE(488),
    [sym_break_statement] = STATE(488),
    [sym_continue_statement] = STATE(488),
    [sym_yield_statement] = STATE(488),
    [sym_yield_each_statement] = STATE(488),
    [sym_return_statement] = STATE(488),
    [sym_try_statement] = STATE(488),
    [sym__try_head] = STATE(1927),
    [sym_if_statement] = STATE(488),
    [sym_while_statement] = STATE(488),
    [sym_for_statement] = STATE(488),
    [sym__annotation] = STATE(1287),
    [sym_marker_annotation] = STATE(1289),
    [sym_annotation] = STATE(1289),
    [sym_part_directive] = STATE(405),
    [sym_part_of_directive] = STATE(406),
    [sym_enum_declaration] = STATE(466),
    [sym_type_alias] = STATE(466),
    [sym_class_definition] = STATE(466),
    [sym_extension_declaration] = STATE(466),
    [sym__metadata] = STATE(542),
    [sym_type_parameters] = STATE(2299),
    [sym_mixin_declaration] = STATE(466),
    [sym_getter_signature] = STATE(1770),
    [sym_setter_signature] = STATE(1770),
    [sym_initialized_variable_definition] = STATE(2472),
    [sym__declared_identifier] = STATE(2151),
    [sym__final_const_var_or_type] = STATE(2686),
    [sym__type] = STATE(1955),
    [sym__type_not_function] = STATE(1616),
    [sym__type_not_void_not_function] = STATE(1668),
    [sym_function_type] = STATE(1655),
    [aux_sym__function_type_tails] = STATE(1482),
    [sym__function_type_tail] = STATE(1568),
    [sym__type_name] = STATE(1722),
    [sym__var_or_type] = STATE(2325),
    [sym_inferred_type] = STATE(1644),
    [sym_function_signature] = STATE(1764),
    [sym__formal_parameter_part] = STATE(1915),
    [sym_formal_parameter_list] = STATE(1636),
    [sym__strict_formal_parameter_list] = STATE(1626),
    [sym_local_variable_declaration] = STATE(509),
    [sym__covariant] = STATE(1552),
    [sym__function_builtin_identifier] = STATE(1424),
    [sym__get] = STATE(1952),
    [sym__mixin] = STATE(2576),
    [sym__set] = STATE(1892),
    [sym__typedef] = STATE(1699),
    [sym__new_builtin] = STATE(1701),
    [sym__late_builtin] = STATE(1621),
    [sym__external_builtin] = STATE(1573),
    [sym_this] = STATE(967),
    [sym_super] = STATE(1128),
    [sym_comment] = STATE(11),
    [sym_documentation_comment] = STATE(11),
    [aux_sym_program_repeat2] = STATE(377),
    [aux_sym_program_repeat3] = STATE(12),
    [aux_sym_program_repeat4] = STATE(20),
    [aux_sym_program_repeat5] = STATE(54),
    [aux_sym_string_literal_repeat1] = STATE(473),
    [aux_sym__metadata_repeat1] = STATE(1143),
    [ts_builtin_sym_end] = ACTIONS(141),
    [sym_identifier] = ACTIONS(15),
    [anon_sym_POUND] = ACTIONS(139),
    [sym_decimal_integer_literal] = ACTIONS(19),
    [sym_hex_integer_literal] = ACTIONS(21),
    [sym_decimal_floating_point_literal] = ACTIONS(19),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(25),
    [anon_sym_DQUOTE] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_r_DQUOTE] = ACTIONS(35),
    [anon_sym_r_SQUOTE] = ACTIONS(37),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(39),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(43),
    [anon_sym_LBRACK] = ACTIONS(45),
    [anon_sym_null] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_LT] = ACTIONS(53),
    [sym_increment_operator] = ACTIONS(55),
    [sym_minus_operator] = ACTIONS(57),
    [sym__exclamation_operator] = ACTIONS(59),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_await] = ACTIONS(63),
    [anon_sym_switch] = ACTIONS(65),
    [anon_sym_do] = ACTIONS(67),
    [anon_sym_while] = ACTIONS(69),
    [anon_sym_continue] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [anon_sym_return] = ACTIONS(75),
    [anon_sym_try] = ACTIONS(77),
    [anon_sym_if] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_AT] = ACTIONS(83),
    [anon_sym_part] = ACTIONS(85),
    [anon_sym_enum] = ACTIONS(87),
    [anon_sym_abstract] = ACTIONS(89),
    [anon_sym_class] = ACTIONS(91),
    [anon_sym_extension] = ACTIONS(93),
    [anon_sym_super] = ACTIONS(95),
    [sym_void_type] = ACTIONS(97),
    [anon_sym_var] = ACTIONS(99),
    [sym__break_builtin] = ACTIONS(105),
    [sym__assert_builtin] = ACTIONS(107),
    [anon_sym_covariant] = ACTIONS(109),
    [anon_sym_Function] = ACTIONS(113),
    [anon_sym_get] = ACTIONS(115),
    [anon_sym_mixin] = ACTIONS(119),
    [anon_sym_set] = ACTIONS(121),
    [anon_sym_typedef] = ACTIONS(123),
    [anon_sym_new] = ACTIONS(125),
    [sym_const_builtin] = ACTIONS(127),
    [sym_final_builtin] = ACTIONS(129),
    [anon_sym_late] = ACTIONS(131),
    [anon_sym_external] = ACTIONS(133),
    [anon_sym_this] = ACTIONS(135),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_SLASH_SLASH_SLASH] = ACTIONS(7),
    [sym__block_comment] = ACTIONS(9),
    [sym__documentation_block_comment] = ACTIONS(11),
  },
  [12] = {
    [sym__top_level_definition] = STATE(446),
    [sym__literal] = STATE(967),
    [sym_symbol_literal] = STATE(912),
    [sym_true] = STATE(912),
    [sym_false] = STATE(912),
    [sym_string_literal] = STATE(912),
    [sym__string_literal_double_quotes] = STATE(617),
    [sym__string_literal_single_quotes] = STATE(617),
    [sym__string_literal_double_quotes_multiple] = STATE(617),
    [sym__string_literal_single_quotes_multiple] = STATE(617),
    [sym__raw_string_literal_double_quotes] = STATE(617),
    [sym__raw_string_literal_single_quotes] = STATE(617),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(617),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(617),
    [sym_list_literal] = STATE(912),
    [sym_set_or_map_literal] = STATE(912),
    [sym_null_literal] = STATE(912),
    [sym__expression] = STATE(2450),
    [sym__real_expression] = STATE(670),
    [sym_throw_expression] = STATE(976),
    [sym_assignment_expression] = STATE(976),
    [sym_assignable_expression] = STATE(1582),
    [sym_lambda_expression] = STATE(494),
    [sym_function_expression] = STATE(967),
    [sym_if_null_expression] = STATE(1377),
    [sym_conditional_expression] = STATE(1377),
    [sym_logical_or_expression] = STATE(1377),
    [sym_logical_and_expression] = STATE(1377),
    [sym_equality_expression] = STATE(1377),
    [sym_type_cast_expression] = STATE(1377),
    [sym_type_test_expression] = STATE(1377),
    [sym_relational_expression] = STATE(1377),
    [sym_bitwise_or_expression] = STATE(1377),
    [sym_bitwise_xor_expression] = STATE(1377),
    [sym_bitwise_and_expression] = STATE(1377),
    [sym_shift_expression] = STATE(1377),
    [sym_additive_expression] = STATE(1377),
    [sym_multiplicative_expression] = STATE(1377),
    [sym__unary_expression] = STATE(1118),
    [sym_unary_expression] = STATE(1169),
    [sym__postfix_expression] = STATE(1169),
    [sym_postfix_expression] = STATE(1170),
    [sym_prefix_operator] = STATE(360),
    [sym_negation_operator] = STATE(1206),
    [sym_tilde_operator] = STATE(1188),
    [sym_await_expression] = STATE(1171),
    [sym_new_expression] = STATE(967),
    [sym_const_object_expression] = STATE(967),
    [sym__primary] = STATE(641),
    [sym_constructor_invocation] = STATE(638),
    [sym_type_arguments] = STATE(2454),
    [sym__statement] = STATE(532),
    [sym_local_function_declaration] = STATE(491),
    [sym_block] = STATE(488),
    [sym_expression_statement] = STATE(488),
    [sym_assert_statement] = STATE(488),
    [sym_assertion] = STATE(2726),
    [sym_switch_statement] = STATE(488),
    [sym_do_statement] = STATE(488),
    [sym_break_statement] = STATE(488),
    [sym_continue_statement] = STATE(488),
    [sym_yield_statement] = STATE(488),
    [sym_yield_each_statement] = STATE(488),
    [sym_return_statement] = STATE(488),
    [sym_try_statement] = STATE(488),
    [sym__try_head] = STATE(1927),
    [sym_if_statement] = STATE(488),
    [sym_while_statement] = STATE(488),
    [sym_for_statement] = STATE(488),
    [sym__annotation] = STATE(1287),
    [sym_marker_annotation] = STATE(1289),
    [sym_annotation] = STATE(1289),
    [sym_part_of_directive] = STATE(406),
    [sym_enum_declaration] = STATE(466),
    [sym_type_alias] = STATE(466),
    [sym_class_definition] = STATE(466),
    [sym_extension_declaration] = STATE(466),
    [sym__metadata] = STATE(539),
    [sym_type_parameters] = STATE(2299),
    [sym_mixin_declaration] = STATE(466),
    [sym_getter_signature] = STATE(1770),
    [sym_setter_signature] = STATE(1770),
    [sym_initialized_variable_definition] = STATE(2472),
    [sym__declared_identifier] = STATE(2151),
    [sym__final_const_var_or_type] = STATE(2686),
    [sym__type] = STATE(1955),
    [sym__type_not_function] = STATE(1616),
    [sym__type_not_void_not_function] = STATE(1668),
    [sym_function_type] = STATE(1655),
    [aux_sym__function_type_tails] = STATE(1482),
    [sym__function_type_tail] = STATE(1568),
    [sym__type_name] = STATE(1722),
    [sym__var_or_type] = STATE(2325),
    [sym_inferred_type] = STATE(1644),
    [sym_function_signature] = STATE(1764),
    [sym__formal_parameter_part] = STATE(1915),
    [sym_formal_parameter_list] = STATE(1636),
    [sym__strict_formal_parameter_list] = STATE(1626),
    [sym_local_variable_declaration] = STATE(509),
    [sym__covariant] = STATE(1552),
    [sym__function_builtin_identifier] = STATE(1424),
    [sym__get] = STATE(1952),
    [sym__mixin] = STATE(2576),
    [sym__set] = STATE(1892),
    [sym__typedef] = STATE(1699),
    [sym__new_builtin] = STATE(1701),
    [sym__late_builtin] = STATE(1621),
    [sym__external_builtin] = STATE(1573),
    [sym_this] = STATE(967),
    [sym_super] = STATE(1128),
    [sym_comment] = STATE(12),
    [sym_documentation_comment] = STATE(12),
    [aux_sym_program_repeat3] = STATE(378),
    [aux_sym_program_repeat4] = STATE(18),
    [aux_sym_program_repeat5] = STATE(47),
    [aux_sym_string_literal_repeat1] = STATE(473),
    [aux_sym__metadata_repeat1] = STATE(1143),
    [ts_builtin_sym_end] = ACTIONS(145),
    [sym_identifier] = ACTIONS(15),
    [anon_sym_POUND] = ACTIONS(139),
    [sym_decimal_integer_literal] = ACTIONS(19),
    [sym_hex_integer_literal] = ACTIONS(21),
    [sym_decimal_floating_point_literal] = ACTIONS(19),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(25),
    [anon_sym_DQUOTE] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_r_DQUOTE] = ACTIONS(35),
    [anon_sym_r_SQUOTE] = ACTIONS(37),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(39),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(43),
    [anon_sym_LBRACK] = ACTIONS(45),
    [anon_sym_null] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_LT] = ACTIONS(53),
    [sym_increment_operator] = ACTIONS(55),
    [sym_minus_operator] = ACTIONS(57),
    [sym__exclamation_operator] = ACTIONS(59),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_await] = ACTIONS(63),
    [anon_sym_switch] = ACTIONS(65),
    [anon_sym_do] = ACTIONS(67),
    [anon_sym_while] = ACTIONS(69),
    [anon_sym_continue] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [anon_sym_return] = ACTIONS(75),
    [anon_sym_try] = ACTIONS(77),
    [anon_sym_if] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_AT] = ACTIONS(83),
    [anon_sym_part] = ACTIONS(147),
    [anon_sym_enum] = ACTIONS(87),
    [anon_sym_abstract] = ACTIONS(89),
    [anon_sym_class] = ACTIONS(91),
    [anon_sym_extension] = ACTIONS(93),
    [anon_sym_super] = ACTIONS(95),
    [sym_void_type] = ACTIONS(97),
    [anon_sym_var] = ACTIONS(99),
    [sym__break_builtin] = ACTIONS(105),
    [sym__assert_builtin] = ACTIONS(107),
    [anon_sym_covariant] = ACTIONS(109),
    [anon_sym_Function] = ACTIONS(113),
    [anon_sym_get] = ACTIONS(115),
    [anon_sym_mixin] = ACTIONS(119),
    [anon_sym_set] = ACTIONS(121),
    [anon_sym_typedef] = ACTIONS(123),
    [anon_sym_new] = ACTIONS(125),
    [sym_const_builtin] = ACTIONS(127),
    [sym_final_builtin] = ACTIONS(129),
    [anon_sym_late] = ACTIONS(131),
    [anon_sym_external] = ACTIONS(133),
    [anon_sym_this] = ACTIONS(135),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_SLASH_SLASH_SLASH] = ACTIONS(7),
    [sym__block_comment] = ACTIONS(9),
    [sym__documentation_block_comment] = ACTIONS(11),
  },
  [13] = {
    [sym__top_level_definition] = STATE(446),
    [sym__literal] = STATE(967),
    [sym_symbol_literal] = STATE(912),
    [sym_true] = STATE(912),
    [sym_false] = STATE(912),
    [sym_string_literal] = STATE(912),
    [sym__string_literal_double_quotes] = STATE(617),
    [sym__string_literal_single_quotes] = STATE(617),
    [sym__string_literal_double_quotes_multiple] = STATE(617),
    [sym__string_literal_single_quotes_multiple] = STATE(617),
    [sym__raw_string_literal_double_quotes] = STATE(617),
    [sym__raw_string_literal_single_quotes] = STATE(617),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(617),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(617),
    [sym_list_literal] = STATE(912),
    [sym_set_or_map_literal] = STATE(912),
    [sym_null_literal] = STATE(912),
    [sym__expression] = STATE(2450),
    [sym__real_expression] = STATE(670),
    [sym_throw_expression] = STATE(976),
    [sym_assignment_expression] = STATE(976),
    [sym_assignable_expression] = STATE(1582),
    [sym_lambda_expression] = STATE(494),
    [sym_function_expression] = STATE(967),
    [sym_if_null_expression] = STATE(1377),
    [sym_conditional_expression] = STATE(1377),
    [sym_logical_or_expression] = STATE(1377),
    [sym_logical_and_expression] = STATE(1377),
    [sym_equality_expression] = STATE(1377),
    [sym_type_cast_expression] = STATE(1377),
    [sym_type_test_expression] = STATE(1377),
    [sym_relational_expression] = STATE(1377),
    [sym_bitwise_or_expression] = STATE(1377),
    [sym_bitwise_xor_expression] = STATE(1377),
    [sym_bitwise_and_expression] = STATE(1377),
    [sym_shift_expression] = STATE(1377),
    [sym_additive_expression] = STATE(1377),
    [sym_multiplicative_expression] = STATE(1377),
    [sym__unary_expression] = STATE(1118),
    [sym_unary_expression] = STATE(1169),
    [sym__postfix_expression] = STATE(1169),
    [sym_postfix_expression] = STATE(1170),
    [sym_prefix_operator] = STATE(360),
    [sym_negation_operator] = STATE(1206),
    [sym_tilde_operator] = STATE(1188),
    [sym_await_expression] = STATE(1171),
    [sym_new_expression] = STATE(967),
    [sym_const_object_expression] = STATE(967),
    [sym__primary] = STATE(641),
    [sym_constructor_invocation] = STATE(638),
    [sym_type_arguments] = STATE(2454),
    [sym__statement] = STATE(532),
    [sym_local_function_declaration] = STATE(491),
    [sym_block] = STATE(488),
    [sym_expression_statement] = STATE(488),
    [sym_assert_statement] = STATE(488),
    [sym_assertion] = STATE(2726),
    [sym_switch_statement] = STATE(488),
    [sym_do_statement] = STATE(488),
    [sym_break_statement] = STATE(488),
    [sym_continue_statement] = STATE(488),
    [sym_yield_statement] = STATE(488),
    [sym_yield_each_statement] = STATE(488),
    [sym_return_statement] = STATE(488),
    [sym_try_statement] = STATE(488),
    [sym__try_head] = STATE(1927),
    [sym_if_statement] = STATE(488),
    [sym_while_statement] = STATE(488),
    [sym_for_statement] = STATE(488),
    [sym__annotation] = STATE(1287),
    [sym_marker_annotation] = STATE(1289),
    [sym_annotation] = STATE(1289),
    [sym_part_of_directive] = STATE(406),
    [sym_enum_declaration] = STATE(466),
    [sym_type_alias] = STATE(466),
    [sym_class_definition] = STATE(466),
    [sym_extension_declaration] = STATE(466),
    [sym__metadata] = STATE(539),
    [sym_type_parameters] = STATE(2299),
    [sym_mixin_declaration] = STATE(466),
    [sym_getter_signature] = STATE(1770),
    [sym_setter_signature] = STATE(1770),
    [sym_initialized_variable_definition] = STATE(2472),
    [sym__declared_identifier] = STATE(2151),
    [sym__final_const_var_or_type] = STATE(2686),
    [sym__type] = STATE(1955),
    [sym__type_not_function] = STATE(1616),
    [sym__type_not_void_not_function] = STATE(1668),
    [sym_function_type] = STATE(1655),
    [aux_sym__function_type_tails] = STATE(1482),
    [sym__function_type_tail] = STATE(1568),
    [sym__type_name] = STATE(1722),
    [sym__var_or_type] = STATE(2325),
    [sym_inferred_type] = STATE(1644),
    [sym_function_signature] = STATE(1764),
    [sym__formal_parameter_part] = STATE(1915),
    [sym_formal_parameter_list] = STATE(1636),
    [sym__strict_formal_parameter_list] = STATE(1626),
    [sym_local_variable_declaration] = STATE(509),
    [sym__covariant] = STATE(1552),
    [sym__function_builtin_identifier] = STATE(1424),
    [sym__get] = STATE(1952),
    [sym__mixin] = STATE(2576),
    [sym__set] = STATE(1892),
    [sym__typedef] = STATE(1699),
    [sym__new_builtin] = STATE(1701),
    [sym__late_builtin] = STATE(1621),
    [sym__external_builtin] = STATE(1573),
    [sym_this] = STATE(967),
    [sym_super] = STATE(1128),
    [sym_comment] = STATE(13),
    [sym_documentation_comment] = STATE(13),
    [aux_sym_program_repeat3] = STATE(378),
    [aux_sym_program_repeat4] = STATE(19),
    [aux_sym_program_repeat5] = STATE(39),
    [aux_sym_string_literal_repeat1] = STATE(473),
    [aux_sym__metadata_repeat1] = STATE(1143),
    [ts_builtin_sym_end] = ACTIONS(137),
    [sym_identifier] = ACTIONS(15),
    [anon_sym_POUND] = ACTIONS(139),
    [sym_decimal_integer_literal] = ACTIONS(19),
    [sym_hex_integer_literal] = ACTIONS(21),
    [sym_decimal_floating_point_literal] = ACTIONS(19),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(25),
    [anon_sym_DQUOTE] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_r_DQUOTE] = ACTIONS(35),
    [anon_sym_r_SQUOTE] = ACTIONS(37),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(39),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(43),
    [anon_sym_LBRACK] = ACTIONS(45),
    [anon_sym_null] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_LT] = ACTIONS(53),
    [sym_increment_operator] = ACTIONS(55),
    [sym_minus_operator] = ACTIONS(57),
    [sym__exclamation_operator] = ACTIONS(59),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_await] = ACTIONS(63),
    [anon_sym_switch] = ACTIONS(65),
    [anon_sym_do] = ACTIONS(67),
    [anon_sym_while] = ACTIONS(69),
    [anon_sym_continue] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [anon_sym_return] = ACTIONS(75),
    [anon_sym_try] = ACTIONS(77),
    [anon_sym_if] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_AT] = ACTIONS(83),
    [anon_sym_part] = ACTIONS(147),
    [anon_sym_enum] = ACTIONS(87),
    [anon_sym_abstract] = ACTIONS(89),
    [anon_sym_class] = ACTIONS(91),
    [anon_sym_extension] = ACTIONS(93),
    [anon_sym_super] = ACTIONS(95),
    [sym_void_type] = ACTIONS(97),
    [anon_sym_var] = ACTIONS(99),
    [sym__break_builtin] = ACTIONS(105),
    [sym__assert_builtin] = ACTIONS(107),
    [anon_sym_covariant] = ACTIONS(109),
    [anon_sym_Function] = ACTIONS(113),
    [anon_sym_get] = ACTIONS(115),
    [anon_sym_mixin] = ACTIONS(119),
    [anon_sym_set] = ACTIONS(121),
    [anon_sym_typedef] = ACTIONS(123),
    [anon_sym_new] = ACTIONS(125),
    [sym_const_builtin] = ACTIONS(127),
    [sym_final_builtin] = ACTIONS(129),
    [anon_sym_late] = ACTIONS(131),
    [anon_sym_external] = ACTIONS(133),
    [anon_sym_this] = ACTIONS(135),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_SLASH_SLASH_SLASH] = ACTIONS(7),
    [sym__block_comment] = ACTIONS(9),
    [sym__documentation_block_comment] = ACTIONS(11),
  },
  [14] = {
    [sym__top_level_definition] = STATE(446),
    [sym__literal] = STATE(967),
    [sym_symbol_literal] = STATE(912),
    [sym_true] = STATE(912),
    [sym_false] = STATE(912),
    [sym_string_literal] = STATE(912),
    [sym__string_literal_double_quotes] = STATE(617),
    [sym__string_literal_single_quotes] = STATE(617),
    [sym__string_literal_double_quotes_multiple] = STATE(617),
    [sym__string_literal_single_quotes_multiple] = STATE(617),
    [sym__raw_string_literal_double_quotes] = STATE(617),
    [sym__raw_string_literal_single_quotes] = STATE(617),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(617),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(617),
    [sym_list_literal] = STATE(912),
    [sym_set_or_map_literal] = STATE(912),
    [sym_null_literal] = STATE(912),
    [sym__expression] = STATE(2450),
    [sym__real_expression] = STATE(670),
    [sym_throw_expression] = STATE(976),
    [sym_assignment_expression] = STATE(976),
    [sym_assignable_expression] = STATE(1582),
    [sym_lambda_expression] = STATE(494),
    [sym_function_expression] = STATE(967),
    [sym_if_null_expression] = STATE(1377),
    [sym_conditional_expression] = STATE(1377),
    [sym_logical_or_expression] = STATE(1377),
    [sym_logical_and_expression] = STATE(1377),
    [sym_equality_expression] = STATE(1377),
    [sym_type_cast_expression] = STATE(1377),
    [sym_type_test_expression] = STATE(1377),
    [sym_relational_expression] = STATE(1377),
    [sym_bitwise_or_expression] = STATE(1377),
    [sym_bitwise_xor_expression] = STATE(1377),
    [sym_bitwise_and_expression] = STATE(1377),
    [sym_shift_expression] = STATE(1377),
    [sym_additive_expression] = STATE(1377),
    [sym_multiplicative_expression] = STATE(1377),
    [sym__unary_expression] = STATE(1118),
    [sym_unary_expression] = STATE(1169),
    [sym__postfix_expression] = STATE(1169),
    [sym_postfix_expression] = STATE(1170),
    [sym_prefix_operator] = STATE(360),
    [sym_negation_operator] = STATE(1206),
    [sym_tilde_operator] = STATE(1188),
    [sym_await_expression] = STATE(1171),
    [sym_new_expression] = STATE(967),
    [sym_const_object_expression] = STATE(967),
    [sym__primary] = STATE(641),
    [sym_constructor_invocation] = STATE(638),
    [sym_type_arguments] = STATE(2454),
    [sym__statement] = STATE(532),
    [sym_local_function_declaration] = STATE(491),
    [sym_block] = STATE(488),
    [sym_expression_statement] = STATE(488),
    [sym_assert_statement] = STATE(488),
    [sym_assertion] = STATE(2726),
    [sym_switch_statement] = STATE(488),
    [sym_do_statement] = STATE(488),
    [sym_break_statement] = STATE(488),
    [sym_continue_statement] = STATE(488),
    [sym_yield_statement] = STATE(488),
    [sym_yield_each_statement] = STATE(488),
    [sym_return_statement] = STATE(488),
    [sym_try_statement] = STATE(488),
    [sym__try_head] = STATE(1927),
    [sym_if_statement] = STATE(488),
    [sym_while_statement] = STATE(488),
    [sym_for_statement] = STATE(488),
    [sym__annotation] = STATE(1287),
    [sym_marker_annotation] = STATE(1289),
    [sym_annotation] = STATE(1289),
    [sym_part_of_directive] = STATE(406),
    [sym_enum_declaration] = STATE(466),
    [sym_type_alias] = STATE(466),
    [sym_class_definition] = STATE(466),
    [sym_extension_declaration] = STATE(466),
    [sym__metadata] = STATE(539),
    [sym_type_parameters] = STATE(2299),
    [sym_mixin_declaration] = STATE(466),
    [sym_getter_signature] = STATE(1770),
    [sym_setter_signature] = STATE(1770),
    [sym_initialized_variable_definition] = STATE(2472),
    [sym__declared_identifier] = STATE(2151),
    [sym__final_const_var_or_type] = STATE(2686),
    [sym__type] = STATE(1955),
    [sym__type_not_function] = STATE(1616),
    [sym__type_not_void_not_function] = STATE(1668),
    [sym_function_type] = STATE(1655),
    [aux_sym__function_type_tails] = STATE(1482),
    [sym__function_type_tail] = STATE(1568),
    [sym__type_name] = STATE(1722),
    [sym__var_or_type] = STATE(2325),
    [sym_inferred_type] = STATE(1644),
    [sym_function_signature] = STATE(1764),
    [sym__formal_parameter_part] = STATE(1915),
    [sym_formal_parameter_list] = STATE(1636),
    [sym__strict_formal_parameter_list] = STATE(1626),
    [sym_local_variable_declaration] = STATE(509),
    [sym__covariant] = STATE(1552),
    [sym__function_builtin_identifier] = STATE(1424),
    [sym__get] = STATE(1952),
    [sym__mixin] = STATE(2576),
    [sym__set] = STATE(1892),
    [sym__typedef] = STATE(1699),
    [sym__new_builtin] = STATE(1701),
    [sym__late_builtin] = STATE(1621),
    [sym__external_builtin] = STATE(1573),
    [sym_this] = STATE(967),
    [sym_super] = STATE(1128),
    [sym_comment] = STATE(14),
    [sym_documentation_comment] = STATE(14),
    [aux_sym_program_repeat3] = STATE(378),
    [aux_sym_program_repeat4] = STATE(17),
    [aux_sym_program_repeat5] = STATE(51),
    [aux_sym_string_literal_repeat1] = STATE(473),
    [aux_sym__metadata_repeat1] = STATE(1143),
    [ts_builtin_sym_end] = ACTIONS(143),
    [sym_identifier] = ACTIONS(15),
    [anon_sym_POUND] = ACTIONS(139),
    [sym_decimal_integer_literal] = ACTIONS(19),
    [sym_hex_integer_literal] = ACTIONS(21),
    [sym_decimal_floating_point_literal] = ACTIONS(19),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(25),
    [anon_sym_DQUOTE] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_r_DQUOTE] = ACTIONS(35),
    [anon_sym_r_SQUOTE] = ACTIONS(37),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(39),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(43),
    [anon_sym_LBRACK] = ACTIONS(45),
    [anon_sym_null] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_LT] = ACTIONS(53),
    [sym_increment_operator] = ACTIONS(55),
    [sym_minus_operator] = ACTIONS(57),
    [sym__exclamation_operator] = ACTIONS(59),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_await] = ACTIONS(63),
    [anon_sym_switch] = ACTIONS(65),
    [anon_sym_do] = ACTIONS(67),
    [anon_sym_while] = ACTIONS(69),
    [anon_sym_continue] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [anon_sym_return] = ACTIONS(75),
    [anon_sym_try] = ACTIONS(77),
    [anon_sym_if] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_AT] = ACTIONS(83),
    [anon_sym_part] = ACTIONS(147),
    [anon_sym_enum] = ACTIONS(87),
    [anon_sym_abstract] = ACTIONS(89),
    [anon_sym_class] = ACTIONS(91),
    [anon_sym_extension] = ACTIONS(93),
    [anon_sym_super] = ACTIONS(95),
    [sym_void_type] = ACTIONS(97),
    [anon_sym_var] = ACTIONS(99),
    [sym__break_builtin] = ACTIONS(105),
    [sym__assert_builtin] = ACTIONS(107),
    [anon_sym_covariant] = ACTIONS(109),
    [anon_sym_Function] = ACTIONS(113),
    [anon_sym_get] = ACTIONS(115),
    [anon_sym_mixin] = ACTIONS(119),
    [anon_sym_set] = ACTIONS(121),
    [anon_sym_typedef] = ACTIONS(123),
    [anon_sym_new] = ACTIONS(125),
    [sym_const_builtin] = ACTIONS(127),
    [sym_final_builtin] = ACTIONS(129),
    [anon_sym_late] = ACTIONS(131),
    [anon_sym_external] = ACTIONS(133),
    [anon_sym_this] = ACTIONS(135),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_SLASH_SLASH_SLASH] = ACTIONS(7),
    [sym__block_comment] = ACTIONS(9),
    [sym__documentation_block_comment] = ACTIONS(11),
  },
  [15] = {
    [sym__top_level_definition] = STATE(446),
    [sym__literal] = STATE(967),
    [sym_symbol_literal] = STATE(912),
    [sym_true] = STATE(912),
    [sym_false] = STATE(912),
    [sym_string_literal] = STATE(912),
    [sym__string_literal_double_quotes] = STATE(617),
    [sym__string_literal_single_quotes] = STATE(617),
    [sym__string_literal_double_quotes_multiple] = STATE(617),
    [sym__string_literal_single_quotes_multiple] = STATE(617),
    [sym__raw_string_literal_double_quotes] = STATE(617),
    [sym__raw_string_literal_single_quotes] = STATE(617),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(617),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(617),
    [sym_list_literal] = STATE(912),
    [sym_set_or_map_literal] = STATE(912),
    [sym_null_literal] = STATE(912),
    [sym__expression] = STATE(2450),
    [sym__real_expression] = STATE(670),
    [sym_throw_expression] = STATE(976),
    [sym_assignment_expression] = STATE(976),
    [sym_assignable_expression] = STATE(1582),
    [sym_lambda_expression] = STATE(494),
    [sym_function_expression] = STATE(967),
    [sym_if_null_expression] = STATE(1377),
    [sym_conditional_expression] = STATE(1377),
    [sym_logical_or_expression] = STATE(1377),
    [sym_logical_and_expression] = STATE(1377),
    [sym_equality_expression] = STATE(1377),
    [sym_type_cast_expression] = STATE(1377),
    [sym_type_test_expression] = STATE(1377),
    [sym_relational_expression] = STATE(1377),
    [sym_bitwise_or_expression] = STATE(1377),
    [sym_bitwise_xor_expression] = STATE(1377),
    [sym_bitwise_and_expression] = STATE(1377),
    [sym_shift_expression] = STATE(1377),
    [sym_additive_expression] = STATE(1377),
    [sym_multiplicative_expression] = STATE(1377),
    [sym__unary_expression] = STATE(1118),
    [sym_unary_expression] = STATE(1169),
    [sym__postfix_expression] = STATE(1169),
    [sym_postfix_expression] = STATE(1170),
    [sym_prefix_operator] = STATE(360),
    [sym_negation_operator] = STATE(1206),
    [sym_tilde_operator] = STATE(1188),
    [sym_await_expression] = STATE(1171),
    [sym_new_expression] = STATE(967),
    [sym_const_object_expression] = STATE(967),
    [sym__primary] = STATE(641),
    [sym_constructor_invocation] = STATE(638),
    [sym_type_arguments] = STATE(2454),
    [sym__statement] = STATE(532),
    [sym_local_function_declaration] = STATE(491),
    [sym_block] = STATE(488),
    [sym_expression_statement] = STATE(488),
    [sym_assert_statement] = STATE(488),
    [sym_assertion] = STATE(2726),
    [sym_switch_statement] = STATE(488),
    [sym_do_statement] = STATE(488),
    [sym_break_statement] = STATE(488),
    [sym_continue_statement] = STATE(488),
    [sym_yield_statement] = STATE(488),
    [sym_yield_each_statement] = STATE(488),
    [sym_return_statement] = STATE(488),
    [sym_try_statement] = STATE(488),
    [sym__try_head] = STATE(1927),
    [sym_if_statement] = STATE(488),
    [sym_while_statement] = STATE(488),
    [sym_for_statement] = STATE(488),
    [sym__annotation] = STATE(1287),
    [sym_marker_annotation] = STATE(1289),
    [sym_annotation] = STATE(1289),
    [sym_part_of_directive] = STATE(406),
    [sym_enum_declaration] = STATE(466),
    [sym_type_alias] = STATE(466),
    [sym_class_definition] = STATE(466),
    [sym_extension_declaration] = STATE(466),
    [sym__metadata] = STATE(539),
    [sym_type_parameters] = STATE(2299),
    [sym_mixin_declaration] = STATE(466),
    [sym_getter_signature] = STATE(1770),
    [sym_setter_signature] = STATE(1770),
    [sym_initialized_variable_definition] = STATE(2472),
    [sym__declared_identifier] = STATE(2151),
    [sym__final_const_var_or_type] = STATE(2686),
    [sym__type] = STATE(1955),
    [sym__type_not_function] = STATE(1616),
    [sym__type_not_void_not_function] = STATE(1668),
    [sym_function_type] = STATE(1655),
    [aux_sym__function_type_tails] = STATE(1482),
    [sym__function_type_tail] = STATE(1568),
    [sym__type_name] = STATE(1722),
    [sym__var_or_type] = STATE(2325),
    [sym_inferred_type] = STATE(1644),
    [sym_function_signature] = STATE(1764),
    [sym__formal_parameter_part] = STATE(1915),
    [sym_formal_parameter_list] = STATE(1636),
    [sym__strict_formal_parameter_list] = STATE(1626),
    [sym_local_variable_declaration] = STATE(509),
    [sym__covariant] = STATE(1552),
    [sym__function_builtin_identifier] = STATE(1424),
    [sym__get] = STATE(1952),
    [sym__mixin] = STATE(2576),
    [sym__set] = STATE(1892),
    [sym__typedef] = STATE(1699),
    [sym__new_builtin] = STATE(1701),
    [sym__late_builtin] = STATE(1621),
    [sym__external_builtin] = STATE(1573),
    [sym_this] = STATE(967),
    [sym_super] = STATE(1128),
    [sym_comment] = STATE(15),
    [sym_documentation_comment] = STATE(15),
    [aux_sym_program_repeat3] = STATE(378),
    [aux_sym_program_repeat4] = STATE(20),
    [aux_sym_program_repeat5] = STATE(54),
    [aux_sym_string_literal_repeat1] = STATE(473),
    [aux_sym__metadata_repeat1] = STATE(1143),
    [ts_builtin_sym_end] = ACTIONS(141),
    [sym_identifier] = ACTIONS(15),
    [anon_sym_POUND] = ACTIONS(139),
    [sym_decimal_integer_literal] = ACTIONS(19),
    [sym_hex_integer_literal] = ACTIONS(21),
    [sym_decimal_floating_point_literal] = ACTIONS(19),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(25),
    [anon_sym_DQUOTE] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_r_DQUOTE] = ACTIONS(35),
    [anon_sym_r_SQUOTE] = ACTIONS(37),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(39),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(43),
    [anon_sym_LBRACK] = ACTIONS(45),
    [anon_sym_null] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_LT] = ACTIONS(53),
    [sym_increment_operator] = ACTIONS(55),
    [sym_minus_operator] = ACTIONS(57),
    [sym__exclamation_operator] = ACTIONS(59),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_await] = ACTIONS(63),
    [anon_sym_switch] = ACTIONS(65),
    [anon_sym_do] = ACTIONS(67),
    [anon_sym_while] = ACTIONS(69),
    [anon_sym_continue] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [anon_sym_return] = ACTIONS(75),
    [anon_sym_try] = ACTIONS(77),
    [anon_sym_if] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_AT] = ACTIONS(83),
    [anon_sym_part] = ACTIONS(147),
    [anon_sym_enum] = ACTIONS(87),
    [anon_sym_abstract] = ACTIONS(89),
    [anon_sym_class] = ACTIONS(91),
    [anon_sym_extension] = ACTIONS(93),
    [anon_sym_super] = ACTIONS(95),
    [sym_void_type] = ACTIONS(97),
    [anon_sym_var] = ACTIONS(99),
    [sym__break_builtin] = ACTIONS(105),
    [sym__assert_builtin] = ACTIONS(107),
    [anon_sym_covariant] = ACTIONS(109),
    [anon_sym_Function] = ACTIONS(113),
    [anon_sym_get] = ACTIONS(115),
    [anon_sym_mixin] = ACTIONS(119),
    [anon_sym_set] = ACTIONS(121),
    [anon_sym_typedef] = ACTIONS(123),
    [anon_sym_new] = ACTIONS(125),
    [sym_const_builtin] = ACTIONS(127),
    [sym_final_builtin] = ACTIONS(129),
    [anon_sym_late] = ACTIONS(131),
    [anon_sym_external] = ACTIONS(133),
    [anon_sym_this] = ACTIONS(135),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_SLASH_SLASH_SLASH] = ACTIONS(7),
    [sym__block_comment] = ACTIONS(9),
    [sym__documentation_block_comment] = ACTIONS(11),
  },
  [16] = {
    [sym__top_level_definition] = STATE(446),
    [sym__literal] = STATE(967),
    [sym_symbol_literal] = STATE(912),
    [sym_true] = STATE(912),
    [sym_false] = STATE(912),
    [sym_string_literal] = STATE(912),
    [sym__string_literal_double_quotes] = STATE(617),
    [sym__string_literal_single_quotes] = STATE(617),
    [sym__string_literal_double_quotes_multiple] = STATE(617),
    [sym__string_literal_single_quotes_multiple] = STATE(617),
    [sym__raw_string_literal_double_quotes] = STATE(617),
    [sym__raw_string_literal_single_quotes] = STATE(617),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(617),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(617),
    [sym_list_literal] = STATE(912),
    [sym_set_or_map_literal] = STATE(912),
    [sym_null_literal] = STATE(912),
    [sym__expression] = STATE(2450),
    [sym__real_expression] = STATE(670),
    [sym_throw_expression] = STATE(976),
    [sym_assignment_expression] = STATE(976),
    [sym_assignable_expression] = STATE(1582),
    [sym_lambda_expression] = STATE(494),
    [sym_function_expression] = STATE(967),
    [sym_if_null_expression] = STATE(1377),
    [sym_conditional_expression] = STATE(1377),
    [sym_logical_or_expression] = STATE(1377),
    [sym_logical_and_expression] = STATE(1377),
    [sym_equality_expression] = STATE(1377),
    [sym_type_cast_expression] = STATE(1377),
    [sym_type_test_expression] = STATE(1377),
    [sym_relational_expression] = STATE(1377),
    [sym_bitwise_or_expression] = STATE(1377),
    [sym_bitwise_xor_expression] = STATE(1377),
    [sym_bitwise_and_expression] = STATE(1377),
    [sym_shift_expression] = STATE(1377),
    [sym_additive_expression] = STATE(1377),
    [sym_multiplicative_expression] = STATE(1377),
    [sym__unary_expression] = STATE(1118),
    [sym_unary_expression] = STATE(1169),
    [sym__postfix_expression] = STATE(1169),
    [sym_postfix_expression] = STATE(1170),
    [sym_prefix_operator] = STATE(360),
    [sym_negation_operator] = STATE(1206),
    [sym_tilde_operator] = STATE(1188),
    [sym_await_expression] = STATE(1171),
    [sym_new_expression] = STATE(967),
    [sym_const_object_expression] = STATE(967),
    [sym__primary] = STATE(641),
    [sym_constructor_invocation] = STATE(638),
    [sym_type_arguments] = STATE(2454),
    [sym__statement] = STATE(532),
    [sym_local_function_declaration] = STATE(491),
    [sym_block] = STATE(488),
    [sym_expression_statement] = STATE(488),
    [sym_assert_statement] = STATE(488),
    [sym_assertion] = STATE(2726),
    [sym_switch_statement] = STATE(488),
    [sym_do_statement] = STATE(488),
    [sym_break_statement] = STATE(488),
    [sym_continue_statement] = STATE(488),
    [sym_yield_statement] = STATE(488),
    [sym_yield_each_statement] = STATE(488),
    [sym_return_statement] = STATE(488),
    [sym_try_statement] = STATE(488),
    [sym__try_head] = STATE(1927),
    [sym_if_statement] = STATE(488),
    [sym_while_statement] = STATE(488),
    [sym_for_statement] = STATE(488),
    [sym__annotation] = STATE(1287),
    [sym_marker_annotation] = STATE(1289),
    [sym_annotation] = STATE(1289),
    [sym_part_of_directive] = STATE(406),
    [sym_enum_declaration] = STATE(466),
    [sym_type_alias] = STATE(466),
    [sym_class_definition] = STATE(466),
    [sym_extension_declaration] = STATE(466),
    [sym__metadata] = STATE(539),
    [sym_type_parameters] = STATE(2299),
    [sym_mixin_declaration] = STATE(466),
    [sym_getter_signature] = STATE(1770),
    [sym_setter_signature] = STATE(1770),
    [sym_initialized_variable_definition] = STATE(2472),
    [sym__declared_identifier] = STATE(2151),
    [sym__final_const_var_or_type] = STATE(2686),
    [sym__type] = STATE(1955),
    [sym__type_not_function] = STATE(1616),
    [sym__type_not_void_not_function] = STATE(1668),
    [sym_function_type] = STATE(1655),
    [aux_sym__function_type_tails] = STATE(1482),
    [sym__function_type_tail] = STATE(1568),
    [sym__type_name] = STATE(1722),
    [sym__var_or_type] = STATE(2325),
    [sym_inferred_type] = STATE(1644),
    [sym_function_signature] = STATE(1764),
    [sym__formal_parameter_part] = STATE(1915),
    [sym_formal_parameter_list] = STATE(1636),
    [sym__strict_formal_parameter_list] = STATE(1626),
    [sym_local_variable_declaration] = STATE(509),
    [sym__covariant] = STATE(1552),
    [sym__function_builtin_identifier] = STATE(1424),
    [sym__get] = STATE(1952),
    [sym__mixin] = STATE(2576),
    [sym__set] = STATE(1892),
    [sym__typedef] = STATE(1699),
    [sym__new_builtin] = STATE(1701),
    [sym__late_builtin] = STATE(1621),
    [sym__external_builtin] = STATE(1573),
    [sym_this] = STATE(967),
    [sym_super] = STATE(1128),
    [sym_comment] = STATE(16),
    [sym_documentation_comment] = STATE(16),
    [aux_sym_program_repeat3] = STATE(378),
    [aux_sym_program_repeat4] = STATE(22),
    [aux_sym_program_repeat5] = STATE(45),
    [aux_sym_string_literal_repeat1] = STATE(473),
    [aux_sym__metadata_repeat1] = STATE(1143),
    [ts_builtin_sym_end] = ACTIONS(149),
    [sym_identifier] = ACTIONS(15),
    [anon_sym_POUND] = ACTIONS(139),
    [sym_decimal_integer_literal] = ACTIONS(19),
    [sym_hex_integer_literal] = ACTIONS(21),
    [sym_decimal_floating_point_literal] = ACTIONS(19),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(25),
    [anon_sym_DQUOTE] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_r_DQUOTE] = ACTIONS(35),
    [anon_sym_r_SQUOTE] = ACTIONS(37),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(39),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(43),
    [anon_sym_LBRACK] = ACTIONS(45),
    [anon_sym_null] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_LT] = ACTIONS(53),
    [sym_increment_operator] = ACTIONS(55),
    [sym_minus_operator] = ACTIONS(57),
    [sym__exclamation_operator] = ACTIONS(59),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_await] = ACTIONS(63),
    [anon_sym_switch] = ACTIONS(65),
    [anon_sym_do] = ACTIONS(67),
    [anon_sym_while] = ACTIONS(69),
    [anon_sym_continue] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [anon_sym_return] = ACTIONS(75),
    [anon_sym_try] = ACTIONS(77),
    [anon_sym_if] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_AT] = ACTIONS(83),
    [anon_sym_part] = ACTIONS(147),
    [anon_sym_enum] = ACTIONS(87),
    [anon_sym_abstract] = ACTIONS(89),
    [anon_sym_class] = ACTIONS(91),
    [anon_sym_extension] = ACTIONS(93),
    [anon_sym_super] = ACTIONS(95),
    [sym_void_type] = ACTIONS(97),
    [anon_sym_var] = ACTIONS(99),
    [sym__break_builtin] = ACTIONS(105),
    [sym__assert_builtin] = ACTIONS(107),
    [anon_sym_covariant] = ACTIONS(109),
    [anon_sym_Function] = ACTIONS(113),
    [anon_sym_get] = ACTIONS(115),
    [anon_sym_mixin] = ACTIONS(119),
    [anon_sym_set] = ACTIONS(121),
    [anon_sym_typedef] = ACTIONS(123),
    [anon_sym_new] = ACTIONS(125),
    [sym_const_builtin] = ACTIONS(127),
    [sym_final_builtin] = ACTIONS(129),
    [anon_sym_late] = ACTIONS(131),
    [anon_sym_external] = ACTIONS(133),
    [anon_sym_this] = ACTIONS(135),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_SLASH_SLASH_SLASH] = ACTIONS(7),
    [sym__block_comment] = ACTIONS(9),
    [sym__documentation_block_comment] = ACTIONS(11),
  },
  [17] = {
    [sym__top_level_definition] = STATE(446),
    [sym__literal] = STATE(967),
    [sym_symbol_literal] = STATE(912),
    [sym_true] = STATE(912),
    [sym_false] = STATE(912),
    [sym_string_literal] = STATE(912),
    [sym__string_literal_double_quotes] = STATE(617),
    [sym__string_literal_single_quotes] = STATE(617),
    [sym__string_literal_double_quotes_multiple] = STATE(617),
    [sym__string_literal_single_quotes_multiple] = STATE(617),
    [sym__raw_string_literal_double_quotes] = STATE(617),
    [sym__raw_string_literal_single_quotes] = STATE(617),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(617),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(617),
    [sym_list_literal] = STATE(912),
    [sym_set_or_map_literal] = STATE(912),
    [sym_null_literal] = STATE(912),
    [sym__expression] = STATE(2450),
    [sym__real_expression] = STATE(670),
    [sym_throw_expression] = STATE(976),
    [sym_assignment_expression] = STATE(976),
    [sym_assignable_expression] = STATE(1582),
    [sym_lambda_expression] = STATE(494),
    [sym_function_expression] = STATE(967),
    [sym_if_null_expression] = STATE(1377),
    [sym_conditional_expression] = STATE(1377),
    [sym_logical_or_expression] = STATE(1377),
    [sym_logical_and_expression] = STATE(1377),
    [sym_equality_expression] = STATE(1377),
    [sym_type_cast_expression] = STATE(1377),
    [sym_type_test_expression] = STATE(1377),
    [sym_relational_expression] = STATE(1377),
    [sym_bitwise_or_expression] = STATE(1377),
    [sym_bitwise_xor_expression] = STATE(1377),
    [sym_bitwise_and_expression] = STATE(1377),
    [sym_shift_expression] = STATE(1377),
    [sym_additive_expression] = STATE(1377),
    [sym_multiplicative_expression] = STATE(1377),
    [sym__unary_expression] = STATE(1118),
    [sym_unary_expression] = STATE(1169),
    [sym__postfix_expression] = STATE(1169),
    [sym_postfix_expression] = STATE(1170),
    [sym_prefix_operator] = STATE(360),
    [sym_negation_operator] = STATE(1206),
    [sym_tilde_operator] = STATE(1188),
    [sym_await_expression] = STATE(1171),
    [sym_new_expression] = STATE(967),
    [sym_const_object_expression] = STATE(967),
    [sym__primary] = STATE(641),
    [sym_constructor_invocation] = STATE(638),
    [sym_type_arguments] = STATE(2454),
    [sym__statement] = STATE(532),
    [sym_local_function_declaration] = STATE(491),
    [sym_block] = STATE(488),
    [sym_expression_statement] = STATE(488),
    [sym_assert_statement] = STATE(488),
    [sym_assertion] = STATE(2726),
    [sym_switch_statement] = STATE(488),
    [sym_do_statement] = STATE(488),
    [sym_break_statement] = STATE(488),
    [sym_continue_statement] = STATE(488),
    [sym_yield_statement] = STATE(488),
    [sym_yield_each_statement] = STATE(488),
    [sym_return_statement] = STATE(488),
    [sym_try_statement] = STATE(488),
    [sym__try_head] = STATE(1927),
    [sym_if_statement] = STATE(488),
    [sym_while_statement] = STATE(488),
    [sym_for_statement] = STATE(488),
    [sym__annotation] = STATE(1287),
    [sym_marker_annotation] = STATE(1289),
    [sym_annotation] = STATE(1289),
    [sym_enum_declaration] = STATE(466),
    [sym_type_alias] = STATE(466),
    [sym_class_definition] = STATE(466),
    [sym_extension_declaration] = STATE(466),
    [sym__metadata] = STATE(577),
    [sym_type_parameters] = STATE(2299),
    [sym_mixin_declaration] = STATE(466),
    [sym_getter_signature] = STATE(1770),
    [sym_setter_signature] = STATE(1770),
    [sym_initialized_variable_definition] = STATE(2472),
    [sym__declared_identifier] = STATE(2151),
    [sym__final_const_var_or_type] = STATE(2686),
    [sym__type] = STATE(1955),
    [sym__type_not_function] = STATE(1616),
    [sym__type_not_void_not_function] = STATE(1668),
    [sym_function_type] = STATE(1655),
    [aux_sym__function_type_tails] = STATE(1482),
    [sym__function_type_tail] = STATE(1568),
    [sym__type_name] = STATE(1722),
    [sym__var_or_type] = STATE(2325),
    [sym_inferred_type] = STATE(1644),
    [sym_function_signature] = STATE(1764),
    [sym__formal_parameter_part] = STATE(1915),
    [sym_formal_parameter_list] = STATE(1636),
    [sym__strict_formal_parameter_list] = STATE(1626),
    [sym_local_variable_declaration] = STATE(509),
    [sym__covariant] = STATE(1552),
    [sym__function_builtin_identifier] = STATE(1424),
    [sym__get] = STATE(1952),
    [sym__mixin] = STATE(2576),
    [sym__set] = STATE(1892),
    [sym__typedef] = STATE(1699),
    [sym__new_builtin] = STATE(1701),
    [sym__late_builtin] = STATE(1621),
    [sym__external_builtin] = STATE(1573),
    [sym_this] = STATE(967),
    [sym_super] = STATE(1128),
    [sym_comment] = STATE(17),
    [sym_documentation_comment] = STATE(17),
    [aux_sym_program_repeat4] = STATE(185),
    [aux_sym_program_repeat5] = STATE(54),
    [aux_sym_string_literal_repeat1] = STATE(473),
    [aux_sym__metadata_repeat1] = STATE(1143),
    [ts_builtin_sym_end] = ACTIONS(141),
    [sym_identifier] = ACTIONS(15),
    [anon_sym_POUND] = ACTIONS(139),
    [sym_decimal_integer_literal] = ACTIONS(19),
    [sym_hex_integer_literal] = ACTIONS(21),
    [sym_decimal_floating_point_literal] = ACTIONS(19),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(25),
    [anon_sym_DQUOTE] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_r_DQUOTE] = ACTIONS(35),
    [anon_sym_r_SQUOTE] = ACTIONS(37),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(39),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(43),
    [anon_sym_LBRACK] = ACTIONS(45),
    [anon_sym_null] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_LT] = ACTIONS(53),
    [sym_increment_operator] = ACTIONS(55),
    [sym_minus_operator] = ACTIONS(57),
    [sym__exclamation_operator] = ACTIONS(59),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_await] = ACTIONS(63),
    [anon_sym_switch] = ACTIONS(65),
    [anon_sym_do] = ACTIONS(67),
    [anon_sym_while] = ACTIONS(69),
    [anon_sym_continue] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [anon_sym_return] = ACTIONS(75),
    [anon_sym_try] = ACTIONS(77),
    [anon_sym_if] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_AT] = ACTIONS(83),
    [anon_sym_enum] = ACTIONS(87),
    [anon_sym_abstract] = ACTIONS(89),
    [anon_sym_class] = ACTIONS(91),
    [anon_sym_extension] = ACTIONS(93),
    [anon_sym_super] = ACTIONS(95),
    [sym_void_type] = ACTIONS(97),
    [anon_sym_var] = ACTIONS(99),
    [sym__break_builtin] = ACTIONS(105),
    [sym__assert_builtin] = ACTIONS(107),
    [anon_sym_covariant] = ACTIONS(109),
    [anon_sym_Function] = ACTIONS(113),
    [anon_sym_get] = ACTIONS(115),
    [anon_sym_mixin] = ACTIONS(119),
    [anon_sym_set] = ACTIONS(121),
    [anon_sym_typedef] = ACTIONS(123),
    [anon_sym_new] = ACTIONS(125),
    [sym_const_builtin] = ACTIONS(127),
    [sym_final_builtin] = ACTIONS(129),
    [anon_sym_late] = ACTIONS(131),
    [anon_sym_external] = ACTIONS(133),
    [anon_sym_this] = ACTIONS(135),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_SLASH_SLASH_SLASH] = ACTIONS(7),
    [sym__block_comment] = ACTIONS(9),
    [sym__documentation_block_comment] = ACTIONS(11),
  },
  [18] = {
    [sym__top_level_definition] = STATE(446),
    [sym__literal] = STATE(967),
    [sym_symbol_literal] = STATE(912),
    [sym_true] = STATE(912),
    [sym_false] = STATE(912),
    [sym_string_literal] = STATE(912),
    [sym__string_literal_double_quotes] = STATE(617),
    [sym__string_literal_single_quotes] = STATE(617),
    [sym__string_literal_double_quotes_multiple] = STATE(617),
    [sym__string_literal_single_quotes_multiple] = STATE(617),
    [sym__raw_string_literal_double_quotes] = STATE(617),
    [sym__raw_string_literal_single_quotes] = STATE(617),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(617),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(617),
    [sym_list_literal] = STATE(912),
    [sym_set_or_map_literal] = STATE(912),
    [sym_null_literal] = STATE(912),
    [sym__expression] = STATE(2450),
    [sym__real_expression] = STATE(670),
    [sym_throw_expression] = STATE(976),
    [sym_assignment_expression] = STATE(976),
    [sym_assignable_expression] = STATE(1582),
    [sym_lambda_expression] = STATE(494),
    [sym_function_expression] = STATE(967),
    [sym_if_null_expression] = STATE(1377),
    [sym_conditional_expression] = STATE(1377),
    [sym_logical_or_expression] = STATE(1377),
    [sym_logical_and_expression] = STATE(1377),
    [sym_equality_expression] = STATE(1377),
    [sym_type_cast_expression] = STATE(1377),
    [sym_type_test_expression] = STATE(1377),
    [sym_relational_expression] = STATE(1377),
    [sym_bitwise_or_expression] = STATE(1377),
    [sym_bitwise_xor_expression] = STATE(1377),
    [sym_bitwise_and_expression] = STATE(1377),
    [sym_shift_expression] = STATE(1377),
    [sym_additive_expression] = STATE(1377),
    [sym_multiplicative_expression] = STATE(1377),
    [sym__unary_expression] = STATE(1118),
    [sym_unary_expression] = STATE(1169),
    [sym__postfix_expression] = STATE(1169),
    [sym_postfix_expression] = STATE(1170),
    [sym_prefix_operator] = STATE(360),
    [sym_negation_operator] = STATE(1206),
    [sym_tilde_operator] = STATE(1188),
    [sym_await_expression] = STATE(1171),
    [sym_new_expression] = STATE(967),
    [sym_const_object_expression] = STATE(967),
    [sym__primary] = STATE(641),
    [sym_constructor_invocation] = STATE(638),
    [sym_type_arguments] = STATE(2454),
    [sym__statement] = STATE(532),
    [sym_local_function_declaration] = STATE(491),
    [sym_block] = STATE(488),
    [sym_expression_statement] = STATE(488),
    [sym_assert_statement] = STATE(488),
    [sym_assertion] = STATE(2726),
    [sym_switch_statement] = STATE(488),
    [sym_do_statement] = STATE(488),
    [sym_break_statement] = STATE(488),
    [sym_continue_statement] = STATE(488),
    [sym_yield_statement] = STATE(488),
    [sym_yield_each_statement] = STATE(488),
    [sym_return_statement] = STATE(488),
    [sym_try_statement] = STATE(488),
    [sym__try_head] = STATE(1927),
    [sym_if_statement] = STATE(488),
    [sym_while_statement] = STATE(488),
    [sym_for_statement] = STATE(488),
    [sym__annotation] = STATE(1287),
    [sym_marker_annotation] = STATE(1289),
    [sym_annotation] = STATE(1289),
    [sym_enum_declaration] = STATE(466),
    [sym_type_alias] = STATE(466),
    [sym_class_definition] = STATE(466),
    [sym_extension_declaration] = STATE(466),
    [sym__metadata] = STATE(577),
    [sym_type_parameters] = STATE(2299),
    [sym_mixin_declaration] = STATE(466),
    [sym_getter_signature] = STATE(1770),
    [sym_setter_signature] = STATE(1770),
    [sym_initialized_variable_definition] = STATE(2472),
    [sym__declared_identifier] = STATE(2151),
    [sym__final_const_var_or_type] = STATE(2686),
    [sym__type] = STATE(1955),
    [sym__type_not_function] = STATE(1616),
    [sym__type_not_void_not_function] = STATE(1668),
    [sym_function_type] = STATE(1655),
    [aux_sym__function_type_tails] = STATE(1482),
    [sym__function_type_tail] = STATE(1568),
    [sym__type_name] = STATE(1722),
    [sym__var_or_type] = STATE(2325),
    [sym_inferred_type] = STATE(1644),
    [sym_function_signature] = STATE(1764),
    [sym__formal_parameter_part] = STATE(1915),
    [sym_formal_parameter_list] = STATE(1636),
    [sym__strict_formal_parameter_list] = STATE(1626),
    [sym_local_variable_declaration] = STATE(509),
    [sym__covariant] = STATE(1552),
    [sym__function_builtin_identifier] = STATE(1424),
    [sym__get] = STATE(1952),
    [sym__mixin] = STATE(2576),
    [sym__set] = STATE(1892),
    [sym__typedef] = STATE(1699),
    [sym__new_builtin] = STATE(1701),
    [sym__late_builtin] = STATE(1621),
    [sym__external_builtin] = STATE(1573),
    [sym_this] = STATE(967),
    [sym_super] = STATE(1128),
    [sym_comment] = STATE(18),
    [sym_documentation_comment] = STATE(18),
    [aux_sym_program_repeat4] = STATE(185),
    [aux_sym_program_repeat5] = STATE(45),
    [aux_sym_string_literal_repeat1] = STATE(473),
    [aux_sym__metadata_repeat1] = STATE(1143),
    [ts_builtin_sym_end] = ACTIONS(149),
    [sym_identifier] = ACTIONS(15),
    [anon_sym_POUND] = ACTIONS(139),
    [sym_decimal_integer_literal] = ACTIONS(19),
    [sym_hex_integer_literal] = ACTIONS(21),
    [sym_decimal_floating_point_literal] = ACTIONS(19),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(25),
    [anon_sym_DQUOTE] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_r_DQUOTE] = ACTIONS(35),
    [anon_sym_r_SQUOTE] = ACTIONS(37),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(39),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(43),
    [anon_sym_LBRACK] = ACTIONS(45),
    [anon_sym_null] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_LT] = ACTIONS(53),
    [sym_increment_operator] = ACTIONS(55),
    [sym_minus_operator] = ACTIONS(57),
    [sym__exclamation_operator] = ACTIONS(59),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_await] = ACTIONS(63),
    [anon_sym_switch] = ACTIONS(65),
    [anon_sym_do] = ACTIONS(67),
    [anon_sym_while] = ACTIONS(69),
    [anon_sym_continue] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [anon_sym_return] = ACTIONS(75),
    [anon_sym_try] = ACTIONS(77),
    [anon_sym_if] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_AT] = ACTIONS(83),
    [anon_sym_enum] = ACTIONS(87),
    [anon_sym_abstract] = ACTIONS(89),
    [anon_sym_class] = ACTIONS(91),
    [anon_sym_extension] = ACTIONS(93),
    [anon_sym_super] = ACTIONS(95),
    [sym_void_type] = ACTIONS(97),
    [anon_sym_var] = ACTIONS(99),
    [sym__break_builtin] = ACTIONS(105),
    [sym__assert_builtin] = ACTIONS(107),
    [anon_sym_covariant] = ACTIONS(109),
    [anon_sym_Function] = ACTIONS(113),
    [anon_sym_get] = ACTIONS(115),
    [anon_sym_mixin] = ACTIONS(119),
    [anon_sym_set] = ACTIONS(121),
    [anon_sym_typedef] = ACTIONS(123),
    [anon_sym_new] = ACTIONS(125),
    [sym_const_builtin] = ACTIONS(127),
    [sym_final_builtin] = ACTIONS(129),
    [anon_sym_late] = ACTIONS(131),
    [anon_sym_external] = ACTIONS(133),
    [anon_sym_this] = ACTIONS(135),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_SLASH_SLASH_SLASH] = ACTIONS(7),
    [sym__block_comment] = ACTIONS(9),
    [sym__documentation_block_comment] = ACTIONS(11),
  },
  [19] = {
    [sym__top_level_definition] = STATE(446),
    [sym__literal] = STATE(967),
    [sym_symbol_literal] = STATE(912),
    [sym_true] = STATE(912),
    [sym_false] = STATE(912),
    [sym_string_literal] = STATE(912),
    [sym__string_literal_double_quotes] = STATE(617),
    [sym__string_literal_single_quotes] = STATE(617),
    [sym__string_literal_double_quotes_multiple] = STATE(617),
    [sym__string_literal_single_quotes_multiple] = STATE(617),
    [sym__raw_string_literal_double_quotes] = STATE(617),
    [sym__raw_string_literal_single_quotes] = STATE(617),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(617),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(617),
    [sym_list_literal] = STATE(912),
    [sym_set_or_map_literal] = STATE(912),
    [sym_null_literal] = STATE(912),
    [sym__expression] = STATE(2450),
    [sym__real_expression] = STATE(670),
    [sym_throw_expression] = STATE(976),
    [sym_assignment_expression] = STATE(976),
    [sym_assignable_expression] = STATE(1582),
    [sym_lambda_expression] = STATE(494),
    [sym_function_expression] = STATE(967),
    [sym_if_null_expression] = STATE(1377),
    [sym_conditional_expression] = STATE(1377),
    [sym_logical_or_expression] = STATE(1377),
    [sym_logical_and_expression] = STATE(1377),
    [sym_equality_expression] = STATE(1377),
    [sym_type_cast_expression] = STATE(1377),
    [sym_type_test_expression] = STATE(1377),
    [sym_relational_expression] = STATE(1377),
    [sym_bitwise_or_expression] = STATE(1377),
    [sym_bitwise_xor_expression] = STATE(1377),
    [sym_bitwise_and_expression] = STATE(1377),
    [sym_shift_expression] = STATE(1377),
    [sym_additive_expression] = STATE(1377),
    [sym_multiplicative_expression] = STATE(1377),
    [sym__unary_expression] = STATE(1118),
    [sym_unary_expression] = STATE(1169),
    [sym__postfix_expression] = STATE(1169),
    [sym_postfix_expression] = STATE(1170),
    [sym_prefix_operator] = STATE(360),
    [sym_negation_operator] = STATE(1206),
    [sym_tilde_operator] = STATE(1188),
    [sym_await_expression] = STATE(1171),
    [sym_new_expression] = STATE(967),
    [sym_const_object_expression] = STATE(967),
    [sym__primary] = STATE(641),
    [sym_constructor_invocation] = STATE(638),
    [sym_type_arguments] = STATE(2454),
    [sym__statement] = STATE(532),
    [sym_local_function_declaration] = STATE(491),
    [sym_block] = STATE(488),
    [sym_expression_statement] = STATE(488),
    [sym_assert_statement] = STATE(488),
    [sym_assertion] = STATE(2726),
    [sym_switch_statement] = STATE(488),
    [sym_do_statement] = STATE(488),
    [sym_break_statement] = STATE(488),
    [sym_continue_statement] = STATE(488),
    [sym_yield_statement] = STATE(488),
    [sym_yield_each_statement] = STATE(488),
    [sym_return_statement] = STATE(488),
    [sym_try_statement] = STATE(488),
    [sym__try_head] = STATE(1927),
    [sym_if_statement] = STATE(488),
    [sym_while_statement] = STATE(488),
    [sym_for_statement] = STATE(488),
    [sym__annotation] = STATE(1287),
    [sym_marker_annotation] = STATE(1289),
    [sym_annotation] = STATE(1289),
    [sym_enum_declaration] = STATE(466),
    [sym_type_alias] = STATE(466),
    [sym_class_definition] = STATE(466),
    [sym_extension_declaration] = STATE(466),
    [sym__metadata] = STATE(577),
    [sym_type_parameters] = STATE(2299),
    [sym_mixin_declaration] = STATE(466),
    [sym_getter_signature] = STATE(1770),
    [sym_setter_signature] = STATE(1770),
    [sym_initialized_variable_definition] = STATE(2472),
    [sym__declared_identifier] = STATE(2151),
    [sym__final_const_var_or_type] = STATE(2686),
    [sym__type] = STATE(1955),
    [sym__type_not_function] = STATE(1616),
    [sym__type_not_void_not_function] = STATE(1668),
    [sym_function_type] = STATE(1655),
    [aux_sym__function_type_tails] = STATE(1482),
    [sym__function_type_tail] = STATE(1568),
    [sym__type_name] = STATE(1722),
    [sym__var_or_type] = STATE(2325),
    [sym_inferred_type] = STATE(1644),
    [sym_function_signature] = STATE(1764),
    [sym__formal_parameter_part] = STATE(1915),
    [sym_formal_parameter_list] = STATE(1636),
    [sym__strict_formal_parameter_list] = STATE(1626),
    [sym_local_variable_declaration] = STATE(509),
    [sym__covariant] = STATE(1552),
    [sym__function_builtin_identifier] = STATE(1424),
    [sym__get] = STATE(1952),
    [sym__mixin] = STATE(2576),
    [sym__set] = STATE(1892),
    [sym__typedef] = STATE(1699),
    [sym__new_builtin] = STATE(1701),
    [sym__late_builtin] = STATE(1621),
    [sym__external_builtin] = STATE(1573),
    [sym_this] = STATE(967),
    [sym_super] = STATE(1128),
    [sym_comment] = STATE(19),
    [sym_documentation_comment] = STATE(19),
    [aux_sym_program_repeat4] = STATE(185),
    [aux_sym_program_repeat5] = STATE(51),
    [aux_sym_string_literal_repeat1] = STATE(473),
    [aux_sym__metadata_repeat1] = STATE(1143),
    [ts_builtin_sym_end] = ACTIONS(143),
    [sym_identifier] = ACTIONS(15),
    [anon_sym_POUND] = ACTIONS(139),
    [sym_decimal_integer_literal] = ACTIONS(19),
    [sym_hex_integer_literal] = ACTIONS(21),
    [sym_decimal_floating_point_literal] = ACTIONS(19),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(25),
    [anon_sym_DQUOTE] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_r_DQUOTE] = ACTIONS(35),
    [anon_sym_r_SQUOTE] = ACTIONS(37),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(39),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(43),
    [anon_sym_LBRACK] = ACTIONS(45),
    [anon_sym_null] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_LT] = ACTIONS(53),
    [sym_increment_operator] = ACTIONS(55),
    [sym_minus_operator] = ACTIONS(57),
    [sym__exclamation_operator] = ACTIONS(59),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_await] = ACTIONS(63),
    [anon_sym_switch] = ACTIONS(65),
    [anon_sym_do] = ACTIONS(67),
    [anon_sym_while] = ACTIONS(69),
    [anon_sym_continue] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [anon_sym_return] = ACTIONS(75),
    [anon_sym_try] = ACTIONS(77),
    [anon_sym_if] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_AT] = ACTIONS(83),
    [anon_sym_enum] = ACTIONS(87),
    [anon_sym_abstract] = ACTIONS(89),
    [anon_sym_class] = ACTIONS(91),
    [anon_sym_extension] = ACTIONS(93),
    [anon_sym_super] = ACTIONS(95),
    [sym_void_type] = ACTIONS(97),
    [anon_sym_var] = ACTIONS(99),
    [sym__break_builtin] = ACTIONS(105),
    [sym__assert_builtin] = ACTIONS(107),
    [anon_sym_covariant] = ACTIONS(109),
    [anon_sym_Function] = ACTIONS(113),
    [anon_sym_get] = ACTIONS(115),
    [anon_sym_mixin] = ACTIONS(119),
    [anon_sym_set] = ACTIONS(121),
    [anon_sym_typedef] = ACTIONS(123),
    [anon_sym_new] = ACTIONS(125),
    [sym_const_builtin] = ACTIONS(127),
    [sym_final_builtin] = ACTIONS(129),
    [anon_sym_late] = ACTIONS(131),
    [anon_sym_external] = ACTIONS(133),
    [anon_sym_this] = ACTIONS(135),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_SLASH_SLASH_SLASH] = ACTIONS(7),
    [sym__block_comment] = ACTIONS(9),
    [sym__documentation_block_comment] = ACTIONS(11),
  },
  [20] = {
    [sym__top_level_definition] = STATE(446),
    [sym__literal] = STATE(967),
    [sym_symbol_literal] = STATE(912),
    [sym_true] = STATE(912),
    [sym_false] = STATE(912),
    [sym_string_literal] = STATE(912),
    [sym__string_literal_double_quotes] = STATE(617),
    [sym__string_literal_single_quotes] = STATE(617),
    [sym__string_literal_double_quotes_multiple] = STATE(617),
    [sym__string_literal_single_quotes_multiple] = STATE(617),
    [sym__raw_string_literal_double_quotes] = STATE(617),
    [sym__raw_string_literal_single_quotes] = STATE(617),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(617),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(617),
    [sym_list_literal] = STATE(912),
    [sym_set_or_map_literal] = STATE(912),
    [sym_null_literal] = STATE(912),
    [sym__expression] = STATE(2450),
    [sym__real_expression] = STATE(670),
    [sym_throw_expression] = STATE(976),
    [sym_assignment_expression] = STATE(976),
    [sym_assignable_expression] = STATE(1582),
    [sym_lambda_expression] = STATE(494),
    [sym_function_expression] = STATE(967),
    [sym_if_null_expression] = STATE(1377),
    [sym_conditional_expression] = STATE(1377),
    [sym_logical_or_expression] = STATE(1377),
    [sym_logical_and_expression] = STATE(1377),
    [sym_equality_expression] = STATE(1377),
    [sym_type_cast_expression] = STATE(1377),
    [sym_type_test_expression] = STATE(1377),
    [sym_relational_expression] = STATE(1377),
    [sym_bitwise_or_expression] = STATE(1377),
    [sym_bitwise_xor_expression] = STATE(1377),
    [sym_bitwise_and_expression] = STATE(1377),
    [sym_shift_expression] = STATE(1377),
    [sym_additive_expression] = STATE(1377),
    [sym_multiplicative_expression] = STATE(1377),
    [sym__unary_expression] = STATE(1118),
    [sym_unary_expression] = STATE(1169),
    [sym__postfix_expression] = STATE(1169),
    [sym_postfix_expression] = STATE(1170),
    [sym_prefix_operator] = STATE(360),
    [sym_negation_operator] = STATE(1206),
    [sym_tilde_operator] = STATE(1188),
    [sym_await_expression] = STATE(1171),
    [sym_new_expression] = STATE(967),
    [sym_const_object_expression] = STATE(967),
    [sym__primary] = STATE(641),
    [sym_constructor_invocation] = STATE(638),
    [sym_type_arguments] = STATE(2454),
    [sym__statement] = STATE(532),
    [sym_local_function_declaration] = STATE(491),
    [sym_block] = STATE(488),
    [sym_expression_statement] = STATE(488),
    [sym_assert_statement] = STATE(488),
    [sym_assertion] = STATE(2726),
    [sym_switch_statement] = STATE(488),
    [sym_do_statement] = STATE(488),
    [sym_break_statement] = STATE(488),
    [sym_continue_statement] = STATE(488),
    [sym_yield_statement] = STATE(488),
    [sym_yield_each_statement] = STATE(488),
    [sym_return_statement] = STATE(488),
    [sym_try_statement] = STATE(488),
    [sym__try_head] = STATE(1927),
    [sym_if_statement] = STATE(488),
    [sym_while_statement] = STATE(488),
    [sym_for_statement] = STATE(488),
    [sym__annotation] = STATE(1287),
    [sym_marker_annotation] = STATE(1289),
    [sym_annotation] = STATE(1289),
    [sym_enum_declaration] = STATE(466),
    [sym_type_alias] = STATE(466),
    [sym_class_definition] = STATE(466),
    [sym_extension_declaration] = STATE(466),
    [sym__metadata] = STATE(577),
    [sym_type_parameters] = STATE(2299),
    [sym_mixin_declaration] = STATE(466),
    [sym_getter_signature] = STATE(1770),
    [sym_setter_signature] = STATE(1770),
    [sym_initialized_variable_definition] = STATE(2472),
    [sym__declared_identifier] = STATE(2151),
    [sym__final_const_var_or_type] = STATE(2686),
    [sym__type] = STATE(1955),
    [sym__type_not_function] = STATE(1616),
    [sym__type_not_void_not_function] = STATE(1668),
    [sym_function_type] = STATE(1655),
    [aux_sym__function_type_tails] = STATE(1482),
    [sym__function_type_tail] = STATE(1568),
    [sym__type_name] = STATE(1722),
    [sym__var_or_type] = STATE(2325),
    [sym_inferred_type] = STATE(1644),
    [sym_function_signature] = STATE(1764),
    [sym__formal_parameter_part] = STATE(1915),
    [sym_formal_parameter_list] = STATE(1636),
    [sym__strict_formal_parameter_list] = STATE(1626),
    [sym_local_variable_declaration] = STATE(509),
    [sym__covariant] = STATE(1552),
    [sym__function_builtin_identifier] = STATE(1424),
    [sym__get] = STATE(1952),
    [sym__mixin] = STATE(2576),
    [sym__set] = STATE(1892),
    [sym__typedef] = STATE(1699),
    [sym__new_builtin] = STATE(1701),
    [sym__late_builtin] = STATE(1621),
    [sym__external_builtin] = STATE(1573),
    [sym_this] = STATE(967),
    [sym_super] = STATE(1128),
    [sym_comment] = STATE(20),
    [sym_documentation_comment] = STATE(20),
    [aux_sym_program_repeat4] = STATE(185),
    [aux_sym_program_repeat5] = STATE(47),
    [aux_sym_string_literal_repeat1] = STATE(473),
    [aux_sym__metadata_repeat1] = STATE(1143),
    [ts_builtin_sym_end] = ACTIONS(145),
    [sym_identifier] = ACTIONS(15),
    [anon_sym_POUND] = ACTIONS(139),
    [sym_decimal_integer_literal] = ACTIONS(19),
    [sym_hex_integer_literal] = ACTIONS(21),
    [sym_decimal_floating_point_literal] = ACTIONS(19),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(25),
    [anon_sym_DQUOTE] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_r_DQUOTE] = ACTIONS(35),
    [anon_sym_r_SQUOTE] = ACTIONS(37),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(39),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(43),
    [anon_sym_LBRACK] = ACTIONS(45),
    [anon_sym_null] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_LT] = ACTIONS(53),
    [sym_increment_operator] = ACTIONS(55),
    [sym_minus_operator] = ACTIONS(57),
    [sym__exclamation_operator] = ACTIONS(59),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_await] = ACTIONS(63),
    [anon_sym_switch] = ACTIONS(65),
    [anon_sym_do] = ACTIONS(67),
    [anon_sym_while] = ACTIONS(69),
    [anon_sym_continue] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [anon_sym_return] = ACTIONS(75),
    [anon_sym_try] = ACTIONS(77),
    [anon_sym_if] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_AT] = ACTIONS(83),
    [anon_sym_enum] = ACTIONS(87),
    [anon_sym_abstract] = ACTIONS(89),
    [anon_sym_class] = ACTIONS(91),
    [anon_sym_extension] = ACTIONS(93),
    [anon_sym_super] = ACTIONS(95),
    [sym_void_type] = ACTIONS(97),
    [anon_sym_var] = ACTIONS(99),
    [sym__break_builtin] = ACTIONS(105),
    [sym__assert_builtin] = ACTIONS(107),
    [anon_sym_covariant] = ACTIONS(109),
    [anon_sym_Function] = ACTIONS(113),
    [anon_sym_get] = ACTIONS(115),
    [anon_sym_mixin] = ACTIONS(119),
    [anon_sym_set] = ACTIONS(121),
    [anon_sym_typedef] = ACTIONS(123),
    [anon_sym_new] = ACTIONS(125),
    [sym_const_builtin] = ACTIONS(127),
    [sym_final_builtin] = ACTIONS(129),
    [anon_sym_late] = ACTIONS(131),
    [anon_sym_external] = ACTIONS(133),
    [anon_sym_this] = ACTIONS(135),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_SLASH_SLASH_SLASH] = ACTIONS(7),
    [sym__block_comment] = ACTIONS(9),
    [sym__documentation_block_comment] = ACTIONS(11),
  },
  [21] = {
    [sym__top_level_definition] = STATE(446),
    [sym__literal] = STATE(967),
    [sym_symbol_literal] = STATE(912),
    [sym_true] = STATE(912),
    [sym_false] = STATE(912),
    [sym_string_literal] = STATE(912),
    [sym__string_literal_double_quotes] = STATE(617),
    [sym__string_literal_single_quotes] = STATE(617),
    [sym__string_literal_double_quotes_multiple] = STATE(617),
    [sym__string_literal_single_quotes_multiple] = STATE(617),
    [sym__raw_string_literal_double_quotes] = STATE(617),
    [sym__raw_string_literal_single_quotes] = STATE(617),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(617),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(617),
    [sym_list_literal] = STATE(912),
    [sym_set_or_map_literal] = STATE(912),
    [sym_null_literal] = STATE(912),
    [sym__expression] = STATE(2450),
    [sym__real_expression] = STATE(670),
    [sym_throw_expression] = STATE(976),
    [sym_assignment_expression] = STATE(976),
    [sym_assignable_expression] = STATE(1582),
    [sym_lambda_expression] = STATE(494),
    [sym_function_expression] = STATE(967),
    [sym_if_null_expression] = STATE(1377),
    [sym_conditional_expression] = STATE(1377),
    [sym_logical_or_expression] = STATE(1377),
    [sym_logical_and_expression] = STATE(1377),
    [sym_equality_expression] = STATE(1377),
    [sym_type_cast_expression] = STATE(1377),
    [sym_type_test_expression] = STATE(1377),
    [sym_relational_expression] = STATE(1377),
    [sym_bitwise_or_expression] = STATE(1377),
    [sym_bitwise_xor_expression] = STATE(1377),
    [sym_bitwise_and_expression] = STATE(1377),
    [sym_shift_expression] = STATE(1377),
    [sym_additive_expression] = STATE(1377),
    [sym_multiplicative_expression] = STATE(1377),
    [sym__unary_expression] = STATE(1118),
    [sym_unary_expression] = STATE(1169),
    [sym__postfix_expression] = STATE(1169),
    [sym_postfix_expression] = STATE(1170),
    [sym_prefix_operator] = STATE(360),
    [sym_negation_operator] = STATE(1206),
    [sym_tilde_operator] = STATE(1188),
    [sym_await_expression] = STATE(1171),
    [sym_new_expression] = STATE(967),
    [sym_const_object_expression] = STATE(967),
    [sym__primary] = STATE(641),
    [sym_constructor_invocation] = STATE(638),
    [sym_type_arguments] = STATE(2454),
    [sym__statement] = STATE(532),
    [sym_local_function_declaration] = STATE(491),
    [sym_block] = STATE(488),
    [sym_expression_statement] = STATE(488),
    [sym_assert_statement] = STATE(488),
    [sym_assertion] = STATE(2726),
    [sym_switch_statement] = STATE(488),
    [sym_do_statement] = STATE(488),
    [sym_break_statement] = STATE(488),
    [sym_continue_statement] = STATE(488),
    [sym_yield_statement] = STATE(488),
    [sym_yield_each_statement] = STATE(488),
    [sym_return_statement] = STATE(488),
    [sym_try_statement] = STATE(488),
    [sym__try_head] = STATE(1927),
    [sym_if_statement] = STATE(488),
    [sym_while_statement] = STATE(488),
    [sym_for_statement] = STATE(488),
    [sym__annotation] = STATE(1287),
    [sym_marker_annotation] = STATE(1289),
    [sym_annotation] = STATE(1289),
    [sym_enum_declaration] = STATE(466),
    [sym_type_alias] = STATE(466),
    [sym_class_definition] = STATE(466),
    [sym_extension_declaration] = STATE(466),
    [sym__metadata] = STATE(577),
    [sym_type_parameters] = STATE(2299),
    [sym_mixin_declaration] = STATE(466),
    [sym_getter_signature] = STATE(1770),
    [sym_setter_signature] = STATE(1770),
    [sym_initialized_variable_definition] = STATE(2472),
    [sym__declared_identifier] = STATE(2151),
    [sym__final_const_var_or_type] = STATE(2686),
    [sym__type] = STATE(1955),
    [sym__type_not_function] = STATE(1616),
    [sym__type_not_void_not_function] = STATE(1668),
    [sym_function_type] = STATE(1655),
    [aux_sym__function_type_tails] = STATE(1482),
    [sym__function_type_tail] = STATE(1568),
    [sym__type_name] = STATE(1722),
    [sym__var_or_type] = STATE(2325),
    [sym_inferred_type] = STATE(1644),
    [sym_function_signature] = STATE(1764),
    [sym__formal_parameter_part] = STATE(1915),
    [sym_formal_parameter_list] = STATE(1636),
    [sym__strict_formal_parameter_list] = STATE(1626),
    [sym_local_variable_declaration] = STATE(509),
    [sym__covariant] = STATE(1552),
    [sym__function_builtin_identifier] = STATE(1424),
    [sym__get] = STATE(1952),
    [sym__mixin] = STATE(2576),
    [sym__set] = STATE(1892),
    [sym__typedef] = STATE(1699),
    [sym__new_builtin] = STATE(1701),
    [sym__late_builtin] = STATE(1621),
    [sym__external_builtin] = STATE(1573),
    [sym_this] = STATE(967),
    [sym_super] = STATE(1128),
    [sym_comment] = STATE(21),
    [sym_documentation_comment] = STATE(21),
    [aux_sym_program_repeat4] = STATE(185),
    [aux_sym_program_repeat5] = STATE(39),
    [aux_sym_string_literal_repeat1] = STATE(473),
    [aux_sym__metadata_repeat1] = STATE(1143),
    [ts_builtin_sym_end] = ACTIONS(137),
    [sym_identifier] = ACTIONS(15),
    [anon_sym_POUND] = ACTIONS(139),
    [sym_decimal_integer_literal] = ACTIONS(19),
    [sym_hex_integer_literal] = ACTIONS(21),
    [sym_decimal_floating_point_literal] = ACTIONS(19),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(25),
    [anon_sym_DQUOTE] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_r_DQUOTE] = ACTIONS(35),
    [anon_sym_r_SQUOTE] = ACTIONS(37),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(39),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(43),
    [anon_sym_LBRACK] = ACTIONS(45),
    [anon_sym_null] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_LT] = ACTIONS(53),
    [sym_increment_operator] = ACTIONS(55),
    [sym_minus_operator] = ACTIONS(57),
    [sym__exclamation_operator] = ACTIONS(59),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_await] = ACTIONS(63),
    [anon_sym_switch] = ACTIONS(65),
    [anon_sym_do] = ACTIONS(67),
    [anon_sym_while] = ACTIONS(69),
    [anon_sym_continue] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [anon_sym_return] = ACTIONS(75),
    [anon_sym_try] = ACTIONS(77),
    [anon_sym_if] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_AT] = ACTIONS(83),
    [anon_sym_enum] = ACTIONS(87),
    [anon_sym_abstract] = ACTIONS(89),
    [anon_sym_class] = ACTIONS(91),
    [anon_sym_extension] = ACTIONS(93),
    [anon_sym_super] = ACTIONS(95),
    [sym_void_type] = ACTIONS(97),
    [anon_sym_var] = ACTIONS(99),
    [sym__break_builtin] = ACTIONS(105),
    [sym__assert_builtin] = ACTIONS(107),
    [anon_sym_covariant] = ACTIONS(109),
    [anon_sym_Function] = ACTIONS(113),
    [anon_sym_get] = ACTIONS(115),
    [anon_sym_mixin] = ACTIONS(119),
    [anon_sym_set] = ACTIONS(121),
    [anon_sym_typedef] = ACTIONS(123),
    [anon_sym_new] = ACTIONS(125),
    [sym_const_builtin] = ACTIONS(127),
    [sym_final_builtin] = ACTIONS(129),
    [anon_sym_late] = ACTIONS(131),
    [anon_sym_external] = ACTIONS(133),
    [anon_sym_this] = ACTIONS(135),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_SLASH_SLASH_SLASH] = ACTIONS(7),
    [sym__block_comment] = ACTIONS(9),
    [sym__documentation_block_comment] = ACTIONS(11),
  },
  [22] = {
    [sym__top_level_definition] = STATE(446),
    [sym__literal] = STATE(967),
    [sym_symbol_literal] = STATE(912),
    [sym_true] = STATE(912),
    [sym_false] = STATE(912),
    [sym_string_literal] = STATE(912),
    [sym__string_literal_double_quotes] = STATE(617),
    [sym__string_literal_single_quotes] = STATE(617),
    [sym__string_literal_double_quotes_multiple] = STATE(617),
    [sym__string_literal_single_quotes_multiple] = STATE(617),
    [sym__raw_string_literal_double_quotes] = STATE(617),
    [sym__raw_string_literal_single_quotes] = STATE(617),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(617),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(617),
    [sym_list_literal] = STATE(912),
    [sym_set_or_map_literal] = STATE(912),
    [sym_null_literal] = STATE(912),
    [sym__expression] = STATE(2450),
    [sym__real_expression] = STATE(670),
    [sym_throw_expression] = STATE(976),
    [sym_assignment_expression] = STATE(976),
    [sym_assignable_expression] = STATE(1582),
    [sym_lambda_expression] = STATE(494),
    [sym_function_expression] = STATE(967),
    [sym_if_null_expression] = STATE(1377),
    [sym_conditional_expression] = STATE(1377),
    [sym_logical_or_expression] = STATE(1377),
    [sym_logical_and_expression] = STATE(1377),
    [sym_equality_expression] = STATE(1377),
    [sym_type_cast_expression] = STATE(1377),
    [sym_type_test_expression] = STATE(1377),
    [sym_relational_expression] = STATE(1377),
    [sym_bitwise_or_expression] = STATE(1377),
    [sym_bitwise_xor_expression] = STATE(1377),
    [sym_bitwise_and_expression] = STATE(1377),
    [sym_shift_expression] = STATE(1377),
    [sym_additive_expression] = STATE(1377),
    [sym_multiplicative_expression] = STATE(1377),
    [sym__unary_expression] = STATE(1118),
    [sym_unary_expression] = STATE(1169),
    [sym__postfix_expression] = STATE(1169),
    [sym_postfix_expression] = STATE(1170),
    [sym_prefix_operator] = STATE(360),
    [sym_negation_operator] = STATE(1206),
    [sym_tilde_operator] = STATE(1188),
    [sym_await_expression] = STATE(1171),
    [sym_new_expression] = STATE(967),
    [sym_const_object_expression] = STATE(967),
    [sym__primary] = STATE(641),
    [sym_constructor_invocation] = STATE(638),
    [sym_type_arguments] = STATE(2454),
    [sym__statement] = STATE(532),
    [sym_local_function_declaration] = STATE(491),
    [sym_block] = STATE(488),
    [sym_expression_statement] = STATE(488),
    [sym_assert_statement] = STATE(488),
    [sym_assertion] = STATE(2726),
    [sym_switch_statement] = STATE(488),
    [sym_do_statement] = STATE(488),
    [sym_break_statement] = STATE(488),
    [sym_continue_statement] = STATE(488),
    [sym_yield_statement] = STATE(488),
    [sym_yield_each_statement] = STATE(488),
    [sym_return_statement] = STATE(488),
    [sym_try_statement] = STATE(488),
    [sym__try_head] = STATE(1927),
    [sym_if_statement] = STATE(488),
    [sym_while_statement] = STATE(488),
    [sym_for_statement] = STATE(488),
    [sym__annotation] = STATE(1287),
    [sym_marker_annotation] = STATE(1289),
    [sym_annotation] = STATE(1289),
    [sym_enum_declaration] = STATE(466),
    [sym_type_alias] = STATE(466),
    [sym_class_definition] = STATE(466),
    [sym_extension_declaration] = STATE(466),
    [sym__metadata] = STATE(577),
    [sym_type_parameters] = STATE(2299),
    [sym_mixin_declaration] = STATE(466),
    [sym_getter_signature] = STATE(1770),
    [sym_setter_signature] = STATE(1770),
    [sym_initialized_variable_definition] = STATE(2472),
    [sym__declared_identifier] = STATE(2151),
    [sym__final_const_var_or_type] = STATE(2686),
    [sym__type] = STATE(1955),
    [sym__type_not_function] = STATE(1616),
    [sym__type_not_void_not_function] = STATE(1668),
    [sym_function_type] = STATE(1655),
    [aux_sym__function_type_tails] = STATE(1482),
    [sym__function_type_tail] = STATE(1568),
    [sym__type_name] = STATE(1722),
    [sym__var_or_type] = STATE(2325),
    [sym_inferred_type] = STATE(1644),
    [sym_function_signature] = STATE(1764),
    [sym__formal_parameter_part] = STATE(1915),
    [sym_formal_parameter_list] = STATE(1636),
    [sym__strict_formal_parameter_list] = STATE(1626),
    [sym_local_variable_declaration] = STATE(509),
    [sym__covariant] = STATE(1552),
    [sym__function_builtin_identifier] = STATE(1424),
    [sym__get] = STATE(1952),
    [sym__mixin] = STATE(2576),
    [sym__set] = STATE(1892),
    [sym__typedef] = STATE(1699),
    [sym__new_builtin] = STATE(1701),
    [sym__late_builtin] = STATE(1621),
    [sym__external_builtin] = STATE(1573),
    [sym_this] = STATE(967),
    [sym_super] = STATE(1128),
    [sym_comment] = STATE(22),
    [sym_documentation_comment] = STATE(22),
    [aux_sym_program_repeat4] = STATE(185),
    [aux_sym_program_repeat5] = STATE(53),
    [aux_sym_string_literal_repeat1] = STATE(473),
    [aux_sym__metadata_repeat1] = STATE(1143),
    [ts_builtin_sym_end] = ACTIONS(151),
    [sym_identifier] = ACTIONS(15),
    [anon_sym_POUND] = ACTIONS(139),
    [sym_decimal_integer_literal] = ACTIONS(19),
    [sym_hex_integer_literal] = ACTIONS(21),
    [sym_decimal_floating_point_literal] = ACTIONS(19),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(25),
    [anon_sym_DQUOTE] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_r_DQUOTE] = ACTIONS(35),
    [anon_sym_r_SQUOTE] = ACTIONS(37),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(39),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(43),
    [anon_sym_LBRACK] = ACTIONS(45),
    [anon_sym_null] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_LT] = ACTIONS(53),
    [sym_increment_operator] = ACTIONS(55),
    [sym_minus_operator] = ACTIONS(57),
    [sym__exclamation_operator] = ACTIONS(59),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_await] = ACTIONS(63),
    [anon_sym_switch] = ACTIONS(65),
    [anon_sym_do] = ACTIONS(67),
    [anon_sym_while] = ACTIONS(69),
    [anon_sym_continue] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [anon_sym_return] = ACTIONS(75),
    [anon_sym_try] = ACTIONS(77),
    [anon_sym_if] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_AT] = ACTIONS(83),
    [anon_sym_enum] = ACTIONS(87),
    [anon_sym_abstract] = ACTIONS(89),
    [anon_sym_class] = ACTIONS(91),
    [anon_sym_extension] = ACTIONS(93),
    [anon_sym_super] = ACTIONS(95),
    [sym_void_type] = ACTIONS(97),
    [anon_sym_var] = ACTIONS(99),
    [sym__break_builtin] = ACTIONS(105),
    [sym__assert_builtin] = ACTIONS(107),
    [anon_sym_covariant] = ACTIONS(109),
    [anon_sym_Function] = ACTIONS(113),
    [anon_sym_get] = ACTIONS(115),
    [anon_sym_mixin] = ACTIONS(119),
    [anon_sym_set] = ACTIONS(121),
    [anon_sym_typedef] = ACTIONS(123),
    [anon_sym_new] = ACTIONS(125),
    [sym_const_builtin] = ACTIONS(127),
    [sym_final_builtin] = ACTIONS(129),
    [anon_sym_late] = ACTIONS(131),
    [anon_sym_external] = ACTIONS(133),
    [anon_sym_this] = ACTIONS(135),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_SLASH_SLASH_SLASH] = ACTIONS(7),
    [sym__block_comment] = ACTIONS(9),
    [sym__documentation_block_comment] = ACTIONS(11),
  },
  [23] = {
    [sym__literal] = STATE(967),
    [sym_symbol_literal] = STATE(912),
    [sym_true] = STATE(912),
    [sym_false] = STATE(912),
    [sym_string_literal] = STATE(912),
    [sym__string_literal_double_quotes] = STATE(617),
    [sym__string_literal_single_quotes] = STATE(617),
    [sym__string_literal_double_quotes_multiple] = STATE(617),
    [sym__string_literal_single_quotes_multiple] = STATE(617),
    [sym__raw_string_literal_double_quotes] = STATE(617),
    [sym__raw_string_literal_single_quotes] = STATE(617),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(617),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(617),
    [sym_list_literal] = STATE(912),
    [sym_set_or_map_literal] = STATE(912),
    [sym_pair] = STATE(2134),
    [sym__element] = STATE(2188),
    [sym_null_literal] = STATE(912),
    [sym__expression] = STATE(1969),
    [sym__real_expression] = STATE(670),
    [sym_throw_expression] = STATE(976),
    [sym_assignment_expression] = STATE(976),
    [sym_assignable_expression] = STATE(1582),
    [sym_lambda_expression] = STATE(494),
    [sym_function_expression] = STATE(967),
    [sym_if_null_expression] = STATE(1377),
    [sym_conditional_expression] = STATE(1377),
    [sym_logical_or_expression] = STATE(1377),
    [sym_logical_and_expression] = STATE(1377),
    [sym_equality_expression] = STATE(1377),
    [sym_type_cast_expression] = STATE(1377),
    [sym_type_test_expression] = STATE(1377),
    [sym_relational_expression] = STATE(1377),
    [sym_bitwise_or_expression] = STATE(1377),
    [sym_bitwise_xor_expression] = STATE(1377),
    [sym_bitwise_and_expression] = STATE(1377),
    [sym_shift_expression] = STATE(1377),
    [sym_additive_expression] = STATE(1377),
    [sym_multiplicative_expression] = STATE(1377),
    [sym__unary_expression] = STATE(1118),
    [sym_unary_expression] = STATE(1169),
    [sym__postfix_expression] = STATE(1169),
    [sym_postfix_expression] = STATE(1170),
    [sym_spread_element] = STATE(2134),
    [sym_prefix_operator] = STATE(360),
    [sym_negation_operator] = STATE(1206),
    [sym_tilde_operator] = STATE(1188),
    [sym_await_expression] = STATE(1171),
    [sym_new_expression] = STATE(967),
    [sym_const_object_expression] = STATE(967),
    [sym__primary] = STATE(641),
    [sym_constructor_invocation] = STATE(638),
    [sym_type_arguments] = STATE(2454),
    [sym__statement] = STATE(532),
    [sym_local_function_declaration] = STATE(491),
    [sym_block] = STATE(488),
    [sym_expression_statement] = STATE(488),
    [sym_assert_statement] = STATE(488),
    [sym_assertion] = STATE(2726),
    [sym_switch_statement] = STATE(488),
    [sym_do_statement] = STATE(488),
    [sym_break_statement] = STATE(488),
    [sym_continue_statement] = STATE(488),
    [sym_yield_statement] = STATE(488),
    [sym_yield_each_statement] = STATE(488),
    [sym_return_statement] = STATE(488),
    [sym_try_statement] = STATE(488),
    [sym__try_head] = STATE(1927),
    [sym_if_element] = STATE(2134),
    [sym_if_statement] = STATE(488),
    [sym_while_statement] = STATE(488),
    [sym_for_statement] = STATE(488),
    [sym_for_element] = STATE(2134),
    [sym__annotation] = STATE(1287),
    [sym_marker_annotation] = STATE(1289),
    [sym_annotation] = STATE(1289),
    [sym__metadata] = STATE(1359),
    [sym_type_parameters] = STATE(2299),
    [sym_initialized_variable_definition] = STATE(2472),
    [sym__declared_identifier] = STATE(2151),
    [sym__final_const_var_or_type] = STATE(2686),
    [sym__type] = STATE(2047),
    [sym__type_not_function] = STATE(1616),
    [sym__type_not_void_not_function] = STATE(1668),
    [sym_function_type] = STATE(1655),
    [aux_sym__function_type_tails] = STATE(1482),
    [sym__function_type_tail] = STATE(1568),
    [sym__type_name] = STATE(1722),
    [sym__var_or_type] = STATE(2325),
    [sym_inferred_type] = STATE(1653),
    [sym_function_signature] = STATE(1879),
    [sym__formal_parameter_part] = STATE(1915),
    [sym_formal_parameter_list] = STATE(1636),
    [sym__strict_formal_parameter_list] = STATE(1626),
    [sym_local_variable_declaration] = STATE(509),
    [sym__covariant] = STATE(1552),
    [sym__function_builtin_identifier] = STATE(1424),
    [sym__get] = STATE(1992),
    [sym__set] = STATE(1992),
    [sym__new_builtin] = STATE(1701),
    [sym__late_builtin] = STATE(1618),
    [sym_this] = STATE(967),
    [sym_super] = STATE(1128),
    [sym_comment] = STATE(23),
    [sym_documentation_comment] = STATE(23),
    [aux_sym_program_repeat5] = STATE(38),
    [aux_sym_string_literal_repeat1] = STATE(473),
    [aux_sym__metadata_repeat1] = STATE(1143),
    [sym_identifier] = ACTIONS(15),
    [anon_sym_POUND] = ACTIONS(139),
    [sym_decimal_integer_literal] = ACTIONS(19),
    [sym_hex_integer_literal] = ACTIONS(21),
    [sym_decimal_floating_point_literal] = ACTIONS(19),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(25),
    [anon_sym_DQUOTE] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_r_DQUOTE] = ACTIONS(35),
    [anon_sym_r_SQUOTE] = ACTIONS(37),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(39),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(43),
    [anon_sym_RBRACE] = ACTIONS(153),
    [anon_sym_LBRACK] = ACTIONS(45),
    [anon_sym_null] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_LT] = ACTIONS(53),
    [sym_increment_operator] = ACTIONS(55),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(155),
    [sym_minus_operator] = ACTIONS(57),
    [sym__exclamation_operator] = ACTIONS(59),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_await] = ACTIONS(157),
    [anon_sym_switch] = ACTIONS(65),
    [anon_sym_do] = ACTIONS(67),
    [anon_sym_while] = ACTIONS(159),
    [anon_sym_continue] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [anon_sym_return] = ACTIONS(75),
    [anon_sym_try] = ACTIONS(77),
    [anon_sym_if] = ACTIONS(161),
    [anon_sym_for] = ACTIONS(163),
    [anon_sym_AT] = ACTIONS(83),
    [anon_sym_super] = ACTIONS(95),
    [sym_void_type] = ACTIONS(97),
    [anon_sym_var] = ACTIONS(99),
    [sym__break_builtin] = ACTIONS(105),
    [sym__assert_builtin] = ACTIONS(107),
    [anon_sym_covariant] = ACTIONS(109),
    [anon_sym_Function] = ACTIONS(113),
    [anon_sym_get] = ACTIONS(115),
    [anon_sym_set] = ACTIONS(121),
    [anon_sym_new] = ACTIONS(125),
    [sym_const_builtin] = ACTIONS(165),
    [sym_final_builtin] = ACTIONS(167),
    [anon_sym_late] = ACTIONS(131),
    [anon_sym_this] = ACTIONS(135),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_SLASH_SLASH_SLASH] = ACTIONS(7),
    [sym__block_comment] = ACTIONS(9),
    [sym__documentation_block_comment] = ACTIONS(11),
  },
  [24] = {
    [sym__literal] = STATE(967),
    [sym_symbol_literal] = STATE(912),
    [sym_true] = STATE(912),
    [sym_false] = STATE(912),
    [sym_string_literal] = STATE(912),
    [sym__string_literal_double_quotes] = STATE(617),
    [sym__string_literal_single_quotes] = STATE(617),
    [sym__string_literal_double_quotes_multiple] = STATE(617),
    [sym__string_literal_single_quotes_multiple] = STATE(617),
    [sym__raw_string_literal_double_quotes] = STATE(617),
    [sym__raw_string_literal_single_quotes] = STATE(617),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(617),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(617),
    [sym_list_literal] = STATE(912),
    [sym_set_or_map_literal] = STATE(912),
    [sym_pair] = STATE(2134),
    [sym__element] = STATE(2188),
    [sym_null_literal] = STATE(912),
    [sym__expression] = STATE(1969),
    [sym__real_expression] = STATE(670),
    [sym_throw_expression] = STATE(976),
    [sym_assignment_expression] = STATE(976),
    [sym_assignable_expression] = STATE(1582),
    [sym_lambda_expression] = STATE(494),
    [sym_function_expression] = STATE(967),
    [sym_if_null_expression] = STATE(1377),
    [sym_conditional_expression] = STATE(1377),
    [sym_logical_or_expression] = STATE(1377),
    [sym_logical_and_expression] = STATE(1377),
    [sym_equality_expression] = STATE(1377),
    [sym_type_cast_expression] = STATE(1377),
    [sym_type_test_expression] = STATE(1377),
    [sym_relational_expression] = STATE(1377),
    [sym_bitwise_or_expression] = STATE(1377),
    [sym_bitwise_xor_expression] = STATE(1377),
    [sym_bitwise_and_expression] = STATE(1377),
    [sym_shift_expression] = STATE(1377),
    [sym_additive_expression] = STATE(1377),
    [sym_multiplicative_expression] = STATE(1377),
    [sym__unary_expression] = STATE(1118),
    [sym_unary_expression] = STATE(1169),
    [sym__postfix_expression] = STATE(1169),
    [sym_postfix_expression] = STATE(1170),
    [sym_spread_element] = STATE(2134),
    [sym_prefix_operator] = STATE(360),
    [sym_negation_operator] = STATE(1206),
    [sym_tilde_operator] = STATE(1188),
    [sym_await_expression] = STATE(1171),
    [sym_new_expression] = STATE(967),
    [sym_const_object_expression] = STATE(967),
    [sym__primary] = STATE(641),
    [sym_constructor_invocation] = STATE(638),
    [sym_type_arguments] = STATE(2454),
    [sym__statement] = STATE(532),
    [sym_local_function_declaration] = STATE(491),
    [sym_block] = STATE(488),
    [sym_expression_statement] = STATE(488),
    [sym_assert_statement] = STATE(488),
    [sym_assertion] = STATE(2726),
    [sym_switch_statement] = STATE(488),
    [sym_do_statement] = STATE(488),
    [sym_break_statement] = STATE(488),
    [sym_continue_statement] = STATE(488),
    [sym_yield_statement] = STATE(488),
    [sym_yield_each_statement] = STATE(488),
    [sym_return_statement] = STATE(488),
    [sym_try_statement] = STATE(488),
    [sym__try_head] = STATE(1927),
    [sym_if_element] = STATE(2134),
    [sym_if_statement] = STATE(488),
    [sym_while_statement] = STATE(488),
    [sym_for_statement] = STATE(488),
    [sym_for_element] = STATE(2134),
    [sym__annotation] = STATE(1287),
    [sym_marker_annotation] = STATE(1289),
    [sym_annotation] = STATE(1289),
    [sym__metadata] = STATE(1359),
    [sym_type_parameters] = STATE(2299),
    [sym_initialized_variable_definition] = STATE(2472),
    [sym__declared_identifier] = STATE(2151),
    [sym__final_const_var_or_type] = STATE(2686),
    [sym__type] = STATE(2047),
    [sym__type_not_function] = STATE(1616),
    [sym__type_not_void_not_function] = STATE(1668),
    [sym_function_type] = STATE(1655),
    [aux_sym__function_type_tails] = STATE(1482),
    [sym__function_type_tail] = STATE(1568),
    [sym__type_name] = STATE(1722),
    [sym__var_or_type] = STATE(2325),
    [sym_inferred_type] = STATE(1653),
    [sym_function_signature] = STATE(1879),
    [sym__formal_parameter_part] = STATE(1915),
    [sym_formal_parameter_list] = STATE(1636),
    [sym__strict_formal_parameter_list] = STATE(1626),
    [sym_local_variable_declaration] = STATE(509),
    [sym__covariant] = STATE(1552),
    [sym__function_builtin_identifier] = STATE(1424),
    [sym__get] = STATE(1992),
    [sym__set] = STATE(1992),
    [sym__new_builtin] = STATE(1701),
    [sym__late_builtin] = STATE(1618),
    [sym_this] = STATE(967),
    [sym_super] = STATE(1128),
    [sym_comment] = STATE(24),
    [sym_documentation_comment] = STATE(24),
    [aux_sym_program_repeat5] = STATE(38),
    [aux_sym_string_literal_repeat1] = STATE(473),
    [aux_sym__metadata_repeat1] = STATE(1143),
    [sym_identifier] = ACTIONS(15),
    [anon_sym_POUND] = ACTIONS(139),
    [sym_decimal_integer_literal] = ACTIONS(19),
    [sym_hex_integer_literal] = ACTIONS(21),
    [sym_decimal_floating_point_literal] = ACTIONS(19),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(25),
    [anon_sym_DQUOTE] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_r_DQUOTE] = ACTIONS(35),
    [anon_sym_r_SQUOTE] = ACTIONS(37),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(39),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(43),
    [anon_sym_RBRACE] = ACTIONS(169),
    [anon_sym_LBRACK] = ACTIONS(45),
    [anon_sym_null] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_LT] = ACTIONS(53),
    [sym_increment_operator] = ACTIONS(55),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(155),
    [sym_minus_operator] = ACTIONS(57),
    [sym__exclamation_operator] = ACTIONS(59),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_await] = ACTIONS(157),
    [anon_sym_switch] = ACTIONS(65),
    [anon_sym_do] = ACTIONS(67),
    [anon_sym_while] = ACTIONS(159),
    [anon_sym_continue] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [anon_sym_return] = ACTIONS(75),
    [anon_sym_try] = ACTIONS(77),
    [anon_sym_if] = ACTIONS(161),
    [anon_sym_for] = ACTIONS(163),
    [anon_sym_AT] = ACTIONS(83),
    [anon_sym_super] = ACTIONS(95),
    [sym_void_type] = ACTIONS(97),
    [anon_sym_var] = ACTIONS(99),
    [sym__break_builtin] = ACTIONS(105),
    [sym__assert_builtin] = ACTIONS(107),
    [anon_sym_covariant] = ACTIONS(109),
    [anon_sym_Function] = ACTIONS(113),
    [anon_sym_get] = ACTIONS(115),
    [anon_sym_set] = ACTIONS(121),
    [anon_sym_new] = ACTIONS(125),
    [sym_const_builtin] = ACTIONS(165),
    [sym_final_builtin] = ACTIONS(167),
    [anon_sym_late] = ACTIONS(131),
    [anon_sym_this] = ACTIONS(135),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_SLASH_SLASH_SLASH] = ACTIONS(7),
    [sym__block_comment] = ACTIONS(9),
    [sym__documentation_block_comment] = ACTIONS(11),
  },
  [25] = {
    [sym__literal] = STATE(967),
    [sym_symbol_literal] = STATE(912),
    [sym_true] = STATE(912),
    [sym_false] = STATE(912),
    [sym_string_literal] = STATE(912),
    [sym__string_literal_double_quotes] = STATE(617),
    [sym__string_literal_single_quotes] = STATE(617),
    [sym__string_literal_double_quotes_multiple] = STATE(617),
    [sym__string_literal_single_quotes_multiple] = STATE(617),
    [sym__raw_string_literal_double_quotes] = STATE(617),
    [sym__raw_string_literal_single_quotes] = STATE(617),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(617),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(617),
    [sym_list_literal] = STATE(912),
    [sym_set_or_map_literal] = STATE(912),
    [sym_pair] = STATE(2134),
    [sym__element] = STATE(2188),
    [sym_null_literal] = STATE(912),
    [sym__expression] = STATE(1969),
    [sym__real_expression] = STATE(670),
    [sym_throw_expression] = STATE(976),
    [sym_assignment_expression] = STATE(976),
    [sym_assignable_expression] = STATE(1582),
    [sym_lambda_expression] = STATE(494),
    [sym_function_expression] = STATE(967),
    [sym_if_null_expression] = STATE(1377),
    [sym_conditional_expression] = STATE(1377),
    [sym_logical_or_expression] = STATE(1377),
    [sym_logical_and_expression] = STATE(1377),
    [sym_equality_expression] = STATE(1377),
    [sym_type_cast_expression] = STATE(1377),
    [sym_type_test_expression] = STATE(1377),
    [sym_relational_expression] = STATE(1377),
    [sym_bitwise_or_expression] = STATE(1377),
    [sym_bitwise_xor_expression] = STATE(1377),
    [sym_bitwise_and_expression] = STATE(1377),
    [sym_shift_expression] = STATE(1377),
    [sym_additive_expression] = STATE(1377),
    [sym_multiplicative_expression] = STATE(1377),
    [sym__unary_expression] = STATE(1118),
    [sym_unary_expression] = STATE(1169),
    [sym__postfix_expression] = STATE(1169),
    [sym_postfix_expression] = STATE(1170),
    [sym_spread_element] = STATE(2134),
    [sym_prefix_operator] = STATE(360),
    [sym_negation_operator] = STATE(1206),
    [sym_tilde_operator] = STATE(1188),
    [sym_await_expression] = STATE(1171),
    [sym_new_expression] = STATE(967),
    [sym_const_object_expression] = STATE(967),
    [sym__primary] = STATE(641),
    [sym_constructor_invocation] = STATE(638),
    [sym_type_arguments] = STATE(2454),
    [sym__statement] = STATE(532),
    [sym_local_function_declaration] = STATE(491),
    [sym_block] = STATE(488),
    [sym_expression_statement] = STATE(488),
    [sym_assert_statement] = STATE(488),
    [sym_assertion] = STATE(2726),
    [sym_switch_statement] = STATE(488),
    [sym_do_statement] = STATE(488),
    [sym_break_statement] = STATE(488),
    [sym_continue_statement] = STATE(488),
    [sym_yield_statement] = STATE(488),
    [sym_yield_each_statement] = STATE(488),
    [sym_return_statement] = STATE(488),
    [sym_try_statement] = STATE(488),
    [sym__try_head] = STATE(1927),
    [sym_if_element] = STATE(2134),
    [sym_if_statement] = STATE(488),
    [sym_while_statement] = STATE(488),
    [sym_for_statement] = STATE(488),
    [sym_for_element] = STATE(2134),
    [sym__annotation] = STATE(1287),
    [sym_marker_annotation] = STATE(1289),
    [sym_annotation] = STATE(1289),
    [sym__metadata] = STATE(1359),
    [sym_type_parameters] = STATE(2299),
    [sym_initialized_variable_definition] = STATE(2472),
    [sym__declared_identifier] = STATE(2151),
    [sym__final_const_var_or_type] = STATE(2686),
    [sym__type] = STATE(2047),
    [sym__type_not_function] = STATE(1616),
    [sym__type_not_void_not_function] = STATE(1668),
    [sym_function_type] = STATE(1655),
    [aux_sym__function_type_tails] = STATE(1482),
    [sym__function_type_tail] = STATE(1568),
    [sym__type_name] = STATE(1722),
    [sym__var_or_type] = STATE(2325),
    [sym_inferred_type] = STATE(1653),
    [sym_function_signature] = STATE(1879),
    [sym__formal_parameter_part] = STATE(1915),
    [sym_formal_parameter_list] = STATE(1636),
    [sym__strict_formal_parameter_list] = STATE(1626),
    [sym_local_variable_declaration] = STATE(509),
    [sym__covariant] = STATE(1552),
    [sym__function_builtin_identifier] = STATE(1424),
    [sym__get] = STATE(1992),
    [sym__set] = STATE(1992),
    [sym__new_builtin] = STATE(1701),
    [sym__late_builtin] = STATE(1618),
    [sym_this] = STATE(967),
    [sym_super] = STATE(1128),
    [sym_comment] = STATE(25),
    [sym_documentation_comment] = STATE(25),
    [aux_sym_program_repeat5] = STATE(38),
    [aux_sym_string_literal_repeat1] = STATE(473),
    [aux_sym__metadata_repeat1] = STATE(1143),
    [sym_identifier] = ACTIONS(15),
    [anon_sym_POUND] = ACTIONS(139),
    [sym_decimal_integer_literal] = ACTIONS(19),
    [sym_hex_integer_literal] = ACTIONS(21),
    [sym_decimal_floating_point_literal] = ACTIONS(19),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(25),
    [anon_sym_DQUOTE] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_r_DQUOTE] = ACTIONS(35),
    [anon_sym_r_SQUOTE] = ACTIONS(37),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(39),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(43),
    [anon_sym_RBRACE] = ACTIONS(171),
    [anon_sym_LBRACK] = ACTIONS(45),
    [anon_sym_null] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_LT] = ACTIONS(53),
    [sym_increment_operator] = ACTIONS(55),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(155),
    [sym_minus_operator] = ACTIONS(57),
    [sym__exclamation_operator] = ACTIONS(59),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_await] = ACTIONS(157),
    [anon_sym_switch] = ACTIONS(65),
    [anon_sym_do] = ACTIONS(67),
    [anon_sym_while] = ACTIONS(159),
    [anon_sym_continue] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [anon_sym_return] = ACTIONS(75),
    [anon_sym_try] = ACTIONS(77),
    [anon_sym_if] = ACTIONS(161),
    [anon_sym_for] = ACTIONS(163),
    [anon_sym_AT] = ACTIONS(83),
    [anon_sym_super] = ACTIONS(95),
    [sym_void_type] = ACTIONS(97),
    [anon_sym_var] = ACTIONS(99),
    [sym__break_builtin] = ACTIONS(105),
    [sym__assert_builtin] = ACTIONS(107),
    [anon_sym_covariant] = ACTIONS(109),
    [anon_sym_Function] = ACTIONS(113),
    [anon_sym_get] = ACTIONS(115),
    [anon_sym_set] = ACTIONS(121),
    [anon_sym_new] = ACTIONS(125),
    [sym_const_builtin] = ACTIONS(165),
    [sym_final_builtin] = ACTIONS(167),
    [anon_sym_late] = ACTIONS(131),
    [anon_sym_this] = ACTIONS(135),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_SLASH_SLASH_SLASH] = ACTIONS(7),
    [sym__block_comment] = ACTIONS(9),
    [sym__documentation_block_comment] = ACTIONS(11),
  },
  [26] = {
    [sym__literal] = STATE(967),
    [sym_symbol_literal] = STATE(912),
    [sym_true] = STATE(912),
    [sym_false] = STATE(912),
    [sym_string_literal] = STATE(912),
    [sym__string_literal_double_quotes] = STATE(617),
    [sym__string_literal_single_quotes] = STATE(617),
    [sym__string_literal_double_quotes_multiple] = STATE(617),
    [sym__string_literal_single_quotes_multiple] = STATE(617),
    [sym__raw_string_literal_double_quotes] = STATE(617),
    [sym__raw_string_literal_single_quotes] = STATE(617),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(617),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(617),
    [sym_list_literal] = STATE(912),
    [sym_set_or_map_literal] = STATE(912),
    [sym_pair] = STATE(2134),
    [sym__element] = STATE(2188),
    [sym_null_literal] = STATE(912),
    [sym__expression] = STATE(1969),
    [sym__real_expression] = STATE(670),
    [sym_throw_expression] = STATE(976),
    [sym_assignment_expression] = STATE(976),
    [sym_assignable_expression] = STATE(1582),
    [sym_lambda_expression] = STATE(494),
    [sym_function_expression] = STATE(967),
    [sym_if_null_expression] = STATE(1377),
    [sym_conditional_expression] = STATE(1377),
    [sym_logical_or_expression] = STATE(1377),
    [sym_logical_and_expression] = STATE(1377),
    [sym_equality_expression] = STATE(1377),
    [sym_type_cast_expression] = STATE(1377),
    [sym_type_test_expression] = STATE(1377),
    [sym_relational_expression] = STATE(1377),
    [sym_bitwise_or_expression] = STATE(1377),
    [sym_bitwise_xor_expression] = STATE(1377),
    [sym_bitwise_and_expression] = STATE(1377),
    [sym_shift_expression] = STATE(1377),
    [sym_additive_expression] = STATE(1377),
    [sym_multiplicative_expression] = STATE(1377),
    [sym__unary_expression] = STATE(1118),
    [sym_unary_expression] = STATE(1169),
    [sym__postfix_expression] = STATE(1169),
    [sym_postfix_expression] = STATE(1170),
    [sym_spread_element] = STATE(2134),
    [sym_prefix_operator] = STATE(360),
    [sym_negation_operator] = STATE(1206),
    [sym_tilde_operator] = STATE(1188),
    [sym_await_expression] = STATE(1171),
    [sym_new_expression] = STATE(967),
    [sym_const_object_expression] = STATE(967),
    [sym__primary] = STATE(641),
    [sym_constructor_invocation] = STATE(638),
    [sym_type_arguments] = STATE(2454),
    [sym__statement] = STATE(532),
    [sym_local_function_declaration] = STATE(491),
    [sym_block] = STATE(488),
    [sym_expression_statement] = STATE(488),
    [sym_assert_statement] = STATE(488),
    [sym_assertion] = STATE(2726),
    [sym_switch_statement] = STATE(488),
    [sym_do_statement] = STATE(488),
    [sym_break_statement] = STATE(488),
    [sym_continue_statement] = STATE(488),
    [sym_yield_statement] = STATE(488),
    [sym_yield_each_statement] = STATE(488),
    [sym_return_statement] = STATE(488),
    [sym_try_statement] = STATE(488),
    [sym__try_head] = STATE(1927),
    [sym_if_element] = STATE(2134),
    [sym_if_statement] = STATE(488),
    [sym_while_statement] = STATE(488),
    [sym_for_statement] = STATE(488),
    [sym_for_element] = STATE(2134),
    [sym__annotation] = STATE(1287),
    [sym_marker_annotation] = STATE(1289),
    [sym_annotation] = STATE(1289),
    [sym__metadata] = STATE(1359),
    [sym_type_parameters] = STATE(2299),
    [sym_initialized_variable_definition] = STATE(2472),
    [sym__declared_identifier] = STATE(2151),
    [sym__final_const_var_or_type] = STATE(2686),
    [sym__type] = STATE(2047),
    [sym__type_not_function] = STATE(1616),
    [sym__type_not_void_not_function] = STATE(1668),
    [sym_function_type] = STATE(1655),
    [aux_sym__function_type_tails] = STATE(1482),
    [sym__function_type_tail] = STATE(1568),
    [sym__type_name] = STATE(1722),
    [sym__var_or_type] = STATE(2325),
    [sym_inferred_type] = STATE(1653),
    [sym_function_signature] = STATE(1879),
    [sym__formal_parameter_part] = STATE(1915),
    [sym_formal_parameter_list] = STATE(1636),
    [sym__strict_formal_parameter_list] = STATE(1626),
    [sym_local_variable_declaration] = STATE(509),
    [sym__covariant] = STATE(1552),
    [sym__function_builtin_identifier] = STATE(1424),
    [sym__get] = STATE(1992),
    [sym__set] = STATE(1992),
    [sym__new_builtin] = STATE(1701),
    [sym__late_builtin] = STATE(1618),
    [sym_this] = STATE(967),
    [sym_super] = STATE(1128),
    [sym_comment] = STATE(26),
    [sym_documentation_comment] = STATE(26),
    [aux_sym_program_repeat5] = STATE(38),
    [aux_sym_string_literal_repeat1] = STATE(473),
    [aux_sym__metadata_repeat1] = STATE(1143),
    [sym_identifier] = ACTIONS(15),
    [anon_sym_POUND] = ACTIONS(139),
    [sym_decimal_integer_literal] = ACTIONS(19),
    [sym_hex_integer_literal] = ACTIONS(21),
    [sym_decimal_floating_point_literal] = ACTIONS(19),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(25),
    [anon_sym_DQUOTE] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_r_DQUOTE] = ACTIONS(35),
    [anon_sym_r_SQUOTE] = ACTIONS(37),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(39),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(43),
    [anon_sym_RBRACE] = ACTIONS(173),
    [anon_sym_LBRACK] = ACTIONS(45),
    [anon_sym_null] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_LT] = ACTIONS(53),
    [sym_increment_operator] = ACTIONS(55),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(155),
    [sym_minus_operator] = ACTIONS(57),
    [sym__exclamation_operator] = ACTIONS(59),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_await] = ACTIONS(157),
    [anon_sym_switch] = ACTIONS(65),
    [anon_sym_do] = ACTIONS(67),
    [anon_sym_while] = ACTIONS(159),
    [anon_sym_continue] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [anon_sym_return] = ACTIONS(75),
    [anon_sym_try] = ACTIONS(77),
    [anon_sym_if] = ACTIONS(161),
    [anon_sym_for] = ACTIONS(163),
    [anon_sym_AT] = ACTIONS(83),
    [anon_sym_super] = ACTIONS(95),
    [sym_void_type] = ACTIONS(97),
    [anon_sym_var] = ACTIONS(99),
    [sym__break_builtin] = ACTIONS(105),
    [sym__assert_builtin] = ACTIONS(107),
    [anon_sym_covariant] = ACTIONS(109),
    [anon_sym_Function] = ACTIONS(113),
    [anon_sym_get] = ACTIONS(115),
    [anon_sym_set] = ACTIONS(121),
    [anon_sym_new] = ACTIONS(125),
    [sym_const_builtin] = ACTIONS(165),
    [sym_final_builtin] = ACTIONS(167),
    [anon_sym_late] = ACTIONS(131),
    [anon_sym_this] = ACTIONS(135),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_SLASH_SLASH_SLASH] = ACTIONS(7),
    [sym__block_comment] = ACTIONS(9),
    [sym__documentation_block_comment] = ACTIONS(11),
  },
  [27] = {
    [sym__literal] = STATE(967),
    [sym_symbol_literal] = STATE(912),
    [sym_true] = STATE(912),
    [sym_false] = STATE(912),
    [sym_string_literal] = STATE(912),
    [sym__string_literal_double_quotes] = STATE(617),
    [sym__string_literal_single_quotes] = STATE(617),
    [sym__string_literal_double_quotes_multiple] = STATE(617),
    [sym__string_literal_single_quotes_multiple] = STATE(617),
    [sym__raw_string_literal_double_quotes] = STATE(617),
    [sym__raw_string_literal_single_quotes] = STATE(617),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(617),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(617),
    [sym_list_literal] = STATE(912),
    [sym_set_or_map_literal] = STATE(912),
    [sym_null_literal] = STATE(912),
    [sym__expression] = STATE(2450),
    [sym__real_expression] = STATE(670),
    [sym_throw_expression] = STATE(976),
    [sym_assignment_expression] = STATE(976),
    [sym_assignable_expression] = STATE(1582),
    [sym_lambda_expression] = STATE(494),
    [sym_function_expression] = STATE(967),
    [sym_if_null_expression] = STATE(1377),
    [sym_conditional_expression] = STATE(1377),
    [sym_logical_or_expression] = STATE(1377),
    [sym_logical_and_expression] = STATE(1377),
    [sym_equality_expression] = STATE(1377),
    [sym_type_cast_expression] = STATE(1377),
    [sym_type_test_expression] = STATE(1377),
    [sym_relational_expression] = STATE(1377),
    [sym_bitwise_or_expression] = STATE(1377),
    [sym_bitwise_xor_expression] = STATE(1377),
    [sym_bitwise_and_expression] = STATE(1377),
    [sym_shift_expression] = STATE(1377),
    [sym_additive_expression] = STATE(1377),
    [sym_multiplicative_expression] = STATE(1377),
    [sym__unary_expression] = STATE(1118),
    [sym_unary_expression] = STATE(1169),
    [sym__postfix_expression] = STATE(1169),
    [sym_postfix_expression] = STATE(1170),
    [sym_prefix_operator] = STATE(360),
    [sym_negation_operator] = STATE(1206),
    [sym_tilde_operator] = STATE(1188),
    [sym_await_expression] = STATE(1171),
    [sym_new_expression] = STATE(967),
    [sym_const_object_expression] = STATE(967),
    [sym__primary] = STATE(641),
    [sym_constructor_invocation] = STATE(638),
    [sym_type_arguments] = STATE(2454),
    [sym__statement] = STATE(527),
    [sym_local_function_declaration] = STATE(491),
    [sym_block] = STATE(488),
    [sym_expression_statement] = STATE(488),
    [sym_assert_statement] = STATE(488),
    [sym_assertion] = STATE(2726),
    [sym_switch_statement] = STATE(488),
    [sym_switch_label] = STATE(527),
    [sym_do_statement] = STATE(488),
    [sym_break_statement] = STATE(488),
    [sym_continue_statement] = STATE(488),
    [sym_yield_statement] = STATE(488),
    [sym_yield_each_statement] = STATE(488),
    [sym_return_statement] = STATE(488),
    [sym_try_statement] = STATE(488),
    [sym__try_head] = STATE(1927),
    [sym_if_statement] = STATE(488),
    [sym_while_statement] = STATE(488),
    [sym_for_statement] = STATE(488),
    [sym__annotation] = STATE(1287),
    [sym_marker_annotation] = STATE(1289),
    [sym_annotation] = STATE(1289),
    [sym__metadata] = STATE(1359),
    [sym_type_parameters] = STATE(2299),
    [sym_initialized_variable_definition] = STATE(2472),
    [sym__declared_identifier] = STATE(2151),
    [sym__final_const_var_or_type] = STATE(2686),
    [sym__type] = STATE(2047),
    [sym__type_not_function] = STATE(1616),
    [sym__type_not_void_not_function] = STATE(1668),
    [sym_function_type] = STATE(1655),
    [aux_sym__function_type_tails] = STATE(1482),
    [sym__function_type_tail] = STATE(1568),
    [sym__type_name] = STATE(1722),
    [sym__var_or_type] = STATE(2325),
    [sym_inferred_type] = STATE(1653),
    [sym_function_signature] = STATE(1879),
    [sym__formal_parameter_part] = STATE(1915),
    [sym_formal_parameter_list] = STATE(1636),
    [sym__strict_formal_parameter_list] = STATE(1626),
    [sym_local_variable_declaration] = STATE(509),
    [sym__covariant] = STATE(1552),
    [sym__function_builtin_identifier] = STATE(1424),
    [sym__get] = STATE(1992),
    [sym__set] = STATE(1992),
    [sym__new_builtin] = STATE(1701),
    [sym__late_builtin] = STATE(1618),
    [sym_this] = STATE(967),
    [sym_super] = STATE(1128),
    [sym_label] = STATE(2346),
    [sym_comment] = STATE(27),
    [sym_documentation_comment] = STATE(27),
    [aux_sym_string_literal_repeat1] = STATE(473),
    [aux_sym_switch_block_repeat1] = STATE(28),
    [aux_sym_switch_case_repeat1] = STATE(2091),
    [aux_sym__metadata_repeat1] = STATE(1143),
    [sym_identifier] = ACTIONS(175),
    [anon_sym_POUND] = ACTIONS(139),
    [sym_decimal_integer_literal] = ACTIONS(19),
    [sym_hex_integer_literal] = ACTIONS(21),
    [sym_decimal_floating_point_literal] = ACTIONS(19),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(25),
    [anon_sym_DQUOTE] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_r_DQUOTE] = ACTIONS(35),
    [anon_sym_r_SQUOTE] = ACTIONS(37),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(39),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(177),
    [anon_sym_RBRACE] = ACTIONS(179),
    [anon_sym_LBRACK] = ACTIONS(45),
    [anon_sym_null] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_LT] = ACTIONS(53),
    [sym_increment_operator] = ACTIONS(55),
    [sym_minus_operator] = ACTIONS(57),
    [sym__exclamation_operator] = ACTIONS(59),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_await] = ACTIONS(181),
    [anon_sym_switch] = ACTIONS(65),
    [anon_sym_default] = ACTIONS(183),
    [anon_sym_do] = ACTIONS(67),
    [anon_sym_while] = ACTIONS(159),
    [anon_sym_continue] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [anon_sym_return] = ACTIONS(75),
    [anon_sym_try] = ACTIONS(77),
    [anon_sym_if] = ACTIONS(185),
    [anon_sym_for] = ACTIONS(187),
    [anon_sym_AT] = ACTIONS(83),
    [anon_sym_super] = ACTIONS(95),
    [sym_void_type] = ACTIONS(97),
    [anon_sym_var] = ACTIONS(99),
    [sym__break_builtin] = ACTIONS(105),
    [sym__assert_builtin] = ACTIONS(107),
    [sym_case_builtin] = ACTIONS(189),
    [anon_sym_covariant] = ACTIONS(109),
    [anon_sym_Function] = ACTIONS(113),
    [anon_sym_get] = ACTIONS(115),
    [anon_sym_set] = ACTIONS(121),
    [anon_sym_new] = ACTIONS(125),
    [sym_const_builtin] = ACTIONS(165),
    [sym_final_builtin] = ACTIONS(167),
    [anon_sym_late] = ACTIONS(131),
    [anon_sym_this] = ACTIONS(135),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_SLASH_SLASH_SLASH] = ACTIONS(7),
    [sym__block_comment] = ACTIONS(9),
    [sym__documentation_block_comment] = ACTIONS(11),
  },
  [28] = {
    [sym__literal] = STATE(967),
    [sym_symbol_literal] = STATE(912),
    [sym_true] = STATE(912),
    [sym_false] = STATE(912),
    [sym_string_literal] = STATE(912),
    [sym__string_literal_double_quotes] = STATE(617),
    [sym__string_literal_single_quotes] = STATE(617),
    [sym__string_literal_double_quotes_multiple] = STATE(617),
    [sym__string_literal_single_quotes_multiple] = STATE(617),
    [sym__raw_string_literal_double_quotes] = STATE(617),
    [sym__raw_string_literal_single_quotes] = STATE(617),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(617),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(617),
    [sym_list_literal] = STATE(912),
    [sym_set_or_map_literal] = STATE(912),
    [sym_null_literal] = STATE(912),
    [sym__expression] = STATE(2450),
    [sym__real_expression] = STATE(670),
    [sym_throw_expression] = STATE(976),
    [sym_assignment_expression] = STATE(976),
    [sym_assignable_expression] = STATE(1582),
    [sym_lambda_expression] = STATE(494),
    [sym_function_expression] = STATE(967),
    [sym_if_null_expression] = STATE(1377),
    [sym_conditional_expression] = STATE(1377),
    [sym_logical_or_expression] = STATE(1377),
    [sym_logical_and_expression] = STATE(1377),
    [sym_equality_expression] = STATE(1377),
    [sym_type_cast_expression] = STATE(1377),
    [sym_type_test_expression] = STATE(1377),
    [sym_relational_expression] = STATE(1377),
    [sym_bitwise_or_expression] = STATE(1377),
    [sym_bitwise_xor_expression] = STATE(1377),
    [sym_bitwise_and_expression] = STATE(1377),
    [sym_shift_expression] = STATE(1377),
    [sym_additive_expression] = STATE(1377),
    [sym_multiplicative_expression] = STATE(1377),
    [sym__unary_expression] = STATE(1118),
    [sym_unary_expression] = STATE(1169),
    [sym__postfix_expression] = STATE(1169),
    [sym_postfix_expression] = STATE(1170),
    [sym_prefix_operator] = STATE(360),
    [sym_negation_operator] = STATE(1206),
    [sym_tilde_operator] = STATE(1188),
    [sym_await_expression] = STATE(1171),
    [sym_new_expression] = STATE(967),
    [sym_const_object_expression] = STATE(967),
    [sym__primary] = STATE(641),
    [sym_constructor_invocation] = STATE(638),
    [sym_type_arguments] = STATE(2454),
    [sym__statement] = STATE(527),
    [sym_local_function_declaration] = STATE(491),
    [sym_block] = STATE(488),
    [sym_expression_statement] = STATE(488),
    [sym_assert_statement] = STATE(488),
    [sym_assertion] = STATE(2726),
    [sym_switch_statement] = STATE(488),
    [sym_switch_label] = STATE(527),
    [sym_do_statement] = STATE(488),
    [sym_break_statement] = STATE(488),
    [sym_continue_statement] = STATE(488),
    [sym_yield_statement] = STATE(488),
    [sym_yield_each_statement] = STATE(488),
    [sym_return_statement] = STATE(488),
    [sym_try_statement] = STATE(488),
    [sym__try_head] = STATE(1927),
    [sym_if_statement] = STATE(488),
    [sym_while_statement] = STATE(488),
    [sym_for_statement] = STATE(488),
    [sym__annotation] = STATE(1287),
    [sym_marker_annotation] = STATE(1289),
    [sym_annotation] = STATE(1289),
    [sym__metadata] = STATE(1359),
    [sym_type_parameters] = STATE(2299),
    [sym_initialized_variable_definition] = STATE(2472),
    [sym__declared_identifier] = STATE(2151),
    [sym__final_const_var_or_type] = STATE(2686),
    [sym__type] = STATE(2047),
    [sym__type_not_function] = STATE(1616),
    [sym__type_not_void_not_function] = STATE(1668),
    [sym_function_type] = STATE(1655),
    [aux_sym__function_type_tails] = STATE(1482),
    [sym__function_type_tail] = STATE(1568),
    [sym__type_name] = STATE(1722),
    [sym__var_or_type] = STATE(2325),
    [sym_inferred_type] = STATE(1653),
    [sym_function_signature] = STATE(1879),
    [sym__formal_parameter_part] = STATE(1915),
    [sym_formal_parameter_list] = STATE(1636),
    [sym__strict_formal_parameter_list] = STATE(1626),
    [sym_local_variable_declaration] = STATE(509),
    [sym__covariant] = STATE(1552),
    [sym__function_builtin_identifier] = STATE(1424),
    [sym__get] = STATE(1992),
    [sym__set] = STATE(1992),
    [sym__new_builtin] = STATE(1701),
    [sym__late_builtin] = STATE(1618),
    [sym_this] = STATE(967),
    [sym_super] = STATE(1128),
    [sym_label] = STATE(2346),
    [sym_comment] = STATE(28),
    [sym_documentation_comment] = STATE(28),
    [aux_sym_string_literal_repeat1] = STATE(473),
    [aux_sym_switch_block_repeat1] = STATE(28),
    [aux_sym_switch_case_repeat1] = STATE(2091),
    [aux_sym__metadata_repeat1] = STATE(1143),
    [sym_identifier] = ACTIONS(191),
    [anon_sym_POUND] = ACTIONS(194),
    [sym_decimal_integer_literal] = ACTIONS(197),
    [sym_hex_integer_literal] = ACTIONS(200),
    [sym_decimal_floating_point_literal] = ACTIONS(197),
    [anon_sym_true] = ACTIONS(203),
    [anon_sym_false] = ACTIONS(206),
    [anon_sym_DQUOTE] = ACTIONS(209),
    [anon_sym_SQUOTE] = ACTIONS(212),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(215),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(218),
    [anon_sym_r_DQUOTE] = ACTIONS(221),
    [anon_sym_r_SQUOTE] = ACTIONS(224),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(227),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(230),
    [anon_sym_LBRACE] = ACTIONS(233),
    [anon_sym_RBRACE] = ACTIONS(236),
    [anon_sym_LBRACK] = ACTIONS(238),
    [anon_sym_null] = ACTIONS(241),
    [anon_sym_throw] = ACTIONS(244),
    [anon_sym_LPAREN] = ACTIONS(247),
    [anon_sym_LT] = ACTIONS(250),
    [sym_increment_operator] = ACTIONS(253),
    [sym_minus_operator] = ACTIONS(256),
    [sym__exclamation_operator] = ACTIONS(259),
    [anon_sym_TILDE] = ACTIONS(262),
    [anon_sym_await] = ACTIONS(265),
    [anon_sym_switch] = ACTIONS(268),
    [anon_sym_default] = ACTIONS(271),
    [anon_sym_do] = ACTIONS(274),
    [anon_sym_while] = ACTIONS(277),
    [anon_sym_continue] = ACTIONS(280),
    [anon_sym_yield] = ACTIONS(283),
    [anon_sym_return] = ACTIONS(286),
    [anon_sym_try] = ACTIONS(289),
    [anon_sym_if] = ACTIONS(292),
    [anon_sym_for] = ACTIONS(295),
    [anon_sym_AT] = ACTIONS(298),
    [anon_sym_super] = ACTIONS(301),
    [sym_void_type] = ACTIONS(304),
    [anon_sym_var] = ACTIONS(307),
    [sym__break_builtin] = ACTIONS(310),
    [sym__assert_builtin] = ACTIONS(313),
    [sym_case_builtin] = ACTIONS(316),
    [anon_sym_covariant] = ACTIONS(319),
    [anon_sym_Function] = ACTIONS(322),
    [anon_sym_get] = ACTIONS(325),
    [anon_sym_set] = ACTIONS(328),
    [anon_sym_new] = ACTIONS(331),
    [sym_const_builtin] = ACTIONS(334),
    [sym_final_builtin] = ACTIONS(337),
    [anon_sym_late] = ACTIONS(340),
    [anon_sym_this] = ACTIONS(343),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_SLASH_SLASH_SLASH] = ACTIONS(7),
    [sym__block_comment] = ACTIONS(9),
    [sym__documentation_block_comment] = ACTIONS(11),
  },
  [29] = {
    [sym__literal] = STATE(967),
    [sym_symbol_literal] = STATE(912),
    [sym_true] = STATE(912),
    [sym_false] = STATE(912),
    [sym_string_literal] = STATE(912),
    [sym__string_literal_double_quotes] = STATE(617),
    [sym__string_literal_single_quotes] = STATE(617),
    [sym__string_literal_double_quotes_multiple] = STATE(617),
    [sym__string_literal_single_quotes_multiple] = STATE(617),
    [sym__raw_string_literal_double_quotes] = STATE(617),
    [sym__raw_string_literal_single_quotes] = STATE(617),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(617),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(617),
    [sym_list_literal] = STATE(912),
    [sym_set_or_map_literal] = STATE(912),
    [sym_null_literal] = STATE(912),
    [sym__expression] = STATE(2450),
    [sym__real_expression] = STATE(670),
    [sym_throw_expression] = STATE(976),
    [sym_assignment_expression] = STATE(976),
    [sym_assignable_expression] = STATE(1582),
    [sym_lambda_expression] = STATE(494),
    [sym_function_expression] = STATE(967),
    [sym_if_null_expression] = STATE(1377),
    [sym_conditional_expression] = STATE(1377),
    [sym_logical_or_expression] = STATE(1377),
    [sym_logical_and_expression] = STATE(1377),
    [sym_equality_expression] = STATE(1377),
    [sym_type_cast_expression] = STATE(1377),
    [sym_type_test_expression] = STATE(1377),
    [sym_relational_expression] = STATE(1377),
    [sym_bitwise_or_expression] = STATE(1377),
    [sym_bitwise_xor_expression] = STATE(1377),
    [sym_bitwise_and_expression] = STATE(1377),
    [sym_shift_expression] = STATE(1377),
    [sym_additive_expression] = STATE(1377),
    [sym_multiplicative_expression] = STATE(1377),
    [sym__unary_expression] = STATE(1118),
    [sym_unary_expression] = STATE(1169),
    [sym__postfix_expression] = STATE(1169),
    [sym_postfix_expression] = STATE(1170),
    [sym_prefix_operator] = STATE(360),
    [sym_negation_operator] = STATE(1206),
    [sym_tilde_operator] = STATE(1188),
    [sym_await_expression] = STATE(1171),
    [sym_new_expression] = STATE(967),
    [sym_const_object_expression] = STATE(967),
    [sym__primary] = STATE(641),
    [sym_constructor_invocation] = STATE(638),
    [sym_type_arguments] = STATE(2454),
    [sym__statement] = STATE(527),
    [sym_local_function_declaration] = STATE(491),
    [sym_block] = STATE(488),
    [sym_expression_statement] = STATE(488),
    [sym_assert_statement] = STATE(488),
    [sym_assertion] = STATE(2726),
    [sym_switch_statement] = STATE(488),
    [sym_switch_label] = STATE(527),
    [sym_do_statement] = STATE(488),
    [sym_break_statement] = STATE(488),
    [sym_continue_statement] = STATE(488),
    [sym_yield_statement] = STATE(488),
    [sym_yield_each_statement] = STATE(488),
    [sym_return_statement] = STATE(488),
    [sym_try_statement] = STATE(488),
    [sym__try_head] = STATE(1927),
    [sym_if_statement] = STATE(488),
    [sym_while_statement] = STATE(488),
    [sym_for_statement] = STATE(488),
    [sym__annotation] = STATE(1287),
    [sym_marker_annotation] = STATE(1289),
    [sym_annotation] = STATE(1289),
    [sym__metadata] = STATE(1359),
    [sym_type_parameters] = STATE(2299),
    [sym_initialized_variable_definition] = STATE(2472),
    [sym__declared_identifier] = STATE(2151),
    [sym__final_const_var_or_type] = STATE(2686),
    [sym__type] = STATE(2047),
    [sym__type_not_function] = STATE(1616),
    [sym__type_not_void_not_function] = STATE(1668),
    [sym_function_type] = STATE(1655),
    [aux_sym__function_type_tails] = STATE(1482),
    [sym__function_type_tail] = STATE(1568),
    [sym__type_name] = STATE(1722),
    [sym__var_or_type] = STATE(2325),
    [sym_inferred_type] = STATE(1653),
    [sym_function_signature] = STATE(1879),
    [sym__formal_parameter_part] = STATE(1915),
    [sym_formal_parameter_list] = STATE(1636),
    [sym__strict_formal_parameter_list] = STATE(1626),
    [sym_local_variable_declaration] = STATE(509),
    [sym__covariant] = STATE(1552),
    [sym__function_builtin_identifier] = STATE(1424),
    [sym__get] = STATE(1992),
    [sym__set] = STATE(1992),
    [sym__new_builtin] = STATE(1701),
    [sym__late_builtin] = STATE(1618),
    [sym_this] = STATE(967),
    [sym_super] = STATE(1128),
    [sym_label] = STATE(2346),
    [sym_comment] = STATE(29),
    [sym_documentation_comment] = STATE(29),
    [aux_sym_string_literal_repeat1] = STATE(473),
    [aux_sym_switch_block_repeat1] = STATE(27),
    [aux_sym_switch_case_repeat1] = STATE(2091),
    [aux_sym__metadata_repeat1] = STATE(1143),
    [sym_identifier] = ACTIONS(175),
    [anon_sym_POUND] = ACTIONS(139),
    [sym_decimal_integer_literal] = ACTIONS(19),
    [sym_hex_integer_literal] = ACTIONS(21),
    [sym_decimal_floating_point_literal] = ACTIONS(19),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(25),
    [anon_sym_DQUOTE] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_r_DQUOTE] = ACTIONS(35),
    [anon_sym_r_SQUOTE] = ACTIONS(37),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(39),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(177),
    [anon_sym_RBRACE] = ACTIONS(346),
    [anon_sym_LBRACK] = ACTIONS(45),
    [anon_sym_null] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_LT] = ACTIONS(53),
    [sym_increment_operator] = ACTIONS(55),
    [sym_minus_operator] = ACTIONS(57),
    [sym__exclamation_operator] = ACTIONS(59),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_await] = ACTIONS(181),
    [anon_sym_switch] = ACTIONS(65),
    [anon_sym_default] = ACTIONS(183),
    [anon_sym_do] = ACTIONS(67),
    [anon_sym_while] = ACTIONS(159),
    [anon_sym_continue] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [anon_sym_return] = ACTIONS(75),
    [anon_sym_try] = ACTIONS(77),
    [anon_sym_if] = ACTIONS(185),
    [anon_sym_for] = ACTIONS(187),
    [anon_sym_AT] = ACTIONS(83),
    [anon_sym_super] = ACTIONS(95),
    [sym_void_type] = ACTIONS(97),
    [anon_sym_var] = ACTIONS(99),
    [sym__break_builtin] = ACTIONS(105),
    [sym__assert_builtin] = ACTIONS(107),
    [sym_case_builtin] = ACTIONS(189),
    [anon_sym_covariant] = ACTIONS(109),
    [anon_sym_Function] = ACTIONS(113),
    [anon_sym_get] = ACTIONS(115),
    [anon_sym_set] = ACTIONS(121),
    [anon_sym_new] = ACTIONS(125),
    [sym_const_builtin] = ACTIONS(165),
    [sym_final_builtin] = ACTIONS(167),
    [anon_sym_late] = ACTIONS(131),
    [anon_sym_this] = ACTIONS(135),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_SLASH_SLASH_SLASH] = ACTIONS(7),
    [sym__block_comment] = ACTIONS(9),
    [sym__documentation_block_comment] = ACTIONS(11),
  },
  [30] = {
    [sym__literal] = STATE(967),
    [sym_symbol_literal] = STATE(912),
    [sym_true] = STATE(912),
    [sym_false] = STATE(912),
    [sym_string_literal] = STATE(912),
    [sym__string_literal_double_quotes] = STATE(617),
    [sym__string_literal_single_quotes] = STATE(617),
    [sym__string_literal_double_quotes_multiple] = STATE(617),
    [sym__string_literal_single_quotes_multiple] = STATE(617),
    [sym__raw_string_literal_double_quotes] = STATE(617),
    [sym__raw_string_literal_single_quotes] = STATE(617),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(617),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(617),
    [sym_list_literal] = STATE(912),
    [sym_set_or_map_literal] = STATE(912),
    [sym_pair] = STATE(2134),
    [sym__element] = STATE(2123),
    [sym_null_literal] = STATE(912),
    [sym__expression] = STATE(1969),
    [sym__real_expression] = STATE(670),
    [sym_throw_expression] = STATE(976),
    [sym_assignment_expression] = STATE(976),
    [sym_assignable_expression] = STATE(1582),
    [sym_lambda_expression] = STATE(494),
    [sym_function_expression] = STATE(967),
    [sym_if_null_expression] = STATE(1377),
    [sym_conditional_expression] = STATE(1377),
    [sym_logical_or_expression] = STATE(1377),
    [sym_logical_and_expression] = STATE(1377),
    [sym_equality_expression] = STATE(1377),
    [sym_type_cast_expression] = STATE(1377),
    [sym_type_test_expression] = STATE(1377),
    [sym_relational_expression] = STATE(1377),
    [sym_bitwise_or_expression] = STATE(1377),
    [sym_bitwise_xor_expression] = STATE(1377),
    [sym_bitwise_and_expression] = STATE(1377),
    [sym_shift_expression] = STATE(1377),
    [sym_additive_expression] = STATE(1377),
    [sym_multiplicative_expression] = STATE(1377),
    [sym__unary_expression] = STATE(1118),
    [sym_unary_expression] = STATE(1169),
    [sym__postfix_expression] = STATE(1169),
    [sym_postfix_expression] = STATE(1170),
    [sym_spread_element] = STATE(2134),
    [sym_prefix_operator] = STATE(360),
    [sym_negation_operator] = STATE(1206),
    [sym_tilde_operator] = STATE(1188),
    [sym_await_expression] = STATE(1171),
    [sym_new_expression] = STATE(967),
    [sym_const_object_expression] = STATE(967),
    [sym__primary] = STATE(641),
    [sym_constructor_invocation] = STATE(638),
    [sym_type_arguments] = STATE(2454),
    [sym__statement] = STATE(506),
    [sym_local_function_declaration] = STATE(491),
    [sym_block] = STATE(488),
    [sym_expression_statement] = STATE(488),
    [sym_assert_statement] = STATE(488),
    [sym_assertion] = STATE(2726),
    [sym_switch_statement] = STATE(488),
    [sym_do_statement] = STATE(488),
    [sym_break_statement] = STATE(488),
    [sym_continue_statement] = STATE(488),
    [sym_yield_statement] = STATE(488),
    [sym_yield_each_statement] = STATE(488),
    [sym_return_statement] = STATE(488),
    [sym_try_statement] = STATE(488),
    [sym__try_head] = STATE(1927),
    [sym_if_element] = STATE(2134),
    [sym_if_statement] = STATE(488),
    [sym_while_statement] = STATE(488),
    [sym_for_statement] = STATE(488),
    [sym_for_element] = STATE(2134),
    [sym__annotation] = STATE(1287),
    [sym_marker_annotation] = STATE(1289),
    [sym_annotation] = STATE(1289),
    [sym__metadata] = STATE(1359),
    [sym_type_parameters] = STATE(2299),
    [sym_initialized_variable_definition] = STATE(2472),
    [sym__declared_identifier] = STATE(2151),
    [sym__final_const_var_or_type] = STATE(2686),
    [sym__type] = STATE(2047),
    [sym__type_not_function] = STATE(1616),
    [sym__type_not_void_not_function] = STATE(1668),
    [sym_function_type] = STATE(1655),
    [aux_sym__function_type_tails] = STATE(1482),
    [sym__function_type_tail] = STATE(1568),
    [sym__type_name] = STATE(1722),
    [sym__var_or_type] = STATE(2325),
    [sym_inferred_type] = STATE(1653),
    [sym_function_signature] = STATE(1879),
    [sym__formal_parameter_part] = STATE(1915),
    [sym_formal_parameter_list] = STATE(1636),
    [sym__strict_formal_parameter_list] = STATE(1626),
    [sym_local_variable_declaration] = STATE(509),
    [sym__covariant] = STATE(1552),
    [sym__function_builtin_identifier] = STATE(1424),
    [sym__get] = STATE(1992),
    [sym__set] = STATE(1992),
    [sym__new_builtin] = STATE(1701),
    [sym__late_builtin] = STATE(1618),
    [sym_this] = STATE(967),
    [sym_super] = STATE(1128),
    [sym_comment] = STATE(30),
    [sym_documentation_comment] = STATE(30),
    [aux_sym_string_literal_repeat1] = STATE(473),
    [aux_sym__metadata_repeat1] = STATE(1143),
    [sym_identifier] = ACTIONS(15),
    [anon_sym_POUND] = ACTIONS(139),
    [sym_decimal_integer_literal] = ACTIONS(19),
    [sym_hex_integer_literal] = ACTIONS(21),
    [sym_decimal_floating_point_literal] = ACTIONS(19),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(25),
    [anon_sym_DQUOTE] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_r_DQUOTE] = ACTIONS(35),
    [anon_sym_r_SQUOTE] = ACTIONS(37),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(39),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(43),
    [anon_sym_LBRACK] = ACTIONS(45),
    [anon_sym_null] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_LT] = ACTIONS(53),
    [sym_increment_operator] = ACTIONS(55),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(155),
    [sym_minus_operator] = ACTIONS(57),
    [sym__exclamation_operator] = ACTIONS(59),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_await] = ACTIONS(157),
    [anon_sym_switch] = ACTIONS(65),
    [anon_sym_do] = ACTIONS(67),
    [anon_sym_while] = ACTIONS(159),
    [anon_sym_continue] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [anon_sym_return] = ACTIONS(75),
    [anon_sym_try] = ACTIONS(77),
    [anon_sym_if] = ACTIONS(161),
    [anon_sym_for] = ACTIONS(163),
    [anon_sym_AT] = ACTIONS(83),
    [anon_sym_super] = ACTIONS(95),
    [sym_void_type] = ACTIONS(97),
    [anon_sym_var] = ACTIONS(99),
    [sym__break_builtin] = ACTIONS(105),
    [sym__assert_builtin] = ACTIONS(107),
    [anon_sym_covariant] = ACTIONS(109),
    [anon_sym_Function] = ACTIONS(113),
    [anon_sym_get] = ACTIONS(115),
    [anon_sym_set] = ACTIONS(121),
    [anon_sym_new] = ACTIONS(125),
    [sym_const_builtin] = ACTIONS(165),
    [sym_final_builtin] = ACTIONS(167),
    [anon_sym_late] = ACTIONS(131),
    [anon_sym_this] = ACTIONS(135),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_SLASH_SLASH_SLASH] = ACTIONS(7),
    [sym__block_comment] = ACTIONS(9),
    [sym__documentation_block_comment] = ACTIONS(11),
  },
  [31] = {
    [sym__literal] = STATE(967),
    [sym_symbol_literal] = STATE(912),
    [sym_true] = STATE(912),
    [sym_false] = STATE(912),
    [sym_string_literal] = STATE(912),
    [sym__string_literal_double_quotes] = STATE(617),
    [sym__string_literal_single_quotes] = STATE(617),
    [sym__string_literal_double_quotes_multiple] = STATE(617),
    [sym__string_literal_single_quotes_multiple] = STATE(617),
    [sym__raw_string_literal_double_quotes] = STATE(617),
    [sym__raw_string_literal_single_quotes] = STATE(617),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(617),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(617),
    [sym_list_literal] = STATE(912),
    [sym_set_or_map_literal] = STATE(912),
    [sym_pair] = STATE(2134),
    [sym__element] = STATE(2154),
    [sym_null_literal] = STATE(912),
    [sym__expression] = STATE(1969),
    [sym__real_expression] = STATE(670),
    [sym_throw_expression] = STATE(976),
    [sym_assignment_expression] = STATE(976),
    [sym_assignable_expression] = STATE(1582),
    [sym_lambda_expression] = STATE(494),
    [sym_function_expression] = STATE(967),
    [sym_if_null_expression] = STATE(1377),
    [sym_conditional_expression] = STATE(1377),
    [sym_logical_or_expression] = STATE(1377),
    [sym_logical_and_expression] = STATE(1377),
    [sym_equality_expression] = STATE(1377),
    [sym_type_cast_expression] = STATE(1377),
    [sym_type_test_expression] = STATE(1377),
    [sym_relational_expression] = STATE(1377),
    [sym_bitwise_or_expression] = STATE(1377),
    [sym_bitwise_xor_expression] = STATE(1377),
    [sym_bitwise_and_expression] = STATE(1377),
    [sym_shift_expression] = STATE(1377),
    [sym_additive_expression] = STATE(1377),
    [sym_multiplicative_expression] = STATE(1377),
    [sym__unary_expression] = STATE(1118),
    [sym_unary_expression] = STATE(1169),
    [sym__postfix_expression] = STATE(1169),
    [sym_postfix_expression] = STATE(1170),
    [sym_spread_element] = STATE(2134),
    [sym_prefix_operator] = STATE(360),
    [sym_negation_operator] = STATE(1206),
    [sym_tilde_operator] = STATE(1188),
    [sym_await_expression] = STATE(1171),
    [sym_new_expression] = STATE(967),
    [sym_const_object_expression] = STATE(967),
    [sym__primary] = STATE(641),
    [sym_constructor_invocation] = STATE(638),
    [sym_type_arguments] = STATE(2454),
    [sym__statement] = STATE(490),
    [sym_local_function_declaration] = STATE(491),
    [sym_block] = STATE(488),
    [sym_expression_statement] = STATE(488),
    [sym_assert_statement] = STATE(488),
    [sym_assertion] = STATE(2726),
    [sym_switch_statement] = STATE(488),
    [sym_do_statement] = STATE(488),
    [sym_break_statement] = STATE(488),
    [sym_continue_statement] = STATE(488),
    [sym_yield_statement] = STATE(488),
    [sym_yield_each_statement] = STATE(488),
    [sym_return_statement] = STATE(488),
    [sym_try_statement] = STATE(488),
    [sym__try_head] = STATE(1927),
    [sym_if_element] = STATE(2134),
    [sym_if_statement] = STATE(488),
    [sym_while_statement] = STATE(488),
    [sym_for_statement] = STATE(488),
    [sym_for_element] = STATE(2134),
    [sym__annotation] = STATE(1287),
    [sym_marker_annotation] = STATE(1289),
    [sym_annotation] = STATE(1289),
    [sym__metadata] = STATE(1359),
    [sym_type_parameters] = STATE(2299),
    [sym_initialized_variable_definition] = STATE(2472),
    [sym__declared_identifier] = STATE(2151),
    [sym__final_const_var_or_type] = STATE(2686),
    [sym__type] = STATE(2047),
    [sym__type_not_function] = STATE(1616),
    [sym__type_not_void_not_function] = STATE(1668),
    [sym_function_type] = STATE(1655),
    [aux_sym__function_type_tails] = STATE(1482),
    [sym__function_type_tail] = STATE(1568),
    [sym__type_name] = STATE(1722),
    [sym__var_or_type] = STATE(2325),
    [sym_inferred_type] = STATE(1653),
    [sym_function_signature] = STATE(1879),
    [sym__formal_parameter_part] = STATE(1915),
    [sym_formal_parameter_list] = STATE(1636),
    [sym__strict_formal_parameter_list] = STATE(1626),
    [sym_local_variable_declaration] = STATE(509),
    [sym__covariant] = STATE(1552),
    [sym__function_builtin_identifier] = STATE(1424),
    [sym__get] = STATE(1992),
    [sym__set] = STATE(1992),
    [sym__new_builtin] = STATE(1701),
    [sym__late_builtin] = STATE(1618),
    [sym_this] = STATE(967),
    [sym_super] = STATE(1128),
    [sym_comment] = STATE(31),
    [sym_documentation_comment] = STATE(31),
    [aux_sym_string_literal_repeat1] = STATE(473),
    [aux_sym__metadata_repeat1] = STATE(1143),
    [sym_identifier] = ACTIONS(15),
    [anon_sym_POUND] = ACTIONS(139),
    [sym_decimal_integer_literal] = ACTIONS(19),
    [sym_hex_integer_literal] = ACTIONS(21),
    [sym_decimal_floating_point_literal] = ACTIONS(19),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(25),
    [anon_sym_DQUOTE] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_r_DQUOTE] = ACTIONS(35),
    [anon_sym_r_SQUOTE] = ACTIONS(37),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(39),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(348),
    [anon_sym_LBRACK] = ACTIONS(45),
    [anon_sym_null] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_LT] = ACTIONS(53),
    [sym_increment_operator] = ACTIONS(55),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(155),
    [sym_minus_operator] = ACTIONS(57),
    [sym__exclamation_operator] = ACTIONS(59),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_await] = ACTIONS(350),
    [anon_sym_switch] = ACTIONS(65),
    [anon_sym_do] = ACTIONS(67),
    [anon_sym_while] = ACTIONS(159),
    [anon_sym_continue] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [anon_sym_return] = ACTIONS(75),
    [anon_sym_try] = ACTIONS(77),
    [anon_sym_if] = ACTIONS(161),
    [anon_sym_for] = ACTIONS(352),
    [anon_sym_AT] = ACTIONS(83),
    [anon_sym_super] = ACTIONS(95),
    [sym_void_type] = ACTIONS(97),
    [anon_sym_var] = ACTIONS(99),
    [sym__break_builtin] = ACTIONS(105),
    [sym__assert_builtin] = ACTIONS(107),
    [anon_sym_covariant] = ACTIONS(109),
    [anon_sym_Function] = ACTIONS(113),
    [anon_sym_get] = ACTIONS(115),
    [anon_sym_set] = ACTIONS(121),
    [anon_sym_new] = ACTIONS(125),
    [sym_const_builtin] = ACTIONS(165),
    [sym_final_builtin] = ACTIONS(167),
    [anon_sym_late] = ACTIONS(131),
    [anon_sym_this] = ACTIONS(135),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_SLASH_SLASH_SLASH] = ACTIONS(7),
    [sym__block_comment] = ACTIONS(9),
    [sym__documentation_block_comment] = ACTIONS(11),
  },
  [32] = {
    [sym__literal] = STATE(967),
    [sym_symbol_literal] = STATE(912),
    [sym_true] = STATE(912),
    [sym_false] = STATE(912),
    [sym_string_literal] = STATE(912),
    [sym__string_literal_double_quotes] = STATE(617),
    [sym__string_literal_single_quotes] = STATE(617),
    [sym__string_literal_double_quotes_multiple] = STATE(617),
    [sym__string_literal_single_quotes_multiple] = STATE(617),
    [sym__raw_string_literal_double_quotes] = STATE(617),
    [sym__raw_string_literal_single_quotes] = STATE(617),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(617),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(617),
    [sym_list_literal] = STATE(912),
    [sym_set_or_map_literal] = STATE(912),
    [sym_pair] = STATE(2134),
    [sym__element] = STATE(2123),
    [sym_null_literal] = STATE(912),
    [sym__expression] = STATE(1969),
    [sym__real_expression] = STATE(670),
    [sym_throw_expression] = STATE(976),
    [sym_assignment_expression] = STATE(976),
    [sym_assignable_expression] = STATE(1582),
    [sym_lambda_expression] = STATE(494),
    [sym_function_expression] = STATE(967),
    [sym_if_null_expression] = STATE(1377),
    [sym_conditional_expression] = STATE(1377),
    [sym_logical_or_expression] = STATE(1377),
    [sym_logical_and_expression] = STATE(1377),
    [sym_equality_expression] = STATE(1377),
    [sym_type_cast_expression] = STATE(1377),
    [sym_type_test_expression] = STATE(1377),
    [sym_relational_expression] = STATE(1377),
    [sym_bitwise_or_expression] = STATE(1377),
    [sym_bitwise_xor_expression] = STATE(1377),
    [sym_bitwise_and_expression] = STATE(1377),
    [sym_shift_expression] = STATE(1377),
    [sym_additive_expression] = STATE(1377),
    [sym_multiplicative_expression] = STATE(1377),
    [sym__unary_expression] = STATE(1118),
    [sym_unary_expression] = STATE(1169),
    [sym__postfix_expression] = STATE(1169),
    [sym_postfix_expression] = STATE(1170),
    [sym_spread_element] = STATE(2134),
    [sym_prefix_operator] = STATE(360),
    [sym_negation_operator] = STATE(1206),
    [sym_tilde_operator] = STATE(1188),
    [sym_await_expression] = STATE(1171),
    [sym_new_expression] = STATE(967),
    [sym_const_object_expression] = STATE(967),
    [sym__primary] = STATE(641),
    [sym_constructor_invocation] = STATE(638),
    [sym_type_arguments] = STATE(2454),
    [sym__statement] = STATE(506),
    [sym_local_function_declaration] = STATE(491),
    [sym_block] = STATE(488),
    [sym_expression_statement] = STATE(488),
    [sym_assert_statement] = STATE(488),
    [sym_assertion] = STATE(2726),
    [sym_switch_statement] = STATE(488),
    [sym_do_statement] = STATE(488),
    [sym_break_statement] = STATE(488),
    [sym_continue_statement] = STATE(488),
    [sym_yield_statement] = STATE(488),
    [sym_yield_each_statement] = STATE(488),
    [sym_return_statement] = STATE(488),
    [sym_try_statement] = STATE(488),
    [sym__try_head] = STATE(1927),
    [sym_if_element] = STATE(2134),
    [sym_if_statement] = STATE(488),
    [sym_while_statement] = STATE(488),
    [sym_for_statement] = STATE(488),
    [sym_for_element] = STATE(2134),
    [sym__annotation] = STATE(1287),
    [sym_marker_annotation] = STATE(1289),
    [sym_annotation] = STATE(1289),
    [sym__metadata] = STATE(1359),
    [sym_type_parameters] = STATE(2299),
    [sym_initialized_variable_definition] = STATE(2472),
    [sym__declared_identifier] = STATE(2151),
    [sym__final_const_var_or_type] = STATE(2686),
    [sym__type] = STATE(2047),
    [sym__type_not_function] = STATE(1616),
    [sym__type_not_void_not_function] = STATE(1668),
    [sym_function_type] = STATE(1655),
    [aux_sym__function_type_tails] = STATE(1482),
    [sym__function_type_tail] = STATE(1568),
    [sym__type_name] = STATE(1722),
    [sym__var_or_type] = STATE(2325),
    [sym_inferred_type] = STATE(1653),
    [sym_function_signature] = STATE(1879),
    [sym__formal_parameter_part] = STATE(1915),
    [sym_formal_parameter_list] = STATE(1636),
    [sym__strict_formal_parameter_list] = STATE(1626),
    [sym_local_variable_declaration] = STATE(509),
    [sym__covariant] = STATE(1552),
    [sym__function_builtin_identifier] = STATE(1424),
    [sym__get] = STATE(1992),
    [sym__set] = STATE(1992),
    [sym__new_builtin] = STATE(1701),
    [sym__late_builtin] = STATE(1618),
    [sym_this] = STATE(967),
    [sym_super] = STATE(1128),
    [sym_comment] = STATE(32),
    [sym_documentation_comment] = STATE(32),
    [aux_sym_string_literal_repeat1] = STATE(473),
    [aux_sym__metadata_repeat1] = STATE(1143),
    [sym_identifier] = ACTIONS(15),
    [anon_sym_POUND] = ACTIONS(139),
    [sym_decimal_integer_literal] = ACTIONS(19),
    [sym_hex_integer_literal] = ACTIONS(21),
    [sym_decimal_floating_point_literal] = ACTIONS(19),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(25),
    [anon_sym_DQUOTE] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_r_DQUOTE] = ACTIONS(35),
    [anon_sym_r_SQUOTE] = ACTIONS(37),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(39),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(348),
    [anon_sym_LBRACK] = ACTIONS(45),
    [anon_sym_null] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_LT] = ACTIONS(53),
    [sym_increment_operator] = ACTIONS(55),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(155),
    [sym_minus_operator] = ACTIONS(57),
    [sym__exclamation_operator] = ACTIONS(59),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_await] = ACTIONS(350),
    [anon_sym_switch] = ACTIONS(65),
    [anon_sym_do] = ACTIONS(67),
    [anon_sym_while] = ACTIONS(159),
    [anon_sym_continue] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [anon_sym_return] = ACTIONS(75),
    [anon_sym_try] = ACTIONS(77),
    [anon_sym_if] = ACTIONS(161),
    [anon_sym_for] = ACTIONS(352),
    [anon_sym_AT] = ACTIONS(83),
    [anon_sym_super] = ACTIONS(95),
    [sym_void_type] = ACTIONS(97),
    [anon_sym_var] = ACTIONS(99),
    [sym__break_builtin] = ACTIONS(105),
    [sym__assert_builtin] = ACTIONS(107),
    [anon_sym_covariant] = ACTIONS(109),
    [anon_sym_Function] = ACTIONS(113),
    [anon_sym_get] = ACTIONS(115),
    [anon_sym_set] = ACTIONS(121),
    [anon_sym_new] = ACTIONS(125),
    [sym_const_builtin] = ACTIONS(165),
    [sym_final_builtin] = ACTIONS(167),
    [anon_sym_late] = ACTIONS(131),
    [anon_sym_this] = ACTIONS(135),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_SLASH_SLASH_SLASH] = ACTIONS(7),
    [sym__block_comment] = ACTIONS(9),
    [sym__documentation_block_comment] = ACTIONS(11),
  },
  [33] = {
    [sym__literal] = STATE(967),
    [sym_symbol_literal] = STATE(912),
    [sym_true] = STATE(912),
    [sym_false] = STATE(912),
    [sym_string_literal] = STATE(912),
    [sym__string_literal_double_quotes] = STATE(617),
    [sym__string_literal_single_quotes] = STATE(617),
    [sym__string_literal_double_quotes_multiple] = STATE(617),
    [sym__string_literal_single_quotes_multiple] = STATE(617),
    [sym__raw_string_literal_double_quotes] = STATE(617),
    [sym__raw_string_literal_single_quotes] = STATE(617),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(617),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(617),
    [sym_list_literal] = STATE(912),
    [sym_set_or_map_literal] = STATE(912),
    [sym_pair] = STATE(2134),
    [sym__element] = STATE(2154),
    [sym_null_literal] = STATE(912),
    [sym__expression] = STATE(1969),
    [sym__real_expression] = STATE(670),
    [sym_throw_expression] = STATE(976),
    [sym_assignment_expression] = STATE(976),
    [sym_assignable_expression] = STATE(1582),
    [sym_lambda_expression] = STATE(494),
    [sym_function_expression] = STATE(967),
    [sym_if_null_expression] = STATE(1377),
    [sym_conditional_expression] = STATE(1377),
    [sym_logical_or_expression] = STATE(1377),
    [sym_logical_and_expression] = STATE(1377),
    [sym_equality_expression] = STATE(1377),
    [sym_type_cast_expression] = STATE(1377),
    [sym_type_test_expression] = STATE(1377),
    [sym_relational_expression] = STATE(1377),
    [sym_bitwise_or_expression] = STATE(1377),
    [sym_bitwise_xor_expression] = STATE(1377),
    [sym_bitwise_and_expression] = STATE(1377),
    [sym_shift_expression] = STATE(1377),
    [sym_additive_expression] = STATE(1377),
    [sym_multiplicative_expression] = STATE(1377),
    [sym__unary_expression] = STATE(1118),
    [sym_unary_expression] = STATE(1169),
    [sym__postfix_expression] = STATE(1169),
    [sym_postfix_expression] = STATE(1170),
    [sym_spread_element] = STATE(2134),
    [sym_prefix_operator] = STATE(360),
    [sym_negation_operator] = STATE(1206),
    [sym_tilde_operator] = STATE(1188),
    [sym_await_expression] = STATE(1171),
    [sym_new_expression] = STATE(967),
    [sym_const_object_expression] = STATE(967),
    [sym__primary] = STATE(641),
    [sym_constructor_invocation] = STATE(638),
    [sym_type_arguments] = STATE(2454),
    [sym__statement] = STATE(490),
    [sym_local_function_declaration] = STATE(491),
    [sym_block] = STATE(488),
    [sym_expression_statement] = STATE(488),
    [sym_assert_statement] = STATE(488),
    [sym_assertion] = STATE(2726),
    [sym_switch_statement] = STATE(488),
    [sym_do_statement] = STATE(488),
    [sym_break_statement] = STATE(488),
    [sym_continue_statement] = STATE(488),
    [sym_yield_statement] = STATE(488),
    [sym_yield_each_statement] = STATE(488),
    [sym_return_statement] = STATE(488),
    [sym_try_statement] = STATE(488),
    [sym__try_head] = STATE(1927),
    [sym_if_element] = STATE(2134),
    [sym_if_statement] = STATE(488),
    [sym_while_statement] = STATE(488),
    [sym_for_statement] = STATE(488),
    [sym_for_element] = STATE(2134),
    [sym__annotation] = STATE(1287),
    [sym_marker_annotation] = STATE(1289),
    [sym_annotation] = STATE(1289),
    [sym__metadata] = STATE(1359),
    [sym_type_parameters] = STATE(2299),
    [sym_initialized_variable_definition] = STATE(2472),
    [sym__declared_identifier] = STATE(2151),
    [sym__final_const_var_or_type] = STATE(2686),
    [sym__type] = STATE(2047),
    [sym__type_not_function] = STATE(1616),
    [sym__type_not_void_not_function] = STATE(1668),
    [sym_function_type] = STATE(1655),
    [aux_sym__function_type_tails] = STATE(1482),
    [sym__function_type_tail] = STATE(1568),
    [sym__type_name] = STATE(1722),
    [sym__var_or_type] = STATE(2325),
    [sym_inferred_type] = STATE(1653),
    [sym_function_signature] = STATE(1879),
    [sym__formal_parameter_part] = STATE(1915),
    [sym_formal_parameter_list] = STATE(1636),
    [sym__strict_formal_parameter_list] = STATE(1626),
    [sym_local_variable_declaration] = STATE(509),
    [sym__covariant] = STATE(1552),
    [sym__function_builtin_identifier] = STATE(1424),
    [sym__get] = STATE(1992),
    [sym__set] = STATE(1992),
    [sym__new_builtin] = STATE(1701),
    [sym__late_builtin] = STATE(1618),
    [sym_this] = STATE(967),
    [sym_super] = STATE(1128),
    [sym_comment] = STATE(33),
    [sym_documentation_comment] = STATE(33),
    [aux_sym_string_literal_repeat1] = STATE(473),
    [aux_sym__metadata_repeat1] = STATE(1143),
    [sym_identifier] = ACTIONS(15),
    [anon_sym_POUND] = ACTIONS(139),
    [sym_decimal_integer_literal] = ACTIONS(19),
    [sym_hex_integer_literal] = ACTIONS(21),
    [sym_decimal_floating_point_literal] = ACTIONS(19),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(25),
    [anon_sym_DQUOTE] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_r_DQUOTE] = ACTIONS(35),
    [anon_sym_r_SQUOTE] = ACTIONS(37),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(39),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(43),
    [anon_sym_LBRACK] = ACTIONS(45),
    [anon_sym_null] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_LT] = ACTIONS(53),
    [sym_increment_operator] = ACTIONS(55),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(155),
    [sym_minus_operator] = ACTIONS(57),
    [sym__exclamation_operator] = ACTIONS(59),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_await] = ACTIONS(157),
    [anon_sym_switch] = ACTIONS(65),
    [anon_sym_do] = ACTIONS(67),
    [anon_sym_while] = ACTIONS(159),
    [anon_sym_continue] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [anon_sym_return] = ACTIONS(75),
    [anon_sym_try] = ACTIONS(77),
    [anon_sym_if] = ACTIONS(161),
    [anon_sym_for] = ACTIONS(163),
    [anon_sym_AT] = ACTIONS(83),
    [anon_sym_super] = ACTIONS(95),
    [sym_void_type] = ACTIONS(97),
    [anon_sym_var] = ACTIONS(99),
    [sym__break_builtin] = ACTIONS(105),
    [sym__assert_builtin] = ACTIONS(107),
    [anon_sym_covariant] = ACTIONS(109),
    [anon_sym_Function] = ACTIONS(113),
    [anon_sym_get] = ACTIONS(115),
    [anon_sym_set] = ACTIONS(121),
    [anon_sym_new] = ACTIONS(125),
    [sym_const_builtin] = ACTIONS(165),
    [sym_final_builtin] = ACTIONS(167),
    [anon_sym_late] = ACTIONS(131),
    [anon_sym_this] = ACTIONS(135),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_SLASH_SLASH_SLASH] = ACTIONS(7),
    [sym__block_comment] = ACTIONS(9),
    [sym__documentation_block_comment] = ACTIONS(11),
  },
  [34] = {
    [sym__literal] = STATE(967),
    [sym_symbol_literal] = STATE(912),
    [sym_true] = STATE(912),
    [sym_false] = STATE(912),
    [sym_string_literal] = STATE(912),
    [sym__string_literal_double_quotes] = STATE(617),
    [sym__string_literal_single_quotes] = STATE(617),
    [sym__string_literal_double_quotes_multiple] = STATE(617),
    [sym__string_literal_single_quotes_multiple] = STATE(617),
    [sym__raw_string_literal_double_quotes] = STATE(617),
    [sym__raw_string_literal_single_quotes] = STATE(617),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(617),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(617),
    [sym_list_literal] = STATE(912),
    [sym_set_or_map_literal] = STATE(912),
    [sym_pair] = STATE(2134),
    [sym__element] = STATE(2109),
    [sym_null_literal] = STATE(912),
    [sym__expression] = STATE(1969),
    [sym__real_expression] = STATE(670),
    [sym_throw_expression] = STATE(976),
    [sym_assignment_expression] = STATE(976),
    [sym_assignable_expression] = STATE(1582),
    [sym_lambda_expression] = STATE(494),
    [sym_function_expression] = STATE(967),
    [sym_if_null_expression] = STATE(1377),
    [sym_conditional_expression] = STATE(1377),
    [sym_logical_or_expression] = STATE(1377),
    [sym_logical_and_expression] = STATE(1377),
    [sym_equality_expression] = STATE(1377),
    [sym_type_cast_expression] = STATE(1377),
    [sym_type_test_expression] = STATE(1377),
    [sym_relational_expression] = STATE(1377),
    [sym_bitwise_or_expression] = STATE(1377),
    [sym_bitwise_xor_expression] = STATE(1377),
    [sym_bitwise_and_expression] = STATE(1377),
    [sym_shift_expression] = STATE(1377),
    [sym_additive_expression] = STATE(1377),
    [sym_multiplicative_expression] = STATE(1377),
    [sym__unary_expression] = STATE(1118),
    [sym_unary_expression] = STATE(1169),
    [sym__postfix_expression] = STATE(1169),
    [sym_postfix_expression] = STATE(1170),
    [sym_spread_element] = STATE(2134),
    [sym_prefix_operator] = STATE(360),
    [sym_negation_operator] = STATE(1206),
    [sym_tilde_operator] = STATE(1188),
    [sym_await_expression] = STATE(1171),
    [sym_new_expression] = STATE(967),
    [sym_const_object_expression] = STATE(967),
    [sym__primary] = STATE(641),
    [sym_constructor_invocation] = STATE(638),
    [sym_type_arguments] = STATE(2454),
    [sym__statement] = STATE(517),
    [sym_local_function_declaration] = STATE(491),
    [sym_block] = STATE(488),
    [sym_expression_statement] = STATE(488),
    [sym_assert_statement] = STATE(488),
    [sym_assertion] = STATE(2726),
    [sym_switch_statement] = STATE(488),
    [sym_do_statement] = STATE(488),
    [sym_break_statement] = STATE(488),
    [sym_continue_statement] = STATE(488),
    [sym_yield_statement] = STATE(488),
    [sym_yield_each_statement] = STATE(488),
    [sym_return_statement] = STATE(488),
    [sym_try_statement] = STATE(488),
    [sym__try_head] = STATE(1927),
    [sym_if_element] = STATE(2134),
    [sym_if_statement] = STATE(488),
    [sym_while_statement] = STATE(488),
    [sym_for_statement] = STATE(488),
    [sym_for_element] = STATE(2134),
    [sym__annotation] = STATE(1287),
    [sym_marker_annotation] = STATE(1289),
    [sym_annotation] = STATE(1289),
    [sym__metadata] = STATE(1359),
    [sym_type_parameters] = STATE(2299),
    [sym_initialized_variable_definition] = STATE(2472),
    [sym__declared_identifier] = STATE(2151),
    [sym__final_const_var_or_type] = STATE(2686),
    [sym__type] = STATE(2047),
    [sym__type_not_function] = STATE(1616),
    [sym__type_not_void_not_function] = STATE(1668),
    [sym_function_type] = STATE(1655),
    [aux_sym__function_type_tails] = STATE(1482),
    [sym__function_type_tail] = STATE(1568),
    [sym__type_name] = STATE(1722),
    [sym__var_or_type] = STATE(2325),
    [sym_inferred_type] = STATE(1653),
    [sym_function_signature] = STATE(1879),
    [sym__formal_parameter_part] = STATE(1915),
    [sym_formal_parameter_list] = STATE(1636),
    [sym__strict_formal_parameter_list] = STATE(1626),
    [sym_local_variable_declaration] = STATE(509),
    [sym__covariant] = STATE(1552),
    [sym__function_builtin_identifier] = STATE(1424),
    [sym__get] = STATE(1992),
    [sym__set] = STATE(1992),
    [sym__new_builtin] = STATE(1701),
    [sym__late_builtin] = STATE(1618),
    [sym_this] = STATE(967),
    [sym_super] = STATE(1128),
    [sym_comment] = STATE(34),
    [sym_documentation_comment] = STATE(34),
    [aux_sym_string_literal_repeat1] = STATE(473),
    [aux_sym__metadata_repeat1] = STATE(1143),
    [sym_identifier] = ACTIONS(15),
    [anon_sym_POUND] = ACTIONS(139),
    [sym_decimal_integer_literal] = ACTIONS(19),
    [sym_hex_integer_literal] = ACTIONS(21),
    [sym_decimal_floating_point_literal] = ACTIONS(19),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(25),
    [anon_sym_DQUOTE] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_r_DQUOTE] = ACTIONS(35),
    [anon_sym_r_SQUOTE] = ACTIONS(37),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(39),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(348),
    [anon_sym_LBRACK] = ACTIONS(45),
    [anon_sym_null] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_LT] = ACTIONS(53),
    [sym_increment_operator] = ACTIONS(55),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(155),
    [sym_minus_operator] = ACTIONS(57),
    [sym__exclamation_operator] = ACTIONS(59),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_await] = ACTIONS(350),
    [anon_sym_switch] = ACTIONS(65),
    [anon_sym_do] = ACTIONS(67),
    [anon_sym_while] = ACTIONS(159),
    [anon_sym_continue] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [anon_sym_return] = ACTIONS(75),
    [anon_sym_try] = ACTIONS(77),
    [anon_sym_if] = ACTIONS(161),
    [anon_sym_for] = ACTIONS(352),
    [anon_sym_AT] = ACTIONS(83),
    [anon_sym_super] = ACTIONS(95),
    [sym_void_type] = ACTIONS(97),
    [anon_sym_var] = ACTIONS(99),
    [sym__break_builtin] = ACTIONS(105),
    [sym__assert_builtin] = ACTIONS(107),
    [anon_sym_covariant] = ACTIONS(109),
    [anon_sym_Function] = ACTIONS(113),
    [anon_sym_get] = ACTIONS(115),
    [anon_sym_set] = ACTIONS(121),
    [anon_sym_new] = ACTIONS(125),
    [sym_const_builtin] = ACTIONS(165),
    [sym_final_builtin] = ACTIONS(167),
    [anon_sym_late] = ACTIONS(131),
    [anon_sym_this] = ACTIONS(135),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_SLASH_SLASH_SLASH] = ACTIONS(7),
    [sym__block_comment] = ACTIONS(9),
    [sym__documentation_block_comment] = ACTIONS(11),
  },
  [35] = {
    [sym__literal] = STATE(967),
    [sym_symbol_literal] = STATE(912),
    [sym_true] = STATE(912),
    [sym_false] = STATE(912),
    [sym_string_literal] = STATE(912),
    [sym__string_literal_double_quotes] = STATE(617),
    [sym__string_literal_single_quotes] = STATE(617),
    [sym__string_literal_double_quotes_multiple] = STATE(617),
    [sym__string_literal_single_quotes_multiple] = STATE(617),
    [sym__raw_string_literal_double_quotes] = STATE(617),
    [sym__raw_string_literal_single_quotes] = STATE(617),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(617),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(617),
    [sym_list_literal] = STATE(912),
    [sym_set_or_map_literal] = STATE(912),
    [sym_null_literal] = STATE(912),
    [sym__expression] = STATE(2450),
    [sym__real_expression] = STATE(670),
    [sym_throw_expression] = STATE(976),
    [sym_assignment_expression] = STATE(976),
    [sym_assignable_expression] = STATE(1582),
    [sym_lambda_expression] = STATE(494),
    [sym_function_expression] = STATE(967),
    [sym_if_null_expression] = STATE(1377),
    [sym_conditional_expression] = STATE(1377),
    [sym_logical_or_expression] = STATE(1377),
    [sym_logical_and_expression] = STATE(1377),
    [sym_equality_expression] = STATE(1377),
    [sym_type_cast_expression] = STATE(1377),
    [sym_type_test_expression] = STATE(1377),
    [sym_relational_expression] = STATE(1377),
    [sym_bitwise_or_expression] = STATE(1377),
    [sym_bitwise_xor_expression] = STATE(1377),
    [sym_bitwise_and_expression] = STATE(1377),
    [sym_shift_expression] = STATE(1377),
    [sym_additive_expression] = STATE(1377),
    [sym_multiplicative_expression] = STATE(1377),
    [sym__unary_expression] = STATE(1118),
    [sym_unary_expression] = STATE(1169),
    [sym__postfix_expression] = STATE(1169),
    [sym_postfix_expression] = STATE(1170),
    [sym_prefix_operator] = STATE(360),
    [sym_negation_operator] = STATE(1206),
    [sym_tilde_operator] = STATE(1188),
    [sym_await_expression] = STATE(1171),
    [sym_new_expression] = STATE(967),
    [sym_const_object_expression] = STATE(967),
    [sym__primary] = STATE(641),
    [sym_constructor_invocation] = STATE(638),
    [sym_type_arguments] = STATE(2454),
    [sym__statement] = STATE(532),
    [sym_local_function_declaration] = STATE(491),
    [sym_block] = STATE(488),
    [sym_expression_statement] = STATE(488),
    [sym_assert_statement] = STATE(488),
    [sym_assertion] = STATE(2726),
    [sym_switch_statement] = STATE(488),
    [sym_do_statement] = STATE(488),
    [sym_break_statement] = STATE(488),
    [sym_continue_statement] = STATE(488),
    [sym_yield_statement] = STATE(488),
    [sym_yield_each_statement] = STATE(488),
    [sym_return_statement] = STATE(488),
    [sym_try_statement] = STATE(488),
    [sym__try_head] = STATE(1927),
    [sym_if_statement] = STATE(488),
    [sym_while_statement] = STATE(488),
    [sym_for_statement] = STATE(488),
    [sym__annotation] = STATE(1287),
    [sym_marker_annotation] = STATE(1289),
    [sym_annotation] = STATE(1289),
    [sym__metadata] = STATE(1359),
    [sym_type_parameters] = STATE(2299),
    [sym_initialized_variable_definition] = STATE(2472),
    [sym__declared_identifier] = STATE(2151),
    [sym__final_const_var_or_type] = STATE(2686),
    [sym__type] = STATE(2047),
    [sym__type_not_function] = STATE(1616),
    [sym__type_not_void_not_function] = STATE(1668),
    [sym_function_type] = STATE(1655),
    [aux_sym__function_type_tails] = STATE(1482),
    [sym__function_type_tail] = STATE(1568),
    [sym__type_name] = STATE(1722),
    [sym__var_or_type] = STATE(2325),
    [sym_inferred_type] = STATE(1653),
    [sym_function_signature] = STATE(1879),
    [sym__formal_parameter_part] = STATE(1915),
    [sym_formal_parameter_list] = STATE(1636),
    [sym__strict_formal_parameter_list] = STATE(1626),
    [sym_local_variable_declaration] = STATE(509),
    [sym__covariant] = STATE(1552),
    [sym__function_builtin_identifier] = STATE(1424),
    [sym__get] = STATE(1992),
    [sym__set] = STATE(1992),
    [sym__new_builtin] = STATE(1701),
    [sym__late_builtin] = STATE(1618),
    [sym_this] = STATE(967),
    [sym_super] = STATE(1128),
    [sym_comment] = STATE(35),
    [sym_documentation_comment] = STATE(35),
    [aux_sym_program_repeat5] = STATE(50),
    [aux_sym_string_literal_repeat1] = STATE(473),
    [aux_sym__metadata_repeat1] = STATE(1143),
    [sym_identifier] = ACTIONS(15),
    [anon_sym_POUND] = ACTIONS(139),
    [sym_decimal_integer_literal] = ACTIONS(19),
    [sym_hex_integer_literal] = ACTIONS(21),
    [sym_decimal_floating_point_literal] = ACTIONS(19),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(25),
    [anon_sym_DQUOTE] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_r_DQUOTE] = ACTIONS(35),
    [anon_sym_r_SQUOTE] = ACTIONS(37),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(39),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(177),
    [anon_sym_RBRACE] = ACTIONS(354),
    [anon_sym_LBRACK] = ACTIONS(45),
    [anon_sym_null] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_LT] = ACTIONS(53),
    [sym_increment_operator] = ACTIONS(55),
    [sym_minus_operator] = ACTIONS(57),
    [sym__exclamation_operator] = ACTIONS(59),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_await] = ACTIONS(181),
    [anon_sym_switch] = ACTIONS(65),
    [anon_sym_do] = ACTIONS(67),
    [anon_sym_while] = ACTIONS(159),
    [anon_sym_continue] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [anon_sym_return] = ACTIONS(75),
    [anon_sym_try] = ACTIONS(77),
    [anon_sym_if] = ACTIONS(185),
    [anon_sym_for] = ACTIONS(187),
    [anon_sym_AT] = ACTIONS(83),
    [anon_sym_super] = ACTIONS(95),
    [sym_void_type] = ACTIONS(97),
    [anon_sym_var] = ACTIONS(99),
    [sym__break_builtin] = ACTIONS(105),
    [sym__assert_builtin] = ACTIONS(107),
    [anon_sym_covariant] = ACTIONS(109),
    [anon_sym_Function] = ACTIONS(113),
    [anon_sym_get] = ACTIONS(115),
    [anon_sym_set] = ACTIONS(121),
    [anon_sym_new] = ACTIONS(125),
    [sym_const_builtin] = ACTIONS(165),
    [sym_final_builtin] = ACTIONS(167),
    [anon_sym_late] = ACTIONS(131),
    [anon_sym_this] = ACTIONS(135),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_SLASH_SLASH_SLASH] = ACTIONS(7),
    [sym__block_comment] = ACTIONS(9),
    [sym__documentation_block_comment] = ACTIONS(11),
  },
  [36] = {
    [sym__literal] = STATE(967),
    [sym_symbol_literal] = STATE(912),
    [sym_true] = STATE(912),
    [sym_false] = STATE(912),
    [sym_string_literal] = STATE(912),
    [sym__string_literal_double_quotes] = STATE(617),
    [sym__string_literal_single_quotes] = STATE(617),
    [sym__string_literal_double_quotes_multiple] = STATE(617),
    [sym__string_literal_single_quotes_multiple] = STATE(617),
    [sym__raw_string_literal_double_quotes] = STATE(617),
    [sym__raw_string_literal_single_quotes] = STATE(617),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(617),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(617),
    [sym_list_literal] = STATE(912),
    [sym_set_or_map_literal] = STATE(912),
    [sym_null_literal] = STATE(912),
    [sym__expression] = STATE(2450),
    [sym__real_expression] = STATE(670),
    [sym_throw_expression] = STATE(976),
    [sym_assignment_expression] = STATE(976),
    [sym_assignable_expression] = STATE(1582),
    [sym_lambda_expression] = STATE(494),
    [sym_function_expression] = STATE(967),
    [sym_if_null_expression] = STATE(1377),
    [sym_conditional_expression] = STATE(1377),
    [sym_logical_or_expression] = STATE(1377),
    [sym_logical_and_expression] = STATE(1377),
    [sym_equality_expression] = STATE(1377),
    [sym_type_cast_expression] = STATE(1377),
    [sym_type_test_expression] = STATE(1377),
    [sym_relational_expression] = STATE(1377),
    [sym_bitwise_or_expression] = STATE(1377),
    [sym_bitwise_xor_expression] = STATE(1377),
    [sym_bitwise_and_expression] = STATE(1377),
    [sym_shift_expression] = STATE(1377),
    [sym_additive_expression] = STATE(1377),
    [sym_multiplicative_expression] = STATE(1377),
    [sym__unary_expression] = STATE(1118),
    [sym_unary_expression] = STATE(1169),
    [sym__postfix_expression] = STATE(1169),
    [sym_postfix_expression] = STATE(1170),
    [sym_prefix_operator] = STATE(360),
    [sym_negation_operator] = STATE(1206),
    [sym_tilde_operator] = STATE(1188),
    [sym_await_expression] = STATE(1171),
    [sym_new_expression] = STATE(967),
    [sym_const_object_expression] = STATE(967),
    [sym__primary] = STATE(641),
    [sym_constructor_invocation] = STATE(638),
    [sym_type_arguments] = STATE(2454),
    [sym__statement] = STATE(532),
    [sym_local_function_declaration] = STATE(491),
    [sym_block] = STATE(488),
    [sym_expression_statement] = STATE(488),
    [sym_assert_statement] = STATE(488),
    [sym_assertion] = STATE(2726),
    [sym_switch_statement] = STATE(488),
    [sym_do_statement] = STATE(488),
    [sym_break_statement] = STATE(488),
    [sym_continue_statement] = STATE(488),
    [sym_yield_statement] = STATE(488),
    [sym_yield_each_statement] = STATE(488),
    [sym_return_statement] = STATE(488),
    [sym_try_statement] = STATE(488),
    [sym__try_head] = STATE(1927),
    [sym_if_statement] = STATE(488),
    [sym_while_statement] = STATE(488),
    [sym_for_statement] = STATE(488),
    [sym__annotation] = STATE(1287),
    [sym_marker_annotation] = STATE(1289),
    [sym_annotation] = STATE(1289),
    [sym__metadata] = STATE(1359),
    [sym_type_parameters] = STATE(2299),
    [sym_initialized_variable_definition] = STATE(2472),
    [sym__declared_identifier] = STATE(2151),
    [sym__final_const_var_or_type] = STATE(2686),
    [sym__type] = STATE(2047),
    [sym__type_not_function] = STATE(1616),
    [sym__type_not_void_not_function] = STATE(1668),
    [sym_function_type] = STATE(1655),
    [aux_sym__function_type_tails] = STATE(1482),
    [sym__function_type_tail] = STATE(1568),
    [sym__type_name] = STATE(1722),
    [sym__var_or_type] = STATE(2325),
    [sym_inferred_type] = STATE(1653),
    [sym_function_signature] = STATE(1879),
    [sym__formal_parameter_part] = STATE(1915),
    [sym_formal_parameter_list] = STATE(1636),
    [sym__strict_formal_parameter_list] = STATE(1626),
    [sym_local_variable_declaration] = STATE(509),
    [sym__covariant] = STATE(1552),
    [sym__function_builtin_identifier] = STATE(1424),
    [sym__get] = STATE(1992),
    [sym__set] = STATE(1992),
    [sym__new_builtin] = STATE(1701),
    [sym__late_builtin] = STATE(1618),
    [sym_this] = STATE(967),
    [sym_super] = STATE(1128),
    [sym_comment] = STATE(36),
    [sym_documentation_comment] = STATE(36),
    [aux_sym_program_repeat5] = STATE(38),
    [aux_sym_string_literal_repeat1] = STATE(473),
    [aux_sym__metadata_repeat1] = STATE(1143),
    [sym_identifier] = ACTIONS(15),
    [anon_sym_POUND] = ACTIONS(139),
    [sym_decimal_integer_literal] = ACTIONS(19),
    [sym_hex_integer_literal] = ACTIONS(21),
    [sym_decimal_floating_point_literal] = ACTIONS(19),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(25),
    [anon_sym_DQUOTE] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_r_DQUOTE] = ACTIONS(35),
    [anon_sym_r_SQUOTE] = ACTIONS(37),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(39),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(177),
    [anon_sym_RBRACE] = ACTIONS(356),
    [anon_sym_LBRACK] = ACTIONS(45),
    [anon_sym_null] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_LT] = ACTIONS(53),
    [sym_increment_operator] = ACTIONS(55),
    [sym_minus_operator] = ACTIONS(57),
    [sym__exclamation_operator] = ACTIONS(59),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_await] = ACTIONS(181),
    [anon_sym_switch] = ACTIONS(65),
    [anon_sym_do] = ACTIONS(67),
    [anon_sym_while] = ACTIONS(159),
    [anon_sym_continue] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [anon_sym_return] = ACTIONS(75),
    [anon_sym_try] = ACTIONS(77),
    [anon_sym_if] = ACTIONS(185),
    [anon_sym_for] = ACTIONS(187),
    [anon_sym_AT] = ACTIONS(83),
    [anon_sym_super] = ACTIONS(95),
    [sym_void_type] = ACTIONS(97),
    [anon_sym_var] = ACTIONS(99),
    [sym__break_builtin] = ACTIONS(105),
    [sym__assert_builtin] = ACTIONS(107),
    [anon_sym_covariant] = ACTIONS(109),
    [anon_sym_Function] = ACTIONS(113),
    [anon_sym_get] = ACTIONS(115),
    [anon_sym_set] = ACTIONS(121),
    [anon_sym_new] = ACTIONS(125),
    [sym_const_builtin] = ACTIONS(165),
    [sym_final_builtin] = ACTIONS(167),
    [anon_sym_late] = ACTIONS(131),
    [anon_sym_this] = ACTIONS(135),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_SLASH_SLASH_SLASH] = ACTIONS(7),
    [sym__block_comment] = ACTIONS(9),
    [sym__documentation_block_comment] = ACTIONS(11),
  },
  [37] = {
    [sym__literal] = STATE(967),
    [sym_symbol_literal] = STATE(912),
    [sym_true] = STATE(912),
    [sym_false] = STATE(912),
    [sym_string_literal] = STATE(912),
    [sym__string_literal_double_quotes] = STATE(617),
    [sym__string_literal_single_quotes] = STATE(617),
    [sym__string_literal_double_quotes_multiple] = STATE(617),
    [sym__string_literal_single_quotes_multiple] = STATE(617),
    [sym__raw_string_literal_double_quotes] = STATE(617),
    [sym__raw_string_literal_single_quotes] = STATE(617),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(617),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(617),
    [sym_list_literal] = STATE(912),
    [sym_set_or_map_literal] = STATE(912),
    [sym_null_literal] = STATE(912),
    [sym__expression] = STATE(2450),
    [sym__real_expression] = STATE(670),
    [sym_throw_expression] = STATE(976),
    [sym_assignment_expression] = STATE(976),
    [sym_assignable_expression] = STATE(1582),
    [sym_lambda_expression] = STATE(494),
    [sym_function_expression] = STATE(967),
    [sym_if_null_expression] = STATE(1377),
    [sym_conditional_expression] = STATE(1377),
    [sym_logical_or_expression] = STATE(1377),
    [sym_logical_and_expression] = STATE(1377),
    [sym_equality_expression] = STATE(1377),
    [sym_type_cast_expression] = STATE(1377),
    [sym_type_test_expression] = STATE(1377),
    [sym_relational_expression] = STATE(1377),
    [sym_bitwise_or_expression] = STATE(1377),
    [sym_bitwise_xor_expression] = STATE(1377),
    [sym_bitwise_and_expression] = STATE(1377),
    [sym_shift_expression] = STATE(1377),
    [sym_additive_expression] = STATE(1377),
    [sym_multiplicative_expression] = STATE(1377),
    [sym__unary_expression] = STATE(1118),
    [sym_unary_expression] = STATE(1169),
    [sym__postfix_expression] = STATE(1169),
    [sym_postfix_expression] = STATE(1170),
    [sym_prefix_operator] = STATE(360),
    [sym_negation_operator] = STATE(1206),
    [sym_tilde_operator] = STATE(1188),
    [sym_await_expression] = STATE(1171),
    [sym_new_expression] = STATE(967),
    [sym_const_object_expression] = STATE(967),
    [sym__primary] = STATE(641),
    [sym_constructor_invocation] = STATE(638),
    [sym_type_arguments] = STATE(2454),
    [sym__statement] = STATE(532),
    [sym_local_function_declaration] = STATE(491),
    [sym_block] = STATE(488),
    [sym_expression_statement] = STATE(488),
    [sym_assert_statement] = STATE(488),
    [sym_assertion] = STATE(2726),
    [sym_switch_statement] = STATE(488),
    [sym_do_statement] = STATE(488),
    [sym_break_statement] = STATE(488),
    [sym_continue_statement] = STATE(488),
    [sym_yield_statement] = STATE(488),
    [sym_yield_each_statement] = STATE(488),
    [sym_return_statement] = STATE(488),
    [sym_try_statement] = STATE(488),
    [sym__try_head] = STATE(1927),
    [sym_if_statement] = STATE(488),
    [sym_while_statement] = STATE(488),
    [sym_for_statement] = STATE(488),
    [sym__annotation] = STATE(1287),
    [sym_marker_annotation] = STATE(1289),
    [sym_annotation] = STATE(1289),
    [sym__metadata] = STATE(1359),
    [sym_type_parameters] = STATE(2299),
    [sym_initialized_variable_definition] = STATE(2472),
    [sym__declared_identifier] = STATE(2151),
    [sym__final_const_var_or_type] = STATE(2686),
    [sym__type] = STATE(2047),
    [sym__type_not_function] = STATE(1616),
    [sym__type_not_void_not_function] = STATE(1668),
    [sym_function_type] = STATE(1655),
    [aux_sym__function_type_tails] = STATE(1482),
    [sym__function_type_tail] = STATE(1568),
    [sym__type_name] = STATE(1722),
    [sym__var_or_type] = STATE(2325),
    [sym_inferred_type] = STATE(1653),
    [sym_function_signature] = STATE(1879),
    [sym__formal_parameter_part] = STATE(1915),
    [sym_formal_parameter_list] = STATE(1636),
    [sym__strict_formal_parameter_list] = STATE(1626),
    [sym_local_variable_declaration] = STATE(509),
    [sym__covariant] = STATE(1552),
    [sym__function_builtin_identifier] = STATE(1424),
    [sym__get] = STATE(1992),
    [sym__set] = STATE(1992),
    [sym__new_builtin] = STATE(1701),
    [sym__late_builtin] = STATE(1618),
    [sym_this] = STATE(967),
    [sym_super] = STATE(1128),
    [sym_comment] = STATE(37),
    [sym_documentation_comment] = STATE(37),
    [aux_sym_program_repeat5] = STATE(38),
    [aux_sym_string_literal_repeat1] = STATE(473),
    [aux_sym__metadata_repeat1] = STATE(1143),
    [sym_identifier] = ACTIONS(15),
    [anon_sym_POUND] = ACTIONS(139),
    [sym_decimal_integer_literal] = ACTIONS(19),
    [sym_hex_integer_literal] = ACTIONS(21),
    [sym_decimal_floating_point_literal] = ACTIONS(19),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(25),
    [anon_sym_DQUOTE] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_r_DQUOTE] = ACTIONS(35),
    [anon_sym_r_SQUOTE] = ACTIONS(37),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(39),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(177),
    [anon_sym_RBRACE] = ACTIONS(358),
    [anon_sym_LBRACK] = ACTIONS(45),
    [anon_sym_null] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_LT] = ACTIONS(53),
    [sym_increment_operator] = ACTIONS(55),
    [sym_minus_operator] = ACTIONS(57),
    [sym__exclamation_operator] = ACTIONS(59),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_await] = ACTIONS(181),
    [anon_sym_switch] = ACTIONS(65),
    [anon_sym_do] = ACTIONS(67),
    [anon_sym_while] = ACTIONS(159),
    [anon_sym_continue] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [anon_sym_return] = ACTIONS(75),
    [anon_sym_try] = ACTIONS(77),
    [anon_sym_if] = ACTIONS(185),
    [anon_sym_for] = ACTIONS(187),
    [anon_sym_AT] = ACTIONS(83),
    [anon_sym_super] = ACTIONS(95),
    [sym_void_type] = ACTIONS(97),
    [anon_sym_var] = ACTIONS(99),
    [sym__break_builtin] = ACTIONS(105),
    [sym__assert_builtin] = ACTIONS(107),
    [anon_sym_covariant] = ACTIONS(109),
    [anon_sym_Function] = ACTIONS(113),
    [anon_sym_get] = ACTIONS(115),
    [anon_sym_set] = ACTIONS(121),
    [anon_sym_new] = ACTIONS(125),
    [sym_const_builtin] = ACTIONS(165),
    [sym_final_builtin] = ACTIONS(167),
    [anon_sym_late] = ACTIONS(131),
    [anon_sym_this] = ACTIONS(135),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_SLASH_SLASH_SLASH] = ACTIONS(7),
    [sym__block_comment] = ACTIONS(9),
    [sym__documentation_block_comment] = ACTIONS(11),
  },
  [38] = {
    [sym__literal] = STATE(967),
    [sym_symbol_literal] = STATE(912),
    [sym_true] = STATE(912),
    [sym_false] = STATE(912),
    [sym_string_literal] = STATE(912),
    [sym__string_literal_double_quotes] = STATE(617),
    [sym__string_literal_single_quotes] = STATE(617),
    [sym__string_literal_double_quotes_multiple] = STATE(617),
    [sym__string_literal_single_quotes_multiple] = STATE(617),
    [sym__raw_string_literal_double_quotes] = STATE(617),
    [sym__raw_string_literal_single_quotes] = STATE(617),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(617),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(617),
    [sym_list_literal] = STATE(912),
    [sym_set_or_map_literal] = STATE(912),
    [sym_null_literal] = STATE(912),
    [sym__expression] = STATE(2450),
    [sym__real_expression] = STATE(670),
    [sym_throw_expression] = STATE(976),
    [sym_assignment_expression] = STATE(976),
    [sym_assignable_expression] = STATE(1582),
    [sym_lambda_expression] = STATE(494),
    [sym_function_expression] = STATE(967),
    [sym_if_null_expression] = STATE(1377),
    [sym_conditional_expression] = STATE(1377),
    [sym_logical_or_expression] = STATE(1377),
    [sym_logical_and_expression] = STATE(1377),
    [sym_equality_expression] = STATE(1377),
    [sym_type_cast_expression] = STATE(1377),
    [sym_type_test_expression] = STATE(1377),
    [sym_relational_expression] = STATE(1377),
    [sym_bitwise_or_expression] = STATE(1377),
    [sym_bitwise_xor_expression] = STATE(1377),
    [sym_bitwise_and_expression] = STATE(1377),
    [sym_shift_expression] = STATE(1377),
    [sym_additive_expression] = STATE(1377),
    [sym_multiplicative_expression] = STATE(1377),
    [sym__unary_expression] = STATE(1118),
    [sym_unary_expression] = STATE(1169),
    [sym__postfix_expression] = STATE(1169),
    [sym_postfix_expression] = STATE(1170),
    [sym_prefix_operator] = STATE(360),
    [sym_negation_operator] = STATE(1206),
    [sym_tilde_operator] = STATE(1188),
    [sym_await_expression] = STATE(1171),
    [sym_new_expression] = STATE(967),
    [sym_const_object_expression] = STATE(967),
    [sym__primary] = STATE(641),
    [sym_constructor_invocation] = STATE(638),
    [sym_type_arguments] = STATE(2454),
    [sym__statement] = STATE(532),
    [sym_local_function_declaration] = STATE(491),
    [sym_block] = STATE(488),
    [sym_expression_statement] = STATE(488),
    [sym_assert_statement] = STATE(488),
    [sym_assertion] = STATE(2726),
    [sym_switch_statement] = STATE(488),
    [sym_do_statement] = STATE(488),
    [sym_break_statement] = STATE(488),
    [sym_continue_statement] = STATE(488),
    [sym_yield_statement] = STATE(488),
    [sym_yield_each_statement] = STATE(488),
    [sym_return_statement] = STATE(488),
    [sym_try_statement] = STATE(488),
    [sym__try_head] = STATE(1927),
    [sym_if_statement] = STATE(488),
    [sym_while_statement] = STATE(488),
    [sym_for_statement] = STATE(488),
    [sym__annotation] = STATE(1287),
    [sym_marker_annotation] = STATE(1289),
    [sym_annotation] = STATE(1289),
    [sym__metadata] = STATE(1359),
    [sym_type_parameters] = STATE(2299),
    [sym_initialized_variable_definition] = STATE(2472),
    [sym__declared_identifier] = STATE(2151),
    [sym__final_const_var_or_type] = STATE(2686),
    [sym__type] = STATE(2047),
    [sym__type_not_function] = STATE(1616),
    [sym__type_not_void_not_function] = STATE(1668),
    [sym_function_type] = STATE(1655),
    [aux_sym__function_type_tails] = STATE(1482),
    [sym__function_type_tail] = STATE(1568),
    [sym__type_name] = STATE(1722),
    [sym__var_or_type] = STATE(2325),
    [sym_inferred_type] = STATE(1653),
    [sym_function_signature] = STATE(1879),
    [sym__formal_parameter_part] = STATE(1915),
    [sym_formal_parameter_list] = STATE(1636),
    [sym__strict_formal_parameter_list] = STATE(1626),
    [sym_local_variable_declaration] = STATE(509),
    [sym__covariant] = STATE(1552),
    [sym__function_builtin_identifier] = STATE(1424),
    [sym__get] = STATE(1992),
    [sym__set] = STATE(1992),
    [sym__new_builtin] = STATE(1701),
    [sym__late_builtin] = STATE(1618),
    [sym_this] = STATE(967),
    [sym_super] = STATE(1128),
    [sym_comment] = STATE(38),
    [sym_documentation_comment] = STATE(38),
    [aux_sym_program_repeat5] = STATE(52),
    [aux_sym_string_literal_repeat1] = STATE(473),
    [aux_sym__metadata_repeat1] = STATE(1143),
    [sym_identifier] = ACTIONS(15),
    [anon_sym_POUND] = ACTIONS(139),
    [sym_decimal_integer_literal] = ACTIONS(19),
    [sym_hex_integer_literal] = ACTIONS(21),
    [sym_decimal_floating_point_literal] = ACTIONS(19),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(25),
    [anon_sym_DQUOTE] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_r_DQUOTE] = ACTIONS(35),
    [anon_sym_r_SQUOTE] = ACTIONS(37),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(39),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(177),
    [anon_sym_RBRACE] = ACTIONS(360),
    [anon_sym_LBRACK] = ACTIONS(45),
    [anon_sym_null] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_LT] = ACTIONS(53),
    [sym_increment_operator] = ACTIONS(55),
    [sym_minus_operator] = ACTIONS(57),
    [sym__exclamation_operator] = ACTIONS(59),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_await] = ACTIONS(181),
    [anon_sym_switch] = ACTIONS(65),
    [anon_sym_do] = ACTIONS(67),
    [anon_sym_while] = ACTIONS(159),
    [anon_sym_continue] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [anon_sym_return] = ACTIONS(75),
    [anon_sym_try] = ACTIONS(77),
    [anon_sym_if] = ACTIONS(185),
    [anon_sym_for] = ACTIONS(187),
    [anon_sym_AT] = ACTIONS(83),
    [anon_sym_super] = ACTIONS(95),
    [sym_void_type] = ACTIONS(97),
    [anon_sym_var] = ACTIONS(99),
    [sym__break_builtin] = ACTIONS(105),
    [sym__assert_builtin] = ACTIONS(107),
    [anon_sym_covariant] = ACTIONS(109),
    [anon_sym_Function] = ACTIONS(113),
    [anon_sym_get] = ACTIONS(115),
    [anon_sym_set] = ACTIONS(121),
    [anon_sym_new] = ACTIONS(125),
    [sym_const_builtin] = ACTIONS(165),
    [sym_final_builtin] = ACTIONS(167),
    [anon_sym_late] = ACTIONS(131),
    [anon_sym_this] = ACTIONS(135),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_SLASH_SLASH_SLASH] = ACTIONS(7),
    [sym__block_comment] = ACTIONS(9),
    [sym__documentation_block_comment] = ACTIONS(11),
  },
  [39] = {
    [sym__literal] = STATE(967),
    [sym_symbol_literal] = STATE(912),
    [sym_true] = STATE(912),
    [sym_false] = STATE(912),
    [sym_string_literal] = STATE(912),
    [sym__string_literal_double_quotes] = STATE(617),
    [sym__string_literal_single_quotes] = STATE(617),
    [sym__string_literal_double_quotes_multiple] = STATE(617),
    [sym__string_literal_single_quotes_multiple] = STATE(617),
    [sym__raw_string_literal_double_quotes] = STATE(617),
    [sym__raw_string_literal_single_quotes] = STATE(617),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(617),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(617),
    [sym_list_literal] = STATE(912),
    [sym_set_or_map_literal] = STATE(912),
    [sym_null_literal] = STATE(912),
    [sym__expression] = STATE(2450),
    [sym__real_expression] = STATE(670),
    [sym_throw_expression] = STATE(976),
    [sym_assignment_expression] = STATE(976),
    [sym_assignable_expression] = STATE(1582),
    [sym_lambda_expression] = STATE(494),
    [sym_function_expression] = STATE(967),
    [sym_if_null_expression] = STATE(1377),
    [sym_conditional_expression] = STATE(1377),
    [sym_logical_or_expression] = STATE(1377),
    [sym_logical_and_expression] = STATE(1377),
    [sym_equality_expression] = STATE(1377),
    [sym_type_cast_expression] = STATE(1377),
    [sym_type_test_expression] = STATE(1377),
    [sym_relational_expression] = STATE(1377),
    [sym_bitwise_or_expression] = STATE(1377),
    [sym_bitwise_xor_expression] = STATE(1377),
    [sym_bitwise_and_expression] = STATE(1377),
    [sym_shift_expression] = STATE(1377),
    [sym_additive_expression] = STATE(1377),
    [sym_multiplicative_expression] = STATE(1377),
    [sym__unary_expression] = STATE(1118),
    [sym_unary_expression] = STATE(1169),
    [sym__postfix_expression] = STATE(1169),
    [sym_postfix_expression] = STATE(1170),
    [sym_prefix_operator] = STATE(360),
    [sym_negation_operator] = STATE(1206),
    [sym_tilde_operator] = STATE(1188),
    [sym_await_expression] = STATE(1171),
    [sym_new_expression] = STATE(967),
    [sym_const_object_expression] = STATE(967),
    [sym__primary] = STATE(641),
    [sym_constructor_invocation] = STATE(638),
    [sym_type_arguments] = STATE(2454),
    [sym__statement] = STATE(532),
    [sym_local_function_declaration] = STATE(491),
    [sym_block] = STATE(488),
    [sym_expression_statement] = STATE(488),
    [sym_assert_statement] = STATE(488),
    [sym_assertion] = STATE(2726),
    [sym_switch_statement] = STATE(488),
    [sym_do_statement] = STATE(488),
    [sym_break_statement] = STATE(488),
    [sym_continue_statement] = STATE(488),
    [sym_yield_statement] = STATE(488),
    [sym_yield_each_statement] = STATE(488),
    [sym_return_statement] = STATE(488),
    [sym_try_statement] = STATE(488),
    [sym__try_head] = STATE(1927),
    [sym_if_statement] = STATE(488),
    [sym_while_statement] = STATE(488),
    [sym_for_statement] = STATE(488),
    [sym__annotation] = STATE(1287),
    [sym_marker_annotation] = STATE(1289),
    [sym_annotation] = STATE(1289),
    [sym__metadata] = STATE(1359),
    [sym_type_parameters] = STATE(2299),
    [sym_initialized_variable_definition] = STATE(2472),
    [sym__declared_identifier] = STATE(2151),
    [sym__final_const_var_or_type] = STATE(2686),
    [sym__type] = STATE(2047),
    [sym__type_not_function] = STATE(1616),
    [sym__type_not_void_not_function] = STATE(1668),
    [sym_function_type] = STATE(1655),
    [aux_sym__function_type_tails] = STATE(1482),
    [sym__function_type_tail] = STATE(1568),
    [sym__type_name] = STATE(1722),
    [sym__var_or_type] = STATE(2325),
    [sym_inferred_type] = STATE(1653),
    [sym_function_signature] = STATE(1879),
    [sym__formal_parameter_part] = STATE(1915),
    [sym_formal_parameter_list] = STATE(1636),
    [sym__strict_formal_parameter_list] = STATE(1626),
    [sym_local_variable_declaration] = STATE(509),
    [sym__covariant] = STATE(1552),
    [sym__function_builtin_identifier] = STATE(1424),
    [sym__get] = STATE(1992),
    [sym__set] = STATE(1992),
    [sym__new_builtin] = STATE(1701),
    [sym__late_builtin] = STATE(1618),
    [sym_this] = STATE(967),
    [sym_super] = STATE(1128),
    [sym_comment] = STATE(39),
    [sym_documentation_comment] = STATE(39),
    [aux_sym_program_repeat5] = STATE(44),
    [aux_sym_string_literal_repeat1] = STATE(473),
    [aux_sym__metadata_repeat1] = STATE(1143),
    [ts_builtin_sym_end] = ACTIONS(143),
    [sym_identifier] = ACTIONS(15),
    [anon_sym_POUND] = ACTIONS(139),
    [sym_decimal_integer_literal] = ACTIONS(19),
    [sym_hex_integer_literal] = ACTIONS(21),
    [sym_decimal_floating_point_literal] = ACTIONS(19),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(25),
    [anon_sym_DQUOTE] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_r_DQUOTE] = ACTIONS(35),
    [anon_sym_r_SQUOTE] = ACTIONS(37),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(39),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(43),
    [anon_sym_LBRACK] = ACTIONS(45),
    [anon_sym_null] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_LT] = ACTIONS(53),
    [sym_increment_operator] = ACTIONS(55),
    [sym_minus_operator] = ACTIONS(57),
    [sym__exclamation_operator] = ACTIONS(59),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_await] = ACTIONS(63),
    [anon_sym_switch] = ACTIONS(65),
    [anon_sym_do] = ACTIONS(67),
    [anon_sym_while] = ACTIONS(69),
    [anon_sym_continue] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [anon_sym_return] = ACTIONS(75),
    [anon_sym_try] = ACTIONS(77),
    [anon_sym_if] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_AT] = ACTIONS(83),
    [anon_sym_super] = ACTIONS(95),
    [sym_void_type] = ACTIONS(97),
    [anon_sym_var] = ACTIONS(99),
    [sym__break_builtin] = ACTIONS(105),
    [sym__assert_builtin] = ACTIONS(107),
    [anon_sym_covariant] = ACTIONS(109),
    [anon_sym_Function] = ACTIONS(113),
    [anon_sym_get] = ACTIONS(115),
    [anon_sym_set] = ACTIONS(121),
    [anon_sym_new] = ACTIONS(125),
    [sym_const_builtin] = ACTIONS(165),
    [sym_final_builtin] = ACTIONS(167),
    [anon_sym_late] = ACTIONS(131),
    [anon_sym_this] = ACTIONS(135),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_SLASH_SLASH_SLASH] = ACTIONS(7),
    [sym__block_comment] = ACTIONS(9),
    [sym__documentation_block_comment] = ACTIONS(11),
  },
  [40] = {
    [sym__literal] = STATE(967),
    [sym_symbol_literal] = STATE(912),
    [sym_true] = STATE(912),
    [sym_false] = STATE(912),
    [sym_string_literal] = STATE(912),
    [sym__string_literal_double_quotes] = STATE(617),
    [sym__string_literal_single_quotes] = STATE(617),
    [sym__string_literal_double_quotes_multiple] = STATE(617),
    [sym__string_literal_single_quotes_multiple] = STATE(617),
    [sym__raw_string_literal_double_quotes] = STATE(617),
    [sym__raw_string_literal_single_quotes] = STATE(617),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(617),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(617),
    [sym_list_literal] = STATE(912),
    [sym_set_or_map_literal] = STATE(912),
    [sym_null_literal] = STATE(912),
    [sym__expression] = STATE(2450),
    [sym__real_expression] = STATE(670),
    [sym_throw_expression] = STATE(976),
    [sym_assignment_expression] = STATE(976),
    [sym_assignable_expression] = STATE(1582),
    [sym_lambda_expression] = STATE(494),
    [sym_function_expression] = STATE(967),
    [sym_if_null_expression] = STATE(1377),
    [sym_conditional_expression] = STATE(1377),
    [sym_logical_or_expression] = STATE(1377),
    [sym_logical_and_expression] = STATE(1377),
    [sym_equality_expression] = STATE(1377),
    [sym_type_cast_expression] = STATE(1377),
    [sym_type_test_expression] = STATE(1377),
    [sym_relational_expression] = STATE(1377),
    [sym_bitwise_or_expression] = STATE(1377),
    [sym_bitwise_xor_expression] = STATE(1377),
    [sym_bitwise_and_expression] = STATE(1377),
    [sym_shift_expression] = STATE(1377),
    [sym_additive_expression] = STATE(1377),
    [sym_multiplicative_expression] = STATE(1377),
    [sym__unary_expression] = STATE(1118),
    [sym_unary_expression] = STATE(1169),
    [sym__postfix_expression] = STATE(1169),
    [sym_postfix_expression] = STATE(1170),
    [sym_prefix_operator] = STATE(360),
    [sym_negation_operator] = STATE(1206),
    [sym_tilde_operator] = STATE(1188),
    [sym_await_expression] = STATE(1171),
    [sym_new_expression] = STATE(967),
    [sym_const_object_expression] = STATE(967),
    [sym__primary] = STATE(641),
    [sym_constructor_invocation] = STATE(638),
    [sym_type_arguments] = STATE(2454),
    [sym__statement] = STATE(532),
    [sym_local_function_declaration] = STATE(491),
    [sym_block] = STATE(488),
    [sym_expression_statement] = STATE(488),
    [sym_assert_statement] = STATE(488),
    [sym_assertion] = STATE(2726),
    [sym_switch_statement] = STATE(488),
    [sym_do_statement] = STATE(488),
    [sym_break_statement] = STATE(488),
    [sym_continue_statement] = STATE(488),
    [sym_yield_statement] = STATE(488),
    [sym_yield_each_statement] = STATE(488),
    [sym_return_statement] = STATE(488),
    [sym_try_statement] = STATE(488),
    [sym__try_head] = STATE(1927),
    [sym_if_statement] = STATE(488),
    [sym_while_statement] = STATE(488),
    [sym_for_statement] = STATE(488),
    [sym__annotation] = STATE(1287),
    [sym_marker_annotation] = STATE(1289),
    [sym_annotation] = STATE(1289),
    [sym__metadata] = STATE(1359),
    [sym_type_parameters] = STATE(2299),
    [sym_initialized_variable_definition] = STATE(2472),
    [sym__declared_identifier] = STATE(2151),
    [sym__final_const_var_or_type] = STATE(2686),
    [sym__type] = STATE(2047),
    [sym__type_not_function] = STATE(1616),
    [sym__type_not_void_not_function] = STATE(1668),
    [sym_function_type] = STATE(1655),
    [aux_sym__function_type_tails] = STATE(1482),
    [sym__function_type_tail] = STATE(1568),
    [sym__type_name] = STATE(1722),
    [sym__var_or_type] = STATE(2325),
    [sym_inferred_type] = STATE(1653),
    [sym_function_signature] = STATE(1879),
    [sym__formal_parameter_part] = STATE(1915),
    [sym_formal_parameter_list] = STATE(1636),
    [sym__strict_formal_parameter_list] = STATE(1626),
    [sym_local_variable_declaration] = STATE(509),
    [sym__covariant] = STATE(1552),
    [sym__function_builtin_identifier] = STATE(1424),
    [sym__get] = STATE(1992),
    [sym__set] = STATE(1992),
    [sym__new_builtin] = STATE(1701),
    [sym__late_builtin] = STATE(1618),
    [sym_this] = STATE(967),
    [sym_super] = STATE(1128),
    [sym_comment] = STATE(40),
    [sym_documentation_comment] = STATE(40),
    [aux_sym_program_repeat5] = STATE(52),
    [aux_sym_string_literal_repeat1] = STATE(473),
    [aux_sym__metadata_repeat1] = STATE(1143),
    [sym_identifier] = ACTIONS(15),
    [anon_sym_POUND] = ACTIONS(139),
    [sym_decimal_integer_literal] = ACTIONS(19),
    [sym_hex_integer_literal] = ACTIONS(21),
    [sym_decimal_floating_point_literal] = ACTIONS(19),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(25),
    [anon_sym_DQUOTE] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_r_DQUOTE] = ACTIONS(35),
    [anon_sym_r_SQUOTE] = ACTIONS(37),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(39),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(177),
    [anon_sym_RBRACE] = ACTIONS(362),
    [anon_sym_LBRACK] = ACTIONS(45),
    [anon_sym_null] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_LT] = ACTIONS(53),
    [sym_increment_operator] = ACTIONS(55),
    [sym_minus_operator] = ACTIONS(57),
    [sym__exclamation_operator] = ACTIONS(59),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_await] = ACTIONS(181),
    [anon_sym_switch] = ACTIONS(65),
    [anon_sym_do] = ACTIONS(67),
    [anon_sym_while] = ACTIONS(159),
    [anon_sym_continue] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [anon_sym_return] = ACTIONS(75),
    [anon_sym_try] = ACTIONS(77),
    [anon_sym_if] = ACTIONS(185),
    [anon_sym_for] = ACTIONS(187),
    [anon_sym_AT] = ACTIONS(83),
    [anon_sym_super] = ACTIONS(95),
    [sym_void_type] = ACTIONS(97),
    [anon_sym_var] = ACTIONS(99),
    [sym__break_builtin] = ACTIONS(105),
    [sym__assert_builtin] = ACTIONS(107),
    [anon_sym_covariant] = ACTIONS(109),
    [anon_sym_Function] = ACTIONS(113),
    [anon_sym_get] = ACTIONS(115),
    [anon_sym_set] = ACTIONS(121),
    [anon_sym_new] = ACTIONS(125),
    [sym_const_builtin] = ACTIONS(165),
    [sym_final_builtin] = ACTIONS(167),
    [anon_sym_late] = ACTIONS(131),
    [anon_sym_this] = ACTIONS(135),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_SLASH_SLASH_SLASH] = ACTIONS(7),
    [sym__block_comment] = ACTIONS(9),
    [sym__documentation_block_comment] = ACTIONS(11),
  },
  [41] = {
    [sym__literal] = STATE(967),
    [sym_symbol_literal] = STATE(912),
    [sym_true] = STATE(912),
    [sym_false] = STATE(912),
    [sym_string_literal] = STATE(912),
    [sym__string_literal_double_quotes] = STATE(617),
    [sym__string_literal_single_quotes] = STATE(617),
    [sym__string_literal_double_quotes_multiple] = STATE(617),
    [sym__string_literal_single_quotes_multiple] = STATE(617),
    [sym__raw_string_literal_double_quotes] = STATE(617),
    [sym__raw_string_literal_single_quotes] = STATE(617),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(617),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(617),
    [sym_list_literal] = STATE(912),
    [sym_set_or_map_literal] = STATE(912),
    [sym_null_literal] = STATE(912),
    [sym__expression] = STATE(2450),
    [sym__real_expression] = STATE(670),
    [sym_throw_expression] = STATE(976),
    [sym_assignment_expression] = STATE(976),
    [sym_assignable_expression] = STATE(1582),
    [sym_lambda_expression] = STATE(494),
    [sym_function_expression] = STATE(967),
    [sym_if_null_expression] = STATE(1377),
    [sym_conditional_expression] = STATE(1377),
    [sym_logical_or_expression] = STATE(1377),
    [sym_logical_and_expression] = STATE(1377),
    [sym_equality_expression] = STATE(1377),
    [sym_type_cast_expression] = STATE(1377),
    [sym_type_test_expression] = STATE(1377),
    [sym_relational_expression] = STATE(1377),
    [sym_bitwise_or_expression] = STATE(1377),
    [sym_bitwise_xor_expression] = STATE(1377),
    [sym_bitwise_and_expression] = STATE(1377),
    [sym_shift_expression] = STATE(1377),
    [sym_additive_expression] = STATE(1377),
    [sym_multiplicative_expression] = STATE(1377),
    [sym__unary_expression] = STATE(1118),
    [sym_unary_expression] = STATE(1169),
    [sym__postfix_expression] = STATE(1169),
    [sym_postfix_expression] = STATE(1170),
    [sym_prefix_operator] = STATE(360),
    [sym_negation_operator] = STATE(1206),
    [sym_tilde_operator] = STATE(1188),
    [sym_await_expression] = STATE(1171),
    [sym_new_expression] = STATE(967),
    [sym_const_object_expression] = STATE(967),
    [sym__primary] = STATE(641),
    [sym_constructor_invocation] = STATE(638),
    [sym_type_arguments] = STATE(2454),
    [sym__statement] = STATE(532),
    [sym_local_function_declaration] = STATE(491),
    [sym_block] = STATE(488),
    [sym_expression_statement] = STATE(488),
    [sym_assert_statement] = STATE(488),
    [sym_assertion] = STATE(2726),
    [sym_switch_statement] = STATE(488),
    [sym_do_statement] = STATE(488),
    [sym_break_statement] = STATE(488),
    [sym_continue_statement] = STATE(488),
    [sym_yield_statement] = STATE(488),
    [sym_yield_each_statement] = STATE(488),
    [sym_return_statement] = STATE(488),
    [sym_try_statement] = STATE(488),
    [sym__try_head] = STATE(1927),
    [sym_if_statement] = STATE(488),
    [sym_while_statement] = STATE(488),
    [sym_for_statement] = STATE(488),
    [sym__annotation] = STATE(1287),
    [sym_marker_annotation] = STATE(1289),
    [sym_annotation] = STATE(1289),
    [sym__metadata] = STATE(1359),
    [sym_type_parameters] = STATE(2299),
    [sym_initialized_variable_definition] = STATE(2472),
    [sym__declared_identifier] = STATE(2151),
    [sym__final_const_var_or_type] = STATE(2686),
    [sym__type] = STATE(2047),
    [sym__type_not_function] = STATE(1616),
    [sym__type_not_void_not_function] = STATE(1668),
    [sym_function_type] = STATE(1655),
    [aux_sym__function_type_tails] = STATE(1482),
    [sym__function_type_tail] = STATE(1568),
    [sym__type_name] = STATE(1722),
    [sym__var_or_type] = STATE(2325),
    [sym_inferred_type] = STATE(1653),
    [sym_function_signature] = STATE(1879),
    [sym__formal_parameter_part] = STATE(1915),
    [sym_formal_parameter_list] = STATE(1636),
    [sym__strict_formal_parameter_list] = STATE(1626),
    [sym_local_variable_declaration] = STATE(509),
    [sym__covariant] = STATE(1552),
    [sym__function_builtin_identifier] = STATE(1424),
    [sym__get] = STATE(1992),
    [sym__set] = STATE(1992),
    [sym__new_builtin] = STATE(1701),
    [sym__late_builtin] = STATE(1618),
    [sym_this] = STATE(967),
    [sym_super] = STATE(1128),
    [sym_comment] = STATE(41),
    [sym_documentation_comment] = STATE(41),
    [aux_sym_program_repeat5] = STATE(52),
    [aux_sym_string_literal_repeat1] = STATE(473),
    [aux_sym__metadata_repeat1] = STATE(1143),
    [sym_identifier] = ACTIONS(15),
    [anon_sym_POUND] = ACTIONS(139),
    [sym_decimal_integer_literal] = ACTIONS(19),
    [sym_hex_integer_literal] = ACTIONS(21),
    [sym_decimal_floating_point_literal] = ACTIONS(19),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(25),
    [anon_sym_DQUOTE] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_r_DQUOTE] = ACTIONS(35),
    [anon_sym_r_SQUOTE] = ACTIONS(37),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(39),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(177),
    [anon_sym_RBRACE] = ACTIONS(364),
    [anon_sym_LBRACK] = ACTIONS(45),
    [anon_sym_null] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_LT] = ACTIONS(53),
    [sym_increment_operator] = ACTIONS(55),
    [sym_minus_operator] = ACTIONS(57),
    [sym__exclamation_operator] = ACTIONS(59),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_await] = ACTIONS(181),
    [anon_sym_switch] = ACTIONS(65),
    [anon_sym_do] = ACTIONS(67),
    [anon_sym_while] = ACTIONS(159),
    [anon_sym_continue] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [anon_sym_return] = ACTIONS(75),
    [anon_sym_try] = ACTIONS(77),
    [anon_sym_if] = ACTIONS(185),
    [anon_sym_for] = ACTIONS(187),
    [anon_sym_AT] = ACTIONS(83),
    [anon_sym_super] = ACTIONS(95),
    [sym_void_type] = ACTIONS(97),
    [anon_sym_var] = ACTIONS(99),
    [sym__break_builtin] = ACTIONS(105),
    [sym__assert_builtin] = ACTIONS(107),
    [anon_sym_covariant] = ACTIONS(109),
    [anon_sym_Function] = ACTIONS(113),
    [anon_sym_get] = ACTIONS(115),
    [anon_sym_set] = ACTIONS(121),
    [anon_sym_new] = ACTIONS(125),
    [sym_const_builtin] = ACTIONS(165),
    [sym_final_builtin] = ACTIONS(167),
    [anon_sym_late] = ACTIONS(131),
    [anon_sym_this] = ACTIONS(135),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_SLASH_SLASH_SLASH] = ACTIONS(7),
    [sym__block_comment] = ACTIONS(9),
    [sym__documentation_block_comment] = ACTIONS(11),
  },
  [42] = {
    [sym__literal] = STATE(967),
    [sym_symbol_literal] = STATE(912),
    [sym_true] = STATE(912),
    [sym_false] = STATE(912),
    [sym_string_literal] = STATE(912),
    [sym__string_literal_double_quotes] = STATE(617),
    [sym__string_literal_single_quotes] = STATE(617),
    [sym__string_literal_double_quotes_multiple] = STATE(617),
    [sym__string_literal_single_quotes_multiple] = STATE(617),
    [sym__raw_string_literal_double_quotes] = STATE(617),
    [sym__raw_string_literal_single_quotes] = STATE(617),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(617),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(617),
    [sym_list_literal] = STATE(912),
    [sym_set_or_map_literal] = STATE(912),
    [sym_null_literal] = STATE(912),
    [sym__expression] = STATE(2450),
    [sym__real_expression] = STATE(670),
    [sym_throw_expression] = STATE(976),
    [sym_assignment_expression] = STATE(976),
    [sym_assignable_expression] = STATE(1582),
    [sym_lambda_expression] = STATE(494),
    [sym_function_expression] = STATE(967),
    [sym_if_null_expression] = STATE(1377),
    [sym_conditional_expression] = STATE(1377),
    [sym_logical_or_expression] = STATE(1377),
    [sym_logical_and_expression] = STATE(1377),
    [sym_equality_expression] = STATE(1377),
    [sym_type_cast_expression] = STATE(1377),
    [sym_type_test_expression] = STATE(1377),
    [sym_relational_expression] = STATE(1377),
    [sym_bitwise_or_expression] = STATE(1377),
    [sym_bitwise_xor_expression] = STATE(1377),
    [sym_bitwise_and_expression] = STATE(1377),
    [sym_shift_expression] = STATE(1377),
    [sym_additive_expression] = STATE(1377),
    [sym_multiplicative_expression] = STATE(1377),
    [sym__unary_expression] = STATE(1118),
    [sym_unary_expression] = STATE(1169),
    [sym__postfix_expression] = STATE(1169),
    [sym_postfix_expression] = STATE(1170),
    [sym_prefix_operator] = STATE(360),
    [sym_negation_operator] = STATE(1206),
    [sym_tilde_operator] = STATE(1188),
    [sym_await_expression] = STATE(1171),
    [sym_new_expression] = STATE(967),
    [sym_const_object_expression] = STATE(967),
    [sym__primary] = STATE(641),
    [sym_constructor_invocation] = STATE(638),
    [sym_type_arguments] = STATE(2454),
    [sym__statement] = STATE(532),
    [sym_local_function_declaration] = STATE(491),
    [sym_block] = STATE(488),
    [sym_expression_statement] = STATE(488),
    [sym_assert_statement] = STATE(488),
    [sym_assertion] = STATE(2726),
    [sym_switch_statement] = STATE(488),
    [sym_do_statement] = STATE(488),
    [sym_break_statement] = STATE(488),
    [sym_continue_statement] = STATE(488),
    [sym_yield_statement] = STATE(488),
    [sym_yield_each_statement] = STATE(488),
    [sym_return_statement] = STATE(488),
    [sym_try_statement] = STATE(488),
    [sym__try_head] = STATE(1927),
    [sym_if_statement] = STATE(488),
    [sym_while_statement] = STATE(488),
    [sym_for_statement] = STATE(488),
    [sym__annotation] = STATE(1287),
    [sym_marker_annotation] = STATE(1289),
    [sym_annotation] = STATE(1289),
    [sym__metadata] = STATE(1359),
    [sym_type_parameters] = STATE(2299),
    [sym_initialized_variable_definition] = STATE(2472),
    [sym__declared_identifier] = STATE(2151),
    [sym__final_const_var_or_type] = STATE(2686),
    [sym__type] = STATE(2047),
    [sym__type_not_function] = STATE(1616),
    [sym__type_not_void_not_function] = STATE(1668),
    [sym_function_type] = STATE(1655),
    [aux_sym__function_type_tails] = STATE(1482),
    [sym__function_type_tail] = STATE(1568),
    [sym__type_name] = STATE(1722),
    [sym__var_or_type] = STATE(2325),
    [sym_inferred_type] = STATE(1653),
    [sym_function_signature] = STATE(1879),
    [sym__formal_parameter_part] = STATE(1915),
    [sym_formal_parameter_list] = STATE(1636),
    [sym__strict_formal_parameter_list] = STATE(1626),
    [sym_local_variable_declaration] = STATE(509),
    [sym__covariant] = STATE(1552),
    [sym__function_builtin_identifier] = STATE(1424),
    [sym__get] = STATE(1992),
    [sym__set] = STATE(1992),
    [sym__new_builtin] = STATE(1701),
    [sym__late_builtin] = STATE(1618),
    [sym_this] = STATE(967),
    [sym_super] = STATE(1128),
    [sym_comment] = STATE(42),
    [sym_documentation_comment] = STATE(42),
    [aux_sym_program_repeat5] = STATE(41),
    [aux_sym_string_literal_repeat1] = STATE(473),
    [aux_sym__metadata_repeat1] = STATE(1143),
    [sym_identifier] = ACTIONS(15),
    [anon_sym_POUND] = ACTIONS(139),
    [sym_decimal_integer_literal] = ACTIONS(19),
    [sym_hex_integer_literal] = ACTIONS(21),
    [sym_decimal_floating_point_literal] = ACTIONS(19),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(25),
    [anon_sym_DQUOTE] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_r_DQUOTE] = ACTIONS(35),
    [anon_sym_r_SQUOTE] = ACTIONS(37),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(39),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(177),
    [anon_sym_RBRACE] = ACTIONS(358),
    [anon_sym_LBRACK] = ACTIONS(45),
    [anon_sym_null] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_LT] = ACTIONS(53),
    [sym_increment_operator] = ACTIONS(55),
    [sym_minus_operator] = ACTIONS(57),
    [sym__exclamation_operator] = ACTIONS(59),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_await] = ACTIONS(181),
    [anon_sym_switch] = ACTIONS(65),
    [anon_sym_do] = ACTIONS(67),
    [anon_sym_while] = ACTIONS(159),
    [anon_sym_continue] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [anon_sym_return] = ACTIONS(75),
    [anon_sym_try] = ACTIONS(77),
    [anon_sym_if] = ACTIONS(185),
    [anon_sym_for] = ACTIONS(187),
    [anon_sym_AT] = ACTIONS(83),
    [anon_sym_super] = ACTIONS(95),
    [sym_void_type] = ACTIONS(97),
    [anon_sym_var] = ACTIONS(99),
    [sym__break_builtin] = ACTIONS(105),
    [sym__assert_builtin] = ACTIONS(107),
    [anon_sym_covariant] = ACTIONS(109),
    [anon_sym_Function] = ACTIONS(113),
    [anon_sym_get] = ACTIONS(115),
    [anon_sym_set] = ACTIONS(121),
    [anon_sym_new] = ACTIONS(125),
    [sym_const_builtin] = ACTIONS(165),
    [sym_final_builtin] = ACTIONS(167),
    [anon_sym_late] = ACTIONS(131),
    [anon_sym_this] = ACTIONS(135),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_SLASH_SLASH_SLASH] = ACTIONS(7),
    [sym__block_comment] = ACTIONS(9),
    [sym__documentation_block_comment] = ACTIONS(11),
  },
  [43] = {
    [sym__literal] = STATE(967),
    [sym_symbol_literal] = STATE(912),
    [sym_true] = STATE(912),
    [sym_false] = STATE(912),
    [sym_string_literal] = STATE(912),
    [sym__string_literal_double_quotes] = STATE(617),
    [sym__string_literal_single_quotes] = STATE(617),
    [sym__string_literal_double_quotes_multiple] = STATE(617),
    [sym__string_literal_single_quotes_multiple] = STATE(617),
    [sym__raw_string_literal_double_quotes] = STATE(617),
    [sym__raw_string_literal_single_quotes] = STATE(617),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(617),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(617),
    [sym_list_literal] = STATE(912),
    [sym_set_or_map_literal] = STATE(912),
    [sym_null_literal] = STATE(912),
    [sym__expression] = STATE(2450),
    [sym__real_expression] = STATE(670),
    [sym_throw_expression] = STATE(976),
    [sym_assignment_expression] = STATE(976),
    [sym_assignable_expression] = STATE(1582),
    [sym_lambda_expression] = STATE(494),
    [sym_function_expression] = STATE(967),
    [sym_if_null_expression] = STATE(1377),
    [sym_conditional_expression] = STATE(1377),
    [sym_logical_or_expression] = STATE(1377),
    [sym_logical_and_expression] = STATE(1377),
    [sym_equality_expression] = STATE(1377),
    [sym_type_cast_expression] = STATE(1377),
    [sym_type_test_expression] = STATE(1377),
    [sym_relational_expression] = STATE(1377),
    [sym_bitwise_or_expression] = STATE(1377),
    [sym_bitwise_xor_expression] = STATE(1377),
    [sym_bitwise_and_expression] = STATE(1377),
    [sym_shift_expression] = STATE(1377),
    [sym_additive_expression] = STATE(1377),
    [sym_multiplicative_expression] = STATE(1377),
    [sym__unary_expression] = STATE(1118),
    [sym_unary_expression] = STATE(1169),
    [sym__postfix_expression] = STATE(1169),
    [sym_postfix_expression] = STATE(1170),
    [sym_prefix_operator] = STATE(360),
    [sym_negation_operator] = STATE(1206),
    [sym_tilde_operator] = STATE(1188),
    [sym_await_expression] = STATE(1171),
    [sym_new_expression] = STATE(967),
    [sym_const_object_expression] = STATE(967),
    [sym__primary] = STATE(641),
    [sym_constructor_invocation] = STATE(638),
    [sym_type_arguments] = STATE(2454),
    [sym__statement] = STATE(532),
    [sym_local_function_declaration] = STATE(491),
    [sym_block] = STATE(488),
    [sym_expression_statement] = STATE(488),
    [sym_assert_statement] = STATE(488),
    [sym_assertion] = STATE(2726),
    [sym_switch_statement] = STATE(488),
    [sym_do_statement] = STATE(488),
    [sym_break_statement] = STATE(488),
    [sym_continue_statement] = STATE(488),
    [sym_yield_statement] = STATE(488),
    [sym_yield_each_statement] = STATE(488),
    [sym_return_statement] = STATE(488),
    [sym_try_statement] = STATE(488),
    [sym__try_head] = STATE(1927),
    [sym_if_statement] = STATE(488),
    [sym_while_statement] = STATE(488),
    [sym_for_statement] = STATE(488),
    [sym__annotation] = STATE(1287),
    [sym_marker_annotation] = STATE(1289),
    [sym_annotation] = STATE(1289),
    [sym__metadata] = STATE(1359),
    [sym_type_parameters] = STATE(2299),
    [sym_initialized_variable_definition] = STATE(2472),
    [sym__declared_identifier] = STATE(2151),
    [sym__final_const_var_or_type] = STATE(2686),
    [sym__type] = STATE(2047),
    [sym__type_not_function] = STATE(1616),
    [sym__type_not_void_not_function] = STATE(1668),
    [sym_function_type] = STATE(1655),
    [aux_sym__function_type_tails] = STATE(1482),
    [sym__function_type_tail] = STATE(1568),
    [sym__type_name] = STATE(1722),
    [sym__var_or_type] = STATE(2325),
    [sym_inferred_type] = STATE(1653),
    [sym_function_signature] = STATE(1879),
    [sym__formal_parameter_part] = STATE(1915),
    [sym_formal_parameter_list] = STATE(1636),
    [sym__strict_formal_parameter_list] = STATE(1626),
    [sym_local_variable_declaration] = STATE(509),
    [sym__covariant] = STATE(1552),
    [sym__function_builtin_identifier] = STATE(1424),
    [sym__get] = STATE(1992),
    [sym__set] = STATE(1992),
    [sym__new_builtin] = STATE(1701),
    [sym__late_builtin] = STATE(1618),
    [sym_this] = STATE(967),
    [sym_super] = STATE(1128),
    [sym_comment] = STATE(43),
    [sym_documentation_comment] = STATE(43),
    [aux_sym_program_repeat5] = STATE(44),
    [aux_sym_string_literal_repeat1] = STATE(473),
    [aux_sym__metadata_repeat1] = STATE(1143),
    [ts_builtin_sym_end] = ACTIONS(137),
    [sym_identifier] = ACTIONS(15),
    [anon_sym_POUND] = ACTIONS(139),
    [sym_decimal_integer_literal] = ACTIONS(19),
    [sym_hex_integer_literal] = ACTIONS(21),
    [sym_decimal_floating_point_literal] = ACTIONS(19),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(25),
    [anon_sym_DQUOTE] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_r_DQUOTE] = ACTIONS(35),
    [anon_sym_r_SQUOTE] = ACTIONS(37),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(39),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(43),
    [anon_sym_LBRACK] = ACTIONS(45),
    [anon_sym_null] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_LT] = ACTIONS(53),
    [sym_increment_operator] = ACTIONS(55),
    [sym_minus_operator] = ACTIONS(57),
    [sym__exclamation_operator] = ACTIONS(59),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_await] = ACTIONS(63),
    [anon_sym_switch] = ACTIONS(65),
    [anon_sym_do] = ACTIONS(67),
    [anon_sym_while] = ACTIONS(69),
    [anon_sym_continue] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [anon_sym_return] = ACTIONS(75),
    [anon_sym_try] = ACTIONS(77),
    [anon_sym_if] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_AT] = ACTIONS(83),
    [anon_sym_super] = ACTIONS(95),
    [sym_void_type] = ACTIONS(97),
    [anon_sym_var] = ACTIONS(99),
    [sym__break_builtin] = ACTIONS(105),
    [sym__assert_builtin] = ACTIONS(107),
    [anon_sym_covariant] = ACTIONS(109),
    [anon_sym_Function] = ACTIONS(113),
    [anon_sym_get] = ACTIONS(115),
    [anon_sym_set] = ACTIONS(121),
    [anon_sym_new] = ACTIONS(125),
    [sym_const_builtin] = ACTIONS(165),
    [sym_final_builtin] = ACTIONS(167),
    [anon_sym_late] = ACTIONS(131),
    [anon_sym_this] = ACTIONS(135),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_SLASH_SLASH_SLASH] = ACTIONS(7),
    [sym__block_comment] = ACTIONS(9),
    [sym__documentation_block_comment] = ACTIONS(11),
  },
  [44] = {
    [sym__literal] = STATE(967),
    [sym_symbol_literal] = STATE(912),
    [sym_true] = STATE(912),
    [sym_false] = STATE(912),
    [sym_string_literal] = STATE(912),
    [sym__string_literal_double_quotes] = STATE(617),
    [sym__string_literal_single_quotes] = STATE(617),
    [sym__string_literal_double_quotes_multiple] = STATE(617),
    [sym__string_literal_single_quotes_multiple] = STATE(617),
    [sym__raw_string_literal_double_quotes] = STATE(617),
    [sym__raw_string_literal_single_quotes] = STATE(617),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(617),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(617),
    [sym_list_literal] = STATE(912),
    [sym_set_or_map_literal] = STATE(912),
    [sym_null_literal] = STATE(912),
    [sym__expression] = STATE(2450),
    [sym__real_expression] = STATE(670),
    [sym_throw_expression] = STATE(976),
    [sym_assignment_expression] = STATE(976),
    [sym_assignable_expression] = STATE(1582),
    [sym_lambda_expression] = STATE(494),
    [sym_function_expression] = STATE(967),
    [sym_if_null_expression] = STATE(1377),
    [sym_conditional_expression] = STATE(1377),
    [sym_logical_or_expression] = STATE(1377),
    [sym_logical_and_expression] = STATE(1377),
    [sym_equality_expression] = STATE(1377),
    [sym_type_cast_expression] = STATE(1377),
    [sym_type_test_expression] = STATE(1377),
    [sym_relational_expression] = STATE(1377),
    [sym_bitwise_or_expression] = STATE(1377),
    [sym_bitwise_xor_expression] = STATE(1377),
    [sym_bitwise_and_expression] = STATE(1377),
    [sym_shift_expression] = STATE(1377),
    [sym_additive_expression] = STATE(1377),
    [sym_multiplicative_expression] = STATE(1377),
    [sym__unary_expression] = STATE(1118),
    [sym_unary_expression] = STATE(1169),
    [sym__postfix_expression] = STATE(1169),
    [sym_postfix_expression] = STATE(1170),
    [sym_prefix_operator] = STATE(360),
    [sym_negation_operator] = STATE(1206),
    [sym_tilde_operator] = STATE(1188),
    [sym_await_expression] = STATE(1171),
    [sym_new_expression] = STATE(967),
    [sym_const_object_expression] = STATE(967),
    [sym__primary] = STATE(641),
    [sym_constructor_invocation] = STATE(638),
    [sym_type_arguments] = STATE(2454),
    [sym__statement] = STATE(532),
    [sym_local_function_declaration] = STATE(491),
    [sym_block] = STATE(488),
    [sym_expression_statement] = STATE(488),
    [sym_assert_statement] = STATE(488),
    [sym_assertion] = STATE(2726),
    [sym_switch_statement] = STATE(488),
    [sym_do_statement] = STATE(488),
    [sym_break_statement] = STATE(488),
    [sym_continue_statement] = STATE(488),
    [sym_yield_statement] = STATE(488),
    [sym_yield_each_statement] = STATE(488),
    [sym_return_statement] = STATE(488),
    [sym_try_statement] = STATE(488),
    [sym__try_head] = STATE(1927),
    [sym_if_statement] = STATE(488),
    [sym_while_statement] = STATE(488),
    [sym_for_statement] = STATE(488),
    [sym__annotation] = STATE(1287),
    [sym_marker_annotation] = STATE(1289),
    [sym_annotation] = STATE(1289),
    [sym__metadata] = STATE(1359),
    [sym_type_parameters] = STATE(2299),
    [sym_initialized_variable_definition] = STATE(2472),
    [sym__declared_identifier] = STATE(2151),
    [sym__final_const_var_or_type] = STATE(2686),
    [sym__type] = STATE(2047),
    [sym__type_not_function] = STATE(1616),
    [sym__type_not_void_not_function] = STATE(1668),
    [sym_function_type] = STATE(1655),
    [aux_sym__function_type_tails] = STATE(1482),
    [sym__function_type_tail] = STATE(1568),
    [sym__type_name] = STATE(1722),
    [sym__var_or_type] = STATE(2325),
    [sym_inferred_type] = STATE(1653),
    [sym_function_signature] = STATE(1879),
    [sym__formal_parameter_part] = STATE(1915),
    [sym_formal_parameter_list] = STATE(1636),
    [sym__strict_formal_parameter_list] = STATE(1626),
    [sym_local_variable_declaration] = STATE(509),
    [sym__covariant] = STATE(1552),
    [sym__function_builtin_identifier] = STATE(1424),
    [sym__get] = STATE(1992),
    [sym__set] = STATE(1992),
    [sym__new_builtin] = STATE(1701),
    [sym__late_builtin] = STATE(1618),
    [sym_this] = STATE(967),
    [sym_super] = STATE(1128),
    [sym_comment] = STATE(44),
    [sym_documentation_comment] = STATE(44),
    [aux_sym_program_repeat5] = STATE(44),
    [aux_sym_string_literal_repeat1] = STATE(473),
    [aux_sym__metadata_repeat1] = STATE(1143),
    [ts_builtin_sym_end] = ACTIONS(366),
    [sym_identifier] = ACTIONS(368),
    [anon_sym_POUND] = ACTIONS(371),
    [sym_decimal_integer_literal] = ACTIONS(374),
    [sym_hex_integer_literal] = ACTIONS(377),
    [sym_decimal_floating_point_literal] = ACTIONS(374),
    [anon_sym_true] = ACTIONS(380),
    [anon_sym_false] = ACTIONS(383),
    [anon_sym_DQUOTE] = ACTIONS(386),
    [anon_sym_SQUOTE] = ACTIONS(389),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(392),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(395),
    [anon_sym_r_DQUOTE] = ACTIONS(398),
    [anon_sym_r_SQUOTE] = ACTIONS(401),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(404),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(407),
    [anon_sym_LBRACE] = ACTIONS(410),
    [anon_sym_LBRACK] = ACTIONS(413),
    [anon_sym_null] = ACTIONS(416),
    [anon_sym_throw] = ACTIONS(419),
    [anon_sym_LPAREN] = ACTIONS(422),
    [anon_sym_LT] = ACTIONS(425),
    [sym_increment_operator] = ACTIONS(428),
    [sym_minus_operator] = ACTIONS(431),
    [sym__exclamation_operator] = ACTIONS(434),
    [anon_sym_TILDE] = ACTIONS(437),
    [anon_sym_await] = ACTIONS(440),
    [anon_sym_switch] = ACTIONS(443),
    [anon_sym_do] = ACTIONS(446),
    [anon_sym_while] = ACTIONS(449),
    [anon_sym_continue] = ACTIONS(452),
    [anon_sym_yield] = ACTIONS(455),
    [anon_sym_return] = ACTIONS(458),
    [anon_sym_try] = ACTIONS(461),
    [anon_sym_if] = ACTIONS(464),
    [anon_sym_for] = ACTIONS(467),
    [anon_sym_AT] = ACTIONS(470),
    [anon_sym_super] = ACTIONS(473),
    [sym_void_type] = ACTIONS(476),
    [anon_sym_var] = ACTIONS(479),
    [sym__break_builtin] = ACTIONS(482),
    [sym__assert_builtin] = ACTIONS(485),
    [anon_sym_covariant] = ACTIONS(488),
    [anon_sym_Function] = ACTIONS(491),
    [anon_sym_get] = ACTIONS(494),
    [anon_sym_set] = ACTIONS(497),
    [anon_sym_new] = ACTIONS(500),
    [sym_const_builtin] = ACTIONS(503),
    [sym_final_builtin] = ACTIONS(506),
    [anon_sym_late] = ACTIONS(509),
    [anon_sym_this] = ACTIONS(512),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_SLASH_SLASH_SLASH] = ACTIONS(7),
    [sym__block_comment] = ACTIONS(9),
    [sym__documentation_block_comment] = ACTIONS(11),
  },
  [45] = {
    [sym__literal] = STATE(967),
    [sym_symbol_literal] = STATE(912),
    [sym_true] = STATE(912),
    [sym_false] = STATE(912),
    [sym_string_literal] = STATE(912),
    [sym__string_literal_double_quotes] = STATE(617),
    [sym__string_literal_single_quotes] = STATE(617),
    [sym__string_literal_double_quotes_multiple] = STATE(617),
    [sym__string_literal_single_quotes_multiple] = STATE(617),
    [sym__raw_string_literal_double_quotes] = STATE(617),
    [sym__raw_string_literal_single_quotes] = STATE(617),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(617),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(617),
    [sym_list_literal] = STATE(912),
    [sym_set_or_map_literal] = STATE(912),
    [sym_null_literal] = STATE(912),
    [sym__expression] = STATE(2450),
    [sym__real_expression] = STATE(670),
    [sym_throw_expression] = STATE(976),
    [sym_assignment_expression] = STATE(976),
    [sym_assignable_expression] = STATE(1582),
    [sym_lambda_expression] = STATE(494),
    [sym_function_expression] = STATE(967),
    [sym_if_null_expression] = STATE(1377),
    [sym_conditional_expression] = STATE(1377),
    [sym_logical_or_expression] = STATE(1377),
    [sym_logical_and_expression] = STATE(1377),
    [sym_equality_expression] = STATE(1377),
    [sym_type_cast_expression] = STATE(1377),
    [sym_type_test_expression] = STATE(1377),
    [sym_relational_expression] = STATE(1377),
    [sym_bitwise_or_expression] = STATE(1377),
    [sym_bitwise_xor_expression] = STATE(1377),
    [sym_bitwise_and_expression] = STATE(1377),
    [sym_shift_expression] = STATE(1377),
    [sym_additive_expression] = STATE(1377),
    [sym_multiplicative_expression] = STATE(1377),
    [sym__unary_expression] = STATE(1118),
    [sym_unary_expression] = STATE(1169),
    [sym__postfix_expression] = STATE(1169),
    [sym_postfix_expression] = STATE(1170),
    [sym_prefix_operator] = STATE(360),
    [sym_negation_operator] = STATE(1206),
    [sym_tilde_operator] = STATE(1188),
    [sym_await_expression] = STATE(1171),
    [sym_new_expression] = STATE(967),
    [sym_const_object_expression] = STATE(967),
    [sym__primary] = STATE(641),
    [sym_constructor_invocation] = STATE(638),
    [sym_type_arguments] = STATE(2454),
    [sym__statement] = STATE(532),
    [sym_local_function_declaration] = STATE(491),
    [sym_block] = STATE(488),
    [sym_expression_statement] = STATE(488),
    [sym_assert_statement] = STATE(488),
    [sym_assertion] = STATE(2726),
    [sym_switch_statement] = STATE(488),
    [sym_do_statement] = STATE(488),
    [sym_break_statement] = STATE(488),
    [sym_continue_statement] = STATE(488),
    [sym_yield_statement] = STATE(488),
    [sym_yield_each_statement] = STATE(488),
    [sym_return_statement] = STATE(488),
    [sym_try_statement] = STATE(488),
    [sym__try_head] = STATE(1927),
    [sym_if_statement] = STATE(488),
    [sym_while_statement] = STATE(488),
    [sym_for_statement] = STATE(488),
    [sym__annotation] = STATE(1287),
    [sym_marker_annotation] = STATE(1289),
    [sym_annotation] = STATE(1289),
    [sym__metadata] = STATE(1359),
    [sym_type_parameters] = STATE(2299),
    [sym_initialized_variable_definition] = STATE(2472),
    [sym__declared_identifier] = STATE(2151),
    [sym__final_const_var_or_type] = STATE(2686),
    [sym__type] = STATE(2047),
    [sym__type_not_function] = STATE(1616),
    [sym__type_not_void_not_function] = STATE(1668),
    [sym_function_type] = STATE(1655),
    [aux_sym__function_type_tails] = STATE(1482),
    [sym__function_type_tail] = STATE(1568),
    [sym__type_name] = STATE(1722),
    [sym__var_or_type] = STATE(2325),
    [sym_inferred_type] = STATE(1653),
    [sym_function_signature] = STATE(1879),
    [sym__formal_parameter_part] = STATE(1915),
    [sym_formal_parameter_list] = STATE(1636),
    [sym__strict_formal_parameter_list] = STATE(1626),
    [sym_local_variable_declaration] = STATE(509),
    [sym__covariant] = STATE(1552),
    [sym__function_builtin_identifier] = STATE(1424),
    [sym__get] = STATE(1992),
    [sym__set] = STATE(1992),
    [sym__new_builtin] = STATE(1701),
    [sym__late_builtin] = STATE(1618),
    [sym_this] = STATE(967),
    [sym_super] = STATE(1128),
    [sym_comment] = STATE(45),
    [sym_documentation_comment] = STATE(45),
    [aux_sym_program_repeat5] = STATE(44),
    [aux_sym_string_literal_repeat1] = STATE(473),
    [aux_sym__metadata_repeat1] = STATE(1143),
    [ts_builtin_sym_end] = ACTIONS(151),
    [sym_identifier] = ACTIONS(15),
    [anon_sym_POUND] = ACTIONS(139),
    [sym_decimal_integer_literal] = ACTIONS(19),
    [sym_hex_integer_literal] = ACTIONS(21),
    [sym_decimal_floating_point_literal] = ACTIONS(19),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(25),
    [anon_sym_DQUOTE] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_r_DQUOTE] = ACTIONS(35),
    [anon_sym_r_SQUOTE] = ACTIONS(37),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(39),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(43),
    [anon_sym_LBRACK] = ACTIONS(45),
    [anon_sym_null] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_LT] = ACTIONS(53),
    [sym_increment_operator] = ACTIONS(55),
    [sym_minus_operator] = ACTIONS(57),
    [sym__exclamation_operator] = ACTIONS(59),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_await] = ACTIONS(63),
    [anon_sym_switch] = ACTIONS(65),
    [anon_sym_do] = ACTIONS(67),
    [anon_sym_while] = ACTIONS(69),
    [anon_sym_continue] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [anon_sym_return] = ACTIONS(75),
    [anon_sym_try] = ACTIONS(77),
    [anon_sym_if] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_AT] = ACTIONS(83),
    [anon_sym_super] = ACTIONS(95),
    [sym_void_type] = ACTIONS(97),
    [anon_sym_var] = ACTIONS(99),
    [sym__break_builtin] = ACTIONS(105),
    [sym__assert_builtin] = ACTIONS(107),
    [anon_sym_covariant] = ACTIONS(109),
    [anon_sym_Function] = ACTIONS(113),
    [anon_sym_get] = ACTIONS(115),
    [anon_sym_set] = ACTIONS(121),
    [anon_sym_new] = ACTIONS(125),
    [sym_const_builtin] = ACTIONS(165),
    [sym_final_builtin] = ACTIONS(167),
    [anon_sym_late] = ACTIONS(131),
    [anon_sym_this] = ACTIONS(135),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_SLASH_SLASH_SLASH] = ACTIONS(7),
    [sym__block_comment] = ACTIONS(9),
    [sym__documentation_block_comment] = ACTIONS(11),
  },
  [46] = {
    [sym__literal] = STATE(967),
    [sym_symbol_literal] = STATE(912),
    [sym_true] = STATE(912),
    [sym_false] = STATE(912),
    [sym_string_literal] = STATE(912),
    [sym__string_literal_double_quotes] = STATE(617),
    [sym__string_literal_single_quotes] = STATE(617),
    [sym__string_literal_double_quotes_multiple] = STATE(617),
    [sym__string_literal_single_quotes_multiple] = STATE(617),
    [sym__raw_string_literal_double_quotes] = STATE(617),
    [sym__raw_string_literal_single_quotes] = STATE(617),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(617),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(617),
    [sym_list_literal] = STATE(912),
    [sym_set_or_map_literal] = STATE(912),
    [sym_null_literal] = STATE(912),
    [sym__expression] = STATE(2450),
    [sym__real_expression] = STATE(670),
    [sym_throw_expression] = STATE(976),
    [sym_assignment_expression] = STATE(976),
    [sym_assignable_expression] = STATE(1582),
    [sym_lambda_expression] = STATE(494),
    [sym_function_expression] = STATE(967),
    [sym_if_null_expression] = STATE(1377),
    [sym_conditional_expression] = STATE(1377),
    [sym_logical_or_expression] = STATE(1377),
    [sym_logical_and_expression] = STATE(1377),
    [sym_equality_expression] = STATE(1377),
    [sym_type_cast_expression] = STATE(1377),
    [sym_type_test_expression] = STATE(1377),
    [sym_relational_expression] = STATE(1377),
    [sym_bitwise_or_expression] = STATE(1377),
    [sym_bitwise_xor_expression] = STATE(1377),
    [sym_bitwise_and_expression] = STATE(1377),
    [sym_shift_expression] = STATE(1377),
    [sym_additive_expression] = STATE(1377),
    [sym_multiplicative_expression] = STATE(1377),
    [sym__unary_expression] = STATE(1118),
    [sym_unary_expression] = STATE(1169),
    [sym__postfix_expression] = STATE(1169),
    [sym_postfix_expression] = STATE(1170),
    [sym_prefix_operator] = STATE(360),
    [sym_negation_operator] = STATE(1206),
    [sym_tilde_operator] = STATE(1188),
    [sym_await_expression] = STATE(1171),
    [sym_new_expression] = STATE(967),
    [sym_const_object_expression] = STATE(967),
    [sym__primary] = STATE(641),
    [sym_constructor_invocation] = STATE(638),
    [sym_type_arguments] = STATE(2454),
    [sym__statement] = STATE(532),
    [sym_local_function_declaration] = STATE(491),
    [sym_block] = STATE(488),
    [sym_expression_statement] = STATE(488),
    [sym_assert_statement] = STATE(488),
    [sym_assertion] = STATE(2726),
    [sym_switch_statement] = STATE(488),
    [sym_do_statement] = STATE(488),
    [sym_break_statement] = STATE(488),
    [sym_continue_statement] = STATE(488),
    [sym_yield_statement] = STATE(488),
    [sym_yield_each_statement] = STATE(488),
    [sym_return_statement] = STATE(488),
    [sym_try_statement] = STATE(488),
    [sym__try_head] = STATE(1927),
    [sym_if_statement] = STATE(488),
    [sym_while_statement] = STATE(488),
    [sym_for_statement] = STATE(488),
    [sym__annotation] = STATE(1287),
    [sym_marker_annotation] = STATE(1289),
    [sym_annotation] = STATE(1289),
    [sym__metadata] = STATE(1359),
    [sym_type_parameters] = STATE(2299),
    [sym_initialized_variable_definition] = STATE(2472),
    [sym__declared_identifier] = STATE(2151),
    [sym__final_const_var_or_type] = STATE(2686),
    [sym__type] = STATE(2047),
    [sym__type_not_function] = STATE(1616),
    [sym__type_not_void_not_function] = STATE(1668),
    [sym_function_type] = STATE(1655),
    [aux_sym__function_type_tails] = STATE(1482),
    [sym__function_type_tail] = STATE(1568),
    [sym__type_name] = STATE(1722),
    [sym__var_or_type] = STATE(2325),
    [sym_inferred_type] = STATE(1653),
    [sym_function_signature] = STATE(1879),
    [sym__formal_parameter_part] = STATE(1915),
    [sym_formal_parameter_list] = STATE(1636),
    [sym__strict_formal_parameter_list] = STATE(1626),
    [sym_local_variable_declaration] = STATE(509),
    [sym__covariant] = STATE(1552),
    [sym__function_builtin_identifier] = STATE(1424),
    [sym__get] = STATE(1992),
    [sym__set] = STATE(1992),
    [sym__new_builtin] = STATE(1701),
    [sym__late_builtin] = STATE(1618),
    [sym_this] = STATE(967),
    [sym_super] = STATE(1128),
    [sym_comment] = STATE(46),
    [sym_documentation_comment] = STATE(46),
    [aux_sym_program_repeat5] = STATE(52),
    [aux_sym_string_literal_repeat1] = STATE(473),
    [aux_sym__metadata_repeat1] = STATE(1143),
    [sym_identifier] = ACTIONS(15),
    [anon_sym_POUND] = ACTIONS(139),
    [sym_decimal_integer_literal] = ACTIONS(19),
    [sym_hex_integer_literal] = ACTIONS(21),
    [sym_decimal_floating_point_literal] = ACTIONS(19),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(25),
    [anon_sym_DQUOTE] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_r_DQUOTE] = ACTIONS(35),
    [anon_sym_r_SQUOTE] = ACTIONS(37),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(39),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(177),
    [anon_sym_RBRACE] = ACTIONS(515),
    [anon_sym_LBRACK] = ACTIONS(45),
    [anon_sym_null] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_LT] = ACTIONS(53),
    [sym_increment_operator] = ACTIONS(55),
    [sym_minus_operator] = ACTIONS(57),
    [sym__exclamation_operator] = ACTIONS(59),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_await] = ACTIONS(181),
    [anon_sym_switch] = ACTIONS(65),
    [anon_sym_do] = ACTIONS(67),
    [anon_sym_while] = ACTIONS(159),
    [anon_sym_continue] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [anon_sym_return] = ACTIONS(75),
    [anon_sym_try] = ACTIONS(77),
    [anon_sym_if] = ACTIONS(185),
    [anon_sym_for] = ACTIONS(187),
    [anon_sym_AT] = ACTIONS(83),
    [anon_sym_super] = ACTIONS(95),
    [sym_void_type] = ACTIONS(97),
    [anon_sym_var] = ACTIONS(99),
    [sym__break_builtin] = ACTIONS(105),
    [sym__assert_builtin] = ACTIONS(107),
    [anon_sym_covariant] = ACTIONS(109),
    [anon_sym_Function] = ACTIONS(113),
    [anon_sym_get] = ACTIONS(115),
    [anon_sym_set] = ACTIONS(121),
    [anon_sym_new] = ACTIONS(125),
    [sym_const_builtin] = ACTIONS(165),
    [sym_final_builtin] = ACTIONS(167),
    [anon_sym_late] = ACTIONS(131),
    [anon_sym_this] = ACTIONS(135),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_SLASH_SLASH_SLASH] = ACTIONS(7),
    [sym__block_comment] = ACTIONS(9),
    [sym__documentation_block_comment] = ACTIONS(11),
  },
  [47] = {
    [sym__literal] = STATE(967),
    [sym_symbol_literal] = STATE(912),
    [sym_true] = STATE(912),
    [sym_false] = STATE(912),
    [sym_string_literal] = STATE(912),
    [sym__string_literal_double_quotes] = STATE(617),
    [sym__string_literal_single_quotes] = STATE(617),
    [sym__string_literal_double_quotes_multiple] = STATE(617),
    [sym__string_literal_single_quotes_multiple] = STATE(617),
    [sym__raw_string_literal_double_quotes] = STATE(617),
    [sym__raw_string_literal_single_quotes] = STATE(617),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(617),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(617),
    [sym_list_literal] = STATE(912),
    [sym_set_or_map_literal] = STATE(912),
    [sym_null_literal] = STATE(912),
    [sym__expression] = STATE(2450),
    [sym__real_expression] = STATE(670),
    [sym_throw_expression] = STATE(976),
    [sym_assignment_expression] = STATE(976),
    [sym_assignable_expression] = STATE(1582),
    [sym_lambda_expression] = STATE(494),
    [sym_function_expression] = STATE(967),
    [sym_if_null_expression] = STATE(1377),
    [sym_conditional_expression] = STATE(1377),
    [sym_logical_or_expression] = STATE(1377),
    [sym_logical_and_expression] = STATE(1377),
    [sym_equality_expression] = STATE(1377),
    [sym_type_cast_expression] = STATE(1377),
    [sym_type_test_expression] = STATE(1377),
    [sym_relational_expression] = STATE(1377),
    [sym_bitwise_or_expression] = STATE(1377),
    [sym_bitwise_xor_expression] = STATE(1377),
    [sym_bitwise_and_expression] = STATE(1377),
    [sym_shift_expression] = STATE(1377),
    [sym_additive_expression] = STATE(1377),
    [sym_multiplicative_expression] = STATE(1377),
    [sym__unary_expression] = STATE(1118),
    [sym_unary_expression] = STATE(1169),
    [sym__postfix_expression] = STATE(1169),
    [sym_postfix_expression] = STATE(1170),
    [sym_prefix_operator] = STATE(360),
    [sym_negation_operator] = STATE(1206),
    [sym_tilde_operator] = STATE(1188),
    [sym_await_expression] = STATE(1171),
    [sym_new_expression] = STATE(967),
    [sym_const_object_expression] = STATE(967),
    [sym__primary] = STATE(641),
    [sym_constructor_invocation] = STATE(638),
    [sym_type_arguments] = STATE(2454),
    [sym__statement] = STATE(532),
    [sym_local_function_declaration] = STATE(491),
    [sym_block] = STATE(488),
    [sym_expression_statement] = STATE(488),
    [sym_assert_statement] = STATE(488),
    [sym_assertion] = STATE(2726),
    [sym_switch_statement] = STATE(488),
    [sym_do_statement] = STATE(488),
    [sym_break_statement] = STATE(488),
    [sym_continue_statement] = STATE(488),
    [sym_yield_statement] = STATE(488),
    [sym_yield_each_statement] = STATE(488),
    [sym_return_statement] = STATE(488),
    [sym_try_statement] = STATE(488),
    [sym__try_head] = STATE(1927),
    [sym_if_statement] = STATE(488),
    [sym_while_statement] = STATE(488),
    [sym_for_statement] = STATE(488),
    [sym__annotation] = STATE(1287),
    [sym_marker_annotation] = STATE(1289),
    [sym_annotation] = STATE(1289),
    [sym__metadata] = STATE(1359),
    [sym_type_parameters] = STATE(2299),
    [sym_initialized_variable_definition] = STATE(2472),
    [sym__declared_identifier] = STATE(2151),
    [sym__final_const_var_or_type] = STATE(2686),
    [sym__type] = STATE(2047),
    [sym__type_not_function] = STATE(1616),
    [sym__type_not_void_not_function] = STATE(1668),
    [sym_function_type] = STATE(1655),
    [aux_sym__function_type_tails] = STATE(1482),
    [sym__function_type_tail] = STATE(1568),
    [sym__type_name] = STATE(1722),
    [sym__var_or_type] = STATE(2325),
    [sym_inferred_type] = STATE(1653),
    [sym_function_signature] = STATE(1879),
    [sym__formal_parameter_part] = STATE(1915),
    [sym_formal_parameter_list] = STATE(1636),
    [sym__strict_formal_parameter_list] = STATE(1626),
    [sym_local_variable_declaration] = STATE(509),
    [sym__covariant] = STATE(1552),
    [sym__function_builtin_identifier] = STATE(1424),
    [sym__get] = STATE(1992),
    [sym__set] = STATE(1992),
    [sym__new_builtin] = STATE(1701),
    [sym__late_builtin] = STATE(1618),
    [sym_this] = STATE(967),
    [sym_super] = STATE(1128),
    [sym_comment] = STATE(47),
    [sym_documentation_comment] = STATE(47),
    [aux_sym_program_repeat5] = STATE(44),
    [aux_sym_string_literal_repeat1] = STATE(473),
    [aux_sym__metadata_repeat1] = STATE(1143),
    [ts_builtin_sym_end] = ACTIONS(149),
    [sym_identifier] = ACTIONS(15),
    [anon_sym_POUND] = ACTIONS(139),
    [sym_decimal_integer_literal] = ACTIONS(19),
    [sym_hex_integer_literal] = ACTIONS(21),
    [sym_decimal_floating_point_literal] = ACTIONS(19),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(25),
    [anon_sym_DQUOTE] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_r_DQUOTE] = ACTIONS(35),
    [anon_sym_r_SQUOTE] = ACTIONS(37),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(39),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(43),
    [anon_sym_LBRACK] = ACTIONS(45),
    [anon_sym_null] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_LT] = ACTIONS(53),
    [sym_increment_operator] = ACTIONS(55),
    [sym_minus_operator] = ACTIONS(57),
    [sym__exclamation_operator] = ACTIONS(59),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_await] = ACTIONS(63),
    [anon_sym_switch] = ACTIONS(65),
    [anon_sym_do] = ACTIONS(67),
    [anon_sym_while] = ACTIONS(69),
    [anon_sym_continue] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [anon_sym_return] = ACTIONS(75),
    [anon_sym_try] = ACTIONS(77),
    [anon_sym_if] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_AT] = ACTIONS(83),
    [anon_sym_super] = ACTIONS(95),
    [sym_void_type] = ACTIONS(97),
    [anon_sym_var] = ACTIONS(99),
    [sym__break_builtin] = ACTIONS(105),
    [sym__assert_builtin] = ACTIONS(107),
    [anon_sym_covariant] = ACTIONS(109),
    [anon_sym_Function] = ACTIONS(113),
    [anon_sym_get] = ACTIONS(115),
    [anon_sym_set] = ACTIONS(121),
    [anon_sym_new] = ACTIONS(125),
    [sym_const_builtin] = ACTIONS(165),
    [sym_final_builtin] = ACTIONS(167),
    [anon_sym_late] = ACTIONS(131),
    [anon_sym_this] = ACTIONS(135),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_SLASH_SLASH_SLASH] = ACTIONS(7),
    [sym__block_comment] = ACTIONS(9),
    [sym__documentation_block_comment] = ACTIONS(11),
  },
  [48] = {
    [sym__literal] = STATE(967),
    [sym_symbol_literal] = STATE(912),
    [sym_true] = STATE(912),
    [sym_false] = STATE(912),
    [sym_string_literal] = STATE(912),
    [sym__string_literal_double_quotes] = STATE(617),
    [sym__string_literal_single_quotes] = STATE(617),
    [sym__string_literal_double_quotes_multiple] = STATE(617),
    [sym__string_literal_single_quotes_multiple] = STATE(617),
    [sym__raw_string_literal_double_quotes] = STATE(617),
    [sym__raw_string_literal_single_quotes] = STATE(617),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(617),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(617),
    [sym_list_literal] = STATE(912),
    [sym_set_or_map_literal] = STATE(912),
    [sym_null_literal] = STATE(912),
    [sym__expression] = STATE(2450),
    [sym__real_expression] = STATE(670),
    [sym_throw_expression] = STATE(976),
    [sym_assignment_expression] = STATE(976),
    [sym_assignable_expression] = STATE(1582),
    [sym_lambda_expression] = STATE(494),
    [sym_function_expression] = STATE(967),
    [sym_if_null_expression] = STATE(1377),
    [sym_conditional_expression] = STATE(1377),
    [sym_logical_or_expression] = STATE(1377),
    [sym_logical_and_expression] = STATE(1377),
    [sym_equality_expression] = STATE(1377),
    [sym_type_cast_expression] = STATE(1377),
    [sym_type_test_expression] = STATE(1377),
    [sym_relational_expression] = STATE(1377),
    [sym_bitwise_or_expression] = STATE(1377),
    [sym_bitwise_xor_expression] = STATE(1377),
    [sym_bitwise_and_expression] = STATE(1377),
    [sym_shift_expression] = STATE(1377),
    [sym_additive_expression] = STATE(1377),
    [sym_multiplicative_expression] = STATE(1377),
    [sym__unary_expression] = STATE(1118),
    [sym_unary_expression] = STATE(1169),
    [sym__postfix_expression] = STATE(1169),
    [sym_postfix_expression] = STATE(1170),
    [sym_prefix_operator] = STATE(360),
    [sym_negation_operator] = STATE(1206),
    [sym_tilde_operator] = STATE(1188),
    [sym_await_expression] = STATE(1171),
    [sym_new_expression] = STATE(967),
    [sym_const_object_expression] = STATE(967),
    [sym__primary] = STATE(641),
    [sym_constructor_invocation] = STATE(638),
    [sym_type_arguments] = STATE(2454),
    [sym__statement] = STATE(532),
    [sym_local_function_declaration] = STATE(491),
    [sym_block] = STATE(488),
    [sym_expression_statement] = STATE(488),
    [sym_assert_statement] = STATE(488),
    [sym_assertion] = STATE(2726),
    [sym_switch_statement] = STATE(488),
    [sym_do_statement] = STATE(488),
    [sym_break_statement] = STATE(488),
    [sym_continue_statement] = STATE(488),
    [sym_yield_statement] = STATE(488),
    [sym_yield_each_statement] = STATE(488),
    [sym_return_statement] = STATE(488),
    [sym_try_statement] = STATE(488),
    [sym__try_head] = STATE(1927),
    [sym_if_statement] = STATE(488),
    [sym_while_statement] = STATE(488),
    [sym_for_statement] = STATE(488),
    [sym__annotation] = STATE(1287),
    [sym_marker_annotation] = STATE(1289),
    [sym_annotation] = STATE(1289),
    [sym__metadata] = STATE(1359),
    [sym_type_parameters] = STATE(2299),
    [sym_initialized_variable_definition] = STATE(2472),
    [sym__declared_identifier] = STATE(2151),
    [sym__final_const_var_or_type] = STATE(2686),
    [sym__type] = STATE(2047),
    [sym__type_not_function] = STATE(1616),
    [sym__type_not_void_not_function] = STATE(1668),
    [sym_function_type] = STATE(1655),
    [aux_sym__function_type_tails] = STATE(1482),
    [sym__function_type_tail] = STATE(1568),
    [sym__type_name] = STATE(1722),
    [sym__var_or_type] = STATE(2325),
    [sym_inferred_type] = STATE(1653),
    [sym_function_signature] = STATE(1879),
    [sym__formal_parameter_part] = STATE(1915),
    [sym_formal_parameter_list] = STATE(1636),
    [sym__strict_formal_parameter_list] = STATE(1626),
    [sym_local_variable_declaration] = STATE(509),
    [sym__covariant] = STATE(1552),
    [sym__function_builtin_identifier] = STATE(1424),
    [sym__get] = STATE(1992),
    [sym__set] = STATE(1992),
    [sym__new_builtin] = STATE(1701),
    [sym__late_builtin] = STATE(1618),
    [sym_this] = STATE(967),
    [sym_super] = STATE(1128),
    [sym_comment] = STATE(48),
    [sym_documentation_comment] = STATE(48),
    [aux_sym_program_repeat5] = STATE(40),
    [aux_sym_string_literal_repeat1] = STATE(473),
    [aux_sym__metadata_repeat1] = STATE(1143),
    [sym_identifier] = ACTIONS(15),
    [anon_sym_POUND] = ACTIONS(139),
    [sym_decimal_integer_literal] = ACTIONS(19),
    [sym_hex_integer_literal] = ACTIONS(21),
    [sym_decimal_floating_point_literal] = ACTIONS(19),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(25),
    [anon_sym_DQUOTE] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_r_DQUOTE] = ACTIONS(35),
    [anon_sym_r_SQUOTE] = ACTIONS(37),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(39),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(177),
    [anon_sym_RBRACE] = ACTIONS(517),
    [anon_sym_LBRACK] = ACTIONS(45),
    [anon_sym_null] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_LT] = ACTIONS(53),
    [sym_increment_operator] = ACTIONS(55),
    [sym_minus_operator] = ACTIONS(57),
    [sym__exclamation_operator] = ACTIONS(59),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_await] = ACTIONS(181),
    [anon_sym_switch] = ACTIONS(65),
    [anon_sym_do] = ACTIONS(67),
    [anon_sym_while] = ACTIONS(159),
    [anon_sym_continue] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [anon_sym_return] = ACTIONS(75),
    [anon_sym_try] = ACTIONS(77),
    [anon_sym_if] = ACTIONS(185),
    [anon_sym_for] = ACTIONS(187),
    [anon_sym_AT] = ACTIONS(83),
    [anon_sym_super] = ACTIONS(95),
    [sym_void_type] = ACTIONS(97),
    [anon_sym_var] = ACTIONS(99),
    [sym__break_builtin] = ACTIONS(105),
    [sym__assert_builtin] = ACTIONS(107),
    [anon_sym_covariant] = ACTIONS(109),
    [anon_sym_Function] = ACTIONS(113),
    [anon_sym_get] = ACTIONS(115),
    [anon_sym_set] = ACTIONS(121),
    [anon_sym_new] = ACTIONS(125),
    [sym_const_builtin] = ACTIONS(165),
    [sym_final_builtin] = ACTIONS(167),
    [anon_sym_late] = ACTIONS(131),
    [anon_sym_this] = ACTIONS(135),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_SLASH_SLASH_SLASH] = ACTIONS(7),
    [sym__block_comment] = ACTIONS(9),
    [sym__documentation_block_comment] = ACTIONS(11),
  },
  [49] = {
    [sym__literal] = STATE(967),
    [sym_symbol_literal] = STATE(912),
    [sym_true] = STATE(912),
    [sym_false] = STATE(912),
    [sym_string_literal] = STATE(912),
    [sym__string_literal_double_quotes] = STATE(617),
    [sym__string_literal_single_quotes] = STATE(617),
    [sym__string_literal_double_quotes_multiple] = STATE(617),
    [sym__string_literal_single_quotes_multiple] = STATE(617),
    [sym__raw_string_literal_double_quotes] = STATE(617),
    [sym__raw_string_literal_single_quotes] = STATE(617),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(617),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(617),
    [sym_list_literal] = STATE(912),
    [sym_set_or_map_literal] = STATE(912),
    [sym_null_literal] = STATE(912),
    [sym__expression] = STATE(2450),
    [sym__real_expression] = STATE(670),
    [sym_throw_expression] = STATE(976),
    [sym_assignment_expression] = STATE(976),
    [sym_assignable_expression] = STATE(1582),
    [sym_lambda_expression] = STATE(494),
    [sym_function_expression] = STATE(967),
    [sym_if_null_expression] = STATE(1377),
    [sym_conditional_expression] = STATE(1377),
    [sym_logical_or_expression] = STATE(1377),
    [sym_logical_and_expression] = STATE(1377),
    [sym_equality_expression] = STATE(1377),
    [sym_type_cast_expression] = STATE(1377),
    [sym_type_test_expression] = STATE(1377),
    [sym_relational_expression] = STATE(1377),
    [sym_bitwise_or_expression] = STATE(1377),
    [sym_bitwise_xor_expression] = STATE(1377),
    [sym_bitwise_and_expression] = STATE(1377),
    [sym_shift_expression] = STATE(1377),
    [sym_additive_expression] = STATE(1377),
    [sym_multiplicative_expression] = STATE(1377),
    [sym__unary_expression] = STATE(1118),
    [sym_unary_expression] = STATE(1169),
    [sym__postfix_expression] = STATE(1169),
    [sym_postfix_expression] = STATE(1170),
    [sym_prefix_operator] = STATE(360),
    [sym_negation_operator] = STATE(1206),
    [sym_tilde_operator] = STATE(1188),
    [sym_await_expression] = STATE(1171),
    [sym_new_expression] = STATE(967),
    [sym_const_object_expression] = STATE(967),
    [sym__primary] = STATE(641),
    [sym_constructor_invocation] = STATE(638),
    [sym_type_arguments] = STATE(2454),
    [sym__statement] = STATE(532),
    [sym_local_function_declaration] = STATE(491),
    [sym_block] = STATE(488),
    [sym_expression_statement] = STATE(488),
    [sym_assert_statement] = STATE(488),
    [sym_assertion] = STATE(2726),
    [sym_switch_statement] = STATE(488),
    [sym_do_statement] = STATE(488),
    [sym_break_statement] = STATE(488),
    [sym_continue_statement] = STATE(488),
    [sym_yield_statement] = STATE(488),
    [sym_yield_each_statement] = STATE(488),
    [sym_return_statement] = STATE(488),
    [sym_try_statement] = STATE(488),
    [sym__try_head] = STATE(1927),
    [sym_if_statement] = STATE(488),
    [sym_while_statement] = STATE(488),
    [sym_for_statement] = STATE(488),
    [sym__annotation] = STATE(1287),
    [sym_marker_annotation] = STATE(1289),
    [sym_annotation] = STATE(1289),
    [sym__metadata] = STATE(1359),
    [sym_type_parameters] = STATE(2299),
    [sym_initialized_variable_definition] = STATE(2472),
    [sym__declared_identifier] = STATE(2151),
    [sym__final_const_var_or_type] = STATE(2686),
    [sym__type] = STATE(2047),
    [sym__type_not_function] = STATE(1616),
    [sym__type_not_void_not_function] = STATE(1668),
    [sym_function_type] = STATE(1655),
    [aux_sym__function_type_tails] = STATE(1482),
    [sym__function_type_tail] = STATE(1568),
    [sym__type_name] = STATE(1722),
    [sym__var_or_type] = STATE(2325),
    [sym_inferred_type] = STATE(1653),
    [sym_function_signature] = STATE(1879),
    [sym__formal_parameter_part] = STATE(1915),
    [sym_formal_parameter_list] = STATE(1636),
    [sym__strict_formal_parameter_list] = STATE(1626),
    [sym_local_variable_declaration] = STATE(509),
    [sym__covariant] = STATE(1552),
    [sym__function_builtin_identifier] = STATE(1424),
    [sym__get] = STATE(1992),
    [sym__set] = STATE(1992),
    [sym__new_builtin] = STATE(1701),
    [sym__late_builtin] = STATE(1618),
    [sym_this] = STATE(967),
    [sym_super] = STATE(1128),
    [sym_comment] = STATE(49),
    [sym_documentation_comment] = STATE(49),
    [aux_sym_program_repeat5] = STATE(46),
    [aux_sym_string_literal_repeat1] = STATE(473),
    [aux_sym__metadata_repeat1] = STATE(1143),
    [sym_identifier] = ACTIONS(15),
    [anon_sym_POUND] = ACTIONS(139),
    [sym_decimal_integer_literal] = ACTIONS(19),
    [sym_hex_integer_literal] = ACTIONS(21),
    [sym_decimal_floating_point_literal] = ACTIONS(19),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(25),
    [anon_sym_DQUOTE] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_r_DQUOTE] = ACTIONS(35),
    [anon_sym_r_SQUOTE] = ACTIONS(37),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(39),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(177),
    [anon_sym_RBRACE] = ACTIONS(519),
    [anon_sym_LBRACK] = ACTIONS(45),
    [anon_sym_null] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_LT] = ACTIONS(53),
    [sym_increment_operator] = ACTIONS(55),
    [sym_minus_operator] = ACTIONS(57),
    [sym__exclamation_operator] = ACTIONS(59),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_await] = ACTIONS(181),
    [anon_sym_switch] = ACTIONS(65),
    [anon_sym_do] = ACTIONS(67),
    [anon_sym_while] = ACTIONS(159),
    [anon_sym_continue] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [anon_sym_return] = ACTIONS(75),
    [anon_sym_try] = ACTIONS(77),
    [anon_sym_if] = ACTIONS(185),
    [anon_sym_for] = ACTIONS(187),
    [anon_sym_AT] = ACTIONS(83),
    [anon_sym_super] = ACTIONS(95),
    [sym_void_type] = ACTIONS(97),
    [anon_sym_var] = ACTIONS(99),
    [sym__break_builtin] = ACTIONS(105),
    [sym__assert_builtin] = ACTIONS(107),
    [anon_sym_covariant] = ACTIONS(109),
    [anon_sym_Function] = ACTIONS(113),
    [anon_sym_get] = ACTIONS(115),
    [anon_sym_set] = ACTIONS(121),
    [anon_sym_new] = ACTIONS(125),
    [sym_const_builtin] = ACTIONS(165),
    [sym_final_builtin] = ACTIONS(167),
    [anon_sym_late] = ACTIONS(131),
    [anon_sym_this] = ACTIONS(135),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_SLASH_SLASH_SLASH] = ACTIONS(7),
    [sym__block_comment] = ACTIONS(9),
    [sym__documentation_block_comment] = ACTIONS(11),
  },
  [50] = {
    [sym__literal] = STATE(967),
    [sym_symbol_literal] = STATE(912),
    [sym_true] = STATE(912),
    [sym_false] = STATE(912),
    [sym_string_literal] = STATE(912),
    [sym__string_literal_double_quotes] = STATE(617),
    [sym__string_literal_single_quotes] = STATE(617),
    [sym__string_literal_double_quotes_multiple] = STATE(617),
    [sym__string_literal_single_quotes_multiple] = STATE(617),
    [sym__raw_string_literal_double_quotes] = STATE(617),
    [sym__raw_string_literal_single_quotes] = STATE(617),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(617),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(617),
    [sym_list_literal] = STATE(912),
    [sym_set_or_map_literal] = STATE(912),
    [sym_null_literal] = STATE(912),
    [sym__expression] = STATE(2450),
    [sym__real_expression] = STATE(670),
    [sym_throw_expression] = STATE(976),
    [sym_assignment_expression] = STATE(976),
    [sym_assignable_expression] = STATE(1582),
    [sym_lambda_expression] = STATE(494),
    [sym_function_expression] = STATE(967),
    [sym_if_null_expression] = STATE(1377),
    [sym_conditional_expression] = STATE(1377),
    [sym_logical_or_expression] = STATE(1377),
    [sym_logical_and_expression] = STATE(1377),
    [sym_equality_expression] = STATE(1377),
    [sym_type_cast_expression] = STATE(1377),
    [sym_type_test_expression] = STATE(1377),
    [sym_relational_expression] = STATE(1377),
    [sym_bitwise_or_expression] = STATE(1377),
    [sym_bitwise_xor_expression] = STATE(1377),
    [sym_bitwise_and_expression] = STATE(1377),
    [sym_shift_expression] = STATE(1377),
    [sym_additive_expression] = STATE(1377),
    [sym_multiplicative_expression] = STATE(1377),
    [sym__unary_expression] = STATE(1118),
    [sym_unary_expression] = STATE(1169),
    [sym__postfix_expression] = STATE(1169),
    [sym_postfix_expression] = STATE(1170),
    [sym_prefix_operator] = STATE(360),
    [sym_negation_operator] = STATE(1206),
    [sym_tilde_operator] = STATE(1188),
    [sym_await_expression] = STATE(1171),
    [sym_new_expression] = STATE(967),
    [sym_const_object_expression] = STATE(967),
    [sym__primary] = STATE(641),
    [sym_constructor_invocation] = STATE(638),
    [sym_type_arguments] = STATE(2454),
    [sym__statement] = STATE(532),
    [sym_local_function_declaration] = STATE(491),
    [sym_block] = STATE(488),
    [sym_expression_statement] = STATE(488),
    [sym_assert_statement] = STATE(488),
    [sym_assertion] = STATE(2726),
    [sym_switch_statement] = STATE(488),
    [sym_do_statement] = STATE(488),
    [sym_break_statement] = STATE(488),
    [sym_continue_statement] = STATE(488),
    [sym_yield_statement] = STATE(488),
    [sym_yield_each_statement] = STATE(488),
    [sym_return_statement] = STATE(488),
    [sym_try_statement] = STATE(488),
    [sym__try_head] = STATE(1927),
    [sym_if_statement] = STATE(488),
    [sym_while_statement] = STATE(488),
    [sym_for_statement] = STATE(488),
    [sym__annotation] = STATE(1287),
    [sym_marker_annotation] = STATE(1289),
    [sym_annotation] = STATE(1289),
    [sym__metadata] = STATE(1359),
    [sym_type_parameters] = STATE(2299),
    [sym_initialized_variable_definition] = STATE(2472),
    [sym__declared_identifier] = STATE(2151),
    [sym__final_const_var_or_type] = STATE(2686),
    [sym__type] = STATE(2047),
    [sym__type_not_function] = STATE(1616),
    [sym__type_not_void_not_function] = STATE(1668),
    [sym_function_type] = STATE(1655),
    [aux_sym__function_type_tails] = STATE(1482),
    [sym__function_type_tail] = STATE(1568),
    [sym__type_name] = STATE(1722),
    [sym__var_or_type] = STATE(2325),
    [sym_inferred_type] = STATE(1653),
    [sym_function_signature] = STATE(1879),
    [sym__formal_parameter_part] = STATE(1915),
    [sym_formal_parameter_list] = STATE(1636),
    [sym__strict_formal_parameter_list] = STATE(1626),
    [sym_local_variable_declaration] = STATE(509),
    [sym__covariant] = STATE(1552),
    [sym__function_builtin_identifier] = STATE(1424),
    [sym__get] = STATE(1992),
    [sym__set] = STATE(1992),
    [sym__new_builtin] = STATE(1701),
    [sym__late_builtin] = STATE(1618),
    [sym_this] = STATE(967),
    [sym_super] = STATE(1128),
    [sym_comment] = STATE(50),
    [sym_documentation_comment] = STATE(50),
    [aux_sym_program_repeat5] = STATE(52),
    [aux_sym_string_literal_repeat1] = STATE(473),
    [aux_sym__metadata_repeat1] = STATE(1143),
    [sym_identifier] = ACTIONS(15),
    [anon_sym_POUND] = ACTIONS(139),
    [sym_decimal_integer_literal] = ACTIONS(19),
    [sym_hex_integer_literal] = ACTIONS(21),
    [sym_decimal_floating_point_literal] = ACTIONS(19),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(25),
    [anon_sym_DQUOTE] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_r_DQUOTE] = ACTIONS(35),
    [anon_sym_r_SQUOTE] = ACTIONS(37),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(39),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(177),
    [anon_sym_RBRACE] = ACTIONS(521),
    [anon_sym_LBRACK] = ACTIONS(45),
    [anon_sym_null] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_LT] = ACTIONS(53),
    [sym_increment_operator] = ACTIONS(55),
    [sym_minus_operator] = ACTIONS(57),
    [sym__exclamation_operator] = ACTIONS(59),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_await] = ACTIONS(181),
    [anon_sym_switch] = ACTIONS(65),
    [anon_sym_do] = ACTIONS(67),
    [anon_sym_while] = ACTIONS(159),
    [anon_sym_continue] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [anon_sym_return] = ACTIONS(75),
    [anon_sym_try] = ACTIONS(77),
    [anon_sym_if] = ACTIONS(185),
    [anon_sym_for] = ACTIONS(187),
    [anon_sym_AT] = ACTIONS(83),
    [anon_sym_super] = ACTIONS(95),
    [sym_void_type] = ACTIONS(97),
    [anon_sym_var] = ACTIONS(99),
    [sym__break_builtin] = ACTIONS(105),
    [sym__assert_builtin] = ACTIONS(107),
    [anon_sym_covariant] = ACTIONS(109),
    [anon_sym_Function] = ACTIONS(113),
    [anon_sym_get] = ACTIONS(115),
    [anon_sym_set] = ACTIONS(121),
    [anon_sym_new] = ACTIONS(125),
    [sym_const_builtin] = ACTIONS(165),
    [sym_final_builtin] = ACTIONS(167),
    [anon_sym_late] = ACTIONS(131),
    [anon_sym_this] = ACTIONS(135),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_SLASH_SLASH_SLASH] = ACTIONS(7),
    [sym__block_comment] = ACTIONS(9),
    [sym__documentation_block_comment] = ACTIONS(11),
  },
  [51] = {
    [sym__literal] = STATE(967),
    [sym_symbol_literal] = STATE(912),
    [sym_true] = STATE(912),
    [sym_false] = STATE(912),
    [sym_string_literal] = STATE(912),
    [sym__string_literal_double_quotes] = STATE(617),
    [sym__string_literal_single_quotes] = STATE(617),
    [sym__string_literal_double_quotes_multiple] = STATE(617),
    [sym__string_literal_single_quotes_multiple] = STATE(617),
    [sym__raw_string_literal_double_quotes] = STATE(617),
    [sym__raw_string_literal_single_quotes] = STATE(617),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(617),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(617),
    [sym_list_literal] = STATE(912),
    [sym_set_or_map_literal] = STATE(912),
    [sym_null_literal] = STATE(912),
    [sym__expression] = STATE(2450),
    [sym__real_expression] = STATE(670),
    [sym_throw_expression] = STATE(976),
    [sym_assignment_expression] = STATE(976),
    [sym_assignable_expression] = STATE(1582),
    [sym_lambda_expression] = STATE(494),
    [sym_function_expression] = STATE(967),
    [sym_if_null_expression] = STATE(1377),
    [sym_conditional_expression] = STATE(1377),
    [sym_logical_or_expression] = STATE(1377),
    [sym_logical_and_expression] = STATE(1377),
    [sym_equality_expression] = STATE(1377),
    [sym_type_cast_expression] = STATE(1377),
    [sym_type_test_expression] = STATE(1377),
    [sym_relational_expression] = STATE(1377),
    [sym_bitwise_or_expression] = STATE(1377),
    [sym_bitwise_xor_expression] = STATE(1377),
    [sym_bitwise_and_expression] = STATE(1377),
    [sym_shift_expression] = STATE(1377),
    [sym_additive_expression] = STATE(1377),
    [sym_multiplicative_expression] = STATE(1377),
    [sym__unary_expression] = STATE(1118),
    [sym_unary_expression] = STATE(1169),
    [sym__postfix_expression] = STATE(1169),
    [sym_postfix_expression] = STATE(1170),
    [sym_prefix_operator] = STATE(360),
    [sym_negation_operator] = STATE(1206),
    [sym_tilde_operator] = STATE(1188),
    [sym_await_expression] = STATE(1171),
    [sym_new_expression] = STATE(967),
    [sym_const_object_expression] = STATE(967),
    [sym__primary] = STATE(641),
    [sym_constructor_invocation] = STATE(638),
    [sym_type_arguments] = STATE(2454),
    [sym__statement] = STATE(532),
    [sym_local_function_declaration] = STATE(491),
    [sym_block] = STATE(488),
    [sym_expression_statement] = STATE(488),
    [sym_assert_statement] = STATE(488),
    [sym_assertion] = STATE(2726),
    [sym_switch_statement] = STATE(488),
    [sym_do_statement] = STATE(488),
    [sym_break_statement] = STATE(488),
    [sym_continue_statement] = STATE(488),
    [sym_yield_statement] = STATE(488),
    [sym_yield_each_statement] = STATE(488),
    [sym_return_statement] = STATE(488),
    [sym_try_statement] = STATE(488),
    [sym__try_head] = STATE(1927),
    [sym_if_statement] = STATE(488),
    [sym_while_statement] = STATE(488),
    [sym_for_statement] = STATE(488),
    [sym__annotation] = STATE(1287),
    [sym_marker_annotation] = STATE(1289),
    [sym_annotation] = STATE(1289),
    [sym__metadata] = STATE(1359),
    [sym_type_parameters] = STATE(2299),
    [sym_initialized_variable_definition] = STATE(2472),
    [sym__declared_identifier] = STATE(2151),
    [sym__final_const_var_or_type] = STATE(2686),
    [sym__type] = STATE(2047),
    [sym__type_not_function] = STATE(1616),
    [sym__type_not_void_not_function] = STATE(1668),
    [sym_function_type] = STATE(1655),
    [aux_sym__function_type_tails] = STATE(1482),
    [sym__function_type_tail] = STATE(1568),
    [sym__type_name] = STATE(1722),
    [sym__var_or_type] = STATE(2325),
    [sym_inferred_type] = STATE(1653),
    [sym_function_signature] = STATE(1879),
    [sym__formal_parameter_part] = STATE(1915),
    [sym_formal_parameter_list] = STATE(1636),
    [sym__strict_formal_parameter_list] = STATE(1626),
    [sym_local_variable_declaration] = STATE(509),
    [sym__covariant] = STATE(1552),
    [sym__function_builtin_identifier] = STATE(1424),
    [sym__get] = STATE(1992),
    [sym__set] = STATE(1992),
    [sym__new_builtin] = STATE(1701),
    [sym__late_builtin] = STATE(1618),
    [sym_this] = STATE(967),
    [sym_super] = STATE(1128),
    [sym_comment] = STATE(51),
    [sym_documentation_comment] = STATE(51),
    [aux_sym_program_repeat5] = STATE(44),
    [aux_sym_string_literal_repeat1] = STATE(473),
    [aux_sym__metadata_repeat1] = STATE(1143),
    [ts_builtin_sym_end] = ACTIONS(141),
    [sym_identifier] = ACTIONS(15),
    [anon_sym_POUND] = ACTIONS(139),
    [sym_decimal_integer_literal] = ACTIONS(19),
    [sym_hex_integer_literal] = ACTIONS(21),
    [sym_decimal_floating_point_literal] = ACTIONS(19),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(25),
    [anon_sym_DQUOTE] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_r_DQUOTE] = ACTIONS(35),
    [anon_sym_r_SQUOTE] = ACTIONS(37),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(39),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(43),
    [anon_sym_LBRACK] = ACTIONS(45),
    [anon_sym_null] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_LT] = ACTIONS(53),
    [sym_increment_operator] = ACTIONS(55),
    [sym_minus_operator] = ACTIONS(57),
    [sym__exclamation_operator] = ACTIONS(59),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_await] = ACTIONS(63),
    [anon_sym_switch] = ACTIONS(65),
    [anon_sym_do] = ACTIONS(67),
    [anon_sym_while] = ACTIONS(69),
    [anon_sym_continue] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [anon_sym_return] = ACTIONS(75),
    [anon_sym_try] = ACTIONS(77),
    [anon_sym_if] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_AT] = ACTIONS(83),
    [anon_sym_super] = ACTIONS(95),
    [sym_void_type] = ACTIONS(97),
    [anon_sym_var] = ACTIONS(99),
    [sym__break_builtin] = ACTIONS(105),
    [sym__assert_builtin] = ACTIONS(107),
    [anon_sym_covariant] = ACTIONS(109),
    [anon_sym_Function] = ACTIONS(113),
    [anon_sym_get] = ACTIONS(115),
    [anon_sym_set] = ACTIONS(121),
    [anon_sym_new] = ACTIONS(125),
    [sym_const_builtin] = ACTIONS(165),
    [sym_final_builtin] = ACTIONS(167),
    [anon_sym_late] = ACTIONS(131),
    [anon_sym_this] = ACTIONS(135),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_SLASH_SLASH_SLASH] = ACTIONS(7),
    [sym__block_comment] = ACTIONS(9),
    [sym__documentation_block_comment] = ACTIONS(11),
  },
  [52] = {
    [sym__literal] = STATE(967),
    [sym_symbol_literal] = STATE(912),
    [sym_true] = STATE(912),
    [sym_false] = STATE(912),
    [sym_string_literal] = STATE(912),
    [sym__string_literal_double_quotes] = STATE(617),
    [sym__string_literal_single_quotes] = STATE(617),
    [sym__string_literal_double_quotes_multiple] = STATE(617),
    [sym__string_literal_single_quotes_multiple] = STATE(617),
    [sym__raw_string_literal_double_quotes] = STATE(617),
    [sym__raw_string_literal_single_quotes] = STATE(617),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(617),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(617),
    [sym_list_literal] = STATE(912),
    [sym_set_or_map_literal] = STATE(912),
    [sym_null_literal] = STATE(912),
    [sym__expression] = STATE(2450),
    [sym__real_expression] = STATE(670),
    [sym_throw_expression] = STATE(976),
    [sym_assignment_expression] = STATE(976),
    [sym_assignable_expression] = STATE(1582),
    [sym_lambda_expression] = STATE(494),
    [sym_function_expression] = STATE(967),
    [sym_if_null_expression] = STATE(1377),
    [sym_conditional_expression] = STATE(1377),
    [sym_logical_or_expression] = STATE(1377),
    [sym_logical_and_expression] = STATE(1377),
    [sym_equality_expression] = STATE(1377),
    [sym_type_cast_expression] = STATE(1377),
    [sym_type_test_expression] = STATE(1377),
    [sym_relational_expression] = STATE(1377),
    [sym_bitwise_or_expression] = STATE(1377),
    [sym_bitwise_xor_expression] = STATE(1377),
    [sym_bitwise_and_expression] = STATE(1377),
    [sym_shift_expression] = STATE(1377),
    [sym_additive_expression] = STATE(1377),
    [sym_multiplicative_expression] = STATE(1377),
    [sym__unary_expression] = STATE(1118),
    [sym_unary_expression] = STATE(1169),
    [sym__postfix_expression] = STATE(1169),
    [sym_postfix_expression] = STATE(1170),
    [sym_prefix_operator] = STATE(360),
    [sym_negation_operator] = STATE(1206),
    [sym_tilde_operator] = STATE(1188),
    [sym_await_expression] = STATE(1171),
    [sym_new_expression] = STATE(967),
    [sym_const_object_expression] = STATE(967),
    [sym__primary] = STATE(641),
    [sym_constructor_invocation] = STATE(638),
    [sym_type_arguments] = STATE(2454),
    [sym__statement] = STATE(532),
    [sym_local_function_declaration] = STATE(491),
    [sym_block] = STATE(488),
    [sym_expression_statement] = STATE(488),
    [sym_assert_statement] = STATE(488),
    [sym_assertion] = STATE(2726),
    [sym_switch_statement] = STATE(488),
    [sym_do_statement] = STATE(488),
    [sym_break_statement] = STATE(488),
    [sym_continue_statement] = STATE(488),
    [sym_yield_statement] = STATE(488),
    [sym_yield_each_statement] = STATE(488),
    [sym_return_statement] = STATE(488),
    [sym_try_statement] = STATE(488),
    [sym__try_head] = STATE(1927),
    [sym_if_statement] = STATE(488),
    [sym_while_statement] = STATE(488),
    [sym_for_statement] = STATE(488),
    [sym__annotation] = STATE(1287),
    [sym_marker_annotation] = STATE(1289),
    [sym_annotation] = STATE(1289),
    [sym__metadata] = STATE(1359),
    [sym_type_parameters] = STATE(2299),
    [sym_initialized_variable_definition] = STATE(2472),
    [sym__declared_identifier] = STATE(2151),
    [sym__final_const_var_or_type] = STATE(2686),
    [sym__type] = STATE(2047),
    [sym__type_not_function] = STATE(1616),
    [sym__type_not_void_not_function] = STATE(1668),
    [sym_function_type] = STATE(1655),
    [aux_sym__function_type_tails] = STATE(1482),
    [sym__function_type_tail] = STATE(1568),
    [sym__type_name] = STATE(1722),
    [sym__var_or_type] = STATE(2325),
    [sym_inferred_type] = STATE(1653),
    [sym_function_signature] = STATE(1879),
    [sym__formal_parameter_part] = STATE(1915),
    [sym_formal_parameter_list] = STATE(1636),
    [sym__strict_formal_parameter_list] = STATE(1626),
    [sym_local_variable_declaration] = STATE(509),
    [sym__covariant] = STATE(1552),
    [sym__function_builtin_identifier] = STATE(1424),
    [sym__get] = STATE(1992),
    [sym__set] = STATE(1992),
    [sym__new_builtin] = STATE(1701),
    [sym__late_builtin] = STATE(1618),
    [sym_this] = STATE(967),
    [sym_super] = STATE(1128),
    [sym_comment] = STATE(52),
    [sym_documentation_comment] = STATE(52),
    [aux_sym_program_repeat5] = STATE(52),
    [aux_sym_string_literal_repeat1] = STATE(473),
    [aux_sym__metadata_repeat1] = STATE(1143),
    [sym_identifier] = ACTIONS(368),
    [anon_sym_POUND] = ACTIONS(371),
    [sym_decimal_integer_literal] = ACTIONS(374),
    [sym_hex_integer_literal] = ACTIONS(377),
    [sym_decimal_floating_point_literal] = ACTIONS(374),
    [anon_sym_true] = ACTIONS(380),
    [anon_sym_false] = ACTIONS(383),
    [anon_sym_DQUOTE] = ACTIONS(386),
    [anon_sym_SQUOTE] = ACTIONS(389),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(392),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(395),
    [anon_sym_r_DQUOTE] = ACTIONS(398),
    [anon_sym_r_SQUOTE] = ACTIONS(401),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(404),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(407),
    [anon_sym_LBRACE] = ACTIONS(523),
    [anon_sym_RBRACE] = ACTIONS(366),
    [anon_sym_LBRACK] = ACTIONS(413),
    [anon_sym_null] = ACTIONS(416),
    [anon_sym_throw] = ACTIONS(419),
    [anon_sym_LPAREN] = ACTIONS(422),
    [anon_sym_LT] = ACTIONS(425),
    [sym_increment_operator] = ACTIONS(428),
    [sym_minus_operator] = ACTIONS(431),
    [sym__exclamation_operator] = ACTIONS(434),
    [anon_sym_TILDE] = ACTIONS(437),
    [anon_sym_await] = ACTIONS(526),
    [anon_sym_switch] = ACTIONS(443),
    [anon_sym_do] = ACTIONS(446),
    [anon_sym_while] = ACTIONS(529),
    [anon_sym_continue] = ACTIONS(452),
    [anon_sym_yield] = ACTIONS(455),
    [anon_sym_return] = ACTIONS(458),
    [anon_sym_try] = ACTIONS(461),
    [anon_sym_if] = ACTIONS(532),
    [anon_sym_for] = ACTIONS(535),
    [anon_sym_AT] = ACTIONS(470),
    [anon_sym_super] = ACTIONS(473),
    [sym_void_type] = ACTIONS(476),
    [anon_sym_var] = ACTIONS(479),
    [sym__break_builtin] = ACTIONS(482),
    [sym__assert_builtin] = ACTIONS(485),
    [anon_sym_covariant] = ACTIONS(488),
    [anon_sym_Function] = ACTIONS(491),
    [anon_sym_get] = ACTIONS(494),
    [anon_sym_set] = ACTIONS(497),
    [anon_sym_new] = ACTIONS(500),
    [sym_const_builtin] = ACTIONS(503),
    [sym_final_builtin] = ACTIONS(506),
    [anon_sym_late] = ACTIONS(509),
    [anon_sym_this] = ACTIONS(512),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_SLASH_SLASH_SLASH] = ACTIONS(7),
    [sym__block_comment] = ACTIONS(9),
    [sym__documentation_block_comment] = ACTIONS(11),
  },
  [53] = {
    [sym__literal] = STATE(967),
    [sym_symbol_literal] = STATE(912),
    [sym_true] = STATE(912),
    [sym_false] = STATE(912),
    [sym_string_literal] = STATE(912),
    [sym__string_literal_double_quotes] = STATE(617),
    [sym__string_literal_single_quotes] = STATE(617),
    [sym__string_literal_double_quotes_multiple] = STATE(617),
    [sym__string_literal_single_quotes_multiple] = STATE(617),
    [sym__raw_string_literal_double_quotes] = STATE(617),
    [sym__raw_string_literal_single_quotes] = STATE(617),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(617),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(617),
    [sym_list_literal] = STATE(912),
    [sym_set_or_map_literal] = STATE(912),
    [sym_null_literal] = STATE(912),
    [sym__expression] = STATE(2450),
    [sym__real_expression] = STATE(670),
    [sym_throw_expression] = STATE(976),
    [sym_assignment_expression] = STATE(976),
    [sym_assignable_expression] = STATE(1582),
    [sym_lambda_expression] = STATE(494),
    [sym_function_expression] = STATE(967),
    [sym_if_null_expression] = STATE(1377),
    [sym_conditional_expression] = STATE(1377),
    [sym_logical_or_expression] = STATE(1377),
    [sym_logical_and_expression] = STATE(1377),
    [sym_equality_expression] = STATE(1377),
    [sym_type_cast_expression] = STATE(1377),
    [sym_type_test_expression] = STATE(1377),
    [sym_relational_expression] = STATE(1377),
    [sym_bitwise_or_expression] = STATE(1377),
    [sym_bitwise_xor_expression] = STATE(1377),
    [sym_bitwise_and_expression] = STATE(1377),
    [sym_shift_expression] = STATE(1377),
    [sym_additive_expression] = STATE(1377),
    [sym_multiplicative_expression] = STATE(1377),
    [sym__unary_expression] = STATE(1118),
    [sym_unary_expression] = STATE(1169),
    [sym__postfix_expression] = STATE(1169),
    [sym_postfix_expression] = STATE(1170),
    [sym_prefix_operator] = STATE(360),
    [sym_negation_operator] = STATE(1206),
    [sym_tilde_operator] = STATE(1188),
    [sym_await_expression] = STATE(1171),
    [sym_new_expression] = STATE(967),
    [sym_const_object_expression] = STATE(967),
    [sym__primary] = STATE(641),
    [sym_constructor_invocation] = STATE(638),
    [sym_type_arguments] = STATE(2454),
    [sym__statement] = STATE(532),
    [sym_local_function_declaration] = STATE(491),
    [sym_block] = STATE(488),
    [sym_expression_statement] = STATE(488),
    [sym_assert_statement] = STATE(488),
    [sym_assertion] = STATE(2726),
    [sym_switch_statement] = STATE(488),
    [sym_do_statement] = STATE(488),
    [sym_break_statement] = STATE(488),
    [sym_continue_statement] = STATE(488),
    [sym_yield_statement] = STATE(488),
    [sym_yield_each_statement] = STATE(488),
    [sym_return_statement] = STATE(488),
    [sym_try_statement] = STATE(488),
    [sym__try_head] = STATE(1927),
    [sym_if_statement] = STATE(488),
    [sym_while_statement] = STATE(488),
    [sym_for_statement] = STATE(488),
    [sym__annotation] = STATE(1287),
    [sym_marker_annotation] = STATE(1289),
    [sym_annotation] = STATE(1289),
    [sym__metadata] = STATE(1359),
    [sym_type_parameters] = STATE(2299),
    [sym_initialized_variable_definition] = STATE(2472),
    [sym__declared_identifier] = STATE(2151),
    [sym__final_const_var_or_type] = STATE(2686),
    [sym__type] = STATE(2047),
    [sym__type_not_function] = STATE(1616),
    [sym__type_not_void_not_function] = STATE(1668),
    [sym_function_type] = STATE(1655),
    [aux_sym__function_type_tails] = STATE(1482),
    [sym__function_type_tail] = STATE(1568),
    [sym__type_name] = STATE(1722),
    [sym__var_or_type] = STATE(2325),
    [sym_inferred_type] = STATE(1653),
    [sym_function_signature] = STATE(1879),
    [sym__formal_parameter_part] = STATE(1915),
    [sym_formal_parameter_list] = STATE(1636),
    [sym__strict_formal_parameter_list] = STATE(1626),
    [sym_local_variable_declaration] = STATE(509),
    [sym__covariant] = STATE(1552),
    [sym__function_builtin_identifier] = STATE(1424),
    [sym__get] = STATE(1992),
    [sym__set] = STATE(1992),
    [sym__new_builtin] = STATE(1701),
    [sym__late_builtin] = STATE(1618),
    [sym_this] = STATE(967),
    [sym_super] = STATE(1128),
    [sym_comment] = STATE(53),
    [sym_documentation_comment] = STATE(53),
    [aux_sym_program_repeat5] = STATE(44),
    [aux_sym_string_literal_repeat1] = STATE(473),
    [aux_sym__metadata_repeat1] = STATE(1143),
    [ts_builtin_sym_end] = ACTIONS(538),
    [sym_identifier] = ACTIONS(15),
    [anon_sym_POUND] = ACTIONS(139),
    [sym_decimal_integer_literal] = ACTIONS(19),
    [sym_hex_integer_literal] = ACTIONS(21),
    [sym_decimal_floating_point_literal] = ACTIONS(19),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(25),
    [anon_sym_DQUOTE] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_r_DQUOTE] = ACTIONS(35),
    [anon_sym_r_SQUOTE] = ACTIONS(37),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(39),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(43),
    [anon_sym_LBRACK] = ACTIONS(45),
    [anon_sym_null] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_LT] = ACTIONS(53),
    [sym_increment_operator] = ACTIONS(55),
    [sym_minus_operator] = ACTIONS(57),
    [sym__exclamation_operator] = ACTIONS(59),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_await] = ACTIONS(63),
    [anon_sym_switch] = ACTIONS(65),
    [anon_sym_do] = ACTIONS(67),
    [anon_sym_while] = ACTIONS(69),
    [anon_sym_continue] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [anon_sym_return] = ACTIONS(75),
    [anon_sym_try] = ACTIONS(77),
    [anon_sym_if] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_AT] = ACTIONS(83),
    [anon_sym_super] = ACTIONS(95),
    [sym_void_type] = ACTIONS(97),
    [anon_sym_var] = ACTIONS(99),
    [sym__break_builtin] = ACTIONS(105),
    [sym__assert_builtin] = ACTIONS(107),
    [anon_sym_covariant] = ACTIONS(109),
    [anon_sym_Function] = ACTIONS(113),
    [anon_sym_get] = ACTIONS(115),
    [anon_sym_set] = ACTIONS(121),
    [anon_sym_new] = ACTIONS(125),
    [sym_const_builtin] = ACTIONS(165),
    [sym_final_builtin] = ACTIONS(167),
    [anon_sym_late] = ACTIONS(131),
    [anon_sym_this] = ACTIONS(135),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_SLASH_SLASH_SLASH] = ACTIONS(7),
    [sym__block_comment] = ACTIONS(9),
    [sym__documentation_block_comment] = ACTIONS(11),
  },
  [54] = {
    [sym__literal] = STATE(967),
    [sym_symbol_literal] = STATE(912),
    [sym_true] = STATE(912),
    [sym_false] = STATE(912),
    [sym_string_literal] = STATE(912),
    [sym__string_literal_double_quotes] = STATE(617),
    [sym__string_literal_single_quotes] = STATE(617),
    [sym__string_literal_double_quotes_multiple] = STATE(617),
    [sym__string_literal_single_quotes_multiple] = STATE(617),
    [sym__raw_string_literal_double_quotes] = STATE(617),
    [sym__raw_string_literal_single_quotes] = STATE(617),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(617),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(617),
    [sym_list_literal] = STATE(912),
    [sym_set_or_map_literal] = STATE(912),
    [sym_null_literal] = STATE(912),
    [sym__expression] = STATE(2450),
    [sym__real_expression] = STATE(670),
    [sym_throw_expression] = STATE(976),
    [sym_assignment_expression] = STATE(976),
    [sym_assignable_expression] = STATE(1582),
    [sym_lambda_expression] = STATE(494),
    [sym_function_expression] = STATE(967),
    [sym_if_null_expression] = STATE(1377),
    [sym_conditional_expression] = STATE(1377),
    [sym_logical_or_expression] = STATE(1377),
    [sym_logical_and_expression] = STATE(1377),
    [sym_equality_expression] = STATE(1377),
    [sym_type_cast_expression] = STATE(1377),
    [sym_type_test_expression] = STATE(1377),
    [sym_relational_expression] = STATE(1377),
    [sym_bitwise_or_expression] = STATE(1377),
    [sym_bitwise_xor_expression] = STATE(1377),
    [sym_bitwise_and_expression] = STATE(1377),
    [sym_shift_expression] = STATE(1377),
    [sym_additive_expression] = STATE(1377),
    [sym_multiplicative_expression] = STATE(1377),
    [sym__unary_expression] = STATE(1118),
    [sym_unary_expression] = STATE(1169),
    [sym__postfix_expression] = STATE(1169),
    [sym_postfix_expression] = STATE(1170),
    [sym_prefix_operator] = STATE(360),
    [sym_negation_operator] = STATE(1206),
    [sym_tilde_operator] = STATE(1188),
    [sym_await_expression] = STATE(1171),
    [sym_new_expression] = STATE(967),
    [sym_const_object_expression] = STATE(967),
    [sym__primary] = STATE(641),
    [sym_constructor_invocation] = STATE(638),
    [sym_type_arguments] = STATE(2454),
    [sym__statement] = STATE(532),
    [sym_local_function_declaration] = STATE(491),
    [sym_block] = STATE(488),
    [sym_expression_statement] = STATE(488),
    [sym_assert_statement] = STATE(488),
    [sym_assertion] = STATE(2726),
    [sym_switch_statement] = STATE(488),
    [sym_do_statement] = STATE(488),
    [sym_break_statement] = STATE(488),
    [sym_continue_statement] = STATE(488),
    [sym_yield_statement] = STATE(488),
    [sym_yield_each_statement] = STATE(488),
    [sym_return_statement] = STATE(488),
    [sym_try_statement] = STATE(488),
    [sym__try_head] = STATE(1927),
    [sym_if_statement] = STATE(488),
    [sym_while_statement] = STATE(488),
    [sym_for_statement] = STATE(488),
    [sym__annotation] = STATE(1287),
    [sym_marker_annotation] = STATE(1289),
    [sym_annotation] = STATE(1289),
    [sym__metadata] = STATE(1359),
    [sym_type_parameters] = STATE(2299),
    [sym_initialized_variable_definition] = STATE(2472),
    [sym__declared_identifier] = STATE(2151),
    [sym__final_const_var_or_type] = STATE(2686),
    [sym__type] = STATE(2047),
    [sym__type_not_function] = STATE(1616),
    [sym__type_not_void_not_function] = STATE(1668),
    [sym_function_type] = STATE(1655),
    [aux_sym__function_type_tails] = STATE(1482),
    [sym__function_type_tail] = STATE(1568),
    [sym__type_name] = STATE(1722),
    [sym__var_or_type] = STATE(2325),
    [sym_inferred_type] = STATE(1653),
    [sym_function_signature] = STATE(1879),
    [sym__formal_parameter_part] = STATE(1915),
    [sym_formal_parameter_list] = STATE(1636),
    [sym__strict_formal_parameter_list] = STATE(1626),
    [sym_local_variable_declaration] = STATE(509),
    [sym__covariant] = STATE(1552),
    [sym__function_builtin_identifier] = STATE(1424),
    [sym__get] = STATE(1992),
    [sym__set] = STATE(1992),
    [sym__new_builtin] = STATE(1701),
    [sym__late_builtin] = STATE(1618),
    [sym_this] = STATE(967),
    [sym_super] = STATE(1128),
    [sym_comment] = STATE(54),
    [sym_documentation_comment] = STATE(54),
    [aux_sym_program_repeat5] = STATE(44),
    [aux_sym_string_literal_repeat1] = STATE(473),
    [aux_sym__metadata_repeat1] = STATE(1143),
    [ts_builtin_sym_end] = ACTIONS(145),
    [sym_identifier] = ACTIONS(15),
    [anon_sym_POUND] = ACTIONS(139),
    [sym_decimal_integer_literal] = ACTIONS(19),
    [sym_hex_integer_literal] = ACTIONS(21),
    [sym_decimal_floating_point_literal] = ACTIONS(19),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(25),
    [anon_sym_DQUOTE] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_r_DQUOTE] = ACTIONS(35),
    [anon_sym_r_SQUOTE] = ACTIONS(37),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(39),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(43),
    [anon_sym_LBRACK] = ACTIONS(45),
    [anon_sym_null] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_LT] = ACTIONS(53),
    [sym_increment_operator] = ACTIONS(55),
    [sym_minus_operator] = ACTIONS(57),
    [sym__exclamation_operator] = ACTIONS(59),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_await] = ACTIONS(63),
    [anon_sym_switch] = ACTIONS(65),
    [anon_sym_do] = ACTIONS(67),
    [anon_sym_while] = ACTIONS(69),
    [anon_sym_continue] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [anon_sym_return] = ACTIONS(75),
    [anon_sym_try] = ACTIONS(77),
    [anon_sym_if] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_AT] = ACTIONS(83),
    [anon_sym_super] = ACTIONS(95),
    [sym_void_type] = ACTIONS(97),
    [anon_sym_var] = ACTIONS(99),
    [sym__break_builtin] = ACTIONS(105),
    [sym__assert_builtin] = ACTIONS(107),
    [anon_sym_covariant] = ACTIONS(109),
    [anon_sym_Function] = ACTIONS(113),
    [anon_sym_get] = ACTIONS(115),
    [anon_sym_set] = ACTIONS(121),
    [anon_sym_new] = ACTIONS(125),
    [sym_const_builtin] = ACTIONS(165),
    [sym_final_builtin] = ACTIONS(167),
    [anon_sym_late] = ACTIONS(131),
    [anon_sym_this] = ACTIONS(135),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_SLASH_SLASH_SLASH] = ACTIONS(7),
    [sym__block_comment] = ACTIONS(9),
    [sym__documentation_block_comment] = ACTIONS(11),
  },
  [55] = {
    [sym__literal] = STATE(967),
    [sym_symbol_literal] = STATE(912),
    [sym_true] = STATE(912),
    [sym_false] = STATE(912),
    [sym_string_literal] = STATE(912),
    [sym__string_literal_double_quotes] = STATE(617),
    [sym__string_literal_single_quotes] = STATE(617),
    [sym__string_literal_double_quotes_multiple] = STATE(617),
    [sym__string_literal_single_quotes_multiple] = STATE(617),
    [sym__raw_string_literal_double_quotes] = STATE(617),
    [sym__raw_string_literal_single_quotes] = STATE(617),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(617),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(617),
    [sym_list_literal] = STATE(912),
    [sym_set_or_map_literal] = STATE(912),
    [sym_null_literal] = STATE(912),
    [sym__expression] = STATE(2450),
    [sym__real_expression] = STATE(670),
    [sym_throw_expression] = STATE(976),
    [sym_assignment_expression] = STATE(976),
    [sym_assignable_expression] = STATE(1582),
    [sym_lambda_expression] = STATE(494),
    [sym_function_expression] = STATE(967),
    [sym_if_null_expression] = STATE(1377),
    [sym_conditional_expression] = STATE(1377),
    [sym_logical_or_expression] = STATE(1377),
    [sym_logical_and_expression] = STATE(1377),
    [sym_equality_expression] = STATE(1377),
    [sym_type_cast_expression] = STATE(1377),
    [sym_type_test_expression] = STATE(1377),
    [sym_relational_expression] = STATE(1377),
    [sym_bitwise_or_expression] = STATE(1377),
    [sym_bitwise_xor_expression] = STATE(1377),
    [sym_bitwise_and_expression] = STATE(1377),
    [sym_shift_expression] = STATE(1377),
    [sym_additive_expression] = STATE(1377),
    [sym_multiplicative_expression] = STATE(1377),
    [sym__unary_expression] = STATE(1118),
    [sym_unary_expression] = STATE(1169),
    [sym__postfix_expression] = STATE(1169),
    [sym_postfix_expression] = STATE(1170),
    [sym_prefix_operator] = STATE(360),
    [sym_negation_operator] = STATE(1206),
    [sym_tilde_operator] = STATE(1188),
    [sym_await_expression] = STATE(1171),
    [sym_new_expression] = STATE(967),
    [sym_const_object_expression] = STATE(967),
    [sym__primary] = STATE(641),
    [sym_constructor_invocation] = STATE(638),
    [sym_type_arguments] = STATE(2454),
    [sym__statement] = STATE(511),
    [sym_local_function_declaration] = STATE(491),
    [sym_block] = STATE(488),
    [sym_expression_statement] = STATE(488),
    [sym_assert_statement] = STATE(488),
    [sym_assertion] = STATE(2726),
    [sym_switch_statement] = STATE(488),
    [sym_do_statement] = STATE(488),
    [sym_break_statement] = STATE(488),
    [sym_continue_statement] = STATE(488),
    [sym_yield_statement] = STATE(488),
    [sym_yield_each_statement] = STATE(488),
    [sym_return_statement] = STATE(488),
    [sym_try_statement] = STATE(488),
    [sym__try_head] = STATE(1956),
    [sym_if_statement] = STATE(488),
    [sym_while_statement] = STATE(488),
    [sym_for_statement] = STATE(488),
    [sym__annotation] = STATE(1287),
    [sym_marker_annotation] = STATE(1289),
    [sym_annotation] = STATE(1289),
    [sym__metadata] = STATE(1382),
    [sym_type_parameters] = STATE(2299),
    [sym_initialized_variable_definition] = STATE(2472),
    [sym__declared_identifier] = STATE(2151),
    [sym__final_const_var_or_type] = STATE(2686),
    [sym__type] = STATE(2047),
    [sym__type_not_function] = STATE(1616),
    [sym__type_not_void_not_function] = STATE(1668),
    [sym_function_type] = STATE(1655),
    [aux_sym__function_type_tails] = STATE(1482),
    [sym__function_type_tail] = STATE(1568),
    [sym__type_name] = STATE(1722),
    [sym__var_or_type] = STATE(2325),
    [sym_inferred_type] = STATE(1653),
    [sym_function_signature] = STATE(1953),
    [sym__formal_parameter_part] = STATE(1915),
    [sym_formal_parameter_list] = STATE(1636),
    [sym__strict_formal_parameter_list] = STATE(1626),
    [sym_local_variable_declaration] = STATE(509),
    [sym__covariant] = STATE(1552),
    [sym__function_builtin_identifier] = STATE(1424),
    [sym__get] = STATE(1992),
    [sym__set] = STATE(1992),
    [sym__new_builtin] = STATE(1701),
    [sym__late_builtin] = STATE(1618),
    [sym_this] = STATE(967),
    [sym_super] = STATE(1128),
    [sym_comment] = STATE(55),
    [sym_documentation_comment] = STATE(55),
    [aux_sym_string_literal_repeat1] = STATE(473),
    [aux_sym__metadata_repeat1] = STATE(1143),
    [sym_identifier] = ACTIONS(15),
    [anon_sym_POUND] = ACTIONS(139),
    [sym_decimal_integer_literal] = ACTIONS(19),
    [sym_hex_integer_literal] = ACTIONS(21),
    [sym_decimal_floating_point_literal] = ACTIONS(19),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(25),
    [anon_sym_DQUOTE] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_r_DQUOTE] = ACTIONS(35),
    [anon_sym_r_SQUOTE] = ACTIONS(37),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(39),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(540),
    [anon_sym_LBRACK] = ACTIONS(45),
    [anon_sym_null] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_LT] = ACTIONS(53),
    [sym_increment_operator] = ACTIONS(55),
    [sym_minus_operator] = ACTIONS(57),
    [sym__exclamation_operator] = ACTIONS(59),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_await] = ACTIONS(542),
    [anon_sym_switch] = ACTIONS(65),
    [anon_sym_do] = ACTIONS(67),
    [anon_sym_while] = ACTIONS(544),
    [anon_sym_continue] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [anon_sym_return] = ACTIONS(75),
    [anon_sym_try] = ACTIONS(77),
    [anon_sym_if] = ACTIONS(546),
    [anon_sym_for] = ACTIONS(548),
    [anon_sym_AT] = ACTIONS(83),
    [anon_sym_super] = ACTIONS(95),
    [sym_void_type] = ACTIONS(97),
    [anon_sym_var] = ACTIONS(99),
    [sym__break_builtin] = ACTIONS(105),
    [sym__assert_builtin] = ACTIONS(107),
    [anon_sym_covariant] = ACTIONS(109),
    [anon_sym_Function] = ACTIONS(113),
    [anon_sym_get] = ACTIONS(115),
    [anon_sym_set] = ACTIONS(121),
    [anon_sym_new] = ACTIONS(125),
    [sym_const_builtin] = ACTIONS(165),
    [sym_final_builtin] = ACTIONS(167),
    [anon_sym_late] = ACTIONS(131),
    [anon_sym_this] = ACTIONS(135),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_SLASH_SLASH_SLASH] = ACTIONS(7),
    [sym__block_comment] = ACTIONS(9),
    [sym__documentation_block_comment] = ACTIONS(11),
  },
  [56] = {
    [sym__literal] = STATE(967),
    [sym_symbol_literal] = STATE(912),
    [sym_true] = STATE(912),
    [sym_false] = STATE(912),
    [sym_string_literal] = STATE(912),
    [sym__string_literal_double_quotes] = STATE(617),
    [sym__string_literal_single_quotes] = STATE(617),
    [sym__string_literal_double_quotes_multiple] = STATE(617),
    [sym__string_literal_single_quotes_multiple] = STATE(617),
    [sym__raw_string_literal_double_quotes] = STATE(617),
    [sym__raw_string_literal_single_quotes] = STATE(617),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(617),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(617),
    [sym_list_literal] = STATE(912),
    [sym_set_or_map_literal] = STATE(912),
    [sym_null_literal] = STATE(912),
    [sym__expression] = STATE(2450),
    [sym__real_expression] = STATE(670),
    [sym_throw_expression] = STATE(976),
    [sym_assignment_expression] = STATE(976),
    [sym_assignable_expression] = STATE(1582),
    [sym_lambda_expression] = STATE(494),
    [sym_function_expression] = STATE(967),
    [sym_if_null_expression] = STATE(1377),
    [sym_conditional_expression] = STATE(1377),
    [sym_logical_or_expression] = STATE(1377),
    [sym_logical_and_expression] = STATE(1377),
    [sym_equality_expression] = STATE(1377),
    [sym_type_cast_expression] = STATE(1377),
    [sym_type_test_expression] = STATE(1377),
    [sym_relational_expression] = STATE(1377),
    [sym_bitwise_or_expression] = STATE(1377),
    [sym_bitwise_xor_expression] = STATE(1377),
    [sym_bitwise_and_expression] = STATE(1377),
    [sym_shift_expression] = STATE(1377),
    [sym_additive_expression] = STATE(1377),
    [sym_multiplicative_expression] = STATE(1377),
    [sym__unary_expression] = STATE(1118),
    [sym_unary_expression] = STATE(1169),
    [sym__postfix_expression] = STATE(1169),
    [sym_postfix_expression] = STATE(1170),
    [sym_prefix_operator] = STATE(360),
    [sym_negation_operator] = STATE(1206),
    [sym_tilde_operator] = STATE(1188),
    [sym_await_expression] = STATE(1171),
    [sym_new_expression] = STATE(967),
    [sym_const_object_expression] = STATE(967),
    [sym__primary] = STATE(641),
    [sym_constructor_invocation] = STATE(638),
    [sym_type_arguments] = STATE(2454),
    [sym__statement] = STATE(506),
    [sym_local_function_declaration] = STATE(491),
    [sym_block] = STATE(488),
    [sym_expression_statement] = STATE(488),
    [sym_assert_statement] = STATE(488),
    [sym_assertion] = STATE(2726),
    [sym_switch_statement] = STATE(488),
    [sym_do_statement] = STATE(488),
    [sym_break_statement] = STATE(488),
    [sym_continue_statement] = STATE(488),
    [sym_yield_statement] = STATE(488),
    [sym_yield_each_statement] = STATE(488),
    [sym_return_statement] = STATE(488),
    [sym_try_statement] = STATE(488),
    [sym__try_head] = STATE(1927),
    [sym_if_statement] = STATE(488),
    [sym_while_statement] = STATE(488),
    [sym_for_statement] = STATE(488),
    [sym__annotation] = STATE(1287),
    [sym_marker_annotation] = STATE(1289),
    [sym_annotation] = STATE(1289),
    [sym__metadata] = STATE(1359),
    [sym_type_parameters] = STATE(2299),
    [sym_initialized_variable_definition] = STATE(2472),
    [sym__declared_identifier] = STATE(2151),
    [sym__final_const_var_or_type] = STATE(2686),
    [sym__type] = STATE(2047),
    [sym__type_not_function] = STATE(1616),
    [sym__type_not_void_not_function] = STATE(1668),
    [sym_function_type] = STATE(1655),
    [aux_sym__function_type_tails] = STATE(1482),
    [sym__function_type_tail] = STATE(1568),
    [sym__type_name] = STATE(1722),
    [sym__var_or_type] = STATE(2325),
    [sym_inferred_type] = STATE(1653),
    [sym_function_signature] = STATE(1879),
    [sym__formal_parameter_part] = STATE(1915),
    [sym_formal_parameter_list] = STATE(1636),
    [sym__strict_formal_parameter_list] = STATE(1626),
    [sym_local_variable_declaration] = STATE(509),
    [sym__covariant] = STATE(1552),
    [sym__function_builtin_identifier] = STATE(1424),
    [sym__get] = STATE(1992),
    [sym__set] = STATE(1992),
    [sym__new_builtin] = STATE(1701),
    [sym__late_builtin] = STATE(1618),
    [sym_this] = STATE(967),
    [sym_super] = STATE(1128),
    [sym_comment] = STATE(56),
    [sym_documentation_comment] = STATE(56),
    [aux_sym_string_literal_repeat1] = STATE(473),
    [aux_sym__metadata_repeat1] = STATE(1143),
    [sym_identifier] = ACTIONS(15),
    [anon_sym_POUND] = ACTIONS(139),
    [sym_decimal_integer_literal] = ACTIONS(19),
    [sym_hex_integer_literal] = ACTIONS(21),
    [sym_decimal_floating_point_literal] = ACTIONS(19),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(25),
    [anon_sym_DQUOTE] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_r_DQUOTE] = ACTIONS(35),
    [anon_sym_r_SQUOTE] = ACTIONS(37),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(39),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(177),
    [anon_sym_LBRACK] = ACTIONS(45),
    [anon_sym_null] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_LT] = ACTIONS(53),
    [sym_increment_operator] = ACTIONS(55),
    [sym_minus_operator] = ACTIONS(57),
    [sym__exclamation_operator] = ACTIONS(59),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_await] = ACTIONS(181),
    [anon_sym_switch] = ACTIONS(65),
    [anon_sym_do] = ACTIONS(67),
    [anon_sym_while] = ACTIONS(159),
    [anon_sym_continue] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [anon_sym_return] = ACTIONS(75),
    [anon_sym_try] = ACTIONS(77),
    [anon_sym_if] = ACTIONS(185),
    [anon_sym_for] = ACTIONS(187),
    [anon_sym_AT] = ACTIONS(83),
    [anon_sym_super] = ACTIONS(95),
    [sym_void_type] = ACTIONS(97),
    [anon_sym_var] = ACTIONS(99),
    [sym__break_builtin] = ACTIONS(105),
    [sym__assert_builtin] = ACTIONS(107),
    [anon_sym_covariant] = ACTIONS(109),
    [anon_sym_Function] = ACTIONS(113),
    [anon_sym_get] = ACTIONS(115),
    [anon_sym_set] = ACTIONS(121),
    [anon_sym_new] = ACTIONS(125),
    [sym_const_builtin] = ACTIONS(165),
    [sym_final_builtin] = ACTIONS(167),
    [anon_sym_late] = ACTIONS(131),
    [anon_sym_this] = ACTIONS(135),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_SLASH_SLASH_SLASH] = ACTIONS(7),
    [sym__block_comment] = ACTIONS(9),
    [sym__documentation_block_comment] = ACTIONS(11),
  },
  [57] = {
    [sym__literal] = STATE(967),
    [sym_symbol_literal] = STATE(912),
    [sym_true] = STATE(912),
    [sym_false] = STATE(912),
    [sym_string_literal] = STATE(912),
    [sym__string_literal_double_quotes] = STATE(617),
    [sym__string_literal_single_quotes] = STATE(617),
    [sym__string_literal_double_quotes_multiple] = STATE(617),
    [sym__string_literal_single_quotes_multiple] = STATE(617),
    [sym__raw_string_literal_double_quotes] = STATE(617),
    [sym__raw_string_literal_single_quotes] = STATE(617),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(617),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(617),
    [sym_list_literal] = STATE(912),
    [sym_set_or_map_literal] = STATE(912),
    [sym_null_literal] = STATE(912),
    [sym__expression] = STATE(2450),
    [sym__real_expression] = STATE(670),
    [sym_throw_expression] = STATE(976),
    [sym_assignment_expression] = STATE(976),
    [sym_assignable_expression] = STATE(1582),
    [sym_lambda_expression] = STATE(494),
    [sym_function_expression] = STATE(967),
    [sym_if_null_expression] = STATE(1377),
    [sym_conditional_expression] = STATE(1377),
    [sym_logical_or_expression] = STATE(1377),
    [sym_logical_and_expression] = STATE(1377),
    [sym_equality_expression] = STATE(1377),
    [sym_type_cast_expression] = STATE(1377),
    [sym_type_test_expression] = STATE(1377),
    [sym_relational_expression] = STATE(1377),
    [sym_bitwise_or_expression] = STATE(1377),
    [sym_bitwise_xor_expression] = STATE(1377),
    [sym_bitwise_and_expression] = STATE(1377),
    [sym_shift_expression] = STATE(1377),
    [sym_additive_expression] = STATE(1377),
    [sym_multiplicative_expression] = STATE(1377),
    [sym__unary_expression] = STATE(1118),
    [sym_unary_expression] = STATE(1169),
    [sym__postfix_expression] = STATE(1169),
    [sym_postfix_expression] = STATE(1170),
    [sym_prefix_operator] = STATE(360),
    [sym_negation_operator] = STATE(1206),
    [sym_tilde_operator] = STATE(1188),
    [sym_await_expression] = STATE(1171),
    [sym_new_expression] = STATE(967),
    [sym_const_object_expression] = STATE(967),
    [sym__primary] = STATE(641),
    [sym_constructor_invocation] = STATE(638),
    [sym_type_arguments] = STATE(2454),
    [sym__statement] = STATE(490),
    [sym_local_function_declaration] = STATE(491),
    [sym_block] = STATE(488),
    [sym_expression_statement] = STATE(488),
    [sym_assert_statement] = STATE(488),
    [sym_assertion] = STATE(2726),
    [sym_switch_statement] = STATE(488),
    [sym_do_statement] = STATE(488),
    [sym_break_statement] = STATE(488),
    [sym_continue_statement] = STATE(488),
    [sym_yield_statement] = STATE(488),
    [sym_yield_each_statement] = STATE(488),
    [sym_return_statement] = STATE(488),
    [sym_try_statement] = STATE(488),
    [sym__try_head] = STATE(1927),
    [sym_if_statement] = STATE(488),
    [sym_while_statement] = STATE(488),
    [sym_for_statement] = STATE(488),
    [sym__annotation] = STATE(1287),
    [sym_marker_annotation] = STATE(1289),
    [sym_annotation] = STATE(1289),
    [sym__metadata] = STATE(1359),
    [sym_type_parameters] = STATE(2299),
    [sym_initialized_variable_definition] = STATE(2472),
    [sym__declared_identifier] = STATE(2151),
    [sym__final_const_var_or_type] = STATE(2686),
    [sym__type] = STATE(2047),
    [sym__type_not_function] = STATE(1616),
    [sym__type_not_void_not_function] = STATE(1668),
    [sym_function_type] = STATE(1655),
    [aux_sym__function_type_tails] = STATE(1482),
    [sym__function_type_tail] = STATE(1568),
    [sym__type_name] = STATE(1722),
    [sym__var_or_type] = STATE(2325),
    [sym_inferred_type] = STATE(1653),
    [sym_function_signature] = STATE(1879),
    [sym__formal_parameter_part] = STATE(1915),
    [sym_formal_parameter_list] = STATE(1636),
    [sym__strict_formal_parameter_list] = STATE(1626),
    [sym_local_variable_declaration] = STATE(509),
    [sym__covariant] = STATE(1552),
    [sym__function_builtin_identifier] = STATE(1424),
    [sym__get] = STATE(1992),
    [sym__set] = STATE(1992),
    [sym__new_builtin] = STATE(1701),
    [sym__late_builtin] = STATE(1618),
    [sym_this] = STATE(967),
    [sym_super] = STATE(1128),
    [sym_comment] = STATE(57),
    [sym_documentation_comment] = STATE(57),
    [aux_sym_string_literal_repeat1] = STATE(473),
    [aux_sym__metadata_repeat1] = STATE(1143),
    [sym_identifier] = ACTIONS(15),
    [anon_sym_POUND] = ACTIONS(139),
    [sym_decimal_integer_literal] = ACTIONS(19),
    [sym_hex_integer_literal] = ACTIONS(21),
    [sym_decimal_floating_point_literal] = ACTIONS(19),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(25),
    [anon_sym_DQUOTE] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_r_DQUOTE] = ACTIONS(35),
    [anon_sym_r_SQUOTE] = ACTIONS(37),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(39),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(43),
    [anon_sym_LBRACK] = ACTIONS(45),
    [anon_sym_null] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_LT] = ACTIONS(53),
    [sym_increment_operator] = ACTIONS(55),
    [sym_minus_operator] = ACTIONS(57),
    [sym__exclamation_operator] = ACTIONS(59),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_await] = ACTIONS(63),
    [anon_sym_switch] = ACTIONS(65),
    [anon_sym_do] = ACTIONS(67),
    [anon_sym_while] = ACTIONS(69),
    [anon_sym_continue] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [anon_sym_return] = ACTIONS(75),
    [anon_sym_try] = ACTIONS(77),
    [anon_sym_if] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_AT] = ACTIONS(83),
    [anon_sym_super] = ACTIONS(95),
    [sym_void_type] = ACTIONS(97),
    [anon_sym_var] = ACTIONS(99),
    [sym__break_builtin] = ACTIONS(105),
    [sym__assert_builtin] = ACTIONS(107),
    [anon_sym_covariant] = ACTIONS(109),
    [anon_sym_Function] = ACTIONS(113),
    [anon_sym_get] = ACTIONS(115),
    [anon_sym_set] = ACTIONS(121),
    [anon_sym_new] = ACTIONS(125),
    [sym_const_builtin] = ACTIONS(165),
    [sym_final_builtin] = ACTIONS(167),
    [anon_sym_late] = ACTIONS(131),
    [anon_sym_this] = ACTIONS(135),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_SLASH_SLASH_SLASH] = ACTIONS(7),
    [sym__block_comment] = ACTIONS(9),
    [sym__documentation_block_comment] = ACTIONS(11),
  },
  [58] = {
    [sym__literal] = STATE(967),
    [sym_symbol_literal] = STATE(912),
    [sym_true] = STATE(912),
    [sym_false] = STATE(912),
    [sym_string_literal] = STATE(912),
    [sym__string_literal_double_quotes] = STATE(617),
    [sym__string_literal_single_quotes] = STATE(617),
    [sym__string_literal_double_quotes_multiple] = STATE(617),
    [sym__string_literal_single_quotes_multiple] = STATE(617),
    [sym__raw_string_literal_double_quotes] = STATE(617),
    [sym__raw_string_literal_single_quotes] = STATE(617),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(617),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(617),
    [sym_list_literal] = STATE(912),
    [sym_set_or_map_literal] = STATE(912),
    [sym_null_literal] = STATE(912),
    [sym__expression] = STATE(2450),
    [sym__real_expression] = STATE(670),
    [sym_throw_expression] = STATE(976),
    [sym_assignment_expression] = STATE(976),
    [sym_assignable_expression] = STATE(1582),
    [sym_lambda_expression] = STATE(494),
    [sym_function_expression] = STATE(967),
    [sym_if_null_expression] = STATE(1377),
    [sym_conditional_expression] = STATE(1377),
    [sym_logical_or_expression] = STATE(1377),
    [sym_logical_and_expression] = STATE(1377),
    [sym_equality_expression] = STATE(1377),
    [sym_type_cast_expression] = STATE(1377),
    [sym_type_test_expression] = STATE(1377),
    [sym_relational_expression] = STATE(1377),
    [sym_bitwise_or_expression] = STATE(1377),
    [sym_bitwise_xor_expression] = STATE(1377),
    [sym_bitwise_and_expression] = STATE(1377),
    [sym_shift_expression] = STATE(1377),
    [sym_additive_expression] = STATE(1377),
    [sym_multiplicative_expression] = STATE(1377),
    [sym__unary_expression] = STATE(1118),
    [sym_unary_expression] = STATE(1169),
    [sym__postfix_expression] = STATE(1169),
    [sym_postfix_expression] = STATE(1170),
    [sym_prefix_operator] = STATE(360),
    [sym_negation_operator] = STATE(1206),
    [sym_tilde_operator] = STATE(1188),
    [sym_await_expression] = STATE(1171),
    [sym_new_expression] = STATE(967),
    [sym_const_object_expression] = STATE(967),
    [sym__primary] = STATE(641),
    [sym_constructor_invocation] = STATE(638),
    [sym_type_arguments] = STATE(2454),
    [sym__statement] = STATE(490),
    [sym_local_function_declaration] = STATE(491),
    [sym_block] = STATE(488),
    [sym_expression_statement] = STATE(488),
    [sym_assert_statement] = STATE(488),
    [sym_assertion] = STATE(2726),
    [sym_switch_statement] = STATE(488),
    [sym_do_statement] = STATE(488),
    [sym_break_statement] = STATE(488),
    [sym_continue_statement] = STATE(488),
    [sym_yield_statement] = STATE(488),
    [sym_yield_each_statement] = STATE(488),
    [sym_return_statement] = STATE(488),
    [sym_try_statement] = STATE(488),
    [sym__try_head] = STATE(1956),
    [sym_if_statement] = STATE(488),
    [sym_while_statement] = STATE(488),
    [sym_for_statement] = STATE(488),
    [sym__annotation] = STATE(1287),
    [sym_marker_annotation] = STATE(1289),
    [sym_annotation] = STATE(1289),
    [sym__metadata] = STATE(1382),
    [sym_type_parameters] = STATE(2299),
    [sym_initialized_variable_definition] = STATE(2472),
    [sym__declared_identifier] = STATE(2151),
    [sym__final_const_var_or_type] = STATE(2686),
    [sym__type] = STATE(2047),
    [sym__type_not_function] = STATE(1616),
    [sym__type_not_void_not_function] = STATE(1668),
    [sym_function_type] = STATE(1655),
    [aux_sym__function_type_tails] = STATE(1482),
    [sym__function_type_tail] = STATE(1568),
    [sym__type_name] = STATE(1722),
    [sym__var_or_type] = STATE(2325),
    [sym_inferred_type] = STATE(1653),
    [sym_function_signature] = STATE(1953),
    [sym__formal_parameter_part] = STATE(1915),
    [sym_formal_parameter_list] = STATE(1636),
    [sym__strict_formal_parameter_list] = STATE(1626),
    [sym_local_variable_declaration] = STATE(509),
    [sym__covariant] = STATE(1552),
    [sym__function_builtin_identifier] = STATE(1424),
    [sym__get] = STATE(1992),
    [sym__set] = STATE(1992),
    [sym__new_builtin] = STATE(1701),
    [sym__late_builtin] = STATE(1618),
    [sym_this] = STATE(967),
    [sym_super] = STATE(1128),
    [sym_comment] = STATE(58),
    [sym_documentation_comment] = STATE(58),
    [aux_sym_string_literal_repeat1] = STATE(473),
    [aux_sym__metadata_repeat1] = STATE(1143),
    [sym_identifier] = ACTIONS(15),
    [anon_sym_POUND] = ACTIONS(139),
    [sym_decimal_integer_literal] = ACTIONS(19),
    [sym_hex_integer_literal] = ACTIONS(21),
    [sym_decimal_floating_point_literal] = ACTIONS(19),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(25),
    [anon_sym_DQUOTE] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_r_DQUOTE] = ACTIONS(35),
    [anon_sym_r_SQUOTE] = ACTIONS(37),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(39),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(540),
    [anon_sym_LBRACK] = ACTIONS(45),
    [anon_sym_null] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_LT] = ACTIONS(53),
    [sym_increment_operator] = ACTIONS(55),
    [sym_minus_operator] = ACTIONS(57),
    [sym__exclamation_operator] = ACTIONS(59),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_await] = ACTIONS(542),
    [anon_sym_switch] = ACTIONS(65),
    [anon_sym_do] = ACTIONS(67),
    [anon_sym_while] = ACTIONS(544),
    [anon_sym_continue] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [anon_sym_return] = ACTIONS(75),
    [anon_sym_try] = ACTIONS(77),
    [anon_sym_if] = ACTIONS(546),
    [anon_sym_for] = ACTIONS(548),
    [anon_sym_AT] = ACTIONS(83),
    [anon_sym_super] = ACTIONS(95),
    [sym_void_type] = ACTIONS(97),
    [anon_sym_var] = ACTIONS(99),
    [sym__break_builtin] = ACTIONS(105),
    [sym__assert_builtin] = ACTIONS(107),
    [anon_sym_covariant] = ACTIONS(109),
    [anon_sym_Function] = ACTIONS(113),
    [anon_sym_get] = ACTIONS(115),
    [anon_sym_set] = ACTIONS(121),
    [anon_sym_new] = ACTIONS(125),
    [sym_const_builtin] = ACTIONS(165),
    [sym_final_builtin] = ACTIONS(167),
    [anon_sym_late] = ACTIONS(131),
    [anon_sym_this] = ACTIONS(135),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_SLASH_SLASH_SLASH] = ACTIONS(7),
    [sym__block_comment] = ACTIONS(9),
    [sym__documentation_block_comment] = ACTIONS(11),
  },
  [59] = {
    [sym__literal] = STATE(967),
    [sym_symbol_literal] = STATE(912),
    [sym_true] = STATE(912),
    [sym_false] = STATE(912),
    [sym_string_literal] = STATE(912),
    [sym__string_literal_double_quotes] = STATE(617),
    [sym__string_literal_single_quotes] = STATE(617),
    [sym__string_literal_double_quotes_multiple] = STATE(617),
    [sym__string_literal_single_quotes_multiple] = STATE(617),
    [sym__raw_string_literal_double_quotes] = STATE(617),
    [sym__raw_string_literal_single_quotes] = STATE(617),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(617),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(617),
    [sym_list_literal] = STATE(912),
    [sym_set_or_map_literal] = STATE(912),
    [sym_null_literal] = STATE(912),
    [sym__expression] = STATE(2450),
    [sym__real_expression] = STATE(670),
    [sym_throw_expression] = STATE(976),
    [sym_assignment_expression] = STATE(976),
    [sym_assignable_expression] = STATE(1582),
    [sym_lambda_expression] = STATE(494),
    [sym_function_expression] = STATE(967),
    [sym_if_null_expression] = STATE(1377),
    [sym_conditional_expression] = STATE(1377),
    [sym_logical_or_expression] = STATE(1377),
    [sym_logical_and_expression] = STATE(1377),
    [sym_equality_expression] = STATE(1377),
    [sym_type_cast_expression] = STATE(1377),
    [sym_type_test_expression] = STATE(1377),
    [sym_relational_expression] = STATE(1377),
    [sym_bitwise_or_expression] = STATE(1377),
    [sym_bitwise_xor_expression] = STATE(1377),
    [sym_bitwise_and_expression] = STATE(1377),
    [sym_shift_expression] = STATE(1377),
    [sym_additive_expression] = STATE(1377),
    [sym_multiplicative_expression] = STATE(1377),
    [sym__unary_expression] = STATE(1118),
    [sym_unary_expression] = STATE(1169),
    [sym__postfix_expression] = STATE(1169),
    [sym_postfix_expression] = STATE(1170),
    [sym_prefix_operator] = STATE(360),
    [sym_negation_operator] = STATE(1206),
    [sym_tilde_operator] = STATE(1188),
    [sym_await_expression] = STATE(1171),
    [sym_new_expression] = STATE(967),
    [sym_const_object_expression] = STATE(967),
    [sym__primary] = STATE(641),
    [sym_constructor_invocation] = STATE(638),
    [sym_type_arguments] = STATE(2454),
    [sym__statement] = STATE(2820),
    [sym_local_function_declaration] = STATE(491),
    [sym_block] = STATE(488),
    [sym_expression_statement] = STATE(488),
    [sym_assert_statement] = STATE(488),
    [sym_assertion] = STATE(2726),
    [sym_switch_statement] = STATE(488),
    [sym_do_statement] = STATE(488),
    [sym_break_statement] = STATE(488),
    [sym_continue_statement] = STATE(488),
    [sym_yield_statement] = STATE(488),
    [sym_yield_each_statement] = STATE(488),
    [sym_return_statement] = STATE(488),
    [sym_try_statement] = STATE(488),
    [sym__try_head] = STATE(1956),
    [sym_if_statement] = STATE(488),
    [sym_while_statement] = STATE(488),
    [sym_for_statement] = STATE(488),
    [sym__annotation] = STATE(1287),
    [sym_marker_annotation] = STATE(1289),
    [sym_annotation] = STATE(1289),
    [sym__metadata] = STATE(1382),
    [sym_type_parameters] = STATE(2299),
    [sym_initialized_variable_definition] = STATE(2472),
    [sym__declared_identifier] = STATE(2151),
    [sym__final_const_var_or_type] = STATE(2686),
    [sym__type] = STATE(2047),
    [sym__type_not_function] = STATE(1616),
    [sym__type_not_void_not_function] = STATE(1668),
    [sym_function_type] = STATE(1655),
    [aux_sym__function_type_tails] = STATE(1482),
    [sym__function_type_tail] = STATE(1568),
    [sym__type_name] = STATE(1722),
    [sym__var_or_type] = STATE(2325),
    [sym_inferred_type] = STATE(1653),
    [sym_function_signature] = STATE(1953),
    [sym__formal_parameter_part] = STATE(1915),
    [sym_formal_parameter_list] = STATE(1636),
    [sym__strict_formal_parameter_list] = STATE(1626),
    [sym_local_variable_declaration] = STATE(509),
    [sym__covariant] = STATE(1552),
    [sym__function_builtin_identifier] = STATE(1424),
    [sym__get] = STATE(1992),
    [sym__set] = STATE(1992),
    [sym__new_builtin] = STATE(1701),
    [sym__late_builtin] = STATE(1618),
    [sym_this] = STATE(967),
    [sym_super] = STATE(1128),
    [sym_comment] = STATE(59),
    [sym_documentation_comment] = STATE(59),
    [aux_sym_string_literal_repeat1] = STATE(473),
    [aux_sym__metadata_repeat1] = STATE(1143),
    [sym_identifier] = ACTIONS(15),
    [anon_sym_POUND] = ACTIONS(139),
    [sym_decimal_integer_literal] = ACTIONS(19),
    [sym_hex_integer_literal] = ACTIONS(21),
    [sym_decimal_floating_point_literal] = ACTIONS(19),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(25),
    [anon_sym_DQUOTE] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_r_DQUOTE] = ACTIONS(35),
    [anon_sym_r_SQUOTE] = ACTIONS(37),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(39),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(540),
    [anon_sym_LBRACK] = ACTIONS(45),
    [anon_sym_null] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_LT] = ACTIONS(53),
    [sym_increment_operator] = ACTIONS(55),
    [sym_minus_operator] = ACTIONS(57),
    [sym__exclamation_operator] = ACTIONS(59),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_await] = ACTIONS(542),
    [anon_sym_switch] = ACTIONS(65),
    [anon_sym_do] = ACTIONS(67),
    [anon_sym_while] = ACTIONS(544),
    [anon_sym_continue] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [anon_sym_return] = ACTIONS(75),
    [anon_sym_try] = ACTIONS(77),
    [anon_sym_if] = ACTIONS(546),
    [anon_sym_for] = ACTIONS(548),
    [anon_sym_AT] = ACTIONS(83),
    [anon_sym_super] = ACTIONS(95),
    [sym_void_type] = ACTIONS(97),
    [anon_sym_var] = ACTIONS(99),
    [sym__break_builtin] = ACTIONS(105),
    [sym__assert_builtin] = ACTIONS(107),
    [anon_sym_covariant] = ACTIONS(109),
    [anon_sym_Function] = ACTIONS(113),
    [anon_sym_get] = ACTIONS(115),
    [anon_sym_set] = ACTIONS(121),
    [anon_sym_new] = ACTIONS(125),
    [sym_const_builtin] = ACTIONS(165),
    [sym_final_builtin] = ACTIONS(167),
    [anon_sym_late] = ACTIONS(131),
    [anon_sym_this] = ACTIONS(135),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_SLASH_SLASH_SLASH] = ACTIONS(7),
    [sym__block_comment] = ACTIONS(9),
    [sym__documentation_block_comment] = ACTIONS(11),
  },
  [60] = {
    [sym__literal] = STATE(967),
    [sym_symbol_literal] = STATE(912),
    [sym_true] = STATE(912),
    [sym_false] = STATE(912),
    [sym_string_literal] = STATE(912),
    [sym__string_literal_double_quotes] = STATE(617),
    [sym__string_literal_single_quotes] = STATE(617),
    [sym__string_literal_double_quotes_multiple] = STATE(617),
    [sym__string_literal_single_quotes_multiple] = STATE(617),
    [sym__raw_string_literal_double_quotes] = STATE(617),
    [sym__raw_string_literal_single_quotes] = STATE(617),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(617),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(617),
    [sym_list_literal] = STATE(912),
    [sym_set_or_map_literal] = STATE(912),
    [sym_null_literal] = STATE(912),
    [sym__expression] = STATE(2450),
    [sym__real_expression] = STATE(670),
    [sym_throw_expression] = STATE(976),
    [sym_assignment_expression] = STATE(976),
    [sym_assignable_expression] = STATE(1582),
    [sym_lambda_expression] = STATE(494),
    [sym_function_expression] = STATE(967),
    [sym_if_null_expression] = STATE(1377),
    [sym_conditional_expression] = STATE(1377),
    [sym_logical_or_expression] = STATE(1377),
    [sym_logical_and_expression] = STATE(1377),
    [sym_equality_expression] = STATE(1377),
    [sym_type_cast_expression] = STATE(1377),
    [sym_type_test_expression] = STATE(1377),
    [sym_relational_expression] = STATE(1377),
    [sym_bitwise_or_expression] = STATE(1377),
    [sym_bitwise_xor_expression] = STATE(1377),
    [sym_bitwise_and_expression] = STATE(1377),
    [sym_shift_expression] = STATE(1377),
    [sym_additive_expression] = STATE(1377),
    [sym_multiplicative_expression] = STATE(1377),
    [sym__unary_expression] = STATE(1118),
    [sym_unary_expression] = STATE(1169),
    [sym__postfix_expression] = STATE(1169),
    [sym_postfix_expression] = STATE(1170),
    [sym_prefix_operator] = STATE(360),
    [sym_negation_operator] = STATE(1206),
    [sym_tilde_operator] = STATE(1188),
    [sym_await_expression] = STATE(1171),
    [sym_new_expression] = STATE(967),
    [sym_const_object_expression] = STATE(967),
    [sym__primary] = STATE(641),
    [sym_constructor_invocation] = STATE(638),
    [sym_type_arguments] = STATE(2454),
    [sym__statement] = STATE(506),
    [sym_local_function_declaration] = STATE(491),
    [sym_block] = STATE(488),
    [sym_expression_statement] = STATE(488),
    [sym_assert_statement] = STATE(488),
    [sym_assertion] = STATE(2726),
    [sym_switch_statement] = STATE(488),
    [sym_do_statement] = STATE(488),
    [sym_break_statement] = STATE(488),
    [sym_continue_statement] = STATE(488),
    [sym_yield_statement] = STATE(488),
    [sym_yield_each_statement] = STATE(488),
    [sym_return_statement] = STATE(488),
    [sym_try_statement] = STATE(488),
    [sym__try_head] = STATE(1956),
    [sym_if_statement] = STATE(488),
    [sym_while_statement] = STATE(488),
    [sym_for_statement] = STATE(488),
    [sym__annotation] = STATE(1287),
    [sym_marker_annotation] = STATE(1289),
    [sym_annotation] = STATE(1289),
    [sym__metadata] = STATE(1382),
    [sym_type_parameters] = STATE(2299),
    [sym_initialized_variable_definition] = STATE(2472),
    [sym__declared_identifier] = STATE(2151),
    [sym__final_const_var_or_type] = STATE(2686),
    [sym__type] = STATE(2047),
    [sym__type_not_function] = STATE(1616),
    [sym__type_not_void_not_function] = STATE(1668),
    [sym_function_type] = STATE(1655),
    [aux_sym__function_type_tails] = STATE(1482),
    [sym__function_type_tail] = STATE(1568),
    [sym__type_name] = STATE(1722),
    [sym__var_or_type] = STATE(2325),
    [sym_inferred_type] = STATE(1653),
    [sym_function_signature] = STATE(1953),
    [sym__formal_parameter_part] = STATE(1915),
    [sym_formal_parameter_list] = STATE(1636),
    [sym__strict_formal_parameter_list] = STATE(1626),
    [sym_local_variable_declaration] = STATE(509),
    [sym__covariant] = STATE(1552),
    [sym__function_builtin_identifier] = STATE(1424),
    [sym__get] = STATE(1992),
    [sym__set] = STATE(1992),
    [sym__new_builtin] = STATE(1701),
    [sym__late_builtin] = STATE(1618),
    [sym_this] = STATE(967),
    [sym_super] = STATE(1128),
    [sym_comment] = STATE(60),
    [sym_documentation_comment] = STATE(60),
    [aux_sym_string_literal_repeat1] = STATE(473),
    [aux_sym__metadata_repeat1] = STATE(1143),
    [sym_identifier] = ACTIONS(15),
    [anon_sym_POUND] = ACTIONS(139),
    [sym_decimal_integer_literal] = ACTIONS(19),
    [sym_hex_integer_literal] = ACTIONS(21),
    [sym_decimal_floating_point_literal] = ACTIONS(19),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(25),
    [anon_sym_DQUOTE] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_r_DQUOTE] = ACTIONS(35),
    [anon_sym_r_SQUOTE] = ACTIONS(37),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(39),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(540),
    [anon_sym_LBRACK] = ACTIONS(45),
    [anon_sym_null] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_LT] = ACTIONS(53),
    [sym_increment_operator] = ACTIONS(55),
    [sym_minus_operator] = ACTIONS(57),
    [sym__exclamation_operator] = ACTIONS(59),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_await] = ACTIONS(542),
    [anon_sym_switch] = ACTIONS(65),
    [anon_sym_do] = ACTIONS(67),
    [anon_sym_while] = ACTIONS(544),
    [anon_sym_continue] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [anon_sym_return] = ACTIONS(75),
    [anon_sym_try] = ACTIONS(77),
    [anon_sym_if] = ACTIONS(546),
    [anon_sym_for] = ACTIONS(548),
    [anon_sym_AT] = ACTIONS(83),
    [anon_sym_super] = ACTIONS(95),
    [sym_void_type] = ACTIONS(97),
    [anon_sym_var] = ACTIONS(99),
    [sym__break_builtin] = ACTIONS(105),
    [sym__assert_builtin] = ACTIONS(107),
    [anon_sym_covariant] = ACTIONS(109),
    [anon_sym_Function] = ACTIONS(113),
    [anon_sym_get] = ACTIONS(115),
    [anon_sym_set] = ACTIONS(121),
    [anon_sym_new] = ACTIONS(125),
    [sym_const_builtin] = ACTIONS(165),
    [sym_final_builtin] = ACTIONS(167),
    [anon_sym_late] = ACTIONS(131),
    [anon_sym_this] = ACTIONS(135),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_SLASH_SLASH_SLASH] = ACTIONS(7),
    [sym__block_comment] = ACTIONS(9),
    [sym__documentation_block_comment] = ACTIONS(11),
  },
  [61] = {
    [sym__literal] = STATE(967),
    [sym_symbol_literal] = STATE(912),
    [sym_true] = STATE(912),
    [sym_false] = STATE(912),
    [sym_string_literal] = STATE(912),
    [sym__string_literal_double_quotes] = STATE(617),
    [sym__string_literal_single_quotes] = STATE(617),
    [sym__string_literal_double_quotes_multiple] = STATE(617),
    [sym__string_literal_single_quotes_multiple] = STATE(617),
    [sym__raw_string_literal_double_quotes] = STATE(617),
    [sym__raw_string_literal_single_quotes] = STATE(617),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(617),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(617),
    [sym_list_literal] = STATE(912),
    [sym_set_or_map_literal] = STATE(912),
    [sym_null_literal] = STATE(912),
    [sym__expression] = STATE(2450),
    [sym__real_expression] = STATE(670),
    [sym_throw_expression] = STATE(976),
    [sym_assignment_expression] = STATE(976),
    [sym_assignable_expression] = STATE(1582),
    [sym_lambda_expression] = STATE(494),
    [sym_function_expression] = STATE(967),
    [sym_if_null_expression] = STATE(1377),
    [sym_conditional_expression] = STATE(1377),
    [sym_logical_or_expression] = STATE(1377),
    [sym_logical_and_expression] = STATE(1377),
    [sym_equality_expression] = STATE(1377),
    [sym_type_cast_expression] = STATE(1377),
    [sym_type_test_expression] = STATE(1377),
    [sym_relational_expression] = STATE(1377),
    [sym_bitwise_or_expression] = STATE(1377),
    [sym_bitwise_xor_expression] = STATE(1377),
    [sym_bitwise_and_expression] = STATE(1377),
    [sym_shift_expression] = STATE(1377),
    [sym_additive_expression] = STATE(1377),
    [sym_multiplicative_expression] = STATE(1377),
    [sym__unary_expression] = STATE(1118),
    [sym_unary_expression] = STATE(1169),
    [sym__postfix_expression] = STATE(1169),
    [sym_postfix_expression] = STATE(1170),
    [sym_prefix_operator] = STATE(360),
    [sym_negation_operator] = STATE(1206),
    [sym_tilde_operator] = STATE(1188),
    [sym_await_expression] = STATE(1171),
    [sym_new_expression] = STATE(967),
    [sym_const_object_expression] = STATE(967),
    [sym__primary] = STATE(641),
    [sym_constructor_invocation] = STATE(638),
    [sym_type_arguments] = STATE(2454),
    [sym__statement] = STATE(499),
    [sym_local_function_declaration] = STATE(491),
    [sym_block] = STATE(488),
    [sym_expression_statement] = STATE(488),
    [sym_assert_statement] = STATE(488),
    [sym_assertion] = STATE(2726),
    [sym_switch_statement] = STATE(488),
    [sym_do_statement] = STATE(488),
    [sym_break_statement] = STATE(488),
    [sym_continue_statement] = STATE(488),
    [sym_yield_statement] = STATE(488),
    [sym_yield_each_statement] = STATE(488),
    [sym_return_statement] = STATE(488),
    [sym_try_statement] = STATE(488),
    [sym__try_head] = STATE(1927),
    [sym_if_statement] = STATE(488),
    [sym_while_statement] = STATE(488),
    [sym_for_statement] = STATE(488),
    [sym__annotation] = STATE(1287),
    [sym_marker_annotation] = STATE(1289),
    [sym_annotation] = STATE(1289),
    [sym__metadata] = STATE(1359),
    [sym_type_parameters] = STATE(2299),
    [sym_initialized_variable_definition] = STATE(2472),
    [sym__declared_identifier] = STATE(2151),
    [sym__final_const_var_or_type] = STATE(2686),
    [sym__type] = STATE(2047),
    [sym__type_not_function] = STATE(1616),
    [sym__type_not_void_not_function] = STATE(1668),
    [sym_function_type] = STATE(1655),
    [aux_sym__function_type_tails] = STATE(1482),
    [sym__function_type_tail] = STATE(1568),
    [sym__type_name] = STATE(1722),
    [sym__var_or_type] = STATE(2325),
    [sym_inferred_type] = STATE(1653),
    [sym_function_signature] = STATE(1879),
    [sym__formal_parameter_part] = STATE(1915),
    [sym_formal_parameter_list] = STATE(1636),
    [sym__strict_formal_parameter_list] = STATE(1626),
    [sym_local_variable_declaration] = STATE(509),
    [sym__covariant] = STATE(1552),
    [sym__function_builtin_identifier] = STATE(1424),
    [sym__get] = STATE(1992),
    [sym__set] = STATE(1992),
    [sym__new_builtin] = STATE(1701),
    [sym__late_builtin] = STATE(1618),
    [sym_this] = STATE(967),
    [sym_super] = STATE(1128),
    [sym_comment] = STATE(61),
    [sym_documentation_comment] = STATE(61),
    [aux_sym_string_literal_repeat1] = STATE(473),
    [aux_sym__metadata_repeat1] = STATE(1143),
    [sym_identifier] = ACTIONS(15),
    [anon_sym_POUND] = ACTIONS(139),
    [sym_decimal_integer_literal] = ACTIONS(19),
    [sym_hex_integer_literal] = ACTIONS(21),
    [sym_decimal_floating_point_literal] = ACTIONS(19),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(25),
    [anon_sym_DQUOTE] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_r_DQUOTE] = ACTIONS(35),
    [anon_sym_r_SQUOTE] = ACTIONS(37),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(39),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(177),
    [anon_sym_LBRACK] = ACTIONS(45),
    [anon_sym_null] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_LT] = ACTIONS(53),
    [sym_increment_operator] = ACTIONS(55),
    [sym_minus_operator] = ACTIONS(57),
    [sym__exclamation_operator] = ACTIONS(59),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_await] = ACTIONS(181),
    [anon_sym_switch] = ACTIONS(65),
    [anon_sym_do] = ACTIONS(67),
    [anon_sym_while] = ACTIONS(159),
    [anon_sym_continue] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [anon_sym_return] = ACTIONS(75),
    [anon_sym_try] = ACTIONS(77),
    [anon_sym_if] = ACTIONS(185),
    [anon_sym_for] = ACTIONS(187),
    [anon_sym_AT] = ACTIONS(83),
    [anon_sym_super] = ACTIONS(95),
    [sym_void_type] = ACTIONS(97),
    [anon_sym_var] = ACTIONS(99),
    [sym__break_builtin] = ACTIONS(105),
    [sym__assert_builtin] = ACTIONS(107),
    [anon_sym_covariant] = ACTIONS(109),
    [anon_sym_Function] = ACTIONS(113),
    [anon_sym_get] = ACTIONS(115),
    [anon_sym_set] = ACTIONS(121),
    [anon_sym_new] = ACTIONS(125),
    [sym_const_builtin] = ACTIONS(165),
    [sym_final_builtin] = ACTIONS(167),
    [anon_sym_late] = ACTIONS(131),
    [anon_sym_this] = ACTIONS(135),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_SLASH_SLASH_SLASH] = ACTIONS(7),
    [sym__block_comment] = ACTIONS(9),
    [sym__documentation_block_comment] = ACTIONS(11),
  },
  [62] = {
    [sym__literal] = STATE(967),
    [sym_symbol_literal] = STATE(912),
    [sym_true] = STATE(912),
    [sym_false] = STATE(912),
    [sym_string_literal] = STATE(912),
    [sym__string_literal_double_quotes] = STATE(617),
    [sym__string_literal_single_quotes] = STATE(617),
    [sym__string_literal_double_quotes_multiple] = STATE(617),
    [sym__string_literal_single_quotes_multiple] = STATE(617),
    [sym__raw_string_literal_double_quotes] = STATE(617),
    [sym__raw_string_literal_single_quotes] = STATE(617),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(617),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(617),
    [sym_list_literal] = STATE(912),
    [sym_set_or_map_literal] = STATE(912),
    [sym_null_literal] = STATE(912),
    [sym__expression] = STATE(2450),
    [sym__real_expression] = STATE(670),
    [sym_throw_expression] = STATE(976),
    [sym_assignment_expression] = STATE(976),
    [sym_assignable_expression] = STATE(1582),
    [sym_lambda_expression] = STATE(494),
    [sym_function_expression] = STATE(967),
    [sym_if_null_expression] = STATE(1377),
    [sym_conditional_expression] = STATE(1377),
    [sym_logical_or_expression] = STATE(1377),
    [sym_logical_and_expression] = STATE(1377),
    [sym_equality_expression] = STATE(1377),
    [sym_type_cast_expression] = STATE(1377),
    [sym_type_test_expression] = STATE(1377),
    [sym_relational_expression] = STATE(1377),
    [sym_bitwise_or_expression] = STATE(1377),
    [sym_bitwise_xor_expression] = STATE(1377),
    [sym_bitwise_and_expression] = STATE(1377),
    [sym_shift_expression] = STATE(1377),
    [sym_additive_expression] = STATE(1377),
    [sym_multiplicative_expression] = STATE(1377),
    [sym__unary_expression] = STATE(1118),
    [sym_unary_expression] = STATE(1169),
    [sym__postfix_expression] = STATE(1169),
    [sym_postfix_expression] = STATE(1170),
    [sym_prefix_operator] = STATE(360),
    [sym_negation_operator] = STATE(1206),
    [sym_tilde_operator] = STATE(1188),
    [sym_await_expression] = STATE(1171),
    [sym_new_expression] = STATE(967),
    [sym_const_object_expression] = STATE(967),
    [sym__primary] = STATE(641),
    [sym_constructor_invocation] = STATE(638),
    [sym_type_arguments] = STATE(2454),
    [sym__statement] = STATE(511),
    [sym_local_function_declaration] = STATE(491),
    [sym_block] = STATE(488),
    [sym_expression_statement] = STATE(488),
    [sym_assert_statement] = STATE(488),
    [sym_assertion] = STATE(2726),
    [sym_switch_statement] = STATE(488),
    [sym_do_statement] = STATE(488),
    [sym_break_statement] = STATE(488),
    [sym_continue_statement] = STATE(488),
    [sym_yield_statement] = STATE(488),
    [sym_yield_each_statement] = STATE(488),
    [sym_return_statement] = STATE(488),
    [sym_try_statement] = STATE(488),
    [sym__try_head] = STATE(1927),
    [sym_if_statement] = STATE(488),
    [sym_while_statement] = STATE(488),
    [sym_for_statement] = STATE(488),
    [sym__annotation] = STATE(1287),
    [sym_marker_annotation] = STATE(1289),
    [sym_annotation] = STATE(1289),
    [sym__metadata] = STATE(1359),
    [sym_type_parameters] = STATE(2299),
    [sym_initialized_variable_definition] = STATE(2472),
    [sym__declared_identifier] = STATE(2151),
    [sym__final_const_var_or_type] = STATE(2686),
    [sym__type] = STATE(2047),
    [sym__type_not_function] = STATE(1616),
    [sym__type_not_void_not_function] = STATE(1668),
    [sym_function_type] = STATE(1655),
    [aux_sym__function_type_tails] = STATE(1482),
    [sym__function_type_tail] = STATE(1568),
    [sym__type_name] = STATE(1722),
    [sym__var_or_type] = STATE(2325),
    [sym_inferred_type] = STATE(1653),
    [sym_function_signature] = STATE(1879),
    [sym__formal_parameter_part] = STATE(1915),
    [sym_formal_parameter_list] = STATE(1636),
    [sym__strict_formal_parameter_list] = STATE(1626),
    [sym_local_variable_declaration] = STATE(509),
    [sym__covariant] = STATE(1552),
    [sym__function_builtin_identifier] = STATE(1424),
    [sym__get] = STATE(1992),
    [sym__set] = STATE(1992),
    [sym__new_builtin] = STATE(1701),
    [sym__late_builtin] = STATE(1618),
    [sym_this] = STATE(967),
    [sym_super] = STATE(1128),
    [sym_comment] = STATE(62),
    [sym_documentation_comment] = STATE(62),
    [aux_sym_string_literal_repeat1] = STATE(473),
    [aux_sym__metadata_repeat1] = STATE(1143),
    [sym_identifier] = ACTIONS(15),
    [anon_sym_POUND] = ACTIONS(139),
    [sym_decimal_integer_literal] = ACTIONS(19),
    [sym_hex_integer_literal] = ACTIONS(21),
    [sym_decimal_floating_point_literal] = ACTIONS(19),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(25),
    [anon_sym_DQUOTE] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_r_DQUOTE] = ACTIONS(35),
    [anon_sym_r_SQUOTE] = ACTIONS(37),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(39),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(177),
    [anon_sym_LBRACK] = ACTIONS(45),
    [anon_sym_null] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_LT] = ACTIONS(53),
    [sym_increment_operator] = ACTIONS(55),
    [sym_minus_operator] = ACTIONS(57),
    [sym__exclamation_operator] = ACTIONS(59),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_await] = ACTIONS(181),
    [anon_sym_switch] = ACTIONS(65),
    [anon_sym_do] = ACTIONS(67),
    [anon_sym_while] = ACTIONS(159),
    [anon_sym_continue] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [anon_sym_return] = ACTIONS(75),
    [anon_sym_try] = ACTIONS(77),
    [anon_sym_if] = ACTIONS(185),
    [anon_sym_for] = ACTIONS(187),
    [anon_sym_AT] = ACTIONS(83),
    [anon_sym_super] = ACTIONS(95),
    [sym_void_type] = ACTIONS(97),
    [anon_sym_var] = ACTIONS(99),
    [sym__break_builtin] = ACTIONS(105),
    [sym__assert_builtin] = ACTIONS(107),
    [anon_sym_covariant] = ACTIONS(109),
    [anon_sym_Function] = ACTIONS(113),
    [anon_sym_get] = ACTIONS(115),
    [anon_sym_set] = ACTIONS(121),
    [anon_sym_new] = ACTIONS(125),
    [sym_const_builtin] = ACTIONS(165),
    [sym_final_builtin] = ACTIONS(167),
    [anon_sym_late] = ACTIONS(131),
    [anon_sym_this] = ACTIONS(135),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_SLASH_SLASH_SLASH] = ACTIONS(7),
    [sym__block_comment] = ACTIONS(9),
    [sym__documentation_block_comment] = ACTIONS(11),
  },
  [63] = {
    [sym__literal] = STATE(967),
    [sym_symbol_literal] = STATE(912),
    [sym_true] = STATE(912),
    [sym_false] = STATE(912),
    [sym_string_literal] = STATE(912),
    [sym__string_literal_double_quotes] = STATE(617),
    [sym__string_literal_single_quotes] = STATE(617),
    [sym__string_literal_double_quotes_multiple] = STATE(617),
    [sym__string_literal_single_quotes_multiple] = STATE(617),
    [sym__raw_string_literal_double_quotes] = STATE(617),
    [sym__raw_string_literal_single_quotes] = STATE(617),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(617),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(617),
    [sym_list_literal] = STATE(912),
    [sym_set_or_map_literal] = STATE(912),
    [sym_null_literal] = STATE(912),
    [sym__expression] = STATE(2450),
    [sym__real_expression] = STATE(670),
    [sym_throw_expression] = STATE(976),
    [sym_assignment_expression] = STATE(976),
    [sym_assignable_expression] = STATE(1582),
    [sym_lambda_expression] = STATE(494),
    [sym_function_expression] = STATE(967),
    [sym_if_null_expression] = STATE(1377),
    [sym_conditional_expression] = STATE(1377),
    [sym_logical_or_expression] = STATE(1377),
    [sym_logical_and_expression] = STATE(1377),
    [sym_equality_expression] = STATE(1377),
    [sym_type_cast_expression] = STATE(1377),
    [sym_type_test_expression] = STATE(1377),
    [sym_relational_expression] = STATE(1377),
    [sym_bitwise_or_expression] = STATE(1377),
    [sym_bitwise_xor_expression] = STATE(1377),
    [sym_bitwise_and_expression] = STATE(1377),
    [sym_shift_expression] = STATE(1377),
    [sym_additive_expression] = STATE(1377),
    [sym_multiplicative_expression] = STATE(1377),
    [sym__unary_expression] = STATE(1118),
    [sym_unary_expression] = STATE(1169),
    [sym__postfix_expression] = STATE(1169),
    [sym_postfix_expression] = STATE(1170),
    [sym_prefix_operator] = STATE(360),
    [sym_negation_operator] = STATE(1206),
    [sym_tilde_operator] = STATE(1188),
    [sym_await_expression] = STATE(1171),
    [sym_new_expression] = STATE(967),
    [sym_const_object_expression] = STATE(967),
    [sym__primary] = STATE(641),
    [sym_constructor_invocation] = STATE(638),
    [sym_type_arguments] = STATE(2454),
    [sym__statement] = STATE(2431),
    [sym_local_function_declaration] = STATE(491),
    [sym_block] = STATE(488),
    [sym_expression_statement] = STATE(488),
    [sym_assert_statement] = STATE(488),
    [sym_assertion] = STATE(2726),
    [sym_switch_statement] = STATE(488),
    [sym_do_statement] = STATE(488),
    [sym_break_statement] = STATE(488),
    [sym_continue_statement] = STATE(488),
    [sym_yield_statement] = STATE(488),
    [sym_yield_each_statement] = STATE(488),
    [sym_return_statement] = STATE(488),
    [sym_try_statement] = STATE(488),
    [sym__try_head] = STATE(1956),
    [sym_if_statement] = STATE(488),
    [sym_while_statement] = STATE(488),
    [sym_for_statement] = STATE(488),
    [sym__annotation] = STATE(1287),
    [sym_marker_annotation] = STATE(1289),
    [sym_annotation] = STATE(1289),
    [sym__metadata] = STATE(1382),
    [sym_type_parameters] = STATE(2299),
    [sym_initialized_variable_definition] = STATE(2472),
    [sym__declared_identifier] = STATE(2151),
    [sym__final_const_var_or_type] = STATE(2686),
    [sym__type] = STATE(2047),
    [sym__type_not_function] = STATE(1616),
    [sym__type_not_void_not_function] = STATE(1668),
    [sym_function_type] = STATE(1655),
    [aux_sym__function_type_tails] = STATE(1482),
    [sym__function_type_tail] = STATE(1568),
    [sym__type_name] = STATE(1722),
    [sym__var_or_type] = STATE(2325),
    [sym_inferred_type] = STATE(1653),
    [sym_function_signature] = STATE(1953),
    [sym__formal_parameter_part] = STATE(1915),
    [sym_formal_parameter_list] = STATE(1636),
    [sym__strict_formal_parameter_list] = STATE(1626),
    [sym_local_variable_declaration] = STATE(509),
    [sym__covariant] = STATE(1552),
    [sym__function_builtin_identifier] = STATE(1424),
    [sym__get] = STATE(1992),
    [sym__set] = STATE(1992),
    [sym__new_builtin] = STATE(1701),
    [sym__late_builtin] = STATE(1618),
    [sym_this] = STATE(967),
    [sym_super] = STATE(1128),
    [sym_comment] = STATE(63),
    [sym_documentation_comment] = STATE(63),
    [aux_sym_string_literal_repeat1] = STATE(473),
    [aux_sym__metadata_repeat1] = STATE(1143),
    [sym_identifier] = ACTIONS(15),
    [anon_sym_POUND] = ACTIONS(139),
    [sym_decimal_integer_literal] = ACTIONS(19),
    [sym_hex_integer_literal] = ACTIONS(21),
    [sym_decimal_floating_point_literal] = ACTIONS(19),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(25),
    [anon_sym_DQUOTE] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_r_DQUOTE] = ACTIONS(35),
    [anon_sym_r_SQUOTE] = ACTIONS(37),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(39),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(540),
    [anon_sym_LBRACK] = ACTIONS(45),
    [anon_sym_null] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_LT] = ACTIONS(53),
    [sym_increment_operator] = ACTIONS(55),
    [sym_minus_operator] = ACTIONS(57),
    [sym__exclamation_operator] = ACTIONS(59),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_await] = ACTIONS(542),
    [anon_sym_switch] = ACTIONS(65),
    [anon_sym_do] = ACTIONS(67),
    [anon_sym_while] = ACTIONS(544),
    [anon_sym_continue] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [anon_sym_return] = ACTIONS(75),
    [anon_sym_try] = ACTIONS(77),
    [anon_sym_if] = ACTIONS(546),
    [anon_sym_for] = ACTIONS(548),
    [anon_sym_AT] = ACTIONS(83),
    [anon_sym_super] = ACTIONS(95),
    [sym_void_type] = ACTIONS(97),
    [anon_sym_var] = ACTIONS(99),
    [sym__break_builtin] = ACTIONS(105),
    [sym__assert_builtin] = ACTIONS(107),
    [anon_sym_covariant] = ACTIONS(109),
    [anon_sym_Function] = ACTIONS(113),
    [anon_sym_get] = ACTIONS(115),
    [anon_sym_set] = ACTIONS(121),
    [anon_sym_new] = ACTIONS(125),
    [sym_const_builtin] = ACTIONS(165),
    [sym_final_builtin] = ACTIONS(167),
    [anon_sym_late] = ACTIONS(131),
    [anon_sym_this] = ACTIONS(135),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_SLASH_SLASH_SLASH] = ACTIONS(7),
    [sym__block_comment] = ACTIONS(9),
    [sym__documentation_block_comment] = ACTIONS(11),
  },
  [64] = {
    [sym__literal] = STATE(967),
    [sym_symbol_literal] = STATE(912),
    [sym_true] = STATE(912),
    [sym_false] = STATE(912),
    [sym_string_literal] = STATE(912),
    [sym__string_literal_double_quotes] = STATE(617),
    [sym__string_literal_single_quotes] = STATE(617),
    [sym__string_literal_double_quotes_multiple] = STATE(617),
    [sym__string_literal_single_quotes_multiple] = STATE(617),
    [sym__raw_string_literal_double_quotes] = STATE(617),
    [sym__raw_string_literal_single_quotes] = STATE(617),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(617),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(617),
    [sym_list_literal] = STATE(912),
    [sym_set_or_map_literal] = STATE(912),
    [sym_null_literal] = STATE(912),
    [sym__expression] = STATE(2450),
    [sym__real_expression] = STATE(670),
    [sym_throw_expression] = STATE(976),
    [sym_assignment_expression] = STATE(976),
    [sym_assignable_expression] = STATE(1582),
    [sym_lambda_expression] = STATE(494),
    [sym_function_expression] = STATE(967),
    [sym_if_null_expression] = STATE(1377),
    [sym_conditional_expression] = STATE(1377),
    [sym_logical_or_expression] = STATE(1377),
    [sym_logical_and_expression] = STATE(1377),
    [sym_equality_expression] = STATE(1377),
    [sym_type_cast_expression] = STATE(1377),
    [sym_type_test_expression] = STATE(1377),
    [sym_relational_expression] = STATE(1377),
    [sym_bitwise_or_expression] = STATE(1377),
    [sym_bitwise_xor_expression] = STATE(1377),
    [sym_bitwise_and_expression] = STATE(1377),
    [sym_shift_expression] = STATE(1377),
    [sym_additive_expression] = STATE(1377),
    [sym_multiplicative_expression] = STATE(1377),
    [sym__unary_expression] = STATE(1118),
    [sym_unary_expression] = STATE(1169),
    [sym__postfix_expression] = STATE(1169),
    [sym_postfix_expression] = STATE(1170),
    [sym_prefix_operator] = STATE(360),
    [sym_negation_operator] = STATE(1206),
    [sym_tilde_operator] = STATE(1188),
    [sym_await_expression] = STATE(1171),
    [sym_new_expression] = STATE(967),
    [sym_const_object_expression] = STATE(967),
    [sym__primary] = STATE(641),
    [sym_constructor_invocation] = STATE(638),
    [sym_type_arguments] = STATE(2454),
    [sym__statement] = STATE(506),
    [sym_local_function_declaration] = STATE(491),
    [sym_block] = STATE(488),
    [sym_expression_statement] = STATE(488),
    [sym_assert_statement] = STATE(488),
    [sym_assertion] = STATE(2726),
    [sym_switch_statement] = STATE(488),
    [sym_do_statement] = STATE(488),
    [sym_break_statement] = STATE(488),
    [sym_continue_statement] = STATE(488),
    [sym_yield_statement] = STATE(488),
    [sym_yield_each_statement] = STATE(488),
    [sym_return_statement] = STATE(488),
    [sym_try_statement] = STATE(488),
    [sym__try_head] = STATE(1927),
    [sym_if_statement] = STATE(488),
    [sym_while_statement] = STATE(488),
    [sym_for_statement] = STATE(488),
    [sym__annotation] = STATE(1287),
    [sym_marker_annotation] = STATE(1289),
    [sym_annotation] = STATE(1289),
    [sym__metadata] = STATE(1359),
    [sym_type_parameters] = STATE(2299),
    [sym_initialized_variable_definition] = STATE(2472),
    [sym__declared_identifier] = STATE(2151),
    [sym__final_const_var_or_type] = STATE(2686),
    [sym__type] = STATE(2047),
    [sym__type_not_function] = STATE(1616),
    [sym__type_not_void_not_function] = STATE(1668),
    [sym_function_type] = STATE(1655),
    [aux_sym__function_type_tails] = STATE(1482),
    [sym__function_type_tail] = STATE(1568),
    [sym__type_name] = STATE(1722),
    [sym__var_or_type] = STATE(2325),
    [sym_inferred_type] = STATE(1653),
    [sym_function_signature] = STATE(1879),
    [sym__formal_parameter_part] = STATE(1915),
    [sym_formal_parameter_list] = STATE(1636),
    [sym__strict_formal_parameter_list] = STATE(1626),
    [sym_local_variable_declaration] = STATE(509),
    [sym__covariant] = STATE(1552),
    [sym__function_builtin_identifier] = STATE(1424),
    [sym__get] = STATE(1992),
    [sym__set] = STATE(1992),
    [sym__new_builtin] = STATE(1701),
    [sym__late_builtin] = STATE(1618),
    [sym_this] = STATE(967),
    [sym_super] = STATE(1128),
    [sym_comment] = STATE(64),
    [sym_documentation_comment] = STATE(64),
    [aux_sym_string_literal_repeat1] = STATE(473),
    [aux_sym__metadata_repeat1] = STATE(1143),
    [sym_identifier] = ACTIONS(15),
    [anon_sym_POUND] = ACTIONS(139),
    [sym_decimal_integer_literal] = ACTIONS(19),
    [sym_hex_integer_literal] = ACTIONS(21),
    [sym_decimal_floating_point_literal] = ACTIONS(19),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(25),
    [anon_sym_DQUOTE] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_r_DQUOTE] = ACTIONS(35),
    [anon_sym_r_SQUOTE] = ACTIONS(37),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(39),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(43),
    [anon_sym_LBRACK] = ACTIONS(45),
    [anon_sym_null] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_LT] = ACTIONS(53),
    [sym_increment_operator] = ACTIONS(55),
    [sym_minus_operator] = ACTIONS(57),
    [sym__exclamation_operator] = ACTIONS(59),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_await] = ACTIONS(63),
    [anon_sym_switch] = ACTIONS(65),
    [anon_sym_do] = ACTIONS(67),
    [anon_sym_while] = ACTIONS(69),
    [anon_sym_continue] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [anon_sym_return] = ACTIONS(75),
    [anon_sym_try] = ACTIONS(77),
    [anon_sym_if] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_AT] = ACTIONS(83),
    [anon_sym_super] = ACTIONS(95),
    [sym_void_type] = ACTIONS(97),
    [anon_sym_var] = ACTIONS(99),
    [sym__break_builtin] = ACTIONS(105),
    [sym__assert_builtin] = ACTIONS(107),
    [anon_sym_covariant] = ACTIONS(109),
    [anon_sym_Function] = ACTIONS(113),
    [anon_sym_get] = ACTIONS(115),
    [anon_sym_set] = ACTIONS(121),
    [anon_sym_new] = ACTIONS(125),
    [sym_const_builtin] = ACTIONS(165),
    [sym_final_builtin] = ACTIONS(167),
    [anon_sym_late] = ACTIONS(131),
    [anon_sym_this] = ACTIONS(135),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_SLASH_SLASH_SLASH] = ACTIONS(7),
    [sym__block_comment] = ACTIONS(9),
    [sym__documentation_block_comment] = ACTIONS(11),
  },
  [65] = {
    [sym__literal] = STATE(967),
    [sym_symbol_literal] = STATE(912),
    [sym_true] = STATE(912),
    [sym_false] = STATE(912),
    [sym_string_literal] = STATE(912),
    [sym__string_literal_double_quotes] = STATE(617),
    [sym__string_literal_single_quotes] = STATE(617),
    [sym__string_literal_double_quotes_multiple] = STATE(617),
    [sym__string_literal_single_quotes_multiple] = STATE(617),
    [sym__raw_string_literal_double_quotes] = STATE(617),
    [sym__raw_string_literal_single_quotes] = STATE(617),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(617),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(617),
    [sym_list_literal] = STATE(912),
    [sym_set_or_map_literal] = STATE(912),
    [sym_null_literal] = STATE(912),
    [sym__expression] = STATE(2450),
    [sym__real_expression] = STATE(670),
    [sym_throw_expression] = STATE(976),
    [sym_assignment_expression] = STATE(976),
    [sym_assignable_expression] = STATE(1582),
    [sym_lambda_expression] = STATE(494),
    [sym_function_expression] = STATE(967),
    [sym_if_null_expression] = STATE(1377),
    [sym_conditional_expression] = STATE(1377),
    [sym_logical_or_expression] = STATE(1377),
    [sym_logical_and_expression] = STATE(1377),
    [sym_equality_expression] = STATE(1377),
    [sym_type_cast_expression] = STATE(1377),
    [sym_type_test_expression] = STATE(1377),
    [sym_relational_expression] = STATE(1377),
    [sym_bitwise_or_expression] = STATE(1377),
    [sym_bitwise_xor_expression] = STATE(1377),
    [sym_bitwise_and_expression] = STATE(1377),
    [sym_shift_expression] = STATE(1377),
    [sym_additive_expression] = STATE(1377),
    [sym_multiplicative_expression] = STATE(1377),
    [sym__unary_expression] = STATE(1118),
    [sym_unary_expression] = STATE(1169),
    [sym__postfix_expression] = STATE(1169),
    [sym_postfix_expression] = STATE(1170),
    [sym_prefix_operator] = STATE(360),
    [sym_negation_operator] = STATE(1206),
    [sym_tilde_operator] = STATE(1188),
    [sym_await_expression] = STATE(1171),
    [sym_new_expression] = STATE(967),
    [sym_const_object_expression] = STATE(967),
    [sym__primary] = STATE(641),
    [sym_constructor_invocation] = STATE(638),
    [sym_type_arguments] = STATE(2454),
    [sym__statement] = STATE(499),
    [sym_local_function_declaration] = STATE(491),
    [sym_block] = STATE(488),
    [sym_expression_statement] = STATE(488),
    [sym_assert_statement] = STATE(488),
    [sym_assertion] = STATE(2726),
    [sym_switch_statement] = STATE(488),
    [sym_do_statement] = STATE(488),
    [sym_break_statement] = STATE(488),
    [sym_continue_statement] = STATE(488),
    [sym_yield_statement] = STATE(488),
    [sym_yield_each_statement] = STATE(488),
    [sym_return_statement] = STATE(488),
    [sym_try_statement] = STATE(488),
    [sym__try_head] = STATE(1956),
    [sym_if_statement] = STATE(488),
    [sym_while_statement] = STATE(488),
    [sym_for_statement] = STATE(488),
    [sym__annotation] = STATE(1287),
    [sym_marker_annotation] = STATE(1289),
    [sym_annotation] = STATE(1289),
    [sym__metadata] = STATE(1382),
    [sym_type_parameters] = STATE(2299),
    [sym_initialized_variable_definition] = STATE(2472),
    [sym__declared_identifier] = STATE(2151),
    [sym__final_const_var_or_type] = STATE(2686),
    [sym__type] = STATE(2047),
    [sym__type_not_function] = STATE(1616),
    [sym__type_not_void_not_function] = STATE(1668),
    [sym_function_type] = STATE(1655),
    [aux_sym__function_type_tails] = STATE(1482),
    [sym__function_type_tail] = STATE(1568),
    [sym__type_name] = STATE(1722),
    [sym__var_or_type] = STATE(2325),
    [sym_inferred_type] = STATE(1653),
    [sym_function_signature] = STATE(1953),
    [sym__formal_parameter_part] = STATE(1915),
    [sym_formal_parameter_list] = STATE(1636),
    [sym__strict_formal_parameter_list] = STATE(1626),
    [sym_local_variable_declaration] = STATE(509),
    [sym__covariant] = STATE(1552),
    [sym__function_builtin_identifier] = STATE(1424),
    [sym__get] = STATE(1992),
    [sym__set] = STATE(1992),
    [sym__new_builtin] = STATE(1701),
    [sym__late_builtin] = STATE(1618),
    [sym_this] = STATE(967),
    [sym_super] = STATE(1128),
    [sym_comment] = STATE(65),
    [sym_documentation_comment] = STATE(65),
    [aux_sym_string_literal_repeat1] = STATE(473),
    [aux_sym__metadata_repeat1] = STATE(1143),
    [sym_identifier] = ACTIONS(15),
    [anon_sym_POUND] = ACTIONS(139),
    [sym_decimal_integer_literal] = ACTIONS(19),
    [sym_hex_integer_literal] = ACTIONS(21),
    [sym_decimal_floating_point_literal] = ACTIONS(19),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(25),
    [anon_sym_DQUOTE] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_r_DQUOTE] = ACTIONS(35),
    [anon_sym_r_SQUOTE] = ACTIONS(37),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(39),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(540),
    [anon_sym_LBRACK] = ACTIONS(45),
    [anon_sym_null] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_LT] = ACTIONS(53),
    [sym_increment_operator] = ACTIONS(55),
    [sym_minus_operator] = ACTIONS(57),
    [sym__exclamation_operator] = ACTIONS(59),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_await] = ACTIONS(542),
    [anon_sym_switch] = ACTIONS(65),
    [anon_sym_do] = ACTIONS(67),
    [anon_sym_while] = ACTIONS(544),
    [anon_sym_continue] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [anon_sym_return] = ACTIONS(75),
    [anon_sym_try] = ACTIONS(77),
    [anon_sym_if] = ACTIONS(546),
    [anon_sym_for] = ACTIONS(548),
    [anon_sym_AT] = ACTIONS(83),
    [anon_sym_super] = ACTIONS(95),
    [sym_void_type] = ACTIONS(97),
    [anon_sym_var] = ACTIONS(99),
    [sym__break_builtin] = ACTIONS(105),
    [sym__assert_builtin] = ACTIONS(107),
    [anon_sym_covariant] = ACTIONS(109),
    [anon_sym_Function] = ACTIONS(113),
    [anon_sym_get] = ACTIONS(115),
    [anon_sym_set] = ACTIONS(121),
    [anon_sym_new] = ACTIONS(125),
    [sym_const_builtin] = ACTIONS(165),
    [sym_final_builtin] = ACTIONS(167),
    [anon_sym_late] = ACTIONS(131),
    [anon_sym_this] = ACTIONS(135),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_SLASH_SLASH_SLASH] = ACTIONS(7),
    [sym__block_comment] = ACTIONS(9),
    [sym__documentation_block_comment] = ACTIONS(11),
  },
  [66] = {
    [sym__literal] = STATE(967),
    [sym_symbol_literal] = STATE(912),
    [sym_true] = STATE(912),
    [sym_false] = STATE(912),
    [sym_string_literal] = STATE(912),
    [sym__string_literal_double_quotes] = STATE(617),
    [sym__string_literal_single_quotes] = STATE(617),
    [sym__string_literal_double_quotes_multiple] = STATE(617),
    [sym__string_literal_single_quotes_multiple] = STATE(617),
    [sym__raw_string_literal_double_quotes] = STATE(617),
    [sym__raw_string_literal_single_quotes] = STATE(617),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(617),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(617),
    [sym_list_literal] = STATE(912),
    [sym_set_or_map_literal] = STATE(912),
    [sym_null_literal] = STATE(912),
    [sym__expression] = STATE(2450),
    [sym__real_expression] = STATE(670),
    [sym_throw_expression] = STATE(976),
    [sym_assignment_expression] = STATE(976),
    [sym_assignable_expression] = STATE(1582),
    [sym_lambda_expression] = STATE(494),
    [sym_function_expression] = STATE(967),
    [sym_if_null_expression] = STATE(1377),
    [sym_conditional_expression] = STATE(1377),
    [sym_logical_or_expression] = STATE(1377),
    [sym_logical_and_expression] = STATE(1377),
    [sym_equality_expression] = STATE(1377),
    [sym_type_cast_expression] = STATE(1377),
    [sym_type_test_expression] = STATE(1377),
    [sym_relational_expression] = STATE(1377),
    [sym_bitwise_or_expression] = STATE(1377),
    [sym_bitwise_xor_expression] = STATE(1377),
    [sym_bitwise_and_expression] = STATE(1377),
    [sym_shift_expression] = STATE(1377),
    [sym_additive_expression] = STATE(1377),
    [sym_multiplicative_expression] = STATE(1377),
    [sym__unary_expression] = STATE(1118),
    [sym_unary_expression] = STATE(1169),
    [sym__postfix_expression] = STATE(1169),
    [sym_postfix_expression] = STATE(1170),
    [sym_prefix_operator] = STATE(360),
    [sym_negation_operator] = STATE(1206),
    [sym_tilde_operator] = STATE(1188),
    [sym_await_expression] = STATE(1171),
    [sym_new_expression] = STATE(967),
    [sym_const_object_expression] = STATE(967),
    [sym__primary] = STATE(641),
    [sym_constructor_invocation] = STATE(638),
    [sym_type_arguments] = STATE(2454),
    [sym__statement] = STATE(551),
    [sym_local_function_declaration] = STATE(491),
    [sym_block] = STATE(488),
    [sym_expression_statement] = STATE(488),
    [sym_assert_statement] = STATE(488),
    [sym_assertion] = STATE(2726),
    [sym_switch_statement] = STATE(488),
    [sym_do_statement] = STATE(488),
    [sym_break_statement] = STATE(488),
    [sym_continue_statement] = STATE(488),
    [sym_yield_statement] = STATE(488),
    [sym_yield_each_statement] = STATE(488),
    [sym_return_statement] = STATE(488),
    [sym_try_statement] = STATE(488),
    [sym__try_head] = STATE(1927),
    [sym_if_statement] = STATE(488),
    [sym_while_statement] = STATE(488),
    [sym_for_statement] = STATE(488),
    [sym__annotation] = STATE(1287),
    [sym_marker_annotation] = STATE(1289),
    [sym_annotation] = STATE(1289),
    [sym__metadata] = STATE(1359),
    [sym_type_parameters] = STATE(2299),
    [sym_initialized_variable_definition] = STATE(2472),
    [sym__declared_identifier] = STATE(2151),
    [sym__final_const_var_or_type] = STATE(2686),
    [sym__type] = STATE(2047),
    [sym__type_not_function] = STATE(1616),
    [sym__type_not_void_not_function] = STATE(1668),
    [sym_function_type] = STATE(1655),
    [aux_sym__function_type_tails] = STATE(1482),
    [sym__function_type_tail] = STATE(1568),
    [sym__type_name] = STATE(1722),
    [sym__var_or_type] = STATE(2325),
    [sym_inferred_type] = STATE(1653),
    [sym_function_signature] = STATE(1879),
    [sym__formal_parameter_part] = STATE(1915),
    [sym_formal_parameter_list] = STATE(1636),
    [sym__strict_formal_parameter_list] = STATE(1626),
    [sym_local_variable_declaration] = STATE(509),
    [sym__covariant] = STATE(1552),
    [sym__function_builtin_identifier] = STATE(1424),
    [sym__get] = STATE(1992),
    [sym__set] = STATE(1992),
    [sym__new_builtin] = STATE(1701),
    [sym__late_builtin] = STATE(1618),
    [sym_this] = STATE(967),
    [sym_super] = STATE(1128),
    [sym_comment] = STATE(66),
    [sym_documentation_comment] = STATE(66),
    [aux_sym_string_literal_repeat1] = STATE(473),
    [aux_sym__metadata_repeat1] = STATE(1143),
    [sym_identifier] = ACTIONS(15),
    [anon_sym_POUND] = ACTIONS(139),
    [sym_decimal_integer_literal] = ACTIONS(19),
    [sym_hex_integer_literal] = ACTIONS(21),
    [sym_decimal_floating_point_literal] = ACTIONS(19),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(25),
    [anon_sym_DQUOTE] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_r_DQUOTE] = ACTIONS(35),
    [anon_sym_r_SQUOTE] = ACTIONS(37),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(39),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(43),
    [anon_sym_LBRACK] = ACTIONS(45),
    [anon_sym_null] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_LT] = ACTIONS(53),
    [sym_increment_operator] = ACTIONS(55),
    [sym_minus_operator] = ACTIONS(57),
    [sym__exclamation_operator] = ACTIONS(59),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_await] = ACTIONS(63),
    [anon_sym_switch] = ACTIONS(65),
    [anon_sym_do] = ACTIONS(67),
    [anon_sym_while] = ACTIONS(69),
    [anon_sym_continue] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [anon_sym_return] = ACTIONS(75),
    [anon_sym_try] = ACTIONS(77),
    [anon_sym_if] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_AT] = ACTIONS(83),
    [anon_sym_super] = ACTIONS(95),
    [sym_void_type] = ACTIONS(97),
    [anon_sym_var] = ACTIONS(99),
    [sym__break_builtin] = ACTIONS(105),
    [sym__assert_builtin] = ACTIONS(107),
    [anon_sym_covariant] = ACTIONS(109),
    [anon_sym_Function] = ACTIONS(113),
    [anon_sym_get] = ACTIONS(115),
    [anon_sym_set] = ACTIONS(121),
    [anon_sym_new] = ACTIONS(125),
    [sym_const_builtin] = ACTIONS(165),
    [sym_final_builtin] = ACTIONS(167),
    [anon_sym_late] = ACTIONS(131),
    [anon_sym_this] = ACTIONS(135),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_SLASH_SLASH_SLASH] = ACTIONS(7),
    [sym__block_comment] = ACTIONS(9),
    [sym__documentation_block_comment] = ACTIONS(11),
  },
  [67] = {
    [sym__literal] = STATE(967),
    [sym_symbol_literal] = STATE(912),
    [sym_true] = STATE(912),
    [sym_false] = STATE(912),
    [sym_string_literal] = STATE(912),
    [sym__string_literal_double_quotes] = STATE(617),
    [sym__string_literal_single_quotes] = STATE(617),
    [sym__string_literal_double_quotes_multiple] = STATE(617),
    [sym__string_literal_single_quotes_multiple] = STATE(617),
    [sym__raw_string_literal_double_quotes] = STATE(617),
    [sym__raw_string_literal_single_quotes] = STATE(617),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(617),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(617),
    [sym_list_literal] = STATE(912),
    [sym_set_or_map_literal] = STATE(912),
    [sym_null_literal] = STATE(912),
    [sym__expression] = STATE(2450),
    [sym__real_expression] = STATE(670),
    [sym_throw_expression] = STATE(976),
    [sym_assignment_expression] = STATE(976),
    [sym_assignable_expression] = STATE(1582),
    [sym_lambda_expression] = STATE(494),
    [sym_function_expression] = STATE(967),
    [sym_if_null_expression] = STATE(1377),
    [sym_conditional_expression] = STATE(1377),
    [sym_logical_or_expression] = STATE(1377),
    [sym_logical_and_expression] = STATE(1377),
    [sym_equality_expression] = STATE(1377),
    [sym_type_cast_expression] = STATE(1377),
    [sym_type_test_expression] = STATE(1377),
    [sym_relational_expression] = STATE(1377),
    [sym_bitwise_or_expression] = STATE(1377),
    [sym_bitwise_xor_expression] = STATE(1377),
    [sym_bitwise_and_expression] = STATE(1377),
    [sym_shift_expression] = STATE(1377),
    [sym_additive_expression] = STATE(1377),
    [sym_multiplicative_expression] = STATE(1377),
    [sym__unary_expression] = STATE(1118),
    [sym_unary_expression] = STATE(1169),
    [sym__postfix_expression] = STATE(1169),
    [sym_postfix_expression] = STATE(1170),
    [sym_prefix_operator] = STATE(360),
    [sym_negation_operator] = STATE(1206),
    [sym_tilde_operator] = STATE(1188),
    [sym_await_expression] = STATE(1171),
    [sym_new_expression] = STATE(967),
    [sym_const_object_expression] = STATE(967),
    [sym__primary] = STATE(641),
    [sym_constructor_invocation] = STATE(638),
    [sym_type_arguments] = STATE(2454),
    [sym__statement] = STATE(511),
    [sym_local_function_declaration] = STATE(491),
    [sym_block] = STATE(488),
    [sym_expression_statement] = STATE(488),
    [sym_assert_statement] = STATE(488),
    [sym_assertion] = STATE(2726),
    [sym_switch_statement] = STATE(488),
    [sym_do_statement] = STATE(488),
    [sym_break_statement] = STATE(488),
    [sym_continue_statement] = STATE(488),
    [sym_yield_statement] = STATE(488),
    [sym_yield_each_statement] = STATE(488),
    [sym_return_statement] = STATE(488),
    [sym_try_statement] = STATE(488),
    [sym__try_head] = STATE(1927),
    [sym_if_statement] = STATE(488),
    [sym_while_statement] = STATE(488),
    [sym_for_statement] = STATE(488),
    [sym__annotation] = STATE(1287),
    [sym_marker_annotation] = STATE(1289),
    [sym_annotation] = STATE(1289),
    [sym__metadata] = STATE(1359),
    [sym_type_parameters] = STATE(2299),
    [sym_initialized_variable_definition] = STATE(2472),
    [sym__declared_identifier] = STATE(2151),
    [sym__final_const_var_or_type] = STATE(2686),
    [sym__type] = STATE(2047),
    [sym__type_not_function] = STATE(1616),
    [sym__type_not_void_not_function] = STATE(1668),
    [sym_function_type] = STATE(1655),
    [aux_sym__function_type_tails] = STATE(1482),
    [sym__function_type_tail] = STATE(1568),
    [sym__type_name] = STATE(1722),
    [sym__var_or_type] = STATE(2325),
    [sym_inferred_type] = STATE(1653),
    [sym_function_signature] = STATE(1879),
    [sym__formal_parameter_part] = STATE(1915),
    [sym_formal_parameter_list] = STATE(1636),
    [sym__strict_formal_parameter_list] = STATE(1626),
    [sym_local_variable_declaration] = STATE(509),
    [sym__covariant] = STATE(1552),
    [sym__function_builtin_identifier] = STATE(1424),
    [sym__get] = STATE(1992),
    [sym__set] = STATE(1992),
    [sym__new_builtin] = STATE(1701),
    [sym__late_builtin] = STATE(1618),
    [sym_this] = STATE(967),
    [sym_super] = STATE(1128),
    [sym_comment] = STATE(67),
    [sym_documentation_comment] = STATE(67),
    [aux_sym_string_literal_repeat1] = STATE(473),
    [aux_sym__metadata_repeat1] = STATE(1143),
    [sym_identifier] = ACTIONS(15),
    [anon_sym_POUND] = ACTIONS(139),
    [sym_decimal_integer_literal] = ACTIONS(19),
    [sym_hex_integer_literal] = ACTIONS(21),
    [sym_decimal_floating_point_literal] = ACTIONS(19),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(25),
    [anon_sym_DQUOTE] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_r_DQUOTE] = ACTIONS(35),
    [anon_sym_r_SQUOTE] = ACTIONS(37),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(39),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(43),
    [anon_sym_LBRACK] = ACTIONS(45),
    [anon_sym_null] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_LT] = ACTIONS(53),
    [sym_increment_operator] = ACTIONS(55),
    [sym_minus_operator] = ACTIONS(57),
    [sym__exclamation_operator] = ACTIONS(59),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_await] = ACTIONS(63),
    [anon_sym_switch] = ACTIONS(65),
    [anon_sym_do] = ACTIONS(67),
    [anon_sym_while] = ACTIONS(69),
    [anon_sym_continue] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [anon_sym_return] = ACTIONS(75),
    [anon_sym_try] = ACTIONS(77),
    [anon_sym_if] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_AT] = ACTIONS(83),
    [anon_sym_super] = ACTIONS(95),
    [sym_void_type] = ACTIONS(97),
    [anon_sym_var] = ACTIONS(99),
    [sym__break_builtin] = ACTIONS(105),
    [sym__assert_builtin] = ACTIONS(107),
    [anon_sym_covariant] = ACTIONS(109),
    [anon_sym_Function] = ACTIONS(113),
    [anon_sym_get] = ACTIONS(115),
    [anon_sym_set] = ACTIONS(121),
    [anon_sym_new] = ACTIONS(125),
    [sym_const_builtin] = ACTIONS(165),
    [sym_final_builtin] = ACTIONS(167),
    [anon_sym_late] = ACTIONS(131),
    [anon_sym_this] = ACTIONS(135),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_SLASH_SLASH_SLASH] = ACTIONS(7),
    [sym__block_comment] = ACTIONS(9),
    [sym__documentation_block_comment] = ACTIONS(11),
  },
  [68] = {
    [sym__literal] = STATE(967),
    [sym_symbol_literal] = STATE(912),
    [sym_true] = STATE(912),
    [sym_false] = STATE(912),
    [sym_string_literal] = STATE(912),
    [sym__string_literal_double_quotes] = STATE(617),
    [sym__string_literal_single_quotes] = STATE(617),
    [sym__string_literal_double_quotes_multiple] = STATE(617),
    [sym__string_literal_single_quotes_multiple] = STATE(617),
    [sym__raw_string_literal_double_quotes] = STATE(617),
    [sym__raw_string_literal_single_quotes] = STATE(617),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(617),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(617),
    [sym_list_literal] = STATE(912),
    [sym_set_or_map_literal] = STATE(912),
    [sym_null_literal] = STATE(912),
    [sym__expression] = STATE(2450),
    [sym__real_expression] = STATE(670),
    [sym_throw_expression] = STATE(976),
    [sym_assignment_expression] = STATE(976),
    [sym_assignable_expression] = STATE(1582),
    [sym_lambda_expression] = STATE(494),
    [sym_function_expression] = STATE(967),
    [sym_if_null_expression] = STATE(1377),
    [sym_conditional_expression] = STATE(1377),
    [sym_logical_or_expression] = STATE(1377),
    [sym_logical_and_expression] = STATE(1377),
    [sym_equality_expression] = STATE(1377),
    [sym_type_cast_expression] = STATE(1377),
    [sym_type_test_expression] = STATE(1377),
    [sym_relational_expression] = STATE(1377),
    [sym_bitwise_or_expression] = STATE(1377),
    [sym_bitwise_xor_expression] = STATE(1377),
    [sym_bitwise_and_expression] = STATE(1377),
    [sym_shift_expression] = STATE(1377),
    [sym_additive_expression] = STATE(1377),
    [sym_multiplicative_expression] = STATE(1377),
    [sym__unary_expression] = STATE(1118),
    [sym_unary_expression] = STATE(1169),
    [sym__postfix_expression] = STATE(1169),
    [sym_postfix_expression] = STATE(1170),
    [sym_prefix_operator] = STATE(360),
    [sym_negation_operator] = STATE(1206),
    [sym_tilde_operator] = STATE(1188),
    [sym_await_expression] = STATE(1171),
    [sym_new_expression] = STATE(967),
    [sym_const_object_expression] = STATE(967),
    [sym__primary] = STATE(641),
    [sym_constructor_invocation] = STATE(638),
    [sym_type_arguments] = STATE(2454),
    [sym__statement] = STATE(517),
    [sym_local_function_declaration] = STATE(491),
    [sym_block] = STATE(488),
    [sym_expression_statement] = STATE(488),
    [sym_assert_statement] = STATE(488),
    [sym_assertion] = STATE(2726),
    [sym_switch_statement] = STATE(488),
    [sym_do_statement] = STATE(488),
    [sym_break_statement] = STATE(488),
    [sym_continue_statement] = STATE(488),
    [sym_yield_statement] = STATE(488),
    [sym_yield_each_statement] = STATE(488),
    [sym_return_statement] = STATE(488),
    [sym_try_statement] = STATE(488),
    [sym__try_head] = STATE(1927),
    [sym_if_statement] = STATE(488),
    [sym_while_statement] = STATE(488),
    [sym_for_statement] = STATE(488),
    [sym__annotation] = STATE(1287),
    [sym_marker_annotation] = STATE(1289),
    [sym_annotation] = STATE(1289),
    [sym__metadata] = STATE(1359),
    [sym_type_parameters] = STATE(2299),
    [sym_initialized_variable_definition] = STATE(2472),
    [sym__declared_identifier] = STATE(2151),
    [sym__final_const_var_or_type] = STATE(2686),
    [sym__type] = STATE(2047),
    [sym__type_not_function] = STATE(1616),
    [sym__type_not_void_not_function] = STATE(1668),
    [sym_function_type] = STATE(1655),
    [aux_sym__function_type_tails] = STATE(1482),
    [sym__function_type_tail] = STATE(1568),
    [sym__type_name] = STATE(1722),
    [sym__var_or_type] = STATE(2325),
    [sym_inferred_type] = STATE(1653),
    [sym_function_signature] = STATE(1879),
    [sym__formal_parameter_part] = STATE(1915),
    [sym_formal_parameter_list] = STATE(1636),
    [sym__strict_formal_parameter_list] = STATE(1626),
    [sym_local_variable_declaration] = STATE(509),
    [sym__covariant] = STATE(1552),
    [sym__function_builtin_identifier] = STATE(1424),
    [sym__get] = STATE(1992),
    [sym__set] = STATE(1992),
    [sym__new_builtin] = STATE(1701),
    [sym__late_builtin] = STATE(1618),
    [sym_this] = STATE(967),
    [sym_super] = STATE(1128),
    [sym_comment] = STATE(68),
    [sym_documentation_comment] = STATE(68),
    [aux_sym_string_literal_repeat1] = STATE(473),
    [aux_sym__metadata_repeat1] = STATE(1143),
    [sym_identifier] = ACTIONS(15),
    [anon_sym_POUND] = ACTIONS(139),
    [sym_decimal_integer_literal] = ACTIONS(19),
    [sym_hex_integer_literal] = ACTIONS(21),
    [sym_decimal_floating_point_literal] = ACTIONS(19),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(25),
    [anon_sym_DQUOTE] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_r_DQUOTE] = ACTIONS(35),
    [anon_sym_r_SQUOTE] = ACTIONS(37),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(39),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(177),
    [anon_sym_LBRACK] = ACTIONS(45),
    [anon_sym_null] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_LT] = ACTIONS(53),
    [sym_increment_operator] = ACTIONS(55),
    [sym_minus_operator] = ACTIONS(57),
    [sym__exclamation_operator] = ACTIONS(59),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_await] = ACTIONS(181),
    [anon_sym_switch] = ACTIONS(65),
    [anon_sym_do] = ACTIONS(67),
    [anon_sym_while] = ACTIONS(159),
    [anon_sym_continue] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [anon_sym_return] = ACTIONS(75),
    [anon_sym_try] = ACTIONS(77),
    [anon_sym_if] = ACTIONS(185),
    [anon_sym_for] = ACTIONS(187),
    [anon_sym_AT] = ACTIONS(83),
    [anon_sym_super] = ACTIONS(95),
    [sym_void_type] = ACTIONS(97),
    [anon_sym_var] = ACTIONS(99),
    [sym__break_builtin] = ACTIONS(105),
    [sym__assert_builtin] = ACTIONS(107),
    [anon_sym_covariant] = ACTIONS(109),
    [anon_sym_Function] = ACTIONS(113),
    [anon_sym_get] = ACTIONS(115),
    [anon_sym_set] = ACTIONS(121),
    [anon_sym_new] = ACTIONS(125),
    [sym_const_builtin] = ACTIONS(165),
    [sym_final_builtin] = ACTIONS(167),
    [anon_sym_late] = ACTIONS(131),
    [anon_sym_this] = ACTIONS(135),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_SLASH_SLASH_SLASH] = ACTIONS(7),
    [sym__block_comment] = ACTIONS(9),
    [sym__documentation_block_comment] = ACTIONS(11),
  },
  [69] = {
    [sym__literal] = STATE(967),
    [sym_symbol_literal] = STATE(912),
    [sym_true] = STATE(912),
    [sym_false] = STATE(912),
    [sym_string_literal] = STATE(912),
    [sym__string_literal_double_quotes] = STATE(617),
    [sym__string_literal_single_quotes] = STATE(617),
    [sym__string_literal_double_quotes_multiple] = STATE(617),
    [sym__string_literal_single_quotes_multiple] = STATE(617),
    [sym__raw_string_literal_double_quotes] = STATE(617),
    [sym__raw_string_literal_single_quotes] = STATE(617),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(617),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(617),
    [sym_list_literal] = STATE(912),
    [sym_set_or_map_literal] = STATE(912),
    [sym_null_literal] = STATE(912),
    [sym__expression] = STATE(2450),
    [sym__real_expression] = STATE(670),
    [sym_throw_expression] = STATE(976),
    [sym_assignment_expression] = STATE(976),
    [sym_assignable_expression] = STATE(1582),
    [sym_lambda_expression] = STATE(494),
    [sym_function_expression] = STATE(967),
    [sym_if_null_expression] = STATE(1377),
    [sym_conditional_expression] = STATE(1377),
    [sym_logical_or_expression] = STATE(1377),
    [sym_logical_and_expression] = STATE(1377),
    [sym_equality_expression] = STATE(1377),
    [sym_type_cast_expression] = STATE(1377),
    [sym_type_test_expression] = STATE(1377),
    [sym_relational_expression] = STATE(1377),
    [sym_bitwise_or_expression] = STATE(1377),
    [sym_bitwise_xor_expression] = STATE(1377),
    [sym_bitwise_and_expression] = STATE(1377),
    [sym_shift_expression] = STATE(1377),
    [sym_additive_expression] = STATE(1377),
    [sym_multiplicative_expression] = STATE(1377),
    [sym__unary_expression] = STATE(1118),
    [sym_unary_expression] = STATE(1169),
    [sym__postfix_expression] = STATE(1169),
    [sym_postfix_expression] = STATE(1170),
    [sym_prefix_operator] = STATE(360),
    [sym_negation_operator] = STATE(1206),
    [sym_tilde_operator] = STATE(1188),
    [sym_await_expression] = STATE(1171),
    [sym_new_expression] = STATE(967),
    [sym_const_object_expression] = STATE(967),
    [sym__primary] = STATE(641),
    [sym_constructor_invocation] = STATE(638),
    [sym_type_arguments] = STATE(2454),
    [sym__statement] = STATE(499),
    [sym_local_function_declaration] = STATE(491),
    [sym_block] = STATE(488),
    [sym_expression_statement] = STATE(488),
    [sym_assert_statement] = STATE(488),
    [sym_assertion] = STATE(2726),
    [sym_switch_statement] = STATE(488),
    [sym_do_statement] = STATE(488),
    [sym_break_statement] = STATE(488),
    [sym_continue_statement] = STATE(488),
    [sym_yield_statement] = STATE(488),
    [sym_yield_each_statement] = STATE(488),
    [sym_return_statement] = STATE(488),
    [sym_try_statement] = STATE(488),
    [sym__try_head] = STATE(1927),
    [sym_if_statement] = STATE(488),
    [sym_while_statement] = STATE(488),
    [sym_for_statement] = STATE(488),
    [sym__annotation] = STATE(1287),
    [sym_marker_annotation] = STATE(1289),
    [sym_annotation] = STATE(1289),
    [sym__metadata] = STATE(1359),
    [sym_type_parameters] = STATE(2299),
    [sym_initialized_variable_definition] = STATE(2472),
    [sym__declared_identifier] = STATE(2151),
    [sym__final_const_var_or_type] = STATE(2686),
    [sym__type] = STATE(2047),
    [sym__type_not_function] = STATE(1616),
    [sym__type_not_void_not_function] = STATE(1668),
    [sym_function_type] = STATE(1655),
    [aux_sym__function_type_tails] = STATE(1482),
    [sym__function_type_tail] = STATE(1568),
    [sym__type_name] = STATE(1722),
    [sym__var_or_type] = STATE(2325),
    [sym_inferred_type] = STATE(1653),
    [sym_function_signature] = STATE(1879),
    [sym__formal_parameter_part] = STATE(1915),
    [sym_formal_parameter_list] = STATE(1636),
    [sym__strict_formal_parameter_list] = STATE(1626),
    [sym_local_variable_declaration] = STATE(509),
    [sym__covariant] = STATE(1552),
    [sym__function_builtin_identifier] = STATE(1424),
    [sym__get] = STATE(1992),
    [sym__set] = STATE(1992),
    [sym__new_builtin] = STATE(1701),
    [sym__late_builtin] = STATE(1618),
    [sym_this] = STATE(967),
    [sym_super] = STATE(1128),
    [sym_comment] = STATE(69),
    [sym_documentation_comment] = STATE(69),
    [aux_sym_string_literal_repeat1] = STATE(473),
    [aux_sym__metadata_repeat1] = STATE(1143),
    [sym_identifier] = ACTIONS(15),
    [anon_sym_POUND] = ACTIONS(139),
    [sym_decimal_integer_literal] = ACTIONS(19),
    [sym_hex_integer_literal] = ACTIONS(21),
    [sym_decimal_floating_point_literal] = ACTIONS(19),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(25),
    [anon_sym_DQUOTE] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_r_DQUOTE] = ACTIONS(35),
    [anon_sym_r_SQUOTE] = ACTIONS(37),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(39),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(43),
    [anon_sym_LBRACK] = ACTIONS(45),
    [anon_sym_null] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_LT] = ACTIONS(53),
    [sym_increment_operator] = ACTIONS(55),
    [sym_minus_operator] = ACTIONS(57),
    [sym__exclamation_operator] = ACTIONS(59),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_await] = ACTIONS(63),
    [anon_sym_switch] = ACTIONS(65),
    [anon_sym_do] = ACTIONS(67),
    [anon_sym_while] = ACTIONS(69),
    [anon_sym_continue] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [anon_sym_return] = ACTIONS(75),
    [anon_sym_try] = ACTIONS(77),
    [anon_sym_if] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_AT] = ACTIONS(83),
    [anon_sym_super] = ACTIONS(95),
    [sym_void_type] = ACTIONS(97),
    [anon_sym_var] = ACTIONS(99),
    [sym__break_builtin] = ACTIONS(105),
    [sym__assert_builtin] = ACTIONS(107),
    [anon_sym_covariant] = ACTIONS(109),
    [anon_sym_Function] = ACTIONS(113),
    [anon_sym_get] = ACTIONS(115),
    [anon_sym_set] = ACTIONS(121),
    [anon_sym_new] = ACTIONS(125),
    [sym_const_builtin] = ACTIONS(165),
    [sym_final_builtin] = ACTIONS(167),
    [anon_sym_late] = ACTIONS(131),
    [anon_sym_this] = ACTIONS(135),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_SLASH_SLASH_SLASH] = ACTIONS(7),
    [sym__block_comment] = ACTIONS(9),
    [sym__documentation_block_comment] = ACTIONS(11),
  },
  [70] = {
    [sym__literal] = STATE(967),
    [sym_symbol_literal] = STATE(912),
    [sym_true] = STATE(912),
    [sym_false] = STATE(912),
    [sym_string_literal] = STATE(912),
    [sym__string_literal_double_quotes] = STATE(617),
    [sym__string_literal_single_quotes] = STATE(617),
    [sym__string_literal_double_quotes_multiple] = STATE(617),
    [sym__string_literal_single_quotes_multiple] = STATE(617),
    [sym__raw_string_literal_double_quotes] = STATE(617),
    [sym__raw_string_literal_single_quotes] = STATE(617),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(617),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(617),
    [sym_list_literal] = STATE(912),
    [sym_set_or_map_literal] = STATE(912),
    [sym_null_literal] = STATE(912),
    [sym__expression] = STATE(2450),
    [sym__real_expression] = STATE(670),
    [sym_throw_expression] = STATE(976),
    [sym_assignment_expression] = STATE(976),
    [sym_assignable_expression] = STATE(1582),
    [sym_lambda_expression] = STATE(494),
    [sym_function_expression] = STATE(967),
    [sym_if_null_expression] = STATE(1377),
    [sym_conditional_expression] = STATE(1377),
    [sym_logical_or_expression] = STATE(1377),
    [sym_logical_and_expression] = STATE(1377),
    [sym_equality_expression] = STATE(1377),
    [sym_type_cast_expression] = STATE(1377),
    [sym_type_test_expression] = STATE(1377),
    [sym_relational_expression] = STATE(1377),
    [sym_bitwise_or_expression] = STATE(1377),
    [sym_bitwise_xor_expression] = STATE(1377),
    [sym_bitwise_and_expression] = STATE(1377),
    [sym_shift_expression] = STATE(1377),
    [sym_additive_expression] = STATE(1377),
    [sym_multiplicative_expression] = STATE(1377),
    [sym__unary_expression] = STATE(1118),
    [sym_unary_expression] = STATE(1169),
    [sym__postfix_expression] = STATE(1169),
    [sym_postfix_expression] = STATE(1170),
    [sym_prefix_operator] = STATE(360),
    [sym_negation_operator] = STATE(1206),
    [sym_tilde_operator] = STATE(1188),
    [sym_await_expression] = STATE(1171),
    [sym_new_expression] = STATE(967),
    [sym_const_object_expression] = STATE(967),
    [sym__primary] = STATE(641),
    [sym_constructor_invocation] = STATE(638),
    [sym_type_arguments] = STATE(2454),
    [sym__statement] = STATE(490),
    [sym_local_function_declaration] = STATE(491),
    [sym_block] = STATE(488),
    [sym_expression_statement] = STATE(488),
    [sym_assert_statement] = STATE(488),
    [sym_assertion] = STATE(2726),
    [sym_switch_statement] = STATE(488),
    [sym_do_statement] = STATE(488),
    [sym_break_statement] = STATE(488),
    [sym_continue_statement] = STATE(488),
    [sym_yield_statement] = STATE(488),
    [sym_yield_each_statement] = STATE(488),
    [sym_return_statement] = STATE(488),
    [sym_try_statement] = STATE(488),
    [sym__try_head] = STATE(1927),
    [sym_if_statement] = STATE(488),
    [sym_while_statement] = STATE(488),
    [sym_for_statement] = STATE(488),
    [sym__annotation] = STATE(1287),
    [sym_marker_annotation] = STATE(1289),
    [sym_annotation] = STATE(1289),
    [sym__metadata] = STATE(1359),
    [sym_type_parameters] = STATE(2299),
    [sym_initialized_variable_definition] = STATE(2472),
    [sym__declared_identifier] = STATE(2151),
    [sym__final_const_var_or_type] = STATE(2686),
    [sym__type] = STATE(2047),
    [sym__type_not_function] = STATE(1616),
    [sym__type_not_void_not_function] = STATE(1668),
    [sym_function_type] = STATE(1655),
    [aux_sym__function_type_tails] = STATE(1482),
    [sym__function_type_tail] = STATE(1568),
    [sym__type_name] = STATE(1722),
    [sym__var_or_type] = STATE(2325),
    [sym_inferred_type] = STATE(1653),
    [sym_function_signature] = STATE(1879),
    [sym__formal_parameter_part] = STATE(1915),
    [sym_formal_parameter_list] = STATE(1636),
    [sym__strict_formal_parameter_list] = STATE(1626),
    [sym_local_variable_declaration] = STATE(509),
    [sym__covariant] = STATE(1552),
    [sym__function_builtin_identifier] = STATE(1424),
    [sym__get] = STATE(1992),
    [sym__set] = STATE(1992),
    [sym__new_builtin] = STATE(1701),
    [sym__late_builtin] = STATE(1618),
    [sym_this] = STATE(967),
    [sym_super] = STATE(1128),
    [sym_comment] = STATE(70),
    [sym_documentation_comment] = STATE(70),
    [aux_sym_string_literal_repeat1] = STATE(473),
    [aux_sym__metadata_repeat1] = STATE(1143),
    [sym_identifier] = ACTIONS(15),
    [anon_sym_POUND] = ACTIONS(139),
    [sym_decimal_integer_literal] = ACTIONS(19),
    [sym_hex_integer_literal] = ACTIONS(21),
    [sym_decimal_floating_point_literal] = ACTIONS(19),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(25),
    [anon_sym_DQUOTE] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_r_DQUOTE] = ACTIONS(35),
    [anon_sym_r_SQUOTE] = ACTIONS(37),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(39),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(177),
    [anon_sym_LBRACK] = ACTIONS(45),
    [anon_sym_null] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_LT] = ACTIONS(53),
    [sym_increment_operator] = ACTIONS(55),
    [sym_minus_operator] = ACTIONS(57),
    [sym__exclamation_operator] = ACTIONS(59),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_await] = ACTIONS(181),
    [anon_sym_switch] = ACTIONS(65),
    [anon_sym_do] = ACTIONS(67),
    [anon_sym_while] = ACTIONS(159),
    [anon_sym_continue] = ACTIONS(71),
    [anon_sym_yield] = ACTIONS(73),
    [anon_sym_return] = ACTIONS(75),
    [anon_sym_try] = ACTIONS(77),
    [anon_sym_if] = ACTIONS(185),
    [anon_sym_for] = ACTIONS(187),
    [anon_sym_AT] = ACTIONS(83),
    [anon_sym_super] = ACTIONS(95),
    [sym_void_type] = ACTIONS(97),
    [anon_sym_var] = ACTIONS(99),
    [sym__break_builtin] = ACTIONS(105),
    [sym__assert_builtin] = ACTIONS(107),
    [anon_sym_covariant] = ACTIONS(109),
    [anon_sym_Function] = ACTIONS(113),
    [anon_sym_get] = ACTIONS(115),
    [anon_sym_set] = ACTIONS(121),
    [anon_sym_new] = ACTIONS(125),
    [sym_const_builtin] = ACTIONS(165),
    [sym_final_builtin] = ACTIONS(167),
    [anon_sym_late] = ACTIONS(131),
    [anon_sym_this] = ACTIONS(135),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_SLASH_SLASH_SLASH] = ACTIONS(7),
    [sym__block_comment] = ACTIONS(9),
    [sym__documentation_block_comment] = ACTIONS(11),
  },
  [71] = {
    [sym__literal] = STATE(967),
    [sym_symbol_literal] = STATE(912),
    [sym_true] = STATE(912),
    [sym_false] = STATE(912),
    [sym_string_literal] = STATE(912),
    [sym__string_literal_double_quotes] = STATE(617),
    [sym__string_literal_single_quotes] = STATE(617),
    [sym__string_literal_double_quotes_multiple] = STATE(617),
    [sym__string_literal_single_quotes_multiple] = STATE(617),
    [sym__raw_string_literal_double_quotes] = STATE(617),
    [sym__raw_string_literal_single_quotes] = STATE(617),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(617),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(617),
    [sym_list_literal] = STATE(912),
    [sym_set_or_map_literal] = STATE(912),
    [sym_pair] = STATE(2134),
    [sym__element] = STATE(2188),
    [sym_null_literal] = STATE(912),
    [sym__expression] = STATE(2077),
    [sym__real_expression] = STATE(670),
    [sym_throw_expression] = STATE(976),
    [sym_assignment_expression] = STATE(976),
    [sym_assignable_expression] = STATE(1582),
    [sym_function_expression] = STATE(967),
    [sym_if_null_expression] = STATE(1377),
    [sym_conditional_expression] = STATE(1377),
    [sym_logical_or_expression] = STATE(1377),
    [sym_logical_and_expression] = STATE(1377),
    [sym_equality_expression] = STATE(1377),
    [sym_type_cast_expression] = STATE(1377),
    [sym_type_test_expression] = STATE(1377),
    [sym_relational_expression] = STATE(1377),
    [sym_bitwise_or_expression] = STATE(1377),
    [sym_bitwise_xor_expression] = STATE(1377),
    [sym_bitwise_and_expression] = STATE(1377),
    [sym_shift_expression] = STATE(1377),
    [sym_additive_expression] = STATE(1377),
    [sym_multiplicative_expression] = STATE(1377),
    [sym__unary_expression] = STATE(1118),
    [sym_unary_expression] = STATE(1169),
    [sym__postfix_expression] = STATE(1169),
    [sym_postfix_expression] = STATE(1170),
    [sym_spread_element] = STATE(2134),
    [sym_prefix_operator] = STATE(360),
    [sym_negation_operator] = STATE(1206),
    [sym_tilde_operator] = STATE(1188),
    [sym_await_expression] = STATE(1171),
    [sym_new_expression] = STATE(967),
    [sym_const_object_expression] = STATE(967),
    [sym__primary] = STATE(641),
    [sym_constructor_invocation] = STATE(638),
    [sym_type_arguments] = STATE(2454),
    [sym_if_element] = STATE(2134),
    [sym_for_element] = STATE(2134),
    [sym__annotation] = STATE(1287),
    [sym_marker_annotation] = STATE(1289),
    [sym_annotation] = STATE(1289),
    [sym__metadata] = STATE(986),
    [sym_type_parameters] = STATE(2299),
    [sym__declared_identifier] = STATE(2007),
    [sym__final_const_var_or_type] = STATE(2066),
    [sym__type] = STATE(2269),
    [sym__type_not_function] = STATE(1616),
    [sym__type_not_void_not_function] = STATE(1668),
    [sym_function_type] = STATE(1655),
    [aux_sym__function_type_tails] = STATE(1482),
    [sym__function_type_tail] = STATE(1568),
    [sym__type_name] = STATE(1722),
    [sym__var_or_type] = STATE(2325),
    [sym_inferred_type] = STATE(1653),
    [sym__formal_parameter_part] = STATE(1915),
    [sym_formal_parameter_list] = STATE(1636),
    [sym__strict_formal_parameter_list] = STATE(1626),
    [sym_formal_parameter] = STATE(2120),
    [sym__default_named_parameter] = STATE(2198),
    [sym__normal_formal_parameter] = STATE(2008),
    [sym__function_formal_parameter] = STATE(2011),
    [sym__simple_formal_parameter] = STATE(2013),
    [sym_super_formal_parameter] = STATE(2011),
    [sym_constructor_param] = STATE(2011),
    [sym__covariant] = STATE(1547),
    [sym__function_builtin_identifier] = STATE(1424),
    [sym__required] = STATE(789),
    [sym__new_builtin] = STATE(1701),
    [sym__late_builtin] = STATE(1618),
    [sym_this] = STATE(1113),
    [sym_super] = STATE(1125),
    [sym_comment] = STATE(71),
    [sym_documentation_comment] = STATE(71),
    [aux_sym_string_literal_repeat1] = STATE(473),
    [aux_sym__metadata_repeat1] = STATE(1143),
    [sym_identifier] = ACTIONS(550),
    [anon_sym_POUND] = ACTIONS(139),
    [sym_decimal_integer_literal] = ACTIONS(19),
    [sym_hex_integer_literal] = ACTIONS(21),
    [sym_decimal_floating_point_literal] = ACTIONS(19),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(25),
    [anon_sym_DQUOTE] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_r_DQUOTE] = ACTIONS(35),
    [anon_sym_r_SQUOTE] = ACTIONS(37),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(39),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(552),
    [anon_sym_RBRACE] = ACTIONS(554),
    [anon_sym_LBRACK] = ACTIONS(45),
    [anon_sym_null] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_LT] = ACTIONS(53),
    [sym_increment_operator] = ACTIONS(55),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(155),
    [sym_minus_operator] = ACTIONS(57),
    [sym__exclamation_operator] = ACTIONS(59),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_await] = ACTIONS(556),
    [anon_sym_if] = ACTIONS(558),
    [anon_sym_for] = ACTIONS(560),
    [anon_sym_AT] = ACTIONS(83),
    [anon_sym_super] = ACTIONS(95),
    [sym_void_type] = ACTIONS(97),
    [anon_sym_var] = ACTIONS(99),
    [anon_sym_covariant] = ACTIONS(109),
    [anon_sym_Function] = ACTIONS(113),
    [anon_sym_required] = ACTIONS(562),
    [anon_sym_new] = ACTIONS(125),
    [sym_const_builtin] = ACTIONS(165),
    [sym_final_builtin] = ACTIONS(167),
    [anon_sym_late] = ACTIONS(131),
    [anon_sym_this] = ACTIONS(135),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_SLASH_SLASH_SLASH] = ACTIONS(7),
    [sym__block_comment] = ACTIONS(9),
    [sym__documentation_block_comment] = ACTIONS(11),
  },
  [72] = {
    [sym__literal] = STATE(967),
    [sym_symbol_literal] = STATE(912),
    [sym_true] = STATE(912),
    [sym_false] = STATE(912),
    [sym_string_literal] = STATE(912),
    [sym__string_literal_double_quotes] = STATE(617),
    [sym__string_literal_single_quotes] = STATE(617),
    [sym__string_literal_double_quotes_multiple] = STATE(617),
    [sym__string_literal_single_quotes_multiple] = STATE(617),
    [sym__raw_string_literal_double_quotes] = STATE(617),
    [sym__raw_string_literal_single_quotes] = STATE(617),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(617),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(617),
    [sym_list_literal] = STATE(912),
    [sym_set_or_map_literal] = STATE(912),
    [sym_pair] = STATE(2134),
    [sym__element] = STATE(2210),
    [sym_null_literal] = STATE(912),
    [sym__expression] = STATE(2077),
    [sym__real_expression] = STATE(670),
    [sym_throw_expression] = STATE(976),
    [sym_assignment_expression] = STATE(976),
    [sym_assignable_expression] = STATE(1582),
    [sym_function_expression] = STATE(967),
    [sym_if_null_expression] = STATE(1377),
    [sym_conditional_expression] = STATE(1377),
    [sym_logical_or_expression] = STATE(1377),
    [sym_logical_and_expression] = STATE(1377),
    [sym_equality_expression] = STATE(1377),
    [sym_type_cast_expression] = STATE(1377),
    [sym_type_test_expression] = STATE(1377),
    [sym_relational_expression] = STATE(1377),
    [sym_bitwise_or_expression] = STATE(1377),
    [sym_bitwise_xor_expression] = STATE(1377),
    [sym_bitwise_and_expression] = STATE(1377),
    [sym_shift_expression] = STATE(1377),
    [sym_additive_expression] = STATE(1377),
    [sym_multiplicative_expression] = STATE(1377),
    [sym__unary_expression] = STATE(1118),
    [sym_unary_expression] = STATE(1169),
    [sym__postfix_expression] = STATE(1169),
    [sym_postfix_expression] = STATE(1170),
    [sym_spread_element] = STATE(2134),
    [sym_prefix_operator] = STATE(360),
    [sym_negation_operator] = STATE(1206),
    [sym_tilde_operator] = STATE(1188),
    [sym_await_expression] = STATE(1171),
    [sym_new_expression] = STATE(967),
    [sym_const_object_expression] = STATE(967),
    [sym__primary] = STATE(641),
    [sym_constructor_invocation] = STATE(638),
    [sym_type_arguments] = STATE(2454),
    [sym_if_element] = STATE(2134),
    [sym_for_element] = STATE(2134),
    [sym__annotation] = STATE(1287),
    [sym_marker_annotation] = STATE(1289),
    [sym_annotation] = STATE(1289),
    [sym__metadata] = STATE(986),
    [sym_type_parameters] = STATE(2299),
    [sym__declared_identifier] = STATE(2007),
    [sym__final_const_var_or_type] = STATE(2066),
    [sym__type] = STATE(2269),
    [sym__type_not_function] = STATE(1616),
    [sym__type_not_void_not_function] = STATE(1668),
    [sym_function_type] = STATE(1655),
    [aux_sym__function_type_tails] = STATE(1482),
    [sym__function_type_tail] = STATE(1568),
    [sym__type_name] = STATE(1722),
    [sym__var_or_type] = STATE(2325),
    [sym_inferred_type] = STATE(1653),
    [sym__formal_parameter_part] = STATE(1915),
    [sym_formal_parameter_list] = STATE(1636),
    [sym__strict_formal_parameter_list] = STATE(1626),
    [sym_formal_parameter] = STATE(2199),
    [sym__default_formal_parameter] = STATE(2203),
    [sym__normal_formal_parameter] = STATE(2008),
    [sym__function_formal_parameter] = STATE(2011),
    [sym__simple_formal_parameter] = STATE(2013),
    [sym_super_formal_parameter] = STATE(2011),
    [sym_constructor_param] = STATE(2011),
    [sym__covariant] = STATE(1547),
    [sym__function_builtin_identifier] = STATE(1424),
    [sym__new_builtin] = STATE(1701),
    [sym__late_builtin] = STATE(1618),
    [sym_this] = STATE(1113),
    [sym_super] = STATE(1134),
    [sym_comment] = STATE(72),
    [sym_documentation_comment] = STATE(72),
    [aux_sym_string_literal_repeat1] = STATE(473),
    [aux_sym__metadata_repeat1] = STATE(1143),
    [sym_identifier] = ACTIONS(564),
    [anon_sym_POUND] = ACTIONS(139),
    [sym_decimal_integer_literal] = ACTIONS(19),
    [sym_hex_integer_literal] = ACTIONS(21),
    [sym_decimal_floating_point_literal] = ACTIONS(19),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(25),
    [anon_sym_DQUOTE] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_r_DQUOTE] = ACTIONS(35),
    [anon_sym_r_SQUOTE] = ACTIONS(37),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(39),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(552),
    [anon_sym_LBRACK] = ACTIONS(45),
    [anon_sym_RBRACK] = ACTIONS(566),
    [anon_sym_null] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_LT] = ACTIONS(53),
    [sym_increment_operator] = ACTIONS(55),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(155),
    [sym_minus_operator] = ACTIONS(57),
    [sym__exclamation_operator] = ACTIONS(59),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_await] = ACTIONS(556),
    [anon_sym_if] = ACTIONS(558),
    [anon_sym_for] = ACTIONS(560),
    [anon_sym_AT] = ACTIONS(83),
    [anon_sym_super] = ACTIONS(95),
    [sym_void_type] = ACTIONS(97),
    [anon_sym_var] = ACTIONS(99),
    [anon_sym_covariant] = ACTIONS(109),
    [anon_sym_Function] = ACTIONS(113),
    [anon_sym_new] = ACTIONS(125),
    [sym_const_builtin] = ACTIONS(165),
    [sym_final_builtin] = ACTIONS(167),
    [anon_sym_late] = ACTIONS(131),
    [anon_sym_this] = ACTIONS(135),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_SLASH_SLASH_SLASH] = ACTIONS(7),
    [sym__block_comment] = ACTIONS(9),
    [sym__documentation_block_comment] = ACTIONS(11),
  },
  [73] = {
    [sym__literal] = STATE(967),
    [sym_symbol_literal] = STATE(912),
    [sym_true] = STATE(912),
    [sym_false] = STATE(912),
    [sym_string_literal] = STATE(912),
    [sym__string_literal_double_quotes] = STATE(617),
    [sym__string_literal_single_quotes] = STATE(617),
    [sym__string_literal_double_quotes_multiple] = STATE(617),
    [sym__string_literal_single_quotes_multiple] = STATE(617),
    [sym__raw_string_literal_double_quotes] = STATE(617),
    [sym__raw_string_literal_single_quotes] = STATE(617),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(617),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(617),
    [sym_list_literal] = STATE(912),
    [sym_set_or_map_literal] = STATE(912),
    [sym_null_literal] = STATE(912),
    [sym__expression] = STATE(2700),
    [sym__real_expression] = STATE(670),
    [sym_throw_expression] = STATE(976),
    [sym_assignment_expression] = STATE(976),
    [sym_assignable_expression] = STATE(1582),
    [sym_function_expression] = STATE(967),
    [sym_if_null_expression] = STATE(1377),
    [sym_conditional_expression] = STATE(1377),
    [sym_logical_or_expression] = STATE(1377),
    [sym_logical_and_expression] = STATE(1377),
    [sym_equality_expression] = STATE(1377),
    [sym_type_cast_expression] = STATE(1377),
    [sym_type_test_expression] = STATE(1377),
    [sym_relational_expression] = STATE(1377),
    [sym_bitwise_or_expression] = STATE(1377),
    [sym_bitwise_xor_expression] = STATE(1377),
    [sym_bitwise_and_expression] = STATE(1377),
    [sym_shift_expression] = STATE(1377),
    [sym_additive_expression] = STATE(1377),
    [sym_multiplicative_expression] = STATE(1377),
    [sym__unary_expression] = STATE(1118),
    [sym_unary_expression] = STATE(1169),
    [sym__postfix_expression] = STATE(1169),
    [sym_postfix_expression] = STATE(1170),
    [sym_prefix_operator] = STATE(360),
    [sym_negation_operator] = STATE(1206),
    [sym_tilde_operator] = STATE(1188),
    [sym_await_expression] = STATE(1171),
    [sym_new_expression] = STATE(967),
    [sym_const_object_expression] = STATE(967),
    [sym__primary] = STATE(641),
    [sym_constructor_invocation] = STATE(638),
    [sym_type_arguments] = STATE(2454),
    [sym__annotation] = STATE(1287),
    [sym_marker_annotation] = STATE(1289),
    [sym_annotation] = STATE(1289),
    [sym__metadata] = STATE(986),
    [sym_type_parameters] = STATE(2299),
    [sym__declared_identifier] = STATE(2007),
    [sym__final_const_var_or_type] = STATE(2066),
    [sym__type] = STATE(2269),
    [sym__type_not_function] = STATE(1616),
    [sym__type_not_void_not_function] = STATE(1668),
    [sym_function_type] = STATE(1655),
    [aux_sym__function_type_tails] = STATE(1482),
    [sym__function_type_tail] = STATE(1568),
    [sym__type_name] = STATE(1722),
    [sym__var_or_type] = STATE(2325),
    [sym_inferred_type] = STATE(1653),
    [sym__formal_parameter_part] = STATE(1915),
    [sym_formal_parameter_list] = STATE(1636),
    [sym__strict_formal_parameter_list] = STATE(1626),
    [sym__normal_formal_parameters] = STATE(2437),
    [sym_optional_formal_parameters] = STATE(2749),
    [sym__optional_postional_formal_parameters] = STATE(2750),
    [sym__named_formal_parameters] = STATE(2750),
    [sym_formal_parameter] = STATE(2271),
    [sym__normal_formal_parameter] = STATE(2008),
    [sym__function_formal_parameter] = STATE(2011),
    [sym__simple_formal_parameter] = STATE(2013),
    [sym_super_formal_parameter] = STATE(2011),
    [sym_constructor_param] = STATE(2011),
    [sym__covariant] = STATE(1547),
    [sym__function_builtin_identifier] = STATE(1424),
    [sym__new_builtin] = STATE(1701),
    [sym__late_builtin] = STATE(1618),
    [sym_this] = STATE(1113),
    [sym_super] = STATE(1122),
    [sym_comment] = STATE(73),
    [sym_documentation_comment] = STATE(73),
    [aux_sym_string_literal_repeat1] = STATE(473),
    [aux_sym__metadata_repeat1] = STATE(1143),
    [sym_identifier] = ACTIONS(568),
    [anon_sym_POUND] = ACTIONS(139),
    [sym_decimal_integer_literal] = ACTIONS(19),
    [sym_hex_integer_literal] = ACTIONS(21),
    [sym_decimal_floating_point_literal] = ACTIONS(19),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(25),
    [anon_sym_DQUOTE] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_r_DQUOTE] = ACTIONS(35),
    [anon_sym_r_SQUOTE] = ACTIONS(37),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(39),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(570),
    [anon_sym_LBRACK] = ACTIONS(572),
    [anon_sym_null] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_RPAREN] = ACTIONS(574),
    [anon_sym_LT] = ACTIONS(53),
    [sym_increment_operator] = ACTIONS(55),
    [sym_minus_operator] = ACTIONS(57),
    [sym__exclamation_operator] = ACTIONS(59),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_await] = ACTIONS(576),
    [anon_sym_AT] = ACTIONS(83),
    [anon_sym_super] = ACTIONS(95),
    [sym_void_type] = ACTIONS(97),
    [anon_sym_var] = ACTIONS(99),
    [anon_sym_covariant] = ACTIONS(109),
    [anon_sym_Function] = ACTIONS(113),
    [anon_sym_new] = ACTIONS(125),
    [sym_const_builtin] = ACTIONS(165),
    [sym_final_builtin] = ACTIONS(167),
    [anon_sym_late] = ACTIONS(131),
    [anon_sym_this] = ACTIONS(135),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_SLASH_SLASH_SLASH] = ACTIONS(7),
    [sym__block_comment] = ACTIONS(9),
    [sym__documentation_block_comment] = ACTIONS(11),
  },
  [74] = {
    [sym__literal] = STATE(967),
    [sym_symbol_literal] = STATE(912),
    [sym_true] = STATE(912),
    [sym_false] = STATE(912),
    [sym_string_literal] = STATE(912),
    [sym__string_literal_double_quotes] = STATE(617),
    [sym__string_literal_single_quotes] = STATE(617),
    [sym__string_literal_double_quotes_multiple] = STATE(617),
    [sym__string_literal_single_quotes_multiple] = STATE(617),
    [sym__raw_string_literal_double_quotes] = STATE(617),
    [sym__raw_string_literal_single_quotes] = STATE(617),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(617),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(617),
    [sym_list_literal] = STATE(912),
    [sym_set_or_map_literal] = STATE(912),
    [sym_null_literal] = STATE(912),
    [sym__expression] = STATE(2624),
    [sym__real_expression] = STATE(670),
    [sym_throw_expression] = STATE(976),
    [sym_assignment_expression] = STATE(976),
    [sym_assignable_expression] = STATE(1582),
    [sym_function_expression] = STATE(967),
    [sym_if_null_expression] = STATE(1377),
    [sym_conditional_expression] = STATE(1377),
    [sym_logical_or_expression] = STATE(1377),
    [sym_logical_and_expression] = STATE(1377),
    [sym_equality_expression] = STATE(1377),
    [sym_type_cast_expression] = STATE(1377),
    [sym_type_test_expression] = STATE(1377),
    [sym_relational_expression] = STATE(1377),
    [sym_bitwise_or_expression] = STATE(1377),
    [sym_bitwise_xor_expression] = STATE(1377),
    [sym_bitwise_and_expression] = STATE(1377),
    [sym_shift_expression] = STATE(1377),
    [sym_additive_expression] = STATE(1377),
    [sym_multiplicative_expression] = STATE(1377),
    [sym__unary_expression] = STATE(1118),
    [sym_unary_expression] = STATE(1169),
    [sym__postfix_expression] = STATE(1169),
    [sym_postfix_expression] = STATE(1170),
    [sym_prefix_operator] = STATE(360),
    [sym_negation_operator] = STATE(1206),
    [sym_tilde_operator] = STATE(1188),
    [sym_await_expression] = STATE(1171),
    [sym_new_expression] = STATE(967),
    [sym_const_object_expression] = STATE(967),
    [sym__primary] = STATE(641),
    [sym_constructor_invocation] = STATE(638),
    [sym_type_arguments] = STATE(2454),
    [sym__annotation] = STATE(1287),
    [sym_marker_annotation] = STATE(1289),
    [sym_annotation] = STATE(1289),
    [sym__metadata] = STATE(986),
    [sym_type_parameters] = STATE(2299),
    [sym__declared_identifier] = STATE(2007),
    [sym__final_const_var_or_type] = STATE(2066),
    [sym__type] = STATE(2269),
    [sym__type_not_function] = STATE(1616),
    [sym__type_not_void_not_function] = STATE(1668),
    [sym_function_type] = STATE(1655),
    [aux_sym__function_type_tails] = STATE(1482),
    [sym__function_type_tail] = STATE(1568),
    [sym__type_name] = STATE(1722),
    [sym__var_or_type] = STATE(2325),
    [sym_inferred_type] = STATE(1653),
    [sym__formal_parameter_part] = STATE(1915),
    [sym_formal_parameter_list] = STATE(1636),
    [sym__strict_formal_parameter_list] = STATE(1626),
    [sym__normal_formal_parameters] = STATE(2437),
    [sym_optional_formal_parameters] = STATE(2749),
    [sym__optional_postional_formal_parameters] = STATE(2750),
    [sym__named_formal_parameters] = STATE(2750),
    [sym_formal_parameter] = STATE(2271),
    [sym__normal_formal_parameter] = STATE(2008),
    [sym__function_formal_parameter] = STATE(2011),
    [sym__simple_formal_parameter] = STATE(2013),
    [sym_super_formal_parameter] = STATE(2011),
    [sym_constructor_param] = STATE(2011),
    [sym__covariant] = STATE(1547),
    [sym__function_builtin_identifier] = STATE(1424),
    [sym__new_builtin] = STATE(1701),
    [sym__late_builtin] = STATE(1618),
    [sym_this] = STATE(1113),
    [sym_super] = STATE(1122),
    [sym_comment] = STATE(74),
    [sym_documentation_comment] = STATE(74),
    [aux_sym_string_literal_repeat1] = STATE(473),
    [aux_sym__metadata_repeat1] = STATE(1143),
    [sym_identifier] = ACTIONS(568),
    [anon_sym_POUND] = ACTIONS(139),
    [sym_decimal_integer_literal] = ACTIONS(19),
    [sym_hex_integer_literal] = ACTIONS(21),
    [sym_decimal_floating_point_literal] = ACTIONS(19),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(25),
    [anon_sym_DQUOTE] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_r_DQUOTE] = ACTIONS(35),
    [anon_sym_r_SQUOTE] = ACTIONS(37),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(39),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(570),
    [anon_sym_LBRACK] = ACTIONS(572),
    [anon_sym_null] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_RPAREN] = ACTIONS(574),
    [anon_sym_LT] = ACTIONS(53),
    [sym_increment_operator] = ACTIONS(55),
    [sym_minus_operator] = ACTIONS(57),
    [sym__exclamation_operator] = ACTIONS(59),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_await] = ACTIONS(576),
    [anon_sym_AT] = ACTIONS(83),
    [anon_sym_super] = ACTIONS(95),
    [sym_void_type] = ACTIONS(97),
    [anon_sym_var] = ACTIONS(99),
    [anon_sym_covariant] = ACTIONS(109),
    [anon_sym_Function] = ACTIONS(113),
    [anon_sym_new] = ACTIONS(125),
    [sym_const_builtin] = ACTIONS(165),
    [sym_final_builtin] = ACTIONS(167),
    [anon_sym_late] = ACTIONS(131),
    [anon_sym_this] = ACTIONS(135),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_SLASH_SLASH_SLASH] = ACTIONS(7),
    [sym__block_comment] = ACTIONS(9),
    [sym__documentation_block_comment] = ACTIONS(11),
  },
  [75] = {
    [sym__literal] = STATE(967),
    [sym_symbol_literal] = STATE(912),
    [sym_true] = STATE(912),
    [sym_false] = STATE(912),
    [sym_string_literal] = STATE(912),
    [sym__string_literal_double_quotes] = STATE(617),
    [sym__string_literal_single_quotes] = STATE(617),
    [sym__string_literal_double_quotes_multiple] = STATE(617),
    [sym__string_literal_single_quotes_multiple] = STATE(617),
    [sym__raw_string_literal_double_quotes] = STATE(617),
    [sym__raw_string_literal_single_quotes] = STATE(617),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(617),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(617),
    [sym_list_literal] = STATE(912),
    [sym_set_or_map_literal] = STATE(912),
    [sym_null_literal] = STATE(912),
    [sym__expression] = STATE(2743),
    [sym__real_expression] = STATE(670),
    [sym_throw_expression] = STATE(976),
    [sym_assignment_expression] = STATE(976),
    [sym_assignable_expression] = STATE(1582),
    [sym_function_expression] = STATE(967),
    [sym_if_null_expression] = STATE(1377),
    [sym_conditional_expression] = STATE(1377),
    [sym_logical_or_expression] = STATE(1377),
    [sym_logical_and_expression] = STATE(1377),
    [sym_equality_expression] = STATE(1377),
    [sym_type_cast_expression] = STATE(1377),
    [sym_type_test_expression] = STATE(1377),
    [sym_relational_expression] = STATE(1377),
    [sym_bitwise_or_expression] = STATE(1377),
    [sym_bitwise_xor_expression] = STATE(1377),
    [sym_bitwise_and_expression] = STATE(1377),
    [sym_shift_expression] = STATE(1377),
    [sym_additive_expression] = STATE(1377),
    [sym_multiplicative_expression] = STATE(1377),
    [sym__unary_expression] = STATE(1118),
    [sym_unary_expression] = STATE(1169),
    [sym__postfix_expression] = STATE(1169),
    [sym_postfix_expression] = STATE(1170),
    [sym_prefix_operator] = STATE(360),
    [sym_negation_operator] = STATE(1206),
    [sym_tilde_operator] = STATE(1188),
    [sym_await_expression] = STATE(1171),
    [sym_new_expression] = STATE(967),
    [sym_const_object_expression] = STATE(967),
    [sym__primary] = STATE(641),
    [sym_constructor_invocation] = STATE(638),
    [sym_type_arguments] = STATE(2454),
    [sym__annotation] = STATE(1287),
    [sym_marker_annotation] = STATE(1289),
    [sym_annotation] = STATE(1289),
    [sym__metadata] = STATE(986),
    [sym_type_parameters] = STATE(2299),
    [sym__declared_identifier] = STATE(2007),
    [sym__final_const_var_or_type] = STATE(2066),
    [sym__type] = STATE(2269),
    [sym__type_not_function] = STATE(1616),
    [sym__type_not_void_not_function] = STATE(1668),
    [sym_function_type] = STATE(1655),
    [aux_sym__function_type_tails] = STATE(1482),
    [sym__function_type_tail] = STATE(1568),
    [sym__type_name] = STATE(1722),
    [sym__var_or_type] = STATE(2325),
    [sym_inferred_type] = STATE(1653),
    [sym__formal_parameter_part] = STATE(1915),
    [sym_formal_parameter_list] = STATE(1636),
    [sym__strict_formal_parameter_list] = STATE(1626),
    [sym__normal_formal_parameters] = STATE(2437),
    [sym_optional_formal_parameters] = STATE(2749),
    [sym__optional_postional_formal_parameters] = STATE(2750),
    [sym__named_formal_parameters] = STATE(2750),
    [sym_formal_parameter] = STATE(2271),
    [sym__normal_formal_parameter] = STATE(2008),
    [sym__function_formal_parameter] = STATE(2011),
    [sym__simple_formal_parameter] = STATE(2013),
    [sym_super_formal_parameter] = STATE(2011),
    [sym_constructor_param] = STATE(2011),
    [sym__covariant] = STATE(1547),
    [sym__function_builtin_identifier] = STATE(1424),
    [sym__new_builtin] = STATE(1701),
    [sym__late_builtin] = STATE(1618),
    [sym_this] = STATE(1113),
    [sym_super] = STATE(1122),
    [sym_comment] = STATE(75),
    [sym_documentation_comment] = STATE(75),
    [aux_sym_string_literal_repeat1] = STATE(473),
    [aux_sym__metadata_repeat1] = STATE(1143),
    [sym_identifier] = ACTIONS(568),
    [anon_sym_POUND] = ACTIONS(139),
    [sym_decimal_integer_literal] = ACTIONS(19),
    [sym_hex_integer_literal] = ACTIONS(21),
    [sym_decimal_floating_point_literal] = ACTIONS(19),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(25),
    [anon_sym_DQUOTE] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_r_DQUOTE] = ACTIONS(35),
    [anon_sym_r_SQUOTE] = ACTIONS(37),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(39),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(570),
    [anon_sym_LBRACK] = ACTIONS(572),
    [anon_sym_null] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_RPAREN] = ACTIONS(574),
    [anon_sym_LT] = ACTIONS(53),
    [sym_increment_operator] = ACTIONS(55),
    [sym_minus_operator] = ACTIONS(57),
    [sym__exclamation_operator] = ACTIONS(59),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_await] = ACTIONS(576),
    [anon_sym_AT] = ACTIONS(83),
    [anon_sym_super] = ACTIONS(95),
    [sym_void_type] = ACTIONS(97),
    [anon_sym_var] = ACTIONS(99),
    [anon_sym_covariant] = ACTIONS(109),
    [anon_sym_Function] = ACTIONS(113),
    [anon_sym_new] = ACTIONS(125),
    [sym_const_builtin] = ACTIONS(165),
    [sym_final_builtin] = ACTIONS(167),
    [anon_sym_late] = ACTIONS(131),
    [anon_sym_this] = ACTIONS(135),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_SLASH_SLASH_SLASH] = ACTIONS(7),
    [sym__block_comment] = ACTIONS(9),
    [sym__documentation_block_comment] = ACTIONS(11),
  },
  [76] = {
    [sym__literal] = STATE(967),
    [sym_symbol_literal] = STATE(912),
    [sym_true] = STATE(912),
    [sym_false] = STATE(912),
    [sym_string_literal] = STATE(912),
    [sym__string_literal_double_quotes] = STATE(617),
    [sym__string_literal_single_quotes] = STATE(617),
    [sym__string_literal_double_quotes_multiple] = STATE(617),
    [sym__string_literal_single_quotes_multiple] = STATE(617),
    [sym__raw_string_literal_double_quotes] = STATE(617),
    [sym__raw_string_literal_single_quotes] = STATE(617),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(617),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(617),
    [sym_list_literal] = STATE(912),
    [sym_set_or_map_literal] = STATE(912),
    [sym_null_literal] = STATE(912),
    [sym__expression] = STATE(2843),
    [sym__real_expression] = STATE(670),
    [sym_throw_expression] = STATE(976),
    [sym_assignment_expression] = STATE(976),
    [sym_assignable_expression] = STATE(1582),
    [sym_function_expression] = STATE(967),
    [sym_if_null_expression] = STATE(1377),
    [sym_conditional_expression] = STATE(1377),
    [sym_logical_or_expression] = STATE(1377),
    [sym_logical_and_expression] = STATE(1377),
    [sym_equality_expression] = STATE(1377),
    [sym_type_cast_expression] = STATE(1377),
    [sym_type_test_expression] = STATE(1377),
    [sym_relational_expression] = STATE(1377),
    [sym_bitwise_or_expression] = STATE(1377),
    [sym_bitwise_xor_expression] = STATE(1377),
    [sym_bitwise_and_expression] = STATE(1377),
    [sym_shift_expression] = STATE(1377),
    [sym_additive_expression] = STATE(1377),
    [sym_multiplicative_expression] = STATE(1377),
    [sym__unary_expression] = STATE(1118),
    [sym_unary_expression] = STATE(1169),
    [sym__postfix_expression] = STATE(1169),
    [sym_postfix_expression] = STATE(1170),
    [sym_prefix_operator] = STATE(360),
    [sym_negation_operator] = STATE(1206),
    [sym_tilde_operator] = STATE(1188),
    [sym_await_expression] = STATE(1171),
    [sym_new_expression] = STATE(967),
    [sym_const_object_expression] = STATE(967),
    [sym__primary] = STATE(641),
    [sym_constructor_invocation] = STATE(638),
    [sym_type_arguments] = STATE(2454),
    [sym__annotation] = STATE(1287),
    [sym_marker_annotation] = STATE(1289),
    [sym_annotation] = STATE(1289),
    [sym__metadata] = STATE(986),
    [sym_type_parameters] = STATE(2299),
    [sym__declared_identifier] = STATE(2007),
    [sym__final_const_var_or_type] = STATE(2066),
    [sym__type] = STATE(2269),
    [sym__type_not_function] = STATE(1616),
    [sym__type_not_void_not_function] = STATE(1668),
    [sym_function_type] = STATE(1655),
    [aux_sym__function_type_tails] = STATE(1482),
    [sym__function_type_tail] = STATE(1568),
    [sym__type_name] = STATE(1722),
    [sym__var_or_type] = STATE(2325),
    [sym_inferred_type] = STATE(1653),
    [sym__formal_parameter_part] = STATE(1915),
    [sym_formal_parameter_list] = STATE(1636),
    [sym__strict_formal_parameter_list] = STATE(1626),
    [sym__normal_formal_parameters] = STATE(2437),
    [sym_optional_formal_parameters] = STATE(2749),
    [sym__optional_postional_formal_parameters] = STATE(2750),
    [sym__named_formal_parameters] = STATE(2750),
    [sym_formal_parameter] = STATE(2271),
    [sym__normal_formal_parameter] = STATE(2008),
    [sym__function_formal_parameter] = STATE(2011),
    [sym__simple_formal_parameter] = STATE(2013),
    [sym_super_formal_parameter] = STATE(2011),
    [sym_constructor_param] = STATE(2011),
    [sym__covariant] = STATE(1547),
    [sym__function_builtin_identifier] = STATE(1424),
    [sym__new_builtin] = STATE(1701),
    [sym__late_builtin] = STATE(1618),
    [sym_this] = STATE(1113),
    [sym_super] = STATE(1122),
    [sym_comment] = STATE(76),
    [sym_documentation_comment] = STATE(76),
    [aux_sym_string_literal_repeat1] = STATE(473),
    [aux_sym__metadata_repeat1] = STATE(1143),
    [sym_identifier] = ACTIONS(568),
    [anon_sym_POUND] = ACTIONS(139),
    [sym_decimal_integer_literal] = ACTIONS(19),
    [sym_hex_integer_literal] = ACTIONS(21),
    [sym_decimal_floating_point_literal] = ACTIONS(19),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(25),
    [anon_sym_DQUOTE] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_r_DQUOTE] = ACTIONS(35),
    [anon_sym_r_SQUOTE] = ACTIONS(37),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(39),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(570),
    [anon_sym_LBRACK] = ACTIONS(572),
    [anon_sym_null] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_RPAREN] = ACTIONS(574),
    [anon_sym_LT] = ACTIONS(53),
    [sym_increment_operator] = ACTIONS(55),
    [sym_minus_operator] = ACTIONS(57),
    [sym__exclamation_operator] = ACTIONS(59),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_await] = ACTIONS(576),
    [anon_sym_AT] = ACTIONS(83),
    [anon_sym_super] = ACTIONS(95),
    [sym_void_type] = ACTIONS(97),
    [anon_sym_var] = ACTIONS(99),
    [anon_sym_covariant] = ACTIONS(109),
    [anon_sym_Function] = ACTIONS(113),
    [anon_sym_new] = ACTIONS(125),
    [sym_const_builtin] = ACTIONS(165),
    [sym_final_builtin] = ACTIONS(167),
    [anon_sym_late] = ACTIONS(131),
    [anon_sym_this] = ACTIONS(135),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_SLASH_SLASH_SLASH] = ACTIONS(7),
    [sym__block_comment] = ACTIONS(9),
    [sym__documentation_block_comment] = ACTIONS(11),
  },
  [77] = {
    [sym__literal] = STATE(967),
    [sym_symbol_literal] = STATE(912),
    [sym_true] = STATE(912),
    [sym_false] = STATE(912),
    [sym_string_literal] = STATE(912),
    [sym__string_literal_double_quotes] = STATE(617),
    [sym__string_literal_single_quotes] = STATE(617),
    [sym__string_literal_double_quotes_multiple] = STATE(617),
    [sym__string_literal_single_quotes_multiple] = STATE(617),
    [sym__raw_string_literal_double_quotes] = STATE(617),
    [sym__raw_string_literal_single_quotes] = STATE(617),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(617),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(617),
    [sym_list_literal] = STATE(912),
    [sym_set_or_map_literal] = STATE(912),
    [sym_null_literal] = STATE(912),
    [sym__expression] = STATE(2125),
    [sym__real_expression] = STATE(670),
    [sym_throw_expression] = STATE(976),
    [sym_assignment_expression] = STATE(976),
    [sym_assignable_expression] = STATE(1582),
    [sym_function_expression] = STATE(967),
    [sym_if_null_expression] = STATE(1377),
    [sym_conditional_expression] = STATE(1377),
    [sym_logical_or_expression] = STATE(1377),
    [sym_logical_and_expression] = STATE(1377),
    [sym_equality_expression] = STATE(1377),
    [sym_type_cast_expression] = STATE(1377),
    [sym_type_test_expression] = STATE(1377),
    [sym_relational_expression] = STATE(1377),
    [sym_bitwise_or_expression] = STATE(1377),
    [sym_bitwise_xor_expression] = STATE(1377),
    [sym_bitwise_and_expression] = STATE(1377),
    [sym_shift_expression] = STATE(1377),
    [sym_additive_expression] = STATE(1377),
    [sym_multiplicative_expression] = STATE(1377),
    [sym__unary_expression] = STATE(1118),
    [sym_unary_expression] = STATE(1169),
    [sym__postfix_expression] = STATE(1169),
    [sym_postfix_expression] = STATE(1170),
    [sym_prefix_operator] = STATE(360),
    [sym_negation_operator] = STATE(1206),
    [sym_tilde_operator] = STATE(1188),
    [sym_await_expression] = STATE(1171),
    [sym_new_expression] = STATE(967),
    [sym_const_object_expression] = STATE(967),
    [sym__primary] = STATE(641),
    [sym_constructor_invocation] = STATE(638),
    [sym_type_arguments] = STATE(2454),
    [sym__for_loop_parts] = STATE(2759),
    [sym__annotation] = STATE(1287),
    [sym_marker_annotation] = STATE(1289),
    [sym_annotation] = STATE(1289),
    [sym__metadata] = STATE(1477),
    [sym_type_parameters] = STATE(2299),
    [sym_initialized_variable_definition] = STATE(2472),
    [sym__declared_identifier] = STATE(2075),
    [sym__final_const_var_or_type] = STATE(2686),
    [sym__type] = STATE(2200),
    [sym__type_not_function] = STATE(1616),
    [sym__type_not_void_not_function] = STATE(1668),
    [sym_function_type] = STATE(1655),
    [aux_sym__function_type_tails] = STATE(1482),
    [sym__function_type_tail] = STATE(1568),
    [sym__type_name] = STATE(1722),
    [sym__var_or_type] = STATE(2325),
    [sym_inferred_type] = STATE(1653),
    [sym__formal_parameter_part] = STATE(1915),
    [sym_formal_parameter_list] = STATE(1636),
    [sym__strict_formal_parameter_list] = STATE(1626),
    [sym_local_variable_declaration] = STATE(161),
    [sym__covariant] = STATE(1552),
    [sym__function_builtin_identifier] = STATE(1424),
    [sym__new_builtin] = STATE(1701),
    [sym__late_builtin] = STATE(1618),
    [sym_this] = STATE(967),
    [sym_super] = STATE(1128),
    [sym__semicolon] = STATE(158),
    [sym_comment] = STATE(77),
    [sym_documentation_comment] = STATE(77),
    [aux_sym_string_literal_repeat1] = STATE(473),
    [aux_sym__metadata_repeat1] = STATE(1143),
    [sym_identifier] = ACTIONS(578),
    [anon_sym_POUND] = ACTIONS(139),
    [sym_decimal_integer_literal] = ACTIONS(19),
    [sym_hex_integer_literal] = ACTIONS(21),
    [sym_decimal_floating_point_literal] = ACTIONS(19),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(25),
    [anon_sym_DQUOTE] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_r_DQUOTE] = ACTIONS(35),
    [anon_sym_r_SQUOTE] = ACTIONS(37),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(39),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(552),
    [anon_sym_LBRACK] = ACTIONS(45),
    [anon_sym_null] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_LT] = ACTIONS(53),
    [sym_increment_operator] = ACTIONS(55),
    [sym_minus_operator] = ACTIONS(57),
    [sym__exclamation_operator] = ACTIONS(59),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_await] = ACTIONS(576),
    [anon_sym_SEMI] = ACTIONS(580),
    [anon_sym_AT] = ACTIONS(83),
    [anon_sym_super] = ACTIONS(95),
    [sym_void_type] = ACTIONS(97),
    [anon_sym_var] = ACTIONS(99),
    [anon_sym_covariant] = ACTIONS(109),
    [anon_sym_Function] = ACTIONS(113),
    [anon_sym_new] = ACTIONS(125),
    [sym_const_builtin] = ACTIONS(165),
    [sym_final_builtin] = ACTIONS(167),
    [anon_sym_late] = ACTIONS(131),
    [anon_sym_this] = ACTIONS(135),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_SLASH_SLASH_SLASH] = ACTIONS(7),
    [sym__block_comment] = ACTIONS(9),
    [sym__documentation_block_comment] = ACTIONS(11),
  },
  [78] = {
    [sym__literal] = STATE(967),
    [sym_symbol_literal] = STATE(912),
    [sym_true] = STATE(912),
    [sym_false] = STATE(912),
    [sym_string_literal] = STATE(912),
    [sym__string_literal_double_quotes] = STATE(617),
    [sym__string_literal_single_quotes] = STATE(617),
    [sym__string_literal_double_quotes_multiple] = STATE(617),
    [sym__string_literal_single_quotes_multiple] = STATE(617),
    [sym__raw_string_literal_double_quotes] = STATE(617),
    [sym__raw_string_literal_single_quotes] = STATE(617),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(617),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(617),
    [sym_list_literal] = STATE(912),
    [sym_set_or_map_literal] = STATE(912),
    [sym_null_literal] = STATE(912),
    [sym__expression] = STATE(2125),
    [sym__real_expression] = STATE(670),
    [sym_throw_expression] = STATE(976),
    [sym_assignment_expression] = STATE(976),
    [sym_assignable_expression] = STATE(1582),
    [sym_function_expression] = STATE(967),
    [sym_if_null_expression] = STATE(1377),
    [sym_conditional_expression] = STATE(1377),
    [sym_logical_or_expression] = STATE(1377),
    [sym_logical_and_expression] = STATE(1377),
    [sym_equality_expression] = STATE(1377),
    [sym_type_cast_expression] = STATE(1377),
    [sym_type_test_expression] = STATE(1377),
    [sym_relational_expression] = STATE(1377),
    [sym_bitwise_or_expression] = STATE(1377),
    [sym_bitwise_xor_expression] = STATE(1377),
    [sym_bitwise_and_expression] = STATE(1377),
    [sym_shift_expression] = STATE(1377),
    [sym_additive_expression] = STATE(1377),
    [sym_multiplicative_expression] = STATE(1377),
    [sym__unary_expression] = STATE(1118),
    [sym_unary_expression] = STATE(1169),
    [sym__postfix_expression] = STATE(1169),
    [sym_postfix_expression] = STATE(1170),
    [sym_prefix_operator] = STATE(360),
    [sym_negation_operator] = STATE(1206),
    [sym_tilde_operator] = STATE(1188),
    [sym_await_expression] = STATE(1171),
    [sym_new_expression] = STATE(967),
    [sym_const_object_expression] = STATE(967),
    [sym__primary] = STATE(641),
    [sym_constructor_invocation] = STATE(638),
    [sym_type_arguments] = STATE(2454),
    [sym__for_loop_parts] = STATE(2569),
    [sym__annotation] = STATE(1287),
    [sym_marker_annotation] = STATE(1289),
    [sym_annotation] = STATE(1289),
    [sym__metadata] = STATE(1477),
    [sym_type_parameters] = STATE(2299),
    [sym_initialized_variable_definition] = STATE(2472),
    [sym__declared_identifier] = STATE(2075),
    [sym__final_const_var_or_type] = STATE(2686),
    [sym__type] = STATE(2200),
    [sym__type_not_function] = STATE(1616),
    [sym__type_not_void_not_function] = STATE(1668),
    [sym_function_type] = STATE(1655),
    [aux_sym__function_type_tails] = STATE(1482),
    [sym__function_type_tail] = STATE(1568),
    [sym__type_name] = STATE(1722),
    [sym__var_or_type] = STATE(2325),
    [sym_inferred_type] = STATE(1653),
    [sym__formal_parameter_part] = STATE(1915),
    [sym_formal_parameter_list] = STATE(1636),
    [sym__strict_formal_parameter_list] = STATE(1626),
    [sym_local_variable_declaration] = STATE(161),
    [sym__covariant] = STATE(1552),
    [sym__function_builtin_identifier] = STATE(1424),
    [sym__new_builtin] = STATE(1701),
    [sym__late_builtin] = STATE(1618),
    [sym_this] = STATE(967),
    [sym_super] = STATE(1128),
    [sym__semicolon] = STATE(158),
    [sym_comment] = STATE(78),
    [sym_documentation_comment] = STATE(78),
    [aux_sym_string_literal_repeat1] = STATE(473),
    [aux_sym__metadata_repeat1] = STATE(1143),
    [sym_identifier] = ACTIONS(578),
    [anon_sym_POUND] = ACTIONS(139),
    [sym_decimal_integer_literal] = ACTIONS(19),
    [sym_hex_integer_literal] = ACTIONS(21),
    [sym_decimal_floating_point_literal] = ACTIONS(19),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(25),
    [anon_sym_DQUOTE] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_r_DQUOTE] = ACTIONS(35),
    [anon_sym_r_SQUOTE] = ACTIONS(37),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(39),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(552),
    [anon_sym_LBRACK] = ACTIONS(45),
    [anon_sym_null] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_LT] = ACTIONS(53),
    [sym_increment_operator] = ACTIONS(55),
    [sym_minus_operator] = ACTIONS(57),
    [sym__exclamation_operator] = ACTIONS(59),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_await] = ACTIONS(576),
    [anon_sym_SEMI] = ACTIONS(580),
    [anon_sym_AT] = ACTIONS(83),
    [anon_sym_super] = ACTIONS(95),
    [sym_void_type] = ACTIONS(97),
    [anon_sym_var] = ACTIONS(99),
    [anon_sym_covariant] = ACTIONS(109),
    [anon_sym_Function] = ACTIONS(113),
    [anon_sym_new] = ACTIONS(125),
    [sym_const_builtin] = ACTIONS(165),
    [sym_final_builtin] = ACTIONS(167),
    [anon_sym_late] = ACTIONS(131),
    [anon_sym_this] = ACTIONS(135),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_SLASH_SLASH_SLASH] = ACTIONS(7),
    [sym__block_comment] = ACTIONS(9),
    [sym__documentation_block_comment] = ACTIONS(11),
  },
  [79] = {
    [sym__literal] = STATE(967),
    [sym_symbol_literal] = STATE(912),
    [sym_true] = STATE(912),
    [sym_false] = STATE(912),
    [sym_string_literal] = STATE(912),
    [sym__string_literal_double_quotes] = STATE(617),
    [sym__string_literal_single_quotes] = STATE(617),
    [sym__string_literal_double_quotes_multiple] = STATE(617),
    [sym__string_literal_single_quotes_multiple] = STATE(617),
    [sym__raw_string_literal_double_quotes] = STATE(617),
    [sym__raw_string_literal_single_quotes] = STATE(617),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(617),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(617),
    [sym_list_literal] = STATE(912),
    [sym_set_or_map_literal] = STATE(912),
    [sym_null_literal] = STATE(912),
    [sym__expression] = STATE(2125),
    [sym__real_expression] = STATE(670),
    [sym_throw_expression] = STATE(976),
    [sym_assignment_expression] = STATE(976),
    [sym_assignable_expression] = STATE(1582),
    [sym_function_expression] = STATE(967),
    [sym_if_null_expression] = STATE(1377),
    [sym_conditional_expression] = STATE(1377),
    [sym_logical_or_expression] = STATE(1377),
    [sym_logical_and_expression] = STATE(1377),
    [sym_equality_expression] = STATE(1377),
    [sym_type_cast_expression] = STATE(1377),
    [sym_type_test_expression] = STATE(1377),
    [sym_relational_expression] = STATE(1377),
    [sym_bitwise_or_expression] = STATE(1377),
    [sym_bitwise_xor_expression] = STATE(1377),
    [sym_bitwise_and_expression] = STATE(1377),
    [sym_shift_expression] = STATE(1377),
    [sym_additive_expression] = STATE(1377),
    [sym_multiplicative_expression] = STATE(1377),
    [sym__unary_expression] = STATE(1118),
    [sym_unary_expression] = STATE(1169),
    [sym__postfix_expression] = STATE(1169),
    [sym_postfix_expression] = STATE(1170),
    [sym_prefix_operator] = STATE(360),
    [sym_negation_operator] = STATE(1206),
    [sym_tilde_operator] = STATE(1188),
    [sym_await_expression] = STATE(1171),
    [sym_new_expression] = STATE(967),
    [sym_const_object_expression] = STATE(967),
    [sym__primary] = STATE(641),
    [sym_constructor_invocation] = STATE(638),
    [sym_type_arguments] = STATE(2454),
    [sym__for_loop_parts] = STATE(2629),
    [sym__annotation] = STATE(1287),
    [sym_marker_annotation] = STATE(1289),
    [sym_annotation] = STATE(1289),
    [sym__metadata] = STATE(1477),
    [sym_type_parameters] = STATE(2299),
    [sym_initialized_variable_definition] = STATE(2472),
    [sym__declared_identifier] = STATE(2075),
    [sym__final_const_var_or_type] = STATE(2686),
    [sym__type] = STATE(2200),
    [sym__type_not_function] = STATE(1616),
    [sym__type_not_void_not_function] = STATE(1668),
    [sym_function_type] = STATE(1655),
    [aux_sym__function_type_tails] = STATE(1482),
    [sym__function_type_tail] = STATE(1568),
    [sym__type_name] = STATE(1722),
    [sym__var_or_type] = STATE(2325),
    [sym_inferred_type] = STATE(1653),
    [sym__formal_parameter_part] = STATE(1915),
    [sym_formal_parameter_list] = STATE(1636),
    [sym__strict_formal_parameter_list] = STATE(1626),
    [sym_local_variable_declaration] = STATE(161),
    [sym__covariant] = STATE(1552),
    [sym__function_builtin_identifier] = STATE(1424),
    [sym__new_builtin] = STATE(1701),
    [sym__late_builtin] = STATE(1618),
    [sym_this] = STATE(967),
    [sym_super] = STATE(1128),
    [sym__semicolon] = STATE(158),
    [sym_comment] = STATE(79),
    [sym_documentation_comment] = STATE(79),
    [aux_sym_string_literal_repeat1] = STATE(473),
    [aux_sym__metadata_repeat1] = STATE(1143),
    [sym_identifier] = ACTIONS(578),
    [anon_sym_POUND] = ACTIONS(139),
    [sym_decimal_integer_literal] = ACTIONS(19),
    [sym_hex_integer_literal] = ACTIONS(21),
    [sym_decimal_floating_point_literal] = ACTIONS(19),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(25),
    [anon_sym_DQUOTE] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_r_DQUOTE] = ACTIONS(35),
    [anon_sym_r_SQUOTE] = ACTIONS(37),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(39),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(552),
    [anon_sym_LBRACK] = ACTIONS(45),
    [anon_sym_null] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_LT] = ACTIONS(53),
    [sym_increment_operator] = ACTIONS(55),
    [sym_minus_operator] = ACTIONS(57),
    [sym__exclamation_operator] = ACTIONS(59),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_await] = ACTIONS(576),
    [anon_sym_SEMI] = ACTIONS(580),
    [anon_sym_AT] = ACTIONS(83),
    [anon_sym_super] = ACTIONS(95),
    [sym_void_type] = ACTIONS(97),
    [anon_sym_var] = ACTIONS(99),
    [anon_sym_covariant] = ACTIONS(109),
    [anon_sym_Function] = ACTIONS(113),
    [anon_sym_new] = ACTIONS(125),
    [sym_const_builtin] = ACTIONS(165),
    [sym_final_builtin] = ACTIONS(167),
    [anon_sym_late] = ACTIONS(131),
    [anon_sym_this] = ACTIONS(135),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_SLASH_SLASH_SLASH] = ACTIONS(7),
    [sym__block_comment] = ACTIONS(9),
    [sym__documentation_block_comment] = ACTIONS(11),
  },
  [80] = {
    [sym__literal] = STATE(967),
    [sym_symbol_literal] = STATE(912),
    [sym_true] = STATE(912),
    [sym_false] = STATE(912),
    [sym_string_literal] = STATE(912),
    [sym__string_literal_double_quotes] = STATE(617),
    [sym__string_literal_single_quotes] = STATE(617),
    [sym__string_literal_double_quotes_multiple] = STATE(617),
    [sym__string_literal_single_quotes_multiple] = STATE(617),
    [sym__raw_string_literal_double_quotes] = STATE(617),
    [sym__raw_string_literal_single_quotes] = STATE(617),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(617),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(617),
    [sym_list_literal] = STATE(912),
    [sym_set_or_map_literal] = STATE(912),
    [sym_null_literal] = STATE(912),
    [sym__expression] = STATE(2125),
    [sym__real_expression] = STATE(670),
    [sym_throw_expression] = STATE(976),
    [sym_assignment_expression] = STATE(976),
    [sym_assignable_expression] = STATE(1582),
    [sym_function_expression] = STATE(967),
    [sym_if_null_expression] = STATE(1377),
    [sym_conditional_expression] = STATE(1377),
    [sym_logical_or_expression] = STATE(1377),
    [sym_logical_and_expression] = STATE(1377),
    [sym_equality_expression] = STATE(1377),
    [sym_type_cast_expression] = STATE(1377),
    [sym_type_test_expression] = STATE(1377),
    [sym_relational_expression] = STATE(1377),
    [sym_bitwise_or_expression] = STATE(1377),
    [sym_bitwise_xor_expression] = STATE(1377),
    [sym_bitwise_and_expression] = STATE(1377),
    [sym_shift_expression] = STATE(1377),
    [sym_additive_expression] = STATE(1377),
    [sym_multiplicative_expression] = STATE(1377),
    [sym__unary_expression] = STATE(1118),
    [sym_unary_expression] = STATE(1169),
    [sym__postfix_expression] = STATE(1169),
    [sym_postfix_expression] = STATE(1170),
    [sym_prefix_operator] = STATE(360),
    [sym_negation_operator] = STATE(1206),
    [sym_tilde_operator] = STATE(1188),
    [sym_await_expression] = STATE(1171),
    [sym_new_expression] = STATE(967),
    [sym_const_object_expression] = STATE(967),
    [sym__primary] = STATE(641),
    [sym_constructor_invocation] = STATE(638),
    [sym_type_arguments] = STATE(2454),
    [sym__for_loop_parts] = STATE(2713),
    [sym__annotation] = STATE(1287),
    [sym_marker_annotation] = STATE(1289),
    [sym_annotation] = STATE(1289),
    [sym__metadata] = STATE(1477),
    [sym_type_parameters] = STATE(2299),
    [sym_initialized_variable_definition] = STATE(2472),
    [sym__declared_identifier] = STATE(2075),
    [sym__final_const_var_or_type] = STATE(2686),
    [sym__type] = STATE(2200),
    [sym__type_not_function] = STATE(1616),
    [sym__type_not_void_not_function] = STATE(1668),
    [sym_function_type] = STATE(1655),
    [aux_sym__function_type_tails] = STATE(1482),
    [sym__function_type_tail] = STATE(1568),
    [sym__type_name] = STATE(1722),
    [sym__var_or_type] = STATE(2325),
    [sym_inferred_type] = STATE(1653),
    [sym__formal_parameter_part] = STATE(1915),
    [sym_formal_parameter_list] = STATE(1636),
    [sym__strict_formal_parameter_list] = STATE(1626),
    [sym_local_variable_declaration] = STATE(161),
    [sym__covariant] = STATE(1552),
    [sym__function_builtin_identifier] = STATE(1424),
    [sym__new_builtin] = STATE(1701),
    [sym__late_builtin] = STATE(1618),
    [sym_this] = STATE(967),
    [sym_super] = STATE(1128),
    [sym__semicolon] = STATE(158),
    [sym_comment] = STATE(80),
    [sym_documentation_comment] = STATE(80),
    [aux_sym_string_literal_repeat1] = STATE(473),
    [aux_sym__metadata_repeat1] = STATE(1143),
    [sym_identifier] = ACTIONS(578),
    [anon_sym_POUND] = ACTIONS(139),
    [sym_decimal_integer_literal] = ACTIONS(19),
    [sym_hex_integer_literal] = ACTIONS(21),
    [sym_decimal_floating_point_literal] = ACTIONS(19),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(25),
    [anon_sym_DQUOTE] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_r_DQUOTE] = ACTIONS(35),
    [anon_sym_r_SQUOTE] = ACTIONS(37),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(39),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(552),
    [anon_sym_LBRACK] = ACTIONS(45),
    [anon_sym_null] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_LT] = ACTIONS(53),
    [sym_increment_operator] = ACTIONS(55),
    [sym_minus_operator] = ACTIONS(57),
    [sym__exclamation_operator] = ACTIONS(59),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_await] = ACTIONS(576),
    [anon_sym_SEMI] = ACTIONS(580),
    [anon_sym_AT] = ACTIONS(83),
    [anon_sym_super] = ACTIONS(95),
    [sym_void_type] = ACTIONS(97),
    [anon_sym_var] = ACTIONS(99),
    [anon_sym_covariant] = ACTIONS(109),
    [anon_sym_Function] = ACTIONS(113),
    [anon_sym_new] = ACTIONS(125),
    [sym_const_builtin] = ACTIONS(165),
    [sym_final_builtin] = ACTIONS(167),
    [anon_sym_late] = ACTIONS(131),
    [anon_sym_this] = ACTIONS(135),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_SLASH_SLASH_SLASH] = ACTIONS(7),
    [sym__block_comment] = ACTIONS(9),
    [sym__documentation_block_comment] = ACTIONS(11),
  },
  [81] = {
    [sym__literal] = STATE(967),
    [sym_symbol_literal] = STATE(912),
    [sym_true] = STATE(912),
    [sym_false] = STATE(912),
    [sym_string_literal] = STATE(912),
    [sym__string_literal_double_quotes] = STATE(617),
    [sym__string_literal_single_quotes] = STATE(617),
    [sym__string_literal_double_quotes_multiple] = STATE(617),
    [sym__string_literal_single_quotes_multiple] = STATE(617),
    [sym__raw_string_literal_double_quotes] = STATE(617),
    [sym__raw_string_literal_single_quotes] = STATE(617),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(617),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(617),
    [sym_list_literal] = STATE(912),
    [sym_set_or_map_literal] = STATE(912),
    [sym_null_literal] = STATE(912),
    [sym__expression] = STATE(2125),
    [sym__real_expression] = STATE(670),
    [sym_throw_expression] = STATE(976),
    [sym_assignment_expression] = STATE(976),
    [sym_assignable_expression] = STATE(1582),
    [sym_function_expression] = STATE(967),
    [sym_if_null_expression] = STATE(1377),
    [sym_conditional_expression] = STATE(1377),
    [sym_logical_or_expression] = STATE(1377),
    [sym_logical_and_expression] = STATE(1377),
    [sym_equality_expression] = STATE(1377),
    [sym_type_cast_expression] = STATE(1377),
    [sym_type_test_expression] = STATE(1377),
    [sym_relational_expression] = STATE(1377),
    [sym_bitwise_or_expression] = STATE(1377),
    [sym_bitwise_xor_expression] = STATE(1377),
    [sym_bitwise_and_expression] = STATE(1377),
    [sym_shift_expression] = STATE(1377),
    [sym_additive_expression] = STATE(1377),
    [sym_multiplicative_expression] = STATE(1377),
    [sym__unary_expression] = STATE(1118),
    [sym_unary_expression] = STATE(1169),
    [sym__postfix_expression] = STATE(1169),
    [sym_postfix_expression] = STATE(1170),
    [sym_prefix_operator] = STATE(360),
    [sym_negation_operator] = STATE(1206),
    [sym_tilde_operator] = STATE(1188),
    [sym_await_expression] = STATE(1171),
    [sym_new_expression] = STATE(967),
    [sym_const_object_expression] = STATE(967),
    [sym__primary] = STATE(641),
    [sym_constructor_invocation] = STATE(638),
    [sym_type_arguments] = STATE(2454),
    [sym__for_loop_parts] = STATE(2630),
    [sym__annotation] = STATE(1287),
    [sym_marker_annotation] = STATE(1289),
    [sym_annotation] = STATE(1289),
    [sym__metadata] = STATE(1477),
    [sym_type_parameters] = STATE(2299),
    [sym_initialized_variable_definition] = STATE(2472),
    [sym__declared_identifier] = STATE(2075),
    [sym__final_const_var_or_type] = STATE(2686),
    [sym__type] = STATE(2200),
    [sym__type_not_function] = STATE(1616),
    [sym__type_not_void_not_function] = STATE(1668),
    [sym_function_type] = STATE(1655),
    [aux_sym__function_type_tails] = STATE(1482),
    [sym__function_type_tail] = STATE(1568),
    [sym__type_name] = STATE(1722),
    [sym__var_or_type] = STATE(2325),
    [sym_inferred_type] = STATE(1653),
    [sym__formal_parameter_part] = STATE(1915),
    [sym_formal_parameter_list] = STATE(1636),
    [sym__strict_formal_parameter_list] = STATE(1626),
    [sym_local_variable_declaration] = STATE(161),
    [sym__covariant] = STATE(1552),
    [sym__function_builtin_identifier] = STATE(1424),
    [sym__new_builtin] = STATE(1701),
    [sym__late_builtin] = STATE(1618),
    [sym_this] = STATE(967),
    [sym_super] = STATE(1128),
    [sym__semicolon] = STATE(158),
    [sym_comment] = STATE(81),
    [sym_documentation_comment] = STATE(81),
    [aux_sym_string_literal_repeat1] = STATE(473),
    [aux_sym__metadata_repeat1] = STATE(1143),
    [sym_identifier] = ACTIONS(578),
    [anon_sym_POUND] = ACTIONS(139),
    [sym_decimal_integer_literal] = ACTIONS(19),
    [sym_hex_integer_literal] = ACTIONS(21),
    [sym_decimal_floating_point_literal] = ACTIONS(19),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(25),
    [anon_sym_DQUOTE] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_r_DQUOTE] = ACTIONS(35),
    [anon_sym_r_SQUOTE] = ACTIONS(37),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(39),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(552),
    [anon_sym_LBRACK] = ACTIONS(45),
    [anon_sym_null] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_LT] = ACTIONS(53),
    [sym_increment_operator] = ACTIONS(55),
    [sym_minus_operator] = ACTIONS(57),
    [sym__exclamation_operator] = ACTIONS(59),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_await] = ACTIONS(576),
    [anon_sym_SEMI] = ACTIONS(580),
    [anon_sym_AT] = ACTIONS(83),
    [anon_sym_super] = ACTIONS(95),
    [sym_void_type] = ACTIONS(97),
    [anon_sym_var] = ACTIONS(99),
    [anon_sym_covariant] = ACTIONS(109),
    [anon_sym_Function] = ACTIONS(113),
    [anon_sym_new] = ACTIONS(125),
    [sym_const_builtin] = ACTIONS(165),
    [sym_final_builtin] = ACTIONS(167),
    [anon_sym_late] = ACTIONS(131),
    [anon_sym_this] = ACTIONS(135),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_SLASH_SLASH_SLASH] = ACTIONS(7),
    [sym__block_comment] = ACTIONS(9),
    [sym__documentation_block_comment] = ACTIONS(11),
  },
  [82] = {
    [sym__literal] = STATE(967),
    [sym_symbol_literal] = STATE(912),
    [sym_true] = STATE(912),
    [sym_false] = STATE(912),
    [sym_string_literal] = STATE(912),
    [sym__string_literal_double_quotes] = STATE(617),
    [sym__string_literal_single_quotes] = STATE(617),
    [sym__string_literal_double_quotes_multiple] = STATE(617),
    [sym__string_literal_single_quotes_multiple] = STATE(617),
    [sym__raw_string_literal_double_quotes] = STATE(617),
    [sym__raw_string_literal_single_quotes] = STATE(617),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(617),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(617),
    [sym_list_literal] = STATE(912),
    [sym_set_or_map_literal] = STATE(912),
    [sym_null_literal] = STATE(912),
    [sym__expression] = STATE(2125),
    [sym__real_expression] = STATE(670),
    [sym_throw_expression] = STATE(976),
    [sym_assignment_expression] = STATE(976),
    [sym_assignable_expression] = STATE(1582),
    [sym_function_expression] = STATE(967),
    [sym_if_null_expression] = STATE(1377),
    [sym_conditional_expression] = STATE(1377),
    [sym_logical_or_expression] = STATE(1377),
    [sym_logical_and_expression] = STATE(1377),
    [sym_equality_expression] = STATE(1377),
    [sym_type_cast_expression] = STATE(1377),
    [sym_type_test_expression] = STATE(1377),
    [sym_relational_expression] = STATE(1377),
    [sym_bitwise_or_expression] = STATE(1377),
    [sym_bitwise_xor_expression] = STATE(1377),
    [sym_bitwise_and_expression] = STATE(1377),
    [sym_shift_expression] = STATE(1377),
    [sym_additive_expression] = STATE(1377),
    [sym_multiplicative_expression] = STATE(1377),
    [sym__unary_expression] = STATE(1118),
    [sym_unary_expression] = STATE(1169),
    [sym__postfix_expression] = STATE(1169),
    [sym_postfix_expression] = STATE(1170),
    [sym_prefix_operator] = STATE(360),
    [sym_negation_operator] = STATE(1206),
    [sym_tilde_operator] = STATE(1188),
    [sym_await_expression] = STATE(1171),
    [sym_new_expression] = STATE(967),
    [sym_const_object_expression] = STATE(967),
    [sym__primary] = STATE(641),
    [sym_constructor_invocation] = STATE(638),
    [sym_type_arguments] = STATE(2454),
    [sym__for_loop_parts] = STATE(2764),
    [sym__annotation] = STATE(1287),
    [sym_marker_annotation] = STATE(1289),
    [sym_annotation] = STATE(1289),
    [sym__metadata] = STATE(1477),
    [sym_type_parameters] = STATE(2299),
    [sym_initialized_variable_definition] = STATE(2472),
    [sym__declared_identifier] = STATE(2075),
    [sym__final_const_var_or_type] = STATE(2686),
    [sym__type] = STATE(2200),
    [sym__type_not_function] = STATE(1616),
    [sym__type_not_void_not_function] = STATE(1668),
    [sym_function_type] = STATE(1655),
    [aux_sym__function_type_tails] = STATE(1482),
    [sym__function_type_tail] = STATE(1568),
    [sym__type_name] = STATE(1722),
    [sym__var_or_type] = STATE(2325),
    [sym_inferred_type] = STATE(1653),
    [sym__formal_parameter_part] = STATE(1915),
    [sym_formal_parameter_list] = STATE(1636),
    [sym__strict_formal_parameter_list] = STATE(1626),
    [sym_local_variable_declaration] = STATE(161),
    [sym__covariant] = STATE(1552),
    [sym__function_builtin_identifier] = STATE(1424),
    [sym__new_builtin] = STATE(1701),
    [sym__late_builtin] = STATE(1618),
    [sym_this] = STATE(967),
    [sym_super] = STATE(1128),
    [sym__semicolon] = STATE(158),
    [sym_comment] = STATE(82),
    [sym_documentation_comment] = STATE(82),
    [aux_sym_string_literal_repeat1] = STATE(473),
    [aux_sym__metadata_repeat1] = STATE(1143),
    [sym_identifier] = ACTIONS(578),
    [anon_sym_POUND] = ACTIONS(139),
    [sym_decimal_integer_literal] = ACTIONS(19),
    [sym_hex_integer_literal] = ACTIONS(21),
    [sym_decimal_floating_point_literal] = ACTIONS(19),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(25),
    [anon_sym_DQUOTE] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_r_DQUOTE] = ACTIONS(35),
    [anon_sym_r_SQUOTE] = ACTIONS(37),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(39),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(552),
    [anon_sym_LBRACK] = ACTIONS(45),
    [anon_sym_null] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_LT] = ACTIONS(53),
    [sym_increment_operator] = ACTIONS(55),
    [sym_minus_operator] = ACTIONS(57),
    [sym__exclamation_operator] = ACTIONS(59),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_await] = ACTIONS(576),
    [anon_sym_SEMI] = ACTIONS(580),
    [anon_sym_AT] = ACTIONS(83),
    [anon_sym_super] = ACTIONS(95),
    [sym_void_type] = ACTIONS(97),
    [anon_sym_var] = ACTIONS(99),
    [anon_sym_covariant] = ACTIONS(109),
    [anon_sym_Function] = ACTIONS(113),
    [anon_sym_new] = ACTIONS(125),
    [sym_const_builtin] = ACTIONS(165),
    [sym_final_builtin] = ACTIONS(167),
    [anon_sym_late] = ACTIONS(131),
    [anon_sym_this] = ACTIONS(135),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_SLASH_SLASH_SLASH] = ACTIONS(7),
    [sym__block_comment] = ACTIONS(9),
    [sym__documentation_block_comment] = ACTIONS(11),
  },
  [83] = {
    [sym__literal] = STATE(967),
    [sym_symbol_literal] = STATE(912),
    [sym_true] = STATE(912),
    [sym_false] = STATE(912),
    [sym_string_literal] = STATE(912),
    [sym__string_literal_double_quotes] = STATE(617),
    [sym__string_literal_single_quotes] = STATE(617),
    [sym__string_literal_double_quotes_multiple] = STATE(617),
    [sym__string_literal_single_quotes_multiple] = STATE(617),
    [sym__raw_string_literal_double_quotes] = STATE(617),
    [sym__raw_string_literal_single_quotes] = STATE(617),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(617),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(617),
    [sym_list_literal] = STATE(912),
    [sym_set_or_map_literal] = STATE(912),
    [sym_null_literal] = STATE(912),
    [sym__expression] = STATE(2125),
    [sym__real_expression] = STATE(670),
    [sym_throw_expression] = STATE(976),
    [sym_assignment_expression] = STATE(976),
    [sym_assignable_expression] = STATE(1582),
    [sym_function_expression] = STATE(967),
    [sym_if_null_expression] = STATE(1377),
    [sym_conditional_expression] = STATE(1377),
    [sym_logical_or_expression] = STATE(1377),
    [sym_logical_and_expression] = STATE(1377),
    [sym_equality_expression] = STATE(1377),
    [sym_type_cast_expression] = STATE(1377),
    [sym_type_test_expression] = STATE(1377),
    [sym_relational_expression] = STATE(1377),
    [sym_bitwise_or_expression] = STATE(1377),
    [sym_bitwise_xor_expression] = STATE(1377),
    [sym_bitwise_and_expression] = STATE(1377),
    [sym_shift_expression] = STATE(1377),
    [sym_additive_expression] = STATE(1377),
    [sym_multiplicative_expression] = STATE(1377),
    [sym__unary_expression] = STATE(1118),
    [sym_unary_expression] = STATE(1169),
    [sym__postfix_expression] = STATE(1169),
    [sym_postfix_expression] = STATE(1170),
    [sym_prefix_operator] = STATE(360),
    [sym_negation_operator] = STATE(1206),
    [sym_tilde_operator] = STATE(1188),
    [sym_await_expression] = STATE(1171),
    [sym_new_expression] = STATE(967),
    [sym_const_object_expression] = STATE(967),
    [sym__primary] = STATE(641),
    [sym_constructor_invocation] = STATE(638),
    [sym_type_arguments] = STATE(2454),
    [sym__for_loop_parts] = STATE(2711),
    [sym__annotation] = STATE(1287),
    [sym_marker_annotation] = STATE(1289),
    [sym_annotation] = STATE(1289),
    [sym__metadata] = STATE(1477),
    [sym_type_parameters] = STATE(2299),
    [sym_initialized_variable_definition] = STATE(2472),
    [sym__declared_identifier] = STATE(2075),
    [sym__final_const_var_or_type] = STATE(2686),
    [sym__type] = STATE(2200),
    [sym__type_not_function] = STATE(1616),
    [sym__type_not_void_not_function] = STATE(1668),
    [sym_function_type] = STATE(1655),
    [aux_sym__function_type_tails] = STATE(1482),
    [sym__function_type_tail] = STATE(1568),
    [sym__type_name] = STATE(1722),
    [sym__var_or_type] = STATE(2325),
    [sym_inferred_type] = STATE(1653),
    [sym__formal_parameter_part] = STATE(1915),
    [sym_formal_parameter_list] = STATE(1636),
    [sym__strict_formal_parameter_list] = STATE(1626),
    [sym_local_variable_declaration] = STATE(161),
    [sym__covariant] = STATE(1552),
    [sym__function_builtin_identifier] = STATE(1424),
    [sym__new_builtin] = STATE(1701),
    [sym__late_builtin] = STATE(1618),
    [sym_this] = STATE(967),
    [sym_super] = STATE(1128),
    [sym__semicolon] = STATE(158),
    [sym_comment] = STATE(83),
    [sym_documentation_comment] = STATE(83),
    [aux_sym_string_literal_repeat1] = STATE(473),
    [aux_sym__metadata_repeat1] = STATE(1143),
    [sym_identifier] = ACTIONS(578),
    [anon_sym_POUND] = ACTIONS(139),
    [sym_decimal_integer_literal] = ACTIONS(19),
    [sym_hex_integer_literal] = ACTIONS(21),
    [sym_decimal_floating_point_literal] = ACTIONS(19),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(25),
    [anon_sym_DQUOTE] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_r_DQUOTE] = ACTIONS(35),
    [anon_sym_r_SQUOTE] = ACTIONS(37),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(39),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(552),
    [anon_sym_LBRACK] = ACTIONS(45),
    [anon_sym_null] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_LT] = ACTIONS(53),
    [sym_increment_operator] = ACTIONS(55),
    [sym_minus_operator] = ACTIONS(57),
    [sym__exclamation_operator] = ACTIONS(59),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_await] = ACTIONS(576),
    [anon_sym_SEMI] = ACTIONS(580),
    [anon_sym_AT] = ACTIONS(83),
    [anon_sym_super] = ACTIONS(95),
    [sym_void_type] = ACTIONS(97),
    [anon_sym_var] = ACTIONS(99),
    [anon_sym_covariant] = ACTIONS(109),
    [anon_sym_Function] = ACTIONS(113),
    [anon_sym_new] = ACTIONS(125),
    [sym_const_builtin] = ACTIONS(165),
    [sym_final_builtin] = ACTIONS(167),
    [anon_sym_late] = ACTIONS(131),
    [anon_sym_this] = ACTIONS(135),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_SLASH_SLASH_SLASH] = ACTIONS(7),
    [sym__block_comment] = ACTIONS(9),
    [sym__documentation_block_comment] = ACTIONS(11),
  },
  [84] = {
    [sym__literal] = STATE(967),
    [sym_symbol_literal] = STATE(912),
    [sym_true] = STATE(912),
    [sym_false] = STATE(912),
    [sym_string_literal] = STATE(912),
    [sym__string_literal_double_quotes] = STATE(617),
    [sym__string_literal_single_quotes] = STATE(617),
    [sym__string_literal_double_quotes_multiple] = STATE(617),
    [sym__string_literal_single_quotes_multiple] = STATE(617),
    [sym__raw_string_literal_double_quotes] = STATE(617),
    [sym__raw_string_literal_single_quotes] = STATE(617),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(617),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(617),
    [sym_list_literal] = STATE(912),
    [sym_set_or_map_literal] = STATE(912),
    [sym_null_literal] = STATE(912),
    [sym__expression] = STATE(2125),
    [sym__real_expression] = STATE(670),
    [sym_throw_expression] = STATE(976),
    [sym_assignment_expression] = STATE(976),
    [sym_assignable_expression] = STATE(1582),
    [sym_function_expression] = STATE(967),
    [sym_if_null_expression] = STATE(1377),
    [sym_conditional_expression] = STATE(1377),
    [sym_logical_or_expression] = STATE(1377),
    [sym_logical_and_expression] = STATE(1377),
    [sym_equality_expression] = STATE(1377),
    [sym_type_cast_expression] = STATE(1377),
    [sym_type_test_expression] = STATE(1377),
    [sym_relational_expression] = STATE(1377),
    [sym_bitwise_or_expression] = STATE(1377),
    [sym_bitwise_xor_expression] = STATE(1377),
    [sym_bitwise_and_expression] = STATE(1377),
    [sym_shift_expression] = STATE(1377),
    [sym_additive_expression] = STATE(1377),
    [sym_multiplicative_expression] = STATE(1377),
    [sym__unary_expression] = STATE(1118),
    [sym_unary_expression] = STATE(1169),
    [sym__postfix_expression] = STATE(1169),
    [sym_postfix_expression] = STATE(1170),
    [sym_prefix_operator] = STATE(360),
    [sym_negation_operator] = STATE(1206),
    [sym_tilde_operator] = STATE(1188),
    [sym_await_expression] = STATE(1171),
    [sym_new_expression] = STATE(967),
    [sym_const_object_expression] = STATE(967),
    [sym__primary] = STATE(641),
    [sym_constructor_invocation] = STATE(638),
    [sym_type_arguments] = STATE(2454),
    [sym__for_loop_parts] = STATE(2710),
    [sym__annotation] = STATE(1287),
    [sym_marker_annotation] = STATE(1289),
    [sym_annotation] = STATE(1289),
    [sym__metadata] = STATE(1477),
    [sym_type_parameters] = STATE(2299),
    [sym_initialized_variable_definition] = STATE(2472),
    [sym__declared_identifier] = STATE(2075),
    [sym__final_const_var_or_type] = STATE(2686),
    [sym__type] = STATE(2200),
    [sym__type_not_function] = STATE(1616),
    [sym__type_not_void_not_function] = STATE(1668),
    [sym_function_type] = STATE(1655),
    [aux_sym__function_type_tails] = STATE(1482),
    [sym__function_type_tail] = STATE(1568),
    [sym__type_name] = STATE(1722),
    [sym__var_or_type] = STATE(2325),
    [sym_inferred_type] = STATE(1653),
    [sym__formal_parameter_part] = STATE(1915),
    [sym_formal_parameter_list] = STATE(1636),
    [sym__strict_formal_parameter_list] = STATE(1626),
    [sym_local_variable_declaration] = STATE(161),
    [sym__covariant] = STATE(1552),
    [sym__function_builtin_identifier] = STATE(1424),
    [sym__new_builtin] = STATE(1701),
    [sym__late_builtin] = STATE(1618),
    [sym_this] = STATE(967),
    [sym_super] = STATE(1128),
    [sym__semicolon] = STATE(158),
    [sym_comment] = STATE(84),
    [sym_documentation_comment] = STATE(84),
    [aux_sym_string_literal_repeat1] = STATE(473),
    [aux_sym__metadata_repeat1] = STATE(1143),
    [sym_identifier] = ACTIONS(578),
    [anon_sym_POUND] = ACTIONS(139),
    [sym_decimal_integer_literal] = ACTIONS(19),
    [sym_hex_integer_literal] = ACTIONS(21),
    [sym_decimal_floating_point_literal] = ACTIONS(19),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(25),
    [anon_sym_DQUOTE] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_r_DQUOTE] = ACTIONS(35),
    [anon_sym_r_SQUOTE] = ACTIONS(37),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(39),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(552),
    [anon_sym_LBRACK] = ACTIONS(45),
    [anon_sym_null] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_LT] = ACTIONS(53),
    [sym_increment_operator] = ACTIONS(55),
    [sym_minus_operator] = ACTIONS(57),
    [sym__exclamation_operator] = ACTIONS(59),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_await] = ACTIONS(576),
    [anon_sym_SEMI] = ACTIONS(580),
    [anon_sym_AT] = ACTIONS(83),
    [anon_sym_super] = ACTIONS(95),
    [sym_void_type] = ACTIONS(97),
    [anon_sym_var] = ACTIONS(99),
    [anon_sym_covariant] = ACTIONS(109),
    [anon_sym_Function] = ACTIONS(113),
    [anon_sym_new] = ACTIONS(125),
    [sym_const_builtin] = ACTIONS(165),
    [sym_final_builtin] = ACTIONS(167),
    [anon_sym_late] = ACTIONS(131),
    [anon_sym_this] = ACTIONS(135),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_SLASH_SLASH_SLASH] = ACTIONS(7),
    [sym__block_comment] = ACTIONS(9),
    [sym__documentation_block_comment] = ACTIONS(11),
  },
  [85] = {
    [sym__literal] = STATE(967),
    [sym_symbol_literal] = STATE(912),
    [sym_true] = STATE(912),
    [sym_false] = STATE(912),
    [sym_string_literal] = STATE(912),
    [sym__string_literal_double_quotes] = STATE(617),
    [sym__string_literal_single_quotes] = STATE(617),
    [sym__string_literal_double_quotes_multiple] = STATE(617),
    [sym__string_literal_single_quotes_multiple] = STATE(617),
    [sym__raw_string_literal_double_quotes] = STATE(617),
    [sym__raw_string_literal_single_quotes] = STATE(617),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(617),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(617),
    [sym_list_literal] = STATE(912),
    [sym_set_or_map_literal] = STATE(912),
    [sym_null_literal] = STATE(912),
    [sym__expression] = STATE(2125),
    [sym__real_expression] = STATE(670),
    [sym_throw_expression] = STATE(976),
    [sym_assignment_expression] = STATE(976),
    [sym_assignable_expression] = STATE(1582),
    [sym_function_expression] = STATE(967),
    [sym_if_null_expression] = STATE(1377),
    [sym_conditional_expression] = STATE(1377),
    [sym_logical_or_expression] = STATE(1377),
    [sym_logical_and_expression] = STATE(1377),
    [sym_equality_expression] = STATE(1377),
    [sym_type_cast_expression] = STATE(1377),
    [sym_type_test_expression] = STATE(1377),
    [sym_relational_expression] = STATE(1377),
    [sym_bitwise_or_expression] = STATE(1377),
    [sym_bitwise_xor_expression] = STATE(1377),
    [sym_bitwise_and_expression] = STATE(1377),
    [sym_shift_expression] = STATE(1377),
    [sym_additive_expression] = STATE(1377),
    [sym_multiplicative_expression] = STATE(1377),
    [sym__unary_expression] = STATE(1118),
    [sym_unary_expression] = STATE(1169),
    [sym__postfix_expression] = STATE(1169),
    [sym_postfix_expression] = STATE(1170),
    [sym_prefix_operator] = STATE(360),
    [sym_negation_operator] = STATE(1206),
    [sym_tilde_operator] = STATE(1188),
    [sym_await_expression] = STATE(1171),
    [sym_new_expression] = STATE(967),
    [sym_const_object_expression] = STATE(967),
    [sym__primary] = STATE(641),
    [sym_constructor_invocation] = STATE(638),
    [sym_type_arguments] = STATE(2454),
    [sym__for_loop_parts] = STATE(2703),
    [sym__annotation] = STATE(1287),
    [sym_marker_annotation] = STATE(1289),
    [sym_annotation] = STATE(1289),
    [sym__metadata] = STATE(1477),
    [sym_type_parameters] = STATE(2299),
    [sym_initialized_variable_definition] = STATE(2472),
    [sym__declared_identifier] = STATE(2075),
    [sym__final_const_var_or_type] = STATE(2686),
    [sym__type] = STATE(2200),
    [sym__type_not_function] = STATE(1616),
    [sym__type_not_void_not_function] = STATE(1668),
    [sym_function_type] = STATE(1655),
    [aux_sym__function_type_tails] = STATE(1482),
    [sym__function_type_tail] = STATE(1568),
    [sym__type_name] = STATE(1722),
    [sym__var_or_type] = STATE(2325),
    [sym_inferred_type] = STATE(1653),
    [sym__formal_parameter_part] = STATE(1915),
    [sym_formal_parameter_list] = STATE(1636),
    [sym__strict_formal_parameter_list] = STATE(1626),
    [sym_local_variable_declaration] = STATE(161),
    [sym__covariant] = STATE(1552),
    [sym__function_builtin_identifier] = STATE(1424),
    [sym__new_builtin] = STATE(1701),
    [sym__late_builtin] = STATE(1618),
    [sym_this] = STATE(967),
    [sym_super] = STATE(1128),
    [sym__semicolon] = STATE(158),
    [sym_comment] = STATE(85),
    [sym_documentation_comment] = STATE(85),
    [aux_sym_string_literal_repeat1] = STATE(473),
    [aux_sym__metadata_repeat1] = STATE(1143),
    [sym_identifier] = ACTIONS(578),
    [anon_sym_POUND] = ACTIONS(139),
    [sym_decimal_integer_literal] = ACTIONS(19),
    [sym_hex_integer_literal] = ACTIONS(21),
    [sym_decimal_floating_point_literal] = ACTIONS(19),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(25),
    [anon_sym_DQUOTE] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_r_DQUOTE] = ACTIONS(35),
    [anon_sym_r_SQUOTE] = ACTIONS(37),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(39),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(552),
    [anon_sym_LBRACK] = ACTIONS(45),
    [anon_sym_null] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_LT] = ACTIONS(53),
    [sym_increment_operator] = ACTIONS(55),
    [sym_minus_operator] = ACTIONS(57),
    [sym__exclamation_operator] = ACTIONS(59),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_await] = ACTIONS(576),
    [anon_sym_SEMI] = ACTIONS(580),
    [anon_sym_AT] = ACTIONS(83),
    [anon_sym_super] = ACTIONS(95),
    [sym_void_type] = ACTIONS(97),
    [anon_sym_var] = ACTIONS(99),
    [anon_sym_covariant] = ACTIONS(109),
    [anon_sym_Function] = ACTIONS(113),
    [anon_sym_new] = ACTIONS(125),
    [sym_const_builtin] = ACTIONS(165),
    [sym_final_builtin] = ACTIONS(167),
    [anon_sym_late] = ACTIONS(131),
    [anon_sym_this] = ACTIONS(135),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_SLASH_SLASH_SLASH] = ACTIONS(7),
    [sym__block_comment] = ACTIONS(9),
    [sym__documentation_block_comment] = ACTIONS(11),
  },
  [86] = {
    [sym__literal] = STATE(967),
    [sym_symbol_literal] = STATE(912),
    [sym_true] = STATE(912),
    [sym_false] = STATE(912),
    [sym_string_literal] = STATE(912),
    [sym__string_literal_double_quotes] = STATE(617),
    [sym__string_literal_single_quotes] = STATE(617),
    [sym__string_literal_double_quotes_multiple] = STATE(617),
    [sym__string_literal_single_quotes_multiple] = STATE(617),
    [sym__raw_string_literal_double_quotes] = STATE(617),
    [sym__raw_string_literal_single_quotes] = STATE(617),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(617),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(617),
    [sym_list_literal] = STATE(912),
    [sym_set_or_map_literal] = STATE(912),
    [sym_null_literal] = STATE(912),
    [sym__expression] = STATE(2125),
    [sym__real_expression] = STATE(670),
    [sym_throw_expression] = STATE(976),
    [sym_assignment_expression] = STATE(976),
    [sym_assignable_expression] = STATE(1582),
    [sym_function_expression] = STATE(967),
    [sym_if_null_expression] = STATE(1377),
    [sym_conditional_expression] = STATE(1377),
    [sym_logical_or_expression] = STATE(1377),
    [sym_logical_and_expression] = STATE(1377),
    [sym_equality_expression] = STATE(1377),
    [sym_type_cast_expression] = STATE(1377),
    [sym_type_test_expression] = STATE(1377),
    [sym_relational_expression] = STATE(1377),
    [sym_bitwise_or_expression] = STATE(1377),
    [sym_bitwise_xor_expression] = STATE(1377),
    [sym_bitwise_and_expression] = STATE(1377),
    [sym_shift_expression] = STATE(1377),
    [sym_additive_expression] = STATE(1377),
    [sym_multiplicative_expression] = STATE(1377),
    [sym__unary_expression] = STATE(1118),
    [sym_unary_expression] = STATE(1169),
    [sym__postfix_expression] = STATE(1169),
    [sym_postfix_expression] = STATE(1170),
    [sym_prefix_operator] = STATE(360),
    [sym_negation_operator] = STATE(1206),
    [sym_tilde_operator] = STATE(1188),
    [sym_await_expression] = STATE(1171),
    [sym_new_expression] = STATE(967),
    [sym_const_object_expression] = STATE(967),
    [sym__primary] = STATE(641),
    [sym_constructor_invocation] = STATE(638),
    [sym_type_arguments] = STATE(2454),
    [sym__for_loop_parts] = STATE(2587),
    [sym__annotation] = STATE(1287),
    [sym_marker_annotation] = STATE(1289),
    [sym_annotation] = STATE(1289),
    [sym__metadata] = STATE(1477),
    [sym_type_parameters] = STATE(2299),
    [sym_initialized_variable_definition] = STATE(2472),
    [sym__declared_identifier] = STATE(2075),
    [sym__final_const_var_or_type] = STATE(2686),
    [sym__type] = STATE(2200),
    [sym__type_not_function] = STATE(1616),
    [sym__type_not_void_not_function] = STATE(1668),
    [sym_function_type] = STATE(1655),
    [aux_sym__function_type_tails] = STATE(1482),
    [sym__function_type_tail] = STATE(1568),
    [sym__type_name] = STATE(1722),
    [sym__var_or_type] = STATE(2325),
    [sym_inferred_type] = STATE(1653),
    [sym__formal_parameter_part] = STATE(1915),
    [sym_formal_parameter_list] = STATE(1636),
    [sym__strict_formal_parameter_list] = STATE(1626),
    [sym_local_variable_declaration] = STATE(161),
    [sym__covariant] = STATE(1552),
    [sym__function_builtin_identifier] = STATE(1424),
    [sym__new_builtin] = STATE(1701),
    [sym__late_builtin] = STATE(1618),
    [sym_this] = STATE(967),
    [sym_super] = STATE(1128),
    [sym__semicolon] = STATE(158),
    [sym_comment] = STATE(86),
    [sym_documentation_comment] = STATE(86),
    [aux_sym_string_literal_repeat1] = STATE(473),
    [aux_sym__metadata_repeat1] = STATE(1143),
    [sym_identifier] = ACTIONS(578),
    [anon_sym_POUND] = ACTIONS(139),
    [sym_decimal_integer_literal] = ACTIONS(19),
    [sym_hex_integer_literal] = ACTIONS(21),
    [sym_decimal_floating_point_literal] = ACTIONS(19),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(25),
    [anon_sym_DQUOTE] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_r_DQUOTE] = ACTIONS(35),
    [anon_sym_r_SQUOTE] = ACTIONS(37),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(39),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(552),
    [anon_sym_LBRACK] = ACTIONS(45),
    [anon_sym_null] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_LT] = ACTIONS(53),
    [sym_increment_operator] = ACTIONS(55),
    [sym_minus_operator] = ACTIONS(57),
    [sym__exclamation_operator] = ACTIONS(59),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_await] = ACTIONS(576),
    [anon_sym_SEMI] = ACTIONS(580),
    [anon_sym_AT] = ACTIONS(83),
    [anon_sym_super] = ACTIONS(95),
    [sym_void_type] = ACTIONS(97),
    [anon_sym_var] = ACTIONS(99),
    [anon_sym_covariant] = ACTIONS(109),
    [anon_sym_Function] = ACTIONS(113),
    [anon_sym_new] = ACTIONS(125),
    [sym_const_builtin] = ACTIONS(165),
    [sym_final_builtin] = ACTIONS(167),
    [anon_sym_late] = ACTIONS(131),
    [anon_sym_this] = ACTIONS(135),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_SLASH_SLASH_SLASH] = ACTIONS(7),
    [sym__block_comment] = ACTIONS(9),
    [sym__documentation_block_comment] = ACTIONS(11),
  },
  [87] = {
    [sym__literal] = STATE(967),
    [sym_symbol_literal] = STATE(912),
    [sym_true] = STATE(912),
    [sym_false] = STATE(912),
    [sym_string_literal] = STATE(912),
    [sym__string_literal_double_quotes] = STATE(617),
    [sym__string_literal_single_quotes] = STATE(617),
    [sym__string_literal_double_quotes_multiple] = STATE(617),
    [sym__string_literal_single_quotes_multiple] = STATE(617),
    [sym__raw_string_literal_double_quotes] = STATE(617),
    [sym__raw_string_literal_single_quotes] = STATE(617),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(617),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(617),
    [sym_list_literal] = STATE(912),
    [sym_set_or_map_literal] = STATE(912),
    [sym_null_literal] = STATE(912),
    [sym__expression] = STATE(2125),
    [sym__real_expression] = STATE(670),
    [sym_throw_expression] = STATE(976),
    [sym_assignment_expression] = STATE(976),
    [sym_assignable_expression] = STATE(1582),
    [sym_function_expression] = STATE(967),
    [sym_if_null_expression] = STATE(1377),
    [sym_conditional_expression] = STATE(1377),
    [sym_logical_or_expression] = STATE(1377),
    [sym_logical_and_expression] = STATE(1377),
    [sym_equality_expression] = STATE(1377),
    [sym_type_cast_expression] = STATE(1377),
    [sym_type_test_expression] = STATE(1377),
    [sym_relational_expression] = STATE(1377),
    [sym_bitwise_or_expression] = STATE(1377),
    [sym_bitwise_xor_expression] = STATE(1377),
    [sym_bitwise_and_expression] = STATE(1377),
    [sym_shift_expression] = STATE(1377),
    [sym_additive_expression] = STATE(1377),
    [sym_multiplicative_expression] = STATE(1377),
    [sym__unary_expression] = STATE(1118),
    [sym_unary_expression] = STATE(1169),
    [sym__postfix_expression] = STATE(1169),
    [sym_postfix_expression] = STATE(1170),
    [sym_prefix_operator] = STATE(360),
    [sym_negation_operator] = STATE(1206),
    [sym_tilde_operator] = STATE(1188),
    [sym_await_expression] = STATE(1171),
    [sym_new_expression] = STATE(967),
    [sym_const_object_expression] = STATE(967),
    [sym__primary] = STATE(641),
    [sym_constructor_invocation] = STATE(638),
    [sym_type_arguments] = STATE(2454),
    [sym__for_loop_parts] = STATE(2586),
    [sym__annotation] = STATE(1287),
    [sym_marker_annotation] = STATE(1289),
    [sym_annotation] = STATE(1289),
    [sym__metadata] = STATE(1477),
    [sym_type_parameters] = STATE(2299),
    [sym_initialized_variable_definition] = STATE(2472),
    [sym__declared_identifier] = STATE(2075),
    [sym__final_const_var_or_type] = STATE(2686),
    [sym__type] = STATE(2200),
    [sym__type_not_function] = STATE(1616),
    [sym__type_not_void_not_function] = STATE(1668),
    [sym_function_type] = STATE(1655),
    [aux_sym__function_type_tails] = STATE(1482),
    [sym__function_type_tail] = STATE(1568),
    [sym__type_name] = STATE(1722),
    [sym__var_or_type] = STATE(2325),
    [sym_inferred_type] = STATE(1653),
    [sym__formal_parameter_part] = STATE(1915),
    [sym_formal_parameter_list] = STATE(1636),
    [sym__strict_formal_parameter_list] = STATE(1626),
    [sym_local_variable_declaration] = STATE(161),
    [sym__covariant] = STATE(1552),
    [sym__function_builtin_identifier] = STATE(1424),
    [sym__new_builtin] = STATE(1701),
    [sym__late_builtin] = STATE(1618),
    [sym_this] = STATE(967),
    [sym_super] = STATE(1128),
    [sym__semicolon] = STATE(158),
    [sym_comment] = STATE(87),
    [sym_documentation_comment] = STATE(87),
    [aux_sym_string_literal_repeat1] = STATE(473),
    [aux_sym__metadata_repeat1] = STATE(1143),
    [sym_identifier] = ACTIONS(578),
    [anon_sym_POUND] = ACTIONS(139),
    [sym_decimal_integer_literal] = ACTIONS(19),
    [sym_hex_integer_literal] = ACTIONS(21),
    [sym_decimal_floating_point_literal] = ACTIONS(19),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(25),
    [anon_sym_DQUOTE] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_r_DQUOTE] = ACTIONS(35),
    [anon_sym_r_SQUOTE] = ACTIONS(37),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(39),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(552),
    [anon_sym_LBRACK] = ACTIONS(45),
    [anon_sym_null] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_LT] = ACTIONS(53),
    [sym_increment_operator] = ACTIONS(55),
    [sym_minus_operator] = ACTIONS(57),
    [sym__exclamation_operator] = ACTIONS(59),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_await] = ACTIONS(576),
    [anon_sym_SEMI] = ACTIONS(580),
    [anon_sym_AT] = ACTIONS(83),
    [anon_sym_super] = ACTIONS(95),
    [sym_void_type] = ACTIONS(97),
    [anon_sym_var] = ACTIONS(99),
    [anon_sym_covariant] = ACTIONS(109),
    [anon_sym_Function] = ACTIONS(113),
    [anon_sym_new] = ACTIONS(125),
    [sym_const_builtin] = ACTIONS(165),
    [sym_final_builtin] = ACTIONS(167),
    [anon_sym_late] = ACTIONS(131),
    [anon_sym_this] = ACTIONS(135),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_SLASH_SLASH_SLASH] = ACTIONS(7),
    [sym__block_comment] = ACTIONS(9),
    [sym__documentation_block_comment] = ACTIONS(11),
  },
  [88] = {
    [sym__literal] = STATE(967),
    [sym_symbol_literal] = STATE(912),
    [sym_true] = STATE(912),
    [sym_false] = STATE(912),
    [sym_string_literal] = STATE(912),
    [sym__string_literal_double_quotes] = STATE(617),
    [sym__string_literal_single_quotes] = STATE(617),
    [sym__string_literal_double_quotes_multiple] = STATE(617),
    [sym__string_literal_single_quotes_multiple] = STATE(617),
    [sym__raw_string_literal_double_quotes] = STATE(617),
    [sym__raw_string_literal_single_quotes] = STATE(617),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(617),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(617),
    [sym_list_literal] = STATE(912),
    [sym_set_or_map_literal] = STATE(912),
    [sym_null_literal] = STATE(912),
    [sym__expression] = STATE(2125),
    [sym__real_expression] = STATE(670),
    [sym_throw_expression] = STATE(976),
    [sym_assignment_expression] = STATE(976),
    [sym_assignable_expression] = STATE(1582),
    [sym_function_expression] = STATE(967),
    [sym_if_null_expression] = STATE(1377),
    [sym_conditional_expression] = STATE(1377),
    [sym_logical_or_expression] = STATE(1377),
    [sym_logical_and_expression] = STATE(1377),
    [sym_equality_expression] = STATE(1377),
    [sym_type_cast_expression] = STATE(1377),
    [sym_type_test_expression] = STATE(1377),
    [sym_relational_expression] = STATE(1377),
    [sym_bitwise_or_expression] = STATE(1377),
    [sym_bitwise_xor_expression] = STATE(1377),
    [sym_bitwise_and_expression] = STATE(1377),
    [sym_shift_expression] = STATE(1377),
    [sym_additive_expression] = STATE(1377),
    [sym_multiplicative_expression] = STATE(1377),
    [sym__unary_expression] = STATE(1118),
    [sym_unary_expression] = STATE(1169),
    [sym__postfix_expression] = STATE(1169),
    [sym_postfix_expression] = STATE(1170),
    [sym_prefix_operator] = STATE(360),
    [sym_negation_operator] = STATE(1206),
    [sym_tilde_operator] = STATE(1188),
    [sym_await_expression] = STATE(1171),
    [sym_new_expression] = STATE(967),
    [sym_const_object_expression] = STATE(967),
    [sym__primary] = STATE(641),
    [sym_constructor_invocation] = STATE(638),
    [sym_type_arguments] = STATE(2454),
    [sym__for_loop_parts] = STATE(2655),
    [sym__annotation] = STATE(1287),
    [sym_marker_annotation] = STATE(1289),
    [sym_annotation] = STATE(1289),
    [sym__metadata] = STATE(1477),
    [sym_type_parameters] = STATE(2299),
    [sym_initialized_variable_definition] = STATE(2472),
    [sym__declared_identifier] = STATE(2075),
    [sym__final_const_var_or_type] = STATE(2686),
    [sym__type] = STATE(2200),
    [sym__type_not_function] = STATE(1616),
    [sym__type_not_void_not_function] = STATE(1668),
    [sym_function_type] = STATE(1655),
    [aux_sym__function_type_tails] = STATE(1482),
    [sym__function_type_tail] = STATE(1568),
    [sym__type_name] = STATE(1722),
    [sym__var_or_type] = STATE(2325),
    [sym_inferred_type] = STATE(1653),
    [sym__formal_parameter_part] = STATE(1915),
    [sym_formal_parameter_list] = STATE(1636),
    [sym__strict_formal_parameter_list] = STATE(1626),
    [sym_local_variable_declaration] = STATE(161),
    [sym__covariant] = STATE(1552),
    [sym__function_builtin_identifier] = STATE(1424),
    [sym__new_builtin] = STATE(1701),
    [sym__late_builtin] = STATE(1618),
    [sym_this] = STATE(967),
    [sym_super] = STATE(1128),
    [sym__semicolon] = STATE(158),
    [sym_comment] = STATE(88),
    [sym_documentation_comment] = STATE(88),
    [aux_sym_string_literal_repeat1] = STATE(473),
    [aux_sym__metadata_repeat1] = STATE(1143),
    [sym_identifier] = ACTIONS(578),
    [anon_sym_POUND] = ACTIONS(139),
    [sym_decimal_integer_literal] = ACTIONS(19),
    [sym_hex_integer_literal] = ACTIONS(21),
    [sym_decimal_floating_point_literal] = ACTIONS(19),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(25),
    [anon_sym_DQUOTE] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_r_DQUOTE] = ACTIONS(35),
    [anon_sym_r_SQUOTE] = ACTIONS(37),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(39),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(552),
    [anon_sym_LBRACK] = ACTIONS(45),
    [anon_sym_null] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_LT] = ACTIONS(53),
    [sym_increment_operator] = ACTIONS(55),
    [sym_minus_operator] = ACTIONS(57),
    [sym__exclamation_operator] = ACTIONS(59),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_await] = ACTIONS(576),
    [anon_sym_SEMI] = ACTIONS(580),
    [anon_sym_AT] = ACTIONS(83),
    [anon_sym_super] = ACTIONS(95),
    [sym_void_type] = ACTIONS(97),
    [anon_sym_var] = ACTIONS(99),
    [anon_sym_covariant] = ACTIONS(109),
    [anon_sym_Function] = ACTIONS(113),
    [anon_sym_new] = ACTIONS(125),
    [sym_const_builtin] = ACTIONS(165),
    [sym_final_builtin] = ACTIONS(167),
    [anon_sym_late] = ACTIONS(131),
    [anon_sym_this] = ACTIONS(135),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_SLASH_SLASH_SLASH] = ACTIONS(7),
    [sym__block_comment] = ACTIONS(9),
    [sym__documentation_block_comment] = ACTIONS(11),
  },
  [89] = {
    [sym__literal] = STATE(967),
    [sym_symbol_literal] = STATE(912),
    [sym_true] = STATE(912),
    [sym_false] = STATE(912),
    [sym_string_literal] = STATE(912),
    [sym__string_literal_double_quotes] = STATE(617),
    [sym__string_literal_single_quotes] = STATE(617),
    [sym__string_literal_double_quotes_multiple] = STATE(617),
    [sym__string_literal_single_quotes_multiple] = STATE(617),
    [sym__raw_string_literal_double_quotes] = STATE(617),
    [sym__raw_string_literal_single_quotes] = STATE(617),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(617),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(617),
    [sym_list_literal] = STATE(912),
    [sym_set_or_map_literal] = STATE(912),
    [sym_pair] = STATE(2134),
    [sym__element] = STATE(2256),
    [sym_null_literal] = STATE(912),
    [sym__expression] = STATE(2077),
    [sym__real_expression] = STATE(670),
    [sym_throw_expression] = STATE(976),
    [sym_assignment_expression] = STATE(976),
    [sym_assignable_expression] = STATE(1582),
    [sym_function_expression] = STATE(967),
    [sym_if_null_expression] = STATE(1377),
    [sym_conditional_expression] = STATE(1377),
    [sym_logical_or_expression] = STATE(1377),
    [sym_logical_and_expression] = STATE(1377),
    [sym_equality_expression] = STATE(1377),
    [sym_type_cast_expression] = STATE(1377),
    [sym_type_test_expression] = STATE(1377),
    [sym_relational_expression] = STATE(1377),
    [sym_bitwise_or_expression] = STATE(1377),
    [sym_bitwise_xor_expression] = STATE(1377),
    [sym_bitwise_and_expression] = STATE(1377),
    [sym_shift_expression] = STATE(1377),
    [sym_additive_expression] = STATE(1377),
    [sym_multiplicative_expression] = STATE(1377),
    [sym__unary_expression] = STATE(1118),
    [sym_unary_expression] = STATE(1169),
    [sym__postfix_expression] = STATE(1169),
    [sym_postfix_expression] = STATE(1170),
    [sym_spread_element] = STATE(2134),
    [sym_prefix_operator] = STATE(360),
    [sym_negation_operator] = STATE(1206),
    [sym_tilde_operator] = STATE(1188),
    [sym_await_expression] = STATE(1171),
    [sym_new_expression] = STATE(967),
    [sym_const_object_expression] = STATE(967),
    [sym__primary] = STATE(641),
    [sym_constructor_invocation] = STATE(638),
    [sym_type_arguments] = STATE(2454),
    [sym_if_element] = STATE(2134),
    [sym_for_element] = STATE(2134),
    [sym_type_parameters] = STATE(2299),
    [sym__type_name] = STATE(2453),
    [sym__formal_parameter_part] = STATE(1915),
    [sym_formal_parameter_list] = STATE(1636),
    [sym__strict_formal_parameter_list] = STATE(1626),
    [sym__new_builtin] = STATE(1701),
    [sym_this] = STATE(967),
    [sym_super] = STATE(1128),
    [sym_comment] = STATE(89),
    [sym_documentation_comment] = STATE(89),
    [aux_sym_string_literal_repeat1] = STATE(473),
    [sym_identifier] = ACTIONS(582),
    [anon_sym_POUND] = ACTIONS(139),
    [sym_decimal_integer_literal] = ACTIONS(19),
    [sym_hex_integer_literal] = ACTIONS(21),
    [sym_decimal_floating_point_literal] = ACTIONS(19),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(25),
    [anon_sym_DQUOTE] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_r_DQUOTE] = ACTIONS(35),
    [anon_sym_r_SQUOTE] = ACTIONS(37),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(39),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(552),
    [anon_sym_LBRACK] = ACTIONS(45),
    [anon_sym_RBRACK] = ACTIONS(584),
    [anon_sym_null] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_LT] = ACTIONS(53),
    [sym_increment_operator] = ACTIONS(55),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(155),
    [sym_minus_operator] = ACTIONS(57),
    [sym__exclamation_operator] = ACTIONS(59),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_await] = ACTIONS(556),
    [anon_sym_if] = ACTIONS(558),
    [anon_sym_for] = ACTIONS(560),
    [anon_sym_super] = ACTIONS(95),
    [anon_sym_new] = ACTIONS(125),
    [sym_const_builtin] = ACTIONS(586),
    [anon_sym_this] = ACTIONS(135),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_SLASH_SLASH_SLASH] = ACTIONS(7),
    [sym__block_comment] = ACTIONS(9),
    [sym__documentation_block_comment] = ACTIONS(11),
  },
  [90] = {
    [sym__literal] = STATE(967),
    [sym_symbol_literal] = STATE(912),
    [sym_true] = STATE(912),
    [sym_false] = STATE(912),
    [sym_string_literal] = STATE(912),
    [sym__string_literal_double_quotes] = STATE(617),
    [sym__string_literal_single_quotes] = STATE(617),
    [sym__string_literal_double_quotes_multiple] = STATE(617),
    [sym__string_literal_single_quotes_multiple] = STATE(617),
    [sym__raw_string_literal_double_quotes] = STATE(617),
    [sym__raw_string_literal_single_quotes] = STATE(617),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(617),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(617),
    [sym_list_literal] = STATE(912),
    [sym_set_or_map_literal] = STATE(912),
    [sym_pair] = STATE(2134),
    [sym__element] = STATE(2303),
    [sym_null_literal] = STATE(912),
    [sym__expression] = STATE(2077),
    [sym__real_expression] = STATE(670),
    [sym_throw_expression] = STATE(976),
    [sym_assignment_expression] = STATE(976),
    [sym_assignable_expression] = STATE(1582),
    [sym_function_expression] = STATE(967),
    [sym_if_null_expression] = STATE(1377),
    [sym_conditional_expression] = STATE(1377),
    [sym_logical_or_expression] = STATE(1377),
    [sym_logical_and_expression] = STATE(1377),
    [sym_equality_expression] = STATE(1377),
    [sym_type_cast_expression] = STATE(1377),
    [sym_type_test_expression] = STATE(1377),
    [sym_relational_expression] = STATE(1377),
    [sym_bitwise_or_expression] = STATE(1377),
    [sym_bitwise_xor_expression] = STATE(1377),
    [sym_bitwise_and_expression] = STATE(1377),
    [sym_shift_expression] = STATE(1377),
    [sym_additive_expression] = STATE(1377),
    [sym_multiplicative_expression] = STATE(1377),
    [sym__unary_expression] = STATE(1118),
    [sym_unary_expression] = STATE(1169),
    [sym__postfix_expression] = STATE(1169),
    [sym_postfix_expression] = STATE(1170),
    [sym_spread_element] = STATE(2134),
    [sym_prefix_operator] = STATE(360),
    [sym_negation_operator] = STATE(1206),
    [sym_tilde_operator] = STATE(1188),
    [sym_await_expression] = STATE(1171),
    [sym_new_expression] = STATE(967),
    [sym_const_object_expression] = STATE(967),
    [sym__primary] = STATE(641),
    [sym_constructor_invocation] = STATE(638),
    [sym_type_arguments] = STATE(2454),
    [sym_if_element] = STATE(2134),
    [sym_for_element] = STATE(2134),
    [sym_type_parameters] = STATE(2299),
    [sym__type_name] = STATE(2453),
    [sym__formal_parameter_part] = STATE(1915),
    [sym_formal_parameter_list] = STATE(1636),
    [sym__strict_formal_parameter_list] = STATE(1626),
    [sym__new_builtin] = STATE(1701),
    [sym_this] = STATE(967),
    [sym_super] = STATE(1128),
    [sym_comment] = STATE(90),
    [sym_documentation_comment] = STATE(90),
    [aux_sym_string_literal_repeat1] = STATE(473),
    [sym_identifier] = ACTIONS(582),
    [anon_sym_POUND] = ACTIONS(139),
    [sym_decimal_integer_literal] = ACTIONS(19),
    [sym_hex_integer_literal] = ACTIONS(21),
    [sym_decimal_floating_point_literal] = ACTIONS(19),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(25),
    [anon_sym_DQUOTE] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_r_DQUOTE] = ACTIONS(35),
    [anon_sym_r_SQUOTE] = ACTIONS(37),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(39),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(552),
    [anon_sym_RBRACE] = ACTIONS(588),
    [anon_sym_LBRACK] = ACTIONS(45),
    [anon_sym_null] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_LT] = ACTIONS(53),
    [sym_increment_operator] = ACTIONS(55),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(155),
    [sym_minus_operator] = ACTIONS(57),
    [sym__exclamation_operator] = ACTIONS(59),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_await] = ACTIONS(556),
    [anon_sym_if] = ACTIONS(558),
    [anon_sym_for] = ACTIONS(560),
    [anon_sym_super] = ACTIONS(95),
    [anon_sym_new] = ACTIONS(125),
    [sym_const_builtin] = ACTIONS(586),
    [anon_sym_this] = ACTIONS(135),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_SLASH_SLASH_SLASH] = ACTIONS(7),
    [sym__block_comment] = ACTIONS(9),
    [sym__documentation_block_comment] = ACTIONS(11),
  },
  [91] = {
    [sym__literal] = STATE(967),
    [sym_symbol_literal] = STATE(912),
    [sym_true] = STATE(912),
    [sym_false] = STATE(912),
    [sym_string_literal] = STATE(912),
    [sym__string_literal_double_quotes] = STATE(617),
    [sym__string_literal_single_quotes] = STATE(617),
    [sym__string_literal_double_quotes_multiple] = STATE(617),
    [sym__string_literal_single_quotes_multiple] = STATE(617),
    [sym__raw_string_literal_double_quotes] = STATE(617),
    [sym__raw_string_literal_single_quotes] = STATE(617),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(617),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(617),
    [sym_list_literal] = STATE(912),
    [sym_set_or_map_literal] = STATE(912),
    [sym_pair] = STATE(2134),
    [sym__element] = STATE(2204),
    [sym_null_literal] = STATE(912),
    [sym__expression] = STATE(2077),
    [sym__real_expression] = STATE(670),
    [sym_throw_expression] = STATE(976),
    [sym_assignment_expression] = STATE(976),
    [sym_assignable_expression] = STATE(1582),
    [sym_function_expression] = STATE(967),
    [sym_if_null_expression] = STATE(1377),
    [sym_conditional_expression] = STATE(1377),
    [sym_logical_or_expression] = STATE(1377),
    [sym_logical_and_expression] = STATE(1377),
    [sym_equality_expression] = STATE(1377),
    [sym_type_cast_expression] = STATE(1377),
    [sym_type_test_expression] = STATE(1377),
    [sym_relational_expression] = STATE(1377),
    [sym_bitwise_or_expression] = STATE(1377),
    [sym_bitwise_xor_expression] = STATE(1377),
    [sym_bitwise_and_expression] = STATE(1377),
    [sym_shift_expression] = STATE(1377),
    [sym_additive_expression] = STATE(1377),
    [sym_multiplicative_expression] = STATE(1377),
    [sym__unary_expression] = STATE(1118),
    [sym_unary_expression] = STATE(1169),
    [sym__postfix_expression] = STATE(1169),
    [sym_postfix_expression] = STATE(1170),
    [sym_spread_element] = STATE(2134),
    [sym_prefix_operator] = STATE(360),
    [sym_negation_operator] = STATE(1206),
    [sym_tilde_operator] = STATE(1188),
    [sym_await_expression] = STATE(1171),
    [sym_new_expression] = STATE(967),
    [sym_const_object_expression] = STATE(967),
    [sym__primary] = STATE(641),
    [sym_constructor_invocation] = STATE(638),
    [sym_type_arguments] = STATE(2454),
    [sym_if_element] = STATE(2134),
    [sym_for_element] = STATE(2134),
    [sym_type_parameters] = STATE(2299),
    [sym__type_name] = STATE(2453),
    [sym__formal_parameter_part] = STATE(1915),
    [sym_formal_parameter_list] = STATE(1636),
    [sym__strict_formal_parameter_list] = STATE(1626),
    [sym__new_builtin] = STATE(1701),
    [sym_this] = STATE(967),
    [sym_super] = STATE(1128),
    [sym_comment] = STATE(91),
    [sym_documentation_comment] = STATE(91),
    [aux_sym_string_literal_repeat1] = STATE(473),
    [sym_identifier] = ACTIONS(582),
    [anon_sym_POUND] = ACTIONS(139),
    [sym_decimal_integer_literal] = ACTIONS(19),
    [sym_hex_integer_literal] = ACTIONS(21),
    [sym_decimal_floating_point_literal] = ACTIONS(19),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(25),
    [anon_sym_DQUOTE] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_r_DQUOTE] = ACTIONS(35),
    [anon_sym_r_SQUOTE] = ACTIONS(37),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(39),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(552),
    [anon_sym_RBRACE] = ACTIONS(590),
    [anon_sym_LBRACK] = ACTIONS(45),
    [anon_sym_null] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_LT] = ACTIONS(53),
    [sym_increment_operator] = ACTIONS(55),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(155),
    [sym_minus_operator] = ACTIONS(57),
    [sym__exclamation_operator] = ACTIONS(59),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_await] = ACTIONS(556),
    [anon_sym_if] = ACTIONS(558),
    [anon_sym_for] = ACTIONS(560),
    [anon_sym_super] = ACTIONS(95),
    [anon_sym_new] = ACTIONS(125),
    [sym_const_builtin] = ACTIONS(586),
    [anon_sym_this] = ACTIONS(135),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_SLASH_SLASH_SLASH] = ACTIONS(7),
    [sym__block_comment] = ACTIONS(9),
    [sym__documentation_block_comment] = ACTIONS(11),
  },
  [92] = {
    [sym__literal] = STATE(967),
    [sym_symbol_literal] = STATE(912),
    [sym_true] = STATE(912),
    [sym_false] = STATE(912),
    [sym_string_literal] = STATE(912),
    [sym__string_literal_double_quotes] = STATE(617),
    [sym__string_literal_single_quotes] = STATE(617),
    [sym__string_literal_double_quotes_multiple] = STATE(617),
    [sym__string_literal_single_quotes_multiple] = STATE(617),
    [sym__raw_string_literal_double_quotes] = STATE(617),
    [sym__raw_string_literal_single_quotes] = STATE(617),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(617),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(617),
    [sym_list_literal] = STATE(912),
    [sym_set_or_map_literal] = STATE(912),
    [sym_pair] = STATE(2134),
    [sym__element] = STATE(2204),
    [sym_null_literal] = STATE(912),
    [sym__expression] = STATE(2077),
    [sym__real_expression] = STATE(670),
    [sym_throw_expression] = STATE(976),
    [sym_assignment_expression] = STATE(976),
    [sym_assignable_expression] = STATE(1582),
    [sym_function_expression] = STATE(967),
    [sym_if_null_expression] = STATE(1377),
    [sym_conditional_expression] = STATE(1377),
    [sym_logical_or_expression] = STATE(1377),
    [sym_logical_and_expression] = STATE(1377),
    [sym_equality_expression] = STATE(1377),
    [sym_type_cast_expression] = STATE(1377),
    [sym_type_test_expression] = STATE(1377),
    [sym_relational_expression] = STATE(1377),
    [sym_bitwise_or_expression] = STATE(1377),
    [sym_bitwise_xor_expression] = STATE(1377),
    [sym_bitwise_and_expression] = STATE(1377),
    [sym_shift_expression] = STATE(1377),
    [sym_additive_expression] = STATE(1377),
    [sym_multiplicative_expression] = STATE(1377),
    [sym__unary_expression] = STATE(1118),
    [sym_unary_expression] = STATE(1169),
    [sym__postfix_expression] = STATE(1169),
    [sym_postfix_expression] = STATE(1170),
    [sym_spread_element] = STATE(2134),
    [sym_prefix_operator] = STATE(360),
    [sym_negation_operator] = STATE(1206),
    [sym_tilde_operator] = STATE(1188),
    [sym_await_expression] = STATE(1171),
    [sym_new_expression] = STATE(967),
    [sym_const_object_expression] = STATE(967),
    [sym__primary] = STATE(641),
    [sym_constructor_invocation] = STATE(638),
    [sym_type_arguments] = STATE(2454),
    [sym_if_element] = STATE(2134),
    [sym_for_element] = STATE(2134),
    [sym_type_parameters] = STATE(2299),
    [sym__type_name] = STATE(2453),
    [sym__formal_parameter_part] = STATE(1915),
    [sym_formal_parameter_list] = STATE(1636),
    [sym__strict_formal_parameter_list] = STATE(1626),
    [sym__new_builtin] = STATE(1701),
    [sym_this] = STATE(967),
    [sym_super] = STATE(1128),
    [sym_comment] = STATE(92),
    [sym_documentation_comment] = STATE(92),
    [aux_sym_string_literal_repeat1] = STATE(473),
    [sym_identifier] = ACTIONS(582),
    [anon_sym_POUND] = ACTIONS(139),
    [sym_decimal_integer_literal] = ACTIONS(19),
    [sym_hex_integer_literal] = ACTIONS(21),
    [sym_decimal_floating_point_literal] = ACTIONS(19),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(25),
    [anon_sym_DQUOTE] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_r_DQUOTE] = ACTIONS(35),
    [anon_sym_r_SQUOTE] = ACTIONS(37),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(39),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(552),
    [anon_sym_LBRACK] = ACTIONS(45),
    [anon_sym_RBRACK] = ACTIONS(592),
    [anon_sym_null] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_LT] = ACTIONS(53),
    [sym_increment_operator] = ACTIONS(55),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(155),
    [sym_minus_operator] = ACTIONS(57),
    [sym__exclamation_operator] = ACTIONS(59),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_await] = ACTIONS(556),
    [anon_sym_if] = ACTIONS(558),
    [anon_sym_for] = ACTIONS(560),
    [anon_sym_super] = ACTIONS(95),
    [anon_sym_new] = ACTIONS(125),
    [sym_const_builtin] = ACTIONS(586),
    [anon_sym_this] = ACTIONS(135),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_SLASH_SLASH_SLASH] = ACTIONS(7),
    [sym__block_comment] = ACTIONS(9),
    [sym__documentation_block_comment] = ACTIONS(11),
  },
  [93] = {
    [sym__literal] = STATE(967),
    [sym_symbol_literal] = STATE(912),
    [sym_true] = STATE(912),
    [sym_false] = STATE(912),
    [sym_string_literal] = STATE(912),
    [sym__string_literal_double_quotes] = STATE(617),
    [sym__string_literal_single_quotes] = STATE(617),
    [sym__string_literal_double_quotes_multiple] = STATE(617),
    [sym__string_literal_single_quotes_multiple] = STATE(617),
    [sym__raw_string_literal_double_quotes] = STATE(617),
    [sym__raw_string_literal_single_quotes] = STATE(617),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(617),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(617),
    [sym_list_literal] = STATE(912),
    [sym_set_or_map_literal] = STATE(912),
    [sym_pair] = STATE(2134),
    [sym__element] = STATE(2204),
    [sym_null_literal] = STATE(912),
    [sym__expression] = STATE(2077),
    [sym__real_expression] = STATE(670),
    [sym_throw_expression] = STATE(976),
    [sym_assignment_expression] = STATE(976),
    [sym_assignable_expression] = STATE(1582),
    [sym_function_expression] = STATE(967),
    [sym_if_null_expression] = STATE(1377),
    [sym_conditional_expression] = STATE(1377),
    [sym_logical_or_expression] = STATE(1377),
    [sym_logical_and_expression] = STATE(1377),
    [sym_equality_expression] = STATE(1377),
    [sym_type_cast_expression] = STATE(1377),
    [sym_type_test_expression] = STATE(1377),
    [sym_relational_expression] = STATE(1377),
    [sym_bitwise_or_expression] = STATE(1377),
    [sym_bitwise_xor_expression] = STATE(1377),
    [sym_bitwise_and_expression] = STATE(1377),
    [sym_shift_expression] = STATE(1377),
    [sym_additive_expression] = STATE(1377),
    [sym_multiplicative_expression] = STATE(1377),
    [sym__unary_expression] = STATE(1118),
    [sym_unary_expression] = STATE(1169),
    [sym__postfix_expression] = STATE(1169),
    [sym_postfix_expression] = STATE(1170),
    [sym_spread_element] = STATE(2134),
    [sym_prefix_operator] = STATE(360),
    [sym_negation_operator] = STATE(1206),
    [sym_tilde_operator] = STATE(1188),
    [sym_await_expression] = STATE(1171),
    [sym_new_expression] = STATE(967),
    [sym_const_object_expression] = STATE(967),
    [sym__primary] = STATE(641),
    [sym_constructor_invocation] = STATE(638),
    [sym_type_arguments] = STATE(2454),
    [sym_if_element] = STATE(2134),
    [sym_for_element] = STATE(2134),
    [sym_type_parameters] = STATE(2299),
    [sym__type_name] = STATE(2453),
    [sym__formal_parameter_part] = STATE(1915),
    [sym_formal_parameter_list] = STATE(1636),
    [sym__strict_formal_parameter_list] = STATE(1626),
    [sym__new_builtin] = STATE(1701),
    [sym_this] = STATE(967),
    [sym_super] = STATE(1128),
    [sym_comment] = STATE(93),
    [sym_documentation_comment] = STATE(93),
    [aux_sym_string_literal_repeat1] = STATE(473),
    [sym_identifier] = ACTIONS(582),
    [anon_sym_POUND] = ACTIONS(139),
    [sym_decimal_integer_literal] = ACTIONS(19),
    [sym_hex_integer_literal] = ACTIONS(21),
    [sym_decimal_floating_point_literal] = ACTIONS(19),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(25),
    [anon_sym_DQUOTE] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_r_DQUOTE] = ACTIONS(35),
    [anon_sym_r_SQUOTE] = ACTIONS(37),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(39),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(552),
    [anon_sym_RBRACE] = ACTIONS(594),
    [anon_sym_LBRACK] = ACTIONS(45),
    [anon_sym_null] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_LT] = ACTIONS(53),
    [sym_increment_operator] = ACTIONS(55),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(155),
    [sym_minus_operator] = ACTIONS(57),
    [sym__exclamation_operator] = ACTIONS(59),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_await] = ACTIONS(556),
    [anon_sym_if] = ACTIONS(558),
    [anon_sym_for] = ACTIONS(560),
    [anon_sym_super] = ACTIONS(95),
    [anon_sym_new] = ACTIONS(125),
    [sym_const_builtin] = ACTIONS(586),
    [anon_sym_this] = ACTIONS(135),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_SLASH_SLASH_SLASH] = ACTIONS(7),
    [sym__block_comment] = ACTIONS(9),
    [sym__documentation_block_comment] = ACTIONS(11),
  },
  [94] = {
    [sym__literal] = STATE(967),
    [sym_symbol_literal] = STATE(912),
    [sym_true] = STATE(912),
    [sym_false] = STATE(912),
    [sym_string_literal] = STATE(912),
    [sym__string_literal_double_quotes] = STATE(617),
    [sym__string_literal_single_quotes] = STATE(617),
    [sym__string_literal_double_quotes_multiple] = STATE(617),
    [sym__string_literal_single_quotes_multiple] = STATE(617),
    [sym__raw_string_literal_double_quotes] = STATE(617),
    [sym__raw_string_literal_single_quotes] = STATE(617),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(617),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(617),
    [sym_list_literal] = STATE(912),
    [sym_set_or_map_literal] = STATE(912),
    [sym_pair] = STATE(2134),
    [sym__element] = STATE(2204),
    [sym_null_literal] = STATE(912),
    [sym__expression] = STATE(2077),
    [sym__real_expression] = STATE(670),
    [sym_throw_expression] = STATE(976),
    [sym_assignment_expression] = STATE(976),
    [sym_assignable_expression] = STATE(1582),
    [sym_function_expression] = STATE(967),
    [sym_if_null_expression] = STATE(1377),
    [sym_conditional_expression] = STATE(1377),
    [sym_logical_or_expression] = STATE(1377),
    [sym_logical_and_expression] = STATE(1377),
    [sym_equality_expression] = STATE(1377),
    [sym_type_cast_expression] = STATE(1377),
    [sym_type_test_expression] = STATE(1377),
    [sym_relational_expression] = STATE(1377),
    [sym_bitwise_or_expression] = STATE(1377),
    [sym_bitwise_xor_expression] = STATE(1377),
    [sym_bitwise_and_expression] = STATE(1377),
    [sym_shift_expression] = STATE(1377),
    [sym_additive_expression] = STATE(1377),
    [sym_multiplicative_expression] = STATE(1377),
    [sym__unary_expression] = STATE(1118),
    [sym_unary_expression] = STATE(1169),
    [sym__postfix_expression] = STATE(1169),
    [sym_postfix_expression] = STATE(1170),
    [sym_spread_element] = STATE(2134),
    [sym_prefix_operator] = STATE(360),
    [sym_negation_operator] = STATE(1206),
    [sym_tilde_operator] = STATE(1188),
    [sym_await_expression] = STATE(1171),
    [sym_new_expression] = STATE(967),
    [sym_const_object_expression] = STATE(967),
    [sym__primary] = STATE(641),
    [sym_constructor_invocation] = STATE(638),
    [sym_type_arguments] = STATE(2454),
    [sym_if_element] = STATE(2134),
    [sym_for_element] = STATE(2134),
    [sym_type_parameters] = STATE(2299),
    [sym__type_name] = STATE(2453),
    [sym__formal_parameter_part] = STATE(1915),
    [sym_formal_parameter_list] = STATE(1636),
    [sym__strict_formal_parameter_list] = STATE(1626),
    [sym__new_builtin] = STATE(1701),
    [sym_this] = STATE(967),
    [sym_super] = STATE(1128),
    [sym_comment] = STATE(94),
    [sym_documentation_comment] = STATE(94),
    [aux_sym_string_literal_repeat1] = STATE(473),
    [sym_identifier] = ACTIONS(582),
    [anon_sym_POUND] = ACTIONS(139),
    [sym_decimal_integer_literal] = ACTIONS(19),
    [sym_hex_integer_literal] = ACTIONS(21),
    [sym_decimal_floating_point_literal] = ACTIONS(19),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(25),
    [anon_sym_DQUOTE] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_r_DQUOTE] = ACTIONS(35),
    [anon_sym_r_SQUOTE] = ACTIONS(37),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(39),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(552),
    [anon_sym_RBRACE] = ACTIONS(596),
    [anon_sym_LBRACK] = ACTIONS(45),
    [anon_sym_null] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_LT] = ACTIONS(53),
    [sym_increment_operator] = ACTIONS(55),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(155),
    [sym_minus_operator] = ACTIONS(57),
    [sym__exclamation_operator] = ACTIONS(59),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_await] = ACTIONS(556),
    [anon_sym_if] = ACTIONS(558),
    [anon_sym_for] = ACTIONS(560),
    [anon_sym_super] = ACTIONS(95),
    [anon_sym_new] = ACTIONS(125),
    [sym_const_builtin] = ACTIONS(586),
    [anon_sym_this] = ACTIONS(135),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_SLASH_SLASH_SLASH] = ACTIONS(7),
    [sym__block_comment] = ACTIONS(9),
    [sym__documentation_block_comment] = ACTIONS(11),
  },
  [95] = {
    [sym__literal] = STATE(967),
    [sym_symbol_literal] = STATE(912),
    [sym_true] = STATE(912),
    [sym_false] = STATE(912),
    [sym_string_literal] = STATE(912),
    [sym__string_literal_double_quotes] = STATE(617),
    [sym__string_literal_single_quotes] = STATE(617),
    [sym__string_literal_double_quotes_multiple] = STATE(617),
    [sym__string_literal_single_quotes_multiple] = STATE(617),
    [sym__raw_string_literal_double_quotes] = STATE(617),
    [sym__raw_string_literal_single_quotes] = STATE(617),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(617),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(617),
    [sym_list_literal] = STATE(912),
    [sym_set_or_map_literal] = STATE(912),
    [sym_pair] = STATE(2134),
    [sym__element] = STATE(2204),
    [sym_null_literal] = STATE(912),
    [sym__expression] = STATE(2077),
    [sym__real_expression] = STATE(670),
    [sym_throw_expression] = STATE(976),
    [sym_assignment_expression] = STATE(976),
    [sym_assignable_expression] = STATE(1582),
    [sym_function_expression] = STATE(967),
    [sym_if_null_expression] = STATE(1377),
    [sym_conditional_expression] = STATE(1377),
    [sym_logical_or_expression] = STATE(1377),
    [sym_logical_and_expression] = STATE(1377),
    [sym_equality_expression] = STATE(1377),
    [sym_type_cast_expression] = STATE(1377),
    [sym_type_test_expression] = STATE(1377),
    [sym_relational_expression] = STATE(1377),
    [sym_bitwise_or_expression] = STATE(1377),
    [sym_bitwise_xor_expression] = STATE(1377),
    [sym_bitwise_and_expression] = STATE(1377),
    [sym_shift_expression] = STATE(1377),
    [sym_additive_expression] = STATE(1377),
    [sym_multiplicative_expression] = STATE(1377),
    [sym__unary_expression] = STATE(1118),
    [sym_unary_expression] = STATE(1169),
    [sym__postfix_expression] = STATE(1169),
    [sym_postfix_expression] = STATE(1170),
    [sym_spread_element] = STATE(2134),
    [sym_prefix_operator] = STATE(360),
    [sym_negation_operator] = STATE(1206),
    [sym_tilde_operator] = STATE(1188),
    [sym_await_expression] = STATE(1171),
    [sym_new_expression] = STATE(967),
    [sym_const_object_expression] = STATE(967),
    [sym__primary] = STATE(641),
    [sym_constructor_invocation] = STATE(638),
    [sym_type_arguments] = STATE(2454),
    [sym_if_element] = STATE(2134),
    [sym_for_element] = STATE(2134),
    [sym_type_parameters] = STATE(2299),
    [sym__type_name] = STATE(2453),
    [sym__formal_parameter_part] = STATE(1915),
    [sym_formal_parameter_list] = STATE(1636),
    [sym__strict_formal_parameter_list] = STATE(1626),
    [sym__new_builtin] = STATE(1701),
    [sym_this] = STATE(967),
    [sym_super] = STATE(1128),
    [sym_comment] = STATE(95),
    [sym_documentation_comment] = STATE(95),
    [aux_sym_string_literal_repeat1] = STATE(473),
    [sym_identifier] = ACTIONS(582),
    [anon_sym_POUND] = ACTIONS(139),
    [sym_decimal_integer_literal] = ACTIONS(19),
    [sym_hex_integer_literal] = ACTIONS(21),
    [sym_decimal_floating_point_literal] = ACTIONS(19),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(25),
    [anon_sym_DQUOTE] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_r_DQUOTE] = ACTIONS(35),
    [anon_sym_r_SQUOTE] = ACTIONS(37),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(39),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(552),
    [anon_sym_LBRACK] = ACTIONS(45),
    [anon_sym_RBRACK] = ACTIONS(598),
    [anon_sym_null] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_LT] = ACTIONS(53),
    [sym_increment_operator] = ACTIONS(55),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(155),
    [sym_minus_operator] = ACTIONS(57),
    [sym__exclamation_operator] = ACTIONS(59),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_await] = ACTIONS(556),
    [anon_sym_if] = ACTIONS(558),
    [anon_sym_for] = ACTIONS(560),
    [anon_sym_super] = ACTIONS(95),
    [anon_sym_new] = ACTIONS(125),
    [sym_const_builtin] = ACTIONS(586),
    [anon_sym_this] = ACTIONS(135),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_SLASH_SLASH_SLASH] = ACTIONS(7),
    [sym__block_comment] = ACTIONS(9),
    [sym__documentation_block_comment] = ACTIONS(11),
  },
  [96] = {
    [sym__literal] = STATE(967),
    [sym_symbol_literal] = STATE(912),
    [sym_true] = STATE(912),
    [sym_false] = STATE(912),
    [sym_string_literal] = STATE(912),
    [sym__string_literal_double_quotes] = STATE(617),
    [sym__string_literal_single_quotes] = STATE(617),
    [sym__string_literal_double_quotes_multiple] = STATE(617),
    [sym__string_literal_single_quotes_multiple] = STATE(617),
    [sym__raw_string_literal_double_quotes] = STATE(617),
    [sym__raw_string_literal_single_quotes] = STATE(617),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(617),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(617),
    [sym_list_literal] = STATE(912),
    [sym_set_or_map_literal] = STATE(912),
    [sym_pair] = STATE(2134),
    [sym__element] = STATE(2188),
    [sym_null_literal] = STATE(912),
    [sym__expression] = STATE(2077),
    [sym__real_expression] = STATE(670),
    [sym_throw_expression] = STATE(976),
    [sym_assignment_expression] = STATE(976),
    [sym_assignable_expression] = STATE(1582),
    [sym_function_expression] = STATE(967),
    [sym_if_null_expression] = STATE(1377),
    [sym_conditional_expression] = STATE(1377),
    [sym_logical_or_expression] = STATE(1377),
    [sym_logical_and_expression] = STATE(1377),
    [sym_equality_expression] = STATE(1377),
    [sym_type_cast_expression] = STATE(1377),
    [sym_type_test_expression] = STATE(1377),
    [sym_relational_expression] = STATE(1377),
    [sym_bitwise_or_expression] = STATE(1377),
    [sym_bitwise_xor_expression] = STATE(1377),
    [sym_bitwise_and_expression] = STATE(1377),
    [sym_shift_expression] = STATE(1377),
    [sym_additive_expression] = STATE(1377),
    [sym_multiplicative_expression] = STATE(1377),
    [sym__unary_expression] = STATE(1118),
    [sym_unary_expression] = STATE(1169),
    [sym__postfix_expression] = STATE(1169),
    [sym_postfix_expression] = STATE(1170),
    [sym_spread_element] = STATE(2134),
    [sym_prefix_operator] = STATE(360),
    [sym_negation_operator] = STATE(1206),
    [sym_tilde_operator] = STATE(1188),
    [sym_await_expression] = STATE(1171),
    [sym_new_expression] = STATE(967),
    [sym_const_object_expression] = STATE(967),
    [sym__primary] = STATE(641),
    [sym_constructor_invocation] = STATE(638),
    [sym_type_arguments] = STATE(2454),
    [sym_if_element] = STATE(2134),
    [sym_for_element] = STATE(2134),
    [sym_type_parameters] = STATE(2299),
    [sym__type_name] = STATE(2453),
    [sym__formal_parameter_part] = STATE(1915),
    [sym_formal_parameter_list] = STATE(1636),
    [sym__strict_formal_parameter_list] = STATE(1626),
    [sym__new_builtin] = STATE(1701),
    [sym_this] = STATE(967),
    [sym_super] = STATE(1128),
    [sym_comment] = STATE(96),
    [sym_documentation_comment] = STATE(96),
    [aux_sym_string_literal_repeat1] = STATE(473),
    [sym_identifier] = ACTIONS(582),
    [anon_sym_POUND] = ACTIONS(139),
    [sym_decimal_integer_literal] = ACTIONS(19),
    [sym_hex_integer_literal] = ACTIONS(21),
    [sym_decimal_floating_point_literal] = ACTIONS(19),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(25),
    [anon_sym_DQUOTE] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_r_DQUOTE] = ACTIONS(35),
    [anon_sym_r_SQUOTE] = ACTIONS(37),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(39),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(552),
    [anon_sym_RBRACE] = ACTIONS(554),
    [anon_sym_LBRACK] = ACTIONS(45),
    [anon_sym_null] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_LT] = ACTIONS(53),
    [sym_increment_operator] = ACTIONS(55),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(155),
    [sym_minus_operator] = ACTIONS(57),
    [sym__exclamation_operator] = ACTIONS(59),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_await] = ACTIONS(556),
    [anon_sym_if] = ACTIONS(558),
    [anon_sym_for] = ACTIONS(560),
    [anon_sym_super] = ACTIONS(95),
    [anon_sym_new] = ACTIONS(125),
    [sym_const_builtin] = ACTIONS(586),
    [anon_sym_this] = ACTIONS(135),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_SLASH_SLASH_SLASH] = ACTIONS(7),
    [sym__block_comment] = ACTIONS(9),
    [sym__documentation_block_comment] = ACTIONS(11),
  },
  [97] = {
    [sym__literal] = STATE(967),
    [sym_symbol_literal] = STATE(912),
    [sym_true] = STATE(912),
    [sym_false] = STATE(912),
    [sym_string_literal] = STATE(912),
    [sym__string_literal_double_quotes] = STATE(617),
    [sym__string_literal_single_quotes] = STATE(617),
    [sym__string_literal_double_quotes_multiple] = STATE(617),
    [sym__string_literal_single_quotes_multiple] = STATE(617),
    [sym__raw_string_literal_double_quotes] = STATE(617),
    [sym__raw_string_literal_single_quotes] = STATE(617),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(617),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(617),
    [sym_list_literal] = STATE(912),
    [sym_set_or_map_literal] = STATE(912),
    [sym_pair] = STATE(2134),
    [sym__element] = STATE(2204),
    [sym_null_literal] = STATE(912),
    [sym__expression] = STATE(2077),
    [sym__real_expression] = STATE(670),
    [sym_throw_expression] = STATE(976),
    [sym_assignment_expression] = STATE(976),
    [sym_assignable_expression] = STATE(1582),
    [sym_function_expression] = STATE(967),
    [sym_if_null_expression] = STATE(1377),
    [sym_conditional_expression] = STATE(1377),
    [sym_logical_or_expression] = STATE(1377),
    [sym_logical_and_expression] = STATE(1377),
    [sym_equality_expression] = STATE(1377),
    [sym_type_cast_expression] = STATE(1377),
    [sym_type_test_expression] = STATE(1377),
    [sym_relational_expression] = STATE(1377),
    [sym_bitwise_or_expression] = STATE(1377),
    [sym_bitwise_xor_expression] = STATE(1377),
    [sym_bitwise_and_expression] = STATE(1377),
    [sym_shift_expression] = STATE(1377),
    [sym_additive_expression] = STATE(1377),
    [sym_multiplicative_expression] = STATE(1377),
    [sym__unary_expression] = STATE(1118),
    [sym_unary_expression] = STATE(1169),
    [sym__postfix_expression] = STATE(1169),
    [sym_postfix_expression] = STATE(1170),
    [sym_spread_element] = STATE(2134),
    [sym_prefix_operator] = STATE(360),
    [sym_negation_operator] = STATE(1206),
    [sym_tilde_operator] = STATE(1188),
    [sym_await_expression] = STATE(1171),
    [sym_new_expression] = STATE(967),
    [sym_const_object_expression] = STATE(967),
    [sym__primary] = STATE(641),
    [sym_constructor_invocation] = STATE(638),
    [sym_type_arguments] = STATE(2454),
    [sym_if_element] = STATE(2134),
    [sym_for_element] = STATE(2134),
    [sym_type_parameters] = STATE(2299),
    [sym__type_name] = STATE(2453),
    [sym__formal_parameter_part] = STATE(1915),
    [sym_formal_parameter_list] = STATE(1636),
    [sym__strict_formal_parameter_list] = STATE(1626),
    [sym__new_builtin] = STATE(1701),
    [sym_this] = STATE(967),
    [sym_super] = STATE(1128),
    [sym_comment] = STATE(97),
    [sym_documentation_comment] = STATE(97),
    [aux_sym_string_literal_repeat1] = STATE(473),
    [sym_identifier] = ACTIONS(582),
    [anon_sym_POUND] = ACTIONS(139),
    [sym_decimal_integer_literal] = ACTIONS(19),
    [sym_hex_integer_literal] = ACTIONS(21),
    [sym_decimal_floating_point_literal] = ACTIONS(19),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(25),
    [anon_sym_DQUOTE] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_r_DQUOTE] = ACTIONS(35),
    [anon_sym_r_SQUOTE] = ACTIONS(37),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(39),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(552),
    [anon_sym_LBRACK] = ACTIONS(45),
    [anon_sym_RBRACK] = ACTIONS(600),
    [anon_sym_null] = ACTIONS(47),
    [anon_sym_throw] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_LT] = ACTIONS(53),
    [sym_increment_operator] = ACTIONS(55),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(155),
    [sym_minus_operator] = ACTIONS(57),
    [sym__exclamation_operator] = ACTIONS(59),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_await] = ACTIONS(556),
    [anon_sym_if] = ACTIONS(558),
    [anon_sym_for] = ACTIONS(560),
    [anon_sym_super] = ACTIONS(95),
    [anon_sym_new] = ACTIONS(125),
    [sym_const_builtin] = ACTIONS(586),
    [anon_sym_this] = ACTIONS(135),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_SLASH_SLASH_SLASH] = ACTIONS(7),
    [sym__block_comment] = ACTIONS(9),
    [sym__documentation_block_comment] = ACTIONS(11),
  },
  [98] = {
    [sym__literal] = STATE(967),
    [sym_symbol_literal] = STATE(912),
    [sym_true] = STATE(912),
    [sym_false] = STATE(912),
    [sym_string_literal] = STATE(912),
    [sym__string_literal_double_quotes] = STATE(617),
    [sym__string_literal_single_quotes] = STATE(617),
    [sym__string_literal_double_quotes_multiple] = STATE(617),
    [sym__string_literal_single_quotes_multiple] = STATE(617),
    [sym__raw_string_literal_double_quotes] = STATE(617),
    [sym__raw_string_literal_single_quotes] = STATE(617),
    [sym__raw_string_literal_double_quotes_multiple] = STATE(617),
    [sym__raw_string_literal_single_quotes_multiple] = STATE(617),
    [sym_list_literal] = STATE(912),
    [sym_set_or_map_literal] = STATE(912),
    [sym_pair] = STATE(2134),
    [sym__element] = STATE(2234),
    [sym_null_literal] = STATE(912),
    [sym__expression] = STATE(2077),
    [sym__real_expression] = STATE(670),
    [sym_throw_expression] = STATE(976),
    [sym_assignment_expression] = STATE(976),
    [sym_assignable_expression] = STATE(1582),
    [sym_function_expression] = STATE(967),
    [sym_if_null_expression] = STATE(1377),
    [sym_conditional_expression] = STATE(1377),
    [sym_logical_or_expression] = STATE(1377),
    [sym_logical_and_expression] = STATE(1377),
    [sym_equality_expression] = STATE(1377),
    [sym_type_cast_expression] = STATE(1377),
    [sym_type_test_expression] = STATE(1377),
    [sym_relational_expression] = STATE(1377),
    [sym_bitwise_or_expression] = STATE(1377),
    [sym_bitwise_xor_expression] = STATE(1377),
    [sym_bitwise_and_expression] = STATE(1377),
    [sym_shift_expression] = STATE(1377),
    [sym_additive_expression] = STATE(1377),
    [sym_multiplicative_expression] = STATE(1377),
    [sym__unary_expression] = STATE(1118),
    [sym_unary_expression] = STATE(1169),
    [sym__postfix_expression] = STATE(1169),
    [sym_postfix_expression] = STATE(1170),
    [sym_spread_element] = STATE(2134),
    [sym_prefix_operator] = STATE(360),
    [sym_negation_operator] = STATE(1206),
    [sym_tilde_operator] = STATE(1188),
    [sym_await_expression] = STATE(1171),
    [sym_new_expression] = STATE(967),
    [sym_const_object_expression] = STATE(967),
    [sym__primary] = STATE(641),
    [sym_constructor_invocation] = STATE(638),
    [sym_type_arguments] = STATE(2454),
    [sym_if_element] = STATE(2134),
    [sym_for_element] = STATE(2134),
    [sym_type_parameters] = STATE(2299),
    [sym__type_name] = STATE(2453),
    [sym__formal_parameter_part] = STATE(1915),
    [sym_formal_parameter_list] = STATE(1636),
    [sym__strict_formal_parameter_list] = STATE(1626),
    [sym__new_builtin] = STATE(1701),
    [sym_this] = STATE(967),
    [sym_super] = STATE(1128),
    [sym_comment] = STATE(98),
    [sym_documentation_comment] = STATE(98),
    [aux_sym_string_literal_repeat1] = STATE(473),
    [sym_identifier] = ACTIONS(582),
    [anon_sym_POUND] = ACTIONS(139),
    [sym_decimal_integer_literal] = ACTIONS(19),
    [sym_hex_integer_literal] = ACTIONS(21),
    [sym_decimal_floating_point_literal] = ACTIONS(19),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(25),
    [anon_sym_DQUOTE] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(31),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(33),
    [anon_sym_r_DQUOTE] = ACTIONS(35),
    [anon_sym_r_SQUOTE] = ACTIONS(37),
    [anon_sym_r_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(39),
    [anon_sym_r_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(41),
    [anon_sym_LBRACE] = A