# 0.0.22

**Version:** 0.0.22
**Published:** 2023-10-15T16:38:31Z

## Release Notes

📦 **Rust Coreutils 0.0.22 Release:**

We've got +11 more GNU tests passing than in our last release.
This release also adds support for NetBSD and requires a minimum Rust version of 1.70. 🛠️
We are also collaborating more and more with the [nushell](https://github.com/nushell/nushell/) team. Future versions of nushell will rely on the Rust Coreutils.
24 developers contributed to this release (11 new contributors started with this release).

Visit our website at [https://uutils.github.io](https://uutils.github.io).

If you want to help us, please consider sponsoring on GitHub. This helps us use better tools like GitHub Actions. Sponsor us at [https://github.com/sponsors/uutils](https://github.com/sponsors/uutils).

## GNU test suite compatibility

Here's how version 0.0.22 compares to the previous release - running GNU/Coreutils 9.4:

| result | 0.0.21 | 0.0.22 | change |
|--------|-------:|-------:|------:|
| pass   |    372 |    383 |  +11  |
| skip   |     49 |     48 |   -1  |
| fail   |    181 |    171 |  -10  |
| error  |      2 |      2 |    0  |

![GNU testsuite evolution](https://github.com/uutils/coreutils-tracking/blob/main/gnu-results.png?raw=true)

For more details, visit [https://github.com/uutils/coreutils-tracking/](https://github.com/uutils/coreutils-tracking/).

## What's Changed
* Bump MSRV to 1.70 by @cakebaker in https://github.com/uutils/coreutils/pull/5239

### chown
* chown: move uid & gid detections into their own functions by @sylvestre in https://github.com/uutils/coreutils/pull/5359

### cp
* cp: Error out if cp only contains source by @dmatos2012 in https://github.com/uutils/coreutils/pull/5253
* cp: fix the result of inodes are not the same when preserve links is flagged by @tommady in https://github.com/uutils/coreutils/pull/5064
* cp: fix cp -dR --no-preserve=links d c should have different inodes by @tommady in https://github.com/uutils/coreutils/pull/5320
* cp: fail when trying to copy to read only file on mac by @PGIII in https://github.com/uutils/coreutils/pull/5261
* cp: show no "skipped" msg with -vi/-vin by @cakebaker in https://github.com/uutils/coreutils/pull/5348

### cut
* cut-huge-range.sh: make cut fails on usize::MAX by @sylvestre in https://github.com/uutils/coreutils/pull/4988

### dd
* dd: fix GNU test 'dd/skip-seek-past-dev' by @bbara in https://github.com/uutils/coreutils/pull/4527

### df
* df: Fix overflow error on WSL. Default to 0 when the values are non-sense. by @howard0su in https://github.com/uutils/coreutils/pull/5381

### echo
* echo's doc doesn't show correctly by @sylvestre in https://github.com/uutils/coreutils/pull/5260
* echo: fix wrapping behavior of octal sequences by @tertsdiepraam in https://github.com/uutils/coreutils/pull/5218
* echo: don't output "\n" if "\c" is encountered by @cakebaker in https://github.com/uutils/coreutils/pull/5350

### expr
* expr: short-circuit evaluation for `|` by @Luv-Ray in https://github.com/uutils/coreutils/pull/5365
* expr: add some empty lines by @cakebaker in https://github.com/uutils/coreutils/pull/5376
* expr: short-circuit evaluation for `&` by @Luv-Ray in https://github.com/uutils/coreutils/pull/5402
* expr: test some invalid syntaxes by @cakebaker in https://github.com/uutils/coreutils/pull/5405
* expr: interpret numbers != 0 as true for | and & by @cakebaker in https://github.com/uutils/coreutils/pull/5324

### fmt
* fmt: use clap's value parser for goal & width by @cakebaker in https://github.com/uutils/coreutils/pull/5333

### head
* head: remove a clippy::cognitive_complexity by moving some content in a function by @sylvestre in https://github.com/uutils/coreutils/pull/5366
* head: add some empty lines by @cakebaker in https://github.com/uutils/coreutils/pull/5373

### ls
* ls.rs: changed variable name dfn to display_file_content responding to #5282 by @rojin254 in https://github.com/uutils/coreutils/pull/5283
* Support ls --dired by @sylvestre in https://github.com/uutils/coreutils/pull/5280
* ls -R1: add a test to replicate GNU's recursive.sh by @sylvestre in https://github.com/uutils/coreutils/pull/5342
* ls --dired - some minor cleanup by @sylvestre in https://github.com/uutils/coreutils/pull/5299
* ls: fix test which fails if /tmp uses tmpfs by @cakebaker in https://github.com/uutils/coreutils/pull/5301
* ls --dired: replace the previous "total: xx" padding method by @sylvestre in https://github.com/uutils/coreutils/pull/5305
* ls: move to `uutils-term-grid` by @miles170 in https://github.com/uutils/coreutils/pull/5391
* ls: use OnceCell from std instead of once_cell by @cakebaker in https://github.com/uutils/coreutils/pull/5268
* ls: Document a bit tests/ls/stat-dtype.sh by @sylvestre in https://github.com/uutils/coreutils/pull/5397
* ls -l: show an error when symlink not readable by @sylvestre in https://github.com/uutils/coreutils/pull/5278
* ls: fix panic when file removed too quickly by @sanpii in https://github.com/uutils/coreutils/pull/5372

### mkdir
* mkdir: make `mkdir` public and document it by @KAAtheWiseGit in https://github.com/uutils/coreutils/pull/5329

### mv
* mv: expose main functionality for nushell  by @PThorpe92 in https://github.com/uutils/coreutils/pull/5335
* ls: fix panic when file removed too quickly by @sanpii in https://github.com/uutils/coreutils/pull/5372
* mv: show no "skipped" msg with -vi/-vin by @cakebaker in https://github.com/uutils/coreutils/pull/5347
* mv: fix typo in test function name by @cakebaker in https://github.com/uutils/coreutils/pull/5351

### nl
* nl: make line number and --join-blank-lines work over multiple files by @cakebaker in https://github.com/uutils/coreutils/pull/5285
* nl: fix output order if stdin and files are mixed by @cakebaker in https://github.com/uutils/coreutils/pull/5306
* nl: implement -d/--section-delimiter by @cakebaker in https://github.com/uutils/coreutils/pull/5158
* nl: defer showing "line number overflow" error by @cakebaker in https://github.com/uutils/coreutils/pull/5340

### relpath
* relpath: remove by @boxdot in https://github.com/uutils/coreutils/pull/5355
* relpath: show error if no argument provided by @cakebaker in https://github.com/uutils/coreutils/pull/5302

### rm
* rm: make the utility public by @KAAtheWiseGit in https://github.com/uutils/coreutils/pull/5304

### seq
* seq: parse "infinity" and "-infinity" by @shinhs0506 in https://github.com/uutils/coreutils/pull/5124

### split
* split: implement remaining -n variants and pass GNU tests/split/fail.sh by @zhitkoff in https://github.com/uutils/coreutils/pull/5252
* split: catch broken pipe error for round robin strategy by @granquet in https://github.com/uutils/coreutils/pull/5338

### touch
* touch: make main public by @KAAtheWiseGit in https://github.com/uutils/coreutils/pull/5318

### tr
* tr: work with Windows newline (CRLF) by @muhajirdev in https://github.com/uutils/coreutils/pull/5344
* tr: rename to_u*_str to map_buffer in set1 and set2 by @cakebaker in https://github.com/uutils/coreutils/pull/5325
* tr: make the utility public by @KAAtheWiseGit in https://github.com/uutils/coreutils/pull/5322
* tr: support character class [:blank:] by @takanki in https://github.com/uutils/coreutils/pull/5317
* tr: Add test for character class [:blank:] by @cakebaker in https://github.com/uutils/coreutils/pull/5328

### wc
* wc: add --count-mbs option by @mbuf in https://github.com/uutils/coreutils/pull/5336

### whoami
* whoami: add support for -g/-m options by @muhajirdev in https://github.com/uutils/coreutils/pull/5352
* whoami: make main public by @KAAtheWiseGit in https://github.com/uutils/coreutils/pull/5321

### yes
* yes: make main public by @KAAtheWiseGit in https://github.com/uutils/coreutils/pull/5349










### Build system & CI
* ci: code-quality workflow doesn't fail on clippy errors by @miles170 in https://github.com/uutils/coreutils/pull/5399
* build-gnu.sh: fix for /usr/bin/timeout on MacOS by @zhitkoff in https://github.com/uutils/coreutils/pull/5194
* build-gnu.sh: fix formatting issues by @cakebaker in https://github.com/uutils/coreutils/pull/5248
* run-gnu-test.sh: show if we can't find the file by @sylvestre in https://github.com/uutils/coreutils/pull/5318
* run-gnu-test.sh: accept "run-root" as first param by @cakebaker in https://github.com/uutils/coreutils/pull/5323
* ci: remove committing from CheckScripts.yml by @cakebaker in https://github.com/uutils/coreutils/pull/5291
* ci: replace deprecated "command" with "fix" by @cakebaker in https://github.com/uutils/coreutils/pull/5271
* Binary sizes: handle when 0 (relpath removal) by @sylvestre in https://github.com/uutils/coreutils/pull/5369
* build-gnu.sh: fix formatting by @cakebaker in https://github.com/uutils/coreutils/pull/5290
* 0.0.21 => 0.0.22 by @sylvestre in https://github.com/uutils/coreutils/pull/5409
* Add NetBSD support to uucore. by @0323pin in https://github.com/uutils/coreutils/pull/5289

### Documentation
* DEVELOPMENT.md: improve doc on how to run some tests by @sylvestre in https://github.com/uutils/coreutils/pull/5393
* update of the release doc by @sylvestre in https://github.com/uutils/coreutils/pull/5410
* Introducing DEVELOPMENT.md by @zhitkoff in https://github.com/uutils/coreutils/pull/5209
* doc: recommend the rust-gdb helper by @sylvestre in https://github.com/uutils/coreutils/pull/5404
* Document how to run the pure Rust tests by @sylvestre in https://github.com/uutils/coreutils/pull/5279

### Security
* fuzz: move the common duplicated code into a function by @sylvestre in https://github.com/uutils/coreutils/pull/5332
* fuzzing: remove some duplicated code + clippy fixes by @sylvestre in https://github.com/uutils/coreutils/pull/5337
* Fuzz the expr command by @sylvestre in https://github.com/uutils/coreutils/pull/4642
* fuzz: store the corpus by @tommady in https://github.com/uutils/coreutils/pull/5363
* github action: move the fuzzing action into it own file/task by @sylvestre in https://github.com/uutils/coreutils/pull/5380

### Various improvements
* uucore: turn version_cmp into a feature by @cakebaker in https://github.com/uutils/coreutils/pull/5254
* clippy: suppress cognitive_complexity lint in some tests by @cakebaker in https://github.com/uutils/coreutils/pull/5401
* uucore: remove commented out import by @cakebaker in https://github.com/uutils/coreutils/pull/5384
* uucore: remove commented out enum FChar by @cakebaker in https://github.com/uutils/coreutils/pull/5385
* Make clippy::cognitive_complexity as an error by @sylvestre in https://github.com/uutils/coreutils/pull/5379
* clippy: suppress cognitive_complexity lint for two functions by @cakebaker in https://github.com/uutils/coreutils/pull/5374
* truncate clippy fix. by @devnexen in https://github.com/uutils/coreutils/pull/5259
* uu clippy fix proposal. by @devnexen in https://github.com/uutils/coreutils/pull/5264
* clippy: fix warnings in tests by @cakebaker in https://github.com/uutils/coreutils/pull/5362
* uucore: turn quoting_style into a feature by @cakebaker in https://github.com/uutils/coreutils/pull/5265
* fs: split get_file_display into its function & add test by @sylvestre in https://github.com/uutils/coreutils/pull/5394
* Replace list of digit by is_digit by @sylvestre in https://github.com/uutils/coreutils/pull/5336



### Dependencies
* Bump blake3 & add constant_time_eq to skip list in deny.toml by @cakebaker in https://github.com/uutils/coreutils/pull/5249
* chore(deps): update rust crate clap_complete to 4.4 by @renovate in https://github.com/uutils/coreutils/pull/5201
* chore(deps): update actions/checkout action to v4 by @renovate in https://github.com/uutils/coreutils/pull/5241
* chore(deps): update rust crate clap to 4.4 by @renovate in https://github.com/uutils/coreutils/pull/5200
* chore(deps): update rust crate half to 2.3 by @renovate in https://github.com/uutils/coreutils/pull/5005
* chore(deps): update rust crate regex to 1.10.1 by @renovate in https://github.com/uutils/coreutils/pull/5387
* chore(deps): update rust crate memmap2 to 0.9 by @renovate in https://github.com/uutils/coreutils/pull/5352
* chore(deps): update rust crate byteorder to 1.5.0 by @renovate in https://github.com/uutils/coreutils/pull/5361
* chore(deps): update rust crate md-5 to 0.10.6 by @renovate in https://github.com/uutils/coreutils/pull/5303
* chore(deps): update rust crate memmap2 to 0.8 by @renovate in https://github.com/uutils/coreutils/pull/5319
* fix(deps): update rust crate wild to 2.2 by @renovate in https://github.com/uutils/coreutils/pull/5317
* chore(deps): update rust crate exacl to 0.11.0 by @renovate in https://github.com/uutils/coreutils/pull/5322
* chore(deps): update rust crate sha2 to 0.10.8 by @renovate in https://github.com/uutils/coreutils/pull/5325
* chore(deps): update rust crate regex to 1.9.6 by @renovate in https://github.com/uutils/coreutils/pull/5339
* chore(deps): update rust crate num-traits to 0.2.17 by @renovate in https://github.com/uutils/coreutils/pull/5375
* Bump errno from 0.3.1 to 0.3.5 by @cakebaker in https://github.com/uutils/coreutils/pull/5382
* chore(deps): update rust crate bytecount to 0.6.4 by @renovate in https://github.com/uutils/coreutils/pull/5346
* chore(deps): update rust crate libc to 0.2.149 by @renovate in https://github.com/uutils/coreutils/pull/5370
* chore(deps): update mfinelli/setup-shfmt action to v3 by @renovate in https://github.com/uutils/coreutils/pull/5284
* chore(deps): update rust crate unicode-width to 0.1.11 by @renovate in https://github.com/uutils/coreutils/pull/5286
* chore(deps): update davidanson/markdownlint-cli2-action action to v13 by @renovate in https://github.com/uutils/coreutils/pull/5287
* chore(deps): update rust crate rayon to 1.8 by @renovate in https://github.com/uutils/coreutils/pull/5295
* chore(deps): update rust crate blake3 to 1.5.0 by @renovate in https://github.com/uutils/coreutils/pull/5296
* chore(deps): update rust crate winapi-util to 0.1.6 by @renovate in https://github.com/uutils/coreutils/pull/5292
* chore(deps): update rust crate redox_syscall to 0.4 by @renovate in https://github.com/uutils/coreutils/pull/5262
* chore(deps): update rust crate blake2b_simd to 1.0.2 by @renovate in https://github.com/uutils/coreutils/pull/5266
* chore(deps): update rust crate libc to 0.2.148 by @renovate in https://github.com/uutils/coreutils/pull/5272
* chore(deps): update codecov/codecov-action action to v4 by @renovate in https://github.com/uutils/coreutils/pull/5273
* Revert "chore(deps): update codecov/codecov-action action to v4" by @cakebaker in https://github.com/uutils/coreutils/pull/5277
* chore(deps): update rust crate chrono to ^0.4.31 by @renovate in https://github.com/uutils/coreutils/pull/5251
* chore(deps): update rust crate terminal_size to 0.3.0 by @renovate in https://github.com/uutils/coreutils/pull/5275
* fix(deps): update rust crate dns-lookup to 2.0.3 by @renovate in https://github.com/uutils/coreutils/pull/5281
* chore(deps): update rust crate sha1 to 0.10.6 by @renovate in https://github.com/uutils/coreutils/pull/5298
* chore(deps): update rust crate walkdir to 2.4 by @renovate in https://github.com/uutils/coreutils/pull/5250
* Bump bstr and regex by @cakebaker in https://github.com/uutils/coreutils/pull/5388
* deny.toml: add redox_syscall to skip list by @cakebaker in https://github.com/uutils/coreutils/pull/5263
* Bump nix & ctrlc, adapt stty to nix API changes by @cakebaker in https://github.com/uutils/coreutils/pull/5258
* deny.toml: remove constant_time_eq from skip list by @cakebaker in https://github.com/uutils/coreutils/pull/5267
* Bump chrono and fix deprecation warnings in touch by @cakebaker in https://github.com/uutils/coreutils/pull/5270
* deny.toml: add terminal_size to skip list by @cakebaker in https://github.com/uutils/coreutils/pull/5276
* Update parse_datetime to 0.5.0 by @u8sand in https://github.com/uutils/coreutils/pull/5313
* Use std::io::IsTerminal instead of is-terminal by @cakebaker in https://github.com/uutils/coreutils/pull/5240
* Remove is-terminal from Cargo.lock by @cakebaker in https://github.com/uutils/coreutils/pull/5247

## New Contributors
* @rojin254 made their first contribution in https://github.com/uutils/coreutils/pull/5283
* @0323pin made their first contribution in https://github.com/uutils/coreutils/pull/5289
* @KAAtheWiseGit made their first contribution in https://github.com/uutils/coreutils/pull/5304
* @Leviticoh made their first contribution in https://github.com/uutils/coreutils/pull/4228
* @u8sand made their first contribution in https://github.com/uutils/coreutils/pull/5313
* @PGIII made their first contribution in https://github.com/uutils/coreutils/pull/5261
* @boxdot made their first contribution in https://github.com/uutils/coreutils/pull/5355
* @PThorpe92 made their first contribution in https://github.com/uutils/coreutils/pull/5335
* @sanpii made their first contribution in https://github.com/uutils/coreutils/pull/5372
* @Luv-Ray made their first contribution in https://github.com/uutils/coreutils/pull/5365
* @howard0su made their first contribution in https://github.com/uutils/coreutils/pull/5381

**Full Changelog**: https://github.com/uutils/coreutils/compare/0.0.21...0.0.22
